// 5.     Mobile Phone ========================

// 5A.    White buttons -----------------------
//  $MRX$: 'Paint'
#declare Paint = material { // Paint
     texture {      
          pigment { color rgb <1.0, 1.0, 1.0> }      
          finish  {
               ambient 0.1         phong_size 51.336667
               specular 0.099033   roughness 0.0825
          }
     }
}

// 5B.    Gray Shell -------------------------
//  $MRX$: 'DGray'
#declare DGray = material {   
     texture {      
          pigment { color rgb <0.219, 0.220, 0.220> }      
          normal  { wrinkles , 0.513    }      
          finish  {
               ambient 0.2028      diffuse 0.400933
               brilliance 0.44     phong 0.051867
               phong_size 88.9     specular 0.108467
               roughness 0.801     crand 0.287733
          }
     }
}

// 5D.    Glossy Black Antenna ----------------
//  $MRX$: 'Shiny_Black'

#declare Shiny_Black = material {   
     texture {      
          pigment { color rgb <0, 0, 0> }      
          finish  { ambient 0.1    phong 0.708    phong_size 41.963   reflection 0.099    crand 0.0896 }
     }
}



// =========================================================================================
//   And now for the phone itself
//
// =========================================================================================

#declare Earpiece = union {
     cylinder { <0,0,1>, <0,0,0>, 1   scale <0.45, 0.14, 0.4>    rotate 120*z   translate  <6.15, 0.45, 1.65>   }
     cylinder { <0,0,1>, <0,0,0>, 1   scale <0.45, 0.14, 0.4>    translate  <6.8, 0, 1.71> }
     cylinder { <0,0,1>, <0,0,0>, 1   scale <0.45, 0.14, 0.4>    rotate -120*z  translate  <6.15, -0.45, 1.71>  }
     //material { DGray }  
}


#declare Button = union {
     cylinder { <0, 0, 0.5>, <0, 0, 0>, 0.25       scale < 1, 2, 1 >    translate < 2, 1.5, 1.5 > }
     cylinder { <0, 0, 0.5>, <0, 0, 0>, 0.25       scale < 1, 2, 1 >    translate < 1.75, 1.5, 1.5 > }
     box      { <1.75, 1, 1.5>, <2, 2, 2>  }
     pigment { color Gray90} //material { Paint }
}

#declare Button3 = object {
     object { Button	scale <1.0, 1.6, 1.0>		translate  <-1.5, -1.2, 0.0>  }
     pigment { color Gray90} //material { Paint }
}

#declare Row01 = union {
     object { Button     }
     object { Button	translate  -1.5*y  }
     object { Button     translate  -3.0*y  }
}
#declare Row02 = union {
     //object { Row01    pigment { color Gray90}  translate  -2.75*x }
     object { Button      translate  -2.75*x }
     object { Button	 translate  < -2.75, -1.5, 0>  }
     object { Button      translate  < -2.75, -3.0, 0>  }
}

#declare Buttons = union {
     object { Row01 }
     object { Row02 }
     object { Row02	translate  -1.2*x  }
     object { Row02	translate  -2.4*x  }
     object { Row02	translate  -3.6*x  }
     object { Button3    pigment { color Green } }
     object { Button3	pigment { color Red } translate  -2.4*y  }
     translate  -0.95*x
}



#declare Body01 = merge {
     sphere { <0.45, 0.4500, 0.4500>, 0.05 }
     sphere { <0.45, -0.4500, 0.4500>, 0.05 }
     sphere { <-0.45, -0.4500, 0.4500>, 0.05 }
     sphere { <-0.45, 0.4500, 0.4500>, 0.05 }
     sphere { <0.45, 0.4500, -0.4500>, 0.05 }
     sphere { <0.45, -0.4500, -0.4500>, 0.05 }
     sphere { <-0.45, -0.4500, -0.4500>, 0.05 }
     sphere { <-0.45, 0.4500, -0.4500>, 0.05 }

     cylinder { <0.45, 0.4500, 0.4500>, <-0.4500, 0.4500, 0.4500>, 0.05 }
     cylinder { <0.45, -0.4500, 0.4500>, <-0.4500, -0.4500, 0.4500>, 0.05 }
     cylinder { <0.45, -0.4500, -0.4500>, <-0.4500, -0.4500, -0.4500>, 0.05 }
     cylinder { <0.45, 0.4500, -0.4500>, <-0.4500, 0.4500, -0.4500>, 0.05 }
     cylinder { <0.45, 0.4500, -0.4500>, <0.4500, 0.4500, 0.4500>, 0.05 }
     cylinder { <0.45, -0.4500, -0.4500>, <0.4500, -0.4500, 0.4500>, 0.05 }
     cylinder { <-0.45, -0.4500, -0.4500>, <-0.4500, -0.4500, 0.4500>, 0.05 }
     cylinder { <-0.45, 0.4500, -0.4500>, <-0.4500, 0.4500, 0.4500>, 0.05 }
     cylinder { <0.45, 0.4500, 0.4500>, <0.4500, -0.4500, 0.4500>, 0.05 }
     cylinder { <0.45, 0.4500, -0.4500>, <0.4500, -0.4500, -0.4500>, 0.05 }
     cylinder { <-0.45, 0.4500, -0.4500>, <-0.4500, -0.4500, -0.4500>, 0.05 }
     cylinder { <-0.45, 0.4500, 0.4500>, <-0.4500, -0.4500, 0.4500>, 0.05 }

     box { < -7.2, -2.7, -1>   <7.2, 2.7, 1>      scale <0.0625, 0.1666, 0.5> }
     box { < -7.2, -3.0, -0.9> <7.2, 3.0, 0.9>    scale <0.0625, 0.1666, 0.5> }
     box { < -8,   -2.7, -0.9> <8,   2.7, 0.9>    scale <0.0625, 0.1666, 0.5> }

     scale <16.0, 6.0, 2.0>
     translate  1.0*z
     material { DGray  }
}



#declare Body02 = difference {
     union {
          object { Body01 }
          // Phone_Label
          text { ttf "C:\WINDOWS\Fonts\Arial.ttf",     "ERICSDAUGHTER",    0.25,  // Depth
               <0.0,     0.0, 0.0> // Offset
               scale <0.44, 0.5, 1.0>
               rotate -90.0*z
               translate  <3.6, 1.9, 1.761 >
          }
          texture {pigment { color White } }  //material { Paint }
     }     

     object { Earpiece }
     cylinder { <0,0,1>, <0,0,0>, 1     scale <0.45, 0.14, 0.4>  translate  <-7.5, -.5, 1.71> }
     cylinder { <0,0,1>, <0,0,0>, 1     scale <0.45, 0.14, 0.4>  translate  <-7.5, 0, 1.71> }
     cylinder { <0,0,1>, <0,0,0>, 1     scale <0.45, 0.14, 0.4>  translate  <-7.5, .5, 1.71> }
     box { <-6.75, -2.3, 1.75>, <3.5, 2.3, 2.05>		 }
     sphere { <0, 0, 0>, 1              scale <1.7, 2.6, 0.15>   translate < 6, 0, 2>  } 
     cylinder { <0,0,2>, <0,0,1.8>, 1     scale <1.7, 2.6, 1>  translate  < 6, 0, 0> }
     material { DGray  }
}

#declare Antenna = union {
     cylinder { <0,0,1>, <0,0,0>, 1 	scale <0.4, 0.4, 3.5>		rotate 90.0*y
          translate  <8.0, 1.75, 1.0>		material { DGray }
     }
     cone { <0,0,0>, 0.45, <0,0,1>, 0.42	rotate 90.0*y		translate  <11.4, 1.75, 1.0>
          material { Shiny_Black  }
     }
}

#declare Display = object {
     box {  <-2.2, -1.1, -0.2>, <2.2, 1.1, 0.2>	
          texture { pigment { image_map { gif "911.gif" }   scale <4.35, 2.15, 1>    translate <-2.2, 1.1, 0>  } }
          rotate -90*z
          rotate -3.0*y		
          translate  <2.29, 0.0, 1.75>
     }
}

#declare Keypad = union {
     object { Buttons }
  text {   // K_Label01
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "1    2    3",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.91, 0.65, 1.0>
    rotate -90.0*z
    translate  <-2.05, 1.7, 1.91>
    material { Shiny_Black }
  }
  text {   // K_Label02
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "4    5    6",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.91, 0.65, 1.0>
    rotate -90.0*z
    translate  <-3.3, 1.75, 1.91>
    material { Shiny_Black }
  }
  text {   // K_Label03
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "7    8    9",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.91, 0.65, 1.0>
    rotate -90.0*z
    translate  <-4.4, 1.73, 1.91>
    material { Shiny_Black }
  }

  text {   // K_Label04
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "*    0    #",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.91, 0.75, 1.0>
    rotate -90.0*z
    translate  <-5.7, 1.7, 1.91>
    material { Shiny_Black }
  }
  translate  -0.5*x
}


#declare Phone = union {
     object { Body02 }
     object { Antenna }
     object { Display }
     object { Keypad }
}
