//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 18 materials and 1969 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 10/11/1999    (11.10.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.161,0.318,0.361> }

fog {
  fog_type 2    // Ground Fog
  distance     10.0
  color <0.113725,0.752941,0.631373,-0.207843,0.666667>
  turbulence   <1.0,1.0,1.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.5
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      1.0
}

camera {  //  Camera StdCam
  location  <     38.317,       9.060,      13.853>
  direction <        0.0,         0.0,      1.1267> // Aperture is 0.84 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      4.429,       1.032,       8.166>
}

//
// *******  L I G H T S *******
//

light_source {   // Light003
  <5.248, 4.894, 17.874>
  color rgb <1.000, 0.743, 0.514>*1.3000
  fade_distance  8.0
  fade_power 1.0
  media_interaction off
}

light_source {   // Light002
  <38.731, 34.039, 7.925>
  color rgb <1.000, 1.000, 1.000>*0.5713
  fade_distance  20.0
  fade_power 1.0
  media_interaction off
}

light_source {   // Light001
  <-100.709, 29.967, 108.922>
  color rgb <1.000, 1.000, 0.814>*2.9997
  fade_distance  20.0
  fade_power 1.0
  media_interaction off
}


//
// ********  MATERIALS  *******
//

#include "alien-scene.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#declare fireball = union {
  sphere { // Sphere690
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate 107.55394*z
    translate  <3.156064, -9.878329, 10.174003>
  }
  sphere { // Sphere689
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate 107.55394*z
    translate  <3.156064, -9.983593, 14.8056>
  }
  sphere { // Sphere688
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate 107.55394*z
    translate  <3.156064, -9.773066, 12.805592>
  }
  sphere { // Sphere687
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate 107.55394*z
    translate  <5.996043, -10.733741, 10.775715>
  }
  sphere { // Sphere686
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate 107.55394*z
    translate  <5.996043, -8.39031, 10.489794>
  }
  sphere { // Sphere685
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate 107.55394*z
    translate  <5.996043, -9.955844, 14.302441>
  }
  sphere { // Sphere684
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate 107.55394*z
    translate  <5.996043, -8.285047, 15.226654>
  }
  sphere { // Sphere683
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate <0.0, -30.0, 107.55394>
    translate  <4.297442, -8.058529, 12.805592>
  }
  sphere { // Sphere632
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate 107.55394*z
    translate  <4.487701, -12.43634, 12.805592>
  }
  sphere { // Sphere631
    <0,0,0>,1
    material {
      explosion
    }
    hollow
    scale 2.0
    rotate 107.55394*z
    translate  <6.111789, -11.952892, 13.883554>
  }
  scale <1.484232, 1.8, 1.484232>
  rotate -3.01933*z
  translate  <4.966163, 8.446165, -6.440739>
}
#declare CSG009 = union {
  sphere { // Sphere633
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <1.219412, 1.0, 1.337685>
    translate  <0.0, 2.39378, 7.18134>
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMroughM2
    }
    scale <-1.329118, -1.165801, -3.963728>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 2.39378, 7.067351>
  }
}
#declare CSG010 = difference {
  object { CSG009 }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleMvM1
    }
    scale <1.723546, 1.5, 1.601017>
    rotate -39.117523*y
    translate  <-0.219412, 2.39378, 10.188856>
  }
  scale <1.0, 1.2, 1.0>
  translate  <0.0, -0.341969, -0.11399>
}
#declare upperMarm2 = union {
  object { CSG010 }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleM1
    }
    scale 1.3
    rotate <0.179018, -39.228443, 0.0>
    translate  <-0.0, 2.39378, 10.080104>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.424203, -2.322462, -10.588848>
  rotate <-10.068949, -11.133198, 69.406441>
  translate  <-1.091244, 1.428967, 11.065864>
}
#declare lowerMfinger4 = union {
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere635
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere636
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-14.692499, 10.343202, -52.455254>
  translate  <-3.484187, 0.289364, 0.347117>
}
#declare upperMfinger4 = union {
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere637
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  rotate <-13.009263, 12.882142, -11.755546>
  translate  -1.893654*x
}
#declare thumb = union {
  object { lowerMfinger4 }
  object { upperMfinger4 }
  sphere { // Sphere638
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <1.898587, 0.786085, 0.547396>
    rotate <4.144116, -2.029754, 18.704447>
    translate  <-0.352407, 0.510747, 0.002617>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.046266, -0.0, -0.057141>
  scale <0.8, 1.1, 1.1>
  rotate <-0.0, -46.894882, 0.0>
  translate  <0.761232, -1.615988, -0.198566>
}
#declare lowerMfinger3 = union {
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere639
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere640
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-0.0, -141.477707, 0.0>
  translate  <-3.45667, 0.0, 0.0>
}
#declare upperMfinger3 = union {
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere641
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  translate  -1.893654*x
}
#declare finger24 = union {
  object { lowerMfinger3 }
  object { upperMfinger3 }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  scale 0.9
  rotate -62.291557*y
  translate  <-1.354992, 1.46908, 0.0>
}
#declare lowerMfinger2 = union {
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere642
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere643
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-0.0, -144.530014, 0.0>
  translate  <-3.45667, 0.0, 0.0>
}
#declare upperMfinger2 = union {
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere644
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  translate  -1.893654*x
}
#declare finger25 = union {
  object { lowerMfinger2 }
  object { upperMfinger2 }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  scale 1.1
  rotate <-0.0, -66.054169, 0.0>
  translate  <-1.795716, 0.538663, 0.0>
}
#declare lowerMfinger1 = union {
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere645
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere646
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-0.0, -142.746628, 0.0>
  translate  <-3.45667, 0.0, 0.0>
}
#declare upperMfinger1 = union {
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere647
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  translate  -1.893654*x
}
#declare finger26 = union {
  object { lowerMfinger1 }
  object { upperMfinger1 }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  scale 1.1
  rotate -64.139069*y
  translate  <-1.403961, -1.420111, 0.0>
}
#declare palm = union {
  sphere { // Sphere648
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <1.130864, 2.125876, 0.584807>
    translate  <-0.920721, -0.048969, 0.0>
  }
  sphere { // Sphere649
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <2.328115, 1.986643, 0.688605>
    translate  <0.244847, -0.097939, 0.0>
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.008424, -0.0, -0.885899>
    material {
      trooperMskinMsmoothM0
    }
    scale <0.8, 1.332529, 3.059135>
    rotate <180.0, -71.933998, 180.0>
    translate  <1.139546, 0.0, 0.085273>
  }
  material {
    trooperMskinMrippleMvM1
  }
}
#declare lowerMfinger = union {
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere650
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere651
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-0.0, -139.145752, 0.0>
  translate  <-3.45667, 0.0, 0.0>
}
#declare upperMfinger = union {
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere652
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  translate  -1.893654*x
}
#declare finger27 = union {
  object { lowerMfinger }
  object { upperMfinger }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  scale 1.1
  rotate -67.211563*y
  translate  <-1.893654, -0.489693, 0.0>
}
#declare trooperMhandMright = union {
  object { thumb }
  object { finger24 }
  object { finger25 }
  object { finger26 }
  object { palm }
  object { finger27 }
  rotate <0.0, 20.375107, 0.0>
  translate  <-2.769396, -0.024485, 0.34947>
  scale 0.714286
  rotate <161.988342, -87.9235, 19.107847>
  translate  <-0.18107, 2.105984, 2.852996>
}
#declare lowerMarm2 = union {
  cone { // Cone292
    <0,0,0>, 0.8, <0,0,1>, 1.0
    material {
      trooperMskinMroughM2
    }
    scale <1.3, 1.3, 3.41351>
    translate  <-0.227652, 2.158882, 2.391724>
  }
  sphere { // Sphere634
    <0,0,0>,1
    material {
      trooperMskinMrippleMvM1
    }
    scale <1.317519, 0.829937, 1.78936>
    translate  <0.0187, 1.142043, 6.835088>
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleM2
    }
    scale <1.243514, 1.229053, 1.0>
    translate  <0.0, 2.182199, 6.10945>
  }
  object { trooperMhandMright }
  rotate <0.0, -0.0, -0.0>
  translate  <0.0, -2.051811, -6.793207>
  rotate <-93.160011, -169.102753, 225.912186>
  translate  <-0.343873, 2.22846, 7.070982>
}
#declare armMright = union {
  object { upperMarm2 }
  object { lowerMarm2 }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.476019, -2.43175, -10.172349>
  scale 0.7
  rotate <-150.148834, -203.407333, -60.036095>
  translate  <-3.966216, 2.147862, 15.579586>
}
#declare CSG012 = difference {
  sphere { // Sphere654
    <0,0,0>,1
    material {
      trooperMskinMrippleMvM1
    }
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMblack
    }
    scale <0.5, 1.0, 1.0>
    translate  <0.61012, 0.0, 0.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMblack
    }
    scale <0.943245, 1.0, 0.475013>
    translate  <-0.070944, 0.0, -0.681064>
  }
  scale <-1.347273, -2.2, -2.464775>
  rotate <-13.395788, -123.128632, 66.863464>
  translate  <1.446018, 1.183552, 14.857966>
}
#declare CSG011 = difference {
  sphere { // Sphere655
    <0,0,0>,1
    material {
      trooperMskinMrippleMvM1
    }
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMblack
    }
    scale <0.5, 1.0, 1.0>
    translate  <0.61012, 0.0, 0.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMblack
    }
    scale <0.943245, 1.0, 0.475013>
    translate  <-0.070944, 0.0, -0.681064>
  }
  scale <1.347273, 2.2, 2.464775>
  rotate 42.52026*y
  translate  <-2.748598, 2.828897, 14.581447>
}
#declare rightMarmor = union {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
    translate  4.8*z
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
    translate  2.4*z
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
  }
  scale <1.500643, 1.0, 0.833119>
  rotate 10.0*z
  translate  3.5*x
}
#declare leftMarmor = union {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
    translate  4.8*z
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
    translate  2.4*z
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
  }
  scale <1.500643, 1.0, 0.833119>
  rotate -10.0*z
}
#declare frontMarmor = union {
  object { rightMarmor }
  object { leftMarmor }
  scale <0.532669, 1.130416, 0.431875>
  rotate <0.549072, -0.0, -0.0>
  translate  <-0.921916, 1.978157, 12.946023>
}
#declare torso3 = union {
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleMvM1
    }
    scale <3.0, 1.5, 1.0>
    rotate -90.0*y
    translate  <0.509418, 2.780784, 11.825168>
  }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleMvM1
    }
    scale <2.207402, 1.697715, 1.552071>
    translate  <0.022801, 2.929241, 10.897414>
  }
  cone { // Cone293
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      trooperMskinMroughM2
    }
    scale <2.859634, 2.061142, 5.728023>
    translate  <0.015728, 2.972758, 9.725696>
  }
  sphere { // Sphere653
    <0,0,0>,1
    material {
      trooperMskinMroughM2
    }
    scale <2.859634, 2.287631, 0.744974>
    translate  <0.01211, 2.995047, 15.471672>
  }
  object { CSG012 }
  object { CSG011 }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMrippleMvM1
    }
    scale <0.62742, 1.1862, 1.016553>
    rotate <90.0, -90.900246, -90.0>
    translate  <0.037482, 1.683974, 12.077871>
  }
  object { frontMarmor }
  scale <1.349169, 0.786395, 1.342329>
  translate  <-0.02122, 0.249206, -3.508875>
}
#declare CSG013 = union {
  sphere { // Sphere656
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <1.219412, 1.0, 1.337685>
    translate  <0.0, 2.39378, 7.18134>
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMroughM2
    }
    scale <-1.329118, -1.165801, -3.963728>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 2.39378, 7.067351>
  }
}
#declare CSG014 = difference {
  object { CSG013 }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleMvM1
    }
    scale <1.723546, 1.5, 1.601017>
    rotate -39.117523*y
    translate  <-0.219412, 2.39378, 10.188856>
  }
  scale <1.0, 1.2, 1.0>
  translate  <0.0, -0.341969, -0.11399>
}
#declare upperMarm3 = union {
  object { CSG014 }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleM1
    }
    scale 1.3
    rotate <114.759911, -109.332764, -142.706696>
    translate  <-0.0, 2.39378, 10.080104>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.424203, -2.322462, -10.588848>
  rotate <-1.253859, 3.117615, -152.468597>
  translate  <-1.091244, 1.428967, 11.065864>
}
#declare lowerMfinger5 = union {
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere658
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere659
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-14.692499, 10.343202, -52.455254>
  translate  <-3.484187, 0.289364, 0.347117>
}
#declare upperMfinger5 = union {
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere660
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  rotate <-13.009263, 12.882142, -11.755546>
  translate  -1.893654*x
}
#declare thumb1 = union {
  object { lowerMfinger5 }
  object { upperMfinger5 }
  sphere { // Sphere661
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <1.898587, 0.786085, 0.547396>
    rotate <4.144116, -2.029754, 18.704447>
    translate  <-0.352407, 0.510747, 0.002617>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.046266, -0.0, -0.057141>
  scale <0.8, 1.1, 1.1>
  rotate <-0.0, -46.894882, 0.0>
  translate  <0.761232, -1.615988, -0.198566>
}
#declare lowerMfinger6 = union {
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere662
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere663
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-0.0, -141.477707, 0.0>
  translate  <-3.45667, 0.0, 0.0>
}
#declare upperMfinger6 = union {
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere664
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  translate  -1.893654*x
}
#declare finger28 = union {
  object { lowerMfinger6 }
  object { upperMfinger6 }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  scale 0.9
  rotate -62.291557*y
  translate  <-1.354992, 1.46908, 0.0>
}
#declare lowerMfinger7 = union {
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere665
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere666
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-0.0, -144.530014, 0.0>
  translate  <-3.45667, 0.0, 0.0>
}
#declare upperMfinger7 = union {
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere667
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  translate  -1.893654*x
}
#declare finger29 = union {
  object { lowerMfinger7 }
  object { upperMfinger7 }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  scale 1.1
  rotate <-0.0, -66.054169, 0.0>
  translate  <-1.795716, 0.538663, 0.0>
}
#declare lowerMfinger8 = union {
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere668
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere669
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-0.0, -142.746628, 0.0>
  translate  <-3.45667, 0.0, 0.0>
}
#declare upperMfinger8 = union {
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere670
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  translate  -1.893654*x
}
#declare finger30 = union {
  object { lowerMfinger8 }
  object { upperMfinger8 }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  scale 1.1
  rotate -64.139069*y
  translate  <-1.403961, -1.420111, 0.0>
}
#declare palm1 = union {
  sphere { // Sphere671
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <1.130864, 2.125876, 0.584807>
    translate  <-0.920721, -0.048969, 0.0>
  }
  sphere { // Sphere672
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <2.328115, 1.986643, 0.688605>
    translate  <0.244847, -0.097939, 0.0>
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.008424, -0.0, -0.885899>
    material {
      trooperMskinMsmoothM0
    }
    scale <0.8, 1.2, 3.059135>
    rotate <180.0, -71.933998, 180.0>
    translate  <1.139546, 0.0, 0.085273>
  }
  material {
    trooperMskinMrippleMvM1
  }
}
#declare lowerMfinger9 = union {
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere673
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  sphere { // Sphere674
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <0.656071, 0.388889, 0.388889>
    translate  <-3.540165, -0.0, 0.0>
  }
  rotate 0.0*z
  translate  <1.870276, -0.0, 0.0>
  scale 0.9
  rotate <-0.0, -139.145752, 0.0>
  translate  <-3.45667, 0.0, 0.0>
}
#declare upperMfinger9 = union {
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMsmoothM0
    }
    scale <0.364236, 0.364236, 1.35615>
    rotate -90.0*y
    translate  -2.098971*x
  }
  sphere { // Sphere675
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale 0.470196
    translate  -1.907293*x
  }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  translate  -1.893654*x
}
#declare finger31 = union {
  object { lowerMfinger9 }
  object { upperMfinger9 }
  rotate -0.0*z
  translate  <1.893654, -0.0, 0.0>
  scale 1.1
  rotate -67.211563*y
  translate  <-1.893654, -0.489693, 0.0>
}
#declare trooperMhandMleft = union {
  object { thumb1 }
  object { finger28 }
  object { finger29 }
  object { finger30 }
  object { palm1 }
  object { finger31 }
  rotate <0.0, 20.375107, 0.0>
  translate  <-2.769396, -0.024485, 0.34947>
  scale 0.714286
  rotate <114.981384, -99.968102, 61.855602>
  translate  <0.161575, 2.154681, 2.490582>
}
#declare lowerMarm3 = union {
  cone { // Cone294
    <0,0,0>, 0.8, <0,0,1>, 1.0
    material {
      trooperMskinMrippleMvM1
    }
    scale <1.3, 1.3, 3.41351>
    translate  <0.134661, 2.155777, 2.442214>
  }
  sphere { // Sphere657
    <0,0,0>,1
    material {
      trooperMskinMrippleMvM1
    }
    scale <1.317519, 0.829937, 1.78936>
    translate  <0.0187, 1.142043, 6.835088>
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleM2
    }
    scale <1.243514, 1.229053, 1.0>
    translate  <0.0, 2.182199, 6.10945>
  }
  object { trooperMhandMleft }
  rotate <0.0, -0.0, -0.0>
  translate  <0.0, -2.051811, -6.793207>
  rotate <3.314691, 28.447624, -126.645996>
  translate  <-1.376442, 1.362331, 6.835763>
}
#declare armMleft = union {
  object { upperMarm3 }
  object { lowerMarm3 }
  rotate <-67.943314, 36.595665, -25.592804>
  translate  <-5.385072, -9.696856, -2.808739>
  scale -0.7
  rotate <-84.261734, -234.119797, 71.041336>
  translate  <3.073529, 2.448314, 16.002495>
}
#declare trooperMhead = union {
  cone { // Cone295
    <0,0,0>, 0.8, <0,0,1>, 1.0
    material {
      trooperMskinMroughM2
    }
    scale 1.180304
    rotate 180.0*x
  }
  sphere { // Sphere676
    <0,0,0>,1
    material {
      trooperMskinMroughM2
    }
  }
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleM2
    }
    scale <1.200285, 0.997522, 0.769231>
    rotate <90.0, -55.165329, -90.0>
    translate  <0.373842, 0.102737, 0.023591>
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMblack
    }
    scale <0.850826, 0.781889, 0.362887>
    rotate -7.287615*x
    translate  <0.01114, -0.396083, -0.536753>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMrippleMvM1
    }
    scale <0.355283, 0.435607, 0.522314>
    rotate -8.805573*x
    translate  <0.01114, -0.711746, -0.885735>
  }
  rotate 0.0*x
  translate  <-0.0, 0.057967, 1.00874>
  scale 1.3
  rotate <-8.026908, -5.651658, -34.928246>
  translate  <-0.014482, 2.618978, 18.151783>
}
#declare trooperMupperMbody = union {
  object { armMright }
  object { torso3 }
  object { armMleft }
  object { trooperMhead }
  rotate 0.0*x
  translate  <0.091174, -2.608102, -10.26701>
  rotate 9.806281*x
  translate  <-0.091174, 2.608102, 10.26701>
}
#declare CSG005 = union {
  sphere { // Sphere677
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <1.219412, 1.0, 1.337685>
    translate  <0.0, 2.39378, 7.18134>
  }
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMroughM2
    }
    scale <-1.329118, -1.165801, -3.963728>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 2.39378, 7.067351>
  }
}
#declare CSG006 = difference {
  object { CSG005 }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleMvM1
    }
    scale <1.723546, 1.5, 1.601017>
    rotate -39.117523*y
    translate  <-0.219412, 2.39378, 10.188856>
  }
  scale <1.0, 1.2, 1.0>
  translate  <0.0, -0.341969, -0.11399>
}
#declare upperMleg1 = union {
  object { CSG006 }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleMvM1
    }
    scale 1.3
    rotate <0.179018, -39.228443, 0.0>
    translate  <-0.0, 2.39378, 10.080104>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
    scale <0.356861, 0.490047, 1.644718>
    rotate <-0.537035, 2.412332, 179.132233>
    translate  <-0.066828, 1.388982, 8.901355>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.424203, -2.322462, -10.588848>
  rotate <-7.714905, -16.785934, 1.85054>
  translate  <-1.426178, 2.39378, 10.098903>
}
#declare CSG007 = union {
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <0.0, 2.06821, -0.225623>
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -77.90052*x
  }
  sphere { // Sphere679
    <0,0,0>,1
  }
  material {
    trooperMskinMroughM2
  }
}
#declare CSG008 = difference {
  object { CSG007 }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMblack
    }
    scale <1.230817, 2.316134, 0.571836>
    translate  <0.023082, 1.203322, -0.728995>
  }
}
#declare shoe1 = union {
  object { CSG008 }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleM2
    }
    translate  <0.0, 2.06821, 1.729776>
  }
  rotate <0.0, -0.0, 0.0>
  translate  <0.109706, -2.051811, -1.843585>
  rotate <8.880816, -0.00755, 0.097279>
  translate  <-0.109706, 2.008534, 1.920082>
}
#declare lowerMleg1 = union {
  cone { // Cone296
    <0,0,0>, 0.8, <0,0,1>, 1.0
    material {
      trooperMskinMroughM2
    }
    scale <1.5, 1.5, 3.938666>
    rotate 180.0*x
    translate  <0.0, 2.155022, 6.269154>
  }
  sphere { // Sphere678
    <0,0,0>,1
    material {
      trooperMskinMrippleMvM1
    }
    scale <1.317519, 0.829937, 1.78936>
    translate  <0.0187, 1.142043, 6.835088>
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleM2
    }
    scale <1.243514, 1.229053, 1.0>
    translate  <0.0, 2.182199, 6.10945>
  }
  object { shoe1 }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
    scale <-0.356861, -0.490047, -1.644718>
    rotate <177.015808, 0.196768, -0.030772>
    translate  <-0.015037, 1.035803, 4.250688>
  }
  rotate <0.0, -0.0, -0.0>
  translate  <0.0, -2.051811, -6.793207>
  rotate <38.860104, -3.57348, 0.39634>
  translate  <0.0, 2.051811, 6.793207>
}
#declare legMright = union {
  object { upperMleg1 }
  object { lowerMleg1 }
  rotate <0.0, 0.0, -0.0>
  translate  <1.486243, -2.380011, -10.164786>
  scale -1.0
  rotate <-46.610382, -177.205719, -177.047806>
  translate  <-1.637015, 2.688926, 10.132606>
}
#declare CSG015 = union {
  sphere { // Sphere680
    <0,0,0>,1
    material {
      trooperMskinMsmoothM0
    }
    scale <1.219412, 1.0, 1.337685>
    translate  <0.0, 2.39378, 7.18134>
  }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMroughM2
    }
    scale <-1.329118, -1.165801, -3.963728>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 2.39378, 7.067351>
  }
}
#declare CSG016 = difference {
  object { CSG015 }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleMvM1
    }
    scale <1.723546, 1.5, 1.601017>
    rotate -39.117523*y
    translate  <-0.219412, 2.39378, 10.188856>
  }
  scale <1.0, 1.2, 1.0>
  translate  <0.0, -0.341969, -0.11399>
}
#declare upperMleg2 = union {
  object { CSG016 }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleMvM1
    }
    scale 1.3
    rotate <0.179018, -39.228443, 0.0>
    translate  <-0.0, 2.39378, 10.080104>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
    scale <0.356861, 0.490047, 1.644718>
    rotate <-0.537035, 2.412332, 179.132233>
    translate  <-0.066828, 1.388982, 8.901355>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.424203, -2.322462, -10.588848>
  rotate <-7.714905, -16.785934, 1.85054>
  translate  <-1.426178, 2.39378, 10.098903>
}
#declare CSG017 = union {
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <0.0, 2.06821, -0.225623>
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -77.90052*x
  }
  sphere { // Sphere682
    <0,0,0>,1
  }
  material {
    trooperMskinMroughM2
  }
}
#declare CSG018 = difference {
  object { CSG017 }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMblack
    }
    scale <1.230817, 2.316134, 0.571836>
    translate  <0.023082, 1.203322, -0.728995>
  }
}
#declare shoe2 = union {
  object { CSG018 }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleM2
    }
    translate  <0.0, 2.06821, 1.729776>
  }
  rotate <0.0, -0.0, 0.0>
  translate  <0.109706, -2.051811, -1.843585>
  rotate <-23.330612, 0.015993, 0.077465>
  translate  <-0.109706, 2.008534, 1.920082>
}
#declare lowerMleg2 = union {
  cone { // Cone297
    <0,0,0>, 0.8, <0,0,1>, 1.0
    material {
      trooperMskinMroughM2
    }
    scale <1.5, 1.5, 3.938666>
    rotate 180.0*x
    translate  <0.0, 2.155022, 6.269154>
  }
  sphere { // Sphere681
    <0,0,0>,1
    material {
      trooperMskinMrippleMvM1
    }
    scale <1.317519, 0.829937, 1.78936>
    translate  <0.0187, 1.142043, 6.835088>
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMrippleM2
    }
    scale <1.243514, 1.229053, 1.0>
    translate  <0.0, 2.182199, 6.10945>
  }
  object { shoe2 }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      trooperMskinMroughM2
    }
    scale <-0.356861, -0.490047, -1.644718>
    rotate <177.015808, 0.196768, -0.030772>
    translate  <-0.015037, 1.035803, 4.250688>
  }
  rotate <0.0, -0.0, -0.0>
  translate  <0.0, -2.051811, -6.793207>
  rotate <12.173069, -3.429545, -0.041311>
  translate  <0.0, 2.051811, 6.793207>
}
#declare legMleft = union {
  object { upperMleg2 }
  object { lowerMleg2 }
  rotate <0.0, 0.0, -0.0>
  translate  <1.486243, -2.380011, -10.164786>
  rotate <34.117207, 2.681895, 1.815683>
  translate  <1.656277, 2.688926, 10.19901>
}
#declare weapon = union {
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    material {
      weaponMskin
    }
    scale <0.5, 0.5, 12.0>
    translate  <0.0, -1.141213, -0.489091>
  }
  torus { // Torus298
    1.5, 0.5  rotate -x*90
    material {
      weaponMskin
    }
    scale <0.7, 0.7, 1.0>
    translate  9.5*z
  }
  torus { // Torus299
    1.5, 0.5  rotate -x*90
    material {
      weaponMskin
    }
    scale <0.9, 0.9, 1.0>
    translate  8.0*z
  }
  torus { // Torus300
    1.5, 0.5  rotate -x*90
    material {
      weaponMskin
    }
    translate  6.5*z
  }
  torus { // Torus301
    1.5, 0.5  rotate -x*90
    material {
      weaponMskin
    }
    translate  5.0*z
  }
  torus { // Torus302
    1.5, 0.5  rotate -x*90
    material {
      weaponMskin
    }
    translate  3.5*z
  }
  torus { // Torus303
    1.5, 0.5  rotate -x*90
    material {
      weaponMskin
    }
    translate  2.0*z
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    material {
      weaponMskin
    }
    scale <2.0, 2.0, 5.0>
    translate  -5.0*z
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    material {
      trooperMskinMblack
    }
    scale <1.0, 1.0, 12.0>
  }
  scale 0.5
  rotate <-87.733055, 3.894021, 138.398697>
  translate  <-3.105527, -0.511467, 15.450634>
}
#declare trooper = union {
  object { trooperMupperMbody }
  object { legMright }
  object { legMleft }
  object { weapon }
  sphere { // fire
    <0,0,0>,1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.945196, -0.0, -0.0>
    material {
      explosion
    }
    hollow
    scale <-12.436904, -3.981284, -1.732946>
    rotate <-0.103394, -184.307922, 238.868134>
    translate  <-7.13426, -5.234586, 15.679229>
  }
  rotate 108.492096*z
  translate  <-22.432213, -3.145228, -3.473067>
}
#declare basicMupperMlimb2 = union {
  sphere { // Sphere354
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1487
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1488
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1489
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.889763, 0.6, 7.957074>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.272689, -0.0, -0.972206>
  }
  cylinder { // Cylndr1490
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1491
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere355
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.227032, 1.0, 1.313549>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere356
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere357
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.088028, 0.897211, 1.451759>
    rotate <-0.20454, 0.006653, -6.376747>
    translate  <-2.579374, -0.301122, -0.209806>
  }
  sphere { // Sphere358
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.402014, 1.951081, 1.903414>
    rotate <0.0, 4.411142, 0.0>
    translate  <-0.640424, 0.35666, -0.478302>
  }
  sphere { // Sphere359
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.748529, 0.423051, 2.390815>
    rotate <174.716705, -80.629654, 176.581375>
    translate  <2.228457, 0.34524, 1.265795>
  }
  torus { // Torus190
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.247004, 0.895005>
    rotate <-47.660999, -86.089897, -0.0>
    translate  <-1.243407, 0.465109, 0.390461>
  }
  torus { // Torus191
    1.3, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.136887, 1.027554>
    rotate <-35.391956, -86.089897, -0.0>
    translate  <0.577974, 0.26271, 0.335131>
  }
  torus { // Torus192
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.22252, 0.912929>
    rotate <-42.451847, -86.089897, -0.0>
    translate  <-0.341099, 0.358058, 0.363051>
  }
  scale <0.8, 1.0, 1.2>
  rotate <0.0, 87.391014, 0.0>
  translate  <-2.902059, 0.0, 5.616888>
}
#declare toeMlowerMpart6 = union {
  sphere { // Sphere367
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere368
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1498
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1499
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone098
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart6 = union {
  sphere { // Sphere369
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere370
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1500
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1501
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe6 = union {
  object { toeMlowerMpart6 }
  object { toeMpart6 }
  scale <3.846327, 6.251647, 2.984955>
  rotate <-105.290733, -0.790473, -89.373299>
  translate  <10.30372, 0.011034, 2.120341>
}
#declare toeMlowerMpart7 = union {
  sphere { // Sphere371
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere372
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1502
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1503
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone100
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart7 = union {
  sphere { // Sphere373
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere374
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1504
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1505
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe7 = union {
  object { toeMlowerMpart7 }
  object { toeMpart7 }
  scale <3.817335, 6.252286, 3.007317>
  rotate <-95.292099, 1.427575, -81.559448>
  translate  <10.156489, 0.47757, 1.273319>
}
#declare toeMlowerMpart8 = union {
  sphere { // Sphere375
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere376
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1506
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1507
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone101
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart8 = union {
  sphere { // Sphere377
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere378
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1508
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1509
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe8 = union {
  object { toeMlowerMpart8 }
  object { toeMpart8 }
  scale <3.835269, 6.246415, 2.996068>
  rotate <-95.305641, -2.794001, -95.775719>
  translate  <10.170376, -0.548809, 1.732482>
}
#declare foot2 = union {
  sphere { // Sphere365
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.104823, 0.954575, 0.702369>
    rotate <-0.0, 17.439234, -0.0>
    translate  <10.410911, 0.0, 0.865005>
  }
  cone { // Cone069
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <0.644094, 0.564646, 1.756106>
    rotate <180.0, 78.781219, 180.0>
    translate  <7.487469, 0.0, 2.592187>
  }
  sphere { // Sphere366
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.757855, 0.850708, 1.307657>
    rotate <-0.0, -15.639227, 0.0>
    translate  <9.65996, 0.0, 1.614038>
  }
  cylinder { // Cylndr1497
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.468556, 0.6, 1.877972>
    rotate 180.0*z
    translate  <9.489619, -0.019726, 1.869243>
  }
  object { toe6 }
  object { toe7 }
  object { toe8 }
  rotate <-0.0, 6.690316, -0.0>
  translate  <-9.753865, -0.0, -1.855504>
  scale <1.99075, 1.4, 0.845479>
  rotate <0.0, -153.91156, -0.0>
  translate  <9.249519, -0.063675, -0.101697>
}
#declare basicMlowerMlimb2 = union {
  sphere { // Sphere360
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1492
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1493
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1494
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1495
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1496
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere361
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere362
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere363
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  sphere { // Sphere364
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.082873, 0.552123, 1.709136>
    rotate <0.0, 87.068787, 0.0>
    translate  <0.049581, -0.0, 0.759272>
  }
  object { foot2 }
  sphere { // Sphere379
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.121197, 0.756362, -0.365819>
  }
  rotate 5.889341*y
  translate  <0.038422, 0.0, 0.372483>
  rotate <-0.0, -214.651245, -0.0>
  translate  <-2.714829, 0.0, -0.468074>
}
#declare basicMlegMright1 = union {
  object { basicMupperMlimb2 }
  object { basicMlowerMlimb2 }
  rotate <-0.0, -0.0, 0.0>
  translate  <3.337407, 0.0, -5.623791>
  scale <1.2, 1.3, 1.3>
  rotate <-0.12119, 16.036512, 5.273511>
  translate  <-1.513351, -3.598145, 6.44127>
}
#declare ribcageMleft1 = union {
  torus { // Torus193
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.178551, 1.805179, -5.12764>
  }
  torus { // Torus194
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.297019, 1.575937, -6.197968>
  }
  torus { // Torus195
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.181722, 2.001243, -3.90566>
  }
  torus { // Torus196
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.057331, 2.114087, -2.466968>
  }
  torus { // Torus197
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.999426, 2.20132, -1.078089>
  }
  torus { // Torus198
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.067741, 2.226013, -1.794035>
  }
  scale <1.0, -0.9, 1.0>
  rotate 3.609034*z
  translate  <-0.072292, -0.04536, -0.143374>
}
#declare ribcageMright1 = union {
  torus { // Torus199
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.238894, 1.790511, -4.974797>
  }
  torus { // Torus200
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.183365, 1.511926, -6.147021>
  }
  torus { // Torus201
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.168194, 1.921746, -3.863626>
  }
  torus { // Torus202
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.070659, 2.196042, -2.502768>
  }
  torus { // Torus203
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.910663, 2.344694, -1.01272>
  }
  torus { // Torus204
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.959827, 2.376283, -1.757957>
  }
  scale <1.0, 0.9, 1.0>
  rotate -2.686408*z
  translate  <-0.16194, 0.776374, -0.191991>
}
#declare backhorn4 = union {
  cone { // Cone102
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere389
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone103
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1520
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1521
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <-4.982898, -122.199158, -13.006399>
  translate  <2.991861, -2.831935, -0.52784>
}
#declare backhorn5 = union {
  cone { // Cone104
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere390
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone105
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1522
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1523
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, -0.966641, 0.897271>
  rotate <-5.282954, -123.897797, -11.708396>
  translate  <3.149146, -2.3936, -4.01965>
}
#declare backhorn6 = union {
  cone { // Cone106
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere391
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone107
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1524
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1525
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <3.189699, 2.342453, -4.170216>
}
#declare backhorn7 = union {
  cone { // Cone108
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere392
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone109
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1526
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1527
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <2.984451, 2.908959, -0.876936>
}
#declare torso1 = union {
  sphere { // Sphere380
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.431978, 3.640435, -1.571137>
    translate  <0.755961, 0.0, -9.936281>
  }
  sphere { // Sphere381
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.562611, -1.577748, 2.681785>
    rotate <0.0, -7.330361, -0.0>
    translate  <0.28956, -0.0, -9.564097>
  }
  cylinder { // Cylndr1510
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.12583, -0.742838, -11.504373>
    rotate -4.594381*y
    translate  <-1.109086, 0.0, 1.943899>
  }
  object { ribcageMleft1 }
  object { ribcageMright1 }
  cylinder { // Cylndr1511
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <12.646627, -7.665387, 8.324436>
    translate  <-0.660863, -2.517925, -2.905298>
  }
  cylinder { // Cylndr1512
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <171.665756, -175.767288, 182.595764>
    translate  <-0.966044, 2.1511, -2.495622>
  }
  sphere { // Sphere382
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.745076, 1.770083, -4.747586>
    rotate <4.042048, 0.185979, 0.521351>
    translate  <0.010811, 2.614042, -5.087942>
  }
  sphere { // Sphere383
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.678328, 1.883597, -5.076229>
    rotate <-1.562712, 0.189786, -0.485653>
    translate  <-0.018209, -2.140103, -5.208063>
  }
  cylinder { // Cylndr1513
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.219531, 0.612627, -9.652758>
    rotate -3.6973*y
    translate  0.390831*x
  }
  cylinder { // Cylndr1514
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.601077, -2.034538, -9.141262>
    rotate <5.172945, -4.044183, -8.660601>
    translate  <0.252768, -1.941129, -0.484216>
  }
  cylinder { // Cylndr1515
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.830165, 1.902151, -9.160878>
    rotate <-2.637861, 0.249879, 11.201634>
    translate  <0.252768, 1.738915, -0.387373>
  }
  sphere { // Sphere384
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <-1.064826, -2.428671, -2.510869>
    rotate -9.444944*z
    translate  <-0.534124, 2.386924, -1.936865>
  }
  sphere { // Sphere385
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.091671, -2.311246, -2.764631>
    rotate 8.449643*z
    translate  <-0.333828, -1.865268, -1.936865>
  }
  sphere { // Sphere386
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.30654, 2.177789, -5.763244>
    translate  <-0.073603, 0.0, -3.776887>
  }
  cylinder { // Cylndr1516
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    translate  <1.001483, -0.034691, -0.861696>
  }
  cylinder { // Cylndr1517
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate <15.484534, -0.0, -0.0>
    translate  <-0.534124, 1.457883, -0.861696>
  }
  cylinder { // Cylndr1518
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate -12.639755*x
    translate  <-0.467359, -1.483702, -0.861696>
  }
  cylinder { // Cylndr1519
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <1.0, 1.0, 3.0>
    translate  -0.861696*z
  }
  sphere { // Sphere387
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, -2.723392, 1.107712>
    rotate 6.808063*x
    translate  <0.0, -3.23136, -0.215424>
  }
  sphere { // Sphere388
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, 2.723392, 1.107712>
    rotate -4.840706*x
    translate  <0.0, 3.123648, -0.215424>
  }
  object { backhorn4 }
  object { backhorn5 }
  object { backhorn6 }
  object { backhorn7 }
  torus { // Torus205
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.418202, 1.180507>
    rotate <-44.0, 16.0, -167.0>
    translate  <-0.468104, 2.281597, -1.017244>
  }
  torus { // Torus206
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.342479, 1.247094>
    rotate <44.496597, 16.266319, 167.285858>
    translate  <-0.539582, -2.22596, -0.894328>
  }
  torus { // Torus207
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <-64.350632, -197.359482, -170.857941>
    translate  <1.035453, -2.369653, -9.84021>
  }
  torus { // Torus208
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <65.47683, 21.784595, -0.944939>
    translate  <1.034414, 2.657424, -9.785606>
  }
  torus { // Torus209
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, 1.220737, 1.808289>
    rotate <-32.536304, -193.641876, -169.694855>
    translate  <0.710842, -3.17749, -11.183852>
  }
  torus { // Torus210
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, -1.220737, 1.808289>
    rotate <32.536301, -193.641876, -169.694855>
    translate  <0.777046, 3.689119, -11.086957>
  }
  rotate 0.0*y
  translate  <-1.013394, 0.0, 9.373898>
  scale <1.5, 1.1, 1.5>
  rotate <0.0, -13.581846, -180.0>
  translate  <-4.601911, 0.111723, 9.845346>
}
#declare basicMlimb6 = union {
  sphere { // Sphere393
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1528
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1529
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1530
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1531
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1532
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere394
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere395
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere396
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere397
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart8 = union {
  sphere { // Sphere407
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere408
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1542
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1543
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone111
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart8 = union {
  sphere { // Sphere409
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere410
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1544
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1545
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger8 = union {
  object { fingerMlowerMpart8 }
  object { fingerMpart8 }
  rotate 5.359898*x
}
#declare fingerMlowerMpart9 = union {
  sphere { // Sphere411
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere412
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1546
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1547
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone112
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart9 = union {
  sphere { // Sphere413
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere414
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1548
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1549
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger9 = union {
  object { fingerMlowerMpart9 }
  object { fingerMpart9 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart10 = union {
  sphere { // Sphere415
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere416
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1550
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1551
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone113
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart10 = union {
  sphere { // Sphere417
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere418
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1552
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1553
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger10 = union {
  object { fingerMlowerMpart10 }
  object { fingerMpart10 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart11 = union {
  sphere { // Sphere419
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere420
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1554
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1555
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone114
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart11 = union {
  sphere { // Sphere421
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere422
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1556
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1557
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger11 = union {
  object { fingerMlowerMpart11 }
  object { fingerMpart11 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand2 = union {
  sphere { // Sphere403
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1538
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere404
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere405
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1539
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1540
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1541
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere406
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger8 }
  object { finger9 }
  object { finger10 }
  object { finger11 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.59683, 0.117826, -0.181062>
}
#declare basicMlimb7 = union {
  sphere { // Sphere398
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1533
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1534
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1535
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1536
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1537
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere399
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere400
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere401
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere402
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone110
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand2 }
  rotate <-192.024017, -163.898071, 202.403015>
}
#declare basicMarmMleft1 = union {
  object { basicMlimb6 }
  object { basicMlimb7 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale -0.8
  rotate <52.61475, -243.693542, -238.863205>
  translate  <0.207494, 5.447027, 22.500708>
}
#declare basicMlimb2 = union {
  sphere { // Sphere423
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1558
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1559
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1560
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1561
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1562
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere424
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere425
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere426
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere427
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart12 = union {
  sphere { // Sphere437
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere438
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1572
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1573
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone116
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart12 = union {
  sphere { // Sphere439
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere440
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1574
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1575
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger12 = union {
  object { fingerMlowerMpart12 }
  object { fingerMpart12 }
  rotate 5.359898*x
}
#declare fingerMlowerMpart13 = union {
  sphere { // Sphere441
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere442
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1576
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1577
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone117
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart13 = union {
  sphere { // Sphere443
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere444
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1578
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1579
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger13 = union {
  object { fingerMlowerMpart13 }
  object { fingerMpart13 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart14 = union {
  sphere { // Sphere445
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere446
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1580
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1581
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone118
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart14 = union {
  sphere { // Sphere447
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere448
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1582
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1583
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger14 = union {
  object { fingerMlowerMpart14 }
  object { fingerMpart14 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart15 = union {
  sphere { // Sphere449
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere450
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1584
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1585
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone119
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart15 = union {
  sphere { // Sphere451
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere452
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1586
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1587
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger15 = union {
  object { fingerMlowerMpart15 }
  object { fingerMpart15 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand3 = union {
  sphere { // Sphere433
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1568
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere434
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere435
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1569
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1570
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1571
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere436
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger12 }
  object { finger13 }
  object { finger14 }
  object { finger15 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.696018, -0.056512, -0.223852>
}
#declare basicMlimb3 = union {
  sphere { // Sphere428
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1563
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1564
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1565
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1566
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1567
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere429
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere430
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere431
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere432
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone115
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand3 }
  rotate <-141.575653, -193.933014, 189.809418>
}
#declare basicMarmMright1 = union {
  object { basicMlimb2 }
  object { basicMlimb3 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale 0.8
  rotate <-134.888748, -113.957748, 80.560448>
  translate  <0.146469, -5.227571, 22.61268>
}
#declare CSG002 = difference {
  sphere { // Sphere453
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <4.25028, 11.680179, 3.325953>
    rotate <-0.196035, -0.0, -0.0>
    translate  <-0.0, 5.874081, -0.157509>
  }
  sphere { // Sphere454
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <5.349308, 9.944535, 4.791598>
    rotate -2.533771*x
    translate  <0.149241, 3.538993, -3.332989>
  }
  scale <1.166423, 1.1, 1.144323>
  rotate 0.684455*x
  translate  <-0.0, 2.075105, -0.253283>
}
#declare teethMupperMleft2 = union {
  cone { // Cone120
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone121
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone122
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone123
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone124
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone125
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone126
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone127
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone128
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone129
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright2 = union {
  cone { // Cone130
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone131
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone132
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone133
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone134
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone135
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone136
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone137
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone138
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone139
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone140
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMlower1 = union {
  object { teethMupperMleft2 }
  object { teethMupperMright2 }
  scale -1.0
  rotate <7.41871, 0.0, -180.0>
  translate  <0.0, 0.20296, -4.886318>
}
#declare teethMupperMleft3 = union {
  cone { // Cone141
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone142
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone143
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone144
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone145
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone146
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone147
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone148
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone149
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone150
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright3 = union {
  cone { // Cone151
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone152
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone153
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone154
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone155
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone156
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone157
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone158
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone159
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone160
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone161
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMupper1 = union {
  object { teethMupperMleft3 }
  object { teethMupperMright3 }
}
#declare headMx1 = union {
  sphere { // Sphere459
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.270821, 1.487489, 2.59577>
    rotate -62.072033*x
    translate  <0.0, -1.195858, -0.233674>
  }
  sphere { // Sphere460
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <2.0, 1.658326, 2.0>
    rotate -90.0*x
    translate  <0.0, 13.325275, 0.0>
  }
  torus { // Torus213
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  11.195858*y
  }
  torus { // Torus214
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  9.195858*y
  }
  torus { // Torus215
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  7.195858*y
  }
  torus { // Torus216
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  5.195858*y
  }
  torus { // Torus217
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  3.195858*y
  }
  torus { // Torus218
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  1.195858*y
  }
  cylinder { // Cylndr1593
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 0.658326, 13.075064>
    rotate -90.0*x
  }
  scale <1.823368, 1.192647, 0.952494>
  translate  <-0.0, 0.555383, 0.18012>
}
#declare headMinterior1 = union {
  object { teethMlower1 }
  object { teethMupper1 }
  sphere { // Sphere455
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.279829, 3.013228, 0.691975>
    rotate 10.305234*x
    translate  <0.0, 2.850586, -3.530883>
  }
  cylinder { // Cylndr1588
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.639969, -0.189462, 2.421683>
    translate  <1.750329, -2.022552, -2.360624>
  }
  cylinder { // Cylndr1589
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.590279, 0.101221, -2.999959>
    translate  <-1.731603, -1.888632, -2.360624>
  }
  sphere { // Sphere456
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.715117, 3.552059, 0.626342>
    rotate -4.058217*x
    translate  <0.0, -0.284982, -3.303354>
  }
  sphere { // Sphere457
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.839486, 2.366695, 0.735887>
    translate  <0.0, -2.050042, -0.683347>
  }
  torus { // Torus211
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.145908, 1.126128, 0.95174>
    rotate -19.642107*x
    translate  <0.0, -2.73339, -1.537532>
  }
  torus { // Torus212
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.15546, 0.996368, 0.875845>
    rotate 6.707807*x
    translate  <0.0, -2.562553, -3.075063>
  }
  sphere { // Sphere458
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.0, 0.847587, 2.885885>
    rotate -68.325066*x
    translate  <0.0, 8.679306, -2.166905>
  }
  cylinder { // Cylndr1590
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.621841, 0.964178, 8.980318>
    rotate -90.0*x
    translate  <0.031092, -1.879205, -2.500708>
  }
  cylinder { // Cylndr1591
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <1.368051, 2.904227, -1.117958>
  }
  cylinder { // Cylndr1592
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <-1.368051, 2.904227, -1.117958>
  }
  object { headMx1 }
}
#declare head1 = union {
  object { CSG002 }
  object { headMinterior1 }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.006278, -4.971637, 2.107308>
  scale <0.6, 0.8, 0.8>
  rotate <-32.250435, 9.767241, 102.856468>
  translate  <0.932633, 0.071071, 25.285087>
}
#declare tailMseg5 = union {
  sphere { // Sphere461
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone162
    <0,0,0>, 0.0, <0,0,1>, 0.8
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone163
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.541516, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.076768, -1.995904>
  }
  cone { // Cone164
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.336995, -0.1877, -0.651453>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 0.787325, -2.373694>
  }
  cone { // Cone165
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.285301, -0.097924, -0.690062>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 0.606552, -3.05747>
  }
  torus { // Torus219
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.387161, 0.529998, 0.55242>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus220
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.470708, 0.590001, 0.599762>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone166
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.618626, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.207862, -1.206992>
  }
  translate  <0.0, 0.081209, -0.153672>
  scale 0.2401
  translate  <-0.0, -0.019498, -10.177797>
}
#declare tailMseg6 = union {
  sphere { // Sphere462
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone167
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.018093, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone168
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus221
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.503471, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus222
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.539657, 0.607, 0.607239>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus223
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.575842, 0.643, 0.640606>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone169
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone170
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone171
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus224
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus225
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone172
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.343
  translate  <0.0, 0.0, -8.799636>
}
#declare tailMpartM4 = union {
  object { tailMseg5 }
  object { tailMseg6 }
  rotate 0.0*x
  translate  <-0.0, 0.023283, 8.800973>
  rotate <63.330853, 4.369052, -2.554259>
  translate  <0.0, -0.023283, -8.800973>
}
#declare tailMseg7 = union {
  sphere { // Sphere463
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone173
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone174
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus226
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.491709, 0.569774, 0.57679>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus227
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.542822, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus228
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone175
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone176
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone177
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus229
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus230
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone178
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.49
  translate  <0.0, 0.0, -6.825016>
}
#declare tailMpartM5 = union {
  object { tailMpartM4 }
  object { tailMseg7 }
  rotate -0.0*x
  translate  <-0.0, -0.008138, 6.841223>
  rotate <12.490372, -1.111739, 1.34524>
  translate  <0.0, 0.008138, -6.841223>
}
#declare tailMseg8 = union {
  sphere { // Sphere464
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone179
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone180
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus231
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus232
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus233
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone181
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone182
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone183
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus234
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus235
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone184
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.7
  translate  <0.0, 0.0, -3.996833>
}
#declare tailMpartM6 = union {
  object { tailMpartM5 }
  object { tailMseg8 }
  rotate <-0.0, 0.0, 0.0>
  translate  <-0.0, -0.048121, 3.977207>
  rotate <-47.84547, -3.752638, 3.036387>
  translate  <0.0, 0.073518, -3.72317>
}
#declare tailMseg9 = union {
  sphere { // Sphere465
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone185
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone186
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus236
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus237
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus238
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone187
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone188
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone189
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus239
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus240
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone190
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
}
#declare tail1 = union {
  object { tailMpartM6 }
  object { tailMseg9 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.076435, -0.065365>
  scale <1.214286, 1.7, 2.833333>
  rotate <52.305943, -0.0, 90.0>
  translate  <-6.403084, -0.252203, 6.594411>
}
#declare upperMbody1 = union {
  object { torso1 }
  object { basicMarmMleft1 }
  object { basicMarmMright1 }
  object { head1 }
  object { tail1 }
  rotate <-5.973597, 36.540485, -2.863771>
  translate  <-2.274868, 0.0, -1.624906>
}
#declare basicMupperMlimb3 = union {
  sphere { // Sphere466
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1594
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1595
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1596
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.889763, 0.6, 7.957074>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.272689, -0.0, -0.972206>
  }
  cylinder { // Cylndr1597
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1598
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere467
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.227032, 1.0, 1.313549>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere468
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere469
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.088028, 0.897211, 1.451759>
    rotate <-0.210516, -0.012921, -6.567191>
    translate  <-2.579374, -0.301122, -0.209806>
  }
  sphere { // Sphere470
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.402014, 1.951081, 1.903414>
    rotate <0.0, 4.411142, 0.0>
    translate  <-0.640424, 0.35666, -0.478302>
  }
  sphere { // Sphere471
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.748529, 0.423051, 2.390815>
    rotate <174.716705, -80.629654, 176.581375>
    translate  <2.228457, 0.34524, 1.265795>
  }
  torus { // Torus241
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.247004, 0.895005>
    rotate <-47.660999, -86.089897, -0.0>
    translate  <-1.243407, 0.465109, 0.390461>
  }
  torus { // Torus242
    1.3, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.136887, 1.027554>
    rotate <-35.391956, -86.089897, -0.0>
    translate  <0.577974, 0.26271, 0.335131>
  }
  torus { // Torus243
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.22252, 0.912929>
    rotate <-42.451847, -86.089897, -0.0>
    translate  <-0.341099, 0.358058, 0.363051>
  }
  scale <0.8, 1.0, 1.2>
  rotate <0.0, 87.391014, 0.0>
  translate  <-2.902059, 0.0, 5.616888>
}
#declare toeMlowerMpart9 = union {
  sphere { // Sphere479
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere480
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1605
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1606
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone192
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart9 = union {
  sphere { // Sphere481
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere482
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1607
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1608
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe9 = union {
  object { toeMlowerMpart9 }
  object { toeMpart9 }
  scale <3.846327, 6.251647, 2.984955>
  rotate <-104.346291, -0.802354, -89.380188>
  translate  <10.356746, 0.011034, 2.11107>
}
#declare toeMlowerMpart10 = union {
  sphere { // Sphere483
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere484
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1609
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1610
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone193
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart10 = union {
  sphere { // Sphere485
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere486
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1611
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1612
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe10 = union {
  object { toeMlowerMpart10 }
  object { toeMpart10 }
  scale <3.817335, 6.252286, 3.007317>
  rotate <-95.292099, 1.427575, -81.559448>
  translate  <10.156489, 0.47757, 1.273319>
}
#declare toeMlowerMpart11 = union {
  sphere { // Sphere487
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere488
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1613
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1614
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone194
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart11 = union {
  sphere { // Sphere489
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere490
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1615
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1616
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe11 = union {
  object { toeMlowerMpart11 }
  object { toeMpart11 }
  scale <3.835269, 6.246415, 2.996068>
  rotate <-95.305641, -2.794001, -95.775719>
  translate  <10.170376, -0.548809, 1.732482>
}
#declare foot3 = union {
  sphere { // Sphere477
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.104823, 0.954575, 0.702369>
    rotate <-0.0, 17.439234, -0.0>
    translate  <10.410911, 0.0, 0.865005>
  }
  cone { // Cone191
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <0.644094, 0.564646, 1.756106>
    rotate <180.0, 78.781219, 180.0>
    translate  <7.487469, 0.0, 2.592187>
  }
  sphere { // Sphere478
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.757855, 0.850708, 1.307657>
    rotate <-0.0, -15.639227, 0.0>
    translate  <9.65996, 0.0, 1.614038>
  }
  cylinder { // Cylndr1604
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.468556, 0.6, 1.877972>
    rotate 180.0*z
    translate  <9.475477, -0.019726, 2.093359>
  }
  object { toe9 }
  object { toe10 }
  object { toe11 }
  rotate <-0.0, 6.690316, -0.0>
  translate  <-9.753865, -0.0, -1.855504>
  scale <1.99075, 1.4, 0.845479>
  rotate <0.0, -111.314934, -0.0>
  translate  <9.249519, -0.063675, -0.101697>
}
#declare basicMlowerMlimb3 = union {
  sphere { // Sphere472
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1599
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1600
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1601
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1602
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1603
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere473
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere474
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere475
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  sphere { // Sphere476
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.175285, 0.552123, 1.745987>
    rotate <0.0, 82.934669, 0.0>
    translate  <-0.304845, -0.0, 0.620477>
  }
  object { foot3 }
  sphere { // Sphere491
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.121197, 0.756362, -0.365819>
  }
  rotate 5.889341*y
  translate  <0.038422, 0.0, 0.372483>
  rotate <-0.0, -231.446243, -0.0>
  translate  <-2.714829, 0.0, -0.468074>
}
#declare basicMlegMleft1 = union {
  object { basicMupperMlimb3 }
  object { basicMlowerMlimb3 }
  rotate <-0.0, -0.0, 0.0>
  translate  <3.337407, 0.0, -5.623791>
  scale <1.2, -1.3, 1.3>
  rotate <0.403906, -33.849937, 8.741065>
  translate  <-1.540774, 3.356687, 7.060229>
}
#declare alien1 = union {
  object { basicMlegMright1 }
  object { upperMbody1 }
  object { basicMlegMleft1 }
  scale 0.4
  translate  <7.412163, -8.945824, 5.791357>
}
union { // mainMaction
  object { fireball }
  object { trooper }
  object { alien1 }
  rotate -10.810641*z
  translate  <8.867016, 14.098458, 1.483969>
}




#declare basicMupperMlimb4 = union {
  sphere { // Sphere492
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1617
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1618
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1619
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.889763, 0.6, 7.957074>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.272689, -0.0, -0.972206>
  }
  cylinder { // Cylndr1620
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1621
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere493
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.227032, 1.0, 1.313549>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere494
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere495
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.088028, 0.897211, 1.451759>
    rotate <-0.20454, 0.006653, -6.376747>
    translate  <-2.579374, -0.301122, -0.209806>
  }
  sphere { // Sphere496
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.402014, 1.951081, 1.903414>
    rotate <0.0, 4.411142, 0.0>
    translate  <-0.640424, 0.35666, -0.478302>
  }
  sphere { // Sphere497
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.748529, 0.423051, 2.390815>
    rotate <174.716705, -80.629654, 176.581375>
    translate  <2.228457, 0.34524, 1.265795>
  }
  torus { // Torus244
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.247004, 0.895005>
    rotate <-47.660999, -86.089897, -0.0>
    translate  <-1.243407, 0.465109, 0.390461>
  }
  torus { // Torus245
    1.3, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.136887, 1.027554>
    rotate <-35.391956, -86.089897, -0.0>
    translate  <0.577974, 0.26271, 0.335131>
  }
  torus { // Torus246
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.22252, 0.912929>
    rotate <-42.451847, -86.089897, -0.0>
    translate  <-0.341099, 0.358058, 0.363051>
  }
  scale <0.8, 1.0, 1.2>
  rotate <0.0, 87.391014, 0.0>
  translate  <-2.902059, 0.0, 5.616888>
}
#declare toeMlowerMpart12 = union {
  sphere { // Sphere505
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere506
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1628
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1629
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone196
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart12 = union {
  sphere { // Sphere507
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere508
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1630
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1631
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe12 = union {
  object { toeMlowerMpart12 }
  object { toeMpart12 }
  scale <3.846327, 6.251647, 2.984955>
  rotate <-105.290733, -0.790473, -89.373299>
  translate  <10.30372, 0.011034, 2.120341>
}
#declare toeMlowerMpart13 = union {
  sphere { // Sphere509
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere510
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1632
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1633
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone197
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart13 = union {
  sphere { // Sphere511
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere512
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1634
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1635
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe13 = union {
  object { toeMlowerMpart13 }
  object { toeMpart13 }
  scale <3.817335, 6.252286, 3.007317>
  rotate <-95.292099, 1.427575, -81.559448>
  translate  <10.156489, 0.47757, 1.273319>
}
#declare toeMlowerMpart14 = union {
  sphere { // Sphere513
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere514
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1636
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1637
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone198
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart14 = union {
  sphere { // Sphere515
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere516
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1638
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1639
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe14 = union {
  object { toeMlowerMpart14 }
  object { toeMpart14 }
  scale <3.835269, 6.246415, 2.996068>
  rotate <-95.305641, -2.794001, -95.775719>
  translate  <10.170376, -0.548809, 1.732482>
}
#declare foot4 = union {
  sphere { // Sphere503
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.104823, 0.954575, 0.702369>
    rotate <-0.0, 17.439234, -0.0>
    translate  <10.410911, 0.0, 0.865005>
  }
  cone { // Cone195
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <0.644094, 0.564646, 1.756106>
    rotate <180.0, 78.781219, 180.0>
    translate  <7.487469, 0.0, 2.592187>
  }
  sphere { // Sphere504
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.757855, 0.850708, 1.307657>
    rotate <-0.0, -15.639227, 0.0>
    translate  <9.65996, 0.0, 1.614038>
  }
  cylinder { // Cylndr1627
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.468556, 0.6, 1.877972>
    rotate 180.0*z
    translate  <9.489619, -0.019726, 1.869243>
  }
  object { toe12 }
  object { toe13 }
  object { toe14 }
  rotate <-0.0, 6.690316, -0.0>
  translate  <-9.753865, -0.0, -1.855504>
  scale <1.99075, 1.4, 0.845479>
  rotate <0.0, -153.91156, -0.0>
  translate  <9.249519, -0.063675, -0.101697>
}
#declare basicMlowerMlimb4 = union {
  sphere { // Sphere498
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1622
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1623
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1624
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1625
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1626
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere499
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere500
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere501
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  sphere { // Sphere502
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.082873, 0.552123, 1.709136>
    rotate <0.0, 87.068787, 0.0>
    translate  <0.049581, -0.0, 0.759272>
  }
  object { foot4 }
  sphere { // Sphere517
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.121197, 0.756362, -0.365819>
  }
  rotate 5.889341*y
  translate  <0.038422, 0.0, 0.372483>
  rotate <-3.478285, -168.160248, -6.110368>
  translate  <-2.714829, 0.0, -0.468074>
}
#declare basicMlegMright2 = union {
  object { basicMupperMlimb4 }
  object { basicMlowerMlimb4 }
  rotate <-0.0, -0.0, 0.0>
  translate  <3.337407, 0.0, -5.623791>
  scale <1.2, 1.3, 1.3>
  rotate <166.517319, -114.512093, -175.916229>
  translate  <-1.873552, -3.323271, 5.928352>
}
#declare ribcageMleft2 = union {
  torus { // Torus247
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.178551, 1.805179, -5.12764>
  }
  torus { // Torus248
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.297019, 1.575937, -6.197968>
  }
  torus { // Torus249
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.181722, 2.001243, -3.90566>
  }
  torus { // Torus250
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.057331, 2.114087, -2.466968>
  }
  torus { // Torus251
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.999426, 2.20132, -1.078089>
  }
  torus { // Torus252
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.067741, 2.226013, -1.794035>
  }
  scale <1.0, -0.9, 1.0>
  rotate 3.609034*z
  translate  <-0.072292, -0.04536, -0.143374>
}
#declare ribcageMright2 = union {
  torus { // Torus253
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.238894, 1.790511, -4.974797>
  }
  torus { // Torus254
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.183365, 1.511926, -6.147021>
  }
  torus { // Torus255
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.168194, 1.921746, -3.863626>
  }
  torus { // Torus256
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.070659, 2.196042, -2.502768>
  }
  torus { // Torus257
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.910663, 2.344694, -1.01272>
  }
  torus { // Torus258
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.959827, 2.376283, -1.757957>
  }
  scale <1.0, 0.9, 1.0>
  rotate -2.686408*z
  translate  <-0.16194, 0.776374, -0.191991>
}
#declare backhorn8 = union {
  cone { // Cone199
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere527
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone200
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1650
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1651
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <-4.982898, -122.199158, -13.006399>
  translate  <2.991861, -2.831935, -0.52784>
}
#declare backhorn9 = union {
  cone { // Cone201
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere528
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone202
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1652
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1653
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, -0.966641, 0.897271>
  rotate <-5.282954, -123.897797, -11.708396>
  translate  <3.149146, -2.3936, -4.01965>
}
#declare backhorn10 = union {
  cone { // Cone203
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere529
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone204
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1654
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1655
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <3.189699, 2.342453, -4.170216>
}
#declare backhorn11 = union {
  cone { // Cone205
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere530
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone206
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1656
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1657
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <2.984451, 2.908959, -0.876936>
}
#declare torso2 = union {
  sphere { // Sphere518
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.431978, 3.640435, -1.571137>
    translate  <0.755961, 0.0, -9.936281>
  }
  sphere { // Sphere519
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.562611, -1.577748, 2.681785>
    rotate <0.0, -7.330361, -0.0>
    translate  <0.28956, -0.0, -9.564097>
  }
  cylinder { // Cylndr1640
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.12583, -0.742838, -11.504373>
    rotate -4.594381*y
    translate  <-1.109086, 0.0, 1.943899>
  }
  object { ribcageMleft2 }
  object { ribcageMright2 }
  cylinder { // Cylndr1641
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <12.646627, -7.665387, 8.324436>
    translate  <-0.660863, -2.517925, -2.905298>
  }
  cylinder { // Cylndr1642
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <171.665756, -175.767288, 182.595764>
    translate  <-0.966044, 2.1511, -2.495622>
  }
  sphere { // Sphere520
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.745076, 1.770083, -4.747586>
    rotate <4.042048, 0.185979, 0.521351>
    translate  <0.010811, 2.614042, -5.087942>
  }
  sphere { // Sphere521
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.678328, 1.883597, -5.076229>
    rotate <-1.562712, 0.189786, -0.485653>
    translate  <-0.018209, -2.140103, -5.208063>
  }
  cylinder { // Cylndr1643
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.219531, 0.612627, -9.652758>
    rotate -3.6973*y
    translate  0.390831*x
  }
  cylinder { // Cylndr1644
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.601077, -2.034538, -9.141262>
    rotate <5.172945, -4.044183, -8.660601>
    translate  <0.252768, -1.941129, -0.484216>
  }
  cylinder { // Cylndr1645
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.830165, 1.902151, -9.160878>
    rotate <-2.637861, 0.249879, 11.201634>
    translate  <0.252768, 1.738915, -0.387373>
  }
  sphere { // Sphere522
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <-1.064826, -2.428671, -2.510869>
    rotate -9.444944*z
    translate  <-0.534124, 2.386924, -1.936865>
  }
  sphere { // Sphere523
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.091671, -2.311246, -2.764631>
    rotate 8.449643*z
    translate  <-0.333828, -1.865268, -1.936865>
  }
  sphere { // Sphere524
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.30654, 2.177789, -5.763244>
    translate  <-0.073603, 0.0, -3.776887>
  }
  cylinder { // Cylndr1646
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    translate  <1.001483, -0.034691, -0.861696>
  }
  cylinder { // Cylndr1647
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate <15.484534, -0.0, -0.0>
    translate  <-0.534124, 1.457883, -0.861696>
  }
  cylinder { // Cylndr1648
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate -12.639755*x
    translate  <-0.467359, -1.483702, -0.861696>
  }
  cylinder { // Cylndr1649
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <1.0, 1.0, 3.0>
    translate  -0.861696*z
  }
  sphere { // Sphere525
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, -2.723392, 1.107712>
    rotate 6.808063*x
    translate  <0.0, -3.23136, -0.215424>
  }
  sphere { // Sphere526
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, 2.723392, 1.107712>
    rotate -4.840706*x
    translate  <0.0, 3.123648, -0.215424>
  }
  object { backhorn8 }
  object { backhorn9 }
  object { backhorn10 }
  object { backhorn11 }
  torus { // Torus259
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.418202, 1.180507>
    rotate <-44.0, 16.0, -167.0>
    translate  <-0.468104, 2.281597, -1.017244>
  }
  torus { // Torus260
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.342479, 1.247094>
    rotate <44.496597, 16.266319, 167.285858>
    translate  <-0.539582, -2.22596, -0.894328>
  }
  torus { // Torus261
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <-64.350632, -197.359482, -170.857941>
    translate  <1.035453, -2.369653, -9.84021>
  }
  torus { // Torus262
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <65.47683, 21.784595, -0.944939>
    translate  <1.034414, 2.657424, -9.785606>
  }
  torus { // Torus263
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, 1.220737, 1.808289>
    rotate <-32.536304, -193.641876, -169.694855>
    translate  <0.710842, -3.17749, -11.183852>
  }
  torus { // Torus264
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, -1.220737, 1.808289>
    rotate <32.536301, -193.641876, -169.694855>
    translate  <0.777046, 3.689119, -11.086957>
  }
  rotate 0.0*y
  translate  <-1.013394, 0.0, 9.373898>
  scale <1.5, 1.1, 1.5>
  rotate <0.0, -13.581846, -180.0>
  translate  <-4.601911, 0.111723, 9.845346>
}
#declare basicMlimb8 = union {
  sphere { // Sphere531
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1658
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1659
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1660
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1661
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1662
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere532
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere533
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere534
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere535
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart16 = union {
  sphere { // Sphere545
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere546
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1672
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1673
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone208
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart16 = union {
  sphere { // Sphere547
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere548
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1674
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1675
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger16 = union {
  object { fingerMlowerMpart16 }
  object { fingerMpart16 }
  rotate 5.359898*x
}
#declare fingerMlowerMpart17 = union {
  sphere { // Sphere549
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere550
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1676
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1677
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone209
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart17 = union {
  sphere { // Sphere551
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere552
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1678
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1679
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger17 = union {
  object { fingerMlowerMpart17 }
  object { fingerMpart17 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart18 = union {
  sphere { // Sphere553
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere554
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1680
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1681
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone210
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart18 = union {
  sphere { // Sphere555
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere556
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1682
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1683
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger18 = union {
  object { fingerMlowerMpart18 }
  object { fingerMpart18 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart19 = union {
  sphere { // Sphere557
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere558
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1684
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1685
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone211
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart19 = union {
  sphere { // Sphere559
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere560
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1686
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1687
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger19 = union {
  object { fingerMlowerMpart19 }
  object { fingerMpart19 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand4 = union {
  sphere { // Sphere541
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1668
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere542
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere543
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1669
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1670
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1671
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere544
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger16 }
  object { finger17 }
  object { finger18 }
  object { finger19 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.59683, 0.117826, -0.181062>
}
#declare basicMlimb9 = union {
  sphere { // Sphere536
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1663
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1664
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1665
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1666
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1667
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere537
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere538
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere539
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere540
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone207
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand4 }
  rotate <-190.374329, -149.529099, 187.794266>
}
#declare basicMarmMleft2 = union {
  object { basicMlimb8 }
  object { basicMlimb9 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale -0.8
  rotate <156.797913, 4.435587, -160.001663>
  translate  <0.207494, 5.447027, 22.500708>
}
#declare basicMlimb10 = union {
  sphere { // Sphere561
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1688
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1689
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1690
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1691
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1692
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere562
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere563
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere564
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere565
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart20 = union {
  sphere { // Sphere575
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere576
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1702
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1703
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone213
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart20 = union {
  sphere { // Sphere577
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere578
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1704
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1705
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger20 = union {
  object { fingerMlowerMpart20 }
  object { fingerMpart20 }
  rotate 5.359898*x
}
#declare fingerMlowerMpart21 = union {
  sphere { // Sphere579
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere580
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1706
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1707
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone214
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart21 = union {
  sphere { // Sphere581
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere582
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1708
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1709
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger21 = union {
  object { fingerMlowerMpart21 }
  object { fingerMpart21 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart22 = union {
  sphere { // Sphere583
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere584
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1710
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1711
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone215
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart22 = union {
  sphere { // Sphere585
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere586
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1712
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1713
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger22 = union {
  object { fingerMlowerMpart22 }
  object { fingerMpart22 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart23 = union {
  sphere { // Sphere587
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere588
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1714
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1715
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone216
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart23 = union {
  sphere { // Sphere589
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere590
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1716
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1717
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger23 = union {
  object { fingerMlowerMpart23 }
  object { fingerMpart23 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand5 = union {
  sphere { // Sphere571
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1698
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere572
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere573
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1699
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1700
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1701
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere574
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger20 }
  object { finger21 }
  object { finger22 }
  object { finger23 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.696018, -0.056512, -0.223852>
}
#declare basicMlimb11 = union {
  sphere { // Sphere566
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1693
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1694
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1695
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1696
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1697
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere567
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere568
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere569
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere570
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone212
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand5 }
  rotate <-150.455215, -156.036163, 179.265594>
}
#declare basicMarmMright2 = union {
  object { basicMlimb10 }
  object { basicMlimb11 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale 0.8
  rotate <127.498657, -219.257095, 129.027893>
  translate  <0.055141, -5.405216, 22.731882>
}
#declare CSG003 = difference {
  sphere { // Sphere591
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <4.25028, 11.680179, 3.325953>
    rotate <-0.196035, -0.0, -0.0>
    translate  <-0.0, 5.874081, -0.157509>
  }
  sphere { // Sphere592
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <5.349308, 9.944535, 4.791598>
    rotate -2.533771*x
    translate  <0.149241, 3.538993, -3.332989>
  }
  scale <1.166423, 1.1, 1.144323>
  rotate 0.684455*x
  translate  <-0.0, 2.075105, -0.253283>
}
#declare teethMupperMleft4 = union {
  cone { // Cone217
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone218
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone219
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone220
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone221
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone222
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone223
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone224
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone225
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone226
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright4 = union {
  cone { // Cone227
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone228
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone229
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone230
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone231
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone232
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone233
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone234
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone235
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone236
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone237
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMlower2 = union {
  object { teethMupperMleft4 }
  object { teethMupperMright4 }
  scale -1.0
  rotate <7.41871, 0.0, -180.0>
  translate  <0.0, 0.20296, -4.886318>
}
#declare teethMupperMleft5 = union {
  cone { // Cone238
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone239
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone240
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone241
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone242
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone243
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone244
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone245
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone246
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone247
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright5 = union {
  cone { // Cone248
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone249
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone250
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone251
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone252
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone253
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone254
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone255
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone256
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone257
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone258
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMupper2 = union {
  object { teethMupperMleft5 }
  object { teethMupperMright5 }
}
#declare headMx2 = union {
  sphere { // Sphere597
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.270821, 1.487489, 2.59577>
    rotate -62.072033*x
    translate  <0.0, -1.195858, -0.233674>
  }
  sphere { // Sphere598
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <2.0, 1.658326, 2.0>
    rotate -90.0*x
    translate  <0.0, 13.325275, 0.0>
  }
  torus { // Torus267
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  11.195858*y
  }
  torus { // Torus268
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  9.195858*y
  }
  torus { // Torus269
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  7.195858*y
  }
  torus { // Torus270
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  5.195858*y
  }
  torus { // Torus271
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  3.195858*y
  }
  torus { // Torus272
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  1.195858*y
  }
  cylinder { // Cylndr1723
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 0.658326, 13.075064>
    rotate -90.0*x
  }
  scale <1.823368, 1.192647, 0.952494>
  translate  <-0.0, 0.555383, 0.18012>
}
#declare headMinterior2 = union {
  object { teethMlower2 }
  object { teethMupper2 }
  sphere { // Sphere593
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.279829, 3.013228, 0.691975>
    rotate 10.305234*x
    translate  <0.0, 2.850586, -3.530883>
  }
  cylinder { // Cylndr1718
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.639969, -0.189462, 2.421683>
    translate  <1.750329, -2.022552, -2.360624>
  }
  cylinder { // Cylndr1719
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.590279, 0.101221, -2.999959>
    translate  <-1.731603, -1.888632, -2.360624>
  }
  sphere { // Sphere594
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.715117, 3.552059, 0.626342>
    rotate -4.058217*x
    translate  <0.0, -0.284982, -3.303354>
  }
  sphere { // Sphere595
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.839486, 2.366695, 0.735887>
    translate  <0.0, -2.050042, -0.683347>
  }
  torus { // Torus265
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.145908, 1.126128, 0.95174>
    rotate -19.642107*x
    translate  <0.0, -2.73339, -1.537532>
  }
  torus { // Torus266
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.15546, 0.996368, 0.875845>
    rotate 6.707807*x
    translate  <0.0, -2.562553, -3.075063>
  }
  sphere { // Sphere596
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.0, 0.847587, 2.885885>
    rotate -68.325066*x
    translate  <0.0, 8.679306, -2.166905>
  }
  cylinder { // Cylndr1720
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.621841, 0.964178, 8.980318>
    rotate -90.0*x
    translate  <0.031092, -1.879205, -2.500708>
  }
  cylinder { // Cylndr1721
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <1.368051, 2.904227, -1.117958>
  }
  cylinder { // Cylndr1722
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <-1.368051, 2.904227, -1.117958>
  }
  object { headMx2 }
}
#declare head2 = union {
  object { CSG003 }
  object { headMinterior2 }
  rotate <-0.0, 0.0, 0.0>
  translate  <-1.872402, -6.647356, 3.564467>
  scale <0.6, 0.8, 0.8>
  rotate <-30.551382, -5.538083, 73.619789>
  translate  <0.404229, 1.206036, 23.594139>
}
#declare tailMseg10 = union {
  sphere { // Sphere599
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone259
    <0,0,0>, 0.0, <0,0,1>, 0.8
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone260
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.541516, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.076768, -1.995904>
  }
  cone { // Cone261
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.336995, -0.1877, -0.651453>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 0.787325, -2.373694>
  }
  cone { // Cone262
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.285301, -0.097924, -0.690062>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 0.606552, -3.05747>
  }
  torus { // Torus273
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.387161, 0.529998, 0.55242>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus274
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.470708, 0.590001, 0.599762>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone263
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.618626, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.207862, -1.206992>
  }
  translate  <0.0, 0.081209, -0.153672>
  scale 0.2401
  translate  <-0.0, -0.019498, -10.177797>
}
#declare tailMseg11 = union {
  sphere { // Sphere600
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone264
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.018093, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone265
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus275
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.503471, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus276
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.539657, 0.607, 0.607239>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus277
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.575842, 0.643, 0.640606>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone266
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone267
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone268
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus278
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus279
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone269
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.343
  translate  <0.0, 0.0, -8.799636>
}
#declare tailMpartM7 = union {
  object { tailMseg10 }
  object { tailMseg11 }
  rotate 0.0*x
  translate  <-0.0, 0.023283, 8.800973>
  rotate <-31.292847, 0.0, -0.0>
  translate  <0.0, -0.023283, -8.800973>
}
#declare tailMseg12 = union {
  sphere { // Sphere601
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone270
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone271
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus280
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.491709, 0.569774, 0.57679>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus281
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.542822, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus282
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone272
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone273
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone274
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus283
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus284
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone275
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.49
  translate  <0.0, 0.0, -6.825016>
}
#declare tailMpartM8 = union {
  object { tailMpartM7 }
  object { tailMseg12 }
  rotate -0.0*x
  translate  <-0.0, -0.008138, 6.841223>
  rotate <41.882164, -0.0, 0.0>
  translate  <0.0, 0.008138, -6.841223>
}
#declare tailMseg13 = union {
  sphere { // Sphere602
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone276
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone277
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus285
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus286
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus287
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone278
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone279
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone280
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus288
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus289
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone281
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.7
  translate  <0.0, 0.0, -3.996833>
}
#declare tailMpartM9 = union {
  object { tailMpartM8 }
  object { tailMseg13 }
  rotate <-0.0, 0.0, 0.0>
  translate  <-0.0, -0.048121, 3.977207>
  rotate <41.364124, -0.0, 0.0>
  translate  <0.0, 0.073518, -3.72317>
}
#declare tailMseg14 = union {
  sphere { // Sphere603
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone282
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone283
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus290
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus291
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus292
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone284
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone285
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone286
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus293
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus294
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone287
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
}
#declare tail2 = union {
  object { tailMpartM9 }
  object { tailMseg14 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.076435, -0.065365>
  scale <1.214286, 1.7, 2.833333>
  rotate <52.305943, -0.0, 90.0>
  translate  <-6.403084, -0.252203, 6.594411>
}
#declare upperMbody2 = union {
  object { torso2 }
  object { basicMarmMleft2 }
  object { basicMarmMright2 }
  object { head2 }
  object { tail2 }
  rotate <-5.973597, 36.540485, -2.863771>
  translate  <-2.274868, 0.0, -1.624906>
}
#declare basicMupperMlimb5 = union {
  sphere { // Sphere604
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1724
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1725
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1726
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.889763, 0.6, 7.957074>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.272689, -0.0, -0.972206>
  }
  cylinder { // Cylndr1727
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1728
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere605
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.227032, 1.0, 1.313549>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere606
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere607
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.088028, 0.897211, 1.451759>
    rotate <-0.210516, -0.012921, -6.567191>
    translate  <-2.579374, -0.301122, -0.209806>
  }
  sphere { // Sphere608
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.402014, 1.951081, 1.903414>
    rotate <0.0, 4.411142, 0.0>
    translate  <-0.640424, 0.35666, -0.478302>
  }
  sphere { // Sphere609
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.748529, 0.423051, 2.390815>
    rotate <174.716705, -80.629654, 176.581375>
    translate  <2.228457, 0.34524, 1.265795>
  }
  torus { // Torus295
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.247004, 0.895005>
    rotate <-47.660999, -86.089897, -0.0>
    translate  <-1.243407, 0.465109, 0.390461>
  }
  torus { // Torus296
    1.3, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.136887, 1.027554>
    rotate <-35.391956, -86.089897, -0.0>
    translate  <0.577974, 0.26271, 0.335131>
  }
  torus { // Torus297
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.22252, 0.912929>
    rotate <-42.451847, -86.089897, -0.0>
    translate  <-0.341099, 0.358058, 0.363051>
  }
  scale <0.8, 1.0, 1.2>
  rotate <0.0, 87.391014, 0.0>
  translate  <-2.902059, 0.0, 5.616888>
}
#declare toeMlowerMpart15 = union {
  sphere { // Sphere617
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere618
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1735
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1736
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone289
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart15 = union {
  sphere { // Sphere619
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere620
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1737
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1738
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe15 = union {
  object { toeMlowerMpart15 }
  object { toeMpart15 }
  scale <3.846327, 6.251647, 2.984955>
  rotate <-104.346291, -0.802354, -89.380188>
  translate  <10.356746, 0.011034, 2.11107>
}
#declare toeMlowerMpart16 = union {
  sphere { // Sphere621
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere622
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1739
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1740
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone290
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart16 = union {
  sphere { // Sphere623
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere624
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1741
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1742
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe16 = union {
  object { toeMlowerMpart16 }
  object { toeMpart16 }
  scale <3.817335, 6.252286, 3.007317>
  rotate <-95.292099, 1.427575, -81.559448>
  translate  <10.156489, 0.47757, 1.273319>
}
#declare toeMlowerMpart17 = union {
  sphere { // Sphere625
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere626
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1743
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1744
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone291
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart17 = union {
  sphere { // Sphere627
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere628
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1745
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1746
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe17 = union {
  object { toeMlowerMpart17 }
  object { toeMpart17 }
  scale <3.835269, 6.246415, 2.996068>
  rotate <-95.305641, -2.794001, -95.775719>
  translate  <10.170376, -0.548809, 1.732482>
}
#declare foot5 = union {
  sphere { // Sphere615
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.104823, 0.954575, 0.702369>
    rotate <-0.0, 17.439234, -0.0>
    translate  <10.410911, 0.0, 0.865005>
  }
  cone { // Cone288
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <0.644094, 0.564646, 1.756106>
    rotate <180.0, 78.781219, 180.0>
    translate  <7.487469, 0.0, 2.592187>
  }
  sphere { // Sphere616
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.757855, 0.850708, 1.307657>
    rotate <-0.0, -15.639227, 0.0>
    translate  <9.65996, 0.0, 1.614038>
  }
  cylinder { // Cylndr1734
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.468556, 0.6, 1.877972>
    rotate 180.0*z
    translate  <9.475477, -0.019726, 2.093359>
  }
  object { toe15 }
  object { toe16 }
  object { toe17 }
  rotate <-0.0, 6.690316, -0.0>
  translate  <-9.753865, -0.0, -1.855504>
  scale <1.99075, 1.4, 0.845479>
  rotate <180.0, -101.704941, -180.0>
  translate  <9.249519, -0.063675, -0.101697>
}
#declare basicMlowerMlimb5 = union {
  sphere { // Sphere610
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1729
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1730
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1731
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1732
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1733
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere611
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere612
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere613
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  sphere { // Sphere614
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.175285, 0.552123, 1.745987>
    rotate <0.0, 82.934669, 0.0>
    translate  <-0.304845, -0.0, 0.620477>
  }
  object { foot5 }
  sphere { // Sphere629
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.121197, 0.756362, -0.365819>
  }
  rotate 5.889341*y
  translate  <0.038422, 0.0, 0.372483>
  rotate <-3.396867, -242.453308, -2.00318>
  translate  <-2.714829, 0.0, -0.468074>
}
#declare basicMlegMleft2 = union {
  object { basicMupperMlimb5 }
  object { basicMlowerMlimb5 }
  rotate <-0.0, -0.0, 0.0>
  translate  <3.337407, 0.0, -5.623791>
  scale <1.2, -1.3, 1.3>
  rotate <-171.741989, -211.894379, -175.907791>
  translate  <-4.232837, 3.356687, 6.081297>
}
union { // alien2
  object { basicMlegMright2 }
  object { upperMbody2 }
  object { basicMlegMleft2 }
  scale 0.4
  rotate <4.394619, -13.956867, 14.638172>
  translate  <10.415922, 10.200305, 2.086886>
}




#declare wall = union {
  torus { // Torus170
    1.5, 0.05  rotate -x*90
    scale <5.683695, 5.683695, 6.0>
    translate  56.45*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus169
    1.5, 0.05  rotate -x*90
    scale <5.799689, 5.799689, 6.0>
    translate  55.9*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus168
    1.5, 0.05  rotate -x*90
    scale <5.91805, 5.91805, 6.0>
    translate  55.35*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus167
    1.5, 0.05  rotate -x*90
    scale <6.038826, 6.038826, 6.0>
    translate  54.8*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus166
    1.5, 0.05  rotate -x*90
    scale <6.162068, 6.162068, 6.0>
    translate  54.25*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus165
    1.5, 0.05  rotate -x*90
    scale <6.287825, 6.287825, 6.0>
    translate  53.7*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus164
    1.5, 0.05  rotate -x*90
    scale <6.416147, 6.416147, 6.0>
    translate  53.15*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus163
    1.5, 0.05  rotate -x*90
    scale <6.547089, 6.547089, 6.0>
    translate  52.6*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus162
    1.5, 0.05  rotate -x*90
    scale <6.680703, 6.680703, 6.0>
    translate  52.05*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus161
    1.5, 0.05  rotate -x*90
    scale <6.817044, 6.817044, 6.0>
    translate  51.5*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus160
    1.5, 0.05  rotate -x*90
    scale <6.956167, 6.956167, 6.0>
    translate  50.95*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus159
    1.5, 0.05  rotate -x*90
    scale <7.09813, 7.09813, 6.0>
    translate  50.4*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus158
    1.5, 0.05  rotate -x*90
    scale <7.24299, 7.24299, 6.0>
    translate  49.85*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus157
    1.5, 0.05  rotate -x*90
    scale <7.390806, 7.390806, 6.0>
    translate  49.3*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus156
    1.5, 0.05  rotate -x*90
    scale <7.541639, 7.541639, 6.0>
    translate  48.75*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus155
    1.5, 0.05  rotate -x*90
    scale <7.695549, 7.695549, 6.0>
    translate  48.2*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus154
    1.5, 0.05  rotate -x*90
    scale <7.852602, 7.852602, 6.0>
    translate  47.65*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus153
    1.5, 0.05  rotate -x*90
    scale <8.012859, 8.012859, 6.0>
    translate  47.1*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus152
    1.5, 0.05  rotate -x*90
    scale <8.176387, 8.176387, 6.0>
    translate  46.55*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus151
    1.5, 0.05  rotate -x*90
    scale <8.343251, 8.343251, 6.0>
    translate  46.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus150
    1.5, 0.05  rotate -x*90
    scale <8.513522, 8.513522, 6.0>
    translate  45.45*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus149
    1.5, 0.05  rotate -x*90
    scale <8.687267, 8.687267, 6.0>
    translate  44.9*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus148
    1.5, 0.05  rotate -x*90
    scale <8.864558, 8.864558, 6.0>
    translate  44.35*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus147
    1.5, 0.05  rotate -x*90
    scale <9.045468, 9.045468, 6.0>
    translate  43.8*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus146
    1.5, 0.05  rotate -x*90
    scale <9.230069, 9.230069, 6.0>
    translate  43.25*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus145
    1.5, 0.05  rotate -x*90
    scale <9.418438, 9.418438, 6.0>
    translate  42.7*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus144
    1.5, 0.05  rotate -x*90
    scale <9.610651, 9.610651, 6.0>
    translate  42.15*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus143
    1.5, 0.05  rotate -x*90
    scale <9.806787, 9.806787, 6.0>
    translate  41.6*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus142
    1.5, 0.05  rotate -x*90
    scale <10.006926, 10.006926, 6.0>
    translate  41.05*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus141
    1.5, 0.05  rotate -x*90
    scale <10.211148, 10.211148, 6.0>
    translate  40.5*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus140
    1.5, 0.05  rotate -x*90
    scale <10.419539, 10.419539, 6.0>
    translate  39.95*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus139
    1.5, 0.05  rotate -x*90
    scale <10.632183, 10.632183, 6.0>
    translate  39.4*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus138
    1.5, 0.05  rotate -x*90
    scale <10.849166, 10.849166, 6.0>
    translate  38.85*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus137
    1.5, 0.05  rotate -x*90
    scale <11.070578, 11.070578, 6.0>
    translate  38.3*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus136
    1.5, 0.05  rotate -x*90
    scale <11.296508, 11.296508, 6.0>
    translate  37.75*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus135
    1.5, 0.05  rotate -x*90
    scale <11.527049, 11.527049, 6.0>
    translate  37.2*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus134
    1.5, 0.05  rotate -x*90
    scale <11.762295, 11.762295, 6.0>
    translate  36.65*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus133
    1.5, 0.05  rotate -x*90
    scale <12.002341, 12.002341, 6.0>
    translate  36.1*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus132
    1.5, 0.05  rotate -x*90
    scale <12.247288, 12.247288, 6.0>
    translate  35.55*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus131
    1.5, 0.05  rotate -x*90
    scale <12.497232, 12.497232, 6.0>
    translate  35.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus130
    1.5, 0.05  rotate -x*90
    scale <12.752277, 12.752277, 6.0>
    translate  34.45*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus129
    1.5, 0.05  rotate -x*90
    scale <13.012528, 13.012528, 6.0>
    translate  33.9*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus128
    1.5, 0.05  rotate -x*90
    scale <13.27809, 13.27809, 6.0>
    translate  33.35*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus127
    1.5, 0.05  rotate -x*90
    scale <13.549071, 13.549071, 6.0>
    translate  32.8*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus126
    1.5, 0.05  rotate -x*90
    scale <13.825583, 13.825583, 6.0>
    translate  32.25*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus125
    1.5, 0.05  rotate -x*90
    scale <14.107738, 14.107738, 6.0>
    translate  31.7*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus124
    1.5, 0.05  rotate -x*90
    scale <14.395651, 14.395651, 6.0>
    translate  31.15*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus123
    1.5, 0.05  rotate -x*90
    scale <14.68944, 14.68944, 6.0>
    translate  30.6*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus122
    1.5, 0.05  rotate -x*90
    scale <14.989224, 14.989224, 6.0>
    translate  30.05*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus121
    1.5, 0.05  rotate -x*90
    scale <15.295127, 15.295127, 6.0>
    translate  29.5*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus120
    1.5, 0.05  rotate -x*90
    scale <15.607272, 15.607272, 6.0>
    translate  28.95*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus119
    1.5, 0.05  rotate -x*90
    scale <15.925788, 15.925788, 6.0>
    translate  28.4*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus118
    1.5, 0.05  rotate -x*90
    scale <16.250803, 16.250803, 6.0>
    translate  27.85*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus117
    1.5, 0.05  rotate -x*90
    scale <16.582453, 16.582453, 6.0>
    translate  27.3*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus116
    1.5, 0.05  rotate -x*90
    scale <16.92087, 16.92087, 6.0>
    translate  26.75*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus115
    1.5, 0.1  rotate -x*90
    scale <17.266193, 17.266193, 6.0>
    translate  26.2*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus114
    1.5, 0.05  rotate -x*90
    scale <17.618565, 17.618565, 6.0>
    translate  25.65*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus113
    1.5, 0.05  rotate -x*90
    scale <17.978128, 17.978128, 6.0>
    translate  25.1*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus112
    1.5, 0.05  rotate -x*90
    scale <18.345028, 18.345028, 6.0>
    translate  24.55*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus111
    1.5, 0.05  rotate -x*90
    scale <18.719418, 18.719418, 6.0>
    translate  24.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus110
    1.5, 0.05  rotate -x*90
    scale <19.101446, 19.101446, 6.0>
    translate  23.45*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus109
    1.5, 0.05  rotate -x*90
    scale <19.491272, 19.491272, 6.0>
    translate  22.9*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus108
    1.5, 0.05  rotate -x*90
    scale <19.0, 19.0, 8.0>
    translate  22.35*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus107
    1.5, 0.05  rotate -x*90
    scale <20.29495, 20.29495, 6.0>
    translate  21.8*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus106
    1.5, 0.05  rotate -x*90
    scale <20.709133, 20.709133, 6.0>
    translate  21.25*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus105
    1.5, 0.05  rotate -x*90
    scale <21.131769, 21.131769, 6.0>
    translate  20.7*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus104
    1.5, 0.05  rotate -x*90
    scale <21.56303, 21.56303, 6.0>
    translate  20.15*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus103
    1.5, 0.05  rotate -x*90
    scale <22.003092, 22.003092, 6.0>
    translate  19.6*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus064
    1.5, 0.05  rotate -x*90
    scale <22.452135, 22.452135, 6.0>
    translate  19.05*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus063
    1.5, 0.05  rotate -x*90
    scale <22.910341, 22.910341, 6.0>
    translate  18.5*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus062
    1.5, 0.1  rotate -x*90
    scale <23.377899, 23.377899, 6.0>
    translate  17.95*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus061
    1.5, 0.05  rotate -x*90
    scale <23.855, 23.855, 6.0>
    translate  17.4*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus060
    1.5, 0.05  rotate -x*90
    scale <24.341837, 24.341837, 6.0>
    translate  16.85*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus059
    1.5, 0.05  rotate -x*90
    scale <24.838608, 24.838608, 6.0>
    translate  16.3*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus058
    1.5, 0.05  rotate -x*90
    scale <25.345518, 25.345518, 6.0>
    translate  15.75*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus057
    1.5, 0.05  rotate -x*90
    scale <25.862774, 25.862774, 6.0>
    translate  15.2*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus056
    1.5, 0.05  rotate -x*90
    scale <26.390585, 26.390585, 6.0>
    translate  14.65*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus055
    1.5, 0.05  rotate -x*90
    scale <26.929169, 26.929169, 6.0>
    translate  14.1*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus054
    1.5, 0.05  rotate -x*90
    scale <27.478745, 27.478745, 6.0>
    translate  13.55*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus053
    1.5, 0.05  rotate -x*90
    scale <28.039536, 28.039536, 6.0>
    translate  13.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus052
    1.5, 0.05  rotate -x*90
    scale <28.611771, 28.611771, 6.0>
    translate  12.45*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus051
    1.5, 0.05  rotate -x*90
    scale <29.195684, 29.195684, 6.0>
    translate  11.9*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus050
    1.5, 0.05  rotate -x*90
    scale <29.791513, 29.791513, 6.0>
    translate  11.35*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus049
    1.5, 0.1  rotate -x*90
    scale <29.0, 29.0, 6.0>
    translate  10.8*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus048
    1.5, 0.05  rotate -x*90
    scale <31.019903, 31.019903, 6.0>
    translate  10.25*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus047
    1.5, 0.05  rotate -x*90
    scale <31.652962, 31.652962, 6.0>
    translate  9.7*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus046
    1.5, 0.05  rotate -x*90
    scale <32.298939, 32.298939, 6.0>
    translate  9.15*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus045
    1.5, 0.05  rotate -x*90
    scale <32.958103, 32.958103, 6.0>
    translate  8.6*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus044
    1.5, 0.05  rotate -x*90
    scale <33.630718, 33.630718, 6.0>
    translate  8.05*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus043
    1.5, 0.05  rotate -x*90
    scale <34.317059, 34.317059, 6.0>
    translate  7.5*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus042
    1.5, 0.05  rotate -x*90
    scale <35.017406, 35.017406, 6.0>
    translate  6.95*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus041
    1.5, 0.2  rotate -x*90
    scale <35.732048, 35.732048, 6.0>
    translate  6.4*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus040
    1.5, 0.05  rotate -x*90
    scale <35.0, 35.0, 6.0>
    translate  5.85*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus039
    1.5, 0.05  rotate -x*90
    scale <37.205379, 37.205379, 6.0>
    translate  5.3*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus022
    1.5, 0.05  rotate -x*90
    scale <37.964672, 37.964672, 6.0>
    translate  4.75*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus021
    1.5, 0.05  rotate -x*90
    scale <38.739464, 38.739464, 6.0>
    translate  4.2*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus020
    1.5, 0.05  rotate -x*90
    scale <39.530064, 39.530064, 6.0>
    translate  3.65*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus019
    1.5, 0.05  rotate -x*90
    scale <40.3368, 40.3368, 6.0>
    translate  3.1*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus018
    1.5, 0.05  rotate -x*90
    scale <41.16, 41.16, 6.0>
    translate  2.55*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus017
    1.5, 0.05  rotate -x*90
    scale <42.0, 42.0, 6.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
}
#declare pipeMseg210 = union {
  sphere { // Sphere211
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg211 = union {
  sphere { // Sphere212
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg212 = union {
  sphere { // Sphere213
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg213 = union {
  sphere { // Sphere214
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg214 = union {
  sphere { // Sphere215
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe42 = union {
  object { pipeMseg210 }
  object { pipeMseg211 }
  object { pipeMseg212 }
  object { pipeMseg213 }
  object { pipeMseg214 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate -13.165925*z
  translate  <0.942841, 4.278043, 0.0>
}
#declare pipeMseg205 = union {
  sphere { // Sphere206
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg206 = union {
  sphere { // Sphere207
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg207 = union {
  sphere { // Sphere208
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg208 = union {
  sphere { // Sphere209
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg209 = union {
  sphere { // Sphere210
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe41 = union {
  object { pipeMseg205 }
  object { pipeMseg206 }
  object { pipeMseg207 }
  object { pipeMseg208 }
  object { pipeMseg209 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate 18.611574*z
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMseg200 = union {
  sphere { // Sphere201
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg201 = union {
  sphere { // Sphere202
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg202 = union {
  sphere { // Sphere203
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg203 = union {
  sphere { // Sphere204
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg204 = union {
  sphere { // Sphere205
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe40 = union {
  object { pipeMseg200 }
  object { pipeMseg201 }
  object { pipeMseg202 }
  object { pipeMseg203 }
  object { pipeMseg204 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate 56.214088*z
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMseg195 = union {
  sphere { // Sphere196
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg196 = union {
  sphere { // Sphere197
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg197 = union {
  sphere { // Sphere198
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg198 = union {
  sphere { // Sphere199
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg199 = union {
  sphere { // Sphere200
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe39 = union {
  object { pipeMseg195 }
  object { pipeMseg196 }
  object { pipeMseg197 }
  object { pipeMseg198 }
  object { pipeMseg199 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate 65.18647*z
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMseg190 = union {
  sphere { // Sphere191
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg191 = union {
  sphere { // Sphere192
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg192 = union {
  sphere { // Sphere193
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg193 = union {
  sphere { // Sphere194
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg194 = union {
  sphere { // Sphere195
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe38 = union {
  object { pipeMseg190 }
  object { pipeMseg191 }
  object { pipeMseg192 }
  object { pipeMseg193 }
  object { pipeMseg194 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate 134.064377*z
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMseg185 = union {
  sphere { // Sphere186
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg186 = union {
  sphere { // Sphere187
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg187 = union {
  sphere { // Sphere188
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg188 = union {
  sphere { // Sphere189
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg189 = union {
  sphere { // Sphere190
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe37 = union {
  object { pipeMseg185 }
  object { pipeMseg186 }
  object { pipeMseg187 }
  object { pipeMseg188 }
  object { pipeMseg189 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate 155.147125*z
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMseg180 = union {
  sphere { // Sphere181
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg181 = union {
  sphere { // Sphere182
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg182 = union {
  sphere { // Sphere183
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg183 = union {
  sphere { // Sphere184
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg184 = union {
  sphere { // Sphere185
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe36 = union {
  object { pipeMseg180 }
  object { pipeMseg181 }
  object { pipeMseg182 }
  object { pipeMseg183 }
  object { pipeMseg184 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate -135.920914*z
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMseg175 = union {
  sphere { // Sphere176
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg176 = union {
  sphere { // Sphere177
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg177 = union {
  sphere { // Sphere178
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg178 = union {
  sphere { // Sphere179
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg179 = union {
  sphere { // Sphere180
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe35 = union {
  object { pipeMseg175 }
  object { pipeMseg176 }
  object { pipeMseg177 }
  object { pipeMseg178 }
  object { pipeMseg179 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate -120.0*z
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMseg170 = union {
  sphere { // Sphere171
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg171 = union {
  sphere { // Sphere172
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg172 = union {
  sphere { // Sphere173
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg173 = union {
  sphere { // Sphere174
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg174 = union {
  sphere { // Sphere175
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe34 = union {
  object { pipeMseg170 }
  object { pipeMseg171 }
  object { pipeMseg172 }
  object { pipeMseg173 }
  object { pipeMseg174 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate -85.977859*z
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMseg165 = union {
  sphere { // Sphere166
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg166 = union {
  sphere { // Sphere167
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg167 = union {
  sphere { // Sphere168
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg168 = union {
  sphere { // Sphere169
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg169 = union {
  sphere { // Sphere170
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe33 = union {
  object { pipeMseg165 }
  object { pipeMseg166 }
  object { pipeMseg167 }
  object { pipeMseg168 }
  object { pipeMseg169 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  rotate -53.367523*z
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMseg150 = union {
  sphere { // Sphere151
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg151 = union {
  sphere { // Sphere152
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg152 = union {
  sphere { // Sphere153
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg153 = union {
  sphere { // Sphere154
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg154 = union {
  sphere { // Sphere155
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe30 = union {
  object { pipeMseg150 }
  object { pipeMseg151 }
  object { pipeMseg152 }
  object { pipeMseg153 }
  object { pipeMseg154 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg155 = union {
  sphere { // Sphere156
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg156 = union {
  sphere { // Sphere157
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg157 = union {
  sphere { // Sphere158
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg158 = union {
  sphere { // Sphere159
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg159 = union {
  sphere { // Sphere160
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe31 = union {
  object { pipeMseg155 }
  object { pipeMseg156 }
  object { pipeMseg157 }
  object { pipeMseg158 }
  object { pipeMseg159 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg160 = union {
  sphere { // Sphere161
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg161 = union {
  sphere { // Sphere162
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg162 = union {
  sphere { // Sphere163
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg163 = union {
  sphere { // Sphere164
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg164 = union {
  sphere { // Sphere165
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe32 = union {
  object { pipeMseg160 }
  object { pipeMseg161 }
  object { pipeMseg162 }
  object { pipeMseg163 }
  object { pipeMseg164 }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup10 = union {
  object { pipe30 }
  object { pipe31 }
  object { pipe32 }
  rotate -0.0*z
  translate  0.0*y
  rotate -40.0*z
}
#declare pipeMseg135 = union {
  sphere { // Sphere136
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg136 = union {
  sphere { // Sphere137
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg137 = union {
  sphere { // Sphere138
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg138 = union {
  sphere { // Sphere139
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg139 = union {
  sphere { // Sphere140
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe27 = union {
  object { pipeMseg135 }
  object { pipeMseg136 }
  object { pipeMseg137 }
  object { pipeMseg138 }
  object { pipeMseg139 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg140 = union {
  sphere { // Sphere141
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg141 = union {
  sphere { // Sphere142
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg142 = union {
  sphere { // Sphere143
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg143 = union {
  sphere { // Sphere144
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg144 = union {
  sphere { // Sphere145
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe28 = union {
  object { pipeMseg140 }
  object { pipeMseg141 }
  object { pipeMseg142 }
  object { pipeMseg143 }
  object { pipeMseg144 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg145 = union {
  sphere { // Sphere146
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg146 = union {
  sphere { // Sphere147
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg147 = union {
  sphere { // Sphere148
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg148 = union {
  sphere { // Sphere149
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg149 = union {
  sphere { // Sphere150
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe29 = union {
  object { pipeMseg145 }
  object { pipeMseg146 }
  object { pipeMseg147 }
  object { pipeMseg148 }
  object { pipeMseg149 }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup9 = union {
  object { pipe27 }
  object { pipe28 }
  object { pipe29 }
  rotate -0.0*z
  translate  0.0*y
  rotate -0.0*z
}
#declare pipeMseg120 = union {
  sphere { // Sphere121
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg121 = union {
  sphere { // Sphere122
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg122 = union {
  sphere { // Sphere123
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg123 = union {
  sphere { // Sphere124
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg124 = union {
  sphere { // Sphere125
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe24 = union {
  object { pipeMseg120 }
  object { pipeMseg121 }
  object { pipeMseg122 }
  object { pipeMseg123 }
  object { pipeMseg124 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg125 = union {
  sphere { // Sphere126
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg126 = union {
  sphere { // Sphere127
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg127 = union {
  sphere { // Sphere128
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg128 = union {
  sphere { // Sphere129
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg129 = union {
  sphere { // Sphere130
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe25 = union {
  object { pipeMseg125 }
  object { pipeMseg126 }
  object { pipeMseg127 }
  object { pipeMseg128 }
  object { pipeMseg129 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg130 = union {
  sphere { // Sphere131
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg131 = union {
  sphere { // Sphere132
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg132 = union {
  sphere { // Sphere133
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg133 = union {
  sphere { // Sphere134
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg134 = union {
  sphere { // Sphere135
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe26 = union {
  object { pipeMseg130 }
  object { pipeMseg131 }
  object { pipeMseg132 }
  object { pipeMseg133 }
  object { pipeMseg134 }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup8 = union {
  object { pipe24 }
  object { pipe25 }
  object { pipe26 }
  rotate -0.0*z
  translate  0.0*y
  rotate 40.0*z
}
#declare pipeMseg105 = union {
  sphere { // Sphere106
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg106 = union {
  sphere { // Sphere107
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg107 = union {
  sphere { // Sphere108
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg108 = union {
  sphere { // Sphere109
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg109 = union {
  sphere { // Sphere110
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe21 = union {
  object { pipeMseg105 }
  object { pipeMseg106 }
  object { pipeMseg107 }
  object { pipeMseg108 }
  object { pipeMseg109 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg110 = union {
  sphere { // Sphere111
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg111 = union {
  sphere { // Sphere112
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg112 = union {
  sphere { // Sphere113
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg113 = union {
  sphere { // Sphere114
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg114 = union {
  sphere { // Sphere115
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe22 = union {
  object { pipeMseg110 }
  object { pipeMseg111 }
  object { pipeMseg112 }
  object { pipeMseg113 }
  object { pipeMseg114 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg115 = union {
  sphere { // Sphere116
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg116 = union {
  sphere { // Sphere117
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg117 = union {
  sphere { // Sphere118
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg118 = union {
  sphere { // Sphere119
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg119 = union {
  sphere { // Sphere120
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe23 = union {
  object { pipeMseg115 }
  object { pipeMseg116 }
  object { pipeMseg117 }
  object { pipeMseg118 }
  object { pipeMseg119 }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup7 = union {
  object { pipe21 }
  object { pipe22 }
  object { pipe23 }
  rotate -0.0*z
  translate  0.0*y
  rotate 93.153183*z
}
#declare pipeMseg90 = union {
  sphere { // Sphere091
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg91 = union {
  sphere { // Sphere092
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg92 = union {
  sphere { // Sphere093
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg93 = union {
  sphere { // Sphere094
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg94 = union {
  sphere { // Sphere095
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe18 = union {
  object { pipeMseg90 }
  object { pipeMseg91 }
  object { pipeMseg92 }
  object { pipeMseg93 }
  object { pipeMseg94 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg95 = union {
  sphere { // Sphere096
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg96 = union {
  sphere { // Sphere097
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg97 = union {
  sphere { // Sphere098
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg98 = union {
  sphere { // Sphere099
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg99 = union {
  sphere { // Sphere100
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe19 = union {
  object { pipeMseg95 }
  object { pipeMseg96 }
  object { pipeMseg97 }
  object { pipeMseg98 }
  object { pipeMseg99 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg100 = union {
  sphere { // Sphere101
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg101 = union {
  sphere { // Sphere102
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg102 = union {
  sphere { // Sphere103
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg103 = union {
  sphere { // Sphere104
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg104 = union {
  sphere { // Sphere105
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe20 = union {
  object { pipeMseg100 }
  object { pipeMseg101 }
  object { pipeMseg102 }
  object { pipeMseg103 }
  object { pipeMseg104 }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup6 = union {
  object { pipe18 }
  object { pipe19 }
  object { pipe20 }
  rotate -0.0*z
  translate  0.0*y
  rotate 120.0*z
}
#declare pipeMseg75 = union {
  sphere { // Sphere076
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg76 = union {
  sphere { // Sphere077
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg77 = union {
  sphere { // Sphere078
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg78 = union {
  sphere { // Sphere079
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg79 = union {
  sphere { // Sphere080
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe15 = union {
  object { pipeMseg75 }
  object { pipeMseg76 }
  object { pipeMseg77 }
  object { pipeMseg78 }
  object { pipeMseg79 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg80 = union {
  sphere { // Sphere081
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg81 = union {
  sphere { // Sphere082
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg82 = union {
  sphere { // Sphere083
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg83 = union {
  sphere { // Sphere084
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg84 = union {
  sphere { // Sphere085
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe16 = union {
  object { pipeMseg80 }
  object { pipeMseg81 }
  object { pipeMseg82 }
  object { pipeMseg83 }
  object { pipeMseg84 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg85 = union {
  sphere { // Sphere086
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg86 = union {
  sphere { // Sphere087
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg87 = union {
  sphere { // Sphere088
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg88 = union {
  sphere { // Sphere089
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg89 = union {
  sphere { // Sphere090
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe17 = union {
  object { pipeMseg85 }
  object { pipeMseg86 }
  object { pipeMseg87 }
  object { pipeMseg88 }
  object { pipeMseg89 }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup5 = union {
  object { pipe15 }
  object { pipe16 }
  object { pipe17 }
  rotate -0.0*z
  translate  0.0*y
  rotate 172.122971*z
}
#declare pipeMseg60 = union {
  sphere { // Sphere061
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg61 = union {
  sphere { // Sphere062
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg62 = union {
  sphere { // Sphere063
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg63 = union {
  sphere { // Sphere064
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg64 = union {
  sphere { // Sphere065
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe12 = union {
  object { pipeMseg60 }
  object { pipeMseg61 }
  object { pipeMseg62 }
  object { pipeMseg63 }
  object { pipeMseg64 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg65 = union {
  sphere { // Sphere066
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg66 = union {
  sphere { // Sphere067
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg67 = union {
  sphere { // Sphere068
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg68 = union {
  sphere { // Sphere069
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg69 = union {
  sphere { // Sphere070
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe13 = union {
  object { pipeMseg65 }
  object { pipeMseg66 }
  object { pipeMseg67 }
  object { pipeMseg68 }
  object { pipeMseg69 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg70 = union {
  sphere { // Sphere071
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg71 = union {
  sphere { // Sphere072
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg72 = union {
  sphere { // Sphere073
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg73 = union {
  sphere { // Sphere074
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg74 = union {
  sphere { // Sphere075
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe14 = union {
  object { pipeMseg70 }
  object { pipeMseg71 }
  object { pipeMseg72 }
  object { pipeMseg73 }
  object { pipeMseg74 }
  rotate 0.0*z
  translate  <0.156855, 36.124486, 0.0>
  scale <1.0, 0.5, 1.0>
  translate  <-0.121322, -0.333329, 0.0>
}
#declare pipeMgroup4 = union {
  object { pipe12 }
  object { pipe13 }
  object { pipe14 }
  rotate -0.0*z
  translate  0.0*y
  rotate -160.0*z
}
#declare pipeMseg45 = union {
  sphere { // Sphere046
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg46 = union {
  sphere { // Sphere047
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg47 = union {
  sphere { // Sphere048
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg48 = union {
  sphere { // Sphere049
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg49 = union {
  sphere { // Sphere050
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe9 = union {
  object { pipeMseg45 }
  object { pipeMseg46 }
  object { pipeMseg47 }
  object { pipeMseg48 }
  object { pipeMseg49 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg50 = union {
  sphere { // Sphere051
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg51 = union {
  sphere { // Sphere052
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg52 = union {
  sphere { // Sphere053
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg53 = union {
  sphere { // Sphere054
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg54 = union {
  sphere { // Sphere055
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe10 = union {
  object { pipeMseg50 }
  object { pipeMseg51 }
  object { pipeMseg52 }
  object { pipeMseg53 }
  object { pipeMseg54 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg55 = union {
  sphere { // Sphere056
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg56 = union {
  sphere { // Sphere057
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg57 = union {
  sphere { // Sphere058
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg58 = union {
  sphere { // Sphere059
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg59 = union {
  sphere { // Sphere060
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe11 = union {
  object { pipeMseg55 }
  object { pipeMseg56 }
  object { pipeMseg57 }
  object { pipeMseg58 }
  object { pipeMseg59 }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup3 = union {
  object { pipe9 }
  object { pipe10 }
  object { pipe11 }
  rotate -0.0*z
  translate  0.0*y
  rotate -104.025558*z
}
#declare pipeMseg30 = union {
  sphere { // Sphere031
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg31 = union {
  sphere { // Sphere032
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg32 = union {
  sphere { // Sphere033
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg33 = union {
  sphere { // Sphere034
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg34 = union {
  sphere { // Sphere035
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe6 = union {
  object { pipeMseg30 }
  object { pipeMseg31 }
  object { pipeMseg32 }
  object { pipeMseg33 }
  object { pipeMseg34 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg35 = union {
  sphere { // Sphere036
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg36 = union {
  sphere { // Sphere037
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg37 = union {
  sphere { // Sphere038
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg38 = union {
  sphere { // Sphere039
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg39 = union {
  sphere { // Sphere040
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe7 = union {
  object { pipeMseg35 }
  object { pipeMseg36 }
  object { pipeMseg37 }
  object { pipeMseg38 }
  object { pipeMseg39 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg40 = union {
  sphere { // Sphere041
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg41 = union {
  sphere { // Sphere042
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg42 = union {
  sphere { // Sphere043
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg43 = union {
  sphere { // Sphere044
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg44 = union {
  sphere { // Sphere045
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe8 = union {
  object { pipeMseg40 }
  object { pipeMseg41 }
  object { pipeMseg42 }
  object { pipeMseg43 }
  object { pipeMseg44 }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup2 = union {
  object { pipe6 }
  object { pipe7 }
  object { pipe8 }
  rotate -0.0*z
  translate  0.0*y
  rotate -72.390137*z
}
#declare pipeMseg15 = union {
  sphere { // Sphere016
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg16 = union {
  sphere { // Sphere017
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg17 = union {
  sphere { // Sphere018
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg18 = union {
  sphere { // Sphere019
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg19 = union {
  sphere { // Sphere020
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe3 = union {
  object { pipeMseg15 }
  object { pipeMseg16 }
  object { pipeMseg17 }
  object { pipeMseg18 }
  object { pipeMseg19 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg20 = union {
  sphere { // Sphere021
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg21 = union {
  sphere { // Sphere022
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg22 = union {
  sphere { // Sphere023
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg23 = union {
  sphere { // Sphere024
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg24 = union {
  sphere { // Sphere025
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe4 = union {
  object { pipeMseg20 }
  object { pipeMseg21 }
  object { pipeMseg22 }
  object { pipeMseg23 }
  object { pipeMseg24 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg25 = union {
  sphere { // Sphere026
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg26 = union {
  sphere { // Sphere027
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg27 = union {
  sphere { // Sphere028
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg28 = union {
  sphere { // Sphere029
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg29 = union {
  sphere { // Sphere030
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe5 = union {
  object { pipeMseg25 }
  object { pipeMseg26 }
  object { pipeMseg27 }
  object { pipeMseg28 }
  object { pipeMseg29 }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup1 = union {
  object { pipe3 }
  object { pipe4 }
  object { pipe5 }
  rotate -0.0*z
  translate  0.0*y
  rotate -25.235479*z
}
#declare pipeMseg10 = union {
  sphere { // Sphere011
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg11 = union {
  sphere { // Sphere012
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg12 = union {
  sphere { // Sphere013
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg13 = union {
  sphere { // Sphere014
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg14 = union {
  sphere { // Sphere015
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe2 = union {
  object { pipeMseg10 }
  object { pipeMseg11 }
  object { pipeMseg12 }
  object { pipeMseg13 }
  object { pipeMseg14 }
  scale <0.5, 1.0, 1.0>
}
#declare pipeMseg5 = union {
  sphere { // Sphere006
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg6 = union {
  sphere { // Sphere007
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg7 = union {
  sphere { // Sphere008
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg8 = union {
  sphere { // Sphere009
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg9 = union {
  sphere { // Sphere010
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe1 = union {
  object { pipeMseg5 }
  object { pipeMseg6 }
  object { pipeMseg7 }
  object { pipeMseg8 }
  object { pipeMseg9 }
  scale <0.5, 1.0, 1.0>
  rotate -2.953104*z
  translate  1.418884*x
}
#declare pipeMseg4 = union {
  sphere { // Sphere005
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  40.0*y
}
#declare pipeMseg3 = union {
  sphere { // Sphere004
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  30.0*y
}
#declare pipeMseg2 = union {
  sphere { // Sphere003
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  20.0*y
}
#declare pipeMseg1 = union {
  sphere { // Sphere002
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
  translate  10.0*y
}
#declare pipeMseg = union {
  sphere { // Sphere001
    <0,0,0>,1
    material {
      alienMhullMroughMglobal
    }
    scale 1.5
    translate  <0.0, 10.0, 2.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare pipe = union {
  object { pipeMseg4 }
  object { pipeMseg3 }
  object { pipeMseg2 }
  object { pipeMseg1 }
  object { pipeMseg }
  scale <0.5, 1.0, 1.0>
  rotate 2.186704*z
  translate  -1.773605*x
}
#declare pipeMgroup = union {
  object { pipe2 }
  object { pipe1 }
  object { pipe }
  rotate -0.0*z
  translate  0.0*y
}
#declare bottom = union {
  torus { // Torus013
    1.5, 0.1  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <4.0, 4.0, 8.0>
    translate  <-6.384977, 29.087115, 3.0>
  }
  torus { // Torus012
    1.5, 0.1  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <4.0, 4.0, 8.0>
    translate  <-32.279604, 12.060511, 3.0>
  }
  object { pipe42 }
  object { pipe41 }
  object { pipe40 }
  object { pipe39 }
  object { pipe38 }
  object { pipe37 }
  object { pipe36 }
  object { pipe35 }
  object { pipe34 }
  object { pipe33 }
  object { pipeMgroup10 }
  object { pipeMgroup9 }
  object { pipeMgroup8 }
  object { pipeMgroup7 }
  object { pipeMgroup6 }
  object { pipeMgroup5 }
  object { pipeMgroup4 }
  object { pipeMgroup3 }
  object { pipeMgroup2 }
  object { pipeMgroup1 }
  object { pipeMgroup }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMhullMroughMglobal
    }
    scale <7.0, 7.0, 1.0>
    translate  1.5*z
  }
  torus { // Torus011
    1.5, 0.03  rotate -x*90
    scale <30.599689, 30.599689, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus010
    1.5, 0.02  rotate -x*90
    scale <27.8179, 27.8179, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus009
    1.5, 0.03  rotate -x*90
    scale <25.289, 25.289, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus008
    1.5, 0.03  rotate -x*90
    scale <22.99, 22.99, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus007
    1.5, 0.03  rotate -x*90
    scale <20.9, 20.9, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus006
    1.5, 0.05  rotate -x*90
    scale <19.0, 19.0, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus005
    1.5, 0.02  rotate -x*90
    scale <14.641, 14.641, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus004
    1.5, 0.03  rotate -x*90
    scale <13.31, 13.31, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus003
    1.5, 0.05  rotate -x*90
    scale <12.1, 12.1, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus002
    1.5, 0.02  rotate -x*90
    scale <11.0, 11.0, 10.0>
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus001
    1.5, 0.03  rotate -x*90
    scale 10.0
    translate  2.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  plane { // Plane001
    z,0
    hollow
    scale 59.640621
    translate  <0.0, -0.718759, 1.078138>
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <0.0, 0.641008, -0.641008>
      scale <1.0/1.2, 1.0/1.2, 1.0/0.5>
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus016
    1.5, 0.1  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <3.333333, 3.333333, 16.0>
    translate  <27.786471, 9.993397, 4.717984>
  }
  torus { // Torus014
    1.5, 0.1  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <3.333333, 3.333333, 16.0>
    translate  <15.962441, -12.47226, 4.717984>
  }
  torus { // Torus015
    1.5, 0.1  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <3.333333, 3.333333, 16.0>
    translate  <-12.415232, -26.069895, 4.717984>
  }
  scale <1.2, 1.2, 0.5>
  translate  <0.0, -0.641008, 0.641008>
}
#declare pillars = union {
  torus { // Torus171
    1.5, 0.05  rotate -x*90
    scale <5.570021, 5.570021, 6.0>
    translate  57.0*z
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus172
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.829079, 5.823048, 1.839474>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus173
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-90.089439, 5.809561, -10.934798>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus174
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-90.021141, 5.816516, -13.889515>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus175
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.940659, 5.757873, -16.447212>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus176
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-90.177788, 5.796897, -28.595314>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus177
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-90.114006, 5.806456, -31.673361>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus178
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-90.375885, 5.753011, -44.645069>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus179
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-90.315445, 5.768731, -47.783253>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus180
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.890808, 5.823033, 5.0>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus181
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.598541, 5.805587, 18.732754>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus182
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.658867, 5.812845, 21.922129>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus183
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.33786, 5.751544, 36.673462>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus184
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.397438, 5.76723, 39.837433>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus185
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.379074, 5.762611, 45.401836>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus186
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.141075, 5.684736, 57.871662>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus187
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-89.173889, 5.697539, 61.821846>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus188
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-88.891167, 5.562957, 76.1698>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
  torus { // Torus189
    1.5, 0.02  rotate -x*90
    rotate <0.0, -0.0, 0.0>
    translate  <-1.607157, 0.274362, 0.0>
    scale <76.901886, 51.46759, 40.0>
    rotate <-88.896194, 5.565876, 80.996193>
    translate  <-0.185386, 0.0, 70.789943>
    material {
      alienMhullMgridMglobal
      // Transform to world space
      translate  <54.44188, -7.413631, 9.041395>
      scale 1.0/4.0
    }
  }
}
union { // place
  object { wall }
  object { bottom }
  object { pillars }
  scale 4.0
  translate  <-54.44188, 7.413631, -9.041395>
}


#declare basicMupperMlimb = union {
  sphere { // Sphere216
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1357
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1358
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1359
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.889763, 0.6, 7.957074>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.272689, -0.0, -0.972206>
  }
  cylinder { // Cylndr1360
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1361
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere217
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.227032, 1.0, 1.313549>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere218
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere219
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.088028, 0.897211, 1.451759>
    rotate <-0.20454, 0.006653, -6.376747>
    translate  <-2.579374, -0.301122, -0.209806>
  }
  sphere { // Sphere220
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.402014, 1.951081, 1.903414>
    rotate <0.0, 4.411142, 0.0>
    translate  <-0.640424, 0.35666, -0.478302>
  }
  sphere { // Sphere221
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.748529, 0.423051, 2.390815>
    rotate <174.716705, -80.629654, 176.581375>
    translate  <2.228457, 0.34524, 1.265795>
  }
  torus { // Torus023
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.247004, 0.895005>
    rotate <-47.660999, -86.089897, -0.0>
    translate  <-1.243407, 0.465109, 0.390461>
  }
  torus { // Torus024
    1.3, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.136887, 1.027554>
    rotate <-35.391956, -86.089897, -0.0>
    translate  <0.577974, 0.26271, 0.335131>
  }
  torus { // Torus025
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.22252, 0.912929>
    rotate <-42.451847, -86.089897, -0.0>
    translate  <-0.341099, 0.358058, 0.363051>
  }
  scale <0.8, 1.0, 1.2>
  rotate <0.0, 87.391014, 0.0>
  translate  <-2.902059, 0.0, 5.616888>
}
#declare toeMlowerMpart = union {
  sphere { // Sphere229
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere230
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1368
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1369
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone016
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart = union {
  sphere { // Sphere231
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere232
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1370
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1371
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe = union {
  object { toeMlowerMpart }
  object { toeMpart }
  scale <3.846327, 6.251647, 2.984955>
  rotate <-105.290733, -0.790473, -89.373299>
  translate  <10.30372, 0.011034, 2.120341>
}
#declare toeMlowerMpart1 = union {
  sphere { // Sphere233
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere234
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1372
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1373
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone017
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart1 = union {
  sphere { // Sphere235
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere236
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1374
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1375
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe1 = union {
  object { toeMlowerMpart1 }
  object { toeMpart1 }
  scale <3.817335, 6.252286, 3.007317>
  rotate <-95.292099, 1.427575, -81.559448>
  translate  <10.156489, 0.47757, 1.273319>
}
#declare toeMlowerMpart2 = union {
  sphere { // Sphere237
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere238
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1376
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1377
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone018
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart2 = union {
  sphere { // Sphere239
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere240
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1378
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1379
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe2 = union {
  object { toeMlowerMpart2 }
  object { toeMpart2 }
  scale <3.835269, 6.246415, 2.996068>
  rotate <-95.305641, -2.794001, -95.775719>
  translate  <10.170376, -0.548809, 1.732482>
}
#declare foot = union {
  sphere { // Sphere227
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.104823, 0.954575, 0.702369>
    rotate <-0.0, 17.439234, -0.0>
    translate  <10.410911, 0.0, 0.865005>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <0.644094, 0.564646, 1.756106>
    rotate <180.0, 78.781219, 180.0>
    translate  <7.487469, 0.0, 2.592187>
  }
  sphere { // Sphere228
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.757855, 0.850708, 1.307657>
    rotate <-0.0, -15.639227, 0.0>
    translate  <9.65996, 0.0, 1.614038>
  }
  cylinder { // Cylndr1367
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.468556, 0.6, 1.877972>
    rotate 180.0*z
    translate  <9.489619, -0.019726, 1.869243>
  }
  object { toe }
  object { toe1 }
  object { toe2 }
  rotate <-0.0, 6.690316, -0.0>
  translate  <-9.753865, -0.0, -1.855504>
  scale <1.99075, 1.4, 0.845479>
  rotate <0.0, -153.91156, -0.0>
  translate  <9.249519, -0.063675, -0.101697>
}
#declare basicMlowerMlimb = union {
  sphere { // Sphere222
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1362
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1363
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1364
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1365
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1366
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere223
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere224
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere225
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  sphere { // Sphere226
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.082873, 0.552123, 1.709136>
    rotate <0.0, 87.068787, 0.0>
    translate  <0.049581, -0.0, 0.759272>
  }
  object { foot }
  sphere { // Sphere241
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.121197, 0.756362, -0.365819>
  }
  rotate 5.889341*y
  translate  <0.038422, 0.0, 0.372483>
  rotate <-0.0, -214.651245, -0.0>
  translate  <-2.714829, 0.0, -0.468074>
}
#declare basicMlegMright = union {
  object { basicMupperMlimb }
  object { basicMlowerMlimb }
  rotate <-0.0, -0.0, 0.0>
  translate  <3.337407, 0.0, -5.623791>
  scale <1.2, 1.3, 1.3>
  rotate <0.0, -44.684143, -0.0>
  translate  <-2.002818, -3.598145, 5.707071>
}
#declare ribcageMleft = union {
  torus { // Torus026
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.178551, 1.805179, -5.12764>
  }
  torus { // Torus027
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.297019, 1.575937, -6.197968>
  }
  torus { // Torus028
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.181722, 2.001243, -3.90566>
  }
  torus { // Torus029
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.057331, 2.114087, -2.466968>
  }
  torus { // Torus030
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.999426, 2.20132, -1.078089>
  }
  torus { // Torus031
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.067741, 2.226013, -1.794035>
  }
  scale <1.0, -0.9, 1.0>
  rotate 3.609034*z
  translate  <-0.072292, -0.04536, -0.143374>
}
#declare ribcageMright = union {
  torus { // Torus032
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.238894, 1.790511, -4.974797>
  }
  torus { // Torus033
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.183365, 1.511926, -6.147021>
  }
  torus { // Torus034
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.168194, 1.921746, -3.863626>
  }
  torus { // Torus035
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.070659, 2.196042, -2.502768>
  }
  torus { // Torus036
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.910663, 2.344694, -1.01272>
  }
  torus { // Torus037
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.959827, 2.376283, -1.757957>
  }
  scale <1.0, 0.9, 1.0>
  rotate -2.686408*z
  translate  <-0.16194, 0.776374, -0.191991>
}
#declare backhorn3 = union {
  cone { // Cone039
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere251
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone040
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1390
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1391
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <-4.982898, -122.199158, -13.006399>
  translate  <2.991861, -2.831935, -0.52784>
}
#declare backhorn2 = union {
  cone { // Cone037
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere252
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone038
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1392
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1393
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, -0.966641, 0.897271>
  rotate <-5.282954, -123.897797, -11.708396>
  translate  <3.149146, -2.3936, -4.01965>
}
#declare backhorn1 = union {
  cone { // Cone035
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere253
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone036
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1394
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1395
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <3.189699, 2.342453, -4.170216>
}
#declare backhorn = union {
  cone { // Cone034
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere254
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone033
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1396
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1397
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <2.984451, 2.908959, -0.876936>
}
#declare torso = union {
  sphere { // Sphere242
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.431978, 3.640435, -1.571137>
    translate  <0.755961, 0.0, -9.936281>
  }
  sphere { // Sphere243
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.562611, -1.577748, 2.681785>
    rotate <0.0, -7.330361, -0.0>
    translate  <0.28956, -0.0, -9.564097>
  }
  cylinder { // Cylndr1380
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.12583, -0.742838, -11.504373>
    rotate -4.594381*y
    translate  <-1.109086, 0.0, 1.943899>
  }
  object { ribcageMleft }
  object { ribcageMright }
  cylinder { // Cylndr1381
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <12.646627, -7.665387, 8.324436>
    translate  <-0.660863, -2.517925, -2.905298>
  }
  cylinder { // Cylndr1382
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <171.665756, -175.767288, 182.595764>
    translate  <-0.966044, 2.1511, -2.495622>
  }
  sphere { // Sphere244
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.745076, 1.770083, -4.747586>
    rotate <4.042048, 0.185979, 0.521351>
    translate  <0.010811, 2.614042, -5.087942>
  }
  sphere { // Sphere245
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.678328, 1.883597, -5.076229>
    rotate <-1.562712, 0.189786, -0.485653>
    translate  <-0.018209, -2.140103, -5.208063>
  }
  cylinder { // Cylndr1383
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.219531, 0.612627, -9.652758>
    rotate -3.6973*y
    translate  0.390831*x
  }
  cylinder { // Cylndr1384
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.601077, -2.034538, -9.141262>
    rotate <5.172945, -4.044183, -8.660601>
    translate  <0.252768, -1.941129, -0.484216>
  }
  cylinder { // Cylndr1385
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.830165, 1.902151, -9.160878>
    rotate <-2.637861, 0.249879, 11.201634>
    translate  <0.252768, 1.738915, -0.387373>
  }
  sphere { // Sphere246
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <-1.064826, -2.428671, -2.510869>
    rotate -9.444944*z
    translate  <-0.534124, 2.386924, -1.936865>
  }
  sphere { // Sphere247
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.091671, -2.311246, -2.764631>
    rotate 8.449643*z
    translate  <-0.333828, -1.865268, -1.936865>
  }
  sphere { // Sphere248
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.30654, 2.177789, -5.763244>
    translate  <-0.073603, 0.0, -3.776887>
  }
  cylinder { // Cylndr1386
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    translate  <1.001483, -0.034691, -0.861696>
  }
  cylinder { // Cylndr1387
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate <15.484534, -0.0, -0.0>
    translate  <-0.534124, 1.457883, -0.861696>
  }
  cylinder { // Cylndr1388
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate -12.639755*x
    translate  <-0.467359, -1.483702, -0.861696>
  }
  cylinder { // Cylndr1389
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <1.0, 1.0, 3.0>
    translate  -0.861696*z
  }
  sphere { // Sphere249
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, -2.723392, 1.107712>
    rotate 6.808063*x
    translate  <0.0, -3.23136, -0.215424>
  }
  sphere { // Sphere250
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, 2.723392, 1.107712>
    rotate -4.840706*x
    translate  <0.0, 3.123648, -0.215424>
  }
  object { backhorn3 }
  object { backhorn2 }
  object { backhorn1 }
  object { backhorn }
  torus { // Torus038
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.418202, 1.180507>
    rotate <-44.0, 16.0, -167.0>
    translate  <-0.468104, 2.281597, -1.017244>
  }
  torus { // Torus065
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.342479, 1.247094>
    rotate <44.496597, 16.266319, 167.285858>
    translate  <-0.539582, -2.22596, -0.894328>
  }
  torus { // Torus066
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <-64.350632, -197.359482, -170.857941>
    translate  <1.035453, -2.369653, -9.84021>
  }
  torus { // Torus067
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <65.47683, 21.784595, -0.944939>
    translate  <1.034414, 2.657424, -9.785606>
  }
  torus { // Torus068
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, 1.220737, 1.808289>
    rotate <-32.536304, -193.641876, -169.694855>
    translate  <0.710842, -3.17749, -11.183852>
  }
  torus { // Torus069
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, -1.220737, 1.808289>
    rotate <32.536301, -193.641876, -169.694855>
    translate  <0.777046, 3.689119, -11.086957>
  }
  rotate 0.0*y
  translate  <-1.013394, 0.0, 9.373898>
  scale <1.5, 1.1, 1.5>
  rotate <0.0, -13.581846, -180.0>
  translate  <-4.601911, 0.111723, 9.845346>
}
#declare basicMlimb4 = union {
  sphere { // Sphere255
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1398
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1399
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1400
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1401
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1402
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere256
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere257
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere258
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere259
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart4 = union {
  sphere { // Sphere269
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere270
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1412
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1413
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone012
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart4 = union {
  sphere { // Sphere271
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere272
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1414
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1415
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger4 = union {
  object { fingerMlowerMpart4 }
  object { fingerMpart4 }
  rotate 5.359898*x
}
#declare fingerMlowerMpart5 = union {
  sphere { // Sphere273
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere274
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1416
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1417
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone013
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart5 = union {
  sphere { // Sphere275
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere276
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1418
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1419
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger5 = union {
  object { fingerMlowerMpart5 }
  object { fingerMpart5 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart6 = union {
  sphere { // Sphere277
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere278
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1420
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1421
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone014
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart6 = union {
  sphere { // Sphere279
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere280
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1422
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1423
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger6 = union {
  object { fingerMlowerMpart6 }
  object { fingerMpart6 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart7 = union {
  sphere { // Sphere281
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere282
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1424
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1425
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone015
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart7 = union {
  sphere { // Sphere283
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere284
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1426
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1427
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger7 = union {
  object { fingerMlowerMpart7 }
  object { fingerMpart7 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand1 = union {
  sphere { // Sphere265
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1408
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere266
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere267
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1409
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1410
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1411
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere268
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger4 }
  object { finger5 }
  object { finger6 }
  object { finger7 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.59683, 0.117826, -0.181062>
}
#declare basicMlimb5 = union {
  sphere { // Sphere260
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1403
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1404
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1405
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1406
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1407
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere261
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere262
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere263
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere264
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone011
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand1 }
  rotate <-190.374329, -149.529099, 187.794266>
}
#declare basicMarmMleft = union {
  object { basicMlimb4 }
  object { basicMlimb5 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale -0.8
  rotate <153.971664, 6.262101, -157.891312>
  translate  <0.207494, 5.447027, 22.500708>
}
#declare basicMlimb1 = union {
  sphere { // Sphere285
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1428
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1429
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1430
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1431
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1432
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere286
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere287
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere288
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere289
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart = union {
  sphere { // Sphere299
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere300
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1442
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1443
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone007
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart = union {
  sphere { // Sphere301
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere302
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1444
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1445
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger = union {
  object { fingerMlowerMpart }
  object { fingerMpart }
  rotate 5.359898*x
}
#declare fingerMlowerMpart1 = union {
  sphere { // Sphere303
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere304
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1446
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1447
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone008
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart1 = union {
  sphere { // Sphere305
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere306
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1448
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1449
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger1 = union {
  object { fingerMlowerMpart1 }
  object { fingerMpart1 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart2 = union {
  sphere { // Sphere307
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere308
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1450
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1451
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone009
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart2 = union {
  sphere { // Sphere309
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere310
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1452
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1453
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger2 = union {
  object { fingerMlowerMpart2 }
  object { fingerMpart2 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart3 = union {
  sphere { // Sphere311
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere312
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1454
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1455
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone010
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart3 = union {
  sphere { // Sphere313
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere314
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1456
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1457
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger3 = union {
  object { fingerMlowerMpart3 }
  object { fingerMpart3 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand = union {
  sphere { // Sphere295
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1438
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere296
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere297
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1439
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1440
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1441
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere298
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger }
  object { finger1 }
  object { finger2 }
  object { finger3 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.696018, -0.056512, -0.223852>
}
#declare basicMlimb = union {
  sphere { // Sphere290
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1433
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1434
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1435
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1436
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1437
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere291
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere292
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere293
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere294
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand }
  rotate <-150.455215, -156.036163, 179.265594>
}
#declare basicMarmMright = union {
  object { basicMlimb1 }
  object { basicMlimb }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale 0.8
  rotate <163.70462, -227.336044, 174.132141>
  translate  <0.055141, -5.405216, 22.731882>
}
#declare CSG001 = difference {
  sphere { // Sphere315
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <4.25028, 11.680179, 3.325953>
    rotate <-0.196035, -0.0, -0.0>
    translate  <-0.0, 5.874081, -0.157509>
  }
  sphere { // Sphere316
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <5.349308, 9.944535, 4.791598>
    rotate -2.533771*x
    translate  <0.149241, 3.538993, -3.332989>
  }
  scale <1.166423, 1.1, 1.144323>
  rotate 0.684455*x
  translate  <-0.0, 2.075105, -0.253283>
}
#declare teethMupperMleft1 = union {
  cone { // Cone048
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone049
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone050
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone051
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone052
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone053
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone054
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone055
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone056
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone057
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright1 = union {
  cone { // Cone058
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone059
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone060
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone061
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone062
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone063
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone064
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone065
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone066
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone067
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone068
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMlower = union {
  object { teethMupperMleft1 }
  object { teethMupperMright1 }
  scale -1.0
  rotate <7.41871, 0.0, -180.0>
  translate  <0.0, 0.20296, -4.886318>
}
#declare teethMupperMleft = union {
  cone { // Cone030
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone031
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone032
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone041
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone042
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone043
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone044
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone045
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone046
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone047
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright = union {
  cone { // Cone028
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone027
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone029
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone026
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone025
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone024
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone023
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone022
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone006
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone005
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMupper = union {
  object { teethMupperMleft }
  object { teethMupperMright }
}
#declare headMx = union {
  sphere { // Sphere321
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.270821, 1.487489, 2.59577>
    rotate -62.072033*x
    translate  <0.0, -1.195858, -0.233674>
  }
  sphere { // Sphere322
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <2.0, 1.658326, 2.0>
    rotate -90.0*x
    translate  <0.0, 13.325275, 0.0>
  }
  torus { // Torus072
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  11.195858*y
  }
  torus { // Torus073
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  9.195858*y
  }
  torus { // Torus074
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  7.195858*y
  }
  torus { // Torus075
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  5.195858*y
  }
  torus { // Torus076
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  3.195858*y
  }
  torus { // Torus077
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  1.195858*y
  }
  cylinder { // Cylndr1463
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 0.658326, 13.075064>
    rotate -90.0*x
  }
  scale <1.823368, 1.192647, 0.952494>
  translate  <-0.0, 0.555383, 0.18012>
}
#declare headMinterior = union {
  object { teethMlower }
  object { teethMupper }
  sphere { // Sphere317
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.279829, 3.013228, 0.691975>
    rotate 10.305234*x
    translate  <0.0, 2.850586, -3.530883>
  }
  cylinder { // Cylndr1458
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.639969, -0.189462, 2.421683>
    translate  <1.750329, -2.022552, -2.360624>
  }
  cylinder { // Cylndr1459
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.590279, 0.101221, -2.999959>
    translate  <-1.731603, -1.888632, -2.360624>
  }
  sphere { // Sphere318
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.715117, 3.552059, 0.626342>
    rotate -4.058217*x
    translate  <0.0, -0.284982, -3.303354>
  }
  sphere { // Sphere319
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.839486, 2.366695, 0.735887>
    translate  <0.0, -2.050042, -0.683347>
  }
  torus { // Torus070
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.145908, 1.126128, 0.95174>
    rotate -19.642107*x
    translate  <0.0, -2.73339, -1.537532>
  }
  torus { // Torus071
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.15546, 0.996368, 0.875845>
    rotate 6.707807*x
    translate  <0.0, -2.562553, -3.075063>
  }
  sphere { // Sphere320
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.0, 0.847587, 2.885885>
    rotate -68.325066*x
    translate  <0.0, 8.679306, -2.166905>
  }
  cylinder { // Cylndr1460
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.621841, 0.964178, 8.980318>
    rotate -90.0*x
    translate  <0.031092, -1.879205, -2.500708>
  }
  cylinder { // Cylndr1461
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <1.368051, 2.904227, -1.117958>
  }
  cylinder { // Cylndr1462
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <-1.368051, 2.904227, -1.117958>
  }
  object { headMx }
}
#declare head = union {
  object { CSG001 }
  object { headMinterior }
  scale <0.6, 0.8, 0.8>
  rotate <-31.495039, -0.17246, 89.712929>
  translate  <3.443233, 0.051678, 28.800424>
}
#declare tailMseg4 = union {
  sphere { // Sphere323
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone094
    <0,0,0>, 0.0, <0,0,1>, 0.8
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone095
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.541516, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.076768, -1.995904>
  }
  cone { // Cone096
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.336995, -0.1877, -0.651453>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 0.787325, -2.373694>
  }
  cone { // Cone097
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.285301, -0.097924, -0.690062>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 0.606552, -3.05747>
  }
  torus { // Torus078
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.387161, 0.529998, 0.55242>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus079
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.470708, 0.590001, 0.599762>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone099
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.618626, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.207862, -1.206992>
  }
  translate  <0.0, 0.081209, -0.153672>
  scale 0.2401
  translate  <-0.0, -0.019498, -10.177797>
}
#declare tailMseg3 = union {
  sphere { // Sphere324
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone088
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.018093, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone089
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus080
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.503471, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus081
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.539657, 0.607, 0.607239>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus082
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.575842, 0.643, 0.640606>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone090
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone091
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone092
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus083
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus084
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone093
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.343
  translate  <0.0, 0.0, -8.799636>
}
#declare tailMpartM1 = union {
  object { tailMseg4 }
  object { tailMseg3 }
  rotate 0.0*x
  translate  <-0.0, 0.023283, 8.800973>
  rotate <-31.292847, 0.0, -0.0>
  translate  <0.0, -0.023283, -8.800973>
}
#declare tailMseg2 = union {
  sphere { // Sphere325
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone082
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone083
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus085
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.491709, 0.569774, 0.57679>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus086
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.542822, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus087
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone084
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone085
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone086
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus088
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus089
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone087
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.49
  translate  <0.0, 0.0, -6.825016>
}
#declare tailMpartM2 = union {
  object { tailMpartM1 }
  object { tailMseg2 }
  rotate -0.0*x
  translate  <-0.0, -0.008138, 6.841223>
  rotate <41.882164, -0.0, 0.0>
  translate  <0.0, 0.008138, -6.841223>
}
#declare tailMseg1 = union {
  sphere { // Sphere326
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone076
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone077
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus090
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus091
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus092
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone078
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone079
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone080
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus093
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus094
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone081
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.7
  translate  <0.0, 0.0, -3.996833>
}
#declare tailMpartM3 = union {
  object { tailMpartM2 }
  object { tailMseg1 }
  rotate <-0.0, 0.0, 0.0>
  translate  <-0.0, -0.048121, 3.977207>
  rotate <41.364124, -0.0, 0.0>
  translate  <0.0, 0.073518, -3.72317>
}
#declare tailMseg = union {
  sphere { // Sphere327
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone070
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone072
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus095
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus096
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus097
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone073
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone074
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone075
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus098
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus099
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone071
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
}
#declare tail = union {
  object { tailMpartM3 }
  object { tailMseg }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.076435, -0.065365>
  scale <1.214286, 1.7, 2.833333>
  rotate <52.305943, -0.0, 90.0>
  translate  <-6.403084, -0.252203, 6.594411>
}
#declare upperMbody = union {
  object { torso }
  object { basicMarmMleft }
  object { basicMarmMright }
  object { head }
  object { tail }
  rotate <-5.973597, 36.540485, -2.863771>
  translate  <-2.274868, 0.0, -1.624906>
}
#declare basicMupperMlimb1 = union {
  sphere { // Sphere328
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1464
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1465
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1466
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.889763, 0.6, 7.957074>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.272689, -0.0, -0.972206>
  }
  cylinder { // Cylndr1467
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1468
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere329
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.227032, 1.0, 1.313549>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere330
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere331
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.088028, 0.897211, 1.451759>
    rotate <-0.210516, -0.012921, -6.567191>
    translate  <-2.579374, -0.301122, -0.209806>
  }
  sphere { // Sphere332
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <3.402014, 1.951081, 1.903414>
    rotate <0.0, 4.411142, 0.0>
    translate  <-0.640424, 0.35666, -0.478302>
  }
  sphere { // Sphere333
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.748529, 0.423051, 2.390815>
    rotate <174.716705, -80.629654, 176.581375>
    translate  <2.228457, 0.34524, 1.265795>
  }
  torus { // Torus100
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.247004, 0.895005>
    rotate <-47.660999, -86.089897, -0.0>
    translate  <-1.243407, 0.465109, 0.390461>
  }
  torus { // Torus101
    1.3, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.136887, 1.027554>
    rotate <-35.391956, -86.089897, -0.0>
    translate  <0.577974, 0.26271, 0.335131>
  }
  torus { // Torus102
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <0.652746, 1.22252, 0.912929>
    rotate <-42.451847, -86.089897, -0.0>
    translate  <-0.341099, 0.358058, 0.363051>
  }
  scale <0.8, 1.0, 1.2>
  rotate <0.0, 87.391014, 0.0>
  translate  <-2.902059, 0.0, 5.616888>
}
#declare toeMlowerMpart3 = union {
  sphere { // Sphere341
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere342
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1475
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1476
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone019
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart3 = union {
  sphere { // Sphere343
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere344
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1477
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1478
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe3 = union {
  object { toeMlowerMpart3 }
  object { toeMpart3 }
  scale <3.846327, 6.251647, 2.984955>
  rotate <-104.346291, -0.802354, -89.380188>
  translate  <10.356746, 0.011034, 2.11107>
}
#declare toeMlowerMpart4 = union {
  sphere { // Sphere345
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere346
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1479
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1480
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone020
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart4 = union {
  sphere { // Sphere347
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere348
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1481
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1482
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe4 = union {
  object { toeMlowerMpart4 }
  object { toeMpart4 }
  scale <3.817335, 6.252286, 3.007317>
  rotate <-95.292099, 1.427575, -81.559448>
  translate  <10.156489, 0.47757, 1.273319>
}
#declare toeMlowerMpart5 = union {
  sphere { // Sphere349
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere350
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1483
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1484
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone021
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-22.955671, 1.917567, 0.336826>
  translate  <0.0, 0.0, 0.382571>
}
#declare toeMpart5 = union {
  sphere { // Sphere351
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere352
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.128571, 0.09069, 0.180976>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1485
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1486
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare toe5 = union {
  object { toeMlowerMpart5 }
  object { toeMpart5 }
  scale <3.835269, 6.246415, 2.996068>
  rotate <-95.305641, -2.794001, -95.775719>
  translate  <10.170376, -0.548809, 1.732482>
}
#declare foot1 = union {
  sphere { // Sphere339
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.104823, 0.954575, 0.702369>
    rotate <-0.0, 17.439234, -0.0>
    translate  <10.410911, 0.0, 0.865005>
  }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <0.644094, 0.564646, 1.756106>
    rotate <180.0, 78.781219, 180.0>
    translate  <7.487469, 0.0, 2.592187>
  }
  sphere { // Sphere340
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.757855, 0.850708, 1.307657>
    rotate <-0.0, -15.639227, 0.0>
    translate  <9.65996, 0.0, 1.614038>
  }
  cylinder { // Cylndr1474
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.468556, 0.6, 1.877972>
    rotate 180.0*z
    translate  <9.475477, -0.019726, 2.093359>
  }
  object { toe3 }
  object { toe4 }
  object { toe5 }
  rotate <-0.0, 6.690316, -0.0>
  translate  <-9.753865, -0.0, -1.855504>
  scale <1.99075, 1.4, 0.845479>
  rotate <180.0, -101.704941, -180.0>
  translate  <9.249519, -0.063675, -0.101697>
}
#declare basicMlowerMlimb1 = union {
  sphere { // Sphere334
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1469
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1470
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1471
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1472
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1473
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere335
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere336
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere337
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  sphere { // Sphere338
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.175285, 0.552123, 1.745987>
    rotate <0.0, 82.934669, 0.0>
    translate  <-0.304845, -0.0, 0.620477>
  }
  object { foot1 }
  sphere { // Sphere353
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <2.009062, 1.0, 0.628444>
    translate  <-0.121197, 0.756362, -0.365819>
  }
  rotate 5.889341*y
  translate  <0.038422, 0.0, 0.372483>
  rotate <-0.0, -231.446243, -0.0>
  translate  <-2.714829, 0.0, -0.468074>
}
#declare basicMlegMleft = union {
  object { basicMupperMlimb1 }
  object { basicMlowerMlimb1 }
  rotate <-0.0, -0.0, 0.0>
  translate  <3.337407, 0.0, -5.623791>
  scale <1.2, -1.3, 1.3>
  rotate 33.053066*y
  translate  <-4.232837, 3.356687, 6.081297>
}
union { // alien
  object { basicMlegMright }
  object { upperMbody }
  object { basicMlegMleft }
  scale 0.4
  rotate -4.050463*z
  translate  <8.959236, -9.310821, 4.023167>
}


