//The background height-field and blob foreground
#declare Foreground = //(pun intended)
union {
//basics of the foreground - large spheres
blob {threshold .1
sphere {0,1,.05 
scale <10000000,8.2,10000000>
translate -.5*y
}
sphere {0,1,.15 
scale <10000000,6.2,10000000>
translate -.75*y
}
sphere {0,1,.3 
scale <10000000,4.2,10000000>
translate -1*y
} 
sphere {0,1,.6
scale <10000000,1.2,10000000>
translate -1.25*y
}
sphere {0,1,-.4
scale <30,5,30>
translate <-100,0,-200>
}
sphere {0,1,-.4
scale <15,2,15>
translate <-120,0,-220>
}    

//Snow around the right hut
PSN(<-58,0,-193+7>,4216,40)
sphere {0,1.25,.5
scale <25,25,25>*.375
translate <-58,0,-193+7>
pigment {rgb 1.5} 
finish {ambient ALight diffuse DiffTotal}
}
sphere {0,1.25,-1
scale <20,20,20>*.375
translate <-58,12,-193+7>
pigment {rgb 1.5} 
finish {ambient ALight diffuse DiffTotal}
}
sphere {0,1.25,-.5/2
scale <6,10/.25,50>*.25
translate <-56.5,10,-193+7>
}
sphere {0,1.25,-.5/2
scale <8,10/.25,50>*.25
translate <-58,10,-193+7>
}
sphere {0,1.25,-.5/2
scale <6,10/.25,50>*.25
translate <-59.5,10,-193+7>
}




//Snow around the left hut
PSN(<-125,0,-175>,89,40)
sphere {0,1.25,.5
scale <25,25,25>*.375
rotate 30*y
translate <-125,0,-175> 
pigment {rgb 1.5} 
finish {ambient ALight diffuse DiffTotal}
}
sphere {0,1.25,-1
scale <20,20,20>*.375 
rotate 30*y
translate <-125,12,-175>
pigment {rgb 1.5} 
finish {ambient ALight diffuse DiffTotal}
}
sphere {0,1.25,-.5/2
scale <6,10/.25,50>*.25 
rotate 30*y
translate <-124,10,-175>
}
sphere {0,1.25,-.5/2
scale <8,10/.25,50>*.25
rotate 30*y
translate <-125,10,-175>
}
sphere {0,1.25,-.5/2
scale <6,10/.25,50>*.25
rotate 30*y
translate <-125,10,-175>
}

sphere {0,1.25,.5
scale <25,25,25>*.375
rotate 30*y
translate <-125,0,-175> 
}
sphere {0,1.25,-.5
scale <20,20,20>*.375
rotate 30*y
translate <-125,15,-175> 
}
sphere {0,1.25,-.5/4
scale <8,10/.25,50>*.25
rotate 30*y
translate <-123.5,10,-175> 
}
sphere {0,1.25,-.5/2
scale <10,10/.25,50>*.25
rotate 30*y
translate <-125,10,-175> 
}
sphere {0,1.25,-.5/2
scale <8,10/.25,50>*.25
rotate 30*y
translate <-125.5,10,-175> 
}

//Piled up snow (from crash)
sphere {0,1,.6
scale <30,28,30>
translate <-100,-10,-275>*.975 
pigment {rgb 1.5} 
finish {ambient ALight diffuse DiffTotal*1}
}
sphere {0,1,.4
scale <30,24,30>
translate <-100,-10,-275>*.975
pigment {rgb 1.5}
finish {ambient ALight diffuse DiffTotal*1}
}
sphere {0,1,.6 
scale <30,22,30>
translate <-100,0,-275>*1
translate -10*y
pigment {rgb 1.5}
finish {ambient ALight diffuse DiffTotal*1}
}
sphere {0,1,.6
scale <40,20,30>
translate <-100,0,-275>*1.05  
translate -10*y
pigment {rgb 1.5}
finish {ambient ALight diffuse DiffTotal*1}
} 
sphere {0,1,.6
scale <30,20,30>
translate <-100,0,-275>*1.1 
translate -10*y  
pigment {rgb 1.5}
finish {ambient ALight diffuse DiffTotal*1}
}
sphere {0,1,.6
scale <30,20,30>
translate <-100,0,-275>*1.15 
translate -10*y
pigment {rgb 1.5}
finish {ambient ALight diffuse DiffTotal*1}
}
sphere {0,1,.6
scale <30,20,30>
translate <-100,0,-275>*1.2 
translate -10*y
pigment {rgb 1.5} 
finish {ambient ALight diffuse DiffTotal*1}
} 
sphere {0,1,.6
scale <30,20,30>
translate <-100,0,-275>*1.25 
translate -10*y
pigment {rgb 1.5}
finish {ambient ALight diffuse DiffTotal*1}
}


//Trough dug by the pod
cylinder {<-100,0,-275>*1,<-100,0,-275>*1.8,12,-.5 scale     <1,1.45,1>}
cylinder {<-100,0,-275>*1,<-100,0,-275>*1.8,12,-.125 scale   <1,1.45,1>} 
cylinder {<-100,0,-275>*1,<-100,0,-275>*1.8,14,-.125 scale   <1,1.45,1>}

//Stiff in the snow
#macro BodyNumber1(Loc,Rot,Scale)
#macro BN1T(Loc1,Rot1,Scale1)
scale Scale1
rotate Rot1
translate Loc1
#end
sphere{<0,0,0>,1.8,.125
scale<4,4,14>
rotate<0,-10.666,0>
translate<8,0,-14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<4,4,14>
rotate<0,-3.5958,0>
translate<-2,0,-14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<8.0565,4,14>
rotate<0,-4.9556,0>
translate<1,0,8> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.5016,4,11.401>
rotate<0,-52.94,0>
translate<18,0,-31> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.5452,4,11.401>
rotate<0,-23.195,0>
translate<2,0,-35>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.149,3,11.401>
rotate<0,-58.507,0>
translate<12.5,0,14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.149,3,11.401>
rotate<180,-40.117,180>
translate<-9,0,11>  
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<4,3,8>
rotate<-15.623,-80.493,0>
translate<12,2.5,10>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<2.466,3,11.401>
rotate<0,5.9581,0>
translate<-16.5,0,-6> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<5.5,4.5,6.7051>
rotate<0,28.301,0>
translate<6,1.2496e-30,37>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.5277,3,6.7051>
rotate<0,-6.225,0>
translate<0.5,0,17.5>
BN1T(Loc,Rot,Scale)
}






sphere{<0,0,0>,3,.125/4
scale<4,4,14>
rotate<0,-10.666,0>
translate<8,0,-14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<4,4,14>
rotate<0,-3.5958,0>
translate<-2,0,-14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<8.0565,4.5,14>
rotate<0,-4.9556,0>
translate<1,0,8> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.5016,4,11.401>
rotate<0,-52.94,0>
translate<18,0,-31> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.5452,4,11.401>
rotate<0,-23.195,0>
translate<2,0,-35>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.149,3,11.401>
rotate<0,-58.507,0>
translate<12.5,0,14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.149,3,11.401>
rotate<180,-40.117,180>
translate<-9,0,11>  
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<4,3,8>
rotate<-15.623,-80.493,0>
translate<12,2.5,10>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<2.466,3,11.401>
rotate<0,5.9581,0>
translate<-16.5,0,-6> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<5.5,4.5,6.7051>
rotate<0,28.301,0>
translate<6,1.2496e-30,37>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.5277,3,6.7051>
rotate<0,-6.225,0>
translate<0.5,0,17.5>
BN1T(Loc,Rot,Scale)
}  
#end

//one of the slither marks to be used in the tracks
#macro SlitherMarks(Loc,Rot)
sphere {0,.25,-.05/3
scale <20,38,40>
rotate Rot*y
scale .5
translate Loc
}
sphere {0,.25,-.05/6
scale <40,38,40>
rotate Rot*y 
scale .5
translate Loc
}
#end
//two of the foot marks to be used in the tracks
#macro FootPrints(Loc,Rot)
sphere {0,.25,-.05/4
scale <5,36,10>
translate <-.75,0,-2> 
rotate Rot*y
scale .5
translate Loc
}
sphere {0,.25,-.05/4
scale <5,36,10>
translate <.75,0,2>
rotate Rot*y 
scale .5
translate Loc
}
sphere {0,.25,-.1/6
scale <7.5,26,120>
translate <-.75,0,-2> 
rotate Rot*y
scale .5
translate Loc
}
sphere {0,.25,-.1/6
scale <7.5,26,120>
translate <.75,0,2>
rotate Rot*y 
scale .5
translate Loc
} 
#end 
 
//path of footprints part 1 
#declare FootPrintRoute = spline {
cubic_spline 
0    ,<-128,0,-285>
1/12 ,<-126,0,-275>  
2/12 ,<-123,0,-265>  
3/12 ,<-120,0,-255>  
4/12 ,<-113,0,-248>   
5/12 ,<-106,0,-241>   
6/12 ,<-99,0,-234>   
7/12 ,<-90,0,-227>   
8/12 ,<-80,0,-221>    
9/12 ,<-73,0,-215>    
10/12,<-66,0,-208>   
11/12,<-60,0,-200>   
1   ,<-58,0,-193>
}
FPrints(32) 

//path of footprints part 2
#declare FootPrintRoute = spline {
cubic_spline
0   ,<-126,0,-275>  
1/5 ,<-128,0,-285>
2/5 ,<-134,0,-282>  
3/5 ,<-144,0,-281>    
4/5 ,<-150,0,-280>    
1   ,<-151,0,-282>  
}
FPrints(12) 
                           
//path of slither part 1
#declare SlitherPath = spline {
cubic_spline
0   ,<-110,6,-278>  
1/11 ,<-120,2,-280>
2/11 ,<-130,0,-275>  
3/11 ,<-144,0,-278>    
4/11 ,<-150,0,-270>    
5/11 ,<-151,0,-260>
6/11 ,<-149,0,-250>  
7/11 ,<-140,0,-240> 
8/11 ,<-135,0,-235>   
9/11 ,<-130,0,-225>   
10/11 ,<-125,0,-215>   
1 ,<-115,0,-200>   
}
Slither(60) 

//place the stiff
BodyNumber1(<-156,2.25,-280.5>,-90*y,<1,2,1>/15)

sphere {0,6,-.125/2 scale <2.5,1,1.5> translate <-110,2,-278>}
sphere {0,5.5,-.125/2 scale <2.5,1,1.5> translate <-110,2,-278>}
sphere {0,5,-.125/2 scale <2.5,1,1.5> translate <-110,2,-278>} 

 

texture {
pigment {rgb 1.5}
//normal {bumps scale 7.5 omega 0 turbulence .5 bump_size .125/2}
normal {crackle metric 4 bump_size 1 scale 15}
finish {ambient ALight diffuse DiffTotal*1}

}
texture {
pigment {
image_map {
png "BloodStain.png"  
interpolate 2 
once 
}
}
finish {ambient ALight+ .5 diffuse DiffTotal*1 }  
translate <-.5,-.5,0>
rotate 90*z
scale <8,12,1>*.75 
rotate <90,0,0>
translate<-158,2.125,-279>     
}

texture {
pigment {
image_map {
png "BloodStain.png"  
interpolate 2 
once 
}
}
finish {ambient ALight+ .5 diffuse DiffTotal*1 }  
translate <-.5,-.5,0>
rotate 90*z
scale <8,12,1>*1.5
rotate <90,0,0>
rotate 120*y 
scale <1,1.25,1> 
translate <-130,1,-185>    
}
texture {
pigment {
image_map {
png "BloodStain.png"  
interpolate 2 
once 
}
}
finish {ambient ALight+ .5 diffuse DiffTotal*1 }  
translate <-.5,-.5,0>
rotate 90*z
scale <8,12,1>*1.5
rotate <90,0,0>
rotate 30*y 
scale <1,1.25,1> 
translate <-130,1,-180>    
}
sturm
}

//Background height field
difference {
height_field {
tga
"C:\Projects\ArcticHorror\Acrtic2.tga"
smooth
water_level .001
translate -.001*y
translate <-.5, 0, -.5>
scale <1200,120,1200>
rotate <0, 270, 0>
pigment {rgb 1.5} 
normal {crackle metric 4 bump_size 1 scale 7.5}
finish {ambient ALight diffuse DiffTotal*1}
}
box{0,1 
scale<71,20,51> 
translate<-119,-6,-25>
translate 18*y
translate <80,0,0>
}           
}
}