#include "colors.inc"
+//+sc0.206250 +sr0.350000 +ec0.368750 +er0.550000
#declare sky_vect = y;
#declare cam_loc = <-5,.75,-10>*35;
#declare lookat = <0,0,0>; 
  
#declare cam_loc = <-4.875,.5,-10>*35;
#declare lookat = <0,45,0>;

camera {
direction 1.66*z
location cam_loc
look_at lookat
}
/*camera {
direction 1
location <-120,300,-255.1>
look_at <-120,0,-255>}*/

//sphere {<-5,1,-10>*35,50 pigment {rgb x*3}}

light_source {<40,25,40>*100 rgb <1,1,.9>           }//area_light 400,1000,5,5 }
light_source {<38,35,40>*100 rgb <.875,.875,1>/2.75 }//area_light 5000,10000,8,8 }
light_source {<40,35,38>*100 rgb <.875,.875,1>/2.75 }//area_light 5000,10000,8,8 }
light_source {<-10,60,-10>*100 rgb 1/4             }//area_light 1000,1000,3,3 }

//Twin fighters
#include "Albatross.inc"
#declare Fighter 1 = //hovering over the complex
union {Albatross(<40,125,0>,<0,-45,0>,-80,50,5,0,1) }
#declare Fighter 2 = //doing a "flyby"
union {Albatross(<-110,80,-60>,<0,-15,00>,-45,50,5,0,1) } 

//Makes it look more "cold" somehow
fog { 
fog_type 2
distance 250
rgb <.9,.9,1>
fog_offset 3 
fog_alt 5 
scale 350 
}

//sphere {<40,25,40>*100,1500 pigment {rgb x*50} no_shadow}

//Cloud Background
cylinder {0,y,1 open hollow on no_shadow
pigment {image_map {png "c:\stsky4.png" map_type 2 interpolate 2 once}} 
finish {ambient 1 diffuse 0}
scale <150,62,150>*100
rotate 90*y
}
sphere {0,1 hollow on no_shadow
pigment {image_map {png "c:\stsky4.png" map_type 2 interpolate 2}} 
finish {ambient 1 diffuse 0}
scale <150,50,150>*1000
rotate -90*y
}





#declare RBox2 =
superellipsoid {
<.25, .25>
translate <1,1,1>
scale .5
}
#declare RBox2a =
superellipsoid {
<.2, .2>
translate <1,1,1>
scale .5
}
declare Scarring = //For concrete and other textures
texture {pigment {bozo color_map {[0 rgb 0 transmit .875][1 rgb 0 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb 0 transmit .667][1 rgb 0 transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}

#declare Blood = //for windows
texture {pigment {bozo pigment_map {[0 bozo color_map {[.3 rgb <128,0,25>/255 transmit .25][.5 rgb <128,0,25>/255 transmit 1]}scale .125/4][.4 rgb <128,0,25>/255 transmit 1]}scale 4} finish {ambient .5 diffuse 1 crand .1} }
texture {pigment {bozo color_map {[.15 rgb <128,0,25>/255 transmit .6667][.3 rgb <128,0,25>/255 transmit 1]}scale 4} finish {ambient .5 diffuse 1 crand .1} }
texture {pigment {bozo color_map {[.15 rgb <128,0,25>/255 transmit .75][.3 rgb <128,0,25>/255 transmit 1]}scale 4 translate -40} finish {ambient .5 diffuse 1 crand .1} }

#declare Blood2 = //for windows
texture {pigment {bozo pigment_map {[0 bozo color_map {[.3 rgb <128,0,25>/255 transmit .66][.5 rgb <128,0,25>/255 transmit 1]}scale .125][.4 rgb <128,0,25>/255 transmit 1]}scale 4} finish {ambient .5 diffuse 1 } }
texture {pigment {bozo color_map {[.15 rgb <128,0,25>/255 transmit .66][.3 rgb <128,0,25>/255 transmit 1]}scale 4} finish {ambient .5 diffuse 1 } }


#declare Light = //Spotlight for the corners of the concrete base
union {
cylinder {0,3*y,1
pigment {Clear}
hollow  
no_shadow
interior {
media {
emission <.75,.75,1>/2/75/5
intervals 20
sample_method 2
#declare C=0;
#while (C <360)
density {
cylindrical
color_map {
[0 rgb 0]  
[.25 rgb 1]
}       
rotate 15*z     
rotate C*y
}        
#declare C=C+60;
#end
density {
gradient y
color_map {
[0 rgb 0] 
[.125 rgb .25]
[.25 rgb .5]  
[.4 rgb .75]
[.5 rgb 5]
[1 rgb 10]
}       
scale 4
} 
}
} 
translate -3*y
rotate -90*x
scale <50,50,25>
}

sphere {0,1
pigment {Clear}
hollow
no_shadow
interior {
media {
emission <.75,.75,1>/5
sample_method 2
density {
spherical
color_map {
[0 rgb 0]  
[.75 rgb .5]
[1 rgb 10]
}       
}        
}
}
scale 5
translate 2*y
}      
}
#declare Marklight = //Orangish lights for accenting
union {
sphere {0,1
pigment {Clear}
hollow
no_shadow
interior {
media {
emission <1,.5,.25> 
absorption .5
sample_method 2
density {
spherical
color_map {
[0 rgb 0]  
[.75 rgb .25]
[1 rgb 10]
}       
}        
}
}
scale 2.5
translate .5*y
}
light_source {.5*y rgb <1,.5,.25>  fade_distance 6 fade_power 2}
}
#declare Marklight2 = //Accent lights for the Biotubes (smaller less distance
union {
sphere {0,1
pigment {Clear}
hollow
no_shadow
interior {
media {
emission <1,.5,.25>*1.5 
absorption 1
sample_method 2
density {
spherical
color_map {
[0 rgb 0]  
[.75 rgb .25]
[1 rgb 10]
}       
}        
}
}
scale 2.5
translate .5*y
}
light_source {.5*y rgb <1,.5,.25>  fade_distance 8 fade_power 2}
}      
      

#declare MarkerLights = //positions of the accent lights
union{
object{Marklight translate <38,4.25+70,38>}
object{Marklight translate <38,4.25+70,-38>}
object{Marklight translate <-38,4.25+70,38>}
object{Marklight translate <-38,4.25+70,-38>} 

object{Marklight translate <-137.5,13.5,49>   }
object{Marklight translate <-121,13.5,65.5> }
object{Marklight translate <-104.5,13.5,49>   }
object{Marklight translate <-121,13.5,33> }

object{Marklight translate <-141.5,-5,49> }
object{Marklight translate <-121  ,-5,69>   }
object{Marklight translate <-100,-5,49> }
object{Marklight translate <-121  ,-5,29>   } 

object{Marklight translate <-25,0,-52.5>}
object{Marklight translate <25,0,-52.5> }   

union {
object{Marklight translate <59.5,20,0>}  
object{Marklight translate <-59.5,20,0>}
object{Marklight translate <0,20,59.5>}
object{Marklight translate <0,20,-59.5>}  
rotate <-40,-20,0>
translate <-122,57,49>
translate -18*y
}

}


              

//the macro to define the path of footprints in the snow
#macro FPrints(Max)
#declare Count = 1;
#while (Count < Max)
#declare Constant = (Count/Max);
#declare Constant2 = ((Count-1)/Max);
#declare Dist = vlength(FootPrintRoute(Constant)-FootPrintRoute(Constant2));
#declare P1 = <0,0,0>+FootPrintRoute(Constant2-.05);
#declare P2 = <0,0,0>+FootPrintRoute(Constant);
#declare PA = (P1-P2);
#declare ERX = degrees(atan2(vlength(PA*<1, 0, 1>),PA.y+.001));
#declare ERY = degrees(atan2(PA.x,PA.z+.001));
#declare Location = <0,0,0>+FootPrintRoute(Count/Max) 
FootPrints(Location,<ERX,ERY,0>)
#declare Count = Count+1;
#end 
#end
//the macro to define the path of the slither marks in the snow

#macro Slither(Max)
#declare Count = 1;
#while (Count < Max)
#declare Constant = (Count/Max);
#declare Constant2 = ((Count-1)/Max);
#declare Dist = vlength(SlitherPath(Constant)-SlitherPath(Constant2));
#declare P1 = <0,0,0>+SlitherPath(Constant2-.05);
#declare P2 = <0,0,0>+SlitherPath(Constant);
#declare PA = (P1-P2);
#declare ERX = degrees(atan2(vlength(PA*<1, 0, 1>),PA.y+.001));
#declare ERY = degrees(atan2(PA.x,PA.z+.001));
#declare Location = <0,0,0>+SlitherPath(Count/Max) 
SlitherMarks(Location,<ERX,ERY,0>)
#declare Count = Count+1;
#end 
#end


//Should be self-explainatory
#declare ConcreteTex =
texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 10
} 
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring scale 2} 

#declare SnowTex =
texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 10
} 
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring} 
texture {
pigment {
bozo
color_map {
[.4 rgbt 1]
[.6 rgb 1]
}
scale 5
turbulence .5
}
finish {ambient .125 diffuse 1}
}
#declare DishSnowTex =
texture {
pigment {gradient y sine_wave color_map {[.6 rgb 1.5 transmit 1][.625 rgb 1.5 transmit 0]}
scale 10
warp {turbulence .75}
scale .1
scale 70 translate 30*y}
normal {gradient y sine_wave normal_map{[.6 bumps scale 1/8 omega 0 bump_size 0 ][.625 bumps scale 1/6 omega 0 bump_size .125]}
scale 10
warp {turbulence .75}
scale .1
scale 70 translate 30*y}
finish {ambient .125 diffuse 1}
}

//Large tanks of bio-nuclear material (Num is the number on the tank)
#macro Biotube(Num)
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 3.5, 2, 3.5 >
         translate < 0, 9, 0 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75}
         scale < 6, 2, 6 > 
         texture {ConcreteTex scale .3}
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 3.5, 7, 3.5 >
         translate < 0, 2, 0 >
      }
      
      union {
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 0.25 }

         translate < 0, 3, 0 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 0.25 }

         translate < 0, 5, 0 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 0.25 }

         translate < 0, 7, 0 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.25, 5, 0.25 >
         translate < 0, 2, 4 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.25, 5, 0.25 >
         translate < 0, 2, -4 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.25, 5, 0.25 >
         translate < -4, 2, 0 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.25, 5, 0.25 >
         translate < 4, 2, 0 >
      }
      texture {pigment {rgb .5}}
      texture {Scarring}
      }
union {Marklight2 scale .75 translate <4.25,7.25,0> }
union {Marklight2 scale .75 translate <-4.25,7.25,0>}
}
texture {
pigment {rgb 1}
finish {ambient .25 diffuse .9 phong .5}}
texture {
pigment {
image_map {
png concat("0",str(Num,0,0)) 

once
}
}
scale<6,6,6>
translate<-3,1.5,0> 
scale 1.5 
rotate 45*y
finish {ambient .25 diffuse .9}
}
}
#end


//The Pod the thing arrived in (door open, engines smoking)             
#declare AlienLandingPod = 
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 20, 20, 61 >
                     translate < 0, -0.263, 0.263 >
                  }
                  difference {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 18, 18, 59 >
                  }           
      // Object type: Disc
      // Name: NoName
      object
      {
         disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

         scale < 20, 1, 20 >
         rotate < -90, 0, 0 >
         translate < 0, 7.5, -8.75 >
      }
      }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5}

                     scale < 320.62, 31.046, 36.308 >
                     translate < 0, -21.311, -38.413 >
                  }
      // Object type: Union
      // Name: 'or'
      object
      {
         merge
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 50, 8.8733, 5.25 >
                     translate < -25, 5.5625, -1.6875 >
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 48, 15, 10.454 >
                     rotate < -58.265, 0, 0 >
                     translate < -24, 2.9375, -1.875 >
                  }
               }
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < -50, -8.8733, -5.25 >
                     rotate < 0, 0, 180 >
                     translate < -25, 5.5625, -1.125 >
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < -48, -15, -10.454 >
                     rotate < -58.265, 0, 180 >
                     translate < -24, 2.9375, -0.9375 >
                  }
               }
            }
         }
         texture {
         pigment {image_map {png "alieninternal.png"interpolate 2}}    
         normal {bump_map {png "alieninternal.png"interpolate 2}bump_size 5} 
         finish {ambient 0 diffuse 12}
         scale <13.5,8.75,1>
         translate <-20,5.5,0>
         
         }
      } 
                  
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 42, 21, 103 >
               translate < -21, 0, -37 >
            }
         }
      }
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 20, 11.147, 61 >
                     translate < 0, -0.14658, 0.263 >
                  }
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 18, 10.032, 59 >
                  }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5 open }

                     scale < 320.62, 17.303, 36.308 >
                     translate < 0, -11.877, -38.413 >
                  }
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 42, 21, 103 >
               translate < -21, -21, -37 >
            }
         }
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 10, 15, 4 >
         translate < 2, -5, -42 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 10, 15, 4 >
         translate < -12, -5, -42 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5 open }

         scale < 12.25, 33.593, 2 >
         rotate < -86.742, 0, 0 >
         translate < 2.7443e-41, -8.75, 2.8449e-15 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 10, 15, 46 >
                     translate < 2, -5, -38 > 
                     pigment {rgb <.5,.45,.4>/2}
                     finish {ambient .25 diffuse 1 phong .25 metallic 
                     }            

                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 10, 15, 46 >
                     translate < -12, -5, -38 >
                     pigment {rgb <.5,.45,.4>/2}
                     finish {ambient .25 diffuse 1 phong .25 metallic 
                     }
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 12, 3, 53 >
                     translate < -13, -4, -36 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 12, 3, 53 >
                     translate < -13, 6, -36 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 12, 3, 53 >
                     translate < -13, 1, -36 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 12, 3, 53 >
                     translate < 1, -4, -36 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 12, 3, 53 >
                     translate < 1, 1, -36 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 12, 3, 53 >
                     translate < 1, 6, -36 >
                  }
               }
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < -90, 0, 0 >
               translate < 0, 2, -7.5 >
            }
         }
        pigment {rgb 1}
        finish {ambient .25 diffuse .75 phong .125 metallic}
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 3.75, 5, 10 >
         rotate < -3.3051, 0, 0 >
         translate < -4, 16.5, -8.75 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 3.75, 5, 10 >
         rotate < -3.3051, 0, 0 >
         translate < 4.25, 16.5, -8.75 >
      }
sphere {0,1 no_shadow hollow on
pigment {transmit 1}
interior {
media { 
intervals 5
sample_method 2
absorption .75 
emission .25

density {spherical
color_map {
[0 rgb 0]
[1 rgb 1]
} 
scale <1,2,1>
warp {turbulence .125}
scale 1/<1,2,1> 
translate -.25*y
}
density {bozo
color_map {
[.2 rgb 0]
[.8 rgb 1]
} 
scale <1,2,1>
warp {turbulence .5}
scale 1/<1,2,1> 
scale 1/4*y  
scale .6
}

}

media { 
intervals 5
sample_method 2
absorption .25 
emission .25
density {spherical
color_map {
[0 rgb 0]
[1 rgb 1]
} 
scale <1,2,1>
warp {turbulence .125}
scale 1/<1,2,1>
translate -.25*y
}
density {bozo
color_map {
[.2 rgb 0]
[.8 rgb 1]
} 
scale <1,2,1>
warp {turbulence .5}
scale 1/<1,2,1> 
scale 1/4*y
scale .6 
translate -40
}
}
media { 
intervals 5
sample_method 2
absorption .75 
density {spherical
color_map {
[0 rgb 0]
[1 rgb 1]
} 
scale <1,2,1>
warp {turbulence .125}
scale 1/<1,2,1> 
translate -.25*y
}
density {bozo
color_map {
[.2 rgb 0]
[.8 rgb 1]
} 
scale <1,2,1>
warp {turbulence .5}
scale 1/<1,2,1> 
scale 1/4*y
scale .6 
translate 40

}
}
}
scale <7,34.5,7.25>
translate <-7.25,26.5,0>
translate <-5,-10,-45>  
scale <1,1,1/.75>
}  

light_source{
<-3,9.25,-1.75>
color rgb <1,.5,0>
fade_distance 5
fade_power 2
}
   }
pigment {rgb <.5,.5,.5>}
finish {ambient .25 diffuse .75 phong 1.5 metallic 
reflection_min 0
reflection_max .25
//reflection_blur .125 
//reflection_samples 5
}

texture {
pigment {
image_map {
png "alienskin.png"  
interpolate 2
}
} 
normal {
bump_map {
png "alienskinb.png"  
interpolate 2
}   
bump_size 5
} 
finish {ambient 0 diffuse 1 reflection_min 0 reflection_max .5 } 
scale <103.75,35.75,1>
rotate <0,-90,0>
translate <0,-12.25,-42.75>     
}
}
//Human guard hut
#declare GuardHut =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 7.5, 7.5, 7.5 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2.375, 7.5, 4.5 >
                     rotate < 90, 0, 0 >
                     translate < 0, -5.2881e-23, -8.25 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 8.25, 0.375, 8.25 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 7.5, 0.375, 7.5 >
                     rotate < -180, 0, 0 >
                     translate < 0, 6.2813, 0 >
                  }
               }
            }
            // Object type: Paraboloid
            // Name: NoName
            object
            {
               object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

               scale < 3.75, 1.875, 3.75 >
               rotate < 180, 0, 0 >
               translate < 0, 8.1563, -1.5882e-22 > 
               pigment {rgbt <.5,.55,.6,.5>}
               finish {ambient .25 diffuse .75 phong 1}
            }
         }
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 6.875, 0.25, 6.875 >
                           translate < 0, 2.875, 0 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 4.625, 0.25, 4.625 >
                           translate < 0, 5.875, 0 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 7.75, 0.25, 7.625 >
                           rotate < 0, 0, 90 >
                           translate < 0.125, 0, 0 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 7.75, 0.25, 7.625 >
                           rotate < 90, 45, 0 >
                           translate < -0.088388, 0, -0.088388 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 7.75, 0.25, 7.625 >
                           rotate < 90, 0, 0 >
                           translate < 0, 0, -0.125 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 7.75, 0.25, 7.625 >
                           rotate < 90, -45, 0 >
                           translate < 0.088388, 0, -0.088388 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 2.5, 7.625, 4.625 >
                           rotate < 90, 0, 0 >
                           translate < 0, -1.1444e-21, -7.625 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 16.5, 6.375, 17.875 >
                     translate < -8.25, 0, -9 >
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 2.25, 7.625, 4.375 >
               rotate < 90, 0, 0 >
               translate < 0, -1.5637e-16, -8.125 >
            }
         }
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 3, 0.125 }
         translate < 0, 7, 0 >
         pigment {rgb .5}
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 2, 0.125 }
         translate < 0, 7.625, 0 > 
         pigment {rgb .5}
      }
      // Object type: Disc
      // Name: NoName
      object
      {
         disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

         scale < 2.375, 1, 4.375 >
         rotate < 90, 0, 0 >
         translate < 0, 2.0435e-22, -6.125 >
         pigment {rgb .25}
      }
sphere_sweep{
linear_sphere_sweep,
4,
<0,0,0>        ,.2
<0,5.375,0>    ,.2
<1.375,5.375,0>,.2
<1.375,5.875,0>,.2
translate <.25,0,0>   
translate <-3.5,0,-5.5>
pigment {rgb .5}
} 
sphere_sweep{
linear_sphere_sweep,
4,
<0,0,0>        ,.2
<0,5.375,0>    ,.2
<1.375,5.375,0>,.2
<1.375,5.875,0>,.2
translate <.25,0,0> 
scale <-1,1,1>  
translate <-3.5,0,-5.5>
pigment {rgb .5}
}
union {
sphere {0,1
pigment {Clear}
hollow
no_shadow
interior {
media {
emission <.75,.75,1>*1.5
absorption 1
density {
spherical
color_map {
[0 rgb 0]  
[.75 rgb .5]
[1 rgb 10]
}       
}        
}
}
scale 1
}
scale 2 rotate 151*x translate <1.375,5.875,0> translate <-3.25,0,-6>
}
union {
sphere {0,1
pigment {Clear}
hollow
no_shadow
interior {
media {
emission <.75,.75,1>*1.5
absorption 1
sample_method 2
density {
spherical
color_map {
[0 rgb 0]  
[.75 rgb .5]
[1 rgb 10]
}       
}        
}
}
scale 1
}
scale 2 rotate 151*x translate <1.375,5.875,0> translate .25*x scale <-1,1,1> translate <-3.5,0,-6> 
}  
}
pigment {rgb 1.5}
}
//Radar transmitter, with snow nestled in the lip
#declare Radar = 
union {

      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Paraboloid
                  // Name: NoName
                  object
                  {
                     object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                     scale < 60, 20, 60 >
                     rotate < -40, -20, 0 >
                     translate < -122, 57, 49 >
                  }
                  // Object type: Paraboloid
                  // Name: NoName
                  object
                  {
                     object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                     scale < 60, 20, 60 >
                     rotate < -40, -20, 0 >
                     translate < -121.56, 58.532, 47.792 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                           scale < 50, 20, 50 >
                           rotate < -40, -20, 0 >
                           translate < -122, 57, 49 >
                        }
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 10, 20, 110 >
                           rotate < -40, -20, 0 >
                           translate < -112.55, 22.289, 8.4182 >
                        }
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 110, 20, 10 >
                           rotate < -40, -20, 0 >
                           translate < -172.37, 53.786, 26.59 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                           scale < 15, 30, 15 >
                           rotate < -40, -20, 0 >
                           translate < -124.2, 49.34, 55.04 >
                        }
                     }
                  }
               }
texture {
pigment {
crackle metric 1
color_map {
[0 rgb .45]
[1 rgb .675]
}
scale 5
} 
finish {ambient .5 diffuse 1 phong .25}
}

         texture {Scarring} 
         texture {DishSnowTex} 
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 3, 20, 125 >
                     rotate < -42.633, 26.897, -38.623 >
                     translate < -164.7, 38.23, 9.6552 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -42.633, 26.897, -38.623 >
                           translate < -121.89, 57.383, 48.698 >
                        }
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -42.633, 26.897, -38.623 >
                           translate < -121.67, 58.149, 48.094 >
                        }
                     }
                  }
               }
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 3, 20, 125 >
                     rotate < -37.247, 3.6536, -18.787 >
                     translate < -138.24, 23.525, 0.63626 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -37.247, 3.6536, -18.787 >
                           translate < -121.89, 57.383, 48.698 >
                        }
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -37.247, 3.6536, -18.787 >
                           translate < -121.67, 58.149, 48.094 >
                        }
                     }
                  }
               }
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 3, 20, 125 >
                     rotate < -83.978, -52.6, 66.422 >
                     translate < -64.732, 36.56, 43.921 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -83.978, -52.6, 66.422 >
                           translate < -121.89, 57.383, 48.698 >
                        }
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -83.978, -52.6, 66.422 >
                           translate < -121.67, 58.149, 48.094 >
                        }
                     }
                  }
               }
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 3, 20, 125 >
                     rotate < -53.168, -41.005, 25.206 >
                     translate < -80.523, 22.561, 20.42 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -53.168, -41.005, 25.206 >
                           translate < -121.89, 57.383, 48.698 >
                        }
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -53.168, -41.005, 25.206 >
                           translate < -121.67, 58.149, 48.094 >
                        }
                     }
                  }
               }
            }
            // Object type: Paraboloid
            // Name: NoName
            object
            {
               object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

               scale < 59, 19, 59 >
               rotate < -40, -20, 0 >
               translate < -121.78, 57.766, 48.396 >
                texture {
                pigment {leopard color_map {[.2 rgb .3 transmit 0][.35 rgb .35 transmit 1]} scale .3}
                finish {phong 1 metallic ambient .25 diffuse 1}
                scale <1,100,1>
                rotate < -40, -20, 0 >
                translate < -121.78, 57.766, 48.396 >
                }
                texture {DishSnowTex} 
            }
         }
         texture {
         pigment {rgb .35}
         finish {phong 1 metallic ambient .25 diffuse 1} 
         }
         texture {Scarring}
         texture {DishSnowTex} 
      }

blob {
threshold .1
#macro SnowComp1(Rand,Rot)
#declare C=0
#while (C<10)
sphere {0,2,.125
scale <20*rand(seed(C*C+Rand))+5,2.5*rand(seed(C*C/3/7*C+Rand))+1.5,20*rand(seed(C*C*C+Rand))+5>*<1,1,1> 
rotate 30*(1-(C/10))*x
translate <0,-4*C,C*C>
translate <0,40,-100> 
rotate Rot*y  
scale <1,3,1>
}
#declare C=C+1//.75*rand(seed(C*Rand))+.25
#end 
#end
#declare Count=0
#while (Count<20)
SnowComp1(Count*Count+54676,-160*(Count/20)+80)
#declare Count=Count+1
#end 
pigment {rgb 2}
scale <1,1/2,1>
translate 45*y
scale 1/115
scale<60,20,60>
rotate<-40,-20,0>
translate<-122,57,49>

texture {
pigment {rgb 1.5}
normal {bumps scale 7.5 omega 0 bump_size .125}
finish {ambient .125 diffuse 1 }
}

}



union {
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < 10, 4, 10 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < 3, 15, 3 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < 2, 35, 2 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}

object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < 1, 65, 1 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < .5, 66, .5 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < .25, 67, .25 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}
texture {
pigment {rgb .75}
finish {phong 1 metallic ambient .25 diffuse 1}
}
texture {Scarring} 
texture {DishSnowTex}      
}


object {
cylinder{<0,0,0>,<0,1,0>,1}
scale<10,10,10>
translate<-121,32,49>
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale<9,2,9>
translate<-121,42,49>
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale<8,5,8>
translate<-121,44,49>
}      
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale<20,25,20>
translate<-121,0,49>
}
object {
cone{<0,0,0>,1,<0,1,0>,0.8}
scale<20,7,20>
translate<-121,25,49>
}
texture {ConcreteTex scale .5} 
translate -18*y
}



//passage connecting the radar tower with the main complex
#declare Rand = 234
#declare OverheadPassage = 
union {
//Objecttype:Difference
//Name:'andnot'
object
{
difference
{
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<43,6,18>
translate<-83,26,-9>
texture {SnowTex}
}
union {
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<110,1,20>
rotate<-115,0,0>
translate<-51,26,8>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<110,1,20>
rotate<115,0,0>
translate<-51,26,-8>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<-90,67.609,180>
translate<-83,1.0323e-21,-8>
}
texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb .75]
}
scale 1
scale <10,.5,10> 
translate -Rand
}
finish {ambient 1*rand(seed(Rand))+.75}
}
texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb <.4,.5,.6> transmit 1]
}
turbulence .5
scale 4 
translate Rand
}
finish {ambient 1*rand(seed(Rand))+.75}
}
texture {Blood scale 2}
texture {
pigment { gradient y triangle_wave
color_map {
[.5 rgb .75 transmit 1]
[.6 rgb .75           ]
}
}
finish {ambient .25 diffuse 1}
scale 5
translate 4*y
}

}
}
}
//Objecttype:Difference
//Name:'andnot'
object
{
difference
{
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>} 
scale<63,6,18>
rotate<0,45,0>
translate<-128.28,26,35.556>
texture {SnowTex}
}
union {
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<110,1,20>
rotate<-115,45,0>
translate<-93.636,26,24.95>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<110,1,20>
rotate<115,45,0>
translate<-104.95,26,13.636>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<90,-67.5,0>
translate<-83,0,-8>
}
texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb .75]
}
scale 1
scale <10,.5,10> 
translate -Rand
}
finish {ambient .6*rand(seed(Rand))}
}
texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb <.4,.5,.6> transmit 1]
}
turbulence .5
scale 4 
translate Rand
}
finish {ambient .6*rand(seed(Rand))}
}
texture {Blood scale 2}
texture {
pigment { gradient y triangle_wave
color_map {
[.5 rgb .75 transmit 1]
[.6 rgb .75           ]
}
}
finish {ambient .25 diffuse 1}
scale 5
translate 4*y
}



}
}
}
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<5,8,10>
translate<-76,18,-5>
}
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}
scale<5,8,10>
rotate<0,45,0>
translate<-101,18,14>
}
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 43, 2, 16 >
         translate < -83, 24, -8 >
      }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 62.933, 2, 16 >
         rotate < 0, 45, 0 >
         translate < -127.5, 24, 36 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2a

         scale < 12.5, 5, 7 >
         translate < -74.5, 29.5, -3.5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2a

         scale < 7, 5, 7 >
         translate < -90.5, 29.5, 3.5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2a

         scale < 7, 5, 7 >
         translate < -103.5, 29.5, 16.5 >
      }
      
#declare C=0;
#while (C < 32)
cylinder{<0,0,0>,<0,1,0>,1
scale<0.66,6.7057,0.5>
rotate<25,0,0>
translate<-48-C,26,-8>
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.66,6.706,0.5>
rotate<-25,0,0>
translate<-48-C,26,8> 
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
#declare C=C+8
#end

#declare C=0;
#while (C < 64)
cylinder{<0,0,0>,<0,1,0>,1
scale<0.66,6.7057,0.5>
rotate<25,0,0>
translate<-C,26,-9>
rotate 45*y
translate -79.1*x

texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.66,6.706,0.5>
rotate<-25,0,0>
translate<-C,26,9>
rotate 45*y
translate -79.1*x 
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
#declare C=C+8
#end


texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 10
} 
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
translate -18*y
}

//empty garage with a hole in one of the doors
#declare Garage = 
//Objecttype:Difference
//Name:'andnot'
union {
object {
difference {
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}
scale<72,18,64>
translate<-123,0,-30>
}
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}
scale<121,1.613,40.921>
rotate<-100,0,0>
translate<-67,0,28>
texture {ConcreteTex}
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}
scale<55.168,1.196,115.5>
rotate<0,0,-99.703>
translate<-122,1.4211e-14,0>
texture {ConcreteTex}
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}
scale<121,1.613,40.921>
rotate<117.31,0,0>
translate<-67,-2.0872e-14,-25>
texture {SnowTex}
}

//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<92,17,39>
translate<-104,-1,-15>
}
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<26,17,53>
translate<-86,-1,-28>
}
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<26,17,53>
translate<-118,-1,-28>
}

}

}
object {
box{<0,0,0>,<1,1,1>}
scale<28,14,0.88379>
rotate<27.897,0,0>
translate<-87,4,-22>
texture {
pigment {
image_map {
png "ibrokeit2.png"  
interpolate 2
}
} 
finish {ambient .75 diffuse 2 } 
scale <28,14,1> 
rotate <27.897,0,0>
translate<-87,4,-22>     
}
}
object {
box{<0,0,0>,<1,1,1>}
scale<28,6.7064,0.88379>
rotate<27.897,0,0>
translate<-119,11,-18>
texture {
pigment {
image_map {
png "door.png"  
interpolate 2
}
} 
finish {ambient .75 diffuse 2 } 
scale <28,13,1> 
rotate <27.897,0,0>
translate<-119,11,-18>     
}
}
texture {ConcreteTex}
translate -18*y
}



//one floor of the main complex
#macro OfficeFloor(Rand,FloorNum,SNOW)
union {
object {
difference {
//Objecttype:Box
//Name:NoName
object {
box{<0,0,0>,<1,1,1>}
scale<100,6,100>
translate<-50,0,-50>
}
union {
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,115>
translate<50,3.9593e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<-115,0,0>
translate<1.9722e-31,0,50>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,-115>
translate<-50,3.986e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<115,0,0>
translate<0,0,-50>
}

texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb 1]
}
scale 1
scale <10,.5,10> 
translate -Rand
}
finish {ambient 1*rand(seed(Rand))+.75 diffuse 1 }
}
texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb <.4,.5,.6> transmit 1]
}
turbulence .5
scale 4 
translate Rand
}
finish {ambient 1*rand(seed(Rand))+.75 diffuse 1 }
}
texture {
pigment { bozo
color_map { 
[.2 rgb <.4,.5,.6>*.5]
[.4 rgb <.4,.5,.6>*.5 transmit 1]
}
turbulence .5
scale 12 
translate Rand
}
finish {ambient 1*rand(seed(Rand))+.75 phong 1 diffuse 1 }
}
#if ((rand(seed(Rand))*1)>.25)
texture {Blood translate Rand}
#end
#if ((rand(seed(Rand))*1)>.75)
texture {Blood translate Rand scale 2}
#end
texture {Blood translate -Rand scale 4}
texture {
pigment { gradient y triangle_wave
color_map {
[.5 rgb .75 transmit 1]
[.6 rgb .75           ]
}
}
finish {ambient .25 diffuse 1}
scale 5
translate 3*y
}

}
}
texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 10
} 
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring} 
#if (SNOW=1)
texture {
pigment {
bozo
color_map {
[.4 rgbt 1]
[.6 rgb 1]
}
scale 5
turbulence .5
}
normal {crackle metric 4 bump_size 2 scale 20} 
finish {ambient .125 diffuse 1}
}
#end  
}
#declare C=0;
#while (C < 90)
cylinder{<0,0,0>,<0,1,0>,1
scale<0.5,7.5,0.75>
rotate<0,0,-25>
translate<-50,0,-45+C>
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.5,7.5,0.75>
rotate<0,0,-25>
translate<-50,0,-45+C>
rotate 90*y
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.5,7.5,0.75>
rotate<0,0,-25>
translate<-50,0,-45+C> 
rotate -90*y
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.5,7.5,0.75>
rotate<0,0,-25>
translate<-50,0,-45+C> 
rotate 180*y
texture {
pigment {rgb .5}
finish {ambient .25 diffuse 1 phong .25}
}
texture {Scarring}
}           
#declare C=C+8
#end 

object {
box{<0,0,0>,<1,1,1>}
scale<100,1,100>
translate<-50,-1,-50>
}
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
translate 7*FloorNum*y 
}
#end

//one of the top two floors - top one has snow on it
#macro OfficeTopper(FloorNum,SNOW)
union {
object {
difference {
//Objecttype:Box
//Name:NoName
object {
box{<0,0,0>,<1,1,1>}
scale<100,6,100>
translate<-50,0,-50>
}
union {
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,115>
translate<50,3.9593e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<-115,0,0>
translate<1.9722e-31,0,50>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,-115>
translate<-50,3.986e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<115,0,0>
translate<0,0,-50>
}
}
}   
}
#declare C=0;
#while (C < 90)
cylinder{<0,0,0>,<0,1,0>,1
scale<0.75,21,0.5>
rotate<0,0,-25>
translate<-56,-13,-45+C>
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.75,21,0.5>
rotate<0,0,-25>
translate<-56,-13,-45+C>
rotate 90*y
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.75,21,0.5>
rotate<0,0,-25>
translate<-56,-13,-45+C>
rotate -90*y
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.75,21,0.5>
rotate<0,0,-25>
translate<-56,-13,-45+C>
rotate 180*y
texture {
pigment {rgb .5}
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
}           
#declare C=C+8
#end

object {
box{<0,0,0>,<1,1,1>}
scale<100,1,100>
translate<-50,-1,-50>
}
texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 10
} 
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring}
#if (SNOW=1)
texture {
pigment {
bozo
color_map {
[.4 rgbt 1]
[.6 rgb 1]
}
scale 5
turbulence .5
}
normal {crackle metric 4 bump_size 2 scale 20} 
finish {ambient .125 diffuse 1}
}
#end

scale .8
translate 7*FloorNum*y 
}
#end

//Concrete Base
#macro OfficeBase()
union {
object {
difference {
//Objecttype:Box
//Name:NoName
object {
box{<0,0,0>,<1,1,1>}
scale<100,6,100>
translate<-50,0,-50>
}
union {
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,115>
translate<50,3.9593e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<-115,0,0>
translate<1.9722e-31,0,50>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,-115>
translate<-50,3.986e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<115,0,0>
translate<0,0,-50>
}
}
}   
}

texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 5
rotate 90*x
} 
finish {ambient .5 diffuse 1 phong .25}
}
texture {Scarring} 
texture {
pigment {
bozo
color_map {
[.5 rgbt 1]
[1 rgb 1]
}
scale 2
turbulence 1
} 
finish {ambient .25 diffuse 1}
}
scale <1.1,3,1.1>
translate -18*y
}
#end

//The background height-field and blob foreground
#declare Foreground = //(pun intended)
union {
//basics of the foreground - large spheres
blob {threshold .1
sphere {0,1,.05 
scale <10000000,8.2,10000000>
translate -.5*y
}
sphere {0,1,.15 
scale <10000000,6.2,10000000>
translate -.75*y
}
sphere {0,1,.3 
scale <10000000,4.2,10000000>
translate -1*y
} 
sphere {0,1,.6
scale <10000000,1.2,10000000>
translate -1.25*y
} 
//Snow around the right hut
sphere {0,1.25,.5
scale <25,25,25>*.375
translate <-58,0,-193+7>
pigment {rgb 1.5} 
finish {ambient .25 diffuse 1}
}
sphere {0,1.25,-.5
scale <20,20,20>*.375
translate <-58,15,-193+7>
pigment {rgb 1.5} 
finish {ambient .25 diffuse 1}
}
sphere {0,1.25,-.5/4
scale <8,25,50>*.375
translate <-58,10,-193>
}
sphere {0,1.25,-.5/2
scale <8,25,50>*.25
translate <-58,10,-193>
}
sphere {0,1.25,-.5
scale <8,25,50>*.25
translate <-58,10,-193>
}


//Snow around the left hut
sphere {0,1.25,.5
scale <25,25,25>*.375
rotate 30*y
translate <-125,0,-175> 
}
sphere {0,1.25,-.5
scale <20,20,20>*.375
rotate 30*y
translate <-125,15,-175> 
}
sphere {0,1.25,-.5/4
scale <8,25,50>*.375
rotate 30*y
translate <-125,10,-175> 
}
sphere {0,1.25,-.5/2
scale <8,25,50>*.25
rotate 30*y
translate <-125,10,-175> 
}
sphere {0,1.25,-.5
scale <8,25,50>*.25
rotate 30*y
translate <-125,10,-175> 
}



//Piled up snow (from crash)
sphere {0,1,.6
scale <30,20,30>
translate <-100,-10,-275>*.975 
pigment {rgb 1.5}
}
sphere {0,1,.4
scale <30,25,30>
translate <-100,-10,-275>*.975
pigment {rgb 1.5}
}
sphere {0,1,.6 
scale <30,20,30>
translate <-100,0,-275>*1
translate -10*y
pigment {rgb 1.5}
}
sphere {0,1,.6
scale <40,20,30>
translate <-100,0,-275>*1.05  
translate -10*y
pigment {rgb 1.5}
} 
sphere {0,1,.6
scale <30,20,30>
translate <-100,0,-275>*1.1 
translate -10*y  
pigment {rgb 1.5}
}
sphere {0,1,.6
scale <30,20,30>
translate <-100,0,-275>*1.15 
translate -10*y
pigment {rgb 1.5}
}
sphere {0,1,.6
scale <30,20,30>
translate <-100,0,-275>*1.2 
translate -10*y
pigment {rgb 1.5}
} 
sphere {0,1,.6
scale <30,20,30>
translate <-100,0,-275>*1.25 
translate -10*y
pigment {rgb 1.5}
}


//Trough dug by the pod
cylinder {<-100,0,-275>*1,<-100,0,-275>*1.8,12,-.5 scale <1,1.5,1>}
cylinder {<-100,0,-275>*1,<-100,0,-275>*1.8,12,-.125 scale <1,1.5,1>} 
cylinder {<-100,0,-275>*1,<-100,0,-275>*1.8,12,-.125 scale <1,1.5,1>}

//Stiff in the snow
#macro BodyNumber1(Loc,Rot,Scale)
#macro BN1T(Loc1,Rot1,Scale1)
scale Scale1
rotate Rot1
translate Loc1
#end
sphere{<0,0,0>,1.8,.125
scale<4,4,14>
rotate<0,-10.666,0>
translate<8,0,-14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<4,4,14>
rotate<0,-3.5958,0>
translate<-2,0,-14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<8.0565,4,14>
rotate<0,-4.9556,0>
translate<1,0,8> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.5016,4,11.401>
rotate<0,-52.94,0>
translate<18,0,-31> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.5452,4,11.401>
rotate<0,-23.195,0>
translate<2,0,-35>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.149,3,11.401>
rotate<0,-58.507,0>
translate<12.5,0,14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.149,3,11.401>
rotate<180,-40.117,180>
translate<-9,0,11>  
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<4,3,8>
rotate<-15.623,-80.493,0>
translate<12,2.5,10>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<2.466,3,11.401>
rotate<0,5.9581,0>
translate<-16.5,0,-6> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<5.5,4.5,6.7051>
rotate<0,28.301,0>
translate<6,1.2496e-30,37>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,1.8,.125
scale<3.5277,3,6.7051>
rotate<0,-6.225,0>
translate<0.5,0,17.5>
BN1T(Loc,Rot,Scale)
}






sphere{<0,0,0>,3,.125/4
scale<4,4,14>
rotate<0,-10.666,0>
translate<8,0,-14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<4,4,14>
rotate<0,-3.5958,0>
translate<-2,0,-14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<8.0565,4.5,14>
rotate<0,-4.9556,0>
translate<1,0,8> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.5016,4,11.401>
rotate<0,-52.94,0>
translate<18,0,-31> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.5452,4,11.401>
rotate<0,-23.195,0>
translate<2,0,-35>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.149,3,11.401>
rotate<0,-58.507,0>
translate<12.5,0,14>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.149,3,11.401>
rotate<180,-40.117,180>
translate<-9,0,11>  
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<4,3,8>
rotate<-15.623,-80.493,0>
translate<12,2.5,10>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<2.466,3,11.401>
rotate<0,5.9581,0>
translate<-16.5,0,-6> 
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<5.5,4.5,6.7051>
rotate<0,28.301,0>
translate<6,1.2496e-30,37>
BN1T(Loc,Rot,Scale)
}
sphere{<0,0,0>,3,.125/4
scale<3.5277,3,6.7051>
rotate<0,-6.225,0>
translate<0.5,0,17.5>
BN1T(Loc,Rot,Scale)
}  
#end

//one of the slither marks to be used in the tracks
#macro SlitherMarks(Loc,Rot)
sphere {0,.25,-.05/3
scale <20,40,40>
rotate Rot*y
scale .5
translate Loc
}
sphere {0,.25,-.05/6
scale <40,40,40>
rotate Rot*y 
scale .5
translate Loc
}
#end
//two of the foot marks to be used in the tracks
#macro FootPrints(Loc,Rot)
sphere {0,.25,-.05/2
scale <5,34,10>
translate <-.75,0,-2> 
rotate Rot*y
scale .5
translate Loc
}
sphere {0,.25,-.05/2
scale <5,34,10>
translate <.75,0,2>
rotate Rot*y 
scale .5
translate Loc
}
sphere {0,.25,-.1/6
scale <7.5,30,120>
translate <-.75,0,-2> 
rotate Rot*y
scale .5
translate Loc
}
sphere {0,.25,-.1/6
scale <7.5,30,120>
translate <.75,0,2>
rotate Rot*y 
scale .5
translate Loc
} 
#end 
 
//path of footprints part 1 
#declare FootPrintRoute = spline {
cubic_spline 
0    ,<-128,0,-285>
1/12 ,<-126,0,-275>  
2/12 ,<-123,0,-265>  
3/12 ,<-120,0,-255>  
4/12 ,<-113,0,-248>   
5/12 ,<-106,0,-241>   
6/12 ,<-99,0,-234>   
7/12 ,<-90,0,-227>   
8/12 ,<-80,0,-221>    
9/12 ,<-73,0,-215>    
10/12,<-66,0,-208>   
11/12,<-60,0,-200>   
1   ,<-58,0,-193>
}
FPrints(32) 

//path of footprints part 2
#declare FootPrintRoute = spline {
cubic_spline
0   ,<-126,0,-275>  
1/5 ,<-128,0,-285>
2/5 ,<-134,0,-282>  
3/5 ,<-144,0,-281>    
4/5 ,<-150,0,-280>    
1   ,<-151,0,-282>  
}
FPrints(12) 
                           
//path of slither part 1
#declare SlitherPath = spline {
cubic_spline
0   ,<-110,2,-278>  
1/11 ,<-120,2,-280>
2/11 ,<-130,0,-275>  
3/11 ,<-144,0,-278>    
4/11 ,<-150,0,-270>    
5/11 ,<-151,0,-260>
6/11 ,<-149,0,-250>  
7/11 ,<-140,0,-240> 
8/11 ,<-135,0,-235>   
9/11 ,<-130,0,-225>   
10/11 ,<-125,0,-215>   
1 ,<-115,0,-200>   
}
Slither(60) 

//path of slither part 2
#declare SlitherPath = spline {
cubic_spline
0   ,<-110,2,-278>  
1/11 ,<-115,2,-280>
2/11 ,<-120,0,-275>  
3/11 ,<-134,0,-260>    
4/11 ,<-130,0,-245>    
5/11 ,<-125,0,-235>
6/11 ,<-119,0,-225>  
7/11 ,<-110,0,-220> 
8/11 ,<-115,0,-215>   
9/11 ,<-110,0,-200>   
10/11 ,<-105,0,-190>   
1 ,<-100,0,-180>   
}
Slither(80)

//place the stiff
BodyNumber1(<-156,2.25,-280.5>,-90*y,<1,2,1>/15)

sphere {0,6,-.125/2 scale <2.5,1,1.5> translate <-110,2,-278>}
sphere {0,5.5,-.125/2 scale <2.5,1,1.5> translate <-110,2,-278>}
sphere {0,5,-.125/2 scale <2.5,1,1.5> translate <-110,2,-278>} 



texture {
pigment {rgb 1.5}
normal {bumps scale 7.5 omega 0 turbulence .5 bump_size .125/2}
}
texture {
pigment {
image_map {
png "BloodStain.png"  
interpolate 2 
once 
}
}
normal {bumps scale .001 bump_size .125/4} 
finish {ambient .5 diffuse 1 }  
translate <-.5,-.5,0>
rotate 90*z
scale <8,12,1>*.75 
rotate <90,0,0>
translate<-158,2.125,-279>     
}

texture {
pigment {
image_map {
png "BloodStain.png"  
interpolate 2 
once 
}
}
normal {bumps scale .001 bump_size .125/4} 
finish {ambient .5 diffuse 1 }  
translate <-.5,-.5,0>
rotate 90*z
scale <8,12,1>*1.5
rotate <90,0,0>
rotate 120*y 
scale <1,1.25,1> 
translate <-130,1,-185>    
}
texture {
pigment {
image_map {
png "BloodStain.png"  
interpolate 2 
once 
}
}
normal {bumps scale .001 bump_size .125/4} 
finish {ambient .5 diffuse 1 }  
translate <-.5,-.5,0>
rotate 90*z
scale <8,12,1>*1.5
rotate <90,0,0>
rotate 30*y 
scale <1,1.25,1> 
translate <-130,1,-180>    
}
sturm
}

//Background height field
difference {
height_field {
tga
"C:\Projects\ArcticHorror\Acrtic2.tga"
smooth
water_level .001
translate -.001*y
translate <-.5, 0, -.5>
scale <1200,120,1200>
rotate <0, 270, 0>
pigment {rgb 1.5} 
//normal {crackle metric 4 bump_size 1 scale 7.5}
}
box{0,1 
scale<71,20,51> 
translate<-119,-6,-25>
translate 18*y
translate <80,0,0>
}           
}
}



#declare OfficeComplex = 
union {
OfficeBase()
OfficeFloor(123,0,0)
OfficeFloor(234,1,0)
OfficeFloor(345,2,0)
OfficeFloor(455,3,0)
OfficeFloor(675,4,0)
OfficeFloor(787,5,0)
OfficeFloor(678,6,0)
OfficeFloor(879,7,0)
OfficeFloor(459,8,1)
difference {
OfficeTopper(9,0)
plane {y,0 translate 48*y}
}
OfficeTopper(10,1)  

light_source {
<-52.358,0,-52.669>
color rgb 2
spotlight
point_at < -68.959, -21.425, -65.529 >
radius 28
falloff 50
tightness 10
}
object {Light rotate <180,-64.5,-127.5> translate <-52.5,0,-52.5> rotate 0*y}

light_source {
<-119.17,0,-15.138>
color rgb 2
spotlight
point_at < -127, -21.425, -630 >
radius 28
falloff 50
tightness 10
}
object {Light rotate <180,-64.5,-127.5> translate <-119.17,0,-15.138> rotate 0*y}



//garage lights
light_source
{
< -73, -3, 0 >
color rgb .25
area_light 5,1,3,3
adaptive 0
fade_distance 75
fade_power 2
}
light_source
{
< -104, -3, 0 >
color rgb .5
area_light 5,1,3,3
adaptive 0
fade_distance 75
fade_power 2
}

union {Garage}
union {OverheadPassage}
union {Radar}
union {MarkerLights}

translate 18*y
translate <80,0,0>
} 
#declare Biotubes =
union {
#declare C=0
#while (C<5)
object {Biotube(1+C) translate C*12*x translate -5*3*x translate 8*z}
#declare C=C+1
#end
#declare C=0
#while (C<5)
object {Biotube(1+C) translate C*12*x translate -5*3*x translate -8*z}
#declare C=C+1
#end   
rotate -30*y
translate <-100,1.5,-30>
}

//union {Biotubes}
union {Foreground}
//union {OfficeComplex}
//union {GuardHut scale <1,1.25,1> translate <-58,1,-193+7>}   
//union {GuardHut rotate 30*y scale <1,1.25,1> translate <-125,1,-175>}
//union {AlienLandingPod scale <1,1,.75> scale .55 rotate 6*x rotate 20*y translate <-100,2,-275>*1.025}
//union {Fighter1}
//union {Fighter2}


global_settings{
max_trace_level 32 
}
