// Main cemetary include file

#include "gravetex.inc" // Textures
#include "markers.inc"  // Grave markers
#include "fence.inc"    // Cemetary fence
#include "mausleum.inc" // Mausoleum

#macro DimSun(Dist, Azim, Dir)
	light_source {
		z*Dist
		< 1.00, 0.95, 0.87 > * 100
		area_light
		<0, 8, 0>, <8, 0, 0>
		4, 4
	  adaptive 1
  	jitter
	  fade_distance 5
  	fade_power 1
	}
	rotate x*-Azim
	rotate y*Dir
#end

// Fountain
#macro fRound(ob)
	union {
		object { ob }
		object { ob rotate y* 20 }
		object { ob rotate y* 40 }
		object { ob rotate y* 60 }
		object { ob rotate y* 80 }
		object { ob rotate y*100 }
		object { ob rotate y*120 }
		object { ob rotate y*140 }
		object { ob rotate y*160 }
		object { ob rotate y*180 }
		object { ob rotate y*200 }
		object { ob rotate y*220 }
		object { ob rotate y*240 }
		object { ob rotate y*260 }
		object { ob rotate y*280 }
		object { ob rotate y*300 }
		object { ob rotate y*320 }
		object { ob rotate y*340 }
	}
#end

#declare fBody = lathe {
	cubic_spline
	42,
	<28, -1>, <28, 0>, <27, 2>, <25, 4>, <22, 3>, <18, 2>, <12, 1>,
	<6, 1>, <3, 2>, <2, 5>, <4, 7>, <2, 9>, <4, 11>, <2, 13>,
	<4, 15>, <6, 16>, <9, 17>, <11, 18>, <13, 20>, <13, 21>, <12, 21>, <11, 19>,
	<9, 18>, <6, 17>, <4, 18>, <2, 20>, <4, 22>, <2, 24>, <4, 26>,
	<2, 28>, <4, 30>, <2, 32>, <4, 33>, <7, 34>, <9, 36>, <8, 37>, 
	<7, 35>, <4, 34>,	<2, 35>, <1, 38>, <0, 34>, <-1, 34>
}

#declare fbCut = cone { <16, 15, 0>, 2.5, <8.5, 40, 0>, 1.5 scale <1, 1, .5> }

#declare fBase = difference {
	object { fBody }
	fRound(fbCut)
	texture { FountCol }
}

#declare fwBase = union {
	cylinder { y*.5, y*4, 25 }
	intersection {
		sphere { 0, 12 scale <1, .45, 1> }
		plane { y, 0 }
		translate y*21
	}
	intersection {
		sphere { 0, 8 scale <1, .55, 1> }
		plane { y, 0 }
		translate y*37
	}
}

#declare fwCut = intersection {
	fRound(fbCut)
	object { fBody }
}

// create a 4th order infinite polynomial surface
#declare fwTop = intersection {
	quartic {
<
// x^4,        x^3y,       x^3z,       x^3,        x^2y^2,
   1,          0,          0,          0,          0,
// x^2yz,      x^2y,       x^2z^2,     x^2z,       x^2,
   0,          0,          2,          0,         -8,
// xy^3,       xy^2z,      xy^2,       xyz^2,      xyz,
   0,          0,          0,          0,          0,
// xy,         xz^3,       xz^2,       xz,         x,
   0,          0,          0,          0,          0,
// y^4,        y^3z,       y^3,        y^2z^2,     y^2z,
   0,          0,          0,          0,          0,
// y^2,        yz^3,       yz^2,       yz,         y,
   0,          0,          0,          0,       -150,
// z^4,        z^3,        z^2,        z,          C           
   1,          0,         -8,          0,          16
>
  sturm // optional, slower but reduces speckles
	}
	plane { y, 5 }
	rotate z*180
  translate y*40
}

#declare fwFall = union {
	cone { <8.5, 37, 0>, .3, <9.3, 21, 0>, .5 }
	torus { .7, .3 translate <9.3, 21, 0> }
	cone { <13, 21, 0>, .4, <13.4, 4, 0>, .7 }
	torus { 1.1, .5 translate <13.4, 4, 0> }
}

#declare fWater = merge {
	object { fwBase }
	object { fwCut }
	object { fwTop }
	fRound(fwFall)
	material { Water }
}

#declare Fountain = union {
	object { fBase }
	object { fWater }
	scale .6
}


// Road

#macro rSide(Start, End)
	prism {
		linear_sweep
		linear_spline
		-Start, -End
		5
		<-.5, 0.0>, <-.3, 0.5>, <0.3, 0.5>, <0.5, 0.0>, <-.5, 0.0>
		rotate x*-90
		texture { T_Stone52 }
	}
#end

#macro rFlat(Start, End, Turn)
	object { rSide(Start, End) translate x*-7 }
	prism {
		linear_sweep
		linear_spline
		-Start, -End
		5
		<-.5, 0.0>, <-.3, 0.5>, <0.3, 0.5>, <0.5, 0.0>, <-.5, 0.0>
		rotate x*-90
		translate x*7
		texture { T_Stone52 }
	}
	box {
		<-7, 0, Start>, <7, .1, End>
		texture { RoadCol rotate y*Turn }
	}
#end

#macro rCurve(Radius)
	intersection {
		lathe {
			linear_spline
			5
			<Radius+.5, 0>, <Radius+.3, .5>, <Radius-.3, .5>, <Radius-.5, 0>, <Radius+.5, 0> 
		}
		plane { -x, 0 }
		plane { z, 0 }
		texture { T_Stone52 }
	}
#end

#declare rcBed = difference {
	union {
		cylinder { <8, 0, -8>, <8, .1, -8>, 15 }
		box { 0, <8, .1, -23> }
		box { 0, <23, .1, -8> }
	}
	plane { x, 0 }
	plane { -z, 0 }
	cylinder { y*-.1, y*.2, 9 }
	texture { RoadCol }
}
	
#declare Road = union {
	union { rFlat(0, 88, 0) translate x*16 }
	union { rFlat(0, 88, 90) translate x*-16 rotate y*-90 }
	object { rSide(-8, 0) translate x*23 }
	object { rSide(-8, 0) translate x*-23 rotate y*-90 }
	rCurve(9)
	object { rCurve(15) translate <8, 0, -8> }
	object { rcBed }
}

// Objects

#declare Medallion1 = object {
	Cross()
	scale <0.08, 0.08, 0.02>
	MetalTex("Silver", 3, 4)
}

#declare PentBars = union {
	intersection {
		cylinder { 0, y*.1, 1 }
		plane { z, .35 }
		plane { -z, -.25 }
	}
	intersection {
		cylinder { 0, y*.1, 1 }
		plane { z, .85 }
		plane { -z, -.75 }
		rotate y*36
	}
}

#declare Pentagram = union {
	object { PentBars }
	object { PentBars rotate y* 72 }
	object { PentBars rotate y*144 }
	object { PentBars rotate y*216 }
	object { PentBars rotate y*288 }
}

#declare Medallion2 = object {
	Pentagram
	scale 0.3
	MetalTex("Iron", 2, 5)
}

// Skulls
#declare Tooth = difference {
	intersection {
		sphere { 0, 1 }
		plane { -z, 0 }
		plane {-x, 0 rotate z* 6 }
		plane { x, 0 rotate z*- 6 }
		plane {-y, 0 rotate x*-45 }
	}
	sphere { 0, 1 scale <1, 0.90, 1> }
	translate y*-.95
	scale <.2, .1, .3>
	rotate x*90
}

#declare Jaw = union {
	object { Tooth translate z*0.3 rotate y*  5 }
	object { Tooth translate z*0.3 rotate y* -5 }
	object { Tooth translate z*0.3 rotate y* 15 }
	object { Tooth translate z*0.3 rotate y*-15 }
	object { Tooth scale <1, 1.4, 1> translate z*0.3 rotate y* 25 }
	object { Tooth scale <1, 1.4, 1> translate z*0.3 rotate y*-25 }
	object { Tooth translate z*0.3 rotate y* 35 }
	object { Tooth translate z*0.3 rotate y*-35 }
	object { Tooth translate z*0.3 rotate y* 45 }
	object { Tooth translate z*0.3 rotate y*-45 }
	scale <1, 0.3, 0.7>
}

#declare SkullBody = blob {
	threshold 0.1
	sphere { < 0.00, 0.50,-0.20>, 0.50, 1 scale <1.5, 1.0, 2.0> }
	sphere { < 0.00, 0.35,-0.20>, 0.40,-3 scale <1.3, 1.2, 2.0> }
	sphere { < 0.00, 0.20,-0.20>, 0.50, 1 scale <1.1, 1.0, 2.0> }
	sphere { < 0.20, 0.40, 0.10>, 0.30, 1 scale <1.0, 1.0, 0.9> }
	sphere { <-0.20, 0.40, 0.10>, 0.30, 1 scale <1.0, 1.0, 0.9> }
	sphere { < 0.00, 0.35,-0.10>, 0.30, 1 scale <1.4, 1.0, 2.0> }
	sphere { < 0.00, 0.20, 0.20>, 0.30, 1 scale <1.7, 1.0, 1.0> }
	sphere { < 0.00, 0.20, 0.10>, 0.30,-2 scale <1.7, 1.5, 1.0> }
	sphere { < 0.15, 0.60, 0.10>, 0.10,-3 scale <1.2, 1.0, 4.0> }
	sphere { < 0.00, 0.40, 0.07>, 0.10,-3 scale <1.0, 1.0, 4.0> }
	sphere { <-0.15, 0.60, 0.10>, 0.10,-3 scale <1.2, 1.0, 4.0> }
	sphere { < 0.00, 0.20, 0.12>, 0.10,-3 scale <3.0, 1.0, 5.0> }
}

#declare Skull = union {
	object { SkullBody }
	object { Jaw rotate x*-20 translate <0.00, 0.20, 0.25> }
	object { Jaw rotate <-20, 0, 180> translate <0.00, 0.20, 0.25> }
	texture { Bone }
	scale 0.5
}

