/* Other include file textures:
	T_Wood33 from woods.inc
*/

// Grave Markers

#declare DirtMap1 = color_map {
	[ 0.0 color rgb <0.15, 0.10, 0.05> ]
	[ 0.5 color rgb <0.12, 0.12, 0.05> ]
	[ 1.0 color rgb <0.15, 0.10, 0.05> ]
}

#declare DirtMap2 = color_map {
	[ 0.0 color rgb <0.10, 0.10, 0.05> ]
	[ 0.5 color rgb <0.15, 0.05, 0.05> ]
	[ 1.0 color rgb <0.10, 0.10, 0.05> ]
}

#declare Dirt1 = texture {
	pigment {
		bozo turbulence 1.3 omega 0.75
		color_map { DirtMap1 }
	}
	normal { bozo turbulence 1.3 omega 0.75 }
}

#declare Dirt2 = texture {
	pigment {
		bozo turbulence 1.3 omega 0.75
		color_map { DirtMap2 }
	}
	normal { bozo turbulence 1.3 omega 0.75 }
}

#declare Stone1 = texture { T_Stone54 }

#declare m1Col = texture { T_Stone61 scale 40 }
#declare m1cCol = texture { T_Stone59 }
#declare m2Col = texture { T_Stone55 scale 3 }
#declare m2bCol = texture { T_Stone5 }
#declare m3Col = texture { T_Stone53 scale .2 }
#declare m4Col = texture { T_Stone58 scale .05 }
#declare m4cCol = texture { T_Stone60 scale .5 }
#declare m5Col = texture { T_Stone6 scale .15 }
#declare m5cCol = texture { T_Stone50 scale .40 }

// Bone

#declare Bone = texture {
	pigment {
		granite
		color_map {
			[ 0.00 color rgb < 0.80, 0.80, 0.40> ]
			[ 0.13 color rgb < 0.70, 0.70, 0.70> ]
			[ 0.26 color rgb < 0.90, 0.70, 0.50> ]
			[ 0.39 color rgb < 0.85, 0.85, 0.80> ]
			[ 0.52 color rgb < 0.80, 0.80, 0.80> ]
			[ 0.65 color rgb < 0.70, 0.85, 0.85> ]
			[ 0.78 color rgb < 0.75, 0.85, 0.95> ]
			[ 0.91 color rgb < 0.70, 0.70, 0.70> ]
			[ 1.00 color rgb < 0.80, 0.80, 0.40> ]
		}
	}
	normal { granite 0.3 scale 0.3 }
	finish { phong 0.2 phong_size 24 }
	scale 0.1
}

// Fountain

#declare wClear = pigment { rgbt <0.0, 0.2, 1.0, 0.8> }
#declare wBlood = pigment { rgbt <0.4, 0.0, 1.0, 0.7> }

#declare Water = material {
	texture {
		pigment { wBlood }
		normal {
			bozo
			turbulence 0.5
			normal_map {
				[ 0.00 ripples 0.5 ]
				[ 0.17 waves 0.3 ]
				[ 0.33 ripples 0.5 rotate y*120 ]
				[ 0.50 waves 0.3 rotate y*-120 ]
				[ 0.67 ripples 0.5 rotate y*-120 ]
				[ 0.83 waves 0.3 rotate y*120 ]
				[ 1.00 ripples 0.5 ]
			}
		}
		finish {
			ambient 0
			reflection 0.2
			phong 0.6
			phong_size 150
			metallic 0.2
		}
	}
	interior { ior 1.3 caustics 0.8 }
}

#declare FountCol = texture { T_Stone24 }

// Gate

#declare gMetBase = MetalTex("Iron", 4, 2)

#declare Rust = texture {
	pigment {
		granite
		color_map {
			[ 0.1 rgb <0.0, 0.0, 0.0> ]
			[ 0.2 rgb <0.2, 0.0, 0.0> ]
			[ 0.5 rgb <0.2, 0.1, 0.0> ]
			[ 0.8 rgb <0.2, 0.0, 0.0> ]
			[ 0.9 rgb <0.0, 0.0, 0.0> ]
		}
	}
	normal { granite .3 }
	finish { ambient 0 diffuse 1 }
	scale .25
}

#declare gMetal = texture {
	bozo
	turbulence 0.5
	frequency 3
	texture_map {
		[ 0.03 Rust ]
		[ 0.03 gMetBase ]
	}
	scale .1
}

// Mausoleum

#declare Moss = texture {
	pigment {
		crackle
		turbulence .4
		color_map {
			[ 0.4 rgbt 0.6 ]
			[ 0.4 rgb <0.13, 0.46, 0.22> ]
			[ 0.6 rgb <0.23, 0.46, 0.12> ]
			[ 0.6 rgbt 0.6 ]
		}
	}
	normal { crackle turbulence .4 }
}

#declare Rot2 = texture {
	pigment {
		bozo
		turbulence 0.9
		octaves 7
		omega .70
		color_map {
			[ 0.98 rgbt 0.90 ]
			[ 1.00 rgbt 0.10 ]
		}
	}
	normal {
		bozo .5
		turbulence 0.9
		octaves 7
		omega .70
	}
	finish{
		phong 1.0
		phong_size 90
		ambient 0.2
	}
	scale 5
}
	
#declare Mausocol =	texture { T_Stone62 }

// Similar to T_WoodB, but brighter
#declare T_Wood33 =
texture {
    pigment {
        wood turbulence 0.0425
        scale 0.2
        color_map {
            [0.05 color rgbf <0.55294, 0.21176, 0.00000, 0.0>]
            [0.15 color rgbf <0.32549, 0.13725, 0.00000, 0.0>]
            [0.25 color rgbf <0.55294, 0.21176, 0.00000, 0.0>]
            [0.35 color rgbf <0.32549, 0.11765, 0.00000, 0.0>]
            [0.48 color rgbf <0.55294, 0.21176, 0.00000, 0.0>]
            [0.55 color rgbf <0.29412, 0.13725, 0.01176, 0.0>]
            [0.65 color rgbf <0.55294, 0.21176, 0.00000, 0.0>]
            [0.78 color rgbf <0.32549, 0.13725, 0.00000, 0.0>]
            [0.85 color rgbf <0.55294, 0.21176, 0.00000, 0.0>]
            [0.96 color rgbf <0.28627, 0.13725, 0.00000, 0.0>]
            [1.00 color rgbf <0.54510, 0.17647, 0.03529, 0.0>]
        }
        translate <.015, 0, 0>
    }
}

#declare DoorWood = texture { T_Wood33 }

// Road

#declare Brick = texture {
	pigment {
		hexagon
		pigment { rgb <0.5, 0.1, 0.1> }
		pigment { rgb <0.2, 0.1, 0.1> }
		pigment { rgb <0.1, 0.0, 0.0> }
	}		
	normal { agate 0.3 agate_turb 0.8 }
	finish { phong 0.2 phong_size 20 }
	scale .5
}

#declare RoadCol =
	texture { Brick }
	texture { Moss }
