// Mausoleum
#declare BaseCut = quadric { <0, 0, 1>, <0, 0, 0>, <1, 0, 0>, -1 scale <.8, 1, .20> translate z*.1 }
#declare ColCut = quadric { <0, 0, 1>, <0, 0, 0>, <1, 0, 0>, -1 scale <.8, 1, .15> translate z*.3 }

#macro cRound(ob)
	union {
		object { ob }
		object { ob rotate y* 36 }
		object { ob rotate y* 72 }
		object { ob rotate y*108 }
		object { ob rotate y*144 }
		object { ob rotate y*180 }
		object { ob rotate y*216 }
		object { ob rotate y*252 }
		object { ob rotate y*288 }
		object { ob rotate y*324 }
	}
#end

#declare UpperBase = lathe {
	cubic_spline
	8
	<2.0,-0.1>, <2.0, 0.0>, <1.6, 0.4>, <1.4, 0.2>, 
	<1.1, 0.4>, <0.9, 0.7>, <0.8, 1.0>, <0.8, 2.0>
}

#declare LowerBase = lathe {
	cubic_spline
	8
	<2.0,-0.1>, <2.0, 0.0>, <1.6, 0.2>, <1.4, 0.1>, 
	<1.1, 0.2>, <0.9, 0.4>, <0.8, 0.6>, <0.8, 2.0>
}

#declare ColBase = union {
	difference {
		object { UpperBase }
		object { cRound(BaseCut) }
	}
	object { LowerBase }
	scale 2
}

#declare cH = 20; // Column Height

#declare ColBody = difference {
	cylinder { 0, y*cH, 1.6 }
	object { cRound(ColCut) }
}

#declare mColumn = union {
	object { ColBase }
	object { ColBody }
	object { ColBase rotate z*180 translate y*cH }
	scale <.3, 1, .3>
}

#macro mcLine( ob, st, dir, num )
	#local pos = st;
	#local i = 0;
	#while (i<num)
		object { ob translate pos }
		#local pos = pos + dir;
		#local i = i + 1;
	#end
#end

#declare mColumns = union {
	mcLine ( mColumn, <-12, 1, 20>, x*4, 3 )
	mcLine ( mColumn, < 12, 1, 20>, x*-4, 3 )
	mcLine ( mColumn, <-12, 1, -20>, x*4, 7 )
	mcLine ( mColumn, <-12, 1, -16>, z*4, 9 )
	mcLine ( mColumn, < 12, 1, -16>, z*4, 9 )
}

#declare mFound = union {
	box { <-15.0, 0.00, -23.0>, <15.0, 0.25, 23.0> }	
	box { <-14.5, 0.25, -22.5>, <14.5, 0.50, 22.5> }	
	box { <-14.0, 0.50, -22.0>, <14.0, 0.75, 22.0> }	
	box { <-13.5, 0.75, -21.5>, <13.5, 1.00, 21.5> }	
}

#declare mRoof = intersection {
	box { <-15.0,-0.25, -23.0>, <15.0, 8.00, 23.0> }
	plane { <-1, 2, 0>, 0 translate x*-15 }
	plane { < 1, 2, 0>, 0 translate x* 15 }
	plane { < 0, 2,-1>, 0 translate z*-23 }
	plane { < 0, 2, 1>, 0 translate z* 23 }	
}

#declare dH = 16;  // Door Height 
#declare dW = 7;  // Door Width 
#declare dM = 0.8; // Door Slope modifier
#declare bW = 10;  // Base Width
#declare bD = .25; // Wall Depth
#declare bL = 16;  // Base Length

#declare mBase = difference {
	box { <-bW, 0, -bL>, <bW, cH, bL> }
	box { <bD-bW, -1, bD-bL>, <bW-bD, cH-bD, bL-bD> }
	box { <-dW, -1, bL-2*bD>, <dW, dH, bL+bD> }
}

#declare mdHinge = union {
	prism {
		linear_sweep
		linear_spline
		0, .1, 5
		<0, .3>, <-.4, .1>, <-.4, -.1>, <0, -.3>, <0, .3>
	}
	cylinder { <-.4, 0, 0>, <-.4, .1, 0>, .1 }
	scale < 1.5, 1, 1 >
}

#declare mdHandle = union {
	intersection {
		torus { .3, .05 }
		plane { -x, 0 }
		plane { z, 0 }
		translate -z*dH*.2
		rotate z*90
	}
	intersection {
		torus { .3, .05 }
		plane { -x, 0 }
		plane { -z, 0 }
		translate z*dH*.2
		rotate z*90
	}
	cylinder { <0, .3, dH*.2>, <0, .3, -dH*.2>, .05 }
}

#declare mdFrame = union {
	box { <0, 0, 0>, <dW, .1, dW*.2> }
	box { <0, 0, dH-dW*.2>, <dW, .1, dH> }
	box { <0, 0, 0>, <dW*.2, .1, dH> }
	box { <dW*.8, 0, 0>, <dW, .1, dH> }
	intersection {
		box { <0, 0, 0>, <dW, .1, dH> }
		plane { <-dH, 0, dW*dM>, 0 translate <dW*.75, 0, dH-dW*.2> }
		plane { <dH, 0, -dW*dM>, 0 translate <dW*.25, 0, dW*.2> }
	}
	intersection {
		box { <0, 0, 0>, <dW, .1, dH> }
		plane { <dH, 0, dW*dM>, 0 translate <dW*.25, 0, dH-dW*.2> }
		plane { <-dH, 0, -dW*dM>, 0 translate <dW*.75, 0, dW*.2> }
	}
	object { mdHandle translate <dW*.9, .1, dH*.5> }
	object { mdHinge translate z*dH*.2 }
	object { mdHinge translate z*dH*.5 }
	object { mdHinge translate z*dH*.8 }
	MetalTex("Brass", 1, 1)
}

#declare mDoor = union {
	box { <0, -.4, 0>, <dW, 0, dH> texture { DoorWood } }
	object { mdFrame }
	rotate x*90
}

#declare mDoors = union {
	object { mDoor translate <-dW, dH, 0> }
	object { mDoor rotate z*180 translate <dW, 0, 0> }
}

#declare mlSide = prism {
	linear_spline
	linear_sweep
	-.03, .03, 9,
	<0.30, 0.75>, <0.35, 0.75>, <0.75, 0.25>, <0.75, -.25>, <0.35, -.75>, <0.30, -.75>, 
	<0.70, -.25>, <0.70, 0.25>, <0.30, 0.75>
	rotate x*90
}

#declare mlRing = prism {
	linear_spline
	linear_sweep
	-.03, 0.03, 18,
	<0.03, 0.75>, <0.75, 0.03>, <0.75, -.03>, <0.03, -.75>, <-.03, -.75>, <-.75, -.03>, 
	<-.75, 0.03>, <-.03, 0.75>, <0.03, 0.75>, <0.03, 0.70>, <0.70, 0.03>, <0.70, -.03>, 
	<0.03, -.70>, <-.03, -.70>, <-.70, -.03>, <-.70, 0.03>, <-.03, 0.70>, <0.03, 0.70>
}

#declare mlFace = union {
	box { <-.35, 0.70, -.03>, <0.35, 0.75, 0.03> }
	box { <-.35, 0.70, -.03>, <0.35, 0.75, 0.03> rotate y*90 }
}

#declare mlGrate = union {
	mRound( mlSide )
	object { mlRing translate y*.22 }
	object { mlRing translate y*-.22 }
	object { mlFace }
	object { mlFace scale <1, -1, 1> }
	box { <-.03, .75, -.03>, <0.03, 1, 0.03> }
	MetalTex("Silver", 5, 4)
}

#declare mlLight = union {
	sphere { 
		0, .2
		hollow
		scale <1, 2.5, 1>
		translate y*.2
		pigment { rgbft <0.94, 0.94, 0.88, 0.65, 0.80> }
	}
	light_source { 
		y*.2, rgb 1
		fade_distance cH/2
		fade_power 1.3
	}
}

#declare mLantern = union {
	object { mlGrate }
	object { mlLight }
}

#declare Mausoleum = union {
	object { mFound }
	object { mBase translate y }
	object { mDoors translate <0, 1, bL> }
	object { mRoof translate y*(cH+1.25) }
	object { mColumns }
	object { mLantern translate <-bW-1.5, cH+.00,-bL-1.5 > }
	object { mLantern translate < bW+1.5, cH+.00,-bL-1.5 > }
	object { mLantern translate <-bW-1.5, cH+.00, bL+1.5 > }
	object { mLantern translate < bW+1.5, cH+.00, bL+1.5 > }
	texture { Mausocol }
}
