// DO_Book.f
// This simulates a function when called with a #include statement.
// This will generate a random book using the random number stream Rb,
// which should be declared externally in the .inc file which calls this file.

// The following objects are defined as a result of calling this file:
//    Book
//       A book, standing upright as seen on a shelf.
//       Lower, left corner of spine is at <0,0,0>
// The following variables are defines as a result of callling this file:
//    Bwidth - the width of the book
//    Bheight - the height of the book
//    Bdepth - the depth of the book

#declare DO_BOOK1_F = version;
#version 3;

#declare Bwidth = rand(Rb)*4/100+0.015;
#declare Bheight = rand(Rb)*7/100+0.20;
#declare Bcthick = 0.1;
#declare Bdepth = rand(Rb)*15/100+0.20;

/*
#declare Bshape = difference {
union {
   box { <-Bwidth/2, 0, 0> <Bwidth/2, Bheight, Bdepth> }
   cylinder { <-Bwidth/4,0,0>, <-Bwidth/4, Bheight, 0>, Bwidth/4 scale <1,1,0.5> }
   cylinder { < Bwidth/4,0,0>, < Bwidth/4, Bheight, 0>, Bwidth/4 scale <1,1,0.5> }
   box { <-Bwidth/4,0,-Bwidth/4> <Bwidth/4,Bheight,0> scale <1,1,0.5> }
   }
box { <-1,-1,-1> <-Bwidth/2,1,1> }
box { <Bwidth/2,-1,-1> <1,1,1> }
box { <-1,-1,-1> <1,0,1> }
box { <-1, Bheight, -1> <1,1,1> }
box { <-1, -1, Bdepth> <1,1,1> }
}
*/
#declare Bshape = union {
   box { <-Bwidth/2, 0, 0> <Bwidth/2, Bheight, Bdepth> }
   cylinder { <-Bwidth/4,0,0>, <-Bwidth/4, Bheight, 0>, Bwidth/4 scale <1,1,0.5> }
   cylinder { < Bwidth/4,0,0>, < Bwidth/4, Bheight, 0>, Bwidth/4 scale <1,1,0.5> }
   box { <-Bwidth/4,0,-Bwidth/4> <Bwidth/4,Bheight,0> scale <1,1,0.5> }
   }

#declare cscale = 0.10; // cover is this percentage as thick as the book
#declare Bcover0 = difference {
   object { Bshape }
   object { Bshape scale <1-cscale, 1.1, 1> translate <0, -0.001, Bwidth*cscale, > }
}


#include "Books\DO_Booktitle1.f" // get title, author, and fonts
// these values are used to scale the fonts
#declare yrand = rand(Rb)/5 + 0.4;
#declare xscale = Bheight / ((strlen(Title)+strlen(Author)) * 0.6) * 0.75;
#declare yscale = Bwidth * yrand  // * (rand(Rb)*0.3 + 0.7);

#include "Books\DO_Booktexture1.f"  // get the texture for the book and the title and author
#if (rand(Rb)<0.5)
#declare Tstring = union {
   text { ttf Font1, Title, 1, 0 texture { Ttexture1 } }
   text { ttf Font2, Author, 1, 0 texture { Ttexture2 } translate x*strlen(Title)*0.65 }
   }
#else
#declare Tstring = union {
   text { ttf Font1, Author, 1, 0 texture { Ttexture1 } }
   text { ttf Font2, Title, 1, 0 texture { Ttexture2 } translate x*strlen(Author)*0.65 }
   }
#end

#declare Bcover1 = union {
   object { Bcover0 texture { Btexture } }
   object { Tstring
      translate <0,0.2,0> // compensation
      scale <xscale, yscale, 0.03>
      rotate z*-90
      translate <-0.5*yrand*Bwidth, 0, 0>
      translate <0, Bheight-0.02, -Bwidth/8-0.0001 >
      }
   }

// ========== the decorations ========== //

#declare thinstrip = box {
   <-Bwidth/4,0,-Bwidth/8-0.0001> <Bwidth/4,0.001,-Bwidth/8>
   texture { pigment { color Gold } finish { specular .4 } } }

#declare thickstrip = box {
   <-Bwidth/4,0,-Bwidth/8-0.0001> <Bwidth/4,0.005,-Bwidth/8>
   texture { pigment { color Gold } finish { specular .4 } } }

#declare tallstrip = box {
   <-Bwidth/4,0.01,-Bwidth/8-0.0001> <-Bwidth/4+0.001,Bheight-0.01,-Bwidth/8>
   texture { pigment { color Gold } finish { specular .4 } } }

#declare D = rand(Rb) * 10;
#declare D = ceil(D);
#switch(D)
   #case(1)
      #declare Bdeco = union {
         object { thinstrip translate y*0.005 }
         object { thinstrip translate y*0.008 }
         object { thinstrip translate <0,Bheight-0.005,0> }
         object { thinstrip translate <0,Bheight-0.008,0> } }
      #break
   #case(2)
      #declare Bdeco = union {
         object { thinstrip translate y*0.005 }
         object { thinstrip translate <0,Bheight-0.005,0> } }
      #break
   #case(3)
      #declare Bdeco = union {
         object { thickstrip translate y*0.005 }
         object { thickstrip translate <0,Bheight-0.010,0> } }
      #break
   #case(4)
      #declare Bdeco = object { tallstrip }
      #break
   #case(5)
      #declare Bdeco = union {
         object { tallstrip }
         object { tallstrip translate <Bwidth/2,0,0> } }
      #break
   #else
      #declare Bdeco = object { thinstrip scale 0.0001 } #break
#end


#declare Book = union {
   object { Bcover1 }
   object { Bdeco }
   // the paper
   box { <-Bwidth/2, Bwidth*cscale*3, 0>
         <Bwidth/2, Bheight-Bwidth*cscale*3, Bdepth-Bwidth*cscale*3>
      scale <1-cscale,1,1>
      texture { pigment { color rgb <.7, .7, .7> } } }
   translate <Bwidth/2,0,0> // move lower left corner to origin
}

#version DO_BOOK1_F;
