// Persistence of Vision Ray Tracer Scene Description File
// File: Deadline.pov
// Vers: 3.1
// Desc: Horror of a deadline
// Date: 3 September 1999
// Auth: Gail Shaw 

//1 unit=10cm


#include "kolors.inc"
#include "metals.inc"     
#include "woods.inc"
#include "shapes2.inc"
//#include "myobjects.inc"
#include "Computer\keyboard.inc"
#include "deadlinetextures.inc"
#include "compdesk.inc"        
#include "cd.inc"
#include "deskobj.inc"
#include "plate.inc"                   
#include "paper.inc"     
#include "sword.inc"
                             
global_settings {
 #max_trace_level 20
}

camera {             
 location <0,13,-18>
 angle 40
 look_at <0,8,0>
}

light_source {
 <50,100,-150>
 White
}

light_source {
 <-5,10,-15>       
 LightYellow*0.5 
 area_light <0.5,0,0>,<0,0.5,0>,2,2 
 adaptive 1
 jitter
}

object {
 Keyboard()
 scale 0.1
 rotate y*-9
 translate <-3.3,7.4,-2.4>
}             
             
/*sphere {
 <-6.65,7.4,1>,0.02
 pigment {Red}
}   */          
             
sphere_sweep {
 b_spline_sphere_sweep
 6,
 <-6.65,7.35,1.35>,0.03,
 <-6.65,7.35,1.45>,0.03,
 <-6.8,7.35,2>,0.03,
 <-6.9,7.33,2.7>,0.03,
 <-7.1,7.3,3.2>,0.03,
 <-7.3,7.2,4.3>,0.03
 texture {CableTexture}
}                          

sphere_sweep {
 b_spline_sphere_sweep
 9,
 <-3.7,3.5,4>,0.07,
 <-3.9,3,4>,0.07,
 <-4.2,2,4>,0.07,
 <-4.7,1.5,3.9>,0.07,
 <-5.3,1,3.9>,0.07,
 <-5.8,0.7,3.9>,0.07,
 <-6.5,0.5,3.9>,0.07,
 <-7.3,0.3,3.8>,0.07
 <-7.8,0.25,3.8>,0.07
 texture {CableTexture}
}

difference {             
 object {Desk}
 height_field {
  tga "dents.tga"
  smooth
  scale <14,-0.05,0.3>
  rotate x*-45
  translate <-7,7.25,-4>
  //pigment {Red}
  texture {TeakTex scale 3 rotate y*90 translate z*rand(0)*10}
 }
}
 

object {
 LeaverFile
 rotate y*15
 translate <3,7.65,-3.4>
} 

object {
 Screen
 scale <0.12,0.1,0.1>
 translate <-5.5,6.95,-1.5>
}
 
object {
 BasicCD
 translate <-0.15,7.3,0>
} 

#declare CupPatten=
 pigment {
  image_map {
   gif "heart.gif"
  }
  translate x*0.5
  scale <25,20,20>
 }

#declare CoffeeTex=
 texture{pigment {Chocolate4} }
 
object {
 cup(1,CupPatten,White,CoffeeTex) 
 scale 0.04
 rotate y*5
 translate <-0.2,7.4,0.1>
}

// steam
          
sphere {
 <0,0,0>,1.5
 pigment {Clear}
 hollow
 interior {
  media {
   intervals 4
   samples 4,10
   confidence 0.99            
   variance 1/255             
   absorption 0.6    
   emission 0.7                 
   density {
    spherical   
    color_map {
     [0.0 rgbf <0,0,0,0>]
     [0.3 rgbf <0,0,0,0>]
     [0.5 rgbf <0.6,0.6,0.6,0.6>*2]
     [1.0 rgbf <0.6,0.6,0.6,0.2>*2]
    }     
    turbulence 1.2     
   }
  }
 }                  
 scale <0.3,0.6,0.3>   
 translate <-0.3,8.3,0.1>
}

object {
 cup(0.1,Gray70,Gray70,CoffeeTex)
 scale 0.04
 rotate y*25
 translate <-1.1,7.4,2.4>
}

object {
 spoon
 rotate z*80
 translate <-1,7.8,2.4>
}

// coffee rings

difference {
 cylinder {
  <0.4,7.3,0>,<0.4,7.301,0>,0.28
 }
 cylinder {
  <0.4,7.2,0>,<0.4,7.5,0>,0.22
 }
 pigment { rgbf <0.72,0.45,0.20,0.9>*1.2 }
 finish { phong 0.2 phong_size 10 }
}

difference {
 cylinder {
  <-0.2,7.3,0.1>,<-0.2,7.301,0.1>,0.28
 }
 cylinder {
  <-0.2,7.2,0.1>,<-0.2,7.5,0.1>,0.22
 }
 pigment { rgbf <0.72,0.45,0.20,0.9>*1.2 }
 finish { phong 0.2 phong_size 10 }
} 
 
object {
 Touchpad
 texture {T_Chrome_4A}
 rotate y*7
 translate <0.4,7.3,-2>
} 

sphere_sweep {
 b_spline_sphere_sweep
 11                    
 <-0.25,7.3,-2>,0.02,
 <-0.25,7.3,-1.5>,0.02,
 <-0.4,7.3,-1>,0.02,
 <-0.6,7.3,-0.5>,0.02,
 <-0.9,7.3,0>,0.02,
 <-0.8,7.3,0.5>,0.02,
 <-0.8,7.3,1>,0.02,
 <-0.9,7.3,1.5>,0.02,
 <-1.1,7.3,2>,0.02,
 <-1.4,7.3,2.5>,0.02,
 <-1.6,7.3,3>,0.02
 pigment {Gray80}
}

#declare CDSide1 = 
 pigment {
  image_map {
   gif "CDSide1.gif"
  }
 }          

#declare CDSide2 = 
 pigment {
  image_map {
   gif "CDSide2.gif"
  }
 }

#declare CDSide3 = 
 pigment {
  image_map {
   gif "CDSide3.gif"
  }
 }          
 
#declare CDSide4 = 
 pigment {
  image_map {
   gif "CDSide4.gif"
  }
 }
        
object {
 CDBox(Clear,CDSide1)    
 rotate x*-90
 rotate y*-90
 translate <-1.5,7.3,0>
} 

object {
 CDBox(Clear,CDSide2)    
 rotate x*-90
 rotate y*-90
 translate <-1.35,7.3,0>
}

object {
 CDBox(DarkGreen,CDSide3)    
 rotate x*-90
 rotate y*-90
 translate <-1.2,7.3,0>
}

union {
 object {
  CDBox(Clear,CDSide4)    
  rotate y*-90
 }
 object {
  BasicCD
  translate <0.75,0.05,0.61>
 }
 translate <4.3,7.3,0.3>
}

object {
 PenHolder
 translate <2.3,7.3,0.2>
}

object {
 Pencil
 scale 0.4              
 rotate z*87
 translate <2.1,7.9,0.9>
 pigment {Burlywood}
 finish {specular 1 roughness 0.003}
}

object {
 Pencil
 scale 0.4              
 rotate z*90
 rotate x*-3
 translate <1.9,7.85,0.78>
 pigment {Burlywood}
 finish {specular 1 roughness 0.003}
}

object {
 Pencil
 scale 0.4              
 rotate z*90
 rotate x*18
 translate <1.7,7.85,1.18>
 pigment {Black}
 finish {specular 1 roughness 0.003}
}

object {
 Pencil
 scale 0.4              
 rotate y*-20
 translate <0.33,7.3,-0.6>
 pigment {Teal}
 finish {specular 1 roughness 0.003}
}        

object {
 Pencil
 scale 0.4
 rotate y*94
 translate <2.5,7.3,-2>
 pigment {Teal}
 finish {specular 1 roughness 0.003}
}

union {
 object {
  PaperHolder
 }
 object {
  PaperBlock
 }
 translate <3,7.3,2.6>
}

object {
 Clock
 scale 0.8
 translate <0.73,7.3,3>
}

object {
 PizzaBox
 rotate z*-7
 translate <3.2,7.8,1.5>
}

object {
 plate  
 scale 6
 texture {
  pigment {
   granite
   color_map {
    [0.0 rgb <1.0000, 0.9688, 0.8594>]
    [0.6 rgb <1.0000, 0.9688, 0.8594>]
    [1.0 rgb <0.5430, 0.2695, 0.0742>]
   }
   scale 0.1
  }
 }
 texture {
  pigment {
   cylindrical
   color_map {
    [0.0 Clear]
    [0.73 Clear]
    [0.73 Tan4]
    [0.74 Tan4]
    [0.74 Clear]
    [0.75 Clear]
    [0.75 Tan4]
    [0.76 Tan4]
    [0.76 Clear]
    [1.0 Clear]
   }
   scale 4
  }
  finish {
   specular 0.9 roughness 0.0005
  }
 }
 rotate z*180
 translate <5,9.5,2>
}

object {
 Disk
 translate <2.1,7.3,-0.5>
}

object {
 Disk
 rotate y*20
 translate <2.18,7.34,-0.48>
}

object {
 Disk
 rotate y*-40
 translate <2.54,7.38,-0.55>
}

box {
 <0,0,0>,<1,1,0.01>
 pigment {
  image_map {
   png "Calender.png"
  }
 }
 scale <3,4.6,1>
 translate <1.5,8.5,4.4>
 rotate y*6
}
     
#declare Rb = seed(544); // nice - dark blue
#declare titlenum = 97;  //Dynamic HTML

#include "Books\DO_Book1.f"

object { 
 Book   
 scale 10
 translate <0.3,3.8,-3>
}

#declare Rb = seed(4357); // nice, small, thick very dark blue.
#declare titlenum = 96; // Web programmer's desktop reference

#include "Books\DO_Book1.f"

object { 
 Book   
 scale 10
 translate <0.7,3.8,-3>
}
    
#declare Rb = seed(1240); // nice. Black and yellow.
#declare titlenum = 9;   //Linux Handbook

#include "Books\DO_Book1.f"

object { 
 Book   
 scale 10
 translate <1.18,3.8,-3>
}    

#declare Rb = seed(5866); // nice!! gold on red.
#declare titlenum = 14;  // 3d modelling and rendering

#include "Books\DO_Book1.f"

object { 
 Book   
 scale 10
 rotate z*15  
 translate <1.98,3.85,-3>
}    
    
#declare Rb = seed(1122); //Gold on Black. Do not change!!!! 1122
#declare titlenum = 92;  // aikido

#include "Books\DO_Book1.f"

object { 
 Book   
 scale 10
 rotate z*90
 rotate y*30
 translate <4.9,7.3,-4.1>
}    

object {
 Paper3        
 rotate x*-90     
 //uv_mapping 
 
 pigment {
  image_map {
   gif "seppuku.gif"
  }       
  translate <-0.5,-0.5,0>
  //rotate z*-90
  scale <6,7,1>   
 }             
 scale 0.25  
 rotate x*135
 rotate y*-100
 translate <3.8,7.31,-3.32>
}

object {
 LargePaper        
 //uv_mapping 
 
 pigment {
  image_map {
   gif "letter.gif"
  }       
  translate <-0.5,-0.45,0>
  //rotate z*-90
  scale <6,12,1>   
 }             
 scale 0.25  
 rotate x*93     
 translate <0,7.32,-3.2>
}

object {
 Paper1       
 scale <1,-1,1>
 pigment {rgb<1,0,0>}    
 pigment {
  image_map {
   gif "Note1.gif" 
  }              
  translate <-0.67,0.67,0>
  scale <3,3,1>
 }
 scale <0.23,0.21,0.13>            
 rotate y*-4
 translate <-2,7.76,-1.33>
}

object {
 Paper2   
 scale 0.5    
 pigment {rgb<1,1,1>}    
 pigment {
  image_map {
   gif "Note2.gif"
  }              
  translate <-0.53,0.4,0>
  scale <3,3,1>
 }    
 scale <0.23,0.21,0.13>            
 rotate y*-4
 translate <-4.2,7.73,-1.33>
}

object {Wakizashi rotate x*65 rotate z*5 scale 0.4 translate <1.5,7.5,-3.7>}
                                                                            
box {
 <0,0,-0.0001>,<1,1,0.001>   
 pigment {
  image_map {                     
   gif "blood.gif"
   transmit 0,1 
   transmit 1,1
   transmit 4,1
  }
 }
 rotate x*90      
 scale 1.5
 translate <-2.8,7.3,-4.1>
}       

box {
 <0,0,-0.0001>,<1,1,0.0001>   
 pigment {
  image_map {                     
   gif "blood.gif"
   transmit 0,1 
   transmit 1,1
   transmit 4,1
  }
  scale <-1,1,1>
 }
 rotate x*90      
 scale 1.5
 translate <1,7.3,-3>
}

      
box {
 <-10,0,-10>,<10,-0.1,10>
 pigment {SkyBlue}
}   

box {
 <-20,-1,4.5>,<20,30,5.5>
 pigment {rgb <1,1,0.95>}
 normal {
  bumps 0.1
  scale 0.1
 }
 rotate y*6
}

box {
 <-20,-0.1,4>,<20,0.1,5>
 texture {T_Wood2 rotate y*90}    
 rotate y*6
}

cylinder {
 <-20,0,4>,<20,0,4>,0.1
 texture {T_Wood2 rotate y*90} 
 rotate y*6
}

box {
 <-9.8,-1,-14>,<-10,30,5>
 pigment {rgb <1,1,0.95>}
 normal {
  bumps 0.1
  scale 0.1
 }
 rotate y*6
}

box {
 <-20,30,-10>,<20,31,10>
 pigment {White}
}