// Persistence of Vision Ray Tracer Scene Description File
// File: Desk.inc
// Vers: 3.1
// Desc: A desk and computer parts for deadline.pov 
// Date: 
// Auth: 

#declare SlatPos=seed(6584);

// *******************************desk*******************************

#declare Desk=
 union {
  #declare Slat=0;
  #while (Slat<8)
   box {
    <-7.5,7,-4+Slat>,<6.5,7.3,-3+Slat>
    texture {TeakTex scale 3 rotate y*90 translate z*rand(SlatPos)*10}
   }
   #declare Slat=Slat+1;
  #end 
  box {
   <-7,7,-3.5>,<-6.7,0,3.5>
   texture {TeakTex scale 3 rotate x*90}
  }
  box {
   <6,7,-3>,<2.5,0,3.5>       
   texture {TeakTex scale 3 translate x*-4}
  }
  box {
   <0,7,-3>,<0.3,0,3.5>         
   texture {TeakTex scale 3 rotate x*90}
  }
  box {
   <0,0,-3>,<2.5,0.3,3.5>        
   texture {TeakTex scale 3}
  }
  box {
   <0,3.5,-3>,<2.5,3.8,3.5>
   texture {TeakTex scale 3  translate x*4 }
  }
  box {
   <0,0,3.3>,<2.5,7,3.5> 
   texture {TeakTex scale 3}
  }                          
  box {
   <-7,1,-0.5>,<0,1.3,0.5>     
   texture {TeakTex scale 3 rotate y*90}
  }                              
  box {
   <-7,3,3.3>,<0,7,3.5>       
   texture {TeakTex scale 3 rotate y*90}
  }
  difference {
   box {
    <2.8,5,-3.3>,<5.8,6.5,0>
   }
   sphere {
    <0,0,0>,0.2
    scale <6,0.6,1>
    translate <4.3,5.9,-3.2>
   }
   sphere {
    <0,0,0>,0.2
    scale <6,0.6,1>
    translate <4.3,5.6,-3.2>
   }                                      
   texture {TeakTex scale 3 rotate y*90}
  }
  difference {
   box {
    <2.8,2.9,-3.3>,<5.8,4.6,0>
   }
   sphere {
    <0,0,0>,0.2
    scale <6,0.6,1>
    translate <4.3,3.9,-3.2>
   }
   sphere {
    <0,0,0>,0.2
    scale <6,0.6,1>
    translate <4.3,3.6,-3.2>
   }                                      
   texture {TeakTex scale 3 rotate y*90}
  }
  difference {
   box {
    <2.8,0.5,-3.3>,<5.8,2.5,0>
   }
   sphere {
    <0,0,0>,0.2
    scale <6,0.6,1>
    translate <4.3,1.6,-3.2>
   }
   sphere {
    <0,0,0>,0.2
    scale <6,0.6,1>
    translate <4.3,1.3,-3.2>
   }                                      
   texture {TeakTex scale 3 rotate y*90}
  }   
  pigment {DarkBrown}
 }
 
//****************************Computer Monitor************************** 

#declare ScreenTop=
 union {
  difference {
   union {
    box {
     <0,11,0>,<35,40,9>
     pigment {LightSteelBlue}
     finish {specular 0.2 roughness 0.05}
     normal {
      bumps 0.15
      scale 0.1
     }
    }
    box {
     <1.5,13,-0.2>,<33.5,39,0.5>
     pigment {Gray70}
     finish {specular 0.2 roughness 0.05}
     normal {
      bumps 0.15
      scale 0.1
     }
    }
   }
   object {Pyramid2
           rotate x*90
           scale <30,24,10>
           translate <17.6,26,0>
           pigment {Gray70}
           finish {specular 0.2 roughness 0.05}
           normal {
            bumps 0.15
            scale 0.1
           }		 
          }
  }
  box {
   <2,13.5,0.2>,<33,38.5,1.4>
   pigment {Clear}
   finish {Shiny}
  }
  box {
   <2,13.5,0.211>,<33,38.5,1.3>
   pigment {Black}
  }
  box {
   <0,0,0>,<1,1,1.1>
   pigment {Black}
   pigment {
    image_map {
     png "Screenshot.png"
    }
   }
   scale <26,21,1>
   translate <5,15.5,0.21>
  }
  box {
   <1.5,11.3,-0.001>,<6.5,12.5,0.01>
   pigment {Gray20}
  }
  text {ttf "coprgtb.ttf" "SBM" 0.1,0
        texture {T_Gold_3A}
        scale 1.2
        translate <2.5,11.5,-0.002>
       }
  box {
   <2,9,0.4>,<33,11,5>
   pigment {LightSteelBlue}
   finish {specular 0.2 roughness 0.05}
   normal {
    bumps 0.15
    scale 0.1
   }
  }
  box {
   <27.5,9,0.399>,<30.5,10.5,0.41>
   pigment {Black}
  }
  box {
   <27.6,9.01,0.398>,<30.4,10.4,0.41>
   pigment {LightSteelBlue*0.9}
   finish {specular 0.2 roughness 0.05}
   normal {
    bumps 0.15
    scale 0.1
   }
  }
  box {
   <25.5,9.3,0.399>,<26.5,9.6,0.41>
   pigment {LimeGreen}
   finish {ambient 1 diffuse 0}
  }
  object {Pyramid2
          rotate x*90
          scale <12,10,12>
          translate <17.6,26,20>
          pigment {LightSteelBlue}
          finish {specular 0.2 roughness 0.05}
          normal {
           bumps 0.15
           scale 0.1
          }
         }
  difference {
   box {
    <4.5,15.2,11>,<30,36.9,27>
   pigment {LightSteelBlue}
   finish {specular 0.2 roughness 0.05}
   normal {
    bumps 0.15
    scale 0.1
   }
   }
   box {
    <1,-4,5>,<32.5,3,40>
    pigment {LightSteelBlue}
    rotate x*20
    translate y*45
   }
  }
  box {
   <4.5,0,3>,<30,5,28>
   rotate x*-15
   pigment {LightSteelBlue}
   finish {specular 0.2 roughness 0.05}
   normal {
    bumps 0.15
    scale 0.1
   }
   translate y*8.2
  }
  sphere {
   <17.25,17,15>,8
   pigment {LightSteelBlue}
   finish {specular 0.2 roughness 0.05}
   normal {
    bumps 0.15
    scale 0.1
   }
  }
 }

#declare Screen=
 union {
  object {ScreenTop
          rotate x*10
         }
  cylinder {
   <17.25,6,17.5>,<17.25,8,17.5>,5.5
   pigment {LightSteelBlue*1.5}
   finish {specular 0.2 roughness 0.05}
   normal {
    bumps 0.15
    scale 0.1
   }
  }
  box {
   <4,5.5,4>,<30,6,25>
   pigment {LightSteelBlue*1.3}
   finish {specular 0.2 roughness 0.05}
   normal {
    bumps 0.15
    scale 0.1
   }
  }
  box {
   <3,4,3>,<31,5.5,26>
   pigment {LightSteelBlue*1.3}
   finish {specular 0.2 roughness 0.05}
   normal {
    bumps 0.15
    scale 0.1
   }
  }
 } 

//********************TouchPad****************************
 
#declare Touchpad=
 difference {
  union {
   difference {
    superellipsoid {
     <0.4,0.1>
     scale <1,0.035,0.6>
    }
    box {
     <-25,0.005,-15>,<25,-5,15>
    }
    translate y*0.004
   }       
   difference {
    superellipsoid {
     <0.4,0.1>
     scale <1,0.035,0.6>
    }
    box {
     <-25,-0.005,-15>,<25,5,15>
    } 
    translate y*-0.004
    } 
   box {
    <0.9,-0.015,0.45>,<-0.9,0.015,-0.45>
    pigment {Gray20}
   } 	   
   text {
    ttf "blkchcry.ttf" "Cat" 0.1,0
    scale 0.2
    pigment {DarkBlue}                 
    rotate x*90    
    rotate z*5
    translate <-0.87,0.06,0.4>
   }
  }        
  superellipsoid {
   <0.4,0.05>
   pigment {Gray10 }                  
   scale <0.65,0.02,0.5>
   translate <0.15,0.04,0>
  }
  difference {
   superellipsoid {
    <0.4,0.2>
    pigment {Gray10 }                  
    scale <0.15,0.02,0.25>
    translate <-0.75,0.04,-0.25>
   }
   superellipsoid {
    <0.4,0.2>
    pigment {Gray90 }                  
    scale <0.14,0.02,0.24>
    translate <-0.75,0.04,-0.25>
   }
  }
  difference {
   superellipsoid {
    <0.4,0.2>
    pigment {Gray10 }                  
    scale <0.15,0.02,0.15>
    translate <-0.75,0.04,0.2>
   }
   superellipsoid {
    <0.4,0.2>
    pigment {Gray90 }                  
    scale <0.14,0.02,0.14>
    translate <-0.75,0.04,0.2>
   }
  } 
 } 
 
#declare Disk=
 union {
  difference {
   box {
    <0,0,0>,<0.9,0.04,0.94>
   }
   union {
    box {
     <0.02,-0.01,0.83>,<0.07,0.05,0.87>
    }
    box {
     <0.82,0.01,0.83>,<0.87,0.05,0.87>
    }
    box {
     <0.82,-0.01,0.87>,<0.87,0.03,0.91>
    }
    box {
     <-0.08,-0.01,-0.08>,<0.08,0.05,0.08>
     rotate y*45
    }
    cylinder {
     <0.44,-0.01,0.49>,<0.44,0.03,0.49>,0.11
    }
   }
  }
  box {
   <0.1,0.04,0.3>,<0.8,0.04001,0.9>
   pigment {White}
  }
  #declare LineNo=0;
  #while (LineNo<7)
   box {
    <0.15,0.04,0.4+LineNo*0.07>,<0.75,0.04002,0.41+LineNo*0.07>
    pigment {Red}
   }
   #declare LineNo=LineNo+1;
  #end
  pigment {Gray20}
  finish {
   specular 0.2
   roughness 0.05
  }
  normal {
   bumps 0.15
   scale 0.1
  }
 } 