// Persistence of Vision Ray Tracer Scene Description File
// File: forever.pov
// Vers: 3.1
// Desc: Forever / IRTC Contect Entry for October 1999
// Date: 10/19/1999
// Auth: Ken Kopin
//

#version 3.1;

#include "colors.inc"
#include "dilantin.inc"

global_settings { assumed_gamma 1.0 }


camera {
  location  <0, 6, -12.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0, 10.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {0*x color White translate <-30, 50, -30>} 

light_source {0*x color White translate <0, 50, -30>} 

light_source {0*x color White translate <30, 50, -30>} 

// ----------------------------------------
plane { y, -1
  texture {
    pigment {checker color White color Black scale 10}
  }
}
//------------------------------

//Rows  

#declare XOFFSET=0 ;
#declare ZOFFSET=4 ;

#declare RRR=0 ;
#declare XXX=0 ;
#declare ZZZ=0 ; 

#declare ROW = union {
   #while (RRR < 30)
      object {Dilantin_100mg
         translate <XXX,0,ZZZ>
      }                            
      #declare XXX=XXX+XOFFSET ;
      #declare ZZZ=ZZZ+ZOFFSET ;   
      #declare RRR=RRR+1 ;
   #end //#while (RRR < 6)
} // end of union ROW    

// Columns

#declare XOFFSET=7 ;

#declare RRR=0 ;
#declare XXX=0 ;

#while (RRR < 11)
   object {ROW
      translate <-35+XXX,0,0>
   }                            
   #declare XXX=XXX+XOFFSET ;
   #declare RRR=RRR+1 ;
#end //#while (RRR < 21)

text {ttf "crystal.ttf","Take two pills",2,0
        scale <5,5,5>
        translate <-17.5,4,40>
        texture { pigment {color White} }   
     }

text {ttf "crystal.ttf","three times per day",2,0
        scale <2,2,2>
        translate <-10,2.5,12>
        texture { pigment {color White} }   
     }

text {ttf "crystal.ttf","forever.",2,0
        scale <1,1,.125>
        translate <-1.75,0,-3>
        texture { pigment {color rgb <.5, 0, 0>} }   
     }

fog {fog_type 1 distance 35 color Gray30}   //50
fog {fog_type 2 distance 2.0 fog_offset 1.0 fog_alt .5 color Black}