// Created for the IRTC topic "Horror"
// By Mark Wagner 10/99
// I did this just because

// Creation time: 6 hours
// Render time:   43 minutes

//Command line: width=404 height=268 +AM2 +A0 -J +R4 +Q9 +UV -UD +MB5 +k1


//Scale: 1 POV unit = 1 pixel

//Macro to create a dotted line
#macro DottedLine(Start, End)
	#local TotLength = vlength(Start-End);
	#local DV = vnormalize(End-Start);
	#local BV = <1,1,1>;
	#local length = 1;
	#while(length<TotLength)
		box{Start+(DV*length), Start+(DV*length)+BV}
		#local length = length + 2;
	#end
#end

//Title bar
union{
	box{
		<-200,132,0>,<200,112,1>
		pigment{
			gradient x
			color_map{
				[0 rgb <0,2/256,113/256>]
				[1 rgb <39/256,124/256,188/256>]
			}
			scale <400,1,1>
			translate x*-200
		}
		finish{ambient 1 diffuse 0}
	}
	//The following font is Arial Bold
	text{ttf "c:\windows\fonts\arialbd.ttf" "Pvengine" 1, 0 scale <12,12,1> translate y*119+x*-178+z*1 pigment{ rgb 1 } finish{ambient 1 diffuse 0}} 
}

background{rgb 1}
#declare FrameText = texture{
	pigment{rgb 1}
	finish{ambient 0 diffuse 1.3}
}
#declare BoxTexture = texture{
	pigment{rgb .75}
	finish{ambient .5 diffuse .8}
}

//Message box frame
union{
	cylinder{<-200,132,-1>,<200,132,-1>,2 }
	cylinder{<-200,-132,-1>,<200,-132,-1>,2 }
	cylinder{<-200,132,-1>,<-200,-132,-1>,2 }
	cylinder{<200,132,-1>,<200,-132,-1>,2 }
	sphere{<200,132,-1>,2 }
	sphere{<200,-132,-1>,2 }
	sphere{<-200,132,-1>,2 }
	sphere{<-200,-132,-1>,2 }	
	texture{FrameText}
}

//Message Box
difference{
	box{<-200,112,0>,<200,-132,1.001>}
	box{<-189,10,-.001>,<189,-120,2.001>}
	texture{BoxTexture}
}

//Message box message
//The following font is Arial
#declare MsgFont = "c:\windows\fonts\arial.ttf"
union{
	text{ttf MsgFont "This program has performed an illegal operation", 1, 0 translate y*2}
	text{ttf MsgFont "and will be shut down.", 1, 0 translate y*1}
	text{ttf MsgFont "If the problem persists, contact the program", 1, 0 translate y*-1}
	text{ttf MsgFont "vendor.", 1, 0 translate y*-2}
	pigment{rgb 0}
	finish{ambient 0 diffuse 0}
	scale <12,11,1>
	translate <-148,60,.002>
}

//Details frame
union{
	cylinder{<-189,10,-1>,<189,10,-1>,2}
	cylinder{<-189,-120,-1>,<189,-120,-1>,2}
	cylinder{<-189,10,-1>,<-189,-123,-1>,2}
	cylinder{<189,10,-1>,<189,-123,-1>,2}
	texture{FrameText}
}

//Details scrollbar
#declare arrow = union{
	box{<-6,-6,0>,<6,6,2> texture{BoxTexture}}
	cylinder{<-6,-6,0>,<-6,6,0>,2}
	cylinder{<6,-6,0>,<6,6,0>,2}
	cylinder{<-6,-6,0>,<6,-6,0>,2}
	cylinder{<-6,6,0>,<6,6,0>,2}
	sphere{<-6,-6,0>,2}
	sphere{<-6,6,0>,2}
	sphere{<6,-6,0>,2}
	sphere{<6,6,0>,2}
	polygon{4, <-4,-2>,<4,-2>,<0,2>,<-4,-2> translate z*2 pigment{rgb 0}}
	texture{FrameText}
}

union{
	object{arrow translate <179,0,-1>}	
	object{arrow scale <1,-1,1> translate <179,-109,-1>}
	box{<187,8,-1>,<171,-121,-.99> pigment{rgb .875} finish{ambient 1 diffuse 0}}
	box{<185,-10,-1>,<173,-70,1> texture{BoxTexture}}
	cylinder{<185,-10,-1>,<185,-70,-1>,2}
	cylinder{<173,-10,-1>,<173,-70,-1>,2}
	cylinder{<185,-10,-1>,<173,-10,-1>,2}
	cylinder{<173,-70,-1>,<185,-70,-1>,2}
	sphere{<185,-10,-1>,2}
	sphere{<173,-10,-1>,2}
	sphere{<173,-70,-1>,2}
	sphere{<185,-70,-1>,2}
	texture{FrameText}
}
		

//Details box
box{<-188,9,-1>,<188,-122,-2> texture{BoxTexture}}

//Details box message
//The following font is Courier New Bold
#declare DetailFont = "c:\windows\fonts\courbd.ttf"
union{
	text{ttf DetailFont "PVENGINE caused an invalid page fault in", 1, 0 translate y*4.4}
	text{ttf DetailFont "module PVENGINE.EXE at 015f:004209a3.", 1, 0 translate y*3.3}
	text{ttf DetailFont "Registers:", 1, 0 translate y*2.2}
	text{ttf DetailFont "EAX=007af0c0 CS=015f EIP=004209a3 EFLGS=00010206", 1, 0 translate y*1.1}
	text{ttf DetailFont "EBX=00000315 SS=0167 ESP=01dafbf4 EBP=00000000", 1, 0 translate y*0}
	text{ttf DetailFont "ECX=74222065 DS=0167 ESI=00000000 FS=31bf", 1, 0 translate y*-1.1}
	text{ttf DetailFont "EDX=75747865 ES=0167 EDI=00000000 GS=0000", 1, 0 translate y*-2.2}
	text{ttf DetailFont "Bytes at CS:EIP:", 1, 0 translate y*-3.3}
	text{ttf DetailFont "89 51 0c eb dc 8b 46 0c a3 28 24 4d 00 5e 5a 59", 1, 0 translate y*-4.4}
	scale <12,12,1>
	translate <-184,-60,-1.998>
	pigment{rgb 0}
	finish{ambient 0 diffuse 0}
}
//Close button
union{
	box{<-34,-8,1>,<34,8,4>texture{BoxTexture}}
	box{<-38,-12,1>,<38,12,1.1> pigment{rgb 0}}
	box{<-15,-5,1>,<-7,-6,4.001> pigment{rgb 0}}
	cylinder{<-34,-8,1>,<34,-8,1>,3}
	cylinder{<-34,8,1>,<34,8,1>,3}
	cylinder{<-34,-8,1>,<-34,8,1>,3}
	cylinder{<34,-8,1>,<34,8,1>,3}
	sphere{<-34,-8,1>,3}
	sphere{<-34,8,1>,3}
	sphere{<34,-8,1>,3}
	sphere{<34,8,1>,3}
	//The following font is Arial
	text{ttf "c:\windows\fonts\Arial.ttf" "Close", 1, 0 scale <12,12,1> translate <-15,-4,3.001> pigment{rgb 0}}
	union{
		DottedLine(<-32,7,3>,<-32,-8,3.>)
		DottedLine(<32,7,3>,<32,-8,3>)
		DottedLine(<32,-8,3>,<-32,-8,3>)
		DottedLine(<32,7,3>,<-32,7,3>)
		pigment{rgb 0}
		translate z*.001
	}
	texture{FrameText}
	translate <149,82,0>
}

//Details button
union{
	difference{
		box{<-34,-8,1>,<34,8,4>texture{BoxTexture}}
		//The following font is Arial Bold
		text{ttf "c:\windows\fonts\Arialbd.ttf" "Details>>", .4, 0 scale <12,12,1> translate <-23,-4,3.61>}
		box{<-23,-5,3.91>,<-15,-6,4.001>}
		texture{FrameText}
	}
	box{<-38,-12,1>,<38,12,1.1> pigment{rgb 0}}
	box{<-15,-5,1>,<-7,-6,4.001> pigment{rgb 0}}
	cylinder{<-34,-8,1>,<34,-8,1>,3}
	cylinder{<-34,8,1>,<34,8,1>,3}
	cylinder{<-34,-8,1>,<-34,8,1>,3}
	cylinder{<34,-8,1>,<34,8,1>,3}
	sphere{<-34,-8,1>,3}
	sphere{<-34,8,1>,3}
	sphere{<34,-8,1>,3}
	sphere{<34,8,1>,3}
	texture{FrameText}
	translate <149,33,0>
}

//Close box
union{
	box{<196,127,1>,<182,117,3> texture{BoxTexture}}
	cylinder{<196,127,1>,<182,127,1>,2}
	cylinder{<196,117,1>,<182,117,1>,2}
	cylinder{<196,127,1>,<196,117,1>,2}
	cylinder{<182,127,1>,<182,117,1>,2}
	sphere{<196,127,1>,2}
	sphere{<196,117,1>,2}
	sphere{<182,127,1>,2}
	sphere{<182,117,1>,2}
	union{
		box{<-1,-4,3>,<1,4,3.01> matrix <1,0,0 , 1,1,0 , 0,0,1 , 0,0,0>}
		box{<-1,-4,3>,<1,4,3.01> matrix <1,0,0 , -1,1,0 , 0,0,1 , 0,0,0>}
		translate <189,122,0>
		texture{pigment{rgb 0} finish{ambient 0 diffuse 0}}
	}
	texture{FrameText}
}

//Windows logo
#declare Arc = intersection{
	difference{
		cylinder{ 0, z*1, 6.3 }
		cylinder{ z*-.001, z*1.001, 6.3 translate y*-2}
	}
	box{<-4,7,0>,<4,0,1>}
	translate y*-2.3
}

union{
	union{
		object{Arc translate y*4}
		object{Arc translate y*0}
		object{Arc translate y*-4}
		pigment{rgb 0}
	}
	union{
		object{Arc scale <1,-1,1> translate <-4,4,0>}
		object{Arc scale <1,-1,1> translate <-4,0,0>}
		object{Arc scale <1,-1,1> translate <-4,-4,0>}

		object{Arc scale <1,-1,1> translate <-4,2,0> pigment{rgb <1,0,0>} finish{ambient 1 diffuse 0}}
		object{Arc scale <1,-1,1> translate <-4,-2,0> pigment{rgb <0,0,1>} finish{ambient 1 diffuse 0}}

		pigment{rgb 0}
		translate y*5+x*-2
	}
	union{
		box{<-4,5,0>,<-3,-3,1>}
		box{<4,7,0>,<3,-3,1>}
		box{<-.5,5,0>,<.5,-2,1>}
		pigment{rgb 0}
	}
	box{<4,6,0>,<0,4,.99> pigment{rgb <0,1,0>} finish{ambient 1 diffuse 0}}
	box{<-3,6,0>,<0,4,.99> pigment{rgb <1,0,0>} finish{ambient 1 diffuse 0}}
	box{<-4,4,0>,<0,0,.99> pigment{rgb <0,0,1>} finish{ambient 1 diffuse 0}}
	box{<4,3,0>,<0,0,.99> pigment{rgb <1,1,0>} finish{ambient 1 diffuse 0}}
	scale <1.1,1.2,1>
	no_shadow
	translate x*-186+y*119+z*1
}

//X icon
union{
	disc{
		<0,0,0>, z, 16 
		pigment{
			onion 
			color_map{
				[0  rgb <1,0,0>]
				[.93 rgb <1,0,0>]
				[.93 rgb <.5,0,0>]
				[1 rgb <.5,0,0>]
			}
			scale 14
		}
		finish{ambient 1 diffuse 0}
	}
    union{
    	box{<-2,-10,0>,<2,10,.01>}
    	box{<-10,-2,0>,<10,2,.01>}
    	rotate z*45
    	pigment{rgb 1}
    	finish{ambient 1 diffuse 0}
    }
	translate <-174,80,3.5>
}

light_source{ vnormalize(<-1,1,1>)*sqrt(100000*100000*3) 1}
		
camera{
	location z*50
	look_at 0
	orthographic
	up y*268
	right x*404
	translate x*1
}
