// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1g
// Fichier        : mrcarrelage.inc   	 by  Martial Rameaux
// Date           : Septembre 1999
// Description    : Une macro pour faire du carrelage
//
// Les noms de varialble sont assez explicite,   
// Seul la variable centre peut poser question 
// Valeur 0 le point <0,0,0> est au coin x=0 z=0 de la surface du carrelage.
// Valeur 1 le point <0,0,0> est au centre de la surface du carrelage. 
//
// Exemple:
//
// #local T_Carreau= texture {.....}
// #local T_Joint= texture {.....}
// #local Xnc=40; X_NombredeCarreaux
// #local Znc=40; Z_NombredeCarreaux
// #local Lc=2;   LargeurduCarreau
// #local Ec=0.2; EpaisseurduCarreau
// #local Lj=0.2; LargeurduJoint
// #local ctr=1; centre
// #declare Carrelage=
// object { MrCarrelage (Xnc,Znc,Lc,Ec,T_C,Lj,T_J,ctr)}
//   
//                
//==========================================  
//=============== T_CARRELAGE======

#declare T_C1 = 
      texture
      {      
         pigment
         {
            marble
            pigment_map
            {
               [0.0   
                  leopard
                  color_map
                  {
                     [ 0.0     rgbft <0.687467, 0.986978, 1.0, 0.0, 0.0>/3 ]
                     [ 0.5     rgbft <0.843733, 0.993489, 1.0, 0.0, 0.0>/3 ]
                     [ 0.75    rgbft <0.921867, 0.996744, 1.0, 0.0, 0.0> /3]
                     [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0>/2 ]
                  }
                  turbulence 0.8
                  scale  0.1
                 
               ]
               [1.0  
                  wood
                  color_map
                  {
                     [ 0.0     color rgb <0.176,0.984,0.827>/5 ]
                     [ 0.25    color rgb <0.694,0.929,0.992>/5 ]
                     [ 0.375   rgbft <0.075065, 0.523065, 0.849446, 0.0, 0.0>/5 ]
                     [ 1.0     rgbft <0.07537, 0.610242, 0.848876, 0.0, 0.0> /5]
                  }
                  //turbulence 0.8
                  rotate x*90
                  scale  0.6
                  
               ]
            }
         }  
        
         finish
         {
            ambient 0.3 diffuse 0.6
            reflection 0.3 //0.309333
         }
      }
      
//........................
//..............................
#declare T_J=texture {
                        pigment { rgb <1,1,1>}
                        finish { ambient 0.3 diffuse 0.6 }
}
//.............................      
//====================
#macro MrCarrelage (X_NombredeCarreaux,Z_NombredeCarreaux,LargeurduCarreau,EpaisseurduCarreau,T_Carreau,LargeurduJoint,T_Joint,centre)
//-----CARREAU--------

#ifndef (LargeurduCarreau)
#declare LargeurduCarreau=1;
#end
#ifndef (EpaisseurduCarreau)
#declare EpaisseurduCarreau=0.1;
#end
#ifndef (X_NombredeCarreaux)
#declare X_NombredeCarreaux=10;
#end
#ifndef (Z_NombredeCarreaux)
#declare Z_NombredeCarreaux=5;
#end
#ifndef (LargeurduJoint) 
#declare LargeurduJoint=0.12;
#end
#ifndef (centre)
#declare centre=0;
#end
#if (centre >1)
#declare centre=1;
#end

#declare Ec=EpaisseurduCarreau;
#declare C=(LargeurduCarreau-(Ec*2))/2;
#declare Lj=LargeurduJoint; 
#declare Cj=C+Ec; //pour le Joint 
#declare Joint=box {<-(C+Lj),-Ec,-(C+Lj)>,<+C+Lj,0,+C+Lj> texture {T_Joint}}

#declare Carreaux=
union{ 
cylinder{ <-C,0,-C><-C,0,C>Ec }
cylinder{ <C,0,-C><C,0,C>Ec }   

box {<-C,0,-C><C,Ec,C>}    
cylinder {<-C,0,-C><C,0,-C>Ec} 
cylinder {<-C,0,-C><C,0,-C>Ec}
cylinder {<-C,0, C><C,0, C>Ec}
sphere { <-C,0,-C>,Ec} 
sphere { <-C,0,C>,Ec}
sphere { <C,0,-C>,Ec}
sphere { <C,0, C>,Ec}
object {Joint translate <0,Ec/2,0>}
 
}

#declare Carreaux=
difference {
        object {Carreaux }
       // plane { y,-Ec/2}
        texture {T_C}
}
 
//=======CARRELAGE============
#declare Lc=X_NombredeCarreaux;
#declare Lzc=Z_NombredeCarreaux;
//------------------------  
#declare Rand0=seed(2241);
#declare Rand0=rand(seed(Rand0));
#declare Carrelage=
union {
#declare ii=0; //Reset du Compteur
#while (ii<=Lc-1)  

     #declare CarelageZ=
                union { 
                #declare II=0;// Reset Compteur
                        #while (II<=Lc-1)
                        #declare Randx=rand(Rand0)*1.5;
                        #declare Randz=rand(Rand0)*2;
                        #declare RandT=rand(Rand0);
                        //...................
                      //  #debug concat ("N ",str(II,0,0)," - ",str(Randx,2,2)," \n")
                                #if ( mod(int(RandT*100),7)=0)
                                object {Carreaux texture { T_C} rotate <Randx,0,Randz> translate <0,0,(C+Lj)*II*2>  } 
                                #else
                                object {Carreaux texture {T_C rotate y*90} rotate <Randx,0,Randz> translate <0,0,(C+Lj)*II*2>  } 
                                #end //IF
                        //........................
                        #declare II=II+1;
                        #end //..WHile
                 }
                 
object {CarelageZ translate <(C+Lj)*ii*2,0,0> }
#declare ii=ii+1;
#end 

#if (centre=0)
translate <(C+Lj),0,(C+Lj)>
#else 
translate <(C+Lj),0,(C+Lj)>
translate <-(C+Lj)*Lc,0,-(C+Lj)*Lc>
#end //IF

}
//============================
object {Carrelage }
#end
//=========== FIN DE LA MACRO =================

