// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1g
// Fichier        :  fauteuil.inc  	 by  Martial Rameaux
// Date           :  22/10/99
// Description    :  Fichier objet fauteuil faisant parti de la scene mrhorror                     
// mile ;) ->m.r@lemel.fr
//==========================================  


//======TEXTURES========

#declare T_Fauteuila=
texture {pigment  {  wood
                         color_map
                  {
                     [ 0.0     color rgb <0.06086,0.047,0.0459> ]
                     [ 0.5     color rgb <0.0878,0.0788,0.0706> ]
                     [ 1.0     color rgb <0.0686,0.0600,0.0196>]
                  }
                  turbulence y*0.2
                  frequency 5.0
                  phase 0.0
                  ramp_wave    //rotate y*90
               }               
                              finish {ambient 0.1 diffuse 0.5 reflection 0.01 }
                             scale 0.2  rotate y*90
}
#declare T_Fauteuilb=
texture { pigment  {   wood
         color_map
                  {
                     [ 0.0     rgbf <0.729167, 0.552067, 0.4479, 0.5> ]
                     [ 0.5     rgbf <0.0677083, 0.0515617, 0.0369783, 0.50> ]
                     [ 0.77    rgbf <0.651042, 0.497392, 0.330725, 0.5> ]
                     [ 1.0     rgbf <0.05, 0.079167, 0.091667, 0.70> ]
                   }  
                   // rotate y*90
                  turbulence y*0.10
                  octaves 9
                  lambda 2.0
                  frequency 2.0
                  phase 0.2
                  ramp_wave 
                 
               }
                              finish {ambient 0.1 diffuse 0.4 }
                           scale 1.2   rotate y*90
}
#declare T_Fauteuilc=
texture { 
        pigment {
        wood 
        color_map
                  {
                     [ 0.0     color rgbf <0.457,0.437,0.465,0.60> ]
                     [ 0.5   color rgbf   <0.655,0.651,0.671,0.60> ]
                     [ 1.0     color rgbf <0.557,0.537,0.565,0.6> ]
                   }  
                   // rotate y*90
                  turbulence y*0.10
                  octaves 9
                  lambda 2.0
                  frequency 0.0
                  phase 0.2
                  ramp_wave 
                
               }
               finish {ambient 0.1 diffuse 0.3 }
               rotate y*90
}
#declare T_TachedeSang=
                texture {
                        pigment {
                                 leopard 
                                 color_map {
                                        [0.0 rgb <1,0,0>/2]
                                        [0.3 rgbf <0,0,0,1>]      
                                        [0.5 rgbf <0,0,0,1>] 
                                        [0.8 rgbf <0,0,0,1>]            
                                        [1.0 rgbf <1,0,0,0.5>/2]
                                        }
                                   turbulence 1
                                   octaves 20
                                   omega 0.6
                                   lambda 1
                                   frequency 1 
                                   scale 2
                                   translate x*20  
                        }
                        finish {ambient 0.1 diffuse 0.2 }
                }
                
                
                                        
                                        
                                        
#declare T_Fauteuil2=
texture {T_Fauteuila   scale 0.8 }
texture {T_Fauteuilb   scale 0.8 }
texture {T_Fauteuilc   scale 0.8 }
texture {T_TachedeSang scale 0.8 }

//=========FAUTEUIL===============

declare Clousd=
        union { // clous
        cylinder {<0.0,0,0><0,0,0.4>0.02}
        cylinder {<0.0,0,0><0.0,0,-0.01>0.04}
        texture {pigment {rgb 0.2}finish { ambient 0.3 diffuse 0.6 phong 1 reflection 0.5 brilliance 0.7 metallic} }
         }
#declare Clousg=
        union { // clous
        cylinder {<0.0,0,0><0,0,-0.4>0.02}
        cylinder {<0.0,0,0><0.0,0,0.01>0.04}
        texture {pigment {rgb 0.2}finish { ambient 0.3 diffuse 0.6 phong 1 reflection 0.5 brilliance 0.7 metallic} }
         }

#declare Fauteuil =
union { 
       //object {Spot_Fauteuil }
        union { //siege
        box {<0,0,-1.5><3,0.21,-0.8> }
        box {<0,0.1,-0.70><3,0.21,0.5> }
        difference {
        box {<0,0,0.60><3,0.21,1.5> }
        sphere {<2.0,0,0>0.25 scale <0.9,1.5,1> rotate y*15 translate z*1}
        }
        object { Clousd translate <0.0,0.1,-1.5>} 
        object { Clousg translate <0.0,0.1, 1.5>}
        texture {T_Fauteuil2  }

         }
        union { //repose pied
        difference {
        box {<0,0,-1.5><1,0.2,1.5> texture {T_Fauteuil2 scale 0.5 rotate y*90  }}
        sphere {<0.5,0,0>0.2 scale <1,1.5,1> rotate y*15 translate z*-1}
        }
        box {<0,0,-1.5><0.5,1.3,-1.7>} 
        box {<0,0, 1.5><0.5,1.3, 1.3>  }
        object { Clousd translate <0.3,1.1,-1.7>}
        object { Clousg translate <0.3,1.1, 1.7>}
        object { Clousd translate <0.3,0.1,-1.7>}
        object { Clousg translate <0.3,0.1, 1.7>}
        texture {T_Fauteuil2  }
        rotate z*20
        translate <3,-1,0>
        }
        
        union { // dossier 
            difference {
                    union {
                        box {<0,0,-1.5><4,0.3,-0.7>  }
                        box {<0,0,-0.60><3.99,0.3,0.5>  texture {T_Fauteuil2 scale 0.4} }
                        }
                sphere {<0.0,0,0>0.1 scale <2.,4,1.5> rotate y*-30 translate <3.8,0,-0.65>}
           }
        box {<0,0,0.60><4.01,0.3,1.5> rotate y*-0.5}
        texture {T_Fauteuil2}
        rotate z*110 translate <0.2,0,0>
        }    
                          
        union {                  //accoudoir d
        difference {
        box {<-0.2,1.5,-1.5><3,1.6,-1.0>} 
        sphere {<0.0,0,0>0.1 scale <0,4,1.5> rotate y*-30 translate <2.5,1.6,-0.4>}
        }
        object { Clousd translate <0.1,1.55,-1.5>}
        box {<-0.2,0.5,-1.5><0.2,1.9,-1.3> rotate z*-25}
        object {Clousd translate <0.35,0.5,-1.5>}
        object {Clousd translate <0.8,1.55,-1.5>}
        translate <-0.6,0,-0.2>
        texture {T_Fauteuil2  }

        }
        union { //accoudoir g
        box {<-0.2,1.5, 1.5><3.2,1.6, 1.0>}
        object { Clousg translate <0.1,1.5, 1.5>}
        box {<-0.2,0.5, 1.5><0.2,1.9, 1.3> rotate z*-25}
        object {Clousg translate <0.35,0.50,1.5>}
        object {Clousg translate <0.8,1.55,1.5>}
        texture {T_Fauteuil2  }
        translate <-0.6,0, 0.2>
        }
       // union { //courroie 
       #declare AvP1=sin(clock*2*-pi)*90;
       #declare AvP2=sin(clock*2*pi)*90;
       #declare AvBs=sin(clock*2*pi)*5;
        union { // pied
        box { <-0.8,-2.0,-1><-0.6, 0.0,1.0>   rotate z*AvP1 translate x*0.5}
        box { <-0.8,-2.0,-1><-0.6, 0.0,1.0>   rotate z*AvP2 translate x*2}
        box { <-0.9,-2.0,-1>< 1.1,-1.8,1.0>  translate x*AvBs  }
        texture {T_Fauteuil2  }
       
        }  
//translate x*-20    
translate x*clock*30        
translate y*2.1
}


//=============TRAVAIL================
/*
#declare Zoom=1.5;
#declare Distance =30;
#declare Azimut =50; 	// angle de dplacement                       
#declare Elevation =47; // angle en degrs au-dessus (positif) ou en-dessous (ngatif) du plan XZ ; 
                        // cet angle se limite  : 90 > Elevation > -90. C'est absolument ncessaire.
#declare Right=4/3*x;   // pour changer le rapport x/y ;                        
#declare CentreD_Interet = <0,0, 0>;
//------------------------------------
#include "camera.inc" 
Camera (Distance, Azimut, Elevation, CentreD_Interet)
//====================================
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}
object { Fauteuil scale 1.6 rotate y*60 translate <-4,-7,11>}
*/