// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1g
// Fichier        :    	 by  Martial Rameaux
// Date           :
// Description:                     
// Web  ->http://martial.rameaux.free.fr/
// Web  ->http://multimania.com/martialrameaux
// mile ;-) -> martialrameaux@multiamania.com
//==========================================
// unOfficial Superpatch build of POV-Ray 3.1e Ronald L.Parker
// colorpicker by Jamis Buck.
// Bioform v.0.99d 
// Spline.inc macro by Ronald L. Parker
// PaintShopPro for images 2d 
// ACDSee for convert jpg
// Position Camera by Jean Montambeault
// SplineEditor by Alessandro Falappa
// Squelette to http://www.3dcafe.com
// Frog by myself in Irtc "Nature"
//==============================================
// +fn16 +a0.1 +R3 +AM2
//==============================================
//17h 14mn 35s with +a0.1 +R3 +AM2
//==============================================


global_settings{ assumed_gamma 1.25}  
//=========================
//====================================
//  POSITION DE LA CAMRA 
// Autor : Jean Montambeault
//------------------------------------
#declare Distance =30; //30;50;47 pour mmoire
#declare Azimut = 50;  // angle de dplacement                       
#declare Elevation=47; // angle en degrs au-dessus (positif) ou en-dessous (ngatif) du plan XZ ; 47
                       // cet angle se limite  : 90 > Elevation > -90. C'est absolument ncessaire.
#declare Zoom=1.5;                         
#declare CentreD_Interet = <0,1.0, 0>;
//------------------------------------
#include "camera.inc" 
//====================================
Camera (Distance, Azimut, Elevation, CentreD_Interet)
//=========================

//=======LUMIRE D'AMBIENCE=================
light_source { 0*x rgb <0.8,0.5,0.5>*0.5 area_light <30,0,0><0,0,30> 8,8 adaptive 0  rotate y*10 translate y*50 shadowless }

//=======CARRELAGE=========  
#include "carrelage.inc"
#declare T_C = texture {T_C1} 
// ...................pour le Travail 
//#local T_C=texture {pigment { rgb 1} finish{ ambient 0.4 diffuse 0.6 reflection 0.1}}
// ...................Fin pour le Travail ............................

#local T_J=texture { T_J }
//MrCarrelage(X_NbCarx,Z_NbCarx,LargCar,EpaisCar,T_Car,LargJoint,T_Joint,centre)

#local Xnc=29;
#local Znc=29;
#local Lc=2;
#local Ec=0.2;
#local Lj=0.2;
#local ctr=1;
#declare Carrelage=
object { MrCarrelage (Xnc,Znc,Lc,Ec,T_C,Lj,T_J,ctr)}// ctr =1 point <0,0,0> au milieu; carrelage blanc au centre 


//=====CRACHOIR=========================
//-----TEXTURE CRACHOIR
#declare T_Cr1=texture {pigment {rgbf <1,1,1,0.3>}
finish {ambient 0.2 diffuse 0.9 phong 1 reflection 0.02}
//finish {specular 1 roughness 0.001 ambient 0.1 diffuse 0.8}
}
#declare T_Cr2=texture {
                        pigment {
                                 leopard 
                                 color_map {
                                        [0.0 rgb <1,0,0,0.0>]
                                        [0.3 rgbf <1,1,1,1>]      
                                        [0.5 rgbf <1,1,1,1>] 
                                        [0.8 rgbf <1,1,1,1>]            
                                        [1.0 rgbf <1,0,0,0.5>]
                                        }
                                   turbulence 1
                                   octaves 20
                                   omega 0.6
                                   lambda 1
                                   frequency 2 
                                   scale 1.5
                                   translate x*20  
                        }
                        finish {ambient 0.1 diffuse 0.2 }
                }

#declare T_Crachoir=texture {T_Cr1} texture { T_Cr2}
#declare T_Robinet=texture {pigment { rgb <0.9,0.9,0.9>} finish { ambient 0.3 diffuse 0.6 phong 1 reflection 1.0 }}
#declare T_Colonne=texture {pigment { rgb <0.9,0.9,1.0>} finish{ ambient 0.2 diffuse 0.6 phong 1 reflection 1.0}}

//------CRACHOIR---
//----------------------------------------
#declare Arrivedo=
union {
cylinder { <0,6.5,0>,<0,7.5,0>0.08 }
difference {
torus { 1,0.08 rotate x*90 }     
plane { -y,0} 
plane { -x,0}
translate <1,6.5,0>
}
difference {
torus { 1,0.08 rotate x*90 }     
plane {  y,0} 
plane {  x,0}
translate <1,4.5,0>
}

difference {
torus { 1,0.08 rotate x*90 translate <0,7.5,0>}     
plane { y,7.5} 
plane { -x,0}
translate x*1
} 

union { // collet
difference {
torus { 0.5,0.08 rotate x*90 sturm }     
plane { y,0.} 
plane { x,0}   
translate <0,8,0>
}
difference {
torus { 0.3,0.08 translate <0,0,0> sturm}     
plane { -x,0} 
plane { z,0}   
rotate <0,-90,0> 
rotate <-90 ,0,0>
rotate y*90
translate <0.5,8.01,-0.3>
} 

difference {
torus { 0.3,0.10  translate <0,0,0.0> sturm}     
plane { x,0}   
rotate y*90 
translate <0.8,7.7,-0.3>
} 
translate x*1.0
}  

texture {T_Robinet}
rotate y*-30  
translate <-1.6,-1.2,-1.4>
}
//--- fin Robinet

#declare Colonne=union { 
cylinder {<-0.,0,-0.><-0,0.5,0.>1.8}
cylinder { <0,0.5,0><0,6.0,0>0.5}   
pigment {rgb <0,0,1>}
}  
#declare Crachoir=
union {
        difference {
        torus { 1,0.7 }
        sphere {<0,0.45,0>1.2 } 
        scale <1,0.5,1>
        }
        torus { 1.63,0.2 }
translate y*6.2
}

//------------------
#declare Crachoir=
union {  
object { Arrivedo texture {T_Robinet}}
object { Colonne  texture {T_Colonne}}
object { Crachoir texture {T_Crachoir}}
hollow 
}

//===== CAGE===============================
//-----TEXTURE CAGE
#declare T_Grille=texture {
                        pigment {color rgb 0.95}//rgb <0.95, 0.90, 0.85>}
                        finish {
                            ambient 0.1
                            brilliance 6
                            diffuse 0.7
                            metallic
                            specular 0.80
                            roughness 1/120
                            reflection <0.7,0.7,0.9>
                        }
                        normal { dents 0.2}
} 
#declare T_PiedGrille=texture {
                        pigment {rgb <0.8,0.8,0.8>}
                        finish {ambient 0.1 diffuse 0.6 phong 0.2 reflection 0.0 brilliance 7}
                        normal { dents }
} 
//-------GRILLES-------
#declare I=0;  
#declare Grille=
union {
#while (I<50 )

   cylinder { <I,0,0><I,50,0>0.2}
   cylinder { <0,(I*1.5)+0.8,0><50,(I*1.5)+0.8,0>0.2} //Barreau Horizontal
   cylinder { <I,0,0><I,0.2,0>0.5 texture { T_PiedGrille}}   //PIED
   #declare I=I+3;
   #end
   
}
#declare Cage= union {
               // object {Grille rotate x*-90  translate z*-Bx}
                //object {Grille rotate x*-90  translate <0.50,0,Bx+0.45>}
                object {Grille    }
                object {Grille  rotate y*90  }
               //  object {Grille translate y*Bx} // audessus 
               texture {T_Grille} 
               hollow
}


//=======CHALUMEAU===============
//.......TEXTURE FLAMME.........
#declare Density1=
  density {
    cylindrical
    ramp_wave
    color_map {
      [0.0 color rgb 0]
      [1.0 color rgb <0.3, 0.0, 0.0>]
    } 
scale 0.7 
 }

#declare Density2=
  density {
    cylindrical
    ramp_wave
    color_map {
      [0.0 color rgb 0]
      [0.2 color rgb <1,0,0>]
      [0.3 color rgb <0.3, 0.8, 0.5>]
      [0.4 color rgb <0.8, 0.5, 0.3>]
      [0.6 color rgb <0.0, 0.0, 0.0>]
      [0.9 color rgb <0.2, 0.2, 0.5>]
      [1.0 color rgb 0]
    } 
scale 0.7
  } 

#declare M_Flamme=material {
        texture {
         pigment { color rgbf<1, 1, 1,1 > }
         finish { ambient 0.0 diffuse 0.0 }
  }
  interior { 
    media {
      emission 0.9 //.8     Wk
      intervals 20 //10    Wk
      samples 1,10  // 1,10 Wk 
      confidence 0.9999
      variance 1/1000
      density {
      gradient <1,1,1>
      //agate
         density_map {
          [0.3 Density1]
          [0.3 Density2]
          //[0.9 Density1]
       }
       
           turbulence <1.0,1.0,1.0>
         
 }
scale 1.9
 } 
  } 
}
//..........TEXTURE TUYAUX
#declare  T_TuyauR= texture {pigment {rgb <0.45,0,0>} finish{ambient 0.3 diffuse 0.6}}
#declare  T_TuyauB= texture {pigment {rgb <0,0,0.45>} finish{ambient 0.3 diffuse 0.6}}
//..........TEXTURE CHALUMEAU 
#declare T_Chalumeau= texture {
                                pigment {bozo 
                                        turbulence 1.
                                        omega 1
                                        color_map {
                                        [0.0 color rgb <0.70, 0.55, 0.40>]
                                        [0.5 color rgb <0.70, 0.55, 0.40>]
                                        [0.8 color rgb <0.70, 0.55, 0.40>]
                                         }
                                }
                                
                             finish {
                                    ambient 0.135
                                    brilliance 2
                                    diffuse 0.6
                                    metallic
                                    specular 0.80
                                    roughness 1/20
                                    reflection 0.5
                                }

                                normal { dents 0.5}
}  
//--------------------------------
#declare T_Embout=
                texture { 
                        pigment {bozo 
                                turbulence 1.2
                                 color_map {
                                        [0.0 color rgb <0.075,0.099,0.067>]
                                        [0.5 color rgb <0.075,0.012,0.067>]
                                        [1.0 color rgb <0.075,0.059,0.067>]
                                 }
                        }
                        normal { dents 1.2}   
                        finish { ambient 0.3 diffuse 0.6 phong 0.1  }
                }
//---------------------------                
#declare  T_Poignee=texture {
                        pigment { color rgb <0.459,0.243,0.067>/5}
                        normal {wrinkles 2}
                        normal {spiral1 5 scale .095 rotate y*90}

}
//--------------------------
#declare T_Bouton=texture {
                        pigment {rgb <0.98,0.98,0.98>}
                        finish {ambient 0.3 diffuse  0.6 phong 0.2 brilliance 10}
                        normal {spiral1 8 scale .095 rotate y*90}
} 

//=======CHALUMEAU=======
//--------POIGNEE
#declare Poignee=
       union{
        cone { <8,0,0>0.11<9.5,0,0>0.12  texture {T_Poignee}}
        difference {
        cylinder {<0,0.0,-0.1><0,0.0,-0.23>0.12   } 
        torus { 0.12,0.02 rotate x*90  translate z*-0.20 }   
        texture { T_Bouton  } 
        translate x*7.5
        rotate x*90
        }
       }
#declare PoigneeGaz=
                   union {
                       cylinder { <0,0,0><0,0,0.20>0.12}
                       union { sphere { <-.1,0,.5>,0.12 }
                                cylinder { <-.1,0,.5><1.2,0,0.8>0.12}
                                 sphere {<1.2,0,0.8>,.12}
                                  scale <1,1,0.3>
                        }
                     texture { T_Chalumeau     }
                    translate x*7.3
                    }
                   

//--------EMBOUT

#declare  Feux=             
cylinder { <0,0,1><0,0,-3>0.28 
material { M_Flamme scale <0.9,0.9,0.9>}   
 hollow
 }     

#declare FlammeRemous=
  box {<-10,-7,-10><10,-2,10> 
        material { M_Flamme scale 2.5 translate <-6,0,0>}//x*-6 } 
        hollow 
  }
#declare Trou=
union {
box{<-5,0,0.1><5,0.12,0.5> hollow}
box{<-5,0,0.1><5,0.12,0.5> rotate z*360/3 hollow}
box{<-5,0,0.1><5,0.12,0.5> rotate z*360/6 hollow}
hollow }  
#declare Bout_Chalumeau=
        union { // les petits tuyaux
        cylinder { < 0.0,0,0><-0.15,0.2,-0.5>0.08}
        cylinder { < 0.1,0,0>< 0.15,0.2,-0.5>0.08}
        cylinder { <-0.15,0.15,-0.3><0.15,0.15,-0.3>0.05}
        texture {T_Chalumeau}
        }
        
#declare Embout=
union {
        difference {
        cylinder { < 0,0,0.0><0,0,-1>0.3 }
        cylinder { < 0,0,-0.1><0,0,-1.2>0.25 }
        object {Trou translate z*-0.6 hollow}
        }
      light_source { 0*x rgb <0.8,0.7,0.7>*0.1 looks_like {object {Feux}} translate z*-1 }
       torus { 0.3,0.07 rotate x*90 translate z*-1.0 }
       texture { T_Embout} 
      //rotate <45,0,-80>//rotate x*20
       hollow
}   

//-------TUYAU
#include "spline_rp.inc"
#declare R0=<-95,10,10>;//<-95,10,10>
#declare R1=vnormalize(R0);	
#declare P1=<7.0,-0.3,-0.8>;// point d'attache
#declare P2=<10,-1,-1>;
#declare P3=<7,-1,-2>;
#declare P4=<5,3,-3>;
#declare P5=<11,-2,-5>;
#declare P6=<20,-3,-10>;
#declare P12=vrotate(P1,R1);
#declare P22=vrotate(P2,R1);	
#declare P32=vrotate(P3,R1);	
#declare P42=vrotate(P4,R1);	
#declare P52=vrotate(P5,R1);	
#declare P62=vrotate(P6,R1);	

#declare Pts=array[6]{P12, P22, P32,P42 , P52, P62}

#declare VTuy=<-0.5,-0.5,-.5>;//direction du tuyau
#declare Tuyau=
union {
object {
  TorusSpline( .08, Pts, VTuy )
  texture {T_TuyauR }
  scale 1
  }
object {
  TorusSpline( .08, Pts, VTuy )
  texture {T_TuyauB }
  translate x*.3 scale 1
  }
}

//-------LE CHALUMEAU

#declare Chalumeau=
        union {
        cylinder {<0,0,0><8,0,0>0.1 }
        sphere {<0,0,0>0.1}
        union {          // embouts
        object {Bout_Chalumeau}
        object { Embout translate <-0.3,.2,-0.5> }
        object { Embout translate < 0.3,.2,-0.5> }
        rotate z*-70//<20,-70,90> // direction de la flamme et de l'embout
        }
        object { Poignee}
        object { Tuyau }
        object {PoigneeGaz }
        texture { T_Chalumeau }
        }
        
        
        
//=======DENTISTE=======

#declare Dentiste=

union {
#declare Tan0=tan(radians(50))*30;
#declare PositionDentiste=<12,Tan0+20,5>; //<5.8,0,-5>
#declare PositionSpotDentiste=PositionDentiste+y*20;

 //#debug concat(" TAN ",str(Tan,5,20),"\n")
light_source {0*x color rgb 1.8  //<0.776,0.796,0.976>
       spotlight   
       parallel  
       translate PositionSpotDentiste
       point_at  PositionDentiste-y*Tan0  
       radius 10//11//
       falloff 10.5//12//
       tightness 10//30  
       }

plane { y,0 pigment { 
                image_map { 
                png "plomber.png" 
                transmit 0,1 once  //1,1
                }
        translate -0.5*(x+y)
        rotate x*90 
        scale 28
         }
  rotate <0,-80,0>
  translate PositionDentiste  
 
}  
hollow
}
//=======PATIENT==============
#declare Patient=
union {
#declare Tan0=tan(radians(50))*30;
#declare PositionPatient=<-3,Tan0+10,-9>; //<5.8,0,-5>
#declare PositionSpotPatient=PositionPatient+y*20;
//#debug concat(" TAN ",str(Tan,5,20),"\n")
light_source {0*x color rgb 1.8//<0.776,0.796,0.976>
       spotlight   
       parallel  
       translate PositionSpotPatient
       point_at  PositionPatient-y*Tan0  
       radius 5//11//
       falloff 7//12//
       tightness 1//30      
       }
plane { y,0 pigment { 
                image_map { 
                png "Patient.png" 
                transmit 1,1 once 
                }
        translate -0.5*(x+y)
        rotate x*90 
        scale 15
         }
  rotate <0,-50,0>
  translate PositionPatient  

}  
hollow
}

//==========FAUTEUIL==================
#include "fauteuil.inc"
//======= PINCES ===============
#include "pince.inc"
#declare Pince=
object {pince texture {T_Pince }scale <1,0.2,1>*5 translate <-0,-6.5,-0>}
#declare Prescel=
object { prescel texture {T_Prescel} scale 2 rotate <90,90,90,> rotate y*180}
//=======ROULETTE======================
#include "roulette.inc"
//========COMMODE============
#include "commod.inc"        
//========BOCAL==============
#include "bocal.inc"
//=======DENTIER========
#include "dentier.inc"
//========GLOBULE========

#include "globule.inc"
#declare Globule=
object {WheelWorm
  scale <1, 1, 1>
  rotate <262, 142, 107>
  translate <0, 0, -2>
} 

//========GRENOUILLE=======
#include "grnouil.inc"  
//========SQUELETTE======
#include "squel1.inc"
//=======LA SCENE==============

object { Carrelage  rotate y*10 translate <-12,-7,14> hollow}   
object { Cage rotate y*10 translate <-18,-6.9,25>}                
object { Patient  translate z*2} 
object { Dentiste }

object { Fauteuil scale 1.6 rotate y*60 translate <-4,-7,11>}
object { Pince  translate <-4,3,5>} // rotate <120,0,-45>
object { Roulette rotate y*20 translate <-11,-7,11>}
object { Crachoir rotate y*-0 translate <-8,-7,8> }
object { Chalumeau  rotate R0 translate <-1.5,3,-1> scale 2}//translate <-0.5,4,-1.5> scale 2} // <-90,0,10>
object { FlammeRemous }   
object { Globule  scale 0.8 rotate <-0,120,0> translate <0,11,-4> }
object { Commode rotate y*-80 translate <-19,-7,-3>}
object { Prescel rotate y*120 translate <-19,-3.5,-5>}
object { FouilleDents   texture {T_Pince}scale 1.5 rotate y*-80 translate <-17.5,-3.5,-2> }
object { FouilleDents   texture {T_Pince}scale 1.5 rotate y*-80 translate <-17.3,-3.5,-1.8> }
object { FouilleDents   texture {T_Pince}scale 1.5 rotate y*-80 translate <-17.1,-3.5,-1.6> }
object { Porte_Dentier  rotate y*-70 translate <-16.9,-5.3,0.5>}
object { Bocal scale <1,0.8,1> translate <-18.5,-1.8,-3>}
object { Grenouille scale 0.12 rotate y*-45 translate <-18.5,-0.8,-3>}
object { Prescel rotate y*60 translate <-18,-1.8,-6.5>}

object {Squelette scale 9.0 rotate y*140 translate <-1.5,0,18>}//rotate y*140 

//========FIN DE SCRIPT POVCHERI=====

//==============POUR LE TRAVAIL======================
//background { rgb <0.8,0.8,0.7>}
//plane { y,80 pigment {rgb 1} }
//plane { y,-7 pigment {rgb 2} }
//light_source {0 rgb 1 spotlight translate <-5,-5,8> point_at <-5,-7,15>  radius 0.1  falloff 20 tightness 1}
//light_source { 0*x rgb <0.2,0,0> area_light <30,0,0><0,0,30> 8,8 adaptive 0  rotate y*10 translate y*50 shadowless }
//======================



