// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1g
// Fichier        :    	 by  Martial Rameaux
// Date           :
// Description:                     
// Web  ->http://martial.rameaux.free.fr/
// Web  ->http://multimania.com/martialrameaux
// mile ;-) -> martialrameaux@multiamania.com
//==========================================

                
#declare T_Rotule=
        texture {pigment { rgb <0.9,0.9,1.0>} 
                 finish{ ambient 0.2 diffuse 0.9 phong 1 reflection 0.8 brilliance 10}
                 }
               
#declare T_Outils=  
                texture {
                        pigment {rgb <0.2,0.2,0.5>} 
                        finish{ambient 0.2 diffuse 0.8 reflection 0.5 }
}
#declare T_Pointe=  
                texture {
                        pigment {rgb <0.8,0.8,0.7>} 
                        finish{ambient 0.2 diffuse 0.8 reflection 0.5 }
}

#declare T_Flexible=
         texture {pigment { rgb <0.0,0.0,0.0>} 
                 finish{ ambient 0.3 diffuse 0.6 phong 1 reflection 0.2}
                 }
#declare T_Roulette=
        texture { pigment { rgb <0.9,0.9,0.7>}
                  finish { ambient 0.4 diffuse 0.6 phong 1 reflection 0.1 brilliance 5}
                  normal { dents 0.01 scale 0.1 }
                  }

#declare T_PorteOutils=
                texture {
                        pigment {rgb <0.5,0.5,0.6>} 
                        finish{ambient 0.2 diffuse 0.8 reflection 0.2 }
}                                                 
                  
#declare Base=
 union {
 intersection 
  {plane {-y,1}
   plane {-z,0.9 rotate <2.2,    0, 0>}
   plane {-z,0.9 rotate <2.2,  -90, 0>}
   plane {-z,0.9 rotate <2.2,  180, 0>}
   plane {-z,0.9 rotate <2.2,   90, 0>}
   plane { y,8}
   scale 1.3
  }
box { <-1.3,0,-1.3><1.3,1,1.3>}
}   

#declare PorteOutils=
union {
box{ <-0.8,2,-.8><0.8,5.9,.8> }
union {
cylinder {<-0.8,5.9,-.8><0.8,5.9,-.8>,0.1 }
sphere { <0.8,5.9,-.8>,0.1 }
cylinder {<-0.8,5.9,.8><0.8,5.9,.8>,0.1}
sphere { <0.8,5.9, .8>,0.1 }
cylinder { <0.8,5.9,-.8><0.8,5.9,.8>,0.1}
box { <-0.8,5.9,-.8><0.8,6,.8> texture {T_PorteOutils} }
  texture {T_Rotule}

}
rotate z*-30 translate <-1.5,1,0>
}

#include "spline_rp.inc"
#declare P1=<0.,1,-0.>;// point d'attache
#declare P2=<-0.1,1.5,-0.1>;
#declare P3=<-.2,1.8,-0.2>;
#declare P4=<-.3,2,-0.5>;
#declare P5=<-0.2,3,-0.8>;
#declare P6=<-3,5,0>;
#declare Pts=array[6]{P1, P2, P3,P4 , P5, P6}

#declare VTuy=<0.5,0.5,.5>;//direction du tuyau
#declare Flexible=
union {
object {
  TorusSpline( .08, Pts, VTuy )
  texture {T_Flexible }
  scale 1
  }
}
#declare Outils=
union {
     cylinder { 0,<0,1,0>0.1 }
    torus { 0.1,0.05 texture {T_Rotule} }
    object {Flexible }
  texture {T_Outils }
}
#declare Outils=
union {
  object {Outils translate <0.2,0,-.5>}
  object {Outils translate <0.2,0,-.0>}
  object {Outils translate <0.2,0,.5>}
rotate z*-20
translate <1.5,6.5,0>
}

#include "spline_rp.inc"
#declare P1=<6.0,1,2.5>;// point d'attache <3,1,0>
#declare P2=<0.1,3,-0.1>;
#declare P3=<0.5,4,-0.2>;
#declare P4=<-.0,4,-0.5>;
#declare P5=<-4,5.0,1>;
#declare P6=<-8,4,5>;
#declare Pts=array[6]{P1, P2, P3,P4 , P5, P6}

#declare VTuy=<0.5,0.5,.5>;//direction du tuyau
#declare Flexible2=
union {
object {
  TorusSpline( .08, Pts, VTuy )
  texture {T_Flexible }
  scale 1
  }
}

#declare Outils2=
union {
union {
    sphere {<0,0,0>0.1 texture {T_Rotule}  }  
    cylinder { 0,<0,-1,0>0.08  texture {T_Outils } }
    sphere {<0,-1,0>0.1 texture {T_Rotule}  }  
    cone  { <0,-1,0>0.08<0,-1,-0.4>0.001 texture {T_Pointe} }
 rotate z*-45
translate P1
 }
        object {Flexible2 }
}

#declare Outils2=object {Outils2 translate <12,10.5,0> }

#declare Rotule1=
        union {
            cylinder {<0,0,.8><0,0,-.8>.9 }
            cylinder {<0,0,.9><0,0,-.9>.8}
            sphere {0,1.0}
            translate y*11 
            }
#declare Rotule2=
        union { 
            cylinder {<0,0,.6><0,0,-.6>.4}
            sphere { 0,.6 }
            }
            

#declare Bras1=
        box { <0,0,-.5><5,0.5,0.5> }

#declare Demilune=0;
#declare Torsade=
  union {
#while (Demilune < 15)
 sphere {0,.15  translate <0,sin(-Demilune/20)*pi,-sin(Demilune/5)>}
#declare Demilune=Demilune+1;   
#end
} 

#declare Spot=cylinder { <-0.45,0,0><0.45,0,0>0.1 pigment {rgb 5}}
#declare Spot1=
union {
        difference{
       cylinder { <-0.5,0,0><0.5,0,0>0.4}
       cylinder { <-0.5,0,0><0.5,0,0>0.35}
              plane {y, -0.1}
       }
       union {
       cylinder { <-0.4,0,0><-0.4,0.8,0>0.08 }
       cylinder { <0.4,0,0><0.4,0.8,0>0.08 }
       cylinder { <-0.4,0.8,0><0.4,0.8,0>0.08 }
       sphere { <0.4,0.8,0>0.08 } 
       sphere { <-.4,0.8,0>0.08 }
       rotate x*-30
       }
        texture {T_Roulette}
        rotate x*-10
        } 
        
#declare Spot=
union { 
object {Spot1 rotate x*-70 translate <0,sin(-Demilune/20)*pi,0>}
light_source {0*x rgb 2 
             spotlight
             translate <0,(sin(-Demilune/20)*pi)-0.12345,0>
             radius 5
             falloff 20
             tightness 1
             point_at <-8,-2,8>
             looks_like {Spot}
                }  
}

#declare Braslumiere= 
        union {
        union {
        cylinder {<0,0,0.3><0.0,0,-.4>0.30 }
        cylinder {<0,0,0.35><0.0,0,-.45>0.25 }
        sphere { <0.0,0,0>,0.35}
        rotate x*20
        }
        object { Torsade  translate z*0.25 }
        object { Spot  }
 texture {T_Rotule}
      rotate x*50
      } 

#declare Bras2=
union {
        box { <0,0,-.5><4,0.5,0.5> }
        object { Braslumiere translate <4,0.25,-0.0>}
}

        

 
#declare Roulette=
union { 
object {Base }
object {Rotule1 texture {T_Rotule}}
object {Bras1 rotate z*-20 translate y*11 }
object {Rotule2 texture {T_Rotule} translate <5,9.5,0>}
object {Bras2 rotate <0,-20,40> translate <5,9.3,0> }
object {PorteOutils}
object {Outils }
object {Outils2}
texture {T_Roulette}
hollow
 }
 
//==**********POUR LE TRAVAIL******************
/*
#declare Zoom=1.5;
#declare Distance =30;
#declare Azimut = 50; 	// angle de dplacement                       
#declare Elevation =47; // angle en degrs au-dessus (positif) ou en-dessous (ngatif) du plan XZ ; 
                        // cet angle se limite  : 90 > Elevation > -90. C'est absolument ncessaire.
#declare Right=4/3*x;   // pour changer le rapport x/y ;                        
#declare CentreD_Interet = <0,1,0>;
//------------------------------------
#include "camera.inc" 
Camera (Distance, Azimut, Elevation, CentreD_Interet)
//====================================
#include "tx1099.inc"
#default {pigment {rgb <1,1,0>}finish { ambient 0.3 diffuse 0.6 }}
light_source {0*x rgb 0.8 translate <10,50,-10>}
plane {y,-7 pigment { rgb 1 scale 3} rotate y*10}
plane {z,100 pigment {rgb 0.5}}

object { Roulette rotate y*20 translate <-11,-7,11>}
#include "fauteuil.inc"
object { Fauteuil scale 1.6 rotate y*60 translate <-4,-7,11>}
*/