/**********************************************************************
***********************************************************************

        Prison by M.Schimmler (schimmler@ica.uni-stuttgart.de)
        IRTC Round November 1998 - October 1999
        topic: Horror
        COPYRIGHT: (C) 1999 Marc Schimmler with respect to the IRTC copyright 

***********************************************************************
***********************************************************************/

// ########################################################## include files

#include "kolors.inc"
#include "rat.inc"
#include "skull.inc"

// ########################################################## camera

camera {location <-10,4,0.5>
        //location <0,5,-1>
        look_at  <20,0,0>
        //look_at <0,0,-1>
        angle 70
       }

// ########################################################## global settings

global_settings {max_trace_level 10}

background {Gray05}   //{Gray30}

#declare seed1 = seed(54698635);

// ############################################################# Rust
#declare Rust1 = texture { 
   pigment{
    bozo color_map {
	[0.000000 color rgbt <0.113636, 0.113636, 0.113636, 0.000000>]
	[0.221580 color rgbt <0.378787, 0.212437, 0.110480, 0.000000>]
	[0.346912 color rgbt <0.643939, 0.311237, 0.107323, 0.000000>]
	[0.346912 color rgbt <0.643939, 0.311237, 0.107323, 0.000000>]
	[0.449416 color rgbt <0.757575, 0.565619, 0.463661, 0.000000>]
	[0.538564 color rgbt <0.871212, 0.820000, 0.820000, 0.000000>]
	[0.538564 color rgbt <0.871212, 0.820000, 0.820000, 0.000000>]
	[0.617696 color rgbt <0.605606, 0.474046, 0.463645, 0.000000>]
	[0.652755 color rgbt <0.340000, 0.128091, 0.107291, 0.000000>]
	[0.652755 color rgbt <0.340000, 0.128091, 0.107291, 0.000000>]
	[0.747913 color rgbt <0.670000, 0.325040, 0.163645, 0.000000>]
	[0.777963 color rgbt <1.000000, 0.521990, 0.220000, 0.000000>]
	[0.777963 color rgbt <1.000000, 0.521990, 0.220000, 0.000000>]
	[0.854667 color rgbt <0.602272, 0.321683, 0.133005, 0.000000>]
	[1.000000 color rgbt <0.204545, 0.121376, 0.046011, 0.000000>]}
       turbulence 2.0}
       normal{ bumps normal_map {
          [0.000000 bumps scale 0.0001     ]
          [0.221580 granite scale 0.01 ]
          [1.000000 crackle 0.01]}
      }
}     
  

#declare Rust2 = texture{
pigment{ bumps color_map {
          [0.000000 color rgbt <0.113636, 0.113636, 0.113636, 0.000000>]
          [0.221580 color rgbt <0.378787, 0.212437, 0.110480, 0.000000>]
          [0.346912 color rgbt <0.643939, 0.311237, 0.107323, 0.000000>]
          [0.346912 color rgbt <0.643939, 0.311237, 0.107323, 0.000000>]
          [0.538564 color rgbt <0.757575, 0.565619, 0.463661, 0.000000>]
          [0.816361 color rgbt <0.871212, 0.820000, 0.820000, 0.000000>]
          [0.816361 color rgbt <0.871212, 0.820000, 0.820000, 0.000000>]
          [1.000000 color rgbt <0.605606, 0.474046, 0.463645, 0.000000>]}
           turbulence 0.5
           scale <1,4,1>}
normal{ bumps normal_map {
          [0.000000 bumps scale 0.01     ]
          [0.221580 granite scale 0.01 ]
          [1.000000 crackle 0.01]}
      }
}

#declare Rusty = texture {
 pigment{bumps color_map{
	[0.000000 color rgbt <0.113636, 0.113636, 0.113636, 0.000000>]
	[0.243924 color rgbt <0.395047, 0.243284, 0.147405, 0.000000>]
	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
	[0.747913 color rgbt <0.838229, 0.447461, 0.200587, 0.000000>]
	[0.777963 color rgbt <1.000000, 0.521990, 0.220000, 0.000000>]
	[0.777963 color rgbt <1.000000, 0.521990, 0.220000, 0.000000>]
	[0.854667 color rgbt <0.602272, 0.321683, 0.133005, 0.000000>]
	[1.000000 color rgbt <0.204545, 0.121376, 0.046011, 0.000000>]
   } turbulence 1.2}
 normal {bumps normal_map{
                   [0.2 bumps turbulence 1.1 scale 0.01]
                   [0.8 granite turbulence 0.1]}
        }
}

// ########################################################## crane

#include "crane.inc"
#include "lamp2.inc"
#include "spine.inc"

// ########################################################## spotlights

light_source { <-20,-30,20> LightCyan*4 spotlight 
               radius 2
               falloff 2.5
               tightness 10
               point_at <90,21,45.5>}

light_source { <-40,-50,4> LightCyan*4 spotlight 
               radius 2
               falloff 2.5
               tightness 10
               point_at <90,21,45.5>}

light_source { <200,-10,20> LightCyan*4 spotlight 
               radius 2
               falloff 2.5
               tightness 10
               point_at <90,21,45.5>}

light_source { <300,-10,80> LightCyan*4 spotlight 
               radius 2
               falloff 2.5
               tightness 10
               point_at <310,0,2>}


/*light_source { <-10,4,0> AliceBlue*2 spotlight 
               radius 1
               falloff 8
               tightness 20
               fade_distance 15
               fade_power 1.2
               media_interaction on
               point_at <0,0,-3>}
*/

// ########################################################### media


media {
scattering {4, 0.005 extinction 0.01}
samples 20,100
intervals 10
ratio .999
confidence .9
variance 1/1000
}


// ########################################################### catwalk

#declare borderpart = object{
superellipsoid {<0.1, 0.1> 
                scale <1,0.04,0.04> 
                translate <0,0,0.96>}
}

#declare grid_border = object{
union{
 #declare i=0;
 #while ( i<4 )
  object{borderpart rotate <0,90*i,0>}
  #declare i = i + 1;
 #end
 }
}

#declare grid = object{
union{
 #declare i=1;
 #while (i < 19)
  box {<-1,-0.02,-1.005>,<1,0.02,-0.995>
       translate <0,0,0.1 * i>}
  #declare i = i + 1;
 #end
 }
}

#declare grid_tile = object{
union{
 object{grid_border}
 object{grid}
 object{grid rotate <0,90,0>} 

 }
}


#declare gridwalk = object{
 union{
 #declare i = 0;
 #while ( i < 100)
  #declare j = 0;
  #while ( j < 3)
   #if (i > 30)
    box{<-1,-0.02,-1>,<1,0,1> texture{Rusty 
                  translate <rand(seed1)*10,rand(seed1)*10,rand(seed1)*10>} 
           translate<-10 + i*2.01, 0 ,-3 + j*2.01> }
   #else 
    object{grid_tile
	 	  texture{Rusty 
                  translate <rand(seed1)*10,rand(seed1)*10,rand(seed1)*10>} 
           translate<-10 + i*2.01, 0 ,-3 + j*2.01> }
   #end
   #declare j = j + 1;
  #end
  #declare i = i + 1;
 #end
 }
}

#declare double_t = object{
 union{
  box {<-0.2,0,-4>,<0.2,-0.05,2.2>}
  box {<-0.025,-0.05,-4>,<0.025,-0.45,2.2>} 
  box {<-0.2,-0.45,-4>,<0.2,-0.5,2.2>}
 }
}

// ############################################################ door

#declare door_window = object{
 union{
  difference{
   box {<0,3,0.05>,<0.8,3.6,-0.15>}
   box {<0.04,3.04,0.06>,<0.76,3.56,-0.16>}
  }
  #declare i=0;
  #while (i<3)
   cylinder {<0.22,3,-0.05>,<0.22,3.6,-0.05>,0.04 translate <i*0.18,0,0>}
   #declare i = i + 1;
  #end
 }
}


#declare handle = object{
 union{
  intersection{
   torus {0.2,0.04 
          rotate <0,0,90>}
   box{<0.1,0.5,0.5>,<-0.1,0,0>}
   translate <0,0.4,0>
  }
  intersection{
   torus {0.2,0.04 
          rotate <0,0,90>}
   box{<0.1,-0.5,0.5>,<-0.1,0,0>}
  }
  cylinder{<0,0,0.2>,<0,0.4,0.2>,0.04}
  cylinder{0,<0,0,0.02>,0.05 
           translate <0,-0.2,0>}
  cylinder{0,<0,0,0.02>,0.05
           translate <0,0.6,0>}
 }
 translate <-0.25,2.4,0.02>
}

#declare door = object{
 union{
  difference{
   box {<-0.4,0,0.02>,<1.2,4,-0.13>}
   box {<0,3,0.05>,<0.8,3.6,-0.15>}
  }
 #declare i = 0;
 #while (i<20)
  sphere {<-0.3,0.1,0>,0.04 translate <0,i*0.2,0>}
  sphere {<1.1,0.1,0>,0.04 translate <0,i*0.2,0>}
  #declare i = i + 1;
 #end
 #declare i = 0;
 #while (i<6)
  sphere {<-0.1,3.9,0>,0.04 translate <i*0.2,0,0>}
  sphere {<-0.1,0.1,0>,0.04 translate <i*0.2,0,0>}  
  #declare i = i + 1;
 #end
 }
}

//############################################################# wall

#declare wall_tile = object{
 union{
  difference{
   box {<-3.6,0,-0.1>,<4.4,6,-0.2>}
   box {<-0.4,-0.1,0.02>,<1.2,4,-0.22>}
  }
 box {<4.2,0,-0.1>,<4.6,6,-0.05>}
 #declare i = 0;
 #while (i < 29)
   sphere {<4.4, 0.1 + i*0.2,-0.03>,0.04}
   #declare i = i + 1;
 #end
 }
}

#macro cell_number(cnumber,pos,rot)
 object{ text { ttf "Terminat.ttf"
                cnumber 0.2,0 
                pigment {Black}
		        scale <0.4,0.4,1>
                rotate <0,rot,0>
                translate pos}
}
#end

//############################################################# lamps

/*
#declare lamp_body = object{
 union {
  difference{
   merge{
    cylinder {<0,-0.01,0>,<0,-0.4,0>,0.1}
    torus    {0.08,0.02 translate <0,-0.4,0>}
    cylinder {<0,-0.4,0>,<0,0.42,0>,0.08}
   }
   cylinder {<0,0.01,0>,<0,-0.4,0>,0.08}
  texture{ pigment  {rgbt<0.97,0.97,1,0.95>}
           normal {radial frequency 36}
         }
  interior {ior 1.333}
  }
  cylinder {<0,0,0>,<0,-0.07,0>,0.11 
            texture { pigment{Black}
                      finish {specular 0.9
                              roughness 0.01}
                    }
           }
  difference{
   sphere {<0,-0.4,0>,0.4 pigment{Black}}
   sphere {<0,-0.4,0>,0.38 pigment{White}}
//   cylinder {<0,-0.35,0>,<0,-0.81,0>,0.41 pigment{Black}} OLD_ONE
   cylinder {<0,-0.25,0>,<0,-0.81,0>,0.41 pigment{Black}}
  }  
 }
}

#declare bulb = object{
 merge{
  sphere {0,0.05}
  cone {0,0.05,<0,0.1,0>,0.02}
 }
 texture {pigment{LightYellow} //LightCyan}
          finish {ambient 2.0}
         }
}
*/

// ############################################################ bridge

#declare bridge = object{
 union{
  box{ <0,0,2>,<6,-0.08,200>}
  cylinder {<-0.1, 1.8, 2>,<-0.1, 1.8, 200>, 0.08}
  cylinder {<6.1, 1.8, 2>,<6.1, 1.8, 200>, 0.08}
  cylinder {<-0.1, 1.2, 2>,<-0.1, 1.2, 200>, 0.04}
  cylinder {<6.1, 1.2, 2>,<6.1, 1.2, 200>, 0.04}
  cylinder {<-0.1, 0.6, 2>,<-0.1, 0.6, 200>, 0.04}
  cylinder {<6.1, 0.6, 2>,<6.1, 0.6, 200>, 0.04}
  #declare i=0;
  #while (i<26)
   cylinder {<-0.1, -0.08, i*8>,<-0.1, 1.8, i*8>,0.08}
   cylinder {<6.1, -0.08, i*8>,<6.1, 1.8, i*8>,0.08}
   #declare i = i + 1;
  #end
 }
}

#declare pillars = object{
 union{
  cylinder{<-0.4,-100,0>,<-0.4,100,0>,0.4}
  cylinder{<6.4,-100,0>,<6.4,100,0>,0.4}
  #declare i = 0;
  #while (i<33)
   box{<-0.4, 0, -0.4>,<6.4, -0.2, 0.4> 
       translate <0, -96+i*6, 0 >}
   #declare i = i +1;
  #end
 }
}

// #################################################### tank (reactor)

#macro reactor_head (pos)
 #local bolt = object{
  union{
   sphere {pos+<0,2.07,0>,0.05}
   sphere {pos+<0,2.33,0>,0.05}
   cylinder {pos+<0,2.07,0>,pos+<0,2.33,0>,0.05}
  }
 }
 union{
  cylinder {pos,pos+<0,2,0>,1}
  cylinder {pos+<0,2,0>,pos+<0,2.15,0>,1.4}
  cylinder {pos+<0,2.15,0>,pos+<0,2.25,0>,1.1 pigment{Black}}
  cylinder {pos+<0,2.25,0>,pos+<0,2.40,0>,1.4}
  #local i = 0;
  #while (i<12)
   object{ bolt translate <1.3,0,0> rotate <0,i*30,0>}
   #local i = i + 1;
  #end
 }
#end

#macro reactor(rad,height,lw_point)
 object{
  union{
   sphere{lw_point+<0,rad,0>,rad}
   sphere{lw_point+<0,height-rad,0>,rad}
   cylinder {lw_point+<0,rad,0>,lw_point+<0,height-rad,0>,rad}
   torus{rad,0.1 translate lw_point+<0,rad,0> }
   torus{rad,0.1 translate lw_point+<0,height-rad,0> }
   reactor_head (lw_point + <0,height - 1,0> )
  }
 }
#end

#declare ladder = object{
 union{
  cylinder {<-12,-70,-1>,<-12,10,-1>,0.1}
  cylinder {<-12,-70,1>,<-12,10,1>,0.1}
  #declare i = 0;
  #while (i<101)
   cylinder {<-12,-70+i*0.8,-1>,<-12,-70+i*0.8,1>,0.1}
   #declare i = i + 1;
  #end
  intersection{
   torus {12,0.1 rotate<90,0,0>}
   box {<0,0,-1>,<-15,15,1>}
   translate <0,10,-1>
  }
  intersection{
   torus {12,0.1 rotate <90,0,0>}
   box {<0,0,-1>,<-15,15,1>}
   translate <0,10,1>
  }
  #declare i = 0;
   #while (i<18)
    cylinder{<-12,0,-1>,<-12,0,1>,0.1 
             rotate<0,0,-5 - 5*i> 
             translate <0,10,0>}
    #declare i = i + 1;
   #end
 }
 pigment{Red}
 finish{ambient 2.0}
}

// ############################################################ chain

#declare chain_link = object{
 union{
  difference{
   torus{0.2,0.1}
   box{<0,-1,-1>,<1,1,1>}
  }
  difference{
   torus{0.2,0.1}
   box{<0,-1,-1>,<1,1,12>}
   rotate <0,180,0>
   translate <0.3,0,0>
  }
  cylinder{<0,0,-0.2>, <0.3,0,-0.2>, 0.1}
  cylinder{<0,0,0.2>, <0.3,0,0.2>, 0.1}
  rotate <0,0,90>
 }
}

// ########################################################### valve

#declare valve = object{
 union{
  cylinder{0,<0.8,0,0>,0.24}
  cylinder{<0.4,0,0>,<0.4,0,0.4>,0.24}
  cylinder{<0.4,0,0.4>,<0.4,0,0.44>,0.3} 
  cylinder{<0.4,0,0.445>,<0.4,0,0.455>,0.3} 
  cylinder{<0.4,0,0.455>,<0.4,0,0.48>,0.06} 
  cylinder{<0.4,0,0.47>,<0.4,0,0.6>,0.05 texture{Rust1 translate <4,7,2>}} 
  sphere{0,0.03 scale <2,2,1> translate <0.4,0,0.6>}
  #declare i = 0;
  #while (i<6)
   cylinder {<0,0,0>,<0.2,0,0>,0.015 
             rotate <0,0,i*60>
             translate <0.4,0,0.6>}
   #declare i = i + 1;
  #end
  torus{0.2,0.02 rotate<90,0,0> translate <0.4,0,0.6>} 
 }
}

// ########################################################### scene
// ########################################################### scene
// ########################################################### scene
// -------------------------------------------------- catwalk suspension
#debug "\ncreating catwalk suspensions & light:"
#declare i = 0;
#while (i < 26)
 object{double_t
        texture {Rust1
                 translate <rand(seed1)*10,rand(seed1)*10,rand(seed1)*10>} 
        translate <-10 + i*8,5.98,0>}
 object{double_t
        texture {Rust1
                 translate <rand(seed1)*10,rand(seed1)*10,rand(seed1)*10>} 
        translate <-10 + i*8,-0.02,0>}
 cylinder {<0,0,2.1>,<0,1.8,2.1>,0.08
           texture {Rust2
                    translate <rand(seed1)*10,rand(seed1)*10,rand(seed1)*10>}
           translate <-10 + i*8,-0.02,0>}
 cylinder {<0,0,2.1>,<0,1.8,2.1>,0.08
           texture {Rust2
                    translate <rand(seed1)*10,rand(seed1)*10,rand(seed1)*10>}
           translate <-10 + i*8,5.98,0>}
 #if (mod(i,5)=0)
  object{lamp rotate <0,0,0> translate <-2 + i*8,5.4,-1>}
  object{lamp rotate <0,0,0> translate <-2 + i*8,11.4,-1>}
 #end 
 #declare i = i + 1;
#end

object{
 union{ 
 light_source{
   <0,0,0.05> 
   lightcolor 
   looks_like {object{bulb}}
   fade_distance 8.0
   fade_power 1.4
   media_interaction off
 }
 difference{
  merge{
   cylinder {<0,-0.15,0.05>,<0,0.15,0.05>,0.1}
   sphere{<0,-0.15,0.05>,0.1}
   sphere{<0,0.15,0.05>,0.1}
   cylinder {<0,0.15,0.05>,<0,0.15,0>,0.1}
   cylinder {<0,-0.15,0.05>,<0,-0.15,0>,0.1}
   box {<0.1,-0.15,0>,<-0.1,0.15,0.05>}
  }
  cylinder {<0,-0.15,0.05>,<0,0.15,0.05>,0.09}
  sphere{<0,-0.15,0.05>,0.09}
  sphere{<0,0.15,0.05>,0.09}
  cylinder {<0,0.15,0.05>,<0,0.15,0>,0.09}
  cylinder {<0,-0.15,0.05>,<0,-0.15,0>,0.09}
  box {<0.09,-0.15,0>,<-0.09,0.15,0.05>}
  texture{ pigment  {rgbt<0.97,0.97,1,0.95>}
           normal {radial frequency 36}
         }
  interior {ior 1.333}  
 }
 union{
  cylinder {<0,0.15,0.05>,<0,0.15,0>,0.1}
  cylinder {<0,-0.15,0.05>,<0,-0.15,0>,0.1}
  box {<0.1,-0.15,0>,<-0.1,0.15,0.05>} 
  translate <0,0,-0.05>
  pigment{Black}
//  finish {ambient 1.0}
  }
 }
 rotate <90,0,0> translate <-18,5.5,-1>}

object{lamp rotate <0,0,0> translate <-18,11.5,-1>}

#declare i = 0;
#while (i<50)
 cylinder {<0,0,2.1>,<0,1.8,2.1>,0.08
           texture {Rust2
                    translate <rand(seed1)*10,rand(seed1)*10,rand(seed1)*10>}
           translate <190 + i*8,-0.02,0>}
 #declare i=i+1;
#end

// -------------------------------------------- catwalks

#debug"\ncreating catwalks:"
cylinder {<-10,1.8,2.1>,<400,1.8,2.1>,0.08 
          texture{Rust2}
          translate <0,-0.02,0>}
cylinder {<-10,1.8,2.1>,<400,1.8,2.1>,0.08 
          texture{Rust2}
          translate <0,5.98,0>}

cylinder {<-10,1.2,2.1>,<400,1.6,2.1>,0.04 
          texture{Rust2}
          translate <0,-0.02,0>}

cylinder {<-10,0.6,2.1>,<400,0.8,2.1>,0.04 
          texture{Rust2}
          translate <0,-0.02,0>}

object {gridwalk}
object {gridwalk translate <0,6,0>}
object {gridwalk translate <0,-6,0>}

box {<190,0,2>,<400,-0.2,-4> texture{Rust1}}
box {<190,0+6,2>,<400,-0.2+6,-4> texture{Rust1}}

// -------------------------------------------- doors & wall

#debug"\ncreating doors&walls:"
#declare i = 0;
#while (i < 25)
 object{ door_window 
         texture{Rust1}
         translate <-9.6 + 8*i,0,-3.8>} 
 object{ door 
         translate <-9.6 + 8*i,0,-3.8>
         texture{Rust2 translate <3,7,3.8>}}
 object{ handle
         translate <-9.6 + 8*i,0,-3.8>
         texture{Rust2 translate <1,5,-3.8>}}
 object{ wall_tile
         translate <-9.6 + 8*i,0,-3.8>
         texture{Rust2 
                 translate <rand(seed1)*100,rand(seed1)*100,rand(seed1)*100>}
       }         
 #declare i = i + 1;
#end


#declare p1 = "Z"
#declare p2 = "-3"
#declare fn = 564;
#declare i = 0;
#while (i<20) 
 #declare fn = fn + 1;
 #declare pm = str(fn,3,0)
 #declare cnum = concat(p1,pm,p2)
 cell_number(cnum,<-0.8 + i*8, 4.2, -3.86>,180)
 #declare i = i + 1;
#end

box{<190,0,-4>,<400,8,-4.1> texture{Rust2}}

// ----------------------------------------------- pipe

#debug"\ncreating pipes:"
union{
 cylinder {<-20,5.98-0.7,-3>,<190,5.98-0.7,-3>,0.2
           texture {Rust2 translate <234,4,3>}}
cylinder {<0,-10,-3>,<0,5.98-0.7,-3>,0.2
           texture {Rust2 translate <234,4,3>}}
 #declare i=0;
 #while (i < 26)
  cylinder {<-9.95 + i*8,5.98-0.7,-3>,<-10.05 + i*8,5.98-0.7,-3>,0.3
            texture{Rust1}}
  cylinder {<-9.9 + i*8,5.98-0.7,-3>,<-10.1 + i*8,5.98-0.7,-3>,0.24
            texture{Rust1}}
  cylinder {< -4 + i*8,5.98-0.7,-3>,< -4 + i*8,5.98-0.7,-5>,0.2
            texture{Rust2}}
  #declare i = i +1;
 #end
}

union{ 
 cylinder{<0,0.04,-3>,<0,-0.4,-3>,0.3}
 #declare i = 0;
 #while (i<12)
  sphere {<0.25,0,0>,0.05 
          rotate <0,30*i,0>
          translate <0,0,-3>
          texture{Rust1}}
  #declare i = i + 1;
 #end
 texture {Rust2}
}

object{valve 
       rotate <30,0,0> 
       translate <-4,5.98-0.7,-3>
       texture {Rust1 scale 1}}

object{valve 
       rotate <0,0,90> 
       translate <0,2,-3>
       texture {Rust1 scale 1}}

// ------------------------------------------- bridges

#debug"\ncreating bridges:"
#declare i = 0;
#while (i<18)
 object{ bridge 
         translate <60,-66 + i*6,0>
		 texture{Rusty 
                 translate <rand(seed1)*40,rand(seed1)*40,rand(seed1)*40>}
       }
object {lamp rotate <0,90,0> translate <63,-66.1+i*6,30>}
 #declare i = i + 1;
#end

object{pillars 
       translate <60,0,24>
       texture {Rust2}}

object{pillars 
       translate <60,0,48>
       texture {Rust2}}

// ----------------------------------------- tanks

#debug"\ncreating tanks:"
object{reactor(10,90,<90,-70,20>) texture{Rust2 scale <1,10,1>}}
object{reactor(10,90,<90,-70,45>) texture{Rust2 scale <1,10,1>}}
object{reactor(10,90,<90,-70,70>) texture{Rust2 scale <1,10,1>}}

object {ladder translate <90,0,20> texture {Rust2 translate <234,54,3>}}
object {ladder translate <90,0,45> texture {Rust2 translate <32,65,-7>}}

// ----------------------------------------- chain

#debug"\ncreating chain:"
#declare i = 0;
#while (i<60)
 object{chain_link
        rotate <0,94*i,0> 
        translate <5,10-0.45*i,5>
        texture{Rusty
                translate<30*rand(seed1),30*rand(seed1),30*rand(seed1)>}
       }
 #declare i = i+1;
#end

// ------------------------------------------------------- rats
#debug"\ncreating rats:"


#declare MAX_RATS =  1000;
#declare RAT_BOT = 0.0;
#declare RAT_XMIN = 2.0;
#declare RAT_XDEL = 150.0;
#declare RAT_ZMIN = -3.8;
#declare RAT_ZDEL = 5.6;
#declare RAT_BOUND = 0.5;
#declare RAT_MAINDIR = 180;

#declare RAT_POS = array[MAX_RATS]
#declare RAT_DIR = array[MAX_RATS]

#declare NUM_RATS = 0;
#while ( NUM_RATS < MAX_RATS)
// #debug concat("Rat number: ",str(NUM_RATS,1,0),"\n")
 #declare RAT_POS[NUM_RATS] = <RAT_XMIN + rand(seed1)*RAT_XDEL,
                               RAT_BOT,
                               RAT_ZMIN + rand(seed1)*RAT_ZDEL>;

 #declare TOO_NEAR = false;

 #if(NUM_RATS > 0)
  #declare i = 0;
  #while (i < (NUM_RATS-1))  // check if rat is too near to others
//   #debug concat("check no.: ",str(i,1,0),"\n")
   #declare RAT_DIST = sqrt( pow((RAT_POS[NUM_RATS].x - RAT_POS[i].x),2)
                            +pow((RAT_POS[NUM_RATS].y - RAT_POS[i].y),2)
                            +pow((RAT_POS[NUM_RATS].z - RAT_POS[i].z),2));

   #if (RAT_DIST <= RAT_BOUND)
    #declare TOO_NEAR = true;
    #declare i = NUM_RATS;
    #declare NUM_RATS = NUM_RATS - 1;
   #else
    #declare i = i + 1;
   #end
  #end
 #else
  #declare RAT_DIR[0] = rand(seed1) * 45 - 22.5 + RAT_MAINDIR;
//  #debug concat("set direction of rat number: 0\n") 
 #end

 #if (TOO_NEAR = false)
  #declare RAT_DIR[NUM_RATS] = rand(seed1) * 45 - 22.5 + RAT_MAINDIR;
  #debug concat("rat ",str(NUM_RATS,1,0))
 #end

 #declare NUM_RATS = NUM_RATS + 1;

#end

#declare NUM_RATS = 0;
#while (NUM_RATS < MAX_RATS)
 #declare RAT_TYPE = rand(seed1);
  #if (RAT_TYPE > 0.9)
   object{s_rat rotate <0,RAT_DIR[NUM_RATS],0> translate RAT_POS[NUM_RATS]}
  #else
   object{rat rotate <0,RAT_DIR[NUM_RATS],0> translate RAT_POS[NUM_RATS]}
  #end
 #declare NUM_RATS = NUM_RATS + 1;
#end

box {<145,0,1.8>,<300,0.2,-3.8>
     texture{ leopard texture_map{[0.4 RAT_TEX_B]
                                  [0.6 pigment{rgbt<1,1,1,1>}]}
              turbulence 0.5}
    }


// rats on the pipe

#declare MAX_RATS = 50;
#declare i = 0;
#declare START_RAT = -8.0;

#while (i<MAX_RATS)
 #declare RAT_TYPE = rand(seed1);
 #declare RAT_ROT = rand(seed1) * 359;
 #declare NEXT_RAT = rand(seed1) * 0.5 + 0.5;
 #declare START_RAT = START_RAT + NEXT_RAT;
 #if (RAT_TYPE < 0.9)
  object{rat 
         rotate <0,RAT_ROT,0> 
         translate <START_RAT,5.98 - 0.5,-3>}
 #else
  object{s_rat 
         rotate <0,RAT_ROT,0> 
         translate <START_RAT,5.98 - 0.5,-3>}
 #end
 #declare i = i + 1;
#end

#declare ratfront = array[18][5]
 {
  {-3,0,1.5,10,1},
  {-2.4,0,1,10,2},
  {-2,0,0,7,2},
  {-1,0,1,7,1},
  {-0.5,0,-0.5,-45,1},
  {-1,0,-25,-5,2},
  {-0.9,0,-3,-7,2},
  {0,0,-3.75,0,1},
  {0,0,-2.75,0,1},
  {1,0,-3.6,5,1},
  {-1.2,0,-0.7,-45,1},
  {-0.5,0,-1.5,45,2},
  {-0.4,0,-1,-30,1},
  {0.1,0,1,0,1},
  {1,0,-1,-20,1},
  {1.2,0,-1.8,-5,2},
  {2.1,0,0.4,-2,1},
  {1.5,0.7,-2.5,-45,1}
}

#declare NUM_RATS = 0;
#while (NUM_RATS < 18)
 #if (ratfront[NUM_RATS][4] > 1)
  object{s_rat rotate -y*(ratfront[NUM_RATS][3]+180)
               translate <ratfront[NUM_RATS][0],
                          ratfront[NUM_RATS][1],
                          ratfront[NUM_RATS][2]>}
 #else
  object{rat rotate -y*(ratfront[NUM_RATS][3]+180)
             translate <ratfront[NUM_RATS][0],
                        ratfront[NUM_RATS][1],
                        ratfront[NUM_RATS][2]>}
 #end
 #declare NUM_RATS = NUM_RATS + 1;
#end

// ------------------------------------------------------------ crane

object{Hook scale 0.25 rotate <-90,0,0> translate <25,0,20>}

// ------------------------------------------------------------ shadowcaster

box {0,<1,1,0.0001> pigment{image_map{gif "man.gif"
                                      transmit 1,1.0
                                      transmit 2,1.0}}
     scale <2,4,1>
     translate <-0.5,0,0>
     rotate <0,90,0>
     translate <-10.5,0,0>
    }

// ------------------------------------------------------------ human skull

object{MYSKULL
       rotate <-10,0,0>
       rotate <0,-40,0>
       translate <0,0.75,0>
       scale 0.4
       translate<1.5,0,-2.5>
       texture{
       pigment{PeachPuff4}
       finish{ambient 0.15 
              diffuse 0.65
              specular 0.05 
              roughness 0.05 
              reflection 0.05 }
       normal{crackle scale 0.3 turbulence 0.4 bump_size 0.5}}
      }

// ---------------------------------------------------- spine

object{spine 
       scale 0.4
       rotate <0,0,90>
       rotate <-60,0,0>
       rotate <0,225,0> 
       translate <-1.5,0.2,-0.5>
}
