#declare RAT_TEX_W = texture{
 pigment{Seashell3}
 finish{ambient 0.05
        diffuse 0.3
        reflection 0.3
        specular 0.2
        roughness 0.1}
 normal{bumps scale <0.08,0.02,0.02>}
}

#declare RAT_TEX_B = texture{
 pigment{DarkBrown}   // Burlywood4}
 finish{ambient 0.2
        diffuse 0.3
        reflection 0.01
        specular 0.2
        roughness 0.4
 }
 normal{bumps scale <0.08,0.02,0.02>}
}

#declare ear_angle = 50;

#declare skull = object{
union{
 blob {
  threshold 0.5
  sphere {<0,0,0>,1,2 
          scale <2,1,1.2>} // upper skull
  sphere {<0,0,0>,1,2 
          scale <1.8,0.95,1.1>
          translate <0,-0.3,0>} // lower skull
  sphere {<0,0,0>,0.5,2 
          scale <2,1,1.3> 
          translate <2,-0.2,0>} // front nose
  sphere {<0,0,0>,0.5,2 
          scale <2,1,1.3> 
          translate <1.6,0,0>} //middle nose
  sphere {0,0.4,2 
          scale <2,1,1> 
          translate <1.8,-0.5,0> texture{RAT_TEX_W}} //front lower jar
  sphere {0,0.4,2 
          scale <2,1,1> 
          translate <1.1,-0.5,0> texture{RAT_TEX_W}} //back lower jar
  sphere {0,0.6,2 
          scale <2,1,1.3> 
          translate <1.2,-0.1,0> } // middle upper jar
  sphere {0,0.4,2 
          scale <2,1,1.5> 
          rotate <0,0,-20> 
         translate <1.5,0.2,0>} //back of upper jar
// ---------------------------------------------------- right ear
  sphere {0,1,2 
          scale <0.4,1,1>
          rotate <0,ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,-0.7>} // main ear
  sphere {0,1,-2 
          scale <0.3,0.8,0.8> 
          translate <0.1,0,0>
          rotate <0,ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,-0.7>}    // first groove
  sphere {0,1,-0.5 
          scale <0.4,0.5,0.5> 
          translate <0,-0.2,0>
          rotate <0,ear_angle,0>
 		  scale 0.6
         translate <-0.5,0.5,-0.7>}
  sphere {0,1,-0.25 
          scale <0.4,0.5,0.5> 
          translate <-0.1,0.2,-0.1>
          rotate <0,ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,-0.7>}
  sphere {0,1,-0.25 
          scale <0.4,0.5,0.5> 
          translate <-0.1,0.2,-0.1>
          rotate <0,ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,-0.7>}
  sphere {0,1,-0.25 
          scale <0.4,0.5,0.5> 
          translate <0,-0.2,0>
          rotate <0,ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,-0.7>}
// ------------------------------------------------------ left ear
  sphere {0,1,2 
          scale <0.4,1,1>
		  rotate <180,0,0>
          rotate <0,-ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,0.7>} // main ear
  sphere {0,1,-2 
          scale <0.3,0.8,0.8> 
          translate <0.1,0,0>
		  rotate <180,0,0>
          rotate <0,-ear_angle,0>
 		  scale 0.6
          translate <-0.5,0.5,0.7>}    // first groove
  sphere {0,1,-0.5 
          scale <0.4,0.5,0.5> 
          translate <0,-0.2,0>
		  rotate <180,0,0>
          rotate <0,-ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,0.7>}
  sphere {0,1,-0.25 
          scale <0.4,0.5,0.5> 
          translate <-0.1,0.2,-0.1>
		  rotate <180,0,0>
          rotate <0,-ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,0.7>}
  sphere {0,1,-0.25 
          scale <0.4,0.5,0.5> 
          translate <-0.1,0.2,-0.1>
		  rotate <180,0,0>
          rotate <0,-ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,0.7>}
  sphere {0,1,-0.25 
          scale <0.4,0.5,0.5> 
          translate <0,-0.2,0>
		  rotate <180,0,0>
          rotate <0,-ear_angle,0>
		  scale 0.6
          translate <-0.5,0.5,0.7>}
  }
 sphere{<1.0,0.3,0.5>,0.15 
        pigment {Black}
        finish {specular 0.6
                roughness 0.001
                reflection 0.4
                ambient 0.3
                diffuse 0.1
                metallic 0.5
               }
       }

 sphere{<1.0,0.3,-0.5>,0.15 
        pigment {Black}
        finish {specular 0.6
                roughness 0.001
                reflection 0.01
                ambient 0.0
                diffuse 0.0
                metallic 0.5
               }
       }

 }
 texture{RAT_TEX_B}
}

#declare body = object{
 blob{
  threshold 0.5
  sphere {0,4,2}               // back
  sphere {0,3,2               // middle
          translate <2.5,0,0>}
  sphere {0,2.5,2               // middle
          translate <1.25,0.5,0>}
  sphere {0,3,2               // front
          translate <5,-0.5,0>}
  sphere {0,1.8,2               // neck
          translate <6.3,-0.1,0>}
  sphere {0,1.8,2               // tailbase
          translate <-2,-0.8,0>}
 }
 texture{RAT_TEX_B}
}

#declare forelegs = object{
 blob{
  threshold 0.5 
  cylinder {0,<2,0,0>,0.4,2 rotate <0,0,-10> translate <5.5,-2.2,1.3>} //leg
  cylinder {0,<2,0,0>,0.4,2 rotate <0,0,-10> translate <5.5,-2.2,-1.3>} //leg
 }
 texture{RAT_TEX_B}
}

#declare hindlegs = object{
 blob{
  threshold 0.5 
  cylinder {0,<2.5,0,0>,0.4,2 rotate <0,-5,0> translate <0,-2.3,2>} //leg
  cylinder {0,<2.5,0,0>,0.4,2 rotate <0,5,0> translate <0,-2.3,-2>} //leg
 }
 texture{RAT_TEX_B}
}


#declare tail = object{
 blob{
  threshold 0.5 
  cylinder {0,<2.5,0,0>,0.4,2 rotate <0,0,10> translate <-4.7,-1.7,0>} //tail
  sphere {<-4.7,-1.7,0>,0.5,-1}
  cylinder {0,<2.5,0,0>,0.35,2 rotate <0,0,10> translate <-7,-2.2,0>} //tail
  cylinder {0,<2.5,0,0>,0.3,2 rotate <0,0,10> translate <-9.3,-2.7,0>} //tail
  cylinder {0,<2.5,0,0>,0.25,2 rotate <0,0,5> translate <-11.6,-3,0>} //tail
 }
 texture {RAT_TEX_B}
}


#declare rat = object{
 union{
  object{skull  scale <1.3,1.6,1.6> rotate <0,0,15> translate <7.3,4,0> } 
  object{body scale <0.9,1,1> translate <0,3,0>}
  object{forelegs scale <0.9,1,1> translate <0,3,0>}
  object{hindlegs scale <0.9,1,1> translate <0,3,0>}
  object{tail scale <0.9,1,1> translate <0,3,0>}
 }
  translate <-3.5,0,0>
  scale 0.05 
}

#declare s_rat = object{
 union{
  object{skull  
         scale <1.3,1.6,1.6> 
         rotate <0,0,-35> 
         translate <10.3,1.5,0>
         rotate <0,0,70> } 
  object{body rotate <0,0,70> scale <0.9,1,1> translate <0,3,0>}
  object{forelegs 
         rotate <0,0,-20> 
         scale <0.9,1,1> 
         translate <-1,11,0>}
  object{hindlegs scale <0.9,1,1> translate <0,3,0>}
  object{tail scale <0.9,1,1> translate <-0.5,3,0>}
  scale 0.05
 }
}
