// Persistence of Vision Ray Tracer Scene Description File
// File: classroom.inc
// Vers: 3.1g
// Desc: Classroom Macro include file for Horror.pov
// Date: 10/26/1999 
// Auth: Ray Benjamin 

#ifndef (classroominc)
#declare classroominc = 1;

#include "brickwall.inc"
#include "locker.inc"
#include "chars.inc"


#declare Wall_Thickness = 6*Inch;

///////// Class Room //////////
#declare CR_Width = 30;
#declare CR_Depth = 20;
#declare CR_Height = 10;
#declare Door_Width = 30*Inch;
#declare Door_Height = 7;

// build lockers
#declare LockerRow1 = union {
        MakeLockerRow(0,7,1*Foot,0,0)
        }

#declare LockerRow2 = union {
        MakeLockerRow(0,14,1*Foot,0,0)
        object {ExtinguisherCan translate x*14}
        }

#include "sticker.inc"//hmc 
#include "stuffLocker.inc"//hmc
//#macro sticker(lockerNum, perUp, picForStick, picForStickShape)
#declare MainLockers = union {
    MakeLockerRow(0,5,1*Foot,0,0) // five closed lockers    
      sticker(3, 70, "nra1.tga", "nra1shape.tga")//hmc
    MakeLockerRow(5,1,1*Foot,0,30) // 1 open 30 degrees
    MakeLockerRow(6,1,1*Foot,0,97) // 1 open 90 or so
      object{stuffLocker translate 6*x}//hmc
    MakeLockerRow(7,7,1*Foot,0,0) // seven closed     
      sticker(2,35, "nra2.tga", "nra2shape.tga")//hmc
      sticker(4,75, "hsig.tga", "hsigshape.tga")//hmc 
      #include "banner.inc" //hmc Just isn't working
      object {banner scale <2,2,.1> translate<2,6.25,6*inch> }
    }
            
// locker cut out
#declare Locker_Cutout1 = box {<-.1,0,0>,<7,6,.5> pigment { White }}
#declare Locker_Cutout2 = box {<-.1,0,0>,<15,6,.5> pigment { White }}

#declare Full_Brick_H = Brick_Height + Mortar_Width;
#declare Full_Block_H = Block_Height + Mortar_Width;

#declare BF_Height = Full_Block_H;
#declare BT_Height = 2.5;
#declare BW_Height = (int((HW_Height-BF_Height-BT_Height)/Full_Brick_H)+1)*Full_Brick_H;

#declare Brick_Wall = object {
    MakeBrickWall(Brick_Width,Brick_Height,Brick_Depth,T_Brick,Mortar_Width,T_Mortar,CR_Width,BW_Height,7*Inch)
    }

#declare Block_Foundation = object {
    MakeBrickWall(Block_Width,Block_Height,Block_Depth,T_Block,Mortar_Width,T_Mortar,CR_Width,BF_Height,7*Inch)
    }

#declare Block_Top = object {
    MakeBrickWall(Block_Width,Block_Height,Block_Depth,T_Block,Mortar_Width,T_Mortar,CR_Width,BT_Height,7*Inch)
    }

#declare Hall_Wall = union {
    object {Block_Foundation}
    object {Brick_Wall translate <0,BF_Height,0>}
    object {Block_Top translate <0,BF_Height+BW_Height,0>}
    }
    
#declare T_CR_Floor = texture {
    pigment {Gray90}
    }
    
#declare T_CR_Ceiling = texture {
    pigment {White}
    }    

#declare T_CR_Wall = texture {
    pigment { rgb <0.882,0.812,0.376> }
    }
    
#include "hdoor.inc"

#declare Door_Offset = CR_Width/3;

#macro makeClassRoom(objLockerRow1,objLockerRow2,angDoorOpenAngle,objName,lighton)
  union {
    difference {
        object {Hall_Wall}
        // cut out door
        box {<Door_Offset,0,-.1>,<Door_Offset+TotalFrameWidth,TotalFrameHeight,Wall_Thickness+.1>}
        // cutout lockers
        object {Locker_Cutout1 translate <1,0,-Inch/4>}
        object {Locker_Cutout2 translate <CR_Width/3+4*Foot,0,-Inch/4>}
        }
    difference {
        box {<0,0,0>,<CR_Width,CR_Height,CR_Depth>}
        box {<Wall_Thickness,-.1,-.1>, <CR_Width-Wall_Thickness,CR_Height+.1,CR_Depth-Wall_Thickness>}
        texture {T_CR_Wall}
        }
    // install lockers
    object {objLockerRow1 rotate <0,0,0> translate <1,0,-6.25*Inch>}
    object {objLockerRow2 rotate <0,0,0> translate <CR_Width/3+4*Foot,0,-6.25*Inch>}
    // floor
    box {<0,-.1,0>,<CR_Width,0,CR_Depth> texture {T_CR_Floor}}
    // ceiling
    box {<0,0,0>, <CR_Width,.1,CR_Depth> texture {T_CR_Ceiling} translate <0,CR_Height,0>}
    // make door and frame
    object {
        makeDoor(angDoorOpenAngle,objName)
        translate Door_Offset*x
        }
    // light
    #if (lighton = 1)
        light_source { 0 White fade_power 2 fade_distance 10 translate <CR_Width/2,CR_Height-1,CR_Depth/2>}
    #end
    }
#end // macro

#declare Name301 = union {
    #local cw = 5;
    object {char_3}
    object {char_0 translate cw*1*x}
    object {char_1 translate cw*2*x}
    translate -(3*cw)/2*x
    scale <1/30,1/30,.001>
    pigment {Black}    
    }

// make normal classroom
#declare ClassRoom301 = object {
    makeClassRoom(object {LockerRow1},object{LockerRow2},0,object{Name301},1)
    }

#declare ClassRoom = object {
    makeClassRoom(object {LockerRow1},object{LockerRow2},0,object{Name301},0)
    }

// make library
#declare LibraryName = union {
    #local cw = 5;
    object {char_L}
    object {char_I translate cw*1*x}
    object {char_B translate cw*2*x}
    object {char_R translate cw*3*x}
    object {char_A translate cw*4*x}
    object {char_R translate cw*5*x}
    object {char_Y translate cw*6*x}
    translate -(7*cw)/2*x
    scale <1/30,1/30,.001>
    pigment {Black}
    }

#declare R1 = seed(1);
#declare True = 1;
#declare False = 0;
#declare NumBooks=60;
#declare RowLength = 10;
#declare Titles=False;

#declare T_Shelf = texture {
    pigment {Gray50}
    finish {Dull}
    }
    
#declare Book_Shelf = box {<.01,0,0>, <RowLength+.1-.01,Inch,.9> texture {T_Shelf}}

#declare Book_Shelves = union {
    box { <0,.5,.8>, <RowLength+.22,4,.9> texture {T_Shelf}}
    box { <0,0,0>, <.1,4,.9> texture {T_Shelf}}
    box { <RowLength+.01,0,0>, <RowLength+.11,4,.9> texture {T_Shelf}}
    object { Book_Shelf translate <0,.5,0> }
    object { Book_Shelf translate <0,1.5,0> }
    object { Book_Shelf translate <0,2.5,0> }
    object { Book_Shelf translate <0,3.5,0> }
    object { Book_Shelf translate <0,4.5,0> }
    object { Book_Shelf translate <0,5.5,0> }
    object { Book_Shelf translate <0,6.5,0> }
    object { Book_Shelf translate <0,7.5,0> }

    #declare shelf_count = 0;
    #declare num_shelves = 8;
    #while (shelf_count < num_shelves)

       #declare StackStyle=0;
       #declare Y_pos = (.5 + Inch + 1*shelf_count);
       object { #include "Books.inc" translate <.1,Y_pos, .1>}

       #declare shelf_count = shelf_count + 1;
    #end
    }

#declare BookDetector = union {
    #local ht = 3;
    #local wd = 1;
    #local dp = 1*Inch;
    #local BDSide = union {
        box {<0,0,0>, <wd,ht,dp>}
        cylinder {<0,0,0>, <0,0,dp>, wd/2 translate <wd/2,ht,0>}
        box {<0,0,0>, <wd,wd/2,wd/2> translate <0,0,dp>}
        rotate -90*y
        }
    object {BDSide}
    object {BDSide rotate 180*y translate <3.25,0,wd>}
    texture {
        pigment { color rgb <1,.8,.4> }    
        normal { bumps .01 }
        }
    }

#declare Counter = union {
    #local CW = 6;
    #local CH = 3.5;
    #local CD = 28*Inch;
    
    box {<0,0,0>, <CW,CH,CD> texture {DMFWood6 rotate 90*x}}
    box {<0,0,-1*Inch>,<CW+1*Inch,1*Inch,CD+1*Inch> texture {DMFWood6} translate y*CH}
    }

           
#declare Library = union {
    makeClassRoom(object{LockerRow1},object{MainLockers},45,object{LibraryName},1)
    // put in a book shelf
    object {Book_Shelves rotate -90*y translate <3,0,1>}
    // Add check out counter
    object {Counter rotate -90*y translate <Door_Offset-1,0,1>}
    // put book detector just inside door
    object {BookDetector translate <Door_Offset-.125,0,1>}
    }

#end // include file