//          File: floorclutter.inc
//       Version: 3.1g
//   Description: Some open books, a foler  and a gymbag
//       Created: 10/30/1999 
// Last Modified: 10/30/1999 
//        Author: Heather Cousineau, Copyright 1999, all rights reserved.       

// EXAMPLE:
// object {floorclutter}   

   #include "paper.inc"
   #include "bookrevamp.inc"
   #include "folderQ.inc"         
   #include "gymbag.inc"            
   #include "closedSpiralNotebook.inc"   
   #include "shell.inc"
//#declare floorclutter = union
// Folder with paper flying out
   #declare scatteredPaperInFolder = union {
      object{openFolder texture{pigment{Blue} finish{phong 60}}}     
      
      #declare chVar = 0;
      #declare inc = 10;
      
      #while(chVar < 1)
         object{paper(0,1,1,0,"nothing.gif") rotate <0,chVar*360,0> translate <.4,.01+chVar/inc,chVar*2>}
         #declare chVar = chVar + 1/inc;
      #end
      object{paper(0,1,1,1,"mathnotes.gif") rotate <0,chVar*360,0> translate <.4,.02+chVar/inc,chVar*2>}
   } object {scatteredPaperInFolder rotate 2*x translate <-1,0,3>}

// flat open book
   #declare bookCoverTexture = texture { pigment {Sienna} normal{crackle .1 scale .07}} 
   object{
    openBook (0, 180,         // numPgs,      degreesOpen,              
              75,  50,         // flatPagesBack, flatPagesCover          
   	   	     2,   2,         // windStrength, chaosOfWind,           
   	   	   .03, .25,  	      // thickOfCover, roundOfCover,          
   	   	     1,   1,         // heightOfBook, widthOfBook            
   	   		 pigment{White},  // pagesTexture                       
   	   		 bookCoverTexture,  // frontCoverTexture,                 
   	   		   0,             // useCoverPic                          
   	   		   "none",        // frontCoverPic,                       
   	   		 bookCoverTexture,   // backCoverTexture                  
   	   		 bookCoverTexture,   // bindingCoverTexture)              
   	   		 0)  // spiral (0=normal 1=spiral)                        
   	   		 rotate 48*y
   	   		 translate <1,.1,12>
   } 
//open book with pages flying   
   #declare bookCoverTexture = texture { pigment {SemiSweetChoc} normal{crackle .1 scale .07}} 
   object{
    openBook (7, 180,         // numPgs,      degreesOpen,              
              25,  20,         // flatPagesBack, flatPagesCover          
   	   	     2,   2,         // windStrength, chaosOfWind,           
   	   	   .03, .25,  	      // thickOfCover, roundOfCover,          
   	   	     1,   1,         // heightOfBook, widthOfBook            
   	   		 pigment{White},  // pagesTexture                       
   	   		 bookCoverTexture,  // frontCoverTexture,                 
   	   		   0,             // useCoverPic                          
   	   		   "none",        // frontCoverPic,                       
   	   		 bookCoverTexture,   // backCoverTexture                  
   	   		 bookCoverTexture,   // bindingCoverTexture)              
   	   		 0)  // spiral (0=normal 1=spiral)                        
   	   		 rotate 80*y
   	   		 translate <3,.1,6>
   }     
// closed spiral notebook
   object{closedSpiralNotebook scale 2 rotate <0,15,-5> translate<-4,-1*inch,6>}  
// red gymbag in the distance
   object{gymBag1 rotate -210*y translate <0,0,20>}
// crumpled paper
   object{paper(1,1,0,0,"none") translate <1,3.6*inch,2>}


// Bullet shells scattered randomly down the hall (random numbers generated
// with a TI-89 calculator to acheive correct results quickly 
   #declare dX = 5;
   #declare dZ = 40; 
   #declare dY = 360;
   object{shell(9,T_Copper_3A) rotate .771*dY*y translate <.901*dX,0,.395*dZ> } 
   object{shell(9,T_Copper_3A) rotate .092*dY*y translate <.461*dX,0,.474*dZ> } 
   object{shell(9,T_Copper_3A) rotate .235*dY*y translate <.100*dX,0,.869*dZ> } 
   object{shell(9,T_Copper_3A) rotate .080*dY*y translate <.435*dX,0,.896*dZ> } 
   object{shell(9,T_Copper_3A) rotate .370*dY*y translate <.103*dX,0,.282*dZ> } 
   object{shell(9,T_Copper_3A) rotate .848*dY*y translate <.418*dX,0,.463*dZ> } 
   object{shell(9,T_Copper_3A) rotate .467*dY*y translate <.687*dX,0,.680*dZ> } 
   object{shell(9,T_Copper_3A) rotate .818*dY*y translate <.626*dX,0,.274*dZ> } 
   object{shell(9,T_Copper_3A) rotate .780*dY*y translate <.383*dX,0,.662*dZ> } 
   object{shell(9,T_Copper_3A) rotate .370*dY*y translate <.326*dX,0,.681*dZ> } 
   object{shell(9,T_Copper_3A) rotate .013*dY*y translate <.376*dX,0,.282*dZ> } 
   object{shell(9,T_Copper_3A) rotate .396*dY*y translate <.246*dX,0,.376*dZ> } 
   object{shell(9,T_Copper_3A) rotate .302*dY*y translate <.586*dX,0,.362*dZ> } 
   object{shell(9,T_Copper_3A) rotate .661*dY*y translate <.547*dX,0,.860*dZ> } 
   object{shell(9,T_Copper_3A) rotate .572*dY*y translate <.272*dX,0,.128*dZ> } 
   object{shell(9,T_Copper_3A) rotate .700*dY*y translate <.697*dX,0,.612*dZ> } 
   object{shell(9,T_Copper_3A) rotate .195*dY*y translate <.419*dX,0,.904*dZ> } 
   object{shell(9,T_Copper_3A) rotate .809*dY*y translate <.488*dX,0,.248*dZ> } 
   object{shell(9,T_Copper_3A) rotate .313*dY*y translate <.566*dX,0,.194*dZ> } 
   object{shell(9,T_Copper_3A) rotate .495*dY*y translate <.271*dX,0,.435*dZ> } 

    
//}//floorclutter