//          File: sticker.inc * MUST be used with Ray Benjamin's locker.inc
//       Version: 3.1g
//   Description: a sticker to put on the lockers
//       Created: 10/31/1999 
// Last Modified: 10/31/1999 
//        Author: Heather Cousineau, Copyright 1999, all rights reserved.


#include "paper.inc"   
#include "coathanger.inc"  
#include "closedSpiralNotebook.inc"
#include "gymBag.inc"

#declare stuffLocker = union
{
   #macro makePaperStack()
      #declare ctr = 0;
      #declare forRandSeed = 100000;
      
      #while(ctr < 100)
         #declare xRand   = (rand(seed(forRandSeed))-.5)/10;
         #declare zRand   = (rand(seed(forRandSeed+1))-.5)/10;
         #declare rotRand = 0;//(rand(seed(forRandSeed+2))-.5);
      
         object{
            paper(0,1,1,1,"mathnotes.gif") 
            rotate (-90+rotRand)*y  
            translate <(1-inch/2)+xRand,(5+ctr*.001+inch),(1.5*inch)+zRand>
         }
         #declare ctr = ctr + 1; 
         #declare forRandSeed = forRandSeed + 3;
      #end
   #end            
   
   makePaperStack()
   MakeLockerRow(0,1,1*Foot,0,97)
   object{coatHanger((1/8),T_Copper_4B) rotate -55*y translate <.2,(4.8-8*inch),-.1> }
   object{closedSpiralNotebook  rotate <112,-120,180> translate <2*inch, 5+inch, 0>}
   object{gymBag2 rotate<90,180,0> translate <6*inch,1+7*inch,12*inch>}
}