// ********  MATERIALS  *******

#include "bflyes.inc"

// ********  REFERENCED OBJECTS  *******

#declare TraSwp001 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  43  // control points
  <0.123198, 0.510121>,
  <0.061083, 0.518192>,
  <0.029345, 0.220612>,
  <0.05433, -0.083523>,
  <0.056565, -0.464361>,
  <0.013873, -0.616143>,
  <0.044083, -0.790534>,
  <0.112897, -0.88851>,
  <0.211677, -0.903912>,
  <0.344526, -0.949545>,
  <0.442903, -0.88529>,
  <0.52799, -0.881935>,
  <0.623637, -0.84682>,
  <0.689076, -0.848425>,
  <0.76617, -0.792732>,
  <0.820077, -0.773015>,
  <0.897584, -0.709802>,
  <0.918349, -0.678698>,
  <0.969687, -0.618587>,
  <0.980953, -0.525797>,
  <1.012177, -0.459709>,
  <0.999104, -0.357083>,
  <1.009775, -0.242907>,
  <0.971873, -0.133321>,
  <0.986204, -0.127991>,
  <1.092061, -0.1182>,
  <1.248782, 0.021732>,
  <1.306877, 0.185432>,
  <1.395977, 0.395467>,
  <1.481165, 0.491013>,
  <1.547208, 0.52977>,
  <1.564178, 0.602096>,
  <1.581237, 0.793106>,
  <1.449279, 0.921099>,
  <1.083591, 0.938176>,
  <0.902787, 0.920644>,
  <0.627633, 0.831789>,
  <0.408844, 0.734027>,
  <0.284057, 0.657665>,
  <0.170344, 0.555665>,
  <0.123198, 0.510121>,
  <0.061083, 0.518192>,
  <0.029345, 0.220612>
  rotate -x*90
  material {
    WINGTEX01
    scale <-1.6, 1.9, 15.7>
    translate <1.600000, -0.950000, -0.600000>
  }
  scale <4.0, 4.0, 0.05>
  rotate -15.0*y
  translate  <0.05, -0.65, 0.2>
}
#declare TraSwp2 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  39  // control points
  <-0.123935, 0.52486>,
  <-0.064338, 0.476968>,
  <-0.029345, 0.220612>,
  <-0.05433, -0.083523>,
  <-0.056565, -0.464361>,
  <-0.025806, -0.616143>,
  <-0.058186, -0.792703>,
  <-0.119406, -0.893935>,
  <-0.245285, -0.91181>,
  <-0.351117, -0.946291>,
  <-0.442903, -0.88529>,
  <-0.546433, -0.856983>,
  <-0.646182, -0.795471>,
  <-0.709061, -0.782061>,
  <-0.771883, -0.725577>,
  <-0.858389, -0.674227>,
  <-0.92272, -0.591479>,
  <-0.980953, -0.525797>,
  <-1.006753, -0.460794>,
  <-1.035811, -0.293796>,
  <-1.015266, -0.14417>,
  <-1.049124, -0.13016>,
  <-1.126919, -0.103914>,
  <-1.246492, 0.024023>,
  <-1.33591, 0.275352>,
  <-1.401136, 0.395467>,
  <-1.473529, 0.496358>,
  <-1.539839, 0.515768>,
  <-1.564178, 0.602096>,
  <-1.579026, 0.774682>,
  <-1.4406, 0.912421>,
  <-1.085014, 0.944808>,
  <-0.825258, 0.89187>,
  <-0.627633, 0.831789>,
  <-0.408844, 0.739451>,
  <-0.160232, 0.583093>,
  <-0.123935, 0.52486>,
  <-0.064338, 0.476968>,
  <-0.029345, 0.220612>
  rotate -x*90
  material {
    WINGTEX01
    scale <1.6, 1.9, 15.7>
    translate <-1.600000, -0.950000, -0.350000>
  }
  scale <4.0, 4.0, 0.05>
  rotate 15.0*y
  translate  <-0.05, -0.55, 0.2>
}
#declare KRILA = union {
  object { TraSwp001 }
  object { TraSwp2 }
}
#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.115219, 1.670790, 0.034621>, <-0.115032, 1.669676, 0.042849>, <-0.048189, 1.659758, 0.082220>, <-0.014916, 1.657748, 0.080842>, 
      <-0.123188, 1.694101, 0.048147>, <-0.123001, 1.692987, 0.056375>, <-0.048847, 1.681331, 0.072761>, <-0.015574, 1.679320, 0.071383>, 
      <-0.122171, 1.768439, 0.077004>, <-0.122237, 1.765528, 0.086243>, <-0.055386, 1.748574, 0.033968>, <-0.016581, 1.746132, 0.032474>, 
      <-0.141783, 1.748492, 0.079707>, <-0.141849, 1.745581, 0.088946>, <-0.055913, 1.732098, 0.050807>, <-0.017108, 1.729656, 0.049312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.017138, 1.670964, -0.016805>, <-0.050273, 1.672966, -0.015433>, <-0.115405, 1.671899, 0.026427>, <-0.115219, 1.670790, 0.034621>, 
      <-0.016999, 1.694298, -0.015142>, <-0.050134, 1.696300, -0.013770>, <-0.123375, 1.695210, 0.039953>, <-0.123188, 1.694101, 0.048147>, 
      <-0.016597, 1.759549, 0.009486>, <-0.062877, 1.762461, 0.011269>, <-0.122092, 1.771911, 0.065986>, <-0.122171, 1.768439, 0.077004>, 
      <-0.016674, 1.748743, -0.011262>, <-0.062954, 1.751656, -0.009479>, <-0.141704, 1.751964, 0.068689>, <-0.141783, 1.748492, 0.079707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.081730, 1.658891, 0.026465>, <0.081547, 1.659979, 0.018430>, <0.015354, 1.669001, -0.018151>, <-0.017138, 1.670964, -0.016805>, 
      <0.096602, 1.680615, 0.039282>, <0.096419, 1.681703, 0.031247>, <0.015493, 1.692335, -0.016488>, <-0.016999, 1.694298, -0.015142>, 
      <0.109001, 1.749795, 0.064931>, <0.109087, 1.753596, 0.052870>, <0.034065, 1.756361, 0.007534>, <-0.016597, 1.759549, 0.009486>, 
      <0.131304, 1.731306, 0.069188>, <0.131390, 1.735107, 0.057126>, <0.033988, 1.745555, -0.013214>, <-0.016674, 1.748743, -0.011262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.081730, 1.658891, 0.026465>, <0.096602, 1.680615, 0.039282>, <0.109001, 1.749795, 0.064931>, <0.131304, 1.731306, 0.069188>, 
      <0.081917, 1.657780, 0.034671>, <0.096789, 1.679505, 0.047487>, <0.108924, 1.746434, 0.075598>, <0.131228, 1.727945, 0.079854>, 
      <0.018265, 1.655743, 0.079468>, <0.017607, 1.677316, 0.070009>, <0.028220, 1.743313, 0.030748>, <0.027694, 1.726836, 0.047586>, 
      <-0.014916, 1.657748, 0.080842>, <-0.015574, 1.679320, 0.071383>, <-0.016581, 1.746132, 0.032474>, <-0.017108, 1.729656, 0.049312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.043424, 1.751922, 0.162069>, <0.043424, 1.733867, 0.112735>, <0.082459, 1.698045, 0.078242>, <0.128333, 1.674003, 0.087041>, 
      <0.043424, 1.769977, 0.211403>, <0.043424, 1.751922, 0.162069>, <0.102919, 1.732475, 0.065641>, <0.148793, 1.708433, 0.074440>, 
      <0.082459, 1.764883, 0.260869>, <0.102919, 1.799313, 0.248268>, <0.103371, 1.665418, 0.193727>, <0.103371, 1.650988, 0.154298>, 
      <0.128333, 1.740841, 0.269668>, <0.148793, 1.775271, 0.257067>, <0.103371, 1.679848, 0.233156>, <0.103371, 1.665418, 0.193727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.043424, 1.751922, 0.162069>, <0.043424, 1.733867, 0.112735>, <0.082459, 1.698045, 0.078242>, <0.128333, 1.674003, 0.087041>, 
      <0.043424, 1.769977, 0.211403>, <0.043424, 1.751922, 0.162069>, <0.056858, 1.654965, 0.094009>, <0.102733, 1.630923, 0.102808>, 
      <0.082459, 1.764883, 0.260869>, <0.056858, 1.721803, 0.276636>, <0.080948, 1.627685, 0.207537>, <0.080948, 1.609630, 0.158203>, 
      <0.128333, 1.740841, 0.269668>, <0.102733, 1.697761, 0.285435>, <0.080948, 1.645740, 0.256871>, <0.080948, 1.627685, 0.207537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.043424, 1.751922, 0.162069>, <0.043424, 1.769977, 0.211403>, <0.082459, 1.764883, 0.260869>, <0.128333, 1.740841, 0.269668>, 
      <0.043424, 1.751922, 0.162069>, <0.017823, 1.726897, 0.227170>, <0.056858, 1.721803, 0.276636>, <0.102733, 1.697761, 0.285435>, 
      <0.043424, 1.751922, 0.162069>, <0.017823, 1.726897, 0.227170>, <0.035073, 1.669782, 0.248073>, <0.080948, 1.645740, 0.256871>, 
      <0.043424, 1.751922, 0.162069>, <0.017823, 1.708842, 0.177836>, <0.035073, 1.651727, 0.198738>, <0.080948, 1.627685, 0.207537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.043424, 1.751922, 0.162069>, <0.043424, 1.733867, 0.112735>, <0.082459, 1.698045, 0.078242>, <0.128333, 1.674003, 0.087041>, 
      <0.043424, 1.751922, 0.162069>, <0.017823, 1.690786, 0.128502>, <0.056858, 1.654965, 0.094009>, <0.102733, 1.630923, 0.102808>, 
      <0.043424, 1.751922, 0.162069>, <0.017823, 1.690786, 0.128502>, <0.035073, 1.633671, 0.149404>, <0.080948, 1.609630, 0.158203>, 
      <0.043424, 1.751922, 0.162069>, <0.017823, 1.708842, 0.177836>, <0.035073, 1.651727, 0.198738>, <0.080948, 1.627685, 0.207537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.043424, 1.751922, 0.162069>, <0.043424, 1.733867, 0.112735>, <0.082459, 1.698045, 0.078242>, <0.128333, 1.674003, 0.087041>, 
      <0.043424, 1.751922, 0.162069>, <0.063884, 1.768297, 0.100133>, <0.102919, 1.732475, 0.065641>, <0.148793, 1.708433, 0.074440>, 
      <0.043424, 1.751922, 0.162069>, <0.063884, 1.768297, 0.100133>, <0.066707, 1.670202, 0.147266>, <0.103371, 1.650988, 0.154298>, 
      <0.043424, 1.751922, 0.162069>, <0.063884, 1.786352, 0.149468>, <0.066707, 1.684633, 0.186695>, <0.103371, 1.665418, 0.193727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.043424, 1.751922, 0.162069>, <0.063884, 1.786352, 0.149468>, <0.066707, 1.684633, 0.186695>, <0.103371, 1.665418, 0.193727>, 
      <0.017823, 1.708842, 0.177836>, <0.038284, 1.743272, 0.165235>, <0.066707, 1.670202, 0.147266>, <0.103371, 1.650988, 0.154298>, 
      <0.035073, 1.651727, 0.198738>, <0.035073, 1.633671, 0.149404>, <0.123193, 1.665353, 0.090207>, <0.148793, 1.708433, 0.074440>, 
      <0.080948, 1.627685, 0.207537>, <0.080948, 1.609630, 0.158203>, <0.102733, 1.630923, 0.102808>, <0.128333, 1.674003, 0.087041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.043424, 1.751922, 0.162069>, <0.043424, 1.769977, 0.211403>, <0.082459, 1.764883, 0.260869>, <0.128333, 1.740841, 0.269668>, 
      <0.043424, 1.751922, 0.162069>, <0.063884, 1.804408, 0.198802>, <0.102919, 1.799313, 0.248268>, <0.148793, 1.775271, 0.257067>, 
      <0.043424, 1.751922, 0.162069>, <0.063884, 1.804408, 0.198802>, <0.066707, 1.699063, 0.226124>, <0.103371, 1.679848, 0.233156>, 
      <0.043424, 1.751922, 0.162069>, <0.063884, 1.786352, 0.149468>, <0.066707, 1.684633, 0.186695>, <0.103371, 1.665418, 0.193727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.043424, 1.751922, 0.162069>, <0.017823, 1.708842, 0.177836>, <0.035073, 1.651727, 0.198738>, <0.080948, 1.627685, 0.207537>, 
      <0.063884, 1.786352, 0.149468>, <0.038284, 1.743272, 0.165235>, <0.035073, 1.669782, 0.248073>, <0.080948, 1.645740, 0.256871>, 
      <0.066707, 1.684633, 0.186695>, <0.066707, 1.699063, 0.226124>, <0.123193, 1.732191, 0.272834>, <0.102733, 1.697761, 0.285435>, 
      <0.103371, 1.665418, 0.193727>, <0.103371, 1.679848, 0.233156>, <0.148793, 1.775271, 0.257067>, <0.128333, 1.740841, 0.269668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.213243, 1.680979, 0.243974>, <0.174207, 1.716799, 0.278467>, <0.128333, 1.740841, 0.269668>, 
      <0.213243, 1.644869, 0.145306>, <0.213243, 1.662924, 0.194640>, <0.148607, 1.673720, 0.294233>, <0.102733, 1.697761, 0.285435>, 
      <0.174207, 1.649962, 0.095840>, <0.148607, 1.606881, 0.111607>, <0.080948, 1.627685, 0.207537>, <0.080948, 1.645740, 0.256871>, 
      <0.128333, 1.674003, 0.087041>, <0.102733, 1.630923, 0.102808>, <0.080948, 1.609630, 0.158203>, <0.080948, 1.627685, 0.207537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.213243, 1.680979, 0.243974>, <0.174207, 1.716799, 0.278467>, <0.128333, 1.740841, 0.269668>, 
      <0.213243, 1.644869, 0.145306>, <0.213243, 1.662924, 0.194640>, <0.194668, 1.751230, 0.265865>, <0.148793, 1.775271, 0.257067>, 
      <0.174207, 1.649962, 0.095840>, <0.194668, 1.684392, 0.083238>, <0.103371, 1.665418, 0.193727>, <0.103371, 1.679848, 0.233156>, 
      <0.128333, 1.674003, 0.087041>, <0.148793, 1.708433, 0.074440>, <0.103371, 1.650988, 0.154298>, <0.103371, 1.665418, 0.193727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.213243, 1.644869, 0.145306>, <0.174207, 1.649962, 0.095840>, <0.128333, 1.674003, 0.087041>, 
      <0.233704, 1.697355, 0.182039>, <0.233704, 1.679299, 0.132704>, <0.128333, 1.674003, 0.087041>, <0.082459, 1.698045, 0.078242>, 
      <0.140035, 1.646203, 0.200759>, <0.103371, 1.665418, 0.193727>, <0.063884, 1.768297, 0.100133>, <0.043424, 1.733867, 0.112735>, 
      <0.103371, 1.665418, 0.193727>, <0.066707, 1.684633, 0.186695>, <0.063884, 1.786352, 0.149468>, <0.043424, 1.751922, 0.162069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.233704, 1.697355, 0.182039>, <0.140035, 1.646203, 0.200759>, <0.103371, 1.665418, 0.193727>, 
      <0.213243, 1.680979, 0.243974>, <0.233704, 1.715410, 0.231373>, <0.103371, 1.665418, 0.193727>, <0.066707, 1.684633, 0.186695>, 
      <0.174207, 1.716799, 0.278467>, <0.128333, 1.740841, 0.269668>, <0.063884, 1.804408, 0.198802>, <0.063884, 1.786352, 0.149468>, 
      <0.128333, 1.740841, 0.269668>, <0.082459, 1.764883, 0.260869>, <0.043424, 1.769977, 0.211403>, <0.043424, 1.751922, 0.162069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.233704, 1.697355, 0.182039>, <0.140035, 1.646203, 0.200759>, <0.103371, 1.665418, 0.193727>, 
      <0.213243, 1.662924, 0.194640>, <0.233704, 1.679299, 0.132704>, <0.140035, 1.631773, 0.161330>, <0.103371, 1.650988, 0.154298>, 
      <0.213243, 1.662924, 0.194640>, <0.233704, 1.679299, 0.132704>, <0.194668, 1.684392, 0.083238>, <0.148793, 1.708433, 0.074440>, 
      <0.213243, 1.662924, 0.194640>, <0.213243, 1.644869, 0.145306>, <0.174207, 1.649962, 0.095840>, <0.128333, 1.674003, 0.087041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.213243, 1.680979, 0.243974>, <0.174207, 1.716799, 0.278467>, <0.128333, 1.740841, 0.269668>, 
      <0.213243, 1.662924, 0.194640>, <0.233704, 1.715410, 0.231373>, <0.194668, 1.751230, 0.265865>, <0.148793, 1.775271, 0.257067>, 
      <0.213243, 1.662924, 0.194640>, <0.233704, 1.715410, 0.231373>, <0.140035, 1.660634, 0.240188>, <0.103371, 1.679848, 0.233156>, 
      <0.213243, 1.662924, 0.194640>, <0.233704, 1.697355, 0.182039>, <0.140035, 1.646203, 0.200759>, <0.103371, 1.665418, 0.193727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.213243, 1.644869, 0.145306>, <0.174207, 1.649962, 0.095840>, <0.128333, 1.674003, 0.087041>, 
      <0.187642, 1.619844, 0.210407>, <0.187642, 1.601788, 0.161073>, <0.128333, 1.674003, 0.087041>, <0.082459, 1.698045, 0.078242>, 
      <0.126823, 1.603643, 0.216336>, <0.080948, 1.627685, 0.207537>, <0.017823, 1.690786, 0.128502>, <0.043424, 1.733867, 0.112735>, 
      <0.080948, 1.627685, 0.207537>, <0.035073, 1.651727, 0.198738>, <0.017823, 1.708842, 0.177836>, <0.043424, 1.751922, 0.162069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.213243, 1.680979, 0.243974>, <0.174207, 1.716799, 0.278467>, <0.128333, 1.740841, 0.269668>, 
      <0.187642, 1.619844, 0.210407>, <0.187642, 1.637899, 0.259741>, <0.128333, 1.740841, 0.269668>, <0.082459, 1.764883, 0.260869>, 
      <0.126823, 1.603643, 0.216336>, <0.080948, 1.627685, 0.207537>, <0.017823, 1.726897, 0.227170>, <0.043424, 1.769977, 0.211403>, 
      <0.080948, 1.627685, 0.207537>, <0.035073, 1.651727, 0.198738>, <0.017823, 1.708842, 0.177836>, <0.043424, 1.751922, 0.162069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.213243, 1.680979, 0.243974>, <0.174207, 1.716799, 0.278467>, <0.128333, 1.740841, 0.269668>, 
      <0.213243, 1.662924, 0.194640>, <0.187642, 1.637899, 0.259741>, <0.148607, 1.673720, 0.294233>, <0.102733, 1.697761, 0.285435>, 
      <0.213243, 1.662924, 0.194640>, <0.187642, 1.637899, 0.259741>, <0.126823, 1.621699, 0.265670>, <0.080948, 1.645740, 0.256871>, 
      <0.213243, 1.662924, 0.194640>, <0.187642, 1.619844, 0.210407>, <0.126823, 1.603643, 0.216336>, <0.080948, 1.627685, 0.207537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.233704, 1.697355, 0.182039>, <0.140035, 1.646203, 0.200759>, <0.103371, 1.665418, 0.193727>, 
      <0.187642, 1.619844, 0.210407>, <0.208103, 1.654275, 0.197806>, <0.140035, 1.660634, 0.240188>, <0.103371, 1.679848, 0.233156>, 
      <0.126823, 1.603643, 0.216336>, <0.126823, 1.621699, 0.265670>, <0.123193, 1.732191, 0.272834>, <0.148793, 1.775271, 0.257067>, 
      <0.080948, 1.627685, 0.207537>, <0.080948, 1.645740, 0.256871>, <0.102733, 1.697761, 0.285435>, <0.128333, 1.740841, 0.269668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.213243, 1.644869, 0.145306>, <0.174207, 1.649962, 0.095840>, <0.128333, 1.674003, 0.087041>, 
      <0.213243, 1.662924, 0.194640>, <0.187642, 1.601788, 0.161073>, <0.148607, 1.606881, 0.111607>, <0.102733, 1.630923, 0.102808>, 
      <0.213243, 1.662924, 0.194640>, <0.187642, 1.601788, 0.161073>, <0.126823, 1.585588, 0.167001>, <0.080948, 1.609630, 0.158203>, 
      <0.213243, 1.662924, 0.194640>, <0.187642, 1.619844, 0.210407>, <0.126823, 1.603643, 0.216336>, <0.080948, 1.627685, 0.207537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213243, 1.662924, 0.194640>, <0.187642, 1.619844, 0.210407>, <0.126823, 1.603643, 0.216336>, <0.080948, 1.627685, 0.207537>, 
      <0.233704, 1.697355, 0.182039>, <0.208103, 1.654275, 0.197806>, <0.126823, 1.585588, 0.167001>, <0.080948, 1.609630, 0.158203>, 
      <0.140035, 1.646203, 0.200759>, <0.140035, 1.631773, 0.161330>, <0.123193, 1.665353, 0.090207>, <0.102733, 1.630923, 0.102808>, 
      <0.103371, 1.665418, 0.193727>, <0.103371, 1.650988, 0.154298>, <0.148793, 1.708433, 0.074440>, <0.128333, 1.674003, 0.087041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.067013, 1.744086, 0.158349>, <0.067013, 1.730406, 0.120969>, <0.096589, 1.703264, 0.094834>, <0.131348, 1.685048, 0.101501>, 
      <0.067013, 1.757766, 0.195729>, <0.067013, 1.744086, 0.158349>, <0.115987, 1.735906, 0.082888>, <0.150746, 1.717690, 0.089555>, 
      <0.096589, 1.753907, 0.233210>, <0.115987, 1.786549, 0.221264>, <0.167252, 1.770786, 0.148578>, <0.167252, 1.757105, 0.111198>, 
      <0.131348, 1.735691, 0.239877>, <0.150746, 1.768332, 0.227931>, <0.167252, 1.784467, 0.185958>, <0.167252, 1.770786, 0.148578>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.067013, 1.744086, 0.158349>, <0.067013, 1.730406, 0.120969>, <0.096589, 1.703264, 0.094834>, <0.131348, 1.685048, 0.101501>, 
      <0.067013, 1.757766, 0.195729>, <0.067013, 1.744086, 0.158349>, <0.077191, 1.670623, 0.106780>, <0.111950, 1.652407, 0.113447>, 
      <0.096589, 1.753907, 0.233210>, <0.077191, 1.721266, 0.245156>, <0.095444, 1.649953, 0.192800>, <0.095444, 1.636273, 0.155420>, 
      <0.131348, 1.735691, 0.239877>, <0.111950, 1.703049, 0.251823>, <0.095444, 1.663634, 0.230181>, <0.095444, 1.649953, 0.192800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.067013, 1.744086, 0.158349>, <0.067013, 1.757766, 0.195729>, <0.096589, 1.753907, 0.233210>, <0.131348, 1.735691, 0.239877>, 
      <0.067013, 1.744086, 0.158349>, <0.047615, 1.725125, 0.207675>, <0.077191, 1.721266, 0.245156>, <0.111950, 1.703049, 0.251823>, 
      <0.067013, 1.744086, 0.158349>, <0.047615, 1.725125, 0.207675>, <0.060685, 1.681850, 0.223514>, <0.095444, 1.663634, 0.230181>, 
      <0.067013, 1.744086, 0.158349>, <0.047615, 1.711445, 0.170295>, <0.060685, 1.668169, 0.186133>, <0.095444, 1.649953, 0.192800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.067013, 1.744086, 0.158349>, <0.067013, 1.730406, 0.120969>, <0.096589, 1.703264, 0.094834>, <0.131348, 1.685048, 0.101501>, 
      <0.067013, 1.744086, 0.158349>, <0.047615, 1.697764, 0.132915>, <0.077191, 1.670623, 0.106780>, <0.111950, 1.652407, 0.113447>, 
      <0.067013, 1.744086, 0.158349>, <0.047615, 1.697764, 0.132915>, <0.060685, 1.654489, 0.148753>, <0.095444, 1.636273, 0.155420>, 
      <0.067013, 1.744086, 0.158349>, <0.047615, 1.711445, 0.170295>, <0.060685, 1.668169, 0.186133>, <0.095444, 1.649953, 0.192800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.067013, 1.744086, 0.158349>, <0.067013, 1.730406, 0.120969>, <0.096589, 1.703264, 0.094834>, <0.131348, 1.685048, 0.101501>, 
      <0.067013, 1.744086, 0.158349>, <0.086411, 1.763047, 0.109023>, <0.115987, 1.735906, 0.082888>, <0.150746, 1.717690, 0.089555>, 
      <0.067013, 1.744086, 0.158349>, <0.086411, 1.763047, 0.109023>, <0.132493, 1.775322, 0.104531>, <0.167252, 1.757105, 0.111198>, 
      <0.067013, 1.744086, 0.158349>, <0.086411, 1.776727, 0.146403>, <0.132493, 1.789002, 0.141911>, <0.167252, 1.770786, 0.148578>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.067013, 1.744086, 0.158349>, <0.086411, 1.776727, 0.146403>, <0.132493, 1.789002, 0.141911>, <0.167252, 1.770786, 0.148578>, 
      <0.047615, 1.711445, 0.170295>, <0.067013, 1.744086, 0.158349>, <0.132493, 1.775322, 0.104531>, <0.167252, 1.757105, 0.111198>, 
      <0.060685, 1.668169, 0.186133>, <0.060685, 1.654489, 0.148753>, <0.131348, 1.685048, 0.101501>, <0.150746, 1.717690, 0.089555>, 
      <0.095444, 1.649953, 0.192800>, <0.095444, 1.636273, 0.155420>, <0.111950, 1.652407, 0.113447>, <0.131348, 1.685048, 0.101501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.067013, 1.744086, 0.158349>, <0.067013, 1.757766, 0.195729>, <0.096589, 1.753907, 0.233210>, <0.131348, 1.735691, 0.239877>, 
      <0.067013, 1.744086, 0.158349>, <0.086411, 1.790408, 0.183783>, <0.115987, 1.786549, 0.221264>, <0.150746, 1.768332, 0.227931>, 
      <0.067013, 1.744086, 0.158349>, <0.086411, 1.790408, 0.183783>, <0.132493, 1.802683, 0.179292>, <0.167252, 1.784467, 0.185958>, 
      <0.067013, 1.744086, 0.158349>, <0.086411, 1.776727, 0.146403>, <0.132493, 1.789002, 0.141911>, <0.167252, 1.770786, 0.148578>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.067013, 1.744086, 0.158349>, <0.047615, 1.711445, 0.170295>, <0.060685, 1.668169, 0.186133>, <0.095444, 1.649953, 0.192800>, 
      <0.086411, 1.776727, 0.146403>, <0.067013, 1.744086, 0.158349>, <0.060685, 1.681850, 0.223514>, <0.095444, 1.663634, 0.230181>, 
      <0.132493, 1.789002, 0.141911>, <0.132493, 1.802683, 0.179292>, <0.131348, 1.735691, 0.239877>, <0.111950, 1.703049, 0.251823>, 
      <0.167252, 1.770786, 0.148578>, <0.167252, 1.784467, 0.185958>, <0.150746, 1.768332, 0.227931>, <0.131348, 1.735691, 0.239877>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.195683, 1.690333, 0.220408>, <0.166107, 1.717475, 0.246544>, <0.131348, 1.735691, 0.239877>, 
      <0.195683, 1.662973, 0.145648>, <0.195683, 1.676653, 0.183028>, <0.146709, 1.684833, 0.258490>, <0.111950, 1.703049, 0.251823>, 
      <0.166106, 1.666832, 0.108168>, <0.146709, 1.634190, 0.120114>, <0.095444, 1.649953, 0.192800>, <0.095444, 1.663634, 0.230181>, 
      <0.131348, 1.685048, 0.101501>, <0.111950, 1.652407, 0.113447>, <0.095444, 1.636273, 0.155420>, <0.095444, 1.649953, 0.192800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.195683, 1.690333, 0.220408>, <0.166107, 1.717475, 0.246544>, <0.131348, 1.735691, 0.239877>, 
      <0.195683, 1.662973, 0.145648>, <0.195683, 1.676653, 0.183028>, <0.185505, 1.750116, 0.234598>, <0.150746, 1.768332, 0.227931>, 
      <0.166106, 1.666832, 0.108168>, <0.185504, 1.699473, 0.096222>, <0.167252, 1.770786, 0.148578>, <0.167252, 1.784467, 0.185958>, 
      <0.131348, 1.685048, 0.101501>, <0.150746, 1.717690, 0.089555>, <0.167252, 1.757105, 0.111198>, <0.167252, 1.770786, 0.148578>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.195683, 1.662973, 0.145648>, <0.166106, 1.666832, 0.108168>, <0.131348, 1.685048, 0.101501>, 
      <0.215081, 1.709294, 0.171082>, <0.215081, 1.695614, 0.133702>, <0.131348, 1.685048, 0.101501>, <0.096589, 1.703264, 0.094834>, 
      <0.202011, 1.752570, 0.155245>, <0.167252, 1.770786, 0.148578>, <0.086411, 1.763047, 0.109023>, <0.067013, 1.730406, 0.120969>, 
      <0.167252, 1.770786, 0.148578>, <0.132493, 1.789002, 0.141911>, <0.086411, 1.776727, 0.146403>, <0.067013, 1.744086, 0.158349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.215081, 1.709294, 0.171082>, <0.202011, 1.752570, 0.155245>, <0.167252, 1.770786, 0.148578>, 
      <0.195683, 1.690333, 0.220408>, <0.215081, 1.722975, 0.208463>, <0.167252, 1.770786, 0.148578>, <0.132493, 1.789002, 0.141911>, 
      <0.166107, 1.717475, 0.246544>, <0.131348, 1.735691, 0.239877>, <0.086411, 1.790408, 0.183783>, <0.086411, 1.776727, 0.146403>, 
      <0.131348, 1.735691, 0.239877>, <0.096589, 1.753907, 0.233210>, <0.067013, 1.757766, 0.195729>, <0.067013, 1.744086, 0.158349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.215081, 1.709294, 0.171082>, <0.202011, 1.752570, 0.155245>, <0.167252, 1.770786, 0.148578>, 
      <0.195683, 1.676653, 0.183028>, <0.215081, 1.695614, 0.133702>, <0.202011, 1.738889, 0.117864>, <0.167252, 1.757105, 0.111198>, 
      <0.195683, 1.676653, 0.183028>, <0.215081, 1.695614, 0.133702>, <0.185504, 1.699473, 0.096222>, <0.150746, 1.717690, 0.089555>, 
      <0.195683, 1.676653, 0.183028>, <0.195683, 1.662973, 0.145648>, <0.166106, 1.666832, 0.108168>, <0.131348, 1.685048, 0.101501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.195683, 1.690333, 0.220408>, <0.166107, 1.717475, 0.246544>, <0.131348, 1.735691, 0.239877>, 
      <0.195683, 1.676653, 0.183028>, <0.215081, 1.722975, 0.208463>, <0.185505, 1.750116, 0.234598>, <0.150746, 1.768332, 0.227931>, 
      <0.195683, 1.676653, 0.183028>, <0.215081, 1.722975, 0.208463>, <0.202011, 1.766250, 0.192625>, <0.167252, 1.784467, 0.185958>, 
      <0.195683, 1.676653, 0.183028>, <0.215081, 1.709294, 0.171082>, <0.202011, 1.752570, 0.155245>, <0.167252, 1.770786, 0.148578>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.195683, 1.662973, 0.145648>, <0.166106, 1.666832, 0.108168>, <0.131348, 1.685048, 0.101501>, 
      <0.176285, 1.644012, 0.194974>, <0.176285, 1.630331, 0.157594>, <0.131348, 1.685048, 0.101501>, <0.096589, 1.703264, 0.094834>, 
      <0.130203, 1.631737, 0.199467>, <0.095444, 1.649953, 0.192800>, <0.047615, 1.697764, 0.132915>, <0.067013, 1.730406, 0.120969>, 
      <0.095444, 1.649953, 0.192800>, <0.060685, 1.668169, 0.186133>, <0.047615, 1.711445, 0.170295>, <0.067013, 1.744086, 0.158349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.195683, 1.690333, 0.220408>, <0.166107, 1.717475, 0.246544>, <0.131348, 1.735691, 0.239877>, 
      <0.176285, 1.644012, 0.194974>, <0.176285, 1.657692, 0.232354>, <0.131348, 1.735691, 0.239877>, <0.096589, 1.753907, 0.233210>, 
      <0.130203, 1.631737, 0.199467>, <0.095444, 1.649953, 0.192800>, <0.047615, 1.725125, 0.207675>, <0.067013, 1.757766, 0.195729>, 
      <0.095444, 1.649953, 0.192800>, <0.060685, 1.668169, 0.186133>, <0.047615, 1.711445, 0.170295>, <0.067013, 1.744086, 0.158349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.195683, 1.690333, 0.220408>, <0.166107, 1.717475, 0.246544>, <0.131348, 1.735691, 0.239877>, 
      <0.195683, 1.676653, 0.183028>, <0.176285, 1.657692, 0.232354>, <0.146709, 1.684833, 0.258490>, <0.111950, 1.703049, 0.251823>, 
      <0.195683, 1.676653, 0.183028>, <0.176285, 1.657692, 0.232354>, <0.130203, 1.645417, 0.236847>, <0.095444, 1.663634, 0.230181>, 
      <0.195683, 1.676653, 0.183028>, <0.176285, 1.644012, 0.194974>, <0.130203, 1.631737, 0.199467>, <0.095444, 1.649953, 0.192800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.215081, 1.709294, 0.171082>, <0.202011, 1.752570, 0.155245>, <0.167252, 1.770786, 0.148578>, 
      <0.176285, 1.644012, 0.194974>, <0.195683, 1.676653, 0.183028>, <0.202011, 1.766250, 0.192625>, <0.167252, 1.784467, 0.185958>, 
      <0.130203, 1.631737, 0.199467>, <0.130203, 1.645417, 0.236847>, <0.131348, 1.735691, 0.239877>, <0.150746, 1.768332, 0.227931>, 
      <0.095444, 1.649953, 0.192800>, <0.095444, 1.663634, 0.230181>, <0.111950, 1.703049, 0.251823>, <0.131348, 1.735691, 0.239877>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.195683, 1.662973, 0.145648>, <0.166106, 1.666832, 0.108168>, <0.131348, 1.685048, 0.101501>, 
      <0.195683, 1.676653, 0.183028>, <0.176285, 1.630331, 0.157594>, <0.146709, 1.634190, 0.120114>, <0.111950, 1.652407, 0.113447>, 
      <0.195683, 1.676653, 0.183028>, <0.176285, 1.630331, 0.157594>, <0.130203, 1.618056, 0.162086>, <0.095444, 1.636273, 0.155420>, 
      <0.195683, 1.676653, 0.183028>, <0.176285, 1.644012, 0.194974>, <0.130203, 1.631737, 0.199467>, <0.095444, 1.649953, 0.192800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.195683, 1.676653, 0.183028>, <0.176285, 1.644012, 0.194974>, <0.130203, 1.631737, 0.199467>, <0.095444, 1.649953, 0.192800>, 
      <0.215081, 1.709294, 0.171082>, <0.195683, 1.676653, 0.183028>, <0.130203, 1.618056, 0.162086>, <0.095444, 1.636273, 0.155420>, 
      <0.202011, 1.752570, 0.155245>, <0.202011, 1.738889, 0.117864>, <0.131348, 1.685048, 0.101501>, <0.111950, 1.652407, 0.113447>, 
      <0.167252, 1.770786, 0.148578>, <0.167252, 1.757105, 0.111198>, <0.150746, 1.717690, 0.089555>, <0.131348, 1.685048, 0.101501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.103512, 1.737825, 0.167228>, <-0.103512, 1.719770, 0.117894>, <-0.142548, 1.683949, 0.083401>, <-0.188422, 1.659908, 0.092200>, 
      <-0.103512, 1.755880, 0.216562>, <-0.103512, 1.737825, 0.167228>, <-0.163008, 1.718379, 0.070800>, <-0.208883, 1.694338, 0.079599>, 
      <-0.142547, 1.750786, 0.266028>, <-0.163009, 1.785217, 0.253427>, <-0.163460, 1.651321, 0.198886>, <-0.163460, 1.636891, 0.159457>, 
      <-0.188422, 1.726745, 0.274827>, <-0.208883, 1.761175, 0.262226>, <-0.163460, 1.665751, 0.238315>, <-0.163460, 1.651321, 0.198886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.103512, 1.737825, 0.167228>, <-0.103512, 1.719770, 0.117894>, <-0.142548, 1.683949, 0.083401>, <-0.188422, 1.659908, 0.092200>, 
      <-0.103512, 1.755880, 0.216562>, <-0.103512, 1.737825, 0.167228>, <-0.116947, 1.640870, 0.099169>, <-0.162821, 1.616828, 0.107967>, 
      <-0.142547, 1.750786, 0.266028>, <-0.116947, 1.707707, 0.281795>, <-0.141037, 1.613589, 0.212696>, <-0.141037, 1.595534, 0.163361>, 
      <-0.188422, 1.726745, 0.274827>, <-0.162821, 1.683666, 0.290594>, <-0.141037, 1.631644, 0.262030>, <-0.141037, 1.613589, 0.212696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.103512, 1.737825, 0.167228>, <-0.103512, 1.755880, 0.216562>, <-0.142547, 1.750786, 0.266028>, <-0.188422, 1.726745, 0.274827>, 
      <-0.103512, 1.737825, 0.167228>, <-0.077911, 1.712801, 0.232330>, <-0.116947, 1.707707, 0.281795>, <-0.162821, 1.683666, 0.290594>, 
      <-0.103512, 1.737825, 0.167228>, <-0.077911, 1.712801, 0.232330>, <-0.095162, 1.655685, 0.253232>, <-0.141037, 1.631644, 0.262030>, 
      <-0.103512, 1.737825, 0.167228>, <-0.077911, 1.694745, 0.182995>, <-0.095162, 1.637631, 0.203897>, <-0.141037, 1.613589, 0.212696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.103512, 1.737825, 0.167228>, <-0.103512, 1.719770, 0.117894>, <-0.142548, 1.683949, 0.083401>, <-0.188422, 1.659908, 0.092200>, 
      <-0.103512, 1.737825, 0.167228>, <-0.077911, 1.676690, 0.133661>, <-0.116947, 1.640870, 0.099169>, <-0.162821, 1.616828, 0.107967>, 
      <-0.103512, 1.737825, 0.167228>, <-0.077911, 1.676690, 0.133661>, <-0.095162, 1.619575, 0.154563>, <-0.141037, 1.595534, 0.163361>, 
      <-0.103512, 1.737825, 0.167228>, <-0.077911, 1.694745, 0.182995>, <-0.095162, 1.637631, 0.203897>, <-0.141037, 1.613589, 0.212696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.103512, 1.737825, 0.167228>, <-0.103512, 1.719770, 0.117894>, <-0.142548, 1.683949, 0.083401>, <-0.188422, 1.659908, 0.092200>, 
      <-0.103512, 1.737825, 0.167228>, <-0.123973, 1.754200, 0.105292>, <-0.163008, 1.718379, 0.070800>, <-0.208883, 1.694338, 0.079599>, 
      <-0.103512, 1.737825, 0.167228>, <-0.123973, 1.754200, 0.105292>, <-0.126796, 1.656106, 0.152425>, <-0.163460, 1.636891, 0.159457>, 
      <-0.103512, 1.737825, 0.167228>, <-0.123973, 1.772255, 0.154626>, <-0.126796, 1.670536, 0.191854>, <-0.163460, 1.651321, 0.198886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.103512, 1.737825, 0.167228>, <-0.123973, 1.772255, 0.154626>, <-0.126796, 1.670536, 0.191854>, <-0.163460, 1.651321, 0.198886>, 
      <-0.077911, 1.694745, 0.182995>, <-0.098372, 1.729176, 0.170394>, <-0.126796, 1.656106, 0.152425>, <-0.163460, 1.636891, 0.159457>, 
      <-0.095162, 1.637631, 0.203897>, <-0.095162, 1.619575, 0.154563>, <-0.183282, 1.651258, 0.095366>, <-0.208883, 1.694338, 0.079599>, 
      <-0.141037, 1.613589, 0.212696>, <-0.141037, 1.595534, 0.163361>, <-0.162821, 1.616828, 0.107967>, <-0.188422, 1.659908, 0.092200>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.103512, 1.737825, 0.167228>, <-0.103512, 1.755880, 0.216562>, <-0.142547, 1.750786, 0.266028>, <-0.188422, 1.726745, 0.274827>, 
      <-0.103512, 1.737825, 0.167228>, <-0.123973, 1.790311, 0.203961>, <-0.163009, 1.785217, 0.253427>, <-0.208883, 1.761175, 0.262226>, 
      <-0.103512, 1.737825, 0.167228>, <-0.123973, 1.790311, 0.203961>, <-0.126796, 1.684966, 0.231283>, <-0.163460, 1.665751, 0.238315>, 
      <-0.103512, 1.737825, 0.167228>, <-0.123973, 1.772255, 0.154626>, <-0.126796, 1.670536, 0.191854>, <-0.163460, 1.651321, 0.198886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.103512, 1.737825, 0.167228>, <-0.077911, 1.694745, 0.182995>, <-0.095162, 1.637631, 0.203897>, <-0.141037, 1.613589, 0.212696>, 
      <-0.123973, 1.772255, 0.154626>, <-0.098372, 1.729176, 0.170394>, <-0.095162, 1.655685, 0.253232>, <-0.141037, 1.631644, 0.262030>, 
      <-0.126796, 1.670536, 0.191854>, <-0.126796, 1.684966, 0.231283>, <-0.183282, 1.718096, 0.277993>, <-0.162821, 1.683666, 0.290594>, 
      <-0.163460, 1.651321, 0.198886>, <-0.163460, 1.665751, 0.238315>, <-0.208883, 1.761175, 0.262226>, <-0.188422, 1.726745, 0.274827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.273331, 1.666883, 0.249133>, <-0.234296, 1.702704, 0.283626>, <-0.188422, 1.726745, 0.274827>, 
      <-0.273331, 1.630773, 0.150465>, <-0.273331, 1.648828, 0.199799>, <-0.208695, 1.659624, 0.299393>, <-0.162821, 1.683666, 0.290594>, 
      <-0.234296, 1.635867, 0.100999>, <-0.208695, 1.592787, 0.116766>, <-0.141037, 1.613589, 0.212696>, <-0.141037, 1.631644, 0.262030>, 
      <-0.188422, 1.659908, 0.092200>, <-0.162821, 1.616828, 0.107967>, <-0.141037, 1.595534, 0.163361>, <-0.141037, 1.613589, 0.212696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.273331, 1.666883, 0.249133>, <-0.234296, 1.702704, 0.283626>, <-0.188422, 1.726745, 0.274827>, 
      <-0.273331, 1.630773, 0.150465>, <-0.273331, 1.648828, 0.199799>, <-0.254757, 1.737134, 0.271024>, <-0.208883, 1.761175, 0.262226>, 
      <-0.234296, 1.635867, 0.100999>, <-0.254757, 1.670297, 0.088397>, <-0.163460, 1.651321, 0.198886>, <-0.163460, 1.665751, 0.238315>, 
      <-0.188422, 1.659908, 0.092200>, <-0.208883, 1.694338, 0.079599>, <-0.163460, 1.636891, 0.159457>, <-0.163460, 1.651321, 0.198886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.273331, 1.630773, 0.150465>, <-0.234296, 1.635867, 0.100999>, <-0.188422, 1.659908, 0.092200>, 
      <-0.293792, 1.683258, 0.187198>, <-0.293792, 1.665203, 0.137863>, <-0.188422, 1.659908, 0.092200>, <-0.142548, 1.683949, 0.083401>, 
      <-0.200124, 1.632107, 0.205918>, <-0.163460, 1.651321, 0.198886>, <-0.123973, 1.754200, 0.105292>, <-0.103512, 1.719770, 0.117894>, 
      <-0.163460, 1.651321, 0.198886>, <-0.126796, 1.670536, 0.191854>, <-0.123973, 1.772255, 0.154626>, <-0.103512, 1.737825, 0.167228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.293792, 1.683258, 0.187198>, <-0.200124, 1.632107, 0.205918>, <-0.163460, 1.651321, 0.198886>, 
      <-0.273331, 1.666883, 0.249133>, <-0.293792, 1.701313, 0.236532>, <-0.163460, 1.651321, 0.198886>, <-0.126796, 1.670536, 0.191854>, 
      <-0.234296, 1.702704, 0.283626>, <-0.188422, 1.726745, 0.274827>, <-0.123973, 1.790311, 0.203961>, <-0.123973, 1.772255, 0.154626>, 
      <-0.188422, 1.726745, 0.274827>, <-0.142547, 1.750786, 0.266028>, <-0.103512, 1.755880, 0.216562>, <-0.103512, 1.737825, 0.167228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.293792, 1.683258, 0.187198>, <-0.200124, 1.632107, 0.205918>, <-0.163460, 1.651321, 0.198886>, 
      <-0.273331, 1.648828, 0.199799>, <-0.293792, 1.665203, 0.137863>, <-0.200124, 1.617677, 0.166489>, <-0.163460, 1.636891, 0.159457>, 
      <-0.273331, 1.648828, 0.199799>, <-0.293792, 1.665203, 0.137863>, <-0.254757, 1.670297, 0.088397>, <-0.208883, 1.694338, 0.079599>, 
      <-0.273331, 1.648828, 0.199799>, <-0.273331, 1.630773, 0.150465>, <-0.234296, 1.635867, 0.100999>, <-0.188422, 1.659908, 0.092200>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.273331, 1.666883, 0.249133>, <-0.234296, 1.702704, 0.283626>, <-0.188422, 1.726745, 0.274827>, 
      <-0.273331, 1.648828, 0.199799>, <-0.293792, 1.701313, 0.236532>, <-0.254757, 1.737134, 0.271024>, <-0.208883, 1.761175, 0.262226>, 
      <-0.273331, 1.648828, 0.199799>, <-0.293792, 1.701313, 0.236532>, <-0.200124, 1.646537, 0.245347>, <-0.163460, 1.665751, 0.238315>, 
      <-0.273331, 1.648828, 0.199799>, <-0.293792, 1.683258, 0.187198>, <-0.200124, 1.632107, 0.205918>, <-0.163460, 1.651321, 0.198886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.273331, 1.630773, 0.150465>, <-0.234296, 1.635867, 0.100999>, <-0.188422, 1.659908, 0.092200>, 
      <-0.247730, 1.605749, 0.215566>, <-0.247730, 1.587694, 0.166232>, <-0.188422, 1.659908, 0.092200>, <-0.142548, 1.683949, 0.083401>, 
      <-0.186911, 1.589548, 0.221495>, <-0.141037, 1.613589, 0.212696>, <-0.077911, 1.676690, 0.133661>, <-0.103512, 1.719770, 0.117894>, 
      <-0.141037, 1.613589, 0.212696>, <-0.095162, 1.637631, 0.203897>, <-0.077911, 1.694745, 0.182995>, <-0.103512, 1.737825, 0.167228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.273331, 1.666883, 0.249133>, <-0.234296, 1.702704, 0.283626>, <-0.188422, 1.726745, 0.274827>, 
      <-0.247730, 1.605749, 0.215566>, <-0.247730, 1.623804, 0.264900>, <-0.188422, 1.726745, 0.274827>, <-0.142547, 1.750786, 0.266028>, 
      <-0.186911, 1.589548, 0.221495>, <-0.141037, 1.613589, 0.212696>, <-0.077911, 1.712801, 0.232330>, <-0.103512, 1.755880, 0.216562>, 
      <-0.141037, 1.613589, 0.212696>, <-0.095162, 1.637631, 0.203897>, <-0.077911, 1.694745, 0.182995>, <-0.103512, 1.737825, 0.167228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.273331, 1.666883, 0.249133>, <-0.234296, 1.702704, 0.283626>, <-0.188422, 1.726745, 0.274827>, 
      <-0.273331, 1.648828, 0.199799>, <-0.247730, 1.623804, 0.264900>, <-0.208695, 1.659624, 0.299393>, <-0.162821, 1.683666, 0.290594>, 
      <-0.273331, 1.648828, 0.199799>, <-0.247730, 1.623804, 0.264900>, <-0.186911, 1.607603, 0.270829>, <-0.141037, 1.631644, 0.262030>, 
      <-0.273331, 1.648828, 0.199799>, <-0.247730, 1.605749, 0.215566>, <-0.186911, 1.589548, 0.221495>, <-0.141037, 1.613589, 0.212696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.293792, 1.683258, 0.187198>, <-0.200124, 1.632107, 0.205918>, <-0.163460, 1.651321, 0.198886>, 
      <-0.247730, 1.605749, 0.215566>, <-0.268191, 1.640178, 0.202965>, <-0.200124, 1.646537, 0.245347>, <-0.163460, 1.665751, 0.238315>, 
      <-0.186911, 1.589548, 0.221495>, <-0.186911, 1.607603, 0.270829>, <-0.183282, 1.718096, 0.277993>, <-0.208883, 1.761175, 0.262226>, 
      <-0.141037, 1.613589, 0.212696>, <-0.141037, 1.631644, 0.262030>, <-0.162821, 1.683666, 0.290594>, <-0.188422, 1.726745, 0.274827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.273331, 1.630773, 0.150465>, <-0.234296, 1.635867, 0.100999>, <-0.188422, 1.659908, 0.092200>, 
      <-0.273331, 1.648828, 0.199799>, <-0.247730, 1.587694, 0.166232>, <-0.208695, 1.592787, 0.116766>, <-0.162821, 1.616828, 0.107967>, 
      <-0.273331, 1.648828, 0.199799>, <-0.247730, 1.587694, 0.166232>, <-0.186911, 1.571493, 0.172160>, <-0.141037, 1.595534, 0.163361>, 
      <-0.273331, 1.648828, 0.199799>, <-0.247730, 1.605749, 0.215566>, <-0.186911, 1.589548, 0.221495>, <-0.141037, 1.613589, 0.212696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273331, 1.648828, 0.199799>, <-0.247730, 1.605749, 0.215566>, <-0.186911, 1.589548, 0.221495>, <-0.141037, 1.613589, 0.212696>, 
      <-0.293792, 1.683258, 0.187198>, <-0.268191, 1.640178, 0.202965>, <-0.186911, 1.571493, 0.172160>, <-0.141037, 1.595534, 0.163361>, 
      <-0.200124, 1.632107, 0.205918>, <-0.200124, 1.617677, 0.166489>, <-0.183282, 1.651258, 0.095366>, <-0.162821, 1.616828, 0.107967>, 
      <-0.163460, 1.651321, 0.198886>, <-0.163460, 1.636891, 0.159457>, <-0.208883, 1.694338, 0.079599>, <-0.188422, 1.659908, 0.092200>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.127101, 1.729990, 0.163508>, <-0.127101, 1.716309, 0.126128>, <-0.156678, 1.689168, 0.099993>, <-0.191437, 1.670952, 0.106660>, 
      <-0.127101, 1.743671, 0.200889>, <-0.127101, 1.729990, 0.163508>, <-0.176076, 1.721810, 0.088047>, <-0.210835, 1.703593, 0.094714>, 
      <-0.156678, 1.739811, 0.238369>, <-0.176076, 1.772453, 0.226423>, <-0.227340, 1.756690, 0.153737>, <-0.227340, 1.743009, 0.116357>, 
      <-0.191437, 1.721595, 0.245036>, <-0.210835, 1.754236, 0.233090>, <-0.227340, 1.770370, 0.191117>, <-0.227340, 1.756690, 0.153737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.127101, 1.729990, 0.163508>, <-0.127101, 1.716309, 0.126128>, <-0.156678, 1.689168, 0.099993>, <-0.191437, 1.670952, 0.106660>, 
      <-0.127101, 1.743671, 0.200889>, <-0.127101, 1.729990, 0.163508>, <-0.137280, 1.656527, 0.111939>, <-0.172039, 1.638310, 0.118606>, 
      <-0.156678, 1.739811, 0.238369>, <-0.137280, 1.707170, 0.250315>, <-0.155533, 1.635857, 0.197959>, <-0.155533, 1.622176, 0.160579>, 
      <-0.191437, 1.721595, 0.245036>, <-0.172039, 1.688953, 0.256982>, <-0.155533, 1.649538, 0.235340>, <-0.155533, 1.635857, 0.197959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.127101, 1.729990, 0.163508>, <-0.127101, 1.743671, 0.200889>, <-0.156678, 1.739811, 0.238369>, <-0.191437, 1.721595, 0.245036>, 
      <-0.127101, 1.729990, 0.163508>, <-0.107703, 1.711029, 0.212835>, <-0.137280, 1.707170, 0.250315>, <-0.172039, 1.688953, 0.256982>, 
      <-0.127101, 1.729990, 0.163508>, <-0.107703, 1.711029, 0.212835>, <-0.120774, 1.667754, 0.228673>, <-0.155533, 1.649538, 0.235340>, 
      <-0.127101, 1.729990, 0.163508>, <-0.107703, 1.697348, 0.175454>, <-0.120774, 1.654073, 0.191292>, <-0.155533, 1.635857, 0.197959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.127101, 1.729990, 0.163508>, <-0.127101, 1.716309, 0.126128>, <-0.156678, 1.689168, 0.099993>, <-0.191437, 1.670952, 0.106660>, 
      <-0.127101, 1.729990, 0.163508>, <-0.107703, 1.683668, 0.138074>, <-0.137280, 1.656527, 0.111939>, <-0.172039, 1.638310, 0.118606>, 
      <-0.127101, 1.729990, 0.163508>, <-0.107703, 1.683668, 0.138074>, <-0.120774, 1.640392, 0.153912>, <-0.155533, 1.622176, 0.160579>, 
      <-0.127101, 1.729990, 0.163508>, <-0.107703, 1.697348, 0.175454>, <-0.120774, 1.654073, 0.191292>, <-0.155533, 1.635857, 0.197959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.127101, 1.729990, 0.163508>, <-0.127101, 1.716309, 0.126128>, <-0.156678, 1.689168, 0.099993>, <-0.191437, 1.670952, 0.106660>, 
      <-0.127101, 1.729990, 0.163508>, <-0.146499, 1.748951, 0.114182>, <-0.176076, 1.721810, 0.088047>, <-0.210835, 1.703593, 0.094714>, 
      <-0.127101, 1.729990, 0.163508>, <-0.146499, 1.748951, 0.114182>, <-0.192581, 1.761226, 0.109690>, <-0.227340, 1.743009, 0.116357>, 
      <-0.127101, 1.729990, 0.163508>, <-0.146499, 1.762631, 0.151562>, <-0.192581, 1.774906, 0.147070>, <-0.227340, 1.756690, 0.153737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.127101, 1.729990, 0.163508>, <-0.146499, 1.762631, 0.151562>, <-0.192581, 1.774906, 0.147070>, <-0.227340, 1.756690, 0.153737>, 
      <-0.107703, 1.697348, 0.175454>, <-0.127101, 1.729990, 0.163508>, <-0.192581, 1.761226, 0.109690>, <-0.227340, 1.743009, 0.116357>, 
      <-0.120774, 1.654073, 0.191292>, <-0.120774, 1.640392, 0.153912>, <-0.191437, 1.670952, 0.106660>, <-0.210835, 1.703593, 0.094714>, 
      <-0.155533, 1.635857, 0.197959>, <-0.155533, 1.622176, 0.160579>, <-0.172039, 1.638310, 0.118606>, <-0.191437, 1.670952, 0.106660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.127101, 1.729990, 0.163508>, <-0.127101, 1.743671, 0.200889>, <-0.156678, 1.739811, 0.238369>, <-0.191437, 1.721595, 0.245036>, 
      <-0.127101, 1.729990, 0.163508>, <-0.146499, 1.776312, 0.188943>, <-0.176076, 1.772453, 0.226423>, <-0.210835, 1.754236, 0.233090>, 
      <-0.127101, 1.729990, 0.163508>, <-0.146499, 1.776312, 0.188943>, <-0.192581, 1.788587, 0.184450>, <-0.227340, 1.770370, 0.191117>, 
      <-0.127101, 1.729990, 0.163508>, <-0.146499, 1.762631, 0.151562>, <-0.192581, 1.774906, 0.147070>, <-0.227340, 1.756690, 0.153737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.127101, 1.729990, 0.163508>, <-0.107703, 1.697348, 0.175454>, <-0.120774, 1.654073, 0.191292>, <-0.155533, 1.635857, 0.197959>, 
      <-0.146499, 1.762631, 0.151562>, <-0.127101, 1.729990, 0.163508>, <-0.120774, 1.667754, 0.228673>, <-0.155533, 1.649538, 0.235340>, 
      <-0.192581, 1.774906, 0.147070>, <-0.192581, 1.788587, 0.184450>, <-0.191437, 1.721595, 0.245036>, <-0.172039, 1.688953, 0.256982>, 
      <-0.227340, 1.756690, 0.153737>, <-0.227340, 1.770370, 0.191117>, <-0.210835, 1.754236, 0.233090>, <-0.191437, 1.721595, 0.245036>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.255772, 1.676238, 0.225567>, <-0.226196, 1.703379, 0.251703>, <-0.191437, 1.721595, 0.245036>, 
      <-0.255772, 1.648877, 0.150807>, <-0.255772, 1.662557, 0.188187>, <-0.206798, 1.670737, 0.263649>, <-0.172039, 1.688953, 0.256982>, 
      <-0.226196, 1.652736, 0.113327>, <-0.206798, 1.620094, 0.125273>, <-0.155533, 1.635857, 0.197959>, <-0.155533, 1.649538, 0.235340>, 
      <-0.191437, 1.670952, 0.106660>, <-0.172039, 1.638310, 0.118606>, <-0.155533, 1.622176, 0.160579>, <-0.155533, 1.635857, 0.197959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.255772, 1.676238, 0.225567>, <-0.226196, 1.703379, 0.251703>, <-0.191437, 1.721595, 0.245036>, 
      <-0.255772, 1.648877, 0.150807>, <-0.255772, 1.662557, 0.188187>, <-0.245593, 1.736020, 0.239757>, <-0.210835, 1.754236, 0.233090>, 
      <-0.226196, 1.652736, 0.113327>, <-0.245593, 1.685377, 0.101381>, <-0.227340, 1.756690, 0.153737>, <-0.227340, 1.770370, 0.191117>, 
      <-0.191437, 1.670952, 0.106660>, <-0.210835, 1.703593, 0.094714>, <-0.227340, 1.743009, 0.116357>, <-0.227340, 1.756690, 0.153737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.255772, 1.648877, 0.150807>, <-0.226196, 1.652736, 0.113327>, <-0.191437, 1.670952, 0.106660>, 
      <-0.275170, 1.695198, 0.176241>, <-0.275170, 1.681518, 0.138861>, <-0.191437, 1.670952, 0.106660>, <-0.156678, 1.689168, 0.099993>, 
      <-0.262099, 1.738474, 0.160404>, <-0.227340, 1.756690, 0.153737>, <-0.146499, 1.748951, 0.114182>, <-0.127101, 1.716309, 0.126128>, 
      <-0.227340, 1.756690, 0.153737>, <-0.192581, 1.774906, 0.147070>, <-0.146499, 1.762631, 0.151562>, <-0.127101, 1.729990, 0.163508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.275170, 1.695198, 0.176241>, <-0.262099, 1.738474, 0.160404>, <-0.227340, 1.756690, 0.153737>, 
      <-0.255772, 1.676238, 0.225567>, <-0.275170, 1.708879, 0.213621>, <-0.227340, 1.756690, 0.153737>, <-0.192581, 1.774906, 0.147070>, 
      <-0.226196, 1.703379, 0.251703>, <-0.191437, 1.721595, 0.245036>, <-0.146499, 1.776312, 0.188943>, <-0.146499, 1.762631, 0.151562>, 
      <-0.191437, 1.721595, 0.245036>, <-0.156678, 1.739811, 0.238369>, <-0.127101, 1.743671, 0.200889>, <-0.127101, 1.729990, 0.163508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.275170, 1.695198, 0.176241>, <-0.262099, 1.738474, 0.160404>, <-0.227340, 1.756690, 0.153737>, 
      <-0.255772, 1.662557, 0.188187>, <-0.275170, 1.681518, 0.138861>, <-0.262099, 1.724793, 0.123023>, <-0.227340, 1.743009, 0.116357>, 
      <-0.255772, 1.662557, 0.188187>, <-0.275170, 1.681518, 0.138861>, <-0.245593, 1.685377, 0.101381>, <-0.210835, 1.703593, 0.094714>, 
      <-0.255772, 1.662557, 0.188187>, <-0.255772, 1.648877, 0.150807>, <-0.226196, 1.652736, 0.113327>, <-0.191437, 1.670952, 0.106660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.255772, 1.676238, 0.225567>, <-0.226196, 1.703379, 0.251703>, <-0.191437, 1.721595, 0.245036>, 
      <-0.255772, 1.662557, 0.188187>, <-0.275170, 1.708879, 0.213621>, <-0.245593, 1.736020, 0.239757>, <-0.210835, 1.754236, 0.233090>, 
      <-0.255772, 1.662557, 0.188187>, <-0.275170, 1.708879, 0.213621>, <-0.262099, 1.752154, 0.197784>, <-0.227340, 1.770370, 0.191117>, 
      <-0.255772, 1.662557, 0.188187>, <-0.275170, 1.695198, 0.176241>, <-0.262099, 1.738474, 0.160404>, <-0.227340, 1.756690, 0.153737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.255772, 1.648877, 0.150807>, <-0.226196, 1.652736, 0.113327>, <-0.191437, 1.670952, 0.106660>, 
      <-0.236374, 1.629916, 0.200133>, <-0.236374, 1.616235, 0.162753>, <-0.191437, 1.670952, 0.106660>, <-0.156678, 1.689168, 0.099993>, 
      <-0.190292, 1.617641, 0.204626>, <-0.155533, 1.635857, 0.197959>, <-0.107703, 1.683668, 0.138074>, <-0.127101, 1.716309, 0.126128>, 
      <-0.155533, 1.635857, 0.197959>, <-0.120774, 1.654073, 0.191292>, <-0.107703, 1.697348, 0.175454>, <-0.127101, 1.729990, 0.163508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.255772, 1.676238, 0.225567>, <-0.226196, 1.703379, 0.251703>, <-0.191437, 1.721595, 0.245036>, 
      <-0.236374, 1.629916, 0.200133>, <-0.236374, 1.643596, 0.237513>, <-0.191437, 1.721595, 0.245036>, <-0.156678, 1.739811, 0.238369>, 
      <-0.190292, 1.617641, 0.204626>, <-0.155533, 1.635857, 0.197959>, <-0.107703, 1.711029, 0.212835>, <-0.127101, 1.743671, 0.200889>, 
      <-0.155533, 1.635857, 0.197959>, <-0.120774, 1.654073, 0.191292>, <-0.107703, 1.697348, 0.175454>, <-0.127101, 1.729990, 0.163508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.255772, 1.676238, 0.225567>, <-0.226196, 1.703379, 0.251703>, <-0.191437, 1.721595, 0.245036>, 
      <-0.255772, 1.662557, 0.188187>, <-0.236374, 1.643596, 0.237513>, <-0.206798, 1.670737, 0.263649>, <-0.172039, 1.688953, 0.256982>, 
      <-0.255772, 1.662557, 0.188187>, <-0.236374, 1.643596, 0.237513>, <-0.190292, 1.631321, 0.242006>, <-0.155533, 1.649538, 0.235340>, 
      <-0.255772, 1.662557, 0.188187>, <-0.236374, 1.629916, 0.200133>, <-0.190292, 1.617641, 0.204626>, <-0.155533, 1.635857, 0.197959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.275170, 1.695198, 0.176241>, <-0.262099, 1.738474, 0.160404>, <-0.227340, 1.756690, 0.153737>, 
      <-0.236374, 1.629916, 0.200133>, <-0.255772, 1.662557, 0.188187>, <-0.262099, 1.752154, 0.197784>, <-0.227340, 1.770370, 0.191117>, 
      <-0.190292, 1.617641, 0.204626>, <-0.190292, 1.631321, 0.242006>, <-0.191437, 1.721595, 0.245036>, <-0.210835, 1.754236, 0.233090>, 
      <-0.155533, 1.635857, 0.197959>, <-0.155533, 1.649538, 0.235340>, <-0.172039, 1.688953, 0.256982>, <-0.191437, 1.721595, 0.245036>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.255772, 1.648877, 0.150807>, <-0.226196, 1.652736, 0.113327>, <-0.191437, 1.670952, 0.106660>, 
      <-0.255772, 1.662557, 0.188187>, <-0.236374, 1.616235, 0.162753>, <-0.206798, 1.620094, 0.125273>, <-0.172039, 1.638310, 0.118606>, 
      <-0.255772, 1.662557, 0.188187>, <-0.236374, 1.616235, 0.162753>, <-0.190292, 1.603960, 0.167245>, <-0.155533, 1.622176, 0.160579>, 
      <-0.255772, 1.662557, 0.188187>, <-0.236374, 1.629916, 0.200133>, <-0.190292, 1.617641, 0.204626>, <-0.155533, 1.635857, 0.197959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.255772, 1.662557, 0.188187>, <-0.236374, 1.629916, 0.200133>, <-0.190292, 1.617641, 0.204626>, <-0.155533, 1.635857, 0.197959>, 
      <-0.275170, 1.695198, 0.176241>, <-0.255772, 1.662557, 0.188187>, <-0.190292, 1.603960, 0.167245>, <-0.155533, 1.622176, 0.160579>, 
      <-0.262099, 1.738474, 0.160404>, <-0.262099, 1.724793, 0.123023>, <-0.191437, 1.670952, 0.106660>, <-0.172039, 1.638310, 0.118606>, 
      <-0.227340, 1.756690, 0.153737>, <-0.227340, 1.743009, 0.116357>, <-0.210835, 1.703593, 0.094714>, <-0.191437, 1.670952, 0.106660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.232482, 1.533922, 0.055237>, <0.222961, 1.599877, 0.057368>, <0.182088, 1.689207, 0.078881>, <0.131304, 1.731306, 0.069188>, 
      <0.233111, 1.559366, -0.042385>, <0.223589, 1.625321, -0.040254>, <0.182175, 1.693008, 0.066819>, <0.131390, 1.735107, 0.057126>, 
      <0.083194, 1.597894, -0.160600>, <0.083406, 1.706226, -0.130612>, <0.033777, 1.715935, -0.070086>, <0.033988, 1.745555, -0.013214>, 
      <-0.017673, 1.595986, -0.160767>, <-0.017461, 1.704318, -0.130778>, <-0.016885, 1.719123, -0.068134>, <-0.016674, 1.748743, -0.011262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.232482, 1.533922, 0.055237>, <0.231874, 1.509311, 0.149663>, <0.077216, 1.489573, 0.254761>, <-0.020349, 1.487727, 0.254600>, 
      <0.222961, 1.599877, 0.057368>, <0.222352, 1.575266, 0.151794>, <0.077880, 1.580549, 0.226756>, <-0.019685, 1.578704, 0.226595>, 
      <0.182088, 1.689207, 0.078881>, <0.182012, 1.685846, 0.089547>, <0.025567, 1.660278, 0.115608>, <-0.019235, 1.663097, 0.117334>, 
      <0.131304, 1.731306, 0.069188>, <0.131228, 1.727945, 0.079854>, <0.027694, 1.726836, 0.047586>, <-0.017108, 1.729656, 0.049312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.258929, 1.524627, 0.054425>, <-0.244528, 1.657181, 0.061766>, <-0.194943, 1.694424, 0.087033>, <-0.141783, 1.748492, 0.079707>, 
      <-0.259516, 1.500899, 0.145465>, <-0.245114, 1.633453, 0.152806>, <-0.195010, 1.691513, 0.096271>, <-0.141849, 1.745581, 0.088946>, 
      <-0.114415, 1.485948, 0.254445>, <-0.113751, 1.576925, 0.226439>, <-0.058040, 1.665540, 0.118828>, <-0.055913, 1.732098, 0.050807>, 
      <-0.020349, 1.487727, 0.254600>, <-0.019685, 1.578704, 0.226595>, <-0.019235, 1.663097, 0.117334>, <-0.017108, 1.729656, 0.049312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.258929, 1.524627, 0.054425>, <-0.258310, 1.549676, -0.041682>, <-0.116975, 1.594108, -0.160931>, <-0.017673, 1.595986, -0.160767>, 
      <-0.244528, 1.657181, 0.061766>, <-0.243909, 1.682230, -0.034341>, <-0.116763, 1.702440, -0.130943>, <-0.017461, 1.704318, -0.130778>, 
      <-0.194943, 1.694424, 0.087033>, <-0.194864, 1.697896, 0.076015>, <-0.063165, 1.722035, -0.066352>, <-0.016885, 1.719123, -0.068134>, 
      <-0.141783, 1.748492, 0.079707>, <-0.141704, 1.751964, 0.068689>, <-0.062954, 1.751656, -0.009479>, <-0.016674, 1.748743, -0.011262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.017673, 1.237424, -0.152805>, <-0.017673, 1.343805, -0.136686>, <-0.018028, 1.414213, -0.211086>, <-0.017673, 1.595986, -0.160767>, 
      <-0.100413, 1.235810, -0.152979>, <-0.100413, 1.342191, -0.136860>, <-0.117330, 1.412334, -0.211250>, <-0.116975, 1.594108, -0.160931>, 
      <-0.190735, 1.280286, -0.027499>, <-0.189264, 1.352384, -0.018441>, <-0.272050, 1.423207, -0.048686>, <-0.258310, 1.549676, -0.041682>, 
      <-0.191382, 1.291967, 0.054425>, <-0.189911, 1.364065, 0.063484>, <-0.272669, 1.398159, 0.047421>, <-0.258929, 1.524627, 0.054425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.193644, 1.299478, 0.055237>, <0.186304, 1.369906, 0.063518>, <0.242663, 1.463398, 0.052959>, <0.232482, 1.533922, 0.055237>, 
      <0.194355, 1.286648, -0.034739>, <0.187015, 1.357076, -0.026458>, <0.243292, 1.488841, -0.044664>, <0.233111, 1.559366, -0.042385>, 
      <0.073199, 1.239197, -0.152613>, <0.073199, 1.345578, -0.136494>, <0.082839, 1.416120, -0.210919>, <0.083194, 1.597894, -0.160600>, 
      <-0.017673, 1.237424, -0.152805>, <-0.017673, 1.343805, -0.136686>, <-0.018028, 1.414213, -0.211086>, <-0.017673, 1.595986, -0.160767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.020349, 1.285729, 0.185965>, <-0.020349, 1.349229, 0.193963>, <-0.020796, 1.426559, 0.273429>, <-0.020349, 1.487727, 0.254600>, 
      <0.054979, 1.287198, 0.186124>, <0.054979, 1.350699, 0.194122>, <0.076769, 1.428405, 0.273590>, <0.077216, 1.489573, 0.254761>, 
      <0.193055, 1.310113, 0.129823>, <0.185715, 1.380541, 0.138103>, <0.242055, 1.438787, 0.147384>, <0.231874, 1.509311, 0.149663>, 
      <0.193644, 1.299478, 0.055237>, <0.186304, 1.369906, 0.063518>, <0.242663, 1.463398, 0.052959>, <0.232482, 1.533922, 0.055237>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.020349, 1.285729, 0.185965>, <-0.085094, 1.284466, 0.185829>, <-0.191888, 1.301108, 0.118532>, <-0.191382, 1.291967, 0.054425>, 
      <-0.020349, 1.349229, 0.193963>, <-0.085094, 1.347966, 0.193827>, <-0.190417, 1.373206, 0.127590>, <-0.189911, 1.364065, 0.063484>, 
      <-0.020796, 1.426559, 0.273429>, <-0.114862, 1.424780, 0.273274>, <-0.273256, 1.374430, 0.138461>, <-0.272669, 1.398159, 0.047421>, 
      <-0.020349, 1.487727, 0.254600>, <-0.114415, 1.485948, 0.254445>, <-0.259516, 1.500899, 0.145465>, <-0.258929, 1.524627, 0.054425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.017673, 0.975286, -0.254819>, <-0.018504, 1.058411, -0.240305>, <-0.017673, 1.153990, -0.165447>, <-0.017673, 1.237424, -0.152805>, 
      <-0.129799, 0.979508, -0.254985>, <-0.130630, 1.062633, -0.240471>, <-0.100413, 1.152376, -0.165622>, <-0.100413, 1.235810, -0.152979>, 
      <-0.267195, 1.068987, -0.111130>, <-0.259601, 1.135921, -0.106853>, <-0.192101, 1.213327, -0.035912>, <-0.190735, 1.280286, -0.027499>, 
      <-0.267846, 1.087610, -0.000483>, <-0.260252, 1.154544, 0.003794>, <-0.192748, 1.225008, 0.046012>, <-0.191382, 1.291967, 0.054425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.281153, 1.066936, 0.000329>, <0.274901, 1.142885, 0.004801>, <0.201504, 1.224066, 0.046370>, <0.193644, 1.299478, 0.055237>, 
      <0.281856, 1.046846, -0.119034>, <0.275604, 1.122795, -0.114562>, <0.202214, 1.211236, -0.043606>, <0.194355, 1.286648, -0.034739>, 
      <0.103286, 0.970731, -0.254640>, <0.102455, 1.053856, -0.240126>, <0.073199, 1.155763, -0.165256>, <0.073199, 1.239197, -0.152613>, 
      <-0.017673, 0.975286, -0.254819>, <-0.018504, 1.058411, -0.240305>, <-0.017673, 1.153990, -0.165447>, <-0.017673, 1.237424, -0.152805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.020349, 1.051786, 0.199692>, <-0.019917, 1.122044, 0.197207>, <-0.020349, 1.215977, 0.177179>, <-0.020349, 1.285729, 0.185965>, 
      <0.088105, 1.047702, 0.199852>, <0.088538, 1.117960, 0.197367>, <0.054979, 1.217446, 0.177338>, <0.054979, 1.287198, 0.186124>, 
      <0.280523, 1.084950, 0.107353>, <0.274271, 1.160899, 0.111825>, <0.200915, 1.234701, 0.120956>, <0.193055, 1.310113, 0.129823>, 
      <0.281153, 1.066936, 0.000329>, <0.274901, 1.142885, 0.004801>, <0.201504, 1.224066, 0.046370>, <0.193644, 1.299478, 0.055237>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.020349, 1.051786, 0.199692>, <-0.116378, 1.055402, 0.199550>, <-0.268404, 1.103560, 0.094280>, <-0.267846, 1.087610, -0.000483>, 
      <-0.019917, 1.122044, 0.197207>, <-0.115946, 1.125661, 0.197065>, <-0.260810, 1.170494, 0.098557>, <-0.260252, 1.154544, 0.003794>, 
      <-0.020349, 1.215977, 0.177179>, <-0.085094, 1.214714, 0.177043>, <-0.193255, 1.234149, 0.110119>, <-0.192748, 1.225008, 0.046012>, 
      <-0.020349, 1.285729, 0.185965>, <-0.085094, 1.284466, 0.185829>, <-0.191888, 1.301108, 0.118532>, <-0.191382, 1.291967, 0.054425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.046293, -1.570832, 0.143936>, <0.045092, -1.543863, 0.246419>, <0.033009, -1.323628, 0.145386>, <0.030508, -1.217985, 0.137335>, 
      <0.047495, -1.597817, 0.041393>, <0.046294, -1.570848, 0.143876>, <0.069089, -1.323613, 0.145495>, <0.066588, -1.217970, 0.137444>, 
      <0.034660, -1.364145, -0.001741>, <0.075290, -1.364128, -0.001618>, <0.127079, -1.230423, 0.062078>, <0.126618, -1.220084, 0.101368>, 
      <0.032412, -1.260749, -0.025169>, <0.073042, -1.260732, -0.025046>, <0.127487, -1.239604, 0.027188>, <0.127027, -1.229265, 0.066478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.046293, -1.570832, 0.143936>, <0.047495, -1.597817, 0.041393>, <0.034660, -1.364145, -0.001741>, <0.032412, -1.260749, -0.025169>, 
      <0.046293, -1.570832, 0.143936>, <0.155321, -1.597772, 0.041719>, <0.075290, -1.364128, -0.001618>, <0.073042, -1.260732, -0.025046>, 
      <0.046293, -1.570832, 0.143936>, <0.155321, -1.597772, 0.041719>, <0.120829, -1.346008, 0.043334>, <0.127487, -1.239604, 0.027188>, 
      <0.046293, -1.570832, 0.143936>, <0.154120, -1.570787, 0.144262>, <0.120369, -1.335668, 0.082624>, <0.127027, -1.229265, 0.066478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.046293, -1.570832, 0.143936>, <0.045092, -1.543863, 0.246419>, <0.033009, -1.323628, 0.145386>, <0.030508, -1.217985, 0.137335>, 
      <0.046293, -1.570832, 0.143936>, <0.152919, -1.543818, 0.246745>, <0.069089, -1.323613, 0.145495>, <0.066588, -1.217970, 0.137444>, 
      <0.046293, -1.570832, 0.143936>, <0.152919, -1.543818, 0.246745>, <0.119960, -1.326487, 0.117514>, <0.126618, -1.220084, 0.101368>, 
      <0.046293, -1.570832, 0.143936>, <0.154120, -1.570787, 0.144262>, <0.120369, -1.335668, 0.082624>, <0.127027, -1.229265, 0.066478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.062143, -1.229344, 0.065906>, <-0.050711, -1.337571, 0.081960>, <-0.063713, -1.570878, 0.143603>, <0.046293, -1.570832, 0.143936>, 
      <-0.062143, -1.229344, 0.065906>, <-0.051110, -1.328598, 0.116058>, <-0.064914, -1.543909, 0.246086>, <0.045092, -1.543863, 0.246419>, 
      <-0.062143, -1.229344, 0.065906>, <-0.051110, -1.328598, 0.116058>, <-0.002252, -1.323642, 0.145279>, <0.033009, -1.323628, 0.145386>, 
      <-0.062143, -1.229344, 0.065906>, <-0.062543, -1.220371, 0.100004>, <-0.004753, -1.218000, 0.137228>, <0.030508, -1.217985, 0.137335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.062143, -1.229344, 0.065906>, <-0.062543, -1.220371, 0.100004>, <-0.004753, -1.218000, 0.137228>, <0.030508, -1.217985, 0.137335>, 
      <-0.050711, -1.337571, 0.081960>, <-0.051110, -1.328598, 0.116058>, <0.031326, -1.217985, 0.137338>, <0.066588, -1.217970, 0.137444>, 
      <-0.063713, -1.570878, 0.143603>, <0.044113, -1.570833, 0.143929>, <0.119960, -1.326487, 0.117514>, <0.126618, -1.220084, 0.101368>, 
      <0.046293, -1.570832, 0.143936>, <0.154120, -1.570787, 0.144262>, <0.120369, -1.335668, 0.082624>, <0.127027, -1.229265, 0.066478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.062143, -1.229344, 0.065906>, <-0.062543, -1.220371, 0.100004>, <-0.004753, -1.218000, 0.137228>, <0.030508, -1.217985, 0.137335>, 
      <-0.061684, -1.239649, 0.026746>, <-0.062084, -1.230676, 0.060844>, <-0.002252, -1.323642, 0.145279>, <0.033009, -1.323628, 0.145386>, 
      <-0.008084, -1.260766, -0.025291>, <-0.005836, -1.364162, -0.001863>, <0.046294, -1.570848, 0.143876>, <0.045092, -1.543863, 0.246419>, 
      <0.032412, -1.260749, -0.025169>, <0.034660, -1.364145, -0.001741>, <0.047495, -1.597817, 0.041393>, <0.046293, -1.570832, 0.143936>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.062143, -1.229344, 0.065906>, <-0.050711, -1.337571, 0.081960>, <-0.063713, -1.570878, 0.143603>, <0.046293, -1.570832, 0.143936>, 
      <-0.062143, -1.229344, 0.065906>, <-0.050252, -1.347876, 0.042800>, <-0.062512, -1.597863, 0.041061>, <0.047495, -1.597817, 0.041393>, 
      <-0.062143, -1.229344, 0.065906>, <-0.050252, -1.347876, 0.042800>, <-0.005836, -1.364162, -0.001863>, <0.034660, -1.364145, -0.001741>, 
      <-0.062143, -1.229344, 0.065906>, <-0.061684, -1.239649, 0.026746>, <-0.008084, -1.260766, -0.025291>, <0.032412, -1.260749, -0.025169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.062143, -1.229344, 0.065906>, <-0.050711, -1.337571, 0.081960>, <-0.063713, -1.570878, 0.143603>, <0.046293, -1.570832, 0.143936>, 
      <-0.061684, -1.239649, 0.026746>, <-0.050252, -1.347876, 0.042800>, <0.044113, -1.570833, 0.143929>, <0.154120, -1.570787, 0.144262>, 
      <-0.008084, -1.260766, -0.025291>, <0.032546, -1.260749, -0.025169>, <0.120829, -1.346008, 0.043334>, <0.120369, -1.335668, 0.082624>, 
      <0.032412, -1.260749, -0.025169>, <0.073042, -1.260732, -0.025046>, <0.127487, -1.239604, 0.027188>, <0.127027, -1.229265, 0.066478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.028891, -0.770455, -0.037419>, <0.001151, -0.771026, -0.036771>, <-0.039213, -0.761286, -0.004201>, <-0.039671, -0.757021, 0.023219>, 
      <0.032951, -0.916437, -0.019465>, <0.005212, -0.917008, -0.018817>, <-0.033323, -0.903314, 0.004799>, <-0.033781, -0.899048, 0.032218>, 
      <0.029293, -1.117281, -0.057677>, <-0.011203, -1.117298, -0.057799>, <-0.076486, -1.099520, 0.005960>, <-0.076945, -1.089214, 0.045120>, 
      <0.032412, -1.260749, -0.025169>, <-0.008084, -1.260766, -0.025291>, <-0.061684, -1.239649, 0.026746>, <-0.062143, -1.229344, 0.065906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.097392, -0.754198, 0.020017>, <0.097842, -0.758387, -0.006913>, <0.056136, -0.769894, -0.038055>, <0.028891, -0.770455, -0.037419>, 
      <0.095867, -0.897379, 0.029083>, <0.096317, -0.901568, 0.002153>, <0.060196, -0.915876, -0.020102>, <0.032951, -0.916437, -0.019465>, 
      <0.135886, -1.087684, 0.044994>, <0.136347, -1.098023, 0.005704>, <0.069923, -1.117264, -0.057554>, <0.029293, -1.117281, -0.057677>, 
      <0.127027, -1.229265, 0.066478>, <0.127487, -1.239604, 0.027188>, <0.073042, -1.260732, -0.025046>, <0.032412, -1.260749, -0.025169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.026903, -0.751951, 0.081529>, <0.054964, -0.751373, 0.080874>, <0.096928, -0.749883, 0.047754>, <0.097392, -0.754198, 0.020017>, 
      <0.029130, -0.832124, 0.080538>, <0.057190, -0.831546, 0.079883>, <0.095403, -0.893064, 0.056820>, <0.095867, -0.897379, 0.029083>, 
      <0.027184, -1.077618, 0.126638>, <0.063264, -1.077603, 0.126747>, <0.135477, -1.078502, 0.079883>, <0.135886, -1.087684, 0.044994>, 
      <0.030508, -1.217985, 0.137335>, <0.066588, -1.217970, 0.137444>, <0.126618, -1.220084, 0.101368>, <0.127027, -1.229265, 0.066478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.026903, -0.751951, 0.081529>, <0.029130, -0.832124, 0.080538>, <0.027184, -1.077618, 0.126638>, <0.030508, -1.217985, 0.137335>, 
      <0.000322, -0.752498, 0.082150>, <0.002549, -0.832671, 0.081159>, <-0.008077, -1.077633, 0.126531>, <-0.004753, -1.218000, 0.137228>, 
      <-0.040110, -0.752934, 0.049493>, <-0.034220, -0.894961, 0.058492>, <-0.077345, -1.080241, 0.079218>, <-0.062543, -1.220371, 0.100004>, 
      <-0.039671, -0.757021, 0.023219>, <-0.033781, -0.899048, 0.032218>, <-0.076945, -1.089214, 0.045120>, <-0.062143, -1.229344, 0.065906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.004462, -0.255848, -0.148759>, <-0.053452, -0.255093, -0.148957>, <-0.100180, -0.313592, -0.049282>, <-0.100684, -0.300017, 0.007022>, 
      <0.009307, -0.410846, -0.117848>, <-0.048607, -0.410091, -0.118046>, <-0.074587, -0.449594, -0.047323>, <-0.075091, -0.436019, 0.008981>, 
      <0.024528, -0.613573, -0.056714>, <-0.003212, -0.614144, -0.056065>, <-0.044936, -0.623279, -0.012945>, <-0.045394, -0.619013, 0.014475>, 
      <0.028891, -0.770455, -0.037419>, <0.001151, -0.771026, -0.036771>, <-0.039213, -0.761286, -0.004201>, <-0.039671, -0.757021, 0.023219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.136893, -0.303114, 0.007835>, <0.137443, -0.317912, -0.053542>, <0.067595, -0.256671, -0.148543>, <0.004462, -0.255848, -0.148759>, 
      <0.126454, -0.379809, 0.008731>, <0.127004, -0.394607, -0.052646>, <0.072440, -0.411669, -0.117632>, <0.009307, -0.410846, -0.117848>, 
      <0.098837, -0.618585, 0.011430>, <0.099287, -0.622775, -0.015500>, <0.051772, -0.613012, -0.057350>, <0.024528, -0.613573, -0.056714>, 
      <0.097392, -0.754198, 0.020017>, <0.097842, -0.758387, -0.006913>, <0.056136, -0.769894, -0.038055>, <0.028891, -0.770455, -0.037419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.001786, -0.183788, 0.150116>, <0.070673, -0.184686, 0.150352>, <0.136293, -0.286967, 0.074807>, <0.136893, -0.303114, 0.007835>, 
      <0.009062, -0.354481, 0.131573>, <0.077949, -0.355379, 0.131808>, <0.125855, -0.363662, 0.075702>, <0.126454, -0.379809, 0.008731>, 
      <0.024186, -0.654106, 0.082738>, <0.052246, -0.653528, 0.082083>, <0.098373, -0.614270, 0.039167>, <0.098837, -0.618585, 0.011430>, 
      <0.026903, -0.751951, 0.081529>, <0.054964, -0.751373, 0.080874>, <0.096928, -0.749883, 0.047754>, <0.097392, -0.754198, 0.020017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.001786, -0.183788, 0.150116>, <0.009062, -0.354481, 0.131573>, <0.024186, -0.654106, 0.082738>, <0.026903, -0.751951, 0.081529>, 
      <-0.061483, -0.182963, 0.149899>, <-0.054207, -0.353656, 0.131356>, <-0.002395, -0.654654, 0.083359>, <0.000322, -0.752498, 0.082150>, 
      <-0.101235, -0.285187, 0.068532>, <-0.075642, -0.421189, 0.070490>, <-0.045834, -0.614926, 0.040748>, <-0.040110, -0.752934, 0.049493>, 
      <-0.100684, -0.300017, 0.007022>, <-0.075091, -0.436019, 0.008981>, <-0.045394, -0.619013, 0.014475>, <-0.039671, -0.757021, 0.023219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.010054, 0.475348, -0.285869>, <-0.128949, 0.487675, -0.286078>, <-0.275698, 0.517002, -0.114599>, <-0.279347, 0.516622, 0.004877>, 
      <-0.006056, 0.252983, -0.266713>, <-0.124951, 0.265310, -0.266922>, <-0.245704, 0.268019, -0.113253>, <-0.249353, 0.267639, 0.006224>, 
      <-0.002378, -0.037037, -0.192396>, <-0.060293, -0.036282, -0.192595>, <-0.146555, -0.067156, -0.052831>, <-0.147059, -0.053581, 0.003473>, 
      <0.004462, -0.255848, -0.148759>, <-0.053452, -0.255093, -0.148957>, <-0.100180, -0.313592, -0.049282>, <-0.100684, -0.300017, 0.007022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.010054, 0.475348, -0.285869>, <-0.012746, 0.625057, -0.298766>, <-0.016193, 0.827245, -0.280668>, <-0.017673, 0.975286, -0.254819>, 
      <-0.128949, 0.487675, -0.286078>, <-0.131640, 0.637385, -0.298976>, <-0.128319, 0.831468, -0.280834>, <-0.129799, 0.979508, -0.254985>, 
      <-0.275698, 0.517002, -0.114599>, <-0.296190, 0.687109, -0.115519>, <-0.286471, 0.899082, -0.121988>, <-0.267195, 1.068987, -0.111130>, 
      <-0.279347, 0.516622, 0.004877>, <-0.299839, 0.686728, 0.003957>, <-0.287122, 0.917706, -0.011341>, <-0.267846, 1.087610, -0.000483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.262710, 0.460420, 0.005831>, <0.281773, 0.641463, 0.004839>, <0.296062, 0.885815, -0.010336>, <0.281153, 1.066936, 0.000329>, 
      <0.266370, 0.460801, -0.114004>, <0.285433, 0.641844, -0.114996>, <0.296764, 0.865725, -0.129699>, <0.281856, 1.046846, -0.119034>, 
      <0.109199, 0.462984, -0.285659>, <0.106507, 0.612693, -0.298556>, <0.104766, 0.822690, -0.280489>, <0.103286, 0.970731, -0.254640>, 
      <-0.010054, 0.475348, -0.285869>, <-0.012746, 0.625057, -0.298766>, <-0.016193, 0.827245, -0.280668>, <-0.017673, 0.975286, -0.254819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.262710, 0.460420, 0.005831>, <0.266370, 0.460801, -0.114004>, <0.109199, 0.462984, -0.285659>, <-0.010054, 0.475348, -0.285869>, 
      <0.238400, 0.229550, 0.007096>, <0.242061, 0.229931, -0.112740>, <0.113197, 0.240619, -0.266503>, <-0.006056, 0.252983, -0.266713>, 
      <0.154726, -0.172094, 0.006305>, <0.155275, -0.186892, -0.055072>, <0.060754, -0.037860, -0.192180>, <-0.002378, -0.037037, -0.192396>, 
      <0.136893, -0.303114, 0.007835>, <0.137443, -0.317912, -0.053542>, <0.067595, -0.256671, -0.148543>, <0.004462, -0.255848, -0.148759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.025342, 0.473755, 0.214684>, <-0.028447, 0.647062, 0.221638>, <-0.021415, 0.878424, 0.205824>, <-0.020349, 1.051786, 0.199692>, 
      <0.080903, 0.462739, 0.214871>, <0.077798, 0.636046, 0.221825>, <0.087039, 0.874340, 0.205984>, <0.088105, 1.047702, 0.199852>, 
      <0.259449, 0.460080, 0.112596>, <0.278512, 0.641123, 0.111604>, <0.295432, 0.903828, 0.096688>, <0.280523, 1.084950, 0.107353>, 
      <0.262710, 0.460420, 0.005831>, <0.281773, 0.641463, 0.004839>, <0.296062, 0.885815, -0.010336>, <0.281153, 1.066936, 0.000329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.025342, 0.473755, 0.214684>, <0.080903, 0.462739, 0.214871>, <0.259449, 0.460080, 0.112596>, <0.262710, 0.460420, 0.005831>, 
      <-0.021791, 0.275568, 0.206732>, <0.084454, 0.264552, 0.206919>, <0.235140, 0.229210, 0.113860>, <0.238400, 0.229550, 0.007096>, 
      <-0.006613, 0.013254, 0.171522>, <0.062274, 0.012356, 0.171757>, <0.154126, -0.155946, 0.073276>, <0.154726, -0.172094, 0.006305>, 
      <0.001786, -0.183788, 0.150116>, <0.070673, -0.184686, 0.150352>, <0.136293, -0.286967, 0.074807>, <0.136893, -0.303114, 0.007835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.025342, 0.473755, 0.214684>, <-0.021791, 0.275568, 0.206732>, <-0.006613, 0.013254, 0.171522>, <0.001786, -0.183788, 0.150116>, 
      <-0.124479, 0.484034, 0.214509>, <-0.120928, 0.285846, 0.206558>, <-0.069882, 0.014078, 0.171305>, <-0.061483, -0.182963, 0.149899>, 
      <-0.282390, 0.516305, 0.104498>, <-0.252396, 0.267322, 0.105845>, <-0.147610, -0.038750, 0.064983>, <-0.101235, -0.285187, 0.068532>, 
      <-0.279347, 0.516622, 0.004877>, <-0.249353, 0.267639, 0.006224>, <-0.147059, -0.053581, 0.003473>, <-0.100684, -0.300017, 0.007022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.025342, 0.473755, 0.214684>, <-0.124479, 0.484034, 0.214509>, <-0.282390, 0.516305, 0.104498>, <-0.279347, 0.516622, 0.004877>, 
      <-0.028447, 0.647062, 0.221638>, <-0.127583, 0.657341, 0.221463>, <-0.302882, 0.686411, 0.103578>, <-0.299839, 0.686728, 0.003957>, 
      <-0.021415, 0.878424, 0.205824>, <-0.117444, 0.882040, 0.205682>, <-0.287680, 0.933655, 0.083422>, <-0.287122, 0.917706, -0.011341>, 
      <-0.020349, 1.051786, 0.199692>, <-0.116378, 1.055402, 0.199550>, <-0.268404, 1.103560, 0.094280>, <-0.267846, 1.087610, -0.000483>
    }
  }
}
#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.906982, 0.437390, -0.957747>, <0.909688, 0.439780, -0.951845>, <0.914333, 0.432652, -0.941403>, <0.915165, 0.426087, -0.939385>, 
      <0.829875, 0.498124, -0.786349>, <0.832581, 0.500515, -0.780447>, <0.843778, 0.492823, -0.770787>, <0.844610, 0.486258, -0.768769>, 
      <0.714091, 0.609431, -0.492348>, <0.718819, 0.612575, -0.488177>, <0.737953, 0.603717, -0.476328>, <0.741411, 0.597586, -0.476007>, 
      <0.649958, 0.639838, -0.386419>, <0.654686, 0.642982, -0.382248>, <0.676525, 0.632787, -0.370986>, <0.679983, 0.626657, -0.370665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.902758, 0.415128, -0.966445>, <0.901882, 0.422037, -0.968569>, <0.904134, 0.434875, -0.963958>, <0.906982, 0.437390, -0.957747>, 
      <0.825851, 0.471889, -0.796598>, <0.824975, 0.478798, -0.798722>, <0.827027, 0.495609, -0.792560>, <0.829875, 0.498124, -0.786349>, 
      <0.709276, 0.575505, -0.505390>, <0.705637, 0.581957, -0.505727>, <0.709115, 0.606123, -0.496738>, <0.714091, 0.609431, -0.492348>, 
      <0.646402, 0.604331, -0.400288>, <0.642763, 0.610783, -0.400626>, <0.644982, 0.636530, -0.390809>, <0.649958, 0.639838, -0.386419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.911100, 0.404905, -0.947761>, <0.908416, 0.402534, -0.953615>, <0.903583, 0.408616, -0.964443>, <0.902758, 0.415128, -0.966445>, 
      <0.840708, 0.461289, -0.778621>, <0.838024, 0.458918, -0.784475>, <0.826677, 0.465377, -0.794596>, <0.825851, 0.471889, -0.796598>, 
      <0.736683, 0.565272, -0.488486>, <0.731993, 0.562154, -0.492623>, <0.712706, 0.569425, -0.505072>, <0.709276, 0.575505, -0.505390>, 
      <0.676460, 0.592851, -0.383961>, <0.671770, 0.589733, -0.388098>, <0.649831, 0.598251, -0.399970>, <0.646402, 0.604331, -0.400288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.911100, 0.404905, -0.947761>, <0.840708, 0.461289, -0.778621>, <0.736683, 0.565272, -0.488486>, <0.676460, 0.592851, -0.383961>, 
      <0.913815, 0.407303, -0.941840>, <0.843423, 0.463687, -0.772700>, <0.741426, 0.568426, -0.484301>, <0.681204, 0.596005, -0.379776>, 
      <0.916000, 0.419500, -0.937360>, <0.845445, 0.479671, -0.766744>, <0.744880, 0.591436, -0.475685>, <0.683452, 0.620507, -0.370343>, 
      <0.915165, 0.426087, -0.939385>, <0.844610, 0.486258, -0.768769>, <0.741411, 0.597586, -0.476007>, <0.679983, 0.626657, -0.370665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.461946, 0.648394, -0.222676>, <0.470086, 0.650061, -0.227853>, <0.625657, 0.651360, -0.346282>, <0.649958, 0.639838, -0.386419>, 
      <0.462266, 0.648906, -0.221310>, <0.470405, 0.650573, -0.226487>, <0.630386, 0.654503, -0.342110>, <0.654686, 0.642982, -0.382248>, 
      <0.479735, 0.633143, -0.194095>, <0.488256, 0.635371, -0.199750>, <0.651214, 0.644766, -0.327580>, <0.676525, 0.632787, -0.370986>, 
      <0.480403, 0.631838, -0.193815>, <0.488924, 0.634065, -0.199469>, <0.654672, 0.638635, -0.327259>, <0.679983, 0.626657, -0.370665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.469189, 0.613904, -0.241684>, <0.477143, 0.615650, -0.246258>, <0.623367, 0.614892, -0.361782>, <0.646402, 0.604331, -0.400288>, 
      <0.468486, 0.615278, -0.241979>, <0.476440, 0.617024, -0.246553>, <0.619728, 0.621344, -0.362119>, <0.642763, 0.610783, -0.400626>, 
      <0.461609, 0.647856, -0.224113>, <0.469749, 0.649522, -0.229290>, <0.620681, 0.648051, -0.350671>, <0.644982, 0.636530, -0.390809>, 
      <0.461946, 0.648394, -0.222676>, <0.470086, 0.650061, -0.227853>, <0.625657, 0.651360, -0.346282>, <0.649958, 0.639838, -0.386419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.487229, 0.599017, -0.212071>, <0.495590, 0.601299, -0.217129>, <0.652358, 0.603889, -0.342128>, <0.676460, 0.592851, -0.383961>, 
      <0.486912, 0.598510, -0.213425>, <0.495273, 0.600791, -0.218483>, <0.647668, 0.600771, -0.346265>, <0.671770, 0.589733, -0.388098>, 
      <0.469852, 0.612609, -0.241406>, <0.477806, 0.614356, -0.245980>, <0.626796, 0.608812, -0.361464>, <0.649831, 0.598251, -0.399970>, 
      <0.469189, 0.613904, -0.241684>, <0.477143, 0.615650, -0.246258>, <0.623367, 0.614892, -0.361782>, <0.646402, 0.604331, -0.400288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.487229, 0.599017, -0.212071>, <0.487550, 0.599530, -0.210701>, <0.481074, 0.630529, -0.193534>, <0.480403, 0.631838, -0.193815>, 
      <0.495590, 0.601299, -0.217129>, <0.495911, 0.601812, -0.215759>, <0.489594, 0.632756, -0.199188>, <0.488924, 0.634065, -0.199469>, 
      <0.652358, 0.603889, -0.342128>, <0.657102, 0.607043, -0.337943>, <0.658141, 0.632485, -0.326938>, <0.654672, 0.638635, -0.327259>, 
      <0.676460, 0.592851, -0.383961>, <0.681204, 0.596005, -0.379776>, <0.683452, 0.620507, -0.370343>, <0.679983, 0.626657, -0.370665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.204989, 0.548712, -0.103416>, <0.282076, 0.578617, -0.139194>, <0.452147, 0.646387, -0.216444>, <0.461946, 0.648394, -0.222676>, 
      <0.215041, 0.550062, -0.089809>, <0.292128, 0.579966, -0.125587>, <0.452468, 0.646899, -0.215078>, <0.462266, 0.648906, -0.221310>, 
      <0.228277, 0.525663, -0.071892>, <0.303770, 0.562601, -0.108664>, <0.469965, 0.630590, -0.187612>, <0.479735, 0.633143, -0.194095>, 
      <0.228757, 0.508712, -0.071242>, <0.304251, 0.545650, -0.108014>, <0.470633, 0.629284, -0.187332>, <0.480403, 0.631838, -0.193815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.182669, 0.502524, -0.133628>, <0.268625, 0.535938, -0.166045>, <0.458300, 0.611514, -0.235423>, <0.469189, 0.613904, -0.241684>, 
      <0.182163, 0.520364, -0.134313>, <0.268120, 0.553778, -0.166729>, <0.457597, 0.612887, -0.235718>, <0.468486, 0.615278, -0.241979>, 
      <0.194410, 0.547292, -0.117736>, <0.271497, 0.577196, -0.153514>, <0.451811, 0.645849, -0.217881>, <0.461609, 0.647856, -0.224113>, 
      <0.204989, 0.548712, -0.103416>, <0.282076, 0.578617, -0.139194>, <0.452147, 0.646387, -0.216444>, <0.461946, 0.648394, -0.222676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.207366, 0.464836, -0.100198>, <0.291325, 0.505090, -0.133760>, <0.476442, 0.596073, -0.205546>, <0.487229, 0.599017, -0.212071>, 
      <0.197396, 0.463498, -0.113693>, <0.281355, 0.503752, -0.147255>, <0.476125, 0.595566, -0.206900>, <0.486912, 0.598510, -0.213425>, 
      <0.183145, 0.485711, -0.132983>, <0.269101, 0.519125, -0.165400>, <0.458963, 0.610219, -0.235144>, <0.469852, 0.612609, -0.241406>, 
      <0.182669, 0.502524, -0.133628>, <0.268625, 0.535938, -0.166045>, <0.458300, 0.611514, -0.235423>, <0.469189, 0.613904, -0.241684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.207366, 0.464836, -0.100198>, <0.217451, 0.466190, -0.086547>, <0.229239, 0.491705, -0.070589>, <0.228757, 0.508712, -0.071242>, 
      <0.291325, 0.505090, -0.133760>, <0.301410, 0.506444, -0.120109>, <0.304733, 0.528643, -0.107361>, <0.304251, 0.545650, -0.108014>, 
      <0.476442, 0.596073, -0.205546>, <0.476763, 0.596587, -0.204176>, <0.471304, 0.627975, -0.187051>, <0.470633, 0.629284, -0.187332>, 
      <0.487229, 0.599017, -0.212071>, <0.487550, 0.599530, -0.210701>, <0.481074, 0.630529, -0.193534>, <0.480403, 0.631838, -0.193815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.906982, 1.377009, -0.896369>, <0.909688, 1.379399, -0.890467>, <0.914333, 1.372271, -0.880025>, <0.915165, 1.365706, -0.878007>, 
      <0.809440, 1.322757, -0.762568>, <0.812146, 1.325148, -0.756666>, <0.823344, 1.317456, -0.747006>, <0.824176, 1.310891, -0.744988>, 
      <0.637849, 1.217824, -0.545483>, <0.642577, 1.220967, -0.541312>, <0.661449, 1.210842, -0.528696>, <0.664907, 1.204712, -0.528376>, 
      <0.581843, 1.196170, -0.450365>, <0.586572, 1.199314, -0.446194>, <0.608410, 1.189120, -0.434932>, <0.611868, 1.182989, -0.434611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.902758, 1.354747, -0.905067>, <0.901882, 1.361656, -0.907191>, <0.904134, 1.374494, -0.902580>, <0.906982, 1.377009, -0.896369>, 
      <0.805417, 1.296522, -0.772817>, <0.804541, 1.303431, -0.774941>, <0.806592, 1.320242, -0.768779>, <0.809440, 1.322757, -0.762568>, 
      <0.633527, 1.184316, -0.559314>, <0.629888, 1.190767, -0.559651>, <0.632873, 1.214515, -0.549873>, <0.637849, 1.217824, -0.545483>, 
      <0.578287, 1.160663, -0.464234>, <0.574648, 1.167115, -0.464572>, <0.576867, 1.192862, -0.454755>, <0.581843, 1.196170, -0.450365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.911100, 1.344524, -0.886383>, <0.908416, 1.342153, -0.892237>, <0.903583, 1.348236, -0.903065>, <0.902758, 1.354747, -0.905067>, 
      <0.820273, 1.285922, -0.754840>, <0.817589, 1.283551, -0.760694>, <0.806242, 1.290010, -0.770815>, <0.805417, 1.296522, -0.772817>, 
      <0.660661, 1.172763, -0.541649>, <0.655972, 1.169645, -0.545786>, <0.636956, 1.178236, -0.558995>, <0.633527, 1.184316, -0.559314>, 
      <0.608344, 1.149183, -0.447907>, <0.603654, 1.146065, -0.452044>, <0.581716, 1.154583, -0.463916>, <0.578287, 1.160663, -0.464234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.911100, 1.344524, -0.886383>, <0.820273, 1.285922, -0.754840>, <0.660661, 1.172763, -0.541649>, <0.608344, 1.149183, -0.447907>, 
      <0.913815, 1.346922, -0.880462>, <0.822988, 1.288320, -0.748919>, <0.665405, 1.175917, -0.537465>, <0.613088, 1.152337, -0.443722>, 
      <0.916000, 1.359119, -0.875982>, <0.825011, 1.304304, -0.742964>, <0.668376, 1.198562, -0.528054>, <0.615337, 1.176839, -0.434289>, 
      <0.915165, 1.365706, -0.878007>, <0.824176, 1.310891, -0.744988>, <0.664907, 1.204712, -0.528376>, <0.611868, 1.182989, -0.434611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.494499, 1.217530, -0.195823>, <0.501689, 1.221617, -0.202443>, <0.555812, 1.186106, -0.406154>, <0.581843, 1.196170, -0.450365>, 
      <0.494819, 1.218042, -0.194457>, <0.502009, 1.222129, -0.201077>, <0.560540, 1.189249, -0.401983>, <0.586572, 1.199314, -0.446194>, 
      <0.512288, 1.202279, -0.167242>, <0.519693, 1.206938, -0.174266>, <0.581686, 1.178174, -0.387687>, <0.608410, 1.189120, -0.434932>, 
      <0.512956, 1.200974, -0.166962>, <0.520361, 1.205633, -0.173986>, <0.585144, 1.172044, -0.387366>, <0.611868, 1.182989, -0.434611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.501742, 1.183040, -0.214831>, <0.508969, 1.187148, -0.220870>, <0.553382, 1.149999, -0.421366>, <0.578287, 1.160663, -0.464234>, 
      <0.501039, 1.184414, -0.215126>, <0.508266, 1.188522, -0.221165>, <0.549743, 1.156451, -0.421704>, <0.574648, 1.167115, -0.464572>, 
      <0.494162, 1.216992, -0.197260>, <0.501352, 1.221079, -0.203880>, <0.550836, 1.182797, -0.410544>, <0.576867, 1.192862, -0.454755>, 
      <0.494499, 1.217530, -0.195823>, <0.501689, 1.221617, -0.202443>, <0.555812, 1.186106, -0.406154>, <0.581843, 1.196170, -0.450365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.519782, 1.168153, -0.185218>, <0.527228, 1.172816, -0.191675>, <0.582729, 1.137638, -0.402010>, <0.608344, 1.149183, -0.447907>, 
      <0.519465, 1.167646, -0.186573>, <0.526911, 1.172309, -0.193030>, <0.578039, 1.134520, -0.406147>, <0.603654, 1.146065, -0.452044>, 
      <0.502405, 1.181745, -0.214553>, <0.509632, 1.185853, -0.220592>, <0.556811, 1.143919, -0.421048>, <0.581716, 1.154583, -0.463916>, 
      <0.501742, 1.183040, -0.214831>, <0.508969, 1.187148, -0.220870>, <0.553382, 1.149999, -0.421366>, <0.578287, 1.160663, -0.464234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.519782, 1.168153, -0.185218>, <0.520103, 1.168666, -0.183848>, <0.513627, 1.199664, -0.166681>, <0.512956, 1.200974, -0.166962>, 
      <0.527228, 1.172816, -0.191675>, <0.527550, 1.173329, -0.190305>, <0.521032, 1.204323, -0.173704>, <0.520361, 1.205633, -0.173986>, 
      <0.582729, 1.137638, -0.402010>, <0.587473, 1.140792, -0.397825>, <0.588612, 1.165893, -0.387045>, <0.585144, 1.172044, -0.387366>, 
      <0.608344, 1.149183, -0.447907>, <0.613088, 1.152337, -0.443722>, <0.615337, 1.176839, -0.434289>, <0.611868, 1.182989, -0.434611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.204989, 0.981963, -0.103416>, <0.291842, 1.052633, -0.131138>, <0.484258, 1.211709, -0.186394>, <0.494499, 1.217530, -0.195823>, 
      <0.215041, 0.983313, -0.089809>, <0.301894, 1.053983, -0.117531>, <0.484578, 1.212220, -0.185029>, <0.494819, 1.218042, -0.194457>, 
      <0.228277, 0.958915, -0.071892>, <0.313536, 1.036618, -0.100608>, <0.502024, 1.195822, -0.157508>, <0.512288, 1.202279, -0.167242>, 
      <0.228757, 0.941963, -0.071242>, <0.314017, 1.019666, -0.099958>, <0.502693, 1.194517, -0.157228>, <0.512956, 1.200974, -0.166962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.182669, 0.935775, -0.133628>, <0.278391, 1.009955, -0.157989>, <0.490378, 1.176580, -0.205334>, <0.501742, 1.183040, -0.214831>, 
      <0.182163, 0.953615, -0.134313>, <0.277885, 1.027794, -0.158673>, <0.489674, 1.177954, -0.205629>, <0.501039, 1.184414, -0.215126>, 
      <0.194410, 0.980543, -0.117736>, <0.281263, 1.051213, -0.145458>, <0.483921, 1.211170, -0.187832>, <0.494162, 1.216992, -0.197260>, 
      <0.204989, 0.981963, -0.103416>, <0.291842, 1.052633, -0.131138>, <0.484258, 1.211709, -0.186394>, <0.494499, 1.217530, -0.195823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.207366, 0.898087, -0.100198>, <0.301091, 0.979107, -0.125704>, <0.508483, 1.161077, -0.175420>, <0.519782, 1.168153, -0.185218>, 
      <0.197396, 0.896748, -0.113693>, <0.291121, 0.977768, -0.139199>, <0.508166, 1.160570, -0.176774>, <0.519465, 1.167646, -0.186573>, 
      <0.183145, 0.918962, -0.132983>, <0.278867, 0.993142, -0.157344>, <0.491041, 1.175285, -0.205056>, <0.502405, 1.181745, -0.214553>, 
      <0.182669, 0.935775, -0.133628>, <0.278391, 1.009955, -0.157989>, <0.490378, 1.176580, -0.205334>, <0.501742, 1.183040, -0.214831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.207366, 0.898087, -0.100198>, <0.217451, 0.899441, -0.086547>, <0.229239, 0.924956, -0.070589>, <0.228757, 0.941963, -0.071242>, 
      <0.301091, 0.979107, -0.125704>, <0.311176, 0.980461, -0.112053>, <0.314499, 1.002659, -0.099306>, <0.314017, 1.019666, -0.099958>, 
      <0.508483, 1.161077, -0.175420>, <0.508804, 1.161591, -0.174050>, <0.503363, 1.193208, -0.156946>, <0.502693, 1.194517, -0.157228>, 
      <0.519782, 1.168153, -0.185218>, <0.520103, 1.168666, -0.183848>, <0.513627, 1.199664, -0.166681>, <0.512956, 1.200974, -0.166962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.849373, -1.604094, -0.653315>, <0.849732, -1.607687, -0.647413>, <0.857984, -1.605617, -0.636971>, <0.863058, -1.601369, -0.634953>, 
      <0.763126, -1.414762, -0.604364>, <0.763485, -1.418355, -0.598462>, <0.774108, -1.415813, -0.584839>, <0.779182, -1.411565, -0.582821>, 
      <0.560250, -0.969133, -0.488472>, <0.560239, -0.969013, -0.488669>, <0.582041, -0.964680, -0.459420>, <0.581873, -0.964822, -0.459487>, 
      <0.561883, -0.972989, -0.490144>, <0.561871, -0.972870, -0.490340>, <0.583639, -0.968548, -0.461113>, <0.583470, -0.968689, -0.461180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.861411, -1.584898, -0.662013>, <0.856071, -1.589369, -0.664137>, <0.848995, -1.600313, -0.659526>, <0.849373, -1.604094, -0.653315>, 
      <0.777249, -1.392241, -0.614568>, <0.771909, -1.396712, -0.616692>, <0.762748, -1.410982, -0.610575>, <0.763126, -1.414762, -0.604364>, 
      <0.579223, -0.938797, -0.502232>, <0.579401, -0.938649, -0.502162>, <0.560263, -0.969259, -0.488266>, <0.560250, -0.969133, -0.488472>, 
      <0.580872, -0.942708, -0.503864>, <0.581050, -0.942559, -0.503793>, <0.561896, -0.973115, -0.489937>, <0.561883, -0.972989, -0.490144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.874479, -1.583073, -0.643329>, <0.874123, -1.579510, -0.649183>, <0.866444, -1.580684, -0.660011>, <0.861411, -1.584898, -0.662013>, 
      <0.792581, -1.390100, -0.592648>, <0.792225, -1.386537, -0.598502>, <0.782282, -1.388027, -0.612567>, <0.777249, -1.392241, -0.614568>, 
      <0.599872, -0.935910, -0.472738>, <0.599884, -0.936029, -0.472543>, <0.579055, -0.938938, -0.502299>, <0.579223, -0.938797, -0.502232>, 
      <0.601486, -0.939829, -0.474393>, <0.601498, -0.939948, -0.474198>, <0.580704, -0.942848, -0.503931>, <0.580872, -0.942708, -0.503864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.874479, -1.583073, -0.643329>, <0.792581, -1.390100, -0.592648>, <0.599872, -0.935910, -0.472738>, <0.601486, -0.939829, -0.474393>, 
      <0.874839, -1.586677, -0.637408>, <0.792941, -1.393704, -0.586727>, <0.599861, -0.935790, -0.472935>, <0.601474, -0.939709, -0.474590>, 
      <0.868149, -1.597107, -0.632928>, <0.784272, -1.407303, -0.580796>, <0.581703, -0.964964, -0.459554>, <0.583301, -0.968831, -0.461247>, 
      <0.863058, -1.601369, -0.634953>, <0.779182, -1.411565, -0.582821>, <0.581873, -0.964822, -0.459487>, <0.583470, -0.968689, -0.461180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.415025, -0.578025, -0.208509>, <0.423900, -0.593664, -0.217008>, <0.563044, -0.975733, -0.491333>, <0.561883, -0.972989, -0.490144>, 
      <0.415345, -0.578537, -0.207143>, <0.424220, -0.594175, -0.215642>, <0.563032, -0.975613, -0.491530>, <0.561871, -0.972870, -0.490340>, 
      <0.432814, -0.562774, -0.179928>, <0.441545, -0.579021, -0.188406>, <0.584798, -0.971353, -0.462341>, <0.583639, -0.968548, -0.461113>, 
      <0.433482, -0.561469, -0.179648>, <0.442213, -0.577715, -0.188125>, <0.584629, -0.971494, -0.462408>, <0.583470, -0.968689, -0.461180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.422268, -0.543535, -0.227517>, <0.431863, -0.559217, -0.235498>, <0.582044, -0.945488, -0.505024>, <0.580872, -0.942708, -0.503864>, 
      <0.421565, -0.544909, -0.227812>, <0.431160, -0.560591, -0.235793>, <0.582222, -0.945339, -0.504953>, <0.581050, -0.942559, -0.503793>, 
      <0.414688, -0.577487, -0.209946>, <0.423563, -0.593125, -0.218445>, <0.563057, -0.975858, -0.491127>, <0.561896, -0.973115, -0.489937>, 
      <0.415025, -0.578025, -0.208509>, <0.423900, -0.593664, -0.217008>, <0.563044, -0.975733, -0.491333>, <0.561883, -0.972989, -0.490144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.440308, -0.528648, -0.197904>, <0.449732, -0.544937, -0.205900>, <0.602656, -0.942669, -0.475593>, <0.601486, -0.939829, -0.474393>, 
      <0.439991, -0.528141, -0.199259>, <0.449415, -0.544429, -0.207254>, <0.602668, -0.942788, -0.475398>, <0.601498, -0.939948, -0.474198>, 
      <0.422931, -0.542240, -0.227239>, <0.432526, -0.557923, -0.235220>, <0.581877, -0.945628, -0.505091>, <0.580704, -0.942848, -0.503931>, 
      <0.422268, -0.543535, -0.227517>, <0.431863, -0.559217, -0.235498>, <0.582044, -0.945488, -0.505024>, <0.580872, -0.942708, -0.503864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.440308, -0.528648, -0.197904>, <0.440629, -0.529161, -0.196534>, <0.434153, -0.560160, -0.179367>, <0.433482, -0.561469, -0.179648>, 
      <0.449732, -0.544937, -0.205900>, <0.450053, -0.545450, -0.204530>, <0.442884, -0.576406, -0.187844>, <0.442213, -0.577715, -0.188125>, 
      <0.602656, -0.942669, -0.475593>, <0.602644, -0.942549, -0.475790>, <0.584459, -0.971636, -0.462475>, <0.584629, -0.971494, -0.462408>, 
      <0.601486, -0.939829, -0.474393>, <0.601474, -0.939709, -0.474590>, <0.583301, -0.968831, -0.461247>, <0.583470, -0.968689, -0.461180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.158068, -0.261387, -0.103416>, <0.235155, -0.356378, -0.134944>, <0.407652, -0.565032, -0.201448>, <0.415025, -0.578025, -0.208509>, 
      <0.168120, -0.262737, -0.089809>, <0.245207, -0.357728, -0.121337>, <0.407971, -0.565543, -0.200082>, <0.415345, -0.578537, -0.207143>, 
      <0.181356, -0.238339, -0.071892>, <0.256849, -0.340363, -0.104414>, <0.425442, -0.549058, -0.172771>, <0.432814, -0.562774, -0.179928>, 
      <0.181836, -0.221387, -0.071242>, <0.257330, -0.323412, -0.103764>, <0.426110, -0.547753, -0.172491>, <0.433482, -0.561469, -0.179648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.135748, -0.215199, -0.133628>, <0.221704, -0.313700, -0.161795>, <0.413894, -0.529848, -0.220552>, <0.422268, -0.543535, -0.227517>, 
      <0.135242, -0.233039, -0.134313>, <0.221198, -0.331540, -0.162479>, <0.413190, -0.531222, -0.220847>, <0.421565, -0.544909, -0.227812>, 
      <0.147489, -0.259967, -0.117736>, <0.224576, -0.354958, -0.149264>, <0.407315, -0.564493, -0.202885>, <0.414688, -0.577487, -0.209946>, 
      <0.158068, -0.261387, -0.103416>, <0.235155, -0.356378, -0.134944>, <0.407652, -0.565032, -0.201448>, <0.415025, -0.578025, -0.208509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.160445, -0.177511, -0.100198>, <0.244404, -0.282852, -0.129510>, <0.431997, -0.514282, -0.190853>, <0.440308, -0.528648, -0.197904>, 
      <0.150475, -0.176172, -0.113693>, <0.234434, -0.281514, -0.143005>, <0.431679, -0.513775, -0.192207>, <0.439991, -0.528141, -0.199259>, 
      <0.136225, -0.198386, -0.132983>, <0.222181, -0.296887, -0.161150>, <0.414556, -0.528553, -0.220273>, <0.422931, -0.542240, -0.227239>, 
      <0.135748, -0.215199, -0.133628>, <0.221704, -0.313700, -0.161795>, <0.413894, -0.529848, -0.220552>, <0.422268, -0.543535, -0.227517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.160445, -0.177511, -0.100198>, <0.170530, -0.178865, -0.086547>, <0.182318, -0.204380, -0.070589>, <0.181836, -0.221387, -0.071242>, 
      <0.244404, -0.282852, -0.129510>, <0.254489, -0.284206, -0.115858>, <0.257812, -0.306405, -0.103111>, <0.257330, -0.323412, -0.103764>, 
      <0.431997, -0.514282, -0.190853>, <0.432318, -0.514796, -0.189482>, <0.426781, -0.546443, -0.172210>, <0.426110, -0.547753, -0.172491>, 
      <0.440308, -0.528648, -0.197904>, <0.440629, -0.529161, -0.196534>, <0.434153, -0.560160, -0.179367>, <0.433482, -0.561469, -0.179648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.891288, 0.437390, -0.957747>, <-0.893994, 0.439780, -0.951845>, <-0.898639, 0.432652, -0.941403>, <-0.899471, 0.426087, -0.939385>, 
      <-0.814181, 0.498124, -0.786349>, <-0.816887, 0.500515, -0.780447>, <-0.828084, 0.492823, -0.770787>, <-0.828916, 0.486258, -0.768769>, 
      <-0.698397, 0.609431, -0.492348>, <-0.703125, 0.612575, -0.488177>, <-0.722259, 0.603717, -0.476328>, <-0.725717, 0.597586, -0.476007>, 
      <-0.634264, 0.639838, -0.386419>, <-0.638992, 0.642982, -0.382248>, <-0.660831, 0.632787, -0.370986>, <-0.664289, 0.626657, -0.370665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.887064, 0.415128, -0.966445>, <-0.886188, 0.422037, -0.968569>, <-0.888440, 0.434875, -0.963958>, <-0.891288, 0.437390, -0.957747>, 
      <-0.810157, 0.471889, -0.796598>, <-0.809281, 0.478798, -0.798722>, <-0.811333, 0.495609, -0.792560>, <-0.814181, 0.498124, -0.786349>, 
      <-0.693582, 0.575505, -0.505390>, <-0.689943, 0.581957, -0.505727>, <-0.693421, 0.606123, -0.496738>, <-0.698397, 0.609431, -0.492348>, 
      <-0.630708, 0.604331, -0.400288>, <-0.627069, 0.610783, -0.400626>, <-0.629288, 0.636530, -0.390809>, <-0.634264, 0.639838, -0.386419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.895406, 0.404905, -0.947761>, <-0.892722, 0.402534, -0.953615>, <-0.887889, 0.408616, -0.964443>, <-0.887064, 0.415128, -0.966445>, 
      <-0.825014, 0.461289, -0.778621>, <-0.822330, 0.458918, -0.784475>, <-0.810983, 0.465377, -0.794596>, <-0.810157, 0.471889, -0.796598>, 
      <-0.720989, 0.565272, -0.488486>, <-0.716299, 0.562154, -0.492623>, <-0.697012, 0.569425, -0.505072>, <-0.693582, 0.575505, -0.505390>, 
      <-0.660766, 0.592851, -0.383961>, <-0.656076, 0.589733, -0.388098>, <-0.634137, 0.598251, -0.399970>, <-0.630708, 0.604331, -0.400288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.895406, 0.404905, -0.947761>, <-0.825014, 0.461289, -0.778621>, <-0.720989, 0.565272, -0.488486>, <-0.660766, 0.592851, -0.383961>, 
      <-0.898121, 0.407303, -0.941840>, <-0.827729, 0.463687, -0.772700>, <-0.725732, 0.568426, -0.484301>, <-0.665510, 0.596005, -0.379776>, 
      <-0.900306, 0.419500, -0.937360>, <-0.829751, 0.479671, -0.766744>, <-0.729186, 0.591436, -0.475685>, <-0.667758, 0.620507, -0.370343>, 
      <-0.899471, 0.426087, -0.939385>, <-0.828916, 0.486258, -0.768769>, <-0.725717, 0.597586, -0.476007>, <-0.664289, 0.626657, -0.370665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.446252, 0.648394, -0.222676>, <-0.454392, 0.650061, -0.227853>, <-0.609963, 0.651360, -0.346282>, <-0.634264, 0.639838, -0.386419>, 
      <-0.446572, 0.648906, -0.221310>, <-0.454711, 0.650573, -0.226487>, <-0.614692, 0.654503, -0.342110>, <-0.638992, 0.642982, -0.382248>, 
      <-0.464041, 0.633143, -0.194095>, <-0.472562, 0.635371, -0.199750>, <-0.635520, 0.644766, -0.327580>, <-0.660831, 0.632787, -0.370986>, 
      <-0.464709, 0.631838, -0.193815>, <-0.473230, 0.634065, -0.199469>, <-0.638978, 0.638635, -0.327259>, <-0.664289, 0.626657, -0.370665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.453495, 0.613904, -0.241684>, <-0.461449, 0.615650, -0.246258>, <-0.607673, 0.614892, -0.361782>, <-0.630708, 0.604331, -0.400288>, 
      <-0.452792, 0.615278, -0.241979>, <-0.460746, 0.617024, -0.246553>, <-0.604034, 0.621344, -0.362119>, <-0.627069, 0.610783, -0.400626>, 
      <-0.445915, 0.647856, -0.224113>, <-0.454055, 0.649522, -0.229290>, <-0.604987, 0.648051, -0.350671>, <-0.629288, 0.636530, -0.390809>, 
      <-0.446252, 0.648394, -0.222676>, <-0.454392, 0.650061, -0.227853>, <-0.609963, 0.651360, -0.346282>, <-0.634264, 0.639838, -0.386419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.471535, 0.599017, -0.212071>, <-0.479896, 0.601299, -0.217129>, <-0.636664, 0.603889, -0.342128>, <-0.660766, 0.592851, -0.383961>, 
      <-0.471218, 0.598510, -0.213425>, <-0.479579, 0.600791, -0.218483>, <-0.631974, 0.600771, -0.346265>, <-0.656076, 0.589733, -0.388098>, 
      <-0.454158, 0.612609, -0.241406>, <-0.462112, 0.614356, -0.245980>, <-0.611102, 0.608812, -0.361464>, <-0.634137, 0.598251, -0.399970>, 
      <-0.453495, 0.613904, -0.241684>, <-0.461449, 0.615650, -0.246258>, <-0.607673, 0.614892, -0.361782>, <-0.630708, 0.604331, -0.400288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.471535, 0.599017, -0.212071>, <-0.471856, 0.599530, -0.210701>, <-0.465380, 0.630529, -0.193534>, <-0.464709, 0.631838, -0.193815>, 
      <-0.479896, 0.601299, -0.217129>, <-0.480217, 0.601812, -0.215759>, <-0.473901, 0.632756, -0.199188>, <-0.473230, 0.634065, -0.199469>, 
      <-0.636664, 0.603889, -0.342128>, <-0.641408, 0.607043, -0.337943>, <-0.642447, 0.632485, -0.326938>, <-0.638978, 0.638635, -0.327259>, 
      <-0.660766, 0.592851, -0.383961>, <-0.665510, 0.596005, -0.379776>, <-0.667758, 0.620507, -0.370343>, <-0.664289, 0.626657, -0.370665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.189295, 0.548712, -0.103416>, <-0.266382, 0.578617, -0.139194>, <-0.436453, 0.646387, -0.216444>, <-0.446252, 0.648394, -0.222676>, 
      <-0.199347, 0.550062, -0.089809>, <-0.276434, 0.579966, -0.125587>, <-0.436773, 0.646899, -0.215078>, <-0.446572, 0.648906, -0.221310>, 
      <-0.212583, 0.525663, -0.071892>, <-0.288076, 0.562601, -0.108664>, <-0.454271, 0.630590, -0.187612>, <-0.464041, 0.633143, -0.194095>, 
      <-0.213063, 0.508712, -0.071242>, <-0.288557, 0.545650, -0.108014>, <-0.454940, 0.629284, -0.187332>, <-0.464709, 0.631838, -0.193815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.166975, 0.502524, -0.133628>, <-0.252931, 0.535938, -0.166045>, <-0.442606, 0.611514, -0.235423>, <-0.453495, 0.613904, -0.241684>, 
      <-0.166469, 0.520364, -0.134313>, <-0.252425, 0.553778, -0.166729>, <-0.441902, 0.612887, -0.235718>, <-0.452792, 0.615278, -0.241979>, 
      <-0.178716, 0.547292, -0.117736>, <-0.255803, 0.577196, -0.153514>, <-0.436117, 0.645849, -0.217881>, <-0.445915, 0.647856, -0.224113>, 
      <-0.189295, 0.548712, -0.103416>, <-0.266382, 0.578617, -0.139194>, <-0.436453, 0.646387, -0.216444>, <-0.446252, 0.648394, -0.222676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.191672, 0.464836, -0.100198>, <-0.275631, 0.505090, -0.133760>, <-0.460748, 0.596073, -0.205546>, <-0.471535, 0.599017, -0.212071>, 
      <-0.181702, 0.463498, -0.113693>, <-0.265661, 0.503752, -0.147255>, <-0.460431, 0.595566, -0.206900>, <-0.471218, 0.598510, -0.213425>, 
      <-0.167452, 0.485711, -0.132983>, <-0.253408, 0.519125, -0.165400>, <-0.443269, 0.610219, -0.235144>, <-0.454158, 0.612609, -0.241406>, 
      <-0.166975, 0.502524, -0.133628>, <-0.252931, 0.535938, -0.166045>, <-0.442606, 0.611514, -0.235423>, <-0.453495, 0.613904, -0.241684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.191672, 0.464836, -0.100198>, <-0.201757, 0.466190, -0.086547>, <-0.213545, 0.491705, -0.070589>, <-0.213063, 0.508712, -0.071242>, 
      <-0.275631, 0.505090, -0.133760>, <-0.285716, 0.506444, -0.120109>, <-0.289039, 0.528643, -0.107361>, <-0.288557, 0.545650, -0.108014>, 
      <-0.460748, 0.596073, -0.205546>, <-0.461069, 0.596587, -0.204176>, <-0.455610, 0.627975, -0.187051>, <-0.454940, 0.629284, -0.187332>, 
      <-0.471535, 0.599017, -0.212071>, <-0.471856, 0.599530, -0.210701>, <-0.465380, 0.630529, -0.193534>, <-0.464709, 0.631838, -0.193815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.891288, 1.377009, -0.896369>, <-0.893994, 1.379399, -0.890467>, <-0.898639, 1.372271, -0.880025>, <-0.899471, 1.365706, -0.878007>, 
      <-0.793746, 1.322757, -0.762568>, <-0.796452, 1.325148, -0.756666>, <-0.807650, 1.317456, -0.747006>, <-0.808482, 1.310891, -0.744988>, 
      <-0.622155, 1.217824, -0.545483>, <-0.626883, 1.220967, -0.541312>, <-0.645755, 1.210842, -0.528696>, <-0.649213, 1.204712, -0.528376>, 
      <-0.566149, 1.196170, -0.450365>, <-0.570878, 1.199314, -0.446194>, <-0.592716, 1.189120, -0.434932>, <-0.596174, 1.182989, -0.434611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.887064, 1.354747, -0.905067>, <-0.886188, 1.361656, -0.907191>, <-0.888440, 1.374494, -0.902580>, <-0.891288, 1.377009, -0.896369>, 
      <-0.789723, 1.296522, -0.772817>, <-0.788847, 1.303431, -0.774941>, <-0.790898, 1.320242, -0.768779>, <-0.793746, 1.322757, -0.762568>, 
      <-0.617833, 1.184316, -0.559314>, <-0.614194, 1.190767, -0.559651>, <-0.617179, 1.214515, -0.549873>, <-0.622155, 1.217824, -0.545483>, 
      <-0.562593, 1.160663, -0.464234>, <-0.558954, 1.167115, -0.464572>, <-0.561173, 1.192862, -0.454755>, <-0.566149, 1.196170, -0.450365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.895406, 1.344524, -0.886383>, <-0.892722, 1.342153, -0.892237>, <-0.887889, 1.348236, -0.903065>, <-0.887064, 1.354747, -0.905067>, 
      <-0.804579, 1.285922, -0.754840>, <-0.801895, 1.283551, -0.760694>, <-0.790548, 1.290010, -0.770815>, <-0.789723, 1.296522, -0.772817>, 
      <-0.644967, 1.172763, -0.541649>, <-0.640278, 1.169645, -0.545786>, <-0.621262, 1.178236, -0.558995>, <-0.617833, 1.184316, -0.559314>, 
      <-0.592650, 1.149183, -0.447907>, <-0.587960, 1.146065, -0.452044>, <-0.566022, 1.154583, -0.463916>, <-0.562593, 1.160663, -0.464234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.895406, 1.344524, -0.886383>, <-0.804579, 1.285922, -0.754840>, <-0.644967, 1.172763, -0.541649>, <-0.592650, 1.149183, -0.447907>, 
      <-0.898121, 1.346922, -0.880462>, <-0.807294, 1.288320, -0.748919>, <-0.649711, 1.175917, -0.537465>, <-0.597394, 1.152337, -0.443722>, 
      <-0.900306, 1.359119, -0.875982>, <-0.809317, 1.304304, -0.742964>, <-0.652682, 1.198562, -0.528054>, <-0.599643, 1.176839, -0.434289>, 
      <-0.899471, 1.365706, -0.878007>, <-0.808482, 1.310891, -0.744988>, <-0.649213, 1.204712, -0.528376>, <-0.596174, 1.182989, -0.434611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.478805, 1.217530, -0.195823>, <-0.485995, 1.221617, -0.202443>, <-0.540118, 1.186106, -0.406154>, <-0.566149, 1.196170, -0.450365>, 
      <-0.479125, 1.218042, -0.194457>, <-0.486315, 1.222129, -0.201077>, <-0.544846, 1.189249, -0.401983>, <-0.570878, 1.199314, -0.446194>, 
      <-0.496594, 1.202279, -0.167242>, <-0.503999, 1.206938, -0.174266>, <-0.565992, 1.178174, -0.387687>, <-0.592716, 1.189120, -0.434932>, 
      <-0.497262, 1.200974, -0.166962>, <-0.504667, 1.205633, -0.173986>, <-0.569450, 1.172044, -0.387366>, <-0.596174, 1.182989, -0.434611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.486048, 1.183040, -0.214831>, <-0.493275, 1.187148, -0.220870>, <-0.537688, 1.149999, -0.421366>, <-0.562593, 1.160663, -0.464234>, 
      <-0.485345, 1.184414, -0.215126>, <-0.492571, 1.188522, -0.221165>, <-0.534049, 1.156451, -0.421704>, <-0.558954, 1.167115, -0.464572>, 
      <-0.478468, 1.216992, -0.197260>, <-0.485658, 1.221079, -0.203880>, <-0.535142, 1.182797, -0.410544>, <-0.561173, 1.192862, -0.454755>, 
      <-0.478805, 1.217530, -0.195823>, <-0.485995, 1.221617, -0.202443>, <-0.540118, 1.186106, -0.406154>, <-0.566149, 1.196170, -0.450365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.504088, 1.168153, -0.185218>, <-0.511535, 1.172816, -0.191675>, <-0.567035, 1.137638, -0.402010>, <-0.592650, 1.149183, -0.447907>, 
      <-0.503771, 1.167646, -0.186573>, <-0.511217, 1.172309, -0.193030>, <-0.562345, 1.134520, -0.406147>, <-0.587960, 1.146065, -0.452044>, 
      <-0.486711, 1.181745, -0.214553>, <-0.493938, 1.185853, -0.220592>, <-0.541117, 1.143919, -0.421048>, <-0.566022, 1.154583, -0.463916>, 
      <-0.486048, 1.183040, -0.214831>, <-0.493275, 1.187148, -0.220870>, <-0.537688, 1.149999, -0.421366>, <-0.562593, 1.160663, -0.464234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.504088, 1.168153, -0.185218>, <-0.504409, 1.168666, -0.183848>, <-0.497933, 1.199664, -0.166681>, <-0.497262, 1.200974, -0.166962>, 
      <-0.511535, 1.172816, -0.191675>, <-0.511855, 1.173329, -0.190305>, <-0.505338, 1.204323, -0.173704>, <-0.504667, 1.205633, -0.173986>, 
      <-0.567035, 1.137638, -0.402010>, <-0.571779, 1.140792, -0.397825>, <-0.572918, 1.165893, -0.387045>, <-0.569450, 1.172044, -0.387366>, 
      <-0.592650, 1.149183, -0.447907>, <-0.597394, 1.152337, -0.443722>, <-0.599643, 1.176839, -0.434289>, <-0.596174, 1.182989, -0.434611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.189295, 0.981963, -0.103416>, <-0.276148, 1.052633, -0.131138>, <-0.468564, 1.211709, -0.186394>, <-0.478805, 1.217530, -0.195823>, 
      <-0.199347, 0.983313, -0.089809>, <-0.286200, 1.053983, -0.117531>, <-0.468884, 1.212220, -0.185029>, <-0.479125, 1.218042, -0.194457>, 
      <-0.212583, 0.958915, -0.071892>, <-0.297842, 1.036618, -0.100608>, <-0.486330, 1.195822, -0.157508>, <-0.496594, 1.202279, -0.167242>, 
      <-0.213063, 0.941963, -0.071242>, <-0.298323, 1.019666, -0.099958>, <-0.486999, 1.194517, -0.157228>, <-0.497262, 1.200974, -0.166962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.166975, 0.935775, -0.133628>, <-0.262697, 1.009955, -0.157989>, <-0.474684, 1.176580, -0.205334>, <-0.486048, 1.183040, -0.214831>, 
      <-0.166469, 0.953615, -0.134313>, <-0.262191, 1.027794, -0.158673>, <-0.473980, 1.177954, -0.205629>, <-0.485345, 1.184414, -0.215126>, 
      <-0.178716, 0.980543, -0.117736>, <-0.265569, 1.051213, -0.145458>, <-0.468227, 1.211170, -0.187832>, <-0.478468, 1.216992, -0.197260>, 
      <-0.189295, 0.981963, -0.103416>, <-0.276148, 1.052633, -0.131138>, <-0.468564, 1.211709, -0.186394>, <-0.478805, 1.217530, -0.195823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.191672, 0.898087, -0.100198>, <-0.285397, 0.979107, -0.125704>, <-0.492789, 1.161077, -0.175420>, <-0.504088, 1.168153, -0.185218>, 
      <-0.181702, 0.896748, -0.113693>, <-0.275427, 0.977768, -0.139199>, <-0.492472, 1.160570, -0.176774>, <-0.503771, 1.167646, -0.186573>, 
      <-0.167452, 0.918962, -0.132983>, <-0.263173, 0.993142, -0.157344>, <-0.475347, 1.175285, -0.205056>, <-0.486711, 1.181745, -0.214553>, 
      <-0.166975, 0.935775, -0.133628>, <-0.262697, 1.009955, -0.157989>, <-0.474684, 1.176580, -0.205334>, <-0.486048, 1.183040, -0.214831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.191672, 0.898087, -0.100198>, <-0.201757, 0.899441, -0.086547>, <-0.213545, 0.924956, -0.070589>, <-0.213063, 0.941963, -0.071242>, 
      <-0.285397, 0.979107, -0.125704>, <-0.295482, 0.980461, -0.112053>, <-0.298805, 1.002659, -0.099306>, <-0.298323, 1.019666, -0.099958>, 
      <-0.492789, 1.161077, -0.175420>, <-0.493110, 1.161591, -0.174050>, <-0.487669, 1.193208, -0.156946>, <-0.486999, 1.194517, -0.157228>, 
      <-0.504088, 1.168153, -0.185218>, <-0.504409, 1.168666, -0.183848>, <-0.497933, 1.199664, -0.166681>, <-0.497262, 1.200974, -0.166962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.833679, -1.604094, -0.653315>, <-0.834038, -1.607687, -0.647413>, <-0.842290, -1.605617, -0.636971>, <-0.847364, -1.601369, -0.634953>, 
      <-0.747432, -1.414762, -0.604364>, <-0.747791, -1.418355, -0.598462>, <-0.758414, -1.415813, -0.584839>, <-0.763488, -1.411565, -0.582821>, 
      <-0.544557, -0.969133, -0.488472>, <-0.544545, -0.969013, -0.488669>, <-0.566347, -0.964680, -0.459420>, <-0.566179, -0.964822, -0.459487>, 
      <-0.546189, -0.972989, -0.490144>, <-0.546177, -0.972870, -0.490340>, <-0.567945, -0.968548, -0.461113>, <-0.567776, -0.968689, -0.461180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.845717, -1.584898, -0.662013>, <-0.840377, -1.589369, -0.664137>, <-0.833301, -1.600313, -0.659526>, <-0.833679, -1.604094, -0.653315>, 
      <-0.761555, -1.392241, -0.614568>, <-0.756216, -1.396712, -0.616692>, <-0.747054, -1.410982, -0.610575>, <-0.747432, -1.414762, -0.604364>, 
      <-0.563529, -0.938797, -0.502232>, <-0.563707, -0.938649, -0.502162>, <-0.544569, -0.969259, -0.488266>, <-0.544557, -0.969133, -0.488472>, 
      <-0.565178, -0.942708, -0.503864>, <-0.565356, -0.942559, -0.503793>, <-0.546202, -0.973115, -0.489937>, <-0.546189, -0.972989, -0.490144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.858785, -1.583073, -0.643329>, <-0.858429, -1.579510, -0.649183>, <-0.850750, -1.580684, -0.660011>, <-0.845717, -1.584898, -0.662013>, 
      <-0.776887, -1.390100, -0.592648>, <-0.776531, -1.386537, -0.598502>, <-0.766588, -1.388027, -0.612567>, <-0.761555, -1.392241, -0.614568>, 
      <-0.584178, -0.935910, -0.472738>, <-0.584190, -0.936029, -0.472543>, <-0.563361, -0.938938, -0.502299>, <-0.563529, -0.938797, -0.502232>, 
      <-0.585792, -0.939829, -0.474393>, <-0.585804, -0.939948, -0.474198>, <-0.565010, -0.942848, -0.503931>, <-0.565178, -0.942708, -0.503864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.858785, -1.583073, -0.643329>, <-0.776887, -1.390100, -0.592648>, <-0.584178, -0.935910, -0.472738>, <-0.585792, -0.939829, -0.474393>, 
      <-0.859145, -1.586677, -0.637408>, <-0.777247, -1.393704, -0.586727>, <-0.584166, -0.935790, -0.472935>, <-0.585780, -0.939709, -0.474590>, 
      <-0.852455, -1.597107, -0.632928>, <-0.768578, -1.407303, -0.580796>, <-0.566009, -0.964964, -0.459554>, <-0.567607, -0.968831, -0.461247>, 
      <-0.847364, -1.601369, -0.634953>, <-0.763488, -1.411565, -0.582821>, <-0.566179, -0.964822, -0.459487>, <-0.567776, -0.968689, -0.461180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.399331, -0.578025, -0.208509>, <-0.408206, -0.593664, -0.217008>, <-0.547350, -0.975733, -0.491333>, <-0.546189, -0.972989, -0.490144>, 
      <-0.399651, -0.578537, -0.207143>, <-0.408525, -0.594175, -0.215642>, <-0.547338, -0.975613, -0.491530>, <-0.546177, -0.972870, -0.490340>, 
      <-0.417120, -0.562774, -0.179928>, <-0.425851, -0.579021, -0.188406>, <-0.569104, -0.971353, -0.462341>, <-0.567945, -0.968548, -0.461113>, 
      <-0.417788, -0.561469, -0.179648>, <-0.426520, -0.577715, -0.188125>, <-0.568935, -0.971494, -0.462408>, <-0.567776, -0.968689, -0.461180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.406574, -0.543535, -0.227517>, <-0.416169, -0.559217, -0.235498>, <-0.566350, -0.945488, -0.505024>, <-0.565178, -0.942708, -0.503864>, 
      <-0.405871, -0.544909, -0.227812>, <-0.415466, -0.560591, -0.235793>, <-0.566528, -0.945339, -0.504953>, <-0.565356, -0.942559, -0.503793>, 
      <-0.398994, -0.577487, -0.209946>, <-0.407869, -0.593125, -0.218445>, <-0.547363, -0.975858, -0.491127>, <-0.546202, -0.973115, -0.489937>, 
      <-0.399331, -0.578025, -0.208509>, <-0.408206, -0.593664, -0.217008>, <-0.547350, -0.975733, -0.491333>, <-0.546189, -0.972989, -0.490144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.424614, -0.528648, -0.197904>, <-0.434038, -0.544937, -0.205900>, <-0.586962, -0.942669, -0.475593>, <-0.585792, -0.939829, -0.474393>, 
      <-0.424297, -0.528141, -0.199259>, <-0.433721, -0.544429, -0.207254>, <-0.586974, -0.942788, -0.475398>, <-0.585804, -0.939948, -0.474198>, 
      <-0.407237, -0.542240, -0.227239>, <-0.416832, -0.557923, -0.235220>, <-0.566183, -0.945628, -0.505091>, <-0.565010, -0.942848, -0.503931>, 
      <-0.406574, -0.543535, -0.227517>, <-0.416169, -0.559217, -0.235498>, <-0.566350, -0.945488, -0.505024>, <-0.565178, -0.942708, -0.503864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.424614, -0.528648, -0.197904>, <-0.424935, -0.529161, -0.196534>, <-0.418459, -0.560160, -0.179367>, <-0.417788, -0.561469, -0.179648>, 
      <-0.434038, -0.544937, -0.205900>, <-0.434359, -0.545450, -0.204530>, <-0.427190, -0.576406, -0.187844>, <-0.426520, -0.577715, -0.188125>, 
      <-0.586962, -0.942669, -0.475593>, <-0.586950, -0.942549, -0.475790>, <-0.568765, -0.971636, -0.462475>, <-0.568935, -0.971494, -0.462408>, 
      <-0.585792, -0.939829, -0.474393>, <-0.585780, -0.939709, -0.474590>, <-0.567607, -0.968831, -0.461247>, <-0.567776, -0.968689, -0.461180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.142374, -0.261387, -0.103416>, <-0.219461, -0.356378, -0.134944>, <-0.391958, -0.565032, -0.201448>, <-0.399331, -0.578025, -0.208509>, 
      <-0.152426, -0.262737, -0.089809>, <-0.229513, -0.357728, -0.121337>, <-0.392278, -0.565543, -0.200082>, <-0.399651, -0.578537, -0.207143>, 
      <-0.165662, -0.238339, -0.071892>, <-0.241155, -0.340363, -0.104414>, <-0.409748, -0.549058, -0.172771>, <-0.417120, -0.562774, -0.179928>, 
      <-0.166142, -0.221387, -0.071242>, <-0.241636, -0.323412, -0.103764>, <-0.410416, -0.547753, -0.172491>, <-0.417788, -0.561469, -0.179648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.120054, -0.215199, -0.133628>, <-0.206010, -0.313700, -0.161795>, <-0.398199, -0.529848, -0.220552>, <-0.406574, -0.543535, -0.227517>, 
      <-0.119548, -0.233039, -0.134313>, <-0.205505, -0.331540, -0.162479>, <-0.397496, -0.531222, -0.220847>, <-0.405871, -0.544909, -0.227812>, 
      <-0.131795, -0.259967, -0.117736>, <-0.208882, -0.354958, -0.149264>, <-0.391621, -0.564493, -0.202885>, <-0.398994, -0.577487, -0.209946>, 
      <-0.142374, -0.261387, -0.103416>, <-0.219461, -0.356378, -0.134944>, <-0.391958, -0.565032, -0.201448>, <-0.399331, -0.578025, -0.208509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.144751, -0.177511, -0.100198>, <-0.228710, -0.282852, -0.129510>, <-0.416303, -0.514282, -0.190853>, <-0.424614, -0.528648, -0.197904>, 
      <-0.134781, -0.176172, -0.113693>, <-0.218740, -0.281514, -0.143005>, <-0.415986, -0.513775, -0.192207>, <-0.424297, -0.528141, -0.199259>, 
      <-0.120531, -0.198386, -0.132983>, <-0.206486, -0.296887, -0.161150>, <-0.398862, -0.528553, -0.220273>, <-0.407237, -0.542240, -0.227239>, 
      <-0.120054, -0.215199, -0.133628>, <-0.206010, -0.313700, -0.161795>, <-0.398199, -0.529848, -0.220552>, <-0.406574, -0.543535, -0.227517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.144751, -0.177511, -0.100198>, <-0.154836, -0.178865, -0.086547>, <-0.166624, -0.204380, -0.070589>, <-0.166142, -0.221387, -0.071242>, 
      <-0.228710, -0.282852, -0.129510>, <-0.238795, -0.284206, -0.115858>, <-0.242118, -0.306405, -0.103111>, <-0.241636, -0.323412, -0.103764>, 
      <-0.416303, -0.514282, -0.190853>, <-0.416624, -0.514796, -0.189482>, <-0.411087, -0.546443, -0.172210>, <-0.410416, -0.547753, -0.172491>, 
      <-0.424614, -0.528648, -0.197904>, <-0.424935, -0.529161, -0.196534>, <-0.418459, -0.560160, -0.179367>, <-0.417788, -0.561469, -0.179648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428774, 2.606231, 0.661995>, <0.432996, 2.618109, 0.664755>, <0.443796, 2.635799, 0.683887>, <0.443584, 2.629386, 0.695083>, 
      <0.428774, 2.606231, 0.661995>, <0.447100, 2.614107, 0.663107>, <0.458714, 2.631566, 0.682143>, <0.458502, 2.625153, 0.693339>, 
      <0.428774, 2.606231, 0.661995>, <0.447100, 2.614107, 0.663107>, <0.466075, 2.602645, 0.679288>, <0.465833, 2.595314, 0.692088>, 
      <0.428774, 2.606231, 0.661995>, <0.442878, 2.602229, 0.660346>, <0.461318, 2.588116, 0.676166>, <0.461075, 2.580784, 0.688966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428774, 2.606231, 0.661995>, <0.414228, 2.610358, 0.663695>, <0.392793, 2.607790, 0.683775>, <0.392543, 2.600229, 0.696976>, 
      <0.428774, 2.606231, 0.661995>, <0.418450, 2.622236, 0.666455>, <0.398941, 2.623986, 0.687122>, <0.398691, 2.616425, 0.700323>, 
      <0.428774, 2.606231, 0.661995>, <0.418450, 2.622236, 0.666455>, <0.426929, 2.640585, 0.685858>, <0.426717, 2.634172, 0.697055>, 
      <0.428774, 2.606231, 0.661995>, <0.432996, 2.618109, 0.664755>, <0.443796, 2.635799, 0.683887>, <0.443584, 2.629386, 0.695083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428774, 2.606231, 0.661995>, <0.414228, 2.610358, 0.663695>, <0.392793, 2.607790, 0.683775>, <0.392543, 2.600229, 0.696976>, 
      <0.442878, 2.602229, 0.660346>, <0.428332, 2.606356, 0.662047>, <0.398941, 2.623986, 0.687122>, <0.398691, 2.616425, 0.700323>, 
      <0.461318, 2.588116, 0.676166>, <0.466075, 2.602645, 0.679288>, <0.441634, 2.629939, 0.695311>, <0.426717, 2.634172, 0.697055>, 
      <0.461075, 2.580784, 0.688966>, <0.465833, 2.595314, 0.692088>, <0.458502, 2.625153, 0.693339>, <0.443584, 2.629386, 0.695083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.427689, 2.573445, 0.719235>, <0.433805, 2.591013, 0.722527>, <0.443273, 2.619998, 0.711473>, <0.443584, 2.629386, 0.695083>, 
      <0.427689, 2.573445, 0.719235>, <0.419615, 2.595040, 0.724185>, <0.426406, 2.624784, 0.713445>, <0.426717, 2.634172, 0.697055>, 
      <0.427689, 2.573445, 0.719235>, <0.419615, 2.595040, 0.724185>, <0.398446, 2.609048, 0.713202>, <0.398691, 2.616425, 0.700323>, 
      <0.427689, 2.573445, 0.719235>, <0.413499, 2.577471, 0.720894>, <0.392299, 2.592853, 0.709855>, <0.392543, 2.600229, 0.696976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.427689, 2.573445, 0.719235>, <0.433805, 2.591013, 0.722527>, <0.443273, 2.619998, 0.711473>, <0.443584, 2.629386, 0.695083>, 
      <0.413499, 2.577471, 0.720894>, <0.419615, 2.595040, 0.724185>, <0.443486, 2.626411, 0.700277>, <0.443796, 2.635799, 0.683887>, 
      <0.392299, 2.592853, 0.709855>, <0.392549, 2.600414, 0.696653>, <0.418450, 2.622236, 0.666455>, <0.432996, 2.618109, 0.664755>, 
      <0.392543, 2.600229, 0.696976>, <0.392793, 2.607790, 0.683775>, <0.414228, 2.610358, 0.663695>, <0.428774, 2.606231, 0.661995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.427689, 2.573445, 0.719235>, <0.433805, 2.591013, 0.722527>, <0.443273, 2.619998, 0.711473>, <0.443584, 2.629386, 0.695083>, 
      <0.427689, 2.573445, 0.719235>, <0.446900, 2.587298, 0.720996>, <0.458191, 2.615765, 0.709730>, <0.458502, 2.625153, 0.693339>, 
      <0.427689, 2.573445, 0.719235>, <0.446900, 2.587298, 0.720996>, <0.465607, 2.588507, 0.703972>, <0.465833, 2.595314, 0.692088>, 
      <0.427689, 2.573445, 0.719235>, <0.440784, 2.569730, 0.717704>, <0.460850, 2.573977, 0.700850>, <0.461075, 2.580784, 0.688966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.427689, 2.573445, 0.719235>, <0.440784, 2.569730, 0.717704>, <0.460850, 2.573977, 0.700850>, <0.461075, 2.580784, 0.688966>, 
      <0.413499, 2.577471, 0.720894>, <0.426594, 2.573756, 0.719363>, <0.465607, 2.588507, 0.703972>, <0.465833, 2.595314, 0.692088>, 
      <0.392299, 2.592853, 0.709855>, <0.398446, 2.609048, 0.713202>, <0.441634, 2.629939, 0.695311>, <0.458502, 2.625153, 0.693339>, 
      <0.392543, 2.600229, 0.696976>, <0.398691, 2.616425, 0.700323>, <0.426717, 2.634172, 0.697055>, <0.443584, 2.629386, 0.695083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.427689, 2.573445, 0.719235>, <0.440784, 2.569730, 0.717704>, <0.460850, 2.573977, 0.700850>, <0.461075, 2.580784, 0.688966>, 
      <0.433805, 2.591013, 0.722527>, <0.446900, 2.587298, 0.720996>, <0.461092, 2.581309, 0.688050>, <0.461318, 2.588116, 0.676166>, 
      <0.443273, 2.619998, 0.711473>, <0.443486, 2.626411, 0.700277>, <0.447100, 2.614107, 0.663107>, <0.442878, 2.602229, 0.660346>, 
      <0.443584, 2.629386, 0.695083>, <0.443796, 2.635799, 0.683887>, <0.432996, 2.618109, 0.664755>, <0.428774, 2.606231, 0.661995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.361250, 2.392874, 0.650769>, <0.380925, 2.448197, 0.668262>, <0.407855, 2.516469, 0.708560>, <0.427689, 2.573445, 0.719235>, 
      <0.358948, 2.393478, 0.651293>, <0.378623, 2.448801, 0.668785>, <0.393664, 2.520495, 0.710218>, <0.413499, 2.577471, 0.720894>, 
      <0.355440, 2.396060, 0.649229>, <0.371366, 2.455802, 0.664459>, <0.370113, 2.534402, 0.697775>, <0.392299, 2.592853, 0.709855>, 
      <0.355480, 2.397271, 0.647115>, <0.371406, 2.457013, 0.662345>, <0.370357, 2.541778, 0.684897>, <0.392543, 2.600229, 0.696976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.366623, 2.394345, 0.644581>, <0.390857, 2.451662, 0.659946>, <0.441532, 2.521100, 0.676142>, <0.461075, 2.580784, 0.688966>, 
      <0.366582, 2.393104, 0.646748>, <0.390815, 2.450420, 0.662113>, <0.441307, 2.514293, 0.688026>, <0.460850, 2.573977, 0.700850>, 
      <0.363610, 2.392254, 0.650232>, <0.383284, 2.447577, 0.667725>, <0.420949, 2.512753, 0.707029>, <0.440784, 2.569730, 0.717704>, 
      <0.361250, 2.392874, 0.650769>, <0.380925, 2.448197, 0.668262>, <0.407855, 2.516469, 0.708560>, <0.427689, 2.573445, 0.719235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.361429, 2.398256, 0.641373>, <0.382035, 2.459801, 0.652636>, <0.407222, 2.545599, 0.647905>, <0.428774, 2.606231, 0.661995>, 
      <0.363484, 2.397717, 0.640906>, <0.384089, 2.459262, 0.652169>, <0.421326, 2.541597, 0.646257>, <0.442878, 2.602229, 0.660346>, 
      <0.366659, 2.395426, 0.642694>, <0.390893, 2.452743, 0.658059>, <0.441775, 2.528432, 0.663342>, <0.461318, 2.588116, 0.676166>, 
      <0.366623, 2.394345, 0.644581>, <0.390857, 2.451662, 0.659946>, <0.441532, 2.521100, 0.676142>, <0.461075, 2.580784, 0.688966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.361429, 2.398256, 0.641373>, <0.359069, 2.398876, 0.641910>, <0.355521, 2.398512, 0.644948>, <0.355480, 2.397271, 0.647115>, 
      <0.382035, 2.459801, 0.652636>, <0.379675, 2.460421, 0.653173>, <0.371447, 2.458254, 0.660178>, <0.371406, 2.457013, 0.662345>, 
      <0.407222, 2.545599, 0.647905>, <0.392676, 2.549726, 0.649605>, <0.370607, 2.549340, 0.671695>, <0.370357, 2.541778, 0.684897>, 
      <0.428774, 2.606231, 0.661995>, <0.414228, 2.610358, 0.663695>, <0.392793, 2.607790, 0.683775>, <0.392543, 2.600229, 0.696976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.350703, 2.356973, 0.650788>, <0.354271, 2.367191, 0.653768>, <0.357645, 2.382738, 0.647564>, <0.361250, 2.392874, 0.650769>, 
      <0.343074, 2.358976, 0.652523>, <0.346642, 2.369194, 0.655504>, <0.355343, 2.383342, 0.648088>, <0.358948, 2.393478, 0.651293>, 
      <0.331447, 2.367532, 0.645684>, <0.335094, 2.377281, 0.648692>, <0.352730, 2.385895, 0.646638>, <0.355440, 2.396060, 0.649229>, 
      <0.331580, 2.371546, 0.638677>, <0.335227, 2.381294, 0.641684>, <0.352770, 2.387106, 0.644524>, <0.355480, 2.397271, 0.647115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.368509, 2.361849, 0.630277>, <0.371737, 2.371548, 0.633323>, <0.362590, 2.384807, 0.642024>, <0.366623, 2.394345, 0.644581>, 
      <0.368373, 2.357735, 0.637460>, <0.371601, 2.367434, 0.640505>, <0.362549, 2.383566, 0.644191>, <0.366582, 2.393104, 0.646748>, 
      <0.358523, 2.354919, 0.649009>, <0.362091, 2.365137, 0.651989>, <0.360005, 2.382118, 0.647027>, <0.363610, 2.392254, 0.650232>, 
      <0.350703, 2.356973, 0.650788>, <0.354271, 2.367191, 0.653768>, <0.357645, 2.382738, 0.647564>, <0.361250, 2.392874, 0.650769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.351294, 2.374811, 0.619644>, <0.354509, 2.383866, 0.622625>, <0.358282, 2.388857, 0.639653>, <0.361429, 2.398256, 0.641373>, 
      <0.358104, 2.373023, 0.618095>, <0.361318, 2.382078, 0.621076>, <0.360337, 2.388317, 0.639186>, <0.363484, 2.397717, 0.640906>, 
      <0.368628, 2.365432, 0.624022>, <0.371856, 2.375131, 0.627068>, <0.362626, 2.385888, 0.640137>, <0.366659, 2.395426, 0.642694>, 
      <0.368509, 2.361849, 0.630277>, <0.371737, 2.371548, 0.633323>, <0.362590, 2.384807, 0.642024>, <0.366623, 2.394345, 0.644581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.351294, 2.374811, 0.619644>, <0.343474, 2.376864, 0.621423>, <0.331716, 2.375660, 0.631494>, <0.331580, 2.371546, 0.638677>, 
      <0.354509, 2.383866, 0.622625>, <0.346688, 2.385919, 0.624403>, <0.335363, 2.385409, 0.634501>, <0.335227, 2.381294, 0.641684>, 
      <0.358282, 2.388857, 0.639653>, <0.355922, 2.389476, 0.640189>, <0.352812, 2.388348, 0.642356>, <0.352770, 2.387106, 0.644524>, 
      <0.361429, 2.398256, 0.641373>, <0.359069, 2.398876, 0.641910>, <0.355521, 2.398512, 0.644948>, <0.355480, 2.397271, 0.647115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.182890, 1.882081, 0.501785>, <0.285443, 2.152842, 0.631212>, <0.300621, 2.213546, 0.608954>, <0.350703, 2.356973, 0.650788>, 
      <0.170316, 1.885383, 0.504645>, <0.272869, 2.156144, 0.634072>, <0.292992, 2.215549, 0.610690>, <0.343074, 2.358976, 0.652523>, 
      <0.167011, 1.887400, 0.503415>, <0.268963, 2.159015, 0.632535>, <0.278341, 2.225562, 0.601888>, <0.331447, 2.367532, 0.645684>, 
      <0.167230, 1.894015, 0.491866>, <0.269182, 2.165630, 0.620985>, <0.278474, 2.229575, 0.594881>, <0.331580, 2.371546, 0.638677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.197473, 1.886074, 0.484987>, <0.300831, 2.157378, 0.613816>, <0.320751, 2.218343, 0.585217>, <0.368509, 2.361849, 0.630277>, 
      <0.197248, 1.879293, 0.496827>, <0.300606, 2.150597, 0.625656>, <0.320615, 2.214229, 0.592400>, <0.368373, 2.357735, 0.637460>, 
      <0.195780, 1.878696, 0.498853>, <0.298334, 2.149457, 0.628280>, <0.308441, 2.211492, 0.607175>, <0.358523, 2.354919, 0.649009>, 
      <0.182890, 1.882081, 0.501785>, <0.285443, 2.152842, 0.631212>, <0.300621, 2.213546, 0.608954>, <0.350703, 2.356973, 0.650788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.183374, 1.896690, 0.476279>, <0.286188, 2.168750, 0.604837>, <0.300812, 2.232606, 0.572836>, <0.351294, 2.374811, 0.619644>, 
      <0.194599, 1.893743, 0.473726>, <0.297413, 2.165802, 0.602283>, <0.307621, 2.230818, 0.571287>, <0.358104, 2.373023, 0.618095>, 
      <0.197669, 1.891979, 0.474677>, <0.301026, 2.163284, 0.603506>, <0.320870, 2.221925, 0.578962>, <0.368628, 2.365432, 0.624022>, 
      <0.197473, 1.886074, 0.484987>, <0.300831, 2.157378, 0.613816>, <0.320751, 2.218343, 0.585217>, <0.368509, 2.361849, 0.630277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.183374, 1.896690, 0.476279>, <0.170484, 1.900075, 0.479211>, <0.167455, 1.900796, 0.480027>, <0.167230, 1.894015, 0.491866>, 
      <0.286188, 2.168750, 0.604837>, <0.273298, 2.172134, 0.607768>, <0.269407, 2.172411, 0.609146>, <0.269182, 2.165630, 0.620985>, 
      <0.300812, 2.232606, 0.572836>, <0.292991, 2.234660, 0.574615>, <0.278610, 2.233690, 0.587698>, <0.278474, 2.229575, 0.594881>, 
      <0.351294, 2.374811, 0.619644>, <0.343474, 2.376864, 0.621423>, <0.331716, 2.375660, 0.631494>, <0.331580, 2.371546, 0.638677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.025071, 1.497240, 0.239826>, <0.072417, 1.612692, 0.318414>, <0.086914, 1.628685, 0.380659>, <0.182890, 1.882081, 0.501785>, 
      <0.018350, 1.499005, 0.241355>, <0.065695, 1.614457, 0.319942>, <0.074340, 1.631987, 0.383519>, <0.170316, 1.885383, 0.504645>, 
      <0.008106, 1.506543, 0.235330>, <0.055808, 1.621724, 0.314142>, <0.071706, 1.633495, 0.382715>, <0.167011, 1.887400, 0.503415>, 
      <0.008223, 1.510079, 0.229156>, <0.055925, 1.625260, 0.307969>, <0.071925, 1.640110, 0.371165>, <0.167230, 1.894015, 0.491866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.040759, 1.501536, 0.221756>, <0.087773, 1.616897, 0.300725>, <0.100874, 1.632509, 0.364581>, <0.197473, 1.886074, 0.484987>, 
      <0.040639, 1.497911, 0.228084>, <0.087653, 1.613273, 0.307053>, <0.100649, 1.625728, 0.376421>, <0.197248, 1.879293, 0.496827>, 
      <0.031961, 1.495431, 0.238259>, <0.079307, 1.610883, 0.316847>, <0.099804, 1.625301, 0.377727>, <0.195780, 1.878696, 0.498853>, 
      <0.025071, 1.497240, 0.239826>, <0.072417, 1.612692, 0.318414>, <0.086914, 1.628685, 0.380659>, <0.182890, 1.882081, 0.501785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.025592, 1.512956, 0.212388>, <0.072927, 1.628076, 0.291555>, <0.087378, 1.642672, 0.356247>, <0.183374, 1.896690, 0.476279>, 
      <0.031592, 1.511381, 0.211023>, <0.078926, 1.626501, 0.290191>, <0.098603, 1.639725, 0.353693>, <0.194599, 1.893743, 0.473726>, 
      <0.040864, 1.504692, 0.216246>, <0.087878, 1.620054, 0.295215>, <0.101069, 1.638414, 0.354272>, <0.197669, 1.891979, 0.474677>, 
      <0.040759, 1.501536, 0.221756>, <0.087773, 1.616897, 0.300725>, <0.100874, 1.632509, 0.364581>, <0.197473, 1.886074, 0.484987>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.025592, 1.512956, 0.212388>, <0.018702, 1.514765, 0.213955>, <0.008343, 1.513704, 0.222828>, <0.008223, 1.510079, 0.229156>, 
      <0.072927, 1.628076, 0.291555>, <0.066037, 1.629885, 0.293122>, <0.056045, 1.628885, 0.301641>, <0.055925, 1.625260, 0.307969>, 
      <0.087378, 1.642672, 0.356247>, <0.074488, 1.646056, 0.359179>, <0.072150, 1.646891, 0.359326>, <0.071925, 1.640110, 0.371165>, 
      <0.183374, 1.896690, 0.476279>, <0.170484, 1.900075, 0.479211>, <0.167455, 1.900796, 0.480027>, <0.167230, 1.894015, 0.491866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.474311, 2.606231, 0.667508>, <-0.478533, 2.618109, 0.670268>, <-0.489333, 2.635799, 0.689400>, <-0.489121, 2.629386, 0.700596>, 
      <-0.474311, 2.606231, 0.667508>, <-0.492637, 2.614107, 0.668620>, <-0.504251, 2.631566, 0.687656>, <-0.504039, 2.625153, 0.698852>, 
      <-0.474311, 2.606231, 0.667508>, <-0.492637, 2.614107, 0.668620>, <-0.511612, 2.602645, 0.684801>, <-0.511370, 2.595314, 0.697601>, 
      <-0.474311, 2.606231, 0.667508>, <-0.488415, 2.602229, 0.665860>, <-0.506855, 2.588116, 0.681679>, <-0.506612, 2.580784, 0.694479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.474311, 2.606231, 0.667508>, <-0.459765, 2.610358, 0.669208>, <-0.438330, 2.607790, 0.689288>, <-0.438080, 2.600229, 0.702489>, 
      <-0.474311, 2.606231, 0.667508>, <-0.463987, 2.622236, 0.671968>, <-0.444478, 2.623986, 0.692635>, <-0.444228, 2.616425, 0.705836>, 
      <-0.474311, 2.606231, 0.667508>, <-0.463987, 2.622236, 0.671968>, <-0.472466, 2.640585, 0.691371>, <-0.472254, 2.634172, 0.702568>, 
      <-0.474311, 2.606231, 0.667508>, <-0.478533, 2.618109, 0.670268>, <-0.489333, 2.635799, 0.689400>, <-0.489121, 2.629386, 0.700596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.474311, 2.606231, 0.667508>, <-0.459765, 2.610358, 0.669208>, <-0.438330, 2.607790, 0.689288>, <-0.438080, 2.600229, 0.702489>, 
      <-0.488415, 2.602229, 0.665860>, <-0.473869, 2.606356, 0.667560>, <-0.444478, 2.623986, 0.692635>, <-0.444228, 2.616425, 0.705836>, 
      <-0.506855, 2.588116, 0.681679>, <-0.511612, 2.602645, 0.684801>, <-0.487171, 2.629939, 0.700824>, <-0.472254, 2.634172, 0.702568>, 
      <-0.506612, 2.580784, 0.694479>, <-0.511370, 2.595314, 0.697601>, <-0.504039, 2.625153, 0.698852>, <-0.489121, 2.629386, 0.700596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.473226, 2.573445, 0.724748>, <-0.479342, 2.591013, 0.728040>, <-0.488810, 2.619998, 0.716986>, <-0.489121, 2.629386, 0.700596>, 
      <-0.473226, 2.573445, 0.724748>, <-0.465152, 2.595040, 0.729698>, <-0.471943, 2.624784, 0.718958>, <-0.472254, 2.634172, 0.702568>, 
      <-0.473226, 2.573445, 0.724748>, <-0.465152, 2.595040, 0.729698>, <-0.443983, 2.609048, 0.718715>, <-0.444228, 2.616425, 0.705836>, 
      <-0.473226, 2.573445, 0.724748>, <-0.459036, 2.577471, 0.726407>, <-0.437836, 2.592853, 0.715368>, <-0.438080, 2.600229, 0.702489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.473226, 2.573445, 0.724748>, <-0.479342, 2.591013, 0.728040>, <-0.488810, 2.619998, 0.716986>, <-0.489121, 2.629386, 0.700596>, 
      <-0.459036, 2.577471, 0.726407>, <-0.465152, 2.595040, 0.729698>, <-0.489023, 2.626411, 0.705790>, <-0.489333, 2.635799, 0.689400>, 
      <-0.437836, 2.592853, 0.715368>, <-0.438086, 2.600414, 0.702166>, <-0.463987, 2.622236, 0.671968>, <-0.478533, 2.618109, 0.670268>, 
      <-0.438080, 2.600229, 0.702489>, <-0.438330, 2.607790, 0.689288>, <-0.459765, 2.610358, 0.669208>, <-0.474311, 2.606231, 0.667508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.473226, 2.573445, 0.724748>, <-0.479342, 2.591013, 0.728040>, <-0.488810, 2.619998, 0.716986>, <-0.489121, 2.629386, 0.700596>, 
      <-0.473226, 2.573445, 0.724748>, <-0.492437, 2.587298, 0.726509>, <-0.503728, 2.615765, 0.715243>, <-0.504039, 2.625153, 0.698852>, 
      <-0.473226, 2.573445, 0.724748>, <-0.492437, 2.587298, 0.726509>, <-0.511144, 2.588507, 0.709485>, <-0.511370, 2.595314, 0.697601>, 
      <-0.473226, 2.573445, 0.724748>, <-0.486321, 2.569730, 0.723217>, <-0.506387, 2.573977, 0.706363>, <-0.506612, 2.580784, 0.694479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.473226, 2.573445, 0.724748>, <-0.486321, 2.569730, 0.723217>, <-0.506387, 2.573977, 0.706363>, <-0.506612, 2.580784, 0.694479>, 
      <-0.459036, 2.577471, 0.726407>, <-0.472131, 2.573756, 0.724876>, <-0.511144, 2.588507, 0.709485>, <-0.511370, 2.595314, 0.697601>, 
      <-0.437836, 2.592853, 0.715368>, <-0.443983, 2.609048, 0.718715>, <-0.487171, 2.629939, 0.700824>, <-0.504039, 2.625153, 0.698852>, 
      <-0.438080, 2.600229, 0.702489>, <-0.444228, 2.616425, 0.705836>, <-0.472254, 2.634172, 0.702568>, <-0.489121, 2.629386, 0.700596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.473226, 2.573445, 0.724748>, <-0.486321, 2.569730, 0.723217>, <-0.506387, 2.573977, 0.706363>, <-0.506612, 2.580784, 0.694479>, 
      <-0.479342, 2.591013, 0.728040>, <-0.492437, 2.587298, 0.726509>, <-0.506629, 2.581309, 0.693563>, <-0.506855, 2.588116, 0.681679>, 
      <-0.488810, 2.619998, 0.716986>, <-0.489023, 2.626411, 0.705790>, <-0.492637, 2.614107, 0.668620>, <-0.488415, 2.602229, 0.665860>, 
      <-0.489121, 2.629386, 0.700596>, <-0.489333, 2.635799, 0.689400>, <-0.478533, 2.618109, 0.670268>, <-0.474311, 2.606231, 0.667508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.406787, 2.392874, 0.656282>, <-0.426462, 2.448197, 0.673775>, <-0.453392, 2.516469, 0.714073>, <-0.473226, 2.573445, 0.724748>, 
      <-0.404485, 2.393478, 0.656806>, <-0.424160, 2.448801, 0.674298>, <-0.439201, 2.520495, 0.715731>, <-0.459036, 2.577471, 0.726407>, 
      <-0.400977, 2.396060, 0.654742>, <-0.416903, 2.455802, 0.669972>, <-0.415650, 2.534402, 0.703288>, <-0.437836, 2.592853, 0.715368>, 
      <-0.401017, 2.397271, 0.652628>, <-0.416943, 2.457013, 0.667858>, <-0.415894, 2.541778, 0.690410>, <-0.438080, 2.600229, 0.702489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.412160, 2.394345, 0.650094>, <-0.436394, 2.451662, 0.665459>, <-0.487069, 2.521100, 0.681655>, <-0.506612, 2.580784, 0.694479>, 
      <-0.412119, 2.393104, 0.652261>, <-0.436352, 2.450420, 0.667626>, <-0.486844, 2.514293, 0.693539>, <-0.506387, 2.573977, 0.706363>, 
      <-0.409147, 2.392254, 0.655745>, <-0.428822, 2.447577, 0.673238>, <-0.466486, 2.512753, 0.712542>, <-0.486321, 2.569730, 0.723217>, 
      <-0.406787, 2.392874, 0.656282>, <-0.426462, 2.448197, 0.673775>, <-0.453392, 2.516469, 0.714073>, <-0.473226, 2.573445, 0.724748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.406966, 2.398256, 0.646886>, <-0.427572, 2.459801, 0.658149>, <-0.452759, 2.545599, 0.653418>, <-0.474311, 2.606231, 0.667508>, 
      <-0.409021, 2.397717, 0.646419>, <-0.429626, 2.459262, 0.657682>, <-0.466863, 2.541597, 0.651770>, <-0.488415, 2.602229, 0.665860>, 
      <-0.412196, 2.395426, 0.648207>, <-0.436430, 2.452743, 0.663572>, <-0.487312, 2.528432, 0.668855>, <-0.506855, 2.588116, 0.681679>, 
      <-0.412160, 2.394345, 0.650094>, <-0.436394, 2.451662, 0.665459>, <-0.487069, 2.521100, 0.681655>, <-0.506612, 2.580784, 0.694479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.406966, 2.398256, 0.646886>, <-0.404606, 2.398876, 0.647423>, <-0.401058, 2.398512, 0.650461>, <-0.401017, 2.397271, 0.652628>, 
      <-0.427572, 2.459801, 0.658149>, <-0.425212, 2.460421, 0.658686>, <-0.416984, 2.458254, 0.665691>, <-0.416943, 2.457013, 0.667858>, 
      <-0.452759, 2.545599, 0.653418>, <-0.438213, 2.549726, 0.655119>, <-0.416144, 2.549340, 0.677208>, <-0.415894, 2.541778, 0.690410>, 
      <-0.474311, 2.606231, 0.667508>, <-0.459765, 2.610358, 0.669208>, <-0.438330, 2.607790, 0.689288>, <-0.438080, 2.600229, 0.702489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.396240, 2.356973, 0.656301>, <-0.399808, 2.367191, 0.659281>, <-0.403182, 2.382738, 0.653077>, <-0.406787, 2.392874, 0.656282>, 
      <-0.388611, 2.358976, 0.658036>, <-0.392179, 2.369194, 0.661017>, <-0.400880, 2.383342, 0.653601>, <-0.404485, 2.393478, 0.656806>, 
      <-0.376984, 2.367532, 0.651197>, <-0.380631, 2.377281, 0.654205>, <-0.398267, 2.385895, 0.652151>, <-0.400977, 2.396060, 0.654742>, 
      <-0.377117, 2.371546, 0.644190>, <-0.380764, 2.381294, 0.647197>, <-0.398307, 2.387106, 0.650037>, <-0.401017, 2.397271, 0.652628>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.414046, 2.361849, 0.635790>, <-0.417274, 2.371548, 0.638836>, <-0.408127, 2.384807, 0.647537>, <-0.412160, 2.394345, 0.650094>, 
      <-0.413910, 2.357735, 0.642973>, <-0.417138, 2.367434, 0.646019>, <-0.408086, 2.383566, 0.649704>, <-0.412119, 2.393104, 0.652261>, 
      <-0.404060, 2.354919, 0.654522>, <-0.407628, 2.365137, 0.657502>, <-0.405542, 2.382118, 0.652540>, <-0.409147, 2.392254, 0.655745>, 
      <-0.396240, 2.356973, 0.656301>, <-0.399808, 2.367191, 0.659281>, <-0.403182, 2.382738, 0.653077>, <-0.406787, 2.392874, 0.656282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.396831, 2.374811, 0.625157>, <-0.400046, 2.383866, 0.628138>, <-0.403819, 2.388857, 0.645166>, <-0.406966, 2.398256, 0.646886>, 
      <-0.403641, 2.373023, 0.623608>, <-0.406855, 2.382078, 0.626589>, <-0.405874, 2.388317, 0.644699>, <-0.409021, 2.397717, 0.646419>, 
      <-0.414165, 2.365432, 0.629535>, <-0.417393, 2.375131, 0.632581>, <-0.408163, 2.385888, 0.645650>, <-0.412196, 2.395426, 0.648207>, 
      <-0.414046, 2.361849, 0.635790>, <-0.417274, 2.371548, 0.638836>, <-0.408127, 2.384807, 0.647537>, <-0.412160, 2.394345, 0.650094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.396831, 2.374811, 0.625157>, <-0.389011, 2.376864, 0.626936>, <-0.377253, 2.375660, 0.637007>, <-0.377117, 2.371546, 0.644190>, 
      <-0.400046, 2.383866, 0.628138>, <-0.392225, 2.385919, 0.629916>, <-0.380900, 2.385409, 0.640014>, <-0.380764, 2.381294, 0.647197>, 
      <-0.403819, 2.388857, 0.645166>, <-0.401459, 2.389476, 0.645702>, <-0.398349, 2.388348, 0.647869>, <-0.398307, 2.387106, 0.650037>, 
      <-0.406966, 2.398256, 0.646886>, <-0.404606, 2.398876, 0.647423>, <-0.401058, 2.398512, 0.650461>, <-0.401017, 2.397271, 0.652628>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.228427, 1.882081, 0.507298>, <-0.330980, 2.152842, 0.636725>, <-0.346158, 2.213546, 0.614467>, <-0.396240, 2.356973, 0.656301>, 
      <-0.215853, 1.885383, 0.510158>, <-0.318406, 2.156144, 0.639585>, <-0.338529, 2.215549, 0.616203>, <-0.388611, 2.358976, 0.658036>, 
      <-0.212548, 1.887400, 0.508928>, <-0.314500, 2.159015, 0.638048>, <-0.323878, 2.225562, 0.607401>, <-0.376984, 2.367532, 0.651197>, 
      <-0.212767, 1.894015, 0.497379>, <-0.314719, 2.165630, 0.626498>, <-0.324011, 2.229575, 0.600394>, <-0.377117, 2.371546, 0.644190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.243010, 1.886074, 0.490500>, <-0.346368, 2.157378, 0.619329>, <-0.366288, 2.218343, 0.590730>, <-0.414046, 2.361849, 0.635790>, 
      <-0.242785, 1.879293, 0.502340>, <-0.346143, 2.150597, 0.631169>, <-0.366152, 2.214229, 0.597913>, <-0.413910, 2.357735, 0.642973>, 
      <-0.241317, 1.878696, 0.504366>, <-0.343871, 2.149457, 0.633793>, <-0.353978, 2.211492, 0.612688>, <-0.404060, 2.354919, 0.654522>, 
      <-0.228427, 1.882081, 0.507298>, <-0.330980, 2.152842, 0.636725>, <-0.346158, 2.213546, 0.614467>, <-0.396240, 2.356973, 0.656301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.228911, 1.896690, 0.481792>, <-0.331725, 2.168750, 0.610350>, <-0.346349, 2.232606, 0.578349>, <-0.396831, 2.374811, 0.625157>, 
      <-0.240136, 1.893743, 0.479239>, <-0.342950, 2.165802, 0.607796>, <-0.353158, 2.230818, 0.576801>, <-0.403641, 2.373023, 0.623608>, 
      <-0.243206, 1.891979, 0.480190>, <-0.346563, 2.163284, 0.609020>, <-0.366407, 2.221925, 0.584475>, <-0.414165, 2.365432, 0.629535>, 
      <-0.243010, 1.886074, 0.490500>, <-0.346368, 2.157378, 0.619329>, <-0.366288, 2.218343, 0.590730>, <-0.414046, 2.361849, 0.635790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.228911, 1.896690, 0.481792>, <-0.216021, 1.900075, 0.484724>, <-0.212992, 1.900796, 0.485540>, <-0.212767, 1.894015, 0.497379>, 
      <-0.331725, 2.168750, 0.610350>, <-0.318835, 2.172134, 0.613282>, <-0.314944, 2.172411, 0.614659>, <-0.314719, 2.165630, 0.626498>, 
      <-0.346349, 2.232606, 0.578349>, <-0.338528, 2.234660, 0.580128>, <-0.324147, 2.233690, 0.593211>, <-0.324011, 2.229575, 0.600394>, 
      <-0.396831, 2.374811, 0.625157>, <-0.389011, 2.376864, 0.626936>, <-0.377253, 2.375660, 0.637007>, <-0.377117, 2.371546, 0.644190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.070608, 1.497240, 0.245339>, <-0.117954, 1.612692, 0.323927>, <-0.132451, 1.628685, 0.386172>, <-0.228427, 1.882081, 0.507298>, 
      <-0.063887, 1.499005, 0.246868>, <-0.111232, 1.614457, 0.325455>, <-0.119877, 1.631987, 0.389032>, <-0.215853, 1.885383, 0.510158>, 
      <-0.053643, 1.506543, 0.240842>, <-0.101345, 1.621724, 0.319655>, <-0.117243, 1.633495, 0.388228>, <-0.212548, 1.887400, 0.508928>, 
      <-0.053760, 1.510079, 0.234669>, <-0.101462, 1.625260, 0.313482>, <-0.117462, 1.640110, 0.376679>, <-0.212767, 1.894015, 0.497379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.086296, 1.501536, 0.227269>, <-0.133310, 1.616897, 0.306238>, <-0.146411, 1.632509, 0.370094>, <-0.243010, 1.886074, 0.490500>, 
      <-0.086176, 1.497911, 0.233597>, <-0.133190, 1.613273, 0.312567>, <-0.146186, 1.625728, 0.381934>, <-0.242785, 1.879293, 0.502340>, 
      <-0.077498, 1.495431, 0.243772>, <-0.124844, 1.610883, 0.322360>, <-0.145341, 1.625301, 0.383240>, <-0.241317, 1.878696, 0.504366>, 
      <-0.070608, 1.497240, 0.245339>, <-0.117954, 1.612692, 0.323927>, <-0.132451, 1.628685, 0.386172>, <-0.228427, 1.882081, 0.507298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.071129, 1.512956, 0.217901>, <-0.118464, 1.628076, 0.297068>, <-0.132915, 1.642672, 0.361760>, <-0.228911, 1.896690, 0.481792>, 
      <-0.077129, 1.511381, 0.216536>, <-0.124463, 1.626501, 0.295704>, <-0.144140, 1.639725, 0.359206>, <-0.240136, 1.893743, 0.479239>, 
      <-0.086401, 1.504692, 0.221759>, <-0.133415, 1.620054, 0.300728>, <-0.146606, 1.638414, 0.359785>, <-0.243206, 1.891979, 0.480190>, 
      <-0.086296, 1.501536, 0.227269>, <-0.133310, 1.616897, 0.306238>, <-0.146411, 1.632509, 0.370094>, <-0.243010, 1.886074, 0.490500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.071129, 1.512956, 0.217901>, <-0.064239, 1.514765, 0.219468>, <-0.053880, 1.513704, 0.228341>, <-0.053760, 1.510079, 0.234669>, 
      <-0.118464, 1.628076, 0.297068>, <-0.111574, 1.629885, 0.298635>, <-0.101582, 1.628885, 0.307154>, <-0.101462, 1.625260, 0.313482>, 
      <-0.132915, 1.642672, 0.361760>, <-0.120025, 1.646056, 0.364692>, <-0.117687, 1.646891, 0.364839>, <-0.117462, 1.640110, 0.376679>, 
      <-0.228911, 1.896690, 0.481792>, <-0.216021, 1.900075, 0.484724>, <-0.212992, 1.900796, 0.485540>, <-0.212767, 1.894015, 0.497379>
    }
  }
}
#declare sPatchGroup = union {
  object { sPatchObj }
  object { sPatchObj1 }
  scale 2.0
  translate  -0.8*y
}
#declare BFly = union {
  object { KRILA }
  object { sPatchGroup }
  material {
    TICALA
  }
  scale 0.01
  rotate 65.0*z
  translate  <-8.08, -11.36, 0.36>
}

union { // BFlys
  object { // BFly1->BFly
    BFly
    rotate <16.102114, -25.658905, 56.309933>
    translate  <-14.59, -0.45, 6.61>
  }
  object { BFly }
  translate  <0.95, -2.13, -0.21>
}
