#include "chimney.pov"
#include "left_building_add.inc"

// ********  REFERENCED OBJECTS  *******

#declare Torus010 = object {
  torus { // Torus010
    0.07, 0.01  rotate -x*90
    rotate -90.0*y
    translate  <4.1, 0.2, 5.3>
  }
}
#declare Torus011 = object {
  object { // Torus011->Torus010
    Torus010
    rotate <-0.0, -0.0, 0.0>
    translate  0.2*y
  }
}
#declare Fence_Circles2_side = union {
  object { Torus010 }
  object { Torus011 }
  object { // Torus012->Torus011
    Torus011
    translate  0.2*y
  }
  translate  -0.9*y
}
#declare Torus001 = object {
  torus { // Torus001
    0.07, 0.01  rotate -x*90
    rotate -90.0*x
    translate  <6.2, 0.0, 5.3>
  }
}
#declare Fence_Circles = union {
  object { Torus001 }
  object { // Torus002->Torus001
    Torus001
    translate  0.185*x
  }
  object { // Torus003->Torus001
    Torus001
    translate  0.37*x
  }
  object { // Torus004->Torus001
    Torus001
    translate  0.555*x
  }
  object { // Torus005->Torus001
    Torus001
    translate  0.74*x
  }
  object { // Torus006->Torus001
    Torus001
    translate  0.925*x
  }
  object { // Torus007->Torus001
    Torus001
    translate  1.11*x
  }
  object { // Torus008->Torus001
    Torus001
    translate  1.295*x
  }
  object { // Torus009->Torus001
    Torus001
    translate  1.48*x
  }
  translate  -0.9*y
}
#declare Cylndr021 = object {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.8>
    translate  <4.1, -0.7, 4.4>
  }
}
#declare Little_fence2 = union {
  object { Cylndr021 }
  object { // Cylndr022->Cylndr021
    Cylndr021
    rotate -0.0*y
    translate  0.2*y
  }
  object { // Cylndr023->Cylndr021
    Cylndr021
    rotate -0.0*y
    translate  0.4*y
  }
}
#declare Cylndr012 = object {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.8>
    translate  <4.3, -0.9, 4.4>
  }
}
#declare Little_fence = union {
  object { Cylndr012 }
  object { // Cylndr013->Cylndr012
    Cylndr012
    rotate -0.0*y
    translate  0.185*x
  }
  object { // Cylndr014->Cylndr012
    Cylndr012
    rotate -0.0*y
    translate  0.37*x
  }
  object { // Cylndr015->Cylndr012
    Cylndr012
    rotate -0.0*y
    translate  0.555*x
  }
  object { // Cylndr016->Cylndr012
    Cylndr012
    rotate -0.0*y
    translate  0.74*x
  }
  object { // Cylndr017->Cylndr012
    Cylndr012
    rotate -0.0*y
    translate  0.925*x
  }
  object { // Cylndr018->Cylndr012
    Cylndr012
    rotate -0.0*y
    translate  1.11*x
  }
  object { // Cylndr019->Cylndr012
    Cylndr012
    rotate -0.0*y
    translate  1.295*x
  }
  object { // Cylndr020->Cylndr012
    Cylndr012
    rotate -0.0*y
    translate  1.48*x
  }
}
#declare Cylndr040 = object {
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.025, 1.65>
    translate  <6.025, 0.1, 1.175>
  }
}
#declare Cylndr042 = object {
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.025, 1.25>
    rotate -90.0*y
    translate  <6.625, 0.1, 1.975>
  }
}
#declare CSG006 = difference {
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <0.14, 0.14, 0.15>
    translate  <8.27, 0.0, 7.44>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.2>
    translate  <8.27, 0.0, 7.42>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    translate  <8.27, 0.1, 7.52>
  }
}
#declare CSG007 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.12, 0.075>
    translate  <8.4, 0.12, 7.515>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.12, 0.075>
    translate  <8.14, 0.12, 7.515>
  }
  object { CSG006 }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.01, 0.08>
    translate  <8.42, 0.23, 7.515>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.01, 0.08>
    translate  <8.12, 0.23, 7.515>
  }
  translate  -0.24*y
}
#declare W_DRZ = union {
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale 0.01
    rotate -90.0*x
    translate  <8.115, -0.03, 7.56>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    scale 0.01
    rotate -90.0*x
    translate  <8.115, -0.03, 7.47>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale 0.01
    rotate -90.0*x
    translate  <8.425, -0.03, 7.47>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale 0.01
    rotate -90.0*x
    translate  <8.425, -0.03, 7.56>
  }
  object { CSG007 }
}

//
// ********  OBJECTS  *******
//

#declare F_Elements = union {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    translate  <6.0, -0.9, 4.4>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate  <4.1, 0.1, 5.2>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate  <7.9, 0.1, 5.2>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 3.8>
    rotate -90.0*y
    translate  <7.9, -0.9, 5.2>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.03
    translate  <7.9, -0.9, 5.4>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.03
    translate  <4.1, -0.9, 5.4>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    translate  <7.9, -0.9, 4.4>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    translate  <4.1, -0.9, 4.4>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    translate  <7.9, -0.1, 4.4>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate  <7.9, 0.1, 5.4>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate  <4.1, 0.1, 5.4>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 3.8>
    rotate -90.0*y
    translate  <7.9, -0.9, 5.4>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    translate  <4.1, -0.1, 4.4>
  }
}
#declare Complete_Fence = union {
  object { F_Elements }
  object { // Fence_Circles2_side1->Fence_Circles2_side
    Fence_Circles2_side
    translate  3.8*x
  }
  object { Fence_Circles2_side }
  object { // Fence_Circles1->Fence_Circles
    Fence_Circles
    translate  -1.9*x
  }
  object { Fence_Circles }
  object { // Little_fence3->Little_fence2
    Little_fence2
    translate  3.8*x
  }
  object { Little_fence2 }
  object { // Little_fence1->Little_fence
    Little_fence
    translate  1.9*x
  }
  object { Little_fence }
  texture { Fence_Metal01 }
  translate  -0.35*z
}
#declare BElements01 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 5.0, 4.0>
    translate  <0.0, 5.0, 4.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.0, 1.6>
    translate  <6.0, 0.9, 5.6>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 1.0, 1.0>
    translate  <6.0, 0.9, 2.2>
  }
  object {   
    height_field {
      tga "hf01.tga"
    }
    rotate    <-90, 0, 0> 
    scale     <  2, 2,-2> 
    translate < -1,-1,-1> 
    scale <1.8, 1.8, 0.105>
    rotate -90.0*x
    translate  <4.14, 0.1, 2.6>
  }
}
#declare MDoors = union {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.02, 0.5>
    translate  <5.5, 0.2, 5.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.05, 0.5>
    translate  <5.5, 0.2, 5.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.05, 0.08>
    translate  <5.5, 0.2, 5.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.02, 0.1>
    translate  <5.5, 0.2, 5.0>
  }
}
#declare ODoors = union {
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.05, 0.8>
    rotate -90.0*y
    translate  <5.9, 0.2, 7.2>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.05, 0.8>
    rotate -90.0*y
    translate  <5.9, 0.2, 5.6>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.05, 1.6>
    translate  <5.9, 0.2, 5.6>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.05, 1.6>
    translate  <5.1, 0.2, 5.6>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.05, 1.0>
    translate  <5.1, 0.2, 4.5>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.05, 1.0>
    translate  <5.9, 0.2, 4.5>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.05, 0.8>
    rotate -90.0*y
    translate  <5.9, 0.2, 4.5>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.05, 0.8>
    rotate -90.0*y
    translate  <5.9, 0.2, 5.5>
  }
}
#declare DDoors = difference {
  box { // Doors
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 1.525>
    translate  <5.5, 0.2, 5.775>
  }
  box { // Doors1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.06, 0.8>
    translate  <5.5, 0.2, 6.4>
  }
  box { // Doors2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.1, 0.5>
    translate  <5.5, 0.1, 5.0>
  }
}
#declare O_Side_Door = union {
  box { // Door_Glass
    <-1, -1, -1>, <1, 1, 1>
    texture { Glass01 }
    scale <0.4, 0.01, 0.8>
    translate  <5.5, 0.2, 6.4>
  }
  object { MDoors }
  object { ODoors }
  object { DDoors }
}
#declare Complete_Door = union {
  object { SDoor }
  object { O_Side_Door }
  object { O_Side_Door translate 1*x}
  translate  -0.2*z
  texture { Wood01 scale 0.2 }
}
#declare IWin2 = difference {
  box { // Rbox6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 0.025, 0.9>
    translate  <6.0, 0.2, 5.9>
  }
  box { // Rbox7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.625, 0.05, 0.825>
    translate  <6.0, 0.2, 5.9>
  }
  translate  <0.0, -0.1, -3.9>
}
#declare OWin = union {
  object { // Cylndr047->Cylndr040
    Cylndr040
    rotate 0.0*y
    translate  -0.65*x
  }
  object { // Cylndr046->Cylndr040
    Cylndr040
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cylndr045->Cylndr042
    Cylndr042
    rotate <0.0, 0.0, 0.0>
    translate  -0.8*z
  }
  object { // Cylndr044->Cylndr042
    Cylndr042
    rotate <0.0, 0.0, 0.0>
    translate  0.85*z
  }
  object { // Cylndr043->Cylndr042
    Cylndr042
    translate  <0.0, 0.0, 0.05>
  }
  object { Cylndr042 }
  object { // Cylndr041->Cylndr040
    Cylndr040
    translate  -0.05*x
  }
  object { Cylndr040 }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.625, 0.025, 0.025>
    translate  <6.0, 0.1, 2.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.025, 0.825>
    translate  <6.0, 0.1, 2.0>
  }
  object { IWin2 }
  translate  3.6*z
}
#declare Window = union {
  object { SWin1 }
  object { OWin }
  box { // Window_Glass
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass01
    }
    scale <0.7, 0.01, 0.9>
    translate  <6.0, 0.1, 5.6>
  }
  texture { Wood01 }
  translate  -3.4*z
}
#declare W_DRZ_ALL = union {
  object { // W_DRZ2->W_DRZ
    W_DRZ
    translate  -6.19*z
  }
  object { // W_DRZ1->W_DRZ
    W_DRZ
    translate  -3.22*z
  }
  object { W_DRZ }
}
#declare CSG005 = difference {
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.6>
    rotate -90.0*y
    translate  <0.8, -0.42, 7.91>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.7>
    rotate -90.0*y
    translate  <0.85, -0.47, 7.86>
  }
}
#declare Water_ODV = union {
  object { CSG005 }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.6>
    rotate -90.0*y
    translate  <0.8, -0.09, 7.7>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.6>
    rotate -90.0*y
    translate  <0.8, -0.39, 7.7>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.15, 0.02>
    translate  <0.0, -0.24, 7.69>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.02, 0.13>
    translate  <0.0, -0.4, 7.83>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.02, 0.13>
    translate  <0.0, -0.08, 7.83>
  }
  scale <10.0, 1.0, 1.0>
  translate  2.0*x
}
#declare ODV_F_WATER = union {
  object { W_DRZ_ALL }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 7.5>
    translate  <8.27, -0.24, 0.17>
  }
  object { Water_ODV }
  texture { Metal01 }
}
#declare CSG001 = object {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RoofT
    }
    scale <10.0, 1.0, 1.0>
    rotate -45.0*x
  }
  scale <1.0, 3.6, 2.0>
  translate  <0.0, 5.0, 8.0>
}
#declare CSG002 = difference {
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.8>
    rotate -90.0*x
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 1.0>
    rotate -90.0*x
    translate  -0.1*y
  }
}
#declare CSG003 = union {
  object { CSG002 }
  torus { // Torus013
    0.175, 0.025  rotate -x*90
    rotate -90.0*x
  }
}
#declare CSG004 = difference {
  object { CSG003 }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.5, 0.1>
    translate  <0.0, 0.4, -0.1>
  }
}
#declare KP = union {
  object { CSG004 }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.8>
    rotate -90.0*x
    translate  0.175*x
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.02
    translate  0.175*x
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.02
    translate  -0.175*x
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.8>
    rotate -90.0*x
    translate  -0.175*x
  }
  rotate 5.0*x
  translate  <0.0, 4.2, 10.8>
}
#declare CL1 = union {
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.05, 2.5>
    translate  <6.45, 0.44, 4.6>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.05, 2.5>
    translate  <6.6, 0.44, 4.6>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.05, 2.5>
    translate  <6.74, 0.44, 4.6>
  }
  translate  <-1.38, 0.0, -0.01>
}
#declare CL = union {
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.05, 2.5>
    translate  <6.45, 0.44, 4.6>
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.05, 2.5>
    translate  <6.6, 0.44, 4.6>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.05, 2.5>
    translate  <6.74, 0.44, 4.6>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.05, 2.5>
    translate  <6.9, 0.44, 4.6>
  }
}
#declare ZAVJ = union {
  object { CL1 }
  object { CL }
  texture { Zav01 }
}
#declare CL2 = union {
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.05, 2.5>
    translate  <6.45, 0.44, 4.6>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.05, 2.5>
    translate  <6.6, 0.44, 4.6>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.05, 2.5>
    translate  <6.74, 0.44, 4.6>
  }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.38, -0.0, -7.1>
  rotate 10.0*y
  translate  <5.3, -0.15, 2.9>
}
#declare CL3 = union {
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.05, 2.5>
    translate  <6.6, 0.44, 4.6>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.05, 2.5>
    translate  <6.74, 0.44, 4.6>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.05, 2.5>
    translate  <6.9, 0.44, 4.6>
  }
  rotate -0.0*y
  translate  <-7.0, 0.0, -7.11>
  rotate -5.0*y
  translate  <6.7, 0.0, 2.91>
}
#declare ZAVJ1 = union {
  object { CL2 }
  object { CL3 }
  texture { Zav01 }
}

// ROOF GENERATORS --------------------
#declare Row =
union {
  #declare counter = 0;
  #declare max_count = 10;
  #while (counter<max_count)
     object { KP  translate <0,-0.52*counter,0> }
     #declare counter = counter +1;
  #end
  texture {
    RoofT
  }
  translate  <0.0, -5.0, -10.9>
  rotate 28.5*x
  translate  <9.8, 5.0, 10.9>
}
#declare roof =
union { // Roof
  #declare counter = 0;
  #declare max_count = 30;
  #while (counter<max_count)
     object { Row translate <-0.4*counter,0,0> }
     #declare counter = counter +1;
  #end
  texture {
    RoofT
  }
}
#declare rf01 =
object { // CSG001
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.0, 1.0>
    rotate -45.0*x
  }
  texture {
    Stone01
  }
  scale <1.0, 3.6, 2.0>
  translate  <0.0, 5.0, 8.0>
}
// ------------------------------------

// BRICK ------------------------------
#declare br_wall =
difference { // BElements01
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <9.96, 4.96, 3.96>
    translate  <0.0, 5.0, 4.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.0, 1.6>
    translate  <6.0, 0.9, 5.6>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.82, 1.02, 1.02>
    translate  <6.0, 0.9, 2.0>
  }
  texture { Brick_Texture01 scale 0.2 }
}
// ------------------------------------

//#declare left_building =
union { // Left_Building
  object { Balcony }
  object { Complete_Fence }
  object { BElements01 }
  object { Complete_Door }
  object { Window }
  object { ODV_F_WATER }
  object { CSG001 }
  object { cb }
  object { mb }
  object { ZAVJ }
  object { br_wall }
  object { roof }
  object { rf01 }
  cylinder { // ROOF_CONECTOR
    <0,0,1>, <0,0,0>, 1 
    texture {
      RoofT
    }
    scale <0.2, 0.2, 20.0>
    rotate -90.0*y
    translate  <10.0, 5.0, 10.8>
  }
  object { ZAVJ1 }
  object { DIMNJAK }
  texture {
    Wall01
  }
  translate <-16,3,0>
}
