// !!!!       THIS IS OLD VERSION OF GENERATOR        !!!!
// !!!! THERE IS NEW, ADVANCED VERSION AT MY HOMEPAGE !!!!

// ##################################################################

// TYPE OF INC FILE: Tree generator for POVRay                      
// CREATOR : Toni Bratincevic                                       
// E-MAIL  : tbrat@mail.geocities.com                                
// HOMEPAGE: http://members.xoom.com/Intercepto                     
// Created in POVRay 3.1 on Pentium 133 (64MB Ram, 1.6GB HD, WinNT) 

// ##################################################################

global_settings { max_trace_level 15 }

#include "colors.inc"
#include "wood_textures.inc"
                                  
#declare lig = off;
#declare cam = off;

// ##
// POSTAVLJANJE KAMERE I SVIJETLA
// ##

#if (cam)
  camera {  //  Camera Camera01
    location  <    -10.710,     -18.240,       2.340>
    direction <        0.0,         0.0,      1.1547> // Aperture is 0.82 degrees
    sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
    up        <        0.0,         0.0,         1.0> // Where Z is up
    right     <    1.33333,         0.0,         0.0> // Aspect ratio
    look_at   <     -0.060,       4.250,       3.170>
  }
  light_source { <5000,-6000,5000> color rgb <1,0.9,0.7> }
  light_source { <-10,-18,2.3> color rgb <1,0.9,0.7>*0.1 }
  light_source { <-10,38,2.3> color rgb <0.4,0.3,0.1>*0.5 }
#end
  
// ##
// DEKLARACIJE VARIJABLA KORISTENIH ZA KONTROLU RASTA STABLA
// ##

// ---> transformation controls
#ifndef (rotas)
   #declare rotas = <0,0,0>;
#end
#ifndef (trans)
   #declare trans= <0,0,0>;           
#end
#ifndef (scals)
   #declare scals = <1,1,1>;
#end

// ---> quality control and switches
#declare leafs = off;                    // leaf switch (on/off) 
#declare leaftype = 3;                   // 1-mesh3D, 2-object3D, 3-polygon2D
#declare roots = on;                    // root switch (on/off) 
#declare branching_with_metaballs = off; // not used yet!!!
#declare textures_switch = on;          // textures (on/off) 
#declare algorythm = 2;                  // algorythm for creating last branches

// ---> branch properties
#declare branch_segments = 3;           // branch segmentation (1-X) rec. 2-5
#declare rmov_branch = 0.5;             // random move size for connection points (0-X)
#declare connectors = on;              // using spheres as connectors (on/off) not impl!
#declare last_branch_type = 1;          // generation method 4 last branch (0/1) if alg_1 on 						
#declare last_branch_max = 1;

// ---> branching properties
#declare smalt = 0.5;

// ---> branch rotations controls
#declare max_rota = 35;                 // maximum branch rotation if branching
#declare min_rota = 15;                 // minimum branch rotation if branching
#declare max_rota2 = 10;                 // maximim rotation if not branching
#declare gvarot = 1;                    // 1 = 360, 0.5 = 180 ...

// ---> branch size controls
#declare deb_grana = 2.6;               // debljina mame grane
#declare deb_brzina = 2.6;              // brzina smanjivanja debljine tijekom iscrtavanja stabla
#declare oddeb = 0.2;                   // oduzimanje od debljine grane u slucaju grananja
#declare st_siz_branch = 9;             // duzina mame grane 
#declare en_siz_branch = 3;             // duzina mame grane 
#declare max_duz_vari = 5;              // keep it below en_siz_branch*2

// ---> branching controls
#declare pos_grananja0 = 30;            // postotak grananja u prvom dijelu stabla (0-100%)
#declare pos_grananja1 = 40;            // postotak grananja u drugom dijelu stabla (0-100%)
#declare pos_grananja2 = 80;            // postotak grananja u trecem dijelu stabla (0-100%)
#declare third_br_perc = 0;
#declare third_br_to   = 2;             // level

#declare pos_flower = 5;
#declare flow_scale = 0.4;

// ---> if last_branch_type = 1  
#declare br_levels = 5; 				        // division of branch
#declare kolturb = 0.2;					        // ? (0-1) ?
#declare mkol = 6; 						          // division of one loop arround branch
#declare zrot_tolerance = 40; 			    // maximum tolerance of z rotation
#declare yrot_tolerance = 25; 			    // maximum tolerance of y rotation

// ---> random rotations controls
#declare rnd_rota1y = seed (42354);     // y rotacija - 1 dio stabla
#declare rnd_rota2y = seed (34534);     // y rotacija - 2 dio stabla 
#declare rnd_rota3y = seed (90423);     // y rotacija - 3 dio stabla
#declare rnd_rota1x = seed (34243);     // x rotacija - 1 dio stabla
#declare rnd_rota2x = seed (53435);     // x rotacija - 2 dio stabla 
#declare rnd_rota3x = seed (56744);     // x rotacija - 3 dio stabla

#declare rnd_gran = seed (5645);         // sjeme za kontrolu rand funkcije kod grananja
#declare rnd_gran1 = seed (532);        // sjeme za kontrolu rand funkcije kod grananja
#declare rnd_gran2 = seed (532);        // sjeme za kontrolu rand funkcije kod grananja
#declare rnd_gran3 = seed (532);        // sjeme za kontrolu rand funkcije kod grananja

#declare rnd4branch_siz = seed (23422);         // sjeme za kontrolu rand funkcije kod grananja

// ---> texture controls

// ---> leaf controls
#declare seed_vel_list = seed(123);
#declare var_vel = .6;
#declare seed_duz_list = seed(123);
#declare var_duz = .5;
#declare seed_boj_list = seed(223);
#declare var_boje = .2;
#declare seed_rot_list = seed(223);
#declare var_rot = 15;
#declare var_rotx = 20;
#declare lseed = seed (253);
#declare lp = 50;
#declare pg_kol_list = 4;

// ---> arrays for storing end points if using algorythm
#if (algorythm=2)
	#declare po1 = array[10000]
	#declare po2 = array[10000]
	#declare ar1 = 0;
	#declare ar2 = 0;
#end

// ##
// DEKLARACIJE MATERIJALA KORISTENIH U GENERATORU
// ##

#if (textures_switch)
// tekstura listica
#declare LeafTex =
texture {
   pigment {              
      bumps
      color_map {
        [ 0 color rgb <.6,1,.2> ]
        [ 1 color rgb <.3,1,.3>/1.5 ]
      }
   }
   finish {
      ambient 0.3
      diffuse 0.7
      phong 0.15
      phong_size 25
      crand 0.05
   }
   normal { bumps 0.1}
}
texture {
   pigment {
      granite
      color_map {
        [ 0.00 color rgbt <.3,1,.3,0.6> ]
        [ 0.20 color rgbt <.3,1,.3,0.8> ]
        [ 0.45 color rgbt <.3,1,.3,1> ]
        [ 1.00 color rgbt <.3,1,.3,1> ]
      }
   }
   normal {
      granite 0.20
   }
   finish {
      ambient 0.3
      diffuse 0.7
      phong 0.15
      phong_size 25
      crand 0.05
   }
      scale 0.4
}
texture {
   pigment {
      gradient x
      pigment_map {
        [ 0.00 color rgbt <0,0.6,0,0.4> ]
        [ 0.02 color rgbt <0,0.6,0,0.5> ]
        [ 0.05
           crackle
           color_map {
              [ 0.05 color rgbt <0,.6,0,0.6> ]
              [ 0.10 color rgbt <0,.6,0,1> ]
              [ 1.00 color rgbt <0,.6,0,1> ]
           }
           scale 0.2
        ]
        [ 1.00
           crackle
           color_map {
              [ 0.05 color rgbt <0,.6,0,0.9> ]
              [ 0.10 color rgbt <0,.6,0,1> ]
              [ 1.00 color rgbt <0,.6,0,1> ]
           }
        ]
      }
      scale 1
   }
   finish {
      ambient 0.3
      diffuse 0.7
      phong 0.15
      phong_size 25
      crand 0.05
   }
   normal { crackle 0.1 scale 0.2}
}
texture { pigment { color rgbf <0,0.8,0,0.4> } finish { specular 0.3  roughness 0.1 } }


// textura za grane
#declare BranchTex1 = texture { Wood_Tex2 }
// tekstura krosnje sa duginim prijelazom
#declare LeafTex2 = 
texture {
   pigment {
      radial
      color_map {
         [ 1*(1/7) color rgb <1,0,0> ]
         [ 2*(1/7) color rgb <1,1,0> ]
         [ 3*(1/7) color rgb <0,1,0> ]
         [ 4*(1/7) color rgb <0,1,1> ]
         [ 5*(1/7) color rgb <0,0,1> ]
         [ 6*(1/7) color rgb <1,0,1> ]
         [ 7*(1/7) color rgb <1,0,0> ]
      }
   }
   finish {
      ambient 0.1
      diffuse 0.7
      specular 0.05
      roughness 0.1
      crand 0.05
   }
}

#declare Sand = 
   texture {
      pigment {
         granite
         color_map {
            [ 0 color rgb <193,211,185>/255 ]
            [ 1 color rgb <193,211,185>*0.9/255 ]
         }
         scale 0.05
      }
      normal {
         wrinkles
         normal_map {
            [ 0.3
               average
               normal_map {
                  [ 1  wrinkles 0.05 scale 0.1 ]
                  [ .4 gradient x 0.05 scale 0.1 ]
               }
            ]
            [ 0.4
               gradient x 0.05
               translate x*50
               scale 0.1
            ]
            [ 1.0
               gradient x 0.05
               translate x*50
               scale 0.1
            ]
         }
         turbulence <0.4,0,0>
         octaves 5
         lambda 1
         omega 0.1
         scale 10
      }
      finish { diffuse 0.85 ambient 0.3 }
      scale .5
   }

#else             
   #declare LeafTex = texture { pigment { color rgb <0,1,0> } }
   #declare BranchTex1 =
   texture {
       pigment { color rgb 1 }
       finish { ambient 0.3 diffuse 0.7 } 
   }
   #declare Sand = pigment { color rgb <1,1,0> }
#end


// ##
// MACRO ZA ODLUCIVANJE O KOLICINI GRANA PRI GRANANJU U PRVOJ POLOVICI STABLA
// vraca vrijednost 1 ili 2
// ##

#macro ispit_grananja (postotak_grananja,random_sjeme,third_switch) 
   #local rand_broj1 = rand(rnd_gran1);
   #if ( rand_broj1 < postotak_grananja/100 )
     #declare grananje = 2;
   #else
     #declare grananje = 1;
   #end
   #if (third_switch>=1)
     #declare third_branch = third_br_perc/100; 
     #if (rand_broj1<third_branch)
        #declare grananje = 3;
     #end
   #end 
#end

#macro gispit3 () 
   #local rand_broj1 = rand(rnd_gran);
   #if ( rand_broj1 < pos_grananja3/100 )
     #declare gr = 1;
   #else
     #declare gr = 0;
   #end 
#end

#macro fispit () 
   #local rand_broj1 = rand(rnd_gran);
   #if ( rand_broj1 < pos_flower/100 )
     #declare fl = 1;
   #else
     #declare fl = 0;
   #end 
#end

// ##
// GENERATOR POLIGONSKOG LISTA + GENERATOR GRANCICA SA LISTOVIMA
// ##

#switch (leaftype)
#case (1)
#declare leaf = 
mesh {  // DEFAULT___
  triangle { <0.8756, 0.6968, -0.0078>, <0.0000, 0.0000, 0.0000>, <-0.8756, 0.6968, -0.0078> }
  triangle { <2.3748, 2.3488, -0.0891>, <0.8756, 0.6968, -0.0078>, <-0.8756, 0.6968, -0.0078> }
  triangle { <2.3748, 2.3488, -0.0891>, <-0.8756, 0.6968, -0.0078>, <-2.3748, 2.3488, -0.0891> }
  triangle { <3.5330, 4.3432, -0.3056>, <2.3748, 2.3488, -0.0891>, <-2.3748, 2.3488, -0.0891> }
  triangle { <3.5330, 4.3432, -0.3056>, <-2.3748, 2.3488, -0.0891>, <-3.5330, 4.3432, -0.3056> }
  triangle { <4.3227, 6.6917, -0.7306>, <3.5330, 4.3432, -0.3056>, <-3.5330, 4.3432, -0.3056> }
  triangle { <4.3227, 6.6917, -0.7306>, <-3.5330, 4.3432, -0.3056>, <-4.3227, 6.6917, -0.7306> }
  triangle { <4.8101, 9.3853, -1.4542>, <4.3227, 6.6917, -0.7306>, <-4.3227, 6.6917, -0.7306> }
  triangle { <4.8101, 9.3853, -1.4542>, <-4.3227, 6.6917, -0.7306>, <-4.8101, 9.3853, -1.4542> }
  triangle { <4.9405, 12.4250, -2.5978>, <4.8101, 9.3853, -1.4542>, <-4.8101, 9.3853, -1.4542> }
  triangle { <4.9405, 12.4250, -2.5978>, <-4.8101, 9.3853, -1.4542>, <-4.9405, 12.4250, -2.5978> }
  triangle { <-0.8595, 20.1227, -7.4149>, <-0.0000, 20.7511, -7.9656>, <0.8595, 20.1227, -7.4149> }
  triangle { <-0.8595, 20.1227, -7.4149>, <0.8595, 20.1227, -7.4149>, <2.3595, 18.6721, -6.2512> }
  triangle { <-2.3595, 18.6721, -6.2512>, <-0.8595, 20.1227, -7.4149>, <2.3595, 18.6721, -6.2512> }
  triangle { <-2.3595, 18.6721, -6.2512>, <2.3595, 18.6721, -6.2512>, <3.5789, 16.9476, -5.0404> }
  triangle { <-3.5789, 16.9476, -5.0404>, <-2.3595, 18.6721, -6.2512>, <3.5789, 16.9476, -5.0404> }
  triangle { <4.5058, 14.9195, -3.8246>, <4.9405, 12.4250, -2.5978>, <-4.9405, 12.4250, -2.5978> }
  triangle { <4.5058, 14.9195, -3.8246>, <-4.9405, 12.4250, -2.5978>, <-4.5058, 14.9195, -3.8246> }
  triangle { <-3.5789, 16.9476, -5.0404>, <3.5789, 16.9476, -5.0404>, <4.5058, 14.9195, -3.8246> }
  triangle { <4.5058, 14.9195, -3.8246>, <-4.5058, 14.9195, -3.8246>, <-3.5789, 16.9476, -5.0404> }
  scale 0.17
  // rotate -90*x
}
#break
#case (2)
#declare leaf = 
intersection {
   intersection {
      cylinder { <0,0,0> <0,1,0>,1 translate <-0.5,0,0> }
      cylinder { <0,0,0> <0,1,0>,1 translate <0.5,0,0> }
   }
   difference {
      sphere { <0,0,1>,1 }
      sphere { <0,0,1>,.95 }
      scale <.8,.2,1>
      translate <0,0,-1>
   }
   scale 1.5
   translate <0,-0.1,.85>   
   rotate -90*x
}
#break
#case (3)
#declare se = seed (123);
#declare leaf =
polygon {
   #declare pnumber = 8;
   pnumber,
   #declare maxcount = 8;
   #declare maxrep = .5;
   #declare divsize = .7;
   #declare lcounter = 0;
   #declare xsize = 1.2;
   #declare rpseed = seed (123);
   #while ( lcounter < maxcount)
      #if (lcounter =0)
         <0, 0>
      #else
         #if (lcounter < (maxcount-1))
            #declare xpos = (rand(rpseed)*0.03)+sin(radians(lcounter*(360/maxcount)))/xsize; 
            #declare ypos = (sin(radians((lcounter*(((360)*maxrep)/maxcount))))/divsize);
            < xpos,ypos >
         #else
            < 0,0>
         #end
      #end
      #declare lcounter = lcounter + 1;
   #end
   scale <1,1.5,1>/1.5
   rotate 180*z
   translate <0,1.4,0>
   texture { LeafTex }
}
#break
#case(4)
  #declare leaf_points = 6;
  #declare sin_size    = .2;
  #declare pow_size    = 10;
  #declare ppow_size   = pow(pow_size+1,2);
  #declare lf_counter = 0;
  #declare leaf = mesh {
  #while (lf_counter<1)
     #declare lf_point_xpos = 0.01+sin_size*sin(lf_counter*pi);
     #declare lf_npoint_xpos = 0.01+sin_size*sin((lf_counter+1/leaf_points)*pi);
     #declare lf_point_ypos = pow(1+lf_counter*pow_size,2)/ppow_size;
     #declare lf_npoint_ypos = pow(1+(lf_counter+1/leaf_points)*pow_size,2)/ppow_size;
     //#if (lf_counter<(1-1/leaf_points))
       triangle {
           <lf_point_xpos,lf_point_ypos,lf_counter>,
           <-lf_point_xpos,lf_point_ypos,lf_counter>,
           <-lf_npoint_xpos,lf_npoint_ypos,lf_counter+1/leaf_points>
       }
       triangle {
           <lf_point_xpos,lf_point_ypos,lf_counter>,
           <-lf_npoint_xpos,lf_npoint_ypos,lf_counter+1/leaf_points>,
           <lf_npoint_xpos,lf_npoint_ypos,lf_counter+1/leaf_points>
       }
     //#end
     #declare lf_counter = lf_counter + 1/leaf_points;
  #end
  scale <1,1.5,1>
  texture {
     LeafTex
     scale 0.2
  }
  }
#break
#end

// *****************************************************************

#if (last_branch_type=1)
  #declare pgrseed = seed (53453);
	#declare sj1 = seed (123);
	#declare mrot = seed(73563);
	#declare mrotz = seed(45423);
	#macro last_branch(duzina,debljina)
	   #local gduz2      = duzina/br_levels;
	   #local pgcounter1 = 1;
	   #local randtran1  = 0;
	   #local d1 = debljina;
	   #local d2 = debljina/2;
	   #local dp = (d1-d2)/br_levels;
	   #while (pgcounter1<br_levels)
	      #local randtran2 = (2*(rand(sj1)-0.5))*kolturb;
	      #local dd1 = d1 - (dp*pgcounter1);
	      //#debug str(randtran2,2,2)
	      // #debug "\\"
	      cone {
	         <randtran1,gduz2*(pgcounter1-1),0>,dd1+dp
	         <randtran2,gduz2*pgcounter1,0>,dd1
           texture { BranchTex1 }
	      }
	      #local maxcount2 = int(rand(mrot)*mkol);
	      // #debug str(maxcount2,1,0)
	      // #debug "\\"
	      #declare count2 = 0;
	      #declare mrota = 360/maxcount2; 
	      #while (count2 < maxcount2 )
    	     #declare brand_mov = rand (rnd_gran);
	         union {
	            cylinder { <0,0,0> <-0.5+(brand_mov*0.5/2),0,0>,0.02 }
	            //fispit()
	            /*#if (fl=1)
	               object {
	                  flower
	                  rotate 90*y
	                  rotate 90*z
	                  scale flow_scale
	                  translate <-1.5,0,0>
	               }
	            #else  */
	               object {
	                  leaf
	                  scale 0.6
	                  rotate 90*y
	                  rotate 135*z
	                  translate <-0.5+(brand_mov*0.5/2),0,0>
	               }
	            //#end
	            rotate z*((zrot_tolerance/2)-(rand(mrotz)*zrot_tolerance))
	            rotate y*mrota*count2+(yrot_tolerance*rand(pgrseed))
	            translate <randtran2,gduz2*pgcounter1,0>
              texture { pigment { color rgb <0.3,0.8,0.4> } finish { ambient 0.3 diffuse 0.7 specular 0.3 } }
	         }
	         #declare count2 = count2 + 1;
	      #end
	      #declare randtran1 = randtran2;
	      #declare pgcounter1 = pgcounter1 + 1;
	   #end
	#end
#end

#if (last_branch_type=2)
	#macro last_branch( pduzina, pdebljina )
	      cone { <0,0,0>,pdebljina <0,pduzina,0>, pdebljina-0.05*deb_brzina }
	      sphere { <0,pduzina,0>, pdebljina-0.05*deb_brzina }
	   #if (leafs)
	      //fispit()
	      //#if (fl=1)
	         //object { flower scale flow_scale translate <0,pduzina,0> }
	      //#else
	         listici (lp,<0,pduzina,0>,<0,0,0>)
	      //#end 
	      #declare pgcounter1 = 0;
	      #while (pgcounter1 < pg_kol_list)
	         #declare sidedec = int(1+(rand (seed_duz_list)*2));
	         #if (sidedec = 1 )
	            #declare pgrotz = 90-(rand(seed_rot_list)*45); 
	         #else
	            #declare pgrotz = 90-(rand(seed_rot_list)*45);
	            #declare pgroty = 180; 
	         #end
	         #declare pg_rnd_tran = (rand(seed_rot_list)*pduzina); 
	         listici (lp,<0,pg_rnd_tran,0>,<0,180,pgrotz>)
	         #declare pgcounter1 = pgcounter1 + 1;
	      #end
	   #end
	#end
#end
// *****************************************************************


// makro za iscrtavanje grancica sa listovima
#macro listici (llpercent,llt,llr)
   #declare lcounter1 = 1;
   #declare lcswitch = 1;
   #declare lrotang = 45;
   #declare lrot = 0;
      #while (lcounter1<4)                
         #declare rnd_vel_list = rand (seed_vel_list)*var_vel;
         #declare rnd_boj_list = rand (seed_boj_list)*var_boje;
         #declare rnd_duz_list = rand (seed_duz_list)*var_duz;
         #declare rnd_rot_listy = (rand (seed_rot_list)*var_rot)-(var_rot/2);
         #declare rnd_rot_listx = rand (seed_rot_list)*var_rotx;
         #if (lcswitch=1)
            #declare klist = int(1+(rand(lseed)*(llpercent/100))*3);
            #if (klist=3)
               #declare lcounter1 = lcounter1;
               #declare lcswitch = 0;
               #declare lmin = 2;
            #else
               #if (klist=2)
                  #declare lcounter1 = lcounter1 + 1;
                  #declare lcswitch = 0;
                  #declare lmin = 2.5;
               #else
                  #declare lcounter1 = lcounter1 + 2;
                  #declare lcswitch = 0;
                  #declare lrotang = 0;
                  #declare lmin = 0;
               #end
            #end
         #end 
         union {
            cone { <0,0,0>,0.05 <0,2-rnd_duz_list,0>, 0.03 texture { LeafTex } }
            object {
               leaf
               scale 1.5
               rotate -90*y
               scale <1.5,1.5,1>/(1.4-(rnd_vel_list))
               texture { LeafTex }
               translate <0,2-rnd_duz_list,0>
            }
            scale 0.5
            rotate y*(rnd_rot_listy)
            rotate z*((lrotang*(lcounter1-lmin))+rnd_rot_listy)
            rotate x*(15+rnd_rot_listx)
            rotate llr
            translate llt
         }
         #declare lcounter1 = lcounter1 + 1;
      #end
#end


// ##
// BRANCH GENERATOR
// ##

#declare sin_add_toler = 0.1; // tollerance for random move add on sinus
#declare seed_prel_x = seed (123);
#declare seed_prel_z = seed (345);
#declare branch_rot_s = seed (324);
#declare use_sinus = on;

#macro grana ( duzina, debljina_dna, debljina_vrha )
  #declare rnd_prelx_buf = 0; 
  #declare rnd_prelz_buf = 0; 
  #declare y_branch_rot = rand (branch_rot_s)*360;
  #declare br_siz_seg = duzina/branch_segments;
  #declare br_rad_seg = (debljina_dna-debljina_vrha)/branch_segments;
  #declare x_max_mov = rmov_branch*rand(seed_prel_x);
  #declare z_max_mov = rmov_branch*rand(seed_prel_z);
  #if (connectors)
    union {
  #else
    #if (branch_segments=1)
      object {
    #else
      union {
    #end
  #end
      #declare bcounter = 0;
      #while (bcounter<branch_segments)
         #declare str_to_one = bcounter*(1/branch_segments);
         #if (bcounter=(branch_segments-1))
            #declare rnd_prelx = 0;
            #declare rnd_prelz = 0;
         #else
            #if(use_sinus)
               #declare rnd_prelx = sin_add_toler*(1-2*rand(seed_prel_x))+x_max_mov*sin(str_to_one*pi);
               #declare rnd_prelz = sin_add_toler*(1-2*rand(seed_prel_z))+z_max_mov*sin(str_to_one*pi);
            #else
               #declare rnd_prelx = rmov_branch-x_max_mov*2;
               #declare rnd_prelz = rmov_branch-z_max_mov*2;
            #end
         #end
         cone {
            <rnd_prelx_buf ,(bcounter*br_siz_seg),rnd_prelz_buf >,debljina_dna-(bcounter*br_rad_seg)
            <rnd_prelx,((bcounter+1)*br_siz_seg),rnd_prelz>, debljina_dna-((bcounter+1)*br_rad_seg)
         }
         #if (connectors)
            sphere { <rnd_prelx,((bcounter+1)*br_siz_seg),rnd_prelz>, debljina_dna-((bcounter+1)*br_rad_seg) }
         #end
         #declare rnd_prelx_buf = rnd_prelx; 
         #declare rnd_prelz_buf = rnd_prelz; 
         #declare bcounter = bcounter +1;
      #end
      rotate y*y_branch_rot
      texture { BranchTex1 }
  }
#end
  
// ##
// GENERATOR DNA STABLA
// ##
#declare dn_seed = seed (123); 
#declare dno =
blob {
   threshold 0.58
   cylinder { <0,0,0> <0,3,0>, 3.7,1 }
   sphere   { <0,0,0>, 3,1 }
   #declare dncounter = 0;
   #declare dnumber = 8;
   #while (dncounter<dnumber)
      #declare blcounter = 0;
      #declare blcountad = .05;
      #declare rnd_bl_rot = rand(dn_seed);
      #while (blcounter<1)
          #declare dnrand = rand (dn_seed)*1;
          #declare dtrany = cos (radians(45*blcounter)); 
          sphere {
             <0,0,0>, (rnd_bl_rot/4)+1.5-blcounter, .7
             translate <
                2*(blcounter*3*(0.5+(rnd_bl_rot/2))),
                1+(-blcounter*2)+dtrany+dnrand-0.5,
                0>
             rotate y*((30*(rnd_bl_rot-0.5))+(dncounter*(360/dnumber))) 
          }
          
         #declare blcounter = blcounter + blcountad;
      #end
      #declare dncounter = dncounter + 1;
   #end
   scale 2
   scale deb_grana/3.6 
   texture {
         gradient y
         texture_map {
            [ 0.1 BranchTex1 scale 1/10 /*pigment { color rgb <0.1,0.4,0.2> } */ ]   
            [ 0.2 BranchTex1 scale 1/10 ]   
         }
         translate <0,-0.05,0>
         turbulence 0.3
         octaves 6
         lambda 1
         omega 0.3
         scale 10
   }
}

// ##
// GENERATOR SPOJKE OD METABALLSA PRI GRANANJU
// ##
#declare tr = 0.5; // threshold for blob
#declare sz = 1.19;
#macro spojka(sduz0,sdeb0,sduz1,sdeb1,srot,sroty)
blob {
   threshold tr
   cylinder {
      <0,3*(sduz0/4),0> <0,sduz0,0>,sdeb0/(1-(tr/sz)),1
      texture { BranchTex1 } 
   }
   cylinder {
      <0,0,0> <0,sduz1/2,0>,sdeb1/(1-(tr/sz)),1
      texture { BranchTex1 } 
      rotate x*srot
      translate y*sduz0
   }
   rotate y*sroty
   // pigment { color White }
}
#end

// ##
// MACRO FOR GETING END POINTS
// ##
#macro get_point(level)
   #switch (level)
   #case (14)
      #declare point = vrotate(<0,gduz1m,0>,<rotx1m,roty1m,0>);
      #declare point = vrotate(point+<0,trany1m,0>,<rotx1l,roty1l,0>);
      #declare point = vrotate(point+<0,trany1l,0>,<rotx1k,roty1k,0>);
      #declare point = vrotate(point+<0,trany1k,0>,<rotx1j,roty1j,0>);
      #declare point = vrotate(point+<0,trany1j,0>,<rotx1i,roty1i,0>);
      #declare point = vrotate(point+<0,trany1i,0>,<rotx1h,roty1h,0>);
      #declare point = vrotate(point+<0,trany1h,0>,<rotx1g,roty1g,0>);
      #declare point = vrotate(point+<0,trany1g,0>,<rotx1f,roty1f,0>);
      #declare point = vrotate(point+<0,trany1f,0>,<rotx1e,roty1e,0>);
      #declare point = vrotate(point+<0,trany1e,0>,<rotx1d,roty1d,0>);
      #declare point = vrotate(point+<0,trany1d,0>,<rotx1c,roty1c,0>);
      #declare point = vrotate(point+<0,trany1c,0>,<rotx1b,roty1b,0>);
      #declare point = vrotate(point+<0,trany1b,0>,<rotx1a,roty1a,0>);
      #declare point = point+<0,trany1a,0>;
   #break
   #case (13)
      #declare point = vrotate(<0,gduz1l,0>,<rotx1l,roty1l,0>);
      #declare point = vrotate(point+<0,trany1l,0>,<rotx1k,roty1k,0>);
      #declare point = vrotate(point+<0,trany1k,0>,<rotx1j,roty1j,0>);
      #declare point = vrotate(point+<0,trany1j,0>,<rotx1i,roty1i,0>);
      #declare point = vrotate(point+<0,trany1i,0>,<rotx1h,roty1h,0>);
      #declare point = vrotate(point+<0,trany1h,0>,<rotx1g,roty1g,0>);
      #declare point = vrotate(point+<0,trany1g,0>,<rotx1f,roty1f,0>);
      #declare point = vrotate(point+<0,trany1f,0>,<rotx1e,roty1e,0>);
      #declare point = vrotate(point+<0,trany1e,0>,<rotx1d,roty1d,0>);
      #declare point = vrotate(point+<0,trany1d,0>,<rotx1c,roty1c,0>);
      #declare point = vrotate(point+<0,trany1c,0>,<rotx1b,roty1b,0>);
      #declare point = vrotate(point+<0,trany1b,0>,<rotx1a,roty1a,0>);
      #declare point = point+<0,trany1a,0>;
   #break
   #end
#end

// MACRO FOR CREATING LEAFS OR WHATHEVER YOU WANT AT THE END OF BRANCHES
#declare lsiz_seed = seed (123);
#declare color_seed = seed (123);
/*
#macro plod(pnt1,pnt2)
   #declare red_col = rand (color_seed);
   #declare gre_col = rand (color_seed);
   #declare blu_col = rand (color_seed);
   #declare lsiz = rand (lsiz_seed);
   /*cylinder {
      pnt1 pnt2,0.2
      pigment {
         color rgb 1
      }
      finish { ambient 0.3 diffuse 0.7 }
   }*/ 
   sphere {
      <0,0,0>,1+lsiz*4
      material {
         texture {
            pigment { color rgb <0.3,0.7,1> transmit 0.5 }
            finish { ambient 0.2 diffuse 0.5 specular 1 roughness 0.01 reflection 0.4 }
         }
         
         interior {
            ior 1
            media {
               // emission <blu_col*0.1,(blu_col*0.9)+0.1,(blu_col*0.6)+0.4>
               emission <0,0.1,0.3>*0.1
               /*density {
                  spherical
                  color_map {
                     [0.0 color rgbt <0,0,0,1>]
                     [1.0 color rgbt <1,1,1,0>]
                  }
                  scale 1+lsiz*4
               } */
            }
         }
         
      }
      translate pnt1
      hollow
   }
#end*/

#macro plod(pnt1,pnt2)
   object {
      //sphere { <0,0,0>,3.5 pigment { color rgb 1 } }
      //translate pnt1
      cylinder {
        pnt1 pnt2, 0.2
        pigment { color rgb 1 }
      }
   } 
#end   

#macro size_variation ()
  #declare siz_rnd_add = ((max_duz_vari/2)-max_duz_vari*rand(rnd4branch_siz));
#end
      
// ##
// GENERATOR STABLA
// ##

#declare counter1 = 0;
#declare branches_at_branch_1 = 1;
#declare siz_add_factor = (st_siz_branch-en_siz_branch)/14;

// ### COUNTER 1 ###
#declare stablo =
union {
	#while ( counter1 < branches_at_branch_1 )
	#declare tg_level = 1;
	#declare gsiz_first_branch = st_siz_branch;
	union {
		// COUNTER 2
		#declare counter2 = 0;
		#while (counter2 < 3)
		#declare tg_level = 2;
		union {
			#if (counter2=0)
  			ispit_grananja (pos_grananja0,rnd_gran1,third_br_to/tg_level) 
  			#if (grananje = 2) 
 					#declare odb1 = 1 - oddeb; 
					#declare dspojk2 = on; 
  				#declare counter2 = counter2+1;
  			#else 
 					#if (grananje = 3)
   					#declare odb1 = 1 - oddeb; 
  					#declare dspojk2 = on; 
    				#declare counter2 = counter2;
 					#else
   					#declare odb1 = 1; 
   					#declare dspojk2 = off; 
            #declare counter2 = counter2 + 2; 
            #declare rotx1a = rand(rnd_rota1x)*max_rota2; 
  			  #end
  			#end
			#end
			#if (grananje!=1)
			  #declare rotx1a = min_rota+rand(rnd_rota1x)*(max_rota-min_rota); 
			#end
  		#declare roty1a = rand(rnd_rota1y)*360;
			#declare gdeb2 = (deb_grana - (1*0.076)*deb_brzina)*odb1;
			size_variation ()
			#declare gduz1a = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
			// #declare gdeb1 = (deb_grana - (1*0.076)*deb_brzina)*odb1;
			#declare trany1a = gsiz_first_branch;
			
			// COUNTER 3
			#declare counter3 = 0;
			#while (counter3 < 3)
			#declare tg_level = 3;
			union {
  			#if (counter3=0)
  				ispit_grananja (pos_grananja0,rnd_gran1,third_br_to/tg_level)
  				#if (grananje = 2)
						#declare odb2 = 1 - oddeb;
 						#declare dspojk3 = on;
    				#declare counter3 = counter3 + 1;
  				#else
 						#if (grananje=3)
  						#declare odb2 = 1 - oddeb;
   						#declare dspojk3 = on;
    					#declare counter3 = counter3;
 						#else
   						#declare odb2 = 1;
   						#declare dspojk3 = off;
    					#declare counter3 = counter3 + 2;
    					#declare rotx1b = rand(rnd_rota1x)*max_rota2;
  				  #end
  				#end
				#end
  			#if (grananje!=1)
  			  #declare rotx1b = min_rota+rand(rnd_rota1x)*(max_rota-min_rota); 
  			#end
				#declare roty1b = rand(rnd_rota1y)*360;
				#declare gdeb3 = (deb_grana - (2*0.076)*deb_brzina)*(odb1*odb2);
			  size_variation ()
				#declare gduz1b = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
				// #declare gdeb1 = (deb_grana - (2*0.076)*deb_brzina)*(odb1*odb2);
				#declare trany1b= gduz1a;
				
				// COUNTER 4
				#declare counter4 = 0;
				#while (counter4 < 3)
        #declare tg_level = 4;
        union {
  			  #if (counter4=0)
          	ispit_grananja (pos_grananja0,rnd_gran1,third_br_to/tg_level)
          	#if (grananje = 2)
             	#declare odb3 = 1 - oddeb;
             	#declare dspojk4 = on;
              #declare counter4 = counter4 + 1;
            #else
   						#if (grananje=3)
               	#declare odb3 = 1 - oddeb;
               	#declare dspojk4 = on;
                #declare counter4 = counter4;
   						#else
               	#declare odb3 = 1;
               	#declare dspojk4 = off;
                #declare counter4 = counter4 + 2;
                #declare rotx1c = rand(rnd_rota1x)*max_rota2;
              #end
            #end
          #end
    			#if (grananje!=1)
    			  #declare rotx1c = min_rota+rand(rnd_rota1x)*(max_rota-min_rota); 
    			#end
          #declare roty1c = rand(rnd_rota1y)*360;
          #declare gdeb4 = (deb_grana - (3*0.076)*deb_brzina)*(odb1*odb2*odb3);
			    size_variation ()
          #declare gduz1c = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
          // #declare gdeb1 = (deb_grana - (3*0.076)*deb_brzina)*(odb1*odb2*odb3);
          #declare trany1c= gduz1b;
          
          // COUNTER 5
          #declare counter5 = 0;
          #while (counter5 < 3)
         	#declare tg_level = 5;
          union {
    			  #if (counter5=0)
            	ispit_grananja (pos_grananja0,rnd_gran1,third_br_to/tg_level)
            	#if (grananje = 2)
               	#declare odb4 = 1 - oddeb;
               	#declare dspojk5 = on;
                #declare counter5 = counter5 + 1;
              #else
     						#if (grananje=3)
                 	#declare odb4 = 1 - oddeb;
                 	#declare dspojk5 = on;
                  #declare counter5 = counter5;
     						#else
                 	#declare odb4 = 1;
                  #declare dspojk5 = off;
                  #declare counter5 = counter5 + 2;
                  #declare rotx1d = rand(rnd_rota1x)*max_rota2;
                #end
              #end
            #end
      			#if (grananje!=1)
      			  #declare rotx1d = min_rota+rand(rnd_rota1x)*(max_rota-min_rota); 
      			#end
            #declare roty1d = rand(rnd_rota1y)*360;
            #declare gdeb5 = (deb_grana - (4*0.076)*deb_brzina)*(odb1*odb2*odb3*odb4);
			      size_variation ()
            #declare gduz1d = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
            // #declare gdeb1 = (deb_grana - (4*0.076)*deb_brzina)*(odb1*odb2*odb3*odb4);
            #declare trany1d= gduz1c;
            
            // COUNTER 6
            #declare counter6 = 0;
            #while (counter6 < 3)
            #declare tg_level = 6;
            union {
       			  #if (counter6=0)
              	ispit_grananja (pos_grananja1,rnd_gran2,third_br_to/tg_level)
                #if (grananje = 2)
                 	#declare odb5 = 1 - oddeb;
                  #declare dspojk6 = on;
                  #declare counter6 = counter6 + 1;
                #else
       						#if (grananje=3)
                   	#declare odb5 = 1 - oddeb;
                    #declare dspojk6 = on;
                    #declare counter6 = counter6;
       						#else
                   	#declare odb5 = 1;
                    #declare dspojk6 = off;
                    #declare counter6 = counter6 + 2;
                    #declare rotx1e = rand(rnd_rota2x)*max_rota2;
                  #end
                #end
              #end
        			#if (grananje!=1)
        			  #declare rotx1e = min_rota+rand(rnd_rota2x)*(max_rota-min_rota); 
        			#end
              #declare roty1e = rand(rnd_rota2y)*360;
              #declare gdeb6 = (deb_grana - (5*0.076)*deb_brzina)*(odb1*odb2*odb3*odb4*odb5);
			        size_variation ()
              #declare gduz1e = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
              // #declare gdeb1 = (deb_grana - (5*0.076)*deb_brzina)*(odb1*odb2*odb3*odb4*odb5);
              #declare trany1e = gduz1d;
              
              // COUNTER 7
              #declare counter7 = 0;
              #while (counter7 < 3)
							#declare tg_level = 7;
              union {
  			        #if (counter7=0)
                	ispit_grananja (pos_grananja1,rnd_gran2,third_br_to/tg_level)
                  #if (grananje = 2)
                   	#declare odb6 = 1 - oddeb;
                    #declare dspojk7 = on;
                    #declare counter7 = counter7 + 1;
                  #else
         						#if (grananje=3)
                     	#declare odb6 = 1 - oddeb;
                      #declare dspojk7 = on;
         						#else
                    	#declare odb6 = 1;
                      #declare dspojk7 = off;
                      #declare counter7 = counter7 + 2;
                      #declare rotx1f = rand(rnd_rota2x)*max_rota2;
                    #end
                  #end
                #end
          			#if (grananje!=1)
          			  #declare rotx1f = min_rota+rand(rnd_rota2x)*(max_rota-min_rota); 
          			#end
                #declare roty1f = ((360*gvarot)/2)-(rand(rnd_rota2y)*(360*gvarot));
                #declare gdeb7 = (deb_grana - (6*0.076)*deb_brzina)*(odb1*odb2*odb3*odb4*odb5*odb6);
			          size_variation ()
                #declare gduz1f = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
                // #declare gdeb1 = (deb_grana - (6*0.076)*deb_brzina)*(odb1*odb2*odb3*odb4*odb5*odb6);
                #declare trany1f = gduz1e;
                
                // COUNTER 8
                #declare counter8 = 0;
                #while (counter8 < 3)
         				#declare tg_level = 8;
                union {
    			        #if (counter8=0)
                  	ispit_grananja (pos_grananja1,rnd_gran2,third_br_to/tg_level)
                    #if (grananje = 2)
    			            #declare counter8 = counter8 + 1;
  			            #else
           						#if (grananje=3)
    			            	#declare counter8 = counter8;
           						#else
    			            	#declare counter8 = counter8 + 2;
    			              #declare rotx1g = rand(rnd_rota2x)*max_rota2;
  			              #end
  			            #end
			            #end
            			#if (grananje!=1)
            			  #declare rotx1g = min_rota+rand(rnd_rota2x)*(max_rota-min_rota); 
            			#end
                  #declare roty1g = ((360*gvarot)/2)-(rand(rnd_rota2y)*(360*gvarot));
				          #declare odbal = odb1*odb2*odb3*odb4*odb5*odb6;
				          #declare gdeb8 = (deb_grana - (7*0.076)*deb_brzina)*odbal; // ****
			            size_variation ()
				          #declare gduz1g = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
				          // #declare gdeb1 = (deb_grana - (7*0.076)*deb_brzina)*odbal; // ****
				          #declare trany1g = gduz1f;
                  
                  // COUNTER 9
				          #declare counter9 = 0;
                  #while (counter9 < 3)
                  #declare tg_level = 9;
                  union {
    			          #if (counter9=0)
                    	ispit_grananja (pos_grananja1,rnd_gran2,third_br_to/tg_level)
                      #if (grananje = 2)
                      	#declare counter9 = counter9 + 1;
                      #else
             						#if (grananje=3)
                      	   #declare counter9 = counter9;
             						#else
                        	#declare counter9 = counter9 + 2;
                          #declare rotx1h = rand(rnd_rota2x)*max_rota2;
                        #end
                      #end
			              #end
              			#if (grananje!=1)
              			  #declare rotx1h = min_rota+rand(rnd_rota2x)*(max_rota-min_rota); 
              			#end
				            #declare roty1h = ((360*gvarot)/2)-(rand(rnd_rota2y)*(360*gvarot));
				            #declare gdeb9 = (deb_grana - (8*0.076)*deb_brzina)*odbal;
			              size_variation ()
				            #declare gduz1h = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
				            // #declare gdeb1 = (deb_grana - (8*0.076)*deb_brzina)*odbal;
				            #declare trany1h = gduz1g;
				            
				            // COUNTER 10
				            #declare counter10 = 0;
                    #while (counter10 < 3)
         						#declare tg_level = 10;
                    union {
    			            #if (counter10=0)
                      	ispit_grananja (pos_grananja2,rnd_gran3,third_br_to/tg_level)
                        #if (grananje = 2)
                        	#declare counter10 = counter10 + 1;
                        #else
               						#if (grananje=3)
                        	   #declare counter10 = counter10;
               						#else
                          	#declare counter10 = counter10 + 2;
                            #declare rotx1i = rand(rnd_rota2x)*max_rota2;
                          #end
                        #end
                      #end
                			#if (grananje!=1)
                			   #declare rotx1i = min_rota+rand(rnd_rota3x)*(max_rota-min_rota); 
                			#end
                      #declare roty1i = ((360*gvarot)/2)-(rand(rnd_rota2y)*(360*gvarot));
                      #declare gdeb10 = (deb_grana - (9*0.076)*deb_brzina)*odbal;
			                size_variation ()
                      #declare gduz1i = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
                      // #declare gdeb1 = (deb_grana - (9*0.076)*deb_brzina)*odbal;
                      #declare trany1i= gduz1h;
                      
                      // COUNTER 11
                      #declare counter11 = 0;
                      #while (counter11 < 3)
                      #declare tg_level = 11;
                      union {
          			        #if (counter11=0)
                        	ispit_grananja (pos_grananja2,rnd_gran3,third_br_to/tg_level)
                          #if (grananje = 2)
                          	#declare counter11 = counter11 + 1;
                          #else
                 						#if (grananje=3)
                            	#declare counter11 = counter11;
                 						#else
                            	#declare counter11 = counter11 + 2;
                              #declare rotx1j = rand(rnd_rota3x)*max_rota2;
                            #end
                          #end
                        #end
                  			#if (grananje!=1)
                  			  #declare rotx1j = min_rota+rand(rnd_rota3x)*(max_rota-min_rota); 
                  			#end
                        #declare roty1j = ((360*gvarot)/2)-(rand(rnd_rota3y)*(360*gvarot));
                        #declare gdeb11 = (deb_grana - (10*0.076)*deb_brzina)*odbal;
			                  size_variation ()
                        #declare gduz1j = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
                        // #declare gdeb1 = (deb_grana - (10*0.076)*deb_brzina)*odbal;
                        #declare trany1j= gduz1i;
                        
                        // COUNTER 12
                        #declare counter12 = 0;
                        #while (counter12 < 3)
         								#declare tg_level = 12;
                        union {
             			        #if (counter12=0)
                          	ispit_grananja (pos_grananja2,rnd_gran3,third_br_to/tg_level)
                            #if (grananje = 2)
                            	#declare counter12 = counter12 + 1;
                            #else
                   						#if (grananje=3)
                            	  #declare counter12 = counter12;
                   						#else
                              	#declare counter12 = counter12 + 2;
                                #declare rotx1k = rand(rnd_rota3x)*max_rota2;
                              #end
                            #end
                          #end
                    			#if (grananje!=1)
                    			  #declare rotx1k = min_rota+rand(rnd_rota3x)*(max_rota-min_rota); 
                    			#end
                          #declare roty1k = ((360*gvarot)/2)-(rand(rnd_rota3y)*(360*gvarot));
                          #declare gdeb12 = (deb_grana - (11*0.076)*deb_brzina)*odbal;
			                    size_variation ()
                          #declare gduz1k = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
                          // #declare gdeb1 = (deb_grana - (11*0.076)*deb_brzina)*odbal;
                          #declare trany1k= gduz1j;
                          
                          // COUNTER 13
                          #declare counter13 = 0;
                          #while (counter13 < 3)
         									#declare tg_level = 13;
                          #if (algorythm=1)
                          	union {
                          #else
                          	object {
                          #end
                			        #if (counter13=0)
                            		ispit_grananja (pos_grananja2,rnd_gran3,third_br_to/tg_level)
                              	#if (grananje = 2)
                                	#declare counter13 = counter13 + 1;
                              	#else
                       						#if (grananje=3)
                                  	#declare counter13 = counter13;
                       						#else
                                  	#declare counter13 = counter13 + 2;
                                  	#declare rotx1l = rand(rnd_rota3x)*max_rota2;
                              	  #end
                              	#end
                            	#end
                        			#if (grananje!=1)
                        			  #declare rotx1l = min_rota+rand(rnd_rota3x)*(max_rota-min_rota); 
                        			#end
                            	#declare roty1l = ((360*gvarot)/2)-(rand(rnd_rota3y)*(360*gvarot));
                            	#declare gdeb13 = (deb_grana - (12*0.076)*deb_brzina)*odbal;
			                        size_variation ()
                            	#declare gduz1l = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
                            	// #declare gdeb1 = (deb_grana - (12*0.076)*deb_brzina)*odbal;
                            	#declare trany1l= gduz1k;
                            	#declare counter14 = 0;
                            
                            	// COUNTER 14
                            	#while (counter14 < last_branch_max )
         											#declare tg_level = 14;
                            	#debug "Tree Generation: "
                            	#debug str(counter2,0,0)
                            	#debug str(counter3,0,0)
                            	#debug str(counter4,0,0)
                            	#debug str(counter5,0,0)
                            	#debug str(counter6,0,0)
                            	#debug str(counter7,0,0)
                            	#debug str(counter8,0,0)
                            	#debug str(counter9,0,0)
                            	#debug str(counter10,0,0)
                            	#debug str(counter11,0,0)
                            	#debug str(counter12,0,0)
                            	#debug str(counter13,0,0)
                            	#debug "\n"
                            	#if (algorythm=1)
                             		#if (leafs)
                              		union {
                              	#else
                              		object {
                              	#end
                              			// ## GRANE IZ PCOUNTER14 ######################################################
                      			        #if (counter14=0)
                                  		ispit_grananja (pos_grananja2,rnd_gran3,third_br_to/tg_level)
                                  		#if (grananje = 2)
                                    		#declare counter14 = counter14 + 1;
                                  		#else
                             						#if (grananje=3)
                                    		  #declare counter14 = counter14;
                             						#else
                                    		  #declare counter14 = counter14 + 2;
                                    		  #declare rotx1m = rand(rnd_rota3x)*max_rota2;
                                  		  #end
                                  		#end
                                		#end
                              			#if (grananje!=1)
                              			  #declare rotx1m = min_rota+rand(rnd_rota3x)*(max_rota-min_rota); 
                              			#end
                                		#declare roty1m = ((360*gvarot)/2)-(rand(rnd_rota3y)*(360*gvarot));
			                              size_variation ()
                                		#declare gduz1m = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
                                		#declare gdeb14 = (deb_grana - (13*0.076)*deb_brzina)*odbal;
                                		#declare trany1m= gduz1l;
	                     	    				// BRANCHES - COUNTER 14 ---V---V
	                                		#if (leafs)
	                                			last_branch ( gduz1m, gdeb14 )
	                                		#else
	                                  		grana ( gduz1m, gdeb14,gdeb14)
	                                		#end
	                                		rotate x*rotx1m
	                                		rotate y*roty1m
	                                		translate y*(trany1m/1+(rand(rnd_gran)*3))
                      	  					// --------------------- ---^---^
                                	}           
                              #else
	                              size_variation ()
                                #declare gduz1m = st_siz_branch-(tg_level*siz_add_factor)+siz_rnd_add;
                                #declare gdeb14 = (deb_grana - (13*0.076)*deb_brzina)*odbal;
                                #declare trany1m= gduz1l;
                                #declare rotx1m = min_rota+rand(rnd_rota3x)*(max_rota-min_rota);
                                #declare roty1m = (360*gvarot);
                     	    		  
                     	    		  // STORING END POINTS FOR 14 LEVEL  ---V---V
                            	  #if (algorythm=2)
                                	get_point (14) 
                                	#declare po2[ar2] = point;
                                	#declare ar2 = ar2+1;
                     	    			#end
                     	    			// -------------------------------- ---V---V
                              
                              #end
                              #declare counter14 = counter14 + 1;
                              #end           
                              
                              // STORING END POINTS FOR 13 LEVEL  ---V---V
                            	#if (algorythm=2)
                              	get_point (13) 
                              	#declare po1[ar1] = point;
                              	#declare ar1 = ar1+1;
                   	    			#end
                   	    			// -------------------------------- ---V---V
                     	    		
                     	    		// BRANCHES - COUNTER 13 ---V---V
                           		//last_branch ( gduz1l, gdeb13 )
                              	grana ( gduz1l, gdeb13,gdeb14)
                              	rotate x*rotx1l
                              	rotate y*roty1l
                              	translate y*trany1l
                      	  		// --------------------- ---^---^
                            } 
                            #declare counter13 = counter13 + 1;
                          #end
                    	    // BRANCHES - COUNTER 12 ---V---V
                          	#declare opt1 = off;
                          	grana ( gduz1k, gdeb12, gdeb13)
                          	rotate x*rotx1k
                          	rotate y*roty1k
                        		translate y*trany1k
                      	  // --------------------- ---^---^
                        } 
                        #declare counter12 = counter12 + 1;
                        #end
                    	  // BRANCHES - COUNTER 11 ---V---V
                        	#declare opt1 = off;
                        	grana ( gduz1j, gdeb11, gdeb12 )
                        	rotate x*rotx1j
                        	rotate y*roty1j
                        	translate y*trany1j
                      	// --------------------- ---^---^
                      } 
                      #declare counter11 = counter11 + 1;
                      #end
                    	// BRANCHES - COUNTER 10 ---V---V
                      	#declare opt1 = off;
                      	grana ( gduz1i, gdeb10, gdeb11 )
                      	rotate x*rotx1i
                      	rotate y*roty1i
                      	translate y*trany1i
                      // --------------------- ---^---^
                    } 
                    #declare counter10 = counter10 + 1;
                    #end
                    #declare opt1 = off;
                    // BRANCHES - COUNTER 9 ---V---V
                    	grana ( gduz1h, gdeb9, gdeb10 )
                    	rotate x*rotx1h
                    	rotate y*roty1h
                    	translate y*trany1h
                    // -------------------- ---^---^
                  } 
                  #declare counter9 = counter9 + 1;
                  #end
                  #declare opt1 = off;
                  // BRANCHES - COUNTER 8 ---V---V
                    grana ( gduz1g, gdeb8, gdeb9 )
                    rotate x*rotx1g
                    rotate y*roty1g
                    translate y*trany1g
                  // -------------------- ---^---^
                } 
                #declare counter8 = counter8 + 1;
                #end
                // BRANCHES - COUNTER 7 ---V---V
                	#declare opt1 = off;
                	grana ( gduz1f, gdeb7, gdeb8 )
                	rotate x*rotx1f
                	rotate y*roty1f
                	translate y*trany1f
                // -------------------- ---^---^
              } 
              #if (branching_with_metaballs) 
              	#if  (dspojk7)
                	spojka (
                  	duz_grana - (5*0.076)*duz_brzina,
                    (deb_grana - (5*0.076)*deb_brzina)*(odb1*odb2*odb3*odb4*odb5),
                    gduz1,
                    gdeb1,
                    rotx1f,
                    roty1
                  )
                #end
              #end
              #declare counter7 = counter7 + 1;
              #end
              // BRANCHES - COUNTER 6 ---V---V
              	#declare opt1 = off;
              	grana ( gduz1e, gdeb6, gdeb7 )
              	rotate x*rotx1e
              	rotate y*roty1e
              	translate y*trany1e
              // -------------------- ---^---^
            }
            #if (branching_with_metaballs) 
              #if (dspojk6)
                spojka (
                  duz_grana - (4*0.076)*duz_brzina,
                  (deb_grana - (4*0.076)*deb_brzina)*(odb1*odb2*odb3*odb4),
                  gduz1,
                  gdeb1,
                  rotx1e,
                	roty1
              	)
            	#end
            #end
            #declare counter6 = counter6 + 1;
            #end
            // BRANCHES - COUNTER 5 ---V---V
            	#declare opt1 = off;
            	grana ( gduz1d, gdeb5, gdeb6 )
            	rotate x*rotx1d
            	rotate y*roty1d
          		translate y*trany1d
            // -------------------- ---^---^
          }
          #if (branching_with_metaballs)
          	#if (dspojk5)
              spojka (
                duz_grana - (3*0.076)*duz_brzina,
                (deb_grana - (3*0.076)*deb_brzina)*(odb1*odb2*odb3),
                gduz1,
                gdeb1,
                rotx1d,
              	roty1
            	)
          	#end
          #end
          #declare counter5 = counter5 + 1;
          #end
          // BRANCHES - COUNTER 4 ---V---V
          	#declare opt1 = off;
          	grana ( gduz1c, gdeb4, gdeb5  )
          	rotate x*rotx1c
          	rotate y*roty1c
          	translate y*trany1c
          // -------------------- ---^---^
        } 
        #if (branching_with_metaballs)
        	#if (dspojk4)
          	spojka (
            	duz_grana - (2*0.076)*duz_brzina,
              (deb_grana - (2*0.076)*deb_brzina)*(odb1*odb2),
              gduz1,
              gdeb1,
              rotx1c,
              roty1
            )
          #end
        #end
        #declare counter4 = counter4 + 1;
        #end
        // BRANCHES - COUNTER 3 ---V---V
        	#declare opt1 = off;
        	grana ( gduz1b, gdeb3, gdeb4 )
        	rotate x*rotx1b
        	rotate y*roty1b
      		translate y*trany1b
        // -------------------- ---^---^
      } 
      #if (branching_with_metaballs)
      	#if (dspojk3)
        	spojka (
            duz_grana - (1*0.076)*duz_brzina,
            (deb_grana - (1*0.076)*deb_brzina)*odb1,
            gduz1,
            gdeb1,
            rotx1b,
            roty1
          )
        #end
      #end
      #declare counter3 = counter3 + 1;
      #end
      // BRANCHES - COUNTER 2 ---V---V
      	#declare opt1 = off;
      	grana ( gduz1a, gdeb2, gdeb3 )
      	rotate x*rotx1a
      	rotate y*roty1a
    		translate y*trany1a
      // -------------------- ---^---^
    }
    #if (branching_with_metaballs)
    	#if (dspojk2)
      	spojka ( duz_grana,deb_grana,gduz1,gdeb1,rotx1a,roty1)
      #end
    #end
    #declare counter2 = counter2 +1;                    
    #end
    // BRANCHES AND ROOTS - COUNTER 1 ---V---V
    	grana ( gsiz_first_branch, deb_grana, gdeb2)
    	#if (roots) object { dno } #end
    	texture { BranchTex1 }
    	scale scals
    	rotate rotas
  		translate trans
    // ------------------------------ ---^---^
  }
  #declare counter1 = counter1 + 1;
  #end
    
  // BRANCHES WITH LEAFS 
  #if (algorythm=2)
  	#declare lsseed = seed (23423);
    #if (leafs)
    	#declare point_counter = 0;
      #while (point_counter < ar1)
      	#declare lsw = rand(lseed);
        #if (lsw<0.5)
        	plod(po1[point_counter],po2[point_counter])
        #end
      	#declare point_counter = point_counter + 1;
    	#end
  	#end
  #end    
  scale scals
  rotate rotas
  translate trans
}
