//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 15 materials and 225 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 10/31/1999    (31.10.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment


// Scene Includes

#include "C:\My Documents\POV\Horror\sleeping_vampire.pov"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }



#declare MMistyFog = 
   media  // MMistyFog
   {
      scattering
      {
         2 ,  rgb <0.0, 0.0, 0.004> // mie hazy scattering
      }
   }

media { MMistyFog }

camera {  //  Camera MainCamera
  location  <   -158.793,    -320.569,     123.173>
  direction <        0.0,         0.0,      2.1144> // Aperture is 0.46 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    -34.802,    -107.715,      63.796>
}

//    Other cameras are commented out.
/*
camera {  //  Camera TestCamera
  location  <    -50.938,    -225.996,      82.790>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    -25.828,    -130.001,      23.193>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light2
  <-180.000, -154.000, 120.000>
  color rgb <1.000, 0.800, 0.700>*0.3000
  media_interaction off
}

light_source {   // MoonLight
  <-300.000, 3148.363, 1923.387>
  color rgb <0.886, 0.886, 1.000>*2.7137
}

light_source {   // Light1
  <-180.000, -54.000, 120.000>
  color rgb <1.000, 0.800, 0.700>*0.3000
  media_interaction off
}


//
// ********  MATERIALS  *******
//

#include "chamber.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare WindowFrame = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 9.0, 2.0>
    rotate 10.0*x
    translate  <-40.0, 2.0, 40.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 9.0, 38.0>
    rotate 5.0*z
    translate  <-22.0, 2.0, 79.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 9.0, 38.0>
    rotate -5.0*z
    translate  <-58.0, 2.0, 79.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <10.5, 9.0, 2.0>
    rotate 10.0*y
    translate  <-30.0, 2.0, 120.0>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <10.5, 9.0, 2.0>
    rotate -10.0*y
    translate  <-50.0, 2.0, 120.0>
  }
  material {
    Black_Vein_Granit
  }
}
#declare Cube006 = object {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 2.0, 1.0>
  }
}
#declare Cylndr001 = object {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 60.0>
    translate  9.0*x
  }
}
#declare WindowBars = union {
  object { Cube006 }
  object { // Cube007->Cube006
    Cube006
    translate  60.0*z
  }
  object { Cylndr001 }
  object { // Cylndr002->Cylndr001
    Cylndr001
    translate  -6.0*x
  }
  object { // Cylndr003->Cylndr001
    Cylndr001
    translate  -12.0*x
  }
  object { // Cylndr004->Cylndr001
    Cylndr001
    translate  -18.0*x
  }
  material {
    WroughtIron
  }
  translate  <-40.0, 0.0, 50.0>
}
#declare Window = union { // Window
  object { WindowFrame }
  object { WindowBars }
}


#declare Stone = object {
  superellipsoid { // Stone
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    translate  <0.0, -10.0, 10.0>
  }
}
#declare StoneRow1 = union {
  object { Stone }
  object { // Stone1->Stone
    Stone
    translate  -20.0*y
  }
  object { // Stone2->Stone
    Stone
    translate  -40.0*y
  }
  object { // Stone3->Stone
    Stone
    translate  -60.0*y
  }
  object { // Stone4->Stone
    Stone
    translate  -80.0*y
  }
  object { // Stone5->Stone
    Stone
    translate  -100.0*y
  }
  object { // Stone6->Stone
    Stone
    translate  -120.0*y
  }
  object { // Stone7->Stone
    Stone
    translate  -140.0*y
  }
  object { // Stone8->Stone
    Stone
    translate  -160.0*y
  }
  object { // Stone9->Stone
    Stone
    translate  -180.0*y
  }
  object { // Stone10->Stone
    Stone
    translate  -200.0*y
  }
  object { // Stone11->Stone
    Stone
    translate  -220.0*y
  }
  object { // Stone12->Stone
    Stone
    translate  -240.0*y
  }
  object { // Stone13->Stone
    Stone
    translate  -260.0*y
  }
  object { // Stone14->Stone
    Stone
    translate  -280.0*y
  }
  object { // Stone15->Stone
    Stone
    translate  -300.0*y
  }
  object { // Stone16->Stone
    Stone
    translate  -320.0*y
  }
}
#declare StoneRow2 = object {
  object { // StoneRow2->StoneRow1
    StoneRow1
    translate  <0.0, 10.0, 20.0>
  }
}


#declare Cube012 = object {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 42.5, 1.0>
    translate  <15.0, 0.0, 7.0>
  }
}
#declare Cube016 = object {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <15.5, 0.5, 1.0>
    translate  <0.0, 42.0, 7.0>
  }
}
#declare Cube020 = object {
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 8.0>
    translate  <14.5, 41.5, 0.0>
  }
}
#declare Cube024 = object {
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 42.5, 2.1>
    translate  <-1.0, 0.0, 2.1>
  }
}
#declare LidEnd = intersection {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  <0.0, -0.5, 1.125>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    rotate 90.0*x
  }
  scale <31.0, 1.0, 17.23514>
  translate  <-16.0, -41.5, -10.75>
}
#declare Cylndr005 = object {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 8.0>
    rotate 90.0*x
  }
}
#declare Cube028 = object {
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 42.0, 2.1>
    translate  <-1.5, 0.0, 2.1>
  }
}
#declare LidEnd2 = intersection {
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  <0.0, -0.5, 1.125>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    rotate 90.0*x
  }
  scale <30.0, 1.0, 17.0>
  translate  <-16.0, -41.0, -10.75>
}
#declare Cylndr021 = object {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate 90.0*x
    translate  35.0*y
  }
}
#declare Cylndr022 = object {
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 4.0>
    rotate 90.0*y
    translate  32.0*y
  }
}
#declare Cylndr023 = object {
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.1>
    rotate 90.0*y
    translate  <3.4, 32.0, 0.0>
  }
}




//
// ********  OBJECTS  *******
//

sphere { // Sphere003
  <0,0,0>,1
  material {
    DreamCloud
  }
  hollow
  scale <7.697972, -11.678428, 13.787037>
  translate  <-36.534391, -69.455736, 63.046117>
}


sphere { // Sphere002
  <0,0,0>,1
  material {
    DreamCloud
  }
  hollow
  scale <7.089066, 5.262346, 11.351411>
  translate  <-38.361111, -56.226072, 39.490511>
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    DreamCloud
  }
  no_shadow
  hollow
  scale <10.0, 75.0, 50.0>
  rotate 24.581121*z
  translate  <-27.858726, -149.166785, 88.316816>
}


box { // DreamPalete
  <-1, -1, -1>, <1, 1, 1>
  material {
    Dream
  }
  no_shadow
  scale <36.0, 0.006429, 27.0>
  rotate -68.326889*z
  translate  <-46.701517, -156.907167, 89.670585>
}


plane { // CloudySky
  z,0
  material {
    Midnight_Sky
  }
  no_shadow
  scale 10000.0
  rotate -182.0*x
  translate  1000.0*z
}


object { // Window1->Window
  Window
  translate  -70.0*x
}


object { Window }




plane { // Ground
  z,0
  material {
    DryGrass
  }
  scale 5000.0
  rotate -5.0*x
  translate  -120.0*z
}


difference { // MainRoom
  box { // RoomCube
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <181.0, 201.0, 121.0>
    translate  <-181.0, -201.0, 121.0>
  }
  box { // WindowHole
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 12.0, 40.0>
    translate  <-40.0, 0.0, 80.0>
  }
  box { // RoomCube1
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <180.0, 200.0, 120.0>
    translate  <-180.0, -200.0, 120.0>
  }
  box { // WindowHole1
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 12.0, 40.0>
    translate  <-110.0, 0.0, 80.0>
  }
  material {
    RoughStone
  }
}




#declare BackWallRow1 = union {
  superellipsoid { // Stone17
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone18
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-20.0, 0.0, 10.0>
  }
  superellipsoid { // Stone19
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-40.0, 0.0, 10.0>
  }
  superellipsoid { // Stone20
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone21
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone22
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-100.0, 0.0, 10.0>
  }
  superellipsoid { // Stone23
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-120.0, 0.0, 10.0>
  }
  superellipsoid { // Stone24
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone25
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone26
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone27
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
}
#declare BackWallRow2 = union {
  superellipsoid { // Stone28
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone29
    <0.295, 0.281>
    scale <1.0, 5.0, 10.0>
    rotate -90.0*z
    translate  <-15.0, 0.0, 10.0>
  }
  superellipsoid { // Stone31
    <0.295, 0.281>
    scale <1.0, 5.0, 10.0>
    rotate -90.0*z
    translate  <-65.0, 0.0, 10.0>
  }
  superellipsoid { // Stone32
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone35
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone36
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone37
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone38
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  40.0*z
}
#declare BackWallRow3 = union {
  superellipsoid { // Stone39
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone40
    <0.295, 0.281>
    scale <1.0, 5.0, 10.0>
    rotate -90.0*z
    translate  <-15.0, 0.0, 10.0>
  }
  superellipsoid { // Stone42
    <0.295, 0.281>
    scale <1.0, 5.0, 10.0>
    rotate -90.0*z
    translate  <-65.0, 0.0, 10.0>
  }
  superellipsoid { // Stone43
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone46
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone47
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone48
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone49
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  80.0*z
}
#declare BackWallRow4 = union {
  superellipsoid { // Stone50
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone51
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-20.0, 0.0, 10.0>
  }
  superellipsoid { // Stone52
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-40.0, 0.0, 10.0>
  }
  superellipsoid { // Stone53
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone54
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone55
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-100.0, 0.0, 10.0>
  }
  superellipsoid { // Stone56
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-120.0, 0.0, 10.0>
  }
  superellipsoid { // Stone57
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone58
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone59
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone60
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  120.0*z
}
#declare BackWallRow5 = union {
  superellipsoid { // Stone61
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone62
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-20.0, 0.0, 10.0>
  }
  superellipsoid { // Stone63
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-40.0, 0.0, 10.0>
  }
  superellipsoid { // Stone64
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone65
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone66
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-100.0, 0.0, 10.0>
  }
  superellipsoid { // Stone67
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-120.0, 0.0, 10.0>
  }
  superellipsoid { // Stone68
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone69
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone70
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone71
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  160.0*z
}
#declare BackWallRow6 = union {
  superellipsoid { // Stone72
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone73
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-20.0, 0.0, 10.0>
  }
  superellipsoid { // Stone74
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-40.0, 0.0, 10.0>
  }
  superellipsoid { // Stone75
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone76
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone77
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-100.0, 0.0, 10.0>
  }
  superellipsoid { // Stone78
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-120.0, 0.0, 10.0>
  }
  superellipsoid { // Stone79
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone80
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone81
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone82
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  200.0*z
}
#declare BackWallRow7 = union {
  superellipsoid { // Stone83
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone84
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-20.0, 0.0, 10.0>
  }
  superellipsoid { // Stone85
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-40.0, 0.0, 10.0>
  }
  superellipsoid { // Stone86
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone87
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone88
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-100.0, 0.0, 10.0>
  }
  superellipsoid { // Stone89
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-120.0, 0.0, 10.0>
  }
  superellipsoid { // Stone90
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone91
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone92
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone93
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  <-10.0, 0.0, 20.0>
}
#declare BackWallRow8 = union {
  superellipsoid { // Stone94
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone97
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone98
    <0.295, 0.281>
    scale <1.0, 5.0, 10.0>
    rotate -90.0*z
    translate  <-75.0, 0.0, 10.0>
  }
  superellipsoid { // Stone100
    <0.295, 0.281>
    scale <1.0, 5.0, 10.0>
    rotate -90.0*z
    translate  <-125.0, 0.0, 10.0>
  }
  superellipsoid { // Stone101
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone102
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone103
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone104
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  <-10.0, 0.0, 60.0>
}
#declare BackWallRow9 = union {
  superellipsoid { // Stone105
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone108
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone109
    <0.295, 0.281>
    scale <1.0, 5.0, 10.0>
    rotate -90.0*z
    translate  <-75.0, 0.0, 10.0>
  }
  superellipsoid { // Stone111
    <0.295, 0.281>
    scale <1.0, 5.0, 10.0>
    rotate -90.0*z
    translate  <-125.0, 0.0, 10.0>
  }
  superellipsoid { // Stone112
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone113
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone114
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone115
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  <-10.0, 0.0, 100.0>
}
#declare BackWallRow10 = union {
  superellipsoid { // Stone116
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone117
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-20.0, 0.0, 10.0>
  }
  superellipsoid { // Stone118
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-40.0, 0.0, 10.0>
  }
  superellipsoid { // Stone119
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone120
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone121
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-100.0, 0.0, 10.0>
  }
  superellipsoid { // Stone122
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-120.0, 0.0, 10.0>
  }
  superellipsoid { // Stone123
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone124
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone125
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone126
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  <-10.0, 0.0, 140.0>
}
#declare BackWallRow11 = union {
  superellipsoid { // Stone127
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone128
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-20.0, 0.0, 10.0>
  }
  superellipsoid { // Stone129
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-40.0, 0.0, 10.0>
  }
  superellipsoid { // Stone130
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone131
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone132
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-100.0, 0.0, 10.0>
  }
  superellipsoid { // Stone133
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-120.0, 0.0, 10.0>
  }
  superellipsoid { // Stone134
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone135
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone136
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone137
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  <-10.0, 0.0, 180.0>
}
#declare BackWallRow12 = union {
  superellipsoid { // Stone138
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  10.0*z
  }
  superellipsoid { // Stone139
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-20.0, 0.0, 10.0>
  }
  superellipsoid { // Stone140
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-40.0, 0.0, 10.0>
  }
  superellipsoid { // Stone141
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-60.0, 0.0, 10.0>
  }
  superellipsoid { // Stone142
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-80.0, 0.0, 10.0>
  }
  superellipsoid { // Stone143
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-100.0, 0.0, 10.0>
  }
  superellipsoid { // Stone144
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-120.0, 0.0, 10.0>
  }
  superellipsoid { // Stone145
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-140.0, 0.0, 10.0>
  }
  superellipsoid { // Stone146
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-160.0, 0.0, 10.0>
  }
  superellipsoid { // Stone147
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-180.0, 0.0, 10.0>
  }
  superellipsoid { // Stone148
    <0.295, 0.281>
    scale <1.0, 10.0, 10.0>
    rotate -90.0*z
    translate  <-200.0, 0.0, 10.0>
  }
  translate  <-10.0, 0.0, 220.0>
}
union { // BackWall
  object { BackWallRow1 }
  object { BackWallRow2 }
  object { BackWallRow3 }
  object { BackWallRow4 }
  object { BackWallRow5 }
  object { BackWallRow6 }
  object { BackWallRow7 }
  object { BackWallRow8 }
  object { BackWallRow9 }
  object { BackWallRow10 }
  object { BackWallRow11 }
  object { BackWallRow12 }
  material {
    Gray_Vein_Granit
  }
}


union { // SideWall
  object { StoneRow1 }
  object { StoneRow2 }
  object { // StoneRow3->StoneRow1
    StoneRow1
    translate  40.0*z
  }
  object { // StoneRow4->StoneRow1
    StoneRow1
    translate  80.0*z
  }
  object { // StoneRow5->StoneRow1
    StoneRow1
    translate  120.0*z
  }
  object { // StoneRow6->StoneRow1
    StoneRow1
    translate  160.0*z
  }
  object { // StoneRow7->StoneRow1
    StoneRow1
    translate  200.0*z
  }
  object { // StoneRow8->StoneRow2
    StoneRow2
    translate  40.0*z
  }
  object { // StoneRow9->StoneRow2
    StoneRow2
    translate  80.0*z
  }
  object { // StoneRow10->StoneRow2
    StoneRow2
    translate  120.0*z
  }
  object { // StoneRow11->StoneRow2
    StoneRow2
    translate  160.0*z
  }
  object { // StoneRow12->StoneRow2
    StoneRow2
    translate  200.0*z
  }
  material {
    Gray_Vein_Granit
  }
}


#declare CoffinBox = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 42.0, 8.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <14.0, 41.0, 8.0>
    translate  1.0*z
  }
}
#declare CoffinWood = union {
  object { CoffinBox }
  object { Cube012 }
  object { // Cube013->Cube012
    Cube012
    translate  -30.0*x
  }
  object { // Cube014->Cube012
    Cube012
    translate  <-30.0, 0.0, -14.0>
  }
  object { // Cube015->Cube012
    Cube012
    translate  -14.0*z
  }
  object { Cube016 }
  object { // Cube017->Cube016
    Cube016
    translate  -14.0*z
  }
  object { // Cube018->Cube016
    Cube016
    translate  <0.0, -84.0, -14.0>
  }
  object { // Cube019->Cube016
    Cube016
    translate  -84.0*y
  }
  object { Cube020 }
  object { // Cube021->Cube020
    Cube020
    translate  <-29.0, -0.0, 0.0>
  }
  object { // Cube022->Cube020
    Cube020
    translate  <-29.0, -83.0, 0.0>
  }
  object { // Cube023->Cube020
    Cube020
    translate  -83.0*y
  }
  material {
    BlackLaqueredWood
  }
}
#declare CoffinPad = difference {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <14.0, 41.0, 7.5>
    translate  0.5*z
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <13.0, 40.0, 7.5>
    translate  1.5*z
  }
  material {
    RedVelvetPad
  }
}
#declare CSG001 = intersection {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    rotate 90.0*x
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  <0.0, -0.5, 1.125>
  }
}
#declare LidTop = difference {
  object { CSG001 }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    rotate 90.0*x
    translate  -0.02*z
  }
  scale <31.0, 85.0, 17.23514>
  translate  <-16.0, 42.5, -10.75>
}
#declare CoffinLidBox = union {
  object { Cube024 }
  object { LidEnd }
  object { // LidEnd1->LidEnd
    LidEnd
    translate  84.0*y
  }
  object { // Cube026->Cube024
    Cube024
    translate  -30.0*x
  }
  object { LidTop }
  material {
    BlackLaqueredWood
  }
}
#declare Hinge = union {
  object { Cylndr005 }
  object { // Cylndr006->Cylndr005
    Cylndr005
    translate  -9.0*y
  }
  object { // Cylndr007->Cylndr005
    Cylndr005
    translate  -18.0*y
  }
  object { // Cylndr008->Cylndr005
    Cylndr005
    translate  -27.0*y
  }
  object { // Cylndr009->Cylndr005
    Cylndr005
    translate  -36.0*y
  }
  object { // Cylndr010->Cylndr005
    Cylndr005
    translate  -45.0*y
  }
  object { // Cylndr011->Cylndr005
    Cylndr005
    translate  -54.0*y
  }
  object { // Cylndr012->Cylndr005
    Cylndr005
    translate  -63.0*y
  }
  object { // Cylndr013->Cylndr005
    Cylndr005
    translate  -72.0*y
  }
  material {
    Brass_Metal
  }
  translate  39.639602*y
}
#declare CSG002 = intersection {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    rotate 90.0*x
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  <0.0, -0.5, 1.125>
  }
}
#declare LidTop1 = difference {
  object { CSG002 }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    rotate 90.0*x
    translate  -0.02*z
  }
  scale <30.0, 85.0, 17.23514>
  translate  <-16.0, 42.5, -11.5>
}
#declare CoffinLidLiner = union {
  object { Cube028 }
  object { LidEnd2 }
  object { LidTop1 }
  object { // Cube030->Cube028
    Cube028
    rotate -0.0*y
    translate  -29.0*x
  }
  object { // LidEnd3->LidEnd2
    LidEnd2
    translate  <0.0, 83.0, 0.0>
  }
  material {
    RedVelvetPad
  }
}
#declare CoffinLid = union {
  object { CoffinLidBox }
  object { Hinge }
  object { CoffinLidLiner }
  rotate <-0.0, -253.439468, 0.0>
  translate  <16.0, 0.0, 8.0>
}
#declare CoffinRail = union {
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 84.0>
    rotate 90.0*x
    translate  42.0*y
  }
  object { Cylndr021 }
  object { Cylndr022 }
  object { Cylndr023 }
  object { // Cylndr024->Cylndr023
    Cylndr023
    translate  <0.0, -32.0, 0.0>
  }
  object { // Cylndr025->Cylndr023
    Cylndr023
    translate  <0.0, -64.0, 0.0>
  }
  object { // Cylndr026->Cylndr021
    Cylndr021
    translate  -32.0*y
  }
  object { // Cylndr027->Cylndr021
    Cylndr021
    translate  -64.0*y
  }
  object { // Cylndr028->Cylndr022
    Cylndr022
    translate  -32.0*y
  }
  object { // Cylndr029->Cylndr022
    Cylndr022
    translate  -64.0*y
  }
  material {
    Brass_Metal
  }
  translate  <-19.0, 0.0, 4.0>
}
union { // Coffin
  object { CoffinWood }
  object { CoffinPad }
  object { CoffinLid }
  object { CoffinRail }
  scale 1.5
  translate  <-48.8, -120.0, 20.0>
}


box { // Floor
  <-1, -1, -1>, <1, 1, 1>
  material {
    GraniteFloor
  }
  scale <180.0, 180.0, 1.0>
  translate  <-180.0, -180.0, 0.0>
}




