
// POV-Ray Object File - Fire Truck
// created 10-Sep-99
// last update 10-Sep-99
// 1999 Glenn McCarter
// This file does not render.  #include "FireTruck.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// FireTruck
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Front of truck is at x=0, truck extends into +x


//===============================================
//             Variables
//===============================================




//===============================================
//             Textures
//===============================================

#declare FireTruckTex =
	texture {
//		pigment { color rgb <0.857,0.122,0.120> } // red
		pigment { color rgb <0.952,0.962,0.982> } // test white
//		finish { ambient .10 specular .85 roughness .018 } // red
		finish { ambient .16 specular .85 roughness .018 } // white
	}
#declare UnderbodyTex =
	texture {
		pigment { color rgb <0.289,0.265,0.257> } // grey
		finish { ambient .16 specular .25 roughness .018 }
	}
#declare WindshieldTex =
	texture {
		pigment { color rgb <0.257,0.242,0.120> }
		finish { ambient .10 specular .85 roughness .018 reflection .3 }
	}
#declare LightBarGlassTex =
	texture {
		pigment { color rgbt <0.257,0.242,0.120,0.6> }
		finish { ambient .10 specular .85 roughness .038 reflection .13 }
	}
#declare MetalTex =
	texture {
		pigment { color rgb <0.723,0.722,0.820> }
		finish { ambient .10 specular .85 roughness .018 }
	}
#declare TTireTex =
	texture {
		pigment { color rgb <.081,.081,.081> }
		normal { bumps 0.3 scale <3,.4,3> }
		finish { ambient .10 specular .25 roughness .125 }
	}



//===============================================
//             Objects
//===============================================

#declare HeadlightRH =
		light_source {
			<0,0,0>
			color rgb <1, 1, .47>*1.2
			media_interaction off
			fade_distance 30*Feet
			fade_power 1
			spotlight
			point_at <-30*Feet,0,-2*Feet>
			radius 9    // degrees fully lit (*2)
			falloff 16   // degrees no lighting (*2)
			tightness 1
			looks_like {
			union {
				superellipsoid { // headlamp
					<.2,.2>
					scale <1,7,4>
					texture {
						pigment { color rgb<1,1,1>*6 }
						finish { ambient .99 diffuse .2 }
					}
				}
				superellipsoid { // park/turn lamp
					<.2,.2>
					scale <2,3,4>
					translate <0,6,0>
					texture {
						pigment { color rgb<1,.26,.08>*6 }
						finish { ambient .99 diffuse .2 }
					}
				}
			} // end union
			}
		}
#declare HeadlightLH = object { HeadlightRH scale <1,-1,1> }

#declare TWheelS =
	cylinder {
		<0,0,0>,<0,10.5,0>,16
		translate <0,0,12.5>
		texture { TTireTex }
	}

#declare WindshieldS = // simple version
	box {
		<0,-3.2*Feet,0>,<1,3.2*Feet,1.9*Feet>
		texture { WindshieldTex }
		rotate <0,27,0>
		translate <4.0*Feet,0,4.2*Feet>
	}
#declare Windshield =
	superellipsoid { // windshield
		<.4,.4>
		scale <6,38,23>
		rotate <0,27,0>
		translate <32,0,52>
		texture { WindshieldTex }
	}

#declare LightBar =
	union {
		box { // outer
			<-3.5,-2.8*Feet,0>,<3.5,2.8*Feet,6>
			texture { LightBarGlassTex }
		}
		box { // inner
			<-2,-14,1>,<2,14,4>
			texture { MetalTex }
		}
		sphere { // redlight
			<0,0,0>,3
			translate <0,-2.3*Feet,6>
			texture {
				pigment { color rgb<1.0,0.1,0.0> }
				finish { ambient 4.92 }
			}
		}
		sphere { // bluelight
			<0,0,0>,3
			translate <0, 2.3*Feet,6>
			texture {
				pigment { color rgb<0.1,0.0,1.0> }
				finish { ambient 4.92 }
			}
		}
	} // end union

#declare FireTruckS = // simple version
	union {
		box { // hood
			<0,-3.5*Feet,10>,<5*Feet,3.5*Feet,4*Feet>
			texture { FireTruckTex }
		}
		box { // cockpit
			<5*Feet,-3.4*Feet,10>,<9*Feet,3.4*Feet,6.5*Feet>
			texture { FireTruckTex }
		}
		box { // box
			<9.3*Feet,-3.5*Feet,10>,<25*Feet,3.5*Feet,6.4*Feet>
			texture { FireTruckTex }
		}
	} // end union

#declare BedShape =
	union {
		superellipsoid { // main
			<.3,.3>
			scale <50,42,20>
			translate <0,0,28>
		}
		superellipsoid { // wheel well
			<.3,.3>
			scale <28,45,15>
			translate <0,0,23>
		}
		texture { FireTruckTex }
	} // end union

#declare Bed =
	union {
		difference {
			object { BedShape }
			cylinder { // wheel well
				<0,-60,0>,<0,60,0>,16
				translate <0,0,16>
				texture { UnderbodyTex }
			}
		} // end difference
		box { // toolbox
			<-4*Feet,-36,0>,<4*Feet,36,50>
			translate <0,0,50>
		}
		box { // toolboxbase
			<-4*Feet,-33,0>,<4*Feet,33,20>
			translate <0,0,40>
		}
		texture { FireTruckTex }
	} // end union

#declare CabShape =
	union {
		superellipsoid { // hood
			<.62,.62>
			scale <28,40,6>
			rotate <0,-6,0>
			translate <0,0,46>
		}
		difference {
			superellipsoid { // fender and front end
				<.2,.2>
				scale <40,42,17>
				translate <14,0,26>
			}
			cylinder { // grille
				<-20,0,0>,<0,0,0>,16
				scale <1,1,.3>
				translate <-20,0,31>
			}		
			box { // bumper slice
				<-20,-60,0>,<20,60,2>
				translate <-20,0,23>
			}		
		} // end difference
		superellipsoid { // cab
			<.32,.32>
			scale <18,38,26>
			rotate <0,27,0>
			translate <52,0,36+14>
		}
		texture { FireTruckTex }
	} // end union
#declare Cab =
	union {
		difference {
			object { CabShape }
			cylinder { // wheel well
				<0,-60,0>,<0,60,0>,16
				translate <10,0,20>
				texture { UnderbodyTex }
			}
		} // end difference
		object { Windshield }
		texture { FireTruckTex }
	} // end union

#declare FireTruckSS =
	union {
		object { FireTruckS }
		object { LightBar translate <7*Feet,0,6.6*Feet> }
		object { WindshieldS }
		object { HeadlightLH translate <-1,-2.4*Feet,3.3*Feet> }
		object { HeadlightRH translate <-1, 2.4*Feet,3.3*Feet> }
	}
#declare FireTruck =
	union {
		object { Cab translate <26,0,0> }
		object { Bed translate <142,0,0> }
		object { TWheelS translate <30,-44,0> }
		object { TWheelS rotate z*180 translate <30,44,0> }
		object { TWheelS translate <148,-44,0> }
		object { TWheelS rotate z*180 translate <148,44,0> }
		object { LightBar translate <7*Feet,0,6.6*Feet> }
		object { HeadlightLH translate <-1,-2.4*Feet,3.3*Feet> }
		object { HeadlightRH translate <-1, 2.4*Feet,3.3*Feet> }
	}

//===============================================
//             Assemblies
//===============================================

                                

