
// POV-Ray Object File - Lens Flares
// created 24-Sep-99
// last update 28-Oct-99
// 1999 Glenn McCarter
// This file does not render.  #include "LensFlare.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// WhiteFlare
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================




//===============================================
//             Textures
//===============================================


#declare PlainTex =
	texture {
		pigment { color rgb <1,1,1> }
		finish { ambient .10 specular .65 roughness .125 }
	}

#declare FlareSurfTex =
	texture {
		pigment { color rgbf<1,1,1,1> }
//		finish { ambient .1 diffuse 0.7 } // default
		finish { ambient 0 diffuse 0 } // test
	}
#declare WhiteFlareInt =
	interior {
		media {
			emission <.0015,.0015,.0015> // fairly dim
	    density { spherical
				color_map{
					[0.00 color rgb<0.00,0.00,0.00> ] // outside is transparent
					[0.20 color rgb<0.00,0.00,0.00> ] // outside is transparent
					[0.90 color rgb<1.0,1.0,1.0> ] // inside is opaque
				}
			scale .6 // scale it down for turbularization
			turbulence <.06,0.06,.06>
			omega 0.835 // default 0.5, higher = rougher
	    }
		}
	}
#macro FlareInt(FColor)
	interior {
		media {
			emission <.0015,.0015,.0015> // fairly dim
	    density { spherical
				color_map{
					[0.00 color rgb<0.00,0.00,0.00> ] // outside is transparent
					[0.20 color rgb<0.00,0.00,0.00> ] // outside is transparent
					[0.90 color FColor ] // inside is opaque
				}
			scale .6 // scale it down for turbularization
			turbulence <.06,0.06,.06>
			omega 0.835 // default 0.5, higher = rougher
	    }
		}
	}
#end

#declare WhiteFlareMaterial =
	material {
		texture { FlareSurfTex }
		interior { WhiteFlareInt }
	}

#macro FlareMaterial(FColor)
//	material {
		texture { FlareSurfTex }
//		interior { FlareInt(FColor) }
		FlareInt(FColor)
//	}
#end

//===============================================
//             Objects
//===============================================

#declare WhiteFlare =
	sphere {
		<0,0,0>,1
		hollow
//		texture { PlainTex } // test
		material { WhiteFlareMaterial }
		scale 6*Feet
	}

#macro Flare(FColor)
	sphere {
		<0,0,0>,1
		hollow
//		texture { PlainTex } // test
		material { FlareMaterial(FColor) }
		scale 6*Feet
	}
#end

