//
//    EMAIL: castlewrks@aol.com
//    NAME: Robert J Becraft
//    TOPIC:  Gardens
//    COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//    TITLE: "Vista"
//  Include file for 99vista.pov

#ifndef(GL)
  #declare GL=-2;
#end

#declare Leaf1=union{
    triangle{<0,0,0><-.01,.01,0><.01,.01,0> }
    triangle{<0,.008,0><-.012,.02,0><.012,.02,0> }                        
    triangle{<0,.018,0><-.008,.03,0><.008,.03,0> }
    triangle{<0,.028,0><-.004,.04,0><.005,.04,0> }
    triangle{<-.004,.04,0><.005,.04,0><0,.05,.01>}
}

#declare Leaf2=union{
    cylinder{<0,0,0><0,0,.00001> .025 scale <.2,.55,1>}  
    scale 4
}

#declare Leaf3=union{
    cylinder{<0,0,0><0,0,.00001> .025  scale <.5,1,1>}
    triangle{<0,-.025,0><-.02,.005,0><.02,.005,0> }
    triangle{<0,.01,0><-.023,-.015,0><.023,-.015,0>}
    scale 4
}

#declare Leaf4=union{ // star pattern leaf
    cylinder{<0,0,0><0,0,.00001> .025  scale <.25,1,1.2>}
    cylinder{<0,0,0><0,0,.00001> .025  scale <.25,1,1.2> rotate<0,0,45>}
    cylinder{<0,0,0><0,0,.00001> .025  scale <.25,1,1.2> rotate<0,0,-45>}
    scale 4
}

#declare Leaf5=union{ // duck foot pattern leaf
    cylinder{<0,0,0><0,0,.00001> .025 translate<0,.025,0>  scale <.35,1,1.2>}
    cylinder{<0,0,0><0,0,.00001> .025 translate<0,.025,0>  scale <.25,1,1.2> rotate<0,0,25>}
    cylinder{<0,0,0><0,0,.00001> .025 translate<0,.025,0>  scale <.25,1,1.2> rotate<0,0,-25>}
    scale 4
} 

#declare Dirt=texture{pigment{image_map { gif "..\graphics\natfl113.gif" } rotate<90,0,0>} normal{granite .25}}

#declare X1=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers1.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0> rotate<0,0,0>
               }}

#declare X2=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers2.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}
#declare X3=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers3.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}
#declare X4=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}               
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers4.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}
#declare X5=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers5.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}
#declare X6=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers6.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}                                                                
#declare X7=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers7.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}               

// no dirt versions!                                    
#declare X1a= //union{
              // box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers1.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0> rotate<0,0,0>
               }
              //}

#declare X2a= //union{
              // box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers2.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }
              //}
#declare X3a= //union{
              // box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers3.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }
              //}
#declare X4a= //union{
              // box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}               
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers4.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }
              //}
#declare X5a= //union{
              // box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers5.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }
              //}
#declare X6a= //union{
              // box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers6.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }
              //}                                                                
#declare X7a= //union{
              // box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\garden\flowers7.gif" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }
              //}               
                                    
#declare Vine1=box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\vine1.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0> 
               }           
#declare Vine2=box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\vine2.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0> 
               }   
#declare Tree1=union{
               cylinder{<0,0,0><0,.291,0> .5 texture{Dirt}}               
               box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\tree1.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0>
                  scale <9,6,1> 
               }}      
#declare Tree2=union{
               cylinder{<0,0,0><0,.291,0> .5 texture{Dirt}}               
               box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\tree2.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0>
                  scale <9,6,1> 
               }}      
#declare Tree3=union{
               cylinder{<0,0,0><0,.291,0> .5 texture{Dirt}}               
               box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\tree3.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0>
                  scale <9,6,1> 
               }}      
#declare Tree4=union{
               cylinder{<0,0,0><0,.291,0> .5 texture{Dirt}}               
               box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\tree4.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0>
                  scale <9,6,1> 
               }}                                                                                           
#declare Tree5=union{
               cylinder{<0,0,0><0,.291,0> .5 texture{Dirt}}               
               box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\tree5.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0>
                  scale <9,6,1> 
               }}             
#declare Tree6=union{
               cylinder{<0,0,0><0,.291,0> .5 texture{Dirt}}               
               box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\tree6.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0>
                  scale <9,6,1> 
               }}
#declare Tree7=union{
               cylinder{<0,0,0><0,.291,0> .5 texture{Dirt}}               
               box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\tree7.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0>
                  scale <9,6,1> 
               }}                                                  
#declare Tree8=union{
               cylinder{<0,0,0><0,.291,0> .5 texture{Dirt}}               
               box{<0,0,0><1,1,.001> hollow 
                texture{pigment{image_map { gif "..\garden\tree8.gif" transmit 0, 1.0} 
               }} translate<-.5,0,0>
                  scale <9,6,1> 
               }}         
               
                                       
#declare Urn=union{
    difference{
        union{
          sphere{<0,0,0> .5}
          cylinder{<0,-.05,0><0,0,0> .52}
        }
        sphere{<0,0,0> .45}
        box{<-.6,0,-.6><.6,.6,.6>}
     }
    cone{<0,-.45,0>.2 <0,-.6,0> .1}
    cone{<0,-.6,0> .1 <0,-.75,0> .2}
    cylinder{<0,-.75,0><0,-.78,0> .25}
    cylinder{<0,-.78,0><0,-.8,0>.3}
    cylinder{<0,-.8,0><0,-.85,0>.35}
    
    //intersection{
     cylinder{<0,-.02,0><0,-.01,0> .48  texture{Dirt scale .5 rotate<0,45,0> }} // dirt 
    // cylinder{<0,-.02,0><0,-.01,0> .48}
    //} 
}
#declare Urn1=union{
    object{Urn}
    #ifndef(FlowersOff)
      object{X2a rotate<0,180,0> translate<0,-.1,-.2>}
      object{X2a translate<0,-.1,.2>}
    #end
}              
#declare Urn2=union{
    object{Urn}
    #ifndef(FlowersOff)              
     object{X1a rotate<0,180,0> translate<0,-.1,-.2>}
     object{X1a translate<0,-.1,.2>}
    #end
}  
#declare Urn3=union{
    object{Urn}
    #ifndef(FlowersOff)         
     object{X3a rotate<0,180,0> translate<0,-.1,-.2>}
     object{X3a translate<0,-.1,.2>}
    #end
}                                    
#declare Urn4=union{
    object{Urn}
    #ifndef(FlowersOff)            
     object{X4a rotate<0,180,0> scale <1,.75,1> translate<0,-.1,-.2>}
     object{X4a scale <1,.75,1> translate<0,-.1,.2>}
    #end
}                                    
#declare Urn5=union{
    object{Urn}
    #ifndef(FlowersOff)
     object{X5a rotate<0,180,0> translate<0,-.1,-.2>}
     object{X5a translate<0,-.1,.2>}
    #end
}             
                                                
#declare Balustre=union{
     sphere{<0,0,0> .15 scale <.35,1,.35> translate<0,.15,0> }
     sphere{<0,0,0> .15 scale <.35,1,.35> translate<0,-.15,0> } 
     sphere{<0,0,0> .05 }
}
#declare Rail=union{                                   
   box{<-2,.66,-.1><2,.62,.1> } 
   cylinder{<-2,.62,0><-2,.66,0> .1}
   cylinder{<-2,0,0><-2,.04,0> .1}     
   
   box{<-2,.66,-.14><2,.64,.14> } 
   cylinder{<-2,.64,0><-2,.66,0> .14}
   cylinder{<2,.64,0><2,.66,0> .14}       
   
   cylinder{<2,.62,0><2,.66,0> .1}
   cylinder{<2,0,0><2,.04,0> .1}   
   box{<-2,0,-.1><2,.04,.1> }
   #declare C1=-2;
   #while (C1<=2)
      object{Balustre translate<C1,.3,0>}
      #declare C1=C1+.25;
   #end
   texture{T_Stone8}
}  // rail 

#declare Rail12=union{   
   #declare C1=-6;
   #while (C1<=6)
     object{Rail translate<C1,0,0>}
     #declare C1=C1+4;
   #end
} // Rail20

#declare StepTop=union{
       box{<-.1,-.02,-.2><.1,.02,.2> }
       box{<-.1,-.04,.2><.1,-.2,.3> }
       cylinder{<-.1,0,.3><.1,0,.3> .04}
       cylinder{<0,-.02,0><0,.02,0> .1 translate<0,0,-.2> }
}       
#declare Steps=union{
   #declare C1=GL;
   #while (C1<0)
       box{<-1,C1,0><1,C1+.25,6-((3+C1)*4)*.5> texture{T_Stone8}}
       cylinder{<-1+.125,C1+.24,6-((3+C1)*4)*.5-.25> <-1+.125,C1+.26,6-((3+C1)*4)*.5-.25> .27 texture{T_Stone5}}
       cylinder{<1-.125,C1+.24,6-((3+C1)*4)*.5-.25> <1-.125,C1+.26,6-((3+C1)*4)*.5-.25>  .27 texture{T_Stone5}}
       box{<-1,C1+.24,6-((3+C1)*4)*.5-.52><1,C1+.26,6-((3+C1)*4)*.5+.02> texture{T_Stone5}}  
       object{Balustre translate<-1,C1+.3+.25,6-((3+C1)*4)*.5-.25> texture{T_Stone8}}
       object{Balustre translate<1,C1+.3+.25,6-((3+C1)*4)*.5-.25> texture{T_Stone8}}

       box{<-.1,0,-6><.1,.02,-2.25> rotate<25,0,0> translate<-1,-2.1,6> texture{T_Stone8}}
       box{<-.1,0,-6><.1,.02,-2.25> rotate<25,0,0> translate<1,-2.1,6> texture{T_Stone8}} 
       
       object{StepTop translate<-1,.6,.4> texture{T_Stone8}}
       object{StepTop translate<1,.6,.4> texture{T_Stone8}}  
       
       #declare C1=C1+.25;
   #end
}

#declare FrontWalks=union{   
   difference{
      cylinder{<0,0,0><0,.01,0> 20}
      cylinder{<0,-.01,0><0,.02,0> 18}
     translate<0,0,-43>
   }// difference
   box{<-40,0,-2.25><40,.01,-.75> }    
   box{<-40,0,-8><40,.01,-10> }   
   box{<-4.1,0,-8><-2.1,.01,0>}
   box{<2.1,0,-8><4.1,.01,0>}       
   box{<-20.1,0,-8><-22.1,.01,0>}
   box{<20.1,0,-8><22.1,.01,0>}  
   box{<-40,0,-8><-38,.01,0>}
   box{<40,0,-8><38,.01,0>} 
   texture{pigment{image_map { gif "..\graphics\brick001.gif" } rotate<90,0,0> scale .5}}
}   

// Center Garden
#declare Water=texture {
                  pigment { color rgb< 0.0, 0.1, 0.2 > }
                  normal { bumps 0.1  scale < .25, 0.15, 0.15 > }
                  finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
                 }

#declare Pillar=union{
   cone{<0,0,0> .2 <0,3,0> .15}
   cylinder{<0,0,0><0,.1,0> .25}
   cylinder{<0,3,0><0,3.1,0> .2}
}   

#declare LillyPetal=difference{
   sphere{<0,0,0> .05 }
   sphere{<0,0,0> .045}
   box{<0,-.051,-.051><.051,.051,.051>}
   
   scale <1,1.5,.5>
   rotate<0,0,45>
}

#declare LillyPetalCluster=union{
  #declare C1=1;
  #while (C1<=6)
     object{LillyPetal rotate<0,C1*60,0> texture{pigment{color Pink}}}
     #declare C1=C1+1;
  #end
}  
   

#declare LillyPad5=union{
    cylinder{<0,0,0><0,.0001,0> .05 scale<1,1,1.2> }
    triangle{<-.05,0,0><.05,0,0><0,0,-.1>}
   translate<0,0,.1>  // center on end of triangle
}

#declare LillyPad=union{
  object{LillyPad5}
  object{LillyPad5 rotate<0,65,0>}
  object{LillyPad5 rotate<0,-65,0>}
  object{LillyPad5 rotate<0,130,0>}
  object{LillyPad5 rotate<0,-140,0>}
  object{LillyPad5 rotate<0,180,0>}
}

#declare LillyPatch=union{
 #declare C1=1;
 #while (C1<25)
   #declare RX=rand(R1)*2-1;
   #declare RZ=rand(R1)*2-1;
   #declare Sc=rand(R1)*.5+.75;
   object{LillyPad scale Sc translate<RX,0,RZ>}
   #declare C1=C1+1;
 #end
 #declare C1=1;
 #while (C1<15)
   #declare RX=rand(R1)*2-1;
   #declare RZ=rand(R1)*2-1;
   #declare Sc=rand(R1)*.75+.5;
   object{LillyPetalCluster scale Sc translate<RX,0,RZ>}
   #declare C1=C1+1;
 #end 
}    
       
#declare Fountain=union{     
  difference{ 
   union{
     cylinder{<0,.2,15><0,.25,15> 6}
     cylinder{<0,.2,-15><0,.25,-15> 6}
     box{<-6,.2,-15><6,.25,15> }
     cylinder{<0,0,15><0,.2,15> 5.98 texture{T_GrayBrick scale .0325}}
     cylinder{<0,0,-15><0,.2,-15> 5.98 texture{T_GrayBrick scale .0325}}
     box{<-5.98,0,-15><5.98,.2,15> texture{T_GrayBrick scale .0325}}     
   }
   union{
     cylinder{<0,0,15><0,.251,15> 5.5}
     cylinder{<0,0,-15><0,.251,-15> 5.5}
     box{<-5.5,0,-15><5.5,.251,15> }
   }          
   texture{T_Stone8}
  } // difference
   union{
     cylinder{<0,0,15><0,.15,15> 5.5}
     cylinder{<0,0,-15><0,.15,-15> 5.5}
     box{<-5.5,0,-15><5.5,.15,15> }
     texture{Water }
   }                               
   cylinder{<0,0,0><0,.5,0> 2 texture{T_Stone8}}
   cylinder{<0,.5,0><0,.6,0> 2.2 texture{T_Stone8}}
   #declare C=0;
   #while(C<360)
      object{Pillar translate<1.8,.6,0> rotate<0,C,0> texture{T_Stone5}}
      #declare C=C+30;
   #end
   cylinder{<0,3.6,0><0,3.7,0> 2.2 texture{T_Stone8}}
   cylinder{<0,3.7,0><0,4.2,0> 2   texture{T_Stone5}}
   cylinder{<0,4.2,0><0,4.3,0> 2.2 texture{T_Stone8}}
   difference{
      union{
         sphere{<0,4.3,0> 2 texture{T_Stone8}}
         #declare CR=0;
         #while (CR<180)
            cylinder{<-.05,4.3,0><.05,4.3,0> 2.05 texture{T_Stone8} rotate<0,CR,0>}
            #declare CR=CR+45;
         #end
       }// union  
      box{<-2.15,2.2,-2.15><2.15,4.2,2.15>}   
     }
   cylinder{<0,6.2,0><0,6.5,0> .3 texture{T_Stone8}}
   cylinder{<0,6.5,0><0,6.7,0> .4 texture{T_Stone8}}
   sphere{<0,6.7,0> .35  texture{T_Stone8}}
   sphere{<0,7.2,0> .15  texture{T_Stone5}}
   cone{<0,7.35,0> .05 <0,8.8,0> .001 texture{T_Stone8}}     
                            
  union{                            
   object{Urn2 translate<-5.75,1.1,-14>}
   object{Urn1 translate<-5.75,1.1,-10>}
   object{Urn2 translate<-5.75,1.1,-6>}
   object{Urn1 translate<-5.75,1.1,-2>}
   object{Urn2 translate<-5.75,1.1,2>}
   object{Urn1 translate<-5.75,1.1,6>}
   object{Urn2 translate<-5.75,1.1,10>}
   object{Urn1 translate<-5.75,1.1,14>}     
   
   object{Urn1 translate<5.75,1.1,-14>}
   object{Urn2 translate<5.75,1.1,-10>}
   object{Urn1 translate<5.75,1.1,-6>}
   object{Urn2 translate<5.75,1.1,-2>}
   object{Urn1 translate<5.75,1.1,2>}
   object{Urn2 translate<5.75,1.1,6>}
   object{Urn1 translate<5.75,1.1,10>}
   object{Urn2 translate<5.75,1.1,14>}  
  texture{T_Stone5}
  } 

  object{LillyPatch translate<-3,.16,12> texture{pigment{color DarkGreen}}}
  object{LillyPatch translate<-3.5,.16,15> texture{pigment{color DarkGreen}}}
  object{LillyPatch translate<-2.5,.16,16> texture{pigment{color DarkGreen}}}  
  object{LillyPatch translate<-1,.16,17> texture{pigment{color DarkGreen}}}  
   
} // Fountain


#ifndef(FlowersOff)

#declare LowerGardens=union{
    #declare C1=1.5;
    #while (C1<=19)                  
         #declare C2=1.5;
         #while (C2<18)
           #declare F1=int(rand(R1)*3+1);
           #declare F2=int(rand(R1)*3+1);
           #declare F3=int(rand(R1)*3+1);
           #declare F4=int(rand(R1)*3+1);
           #switch (F1)
             #case(1) object{X1 translate<C1,GL,C2+10>} #break
             #case(2) object{X2 translate<C1,GL,C2+10>} #break
             #case(3) object{X3 translate<C1,GL,C2+10>} #break        
             #case(4) object{X4 translate<C1,GL,C2+10>} #break
             #case(5) object{X5 translate<C1,GL,C2+10>} #break
             #case(6) object{X6 translate<C1,GL,C2+10>} #break
             #case(7) object{X7 translate<C1,GL,C2+10>} #break               
           #end // switch      
           
           #switch (F2)
             #case(1) object{X1 translate<-C1,GL,C2+10>} #break
             #case(2) object{X2 translate<-C1,GL,C2+10>} #break
             #case(3) object{X3 translate<-C1,GL,C2+10>} #break        
             #case(4) object{X4 translate<-C1,GL,C2+10>} #break
             #case(5) object{X5 translate<-C1,GL,C2+10>} #break
             #case(6) object{X6 translate<-C1,GL,C2+10>} #break
             #case(7) object{X7 translate<-C1,GL,C2+10>} #break
           #end // switch
                          
           #switch (F3)
             #case(1) object{X1 translate<-C1-1,GL,C2+90>} #break
             #case(2) object{X2 translate<-C1-1,GL,C2+90>} #break
             #case(3) object{X3 translate<-C1-1,GL,C2+90>} #break        
             #case(4) object{X4 translate<-C1-1,GL,C2+90>} #break
             #case(5) object{X5 translate<-C1-1,GL,C2+90>} #break
             #case(6) object{X6 translate<-C1-1,GL,C2+90>} #break
             #case(7) object{X7 translate<-C1-1,GL,C2+90>} #break
           #end // switch                             
           
           #switch (F4)
             #case(1) object{X1 translate<C1,GL,C2+90>} #break
             #case(2) object{X2 translate<C1,GL,C2+90>} #break
             #case(3) object{X3 translate<C1,GL,C2+90>} #break        
             #case(4) object{X4 translate<C1,GL,C2+90>} #break
             #case(5) object{X5 translate<C1,GL,C2+90>} #break
             #case(6) object{X6 translate<C1,GL,C2+90>} #break
             #case(7) object{X7 translate<C1,GL,C2+90>} #break
           #end // switch           
           
           #declare C2=C2+1;
         #end
         #declare C1=C1+1;
    #end
}           

#end // ifndef(FlowersOff)             


#declare RW1=seed(55);
#declare RefusePile=union{
   #declare C1=1;
   #while (C1<2000)
      #declare SL=rand(RW1)*.1+.2;
      #declare ROY=rand(RW1)*360;
      #declare ROX=rand(RW1)*90;
      #declare ROZ=rand(RW1)*90;
      #declare RX=rand(RW1)*.2;
      #declare RZ=rand(RW1)*.6-.3;
      #declare RY=rand(RW1)*.05;
      #declare Item=int(rand(RW1)*5)+1;
      #switch (Item)
         #case (1)
             cylinder{<0,0,0><0,SL,0> .001 rotate<ROX,ROY,0> translate<RX,RY,RZ> texture{pigment{color Wheat}}}
         #break
         #case (2)
             object{Leaf1 rotate<ROX,ROY,ROZ> translate<RX,RY,RZ> texture{pigment{color OliveDrab1}}}
         #break
         #case (3)
             object{Leaf2 rotate<ROX,ROY,ROZ> translate<RX,RY,RZ> texture{pigment{color OliveDrab2}}}
         #break
         #case (4)
             object{Leaf3 rotate<ROX,ROY,ROZ> translate<RX,RY,RZ> texture{pigment{color OliveDrab3}}}
         #break
         #case (5)
             object{Leaf4 rotate<ROX,ROY,ROZ> translate<RX,RY,RZ> texture{pigment{color OliveDrab4}}}
         #break                           
      #end             
      #declare C1=C1+1;
   #end
}
                          
#declare WheelbarrowWheel=union{
    difference{
       cylinder{<0,0,-.061><0,0,.061> .2}
       cylinder{<0,0,-.0611><0,0,.0611> .19}
     texture{pigment{color Gray40}}
    }
    difference{   
       cylinder{<0,0,-.061><0,0,.061> .19}
       cylinder{<0,0,-.0611><0,0,.0611> .18}
     texture{T_Wood1}
    }
    cylinder{<0,0,-.15><0,0,.15> .05 texture{T_Wood1}}
    cylinder{<0,0,-.2><0,0,.2> .01 texture{pigment{color Gray40}}}
    #declare C1=0;
    #while (C1<180)
        cylinder{<0,-.18,0><0,.18,0> .01 texture{T_Wood1 rotate<90,0,0>} rotate<0,0,C1>}
        #declare C1=C1+45;
    #end
}    
 
#declare WheelbarrowHandle=union{        
    cylinder{<-.5,0,-.04><-.5,0,.04>.04 texture{T_Wood1 rotate<0,90,0>}}
    box{<-.5,-.04,-.04><.75,.04,.04> texture{T_Wood1 rotate<0,90,0>}}
    cone{<.75,0,0>.02<1,0,0>.03 texture{T_Wood1 rotate<0,90,0>}}
    sphere{<1,0,0>.03 texture{T_Wood1 rotate<0,90,0>}}
}
#declare WheelbarrowCarry=union{
    box{<-.4,-.02,-.28><-.35,.36,-.24> texture{T_Wood1 rotate<90,0,0>}}
    box{<-.4,-0.2,.24><-.35,.36,.28> texture{T_Wood1 rotate<90,0,0>}}
    
    box{<-.35,0,-.3><-.32,.05,.3> texture{T_Wood1}}
    box{<-.35,.06,-.3><-.32,.11,.3> texture{T_Wood1}}
    box{<-.35,.12,-.3><-.32,.17,.3> texture{T_Wood1}} 
    box{<-.35,.18,-.3><-.32,.25,.3> texture{T_Wood1}}  
    box{<-.35,.26,-.3><-.32,.35,.3> texture{T_Wood1}}    
    
    box{<-.31,0,-.3><-.21,.02,.3> texture{T_Wood1}}
    box{<-.20,0,-.32><-.10,.02,.32> texture{T_Wood1}}
    box{<-.09,0,-.34><.01,.02,.34> texture{T_Wood1}}
    box{<.02,0,-.36><.12,.02,.36> texture{T_Wood1}}
    box{<.13,0,-.38><.23,.02,.38> texture{T_Wood1}}    
    box{<.24,0,-.4><.34,.02,.4> texture{T_Wood1}}
    
    object{RefusePile translate<-.25,0,0>}    
}                          

#declare WheelbarrowF=union{ 
   object{WheelbarrowHandle translate<0,0,.25> rotate<0,-10,0>}
   object{WheelbarrowHandle translate<0,0,-.25> rotate<0,10,0>}
   object{WheelbarrowWheel  translate<-.5,-.02,0> } 
   box{<-.02,.04,-.25><.03,.15,.25> texture{T_Wood1} translate<-.24,0,0>}      
   box{<-.02,.04,-.4><.03,.06,.4> texture{T_Wood1} translate<.34,0,0>} 
   object{WheelbarrowCarry translate<.11,.08,0>}  
}

#declare Wheelbarrow=union{
   object{WheelbarrowF rotate<0,0,12>}
   box{<-.02,.1,-.02><.02,-.45,.02> texture{T_Wood1 rotate<90,0,0>} translate<.34,.1,-.32>}
   box{<-.02,.1,-.02><.02,-.45,.02> texture{T_Wood1 rotate<90,0,0>} translate<.34,.1,.32>} 
  translate<0,.33,0>
} 

#declare Shovel=union{
     box{<-.1,0,-.001><.1,.3,.001> texture{pigment{Gray40}}}
     cylinder{<-.1,.3,0><.1,.3,0> .001 texture{pigment{Gray40}}}
     cone{<0,.35,0> .02 <0,.2,0> .005 texture{pigment{Gray40}}}
     cone{<0,.35,0> .019 <0,1.32,0> .017 texture{T_Wood1 rotate<90,0,0>}}
     sphere{<0,1.32,0> .017 texture{T_Wood1 rotate<90,0,0>}}
}

