//
//    EMAIL: castlewrks@aol.com
//    NAME: Robert J Becraft
//    TOPIC:  Gardens
//    COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//    TITLE: "
//    COUNTRY: USA
//    WEBPAGE: http://www.geocities.com/siliconvalley/labs/6080
//    RENDERER USED:  Povray 3.1g.watcom
//    TOOLS USED: Povray (image creation), I_view32 (TGA>JPG conversion), PaintShop Pro (add copyright)
//    RENDER TIME: 
//    HARDWARE USED: Pentium 233
//    IMAGE DESCRIPTION:
//    
//
//    DESCRIPTION OF HOW THIS IMAGE WAS CREATED:


 global_settings {
                                    max_trace_level 12          // default POV setting is 5
                                    max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                                  }

#include "kolors.inc"    // Ken's kolors file.
#include "textures.inc"
#include "glass.inc"
#include "finish.inc"
#include "stones1.inc"  

#declare Leaves=yes;  // uncomment to turn on

camera {                                                       
    location <0,5,-12> look_at <0,5.5,0>
}

light_source{<0,20,-50> color White*2}  // BIG light

#declare S1=seed(48); 
                      
#declare Leaf1=union{
    triangle{<0,0,0><-.01,.01,0><.01,.01,0> }
    triangle{<0,.008,0><-.012,.02,0><.012,.02,0> }                        
    triangle{<0,.018,0><-.008,.03,0><.008,.03,0> }
    triangle{<0,.028,0><-.004,.04,0><.005,.04,0> }
    triangle{<-.004,.04,0><.005,.04,0><0,.05,.01>}
}

#declare Leaf2=union{
    cylinder{<0,0,0><0,0,.00001> .025 scale <.2,.55,1>}
}

#declare Leaf3=union{
    cylinder{<0,0,0><0,0,.00001> .025  scale <.5,1,1>}
    triangle{<0,-.025,0><-.02,.005,0><.02,.005,0> }
    triangle{<0,.01,0><-.023,-.015,0><.023,-.015,0>}
}

#declare Leaf4=union{ // star pattern leaf
    cylinder{<0,0,0><0,0,.00001> .025  scale <.25,1,1.2>}
    cylinder{<0,0,0><0,0,.00001> .025  scale <.25,1,1.2> rotate<0,0,45>}
    cylinder{<0,0,0><0,0,.00001> .025  scale <.25,1,1.2> rotate<0,0,-45>}
}

#declare Leaf5=union{ // duck foot pattern leaf
    cylinder{<0,0,0><0,0,.00001> .025 translate<0,.025,0>  scale <.35,1,1.2>}
    cylinder{<0,0,0><0,0,.00001> .025 translate<0,.025,0>  scale <.25,1,1.2> rotate<0,0,25>}
    cylinder{<0,0,0><0,0,.00001> .025 translate<0,.025,0>  scale <.25,1,1.2> rotate<0,0,-25>} 
    scale 4
} 

#declare Twig1=union{  // random small branches
    cylinder{<0,0,0><0,.02,0> .005}
    cylinder{<0,.02,0><.04,.05,0> .005}
    cylinder{<.04,.05,0><.02,.075,0> .005}
    cylinder{<.02,.075,0><-.01,.085,0> .005}
}  

#macro LeafCluster(X1,Y1,Z1,Y2,Y3,X2,LC,L1)
// X1,Y1,Z1 = cluster origin
// Y2,Y3 = lowest height/greatest height respectively
// X2 = distance leaf can be from X1,Y1,Z1
// LC = leaf count                        
// L1 = Leaf pattern

   #local C1=1;  // counter
   #while (C1<=LC) 
      #local XX=rand(R1)*X2;
      #local YY=rand(R1)*(Y3-Y2);
      #local YR=rand(R1)*360;    // rotate final leaf in 3-d
      #local CO=int(rand(R1)*5+1);
      
      #local XOR=rand(R1)*360;
      #local YOR=rand(R1)*360;
      #local ZOR=rand(R1)*360;
      #local Sc=rand(R1)*.75+.5;

      object{L1 rotate<XOR,YOR,ZOR> scale Sc translate<XX,YY,0> rotate<0,YR,0>
             translate<X1,Y1,Z1>
                texture{pigment{color
                    #switch (CO)
                      #case (1) DarkOliveGreen  #break
                      #case (2) DarkOliveGreen1 #break
                      #case (3) DarkOliveGreen2 #break
                      #case (4) DarkOliveGreen3 #break
                      #case (5) DarkOliveGreen4 #break 
                      #case (6) DarkOliveGreen5 #break                      
                      #case (7) DarkGreenCopper #break                                                                    
                      #case (8) DarkGreen #break
                      #case (9) DarkGreen1 #break
                    #end // switch
                 }}       
      }
      #local C1=C1+1; 
   #end
#end // macro LeafCluster                    
           
#declare R1=seed(748);           
           
#ifdef(Leaves)

#declare Canopy1=union{
    #declare C1=1;
    #while (C1<400)
       #declare X=rand(R1)*5-2.5;
       #declare Y=rand(R1)*4.5+6;
       #declare Z=rand(R1)*4-2; 
       #declare Ymin=rand(R1)*.2+.2;
       #declare Ymax=rand(R1)*.2+.4;
       #declare XDis=rand(R1)*.2+.2;
       
       #declare LeafCount=rand(R1)*20+5;

       LeafCluster(X,Y,Z,Ymin,Ymax,XDis,LeafCount,Leaf5)

       #declare C1=C1+1;
    #end
} // Canopy1

object{Canopy1}
#end // ifdef(Leaves)                     

#macro BranchGroup (BC,X,Y,Z,Xmax,Ymax,Zmax,Diam,L)
// BC = Branch Count
// X,Y,Z = Origin of branch group      
// Xmax,Ymax,Zmax = outer limits of branch group (+ or -)
// Diam = branch diameters.

  #local C1=1;                                    
  #while (C1<BC)
    #local RX=rand(R1)*Xmax-(Xmax/2);
    #local RY=rand(R1)*Ymax/2+(Ymax/2);
    #local RZ=rand(R1)*Zmax-(Zmax/2);
    #local DD=rand(R1)*Diam/2+(Diam/2);
    cone{<X,Y,Z>DD <X+RX,Y+RY,Z+RZ> DD/3 texture{TreeTrunkTexture}} 
               
    #if (L=1)               
     BranchGroup (3,X+RX,Y+RY,Z+RZ, Xmax, Ymax, Zmax, Diam/3,0)
    #end
    
    #local C1=C1+1;
  #end
#end // macro BranchGroup 

#declare TreeTrunkTexture = texture {
  pigment { granite
     color_map {
      [0.1 color White]
      [0.2 color Gray10]
      [0.4 color Gray30]
      [0.6 color Gray]
      [0.8 color DarkBrown]
      [0.9 color DarkGreen] 
     }
   }
   scale <.051,.75,.051> 
   normal{granite .05}
}
              
cone{<0,0,0> .3 <0,1,0> 0 texture{TreeTrunkTexture}}
cone{<0,0,0> .2 <0,5,0> .1 texture{TreeTrunkTexture}}
              
#declare BD=3;
#while (BD<5)
   BranchGroup(3,0,BD,0,4,4,4,.1,1)
   #declare BD=BD+rand(R1)*.3+.2;
#end
                     