/*
garden.pov

Created by Andrew Clinton for the November-December 1999
IRTC.  You may use these files freely for personal use, but
if you distribute your images/scene files please give me
credit for my work!
*/

//Remember to +F!!!

#debug "Parsing...\n\ngarden.pov\n"

//+H600 +W800 +A0.1 -J +R3

#declare rad = false;

global_settings {
	max_trace_level 60
	#if(rad)
	ini_option "+QR"
	ini_option "Preview_Start_Size=16"
	ini_option "Preview_End_Size=8"
	radiosity{
		count 20             // CHANGE range from 20 to 150 (at least 80 if lit by ambient)
		nearest_count 3      // CHANGE range from 3 to 10
		error_bound 3     // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
		                     //   1 : preview_end_size = 4
		                     //   3 : preview_end_size = 8
		                     //   use preview_start_size = 16
		recursion_limit 2    // CHANGE
		
		low_error_factor .5  // leave this
		gray_threshold 0.0   // leave this
		minimum_reuse 0.015  // leave this
		brightness 1         // leave this
		
		adc_bailout 0.01/1  // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
	}
	#end
}

background { color rgb <0.9, 0.9, 0.95> }

camera {
	location <0, 4, -18>
	look_at <0, 1, 0>
}

sky_sphere {
	pigment {
		gradient y
		color_map {
			[ 0 rgb <0.77, 0.83, 0.89>*1.2 ]
			[ 0.5 rgb <0.61, 0.69, 0.84>*1.2 ]
		}
	}
	pigment {
		gradient x
		turbulence 0.1
		scale 2
		translate x*-1
		color_map {
			[ 0.2 rgbt <0.53, 0.59, 0.76, 0.3> ]
			[ 0.8 rgbt <0.53, 0.59, 0.76, 1> ]
		}
	}
}

#declare r1 = seed(13);

light_source {
	<0, 0, 0>
	color rgb 1.2
	area_light
	<2, 0, 2>, <-2, 0, -2>
	3, 3
	rotate y*30
	translate y*100
	rotate x*-40
	rotate y*-50
	photons { reflection off refraction off }
}

light_source {
	<0, 4, -18>
	color rgb 0.5
	shadowless
	photons { reflection off refraction off }
}


#include "common.inc"

#include "environment.inc"
#include "gardenwalkway.inc"
#include "fountain.inc"
#include "dirtmap.inc"

#include "mkplant.inc"
#include "flowers.inc"
#include "flowers2.inc"
#include "leafies.inc"

#include "actree.inc"
#include "trees.inc"
#include "shrubs.inc"
#include "treeborders.inc"

#include "fence.inc"
#include "fencevines.inc"

#include "scatter.inc"

//End of file