/*
Tree border file.  Describes the circular brick arrangements
around the trees.
*/

#debug ".treeborders.inc\n"

#declare borderbrick = superellipsoid {
	<0.1, 0.1>
	scale <0.06, 0.06, 0.12>
}

#declare radiusdist = 1;
#declare oneround = union {
#declare rotation = 0;
#while(rotation < 360)
object {
	borderbrick
	translate x*radiusdist
	rotate y*rotation
}
#declare rotation = rotation + 40/((radiusdist-0.16)*pi);
#end
texture {
	pigment {
		bozo
		color_map {
			[ 0 rgb 0.62 ]
			[ 1 rgb 0.55 ]
		}
		scale 0.5
	}
	#if(rad)
	finish {
		diffuse 0.8
		ambient 0.0
		specular 2.5
		roughness 0.01
	}
	#else
	finish {
		diffuse 0.85
		ambient 0.3
		specular 2.5
		roughness 0.01
	}
	#end
	normal {
		average
		normal_map {
			[ 1 granite 1.2 scale 0.1 ]
			[ 1 bozo 1.2 scale 0.2 ]
		}
	}
}
}

#declare oneborder = union {
object { oneround }
object { oneround translate y*0.13 rotate y*rand(r1)*360
texture {
	pigment {
		color rgbt <0.5, 0.4, 0.2, 0.8>
	}
	finish {
		diffuse 0.8
		#if(rad)
		ambient 0.0
		#else
		ambient 0.3
		#end
		specular 1.5
		roughness 0.01
	}
}
}
object { oneround translate y*0.26 rotate y*rand(r1)*360
texture {
	pigment {
		color rgbt <0.5, 0.4, 0.2, 0.7>
	}
	finish {
		diffuse 0.8
		#if(rad)
		ambient 0.0
		#else
		ambient 0.3
		#end
		specular 1.5
		roughness 0.01
	}
}
}
}

object { oneborder translate <-7, -0.1, -6> }
object { oneborder translate <7, -0.1, -7> }
object { oneborder translate <-7, -0.1, 6> }
object { oneborder translate <8, -0.1, 6> }

//object { borderbrick }