/* IRTC_Garden.pov  Renders atrium garden with Greek columns and a fountain.
                        Written by Chuck Higgs, December 1999 IRTC Competition */                              
#include "colors.inc" 
#include "finish.inc"
#include "IRTC_texture_subset.inc" // subset of textures.inc, stones1.inc, & woods.inc

camera { location <4,6,-48>  direction <0,0,2> look_at <0,5,0> }
light_source { <0,100,0> color White }                  // overhead sky light     
light_source { <5,10,-40> color White*0.5 shadowless }  // shadowless "chamber" lights
light_source { <-5,10,-40> color White*0.5 shadowless }
      
//  BUILD the ROOM *******************************************************************
#declare Archway = union { difference { cylinder { <-21,0,20>, <-20,0,20>, 7 }  // archway
                                        cylinder { <-30,0,20>, <30,0,20>, 5 }
                                        plane { y,0 }
                                        translate <0,17,0>
                                      }
                           difference { torus { 7, 0.5 rotate <0,0,90> } // top round-over
                                        plane { y,0 }
                                        translate <-20.5,17,20>
                                      }
                           difference { torus { 5, 0.5 rotate <0,0,90> } // bottom round-over
                                        plane { y,0 }
                                        translate <-20.5,17,20>
                                      }
                           cylinder { <-20.5,0,15>, <-20.5,17,15>, 0.5 } // vertical round-over
                           cylinder { <-20.5,0,25>, <-20.5,17,25>, 0.5 }
                         }

#declare Wall_Stucco = pigment { image_map { gif "stuc_3.gif"
                                             map_type 0 interpolate 2 
                                           }
                                 translate <-0.5,-0.5,0> scale 12
                               }         
#declare Main_Room = 
union {
                     union { box { <-21,-10,60>, <-5,20,61> }     // left rear wall
                             cylinder { <-21,20,60.5>, <-5,20,60.5>, 0.5 }
                             cylinder { <-5,0,60.5>, <-5,20,60.5>, 0.5 }
                             sphere { <0,0,0>, 0.5 translate <-5,20,60.5> }
                             pigment { Wall_Stucco }
                           }

                     union { box { <5,-10,60>, <100,20,61> }      // right rear wall
                             cylinder { <5,20,60.5>, <100,20,60.5>, 0.5 }
                             cylinder { <5,0,60.5>, <5,20,60.5>, 0.5 }
                             sphere { <0,0,0>, 0.5 translate <5,20,60.5> }
                             pigment { Wall_Stucco }
                           }
                     
                     object { Archway translate <20.5,0,-20>   // on rear wall
                              rotate <0,90,0> translate <0,0,60.5>
                              pigment { Wall_Stucco }
                            }
                     
                     union { box { <-20,-10,25>, <-21,20,61> }       // left forward wall
                             cylinder { <-20.5,20,25>, <-20.5,20,61>, 0.5 }
                             pigment { Wall_Stucco rotate <0,-90,0> }
                             finish { ambient 0.3 }
                           }

                     union { box { <-20,-10,-5>, <-21,20,15> }          // left rear wall
                             cylinder { <-20.5,20,-60>, <-20.5,20,15>, 0.5 }
                             pigment { Wall_Stucco rotate <0,-90,0> }
                             finish { ambient 0.3 }
                           }

                     object { Archway   // on left wall
                              pigment { Wall_Stucco rotate <0,-90,0> }
                              finish { ambient 0.3 }        
                            }
                     
                     union { box { <20,-10,-5>, <21,20,61> }   // right wall
                             cylinder { <20.5,20,-60>, <20.5,20,61>, 0.5 }
                             pigment { Wall_Stucco rotate <0,90,0> }
                             finish { ambient 0.3 }
                           }
      }

//  BUILD the GATE *********************************************************************
#declare Left_Gate = union { 
                        cylinder { <-4,-1,60.5>, <-4,8.2,60.5>, 0.2 }  // left post
                        cylinder { <-3,0.5,60.5>, <-3,7.5,60.5>, 0.1 }  // 3 vertical bars
                        cylinder { <-1.5,0.5,60.5>, <-1.5,7.5,60.5>, 0.1 }
                        cylinder { <-0.4,0.5,60.5>, <-0.4,7.5,60.5>, 0.1 }
                        cylinder { <-4,7.5,60.5>, <-0.4,7.5,60.5>, 0.1 }  // 4 horizontal bars
                        cylinder { <-4,5.5,60.5>, <-0.4,5.5,60.5>, 0.1 }
                        cylinder { <-4,2.5,60.5>, <-0.4,2.5,60.5>, 0.1 }
                        cylinder { <-4,0.5,60.5>, <-0.4,0.5,60.5>, 0.1 }
                        sphere { <0,0,0>, 0.1 translate <-0.4,7.5,60.5> }
                        cylinder { <-1.5,4.65,60.5>, <-0.4,4.65,60.5>, 0.1 }  // hoop bar and hoop
                        torus { 0.45, 0.1 rotate <-90,0,0> translate <-0.95,4,60.5> }
                        cylinder { <-1.5,3.35,60.5>, <-0.4,3.35,60.5>, 0.1 }
                        texture { Brass_Texture }
                           }

#declare Right_Gate = union {
                        cylinder { <4,-1,60.5>, <4,8.2,60.5>, 0.2 }  // right post
                        cylinder { <0.4,0.5,60.5>, <0.4,7.5,60.5>, 0.1 }  // 3 vertical bars
                        cylinder { <1.5,0.5,60.5>, <1.5,7.5,60.5>, 0.1 }
                        cylinder { <3,0.5,60.5>, <3,7.5,60.5>, 0.1 }
                        cylinder { <0.4,7.5,60.5>, <4,7.5,60.5>, 0.1 }  // 4 horizontal bars
                        cylinder { <0.4,5.5,60.5>, <4,5.5,60.5>, 0.1 }
                        cylinder { <0.4,2.5,60.5>, <4,2.5,60.5>, 0.1 }
                        cylinder { <0.4,0.5,60.5>, <4,0.5,60.5>, 0.1 }
                        sphere { <0,0,0>, 0.1 translate <0.4,7.5,60.5> }
                        cylinder { <0.4,4.65,60.5>, <1.5,4.65,60.5>, 0.1 }  // hoop bar and hoop
                        torus { 0.45, 0.1 rotate <-90,0,0> translate <0.95,4,60.5> }
                        cylinder { <0.4,3.35,60.5>, <1.5,3.35,60.5>, 0.1 }
                        texture { Brass_Texture }
                            }
                        
#declare Hinges = union { cylinder { <-5,1.5,60.5>, <-4,1.5,60.5>, 0.2 } // hinges
                          cylinder { <-5,7.5,60.5>, <-4,7.5,60.5>, 0.2 }
                          cylinder { <4,1.5,60.5>, <5,1.5,60.5>, 0.2 }
                          cylinder { <4,7.5,60.5>, <5,7.5,60.5>, 0.2 }
                          texture { Brass_Texture }
                        }
                        
#declare Wrought_Iron = difference { height_field { tga "wrought_iron.tga" 
                                                    smooth water_level 0.01
                                                  }
                                     plane { y, 0.05 }
                                     texture { Brass_Texture }             
                                     translate <-0.5,0,0>
                                     rotate -90*x scale <8.7,3.8,0.2>
                                   }

// COMPOSE the LATIN PHRASES **********************************************************
#declare Size = 2;         // Scaling for Rear Gate
#declare Rot = 45;  #declare Ang = <0,0,-2*Rot/13>;
#declare Ofst = -5.0*<sin(Rot*pi/180),-cos(Rot*pi/180),0>; 
                           
#declare Text_Rear_Gate = union { 
text { ttf "timesbd.ttf" "L" Size, 0 rotate Rot*z translate Ofst rotate Ang*0 }
text { ttf "timesbd.ttf" "u" Size, 0 rotate Rot*z translate Ofst rotate Ang*1 }
text { ttf "timesbd.ttf" "x" Size, 0 rotate Rot*z translate Ofst rotate Ang*2 }
text { ttf "timesbd.ttf" " " Size, 0 rotate Rot*z translate Ofst rotate Ang*3 }
text { ttf "timesbd.ttf" "E" Size, 0 rotate Rot*z translate Ofst rotate Ang*4 }
text { ttf "timesbd.ttf" "x" Size, 0 rotate Rot*z translate Ofst rotate Ang*5 }
text { ttf "timesbd.ttf" " " Size, 0 rotate Rot*z translate Ofst rotate Ang*6 }
text { ttf "timesbd.ttf" "O" Size, 0 rotate Rot*z translate Ofst rotate Ang*7 }
text { ttf "timesbd.ttf" "r" Size, 0 rotate Rot*z translate Ofst rotate Ang*8*1.025 }
text { ttf "timesbd.ttf" "i" Size, 0 rotate Rot*z translate Ofst rotate Ang*9*1.015 }
text { ttf "timesbd.ttf" "e" Size, 0 rotate Rot*z translate Ofst rotate Ang*10 }
text { ttf "timesbd.ttf" "n" Size, 0 rotate Rot*z translate Ofst rotate Ang*11 }
text { ttf "timesbd.ttf" "t" Size, 0 rotate Rot*z translate Ofst rotate Ang*12 }
text { ttf "timesbd.ttf" "e" Size, 0 rotate Rot*z translate Ofst rotate Ang*13*0.99 }               
                                  scale <1,1,0.5>
                                  pigment { Black }
                                  //finish { Dull }
                                  normal { crackle 0.5 scale 0.5 }
                                }

#declare Size = 2;      // Scaling for Left Gate
#declare Rot = 40;  #declare Ang = <0,0,-2*Rot/11>;
#declare Ofst = -4.8*<sin(Rot*pi/180),-cos(Rot*pi/180),0>; 
                           
#declare Text_Left_Gate = union { 
text { ttf "timesbd.ttf" "L" Size, 0 rotate Rot*z translate Ofst rotate Ang*0 }
text { ttf "timesbd.ttf" "u" Size, 0 rotate Rot*z translate Ofst rotate Ang*1 }
text { ttf "timesbd.ttf" "x" Size, 0 rotate Rot*z translate Ofst rotate Ang*2 }
text { ttf "timesbd.ttf" " " Size, 0 rotate Rot*z translate Ofst rotate Ang*3 }
text { ttf "timesbd.ttf" "E" Size, 0 rotate Rot*z translate Ofst rotate Ang*4 }
text { ttf "timesbd.ttf" "x" Size, 0 rotate Rot*z translate Ofst rotate Ang*5 }
text { ttf "timesbd.ttf" " " Size, 0 rotate Rot*z translate Ofst rotate Ang*6 }
text { ttf "timesbd.ttf" "N" Size, 0 rotate Rot*z translate Ofst rotate Ang*7 }
text { ttf "timesbd.ttf" "o" Size, 0 rotate Rot*z translate Ofst rotate Ang*8*1.02 }
text { ttf "timesbd.ttf" "r" Size, 0 rotate Rot*z translate Ofst rotate Ang*9*1.0 }
text { ttf "timesbd.ttf" "t" Size, 0 rotate Rot*z translate Ofst rotate Ang*10*0.98 }
text { ttf "timesbd.ttf" "e" Size, 0 rotate Rot*z translate Ofst rotate Ang*11*0.96 }               
                                  scale <1,1,0.5>
                                  pigment { Gray10 }
                                  finish { Dull }
                                  normal { crackle 0.5 scale 0.5 }
                                }
//  PUT in the LAWN *******************************************************************
#declare Lawn = difference { box { <-100,-0.5,-30>, <40,-0.05,80> }
                             box { <-21,-10,-50>, <21,10,61> } // cutout garden area
                                   pigment { image_map { gif "lawn.gif" map_type 0 }
                                             rotate <90,0,0> scale 2 
                                           }
                                   normal { bumps 3.0 }
                           }
#declare Path = union { box { <-30,-1,16>, <-20,0,24> }
                        box { <-4,-1,0>, <4,0,55> rotate <0,-15,0> translate <-27,0,16> }
                        texture { pigment { bozo color_map { [ 0 Wheat ]
                                                             [ 1 Gray ]
                                                           }
                                            scale 0.1
                                          }
                                  normal { bumps 0.2 scale 0.2 }
                                }          
                      }
//  TILE the FLOOR *******************************************************************
#declare Vert_Grout_Cut = union { #declare Count = -20;         // front-back lines 
                                  #while (Count < 21)
                                        cylinder { <0,0,-30>, <0,0,60>, 0.1 
                                                   scale <1,0.5,1>
                                                   translate <Count,0,0>
                                                   pigment { Gray }
                                                   normal { bumps 0.3 scale <0.1,0.1,0.3> }
                                                 }          
                                        #declare Count = Count + 2;
                                  #end
                                }
                           
#declare Horz_Grout_Cut = union { #declare Count = -30;         // left-right lines 
                                  #while (Count < 61)
                                        cylinder { <-20,0,0>, <20,0,0>, 0.2
                                                   scale <1,0.2,1> 
                                                   translate <0,0,Count>
                                                   pigment { Gray }
                                                   normal { bumps 0.3 scale <0.3,0.2,0.1> }
                                                   
                                                 }          
                                        #declare Count = Count + 2;
                                  #end
                                }                           
                                                 
#declare Floor = difference { box { <-20,-1,-30>, <20,0,60>
                                    texture { T_Stone5 }
                                  }
                              object { Horz_Grout_Cut }
                              object { Vert_Grout_Cut }
                            }

//  BUILD the RAISED POOL **************************************************************
#declare Rippled_Water = material { texture { pigment { rgbf <0.825,0.825,0.95,0.99> }
                                              finish { ambient 0.1 diffuse 0.1 
                                                       specular 0.3 reflection 0.05 
                                                     }
                                              normal { average 
                                                         normal_map { 
                                                               [ 0.5 waves 0.6 scale 0.5 ]
                                                               [ 0.5 bumps 0.3 scale 0.5 ]
                                                                    }
                                                     }                       
                                            }        
                                    interior { ior 1.2 }
                                  }

#declare Pool_Block = intersection { box { <0,0,0>, <1,1,0.98> }
                                     cylinder { <0.5,0.5,-10>, <0.5,0.5,10>, 0.68 }
                                     translate <-0.5,0,-0.5> scale <1,1,5> 
                                     translate <0,-0.8,0>
                                     texture { T_Stone18 }
                                   }

#declare Pool_Trim = union { object { Pool_Block translate <-8,0,-15> } // left front corner
                             object { Pool_Block translate <-8,0,-10> }
                             object { Pool_Block translate <-8,0,-5> }
                             object { Pool_Block translate <-8,0,0> }
                             object { Pool_Block translate <-8,0,5> }
                             object { Pool_Block translate <-8,0,10> }
                             object { Pool_Block translate <-8,0,15> }

                             object { Pool_Block translate <8,0,-15> }  // right front corner
                             object { Pool_Block translate <8,0,-10> }
                             object { Pool_Block translate <8,0,-5> }
                             object { Pool_Block translate <8,0,0> }
                             object { Pool_Block translate <8,0,5> }
                             object { Pool_Block translate <8,0,10> }
                             object { Pool_Block translate <8,0,15> }

                             object { Pool_Block rotate <0,90,0> translate <-5,0,-17> } //front side
                             object { Pool_Block rotate <0,90,0> translate <5,0,-17> }
                             object { Pool_Block rotate <0,90,0> translate <0,0,-17> }

                             object { Pool_Block rotate <0,90,0> translate <-5,0,17> }  // rear side
                             object { Pool_Block rotate <0,90,0> translate <5,0,17> }
                             object { Pool_Block rotate <0,90,0> translate <0,0,17> }
                           }

#declare Pool_Hole = difference { box { <-9,-4,-18>, <9,0.1,18> 
                                        texture { T_Stone8 scale <1,10,1> }
                                      }
                                  box { <-7,-0.5,-15.5>, <7,10,15.5>
                                        pigment { rgb <0.825,0.825,0.95> }
                                      }
                                }

#declare Pool_Water = union { box { <-6.99,-0.2,-15.49>, <6.99,0,15.49>   // top water layer
                                    material { Rippled_Water }      
                                  }
                              box { <-6.99,-0.5,-15.49>, <6.99,-0.2,15.49>  // bottom layer
                                    pigment { rgb <0.825,0.825,0.95> }
                                  }
                            }

#declare Pool = union { object { Pool_Trim }
                        object { Pool_Hole }
                        object { Pool_Water }
                      }
                      
//  BUILD the COLUMNS *****************************************************************
#declare Cut_Shape = union { cylinder { <0,1.7,0>, <0,12.7,0>, 0.25 // this is single cut
                                        scale <1,1,1> 
                                      }
                             sphere { <0,1.7,0>, 0.25 }
                             sphere { <0,12.7,0>, 0.25 }
                             translate <0,0,1.55>
                           } 
                                                                                
#declare Column_Cut = union { #declare Count = 0;       // this is full cut-away shape
                              #while (Count < 21)
                                     object { Cut_Shape
                                              rotate <0,Count*360./20.,0>
                                            } 
                                     #declare Count = Count + 1;
                              #end
                            }

#declare Braid = union { #declare Count = 0;  // this is the top piece
                         #while (Count < 8)
                                  torus { 1.85, 0.12 scale  <1,1,1> rotate <0,0,35>
                                          rotate <0,Count*360/8,0> 
                                        } 
                                  #declare Count = Count + 1;
                         #end
                       } 

#declare Column_1 = union { intersection { cylinder { <0,0,0>, <0,0.4,0>, 2 } // base sections
                                           sphere { <0,-0.5,0>, 2.12 }
                                           texture { T_Stone17 scale <5,5,3> }
                                         }
                            torus { 1.1, 0.8 scale <1,0.4,1> translate <0,0.55,0>
                                    texture { T_Stone17 scale <5,5,3> }
                                  }
                            torus { 0.9, 0.7 scale <1,0.4,1> translate <0,0.9,0>
                                    texture { T_Stone17 scale <3,5,5> }
                                  }
                            difference { cylinder { <0,1,0>, <0,14.55,0>, 1.5 }   // shaft
                                         object { Column_Cut }
                                         texture { T_Stone17 scale 20 }
                                       }
                            sphere { <0,14.4,0>, 1.75
                                     texture { T_Stone17 scale 20 }
                                   }
                            object { Braid translate <0,14.4,0>
                                     texture { Gold_Texture
                                               normal { wrinkles 0.3 scale 0.2 }
                                             }
                                   }                     
                          }

//  BUILD the RAISED FRAME **************************************************************                   
#declare S_Cube = superellipsoid { <0.1,0.1> translate <1,1,1> scale 0.5 } // unit cube                
                 
#declare Frame = union { object { S_Cube scale <4,2,44> translate <-11,14.5,-22> // left
                                  texture { T_Stone17 scale 20 }
                                }
                         object { S_Cube scale <4,2,44> translate <7,14.5,-22> // right block
                                  texture { T_Stone17 scale 20 }
                                }
                         object { S_Cube scale <22,2,4> translate <-11,14.5,18> // forward
                                  texture { T_Stone17 scale 10 }
                                }
                       }

//  BUILD the URNS ******************************************************************
#declare Egypt_Tiles = texture { pigment { image_map { gif "diamond_tile_strip2.gif" 
                                                       map_type 2 // cylinder map 
                                                     }
                                           translate <0,0.77,0> scale 0.1           
                                         }
                                 finish { ambient 0.3 }
                                 normal { wrinkles 0.3 scale <0.2,0.1,0.2> }
                               }

#declare Egyptian_Urn = union { torus { 2.5, 0.15 translate <0,11,0> }
                                intersection { sor { 6, <0,  -0.5>,
                                                        <5,   1>,
                                                        <8,   7.0>,
                                                        <6,  9.0>,
                                                        <5,  11.0>,
                                                        <5,  15>
                                                      sturm
                                                      scale <0.5,1,0.5>
                                                    }
                                               cylinder { <0,0,0>, <0,11,0>, 10 }
                                             }
        texture { gradient y 
                  texture_map { [ 0 pigment { rgb <151,38,38>/255 }
                                    finish { ambient 0.2 } 
                                    normal { wrinkles 0.3 scale <0.2,0.1,0.2> } 
                                    ]
                                [ 0.1 pigment { rgb <151,38,38>/255 } ]   
                                [ 0.65 Egypt_Tiles ]
                                [ 0.7 Egypt_Tiles ]          
                                [ 1 pigment { rgb <151,38,38>/255 }
                                    finish { ambient 0.2 } 
                                    normal { wrinkles 0.3 scale <0.2,0.1,0.2> } 
                                    ]
                              }                                             
                  scale 11  
                }
          
                              }
#declare Yellow_Tiles = texture { pigment { image_map { gif "yellow_tile_strip.gif" 
                                                             map_type 2 // cylindrical 
                                                      }
                                            translate <0,0.72,0> scale 0.35           
                                               }
                                  finish { Shiny ambient 0.4 }
                                }

#declare Grecian_Urn2 = union {
         torus { 0.87, 0.07 translate <0,5,0> }
         intersection { sor { 7, <0,   -0.5>,
                                 <3,   0>,
                                 <2.2, 0.5>,
                                 <5,   6>,
                                 <2.2, 7.5>,
                                 <2.5, 8.5>
                                 <4,   9>
                               sturm
                               scale <0.4,0.6,0.4>
                             }
                         cylinder { <0,0,0>, <0,5,0>, 10 }
                      }
         texture { gradient y 
                   texture_map { [ 0 pigment { Gold }
                                     finish { Shiny specular 0.5 ambient 0.4 }  
                                     ]   
                                 [ 0.69 Yellow_Tiles ]
                                 [ 0.8 Yellow_Tiles ]          
                                 [ 1 pigment { Gold }
                                     finish { Shiny specular 0.5 ambient 0.4 }  
                                     ]
                               }                                             
                   scale 4 
                 }
          
                             }

#declare Palm_Urn = intersection { sor { 6, <0,  -0.5>,
                                            <6,   0.0>,
                                            <8,   2.0>,
                                            <9,   4.0 >,
                                            <10,  6.0>,
                                            <11,  8.0>
                                            sturm scale <0.5,1,0.5>
                                       }
                                   cylinder { <0,0,0>, <0,4,0>, 10 
                                              pigment { Clear } 
                                            }
                                   pigment { image_map { gif "mossy_tile_strip.gif" 
                                                         map_type 2 // cylinder map
                                                       }
                                             scale 4          
                                           }
                                   finish { ambient 0.5 }        
                                   normal { bumps 0.1 scale 0.2 }
                                 }                                 

#declare White_Stucco = texture { pigment { image_map { gif "white_stucco.gif" 
                                                        map_type 0 // planar 
                                                      }           
                                          }
                                  finish { ambient 0.3 }
                                  normal { wrinkles 0.3 scale <0.4,0.15,0.15> }
                                }
                                
#declare Glazed_Tiles = texture { pigment { image_map { gif "glazed_tile1.gif" 
                                                        map_type 2 // cylindrical 
                                                      }
                                            translate <0,0.77,0> scale 0.1           
                                          }
                                  finish { ambient 0.3 }
                                  normal { wrinkles 0.3 scale <0.2,0.1,0.2> }
                                } 

#declare Topiary_Urn = union { torus { 4.4, 0.16 translate <0,4,0>
                                       texture { White_Stucco }
                                     }
                               intersection { sor { 6, <0,  -0.5>,
                                                    <6,   0.0>,
                                                    <8,   2.0>,
                                                    <9,   4.0 >,
                                                    <10,  6.0>,
                                                    <11,  8.0>
                                                    sturm scale <0.5,1,0.5>
                                                  }
                                              cylinder { <0,0,0>, <0,4,0>, 10 
                                                         pigment { Clear } 
                                                       }
                                            }               
                               texture { gradient y 
                                         texture_map { 
                                          [ 0 White_Stucco ] 
                                          [ 0.45 White_Stucco ]
                                          [ 0.455 pigment { White } ]   
                                          [ 0.46 Glazed_Tiles 
                                                 scale 5.3 translate <0,0.05,0> ]
                                          [ 0.94 Glazed_Tiles 
                                                scale 5.3 translate <0,0.05,0> ]
                                          [ 0.95 pigment { White} ]           
                                          [ 1 pigment { rgb <100,150,170>/255 }
                                              finish { ambient 0.2 } 
                                              normal { wrinkles 0.3 scale <0.2,0.1,0.2> } ]
                                                     }                                             
                                         scale 4
                                       }                                          
                             }

#declare Dirt = cylinder { <0,-0.5,0>, <0,0.05,0>, 1
                           pigment { image_map { gif "dirt2.gif" 
                                                 map_type 0
                                               }
                                     translate <-0.5,-0.5,0> rotate <90,0,0>          
                                   }
                           finish { ambient 0.1 }        
                           normal { bumps 2 scale 0.1 }
                         }
                              
//  BUILD the BARREL ******************************************************************
#declare Boule = intersection { difference { sphere { <0,0,0>, 1 }
                                             sphere { <0,0,0>, 0.95 }
                                           }         
                                box { <-5,-0.7,-5>, <5,0.7,5> }
                                scale <0.5,1,0.5> translate <0,0.7,0>
                              }

#declare Rib = difference { intersection { object { Boule }
                                           plane { x,0 }
                                           rotate <0,-43,0>
                                         }
                            plane { x,0 }
                          }

#declare R = seed(7227)
#declare Barrel = union { #declare C = 0;
                          #while (C < 360)
                          object { Rib  
                                   texture { T_Wood1 translate <-1,0,-1>/5 
                                             translate <-0.3*0.6*rand(R),0,0> 
                                             scale 0.3+0.9*rand(R)
                                             rotate <89.5+1.5*rand(R),-1+2*rand(R),0> 
                                           } 
                                   rotate <0,C,0>
                                 }
                          #declare C = C + 45;
                          #end
                        }       

#declare Strap_Top = intersection { object { Boule }
                                    box { <-5,0,-5>, <5,0.1,5> translate <0,1.25,0> }                                
                                    pigment { color Gray20 }                               
                                  }

#declare Strap_Upper = intersection { object { Boule  }
                                      box { <-5,0,-5>, <5,0.1,5> translate <0,0.9,0> }
                                      pigment { color Gray20 }                               
                                    }
                                     
#declare Strap_Lower = intersection { object { Boule  }
                                      box { <-5,0,-5>, <5,0.1,5> translate <0,0.40,0> }
                                      pigment { color Gray20 }                               
                                    }

#declare Strap_Bottom = intersection { object { Boule }
                                       box { <-5,0,-5>, <5,0.1,5> translate <0,0.03,0> } 
                                       pigment { color Gray20 }
                                     }

#declare Keg = union { intersection { object { Barrel }
                                      cylinder { <0,0,0>, <0,1.365,0>, 2 }
                                      rotate <0,30,0>
                                    }
                       object { Strap_Top scale <1.01,1,1.01> }
                       object { Strap_Upper scale <1.01,1,1.01> }
                       object { Strap_Lower scale <1.01,1,1.01> }
                       object { Strap_Bottom scale <1.01,1,1.01> }
                       scale <1.5,1.35,1.5> rotate <0,70,0>
                     }

// BUILD the BUCKET *****************************************************************
#declare Puddled_Water = material { texture { pigment { rgbf <0.825,0.825,0.95,0.99> }
                                              finish { ambient 0.1 diffuse 0.1 
                                                       specular 0.3 reflection 0.05 
                                                     }
                                              normal { average 
                                                       normal_map { 
                                                             [ 0.5 ripples 0.3 scale 0.5 ]
                                                             [ 0.5 bumps 0.2 scale 0.5 ]
                                                                  }
                                                     }                       
                                            }        
                                    interior { ior 1.2 }
                                  }

#declare Handle_Braid = union { #declare C = -9;
                                #while (C < 180.1)
                                union {
                                        sphere { 0, 0.05 scale <1,1,4> rotate <10,20,0>
                                                 pigment { Wheat }
                                               }
                                        sphere { 0, 0.05 scale <1,1,4> rotate <-10,-20,0>
                                                 pigment { Khaki }
                                               }
                                               translate <-1.2,0,0> rotate <0,-C,0>
                                      }      
                                #declare C = C + 9;
                                #end
                              } 
                                                                          
#declare Handle = union { intersection { object { Handle_Braid scale <1,1,1.2> }    
                                         plane { z, 0 }
                                         rotate <90,0,0> scale 0.45  
                                       }
                          torus { 0.07, 0.02 translate <0.495,0.05,0>
                                  pigment { Gray20 }
                                }
                          torus { 0.07, 0.02 translate <-0.495,0.05,0>
                                  pigment { Gray20 }
                                }
                          sphere { 0, 0.04 scale <1.35,1,1.35> translate <0.52,0.02,0>
                                   pigment { bozo color_map { [ 0 Khaki ] 
                                                              [ 1 Wheat ]
                                                            }
                                             scale 0.005
                                           }               
                                   normal { bumps 0.3 scale 0.01 }
                                 }
                          sphere { 0, 0.04 scale <1.35,1,1.35> translate <0.52,0.02,0>
                                   pigment { bozo color_map { [ 0 Khaki ] 
                                                              [ 1 Wheat ]
                                                            }
                                             scale 0.005
                                           }               
                                   normal { bumps 0.3 scale 0.01 }
                                 }                        
                        }

#declare Bucket = union { intersection { object { Barrel }
                                         cylinder { <0,0,0>, <0,0.52,0>, 2 }
                                         rotate <0,30,0>
                                       }
                          object { Strap_Lower scale <1.01,1,1.01> }
                          object { Strap_Bottom scale <1.01,1,1.01> }
                          object { Handle rotate <-137,0,0> translate <0,0.47,0> }
                          cylinder { <0,0,0>, <0,0.4,0>, 0.35 pigment { Black} }
                          cylinder { <0,0.4,0>, <0,0.45,0>, 0.37
                                     pigment { rgb <0.825,0.825,0.95> }
                                   } 
                          cylinder { <0,0.45,0>, <0,0.5,0>, 0.4
                                    material { Puddled_Water scale 1.2 }
                                   }              
                          scale <1,1.35,1> rotate <0,70,0>
                        }

//  BUILD the BENCH ******************************************************************
#declare S_Cube = superellipsoid { <0.1,0.1> translate <1,1,1> scale 0.5 } // unit cube

#declare Leg = union { superellipsoid { <0.2,0.2> translate <1,1,1> scale 0.5 
                                        scale <0.15,1.2,0.15> translate <-0.075,0,-0.075>
                                        texture { T_Stone8 scale 2 
                                                  finish { ambient 0.3 }
                                                }
                                      }        
                       sphere { <0,0,0>, 0.15*0.8 
                                scale <1,0.55,1> translate <0,1.25,0> 
                                texture { Brass_Texture }
                              }               
                     }         

#declare Round_Box = superellipsoid { <0.1,0.1> translate <1,1,1> scale 0.5 
                                        scale <5,0.06,1.5> translate <-2.5,0,-0.75>
                                    }
                                      
#declare Bench = union { object { Round_Box translate <0,1.2,0>  // the seat
                                  pigment { Gray }
                                  finish { Phong_Shiny ambient 0.2 }
                                  normal { crackle 0.7 scale 0.5 }
                                }
                         object { Round_Box scale <0.95,3,0.9> 
                                  translate <0,1.02,0>
                                  texture { Brass_Texture  
                                          }  
                                }
                         object { Leg translate <-2.35,0,-0.6> }
                         object { Leg translate <-2.35,0,0.6> }
                         object { Leg translate <2.35,0,-0.6> }
                         object { Leg translate <2.35,0,0.6> }
                         translate <0,0.15*0.5,0> // put back at origin (leg feet height)
                       }        

//  BUILD the FOUNTAIN ****************************************************************
#declare Bowl_Water = material { texture { pigment { rgbf <0.825,0.825,0.95,0.99> }
                                           finish { ambient 0.1 diffuse 0.1 specular 0.6 } 
                                           normal { waves 1 scale 0.2 }
                                          }
                                 interior { ior 1.2 }
                               }          
                               
#declare Drip_Water = material { texture { pigment { rgbf <0.825,0.825,0.95,0.99> }
                                           finish { ambient 0.1 diffuse 0.1 specular 0.3
                                                    reflection 0.05 
                                                  }
                                           normal { gradient y scale 1
                                                    normal_map {
                                                       [ 0.6 waves 2.0 scale <0.1,10,1> ]
                                                       [ 1.0 waves 2.0 scale <0.5,10,1> ]
                                                               }
                                                  }
                                         }
                                 interior { ior 1.2 }        
                               }
                               
#declare Water_Stain = texture { pigment { bozo 
                                           turbulence <1,0.0,1> octaves 6 
                                           omega 0.5 lambda 4
                                           color_map { [ 0 color Bronze2 ]
                                                       [ 0.45 color Clear ]
                                                       [ 0.55 color Clear ]
                                                       [ 1 color GreenCopper ] 
                                                     }
                                         }
                                 finish { ambient 0.3 } 
                               }

#declare Add_Shape = union { cylinder { <0,0,0>, <0,0.8,0>, 0.04 }
                             sphere { <0,0.8,0>, 0.04 }
                           }
                                                           
#declare N_Counts = 0.25*pi/0.06;
#declare Stem = union { #declare Count = 0;   
                                #while (Count < N_Counts)
                                        object { Add_Shape 
                                                 translate <0,0,0.24>
                                                 rotate <0,Count*360/N_Counts,0>
                                               } 
                                        #declare Count = Count + 1;
                                #end
                        cylinder { <0,0,0>, <0,1,0>, 0.25 }
                        torus { 0.25, 0.08 translate <0,1,0> }
                        texture { pigment { White_Marble } 
                                  finish { ambient 0.3 }
                                }
                        texture { Water_Stain scale <0.2,0.5,0.2> }        
                      } 
                                                           
#declare Bowl = union { difference { sphere { <0,0,0>, 2 }
                                     sphere { <0,0,0>, 2 translate <0,0.2,0> }
                                     plane { -y, 1 }
                                     texture { pigment { White_Marble }
                                               finish { ambient 0.3 }
                                             }
                                     texture { Water_Stain scale <0.2,1,1> }
                                   }
                        torus { 1.8, 0.1 scale <1,0.5,1> translate <0,-1,0>
                                texture { pigment { White_Marble } }
                                texture { Water_Stain }
                              }  
                        difference { sphere { <0,0,0>, 2 translate <0,0.2,0> }
                                     plane { -y, 1 }
                                     material { Bowl_Water }
                                   }
                      }

#declare Bowl_2 = union { difference { sphere { <0,0,0>, 2 }
                                       sphere { <0,0,0>, 2 translate <0,0.2,0> }
                                       plane { -y, 1 }
                                       texture { pigment { White_Marble }
                                                 finish { ambient 0.3 }
                                               }
                                       texture { Water_Stain scale <0.1,1,1> }        
                                     }
                          torus { 1.8, 0.1 scale <1,0.5,1> translate <0,-1,0>
                                  texture { pigment { White_Marble } }
                                  texture { Water_Stain }
                                }
                          difference { sphere { <0,0,0>, 2 translate <0,0.2,0> }
                                       plane { -y, 1 }
                                       material { Bowl_Water }
                                     }
                        }

#declare Drip_Slice = merge { cylinder { <0,0,-10>, <0,0,10>, 0.5 scale <1,0.5,1> }                                       
                              box { <-0.5,-5,-10>, <0.5,0,10> }
                            }
                                    
#declare Drip = difference { cylinder { <0,0,0>, <0,1,0>, 1.9 } 
                             cylinder { <0,-1,0>, <0,2,0>, 1.85 }  //  remove the inside
                             object { Drip_Slice rotate <0,7,0> translate <0,0.8,0> }
                             object { Drip_Slice rotate <0,-40,0> translate <0,0.85,0> }        
                             material { Drip_Water }       
                           }
                           
#declare Drip_2 = difference { cylinder { <0,0,0>, <0,1,0>, 1.9 } 
                               cylinder { <0,-1,0>, <0,2,0>, 1.85 }  //  remove the inside
                               object { Drip_Slice rotate <0,7,0> translate <0,0.8,0> }
                               object { Drip_Slice rotate <0,-40,0> translate <0,0.85,0> }
                               object { Drip_Slice rotate <0,30,0> translate <0,0.85,0> }        
                               material { Drip_Water }
                             }
                           
#declare Spout = blob { threshold 0.65
                        sphere { <0,0,0>, 0.6, 1 }
                        sphere { <0,0.7,0>, 0.8, 1 }
                        sphere { <-0.1,1.1,0>, 0.7, 1 }
                        sphere { <0,1.5,0.2>, 0.6, 1 }
                        sphere { <0,2,0>, 0.6, 1 }
                        sphere { <0.1,2.4,0>, 1, 1 scale <1.2,1,1.1> }
                        texture { pigment { rgbf <0.825,0.825,0.95,0.99> }
                                  finish { ambient 0.1 diffuse 0.1 specular 0.3
                                           reflection 0.05 
                                         }
                                  normal { bumps 2.0 scale 0.5 }
                                }
                        interior { ior 1.2 }                                              
                      }
                                                                     
#declare Fountain = union { object { Stem rotate <0,90,0> }
                            object { Stem scale <0.6,1,0.6> translate <0,1.1,0> }
                            object { Spout scale <0.15,0.2,0.15> translate <0,2.1,0> }
                            object { Bowl scale <1,0.5,1> translate <0,2,0> }
                            object { Drip scale <1,2,1> translate <0,-0.47,0> }
                            object { Bowl_2 scale <0.5,0.2,0.5> translate <0,2.3,0> }
                            object { Drip_2 scale <0.5,1,0.5> rotate <0,-20,0> 
                                     translate <0,1.12,0> 
                                   }
                          }
                                                                                  
// DEFINE the PLANTS ****************************************************************
#declare Leaf_texture = texture { pigment { marble
                                            color_map { [ 0.0 color DarkGreen ]
                                                        [ 1.0 color rgb <0.45,0.6,0.45> ]
                                                      }
                                            scale 0.1
                                          }
                                  finish { phong 0.1 }                           
                                }
                                                                
#declare S = seed(13);
#declare Fern_Leaf = union { #declare C = 1;
                             #while (C < 14)
                             sphere { <0,0.05,0>, 0.05    // the left side
                                      texture { Leaf_texture }
                                      scale <2+0.1*rand(S),9.5+rand(S),0.5>
                                      rotate <-4+22*rand(S),-10+20*rand(S),90-C*(5.7+rand(S))>
                                      rotate <2*C,0,0> translate <0,C/5,0> 
                                    }
                             sphere { <0,0.05,0>, 0.05    // the right side
                                      texture { Leaf_texture }
                                      scale <2+0.1*rand(S),9.5+rand(S),0.5>
                                      rotate <-4+22*rand(S),-10+20*rand(S),-90+C*(5.7+rand(S))>
                                      rotate <2*C,0,0> translate <0,C/5,0>
                                    }
                             #declare C = C + 1;
                             #end

                             cone { <0,0,0>, 0.05, <0,2.6,0.02>, 0.01  // the stem
                                    pigment { color DarkGreen }
                                  }
                             rotate <90,90,0>       
                           }

//  The SKY  **************************************************************************
#declare Hazy_Sky = pigment { granite turbulence 0.2
                              color_map { [ 0,0.25 color rgb <0.4,0.4,1>
                                                   color rgb <0.4,0.4,1> ]
                                          [ 0.25,1 color rgb <0.4,0.4,1>
                                                   color rgb <1,1,1> * 1 ]
                                        }
	                      scale <75000,100000,100000> rotate <0,0,0>
	                      octaves 7.5 omega 0.65
                            }
                         
//  The SEA ***************************************************************************
#declare Sea = union { box { <-500,-1,100>, <100,0,500>  // the water
                              texture { pigment { rgbf <0.9,0.9,1,0.9> }
                                        finish { metallic reflection 0.05 }
                                        normal { ripples 0.5 scale 10 }
                                      }
                           }
                       box { <-500,-1,80>, <100,0,100>
                             texture { pigment { rgb <0.95,0.8,0.7> }   // the sand
                                       finish { ambient .25 diffuse 0.6 }
                                       normal { average turbulence 0.2
                                                normal_map { [ 0.5 bumps 4 scale 2 ]
                                                             [ 0.5 ripples 0.5 scale 5 ]
                                                           }
                                              }
                                     }
                           }
                     }                         
                   
//  RENDER the SCENE ******************************************************************

object { Floor }

object { Main_Room translate <0,-10,0> }
object { Lawn }
object { Path }

// rear gate
object { Left_Gate translate <4,0,-60.5>  // Bring back to origin (left rear gate)
         rotate <0,5,0> translate <-4,0,60.5>
       }
object { Right_Gate translate <-4,0,-60.5>  // Bring back to origin (rear gate)
         rotate <0,30,0> translate <4,0,60.5>
       }
object { Hinges } // for rear gate
object { Wrought_Iron translate <0,8,60.6> }  // above rear gate      
object { Text_Rear_Gate translate <0,8,59.9> }
                
// left gate         
object { Left_Gate translate <4,0,-60.5>  // Bring back to origin (left left gate)
         rotate <0,-90,0> translate <-20.5,0,16>
       }
object { Right_Gate translate <-4,0,-60.5>  // Bring back to origin (right left gate)
         rotate <0,-135,0> translate <-20.5,0,24>
       }
object { Hinges translate <0,0,-60.5> // bring back to origin (left gate hinges)
         rotate <0,-90,0> translate <-20.5,0,20>
       }
object { Wrought_Iron rotate <0,-90,0> translate <-20.6,8,20> }  // above left gate
object { Text_Left_Gate rotate <0,-90,0> translate <-19.92,8,20> }

union { object { Pool }
        object { Fountain scale 1.8 }
        translate <0,0.55,0>
      }

object { Column_1 translate <-9,0,-20> }       // one column at each corner of pool
object { Column_1 rotate <0,30,0> translate <9,0,-20> }
object { Column_1 rotate <0,-90,0> translate <-9,0,20> }
object { Column_1 rotate <0,180,0> translate <9,0,20> }
object { Frame translate <0,0,0> }
 
object { Bucket scale 2 rotate <0,-40,0> translate <-5,0,-22.5> }
merge { sphere { 0, 1 scale <2.6,0.06,2> translate <-4,0,-22> }
        sphere { 0, 1 scale <2.6,0.04,2> scale <1.5,1,1.5> translate <-4,-0.06,-22> }
        material { Puddled_Water scale 0.18 } 
      }
      
object { Egyptian_Urn scale 0.3 rotate <0,90,0> translate <6.5,-0.1,55> no_shadow }
object { Grecian_Urn2 rotate <0,30,0> scale 0.7 translate <-18.2,0,42.5> }
object { Keg scale 1.5 translate <-10,0,45> }

object { Bench scale 1.5 rotate <0,-90,0> translate <-10.5,0,1.8> }
object { Bench scale 1.5 rotate <0,-90,0> translate <10.5,0,1> }

union { object { Palm_Urn }
        object { Dirt scale <4.3,1,4.3> translate <0,3.8,0> }
        scale 0.45 translate <7,0,-23>
      }

union { object { Topiary_Urn }  
        object { Dirt scale <4.3,1,4.3> rotate <0,90,0> translate <0,3.8,0> }
        scale 0.3 translate <-1.5,0,-21> //translate <-4,0,-22.5>
      }
      
//  The Sky
plane { y, 3000 pigment { Hazy_Sky scale 0.3 }
                finish { ambient 1 }
	        no_shadow hollow
      }      
fog { fog_type 1 distance 200000
      color rgb <0.9,0.9,1> 
    }
    
object { Sea }
   
// The tree holes
object { Dirt scale <1.5,1,1.5> translate <-18.5,0,8> } // Lombardy 1
object { Dirt scale <1.5,1,1.5> translate <-18,0,26> }  //          2
object { Dirt scale <1.5,1,1.5> translate <-18,0,37> }  //          3
object { Dirt scale <1.5,1,1.5> translate <-18,0,48> }  //          4
object { Dirt scale <1.5,1,1.5> translate <-8,0,45> }       // Olive

// The Trees
#include "topiary_2.inc"
#include "tomtree.inc"
object { Tree rotate <0,180,0> scale 2.5 translate <-1.5,0.3,-21> } // the topiary

#include "palm_1.inc"
#include "tomtree.inc"
object { Tree scale 9 translate <7,1.5,-23> }  // the palm tree       
       
#include "lombardy.inc"
#include "tomtree.inc"                  // Lombardy poplars, on both sides of left gate
object { Tree scale 20 rotate <0,-40,0> translate <-18.5,0,8> }
object { Tree scale 19.5 translate <-18,0,26> }   
object { Tree scale 20.5 rotate <0,135,0> translate <-18,0,37> }
object { Tree scale 19 rotate <0,-120,0> translate <-18,0,48> }

#include "olive_1.inc"
#include "tomtree.inc"
object { Tree scale 15 translate <-8,0,45> }

// The plants LEFT of gate
// just beyond the left gate
object { Fern_Leaf  rotate <-90,0,90> rotate <0,0,40> translate <-32,10,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <0,0,90> translate <-32,8,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <0,0,60> translate <-32,6,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <0,0,135> translate <-32,4,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <0,0,100> translate <-32,2,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <0,0,50> translate <-32,1,61> } 
         
// behind the rear wall
#declare Count = -35;
#while (Count < -4.8)
        object { Fern_Leaf scale <0.8+0.4*rand(S),0.8+0.4*rand(S),0.8+0.4*rand(S)> 
                 rotate <-120+240*rand(S),360*rand(S),360*rand(S)>
                 translate <Count,9+4*rand(S),63+2*rand(S)>
               }  
        #declare Count = Count + 0.2;
#end

object { Fern_Leaf  rotate <-90,0,90> rotate <5,0,-40> translate <-6,10,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <-15,0,-90> translate <-6,8,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <10,0,-60> translate <-5.6,6,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <-7,0,-135> translate <-6,4,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <20,0,-100> translate <-6,2,61> }
object { Fern_Leaf  rotate <-90,0,90> rotate <0,0,-50> translate <-6,1,61> }

// The plants to RIGHT of gate
#declare Count = 4;
#while (Count < 30)
        object { Fern_Leaf 
                 scale <0.8+0.4*rand(S),0.8+0.4*rand(S),0.8+0.4*rand(S)> 
                 rotate <-120+240*rand(S),360*rand(S),360*rand(S)>
                 translate <Count,9+4*rand(S),63+2*rand(S)>
               }       
        #declare Count = Count + 0.2;
#end

// END
