// Persistence of Vision Ray Tracer Scene			
// Megapov3 for windows version 3.1g de Nathan Kopp
// Fichier        : babel by  Martial Rameaux
// Date           : Decembre 1999
// Description    :                     
// Web  -> http://martial.rameaux.free.fr/
// mile ;-) -> mailto:martial.rameaux@free.fr
//==================================
// 9h42mn16s with medium radiosite 
// 3h07mn09s for parse
// ColorPicker was created by Jamis Buck.  
// mkseed.exe by Jean-Michel Soler for randomise. 
// Trees are cut and paste from Gilles Tran's MakeTree 
//=========-for-works-==============
#declare Lumiere =true;   
#declare Arbre=true;
#declare Brouillard=true; 
#declare TourdeB=true;
#declare FocalBlur=false;
#declare phot=true;
//==========global settings=========
#declare phd=.8;
global_settings 
{
ini_option "+w600 +h600 +a0.2"
assumed_gamma 1.0
#declare high_quality=no; // or yes
#if(high_quality)
  // High Quality - slow rendering
  ini_option "+qr"
  ini_option "Preview_Start_Size=8"
  ini_option "Preview_End_Size=4"
  
  radiosity{
    count 80             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16 (or 8 for high quality)
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    max_sample 2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#else
  // Medium Quality - works for most scenes
  ini_option "+qr"
  ini_option "Preview_Start_Size=16"
  ini_option "Preview_End_Size=8"
  
  radiosity{
    count 35             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 2.25     // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 3    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    max_sample 2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#end

#if (phot)
photons {
    gather 20, 100
    radius .05*phd*sqrt(20), 2
    $phd=phd*2 
    autostop 0
    jitter .9
   // range_divider 2000
  }
 motion_blur 8,.1 
#end 
}
//====================================
//  POSITION DE LA CAMERA Autor : Jean Montambeault
//------------------------------------
#declare Zoom=1.35;
#declare Distance =50;
#declare Azimut = 0; 	// angle de dplacement                       
#declare Elevation =4;  // angle en degrs au-dessus (positif) ou en-dessous (ngatif) du plan XZ ; 
                        // cet angle se limite  : 90 > Elevation > -90. C'est absolument ncessaire.
#declare Right=4/4*x;   // pour changer le rapport x/y ;                        
#declare CentreD_Interet = <0,20,0>;
#declare Angle=0;

#declare FocalBlur=FocalBlur; // true pour enclencher le focal blur
#declare Aperture=0.3;	      // adapter les valeurs 	
#declare BlurSamples=30;
#declare FocalPoint=<0,20,0>;

//------------------------------------
#include "camera.inc" 
Camera (Distance, Azimut, Elevation, CentreD_Interet,FocalBlur) //, Angle
//=====================================
#include "random.inc"
#include "brouette.inc"
#include "minaret.inc"
#include "fenetre.inc"

//=====================================
light_source { 0*x color rgb <0.957,0.933,0.729>*0.5 translate <0,500,0>}  
light_source { 0*x rgb 1 translate <-100,300,-200> } 
light_source { 0*x rgb 1 translate <-100,300, 200> }
//=====================================
//plane { z,400 pigment { color rgb <0.188,0.306,0.843>*0.2} finish {ambient 0.2 diffuse 0.2 phong 1 phong_size 100 } hollow}
background {color rgb <0.188,0.306,0.843>*0.2}
//plane {y,0 pigment {color rgb <0.188,0.306,0.843>*0.2}}
//=====================================
#if (Brouillard)
#declare Distfog2=200;//170
#declare fogoff2=50;
fog {
	distance Distfog2
	color rgbt<0.494,0.643,0.52,0.1> //<0.678,0.949,0.839>*0.1
	turbulence 0.2
        turb_depth 0.5
	fog_type 2
	fog_offset fogoff2
	fog_alt 0.5
}
#end
//====================================
#declare Brouettes_sous_Fenetre=
union {
#declare i=30;  
#declare RoueTourne=37;
#while (i > 0)
object {Brouette (i*RoueTourne) rotate y*145 translate <10,10+i*0.8,8> rotate y*35*i}
#declare i=i-1;
#end  //fin while
}
//---------Fentre----------------
#declare Ampoule=light_source { <0,0,0>  rgb <2,Rand(),Rand()>
                                         spotlight  
                                          radius 10 
                                          falloff 11 
                                          tightness 10 
                                          point_at <-5,i*0.8,0> 
                                          fade_distance 10 fade_power 1 
                                          photons {reflection on refraction on}
                                         }
                                        
                                          
               
#declare i=30; 
#declare Fenetres=
union { 
#while (i > 0)
object {Fenetre scale 0.8 rotate <-10,-90,0> translate <9,10+i*0.8,0> rotate y*35*i rotate y*-4 translate y*3}  
       /* #if  (Lumiere)
        object { Ampoule   translate <10,12+i*0.8,0.0>   rotate y*35*i rotate y*-4 translate y*4}
         #end */
#declare i=i-1;
#end  //fin while
}
//====================================
#declare Trou_Fenetres=union {
        #declare i=30;  
#while (i > 0)
box {<-1.5,0.2,0.1><1.5,5,5> 
       // pigment {rgbt <0.0,0.0,0.8,0.8>}
scale 0.8 rotate <0,-90,0> translate <9,10+i*0.8,0> rotate y*35*i rotate y*-4 translate y*3
}
#declare i=i-1;
#end  //fin while
}
//===================================
#macro TourdeBabel(Ftr,Brtt) 
object{
  union {
  difference {
        object {Minaret_Creux}
        #if (Ftr)
        object {Trou_Fenetres }
        #end
  }
  #if (Ftr)
        object { Fenetres} 
  #end
  #if (Brtt=1)
        object {Brouettes_sous_Fenetre}
  #end
texture {T_Colonne} 
  }  
}

#end
//====================================
 object {TourdeBabel (1,1) rotate y*10 translate <-2,0, 0> hollow}
//object {TourdeBabel rotate y*10 translate <50,20, 110> hollow}
//===================================                   
#if (TourdeB)
object {TourdeBabel (0,0)  scale 1.5 rotate y*10 translate <-45,-5, 140> hollow}
object {TourdeBabel (1,0)  scale 2.5 rotate y*10 translate <-60,-5, 100> hollow}
//object {TourdeBabel (1,0) scale 1.5 rotate y*10 translate <-45,-5, 100> hollow}

object {TourdeBabel (1,0) scale 1.5 rotate y*10 translate < 45, -30, 170> hollow}
object {TourdeBabel (0,0) scale 1.5 rotate y*10 translate < 65,  -5, 180> hollow}
object {TourdeBabel (1,0) scale 1.5 rotate y*10 translate < 100,-140, 320> hollow}



#end
//=======End Script=============================

