// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1g
// Fichier        :  brouette.inc by  Martial Rameaux
// Date           :  decembre 99
// Description    :                     
// Web  ->http://martial.rameaux.free.fr/
// mile ;-) -> martial.rameaux@free.fr
//==========================================
#macro Brouette ( TourneRoue )
//=====Texture_Brouette===========
#declare NormalBenne=normal {wood 0.02 scale 0.2}
#declare T_RoueBrouette=texture { pigment {wood 
                        color_map {[0.0 rgb <0.3,0.4,0.4>]
                                   [0.1  rgb <0.8,0.9,0.2>]
                                   [1.0  rgb <0.8,0.7,0.6>]
                        }
                        
                          
                        scale 0.1
                        }
                        finish {ambient 0.3  diffuse 0.5 }
}
#declare T_BrasBrouette=texture { pigment {wood 
        
                        color_map {[0.0  color rgb <0.404,0.227,0.055>]
                                   [0.1  color rgb <0.459,0.259,0.063>]
                                   [1.0  color rgb <0.651,0.435,0.094>]
                        }
                        scale 0.1
                        }
                        finish {ambient 0.3  diffuse 0.5 }
}

#declare T_RoueRayon=texture {
                
                pigment {gradient x 
                        color_map {[0.0 rgb <0.3,0.4,0.4>]
                                   [0.1  rgb <0.8,0.9,0.2>]
                                   [1.0  rgb <0.8,0.7,0.6>]
                        }
                        scale 0.01
                        }
                        finish {ambient 0.3  diffuse 0.5 }
}
#declare T_BenneBrouette=texture { pigment {wood 
                                                color_map { [0.0 color rgb <Rand(),Rand(),Rand()>*1.3]//<0.537,0.333,0.231> ]//
                                                            [0.2 color rgb <Rand(),Rand(),Rand()>*1.3] // <0.600,0.302,0.004> ]//
                                                            [1.0 color rgb <Rand(),Rand(),Rand()>*1.3]   //<0.443,0.227,0.227> ]//                                                      
                                                            }
                                                           #declare Turb=0.1;
                                                           turbulence Turb scale 0.1
                                                             }
                                    finish { ambient 0.3 diffuse 0.6 phong 10 phong_size 20 }                                                               
                                       rotate y*Rand()
}

#declare T_Roulement=texture {pigment {rgb <0.95,0.95,.95>}finish {ambient 0.1 diffuse 0.3 crand .09}}

//--------T_PotdeFleurs---
#declare T_PotdeFleurs=
texture {pigment 
                                {bozo  
                                     color_map {
                                       [0.0 rgb <Rand(),Rand(),Rand()>]
                                       [0.5 rgb <Rand(),Rand(),Rand()>]
                                       [1.0 rgb <Rand(),Rand(),Rand()>]
                                     }
                                }                                                                                                        
                                 finish { ambient 0.3 diffuse 0.6 phong 1 phong_size 40}
}


//=======Brouette Forme================
#declare RoueBrouette=
union {                     
difference {        
  cylinder { <0,0,-0.11><0,0,0.11>,1 }
                cylinder { <0,0,-0.3><0,0,0.3>,0.98 }
                texture {T_Roulement} 
}
difference {    
                cylinder { <0,0,-0.1><0,0,0.1>,.98 }
                cylinder { <0,0,-0.3><0,0,0.3>,0.8 } 
                    
 texture {T_RoueBrouette} 
}
cylinder { <-.8,0,0.0><0.8,0,0.0>0.08 texture {T_RoueRayon rotate z*90}}     
cylinder { <0,-.8,0.0><0,0.8,0.0>0.08  texture {T_RoueRayon}}         
cylinder { <0,0,-.15><0,0,.15>0.12 texture {T_RoueBrouette}}  //moyeux       
cylinder { <0,0,-.50><0,0,.50>0.05 texture {T_Roulement }}  //moyeux       

}
#declare BenneBrouette= union {
        box {<1.2,0.1,-1><4,0.2,1> texture {T_BenneBrouette rotate y*90 }}
        box {<0,0.0,-1.1><.1,1.4,1> rotate z*20 translate <1.2,0.1,0>}
        box {<0,0.0,-1><.1,.6,1> rotate z*-20 translate <3.9,0.1,0>}
/*
        difference {    
           box {<1.0,0.1,0><5,0.8,.1> rotate x*-10 translate z*-1}
           box {<-2,0.0,-1.3><.1,1.4,1> rotate z*20 translate <1.2,0.1,0>}         
           box {<0,0.0,-2><2,2,2> rotate z*-20 translate <4,0.1,0>}
        texture {T_BenneBrouette rotate y*85 }
        }
        difference {    
        box {<1,0.1,0><5,0.8,-.1> rotate x*10 translate z* 1}
        box {<-2,0.0,-1><.1,1.4,1.3> rotate z*20 translate <1.2,0.1,0>}
        box {<0,0.0,-2><2,2,2> rotate z*-20 translate <4,0.1,0>}
               texture {T_BenneBrouette rotate y*90 } }
   */     
      texture {T_BenneBrouette }


        }
//------Bras-de-la-brouette-----------

#declare BrasBrouette=
union { 
       
       
        union {
                box { <-0.1,-0.1,-.20><3.9,0.1,-.40>}
                cylinder {<-0.1,-0.0,-.20><-0.1,-0.0,-.40>0.1}
                rotate y*8
        }
        union {
                box { <-0.1,-0.1, .20><3.9,0.1, .40>}
                cylinder {<-0.1,-0.0, .20><-0.1,-0.0, .40>0.1}
                 rotate y*-8
        }   

        box { <3.8,-0.1,-0.95><4.4,0.1,-0.75>   }
        box { <3.8,-0.1, 0.95><4.4,0.1, 0.75>   }
        box {<3.8,-0.1,-0.95><2,0.1,-0.75> clipped_by {sphere { <1.5,0,-0.8>0.2 }}} // bout
        box {<3.8,-0.1, 0.95><2,0.1, 0.75> clipped_by {sphere { <1.5,0, 0.8>0.2 }}} // bout 
        
        intersection {                                // poigne droite 
        box {<4.4,-.1,-0.95><6,0.1,-0.75>      }
        cone {<4.3,0,-0.84>0.15<5.5,0,-0.84>0.10 }
        } 
       

        intersection {                                  // poigne gauche
        box {<4.4,-.1, 0.95><6,0.1, 0.75>      }
        cone {<4.3,0, 0.86>0.15<5.5,0, 0.86>0.10}
        }
        box {<4.2,0, 0.95><4.4,-1, 0.75>} // pieds
        box {<4.2,0,-0.95><4.4,-1,-0.75>}
        //texture {T_BrasBrouette rotate y*90}
        
texture {T_BrasBrouette rotate y*85}
}

//===========Pot de fleurs============
#declare PotdeFleurs=union {
                                cone { <0,0,0>0.6<0,.5,0>0.8}
                                cylinder {<0,.5,0><0,0.7,0>0.82 open}
                                texture  { T_PotdeFleurs }
}
//=====ARBRES==========================

#if (Arbre)
//----------------------
#include "mr_arbre.inc"  
//---------------------- 
#declare rsd=seed(ra);       //ra random  
#declare rd=rand(rsd); 
    
//=============================================
#declare t_ecorce=texture { pigment {color rgb <.5-rand(rd),.5-rand(rd),.5-rand(rd)> } normal {granite rand(rd)*1.2 }}
//=============================================          
#declare level0=5;     //10 initial de la recursion 
#declare nb_bch0=4;    //8 nombre de branche par niveau
#declare snd_bch=0.9;  // seconde branche
#declare branchevertical=true; //branche verticale true/false

#declare lg_bch0=15;       //25 initial longueur de la branche 
#declare dec_lg_bch=0.7;   //0.7 dcroissement de la branche 

#declare rd_bch0=1.5;      // initial du radius de la branche
#declare dec_rd_bch=0.4;   // decroissement du radius de la branche

#declare angl_bch0=45;  //35  // angle avec le tronc
#declare dec_angl_bch=0.6; // .3 decroissement de l'angle de la branche

#declare vect0=<.0,1,0>;     //initial direction
     
//#debug concat("rsd:",str(rd,2,2),"\n")
#declare pos0=<0,0,0>;       // position de depart

#declare facnx=rand(rd);//0.3;  //facteur des noeuds
#declare dvay=200;
#declare dvax=200;   
#declare proba_bch=1 // rand(rd); 

//----Feuilles --
#declare  lsize=5*Rand(); 
        #if (lsize > 1) #declare  lsize=0.9; #end
#declare seg=50;
#declare ll=5*Rand();
//#debug concat ("ll ",str(ll,0,3),"\n")
#declare wl=5*Rand();
#declare lpow=3;
#declare ndents=8;
#declare fl=0.2;
#declare apow=3; 
#declare al=100; 
#declare stdlsize=0.1;
#declare alz0=100;       // max z angle for leaf
#declare alx0=-10;      // start x angle for leaf
#declare stdalx=20;     // stddev x angle for leaf
#declare T_Feuille=texture {pigment 
                                {bozo  
                                     color_map {
                                       [0.0 rgb <Rand(),Rand(),Rand()>]
                                       [0.5 rgb <Rand(),Rand(),Rand()>]
                                       [1.0 rgb <Rand(),Rand(),Rand()>]
                                     }
                                }                                                                                                        
                                 finish { ambient 0.3 diffuse 0.6 phong 1 phong_size 40}
}
#end

//========================================
//     Affichage de la Brouette
//----------------------------------------

union {
        object {RoueBrouette rotate z*TourneRoue}
        object {BenneBrouette}
        object {BrasBrouette}  
#if (Arbre=1)
        #declare Feuille=object {FaireFeuille(lsize,seg,ll,wl,lpow,ndents) texture {T_Feuille}}
        union {arbre()scale 0.15 translate <2.5,0.35,0>} 
        object { PotdeFleurs translate <2.5,0.2,0>}
#end //if

#if (Lumiere)
        light_source { <-10,5,0> rgb 1 spotlight
                                  radius 10 
                                  falloff 15 
                                  tightness 10 
                                  point_at <3, 2.0, 0> 
                                  //shadowless 
                                  fade_distance 10
                                  fade_power 2
                                 
        } 
#end //if lumiere

}

#end //macro

//=========Fin de script====================
