// Exemple de commande pour mr_arbreshow!
/*
#declare level0=5;    // initial de la recursion 
#declare nb_bch0=3;   // nombre de branche par niveau

#declare lg_bch0=20;       // initial longueur de la branche 
#declare dec_lg_bch=0.50;  // dcroissement de la branche 

#declare rd_bch0=1.3;      // initial du radius de la branche
#declare dec_rd_bch=0.5;   // decroissement du radius de la branche

#declare angl_bch0=35;     // angle avec le tronc
#declare dec_angl_bch=0.6; // decroissement de l'angle de la branche

#declare vct0=<.6,1,0>;     //initial direction
#declare 

#declare rsd=1;           // random seed
#declare rd=seed(rsd);   // random stream for branches
*/
//===========================================
#macro fairebranche (level,pos,vect)
#if (level > level0 - 3) #warning concat("level= ",str(level,0,0),"\n") #end
#if (level > 0)    
#local nb_bch=max(1,nb_bch0-level0+level); 
#local lg_bout=lg_bch[level]/nb_bch;
#local posbch=array[nb_bch+1] // positions des branches
#local posbch[0]=pos; 

#local k=0;
#local ay= 360*(0.5-rand(rd));
        
#while ( k < nb_bch )
       #local rd_bch1=rd_bch[level]+(rd_bch[level-1]-rd_bch[level])*k/nb_bch;
       #local rd_bch2=rd_bch[level]+(rd_bch[level-1]-rd_bch[level])*(k+1)/nb_bch;
       
       #local vnoeux=<(0.5-rand(rd)),0.5-rand(rd)*facnx,facnx*(0.5-rand(rd))>;
       #if (vlength(vnoeux)>0) #local vnoeux=vnormalize(vnoeux); #end
       

       #local posbch[k+1]=posbch[k]+lg_bout*vnormalize(vect+vnoeux)*(1+(0.5-rand(rd)));
       
              union {
                       cone{posbch[k],rd_bch1,posbch[k+1],rd_bch2 } // fait la branche
                       sphere { posbch[k],rd_bch1}
              }    
     // #if (rand(rd)<=leafproba & level<=leaflevel)
                #local alz=alz0*(0.5-rand(rd));
                #local alx=alx0+stdalx*(0.5-rand(rd));
                #local P1=posbch[k];
                #local P2=posbch[k+1];
                #local aly=degrees(atan2(P2.x-P1.x,P2.z-P1.z+0.0001))-180;          
      object{ Feuille scale (1+stdlsize*rand(rd)) rotate z*alz rotate x*alx rotate y*aly translate P2}
     // #end
//-------------
        #if (posbch[k+1].x>xMax) #declare xMax=posbch[k+1].x; #end
        #if (posbch[k+1].y>yMax) #declare yMax=posbch[k+1].y; #end
        #if (posbch[k+1].z>zMax) #declare zMax=posbch[k+1].z; #end
        #if (posbch[k+1].x<xMin) #declare xMin=posbch[k+1].x; #end
        #if (posbch[k+1].y<yMin) #declare yMin=posbch[k+1].y; #end
        #if (posbch[k+1].z<zMin) #declare zMin=posbch[k+1].z; #end
        #local k=k+1;

#end //while

//-------Nouvelle Branche ---------------        
#local new_level=level-1;                  
#local ax=angl_bch[level]+ 2*(0.5-rand(rd));
#local ay=2*(0.5-rand(rd));
#local new_vect=vCone(posbch[nb_bch-1],posbch[nb_bch],ax,ay)
fairebranche(new_level,posbch[nb_bch],new_vect)
//---------------------------------------
//--------Branche verticale
//-------------------------------------
#if (branchevertical=true & level=level0)
        #local ax=dvax*(0.5-rand(rd));
        #local ay=dvay*(0.5-rand(rd));
        #local new_vect=vCone(posbch[nb_bch-1],posbch[nb_bch],ax,ay)
        fairebranche(new_level,posbch[nb_bch],new_vect)

#end
//--------------------------------------

#local j=1;      
#while (j< nb_bch)
     #if (rand(rd) <= proba_bch )
                
                #local i=int(snd_bch*nb_bch)+rand(rd)*(nb_bch-int(snd_bch*nb_bch));
                #local ay=j*360/nb_bch + dvay*(0.5-rand(rd));
                #local ax=angl_bch[level]+ dvax*(0.5-rand(rd));
                #local new_vect=vCone(posbch[i],posbch[i+1],ax,ay)
                #local new_pos=posbch[i]+(posbch[i+1]-posbch[i])*rand(rd);
               fairebranche(new_level,new_pos,new_vect)
               #end
#local j=j+1;
#end //while
//-------------------------------------
// 
//-------------------------------------
#if (level=level0)
#local l=0;
  #while (l< nb_bch)
                #local ay=360/nb_bch + dvay*(0.5-rand(rd));
                #local ax=angl_bch[level]+ dvax*(0.5-rand(rd));
                #local new_vect=vCone(posbch[l],posbch[l+1],ax,ay)
                #local new_pos=posbch[l]+(posbch[l+1]-posbch[l])*rand(rd);
               fairebranche(1,new_pos,new_vect)
#local l=l+1;
#end //while
#end // if
//--------------------------------------    
#end // fin if level > 0
#end // fin macro fairebranche
//---------------------------------------
//--------------------------------
//   Normalise l'axe des cones
//--------------------------------
#macro vCone(P1,P2,ax,ay)
#local p = vaxis_rotate(vaxis_rotate(y,x,ax),y,ay);
#local yV1=vnormalize(P2-P1);
#local xV1=vnormalize(vcross(yV1,z));
#local zV1=vcross(xV1,yV1);
#local reponse=vnormalize(<p.x*xV1.x + p.y*yV1.x + p.z*zV1.x,p.x*xV1.y + p.y*yV1.y + p.z*zV1.y,p.x*xV1.z + p.y*yV1.z + p.z*zV1.z>);
reponse;
#end   


//--------------------------------
// tableau des branches
//--------------------------------
#macro tab_branche (level,lg_bch0,dec_lg_bch,rd_bch0,dec_rd_bch,angl_bch0,dec_angl_bch)
#declare lg_bch=array[level+1]
#declare rd_bch=array[level+1]
#declare angl_bch=array[level+1]
#local i=level;
#declare lg_bch[i]=lg_bch0;
#declare rd_bch[i]=rd_bch0;
#declare angl_bch[i]=angl_bch0;
#warning concat("level=",str(i,0,0)," lb=",str(lg_bch[i],0,3)," rb=",str(rd_bch[i],0,3),"\n")
#local i=level-1;  
#while (i>=0)
        #declare lg_bch[i]=lg_bch[i+1]*dec_lg_bch;// trouv un random  faire
        #declare rd_bch[i]=rd_bch[i+1]*dec_rd_bch;
        #declare angl_bch[i]=angl_bch[i+1]*dec_angl_bch;
#warning concat("level=",str(i,0,0)," lb=",str(lg_bch[i],0,3)," rb=",str(rd_bch[i],0,3),"\n")
        
#local i=i-1;
#end
#end                        
//---------------------------------
// Faire Arbre 
//---------------------------------
#macro arbre()
#declare xMax=pos0.x;
#declare yMax=pos0.y;
#declare zMax=pos0.z;
#declare xMin=pos0.x;
#declare yMin=pos0.y;
#declare zMin=pos0.z;


tab_branche  (level0,lg_bch0,dec_lg_bch,rd_bch0,dec_rd_bch,angl_bch0,dec_angl_bch)
union { fairebranche (level0,pos0,vect0)  texture {t_ecorce}}
#end
//------------------------------
// fin fichier Arbre
//----------------------------
// Feuille 
//-----------------------------
#macro FaireFeuille(lsize,seg,ll,wl,lpow,ndents)
union {
        sphere { <0,ll/0.5,0>0.6 pigment{rgb <Rand(),Rand(),Rand()>*1} 
                                 finish {ambient 0.3 diffuse 0.6 reflection 1 brilliance 3}
        }
        
mesh{
#local lseg=ll/seg;  // length of leaf segment
#local nI=3; 
#local nJ=seg+1;
#local nP=nI*nJ; #local P=array[nP] // array of leaf points
#local pl=<0,0,0>;   // start of leaf
#local j=0; 
#while (j<nJ)          
        #local tl=j/seg;
        #if (j>0) #local pl=pl+lseg*vaxis_rotate(z,x,pow(tl,apow)*al);#end
                #local P[j*nI]=pl-x*wl*(pow(sin(tl*pi),lpow)*(2+(pow(sin(tl*pi*ndents),2))))/3;
                #local P[j*nI+1]=pl-y*fl*sin(tl*pi);
                #local P[j*nI+2]=pl+x*wl*(pow(sin(tl*pi),lpow)*(2+(pow(sin(tl*pi*ndents),2))))/3;
        #local j=j+1;        
#end   
#local q=0;
#while (q<(nI*(nJ-1)-1))
#local i=mod(q,nI);#local j=(q-i)/nI;
        #if (i <nI-1) 
                triangle{P[q],P[q+1],P[q+nI+1]} triangle{P[q],P[q+nI],P[q+nI+1]} triangle{P[q],P[q+nI],P[q+nI+1]}
        #end
#local q=q+1;
#end       
 }
translate <0,-P[nP-1].y,-P[nP-1].z> // centers the leaf at origin
 }
#end   
//----------Fin Faire Feuille---------------
//-
