//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 9 materials and 62 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 30/12/1999    (30.12.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.
Philippe Peyralans
12/1999

*/ // End Scene Comment


// Scene Includes

#include "D:\JARDIN\fireweed.inc"
#include "D:\JARDIN\gilia.inc"
#include "D:\JARDIN\phlox.inc"
#include "D:\JARDIN\decplant.inc"
#include "D:\JARDIN\Sherbes.inc"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.686,0.820,1.000> }

fog {
  fog_type 2    // Ground Fog
  distance     2800.0
  color <0.6,0.705882,1.0,0.0,0.0>
  up           <0,0,1>
  fog_offset   60.0
  fog_alt      60.0
}

camera {  //  Camera observateur
  location  <      2.100,     -58.700,       2.600>
  direction <        0.0,         0.0,      2.1144> // Aperture is 0.46 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      9.000,      33.600,       2.900>
}

//
// *******  L I G H T S *******
//

light_source {   // L3
  <-0.500, 0.000, -1513.100>
  color rgb <1.000, 1.000, 1.000>
  shadowless
  media_interaction off
}

light_source {   // Spotlight soleil
  <-3045.000, 1604.000, 4660.000>
  color rgb <1.000, 1.000, 1.000>*2.0000
  spotlight
    point_at  <82.600, -12.787, -198.407>
    falloff    60.000  // outer radius (in deg)
    radius     60.000  // inner radius
    tightness  0.000
}

light_source {   // L2
  <9.800, -89.700, 14.400>
  color rgb <1.000, 1.000, 1.000>*0.8000
  shadowless
  media_interaction off
}


//
// ********  MATERIALS  *******
//

#include "chemineden.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare corps1 = union {
  sphere { // c04
    <0,0,0>,1
    scale <0.035, 0.145, 0.035>
    translate  0.4*y
  }
  sphere { // c05
    <0,0,0>,1
    scale <0.039, 0.1, 0.039>
    translate  0.54*y
  }
  sphere { // c06
    <0,0,0>,1
    scale <0.0162, 0.045, 0.0162>
    translate  0.63*y
  }
  sphere { // y3
    <0,0,0>,1
    scale 0.01
    translate  <0.013, 0.648, 0.005>
  }
  sphere { // y4
    <0,0,0>,1
    scale 0.01
    translate  <-0.013, 0.648, 0.005>
  }
  material {
    txcorps
  }
}
#declare papillonAF = union { // papillonAF
  object { corps1 }
  box { // aileg1
    <-1, -1, -1>, <1, 1, 1>
    material {
      txaile
    }
    scale <0.28, 0.5, 0.00002>
    rotate <-180.0, 56.0, -180.0>
    translate  <0.162166, 0.5, 0.260421>
  }
  box { // ailed1
    <-1, -1, -1>, <1, 1, 1>
    material {
      txaile
    }
    scale <0.28, 0.5, 0.00002>
    rotate 56.0*y
    translate  <-0.162166, 0.5, 0.260421>
  }
  scale 0.5
}
#declare corps = union {
  sphere { // c01
    <0,0,0>,1
    scale <0.035, 0.145, 0.035>
    translate  0.4*y
  }
  sphere { // c02
    <0,0,0>,1
    scale <0.039, 0.1, 0.039>
    translate  0.54*y
  }
  sphere { // c03
    <0,0,0>,1
    scale <0.0162, 0.045, 0.0162>
    translate  0.63*y
  }
  sphere { // y1
    <0,0,0>,1
    scale 0.01
    translate  <0.013, 0.648, 0.005>
  }
  sphere { // y2
    <0,0,0>,1
    scale 0.01
    translate  <-0.013, 0.648, 0.005>
  }
  material {
    txcorps
  }
}
#declare papillonAO = union { // papillonAO
  object { corps }
  box { // aileg
    <-1, -1, -1>, <1, 1, 1>
    material {
      txaile
    }
    scale <0.28, 0.5, 0.00002>
    rotate <-180.0, 26.0, -180.0>
    translate  <0.26065, 0.5, 0.147128>
  }
  box { // ailed
    <-1, -1, -1>, <1, 1, 1>
    material {
      txaile
    }
    scale <0.28, 0.5, 0.00002>
    rotate 26.0*y
    translate  <-0.26065, 0.5, 0.147128>
  }
  scale 0.5
}


//
// ********  OBJECTS  *******
//

object { // papillonAF1->papillonAF
  papillonAF
  rotate <9.0, -0.0, -9.0>
  translate  <2.0, -48.9, 0.4>
}


object { // papillonAF2->papillonAF
  papillonAF
  rotate <21.0, -0.0, -15.0>
  translate  <0.1, -48.3, 3.4>
}


object { // papillonAO1->papillonAO
  papillonAO
  rotate <8.0, 1.56, 24.5>
  translate  <2.6, -55.4, 2.5>
}


object { // papillonAO2->papillonAO
  papillonAO
  rotate <2.5, 0.0, -6.16>
  translate  <0.26, -49.2, 1.0>
}


object { // papillonAO3->papillonAO
  papillonAO
  rotate <36.0, 0.0, 16.0>
  translate  <4.5, -49.8, 4.2>
}


object {   // chemin
  height_field {
    tga "D:\jardin\chpave.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    paves
  }
  scale <52.0, 16.0, 3.0>
  rotate <-0.0, -0.0, 90.0>
  translate  <-1.240525, -5.092109, -4.227898>
}


union { // gi02
  object { // gilia6->gilia
    gilia
    scale 1.01
    rotate -98.0*z
    translate  -0.6*x
  }
  object { // gilia8->gilia
    gilia
    scale 0.95
    rotate 60.0*z
    translate  <0.6, -0.3, 0.0>
  }
  object { // gilia7->gilia
    gilia
    rotate -159.0*z
    translate  <-0.2, 0.6, 0.0>
  }
  translate  <13.8, -25.1, -1.161885>
}


union { // gi01
  object { // gilia1->gilia
    gilia
    scale 0.9
    rotate -137.0*z
    translate  <-0.1, 0.8, 0.0>
  }
  object { // gilia2->gilia
    gilia
    scale 1.01
    rotate -67.0*z
    translate  -1.0*x
  }
  object { // gilia3->gilia
    gilia
    scale 0.95
    rotate 79.0*z
    translate  <0.7, 0.6, 0.0>
  }
  object { // gilia4->gilia
    gilia
    scale 0.8
  }
  object { // gilia5->gilia
    gilia
    rotate <0.0, 0.0, 133.0>
    translate  1.1*y
  }
  translate  <-3.209462, -37.7, -2.156589>
}


union { // fi03
  object { // fireweed6->fireweed
    fireweed
    rotate <1.104208, -3.844809, 26.962934>
    translate  <-0.1, -0.15, 0.0>
  }
  object { // fireweed7->fireweed
    fireweed
    rotate <0.813749, -1.827029, 140.987015>
    translate  <1.47, 0.16, 0.0>
  }
  object { // fireweed8->fireweed
    fireweed
    rotate <0.517834, -1.931825, -105.008728>
    translate  <0.5, 1.3, 0.0>
  }
  translate  <9.945056, 23.10224, 0.0>
}


union { // fi02
  object { // fireweed4->fireweed
    fireweed
    rotate <-2.0, -3.0, 1.0>
  }
  object { // fireweed5->fireweed
    fireweed
    rotate <1.26, -1.55, 139.0>
    translate  <0.5, -0.4, 0.0>
  }
  translate  <-1.919476, -27.1541, -2.182044>
}


union { // fi01
  object { // fireweed1->fireweed
    fireweed
    rotate <1.0, -2.0, -0.03>
    translate  <-0.2, -0.3, 0.0>
  }
  object { // fireweed2->fireweed
    fireweed
    rotate <2.7, -2.4, -105.0>
    translate  <0.1, 0.4, 0.0>
  }
  object { // fireweed3->fireweed
    fireweed
    rotate <1.13, -1.92, 122.82>
    translate  <0.3, -0.3, 0.0>
  }
  translate  <5.1, -46.2, -1.8>
}


union { // fg02
  object { // phlox7->phlox
    phlox
    rotate <2.5, -1.4, 0.0>
    translate  <1.2, -20.3, -1.7>
  }
  object { // phlox8->phlox
    phlox
    rotate <-6.53, 7.55, -63.860001>
    translate  <2.4, -19.2, -1.8>
  }
  object { // phlox9->phlox
    phlox
    rotate <-5.76, -0.38, -43.34>
    translate  <-13.27, 15.01, 0.4>
  }
  object { // phlox10->phlox
    phlox
    rotate <15.76, 13.07, 39.060001>
    translate  <-12.54, 14.56, 0.33>
  }
  object { // phlox11->phlox
    phlox
    rotate <-2.9, -5.0, 114.379997>
    translate  <9.4, 10.15, -0.6>
  }
  object { // phlox12->phlox
    phlox
    rotate -174.0*z
    translate  <11.1, 10.2, -0.6>
  }
}


union { // fg01
  object { // phlox1->phlox
    phlox
    scale 0.9
    translate  <4.4, -50.6, -1.5>
  }
  object { // phlox2->phlox
    phlox
    scale 0.85
    rotate -5.0*y
    translate  <3.2, -51.7, -1.6>
  }
  object { // phlox3->phlox
    phlox
    scale 0.9
    rotate <-0.0, 3.0, -64.0>
    translate  <2.6, -21.2, -2.1>
  }
  object { // phlox5->phlox
    phlox
    scale 0.95
    translate  <2.1, -0.9, -1.9>
  }
  object { // phlox6->phlox
    phlox
    scale 0.9
    rotate <-1.606461, 15.19733, -62.499725>
    translate  <2.6, -2.4, -1.8>
  }
}








#declare cielext = difference {
  sphere { // cl1
    <0,0,0>,1
    material {
      ciel1
    }
    scale 3400.0
  }
  cylinder { // clm
    <0,0,1>, <0,0,0>, 1 
    material {
      ciel1
    }
    scale <50.0, 50.0, 800.0>
    translate  -3500.0*z
  }
}
#declare cielint = union {
  sphere { // cl2
    <0,0,0>,1
    material {
      ciel2
    }
    scale 3200.0
  }
  sphere { // cl3
    <0,0,0>,1
    material {
      halosoleil
    }
    scale 3000.0
    rotate <-0.0, 62.0, -27.0>
  }
}
difference { // ciel
  object { cielext }
  object { cielint }
  scale <2.5, 2.5, 2.0>
}


object {   // relieffond
  height_field {
    tga "D:\jardin\rffd.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    solfond
  }
  scale <2020.0, 1515.0, 45.0>
  rotate -120.0*z
  translate  <188.1, 956.8, -3.7>
}


