// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare txfirew_inter = material { texture { pigment { color rgb <0.19, 0.53, 0.19> }
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   

#declare txfirew_leaf = material { texture { pigment { color rgb <0.19, 0.78, 0.19> }
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   

#declare txfirew_inflor = material { texture { pigment { color rgb <0.19, 0.5, 0.19> }
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   

#declare txfirew_flower = material { texture { pigment { color rgb <0.75, 0.44, 0.8> }
finish { ambient 0.2  diffuse 0.5 roughness 0.001 } } } 

#declare txfirew_flowerb = material { texture { pigment { color rgb <0.75, 0.51, 0.8> }
finish { ambient 0.2  diffuse 0.5 roughness 0.001 } } }   

#declare txfirew_pedicel = material { texture { pigment { color rgb <0.19, 0.55, 0.19> }
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   

#declare txfirew_petiole = material { texture { pigment { color rgb <0.19, 0.39, 0.19> }
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   

#declare txfirew_fruit1 = material { texture { pigment { color rgb <0.8, 0.6, 0.77> }
finish { ambient 0.2  diffuse 0.55 roughness 0.001 } } }  

#declare txfirew_fruit2 = material { texture { pigment { color rgb <0.83, 0.5, 0.83> }
finish { ambient 0.2  diffuse 0.55 roughness 0.001 } } }   
                                           
                                              
#declare fireweed = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.2934, 5.5875, 0.08981>, 0.6872 }
		cylinder { <-0.2934, 5.5875, 0.08981>, <-0.6814, 11.1699, 0.08005>, 0.6872 }
		cylinder { <-0.6814, 11.1699, 0.08005>, <-1.1636, 16.744, -0.02926>, 0.6872 }
		material { txfirew_inter }}
	union { // internode
		cylinder { <-1.1636, 16.744, -0.02926>, <-1.6549, 22.4199, 0.1391>, 0.6999 }
		cylinder { <-1.6549, 22.4199, 0.1391>, <-2.1451, 28.08084, 0.5868>, 0.6999 }
		cylinder { <-2.1451, 28.08084, 0.5868>, <-2.6331, 33.7129, 1.3128>, 0.6999 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.6331, 33.7129, 1.3128>, <-2.7265, 34.7898, 1.5612>, 0.4864 }
			cylinder { <-2.7265, 34.7898, 1.5612>, <-2.8175, 35.8372, 1.9144>, 0.4864 }
			cylinder { <-2.8175, 35.8372, 1.9144>, <-2.9051, 36.845, 2.3689>, 0.4864 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-2.9051, 36.845, 2.3689>, <-5.6192, 73.05659, 12.8855>, <-8.1912, 72.4398, 16.1929> }
			triangle { <-5.6192, 73.05659, 12.8855>, <-6.2666, 91.9849, 21.9369>, <-8.1912, 72.4398, 16.1929> }
			triangle { <-6.2666, 91.9849, 21.9369>, <-9.2276, 91.2121, 25.515>, <-8.1912, 72.4398, 16.1929> }
			triangle { <-6.2666, 91.9849, 21.9369>, <-11.3631, 117.9922, 38.7895>, <-9.2276, 91.2121, 25.515> }
			triangle { <-9.2276, 91.2121, 25.515>, <-11.3631, 117.9922, 38.7895>, <-13.2709, 89.1776, 26.8113> }
			triangle { <-8.1912, 72.4398, 16.1929>, <-9.2276, 91.2121, 25.515>, <-13.2709, 89.1776, 26.8113> }
			triangle { <-8.1912, 72.4398, 16.1929>, <-13.2709, 89.1776, 26.8113>, <-11.5354, 70.4231, 17.5843> }
			triangle { <-8.1912, 72.4398, 16.1929>, <-11.5354, 70.4231, 17.5843>, <-2.9051, 36.845, 2.3689> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-2.6331, 33.7129, 1.3128>, <-3.02595, 39.3645, 1.9382>, 0.6999 }
		cylinder { <-3.02595, 39.3645, 1.9382>, <-3.3232, 45.03228, 2.4627>, 0.6999 }
		cylinder { <-3.3232, 45.03228, 2.4627>, <-3.5249, 50.7126, 2.8858>, 0.6999 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.5249, 50.7126, 2.8858>, <-3.4897, 51.8188, 2.8889>, 0.4854 }
			cylinder { <-3.4897, 51.8188, 2.8889>, <-3.3804, 52.9175, 2.8129>, 0.4854 }
			cylinder { <-3.3804, 52.9175, 2.8129>, <-3.198, 53.9982, 2.6586>, 0.4854 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-3.198, 53.9982, 2.6586>, <-0.8645, 91.6134, 0.9329>, <3.309, 91.8402, 0.3083> }
			triangle { <-0.8645, 91.6134, 0.9329>, <2.1926, 111.9556, -3.02426>, <3.309, 91.8402, 0.3083> }
			triangle { <2.1926, 111.9556, -3.02426>, <6.8548, 112.1087, -3.5872>, <3.309, 91.8402, 0.3083> }
			triangle { <2.1926, 111.9556, -3.02426>, <12.3662, 141.0571, -8.6714>, <6.8548, 112.1087, -3.5872> }
			triangle { <6.8548, 112.1087, -3.5872>, <12.3662, 141.0571, -8.6714>, <10.9893, 110.6298, -1.9152> }
			triangle { <3.309, 91.8402, 0.3083>, <6.8548, 112.1087, -3.5872>, <10.9893, 110.6298, -1.9152> }
			triangle { <3.309, 91.8402, 0.3083>, <10.9893, 110.6298, -1.9152>, <7.00466, 90.3567, 1.4294> }
			triangle { <3.309, 91.8402, 0.3083>, <7.00466, 90.3567, 1.4294>, <-3.198, 53.9982, 2.6586> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-3.5249, 50.7126, 2.8858>, <-3.8661, 56.3857, 3.3162>, 0.7 }
		cylinder { <-3.8661, 56.3857, 3.3162>, <-4.3467, 62.04827, 3.7537>, 0.7 }
		cylinder { <-4.3467, 62.04827, 3.7537>, <-4.9662, 67.6967, 4.1979>, 0.7 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.9662, 67.6967, 4.1979>, <-5.194, 68.7783, 4.2891>, 0.4864 }
			cylinder { <-5.194, 68.7783, 4.2891>, <-5.527, 69.8319, 4.3841>, 0.4864 }
			cylinder { <-5.527, 69.8319, 4.3841>, <-5.9619, 70.8474, 4.4821>, 0.4864 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-5.9619, 70.8474, 4.4821>, <-15.7601, 107.1817, 8.09507>, <-19.2174, 107.0268, 5.6543> }
			triangle { <-15.7601, 107.1817, 8.09507>, <-24.3872, 126.1039, 10.9501>, <-19.2174, 107.0268, 5.6543> }
			triangle { <-24.3872, 126.1039, 10.9501>, <-28.1399, 125.8604, 8.117>, <-19.2174, 107.0268, 5.6543> }
			triangle { <-24.3872, 126.1039, 10.9501>, <-40.8804, 152.8311, 10.9812>, <-28.1399, 125.8604, 8.117> }
			triangle { <-28.1399, 125.8604, 8.117>, <-40.8804, 152.8311, 10.9812>, <-29.7038, 124.5088, 3.8867> }
			triangle { <-19.2174, 107.0268, 5.6543>, <-28.1399, 125.8604, 8.117>, <-29.7038, 124.5088, 3.8867> }
			triangle { <-19.2174, 107.0268, 5.6543>, <-29.7038, 124.5088, 3.8867>, <-20.8375, 105.5839, 2.1216> }
			triangle { <-19.2174, 107.0268, 5.6543>, <-20.8375, 105.5839, 2.1216>, <-5.9619, 70.8474, 4.4821> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-4.9662, 67.6967, 4.1979>, <-5.2665, 73.3431, 4.9144>, 0.7 }
		cylinder { <-5.2665, 73.3431, 4.9144>, <-5.246, 78.957, 5.8993>, 0.7 }
		cylinder { <-5.246, 78.957, 5.8993>, <-4.9047, 84.5079, 7.1474>, 0.7 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.9047, 84.5079, 7.1474>, <-4.7569, 85.5543, 7.4539>, 0.4826 }
			cylinder { <-4.7569, 85.5543, 7.4539>, <-4.5285, 86.5655, 7.8232>, 0.4826 }
			cylinder { <-4.5285, 86.5655, 7.8232>, <-4.2218, 87.5315, 8.2516>, 0.4826 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-4.2218, 87.5315, 8.2516>, <2.6637, 122.6095, 19.6144>, <3.5189, 121.6882, 23.6238> }
			triangle { <2.6637, 122.6095, 19.6144>, <9.4527, 140.766, 27.2315>, <3.5189, 121.6882, 23.6238> }
			triangle { <9.4527, 140.766, 27.2315>, <10.262, 139.657, 31.6968>, <3.5189, 121.6882, 23.6238> }
			triangle { <9.4527, 140.766, 27.2315>, <19.4433, 165.2635, 43.696>, <10.262, 139.657, 31.6968> }
			triangle { <10.262, 139.657, 31.6968>, <19.4433, 165.2635, 43.696>, <8.6258, 137.389, 35.4388> }
			triangle { <3.5189, 121.6882, 23.6238>, <10.262, 139.657, 31.6968>, <8.6258, 137.389, 35.4388> }
			triangle { <3.5189, 121.6882, 23.6238>, <8.6258, 137.389, 35.4388>, <2.402, 119.4628, 26.8978> }
			triangle { <3.5189, 121.6882, 23.6238>, <2.402, 119.4628, 26.8978>, <-4.2218, 87.5315, 8.2516> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-4.9047, 84.5079, 7.1474>, <-4.5941, 90.1148, 8.123>, 0.7 }
		cylinder { <-4.5941, 90.1148, 8.123>, <-4.3151, 95.7643, 8.824>, 0.7 }
		cylinder { <-4.3151, 95.7643, 8.824>, <-4.06819, 101.4428, 9.2485>, 0.7 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.06819, 101.4428, 9.2485>, <-4.03298, 102.5511, 9.2231>, 0.4864 }
			cylinder { <-4.03298, 102.5511, 9.2231>, <-4.01095, 103.6519, 9.08996>, 0.4864 }
			cylinder { <-4.01095, 103.6519, 9.08996>, <-4.002321, 104.7347, 8.8502>, 0.4864 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-4.002321, 104.7347, 8.8502>, <-3.4817, 142.4239, 5.9358>, <-1.2747, 142.6298, 2.3274> }
			triangle { <-3.4817, 142.4239, 5.9358>, <-4.3686, 162.8156, 1.03507>, <-1.2747, 142.6298, 2.3274> }
			triangle { <-4.3686, 162.8156, 1.03507>, <-1.8005, 162.9444, -2.9091>, <-1.2747, 142.6298, 2.3274> }
			triangle { <-4.3686, 162.8156, 1.03507>, <-1.8954, 191.9526, -10.423>, <-1.8005, 162.9444, -2.9091> }
			triangle { <-1.8005, 162.9444, -2.9091>, <-1.8954, 191.9526, -10.423>, <2.1301, 161.4257, -5.009513> }
			triangle { <-1.2747, 142.6298, 2.3274>, <-1.8005, 162.9444, -2.9091>, <2.1301, 161.4257, -5.009513> }
			triangle { <-1.2747, 142.6298, 2.3274>, <2.1301, 161.4257, -5.009513>, <1.9504, 141.113, 0.2097> }
			triangle { <-1.2747, 142.6298, 2.3274>, <1.9504, 141.113, 0.2097>, <-4.002321, 104.7347, 8.8502> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-4.06819, 101.4428, 9.2485>, <-3.9052, 107.1149, 9.7847>, 0.7 }
		cylinder { <-3.9052, 107.1149, 9.7847>, <-3.8265, 112.7771, 10.4323>, 0.7 }
		cylinder { <-3.8265, 112.7771, 10.4323>, <-3.8319, 118.4261, 11.1908>, 0.7 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.8319, 118.4261, 11.1908>, <-3.8981, 119.5041, 11.4228>, 0.4845 }
			cylinder { <-3.8981, 119.5041, 11.4228>, <-4.02886, 120.5549, 11.7375>, 0.4845 }
			cylinder { <-4.02886, 120.5549, 11.7375>, <-4.2228, 121.5683, 12.132>, 0.4845 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-4.2228, 121.5683, 12.132>, <-7.3977, 157.7924, 21.914>, <-11.4736, 157.6757, 22.9936> }
			triangle { <-7.3977, 157.7924, 21.914>, <-10.5612, 176.672, 30.3223>, <-11.4736, 157.6757, 22.9936> }
			triangle { <-10.5612, 176.672, 30.3223>, <-15.1265, 176.4716, 31.3766>, <-11.4736, 157.6757, 22.9936> }
			triangle { <-10.5612, 176.672, 30.3223>, <-20.8399, 203.3926, 42.9295>, <-15.1265, 176.4716, 31.3766> }
			triangle { <-15.1265, 176.4716, 31.3766>, <-20.8399, 203.3926, 42.9295>, <-19.3693, 175.1637, 29.8662> }
			triangle { <-11.4736, 157.6757, 22.9936>, <-15.1265, 176.4716, 31.3766>, <-19.3693, 175.1637, 29.8662> }
			triangle { <-11.4736, 157.6757, 22.9936>, <-19.3693, 175.1637, 29.8662>, <-15.2204, 156.2724, 21.9722> }
			triangle { <-11.4736, 157.6757, 22.9936>, <-15.2204, 156.2724, 21.9722>, <-4.2228, 121.5683, 12.132> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-3.8319, 118.4261, 11.1908>, <-3.4236, 124.0692, 11.8793>, 0.7 }
		cylinder { <-3.4236, 124.0692, 11.8793>, <-2.6039, 129.676, 12.4942>, 0.7 }
		cylinder { <-2.6039, 129.676, 12.4942>, <-1.3772, 135.2161, 13.03215>, 0.7 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.3772, 135.2161, 13.03215>, <-1.03507, 136.2675, 13.1159>, 0.4863 }
			cylinder { <-1.03507, 136.2675, 13.1159>, <-0.5927, 137.2825, 13.1781>, 0.4863 }
			cylinder { <-0.5927, 137.2825, 13.1781>, <-0.0544, 138.2511, 13.218>, 0.4863 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-0.0544, 138.2511, 13.218>, <13.5026, 173.4779, 15.2385>, <17.1449, 172.5166, 17.1719> }
			triangle { <13.5026, 173.4779, 15.2385>, <23.9471, 191.6796, 14.9155>, <17.1449, 172.5166, 17.1719> }
			triangle { <23.9471, 191.6796, 14.9155>, <27.9102, 190.5264, 17.1794>, <17.1449, 172.5166, 17.1719> }
			triangle { <23.9471, 191.6796, 14.9155>, <43.3566, 216.1904, 17.8408>, <27.9102, 190.5264, 17.1794> }
			triangle { <27.9102, 190.5264, 17.1794>, <43.3566, 216.1904, 17.8408>, <29.7218, 188.2253, 20.8651> }
			triangle { <17.1449, 172.5166, 17.1719>, <27.9102, 190.5264, 17.1794>, <29.7218, 188.2253, 20.8651> }
			triangle { <17.1449, 172.5166, 17.1719>, <29.7218, 188.2253, 20.8651>, <18.9313, 170.2585, 20.1537> }
			triangle { <17.1449, 172.5166, 17.1719>, <18.9313, 170.2585, 20.1537>, <-0.0544, 138.2511, 13.218> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-1.3772, 135.2161, 13.03215>, <-0.7248, 140.8761, 13.1901>, 0.7 }
		cylinder { <-0.7248, 140.8761, 13.1901>, <-0.6567, 146.5709, 12.9658>, 0.7 }
		cylinder { <-0.6567, 146.5709, 12.9658>, <-1.1737, 152.2149, 12.3626>, 0.7 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.1737, 152.2149, 12.3626>, <-1.3638, 153.2898, 12.188>, 0.4848 }
			cylinder { <-1.3638, 153.2898, 12.188>, <-1.6418, 154.3346, 11.9575>, 0.4848 }
			cylinder { <-1.6418, 154.3346, 11.9575>, <-2.005193, 155.3393, 11.6734>, 0.4848 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-2.005193, 155.3393, 11.6734>, <-10.4364, 191.4518, 4.9849>, <-11.7869, 190.9365, 1.01915> }
			triangle { <-10.4364, 191.4518, 4.9849>, <-18.2322, 210.2697, 0.2026>, <-11.7869, 190.9365, 1.01915> }
			triangle { <-18.2322, 210.2697, 0.2026>, <-19.5932, 209.6155, -4.2407>, <-11.7869, 190.9365, 1.01915> }
			triangle { <-18.2322, 210.2697, 0.2026>, <-30.3531, 236.2932, -12.2797>, <-19.5932, 209.6155, -4.2407> }
			triangle { <-19.5932, 209.6155, -4.2407>, <-30.3531, 236.2932, -12.2797>, <-18.4214, 207.77, -8.3934> }
			triangle { <-11.7869, 190.9365, 1.01915>, <-19.5932, 209.6155, -4.2407>, <-18.4214, 207.77, -8.3934> }
			triangle { <-11.7869, 190.9365, 1.01915>, <-18.4214, 207.77, -8.3934>, <-11.07432, 189.0756, -2.6008> }
			triangle { <-11.7869, 190.9365, 1.01915>, <-11.07432, 189.0756, -2.6008>, <-2.005193, 155.3393, 11.6734> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-1.1737, 152.2149, 12.3626>, <-1.6265, 157.8869, 12.03026>, 0.7 }
		cylinder { <-1.6265, 157.8869, 12.03026>, <-2.01414, 163.573, 11.9695>, 0.7 }
		cylinder { <-2.01414, 163.573, 11.9695>, <-2.3354, 169.2597, 12.1806>, 0.7 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.3354, 169.2597, 12.1806>, <-2.3718, 170.3584, 12.3271>, 0.4864 }
			cylinder { <-2.3718, 170.3584, 12.3271>, <-2.3816, 171.4388, 12.5774>, 0.4864 }
			cylinder { <-2.3816, 171.4388, 12.5774>, <-2.3647, 172.4904, 12.9293>, 0.4864 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-2.3647, 172.4904, 12.9293>, <-2.6736, 209.6558, 19.8486>, <-4.4145, 209.4465, 23.7034> }
			triangle { <-2.6736, 209.6558, 19.8486>, <-1.2669, 229.4378, 26.7277>, <-4.4145, 209.4465, 23.7034> }
			triangle { <-1.2669, 229.4378, 26.7277>, <-3.3239, 229.1104, 30.9503>, <-4.4145, 209.4465, 23.7034> }
			triangle { <-1.2669, 229.4378, 26.7277>, <-2.4131, 257.1746, 41.4154>, <-3.3239, 229.1104, 30.9503> }
			triangle { <-3.3239, 229.1104, 30.9503>, <-2.4131, 257.1746, 41.4154>, <-6.9559, 227.3136, 33.3478> }
			triangle { <-4.4145, 209.4465, 23.7034>, <-3.3239, 229.1104, 30.9503>, <-6.9559, 227.3136, 33.3478> }
			triangle { <-4.4145, 209.4465, 23.7034>, <-6.9559, 227.3136, 33.3478>, <-7.3443, 207.6618, 26.0311> }
			triangle { <-4.4145, 209.4465, 23.7034>, <-7.3443, 207.6618, 26.0311>, <-2.3647, 172.4904, 12.9293> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-2.3354, 169.2597, 12.1806>, <-2.5176, 174.9563, 12.1492>, 0.7 }
		cylinder { <-2.5176, 174.9563, 12.1492>, <-2.5603, 180.6492, 11.8754>, 0.7 }
		cylinder { <-2.5603, 180.6492, 11.8754>, <-2.4633, 186.3247, 11.3598>, 0.7 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.4633, 186.3247, 11.3598>, <-2.3907, 187.4078, 11.1674>, 0.4835 }
			cylinder { <-2.3907, 187.4078, 11.1674>, <-2.2649, 188.4658, 10.8842>, 0.4835 }
			cylinder { <-2.2649, 188.4658, 10.8842>, <-2.08734, 189.4885, 10.5128>, 0.4835 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-2.08734, 189.4885, 10.5128>, <1.05593, 225.9478, 1.9665>, <4.9595, 225.7708, 0.401> }
			triangle { <1.05593, 225.9478, 1.9665>, <3.793, 245.06, -5.9459>, <4.9595, 225.7708, 0.401> }
			triangle { <3.793, 245.06, -5.9459>, <8.1815, 244.7852, -7.5489>, <4.9595, 225.7708, 0.401> }
			triangle { <3.793, 245.06, -5.9459>, <13.3274, 271.9855, -18.5445>, <8.1815, 244.7852, -7.5489> }
			triangle { <8.1815, 244.7852, -7.5489>, <13.3274, 271.9855, -18.5445>, <12.5213, 243.2987, -6.621> }
			triangle { <4.9595, 225.7708, 0.401>, <8.1815, 244.7852, -7.5489>, <12.5213, 243.2987, -6.621> }
			triangle { <4.9595, 225.7708, 0.401>, <12.5213, 243.2987, -6.621>, <8.7466, 224.2249, 0.9008> }
			triangle { <4.9595, 225.7708, 0.401>, <8.7466, 224.2249, 0.9008>, <-2.08734, 189.4885, 10.5128> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-2.4633, 186.3247, 11.3598>, <-2.6345, 192.0051, 10.9234>, 0.7 }
		cylinder { <-2.6345, 192.0051, 10.9234>, <-3.07368, 197.6766, 10.5672>, 0.7 }
		cylinder { <-3.07368, 197.6766, 10.5672>, <-3.7796, 203.3257, 10.2921>, 0.7 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.7796, 203.3257, 10.2921>, <-4.0149, 204.3867, 10.2709>, 0.4767 }
			cylinder { <-4.0149, 204.3867, 10.2709>, <-4.3486, 205.4212, 10.2812>, 0.4767 }
			cylinder { <-4.3486, 205.4212, 10.2812>, <-4.7775, 206.4191, 10.3228>, 0.4767 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-4.7775, 206.4191, 10.3228>, <-14.6038, 242.1441, 10.6122>, <-18.4398, 241.6235, 9.1152> }
			triangle { <-14.6038, 242.1441, 10.6122>, <-22.8655, 260.8933, 12.4759>, <-18.4398, 241.6235, 9.1152> }
			triangle { <-22.8655, 260.8933, 12.4759>, <-27.06763, 260.2275, 10.6888>, <-18.4398, 241.6235, 9.1152> }
			triangle { <-22.8655, 260.8933, 12.4759>, <-39.5355, 286.7697, 12.3094>, <-27.06763, 260.2275, 10.6888> }
			triangle { <-27.06763, 260.2275, 10.6888>, <-39.5355, 286.7697, 12.3094>, <-29.4544, 258.2795, 7.2532> }
			triangle { <-18.4398, 241.6235, 9.1152>, <-27.06763, 260.2275, 10.6888>, <-29.4544, 258.2795, 7.2532> }
			triangle { <-18.4398, 241.6235, 9.1152>, <-29.4544, 258.2795, 7.2532>, <-20.7214, 239.6921, 6.3631> }
			triangle { <-18.4398, 241.6235, 9.1152>, <-20.7214, 239.6921, 6.3631>, <-4.7775, 206.4191, 10.3228> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-3.7796, 203.3257, 10.2921>, <-4.4855, 208.9748, 10.01703>, 0.6999 }
		cylinder { <-4.4855, 208.9748, 10.01703>, <-5.1914, 214.6238, 9.7419>, 0.6999 }
		cylinder { <-5.1914, 214.6238, 9.7419>, <-5.8973, 220.2729, 9.4667>, 0.6999 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.8973, 220.2729, 9.4667>, <-5.9373, 221.3649, 9.4622>, 0.4793 }
			cylinder { <-5.9373, 221.3649, 9.4622>, <-5.8815, 222.4554, 9.506>, 0.4793 }
			cylinder { <-5.8815, 222.4554, 9.506>, <-5.7306, 223.5338, 9.5976>, 0.4793 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-5.7306, 223.5338, 9.5976>, <-5.0418, 260.7744, 10.00769>, <-3.3015, 261.2072, 13.7752> }
			triangle { <-5.0418, 260.7744, 10.00769>, <-1.3085, 281.0886, 11.08423>, <-3.3015, 261.2072, 13.7752> }
			triangle { <-1.3085, 281.0886, 11.08423>, <0.5122, 281.4692, 15.334>, <-3.3015, 261.2072, 13.7752> }
			triangle { <-1.3085, 281.0886, 11.08423>, <5.6291, 310.4138, 18.1175>, <0.5122, 281.4692, 15.334> }
			triangle { <0.5122, 281.4692, 15.334>, <5.6291, 310.4138, 18.1175>, <0.1398, 280.1481, 19.7654> }
			triangle { <-3.3015, 261.2072, 13.7752>, <0.5122, 281.4692, 15.334>, <0.1398, 280.1481, 19.7654> }
			triangle { <-3.3015, 261.2072, 13.7752>, <0.1398, 280.1481, 19.7654>, <-3.2739, 259.8785, 17.6377> }
			triangle { <-3.3015, 261.2072, 13.7752>, <-3.2739, 259.8785, 17.6377>, <-5.7306, 223.5338, 9.5976> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-5.8973, 220.2729, 9.4667>, <-6.6018, 225.9102, 9.1922>, 0.6985 }
		cylinder { <-6.6018, 225.9102, 9.1922>, <-7.3062, 231.5476, 8.9176>, 0.6985 }
		cylinder { <-7.3062, 231.5476, 8.9176>, <-8.01069, 237.1849, 8.6431>, 0.6985 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.01069, 237.1849, 8.6431>, <-8.1757, 238.2222, 8.4944>, 0.4652 }
			cylinder { <-8.1757, 238.2222, 8.4944>, <-8.3728, 239.2354, 8.2496>, 0.4652 }
			cylinder { <-8.3728, 239.2354, 8.2496>, <-8.6001, 240.2147, 7.9111>, 0.4652 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-8.6001, 240.2147, 7.9111>, <-15.239, 275.1021, 1.1048>, <-13.9556, 275.1063, -2.7369> }
			triangle { <-15.239, 275.1021, 1.1048>, <-20.5604, 293.3367, -5.3981>, <-13.9556, 275.1063, -2.7369> }
			triangle { <-20.5604, 293.3367, -5.3981>, <-18.9976, 293.274, -9.6212>, <-13.9556, 275.1063, -2.7369> }
			triangle { <-20.5604, 293.3367, -5.3981>, <-25.6013, 319.3073, -19.6283>, <-18.9976, 293.274, -9.6212> }
			triangle { <-18.9976, 293.274, -9.6212>, <-25.6013, 319.3073, -19.6283>, <-15.5324, 292.1317, -12.2609> }
			triangle { <-13.9556, 275.1063, -2.7369>, <-18.9976, 293.274, -9.6212>, <-15.5324, 292.1317, -12.2609> }
			triangle { <-13.9556, 275.1063, -2.7369>, <-15.5324, 292.1317, -12.2609>, <-11.143, 273.8601, -5.2389> }
			triangle { <-13.9556, 275.1063, -2.7369>, <-11.143, 273.8601, -5.2389>, <-8.6001, 240.2147, 7.9111> }
			material { txfirew_leaf }}
		}
	union { // internode
		cylinder { <-8.01069, 237.1849, 8.6431>, <-8.673, 241.748, 8.6275>, 0.5662 }
		cylinder { <-8.673, 241.748, 8.6275>, <-9.4251, 246.2931, 8.8189>, 0.5662 }
		cylinder { <-9.4251, 246.2931, 8.8189>, <-10.265, 250.8094, 9.2168>, 0.5662 }
		material { txfirew_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.265, 250.8094, 9.2168>, <-10.3632, 251.2402, 9.2955>, 0.1968 }
			cylinder { <-10.3632, 251.2402, 9.2955>, <-10.477, 251.658, 9.4132>, 0.1968 }
			cylinder { <-10.477, 251.658, 9.4132>, <-10.6053, 252.0589, 9.5689>, 0.1968 }
			material { txfirew_petiole }}
		mesh { // leaf
			triangle { <-10.6053, 252.0589, 9.5689>, <-14.1041, 266.5313, 13.08315>, <-15.5812, 266.1991, 13.8859> }
			triangle { <-14.1041, 266.5313, 13.08315>, <-16.2277, 274.0741, 16.3618>, <-15.5812, 266.1991, 13.8859> }
			triangle { <-16.2277, 274.0741, 16.3618>, <-17.8895, 273.6687, 17.201>, <-15.5812, 266.1991, 13.8859> }
			triangle { <-16.2277, 274.0741, 16.3618>, <-21.4213, 284.3124, 21.8137>, <-17.8895, 273.6687, 17.201> }
			triangle { <-17.8895, 273.6687, 17.201>, <-21.4213, 284.3124, 21.8137>, <-19.5519, 272.7564, 17.01631> }
			triangle { <-15.5812, 266.1991, 13.8859>, <-17.8895, 273.6687, 17.201>, <-19.5519, 272.7564, 17.01631> }
			triangle { <-15.5812, 266.1991, 13.8859>, <-19.5519, 272.7564, 17.01631>, <-17.00119, 265.3063, 13.8508> }
			triangle { <-15.5812, 266.1991, 13.8859>, <-17.00119, 265.3063, 13.8508>, <-10.6053, 252.0589, 9.5689> }
			material { txfirew_leaf }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-10.265, 250.8094, 9.2168>, <-11.3032, 256.392, 9.7088>, 0.3 }
			cylinder { <-11.3032, 256.392, 9.7088>, <-12.3415, 261.9747, 10.2007>, 0.3 }
			cylinder { <-12.3415, 261.9747, 10.2007>, <-13.3797, 267.5574, 10.6926>, 0.3 }
			material { txfirew_inflor }}
		union { // inflor. internode
			cylinder { <-13.3797, 267.5574, 10.6926>, <-13.7951, 269.7904, 10.8894>, 0.3 }
			cylinder { <-13.7951, 269.7904, 10.8894>, <-14.2104, 272.0235, 11.08621>, 0.3 }
			cylinder { <-14.2104, 272.0235, 11.08621>, <-14.6257, 274.2566, 11.2829>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-14.6257, 274.2566, 11.2829>, <-20.3755, 289.1407, 11.589>, 0.3 }
				cylinder { <-20.3755, 289.1407, 11.589>, <-28.7472, 302.7054, 10.812>, 0.3 }
				cylinder { <-28.7472, 302.7054, 10.812>, <-39.419, 314.4295, 8.9817>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-39.419, 314.4295, 8.9817>, <-54.4066, 335.5304, 7.8933>, <-55.5255, 335.0323, 5.2627> }
					triangle { <-54.4066, 335.5304, 7.8933>, <-64.499, 345.7093, 6.702>, <-55.5255, 335.0323, 5.2627> }
					triangle { <-64.499, 345.7093, 6.702>, <-65.6372, 345.1414, 3.7371>, <-55.5255, 335.0323, 5.2627> }
					triangle { <-64.499, 345.7093, 6.702>, <-79.8845, 359.7029, 1.1713>, <-65.6372, 345.1414, 3.7371> }
					triangle { <-65.6372, 345.1414, 3.7371>, <-79.8845, 359.7029, 1.1713>, <-64.8465, 344.4538, 0.6858> }
					triangle { <-55.5255, 335.0323, 5.2627>, <-65.6372, 345.1414, 3.7371>, <-64.8465, 344.4538, 0.6858> }
					triangle { <-55.5255, 335.0323, 5.2627>, <-64.8465, 344.4538, 0.6858>, <-54.9691, 334.1931, 2.6064> }
					triangle { <-55.5255, 335.0323, 5.2627>, <-54.9691, 334.1931, 2.6064>, <-39.419, 314.4295, 8.9817> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-39.419, 314.4295, 8.9817>, <-56.2266, 333.0209, 2.43>, <-58.08918, 332.5976, 4.6145> }
					triangle { <-56.2266, 333.0209, 2.43>, <-65.3366, 344.0703, 1.08678>, <-58.08918, 332.5976, 4.6145> }
					triangle { <-65.3366, 344.0703, 1.08678>, <-67.4102, 343.4888, 3.4889>, <-58.08918, 332.5976, 4.6145> }
					triangle { <-65.3366, 344.0703, 1.08678>, <-81.05868, 358.744, 1.8751>, <-67.4102, 343.4888, 3.4889> }
					triangle { <-67.4102, 343.4888, 3.4889>, <-81.05868, 358.744, 1.8751>, <-69.1362, 341.2234, 5.004745> }
					triangle { <-58.08918, 332.5976, 4.6145>, <-67.4102, 343.4888, 3.4889>, <-69.1362, 341.2234, 5.004745> }
					triangle { <-58.08918, 332.5976, 4.6145>, <-69.1362, 341.2234, 5.004745>, <-59.4622, 330.6601, 6.1734> }
					triangle { <-58.08918, 332.5976, 4.6145>, <-59.4622, 330.6601, 6.1734>, <-39.419, 314.4295, 8.9817> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-39.419, 314.4295, 8.9817>, <-59.04634, 331.2964, 7.8239>, <-57.4464, 333.7109, 7.9984> }
					triangle { <-59.04634, 331.2964, 7.8239>, <-68.6647, 341.7179, 5.4232>, <-57.4464, 333.7109, 7.9984> }
					triangle { <-68.6647, 341.7179, 5.4232>, <-66.8346, 344.3594, 5.7096>, <-57.4464, 333.7109, 7.9984> }
					triangle { <-68.6647, 341.7179, 5.4232>, <-80.109, 359.7569, 2.8267>, <-66.8346, 344.3594, 5.7096> }
					triangle { <-66.8346, 344.3594, 5.7096>, <-80.109, 359.7569, 2.8267>, <-64.5226, 345.8024, 7.436> }
					triangle { <-57.4464, 333.7109, 7.9984>, <-66.8346, 344.3594, 5.7096>, <-64.5226, 345.8024, 7.436> }
					triangle { <-57.4464, 333.7109, 7.9984>, <-64.5226, 345.8024, 7.436>, <-55.2563, 334.9754, 9.2922> }
					triangle { <-57.4464, 333.7109, 7.9984>, <-55.2563, 334.9754, 9.2922>, <-39.419, 314.4295, 8.9817> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-14.6257, 274.2566, 11.2829>, <-15.041, 276.4896, 11.4797>, 0.3 }
			cylinder { <-15.041, 276.4896, 11.4797>, <-15.4563, 278.7227, 11.6765>, 0.3 }
			cylinder { <-15.4563, 278.7227, 11.6765>, <-15.8716, 280.9557, 11.8732>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-15.8716, 280.9557, 11.8732>, <-17.2364, 296.3223, 15.9597>, 0.3 }
				cylinder { <-17.2364, 296.3223, 15.9597>, <-17.00667, 310.8333, 22.5981>, 0.3 }
				cylinder { <-17.00667, 310.8333, 22.5981>, <-15.191, 323.9312, 31.5335>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-15.191, 323.9312, 31.5335>, <-13.4356, 346.7678, 42.9858>, <-14.1379, 345.8888, 45.6245> }
					triangle { <-13.4356, 346.7678, 42.9858>, <-11.07098, 358.3214, 50.9285>, <-14.1379, 345.8888, 45.6245> }
					triangle { <-11.07098, 358.3214, 50.9285>, <-11.943, 357.2942, 53.819>, <-14.1379, 345.8888, 45.6245> }
					triangle { <-11.07098, 358.3214, 50.9285>, <-9.2257, 373.5452, 65.6725>, <-11.943, 357.2942, 53.819> }
					triangle { <-11.943, 357.2942, 53.819>, <-9.2257, 373.5452, 65.6725>, <-14.128, 355.6521, 55.4624> }
					triangle { <-14.1379, 345.8888, 45.6245>, <-11.943, 357.2942, 53.819>, <-14.128, 355.6521, 55.4624> }
					triangle { <-14.1379, 345.8888, 45.6245>, <-14.128, 355.6521, 55.4624>, <-15.8632, 344.2713, 47.1385> }
					triangle { <-14.1379, 345.8888, 45.6245>, <-15.8632, 344.2713, 47.1385>, <-15.191, 323.9312, 31.5335> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-15.191, 323.9312, 31.5335>, <-14.6968, 343.4616, 48.08846>, <-11.9234, 344.1199, 47.7674> }
					triangle { <-14.6968, 343.4616, 48.08846>, <-13.4074, 355.529, 55.4964>, <-11.9234, 344.1199, 47.7674> }
					triangle { <-13.4074, 355.529, 55.4964>, <-10.2981, 356.1528, 55.1579>, <-11.9234, 344.1199, 47.7674> }
					triangle { <-13.4074, 355.529, 55.4964>, <-7.6448, 373.1451, 65.9377>, <-10.2981, 356.1528, 55.1579> }
					triangle { <-10.2981, 356.1528, 55.1579>, <-7.6448, 373.1451, 65.9377>, <-7.3625, 354.9067, 55.1804> }
					triangle { <-11.9234, 344.1199, 47.7674>, <-10.2981, 356.1528, 55.1579>, <-7.3625, 354.9067, 55.1804> }
					triangle { <-11.9234, 344.1199, 47.7674>, <-7.3625, 354.9067, 55.1804>, <-9.3186, 343.0984, 47.528> }
					triangle { <-11.9234, 344.1199, 47.7674>, <-9.3186, 343.0984, 47.528>, <-15.191, 323.9312, 31.5335> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-15.191, 323.9312, 31.5335>, <-8.8029, 344.0187, 46.07423>, <-10.6544, 345.8836, 44.9243> }
					triangle { <-8.8029, 344.0187, 46.07423>, <-7.6003, 355.3547, 54.572>, <-10.6544, 345.8836, 44.9243> }
					triangle { <-7.6003, 355.3547, 54.572>, <-9.6202, 357.4004, 53.1914>, <-10.6544, 345.8836, 44.9243> }
					triangle { <-7.6003, 355.3547, 54.572>, <-8.06218, 374.0919, 64.6347>, <-9.6202, 357.4004, 53.1914> }
					triangle { <-9.6202, 357.4004, 53.1914>, <-8.06218, 374.0919, 64.6347>, <-10.6315, 358.6084, 50.4185> }
					triangle { <-10.6544, 345.8836, 44.9243>, <-9.6202, 357.4004, 53.1914>, <-10.6315, 358.6084, 50.4185> }
					triangle { <-10.6544, 345.8836, 44.9243>, <-10.6315, 358.6084, 50.4185>, <-11.7879, 346.8429, 42.5409> }
					triangle { <-10.6544, 345.8836, 44.9243>, <-11.7879, 346.8429, 42.5409>, <-15.191, 323.9312, 31.5335> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-15.8716, 280.9557, 11.8732>, <-16.2869, 283.1888, 12.07006>, 0.3 }
			cylinder { <-16.2869, 283.1888, 12.07006>, <-16.7022, 285.4219, 12.2668>, 0.3 }
			cylinder { <-16.7022, 285.4219, 12.2668>, <-17.1175, 287.6549, 12.4636>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-17.1175, 287.6549, 12.4636>, <-19.2727, 303.3806, 10.8056>, 0.3 }
				cylinder { <-19.2727, 303.3806, 10.8056>, <-20.5934, 318.5962, 6.1759>, 0.3 }
				cylinder { <-20.5934, 318.5962, 6.1759>, <-21.02862, 332.7169, -1.2474>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-21.02862, 332.7169, -1.2474>, <-23.2153, 354.4886, -9.4331>, <-20.9645, 354.5541, -10.7665> }
					triangle { <-23.2153, 354.4886, -9.4331>, <-24.00621, 365.6914, -15.9245>, <-20.9645, 354.5541, -10.7665> }
					triangle { <-24.00621, 365.6914, -15.9245>, <-21.4548, 365.7323, -17.3224>, <-20.9645, 354.5541, -10.7665> }
					triangle { <-24.00621, 365.6914, -15.9245>, <-21.7959, 381.7978, -26.5251>, <-21.4548, 365.7323, -17.3224> }
					triangle { <-21.4548, 365.7323, -17.3224>, <-21.7959, 381.7978, -26.5251>, <-18.5956, 365.2479, -17.08543> }
					triangle { <-20.9645, 354.5541, -10.7665>, <-21.4548, 365.7323, -17.3224>, <-18.5956, 365.2479, -17.08543> }
					triangle { <-20.9645, 354.5541, -10.7665>, <-18.5956, 365.2479, -17.08543>, <-18.4744, 353.9528, -10.7303> }
					triangle { <-20.9645, 354.5541, -10.7665>, <-18.4744, 353.9528, -10.7303>, <-21.02862, 332.7169, -1.2474> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-21.02862, 332.7169, -1.2474>, <-18.3828, 353.231, -12.1086>, <-20.5174, 353.0709, -13.6141> }
					triangle { <-18.3828, 353.231, -12.1086>, <-18.9838, 364.9858, -17.5612>, <-20.5174, 353.0709, -13.6141> }
					triangle { <-18.9838, 364.9858, -17.5612>, <-21.3262, 364.7147, -19.2657>, <-20.5174, 353.0709, -13.6141> }
					triangle { <-18.9838, 364.9858, -17.5612>, <-22.4941, 381.1594, -27.6985>, <-21.3262, 364.7147, -19.2657> }
					triangle { <-21.3262, 364.7147, -19.2657>, <-22.4941, 381.1594, -27.6985>, <-22.7239, 362.9871, -21.1438> }
					triangle { <-20.5174, 353.0709, -13.6141>, <-21.3262, 364.7147, -19.2657>, <-22.7239, 362.9871, -21.1438> }
					triangle { <-20.5174, 353.0709, -13.6141>, <-22.7239, 362.9871, -21.1438>, <-21.9351, 351.5456, -15.1064> }
					triangle { <-20.5174, 353.0709, -13.6141>, <-21.9351, 351.5456, -15.1064>, <-21.02862, 332.7169, -1.2474> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-21.02862, 332.7169, -1.2474>, <-23.4021, 351.8495, -14.4424>, <-23.5366, 353.5746, -12.4791> }
					triangle { <-23.4021, 351.8495, -14.4424>, <-23.07627, 363.2721, -20.581>, <-23.5366, 353.5746, -12.4791> }
					triangle { <-23.07627, 363.2721, -20.581>, <-23.2992, 365.1326, -18.3551>, <-23.5366, 353.5746, -12.4791> }
					triangle { <-23.07627, 363.2721, -20.581>, <-23.3018, 381.7379, -26.5508>, <-23.2992, 365.1326, -18.3551> }
					triangle { <-23.2992, 365.1326, -18.3551>, <-23.3018, 381.7379, -26.5508>, <-24.6699, 365.7081, -15.8539> }
					triangle { <-23.5366, 353.5746, -12.4791>, <-23.2992, 365.1326, -18.3551>, <-24.6699, 365.7081, -15.8539> }
					triangle { <-23.5366, 353.5746, -12.4791>, <-24.6699, 365.7081, -15.8539>, <-24.5234, 354.0631, -10.1659> }
					triangle { <-23.5366, 353.5746, -12.4791>, <-24.5234, 354.0631, -10.1659>, <-21.02862, 332.7169, -1.2474> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-17.1175, 287.6549, 12.4636>, <-17.5328, 289.888, 12.6603>, 0.3 }
			cylinder { <-17.5328, 289.888, 12.6603>, <-17.9481, 292.1211, 12.8571>, 0.3 }
			cylinder { <-17.9481, 292.1211, 12.8571>, <-18.3634, 294.3541, 13.05391>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-18.3634, 294.3541, 13.05391>, <-23.7324, 309.0651, 16.1282>, 0.3 }
				cylinder { <-23.7324, 309.0651, 16.1282>, <-31.3569, 322.2903, 20.7813>, 0.3 }
				cylinder { <-31.3569, 322.2903, 20.7813>, <-40.944, 333.5215, 26.8344>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-40.944, 333.5215, 26.8344>, <-50.6652, 348.9693, 33.4849>, <-52.6629, 348.2482, 33.01112> }
					triangle { <-50.6652, 348.9693, 33.4849>, <-57.05206, 356.337, 38.09627>, <-52.6629, 348.2482, 33.01112> }
					triangle { <-57.05206, 356.337, 38.09627>, <-59.2467, 355.5193, 37.4897>, <-52.6629, 348.2482, 33.01112> }
					triangle { <-57.05206, 356.337, 38.09627>, <-68.8006, 365.9423, 43.5865>, <-59.2467, 355.5193, 37.4897> }
					triangle { <-59.2467, 355.5193, 37.4897>, <-68.8006, 365.9423, 43.5865>, <-60.5982, 354.5974, 35.7074> }
					triangle { <-52.6629, 348.2482, 33.01112>, <-59.2467, 355.5193, 37.4897>, <-60.5982, 354.5974, 35.7074> }
					triangle { <-52.6629, 348.2482, 33.01112>, <-60.5982, 354.5974, 35.7074>, <-53.8741, 347.2686, 31.5581> }
					triangle { <-52.6629, 348.2482, 33.01112>, <-53.8741, 347.2686, 31.5581>, <-40.944, 333.5215, 26.8344> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-40.944, 333.5215, 26.8344>, <-54.4274, 346.3827, 32.3254>, <-53.9549, 346.3701, 34.4494> }
					triangle { <-54.4274, 346.3827, 32.3254>, <-60.5467, 354.3699, 36.2111>, <-53.9549, 346.3701, 34.4494> }
					triangle { <-60.5467, 354.3699, 36.2111>, <-60.0265, 354.2705, 38.5717>, <-53.9549, 346.3701, 34.4494> }
					triangle { <-60.5467, 354.3699, 36.2111>, <-68.8233, 365.3327, 44.6814>, <-60.0265, 354.2705, 38.5717> }
					triangle { <-60.0265, 354.2705, 38.5717>, <-68.8233, 365.3327, 44.6814>, <-59.6875, 352.8084, 40.4692> }
					triangle { <-53.9549, 346.3701, 34.4494>, <-60.0265, 354.2705, 38.5717>, <-59.6875, 352.8084, 40.4692> }
					triangle { <-53.9549, 346.3701, 34.4494>, <-59.6875, 352.8084, 40.4692>, <-53.4643, 345.155, 36.1289> }
					triangle { <-53.9549, 346.3701, 34.4494>, <-53.4643, 345.155, 36.1289>, <-40.944, 333.5215, 26.8344> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-40.944, 333.5215, 26.8344>, <-52.376, 345.8467, 36.569>, <-51.7991, 347.6479, 35.4928> }
					triangle { <-52.376, 345.8467, 36.569>, <-59.2797, 353.2288, 40.3351>, <-51.7991, 347.6479, 35.4928> }
					triangle { <-59.2797, 353.2288, 40.3351>, <-58.5564, 355.212, 39.1532>, <-51.7991, 347.6479, 35.4928> }
					triangle { <-59.2797, 353.2288, 40.3351>, <-67.9402, 366.2066, 44.4587>, <-58.5564, 355.212, 39.1532> }
					triangle { <-58.5564, 355.212, 39.1532>, <-67.9402, 366.2066, 44.4587>, <-56.6431, 356.5051, 38.432> }
					triangle { <-51.7991, 347.6479, 35.4928>, <-58.5564, 355.212, 39.1532>, <-56.6431, 356.5051, 38.432> }
					triangle { <-51.7991, 347.6479, 35.4928>, <-56.6431, 356.5051, 38.432>, <-50.1758, 348.7511, 34.6649> }
					triangle { <-51.7991, 347.6479, 35.4928>, <-50.1758, 348.7511, 34.6649>, <-40.944, 333.5215, 26.8344> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-18.3634, 294.3541, 13.05391>, <-18.7787, 296.5872, 13.2506>, 0.3 }
			cylinder { <-18.7787, 296.5872, 13.2506>, <-19.194, 298.8203, 13.4474>, 0.3 }
			cylinder { <-19.194, 298.8203, 13.4474>, <-19.6093, 301.0533, 13.6442>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-19.6093, 301.0533, 13.6442>, <-19.4255, 316.9088, 15.4501>, 0.3 }
				cylinder { <-19.4255, 316.9088, 15.4501>, <-16.1578, 332.3789, 17.6152>, 0.3 }
				cylinder { <-16.1578, 332.3789, 17.6152>, <-9.9318, 346.8693, 20.05625>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-9.9318, 346.8693, 20.05625>, <-6.0563, 360.8962, 21.7171>, <-5.05207, 360.6753, 22.9956> }
					triangle { <-6.0563, 360.8962, 21.7171>, <-2.622, 368.2122, 22.6233>, <-5.05207, 360.6753, 22.9956> }
					triangle { <-2.622, 368.2122, 22.6233>, <-1.5525, 367.9342, 24.07472>, <-5.05207, 360.6753, 22.9956> }
					triangle { <-2.622, 368.2122, 22.6233>, <3.37, 378.2961, 25.8589>, <-1.5525, 367.9342, 24.07472> }
					triangle { <-1.5525, 367.9342, 24.07472>, <3.37, 378.2961, 25.8589>, <-1.4473, 367.1836, 25.7339> }
					triangle { <-5.05207, 360.6753, 22.9956>, <-1.5525, 367.9342, 24.07472>, <-1.4473, 367.1836, 25.7339> }
					triangle { <-5.05207, 360.6753, 22.9956>, <-1.4473, 367.1836, 25.7339>, <-4.8465, 359.9244, 24.4005> }
					triangle { <-5.05207, 360.6753, 22.9956>, <-4.8465, 359.9244, 24.4005>, <-9.9318, 346.8693, 20.05625> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-9.9318, 346.8693, 20.05625>, <-3.9506, 359.565, 24.2486>, <-3.1809, 359.8978, 22.8384> }
					triangle { <-3.9506, 359.565, 24.2486>, <-1.1712, 367.1167, 25.4266>, <-3.1809, 359.8978, 22.8384> }
					triangle { <-1.1712, 367.1167, 25.4266>, <-0.2895, 367.4276, 23.8602>, <-3.1809, 359.8978, 22.8384> }
					triangle { <-1.1712, 367.1167, 25.4266>, <4.0716, 378.0958, 25.2583>, <-0.2895, 367.4276, 23.8602> }
					triangle { <-0.2895, 367.4276, 23.8602>, <4.0716, 378.0958, 25.2583>, <0.8441, 366.7242, 22.6162> }
					triangle { <-3.1809, 359.8978, 22.8384>, <-0.2895, 367.4276, 23.8602>, <0.8441, 366.7242, 22.6162> }
					triangle { <-3.1809, 359.8978, 22.8384>, <0.8441, 366.7242, 22.6162>, <-2.2976, 359.2942, 21.6403> }
					triangle { <-3.1809, 359.8978, 22.8384>, <-2.2976, 359.2942, 21.6403>, <-9.9318, 346.8693, 20.05625> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-9.9318, 346.8693, 20.05625>, <-2.8413, 359.661, 20.8495>, <-4.1505, 360.5945, 21.176> }
					triangle { <-2.8413, 359.661, 20.8495>, <0.4534, 366.9138, 22.487>, <-4.1505, 360.5945, 21.176> }
					triangle { <0.4534, 366.9138, 22.487>, <-1.03203, 367.9254, 22.7992>, <-4.1505, 360.5945, 21.176> }
					triangle { <0.4534, 366.9138, 22.487>, <3.2679, 378.4946, 24.9406>, <-1.03203, 367.9254, 22.7992> }
					triangle { <-1.03203, 367.9254, 22.7992>, <3.2679, 378.4946, 24.9406>, <-2.7198, 368.3204, 22.231> }
					triangle { <-4.1505, 360.5945, 21.176>, <-1.03203, 367.9254, 22.7992>, <-2.7198, 368.3204, 22.231> }
					triangle { <-4.1505, 360.5945, 21.176>, <-2.7198, 368.3204, 22.231>, <-5.6868, 360.8899, 20.8125> }
					triangle { <-4.1505, 360.5945, 21.176>, <-5.6868, 360.8899, 20.8125>, <-9.9318, 346.8693, 20.05625> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-19.6093, 301.0533, 13.6442>, <-20.02462, 303.2864, 13.8409>, 0.3 }
			cylinder { <-20.02462, 303.2864, 13.8409>, <-20.4399, 305.5194, 14.03777>, 0.3 }
			cylinder { <-20.4399, 305.5194, 14.03777>, <-20.8552, 307.7525, 14.2345>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.8552, 307.7525, 14.2345>, <-25.6864, 322.9267, 13.1877>, 0.3 }
				cylinder { <-25.6864, 322.9267, 13.1877>, <-32.256, 337.0604, 9.7571>, 0.3 }
				cylinder { <-32.256, 337.0604, 9.7571>, <-40.3115, 349.6105, 4.07438>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-40.3115, 349.6105, 4.07438>, <-45.09997, 358.4529, 1.5878>, <-44.9575, 358.3719, 0.4391> }
					triangle { <-45.09997, 358.4529, 1.5878>, <-48.2622, 362.8199, -0.4142>, <-44.9575, 358.3719, 0.4391> }
					triangle { <-48.2622, 362.8199, -0.4142>, <-48.05945, 362.7227, -1.6845>, <-44.9575, 358.3719, 0.4391> }
					triangle { <-48.2622, 362.8199, -0.4142>, <-52.3433, 368.9929, -4.8062>, <-48.05945, 362.7227, -1.6845> }
					triangle { <-48.05945, 362.7227, -1.6845>, <-52.3433, 368.9929, -4.8062>, <-47.1748, 362.5269, -2.6029> }
					triangle { <-44.9575, 358.3719, 0.4391>, <-48.05945, 362.7227, -1.6845>, <-47.1748, 362.5269, -2.6029> }
					triangle { <-44.9575, 358.3719, 0.4391>, <-47.1748, 362.5269, -2.6029>, <-44.2348, 358.1095, -0.3969> }
					triangle { <-44.9575, 358.3719, 0.4391>, <-44.2348, 358.1095, -0.3969>, <-40.3115, 349.6105, 4.07438> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-40.3115, 349.6105, 4.07438>, <-44.6417, 357.6843, -0.7591>, <-45.729, 357.4967, -0.4002> }
					triangle { <-44.6417, 357.6843, -0.7591>, <-47.4278, 362.375, -2.5796>, <-45.729, 357.4967, -0.4002> }
					triangle { <-47.4278, 362.375, -2.5796>, <-48.6332, 362.1233, -2.1949>, <-45.729, 357.4967, -0.4002> }
					triangle { <-47.4278, 362.375, -2.5796>, <-52.8979, 368.6214, -4.8405>, <-48.6332, 362.1233, -2.1949> }
					triangle { <-48.6332, 362.1233, -2.1949>, <-52.8979, 368.6214, -4.8405>, <-49.5522, 361.2213, -2.1161> }
					triangle { <-45.729, 357.4967, -0.4002>, <-48.6332, 362.1233, -2.1949>, <-49.5522, 361.2213, -2.1161> }
					triangle { <-45.729, 357.4967, -0.4002>, <-49.5522, 361.2213, -2.1161>, <-46.5326, 356.7138, -0.2219> }
					triangle { <-45.729, 357.4967, -0.4002>, <-46.5326, 356.7138, -0.2219>, <-40.3115, 349.6105, 4.07438> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-40.3115, 349.6105, 4.07438>, <-46.7181, 356.9013, 0.455>, <-46.1833, 357.8109, 0.9377> }
					triangle { <-46.7181, 356.9013, 0.455>, <-49.4705, 361.3911, -1.857>, <-46.1833, 357.8109, 0.9377> }
					triangle { <-49.4705, 361.3911, -1.857>, <-48.8772, 362.3808, -1.2802>, <-46.1833, 357.8109, 0.9377> }
					triangle { <-49.4705, 361.3911, -1.857>, <-52.7552, 368.9666, -4.2805>, <-48.8772, 362.3808, -1.2802> }
					triangle { <-48.8772, 362.3808, -1.2802>, <-52.7552, 368.9666, -4.2805>, <-48.4181, 362.8337, -0.1629> }
					triangle { <-46.1833, 357.8109, 0.9377>, <-48.8772, 362.3808, -1.2802>, <-48.4181, 362.8337, -0.1629> }
					triangle { <-46.1833, 357.8109, 0.9377>, <-48.4181, 362.8337, -0.1629>, <-45.6801, 358.2103, 1.8744> }
					triangle { <-46.1833, 357.8109, 0.9377>, <-45.6801, 358.2103, 1.8744>, <-40.3115, 349.6105, 4.07438> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-20.8552, 307.7525, 14.2345>, <-21.2705, 309.9856, 14.4313>, 0.3 }
			cylinder { <-21.2705, 309.9856, 14.4313>, <-21.6858, 312.2186, 14.628>, 0.3 }
			cylinder { <-21.6858, 312.2186, 14.628>, <-22.1011, 314.4517, 14.8248>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-22.1011, 314.4517, 14.8248>, <-25.05338, 329.491, 19.2738>, 0.3 }
				cylinder { <-25.05338, 329.491, 19.2738>, <-27.9373, 343.3603, 26.6235>, 0.3 }
				cylinder { <-27.9373, 343.3603, 26.6235>, <-30.642, 355.5265, 36.5915>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-30.642, 355.5265, 36.5915>, <-31.7665, 361.8572, 40.4308>, <-32.3388, 361.5529, 40.9634> }
					triangle { <-31.7665, 361.8572, 40.4308>, <-32.2808, 364.9786, 43.1294>, <-32.3388, 361.5529, 40.9634> }
					triangle { <-32.2808, 364.9786, 43.1294>, <-32.934, 364.6287, 43.6957>, <-32.3388, 361.5529, 40.9634> }
					triangle { <-32.2808, 364.9786, 43.1294>, <-33.9117, 369.0155, 47.5733>, <-32.934, 364.6287, 43.6957> }
					triangle { <-32.934, 364.6287, 43.6957>, <-33.9117, 369.0155, 47.5733>, <-33.7373, 364.1566, 43.7374> }
					triangle { <-32.3388, 361.5529, 40.9634>, <-32.934, 364.6287, 43.6957>, <-33.7373, 364.1566, 43.7374> }
					triangle { <-32.3388, 361.5529, 40.9634>, <-33.7373, 364.1566, 43.7374>, <-33.00693, 361.0817, 41.04077> }
					triangle { <-32.3388, 361.5529, 40.9634>, <-33.00693, 361.0817, 41.04077>, <-30.642, 355.5265, 36.5915> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-30.642, 355.5265, 36.5915>, <-32.8577, 360.7998, 41.4253>, <-32.107, 360.9423, 41.7716> }
					triangle { <-32.8577, 360.7998, 41.4253>, <-33.5612, 364.1053, 43.8478>, <-32.107, 360.9423, 41.7716> }
					triangle { <-33.5612, 364.1053, 43.8478>, <-32.7235, 364.2314, 44.2379>, <-32.107, 360.9423, 41.7716> }
					triangle { <-33.5612, 364.1053, 43.8478>, <-33.5544, 368.8605, 47.8594>, <-32.7235, 364.2314, 44.2379> }
					triangle { <-32.7235, 364.2314, 44.2379>, <-33.5544, 368.8605, 47.8594>, <-31.9933, 363.8086, 44.6354> }
					triangle { <-32.107, 360.9423, 41.7716>, <-32.7235, 364.2314, 44.2379>, <-31.9933, 363.8086, 44.6354> }
					triangle { <-32.107, 360.9423, 41.7716>, <-31.9933, 363.8086, 44.6354>, <-31.4203, 360.5979, 42.06181> }
					triangle { <-32.107, 360.9423, 41.7716>, <-31.4203, 360.5979, 42.06181>, <-30.642, 355.5265, 36.5915> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-30.642, 355.5265, 36.5915>, <-31.07014, 360.8896, 41.8007>, <-31.3566, 361.4971, 41.2981> }
					triangle { <-31.07014, 360.8896, 41.8007>, <-31.9608, 363.9583, 44.4616>, <-31.3566, 361.4971, 41.2981> }
					triangle { <-31.9608, 363.9583, 44.4616>, <-32.2547, 364.6272, 43.8819>, <-31.3566, 361.4971, 41.2981> }
					triangle { <-31.9608, 363.9583, 44.4616>, <-33.4617, 369.1754, 47.5002>, <-32.2547, 364.6272, 43.8819> }
					triangle { <-32.2547, 364.6272, 43.8819>, <-33.4617, 369.1754, 47.5002>, <-32.09295, 365.0653, 43.07462> }
					triangle { <-31.3566, 361.4971, 41.2981>, <-32.2547, 364.6272, 43.8819>, <-32.09295, 365.0653, 43.07462> }
					triangle { <-31.3566, 361.4971, 41.2981>, <-32.09295, 365.0653, 43.07462>, <-31.2847, 361.856, 40.563> }
					triangle { <-31.3566, 361.4971, 41.2981>, <-31.2847, 361.856, 40.563>, <-30.642, 355.5265, 36.5915> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-22.1011, 314.4517, 14.8248>, <-22.5164, 316.6848, 15.02162>, 0.3 }
			cylinder { <-22.5164, 316.6848, 15.02162>, <-22.9317, 318.9178, 15.2183>, 0.3 }
			cylinder { <-22.9317, 318.9178, 15.2183>, <-23.347, 321.1509, 15.4151>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-23.347, 321.1509, 15.4151>, <-24.06869, 337.0713, 14.5726>, 0.3 }
				cylinder { <-24.06869, 337.0713, 14.5726>, <-22.5771, 352.6689, 11.5426>, 0.3 }
				cylinder { <-22.5771, 352.6689, 11.5426>, <-18.9297, 367.3443, 6.4415>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-18.9297, 367.3443, 6.4415>, <-18.2755, 372.8534, 5.01314>, <-17.6338, 372.8576, 5.01072> }
					triangle { <-18.2755, 372.8534, 5.01314>, <-17.5855, 375.7281, 3.8392>, <-17.6338, 372.8576, 5.01072> }
					triangle { <-17.5855, 375.7281, 3.8392>, <-16.8724, 375.7224, 3.8595>, <-17.6338, 372.8576, 5.01072> }
					triangle { <-17.5855, 375.7281, 3.8392>, <-15.7284, 379.8291, 2.2959>, <-16.8724, 375.7224, 3.8595> }
					triangle { <-16.8724, 375.7224, 3.8595>, <-15.7284, 379.8291, 2.2959>, <-16.2994, 375.5506, 4.2483> }
					triangle { <-17.6338, 372.8576, 5.01072>, <-16.8724, 375.7224, 3.8595>, <-16.2994, 375.5506, 4.2483> }
					triangle { <-17.6338, 372.8576, 5.01072>, <-16.2994, 375.5506, 4.2483>, <-17.1145, 372.6677, 5.3088> }
					triangle { <-17.6338, 372.8576, 5.01072>, <-17.1145, 372.6677, 5.3088>, <-18.9297, 367.3443, 6.4415> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-18.9297, 367.3443, 6.4415>, <-16.9276, 372.5177, 5.01117>, <-17.193, 372.5453, 4.4275> }
					triangle { <-16.9276, 372.5177, 5.01117>, <-16.3237, 375.5029, 4.09366>, <-17.193, 372.5453, 4.4275> }
					triangle { <-16.3237, 375.5029, 4.09366>, <-16.6089, 375.511, 3.4397>, <-17.193, 372.5453, 4.4275> }
					triangle { <-16.3237, 375.5029, 4.09366>, <-15.7335, 379.7089, 1.9464>, <-16.6089, 375.511, 3.4397> }
					triangle { <-16.6089, 375.511, 3.4397>, <-15.7335, 379.7089, 1.9464>, <-16.6796, 375.1513, 2.8276> }
					triangle { <-17.193, 372.5453, 4.4275>, <-16.6089, 375.511, 3.4397>, <-16.6796, 375.1513, 2.8276> }
					triangle { <-17.193, 372.5453, 4.4275>, <-16.6796, 375.1513, 2.8276>, <-17.3149, 372.2276, 3.8995> }
					triangle { <-17.193, 372.5453, 4.4275>, <-17.3149, 372.2276, 3.8995>, <-18.9297, 367.3443, 6.4415> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-18.9297, 367.3443, 6.4415>, <-17.7061, 372.3135, 3.8668>, <-17.97, 372.6971, 4.3085> }
					triangle { <-17.7061, 372.3135, 3.8668>, <-16.8226, 375.2155, 2.9102>, <-17.97, 372.6971, 4.3085> }
					triangle { <-16.8226, 375.2155, 2.9102>, <-17.1372, 375.6284, 3.3997>, <-17.97, 372.6971, 4.3085> }
					triangle { <-16.8226, 375.2155, 2.9102>, <-16.04397, 379.8408, 2.1038>, <-17.1372, 375.6284, 3.3997> }
					triangle { <-17.1372, 375.6284, 3.3997>, <-16.04397, 379.8408, 2.1038>, <-17.7346, 375.7421, 3.7729> }
					triangle { <-17.97, 372.6971, 4.3085>, <-17.1372, 375.6284, 3.3997>, <-17.7346, 375.7421, 3.7729> }
					triangle { <-17.97, 372.6971, 4.3085>, <-17.7346, 375.7421, 3.7729>, <-18.4633, 372.7867, 4.6869> }
					triangle { <-17.97, 372.6971, 4.3085>, <-18.4633, 372.7867, 4.6869>, <-18.9297, 367.3443, 6.4415> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-23.347, 321.1509, 15.4151>, <-23.7623, 323.3839, 15.6119>, 0.3 }
			cylinder { <-23.7623, 323.3839, 15.6119>, <-24.1776, 325.617, 15.8087>, 0.3 }
			cylinder { <-24.1776, 325.617, 15.8087>, <-24.5929, 327.8501, 16.00547>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-24.5929, 327.8501, 16.00547>, <-30.499, 342.5996, 17.5087>, 0.3 }
				cylinder { <-30.499, 342.5996, 17.5087>, <-39.1772, 355.9004, 19.08007>, 0.3 }
				cylinder { <-39.1772, 355.9004, 19.08007>, <-50.2939, 367.2414, 20.6591>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-50.2939, 367.2414, 20.6591>, <-52.9691, 370.86, 21.2361>, <-53.3187, 370.7341, 20.8893> }
					triangle { <-52.9691, 370.86, 21.2361>, <-54.7677, 372.587, 21.595>, <-53.3187, 370.7341, 20.8893> }
					triangle { <-54.7677, 372.587, 21.595>, <-55.1417, 372.4444, 21.1962>, <-53.3187, 370.7341, 20.8893> }
					triangle { <-54.7677, 372.587, 21.595>, <-57.7402, 374.9041, 21.5577>, <-55.1417, 372.4444, 21.1962> }
					triangle { <-55.1417, 372.4444, 21.1962>, <-57.7402, 374.9041, 21.5577>, <-55.2075, 372.2863, 20.6578> }
					triangle { <-53.3187, 370.7341, 20.8893>, <-55.1417, 372.4444, 21.1962>, <-55.2075, 372.2863, 20.6578> }
					triangle { <-53.3187, 370.7341, 20.8893>, <-55.2075, 372.2863, 20.6578>, <-53.3954, 370.5541, 20.4319> }
					triangle { <-53.3187, 370.7341, 20.8893>, <-53.3954, 370.5541, 20.4319>, <-50.2939, 367.2414, 20.6591> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-50.2939, 367.2414, 20.6591>, <-53.6014, 370.3428, 20.4992>, <-53.7572, 370.2917, 20.9802> }
					triangle { <-53.6014, 370.3428, 20.4992>, <-55.2577, 372.2231, 20.7592>, <-53.7572, 370.2917, 20.9802> }
					triangle { <-55.2577, 372.2231, 20.7592>, <-55.4322, 372.1465, 21.2911>, <-53.7572, 370.2917, 20.9802> }
					triangle { <-55.2577, 372.2231, 20.7592>, <-57.8768, 374.7421, 21.7596>, <-55.4322, 372.1465, 21.2911> }
					triangle { <-55.4322, 372.1465, 21.2911>, <-57.8768, 374.7421, 21.7596>, <-55.5945, 371.7653, 21.6753> }
					triangle { <-53.7572, 370.2917, 20.9802>, <-55.4322, 372.1465, 21.2911>, <-55.5945, 371.7653, 21.6753> }
					triangle { <-53.7572, 370.2917, 20.9802>, <-55.5945, 371.7653, 21.6753>, <-53.8622, 369.9695, 21.3445> }
					triangle { <-53.7572, 370.2917, 20.9802>, <-53.8622, 369.9695, 21.3445>, <-50.2939, 367.2414, 20.6591> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-50.2939, 367.2414, 20.6591>, <-53.6919, 370.104, 21.5773>, <-53.4406, 370.5334, 21.4734> }
					triangle { <-53.6919, 370.104, 21.5773>, <-55.4947, 371.8588, 21.7066>, <-53.4406, 370.5334, 21.4734> }
					triangle { <-55.4947, 371.8588, 21.7066>, <-55.2006, 372.3301, 21.6031>, <-53.4406, 370.5334, 21.4734> }
					triangle { <-55.4947, 371.8588, 21.7066>, <-57.6687, 374.9348, 21.8399>, <-55.2006, 372.3301, 21.6031> }
					triangle { <-55.2006, 372.3301, 21.6031>, <-57.6687, 374.9348, 21.8399>, <-54.7242, 372.6129, 21.7144> }
					triangle { <-53.4406, 370.5334, 21.4734>, <-55.2006, 372.3301, 21.6031>, <-54.7242, 372.6129, 21.7144> }
					triangle { <-53.4406, 370.5334, 21.4734>, <-54.7242, 372.6129, 21.7144>, <-53.01095, 370.7789, 21.5247> }
					triangle { <-53.4406, 370.5334, 21.4734>, <-53.01095, 370.7789, 21.5247>, <-50.2939, 367.2414, 20.6591> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-24.5929, 327.8501, 16.00547>, <-25.00825, 330.0831, 16.2022>, 0.3 }
			cylinder { <-25.00825, 330.0831, 16.2022>, <-25.4235, 332.3162, 16.399>, 0.3 }
			cylinder { <-25.4235, 332.3162, 16.399>, <-25.8388, 334.5493, 16.5957>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-25.8388, 334.5493, 16.5957>, <-26.2927, 350.1529, 19.9144>, 0.3 }
				cylinder { <-26.2927, 350.1529, 19.9144>, <-24.2758, 365.1289, 25.0467>, 0.3 }
				cylinder { <-24.2758, 365.1289, 25.0467>, <-19.8657, 378.902, 31.7954>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-19.8657, 378.902, 31.7954>, <-19.1275, 382.5118, 33.08891>, <-19.07019, 382.4068, 33.5096> }
					triangle { <-19.1275, 382.5118, 33.08891>, <-18.423, 384.3675, 33.9615>, <-19.07019, 382.4068, 33.5096> }
					triangle { <-18.423, 384.3675, 33.9615>, <-18.3742, 384.2423, 34.4289>, <-19.07019, 382.4068, 33.5096> }
					triangle { <-18.423, 384.3675, 33.9615>, <-17.4305, 386.8585, 35.7873>, <-18.3742, 384.2423, 34.4289> }
					triangle { <-18.3742, 384.2423, 34.4289>, <-17.4305, 386.8585, 35.7873>, <-18.5776, 384.0052, 34.8017> }
					triangle { <-19.07019, 382.4068, 33.5096>, <-18.3742, 384.2423, 34.4289>, <-18.5776, 384.0052, 34.8017> }
					triangle { <-19.07019, 382.4068, 33.5096>, <-18.5776, 384.0052, 34.8017>, <-19.2161, 382.1733, 33.8376> }
					triangle { <-19.07019, 382.4068, 33.5096>, <-19.2161, 382.1733, 33.8376>, <-19.8657, 378.902, 31.7954> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-19.8657, 378.902, 31.7954>, <-18.9915, 382.0647, 33.9124>, <-18.6226, 382.1693, 33.7018> }
					triangle { <-18.9915, 382.0647, 33.9124>, <-18.473, 383.9891, 34.7664>, <-18.6226, 382.1693, 33.7018> }
					triangle { <-18.473, 383.9891, 34.7664>, <-18.05753, 384.0892, 34.5343>, <-18.6226, 382.1693, 33.7018> }
					triangle { <-18.473, 383.9891, 34.7664>, <-17.1892, 386.8055, 35.7379>, <-18.05753, 384.0892, 34.5343> }
					triangle { <-18.05753, 384.0892, 34.5343>, <-17.1892, 386.8055, 35.7379>, <-17.6326, 383.9087, 34.3812> }
					triangle { <-18.6226, 382.1693, 33.7018>, <-18.05753, 384.0892, 34.5343>, <-17.6326, 383.9087, 34.3812> }
					triangle { <-18.6226, 382.1693, 33.7018>, <-17.6326, 383.9087, 34.3812>, <-18.261, 382.019, 33.5285> }
					triangle { <-18.6226, 382.1693, 33.7018>, <-18.261, 382.019, 33.5285>, <-19.8657, 378.902, 31.7954> }
					material { txfirew_fruit1 }}
				mesh { // fruit section
					triangle { <-19.8657, 378.902, 31.7954>, <-18.2776, 382.1435, 33.2851>, <-18.6179, 382.4082, 33.2112> }
					triangle { <-18.2776, 382.1435, 33.2851>, <-17.7041, 383.9691, 34.3047>, <-18.6179, 382.4082, 33.2112> }
					triangle { <-17.7041, 383.9691, 34.3047>, <-18.08267, 384.258, 34.2062>, <-18.6179, 382.4082, 33.2112> }
					triangle { <-17.7041, 383.9691, 34.3047>, <-17.3292, 386.933, 35.569>, <-18.08267, 384.258, 34.2062> }
					triangle { <-18.08267, 384.258, 34.2062>, <-17.3292, 386.933, 35.569>, <-18.3921, 384.4065, 33.8616> }
					triangle { <-18.6179, 382.4082, 33.2112>, <-18.08267, 384.258, 34.2062>, <-18.3921, 384.4065, 33.8616> }
					triangle { <-18.6179, 382.4082, 33.2112>, <-18.3921, 384.4065, 33.8616>, <-18.9206, 382.5229, 32.9309> }
					triangle { <-18.6179, 382.4082, 33.2112>, <-18.9206, 382.5229, 32.9309>, <-19.8657, 378.902, 31.7954> }
					material { txfirew_fruit1 }}
				}
			}
		union { // inflor. internode
			cylinder { <-25.8388, 334.5493, 16.5957>, <-26.2541, 336.7823, 16.7925>, 0.3 }
			cylinder { <-26.2541, 336.7823, 16.7925>, <-26.6694, 339.0154, 16.9893>, 0.3 }
			cylinder { <-26.6694, 339.0154, 16.9893>, <-27.08476, 341.2484, 17.186>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-27.08476, 341.2484, 17.186>, <-30.4338, 356.7573, 15.4687>, 0.3 }
				cylinder { <-30.4338, 356.7573, 15.4687>, <-34.09629, 371.5476, 10.7227>, 0.3 }
				cylinder { <-34.09629, 371.5476, 10.7227>, <-37.9312, 385.051, 3.1303>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-37.9312, 385.051, 3.1303>, <-38.8973, 388.3836, 1.8436>, <-38.6464, 388.3848, 1.5137> }
					triangle { <-38.8973, 388.3836, 1.8436>, <-39.4803, 390.072, 0.8279>, <-38.6464, 388.3848, 1.5137> }
					triangle { <-39.4803, 390.072, 0.8279>, <-39.1889, 390.0694, 0.4708>, <-38.6464, 388.3848, 1.5137> }
					triangle { <-39.4803, 390.072, 0.8279>, <-39.9022, 392.4943, -1.01747>, <-39.1889, 390.0694, 0.4708> }
					triangle { <-39.1889, 390.0694, 0.4708>, <-39.9022, 392.4943, -1.01747>, <-38.7517, 390.0046, 0.3401> }
					triangle { <-38.6464, 388.3848, 1.5137>, <-39.1889, 390.0694, 0.4708>, <-38.7517, 390.0046, 0.3401> }
					triangle { <-38.6464, 388.3848, 1.5137>, <-38.7517, 390.0046, 0.3401>, <-38.2744, 388.2979, 1.3767> }
					triangle { <-38.6464, 388.3848, 1.5137>, <-38.2744, 388.2979, 1.3767>, <-37.9312, 385.051, 3.1303> }
					material { txfirew_fruit2 }}
				mesh { // fruit section
					triangle { <-37.9312, 385.051, 3.1303>, <-38.3372, 388.1676, 1.1766>, <-38.7384, 388.1176, 1.08495> }
					triangle { <-38.3372, 388.1676, 1.1766>, <-38.8349, 389.9563, 0.2961>, <-38.7384, 388.1176, 1.08495> }
					triangle { <-38.8349, 389.9563, 0.2961>, <-39.2775, 389.8857, 0.1888>, <-38.7384, 388.1176, 1.08495> }
					triangle { <-38.8349, 389.9563, 0.2961>, <-40.0695, 392.3772, -1.1413>, <-39.2775, 389.8857, 0.1888> }
					triangle { <-39.2775, 389.8857, 0.1888>, <-40.0695, 392.3772, -1.1413>, <-39.5811, 389.5859, 0.01436> }
					triangle { <-38.7384, 388.1176, 1.08495>, <-39.2775, 389.8857, 0.1888>, <-39.5811, 389.5859, 0.01436> }
					triangle { <-38.7384, 388.1176, 1.08495>, <-39.5811, 389.5859, 0.01436>, <-39.02354, 387.8544, 0.9661> }
					triangle { <-38.7384, 388.1176, 1.08495>, <-39.02354, 387.8544, 0.9661>, <-37.9312, 385.051, 3.1303> }
					material { txfirew_fruit2 }}
				mesh { // fruit section
					triangle { <-37.9312, 385.051, 3.1303>, <-39.2017, 387.9059, 1.1477>, <-39.118, 388.2015, 1.4259> }
					triangle { <-39.2017, 387.9059, 1.1477>, <-39.6016, 389.6366, 0.1149>, <-39.118, 388.2015, 1.4259> }
					triangle { <-39.6016, 389.6366, 0.1149>, <-39.5163, 389.9566, 0.4355>, <-39.118, 388.2015, 1.4259> }
					triangle { <-39.6016, 389.6366, 0.1149>, <-40.1243, 392.4799, -0.9309>, <-39.5163, 389.9566, 0.4355> }
					triangle { <-39.5163, 389.9566, 0.4355>, <-40.1243, 392.4799, -0.9309>, <-39.5736, 390.0734, 0.8776> }
					triangle { <-39.118, 388.2015, 1.4259>, <-39.5163, 389.9566, 0.4355>, <-39.5736, 390.0734, 0.8776> }
					triangle { <-39.118, 388.2015, 1.4259>, <-39.5736, 390.0734, 0.8776>, <-39.1295, 388.3035, 1.8185> }
					triangle { <-39.118, 388.2015, 1.4259>, <-39.1295, 388.3035, 1.8185>, <-37.9312, 385.051, 3.1303> }
					material { txfirew_fruit2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-27.08476, 341.2484, 17.186>, <-27.5, 343.4815, 17.3828>, 0.3 }
			cylinder { <-27.5, 343.4815, 17.3828>, <-27.9153, 345.7146, 17.5796>, 0.3 }
			cylinder { <-27.9153, 345.7146, 17.5796>, <-28.3306, 347.9476, 17.7764>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-28.3306, 347.9476, 17.7764>, <-32.8415, 362.7428, 21.7064>, 0.3 }
				cylinder { <-32.8415, 362.7428, 21.7064>, <-38.7828, 376.1332, 28.03823>, 0.3 }
				cylinder { <-38.7828, 376.1332, 28.03823>, <-45.9262, 387.6041, 36.5283>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-45.9262, 387.6041, 36.5283>, <-47.3056, 390.5983, 38.2096>, <-47.6855, 390.4471, 38.278> }
					triangle { <-47.3056, 390.5983, 38.2096>, <-48.17, 392.0408, 39.3905>, <-47.6855, 390.4471, 38.278> }
					triangle { <-48.17, 392.0408, 39.3905>, <-48.5932, 391.8685, 39.4507>, <-47.6855, 390.4471, 38.278> }
					triangle { <-48.17, 392.0408, 39.3905>, <-49.9379, 393.9011, 41.08321>, <-48.5932, 391.8685, 39.4507> }
					triangle { <-48.5932, 391.8685, 39.4507>, <-49.9379, 393.9011, 41.08321>, <-48.9504, 391.6626, 39.2447> }
					triangle { <-47.6855, 390.4471, 38.278>, <-48.5932, 391.8685, 39.4507>, <-48.9504, 391.6626, 39.2447> }
					triangle { <-47.6855, 390.4471, 38.278>, <-48.9504, 391.6626, 39.2447>, <-47.994, 390.2355, 38.1207> }
					triangle { <-47.6855, 390.4471, 38.278>, <-47.994, 390.2355, 38.1207>, <-45.9262, 387.6041, 36.5283> }
					material { txfirew_fruit2 }}
				mesh { // fruit section
					triangle { <-45.9262, 387.6041, 36.5283>, <-48.0292, 390.0763, 38.3061>, <-47.7945, 390.1065, 38.6465> }
					triangle { <-48.0292, 390.0763, 38.3061>, <-48.9035, 391.6269, 39.3325>, <-47.7945, 390.1065, 38.6465> }
					triangle { <-48.9035, 391.6269, 39.3325>, <-48.6427, 391.6442, 39.7122>, <-47.7945, 390.1065, 38.6465> }
					triangle { <-48.9035, 391.6269, 39.3325>, <-49.8586, 393.8011, 41.285>, <-48.6427, 391.6442, 39.7122> }
					triangle { <-48.6427, 391.6442, 39.7122>, <-49.8586, 393.8011, 41.285>, <-48.4349, 391.3953, 40.03973> }
					triangle { <-47.7945, 390.1065, 38.6465>, <-48.6427, 391.6442, 39.7122>, <-48.4349, 391.3953, 40.03973> }
					triangle { <-47.7945, 390.1065, 38.6465>, <-48.4349, 391.3953, 40.03973>, <-47.5775, 389.9019, 38.9218> }
					triangle { <-47.7945, 390.1065, 38.6465>, <-47.5775, 389.9019, 38.9218>, <-45.9262, 387.6041, 36.5283> }
					material { txfirew_fruit2 }}
				mesh { // fruit section
					triangle { <-45.9262, 387.6041, 36.5283>, <-47.3603, 390.0437, 38.913>, <-47.3511, 390.3723, 38.6604> }
					triangle { <-47.3603, 390.0437, 38.913>, <-48.3762, 391.4747, 39.9818>, <-47.3511, 390.3723, 38.6604> }
					triangle { <-48.3762, 391.4747, 39.9818>, <-48.3503, 391.8369, 39.6979>, <-47.3511, 390.3723, 38.6604> }
					triangle { <-48.3762, 391.4747, 39.9818>, <-49.7263, 393.9671, 41.1719>, <-48.3503, 391.8369, 39.6979> }
					triangle { <-48.3503, 391.8369, 39.6979>, <-49.7263, 393.9671, 41.1719>, <-48.07545, 392.0791, 39.4183> }
					triangle { <-47.3511, 390.3723, 38.6604>, <-48.3503, 391.8369, 39.6979>, <-48.07545, 392.0791, 39.4183> }
					triangle { <-47.3511, 390.3723, 38.6604>, <-48.07545, 392.0791, 39.4183>, <-47.1333, 390.5758, 38.385> }
					triangle { <-47.3511, 390.3723, 38.6604>, <-47.1333, 390.5758, 38.385>, <-45.9262, 387.6041, 36.5283> }
					material { txfirew_fruit2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-28.3306, 347.9476, 17.7764>, <-28.7459, 350.1807, 17.9731>, 0.3 }
			cylinder { <-28.7459, 350.1807, 17.9731>, <-29.1612, 352.4138, 18.1699>, 0.3 }
			cylinder { <-29.1612, 352.4138, 18.1699>, <-29.5765, 354.6468, 18.3667>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-29.5765, 354.6468, 18.3667>, <-29.4705, 370.5943, 18.9638>, 0.3 }
				cylinder { <-29.4705, 370.5943, 18.9638>, <-26.3554, 386.2451, 18.7577>, 0.3 }
				cylinder { <-26.3554, 386.2451, 18.7577>, <-20.351, 400.9975, 17.7563>, 0.3 }
				material { txfirew_pedicel }}
			union { // fruit
				mesh { // fruit section
					triangle { <-20.351, 400.9975, 17.7563>, <-19.4523, 404.5816, 17.5517>, <-19.09399, 404.5555, 17.7585> }
					triangle { <-19.4523, 404.5816, 17.5517>, <-18.6491, 406.4586, 17.3202>, <-19.09399, 404.5555, 17.7585> }
					triangle { <-18.6491, 406.4586, 17.3202>, <-18.2585, 406.4218, 17.562>, <-19.09399, 404.5555, 17.7585> }
					triangle { <-18.6491, 406.4586, 17.3202>, <-17.05988, 409.0902, 17.3454>, <-18.2585, 406.4218, 17.562> }
					triangle { <-18.2585, 406.4218, 17.562>, <-17.05988, 409.0902, 17.3454>, <-18.06841, 406.2652, 17.9516> }
					triangle { <-19.09399, 404.5555, 17.7585>, <-18.2585, 406.4218, 17.562>, <-18.06841, 406.2652, 17.9516> }
					triangle { <-19.09399, 404.5555, 17.7585>, <-18.06841, 406.2652, 17.9516>, <-18.9044, 404.3944, 18.07915> }
					triangle { <-19.09399, 404.5555, 17.7585>, <-18.9044, 404.3944, 18.07915>, <-20.351, 400.9975, 17.7563> }
					material { txfirew_fruit2 }}
				mesh { // fruit section
					triangle { <-20.351, 400.9975, 17.7563>, <-18.7048, 404.3054, 17.9643>, <-18.6617, 404.3658, 17.5564> }
					triangle { <-18.7048, 404.3054, 17.9643>, <-18.03199, 406.2437, 17.8546>, <-18.6617, 404.3658, 17.5564> }
					triangle { <-18.03199, 406.2437, 17.8546>, <-17.9771, 406.2963, 17.4>, <-18.6617, 404.3658, 17.5564> }
					triangle { <-18.03199, 406.2437, 17.8546>, <-16.95, 409.0317, 17.1417>, <-17.9771, 406.2963, 17.4> }
					triangle { <-17.9771, 406.2963, 17.4>, <-16.95, 409.0317, 17.1417>, <-17.8209, 406.1007, 17.01304> }
					triangle { <-18.6617, 404.3658, 17.5564>, <-17.9771, 406.2963, 17.4>, <-17.8209, 406.1007, 17.01304> }
					triangle { <-18.6617, 404.3658, 17.5564>, <-17.8209, 406.1007, 17.01304>, <-18.5609, 404.1951, 17.2023> }
					triangle { <-18.6617, 404.3658, 17.5564>, <-18.5609, 404.1951, 17.2023>, <-20.351, 400.9975, 17.7563> }
					material { txfirew_fruit2 }}
				mesh { // fruit section
					triangle { <-20.351, 400.9975, 17.7563>, <-18.7671, 404.2696, 17.06345>, <-19.0538, 404.5045, 17.2491> }
					triangle { <-18.7671, 404.2696, 17.06345>, <-17.9268, 406.1441, 17.01695>, <-19.0538, 404.5045, 17.2491> }
					triangle { <-17.9268, 406.1441, 17.01695>, <-18.2569, 406.3976, 17.2148>, <-19.0538, 404.5045, 17.2491> }
					triangle { <-17.9268, 406.1441, 17.01695>, <-17.1728, 409.1221, 17.1375>, <-18.2569, 406.3976, 17.2148> }
					triangle { <-18.2569, 406.3976, 17.2148>, <-17.1728, 409.1221, 17.1375>, <-18.7103, 406.4778, 17.2361> }
					triangle { <-19.0538, 404.5045, 17.2491>, <-18.2569, 406.3976, 17.2148>, <-18.7103, 406.4778, 17.2361> }
					triangle { <-19.0538, 404.5045, 17.2491>, <-18.7103, 406.4778, 17.2361>, <-19.4512, 404.5644, 17.3055> }
					triangle { <-19.0538, 404.5045, 17.2491>, <-19.4512, 404.5644, 17.3055>, <-20.351, 400.9975, 17.7563> }
					material { txfirew_fruit2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-29.5765, 354.6468, 18.3667>, <-29.9918, 356.8799, 18.5634>, 0.3 }
			cylinder { <-29.9918, 356.8799, 18.5634>, <-30.4071, 359.1129, 18.7602>, 0.3 }
			cylinder { <-30.4071, 359.1129, 18.7602>, <-30.8224, 361.346, 18.957>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-30.8224, 361.346, 18.957>, <-36.3964, 376.2996, 18.8458>, 0.3 }
				cylinder { <-36.3964, 376.2996, 18.8458>, <-44.4231, 390.0006, 17.2504>, 0.3 }
				cylinder { <-44.4231, 390.0006, 17.2504>, <-54.5941, 401.9226, 14.232>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-54.5941, 401.9226, 14.232>, <-56.838, 402.7537, 14.2271>, <-59.6643, 406.6664, 13.168> }
					triangle { <-56.838, 402.7537, 14.2271>, <-62.03211, 408.2424, 12.906>, <-59.6643, 406.6664, 13.168> }
					triangle { <-62.03211, 408.2424, 12.906>, <-60.9582, 409.3823, 12.3433>, <-59.6643, 406.6664, 13.168> }
					triangle { <-59.6643, 406.6664, 13.168>, <-60.9582, 409.3823, 12.3433>, <-54.5941, 401.9226, 14.232> }
					triangle { <-62.03211, 408.2424, 12.906>, <-68.00726, 401.0371, 3.1347>, <-68.9596, 402.08, -2.5555> }
					triangle { <-68.9596, 402.08, -2.5555>, <-65.4887, 404.671, -6.9102>, <-64.5715, 404.9317, -4.6318> }
					triangle { <-64.5715, 404.9317, -4.6318>, <-62.03211, 408.2424, 12.906>, <-68.9596, 402.08, -2.5555> }
					triangle { <-62.03211, 408.2424, 12.906>, <-64.5715, 404.9317, -4.6318>, <-60.9582, 409.3823, 12.3433> }
					triangle { <-58.4161, 407.602, 12.657>, <-54.9656, 404.1571, 13.4606>, <-54.5941, 401.9226, 14.232> }
					triangle { <-58.4161, 407.602, 12.657>, <-59.5355, 410.1135, 11.8841>, <-54.9656, 404.1571, 13.4606> }
					triangle { <-58.4161, 407.602, 12.657>, <-60.9582, 409.3823, 12.3433>, <-59.5355, 410.1135, 11.8841> }
					triangle { <-54.5941, 401.9226, 14.232>, <-60.9582, 409.3823, 12.3433>, <-58.4161, 407.602, 12.657> }
					triangle { <-60.4298, 408.473, -6.04735>, <-57.1889, 409.1453, -1.2938>, <-59.5355, 410.1135, 11.8841> }
					triangle { <-64.5715, 404.9317, -4.6318>, <-65.4887, 404.671, -6.9102>, <-60.4298, 408.473, -6.04735> }
					triangle { <-60.4298, 408.473, -6.04735>, <-59.5355, 410.1135, 11.8841>, <-64.5715, 404.9317, -4.6318> }
					triangle { <-60.9582, 409.3823, 12.3433>, <-64.5715, 404.9317, -4.6318>, <-59.5355, 410.1135, 11.8841> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-54.5941, 401.9226, 14.232>, <-55.7482, 403.8767, 14.9904>, <-58.9378, 407.415, 13.6769> }
					triangle { <-55.7482, 403.8767, 14.9904>, <-60.579, 409.7397, 13.9238>, <-58.9378, 407.415, 13.6769> }
					triangle { <-60.579, 409.7397, 13.9238>, <-60.9582, 409.3823, 12.3433>, <-58.9378, 407.415, 13.6769> }
					triangle { <-58.9378, 407.415, 13.6769>, <-60.9582, 409.3823, 12.3433>, <-54.5941, 401.9226, 14.232> }
					triangle { <-60.579, 409.7397, 13.9238>, <-69.4157, 404.8468, 22.9277>, <-75.03854, 403.2398, 22.5088> }
					triangle { <-75.03854, 403.2398, 22.5088>, <-78.1503, 400.2168, 18.1612>, <-75.8759, 400.8822, 17.4651> }
					triangle { <-75.8759, 400.8822, 17.4651>, <-60.579, 409.7397, 13.9238>, <-75.03854, 403.2398, 22.5088> }
					triangle { <-60.579, 409.7397, 13.9238>, <-75.8759, 400.8822, 17.4651>, <-60.9582, 409.3823, 12.3433> }
					triangle { <-59.1426, 406.8533, 12.1481>, <-56.05539, 403.0341, 12.6973>, <-54.5941, 401.9226, 14.232> }
					triangle { <-59.1426, 406.8533, 12.1481>, <-60.9886, 408.6162, 10.8663>, <-56.05539, 403.0341, 12.6973> }
					triangle { <-59.1426, 406.8533, 12.1481>, <-60.9582, 409.3823, 12.3433>, <-60.9886, 408.6162, 10.8663> }
					triangle { <-54.5941, 401.9226, 14.232>, <-60.9582, 409.3823, 12.3433>, <-59.1426, 406.8533, 12.1481> }
					triangle { <-76.4379, 399.4011, 12.06251>, <-71.1905, 399.9782, 9.6786>, <-60.9886, 408.6162, 10.8663> }
					triangle { <-75.8759, 400.8822, 17.4651>, <-78.1503, 400.2168, 18.1612>, <-76.4379, 399.4011, 12.06251> }
					triangle { <-76.4379, 399.4011, 12.06251>, <-60.9886, 408.6162, 10.8663>, <-75.8759, 400.8822, 17.4651> }
					triangle { <-60.9582, 409.3823, 12.3433>, <-75.8759, 400.8822, 17.4651>, <-60.9886, 408.6162, 10.8663> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-54.5941, 401.9226, 14.232>, <-54.9656, 404.1571, 13.4606>, <-58.4161, 407.602, 12.657> }
					triangle { <-54.9656, 404.1571, 13.4606>, <-59.5355, 410.1135, 11.8841>, <-58.4161, 407.602, 12.657> }
					triangle { <-59.5355, 410.1135, 11.8841>, <-60.9582, 409.3823, 12.3433>, <-58.4161, 407.602, 12.657> }
					triangle { <-58.4161, 407.602, 12.657>, <-60.9582, 409.3823, 12.3433>, <-54.5941, 401.9226, 14.232> }
					triangle { <-59.5355, 410.1135, 11.8841>, <-53.9091, 417.7275, 21.5519>, <-56.09521, 420.3634, 26.3108> }
					triangle { <-56.09521, 420.3634, 26.3108>, <-60.2635, 418.5899, 30.4585>, <-60.1345, 417.103, 28.4907> }
					triangle { <-60.1345, 417.103, 28.4907>, <-59.5355, 410.1135, 11.8841>, <-56.09521, 420.3634, 26.3108> }
					triangle { <-59.5355, 410.1135, 11.8841>, <-60.1345, 417.103, 28.4907>, <-60.9582, 409.3823, 12.3433> }
					triangle { <-59.6643, 406.6664, 13.168>, <-56.838, 402.7537, 14.2271>, <-54.5941, 401.9226, 14.232> }
					triangle { <-59.6643, 406.6664, 13.168>, <-62.03211, 408.2424, 12.906>, <-56.838, 402.7537, 14.2271> }
					triangle { <-59.6643, 406.6664, 13.168>, <-60.9582, 409.3823, 12.3433>, <-62.03211, 408.2424, 12.906> }
					triangle { <-54.5941, 401.9226, 14.232>, <-60.9582, 409.3823, 12.3433>, <-59.6643, 406.6664, 13.168> }
					triangle { <-64.625, 413.9705, 29.8026>, <-64.7274, 409.6194, 25.9806>, <-62.03211, 408.2424, 12.906> }
					triangle { <-60.1345, 417.103, 28.4907>, <-60.2635, 418.5899, 30.4585>, <-64.625, 413.9705, 29.8026> }
					triangle { <-64.625, 413.9705, 29.8026>, <-62.03211, 408.2424, 12.906>, <-60.1345, 417.103, 28.4907> }
					triangle { <-60.9582, 409.3823, 12.3433>, <-60.1345, 417.103, 28.4907>, <-62.03211, 408.2424, 12.906> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-54.5941, 401.9226, 14.232>, <-56.05539, 403.0341, 12.6973>, <-59.1426, 406.8533, 12.1481> }
					triangle { <-56.05539, 403.0341, 12.6973>, <-60.9886, 408.6162, 10.8663>, <-59.1426, 406.8533, 12.1481> }
					triangle { <-60.9886, 408.6162, 10.8663>, <-60.9582, 409.3823, 12.3433>, <-59.1426, 406.8533, 12.1481> }
					triangle { <-59.1426, 406.8533, 12.1481>, <-60.9582, 409.3823, 12.3433>, <-54.5941, 401.9226, 14.232> }
					triangle { <-60.9886, 408.6162, 10.8663>, <-52.5006, 413.9179, 1.7589>, <-50.01632, 419.2036, 1.2464> }
					triangle { <-50.01632, 419.2036, 1.2464>, <-47.6019, 423.0441, 5.387>, <-48.8302, 421.1525, 6.3936> }
					triangle { <-48.8302, 421.1525, 6.3936>, <-60.9886, 408.6162, 10.8663>, <-50.01632, 419.2036, 1.2464> }
					triangle { <-60.9886, 408.6162, 10.8663>, <-48.8302, 421.1525, 6.3936>, <-60.9582, 409.3823, 12.3433> }
					triangle { <-58.9378, 407.415, 13.6769>, <-55.7482, 403.8767, 14.9904>, <-54.5941, 401.9226, 14.232> }
					triangle { <-58.9378, 407.415, 13.6769>, <-60.579, 409.7397, 13.9238>, <-55.7482, 403.8767, 14.9904> }
					triangle { <-58.9378, 407.415, 13.6769>, <-60.9582, 409.3823, 12.3433>, <-60.579, 409.7397, 13.9238> }
					triangle { <-54.5941, 401.9226, 14.232>, <-60.9582, 409.3823, 12.3433>, <-58.9378, 407.415, 13.6769> }
					triangle { <-48.6169, 423.0423, 11.6928>, <-50.7258, 418.7864, 15.00802>, <-60.579, 409.7397, 13.9238> }
					triangle { <-48.8302, 421.1525, 6.3936>, <-47.6019, 423.0441, 5.387>, <-48.6169, 423.0423, 11.6928> }
					triangle { <-48.6169, 423.0423, 11.6928>, <-60.579, 409.7397, 13.9238>, <-48.8302, 421.1525, 6.3936> }
					triangle { <-60.9582, 409.3823, 12.3433>, <-48.8302, 421.1525, 6.3936>, <-60.579, 409.7397, 13.9238> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-30.8224, 361.346, 18.957>, <-31.2377, 363.5791, 19.1537>, 0.3 }
			cylinder { <-31.2377, 363.5791, 19.1537>, <-31.653, 365.8121, 19.3505>, 0.3 }
			cylinder { <-31.653, 365.8121, 19.3505>, <-32.06839, 368.0452, 19.5473>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-32.06839, 368.0452, 19.5473>, <-33.842, 383.3194, 23.8187>, 0.3 }
				cylinder { <-33.842, 383.3194, 23.8187>, <-34.4141, 397.6493, 30.82>, 0.3 }
				cylinder { <-34.4141, 397.6493, 30.82>, <-33.7625, 410.4843, 40.282>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-33.7625, 410.4843, 40.282>, <-32.5389, 411.8223, 41.8436>, <-32.7178, 415.8868, 44.6483> }
					triangle { <-32.5389, 411.8223, 41.8436>, <-31.8463, 417.879, 46.5004>, <-32.7178, 415.8868, 44.6483> }
					triangle { <-31.8463, 417.879, 46.5004>, <-33.3548, 418.5153, 46.2026>, <-32.7178, 415.8868, 44.6483> }
					triangle { <-32.7178, 415.8868, 44.6483>, <-33.3548, 418.5153, 46.2026>, <-33.7625, 410.4843, 40.282> }
					triangle { <-31.8463, 417.879, 46.5004>, <-31.2683, 410.0597, 57.5286>, <-34.5892, 409.7358, 62.3495> }
					triangle { <-34.5892, 409.7358, 62.3495>, <-40.6606, 410.093, 63.206>, <-39.9471, 410.7175, 60.9254> }
					triangle { <-39.9471, 410.7175, 60.9254>, <-31.8463, 417.879, 46.5004>, <-34.5892, 409.7358, 62.3495> }
					triangle { <-31.8463, 417.879, 46.5004>, <-39.9471, 410.7175, 60.9254>, <-33.3548, 418.5153, 46.2026> }
					triangle { <-34.2376, 416.3031, 44.1883>, <-34.8186, 412.4467, 41.1536>, <-33.7625, 410.4843, 40.282> }
					triangle { <-34.2376, 416.3031, 44.1883>, <-34.8858, 418.7115, 45.5804>, <-34.8186, 412.4467, 41.1536> }
					triangle { <-34.2376, 416.3031, 44.1883>, <-33.3548, 418.5153, 46.2026>, <-34.8858, 418.7115, 45.5804> }
					triangle { <-33.7625, 410.4843, 40.282>, <-33.3548, 418.5153, 46.2026>, <-34.2376, 416.3031, 44.1883> }
					triangle { <-44.9742, 412.5804, 59.2061>, <-44.4395, 413.6673, 53.5419>, <-34.8858, 418.7115, 45.5804> }
					triangle { <-39.9471, 410.7175, 60.9254>, <-40.6606, 410.093, 63.206>, <-44.9742, 412.5804, 59.2061> }
					triangle { <-44.9742, 412.5804, 59.2061>, <-34.8858, 418.7115, 45.5804>, <-39.9471, 410.7175, 60.9254> }
					triangle { <-33.3548, 418.5153, 46.2026>, <-39.9471, 410.7175, 60.9254>, <-34.8858, 418.7115, 45.5804> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-33.7625, 410.4843, 40.282>, <-33.2162, 412.7962, 40.5691>, <-33.1693, 416.5361, 43.7987> }
					triangle { <-33.2162, 412.7962, 40.5691>, <-32.7493, 419.1775, 44.8011>, <-33.1693, 416.5361, 43.7987> }
					triangle { <-32.7493, 419.1775, 44.8011>, <-33.3548, 418.5153, 46.2026>, <-33.1693, 416.5361, 43.7987> }
					triangle { <-33.1693, 416.5361, 43.7987>, <-33.3548, 418.5153, 46.2026>, <-33.7625, 410.4843, 40.282> }
					triangle { <-32.7493, 419.1775, 44.8011>, <-19.2327, 419.29, 44.1793>, <-15.06305, 419.1045, 48.2968> }
					triangle { <-15.06305, 419.1045, 48.2968>, <-14.5636, 415.9098, 53.5187>, <-16.8015, 415.7659, 52.4836> }
					triangle { <-16.8015, 415.7659, 52.4836>, <-32.7493, 419.1775, 44.8011>, <-15.06305, 419.1045, 48.2968> }
					triangle { <-32.7493, 419.1775, 44.8011>, <-16.8015, 415.7659, 52.4836>, <-33.3548, 418.5153, 46.2026> }
					triangle { <-33.7861, 415.6538, 45.03798>, <-34.1413, 411.4727, 42.428>, <-33.7625, 410.4843, 40.282> }
					triangle { <-33.7861, 415.6538, 45.03798>, <-33.9828, 417.413, 47.2796>, <-34.1413, 411.4727, 42.428> }
					triangle { <-33.7861, 415.6538, 45.03798>, <-33.3548, 418.5153, 46.2026>, <-33.9828, 417.413, 47.2796> }
					triangle { <-33.7625, 410.4843, 40.282>, <-33.3548, 418.5153, 46.2026>, <-33.7861, 415.6538, 45.03798> }
					triangle { <-19.2775, 413.0756, 56.7649>, <-24.5779, 411.6436, 54.9194>, <-33.9828, 417.413, 47.2796> }
					triangle { <-16.8015, 415.7659, 52.4836>, <-14.5636, 415.9098, 53.5187>, <-19.2775, 413.0756, 56.7649> }
					triangle { <-19.2775, 413.0756, 56.7649>, <-33.9828, 417.413, 47.2796>, <-16.8015, 415.7659, 52.4836> }
					triangle { <-33.3548, 418.5153, 46.2026>, <-16.8015, 415.7659, 52.4836>, <-33.9828, 417.413, 47.2796> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-33.7625, 410.4843, 40.282>, <-34.8186, 412.4467, 41.1536>, <-34.2376, 416.3031, 44.1883> }
					triangle { <-34.8186, 412.4467, 41.1536>, <-34.8858, 418.7115, 45.5804>, <-34.2376, 416.3031, 44.1883> }
					triangle { <-34.8858, 418.7115, 45.5804>, <-33.3548, 418.5153, 46.2026>, <-34.2376, 416.3031, 44.1883> }
					triangle { <-34.2376, 416.3031, 44.1883>, <-33.3548, 418.5153, 46.2026>, <-33.7625, 410.4843, 40.282> }
					triangle { <-34.8858, 418.7115, 45.5804>, <-35.4414, 426.9709, 34.8766>, <-31.9194, 431.2552, 32.9754> }
					triangle { <-31.9194, 431.2552, 32.9754>, <-25.8033, 431.7781, 32.7678>, <-26.5839, 429.8335, 34.07513> }
					triangle { <-26.5839, 429.8335, 34.07513>, <-34.8858, 418.7115, 45.5804>, <-31.9194, 431.2552, 32.9754> }
					triangle { <-34.8858, 418.7115, 45.5804>, <-26.5839, 429.8335, 34.07513>, <-33.3548, 418.5153, 46.2026> }
					triangle { <-32.7178, 415.8868, 44.6483>, <-32.5389, 411.8223, 41.8436>, <-33.7625, 410.4843, 40.282> }
					triangle { <-32.7178, 415.8868, 44.6483>, <-31.8463, 417.879, 46.5004>, <-32.5389, 411.8223, 41.8436> }
					triangle { <-32.7178, 415.8868, 44.6483>, <-33.3548, 418.5153, 46.2026>, <-31.8463, 417.879, 46.5004> }
					triangle { <-33.7625, 410.4843, 40.282>, <-33.3548, 418.5153, 46.2026>, <-32.7178, 415.8868, 44.6483> }
					triangle { <-21.5344, 428.4107, 36.1188>, <-22.2702, 423.3632, 38.8633>, <-31.8463, 417.879, 46.5004> }
					triangle { <-26.5839, 429.8335, 34.07513>, <-25.8033, 431.7781, 32.7678>, <-21.5344, 428.4107, 36.1188> }
					triangle { <-21.5344, 428.4107, 36.1188>, <-31.8463, 417.879, 46.5004>, <-26.5839, 429.8335, 34.07513> }
					triangle { <-33.3548, 418.5153, 46.2026>, <-26.5839, 429.8335, 34.07513>, <-31.8463, 417.879, 46.5004> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-33.7625, 410.4843, 40.282>, <-34.1413, 411.4727, 42.428>, <-33.7861, 415.6538, 45.03798> }
					triangle { <-34.1413, 411.4727, 42.428>, <-33.9828, 417.413, 47.2796>, <-33.7861, 415.6538, 45.03798> }
					triangle { <-33.9828, 417.413, 47.2796>, <-33.3548, 418.5153, 46.2026>, <-33.7861, 415.6538, 45.03798> }
					triangle { <-33.7861, 415.6538, 45.03798>, <-33.3548, 418.5153, 46.2026>, <-33.7625, 410.4843, 40.282> }
					triangle { <-33.9828, 417.413, 47.2796>, <-47.477, 417.7406, 48.2259>, <-51.4456, 421.8866, 47.02819> }
					triangle { <-51.4456, 421.8866, 47.02819>, <-51.9004, 425.9613, 42.4551>, <-49.7295, 424.7851, 42.5169> }
					triangle { <-49.7295, 424.7851, 42.5169>, <-33.9828, 417.413, 47.2796>, <-51.4456, 421.8866, 47.02819> }
					triangle { <-33.9828, 417.413, 47.2796>, <-49.7295, 424.7851, 42.5169>, <-33.3548, 418.5153, 46.2026> }
					triangle { <-33.1693, 416.5361, 43.7987>, <-33.2162, 412.7962, 40.5691>, <-33.7625, 410.4843, 40.282> }
					triangle { <-33.1693, 416.5361, 43.7987>, <-32.7493, 419.1775, 44.8011>, <-33.2162, 412.7962, 40.5691> }
					triangle { <-33.1693, 416.5361, 43.7987>, <-33.3548, 418.5153, 46.2026>, <-32.7493, 419.1775, 44.8011> }
					triangle { <-33.7625, 410.4843, 40.282>, <-33.3548, 418.5153, 46.2026>, <-33.1693, 416.5361, 43.7987> }
					triangle { <-47.2311, 427.9155, 38.56>, <-42.1318, 425.387, 37.4858>, <-32.7493, 419.1775, 44.8011> }
					triangle { <-49.7295, 424.7851, 42.5169>, <-51.9004, 425.9613, 42.4551>, <-47.2311, 427.9155, 38.56> }
					triangle { <-47.2311, 427.9155, 38.56>, <-32.7493, 419.1775, 44.8011>, <-49.7295, 424.7851, 42.5169> }
					triangle { <-33.3548, 418.5153, 46.2026>, <-49.7295, 424.7851, 42.5169>, <-32.7493, 419.1775, 44.8011> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-32.06839, 368.0452, 19.5473>, <-32.4836, 370.2783, 19.7441>, 0.3 }
			cylinder { <-32.4836, 370.2783, 19.7441>, <-32.8989, 372.5113, 19.9408>, 0.3 }
			cylinder { <-32.8989, 372.5113, 19.9408>, <-33.3143, 374.7444, 20.1376>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.3143, 374.7444, 20.1376>, <-35.03967, 390.5374, 18.6227>, 0.3 }
				cylinder { <-35.03967, 390.5374, 18.6227>, <-35.517, 405.8851, 14.2739>, 0.3 }
				cylinder { <-35.517, 405.8851, 14.2739>, <-34.7279, 420.1976, 7.2581>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-34.7279, 420.1976, 7.2581>, <-35.07265, 421.5526, 5.3162>, <-34.6804, 426.1308, 3.4979> }
					triangle { <-35.07265, 421.5526, 5.3162>, <-34.8426, 428.2609, 1.602>, <-34.6804, 426.1308, 3.4979> }
					triangle { <-34.8426, 428.2609, 1.602>, <-34.2342, 429.1531, 2.8682>, <-34.6804, 426.1308, 3.4979> }
					triangle { <-34.6804, 426.1308, 3.4979>, <-34.2342, 429.1531, 2.8682>, <-34.7279, 420.1976, 7.2581> }
					triangle { <-34.8426, 428.2609, 1.602>, <-25.4031, 423.8209, -7.01654>, <-19.9759, 425.6583, -8.2587> }
					triangle { <-19.9759, 425.6583, -8.2587>, <-15.4197, 427.755, -4.7135>, <-17.5751, 427.5404, -3.5267> }
					triangle { <-17.5751, 427.5404, -3.5267>, <-34.8426, 428.2609, 1.602>, <-19.9759, 425.6583, -8.2587> }
					triangle { <-34.8426, 428.2609, 1.602>, <-17.5751, 427.5404, -3.5267>, <-34.2342, 429.1531, 2.8682> }
					triangle { <-34.08562, 426.7776, 4.8844>, <-34.1803, 422.5229, 7.3959>, <-34.7279, 420.1976, 7.2581> }
					triangle { <-34.08562, 426.7776, 4.8844>, <-33.6529, 429.5546, 4.3749>, <-34.1803, 422.5229, 7.3959> }
					triangle { <-34.08562, 426.7776, 4.8844>, <-34.2342, 429.1531, 2.8682>, <-33.6529, 429.5546, 4.3749> }
					triangle { <-34.7279, 420.1976, 7.2581>, <-34.2342, 429.1531, 2.8682>, <-34.08562, 426.7776, 4.8844> }
					triangle { <-15.9111, 430.0783, 1.2154>, <-20.2478, 429.4268, 4.9995>, <-33.6529, 429.5546, 4.3749> }
					triangle { <-17.5751, 427.5404, -3.5267>, <-15.4197, 427.755, -4.7135>, <-15.9111, 430.0783, 1.2154> }
					triangle { <-15.9111, 430.0783, 1.2154>, <-33.6529, 429.5546, 4.3749>, <-17.5751, 427.5404, -3.5267> }
					triangle { <-34.2342, 429.1531, 2.8682>, <-17.5751, 427.5404, -3.5267>, <-33.6529, 429.5546, 4.3749> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-34.7279, 420.1976, 7.2581>, <-35.7723, 422.2853, 6.7322>, <-35.1469, 426.6192, 4.4419> }
					triangle { <-35.7723, 422.2853, 6.7322>, <-35.7755, 429.2378, 3.49>, <-35.1469, 426.6192, 4.4419> }
					triangle { <-35.7755, 429.2378, 3.49>, <-34.2342, 429.1531, 2.8682>, <-35.1469, 426.6192, 4.4419> }
					triangle { <-35.1469, 426.6192, 4.4419>, <-34.2342, 429.1531, 2.8682>, <-34.7279, 420.1976, 7.2581> }
					triangle { <-35.7755, 429.2378, 3.49>, <-45.4433, 425.7596, -5.3153>, <-45.6279, 425.6433, -11.1742> }
					triangle { <-45.6279, 425.6433, -11.1742>, <-41.4996, 423.9558, -15.3971>, <-40.5702, 424.1086, -13.114> }
					triangle { <-40.5702, 424.1086, -13.114>, <-35.7755, 429.2378, 3.49>, <-45.6279, 425.6433, -11.1742> }
					triangle { <-35.7755, 429.2378, 3.49>, <-40.5702, 424.1086, -13.114>, <-34.2342, 429.1531, 2.8682> }
					triangle { <-33.6191, 426.2892, 3.9404>, <-33.4806, 421.7902, 5.9799>, <-34.7279, 420.1976, 7.2581> }
					triangle { <-33.6191, 426.2892, 3.9404>, <-32.72, 428.5777, 2.487>, <-33.4806, 421.7902, 5.9799> }
					triangle { <-33.6191, 426.2892, 3.9404>, <-34.2342, 429.1531, 2.8682>, <-32.72, 428.5777, 2.487> }
					triangle { <-34.7279, 420.1976, 7.2581>, <-34.2342, 429.1531, 2.8682>, <-33.6191, 426.2892, 3.9404> }
					triangle { <-35.1881, 423.388, -14.601>, <-32.2025, 422.8991, -9.6616>, <-32.72, 428.5777, 2.487> }
					triangle { <-40.5702, 424.1086, -13.114>, <-41.4996, 423.9558, -15.3971>, <-35.1881, 423.388, -14.601> }
					triangle { <-35.1881, 423.388, -14.601>, <-32.72, 428.5777, 2.487>, <-40.5702, 424.1086, -13.114> }
					triangle { <-34.2342, 429.1531, 2.8682>, <-40.5702, 424.1086, -13.114>, <-32.72, 428.5777, 2.487> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-34.7279, 420.1976, 7.2581>, <-34.1803, 422.5229, 7.3959>, <-34.08562, 426.7776, 4.8844> }
					triangle { <-34.1803, 422.5229, 7.3959>, <-33.6529, 429.5546, 4.3749>, <-34.08562, 426.7776, 4.8844> }
					triangle { <-33.6529, 429.5546, 4.3749>, <-34.2342, 429.1531, 2.8682>, <-34.08562, 426.7776, 4.8844> }
					triangle { <-34.08562, 426.7776, 4.8844>, <-34.2342, 429.1531, 2.8682>, <-34.7279, 420.1976, 7.2581> }
					triangle { <-33.6529, 429.5546, 4.3749>, <-43.06532, 434.4853, 12.753>, <-48.249, 437.0644, 11.8304> }
					triangle { <-48.249, 437.0644, 11.8304>, <-52.7511, 435.9491, 7.8041>, <-50.6769, 434.6915, 7.3389> }
					triangle { <-50.6769, 434.6915, 7.3389>, <-33.6529, 429.5546, 4.3749>, <-48.249, 437.0644, 11.8304> }
					triangle { <-33.6529, 429.5546, 4.3749>, <-50.6769, 434.6915, 7.3389>, <-34.2342, 429.1531, 2.8682> }
					triangle { <-34.6804, 426.1308, 3.4979>, <-35.07265, 421.5526, 5.3162>, <-34.7279, 420.1976, 7.2581> }
					triangle { <-34.6804, 426.1308, 3.4979>, <-34.8426, 428.2609, 1.602>, <-35.07265, 421.5526, 5.3162> }
					triangle { <-34.6804, 426.1308, 3.4979>, <-34.2342, 429.1531, 2.8682>, <-34.8426, 428.2609, 1.602> }
					triangle { <-34.7279, 420.1976, 7.2581>, <-34.2342, 429.1531, 2.8682>, <-34.6804, 426.1308, 3.4979> }
					triangle { <-52.3138, 432.6443, 2.3562>, <-48.2206, 428.8795, 0.7369>, <-34.8426, 428.2609, 1.602> }
					triangle { <-50.6769, 434.6915, 7.3389>, <-52.7511, 435.9491, 7.8041>, <-52.3138, 432.6443, 2.3562> }
					triangle { <-52.3138, 432.6443, 2.3562>, <-34.8426, 428.2609, 1.602>, <-50.6769, 434.6915, 7.3389> }
					triangle { <-34.2342, 429.1531, 2.8682>, <-50.6769, 434.6915, 7.3389>, <-34.8426, 428.2609, 1.602> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-34.7279, 420.1976, 7.2581>, <-33.4806, 421.7902, 5.9799>, <-33.6191, 426.2892, 3.9404> }
					triangle { <-33.4806, 421.7902, 5.9799>, <-32.72, 428.5777, 2.487>, <-33.6191, 426.2892, 3.9404> }
					triangle { <-32.72, 428.5777, 2.487>, <-34.2342, 429.1531, 2.8682>, <-33.6191, 426.2892, 3.9404> }
					triangle { <-33.6191, 426.2892, 3.9404>, <-34.2342, 429.1531, 2.8682>, <-34.7279, 420.1976, 7.2581> }
					triangle { <-32.72, 428.5777, 2.487>, <-23.0252, 432.5466, 11.05183>, <-22.5971, 437.0793, 14.7458> }
					triangle { <-22.5971, 437.0793, 14.7458>, <-26.6712, 439.7482, 18.4877>, <-27.6818, 438.1233, 16.9261> }
					triangle { <-27.6818, 438.1233, 16.9261>, <-32.72, 428.5777, 2.487>, <-22.5971, 437.0793, 14.7458> }
					triangle { <-32.72, 428.5777, 2.487>, <-27.6818, 438.1233, 16.9261>, <-34.2342, 429.1531, 2.8682> }
					triangle { <-35.1469, 426.6192, 4.4419>, <-35.7723, 422.2853, 6.7322>, <-34.7279, 420.1976, 7.2581> }
					triangle { <-35.1469, 426.6192, 4.4419>, <-35.7755, 429.2378, 3.49>, <-35.7723, 422.2853, 6.7322> }
					triangle { <-35.1469, 426.6192, 4.4419>, <-34.2342, 429.1531, 2.8682>, <-35.7755, 429.2378, 3.49> }
					triangle { <-34.7279, 420.1976, 7.2581>, <-34.2342, 429.1531, 2.8682>, <-35.1469, 426.6192, 4.4419> }
					triangle { <-33.03693, 439.3346, 18.1727>, <-36.2659, 435.4071, 15.3981>, <-35.7755, 429.2378, 3.49> }
					triangle { <-27.6818, 438.1233, 16.9261>, <-26.6712, 439.7482, 18.4877>, <-33.03693, 439.3346, 18.1727> }
					triangle { <-33.03693, 439.3346, 18.1727>, <-35.7755, 429.2378, 3.49>, <-27.6818, 438.1233, 16.9261> }
					triangle { <-34.2342, 429.1531, 2.8682>, <-27.6818, 438.1233, 16.9261>, <-35.7755, 429.2378, 3.49> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-33.3143, 374.7444, 20.1376>, <-33.7296, 376.9774, 20.3344>, 0.3 }
			cylinder { <-33.7296, 376.9774, 20.3344>, <-34.1449, 379.2105, 20.5311>, 0.3 }
			cylinder { <-34.1449, 379.2105, 20.5311>, <-34.5602, 381.4436, 20.7279>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-34.5602, 381.4436, 20.7279>, <-40.1574, 396.1471, 23.4052>, 0.3 }
				cylinder { <-40.1574, 396.1471, 23.4052>, <-48.2298, 409.3577, 27.2794>, 0.3 }
				cylinder { <-48.2298, 409.3577, 27.2794>, <-58.467, 420.5676, 32.2017>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-58.467, 420.5676, 32.2017>, <-59.9551, 421.3906, 33.8852>, <-63.05674, 425.0558, 35.05389> }
					triangle { <-59.9551, 421.3906, 33.8852>, <-64.9263, 426.5652, 36.5981>, <-63.05674, 425.0558, 35.05389> }
					triangle { <-64.9263, 426.5652, 36.5981>, <-64.8725, 427.5818, 35.2816>, <-63.05674, 425.0558, 35.05389> }
					triangle { <-63.05674, 425.0558, 35.05389>, <-64.8725, 427.5818, 35.2816>, <-58.467, 420.5676, 32.2017> }
					triangle { <-64.9263, 426.5652, 36.5981>, <-75.1718, 417.7315, 36.2946>, <-80.3399, 417.7329, 33.5261> }
					triangle { <-80.3399, 417.7329, 33.5261>, <-81.9905, 419.4856, 27.8757>, <-79.6908, 420.1506, 28.4831> }
					triangle { <-79.6908, 420.1506, 28.4831>, <-64.9263, 426.5652, 36.5981>, <-80.3399, 417.7329, 33.5261> }
					triangle { <-64.9263, 426.5652, 36.5981>, <-79.6908, 420.1506, 28.4831>, <-64.8725, 427.5818, 35.2816> }
					triangle { <-62.8275, 425.8802, 33.653>, <-59.6112, 422.6272, 31.7839>, <-58.467, 420.5676, 32.2017> }
					triangle { <-62.8275, 425.8802, 33.653>, <-64.4678, 428.2141, 33.7964>, <-59.6112, 422.6272, 31.7839> }
					triangle { <-62.8275, 425.8802, 33.653>, <-64.8725, 427.5818, 35.2816>, <-64.4678, 428.2141, 33.7964> }
					triangle { <-58.467, 420.5676, 32.2017>, <-64.8725, 427.5818, 35.2816>, <-62.8275, 425.8802, 33.653> }
					triangle { <-78.7735, 423.3666, 23.9539>, <-73.1851, 424.8767, 24.1542>, <-64.4678, 428.2141, 33.7964> }
					triangle { <-79.6908, 420.1506, 28.4831>, <-81.9905, 419.4856, 27.8757>, <-78.7735, 423.3666, 23.9539> }
					triangle { <-78.7735, 423.3666, 23.9539>, <-64.4678, 428.2141, 33.7964>, <-79.6908, 420.1506, 28.4831> }
					triangle { <-64.8725, 427.5818, 35.2816>, <-79.6908, 420.1506, 28.4831>, <-64.4678, 428.2141, 33.7964> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-58.467, 420.5676, 32.2017>, <-58.8545, 422.6298, 33.352>, <-62.323, 425.8819, 34.6984> }
					triangle { <-58.8545, 422.6298, 33.352>, <-63.4588, 428.2175, 35.8871>, <-62.323, 425.8819, 34.6984> }
					triangle { <-63.4588, 428.2175, 35.8871>, <-64.8725, 427.5818, 35.2816>, <-62.323, 425.8819, 34.6984> }
					triangle { <-62.323, 425.8819, 34.6984>, <-64.8725, 427.5818, 35.2816>, <-58.467, 420.5676, 32.2017> }
					triangle { <-63.4588, 428.2175, 35.8871>, <-61.1228, 425.055, 48.8347>, <-64.6473, 423.4146, 53.2234> }
					triangle { <-64.6473, 423.4146, 53.2234>, <-69.5079, 419.6653, 53.4273>, <-68.7598, 420.1877, 51.1322> }
					triangle { <-68.7598, 420.1877, 51.1322>, <-63.4588, 428.2175, 35.8871>, <-64.6473, 423.4146, 53.2234> }
					triangle { <-63.4588, 428.2175, 35.8871>, <-68.7598, 420.1877, 51.1322>, <-64.8725, 427.5818, 35.2816> }
					triangle { <-63.5612, 425.054, 34.00855>, <-60.7119, 421.388, 32.3172>, <-58.467, 420.5676, 32.2017> }
					triangle { <-63.5612, 425.054, 34.00855>, <-65.9353, 426.5618, 34.5074>, <-60.7119, 421.388, 32.3172> }
					triangle { <-63.5612, 425.054, 34.00855>, <-64.8725, 427.5818, 35.2816>, <-65.9353, 426.5618, 34.5074> }
					triangle { <-58.467, 420.5676, 32.2017>, <-64.8725, 427.5818, 35.2816>, <-63.5612, 425.054, 34.00855> }
					triangle { <-73.1087, 417.7575, 48.5093>, <-71.8543, 417.8801, 42.8558>, <-65.9353, 426.5618, 34.5074> }
					triangle { <-68.7598, 420.1877, 51.1322>, <-69.5079, 419.6653, 53.4273>, <-73.1087, 417.7575, 48.5093> }
					triangle { <-73.1087, 417.7575, 48.5093>, <-65.9353, 426.5618, 34.5074>, <-68.7598, 420.1877, 51.1322> }
					triangle { <-64.8725, 427.5818, 35.2816>, <-68.7598, 420.1877, 51.1322>, <-65.9353, 426.5618, 34.5074> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-58.467, 420.5676, 32.2017>, <-59.6112, 422.6272, 31.7839>, <-62.8275, 425.8802, 33.653> }
					triangle { <-59.6112, 422.6272, 31.7839>, <-64.4678, 428.2141, 33.7964>, <-62.8275, 425.8802, 33.653> }
					triangle { <-64.4678, 428.2141, 33.7964>, <-64.8725, 427.5818, 35.2816>, <-62.8275, 425.8802, 33.653> }
					triangle { <-62.8275, 425.8802, 33.653>, <-64.8725, 427.5818, 35.2816>, <-58.467, 420.5676, 32.2017> }
					triangle { <-64.4678, 428.2141, 33.7964>, <-54.5733, 437.4322, 34.2687>, <-52.564, 440.8898, 38.5561> }
					triangle { <-52.564, 440.8898, 38.5561>, <-51.6154, 439.9058, 44.544>, <-52.8622, 438.0878, 43.4303> }
					triangle { <-52.8622, 438.0878, 43.4303>, <-64.4678, 428.2141, 33.7964>, <-52.564, 440.8898, 38.5561> }
					triangle { <-64.4678, 428.2141, 33.7964>, <-52.8622, 438.0878, 43.4303>, <-64.8725, 427.5818, 35.2816> }
					triangle { <-63.05674, 425.0558, 35.05389>, <-59.9551, 421.3906, 33.8852>, <-58.467, 420.5676, 32.2017> }
					triangle { <-63.05674, 425.0558, 35.05389>, <-64.9263, 426.5652, 36.5981>, <-59.9551, 421.3906, 33.8852> }
					triangle { <-63.05674, 425.0558, 35.05389>, <-64.8725, 427.5818, 35.2816>, <-64.9263, 426.5652, 36.5981> }
					triangle { <-58.467, 420.5676, 32.2017>, <-64.8725, 427.5818, 35.2816>, <-63.05674, 425.0558, 35.05389> }
					triangle { <-54.1304, 435.2562, 48.1283>, <-56.5599, 430.287, 46.4091>, <-64.9263, 426.5652, 36.5981> }
					triangle { <-52.8622, 438.0878, 43.4303>, <-51.6154, 439.9058, 44.544>, <-54.1304, 435.2562, 48.1283> }
					triangle { <-54.1304, 435.2562, 48.1283>, <-64.9263, 426.5652, 36.5981>, <-52.8622, 438.0878, 43.4303> }
					triangle { <-64.8725, 427.5818, 35.2816>, <-52.8622, 438.0878, 43.4303>, <-64.9263, 426.5652, 36.5981> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-58.467, 420.5676, 32.2017>, <-60.7119, 421.388, 32.3172>, <-63.5612, 425.054, 34.00855> }
					triangle { <-60.7119, 421.388, 32.3172>, <-65.9353, 426.5618, 34.5074>, <-63.5612, 425.054, 34.00855> }
					triangle { <-65.9353, 426.5618, 34.5074>, <-64.8725, 427.5818, 35.2816>, <-63.5612, 425.054, 34.00855> }
					triangle { <-63.5612, 425.054, 34.00855>, <-64.8725, 427.5818, 35.2816>, <-58.467, 420.5676, 32.2017> }
					triangle { <-65.9353, 426.5618, 34.5074>, <-68.6222, 430.1087, 21.7286>, <-68.2566, 435.2081, 18.8587> }
					triangle { <-68.2566, 435.2081, 18.8587>, <-64.0981, 439.7261, 18.9924>, <-63.7931, 438.0506, 20.7812> }
					triangle { <-63.7931, 438.0506, 20.7812>, <-65.9353, 426.5618, 34.5074>, <-68.2566, 435.2081, 18.8587> }
					triangle { <-65.9353, 426.5618, 34.5074>, <-63.7931, 438.0506, 20.7812>, <-64.8725, 427.5818, 35.2816> }
					triangle { <-62.323, 425.8819, 34.6984>, <-58.8545, 422.6298, 33.352>, <-58.467, 420.5676, 32.2017> }
					triangle { <-62.323, 425.8819, 34.6984>, <-63.4588, 428.2175, 35.8871>, <-58.8545, 422.6298, 33.352> }
					triangle { <-62.323, 425.8819, 34.6984>, <-64.8725, 427.5818, 35.2816>, <-63.4588, 428.2175, 35.8871> }
					triangle { <-58.467, 420.5676, 32.2017>, <-64.8725, 427.5818, 35.2816>, <-62.323, 425.8819, 34.6984> }
					triangle { <-59.7953, 440.8653, 23.5728>, <-57.8907, 437.2836, 27.7075>, <-63.4588, 428.2175, 35.8871> }
					triangle { <-63.7931, 438.0506, 20.7812>, <-64.0981, 439.7261, 18.9924>, <-59.7953, 440.8653, 23.5728> }
					triangle { <-59.7953, 440.8653, 23.5728>, <-63.4588, 428.2175, 35.8871>, <-63.7931, 438.0506, 20.7812> }
					triangle { <-64.8725, 427.5818, 35.2816>, <-63.7931, 438.0506, 20.7812>, <-63.4588, 428.2175, 35.8871> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-34.5602, 381.4436, 20.7279>, <-34.9755, 383.6766, 20.9247>, 0.3 }
			cylinder { <-34.9755, 383.6766, 20.9247>, <-35.3908, 385.9097, 21.1214>, 0.3 }
			cylinder { <-35.3908, 385.9097, 21.1214>, <-35.8061, 388.1428, 21.3182>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-35.8061, 388.1428, 21.3182>, <-35.7139, 403.942, 23.5694>, 0.3 }
				cylinder { <-35.7139, 403.942, 23.5694>, <-32.6259, 419.3017, 26.608>, 0.3 }
				cylinder { <-32.6259, 419.3017, 26.608>, <-26.6608, 433.6318, 30.3171>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-26.6608, 433.6318, 30.3171>, <-24.8861, 435.2263, 30.1315>, <-23.3814, 439.7308, 31.4969> }
					triangle { <-24.8861, 435.2263, 30.1315>, <-21.687, 442.022, 31.6911>, <-23.3814, 439.7308, 31.4969> }
					triangle { <-21.687, 442.022, 31.6911>, <-22.9283, 442.5984, 32.6379>, <-23.3814, 439.7308, 31.4969> }
					triangle { <-23.3814, 439.7308, 31.4969>, <-22.9283, 442.5984, 32.6379>, <-26.6608, 433.6318, 30.3171> }
					triangle { <-21.687, 442.022, 31.6911>, <-11.6228, 436.3201, 38.7123>, <-9.8378, 436.881, 44.2686> }
					triangle { <-9.8378, 436.881, 44.2686>, <-12.9182, 437.404, 49.5565>, <-14.3515, 437.6046, 47.5551> }
					triangle { <-14.3515, 437.6046, 47.5551>, <-21.687, 442.022, 31.6911>, <-9.8378, 436.881, 44.2686> }
					triangle { <-21.687, 442.022, 31.6911>, <-14.3515, 437.6046, 47.5551>, <-22.9283, 442.5984, 32.6379> }
					triangle { <-24.7249, 440.0615, 32.3801>, <-26.9015, 435.7223, 31.4563>, <-26.6608, 433.6318, 30.3171> }
					triangle { <-24.7249, 440.0615, 32.3801>, <-24.3741, 442.6834, 33.4575>, <-26.9015, 435.7223, 31.4563> }
					triangle { <-24.7249, 440.0615, 32.3801>, <-22.9283, 442.5984, 32.6379>, <-24.3741, 442.6834, 33.4575> }
					triangle { <-26.6608, 433.6318, 30.3171>, <-22.9283, 442.5984, 32.6379>, <-24.7249, 440.0615, 32.3801> }
					triangle { <-19.01883, 439.1407, 50.3038>, <-23.267, 439.1859, 46.3666>, <-24.3741, 442.6834, 33.4575> }
					triangle { <-14.3515, 437.6046, 47.5551>, <-12.9182, 437.404, 49.5565>, <-19.01883, 439.1407, 50.3038> }
					triangle { <-19.01883, 439.1407, 50.3038>, <-24.3741, 442.6834, 33.4575>, <-14.3515, 437.6046, 47.5551> }
					triangle { <-22.9283, 442.5984, 32.6379>, <-14.3515, 437.6046, 47.5551>, <-24.3741, 442.6834, 33.4575> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-26.6608, 433.6318, 30.3171>, <-26.431, 435.9561, 29.7964>, <-24.4112, 440.2173, 31.2734> }
					triangle { <-26.431, 435.9561, 29.7964>, <-23.7467, 442.9951, 31.2443>, <-24.4112, 440.2173, 31.2734> }
					triangle { <-23.7467, 442.9951, 31.2443>, <-22.9283, 442.5984, 32.6379>, <-24.4112, 440.2173, 31.2734> }
					triangle { <-24.4112, 440.2173, 31.2734>, <-22.9283, 442.5984, 32.6379>, <-26.6608, 433.6318, 30.3171> }
					triangle { <-23.7467, 442.9951, 31.2443>, <-16.01481, 442.9554, 20.1397>, <-10.2356, 443.5044, 19.3188> }
					triangle { <-10.2356, 443.5044, 19.3188>, <-5.4045, 441.3033, 22.4074>, <-7.555, 440.9813, 23.5786> }
					triangle { <-7.555, 440.9813, 23.5786>, <-23.7467, 442.9951, 31.2443>, <-10.2356, 443.5044, 19.3188> }
					triangle { <-23.7467, 442.9951, 31.2443>, <-7.555, 440.9813, 23.5786>, <-22.9283, 442.5984, 32.6379> }
					triangle { <-23.6951, 439.575, 32.6035>, <-25.3567, 434.9925, 31.7915>, <-26.6608, 433.6318, 30.3171> }
					triangle { <-23.6951, 439.575, 32.6035>, <-22.3144, 441.7104, 33.9043>, <-25.3567, 434.9925, 31.7915> }
					triangle { <-23.6951, 439.575, 32.6035>, <-22.9283, 442.5984, 32.6379>, <-22.3144, 441.7104, 33.9043> }
					triangle { <-26.6608, 433.6318, 30.3171>, <-22.9283, 442.5984, 32.6379>, <-23.6951, 439.575, 32.6035> }
					triangle { <-5.3416, 439.1149, 28.4073>, <-9.8078, 437.3882, 31.6665>, <-22.3144, 441.7104, 33.9043> }
					triangle { <-7.555, 440.9813, 23.5786>, <-5.4045, 441.3033, 22.4074>, <-5.3416, 439.1149, 28.4073> }
					triangle { <-5.3416, 439.1149, 28.4073>, <-22.3144, 441.7104, 33.9043>, <-7.555, 440.9813, 23.5786> }
					triangle { <-22.9283, 442.5984, 32.6379>, <-7.555, 440.9813, 23.5786>, <-22.3144, 441.7104, 33.9043> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-26.6608, 433.6318, 30.3171>, <-26.9015, 435.7223, 31.4563>, <-24.7249, 440.0615, 32.3801> }
					triangle { <-26.9015, 435.7223, 31.4563>, <-24.3741, 442.6834, 33.4575>, <-24.7249, 440.0615, 32.3801> }
					triangle { <-24.3741, 442.6834, 33.4575>, <-22.9283, 442.5984, 32.6379>, <-24.7249, 440.0615, 32.3801> }
					triangle { <-24.7249, 440.0615, 32.3801>, <-22.9283, 442.5984, 32.6379>, <-26.6608, 433.6318, 30.3171> }
					triangle { <-24.3741, 442.6834, 33.4575>, <-34.2338, 448.8767, 26.5635>, <-34.1782, 452.7376, 22.1516> }
					triangle { <-34.1782, 452.7376, 22.1516>, <-30.6887, 453.1973, 17.1181>, <-29.869, 451.5227, 18.738> }
					triangle { <-29.869, 451.5227, 18.738>, <-24.3741, 442.6834, 33.4575>, <-34.1782, 452.7376, 22.1516> }
					triangle { <-24.3741, 442.6834, 33.4575>, <-29.869, 451.5227, 18.738>, <-22.9283, 442.5984, 32.6379> }
					triangle { <-23.3814, 439.7308, 31.4969>, <-24.8861, 435.2263, 30.1315>, <-26.6608, 433.6318, 30.3171> }
					triangle { <-23.3814, 439.7308, 31.4969>, <-21.687, 442.022, 31.6911>, <-24.8861, 435.2263, 30.1315> }
					triangle { <-23.3814, 439.7308, 31.4969>, <-22.9283, 442.5984, 32.6379>, <-21.687, 442.022, 31.6911> }
					triangle { <-26.6608, 433.6318, 30.3171>, <-22.9283, 442.5984, 32.6379>, <-23.3814, 439.7308, 31.4969> }
					triangle { <-24.9972, 450.478, 16.1165>, <-22.5896, 446.0108, 18.9091>, <-21.687, 442.022, 31.6911> }
					triangle { <-29.869, 451.5227, 18.738>, <-30.6887, 453.1973, 17.1181>, <-24.9972, 450.478, 16.1165> }
					triangle { <-24.9972, 450.478, 16.1165>, <-21.687, 442.022, 31.6911>, <-29.869, 451.5227, 18.738> }
					triangle { <-22.9283, 442.5984, 32.6379>, <-29.869, 451.5227, 18.738>, <-21.687, 442.022, 31.6911> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-26.6608, 433.6318, 30.3171>, <-25.3567, 434.9925, 31.7915>, <-23.6951, 439.575, 32.6035> }
					triangle { <-25.3567, 434.9925, 31.7915>, <-22.3144, 441.7104, 33.9043>, <-23.6951, 439.575, 32.6035> }
					triangle { <-22.3144, 441.7104, 33.9043>, <-22.9283, 442.5984, 32.6379>, <-23.6951, 439.575, 32.6035> }
					triangle { <-23.6951, 439.575, 32.6035>, <-22.9283, 442.5984, 32.6379>, <-26.6608, 433.6318, 30.3171> }
					triangle { <-22.3144, 441.7104, 33.9043>, <-29.8418, 442.2413, 45.1361>, <-33.7803, 446.1142, 47.1015> }
					triangle { <-33.7803, 446.1142, 47.1015>, <-38.2024, 449.2979, 44.2673>, <-36.6655, 448.146, 42.7145> }
					triangle { <-36.6655, 448.146, 42.7145>, <-22.3144, 441.7104, 33.9043>, <-33.7803, 446.1142, 47.1015> }
					triangle { <-22.3144, 441.7104, 33.9043>, <-36.6655, 448.146, 42.7145>, <-22.9283, 442.5984, 32.6379> }
					triangle { <-24.4112, 440.2173, 31.2734>, <-26.431, 435.9561, 29.7964>, <-26.6608, 433.6318, 30.3171> }
					triangle { <-24.4112, 440.2173, 31.2734>, <-23.7467, 442.9951, 31.2443>, <-26.431, 435.9561, 29.7964> }
					triangle { <-24.4112, 440.2173, 31.2734>, <-22.9283, 442.5984, 32.6379>, <-23.7467, 442.9951, 31.2443> }
					triangle { <-26.6608, 433.6318, 30.3171>, <-22.9283, 442.5984, 32.6379>, <-24.4112, 440.2173, 31.2734> }
					triangle { <-38.6743, 450.5038, 38.01307>, <-36.04887, 447.8086, 33.6092>, <-23.7467, 442.9951, 31.2443> }
					triangle { <-36.6655, 448.146, 42.7145>, <-38.2024, 449.2979, 44.2673>, <-38.6743, 450.5038, 38.01307> }
					triangle { <-38.6743, 450.5038, 38.01307>, <-23.7467, 442.9951, 31.2443>, <-36.6655, 448.146, 42.7145> }
					triangle { <-22.9283, 442.5984, 32.6379>, <-36.6655, 448.146, 42.7145>, <-23.7467, 442.9951, 31.2443> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-35.8061, 388.1428, 21.3182>, <-36.2214, 390.3758, 21.515>, 0.3 }
			cylinder { <-36.2214, 390.3758, 21.515>, <-36.6367, 392.6089, 21.7117>, 0.3 }
			cylinder { <-36.6367, 392.6089, 21.7117>, <-37.05202, 394.8419, 21.9085>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-37.05202, 394.8419, 21.9085>, <-41.5191, 410.107, 20.599>, 0.3 }
				cylinder { <-41.5191, 410.107, 20.599>, <-47.3747, 424.4189, 16.6528>, 0.3 }
				cylinder { <-47.3747, 424.4189, 16.6528>, <-54.3935, 437.2278, 10.2217>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-54.3935, 437.2278, 10.2217>, <-56.3106, 438.2111, 9.1805>, <-58.1382, 442.3847, 7.2675> }
					triangle { <-56.3106, 438.2111, 9.1805>, <-60.01785, 444.1381, 6.02213>, <-58.1382, 442.3847, 7.2675> }
					triangle { <-60.01785, 444.1381, 6.02213>, <-58.7853, 445.2425, 6.1976>, <-58.1382, 442.3847, 7.2675> }
					triangle { <-58.1382, 442.3847, 7.2675>, <-58.7853, 445.2425, 6.1976>, <-54.3935, 437.2278, 10.2217> }
					triangle { <-60.01785, 444.1381, 6.02213>, <-60.3657, 438.1889, -6.1262>, <-58.2892, 439.7566, -11.3802> }
					triangle { <-58.2892, 439.7566, -11.3802>, <-53.04403, 442.446, -13.1062>, <-53.4004, 442.4552, -10.6622> }
					triangle { <-53.4004, 442.4552, -10.6622>, <-60.01785, 444.1381, 6.02213>, <-58.2892, 439.7566, -11.3802> }
					triangle { <-60.01785, 444.1381, 6.02213>, <-53.4004, 442.4552, -10.6622>, <-58.7853, 445.2425, 6.1976> }
					triangle { <-56.7854, 443.2695, 7.5533>, <-54.2814, 439.5382, 9.6092>, <-54.3935, 437.2278, 10.2217> }
					triangle { <-56.7854, 443.2695, 7.5533>, <-57.3122, 445.9077, 6.5937>, <-54.2814, 439.5382, 9.6092> }
					triangle { <-56.7854, 443.2695, 7.5533>, <-58.7853, 445.2425, 6.1976>, <-57.3122, 445.9077, 6.5937> }
					triangle { <-54.3935, 437.2278, 10.2217>, <-58.7853, 445.2425, 6.1976>, <-56.7854, 443.2695, 7.5533> }
					triangle { <-49.0452, 445.8026, -9.4272>, <-48.6415, 445.857, -3.6493>, <-57.3122, 445.9077, 6.5937> }
					triangle { <-53.4004, 442.4552, -10.6622>, <-53.04403, 442.446, -13.1062>, <-49.0452, 445.8026, -9.4272> }
					triangle { <-49.0452, 445.8026, -9.4272>, <-57.3122, 445.9077, 6.5937>, <-53.4004, 442.4552, -10.6622> }
					triangle { <-58.7853, 445.2425, 6.1976>, <-53.4004, 442.4552, -10.6622>, <-57.3122, 445.9077, 6.5937> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-54.3935, 437.2278, 10.2217>, <-55.7354, 439.1892, 10.501>, <-57.7548, 443.0368, 8.1478> }
					triangle { <-55.7354, 439.1892, 10.501>, <-59.251, 445.4424, 7.7828>, <-57.7548, 443.0368, 8.1478> }
					triangle { <-59.251, 445.4424, 7.7828>, <-58.7853, 445.2425, 6.1976>, <-57.7548, 443.0368, 8.1478> }
					triangle { <-57.7548, 443.0368, 8.1478>, <-58.7853, 445.2425, 6.1976>, <-54.3935, 437.2278, 10.2217> }
					triangle { <-59.251, 445.4424, 7.7828>, <-71.5191, 440.4592, 10.5682>, <-76.1871, 439.2879, 7.2199> }
					triangle { <-76.1871, 439.2879, 7.2199>, <-76.7293, 436.8543, 1.6068>, <-74.4031, 437.414, 2.2195> }
					triangle { <-74.4031, 437.414, 2.2195>, <-59.251, 445.4424, 7.7828>, <-76.1871, 439.2879, 7.2199> }
					triangle { <-59.251, 445.4424, 7.7828>, <-74.4031, 437.414, 2.2195>, <-58.7853, 445.2425, 6.1976> }
					triangle { <-57.1688, 442.6174, 6.6729>, <-54.8565, 438.5601, 8.2887>, <-54.3935, 437.2278, 10.2217> }
					triangle { <-57.1688, 442.6174, 6.6729>, <-58.07914, 444.6035, 4.833>, <-54.8565, 438.5601, 8.2887> }
					triangle { <-57.1688, 442.6174, 6.6729>, <-58.7853, 445.2425, 6.1976>, <-58.07914, 444.6035, 4.833> }
					triangle { <-54.3935, 437.2278, 10.2217>, <-58.7853, 445.2425, 6.1976>, <-57.1688, 442.6174, 6.6729> }
					triangle { <-72.1833, 436.4217, -2.8584>, <-66.441, 436.824, -2.214>, <-58.07914, 444.6035, 4.833> }
					triangle { <-74.4031, 437.414, 2.2195>, <-76.7293, 436.8543, 1.6068>, <-72.1833, 436.4217, -2.8584> }
					triangle { <-72.1833, 436.4217, -2.8584>, <-58.07914, 444.6035, 4.833>, <-74.4031, 437.414, 2.2195> }
					triangle { <-58.7853, 445.2425, 6.1976>, <-74.4031, 437.414, 2.2195>, <-58.07914, 444.6035, 4.833> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-54.3935, 437.2278, 10.2217>, <-54.2814, 439.5382, 9.6092>, <-56.7854, 443.2695, 7.5533> }
					triangle { <-54.2814, 439.5382, 9.6092>, <-57.3122, 445.9077, 6.5937>, <-56.7854, 443.2695, 7.5533> }
					triangle { <-57.3122, 445.9077, 6.5937>, <-58.7853, 445.2425, 6.1976>, <-56.7854, 443.2695, 7.5533> }
					triangle { <-56.7854, 443.2695, 7.5533>, <-58.7853, 445.2425, 6.1976>, <-54.3935, 437.2278, 10.2217> }
					triangle { <-57.3122, 445.9077, 6.5937>, <-57.205, 452.2961, 18.5216>, <-61.4474, 454.6808, 21.7911> }
					triangle { <-61.4474, 454.6808, 21.7911>, <-67.1738, 452.8698, 23.07612>, <-66.09557, 451.5431, 21.2936> }
					triangle { <-66.09557, 451.5431, 21.2936>, <-57.3122, 445.9077, 6.5937>, <-61.4474, 454.6808, 21.7911> }
					triangle { <-57.3122, 445.9077, 6.5937>, <-66.09557, 451.5431, 21.2936>, <-58.7853, 445.2425, 6.1976> }
					triangle { <-58.1382, 442.3847, 7.2675>, <-56.3106, 438.2111, 9.1805>, <-54.3935, 437.2278, 10.2217> }
					triangle { <-58.1382, 442.3847, 7.2675>, <-60.01785, 444.1381, 6.02213>, <-56.3106, 438.2111, 9.1805> }
					triangle { <-58.1382, 442.3847, 7.2675>, <-58.7853, 445.2425, 6.1976>, <-60.01785, 444.1381, 6.02213> }
					triangle { <-54.3935, 437.2278, 10.2217>, <-58.7853, 445.2425, 6.1976>, <-58.1382, 442.3847, 7.2675> }
					triangle { <-70.6914, 448.6348, 19.8381>, <-68.9292, 444.628, 16.04467>, <-60.01785, 444.1381, 6.02213> }
					triangle { <-66.09557, 451.5431, 21.2936>, <-67.1738, 452.8698, 23.07612>, <-70.6914, 448.6348, 19.8381> }
					triangle { <-70.6914, 448.6348, 19.8381>, <-60.01785, 444.1381, 6.02213>, <-66.09557, 451.5431, 21.2936> }
					triangle { <-58.7853, 445.2425, 6.1976>, <-66.09557, 451.5431, 21.2936>, <-60.01785, 444.1381, 6.02213> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-54.3935, 437.2278, 10.2217>, <-54.8565, 438.5601, 8.2887>, <-57.1688, 442.6174, 6.6729> }
					triangle { <-54.8565, 438.5601, 8.2887>, <-58.07914, 444.6035, 4.833>, <-57.1688, 442.6174, 6.6729> }
					triangle { <-58.07914, 444.6035, 4.833>, <-58.7853, 445.2425, 6.1976>, <-57.1688, 442.6174, 6.6729> }
					triangle { <-57.1688, 442.6174, 6.6729>, <-58.7853, 445.2425, 6.1976>, <-54.3935, 437.2278, 10.2217> }
					triangle { <-58.07914, 444.6035, 4.833>, <-46.05167, 450.0258, 1.8271>, <-43.5494, 455.1495, 3.1909> }
					triangle { <-43.5494, 455.1495, 3.1909>, <-43.4885, 458.4615, 8.3631>, <-45.09284, 456.5842, 8.4118> }
					triangle { <-45.09284, 456.5842, 8.4118>, <-58.07914, 444.6035, 4.833>, <-43.5494, 455.1495, 3.1909> }
					triangle { <-58.07914, 444.6035, 4.833>, <-45.09284, 456.5842, 8.4118>, <-58.7853, 445.2425, 6.1976> }
					triangle { <-57.7548, 443.0368, 8.1478>, <-55.7354, 439.1892, 10.501>, <-54.3935, 437.2278, 10.2217> }
					triangle { <-57.7548, 443.0368, 8.1478>, <-59.251, 445.4424, 7.7828>, <-55.7354, 439.1892, 10.501> }
					triangle { <-57.7548, 443.0368, 8.1478>, <-58.7853, 445.2425, 6.1976>, <-59.251, 445.4424, 7.7828> }
					triangle { <-54.3935, 437.2278, 10.2217>, <-58.7853, 445.2425, 6.1976>, <-57.7548, 443.0368, 8.1478> }
					triangle { <-47.5532, 458.0157, 13.2693>, <-51.1297, 453.6609, 14.6094>, <-59.251, 445.4424, 7.7828> }
					triangle { <-45.09284, 456.5842, 8.4118>, <-43.4885, 458.4615, 8.3631>, <-47.5532, 458.0157, 13.2693> }
					triangle { <-47.5532, 458.0157, 13.2693>, <-59.251, 445.4424, 7.7828>, <-45.09284, 456.5842, 8.4118> }
					triangle { <-58.7853, 445.2425, 6.1976>, <-45.09284, 456.5842, 8.4118>, <-59.251, 445.4424, 7.7828> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-37.05202, 394.8419, 21.9085>, <-37.4673, 397.075, 22.1053>, 0.3 }
			cylinder { <-37.4673, 397.075, 22.1053>, <-37.8826, 399.3081, 22.3021>, 0.3 }
			cylinder { <-37.8826, 399.3081, 22.3021>, <-38.2979, 401.5411, 22.4988>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-38.2979, 401.5411, 22.4988>, <-41.698, 416.5021, 26.892>, 0.3 }
				cylinder { <-41.698, 416.5021, 26.892>, <-45.4604, 430.2176, 34.1322>, 0.3 }
				cylinder { <-45.4604, 430.2176, 34.1322>, <-49.4406, 442.1606, 43.9411>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-49.4406, 442.1606, 43.9411>, <-49.158, 443.2464, 45.9776>, <-50.6113, 446.9628, 48.6483> }
					triangle { <-49.158, 443.2464, 45.9776>, <-50.7544, 448.6814, 50.8229>, <-50.6113, 446.9628, 48.6483> }
					triangle { <-50.7544, 448.6814, 50.8229>, <-51.8606, 449.422, 49.9049>, <-50.6113, 446.9628, 48.6483> }
					triangle { <-50.6113, 446.9628, 48.6483>, <-51.8606, 449.422, 49.9049>, <-49.4406, 442.1606, 43.9411> }
					triangle { <-50.7544, 448.6814, 50.8229>, <-55.8343, 440.2135, 59.5043>, <-60.9927, 439.7434, 61.8763> }
					triangle { <-60.9927, 439.7434, 61.8763>, <-66.4951, 440.4321, 59.6702>, <-64.7647, 441.1679, 58.1788> }
					triangle { <-64.7647, 441.1679, 58.1788>, <-50.7544, 448.6814, 50.8229>, <-60.9927, 439.7434, 61.8763> }
					triangle { <-50.7544, 448.6814, 50.8229>, <-64.7647, 441.1679, 58.1788>, <-51.8606, 449.422, 49.9049> }
					triangle { <-51.6512, 447.5044, 47.5669>, <-50.7177, 444.0589, 44.3555>, <-49.4406, 442.1606, 43.9411> }
					triangle { <-51.6512, 447.5044, 47.5669>, <-52.8341, 449.7646, 48.6601>, <-50.7177, 444.0589, 44.3555> }
					triangle { <-51.6512, 447.5044, 47.5669>, <-51.8606, 449.422, 49.9049>, <-52.8341, 449.7646, 48.6601> }
					triangle { <-49.4406, 442.1606, 43.9411>, <-51.8606, 449.422, 49.9049>, <-51.6512, 447.5044, 47.5669> }
					triangle { <-68.09832, 443.4446, 54.4866>, <-64.8464, 444.9077, 50.132>, <-52.8341, 449.7646, 48.6601> }
					triangle { <-64.7647, 441.1679, 58.1788>, <-66.4951, 440.4321, 59.6702>, <-68.09832, 443.4446, 54.4866> }
					triangle { <-68.09832, 443.4446, 54.4866>, <-52.8341, 449.7646, 48.6601>, <-64.7647, 441.1679, 58.1788> }
					triangle { <-51.8606, 449.422, 49.9049>, <-64.7647, 441.1679, 58.1788>, <-52.8341, 449.7646, 48.6601> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-49.4406, 442.1606, 43.9411>, <-49.08125, 444.3343, 44.6842>, <-50.5602, 447.688, 47.786> }
					triangle { <-49.08125, 444.3343, 44.6842>, <-50.6521, 450.1318, 49.09846>, <-50.5602, 447.688, 47.786> }
					triangle { <-50.6521, 450.1318, 49.09846>, <-51.8606, 449.422, 49.9049>, <-50.5602, 447.688, 47.786> }
					triangle { <-50.5602, 447.688, 47.786>, <-51.8606, 449.422, 49.9049>, <-49.4406, 442.1606, 43.9411> }
					triangle { <-50.6521, 450.1318, 49.09846>, <-39.01705, 449.3737, 55.1753>, <-37.5497, 448.5852, 60.6233> }
					triangle { <-37.5497, 448.5852, 60.6233>, <-39.7565, 445.051, 64.8961>, <-41.1259, 445.1458, 62.9275> }
					triangle { <-41.1259, 445.1458, 62.9275>, <-50.6521, 450.1318, 49.09846>, <-37.5497, 448.5852, 60.6233> }
					triangle { <-50.6521, 450.1318, 49.09846>, <-41.1259, 445.1458, 62.9275>, <-51.8606, 449.422, 49.9049> }
					triangle { <-51.7023, 446.7792, 48.4291>, <-50.7945, 442.971, 45.6488>, <-49.4406, 442.1606, 43.9411> }
					triangle { <-51.7023, 446.7792, 48.4291>, <-52.9364, 448.3142, 50.3846>, <-50.7945, 442.971, 45.6488> }
					triangle { <-51.7023, 446.7792, 48.4291>, <-51.8606, 449.422, 49.9049>, <-52.9364, 448.3142, 50.3846> }
					triangle { <-49.4406, 442.1606, 43.9411>, <-51.8606, 449.422, 49.9049>, <-51.7023, 446.7792, 48.4291> }
					triangle { <-45.3547, 442.3749, 65.01777>, <-48.916, 441.4972, 60.7487>, <-52.9364, 448.3142, 50.3846> }
					triangle { <-41.1259, 445.1458, 62.9275>, <-39.7565, 445.051, 64.8961>, <-45.3547, 442.3749, 65.01777> }
					triangle { <-45.3547, 442.3749, 65.01777>, <-52.9364, 448.3142, 50.3846>, <-41.1259, 445.1458, 62.9275> }
					triangle { <-51.8606, 449.422, 49.9049>, <-41.1259, 445.1458, 62.9275>, <-52.9364, 448.3142, 50.3846> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-49.4406, 442.1606, 43.9411>, <-50.7177, 444.0589, 44.3555>, <-51.6512, 447.5044, 47.5669> }
					triangle { <-50.7177, 444.0589, 44.3555>, <-52.8341, 449.7646, 48.6601>, <-51.6512, 447.5044, 47.5669> }
					triangle { <-52.8341, 449.7646, 48.6601>, <-51.8606, 449.422, 49.9049>, <-51.6512, 447.5044, 47.5669> }
					triangle { <-51.6512, 447.5044, 47.5669>, <-51.8606, 449.422, 49.9049>, <-49.4406, 442.1606, 43.9411> }
					triangle { <-52.8341, 449.7646, 48.6601>, <-47.8868, 458.6304, 40.3055>, <-43.9218, 462.6814, 40.8746> }
					triangle { <-43.9218, 462.6814, 40.8746>, <-38.6846, 462.7886, 43.7343>, <-40.01723, 460.8591, 44.2453> }
					triangle { <-40.01723, 460.8591, 44.2453>, <-52.8341, 449.7646, 48.6601>, <-43.9218, 462.6814, 40.8746> }
					triangle { <-52.8341, 449.7646, 48.6601>, <-40.01723, 460.8591, 44.2453>, <-51.8606, 449.422, 49.9049> }
					triangle { <-50.6113, 446.9628, 48.6483>, <-49.158, 443.2464, 45.9776>, <-49.4406, 442.1606, 43.9411> }
					triangle { <-50.6113, 446.9628, 48.6483>, <-50.7544, 448.6814, 50.8229>, <-49.158, 443.2464, 45.9776> }
					triangle { <-50.6113, 446.9628, 48.6483>, <-51.8606, 449.422, 49.9049>, <-50.7544, 448.6814, 50.8229> }
					triangle { <-49.4406, 442.1606, 43.9411>, <-51.8606, 449.422, 49.9049>, <-50.6113, 446.9628, 48.6483> }
					triangle { <-36.8162, 458.9802, 48.2643>, <-38.8747, 453.9362, 49.6778>, <-50.7544, 448.6814, 50.8229> }
					triangle { <-40.01723, 460.8591, 44.2453>, <-38.6846, 462.7886, 43.7343>, <-36.8162, 458.9802, 48.2643> }
					triangle { <-36.8162, 458.9802, 48.2643>, <-50.7544, 448.6814, 50.8229>, <-40.01723, 460.8591, 44.2453> }
					triangle { <-51.8606, 449.422, 49.9049>, <-40.01723, 460.8591, 44.2453>, <-50.7544, 448.6814, 50.8229> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-49.4406, 442.1606, 43.9411>, <-50.7945, 442.971, 45.6488>, <-51.7023, 446.7792, 48.4291> }
					triangle { <-50.7945, 442.971, 45.6488>, <-52.9364, 448.3142, 50.3846>, <-51.7023, 446.7792, 48.4291> }
					triangle { <-52.9364, 448.3142, 50.3846>, <-51.8606, 449.422, 49.9049>, <-51.7023, 446.7792, 48.4291> }
					triangle { <-51.7023, 446.7792, 48.4291>, <-51.8606, 449.422, 49.9049>, <-49.4406, 442.1606, 43.9411> }
					triangle { <-52.9364, 448.3142, 50.3846>, <-64.7041, 449.4703, 44.6345>, <-67.3648, 453.8396, 42.1276> }
					triangle { <-67.3648, 453.8396, 42.1276>, <-65.4232, 458.1696, 38.5084>, <-63.656, 456.8813, 39.4966> }
					triangle { <-63.656, 456.8813, 39.4966>, <-52.9364, 448.3142, 50.3846>, <-67.3648, 453.8396, 42.1276> }
					triangle { <-52.9364, 448.3142, 50.3846>, <-63.656, 456.8813, 39.4966>, <-51.8606, 449.422, 49.9049> }
					triangle { <-50.5602, 447.688, 47.786>, <-49.08125, 444.3343, 44.6842>, <-49.4406, 442.1606, 43.9411> }
					triangle { <-50.5602, 447.688, 47.786>, <-50.6521, 450.1318, 49.09846>, <-49.08125, 444.3343, 44.6842> }
					triangle { <-50.5602, 447.688, 47.786>, <-51.8606, 449.422, 49.9049>, <-50.6521, 450.1318, 49.09846> }
					triangle { <-49.4406, 442.1606, 43.9411>, <-51.8606, 449.422, 49.9049>, <-50.5602, 447.688, 47.786> }
					triangle { <-59.5598, 460.0499, 37.7331>, <-54.8051, 457.3468, 39.06114>, <-50.6521, 450.1318, 49.09846> }
					triangle { <-63.656, 456.8813, 39.4966>, <-65.4232, 458.1696, 38.5084>, <-59.5598, 460.0499, 37.7331> }
					triangle { <-59.5598, 460.0499, 37.7331>, <-50.6521, 450.1318, 49.09846>, <-63.656, 456.8813, 39.4966> }
					triangle { <-51.8606, 449.422, 49.9049>, <-63.656, 456.8813, 39.4966>, <-50.6521, 450.1318, 49.09846> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-38.2979, 401.5411, 22.4988>, <-38.7132, 403.7742, 22.6956>, 0.3 }
			cylinder { <-38.7132, 403.7742, 22.6956>, <-39.1285, 406.0073, 22.8924>, 0.3 }
			cylinder { <-39.1285, 406.0073, 22.8924>, <-39.5438, 408.2403, 23.08918>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-39.5438, 408.2403, 23.08918>, <-39.9658, 424.1861, 22.5922>, 0.3 }
				cylinder { <-39.9658, 424.1861, 22.5922>, <-37.8865, 439.8333, 20.24>, 0.3 }
				cylinder { <-37.8865, 439.8333, 20.24>, <-33.3857, 454.5807, 16.123>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-33.3857, 454.5807, 16.123>, <-32.7471, 455.9554, 14.5978>, <-31.5386, 460.1544, 13.806> }
					triangle { <-32.7471, 455.9554, 14.5978>, <-30.7662, 462.2068, 12.4721>, <-31.5386, 460.1544, 13.806> }
					triangle { <-30.7662, 462.2068, 12.4721>, <-30.855, 462.8729, 13.8081>, <-31.5386, 460.1544, 13.806> }
					triangle { <-31.5386, 460.1544, 13.806>, <-30.855, 462.8729, 13.8081>, <-33.3857, 454.5807, 16.123> }
					triangle { <-30.7662, 462.2068, 12.4721>, <-19.609, 458.2803, 9.6516>, <-14.8068, 459.6729, 11.3124> }
					triangle { <-14.8068, 459.6729, 11.3124>, <-12.8512, 461.0005, 16.3>, <-15.06477, 460.8568, 16.2245> }
					triangle { <-15.06477, 460.8568, 16.2245>, <-30.7662, 462.2068, 12.4721>, <-14.8068, 459.6729, 11.3124> }
					triangle { <-30.7662, 462.2068, 12.4721>, <-15.06477, 460.8568, 16.2245>, <-30.855, 462.8729, 13.8081> }
					triangle { <-31.6967, 460.5933, 15.2054>, <-32.9843, 456.6137, 16.6969>, <-33.3857, 454.5807, 16.123> }
					triangle { <-31.6967, 460.5933, 15.2054>, <-31.0825, 463.0846, 15.2709>, <-32.9843, 456.6137, 16.6969> }
					triangle { <-31.6967, 460.5933, 15.2054>, <-30.855, 462.8729, 13.8081>, <-31.0825, 463.0846, 15.2709> }
					triangle { <-33.3857, 454.5807, 16.123>, <-30.855, 462.8729, 13.8081>, <-31.6967, 460.5933, 15.2054> }
					triangle { <-15.8872, 462.6721, 20.8748>, <-20.9793, 462.0843, 21.7796>, <-31.0825, 463.0846, 15.2709> }
					triangle { <-15.06477, 460.8568, 16.2245>, <-12.8512, 461.0005, 16.3>, <-15.8872, 462.6721, 20.8748> }
					triangle { <-15.8872, 462.6721, 20.8748>, <-31.0825, 463.0846, 15.2709>, <-15.06477, 460.8568, 16.2245> }
					triangle { <-30.855, 462.8729, 13.8081>, <-15.06477, 460.8568, 16.2245>, <-31.0825, 463.0846, 15.2709> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-33.3857, 454.5807, 16.123>, <-33.9205, 456.5499, 15.4449>, <-32.3209, 460.5508, 14.3708> }
					triangle { <-33.9205, 456.5499, 15.4449>, <-32.3307, 462.9995, 13.6016>, <-32.3209, 460.5508, 14.3708> }
					triangle { <-32.3307, 462.9995, 13.6016>, <-30.855, 462.8729, 13.8081>, <-32.3209, 460.5508, 14.3708> }
					triangle { <-32.3209, 460.5508, 14.3708>, <-30.855, 462.8729, 13.8081>, <-33.3857, 454.5807, 16.123> }
					triangle { <-32.3307, 462.9995, 13.6016>, <-35.8806, 461.1439, 2.1207>, <-33.3627, 461.4813, -2.4949> }
					triangle { <-33.3627, 461.4813, -2.4949>, <-28.2727, 460.0246, -4.05446>, <-28.5875, 459.9354, -1.8592> }
					triangle { <-28.5875, 459.9354, -1.8592>, <-32.3307, 462.9995, 13.6016>, <-33.3627, 461.4813, -2.4949> }
					triangle { <-32.3307, 462.9995, 13.6016>, <-28.5875, 459.9354, -1.8592>, <-30.855, 462.8729, 13.8081> }
					triangle { <-30.9145, 460.1969, 14.6407>, <-31.8109, 456.0191, 15.8497>, <-33.3857, 454.5807, 16.123> }
					triangle { <-30.9145, 460.1969, 14.6407>, <-29.518, 462.2918, 14.1414>, <-31.8109, 456.0191, 15.8497> }
					triangle { <-30.9145, 460.1969, 14.6407>, <-30.855, 462.8729, 13.8081>, <-29.518, 462.2918, 14.1414> }
					triangle { <-33.3857, 454.5807, 16.123>, <-30.855, 462.8729, 13.8081>, <-30.9145, 460.1969, 14.6407> }
					triangle { <-23.7526, 459.0633, -0.6506>, <-23.6921, 458.0771, 4.4597>, <-29.518, 462.2918, 14.1414> }
					triangle { <-28.5875, 459.9354, -1.8592>, <-28.2727, 460.0246, -4.05446>, <-23.7526, 459.0633, -0.6506> }
					triangle { <-23.7526, 459.0633, -0.6506>, <-29.518, 462.2918, 14.1414>, <-28.5875, 459.9354, -1.8592> }
					triangle { <-30.855, 462.8729, 13.8081>, <-28.5875, 459.9354, -1.8592>, <-29.518, 462.2918, 14.1414> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-33.3857, 454.5807, 16.123>, <-32.9843, 456.6137, 16.6969>, <-31.6967, 460.5933, 15.2054> }
					triangle { <-32.9843, 456.6137, 16.6969>, <-31.0825, 463.0846, 15.2709>, <-31.6967, 460.5933, 15.2054> }
					triangle { <-31.0825, 463.0846, 15.2709>, <-30.855, 462.8729, 13.8081>, <-31.6967, 460.5933, 15.2054> }
					triangle { <-31.6967, 460.5933, 15.2054>, <-30.855, 462.8729, 13.8081>, <-33.3857, 454.5807, 16.123> }
					triangle { <-31.0825, 463.0846, 15.2709>, <-42.1011, 467.4654, 17.9645>, <-45.6552, 470.1622, 15.1621> }
					triangle { <-45.6552, 470.1622, 15.1621>, <-47.3335, 469.7433, 9.9209>, <-45.5359, 468.5238, 10.3769> }
					triangle { <-45.5359, 468.5238, 10.3769>, <-31.0825, 463.0846, 15.2709>, <-45.6552, 470.1622, 15.1621> }
					triangle { <-31.0825, 463.0846, 15.2709>, <-45.5359, 468.5238, 10.3769>, <-30.855, 462.8729, 13.8081> }
					triangle { <-31.5386, 460.1544, 13.806>, <-32.7471, 455.9554, 14.5978>, <-33.3857, 454.5807, 16.123> }
					triangle { <-31.5386, 460.1544, 13.806>, <-30.7662, 462.2068, 12.4721>, <-32.7471, 455.9554, 14.5978> }
					triangle { <-31.5386, 460.1544, 13.806>, <-30.855, 462.8729, 13.8081>, <-30.7662, 462.2068, 12.4721> }
					triangle { <-33.3857, 454.5807, 16.123>, <-30.855, 462.8729, 13.8081>, <-31.5386, 460.1544, 13.806> }
					triangle { <-44.5748, 467.1629, 5.5997>, <-40.7308, 463.6614, 5.8365>, <-30.7662, 462.2068, 12.4721> }
					triangle { <-45.5359, 468.5238, 10.3769>, <-47.3335, 469.7433, 9.9209>, <-44.5748, 467.1629, 5.5997> }
					triangle { <-44.5748, 467.1629, 5.5997>, <-30.7662, 462.2068, 12.4721>, <-45.5359, 468.5238, 10.3769> }
					triangle { <-30.855, 462.8729, 13.8081>, <-45.5359, 468.5238, 10.3769>, <-30.7662, 462.2068, 12.4721> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-33.3857, 454.5807, 16.123>, <-31.8109, 456.0191, 15.8497>, <-30.9145, 460.1969, 14.6407> }
					triangle { <-31.8109, 456.0191, 15.8497>, <-29.518, 462.2918, 14.1414>, <-30.9145, 460.1969, 14.6407> }
					triangle { <-29.518, 462.2918, 14.1414>, <-30.855, 462.8729, 13.8081>, <-30.9145, 460.1969, 14.6407> }
					triangle { <-30.9145, 460.1969, 14.6407>, <-30.855, 462.8729, 13.8081>, <-33.3857, 454.5807, 16.123> }
					triangle { <-29.518, 462.2918, 14.1414>, <-25.8294, 464.6019, 25.4955>, <-27.09933, 468.3537, 28.9695> }
					triangle { <-27.09933, 468.3537, 28.9695>, <-31.912, 470.7191, 30.2753>, <-32.01326, 469.4453, 28.4607> }
					triangle { <-32.01326, 469.4453, 28.4607>, <-29.518, 462.2918, 14.1414>, <-27.09933, 468.3537, 28.9695> }
					triangle { <-29.518, 462.2918, 14.1414>, <-32.01326, 469.4453, 28.4607>, <-30.855, 462.8729, 13.8081> }
					triangle { <-32.3209, 460.5508, 14.3708>, <-33.9205, 456.5499, 15.4449>, <-33.3857, 454.5807, 16.123> }
					triangle { <-32.3209, 460.5508, 14.3708>, <-32.3307, 462.9995, 13.6016>, <-33.9205, 456.5499, 15.4449> }
					triangle { <-32.3209, 460.5508, 14.3708>, <-30.855, 462.8729, 13.8081>, <-32.3307, 462.9995, 13.6016> }
					triangle { <-33.3857, 454.5807, 16.123>, <-30.855, 462.8729, 13.8081>, <-32.3209, 460.5508, 14.3708> }
					triangle { <-36.7094, 470.7718, 27.1253>, <-38.01794, 467.6687, 23.1564>, <-32.3307, 462.9995, 13.6016> }
					triangle { <-32.01326, 469.4453, 28.4607>, <-31.912, 470.7191, 30.2753>, <-36.7094, 470.7718, 27.1253> }
					triangle { <-36.7094, 470.7718, 27.1253>, <-32.3307, 462.9995, 13.6016>, <-32.01326, 469.4453, 28.4607> }
					triangle { <-30.855, 462.8729, 13.8081>, <-32.01326, 469.4453, 28.4607>, <-32.3307, 462.9995, 13.6016> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-39.5438, 408.2403, 23.08918>, <-39.9591, 410.4734, 23.2859>, 0.3 }
			cylinder { <-39.9591, 410.4734, 23.2859>, <-40.3744, 412.7065, 23.4827>, 0.3 }
			cylinder { <-40.3744, 412.7065, 23.4827>, <-40.7897, 414.9395, 23.6794>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-40.7897, 414.9395, 23.6794>, <-46.692, 429.73, 24.7265>, 0.3 }
				cylinder { <-46.692, 429.73, 24.7265>, <-55.3627, 443.1111, 25.4029>, 0.3 }
				cylinder { <-55.3627, 443.1111, 25.4029>, <-66.4685, 454.5685, 25.6827>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-66.4685, 454.5685, 25.6827>, <-68.1611, 455.1951, 26.311>, <-70.7139, 458.2019, 26.1801> }
					triangle { <-68.1611, 455.1951, 26.311>, <-72.6025, 459.4039, 26.6181>, <-70.7139, 458.2019, 26.1801> }
					triangle { <-72.6025, 459.4039, 26.6181>, <-72.01833, 460.2939, 25.8225>, <-70.7139, 458.2019, 26.1801> }
					triangle { <-70.7139, 458.2019, 26.1801>, <-72.01833, 460.2939, 25.8225>, <-66.4685, 454.5685, 25.6827> }
					triangle { <-72.6025, 459.4039, 26.6181>, <-79.6707, 452.9804, 21.5625>, <-82.1121, 453.4499, 17.5947> }
					triangle { <-82.1121, 453.4499, 17.5947>, <-80.94, 455.3018, 13.2064>, <-79.5913, 455.6621, 14.5999> }
					triangle { <-79.5913, 455.6621, 14.5999>, <-72.6025, 459.4039, 26.6181>, <-82.1121, 453.4499, 17.5947> }
					triangle { <-72.6025, 459.4039, 26.6181>, <-79.5913, 455.6621, 14.5999>, <-72.01833, 460.2939, 25.8225> }
					triangle { <-69.9776, 458.9351, 25.3807>, <-67.05678, 456.2948, 25.1119>, <-66.4685, 454.5685, 25.6827> }
					triangle { <-69.9776, 458.9351, 25.3807>, <-71.13, 460.8702, 25.01932>, <-67.05678, 456.2948, 25.1119> }
					triangle { <-69.9776, 458.9351, 25.3807>, <-72.01833, 460.2939, 25.8225>, <-71.13, 460.8702, 25.01932> }
					triangle { <-66.4685, 454.5685, 25.6827>, <-72.01833, 460.2939, 25.8225>, <-69.9776, 458.9351, 25.3807> }
					triangle { <-77.08121, 458.4598, 12.1321>, <-73.29, 459.3344, 14.6344>, <-71.13, 460.8702, 25.01932> }
					triangle { <-79.5913, 455.6621, 14.5999>, <-80.94, 455.3018, 13.2064>, <-77.08121, 458.4598, 12.1321> }
					triangle { <-77.08121, 458.4598, 12.1321>, <-71.13, 460.8702, 25.01932>, <-79.5913, 455.6621, 14.5999> }
					triangle { <-72.01833, 460.2939, 25.8225>, <-79.5913, 455.6621, 14.5999>, <-71.13, 460.8702, 25.01932> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-66.4685, 454.5685, 25.6827>, <-67.1688, 456.1525, 26.4905>, <-70.05242, 458.8401, 26.2997> }
					triangle { <-67.1688, 456.1525, 26.4905>, <-71.2795, 460.6805, 26.8574>, <-70.05242, 458.8401, 26.2997> }
					triangle { <-71.2795, 460.6805, 26.8574>, <-72.01833, 460.2939, 25.8225>, <-70.05242, 458.8401, 26.2997> }
					triangle { <-70.05242, 458.8401, 26.2997>, <-72.01833, 460.2939, 25.8225>, <-66.4685, 454.5685, 25.6827> }
					triangle { <-71.2795, 460.6805, 26.8574>, <-74.9485, 457.1952, 36.4058>, <-79.1737, 455.803, 37.8664> }
					triangle { <-79.1737, 455.803, 37.8664>, <-82.6607, 453.0835, 35.7438>, <-81.2105, 453.6063, 34.5133> }
					triangle { <-81.2105, 453.6063, 34.5133>, <-71.2795, 460.6805, 26.8574>, <-79.1737, 455.803, 37.8664> }
					triangle { <-71.2795, 460.6805, 26.8574>, <-81.2105, 453.6063, 34.5133>, <-72.01833, 460.2939, 25.8225> }
					triangle { <-70.6391, 458.2968, 25.261>, <-68.04902, 455.3374, 24.9323>, <-66.4685, 454.5685, 25.6827> }
					triangle { <-70.6391, 458.2968, 25.261>, <-72.453, 459.5937, 24.7799>, <-68.04902, 455.3374, 24.9323> }
					triangle { <-70.6391, 458.2968, 25.261>, <-72.01833, 460.2939, 25.8225>, <-72.453, 459.5937, 24.7799> }
					triangle { <-66.4685, 454.5685, 25.6827>, <-72.01833, 460.2939, 25.8225>, <-70.6391, 458.2968, 25.261> }
					triangle { <-83.1832, 452.0899, 30.7682>, <-80.03378, 452.4859, 27.4032>, <-72.453, 459.5937, 24.7799> }
					triangle { <-81.2105, 453.6063, 34.5133>, <-82.6607, 453.0835, 35.7438>, <-83.1832, 452.0899, 30.7682> }
					triangle { <-83.1832, 452.0899, 30.7682>, <-72.453, 459.5937, 24.7799>, <-81.2105, 453.6063, 34.5133> }
					triangle { <-72.01833, 460.2939, 25.8225>, <-81.2105, 453.6063, 34.5133>, <-72.453, 459.5937, 24.7799> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-66.4685, 454.5685, 25.6827>, <-67.05678, 456.2948, 25.1119>, <-69.9776, 458.9351, 25.3807> }
					triangle { <-67.05678, 456.2948, 25.1119>, <-71.13, 460.8702, 25.01932>, <-69.9776, 458.9351, 25.3807> }
					triangle { <-71.13, 460.8702, 25.01932>, <-72.01833, 460.2939, 25.8225>, <-69.9776, 458.9351, 25.3807> }
					triangle { <-69.9776, 458.9351, 25.3807>, <-72.01833, 460.2939, 25.8225>, <-66.4685, 454.5685, 25.6827> }
					triangle { <-71.13, 460.8702, 25.01932>, <-64.3659, 467.6075, 30.0826>, <-64.6613, 469.9615, 34.1193> }
					triangle { <-64.6613, 469.9615, 34.1193>, <-66.4416, 468.737, 38.5229>, <-66.8781, 467.4355, 37.1064> }
					triangle { <-66.8781, 467.4355, 37.1064>, <-71.13, 460.8702, 25.01932>, <-64.6613, 469.9615, 34.1193> }
					triangle { <-71.13, 460.8702, 25.01932>, <-66.8781, 467.4355, 37.1064>, <-72.01833, 460.2939, 25.8225> }
					triangle { <-70.7139, 458.2019, 26.1801>, <-68.1611, 455.1951, 26.311>, <-66.4685, 454.5685, 25.6827> }
					triangle { <-70.7139, 458.2019, 26.1801>, <-72.6025, 459.4039, 26.6181>, <-68.1611, 455.1951, 26.311> }
					triangle { <-70.7139, 458.2019, 26.1801>, <-72.01833, 460.2939, 25.8225>, <-72.6025, 459.4039, 26.6181> }
					triangle { <-66.4685, 454.5685, 25.6827>, <-72.01833, 460.2939, 25.8225>, <-70.7139, 458.2019, 26.1801> }
					triangle { <-69.6922, 464.9516, 39.5818>, <-70.7465, 461.2534, 37.0107>, <-72.6025, 459.4039, 26.6181> }
					triangle { <-66.8781, 467.4355, 37.1064>, <-66.4416, 468.737, 38.5229>, <-69.6922, 464.9516, 39.5818> }
					triangle { <-69.6922, 464.9516, 39.5818>, <-72.6025, 459.4039, 26.6181>, <-66.8781, 467.4355, 37.1064> }
					triangle { <-72.01833, 460.2939, 25.8225>, <-66.8781, 467.4355, 37.1064>, <-72.6025, 459.4039, 26.6181> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-66.4685, 454.5685, 25.6827>, <-68.04902, 455.3374, 24.9323>, <-70.6391, 458.2968, 25.261> }
					triangle { <-68.04902, 455.3374, 24.9323>, <-72.453, 459.5937, 24.7799>, <-70.6391, 458.2968, 25.261> }
					triangle { <-72.453, 459.5937, 24.7799>, <-72.01833, 460.2939, 25.8225>, <-70.6391, 458.2968, 25.261> }
					triangle { <-70.6391, 458.2968, 25.261>, <-72.01833, 460.2939, 25.8225>, <-66.4685, 454.5685, 25.6827> }
					triangle { <-72.453, 459.5937, 24.7799>, <-69.08814, 463.3927, 15.2392>, <-67.5997, 467.6084, 13.8476> }
					triangle { <-67.5997, 467.6084, 13.8476>, <-64.7209, 470.9553, 15.9855>, <-65.2588, 469.4914, 17.193> }
					triangle { <-65.2588, 469.4914, 17.193>, <-72.453, 459.5937, 24.7799>, <-67.5997, 467.6084, 13.8476> }
					triangle { <-72.453, 459.5937, 24.7799>, <-65.2588, 469.4914, 17.193>, <-72.01833, 460.2939, 25.8225> }
					triangle { <-70.05242, 458.8401, 26.2997>, <-67.1688, 456.1525, 26.4905>, <-66.4685, 454.5685, 25.6827> }
					triangle { <-70.05242, 458.8401, 26.2997>, <-71.2795, 460.6805, 26.8574>, <-67.1688, 456.1525, 26.4905> }
					triangle { <-70.05242, 458.8401, 26.2997>, <-72.01833, 460.2939, 25.8225>, <-71.2795, 460.6805, 26.8574> }
					triangle { <-66.4685, 454.5685, 25.6827>, <-72.01833, 460.2939, 25.8225>, <-70.05242, 458.8401, 26.2997> }
					triangle { <-63.5902, 471.3215, 20.9458>, <-64.00286, 468.102, 24.2418>, <-71.2795, 460.6805, 26.8574> }
					triangle { <-65.2588, 469.4914, 17.193>, <-64.7209, 470.9553, 15.9855>, <-63.5902, 471.3215, 20.9458> }
					triangle { <-63.5902, 471.3215, 20.9458>, <-71.2795, 460.6805, 26.8574>, <-65.2588, 469.4914, 17.193> }
					triangle { <-72.01833, 460.2939, 25.8225>, <-65.2588, 469.4914, 17.193>, <-71.2795, 460.6805, 26.8574> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-40.7897, 414.9395, 23.6794>, <-41.205, 417.1726, 23.8762>, 0.3 }
			cylinder { <-41.205, 417.1726, 23.8762>, <-41.6203, 419.4056, 24.07303>, 0.3 }
			cylinder { <-41.6203, 419.4056, 24.07303>, <-42.03564, 421.6387, 24.2698>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-42.03564, 421.6387, 24.2698>, <-42.7947, 437.1564, 27.9189>, 0.3 }
				cylinder { <-42.7947, 437.1564, 27.9189>, <-41.3767, 451.964, 33.6996>, 0.3 }
				cylinder { <-41.3767, 451.964, 33.6996>, <-37.836, 465.4924, 41.3896>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-37.836, 465.4924, 41.3896>, <-36.6801, 466.524, 42.01763>, <-36.1961, 469.5016, 43.6963> }
					triangle { <-36.6801, 466.524, 42.01763>, <-35.2134, 470.9994, 44.5754>, <-36.1961, 469.5016, 43.6963> }
					triangle { <-35.2134, 470.9994, 44.5754>, <-36.2883, 471.4062, 44.7513>, <-36.1961, 469.5016, 43.6963> }
					triangle { <-36.1961, 469.5016, 43.6963>, <-36.2883, 471.4062, 44.7513>, <-37.836, 465.4924, 41.3896> }
					triangle { <-35.2134, 470.9994, 44.5754>, <-31.7061, 466.148, 51.8918>, <-32.5865, 466.1339, 55.892> }
					triangle { <-32.5865, 466.1339, 55.892>, <-36.304, 466.3457, 58.02441>, <-36.4578, 466.669, 56.3364> }
					triangle { <-36.4578, 466.669, 56.3364>, <-35.2134, 470.9994, 44.5754>, <-32.5865, 466.1339, 55.892> }
					triangle { <-35.2134, 470.9994, 44.5754>, <-36.4578, 466.669, 56.3364>, <-36.2883, 471.4062, 44.7513> }
					triangle { <-37.3133, 469.7464, 43.7801>, <-38.3559, 466.8912, 42.1432>, <-37.836, 465.4924, 41.3896> }
					triangle { <-37.3133, 469.7464, 43.7801>, <-37.4479, 471.489, 44.7429>, <-38.3559, 466.8912, 42.1432> }
					triangle { <-37.3133, 469.7464, 43.7801>, <-36.2883, 471.4062, 44.7513>, <-37.4479, 471.489, 44.7429> }
					triangle { <-37.836, 465.4924, 41.3896>, <-36.2883, 471.4062, 44.7513>, <-37.3133, 469.7464, 43.7801> }
					triangle { <-40.2209, 467.8066, 56.4643>, <-41.3887, 468.2696, 52.6176>, <-37.4479, 471.489, 44.7429> }
					triangle { <-36.4578, 466.669, 56.3364>, <-36.304, 466.3457, 58.02441>, <-40.2209, 467.8066, 56.4643> }
					triangle { <-40.2209, 467.8066, 56.4643>, <-37.4479, 471.489, 44.7429>, <-36.4578, 466.669, 56.3364> }
					triangle { <-36.2883, 471.4062, 44.7513>, <-36.4578, 466.669, 56.3364>, <-37.4479, 471.489, 44.7429> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-37.836, 465.4924, 41.3896>, <-37.4828, 467.1253, 41.3294>, <-36.7312, 469.9024, 43.2375> }
					triangle { <-37.4828, 467.1253, 41.3294>, <-36.2837, 471.8011, 43.6578>, <-36.7312, 469.9024, 43.2375> }
					triangle { <-36.2837, 471.8011, 43.6578>, <-36.2883, 471.4062, 44.7513>, <-36.7312, 469.9024, 43.2375> }
					triangle { <-36.7312, 469.9024, 43.2375>, <-36.2883, 471.4062, 44.7513>, <-37.836, 465.4924, 41.3896> }
					triangle { <-36.2837, 471.8011, 43.6578>, <-27.7016, 472.03, 39.7004>, <-23.9221, 472.1765, 41.2725> }
					triangle { <-23.9221, 472.1765, 41.2725>, <-22.1318, 470.2361, 44.655>, <-23.8457, 470.0504, 44.5808> }
					triangle { <-23.8457, 470.0504, 44.5808>, <-36.2837, 471.8011, 43.6578>, <-23.9221, 472.1765, 41.2725> }
					triangle { <-36.2837, 471.8011, 43.6578>, <-23.8457, 470.0504, 44.5808>, <-36.2883, 471.4062, 44.7513> }
					triangle { <-36.7782, 469.3455, 44.2389>, <-37.5532, 466.2899, 42.8314>, <-37.836, 465.4924, 41.3896> }
					triangle { <-36.7782, 469.3455, 44.2389>, <-36.3776, 470.6873, 45.6606>, <-37.5532, 466.2899, 42.8314> }
					triangle { <-36.7782, 469.3455, 44.2389>, <-36.2883, 471.4062, 44.7513>, <-36.3776, 470.6873, 45.6606> }
					triangle { <-37.836, 465.4924, 41.3896>, <-36.2883, 471.4062, 44.7513>, <-36.7782, 469.3455, 44.2389> }
					triangle { <-24.243, 468.3708, 48.1152>, <-28.1086, 467.2033, 48.3791>, <-36.3776, 470.6873, 45.6606> }
					triangle { <-23.8457, 470.0504, 44.5808>, <-22.1318, 470.2361, 44.655>, <-24.243, 468.3708, 48.1152> }
					triangle { <-24.243, 468.3708, 48.1152>, <-36.3776, 470.6873, 45.6606>, <-23.8457, 470.0504, 44.5808> }
					triangle { <-36.2883, 471.4062, 44.7513>, <-23.8457, 470.0504, 44.5808>, <-36.3776, 470.6873, 45.6606> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-37.836, 465.4924, 41.3896>, <-38.3559, 466.8912, 42.1432>, <-37.3133, 469.7464, 43.7801> }
					triangle { <-38.3559, 466.8912, 42.1432>, <-37.4479, 471.489, 44.7429>, <-37.3133, 469.7464, 43.7801> }
					triangle { <-37.4479, 471.489, 44.7429>, <-36.2883, 471.4062, 44.7513>, <-37.3133, 469.7464, 43.7801> }
					triangle { <-37.3133, 469.7464, 43.7801>, <-36.2883, 471.4062, 44.7513>, <-37.836, 465.4924, 41.3896> }
					triangle { <-37.4479, 471.489, 44.7429>, <-40.8704, 476.6644, 37.6108>, <-39.2268, 479.595, 35.2683> }
					triangle { <-39.2268, 479.595, 35.2683>, <-35.3396, 480.0313, 33.5044>, <-35.4402, 478.7358, 34.6398> }
					triangle { <-35.4402, 478.7358, 34.6398>, <-37.4479, 471.489, 44.7429>, <-39.2268, 479.595, 35.2683> }
					triangle { <-37.4479, 471.489, 44.7429>, <-35.4402, 478.7358, 34.6398>, <-36.2883, 471.4062, 44.7513> }
					triangle { <-36.1961, 469.5016, 43.6963>, <-36.6801, 466.524, 42.01763>, <-37.836, 465.4924, 41.3896> }
					triangle { <-36.1961, 469.5016, 43.6963>, <-35.2134, 470.9994, 44.5754>, <-36.6801, 466.524, 42.01763> }
					triangle { <-36.1961, 469.5016, 43.6963>, <-36.2883, 471.4062, 44.7513>, <-35.2134, 470.9994, 44.5754> }
					triangle { <-37.836, 465.4924, 41.3896>, <-36.2883, 471.4062, 44.7513>, <-36.1961, 469.5016, 43.6963> }
					triangle { <-31.5923, 477.9222, 34.6961>, <-31.1878, 474.5428, 36.885>, <-35.2134, 470.9994, 44.5754> }
					triangle { <-35.4402, 478.7358, 34.6398>, <-35.3396, 480.0313, 33.5044>, <-31.5923, 477.9222, 34.6961> }
					triangle { <-31.5923, 477.9222, 34.6961>, <-35.2134, 470.9994, 44.5754>, <-35.4402, 478.7358, 34.6398> }
					triangle { <-36.2883, 471.4062, 44.7513>, <-35.4402, 478.7358, 34.6398>, <-35.2134, 470.9994, 44.5754> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-37.836, 465.4924, 41.3896>, <-37.5532, 466.2899, 42.8314>, <-36.7782, 469.3455, 44.2389> }
					triangle { <-37.5532, 466.2899, 42.8314>, <-36.3776, 470.6873, 45.6606>, <-36.7782, 469.3455, 44.2389> }
					triangle { <-36.3776, 470.6873, 45.6606>, <-36.2883, 471.4062, 44.7513>, <-36.7782, 469.3455, 44.2389> }
					triangle { <-36.7782, 469.3455, 44.2389>, <-36.2883, 471.4062, 44.7513>, <-37.836, 465.4924, 41.3896> }
					triangle { <-36.3776, 470.6873, 45.6606>, <-44.8749, 470.7824, 49.8022>, <-47.8911, 473.5524, 49.8879> }
					triangle { <-47.8911, 473.5524, 49.8879>, <-49.5118, 476.1408, 46.8737>, <-48.05241, 475.3544, 46.3954> }
					triangle { <-48.05241, 475.3544, 46.3954>, <-36.3776, 470.6873, 45.6606>, <-47.8911, 473.5524, 49.8879> }
					triangle { <-36.3776, 470.6873, 45.6606>, <-48.05241, 475.3544, 46.3954>, <-36.2883, 471.4062, 44.7513> }
					triangle { <-36.7312, 469.9024, 43.2375>, <-37.4828, 467.1253, 41.3294>, <-37.836, 465.4924, 41.3896> }
					triangle { <-36.7312, 469.9024, 43.2375>, <-36.2837, 471.8011, 43.6578>, <-37.4828, 467.1253, 41.3294> }
					triangle { <-36.7312, 469.9024, 43.2375>, <-36.2883, 471.4062, 44.7513>, <-36.2837, 471.8011, 43.6578> }
					triangle { <-37.836, 465.4924, 41.3896>, <-36.2883, 471.4062, 44.7513>, <-36.7312, 469.9024, 43.2375> }
					triangle { <-47.5702, 477.3581, 43.04517>, <-44.4679, 475.6092, 41.1235>, <-36.2837, 471.8011, 43.6578> }
					triangle { <-48.05241, 475.3544, 46.3954>, <-49.5118, 476.1408, 46.8737>, <-47.5702, 477.3581, 43.04517> }
					triangle { <-47.5702, 477.3581, 43.04517>, <-36.2837, 471.8011, 43.6578>, <-48.05241, 475.3544, 46.3954> }
					triangle { <-36.2883, 471.4062, 44.7513>, <-48.05241, 475.3544, 46.3954>, <-36.2837, 471.8011, 43.6578> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-42.03564, 421.6387, 24.2698>, <-42.4509, 423.8718, 24.4665>, 0.3 }
			cylinder { <-42.4509, 423.8718, 24.4665>, <-42.8662, 426.1048, 24.6633>, 0.3 }
			cylinder { <-42.8662, 426.1048, 24.6633>, <-43.2815, 428.3379, 24.8601>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-43.2815, 428.3379, 24.8601>, <-46.182, 443.9332, 23.1091>, 0.3 }
				cylinder { <-46.182, 443.9332, 23.1091>, <-48.9645, 458.8929, 18.2972>, 0.3 }
				cylinder { <-48.9645, 458.8929, 18.2972>, <-51.5219, 472.6423, 10.6092>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-51.5219, 472.6423, 10.6092>, <-52.1852, 473.3584, 9.5608>, <-52.5021, 476.0122, 8.2929> }
					triangle { <-52.1852, 473.3584, 9.5608>, <-53.0756, 477.1952, 7.1995>, <-52.5021, 476.0122, 8.2929> }
					triangle { <-53.0756, 477.1952, 7.1995>, <-52.4799, 477.7924, 7.7295>, <-52.5021, 476.0122, 8.2929> }
					triangle { <-52.5021, 476.0122, 8.2929>, <-52.4799, 477.7924, 7.7295>, <-51.5219, 472.6423, 10.6092> }
					triangle { <-53.0756, 477.1952, 7.1995>, <-49.6445, 474.2625, 0.4733>, <-46.9638, 475.3656, -1.5053> }
					triangle { <-46.9638, 475.3656, -1.5053>, <-43.7027, 476.8315, -0.6484>, <-44.6265, 476.7324, 0.5016> }
					triangle { <-44.6265, 476.7324, 0.5016>, <-53.0756, 477.1952, 7.1995>, <-46.9638, 475.3656, -1.5053> }
					triangle { <-53.0756, 477.1952, 7.1995>, <-44.6265, 476.7324, 0.5016>, <-52.4799, 477.7924, 7.7295> }
					triangle { <-51.8802, 476.4684, 8.9018>, <-51.2523, 474.0426, 10.4741>, <-51.5219, 472.6423, 10.6092> }
					triangle { <-51.8802, 476.4684, 8.9018>, <-51.8317, 478.1074, 8.4172>, <-51.2523, 474.0426, 10.4741> }
					triangle { <-51.8802, 476.4684, 8.9018>, <-52.4799, 477.7924, 7.7295>, <-51.8317, 478.1074, 8.4172> }
					triangle { <-51.5219, 472.6423, 10.6092>, <-52.4799, 477.7924, 7.7295>, <-51.8802, 476.4684, 8.9018> }
					triangle { <-42.7139, 478.4825, 2.6552>, <-44.2543, 478.2157, 5.7502>, <-51.8317, 478.1074, 8.4172> }
					triangle { <-44.6265, 476.7324, 0.5016>, <-43.7027, 476.8315, -0.6484>, <-42.7139, 478.4825, 2.6552> }
					triangle { <-42.7139, 478.4825, 2.6552>, <-51.8317, 478.1074, 8.4172>, <-44.6265, 476.7324, 0.5016> }
					triangle { <-52.4799, 477.7924, 7.7295>, <-44.6265, 476.7324, 0.5016>, <-51.8317, 478.1074, 8.4172> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-51.5219, 472.6423, 10.6092>, <-52.277, 473.8521, 10.4741>, <-52.5633, 476.3413, 8.9018> }
					triangle { <-52.277, 473.8521, 10.4741>, <-53.1979, 477.8533, 8.4173>, <-52.5633, 476.3413, 8.9018> }
					triangle { <-53.1979, 477.8533, 8.4173>, <-52.4799, 477.7924, 7.7295>, <-52.5633, 476.3413, 8.9018> }
					triangle { <-52.5633, 476.3413, 8.9018>, <-52.4799, 477.7924, 7.7295>, <-51.5219, 472.6423, 10.6092> }
					triangle { <-53.1979, 477.8533, 8.4173>, <-60.4318, 475.2637, 5.8524>, <-61.8413, 474.9251, 2.656> }
					triangle { <-61.8413, 474.9251, 2.656>, <-60.4494, 473.7737, -0.5462>, <-59.4275, 473.9797, 0.5022> }
					triangle { <-59.4275, 473.9797, 0.5022>, <-53.1979, 477.8533, 8.4173>, <-61.8413, 474.9251, 2.656> }
					triangle { <-53.1979, 477.8533, 8.4173>, <-59.4275, 473.9797, 0.5022>, <-52.4799, 477.7924, 7.7295> }
					triangle { <-51.819, 476.1393, 8.2929>, <-51.1605, 473.549, 9.5608>, <-51.5219, 472.6423, 10.6092> }
					triangle { <-51.819, 476.1393, 8.2929>, <-51.7093, 477.4492, 7.1994>, <-51.1605, 473.549, 9.5608> }
					triangle { <-51.819, 476.1393, 8.2929>, <-52.4799, 477.7924, 7.7295>, <-51.7093, 477.4492, 7.1994> }
					triangle { <-51.5219, 472.6423, 10.6092>, <-52.4799, 477.7924, 7.7295>, <-51.819, 476.1393, 8.2929> }
					triangle { <-56.7553, 473.5445, -1.5049>, <-53.9811, 473.5127, 0.575>, <-51.7093, 477.4492, 7.1994> }
					triangle { <-59.4275, 473.9797, 0.5022>, <-60.4494, 473.7737, -0.5462>, <-56.7553, 473.5445, -1.5049> }
					triangle { <-56.7553, 473.5445, -1.5049>, <-51.7093, 477.4492, 7.1994>, <-59.4275, 473.9797, 0.5022> }
					triangle { <-52.4799, 477.7924, 7.7295>, <-59.4275, 473.9797, 0.5022>, <-51.7093, 477.4492, 7.1994> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-51.5219, 472.6423, 10.6092>, <-51.2523, 474.0426, 10.4741>, <-51.8802, 476.4684, 8.9018> }
					triangle { <-51.2523, 474.0426, 10.4741>, <-51.8317, 478.1074, 8.4172>, <-51.8802, 476.4684, 8.9018> }
					triangle { <-51.8317, 478.1074, 8.4172>, <-52.4799, 477.7924, 7.7295>, <-51.8802, 476.4684, 8.9018> }
					triangle { <-51.8802, 476.4684, 8.9018>, <-52.4799, 477.7924, 7.7295>, <-51.5219, 472.6423, 10.6092> }
					triangle { <-51.8317, 478.1074, 8.4172>, <-55.3152, 481.3223, 14.9856>, <-58.4683, 482.759, 15.5442> }
					triangle { <-58.4683, 482.759, 15.5442>, <-61.8344, 481.8575, 14.3717>, <-60.7531, 481.11, 13.695> }
					triangle { <-60.7531, 481.11, 13.695>, <-51.8317, 478.1074, 8.4172>, <-58.4683, 482.759, 15.5442> }
					triangle { <-51.8317, 478.1074, 8.4172>, <-60.7531, 481.11, 13.695>, <-52.4799, 477.7924, 7.7295> }
					triangle { <-52.5021, 476.0122, 8.2929>, <-52.1852, 473.3584, 9.5608>, <-51.5219, 472.6423, 10.6092> }
					triangle { <-52.5021, 476.0122, 8.2929>, <-53.0756, 477.1952, 7.1995>, <-52.1852, 473.3584, 9.5608> }
					triangle { <-52.5021, 476.0122, 8.2929>, <-52.4799, 477.7924, 7.7295>, <-53.0756, 477.1952, 7.1995> }
					triangle { <-51.5219, 472.6423, 10.6092>, <-52.4799, 477.7924, 7.7295>, <-52.5021, 476.0122, 8.2929> }
					triangle { <-62.7182, 479.6421, 11.3836>, <-60.7054, 477.3691, 9.7087>, <-53.0756, 477.1952, 7.1995> }
					triangle { <-60.7531, 481.11, 13.695>, <-61.8344, 481.8575, 14.3717>, <-62.7182, 479.6421, 11.3836> }
					triangle { <-62.7182, 479.6421, 11.3836>, <-53.0756, 477.1952, 7.1995>, <-60.7531, 481.11, 13.695> }
					triangle { <-52.4799, 477.7924, 7.7295>, <-60.7531, 481.11, 13.695>, <-53.0756, 477.1952, 7.1995> }
					material { txfirew_flower }}
				mesh { // flower petal
					triangle { <-51.5219, 472.6423, 10.6092>, <-51.1605, 473.549, 9.5608>, <-51.819, 476.1393, 8.2929> }
					triangle { <-51.1605, 473.549, 9.5608>, <-51.7093, 477.4492, 7.1994>, <-51.819, 476.1393, 8.2929> }
					triangle { <-51.7093, 477.4492, 7.1994>, <-52.4799, 477.7924, 7.7295>, <-51.819, 476.1393, 8.2929> }
					triangle { <-51.819, 476.1393, 8.2929>, <-52.4799, 477.7924, 7.7295>, <-51.5219, 472.6423, 10.6092> }
					triangle { <-51.7093, 477.4492, 7.1994>, <-44.5279, 480.3211, 9.6066>, <-43.5908, 483.1994, 11.3828> }
					triangle { <-43.5908, 483.1994, 11.3828>, <-45.08775, 484.9153, 14.2695>, <-45.9521, 483.8627, 13.6944> }
					triangle { <-45.9521, 483.8627, 13.6944>, <-51.7093, 477.4492, 7.1994>, <-43.5908, 483.1994, 11.3828> }
					triangle { <-51.7093, 477.4492, 7.1994>, <-45.9521, 483.8627, 13.6944>, <-52.4799, 477.7924, 7.7295> }
					triangle { <-52.5633, 476.3413, 8.9018>, <-52.277, 473.8521, 10.4741>, <-51.5219, 472.6423, 10.6092> }
					triangle { <-52.5633, 476.3413, 8.9018>, <-53.1979, 477.8533, 8.4173>, <-52.277, 473.8521, 10.4741> }
					triangle { <-52.5633, 476.3413, 8.9018>, <-52.4799, 477.7924, 7.7295>, <-53.1979, 477.8533, 8.4173> }
					triangle { <-51.5219, 472.6423, 10.6092>, <-52.4799, 477.7924, 7.7295>, <-52.5633, 476.3413, 8.9018> }
					triangle { <-48.6768, 484.58, 15.5438>, <-50.9786, 482.0721, 14.8839>, <-53.1979, 477.8533, 8.4173> }
					triangle { <-45.9521, 483.8627, 13.6944>, <-45.08775, 484.9153, 14.2695>, <-48.6768, 484.58, 15.5438> }
					triangle { <-48.6768, 484.58, 15.5438>, <-53.1979, 477.8533, 8.4173>, <-45.9521, 483.8627, 13.6944> }
					triangle { <-52.4799, 477.7924, 7.7295>, <-45.9521, 483.8627, 13.6944>, <-53.1979, 477.8533, 8.4173> }
					material { txfirew_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-43.2815, 428.3379, 24.8601>, <-43.6968, 430.571, 25.05688>, 0.3 }
			cylinder { <-43.6968, 430.571, 25.05688>, <-44.1121, 432.804, 25.2536>, 0.3 }
			cylinder { <-44.1121, 432.804, 25.2536>, <-44.5274, 435.0371, 25.4504>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-44.5274, 435.0371, 25.4504>, <-49.3978, 449.7902, 29.09974>, 0.3 }
				cylinder { <-49.3978, 449.7902, 29.09974>, <-56.04431, 463.0979, 34.8807>, 0.3 }
				cylinder { <-56.04431, 463.0979, 34.8807>, <-64.2114, 474.4489, 42.5713>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower bud
				mesh { // flower bud petal
					triangle { <-64.2114, 474.4489, 42.5713>, <-64.4121, 481.0247, 48.3637>, <-68.157, 479.6039, 46.05912> }
					triangle { <-68.157, 479.6039, 46.05912>, <-64.4121, 481.0247, 48.3637>, <-67.5939, 486.398, 52.765> }
					triangle { <-68.157, 479.6039, 46.05912>, <-67.5939, 486.398, 52.765>, <-72.3224, 484.7007, 50.2488> }
					triangle { <-67.5939, 486.398, 52.765>, <-75.8427, 488.8309, 55.276>, <-72.3224, 484.7007, 50.2488> }
					triangle { <-68.157, 479.6039, 46.05912>, <-71.97, 477.3942, 45.6959>, <-64.2114, 474.4489, 42.5713> }
					triangle { <-71.97, 477.3942, 45.6959>, <-68.157, 479.6039, 46.05912>, <-72.3224, 484.7007, 50.2488> }
					triangle { <-76.07129, 482.488, 50.3827>, <-71.97, 477.3942, 45.6959>, <-72.3224, 484.7007, 50.2488> }
					triangle { <-76.07129, 482.488, 50.3827>, <-72.3224, 484.7007, 50.2488>, <-75.8427, 488.8309, 55.276> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-64.2114, 474.4489, 42.5713>, <-69.06933, 481.742, 42.3591>, <-67.8976, 479.6286, 46.2981> }
					triangle { <-67.8976, 479.6286, 46.2981>, <-69.06933, 481.742, 42.3591>, <-72.8145, 487.7584, 45.213> }
					triangle { <-67.8976, 479.6286, 46.2981>, <-72.8145, 487.7584, 45.213>, <-71.3294, 485.492, 50.1353> }
					triangle { <-72.8145, 487.7584, 45.213>, <-73.6865, 491.8234, 53.1492>, <-71.3294, 485.492, 50.1353> }
					triangle { <-67.8976, 479.6286, 46.2981>, <-65.4728, 479.1746, 49.9679>, <-64.2114, 474.4489, 42.5713> }
					triangle { <-65.4728, 479.1746, 49.9679>, <-67.8976, 479.6286, 46.2981>, <-71.3294, 485.492, 50.1353> }
					triangle { <-68.7836, 485.505, 53.6689>, <-65.4728, 479.1746, 49.9679>, <-71.3294, 485.492, 50.1353> }
					triangle { <-68.7836, 485.505, 53.6689>, <-71.3294, 485.492, 50.1353>, <-73.6865, 491.8234, 53.1492> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-64.2114, 474.4489, 42.5713>, <-70.7244, 476.7519, 47.9668>, <-67.8916, 479.8313, 46.00537> }
					triangle { <-67.8916, 479.8313, 46.00537>, <-70.7244, 476.7519, 47.9668>, <-75.4112, 481.5169, 51.6677> }
					triangle { <-67.8916, 479.8313, 46.00537>, <-75.4112, 481.5169, 51.6677>, <-72.235, 485.4565, 49.2259> }
					triangle { <-75.4112, 481.5169, 51.6677>, <-77.3509, 490.263, 51.5609>, <-72.235, 485.4565, 49.2259> }
					triangle { <-67.8916, 479.8313, 46.00537>, <-66.8703, 482.8982, 42.9879>, <-64.2114, 474.4489, 42.5713> }
					triangle { <-66.8703, 482.8982, 42.9879>, <-67.8916, 479.8313, 46.00537>, <-72.235, 485.4565, 49.2259> }
					triangle { <-71.7105, 488.4939, 46.1491>, <-66.8703, 482.8982, 42.9879>, <-72.235, 485.4565, 49.2259> }
					triangle { <-71.7105, 488.4939, 46.1491>, <-72.235, 485.4565, 49.2259>, <-77.3509, 490.263, 51.5609> }
					material { txfirew_flowerb }}
				}
			}
		union { // inflor. internode
			cylinder { <-44.5274, 435.0371, 25.4504>, <-44.9427, 437.2701, 25.6471>, 0.3 }
			cylinder { <-44.9427, 437.2701, 25.6471>, <-45.358, 439.5032, 25.8439>, 0.3 }
			cylinder { <-45.358, 439.5032, 25.8439>, <-45.7733, 441.7363, 26.04073>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-45.7733, 441.7363, 26.04073>, <-45.5832, 457.6598, 27.08749>, 0.3 }
				cylinder { <-45.5832, 457.6598, 27.08749>, <-42.3031, 473.2635, 27.7634>, 0.3 }
				cylinder { <-42.3031, 473.2635, 27.7634>, <-36.0591, 487.9477, 28.04249>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower bud
				mesh { // flower bud petal
					triangle { <-36.0591, 487.9477, 28.04249>, <-34.9678, 494.1214, 24.9118>, <-33.6653, 493.3258, 28.2761> }
					triangle { <-33.6653, 493.3258, 28.2761>, <-34.9678, 494.1214, 24.9118>, <-32.5952, 499.7043, 24.1999> }
					triangle { <-33.6653, 493.3258, 28.2761>, <-32.5952, 499.7043, 24.1999>, <-30.7806, 498.8563, 28.2206> }
					triangle { <-32.5952, 499.7043, 24.1999>, <-27.5414, 503.7189, 27.305>, <-30.7806, 498.8563, 28.2206> }
					triangle { <-33.6653, 493.3258, 28.2761>, <-31.1147, 492.3762, 30.5321>, <-36.0591, 487.9477, 28.04249> }
					triangle { <-31.1147, 492.3762, 30.5321>, <-33.6653, 493.3258, 28.2761>, <-30.7806, 498.8563, 28.2206> }
					triangle { <-28.0137, 497.9985, 30.1521>, <-31.1147, 492.3762, 30.5321>, <-30.7806, 498.8563, 28.2206> }
					triangle { <-28.0137, 497.9985, 30.1521>, <-30.7806, 498.8563, 28.2206>, <-27.5414, 503.7189, 27.305> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-36.0591, 487.9477, 28.04249>, <-35.6618, 494.3013, 30.9716>, <-33.6938, 493.3433, 27.9955> }
					triangle { <-33.6938, 493.3433, 27.9955>, <-35.6618, 494.3013, 30.9716>, <-33.9508, 500.1423, 31.4816> }
					triangle { <-33.6938, 493.3433, 27.9955>, <-33.9508, 500.1423, 31.4816>, <-31.6134, 499.2191, 27.7584> }
					triangle { <-33.9508, 500.1423, 31.4816>, <-30.6727, 505.0482, 27.4212>, <-31.6134, 499.2191, 27.7584> }
					triangle { <-33.6938, 493.3433, 27.9955>, <-33.03497, 493.3069, 24.5224>, <-36.0591, 487.9477, 28.04249> }
					triangle { <-33.03497, 493.3069, 24.5224>, <-33.6938, 493.3433, 27.9955>, <-31.6134, 499.2191, 27.7584> }
					triangle { <-31.2268, 499.4759, 24.3077>, <-33.03497, 493.3069, 24.5224>, <-31.6134, 499.2191, 27.7584> }
					triangle { <-31.2268, 499.4759, 24.3077>, <-31.6134, 499.2191, 27.7584>, <-30.6727, 505.0482, 27.4212> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-36.0591, 487.9477, 28.04249>, <-30.4613, 492.1367, 28.5155>, <-33.9043, 493.4295, 28.1666> }
					triangle { <-33.9043, 493.4295, 28.1666>, <-30.4613, 492.1367, 28.5155>, <-27.4404, 497.4207, 29.02342> }
					triangle { <-33.9043, 493.4295, 28.1666>, <-27.4404, 497.4207, 29.02342>, <-31.5666, 499.1798, 28.783> }
					triangle { <-27.4404, 497.4207, 29.02342>, <-29.01205, 504.2869, 30.3217>, <-31.5666, 499.1798, 28.783> }
					triangle { <-33.9043, 493.4295, 28.1666>, <-36.8866, 494.8515, 29.4242>, <-36.0591, 487.9477, 28.04249> }
					triangle { <-36.8866, 494.8515, 29.4242>, <-33.9043, 493.4295, 28.1666>, <-31.5666, 499.1798, 28.783> }
					triangle { <-34.2987, 500.6674, 30.3467>, <-36.8866, 494.8515, 29.4242>, <-31.5666, 499.1798, 28.783> }
					triangle { <-34.2987, 500.6674, 30.3467>, <-31.5666, 499.1798, 28.783>, <-29.01205, 504.2869, 30.3217> }
					material { txfirew_flowerb }}
				}
			}
		union { // inflor. internode
			cylinder { <-45.7733, 441.7363, 26.04073>, <-46.1886, 443.9693, 26.2375>, 0.3 }
			cylinder { <-46.1886, 443.9693, 26.2375>, <-46.6039, 446.2024, 26.4342>, 0.3 }
			cylinder { <-46.6039, 446.2024, 26.4342>, <-47.01927, 448.4355, 26.631>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-47.01927, 448.4355, 26.631>, <-52.3584, 463.4667, 26.1343>, 0.3 }
				cylinder { <-52.3584, 463.4667, 26.1343>, <-59.9245, 477.32, 23.7825>, 0.3 }
				cylinder { <-59.9245, 477.32, 23.7825>, <-69.4267, 489.4631, 19.666>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower bud
				mesh { // flower bud petal
					triangle { <-69.4267, 489.4631, 19.666>, <-73.1683, 492.9223, 20.9281>, <-72.02652, 492.8011, 18.41> }
					triangle { <-72.02652, 492.8011, 18.41>, <-73.1683, 492.9223, 20.9281>, <-76.2604, 496.2159, 20.2025> }
					triangle { <-72.02652, 492.8011, 18.41>, <-76.2604, 496.2159, 20.2025>, <-75.0562, 496.0939, 17.06271> }
					triangle { <-76.2604, 496.2159, 20.2025>, <-78.4891, 498.681, 15.9898>, <-75.0562, 496.0939, 17.06271> }
					triangle { <-72.02652, 492.8011, 18.41>, <-72.0043, 492.1127, 15.8529>, <-69.4267, 489.4631, 19.666> }
					triangle { <-72.0043, 492.1127, 15.8529>, <-72.02652, 492.8011, 18.41>, <-75.0562, 496.0939, 17.06271> }
					triangle { <-75.3233, 495.363, 14.5731>, <-72.0043, 492.1127, 15.8529>, <-75.0562, 496.0939, 17.06271> }
					triangle { <-75.3233, 495.363, 14.5731>, <-75.0562, 496.0939, 17.06271>, <-78.4891, 498.681, 15.9898> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-69.4267, 489.4631, 19.666>, <-70.00114, 494.4023, 17.9829>, <-72.1493, 492.762, 18.5781> }
					triangle { <-72.1493, 492.762, 18.5781>, <-70.00114, 494.4023, 17.9829>, <-72.2487, 498.2476, 16.9353> }
					triangle { <-72.1493, 492.762, 18.5781>, <-72.2487, 498.2476, 16.9353>, <-74.9484, 496.4108, 17.7489> }
					triangle { <-72.2487, 498.2476, 16.9353>, <-77.1986, 500.2225, 17.5584>, <-74.9484, 496.4108, 17.7489> }
					triangle { <-72.1493, 492.762, 18.5781>, <-74.1166, 491.9108, 20.1332>, <-69.4267, 489.4631, 19.666> }
					triangle { <-74.1166, 491.9108, 20.1332>, <-72.1493, 492.762, 18.5781>, <-74.9484, 496.4108, 17.7489> }
					triangle { <-76.8468, 495.8197, 19.4371>, <-74.1166, 491.9108, 20.1332>, <-74.9484, 496.4108, 17.7489> }
					triangle { <-76.8468, 495.8197, 19.4371>, <-74.9484, 496.4108, 17.7489>, <-77.1986, 500.2225, 17.5584> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-69.4267, 489.4631, 19.666>, <-73.2249, 491.4152, 16.6129>, <-71.9845, 492.8965, 18.5944> }
					triangle { <-71.9845, 492.8965, 18.5944>, <-73.2249, 491.4152, 16.6129>, <-75.9901, 494.6244, 14.8837> }
					triangle { <-71.9845, 492.8965, 18.5944>, <-75.9901, 494.6244, 14.8837>, <-74.4776, 496.5814, 17.1654> }
					triangle { <-75.9901, 494.6244, 14.8837>, <-76.4686, 499.9638, 15.1101>, <-74.4776, 496.5814, 17.1654> }
					triangle { <-71.9845, 492.8965, 18.5944>, <-70.257, 494.7047, 19.4657>, <-69.4267, 489.4631, 19.666> }
					triangle { <-70.257, 494.7047, 19.4657>, <-71.9845, 492.8965, 18.5944>, <-74.4776, 496.5814, 17.1654> }
					triangle { <-72.7516, 498.4498, 17.7426>, <-70.257, 494.7047, 19.4657>, <-74.4776, 496.5814, 17.1654> }
					triangle { <-72.7516, 498.4498, 17.7426>, <-74.4776, 496.5814, 17.1654>, <-76.4686, 499.9638, 15.1101> }
					material { txfirew_flowerb }}
				}
			}
		union { // inflor. internode
			cylinder { <-47.01927, 448.4355, 26.631>, <-47.4345, 450.6685, 26.8278>, 0.3 }
			cylinder { <-47.4345, 450.6685, 26.8278>, <-47.8498, 452.9016, 27.02458>, 0.3 }
			cylinder { <-47.8498, 452.9016, 27.02458>, <-48.2651, 455.1346, 27.2213>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-48.2651, 455.1346, 27.2213>, <-50.4709, 470.3177, 31.6144>, 0.3 }
				cylinder { <-50.4709, 470.3177, 31.6144>, <-51.8906, 484.469, 38.8545>, 0.3 }
				cylinder { <-51.8906, 484.469, 38.8545>, <-52.4696, 497.0445, 48.6633>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower bud
				mesh { // flower bud petal
					triangle { <-52.4696, 497.0445, 48.6633>, <-51.08825, 500.0376, 49.8144>, <-52.6332, 499.3195, 50.5113> }
					triangle { <-52.6332, 499.3195, 50.5113>, <-51.08825, 500.0376, 49.8144>, <-50.7949, 502.463, 51.6293> }
					triangle { <-52.6332, 499.3195, 50.5113>, <-50.7949, 502.463, 51.6293>, <-52.6287, 501.6223, 52.5988> }
					triangle { <-50.7949, 502.463, 51.6293>, <-52.1529, 503.606, 54.7255>, <-52.6287, 501.6223, 52.5988> }
					triangle { <-52.6332, 499.3195, 50.5113>, <-53.5468, 498.4319, 51.728>, <-52.4696, 497.0445, 48.6633> }
					triangle { <-53.5468, 498.4319, 51.728>, <-52.6332, 499.3195, 50.5113>, <-52.6287, 501.6223, 52.5988> }
					triangle { <-53.372, 500.7692, 53.9139>, <-53.5468, 498.4319, 51.728>, <-52.6287, 501.6223, 52.5988> }
					triangle { <-53.372, 500.7692, 53.9139>, <-52.6287, 501.6223, 52.5988>, <-52.1529, 503.606, 54.7255> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-52.4696, 497.0445, 48.6633>, <-54.1252, 499.8922, 49.8216>, <-52.4974, 499.346, 50.4853> }
					triangle { <-52.4974, 499.346, 50.4853>, <-54.1252, 499.8922, 49.8216>, <-54.4858, 502.4588, 51.4167> }
					triangle { <-52.4974, 499.346, 50.4853>, <-54.4858, 502.4588, 51.4167>, <-52.4676, 501.9231, 52.2227> }
					triangle { <-54.4858, 502.4588, 51.4167>, <-52.4595, 504.6231, 53.4033>, <-52.4676, 501.9231, 52.2227> }
					triangle { <-52.4974, 499.346, 50.4853>, <-50.7426, 499.4293, 50.6147>, <-52.4696, 497.0445, 48.6633> }
					triangle { <-50.7426, 499.4293, 50.6147>, <-52.4974, 499.346, 50.4853>, <-52.4676, 501.9231, 52.2227> }
					triangle { <-50.7522, 502.1794, 52.2606>, <-50.7426, 499.4293, 50.6147>, <-52.4676, 501.9231, 52.2227> }
					triangle { <-50.7522, 502.1794, 52.2606>, <-52.4676, 501.9231, 52.2227>, <-52.4595, 504.6231, 53.4033> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-52.4696, 497.0445, 48.6633>, <-52.5024, 498.3421, 51.9048>, <-52.5984, 499.4044, 50.4045> }
					triangle { <-52.5984, 499.4044, 50.4045>, <-52.5024, 498.3421, 51.9048>, <-52.7577, 500.4804, 54.05528> }
					triangle { <-52.5984, 499.4044, 50.4045>, <-52.7577, 500.4804, 54.05528>, <-52.9681, 501.8448, 52.2935> }
					triangle { <-52.7577, 500.4804, 54.05528>, <-53.7544, 503.9016, 54.2519>, <-52.9681, 501.8448, 52.2935> }
					triangle { <-52.5984, 499.4044, 50.4045>, <-53.4613, 500.3879, 49.2252>, <-52.4696, 497.0445, 48.6633> }
					triangle { <-53.4613, 500.3879, 49.2252>, <-52.5984, 499.4044, 50.4045>, <-52.9681, 501.8448, 52.2935> }
					triangle { <-53.9684, 502.8131, 51.2583>, <-53.4613, 500.3879, 49.2252>, <-52.9681, 501.8448, 52.2935> }
					triangle { <-53.9684, 502.8131, 51.2583>, <-52.9681, 501.8448, 52.2935>, <-53.7544, 503.9016, 54.2519> }
					material { txfirew_flowerb }}
				}
			}
		union { // inflor. internode
			cylinder { <-48.2651, 455.1346, 27.2213>, <-48.6804, 457.3677, 27.4181>, 0.3 }
			cylinder { <-48.6804, 457.3677, 27.4181>, <-49.09578, 459.6008, 27.6148>, 0.3 }
			cylinder { <-49.09578, 459.6008, 27.6148>, <-49.511, 461.8338, 27.8116>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-49.511, 461.8338, 27.8116>, <-50.8309, 477.6842, 26.5019>, 0.3 }
				cylinder { <-50.8309, 477.6842, 26.5019>, <-50.5127, 493.1443, 22.5555>, 0.3 }
				cylinder { <-50.5127, 493.1443, 22.5555>, <-48.5689, 507.6201, 16.124>, 0.3 }
				material { txfirew_pedicel }}
			union { // flower bud
				mesh { // flower bud petal
					triangle { <-48.5689, 507.6201, 16.124>, <-49.2249, 508.982, 15.2749>, <-48.3512, 508.9377, 15.5397> }
					triangle { <-48.3512, 508.9377, 15.5397>, <-49.2249, 508.982, 15.2749>, <-49.2002, 510.3071, 14.549> }
					triangle { <-48.3512, 508.9377, 15.5397>, <-49.2002, 510.3071, 14.549>, <-48.1208, 510.2791, 14.812> }
					triangle { <-49.2002, 510.3071, 14.549>, <-47.9796, 511.4193, 13.9059>, <-48.1208, 510.2791, 14.812> }
					triangle { <-48.3512, 508.9377, 15.5397>, <-47.498, 508.8056, 15.3998>, <-48.5689, 507.6201, 16.124> }
					triangle { <-47.498, 508.8056, 15.3998>, <-48.3512, 508.9377, 15.5397>, <-48.1208, 510.2791, 14.812> }
					triangle { <-47.3008, 510.1547, 14.579>, <-47.498, 508.8056, 15.3998>, <-48.1208, 510.2791, 14.812> }
					triangle { <-47.3008, 510.1547, 14.579>, <-48.1208, 510.2791, 14.812>, <-47.9796, 511.4193, 13.9059> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-48.5689, 507.6201, 16.124>, <-48.1658, 509.2968, 16.3037>, <-48.4103, 508.9294, 15.5033> }
					triangle { <-48.4103, 508.9294, 15.5033>, <-48.1658, 509.2968, 16.3037>, <-48.01396, 510.7398, 15.8814> }
					triangle { <-48.4103, 508.9294, 15.5033>, <-48.01396, 510.7398, 15.8814>, <-48.3482, 510.3473, 14.8969> }
					triangle { <-48.01396, 510.7398, 15.8814>, <-48.4756, 511.7501, 14.5006>, <-48.3482, 510.3473, 14.8969> }
					triangle { <-48.4103, 508.9294, 15.5033>, <-48.9803, 508.765, 14.8605>, <-48.5689, 507.6201, 16.124> }
					triangle { <-48.9803, 508.765, 14.8605>, <-48.4103, 508.9294, 15.5033>, <-48.3482, 510.3473, 14.8969> }
					triangle { <-48.9652, 510.2554, 14.3028>, <-48.9803, 508.765, 14.8605>, <-48.3482, 510.3473, 14.8969> }
					triangle { <-48.9652, 510.2554, 14.3028>, <-48.3482, 510.3473, 14.8969>, <-48.4756, 511.7501, 14.5006> }
					material { txfirew_flowerb }}
				mesh { // flower bud petal
					triangle { <-48.5689, 507.6201, 16.124>, <-47.7805, 508.6568, 14.9795>, <-48.412, 508.9582, 15.5675> }
					triangle { <-48.412, 508.9582, 15.5675>, <-47.7805, 508.6568, 14.9795>, <-47.4121, 509.9632, 14.3154> }
					triangle { <-48.412, 508.9582, 15.5675>, <-47.4121, 509.9632, 14.3154>, <-48.142, 510.3835, 15.04063> }
					triangle { <-47.4121, 509.9632, 14.3154>, <-47.6386, 511.6932, 14.6256>, <-48.142, 510.3835, 15.04063> }
					triangle { <-48.412, 508.9582, 15.5675>, <-48.6684, 509.3625, 16.2995>, <-48.5689, 507.6201, 16.124> }
					triangle { <-48.6684, 509.3625, 16.2995>, <-48.412, 508.9582, 15.5675>, <-48.142, 510.3835, 15.04063> }
					triangle { <-48.3039, 510.8172, 15.767>, <-48.6684, 509.3625, 16.2995>, <-48.142, 510.3835, 15.04063> }
					triangle { <-48.3039, 510.8172, 15.767>, <-48.142, 510.3835, 15.04063>, <-47.6386, 511.6932, 14.6256> }
					material { txfirew_flowerb }}
				}
			}
		union { // inflor. internode
			cylinder { <-49.511, 461.8338, 27.8116>, <-49.9263, 464.0669, 28.00842>, 0.3 }
			cylinder { <-49.9263, 464.0669, 28.00842>, <-50.3416, 466.3, 28.2051>, 0.3 }
			cylinder { <-50.3416, 466.3, 28.2051>, <-50.7569, 468.533, 28.4019>, 0.3 }
			material { txfirew_inflor }}
		union { // pedicel and flower/fruit
				cylinder { <-50.7569, 468.533, 28.4019>, <-56.5231, 483.2427, 30.6534>, 0.3 }
				cylinder { <-56.5231, 483.2427, 30.6534>, <-64.9266, 496.4652, 33.6924>, 0.3 }
				cylinder { <-64.9266, 496.4652, 33.6924>, <-75.6446, 507.6926, 37.4022>, 0.3 }
				material { txfirew_pedicel }
			}
		}
} // end fireweed

