// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare txgilia_inter = material { texture { pigment { color rgb <0.19, 0.39, 0.19> }  
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   
   
#declare txgilia_leaf = material { texture { pigment { color rgb <0.19, 0.78, 0.19> }
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   

#declare txgilia_inflor = material { texture { pigment { color rgb <0.19, 0.39, 0.19> }
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   

#declare txgilia_flower = material { texture { pigment { color rgb <0.62, 0.25, 0.21> }
finish { ambient 0.3  diffuse 0.65 roughness 0.001 } } } 

#declare txgilia_pedicel = material { texture { pigment { color rgb <0.19, 0.39, 0.19> }
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   

#declare txgilia_petiole = material { texture { pigment { color rgb <0.19, 0.39, 0.19> }
finish { ambient 0.1  diffuse 0.6 roughness 0.001 } } }   


#declare gilia = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.06135, 4.3407, 0.08712>, 0.1313 }
		cylinder { <-0.06135, 4.3407, 0.08712>, <-0.184, 8.6775, 0.2613>, 0.1313 }
		cylinder { <-0.184, 8.6775, 0.2613>, <-0.3679, 13.0078, 0.5224>, 0.1313 }
		material { txgilia_inter }}
	union { // internode
		cylinder { <-0.3679, 13.0078, 0.5224>, <0.08749, 17.4882, 0.6467>, 0.1362 }
		cylinder { <0.08749, 17.4882, 0.6467>, <1.1793, 21.859, 0.6216>, 0.1362 }
		cylinder { <1.1793, 21.859, 0.6216>, <2.884, 26.02572, 0.4477>, 0.1362 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.884, 26.02572, 0.4477>, <3.6554, 26.896, 0.3175>, 0.07584 }
			cylinder { <3.6554, 26.896, 0.3175>, <4.6651, 27.4526, 0.1176>, 0.07584 }
			cylinder { <4.6651, 27.4526, 0.1176>, <5.7952, 27.6305, -0.1287>, 0.07584 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <5.7952, 27.6305, -0.1287>, <6.2723, 27.7046, -0.2204>, 0.07584 }
				cylinder { <6.2723, 27.7046, -0.2204>, <6.7517, 27.778, -0.3002>, 0.07584 }
				cylinder { <6.7517, 27.778, -0.3002>, <7.233, 27.8507, -0.3682>, 0.07584 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <7.233, 27.8507, -0.3682>, <7.2469, 27.8525, -0.3663>, 0.0009203 }
				cylinder { <7.2469, 27.8525, -0.3663>, <7.26, 27.8539, -0.3608>, 0.0009203 }
				cylinder { <7.26, 27.8539, -0.3608>, <7.2711, 27.8547, -0.352>, 0.0009203 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <7.2711, 27.8547, -0.352>, <10.8112, 28.09138, 2.08728>, <10.7072, 27.8341, 2.3218> }
				triangle { <10.8112, 28.09138, 2.08728>, <12.1935, 26.9275, 1.9454>, <10.7072, 27.8341, 2.3218> }
				triangle { <10.8112, 28.09138, 2.08728>, <12.06295, 27.3659, 1.7849>, <12.1935, 26.9275, 1.9454> }
				triangle { <12.1935, 26.9275, 1.9454>, <11.732, 26.9265, 2.2681>, <10.7072, 27.8341, 2.3218> }
				triangle { <10.7072, 27.8341, 2.3218>, <9.3714, 27.561, 1.2587>, <7.2711, 27.8547, -0.352> }
				triangle { <7.2711, 27.8547, -0.352>, <9.6521, 27.9699, 0.8434>, <10.8112, 28.09138, 2.08728> }
				triangle { <9.6521, 27.9699, 0.8434>, <11.1251, 28.01506, 1.5731>, <10.8112, 28.09138, 2.08728> }
				triangle { <11.1251, 28.01506, 1.5731>, <12.06295, 27.3659, 1.7849>, <10.8112, 28.09138, 2.08728> }
				triangle { <10.7072, 27.8341, 2.3218>, <11.732, 26.9265, 2.2681>, <10.8483, 27.2449, 2.2324> }
				triangle { <10.8483, 27.2449, 2.2324>, <9.3714, 27.561, 1.2587>, <10.7072, 27.8341, 2.3218> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <7.233, 27.8507, -0.3682>, <7.2469, 27.8528, -0.3701>, 0.0009203 }
				cylinder { <7.2469, 27.8528, -0.3701>, <7.2608, 27.8549, -0.3721>, 0.0009203 }
				cylinder { <7.2608, 27.8549, -0.3721>, <7.2747, 27.857, -0.3741>, 0.0009203 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <7.2747, 27.857, -0.3741>, <11.4482, 28.4544, -1.248>, <11.5688, 28.2268, -0.9918> }
				triangle { <11.4482, 28.4544, -1.248>, <12.4262, 27.3051, -2.2521>, <11.5688, 28.2268, -0.9918> }
				triangle { <11.4482, 28.4544, -1.248>, <12.1769, 27.7179, -2.302>, <12.4262, 27.3051, -2.2521> }
				triangle { <12.4262, 27.3051, -2.2521>, <12.3349, 27.3367, -1.6973>, <11.5688, 28.2268, -0.9918> }
				triangle { <11.5688, 28.2268, -0.9918>, <9.911, 27.8012, -0.7469>, <7.2747, 27.857, -0.3741> }
				triangle { <7.2747, 27.857, -0.3741>, <9.7694, 28.1598, -1.2665>, <11.4482, 28.4544, -1.248> }
				triangle { <9.7694, 28.1598, -1.2665>, <11.3085, 28.3199, -1.8233>, <11.4482, 28.4544, -1.248> }
				triangle { <11.3085, 28.3199, -1.8233>, <12.1769, 27.7179, -2.302>, <11.4482, 28.4544, -1.248> }
				triangle { <11.5688, 28.2268, -0.9918>, <12.3349, 27.3367, -1.6973>, <11.6627, 27.6334, -1.1109> }
				triangle { <11.6627, 27.6334, -1.1109>, <9.911, 27.8012, -0.7469>, <11.5688, 28.2268, -0.9918> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <2.884, 26.02572, 0.4477>, <11.01765, 38.4304, -0.7612>, 0.4501 }
		cylinder { <11.01765, 38.4304, -0.7612>, <21.3409, 48.999, -2.558>, 0.4501 }
		cylinder { <21.3409, 48.999, -2.558>, <33.4571, 57.3252, -4.8738>, 0.4501 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <33.4571, 57.3252, -4.8738>, <35.4747, 57.8533, -5.3029>, 0.138 }
			cylinder { <35.4747, 57.8533, -5.3029>, <37.5405, 57.6566, -5.7797>, 0.138 }
			cylinder { <37.5405, 57.6566, -5.7797>, <39.413, 56.7579, -6.2485>, 0.138 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <39.413, 56.7579, -6.2485>, <40.19, 56.3607, -6.4442>, 0.138 }
				cylinder { <40.19, 56.3607, -6.4442>, <40.957, 55.944, -6.6386>, 0.138 }
				cylinder { <40.957, 55.944, -6.6386>, <41.7136, 55.5081, -6.8317>, 0.138 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <41.7136, 55.5081, -6.8317>, <41.7547, 55.4853, -6.8304>, 0.003047 }
				cylinder { <41.7547, 55.4853, -6.8304>, <41.7946, 55.464, -6.8178>, 0.003047 }
				cylinder { <41.7946, 55.464, -6.8178>, <41.831, 55.4454, -6.7945>, 0.003047 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <41.831, 55.4454, -6.7945>, <48.04339, 52.1263, -3.364>, <47.7078, 51.8919, -2.8449> }
				triangle { <48.04339, 52.1263, -3.364>, <48.7279, 48.9083, -3.5942>, <47.7078, 51.8919, -2.8449> }
				triangle { <48.04339, 52.1263, -3.364>, <48.9484, 49.6701, -3.9803>, <48.7279, 48.9083, -3.5942> }
				triangle { <48.7279, 48.9083, -3.5942>, <48.1867, 49.4464, -2.9106>, <47.7078, 51.8919, -2.8449> }
				triangle { <47.7078, 51.8919, -2.8449>, <45.1154, 52.8648, -4.3379>, <41.831, 55.4454, -6.7945> }
				triangle { <41.831, 55.4454, -6.7945>, <45.798, 53.1063, -5.266>, <48.04339, 52.1263, -3.364> }
				triangle { <45.798, 53.1063, -5.266>, <48.2206, 51.6204, -4.3299>, <48.04339, 52.1263, -3.364> }
				triangle { <48.2206, 51.6204, -4.3299>, <48.9484, 49.6701, -3.9803>, <48.04339, 52.1263, -3.364> }
				triangle { <47.7078, 51.8919, -2.8449>, <48.1867, 49.4464, -2.9106>, <47.2494, 50.8764, -2.8605> }
				triangle { <47.2494, 50.8764, -2.8605>, <45.1154, 52.8648, -4.3379>, <47.7078, 51.8919, -2.8449> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <41.7136, 55.5081, -6.8317>, <41.7536, 55.4851, -6.8407>, 0.003047 }
				cylinder { <41.7536, 55.4851, -6.8407>, <41.7938, 55.4621, -6.8486>, 0.003047 }
				cylinder { <41.7938, 55.4621, -6.8486>, <41.8342, 55.4391, -6.8554>, 0.003047 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <41.8342, 55.4391, -6.8554>, <48.4273, 51.5284, -8.4728>, <48.3905, 51.128, -7.9481> }
				triangle { <48.4273, 51.5284, -8.4728>, <48.4612, 48.5792, -9.9488>, <48.3905, 51.128, -7.9481> }
				triangle { <48.4273, 51.5284, -8.4728>, <48.5405, 49.4332, -10.1549>, <48.4612, 48.5792, -9.9488> }
				triangle { <48.4612, 48.5792, -9.9488>, <48.4395, 48.8508, -8.961>, <48.3905, 51.128, -7.9481> }
				triangle { <48.3905, 51.128, -7.9481>, <45.5531, 52.3879, -7.4398>, <41.8342, 55.4391, -6.8554> }
				triangle { <41.8342, 55.4391, -6.8554>, <45.6652, 52.9391, -8.4738>, <48.4273, 51.5284, -8.4728> }
				triangle { <45.6652, 52.9391, -8.4738>, <47.9987, 51.3572, -9.4765>, <48.4273, 51.5284, -8.4728> }
				triangle { <47.9987, 51.3572, -9.4765>, <48.5405, 49.4332, -10.1549>, <48.4273, 51.5284, -8.4728> }
				triangle { <48.3905, 51.128, -7.9481>, <48.4395, 48.8508, -8.961>, <47.866, 50.1464, -8.002665> }
				triangle { <47.866, 50.1464, -8.002665>, <45.5531, 52.3879, -7.4398>, <48.3905, 51.128, -7.9481> }
				material { txgilia_leaf }}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <33.4571, 57.3252, -4.8738>, <34.958, 58.471, -5.2889>, 0.2192 }
			cylinder { <34.958, 58.471, -5.2889>, <36.3769, 59.674, -5.8157>, 0.2192 }
			cylinder { <36.3769, 59.674, -5.8157>, <37.7049, 60.9271, -6.4509>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <37.7049, 60.9271, -6.4509>, <38.9343, 62.223, -7.1907>, 0.2192 }
			cylinder { <38.9343, 62.223, -7.1907>, <40.05749, 63.5538, -8.03045>, 0.2192 }
			cylinder { <40.05749, 63.5538, -8.03045>, <41.06762, 64.9117, -8.965>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <41.06762, 64.9117, -8.965>, <42.1248, 66.3184, -9.7658>, 0.2192 }
			cylinder { <42.1248, 66.3184, -9.7658>, <43.2229, 67.7653, -10.428>, 0.2192 }
			cylinder { <43.2229, 67.7653, -10.428>, <44.3553, 69.2436, -10.9475>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <44.3553, 69.2436, -10.9475>, <46.172, 71.4432, -11.4685>, 0.2192 }
				cylinder { <46.172, 71.4432, -11.4685>, <48.08912, 73.6039, -11.7262>, 0.2192 }
				cylinder { <48.08912, 73.6039, -11.7262>, <50.08826, 75.7047, -11.7179>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <50.08826, 75.7047, -11.7179>, <59.04348, 82.7265, -11.8065>, <58.4438, 83.1789, -13.1556> }
					triangle { <50.08826, 75.7047, -11.7179>, <55.03532, 79.4689, -10.9254>, <59.04348, 82.7265, -11.8065> }
					triangle { <58.4438, 83.1789, -13.1556>, <54.1517, 80.9611, -12.3887>, <50.08826, 75.7047, -11.7179> }
					triangle { <55.03532, 79.4689, -10.9254>, <60.2099, 81.5501, -12.1048>, <59.04348, 82.7265, -11.8065> }
					triangle { <60.2099, 81.5501, -12.1048>, <61.8715, 81.03782, -14.2445>, <59.04348, 82.7265, -11.8065> }
					triangle { <58.4438, 83.1789, -13.1556>, <58.9139, 83.6793, -14.9128>, <57.4747, 84.3599, -13.6095> }
					triangle { <57.4747, 84.3599, -13.6095>, <54.1517, 80.9611, -12.3887>, <58.4438, 83.1789, -13.1556> }
					triangle { <61.8715, 81.03782, -14.2445>, <61.6676, 81.6181, -14.2026>, <59.7742, 82.963, -13.5888> }
					triangle { <61.6676, 81.6181, -14.2026>, <61.4726, 80.752, -16.7628>, <59.9134, 83.4328, -15.7087> }
					triangle { <59.7742, 82.963, -13.5888>, <59.9134, 83.4328, -15.7087>, <58.9139, 83.6793, -14.9128> }
					triangle { <59.7742, 82.963, -13.5888>, <61.6676, 81.6181, -14.2026>, <59.9134, 83.4328, -15.7087> }
					triangle { <59.04348, 82.7265, -11.8065>, <61.8715, 81.03782, -14.2445>, <59.7742, 82.963, -13.5888> }
					triangle { <58.4438, 83.1789, -13.1556>, <59.7742, 82.963, -13.5888>, <58.9139, 83.6793, -14.9128> }
					triangle { <59.04348, 82.7265, -11.8065>, <59.7742, 82.963, -13.5888>, <58.4438, 83.1789, -13.1556> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <50.08826, 75.7047, -11.7179>, <58.2539, 83.5515, -12.8397>, <57.09545, 84.533, -12.5588> }
					triangle { <50.08826, 75.7047, -11.7179>, <55.129, 79.4023, -12.152>, <58.2539, 83.5515, -12.8397> }
					triangle { <57.09545, 84.533, -12.5588>, <54.04626, 81.0361, -11.0088>, <50.08826, 75.7047, -11.7179> }
					triangle { <55.129, 79.4023, -12.152>, <58.4392, 83.4023, -14.5061>, <58.2539, 83.5515, -12.8397> }
					triangle { <58.4392, 83.4023, -14.5061>, <57.9277, 85.09407, -16.6223>, <58.2539, 83.5515, -12.8397> }
					triangle { <57.09545, 84.533, -12.5588>, <56.3851, 86.202, -13.07769>, <56.5348, 85.2587, -11.2554> }
					triangle { <56.5348, 85.2587, -11.2554>, <54.04626, 81.0361, -11.0088>, <57.09545, 84.533, -12.5588> }
					triangle { <57.9277, 85.09407, -16.6223>, <58.01122, 85.3712, -16.07799>, <57.6128, 85.1587, -13.7186> }
					triangle { <58.01122, 85.3712, -16.07799>, <55.8717, 86.4476, -17.3455>, <56.429, 86.9316, -14.1542> }
					triangle { <57.6128, 85.1587, -13.7186>, <56.429, 86.9316, -14.1542>, <56.3851, 86.202, -13.07769> }
					triangle { <57.6128, 85.1587, -13.7186>, <58.01122, 85.3712, -16.07799>, <56.429, 86.9316, -14.1542> }
					triangle { <58.2539, 83.5515, -12.8397>, <57.9277, 85.09407, -16.6223>, <57.6128, 85.1587, -13.7186> }
					triangle { <57.09545, 84.533, -12.5588>, <57.6128, 85.1587, -13.7186>, <56.3851, 86.202, -13.07769> }
					triangle { <58.2539, 83.5515, -12.8397>, <57.6128, 85.1587, -13.7186>, <57.09545, 84.533, -12.5588> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <50.08826, 75.7047, -11.7179>, <57.3048, 84.4967, -12.07978>, <57.04923, 84.5334, -10.5574> }
					triangle { <50.08826, 75.7047, -11.7179>, <54.342, 80.2123, -12.6443>, <57.3048, 84.4967, -12.07978> }
					triangle { <57.04923, 84.5334, -10.5574>, <54.9317, 80.1249, -10.4549>, <50.08826, 75.7047, -11.7179> }
					triangle { <54.342, 80.2123, -12.6443>, <56.2547, 85.5794, -12.8269>, <57.3048, 84.4967, -12.07978> }
					triangle { <56.2547, 85.5794, -12.8269>, <55.04308, 87.913, -11.9971>, <57.3048, 84.4967, -12.07978> }
					triangle { <57.04923, 84.5334, -10.5574>, <56.7759, 85.7133, -9.1109>, <57.795, 83.9343, -9.2828> }
					triangle { <57.795, 83.9343, -9.2828>, <54.9317, 80.1249, -10.4549>, <57.04923, 84.5334, -10.5574> }
					triangle { <55.04308, 87.913, -11.9971>, <55.5562, 87.7598, -11.6916>, <56.8143, 85.9017, -10.8341> }
					triangle { <55.5562, 87.7598, -11.6916>, <53.6381, 88.5414, -9.9443>, <56.3178, 86.924, -8.9787> }
					triangle { <56.8143, 85.9017, -10.8341>, <56.3178, 86.924, -8.9787>, <56.7759, 85.7133, -9.1109> }
					triangle { <56.8143, 85.9017, -10.8341>, <55.5562, 87.7598, -11.6916>, <56.3178, 86.924, -8.9787> }
					triangle { <57.3048, 84.4967, -12.07978>, <55.04308, 87.913, -11.9971>, <56.8143, 85.9017, -10.8341> }
					triangle { <57.04923, 84.5334, -10.5574>, <56.8143, 85.9017, -10.8341>, <56.7759, 85.7133, -9.1109> }
					triangle { <57.3048, 84.4967, -12.07978>, <56.8143, 85.9017, -10.8341>, <57.04923, 84.5334, -10.5574> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <50.08826, 75.7047, -11.7179>, <57.499, 84.2646, -10.5698>, <58.3686, 83.1795, -9.8985> }
					triangle { <50.08826, 75.7047, -11.7179>, <53.7544, 80.787, -11.7265>, <57.499, 84.2646, -10.5698> }
					triangle { <58.3686, 83.1795, -9.8985>, <55.5926, 79.4783, -11.4874>, <50.08826, 75.7047, -11.7179> }
					triangle { <53.7544, 80.787, -11.7265>, <56.6548, 85.09322, -9.3721>, <57.499, 84.2646, -10.5698> }
					triangle { <56.6548, 85.09322, -9.3721>, <57.177, 85.6252, -6.7177>, <57.499, 84.2646, -10.5698> }
					triangle { <58.3686, 83.1795, -9.8985>, <59.5498, 82.884, -8.4575>, <59.5256, 82.2047, -10.3994> }
					triangle { <59.5256, 82.2047, -10.3994>, <55.5926, 79.4783, -11.4874>, <58.3686, 83.1795, -9.8985> }
					triangle { <57.177, 85.6252, -6.7177>, <57.6725, 85.5052, -7.06451>, <58.4747, 84.1721, -8.8947> }
					triangle { <57.6725, 85.5052, -7.06451>, <57.8378, 84.1593, -4.7184>, <59.7324, 83.4205, -7.2862> }
					triangle { <58.4747, 84.1721, -8.8947>, <59.7324, 83.4205, -7.2862>, <59.5498, 82.884, -8.4575> }
					triangle { <58.4747, 84.1721, -8.8947>, <57.6725, 85.5052, -7.06451>, <59.7324, 83.4205, -7.2862> }
					triangle { <57.499, 84.2646, -10.5698>, <57.177, 85.6252, -6.7177>, <58.4747, 84.1721, -8.8947> }
					triangle { <58.3686, 83.1795, -9.8985>, <58.4747, 84.1721, -8.8947>, <59.5498, 82.884, -8.4575> }
					triangle { <57.499, 84.2646, -10.5698>, <58.4747, 84.1721, -8.8947>, <58.3686, 83.1795, -9.8985> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <50.08826, 75.7047, -11.7179>, <58.5897, 83.1541, -10.3984>, <59.2435, 82.3298, -11.5286> }
					triangle { <50.08826, 75.7047, -11.7179>, <54.1894, 80.3206, -10.6482>, <58.5897, 83.1541, -10.3984> }
					triangle { <59.2435, 82.3298, -11.5286>, <55.1033, 80.00302, -12.7006>, <50.08826, 75.7047, -11.7179> }
					triangle { <54.1894, 80.3206, -10.6482>, <59.1361, 82.5653, -8.9191>, <58.5897, 83.1541, -10.3984> }
					triangle { <59.1361, 82.5653, -8.9191>, <61.4609, 81.312, -8.1276>, <58.5897, 83.1541, -10.3984> }
					triangle { <59.2435, 82.3298, -11.5286>, <60.8911, 81.6079, -12.09746>, <59.3246, 82.4716, -13.1138> }
					triangle { <59.3246, 82.4716, -13.1138>, <55.1033, 80.00302, -12.7006>, <59.2435, 82.3298, -11.5286> }
					triangle { <61.4609, 81.312, -8.1276>, <61.5066, 81.6521, -8.6398>, <60.3316, 82.3284, -10.6229> }
					triangle { <61.5066, 81.6521, -8.6398>, <62.7528, 79.2725, -8.9961>, <61.9882, 81.2303, -11.5084> }
					triangle { <60.3316, 82.3284, -10.6229>, <61.9882, 81.2303, -11.5084>, <60.8911, 81.6079, -12.09746> }
					triangle { <60.3316, 82.3284, -10.6229>, <61.5066, 81.6521, -8.6398>, <61.9882, 81.2303, -11.5084> }
					triangle { <58.5897, 83.1541, -10.3984>, <61.4609, 81.312, -8.1276>, <60.3316, 82.3284, -10.6229> }
					triangle { <59.2435, 82.3298, -11.5286>, <60.3316, 82.3284, -10.6229>, <60.8911, 81.6079, -12.09746> }
					triangle { <58.5897, 83.1541, -10.3984>, <60.3316, 82.3284, -10.6229>, <59.2435, 82.3298, -11.5286> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <44.3553, 69.2436, -10.9475>, <45.5402, 70.6352, -11.5777>, 0.2192 }
			cylinder { <45.5402, 70.6352, -11.5777>, <46.7704, 71.9319, -12.3148>, 0.2192 }
			cylinder { <46.7704, 71.9319, -12.3148>, <48.03828, 73.1257, -13.1544>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <48.03828, 73.1257, -13.1544>, <49.9271, 74.7471, -14.6422>, 0.2192 }
				cylinder { <49.9271, 74.7471, -14.6422>, <51.7848, 76.1834, -16.3439>, 0.2192 }
				cylinder { <51.7848, 76.1834, -16.3439>, <53.5936, 77.4208, -18.2431>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <53.5936, 77.4208, -18.2431>, <59.8959, 82.8249, -26.01698>, <60.2028, 83.7757, -24.8408> }
					triangle { <53.5936, 77.4208, -18.2431>, <57.07515, 79.6604, -22.9428>, <59.8959, 82.8249, -26.01698> }
					triangle { <60.2028, 83.7757, -24.8408>, <58.4135, 80.7324, -21.4589>, <53.5936, 77.4208, -18.2431> }
					triangle { <57.07515, 79.6604, -22.9428>, <58.6126, 83.4601, -26.8999>, <59.8959, 82.8249, -26.01698> }
					triangle { <58.6126, 83.4601, -26.8999>, <57.7028, 86.02567, -27.328>, <59.8959, 82.8249, -26.01698> }
					triangle { <60.2028, 83.7757, -24.8408>, <60.4277, 85.5962, -24.4051>, <61.3756, 83.8861, -23.7688> }
					triangle { <61.3756, 83.8861, -23.7688>, <58.4135, 80.7324, -21.4589>, <60.2028, 83.7757, -24.8408> }
					triangle { <57.7028, 86.02567, -27.328>, <58.2959, 85.9803, -27.1673>, <59.8387, 84.7513, -25.7986> }
					triangle { <58.2959, 85.9803, -27.1673>, <57.109, 87.9722, -25.7681>, <60.00764, 86.7236, -24.8988> }
					triangle { <59.8387, 84.7513, -25.7986>, <60.00764, 86.7236, -24.8988>, <60.4277, 85.5962, -24.4051> }
					triangle { <59.8387, 84.7513, -25.7986>, <58.2959, 85.9803, -27.1673>, <60.00764, 86.7236, -24.8988> }
					triangle { <59.8959, 82.8249, -26.01698>, <57.7028, 86.02567, -27.328>, <59.8387, 84.7513, -25.7986> }
					triangle { <60.2028, 83.7757, -24.8408>, <59.8387, 84.7513, -25.7986>, <60.4277, 85.5962, -24.4051> }
					triangle { <59.8959, 82.8249, -26.01698>, <59.8387, 84.7513, -25.7986>, <60.2028, 83.7757, -24.8408> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <53.5936, 77.4208, -18.2431>, <60.6266, 83.4683, -24.8249>, <61.7145, 82.8223, -23.9414> }
					triangle { <53.5936, 77.4208, -18.2431>, <56.8376, 80.7567, -22.4351>, <60.6266, 83.4683, -24.8249> }
					triangle { <61.7145, 82.8223, -23.9414>, <58.6807, 79.4991, -22.03015>, <53.5936, 77.4208, -18.2431> }
					triangle { <56.8376, 80.7567, -22.4351>, <60.2418, 84.9762, -24.1862>, <60.6266, 83.4683, -24.8249> }
					triangle { <60.2418, 84.9762, -24.1862>, <61.6635, 86.8207, -22.7132>, <60.6266, 83.4683, -24.8249> }
					triangle { <61.7145, 82.8223, -23.9414>, <63.3426, 83.1861, -23.06295>, <62.6458, 81.5372, -24.07456> }
					triangle { <62.6458, 81.5372, -24.07456>, <58.6807, 79.4991, -22.03015>, <61.7145, 82.8223, -23.9414> }
					triangle { <61.6635, 86.8207, -22.7132>, <62.00489, 86.4313, -23.04715>, <62.1404, 84.1672, -23.8341> }
					triangle { <62.00489, 86.4313, -23.04715>, <63.04613, 86.6729, -20.5588>, <63.9153, 84.2494, -22.5805> }
					triangle { <62.1404, 84.1672, -23.8341>, <63.9153, 84.2494, -22.5805>, <63.3426, 83.1861, -23.06295> }
					triangle { <62.1404, 84.1672, -23.8341>, <62.00489, 86.4313, -23.04715>, <63.9153, 84.2494, -22.5805> }
					triangle { <60.6266, 83.4683, -24.8249>, <61.6635, 86.8207, -22.7132>, <62.1404, 84.1672, -23.8341> }
					triangle { <61.7145, 82.8223, -23.9414>, <62.1404, 84.1672, -23.8341>, <63.3426, 83.1861, -23.06295> }
					triangle { <60.6266, 83.4683, -24.8249>, <62.1404, 84.1672, -23.8341>, <61.7145, 82.8223, -23.9414> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <53.5936, 77.4208, -18.2431>, <61.7286, 82.5018, -24.3554>, <61.9876, 81.06803, -24.8638> }
					triangle { <53.5936, 77.4208, -18.2431>, <57.626, 80.9308, -21.5056>, <61.7286, 82.5018, -24.3554> }
					triangle { <61.9876, 81.06803, -24.8638>, <57.7937, 79.3033, -23.07586>, <53.5936, 77.4208, -18.2431> }
					triangle { <57.626, 80.9308, -21.5056>, <62.7705, 82.8127, -23.07179>, <61.7286, 82.5018, -24.3554> }
					triangle { <62.7705, 82.8127, -23.07179>, <65.2716, 81.8711, -22.4003>, <61.7286, 82.5018, -24.3554> }
					triangle { <61.9876, 81.06803, -24.8638>, <63.367, 79.8647, -25.3156>, <61.5157, 80.2291, -26.1328> }
					triangle { <61.5157, 80.2291, -26.1328>, <57.7937, 79.3033, -23.07586>, <61.9876, 81.06803, -24.8638> }
					triangle { <65.2716, 81.8711, -22.4003>, <65.1258, 81.8278, -22.9974>, <63.3184, 81.403, -24.5194> }
					triangle { <65.1258, 81.8278, -22.9974>, <66.2665, 79.5207, -22.1548>, <64.6127, 79.7156, -24.9731> }
					triangle { <63.3184, 81.403, -24.5194>, <64.6127, 79.7156, -24.9731>, <63.367, 79.8647, -25.3156> }
					triangle { <63.3184, 81.403, -24.5194>, <65.1258, 81.8278, -22.9974>, <64.6127, 79.7156, -24.9731> }
					triangle { <61.7286, 82.5018, -24.3554>, <65.2716, 81.8711, -22.4003>, <63.3184, 81.403, -24.5194> }
					triangle { <61.9876, 81.06803, -24.8638>, <63.3184, 81.403, -24.5194>, <63.367, 79.8647, -25.3156> }
					triangle { <61.7286, 82.5018, -24.3554>, <63.3184, 81.403, -24.5194>, <61.9876, 81.06803, -24.8638> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <53.5936, 77.4208, -18.2431>, <61.6892, 81.2521, -25.2529>, <60.6473, 80.9207, -26.3419> }
					triangle { <53.5936, 77.4208, -18.2431>, <58.3582, 79.9438, -21.4302>, <61.6892, 81.2521, -25.2529> }
					triangle { <60.6473, 80.9207, -26.3419>, <56.97, 80.4137, -23.1606>, <53.5936, 77.4208, -18.2431> }
					triangle { <58.3582, 79.9438, -21.4302>, <62.7277, 79.9392, -25.08635>, <61.6892, 81.2521, -25.2529> }
					triangle { <62.7277, 79.9392, -25.08635>, <63.5745, 77.9708, -26.8187>, <61.6892, 81.2521, -25.2529> }
					triangle { <60.6473, 80.9207, -26.3419>, <60.4674, 80.191, -28.07116>, <59.5365, 81.7574, -27.1183> }
					triangle { <59.5365, 81.7574, -27.1183>, <56.97, 80.4137, -23.1606>, <60.6473, 80.9207, -26.3419> }
					triangle { <63.5745, 77.9708, -26.8187>, <63.3749, 78.4886, -27.0864>, <61.7557, 80.2528, -26.9139> }
					triangle { <63.3749, 78.4886, -27.0864>, <62.3499, 76.3328, -28.3653>, <61.1425, 79.3455, -28.7925> }
					triangle { <61.7557, 80.2528, -26.9139>, <61.1425, 79.3455, -28.7925>, <60.4674, 80.191, -28.07116> }
					triangle { <61.7557, 80.2528, -26.9139>, <63.3749, 78.4886, -27.0864>, <61.1425, 79.3455, -28.7925> }
					triangle { <61.6892, 81.2521, -25.2529>, <63.5745, 77.9708, -26.8187>, <61.7557, 80.2528, -26.9139> }
					triangle { <60.6473, 80.9207, -26.3419>, <61.7557, 80.2528, -26.9139>, <60.4674, 80.191, -28.07116> }
					triangle { <61.6892, 81.2521, -25.2529>, <61.7557, 80.2528, -26.9139>, <60.6473, 80.9207, -26.3419> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <53.5936, 77.4208, -18.2431>, <60.5395, 81.4548, -26.2953>, <59.5276, 82.6194, -26.3275> }
					triangle { <53.5936, 77.4208, -18.2431>, <58.01262, 79.1468, -22.3319>, <60.5395, 81.4548, -26.2953> }
					triangle { <59.5276, 82.6194, -26.3275>, <57.3588, 81.3103, -22.1463>, <53.5936, 77.4208, -18.2431> }
					triangle { <58.01262, 79.1468, -22.3319>, <60.1192, 80.3453, -27.488>, <60.5395, 81.4548, -26.2953> }
					triangle { <60.1192, 80.3453, -27.488>, <58.8262, 80.5772, -29.9102>, <60.5395, 81.4548, -26.2953> }
					triangle { <59.5276, 82.6194, -26.3275>, <58.6234, 83.7868, -27.4999>, <59.4485, 84.05172, -25.6353> }
					triangle { <59.4485, 84.05172, -25.6353>, <57.3588, 81.3103, -22.1463>, <59.5276, 82.6194, -26.3275> }
					triangle { <58.8262, 80.5772, -29.9102>, <59.0901, 81.09381, -29.7024>, <59.5726, 82.3534, -27.7164> }
					triangle { <59.0901, 81.09381, -29.7024>, <56.6048, 81.6349, -30.6322>, <58.2535, 83.7421, -28.7458> }
					triangle { <59.5726, 82.3534, -27.7164>, <58.2535, 83.7421, -28.7458>, <58.6234, 83.7868, -27.4999> }
					triangle { <59.5726, 82.3534, -27.7164>, <59.0901, 81.09381, -29.7024>, <58.2535, 83.7421, -28.7458> }
					triangle { <60.5395, 81.4548, -26.2953>, <58.8262, 80.5772, -29.9102>, <59.5726, 82.3534, -27.7164> }
					triangle { <59.5276, 82.6194, -26.3275>, <59.5726, 82.3534, -27.7164>, <58.6234, 83.7868, -27.4999> }
					triangle { <60.5395, 81.4548, -26.2953>, <59.5726, 82.3534, -27.7164>, <59.5276, 82.6194, -26.3275> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <48.03828, 73.1257, -13.1544>, <49.2047, 74.429, -13.9782>, 0.2192 }
			cylinder { <49.2047, 74.429, -13.9782>, <50.2628, 75.8338, -14.7811>, 0.2192 }
			cylinder { <50.2628, 75.8338, -14.7811>, <51.2063, 77.3318, -15.558>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <51.2063, 77.3318, -15.558>, <52.4377, 79.7476, -16.5865>, 0.2192 }
				cylinder { <52.4377, 79.7476, -16.5865>, <53.4735, 82.3088, -17.468>, 0.2192 }
				cylinder { <53.4735, 82.3088, -17.468>, <54.3039, 84.9908, -18.1942>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <54.3039, 84.9908, -18.1942>, <58.1474, 95.6153, -19.4989>, <59.1111, 94.9485, -20.5028> }
					triangle { <54.3039, 84.9908, -18.1942>, <55.6664, 91.08919, -18.6164>, <58.1474, 95.6153, -19.4989> }
					triangle { <59.1111, 94.9485, -20.5028>, <56.6074, 90.7521, -20.6519>, <54.3039, 84.9908, -18.1942> }
					triangle { <55.6664, 91.08919, -18.6164>, <58.9185, 95.7274, -18.008>, <58.1474, 95.6153, -19.4989> }
					triangle { <58.9185, 95.7274, -18.008>, <61.5625, 95.941, -17.2618>, <58.1474, 95.6153, -19.4989> }
					triangle { <59.1111, 94.9485, -20.5028>, <60.8979, 94.9689, -21.1044>, <59.1043, 94.7248, -22.07978> }
					triangle { <59.1043, 94.7248, -22.07978>, <56.6074, 90.7521, -20.6519>, <59.1111, 94.9485, -20.5028> }
					triangle { <61.5625, 95.941, -17.2618>, <61.435, 96.1279, -17.8349>, <60.06891, 95.6747, -19.7564> }
					triangle { <61.435, 96.1279, -17.8349>, <63.6732, 94.6033, -17.8363>, <62.04355, 95.3033, -20.5878> }
					triangle { <60.06891, 95.6747, -19.7564>, <62.04355, 95.3033, -20.5878>, <60.8979, 94.9689, -21.1044> }
					triangle { <60.06891, 95.6747, -19.7564>, <61.435, 96.1279, -17.8349>, <62.04355, 95.3033, -20.5878> }
					triangle { <58.1474, 95.6153, -19.4989>, <61.5625, 95.941, -17.2618>, <60.06891, 95.6747, -19.7564> }
					triangle { <59.1111, 94.9485, -20.5028>, <60.06891, 95.6747, -19.7564>, <60.8979, 94.9689, -21.1044> }
					triangle { <58.1474, 95.6153, -19.4989>, <60.06891, 95.6747, -19.7564>, <59.1111, 94.9485, -20.5028> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <54.3039, 84.9908, -18.1942>, <58.7427, 95.1249, -20.8307>, <57.9917, 94.9036, -22.1605> }
					triangle { <54.3039, 84.9908, -18.1942>, <56.8164, 90.6945, -18.8107>, <58.7427, 95.1249, -20.8307> }
					triangle { <57.9917, 94.9036, -22.1605>, <55.3137, 91.1961, -20.4333>, <54.3039, 84.9908, -18.1942> }
					triangle { <56.8164, 90.6945, -18.8107>, <60.3299, 94.5993, -21.01676>, <58.7427, 95.1249, -20.8307> }
					triangle { <60.3299, 94.5993, -21.01676>, <62.01863, 94.4256, -23.1872>, <58.7427, 95.1249, -20.8307> }
					triangle { <57.9917, 94.9036, -22.1605>, <58.1509, 95.125, -24.02619>, <56.5706, 95.3441, -22.729> }
					triangle { <56.5706, 95.3441, -22.729>, <55.3137, 91.1961, -20.4333>, <57.9917, 94.9036, -22.1605> }
					triangle { <62.01863, 94.4256, -23.1872>, <61.56, 94.8334, -23.2427>, <59.2573, 95.2381, -22.6974> }
					triangle { <61.56, 94.8334, -23.2427>, <61.7932, 93.3892, -25.5217>, <59.1397, 95.1914, -24.8681> }
					triangle { <59.2573, 95.2381, -22.6974>, <59.1397, 95.1914, -24.8681>, <58.1509, 95.125, -24.02619> }
					triangle { <59.2573, 95.2381, -22.6974>, <61.56, 94.8334, -23.2427>, <59.1397, 95.1914, -24.8681> }
					triangle { <58.7427, 95.1249, -20.8307>, <62.01863, 94.4256, -23.1872>, <59.2573, 95.2381, -22.6974> }
					triangle { <57.9917, 94.9036, -22.1605>, <59.2573, 95.2381, -22.6974>, <58.1509, 95.125, -24.02619> }
					triangle { <58.7427, 95.1249, -20.8307>, <59.2573, 95.2381, -22.6974>, <57.9917, 94.9036, -22.1605> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <54.3039, 84.9908, -18.1942>, <57.6473, 95.2074, -21.9087>, <56.1612, 95.567, -21.6999> }
					triangle { <54.3039, 84.9908, -18.1942>, <56.9234, 90.3861, -19.9978>, <57.6473, 95.2074, -21.9087> }
					triangle { <56.1612, 95.567, -21.6999>, <55.1932, 91.5431, -19.09773>, <54.3039, 84.9908, -18.1942> }
					triangle { <56.9234, 90.3861, -19.9978>, <57.8719, 94.7656, -23.5163>, <57.6473, 95.2074, -21.9087> }
					triangle { <57.8719, 94.7656, -23.5163>, <56.5945, 95.4535, -25.8589>, <57.6473, 95.2074, -21.9087> }
					triangle { <56.1612, 95.567, -21.6999>, <54.7302, 96.5276, -22.4644>, <55.3277, 96.2354, -20.5187> }
					triangle { <55.3277, 96.2354, -20.5187>, <55.1932, 91.5431, -19.09773>, <56.1612, 95.567, -21.6999> }
					triangle { <56.5945, 95.4535, -25.8589>, <56.5367, 95.8593, -25.3988>, <56.3046, 96.06113, -23.0179> }
					triangle { <56.5367, 95.8593, -25.3988>, <54.1376, 95.4673, -26.5924>, <54.4097, 96.9084, -23.6658> }
					triangle { <56.3046, 96.06113, -23.0179>, <54.4097, 96.9084, -23.6658>, <54.7302, 96.5276, -22.4644> }
					triangle { <56.3046, 96.06113, -23.0179>, <56.5367, 95.8593, -25.3988>, <54.4097, 96.9084, -23.6658> }
					triangle { <57.6473, 95.2074, -21.9087>, <56.5945, 95.4535, -25.8589>, <56.3046, 96.06113, -23.0179> }
					triangle { <56.1612, 95.567, -21.6999>, <56.3046, 96.06113, -23.0179>, <54.7302, 96.5276, -22.4644> }
					triangle { <57.6473, 95.2074, -21.9087>, <56.3046, 96.06113, -23.0179>, <56.1612, 95.567, -21.6999> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <54.3039, 84.9908, -18.1942>, <56.3647, 95.7496, -21.2531>, <56.1322, 96.02816, -19.7532> }
					triangle { <54.3039, 84.9908, -18.1942>, <55.8406, 90.5873, -20.5483>, <56.3647, 95.7496, -21.2531> }
					triangle { <56.1322, 96.02816, -19.7532>, <56.4114, 91.3167, -18.4784>, <54.3039, 84.9908, -18.1942> }
					triangle { <55.8406, 90.5873, -20.5483>, <54.9185, 95.9981, -22.07572>, <56.3647, 95.7496, -21.2531> }
					triangle { <54.9185, 95.9981, -22.07572>, <52.7355, 97.6138, -21.6096>, <56.3647, 95.7496, -21.2531> }
					triangle { <56.1322, 96.02816, -19.7532>, <55.3313, 97.2514, -18.5628>, <57.08166, 96.1754, -18.4828> }
					triangle { <57.08166, 96.1754, -18.4828>, <56.4114, 91.3167, -18.4784>, <56.1322, 96.02816, -19.7532> }
					triangle { <52.7355, 97.6138, -21.6096>, <53.2602, 97.7973, -21.3438>, <55.2637, 97.0141, -20.278> }
					triangle { <53.2602, 97.7973, -21.3438>, <51.2148, 97.9852, -19.5788>, <54.3462, 98.0976, -18.631> }
					triangle { <55.2637, 97.0141, -20.278>, <54.3462, 98.0976, -18.631>, <55.3313, 97.2514, -18.5628> }
					triangle { <55.2637, 97.0141, -20.278>, <53.2602, 97.7973, -21.3438>, <54.3462, 98.0976, -18.631> }
					triangle { <56.3647, 95.7496, -21.2531>, <52.7355, 97.6138, -21.6096>, <55.2637, 97.0141, -20.278> }
					triangle { <56.1322, 96.02816, -19.7532>, <55.2637, 97.0141, -20.278>, <55.3313, 97.2514, -18.5628> }
					triangle { <56.3647, 95.7496, -21.2531>, <55.2637, 97.0141, -20.278>, <56.1322, 96.02816, -19.7532> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <54.3039, 84.9908, -18.1942>, <56.6785, 96.00554, -19.7413>, <57.9829, 95.6401, -19.00223> }
					triangle { <54.3039, 84.9908, -18.1942>, <55.05206, 91.02841, -19.6816>, <56.6785, 96.00554, -19.7413> }
					triangle { <57.9829, 95.6401, -19.00223>, <57.2986, 90.8205, -19.4534>, <54.3039, 84.9908, -18.1942> }
					triangle { <55.05206, 91.02841, -19.6816>, <55.575, 96.6014, -18.6199>, <56.6785, 96.00554, -19.7413> }
					triangle { <55.575, 96.6014, -18.6199>, <55.8522, 97.9196, -16.2161>, <56.6785, 96.00554, -19.7413> }
					triangle { <57.9829, 95.6401, -19.00223>, <59.2007, 96.2735, -17.7096>, <59.4509, 95.2277, -19.4622> }
					triangle { <59.4509, 95.2277, -19.4622>, <57.2986, 90.8205, -19.4534>, <57.9829, 95.6401, -19.00223> }
					triangle { <55.8522, 97.9196, -16.2161>, <56.3332, 97.9659, -16.5984>, <57.6253, 96.7717, -18.2319> }
					triangle { <56.3332, 97.9659, -16.5984>, <57.1971, 97.4432, -14.08561>, <59.1353, 97.09061, -16.7> }
					triangle { <57.6253, 96.7717, -18.2319>, <59.1353, 97.09061, -16.7>, <59.2007, 96.2735, -17.7096> }
					triangle { <57.6253, 96.7717, -18.2319>, <56.3332, 97.9659, -16.5984>, <59.1353, 97.09061, -16.7> }
					triangle { <56.6785, 96.00554, -19.7413>, <55.8522, 97.9196, -16.2161>, <57.6253, 96.7717, -18.2319> }
					triangle { <57.9829, 95.6401, -19.00223>, <57.6253, 96.7717, -18.2319>, <59.2007, 96.2735, -17.7096> }
					triangle { <56.6785, 96.00554, -19.7413>, <57.6253, 96.7717, -18.2319>, <57.9829, 95.6401, -19.00223> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <51.2063, 77.3318, -15.558>, <52.2726, 78.782, -16.2635>, 0.2192 }
			cylinder { <52.2726, 78.782, -16.2635>, <53.4554, 80.1756, -16.8933>, 0.2192 }
			cylinder { <53.4554, 80.1756, -16.8933>, <54.7476, 81.5042, -17.4437>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <54.7476, 81.5042, -17.4437>, <56.888, 83.3126, -18.1909>, 0.2192 }
				cylinder { <56.888, 83.3126, -18.1909>, <59.2099, 84.9192, -18.8524>, 0.2192 }
				cylinder { <59.2099, 84.9192, -18.8524>, <61.6909, 86.3085, -19.4219>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <61.6909, 86.3085, -19.4219>, <71.3714, 91.3562, -22.5889>, <70.4324, 92.5295, -22.9359> }
					triangle { <61.6909, 86.3085, -19.4219>, <67.4093, 88.5376, -20.6524>, <71.3714, 91.3562, -22.5889> }
					triangle { <70.4324, 92.5295, -22.9359>, <66.6289, 90.6604, -20.5038>, <61.6909, 86.3085, -19.4219> }
					triangle { <67.4093, 88.5376, -20.6524>, <71.6223, 90.4412, -23.977>, <71.3714, 91.3562, -22.5889> }
					triangle { <71.6223, 90.4412, -23.977>, <71.6099, 91.04707, -26.6636>, <71.3714, 91.3562, -22.5889> }
					triangle { <70.4324, 92.5295, -22.9359>, <70.1239, 93.8706, -24.2234>, <69.9595, 93.8454, -22.175> }
					triangle { <69.9595, 93.8454, -22.175>, <66.6289, 90.6604, -20.5038>, <70.4324, 92.5295, -22.9359> }
					triangle { <71.6099, 91.04707, -26.6636>, <71.7165, 91.5227, -26.2873>, <71.1393, 92.469, -24.1591> }
					triangle { <71.7165, 91.5227, -26.2873>, <69.9361, 92.2363, -28.1972>, <70.3863, 94.01506, -25.4882> }
					triangle { <71.1393, 92.469, -24.1591>, <70.3863, 94.01506, -25.4882>, <70.1239, 93.8706, -24.2234> }
					triangle { <71.1393, 92.469, -24.1591>, <71.7165, 91.5227, -26.2873>, <70.3863, 94.01506, -25.4882> }
					triangle { <71.3714, 91.3562, -22.5889>, <71.6099, 91.04707, -26.6636>, <71.1393, 92.469, -24.1591> }
					triangle { <70.4324, 92.5295, -22.9359>, <71.1393, 92.469, -24.1591>, <70.1239, 93.8706, -24.2234> }
					triangle { <71.3714, 91.3562, -22.5889>, <71.1393, 92.469, -24.1591>, <70.4324, 92.5295, -22.9359> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <61.6909, 86.3085, -19.4219>, <70.5995, 92.6808, -22.4634>, <70.2651, 93.4433, -21.1651> }
					triangle { <61.6909, 86.3085, -19.4219>, <66.8432, 89.1509, -21.5568>, <70.5995, 92.6808, -22.4634> }
					triangle { <70.2651, 93.4433, -21.1651>, <67.2657, 89.9705, -19.4863>, <61.6909, 86.3085, -19.4219> }
					triangle { <66.8432, 89.1509, -21.5568>, <69.8502, 93.46, -23.7513>, <70.5995, 92.6808, -22.4634> }
					triangle { <69.8502, 93.46, -23.7513>, <69.111, 96.07439, -24.2025>, <70.5995, 92.6808, -22.4634> }
					triangle { <70.2651, 93.4433, -21.1651>, <70.1594, 95.1755, -20.4304>, <70.7878, 93.3756, -19.663> }
					triangle { <70.7878, 93.3756, -19.663>, <67.2657, 89.9705, -19.4863>, <70.2651, 93.4433, -21.1651> }
					triangle { <69.111, 96.07439, -24.2025>, <69.56, 95.9958, -23.7884>, <70.3417, 94.5542, -22.03679> }
					triangle { <69.56, 95.9958, -23.7884>, <67.7491, 97.7804, -22.8598>, <69.9603, 96.3694, -20.904> }
					triangle { <70.3417, 94.5542, -22.03679>, <69.9603, 96.3694, -20.904>, <70.1594, 95.1755, -20.4304> }
					triangle { <70.3417, 94.5542, -22.03679>, <69.56, 95.9958, -23.7884>, <69.9603, 96.3694, -20.904> }
					triangle { <70.5995, 92.6808, -22.4634>, <69.111, 96.07439, -24.2025>, <70.3417, 94.5542, -22.03679> }
					triangle { <70.2651, 93.4433, -21.1651>, <70.3417, 94.5542, -22.03679>, <70.1594, 95.1755, -20.4304> }
					triangle { <70.5995, 92.6808, -22.4634>, <70.3417, 94.5542, -22.03679>, <70.2651, 93.4433, -21.1651> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <61.6909, 86.3085, -19.4219>, <70.6475, 93.1299, -20.993>, <71.2251, 92.3434, -19.7985> }
					triangle { <61.6909, 86.3085, -19.4219>, <66.3359, 90.1643, -21.07736>, <70.6475, 93.1299, -20.993> }
					triangle { <71.2251, 92.3434, -19.7985>, <67.8365, 88.8304, -20.02578>, <61.6909, 86.3085, -19.4219> }
					triangle { <66.3359, 90.1643, -21.07736>, <69.9265, 94.5337, -20.4128>, <70.6475, 93.1299, -20.993> }
					triangle { <69.9265, 94.5337, -20.4128>, <70.3855, 96.1172, -18.2066>, <70.6475, 93.1299, -20.993> }
					triangle { <71.2251, 92.3434, -19.7985>, <72.2258, 92.5466, -18.2146>, <72.1775, 91.07658, -19.6499> }
					triangle { <72.1775, 91.07658, -19.6499>, <67.8365, 88.8304, -20.02578>, <71.2251, 92.3434, -19.7985> }
					triangle { <70.3855, 96.1172, -18.2066>, <70.8641, 95.7752, -18.389>, <71.4765, 93.65, -19.3195> }
					triangle { <70.8641, 95.7752, -18.389>, <70.5981, 95.6321, -15.6992>, <72.4453, 93.5173, -17.3786> }
					triangle { <71.4765, 93.65, -19.3195>, <72.4453, 93.5173, -17.3786>, <72.2258, 92.5466, -18.2146> }
					triangle { <71.4765, 93.65, -19.3195>, <70.8641, 95.7752, -18.389>, <72.4453, 93.5173, -17.3786> }
					triangle { <70.6475, 93.1299, -20.993>, <70.3855, 96.1172, -18.2066>, <71.4765, 93.65, -19.3195> }
					triangle { <71.2251, 92.3434, -19.7985>, <71.4765, 93.65, -19.3195>, <72.2258, 92.5466, -18.2146> }
					triangle { <70.6475, 93.1299, -20.993>, <71.4765, 93.65, -19.3195>, <71.2251, 92.3434, -19.7985> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <61.6909, 86.3085, -19.4219>, <71.4495, 92.08701, -20.1959>, <71.9945, 90.7395, -20.7119> }
					triangle { <61.6909, 86.3085, -19.4219>, <66.5836, 90.1869, -19.8721>, <71.4495, 92.08701, -20.1959> }
					triangle { <71.9945, 90.7395, -20.7119>, <67.5578, 88.805, -21.3816>, <61.6909, 86.3085, -19.4219> }
					triangle { <66.5836, 90.1869, -19.8721>, <71.7465, 92.1885, -18.544>, <71.4495, 92.08701, -20.1959> }
					triangle { <71.7465, 92.1885, -18.544>, <73.684, 91.1167, -16.9063>, <71.4495, 92.08701, -20.1959> }
					triangle { <71.9945, 90.7395, -20.7119>, <73.4867, 89.5925, -20.6175>, <72.2211, 90.104, -22.1538> }
					triangle { <72.2211, 90.104, -22.1538>, <67.5578, 88.805, -21.3816>, <71.9945, 90.7395, -20.7119> }
					triangle { <73.684, 91.1167, -16.9063>, <73.8387, 91.1638, -17.5005>, <72.986, 90.9975, -19.7372> }
					triangle { <73.8387, 91.1638, -17.5005>, <74.5723, 88.7402, -16.5442>, <74.4305, 89.3737, -19.751> }
					triangle { <72.986, 90.9975, -19.7372>, <74.4305, 89.3737, -19.751>, <73.4867, 89.5925, -20.6175> }
					triangle { <72.986, 90.9975, -19.7372>, <73.8387, 91.1638, -17.5005>, <74.4305, 89.3737, -19.751> }
					triangle { <71.4495, 92.08701, -20.1959>, <73.684, 91.1167, -16.9063>, <72.986, 90.9975, -19.7372> }
					triangle { <71.9945, 90.7395, -20.7119>, <72.986, 90.9975, -19.7372>, <73.4867, 89.5925, -20.6175> }
					triangle { <71.4495, 92.08701, -20.1959>, <72.986, 90.9975, -19.7372>, <71.9945, 90.7395, -20.7119> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <61.6909, 86.3085, -19.4219>, <71.9037, 90.9742, -21.1971>, <71.4972, 90.8563, -22.6803> }
					triangle { <61.6909, 86.3085, -19.4219>, <67.2571, 89.1664, -19.6055>, <71.9037, 90.9742, -21.1971> }
					triangle { <71.4972, 90.8563, -22.6803>, <66.8001, 89.953, -21.6815>, <61.6909, 86.3085, -19.4219> }
					triangle { <67.2571, 89.1664, -19.6055>, <72.8104, 89.621, -20.7801>, <71.9037, 90.9742, -21.1971> }
					triangle { <72.8104, 89.621, -20.7801>, <74.4522, 87.9359, -22.2118>, <71.9037, 90.9742, -21.1971> }
					triangle { <71.4972, 90.8563, -22.6803>, <72.1681, 90.4231, -24.3872>, <70.8297, 91.8411, -23.7379> }
					triangle { <70.8297, 91.8411, -23.7379>, <66.8001, 89.953, -21.6815>, <71.4972, 90.8563, -22.6803> }
					triangle { <74.4522, 87.9359, -22.2118>, <74.3734, 88.4959, -22.4556>, <72.7745, 90.2566, -22.7734> }
					triangle { <74.3734, 88.4959, -22.4556>, <74.157, 86.6098, -24.3849>, <73.1387, 89.6859, -24.8386> }
					triangle { <72.7745, 90.2566, -22.7734>, <73.1387, 89.6859, -24.8386>, <72.1681, 90.4231, -24.3872> }
					triangle { <72.7745, 90.2566, -22.7734>, <74.3734, 88.4959, -22.4556>, <73.1387, 89.6859, -24.8386> }
					triangle { <71.9037, 90.9742, -21.1971>, <74.4522, 87.9359, -22.2118>, <72.7745, 90.2566, -22.7734> }
					triangle { <71.4972, 90.8563, -22.6803>, <72.7745, 90.2566, -22.7734>, <72.1681, 90.4231, -24.3872> }
					triangle { <71.9037, 90.9742, -21.1971>, <72.7745, 90.2566, -22.7734>, <71.4972, 90.8563, -22.6803> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <33.4571, 57.3252, -4.8738>, <35.04075, 58.4238, -5.02593>, 0.2192 }
			cylinder { <35.04075, 58.4238, -5.02593>, <36.6245, 59.5326, -5.02837>, 0.2192 }
			cylinder { <36.6245, 59.5326, -5.02837>, <38.199, 60.6449, -4.8811>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <38.199, 60.6449, -4.8811>, <39.8509, 61.5442, -4.434>, 0.2192 }
			cylinder { <39.8509, 61.5442, -4.434>, <41.5695, 62.3618, -4.09369>, 0.2192 }
			cylinder { <41.5695, 62.3618, -4.09369>, <43.3443, 63.09285, -3.8621>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <43.3443, 63.09285, -3.8621>, <46.06665, 64.08838, -3.774>, 0.2192 }
				cylinder { <46.06665, 64.08838, -3.774>, <48.8229, 64.9733, -3.9458>, 0.2192 }
				cylinder { <48.8229, 64.9733, -3.9458>, <51.5867, 65.7392, -4.3761>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <51.5867, 65.7392, -4.3761>, <62.0703, 69.6142, -6.4496>, <61.9788, 70.1082, -4.9914> }
					triangle { <51.5867, 65.7392, -4.3761>, <57.3898, 67.2934, -6.1344>, <62.0703, 69.6142, -6.4496> }
					triangle { <61.9788, 70.1082, -4.9914>, <58.02761, 67.4237, -3.9634>, <51.5867, 65.7392, -4.3761> }
					triangle { <57.3898, 67.2934, -6.1344>, <61.6146, 70.8697, -7.471>, <62.0703, 69.6142, -6.4496> }
					triangle { <61.6146, 70.8697, -7.471>, <61.7347, 73.6129, -7.2579>, <62.0703, 69.6142, -6.4496> }
					triangle { <61.9788, 70.1082, -4.9914>, <62.4131, 71.5607, -3.8721>, <62.4395, 69.5262, -3.5832> }
					triangle { <62.4395, 69.5262, -3.5832>, <58.02761, 67.4237, -3.9634>, <61.9788, 70.1082, -4.9914> }
					triangle { <61.7347, 73.6129, -7.2579>, <62.1327, 73.3041, -6.9037>, <62.4073, 71.3171, -5.5868> }
					triangle { <62.1327, 73.3041, -6.9037>, <60.962, 75.2801, -5.4715>, <62.602, 72.8352, -4.04383> }
					triangle { <62.4073, 71.3171, -5.5868>, <62.602, 72.8352, -4.04383>, <62.4131, 71.5607, -3.8721> }
					triangle { <62.4073, 71.3171, -5.5868>, <62.1327, 73.3041, -6.9037>, <62.602, 72.8352, -4.04383> }
					triangle { <62.0703, 69.6142, -6.4496>, <61.7347, 73.6129, -7.2579>, <62.4073, 71.3171, -5.5868> }
					triangle { <61.9788, 70.1082, -4.9914>, <62.4073, 71.3171, -5.5868>, <62.4131, 71.5607, -3.8721> }
					triangle { <62.0703, 69.6142, -6.4496>, <62.4073, 71.3171, -5.5868>, <61.9788, 70.1082, -4.9914> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <51.5867, 65.7392, -4.3761>, <62.2422, 69.6612, -4.9218>, <62.5333, 68.4738, -3.9814> }
					triangle { <51.5867, 65.7392, -4.3761>, <57.2203, 68.2676, -5.4019>, <62.2422, 69.6612, -4.9218> }
					triangle { <62.5333, 68.4738, -3.9814>, <58.2182, 66.3276, -4.7874>, <51.5867, 65.7392, -4.3761> }
					triangle { <57.2203, 68.2676, -5.4019>, <61.991, 71.03641, -3.9875>, <62.2422, 69.6612, -4.9218> }
					triangle { <61.991, 71.03641, -3.9875>, <62.9011, 71.8268, -1.5112>, <62.2422, 69.6612, -4.9218> }
					triangle { <62.5333, 68.4738, -3.9814>, <63.5321, 67.9757, -2.463>, <63.04021, 66.9795, -4.1919> }
					triangle { <63.04021, 66.9795, -4.1919>, <58.2182, 66.3276, -4.7874>, <62.5333, 68.4738, -3.9814> }
					triangle { <62.9011, 71.8268, -1.5112>, <63.2505, 71.409, -1.7986>, <63.1762, 69.4861, -3.2321> }
					triangle { <63.2505, 71.409, -1.7986>, <62.9272, 70.7144, 0.7974>, <64.03632, 68.6028, -1.4423> }
					triangle { <63.1762, 69.4861, -3.2321>, <64.03632, 68.6028, -1.4423>, <63.5321, 67.9757, -2.463> }
					triangle { <63.1762, 69.4861, -3.2321>, <63.2505, 71.409, -1.7986>, <64.03632, 68.6028, -1.4423> }
					triangle { <62.2422, 69.6612, -4.9218>, <62.9011, 71.8268, -1.5112>, <63.1762, 69.4861, -3.2321> }
					triangle { <62.5333, 68.4738, -3.9814>, <63.1762, 69.4861, -3.2321>, <63.5321, 67.9757, -2.463> }
					triangle { <62.2422, 69.6612, -4.9218>, <63.1762, 69.4861, -3.2321>, <62.5333, 68.4738, -3.9814> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <51.5867, 65.7392, -4.3761>, <62.6701, 68.264, -4.4411>, <62.7711, 66.9792, -5.2886> }
					triangle { <51.5867, 65.7392, -4.3761>, <57.4511, 67.9241, -4.243>, <62.6701, 68.264, -4.4411> }
					triangle { <62.7711, 66.9792, -5.2886>, <57.9585, 66.7142, -6.09125>, <51.5867, 65.7392, -4.3761> }
					triangle { <57.4511, 67.9241, -4.243>, <62.9681, 67.8712, -2.8336>, <62.6701, 68.264, -4.4411> }
					triangle { <62.9681, 67.8712, -2.8336>, <64.4573, 65.8987, -1.6185>, <62.6701, 68.264, -4.4411> }
					triangle { <62.7711, 66.9792, -5.2886>, <63.8287, 65.4432, -5.5597>, <62.8014, 66.6696, -6.8497> }
					triangle { <62.8014, 66.6696, -6.8497>, <57.9585, 66.7142, -6.09125>, <62.7711, 66.9792, -5.2886> }
					triangle { <64.4573, 65.8987, -1.6185>, <64.6246, 66.03707, -2.1948>, <63.7842, 66.6802, -4.3483> }
					triangle { <64.6246, 66.03707, -2.1948>, <64.5541, 63.3504, -1.8731>, <64.6483, 64.7454, -4.8312> }
					triangle { <63.7842, 66.6802, -4.3483>, <64.6483, 64.7454, -4.8312>, <63.8287, 65.4432, -5.5597> }
					triangle { <63.7842, 66.6802, -4.3483>, <64.6246, 66.03707, -2.1948>, <64.6483, 64.7454, -4.8312> }
					triangle { <62.6701, 68.264, -4.4411>, <64.4573, 65.8987, -1.6185>, <63.7842, 66.6802, -4.3483> }
					triangle { <62.7711, 66.9792, -5.2886>, <63.7842, 66.6802, -4.3483>, <63.8287, 65.4432, -5.5597> }
					triangle { <62.6701, 68.264, -4.4411>, <63.7842, 66.6802, -4.3483>, <62.7711, 66.9792, -5.2886> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <51.5867, 65.7392, -4.3761>, <62.7665, 67.3404, -5.6675>, <62.3658, 67.676, -7.1186> }
					triangle { <51.5867, 65.7392, -4.3761>, <57.7654, 66.7343, -4.2485>, <62.7665, 67.3404, -5.6675> }
					triangle { <62.3658, 67.676, -7.1186>, <57.605, 68.0527, -6.08515>, <51.5867, 65.7392, -4.3761> }
					triangle { <57.7654, 66.7343, -4.2485>, <63.2047, 65.7188, -5.5933>, <62.7665, 67.3404, -5.6675> }
					triangle { <63.2047, 65.7188, -5.5933>, <64.2672, 63.9657, -7.4326>, <62.7665, 67.3404, -5.6675> }
					triangle { <62.3658, 67.676, -7.1186>, <62.8957, 67.4395, -8.9115>, <62.05103, 69.02187, -7.9084> }
					triangle { <62.05103, 69.02187, -7.9084>, <57.605, 68.0527, -6.08515>, <62.3658, 67.676, -7.1186> }
					triangle { <64.2672, 63.9657, -7.4326>, <64.3689, 64.562, -7.5485>, <63.3967, 66.7509, -7.4034> }
					triangle { <64.3689, 64.562, -7.5485>, <63.6096, 63.2962, -9.8174>, <63.5979, 66.5578, -9.5588> }
					triangle { <63.3967, 66.7509, -7.4034>, <63.5979, 66.5578, -9.5588>, <62.8957, 67.4395, -8.9115> }
					triangle { <63.3967, 66.7509, -7.4034>, <64.3689, 64.562, -7.5485>, <63.5979, 66.5578, -9.5588> }
					triangle { <62.7665, 67.3404, -5.6675>, <64.2672, 63.9657, -7.4326>, <63.3967, 66.7509, -7.4034> }
					triangle { <62.3658, 67.676, -7.1186>, <63.3967, 66.7509, -7.4034>, <62.8957, 67.4395, -8.9115> }
					triangle { <62.7665, 67.3404, -5.6675>, <63.3967, 66.7509, -7.4034>, <62.3658, 67.676, -7.1186> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <51.5867, 65.7392, -4.3761>, <62.3902, 68.1875, -6.9276>, <61.8687, 69.639, -6.9322> }
					triangle { <51.5867, 65.7392, -4.3761>, <57.7269, 66.3386, -5.435>, <62.3902, 68.1875, -6.9276> }
					triangle { <61.8687, 69.639, -6.9322>, <57.6483, 68.4978, -4.7502>, <51.5867, 65.7392, -4.3761> }
					triangle { <57.7269, 66.3386, -5.435>, <62.3556, 67.6, -8.5026>, <62.3902, 68.1875, -6.9276> }
					triangle { <62.3556, 67.6, -8.5026>, <62.5591, 68.8054, -10.9706>, <62.3902, 68.1875, -6.9276> }
					triangle { <61.8687, 69.639, -6.9322>, <62.00765, 71.2774, -7.8528>, <61.824, 70.814, -5.8591> }
					triangle { <61.824, 70.814, -5.8591>, <57.6483, 68.4978, -4.7502>, <61.8687, 69.639, -6.9322> }
					triangle { <62.5591, 68.8054, -10.9706>, <62.8055, 69.121, -10.5027>, <62.5329, 69.6599, -8.1804> }
					triangle { <62.8055, 69.121, -10.5027>, <61.3561, 70.7805, -12.07491>, <62.3141, 71.6331, -9.06486> }
					triangle { <62.5329, 69.6599, -8.1804>, <62.3141, 71.6331, -9.06486>, <62.00765, 71.2774, -7.8528> }
					triangle { <62.5329, 69.6599, -8.1804>, <62.8055, 69.121, -10.5027>, <62.3141, 71.6331, -9.06486> }
					triangle { <62.3902, 68.1875, -6.9276>, <62.5591, 68.8054, -10.9706>, <62.5329, 69.6599, -8.1804> }
					triangle { <61.8687, 69.639, -6.9322>, <62.5329, 69.6599, -8.1804>, <62.00765, 71.2774, -7.8528> }
					triangle { <62.3902, 68.1875, -6.9276>, <62.5329, 69.6599, -8.1804>, <61.8687, 69.639, -6.9322> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <38.199, 60.6449, -4.8811>, <39.6364, 61.928, -5.03932>, 0.2192 }
			cylinder { <39.6364, 61.928, -5.03932>, <41.00587, 63.2917, -5.09094>, 0.2192 }
			cylinder { <41.00587, 63.2917, -5.09094>, <42.2989, 64.7279, -5.03561>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <42.2989, 64.7279, -5.03561>, <44.1314, 66.95, -4.6978>, 0.2192 }
				cylinder { <44.1314, 66.95, -4.6978>, <45.8392, 69.2186, -4.1085>, 0.2192 }
				cylinder { <45.8392, 69.2186, -4.1085>, <47.4058, 71.5117, -3.2733>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <47.4058, 71.5117, -3.2733>, <54.2021, 79.8435, 0.416>, <54.816, 79.7185, -0.9933> }
					triangle { <47.4058, 71.5117, -3.2733>, <50.5385, 76.2699, -0.6793>, <54.2021, 79.8435, 0.416> }
					triangle { <54.816, 79.7185, -0.9933>, <51.1381, 77.01378, -2.7347>, <47.4058, 71.5117, -3.2733> }
					triangle { <50.5385, 76.2699, -0.6793>, <55.1031, 78.9026, 1.479>, <54.2021, 79.8435, 0.416> }
					triangle { <55.1031, 78.9026, 1.479>, <57.7392, 78.1064, 1.5237>, <54.2021, 79.8435, 0.416> }
					triangle { <54.816, 79.7185, -0.9933>, <56.4577, 79.7325, -1.9184>, <54.5958, 80.4704, -2.379> }
					triangle { <54.5958, 80.4704, -2.379>, <51.1381, 77.01378, -2.7347>, <54.816, 79.7185, -0.9933> }
					triangle { <57.7392, 78.1064, 1.5237>, <57.6237, 78.6148, 1.1959>, <56.0149, 79.6593, -0.2457> }
					triangle { <57.6237, 78.6148, 1.1959>, <59.2708, 76.9753, -0.1917>, <57.6923, 79.4636, -1.6136> }
					triangle { <56.0149, 79.6593, -0.2457>, <57.6923, 79.4636, -1.6136>, <56.4577, 79.7325, -1.9184> }
					triangle { <56.0149, 79.6593, -0.2457>, <57.6237, 78.6148, 1.1959>, <57.6923, 79.4636, -1.6136> }
					triangle { <54.2021, 79.8435, 0.416>, <57.7392, 78.1064, 1.5237>, <56.0149, 79.6593, -0.2457> }
					triangle { <54.816, 79.7185, -0.9933>, <56.0149, 79.6593, -0.2457>, <56.4577, 79.7325, -1.9184> }
					triangle { <54.2021, 79.8435, 0.416>, <56.0149, 79.6593, -0.2457>, <54.816, 79.7185, -0.9933> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <47.4058, 71.5117, -3.2733>, <54.4918, 80.1226, -1.06864>, <53.5908, 80.8792, -2.06603> }
					triangle { <47.4058, 71.5117, -3.2733>, <51.487, 75.8459, -1.339>, <54.4918, 80.1226, -1.06864> }
					triangle { <53.5908, 80.8792, -2.06603>, <50.07114, 77.4907, -1.9926>, <47.4058, 71.5117, -3.2733> }
					triangle { <51.487, 75.8459, -1.339>, <55.8142, 79.5042, -1.9027>, <54.4918, 80.1226, -1.06864> }
					triangle { <55.8142, 79.5042, -1.9027>, <57.1592, 80.3067, -4.1681>, <54.4918, 80.1226, -1.06864> }
					triangle { <53.5908, 80.8792, -2.06603>, <53.6385, 82.1165, -3.4865>, <52.33, 81.8409, -1.926> }
					triangle { <52.33, 81.8409, -1.926>, <50.07114, 77.4907, -1.9926>, <53.5908, 80.8792, -2.06603> }
					triangle { <57.1592, 80.3067, -4.1681>, <56.8461, 80.7502, -3.8773>, <54.8422, 81.205, -2.6382> }
					triangle { <56.8461, 80.7502, -3.8773>, <56.4117, 80.9096, -6.5442>, <54.5173, 82.4664, -4.3779> }
					triangle { <54.8422, 81.205, -2.6382>, <54.5173, 82.4664, -4.3779>, <53.6385, 82.1165, -3.4865> }
					triangle { <54.8422, 81.205, -2.6382>, <56.8461, 80.7502, -3.8773>, <54.5173, 82.4664, -4.3779> }
					triangle { <54.4918, 80.1226, -1.06864>, <57.1592, 80.3067, -4.1681>, <54.8422, 81.205, -2.6382> }
					triangle { <53.5908, 80.8792, -2.06603>, <54.8422, 81.205, -2.6382>, <53.6385, 82.1165, -3.4865> }
					triangle { <54.4918, 80.1226, -1.06864>, <54.8422, 81.205, -2.6382>, <53.5908, 80.8792, -2.06603> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <47.4058, 71.5117, -3.2733>, <53.3818, 81.03805, -1.613>, <52.1059, 81.4928, -0.8754> }
					triangle { <47.4058, 71.5117, -3.2733>, <51.3841, 76.2799, -2.4859>, <53.3818, 81.03805, -1.613> }
					triangle { <52.1059, 81.4928, -0.8754>, <50.1868, 77.00252, -0.7023>, <47.4058, 71.5117, -3.2733> }
					triangle { <51.3841, 76.2799, -2.4859>, <53.3105, 81.5909, -3.1993>, <53.3818, 81.03805, -1.613> }
					triangle { <53.3105, 81.5909, -3.1993>, <52.09911, 83.7596, -4.3885>, <53.3818, 81.03805, -1.613> }
					triangle { <52.1059, 81.4928, -0.8754>, <50.9782, 82.9792, -0.6109>, <51.6319, 81.489, 0.6442> }
					triangle { <51.6319, 81.489, 0.6442>, <50.1868, 77.00252, -0.7023>, <52.1059, 81.4928, -0.8754> }
					triangle { <52.09911, 83.7596, -4.3885>, <52.2118, 83.8191, -3.786>, <52.2731, 82.6255, -1.7053> }
					triangle { <52.2118, 83.8191, -3.786>, <49.7113, 84.6895, -4.3481>, <50.6823, 84.04701, -1.2904> }
					triangle { <52.2731, 82.6255, -1.7053>, <50.6823, 84.04701, -1.2904>, <50.9782, 82.9792, -0.6109> }
					triangle { <52.2731, 82.6255, -1.7053>, <52.2118, 83.8191, -3.786>, <50.6823, 84.04701, -1.2904> }
					triangle { <53.3818, 81.03805, -1.613>, <52.09911, 83.7596, -4.3885>, <52.2731, 82.6255, -1.7053> }
					triangle { <52.1059, 81.4928, -0.8754>, <52.2731, 82.6255, -1.7053>, <50.9782, 82.9792, -0.6109> }
					triangle { <53.3818, 81.03805, -1.613>, <52.2731, 82.6255, -1.7053>, <52.1059, 81.4928, -0.8754> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <47.4058, 71.5117, -3.2733>, <52.3958, 81.3331, -0.4698>, <52.3995, 80.717, 0.9441> }
					triangle { <47.4058, 71.5117, -3.2733>, <50.3712, 76.9762, -2.5458>, <52.3958, 81.3331, -0.4698> }
					triangle { <52.3995, 80.717, 0.9441>, <51.3264, 76.2192, -0.6349>, <47.4058, 71.5117, -3.2733> }
					triangle { <50.3712, 76.9762, -2.5458>, <51.0286, 82.2984, -0.6309>, <52.3958, 81.3331, -0.4698> }
					triangle { <51.0286, 82.2984, -0.6309>, <49.5046, 83.7255, 1.1651>, <52.3958, 81.3331, -0.4698> }
					triangle { <52.3995, 80.717, 0.9441>, <52.1285, 81.1364, 2.7612>, <53.4598, 79.8979, 1.8036> }
					triangle { <53.4598, 79.8979, 1.8036>, <51.3264, 76.2192, -0.6349>, <52.3995, 80.717, 0.9441> }
					triangle { <49.5046, 83.7255, 1.1651>, <50.08213, 83.6091, 1.3445>, <51.8339, 81.9708, 1.2724> }
					triangle { <50.08213, 83.6091, 1.3445>, <48.3668, 83.1267, 3.382>, <51.4513, 82.03581, 3.4108> }
					triangle { <51.8339, 81.9708, 1.2724>, <51.4513, 82.03581, 3.4108>, <52.1285, 81.1364, 2.7612> }
					triangle { <51.8339, 81.9708, 1.2724>, <50.08213, 83.6091, 1.3445>, <51.4513, 82.03581, 3.4108> }
					triangle { <52.3958, 81.3331, -0.4698>, <49.5046, 83.7255, 1.1651>, <51.8339, 81.9708, 1.2724> }
					triangle { <52.3995, 80.717, 0.9441>, <51.8339, 81.9708, 1.2724>, <52.1285, 81.1364, 2.7612> }
					triangle { <52.3958, 81.3331, -0.4698>, <51.8339, 81.9708, 1.2724>, <52.3995, 80.717, 0.9441> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <47.4058, 71.5117, -3.2733>, <52.9104, 80.5837, 0.8031>, <54.09975, 79.604, 0.8702> }
					triangle { <47.4058, 71.5117, -3.2733>, <49.8407, 76.9699, -1.4125>, <52.9104, 80.5837, 0.8031> }
					triangle { <54.09975, 79.604, 0.8702>, <51.9232, 76.2263, -1.9099>, <47.4058, 71.5117, -3.2733> }
					triangle { <49.8407, 76.9699, -1.4125>, <52.1532, 80.6119, 2.3041>, <52.9104, 80.5837, 0.8031> }
					triangle { <52.1532, 80.6119, 2.3041>, <53.04308, 80.1789, 4.8743>, <52.9104, 80.5837, 0.8031> }
					triangle { <54.09975, 79.604, 0.8702>, <55.5661, 79.09961, 1.9409>, <55.3192, 79.2588, -0.09305> }
					triangle { <55.3192, 79.2588, -0.09305>, <51.9232, 76.2263, -1.9099>, <54.09975, 79.604, 0.8702> }
					triangle { <53.04308, 80.1789, 4.8743>, <53.4773, 80.344, 4.47>, <54.1813, 80.1099, 2.1881> }
					triangle { <53.4773, 80.344, 4.47>, <54.3641, 78.2871, 5.9896>, <55.8491, 79.1603, 3.208> }
					triangle { <54.1813, 80.1099, 2.1881>, <55.8491, 79.1603, 3.208>, <55.5661, 79.09961, 1.9409> }
					triangle { <54.1813, 80.1099, 2.1881>, <53.4773, 80.344, 4.47>, <55.8491, 79.1603, 3.208> }
					triangle { <52.9104, 80.5837, 0.8031>, <53.04308, 80.1789, 4.8743>, <54.1813, 80.1099, 2.1881> }
					triangle { <54.09975, 79.604, 0.8702>, <54.1813, 80.1099, 2.1881>, <55.5661, 79.09961, 1.9409> }
					triangle { <52.9104, 80.5837, 0.8031>, <54.1813, 80.1099, 2.1881>, <54.09975, 79.604, 0.8702> }
					material { txgilia_flower }}
				}
			}
		}
	union { // internode
		cylinder { <2.884, 26.02572, 0.4477>, <8.3206, 40.1713, -0.3201>, 0.4589 }
		cylinder { <8.3206, 40.1713, -0.3201>, <13.4491, 54.4205, -1.2697>, 0.4589 }
		cylinder { <13.4491, 54.4205, -1.2697>, <18.2664, 68.7649, -2.4003>, 0.4589 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <18.2664, 68.7649, -2.4003>, <18.3471, 73.6579, -3.5764>, 0.3262 }
			cylinder { <18.3471, 73.6579, -3.5764>, <16.9013, 78.114, -5.416>, 0.3262 }
			cylinder { <16.9013, 78.114, -5.416>, <14.09805, 81.6122, -7.7041>, 0.3262 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <14.09805, 81.6122, -7.7041>, <12.8845, 83.04545, -8.6745>, 0.3262 }
				cylinder { <12.8845, 83.04545, -8.6745>, <11.6355, 84.4418, -9.6536>, 0.3262 }
				cylinder { <11.6355, 84.4418, -9.6536>, <10.3518, 85.8004, -10.6409>, 0.3262 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <10.3518, 85.8004, -10.6409>, <10.2289, 85.948, -10.8201>, 0.01702 }
				cylinder { <10.2289, 85.948, -10.8201>, <10.1516, 86.06355, -11.04304>, 0.01702 }
				cylinder { <10.1516, 86.06355, -11.04304>, <10.1255, 86.1387, -11.2933>, 0.01702 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <10.1255, 86.1387, -11.2933>, <7.2346, 91.99, -28.6239>, <7.4967, 90.6008, -29.2896> }
				triangle { <7.2346, 91.99, -28.6239>, <0.5142, 90.9149, -32.4259>, <7.4967, 90.6008, -29.2896> }
				triangle { <7.2346, 91.99, -28.6239>, <1.4783, 92.3758, -31.2928>, <0.5142, 90.9149, -32.4259> }
				triangle { <0.5142, 90.9149, -32.4259>, <2.5378, 89.5894, -32.3073>, <7.4967, 90.6008, -29.2896> }
				triangle { <7.4967, 90.6008, -29.2896>, <7.8125, 87.883, -22.3751>, <10.1255, 86.1387, -11.2933> }
				triangle { <10.1255, 86.1387, -11.2933>, <6.9835, 90.3821, -21.4755>, <7.2346, 91.99, -28.6239> }
				triangle { <6.9835, 90.3821, -21.4755>, <4.9553, 92.9235, -27.7567>, <7.2346, 91.99, -28.6239> }
				triangle { <4.9553, 92.9235, -27.7567>, <1.4783, 92.3758, -31.2928>, <7.2346, 91.99, -28.6239> }
				triangle { <7.4967, 90.6008, -29.2896>, <2.5378, 89.5894, -32.3073>, <5.5416, 88.8828, -29.6947> }
				triangle { <5.5416, 88.8828, -29.6947>, <7.8125, 87.883, -22.3751>, <7.4967, 90.6008, -29.2896> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <10.3518, 85.8004, -10.6409>, <10.1923, 85.9693, -10.7635>, 0.01702 }
				cylinder { <10.1923, 85.9693, -10.7635>, <10.0328, 86.1381, -10.8862>, 0.01702 }
				cylinder { <10.0328, 86.1381, -10.8862>, <9.8732, 86.3069, -11.00895>, 0.01702 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <9.8732, 86.3069, -11.00895>, <-2.03517, 98.2671, -18.6303>, <-2.2507, 97.4403, -19.9386> }
				triangle { <-2.03517, 98.2671, -18.6303>, <-9.7668, 97.2827, -18.4637>, <-2.2507, 97.4403, -19.9386> }
				triangle { <-2.03517, 98.2671, -18.6303>, <-8.2731, 98.2829, -17.4074>, <-9.7668, 97.2827, -18.4637> }
				triangle { <-9.7668, 97.2827, -18.4637>, <-8.08435, 96.6212, -20.07557>, <-2.2507, 97.4403, -19.9386> }
				triangle { <-2.2507, 97.4403, -19.9386>, <1.7934, 92.1216, -16.6749>, <9.8732, 86.3069, -11.00895> }
				triangle { <9.8732, 86.3069, -11.00895>, <1.7185, 93.6481, -14.3498>, <-2.03517, 98.2671, -18.6303> }
				triangle { <1.7185, 93.6481, -14.3498>, <-3.3894, 98.08798, -16.4048>, <-2.03517, 98.2671, -18.6303> }
				triangle { <-3.3894, 98.08798, -16.4048>, <-8.2731, 98.2829, -17.4074>, <-2.03517, 98.2671, -18.6303> }
				triangle { <-2.2507, 97.4403, -19.9386>, <-8.08435, 96.6212, -20.07557>, <-4.1627, 95.638, -20.1233> }
				triangle { <-4.1627, 95.638, -20.1233>, <1.7934, 92.1216, -16.6749>, <-2.2507, 97.4403, -19.9386> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <18.2664, 68.7649, -2.4003>, <21.0643, 84.8512, -4.9857>, 0.5 }
		cylinder { <21.0643, 84.8512, -4.9857>, <21.3295, 100.9227, -8.8486>, 0.5 }
		cylinder { <21.3295, 100.9227, -8.8486>, <19.05419, 116.5059, -13.8753>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <19.05419, 116.5059, -13.8753>, <15.749, 122.6931, -17.08604>, 0.4999 }
			cylinder { <15.749, 122.6931, -17.08604>, <10.5869, 127.072, -20.7864>, 0.4999 }
			cylinder { <10.5869, 127.072, -20.7864>, <4.1714, 129.1306, -24.5437>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <4.1714, 129.1306, -24.5437>, <1.4264, 129.8449, -26.1099>, 0.4999 }
				cylinder { <1.4264, 129.8449, -26.1099>, <-1.3624, 130.4071, -27.6606>, 0.4999 }
				cylinder { <-1.3624, 130.4071, -27.6606>, <-4.1884, 130.8159, -29.1918>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <-4.1884, 130.8159, -29.1918>, <-4.6445, 130.859, -29.6054>, 0.03999 }
				cylinder { <-4.6445, 130.859, -29.6054>, <-4.991, 130.8646, -30.116>, 0.03999 }
				cylinder { <-4.991, 130.8646, -30.116>, <-5.2072, 130.8325, -30.6932>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-5.2072, 130.8325, -30.6932>, <-16.9532, 128.4337, -56.4226>, <-15.6027, 126.5782, -57.1082> }
				triangle { <-16.9532, 128.4337, -56.4226>, <-25.3943, 120.3896, -59.03551>, <-15.6027, 126.5782, -57.1082> }
				triangle { <-16.9532, 128.4337, -56.4226>, <-25.145, 123.4554, -58.168>, <-25.3943, 120.3896, -59.03551> }
				triangle { <-25.3943, 120.3896, -59.03551>, <-21.6921, 120.273, -59.2845>, <-15.6027, 126.5782, -57.1082> }
				triangle { <-15.6027, 126.5782, -57.1082>, <-11.6753, 126.4265, -46.4092>, <-5.2072, 130.8325, -30.6932> }
				triangle { <-5.2072, 130.8325, -30.6932>, <-14.6186, 129.3666, -45.4701>, <-16.9532, 128.4337, -56.4226> }
				triangle { <-14.6186, 129.3666, -45.4701>, <-20.4771, 128.2987, -54.5294>, <-16.9532, 128.4337, -56.4226> }
				triangle { <-20.4771, 128.2987, -54.5294>, <-25.145, 123.4554, -58.168>, <-16.9532, 128.4337, -56.4226> }
				triangle { <-15.6027, 126.5782, -57.1082>, <-21.6921, 120.273, -59.2845>, <-16.7747, 122.7699, -56.4573> }
				triangle { <-16.7747, 122.7699, -56.4573>, <-11.6753, 126.4265, -46.4092>, <-15.6027, 126.5782, -57.1082> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <-4.1884, 130.8159, -29.1918>, <-4.7267, 130.8938, -29.4835>, 0.03999 }
				cylinder { <-4.7267, 130.8938, -29.4835>, <-5.265, 130.9717, -29.7751>, 0.03999 }
				cylinder { <-5.265, 130.9717, -29.7751>, <-5.8032, 131.0495, -30.06685>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-5.8032, 131.0495, -30.06685>, <-31.5244, 133.6453, -41.789>, <-31.2136, 131.8916, -43.3905> }
				triangle { <-31.5244, 133.6453, -41.789>, <-40.7056, 126.4986, -39.0654>, <-31.2136, 131.8916, -43.3905> }
				triangle { <-31.5244, 133.6453, -41.789>, <-39.5226, 129.3528, -38.248>, <-40.7056, 126.4986, -39.0654> }
				triangle { <-40.7056, 126.4986, -39.0654>, <-38.09597, 126.2934, -41.6978>, <-31.2136, 131.8916, -43.3905> }
				triangle { <-31.2136, 131.8916, -43.3905>, <-21.4024, 129.7165, -38.01249>, <-5.8032, 131.0495, -30.06685> }
				triangle { <-5.8032, 131.0495, -30.06685>, <-22.5941, 132.5503, -35.05641>, <-31.5244, 133.6453, -41.789> }
				triangle { <-22.5941, 132.5503, -35.05641>, <-32.979, 133.3072, -38.07549>, <-31.5244, 133.6453, -41.789> }
				triangle { <-32.979, 133.3072, -38.07549>, <-39.5226, 129.3528, -38.248>, <-31.5244, 133.6453, -41.789> }
				triangle { <-31.2136, 131.8916, -43.3905>, <-38.09597, 126.2934, -41.6978>, <-32.2212, 128.0733, -42.5503> }
				triangle { <-32.2212, 128.0733, -42.5503>, <-21.4024, 129.7165, -38.01249>, <-31.2136, 131.8916, -43.3905> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <19.05419, 116.5059, -13.8753>, <14.6518, 131.3047, -19.7828>, 0.5 }
		cylinder { <14.6518, 131.3047, -19.7828>, <8.2177, 144.9986, -26.4433>, 0.5 }
		cylinder { <8.2177, 144.9986, -26.4433>, <-0.1088, 157.2911, -33.7126>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1088, 157.2911, -33.7126>, <-5.6955, 161.0464, -37.4727>, 0.4997 }
			cylinder { <-5.6955, 161.0464, -37.4727>, <-12.3323, 162.3843, -41.1627>, 0.4997 }
			cylinder { <-12.3323, 162.3843, -41.1627>, <-19.243, 161.1485, -44.3512>, 0.4997 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-19.243, 161.1485, -44.3512>, <-22.1406, 160.5531, -45.669>, 0.4997 }
				cylinder { <-22.1406, 160.5531, -45.669>, <-25.03176, 159.8816, -46.9645>, 0.4997 }
				cylinder { <-25.03176, 159.8816, -46.9645>, <-27.9144, 159.1346, -48.2369>, 0.4997 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <-27.9144, 159.1346, -48.2369>, <-28.3709, 158.9619, -48.6136>, 0.03995 }
				cylinder { <-28.3709, 158.9619, -48.6136>, <-28.702, 158.7712, -49.09758>, 0.03995 }
				cylinder { <-28.702, 158.7712, -49.09758>, <-28.8836, 158.5764, -49.6535>, 0.03995 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-28.8836, 158.5764, -49.6535>, <-38.6558, 148.2961, -74.2239>, <-36.7568, 146.9019, -74.649> }
				triangle { <-38.6558, 148.2961, -74.2239>, <-43.9181, 137.6205, -75.2132>, <-36.7568, 146.9019, -74.649> }
				triangle { <-38.6558, 148.2961, -74.2239>, <-44.71, 140.6948, -74.8591>, <-43.9181, 137.6205, -75.2132> }
				triangle { <-43.9181, 137.6205, -75.2132>, <-40.3818, 138.686, -75.5693>, <-36.7568, 146.9019, -74.649> }
				triangle { <-36.7568, 146.9019, -74.649>, <-33.2176, 149.7941, -64.214>, <-28.8836, 158.5764, -49.6535> }
				triangle { <-28.8836, 158.5764, -49.6535>, <-36.9817, 151.7158, -63.6575>, <-38.6558, 148.2961, -74.2239> }
				triangle { <-36.9817, 151.7158, -63.6575>, <-41.9743, 147.3233, -72.2126>, <-38.6558, 148.2961, -74.2239> }
				triangle { <-41.9743, 147.3233, -72.2126>, <-44.71, 140.6948, -74.8591>, <-38.6558, 148.2961, -74.2239> }
				triangle { <-36.7568, 146.9019, -74.649>, <-40.3818, 138.686, -75.5693>, <-36.6218, 143.0821, -73.3548> }
				triangle { <-36.6218, 143.0821, -73.3548>, <-33.2176, 149.7941, -64.214>, <-36.7568, 146.9019, -74.649> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <-27.9144, 159.1346, -48.2369>, <-28.4632, 158.9923, -48.4792>, 0.03995 }
				cylinder { <-28.4632, 158.9923, -48.4792>, <-29.01209, 158.8501, -48.7214>, 0.03995 }
				cylinder { <-29.01209, 158.8501, -48.7214>, <-29.5608, 158.7079, -48.9637>, 0.03995 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-29.5608, 158.7079, -48.9637>, <-55.3226, 151.235, -58.2033>, <-54.5516, 149.4155, -59.5545> }
				triangle { <-55.3226, 151.235, -58.2033>, <-61.5762, 142.1961, -53.531>, <-54.5516, 149.4155, -59.5545> }
				triangle { <-55.3226, 151.235, -58.2033>, <-61.3276, 145.3697, -53.2662>, <-61.5762, 142.1961, -53.531> }
				triangle { <-61.5762, 142.1961, -53.531>, <-59.1806, 142.3546, -56.3601>, <-54.5516, 149.4155, -59.5545> }
				triangle { <-54.5516, 149.4155, -59.5545>, <-44.2987, 151.3124, -54.9657>, <-29.5608, 158.7079, -48.9637> }
				triangle { <-29.5608, 158.7079, -48.9637>, <-46.1773, 154.104, -52.3487>, <-55.3226, 151.235, -58.2033> }
				triangle { <-46.1773, 154.104, -52.3487>, <-56.3959, 151.1078, -54.3516>, <-55.3226, 151.235, -58.2033> }
				triangle { <-56.3959, 151.1078, -54.3516>, <-61.3276, 145.3697, -53.2662>, <-55.3226, 151.235, -58.2033> }
				triangle { <-54.5516, 149.4155, -59.5545>, <-59.1806, 142.3546, -56.3601>, <-54.2396, 145.6774, -58.06695> }
				triangle { <-54.2396, 145.6774, -58.06695>, <-44.2987, 151.3124, -54.9657>, <-54.5516, 149.4155, -59.5545> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <-0.1088, 157.2911, -33.7126>, <-7.5931, 171.1385, -38.7638>, 0.5 }
		cylinder { <-7.5931, 171.1385, -38.7638>, <-14.01497, 186.1331, -41.4483>, 0.5 }
		cylinder { <-14.01497, 186.1331, -41.4483>, <-19.1851, 201.8333, -41.6869>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-19.1851, 201.8333, -41.6869>, <-20.07901, 207.5365, -40.1443>, 0.3872 }
			cylinder { <-20.07901, 207.5365, -40.1443>, <-19.9077, 212.6923, -37.1286>, 0.3872 }
			cylinder { <-19.9077, 212.6923, -37.1286>, <-18.6886, 216.7802, -32.9443>, 0.3872 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-18.6886, 216.7802, -32.9443>, <-18.1124, 218.4113, -31.1261>, 0.3872 }
				cylinder { <-18.1124, 218.4113, -31.1261>, <-17.4734, 219.9527, -29.2515>, 0.3872 }
				cylinder { <-17.4734, 219.9527, -29.2515>, <-16.7731, 221.4007, -27.325>, 0.3872 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <-16.7731, 221.4007, -27.325>, <-16.7471, 221.5842, -27.00444>, 0.02399 }
				cylinder { <-16.7471, 221.5842, -27.00444>, <-16.8001, 221.7265, -26.6667>, 0.02399 }
				cylinder { <-16.8001, 221.7265, -26.6667>, <-16.9288, 221.819, -26.3321>, 0.02399 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-16.9288, 221.819, -26.3321>, <-22.7075, 226.5266, -5.6477>, <-23.445, 224.8613, -5.2942> }
				triangle { <-22.7075, 226.5266, -5.6477>, <-17.718, 223.9645, 1.7147>, <-23.445, 224.8613, -5.2942> }
				triangle { <-22.7075, 226.5266, -5.6477>, <-18.02137, 225.9277, 0.2376>, <-17.718, 223.9645, 1.7147> }
				triangle { <-17.718, 223.9645, 1.7147>, <-19.8932, 222.6928, 0.3291>, <-23.445, 224.8613, -5.2942> }
				triangle { <-23.445, 224.8613, -5.2942>, <-20.2826, 222.4195, -13.1669>, <-16.9288, 221.819, -26.3321> }
				triangle { <-16.9288, 221.819, -26.3321>, <-18.7375, 225.3362, -13.3016>, <-22.7075, 226.5266, -5.6477> }
				triangle { <-18.7375, 225.3362, -13.3016>, <-19.7638, 227.4041, -5.228>, <-22.7075, 226.5266, -5.6477> }
				triangle { <-19.7638, 227.4041, -5.228>, <-18.02137, 225.9277, 0.2376>, <-22.7075, 226.5266, -5.6477> }
				triangle { <-23.445, 224.8613, -5.2942>, <-19.8932, 222.6928, 0.3291>, <-21.7237, 222.5366, -4.1056> }
				triangle { <-21.7237, 222.5366, -4.1056>, <-20.2826, 222.4195, -13.1669>, <-23.445, 224.8613, -5.2942> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <-16.7731, 221.4007, -27.325>, <-16.6698, 221.6143, -27.04078>, 0.02399 }
				cylinder { <-16.6698, 221.6143, -27.04078>, <-16.5665, 221.828, -26.7565>, 0.02399 }
				cylinder { <-16.5665, 221.828, -26.7565>, <-16.4631, 222.0416, -26.4723>, 0.02399 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-16.4631, 222.0416, -26.4723>, <-8.5014, 233.5354, -9.5047>, <-9.1788, 232.4037, -8.2> }
				triangle { <-8.5014, 233.5354, -9.5047>, <-0.7365, 231.234, -5.02414>, <-9.1788, 232.4037, -8.2> }
				triangle { <-8.5014, 233.5354, -9.5047>, <-1.4844, 232.7365, -6.8437>, <-0.7365, 231.234, -5.02414> }
				triangle { <-0.7365, 231.234, -5.02414>, <-3.4927, 230.5518, -4.5698>, <-9.1788, 232.4037, -8.2> }
				triangle { <-9.1788, 232.4037, -8.2>, <-11.5476, 227.0918, -14.842>, <-16.4631, 222.0416, -26.4723> }
				triangle { <-16.4631, 222.0416, -26.4723>, <-9.8812, 229.1013, -16.8664>, <-8.5014, 233.5354, -9.5047> }
				triangle { <-9.8812, 229.1013, -16.8664>, <-5.7464, 233.3409, -10.9131>, <-8.5014, 233.5354, -9.5047> }
				triangle { <-5.7464, 233.3409, -10.9131>, <-1.4844, 232.7365, -6.8437>, <-8.5014, 233.5354, -9.5047> }
				triangle { <-9.1788, 232.4037, -8.2>, <-3.4927, 230.5518, -4.5698>, <-7.5186, 229.9829, -7.1215> }
				triangle { <-7.5186, 229.9829, -7.1215>, <-11.5476, 227.0918, -14.842>, <-9.1788, 232.4037, -8.2> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <-19.1851, 201.8333, -41.6869>, <-24.1628, 217.4983, -42.7138>, 0.4981 }
		cylinder { <-24.1628, 217.4983, -42.7138>, <-28.9557, 233.1497, -44.5276>, 0.4981 }
		cylinder { <-28.9557, 233.1497, -44.5276>, <-33.5522, 248.7497, -47.1237>, 0.4981 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-33.5522, 248.7497, -47.1237>, <-34.1316, 251.5483, -48.6593>, 0.2102 }
			cylinder { <-34.1316, 251.5483, -48.6593>, <-34.3171, 253.7452, -51.0396>, 0.2102 }
			cylinder { <-34.3171, 253.7452, -51.0396>, <-34.08717, 255.0835, -53.9861>, 0.2102 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-34.08717, 255.0835, -53.9861>, <-33.9905, 255.6455, -55.2237>, 0.2102 }
				cylinder { <-33.9905, 255.6455, -55.2237>, <-33.8939, 256.2076, -56.4613>, 0.2102 }
				cylinder { <-33.8939, 256.2076, -56.4613>, <-33.7973, 256.7697, -57.6988>, 0.2102 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <-33.7973, 256.7697, -57.6988>, <-33.7629, 256.822, -57.7882>, 0.007074 }
				cylinder { <-33.7629, 256.822, -57.7882>, <-33.7042, 256.878, -57.8613>, 0.007074 }
				cylinder { <-33.7042, 256.878, -57.8613>, <-33.6256, 256.9334, -57.9128>, 0.007074 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-33.6256, 256.9334, -57.9128>, <-25.4425, 262.9171, -64.2169>, <-24.656, 262.3941, -63.867> }
				triangle { <-25.4425, 262.9171, -64.2169>, <-23.4801, 261.1969, -68.5116>, <-24.656, 262.3941, -63.867> }
				triangle { <-25.4425, 262.9171, -64.2169>, <-24.4598, 262.0156, -68.09152>, <-23.4801, 261.1969, -68.5116> }
				triangle { <-23.4801, 261.1969, -68.5116>, <-23.02543, 261.0537, -67.02486>, <-24.656, 262.3941, -63.867> }
				triangle { <-24.656, 262.3941, -63.867>, <-27.8817, 259.558, -61.7387>, <-33.6256, 256.9334, -57.9128> }
				triangle { <-33.6256, 256.9334, -57.9128>, <-29.1527, 260.4583, -62.6282>, <-25.4425, 262.9171, -64.2169> }
				triangle { <-29.1527, 260.4583, -62.6282>, <-26.3796, 262.5658, -65.5704>, <-25.4425, 262.9171, -64.2169> }
				triangle { <-26.3796, 262.5658, -65.5704>, <-24.4598, 262.0156, -68.09152>, <-25.4425, 262.9171, -64.2169> }
				triangle { <-24.656, 262.3941, -63.867>, <-23.02543, 261.0537, -67.02486>, <-24.1046, 260.9938, -64.6532> }
				triangle { <-24.1046, 260.9938, -64.6532>, <-27.8817, 259.558, -61.7387>, <-24.656, 262.3941, -63.867> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <-33.7973, 256.7697, -57.6988>, <-33.7896, 256.8147, -57.798>, 0.007074 }
				cylinder { <-33.7896, 256.8147, -57.798>, <-33.7818, 256.8597, -57.8971>, 0.007074 }
				cylinder { <-33.7818, 256.8597, -57.8971>, <-33.7741, 256.9047, -57.9962>, 0.007074 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-33.7741, 256.9047, -57.9962>, <-33.5898, 261.4468, -69.03451>, <-32.6238, 261.2221, -69.2105> }
				triangle { <-33.5898, 261.4468, -69.03451>, <-34.02571, 258.6324, -73.1749>, <-32.6238, 261.2221, -69.2105> }
				triangle { <-33.5898, 261.4468, -69.03451>, <-34.7928, 259.3759, -72.3594>, <-34.02571, 258.6324, -73.1749> }
				triangle { <-34.02571, 258.6324, -73.1749>, <-32.7799, 259.114, -72.3663>, <-32.6238, 261.2221, -69.2105> }
				triangle { <-32.6238, 261.2221, -69.2105>, <-32.7319, 258.8643, -65.03842>, <-33.7741, 256.9047, -57.9962> }
				triangle { <-33.7741, 256.9047, -57.9962>, <-34.5005, 259.1606, -64.9998>, <-33.5898, 261.4468, -69.03451> }
				triangle { <-34.5005, 259.1606, -64.9998>, <-34.9337, 260.481, -69.3422>, <-33.5898, 261.4468, -69.03451> }
				triangle { <-34.9337, 260.481, -69.3422>, <-34.7928, 259.3759, -72.3594>, <-33.5898, 261.4468, -69.03451> }
				triangle { <-32.6238, 261.2221, -69.2105>, <-32.7799, 259.114, -72.3663>, <-32.1734, 259.7422, -69.9106> }
				triangle { <-32.1734, 259.7422, -69.9106>, <-32.7319, 258.8643, -65.03842>, <-32.6238, 261.2221, -69.2105> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <-33.5522, 248.7497, -47.1237>, <-35.6227, 253.556, -47.5016>, 0.1586 }
		cylinder { <-35.6227, 253.556, -47.5016>, <-38.2545, 258.0945, -47.4222>, 0.1586 }
		cylinder { <-38.2545, 258.0945, -47.4222>, <-41.3905, 262.2669, -46.8871>, 0.1586 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-41.3905, 262.2669, -46.8871>, <-41.9142, 262.6544, -46.6875>, 0.04415 }
			cylinder { <-41.9142, 262.6544, -46.6875>, <-42.493, 262.8424, -46.3813>, 0.04415 }
			cylinder { <-42.493, 262.8424, -46.3813>, <-43.05947, 262.8088, -46.00411>, 0.04415 }
			material { txgilia_petiole }}
		union { // compound leaf
				cylinder { <-43.05947, 262.8088, -46.00411>, <-43.2973, 262.7946, -45.8456>, 0.04415 }
				cylinder { <-43.2973, 262.7946, -45.8456>, <-43.5352, 262.7805, -45.6872>, 0.04415 }
				cylinder { <-43.5352, 262.7805, -45.6872>, <-43.7731, 262.7664, -45.5288>, 0.04415 }
				material { txgilia_petiole }
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <-41.3905, 262.2669, -46.8871>, <-42.2511, 263.6822, -46.7003>, 0.189 }
			cylinder { <-42.2511, 263.6822, -46.7003>, <-42.9676, 265.1736, -46.4986>, 0.189 }
			cylinder { <-42.9676, 265.1736, -46.4986>, <-43.5333, 266.7267, -46.2838>, 0.189 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <-43.5333, 266.7267, -46.2838>, <-43.9426, 268.3267, -46.05806>, 0.189 }
			cylinder { <-43.9426, 268.3267, -46.05806>, <-44.1916, 269.9581, -45.8235>, 0.189 }
			cylinder { <-44.1916, 269.9581, -45.8235>, <-44.2779, 271.6051, -45.5824>, 0.189 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <-44.2779, 271.6051, -45.5824>, <-44.4818, 273.2545, -45.455>, 0.189 }
			cylinder { <-44.4818, 273.2545, -45.455>, <-44.8014, 274.8904, -45.4424>, 0.189 }
			cylinder { <-44.8014, 274.8904, -45.4424>, <-45.2336, 276.497, -45.5448>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-45.2336, 276.497, -45.5448>, <-46.08408, 278.8194, -45.9118>, 0.189 }
				cylinder { <-46.08408, 278.8194, -45.9118>, <-47.1238, 281.0194, -46.4867>, 0.189 }
				cylinder { <-47.1238, 281.0194, -46.4867>, <-48.3372, 283.0639, -47.2607>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-48.3372, 283.0639, -47.2607>, <-55.1301, 291.7663, -49.9125>, <-54.1168, 292.5739, -49.07943> }
					triangle { <-48.3372, 283.0639, -47.2607>, <-52.3339, 287.3827, -49.3733>, <-55.1301, 291.7663, -49.9125> }
					triangle { <-54.1168, 292.5739, -49.07943>, <-50.7918, 289.0021, -49.02077>, <-48.3372, 283.0639, -47.2607> }
					triangle { <-52.3339, 287.3827, -49.3733>, <-56.4093, 291.3237, -48.9185>, <-55.1301, 291.7663, -49.9125> }
					triangle { <-56.4093, 291.3237, -48.9185>, <-57.5256, 292.4494, -46.6705>, <-55.1301, 291.7663, -49.9125> }
					triangle { <-54.1168, 292.5739, -49.07943>, <-53.9891, 293.9606, -47.8131>, <-52.8264, 293.4374, -49.4218> }
					triangle { <-52.8264, 293.4374, -49.4218>, <-50.7918, 289.0021, -49.02077>, <-54.1168, 292.5739, -49.07943> }
					triangle { <-57.5256, 292.4494, -46.6705>, <-57.2154, 292.8381, -47.03253>, <-55.2992, 293.0337, -48.4586> }
					triangle { <-57.2154, 292.8381, -47.03253>, <-56.5624, 293.267, -44.4444>, <-54.7743, 294.4579, -46.9068> }
					triangle { <-55.2992, 293.0337, -48.4586>, <-54.7743, 294.4579, -46.9068>, <-53.9891, 293.9606, -47.8131> }
					triangle { <-55.2992, 293.0337, -48.4586>, <-57.2154, 292.8381, -47.03253>, <-54.7743, 294.4579, -46.9068> }
					triangle { <-55.1301, 291.7663, -49.9125>, <-57.5256, 292.4494, -46.6705>, <-55.2992, 293.0337, -48.4586> }
					triangle { <-54.1168, 292.5739, -49.07943>, <-55.2992, 293.0337, -48.4586>, <-53.9891, 293.9606, -47.8131> }
					triangle { <-55.1301, 291.7663, -49.9125>, <-55.2992, 293.0337, -48.4586>, <-54.1168, 292.5739, -49.07943> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-48.3372, 283.0639, -47.2607>, <-53.9373, 292.6687, -49.5613>, <-52.7048, 292.9626, -50.4375> }
					triangle { <-48.3372, 283.0639, -47.2607>, <-52.1183, 287.9341, -48.2962>, <-53.9373, 292.6687, -49.5613> }
					triangle { <-52.7048, 292.9626, -50.4375>, <-51.03432, 288.3817, -50.2325>, <-48.3372, 283.0639, -47.2607> }
					triangle { <-52.1183, 287.9341, -48.2962>, <-53.712, 293.3886, -48.06091>, <-53.9373, 292.6687, -49.5613> }
					triangle { <-53.712, 293.3886, -48.06091>, <-52.3044, 295.5987, -47.2237>, <-53.9373, 292.6687, -49.5613> }
					triangle { <-52.7048, 292.9626, -50.4375>, <-51.5306, 294.34, -50.9538>, <-52.3552, 292.7622, -51.9755> }
					triangle { <-52.3552, 292.7622, -51.9755>, <-51.03432, 288.3817, -50.2325>, <-52.7048, 292.9626, -50.4375> }
					triangle { <-52.3044, 295.5987, -47.2237>, <-52.4617, 295.5973, -47.8184>, <-52.7483, 294.187, -49.7347> }
					triangle { <-52.4617, 295.5973, -47.8184>, <-49.887, 296.3757, -47.5469>, <-51.1288, 295.4561, -50.4264> }
					triangle { <-52.7483, 294.187, -49.7347>, <-51.1288, 295.4561, -50.4264>, <-51.5306, 294.34, -50.9538> }
					triangle { <-52.7483, 294.187, -49.7347>, <-52.4617, 295.5973, -47.8184>, <-51.1288, 295.4561, -50.4264> }
					triangle { <-53.9373, 292.6687, -49.5613>, <-52.3044, 295.5987, -47.2237>, <-52.7483, 294.187, -49.7347> }
					triangle { <-52.7048, 292.9626, -50.4375>, <-52.7483, 294.187, -49.7347>, <-51.5306, 294.34, -50.9538> }
					triangle { <-53.9373, 292.6687, -49.5613>, <-52.7483, 294.187, -49.7347>, <-52.7048, 292.9626, -50.4375> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-48.3372, 283.0639, -47.2607>, <-53.03355, 292.7763, -50.799>, <-53.1808, 292.009, -52.1266> }
					triangle { <-48.3372, 283.0639, -47.2607>, <-51.07168, 288.5713, -48.3919>, <-53.03355, 292.7763, -50.799> }
					triangle { <-53.1808, 292.009, -52.1266>, <-52.2118, 287.6649, -50.1248>, <-48.3372, 283.0639, -47.2607> }
					triangle { <-51.07168, 288.5713, -48.3919>, <-51.613, 293.6706, -50.8518>, <-53.03355, 292.7763, -50.799> }
					triangle { <-51.613, 293.6706, -50.8518>, <-50.1701, 294.7957, -52.9057>, <-53.03355, 292.7763, -50.799> }
					triangle { <-53.1808, 292.009, -52.1266>, <-53.03568, 292.2067, -53.9928>, <-54.3446, 291.1639, -52.8044> }
					triangle { <-54.3446, 291.1639, -52.8044>, <-52.2118, 287.6649, -50.1248>, <-53.1808, 292.009, -52.1266> }
					triangle { <-50.1701, 294.7957, -52.9057>, <-50.7644, 294.6942, -53.02722>, <-52.5822, 293.1817, -52.6377> }
					triangle { <-50.7644, 294.6942, -53.02722>, <-49.2456, 293.8894, -55.1138>, <-52.3694, 292.986, -54.7891> }
					triangle { <-52.5822, 293.1817, -52.6377>, <-52.3694, 292.986, -54.7891>, <-53.03568, 292.2067, -53.9928> }
					triangle { <-52.5822, 293.1817, -52.6377>, <-50.7644, 294.6942, -53.02722>, <-52.3694, 292.986, -54.7891> }
					triangle { <-53.03355, 292.7763, -50.799>, <-50.1701, 294.7957, -52.9057>, <-52.5822, 293.1817, -52.6377> }
					triangle { <-53.1808, 292.009, -52.1266>, <-52.5822, 293.1817, -52.6377>, <-53.03568, 292.2067, -53.9928> }
					triangle { <-53.03355, 292.7763, -50.799>, <-52.5822, 293.1817, -52.6377>, <-53.1808, 292.009, -52.1266> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-48.3372, 283.0639, -47.2607>, <-53.6593, 291.9414, -51.9268>, <-54.8914, 291.0221, -51.8283> }
					triangle { <-48.3372, 283.0639, -47.2607>, <-50.6305, 288.4196, -49.529>, <-53.6593, 291.9414, -51.9268> }
					triangle { <-54.8914, 291.0221, -51.8283>, <-52.7081, 287.8355, -48.8455>, <-48.3372, 283.0639, -47.2607> }
					triangle { <-50.6305, 288.4196, -49.529>, <-52.9934, 291.7825, -53.4603>, <-53.6593, 291.9414, -51.9268> }
					triangle { <-52.9934, 291.7825, -53.4603>, <-54.05225, 291.1427, -55.9171>, <-53.6593, 291.9414, -51.9268> }
					triangle { <-54.8914, 291.0221, -51.8283>, <-56.4383, 290.489, -52.7587>, <-56.06398, 290.8363, -50.7706> }
					triangle { <-56.06398, 290.8363, -50.7706>, <-52.7081, 287.8355, -48.8455>, <-54.8914, 291.0221, -51.8283> }
					triangle { <-54.05225, 291.1427, -55.9171>, <-54.4533, 291.3685, -55.5091>, <-55.02885, 291.3977, -53.1828> }
					triangle { <-54.4533, 291.3685, -55.5091>, <-55.5187, 289.2208, -56.7585>, <-56.793, 290.438, -54.00647> }
					triangle { <-55.02885, 291.3977, -53.1828>, <-56.793, 290.438, -54.00647>, <-56.4383, 290.489, -52.7587> }
					triangle { <-55.02885, 291.3977, -53.1828>, <-54.4533, 291.3685, -55.5091>, <-56.793, 290.438, -54.00647> }
					triangle { <-53.6593, 291.9414, -51.9268>, <-54.05225, 291.1427, -55.9171>, <-55.02885, 291.3977, -53.1828> }
					triangle { <-54.8914, 291.0221, -51.8283>, <-55.02885, 291.3977, -53.1828>, <-56.4383, 290.489, -52.7587> }
					triangle { <-53.6593, 291.9414, -51.9268>, <-55.02885, 291.3977, -53.1828>, <-54.8914, 291.0221, -51.8283> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-48.3372, 283.0639, -47.2607>, <-54.9746, 291.3077, -51.3706>, <-55.4786, 291.3765, -49.9165> }
					triangle { <-48.3372, 283.0639, -47.2607>, <-51.4224, 287.6739, -50.1448>, <-54.9746, 291.3077, -51.3706> }
					triangle { <-55.4786, 291.3765, -49.9165>, <-51.8172, 288.6744, -48.1529>, <-48.3372, 283.0639, -47.2607> }
					triangle { <-51.4224, 287.6739, -50.1448>, <-56.00241, 290.3101, -52.2474>, <-54.9746, 291.3077, -51.3706> }
					triangle { <-56.00241, 290.3101, -52.2474>, <-58.6668, 289.6707, -52.00547>, <-54.9746, 291.3077, -51.3706> }
					triangle { <-55.4786, 291.3765, -49.9165>, <-57.03646, 291.5894, -48.8818>, <-55.1115, 292.2626, -48.6485> }
					triangle { <-55.1115, 292.2626, -48.6485>, <-51.8172, 288.6744, -48.1529>, <-55.4786, 291.3765, -49.9165> }
					triangle { <-58.6668, 289.6707, -52.00547>, <-58.5004, 290.2041, -51.7483>, <-56.7334, 291.3049, -50.561> }
					triangle { <-58.5004, 290.2041, -51.7483>, <-60.109, 288.8304, -50.06487>, <-58.3018, 291.3614, -49.06138> }
					triangle { <-56.7334, 291.3049, -50.561>, <-58.3018, 291.3614, -49.06138>, <-57.03646, 291.5894, -48.8818> }
					triangle { <-56.7334, 291.3049, -50.561>, <-58.5004, 290.2041, -51.7483>, <-58.3018, 291.3614, -49.06138> }
					triangle { <-54.9746, 291.3077, -51.3706>, <-58.6668, 289.6707, -52.00547>, <-56.7334, 291.3049, -50.561> }
					triangle { <-55.4786, 291.3765, -49.9165>, <-56.7334, 291.3049, -50.561>, <-57.03646, 291.5894, -48.8818> }
					triangle { <-54.9746, 291.3077, -51.3706>, <-56.7334, 291.3049, -50.561>, <-55.4786, 291.3765, -49.9165> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-45.2336, 276.497, -45.5448>, <-45.6575, 278.1079, -45.484>, 0.189 }
			cylinder { <-45.6575, 278.1079, -45.484>, <-46.06901, 279.7077, -45.2604>, 0.189 }
			cylinder { <-46.06901, 279.7077, -45.2604>, <-46.4641, 281.2808, -44.8762>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-46.4641, 281.2808, -44.8762>, <-47.01812, 283.5587, -44.00702>, 0.189 }
				cylinder { <-47.01812, 283.5587, -44.00702>, <-47.5251, 285.7206, -42.8578>, 0.189 }
				cylinder { <-47.5251, 285.7206, -42.8578>, <-47.9774, 287.734, -41.446>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-47.9774, 287.734, -41.446>, <-48.7278, 297.016, -34.9642>, <-49.1666, 297.6791, -36.2825> }
					triangle { <-47.9774, 287.734, -41.446>, <-48.4594, 292.3136, -37.2234>, <-48.7278, 297.016, -34.9642> }
					triangle { <-49.1666, 297.6791, -36.2825>, <-49.8744, 293.438, -38.584>, <-47.9774, 287.734, -41.446> }
					triangle { <-48.4594, 292.3136, -37.2234>, <-47.07751, 297.2507, -34.7701>, <-48.7278, 297.016, -34.9642> }
					triangle { <-47.07751, 297.2507, -34.7701>, <-45.342, 299.2086, -35.6135>, <-48.7278, 297.016, -34.9642> }
					triangle { <-49.1666, 297.6791, -36.2825>, <-48.9787, 299.2492, -37.3009>, <-50.5688, 297.9999, -36.9572> }
					triangle { <-50.5688, 297.9999, -36.9572>, <-49.8744, 293.438, -38.584>, <-49.1666, 297.6791, -36.2825> }
					triangle { <-45.342, 299.2086, -35.6135>, <-45.9319, 299.3777, -35.5796>, <-48.1783, 298.614, -35.9066> }
					triangle { <-45.9319, 299.3777, -35.5796>, <-44.8498, 300.2649, -37.8906>, <-48.07838, 300.1771, -37.4074> }
					triangle { <-48.1783, 298.614, -35.9066>, <-48.07838, 300.1771, -37.4074>, <-48.9787, 299.2492, -37.3009> }
					triangle { <-48.1783, 298.614, -35.9066>, <-45.9319, 299.3777, -35.5796>, <-48.07838, 300.1771, -37.4074> }
					triangle { <-48.7278, 297.016, -34.9642>, <-45.342, 299.2086, -35.6135>, <-48.1783, 298.614, -35.9066> }
					triangle { <-49.1666, 297.6791, -36.2825>, <-48.1783, 298.614, -35.9066>, <-48.9787, 299.2492, -37.3009> }
					triangle { <-48.7278, 297.016, -34.9642>, <-48.1783, 298.614, -35.9066>, <-49.1666, 297.6791, -36.2825> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-47.9774, 287.734, -41.446>, <-49.6329, 297.5853, -36.06612>, <-51.1177, 297.2592, -36.3088> }
					triangle { <-47.9774, 287.734, -41.446>, <-48.1202, 293.0415, -38.1528>, <-49.6329, 297.5853, -36.06612> }
					triangle { <-51.1177, 297.2592, -36.3088>, <-50.256, 292.619, -37.5384>, <-47.9774, 287.734, -41.446> }
					triangle { <-48.1202, 293.0415, -38.1528>, <-49.09263, 298.5771, -37.3074>, <-49.6329, 297.5853, -36.06612> }
					triangle { <-49.09263, 298.5771, -37.3074>, <-50.3404, 300.4114, -38.9306>, <-49.6329, 297.5853, -36.06612> }
					triangle { <-51.1177, 297.2592, -36.3088>, <-52.7606, 298.0396, -36.7878>, <-52.2617, 296.5645, -35.4526> }
					triangle { <-52.2617, 296.5645, -35.4526>, <-50.256, 292.619, -37.5384>, <-51.1177, 297.2592, -36.3088> }
					triangle { <-50.3404, 300.4114, -38.9306>, <-50.6228, 300.2989, -38.3963>, <-51.1192, 298.5815, -36.8025> }
					triangle { <-50.6228, 300.2989, -38.3963>, <-52.4284, 300.3258, -40.4058>, <-53.1222, 299.0848, -37.4659> }
					triangle { <-51.1192, 298.5815, -36.8025>, <-53.1222, 299.0848, -37.4659>, <-52.7606, 298.0396, -36.7878> }
					triangle { <-51.1192, 298.5815, -36.8025>, <-50.6228, 300.2989, -38.3963>, <-53.1222, 299.0848, -37.4659> }
					triangle { <-49.6329, 297.5853, -36.06612>, <-50.3404, 300.4114, -38.9306>, <-51.1192, 298.5815, -36.8025> }
					triangle { <-51.1177, 297.2592, -36.3088>, <-51.1192, 298.5815, -36.8025>, <-52.7606, 298.0396, -36.7878> }
					triangle { <-49.6329, 297.5853, -36.06612>, <-51.1192, 298.5815, -36.8025>, <-51.1177, 297.2592, -36.3088> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-47.9774, 287.734, -41.446>, <-51.06454, 297.0894, -35.8175>, <-51.5247, 296.0769, -34.7531> }
					triangle { <-47.9774, 287.734, -41.446>, <-49.1147, 293.2921, -38.8287>, <-51.06454, 297.0894, -35.8175> }
					triangle { <-51.5247, 296.0769, -34.7531>, <-49.1372, 292.3372, -36.778>, <-47.9774, 287.734, -41.446> }
					triangle { <-49.1147, 293.2921, -38.8287>, <-52.3759, 297.4769, -36.7904>, <-51.06454, 297.0894, -35.8175> }
					triangle { <-52.3759, 297.4769, -36.7904>, <-55.08957, 297.5389, -36.3558>, <-51.06454, 297.0894, -35.8175> }
					triangle { <-51.5247, 296.0769, -34.7531>, <-52.9061, 295.7206, -33.5273>, <-50.8727, 295.4651, -33.4397> }
					triangle { <-50.8727, 295.4651, -33.4397>, <-49.1372, 292.3372, -36.778>, <-51.5247, 296.0769, -34.7531> }
					triangle { <-55.08957, 297.5389, -36.3558>, <-54.7418, 297.5889, -35.8514>, <-52.7093, 296.8406, -34.8293> }
					triangle { <-54.7418, 297.5889, -35.8514>, <-56.7615, 295.8495, -35.4106>, <-54.1635, 296.0278, -33.4399> }
					triangle { <-52.7093, 296.8406, -34.8293>, <-54.1635, 296.0278, -33.4399>, <-52.9061, 295.7206, -33.5273> }
					triangle { <-52.7093, 296.8406, -34.8293>, <-54.7418, 297.5889, -35.8514>, <-54.1635, 296.0278, -33.4399> }
					triangle { <-51.06454, 297.0894, -35.8175>, <-55.08957, 297.5389, -36.3558>, <-52.7093, 296.8406, -34.8293> }
					triangle { <-51.5247, 296.0769, -34.7531>, <-52.7093, 296.8406, -34.8293>, <-52.9061, 295.7206, -33.5273> }
					triangle { <-51.06454, 297.0894, -35.8175>, <-52.7093, 296.8406, -34.8293>, <-51.5247, 296.0769, -34.7531> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-47.9774, 287.734, -41.446>, <-51.05766, 296.209, -34.5597>, <-49.829, 295.755, -33.7508> }
					triangle { <-47.9774, 287.734, -41.446>, <-50.07784, 292.7213, -38.3234>, <-51.05766, 296.209, -34.5597> }
					triangle { <-49.829, 295.755, -33.7508>, <-48.05376, 292.9793, -37.3465>, <-47.9774, 287.734, -41.446> }
					triangle { <-50.07784, 292.7213, -38.3234>, <-52.4206, 295.4602, -33.9287>, <-51.05766, 296.209, -34.5597> }
					triangle { <-52.4206, 295.4602, -33.9287>, <-53.07051, 294.534, -31.4235>, <-51.05766, 296.209, -34.5597> }
					triangle { <-49.829, 295.755, -33.7508>, <-49.2154, 295.4753, -31.9949>, <-48.3085, 296.2108, -33.6814> }
					triangle { <-48.3085, 296.2108, -33.6814>, <-48.05376, 292.9793, -37.3465>, <-49.829, 295.755, -33.7508> }
					triangle { <-53.07051, 294.534, -31.4235>, <-52.635, 294.9676, -31.4382>, <-50.7659, 295.7809, -32.6954> }
					triangle { <-52.635, 294.9676, -31.4382>, <-51.9013, 292.9803, -29.7615>, <-49.7728, 295.2023, -30.8557> }
					triangle { <-50.7659, 295.7809, -32.6954>, <-49.7728, 295.2023, -30.8557>, <-49.2154, 295.4753, -31.9949> }
					triangle { <-50.7659, 295.7809, -32.6954>, <-52.635, 294.9676, -31.4382>, <-49.7728, 295.2023, -30.8557> }
					triangle { <-51.05766, 296.209, -34.5597>, <-53.07051, 294.534, -31.4235>, <-50.7659, 295.7809, -32.6954> }
					triangle { <-49.829, 295.755, -33.7508>, <-50.7659, 295.7809, -32.6954>, <-49.2154, 295.4753, -31.9949> }
					triangle { <-51.05766, 296.209, -34.5597>, <-50.7659, 295.7809, -32.6954>, <-49.829, 295.755, -33.7508> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-47.9774, 287.734, -41.446>, <-49.5917, 296.1629, -34.02442>, <-48.3496, 296.7602, -34.7102> }
					triangle { <-47.9774, 287.734, -41.446>, <-49.6667, 292.1075, -37.3163>, <-49.5917, 296.1629, -34.02442> }
					triangle { <-48.3496, 296.7602, -34.7102>, <-48.5162, 293.6699, -38.4795>, <-47.9774, 287.734, -41.446> }
					triangle { <-49.6667, 292.1075, -37.3163>, <-49.09662, 295.3183, -32.6613>, <-49.5917, 296.1629, -34.02442> }
					triangle { <-49.09662, 295.3183, -32.6613>, <-46.9552, 295.5814, -30.9578>, <-49.5917, 296.1629, -34.02442> }
					triangle { <-48.3496, 296.7602, -34.7102>, <-46.7514, 297.6891, -34.3624>, <-48.1178, 297.801, -35.8882> }
					triangle { <-48.1178, 297.801, -35.8882>, <-48.5162, 293.6699, -38.4795>, <-48.3496, 296.7602, -34.7102> }
					triangle { <-46.9552, 295.5814, -30.9578>, <-47.108, 296.0898, -31.2677>, <-47.9233, 296.8936, -33.3713> }
					triangle { <-47.108, 296.0898, -31.2677>, <-44.4283, 295.7504, -31.3174>, <-45.9552, 297.8054, -33.3448> }
					triangle { <-47.9233, 296.8936, -33.3713>, <-45.9552, 297.8054, -33.3448>, <-46.7514, 297.6891, -34.3624> }
					triangle { <-47.9233, 296.8936, -33.3713>, <-47.108, 296.0898, -31.2677>, <-45.9552, 297.8054, -33.3448> }
					triangle { <-49.5917, 296.1629, -34.02442>, <-46.9552, 295.5814, -30.9578>, <-47.9233, 296.8936, -33.3713> }
					triangle { <-48.3496, 296.7602, -34.7102>, <-47.9233, 296.8936, -33.3713>, <-46.7514, 297.6891, -34.3624> }
					triangle { <-49.5917, 296.1629, -34.02442>, <-47.9233, 296.8936, -33.3713>, <-48.3496, 296.7602, -34.7102> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-46.4641, 281.2808, -44.8762>, <-46.7649, 282.8997, -44.6176>, 0.189 }
			cylinder { <-46.7649, 282.8997, -44.6176>, <-46.9686, 284.549, -44.4871>, 0.189 }
			cylinder { <-46.9686, 284.549, -44.4871>, <-47.07327, 286.2125, -44.486>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-47.07327, 286.2125, -44.486>, <-47.04236, 288.701, -44.7265>, 0.189 }
				cylinder { <-47.04236, 288.701, -44.7265>, <-46.8241, 291.1452, -45.2058>, 0.189 }
				cylinder { <-46.8241, 291.1452, -45.2058>, <-46.4218, 293.5084, -45.9165>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-46.4218, 293.5084, -45.9165>, <-45.3628, 304.2606, -49.381>, <-46.2221, 304.5541, -48.1379> }
					triangle { <-46.4218, 293.5084, -45.9165>, <-45.1502, 299.1675, -48.2388>, <-45.3628, 304.2606, -49.381> }
					triangle { <-46.2221, 304.5541, -48.1379>, <-45.6026, 300.108, -46.2316>, <-46.4218, 293.5084, -45.9165> }
					triangle { <-45.1502, 299.1675, -48.2388>, <-46.3747, 304.1352, -50.714>, <-45.3628, 304.2606, -49.381> }
					triangle { <-46.3747, 304.1352, -50.714>, <-48.8158, 305.2361, -51.335>, <-45.3628, 304.2606, -49.381> }
					triangle { <-46.2221, 304.5541, -48.1379>, <-47.6426, 305.6212, -47.5206>, <-45.9075, 304.9744, -46.6382> }
					triangle { <-45.9075, 304.9744, -46.6382>, <-45.6026, 300.108, -46.2316>, <-46.2221, 304.5541, -48.1379> }
					triangle { <-48.8158, 305.2361, -51.335>, <-48.4868, 305.5456, -50.9182>, <-46.9735, 305.2894, -49.07962> }
					triangle { <-48.4868, 305.5456, -50.9182>, <-51.05735, 305.3569, -50.1085>, <-48.6548, 306.2176, -48.07095> }
					triangle { <-46.9735, 305.2894, -49.07962>, <-48.6548, 306.2176, -48.07095>, <-47.6426, 305.6212, -47.5206> }
					triangle { <-46.9735, 305.2894, -49.07962>, <-48.4868, 305.5456, -50.9182>, <-48.6548, 306.2176, -48.07095> }
					triangle { <-45.3628, 304.2606, -49.381>, <-48.8158, 305.2361, -51.335>, <-46.9735, 305.2894, -49.07962> }
					triangle { <-46.2221, 304.5541, -48.1379>, <-46.9735, 305.2894, -49.07962>, <-47.6426, 305.6212, -47.5206> }
					triangle { <-45.3628, 304.2606, -49.381>, <-46.9735, 305.2894, -49.07962>, <-46.2221, 304.5541, -48.1379> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-46.4218, 293.5084, -45.9165>, <-45.7457, 304.6509, -47.9463>, <-44.8344, 304.6367, -46.7056> }
					triangle { <-46.4218, 293.5084, -45.9165>, <-46.2713, 299.4549, -47.8275>, <-45.7457, 304.6509, -47.9463> }
					triangle { <-44.8344, 304.6367, -46.7056>, <-44.3413, 299.7847, -46.6944>, <-46.4218, 293.5084, -45.9165> }
					triangle { <-46.2713, 299.4549, -47.8275>, <-47.3062, 305.0315, -47.4602>, <-45.7457, 304.6509, -47.9463> }
					triangle { <-47.3062, 305.0315, -47.4602>, <-48.322, 306.4975, -45.3685>, <-45.7457, 304.6509, -47.9463> }
					triangle { <-44.8344, 304.6367, -46.7056>, <-44.4212, 305.5991, -45.1433>, <-43.2645, 304.5526, -46.4754> }
					triangle { <-43.2645, 304.5526, -46.4754>, <-44.3413, 299.7847, -46.6944>, <-44.8344, 304.6367, -46.7056> }
					triangle { <-48.322, 306.4975, -45.3685>, <-47.7443, 306.6338, -45.5283>, <-45.6884, 305.6905, -46.3154> }
					triangle { <-47.7443, 306.6338, -45.5283>, <-47.9402, 306.4573, -42.8395>, <-45.05827, 306.428, -44.3752> }
					triangle { <-45.6884, 305.6905, -46.3154>, <-45.05827, 306.428, -44.3752>, <-44.4212, 305.5991, -45.1433> }
					triangle { <-45.6884, 305.6905, -46.3154>, <-47.7443, 306.6338, -45.5283>, <-45.05827, 306.428, -44.3752> }
					triangle { <-45.7457, 304.6509, -47.9463>, <-48.322, 306.4975, -45.3685>, <-45.6884, 305.6905, -46.3154> }
					triangle { <-44.8344, 304.6367, -46.7056>, <-45.6884, 305.6905, -46.3154>, <-44.4212, 305.5991, -45.1433> }
					triangle { <-45.7457, 304.6509, -47.9463>, <-45.6884, 305.6905, -46.3154>, <-44.8344, 304.6367, -46.7056> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-46.4218, 293.5084, -45.9165>, <-44.475, 304.625, -47.08488>, <-43.07414, 304.1495, -47.5106> }
					triangle { <-46.4218, 293.5084, -45.9165>, <-46.1881, 299.7111, -46.6291>, <-44.475, 304.625, -47.08488> }
					triangle { <-43.07414, 304.1495, -47.5106>, <-44.4349, 299.4965, -48.0426>, <-46.4218, 293.5084, -45.9165> }
					triangle { <-46.1881, 299.7111, -46.6291>, <-44.4421, 304.9891, -45.4469>, <-44.475, 304.625, -47.08488> }
					triangle { <-44.4421, 304.9891, -45.4469>, <-42.4582, 305.846, -43.748>, <-44.475, 304.625, -47.08488> }
					triangle { <-43.07414, 304.1495, -47.5106>, <-41.2442, 304.5511, -47.343>, <-42.3738, 303.8495, -48.9048> }
					triangle { <-42.3738, 303.8495, -48.9048>, <-44.4349, 299.4965, -48.0426>, <-43.07414, 304.1495, -47.5106> }
					triangle { <-42.4582, 305.846, -43.748>, <-42.3648, 305.9679, -44.3432>, <-42.6783, 305.1134, -46.5585> }
					triangle { <-42.3648, 305.9679, -44.3432>, <-40.09733, 305.0079, -43.2317>, <-40.5117, 305.1668, -46.4671> }
					triangle { <-42.6783, 305.1134, -46.5585>, <-40.5117, 305.1668, -46.4671>, <-41.2442, 304.5511, -47.343> }
					triangle { <-42.6783, 305.1134, -46.5585>, <-42.3648, 305.9679, -44.3432>, <-40.5117, 305.1668, -46.4671> }
					triangle { <-44.475, 304.625, -47.08488>, <-42.4582, 305.846, -43.748>, <-42.6783, 305.1134, -46.5585> }
					triangle { <-43.07414, 304.1495, -47.5106>, <-42.6783, 305.1134, -46.5585>, <-41.2442, 304.5511, -47.343> }
					triangle { <-44.475, 304.625, -47.08488>, <-42.6783, 305.1134, -46.5585>, <-43.07414, 304.1495, -47.5106> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-46.4218, 293.5084, -45.9165>, <-43.2951, 304.2184, -47.9791>, <-43.3575, 303.7613, -49.4478> }
					triangle { <-46.4218, 293.5084, -45.9165>, <-45.01485, 299.5844, -46.2886>, <-43.2951, 304.2184, -47.9791> }
					triangle { <-43.3575, 303.7613, -49.4478>, <-45.7549, 299.639, -48.4256>, <-46.4218, 293.5084, -45.9165> }
					triangle { <-45.01485, 299.5844, -46.2886>, <-41.7139, 304.0663, -47.4376>, <-43.2951, 304.2184, -47.9791> }
					triangle { <-41.7139, 304.0663, -47.4376>, <-39.2734, 304.1758, -48.6979>, <-43.2951, 304.2184, -47.9791> }
					triangle { <-43.3575, 303.7613, -49.4478>, <-42.4726, 303.9159, -51.1003>, <-44.4579, 303.8302, -50.5918> }
					triangle { <-44.4579, 303.8302, -50.5918>, <-45.7549, 299.639, -48.4256>, <-43.3575, 303.7613, -49.4478> }
					triangle { <-39.2734, 304.1758, -48.6979>, <-39.7324, 304.4621, -48.9896>, <-42.07507, 304.3502, -49.475> }
					triangle { <-39.7324, 304.4621, -48.9896>, <-38.2941, 302.9983, -50.7467>, <-41.2559, 304.1652, -51.4751> }
					triangle { <-42.07507, 304.3502, -49.475>, <-41.2559, 304.1652, -51.4751>, <-42.4726, 303.9159, -51.1003> }
					triangle { <-42.07507, 304.3502, -49.475>, <-39.7324, 304.4621, -48.9896>, <-41.2559, 304.1652, -51.4751> }
					triangle { <-43.2951, 304.2184, -47.9791>, <-39.2734, 304.1758, -48.6979>, <-42.07507, 304.3502, -49.475> }
					triangle { <-43.3575, 303.7613, -49.4478>, <-42.07507, 304.3502, -49.475>, <-42.4726, 303.9159, -51.1003> }
					triangle { <-43.2951, 304.2184, -47.9791>, <-42.07507, 304.3502, -49.475>, <-43.3575, 303.7613, -49.4478> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-46.4218, 293.5084, -45.9165>, <-43.852, 303.9897, -49.4196>, <-45.3324, 304.0151, -49.8413> }
					triangle { <-46.4218, 293.5084, -45.9165>, <-44.3637, 299.2434, -47.2984>, <-43.852, 303.9897, -49.4196> }
					triangle { <-45.3324, 304.0151, -49.8413>, <-46.4874, 300.0227, -47.2895>, <-46.4218, 293.5084, -45.9165> }
					triangle { <-44.3637, 299.2434, -47.2984>, <-42.9263, 303.5305, -50.742>, <-43.852, 303.9897, -49.4196> }
					triangle { <-42.9263, 303.5305, -50.742>, <-43.2619, 303.7931, -53.4577>, <-43.852, 303.9897, -49.4196> }
					triangle { <-45.3324, 304.0151, -49.8413>, <-46.4867, 304.5872, -51.2117>, <-46.6749, 304.5359, -49.1698> }
					triangle { <-46.6749, 304.5359, -49.1698>, <-46.4874, 300.0227, -47.2895>, <-45.3324, 304.0151, -49.8413> }
					triangle { <-43.2619, 303.7931, -53.4577>, <-43.5731, 304.1971, -53.1145>, <-44.7697, 304.4606, -51.05673> }
					triangle { <-43.5731, 304.1971, -53.1145>, <-45.17, 303.2172, -55.06097>, <-46.3646, 304.8244, -52.4813> }
					triangle { <-44.7697, 304.4606, -51.05673>, <-46.3646, 304.8244, -52.4813>, <-46.4867, 304.5872, -51.2117> }
					triangle { <-44.7697, 304.4606, -51.05673>, <-43.5731, 304.1971, -53.1145>, <-46.3646, 304.8244, -52.4813> }
					triangle { <-43.852, 303.9897, -49.4196>, <-43.2619, 303.7931, -53.4577>, <-44.7697, 304.4606, -51.05673> }
					triangle { <-45.3324, 304.0151, -49.8413>, <-44.7697, 304.4606, -51.05673>, <-46.4867, 304.5872, -51.2117> }
					triangle { <-43.852, 303.9897, -49.4196>, <-44.7697, 304.4606, -51.05673>, <-45.3324, 304.0151, -49.8413> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-47.07327, 286.2125, -44.486>, <-47.3378, 287.858, -44.456>, 0.189 }
			cylinder { <-47.3378, 287.858, -44.456>, <-47.7599, 289.4695, -44.3976>, 0.189 }
			cylinder { <-47.7599, 289.4695, -44.3976>, <-48.3353, 291.0314, -44.3112>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-48.3353, 291.0314, -44.3112>, <-49.4741, 293.25, -44.131>, 0.189 }
				cylinder { <-49.4741, 293.25, -44.131>, <-50.8714, 295.3108, -43.9029>, 0.189 }
				cylinder { <-50.8714, 295.3108, -43.9029>, <-52.5063, 297.1828, -43.6304>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-52.5063, 297.1828, -43.6304>, <-59.8137, 305.476, -41.1018>, <-58.6395, 306.385, -41.5039> }
					triangle { <-52.5063, 297.1828, -43.6304>, <-57.1368, 301.176, -42.3661>, <-59.8137, 305.476, -41.1018> }
					triangle { <-58.6395, 306.385, -41.5039>, <-56.1064, 302.7779, -43.5841>, <-52.5063, 297.1828, -43.6304> }
					triangle { <-57.1368, 301.176, -42.3661>, <-59.7803, 305.263, -39.4385>, <-59.8137, 305.476, -41.1018> }
					triangle { <-59.7803, 305.263, -39.4385>, <-58.8644, 306.81, -37.3614>, <-59.8137, 305.476, -41.1018> }
					triangle { <-58.6395, 306.385, -41.5039>, <-57.747, 307.97, -41.0302>, <-58.2118, 307.1281, -42.8405> }
					triangle { <-58.2118, 307.1281, -42.8405>, <-56.1064, 302.7779, -43.5841>, <-58.6395, 306.385, -41.5039> }
					triangle { <-58.8644, 306.81, -37.3614>, <-59.00027, 307.1161, -37.8763>, <-58.9449, 306.9876, -40.2657> }
					triangle { <-59.00027, 307.1161, -37.8763>, <-56.6427, 307.9812, -36.8848>, <-57.59, 308.6475, -39.936> }
					triangle { <-58.9449, 306.9876, -40.2657>, <-57.59, 308.6475, -39.936>, <-57.747, 307.97, -41.0302> }
					triangle { <-58.9449, 306.9876, -40.2657>, <-59.00027, 307.1161, -37.8763>, <-57.59, 308.6475, -39.936> }
					triangle { <-59.8137, 305.476, -41.1018>, <-58.8644, 306.81, -37.3614>, <-58.9449, 306.9876, -40.2657> }
					triangle { <-58.6395, 306.385, -41.5039>, <-58.9449, 306.9876, -40.2657>, <-57.747, 307.97, -41.0302> }
					triangle { <-59.8137, 305.476, -41.1018>, <-58.9449, 306.9876, -40.2657>, <-58.6395, 306.385, -41.5039> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-52.5063, 297.1828, -43.6304>, <-58.9135, 306.3854, -41.9485>, <-58.8664, 306.4751, -43.4836> }
					triangle { <-52.5063, 297.1828, -43.6304>, <-56.2355, 301.9041, -41.9606>, <-58.9135, 306.3854, -41.9485> }
					triangle { <-58.8664, 306.4751, -43.4836>, <-57.1204, 301.9588, -44.04036>, <-52.5063, 297.1828, -43.6304> }
					triangle { <-56.2355, 301.9041, -41.9606>, <-57.6985, 307.3547, -41.3183>, <-58.9135, 306.3854, -41.9485> }
					triangle { <-57.6985, 307.3547, -41.3183>, <-56.4473, 309.6281, -42.2196>, <-58.9135, 306.3854, -41.9485> }
					triangle { <-58.8664, 306.4751, -43.4836>, <-58.7075, 307.6953, -44.9046>, <-59.8181, 305.9899, -44.6584> }
					triangle { <-59.8181, 305.9899, -44.6584>, <-57.1204, 301.9588, -44.04036>, <-58.8664, 306.4751, -43.4836> }
					triangle { <-56.4473, 309.6281, -42.2196>, <-57.00523, 309.525, -42.455>, <-58.4969, 307.8051, -43.1934> }
					triangle { <-57.00523, 309.525, -42.455>, <-55.2977, 310.2522, -44.4159>, <-58.1856, 308.8726, -45.05443> }
					triangle { <-58.4969, 307.8051, -43.1934>, <-58.1856, 308.8726, -45.05443>, <-58.7075, 307.6953, -44.9046> }
					triangle { <-58.4969, 307.8051, -43.1934>, <-57.00523, 309.525, -42.455>, <-58.1856, 308.8726, -45.05443> }
					triangle { <-58.9135, 306.3854, -41.9485>, <-56.4473, 309.6281, -42.2196>, <-58.4969, 307.8051, -43.1934> }
					triangle { <-58.8664, 306.4751, -43.4836>, <-58.4969, 307.8051, -43.1934>, <-58.7075, 307.6953, -44.9046> }
					triangle { <-58.9135, 306.3854, -41.9485>, <-58.4969, 307.8051, -43.1934>, <-58.8664, 306.4751, -43.4836> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-52.5063, 297.1828, -43.6304>, <-59.3272, 306.2381, -43.4187>, <-60.3543, 305.2507, -43.9992> }
					triangle { <-52.5063, 297.1828, -43.6304>, <-55.7399, 302.4775, -42.9261>, <-59.3272, 306.2381, -43.4187> }
					triangle { <-60.3543, 305.2507, -43.9992>, <-57.678, 301.3138, -42.9541>, <-52.5063, 297.1828, -43.6304> }
					triangle { <-55.7399, 302.4775, -42.9261>, <-58.5984, 307.0592, -44.6865>, <-59.3272, 306.2381, -43.4187> }
					triangle { <-58.5984, 307.0592, -44.6865>, <-59.4346, 307.746, -47.2116>, <-59.3272, 306.2381, -43.4187> }
					triangle { <-60.3543, 305.2507, -43.9992>, <-61.7348, 305.1042, -45.2665>, <-61.4966, 304.3379, -43.3801> }
					triangle { <-61.4966, 304.3379, -43.3801>, <-57.678, 301.3138, -42.9541>, <-60.3543, 305.2507, -43.9992> }
					triangle { <-59.4346, 307.746, -47.2116>, <-59.8838, 307.6444, -46.8052>, <-60.5224, 306.2901, -44.9378> }
					triangle { <-59.8838, 307.6444, -46.8052>, <-60.4649, 306.428, -49.1444>, <-62.03458, 305.7037, -46.3763> }
					triangle { <-60.5224, 306.2901, -44.9378>, <-62.03458, 305.7037, -46.3763>, <-61.7348, 305.1042, -45.2665> }
					triangle { <-60.5224, 306.2901, -44.9378>, <-59.8838, 307.6444, -46.8052>, <-62.03458, 305.7037, -46.3763> }
					triangle { <-59.3272, 306.2381, -43.4187>, <-59.4346, 307.746, -47.2116>, <-60.5224, 306.2901, -44.9378> }
					triangle { <-60.3543, 305.2507, -43.9992>, <-60.5224, 306.2901, -44.9378>, <-61.7348, 305.1042, -45.2665> }
					triangle { <-59.3272, 306.2381, -43.4187>, <-60.5224, 306.2901, -44.9378>, <-60.3543, 305.2507, -43.9992> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-52.5063, 297.1828, -43.6304>, <-60.4869, 305.2363, -43.4943>, <-61.06091, 304.3925, -42.343> }
					triangle { <-52.5063, 297.1828, -43.6304>, <-56.3302, 302.1092, -43.9374>, <-60.4869, 305.2363, -43.4943> }
					triangle { <-61.06091, 304.3925, -42.343>, <-57.01391, 301.7281, -41.8164>, <-52.5063, 297.1828, -43.6304> }
					triangle { <-56.3302, 302.1092, -43.9374>, <-61.2447, 304.7821, -44.92>, <-60.4869, 305.2363, -43.4943> }
					triangle { <-61.2447, 304.7821, -44.92>, <-63.7258, 303.7471, -45.4852>, <-60.4869, 305.2363, -43.4943> }
					triangle { <-61.06091, 304.3925, -42.343>, <-62.6735, 303.7534, -41.6191>, <-60.9434, 304.4397, -40.7602> }
					triangle { <-60.9434, 304.4397, -40.7602>, <-57.01391, 301.7281, -41.8164>, <-61.06091, 304.3925, -42.343> }
					triangle { <-63.7258, 303.7471, -45.4852>, <-63.6848, 304.0557, -44.9556>, <-62.2411, 304.5222, -43.1045> }
					triangle { <-63.6848, 304.0557, -44.9556>, <-65.05164, 301.7578, -44.5799>, <-63.8537, 303.4906, -42.0872> }
					triangle { <-62.2411, 304.5222, -43.1045>, <-63.8537, 303.4906, -42.0872>, <-62.6735, 303.7534, -41.6191> }
					triangle { <-62.2411, 304.5222, -43.1045>, <-63.6848, 304.0557, -44.9556>, <-63.8537, 303.4906, -42.0872> }
					triangle { <-60.4869, 305.2363, -43.4943>, <-63.7258, 303.7471, -45.4852>, <-62.2411, 304.5222, -43.1045> }
					triangle { <-61.06091, 304.3925, -42.343>, <-62.2411, 304.5222, -43.1045>, <-62.6735, 303.7534, -41.6191> }
					triangle { <-60.4869, 305.2363, -43.4943>, <-62.2411, 304.5222, -43.1045>, <-61.06091, 304.3925, -42.343> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-52.5063, 297.1828, -43.6304>, <-60.7921, 304.7581, -42.04084>, <-59.9851, 305.1042, -40.7775> }
					triangle { <-52.5063, 297.1828, -43.6304>, <-57.2066, 301.2927, -43.586>, <-60.7921, 304.7581, -42.04084> }
					triangle { <-59.9851, 305.1042, -40.7775>, <-56.028, 302.6466, -42.2117>, <-52.5063, 297.1828, -43.6304> }
					triangle { <-57.2066, 301.2927, -43.586>, <-61.9862, 303.6552, -41.6275>, <-60.7921, 304.7581, -42.04084> }
					triangle { <-61.9862, 303.6552, -41.6275>, <-63.3681, 303.1599, -39.3055>, <-60.7921, 304.7581, -42.04084> }
					triangle { <-59.9851, 305.1042, -40.7775>, <-60.1717, 305.5513, -38.9614>, <-58.8826, 306.1901, -40.4216> }
					triangle { <-58.8826, 306.1901, -40.4216>, <-56.028, 302.6466, -42.2117>, <-59.9851, 305.1042, -40.7775> }
					triangle { <-63.3681, 303.1599, -39.3055>, <-63.1305, 303.7243, -39.354>, <-61.2514, 304.9598, -40.1733> }
					triangle { <-63.1305, 303.7243, -39.354>, <-62.6537, 302.7322, -36.8886>, <-61.0654, 305.3374, -38.04678> }
					triangle { <-61.2514, 304.9598, -40.1733>, <-61.0654, 305.3374, -38.04678>, <-60.1717, 305.5513, -38.9614> }
					triangle { <-61.2514, 304.9598, -40.1733>, <-63.1305, 303.7243, -39.354>, <-61.0654, 305.3374, -38.04678> }
					triangle { <-60.7921, 304.7581, -42.04084>, <-63.3681, 303.1599, -39.3055>, <-61.2514, 304.9598, -40.1733> }
					triangle { <-59.9851, 305.1042, -40.7775>, <-61.2514, 304.9598, -40.1733>, <-60.1717, 305.5513, -38.9614> }
					triangle { <-60.7921, 304.7581, -42.04084>, <-61.2514, 304.9598, -40.1733>, <-59.9851, 305.1042, -40.7775> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-41.3905, 262.2669, -46.8871>, <-42.4762, 263.5308, -46.8394>, 0.189 }
			cylinder { <-42.4762, 263.5308, -46.8394>, <-43.6408, 264.721, -46.9146>, 0.189 }
			cylinder { <-43.6408, 264.721, -46.9146>, <-44.8732, 265.8259, -47.1119>, 0.189 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <-44.8732, 265.8259, -47.1119>, <-46.2722, 266.6436, -47.5027>, 0.189 }
			cylinder { <-46.2722, 266.6436, -47.5027>, <-47.6944, 267.4818, -47.7328>, 0.189 }
			cylinder { <-47.6944, 267.4818, -47.7328>, <-49.1262, 268.3325, -47.8001>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-49.1262, 268.3325, -47.8001>, <-51.2628, 269.6148, -47.5947>, 0.189 }
				cylinder { <-51.2628, 269.6148, -47.5947>, <-53.3561, 270.8839, -47.08608>, 0.189 }
				cylinder { <-53.3561, 270.8839, -47.08608>, <-55.3747, 272.1209, -46.2817>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-55.3747, 272.1209, -46.2817>, <-63.74, 278.7682, -42.4864>, <-64.1736, 278.7555, -43.9625> }
					triangle { <-55.3747, 272.1209, -46.2817>, <-59.8279, 275.4435, -43.4331>, <-63.74, 278.7682, -42.4864> }
					triangle { <-64.1736, 278.7555, -43.9625>, <-61.2418, 275.0483, -45.1523>, <-55.3747, 272.1209, -46.2817> }
					triangle { <-59.8279, 275.4435, -43.4331>, <-62.7983, 280.1296, -42.217>, <-63.74, 278.7682, -42.4864> }
					triangle { <-62.7983, 280.1296, -42.217>, <-62.7106, 282.6171, -43.3796>, <-63.74, 278.7682, -42.4864> }
					triangle { <-64.1736, 278.7555, -43.9625>, <-64.8573, 279.8514, -45.3281>, <-65.2018, 277.8968, -44.815> }
					triangle { <-65.2018, 277.8968, -44.815>, <-61.2418, 275.0483, -45.1523>, <-64.1736, 278.7555, -43.9625> }
					triangle { <-62.7106, 282.6171, -43.3796>, <-63.2433, 282.3174, -43.4413>, <-64.2095, 280.1502, -43.7547> }
					triangle { <-63.2433, 282.3174, -43.4413>, <-62.5306, 283.4247, -45.7983>, <-64.8328, 281.1208, -45.5902> }
					triangle { <-64.2095, 280.1502, -43.7547>, <-64.8328, 281.1208, -45.5902>, <-64.8573, 279.8514, -45.3281> }
					triangle { <-64.2095, 280.1502, -43.7547>, <-63.2433, 282.3174, -43.4413>, <-64.8328, 281.1208, -45.5902> }
					triangle { <-63.74, 278.7682, -42.4864>, <-62.7106, 282.6171, -43.3796>, <-64.2095, 280.1502, -43.7547> }
					triangle { <-64.1736, 278.7555, -43.9625>, <-64.2095, 280.1502, -43.7547>, <-64.8573, 279.8514, -45.3281> }
					triangle { <-63.74, 278.7682, -42.4864>, <-64.2095, 280.1502, -43.7547>, <-64.1736, 278.7555, -43.9625> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-55.3747, 272.1209, -46.2817>, <-64.4869, 278.3843, -43.7706>, <-65.2399, 277.0719, -44.04916> }
					triangle { <-55.3747, 272.1209, -46.2817>, <-59.8588, 276.0765, -44.4843>, <-64.4869, 278.3843, -43.7706> }
					triangle { <-65.2399, 277.0719, -44.04916>, <-61.207, 274.3361, -43.9697>, <-55.3747, 272.1209, -46.2817> }
					triangle { <-59.8588, 276.0765, -44.4843>, <-64.4808, 279.3056, -45.1721>, <-64.4869, 278.3843, -43.7706> }
					triangle { <-64.4808, 279.3056, -45.1721>, <-66.1946, 279.4882, -47.3113>, <-64.4869, 278.3843, -43.7706> }
					triangle { <-65.2399, 277.0719, -44.04916>, <-66.7934, 276.3824, -44.8518>, <-65.7731, 275.8795, -43.1464> }
					triangle { <-65.7731, 275.8795, -43.1464>, <-61.207, 274.3361, -43.9697>, <-65.2399, 277.0719, -44.04916> }
					triangle { <-66.1946, 279.4882, -47.3113>, <-66.4443, 279.2731, -46.7929>, <-66.01496, 277.9245, -44.8627> }
					triangle { <-66.4443, 279.2731, -46.7929>, <-67.2307, 277.7646, -48.8894>, <-67.5868, 276.765, -45.8031> }
					triangle { <-66.01496, 277.9245, -44.8627>, <-67.5868, 276.765, -45.8031>, <-66.7934, 276.3824, -44.8518> }
					triangle { <-66.01496, 277.9245, -44.8627>, <-66.4443, 279.2731, -46.7929>, <-67.5868, 276.765, -45.8031> }
					triangle { <-64.4869, 278.3843, -43.7706>, <-66.1946, 279.4882, -47.3113>, <-66.01496, 277.9245, -44.8627> }
					triangle { <-65.2399, 277.0719, -44.04916>, <-66.01496, 277.9245, -44.8627>, <-66.7934, 276.3824, -44.8518> }
					triangle { <-64.4869, 278.3843, -43.7706>, <-66.01496, 277.9245, -44.8627>, <-65.2399, 277.0719, -44.04916> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-55.3747, 272.1209, -46.2817>, <-65.2072, 277.0514, -43.5283>, <-65.1007, 276.1517, -42.2848> }
					triangle { <-55.3747, 272.1209, -46.2817>, <-60.5557, 275.4598, -45.2848>, <-65.2072, 277.0514, -43.5283> }
					triangle { <-65.1007, 276.1517, -42.2848>, <-60.423, 275.0299, -43.06923>, <-55.3747, 272.1209, -46.2817> }
					triangle { <-60.5557, 275.4598, -45.2848>, <-66.145, 276.2679, -44.677>, <-65.2072, 277.0514, -43.5283> }
					triangle { <-66.145, 276.2679, -44.677>, <-68.1787, 274.4286, -44.5095>, <-65.2072, 277.0514, -43.5283> }
					triangle { <-65.1007, 276.1517, -42.2848>, <-66.1173, 275.0679, -41.1337>, <-64.5523, 276.3512, -40.8081> }
					triangle { <-64.5523, 276.3512, -40.8081>, <-60.423, 275.0299, -43.06923>, <-65.1007, 276.1517, -42.2848> }
					triangle { <-68.1787, 274.4286, -44.5095>, <-68.09293, 274.7712, -44.00694>, <-66.4219, 275.8255, -42.6561> }
					triangle { <-68.09293, 274.7712, -44.00694>, <-68.4282, 272.1839, -43.3121>, <-67.2202, 274.3943, -41.237> }
					triangle { <-66.4219, 275.8255, -42.6561>, <-67.2202, 274.3943, -41.237>, <-66.1173, 275.0679, -41.1337> }
					triangle { <-66.4219, 275.8255, -42.6561>, <-68.09293, 274.7712, -44.00694>, <-67.2202, 274.3943, -41.237> }
					triangle { <-65.2072, 277.0514, -43.5283>, <-68.1787, 274.4286, -44.5095>, <-66.4219, 275.8255, -42.6561> }
					triangle { <-65.1007, 276.1517, -42.2848>, <-66.4219, 275.8255, -42.6561>, <-66.1173, 275.0679, -41.1337> }
					triangle { <-65.2072, 277.0514, -43.5283>, <-66.4219, 275.8255, -42.6561>, <-65.1007, 276.1517, -42.2848> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-55.3747, 272.1209, -46.2817>, <-64.9121, 276.599, -42.09221>, <-63.9473, 277.258, -41.09142> }
					triangle { <-55.3747, 272.1209, -46.2817>, <-60.962, 274.4398, -44.7357>, <-64.9121, 276.599, -42.09221> }
					triangle { <-63.9473, 277.258, -41.09142>, <-59.966, 276.1774, -43.6868>, <-55.3747, 272.1209, -46.2817> }
					triangle { <-60.962, 274.4398, -44.7357>, <-65.5066, 275.1862, -41.4113>, <-64.9121, 276.599, -42.09221> }
					triangle { <-65.5066, 275.1862, -41.4113>, <-65.9394, 274.3833, -38.82>, <-64.9121, 276.599, -42.09221> }
					triangle { <-63.9473, 277.258, -41.09142>, <-63.7571, 277.7123, -39.2773>, <-63.215, 278.6646, -41.00985> }
					triangle { <-63.215, 278.6646, -41.00985>, <-59.966, 276.1774, -43.6868>, <-63.9473, 277.258, -41.09142> }
					triangle { <-65.9394, 274.3833, -38.82>, <-65.9262, 274.9911, -38.9075>, <-64.8718, 276.7344, -40.1637> }
					triangle { <-65.9262, 274.9911, -38.9075>, <-64.4793, 274.3429, -36.7221>, <-64.2361, 277.2628, -38.1596> }
					triangle { <-64.8718, 276.7344, -40.1637>, <-64.2361, 277.2628, -38.1596>, <-63.7571, 277.7123, -39.2773> }
					triangle { <-64.8718, 276.7344, -40.1637>, <-65.9262, 274.9911, -38.9075>, <-64.2361, 277.2628, -38.1596> }
					triangle { <-64.9121, 276.599, -42.09221>, <-65.9394, 274.3833, -38.82>, <-64.8718, 276.7344, -40.1637> }
					triangle { <-63.9473, 277.258, -41.09142>, <-64.8718, 276.7344, -40.1637>, <-63.7571, 277.7123, -39.2773> }
					triangle { <-64.9121, 276.599, -42.09221>, <-64.8718, 276.7344, -40.1637>, <-63.9473, 277.258, -41.09142> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-55.3747, 272.1209, -46.2817>, <-63.9917, 277.676, -41.4385>, <-63.3656, 278.8915, -42.1439> }
					triangle { <-55.3747, 272.1209, -46.2817>, <-60.5054, 274.4296, -43.5741>, <-63.9917, 277.676, -41.4385> }
					triangle { <-63.3656, 278.8915, -42.1439>, <-60.4796, 276.1889, -44.9937>, <-55.3747, 272.1209, -46.2817> }
					triangle { <-60.5054, 274.4296, -43.5741>, <-63.407, 277.6089, -39.868>, <-63.9917, 277.676, -41.4385> }
					triangle { <-63.407, 277.6089, -39.868>, <-62.5089, 279.5204, -38.1112>, <-63.9917, 277.676, -41.4385> }
					triangle { <-63.3656, 278.8915, -42.1439>, <-62.9667, 280.7133, -41.9088>, <-63.6225, 279.6342, -43.5236> }
					triangle { <-63.6225, 279.6342, -43.5236>, <-60.4796, 276.1889, -44.9937>, <-63.3656, 278.8915, -42.1439> }
					triangle { <-62.5089, 279.5204, -38.1112>, <-62.8837, 279.7253, -38.5527>, <-63.4839, 279.4475, -40.8529> }
					triangle { <-62.8837, 279.7253, -38.5527>, <-60.7793, 281.395, -38.2819>, <-62.7384, 281.4828, -40.8906> }
					triangle { <-63.4839, 279.4475, -40.8529>, <-62.7384, 281.4828, -40.8906>, <-62.9667, 280.7133, -41.9088> }
					triangle { <-63.4839, 279.4475, -40.8529>, <-62.8837, 279.7253, -38.5527>, <-62.7384, 281.4828, -40.8906> }
					triangle { <-63.9917, 277.676, -41.4385>, <-62.5089, 279.5204, -38.1112>, <-63.4839, 279.4475, -40.8529> }
					triangle { <-63.3656, 278.8915, -42.1439>, <-63.4839, 279.4475, -40.8529>, <-62.9667, 280.7133, -41.9088> }
					triangle { <-63.9917, 277.676, -41.4385>, <-63.4839, 279.4475, -40.8529>, <-63.3656, 278.8915, -42.1439> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-44.8732, 265.8259, -47.1119>, <-45.8733, 267.1593, -47.1053>, 0.189 }
			cylinder { <-45.8733, 267.1593, -47.1053>, <-46.8677, 268.4879, -47.262>, 0.189 }
			cylinder { <-46.8677, 268.4879, -47.262>, <-47.8467, 269.7987, -47.5806>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-47.8467, 269.7987, -47.5806>, <-49.2667, 271.7053, -48.3554>, 0.189 }
				cylinder { <-49.2667, 271.7053, -48.3554>, <-50.6166, 273.5234, -49.4153>, 0.189 }
				cylinder { <-50.6166, 273.5234, -49.4153>, <-51.8763, 275.2258, -50.7445>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-51.8763, 275.2258, -50.7445>, <-58.5069, 282.0239, -56.9404>, <-58.7932, 282.6821, -55.5797> }
					triangle { <-51.8763, 275.2258, -50.7445>, <-55.04938, 278.7409, -54.814>, <-58.5069, 282.0239, -56.9404> }
					triangle { <-58.7932, 282.6821, -55.5797>, <-55.09468, 280.4444, -53.3283>, <-51.8763, 275.2258, -50.7445> }
					triangle { <-55.04938, 278.7409, -54.814>, <-59.7064, 280.8936, -57.2512>, <-58.5069, 282.0239, -56.9404> }
					triangle { <-59.7064, 280.8936, -57.2512>, <-62.3398, 280.6887, -56.4961>, <-58.5069, 282.0239, -56.9404> }
					triangle { <-58.7932, 282.6821, -55.5797>, <-60.17, 283.4337, -54.5439>, <-58.1965, 283.9277, -54.7962> }
					triangle { <-58.1965, 283.9277, -54.7962>, <-55.09468, 280.4444, -53.3283>, <-58.7932, 282.6821, -55.5797> }
					triangle { <-62.3398, 280.6887, -56.4961>, <-62.1065, 281.2567, -56.4823>, <-60.1272, 282.5157, -56.00677> }
					triangle { <-62.1065, 281.2567, -56.4823>, <-63.5379, 280.7939, -54.2404>, <-61.4578, 283.2969, -54.4841> }
					triangle { <-60.1272, 282.5157, -56.00677>, <-61.4578, 283.2969, -54.4841>, <-60.17, 283.4337, -54.5439> }
					triangle { <-60.1272, 282.5157, -56.00677>, <-62.1065, 281.2567, -56.4823>, <-61.4578, 283.2969, -54.4841> }
					triangle { <-58.5069, 282.0239, -56.9404>, <-62.3398, 280.6887, -56.4961>, <-60.1272, 282.5157, -56.00677> }
					triangle { <-58.7932, 282.6821, -55.5797>, <-60.1272, 282.5157, -56.00677>, <-60.17, 283.4337, -54.5439> }
					triangle { <-58.5069, 282.0239, -56.9404>, <-60.1272, 282.5157, -56.00677>, <-58.7932, 282.6821, -55.5797> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-51.8763, 275.2258, -50.7445>, <-58.425, 283.004, -55.7627>, <-57.2575, 283.9448, -55.4179> }
					triangle { <-51.8763, 275.2258, -50.7445>, <-55.8567, 278.8595, -53.897>, <-58.425, 283.004, -55.7627> }
					triangle { <-57.2575, 283.9448, -55.4179>, <-54.1864, 280.3111, -54.36>, <-51.8763, 275.2258, -50.7445> }
					triangle { <-55.8567, 278.8595, -53.897>, <-59.5726, 283.1063, -54.544>, <-58.425, 283.004, -55.7627> }
					triangle { <-59.5726, 283.1063, -54.544>, <-60.2857, 285.0996, -52.7933>, <-58.425, 283.004, -55.7627> }
					triangle { <-57.2575, 283.9448, -55.4179>, <-56.8669, 285.677, -54.8014>, <-55.9804, 284.4703, -56.2015> }
					triangle { <-55.9804, 284.4703, -56.2015>, <-54.1864, 280.3111, -54.36>, <-57.2575, 283.9448, -55.4179> }
					triangle { <-60.2857, 285.0996, -52.7933>, <-60.00747, 285.2891, -53.3071>, <-58.3078, 284.7288, -54.8965> }
					triangle { <-60.00747, 285.2891, -53.3071>, <-58.969, 286.5717, -51.1703>, <-57.4823, 286.5576, -54.07569> }
					triangle { <-58.3078, 284.7288, -54.8965>, <-57.4823, 286.5576, -54.07569>, <-56.8669, 285.677, -54.8014> }
					triangle { <-58.3078, 284.7288, -54.8965>, <-60.00747, 285.2891, -53.3071>, <-57.4823, 286.5576, -54.07569> }
					triangle { <-58.425, 283.004, -55.7627>, <-60.2857, 285.0996, -52.7933>, <-58.3078, 284.7288, -54.8965> }
					triangle { <-57.2575, 283.9448, -55.4179>, <-58.3078, 284.7288, -54.8965>, <-56.8669, 285.677, -54.8014> }
					triangle { <-58.425, 283.004, -55.7627>, <-58.3078, 284.7288, -54.8965>, <-57.2575, 283.9448, -55.4179> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-51.8763, 275.2258, -50.7445>, <-57.1432, 283.8335, -55.9151>, <-56.03393, 283.6431, -56.964> }
					triangle { <-51.8763, 275.2258, -50.7445>, <-55.4572, 279.7429, -53.1441>, <-57.1432, 283.8335, -55.9151> }
					triangle { <-56.03393, 283.6431, -56.964>, <-54.6358, 279.3172, -55.2069>, <-51.8763, 275.2258, -50.7445> }
					triangle { <-55.4572, 279.7429, -53.1441>, <-56.6636, 285.0279, -54.8398>, <-57.1432, 283.8335, -55.9151> }
					triangle { <-56.6636, 285.0279, -54.8398>, <-55.0211, 287.2178, -55.06998>, <-57.1432, 283.8335, -55.9151> }
					triangle { <-56.03393, 283.6431, -56.964>, <-54.8648, 284.5902, -58.09077>, <-55.9199, 282.8496, -58.3346> }
					triangle { <-55.9199, 282.8496, -58.3346>, <-54.6358, 279.3172, -55.2069>, <-56.03393, 283.6431, -56.964> }
					triangle { <-55.0211, 287.2178, -55.06998>, <-55.2609, 287.0134, -55.5972>, <-55.9022, 285.0358, -56.7832> }
					triangle { <-55.2609, 287.0134, -55.5972>, <-52.6346, 287.5466, -55.9252>, <-54.3254, 285.769, -58.07763> }
					triangle { <-55.9022, 285.0358, -56.7832>, <-54.3254, 285.769, -58.07763>, <-54.8648, 284.5902, -58.09077> }
					triangle { <-55.9022, 285.0358, -56.7832>, <-55.2609, 287.0134, -55.5972>, <-54.3254, 285.769, -58.07763> }
					triangle { <-57.1432, 283.8335, -55.9151>, <-55.0211, 287.2178, -55.06998>, <-55.9022, 285.0358, -56.7832> }
					triangle { <-56.03393, 283.6431, -56.964>, <-55.9022, 285.0358, -56.7832>, <-54.8648, 284.5902, -58.09077> }
					triangle { <-57.1432, 283.8335, -55.9151>, <-55.9022, 285.0358, -56.7832>, <-56.03393, 283.6431, -56.964> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-51.8763, 275.2258, -50.7445>, <-56.4209, 283.3738, -57.1884>, <-56.8019, 282.1912, -58.09578> }
					triangle { <-51.8763, 275.2258, -50.7445>, <-54.3993, 280.1785, -53.5888>, <-56.4209, 283.3738, -57.1884> }
					triangle { <-56.8019, 282.1912, -58.09578>, <-55.8259, 278.8271, -54.7067>, <-51.8763, 275.2258, -50.7445> }
					triangle { <-54.3993, 280.1785, -53.5888>, <-54.9724, 284.0208, -57.7326>, <-56.4209, 283.3738, -57.1884> }
					triangle { <-54.9724, 284.0208, -57.7326>, <-53.7723, 284.1357, -60.201>, <-56.4209, 283.3738, -57.1884> }
					triangle { <-56.8019, 282.1912, -58.09578>, <-56.912, 281.6651, -59.897>, <-58.09808, 281.2902, -58.2676> }
					triangle { <-58.09808, 281.2902, -58.2676>, <-55.8259, 278.8271, -54.7067>, <-56.8019, 282.1912, -58.09578> }
					triangle { <-53.7723, 284.1357, -60.201>, <-54.3822, 284.0628, -60.2091>, <-56.2124, 283.0153, -59.07713> }
					triangle { <-54.3822, 284.0628, -60.2091>, <-53.2295, 282.3803, -61.9783>, <-56.3204, 282.0137, -60.9967> }
					triangle { <-56.2124, 283.0153, -59.07713>, <-56.3204, 282.0137, -60.9967>, <-56.912, 281.6651, -59.897> }
					triangle { <-56.2124, 283.0153, -59.07713>, <-54.3822, 284.0628, -60.2091>, <-56.3204, 282.0137, -60.9967> }
					triangle { <-56.4209, 283.3738, -57.1884>, <-53.7723, 284.1357, -60.201>, <-56.2124, 283.0153, -59.07713> }
					triangle { <-56.8019, 282.1912, -58.09578>, <-56.2124, 283.0153, -59.07713>, <-56.912, 281.6651, -59.897> }
					triangle { <-56.4209, 283.3738, -57.1884>, <-56.2124, 283.0153, -59.07713>, <-56.8019, 282.1912, -58.09578> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <-51.8763, 275.2258, -50.7445>, <-57.2765, 282.2385, -57.8317>, <-58.533, 281.5883, -57.2273> }
					triangle { <-51.8763, 275.2258, -50.7445>, <-54.1434, 279.55, -54.6364>, <-57.2765, 282.2385, -57.8317> }
					triangle { <-58.533, 281.5883, -57.2273>, <-56.1138, 279.5343, -53.5281>, <-51.8763, 275.2258, -50.7445> }
					triangle { <-54.1434, 279.55, -54.6364>, <-56.8814, 281.4272, -59.2453>, <-57.2765, 282.2385, -57.8317> }
					triangle { <-56.8814, 281.4272, -59.2453>, <-58.3638, 280.0396, -61.09574>, <-57.2765, 282.2385, -57.8317> }
					triangle { <-58.533, 281.5883, -57.2273>, <-60.2402, 280.9396, -57.6718>, <-59.5263, 281.9666, -56.04773> }
					triangle { <-59.5263, 281.9666, -56.04773>, <-56.1138, 279.5343, -53.5281>, <-58.533, 281.5883, -57.2273> }
					triangle { <-58.3638, 280.0396, -61.09574>, <-58.6768, 280.4514, -60.7643>, <-58.863, 281.4342, -58.59> }
					triangle { <-58.6768, 280.4514, -60.7643>, <-60.06992, 278.1439, -60.9213>, <-60.795, 280.4628, -58.7422> }
					triangle { <-58.863, 281.4342, -58.59>, <-60.795, 280.4628, -58.7422>, <-60.2402, 280.9396, -57.6718> }
					triangle { <-58.863, 281.4342, -58.59>, <-58.6768, 280.4514, -60.7643>, <-60.795, 280.4628, -58.7422> }
					triangle { <-57.2765, 282.2385, -57.8317>, <-58.3638, 280.0396, -61.09574>, <-58.863, 281.4342, -58.59> }
					triangle { <-58.533, 281.5883, -57.2273>, <-58.863, 281.4342, -58.59>, <-60.2402, 280.9396, -57.6718> }
					triangle { <-57.2765, 282.2385, -57.8317>, <-58.863, 281.4342, -58.59>, <-58.533, 281.5883, -57.2273> }
					material { txgilia_flower }}
				}
			}
		}
	union { // internode
		cylinder { <19.05419, 116.5059, -13.8753>, <17.6799, 132.7298, -16.7354>, 0.5 }
		cylinder { <17.6799, 132.7298, -16.7354>, <17.2365, 149.243, -17.3673>, 0.5 }
		cylinder { <17.2365, 149.243, -17.3673>, <17.7335, 165.6881, -15.7571>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <17.7335, 165.6881, -15.7571>, <18.8866, 172.7296, -12.8242>, 0.4999 }
			cylinder { <18.8866, 172.7296, -12.8242>, <20.8444, 178.4275, -8.006044>, 0.4999 }
			cylinder { <20.8444, 178.4275, -8.006044>, <23.4093, 182.2066, -1.7888>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <23.4093, 182.2066, -1.7888>, <24.4283, 183.7228, 0.8872>, 0.4999 }
				cylinder { <24.4283, 183.7228, 0.8872>, <25.3878, 185.166, 3.6248>, 0.4999 }
				cylinder { <25.3878, 185.166, 3.6248>, <26.2867, 186.5346, 6.4208>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <26.2867, 186.5346, 6.4208>, <26.2963, 186.7785, 6.9876>, 0.03999 }
				cylinder { <26.2963, 186.7785, 6.9876>, <26.1435, 186.988, 7.5476>, 0.03999 }
				cylinder { <26.1435, 186.988, 7.5476>, <25.8393, 187.1479, 8.06035>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <25.8393, 187.1479, 8.06035>, <13.605, 192.7989, 33.04258>, <12.08557, 190.949, 32.9661> }
				triangle { <13.605, 192.7989, 33.04258>, <16.4856, 187.1404, 43.1654>, <12.08557, 190.949, 32.9661> }
				triangle { <13.605, 192.7989, 33.04258>, <17.1984, 189.8341, 41.6002>, <16.4856, 187.1404, 43.1654> }
				triangle { <16.4856, 187.1404, 43.1654>, <13.9066, 186.4533, 40.5848>, <12.08557, 190.949, 32.9661> }
				triangle { <12.08557, 190.949, 32.9661>, <17.709, 187.662, 23.6126>, <25.8393, 187.1479, 8.06035> }
				triangle { <25.8393, 187.1479, 8.06035>, <20.521, 190.7646, 24.4223>, <13.605, 192.7989, 33.04258> }
				triangle { <20.521, 190.7646, 24.4223>, <17.3058, 192.835, 34.5667>, <13.605, 192.7989, 33.04258> }
				triangle { <17.3058, 192.835, 34.5667>, <17.1984, 189.8341, 41.6002>, <13.605, 192.7989, 33.04258> }
				triangle { <12.08557, 190.949, 32.9661>, <13.9066, 186.4533, 40.5848>, <13.07285, 187.3514, 34.5098> }
				triangle { <13.07285, 187.3514, 34.5098>, <17.709, 187.662, 23.6126>, <12.08557, 190.949, 32.9661> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <26.2867, 186.5346, 6.4208>, <26.458, 186.7953, 6.9533>, 0.03999 }
				cylinder { <26.458, 186.7953, 6.9533>, <26.6292, 187.0559, 7.4859>, 0.03999 }
				cylinder { <26.6292, 187.0559, 7.4859>, <26.8004, 187.3166, 8.01848>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <26.8004, 187.3166, 8.01848>, <36.4577, 197.1465, 32.8345>, <34.917, 195.8993, 34.179> }
				triangle { <36.4577, 197.1465, 32.8345>, <44.01758, 191.0444, 39.7916>, <34.917, 195.8993, 34.179> }
				triangle { <36.4577, 197.1465, 32.8345>, <44.07787, 193.3233, 37.5517>, <44.01758, 191.0444, 39.7916> }
				triangle { <44.01758, 191.0444, 39.7916>, <40.3096, 191.1973, 39.6911>, <34.917, 195.8993, 34.179> }
				triangle { <34.917, 195.8993, 34.179>, <31.7602, 190.7697, 24.5023>, <26.8004, 187.3166, 8.01848> }
				triangle { <26.8004, 187.3166, 8.01848>, <34.9898, 192.7874, 22.5817>, <36.4577, 197.1465, 32.8345> }
				triangle { <34.9898, 192.7874, 22.5817>, <40.08497, 195.9899, 31.5992>, <36.4577, 197.1465, 32.8345> }
				triangle { <40.08497, 195.9899, 31.5992>, <44.07787, 193.3233, 37.5517>, <36.4577, 197.1465, 32.8345> }
				triangle { <34.917, 195.8993, 34.179>, <40.3096, 191.1973, 39.6911>, <35.8223, 192.2066, 35.5374> }
				triangle { <35.8223, 192.2066, 35.5374>, <31.7602, 190.7697, 24.5023>, <34.917, 195.8993, 34.179> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <17.7335, 165.6881, -15.7571>, <19.1663, 182.1225, -16.8247>, 0.5 }
		cylinder { <19.1663, 182.1225, -16.8247>, <21.4928, 198.0623, -20.5388>, 0.5 }
		cylinder { <21.4928, 198.0623, -20.5388>, <24.6443, 213.038, -26.7899>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <24.6443, 213.038, -26.7899>, <26.7076, 218.6598, -31.6534>, 0.4999 }
			cylinder { <26.7076, 218.6598, -31.6534>, <29.1551, 222.3471, -37.9722>, 0.4999 }
			cylinder { <29.1551, 222.3471, -37.9722>, <31.7398, 223.7279, -45.1085>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <31.7398, 223.7279, -45.1085>, <32.8253, 224.2295, -48.1199>, 0.4999 }
				cylinder { <32.8253, 224.2295, -48.1199>, <33.91, 224.6526, -51.1436>, 0.4999 }
				cylinder { <33.91, 224.6526, -51.1436>, <34.9933, 224.9969, -54.1777>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <34.9933, 224.9969, -54.1777>, <35.3473, 225.0501, -54.6805>, 0.03999 }
				cylinder { <35.3473, 225.0501, -54.6805>, <35.8232, 225.0871, -55.0717>, 0.03999 }
				cylinder { <35.8232, 225.0871, -55.0717>, <36.3866, 225.1051, -55.3229>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <36.3866, 225.1051, -55.3229>, <61.5161, 223.7334, -68.4512>, <62.4679, 222.1402, -66.9372> }
				triangle { <61.5161, 223.7334, -68.4512>, <64.4729, 214.9713, -76.019>, <62.4679, 222.1402, -66.9372> }
				triangle { <61.5161, 223.7334, -68.4512>, <63.3047, 217.9454, -76.0825>, <64.4729, 214.9713, -76.019> }
				triangle { <64.4729, 214.9713, -76.019>, <64.9428, 215.3517, -72.3561>, <62.4679, 222.1402, -66.9372> }
				triangle { <62.4679, 222.1402, -66.9372>, <52.0844, 221.4543, -62.2867>, <36.3866, 225.1051, -55.3229> }
				triangle { <36.3866, 225.1051, -55.3229>, <50.6767, 223.8909, -65.4915>, <61.5161, 223.7334, -68.4512> }
				triangle { <50.6767, 223.8909, -65.4915>, <59.4501, 222.9683, -71.793>, <61.5161, 223.7334, -68.4512> }
				triangle { <59.4501, 222.9683, -71.793>, <63.3047, 217.9454, -76.0825>, <61.5161, 223.7334, -68.4512> }
				triangle { <62.4679, 222.1402, -66.9372>, <64.9428, 215.3517, -72.3561>, <62.1539, 218.1687, -67.5923> }
				triangle { <62.1539, 218.1687, -67.5923>, <52.0844, 221.4543, -62.2867>, <62.4679, 222.1402, -66.9372> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <34.9933, 224.9969, -54.1777>, <35.1997, 225.0625, -54.7557>, 0.03999 }
				cylinder { <35.1997, 225.0625, -54.7557>, <35.406, 225.1281, -55.3336>, 0.03999 }
				cylinder { <35.406, 225.1281, -55.3336>, <35.6124, 225.1936, -55.9115>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <35.6124, 225.1936, -55.9115>, <43.6068, 225.9101, -83.1384>, <45.481, 224.4458, -82.8553> }
				triangle { <43.6068, 225.9101, -83.1384>, <40.9054, 217.3055, -90.9775>, <45.481, 224.4458, -82.8553> }
				triangle { <43.6068, 225.9101, -83.1384>, <39.8147, 220.1547, -90.02541>, <40.9054, 217.3055, -90.9775> }
				triangle { <40.9054, 217.3055, -90.9775>, <43.8347, 217.8062, -88.7526>, <45.481, 224.4458, -82.8553> }
				triangle { <45.481, 224.4458, -82.8553>, <41.7214, 222.8865, -72.2087>, <35.6124, 225.1936, -55.9115> }
				triangle { <35.6124, 225.1936, -55.9115>, <38.2482, 225.1114, -73.2933>, <43.6068, 225.9101, -83.1384> }
				triangle { <38.2482, 225.1114, -73.2933>, <39.8388, 224.8833, -84.01487>, <43.6068, 225.9101, -83.1384> }
				triangle { <39.8388, 224.8833, -84.01487>, <39.8147, 220.1547, -90.02541>, <43.6068, 225.9101, -83.1384> }
				triangle { <45.481, 224.4458, -82.8553>, <43.8347, 217.8062, -88.7526>, <45.1127, 220.4494, -83.2947> }
				triangle { <45.1127, 220.4494, -83.2947>, <41.7214, 222.8865, -72.2087>, <45.481, 224.4458, -82.8553> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <24.6443, 213.038, -26.7899>, <28.2284, 226.6678, -34.526>, 0.4862 }
		cylinder { <28.2284, 226.6678, -34.526>, <32.2778, 239.1583, -43.8026>, 0.4862 }
		cylinder { <32.2778, 239.1583, -43.8026>, <36.7316, 250.3217, -54.4801>, 0.4862 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <36.7316, 250.3217, -54.4801>, <37.5842, 251.4712, -56.706>, 0.1715 }
			cylinder { <37.5842, 251.4712, -56.706>, <38.4701, 251.8168, -59.1756>, 0.1715 }
			cylinder { <38.4701, 251.8168, -59.1756>, <39.3, 251.3235, -61.6395>, 0.1715 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <39.3, 251.3235, -61.6395>, <39.6452, 251.0896, -62.6698>, 0.1715 }
				cylinder { <39.6452, 251.0896, -62.6698>, <39.9869, 250.8291, -63.6948>, 0.1715 }
				cylinder { <39.9869, 250.8291, -63.6948>, <40.3249, 250.5423, -64.7141>, 0.1715 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <40.3249, 250.5423, -64.7141>, <40.3644, 250.5231, -64.7719>, 0.004706 }
				cylinder { <40.3644, 250.5231, -64.7719>, <40.4185, 250.5047, -64.8167>, 0.004706 }
				cylinder { <40.4185, 250.5047, -64.8167>, <40.4833, 250.4886, -64.8453>, 0.004706 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <40.4833, 250.4886, -64.8453>, <48.7541, 247.1629, -68.7625>, <49.02699, 246.8091, -68.07307> }
				triangle { <48.7541, 247.1629, -68.7625>, <49.2395, 243.2957, -70.03175>, <49.02699, 246.8091, -68.07307> }
				triangle { <48.7541, 247.1629, -68.7625>, <48.9788, 244.2798, -70.4384>, <49.2395, 243.2957, -70.03175> }
				triangle { <49.2395, 243.2957, -70.03175>, <49.4724, 243.8608, -68.9145>, <49.02699, 246.8091, -68.07307> }
				triangle { <49.02699, 246.8091, -68.07307>, <45.54, 247.6902, -66.5394>, <40.4833, 250.4886, -64.8453> }
				triangle { <40.4833, 250.4886, -64.8453>, <45.1254, 248.1153, -67.8765>, <48.7541, 247.1629, -68.7625> }
				triangle { <45.1254, 248.1153, -67.8765>, <47.9664, 246.595, -69.7332>, <48.7541, 247.1629, -68.7625> }
				triangle { <47.9664, 246.595, -69.7332>, <48.9788, 244.2798, -70.4384>, <48.7541, 247.1629, -68.7625> }
				triangle { <49.02699, 246.8091, -68.07307>, <49.4724, 243.8608, -68.9145>, <48.7275, 245.491, -67.7712> }
				triangle { <48.7275, 245.491, -67.7712>, <45.54, 247.6902, -66.5394>, <49.02699, 246.8091, -68.07307> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <40.3249, 250.5423, -64.7141>, <40.347, 250.5236, -64.7807>, 0.004706 }
				cylinder { <40.347, 250.5236, -64.7807>, <40.369, 250.5048, -64.8473>, 0.004706 }
				cylinder { <40.369, 250.5048, -64.8473>, <40.3911, 250.4861, -64.9139>, 0.004706 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <40.3911, 250.4861, -64.9139>, <42.7667, 246.8983, -73.6486>, <43.3588, 246.4026, -73.3678> }
				triangle { <42.7667, 246.8983, -73.6486>, <41.4384, 243.2716, -75.02152>, <43.3588, 246.4026, -73.3678> }
				triangle { <42.7667, 246.8983, -73.6486>, <41.1786, 244.3345, -75.08958>, <41.4384, 243.2716, -75.02152> }
				triangle { <41.4384, 243.2716, -75.02152>, <42.4853, 243.6073, -74.3789>, <43.3588, 246.4026, -73.3678> }
				triangle { <43.3588, 246.4026, -73.3678>, <42.1694, 247.4256, -69.7865>, <40.3911, 250.4861, -64.9139> }
				triangle { <40.3911, 250.4861, -64.9139>, <41.04747, 248.1176, -70.4211>, <42.7667, 246.8983, -73.6486> }
				triangle { <41.04747, 248.1176, -70.4211>, <41.434, 246.6019, -73.795>, <42.7667, 246.8983, -73.6486> }
				triangle { <41.434, 246.6019, -73.795>, <41.1786, 244.3345, -75.08958>, <42.7667, 246.8983, -73.6486> }
				triangle { <43.3588, 246.4026, -73.3678>, <42.4853, 243.6073, -74.3789>, <43.08826, 245.0984, -72.9886> }
				triangle { <43.08826, 245.0984, -72.9886>, <42.1694, 247.4256, -69.7865>, <43.3588, 246.4026, -73.3678> }
				material { txgilia_leaf }}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <36.7316, 250.3217, -54.4801>, <37.1182, 251.7661, -55.7056>, 0.2192 }
			cylinder { <37.1182, 251.7661, -55.7056>, <37.3522, 253.2985, -56.8609>, 0.2192 }
			cylinder { <37.3522, 253.2985, -56.8609>, <37.4313, 254.9042, -57.9348>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <37.4313, 254.9042, -57.9348>, <37.3547, 256.5677, -58.9169>, 0.2192 }
			cylinder { <37.3547, 256.5677, -58.9169>, <37.1231, 258.273, -59.7978>, 0.2192 }
			cylinder { <37.1231, 258.273, -59.7978>, <36.7388, 260.0037, -60.5691>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <36.7388, 260.0037, -60.5691>, <36.5409, 261.769, -61.3322>, 0.2192 }
			cylinder { <36.5409, 261.769, -61.3322>, <36.5312, 263.5519, -62.07991>, 0.2192 }
			cylinder { <36.5312, 263.5519, -62.07991>, <36.71, 265.3352, -62.8049>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <36.71, 265.3352, -62.8049>, <37.3273, 267.9747, -63.8352>, 0.2192 }
				cylinder { <37.3273, 267.9747, -63.8352>, <38.2846, 270.5392, -64.7929>, 0.2192 }
				cylinder { <38.2846, 270.5392, -64.7929>, <39.5675, 272.99, -65.6635>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <39.5675, 272.99, -65.6635>, <44.4176, 282.401, -69.8371>, <42.9539, 282.824, -70.08766> }
					triangle { <39.5675, 272.99, -65.6635>, <42.9112, 277.9655, -67.4896>, <44.4176, 282.401, -69.8371> }
					triangle { <42.9539, 282.824, -70.08766>, <41.08456, 279.2928, -67.2654>, <39.5675, 272.99, -65.6635> }
					triangle { <42.9112, 277.9655, -67.4896>, <45.02256, 281.7007, -71.2432>, <44.4176, 282.401, -69.8371> }
					triangle { <45.02256, 281.7007, -71.2432>, <44.443, 282.032, -73.9183>, <44.4176, 282.401, -69.8371> }
					triangle { <42.9539, 282.824, -70.08766>, <41.8347, 283.6823, -71.3406>, <41.8872, 283.6934, -69.2839> }
					triangle { <41.8872, 283.6934, -69.2839>, <41.08456, 279.2928, -67.2654>, <42.9539, 282.824, -70.08766> }
					triangle { <44.443, 282.032, -73.9183>, <44.2943, 282.508, -73.5559>, <43.466, 283.0962, -71.379> }
					triangle { <44.2943, 282.508, -73.5559>, <42.2652, 281.9842, -75.2738>, <41.862, 283.8722, -72.6276> }
					triangle { <43.466, 283.0962, -71.379>, <41.862, 283.8722, -72.6276>, <41.8347, 283.6823, -71.3406> }
					triangle { <43.466, 283.0962, -71.379>, <44.2943, 282.508, -73.5559>, <41.862, 283.8722, -72.6276> }
					triangle { <44.4176, 282.401, -69.8371>, <44.443, 282.032, -73.9183>, <43.466, 283.0962, -71.379> }
					triangle { <42.9539, 282.824, -70.08766>, <43.466, 283.0962, -71.379>, <41.8347, 283.6823, -71.3406> }
					triangle { <44.4176, 282.401, -69.8371>, <43.466, 283.0962, -71.379>, <42.9539, 282.824, -70.08766> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <39.5675, 272.99, -65.6635>, <43.04612, 283.0715, -69.6349>, <42.4509, 283.5935, -68.3092> }
					triangle { <39.5675, 272.99, -65.6635>, <42.02303, 278.1005, -68.3326>, <43.04612, 283.0715, -69.6349> }
					triangle { <42.4509, 283.5935, -68.3092>, <42.08379, 279.1409, -66.317>, <39.5675, 272.99, -65.6635> }
					triangle { <42.02303, 278.1005, -68.3326>, <41.881, 283.2177, -70.8411>, <43.04612, 283.0715, -69.6349> }
					triangle { <41.881, 283.2177, -70.8411>, <39.7601, 284.9384, -71.2195>, <43.04612, 283.0715, -69.6349> }
					triangle { <42.4509, 283.5935, -68.3092>, <41.4493, 285.0114, -67.5708>, <43.04643, 283.9215, -66.8678> }
					triangle { <43.04643, 283.9215, -66.8678>, <42.08379, 279.1409, -66.317>, <42.4509, 283.5935, -68.3092> }
					triangle { <39.7601, 284.9384, -71.2195>, <40.209, 285.1503, -70.8539>, <41.8136, 284.5024, -69.1877> }
					triangle { <40.209, 285.1503, -70.8539>, <37.7912, 285.6674, -69.7449>, <40.572, 285.8586, -68.02456> }
					triangle { <41.8136, 284.5024, -69.1877>, <40.572, 285.8586, -68.02456>, <41.4493, 285.0114, -67.5708> }
					triangle { <41.8136, 284.5024, -69.1877>, <40.209, 285.1503, -70.8539>, <40.572, 285.8586, -68.02456> }
					triangle { <43.04612, 283.0715, -69.6349>, <39.7601, 284.9384, -71.2195>, <41.8136, 284.5024, -69.1877> }
					triangle { <42.4509, 283.5935, -68.3092>, <41.8136, 284.5024, -69.1877>, <41.4493, 285.0114, -67.5708> }
					triangle { <43.04612, 283.0715, -69.6349>, <41.8136, 284.5024, -69.1877>, <42.4509, 283.5935, -68.3092> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <39.5675, 272.99, -65.6635>, <42.9569, 283.559, -68.1769>, <43.9768, 283.3047, -67.04585> }
					triangle { <39.5675, 272.99, -65.6635>, <41.07463, 278.6834, -67.8047>, <42.9569, 283.559, -68.1769> }
					triangle { <43.9768, 283.3047, -67.04585>, <43.1507, 278.4852, -66.9108>, <39.5675, 272.99, -65.6635> }
					triangle { <41.07463, 278.6834, -67.8047>, <41.6211, 284.3511, -67.5275>, <42.9569, 283.559, -68.1769> }
					triangle { <41.6211, 284.3511, -67.5275>, <41.2926, 286.052, -65.3824>, <42.9569, 283.559, -68.1769> }
					triangle { <43.9768, 283.3047, -67.04585>, <44.8198, 284.13, -65.5735>, <45.4875, 282.7999, -66.9941> }
					triangle { <45.4875, 282.7999, -66.9941>, <43.1507, 278.4852, -66.9108>, <43.9768, 283.3047, -67.04585> }
					triangle { <41.2926, 286.052, -65.3824>, <41.8638, 286.0265, -65.613>, <43.4874, 284.5555, -66.5983> }
					triangle { <41.8638, 286.0265, -65.613>, <41.9535, 285.922, -62.9068>, <44.5238, 285.1067, -64.7663> }
					triangle { <43.4874, 284.5555, -66.5983>, <44.5238, 285.1067, -64.7663>, <44.8198, 284.13, -65.5735> }
					triangle { <43.4874, 284.5555, -66.5983>, <41.8638, 286.0265, -65.613>, <44.5238, 285.1067, -64.7663> }
					triangle { <42.9569, 283.559, -68.1769>, <41.2926, 286.052, -65.3824>, <43.4874, 284.5555, -66.5983> }
					triangle { <43.9768, 283.3047, -67.04585>, <43.4874, 284.5555, -66.5983>, <44.8198, 284.13, -65.5735> }
					triangle { <42.9569, 283.559, -68.1769>, <43.4874, 284.5555, -66.5983>, <43.9768, 283.3047, -67.04585> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <39.5675, 272.99, -65.6635>, <44.2725, 283.1944, -67.4643>, <45.4371, 282.3541, -68.0317> }
					triangle { <39.5675, 272.99, -65.6635>, <41.3678, 278.914, -66.6306>, <44.2725, 283.1944, -67.4643> }
					triangle { <45.4371, 282.3541, -68.0317>, <42.8208, 278.2257, -68.2317>, <39.5675, 272.99, -65.6635> }
					triangle { <41.3678, 278.914, -66.6306>, <44.5995, 283.5451, -65.8507>, <44.2725, 283.1944, -67.4643> }
					triangle { <44.5995, 283.5451, -65.8507>, <46.9369, 283.8442, -64.4193>, <44.2725, 283.1944, -67.4643> }
					triangle { <45.4371, 282.3541, -68.0317>, <47.3197, 282.2478, -68.09033>, <45.8598, 281.8681, -69.4893> }
					triangle { <45.8598, 281.8681, -69.4893>, <42.8208, 278.2257, -68.2317>, <45.4371, 282.3541, -68.0317> }
					triangle { <46.9369, 283.8442, -64.4193>, <46.9873, 283.9338, -65.02719>, <46.19, 283.1826, -67.165> }
					triangle { <46.9873, 283.9338, -65.02719>, <49.03879, 282.3985, -64.1456>, <48.2931, 282.6485, -67.3253> }
					triangle { <46.19, 283.1826, -67.165>, <48.2931, 282.6485, -67.3253>, <47.3197, 282.2478, -68.09033> }
					triangle { <46.19, 283.1826, -67.165>, <46.9873, 283.9338, -65.02719>, <48.2931, 282.6485, -67.3253> }
					triangle { <44.2725, 283.1944, -67.4643>, <46.9369, 283.8442, -64.4193>, <46.19, 283.1826, -67.165> }
					triangle { <45.4371, 282.3541, -68.0317>, <46.19, 283.1826, -67.165>, <47.3197, 282.2478, -68.09033> }
					triangle { <44.2725, 283.1944, -67.4643>, <46.19, 283.1826, -67.165>, <45.4371, 282.3541, -68.0317> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <39.5675, 272.99, -65.6635>, <45.1889, 282.4679, -68.5058>, <44.7953, 282.0525, -69.94> }
					triangle { <39.5675, 272.99, -65.6635>, <42.52, 278.4637, -66.4329>, <45.1889, 282.4679, -68.5058> }
					triangle { <44.7953, 282.0525, -69.94>, <41.5246, 278.7323, -68.4542>, <39.5675, 272.99, -65.6635> }
					triangle { <42.52, 278.4637, -66.4329>, <46.7334, 281.8823, -68.1818>, <45.1889, 282.4679, -68.5058> }
					triangle { <46.7334, 281.8823, -68.1818>, <48.9134, 281.3222, -69.7744>, <45.1889, 282.4679, -68.5058> }
					triangle { <44.7953, 282.0525, -69.94>, <45.447, 281.9669, -71.7083>, <43.6011, 282.4287, -70.9259> }
					triangle { <43.6011, 282.4287, -70.9259>, <41.5246, 278.7323, -68.4542>, <44.7953, 282.0525, -69.94> }
					triangle { <48.9134, 281.3222, -69.7744>, <48.5121, 281.7265, -70.01025>, <46.1765, 282.267, -70.1643> }
					triangle { <48.5121, 281.7265, -70.01025>, <49.2343, 279.9281, -71.9042>, <46.6232, 281.874, -72.2572> }
					triangle { <46.1765, 282.267, -70.1643>, <46.6232, 281.874, -72.2572>, <45.447, 281.9669, -71.7083> }
					triangle { <46.1765, 282.267, -70.1643>, <48.5121, 281.7265, -70.01025>, <46.6232, 281.874, -72.2572> }
					triangle { <45.1889, 282.4679, -68.5058>, <48.9134, 281.3222, -69.7744>, <46.1765, 282.267, -70.1643> }
					triangle { <44.7953, 282.0525, -69.94>, <46.1765, 282.267, -70.1643>, <45.447, 281.9669, -71.7083> }
					triangle { <45.1889, 282.4679, -68.5058>, <46.1765, 282.267, -70.1643>, <44.7953, 282.0525, -69.94> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <36.71, 265.3352, -62.8049>, <36.7631, 267.0671, -63.6624>, 0.2192 }
			cylinder { <36.7631, 267.0671, -63.6624>, <36.69, 268.731, -64.6443>, 0.2192 }
			cylinder { <36.69, 268.731, -64.6443>, <36.4914, 270.3107, -65.7409>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <36.4914, 270.3107, -65.7409>, <35.9626, 272.4908, -67.5788>, 0.2192 }
				cylinder { <35.9626, 272.4908, -67.5788>, <35.2108, 274.4485, -69.5819>, 0.2192 }
				cylinder { <35.2108, 274.4485, -69.5819>, <34.2472, 276.1543, -71.72>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <34.2472, 276.1543, -71.72>, <29.3944, 283.0322, -79.3686>, <30.4523, 284.0368, -78.8656> }
					triangle { <34.2472, 276.1543, -71.72>, <31.3021, 279.2343, -76.3096>, <29.3944, 283.0322, -79.3686> }
					triangle { <30.4523, 284.0368, -78.8656>, <33.07016, 280.6386, -76.5205>, <34.2472, 276.1543, -71.72> }
					triangle { <31.3021, 279.2343, -76.3096>, <27.9646, 283.2883, -78.5199>, <29.3944, 283.0322, -79.3686> }
					triangle { <27.9646, 283.2883, -78.5199>, <26.8539, 285.5059, -77.3191>, <29.3944, 283.0322, -79.3686> }
					triangle { <30.4523, 284.0368, -78.8656>, <30.7032, 285.8519, -78.4215>, <31.9054, 284.4688, -79.354> }
					triangle { <31.9054, 284.4688, -79.354>, <33.07016, 280.6386, -76.5205>, <30.4523, 284.0368, -78.8656> }
					triangle { <26.8539, 285.5059, -77.3191>, <27.2625, 285.6249, -77.7646>, <29.3147, 284.8709, -78.7565> }
					triangle { <27.2625, 285.6249, -77.7646>, <27.73, 287.2246, -75.63>, <29.9344, 286.8192, -78.016> }
					triangle { <29.3147, 284.8709, -78.7565>, <29.9344, 286.8192, -78.016>, <30.7032, 285.8519, -78.4215> }
					triangle { <29.3147, 284.8709, -78.7565>, <27.2625, 285.6249, -77.7646>, <29.9344, 286.8192, -78.016> }
					triangle { <29.3944, 283.0322, -79.3686>, <26.8539, 285.5059, -77.3191>, <29.3147, 284.8709, -78.7565> }
					triangle { <30.4523, 284.0368, -78.8656>, <29.3147, 284.8709, -78.7565>, <30.7032, 285.8519, -78.4215> }
					triangle { <29.3944, 283.0322, -79.3686>, <29.3147, 284.8709, -78.7565>, <30.4523, 284.0368, -78.8656> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <34.2472, 276.1543, -71.72>, <30.6918, 283.8568, -79.2953>, <32.03785, 283.537, -79.9789> }
					triangle { <34.2472, 276.1543, -71.72>, <31.5082, 280.2267, -75.6107>, <30.6918, 283.8568, -79.2953> }
					triangle { <32.03785, 283.537, -79.9789>, <32.8383, 279.5221, -77.3068>, <34.2472, 276.1543, -71.72> }
					triangle { <31.5082, 280.2267, -75.6107>, <30.8967, 285.2059, -78.3114>, <30.6918, 283.8568, -79.2953> }
					triangle { <30.8967, 285.2059, -78.3114>, <32.5916, 287.3761, -78.4128>, <30.6918, 283.8568, -79.2953> }
					triangle { <32.03785, 283.537, -79.9789>, <33.4855, 284.336, -80.8848>, <32.4933, 282.5542, -81.1465> }
					triangle { <32.4933, 282.5542, -81.1465>, <32.8383, 279.5221, -77.3068>, <32.03785, 283.537, -79.9789> }
					triangle { <32.5916, 287.3761, -78.4128>, <32.4944, 287.0929, -78.9513>, <32.1461, 284.9477, -79.9713> }
					triangle { <32.4944, 287.0929, -78.9513>, <35.1329, 287.6227, -78.6487>, <34.02825, 285.5177, -80.8992> }
					triangle { <32.1461, 284.9477, -79.9713>, <34.02825, 285.5177, -80.8992>, <33.4855, 284.336, -80.8848> }
					triangle { <32.1461, 284.9477, -79.9713>, <32.4944, 287.0929, -78.9513>, <34.02825, 285.5177, -80.8992> }
					triangle { <30.6918, 283.8568, -79.2953>, <32.5916, 287.3761, -78.4128>, <32.1461, 284.9477, -79.9713> }
					triangle { <32.03785, 283.537, -79.9789>, <32.1461, 284.9477, -79.9713>, <33.4855, 284.336, -80.8848> }
					triangle { <30.6918, 283.8568, -79.2953>, <32.1461, 284.9477, -79.9713>, <32.03785, 283.537, -79.9789> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <34.2472, 276.1543, -71.72>, <31.717, 283.2303, -80.2572>, <31.5634, 281.919, -81.05606> }
					triangle { <34.2472, 276.1543, -71.72>, <32.658, 280.6143, -75.8196>, <31.717, 283.2303, -80.2572> }
					triangle { <31.5634, 281.919, -81.05606>, <31.5448, 279.0861, -77.07175>, <34.2472, 276.1543, -71.72> }
					triangle { <32.658, 280.6143, -75.8196>, <33.2753, 283.8205, -80.4886>, <31.717, 283.2303, -80.2572> }
					triangle { <33.2753, 283.8205, -80.4886>, <35.08991, 283.6009, -82.5506>, <31.717, 283.2303, -80.2572> }
					triangle { <31.5634, 281.919, -81.05606>, <31.9212, 281.1355, -82.7332>, <30.3362, 280.9764, -81.4331> }
					triangle { <30.3362, 280.9764, -81.4331>, <31.5448, 279.0861, -77.07175>, <31.5634, 281.919, -81.05606> }
					triangle { <35.08991, 283.6009, -82.5506>, <34.5004, 283.5163, -82.7088>, <32.4095, 282.6063, -81.958> }
					triangle { <34.5004, 283.5163, -82.7088>, <36.04778, 281.6125, -83.8559>, <32.7908, 281.3338, -83.6796> }
					triangle { <32.4095, 282.6063, -81.958>, <32.7908, 281.3338, -83.6796>, <31.9212, 281.1355, -82.7332> }
					triangle { <32.4095, 282.6063, -81.958>, <34.5004, 283.5163, -82.7088>, <32.7908, 281.3338, -83.6796> }
					triangle { <31.717, 283.2303, -80.2572>, <35.08991, 283.6009, -82.5506>, <32.4095, 282.6063, -81.958> }
					triangle { <31.5634, 281.919, -81.05606>, <32.4095, 282.6063, -81.958>, <31.9212, 281.1355, -82.7332> }
					triangle { <31.717, 283.2303, -80.2572>, <32.4095, 282.6063, -81.958>, <31.5634, 281.919, -81.05606> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <34.2472, 276.1543, -71.72>, <31.06281, 282.0126, -80.9338>, <29.6803, 281.4037, -80.6185> }
					triangle { <34.2472, 276.1543, -71.72>, <33.1733, 279.865, -76.6497>, <31.06281, 282.0126, -80.9338> }
					triangle { <29.6803, 281.4037, -80.6185>, <30.965, 279.929, -76.1379>, <34.2472, 276.1543, -71.72> }
					triangle { <33.1733, 279.865, -76.6497>, <31.8355, 281.0338, -82.06301>, <31.06281, 282.0126, -80.9338> }
					triangle { <31.8355, 281.0338, -82.06301>, <30.9195, 279.3622, -84.05289>, <31.06281, 282.0126, -80.9338> }
					triangle { <29.6803, 281.4037, -80.6185>, <28.1575, 280.6435, -81.4295>, <28.3949, 281.9013, -79.8204> }
					triangle { <28.3949, 281.9013, -79.8204>, <30.965, 279.929, -76.1379>, <29.6803, 281.4037, -80.6185> }
					triangle { <30.9195, 279.3622, -84.05289>, <30.5271, 279.8045, -83.8795>, <29.7433, 281.0606, -81.9896> }
					triangle { <30.5271, 279.8045, -83.8795>, <29.2188, 277.444, -84.1041>, <27.9207, 280.0105, -82.5406> }
					triangle { <29.7433, 281.0606, -81.9896>, <27.9207, 280.0105, -82.5406>, <28.1575, 280.6435, -81.4295> }
					triangle { <29.7433, 281.0606, -81.9896>, <30.5271, 279.8045, -83.8795>, <27.9207, 280.0105, -82.5406> }
					triangle { <31.06281, 282.0126, -80.9338>, <30.9195, 279.3622, -84.05289>, <29.7433, 281.0606, -81.9896> }
					triangle { <29.6803, 281.4037, -80.6185>, <29.7433, 281.0606, -81.9896>, <28.1575, 280.6435, -81.4295> }
					triangle { <31.06281, 282.0126, -80.9338>, <29.7433, 281.0606, -81.9896>, <29.6803, 281.4037, -80.6185> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <34.2472, 276.1543, -71.72>, <29.6056, 281.8883, -80.3764>, <28.9832, 282.7324, -79.2443> }
					triangle { <34.2472, 276.1543, -71.72>, <32.3227, 278.9992, -76.9571>, <29.6056, 281.8883, -80.3764> }
					triangle { <28.9832, 282.7324, -79.2443>, <31.922, 280.9031, -75.7921>, <34.2472, 276.1543, -71.72> }
					triangle { <32.3227, 278.9992, -76.9571>, <28.5038, 280.7, -80.8279>, <29.6056, 281.8883, -80.3764> }
					triangle { <28.5038, 280.7, -80.8279>, <25.7525, 280.5573, -80.7708>, <29.6056, 281.8883, -80.3764> }
					triangle { <28.9832, 282.7324, -79.2443>, <27.3934, 283.6024, -78.7245>, <29.3794, 284.0923, -78.516> }
					triangle { <29.3794, 284.0923, -78.516>, <31.922, 280.9031, -75.7921>, <28.9832, 282.7324, -79.2443> }
					triangle { <25.7525, 280.5573, -80.7708>, <25.9863, 281.1274, -80.7777>, <27.8018, 282.4814, -79.9811> }
					triangle { <25.9863, 281.1274, -80.7777>, <24.00056, 280.9648, -78.9435>, <26.1287, 283.4518, -78.9874> }
					triangle { <27.8018, 282.4814, -79.9811>, <26.1287, 283.4518, -78.9874>, <27.3934, 283.6024, -78.7245> }
					triangle { <27.8018, 282.4814, -79.9811>, <25.9863, 281.1274, -80.7777>, <26.1287, 283.4518, -78.9874> }
					triangle { <29.6056, 281.8883, -80.3764>, <25.7525, 280.5573, -80.7708>, <27.8018, 282.4814, -79.9811> }
					triangle { <28.9832, 282.7324, -79.2443>, <27.8018, 282.4814, -79.9811>, <27.3934, 283.6024, -78.7245> }
					triangle { <29.6056, 281.8883, -80.3764>, <27.8018, 282.4814, -79.9811>, <28.9832, 282.7324, -79.2443> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <36.4914, 270.3107, -65.7409>, <36.291, 271.9907, -66.6765>, 0.2192 }
			cylinder { <36.291, 271.9907, -66.6765>, <36.0908, 273.7547, -67.442>, 0.2192 }
			cylinder { <36.0908, 273.7547, -67.442>, <35.8925, 275.5858, -68.03003>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <35.8925, 275.5858, -68.03003>, <35.6029, 278.4207, -68.5676>, 0.2192 }
				cylinder { <35.6029, 278.4207, -68.5676>, <35.3255, 281.3015, -68.7527>, 0.2192 }
				cylinder { <35.3255, 281.3015, -68.7527>, <35.06441, 284.1847, -68.5825>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <35.06441, 284.1847, -68.5825>, <35.05418, 295.5425, -67.9856>, <34.853, 295.4402, -69.5122> }
					triangle { <35.06441, 284.1847, -68.5825>, <34.846, 290.3387, -67.44>, <35.05418, 295.5425, -67.9856> }
					triangle { <34.853, 295.4402, -69.5122>, <33.755, 290.6777, -69.3989>, <35.06441, 284.1847, -68.5825> }
					triangle { <34.846, 290.3387, -67.44>, <36.6971, 295.722, -67.6715>, <35.05418, 295.5425, -67.9856> }
					triangle { <36.6971, 295.722, -67.6715>, <38.7851, 296.808, -69.1045>, <35.05418, 295.5425, -67.9856> }
					triangle { <34.853, 295.4402, -69.5122>, <35.3748, 296.2195, -71.1479>, <33.5859, 295.4594, -70.477> }
					triangle { <33.5859, 295.4594, -70.477>, <33.755, 290.6777, -69.3989>, <34.853, 295.4402, -69.5122> }
					triangle { <38.7851, 296.808, -69.1045>, <38.2251, 297.0132, -69.2592>, <35.9291, 296.3589, -69.5121> }
					triangle { <38.2251, 297.0132, -69.2592>, <39.6572, 296.4632, -71.491>, <36.4116, 296.8836, -71.5664> }
					triangle { <35.9291, 296.3589, -69.5121>, <36.4116, 296.8836, -71.5664>, <35.3748, 296.2195, -71.1479> }
					triangle { <35.9291, 296.3589, -69.5121>, <38.2251, 297.0132, -69.2592>, <36.4116, 296.8836, -71.5664> }
					triangle { <35.05418, 295.5425, -67.9856>, <38.7851, 296.808, -69.1045>, <35.9291, 296.3589, -69.5121> }
					triangle { <34.853, 295.4402, -69.5122>, <35.9291, 296.3589, -69.5121>, <35.3748, 296.2195, -71.1479> }
					triangle { <35.05418, 295.5425, -67.9856>, <35.9291, 296.3589, -69.5121>, <34.853, 295.4402, -69.5122> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <35.06441, 284.1847, -68.5825>, <34.3574, 295.5097, -69.3576>, <32.869, 295.2147, -69.6388> }
					triangle { <35.06441, 284.1847, -68.5825>, <35.3825, 290.4395, -68.5436>, <34.3574, 295.5097, -69.3576> }
					triangle { <32.869, 295.2147, -69.6388>, <33.1514, 290.5643, -68.1574>, <35.06441, 284.1847, -68.5825> }
					triangle { <35.3825, 290.4395, -68.5436>, <35.163, 295.6544, -70.8273>, <34.3574, 295.5097, -69.3576> }
					triangle { <35.163, 295.6544, -70.8273>, <34.3691, 296.4443, -73.345>, <34.3574, 295.5097, -69.3576> }
					triangle { <32.869, 295.2147, -69.6388>, <31.4133, 295.7451, -70.7132>, <31.5511, 295.1631, -68.746> }
					triangle { <31.5511, 295.1631, -68.746>, <33.1514, 290.5643, -68.1574>, <32.869, 295.2147, -69.6388> }
					triangle { <34.3691, 296.4443, -73.345>, <34.02013, 296.6523, -72.8818>, <33.1142, 296.0753, -70.7347> }
					triangle { <34.02013, 296.6523, -72.8818>, <32.446, 295.7462, -74.8905>, <31.2807, 296.2999, -71.8819> }
					triangle { <33.1142, 296.0753, -70.7347>, <31.2807, 296.2999, -71.8819>, <31.4133, 295.7451, -70.7132> }
					triangle { <33.1142, 296.0753, -70.7347>, <34.02013, 296.6523, -72.8818>, <31.2807, 296.2999, -71.8819> }
					triangle { <34.3574, 295.5097, -69.3576>, <34.3691, 296.4443, -73.345>, <33.1142, 296.0753, -70.7347> }
					triangle { <32.869, 295.2147, -69.6388>, <33.1142, 296.0753, -70.7347>, <31.4133, 295.7451, -70.7132> }
					triangle { <34.3574, 295.5097, -69.3576>, <33.1142, 296.0753, -70.7347>, <32.869, 295.2147, -69.6388> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <35.06441, 284.1847, -68.5825>, <32.8467, 295.3266, -69.1276>, <32.1348, 295.0648, -67.7837> }
					triangle { <35.06441, 284.1847, -68.5825>, <34.5072, 290.3681, -69.4065>, <32.8467, 295.3266, -69.1276> }
					triangle { <32.1348, 295.0648, -67.7837>, <34.1362, 290.6445, -67.1865>, <35.06441, 284.1847, -68.5825> }
					triangle { <34.5072, 290.3681, -69.4065>, <31.7092, 295.2379, -70.3638>, <32.8467, 295.3266, -69.1276> }
					triangle { <31.7092, 295.2379, -70.3638>, <28.9986, 295.7215, -70.4728>, <32.8467, 295.3266, -69.1276> }
					triangle { <32.1348, 295.0648, -67.7837>, <30.596, 295.5133, -66.7908>, <32.5544, 295.1922, -66.2525> }
					triangle { <32.5544, 295.1922, -66.2525>, <34.1362, 290.6445, -67.1865>, <32.1348, 295.0648, -67.7837> }
					triangle { <28.9986, 295.7215, -70.4728>, <29.2981, 296.0049, -70.01498>, <31.08814, 295.7601, -68.4338> }
					triangle { <29.2981, 296.0049, -70.01498>, <27.00299, 294.9122, -69.08097>, <29.393, 295.9133, -67.08054> }
					triangle { <31.08814, 295.7601, -68.4338>, <29.393, 295.9133, -67.08054>, <30.596, 295.5133, -66.7908> }
					triangle { <31.08814, 295.7601, -68.4338>, <29.2981, 296.0049, -70.01498>, <29.393, 295.9133, -67.08054> }
					triangle { <32.8467, 295.3266, -69.1276>, <28.9986, 295.7215, -70.4728>, <31.08814, 295.7601, -68.4338> }
					triangle { <32.1348, 295.0648, -67.7837>, <31.08814, 295.7601, -68.4338>, <30.596, 295.5133, -66.7908> }
					triangle { <32.8467, 295.3266, -69.1276>, <31.08814, 295.7601, -68.4338>, <32.1348, 295.0648, -67.7837> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <35.06441, 284.1847, -68.5825>, <32.5956, 295.2445, -67.6114>, <33.6581, 295.1962, -66.4933> }
					triangle { <35.06441, 284.1847, -68.5825>, <33.4215, 290.2227, -68.8443>, <32.5956, 295.2445, -67.6114> }
					triangle { <33.6581, 295.1962, -66.4933>, <35.3576, 290.8082, -67.819>, <35.06441, 284.1847, -68.5825> }
					triangle { <33.4215, 290.2227, -68.8443>, <31.07647, 295.0441, -66.9172>, <32.5956, 295.2445, -67.6114> }
					triangle { <31.07647, 295.0441, -66.9172>, <30.04531, 295.6316, -64.4303>, <32.5956, 295.2445, -67.6114> }
					triangle { <33.6581, 295.1962, -66.4933>, <34.04482, 295.8423, -64.7647>, <35.2185, 295.5068, -66.4193> }
					triangle { <35.2185, 295.5068, -66.4193>, <35.3576, 290.8082, -67.819>, <33.6581, 295.1962, -66.4933> }
					triangle { <30.04531, 295.6316, -64.4303>, <30.5407, 295.9594, -64.5938>, <32.6318, 295.8459, -65.7677> }
					triangle { <30.5407, 295.9594, -64.5938>, <30.7994, 295.1061, -62.03665>, <33.3397, 296.2545, -63.7527> }
					triangle { <32.6318, 295.8459, -65.7677>, <33.3397, 296.2545, -63.7527>, <34.04482, 295.8423, -64.7647> }
					triangle { <32.6318, 295.8459, -65.7677>, <30.5407, 295.9594, -64.5938>, <33.3397, 296.2545, -63.7527> }
					triangle { <32.5956, 295.2445, -67.6114>, <30.04531, 295.6316, -64.4303>, <32.6318, 295.8459, -65.7677> }
					triangle { <33.6581, 295.1962, -66.4933>, <32.6318, 295.8459, -65.7677>, <34.04482, 295.8423, -64.7647> }
					triangle { <32.5956, 295.2445, -67.6114>, <32.6318, 295.8459, -65.7677>, <33.6581, 295.1962, -66.4933> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <35.06441, 284.1847, -68.5825>, <33.9805, 295.3799, -66.8949>, <35.3635, 295.4318, -67.5777> }
					triangle { <35.06441, 284.1847, -68.5825>, <33.634, 290.2042, -67.6106>, <33.9805, 295.3799, -66.8949> }
					triangle { <35.3635, 295.4318, -67.5777>, <35.1184, 290.829, -69.207>, <35.06441, 284.1847, -68.5825> }
					triangle { <33.634, 290.2042, -67.6106>, <34.2056, 295.3478, -65.2281>, <33.9805, 295.3799, -66.8949> }
					triangle { <34.2056, 295.3478, -65.2281>, <36.185, 296.3133, -63.5719>, <33.9805, 295.3799, -66.8949> }
					triangle { <35.3635, 295.4318, -67.5777>, <37.04283, 296.2853, -67.4982>, <35.8657, 295.6744, -69.06957> }
					triangle { <35.8657, 295.6744, -69.06957>, <35.1184, 290.829, -69.207>, <35.3635, 295.4318, -67.5777> }
					triangle { <36.185, 296.3133, -63.5719>, <36.1412, 296.592, -64.1197>, <35.6689, 296.2215, -66.4442> }
					triangle { <36.1412, 296.592, -64.1197>, <38.7383, 296.0791, -63.5486>, <37.7429, 296.8632, -66.567> }
					triangle { <35.6689, 296.2215, -66.4442>, <37.7429, 296.8632, -66.567>, <37.04283, 296.2853, -67.4982> }
					triangle { <35.6689, 296.2215, -66.4442>, <36.1412, 296.592, -64.1197>, <37.7429, 296.8632, -66.567> }
					triangle { <33.9805, 295.3799, -66.8949>, <36.185, 296.3133, -63.5719>, <35.6689, 296.2215, -66.4442> }
					triangle { <35.3635, 295.4318, -67.5777>, <35.6689, 296.2215, -66.4442>, <37.04283, 296.2853, -67.4982> }
					triangle { <33.9805, 295.3799, -66.8949>, <35.6689, 296.2215, -66.4442>, <35.3635, 295.4318, -67.5777> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <35.8925, 275.5858, -68.03003>, <35.8195, 277.3766, -68.7546>, 0.2192 }
			cylinder { <35.8195, 277.3766, -68.7546>, <35.8726, 279.1101, -69.609>, 0.2192 }
			cylinder { <35.8726, 279.1101, -69.609>, <36.05127, 280.7696, -70.5848>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <36.05127, 280.7696, -70.5848>, <36.5506, 283.0862, -72.2563>, 0.2192 }
				cylinder { <36.5506, 283.0862, -72.2563>, <37.274, 285.1955, -74.1103>, 0.2192 }
				cylinder { <37.274, 285.1955, -74.1103>, <38.2105, 287.0658, -76.1191>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <38.2105, 287.0658, -76.1191>, <41.02517, 293.8274, -84.8128>, <40.2315, 294.8805, -84.01273> }
					triangle { <38.2105, 287.0658, -76.1191>, <40.3949, 290.2466, -81.048>, <41.02517, 293.8274, -84.8128> }
					triangle { <40.2315, 294.8805, -84.01273>, <40.1149, 292.1983, -79.93>, <38.2105, 287.0658, -76.1191> }
					triangle { <40.3949, 290.2466, -81.048>, <39.9974, 293.1267, -85.9442>, <41.02517, 293.8274, -84.8128> }
					triangle { <39.9974, 293.1267, -85.9442>, <37.7653, 294.0311, -87.2801>, <41.02517, 293.8274, -84.8128> }
					triangle { <40.2315, 294.8805, -84.01273>, <39.0087, 296.3009, -84.2081>, <40.6201, 296.0145, -82.9653> }
					triangle { <40.6201, 296.0145, -82.9653>, <40.1149, 292.1983, -79.93>, <40.2315, 294.8805, -84.01273> }
					triangle { <37.7653, 294.0311, -87.2801>, <38.144, 294.4705, -87.07356>, <39.6063, 295.0677, -85.2672> }
					triangle { <38.144, 294.4705, -87.07356>, <35.5773, 295.1282, -86.5206>, <38.1048, 296.6281, -85.08297> }
					triangle { <39.6063, 295.0677, -85.2672>, <38.1048, 296.6281, -85.08297>, <39.0087, 296.3009, -84.2081> }
					triangle { <39.6063, 295.0677, -85.2672>, <38.144, 294.4705, -87.07356>, <38.1048, 296.6281, -85.08297> }
					triangle { <41.02517, 293.8274, -84.8128>, <37.7653, 294.0311, -87.2801>, <39.6063, 295.0677, -85.2672> }
					triangle { <40.2315, 294.8805, -84.01273>, <39.6063, 295.0677, -85.2672>, <39.0087, 296.3009, -84.2081> }
					triangle { <41.02517, 293.8274, -84.8128>, <39.6063, 295.0677, -85.2672>, <40.2315, 294.8805, -84.01273> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <38.2105, 287.0658, -76.1191>, <40.7194, 294.9991, -83.8643>, <41.6239, 295.548, -82.742> }
					triangle { <38.2105, 287.0658, -76.1191>, <39.3372, 290.8696, -80.9611>, <40.7194, 294.9991, -83.8643> }
					triangle { <41.6239, 295.548, -82.742>, <41.3049, 291.4975, -80.02781>, <38.2105, 287.0658, -76.1191> }
					triangle { <39.3372, 290.8696, -80.9611>, <39.2433, 295.8022, -83.8047>, <40.7194, 294.9991, -83.8643> }
					triangle { <39.2433, 295.8022, -83.8047>, <38.4945, 298.3124, -82.9541>, <40.7194, 294.9991, -83.8643> }
					triangle { <41.6239, 295.548, -82.742>, <42.2004, 297.1483, -81.931>, <43.1622, 295.3851, -82.3661> }
					triangle { <43.1622, 295.3851, -82.3661>, <41.3049, 291.4975, -80.02781>, <41.6239, 295.548, -82.742> }
					triangle { <38.4945, 298.3124, -82.9541>, <39.08707, 298.254, -83.1113>, <40.9573, 296.7513, -83.06977> }
					triangle { <39.08707, 298.254, -83.1113>, <38.8784, 299.6302, -80.7899>, <41.7128, 298.3462, -81.8012> }
					triangle { <40.9573, 296.7513, -83.06977>, <41.7128, 298.3462, -81.8012>, <42.2004, 297.1483, -81.931> }
					triangle { <40.9573, 296.7513, -83.06977>, <39.08707, 298.254, -83.1113>, <41.7128, 298.3462, -81.8012> }
					triangle { <40.7194, 294.9991, -83.8643>, <38.4945, 298.3124, -82.9541>, <40.9573, 296.7513, -83.06977> }
					triangle { <41.6239, 295.548, -82.742>, <40.9573, 296.7513, -83.06977>, <42.2004, 297.1483, -81.931> }
					triangle { <40.7194, 294.9991, -83.8643>, <40.9573, 296.7513, -83.06977>, <41.6239, 295.548, -82.742> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <38.2105, 287.0658, -76.1191>, <41.975, 295.277, -83.02026>, <43.2779, 294.452, -82.9914> }
					triangle { <38.2105, 287.0658, -76.1191>, <39.4683, 291.734, -80.09514>, <41.975, 295.277, -83.02026> }
					triangle { <43.2779, 294.452, -82.9914>, <41.1573, 290.525, -81.00204>, <38.2105, 287.0658, -76.1191> }
					triangle { <39.4683, 291.734, -80.09514>, <42.07673, 296.4814, -81.8514>, <41.975, 295.277, -83.02026> }
					triangle { <42.07673, 296.4814, -81.8514>, <44.1882, 297.8492, -80.7308>, <41.975, 295.277, -83.02026> }
					triangle { <43.2779, 294.452, -82.9914>, <45.1534, 294.6167, -82.9114>, <43.9125, 293.332, -83.9278> }
					triangle { <43.9125, 293.332, -83.9278>, <41.1573, 290.525, -81.00204>, <43.2779, 294.452, -82.9914> }
					triangle { <44.1882, 297.8492, -80.7308>, <44.2976, 297.6056, -81.2857>, <43.8341, 295.717, -82.6915> }
					triangle { <44.2976, 297.6056, -81.2857>, <46.3843, 297.114, -79.6333>, <45.9841, 295.5058, -82.4545> }
					triangle { <43.8341, 295.717, -82.6915>, <45.9841, 295.5058, -82.4545>, <45.1534, 294.6167, -82.9114> }
					triangle { <43.8341, 295.717, -82.6915>, <44.2976, 297.6056, -81.2857>, <45.9841, 295.5058, -82.4545> }
					triangle { <41.975, 295.277, -83.02026>, <44.1882, 297.8492, -80.7308>, <43.8341, 295.717, -82.6915> }
					triangle { <43.2779, 294.452, -82.9914>, <43.8341, 295.717, -82.6915>, <45.1534, 294.6167, -82.9114> }
					triangle { <41.975, 295.277, -83.02026>, <43.8341, 295.717, -82.6915>, <43.2779, 294.452, -82.9914> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <38.2105, 287.0658, -76.1191>, <43.06852, 294.2795, -83.4391>, <42.9231, 293.0969, -84.4185> }
					triangle { <38.2105, 287.0658, -76.1191>, <40.6083, 291.6534, -79.6387>, <43.06852, 294.2795, -83.4391> }
					triangle { <42.9231, 293.0969, -84.4185>, <39.8748, 290.6157, -81.5155>, <38.2105, 287.0658, -76.1191> }
					triangle { <40.6083, 291.6534, -79.6387>, <44.6083, 294.232, -82.7655>, <43.06852, 294.2795, -83.4391> }
					triangle { <44.6083, 294.232, -82.7655>, <47.03111, 293.2774, -83.6621>, <43.06852, 294.2795, -83.4391> }
					triangle { <42.9231, 293.0969, -84.4185>, <43.8143, 292.181, -85.8035>, <41.8412, 292.6734, -85.5067> }
					triangle { <41.8412, 292.6734, -85.5067>, <39.8748, 290.6157, -81.5155>, <42.9231, 293.0969, -84.4185> }
					triangle { <47.03111, 293.2774, -83.6621>, <46.6235, 293.4154, -84.1027>, <44.2879, 293.3846, -84.6517> }
					triangle { <46.6235, 293.4154, -84.1027>, <47.792, 291.0334, -84.6384>, <45.05587, 292.0059, -86.1459> }
					triangle { <44.2879, 293.3846, -84.6517>, <45.05587, 292.0059, -86.1459>, <43.8143, 292.181, -85.8035> }
					triangle { <44.2879, 293.3846, -84.6517>, <46.6235, 293.4154, -84.1027>, <45.05587, 292.0059, -86.1459> }
					triangle { <43.06852, 294.2795, -83.4391>, <47.03111, 293.2774, -83.6621>, <44.2879, 293.3846, -84.6517> }
					triangle { <42.9231, 293.0969, -84.4185>, <44.2879, 293.3846, -84.6517>, <43.8143, 292.181, -85.8035> }
					triangle { <43.06852, 294.2795, -83.4391>, <44.2879, 293.3846, -84.6517>, <42.9231, 293.0969, -84.4185> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <38.2105, 287.0658, -76.1191>, <42.4726, 293.3701, -84.5637>, <41.012, 293.3656, -85.05927> }
					triangle { <38.2105, 287.0658, -76.1191>, <41.1896, 290.7203, -80.2365>, <42.4726, 293.3701, -84.5637> }
					triangle { <41.012, 293.3656, -85.05927>, <39.2209, 291.6655, -80.8429>, <38.2105, 287.0658, -76.1191> }
					triangle { <41.1896, 290.7203, -80.2365>, <43.3038, 292.1274, -85.3331>, <42.4726, 293.3701, -84.5637> }
					triangle { <43.3038, 292.1274, -85.3331>, <43.00161, 290.882, -87.7709>, <42.4726, 293.3701, -84.5637> }
					triangle { <41.012, 293.3656, -85.05927>, <39.9593, 293.2375, -86.617>, <39.7757, 294.3562, -84.9028> }
					triangle { <39.7757, 294.3562, -84.9028>, <39.2209, 291.6655, -80.8429>, <41.012, 293.3656, -85.05927> }
					triangle { <43.00161, 290.882, -87.7709>, <42.763, 291.4486, -87.7337>, <41.6355, 292.9772, -86.2675> }
					triangle { <42.763, 291.4486, -87.7337>, <41.01217, 289.7875, -88.9592>, <40.1126, 292.71, -87.7949> }
					triangle { <41.6355, 292.9772, -86.2675>, <40.1126, 292.71, -87.7949>, <39.9593, 293.2375, -86.617> }
					triangle { <41.6355, 292.9772, -86.2675>, <42.763, 291.4486, -87.7337>, <40.1126, 292.71, -87.7949> }
					triangle { <42.4726, 293.3701, -84.5637>, <43.00161, 290.882, -87.7709>, <41.6355, 292.9772, -86.2675> }
					triangle { <41.012, 293.3656, -85.05927>, <41.6355, 292.9772, -86.2675>, <39.9593, 293.2375, -86.617> }
					triangle { <42.4726, 293.3701, -84.5637>, <41.6355, 292.9772, -86.2675>, <41.012, 293.3656, -85.05927> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <36.7316, 250.3217, -54.4801>, <37.4458, 251.6329, -55.7082>, 0.2192 }
			cylinder { <37.4458, 251.6329, -55.7082>, <38.3317, 252.9002, -56.8687>, 0.2192 }
			cylinder { <38.3317, 252.9002, -56.8687>, <39.3809, 254.1115, -57.9503>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <39.3809, 254.1115, -57.9503>, <40.7682, 255.062, -58.9041>, 0.2192 }
			cylinder { <40.7682, 255.062, -58.9041>, <42.0572, 255.978, -60.01649>, 0.2192 }
			cylinder { <42.0572, 255.978, -60.01649>, <43.2354, 256.8506, -61.2766>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <43.2354, 256.8506, -61.2766>, <44.7713, 258.0609, -63.4182>, 0.2192 }
				cylinder { <44.7713, 258.0609, -63.4182>, <46.0527, 259.154, -65.7789>, 0.2192 }
				cylinder { <46.0527, 259.154, -65.7789>, <47.0603, 260.1137, -68.3233>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <47.0603, 260.1137, -68.3233>, <50.1525, 264.8655, -78.1762>, <51.4068, 265.2726, -77.3763> }
					triangle { <47.0603, 260.1137, -68.3233>, <48.2241, 262.1884, -74.1133>, <50.1525, 264.8655, -78.1762> }
					triangle { <51.4068, 265.2726, -77.3763>, <50.444, 262.2495, -73.6601>, <47.0603, 260.1137, -68.3233> }
					triangle { <48.2241, 262.1884, -74.1133>, <49.05252, 266.1364, -78.1324>, <50.1525, 264.8655, -78.1762> }
					triangle { <49.05252, 266.1364, -78.1324>, <49.3318, 268.8656, -77.8903>, <50.1525, 264.8655, -78.1762> }
					triangle { <51.4068, 265.2726, -77.3763>, <52.618, 266.6914, -77.1097>, <52.8602, 264.652, -77.1844> }
					triangle { <52.8602, 264.652, -77.1844>, <50.444, 262.2495, -73.6601>, <51.4068, 265.2726, -77.3763> }
					triangle { <49.3318, 268.8656, -77.8903>, <49.8265, 268.5688, -78.1056>, <51.09465, 266.5402, -77.9197> }
					triangle { <49.8265, 268.5688, -78.1056>, <50.5746, 270.3724, -76.2312>, <52.5701, 267.9838, -77.2398> }
					triangle { <51.09465, 266.5402, -77.9197>, <52.5701, 267.9838, -77.2398>, <52.618, 266.6914, -77.1097> }
					triangle { <51.09465, 266.5402, -77.9197>, <49.8265, 268.5688, -78.1056>, <52.5701, 267.9838, -77.2398> }
					triangle { <50.1525, 264.8655, -78.1762>, <49.3318, 268.8656, -77.8903>, <51.09465, 266.5402, -77.9197> }
					triangle { <51.4068, 265.2726, -77.3763>, <51.09465, 266.5402, -77.9197>, <52.618, 266.6914, -77.1097> }
					triangle { <50.1525, 264.8655, -78.1762>, <51.09465, 266.5402, -77.9197>, <51.4068, 265.2726, -77.3763> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <47.0603, 260.1137, -68.3233>, <51.5854, 264.8434, -77.6171>, <52.538, 263.6323, -77.547> }
					triangle { <47.0603, 260.1137, -68.3233>, <48.8059, 263.1067, -73.5365>, <51.5854, 264.8434, -77.6171> }
					triangle { <52.538, 263.6323, -77.547>, <49.7895, 261.2165, -74.309>, <47.0603, 260.1137, -68.3233> }
					triangle { <48.8059, 263.1067, -73.5365>, <52.3128, 266.144, -76.8384>, <51.5854, 264.8434, -77.6171> }
					triangle { <52.3128, 266.144, -76.8384>, <54.938, 266.8664, -76.4242>, <51.5854, 264.8434, -77.6171> }
					triangle { <52.538, 263.6323, -77.547>, <54.3403, 263.1296, -77.7711>, <52.5685, 262.1935, -78.2272> }
					triangle { <52.5685, 262.1935, -78.2272>, <49.7895, 261.2165, -74.309>, <52.538, 263.6323, -77.547> }
					triangle { <54.938, 266.8664, -76.4242>, <54.8409, 266.4918, -76.9033>, <53.5132, 264.6483, -77.6755> }
					triangle { <54.8409, 266.4918, -76.9033>, <56.9793, 265.6371, -75.4809>, <55.4863, 263.737, -77.6868> }
					triangle { <53.5132, 264.6483, -77.6755>, <55.4863, 263.737, -77.6868>, <54.3403, 263.1296, -77.7711> }
					triangle { <53.5132, 264.6483, -77.6755>, <54.8409, 266.4918, -76.9033>, <55.4863, 263.737, -77.6868> }
					triangle { <51.5854, 264.8434, -77.6171>, <54.938, 266.8664, -76.4242>, <53.5132, 264.6483, -77.6755> }
					triangle { <52.538, 263.6323, -77.547>, <53.5132, 264.6483, -77.6755>, <54.3403, 263.1296, -77.7711> }
					triangle { <51.5854, 264.8434, -77.6171>, <53.5132, 264.6483, -77.6755>, <52.538, 263.6323, -77.547> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <47.0603, 260.1137, -68.3233>, <52.1921, 263.4582, -77.8993>, <51.4728, 262.2318, -78.4971> }
					triangle { <47.0603, 260.1137, -68.3233>, <49.9346, 262.7198, -73.2355>, <52.1921, 263.4582, -77.8993> }
					triangle { <51.4728, 262.2318, -78.4971>, <48.5196, 261.6518, -74.6476>, <47.0603, 260.1137, -68.3233> }
					triangle { <49.9346, 262.7198, -73.2355>, <53.7485, 263.0033, -77.4545>, <52.1921, 263.4582, -77.8993> }
					triangle { <53.7485, 263.0033, -77.4545>, <55.4918, 261.0852, -78.3855>, <52.1921, 263.4582, -77.8993> }
					triangle { <51.4728, 262.2318, -78.4971>, <51.7054, 260.7957, -79.6949>, <50.1012, 262.0093, -79.2738> }
					triangle { <50.1012, 262.0093, -79.2738>, <48.5196, 261.6518, -74.6476>, <51.4728, 262.2318, -78.4971> }
					triangle { <55.4918, 261.0852, -78.3855>, <55.06142, 261.2663, -78.7869>, <52.7725, 261.9594, -78.983> }
					triangle { <55.06142, 261.2663, -78.7869>, <55.2792, 258.5685, -78.8204>, <52.7226, 260.123, -80.1444> }
					triangle { <52.7725, 261.9594, -78.983>, <52.7226, 260.123, -80.1444>, <51.7054, 260.7957, -79.6949> }
					triangle { <52.7725, 261.9594, -78.983>, <55.06142, 261.2663, -78.7869>, <52.7226, 260.123, -80.1444> }
					triangle { <52.1921, 263.4582, -77.8993>, <55.4918, 261.0852, -78.3855>, <52.7725, 261.9594, -78.983> }
					triangle { <51.4728, 262.2318, -78.4971>, <52.7725, 261.9594, -78.983>, <51.7054, 260.7957, -79.6949> }
					triangle { <52.1921, 263.4582, -77.8993>, <52.7725, 261.9594, -78.983>, <51.4728, 262.2318, -78.4971> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <47.0603, 260.1137, -68.3233>, <51.1398, 262.6114, -78.6354>, <49.6733, 262.9933, -78.9224> }
					triangle { <47.0603, 260.1137, -68.3233>, <50.06099, 261.5588, -73.6234>, <51.1398, 262.6114, -78.6354> }
					triangle { <49.6733, 262.9933, -78.9224>, <48.3775, 262.9579, -74.2113>, <47.0603, 260.1137, -68.3233> }
					triangle { <50.06099, 261.5588, -73.6234>, <51.3888, 261.0254, -79.135>, <51.1398, 262.6114, -78.6354> }
					triangle { <51.3888, 261.0254, -79.135>, <50.233, 259.4574, -81.08208>, <51.1398, 262.6114, -78.6354> }
					triangle { <49.6733, 262.9933, -78.9224>, <48.3301, 262.8933, -80.2403>, <48.8449, 264.3523, -78.8876> }
					triangle { <48.8449, 264.3523, -78.8876>, <48.3775, 262.9579, -74.2113>, <49.6733, 262.9933, -78.9224> }
					triangle { <50.233, 259.4574, -81.08208>, <50.1853, 260.0649, -81.1711>, <49.8892, 262.1643, -80.04758> }
					triangle { <50.1853, 260.0649, -81.1711>, <47.8079, 258.8693, -81.6657>, <48.07277, 262.1024, -81.2392> }
					triangle { <49.8892, 262.1643, -80.04758>, <48.07277, 262.1024, -81.2392>, <48.3301, 262.8933, -80.2403> }
					triangle { <49.8892, 262.1643, -80.04758>, <50.1853, 260.0649, -81.1711>, <48.07277, 262.1024, -81.2392> }
					triangle { <51.1398, 262.6114, -78.6354>, <50.233, 259.4574, -81.08208>, <49.8892, 262.1643, -80.04758> }
					triangle { <49.6733, 262.9933, -78.9224>, <49.8892, 262.1643, -80.04758>, <48.3301, 262.8933, -80.2403> }
					triangle { <51.1398, 262.6114, -78.6354>, <49.8892, 262.1643, -80.04758>, <49.6733, 262.9933, -78.9224> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <47.0603, 260.1137, -68.3233>, <49.8602, 263.4943, -78.8091>, <49.6319, 264.901, -78.2193> }
					triangle { <47.0603, 260.1137, -68.3233>, <48.9878, 261.2254, -74.1741>, <49.8602, 263.4943, -78.8091> }
					triangle { <49.6319, 264.901, -78.2193>, <49.5848, 263.3329, -73.5917>, <47.0603, 260.1137, -68.3233> }
					triangle { <48.9878, 261.2254, -74.1741>, <48.4427, 262.991, -79.5603>, <49.8602, 263.4943, -78.8091> }
					triangle { <48.4427, 262.991, -79.5603>, <46.3684, 264.3385, -80.7714>, <49.8602, 263.4943, -78.8091> }
					triangle { <49.6319, 264.901, -78.2193>, <48.9026, 266.5921, -78.6185>, <50.5758, 266.0102, -77.5768> }
					triangle { <50.5758, 266.0102, -77.5768>, <49.5848, 263.3329, -73.5917>, <49.6319, 264.901, -78.2193> }
					triangle { <46.3684, 264.3385, -80.7714>, <46.9012, 264.6462, -80.7437>, <48.8365, 265.0382, -79.3804> }
					triangle { <46.9012, 264.6462, -80.7437>, <44.8564, 266.2747, -80.04136>, <47.977, 267.034, -79.4169> }
					triangle { <48.8365, 265.0382, -79.3804>, <47.977, 267.034, -79.4169>, <48.9026, 266.5921, -78.6185> }
					triangle { <48.8365, 265.0382, -79.3804>, <46.9012, 264.6462, -80.7437>, <47.977, 267.034, -79.4169> }
					triangle { <49.8602, 263.4943, -78.8091>, <46.3684, 264.3385, -80.7714>, <48.8365, 265.0382, -79.3804> }
					triangle { <49.6319, 264.901, -78.2193>, <48.8365, 265.0382, -79.3804>, <48.9026, 266.5921, -78.6185> }
					triangle { <49.8602, 263.4943, -78.8091>, <48.8365, 265.0382, -79.3804>, <49.6319, 264.901, -78.2193> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <39.3809, 254.1115, -57.9503>, <40.03605, 255.5192, -59.1023>, 0.2192 }
			cylinder { <40.03605, 255.5192, -59.1023>, <40.8044, 256.9785, -60.111>, 0.2192 }
			cylinder { <40.8044, 256.9785, -60.111>, <41.6786, 258.4755, -60.9669>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <41.6786, 258.4755, -60.9669>, <43.1705, 260.7611, -61.9469>, 0.2192 }
				cylinder { <43.1705, 260.7611, -61.9469>, <44.8205, 263.0524, -62.6083>, 0.2192 }
				cylinder { <44.8205, 263.0524, -62.6083>, <46.6038, 265.3149, -62.9413>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <46.6038, 265.3149, -62.9413>, <54.5463, 273.3034, -64.4649>, <53.8218, 273.5081, -65.8111> }
					triangle { <46.6038, 265.3149, -62.9413>, <51.05183, 269.7194, -62.9369>, <54.5463, 273.3034, -64.4649> }
					triangle { <53.8218, 273.5081, -65.8111>, <49.9056, 270.898, -64.4971>, <46.6038, 265.3149, -62.9413> }
					triangle { <51.05183, 269.7194, -62.9369>, <55.8361, 272.2516, -64.7043>, <54.5463, 273.3034, -64.4649> }
					triangle { <55.8361, 272.2516, -64.7043>, <57.4301, 271.6852, -66.8777>, <54.5463, 273.3034, -64.4649> }
					triangle { <53.8218, 273.5081, -65.8111>, <54.1269, 273.8398, -67.6408>, <52.686, 274.4952, -66.3303> }
					triangle { <52.686, 274.4952, -66.3303>, <49.9056, 270.898, -64.4971>, <53.8218, 273.5081, -65.8111> }
					triangle { <57.4301, 271.6852, -66.8777>, <57.1556, 272.2364, -66.8895>, <55.1421, 273.4043, -66.3069> }
					triangle { <57.1556, 272.2364, -66.8895>, <56.9364, 271.0433, -69.3092>, <55.1043, 273.6207, -68.4691> }
					triangle { <55.1421, 273.4043, -66.3069>, <55.1043, 273.6207, -68.4691>, <54.1269, 273.8398, -67.6408> }
					triangle { <55.1421, 273.4043, -66.3069>, <57.1556, 272.2364, -66.8895>, <55.1043, 273.6207, -68.4691> }
					triangle { <54.5463, 273.3034, -64.4649>, <57.4301, 271.6852, -66.8777>, <55.1421, 273.4043, -66.3069> }
					triangle { <53.8218, 273.5081, -65.8111>, <55.1421, 273.4043, -66.3069>, <54.1269, 273.8398, -67.6408> }
					triangle { <54.5463, 273.3034, -64.4649>, <55.1421, 273.4043, -66.3069>, <53.8218, 273.5081, -65.8111> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <46.6038, 265.3149, -62.9413>, <53.6028, 273.8906, -65.5285>, <52.3452, 274.7495, -65.2842> }
					triangle { <46.6038, 265.3149, -62.9413>, <51.08688, 269.5133, -64.1496>, <53.6028, 273.8906, -65.5285> }
					triangle { <52.3452, 274.7495, -65.2842>, <49.8662, 271.1299, -63.1328>, <46.6038, 265.3149, -62.9413> }
					triangle { <51.08688, 269.5133, -64.1496>, <53.7154, 273.5598, -67.1732>, <53.6028, 273.8906, -65.5285> }
					triangle { <53.7154, 273.5598, -67.1732>, <52.876, 274.8992, -69.4286>, <53.6028, 273.8906, -65.5285> }
					triangle { <52.3452, 274.7495, -65.2842>, <51.3986, 276.2401, -65.9423>, <51.7673, 275.5564, -64.03967> }
					triangle { <51.7673, 275.5564, -64.03967>, <49.8662, 271.1299, -63.1328>, <52.3452, 274.7495, -65.2842> }
					triangle { <52.876, 274.8992, -69.4286>, <52.9521, 275.2495, -68.9278>, <52.7132, 275.2843, -66.5405> }
					triangle { <52.9521, 275.2495, -68.9278>, <50.6283, 275.8901, -70.159>, <51.2894, 276.8297, -67.0955> }
					triangle { <52.7132, 275.2843, -66.5405>, <51.2894, 276.8297, -67.0955>, <51.3986, 276.2401, -65.9423> }
					triangle { <52.7132, 275.2843, -66.5405>, <52.9521, 275.2495, -68.9278>, <51.2894, 276.8297, -67.0955> }
					triangle { <53.6028, 273.8906, -65.5285>, <52.876, 274.8992, -69.4286>, <52.7132, 275.2843, -66.5405> }
					triangle { <52.3452, 274.7495, -65.2842>, <52.7132, 275.2843, -66.5405>, <51.3986, 276.2401, -65.9423> }
					triangle { <53.6028, 273.8906, -65.5285>, <52.7132, 275.2843, -66.5405>, <52.3452, 274.7495, -65.2842> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <46.6038, 265.3149, -62.9413>, <52.5829, 274.7986, -64.8204>, <52.4076, 274.9922, -63.3002> }
					triangle { <46.6038, 265.3149, -62.9413>, <50.177, 270.1529, -64.6763>, <52.5829, 274.7986, -64.8204> }
					triangle { <52.4076, 274.9922, -63.3002>, <50.8898, 270.4103, -62.5402>, <46.6038, 265.3149, -62.9413> }
					triangle { <50.177, 270.1529, -64.6763>, <51.3638, 275.6429, -65.6128>, <52.5829, 274.7986, -64.8204> }
					triangle { <51.3638, 275.6429, -65.6128>, <49.9082, 277.8933, -64.9785>, <52.5829, 274.7986, -64.8204> }
					triangle { <52.4076, 274.9922, -63.3002>, <52.06285, 276.2987, -61.9868>, <53.2918, 274.6519, -62.02097> }
					triangle { <53.2918, 274.6519, -62.02097>, <50.8898, 270.4103, -62.5402>, <52.4076, 274.9922, -63.3002> }
					triangle { <49.9082, 277.8933, -64.9785>, <50.452, 277.8431, -64.6939>, <51.9832, 276.2752, -63.7167> }
					triangle { <50.452, 277.8431, -64.6939>, <48.5484, 278.5945, -62.9225>, <51.4601, 277.4501, -61.9647> }
					triangle { <51.9832, 276.2752, -63.7167>, <51.4601, 277.4501, -61.9647>, <52.06285, 276.2987, -61.9868> }
					triangle { <51.9832, 276.2752, -63.7167>, <50.452, 277.8431, -64.6939>, <51.4601, 277.4501, -61.9647> }
					triangle { <52.5829, 274.7986, -64.8204>, <49.9082, 277.8933, -64.9785>, <51.9832, 276.2752, -63.7167> }
					triangle { <52.4076, 274.9922, -63.3002>, <51.9832, 276.2752, -63.7167>, <52.06285, 276.2987, -61.9868> }
					triangle { <52.5829, 274.7986, -64.8204>, <51.9832, 276.2752, -63.7167>, <52.4076, 274.9922, -63.3002> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <46.6038, 265.3149, -62.9413>, <52.8866, 274.7812, -63.3125>, <53.9234, 273.9031, -62.5824> }
					triangle { <46.6038, 265.3149, -62.9413>, <49.5711, 270.7603, -63.794>, <52.8866, 274.7812, -63.3125> }
					triangle { <53.9234, 273.9031, -62.5824>, <51.5714, 269.727, -63.5328>, <46.6038, 265.3149, -62.9413> }
					triangle { <49.5711, 270.7603, -63.794>, <52.00924, 275.6416, -62.1649>, <52.8866, 274.7812, -63.3125> }
					triangle { <52.00924, 275.6416, -62.1649>, <52.6003, 276.5577, -59.6358>, <52.8866, 274.7812, -63.3125> }
					triangle { <53.9234, 273.9031, -62.5824>, <55.2078, 273.9352, -61.2038>, <55.1668, 273.0233, -63.04516> }
					triangle { <55.1668, 273.0233, -63.04516>, <51.5714, 269.727, -63.5328>, <53.9234, 273.9031, -62.5824> }
					triangle { <52.6003, 276.5577, -59.6358>, <53.08708, 276.4571, -59.9994>, <53.9541, 275.0168, -61.7116> }
					triangle { <53.08708, 276.4571, -59.9994>, <53.5516, 275.4442, -57.5327>, <55.3822, 274.6304, -60.1195> }
					triangle { <53.9541, 275.0168, -61.7116>, <55.3822, 274.6304, -60.1195>, <55.2078, 273.9352, -61.2038> }
					triangle { <53.9541, 275.0168, -61.7116>, <53.08708, 276.4571, -59.9994>, <55.3822, 274.6304, -60.1195> }
					triangle { <52.8866, 274.7812, -63.3125>, <52.6003, 276.5577, -59.6358>, <53.9541, 275.0168, -61.7116> }
					triangle { <53.9234, 273.9031, -62.5824>, <53.9541, 275.0168, -61.7116>, <55.2078, 273.9352, -61.2038> }
					triangle { <52.8866, 274.7812, -63.3125>, <53.9541, 275.0168, -61.7116>, <53.9234, 273.9031, -62.5824> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <46.6038, 265.3149, -62.9413>, <54.1184, 273.8431, -63.08952>, <54.8106, 272.972, -64.1576> }
					triangle { <46.6038, 265.3149, -62.9413>, <50.1199, 270.4883, -62.7028>, <54.1184, 273.8431, -63.08952> }
					triangle { <54.8106, 272.972, -64.1576>, <50.954, 270.033, -64.7605>, <46.6038, 265.3149, -62.9413> }
					triangle { <50.1199, 270.4883, -62.7028>, <54.815, 273.514, -61.595>, <54.1184, 273.8431, -63.08952> }
					triangle { <54.815, 273.514, -61.595>, <57.3192, 272.663, -60.8272>, <54.1184, 273.8431, -63.08952> }
					triangle { <54.8106, 272.972, -64.1576>, <56.5027, 272.3925, -64.751>, <54.7868, 272.925, -65.7486> }
					triangle { <54.7868, 272.925, -65.7486>, <50.954, 270.033, -64.7605>, <54.8106, 272.972, -64.1576> }
					triangle { <57.3192, 272.663, -60.8272>, <57.2926, 272.9396, -61.3768>, <55.9359, 273.2157, -63.3366> }
					triangle { <57.2926, 272.9396, -61.3768>, <58.814, 270.7068, -61.5395>, <57.6685, 272.2279, -64.2002> }
					triangle { <55.9359, 273.2157, -63.3366>, <57.6685, 272.2279, -64.2002>, <56.5027, 272.3925, -64.751> }
					triangle { <55.9359, 273.2157, -63.3366>, <57.2926, 272.9396, -61.3768>, <57.6685, 272.2279, -64.2002> }
					triangle { <54.1184, 273.8431, -63.08952>, <57.3192, 272.663, -60.8272>, <55.9359, 273.2157, -63.3366> }
					triangle { <54.8106, 272.972, -64.1576>, <55.9359, 273.2157, -63.3366>, <56.5027, 272.3925, -64.751> }
					triangle { <54.1184, 273.8431, -63.08952>, <55.9359, 273.2157, -63.3366>, <54.8106, 272.972, -64.1576> }
					material { txgilia_flower }}
				}
			}
		}
	union { // internode
		cylinder { <24.6443, 213.038, -26.7899>, <24.3398, 228.9762, -31.1677>, 0.5 }
		cylinder { <24.3398, 228.9762, -31.1677>, <20.5974, 244.9214, -33.4098>, 0.5 }
		cylinder { <20.5974, 244.9214, -33.4098>, <13.6416, 259.918, -33.3819>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <13.6416, 259.918, -33.3819>, <8.6409, 265.6027, -31.9013>, 0.4999 }
			cylinder { <8.6409, 265.6027, -31.9013>, <2.4703, 269.3091, -29.1264>, 0.4999 }
			cylinder { <2.4703, 269.3091, -29.1264>, <-4.1488, 270.6039, -25.3814>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-4.1488, 270.6039, -25.3814>, <-6.9298, 271.0714, -23.7861>, 0.4999 }
				cylinder { <-6.9298, 271.0714, -23.7861>, <-9.7103, 271.4624, -22.1691>, 0.4999 }
				cylinder { <-9.7103, 271.4624, -22.1691>, <-12.4885, 271.7766, -20.5317>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <-12.4885, 271.7766, -20.5317>, <-13.08299, 271.7954, -20.3669>, 0.03999 }
				cylinder { <-13.08299, 271.7954, -20.3669>, <-13.6996, 271.7717, -20.3611>, 0.03999 }
				cylinder { <-13.6996, 271.7717, -20.3611>, <-14.2939, 271.7073, -20.5149>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-14.2939, 271.7073, -20.5149>, <-42.04131, 268.8244, -25.7585>, <-41.7934, 266.9475, -27.2256> }
				triangle { <-42.04131, 268.8244, -25.7585>, <-48.9378, 260.7719, -20.2464>, <-41.7934, 266.9475, -27.2256> }
				triangle { <-42.04131, 268.8244, -25.7585>, <-48.1297, 263.8541, -19.9998>, <-48.9378, 260.7719, -20.2464> }
				triangle { <-48.9378, 260.7719, -20.2464>, <-46.9992, 260.6302, -23.4093>, <-41.7934, 266.9475, -27.2256> }
				triangle { <-41.7934, 266.9475, -27.2256>, <-30.7921, 267.0024, -24.2453>, <-14.2939, 271.7073, -20.5149> }
				triangle { <-14.2939, 271.7073, -20.5149>, <-31.7693, 269.9777, -21.35>, <-42.04131, 268.8244, -25.7585> }
				triangle { <-31.7693, 269.9777, -21.35>, <-42.5318, 268.7487, -21.7868>, <-42.04131, 268.8244, -25.7585> }
				triangle { <-42.5318, 268.7487, -21.7868>, <-48.1297, 263.8541, -19.9998>, <-42.04131, 268.8244, -25.7585> }
				triangle { <-41.7934, 266.9475, -27.2256>, <-46.9992, 260.6302, -23.4093>, <-41.8856, 263.1603, -25.8296> }
				triangle { <-41.8856, 263.1603, -25.8296>, <-30.7921, 267.0024, -24.2453>, <-41.7934, 266.9475, -27.2256> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <-12.4885, 271.7766, -20.5317>, <-13.0177, 271.8365, -20.2198>, 0.03999 }
				cylinder { <-13.0177, 271.8365, -20.2198>, <-13.5468, 271.8963, -19.9079>, 0.03999 }
				cylinder { <-13.5468, 271.8963, -19.9079>, <-14.07605, 271.9561, -19.5959>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <-14.07605, 271.9561, -19.5959>, <-37.4032, 274.7821, -3.6717>, <-38.585, 272.9642, -4.6893> }
				triangle { <-37.4032, 274.7821, -3.6717>, <-39.6625, 267.9756, 5.8862>, <-38.585, 272.9642, -4.6893> }
				triangle { <-37.4032, 274.7821, -3.6717>, <-38.4044, 270.8263, 5.1761>, <-39.6625, 267.9756, 5.8862> }
				triangle { <-39.6625, 267.9756, 5.8862>, <-40.5735, 267.6086, 2.306>, <-38.585, 272.9642, -4.6893> }
				triangle { <-38.585, 272.9642, -4.6893>, <-28.8883, 270.7353, -10.25>, <-14.07605, 271.9561, -19.5959> }
				triangle { <-14.07605, 271.9561, -19.5959>, <-27.01768, 273.7038, -7.8256>, <-37.4032, 274.7821, -3.6717> }
				triangle { <-27.01768, 273.7038, -7.8256>, <-34.9614, 274.6159, -0.5046>, <-37.4032, 274.7821, -3.6717> }
				triangle { <-34.9614, 274.6159, -0.5046>, <-38.4044, 270.8263, 5.1761>, <-37.4032, 274.7821, -3.6717> }
				triangle { <-38.585, 272.9642, -4.6893>, <-40.5735, 267.6086, 2.306>, <-38.3145, 269.2059, -3.2395> }
				triangle { <-38.3145, 269.2059, -3.2395>, <-28.8883, 270.7353, -10.25>, <-38.585, 272.9642, -4.6893> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <13.6416, 259.918, -33.3819>, <10.5048, 276.1388, -32.8104>, 0.5 }
		cylinder { <10.5048, 276.1388, -32.8104>, <11.3752, 292.6117, -31.7296>, 0.5 }
		cylinder { <11.3752, 292.6117, -31.7296>, <16.2005, 308.3493, -30.2043>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <16.2005, 308.3493, -30.2043>, <20.786, 314.4833, -29.276>, 0.4999 }
			cylinder { <20.786, 314.4833, -29.276>, <27.1692, 318.6898, -28.2399>, 0.4999 }
			cylinder { <27.1692, 318.6898, -28.2399>, <34.6038, 320.4773, -27.217>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <34.6038, 320.4773, -27.217>, <37.7443, 321.1505, -26.7897>, 0.4999 }
				cylinder { <37.7443, 321.1505, -26.7897>, <40.9008, 321.746, -26.3651>, 0.4999 }
				cylinder { <40.9008, 321.746, -26.3651>, <44.07146, 322.2632, -25.9434>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <44.07146, 322.2632, -25.9434>, <44.6333, 322.3485, -25.7028>, 0.03999 }
				cylinder { <44.6333, 322.3485, -25.7028>, <45.1126, 322.4145, -25.3196>, 0.03999 }
				cylinder { <45.1126, 322.4145, -25.3196>, <45.4744, 322.4562, -24.8213>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <45.4744, 322.4562, -24.8213>, <63.5973, 324.2973, -3.05227>, <62.54, 322.5938, -1.7419> }
				triangle { <63.5973, 324.2973, -3.05227>, <72.7125, 316.734, -1.4718>, <62.54, 322.5938, -1.7419> }
				triangle { <63.5973, 324.2973, -3.05227>, <72.1352, 319.6136, -2.7324>, <72.7125, 316.734, -1.4718> }
				triangle { <72.7125, 316.734, -1.4718>, <69.2097, 316.6913, -0.2426>, <62.54, 322.5938, -1.7419> }
				triangle { <62.54, 322.5938, -1.7419>, <55.9687, 320.6873, -10.8577>, <45.4744, 322.4562, -24.8213> }
				triangle { <45.4744, 322.4562, -24.8213>, <58.4575, 323.4046, -13.0053>, <63.5973, 324.2973, -3.05227> }
				triangle { <58.4575, 323.4046, -13.0053>, <66.5087, 323.8185, -5.7569>, <63.5973, 324.2973, -3.05227> }
				triangle { <66.5087, 323.8185, -5.7569>, <72.1352, 319.6136, -2.7324>, <63.5973, 324.2973, -3.05227> }
				triangle { <62.54, 322.5938, -1.7419>, <69.2097, 316.6913, -0.2426>, <63.6387, 318.7208, -2.0463> }
				triangle { <63.6387, 318.7208, -2.0463>, <55.9687, 320.6873, -10.8577>, <62.54, 322.5938, -1.7419> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <44.07146, 322.2632, -25.9434>, <44.6753, 322.3617, -25.863>, 0.03999 }
				cylinder { <44.6753, 322.3617, -25.863>, <45.2793, 322.4602, -25.7827>, 0.03999 }
				cylinder { <45.2793, 322.4602, -25.7827>, <45.8832, 322.5587, -25.7023>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <45.8832, 322.5587, -25.7023>, <73.8849, 326.8253, -23.8514>, <74.2124, 325.3343, -22.00584> }
				triangle { <73.8849, 326.8253, -23.8514>, <81.9633, 319.325, -28.4635>, <74.2124, 325.3343, -22.00584> }
				triangle { <73.8849, 326.8253, -23.8514>, <80.4383, 322.0262, -29.2326>, <81.9633, 319.325, -28.4635> }
				triangle { <81.9633, 319.325, -28.4635>, <80.3964, 319.5263, -25.104>, <74.2124, 325.3343, -22.00584> }
				triangle { <74.2124, 325.3343, -22.00584>, <63.2858, 322.3985, -23.386>, <45.8832, 322.5587, -25.7023> }
				triangle { <45.8832, 322.5587, -25.7023>, <63.2825, 324.7506, -26.9437>, <73.8849, 326.8253, -23.8514> }
				triangle { <63.2825, 324.7506, -26.9437>, <74.02966, 325.9268, -27.7492>, <73.8849, 326.8253, -23.8514> }
				triangle { <74.02966, 325.9268, -27.7492>, <80.4383, 322.0262, -29.2326>, <73.8849, 326.8253, -23.8514> }
				triangle { <74.2124, 325.3343, -22.00584>, <80.3964, 319.5263, -25.104>, <75.06528, 321.4303, -22.5818> }
				triangle { <75.06528, 321.4303, -22.5818>, <63.2858, 322.3985, -23.386>, <74.2124, 325.3343, -22.00584> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <16.2005, 308.3493, -30.2043>, <19.7333, 324.4987, -30.1857>, 0.5 }
		cylinder { <19.7333, 324.4987, -30.1857>, <21.9204, 340.8169, -31.6742>, 0.5 }
		cylinder { <21.9204, 340.8169, -31.6742>, <22.7291, 357.0584, -34.6474>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <22.7291, 357.0584, -34.6474>, <21.4323, 364.014, -37.7119>, 0.4997 }
			cylinder { <21.4323, 364.014, -37.7119>, <18.5924, 369.6475, -42.1448>, 0.4997 }
			cylinder { <18.5924, 369.6475, -42.1448>, <14.4962, 373.3903, -47.4987>, 0.4997 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <14.4962, 373.3903, -47.4987>, <12.7089, 374.8238, -49.7874>, 0.4997 }
				cylinder { <12.7089, 374.8238, -49.7874>, <10.859, 376.1153, -52.1106>, 0.4997 }
				cylinder { <10.859, 376.1153, -52.1106>, <8.951, 377.2617, -54.4628>, 0.4997 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <8.951, 377.2617, -54.4628>, <8.7076, 377.4497, -54.9971>, 0.03995 }
				cylinder { <8.7076, 377.4497, -54.9971>, <8.5987, 377.5962, -55.586>, 0.03995 }
				cylinder { <8.5987, 377.5962, -55.586>, <8.6308, 377.6923, -56.1941>, 0.03995 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <8.6308, 377.6923, -56.1941>, <7.8759, 380.4158, -84.4235>, <9.2228, 378.4869, -84.866> }
				triangle { <7.8759, 380.4158, -84.4235>, <0.5092, 374.1198, -91.4044>, <9.2228, 378.4869, -84.866> }
				triangle { <7.8759, 380.4158, -84.4235>, <0.6557, 376.9748, -89.9792>, <0.5092, 374.1198, -91.4044> }
				triangle { <0.5092, 374.1198, -91.4044>, <3.9809, 373.4907, -90.2557>, <9.2228, 378.4869, -84.866> }
				triangle { <9.2228, 378.4869, -84.866>, <8.5641, 376.3696, -73.6918>, <8.6308, 377.6923, -56.1941> }
				triangle { <8.6308, 377.6923, -56.1941>, <5.754, 379.564, -73.4272>, <7.8759, 380.4158, -84.4235> }
				triangle { <5.754, 379.564, -73.4272>, <3.8949, 380.5589, -84.05572>, <7.8759, 380.4158, -84.4235> }
				triangle { <3.8949, 380.5589, -84.05572>, <0.6557, 376.9748, -89.9792>, <7.8759, 380.4158, -84.4235> }
				triangle { <9.2228, 378.4869, -84.866>, <3.9809, 373.4907, -90.2557>, <7.5687, 374.8438, -85.3911> }
				triangle { <7.5687, 374.8438, -85.3911>, <8.5641, 376.3696, -73.6918>, <9.2228, 378.4869, -84.866> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <8.951, 377.2617, -54.4628>, <8.5877, 377.48, -54.9105>, 0.03995 }
				cylinder { <8.5877, 377.48, -54.9105>, <8.2245, 377.6982, -55.3583>, 0.03995 }
				cylinder { <8.2245, 377.6982, -55.3583>, <7.8613, 377.9165, -55.8061>, 0.03995 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <7.8613, 377.9165, -55.8061>, <-10.69, 385.9406, -75.7146>, <-9.8785, 384.4354, -77.3898> }
				triangle { <-10.69, 385.9406, -75.7146>, <-20.643, 379.8327, -78.2184>, <-9.8785, 384.4354, -77.3898> }
				triangle { <-10.69, 385.9406, -75.7146>, <-19.7017, 382.3245, -76.4554>, <-20.643, 379.8327, -78.2184> }
				triangle { <-20.643, 379.8327, -78.2184>, <-17.2149, 379.6762, -79.6294>, <-9.8785, 384.4354, -77.3898> }
				triangle { <-9.8785, 384.4354, -77.3898>, <-3.2478, 380.0745, -69.2169>, <7.8613, 377.9165, -55.8061> }
				triangle { <7.8613, 377.9165, -55.8061>, <-5.3365, 382.5468, -66.4427>, <-10.69, 385.9406, -75.7146> }
				triangle { <-5.3365, 382.5468, -66.4427>, <-13.5376, 385.2326, -72.9954>, <-10.69, 385.9406, -75.7146> }
				triangle { <-13.5376, 385.2326, -72.9954>, <-19.7017, 382.3245, -76.4554>, <-10.69, 385.9406, -75.7146> }
				triangle { <-9.8785, 384.4354, -77.3898>, <-17.2149, 379.6762, -79.6294>, <-11.3936, 380.7164, -77.7859> }
				triangle { <-11.3936, 380.7164, -77.7859>, <-3.2478, 380.0745, -69.2169>, <-9.8785, 384.4354, -77.3898> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <22.7291, 357.0584, -34.6474>, <23.5687, 373.5404, -35.6076>, 0.5 }
		cylinder { <23.5687, 373.5404, -35.6076>, <24.4268, 390.0149, -34.5406>, 0.5 }
		cylinder { <24.4268, 390.0149, -34.5406>, <25.2904, 406.234, -31.4623>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <25.2904, 406.234, -31.4623>, <25.5833, 411.3786, -28.4369>, 0.3872 }
			cylinder { <25.5833, 411.3786, -28.4369>, <25.8227, 415.2037, -23.8524>, 0.3872 }
			cylinder { <25.8227, 415.2037, -23.8524>, <25.9807, 417.2621, -18.245>, 0.3872 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <25.9807, 417.2621, -18.245>, <25.9827, 418.0716, -15.8694>, 0.3872 }
				cylinder { <25.9827, 418.0716, -15.8694>, <25.9205, 418.8249, -13.4763>, 0.3872 }
				cylinder { <25.9205, 418.8249, -13.4763>, <25.7941, 419.5213, -11.0685>, 0.3872 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <25.7941, 419.5213, -11.0685>, <25.6775, 419.623, -10.732>, 0.02399 }
				cylinder { <25.6775, 419.623, -10.732>, <25.4716, 419.7164, -10.4388>, 0.02399 }
				cylinder { <25.4716, 419.7164, -10.4388>, <25.1912, 419.7946, -10.2101>, 0.02399 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <25.1912, 419.7946, -10.2101>, <9.4911, 424.4166, 4.4711>, <8.3064, 423.1237, 3.8657> }
				triangle { <9.4911, 424.4166, 4.4711>, <8.1924, 419.5138, 12.2134>, <8.3064, 423.1237, 3.8657> }
				triangle { <9.4911, 424.4166, 4.4711>, <9.3406, 421.5737, 11.4605>, <8.1924, 419.5138, 12.2134> }
				triangle { <8.1924, 419.5138, 12.2134>, <7.0657, 419.2806, 9.5781>, <8.3064, 423.1237, 3.8657> }
				triangle { <8.3064, 423.1237, 3.8657>, <14.8506, 420.4042, -1.3992>, <25.1912, 419.7946, -10.2101> }
				triangle { <25.1912, 419.7946, -10.2101>, <16.8252, 422.5298, 0.1804>, <9.4911, 424.4166, 4.4711> }
				triangle { <16.8252, 422.5298, 0.1804>, <11.6856, 424.0864, 6.636>, <9.4911, 424.4166, 4.4711> }
				triangle { <11.6856, 424.0864, 6.636>, <9.3406, 421.5737, 11.4605>, <9.4911, 424.4166, 4.4711> }
				triangle { <8.3064, 423.1237, 3.8657>, <7.0657, 419.2806, 9.5781>, <8.3173, 420.2259, 5.04128> }
				triangle { <8.3173, 420.2259, 5.04128>, <14.8506, 420.4042, -1.3992>, <8.3064, 423.1237, 3.8657> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <25.7941, 419.5213, -11.0685>, <25.7845, 419.6237, -10.7128>, 0.02399 }
				cylinder { <25.7845, 419.6237, -10.7128>, <25.784, 419.7258, -10.3569>, 0.02399 }
				cylinder { <25.784, 419.7258, -10.3569>, <25.7925, 419.8275, -10.00099>, 0.02399 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <25.7925, 419.8275, -10.00099>, <27.7109, 425.5117, 11.151>, <26.2167, 424.5686, 11.7165> }
				triangle { <27.7109, 425.5117, 11.151>, <31.4813, 419.9973, 17.5573>, <26.2167, 424.5686, 11.7165> }
				triangle { <27.7109, 425.5117, 11.151>, <32.1249, 421.8695, 16.07117>, <31.4813, 419.9973, 17.5573> }
				triangle { <31.4813, 419.9973, 17.5573>, <28.7678, 420.3365, 16.6685>, <26.2167, 424.5686, 11.7165> }
				triangle { <26.2167, 424.5686, 11.7165>, <25.8669, 421.3177, 3.5158>, <25.7925, 419.8275, -10.00099> }
				triangle { <25.7925, 419.8275, -10.00099>, <28.7717, 422.7867, 2.9528>, <27.7109, 425.5117, 11.151> }
				triangle { <28.7717, 422.7867, 2.9528>, <30.6269, 424.4751, 10.9666>, <27.7109, 425.5117, 11.151> }
				triangle { <30.6269, 424.4751, 10.9666>, <32.1249, 421.8695, 16.07117>, <27.7109, 425.5117, 11.151> }
				triangle { <26.2167, 424.5686, 11.7165>, <28.7678, 420.3365, 16.6685>, <26.4301, 421.5979, 12.6701> }
				triangle { <26.4301, 421.5979, 12.6701>, <25.8669, 421.3177, 3.5158>, <26.2167, 424.5686, 11.7165> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <25.2904, 406.234, -31.4623>, <27.497, 422.4794, -29.8987>, 0.4981 }
		cylinder { <27.497, 422.4794, -29.8987>, <31.01668, 438.5678, -29.8618>, 0.4981 }
		cylinder { <31.01668, 438.5678, -29.8618>, <35.7964, 454.2573, -31.3521>, 0.4981 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <35.7964, 454.2573, -31.3521>, <37.3467, 456.8872, -32.4505>, 0.2102 }
			cylinder { <37.3467, 456.8872, -32.4505>, <39.3245, 458.7487, -34.2252>, 0.2102 }
			cylinder { <39.3245, 458.7487, -34.2252>, <41.4984, 459.6241, -36.4689>, 0.2102 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <41.4984, 459.6241, -36.4689>, <42.4359, 459.9862, -37.3891>, 0.2102 }
				cylinder { <42.4359, 459.9862, -37.3891>, <43.3973, 460.3425, -38.2866>, 0.2102 }
				cylinder { <43.3973, 460.3425, -38.2866>, <44.382, 460.6928, -39.1609>, 0.2102 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <44.382, 460.6928, -39.1609>, <44.4781, 460.7146, -39.208>, 0.007074 }
				cylinder { <44.4781, 460.7146, -39.208>, <44.5844, 460.7284, -39.2286>, 0.007074 }
				cylinder { <44.5844, 460.7284, -39.2286>, <44.6932, 460.7333, -39.2214>, 0.007074 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <44.6932, 460.7333, -39.2214>, <56.6142, 461.3633, -39.2167>, <56.7497, 460.5428, -38.6481> }
				triangle { <56.6142, 461.3633, -39.2167>, <59.5164, 458.5968, -42.2463>, <56.7497, 460.5428, -38.6481> }
				triangle { <56.6142, 461.3633, -39.2167>, <58.9679, 459.8229, -42.1963>, <59.5164, 458.5968, -42.2463> }
				triangle { <59.5164, 458.5968, -42.2463>, <58.9829, 458.3496, -40.8>, <56.7497, 460.5428, -38.6481> }
				triangle { <56.7497, 460.5428, -38.6481>, <52.02289, 459.8577, -39.05444>, <44.6932, 460.7333, -39.2214> }
				triangle { <44.6932, 460.7333, -39.2214>, <52.00181, 461.2083, -40.2344>, <56.6142, 461.3633, -39.2167> }
				triangle { <52.00181, 461.2083, -40.2344>, <56.5073, 461.4343, -40.8951>, <56.6142, 461.3633, -39.2167> }
				triangle { <56.5073, 461.4343, -40.8951>, <58.9679, 459.8229, -42.1963>, <56.6142, 461.3633, -39.2167> }
				triangle { <56.7497, 460.5428, -38.6481>, <58.9829, 458.3496, -40.8>, <56.9227, 459.0035, -39.3436> }
				triangle { <56.9227, 459.0035, -39.3436>, <52.02289, 459.8577, -39.05444>, <56.7497, 460.5428, -38.6481> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <44.382, 460.6928, -39.1609>, <44.4609, 460.7209, -39.2309>, 0.007074 }
				cylinder { <44.4609, 460.7209, -39.2309>, <44.5398, 460.749, -39.301>, 0.007074 }
				cylinder { <44.5398, 460.749, -39.301>, <44.6187, 460.7771, -39.371>, 0.007074 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <44.6187, 460.7771, -39.371>, <52.7041, 463.8338, -47.6045>, <53.3838, 463.1443, -47.3267> }
				triangle { <52.7041, 463.8338, -47.6045>, <53.3156, 461.3336, -51.9207>, <53.3838, 463.1443, -47.3267> }
				triangle { <52.7041, 463.8338, -47.6045>, <52.6735, 462.4161, -51.449>, <53.3156, 461.3336, -51.9207> }
				triangle { <53.3156, 461.3336, -51.9207>, <53.9922, 461.1826, -50.5218>, <53.3838, 463.1443, -47.3267> }
				triangle { <53.3838, 463.1443, -47.3267>, <50.00798, 461.455, -44.3725>, <44.6187, 460.7771, -39.371> }
				triangle { <44.6187, 460.7771, -39.371>, <48.8621, 462.5982, -45.1454>, <52.7041, 463.8338, -47.6045> }
				triangle { <48.8621, 462.5982, -45.1454>, <51.4696, 463.6511, -48.7343>, <52.7041, 463.8338, -47.6045> }
				triangle { <51.4696, 463.6511, -48.7343>, <52.6735, 462.4161, -51.449>, <52.7041, 463.8338, -47.6045> }
				triangle { <53.3838, 463.1443, -47.3267>, <53.9922, 461.1826, -50.5218>, <53.4027, 461.5929, -48.01645> }
				triangle { <53.4027, 461.5929, -48.01645>, <50.00798, 461.455, -44.3725>, <53.3838, 463.1443, -47.3267> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <35.7964, 454.2573, -31.3521>, <35.5569, 459.4934, -31.5893>, 0.1586 }
		cylinder { <35.5569, 459.4934, -31.5893>, <33.5831, 464.3549, -31.5612>, 0.1586 }
		cylinder { <33.5831, 464.3549, -31.5612>, <30.1057, 468.2733, -31.271>, 0.1586 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <30.1057, 468.2733, -31.271>, <29.5117, 468.6002, -31.2037>, 0.04415 }
			cylinder { <29.5117, 468.6002, -31.2037>, <28.8447, 468.7069, -31.1147>, 0.04415 }
			cylinder { <28.8447, 468.7069, -31.1147>, <28.1827, 468.581, -31.01431>, 0.04415 }
			material { txgilia_petiole }}
		union { // compound leaf
				cylinder { <28.1827, 468.581, -31.01431>, <27.9061, 468.5212, -30.9719>, 0.04415 }
				cylinder { <27.9061, 468.5212, -30.9719>, <27.6311, 468.4547, -30.9295>, 0.04415 }
				cylinder { <27.6311, 468.4547, -30.9295>, <27.3578, 468.3813, -30.8869>, 0.04415 }
				material { txgilia_petiole }
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <30.1057, 468.2733, -31.271>, <29.1108, 469.598, -31.08762>, 0.189 }
			cylinder { <29.1108, 469.598, -31.08762>, <28.2352, 470.9899, -30.8146>, 0.189 }
			cylinder { <28.2352, 470.9899, -30.8146>, <27.4873, 472.4355, -30.4548>, 0.189 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <27.4873, 472.4355, -30.4548>, <26.8745, 473.9208, -30.01165>, 0.189 }
			cylinder { <26.8745, 473.9208, -30.01165>, <26.4025, 475.4317, -29.4893>, 0.189 }
			cylinder { <26.4025, 475.4317, -29.4893>, <26.07593, 476.9536, -28.8928>, 0.189 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <26.07593, 476.9536, -28.8928>, <25.6848, 478.5101, -28.4426>, 0.189 }
			cylinder { <25.6848, 478.5101, -28.4426>, <25.2329, 480.0863, -28.143>, 0.189 }
			cylinder { <25.2329, 480.0863, -28.143>, <24.7246, 481.667, -27.9969>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <24.7246, 481.667, -27.9969>, <23.8667, 484.0145, -28.06821>, 0.189 }
				cylinder { <23.8667, 484.0145, -28.06821>, <22.9264, 486.3029, -28.4288>, 0.189 }
				cylinder { <22.9264, 486.3029, -28.4288>, <21.9178, 488.4981, -29.07352>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <21.9178, 488.4981, -29.07352>, <16.454, 498.1123, -31.6464>, <16.95, 498.5517, -30.2557> }
					triangle { <21.9178, 488.4981, -29.07352>, <18.9933, 493.5564, -31.298>, <16.454, 498.1123, -31.6464> }
					triangle { <16.95, 498.5517, -30.2557>, <20.1246, 494.8683, -29.8408>, <21.9178, 488.4981, -29.07352> }
					triangle { <18.9933, 493.5564, -31.298>, <14.8984, 497.4987, -31.4913>, <16.454, 498.1123, -31.6464> }
					triangle { <14.8984, 497.4987, -31.4913>, <12.8456, 497.9917, -29.7279>, <16.454, 498.1123, -31.6464> }
					triangle { <16.95, 498.5517, -30.2557>, <16.4269, 499.4846, -28.7069>, <18.2052, 499.3711, -29.7257> }
					triangle { <18.2052, 499.3711, -29.7257>, <20.1246, 494.8683, -29.8408>, <16.95, 498.5517, -30.2557> }
					triangle { <12.8456, 497.9917, -29.7279>, <13.2587, 498.4442, -29.7832>, <15.5897, 498.8999, -30.1031> }
					triangle { <13.2587, 498.4442, -29.7832>, <12.687, 498.0307, -27.1735>, <15.2959, 499.7515, -28.1282> }
					triangle { <15.5897, 498.8999, -30.1031>, <15.2959, 499.7515, -28.1282>, <16.4269, 499.4846, -28.7069> }
					triangle { <15.5897, 498.8999, -30.1031>, <13.2587, 498.4442, -29.7832>, <15.2959, 499.7515, -28.1282> }
					triangle { <16.454, 498.1123, -31.6464>, <12.8456, 497.9917, -29.7279>, <15.5897, 498.8999, -30.1031> }
					triangle { <16.95, 498.5517, -30.2557>, <15.5897, 498.8999, -30.1031>, <16.4269, 499.4846, -28.7069> }
					triangle { <16.454, 498.1123, -31.6464>, <15.5897, 498.8999, -30.1031>, <16.95, 498.5517, -30.2557> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <21.9178, 488.4981, -29.07352>, <17.316, 498.7706, -30.5582>, <18.7872, 499.2115, -30.6784> }
					triangle { <21.9178, 488.4981, -29.07352>, <18.6823, 493.7437, -30.1238>, <17.316, 498.7706, -30.5582> }
					triangle { <18.7872, 499.2115, -30.6784>, <20.4744, 494.6577, -31.1618>, <21.9178, 488.4981, -29.07352> }
					triangle { <18.6823, 493.7437, -30.1238>, <16.8185, 498.9917, -28.9696>, <17.316, 498.7706, -30.5582> }
					triangle { <16.8185, 498.9917, -28.9696>, <17.5815, 500.7325, -26.9811>, <17.316, 498.7706, -30.5582> }
					triangle { <18.7872, 499.2115, -30.6784>, <19.983, 500.5809, -30.1914>, <19.7855, 499.4497, -31.8927> }
					triangle { <19.7855, 499.4497, -31.8927>, <20.4744, 494.6577, -31.1618>, <18.7872, 499.2115, -30.6784> }
					triangle { <17.5815, 500.7325, -26.9811>, <17.7004, 500.9205, -27.5545>, <18.3666, 500.1711, -29.7313> }
					triangle { <17.7004, 500.9205, -27.5545>, <19.8448, 501.3733, -25.9718>, <20.04526, 501.4538, -29.2325> }
					triangle { <18.3666, 500.1711, -29.7313>, <20.04526, 501.4538, -29.2325>, <19.983, 500.5809, -30.1914> }
					triangle { <18.3666, 500.1711, -29.7313>, <17.7004, 500.9205, -27.5545>, <20.04526, 501.4538, -29.2325> }
					triangle { <17.316, 498.7706, -30.5582>, <17.5815, 500.7325, -26.9811>, <18.3666, 500.1711, -29.7313> }
					triangle { <18.7872, 499.2115, -30.6784>, <18.3666, 500.1711, -29.7313>, <19.983, 500.5809, -30.1914> }
					triangle { <17.316, 498.7706, -30.5582>, <18.3666, 500.1711, -29.7313>, <18.7872, 499.2115, -30.6784> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <21.9178, 488.4981, -29.07352>, <18.6616, 499.1681, -31.1842>, <19.1564, 498.8443, -32.6067> }
					triangle { <21.9178, 488.4981, -29.07352>, <19.6247, 494.2942, -29.5584>, <18.6616, 499.1681, -31.1842> }
					triangle { <19.1564, 498.8443, -32.6067>, <19.4143, 494.0384, -31.7978>, <21.9178, 488.4981, -29.07352> }
					triangle { <19.6247, 494.2942, -29.5584>, <19.905, 499.9203, -30.3426>, <18.6616, 499.1681, -31.1842> }
					triangle { <19.905, 499.9203, -30.3426>, <22.02961, 501.485, -31.1202>, <18.6616, 499.1681, -31.1842> }
					triangle { <19.1564, 498.8443, -32.6067>, <20.09065, 499.5752, -34.06808>, <18.4597, 498.3353, -33.9421> }
					triangle { <18.4597, 498.3353, -33.9421>, <19.4143, 494.0384, -31.7978>, <19.1564, 498.8443, -32.6067> }
					triangle { <22.02961, 501.485, -31.1202>, <21.5555, 501.4724, -31.512>, <19.8459, 500.0638, -32.4268> }
					triangle { <21.5555, 501.4724, -31.512>, <23.8795, 501.2044, -32.867>, <20.9894, 500.4997, -34.2197> }
					triangle { <19.8459, 500.0638, -32.4268>, <20.9894, 500.4997, -34.2197>, <20.09065, 499.5752, -34.06808> }
					triangle { <19.8459, 500.0638, -32.4268>, <21.5555, 501.4724, -31.512>, <20.9894, 500.4997, -34.2197> }
					triangle { <18.6616, 499.1681, -31.1842>, <22.02961, 501.485, -31.1202>, <19.8459, 500.0638, -32.4268> }
					triangle { <19.1564, 498.8443, -32.6067>, <19.8459, 500.0638, -32.4268>, <20.09065, 499.5752, -34.06808> }
					triangle { <18.6616, 499.1681, -31.1842>, <19.8459, 500.0638, -32.4268>, <19.1564, 498.8443, -32.6067> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <21.9178, 488.4981, -29.07352>, <18.6438, 498.7591, -32.665>, <17.5509, 497.9543, -33.3936> }
					triangle { <21.9178, 488.4981, -29.07352>, <20.5269, 494.4522, -30.378>, <18.6438, 498.7591, -32.665> }
					triangle { <17.5509, 497.9543, -33.3936>, <18.3993, 493.8606, -30.8758>, <21.9178, 488.4981, -29.07352> }
					triangle { <20.5269, 494.4522, -30.378>, <19.9214, 499.01, -33.7257>, <18.6438, 498.7591, -32.665> }
					triangle { <19.9214, 499.01, -33.7257>, <20.08437, 499.2164, -36.4639>, <18.6438, 498.7591, -32.665> }
					triangle { <17.5509, 497.9543, -33.3936>, <16.602, 497.848, -35.01568>, <16.04769, 497.5576, -33.06081> }
					triangle { <16.04769, 497.5576, -33.06081>, <18.3993, 493.8606, -30.8758>, <17.5509, 497.9543, -33.3936> }
					triangle { <20.08437, 499.2164, -36.4639>, <19.5324, 499.3423, -36.2234>, <17.9971, 498.7253, -34.4897> }
					triangle { <19.5324, 499.3423, -36.2234>, <19.2529, 497.7558, -38.3945>, <16.8323, 498.1987, -36.2441> }
					triangle { <17.9971, 498.7253, -34.4897>, <16.8323, 498.1987, -36.2441>, <16.602, 497.848, -35.01568> }
					triangle { <17.9971, 498.7253, -34.4897>, <19.5324, 499.3423, -36.2234>, <16.8323, 498.1987, -36.2441> }
					triangle { <18.6438, 498.7591, -32.665>, <20.08437, 499.2164, -36.4639>, <17.9971, 498.7253, -34.4897> }
					triangle { <17.5509, 497.9543, -33.3936>, <17.9971, 498.7253, -34.4897>, <16.602, 497.848, -35.01568> }
					triangle { <18.6438, 498.7591, -32.665>, <17.9971, 498.7253, -34.4897>, <17.5509, 497.9543, -33.3936> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <21.9178, 488.4981, -29.07352>, <17.2589, 498.0968, -32.955>, <16.1666, 497.7707, -31.9187> }
					triangle { <21.9178, 488.4981, -29.07352>, <20.1308, 493.9894, -31.4694>, <17.2589, 498.0968, -32.955> }
					triangle { <16.1666, 497.7707, -31.9187>, <18.8449, 494.3813, -29.648>, <21.9178, 488.4981, -29.07352> }
					triangle { <20.1308, 493.9894, -31.4694>, <16.7805, 497.4908, -34.4464>, <17.2589, 498.0968, -32.955> }
					triangle { <16.7805, 497.4908, -34.4464>, <14.3227, 497.0249, -35.5904>, <17.2589, 498.0968, -32.955> }
					triangle { <16.1666, 497.7707, -31.9187>, <14.3036, 497.7911, -31.6523>, <15.888, 498.2075, -30.4156> }
					triangle { <15.888, 498.2075, -30.4156>, <18.8449, 494.3813, -29.648>, <16.1666, 497.7707, -31.9187> }
					triangle { <14.3227, 497.0249, -35.5904>, <14.3272, 497.4425, -35.1389>, <15.3269, 497.9951, -33.03198> }
					triangle { <14.3272, 497.4425, -35.1389>, <12.2311, 495.7648, -34.8226>, <13.2605, 497.7294, -32.4226> }
					triangle { <15.3269, 497.9951, -33.03198>, <13.2605, 497.7294, -32.4226>, <14.3036, 497.7911, -31.6523> }
					triangle { <15.3269, 497.9951, -33.03198>, <14.3272, 497.4425, -35.1389>, <13.2605, 497.7294, -32.4226> }
					triangle { <17.2589, 498.0968, -32.955>, <14.3227, 497.0249, -35.5904>, <15.3269, 497.9951, -33.03198> }
					triangle { <16.1666, 497.7707, -31.9187>, <15.3269, 497.9951, -33.03198>, <14.3036, 497.7911, -31.6523> }
					triangle { <17.2589, 498.0968, -32.955>, <15.3269, 497.9951, -33.03198>, <16.1666, 497.7707, -31.9187> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <24.7246, 481.667, -27.9969>, <24.1607, 483.2077, -27.7022>, 0.189 }
			cylinder { <24.1607, 483.2077, -27.7022>, <23.5467, 484.6934, -27.2618>, 0.189 }
			cylinder { <23.5467, 484.6934, -27.2618>, <22.8884, 486.11, -26.68>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <22.8884, 486.11, -26.68>, <21.8316, 488.0764, -25.554>, 0.189 }
				cylinder { <21.8316, 488.0764, -25.554>, <20.7212, 489.8548, -24.1918>, 0.189 }
				cylinder { <20.7212, 489.8548, -24.1918>, <19.5739, 491.4185, -22.6139>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <19.5739, 491.4185, -22.6139>, <15.07013, 498.8937, -15.3634>, <15.2249, 499.8622, -16.55> }
					triangle { <19.5739, 491.4185, -22.6139>, <16.7832, 494.8639, -18.2119>, <15.07013, 498.8937, -15.3634> }
					triangle { <15.2249, 499.8622, -16.55>, <16.05148, 496.3112, -19.7891>, <19.5739, 491.4185, -22.6139> }
					triangle { <16.7832, 494.8639, -18.2119>, <16.4176, 499.0398, -14.3737>, <15.07013, 498.8937, -15.3634> }
					triangle { <16.4176, 499.0398, -14.3737>, <18.1549, 501.1049, -13.851>, <15.07013, 498.8937, -15.3634> }
					triangle { <15.2249, 499.8622, -16.55>, <15.7111, 501.626, -16.9864>, <14.265, 500.3651, -17.712> }
					triangle { <14.265, 500.3651, -17.712>, <16.05148, 496.3112, -19.7891>, <15.2249, 499.8622, -16.55> }
					triangle { <18.1549, 501.1049, -13.851>, <17.6022, 501.2737, -14.0604>, <15.8384, 500.6587, -15.5594> }
					triangle { <17.6022, 501.2737, -14.0604>, <19.5353, 502.6647, -15.3359>, <16.4687, 502.533, -16.4512> }
					triangle { <15.8384, 500.6587, -15.5594>, <16.4687, 502.533, -16.4512>, <15.7111, 501.626, -16.9864> }
					triangle { <15.8384, 500.6587, -15.5594>, <17.6022, 501.2737, -14.0604>, <16.4687, 502.533, -16.4512> }
					triangle { <15.07013, 498.8937, -15.3634>, <18.1549, 501.1049, -13.851>, <15.8384, 500.6587, -15.5594> }
					triangle { <15.2249, 499.8622, -16.55>, <15.8384, 500.6587, -15.5594>, <15.7111, 501.626, -16.9864> }
					triangle { <15.07013, 498.8937, -15.3634>, <15.8384, 500.6587, -15.5594>, <15.2249, 499.8622, -16.55> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <19.5739, 491.4185, -22.6139>, <14.7223, 499.7294, -16.6035>, <13.552, 499.5027, -17.5777> }
					triangle { <19.5739, 491.4185, -22.6139>, <17.4411, 495.7856, -18.6877>, <14.7223, 499.7294, -16.6035> }
					triangle { <13.552, 499.5027, -17.5777>, <15.3114, 495.2742, -19.2539>, <19.5739, 491.4185, -22.6139> }
					triangle { <17.4411, 495.7856, -18.6877>, <15.6762, 500.9777, -17.1938>, <14.7223, 499.7294, -16.6035> }
					triangle { <15.6762, 500.9777, -17.1938>, <15.1462, 503.1733, -18.7605>, <14.7223, 499.7294, -16.6035> }
					triangle { <13.552, 499.5027, -17.5777>, <12.2467, 500.41, -18.583>, <12.2133, 498.648, -17.5334> }
					triangle { <12.2133, 498.648, -17.5334>, <15.3114, 495.2742, -19.2539>, <13.552, 499.5027, -17.5777> }
					triangle { <15.1462, 503.1733, -18.7605>, <14.6622, 502.9423, -18.4602>, <13.6533, 500.9044, -17.7083> }
					triangle { <14.6622, 502.9423, -18.4602>, <13.9855, 503.4879, -21.01825>, <12.1403, 501.5946, -19.1011> }
					triangle { <13.6533, 500.9044, -17.7083>, <12.1403, 501.5946, -19.1011>, <12.2467, 500.41, -18.583> }
					triangle { <13.6533, 500.9044, -17.7083>, <14.6622, 502.9423, -18.4602>, <12.1403, 501.5946, -19.1011> }
					triangle { <14.7223, 499.7294, -16.6035>, <15.1462, 503.1733, -18.7605>, <13.6533, 500.9044, -17.7083> }
					triangle { <13.552, 499.5027, -17.5777>, <13.6533, 500.9044, -17.7083>, <12.2467, 500.41, -18.583> }
					triangle { <14.7223, 499.7294, -16.6035>, <13.6533, 500.9044, -17.7083>, <13.552, 499.5027, -17.5777> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <19.5739, 491.4185, -22.6139>, <13.3896, 499.2191, -17.1699>, <12.5895, 497.9915, -16.6982> }
					triangle { <19.5739, 491.4185, -22.6139>, <16.8487, 496.2118, -19.6757>, <13.3896, 499.2191, -17.1699> }
					triangle { <12.5895, 497.9915, -16.6982>, <15.9778, 494.7947, -18.1424>, <19.5739, 491.4185, -22.6139> }
					triangle { <16.8487, 496.2118, -19.6757>, <12.6405, 499.8562, -18.5299>, <13.3896, 499.2191, -17.1699> }
					triangle { <12.6405, 499.8562, -18.5299>, <10.0374, 499.8705, -19.4129>, <13.3896, 499.2191, -17.1699> }
					triangle { <12.5895, 497.9915, -16.6982>, <10.8399, 497.3819, -16.3737>, <12.6206, 497.0694, -15.4046> }
					triangle { <12.6206, 497.0694, -15.4046>, <15.9778, 494.7947, -18.1424>, <12.5895, 497.9915, -16.6982> }
					triangle { <10.0374, 499.8705, -19.4129>, <10.1087, 499.7909, -18.8076>, <11.5061, 498.7764, -17.1481> }
					triangle { <10.1087, 499.7909, -18.8076>, <8.2844, 498.0402, -19.7594>, <9.6599, 497.6861, -16.8188> }
					triangle { <11.5061, 498.7764, -17.1481>, <9.6599, 497.6861, -16.8188>, <10.8399, 497.3819, -16.3737> }
					triangle { <11.5061, 498.7764, -17.1481>, <10.1087, 499.7909, -18.8076>, <9.6599, 497.6861, -16.8188> }
					triangle { <13.3896, 499.2191, -17.1699>, <10.0374, 499.8705, -19.4129>, <11.5061, 498.7764, -17.1481> }
					triangle { <12.5895, 497.9915, -16.6982>, <11.5061, 498.7764, -17.1481>, <10.8399, 497.3819, -16.3737> }
					triangle { <13.3896, 499.2191, -17.1699>, <11.5061, 498.7764, -17.1481>, <12.5895, 497.9915, -16.6982> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <19.5739, 491.4185, -22.6139>, <12.9012, 498.0634, -16.285>, <13.6585, 497.4029, -15.1187> }
					triangle { <19.5739, 491.4185, -22.6139>, <15.8193, 495.5575, -19.8198>, <12.9012, 498.0634, -16.285> }
					triangle { <13.6585, 497.4029, -15.1187>, <17.1359, 495.5309, -17.9803>, <19.5739, 491.4185, -22.6139> }
					triangle { <15.8193, 495.5575, -19.8198>, <11.4774, 497.2148, -16.5479>, <12.9012, 498.0634, -16.285> }
					triangle { <11.4774, 497.2148, -16.5479>, <9.841, 495.7301, -14.9126>, <12.9012, 498.0634, -16.285> }
					triangle { <13.6585, 497.4029, -15.1187>, <13.4218, 496.6981, -13.391>, <14.9278, 497.7961, -14.2477> }
					triangle { <14.9278, 497.7961, -14.2477>, <17.1359, 495.5309, -17.9803>, <13.6585, 497.4029, -15.1187> }
					triangle { <9.841, 495.7301, -14.9126>, <10.1919, 496.1452, -14.6256>, <12.3442, 497.1956, -14.6478> }
					triangle { <10.1919, 496.1452, -14.6256>, <10.2574, 493.7992, -13.2874>, <12.4323, 496.1724, -12.7371> }
					triangle { <12.3442, 497.1956, -14.6478>, <12.4323, 496.1724, -12.7371>, <13.4218, 496.6981, -13.391> }
					triangle { <12.3442, 497.1956, -14.6478>, <10.1919, 496.1452, -14.6256>, <12.4323, 496.1724, -12.7371> }
					triangle { <12.9012, 498.0634, -16.285>, <9.841, 495.7301, -14.9126>, <12.3442, 497.1956, -14.6478> }
					triangle { <13.6585, 497.4029, -15.1187>, <12.3442, 497.1956, -14.6478>, <13.4218, 496.6981, -13.391> }
					triangle { <12.9012, 498.0634, -16.285>, <12.3442, 497.1956, -14.6478>, <13.6585, 497.4029, -15.1187> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <19.5739, 491.4185, -22.6139>, <13.9555, 497.8592, -15.1517>, <15.3118, 498.5765, -15.02581> }
					triangle { <19.5739, 491.4185, -22.6139>, <15.7782, 494.7119, -18.9015>, <13.9555, 497.8592, -15.1517> }
					triangle { <15.3118, 498.5765, -15.02581>, <17.1821, 496.4822, -19.01347>, <19.5739, 491.4185, -22.6139> }
					triangle { <15.7782, 494.7119, -18.9015>, <13.847, 496.7026, -13.9405>, <13.9555, 497.8592, -15.1517> }
					triangle { <13.847, 496.7026, -13.9405>, <14.9336, 496.5045, -11.4233>, <13.9555, 497.8592, -15.1517> }
					triangle { <15.3118, 498.5765, -15.02581>, <16.4777, 499.3607, -13.7754>, <15.9594, 499.8637, -15.6952> }
					triangle { <15.9594, 499.8637, -15.6952>, <17.1821, 496.4822, -19.01347>, <15.3118, 498.5765, -15.02581> }
					triangle { <14.9336, 496.5045, -11.4233>, <14.8931, 497.0754, -11.6474>, <15.06215, 498.3765, -13.6511> }
					triangle { <14.8931, 497.0754, -11.6474>, <17.3158, 496.7005, -10.5123>, <16.7039, 499.2131, -12.5065> }
					triangle { <15.06215, 498.3765, -13.6511>, <16.7039, 499.2131, -12.5065>, <16.4777, 499.3607, -13.7754> }
					triangle { <15.06215, 498.3765, -13.6511>, <14.8931, 497.0754, -11.6474>, <16.7039, 499.2131, -12.5065> }
					triangle { <13.9555, 497.8592, -15.1517>, <14.9336, 496.5045, -11.4233>, <15.06215, 498.3765, -13.6511> }
					triangle { <15.3118, 498.5765, -15.02581>, <15.06215, 498.3765, -13.6511>, <16.4777, 499.3607, -13.7754> }
					triangle { <13.9555, 497.8592, -15.1517>, <15.06215, 498.3765, -13.6511>, <15.3118, 498.5765, -15.02581> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <22.8884, 486.11, -26.68>, <22.3608, 487.6031, -26.1601>, 0.189 }
			cylinder { <22.3608, 487.6031, -26.1601>, <21.9687, 489.1586, -25.7072>, 0.189 }
			cylinder { <21.9687, 489.1586, -25.7072>, <21.716, 490.7614, -25.3256>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <21.716, 490.7614, -25.3256>, <21.6033, 493.2217, -24.8945>, 0.189 }
				cylinder { <21.6033, 493.2217, -24.8945>, <21.7586, 495.701, -24.6112>, 0.189 }
				cylinder { <21.7586, 495.701, -24.6112>, <22.1795, 498.1621, -24.4801>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <22.1795, 498.1621, -24.4801>, <23.7046, 509.3598, -25.4896>, <22.4918, 509.4262, -24.5437> }
					triangle { <22.1795, 498.1621, -24.4801>, <23.814, 504.1424, -25.2553>, <23.7046, 509.3598, -25.4896> }
					triangle { <22.4918, 509.4262, -24.5437>, <22.721, 504.7018, -23.3553>, <22.1795, 498.1621, -24.4801> }
					triangle { <23.814, 504.1424, -25.2553>, <23.1578, 509.488, -27.07114>, <23.7046, 509.3598, -25.4896> }
					triangle { <23.1578, 509.488, -27.07114>, <20.9724, 510.7009, -28.2154>, <23.7046, 509.3598, -25.4896> }
					triangle { <22.4918, 509.4262, -24.5437>, <20.8983, 510.3718, -24.2203>, <22.3096, 509.5622, -22.9712> }
					triangle { <22.3096, 509.5622, -22.9712>, <22.721, 504.7018, -23.3553>, <22.4918, 509.4262, -24.5437> }
					triangle { <20.9724, 510.7009, -28.2154>, <21.1417, 510.9264, -27.6692>, <22.02916, 510.327, -25.527> }
					triangle { <21.1417, 510.9264, -27.6692>, <18.4597, 510.61, -27.745>, <20.07491, 511.0659, -24.9435> }
					triangle { <22.02916, 510.327, -25.527>, <20.07491, 511.0659, -24.9435>, <20.8983, 510.3718, -24.2203> }
					triangle { <22.02916, 510.327, -25.527>, <21.1417, 510.9264, -27.6692>, <20.07491, 511.0659, -24.9435> }
					triangle { <23.7046, 509.3598, -25.4896>, <20.9724, 510.7009, -28.2154>, <22.02916, 510.327, -25.527> }
					triangle { <22.4918, 509.4262, -24.5437>, <22.02916, 510.327, -25.527>, <20.8983, 510.3718, -24.2203> }
					triangle { <23.7046, 509.3598, -25.4896>, <22.02916, 510.327, -25.527>, <22.4918, 509.4262, -24.5437> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <22.1795, 498.1621, -24.4801>, <22.881, 509.483, -24.1997>, <23.3674, 509.2352, -22.7603> }
					triangle { <22.1795, 498.1621, -24.4801>, <22.6077, 504.3571, -25.1688>, <22.881, 509.483, -24.1997> }
					triangle { <23.3674, 509.2352, -22.7603>, <24.07806, 504.4602, -23.4526>, <22.1795, 498.1621, -24.4801> }
					triangle { <22.6077, 504.3571, -25.1688>, <21.2294, 509.7787, -24.1634>, <22.881, 509.483, -24.1997> }
					triangle { <21.2294, 509.7787, -24.1634>, <19.5483, 510.8431, -22.2668>, <22.881, 509.483, -24.1997> }
					triangle { <23.3674, 509.2352, -22.7603>, <23.2323, 509.8918, -21.00291>, <24.7931, 509.0995, -22.07235> }
					triangle { <24.7931, 509.0995, -22.07235>, <24.07806, 504.4602, -23.4526>, <23.3674, 509.2352, -22.7603> }
					triangle { <19.5483, 510.8431, -22.2668>, <20.1395, 511.0023, -22.2124>, <22.3827, 510.2054, -22.4753> }
					triangle { <20.1395, 511.0023, -22.2124>, <19.1377, 510.337, -19.7932>, <22.3494, 510.5702, -20.3372> }
					triangle { <22.3827, 510.2054, -22.4753>, <22.3494, 510.5702, -20.3372>, <23.2323, 509.8918, -21.00291> }
					triangle { <22.3827, 510.2054, -22.4753>, <20.1395, 511.0023, -22.2124>, <22.3494, 510.5702, -20.3372> }
					triangle { <22.881, 509.483, -24.1997>, <19.5483, 510.8431, -22.2668>, <22.3827, 510.2054, -22.4753> }
					triangle { <23.3674, 509.2352, -22.7603>, <22.3827, 510.2054, -22.4753>, <23.2323, 509.8918, -21.00291> }
					triangle { <22.881, 509.483, -24.1997>, <22.3827, 510.2054, -22.4753>, <23.3674, 509.2352, -22.7603> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <22.1795, 498.1621, -24.4801>, <23.8258, 509.2908, -23.00487>, <25.3119, 508.8919, -23.05107> }
					triangle { <22.1795, 498.1621, -24.4801>, <22.3063, 504.3885, -23.9785>, <23.8258, 509.2908, -23.00487> }
					triangle { <25.3119, 508.8919, -23.05107>, <24.417, 504.4248, -24.7918>, <22.1795, 498.1621, -24.4801> }
					triangle { <22.3063, 504.3885, -23.9785>, <23.3363, 509.3481, -21.4006>, <23.8258, 509.2908, -23.00487> }
					triangle { <23.3363, 509.3481, -21.4006>, <24.6577, 509.8652, -19.04623>, <23.8258, 509.2908, -23.00487> }
					triangle { <25.3119, 508.8919, -23.05107>, <26.9795, 509.2434, -22.2551>, <26.4203, 508.8479, -24.1886> }
					triangle { <26.4203, 508.8479, -24.1886>, <24.417, 504.4248, -24.7918>, <25.3119, 508.8919, -23.05107> }
					triangle { <24.6577, 509.8652, -19.04623>, <24.9228, 510.0935, -19.5515>, <25.3474, 509.662, -21.8687> }
					triangle { <24.9228, 510.0935, -19.5515>, <26.7858, 508.9304, -17.9782>, <27.376, 509.6829, -21.1007> }
					triangle { <25.3474, 509.662, -21.8687>, <27.376, 509.6829, -21.1007>, <26.9795, 509.2434, -22.2551> }
					triangle { <25.3474, 509.662, -21.8687>, <24.9228, 510.0935, -19.5515>, <27.376, 509.6829, -21.1007> }
					triangle { <23.8258, 509.2908, -23.00487>, <24.6577, 509.8652, -19.04623>, <25.3474, 509.662, -21.8687> }
					triangle { <25.3119, 508.8919, -23.05107>, <25.3474, 509.662, -21.8687>, <26.9795, 509.2434, -22.2551> }
					triangle { <23.8258, 509.2908, -23.00487>, <25.3474, 509.662, -21.8687>, <25.3119, 508.8919, -23.05107> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <22.1795, 498.1621, -24.4801>, <25.2421, 509.047, -23.5451>, <25.6563, 508.8675, -25.01695> }
					triangle { <22.1795, 498.1621, -24.4801>, <23.3235, 504.1935, -23.3183>, <25.2421, 509.047, -23.5451> }
					triangle { <25.6563, 508.8675, -25.01695>, <23.2727, 504.6443, -25.5345>, <22.1795, 498.1621, -24.4801> }
					triangle { <23.3235, 504.1935, -23.3183>, <26.5866, 508.7873, -22.5749>, <25.2421, 509.047, -23.5451> }
					triangle { <26.5866, 508.7873, -22.5749>, <29.2872, 509.1094, -22.9743>, <25.2421, 509.047, -23.5451> }
					triangle { <25.6563, 508.8675, -25.01695>, <26.9963, 509.3166, -26.2581>, <24.9577, 509.1526, -26.4152> }
					triangle { <24.9577, 509.1526, -26.4152>, <23.2727, 504.6443, -25.5345>, <25.6563, 508.8675, -25.01695> }
					triangle { <29.2872, 509.1094, -22.9743>, <28.9259, 509.4475, -23.3389>, <26.8538, 509.4426, -24.54> }
					triangle { <28.9259, 509.4475, -23.3389>, <30.9059, 508.321, -24.7913>, <28.2551, 509.622, -26.1861> }
					triangle { <26.8538, 509.4426, -24.54>, <28.2551, 509.622, -26.1861>, <26.9963, 509.3166, -26.2581> }
					triangle { <26.8538, 509.4426, -24.54>, <28.9259, 509.4475, -23.3389>, <28.2551, 509.622, -26.1861> }
					triangle { <25.2421, 509.047, -23.5451>, <29.2872, 509.1094, -22.9743>, <26.8538, 509.4426, -24.54> }
					triangle { <25.6563, 508.8675, -25.01695>, <26.8538, 509.4426, -24.54>, <26.9963, 509.3166, -26.2581> }
					triangle { <25.2421, 509.047, -23.5451>, <26.8538, 509.4426, -24.54>, <25.6563, 508.8675, -25.01695> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <22.1795, 498.1621, -24.4801>, <25.1661, 509.0903, -25.104>, <23.8871, 509.2028, -25.9534> }
					triangle { <22.1795, 498.1621, -24.4801>, <24.2694, 504.039, -24.1193>, <25.1661, 509.0903, -25.104> }
					triangle { <23.8871, 509.2028, -25.9534>, <22.2086, 504.818, -24.6334>, <22.1795, 498.1621, -24.4801> }
					triangle { <24.2694, 504.039, -24.1193>, <26.4747, 508.8751, -26.1324>, <25.1661, 509.0903, -25.104> }
					triangle { <26.4747, 508.8751, -26.1324>, <26.9752, 509.6337, -28.7267>, <25.1661, 509.0903, -25.104> }
					triangle { <23.8871, 509.2028, -25.9534>, <23.1812, 510.0245, -27.491>, <22.3788, 509.6008, -25.6514> }
					triangle { <22.3788, 509.6008, -25.6514>, <22.2086, 504.818, -24.6334>, <23.8871, 509.2028, -25.9534> }
					triangle { <26.9752, 509.6337, -28.7267>, <26.5537, 509.97, -28.4317>, <24.772, 509.8598, -26.835> }
					triangle { <26.5537, 509.97, -28.4317>, <25.6824, 509.3747, -30.9187>, <23.6746, 510.4897, -28.5969> }
					triangle { <24.772, 509.8598, -26.835>, <23.6746, 510.4897, -28.5969>, <23.1812, 510.0245, -27.491> }
					triangle { <24.772, 509.8598, -26.835>, <26.5537, 509.97, -28.4317>, <23.6746, 510.4897, -28.5969> }
					triangle { <25.1661, 509.0903, -25.104>, <26.9752, 509.6337, -28.7267>, <24.772, 509.8598, -26.835> }
					triangle { <23.8871, 509.2028, -25.9534>, <24.772, 509.8598, -26.835>, <23.1812, 510.0245, -27.491> }
					triangle { <25.1661, 509.0903, -25.104>, <24.772, 509.8598, -26.835>, <23.8871, 509.2028, -25.9534> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <21.716, 490.7614, -25.3256>, <21.3071, 492.3413, -24.9864>, 0.189 }
			cylinder { <21.3071, 492.3413, -24.9864>, <20.7458, 493.8832, -24.693>, 0.189 }
			cylinder { <20.7458, 493.8832, -24.693>, <20.03753, 495.3721, -24.4481>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <20.03753, 495.3721, -24.4481>, <18.7141, 497.476, -24.1768>, 0.189 }
				cylinder { <18.7141, 497.476, -24.1768>, <17.1498, 499.4189, -24.00553>, 0.189 }
				cylinder { <17.1498, 499.4189, -24.00553>, <15.3679, 501.1715, -23.9368>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <15.3679, 501.1715, -23.9368>, <6.7167, 508.3167, -22.3022>, <7.8416, 509.3214, -21.999> }
					triangle { <15.3679, 501.1715, -23.9368>, <10.1532, 504.5801, -23.5198>, <6.7167, 508.3167, -22.3022> }
					triangle { <7.8416, 509.3214, -21.999>, <11.3499, 506.4736, -23.8258>, <15.3679, 501.1715, -23.9368> }
					triangle { <10.1532, 504.5801, -23.5198>, <6.1879, 507.6527, -20.8557>, <6.7167, 508.3167, -22.3022> }
					triangle { <6.1879, 507.6527, -20.8557>, <6.1262, 508.5806, -18.2707>, <6.7167, 508.3167, -22.3022> }
					triangle { <7.8416, 509.3214, -21.999>, <8.3174, 510.7286, -20.8472>, <8.6214, 510.4121, -22.8496> }
					triangle { <8.6214, 510.4121, -22.8496>, <11.3499, 506.4736, -23.8258>, <7.8416, 509.3214, -21.999> }
					triangle { <6.1262, 508.5806, -18.2707>, <6.1451, 509.0148, -18.7048>, <7.05181, 509.5528, -20.8535> }
					triangle { <6.1451, 509.0148, -18.7048>, <7.8842, 509.612, -16.7278>, <7.9988, 511.0797, -19.6406> }
					triangle { <7.05181, 509.5528, -20.8535>, <7.9988, 511.0797, -19.6406>, <8.3174, 510.7286, -20.8472> }
					triangle { <7.05181, 509.5528, -20.8535>, <6.1451, 509.0148, -18.7048>, <7.9988, 511.0797, -19.6406> }
					triangle { <6.7167, 508.3167, -22.3022>, <6.1262, 508.5806, -18.2707>, <7.05181, 509.5528, -20.8535> }
					triangle { <7.8416, 509.3214, -21.999>, <7.05181, 509.5528, -20.8535>, <8.3174, 510.7286, -20.8472> }
					triangle { <6.7167, 508.3167, -22.3022>, <7.05181, 509.5528, -20.8535>, <7.8416, 509.3214, -21.999> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <15.3679, 501.1715, -23.9368>, <7.7434, 509.4399, -22.498>, <8.3164, 509.9513, -23.8311> }
					triangle { <15.3679, 501.1715, -23.9368>, <10.762, 505.1829, -22.6407>, <7.7434, 509.4399, -22.498> }
					triangle { <8.3164, 509.9513, -23.8311>, <10.6651, 505.7954, -24.8148>, <15.3679, 501.1715, -23.9368> }
					triangle { <10.762, 505.1829, -22.6407>, <8.5362, 510.2177, -21.2413>, <7.7434, 509.4399, -22.498> }
					triangle { <8.5362, 510.2177, -21.2413>, <9.7477, 512.6727, -21.01385>, <7.7434, 509.4399, -22.498> }
					triangle { <8.3164, 509.9513, -23.8311>, <8.8201, 511.5193, -24.7371>, <7.9028, 509.7937, -25.356> }
					triangle { <7.9028, 509.7937, -25.356>, <10.6651, 505.7954, -24.8148>, <8.3164, 509.9513, -23.8311> }
					triangle { <9.7477, 512.6727, -21.01385>, <9.3245, 512.6293, -21.4569>, <8.4011, 511.1553, -23.1012> }
					triangle { <9.3245, 512.6293, -21.4569>, <11.5143, 513.8992, -22.3959>, <9.219, 512.7009, -24.3826> }
					triangle { <8.4011, 511.1553, -23.1012>, <9.219, 512.7009, -24.3826>, <8.8201, 511.5193, -24.7371> }
					triangle { <8.4011, 511.1553, -23.1012>, <9.3245, 512.6293, -21.4569>, <9.219, 512.7009, -24.3826> }
					triangle { <7.7434, 509.4399, -22.498>, <9.7477, 512.6727, -21.01385>, <8.4011, 511.1553, -23.1012> }
					triangle { <8.3164, 509.9513, -23.8311>, <8.4011, 511.1553, -23.1012>, <8.8201, 511.5193, -24.7371> }
					triangle { <7.7434, 509.4399, -22.498>, <8.4011, 511.1553, -23.1012>, <8.3164, 509.9513, -23.8311> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <15.3679, 501.1715, -23.9368>, <7.8935, 509.6978, -24.00312>, <7.2599, 508.8921, -25.1503> }
					triangle { <15.3679, 501.1715, -23.9368>, <11.4943, 506.0092, -23.1769>, <7.8935, 509.6978, -24.00312> }
					triangle { <7.2599, 508.8921, -25.1503>, <9.8411, 504.8658, -24.2116>, <15.3679, 501.1715, -23.9368> }
					triangle { <11.4943, 506.0092, -23.1769>, <8.9196, 510.8497, -24.6612>, <7.8935, 509.6978, -24.00312> }
					triangle { <8.9196, 510.8497, -24.6612>, <8.9501, 512.1935, -27.05706>, <7.8935, 509.6978, -24.00312> }
					triangle { <7.2599, 508.8921, -25.1503>, <6.4406, 509.0781, -26.8318>, <6.08878, 507.8244, -25.2487> }
					triangle { <6.08878, 507.8244, -25.2487>, <9.8411, 504.8658, -24.2116>, <7.2599, 508.8921, -25.1503> }
					triangle { <8.9501, 512.1935, -27.05706>, <8.4019, 511.9758, -26.8854>, <7.3116, 510.1474, -25.7915> }
					triangle { <8.4019, 511.9758, -26.8854>, <8.8279, 511.4438, -29.4979>, <6.482, 509.9558, -27.7851> }
					triangle { <7.3116, 510.1474, -25.7915>, <6.482, 509.9558, -27.7851>, <6.4406, 509.0781, -26.8318> }
					triangle { <7.3116, 510.1474, -25.7915>, <8.4019, 511.9758, -26.8854>, <6.482, 509.9558, -27.7851> }
					triangle { <7.8935, 509.6978, -24.00312>, <8.9501, 512.1935, -27.05706>, <7.3116, 510.1474, -25.7915> }
					triangle { <7.2599, 508.8921, -25.1503>, <7.3116, 510.1474, -25.7915>, <6.4406, 509.0781, -26.8318> }
					triangle { <7.8935, 509.6978, -24.00312>, <7.3116, 510.1474, -25.7915>, <7.2599, 508.8921, -25.1503> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <15.3679, 501.1715, -23.9368>, <6.9609, 508.7364, -24.7515>, <6.1223, 507.5976, -24.1459> }
					triangle { <15.3679, 501.1715, -23.9368>, <11.345, 505.9249, -24.3923>, <6.9609, 508.7364, -24.7515> }
					triangle { <6.1223, 507.5976, -24.1459>, <10.00916, 504.9607, -22.8442>, <15.3679, 501.1715, -23.9368> }
					triangle { <11.345, 505.9249, -24.3923>, <6.8119, 508.6812, -26.4211>, <6.9609, 508.7364, -24.7515> }
					triangle { <6.8119, 508.6812, -26.4211>, <4.8281, 507.8007, -28.1052>, <6.9609, 508.7364, -24.7515> }
					triangle { <6.1223, 507.5976, -24.1459>, <4.4452, 506.7558, -24.2561>, <5.6693, 507.2072, -22.675> }
					triangle { <5.6693, 507.2072, -22.675>, <10.00916, 504.9607, -22.8442>, <6.1223, 507.5976, -24.1459> }
					triangle { <4.8281, 507.8007, -28.1052>, <4.6437, 507.9514, -27.539>, <5.2787, 507.9125, -25.2316> }
					triangle { <4.6437, 507.9514, -27.539>, <3.5125, 505.6163, -28.2854>, <3.5447, 506.6126, -25.1777> }
					triangle { <5.2787, 507.9125, -25.2316>, <3.5447, 506.6126, -25.1777>, <4.4452, 506.7558, -24.2561> }
					triangle { <5.2787, 507.9125, -25.2316>, <4.6437, 507.9514, -27.539>, <3.5447, 506.6126, -25.1777> }
					triangle { <6.9609, 508.7364, -24.7515>, <4.8281, 507.8007, -28.1052>, <5.2787, 507.9125, -25.2316> }
					triangle { <6.1223, 507.5976, -24.1459>, <5.2787, 507.9125, -25.2316>, <4.4452, 506.7558, -24.2561> }
					triangle { <6.9609, 508.7364, -24.7515>, <5.2787, 507.9125, -25.2316>, <6.1223, 507.5976, -24.1459> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <15.3679, 501.1715, -23.9368>, <6.2226, 507.8699, -23.6844>, <6.4872, 507.8669, -22.1689> }
					triangle { <15.3679, 501.1715, -23.9368>, <10.5036, 505.0283, -24.6075>, <6.2226, 507.8699, -23.6844> }
					triangle { <6.4872, 507.8669, -22.1689>, <10.9557, 505.9694, -22.6022>, <15.3679, 501.1715, -23.9368> }
					triangle { <10.5036, 505.0283, -24.6075>, <5.09816, 506.6755, -24.03373>, <6.2226, 507.8699, -23.6844> }
					triangle { <5.09816, 506.6755, -24.03373>, <3.05656, 505.5341, -22.593>, <6.2226, 507.8699, -23.6844> }
					triangle { <6.4872, 507.8669, -22.1689>, <5.6227, 507.7912, -20.5016>, <7.2582, 508.8307, -21.1699> }
					triangle { <7.2582, 508.8307, -21.1699>, <10.9557, 505.9694, -22.6022>, <6.4872, 507.8669, -22.1689> }
					triangle { <3.05656, 505.5341, -22.593>, <3.2278, 506.0938, -22.4068>, <5.1157, 507.5395, -22.1337> }
					triangle { <3.2278, 506.0938, -22.4068>, <2.9204, 504.4671, -20.274>, <4.4963, 507.3176, -20.0682> }
					triangle { <5.1157, 507.5395, -22.1337>, <4.4963, 507.3176, -20.0682>, <5.6227, 507.7912, -20.5016> }
					triangle { <5.1157, 507.5395, -22.1337>, <3.2278, 506.0938, -22.4068>, <4.4963, 507.3176, -20.0682> }
					triangle { <6.2226, 507.8699, -23.6844>, <3.05656, 505.5341, -22.593>, <5.1157, 507.5395, -22.1337> }
					triangle { <6.4872, 507.8669, -22.1689>, <5.1157, 507.5395, -22.1337>, <5.6227, 507.7912, -20.5016> }
					triangle { <6.2226, 507.8699, -23.6844>, <5.1157, 507.5395, -22.1337>, <6.4872, 507.8669, -22.1689> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <30.1057, 468.2733, -31.271>, <28.9718, 469.4932, -31.3378>, 0.189 }
			cylinder { <28.9718, 469.4932, -31.3378>, <27.8195, 470.6764, -31.563>, 0.189 }
			cylinder { <27.8195, 470.6764, -31.563>, <26.6599, 471.8115, -31.9443>, 0.189 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <26.6599, 471.8115, -31.9443>, <25.4432, 472.7436, -32.5995>, 0.189 }
			cylinder { <25.4432, 472.7436, -32.5995>, <24.1435, 473.6505, -33.1159>, 0.189 }
			cylinder { <24.1435, 473.6505, -33.1159>, <22.7734, 474.5235, -33.4886>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <22.7734, 474.5235, -33.4886>, <20.614, 475.7518, -33.771>, 0.189 }
				cylinder { <20.614, 475.7518, -33.771>, <18.3829, 476.8804, -33.7724>, 0.189 }
				cylinder { <18.3829, 476.8804, -33.7724>, <16.1137, 477.8923, -33.4928>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <16.1137, 477.8923, -33.4928>, <6.5526, 483.5345, -31.1861>, <6.6472, 483.936, -32.6682> }
					triangle { <16.1137, 477.8923, -33.4928>, <10.7566, 480.4639, -31.5759>, <6.5526, 483.5345, -31.1861> }
					triangle { <6.6472, 483.936, -32.6682>, <10.03811, 480.5952, -33.7155>, <16.1137, 477.8923, -33.4928> }
					triangle { <10.7566, 480.4639, -31.5759>, <7.2585, 484.7407, -30.2588>, <6.5526, 483.5345, -31.1861> }
					triangle { <7.2585, 484.7407, -30.2588>, <7.5773, 487.4456, -30.6167>, <6.5526, 483.5345, -31.1861> }
					triangle { <6.6472, 483.936, -32.6682>, <6.3993, 485.3823, -33.8429>, <6.02616, 483.3742, -34.01734> }
					triangle { <6.02616, 483.3742, -34.01734>, <10.03811, 480.5952, -33.7155>, <6.6472, 483.936, -32.6682> }
					triangle { <7.5773, 487.4456, -30.6167>, <7.1173, 487.1915, -30.9347>, <6.4545, 485.2228, -32.1237> }
					triangle { <7.1173, 487.1915, -30.9347>, <8.5156, 488.8714, -32.5197>, <6.4307, 486.6738, -33.7341> }
					triangle { <6.4545, 485.2228, -32.1237>, <6.4307, 486.6738, -33.7341>, <6.3993, 485.3823, -33.8429> }
					triangle { <6.4545, 485.2228, -32.1237>, <7.1173, 487.1915, -30.9347>, <6.4307, 486.6738, -33.7341> }
					triangle { <6.5526, 483.5345, -31.1861>, <7.5773, 487.4456, -30.6167>, <6.4545, 485.2228, -32.1237> }
					triangle { <6.6472, 483.936, -32.6682>, <6.4545, 485.2228, -32.1237>, <6.3993, 485.3823, -33.8429> }
					triangle { <6.5526, 483.5345, -31.1861>, <6.4545, 485.2228, -32.1237>, <6.6472, 483.936, -32.6682> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <16.1137, 477.8923, -33.4928>, <6.3117, 483.5372, -32.7014>, <5.7829, 482.3745, -33.559> }
					triangle { <16.1137, 477.8923, -33.4928>, <11.04405, 481.3585, -32.3658>, <6.3117, 483.5372, -32.7014> }
					triangle { <5.7829, 482.3745, -33.559>, <9.7147, 479.5888, -32.8269>, <16.1137, 477.8923, -33.4928> }
					triangle { <11.04405, 481.3585, -32.3658>, <6.7345, 484.8026, -33.7177>, <6.3117, 483.5372, -32.7014> }
					triangle { <6.7345, 484.8026, -33.7177>, <5.8403, 485.6134, -36.1855>, <6.3117, 483.5372, -32.7014> }
					triangle { <5.7829, 482.3745, -33.559>, <4.641, 481.9792, -34.9989>, <5.0519, 481.0003, -33.2452> }
					triangle { <5.0519, 481.0003, -33.2452>, <9.7147, 479.5888, -32.8269>, <5.7829, 482.3745, -33.559> }
					triangle { <5.8403, 485.6134, -36.1855>, <5.4437, 485.2743, -35.8613>, <5.2774, 483.4404, -34.3323> }
					triangle { <5.4437, 485.2743, -35.8613>, <5.5127, 484.416, -38.4202>, <4.1948, 482.6307, -36.02711> }
					triangle { <5.2774, 483.4404, -34.3323>, <4.1948, 482.6307, -36.02711>, <4.641, 481.9792, -34.9989> }
					triangle { <5.2774, 483.4404, -34.3323>, <5.4437, 485.2743, -35.8613>, <4.1948, 482.6307, -36.02711> }
					triangle { <6.3117, 483.5372, -32.7014>, <5.8403, 485.6134, -36.1855>, <5.2774, 483.4404, -34.3323> }
					triangle { <5.7829, 482.3745, -33.559>, <5.2774, 483.4404, -34.3323>, <4.641, 481.9792, -34.9989> }
					triangle { <6.3117, 483.5372, -32.7014>, <5.2774, 483.4404, -34.3323>, <5.7829, 482.3745, -33.559> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <16.1137, 477.8923, -33.4928>, <5.6382, 482.2127, -33.08412>, <5.3733, 481.0071, -32.1657> }
					triangle { <16.1137, 477.8923, -33.4928>, <10.7007, 481.0045, -33.4899>, <5.6382, 482.2127, -33.08412> }
					triangle { <5.3733, 481.0071, -32.1657>, <10.1009, 479.987, -31.5623>, <16.1137, 477.8923, -33.4928> }
					triangle { <10.7007, 481.0045, -33.4899>, <5.1975, 481.8004, -34.6489>, <5.6382, 482.2127, -33.08412> }
					triangle { <5.1975, 481.8004, -34.6489>, <3.3489, 480.0521, -35.6845>, <5.6382, 482.2127, -33.08412> }
					triangle { <5.3733, 481.0071, -32.1657>, <4.09749, 479.6861, -31.7653>, <5.3743, 480.7815, -30.594> }
					triangle { <5.3743, 480.7815, -30.594>, <10.1009, 479.987, -31.5623>, <5.3733, 481.0071, -32.1657> }
					triangle { <3.3489, 480.0521, -35.6845>, <3.2371, 480.2429, -35.1114>, <4.28, 480.837, -33.0407> }
					triangle { <3.2371, 480.2429, -35.1114>, <2.8509, 477.5765, -35.2866>, <3.1402, 479.102, -32.416> }
					triangle { <4.28, 480.837, -33.0407>, <3.1402, 479.102, -32.416>, <4.09749, 479.6861, -31.7653> }
					triangle { <4.28, 480.837, -33.0407>, <3.2371, 480.2429, -35.1114>, <3.1402, 479.102, -32.416> }
					triangle { <5.6382, 482.2127, -33.08412>, <3.3489, 480.0521, -35.6845>, <4.28, 480.837, -33.0407> }
					triangle { <5.3733, 481.0071, -32.1657>, <4.28, 480.837, -33.0407>, <4.09749, 479.6861, -31.7653> }
					triangle { <5.6382, 482.2127, -33.08412>, <4.28, 480.837, -33.0407>, <5.3733, 481.0071, -32.1657> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <16.1137, 477.8923, -33.4928>, <5.4565, 481.3791, -31.8088>, <5.9806, 481.7108, -30.4009> }
					triangle { <16.1137, 477.8923, -33.4928>, <10.198, 479.8879, -33.4053>, <5.4565, 481.3791, -31.8088> }
					triangle { <5.9806, 481.7108, -30.4009>, <10.6665, 481.2432, -31.6574>, <16.1137, 477.8923, -33.4928> }
					triangle { <10.198, 479.8879, -33.4053>, <4.7573, 479.855, -31.7742>, <5.4565, 481.3791, -31.8088> }
					triangle { <4.7573, 479.855, -31.7742>, <3.5229, 478.3954, -29.8013>, <5.4565, 481.3791, -31.8088> }
					triangle { <5.9806, 481.7108, -30.4009>, <5.5147, 481.6507, -28.5808>, <6.5508, 483.018, -29.7029> }
					triangle { <6.5508, 483.018, -29.7029>, <10.6665, 481.2432, -31.6574>, <5.9806, 481.7108, -30.4009> }
					triangle { <3.5229, 478.3954, -29.8013>, <3.5263, 479.0035, -29.7144>, <4.8314, 480.9862, -30.02168> }
					triangle { <3.5263, 479.0035, -29.7144>, <4.1839, 477.741, -27.4203>, <4.7144, 480.9313, -27.8576> }
					triangle { <4.8314, 480.9862, -30.02168>, <4.7144, 480.9313, -27.8576>, <5.5147, 481.6507, -28.5808> }
					triangle { <4.8314, 480.9862, -30.02168>, <3.5263, 479.0035, -29.7144>, <4.7144, 480.9313, -27.8576> }
					triangle { <5.4565, 481.3791, -31.8088>, <3.5229, 478.3954, -29.8013>, <4.8314, 480.9862, -30.02168> }
					triangle { <5.9806, 481.7108, -30.4009>, <4.8314, 480.9862, -30.02168>, <5.5147, 481.6507, -28.5808> }
					triangle { <5.4565, 481.3791, -31.8088>, <4.8314, 480.9862, -30.02168>, <5.9806, 481.7108, -30.4009> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <16.1137, 477.8923, -33.4928>, <6.03022, 482.2083, -30.6181>, <6.7798, 483.5482, -30.7161> }
					triangle { <16.1137, 477.8923, -33.4928>, <10.233, 479.5487, -32.2046>, <6.03022, 482.2083, -30.6181> }
					triangle { <6.7798, 483.5482, -30.7161>, <10.6271, 481.6248, -33.00834>, <16.1137, 477.8923, -33.4928> }
					triangle { <10.233, 479.5487, -32.2046>, <6.05033, 481.6996, -29.02009>, <6.03022, 482.2083, -30.6181> }
					triangle { <6.05033, 481.6996, -29.02009>, <6.1756, 483.0338, -26.622>, <6.03022, 482.2083, -30.6181> }
					triangle { <6.7798, 483.5482, -30.7161>, <6.9588, 485.2243, -29.8843>, <6.9598, 484.6446, -31.8505> }
					triangle { <6.9598, 484.6446, -31.8505>, <10.6271, 481.6248, -33.00834>, <6.7798, 483.5482, -30.7161> }
					triangle { <6.1756, 483.0338, -26.622>, <5.9607, 483.3628, -27.09418>, <6.1955, 483.7376, -29.4464> }
					triangle { <5.9607, 483.3628, -27.09418>, <7.7377, 484.827, -25.6844>, <6.7787, 485.6816, -28.6846> }
					triangle { <6.1955, 483.7376, -29.4464>, <6.7787, 485.6816, -28.6846>, <6.9588, 485.2243, -29.8843> }
					triangle { <6.1955, 483.7376, -29.4464>, <5.9607, 483.3628, -27.09418>, <6.7787, 485.6816, -28.6846> }
					triangle { <6.03022, 482.2083, -30.6181>, <6.1756, 483.0338, -26.622>, <6.1955, 483.7376, -29.4464> }
					triangle { <6.7798, 483.5482, -30.7161>, <6.1955, 483.7376, -29.4464>, <6.9588, 485.2243, -29.8843> }
					triangle { <6.03022, 482.2083, -30.6181>, <6.1955, 483.7376, -29.4464>, <6.7798, 483.5482, -30.7161> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <26.6599, 471.8115, -31.9443>, <25.6074, 473.1008, -32.03556>, 0.189 }
			cylinder { <25.6074, 473.1008, -32.03556>, <24.6256, 474.4274, -32.2694>, 0.189 }
			cylinder { <24.6256, 474.4274, -32.2694>, <23.7239, 475.7784, -32.6439>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <23.7239, 475.7784, -32.6439>, <22.5397, 477.8232, -33.4611>, 0.189 }
				cylinder { <22.5397, 477.8232, -33.4611>, <21.5418, 479.8556, -34.5217>, 0.189 }
				cylinder { <21.5418, 479.8556, -34.5217>, <20.745, 481.845, -35.8096>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <20.745, 481.845, -35.8096>, <16.4412, 489.7757, -42.6762>, <15.586, 490.1188, -41.4442> }
					triangle { <20.745, 481.845, -35.8096>, <19.09114, 486.1368, -40.03231>, <16.4412, 489.7757, -42.6762> }
					triangle { <15.586, 490.1188, -41.4442>, <18.3087, 487.4747, -38.3863>, <20.745, 481.845, -35.8096> }
					triangle { <19.09114, 486.1368, -40.03231>, <15.5708, 488.7305, -43.6576>, <16.4412, 489.7757, -42.6762> }
					triangle { <15.5708, 488.7305, -43.6576>, <12.8839, 488.3438, -44.07863>, <16.4412, 489.7757, -42.6762> }
					triangle { <15.586, 490.1188, -41.4442>, <13.8497, 490.6148, -40.9221>, <15.7088, 491.1683, -40.259> }
					triangle { <15.7088, 491.1683, -40.259>, <18.3087, 487.4747, -38.3863>, <15.586, 490.1188, -41.4442> }
					triangle { <12.8839, 488.3438, -44.07863>, <13.03826, 488.8972, -43.861>, <14.5463, 490.0384, -42.3941> }
					triangle { <13.03826, 488.8972, -43.861>, <10.8971, 487.9444, -42.5204>, <12.6597, 490.4575, -41.4119> }
					triangle { <14.5463, 490.0384, -42.3941>, <12.6597, 490.4575, -41.4119>, <13.8497, 490.6148, -40.9221> }
					triangle { <14.5463, 490.0384, -42.3941>, <13.03826, 488.8972, -43.861>, <12.6597, 490.4575, -41.4119> }
					triangle { <16.4412, 489.7757, -42.6762>, <12.8839, 488.3438, -44.07863>, <14.5463, 490.0384, -42.3941> }
					triangle { <15.586, 490.1188, -41.4442>, <14.5463, 490.0384, -42.3941>, <13.8497, 490.6148, -40.9221> }
					triangle { <16.4412, 489.7757, -42.6762>, <14.5463, 490.0384, -42.3941>, <15.586, 490.1188, -41.4442> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <20.745, 481.845, -35.8096>, <15.964, 490.4759, -41.397>, <16.8096, 491.3285, -40.4352> }
					triangle { <20.745, 481.845, -35.8096>, <17.9829, 486.0457, -39.5124>, <15.964, 490.4759, -41.397> }
					triangle { <16.8096, 491.3285, -40.4352>, <19.5555, 487.5772, -38.9712>, <20.745, 481.845, -35.8096> }
					triangle { <17.9829, 486.0457, -39.5124>, <14.428, 490.3003, -40.7469>, <15.964, 490.4759, -41.397> }
					triangle { <14.428, 490.3003, -40.7469>, <12.9031, 491.8576, -39.07473>, <15.964, 490.4759, -41.397> }
					triangle { <16.8096, 491.3285, -40.4352>, <16.7627, 492.8876, -39.3864>, <18.235, 492.0229, -40.5207> }
					triangle { <18.235, 492.0229, -40.5207>, <19.5555, 487.5772, -38.9712>, <16.8096, 491.3285, -40.4352> }
					triangle { <12.9031, 491.8576, -39.07473>, <13.3403, 492.1569, -39.3855>, <15.5699, 491.9711, -40.2359> }
					triangle { <13.3403, 492.1569, -39.3855>, <13.3368, 492.9511, -36.8051>, <15.8324, 493.5835, -38.8109> }
					triangle { <15.5699, 491.9711, -40.2359>, <15.8324, 493.5835, -38.8109>, <16.7627, 492.8876, -39.3864> }
					triangle { <15.5699, 491.9711, -40.2359>, <13.3403, 492.1569, -39.3855>, <15.8324, 493.5835, -38.8109> }
					triangle { <15.964, 490.4759, -41.397>, <12.9031, 491.8576, -39.07473>, <15.5699, 491.9711, -40.2359> }
					triangle { <16.8096, 491.3285, -40.4352>, <15.5699, 491.9711, -40.2359>, <16.7627, 492.8876, -39.3864> }
					triangle { <15.964, 490.4759, -41.397>, <15.5699, 491.9711, -40.2359>, <16.8096, 491.3285, -40.4352> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <20.745, 481.845, -35.8096>, <17.1188, 491.3293, -40.8561>, <18.5618, 491.3816, -41.387> }
					triangle { <20.745, 481.845, -35.8096>, <17.9714, 486.7469, -38.5049>, <17.1188, 491.3293, -40.8561> }
					triangle { <18.5618, 491.3816, -41.387>, <19.5684, 486.7884, -40.1046>, <20.745, 481.845, -35.8096> }
					triangle { <17.9714, 486.7469, -38.5049>, <17.02549, 492.2643, -39.4669>, <17.1188, 491.3293, -40.8561> }
					triangle { <17.02549, 492.2643, -39.4669>, <18.4118, 494.4653, -38.5834>, <17.1188, 491.3293, -40.8561> }
					triangle { <18.5618, 491.3816, -41.387>, <19.9819, 492.5614, -41.7399>, <19.2759, 490.9073, -42.7236> }
					triangle { <19.2759, 490.9073, -42.7236>, <19.5684, 486.7884, -40.1046>, <18.5618, 491.3816, -41.387> }
					triangle { <18.4118, 494.4653, -38.5834>, <18.417, 494.3788, -39.1915>, <18.4797, 492.7023, -40.8986> }
					triangle { <18.417, 494.3788, -39.1915>, <20.8999, 494.9926, -38.3267>, <20.359, 493.7134, -41.28> }
					triangle { <18.4797, 492.7023, -40.8986>, <20.359, 493.7134, -41.28>, <19.9819, 492.5614, -41.7399> }
					triangle { <18.4797, 492.7023, -40.8986>, <18.417, 494.3788, -39.1915>, <20.359, 493.7134, -41.28> }
					triangle { <17.1188, 491.3293, -40.8561>, <18.4118, 494.4653, -38.5834>, <18.4797, 492.7023, -40.8986> }
					triangle { <18.5618, 491.3816, -41.387>, <18.4797, 492.7023, -40.8986>, <19.9819, 492.5614, -41.7399> }
					triangle { <17.1188, 491.3293, -40.8561>, <18.4797, 492.7023, -40.8986>, <18.5618, 491.3816, -41.387> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <20.745, 481.845, -35.8096>, <18.3203, 491.1645, -41.796>, <18.4374, 490.2052, -42.993> }
					triangle { <20.745, 481.845, -35.8096>, <19.07247, 487.2779, -38.3927>, <18.3203, 491.1645, -41.796> }
					triangle { <18.4374, 490.2052, -42.993>, <18.3297, 486.191, -40.2308>, <20.745, 481.845, -35.8096> }
					triangle { <19.07247, 487.2779, -38.3927>, <19.7978, 491.9267, -41.5746>, <18.3203, 491.1645, -41.796> }
					triangle { <19.7978, 491.9267, -41.5746>, <21.8484, 492.5874, -43.2791>, <18.3203, 491.1645, -41.796> }
					triangle { <18.4374, 490.2052, -42.993>, <19.08864, 490.0839, -44.7521>, <17.4026, 489.3527, -43.8438> }
					triangle { <17.4026, 489.3527, -43.8438>, <18.3297, 486.191, -40.2308>, <18.4374, 490.2052, -42.993> }
					triangle { <21.8484, 492.5874, -43.2791>, <21.2998, 492.5129, -43.5453>, <19.2816, 491.2284, -43.4726> }
					triangle { <21.2998, 492.5129, -43.5453>, <23.2051, 491.2666, -44.9966>, <20.02612, 490.6689, -45.4302> }
					triangle { <19.2816, 491.2284, -43.4726>, <20.02612, 490.6689, -45.4302>, <19.08864, 490.0839, -44.7521> }
					triangle { <19.2816, 491.2284, -43.4726>, <21.2998, 492.5129, -43.5453>, <20.02612, 490.6689, -45.4302> }
					triangle { <18.3203, 491.1645, -41.796>, <21.8484, 492.5874, -43.2791>, <19.2816, 491.2284, -43.4726> }
					triangle { <18.4374, 490.2052, -42.993>, <19.2816, 491.2284, -43.4726>, <19.08864, 490.0839, -44.7521> }
					triangle { <18.3203, 491.1645, -41.796>, <19.2816, 491.2284, -43.4726>, <18.4374, 490.2052, -42.993> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <20.745, 481.845, -35.8096>, <17.8952, 490.1898, -42.9378>, <16.5704, 489.413, -43.02898> }
					triangle { <20.745, 481.845, -35.8096>, <19.7749, 486.8951, -39.351>, <17.8952, 490.1898, -42.9378> }
					triangle { <16.5704, 489.413, -43.02898>, <17.5395, 486.6216, -39.1528>, <20.745, 481.845, -35.8096> }
					triangle { <19.7749, 486.8951, -39.351>, <18.8852, 489.7097, -44.2037>, <17.8952, 490.1898, -42.9378> }
					triangle { <18.8852, 489.7097, -44.2037>, <18.3804, 488.747, -46.7265>, <17.8952, 490.1898, -42.9378> }
					triangle { <16.5704, 489.413, -43.02898>, <15.2415, 488.8627, -44.239>, <15.1648, 489.5165, -42.2977> }
					triangle { <15.1648, 489.5165, -42.2977>, <17.5395, 486.6216, -39.1528>, <16.5704, 489.413, -43.02898> }
					triangle { <18.3804, 488.747, -46.7265>, <17.9254, 489.0739, -46.4747>, <16.8139, 489.5572, -44.4108> }
					triangle { <17.9254, 489.0739, -46.4747>, <16.9297, 486.8448, -47.6275>, <15.1958, 488.6263, -45.5129> }
					triangle { <16.8139, 489.5572, -44.4108>, <15.1958, 488.6263, -45.5129>, <15.2415, 488.8627, -44.239> }
					triangle { <16.8139, 489.5572, -44.4108>, <17.9254, 489.0739, -46.4747>, <15.1958, 488.6263, -45.5129> }
					triangle { <17.8952, 490.1898, -42.9378>, <18.3804, 488.747, -46.7265>, <16.8139, 489.5572, -44.4108> }
					triangle { <16.5704, 489.413, -43.02898>, <16.8139, 489.5572, -44.4108>, <15.2415, 488.8627, -44.239> }
					triangle { <17.8952, 490.1898, -42.9378>, <16.8139, 489.5572, -44.4108>, <16.5704, 489.413, -43.02898> }
					material { txgilia_flower }}
				}
			}
		}
	union { // internode
		cylinder { <18.2664, 68.7649, -2.4003>, <24.9412, 83.4218, 1.3285>, 0.5 }
		cylinder { <24.9412, 83.4218, 1.3285>, <32.369, 95.6284, 9.6416>, 0.5 }
		cylinder { <32.369, 95.6284, 9.6416>, <39.7998, 104.1526, 21.6999>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <39.7998, 104.1526, 21.6999>, <42.8784, 105.8368, 28.5702>, 0.4999 }
			cylinder { <42.8784, 105.8368, 28.5702>, <45.208, 105.0304, 35.8802>, 0.4999 }
			cylinder { <45.208, 105.0304, 35.8802>, <46.5161, 101.8275, 42.7755>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <46.5161, 101.8275, 42.7755>, <47.03181, 100.4151, 45.6456>, 0.4999 }
				cylinder { <47.03181, 100.4151, 45.6456>, <47.5134, 98.9364, 48.4881>, 0.4999 }
				cylinder { <47.5134, 98.9364, 48.4881>, <47.9606, 97.3922, 51.3013>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <47.9606, 97.3922, 51.3013>, <47.8961, 97.1621, 51.8703>, 0.03999 }
				cylinder { <47.8961, 97.1621, 51.8703>, <47.6867, 97.01275, 52.4313>, 0.03999 }
				cylinder { <47.6867, 97.01275, 52.4313>, <47.3475, 96.9548, 52.9436>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <47.3475, 96.9548, 52.9436>, <32.9318, 92.9513, 77.06596>, <30.7846, 92.7998, 76.01572> }
				triangle { <32.9318, 92.9513, 77.06596>, <29.366, 82.1911, 80.8463>, <30.7846, 92.7998, 76.01572> }
				triangle { <32.9318, 92.9513, 77.06596>, <31.7798, 84.2409, 81.2775>, <29.366, 82.1911, 80.8463> }
				triangle { <29.366, 82.1911, 80.8463>, <27.6999, 84.7643, 78.7522>, <30.7846, 92.7998, 76.01572> }
				triangle { <30.7846, 92.7998, 76.01572>, <36.4266, 93.01698, 66.1144>, <47.3475, 96.9548, 52.9436> }
				triangle { <47.3475, 96.9548, 52.9436>, <40.03843, 92.7274, 68.364>, <32.9318, 92.9513, 77.06596> }
				triangle { <40.03843, 92.7274, 68.364>, <35.4855, 89.9592, 77.8054>, <32.9318, 92.9513, 77.06596> }
				triangle { <35.4855, 89.9592, 77.8054>, <31.7798, 84.2409, 81.2775>, <32.9318, 92.9513, 77.06596> }
				triangle { <30.7846, 92.7998, 76.01572>, <27.6999, 84.7643, 78.7522>, <29.2889, 89.256, 74.7889> }
				triangle { <29.2889, 89.256, 74.7889>, <36.4266, 93.01698, 66.1144>, <30.7846, 92.7998, 76.01572> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <47.9606, 97.3922, 51.3013>, <48.04584, 97.09814, 51.8371>, 0.03999 }
				cylinder { <48.04584, 97.09814, 51.8371>, <48.131, 96.804, 52.373>, 0.03999 }
				cylinder { <48.131, 96.804, 52.373>, <48.2162, 96.5099, 52.9088>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <48.2162, 96.5099, 52.9088>, <53.6035, 82.1149, 76.7727>, <51.3472, 81.3812, 77.1004> }
				triangle { <53.6035, 82.1149, 76.7727>, <55.1411, 70.2684, 77.0602>, <51.3472, 81.3812, 77.1004> }
				triangle { <53.6035, 82.1149, 76.7727>, <56.8858, 72.942, 76.9129>, <55.1411, 70.2684, 77.0602> }
				triangle { <55.1411, 70.2684, 77.0602>, <52.1243, 72.3909, 77.4795>, <51.3472, 81.3812, 77.1004> }
				triangle { <51.3472, 81.3812, 77.1004>, <49.1653, 85.9049, 66.8686>, <48.2162, 96.5099, 52.9088> }
				triangle { <48.2162, 96.5099, 52.9088>, <53.3609, 86.5455, 66.4486>, <53.6035, 82.1149, 76.7727> }
				triangle { <53.3609, 86.5455, 66.4486>, <56.4823, 80.2534, 74.7068>, <53.6035, 82.1149, 76.7727> }
				triangle { <56.4823, 80.2534, 74.7068>, <56.8858, 72.942, 76.9129>, <53.6035, 82.1149, 76.7727> }
				triangle { <51.3472, 81.3812, 77.1004>, <52.1243, 72.3909, 77.4795>, <50.02402, 77.8944, 75.5539> }
				triangle { <50.02402, 77.8944, 75.5539>, <49.1653, 85.9049, 66.8686>, <51.3472, 81.3812, 77.1004> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <39.7998, 104.1526, 21.6999>, <46.2086, 109.6959, 33.9348>, 0.4501 }
		cylinder { <46.2086, 109.6959, 33.9348>, <52.1478, 112.9449, 47.1887>, 0.4501 }
		cylinder { <52.1478, 112.9449, 47.1887>, <57.4423, 113.8042, 61.07117>, 0.4501 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <57.4423, 113.8042, 61.07117>, <57.9518, 113.2427, 63.06083>, 0.138 }
			cylinder { <57.9518, 113.2427, 63.06083>, <58.1538, 112.0623, 64.8213>, 0.138 }
			cylinder { <58.1538, 112.0623, 64.8213>, <58.02461, 110.401, 66.1469>, 0.138 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <58.02461, 110.401, 66.1469>, <57.9703, 109.7033, 66.7037>, 0.138 }
				cylinder { <57.9703, 109.7033, 66.7037>, <57.916, 109.0056, 67.2604>, 0.138 }
				cylinder { <57.916, 109.0056, 67.2604>, <57.8618, 108.3079, 67.8172>, 0.138 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <57.8618, 108.3079, 67.8172>, <57.8479, 108.2766, 67.8494>, 0.003047 }
				cylinder { <57.8479, 108.2766, 67.8494>, <57.8239, 108.2529, 67.8822>, 0.003047 }
				cylinder { <57.8239, 108.2529, 67.8822>, <57.7916, 108.2387, 67.9133>, 0.003047 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <57.7916, 108.2387, 67.9133>, <52.667, 105.4141, 73.1227>, <52.1296, 105.5807, 72.7755> }
				triangle { <52.667, 105.4141, 73.1227>, <51.2058, 102.4743, 72.8064>, <52.1296, 105.5807, 72.7755> }
				triangle { <52.667, 105.4141, 73.1227>, <51.9007, 102.8378, 73.2104>, <51.2058, 102.4743, 72.8064> }
				triangle { <51.2058, 102.4743, 72.8064>, <50.9284, 103.4133, 72.5045>, <52.1296, 105.5807, 72.7755> }
				triangle { <52.1296, 105.5807, 72.7755>, <54.1159, 106.3928, 70.475>, <57.7916, 108.2387, 67.9133> }
				triangle { <57.7916, 108.2387, 67.9133>, <54.9812, 105.9257, 71.1221>, <52.667, 105.4141, 73.1227> }
				triangle { <54.9812, 105.9257, 71.1221>, <53.234, 104.4677, 73.06508>, <52.667, 105.4141, 73.1227> }
				triangle { <53.234, 104.4677, 73.06508>, <51.9007, 102.8378, 73.2104>, <52.667, 105.4141, 73.1227> }
				triangle { <52.1296, 105.5807, 72.7755>, <50.9284, 103.4133, 72.5045>, <51.6747, 104.88, 72.03811> }
				triangle { <51.6747, 104.88, 72.03811>, <54.1159, 106.3928, 70.475>, <52.1296, 105.5807, 72.7755> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <57.8618, 108.3079, 67.8172>, <57.8589, 108.2712, 67.8465>, 0.003047 }
				cylinder { <57.8589, 108.2712, 67.8465>, <57.8561, 108.2345, 67.8757>, 0.003047 }
				cylinder { <57.8561, 108.2345, 67.8757>, <57.8532, 108.1978, 67.905>, 0.003047 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <57.8532, 108.1978, 67.905>, <57.785, 101.8799, 72.5372>, <57.1376, 101.7635, 72.4714> }
				triangle { <57.785, 101.8799, 72.5372>, <57.8317, 98.7919, 71.3796>, <57.1376, 101.7635, 72.4714> }
				triangle { <57.785, 101.8799, 72.5372>, <58.3908, 99.4024, 71.6843>, <57.8317, 98.7919, 71.3796> }
				triangle { <57.8317, 98.7919, 71.3796>, <57.0603, 99.4213, 71.6216>, <57.1376, 101.7635, 72.4714> }
				triangle { <57.1376, 101.7635, 72.4714>, <57.1519, 104.0508, 70.3115>, <57.8532, 108.1978, 67.905> }
				triangle { <57.8532, 108.1978, 67.905>, <58.3254, 104.0651, 70.4036>, <57.785, 101.8799, 72.5372> }
				triangle { <58.3254, 104.0651, 70.4036>, <58.6024, 101.4911, 71.9038>, <57.785, 101.8799, 72.5372> }
				triangle { <58.6024, 101.4911, 71.9038>, <58.3908, 99.4024, 71.6843>, <57.785, 101.8799, 72.5372> }
				triangle { <57.1376, 101.7635, 72.4714>, <57.0603, 99.4213, 71.6216>, <56.7457, 101.1021, 71.6647> }
				triangle { <56.7457, 101.1021, 71.6647>, <57.1519, 104.0508, 70.3115>, <57.1376, 101.7635, 72.4714> }
				material { txgilia_leaf }}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <57.4423, 113.8042, 61.07117>, <58.2432, 113.9841, 62.8216>, 0.2192 }
			cylinder { <58.2432, 113.9841, 62.8216>, <59.1528, 114.2312, 64.5095>, 0.2192 }
			cylinder { <59.1528, 114.2312, 64.5095>, <60.1663, 114.5443, 66.1259>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <60.1663, 114.5443, 66.1259>, <61.2782, 114.9215, 67.6619>, 0.2192 }
			cylinder { <61.2782, 114.9215, 67.6619>, <62.4823, 115.361, 69.1092>, 0.2192 }
			cylinder { <62.4823, 115.361, 69.1092>, <63.7723, 115.8602, 70.4599>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <63.7723, 115.8602, 70.4599>, <64.9529, 116.3983, 71.8932>, 0.2192 }
			cylinder { <64.9529, 116.3983, 71.8932>, <66.01798, 116.9724, 73.4012>, 0.2192 }
			cylinder { <66.01798, 116.9724, 73.4012>, <66.9615, 117.5792, 74.9757>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <66.9615, 117.5792, 74.9757>, <68.05674, 118.5605, 77.4752>, 0.2192 }
				cylinder { <68.05674, 118.5605, 77.4752>, <68.8153, 119.5979, 80.07492>, 0.2192 }
				cylinder { <68.8153, 119.5979, 80.07492>, <69.2258, 120.676, 82.7355>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <69.2258, 120.676, 82.7355>, <70.5439, 123.7043, 93.626>, <72.04397, 123.6823, 93.2602> }
					triangle { <69.2258, 120.676, 82.7355>, <69.152, 122.6219, 88.692>, <70.5439, 123.7043, 93.626> }
					triangle { <72.04397, 123.6823, 93.2602>, <71.2232, 123.5139, 88.4408>, <69.2258, 120.676, 82.7355> }
					triangle { <69.152, 122.6219, 88.692>, <70.1318, 122.2148, 94.2931>, <70.5439, 123.7043, 93.626> }
					triangle { <70.1318, 122.2148, 94.2931>, <71.5532, 120.3182, 95.7019>, <70.5439, 123.7043, 93.626> }
					triangle { <72.04397, 123.6823, 93.2602>, <73.7403, 123.1825, 93.9173>, <73.09849, 124.7828, 92.7948> }
					triangle { <73.09849, 124.7828, 92.7948>, <71.2232, 123.5139, 88.4408>, <72.04397, 123.6823, 93.2602> }
					triangle { <71.5532, 120.3182, 95.7019>, <71.7852, 120.8891, 95.7213>, <72.1104, 122.8891, 94.431> }
					triangle { <71.7852, 120.8891, 95.7213>, <73.7708, 119.0985, 95.2809>, <74.1788, 122.3092, 94.7766> }
					triangle { <72.1104, 122.8891, 94.431>, <74.1788, 122.3092, 94.7766>, <73.7403, 123.1825, 93.9173> }
					triangle { <72.1104, 122.8891, 94.431>, <71.7852, 120.8891, 95.7213>, <74.1788, 122.3092, 94.7766> }
					triangle { <70.5439, 123.7043, 93.626>, <71.5532, 120.3182, 95.7019>, <72.1104, 122.8891, 94.431> }
					triangle { <72.04397, 123.6823, 93.2602>, <72.1104, 122.8891, 94.431>, <73.7403, 123.1825, 93.9173> }
					triangle { <70.5439, 123.7043, 93.626>, <72.1104, 122.8891, 94.431>, <72.04397, 123.6823, 93.2602> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <69.2258, 120.676, 82.7355>, <71.9437, 124.1944, 93.2114>, <72.2916, 125.5099, 92.4815> }
					triangle { <69.2258, 120.676, 82.7355>, <70.2104, 121.9976, 88.7816>, <71.9437, 124.1944, 93.2114> }
					triangle { <72.2916, 125.5099, 92.4815>, <70.03268, 124.2162, 88.3399>, <69.2258, 120.676, 82.7355> }
					triangle { <70.2104, 121.9976, 88.7816>, <73.3476, 123.2785, 93.3659>, <71.9437, 124.1944, 93.2114> }
					triangle { <73.3476, 123.2785, 93.3659>, <76.01962, 123.9337, 93.5478>, <71.9437, 124.1944, 93.2114> }
					triangle { <72.2916, 125.5099, 92.4815>, <73.5549, 126.9102, 92.4355>, <71.5121, 126.8698, 92.194> }
					triangle { <71.5121, 126.8698, 92.194>, <70.03268, 124.2162, 88.3399>, <72.2916, 125.5099, 92.4815> }
					triangle { <76.01962, 123.9337, 93.5478>, <75.6274, 124.3793, 93.7142>, <73.4933, 125.3628, 93.2152> }
					triangle { <75.6274, 124.3793, 93.7142>, <77.578, 125.4054, 92.1379>, <74.8076, 127.037, 92.7638> }
					triangle { <73.4933, 125.3628, 93.2152>, <74.8076, 127.037, 92.7638>, <73.5549, 126.9102, 92.4355> }
					triangle { <73.4933, 125.3628, 93.2152>, <75.6274, 124.3793, 93.7142>, <74.8076, 127.037, 92.7638> }
					triangle { <71.9437, 124.1944, 93.2114>, <76.01962, 123.9337, 93.5478>, <73.4933, 125.3628, 93.2152> }
					triangle { <72.2916, 125.5099, 92.4815>, <73.4933, 125.3628, 93.2152>, <73.5549, 126.9102, 92.4355> }
					triangle { <71.9437, 124.1944, 93.2114>, <73.4933, 125.3628, 93.2152>, <72.2916, 125.5099, 92.4815> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <69.2258, 120.676, 82.7355>, <71.8096, 125.6233, 92.6532>, <70.5023, 126.4036, 92.3955> }
					triangle { <69.2258, 120.676, 82.7355>, <71.1178, 122.7117, 88.3523>, <71.8096, 125.6233, 92.6532> }
					triangle { <70.5023, 126.4036, 92.3955>, <69.01179, 123.4128, 88.823>, <69.2258, 120.676, 82.7355> }
					triangle { <71.1178, 122.7117, 88.3523>, <73.1024, 126.5382, 92.083>, <71.8096, 125.6233, 92.6532> }
					triangle { <73.1024, 126.5382, 92.083>, <73.5106, 129.2483, 91.7815>, <71.8096, 125.6233, 92.6532> }
					triangle { <70.5023, 126.4036, 92.3955>, <69.7262, 128.1173, 92.5372>, <68.9843, 126.2233, 92.846> }
					triangle { <68.9843, 126.2233, 92.846>, <69.01179, 123.4128, 88.823>, <70.5023, 126.4036, 92.3955> }
					triangle { <73.5106, 129.2483, 91.7815>, <73.08367, 129.0911, 92.1976>, <71.3429, 127.507, 92.6782> }
					triangle { <73.08367, 129.0911, 92.1976>, <72.1685, 131.123, 90.6559>, <70.1757, 129.3384, 92.5461> }
					triangle { <71.3429, 127.507, 92.6782>, <70.1757, 129.3384, 92.5461>, <69.7262, 128.1173, 92.5372> }
					triangle { <71.3429, 127.507, 92.6782>, <73.08367, 129.0911, 92.1976>, <70.1757, 129.3384, 92.5461> }
					triangle { <71.8096, 125.6233, 92.6532>, <73.5106, 129.2483, 91.7815>, <71.3429, 127.507, 92.6782> }
					triangle { <70.5023, 126.4036, 92.3955>, <71.3429, 127.507, 92.6782>, <69.7262, 128.1173, 92.5372> }
					triangle { <71.8096, 125.6233, 92.6532>, <71.3429, 127.507, 92.6782>, <70.5023, 126.4036, 92.3955> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <69.2258, 120.676, 82.7355>, <70.3256, 126.0297, 92.7175>, <69.132, 125.1367, 93.1202> }
					triangle { <69.2258, 120.676, 82.7355>, <70.6288, 123.784, 87.9932>, <70.3256, 126.0297, 92.7175> }
					triangle { <69.132, 125.1367, 93.1202>, <69.5619, 122.2065, 89.2269>, <69.2258, 120.676, 82.7355> }
					triangle { <70.6288, 123.784, 87.9932>, <69.7328, 127.5196, 92.2053>, <70.3256, 126.0297, 92.7175> }
					triangle { <69.7328, 127.5196, 92.2053>, <67.4701, 128.967, 92.8275>, <70.3256, 126.0297, 92.7175> }
					triangle { <69.132, 125.1367, 93.1202>, <67.5095, 125.1468, 94.08287>, <68.9847, 123.7307, 93.8559> }
					triangle { <68.9847, 123.7307, 93.8559>, <69.5619, 122.2065, 89.2269>, <69.132, 125.1367, 93.1202> }
					triangle { <67.4701, 128.967, 92.8275>, <67.6455, 128.557, 93.2531>, <68.611, 126.3784, 93.5571> }
					triangle { <67.6455, 128.557, 93.2531>, <64.9675, 128.4031, 92.8691>, <66.641, 126.0544, 94.4222> }
					triangle { <68.611, 126.3784, 93.5571>, <66.641, 126.0544, 94.4222>, <67.5095, 125.1468, 94.08287> }
					triangle { <68.611, 126.3784, 93.5571>, <67.6455, 128.557, 93.2531>, <66.641, 126.0544, 94.4222> }
					triangle { <70.3256, 126.0297, 92.7175>, <67.4701, 128.967, 92.8275>, <68.611, 126.3784, 93.5571> }
					triangle { <69.132, 125.1367, 93.1202>, <68.611, 126.3784, 93.5571>, <67.5095, 125.1468, 94.08287> }
					triangle { <70.3256, 126.0297, 92.7175>, <68.611, 126.3784, 93.5571>, <69.132, 125.1367, 93.1202> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <69.2258, 120.676, 82.7355>, <69.5316, 124.8258, 93.3278>, <70.09924, 123.4294, 93.6628> }
					triangle { <69.2258, 120.676, 82.7355>, <69.3955, 123.7276, 88.2064>, <69.5316, 124.8258, 93.3278> }
					triangle { <70.09924, 123.4294, 93.6628>, <70.9493, 122.2699, 88.9871>, <69.2258, 120.676, 82.7355> }
					triangle { <69.3955, 123.7276, 88.2064>, <67.8692, 124.8073, 93.5918>, <69.5316, 124.8258, 93.3278> }
					triangle { <67.8692, 124.8073, 93.5918>, <66.2422, 123.3647, 95.287>, <69.5316, 124.8258, 93.3278> }
					triangle { <70.09924, 123.4294, 93.6628>, <70.02785, 122.0509, 94.9487>, <71.5658, 122.827, 93.8238> }
					triangle { <71.5658, 122.827, 93.8238>, <70.9493, 122.2699, 88.9871>, <70.09924, 123.4294, 93.6628> }
					triangle { <66.2422, 123.3647, 95.287>, <66.831, 123.4113, 95.4638>, <69.09248, 123.4813, 94.6567> }
					triangle { <66.831, 123.4113, 95.4638>, <65.9728, 120.8594, 95.7706>, <69.1524, 121.6445, 95.8215> }
					triangle { <69.09248, 123.4813, 94.6567>, <69.1524, 121.6445, 95.8215>, <70.02785, 122.0509, 94.9487> }
					triangle { <69.09248, 123.4813, 94.6567>, <66.831, 123.4113, 95.4638>, <69.1524, 121.6445, 95.8215> }
					triangle { <69.5316, 124.8258, 93.3278>, <66.2422, 123.3647, 95.287>, <69.09248, 123.4813, 94.6567> }
					triangle { <70.09924, 123.4294, 93.6628>, <69.09248, 123.4813, 94.6567>, <70.02785, 122.0509, 94.9487> }
					triangle { <69.5316, 124.8258, 93.3278>, <69.09248, 123.4813, 94.6567>, <70.09924, 123.4294, 93.6628> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <66.9615, 117.5792, 74.9757>, <67.9905, 118.0731, 76.5362>, 0.2192 }
			cylinder { <67.9905, 118.0731, 76.5362>, <69.09928, 118.4513, 78.07418>, 0.2192 }
			cylinder { <69.09928, 118.4513, 78.07418>, <70.2818, 118.7118, 79.5812>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <70.2818, 118.7118, 79.5812>, <72.2186, 118.8041, 81.7377>, 0.2192 }
				cylinder { <72.2186, 118.8041, 81.7377>, <74.2892, 118.5965, 83.7575>, 0.2192 }
				cylinder { <74.2892, 118.5965, 83.7575>, <76.4624, 118.0921, 85.6103>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <76.4624, 118.0921, 85.6103>, <85.5721, 116.6851, 92.2728>, <84.9857, 117.9011, 93.02057> }
					triangle { <76.4624, 118.0921, 85.6103>, <81.4907, 116.5189, 88.9963>, <85.5721, 116.6851, 92.2728> }
					triangle { <84.9857, 117.9011, 93.02057>, <80.6448, 117.6196, 90.7894>, <76.4624, 118.0921, 85.6103> }
					triangle { <81.4907, 116.5189, 88.9963>, <86.7109, 117.2353, 91.1635>, <85.5721, 116.6851, 92.2728> }
					triangle { <86.7109, 117.2353, 91.1635>, <88.3628, 119.4395, 91.09011>, <85.5721, 116.6851, 92.2728> }
					triangle { <84.9857, 117.9011, 93.02057>, <85.4699, 119.5084, 93.879>, <84.04556, 118.0844, 94.293> }
					triangle { <84.04556, 118.0844, 94.293>, <80.6448, 117.6196, 90.7894>, <84.9857, 117.9011, 93.02057> }
					triangle { <88.3628, 119.4395, 91.09011>, <88.1725, 119.272, 91.6516>, <86.3107, 118.375, 92.8734> }
					triangle { <88.1725, 119.272, 91.6516>, <87.9619, 121.9569, 91.3669>, <86.4642, 120.3416, 93.7885> }
					triangle { <86.3107, 118.375, 92.8734>, <86.4642, 120.3416, 93.7885>, <85.4699, 119.5084, 93.879> }
					triangle { <86.3107, 118.375, 92.8734>, <88.1725, 119.272, 91.6516>, <86.4642, 120.3416, 93.7885> }
					triangle { <85.5721, 116.6851, 92.2728>, <88.3628, 119.4395, 91.09011>, <86.3107, 118.375, 92.8734> }
					triangle { <84.9857, 117.9011, 93.02057>, <86.3107, 118.375, 92.8734>, <85.4699, 119.5084, 93.879> }
					triangle { <85.5721, 116.6851, 92.2728>, <86.3107, 118.375, 92.8734>, <84.9857, 117.9011, 93.02057> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <76.4624, 118.0921, 85.6103>, <84.804, 117.5114, 93.3197>, <83.6687, 117.0205, 94.2425> }
					triangle { <76.4624, 118.0921, 85.6103>, <81.5849, 117.7303, 89.1954>, <84.804, 117.5114, 93.3197> }
					triangle { <83.6687, 117.0205, 94.2425>, <80.5388, 116.2568, 90.5654>, <76.4624, 118.0921, 85.6103> }
					triangle { <81.5849, 117.7303, 89.1954>, <84.9886, 119.1701, 93.5315>, <84.804, 117.5114, 93.3197> }
					triangle { <84.9886, 119.1701, 93.5315>, <84.5201, 120.8657, 95.6524>, <84.804, 117.5114, 93.3197> }
					triangle { <83.6687, 117.0205, 94.2425>, <82.9985, 117.1621, 95.9991>, <83.1232, 115.5896, 94.6802> }
					triangle { <83.1232, 115.5896, 94.6802>, <80.5388, 116.2568, 90.5654>, <83.6687, 117.0205, 94.2425> }
					triangle { <84.5201, 120.8657, 95.6524>, <84.609, 120.2748, 95.8027>, <84.202, 118.0179, 95.09263> }
					triangle { <84.609, 120.2748, 95.8027>, <82.4983, 121.2706, 97.1766>, <83.06104, 118.0542, 96.9433> }
					triangle { <84.202, 118.0179, 95.09263>, <83.06104, 118.0542, 96.9433>, <82.9985, 117.1621, 95.9991> }
					triangle { <84.202, 118.0179, 95.09263>, <84.609, 120.2748, 95.8027>, <83.06104, 118.0542, 96.9433> }
					triangle { <84.804, 117.5114, 93.3197>, <84.5201, 120.8657, 95.6524>, <84.202, 118.0179, 95.09263> }
					triangle { <83.6687, 117.0205, 94.2425>, <84.202, 118.0179, 95.09263>, <82.9985, 117.1621, 95.9991> }
					triangle { <84.804, 117.5114, 93.3197>, <84.202, 118.0179, 95.09263>, <83.6687, 117.0205, 94.2425> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <76.4624, 118.0921, 85.6103>, <83.8763, 116.5617, 94.09837>, <83.6192, 115.0678, 93.8096> }
					triangle { <76.4624, 118.0921, 85.6103>, <80.8181, 118.0321, 90.1101>, <83.8763, 116.5617, 94.09837> }
					triangle { <83.6192, 115.0678, 93.8096>, <81.4016, 115.9172, 89.5363>, <76.4624, 118.0921, 85.6103> }
					triangle { <80.8181, 118.0321, 90.1101>, <82.8533, 117.0522, 95.3405>, <83.8763, 116.5617, 94.09837> }
					triangle { <82.8533, 117.0522, 95.3405>, <81.6952, 115.7322, 97.4641>, <83.8763, 116.5617, 94.09837> }
					triangle { <83.6192, 115.0678, 93.8096>, <83.371, 113.3997, 94.6527>, <84.3484, 113.9568, 92.9317> }
					triangle { <84.3484, 113.9568, 92.9317>, <81.4016, 115.9172, 89.5363>, <83.6192, 115.0678, 93.8096> }
					triangle { <81.6952, 115.7322, 97.4641>, <82.2039, 115.4692, 97.2366>, <83.4165, 115.04, 95.2096> }
					triangle { <82.2039, 115.4692, 97.2366>, <80.3026, 113.5885, 97.6637>, <82.941, 113.0065, 95.8153> }
					triangle { <83.4165, 115.04, 95.2096>, <82.941, 113.0065, 95.8153>, <83.371, 113.3997, 94.6527> }
					triangle { <83.4165, 115.04, 95.2096>, <82.2039, 115.4692, 97.2366>, <82.941, 113.0065, 95.8153> }
					triangle { <83.8763, 116.5617, 94.09837>, <81.6952, 115.7322, 97.4641>, <83.4165, 115.04, 95.2096> }
					triangle { <83.6192, 115.0678, 93.8096>, <83.4165, 115.04, 95.2096>, <83.371, 113.3997, 94.6527> }
					triangle { <83.8763, 116.5617, 94.09837>, <83.4165, 115.04, 95.2096>, <83.6192, 115.0678, 93.8096> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <76.4624, 118.0921, 85.6103>, <84.06246, 115.1397, 93.5399>, <84.9051, 114.7232, 92.316> }
					triangle { <76.4624, 118.0921, 85.6103>, <80.2428, 117.0101, 90.4849>, <84.06246, 115.1397, 93.5399> }
					triangle { <84.9051, 114.7232, 92.316>, <82.04881, 117.067, 89.1147>, <76.4624, 118.0921, 85.6103> }
					triangle { <80.2428, 117.0101, 90.4849>, <83.2361, 113.7887, 94.1074>, <84.06246, 115.1397, 93.5399> }
					triangle { <83.2361, 113.7887, 94.1074>, <83.7657, 111.0854, 94.03836>, <84.06246, 115.1397, 93.5399> }
					triangle { <84.9051, 114.7232, 92.316>, <86.07609, 113.3855, 91.688>, <86.03945, 115.4273, 91.4474> }
					triangle { <86.03945, 115.4273, 91.4474>, <82.04881, 117.067, 89.1147>, <84.9051, 114.7232, 92.316> }
					triangle { <83.7657, 111.0854, 94.03836>, <84.2585, 111.4515, 93.9852>, <85.03239, 113.5289, 93.06384> }
					triangle { <84.2585, 111.4515, 93.9852>, <84.3887, 109.4553, 92.1597>, <86.2689, 112.1271, 91.953> }
					triangle { <85.03239, 113.5289, 93.06384>, <86.2689, 112.1271, 91.953>, <86.07609, 113.3855, 91.688> }
					triangle { <85.03239, 113.5289, 93.06384>, <84.2585, 111.4515, 93.9852>, <86.2689, 112.1271, 91.953> }
					triangle { <84.06246, 115.1397, 93.5399>, <83.7657, 111.0854, 94.03836>, <85.03239, 113.5289, 93.06384> }
					triangle { <84.9051, 114.7232, 92.316>, <85.03239, 113.5289, 93.06384>, <86.07609, 113.3855, 91.688> }
					triangle { <84.06246, 115.1397, 93.5399>, <85.03239, 113.5289, 93.06384>, <84.9051, 114.7232, 92.316> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <76.4624, 118.0921, 85.6103>, <85.1263, 115.2171, 92.3946>, <85.7624, 116.5007, 91.821> }
					triangle { <76.4624, 118.0921, 85.6103>, <80.6648, 116.0608, 89.7861>, <85.1263, 115.2171, 92.3946> }
					triangle { <85.7624, 116.5007, 91.821>, <81.574, 118.135, 89.9008>, <76.4624, 118.0921, 85.6103> }
					triangle { <80.6648, 116.0608, 89.7861>, <85.6561, 113.9036, 91.4869>, <85.1263, 115.2171, 92.3946> }
					triangle { <85.6561, 113.9036, 91.4869>, <87.9487, 113.4113, 90.03956>, <85.1263, 115.2171, 92.3946> }
					triangle { <85.7624, 116.5007, 91.821>, <87.3928, 117.2179, 91.2026>, <85.8494, 118.0167, 92.3015> }
					triangle { <85.8494, 118.0167, 92.3015>, <81.574, 118.135, 89.9008>, <85.7624, 116.5007, 91.821> }
					triangle { <87.9487, 113.4113, 90.03956>, <88.00301, 113.8372, 90.4814>, <86.848, 115.6212, 91.5982> }
					triangle { <88.00301, 113.8372, 90.4814>, <89.1938, 114.7054, 88.2093>, <88.4792, 116.7289, 90.6814> }
					triangle { <86.848, 115.6212, 91.5982>, <88.4792, 116.7289, 90.6814>, <87.3928, 117.2179, 91.2026> }
					triangle { <86.848, 115.6212, 91.5982>, <88.00301, 113.8372, 90.4814>, <88.4792, 116.7289, 90.6814> }
					triangle { <85.1263, 115.2171, 92.3946>, <87.9487, 113.4113, 90.03956>, <86.848, 115.6212, 91.5982> }
					triangle { <85.7624, 116.5007, 91.821>, <86.848, 115.6212, 91.5982>, <87.3928, 117.2179, 91.2026> }
					triangle { <85.1263, 115.2171, 92.3946>, <86.848, 115.6212, 91.5982>, <85.7624, 116.5007, 91.821> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <70.2818, 118.7118, 79.5812>, <71.4677, 119.1107, 81.05516>, 0.2192 }
			cylinder { <71.4677, 119.1107, 81.05516>, <72.6505, 119.6457, 82.4878>, 0.2192 }
			cylinder { <72.6505, 119.6457, 82.4878>, <73.8238, 120.3141, 83.8715>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <73.8238, 120.3141, 83.8715>, <75.5387, 121.6372, 85.7998>, 0.2192 }
				cylinder { <75.5387, 121.6372, 85.7998>, <77.1828, 123.261, 87.5519>, 0.2192 }
				cylinder { <77.1828, 123.261, 87.5519>, <78.7315, 125.1612, 89.1014>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <78.7315, 125.1612, 89.1014>, <83.6735, 132.9426, 95.7634>, <84.2066, 131.7005, 96.5079> }
					triangle { <78.7315, 125.1612, 89.1014>, <81.3722, 129.9755, 92.1135>, <83.6735, 132.9426, 95.7634> }
					triangle { <84.2066, 131.7005, 96.5079>, <82.9777, 128.5998, 92.9335>, <78.7315, 125.1612, 89.1014> }
					triangle { <81.3722, 129.9755, 92.1135>, <82.2686, 133.4645, 96.5275>, <83.6735, 132.9426, 95.7634> }
					triangle { <82.2686, 133.4645, 96.5275>, <81.3567, 133.2948, 99.1222>, <83.6735, 132.9426, 95.7634> }
					triangle { <84.2066, 131.7005, 96.5079>, <84.5474, 131.0188, 98.2325>, <85.5536, 130.8528, 96.447> }
					triangle { <85.5536, 130.8528, 96.447>, <82.9777, 128.5998, 92.9335>, <84.2066, 131.7005, 96.5079> }
					triangle { <81.3567, 133.2948, 99.1222>, <81.9677, 133.2527, 99.05489>, <83.7005, 132.4038, 97.6264> }
					triangle { <81.9677, 133.2527, 99.05489>, <81.09503, 131.3552, 100.7788>, <84.0724, 131.2369, 99.4232> }
					triangle { <83.7005, 132.4038, 97.6264>, <84.0724, 131.2369, 99.4232>, <84.5474, 131.0188, 98.2325> }
					triangle { <83.7005, 132.4038, 97.6264>, <81.9677, 133.2527, 99.05489>, <84.0724, 131.2369, 99.4232> }
					triangle { <83.6735, 132.9426, 95.7634>, <81.3567, 133.2948, 99.1222>, <83.7005, 132.4038, 97.6264> }
					triangle { <84.2066, 131.7005, 96.5079>, <83.7005, 132.4038, 97.6264>, <84.5474, 131.0188, 98.2325> }
					triangle { <83.6735, 132.9426, 95.7634>, <83.7005, 132.4038, 97.6264>, <84.2066, 131.7005, 96.5079> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <78.7315, 125.1612, 89.1014>, <84.6193, 131.8116, 96.205>, <85.8318, 131.2558, 95.4289> }
					triangle { <78.7315, 125.1612, 89.1014>, <81.2542, 129.2602, 93.1086>, <84.6193, 131.8116, 96.205> }
					triangle { <85.8318, 131.2558, 95.4289>, <83.1104, 129.4046, 91.814>, <78.7315, 125.1612, 89.1014> }
					triangle { <81.2542, 129.2602, 93.1086>, <84.3892, 130.875, 97.5835>, <84.6193, 131.8116, 96.205> }
					triangle { <84.3892, 130.875, 97.5835>, <86.0925, 129.3979, 99.1677>, <84.6193, 131.8116, 96.205> }
					triangle { <85.8318, 131.2558, 95.4289>, <87.5982, 130.6358, 95.653>, <86.6946, 131.7632, 94.1901> }
					triangle { <86.6946, 131.7632, 94.1901>, <83.1104, 129.4046, 91.814>, <85.8318, 131.2558, 95.4289> }
					triangle { <86.0925, 129.3979, 99.1677>, <86.3599, 129.847, 98.8414>, <86.3009, 131.0069, 96.7403> }
					triangle { <86.3599, 129.847, 98.8414>, <87.8325, 127.5804, 98.674>, <88.2719, 130.0956, 96.6254> }
					triangle { <86.3009, 131.0069, 96.7403>, <88.2719, 130.0956, 96.6254>, <87.5982, 130.6358, 95.653> }
					triangle { <86.3009, 131.0069, 96.7403>, <86.3599, 129.847, 98.8414>, <88.2719, 130.0956, 96.6254> }
					triangle { <84.6193, 131.8116, 96.205>, <86.0925, 129.3979, 99.1677>, <86.3009, 131.0069, 96.7403> }
					triangle { <85.8318, 131.2558, 95.4289>, <86.3009, 131.0069, 96.7403>, <87.5982, 130.6358, 95.653> }
					triangle { <84.6193, 131.8116, 96.205>, <86.3009, 131.0069, 96.7403>, <85.8318, 131.2558, 95.4289> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <78.7315, 125.1612, 89.1014>, <85.7646, 131.7127, 95.1817>, <85.8959, 132.4879, 93.8539> }
					triangle { <78.7315, 125.1612, 89.1014>, <82.1993, 128.4713, 93.1315>, <85.7646, 131.7127, 95.1817> }
					triangle { <85.8959, 132.4879, 93.8539>, <82.04729, 130.2921, 91.7883>, <78.7315, 125.1612, 89.1014> }
					triangle { <82.1993, 128.4713, 93.1315>, <87.02516, 130.6032, 95.2823>, <85.7646, 131.7127, 95.1817> }
					triangle { <87.02516, 130.6032, 95.2823>, <89.5834, 130.5551, 94.2596>, <85.7646, 131.7127, 95.1817> }
					triangle { <85.8959, 132.4879, 93.8539>, <87.1447, 133.3714, 92.7517>, <85.1865, 133.7722, 93.2339> }
					triangle { <85.1865, 133.7722, 93.2339>, <82.04729, 130.2921, 91.7883>, <85.8959, 132.4879, 93.8539> }
					triangle { <89.5834, 130.5551, 94.2596>, <89.3327, 131.1152, 94.3149>, <87.274, 132.3374, 94.1362> }
					triangle { <89.3327, 131.1152, 94.3149>, <90.5515, 130.8818, 91.9078>, <88.4276, 133.287, 92.5563> }
					triangle { <87.274, 132.3374, 94.1362>, <88.4276, 133.287, 92.5563>, <87.1447, 133.3714, 92.7517> }
					triangle { <87.274, 132.3374, 94.1362>, <89.3327, 131.1152, 94.3149>, <88.4276, 133.287, 92.5563> }
					triangle { <85.7646, 131.7127, 95.1817>, <89.5834, 130.5551, 94.2596>, <87.274, 132.3374, 94.1362> }
					triangle { <85.8959, 132.4879, 93.8539>, <87.274, 132.3374, 94.1362>, <87.1447, 133.3714, 92.7517> }
					triangle { <85.7646, 131.7127, 95.1817>, <87.274, 132.3374, 94.1362>, <85.8959, 132.4879, 93.8539> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <78.7315, 125.1612, 89.1014>, <85.5373, 132.7816, 94.09801>, <84.3109, 133.7056, 93.9447> }
					triangle { <78.7315, 125.1612, 89.1014>, <82.9102, 128.6917, 92.1507>, <85.5373, 132.7816, 94.09801> }
					triangle { <84.3109, 133.7056, 93.9447>, <81.2475, 130.0441, 92.8917>, <78.7315, 125.1612, 89.1014> }
					triangle { <82.9102, 128.6917, 92.1507>, <86.5582, 133.0221, 92.7827>, <85.5373, 132.7816, 94.09801> }
					triangle { <86.5582, 133.0221, 92.7827>, <87.03772, 135.178, 91.1349>, <85.5373, 132.7816, 94.09801> }
					triangle { <84.3109, 133.7056, 93.9447>, <83.8094, 135.4706, 93.5108>, <83.09933, 134.122, 94.891> }
					triangle { <83.09933, 134.122, 94.891>, <81.2475, 130.0441, 92.8917>, <84.3109, 133.7056, 93.9447> }
					triangle { <87.03772, 135.178, 91.1349>, <86.8056, 135.3166, 91.6886>, <85.2841, 134.5689, 93.3885> }
					triangle { <86.8056, 135.3166, 91.6886>, <85.5199, 136.7279, 89.7678>, <84.3257, 136.4304, 92.8013> }
					triangle { <85.2841, 134.5689, 93.3885>, <84.3257, 136.4304, 92.8013>, <83.8094, 135.4706, 93.5108> }
					triangle { <85.2841, 134.5689, 93.3885>, <86.8056, 135.3166, 91.6886>, <84.3257, 136.4304, 92.8013> }
					triangle { <85.5373, 132.7816, 94.09801>, <87.03772, 135.178, 91.1349>, <85.2841, 134.5689, 93.3885> }
					triangle { <84.3109, 133.7056, 93.9447>, <85.2841, 134.5689, 93.3885>, <83.8094, 135.4706, 93.5108> }
					triangle { <85.5373, 132.7816, 94.09801>, <85.2841, 134.5689, 93.3885>, <84.3109, 133.7056, 93.9447> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <78.7315, 125.1612, 89.1014>, <84.2255, 133.5532, 94.4629>, <83.2511, 133.2116, 95.6098> }
					triangle { <78.7315, 125.1612, 89.1014>, <82.3913, 129.6354, 91.512>, <84.2255, 133.5532, 94.4629> }
					triangle { <83.2511, 133.2116, 95.6098>, <81.8312, 128.9824, 93.6102>, <78.7315, 125.1612, 89.1014> }
					triangle { <82.3913, 129.6354, 91.512>, <83.5742, 134.8172, 93.5639>, <84.2255, 133.5532, 94.4629> }
					triangle { <83.5742, 134.8172, 93.5639>, <81.8766, 136.8967, 94.1855>, <84.2255, 133.5532, 94.4629> }
					triangle { <83.2511, 133.2116, 95.6098>, <82.18, 133.9947, 96.9493>, <83.3296, 132.2905, 96.9067> }
					triangle { <83.3296, 132.2905, 96.9067>, <81.8312, 128.9824, 93.6102>, <83.2511, 133.2116, 95.6098> }
					triangle { <81.8766, 136.8967, 94.1855>, <82.1851, 136.6575, 94.6622>, <83.04227, 134.6106, 95.5782> }
					triangle { <82.1851, 136.6575, 94.6622>, <79.5872, 137.0249, 95.3332>, <81.5934, 135.1443, 97.1093> }
					triangle { <83.04227, 134.6106, 95.5782>, <81.5934, 135.1443, 97.1093>, <82.18, 133.9947, 96.9493> }
					triangle { <83.04227, 134.6106, 95.5782>, <82.1851, 136.6575, 94.6622>, <81.5934, 135.1443, 97.1093> }
					triangle { <84.2255, 133.5532, 94.4629>, <81.8766, 136.8967, 94.1855>, <83.04227, 134.6106, 95.5782> }
					triangle { <83.2511, 133.2116, 95.6098>, <83.04227, 134.6106, 95.5782>, <82.18, 133.9947, 96.9493> }
					triangle { <84.2255, 133.5532, 94.4629>, <83.04227, 134.6106, 95.5782>, <83.2511, 133.2116, 95.6098> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <73.8238, 120.3141, 83.8715>, <74.9278, 120.8986, 85.347>, 0.2192 }
			cylinder { <74.9278, 120.8986, 85.347>, <75.9567, 121.396, 86.9064>, 0.2192 }
			cylinder { <75.9567, 121.396, 86.9064>, <76.9048, 121.8038, 88.5412>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <76.9048, 121.8038, 88.5412>, <78.1083, 122.1841, 91.1521>, 0.2192 }
				cylinder { <78.1083, 122.1841, 91.1521>, <79.07513, 122.3275, 93.8824>, 0.2192 }
				cylinder { <79.07513, 122.3275, 93.8824>, <79.7905, 122.2317, 96.6912>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <79.7905, 122.2317, 96.6912>, <83.2427, 120.7468, 107.4196>, <84.1976, 121.9096, 107.0805> }
					triangle { <79.7905, 122.2317, 96.6912>, <80.9392, 121.0482, 102.7297>, <83.2427, 120.7468, 107.4196> }
					triangle { <84.1976, 121.9096, 107.0805>, <81.8305, 123.117, 102.9799>, <79.7905, 122.2317, 96.6912> }
					triangle { <80.9392, 121.0482, 102.7297>, <84.05255, 119.2956, 107.1638>, <83.2427, 120.7468, 107.4196> }
					triangle { <84.05255, 119.2956, 107.1638>, <86.7073, 118.5715, 107.2763>, <83.2427, 120.7468, 107.4196> }
					triangle { <84.1976, 121.9096, 107.0805>, <85.9635, 122.5186, 107.3292>, <84.1521, 123.4881, 107.2815> }
					triangle { <84.1521, 123.4881, 107.2815>, <81.8305, 123.117, 102.9799>, <84.1976, 121.9096, 107.0805> }
					triangle { <86.7073, 118.5715, 107.2763>, <86.5572, 119.0717, 107.6027>, <85.1519, 121.0165, 107.6203> }
					triangle { <86.5572, 119.0717, 107.6027>, <88.842, 119.5208, 106.2227>, <87.1115, 121.9544, 107.5598> }
					triangle { <85.1519, 121.0165, 107.6203>, <87.1115, 121.9544, 107.5598>, <85.9635, 122.5186, 107.3292> }
					triangle { <85.1519, 121.0165, 107.6203>, <86.5572, 119.0717, 107.6027>, <87.1115, 121.9544, 107.5598> }
					triangle { <83.2427, 120.7468, 107.4196>, <86.7073, 118.5715, 107.2763>, <85.1519, 121.0165, 107.6203> }
					triangle { <84.1976, 121.9096, 107.0805>, <85.1519, 121.0165, 107.6203>, <85.9635, 122.5186, 107.3292> }
					triangle { <83.2427, 120.7468, 107.4196>, <85.1519, 121.0165, 107.6203>, <84.1976, 121.9096, 107.0805> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <79.7905, 122.2317, 96.6912>, <83.8144, 122.1716, 107.3226>, <83.03297, 123.4969, 107.4313> }
					triangle { <79.7905, 122.2317, 96.6912>, <82.09476, 121.3624, 102.4461>, <83.8144, 122.1716, 107.3226> }
					triangle { <83.03297, 123.4969, 107.4313>, <80.5306, 122.7635, 103.299>, <79.7905, 122.2317, 96.6912> }
					triangle { <82.09476, 121.3624, 102.4461>, <85.411, 122.521, 106.9278>, <83.8144, 122.1716, 107.3226> }
					triangle { <85.411, 122.521, 106.9278>, <87.03957, 124.6912, 107.4004>, <83.8144, 122.1716, 107.3226> }
					triangle { <83.03297, 123.4969, 107.4313>, <83.1302, 125.2388, 108.1437>, <81.5829, 123.9001, 107.9499> }
					triangle { <81.5829, 123.9001, 107.9499>, <80.5306, 122.7635, 103.299>, <83.03297, 123.4969, 107.4313> }
					triangle { <87.03957, 124.6912, 107.4004>, <86.5667, 124.6276, 107.7898>, <84.27, 123.9501, 107.945> }
					triangle { <86.5667, 124.6276, 107.7898>, <86.7803, 127.2108, 107.0101>, <84.09085, 126.0517, 108.469> }
					triangle { <84.27, 123.9501, 107.945>, <84.09085, 126.0517, 108.469>, <83.1302, 125.2388, 108.1437> }
					triangle { <84.27, 123.9501, 107.945>, <86.5667, 124.6276, 107.7898>, <84.09085, 126.0517, 108.469> }
					triangle { <83.8144, 122.1716, 107.3226>, <87.03957, 124.6912, 107.4004>, <84.27, 123.9501, 107.945> }
					triangle { <83.03297, 123.4969, 107.4313>, <84.27, 123.9501, 107.945>, <83.1302, 125.2388, 108.1437> }
					triangle { <83.8144, 122.1716, 107.3226>, <84.27, 123.9501, 107.945>, <83.03297, 123.4969, 107.4313> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <79.7905, 122.2317, 96.6912>, <82.6864, 123.167, 107.6438>, <81.1969, 122.8416, 107.8766> }
					triangle { <79.7905, 122.2317, 96.6912>, <82.1771, 122.5901, 102.467>, <82.6864, 123.167, 107.6438> }
					triangle { <81.1969, 122.8416, 107.8766>, <80.4379, 121.3824, 103.2755>, <79.7905, 122.2317, 96.6912> }
					triangle { <82.1771, 122.5901, 102.467>, <82.8783, 124.8374, 107.6519>, <82.6864, 123.167, 107.6438> }
					triangle { <82.8783, 124.8374, 107.6519>, <81.5119, 126.8872, 108.8833>, <82.6864, 123.167, 107.6438> }
					triangle { <81.1969, 122.8416, 107.8766>, <79.7143, 123.2956, 108.9475>, <80.3772, 121.5101, 108.1755> }
					triangle { <80.3772, 121.5101, 108.1755>, <80.4379, 121.3824, 103.2755>, <81.1969, 122.8416, 107.8766> }
					triangle { <81.5119, 126.8872, 108.8833>, <81.4543, 126.3353, 109.1502>, <81.2854, 123.9832, 108.7063> }
					triangle { <81.4543, 126.3353, 109.1502>, <79.03683, 127.5425, 108.9938>, <79.3467, 124.3459, 109.6192> }
					triangle { <81.2854, 123.9832, 108.7063>, <79.3467, 124.3459, 109.6192>, <79.7143, 123.2956, 108.9475> }
					triangle { <81.2854, 123.9832, 108.7063>, <81.4543, 126.3353, 109.1502>, <79.3467, 124.3459, 109.6192> }
					triangle { <82.6864, 123.167, 107.6438>, <81.5119, 126.8872, 108.8833>, <81.2854, 123.9832, 108.7063> }
					triangle { <81.1969, 122.8416, 107.8766>, <81.2854, 123.9832, 108.7063>, <79.7143, 123.2956, 108.9475> }
					triangle { <82.6864, 123.167, 107.6438>, <81.2854, 123.9832, 108.7063>, <81.1969, 122.8416, 107.8766> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <79.7905, 122.2317, 96.6912>, <81.4071, 122.3667, 107.9424>, <81.2096, 120.8431, 107.8052> }
					triangle { <79.7905, 122.2317, 96.6912>, <81.07332, 123.0461, 102.7637>, <81.4071, 122.3667, 107.9424> }
					triangle { <81.2096, 120.8431, 107.8052>, <81.6797, 120.8694, 102.9417>, <79.7905, 122.2317, 96.6912> }
					triangle { <81.07332, 123.0461, 102.7637>, <79.9309, 123.0652, 108.3423>, <81.4071, 122.3667, 107.9424> }
					triangle { <79.9309, 123.0652, 108.3423>, <77.7119, 122.1453, 109.6895>, <81.4071, 122.3667, 107.9424> }
					triangle { <81.2096, 120.8431, 107.8052>, <80.4045, 119.3564, 108.6374>, <82.1898, 119.5986, 107.6486> }
					triangle { <82.1898, 119.5986, 107.6486>, <81.6797, 120.8694, 102.9417>, <81.2096, 120.8431, 107.8052> }
					triangle { <77.7119, 122.1453, 109.6895>, <78.2375, 121.8507, 109.8167>, <80.2948, 121.0705, 108.8593> }
					triangle { <78.2375, 121.8507, 109.8167>, <76.2405, 120.0606, 109.4509>, <79.3912, 119.1786, 109.4317> }
					triangle { <80.2948, 121.0705, 108.8593>, <79.3912, 119.1786, 109.4317>, <80.4045, 119.3564, 108.6374> }
					triangle { <80.2948, 121.0705, 108.8593>, <78.2375, 121.8507, 109.8167>, <79.3912, 119.1786, 109.4317> }
					triangle { <81.4071, 122.3667, 107.9424>, <77.7119, 122.1453, 109.6895>, <80.2948, 121.0705, 108.8593> }
					triangle { <81.2096, 120.8431, 107.8052>, <80.2948, 121.0705, 108.8593>, <80.4045, 119.3564, 108.6374> }
					triangle { <81.4071, 122.3667, 107.9424>, <80.2948, 121.0705, 108.8593>, <81.2096, 120.8431, 107.8052> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <79.7905, 122.2317, 96.6912>, <81.7561, 120.8483, 107.8017>, <83.0922, 120.2585, 107.3057> }
					triangle { <79.7905, 122.2317, 96.6912>, <80.2967, 122.0787, 102.9285>, <81.7561, 120.8483, 107.8017> }
					triangle { <83.0922, 120.2585, 107.3057>, <82.5534, 121.9577, 102.7562>, <79.7905, 122.2317, 96.6912> }
					triangle { <80.2967, 122.0787, 102.9285>, <80.6675, 119.5885, 108.036>, <81.7561, 120.8483, 107.8017> }
					triangle { <80.6675, 119.5885, 108.036>, <80.9713, 116.9283, 108.6813>, <81.7561, 120.8483, 107.8017> }
					triangle { <83.0922, 120.2585, 107.3057>, <84.3251, 118.8689, 107.6221>, <84.5581, 120.8396, 107.0877> }
					triangle { <84.5581, 120.8396, 107.0877>, <82.5534, 121.9577, 102.7562>, <83.0922, 120.2585, 107.3057> }
					triangle { <80.9713, 116.9283, 108.6813>, <81.4389, 117.2938, 108.8458>, <82.7205, 119.2093, 108.178> }
					triangle { <81.4389, 117.2938, 108.8458>, <82.3919, 115.0281, 107.7124>, <84.2625, 117.6782, 108.1397> }
					triangle { <82.7205, 119.2093, 108.178>, <84.2625, 117.6782, 108.1397>, <84.3251, 118.8689, 107.6221> }
					triangle { <82.7205, 119.2093, 108.178>, <81.4389, 117.2938, 108.8458>, <84.2625, 117.6782, 108.1397> }
					triangle { <81.7561, 120.8483, 107.8017>, <80.9713, 116.9283, 108.6813>, <82.7205, 119.2093, 108.178> }
					triangle { <83.0922, 120.2585, 107.3057>, <82.7205, 119.2093, 108.178>, <84.3251, 118.8689, 107.6221> }
					triangle { <81.7561, 120.8483, 107.8017>, <82.7205, 119.2093, 108.178>, <83.0922, 120.2585, 107.3057> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <57.4423, 113.8042, 61.07117>, <57.9982, 113.9483, 62.9172>, 0.2192 }
			cylinder { <57.9982, 113.9483, 62.9172>, <58.4193, 114.124, 64.7959>, 0.2192 }
			cylinder { <58.4193, 114.124, 64.7959>, <58.7032, 114.3303, 66.6971>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <58.7032, 114.3303, 66.6971>, <58.6079, 114.5175, 68.619>, 0.2192 }
			cylinder { <58.6079, 114.5175, 68.619>, <58.5977, 114.5912, 70.5509>, 0.2192 }
			cylinder { <58.5977, 114.5912, 70.5509>, <58.6729, 114.5509, 72.4823>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <58.6729, 114.5509, 72.4823>, <58.9971, 114.2069, 75.3435>, 0.2192 }
				cylinder { <58.9971, 114.2069, 75.3435>, <59.528, 113.5843, 78.1257>, 0.2192 }
				cylinder { <59.528, 113.5843, 78.1257>, <60.2575, 112.6927, 80.7871>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <60.2575, 112.6927, 80.7871>, <64.2584, 109.8243, 91.03339>, <63.2506, 110.8848, 91.5219> }
					triangle { <60.2575, 112.6927, 80.7871>, <62.6985, 110.3848, 86.06906>, <64.2584, 109.8243, 91.03339> }
					triangle { <63.2506, 110.8848, 91.5219>, <60.9094, 111.1361, 87.2404>, <60.2575, 112.6927, 80.7871> }
					triangle { <62.6985, 110.3848, 86.06906>, <65.7644, 110.5528, 90.8646>, <64.2584, 109.8243, 91.03339> }
					triangle { <65.7644, 110.5528, 90.8646>, <66.9753, 112.6915, 92.1076>, <64.2584, 109.8243, 91.03339> }
					triangle { <63.2506, 110.8848, 91.5219>, <63.03367, 112.2839, 92.7655>, <61.7532, 110.8394, 92.06023> }
					triangle { <61.7532, 110.8394, 92.06023>, <60.9094, 111.1361, 87.2404>, <63.2506, 110.8848, 91.5219> }
					triangle { <66.9753, 112.6915, 92.1076>, <66.5229, 112.4229, 92.4278>, <64.387, 111.3486, 92.2242> }
					triangle { <66.5229, 112.4229, 92.4278>, <66.2637, 115.1148, 92.5423>, <63.8325, 113.0963, 93.3909> }
					triangle { <64.387, 111.3486, 92.2242>, <63.8325, 113.0963, 93.3909>, <63.03367, 112.2839, 92.7655> }
					triangle { <64.387, 111.3486, 92.2242>, <66.5229, 112.4229, 92.4278>, <63.8325, 113.0963, 93.3909> }
					triangle { <64.2584, 109.8243, 91.03339>, <66.9753, 112.6915, 92.1076>, <64.387, 111.3486, 92.2242> }
					triangle { <63.2506, 110.8848, 91.5219>, <64.387, 111.3486, 92.2242>, <63.03367, 112.2839, 92.7655> }
					triangle { <64.2584, 109.8243, 91.03339>, <64.387, 111.3486, 92.2242>, <63.2506, 110.8848, 91.5219> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <60.2575, 112.6927, 80.7871>, <62.9701, 110.449, 91.5958>, <61.5646, 109.8145, 91.6254> }
					triangle { <60.2575, 112.6927, 80.7871>, <62.5577, 111.5318, 86.4919>, <62.9701, 110.449, 91.5958> }
					triangle { <61.5646, 109.8145, 91.6254>, <61.06788, 109.8456, 86.7646>, <60.2575, 112.6927, 80.7871> }
					triangle { <62.5577, 111.5318, 86.4919>, <62.8569, 112.0301, 92.1566>, <62.9701, 110.449, 91.5958> }
					triangle { <62.8569, 112.0301, 92.1566>, <61.1463, 113.2929, 93.907>, <62.9701, 110.449, 91.5958> }
					triangle { <61.5646, 109.8145, 91.6254>, <60.02771, 109.6286, 92.6999>, <61.00005, 108.3391, 91.429> }
					triangle { <61.00005, 108.3391, 91.429>, <61.06788, 109.8456, 86.7646>, <61.5646, 109.8145, 91.6254> }
					triangle { <61.1463, 113.2929, 93.907>, <61.1903, 112.6826, 93.9766>, <61.4479, 110.6162, 92.7845> }
					triangle { <61.1903, 112.6826, 93.9766>, <58.5939, 113.44, 94.08376>, <59.4784, 110.3194, 93.6541> }
					triangle { <61.4479, 110.6162, 92.7845>, <59.4784, 110.3194, 93.6541>, <60.02771, 109.6286, 92.6999> }
					triangle { <61.4479, 110.6162, 92.7845>, <61.1903, 112.6826, 93.9766>, <59.4784, 110.3194, 93.6541> }
					triangle { <62.9701, 110.449, 91.5958>, <61.1463, 113.2929, 93.907>, <61.4479, 110.6162, 92.7845> }
					triangle { <61.5646, 109.8145, 91.6254>, <61.4479, 110.6162, 92.7845>, <60.02771, 109.6286, 92.6999> }
					triangle { <62.9701, 110.449, 91.5958>, <61.4479, 110.6162, 92.7845>, <61.5646, 109.8145, 91.6254> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <60.2575, 112.6927, 80.7871>, <61.8575, 109.388, 91.5453>, <61.9382, 107.9848, 90.91> }
					triangle { <60.2575, 112.6927, 80.7871>, <61.3905, 111.6679, 86.8575>, <61.8575, 109.388, 91.5453> }
					triangle { <61.9382, 107.9848, 90.91>, <62.3809, 109.6925, 86.3534>, <60.2575, 112.6927, 80.7871> }
					triangle { <61.3905, 111.6679, 86.8575>, <60.2805, 109.6513, 92.0659>, <61.8575, 109.388, 91.5453> }
					triangle { <60.2805, 109.6513, 92.0659>, <58.2685, 107.9725, 92.9134>, <61.8575, 109.388, 91.5453> }
					triangle { <61.9382, 107.9848, 90.91>, <61.4176, 106.1921, 91.1674>, <63.1267, 107.0492, 90.4138> }
					triangle { <63.1267, 107.0492, 90.4138>, <62.3809, 109.6925, 86.3534>, <61.9382, 107.9848, 90.91> }
					triangle { <58.2685, 107.9725, 92.9134>, <58.8391, 107.7473, 92.9676>, <61.00065, 107.6915, 91.9272> }
					triangle { <58.8391, 107.7473, 92.9676>, <57.1974, 105.8631, 91.9279>, <60.4556, 105.5914, 91.8022> }
					triangle { <61.00065, 107.6915, 91.9272>, <60.4556, 105.5914, 91.8022>, <61.4176, 106.1921, 91.1674> }
					triangle { <61.00065, 107.6915, 91.9272>, <58.8391, 107.7473, 92.9676>, <60.4556, 105.5914, 91.8022> }
					triangle { <61.8575, 109.388, 91.5453>, <58.2685, 107.9725, 92.9134>, <61.00065, 107.6915, 91.9272> }
					triangle { <61.9382, 107.9848, 90.91>, <61.00065, 107.6915, 91.9272>, <61.4176, 106.1921, 91.1674> }
					triangle { <61.8575, 109.388, 91.5453>, <61.00065, 107.6915, 91.9272>, <61.9382, 107.9848, 90.91> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <60.2575, 112.6927, 80.7871>, <62.4477, 108.0977, 90.9512>, <63.8585, 107.9073, 90.3576> }
					triangle { <60.2575, 112.6927, 80.7871>, <60.7991, 110.6062, 86.6639>, <62.4477, 108.0977, 90.9512> }
					triangle { <63.8585, 107.9073, 90.3576>, <63.04629, 110.8869, 86.5711>, <60.2575, 112.6927, 80.7871> }
					triangle { <60.7991, 110.6062, 86.6639>, <61.5716, 106.6818, 90.717>, <62.4477, 108.0977, 90.9512> }
					triangle { <61.5716, 106.6818, 90.717>, <62.292, 104.0332, 90.4906>, <62.4477, 108.0977, 90.9512> }
					triangle { <63.8585, 107.9073, 90.3576>, <65.2956, 106.6913, 90.2716>, <65.2141, 108.7403, 90.4082> }
					triangle { <65.2141, 108.7403, 90.4082>, <63.04629, 110.8869, 86.5711>, <63.8585, 107.9073, 90.3576> }
					triangle { <62.292, 104.0332, 90.4906>, <62.6967, 104.3914, 90.7858>, <63.6591, 106.5891, 90.8291> }
					triangle { <62.6967, 104.3914, 90.7858>, <63.9911, 102.7844, 89.03418>, <65.4226, 105.4021, 90.3772> }
					triangle { <63.6591, 106.5891, 90.8291>, <65.4226, 105.4021, 90.3772>, <65.2956, 106.6913, 90.2716> }
					triangle { <63.6591, 106.5891, 90.8291>, <62.6967, 104.3914, 90.7858>, <65.4226, 105.4021, 90.3772> }
					triangle { <62.4477, 108.0977, 90.9512>, <62.292, 104.0332, 90.4906>, <63.6591, 106.5891, 90.8291> }
					triangle { <63.8585, 107.9073, 90.3576>, <63.6591, 106.5891, 90.8291>, <65.2956, 106.6913, 90.2716> }
					triangle { <62.4477, 108.0977, 90.9512>, <63.6591, 106.5891, 90.8291>, <63.8585, 107.9073, 90.3576> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <60.2575, 112.6927, 80.7871>, <63.954, 108.3714, 90.63>, <64.6819, 109.7266, 90.7415> }
					triangle { <60.2575, 112.6927, 80.7871>, <61.6196, 109.8012, 86.1692>, <63.954, 108.3714, 90.63> }
					triangle { <64.6819, 109.7266, 90.7415>, <62.1231, 111.7925, 87.1276>, <60.2575, 112.6927, 80.7871> }
					triangle { <61.6196, 109.8012, 86.1692>, <65.01202, 107.2474, 89.9634>, <63.954, 108.3714, 90.63> }
					triangle { <65.01202, 107.2474, 89.9634>, <67.7543, 106.9937, 89.9851>, <63.954, 108.3714, 90.63> }
					triangle { <64.6819, 109.7266, 90.7415>, <66.3094, 110.5131, 91.2742>, <64.3525, 111.1181, 91.441> }
					triangle { <64.3525, 111.1181, 91.441>, <62.1231, 111.7925, 87.1276>, <64.6819, 109.7266, 90.7415> }
					triangle { <67.7543, 106.9937, 89.9851>, <67.5172, 107.3248, 90.4472>, <65.7836, 108.8834, 91.01543> }
					triangle { <67.5172, 107.3248, 90.4472>, <69.679, 108.5886, 89.4196>, <67.5412, 110.1104, 91.3739> }
					triangle { <65.7836, 108.8834, 91.01543>, <67.5412, 110.1104, 91.3739>, <66.3094, 110.5131, 91.2742> }
					triangle { <65.7836, 108.8834, 91.01543>, <67.5172, 107.3248, 90.4472>, <67.5412, 110.1104, 91.3739> }
					triangle { <63.954, 108.3714, 90.63>, <67.7543, 106.9937, 89.9851>, <65.7836, 108.8834, 91.01543> }
					triangle { <64.6819, 109.7266, 90.7415>, <65.7836, 108.8834, 91.01543>, <66.3094, 110.5131, 91.2742> }
					triangle { <63.954, 108.3714, 90.63>, <65.7836, 108.8834, 91.01543>, <64.6819, 109.7266, 90.7415> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <58.7032, 114.3303, 66.6971>, <59.3555, 114.5479, 68.504>, 0.2192 }
			cylinder { <59.3555, 114.5479, 68.504>, <59.9255, 114.8812, 70.3211>, 0.2192 }
			cylinder { <59.9255, 114.8812, 70.3211>, <60.4103, 115.3284, 72.1385>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <60.4103, 115.3284, 72.1385>, <60.9157, 116.2755, 74.8325>, 0.2192 }
				cylinder { <60.9157, 116.2755, 74.8325>, <61.1918, 117.4846, 77.4539>, 0.2192 }
				cylinder { <61.1918, 117.4846, 77.4539>, <61.2344, 118.9376, 79.9633>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <61.2344, 118.9376, 79.9633>, <60.2758, 124.0172, 90.0875>, <61.4144, 123.0519, 90.4753> }
					triangle { <61.2344, 118.9376, 79.9633>, <60.3521, 122.3784, 85.1175>, <60.2758, 124.0172, 90.0875> }
					triangle { <61.4144, 123.0519, 90.4753>, <62.4259, 121.834, 85.8526>, <61.2344, 118.9376, 79.9633> }
					triangle { <60.3521, 122.3784, 85.1175>, <58.8089, 123.3171, 90.5178>, <60.2758, 124.0172, 90.0875> }
					triangle { <58.8089, 123.3171, 90.5178>, <58.07639, 121.5261, 92.4776>, <60.2758, 124.0172, 90.0875> }
					triangle { <61.4144, 123.0519, 90.4753>, <62.02523, 121.9389, 91.868>, <63.00137, 123.1623, 90.5361> }
					triangle { <63.00137, 123.1623, 90.5361>, <62.4259, 121.834, 85.8526>, <61.4144, 123.0519, 90.4753> }
					triangle { <58.07639, 121.5261, 92.4776>, <58.5933, 121.8416, 92.5897>, <60.5445, 122.7817, 91.5569> }
					triangle { <58.5933, 121.8416, 92.5897>, <58.9588, 119.227, 93.1869>, <61.4669, 121.3014, 92.8535> }
					triangle { <60.5445, 122.7817, 91.5569>, <61.4669, 121.3014, 92.8535>, <62.02523, 121.9389, 91.868> }
					triangle { <60.5445, 122.7817, 91.5569>, <58.5933, 121.8416, 92.5897>, <61.4669, 121.3014, 92.8535> }
					triangle { <60.2758, 124.0172, 90.0875>, <58.07639, 121.5261, 92.4776>, <60.5445, 122.7817, 91.5569> }
					triangle { <61.4144, 123.0519, 90.4753>, <60.5445, 122.7817, 91.5569>, <62.02523, 121.9389, 91.868> }
					triangle { <60.2758, 124.0172, 90.0875>, <60.5445, 122.7817, 91.5569>, <61.4144, 123.0519, 90.4753> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <61.2344, 118.9376, 79.9633>, <61.6905, 123.4845, 90.3719>, <63.02414, 124.0667, 89.8604> }
					triangle { <61.2344, 118.9376, 79.9633>, <60.645, 121.3418, 85.7127>, <61.6905, 123.4845, 90.3719> }
					triangle { <63.02414, 124.0667, 89.8604>, <62.09645, 123.0001, 85.183>, <61.2344, 118.9376, 79.9633> }
					triangle { <60.645, 121.3418, 85.7127>, <62.01045, 122.0536, 91.1949>, <61.6905, 123.4845, 90.3719> }
					triangle { <62.01045, 122.0536, 91.1949>, <64.1924, 121.1334, 92.601>, <61.6905, 123.4845, 90.3719> }
					triangle { <63.02414, 124.0667, 89.8604>, <64.7993, 124.4256, 90.381>, <63.4614, 125.4495, 89.204> }
					triangle { <63.4614, 125.4495, 89.204>, <62.09645, 123.0001, 85.183>, <63.02414, 124.0667, 89.8604> }
					triangle { <64.1924, 121.1334, 92.601>, <64.1514, 121.7458, 92.5506>, <63.4957, 123.5229, 91.07762> }
					triangle { <64.1514, 121.7458, 92.5506>, <66.6904, 120.9468, 92.05969>, <65.6221, 123.9338, 91.2587> }
					triangle { <63.4957, 123.5229, 91.07762>, <65.6221, 123.9338, 91.2587>, <64.7993, 124.4256, 90.381> }
					triangle { <63.4957, 123.5229, 91.07762>, <64.1514, 121.7458, 92.5506>, <65.6221, 123.9338, 91.2587> }
					triangle { <61.6905, 123.4845, 90.3719>, <64.1924, 121.1334, 92.601>, <63.4957, 123.5229, 91.07762> }
					triangle { <63.02414, 124.0667, 89.8604>, <63.4957, 123.5229, 91.07762>, <64.7993, 124.4256, 90.381> }
					triangle { <61.6905, 123.4845, 90.3719>, <63.4957, 123.5229, 91.07762>, <63.02414, 124.0667, 89.8604> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <61.2344, 118.9376, 79.9633>, <62.7073, 124.4758, 89.7806>, <62.4027, 125.7161, 88.9159> }
					triangle { <61.2344, 118.9376, 79.9633>, <61.8716, 121.249, 85.7456>, <62.7073, 124.4758, 89.7806> }
					triangle { <62.4027, 125.7161, 88.9159>, <60.7164, 123.1046, 85.146>, <61.2344, 118.9376, 79.9633> }
					triangle { <61.8716, 121.249, 85.7456>, <64.3749, 124.2783, 89.8666>, <62.7073, 124.4758, 89.7806> }
					triangle { <64.3749, 124.2783, 89.8666>, <66.4923, 126.0337, 89.7246>, <62.7073, 124.4758, 89.7806> }
					triangle { <62.4027, 125.7161, 88.9159>, <62.9189, 127.5058, 88.6296>, <61.0928, 126.5635, 88.5993> }
					triangle { <61.0928, 126.5635, 88.5993>, <60.7164, 123.1046, 85.146>, <62.4027, 125.7161, 88.9159> }
					triangle { <66.4923, 126.0337, 89.7246>, <65.9549, 126.2831, 89.8928>, <63.5844, 126.1869, 89.5336> }
					triangle { <65.9549, 126.2831, 89.8928>, <67.1664, 127.8546, 88.05194>, <64.00401, 128.1959, 88.8185> }
					triangle { <63.5844, 126.1869, 89.5336>, <64.00401, 128.1959, 88.8185>, <62.9189, 127.5058, 88.6296> }
					triangle { <63.5844, 126.1869, 89.5336>, <65.9549, 126.2831, 89.8928>, <64.00401, 128.1959, 88.8185> }
					triangle { <62.7073, 124.4758, 89.7806>, <66.4923, 126.0337, 89.7246>, <63.5844, 126.1869, 89.5336> }
					triangle { <62.4027, 125.7161, 88.9159>, <63.5844, 126.1869, 89.5336>, <62.9189, 127.5058, 88.6296> }
					triangle { <62.7073, 124.4758, 89.7806>, <63.5844, 126.1869, 89.5336>, <62.4027, 125.7161, 88.9159> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <61.2344, 118.9376, 79.9633>, <61.9305, 125.6305, 89.1252>, <60.4031, 125.7362, 88.9383> }
					triangle { <61.2344, 118.9376, 79.9633>, <62.3483, 122.2273, 85.171>, <61.9305, 125.6305, 89.1252> }
					triangle { <60.4031, 125.7362, 88.9383>, <60.1801, 122.004, 85.7924>, <61.2344, 118.9376, 79.9633> }
					triangle { <62.3483, 122.2273, 85.171>, <62.6568, 126.9375, 88.3561>, <61.9305, 125.6305, 89.1252> }
					triangle { <62.6568, 126.9375, 88.3561>, <61.8191, 129.5007, 87.7967>, <61.9305, 125.6305, 89.1252> }
					triangle { <60.4031, 125.7362, 88.9383>, <58.9651, 126.9514, 89.01785>, <59.1467, 124.9753, 89.552> }
					triangle { <59.1467, 124.9753, 89.552>, <60.1801, 122.004, 85.7924>, <60.4031, 125.7362, 88.9383> }
					triangle { <61.8191, 129.5007, 87.7967>, <61.5283, 129.2253, 88.2645>, <60.6889, 127.117, 89.04436> }
					triangle { <61.5283, 129.2253, 88.2645>, <59.7334, 130.4686, 86.6648>, <58.8336, 128.2374, 88.8824> }
					triangle { <60.6889, 127.117, 89.04436>, <58.8336, 128.2374, 88.8824>, <58.9651, 126.9514, 89.01785> }
					triangle { <60.6889, 127.117, 89.04436>, <61.5283, 129.2253, 88.2645>, <58.8336, 128.2374, 88.8824> }
					triangle { <61.9305, 125.6305, 89.1252>, <61.8191, 129.5007, 87.7967>, <60.6889, 127.117, 89.04436> }
					triangle { <60.4031, 125.7362, 88.9383>, <60.6889, 127.117, 89.04436>, <58.9651, 126.9514, 89.01785> }
					triangle { <61.9305, 125.6305, 89.1252>, <60.6889, 127.117, 89.04436>, <60.4031, 125.7362, 88.9383> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <61.2344, 118.9376, 79.9633>, <60.405, 125.3428, 89.3178>, <59.7832, 124.0647, 89.9166> }
					triangle { <61.2344, 118.9376, 79.9633>, <61.395, 122.9358, 84.777>, <60.405, 125.3428, 89.3178> }
					triangle { <59.7832, 124.0647, 89.9166>, <61.2526, 121.2069, 86.2357>, <61.2344, 118.9376, 79.9633> }
					triangle { <61.395, 122.9358, 84.777>, <59.1649, 126.3344, 88.7647>, <60.405, 125.3428, 89.3178> }
					triangle { <59.1649, 126.3344, 88.7647>, <56.5392, 126.6728, 89.5238>, <60.405, 125.3428, 89.3178> }
					triangle { <59.7832, 124.0647, 89.9166>, <58.4044, 123.459, 91.04951>, <60.3441, 122.8415, 90.7671> }
					triangle { <60.3441, 122.8415, 90.7671>, <61.2526, 121.2069, 86.2357>, <59.7832, 124.0647, 89.9166> }
					triangle { <56.5392, 126.6728, 89.5238>, <56.9099, 126.4389, 89.9564>, <58.7817, 124.9807, 90.3137> }
					triangle { <56.9099, 126.4389, 89.9564>, <54.5842, 125.0559, 89.8863>, <57.2419, 123.912, 91.4138> }
					triangle { <58.7817, 124.9807, 90.3137>, <57.2419, 123.912, 91.4138>, <58.4044, 123.459, 91.04951> }
					triangle { <58.7817, 124.9807, 90.3137>, <56.9099, 126.4389, 89.9564>, <57.2419, 123.912, 91.4138> }
					triangle { <60.405, 125.3428, 89.3178>, <56.5392, 126.6728, 89.5238>, <58.7817, 124.9807, 90.3137> }
					triangle { <59.7832, 124.0647, 89.9166>, <58.7817, 124.9807, 90.3137>, <58.4044, 123.459, 91.04951> }
					triangle { <60.405, 125.3428, 89.3178>, <58.7817, 124.9807, 90.3137>, <59.7832, 124.0647, 89.9166> }
					material { txgilia_flower }}
				}
			}
		}
	union { // internode
		cylinder { <39.7998, 104.1526, 21.6999>, <48.2499, 113.2352, 32.6263>, 0.5 }
		cylinder { <48.2499, 113.2352, 32.6263>, <57.6378, 122.7887, 42.3155>, 0.5 }
		cylinder { <57.6378, 122.7887, 42.3155>, <67.8732, 132.721, 50.6742>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <67.8732, 132.721, 50.6742>, <73.6006, 137.6166, 52.3309>, 0.4999 }
			cylinder { <73.6006, 137.6166, 52.3309>, <79.7008, 142.2784, 51.5765>, 0.4999 }
			cylinder { <79.7008, 142.2784, 51.5765>, <85.5579, 146.236, 48.4869>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <85.5579, 146.236, 48.4869>, <87.9995, 147.868, 47.1181>, 0.4999 }
				cylinder { <87.9995, 147.868, 47.1181>, <90.4212, 149.4688, 45.6789>, 0.4999 }
				cylinder { <90.4212, 149.4688, 45.6789>, <92.8215, 151.0374, 44.1701>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <92.8215, 151.0374, 44.1701>, <93.3628, 151.1981, 43.921>, 0.03999 }
				cylinder { <93.3628, 151.1981, 43.921>, <93.949, 151.2092, 43.7283>, 0.03999 }
				cylinder { <93.949, 151.2092, 43.7283>, <94.5376, 151.0698, 43.6059>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <94.5376, 151.0698, 43.6059>, <120.5901, 144.4057, 34.5184>, <120.1321, 142.0724, 34.2311> }
				triangle { <120.5901, 144.4057, 34.5184>, <123.3325, 143.0103, 22.972>, <120.1321, 142.0724, 34.2311> }
				triangle { <120.5901, 144.4057, 34.5184>, <123.4477, 145.2567, 25.2423>, <123.3325, 143.0103, 22.972> }
				triangle { <123.3325, 143.0103, 22.972>, <122.2087, 140.6029, 25.565>, <120.1321, 142.0724, 34.2311> }
				triangle { <120.1321, 142.0724, 34.2311>, <109.2739, 144.6712, 36.5246>, <94.5376, 151.0698, 43.6059> }
				triangle { <94.5376, 151.0698, 43.6059>, <110.4128, 148.7796, 36.4077>, <120.5901, 144.4057, 34.5184> }
				triangle { <110.4128, 148.7796, 36.4077>, <120.1233, 147.319, 31.8136>, <120.5901, 144.4057, 34.5184> }
				triangle { <120.1233, 147.319, 31.8136>, <123.4477, 145.2567, 25.2423>, <120.5901, 144.4057, 34.5184> }
				triangle { <120.1321, 142.0724, 34.2311>, <122.2087, 140.6029, 25.565>, <118.7709, 140.613, 30.7215> }
				triangle { <118.7709, 140.613, 30.7215>, <109.2739, 144.6712, 36.5246>, <120.1321, 142.0724, 34.2311> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <92.8215, 151.0374, 44.1701>, <93.2787, 151.3362, 43.8827>, 0.03999 }
				cylinder { <93.2787, 151.3362, 43.8827>, <93.7359, 151.6349, 43.5954>, 0.03999 }
				cylinder { <93.7359, 151.6349, 43.5954>, <94.1931, 151.9337, 43.308>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <94.1931, 151.9337, 43.308>, <113.3568, 165.1245, 27.04506>, <114.3083, 163.1152, 26.1538> }
				triangle { <113.3568, 165.1245, 27.04506>, <111.8457, 166.9573, 15.3341>, <114.3083, 163.1152, 26.1538> }
				triangle { <113.3568, 165.1245, 27.04506>, <111.439, 168.4946, 18.1064>, <111.8457, 166.9573, 15.3341> }
				triangle { <111.8457, 166.9573, 15.3341>, <113.4379, 164.1899, 17.2285>, <114.3083, 163.1152, 26.1538> }
				triangle { <114.3083, 163.1152, 26.1538>, <105.8714, 157.6204, 31.496>, <94.1931, 151.9337, 43.308> }
				triangle { <94.1931, 151.9337, 43.308>, <104.2015, 161.4354, 32.4161>, <113.3568, 165.1245, 27.04506> }
				triangle { <104.2015, 161.4354, 32.4161>, <110.2877, 167.2203, 25.5587>, <113.3568, 165.1245, 27.04506> }
				triangle { <110.2877, 167.2203, 25.5587>, <111.439, 168.4946, 18.1064>, <113.3568, 165.1245, 27.04506> }
				triangle { <114.3083, 163.1152, 26.1538>, <113.4379, 164.1899, 17.2285>, <112.8976, 161.446, 22.759> }
				triangle { <112.8976, 161.446, 22.759>, <105.8714, 157.6204, 31.496>, <114.3083, 163.1152, 26.1538> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <67.8732, 132.721, 50.6742>, <76.4619, 143.3226, 60.00825>, 0.5 }
		cylinder { <76.4619, 143.3226, 60.00825>, <83.2748, 154.4339, 70.1771>, 0.5 }
		cylinder { <83.2748, 154.4339, 70.1771>, <88.2094, 165.8878, 81.02787>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <88.2094, 165.8878, 81.02787>, <87.9175, 171.25, 86.5665>, 0.4999 }
			cylinder { <87.9175, 171.25, 86.5665>, <85.06528, 176.0022, 91.9326>, 0.4999 }
			cylinder { <85.06528, 176.0022, 91.9326>, <79.9859, 179.5888, 96.4988>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <79.9859, 179.5888, 96.4988>, <77.7942, 181.0527, 98.3834>, 0.4999 }
				cylinder { <77.7942, 181.0527, 98.3834>, <75.5453, 182.4731, 100.2337>, 0.4999 }
				cylinder { <75.5453, 182.4731, 100.2337>, <73.2408, 183.8493, 102.0485>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <73.2408, 183.8493, 102.0485>, <72.7976, 184.2188, 102.2675>, 0.03999 }
				cylinder { <72.7976, 184.2188, 102.2675>, <72.3822, 184.6689, 102.3439>, 0.03999 }
				cylinder { <72.3822, 184.6689, 102.3439>, <72.02493, 185.1669, 102.2722>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <72.02493, 185.1669, 102.2722>, <54.5775, 207.4819, 100.4408>, <54.1923, 207.2666, 98.08663> }
				triangle { <54.5775, 207.4819, 100.4408>, <42.6725, 206.4764, 100.2222>, <54.1923, 207.2666, 98.08663> }
				triangle { <54.5775, 207.4819, 100.4408>, <45.02639, 207.0274, 102.3127>, <42.6725, 206.4764, 100.2222> }
				triangle { <42.6725, 206.4764, 100.2222>, <45.2048, 206.5846, 97.5096>, <54.1923, 207.2666, 98.08663> }
				triangle { <54.1923, 207.2666, 98.08663>, <60.03475, 197.5034, 98.7667>, <72.02493, 185.1669, 102.2722> }
				triangle { <72.02493, 185.1669, 102.2722>, <60.02154, 197.9913, 103.0036>, <54.5775, 207.4819, 100.4408> }
				triangle { <60.02154, 197.9913, 103.0036>, <52.4924, 205.7814, 103.4041>, <54.5775, 207.4819, 100.4408> }
				triangle { <52.4924, 205.7814, 103.4041>, <45.02639, 207.0274, 102.3127>, <54.5775, 207.4819, 100.4408> }
				triangle { <54.1923, 207.2666, 98.08663>, <45.2048, 206.5846, 97.5096>, <51.1451, 205.042, 96.649> }
				triangle { <51.1451, 205.042, 96.649>, <60.03475, 197.5034, 98.7667>, <54.1923, 207.2666, 98.08663> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <73.2408, 183.8493, 102.0485>, <72.8018, 184.1115, 102.3942>, 0.03999 }
				cylinder { <72.8018, 184.1115, 102.3942>, <72.3628, 184.3736, 102.7398>, 0.03999 }
				cylinder { <72.3628, 184.3736, 102.7398>, <71.9239, 184.6357, 103.0855>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <71.9239, 184.6357, 103.0855>, <51.7491, 195.1537, 120.0583>, <50.2836, 195.8054, 118.2794> }
				triangle { <51.7491, 195.1537, 120.0583>, <41.8674, 189.1114, 122.9961>, <50.2836, 195.8054, 118.2794> }
				triangle { <51.7491, 195.1537, 120.0583>, <44.7806, 189.7189, 124.1617>, <41.8674, 189.1114, 122.9961> }
				triangle { <41.8674, 189.1114, 122.9961>, <42.5999, 191.4786, 120.2318>, <50.2836, 195.8054, 118.2794> }
				triangle { <50.2836, 195.8054, 118.2794>, <57.5479, 190.451, 111.3168>, <71.9239, 184.6357, 103.0855> }
				triangle { <71.9239, 184.6357, 103.0855>, <59.5723, 189.04, 114.7954>, <51.7491, 195.1537, 120.0583> }
				triangle { <59.5723, 189.04, 114.7954>, <51.848, 191.6272, 121.949>, <51.7491, 195.1537, 120.0583> }
				triangle { <51.848, 191.6272, 121.949>, <44.7806, 189.7189, 124.1617>, <51.7491, 195.1537, 120.0583> }
				triangle { <50.2836, 195.8054, 118.2794>, <42.5999, 191.4786, 120.2318>, <47.4654, 193.293, 116.849> }
				triangle { <47.4654, 193.293, 116.849>, <57.5479, 190.451, 111.3168>, <50.2836, 195.8054, 118.2794> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <88.2094, 165.8878, 81.02787>, <89.9965, 177.5305, 92.6268>, 0.5 }
		cylinder { <89.9965, 177.5305, 92.6268>, <88.5674, 188.9144, 104.5284>, 0.5 }
		cylinder { <88.5674, 188.9144, 104.5284>, <83.9771, 199.6022, 116.2751>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <83.9771, 199.6022, 116.2751>, <79.6377, 203.6612, 121.1942>, 0.4999 }
			cylinder { <79.6377, 203.6612, 121.1942>, <73.5387, 206.3824, 125.0546>, 0.4999 }
			cylinder { <73.5387, 206.3824, 125.0546>, <66.2959, 207.491, 127.4666>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <66.2959, 207.491, 127.4666>, <63.2064, 207.8465, 128.3752>, 0.4999 }
				cylinder { <63.2064, 207.8465, 128.3752>, <60.077, 208.0909, 129.1773>, 0.4999 }
				cylinder { <60.077, 208.0909, 129.1773>, <56.915, 208.2236, 129.8709>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <56.915, 208.2236, 129.8709>, <56.3125, 208.3546, 129.895>, 0.03999 }
				cylinder { <56.3125, 208.3546, 129.895>, <55.7458, 208.5834, 129.8098>, 0.03999 }
				cylinder { <55.7458, 208.5834, 129.8098>, <55.2488, 208.8963, 129.6202>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <55.2488, 208.8963, 129.6202>, <31.2358, 220.7961, 120.2731>, <31.9215, 220.9024, 117.9808> }
				triangle { <31.2358, 220.7961, 120.2731>, <22.466, 214.5913, 115.0428>, <31.9215, 220.9024, 117.9808> }
				triangle { <31.2358, 220.7961, 120.2731>, <23.2593, 215.7179, 117.9262>, <22.466, 214.5913, 115.0428> }
				triangle { <22.466, 214.5913, 115.0428>, <25.4172, 216.3671, 113.6582>, <31.9215, 220.9024, 117.9808> }
				triangle { <31.9215, 220.9024, 117.9808>, <41.06671, 214.9117, 121.2015>, <55.2488, 208.8963, 129.6202> }
				triangle { <55.2488, 208.8963, 129.6202>, <39.2284, 214.4887, 125.0263>, <31.2358, 220.7961, 120.2731> }
				triangle { <39.2284, 214.4887, 125.0263>, <29.3268, 217.7872, 122.0953>, <31.2358, 220.7961, 120.2731> }
				triangle { <29.3268, 217.7872, 122.0953>, <23.2593, 215.7179, 117.9262>, <31.2358, 220.7961, 120.2731> }
				triangle { <31.9215, 220.9024, 117.9808>, <25.4172, 216.3671, 113.6582>, <31.1642, 217.8774, 115.4169> }
				triangle { <31.1642, 217.8774, 115.4169>, <41.06671, 214.9117, 121.2015>, <31.9215, 220.9024, 117.9808> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <56.915, 208.2236, 129.8709>, <56.3128, 208.2489, 130.003>, 0.03999 }
				cylinder { <56.3128, 208.2489, 130.003>, <55.7105, 208.2742, 130.1351>, 0.03999 }
				cylinder { <55.7105, 208.2742, 130.1351>, <55.1083, 208.2995, 130.2672>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <55.1083, 208.2995, 130.2672>, <27.294, 206.7223, 135.6962>, <26.6061, 207.1444, 133.4413> }
				triangle { <27.294, 206.7223, 135.6962>, <20.746, 196.9698, 133.5103>, <26.6061, 207.1444, 133.4413> }
				triangle { <27.294, 206.7223, 135.6962>, <22.3115, 198.3532, 135.9286>, <20.746, 196.9698, 133.5103> }
				triangle { <20.746, 196.9698, 133.5103>, <21.4974, 199.9673, 131.4537>, <26.6061, 207.1444, 133.4413> }
				triangle { <26.6061, 207.1444, 133.4413>, <37.6538, 206.476, 130.7215>, <55.1083, 208.2995, 130.2672> }
				triangle { <55.1083, 208.2995, 130.2672>, <38.3867, 205.2148, 134.7288>, <27.294, 206.7223, 135.6962> }
				triangle { <38.3867, 205.2148, 134.7288>, <28.07331, 203.1705, 137.3683>, <27.294, 206.7223, 135.6962> }
				triangle { <28.07331, 203.1705, 137.3683>, <22.3115, 198.3532, 135.9286>, <27.294, 206.7223, 135.6962> }
				triangle { <26.6061, 207.1444, 133.4413>, <21.4974, 199.9673, 131.4537>, <26.04321, 204.1303, 130.8152> }
				triangle { <26.04321, 204.1303, 130.8152>, <37.6538, 206.476, 130.7215>, <26.6061, 207.1444, 133.4413> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <83.9771, 199.6022, 116.2751>, <84.04478, 208.1638, 130.4164>, 0.5 }
		cylinder { <84.04478, 208.1638, 130.4164>, <88.7623, 213.5985, 145.2989>, 0.5 }
		cylinder { <88.7623, 213.5985, 145.2989>, <97.5783, 215.2708, 159.1829>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <97.5783, 215.2708, 159.1829>, <102.5529, 214.4183, 164.0683>, 0.4552 }
			cylinder { <102.5529, 214.4183, 164.0683>, <108.2538, 212.0888, 167.4467>, 0.4552 }
			cylinder { <108.2538, 212.0888, 167.4467>, <114.1056, 208.5174, 168.9769>, 0.4552 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <114.1056, 208.5174, 168.9769>, <116.5579, 206.9829, 169.5562>, 0.4552 }
				cylinder { <116.5579, 206.9829, 169.5562>, <119.0032, 205.415, 170.0716>, 0.4552 }
				cylinder { <119.0032, 205.415, 170.0716>, <121.4401, 203.8145, 170.5229>, 0.4552 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <121.4401, 203.8145, 170.5229>, <121.7725, 203.4496, 170.6577>, 0.03316 }
				cylinder { <121.7725, 203.4496, 170.6577>, <121.9905, 203.0238, 170.8392>, 0.03316 }
				cylinder { <121.9905, 203.0238, 170.8392>, <122.0784, 202.5679, 171.0542>, 0.03316 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <122.0784, 202.5679, 171.0542>, <127.539, 178.8225, 179.6756>, <125.6794, 177.9235, 178.9759> }
				triangle { <127.539, 178.8225, 179.6756>, <131.3994, 170.9076, 173.2857>, <125.6794, 177.9235, 178.9759> }
				triangle { <127.539, 178.8225, 179.6756>, <132.3758, 172.9388, 175.1266>, <131.3994, 170.9076, 173.2857> }
				triangle { <131.3994, 170.9076, 173.2857>, <128.2503, 171.7817, 174.1491>, <125.6794, 177.9235, 178.9759> }
				triangle { <125.6794, 177.9235, 178.9759>, <123.8036, 187.0198, 174.3452>, <122.0784, 202.5679, 171.0542> }
				triangle { <122.0784, 202.5679, 171.0542>, <127.3977, 188.0938, 175.3496>, <127.539, 178.8225, 179.6756> }
				triangle { <127.3977, 188.0938, 175.3496>, <130.6736, 179.1214, 177.8406>, <127.539, 178.8225, 179.6756> }
				triangle { <130.6736, 179.1214, 177.8406>, <132.3758, 172.9388, 175.1266>, <127.539, 178.8225, 179.6756> }
				triangle { <125.6794, 177.9235, 178.9759>, <128.2503, 171.7817, 174.1491>, <125.4152, 176.4317, 175.6265> }
				triangle { <125.4152, 176.4317, 175.6265>, <123.8036, 187.0198, 174.3452>, <125.6794, 177.9235, 178.9759> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <121.4401, 203.8145, 170.5229>, <121.8628, 203.5369, 170.6012>, 0.03316 }
				cylinder { <121.8628, 203.5369, 170.6012>, <122.2854, 203.2594, 170.6795>, 0.03316 }
				cylinder { <122.2854, 203.2594, 170.6795>, <122.708, 202.9818, 170.7577>, 0.03316 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <122.708, 202.9818, 170.7577>, <144.4168, 189.0276, 172.1716>, <143.4386, 187.104, 171.8577> }
				triangle { <144.4168, 189.0276, 172.1716>, <149.7737, 185.4421, 163.4065>, <143.4386, 187.104, 171.8577> }
				triangle { <144.4168, 189.0276, 172.1716>, <149.8368, 187.667, 165.281>, <149.7737, 185.4421, 163.4065> }
				triangle { <149.7737, 185.4421, 163.4065>, <147.3473, 184.0454, 165.3006>, <143.4386, 187.104, 171.8577> }
				triangle { <143.4386, 187.104, 171.8577>, <134.7999, 192.5518, 170.0138>, <122.708, 202.9818, 170.7577> }
				triangle { <122.708, 202.9818, 170.7577>, <136.9819, 195.7611, 170.1536>, <144.4168, 189.0276, 172.1716> }
				triangle { <136.9819, 195.7611, 170.1536>, <145.7541, 191.2656, 169.625>, <144.4168, 189.0276, 172.1716> }
				triangle { <145.7541, 191.2656, 169.625>, <149.8368, 187.667, 165.281>, <144.4168, 189.0276, 172.1716> }
				triangle { <143.4386, 187.104, 171.8577>, <147.3473, 184.0454, 165.3006>, <142.9962, 185.7083, 168.4857> }
				triangle { <142.9962, 185.7083, 168.4857>, <134.7999, 192.5518, 170.0138>, <143.4386, 187.104, 171.8577> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <97.5783, 215.2708, 159.1829>, <106.2393, 218.146, 172.9671>, 0.5 }
		cylinder { <106.2393, 218.146, 172.9671>, <114.6982, 222.2085, 186.5768>, 0.5 }
		cylinder { <114.6982, 222.2085, 186.5768>, <122.9093, 227.4363, 199.9383>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <122.9093, 227.4363, 199.9383>, <124.49, 229.7847, 202.6677>, 0.2548 }
			cylinder { <124.49, 229.7847, 202.6677>, <125.5386, 233.0008, 204.6728>, 0.2548 }
			cylinder { <125.5386, 233.0008, 204.6728>, <125.9493, 236.7601, 205.751>, 0.2548 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <125.9493, 236.7601, 205.751>, <126.1001, 238.3501, 206.1714>, 0.2548 }
				cylinder { <126.1001, 238.3501, 206.1714>, <126.2291, 239.9503, 206.5593>, 0.2548 }
				cylinder { <126.2291, 239.9503, 206.5593>, <126.3362, 241.5597, 206.9142>, 0.2548 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <126.3362, 241.5597, 206.9142>, <126.379, 241.7138, 206.9266>, 0.01039 }
				cylinder { <126.379, 241.7138, 206.9266>, <126.4516, 241.8564, 206.9162>, 0.01039 }
				cylinder { <126.4516, 241.8564, 206.9162>, <126.5496, 241.979, 206.8835>, 0.01039 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <126.5496, 241.979, 206.8835>, <134.0301, 253.7048, 202.8968>, <134.2932, 253.2944, 201.7775> }
				triangle { <134.0301, 253.7048, 202.8968>, <131.6735, 258.1591, 199.4755>, <134.2932, 253.2944, 201.7775> }
				triangle { <134.0301, 253.7048, 202.8968>, <131.9299, 257.8069, 201.0453>, <131.6735, 258.1591, 199.4755> }
				triangle { <131.6735, 258.1591, 199.4755>, <132.6227, 256.5852, 199.0252>, <134.2932, 253.2944, 201.7775> }
				triangle { <134.2932, 253.2944, 201.7775>, <130.7495, 248.8502, 202.9801>, <126.5496, 241.979, 206.8835> }
				triangle { <126.5496, 241.979, 206.8835>, <130.2055, 249.8932, 204.8084>, <134.0301, 253.7048, 202.8968> }
				triangle { <130.2055, 249.8932, 204.8084>, <132.3953, 254.7856, 203.4642>, <134.0301, 253.7048, 202.8968> }
				triangle { <132.3953, 254.7856, 203.4642>, <131.9299, 257.8069, 201.0453>, <134.0301, 253.7048, 202.8968> }
				triangle { <134.2932, 253.2944, 201.7775>, <132.6227, 256.5852, 199.0252>, <133.0562, 253.676, 200.1776> }
				triangle { <133.0562, 253.676, 200.1776>, <130.7495, 248.8502, 202.9801>, <134.2932, 253.2944, 201.7775> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <126.3362, 241.5597, 206.9142>, <126.3466, 241.716, 206.9487>, 0.01039 }
				cylinder { <126.3466, 241.716, 206.9487>, <126.357, 241.8722, 206.9832>, 0.01039 }
				cylinder { <126.357, 241.8722, 206.9832>, <126.3674, 242.0285, 207.0177>, 0.01039 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <126.3674, 242.0285, 207.0177>, <125.8389, 256.3462, 209.0355>, <126.3248, 256.6298, 207.952> }
				triangle { <125.8389, 256.3462, 209.0355>, <121.4524, 259.8802, 206.7186>, <126.3248, 256.6298, 207.952> }
				triangle { <125.8389, 256.3462, 209.0355>, <121.8164, 259.1066, 208.1053>, <121.4524, 259.8802, 206.7186> }
				triangle { <121.4524, 259.8802, 206.7186>, <123.1485, 259.3688, 206.0536>, <126.3248, 256.6298, 207.952> }
				triangle { <126.3248, 256.6298, 207.952>, <125.9561, 250.9634, 206.7228>, <126.3674, 242.0285, 207.0177> }
				triangle { <126.3674, 242.0285, 207.0177>, <124.8543, 250.7218, 208.5813>, <125.8389, 256.3462, 209.0355> }
				triangle { <124.8543, 250.7218, 208.5813>, <123.8635, 256.0846, 209.4737>, <125.8389, 256.3462, 209.0355> }
				triangle { <123.8635, 256.0846, 209.4737>, <121.8164, 259.1066, 208.1053>, <125.8389, 256.3462, 209.0355> }
				triangle { <126.3248, 256.6298, 207.952>, <123.1485, 259.3688, 206.0536>, <125.1441, 256.9317, 206.2937> }
				triangle { <125.1441, 256.9317, 206.2937>, <125.9561, 250.9634, 206.7228>, <126.3248, 256.6298, 207.952> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <122.9093, 227.4363, 199.9383>, <128.2599, 228.7263, 213.7658>, 0.4501 }
		cylinder { <128.2599, 228.7263, 213.7658>, <131.1081, 226.4888, 228.201>, 0.4501 }
		cylinder { <131.1081, 226.4888, 228.201>, <131.2085, 220.9165, 242.0007>, 0.4501 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <131.2085, 220.9165, 242.0007>, <130.7651, 219.652, 243.6555>, 0.138 }
			cylinder { <130.7651, 219.652, 243.6555>, <129.9158, 218.0681, 244.7971>, 0.138 }
			cylinder { <129.9158, 218.0681, 244.7971>, <128.7598, 216.3499, 245.2923>, 0.138 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <128.7598, 216.3499, 245.2923>, <128.2671, 215.6275, 245.4795>, 0.138 }
				cylinder { <128.2671, 215.6275, 245.4795>, <127.7675, 214.9046, 245.6459>, 0.138 }
				cylinder { <127.7675, 214.9046, 245.6459>, <127.2614, 214.1819, 245.7914>, 0.138 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <127.2614, 214.1819, 245.7914>, <127.2261, 214.1526, 245.8018>, 0.003047 }
				cylinder { <127.2261, 214.1526, 245.8018>, <127.1846, 214.1343, 245.8143>, 0.003047 }
				cylinder { <127.1846, 214.1343, 245.8143>, <127.14, 214.1281, 245.8278>, 0.003047 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <127.14, 214.1281, 245.8278>, <119.7572, 212.6029, 247.9599>, <119.4924, 213.1095, 247.6277> }
				triangle { <119.7572, 212.6029, 247.9599>, <117.6113, 211.0123, 246.0253>, <119.4924, 213.1095, 247.6277> }
				triangle { <119.7572, 212.6029, 247.9599>, <118.1729, 210.8437, 246.6844>, <117.6113, 211.0123, 246.0253> }
				triangle { <117.6113, 211.0123, 246.0253>, <117.8193, 212.0086, 246.1435>, <119.4924, 213.1095, 247.6277> }
				triangle { <119.4924, 213.1095, 247.6277>, <122.3651, 213.5614, 246.4278>, <127.14, 214.1281, 245.8278> }
				triangle { <127.14, 214.1281, 245.8278>, <122.6881, 212.5552, 246.9464>, <119.7572, 212.6029, 247.9599> }
				triangle { <122.6881, 212.5552, 246.9464>, <119.9336, 211.5779, 247.5876>, <119.7572, 212.6029, 247.9599> }
				triangle { <119.9336, 211.5779, 247.5876>, <118.1729, 210.8437, 246.6844>, <119.7572, 212.6029, 247.9599> }
				triangle { <119.4924, 213.1095, 247.6277>, <117.8193, 212.0086, 246.1435>, <119.148, 212.996, 246.574> }
				triangle { <119.148, 212.996, 246.574>, <122.3651, 213.5614, 246.4278>, <119.4924, 213.1095, 247.6277> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <127.2614, 214.1819, 245.7914>, <127.2348, 214.1439, 245.799>, 0.003047 }
				cylinder { <127.2348, 214.1439, 245.799>, <127.2081, 214.1059, 245.8067>, 0.003047 }
				cylinder { <127.2081, 214.1059, 245.8067>, <127.1815, 214.0679, 245.8143>, 0.003047 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <127.1815, 214.0679, 245.8143>, <123.1187, 207.4522, 246.8652>, <122.5519, 207.69, 246.622> }
				triangle { <123.1187, 207.4522, 246.8652>, <122.5348, 205.2885, 244.4456>, <122.5519, 207.69, 246.622> }
				triangle { <123.1187, 207.4522, 246.8652>, <123.1052, 205.4184, 245.1058>, <122.5348, 205.2885, 244.4456> }
				triangle { <122.5348, 205.2885, 244.4456>, <122.0018, 206.0939, 244.7879>, <122.5519, 207.69, 246.622> }
				triangle { <122.5519, 207.69, 246.622>, <124.2021, 210.2464, 245.8231>, <127.1815, 214.0679, 245.8143> }
				triangle { <127.1815, 214.0679, 245.8143>, <125.1717, 209.6641, 246.1495>, <123.1187, 207.4522, 246.8652> }
				triangle { <125.1717, 209.6641, 246.1495>, <123.9272, 206.9475, 246.3065>, <123.1187, 207.4522, 246.8652> }
				triangle { <123.9272, 206.9475, 246.3065>, <123.1052, 205.4184, 245.1058>, <123.1187, 207.4522, 246.8652> }
				triangle { <122.5519, 207.69, 246.622>, <122.0018, 206.0939, 244.7879>, <122.3019, 207.6007, 245.5398> }
				triangle { <122.3019, 207.6007, 245.5398>, <124.2021, 210.2464, 245.8231>, <122.5519, 207.69, 246.622> }
				material { txgilia_leaf }}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <131.2085, 220.9165, 242.0007>, <131.4023, 220.2653, 243.8107>, 0.2192 }
			cylinder { <131.4023, 220.2653, 243.8107>, <131.7749, 219.6933, 245.6195>, 0.2192 }
			cylinder { <131.7749, 219.6933, 245.6195>, <132.3225, 219.206, 247.4085>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <132.3225, 219.206, 247.4085>, <133.0397, 218.8083, 249.1593>, 0.2192 }
			cylinder { <133.0397, 218.8083, 249.1593>, <133.9193, 218.504, 250.8539>, 0.2192 }
			cylinder { <133.9193, 218.504, 250.8539>, <134.9522, 218.2961, 252.4748>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <134.9522, 218.2961, 252.4748>, <135.8213, 218.1301, 254.1938>, 0.2192 }
			cylinder { <135.8213, 218.1301, 254.1938>, <136.5176, 218.008, 255.9933>, 0.2192 }
			cylinder { <136.5176, 218.008, 255.9933>, <137.034, 217.9311, 257.8548>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <137.034, 217.9311, 257.8548>, <137.5015, 217.9811, 260.7164>, 0.2192 }
				cylinder { <137.5015, 217.9811, 260.7164>, <137.6548, 218.1955, 263.6044>, 0.2192 }
				cylinder { <137.6548, 218.1955, 263.6044>, <137.4915, 218.5712, 266.4753>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <137.4915, 218.5712, 266.4753>, <136.7638, 219.2475, 277.8121>, <138.1749, 218.6229, 277.7571> }
					triangle { <137.4915, 218.5712, 266.4753>, <136.5081, 219.5451, 272.5872>, <136.7638, 219.2475, 277.8121> }
					triangle { <138.1749, 218.6229, 277.7571>, <138.7429, 219.4703, 272.9729>, <137.4915, 218.5712, 266.4753> }
					triangle { <136.5081, 219.5451, 272.5872>, <135.6371, 218.0124, 278.0085>, <136.7638, 219.2475, 277.8121> }
					triangle { <135.6371, 218.0124, 278.0085>, <135.754, 215.5177, 279.1768>, <136.7638, 219.2475, 277.8121> }
					triangle { <138.1749, 218.6229, 277.7571>, <139.2858, 217.3518, 278.5992>, <139.6582, 219.2051, 277.7871> }
					triangle { <139.6582, 219.2051, 277.7871>, <138.7429, 219.4703, 272.9729>, <138.1749, 218.6229, 277.7571> }
					triangle { <135.754, 215.5177, 279.1768>, <136.1735, 215.9223, 279.3777>, <137.5969, 217.7324, 278.6936> }
					triangle { <136.1735, 215.9223, 279.3777>, <137.3463, 213.5216, 278.9256>, <139.091, 216.2692, 279.2943> }
					triangle { <137.5969, 217.7324, 278.6936>, <139.091, 216.2692, 279.2943>, <139.2858, 217.3518, 278.5992> }
					triangle { <137.5969, 217.7324, 278.6936>, <136.1735, 215.9223, 279.3777>, <139.091, 216.2692, 279.2943> }
					triangle { <136.7638, 219.2475, 277.8121>, <135.754, 215.5177, 279.1768>, <137.5969, 217.7324, 278.6936> }
					triangle { <138.1749, 218.6229, 277.7571>, <137.5969, 217.7324, 278.6936>, <139.2858, 217.3518, 278.5992> }
					triangle { <136.7638, 219.2475, 277.8121>, <137.5969, 217.7324, 278.6936>, <138.1749, 218.6229, 277.7571> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <137.4915, 218.5712, 266.4753>, <138.2993, 219.129, 277.8132>, <139.3197, 220.2455, 277.5027> }
					triangle { <137.4915, 218.5712, 266.4753>, <137.17, 218.5164, 272.7335>, <138.2993, 219.129, 277.8132> }
					triangle { <139.3197, 220.2455, 277.5027>, <137.9982, 220.6276, 272.8083>, <137.4915, 218.5712, 266.4753> }
					triangle { <137.17, 218.5164, 272.7335>, <139.1332, 217.6815, 278.02>, <138.2993, 219.129, 277.8132> }
					triangle { <139.1332, 217.6815, 278.02>, <141.682, 217.0767, 278.88>, <138.2993, 219.129, 277.8132> }
					triangle { <139.3197, 220.2455, 277.5027>, <140.9847, 220.948, 278.0444>, <139.2434, 221.834, 277.3995> }
					triangle { <139.2434, 221.834, 277.3995>, <137.9982, 220.6276, 272.8083>, <139.3197, 220.2455, 277.5027> }
					triangle { <141.682, 217.0767, 278.88>, <141.4637, 217.6221, 279.0668>, <140.1116, 219.4937, 278.4037> }
					triangle { <141.4637, 217.6221, 279.0668>, <144.0169, 217.8951, 278.201>, <142.0414, 220.4715, 278.6356> }
					triangle { <140.1116, 219.4937, 278.4037>, <142.0414, 220.4715, 278.6356>, <140.9847, 220.948, 278.0444> }
					triangle { <140.1116, 219.4937, 278.4037>, <141.4637, 217.6221, 279.0668>, <142.0414, 220.4715, 278.6356> }
					triangle { <138.2993, 219.129, 277.8132>, <141.682, 217.0767, 278.88>, <140.1116, 219.4937, 278.4037> }
					triangle { <139.3197, 220.2455, 277.5027>, <140.1116, 219.4937, 278.4037>, <140.9847, 220.948, 278.0444> }
					triangle { <138.2993, 219.129, 277.8132>, <140.1116, 219.4937, 278.4037>, <139.3197, 220.2455, 277.5027> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <137.4915, 218.5712, 266.4753>, <138.8923, 220.5337, 277.5972>, <138.1195, 221.8321, 277.2791> }
					triangle { <137.4915, 218.5712, 266.4753>, <138.3642, 218.8138, 272.6762>, <138.8923, 220.5337, 277.5972> }
					triangle { <138.1195, 221.8321, 277.2791>, <136.6548, 220.293, 272.8728>, <137.4915, 218.5712, 266.4753> }
					triangle { <138.3642, 218.8138, 272.6762>, <140.5422, 220.8607, 277.5305>, <138.8923, 220.5337, 277.5972> }
					triangle { <140.5422, 220.8607, 277.5305>, <142.036, 223.1356, 277.9725>, <138.8923, 220.5337, 277.5972> }
					triangle { <138.1195, 221.8321, 277.2791>, <138.0628, 223.677, 277.669>, <136.5903, 222.2731, 277.3627> }
					triangle { <136.5903, 222.2731, 277.3627>, <136.6548, 220.293, 272.8728>, <138.1195, 221.8321, 277.2791> }
					triangle { <142.036, 223.1356, 277.9725>, <141.4834, 223.1265, 278.2457>, <139.2059, 222.4106, 277.9784> }
					triangle { <141.4834, 223.1265, 278.2457>, <141.9008, 225.5387, 277.0839>, <138.9283, 224.5671, 278.0585> }
					triangle { <139.2059, 222.4106, 277.9784>, <138.9283, 224.5671, 278.0585>, <138.0628, 223.677, 277.669> }
					triangle { <139.2059, 222.4106, 277.9784>, <141.4834, 223.1265, 278.2457>, <138.9283, 224.5671, 278.0585> }
					triangle { <138.8923, 220.5337, 277.5972>, <142.036, 223.1356, 277.9725>, <139.2059, 222.4106, 277.9784> }
					triangle { <138.1195, 221.8321, 277.2791>, <139.2059, 222.4106, 277.9784>, <138.0628, 223.677, 277.669> }
					triangle { <138.8923, 220.5337, 277.5972>, <139.2059, 222.4106, 277.9784>, <138.1195, 221.8321, 277.2791> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <137.4915, 218.5712, 266.4753>, <137.7289, 221.5335, 277.4607>, <136.2217, 221.2049, 277.3932> }
					triangle { <137.4915, 218.5712, 266.4753>, <138.4514, 220.0291, 272.494>, <137.7289, 221.5335, 277.4607> }
					triangle { <136.2217, 221.2049, 277.3932>, <136.5566, 218.9258, 273.0778>, <137.4915, 218.5712, 266.4753> }
					triangle { <138.4514, 220.0291, 272.494>, <137.9301, 223.1861, 277.212>, <137.7289, 221.5335, 277.4607> }
					triangle { <137.9301, 223.1861, 277.212>, <136.33, 225.3779, 277.6999>, <137.7289, 221.5335, 277.4607> }
					triangle { <136.2217, 221.2049, 277.3932>, <134.5308, 221.793, 277.9883>, <135.3406, 219.9197, 277.7273> }
					triangle { <135.3406, 219.9197, 277.7273>, <136.5566, 218.9258, 273.0778>, <136.2217, 221.2049, 277.3932> }
					triangle { <136.33, 225.3779, 277.6999>, <136.2054, 224.8798, 278.0414>, <136.1229, 222.4794, 278.0016> }
					triangle { <136.2054, 224.8798, 278.0414>, <133.9026, 225.9605, 277.1077>, <134.0249, 222.9343, 278.3552> }
					triangle { <136.1229, 222.4794, 278.0016>, <134.0249, 222.9343, 278.3552>, <134.5308, 221.793, 277.9883> }
					triangle { <136.1229, 222.4794, 278.0016>, <136.2054, 224.8798, 278.0414>, <134.0249, 222.9343, 278.3552> }
					triangle { <137.7289, 221.5335, 277.4607>, <136.33, 225.3779, 277.6999>, <136.1229, 222.4794, 278.0016> }
					triangle { <136.2217, 221.2049, 277.3932>, <136.1229, 222.4794, 278.0016>, <134.5308, 221.793, 277.9883> }
					triangle { <137.7289, 221.5335, 277.4607>, <136.1229, 222.4794, 278.0016>, <136.2217, 221.2049, 277.3932> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <137.4915, 218.5712, 266.4753>, <136.3936, 220.7265, 277.5956>, <136.2565, 219.1916, 277.6931> }
					triangle { <137.4915, 218.5712, 266.4753>, <137.287, 220.4879, 272.4382>, <136.3936, 220.7265, 277.5956> }
					triangle { <136.2565, 219.1916, 277.6931>, <137.8666, 218.4096, 273.1406>, <137.4915, 218.5712, 266.4753> }
					triangle { <137.287, 220.4879, 272.4382>, <134.8528, 221.3992, 277.5119>, <136.3936, 220.7265, 277.5956> }
					triangle { <134.8528, 221.3992, 277.5119>, <132.3889, 220.5986, 278.4555>, <136.3936, 220.7265, 277.5956> }
					triangle { <136.2565, 219.1916, 277.6931>, <135.2981, 217.8247, 278.5718>, <137.2652, 217.995, 277.9935> }
					triangle { <137.2652, 217.995, 277.9935>, <137.8666, 218.4096, 273.1406>, <136.2565, 219.1916, 277.6931> }
					triangle { <132.3889, 220.5986, 278.4555>, <132.8743, 220.3602, 278.7516>, <135.1135, 219.5444, 278.4503> }
					triangle { <132.8743, 220.3602, 278.7516>, <131.0452, 218.4214, 278.2632>, <134.1269, 217.7285, 279.1305> }
					triangle { <135.1135, 219.5444, 278.4503>, <134.1269, 217.7285, 279.1305>, <135.2981, 217.8247, 278.5718> }
					triangle { <135.1135, 219.5444, 278.4503>, <132.8743, 220.3602, 278.7516>, <134.1269, 217.7285, 279.1305> }
					triangle { <136.3936, 220.7265, 277.5956>, <132.3889, 220.5986, 278.4555>, <135.1135, 219.5444, 278.4503> }
					triangle { <136.2565, 219.1916, 277.6931>, <135.1135, 219.5444, 278.4503>, <135.2981, 217.8247, 278.5718> }
					triangle { <136.3936, 220.7265, 277.5956>, <135.1135, 219.5444, 278.4503>, <136.2565, 219.1916, 277.6931> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <137.034, 217.9311, 257.8548>, <137.6519, 217.6933, 259.6712>, 0.2192 }
			cylinder { <137.6519, 217.6933, 259.6712>, <138.3647, 217.2967, 261.424>, 0.2192 }
			cylinder { <138.3647, 217.2967, 261.424>, <139.1649, 216.7453, 263.0954>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <139.1649, 216.7453, 263.0954>, <140.4337, 215.6083, 265.4421>, 0.2192 }
				cylinder { <140.4337, 215.6083, 265.4421>, <141.752, 214.1784, 267.5933>, 0.2192 }
				cylinder { <141.752, 214.1784, 267.5933>, <143.0999, 212.4771, 269.5165>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <143.0999, 212.4771, 269.5165>, <149.754, 206.0927, 276.1736>, <149.4342, 207.178, 277.2231> }
					triangle { <143.0999, 212.4771, 269.5165>, <146.5851, 208.3249, 272.6528>, <149.754, 206.0927, 276.1736> }
					triangle { <149.4342, 207.178, 277.2231>, <145.7746, 209.1096, 274.62>, <143.0999, 212.4771, 269.5165> }
					triangle { <146.5851, 208.3249, 272.6528>, <151.2091, 206.4823, 275.4247>, <149.754, 206.0927, 276.1736> }
					triangle { <151.2091, 206.4823, 275.4247>, <153.4421, 207.872, 276.2466>, <149.754, 206.0927, 276.1736> }
					triangle { <149.4342, 207.178, 277.2231>, <150.207, 208.1961, 278.6091>, <148.3578, 207.3246, 278.3878> }
					triangle { <148.3578, 207.3246, 278.3878>, <145.7746, 209.1096, 274.62>, <149.4342, 207.178, 277.2231> }
					triangle { <153.4421, 207.872, 276.2466>, <153.0984, 207.6348, 276.6996>, <150.8414, 207.1647, 277.3695> }
					triangle { <153.0984, 207.6348, 276.6996>, <153.7952, 210.1809, 277.3045>, <151.4073, 208.6059, 278.8963> }
					triangle { <150.8414, 207.1647, 277.3695>, <151.4073, 208.6059, 278.8963>, <150.207, 208.1961, 278.6091> }
					triangle { <150.8414, 207.1647, 277.3695>, <153.0984, 207.6348, 276.6996>, <151.4073, 208.6059, 278.8963> }
					triangle { <149.754, 206.0927, 276.1736>, <153.4421, 207.872, 276.2466>, <150.8414, 207.1647, 277.3695> }
					triangle { <149.4342, 207.178, 277.2231>, <150.8414, 207.1647, 277.3695>, <150.207, 208.1961, 278.6091> }
					triangle { <149.754, 206.0927, 276.1736>, <150.8414, 207.1647, 277.3695>, <149.4342, 207.178, 277.2231> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <143.0999, 212.4771, 269.5165>, <149.0833, 206.8129, 277.3569>, <147.688, 206.5267, 277.9508> }
					triangle { <143.0999, 212.4771, 269.5165>, <147.008, 209.3143, 273.2512>, <149.0833, 206.8129, 277.3569> }
					triangle { <147.688, 206.5267, 277.9508>, <145.2988, 207.9964, 273.9468>, <143.0999, 212.4771, 269.5165> }
					triangle { <147.008, 209.3143, 273.2512>, <149.7264, 208.1647, 278.1244>, <149.0833, 206.8129, 277.3569> }
					triangle { <149.7264, 208.1647, 278.1244>, <149.3838, 209.2522, 280.633>, <149.0833, 206.8129, 277.3569> }
					triangle { <147.688, 206.5267, 277.9508>, <146.7501, 206.4043, 279.5818>, <146.6475, 205.3265, 277.8337> }
					triangle { <146.6475, 205.3265, 277.8337>, <145.2988, 207.9964, 273.9468>, <147.688, 206.5267, 277.9508> }
					triangle { <149.3838, 209.2522, 280.633>, <149.252, 208.6522, 280.5862>, <148.3187, 206.9864, 279.131> }
					triangle { <149.252, 208.6522, 280.5862>, <147.3207, 209.9149, 282.0038>, <146.8918, 206.9132, 280.7701> }
					triangle { <148.3187, 206.9864, 279.131>, <146.8918, 206.9132, 280.7701>, <146.7501, 206.4043, 279.5818> }
					triangle { <148.3187, 206.9864, 279.131>, <149.252, 208.6522, 280.5862>, <146.8918, 206.9132, 280.7701> }
					triangle { <149.0833, 206.8129, 277.3569>, <149.3838, 209.2522, 280.633>, <148.3187, 206.9864, 279.131> }
					triangle { <147.688, 206.5267, 277.9508>, <148.3187, 206.9864, 279.131>, <146.7501, 206.4043, 279.5818> }
					triangle { <149.0833, 206.8129, 277.3569>, <148.3187, 206.9864, 279.131>, <147.688, 206.5267, 277.9508> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <143.0999, 212.4771, 269.5165>, <147.7677, 206.0837, 277.683>, <147.1241, 204.9261, 276.891> }
					triangle { <143.0999, 212.4771, 269.5165>, <146.2026, 209.6039, 274.1363>, <147.7677, 206.0837, 277.683> }
					triangle { <147.1241, 204.9261, 276.891>, <146.2048, 207.6706, 272.951>, <143.0999, 212.4771, 269.5165> }
					triangle { <146.2026, 209.6039, 274.1363>, <146.7161, 206.5421, 278.9134>, <147.7677, 206.0837, 277.683> }
					triangle { <146.7161, 206.5421, 278.9134>, <144.7962, 205.1912, 280.3563>, <147.7677, 206.0837, 277.683> }
					triangle { <147.1241, 204.9261, 276.891>, <146.203, 203.2949, 277.104>, <147.6358, 203.9192, 275.768> }
					triangle { <147.6358, 203.9192, 275.768>, <146.2048, 207.6706, 272.951>, <147.1241, 204.9261, 276.891> }
					triangle { <144.7962, 205.1912, 280.3563>, <145.2332, 204.8374, 280.1042>, <146.6407, 204.5841, 278.1759> }
					triangle { <145.2332, 204.8374, 280.1042>, <142.7968, 203.7271, 279.6978>, <145.4436, 202.7753, 278.023> }
					triangle { <146.6407, 204.5841, 278.1759>, <145.4436, 202.7753, 278.023>, <146.203, 203.2949, 277.104> }
					triangle { <146.6407, 204.5841, 278.1759>, <145.2332, 204.8374, 280.1042>, <145.4436, 202.7753, 278.023> }
					triangle { <147.7677, 206.0837, 277.683>, <144.7962, 205.1912, 280.3563>, <146.6407, 204.5841, 278.1759> }
					triangle { <147.1241, 204.9261, 276.891>, <146.6407, 204.5841, 278.1759>, <146.203, 203.2949, 277.104> }
					triangle { <147.7677, 206.0837, 277.683>, <146.6407, 204.5841, 278.1759>, <147.1241, 204.9261, 276.891> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <143.0999, 212.4771, 269.5165>, <147.6131, 204.906, 276.7043>, <148.5166, 204.5732, 275.4983> }
					triangle { <143.0999, 212.4771, 269.5165>, <145.2744, 208.7961, 274.0932>, <147.6131, 204.906, 276.7043> }
					triangle { <148.5166, 204.5732, 275.4983>, <147.2491, 208.5794, 272.9995>, <143.0999, 212.4771, 269.5165> }
					triangle { <145.2744, 208.7961, 274.0932>, <146.3103, 203.8418, 276.7087>, <147.6131, 204.906, 276.7043> }
					triangle { <146.3103, 203.8418, 276.7087>, <145.9764, 201.2632, 275.7964>, <147.6131, 204.906, 276.7043> }
					triangle { <148.5166, 204.5732, 275.4983>, <149.3167, 203.1359, 274.5768>, <149.9661, 205.0344, 275.026> }
					triangle { <149.9661, 205.0344, 275.026>, <147.2491, 208.5794, 272.9995>, <148.5166, 204.5732, 275.4983> }
					triangle { <145.9764, 201.2632, 275.7964>, <146.5583, 201.4268, 275.9154>, <148.1106, 203.2555, 275.8153> }
					triangle { <146.5583, 201.4268, 275.9154>, <146.4331, 200.111, 273.5517>, <149.0506, 201.872, 274.4258> }
					triangle { <148.1106, 203.2555, 275.8153>, <149.0506, 201.872, 274.4258>, <149.3167, 203.1359, 274.5768> }
					triangle { <148.1106, 203.2555, 275.8153>, <146.5583, 201.4268, 275.9154>, <149.0506, 201.872, 274.4258> }
					triangle { <147.6131, 204.906, 276.7043>, <145.9764, 201.2632, 275.7964>, <148.1106, 203.2555, 275.8153> }
					triangle { <148.5166, 204.5732, 275.4983>, <148.1106, 203.2555, 275.8153>, <149.3167, 203.1359, 274.5768> }
					triangle { <147.6131, 204.906, 276.7043>, <148.1106, 203.2555, 275.8153>, <148.5166, 204.5732, 275.4983> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <143.0999, 212.4771, 269.5165>, <148.8593, 204.9116, 275.7574>, <149.9659, 205.9859, 275.7066> }
					triangle { <143.0999, 212.4771, 269.5165>, <145.5144, 207.9937, 273.1625>, <148.8593, 204.9116, 275.7574> }
					triangle { <149.9659, 205.9859, 275.7066>, <146.9791, 209.4821, 274.0465>, <143.0999, 212.4771, 269.5165> }
					triangle { <145.5144, 207.9937, 273.1625>, <149.129, 203.8043, 274.52>, <148.8593, 204.9116, 275.7574> }
					triangle { <149.129, 203.8043, 274.52>, <151.4005, 202.945, 273.2181>, <148.8593, 204.9116, 275.7574> }
					triangle { <149.9659, 205.9859, 275.7066>, <151.8287, 206.2108, 275.5211>, <150.4191, 207.1709, 276.6696> }
					triangle { <150.4191, 207.1709, 276.6696>, <146.9791, 209.4821, 274.0465>, <149.9659, 205.9859, 275.7066> }
					triangle { <151.4005, 202.945, 273.2181>, <151.4927, 203.1817, 273.7794>, <150.746, 204.8745, 275.3094> }
					triangle { <151.4927, 203.1817, 273.7794>, <153.3331, 204.1599, 272.0502>, <152.792, 205.53, 274.9736> }
					triangle { <150.746, 204.8745, 275.3094>, <152.792, 205.53, 274.9736>, <151.8287, 206.2108, 275.5211> }
					triangle { <150.746, 204.8745, 275.3094>, <151.4927, 203.1817, 273.7794>, <152.792, 205.53, 274.9736> }
					triangle { <148.8593, 204.9116, 275.7574>, <151.4005, 202.945, 273.2181>, <150.746, 204.8745, 275.3094> }
					triangle { <149.9659, 205.9859, 275.7066>, <150.746, 204.8745, 275.3094>, <151.8287, 206.2108, 275.5211> }
					triangle { <148.8593, 204.9116, 275.7574>, <150.746, 204.8745, 275.3094>, <149.9659, 205.9859, 275.7066> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <139.1649, 216.7453, 263.0954>, <140.0049, 216.3828, 264.7985>, 0.2192 }
			cylinder { <140.0049, 216.3828, 264.7985>, <140.8764, 216.2127, 266.5159>, 0.2192 }
			cylinder { <140.8764, 216.2127, 266.5159>, <141.7706, 216.2368, 268.2298>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <141.7706, 216.2368, 268.2298>, <143.2099, 216.6052, 270.7203>, 0.2192 }
				cylinder { <143.2099, 216.6052, 270.7203>, <144.7256, 217.3004, 273.0929>, 0.2192 }
				cylinder { <144.7256, 217.3004, 273.0929>, <146.2949, 218.312, 275.312>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <146.2949, 218.312, 275.312>, <151.576, 222.6002, 284.4267>, <151.4182, 221.1633, 284.9669> }
					triangle { <146.2949, 218.312, 275.312>, <149.4954, 221.2724, 279.8083>, <151.576, 222.6002, 284.4267> }
					triangle { <151.4182, 221.1633, 284.9669>, <150.2319, 219.284, 280.6124>, <146.2949, 218.312, 275.312> }
					triangle { <149.4954, 221.2724, 279.8083>, <150.2858, 223.5266, 284.9807>, <151.576, 222.6002, 284.4267> }
					triangle { <150.2858, 223.5266, 284.9807>, <148.6919, 223.3924, 287.2245>, <151.576, 222.6002, 284.4267> }
					triangle { <151.4182, 221.1633, 284.9669>, <151.011, 220.1851, 286.5264>, <152.3493, 219.8715, 284.9973> }
					triangle { <152.3493, 219.8715, 284.9973>, <150.2319, 219.284, 280.6124>, <151.4182, 221.1633, 284.9669> }
					triangle { <148.6919, 223.3924, 287.2245>, <149.2438, 223.1235, 287.2774>, <150.8985, 221.857, 286.0852> }
					triangle { <149.2438, 223.1235, 287.2774>, <147.328, 221.5131, 288.312>, <150.3312, 220.4153, 287.6109> }
					triangle { <150.8985, 221.857, 286.0852>, <150.3312, 220.4153, 287.6109>, <151.011, 220.1851, 286.5264> }
					triangle { <150.8985, 221.857, 286.0852>, <149.2438, 223.1235, 287.2774>, <150.3312, 220.4153, 287.6109> }
					triangle { <151.576, 222.6002, 284.4267>, <148.6919, 223.3924, 287.2245>, <150.8985, 221.857, 286.0852> }
					triangle { <151.4182, 221.1633, 284.9669>, <150.8985, 221.857, 286.0852>, <151.011, 220.1851, 286.5264> }
					triangle { <151.576, 222.6002, 284.4267>, <150.8985, 221.857, 286.0852>, <151.4182, 221.1633, 284.9669> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <146.2949, 218.312, 275.312>, <151.9104, 221.1422, 284.7889>, <153.0197, 220.2618, 284.176> }
					triangle { <146.2949, 218.312, 275.312>, <148.8669, 220.5378, 280.5708>, <151.9104, 221.1422, 284.7889> }
					triangle { <153.0197, 220.2618, 284.176>, <150.939, 220.1104, 279.7547>, <146.2949, 218.312, 275.312> }
					triangle { <148.8669, 220.5378, 280.5708>, <150.9988, 220.2003, 285.8434>, <151.9104, 221.1422, 284.7889> }
					triangle { <150.9988, 220.2003, 285.8434>, <151.5766, 217.9821, 287.3726>, <151.9104, 221.1422, 284.7889> }
					triangle { <153.0197, 220.2618, 284.176>, <154.3268, 218.9761, 284.6158>, <154.3115, 220.5469, 283.289> }
					triangle { <154.3115, 220.5469, 283.289>, <150.939, 220.1104, 279.7547>, <153.0197, 220.2618, 284.176> }
					triangle { <151.5766, 217.9821, 287.3726>, <152.062, 218.3288, 287.2182>, <152.9916, 219.6812, 285.4659> }
					triangle { <152.062, 218.3288, 287.2182>, <152.6441, 215.7091, 286.8544>, <154.475, 218.0941, 285.5598> }
					triangle { <152.9916, 219.6812, 285.4659>, <154.475, 218.0941, 285.5598>, <154.3268, 218.9761, 284.6158> }
					triangle { <152.9916, 219.6812, 285.4659>, <152.062, 218.3288, 287.2182>, <154.475, 218.0941, 285.5598> }
					triangle { <151.9104, 221.1422, 284.7889>, <151.5766, 217.9821, 287.3726>, <152.9916, 219.6812, 285.4659> }
					triangle { <153.0197, 220.2618, 284.176>, <152.9916, 219.6812, 285.4659>, <154.3268, 218.9761, 284.6158> }
					triangle { <151.9104, 221.1422, 284.7889>, <152.9916, 219.6812, 285.4659>, <153.0197, 220.2618, 284.176> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <146.2949, 218.312, 275.312>, <153.1859, 220.7364, 284.0293>, <153.9391, 221.5635, 282.9663> }
					triangle { <146.2949, 218.312, 275.312>, <149.4348, 219.4461, 280.611>, <153.1859, 220.7364, 284.0293> }
					triangle { <153.9391, 221.5635, 282.9663>, <150.3, 221.3385, 279.7095>, <146.2949, 218.312, 275.312> }
					triangle { <149.4348, 219.4461, 280.611>, <153.9043, 219.219, 284.1368>, <153.1859, 220.7364, 284.0293> }
					triangle { <153.9043, 219.219, 284.1368>, <156.464, 218.306, 283.6817>, <153.1859, 220.7364, 284.0293> }
					triangle { <153.9391, 221.5635, 282.9663>, <155.6693, 222.0222, 282.3738>, <153.919, 223.0916, 282.5177> }
					triangle { <153.919, 223.0916, 282.5177>, <150.3, 221.3385, 279.7095>, <153.9391, 221.5635, 282.9663> }
					triangle { <156.464, 218.306, 283.6817>, <156.4178, 218.9072, 283.8083>, <155.0446, 220.85, 283.4866> }
					triangle { <156.4178, 218.9072, 283.8083>, <158.0954, 218.5297, 281.7162>, <156.8443, 221.4682, 282.4344> }
					triangle { <155.0446, 220.85, 283.4866>, <156.8443, 221.4682, 282.4344>, <155.6693, 222.0222, 282.3738> }
					triangle { <155.0446, 220.85, 283.4866>, <156.4178, 218.9072, 283.8083>, <156.8443, 221.4682, 282.4344> }
					triangle { <153.1859, 220.7364, 284.0293>, <156.464, 218.306, 283.6817>, <155.0446, 220.85, 283.4866> }
					triangle { <153.9391, 221.5635, 282.9663>, <155.0446, 220.85, 283.4866>, <155.6693, 222.0222, 282.3738> }
					triangle { <153.1859, 220.7364, 284.0293>, <155.0446, 220.85, 283.4866>, <153.9391, 221.5635, 282.9663> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <146.2949, 218.312, 275.312>, <153.6518, 221.9397, 283.1905>, <152.9144, 223.2817, 282.9983> }
					triangle { <146.2949, 218.312, 275.312>, <150.4197, 219.4958, 279.8737>, <153.6518, 221.9397, 283.1905> }
					triangle { <152.9144, 223.2817, 282.9983>, <149.1921, 221.2827, 280.5389>, <146.2949, 218.312, 275.312> }
					triangle { <150.4197, 219.4958, 279.8737>, <155.014, 221.9297, 282.2035>, <153.6518, 221.9397, 283.1905> }
					triangle { <155.014, 221.9297, 282.2035>, <156.6456, 223.9196, 281.218>, <153.6518, 221.9397, 283.1905> }
					triangle { <152.9144, 223.2817, 282.9983>, <153.1956, 225.1421, 282.8779>, <151.7106, 224.0126, 283.7421> }
					triangle { <151.7106, 224.0126, 283.7421>, <149.1921, 221.2827, 280.5389>, <152.9144, 223.2817, 282.9983> }
					triangle { <156.6456, 223.9196, 281.218>, <156.3324, 224.0649, 281.7283>, <154.2395, 223.7591, 282.8641> }
					triangle { <156.3324, 224.0649, 281.7283>, <156.1992, 226.1033, 279.9503>, <154.1868, 225.9063, 282.5247> }
					triangle { <154.2395, 223.7591, 282.8641>, <154.1868, 225.9063, 282.5247>, <153.1956, 225.1421, 282.8779> }
					triangle { <154.2395, 223.7591, 282.8641>, <156.3324, 224.0649, 281.7283>, <154.1868, 225.9063, 282.5247> }
					triangle { <153.6518, 221.9397, 283.1905>, <156.6456, 223.9196, 281.218>, <154.2395, 223.7591, 282.8641> }
					triangle { <152.9144, 223.2817, 282.9983>, <154.2395, 223.7591, 282.8641>, <153.1956, 225.1421, 282.8779> }
					triangle { <153.6518, 221.9397, 283.1905>, <154.2395, 223.7591, 282.8641>, <152.9144, 223.2817, 282.9983> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <146.2949, 218.312, 275.312>, <152.6418, 223.109, 283.4398>, <151.3329, 223.0306, 284.2534> }
					triangle { <146.2949, 218.312, 275.312>, <150.4577, 220.6415, 279.3701>, <152.6418, 223.109, 283.4398> }
					triangle { <151.3329, 223.0306, 284.2534>, <149.1493, 219.9937, 281.1054>, <146.2949, 218.312, 275.312> }
					triangle { <150.4577, 220.6415, 279.3701>, <152.7439, 224.6321, 282.7328>, <152.6418, 223.109, 283.4398> }
					triangle { <152.7439, 224.6321, 282.7328>, <151.7696, 227.1106, 283.4406>, <152.6418, 223.109, 283.4398> }
					triangle { <151.3329, 223.0306, 284.2534>, <150.2731, 223.9896, 285.4831>, <150.7258, 221.9924, 285.2977> }
					triangle { <150.7258, 221.9924, 285.2977>, <149.1493, 219.9937, 281.1054>, <151.3329, 223.0306, 284.2534> }
					triangle { <151.7696, 227.1106, 283.4406>, <151.8316, 226.71, 283.9047>, <151.6384, 224.3908, 284.4944> }
					triangle { <151.8316, 226.71, 283.9047>, <149.4441, 227.975, 284.0883>, <150.1008, 225.2457, 285.7723> }
					triangle { <151.6384, 224.3908, 284.4944>, <150.1008, 225.2457, 285.7723>, <150.2731, 223.9896, 285.4831> }
					triangle { <151.6384, 224.3908, 284.4944>, <151.8316, 226.71, 283.9047>, <150.1008, 225.2457, 285.7723> }
					triangle { <152.6418, 223.109, 283.4398>, <151.7696, 227.1106, 283.4406>, <151.6384, 224.3908, 284.4944> }
					triangle { <151.3329, 223.0306, 284.2534>, <151.6384, 224.3908, 284.4944>, <150.2731, 223.9896, 285.4831> }
					triangle { <152.6418, 223.109, 283.4398>, <151.6384, 224.3908, 284.4944>, <151.3329, 223.0306, 284.2534> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <141.7706, 216.2368, 268.2298>, <142.531, 216.1318, 270.0042>, 0.2192 }
			cylinder { <142.531, 216.1318, 270.0042>, <143.1497, 215.8988, 271.821>, 0.2192 }
			cylinder { <143.1497, 215.8988, 271.821>, <143.6202, 215.5406, 273.6617>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <143.6202, 215.5406, 273.6617>, <144.0043, 214.8545, 276.4531>, 0.2192 }
				cylinder { <144.0043, 214.8545, 276.4531>, <144.0611, 214.0298, 279.2328>, 0.2192 }
				cylinder { <144.0611, 214.0298, 279.2328>, <143.7896, 213.0791, 281.959>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <143.7896, 213.0791, 281.959>, <143.0152, 208.1582, 292.1769>, <144.3608, 208.8718, 292.4201> }
					triangle { <143.7896, 213.0791, 281.959>, <142.5308, 210.3245, 287.4372>, <143.0152, 208.1582, 292.1769> }
					triangle { <144.3608, 208.8718, 292.4201>, <143.9412, 211.7499, 288.4937>, <143.7896, 213.0791, 281.959> }
					triangle { <142.5308, 210.3245, 287.4372>, <143.3261, 206.5885, 291.6605>, <143.0152, 208.1582, 292.1769> }
					triangle { <143.3261, 206.5885, 291.6605>, <145.4065, 204.8369, 292.0948>, <143.0152, 208.1582, 292.1769> }
					triangle { <144.3608, 208.8718, 292.4201>, <146.0575, 208.6414, 293.207>, <144.789, 210.2536, 293.0843> }
					triangle { <144.789, 210.2536, 293.0843>, <143.9412, 211.7499, 288.4937>, <144.3608, 208.8718, 292.4201> }
					triangle { <145.4065, 204.8369, 292.0948>, <145.3397, 205.2765, 292.5208>, <144.7401, 207.5773, 292.8444> }
					triangle { <145.3397, 205.2765, 292.5208>, <147.9512, 205.0244, 291.8549>, <146.816, 207.6234, 293.4862> }
					triangle { <144.7401, 207.5773, 292.8444>, <146.816, 207.6234, 293.4862>, <146.0575, 208.6414, 293.207> }
					triangle { <144.7401, 207.5773, 292.8444>, <145.3397, 205.2765, 292.5208>, <146.816, 207.6234, 293.4862> }
					triangle { <143.0152, 208.1582, 292.1769>, <145.4065, 204.8369, 292.0948>, <144.7401, 207.5773, 292.8444> }
					triangle { <144.3608, 208.8718, 292.4201>, <144.7401, 207.5773, 292.8444>, <146.0575, 208.6414, 293.207> }
					triangle { <143.0152, 208.1582, 292.1769>, <144.7401, 207.5773, 292.8444>, <144.3608, 208.8718, 292.4201> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <143.7896, 213.0791, 281.959>, <144.033, 209.212, 292.6458>, <143.7509, 210.6881, 292.9928> }
					triangle { <143.7896, 213.0791, 281.959>, <143.7517, 210.1899, 287.5119>, <144.033, 209.212, 292.6458> }
					triangle { <143.7509, 210.6881, 292.9928>, <142.5677, 211.9013, 288.4098>, <143.7896, 213.0791, 281.959> }
					triangle { <143.7517, 210.1899, 287.5119>, <145.6924, 208.9512, 292.7201>, <144.033, 209.212, 292.6458> }
					triangle { <145.6924, 208.9512, 292.7201>, <147.7228, 210.1201, 294.1679>, <144.033, 209.212, 292.6458> }
					triangle { <143.7509, 210.6881, 292.9928>, <144.2016, 212.0526, 294.2118>, <142.4365, 211.5333, 293.2963> }
					triangle { <142.4365, 211.5333, 293.2963>, <142.5677, 211.9013, 288.4098>, <143.7509, 210.6881, 292.9928> }
					triangle { <147.7228, 210.1201, 294.1679>, <147.1599, 210.1772, 294.4111>, <144.8427, 210.481, 293.8673> }
					triangle { <147.1599, 210.1772, 294.4111>, <148.4621, 212.5472, 294.5293>, <145.2275, 212.317, 294.9648> }
					triangle { <144.8427, 210.481, 293.8673>, <145.2275, 212.317, 294.9648>, <144.2016, 212.0526, 294.2118> }
					triangle { <144.8427, 210.481, 293.8673>, <147.1599, 210.1772, 294.4111>, <145.2275, 212.317, 294.9648> }
					triangle { <144.033, 209.212, 292.6458>, <147.7228, 210.1201, 294.1679>, <144.8427, 210.481, 293.8673> }
					triangle { <143.7509, 210.6881, 292.9928>, <144.8427, 210.481, 293.8673>, <144.2016, 212.0526, 294.2118> }
					triangle { <144.033, 209.212, 292.6458>, <144.8427, 210.481, 293.8673>, <143.7509, 210.6881, 292.9928> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <143.7896, 213.0791, 281.959>, <143.2657, 210.4928, 293.016>, <141.7599, 210.7643, 292.8211> }
					triangle { <143.7896, 213.0791, 281.959>, <144.2317, 211.2442, 287.9273>, <143.2657, 210.4928, 293.016> }
					triangle { <141.7599, 210.7643, 292.8211>, <142.0278, 210.7153, 287.9424>, <143.7896, 213.0791, 281.959> }
					triangle { <144.2317, 211.2442, 287.9273>, <143.9959, 211.8988, 293.579>, <143.2657, 210.4928, 293.016> }
					triangle { <143.9959, 211.8988, 293.579>, <143.088, 214.0293, 295.0696>, <143.2657, 210.4928, 293.016> }
					triangle { <141.7599, 210.7643, 292.8211>, <140.2617, 211.5553, 293.6461>, <140.4903, 209.8536, 292.5167> }
					triangle { <140.4903, 209.8536, 292.5167>, <142.0278, 210.7153, 287.9424>, <141.7599, 210.7643, 292.8211> }
					triangle { <143.088, 214.0293, 295.0696>, <142.7679, 213.5073, 295.135>, <141.9644, 211.5744, 293.9619> }
					triangle { <142.7679, 213.5073, 295.135>, <141.0747, 215.6008, 294.8585>, <140.0794, 212.5028, 294.517> }
					triangle { <141.9644, 211.5744, 293.9619>, <140.0794, 212.5028, 294.517>, <140.2617, 211.5553, 293.6461> }
					triangle { <141.9644, 211.5744, 293.9619>, <142.7679, 213.5073, 295.135>, <140.0794, 212.5028, 294.517> }
					triangle { <143.2657, 210.4928, 293.016>, <143.088, 214.0293, 295.0696>, <141.9644, 211.5744, 293.9619> }
					triangle { <141.7599, 210.7643, 292.8211>, <141.9644, 211.5744, 293.9619>, <140.2617, 211.5553, 293.6461> }
					triangle { <143.2657, 210.4928, 293.016>, <141.9644, 211.5744, 293.9619>, <141.7599, 210.7643, 292.8211> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <143.7896, 213.0791, 281.959>, <141.7665, 210.2424, 292.7794>, <141.1209, 208.9958, 292.1407> }
					triangle { <143.7896, 213.0791, 281.959>, <143.3118, 212.0402, 288.1133>, <141.7665, 210.2424, 292.7794> }
					triangle { <141.1209, 208.9958, 292.1407>, <143.0626, 209.8197, 287.7332>, <143.7896, 213.0791, 281.959> }
					triangle { <143.3118, 212.0402, 288.1133>, <140.5652, 211.3853, 293.0583>, <141.7665, 210.2424, 292.7794> }
					triangle { <140.5652, 211.3853, 293.0583>, <137.864, 211.1985, 293.5622>, <141.7665, 210.2424, 292.7794> }
					triangle { <141.1209, 208.9958, 292.1407>, <139.6458, 207.8321, 292.2863>, <141.6218, 207.5201, 291.8156> }
					triangle { <141.6218, 207.5201, 291.8156>, <143.0626, 209.8197, 287.7332>, <141.1209, 208.9958, 292.1407> }
					triangle { <137.864, 211.1985, 293.5622>, <138.1923, 210.6957, 293.6989>, <140.0561, 209.3566, 292.9985> }
					triangle { <138.1923, 210.6957, 293.6989>, <135.9291, 209.9937, 292.3907>, <138.438, 207.9258, 292.7574> }
					triangle { <140.0561, 209.3566, 292.9985>, <138.438, 207.9258, 292.7574>, <139.6458, 207.8321, 292.2863> }
					triangle { <140.0561, 209.3566, 292.9985>, <138.1923, 210.6957, 293.6989>, <138.438, 207.9258, 292.7574> }
					triangle { <141.7665, 210.2424, 292.7794>, <137.864, 211.1985, 293.5622>, <140.0561, 209.3566, 292.9985> }
					triangle { <141.1209, 208.9958, 292.1407>, <140.0561, 209.3566, 292.9985>, <139.6458, 207.8321, 292.2863> }
					triangle { <141.7665, 210.2424, 292.7794>, <140.0561, 209.3566, 292.9985>, <141.1209, 208.9958, 292.1407> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <143.7896, 213.0791, 281.959>, <141.6094, 208.7778, 292.253>, <142.7526, 207.8085, 291.8891> }
					triangle { <143.7896, 213.0791, 281.959>, <142.2447, 211.4633, 287.8058>, <141.6094, 208.7778, 292.253> }
					triangle { <142.7526, 207.8085, 291.8891>, <144.263, 210.4688, 288.079>, <143.7896, 213.0791, 281.959> }
					triangle { <142.2447, 211.4633, 287.8058>, <140.145, 208.0539, 291.8547>, <141.6094, 208.7778, 292.253> }
					triangle { <140.145, 208.0539, 291.8547>, <139.3185, 205.4315, 291.6959>, <141.6094, 208.7778, 292.253> }
					triangle { <142.7526, 207.8085, 291.8891>, <143.2819, 206.004, 292.0109>, <144.3187, 207.7711, 292.1717> }
					triangle { <144.3187, 207.7711, 292.1717>, <144.263, 210.4688, 288.079>, <142.7526, 207.8085, 291.8891> }
					triangle { <139.3185, 205.4315, 291.6959>, <139.8058, 205.5321, 292.0588>, <141.7975, 206.8489, 292.2974> }
					triangle { <139.8058, 205.5321, 292.0588>, <140.2432, 203.3584, 290.5063>, <142.6644, 204.8647, 292.1107> }
					triangle { <141.7975, 206.8489, 292.2974>, <142.6644, 204.8647, 292.1107>, <143.2819, 206.004, 292.0109> }
					triangle { <141.7975, 206.8489, 292.2974>, <139.8058, 205.5321, 292.0588>, <142.6644, 204.8647, 292.1107> }
					triangle { <141.6094, 208.7778, 292.253>, <139.3185, 205.4315, 291.6959>, <141.7975, 206.8489, 292.2974> }
					triangle { <142.7526, 207.8085, 291.8891>, <141.7975, 206.8489, 292.2974>, <143.2819, 206.004, 292.0109> }
					triangle { <141.6094, 208.7778, 292.253>, <141.7975, 206.8489, 292.2974>, <142.7526, 207.8085, 291.8891> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <131.2085, 220.9165, 242.0007>, <131.038, 220.2577, 243.8103>, 0.2192 }
			cylinder { <131.038, 220.2577, 243.8103>, <130.6856, 219.6708, 245.6184>, 0.2192 }
			cylinder { <130.6856, 219.6708, 245.6184>, <130.1551, 219.1622, 247.4066>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <130.1551, 219.1622, 247.4066>, <129.2416, 218.8684, 249.085>, 0.2192 }
			cylinder { <129.2416, 218.8684, 249.085>, <128.4054, 218.395, 250.7626>, 0.2192 }
			cylinder { <128.4054, 218.395, 250.7626>, <127.6548, 217.7467, 252.4222>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <127.6548, 217.7467, 252.4222>, <126.6262, 216.4497, 254.8033>, 0.2192 }
				cylinder { <126.6262, 216.4497, 254.8033>, <125.7101, 214.8477, 257.0403>, 0.2192 }
				cylinder { <125.7101, 214.8477, 257.0403>, <124.9206, 212.9648, 259.0997>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <124.9206, 212.9648, 259.0997>, <123.079, 205.6101, 267.5695>, <122.3857, 206.8213, 268.2263> }
					triangle { <124.9206, 212.9648, 259.0997>, <124.0092, 208.308, 263.1823>, <123.079, 205.6101, 267.5695> }
					triangle { <122.3857, 206.8213, 268.2263>, <122.2683, 209.4335, 264.0986>, <124.9206, 212.9648, 259.0997> }
					triangle { <124.0092, 208.308, 263.1823>, <124.6679, 205.5405, 268.1152>, <123.079, 205.6101, 267.5695> }
					triangle { <124.6679, 205.5405, 268.1152>, <125.9014, 206.3525, 270.4398>, <123.079, 205.6101, 267.5695> }
					triangle { <122.3857, 206.8213, 268.2263>, <122.1622, 207.7067, 269.8747>, <120.8828, 207.3395, 268.3088> }
					triangle { <120.8828, 207.3395, 268.3088>, <122.2683, 209.4335, 264.0986>, <122.3857, 206.8213, 268.2263> }
					triangle { <125.9014, 206.3525, 270.4398>, <125.2956, 206.2516, 270.4851>, <123.2117, 206.4491, 269.3121> }
					triangle { <125.2956, 206.2516, 270.4851>, <125.9433, 208.5624, 271.737>, <122.8534, 207.8069, 270.9708> }
					triangle { <123.2117, 206.4491, 269.3121>, <122.8534, 207.8069, 270.9708>, <122.1622, 207.7067, 269.8747> }
					triangle { <123.2117, 206.4491, 269.3121>, <125.2956, 206.2516, 270.4851>, <122.8534, 207.8069, 270.9708> }
					triangle { <123.079, 205.6101, 267.5695>, <125.9014, 206.3525, 270.4398>, <123.2117, 206.4491, 269.3121> }
					triangle { <122.3857, 206.8213, 268.2263>, <123.2117, 206.4491, 269.3121>, <122.1622, 207.7067, 269.8747> }
					triangle { <123.079, 205.6101, 267.5695>, <123.2117, 206.4491, 269.3121>, <122.3857, 206.8213, 268.2263> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <124.9206, 212.9648, 259.0997>, <121.9702, 206.5738, 268.0257>, <120.5557, 206.7146, 267.4271> }
					triangle { <124.9206, 212.9648, 259.0997>, <124.1046, 209.195, 264.0299>, <121.9702, 206.5738, 268.0257> }
					triangle { <120.5557, 206.7146, 267.4271>, <122.1611, 208.4355, 263.145>, <124.9206, 212.9648, 259.0997> }
					triangle { <124.1046, 209.195, 264.0299>, <122.1791, 207.7645, 269.1944>, <121.9702, 206.5738, 268.0257> }
					triangle { <122.1791, 207.7645, 269.1944>, <120.4381, 209.1008, 270.8582>, <121.9702, 206.5738, 268.0257> }
					triangle { <120.5557, 206.7146, 267.4271>, <118.7496, 206.9752, 267.8974>, <119.6594, 205.8266, 266.4565> }
					triangle { <119.6594, 205.8266, 266.4565>, <122.1611, 208.4355, 263.145>, <120.5557, 206.7146, 267.4271> }
					triangle { <120.4381, 209.1008, 270.8582>, <120.2392, 208.5554, 270.6529>, <120.2491, 207.0844, 268.7571> }
					triangle { <120.2392, 208.5554, 270.6529>, <118.2596, 210.3916, 270.4636>, <118.1249, 207.522, 268.8975> }
					triangle { <120.2491, 207.0844, 268.7571>, <118.1249, 207.522, 268.8975>, <118.7496, 206.9752, 267.8974> }
					triangle { <120.2491, 207.0844, 268.7571>, <120.2392, 208.5554, 270.6529>, <118.1249, 207.522, 268.8975> }
					triangle { <121.9702, 206.5738, 268.0257>, <120.4381, 209.1008, 270.8582>, <120.2491, 207.0844, 268.7571> }
					triangle { <120.5557, 206.7146, 267.4271>, <120.2491, 207.0844, 268.7571>, <118.7496, 206.9752, 267.8974> }
					triangle { <121.9702, 206.5738, 268.0257>, <120.2491, 207.0844, 268.7571>, <120.5557, 206.7146, 267.4271> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <124.9206, 212.9648, 259.0997>, <120.6914, 206.2464, 267.236>, <120.5463, 205.2406, 266.0758> }
					triangle { <124.9206, 212.9648, 259.0997>, <123.0138, 209.7567, 264.1252>, <120.6914, 206.2464, 267.236> }
					triangle { <120.5463, 205.2406, 266.0758>, <123.3882, 207.8037, 263.0377>, <124.9206, 212.9648, 259.0997> }
					triangle { <123.0138, 209.7567, 264.1252>, <119.2335, 207.0629, 267.4236>, <120.6914, 206.2464, 267.236> }
					triangle { <119.2335, 207.0629, 267.4236>, <116.6133, 206.3873, 266.9106>, <120.6914, 206.2464, 267.236> }
					triangle { <120.5463, 205.2406, 266.0758>, <119.3914, 203.9335, 265.3623>, <121.4378, 204.0482, 265.5122> }
					triangle { <121.4378, 204.0482, 265.5122>, <123.3882, 207.8037, 263.0377>, <120.5463, 205.2406, 266.0758> }
					triangle { <116.6133, 206.3873, 266.9106>, <116.9962, 205.9119, 266.9925>, <119.2335, 205.1426, 266.5923> }
					triangle { <116.9962, 205.9119, 266.9925>, <115.401, 205.4552, 264.854>, <118.112, 203.7083, 265.4055> }
					triangle { <119.2335, 205.1426, 266.5923>, <118.112, 203.7083, 265.4055>, <119.3914, 203.9335, 265.3623> }
					triangle { <119.2335, 205.1426, 266.5923>, <116.9962, 205.9119, 266.9925>, <118.112, 203.7083, 265.4055> }
					triangle { <120.6914, 206.2464, 267.236>, <116.6133, 206.3873, 266.9106>, <119.2335, 205.1426, 266.5923> }
					triangle { <120.5463, 205.2406, 266.0758>, <119.2335, 205.1426, 266.5923>, <119.3914, 203.9335, 265.3623> }
					triangle { <120.6914, 206.2464, 267.236>, <119.2335, 205.1426, 266.5923>, <120.5463, 205.2406, 266.0758> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <124.9206, 212.9648, 259.0997>, <120.9978, 205.0773, 266.2845>, <122.3704, 204.4225, 266.0271> }
					triangle { <124.9206, 212.9648, 259.0997>, <122.2341, 209.222, 263.3374>, <120.9978, 205.0773, 266.2845> }
					triangle { <122.3704, 204.4225, 266.0271>, <124.2653, 208.4052, 263.924>, <124.9206, 212.9648, 259.0997> }
					triangle { <122.2341, 209.222, 263.3374>, <119.8743, 204.3989, 265.2334>, <120.9978, 205.0773, 266.2845> }
					triangle { <119.8743, 204.3989, 265.2334>, <119.6771, 201.9365, 264.0157>, <120.9978, 205.0773, 266.2845> }
					triangle { <122.3704, 204.4225, 266.0271>, <123.2066, 202.7568, 265.7492>, <123.7769, 204.4454, 266.7722> }
					triangle { <123.7769, 204.4454, 266.7722>, <124.2653, 208.4052, 263.924>, <122.3704, 204.4225, 266.0271> }
					triangle { <119.6771, 201.9365, 264.0157>, <120.0181, 201.9497, 264.5283>, <121.559, 203.2891, 265.7891> }
					triangle { <120.0181, 201.9497, 264.5283>, <121.2913, 200.5291, 262.6082>, <122.8324, 201.6006, 265.2881> }
					triangle { <121.559, 203.2891, 265.7891>, <122.8324, 201.6006, 265.2881>, <123.2066, 202.7568, 265.7492> }
					triangle { <121.559, 203.2891, 265.7891>, <120.0181, 201.9497, 264.5283>, <122.8324, 201.6006, 265.2881> }
					triangle { <120.9978, 205.0773, 266.2845>, <119.6771, 201.9365, 264.0157>, <121.559, 203.2891, 265.7891> }
					triangle { <122.3704, 204.4225, 266.0271>, <121.559, 203.2891, 265.7891>, <123.2066, 202.7568, 265.7492> }
					triangle { <120.9978, 205.0773, 266.2845>, <121.559, 203.2891, 265.7891>, <122.3704, 204.4225, 266.0271> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <124.9206, 212.9648, 259.0997>, <122.4957, 204.678, 266.4937>, <123.5244, 205.4142, 267.3763> }
					triangle { <124.9206, 212.9648, 259.0997>, <122.8586, 208.3131, 262.7458>, <122.4957, 204.678, 266.4937> }
					triangle { <123.5244, 205.4142, 267.3763>, <123.5628, 209.4276, 264.5895>, <124.9206, 212.9648, 259.0997> }
					triangle { <122.8586, 208.3131, 262.7458>, <123.2836, 203.4438, 265.6673>, <122.4957, 204.678, 266.4937> }
					triangle { <123.2836, 203.4438, 265.6673>, <125.5041, 201.9147, 266.2299>, <122.4957, 204.678, 266.4937> }
					triangle { <123.5244, 205.4142, 267.3763>, <124.9449, 205.1239, 268.58>, <123.4288, 206.5103, 268.5268> }
					triangle { <123.4288, 206.5103, 268.5268>, <123.5628, 209.4276, 264.5895>, <123.5244, 205.4142, 267.3763> }
					triangle { <125.5041, 201.9147, 266.2299>, <125.2249, 202.1628, 266.7195>, <124.0548, 204.1087, 267.4954> }
					triangle { <125.2249, 202.1628, 266.7195>, <127.9052, 202.4784, 266.9263>, <125.807, 204.1719, 268.7796> }
					triangle { <124.0548, 204.1087, 267.4954>, <125.807, 204.1719, 268.7796>, <124.9449, 205.1239, 268.58> }
					triangle { <124.0548, 204.1087, 267.4954>, <125.2249, 202.1628, 266.7195>, <125.807, 204.1719, 268.7796> }
					triangle { <122.4957, 204.678, 266.4937>, <125.5041, 201.9147, 266.2299>, <124.0548, 204.1087, 267.4954> }
					triangle { <123.5244, 205.4142, 267.3763>, <124.0548, 204.1087, 267.4954>, <124.9449, 205.1239, 268.58> }
					triangle { <122.4957, 204.678, 266.4937>, <124.0548, 204.1087, 267.4954>, <123.5244, 205.4142, 267.3763> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <130.1551, 219.1622, 247.4066>, <130.0365, 218.4665, 249.2065>, 0.2192 }
			cylinder { <130.0365, 218.4665, 249.2065>, <129.8269, 217.9371, 251.0541>, 0.2192 }
			cylinder { <129.8269, 217.9371, 251.0541>, <129.5284, 217.5796, 252.9305>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <129.5284, 217.5796, 252.9305>, <129.0063, 217.3896, 255.7768>, 0.2192 }
				cylinder { <129.0063, 217.3896, 255.7768>, <128.4175, 217.5489, 258.6119>, 0.2192 }
				cylinder { <128.4175, 217.5489, 258.6119>, <127.771, 218.0549, 261.3932>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <127.771, 218.0549, 261.3932>, <123.974, 220.0033, 271.9293>, <124.4044, 218.54, 272.1586> }
					triangle { <127.771, 218.0549, 261.3932>, <125.8004, 219.9484, 267.0248>, <123.974, 220.0033, 271.9293> }
					triangle { <124.4044, 218.54, 272.1586>, <126.9765, 218.2814, 268.0122>, <127.771, 218.0549, 261.3932> }
					triangle { <125.8004, 219.9484, 267.0248>, <122.3374, 220.027, 271.5445>, <123.974, 220.0033, 271.9293> }
					triangle { <122.3374, 220.027, 271.5445>, <120.2268, 218.3742, 272.176>, <123.974, 220.0033, 271.9293> }
					triangle { <124.4044, 218.54, 272.1586>, <123.8854, 216.9426, 273.0131>, <125.7139, 217.8363, 272.728> }
					triangle { <125.7139, 217.8363, 272.728>, <126.9765, 218.2814, 268.0122>, <124.4044, 218.54, 272.1586> }
					triangle { <120.2268, 218.3742, 272.176>, <120.7038, 218.3516, 272.5648>, <123.0979, 218.4514, 272.6924> }
					triangle { <120.7038, 218.3516, 272.5648>, <119.8519, 215.845, 272.0014>, <122.7563, 216.4226, 273.3928> }
					triangle { <123.0979, 218.4514, 272.6924>, <122.7563, 216.4226, 273.3928>, <123.8854, 216.9426, 273.0131> }
					triangle { <123.0979, 218.4514, 272.6924>, <120.7038, 218.3516, 272.5648>, <122.7563, 216.4226, 273.3928> }
					triangle { <123.974, 220.0033, 271.9293>, <120.2268, 218.3742, 272.176>, <123.0979, 218.4514, 272.6924> }
					triangle { <124.4044, 218.54, 272.1586>, <123.0979, 218.4514, 272.6924>, <123.8854, 216.9426, 273.0131> }
					triangle { <123.974, 220.0033, 271.9293>, <123.0979, 218.4514, 272.6924>, <124.4044, 218.54, 272.1586> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <127.771, 218.0549, 261.3932>, <124.8234, 218.7908, 272.3473>, <126.3491, 218.7566, 272.5713> }
					triangle { <127.771, 218.0549, 261.3932>, <125.4172, 218.7854, 267.1473>, <124.8234, 218.7908, 272.3473> }
					triangle { <126.3491, 218.7566, 272.5713>, <127.4076, 219.5898, 267.8744>, <127.771, 218.0549, 261.3932> }
					triangle { <125.4172, 218.7854, 267.1473>, <124.2246, 217.2264, 272.4927>, <124.8234, 218.7908, 272.3473> }
					triangle { <124.2246, 217.2264, 272.4927>, <125.0519, 215.0139, 273.9089>, <124.8234, 218.7908, 272.3473> }
					triangle { <126.3491, 218.7566, 272.5713>, <127.6821, 218.0424, 273.6956>, <127.4749, 219.8647, 272.7683> }
					triangle { <127.4749, 219.8647, 272.7683>, <127.4076, 219.5898, 267.8744>, <126.3491, 218.7566, 272.5713> }
					triangle { <125.0519, 215.0139, 273.9089>, <125.2463, 215.555, 274.1295>, <125.9878, 217.7464, 273.4925> }
					triangle { <125.2463, 215.555, 274.1295>, <127.289, 213.7793, 274.106>, <127.784, 216.9943, 274.4576> }
					triangle { <125.9878, 217.7464, 273.4925>, <127.784, 216.9943, 274.4576>, <127.6821, 218.0424, 273.6956> }
					triangle { <125.9878, 217.7464, 273.4925>, <125.2463, 215.555, 274.1295>, <127.784, 216.9943, 274.4576> }
					triangle { <124.8234, 218.7908, 272.3473>, <125.0519, 215.0139, 273.9089>, <125.9878, 217.7464, 273.4925> }
					triangle { <126.3491, 218.7566, 272.5713>, <125.9878, 217.7464, 273.4925>, <127.6821, 218.0424, 273.6956> }
					triangle { <124.8234, 218.7908, 272.3473>, <125.9878, 217.7464, 273.4925>, <126.3491, 218.7566, 272.5713> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <127.771, 218.0549, 261.3932>, <126.2632, 219.2726, 272.5944>, <126.8302, 220.6829, 272.3327> }
					triangle { <127.771, 218.0549, 261.3932>, <126.3764, 218.0976, 267.4955>, <126.2632, 219.2726, 272.5944> }
					triangle { <126.8302, 220.6829, 272.3327>, <126.3284, 220.3636, 267.4828>, <127.771, 218.0549, 261.3932> }
					triangle { <126.3764, 218.0976, 267.4955>, <127.5242, 218.2673, 273.0704>, <126.2632, 219.2726, 272.5944> }
					triangle { <127.5242, 218.2673, 273.0704>, <129.9127, 218.7208, 274.3645>, <126.2632, 219.2726, 272.5944> }
					triangle { <126.8302, 220.6829, 272.3327>, <127.9846, 221.9895, 273.0478>, <126.1868, 222.1132, 272.0598> }
					triangle { <126.1868, 222.1132, 272.0598>, <126.3284, 220.3636, 267.4828>, <126.8302, 220.6829, 272.3327> }
					triangle { <129.9127, 218.7208, 274.3645>, <129.4772, 219.1457, 274.4597>, <127.6689, 220.3264, 273.4139> }
					triangle { <129.4772, 219.1457, 274.4597>, <131.8518, 220.3497, 273.9713>, <129.0169, 221.9777, 273.8375> }
					triangle { <127.6689, 220.3264, 273.4139>, <129.0169, 221.9777, 273.8375>, <127.9846, 221.9895, 273.0478> }
					triangle { <127.6689, 220.3264, 273.4139>, <129.4772, 219.1457, 274.4597>, <129.0169, 221.9777, 273.8375> }
					triangle { <126.2632, 219.2726, 272.5944>, <129.9127, 218.7208, 274.3645>, <127.6689, 220.3264, 273.4139> }
					triangle { <126.8302, 220.6829, 272.3327>, <127.6689, 220.3264, 273.4139>, <127.9846, 221.9895, 273.0478> }
					triangle { <126.2632, 219.2726, 272.5944>, <127.6689, 220.3264, 273.4139>, <126.8302, 220.6829, 272.3327> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <127.771, 218.0549, 261.3932>, <126.3171, 220.7872, 272.3313>, <125.1873, 221.6748, 271.7703> }
					triangle { <127.771, 218.0549, 261.3932>, <127.3614, 218.8291, 267.5913>, <126.3171, 220.7872, 272.3313> }
					triangle { <125.1873, 221.6748, 271.7703>, <125.2204, 219.5406, 267.3749>, <127.771, 218.0549, 261.3932> }
					triangle { <127.3614, 218.8291, 267.5913>, <127.707, 221.721, 272.4846>, <126.3171, 220.7872, 272.3313> }
					triangle { <127.707, 221.721, 272.4846>, <128.1371, 224.4067, 272.9173>, <126.3171, 220.7872, 272.3313> }
					triangle { <125.1873, 221.6748, 271.7703>, <124.3776, 223.3659, 271.9589>, <123.6177, 221.4955, 271.575> }
					triangle { <123.6177, 221.4955, 271.575>, <125.2204, 219.5406, 267.3749>, <125.1873, 221.6748, 271.7703> }
					triangle { <128.1371, 224.4067, 272.9173>, <127.5891, 224.195, 273.1022>, <125.8337, 222.65, 272.5645> }
					triangle { <127.5891, 224.195, 273.1022>, <127.2772, 226.5374, 271.7822>, <124.7626, 224.5324, 272.3838> }
					triangle { <125.8337, 222.65, 272.5645>, <124.7626, 224.5324, 272.3838>, <124.3776, 223.3659, 271.9589> }
					triangle { <125.8337, 222.65, 272.5645>, <127.5891, 224.195, 273.1022>, <124.7626, 224.5324, 272.3838> }
					triangle { <126.3171, 220.7872, 272.3313>, <128.1371, 224.4067, 272.9173>, <125.8337, 222.65, 272.5645> }
					triangle { <125.1873, 221.6748, 271.7703>, <125.8337, 222.65, 272.5645>, <124.3776, 223.3659, 271.9589> }
					triangle { <126.3171, 220.7872, 272.3313>, <125.8337, 222.65, 272.5645>, <125.1873, 221.6748, 271.7703> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <127.771, 218.0549, 261.3932>, <124.8809, 221.2456, 271.9141>, <123.6655, 220.3304, 271.6612> }
					triangle { <127.771, 218.0549, 261.3932>, <127.0, 219.9902, 267.2961>, <124.8809, 221.2456, 271.9141> }
					triangle { <123.6655, 220.3304, 271.6612>, <125.6269, 218.2344, 267.707>, <127.771, 218.0549, 261.3932> }
					triangle { <127.0, 219.9902, 267.2961>, <124.4529, 222.825, 271.5273>, <124.8809, 221.2456, 271.9141> }
					triangle { <124.4529, 222.825, 271.5273>, <122.0605, 224.1892, 271.5443>, <124.8809, 221.2456, 271.9141> }
					triangle { <123.6655, 220.3304, 271.6612>, <121.8059, 220.1997, 271.9371>, <123.321, 218.8123, 271.9941> }
					triangle { <123.321, 218.8123, 271.9941>, <125.6269, 218.2344, 267.707>, <123.6655, 220.3304, 271.6612> }
					triangle { <122.0605, 224.1892, 271.5443>, <122.085, 223.6968, 271.9134>, <122.966, 221.4737, 272.1119> }
					triangle { <122.085, 223.6968, 271.9134>, <119.7489, 223.7113, 270.5463>, <120.8349, 221.0473, 272.1048> }
					triangle { <122.966, 221.4737, 272.1119>, <120.8349, 221.0473, 272.1048>, <121.8059, 220.1997, 271.9371> }
					triangle { <122.966, 221.4737, 272.1119>, <122.085, 223.6968, 271.9134>, <120.8349, 221.0473, 272.1048> }
					triangle { <124.8809, 221.2456, 271.9141>, <122.0605, 224.1892, 271.5443>, <122.966, 221.4737, 272.1119> }
					triangle { <123.6655, 220.3304, 271.6612>, <122.966, 221.4737, 272.1119>, <121.8059, 220.1997, 271.9371> }
					triangle { <124.8809, 221.2456, 271.9141>, <122.966, 221.4737, 272.1119>, <123.6655, 220.3304, 271.6612> }
					material { txgilia_flower }}
				}
			}
		}
	union { // internode
		cylinder { <88.2094, 165.8878, 81.02787>, <93.4603, 177.1069, 91.9751>, 0.5 }
		cylinder { <93.4603, 177.1069, 91.9751>, <99.02454, 188.0842, 103.0124>, 0.5 }
		cylinder { <99.02454, 188.0842, 103.0124>, <104.8986, 198.8131, 114.133>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <104.8986, 198.8131, 114.133>, <109.4532, 201.9158, 119.5314>, 0.4999 }
			cylinder { <109.4532, 201.9158, 119.5314>, <115.2888, 202.7517, 124.5075>, 0.4999 }
			cylinder { <115.2888, 202.7517, 124.5075>, <121.7232, 201.2229, 128.4795>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <121.7232, 201.2229, 128.4795>, <124.4316, 200.5114, 130.1094>, 0.4999 }
				cylinder { <124.4316, 200.5114, 130.1094>, <127.1444, 199.7309, 131.7>, 0.4999 }
				cylinder { <127.1444, 199.7309, 131.7>, <129.8599, 198.8819, 133.2503>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <129.8599, 198.8819, 133.2503>, <130.2687, 198.6535, 133.6523>, 0.03999 }
				cylinder { <130.2687, 198.6535, 133.6523>, <130.5394, 198.3749, 134.1319>, 0.03999 }
				cylinder { <130.5394, 198.3749, 134.1319>, <130.6524, 198.0664, 134.6543>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <130.6524, 198.0664, 134.6543>, <137.6568, 183.8002, 158.1732>, <135.9074, 182.1765, 157.9741> }
				triangle { <137.6568, 183.8002, 158.1732>, <144.0196, 173.6867, 158.0382>, <135.9074, 182.1765, 157.9741> }
				triangle { <137.6568, 183.8002, 158.1732>, <144.4586, 176.8284, 158.427>, <144.0196, 173.6867, 158.0382> }
				triangle { <144.0196, 173.6867, 158.0382>, <140.3628, 174.3203, 157.9469>, <135.9074, 182.1765, 157.9741> }
				triangle { <135.9074, 182.1765, 157.9741>, <133.7195, 186.8571, 147.8143>, <130.6524, 198.0664, 134.6543> }
				triangle { <130.6524, 198.0664, 134.6543>, <137.2495, 189.1956, 148.3243>, <137.6568, 183.8002, 158.1732> }
				triangle { <137.2495, 189.1956, 148.3243>, <141.35, 183.5847, 156.6451>, <137.6568, 183.8002, 158.1732> }
				triangle { <141.35, 183.5847, 156.6451>, <144.4586, 176.8284, 158.427>, <137.6568, 183.8002, 158.1732> }
				triangle { <135.9074, 182.1765, 157.9741>, <140.3628, 174.3203, 157.9469>, <136.4675, 178.7166, 155.9703> }
				triangle { <136.4675, 178.7166, 155.9703>, <133.7195, 186.8571, 147.8143>, <135.9074, 182.1765, 157.9741> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <129.8599, 198.8819, 133.2503>, <130.3771, 198.7202, 133.5456>, 0.03999 }
				cylinder { <130.3771, 198.7202, 133.5456>, <130.8943, 198.5585, 133.8409>, 0.03999 }
				cylinder { <130.8943, 198.5585, 133.8409>, <131.4116, 198.3968, 134.1362>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <131.4116, 198.3968, 134.1362>, <156.1601, 191.4701, 146.1885>, <155.4432, 189.3104, 146.936> }
				triangle { <156.1601, 191.4701, 146.1885>, <164.2823, 184.4813, 140.8993>, <155.4432, 189.3104, 146.936> }
				triangle { <156.1601, 191.4701, 146.1885>, <163.6395, 187.5864, 141.2986>, <164.2823, 184.4813, 140.8993> }
				triangle { <164.2823, 184.4813, 140.8993>, <161.4646, 183.7159, 143.192>, <155.4432, 189.3104, 146.936> }
				triangle { <155.4432, 189.3104, 146.936>, <145.8896, 191.247, 141.0289>, <131.4116, 198.3968, 134.1362> }
				triangle { <131.4116, 198.3968, 134.1362>, <147.7569, 194.7601, 139.4923>, <156.1601, 191.4701, 146.1885> }
				triangle { <147.7569, 194.7601, 139.4923>, <157.8444, 192.3834, 142.6743>, <156.1601, 191.4701, 146.1885> }
				triangle { <157.8444, 192.3834, 142.6743>, <163.6395, 187.5864, 141.2986>, <156.1601, 191.4701, 146.1885> }
				triangle { <155.4432, 189.3104, 146.936>, <161.4646, 183.7159, 143.192>, <155.8972, 186.0287, 144.6285> }
				triangle { <155.8972, 186.0287, 144.6285>, <145.8896, 191.247, 141.0289>, <155.4432, 189.3104, 146.936> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <104.8986, 198.8131, 114.133>, <110.1302, 211.5193, 123.3236>, 0.5 }
		cylinder { <110.1302, 211.5193, 123.3236>, <114.5655, 225.8284, 130.3135>, 0.5 }
		cylinder { <114.5655, 225.8284, 130.3135>, <118.0737, 241.3193, 134.897>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <118.0737, 241.3193, 134.897>, <118.7903, 249.0, 134.8097>, 0.4999 }
			cylinder { <118.7903, 249.0, 134.8097>, <118.514, 256.357, 132.505>, 0.4999 }
			cylinder { <118.514, 256.357, 132.505>, <117.2726, 262.6478, 128.2155>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <117.2726, 262.6478, 128.2155>, <116.7217, 265.2437, 126.3564>, 0.4999 }
				cylinder { <116.7217, 265.2437, 126.3564>, <116.1417, 267.7917, 124.4408>, 0.4999 }
				cylinder { <116.1417, 267.7917, 124.4408>, <115.5328, 270.2903, 122.4699>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <115.5328, 270.2903, 122.4699>, <115.5714, 270.7343, 122.0429>, 0.03999 }
				cylinder { <115.5714, 270.7343, 122.0429>, <115.7619, 271.114, 121.5953>, 0.03999 }
				cylinder { <115.7619, 271.114, 121.5953>, <116.0904, 271.402, 121.1594>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <116.0904, 271.402, 121.1594>, <128.9133, 283.1702, 98.7359>, <130.0312, 281.1673, 98.04639> }
				triangle { <128.9133, 283.1702, 98.7359>, <124.8355, 282.0885, 87.556>, <130.0312, 281.1673, 98.04639> }
				triangle { <128.9133, 283.1702, 98.7359>, <124.6966, 284.1367, 90.00548>, <124.8355, 282.0885, 87.556> }
				triangle { <124.8355, 282.0885, 87.556>, <127.2543, 280.0721, 89.5221>, <130.0312, 281.1673, 98.04639> }
				triangle { <130.0312, 281.1673, 98.04639>, <123.9735, 275.8786, 106.1241>, <116.0904, 271.402, 121.1594> }
				triangle { <116.0904, 271.402, 121.1594>, <121.8323, 279.5272, 106.6647>, <128.9133, 283.1702, 98.7359> }
				triangle { <121.8323, 279.5272, 106.6647>, <125.2772, 284.4221, 97.6256>, <128.9133, 283.1702, 98.7359> }
				triangle { <125.2772, 284.4221, 97.6256>, <124.6966, 284.1367, 90.00548>, <128.9133, 283.1702, 98.7359> }
				triangle { <130.0312, 281.1673, 98.04639>, <127.2543, 280.0721, 89.5221>, <128.3234, 278.5948, 95.4451> }
				triangle { <128.3234, 278.5948, 95.4451>, <123.9735, 275.8786, 106.1241>, <130.0312, 281.1673, 98.04639> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <115.5328, 270.2903, 122.4699>, <115.4168, 270.7663, 122.0945>, 0.03999 }
				cylinder { <115.4168, 270.7663, 122.0945>, <115.3008, 271.2422, 121.7191>, 0.03999 }
				cylinder { <115.3008, 271.2422, 121.7191>, <115.1849, 271.7181, 121.3437>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <115.1849, 271.7181, 121.3437>, <107.5497, 291.4046, 102.3734>, <108.8544, 290.4991, 100.5805> }
				triangle { <107.5497, 291.4046, 102.3734>, <99.07349, 289.6172, 94.1425>, <108.8544, 290.4991, 100.5805> }
				triangle { <107.5497, 291.4046, 102.3734>, <99.4025, 290.8941, 97.05379>, <99.07349, 289.6172, 94.1425> }
				triangle { <99.07349, 289.6172, 94.1425>, <102.7498, 289.1055, 94.07167>, <108.8544, 290.4991, 100.5805> }
				triangle { <108.8544, 290.4991, 100.5805>, <111.004, 281.7365, 107.5453>, <115.1849, 271.7181, 121.3437> }
				triangle { <115.1849, 271.7181, 121.3437>, <108.1692, 283.4165, 110.2528>, <107.5497, 291.4046, 102.3734> }
				triangle { <108.1692, 283.4165, 110.2528>, <103.7685, 290.4948, 103.32>, <107.5497, 291.4046, 102.3734> }
				triangle { <103.7685, 290.4948, 103.32>, <99.4025, 290.8941, 97.05379>, <107.5497, 291.4046, 102.3734> }
				triangle { <108.8544, 290.4991, 100.5805>, <102.7498, 289.1055, 94.07167>, <107.321, 287.7652, 98.03592> }
				triangle { <107.321, 287.7652, 98.03592>, <111.004, 281.7365, 107.5453>, <108.8544, 290.4991, 100.5805> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <118.0737, 241.3193, 134.897>, <120.8549, 257.3764, 137.6746>, 0.5 }
		cylinder { <120.8549, 257.3764, 137.6746>, <122.8671, 273.7584, 138.6046>, 0.5 }
		cylinder { <122.8671, 273.7584, 138.6046>, <124.08, 290.2188, 137.6731>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <124.08, 290.2188, 137.6731>, <123.5868, 297.2231, 134.948>, 0.4881 }
			cylinder { <123.5868, 297.2231, 134.948>, <122.1053, 302.9133, 130.2407>, 0.4881 }
			cylinder { <122.1053, 302.9133, 130.2407>, <119.8088, 306.624, 124.1017>, 0.4881 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <119.8088, 306.624, 124.1017>, <118.8038, 308.0462, 121.4607>, 0.4881 }
				cylinder { <118.8038, 308.0462, 121.4607>, <117.7607, 309.3288, 118.7636>, 0.4881 }
				cylinder { <117.7607, 309.3288, 118.7636>, <116.6821, 310.4687, 116.0169>, 0.4881 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <116.6821, 310.4687, 116.0169>, <116.6181, 310.6614, 115.4648>, 0.03812 }
				cylinder { <116.6181, 310.6614, 115.4648>, <116.6946, 310.8235, 114.9044>, 0.03812 }
				cylinder { <116.6946, 310.8235, 114.9044>, <116.9071, 310.9451, 114.3695>, 0.03812 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <116.9071, 310.9451, 114.3695>, <125.1849, 316.8814, 88.5957>, <126.6449, 315.0636, 88.4157> }
				triangle { <125.1849, 316.8814, 88.5957>, <120.892, 311.5831, 79.1296>, <126.6449, 315.0636, 88.4157> }
				triangle { <125.1849, 316.8814, 88.5957>, <120.4553, 314.1857, 80.7945>, <120.892, 311.5831, 79.1296> }
				triangle { <120.892, 311.5831, 79.1296>, <123.7466, 310.8422, 81.2367>, <126.6449, 315.0636, 88.4157> }
				triangle { <126.6449, 315.0636, 88.4157>, <122.5271, 311.705, 98.1934>, <116.9071, 310.9451, 114.3695> }
				triangle { <116.9071, 310.9451, 114.3695>, <119.7259, 314.7695, 97.8753>, <125.1849, 316.8814, 88.5957> }
				triangle { <119.7259, 314.7695, 97.8753>, <121.3924, 316.9733, 87.6576>, <125.1849, 316.8814, 88.5957> }
				triangle { <121.3924, 316.9733, 87.6576>, <120.4553, 314.1857, 80.7945>, <125.1849, 316.8814, 88.5957> }
				triangle { <126.6449, 315.0636, 88.4157>, <123.7466, 310.8422, 81.2367>, <125.4341, 311.5901, 86.9991> }
				triangle { <125.4341, 311.5901, 86.9991>, <122.5271, 311.705, 98.1934>, <126.6449, 315.0636, 88.4157> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <116.6821, 310.4687, 116.0169>, <116.4815, 310.6806, 115.5061>, 0.03812 }
				cylinder { <116.4815, 310.6806, 115.5061>, <116.2809, 310.8926, 114.9953>, 0.03812 }
				cylinder { <116.2809, 310.8926, 114.9953>, <116.0803, 311.1046, 114.4845>, 0.03812 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <116.0803, 311.1046, 114.4845>, <104.9316, 320.8962, 91.0777>, <106.1846, 319.5274, 89.6547> }
				triangle { <104.9316, 320.8962, 91.0777>, <96.4139, 315.421, 85.2827>, <106.1846, 319.5274, 89.6547> }
				triangle { <104.9316, 320.8962, 91.0777>, <96.7675, 317.6927, 87.3923>, <96.4139, 315.421, 85.2827> }
				triangle { <96.4139, 315.421, 85.2827>, <100.0242, 315.2697, 84.9985>, <106.1846, 319.5274, 89.6547> }
				triangle { <106.1846, 319.5274, 89.6547>, <109.8407, 314.4978, 98.8838>, <116.0803, 311.1046, 114.4845> }
				triangle { <116.0803, 311.1046, 114.4845>, <107.074, 316.7666, 101.0139>, <104.9316, 320.8962, 91.0777> }
				triangle { <107.074, 316.7666, 101.0139>, <101.4592, 320.0945, 92.6811>, <104.9316, 320.8962, 91.0777> }
				triangle { <101.4592, 320.0945, 92.6811>, <96.7675, 317.6927, 87.3923>, <104.9316, 320.8962, 91.0777> }
				triangle { <106.1846, 319.5274, 89.6547>, <100.0242, 315.2697, 84.9985>, <104.877, 315.9789, 88.5424> }
				triangle { <104.877, 315.9789, 88.5424>, <109.8407, 314.4978, 98.8838>, <106.1846, 319.5274, 89.6547> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <124.08, 290.2188, 137.6731>, <124.2451, 306.6108, 139.8074>, 0.5 }
		cylinder { <124.2451, 306.6108, 139.8074>, <123.3558, 322.3047, 144.9254>, 0.5 }
		cylinder { <123.3558, 322.3047, 144.9254>, <121.4465, 336.6972, 152.8306>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <121.4465, 336.6972, 152.8306>, <120.4648, 339.7375, 156.1987>, 0.3008 }
			cylinder { <120.4648, 339.7375, 156.1987>, <119.1523, 341.4209, 160.3212>, 0.3008 }
			cylinder { <119.1523, 341.4209, 160.3212>, <117.6625, 341.5506, 164.716>, 0.3008 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <117.6625, 341.5506, 164.716>, <117.0773, 341.5071, 166.5754>, 0.3008 }
				cylinder { <117.0773, 341.5071, 166.5754>, <116.5345, 341.3656, 168.4428>, 0.3008 }
				cylinder { <116.5345, 341.3656, 168.4428>, <116.0356, 341.1265, 170.3124>, 0.3008 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <116.0356, 341.1265, 170.3124>, <115.9276, 341.1027, 170.5066>, 0.01448 }
				cylinder { <115.9276, 341.1027, 170.5066>, <115.7754, 341.0837, 170.6691>, 0.01448 }
				cylinder { <115.7754, 341.0837, 170.6691>, <115.5879, 341.0709, 170.7901>, 0.01448 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <115.5879, 341.0709, 170.7901>, <101.8917, 339.7408, 180.9101>, <101.0997, 338.997, 179.9632> }
				triangle { <101.8917, 339.7408, 180.9101>, <100.3953, 333.8513, 184.7546>, <101.0997, 338.997, 179.9632> }
				triangle { <101.8917, 339.7408, 180.9101>, <101.251, 335.56, 184.9707>, <100.3953, 333.8513, 184.7546> }
				triangle { <100.3953, 333.8513, 184.7546>, <99.789, 334.4886, 182.7011>, <101.0997, 338.997, 179.9632> }
				triangle { <101.0997, 338.997, 179.9632>, <106.7659, 338.7227, 176.1079>, <115.5879, 341.0709, 170.7901> }
				triangle { <115.5879, 341.0709, 170.7901>, <108.0335, 339.7658, 178.0806>, <101.8917, 339.7408, 180.9101> }
				triangle { <108.0335, 339.7658, 178.0806>, <103.3915, 338.8536, 182.5729>, <101.8917, 339.7408, 180.9101> }
				triangle { <103.3915, 338.8536, 182.5729>, <101.251, 335.56, 184.9707>, <101.8917, 339.7408, 180.9101> }
				triangle { <101.0997, 338.997, 179.9632>, <99.789, 334.4886, 182.7011>, <101.1364, 336.5682, 179.9139> }
				triangle { <101.1364, 336.5682, 179.9139>, <106.7659, 338.7227, 176.1079>, <101.0997, 338.997, 179.9632> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <116.0356, 341.1265, 170.3124>, <115.9784, 341.0991, 170.5267>, 0.01448 }
				cylinder { <115.9784, 341.0991, 170.5267>, <115.9212, 341.0717, 170.741>, 0.01448 }
				cylinder { <115.9212, 341.0717, 170.741>, <115.864, 341.0443, 170.9553>, 0.01448 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <115.864, 341.0443, 170.9553>, <112.5685, 338.6803, 187.548>, <111.413, 337.8454, 187.3355> }
				triangle { <112.5685, 338.6803, 187.548>, <114.5144, 332.7651, 191.1439>, <111.413, 337.8454, 187.3355> }
				triangle { <112.5685, 338.6803, 187.548>, <115.1493, 334.5501, 190.8128>, <114.5144, 332.7651, 191.1439> }
				triangle { <114.5144, 332.7651, 191.1439>, <112.6436, 333.2976, 190.0451>, <111.413, 337.8454, 187.3355> }
				triangle { <111.413, 337.8454, 187.3355>, <113.0663, 338.0101, 180.6808>, <115.864, 341.0443, 170.9553> }
				triangle { <115.864, 341.0443, 170.9553>, <115.2325, 339.2098, 181.3553>, <112.5685, 338.6803, 187.548> }
				triangle { <115.2325, 339.2098, 181.3553>, <114.862, 337.973, 187.7501>, <112.5685, 338.6803, 187.548> }
				triangle { <114.862, 337.973, 187.7501>, <115.1493, 334.5501, 190.8128>, <112.5685, 338.6803, 187.548> }
				triangle { <111.413, 337.8454, 187.3355>, <112.6436, 333.2976, 190.0451>, <111.6109, 335.43, 187.165> }
				triangle { <111.6109, 335.43, 187.165>, <113.0663, 338.0101, 180.6808>, <111.413, 337.8454, 187.3355> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <121.4465, 336.6972, 152.8306>, <122.3251, 351.4538, 159.1501>, 0.4862 }
		cylinder { <122.3251, 351.4538, 159.1501>, <125.9055, 366.403, 163.8583>, 0.4862 }
		cylinder { <125.9055, 366.403, 163.8583>, <132.05, 380.9703, 166.7742>, 0.4862 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <132.05, 380.9703, 166.7742>, <133.6976, 383.0399, 166.7008>, 0.1715 }
			cylinder { <133.6976, 383.0399, 166.7008>, <135.7888, 384.5392, 166.0826>, 0.1715 }
			cylinder { <135.7888, 384.5392, 166.0826>, <138.0789, 385.293, 164.9918>, 0.1715 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <138.0789, 385.293, 164.9918>, <139.0287, 385.5952, 164.4999>, 0.1715 }
				cylinder { <139.0287, 385.5952, 164.4999>, <139.9653, 385.8828, 163.975>, 0.1715 }
				cylinder { <139.9653, 385.8828, 163.975>, <140.8875, 386.1552, 163.4176>, 0.1715 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <140.8875, 386.1552, 163.4176>, <140.9557, 386.1664, 163.3955>, 0.004706 }
				cylinder { <140.9557, 386.1664, 163.3955>, <141.028, 386.1702, 163.3892>, 0.004706 }
				cylinder { <141.028, 386.1702, 163.3892>, <141.0999, 386.1665, 163.399>, 0.004706 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <141.0999, 386.1665, 163.399>, <150.8063, 385.8228, 164.0901>, <150.829, 385.0945, 164.4698> }
				triangle { <150.8063, 385.8228, 164.0901>, <153.1658, 383.6896, 161.5047>, <150.829, 385.0945, 164.4698> }
				triangle { <150.8063, 385.8228, 164.0901>, <152.7967, 384.7123, 161.6456>, <153.1658, 383.6896, 161.5047> }
				triangle { <153.1658, 383.6896, 161.5047>, <152.6295, 383.3831, 162.6184>, <150.829, 385.0945, 164.4698> }
				triangle { <150.829, 385.0945, 164.4698>, <146.9768, 384.9204, 163.8235>, <141.0999, 386.1665, 163.399> }
				triangle { <141.0999, 386.1665, 163.399>, <147.1181, 386.1295, 163.0121>, <150.8063, 385.8228, 164.0901> }
				triangle { <147.1181, 386.1295, 163.0121>, <150.8261, 386.0565, 162.7373>, <150.8063, 385.8228, 164.0901> }
				triangle { <150.8261, 386.0565, 162.7373>, <152.7967, 384.7123, 161.6456>, <150.8063, 385.8228, 164.0901> }
				triangle { <150.829, 385.0945, 164.4698>, <152.6295, 383.3831, 162.6184>, <150.9126, 383.911, 163.7554> }
				triangle { <150.9126, 383.911, 163.7554>, <146.9768, 384.9204, 163.8235>, <150.829, 385.0945, 164.4698> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <140.8875, 386.1552, 163.4176>, <140.9477, 386.173, 163.3811>, 0.004706 }
				cylinder { <140.9477, 386.173, 163.3811>, <141.008, 386.1908, 163.3447>, 0.004706 }
				cylinder { <141.008, 386.1908, 163.3447>, <141.0682, 386.2086, 163.3083>, 0.004706 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <141.0682, 386.2086, 163.3083>, <148.7787, 388.6944, 157.9065>, <149.2353, 388.047, 158.1246> }
				triangle { <148.7787, 388.6944, 157.9065>, <149.5713, 387.05, 154.2364>, <149.2353, 388.047, 158.1246> }
				triangle { <148.7787, 388.6944, 157.9065>, <149.0893, 387.9359, 154.6662>, <149.5713, 387.05, 154.2364> }
				triangle { <149.5713, 387.05, 154.2364>, <149.9379, 386.7255, 155.412>, <149.2353, 388.047, 158.1246> }
				triangle { <149.2353, 388.047, 158.1246>, <146.0388, 386.7247, 159.9469>, <141.0682, 386.2086, 163.3083> }
				triangle { <141.0682, 386.2086, 163.3083>, <145.3034, 387.8305, 159.3331>, <148.7787, 388.6944, 157.9065> }
				triangle { <145.3034, 387.8305, 159.3331>, <147.9052, 388.778, 156.8505>, <148.7787, 388.6944, 157.9065> }
				triangle { <147.9052, 388.778, 156.8505>, <149.0893, 387.9359, 154.6662>, <148.7787, 388.6944, 157.9065> }
				triangle { <149.2353, 388.047, 158.1246>, <149.9379, 386.7255, 155.412>, <149.2039, 386.8658, 157.4022> }
				triangle { <149.2039, 386.8658, 157.4022>, <146.0388, 386.7247, 159.9469>, <149.2353, 388.047, 158.1246> }
				material { txgilia_leaf }}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <132.05, 380.9703, 166.7742>, <132.6128, 382.7899, 167.1058>, 0.2192 }
			cylinder { <132.6128, 382.7899, 167.1058>, <132.994, 384.6599, 167.415>, 0.2192 }
			cylinder { <132.994, 384.6599, 167.415>, <133.19, 386.5622, 167.6988>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <133.19, 386.5622, 167.6988>, <133.1988, 388.4785, 167.9547>, 0.2192 }
			cylinder { <133.1988, 388.4785, 167.9547>, <133.0205, 390.3904, 168.18>, 0.2192 }
			cylinder { <133.0205, 390.3904, 168.18>, <132.6566, 392.2794, 168.3726>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <132.6566, 392.2794, 168.3726>, <132.4108, 394.1664, 168.7139>, 0.2192 }
			cylinder { <132.4108, 394.1664, 168.7139>, <132.2852, 396.0333, 169.2004>, 0.2192 }
			cylinder { <132.2852, 396.0333, 169.2004>, <132.2813, 397.8621, 169.8275>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <132.2813, 397.8621, 169.8275>, <132.5032, 400.4968, 171.0188>, 0.2192 }
				cylinder { <132.5032, 400.4968, 171.0188>, <132.9495, 402.9833, 172.4428>, 0.2192 }
				cylinder { <132.9495, 402.9833, 172.4428>, <133.6135, 405.2843, 174.0782>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <133.6135, 405.2843, 174.0782>, <137.3333, 414.3923, 179.7982>, <136.2491, 415.1233, 178.9769> }
					triangle { <133.6135, 405.2843, 174.0782>, <135.9537, 409.7485, 177.8019>, <137.3333, 414.3923, 179.7982> }
					triangle { <136.2491, 415.1233, 178.9769>, <134.0772, 410.9913, 177.5145>, <133.6135, 405.2843, 174.0782> }
					triangle { <135.9537, 409.7485, 177.8019>, <138.8053, 414.5385, 178.9949>, <137.3333, 414.3923, 179.7982> }
					triangle { <138.8053, 414.5385, 178.9949>, <139.8473, 416.4412, 177.2931>, <137.3333, 414.3923, 179.7982> }
					triangle { <136.2491, 415.1233, 178.9769>, <135.9048, 416.7208, 178.0344>, <134.7333, 415.5374, 179.2428> }
					triangle { <134.7333, 415.5374, 179.2428>, <134.0772, 410.9913, 177.5145>, <136.2491, 415.1233, 178.9769> }
					triangle { <139.8473, 416.4412, 177.2931>, <139.3965, 416.6387, 177.6644>, <137.3296, 415.9972, 178.707> }
					triangle { <139.3965, 416.6387, 177.6644>, <138.9879, 417.5524, 175.1462>, <136.6326, 417.6087, 177.4219> }
					triangle { <137.3296, 415.9972, 178.707>, <136.6326, 417.6087, 177.4219>, <135.9048, 416.7208, 178.0344> }
					triangle { <137.3296, 415.9972, 178.707>, <139.3965, 416.6387, 177.6644>, <136.6326, 417.6087, 177.4219> }
					triangle { <137.3333, 414.3923, 179.7982>, <139.8473, 416.4412, 177.2931>, <137.3296, 415.9972, 178.707> }
					triangle { <136.2491, 415.1233, 178.9769>, <137.3296, 415.9972, 178.707>, <135.9048, 416.7208, 178.0344> }
					triangle { <137.3333, 414.3923, 179.7982>, <137.3296, 415.9972, 178.707>, <136.2491, 415.1233, 178.9769> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <133.6135, 405.2843, 174.0782>, <135.9893, 415.0452, 179.4254>, <134.6184, 414.8009, 180.0926> }
					triangle { <133.6135, 405.2843, 174.0782>, <135.7335, 410.4923, 176.8448>, <135.9893, 415.0452, 179.4254> }
					triangle { <134.6184, 414.8009, 180.0926>, <134.3248, 410.1545, 178.5913>, <133.6135, 405.2843, 174.0782> }
					triangle { <135.7335, 410.4923, 176.8448>, <135.7675, 416.0539, 178.0961>, <135.9893, 415.0452, 179.4254> }
					triangle { <135.7675, 416.0539, 178.0961>, <133.9174, 418.0082, 177.4962>, <135.9893, 415.0452, 179.4254> }
					triangle { <134.6184, 414.8009, 180.0926>, <133.0481, 415.6805, 180.6581>, <134.1421, 414.133, 181.4589> }
					triangle { <134.1421, 414.133, 181.4589>, <134.3248, 410.1545, 178.5913>, <134.6184, 414.8009, 180.0926> }
					triangle { <133.9174, 418.0082, 177.4962>, <133.9913, 417.8912, 178.097>, <134.41, 416.1418, 179.6891> }
					triangle { <133.9913, 417.8912, 178.097>, <131.3527, 418.077, 177.5084>, <132.4223, 416.7682, 180.3141> }
					triangle { <134.41, 416.1418, 179.6891>, <132.4223, 416.7682, 180.3141>, <133.0481, 415.6805, 180.6581> }
					triangle { <134.41, 416.1418, 179.6891>, <133.9913, 417.8912, 178.097>, <132.4223, 416.7682, 180.3141> }
					triangle { <135.9893, 415.0452, 179.4254>, <133.9174, 418.0082, 177.4962>, <134.41, 416.1418, 179.6891> }
					triangle { <134.6184, 414.8009, 180.0926>, <134.41, 416.1418, 179.6891>, <133.0481, 415.6805, 180.6581> }
					triangle { <135.9893, 415.0452, 179.4254>, <134.41, 416.1418, 179.6891>, <134.6184, 414.8009, 180.0926> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <133.6135, 405.2843, 174.0782>, <134.9372, 414.6114, 180.4629>, <135.1201, 413.584, 181.6011> }
					triangle { <133.6135, 405.2843, 174.0782>, <134.5451, 410.8158, 176.8722>, <134.9372, 414.6114, 180.4629> }
					triangle { <135.1201, 413.584, 181.6011>, <135.6618, 409.7906, 178.5605>, <133.6135, 405.2843, 174.0782> }
					triangle { <134.5451, 410.8158, 176.8722>, <133.3261, 415.0981, 180.4323>, <134.9372, 414.6114, 180.4629> }
					triangle { <133.3261, 415.0981, 180.4323>, <131.3713, 415.2803, 182.3682>, <134.9372, 414.6114, 180.4629> }
					triangle { <135.1201, 413.584, 181.6011>, <134.6859, 413.2541, 183.4071>, <136.3783, 412.894, 182.2941> }
					triangle { <136.3783, 412.894, 182.2941>, <135.6618, 409.7906, 178.5605>, <135.1201, 413.584, 181.6011> }
					triangle { <131.3713, 415.2803, 182.3682>, <131.951, 415.2957, 182.5773>, <134.1567, 414.4102, 182.2283> }
					triangle { <131.951, 415.2957, 182.5773>, <130.4565, 413.6397, 184.1157>, <133.7306, 413.6212, 184.2107> }
					triangle { <134.1567, 414.4102, 182.2283>, <133.7306, 413.6212, 184.2107>, <134.6859, 413.2541, 183.4071> }
					triangle { <134.1567, 414.4102, 182.2283>, <131.951, 415.2957, 182.5773>, <133.7306, 413.6212, 184.2107> }
					triangle { <134.9372, 414.6114, 180.4629>, <131.3713, 415.2803, 182.3682>, <134.1567, 414.4102, 182.2283> }
					triangle { <135.1201, 413.584, 181.6011>, <134.1567, 414.4102, 182.2283>, <134.6859, 413.2541, 183.4071> }
					triangle { <134.9372, 414.6114, 180.4629>, <134.1567, 414.4102, 182.2283>, <135.1201, 413.584, 181.6011> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <133.6135, 405.2843, 174.0782>, <135.6212, 413.6864, 181.4867>, <137.0655, 413.143, 181.4317> }
					triangle { <133.6135, 405.2843, 174.0782>, <134.0197, 410.275, 177.8465>, <135.6212, 413.6864, 181.4867> }
					triangle { <137.0655, 413.143, 181.4317>, <136.2529, 410.399, 177.4644>, <133.6135, 405.2843, 174.0782> }
					triangle { <134.0197, 410.275, 177.8465>, <134.8322, 412.983, 182.7967>, <135.6212, 413.6864, 181.4867> }
					triangle { <134.8322, 412.983, 182.7967>, <135.7038, 412.002, 185.2216>, <135.6212, 413.6864, 181.4867> }
					triangle { <137.0655, 413.143, 181.4317>, <138.5699, 412.7722, 182.508>, <138.3725, 413.5212, 180.6019> }
					triangle { <138.3725, 413.5212, 180.6019>, <136.2529, 410.399, 177.4644>, <137.0655, 413.143, 181.4317> }
					triangle { <135.7038, 412.002, 185.2216>, <136.0763, 412.4149, 184.9555>, <136.9174, 413.1794, 182.8392> }
					triangle { <136.0763, 412.4149, 184.9555>, <137.5293, 410.3312, 185.8988>, <138.7617, 412.4874, 183.7631> }
					triangle { <136.9174, 413.1794, 182.8392>, <138.7617, 412.4874, 183.7631>, <138.5699, 412.7722, 182.508> }
					triangle { <136.9174, 413.1794, 182.8392>, <136.0763, 412.4149, 184.9555>, <138.7617, 412.4874, 183.7631> }
					triangle { <135.6212, 413.6864, 181.4867>, <135.7038, 412.002, 185.2216>, <136.9174, 413.1794, 182.8392> }
					triangle { <137.0655, 413.143, 181.4317>, <136.9174, 413.1794, 182.8392>, <138.5699, 412.7722, 182.508> }
					triangle { <135.6212, 413.6864, 181.4867>, <136.9174, 413.1794, 182.8392>, <137.0655, 413.143, 181.4317> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <133.6135, 405.2843, 174.0782>, <137.1244, 413.549, 181.0697>, <137.7738, 414.1086, 179.7854> }
					triangle { <133.6135, 405.2843, 174.0782>, <134.9034, 409.6054, 178.4298>, <137.1244, 413.549, 181.0697> }
					triangle { <137.7738, 414.1086, 179.7854>, <135.2588, 411.1523, 176.8082>, <133.6135, 405.2843, 174.0782> }
					triangle { <134.9034, 409.6054, 178.4298>, <138.2696, 412.6319, 181.8949>, <137.1244, 413.549, 181.0697> }
					triangle { <138.2696, 412.6319, 181.8949>, <141.0213, 412.7303, 182.0377>, <137.1244, 413.549, 181.0697> }
					triangle { <137.7738, 414.1086, 179.7854>, <139.3346, 414.9471, 179.1373>, <137.3404, 415.1795, 178.6877> }
					triangle { <137.3404, 415.1795, 178.6877>, <135.2588, 411.1523, 176.8082>, <137.7738, 414.1086, 179.7854> }
					triangle { <141.0213, 412.7303, 182.0377>, <140.7473, 413.2575, 181.8733>, <138.908, 414.175, 180.63> }
					triangle { <140.7473, 413.2575, 181.8733>, <142.8816, 412.7859, 180.2716>, <140.5824, 414.989, 179.504> }
					triangle { <138.908, 414.175, 180.63>, <140.5824, 414.989, 179.504>, <139.3346, 414.9471, 179.1373> }
					triangle { <138.908, 414.175, 180.63>, <140.7473, 413.2575, 181.8733>, <140.5824, 414.989, 179.504> }
					triangle { <137.1244, 413.549, 181.0697>, <141.0213, 412.7303, 182.0377>, <138.908, 414.175, 180.63> }
					triangle { <137.7738, 414.1086, 179.7854>, <138.908, 414.175, 180.63>, <139.3346, 414.9471, 179.1373> }
					triangle { <137.1244, 413.549, 181.0697>, <138.908, 414.175, 180.63>, <137.7738, 414.1086, 179.7854> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <132.2813, 397.8621, 169.8275>, <132.2849, 399.7435, 170.2724>, 0.2192 }
			cylinder { <132.2849, 399.7435, 170.2724>, <132.296, 401.6595, 170.531>, 0.2192 }
			cylinder { <132.296, 401.6595, 170.531>, <132.3145, 403.5914, 170.6007>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <132.3145, 403.5914, 170.6007>, <132.3559, 406.4803, 170.3499>, 0.2192 }
				cylinder { <132.3559, 406.4803, 170.3499>, <132.41, 409.3165, 169.7476>, 0.2192 }
				cylinder { <132.41, 409.3165, 169.7476>, <132.4763, 412.0575, 168.8028>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <132.4763, 412.0575, 168.8028>, <131.45, 422.674, 164.8542>, <131.5774, 423.0463, 166.3464> }
					triangle { <132.4763, 412.0575, 168.8028>, <132.1759, 417.5919, 165.8866>, <131.45, 422.674, 164.8542> }
					triangle { <131.5774, 423.0463, 166.3464>, <133.1231, 418.6044, 167.681>, <132.4763, 412.0575, 168.8028> }
					triangle { <132.1759, 417.5919, 165.8866>, <129.8168, 422.5785, 164.4624>, <131.45, 422.674, 164.8542> }
					triangle { <129.8168, 422.5785, 164.4624>, <127.5617, 423.81, 165.4579>, <131.45, 422.674, 164.8542> }
					triangle { <131.5774, 423.0463, 166.3464>, <130.8974, 424.2116, 167.6634>, <132.7833, 423.4818, 167.2912> }
					triangle { <132.7833, 423.4818, 167.2912>, <133.1231, 418.6044, 167.681>, <131.5774, 423.0463, 166.3464> }
					triangle { <127.5617, 423.81, 165.4579>, <128.0908, 424.1096, 165.5577>, <130.4213, 423.8051, 166.0476> }
					triangle { <128.0908, 424.1096, 165.5577>, <126.5988, 424.0907, 167.8177>, <129.7817, 424.8557, 167.8408> }
					triangle { <130.4213, 423.8051, 166.0476>, <129.7817, 424.8557, 167.8408>, <130.8974, 424.2116, 167.6634> }
					triangle { <130.4213, 423.8051, 166.0476>, <128.0908, 424.1096, 165.5577>, <129.7817, 424.8557, 167.8408> }
					triangle { <131.45, 422.674, 164.8542>, <127.5617, 423.81, 165.4579>, <130.4213, 423.8051, 166.0476> }
					triangle { <131.5774, 423.0463, 166.3464>, <130.4213, 423.8051, 166.0476>, <130.8974, 424.2116, 167.6634> }
					triangle { <131.45, 422.674, 164.8542>, <130.4213, 423.8051, 166.0476>, <131.5774, 423.0463, 166.3464> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <132.4763, 412.0575, 168.8028>, <132.0719, 423.1193, 166.1897>, <133.5641, 423.0791, 166.5809> }
					triangle { <132.4763, 412.0575, 168.8028>, <131.5737, 417.9548, 166.8973>, <132.0719, 423.1193, 166.1897> }
					triangle { <133.5641, 423.0791, 166.5809>, <133.8006, 418.1961, 166.5439>, <132.4763, 412.0575, 168.8028> }
					triangle { <131.5737, 417.9548, 166.8973>, <131.1783, 423.6031, 167.5305>, <132.0719, 423.1193, 166.1897> }
					triangle { <131.1783, 423.6031, 167.5305>, <131.7577, 425.1766, 169.7171>, <132.0719, 423.1193, 166.1897> }
					triangle { <133.5641, 423.0791, 166.5809>, <134.9035, 424.0525, 167.4828>, <134.9271, 422.9073, 165.7751> }
					triangle { <134.9271, 422.9073, 165.7751>, <133.8006, 418.1961, 166.5439>, <133.5641, 423.0791, 166.5809> }
					triangle { <131.7577, 425.1766, 169.7171>, <132.1101, 425.2752, 169.2213>, <133.1804, 424.1925, 167.365> }
					triangle { <132.1101, 425.2752, 169.2213>, <133.6521, 425.1705, 171.4451>, <134.9203, 424.9366, 168.4362> }
					triangle { <133.1804, 424.1925, 167.365>, <134.9203, 424.9366, 168.4362>, <134.9035, 424.0525, 167.4828> }
					triangle { <133.1804, 424.1925, 167.365>, <132.1101, 425.2752, 169.2213>, <134.9203, 424.9366, 168.4362> }
					triangle { <132.0719, 423.1193, 166.1897>, <131.7577, 425.1766, 169.7171>, <133.1804, 424.1925, 167.365> }
					triangle { <133.5641, 423.0791, 166.5809>, <133.1804, 424.1925, 167.365>, <134.9035, 424.0525, 167.4828> }
					triangle { <132.0719, 423.1193, 166.1897>, <133.1804, 424.1925, 167.365>, <133.5641, 423.0791, 166.5809> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <132.4763, 412.0575, 168.8028>, <133.6033, 423.0376, 166.0602>, <134.4079, 422.4697, 164.8722> }
					triangle { <132.4763, 412.0575, 168.8028>, <132.4041, 418.233, 167.7627>, <133.6033, 423.0376, 166.0602> }
					triangle { <134.4079, 422.4697, 164.8722>, <132.8664, 417.8831, 165.5704>, <132.4763, 412.0575, 168.8028> }
					triangle { <132.4041, 418.233, 167.7627>, <134.6759, 423.4367, 167.2932>, <133.6033, 423.0376, 166.0602> }
					triangle { <134.6759, 423.4367, 167.2932>, <137.3192, 424.2149, 167.317>, <133.6033, 423.0376, 166.0602> }
					triangle { <134.4079, 422.4697, 164.8722>, <135.9489, 422.7672, 163.8273>, <134.0612, 422.0969, 163.3631> }
					triangle { <134.0612, 422.0969, 163.3631>, <132.8664, 417.8831, 165.5704>, <134.4079, 422.4697, 164.8722> }
					triangle { <137.3192, 424.2149, 167.317>, <137.0194, 424.318, 166.7887>, <135.3481, 423.4319, 165.3104> }
					triangle { <137.0194, 424.318, 166.7887>, <139.4541, 423.2486, 166.2763>, <137.0916, 423.3596, 164.013> }
					triangle { <135.3481, 423.4319, 165.3104>, <137.0916, 423.3596, 164.013>, <135.9489, 422.7672, 163.8273> }
					triangle { <135.3481, 423.4319, 165.3104>, <137.0194, 424.318, 166.7887>, <137.0916, 423.3596, 164.013> }
					triangle { <133.6033, 423.0376, 166.0602>, <137.3192, 424.2149, 167.317>, <135.3481, 423.4319, 165.3104> }
					triangle { <134.4079, 422.4697, 164.8722>, <135.3481, 423.4319, 165.3104>, <135.9489, 422.7672, 163.8273> }
					triangle { <133.6033, 423.0376, 166.0602>, <135.3481, 423.4319, 165.3104>, <134.4079, 422.4697, 164.8722> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <132.4763, 412.0575, 168.8028>, <133.9422, 422.5411, 164.6434>, <132.9506, 422.0546, 163.5657> }
					triangle { <132.4763, 412.0575, 168.8028>, <133.5273, 418.0446, 167.2949>, <133.9422, 422.5411, 164.6434> }
					triangle { <132.9506, 422.0546, 163.5657>, <131.6028, 418.0951, 166.0967>, <132.4763, 412.0575, 168.8028> }
					triangle { <133.5273, 418.0446, 167.2949>, <135.5087, 422.3077, 164.0762>, <133.9422, 422.5411, 164.6434> }
					triangle { <135.5087, 422.3077, 164.0762>, <136.6122, 422.2449, 161.5521>, <133.9422, 422.5411, 164.6434> }
					triangle { <132.9506, 422.0546, 163.5657>, <132.5985, 422.12, 161.7146>, <131.3742, 422.1629, 163.366> }
					triangle { <131.3742, 422.1629, 163.366>, <131.6028, 418.0951, 166.0967>, <132.9506, 422.0546, 163.5657> }
					triangle { <136.6122, 422.2449, 161.5521>, <136.0801, 422.5519, 161.5989>, <133.9488, 422.5674, 162.7041> }
					triangle { <136.0801, 422.5519, 161.5989>, <136.0408, 420.9632, 159.4061>, <133.3151, 422.2892, 160.6427> }
					triangle { <133.9488, 422.5674, 162.7041>, <133.3151, 422.2892, 160.6427>, <132.5985, 422.12, 161.7146> }
					triangle { <133.9488, 422.5674, 162.7041>, <136.0801, 422.5519, 161.5989>, <133.3151, 422.2892, 160.6427> }
					triangle { <133.9422, 422.5411, 164.6434>, <136.6122, 422.2449, 161.5521>, <133.9488, 422.5674, 162.7041> }
					triangle { <132.9506, 422.0546, 163.5657>, <133.9488, 422.5674, 162.7041>, <132.5985, 422.12, 161.7146> }
					triangle { <133.9422, 422.5411, 164.6434>, <133.9488, 422.5674, 162.7041>, <132.9506, 422.0546, 163.5657> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <132.4763, 412.0575, 168.8028>, <132.5913, 422.313, 163.8868>, <131.1748, 422.4163, 164.4905> }
					triangle { <132.4763, 412.0575, 168.8028>, <133.3842, 417.6424, 166.1179>, <132.5913, 422.313, 163.8868> }
					triangle { <131.1748, 422.4163, 164.4905>, <131.7638, 418.5476, 167.4208>, <132.4763, 412.0575, 168.8028> }
					triangle { <133.3842, 417.6424, 166.1179>, <132.4602, 421.7693, 162.3002>, <132.5913, 422.313, 163.8868> }
					triangle { <132.4602, 421.7693, 162.3002>, <130.4908, 421.9909, 160.3857>, <132.5913, 422.313, 163.8868> }
					triangle { <131.1748, 422.4163, 164.4905>, <129.4294, 423.0262, 164.1212>, <130.5725, 423.0317, 165.8304> }
					triangle { <130.5725, 423.0317, 165.8304>, <131.7638, 418.5476, 167.4208>, <131.1748, 422.4163, 164.4905> }
					triangle { <130.4908, 421.9909, 160.3857>, <130.4786, 422.4212, 160.8266>, <130.8579, 422.8015, 163.1665> }
					triangle { <130.4786, 422.4212, 160.8266>, <127.9758, 421.4915, 160.3732>, <128.7292, 423.2278, 163.0441> }
					triangle { <130.8579, 422.8015, 163.1665>, <128.7292, 423.2278, 163.0441>, <129.4294, 423.0262, 164.1212> }
					triangle { <130.8579, 422.8015, 163.1665>, <130.4786, 422.4212, 160.8266>, <128.7292, 423.2278, 163.0441> }
					triangle { <132.5913, 422.313, 163.8868>, <130.4908, 421.9909, 160.3857>, <130.8579, 422.8015, 163.1665> }
					triangle { <131.1748, 422.4163, 164.4905>, <130.8579, 422.8015, 163.1665>, <129.4294, 423.0262, 164.1212> }
					triangle { <132.5913, 422.313, 163.8868>, <130.8579, 422.8015, 163.1665>, <131.1748, 422.4163, 164.4905> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <132.3145, 403.5914, 170.6007>, <132.2004, 405.5105, 170.8054>, 0.2192 }
			cylinder { <132.2004, 405.5105, 170.8054>, <131.9547, 407.3982, 171.1431>, 0.2192 }
			cylinder { <131.9547, 407.3982, 171.1431>, <131.5798, 409.2363, 171.6106>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <131.5798, 409.2363, 171.6106>, <130.7829, 411.8633, 172.5454>, 0.2192 }
				cylinder { <130.7829, 411.8633, 172.5454>, <129.7636, 414.3205, 173.6999>, 0.2192 }
				cylinder { <129.7636, 414.3205, 173.6999>, <128.5372, 416.5712, 175.0565>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <128.5372, 416.5712, 175.0565>, <124.4366, 425.5321, 180.7348>, <125.3096, 426.3291, 179.7427> }
					triangle { <128.5372, 416.5712, 175.0565>, <125.6423, 420.9962, 178.4125>, <124.4366, 425.5321, 180.7348> }
					triangle { <125.3096, 426.3291, 179.7427>, <126.0307, 422.5135, 176.7726>, <128.5372, 416.5712, 175.0565> }
					triangle { <125.6423, 420.9962, 178.4125>, <125.3169, 425.2865, 182.1471>, <124.4366, 425.5321, 180.7348> }
					triangle { <125.3169, 425.2865, 182.1471>, <127.3307, 426.7016, 183.3862>, <124.4366, 425.5321, 180.7348> }
					triangle { <125.3096, 426.3291, 179.7427>, <126.4663, 427.8131, 179.6219>, <125.0426, 427.0517, 178.3487> }
					triangle { <125.0426, 427.0517, 178.3487>, <126.0307, 422.5135, 176.7726>, <125.3096, 426.3291, 179.7427> }
					triangle { <127.3307, 426.7016, 183.3862>, <126.9742, 427.0299, 183.0057>, <125.7563, 426.9388, 180.9388> }
					triangle { <126.9742, 427.0299, 183.0057>, <129.5795, 427.6397, 182.5876>, <127.2375, 428.4539, 180.4501> }
					triangle { <125.7563, 426.9388, 180.9388>, <127.2375, 428.4539, 180.4501>, <126.4663, 427.8131, 179.6219> }
					triangle { <125.7563, 426.9388, 180.9388>, <126.9742, 427.0299, 183.0057>, <127.2375, 428.4539, 180.4501> }
					triangle { <124.4366, 425.5321, 180.7348>, <127.3307, 426.7016, 183.3862>, <125.7563, 426.9388, 180.9388> }
					triangle { <125.3096, 426.3291, 179.7427>, <125.7563, 426.9388, 180.9388>, <126.4663, 427.8131, 179.6219> }
					triangle { <124.4366, 425.5321, 180.7348>, <125.7563, 426.9388, 180.9388>, <125.3096, 426.3291, 179.7427> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <128.5372, 416.5712, 175.0565>, <124.8437, 426.3648, 179.5061>, <124.0873, 426.4771, 178.1657> }
					triangle { <128.5372, 416.5712, 175.0565>, <126.6897, 421.6254, 178.2605>, <124.8437, 426.3648, 179.5061> }
					triangle { <124.0873, 426.4771, 178.1657>, <124.8524, 421.8057, 176.9435>, <128.5372, 416.5712, 175.0565> }
					triangle { <126.6897, 421.6254, 178.2605>, <126.2983, 427.1993, 179.3731>, <124.8437, 426.3648, 179.5061> }
					triangle { <126.2983, 427.1993, 179.3731>, <127.104, 429.3591, 177.8634>, <124.8437, 426.3648, 179.5061> }
					triangle { <124.0873, 426.4771, 178.1657>, <123.5926, 427.7043, 176.8225>, <122.6166, 426.1091, 177.6773> }
					triangle { <122.6166, 426.1091, 177.6773>, <124.8524, 421.8057, 176.9435>, <124.0873, 426.4771, 178.1657> }
					triangle { <127.104, 429.3591, 177.8634>, <126.4967, 429.3162, 177.9579>, <124.6792, 427.7621, 178.171> }
					triangle { <126.4967, 429.3162, 177.9579>, <126.9885, 429.9062, 175.361>, <124.0689, 428.8296, 176.3776> }
					triangle { <124.6792, 427.7621, 178.171>, <124.0689, 428.8296, 176.3776>, <123.5926, 427.7043, 176.8225> }
					triangle { <124.6792, 427.7621, 178.171>, <126.4967, 429.3162, 177.9579>, <124.0689, 428.8296, 176.3776> }
					triangle { <124.8437, 426.3648, 179.5061>, <127.104, 429.3591, 177.8634>, <124.6792, 427.7621, 178.171> }
					triangle { <124.0873, 426.4771, 178.1657>, <124.6792, 427.7621, 178.171>, <123.5926, 427.7043, 176.8225> }
					triangle { <124.8437, 426.3648, 179.5061>, <124.6792, 427.7621, 178.171>, <124.0873, 426.4771, 178.1657> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <128.5372, 416.5712, 175.0565>, <123.7073, 426.2855, 178.4711>, <122.4367, 425.4132, 178.549> }
					triangle { <128.5372, 416.5712, 175.0565>, <126.6588, 422.1653, 177.1544>, <123.7073, 426.2855, 178.4711> }
					triangle { <122.4367, 425.4132, 178.549>, <124.8871, 421.1983, 178.1879>, <128.5372, 416.5712, 175.0565> }
					triangle { <126.6588, 422.1653, 177.1544>, <123.7396, 427.0547, 176.9753>, <123.7073, 426.2855, 178.4711> }
					triangle { <123.7396, 427.0547, 176.9753>, <121.7699, 427.8688, 175.2288>, <123.7073, 426.2855, 178.4711> }
					triangle { <122.4367, 425.4132, 178.549>, <120.5851, 425.4276, 178.1934>, <121.7042, 424.6055, 179.7099> }
					triangle { <121.7042, 424.6055, 179.7099>, <124.8871, 421.1983, 178.1879>, <122.4367, 425.4132, 178.549> }
					triangle { <121.7699, 427.8688, 175.2288>, <121.5916, 427.805, 175.8151>, <121.9, 426.484, 177.7959> }
					triangle { <121.5916, 427.805, 175.8151>, <119.7563, 426.6911, 174.1644>, <119.8052, 426.0757, 177.3792> }
					triangle { <121.9, 426.484, 177.7959>, <119.8052, 426.0757, 177.3792>, <120.5851, 425.4276, 178.1934> }
					triangle { <121.9, 426.484, 177.7959>, <121.5916, 427.805, 175.8151>, <119.8052, 426.0757, 177.3792> }
					triangle { <123.7073, 426.2855, 178.4711>, <121.7699, 427.8688, 175.2288>, <121.9, 426.484, 177.7959> }
					triangle { <122.4367, 425.4132, 178.549>, <121.9, 426.484, 177.7959>, <120.5851, 425.4276, 178.1934> }
					triangle { <123.7073, 426.2855, 178.4711>, <121.9, 426.484, 177.7959>, <122.4367, 425.4132, 178.549> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <128.5372, 416.5712, 175.0565>, <122.5874, 425.4031, 179.0505>, <122.6235, 424.5979, 180.3665> }
					triangle { <128.5372, 416.5712, 175.0565>, <125.5921, 421.8749, 176.6124>, <122.5874, 425.4031, 179.0505> }
					triangle { <122.6235, 424.5979, 180.3665>, <126.0871, 421.525, 178.7976>, <128.5372, 416.5712, 175.0565> }
					triangle { <125.5921, 421.8749, 176.6124>, <121.153, 425.0511, 178.2451>, <122.5874, 425.4031, 179.0505> }
					triangle { <121.153, 425.0511, 178.2451>, <118.6501, 424.2764, 179.0987>, <122.5874, 425.4031, 179.0505> }
					triangle { <122.6235, 424.5979, 180.3665>, <121.5721, 424.1083, 181.853>, <123.5577, 424.6048, 181.6564> }
					triangle { <123.5577, 424.6048, 181.6564>, <126.0871, 421.525, 178.7976>, <122.6235, 424.5979, 180.3665> }
					triangle { <118.6501, 424.2764, 179.0987>, <118.9918, 424.5707, 179.5185>, <121.2335, 424.8588, 180.3283> }
					triangle { <118.9918, 424.5707, 179.5185>, <117.81, 422.4076, 180.6403>, <120.2989, 423.9724, 182.0802> }
					triangle { <121.2335, 424.8588, 180.3283>, <120.2989, 423.9724, 182.0802>, <121.5721, 424.1083, 181.853> }
					triangle { <121.2335, 424.8588, 180.3283>, <118.9918, 424.5707, 179.5185>, <120.2989, 423.9724, 182.0802> }
					triangle { <122.5874, 425.4031, 179.0505>, <118.6501, 424.2764, 179.0987>, <121.2335, 424.8588, 180.3283> }
					triangle { <122.6235, 424.5979, 180.3665>, <121.2335, 424.8588, 180.3283>, <121.5721, 424.1083, 181.853> }
					triangle { <122.5874, 425.4031, 179.0505>, <121.2335, 424.8588, 180.3283>, <122.6235, 424.5979, 180.3665> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <128.5372, 416.5712, 175.0565>, <123.0449, 424.9304, 180.4706>, <124.4259, 425.1725, 181.1154> }
					triangle { <128.5372, 416.5712, 175.0565>, <124.9544, 421.1414, 177.4017>, <123.0449, 424.9304, 180.4706> }
					triangle { <124.4259, 425.1725, 181.1154>, <126.8046, 422.3502, 177.9097>, <128.5372, 416.5712, 175.0565> }
					triangle { <124.9544, 421.1414, 177.4017>, <122.1425, 423.9418, 181.4897>, <123.0449, 424.9304, 180.4706> }
					triangle { <122.1425, 423.9418, 181.4897>, <122.1388, 423.5441, 184.2164>, <123.0449, 424.9304, 180.4706> }
					triangle { <124.4259, 425.1725, 181.1154>, <125.2617, 425.6049, 182.7492>, <125.6521, 426.1395, 180.8025> }
					triangle { <125.6521, 426.1395, 180.8025>, <126.8046, 422.3502, 177.9097>, <124.4259, 425.1725, 181.1154> }
					triangle { <122.1388, 423.5441, 184.2164>, <122.3687, 424.0844, 184.0297>, <123.6528, 425.1441, 182.3> }
					triangle { <122.3687, 424.0844, 184.0297>, <123.9727, 423.0027, 185.9247>, <124.9616, 425.4644, 184.0067> }
					triangle { <123.6528, 425.1441, 182.3>, <124.9616, 425.4644, 184.0067>, <125.2617, 425.6049, 182.7492> }
					triangle { <123.6528, 425.1441, 182.3>, <122.3687, 424.0844, 184.0297>, <124.9616, 425.4644, 184.0067> }
					triangle { <123.0449, 424.9304, 180.4706>, <122.1388, 423.5441, 184.2164>, <123.6528, 425.1441, 182.3> }
					triangle { <124.4259, 425.1725, 181.1154>, <123.6528, 425.1441, 182.3>, <125.2617, 425.6049, 182.7492> }
					triangle { <123.0449, 424.9304, 180.4706>, <123.6528, 425.1441, 182.3>, <124.4259, 425.1725, 181.1154> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <131.5798, 409.2363, 171.6106>, <131.392, 411.1047, 172.0703>, 0.2192 }
			cylinder { <131.392, 411.1047, 172.0703>, <131.3931, 412.9856, 172.5177>, 0.2192 }
			cylinder { <131.3931, 412.9856, 172.5177>, <131.5831, 414.8607, 172.9487>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <131.5831, 414.8607, 172.9487>, <132.2182, 417.6245, 173.5554>, 0.2192 }
				cylinder { <132.2182, 417.6245, 173.5554>, <133.1938, 420.2978, 174.1133>, 0.2192 }
				cylinder { <133.1938, 420.2978, 174.1133>, <134.4953, 422.8406, 174.6139>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <134.4953, 422.8406, 174.6139>, <139.8378, 432.8691, 174.9416>, <138.4581, 433.3828, 175.4014> }
					triangle { <134.4953, 422.8406, 174.6139>, <138.1527, 427.9147, 174.8582>, <139.8378, 432.8691, 174.9416> }
					triangle { <138.4581, 433.3828, 175.4014>, <136.6998, 428.9103, 176.2848>, <134.4953, 422.8406, 174.6139> }
					triangle { <138.1527, 427.9147, 174.8582>, <139.9608, 433.0779, 173.2778>, <139.8378, 432.8691, 174.9416> }
					triangle { <139.9608, 433.0779, 173.2778>, <138.842, 434.873, 171.514>, <139.8378, 432.8691, 174.9416> }
					triangle { <138.4581, 433.3828, 175.4014>, <137.2511, 434.8162, 175.2019>, <137.7839, 433.6614, 176.8163> }
					triangle { <137.7839, 433.6614, 176.8163>, <136.6998, 428.9103, 176.2848>, <138.4581, 433.3828, 175.4014> }
					triangle { <138.842, 434.873, 171.514>, <138.8702, 435.0623, 172.0993>, <138.694, 434.3289, 174.3772> }
					triangle { <138.8702, 435.0623, 172.0993>, <136.438, 435.6357, 171.0589>, <137.0105, 435.6999, 174.2797> }
					triangle { <138.694, 434.3289, 174.3772>, <137.0105, 435.6999, 174.2797>, <137.2511, 434.8162, 175.2019> }
					triangle { <138.694, 434.3289, 174.3772>, <138.8702, 435.0623, 172.0993>, <137.0105, 435.6999, 174.2797> }
					triangle { <139.8378, 432.8691, 174.9416>, <138.842, 434.873, 171.514>, <138.694, 434.3289, 174.3772> }
					triangle { <138.4581, 433.3828, 175.4014>, <138.694, 434.3289, 174.3772>, <137.2511, 434.8162, 175.2019> }
					triangle { <139.8378, 432.8691, 174.9416>, <138.694, 434.3289, 174.3772>, <138.4581, 433.3828, 175.4014> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <134.4953, 422.8406, 174.6139>, <138.6963, 433.3291, 175.8645>, <138.5318, 433.0187, 177.3663> }
					triangle { <134.4953, 422.8406, 174.6139>, <137.1322, 428.5171, 174.5264>, <138.6963, 433.3291, 175.8645> }
					triangle { <138.5318, 433.0187, 177.3663>, <137.8479, 428.2326, 176.6581>, <134.4953, 422.8406, 174.6139> }
					triangle { <137.1322, 428.5171, 174.5264>, <137.3287, 434.1505, 175.3335>, <138.6963, 433.3291, 175.8645> }
					triangle { <137.3287, 434.1505, 175.3335>, <135.5248, 435.8156, 176.5819>, <138.6963, 433.3291, 175.8645> }
					triangle { <138.5318, 433.0187, 177.3663>, <138.0028, 433.7847, 179.0048>, <139.4959, 432.4639, 178.5051> }
					triangle { <139.4959, 432.4639, 178.5051>, <137.8479, 428.2326, 176.6581>, <138.5318, 433.0187, 177.3663> }
					triangle { <135.5248, 435.8156, 176.5819>, <136.0767, 435.7759, 176.8522>, <137.8813, 434.2741, 177.3479> }
					triangle { <136.0767, 435.7759, 176.8522>, <134.121, 435.6138, 178.7165>, <137.2115, 434.753, 179.3592> }
					triangle { <137.8813, 434.2741, 177.3479>, <137.2115, 434.753, 179.3592>, <138.0028, 433.7847, 179.0048> }
					triangle { <137.8813, 434.2741, 177.3479>, <136.0767, 435.7759, 176.8522>, <137.2115, 434.753, 179.3592> }
					triangle { <138.6963, 433.3291, 175.8645>, <135.5248, 435.8156, 176.5819>, <137.8813, 434.2741, 177.3479> }
					triangle { <138.5318, 433.0187, 177.3663>, <137.8813, 434.2741, 177.3479>, <138.0028, 433.7847, 179.0048> }
					triangle { <138.6963, 433.3291, 175.8645>, <137.8813, 434.2741, 177.3479>, <138.5318, 433.0187, 177.3663> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <134.4953, 422.8406, 174.6139>, <139.0395, 432.9073, 177.3034>, <140.2316, 432.0417, 177.7599> }
					triangle { <134.4953, 422.8406, 174.6139>, <136.455, 428.7138, 175.5349>, <139.0395, 432.9073, 177.3034> }
					triangle { <140.2316, 432.0417, 177.7599>, <138.6098, 428.0113, 175.5235>, <134.4953, 422.8406, 174.6139> }
					triangle { <136.455, 428.7138, 175.5349>, <138.0584, 433.2138, 178.6341>, <139.0395, 432.9073, 177.3034> }
					triangle { <138.0584, 433.2138, 178.6341>, <138.5514, 433.4062, 181.3369>, <139.0395, 432.9073, 177.3034> }
					triangle { <140.2316, 432.0417, 177.7599>, <141.5283, 431.8746, 179.117>, <141.595, 431.5722, 177.0854> }
					triangle { <141.595, 431.5722, 177.0854>, <138.6098, 428.0113, 175.5235>, <140.2316, 432.0417, 177.7599> }
					triangle { <138.5514, 433.4062, 181.3369>, <139.0381, 433.5063, 180.9731>, <140.0936, 432.8261, 178.9283> }
					triangle { <139.0381, 433.5063, 180.9731>, <139.7375, 431.8883, 183.0273>, <141.6098, 432.2269, 180.3655> }
					triangle { <140.0936, 432.8261, 178.9283>, <141.6098, 432.2269, 180.3655>, <141.5283, 431.8746, 179.117> }
					triangle { <140.0936, 432.8261, 178.9283>, <139.0381, 433.5063, 180.9731>, <141.6098, 432.2269, 180.3655> }
					triangle { <139.0395, 432.9073, 177.3034>, <138.5514, 433.4062, 181.3369>, <140.0936, 432.8261, 178.9283> }
					triangle { <140.2316, 432.0417, 177.7599>, <140.0936, 432.8261, 178.9283>, <141.5283, 431.8746, 179.117> }
					triangle { <139.0395, 432.9073, 177.3034>, <140.0936, 432.8261, 178.9283>, <140.2316, 432.0417, 177.7599> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <134.4953, 422.8406, 174.6139>, <140.3962, 432.1826, 177.2833>, <141.2244, 431.7928, 176.0419> }
					triangle { <134.4953, 422.8406, 174.6139>, <137.0506, 428.2349, 176.4994>, <140.3962, 432.1826, 177.2833> }
					triangle { <141.2244, 431.7928, 176.0419>, <137.9397, 428.55, 174.4385>, <134.4953, 422.8406, 174.6139> }
					triangle { <137.0506, 428.2349, 176.4994>, <141.1484, 431.5535, 178.6492>, <140.3962, 432.1826, 177.2833> }
					triangle { <141.1484, 431.5535, 178.6492>, <143.7675, 430.9521, 179.2521>, <140.3962, 432.1826, 177.2833> }
					triangle { <141.2244, 431.7928, 176.0419>, <142.9884, 431.7078, 175.3846>, <141.1999, 432.2103, 174.5059> }
					triangle { <141.1999, 432.2103, 174.5059>, <137.9397, 428.55, 174.4385>, <141.2244, 431.7928, 176.0419> }
					triangle { <143.7675, 430.9521, 179.2521>, <143.6896, 431.3688, 178.8055>, <142.2941, 431.9724, 176.9491> }
					triangle { <143.6896, 431.3688, 178.8055>, <145.5781, 429.573, 178.0741>, <144.1681, 431.5892, 175.9172> }
					triangle { <142.2941, 431.9724, 176.9491>, <144.1681, 431.5892, 175.9172>, <142.9884, 431.7078, 175.3846> }
					triangle { <142.2941, 431.9724, 176.9491>, <143.6896, 431.3688, 178.8055>, <144.1681, 431.5892, 175.9172> }
					triangle { <140.3962, 432.1826, 177.2833>, <143.7675, 430.9521, 179.2521>, <142.2941, 431.9724, 176.9491> }
					triangle { <141.2244, 431.7928, 176.0419>, <142.2941, 431.9724, 176.9491>, <142.9884, 431.7078, 175.3846> }
					triangle { <140.3962, 432.1826, 177.2833>, <142.2941, 431.9724, 176.9491>, <141.2244, 431.7928, 176.0419> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <134.4953, 422.8406, 174.6139>, <140.8971, 432.1587, 175.8016>, <140.1117, 432.6342, 174.5622> }
					triangle { <134.4953, 422.8406, 174.6139>, <138.1157, 427.7336, 176.0749>, <140.8971, 432.1587, 175.8016> }
					triangle { <140.1117, 432.6342, 174.5622>, <136.7414, 429.114, 174.9161>, <134.4953, 422.8406, 174.6139> }
					triangle { <138.1157, 427.7336, 176.0749>, <142.3419, 431.4683, 175.2888>, <140.8971, 432.1587, 175.8016> }
					triangle { <142.3419, 431.4683, 175.2888>, <143.9498, 431.8723, 173.0896>, <140.8971, 432.1587, 175.8016> }
					triangle { <140.1117, 432.6342, 174.5622>, <140.3051, 433.5532, 172.9285>, <138.809, 433.5209, 174.3371> }
					triangle { <138.809, 433.5209, 174.3371>, <136.7414, 429.114, 174.9161>, <140.1117, 432.6342, 174.5622> }
					triangle { <143.9498, 431.8723, 173.0896>, <143.5842, 432.345, 173.2384>, <141.4161, 432.9152, 174.0939> }
					triangle { <143.5842, 432.345, 173.2384>, <143.5081, 431.9239, 170.5657>, <141.2827, 433.768, 172.0993> }
					triangle { <141.4161, 432.9152, 174.0939>, <141.2827, 433.768, 172.0993>, <140.3051, 433.5532, 172.9285> }
					triangle { <141.4161, 432.9152, 174.0939>, <143.5842, 432.345, 173.2384>, <141.2827, 433.768, 172.0993> }
					triangle { <140.8971, 432.1587, 175.8016>, <143.9498, 431.8723, 173.0896>, <141.4161, 432.9152, 174.0939> }
					triangle { <140.1117, 432.6342, 174.5622>, <141.4161, 432.9152, 174.0939>, <140.3051, 433.5532, 172.9285> }
					triangle { <140.8971, 432.1587, 175.8016>, <141.4161, 432.9152, 174.0939>, <140.1117, 432.6342, 174.5622> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <132.05, 380.9703, 166.7742>, <132.8934, 382.6406, 167.2608>, 0.2192 }
			cylinder { <132.8934, 382.6406, 167.2608>, <133.833, 384.2133, 167.8784>, 0.2192 }
			cylinder { <133.833, 384.2133, 167.8784>, <134.8598, 385.6732, 168.6213>, 0.2192 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <134.8598, 385.6732, 168.6213>, <136.1212, 386.8409, 169.5063>, 0.2192 }
			cylinder { <136.1212, 386.8409, 169.5063>, <137.4184, 388.0837, 170.2207>, 0.2192 }
			cylinder { <137.4184, 388.0837, 170.2207>, <138.7388, 389.3898, 170.7579>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <138.7388, 389.3898, 170.7579>, <140.7361, 391.4409, 171.2204>, 0.2192 }
				cylinder { <140.7361, 391.4409, 171.2204>, <142.72, 393.5531, 171.3328>, 0.2192 }
				cylinder { <142.72, 393.5531, 171.3328>, <144.6608, 395.6946, 171.0934>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <144.6608, 395.6946, 171.0934>, <150.9652, 405.082, 169.931>, <151.3129, 404.8112, 171.4091> }
					triangle { <144.6608, 395.6946, 171.0934>, <148.1193, 400.7005, 169.6226>, <150.9652, 405.082, 169.931> }
					triangle { <151.3129, 404.8112, 171.4091>, <149.5052, 400.2718, 171.364>, <144.6608, 395.6946, 171.0934> }
					triangle { <148.1193, 400.7005, 169.6226>, <149.6845, 406.1699, 169.8718>, <150.9652, 405.082, 169.931> }
					triangle { <149.6845, 406.1699, 169.8718>, <148.8303, 408.1718, 171.5592>, <150.9652, 405.082, 169.931> }
					triangle { <151.3129, 404.8112, 171.4091>, <151.588, 405.6688, 173.0644>, <152.504, 404.0674, 172.1589> }
					triangle { <152.504, 404.0674, 172.1589>, <149.5052, 400.2718, 171.364>, <151.3129, 404.8112, 171.4091> }
					triangle { <148.8303, 408.1718, 171.5592>, <149.4242, 408.0183, 171.613>, <150.9575, 406.1743, 171.5325> }
					triangle { <149.4242, 408.0183, 171.613>, <148.3079, 408.2638, 174.0665>, <151.1875, 406.7799, 173.6071> }
					triangle { <150.9575, 406.1743, 171.5325>, <151.1875, 406.7799, 173.6071>, <151.588, 405.6688, 173.0644> }
					triangle { <150.9575, 406.1743, 171.5325>, <149.4242, 408.0183, 171.613>, <151.1875, 406.7799, 173.6071> }
					triangle { <150.9652, 405.082, 169.931>, <148.8303, 408.1718, 171.5592>, <150.9575, 406.1743, 171.5325> }
					triangle { <151.3129, 404.8112, 171.4091>, <150.9575, 406.1743, 171.5325>, <151.588, 405.6688, 173.0644> }
					triangle { <150.9652, 405.082, 169.931>, <150.9575, 406.1743, 171.5325>, <151.3129, 404.8112, 171.4091> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <144.6608, 395.6946, 171.0934>, <151.7292, 404.5969, 171.1749>, <152.8144, 403.5023, 171.2319> }
					triangle { <144.6608, 395.6946, 171.0934>, <147.9162, 401.0326, 170.79>, <151.7292, 404.5969, 171.1749> }
					triangle { <152.8144, 403.5023, 171.2319>, <149.7338, 399.8982, 170.0507>, <144.6608, 395.6946, 171.0934> }
					triangle { <147.9162, 401.0326, 170.79>, <151.3908, 405.0991, 172.7435>, <151.7292, 404.5969, 171.1749> }
					triangle { <151.3908, 405.0991, 172.7435>, <152.8783, 405.1826, 175.0598>, <151.7292, 404.5969, 171.1749> }
					triangle { <152.8144, 403.5023, 171.2319>, <154.4635, 403.0687, 172.0343>, <153.7121, 402.7608, 170.1464> }
					triangle { <153.7121, 402.7608, 170.1464>, <149.7338, 399.8982, 170.0507>, <152.8144, 403.5023, 171.2319> }
					triangle { <152.8783, 405.1826, 175.0598>, <153.2048, 405.1799, 174.5377>, <153.2738, 404.2974, 172.3074> }
					triangle { <153.2048, 405.1799, 174.5377>, <154.2897, 403.4502, 176.3146>, <155.0686, 403.3953, 173.1373> }
					triangle { <153.2738, 404.2974, 172.3074>, <155.0686, 403.3953, 173.1373>, <154.4635, 403.0687, 172.0343> }
					triangle { <153.2738, 404.2974, 172.3074>, <153.2048, 405.1799, 174.5377>, <155.0686, 403.3953, 173.1373> }
					triangle { <151.7292, 404.5969, 171.1749>, <152.8783, 405.1826, 175.0598>, <153.2738, 404.2974, 172.3074> }
					triangle { <152.8144, 403.5023, 171.2319>, <153.2738, 404.2974, 172.3074>, <154.4635, 403.0687, 172.0343> }
					triangle { <151.7292, 404.5969, 171.1749>, <153.2738, 404.2974, 172.3074>, <152.8144, 403.5023, 171.2319> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <144.6608, 395.6946, 171.0934>, <152.8144, 403.6066, 170.7189>, <153.031, 403.0545, 169.295> }
					triangle { <144.6608, 395.6946, 171.0934>, <148.7225, 400.4396, 171.506>, <152.8144, 403.6066, 170.7189> }
					triangle { <153.031, 403.0545, 169.295>, <148.8266, 400.5653, 169.2453>, <144.6608, 395.6946, 171.0934> }
					triangle { <148.7225, 400.4396, 171.506>, <153.8828, 402.8338, 171.7621>, <152.8144, 403.6066, 170.7189> }
					triangle { <153.8828, 402.8338, 171.7621>, <156.3696, 401.7015, 171.4171>, <152.8144, 403.6066, 170.7189> }
					triangle { <153.031, 403.0545, 169.295>, <154.3732, 402.6059, 168.0508>, <152.5196, 403.4693, 167.8457> }
					triangle { <152.5196, 403.4693, 167.8457>, <148.8266, 400.5653, 169.2453>, <153.031, 403.0545, 169.295> }
					triangle { <156.3696, 401.7015, 171.4171>, <156.2135, 402.1258, 170.9989>, <154.3739, 403.0074, 169.7355> }
					triangle { <156.2135, 402.1258, 170.9989>, <157.3112, 399.9778, 169.7709>, <155.6195, 402.2446, 168.1262> }
					triangle { <154.3739, 403.0074, 169.7355>, <155.6195, 402.2446, 168.1262>, <154.3732, 402.6059, 168.0508> }
					triangle { <154.3739, 403.0074, 169.7355>, <156.2135, 402.1258, 170.9989>, <155.6195, 402.2446, 168.1262> }
					triangle { <152.8144, 403.6066, 170.7189>, <156.3696, 401.7015, 171.4171>, <154.3739, 403.0074, 169.7355> }
					triangle { <153.031, 403.0545, 169.295>, <154.3739, 403.0074, 169.7355>, <154.3732, 402.6059, 168.0508> }
					triangle { <152.8144, 403.6066, 170.7189>, <154.3739, 403.0074, 169.7355>, <153.031, 403.0545, 169.295> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <144.6608, 395.6946, 171.0934>, <152.7312, 403.4704, 169.1889>, <151.6653, 404.0824, 168.2571> }
					triangle { <144.6608, 395.6946, 171.0934>, <149.4316, 399.7355, 170.7877>, <152.7312, 403.4704, 169.1889> }
					triangle { <151.6653, 404.0824, 168.2571>, <148.0289, 401.3574, 170.0534>, <144.6608, 395.6946, 171.0934> }
					triangle { <149.4316, 399.7355, 170.7877>, <153.7399, 402.4834, 168.2748>, <152.7312, 403.4704, 169.1889> }
					triangle { <153.7399, 402.4834, 168.2748>, <154.5118, 402.5068, 165.6313>, <152.7312, 403.4704, 169.1889> }
					triangle { <151.6653, 404.0824, 168.2571>, <151.4411, 404.9157, 166.5818>, <150.5634, 405.2204, 168.4149> }
					triangle { <150.5634, 405.2204, 168.4149>, <148.0289, 401.3574, 170.0534>, <151.6653, 404.0824, 168.2571> }
					triangle { <154.5118, 402.5068, 165.6313>, <154.3205, 403.0481, 165.8541>, <152.7477, 404.0751, 167.3472> }
					triangle { <154.3205, 403.0481, 165.8541>, <153.2249, 402.613, 163.4175>, <152.0841, 404.9073, 165.4523> }
					triangle { <152.7477, 404.0751, 167.3472>, <152.0841, 404.9073, 165.4523>, <151.4411, 404.9157, 166.5818> }
					triangle { <152.7477, 404.0751, 167.3472>, <154.3205, 403.0481, 165.8541>, <152.0841, 404.9073, 165.4523> }
					triangle { <152.7312, 403.4704, 169.1889>, <154.5118, 402.5068, 165.6313>, <152.7477, 404.0751, 167.3472> }
					triangle { <151.6653, 404.0824, 168.2571>, <152.7477, 404.0751, 167.3472>, <151.4411, 404.9157, 166.5818> }
					triangle { <152.7312, 403.4704, 169.1889>, <152.7477, 404.0751, 167.3472>, <151.6653, 404.0824, 168.2571> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <144.6608, 395.6946, 171.0934>, <151.5711, 404.396, 168.6946>, <150.5874, 405.1844, 169.5834> }
					triangle { <144.6608, 395.6946, 171.0934>, <149.0531, 399.8992, 169.6061>, <151.5711, 404.396, 168.6946> }
					triangle { <150.5874, 405.1844, 169.5834>, <148.4547, 401.1732, 171.3826>, <144.6608, 395.6946, 171.0934> }
					triangle { <149.0531, 399.8992, 169.6061>, <151.106, 404.5763, 167.0889>, <151.5711, 404.396, 168.6946> }
					triangle { <151.106, 404.5763, 167.0889>, <149.7819, 406.566, 165.7204>, <151.5711, 404.396, 168.6946> }
					triangle { <150.5874, 405.1844, 169.5834>, <149.6937, 406.8372, 169.7272>, <150.5536, 405.5956, 171.1208> }
					triangle { <150.5536, 405.5956, 171.1208>, <148.4547, 401.1732, 171.3826>, <150.5874, 405.1844, 169.5834> }
					triangle { <149.7819, 406.566, 165.7204>, <150.0612, 406.7449, 166.2393>, <150.6044, 406.0619, 168.4745> }
					triangle { <150.0612, 406.7449, 166.2393>, <147.5766, 407.8113, 166.1125>, <149.3036, 407.7525, 168.8908> }
					triangle { <150.6044, 406.0619, 168.4745>, <149.3036, 407.7525, 168.8908>, <149.6937, 406.8372, 169.7272> }
					triangle { <150.6044, 406.0619, 168.4745>, <150.0612, 406.7449, 166.2393>, <149.3036, 407.7525, 168.8908> }
					triangle { <151.5711, 404.396, 168.6946>, <149.7819, 406.566, 165.7204>, <150.6044, 406.0619, 168.4745> }
					triangle { <150.5874, 405.1844, 169.5834>, <150.6044, 406.0619, 168.4745>, <149.6937, 406.8372, 169.7272> }
					triangle { <151.5711, 404.396, 168.6946>, <150.6044, 406.0619, 168.4745>, <150.5874, 405.1844, 169.5834> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <134.8598, 385.6732, 168.6213>, <135.6079, 387.3628, 169.1901>, 0.2192 }
			cylinder { <135.6079, 387.3628, 169.1901>, <136.3312, 388.9926, 169.9373>, 0.2192 }
			cylinder { <136.3312, 388.9926, 169.9373>, <137.0227, 390.547, 170.8557>, 0.2192 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <137.0227, 390.547, 170.8557>, <137.9863, 392.7058, 172.5353>, 0.2192 }
				cylinder { <137.9863, 392.7058, 172.5353>, <138.8619, 394.6593, 174.4916>, 0.2192 }
				cylinder { <138.8619, 394.6593, 174.4916>, <139.6362, 396.3781, 176.6952>, 0.2192 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <139.6362, 396.3781, 176.6952>, <143.9445, 402.08, 185.5354>, <144.179, 403.1786, 184.4785> }
					triangle { <139.6362, 396.3781, 176.6952>, <141.5442, 399.0024, 182.0484>, <143.9445, 402.08, 185.5354> }
					triangle { <144.179, 403.1786, 184.4785>, <141.3071, 401.0645, 181.1381>, <139.6362, 396.3781, 176.6952> }
					triangle { <141.5442, 399.0024, 182.0484>, <145.3511, 401.1711, 185.6857>, <143.9445, 402.08, 185.5354> }
					triangle { <145.3511, 401.1711, 185.6857>, <148.018, 401.7465, 185.3097>, <143.9445, 402.08, 185.5354> }
					triangle { <144.179, 403.1786, 184.4785>, <145.4227, 404.4803, 183.922>, <143.3693, 404.4646, 184.0046> }
					triangle { <143.3693, 404.4646, 184.0046>, <141.3071, 401.0645, 181.1381>, <144.179, 403.1786, 184.4785> }
					triangle { <148.018, 401.7465, 185.3097>, <147.658, 402.2326, 185.4251>, <145.4777, 403.1567, 185.0375> }
					triangle { <147.658, 402.2326, 185.4251>, <149.3429, 402.7954, 183.3829>, <146.71, 404.6302, 184.0208> }
					triangle { <145.4777, 403.1567, 185.0375>, <146.71, 404.6302, 184.0208>, <145.4227, 404.4803, 183.922> }
					triangle { <145.4777, 403.1567, 185.0375>, <147.658, 402.2326, 185.4251>, <146.71, 404.6302, 184.0208> }
					triangle { <143.9445, 402.08, 185.5354>, <148.018, 401.7465, 185.3097>, <145.4777, 403.1567, 185.0375> }
					triangle { <144.179, 403.1786, 184.4785>, <145.4777, 403.1567, 185.0375>, <145.4227, 404.4803, 183.922> }
					triangle { <143.9445, 402.08, 185.5354>, <145.4777, 403.1567, 185.0375>, <144.179, 403.1786, 184.4785> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <139.6362, 396.3781, 176.6952>, <143.7301, 403.3465, 184.6891>, <142.4024, 404.0963, 184.4567> }
					triangle { <139.6362, 396.3781, 176.6952>, <142.3756, 399.5636, 181.3355>, <143.7301, 403.3465, 184.6891> }
					triangle { <142.4024, 404.0963, 184.4567>, <140.3717, 400.4332, 181.9401>, <139.6362, 396.3781, 176.6952> }
					triangle { <142.3756, 399.5636, 181.3355>, <144.9206, 404.0559, 183.7371>, <143.7301, 403.3465, 184.6891> }
					triangle { <144.9206, 404.0559, 183.7371>, <145.2848, 406.6051, 182.7603>, <143.7301, 403.3465, 184.6891> }
					triangle { <142.4024, 404.0963, 184.4567>, <141.6633, 405.8238, 184.3127>, <140.9733, 404.0822, 185.1577> }
					triangle { <140.9733, 404.0822, 185.1577>, <140.3717, 400.4332, 181.9401>, <142.4024, 404.0963, 184.4567> }
					triangle { <145.2848, 406.6051, 182.7603>, <144.9272, 406.5636, 183.2599>, <143.2789, 405.2007, 184.3477> }
					triangle { <144.9272, 406.5636, 183.2599>, <143.7922, 408.222, 181.4467>, <142.1118, 406.9952, 183.9719> }
					triangle { <143.2789, 405.2007, 184.3477>, <142.1118, 406.9952, 183.9719>, <141.6633, 405.8238, 184.3127> }
					triangle { <143.2789, 405.2007, 184.3477>, <144.9272, 406.5636, 183.2599>, <142.1118, 406.9952, 183.9719> }
					triangle { <143.7301, 403.3465, 184.6891>, <145.2848, 406.6051, 182.7603>, <143.2789, 405.2007, 184.3477> }
					triangle { <142.4024, 404.0963, 184.4567>, <143.2789, 405.2007, 184.3477>, <141.6633, 405.8238, 184.3127> }
					triangle { <143.7301, 403.3465, 184.6891>, <143.2789, 405.2007, 184.3477>, <142.4024, 404.0963, 184.4567> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <139.6362, 396.3781, 176.6952>, <142.2766, 403.8132, 184.8787>, <141.1582, 403.083, 185.6501> }
					triangle { <139.6362, 396.3781, 176.6952>, <141.8407, 400.5426, 180.816>, <142.2766, 403.8132, 184.8787> }
					triangle { <141.1582, 403.083, 185.6501>, <140.9735, 399.3318, 182.5245>, <139.6362, 396.3781, 176.6952> }
					triangle { <141.8407, 400.5426, 180.816>, <141.6169, 405.1671, 184.1311>, <142.2766, 403.8132, 184.8787> }
					triangle { <141.6169, 405.1671, 184.1311>, <139.4841, 406.8025, 184.7321>, <142.2766, 403.8132, 184.8787> }
					triangle { <141.1582, 403.083, 185.6501>, <139.7055, 403.3747, 186.8145>, <141.1223, 401.8901, 186.7035> }
					triangle { <141.1223, 401.8901, 186.7035>, <140.9735, 399.3318, 182.5245>, <141.1582, 403.083, 185.6501> }
					triangle { <139.4841, 406.8025, 184.7321>, <139.7216, 406.4943, 185.2094>, <140.715, 404.4093, 185.8605> }
					triangle { <139.7216, 406.4943, 185.2094>, <137.019, 406.3603, 185.2763>, <138.9033, 404.3673, 187.0604> }
					triangle { <140.715, 404.4093, 185.8605>, <138.9033, 404.3673, 187.0604>, <139.7055, 403.3747, 186.8145> }
					triangle { <140.715, 404.4093, 185.8605>, <139.7216, 406.4943, 185.2094>, <138.9033, 404.3673, 187.0604> }
					triangle { <142.2766, 403.8132, 184.8787>, <139.4841, 406.8025, 184.7321>, <140.715, 404.4093, 185.8605> }
					triangle { <141.1582, 403.083, 185.6501>, <140.715, 404.4093, 185.8605>, <139.7055, 403.3747, 186.8145> }
					triangle { <142.2766, 403.8132, 184.8787>, <140.715, 404.4093, 185.8605>, <141.1582, 403.083, 185.6501> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <139.6362, 396.3781, 176.6952>, <141.5792, 402.8394, 185.8439>, <142.1543, 401.5296, 186.4207> }
					triangle { <139.6362, 396.3781, 176.6952>, <140.6737, 400.5956, 181.203>, <141.5792, 402.8394, 185.8439> }
					triangle { <142.1543, 401.5296, 186.4207>, <142.2863, 399.2722, 182.0892>, <139.6362, 396.3781, 176.6952> }
					triangle { <140.6737, 400.5956, 181.203>, <139.9747, 402.9794, 186.327>, <141.5792, 402.8394, 185.8439> }
					triangle { <139.9747, 402.9794, 186.327>, <138.5781, 402.0677, 188.5186>, <141.5792, 402.8394, 185.8439> }
					triangle { <142.1543, 401.5296, 186.4207>, <142.2366, 400.4947, 187.9933>, <143.6118, 400.8972, 186.5201> }
					triangle { <143.6118, 400.8972, 186.5201>, <142.2863, 399.2722, 182.0892>, <142.1543, 401.5296, 186.4207> }
					triangle { <138.5781, 402.0677, 188.5186>, <139.1866, 402.1197, 188.5976>, <141.3053, 401.8688, 187.4995> }
					triangle { <139.1866, 402.1197, 188.5976>, <138.3205, 399.7657, 189.615>, <141.4886, 400.3538, 189.0469> }
					triangle { <141.3053, 401.8688, 187.4995>, <141.4886, 400.3538, 189.0469>, <142.2366, 400.4947, 187.9933> }
					triangle { <141.3053, 401.8688, 187.4995>, <139.1866, 402.1197, 188.5976>, <141.4886, 400.3538, 189.0469> }
					triangle { <141.5792, 402.8394, 185.8439>, <138.5781, 402.0677, 188.5186>, <141.3053, 401.8688, 187.4995> }
					triangle { <142.1543, 401.5296, 186.4207>, <141.3053, 401.8688, 187.4995>, <142.2366, 400.4947, 187.9933> }
					triangle { <141.5792, 402.8394, 185.8439>, <141.3053, 401.8688, 187.4995>, <142.1543, 401.5296, 186.4207> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <139.6362, 396.3781, 176.6952>, <142.6255, 401.752, 186.2559>, <144.0494, 401.5896, 185.6856> }
					triangle { <139.6362, 396.3781, 176.6952>, <140.4877, 399.6293, 181.9762>, <142.6255, 401.752, 186.2559> }
					triangle { <144.0494, 401.5896, 185.6856>, <142.4956, 400.3592, 181.2194>, <139.6362, 396.3781, 176.6952> }
					triangle { <140.4877, 399.6293, 181.9762>, <142.3174, 400.4725, 187.3022>, <142.6255, 401.752, 186.2559> }
					triangle { <142.3174, 400.4725, 187.3022>, <143.932, 398.8958, 188.8809>, <142.6255, 401.752, 186.2559> }
					triangle { <144.0494, 401.5896, 185.6856>, <145.8234, 401.1884, 186.1787>, <145.0215, 402.5124, 184.8269> }
					triangle { <145.0215, 402.5124, 184.8269>, <142.4956, 400.3592, 181.2194>, <144.0494, 401.5896, 185.6856> }
					triangle { <143.932, 398.8958, 188.8809>, <144.1656, 399.446, 188.733>, <144.2933, 401.083, 186.9832> }
					triangle { <144.1656, 399.446, 188.733>, <146.0521, 397.5293, 188.4272>, <146.3862, 400.5187, 187.14> }
					triangle { <144.2933, 401.083, 186.9832>, <146.3862, 400.5187, 187.14>, <145.8234, 401.1884, 186.1787> }
					triangle { <144.2933, 401.083, 186.9832>, <144.1656, 399.446, 188.733>, <146.3862, 400.5187, 187.14> }
					triangle { <142.6255, 401.752, 186.2559>, <143.932, 398.8958, 188.8809>, <144.2933, 401.083, 186.9832> }
					triangle { <144.0494, 401.5896, 185.6856>, <144.2933, 401.083, 186.9832>, <145.8234, 401.1884, 186.1787> }
					triangle { <142.6255, 401.752, 186.2559>, <144.2933, 401.083, 186.9832>, <144.0494, 401.5896, 185.6856> }
					material { txgilia_flower }}
				}
			}
		}
	union { // internode
		cylinder { <118.0737, 241.3193, 134.897>, <120.3629, 255.9005, 142.342>, 0.5 }
		cylinder { <120.3629, 255.9005, 142.342>, <121.345, 269.0119, 152.3625>, 0.5 }
		cylinder { <121.345, 269.0119, 152.3625>, <120.9822, 280.1495, 164.5734>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <120.9822, 280.1495, 164.5734>, <119.8177, 283.4431, 171.4516>, 0.4999 }
			cylinder { <119.8177, 283.4431, 171.4516>, <117.7754, 284.5003, 178.8154>, 0.4999 }
			cylinder { <117.7754, 284.5003, 178.8154>, <115.0615, 283.2144, 185.9214>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <115.0615, 283.2144, 185.9214>, <113.8325, 282.6231, 188.8605>, 0.4999 }
				cylinder { <113.8325, 282.6231, 188.8605>, <112.5157, 281.9812, 191.7506>, 0.4999 }
				cylinder { <112.5157, 281.9812, 191.7506>, <111.1129, 281.2895, 194.5882>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <111.1129, 281.2895, 194.5882>, <110.7104, 281.213, 195.0497>, 0.03999 }
				cylinder { <110.7104, 281.213, 195.0497>, <110.2017, 281.1971, 195.3988>, 0.03999 }
				cylinder { <110.2017, 281.1971, 195.3988>, <109.6238, 281.2432, 195.6102>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <109.6238, 281.2432, 195.6102>, <83.1492, 280.5886, 205.8277>, <82.1204, 280.038, 203.736> }
				triangle { <83.1492, 280.5886, 205.8277>, <77.5053, 270.463, 208.7271>, <82.1204, 280.038, 203.736> }
				triangle { <83.1492, 280.5886, 205.8277>, <79.2169, 272.775, 210.1196>, <77.5053, 270.463, 208.7271> }
				triangle { <77.5053, 270.463, 208.7271>, <77.6303, 272.4202, 205.575>, <82.1204, 280.038, 203.736> }
				triangle { <82.1204, 280.038, 203.736>, <92.7056, 278.8875, 199.6685>, <109.6238, 281.2432, 195.6102> }
				triangle { <109.6238, 281.2432, 195.6102>, <94.1096, 279.374, 203.6662>, <83.1492, 280.5886, 205.8277> }
				triangle { <94.1096, 279.374, 203.6662>, <84.5416, 278.0464, 208.588>, <83.1492, 280.5886, 205.8277> }
				triangle { <84.5416, 278.0464, 208.588>, <79.2169, 272.775, 210.1196>, <83.1492, 280.5886, 205.8277> }
				triangle { <82.1204, 280.038, 203.736>, <77.6303, 272.4202, 205.575>, <81.5512, 276.2005, 202.6179> }
				triangle { <81.5512, 276.2005, 202.6179>, <92.7056, 278.8875, 199.6685>, <82.1204, 280.038, 203.736> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <111.1129, 281.2895, 194.5882>, <110.8457, 281.1578, 195.1287>, 0.03999 }
				cylinder { <110.8457, 281.1578, 195.1287>, <110.5786, 281.026, 195.6692>, 0.03999 }
				cylinder { <110.5786, 281.026, 195.6692>, <110.3114, 280.8943, 196.2097>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <110.3114, 280.8943, 196.2097>, <98.931, 272.1908, 220.7141>, <96.8623, 271.465, 219.7496> }
				triangle { <98.931, 272.1908, 220.7141>, <98.7723, 260.7482, 224.1533>, <96.8623, 271.465, 219.7496> }
				triangle { <98.931, 272.1908, 220.7141>, <100.5246, 263.3876, 224.5741>, <98.7723, 260.7482, 224.1533> }
				triangle { <98.7723, 260.7482, 224.1533>, <96.3354, 262.802, 222.2493>, <96.8623, 271.465, 219.7496> }
				triangle { <96.8623, 271.465, 219.7496>, <101.6749, 273.5928, 209.6389>, <110.3114, 280.8943, 196.2097> }
				triangle { <110.3114, 280.8943, 196.2097>, <105.3349, 274.2773, 211.7188>, <98.931, 272.1908, 220.7141> }
				triangle { <105.3349, 274.2773, 211.7188>, <102.2645, 270.0314, 221.2097>, <98.931, 272.1908, 220.7141> }
				triangle { <102.2645, 270.0314, 221.2097>, <100.5246, 263.3876, 224.5741>, <98.931, 272.1908, 220.7141> }
				triangle { <96.8623, 271.465, 219.7496>, <96.3354, 262.802, 222.2493>, <96.3707, 267.6815, 218.4287> }
				triangle { <96.3707, 267.6815, 218.4287>, <101.6749, 273.5928, 209.6389>, <96.8623, 271.465, 219.7496> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <120.9822, 280.1495, 164.5734>, <119.6172, 289.521, 178.123>, 0.5 }
		cylinder { <119.6172, 289.521, 178.123>, <117.2795, 296.9237, 192.7181>, 0.5 }
		cylinder { <117.2795, 296.9237, 192.7181>, <114.0196, 302.1972, 208.0428>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <114.0196, 302.1972, 208.0428>, <112.1741, 302.1776, 213.7261>, 0.3872 }
			cylinder { <112.1741, 302.1776, 213.7261>, <109.8773, 300.2345, 218.8889>, 0.3872 }
			cylinder { <109.8773, 300.2345, 218.8889>, <107.3976, 296.5951, 222.9277>, 0.3872 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <107.3976, 296.5951, 222.9277>, <106.3553, 295.0216, 224.5818>, 0.3872 }
				cylinder { <106.3553, 295.0216, 224.5818>, <105.3128, 293.4042, 226.1929>, 0.3872 }
				cylinder { <105.3128, 293.4042, 226.1929>, <104.2707, 291.7437, 227.7598>, 0.3872 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <104.2707, 291.7437, 227.7598>, <104.0327, 291.5366, 227.9536>, 0.02399 }
				cylinder { <104.0327, 291.5366, 227.9536>, <103.7277, 291.3822, 228.0958>, 0.02399 }
				cylinder { <103.7277, 291.3822, 228.0958>, <103.3777, 291.2919, 228.1763>, 0.02399 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <103.3777, 291.2919, 228.1763>, <83.09707, 283.8935, 232.3423>, <82.4662, 284.1458, 230.6161> }
				triangle { <83.09707, 283.8935, 232.3423>, <80.3052, 275.3179, 230.2612>, <82.4662, 284.1458, 230.6161> }
				triangle { <83.09707, 283.8935, 232.3423>, <81.201, 276.5902, 232.1865>, <80.3052, 275.3179, 230.2612> }
				triangle { <80.3052, 275.3179, 230.2612>, <80.1913, 277.7869, 228.7916>, <82.4662, 284.1458, 230.6161> }
				triangle { <82.4662, 284.1458, 230.6161>, <90.7941, 286.1445, 228.4727>, <103.3777, 291.2919, 228.1763> }
				triangle { <103.3777, 291.2919, 228.1763>, <91.6615, 285.2105, 231.5203>, <83.09707, 283.8935, 232.3423> }
				triangle { <91.6615, 285.2105, 231.5203>, <84.4644, 281.3589, 233.4902>, <83.09707, 283.8935, 232.3423> }
				triangle { <84.4644, 281.3589, 233.4902>, <81.201, 276.5902, 232.1865>, <83.09707, 283.8935, 232.3423> }
				triangle { <82.4662, 284.1458, 230.6161>, <80.1913, 277.7869, 228.7916>, <82.6656, 281.8871, 228.4624> }
				triangle { <82.6656, 281.8871, 228.4624>, <90.7941, 286.1445, 228.4727>, <82.4662, 284.1458, 230.6161> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <104.2707, 291.7437, 227.7598>, <104.1087, 291.5015, 227.9883>, 0.02399 }
				cylinder { <104.1087, 291.5015, 227.9883>, <103.9387, 291.2621, 228.2138>, 0.02399 }
				cylinder { <103.9387, 291.2621, 228.2138>, <103.7605, 291.0258, 228.4363>, 0.02399 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <103.7605, 291.0258, 228.4363>, <94.265, 275.391, 240.6341>, <92.8781, 275.0669, 239.4453> }
				triangle { <94.265, 275.391, 240.6341>, <95.4213, 266.3424, 239.0683>, <92.8781, 275.0669, 239.4453> }
				triangle { <94.265, 275.391, 240.6341>, <96.3523, 268.1397, 240.4934>, <95.4213, 266.3424, 239.0683> }
				triangle { <95.4213, 266.3424, 239.0683>, <93.4541, 268.2196, 238.1331>, <92.8781, 275.0669, 239.4453> }
				triangle { <92.8781, 275.0669, 239.4453>, <97.08498, 280.5293, 233.931>, <103.7605, 291.0258, 228.4363> }
				triangle { <103.7605, 291.0258, 228.4363>, <99.5893, 280.5601, 236.0851>, <94.265, 275.391, 240.6341> }
				triangle { <99.5893, 280.5601, 236.0851>, <97.04471, 274.0193, 240.6956>, <94.265, 275.391, 240.6341> }
				triangle { <97.04471, 274.0193, 240.6956>, <96.3523, 268.1397, 240.4934>, <94.265, 275.391, 240.6341> }
				triangle { <92.8781, 275.0669, 239.4453>, <93.4541, 268.2196, 238.1331>, <93.1347, 272.9155, 237.1903> }
				triangle { <93.1347, 272.9155, 237.1903>, <97.08498, 280.5293, 233.931>, <92.8781, 275.0669, 239.4453> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <114.0196, 302.1972, 208.0428>, <111.8491, 308.0072, 223.2993>, 0.4981 }
		cylinder { <111.8491, 308.0072, 223.2993>, <110.7674, 314.3421, 238.4626>, 0.4981 }
		cylinder { <110.7674, 314.3421, 238.4626>, <110.7805, 321.1676, 253.4505>, 0.4981 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <110.7805, 321.1676, 253.4505>, <111.7705, 322.8595, 256.0358>, 0.2102 }
			cylinder { <111.7705, 322.8595, 256.0358>, <113.6323, 324.7009, 257.9514>, 0.2102 }
			cylinder { <113.6323, 324.7009, 257.9514>, <116.148, 326.4764, 258.9734>, 0.2102 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <116.148, 326.4764, 258.9734>, <117.2052, 327.244, 259.3607>, 0.2102 }
				cylinder { <117.2052, 327.244, 259.3607>, <118.2617, 328.0326, 259.7056>, 0.2102 }
				cylinder { <118.2617, 328.0326, 259.7056>, <119.3161, 328.841, 260.0076>, 0.2102 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <119.3161, 328.841, 260.0076>, <119.4109, 328.8831, 260.0416>, 0.007074 }
				cylinder { <119.4109, 328.8831, 260.0416>, <119.5104, 328.9001, 260.0832>, 0.007074 }
				cylinder { <119.5104, 328.9001, 260.0832>, <119.6086, 328.8909, 260.1301>, 0.007074 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <119.6086, 328.8909, 260.1301>, <130.6617, 328.4636, 264.6193>, <130.8757, 327.5509, 264.2508> }
				triangle { <130.6617, 328.4636, 264.6193>, <134.771, 329.4891, 261.9144>, <130.8757, 327.5509, 264.2508> }
				triangle { <130.6617, 328.4636, 264.6193>, <133.9279, 330.1007, 262.7639>, <134.771, 329.4891, 261.9144> }
				triangle { <134.771, 329.4891, 261.9144>, <134.015, 328.153, 262.1989>, <130.8757, 327.5509, 264.2508> }
				triangle { <130.8757, 327.5509, 264.2508>, <126.694, 327.8478, 261.9263>, <119.6086, 328.8909, 260.1301> }
				triangle { <119.6086, 328.8909, 260.1301>, <126.5854, 329.5478, 262.488>, <130.6617, 328.4636, 264.6193> }
				triangle { <126.5854, 329.5478, 262.488>, <130.9116, 329.9501, 263.8699>, <130.6617, 328.4636, 264.6193> }
				triangle { <130.9116, 329.9501, 263.8699>, <133.9279, 330.1007, 262.7639>, <130.6617, 328.4636, 264.6193> }
				triangle { <130.8757, 327.5509, 264.2508>, <134.015, 328.153, 262.1989>, <131.588, 327.3593, 262.7214> }
				triangle { <131.588, 327.3593, 262.7214>, <126.694, 327.8478, 261.9263>, <130.8757, 327.5509, 264.2508> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <119.3161, 328.841, 260.0076>, <119.4006, 328.9058, 260.0318>, 0.007074 }
				cylinder { <119.4006, 328.9058, 260.0318>, <119.4851, 328.9706, 260.056>, 0.007074 }
				cylinder { <119.4851, 328.9706, 260.056>, <119.5696, 329.0353, 260.0802>, 0.007074 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <119.5696, 329.0353, 260.0802>, <128.6733, 336.535, 261.9197>, <129.3923, 335.8555, 261.73> }
				triangle { <128.6733, 336.535, 261.9197>, <131.1541, 338.8167, 258.1922>, <129.3923, 335.8555, 261.73> }
				triangle { <128.6733, 336.535, 261.9197>, <130.1472, 339.0601, 259.0487>, <131.1541, 338.8167, 258.1922> }
				triangle { <131.1541, 338.8167, 258.1922>, <131.4004, 337.4671, 258.9375>, <129.3923, 335.8555, 261.73> }
				triangle { <129.3923, 335.8555, 261.73>, <125.84, 332.92, 260.4105>, <119.5696, 329.0353, 260.0802> }
				triangle { <119.5696, 329.0353, 260.0802>, <124.7232, 334.3132, 260.5799>, <128.6733, 336.535, 261.9197> }
				triangle { <124.7232, 334.3132, 260.5799>, <127.919, 337.5567, 260.8149>, <128.6733, 336.535, 261.9197> }
				triangle { <127.919, 337.5567, 260.8149>, <130.1472, 339.0601, 259.0487>, <128.6733, 336.535, 261.9197> }
				triangle { <129.3923, 335.8555, 261.73>, <131.4004, 337.4671, 258.9375>, <130.01, 335.6351, 260.1638> }
				triangle { <130.01, 335.6351, 260.1638>, <125.84, 332.92, 260.4105>, <129.3923, 335.8555, 261.73> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <110.7805, 321.1676, 253.4505>, <109.6841, 323.5924, 257.9726>, 0.1586 }
		cylinder { <109.6841, 323.5924, 257.9726>, <107.5405, 326.1496, 262.0218>, 0.1586 }
		cylinder { <107.5405, 326.1496, 262.0218>, <104.4537, 328.7149, 265.4014>, 0.1586 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <104.4537, 328.7149, 265.4014>, <103.903, 329.0177, 265.6645>, 0.04415 }
			cylinder { <103.903, 329.0177, 265.6645>, <103.2668, 329.2548, 265.7211>, 0.04415 }
			cylinder { <103.2668, 329.2548, 265.7211>, <102.6195, 329.3985, 265.5646>, 0.04415 }
			material { txgilia_petiole }}
		union { // compound leaf
				cylinder { <102.6195, 329.3985, 265.5646>, <102.3476, 329.4589, 265.4989>, 0.04415 }
				cylinder { <102.3476, 329.4589, 265.4989>, <102.0757, 329.5193, 265.4331>, 0.04415 }
				cylinder { <102.0757, 329.5193, 265.4331>, <101.8038, 329.5796, 265.3674>, 0.04415 }
				material { txgilia_petiole }
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <104.4537, 328.7149, 265.4014>, <103.5375, 329.4361, 266.5926>, 0.189 }
			cylinder { <103.5375, 329.4361, 266.5926>, <102.6945, 330.0565, 267.8899>, 0.189 }
			cylinder { <102.6945, 330.0565, 267.8899>, <101.9329, 330.5702, 269.2807>, 0.189 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <101.9329, 330.5702, 269.2807>, <101.2599, 330.9723, 270.7517>, 0.189 }
			cylinder { <101.2599, 330.9723, 270.7517>, <100.682, 331.2588, 272.2887>, 0.189 }
			cylinder { <100.682, 331.2588, 272.2887>, <100.2049, 331.4271, 273.8769>, 0.189 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <100.2049, 331.4271, 273.8769>, <99.7328, 331.757, 275.4411>, 0.189 }
			cylinder { <99.7328, 331.757, 275.4411>, <99.2705, 332.2456, 276.9662>, 0.189 }
			cylinder { <99.2705, 332.2456, 276.9662>, <98.8223, 332.8879, 278.4376>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <98.8223, 332.8879, 278.4376>, <98.1856, 334.1266, 280.5141>, 0.189 }
				cylinder { <98.1856, 334.1266, 280.5141>, <97.594, 335.6218, 282.4287>, 0.189 }
				cylinder { <97.594, 335.6218, 282.4287>, <97.05651, 337.3511, 284.1527>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <97.05651, 337.3511, 284.1527>, <93.2177, 345.4401, 291.134>, <93.1585, 344.2818, 292.1479> }
					triangle { <97.05651, 337.3511, 284.1527>, <95.3217, 342.3539, 287.4769>, <93.2177, 345.4401, 291.134> }
					triangle { <93.1585, 344.2818, 292.1479>, <95.846, 341.2766, 289.3976>, <97.05651, 337.3511, 284.1527> }
					triangle { <95.3217, 342.3539, 287.4769>, <91.7055, 345.6079, 290.4233>, <93.2177, 345.4401, 291.134> }
					triangle { <91.7055, 345.6079, 290.4233>, <89.1492, 345.0652, 291.2822>, <93.2177, 345.4401, 291.134> }
					triangle { <93.1585, 344.2818, 292.1479>, <92.109, 343.5581, 293.5327>, <94.1378, 343.7325, 293.2737> }
					triangle { <94.1378, 343.7325, 293.2737>, <95.846, 341.2766, 289.3976>, <93.1585, 344.2818, 292.1479> }
					triangle { <89.1492, 345.0652, 291.2822>, <89.5632, 345.1527, 291.7286>, <91.8513, 344.7819, 292.3376> }
					triangle { <89.5632, 345.1527, 291.7286>, <88.03262, 342.9986, 292.2991>, <90.8499, 343.5862, 293.8473> }
					triangle { <91.8513, 344.7819, 292.3376>, <90.8499, 343.5862, 293.8473>, <92.109, 343.5581, 293.5327> }
					triangle { <91.8513, 344.7819, 292.3376>, <89.5632, 345.1527, 291.7286>, <90.8499, 343.5862, 293.8473> }
					triangle { <93.2177, 345.4401, 291.134>, <89.1492, 345.0652, 291.2822>, <91.8513, 344.7819, 292.3376> }
					triangle { <93.1585, 344.2818, 292.1479>, <91.8513, 344.7819, 292.3376>, <92.109, 343.5581, 293.5327> }
					triangle { <93.2177, 345.4401, 291.134>, <91.8513, 344.7819, 292.3376>, <93.1585, 344.2818, 292.1479> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <97.05651, 337.3511, 284.1527>, <93.6173, 344.4961, 292.2785>, <95.03411, 344.2572, 292.8342> }
					triangle { <97.05651, 337.3511, 284.1527>, <94.5924, 341.5588, 288.0657>, <93.6173, 344.4961, 292.2785> }
					triangle { <95.03411, 344.2572, 292.8342>, <96.6664, 342.1711, 288.7353>, <97.05651, 337.3511, 284.1527> }
					triangle { <94.5924, 341.5588, 288.0657>, <92.5589, 343.4342, 293.0351>, <93.6173, 344.4961, 292.2785> }
					triangle { <92.5589, 343.4342, 293.0351>, <92.5512, 342.2211, 295.5038>, <93.6173, 344.4961, 292.2785> }
					triangle { <95.03411, 344.2572, 292.8342>, <95.9882, 343.9934, 294.435>, <96.4245, 345.0184, 292.711> }
					triangle { <96.4245, 345.0184, 292.711>, <96.6664, 342.1711, 288.7353>, <95.03411, 344.2572, 292.8342> }
					triangle { <92.5512, 342.2211, 295.5038>, <92.8837, 342.7371, 295.4659>, <94.3087, 344.0121, 294.021> }
					triangle { <92.8837, 342.7371, 295.4659>, <94.276, 340.838, 296.7939>, <95.7027, 343.5309, 295.614> }
					triangle { <94.3087, 344.0121, 294.021>, <95.7027, 343.5309, 295.614>, <95.9882, 343.9934, 294.435> }
					triangle { <94.3087, 344.0121, 294.021>, <92.8837, 342.7371, 295.4659>, <95.7027, 343.5309, 295.614> }
					triangle { <93.6173, 344.4961, 292.2785>, <92.5512, 342.2211, 295.5038>, <94.3087, 344.0121, 294.021> }
					triangle { <95.03411, 344.2572, 292.8342>, <94.3087, 344.0121, 294.021>, <95.9882, 343.9934, 294.435> }
					triangle { <93.6173, 344.4961, 292.2785>, <94.3087, 344.0121, 294.021>, <95.03411, 344.2572, 292.8342> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <97.05651, 337.3511, 284.1527>, <95.1091, 344.7073, 292.5789>, <96.09943, 345.5883, 291.7937> }
					triangle { <97.05651, 337.3511, 284.1527>, <95.2624, 340.9793, 288.9178>, <95.1091, 344.7073, 292.5789> }
					triangle { <96.09943, 345.5883, 291.7937>, <95.9127, 342.8231, 287.7767>, <97.05651, 337.3511, 284.1527> }
					triangle { <95.2624, 340.9793, 288.9178>, <95.9574, 343.8733, 293.7643>, <95.1091, 344.7073, 292.5789> }
					triangle { <95.9574, 343.8733, 293.7643>, <98.2557, 344.4198, 295.1735>, <95.1091, 344.7073, 292.5789> }
					triangle { <96.09943, 345.5883, 291.7937>, <97.5365, 346.7839, 292.0127>, <95.9503, 346.7427, 290.7106> }
					triangle { <95.9503, 346.7427, 290.7106>, <95.9127, 342.8231, 287.7767>, <96.09943, 345.5883, 291.7937> }
					triangle { <98.2557, 344.4198, 295.1735>, <97.9659, 344.911, 294.943>, <96.6984, 345.6993, 293.068> }
					triangle { <97.9659, 344.911, 294.943>, <100.6232, 345.1089, 294.4864>, <98.4478, 346.9756, 292.9172> }
					triangle { <96.6984, 345.6993, 293.068>, <98.4478, 346.9756, 292.9172>, <97.5365, 346.7839, 292.0127> }
					triangle { <96.6984, 345.6993, 293.068>, <97.9659, 344.911, 294.943>, <98.4478, 346.9756, 292.9172> }
					triangle { <95.1091, 344.7073, 292.5789>, <98.2557, 344.4198, 295.1735>, <96.6984, 345.6993, 293.068> }
					triangle { <96.09943, 345.5883, 291.7937>, <96.6984, 345.6993, 293.068>, <97.5365, 346.7839, 292.0127> }
					triangle { <95.1091, 344.7073, 292.5789>, <96.6984, 345.6993, 293.068>, <96.09943, 345.5883, 291.7937> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <97.05651, 337.3511, 284.1527>, <95.6455, 345.7839, 291.6229>, <94.8922, 346.4479, 290.4547> }
					triangle { <97.05651, 337.3511, 284.1527>, <96.412, 341.4108, 288.8635>, <95.6455, 345.7839, 291.6229> }
					triangle { <94.8922, 346.4479, 290.4547>, <94.6194, 342.3377, 287.8377>, <97.05651, 337.3511, 284.1527> }
					triangle { <96.412, 341.4108, 288.8635>, <97.2361, 346.3225, 291.61>, <95.6455, 345.7839, 291.6229> }
					triangle { <97.2361, 346.3225, 291.61>, <98.4325, 348.6434, 290.7446>, <95.6455, 345.7839, 291.6229> }
					triangle { <94.8922, 346.4479, 290.4547>, <94.6287, 348.0992, 289.5907>, <93.366, 346.5384, 290.0183> }
					triangle { <93.366, 346.5384, 290.0183>, <94.6194, 342.3377, 287.8377>, <94.8922, 346.4479, 290.4547> }
					triangle { <98.4325, 348.6434, 290.7446>, <97.8338, 348.6904, 290.8777>, <95.7402, 347.5276, 290.7866> }
					triangle { <97.8338, 348.6904, 290.8777>, <98.3617, 349.9488, 288.5439>, <95.3171, 349.1918, 289.4587> }
					triangle { <95.7402, 347.5276, 290.7866>, <95.3171, 349.1918, 289.4587>, <94.6287, 348.0992, 289.5907> }
					triangle { <95.7402, 347.5276, 290.7866>, <97.8338, 348.6904, 290.8777>, <95.3171, 349.1918, 289.4587> }
					triangle { <95.6455, 345.7839, 291.6229>, <98.4325, 348.6434, 290.7446>, <95.7402, 347.5276, 290.7866> }
					triangle { <94.8922, 346.4479, 290.4547>, <95.7402, 347.5276, 290.7866>, <94.6287, 348.0992, 289.5907> }
					triangle { <95.6455, 345.7839, 291.6229>, <95.7402, 347.5276, 290.7866>, <94.8922, 346.4479, 290.4547> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <97.05651, 337.3511, 284.1527>, <94.4589, 346.2436, 290.7165>, <93.04722, 345.6283, 290.677> }
					triangle { <97.05651, 337.3511, 284.1527>, <96.4492, 342.2732, 287.9596>, <94.4589, 346.2436, 290.7165> }
					triangle { <93.04722, 345.6283, 290.677>, <94.5775, 341.3675, 288.8547>, <97.05651, 337.3511, 284.1527> }
					triangle { <96.4492, 342.2732, 287.9596>, <94.5686, 347.4107, 289.514>, <94.4589, 346.2436, 290.7165> }
					triangle { <94.5686, 347.4107, 289.514>, <92.7194, 349.0482, 288.3033>, <94.4589, 346.2436, 290.7165> }
					triangle { <93.04722, 345.6283, 290.677>, <91.2237, 346.0755, 290.5443>, <92.2289, 344.6499, 291.6263> }
					triangle { <92.2289, 344.6499, 291.6263>, <94.5775, 341.3675, 288.8547>, <93.04722, 345.6283, 290.677> }
					triangle { <92.7194, 349.0482, 288.3033>, <92.5622, 348.842, 288.8611>, <92.6993, 346.952, 290.3284> }
					triangle { <92.5622, 348.842, 288.8611>, <90.4628, 348.6248, 287.1718>, <90.5505, 347.0654, 290.0422> }
					triangle { <92.6993, 346.952, 290.3284>, <90.5505, 347.0654, 290.0422>, <91.2237, 346.0755, 290.5443> }
					triangle { <92.6993, 346.952, 290.3284>, <92.5622, 348.842, 288.8611>, <90.5505, 347.0654, 290.0422> }
					triangle { <94.4589, 346.2436, 290.7165>, <92.7194, 349.0482, 288.3033>, <92.6993, 346.952, 290.3284> }
					triangle { <93.04722, 345.6283, 290.677>, <92.6993, 346.952, 290.3284>, <91.2237, 346.0755, 290.5443> }
					triangle { <94.4589, 346.2436, 290.7165>, <92.6993, 346.952, 290.3284>, <93.04722, 345.6283, 290.677> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <98.8223, 332.8879, 278.4376>, <98.2591, 333.4142, 279.9156>, 0.189 }
			cylinder { <98.2591, 333.4142, 279.9156>, <97.5863, 333.8192, 281.3858>, 0.189 }
			cylinder { <97.5863, 333.8192, 281.3858>, <96.8103, 334.0992, 282.8343>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <96.8103, 334.0992, 282.8343>, <95.469, 334.2791, 284.9366>, 0.189 }
				cylinder { <95.469, 334.2791, 284.9366>, <93.9705, 334.2163, 286.9371>, 0.189 }
				cylinder { <93.9705, 334.2163, 286.9371>, <92.3372, 333.9117, 288.8055>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <92.3372, 333.9117, 288.8055>, <85.5409, 332.2984, 297.7465>, <86.2284, 333.5731, 298.2686> }
					triangle { <92.3372, 333.9117, 288.8055>, <88.1092, 332.5709, 293.2057>, <85.5409, 332.2984, 297.7465> }
					triangle { <86.2284, 333.5731, 298.2686>, <88.1821, 334.7072, 293.9463>, <92.3372, 333.9117, 288.8055> }
					triangle { <88.1092, 332.5709, 293.2057>, <86.348, 330.9632, 298.3649>, <85.5409, 332.2984, 297.7465> }
					triangle { <86.348, 330.9632, 298.3649>, <87.7948, 330.5353, 300.6628>, <85.5409, 332.2984, 297.7465> }
					triangle { <86.2284, 333.5731, 298.2686>, <86.9351, 334.3604, 299.8237>, <85.8752, 335.122, 298.2412> }
					triangle { <85.8752, 335.122, 298.2412>, <88.1821, 334.7072, 293.9463>, <86.2284, 333.5731, 298.2686> }
					triangle { <87.7948, 330.5353, 300.6628>, <87.3911, 330.9981, 300.6892>, <86.4013, 332.7679, 299.4148> }
					triangle { <87.3911, 330.9981, 300.6892>, <89.7449, 331.7646, 301.7715>, <87.4363, 333.9178, 300.9354> }
					triangle { <86.4013, 332.7679, 299.4148>, <87.4363, 333.9178, 300.9354>, <86.9351, 334.3604, 299.8237> }
					triangle { <86.4013, 332.7679, 299.4148>, <87.3911, 330.9981, 300.6892>, <87.4363, 333.9178, 300.9354> }
					triangle { <85.5409, 332.2984, 297.7465>, <87.7948, 330.5353, 300.6628>, <86.4013, 332.7679, 299.4148> }
					triangle { <86.2284, 333.5731, 298.2686>, <86.4013, 332.7679, 299.4148>, <86.9351, 334.3604, 299.8237> }
					triangle { <85.5409, 332.2984, 297.7465>, <86.4013, 332.7679, 299.4148>, <86.2284, 333.5731, 298.2686> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <92.3372, 333.9117, 288.8055>, <85.7902, 333.7782, 298.0711>, <85.1331, 334.999, 297.402> }
					triangle { <92.3372, 333.9117, 288.8055>, <88.9487, 333.0245, 293.9792>, <85.7902, 333.7782, 298.0711> }
					triangle { <85.1331, 334.999, 297.402>, <87.2377, 334.197, 293.0762>, <92.3372, 333.9117, 288.8055> }
					triangle { <88.9487, 333.0245, 293.9792>, <86.9612, 334.3211, 299.1437>, <85.7902, 333.7782, 298.0711> }
					triangle { <86.9612, 334.3211, 299.1437>, <87.2471, 336.6289, 300.6096>, <85.7902, 333.7782, 298.0711> }
					triangle { <85.1331, 334.999, 297.402>, <84.4198, 336.7006, 297.7678>, <83.8634, 335.212, 296.4709> }
					triangle { <83.8634, 335.212, 296.4709>, <87.2377, 334.197, 293.0762>, <85.1331, 334.999, 297.402> }
					triangle { <87.2471, 336.6289, 300.6096>, <86.6713, 336.4942, 300.4418>, <85.3453, 335.5602, 298.6796> }
					triangle { <86.6713, 336.4942, 300.4418>, <87.1673, 339.1154, 300.0145>, <84.598, 337.5967, 298.6888> }
					triangle { <85.3453, 335.5602, 298.6796>, <84.598, 337.5967, 298.6888>, <84.4198, 336.7006, 297.7678> }
					triangle { <85.3453, 335.5602, 298.6796>, <86.6713, 336.4942, 300.4418>, <84.598, 337.5967, 298.6888> }
					triangle { <85.7902, 333.7782, 298.0711>, <87.2471, 336.6289, 300.6096>, <85.3453, 335.5602, 298.6796> }
					triangle { <85.1331, 334.999, 297.402>, <85.3453, 335.5602, 298.6796>, <84.4198, 336.7006, 297.7678> }
					triangle { <85.7902, 333.7782, 298.0711>, <85.3453, 335.5602, 298.6796>, <85.1331, 334.999, 297.402> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <92.3372, 333.9117, 288.8055>, <84.8003, 334.6233, 297.2567>, <83.8195, 334.124, 296.1802> }
					triangle { <92.3372, 333.9117, 288.8055>, <88.8509, 334.2488, 293.9792>, <84.8003, 334.6233, 297.2567> }
					triangle { <83.8195, 334.124, 296.1802>, <87.3478, 332.8195, 293.0761>, <92.3372, 333.9117, 288.8055> }
					triangle { <88.8509, 334.2488, 293.9792>, <84.7279, 336.299, 297.3111>, <84.8003, 334.6233, 297.2567> }
					triangle { <84.7279, 336.299, 297.3111>, <82.7471, 338.1176, 296.7408>, <84.8003, 334.6233, 297.2567> }
					triangle { <83.8195, 334.124, 296.1802>, <82.07089, 334.3566, 295.5277>, <83.2572, 332.6992, 295.758> }
					triangle { <83.2572, 332.6992, 295.758>, <87.3478, 332.8195, 293.0761>, <83.8195, 334.124, 296.1802> }
					triangle { <82.7471, 338.1176, 296.7408>, <82.5517, 337.5513, 296.8784>, <83.06642, 335.2242, 296.6433> }
					triangle { <82.5517, 337.5513, 296.8784>, <81.2225, 338.4864, 294.7202>, <81.2058, 335.3234, 295.5324> }
					triangle { <83.06642, 335.2242, 296.6433>, <81.2058, 335.3234, 295.5324>, <82.07089, 334.3566, 295.5277> }
					triangle { <83.06642, 335.2242, 296.6433>, <82.5517, 337.5513, 296.8784>, <81.2058, 335.3234, 295.5324> }
					triangle { <84.8003, 334.6233, 297.2567>, <82.7471, 338.1176, 296.7408>, <83.06642, 335.2242, 296.6433> }
					triangle { <83.8195, 334.124, 296.1802>, <83.06642, 335.2242, 296.6433>, <82.07089, 334.3566, 295.5277> }
					triangle { <84.8003, 334.6233, 297.2567>, <83.06642, 335.2242, 296.6433>, <83.8195, 334.124, 296.1802> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <92.3372, 333.9117, 288.8055>, <83.9301, 333.6736, 296.4211>, <84.09084, 332.149, 296.2802> }
					triangle { <92.3372, 333.9117, 288.8055>, <87.95, 334.5634, 293.2058>, <83.9301, 333.6736, 296.4211> }
					triangle { <84.09084, 332.149, 296.2802>, <88.3613, 332.4657, 293.9462>, <92.3372, 333.9117, 288.8055> }
					triangle { <87.95, 334.5634, 293.2058>, <82.7136, 334.182, 295.3827>, <83.9301, 333.6736, 296.4211> }
					triangle { <82.7136, 334.182, 295.3827>, <80.4716, 332.9581, 294.3668>, <83.9301, 333.6736, 296.4211> }
					triangle { <84.09084, 332.149, 296.2802>, <83.1124, 330.5459, 296.1784>, <84.8888, 331.0327, 297.0812> }
					triangle { <84.8888, 331.0327, 297.0812>, <88.3613, 332.4657, 293.9462>, <84.09084, 332.149, 296.2802> }
					triangle { <80.4716, 332.9581, 294.3668>, <80.687, 332.7184, 294.8903>, <82.6926, 332.221, 296.1011> }
					triangle { <80.687, 332.7184, 294.8903>, <80.07065, 330.741, 293.1557>, <81.9159, 330.2182, 295.7989> }
					triangle { <82.6926, 332.221, 296.1011>, <81.9159, 330.2182, 295.7989>, <83.1124, 330.5459, 296.1784> }
					triangle { <82.6926, 332.221, 296.1011>, <80.687, 332.7184, 294.8903>, <81.9159, 330.2182, 295.7989> }
					triangle { <83.9301, 333.6736, 296.4211>, <80.4716, 332.9581, 294.3668>, <82.6926, 332.221, 296.1011> }
					triangle { <84.09084, 332.149, 296.2802>, <82.6926, 332.221, 296.1011>, <83.1124, 330.5459, 296.1784> }
					triangle { <83.9301, 333.6736, 296.4211>, <82.6926, 332.221, 296.1011>, <84.09084, 332.149, 296.2802> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <92.3372, 333.9117, 288.8055>, <84.3947, 332.2151, 296.7284>, <85.602, 331.8034, 297.5904> }
					triangle { <92.3372, 333.9117, 288.8055>, <87.4847, 333.5107, 292.7206>, <84.3947, 332.2151, 296.7284> }
					triangle { <85.602, 331.8034, 297.5904>, <88.8847, 333.65, 294.4921>, <92.3372, 333.9117, 288.8055> }
					triangle { <87.4847, 333.5107, 292.7206>, <83.73, 330.8345, 296.0438>, <84.3947, 332.2151, 296.7284> }
					triangle { <83.73, 330.8345, 296.0438>, <83.6384, 328.2012, 296.8274>, <84.3947, 332.2151, 296.7284> }
					triangle { <85.602, 331.8034, 297.5904>, <86.1641, 330.5483, 298.8735>, <86.5312, 332.5527, 298.639> }
					triangle { <86.5312, 332.5527, 298.639>, <88.8847, 333.65, 294.4921>, <85.602, 331.8034, 297.5904> }
					triangle { <83.6384, 328.2012, 296.8274>, <83.7231, 328.6072, 297.281>, <84.7848, 330.68, 297.8398> }
					triangle { <83.7231, 328.6072, 297.281>, <85.4172, 326.524, 297.5795>, <85.8247, 329.3364, 299.1885> }
					triangle { <84.7848, 330.68, 297.8398>, <85.8247, 329.3364, 299.1885>, <86.1641, 330.5483, 298.8735> }
					triangle { <84.7848, 330.68, 297.8398>, <83.7231, 328.6072, 297.281>, <85.8247, 329.3364, 299.1885> }
					triangle { <84.3947, 332.2151, 296.7284>, <83.6384, 328.2012, 296.8274>, <84.7848, 330.68, 297.8398> }
					triangle { <85.602, 331.8034, 297.5904>, <84.7848, 330.68, 297.8398>, <86.1641, 330.5483, 298.8735> }
					triangle { <84.3947, 332.2151, 296.7284>, <84.7848, 330.68, 297.8398>, <85.602, 331.8034, 297.5904> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <96.8103, 334.0992, 282.8343>, <96.1823, 334.4045, 284.3478>, 0.189 }
			cylinder { <96.1823, 334.4045, 284.3478>, <95.7083, 334.7322, 285.9119>, 0.189 }
			cylinder { <95.7083, 334.7322, 285.9119>, <95.3927, 335.0791, 287.5114>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <95.3927, 335.0791, 287.5114>, <95.2228, 335.6285, 289.9446>, 0.189 }
				cylinder { <95.2228, 335.6285, 289.9446>, <95.3588, 336.1987, 292.3752>, 0.189 }
				cylinder { <95.3588, 336.1987, 292.3752>, <95.7986, 336.781, 294.7667>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <95.7986, 336.781, 294.7667>, <97.4581, 340.1392, 305.4766>, <95.9326, 339.9582, 305.5773> }
					triangle { <95.7986, 336.781, 294.7667>, <97.5116, 338.3761, 300.5595>, <97.4581, 340.1392, 305.4766> }
					triangle { <95.9326, 339.9582, 305.5773>, <95.5995, 337.4912, 301.3834>, <95.7986, 336.781, 294.7667> }
					triangle { <97.5116, 338.3761, 300.5595>, <97.7845, 341.7478, 305.1269>, <97.4581, 340.1392, 305.4766> }
					triangle { <97.7845, 341.7478, 305.1269>, <96.4602, 344.0968, 305.6602>, <97.4581, 340.1392, 305.4766> }
					triangle { <95.9326, 339.9582, 305.5773>, <94.3805, 340.7306, 306.3068>, <94.9781, 338.7838, 306.0613> }
					triangle { <94.9781, 338.7838, 306.0613>, <95.5995, 337.4912, 301.3834>, <95.9326, 339.9582, 305.5773> }
					triangle { <96.4602, 344.0968, 305.6602>, <96.3266, 343.6292, 306.036>, <96.01749, 341.2559, 306.1258> }
					triangle { <96.3266, 343.6292, 306.036>, <94.0564, 344.8879, 305.2875>, <94.0258, 341.9264, 306.6635> }
					triangle { <96.01749, 341.2559, 306.1258>, <94.0258, 341.9264, 306.6635>, <94.3805, 340.7306, 306.3068> }
					triangle { <96.01749, 341.2559, 306.1258>, <96.3266, 343.6292, 306.036>, <94.0258, 341.9264, 306.6635> }
					triangle { <97.4581, 340.1392, 305.4766>, <96.4602, 344.0968, 305.6602>, <96.01749, 341.2559, 306.1258> }
					triangle { <95.9326, 339.9582, 305.5773>, <96.01749, 341.2559, 306.1258>, <94.3805, 340.7306, 306.3068> }
					triangle { <97.4581, 340.1392, 305.4766>, <96.01749, 341.2559, 306.1258>, <95.9326, 339.9582, 305.5773> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <95.7986, 336.781, 294.7667>, <96.09349, 339.5031, 305.7774>, <95.7886, 338.0062, 305.9685> }
					triangle { <95.7986, 336.781, 294.7667>, <96.4242, 338.9462, 300.5938>, <96.09349, 339.5031, 305.7774> }
					triangle { <95.7886, 338.0062, 305.9685>, <96.8228, 336.8498, 301.3448>, <95.7986, 336.781, 294.7667> }
					triangle { <96.4242, 338.9462, 300.5938>, <94.6461, 340.3521, 305.8059>, <96.09349, 339.5031, 305.7774> }
					triangle { <94.6461, 340.3521, 305.8059>, <92.221, 339.8994, 307.0184>, <96.09349, 339.5031, 305.7774> }
					triangle { <95.7886, 338.0062, 305.9685>, <94.7735, 336.8076, 307.0032>, <96.6724, 336.7127, 306.2334> }
					triangle { <96.6724, 336.7127, 306.2334>, <96.8228, 336.8498, 301.3448>, <95.7886, 338.0062, 305.9685> }
					triangle { <92.221, 339.8994, 307.0184>, <92.7011, 339.6167, 307.2782>, <94.7807, 338.5253, 306.8092> }
					triangle { <92.7011, 339.6167, 307.2782>, <90.6233, 337.9024, 307.0714>, <93.6651, 336.8779, 307.6737> }
					triangle { <94.7807, 338.5253, 306.8092>, <93.6651, 336.8779, 307.6737>, <94.7735, 336.8076, 307.0032> }
					triangle { <94.7807, 338.5253, 306.8092>, <92.7011, 339.6167, 307.2782>, <93.6651, 336.8779, 307.6737> }
					triangle { <96.09349, 339.5031, 305.7774>, <92.221, 339.8994, 307.0184>, <94.7807, 338.5253, 306.8092> }
					triangle { <95.7886, 338.0062, 305.9685>, <94.7807, 338.5253, 306.8092>, <94.7735, 336.8076, 307.0032> }
					triangle { <96.09349, 339.5031, 305.7774>, <94.7807, 338.5253, 306.8092>, <95.7886, 338.0062, 305.9685> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <95.7986, 336.781, 294.7667>, <96.3069, 338.0046, 306.0351>, <97.6181, 337.2131, 305.879> }
					triangle { <95.7986, 336.781, 294.7667>, <95.5617, 338.115, 300.8658>, <96.3069, 338.0046, 306.0351> }
					triangle { <97.6181, 337.2131, 305.879>, <97.793, 337.7849, 301.0388>, <95.7986, 336.781, 294.7667> }
					triangle { <95.5617, 338.115, 300.8658>, <95.07253, 336.9287, 306.4027>, <96.3069, 338.0046, 306.0351> }
					triangle { <95.07253, 336.9287, 306.4027>, <95.01372, 334.4961, 307.6815>, <96.3069, 338.0046, 306.0351> }
					triangle { <97.6181, 337.2131, 305.879>, <98.6486, 335.8558, 306.6749>, <99.1501, 337.6094, 305.7364> }
					triangle { <99.1501, 337.6094, 305.7364>, <97.793, 337.7849, 301.0388>, <97.6181, 337.2131, 305.879> }
					triangle { <95.01372, 334.4961, 307.6815>, <95.4946, 334.8533, 307.8191>, <97.03925, 336.4416, 306.9094> }
					triangle { <95.4946, 334.8533, 307.8191>, <96.323, 332.3185, 307.3864>, <98.4002, 334.8378, 307.4398> }
					triangle { <97.03925, 336.4416, 306.9094>, <98.4002, 334.8378, 307.4398>, <98.6486, 335.8558, 306.6749> }
					triangle { <97.03925, 336.4416, 306.9094>, <95.4946, 334.8533, 307.8191>, <98.4002, 334.8378, 307.4398> }
					triangle { <96.3069, 338.0046, 306.0351>, <95.01372, 334.4961, 307.6815>, <97.03925, 336.4416, 306.9094> }
					triangle { <97.6181, 337.2131, 305.879>, <97.03925, 336.4416, 306.9094>, <98.6486, 335.8558, 306.6749> }
					triangle { <96.3069, 338.0046, 306.0351>, <97.03925, 336.4416, 306.9094>, <97.6181, 337.2131, 305.879> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <95.7986, 336.781, 294.7667>, <97.8054, 337.7006, 305.8959>, <98.9098, 338.6675, 305.4317> }
					triangle { <95.7986, 336.781, 294.7667>, <96.108, 337.0234, 301.0021>, <97.8054, 337.7006, 305.8959> }
					triangle { <98.9098, 338.6675, 305.4317>, <97.1784, 339.013, 300.8854>, <95.7986, 336.781, 294.7667> }
					triangle { <96.108, 337.0234, 301.0021>, <98.4783, 336.1765, 306.0981>, <97.8054, 337.7006, 305.8959> }
					triangle { <98.4783, 336.1765, 306.0981>, <101.0049, 335.3037, 306.7392>, <97.8054, 337.7006, 305.8959> }
					triangle { <98.9098, 338.6675, 305.4317>, <100.6867, 339.1817, 305.7725>, <99.01016, 340.2431, 305.2526> }
					triangle { <99.01016, 340.2431, 305.2526>, <97.1784, 339.013, 300.8854>, <98.9098, 338.6675, 305.4317> }
					triangle { <101.0049, 335.3037, 306.7392>, <100.8726, 335.8773, 306.9163>, <99.6928, 337.8649, 306.2889> }
					triangle { <100.8726, 335.8773, 306.9163>, <103.3317, 335.8008, 305.8002>, <101.7315, 338.6064, 306.2828> }
					triangle { <99.6928, 337.8649, 306.2889>, <101.7315, 338.6064, 306.2828>, <100.6867, 339.1817, 305.7725> }
					triangle { <99.6928, 337.8649, 306.2889>, <100.8726, 335.8773, 306.9163>, <101.7315, 338.6064, 306.2828> }
					triangle { <97.8054, 337.7006, 305.8959>, <101.0049, 335.3037, 306.7392>, <99.6928, 337.8649, 306.2889> }
					triangle { <98.9098, 338.6675, 305.4317>, <99.6928, 337.8649, 306.2889>, <100.6867, 339.1817, 305.7725> }
					triangle { <97.8054, 337.7006, 305.8959>, <99.6928, 337.8649, 306.2889>, <98.9098, 338.6675, 305.4317> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <95.7986, 336.781, 294.7667>, <98.5276, 339.0398, 305.5455>, <97.8524, 340.3896, 305.2424> }
					triangle { <95.7986, 336.781, 294.7667>, <97.3313, 337.1872, 300.81>, <98.5276, 339.0398, 305.5455> }
					triangle { <97.8524, 340.3896, 305.2424>, <95.8023, 338.8287, 301.1016>, <95.7986, 336.781, 294.7667> }
					triangle { <97.3313, 337.1872, 300.81>, <100.1797, 339.1999, 305.2976>, <98.5276, 339.0398, 305.5455> }
					triangle { <100.1797, 339.1999, 305.2976>, <101.9124, 341.3269, 305.4712>, <98.5276, 339.0398, 305.5455> }
					triangle { <97.8524, 340.3896, 305.2424>, <98.00906, 342.24, 305.5415>, <96.3928, 340.9798, 305.4564> }
					triangle { <96.3928, 340.9798, 305.4564>, <95.8023, 338.8287, 301.1016>, <97.8524, 340.3896, 305.2424> }
					triangle { <101.9124, 341.3269, 305.4712>, <101.3946, 341.3829, 305.7976>, <99.05188, 340.8852, 305.7972> }
					triangle { <101.3946, 341.3829, 305.7976>, <101.9098, 343.6865, 304.4835>, <98.9871, 343.0535, 305.7958> }
					triangle { <99.05188, 340.8852, 305.7972>, <98.9871, 343.0535, 305.7958>, <98.00906, 342.24, 305.5415> }
					triangle { <99.05188, 340.8852, 305.7972>, <101.3946, 341.3829, 305.7976>, <98.9871, 343.0535, 305.7958> }
					triangle { <98.5276, 339.0398, 305.5455>, <101.9124, 341.3269, 305.4712>, <99.05188, 340.8852, 305.7972> }
					triangle { <97.8524, 340.3896, 305.2424>, <99.05188, 340.8852, 305.7972>, <98.00906, 342.24, 305.5415> }
					triangle { <98.5276, 339.0398, 305.5455>, <99.05188, 340.8852, 305.7972>, <97.8524, 340.3896, 305.2424> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <95.3927, 335.0791, 287.5114>, <94.9527, 335.518, 289.058>, 0.189 }
			cylinder { <94.9527, 335.518, 289.058>, <94.3924, 336.0447, 290.5369>, 0.189 }
			cylinder { <94.3924, 336.0447, 290.5369>, <93.7172, 336.6541, 291.9338>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <93.7172, 336.6541, 291.9338>, <92.5029, 337.7106, 293.8471>, 0.189 }
				cylinder { <92.5029, 337.7106, 293.8471>, <91.1054, 338.8937, 295.5497>, 0.189 }
				cylinder { <91.1054, 338.8937, 295.5497>, <89.5457, 340.1857, 297.0158>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <89.5457, 340.1857, 297.0158>, <81.3588, 344.8846, 303.2978>, <82.295, 344.5202, 304.4629> }
					triangle { <89.5457, 340.1857, 297.0158>, <84.8096, 343.1798, 299.7708>, <81.3588, 344.8846, 303.2978> }
					triangle { <82.295, 344.5202, 304.4629>, <86.11, 343.6108, 301.5692>, <89.5457, 340.1857, 297.0158> }
					triangle { <84.8096, 343.1798, 299.7708>, <80.2371, 343.6524, 303.1071>, <81.3588, 344.8846, 303.2978> }
					triangle { <80.2371, 343.6524, 303.1071>, <79.1302, 341.8307, 304.8401>, <81.3588, 344.8846, 303.2978> }
					triangle { <82.295, 344.5202, 304.4629>, <82.3035, 343.851, 306.2194>, <83.4114, 345.2982, 305.2812> }
					triangle { <83.4114, 345.2982, 305.2812>, <86.11, 343.6108, 301.5692>, <82.295, 344.5202, 304.4629> }
					triangle { <79.1302, 341.8307, 304.8401>, <79.3512, 342.3407, 305.1017>, <81.1062, 343.9635, 304.9791> }
					triangle { <79.3512, 342.3407, 305.1017>, <80.1157, 340.173, 306.518>, <81.5207, 343.0912, 306.9199> }
					triangle { <81.1062, 343.9635, 304.9791>, <81.5207, 343.0912, 306.9199>, <82.3035, 343.851, 306.2194> }
					triangle { <81.1062, 343.9635, 304.9791>, <79.3512, 342.3407, 305.1017>, <81.5207, 343.0912, 306.9199> }
					triangle { <81.3588, 344.8846, 303.2978>, <79.1302, 341.8307, 304.8401>, <81.1062, 343.9635, 304.9791> }
					triangle { <82.295, 344.5202, 304.4629>, <81.1062, 343.9635, 304.9791>, <82.3035, 343.851, 306.2194> }
					triangle { <81.3588, 344.8846, 303.2978>, <81.1062, 343.9635, 304.9791>, <82.295, 344.5202, 304.4629> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <89.5457, 340.1857, 297.0158>, <82.4229, 345.0219, 304.3946>, <83.5295, 346.0869, 304.4858> }
					triangle { <89.5457, 340.1857, 297.0158>, <85.01636, 342.4023, 300.6978>, <82.4229, 345.0219, 304.3946> }
					triangle { <83.5295, 346.0869, 304.4858>, <85.8774, 344.4856, 300.5262>, <89.5457, 340.1857, 297.0158> }
					triangle { <85.01636, 342.4023, 300.6978>, <82.6444, 343.9127, 305.6329>, <82.4229, 345.0219, 304.3946> }
					triangle { <82.6444, 343.9127, 305.6329>, <83.7586, 344.0865, 308.1379>, <82.4229, 345.0219, 304.3946> }
					triangle { <83.5295, 346.0869, 304.4858>, <84.4417, 347.193, 305.7013>, <83.7934, 347.4838, 303.7785> }
					triangle { <83.7934, 347.4838, 303.7785>, <85.8774, 344.4856, 300.5262>, <83.5295, 346.0869, 304.4858> }
					triangle { <83.7586, 344.0865, 308.1379>, <83.5612, 344.6179, 307.9012>, <83.3532, 345.8618, 305.867> }
					triangle { <83.5612, 344.6179, 307.9012>, <85.999, 344.9531, 309.0121>, <84.7075, 347.1464, 306.9694> }
					triangle { <83.3532, 345.8618, 305.867>, <84.7075, 347.1464, 306.9694>, <84.4417, 347.193, 305.7013> }
					triangle { <83.3532, 345.8618, 305.867>, <83.5612, 344.6179, 307.9012>, <84.7075, 347.1464, 306.9694> }
					triangle { <82.4229, 345.0219, 304.3946>, <83.7586, 344.0865, 308.1379>, <83.3532, 345.8618, 305.867> }
					triangle { <83.5295, 346.0869, 304.4858>, <83.3532, 345.8618, 305.867>, <84.4417, 347.193, 305.7013> }
					triangle { <82.4229, 345.0219, 304.3946>, <83.3532, 345.8618, 305.867>, <83.5295, 346.0869, 304.4858> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <89.5457, 340.1857, 297.0158>, <83.2078, 346.3163, 304.1443>, <83.08275, 347.2582, 302.9343> }
					triangle { <89.5457, 340.1857, 297.0158>, <85.9444, 342.8425, 301.3699>, <83.2078, 346.3163, 304.1443> }
					triangle { <83.08275, 347.2582, 302.9343>, <84.8334, 343.9904, 299.7702>, <89.5457, 340.1857, 297.0158> }
					triangle { <85.9444, 342.8425, 301.3699>, <84.4685, 346.8527, 305.1118>, <83.2078, 346.3163, 304.1443> }
					triangle { <84.4685, 346.8527, 305.1118>, <85.5728, 349.3272, 305.563>, <83.2078, 346.3163, 304.1443> }
					triangle { <83.08275, 347.2582, 302.9343>, <83.06194, 349.0746, 302.4509>, <82.015, 347.4472, 301.7744> }
					triangle { <82.015, 347.4472, 301.7744>, <84.8334, 343.9904, 299.7702>, <83.08275, 347.2582, 302.9343> }
					triangle { <85.5728, 349.3272, 305.563>, <84.994, 349.3319, 305.3572>, <83.4593, 348.2176, 303.8973> }
					triangle { <84.994, 349.3319, 305.3572>, <86.4606, 351.1661, 304.0251>, <83.5437, 350.1678, 302.9544> }
					triangle { <83.4593, 348.2176, 303.8973>, <83.5437, 350.1678, 302.9544>, <83.06194, 349.0746, 302.4509> }
					triangle { <83.4593, 348.2176, 303.8973>, <84.994, 349.3319, 305.3572>, <83.5437, 350.1678, 302.9544> }
					triangle { <83.2078, 346.3163, 304.1443>, <85.5728, 349.3272, 305.563>, <83.4593, 348.2176, 303.8973> }
					triangle { <83.08275, 347.2582, 302.9343>, <83.4593, 348.2176, 303.8973>, <83.06194, 349.0746, 302.4509> }
					triangle { <83.2078, 346.3163, 304.1443>, <83.4593, 348.2176, 303.8973>, <83.08275, 347.2582, 302.9343> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <89.5457, 340.1857, 297.0158>, <82.6361, 346.9911, 302.8905>, <81.568, 346.4264, 301.9381> }
					triangle { <89.5457, 340.1857, 297.0158>, <86.3199, 343.8962, 300.8645>, <82.6361, 346.9911, 302.8905> }
					triangle { <81.568, 346.4264, 301.9381>, <84.4109, 342.805, 300.3388>, <89.5457, 340.1857, 297.0158> }
					triangle { <86.3199, 343.8962, 300.8645>, <83.2055, 348.4368, 302.2592>, <82.6361, 346.9911, 302.8905> }
					triangle { <83.2055, 348.4368, 302.2592>, <82.08254, 350.3593, 300.6499>, <82.6361, 346.9911, 302.8905> }
					triangle { <81.568, 346.4264, 301.9381>, <80.05808, 346.913, 300.9298>, <80.5173, 345.2387, 302.0198> }
					triangle { <80.5173, 345.2387, 302.0198>, <84.4109, 342.805, 300.3388>, <81.568, 346.4264, 301.9381> }
					triangle { <82.08254, 350.3593, 300.6499>, <81.683, 350.0121, 300.9616>, <81.2789, 347.7972, 301.7736> }
					triangle { <81.683, 350.0121, 300.9616>, <80.8668, 350.2838, 298.4024>, <79.6267, 348.008, 300.386> }
					triangle { <81.2789, 347.7972, 301.7736>, <79.6267, 348.008, 300.386>, <80.05808, 346.913, 300.9298> }
					triangle { <81.2789, 347.7972, 301.7736>, <81.683, 350.0121, 300.9616>, <79.6267, 348.008, 300.386> }
					triangle { <82.6361, 346.9911, 302.8905>, <82.08254, 350.3593, 300.6499>, <81.2789, 347.7972, 301.7736> }
					triangle { <81.568, 346.4264, 301.9381>, <81.2789, 347.7972, 301.7736>, <80.05808, 346.913, 300.9298> }
					triangle { <82.6361, 346.9911, 302.8905>, <81.2789, 347.7972, 301.7736>, <81.568, 346.4264, 301.9381> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <89.5457, 340.1857, 297.0158>, <81.476, 346.0929, 302.3594>, <81.07386, 344.7087, 302.8971> }
					triangle { <89.5457, 340.1857, 297.0158>, <85.6079, 344.1078, 299.8612>, <81.476, 346.0929, 302.3594> }
					triangle { <81.07386, 344.7087, 302.8971>, <85.2119, 342.5669, 301.4674>, <89.5457, 340.1857, 297.0158> }
					triangle { <85.6079, 344.1078, 299.8612>, <80.5509, 346.4291, 301.0015>, <81.476, 346.0929, 302.3594> }
					triangle { <80.5509, 346.4291, 301.0015>, <78.04071, 345.6563, 300.1964>, <81.476, 346.0929, 302.3594> }
					triangle { <81.07386, 344.7087, 302.8971>, <79.5822, 343.636, 303.2941>, <81.3934, 343.8906, 304.2198> }
					triangle { <81.3934, 343.8906, 304.2198>, <85.2119, 342.5669, 301.4674>, <81.07386, 344.7087, 302.8971> }
					triangle { <78.04071, 345.6563, 300.1964>, <78.1429, 345.6261, 300.8013>, <79.8027, 345.1283, 302.4523> }
					triangle { <78.1429, 345.6261, 300.8013>, <76.8862, 343.3871, 299.9664>, <78.3576, 343.5684, 302.8739> }
					triangle { <79.8027, 345.1283, 302.4523>, <78.3576, 343.5684, 302.8739>, <79.5822, 343.636, 303.2941> }
					triangle { <79.8027, 345.1283, 302.4523>, <78.1429, 345.6261, 300.8013>, <78.3576, 343.5684, 302.8739> }
					triangle { <81.476, 346.0929, 302.3594>, <78.04071, 345.6563, 300.1964>, <79.8027, 345.1283, 302.4523> }
					triangle { <81.07386, 344.7087, 302.8971>, <79.8027, 345.1283, 302.4523>, <79.5822, 343.636, 303.2941> }
					triangle { <81.476, 346.0929, 302.3594>, <79.8027, 345.1283, 302.4523>, <81.07386, 344.7087, 302.8971> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <104.4537, 328.7149, 265.4014>, <103.5128, 329.6668, 266.3949>, 0.189 }
			cylinder { <103.5128, 329.6668, 266.3949>, <102.6206, 330.7465, 267.2986>, 0.189 }
			cylinder { <102.6206, 330.7465, 267.2986>, <101.7857, 331.9435, 268.1039>, 0.189 }
			material { txgilia_inflor }}
		union { // inflor. internode
			cylinder { <101.7857, 331.9435, 268.1039>, <101.0056, 333.3229, 268.6207>, 0.189 }
			cylinder { <101.0056, 333.3229, 268.6207>, <100.0904, 334.6109, 269.1516>, 0.189 }
			cylinder { <100.0904, 334.6109, 269.1516>, <99.04914, 335.7952, 269.6917>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <99.04914, 335.7952, 269.6917>, <97.272, 337.3533, 270.5077>, 0.189 }
				cylinder { <97.272, 337.3533, 270.5077>, <95.3065, 338.6695, 271.3174>, 0.189 }
				cylinder { <95.3065, 338.6695, 271.3174>, <93.1821, 339.7241, 272.1087>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <93.1821, 339.7241, 272.1087>, <83.8175, 343.7036, 277.1125>, <84.5492, 345.052, 276.9981> }
					triangle { <93.1821, 339.7241, 272.1087>, <87.6433, 341.2213, 274.5716>, <83.8175, 343.7036, 277.1125> }
					triangle { <84.5492, 345.052, 276.9981>, <87.905, 343.3621, 273.8936>, <93.1821, 339.7241, 272.1087> }
					triangle { <87.6433, 341.2213, 274.5716>, <84.1198, 343.0578, 278.6305>, <83.8175, 343.7036, 277.1125> }
					triangle { <84.1198, 343.0578, 278.6305>, <84.6856, 344.179, 281.0737>, <83.8175, 343.7036, 277.1125> }
					triangle { <84.5492, 345.052, 276.9981>, <84.8895, 346.6505, 277.9267>, <84.5322, 346.2443, 275.9494> }
					triangle { <84.5322, 346.2443, 275.9494>, <87.905, 343.3621, 273.8936>, <84.5492, 345.052, 276.9981> }
					triangle { <84.6856, 344.179, 281.0737>, <84.3923, 344.5463, 280.6783>, <84.2042, 345.1262, 278.3637> }
					triangle { <84.3923, 344.5463, 280.6783>, <86.4065, 345.8945, 281.8676>, <84.9319, 347.0004, 279.1743> }
					triangle { <84.2042, 345.1262, 278.3637>, <84.9319, 347.0004, 279.1743>, <84.8895, 346.6505, 277.9267> }
					triangle { <84.2042, 345.1262, 278.3637>, <84.3923, 344.5463, 280.6783>, <84.9319, 347.0004, 279.1743> }
					triangle { <83.8175, 343.7036, 277.1125>, <84.6856, 344.179, 281.0737>, <84.2042, 345.1262, 278.3637> }
					triangle { <84.5492, 345.052, 276.9981>, <84.2042, 345.1262, 278.3637>, <84.8895, 346.6505, 277.9267> }
					triangle { <83.8175, 343.7036, 277.1125>, <84.2042, 345.1262, 278.3637>, <84.5492, 345.052, 276.9981> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <93.1821, 339.7241, 272.1087>, <84.2411, 345.0777, 276.5772>, <84.07162, 345.6074, 275.1427> }
					triangle { <93.1821, 339.7241, 272.1087>, <88.2793, 342.0818, 275.173>, <84.2411, 345.0777, 276.5772> }
					triangle { <84.07162, 345.6074, 275.1427>, <87.1894, 342.394, 273.217>, <93.1821, 339.7241, 272.1087> }
					triangle { <88.2793, 342.0818, 275.173>, <85.1127, 346.2034, 277.4637>, <84.2411, 345.0777, 276.5772> }
					triangle { <85.1127, 346.2034, 277.4637>, <85.386, 348.9314, 277.2909>, <84.2411, 345.0777, 276.5772> }
					triangle { <84.07162, 345.6074, 275.1427>, <83.6295, 347.1487, 274.1619>, <83.2133, 345.1609, 273.8836> }
					triangle { <83.2133, 345.1609, 273.8836>, <87.1894, 342.394, 273.217>, <84.07162, 345.6074, 275.1427> }
					triangle { <85.386, 348.9314, 277.2909>, <84.8742, 348.7027, 277.0397>, <83.9912, 346.8405, 275.8228> }
					triangle { <84.8742, 348.7027, 277.0397>, <85.9799, 350.5239, 275.3814>, <83.6914, 348.426, 274.3751> }
					triangle { <83.9912, 346.8405, 275.8228>, <83.6914, 348.426, 274.3751>, <83.6295, 347.1487, 274.1619> }
					triangle { <83.9912, 346.8405, 275.8228>, <84.8742, 348.7027, 277.0397>, <83.6914, 348.426, 274.3751> }
					triangle { <84.2411, 345.0777, 276.5772>, <85.386, 348.9314, 277.2909>, <83.9912, 346.8405, 275.8228> }
					triangle { <84.07162, 345.6074, 275.1427>, <83.9912, 346.8405, 275.8228>, <83.6295, 347.1487, 274.1619> }
					triangle { <84.2411, 345.0777, 276.5772>, <83.9912, 346.8405, 275.8228>, <84.07162, 345.6074, 275.1427> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <93.1821, 339.7241, 272.1087>, <83.732, 345.2106, 275.1359>, <83.04755, 344.1234, 274.2895> }
					triangle { <93.1821, 339.7241, 272.1087>, <88.4282, 343.0438, 274.4251>, <83.732, 345.2106, 275.1359> }
					triangle { <83.04755, 344.1234, 274.2895>, <87.02207, 341.3119, 274.0584>, <93.1821, 339.7241, 272.1087> }
					triangle { <88.4282, 343.0438, 274.4251>, <83.9766, 346.5627, 274.174>, <83.732, 345.2106, 275.1359> }
					triangle { <83.9766, 346.5627, 274.174>, <82.6609, 347.5789, 271.987>, <83.732, 345.2106, 275.1359> }
					triangle { <83.04755, 344.1234, 274.2895>, <81.6622, 343.847, 273.0495>, <82.3726, 342.7221, 274.609> }
					triangle { <82.3726, 342.7221, 274.609>, <87.02207, 341.3119, 274.0584>, <83.04755, 344.1234, 274.2895> }
					triangle { <82.6609, 347.5789, 271.987>, <82.326, 347.2102, 272.3465>, <82.4208, 345.249, 273.7152> }
					triangle { <82.326, 347.2102, 272.3465>, <81.9268, 346.5784, 269.7521>, <81.0444, 344.5825, 272.1788> }
					triangle { <82.4208, 345.249, 273.7152>, <81.0444, 344.5825, 272.1788>, <81.6622, 343.847, 273.0495> }
					triangle { <82.4208, 345.249, 273.7152>, <82.326, 347.2102, 272.3465>, <81.0444, 344.5825, 272.1788> }
					triangle { <83.732, 345.2106, 275.1359>, <82.6609, 347.5789, 271.987>, <82.4208, 345.249, 273.7152> }
					triangle { <83.04755, 344.1234, 274.2895>, <82.4208, 345.249, 273.7152>, <81.6622, 343.847, 273.0495> }
					triangle { <83.732, 345.2106, 275.1359>, <82.4208, 345.249, 273.7152>, <83.04755, 344.1234, 274.2895> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <93.1821, 339.7241, 272.1087>, <82.989, 343.9199, 274.7669>, <82.8827, 342.6371, 275.6096> }
					triangle { <93.1821, 339.7241, 272.1087>, <87.8855, 342.7867, 273.3546>, <82.989, 343.9199, 274.7669> }
					triangle { <82.8827, 342.6371, 275.6096>, <87.6326, 341.601, 275.2628>, <93.1821, 339.7241, 272.1087> }
					triangle { <87.8855, 342.7867, 273.3546>, <82.2708, 343.6424, 273.2769>, <82.989, 343.9199, 274.7669> }
					triangle { <82.2708, 343.6424, 273.2769>, <80.2508, 341.978, 272.4424>, <82.989, 343.9199, 274.7669> }
					triangle { <82.8827, 342.6371, 275.6096>, <81.6879, 341.2774, 276.1164>, <83.164, 342.2755, 277.1299> }
					triangle { <83.164, 342.2755, 277.1299>, <87.6326, 341.601, 275.2628>, <82.8827, 342.6371, 275.6096> }
					triangle { <80.2508, 341.978, 272.4424>, <80.2455, 342.1174, 273.0407>, <81.6486, 342.5362, 274.9339> }
					triangle { <80.2455, 342.1174, 273.0407>, <79.8106, 339.4738, 272.7067>, <80.6242, 340.7456, 275.6001> }
					triangle { <81.6486, 342.5362, 274.9339>, <80.6242, 340.7456, 275.6001>, <81.6879, 341.2774, 276.1164> }
					triangle { <81.6486, 342.5362, 274.9339>, <80.2455, 342.1174, 273.0407>, <80.6242, 340.7456, 275.6001> }
					triangle { <82.989, 343.9199, 274.7669>, <80.2508, 341.978, 272.4424>, <81.6486, 342.5362, 274.9339> }
					triangle { <82.8827, 342.6371, 275.6096>, <81.6486, 342.5362, 274.9339>, <81.6879, 341.2774, 276.1164> }
					triangle { <82.989, 343.9199, 274.7669>, <81.6486, 342.5362, 274.9339>, <82.8827, 342.6371, 275.6096> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <93.1821, 339.7241, 272.1087>, <83.04268, 342.9744, 276.0069>, <83.8248, 343.2197, 277.3088> }
					triangle { <93.1821, 339.7241, 272.1087>, <87.3931, 341.6434, 273.4464>, <83.04268, 342.9744, 276.0069> }
					triangle { <83.8248, 343.2197, 277.3088>, <88.1865, 342.8873, 275.1594>, <93.1821, 339.7241, 272.1087> }
					triangle { <87.3931, 341.6434, 273.4464>, <82.3607, 341.4435, 276.0727>, <83.04268, 342.9744, 276.0069> }
					triangle { <82.3607, 341.4435, 276.0727>, <81.5211, 339.845, 278.1431>, <83.04268, 342.9744, 276.0069> }
					triangle { <83.8248, 343.2197, 277.3088>, <83.7126, 343.0363, 279.1762>, <84.5188, 344.4852, 277.9708> }
					triangle { <84.5188, 344.4852, 277.9708>, <88.1865, 342.8873, 275.1594>, <83.8248, 343.2197, 277.3088> }
					triangle { <81.5211, 339.845, 278.1431>, <81.5417, 340.4462, 278.2677>, <82.7674, 342.4592, 277.8503> }
					triangle { <81.5417, 340.4462, 278.2677>, <82.621, 339.0447, 280.3075>, <83.06316, 342.2625, 279.9888> }
					triangle { <82.7674, 342.4592, 277.8503>, <83.06316, 342.2625, 279.9888>, <83.7126, 343.0363, 279.1762> }
					triangle { <82.7674, 342.4592, 277.8503>, <81.5417, 340.4462, 278.2677>, <83.06316, 342.2625, 279.9888> }
					triangle { <83.04268, 342.9744, 276.0069>, <81.5211, 339.845, 278.1431>, <82.7674, 342.4592, 277.8503> }
					triangle { <83.8248, 343.2197, 277.3088>, <82.7674, 342.4592, 277.8503>, <83.7126, 343.0363, 279.1762> }
					triangle { <83.04268, 342.9744, 276.0069>, <82.7674, 342.4592, 277.8503>, <83.8248, 343.2197, 277.3088> }
					material { txgilia_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <101.7857, 331.9435, 268.1039>, <100.9321, 332.9068, 269.163>, 0.189 }
			cylinder { <100.9321, 332.9068, 269.163>, <100.2045, 333.9742, 270.2165>, 0.189 }
			cylinder { <100.2045, 333.9742, 270.2165>, <99.61, 335.1353, 271.2542>, 0.189 }
			material { txgilia_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <99.61, 335.1353, 271.2542>, <98.9797, 337.029, 272.7602>, 0.189 }
				cylinder { <98.9797, 337.029, 272.7602>, <98.6203, 339.0463, 274.1929>, 0.189 }
				cylinder { <98.6203, 339.0463, 274.1929>, <98.5372, 341.1569, 275.5308>, 0.189 }
				material { txgilia_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <98.5372, 341.1569, 275.5308>, <97.9189, 351.4911, 280.1558>, <96.6396, 350.9278, 280.7984> }
					triangle { <98.5372, 341.1569, 275.5308>, <99.02802, 346.8976, 277.9369>, <97.9189, 351.4911, 280.1558> }
					triangle { <96.6396, 350.9278, 280.7984>, <97.6856, 346.3063, 279.6572>, <98.5372, 341.1569, 275.5308> }
					triangle { <99.02802, 346.8976, 277.9369>, <97.4982, 352.3066, 278.752>, <97.9189, 351.4911, 280.1558> }
					triangle { <97.4982, 352.3066, 278.752>, <95.2273, 353.6302, 277.9534>, <97.9189, 351.4911, 280.1558> }
					triangle { <96.6396, 350.9278, 280.7984>, <94.8707, 351.3777, 281.2478>, <96.2979, 350.25, 282.1931> }
					triangle { <96.2979, 350.25, 282.1931>, <97.6856, 346.3063, 279.6572>, <96.6396, 350.9278, 280.7984> }
					triangle { <95.2273, 353.6302, 277.9534>, <95.3006, 353.5784, 278.5611>, <96.09734, 352.126, 280.2886> }
					triangle { <95.3006, 353.5784, 278.5611>, <92.7515, 352.997, 277.8876>, <93.9941, 352.2239, 280.8047> }
					triangle { <96.09734, 352.126, 280.2886>, <93.9941, 352.2239, 280.8047>, <94.8707, 351.3777, 281.2478> }
					triangle { <96.09734, 352.126, 280.2886>, <95.3006, 353.5784, 278.5611>, <93.9941, 352.2239, 280.8047> }
					triangle { <97.9189, 351.4911, 280.1558>, <95.2273, 353.6302, 277.9534>, <96.09734, 352.126, 280.2886> }
					triangle { <96.6396, 350.9278, 280.7984>, <96.09734, 352.126, 280.2886>, <94.8707, 351.3777, 281.2478> }
					triangle { <97.9189, 351.4911, 280.1558>, <96.09734, 352.126, 280.2886>, <96.6396, 350.9278, 280.7984> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <98.5372, 341.1569, 275.5308>, <96.9783, 350.8582, 281.1898>, <97.376, 350.0015, 282.4042> }
					triangle { <98.5372, 341.1569, 275.5308>, <97.8009, 346.8844, 277.9055>, <96.9783, 350.8582, 281.1898> }
					triangle { <97.376, 350.0015, 282.4042>, <99.06606, 346.3211, 279.6925>, <98.5372, 341.1569, 275.5308> }
					triangle { <97.8009, 346.8844, 277.9055>, <95.3052, 350.8818, 281.0763>, <96.9783, 350.8582, 281.1898> }
					triangle { <95.3052, 350.8818, 281.0763>, <93.2901, 350.6511, 282.9292>, <96.9783, 350.8582, 281.1898> }
					triangle { <97.376, 350.0015, 282.4042>, <96.962, 349.6875, 284.2107>, <98.7341, 349.7312, 283.1811> }
					triangle { <98.7341, 349.7312, 283.1811>, <99.06606, 346.3211, 279.6925>, <97.376, 350.0015, 282.4042> }
					triangle { <93.2901, 350.6511, 282.9292>, <93.8312, 350.8379, 283.1521>, <96.1998, 350.5701, 282.9362> }
					triangle { <93.8312, 350.8379, 283.1521>, <92.7726, 348.9491, 284.765>, <95.9091, 349.8311, 284.9533> }
					triangle { <96.1998, 350.5701, 282.9362>, <95.9091, 349.8311, 284.9533>, <96.962, 349.6875, 284.2107> }
					triangle { <96.1998, 350.5701, 282.9362>, <93.8312, 350.8379, 283.1521>, <95.9091, 349.8311, 284.9533> }
					triangle { <96.9783, 350.8582, 281.1898>, <93.2901, 350.6511, 282.9292>, <96.1998, 350.5701, 282.9362> }
					triangle { <97.376, 350.0015, 282.4042>, <96.1998, 350.5701, 282.9362>, <96.962, 349.6875, 284.2107> }
					triangle { <96.9783, 350.8582, 281.1898>, <96.1998, 350.5701, 282.9362>, <97.376, 350.0015, 282.4042> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <98.5372, 341.1569, 275.5308>, <97.8339, 350.2285, 282.2969>, <99.3667, 350.0995, 282.325> }
					triangle { <98.5372, 341.1569, 275.5308>, <97.3967, 346.2887, 278.8997>, <97.8339, 350.2285, 282.2969> }
					triangle { <99.3667, 350.0995, 282.325>, <99.5208, 346.9913, 278.574>, <98.5372, 341.1569, 275.5308> }
					triangle { <97.3967, 346.2887, 278.8997>, <97.2049, 349.4277, 283.6296>, <97.8339, 350.2285, 282.2969> }
					triangle { <97.2049, 349.4277, 283.6296>, <98.1877, 348.8887, 286.1376>, <97.8339, 350.2285, 282.2969> }
					triangle { <99.3667, 350.0995, 282.325>, <100.8559, 350.2269, 283.4649>, <100.5565, 350.7626, 281.509> }
					triangle { <100.5565, 350.7626, 281.509>, <99.5208, 346.9913, 278.574>, <99.3667, 350.0995, 282.325> }
					triangle { <98.1877, 348.8887, 286.1376>, <98.4458, 349.3675, 285.8521>, <99.1471, 350.1873, 283.7156> }
					triangle { <98.4458, 349.3675, 285.8521>, <100.3548, 347.8346, 286.9904>, <101.056, 350.0904, 284.7385> }
					triangle { <99.1471, 350.1873, 283.7156>, <101.056, 350.0904, 284.7385>, <100.8559, 350.2269, 283.4649> }
					triangle { <99.1471, 350.1873, 283.7156>, <98.4458, 349.3675, 285.8521>, <101.056, 350.0904, 284.7385> }
					triangle { <97.8339, 350.2285, 282.2969>, <98.1877, 348.8887, 286.1376>, <99.1471, 350.1873, 283.7156> }
					triangle { <99.3667, 350.0995, 282.325>, <99.1471, 350.1873, 283.7156>, <100.8559, 350.2269, 283.4649> }
					triangle { <97.8339, 350.2285, 282.2969>, <99.1471, 350.1873, 283.7156>, <99.3667, 350.0995, 282.325> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <98.5372, 341.1569, 275.5308>, <99.3112, 350.4663, 281.9576>, <99.8792, 351.0872, 280.6696> }
					triangle { <98.5372, 341.1569, 275.5308>, <98.3702, 345.9282, 279.5548>, <99.3112, 350.4663, 281.9576> }
					triangle { <99.8792, 351.0872, 280.6696>, <98.4257, 347.3969, 277.837>, <98.5372, 341.1569, 275.5308> }
					triangle { <98.3702, 345.9282, 279.5548>, <100.5898, 349.9404, 282.9071>, <99.3112, 350.4663, 281.9576> }
					triangle { <100.5898, 349.9404, 282.9071>, <103.1974, 350.7621, 283.1747>, <99.3112, 350.4663, 281.9576> }
					triangle { <99.8792, 351.0872, 280.6696>, <101.2075, 352.2556, 280.0341>, <99.2635, 351.9284, 279.4719> }
					triangle { <99.2635, 351.9284, 279.4719>, <98.4257, 347.3969, 277.837>, <99.8792, 351.0872, 280.6696> }
					triangle { <103.1974, 350.7621, 283.1747>, <102.8103, 351.1855, 282.9551>, <100.8937, 351.503, 281.5571> }
					triangle { <102.8103, 351.1855, 282.9551>, <105.0905, 351.1834, 281.5093>, <102.3699, 352.6458, 280.4552> }
					triangle { <100.8937, 351.503, 281.5571>, <102.3699, 352.6458, 280.4552>, <101.2075, 352.2556, 280.0341> }
					triangle { <100.8937, 351.503, 281.5571>, <102.8103, 351.1855, 282.9551>, <102.3699, 352.6458, 280.4552> }
					triangle { <99.3112, 350.4663, 281.9576>, <103.1974, 350.7621, 283.1747>, <100.8937, 351.503, 281.5571> }
					triangle { <99.8792, 351.0872, 280.6696>, <100.8937, 351.503, 281.5571>, <101.2075, 352.2556, 280.0341> }
					triangle { <99.3112, 350.4663, 281.9576>, <100.8937, 351.503, 281.5571>, <99.8792, 351.0872, 280.6696> }
					material { txgilia_flower }}
				mesh { // flower petal
					triangle { <98.5372, 341.1569, 275.5308>, <99.3646, 351.2585, 280.6144>, <98.1683, 351.6069, 279.7119> }
					triangle { <98.5372, 341.1569, 275.5308>, <99.3935, 346.3102, 278.9508>, <99.3646, 351.2585, 280.6144> }
					triangle { <98.1683, 351.6069, 279.7119>, <97.2743, 346.9671, 278.5165>, <98.5372, 341.1569, 275.5308> }
					triangle { <99.3935, 346.3102, 278.9508>, <100.7739, 351.7465, 279.8471>, <99.3646, 351.2585, 280.6144> }
					triangle { <100.7739, 351.7465, 279.8471>, <101.3402, 353.7368, 278.0403>, <99.3646, 351.2585, 280.6144> }
					triangle { <98.1683, 351.6069, 279.7119>, <97.4525, 352.9775, 278.6432>, <96.5918, 351.6068, 279.9011> }
					triangle { <96.5918, 351.6068, 279.9011>, <97.2743, 346.9671, 278.5165>, <98.1683, 351.6069, 279.7119> }
					triangle { <101.3402, 353.7368, 278.0403>, <100.8372, 353.8273, 278.3809>, <98.9803, 352.7193, 279.4071> }
					triangle { <100.8372, 353.8273, 278.3809>, <100.3205, 354.4221, 275.7986>, <97.9395, 353.9843, 277.9873> }
					triangle { <98.9803, 352.7193, 279.4071>, <97.9395, 353.9843, 277.9873>, <97.4525, 352.9775, 278.6432> }
					triangle { <98.9803, 352.7193, 279.4071>, <100.8372, 353.8273, 278.3809>, <97.9395, 353.9843, 277.9873> }
					triangle { <99.3646, 351.2585, 280.6144>, <101.3402, 353.7368, 278.0403>, <98.9803, 352.7193, 279.4071> }
					triangle { <98.1683, 351.6069, 279.7119>, <98.9803, 352.7193, 279.4071>, <97.4525, 352.9775, 278.6432> }
					triangle { <99.3646, 351.2585, 280.6144>, <98.9803, 352.7193, 279.4071>, <98.1683, 351.6069, 279.7119> }
					material { txgilia_flower }}
				}
			}
		}
	union { // internode
		cylinder { <120.9822, 280.1495, 164.5734>, <123.22, 291.9873, 175.8933>, 0.5 }
		cylinder { <123.22, 291.9873, 175.8933>, <127.9923, 304.1769, 185.9889>, 0.5 }
		cylinder { <127.9923, 304.1769, 185.9889>, <135.1587, 316.3593, 194.563>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <135.1587, 316.3593, 194.563>, <140.2934, 321.5973, 196.9512>, 0.4999 }
			cylinder { <140.2934, 321.5973, 196.9512>, <146.7003, 325.8599, 197.4856>, 0.4999 }
			cylinder { <146.7003, 325.8599, 197.4856>, <153.7329, 328.7169, 196.1123>, 0.4999 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <153.7329, 328.7169, 196.1123>, <156.6946, 329.8655, 195.4752>, 0.4999 }
				cylinder { <156.6946, 329.8655, 195.4752>, <159.6625, 330.9622, 194.7784>, 0.4999 }
				cylinder { <159.6625, 330.9622, 194.7784>, <162.6348, 332.0062, 194.022>, 0.4999 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <162.6348, 332.0062, 194.022>, <163.2455, 332.0871, 193.9861>, 0.03999 }
				cylinder { <163.2455, 332.0871, 193.9861>, <163.8565, 332.0442, 194.061>, 0.03999 }
				cylinder { <163.8565, 332.0442, 194.061>, <164.4236, 331.8807, 194.2411>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <164.4236, 331.8807, 194.2411>, <191.0657, 323.8354, 199.8151>, <190.5531, 321.5049, 200.0184> }
				triangle { <191.0657, 323.8354, 199.8151>, <198.3698, 319.2276, 191.5578>, <190.5531, 321.5049, 200.0184> }
				triangle { <191.0657, 323.8354, 199.8151>, <197.7113, 322.0424, 192.9201>, <198.3698, 319.2276, 191.5578> }
				triangle { <198.3698, 319.2276, 191.5578>, <196.0108, 317.6438, 193.9467>, <190.5531, 321.5049, 200.0184> }
				triangle { <190.5531, 321.5049, 200.0184>, <180.0761, 324.2502, 196.47>, <164.4236, 331.8807, 194.2411> }
				triangle { <164.4236, 331.8807, 194.2411>, <181.5455, 328.1841, 195.727>, <191.0657, 323.8354, 199.8151> }
				triangle { <181.5455, 328.1841, 195.727>, <192.0952, 325.81, 196.4895>, <191.0657, 323.8354, 199.8151> }
				triangle { <192.0952, 325.81, 196.4895>, <197.7113, 322.0424, 192.9201>, <191.0657, 323.8354, 199.8151> }
				triangle { <190.5531, 321.5049, 200.0184>, <196.0108, 317.6438, 193.9467>, <190.7045, 319.0325, 196.8305> }
				triangle { <190.7045, 319.0325, 196.8305>, <180.0761, 324.2502, 196.47>, <190.5531, 321.5049, 200.0184> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <162.6348, 332.0062, 194.022>, <163.2009, 332.205, 193.878>, 0.03999 }
				cylinder { <163.2009, 332.205, 193.878>, <163.767, 332.4039, 193.7339>, 0.03999 }
				cylinder { <163.767, 332.4039, 193.7339>, <164.3331, 332.6027, 193.5899>, 0.03999 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <164.3331, 332.6027, 193.5899>, <189.7643, 341.1076, 184.2882>, <190.7847, 338.9457, 184.4321> }
				triangle { <189.7643, 341.1076, 184.2882>, <193.4345, 339.6302, 173.0138>, <190.7847, 338.9457, 184.4321> }
				triangle { <189.7643, 341.1076, 184.2882>, <192.0793, 341.8633, 174.8548>, <193.4345, 339.6302, 173.0138> }
				triangle { <193.4345, 339.6302, 173.0138>, <193.8027, 337.5143, 176.0415>, <190.7847, 338.9457, 184.4321> }
				triangle { <190.7847, 338.9457, 184.4321>, <180.3731, 335.0025, 186.8703>, <164.3331, 332.6027, 193.5899> }
				triangle { <164.3331, 332.6027, 193.5899>, <178.8789, 338.8974, 185.9852>, <189.7643, 341.1076, 184.2882> }
				triangle { <178.8789, 338.8974, 185.9852>, <187.8218, 342.6676, 181.1559>, <189.7643, 341.1076, 184.2882> }
				triangle { <187.8218, 342.6676, 181.1559>, <192.0793, 341.8633, 174.8548>, <189.7643, 341.1076, 184.2882> }
				triangle { <190.7847, 338.9457, 184.4321>, <193.8027, 337.5143, 176.0415>, <190.7403, 336.3872, 181.3096> }
				triangle { <190.7403, 336.3872, 181.3096>, <180.3731, 335.0025, 186.8703>, <190.7847, 338.9457, 184.4321> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <135.1587, 316.3593, 194.563>, <140.1481, 329.6243, 203.0734>, 0.5 }
		cylinder { <140.1481, 329.6243, 203.0734>, <142.8523, 343.6848, 211.3361>, 0.5 }
		cylinder { <142.8523, 343.6848, 211.3361>, <143.213, 358.2364, 219.172>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <143.213, 358.2364, 219.172>, <141.2261, 364.4105, 221.8689>, 0.4552 }
			cylinder { <141.2261, 364.4105, 221.8689>, <137.2997, 369.9524, 223.6609>, 0.4552 }
			cylinder { <137.2997, 369.9524, 223.6609>, <131.8299, 374.3026, 224.3671>, 0.4552 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <131.8299, 374.3026, 224.3671>, <129.4522, 376.0348, 224.5896>, 0.4552 }
				cylinder { <129.4522, 376.0348, 224.5896>, <126.9997, 377.6678, 224.7376>, 0.4552 }
				cylinder { <126.9997, 377.6678, 224.7376>, <124.4783, 379.1979, 224.8106>, 0.4552 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <124.4783, 379.1979, 224.8106>, <124.0853, 379.5118, 224.7166>, 0.03316 }
				cylinder { <124.0853, 379.5118, 224.7166>, <123.7601, 379.8553, 224.5216>, 0.03316 }
				cylinder { <123.7601, 379.8553, 224.5216>, <123.5223, 380.208, 224.2373>, 0.03316 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <123.5223, 380.208, 224.2373>, <109.3523, 395.6554, 209.1184>, <110.1101, 394.8464, 207.2402> }
				triangle { <109.3523, 395.6554, 209.1184>, <100.0775, 392.4881, 204.3935>, <110.1101, 394.8464, 207.2402> }
				triangle { <109.3523, 395.6554, 209.1184>, <100.9784, 393.8961, 206.7754>, <100.0775, 392.4881, 204.3935> }
				triangle { <100.0775, 392.4881, 204.3935>, <103.2882, 392.4252, 203.338>, <110.1101, 394.8464, 207.2402> }
				triangle { <110.1101, 394.8464, 207.2402>, <114.9458, 387.7208, 213.0323>, <123.5223, 380.208, 224.2373> }
				triangle { <123.5223, 380.208, 224.2373>, <113.0173, 389.1292, 216.0946>, <109.3523, 395.6554, 209.1184> }
				triangle { <113.0173, 389.1292, 216.0946>, <106.4676, 394.4931, 211.0182>, <109.3523, 395.6554, 209.1184> }
				triangle { <106.4676, 394.4931, 211.0182>, <100.9784, 393.8961, 206.7754>, <109.3523, 395.6554, 209.1184> }
				triangle { <110.1101, 394.8464, 207.2402>, <103.2882, 392.4252, 203.338>, <108.4568, 392.0218, 205.5663> }
				triangle { <108.4568, 392.0218, 205.5663>, <114.9458, 387.7208, 213.0323>, <110.1101, 394.8464, 207.2402> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <124.4783, 379.1979, 224.8106>, <124.041, 379.4633, 224.8233>, 0.03316 }
				cylinder { <124.041, 379.4633, 224.8233>, <123.6037, 379.7286, 224.836>, 0.03316 }
				cylinder { <123.6037, 379.7286, 224.836>, <123.1664, 379.994, 224.8486>, 0.03316 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <123.1664, 379.994, 224.8486>, <99.5727, 390.5451, 224.8416>, <99.3589, 390.5549, 222.6713> }
				triangle { <99.5727, 390.5451, 224.8416>, <90.449, 384.7318, 223.6831>, <99.3589, 390.5549, 222.6713> }
				triangle { <99.5727, 390.5451, 224.8416>, <92.0991, 385.8613, 225.7973>, <90.449, 384.7318, 223.6831> }
				triangle { <90.449, 384.7318, 223.6831>, <92.4384, 386.2875, 221.4364>, <99.3589, 390.5549, 222.6713> }
				triangle { <99.3589, 390.5549, 222.6713>, <108.244, 385.1968, 222.4402>, <123.1664, 379.994, 224.8486> }
				triangle { <123.1664, 379.994, 224.8486>, <108.0185, 384.959, 226.3096>, <99.5727, 390.5451, 224.8416> }
				triangle { <108.0185, 384.959, 226.3096>, <98.6263, 387.8806, 227.141>, <99.5727, 390.5451, 224.8416> }
				triangle { <98.6263, 387.8806, 227.141>, <92.0991, 385.8613, 225.7973>, <99.5727, 390.5451, 224.8416> }
				triangle { <99.3589, 390.5549, 222.6713>, <92.4384, 386.2875, 221.4364>, <97.8708, 387.7098, 220.881> }
				triangle { <97.8708, 387.7098, 220.881>, <108.244, 385.1968, 222.4402>, <99.3589, 390.5549, 222.6713> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <143.213, 358.2364, 219.172>, <145.9797, 370.4669, 229.9444>, 0.5 }
		cylinder { <145.9797, 370.4669, 229.9444>, <150.9518, 379.4901, 242.8727>, 0.5 }
		cylinder { <150.9518, 379.4901, 242.8727>, <157.7693, 384.6525, 257.0203>, 0.5 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <157.7693, 384.6525, 257.0203>, <159.7765, 384.5924, 260.4012>, 0.2548 }
			cylinder { <159.7765, 384.5924, 260.4012>, <161.9344, 383.2513, 263.4026>, 0.2548 }
			cylinder { <161.9344, 383.2513, 263.4026>, <163.9908, 380.786, 265.6735>, 0.2548 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <163.9908, 380.786, 265.6735>, <164.8475, 379.7209, 266.6005>, 0.2548 }
				cylinder { <164.8475, 379.7209, 266.6005>, <165.6966, 378.6268, 267.5003>, 0.2548 }
				cylinder { <165.6966, 378.6268, 267.5003>, <166.5376, 377.5043, 268.3723>, 0.2548 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <166.5376, 377.5043, 268.3723>, <166.5805, 377.3889, 268.475>, 0.01039 }
				cylinder { <166.5805, 377.3889, 268.475>, <166.5817, 377.2752, 268.5881>, 0.01039 }
				cylinder { <166.5817, 377.2752, 268.5881>, <166.5409, 377.1717, 268.7036>, 0.01039 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <166.5409, 377.1717, 268.7036>, <163.7187, 367.4198, 279.013>, <162.621, 367.1107, 278.577> }
				triangle { <163.7187, 367.4198, 279.013>, <164.4608, 361.4257, 278.2256>, <162.621, 367.1107, 278.577> }
				triangle { <163.7187, 367.4198, 279.013>, <165.2668, 362.7041, 278.8339>, <164.4608, 361.4257, 278.2256> }
				triangle { <164.4608, 361.4257, 278.2256>, <162.9698, 362.5612, 277.9642>, <162.621, 367.1107, 278.577> }
				triangle { <162.621, 367.1107, 278.577>, <163.9041, 370.4653, 274.0102>, <166.5409, 377.1717, 268.7036> }
				triangle { <166.5409, 377.1717, 268.7036>, <165.9088, 370.6606, 274.8284>, <163.7187, 367.4198, 279.013> }
				triangle { <165.9088, 370.6606, 274.8284>, <165.5177, 366.5829, 278.5375>, <163.7187, 367.4198, 279.013> }
				triangle { <165.5177, 366.5829, 278.5375>, <165.2668, 362.7041, 278.8339>, <163.7187, 367.4198, 279.013> }
				triangle { <162.621, 367.1107, 278.577>, <162.9698, 362.5612, 277.9642>, <162.3986, 365.5782, 277.2216> }
				triangle { <162.3986, 365.5782, 277.2216>, <163.9041, 370.4653, 274.0102>, <162.621, 367.1107, 278.577> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <166.5376, 377.5043, 268.3723>, <166.6192, 377.3954, 268.457>, 0.01039 }
				cylinder { <166.6192, 377.3954, 268.457>, <166.7009, 377.2864, 268.5417>, 0.01039 }
				cylinder { <166.7009, 377.2864, 268.5417>, <166.7825, 377.1774, 268.6263>, 0.01039 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <166.7825, 377.1774, 268.6263>, <174.8792, 367.4642, 275.658>, <174.0116, 366.6064, 275.7021> }
				triangle { <174.8792, 367.4642, 275.658>, <177.7126, 362.8455, 272.8761>, <174.0116, 366.6064, 275.7021> }
				triangle { <174.8792, 367.4642, 275.658>, <178.0259, 364.3566, 273.3981>, <177.7126, 362.8455, 272.8761> }
				triangle { <177.7126, 362.8455, 272.8761>, <176.0032, 362.9838, 273.6758>, <174.0116, 366.6064, 275.7021> }
				triangle { <174.0116, 366.6064, 275.7021>, <170.8896, 370.118, 272.285>, <166.7825, 377.1774, 268.6263> }
				triangle { <166.7825, 377.1774, 268.6263>, <172.6548, 371.3752, 272.1132>, <174.8792, 367.4642, 275.658> }
				triangle { <172.6548, 371.3752, 272.1132>, <176.2667, 367.7442, 274.1887>, <174.8792, 367.4642, 275.658> }
				triangle { <176.2667, 367.7442, 274.1887>, <178.0259, 364.3566, 273.3981>, <174.8792, 367.4642, 275.658> }
				triangle { <174.0116, 366.6064, 275.7021>, <176.0032, 362.9838, 273.6758>, <173.8174, 365.2007, 274.2115> }
				triangle { <173.8174, 365.2007, 274.2115>, <170.8896, 370.118, 272.285>, <174.0116, 366.6064, 275.7021> }
				material { txgilia_leaf }}
			}
		}
	union { // internode
		cylinder { <157.7693, 384.6525, 257.0203>, <164.7121, 391.9398, 267.9832>, 0.4501 }
		cylinder { <164.7121, 391.9398, 267.9832>, <172.1227, 401.5129, 276.6395>, 0.4501 }
		cylinder { <172.1227, 401.5129, 276.6395>, <179.641, 412.9065, 282.5686>, 0.4501 }
		material { txgilia_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <179.641, 412.9065, 282.5686>, <180.6373, 414.7809, 282.7357>, 0.138 }
			cylinder { <180.6373, 414.7809, 282.7357>, <181.4377, 416.6804, 282.202>, 0.138 }
			cylinder { <181.4377, 416.6804, 282.202>, <181.9486, 418.383, 281.0299>, 0.138 }
			material { txgilia_petiole }}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <181.9486, 418.383, 281.0299>, <182.1534, 419.0888, 280.5204>, 0.138 }
				cylinder { <182.1534, 419.0888, 280.5204>, <182.3482, 419.7849, 279.9938>, 0.138 }
				cylinder { <182.3482, 419.7849, 279.9938>, <182.533, 420.4709, 279.4507>, 0.138 }
				material { txgilia_petiole }}
			union { // compound leaf petiolet
				cylinder { <182.533, 420.4709, 279.4507>, <182.5523, 420.5009, 279.42>, 0.003047 }
				cylinder { <182.5523, 420.5009, 279.42>, <182.5799, 420.523, 279.3891>, 0.003047 }
				cylinder { <182.5799, 420.523, 279.3891>, <182.6144, 420.536, 279.3599>, 0.003047 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <182.6144, 420.536, 279.3599>, <188.0392, 423.0693, 274.3069>, <188.1783, 422.4711, 274.0625> }
				triangle { <188.0392, 423.0693, 274.3069>, <187.4324, 423.5603, 271.1025>, <188.1783, 422.4711, 274.0625> }
				triangle { <188.0392, 423.0693, 274.3069>, <187.464, 424.0168, 271.8567>, <187.4324, 423.5603, 271.1025> }
				triangle { <187.4324, 423.5603, 271.1025>, <187.7765, 422.7441, 271.6175>, <188.1783, 422.4711, 274.0625> }
				triangle { <188.1783, 422.4711, 274.0625>, <185.7607, 421.4281, 275.7841>, <182.6144, 420.536, 279.3599> }
				triangle { <182.6144, 420.536, 279.3599>, <185.5146, 422.552, 276.0328>, <188.0392, 423.0693, 274.3069> }
				triangle { <185.5146, 422.552, 276.0328>, <187.273, 423.7783, 273.9453>, <188.0392, 423.0693, 274.3069> }
				triangle { <187.273, 423.7783, 273.9453>, <187.464, 424.0168, 271.8567>, <188.0392, 423.0693, 274.3069> }
				triangle { <188.1783, 422.4711, 274.0625>, <187.7765, 422.7441, 271.6175>, <187.6333, 422.0634, 273.1802> }
				triangle { <187.6333, 422.0634, 273.1802>, <185.7607, 421.4281, 275.7841>, <188.1783, 422.4711, 274.0625> }
				material { txgilia_leaf }}
			union { // compound leaf petiolet
				cylinder { <182.533, 420.4709, 279.4507>, <182.5427, 420.507, 279.4221>, 0.003047 }
				cylinder { <182.5427, 420.507, 279.4221>, <182.5524, 420.543, 279.3935>, 0.003047 }
				cylinder { <182.5524, 420.543, 279.3935>, <182.5621, 420.5791, 279.365>, 0.003047 }
				material { txgilia_petiole }}
			mesh { // leaf
				triangle { <182.5621, 420.5791, 279.365>, <183.6924, 426.7487, 274.6707>, <183.9722, 426.4025, 274.182> }
				triangle { <183.6924, 426.7487, 274.6707>, <181.6876, 427.4997, 272.1619>, <183.9722, 426.4025, 274.182> }
				triangle { <183.6924, 426.7487, 274.6707>, <181.8143, 427.7172, 273.0073>, <181.6876, 427.4997, 272.1619> }
				triangle { <181.6876, 427.4997, 272.1619>, <182.5368, 426.9286, 272.213>, <183.9722, 426.4025, 274.182> }
				triangle { <183.9722, 426.4025, 274.182>, <183.2145, 423.8374, 275.838>, <182.5621, 420.5791, 279.365> }
				triangle { <182.5621, 420.5791, 279.365>, <182.6156, 424.5424, 276.5659>, <183.6924, 426.7487, 274.6707> }
				triangle { <182.6156, 424.5424, 276.5659>, <182.6175, 426.9637, 274.808>, <183.6924, 426.7487, 274.6707> }
				triangle { <182.6175, 426.9637, 274.808>, <181.8143, 427.7172, 273.0073>, <183.6924, 426.7487, 274.6707> }
				triangle { <183.9722, 426.4025, 274.182>, <182.5368, 426.9286, 272.213>, <183.3628, 425.9638, 273.3587> }
				triangle { <183.3628, 425.9638, 273.3587>, <183.2145, 423.8374, 275.838>, <183.9722, 426.4025, 274.182> }
				material { txgilia_leaf }}
			}
		}
} // end gilia

