// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare txphlox_inter = material { texture { pigment { color rgb <0.19, 0.58, 0.19> } 
finish { ambient 0.1  diffuse 0.42 roughness 0.001 } } }   

#declare txphlox_leaf = material { texture { pigment { color rgb <0.19, 0.83, 0.19> } 
finish { ambient 0.1  diffuse 0.42 roughness 0.001 } } }   

#declare txphlox_inflor = material { texture { pigment { color rgb <0.19, 0.54, 0.19> } 
finish { ambient 0.1  diffuse 0.42 roughness 0.001 } } }   

#declare txphlox_flower = material { texture { pigment { color rgb <0.85, 0.44, 0.94> }
finish { ambient 0.2  diffuse 0.6 roughness 0.001 } } }   
   
#declare txphlox_pedicel = material { texture { pigment { color rgb <0.19, 0.55, 0.19> }
finish { ambient 0.1  diffuse 0.42 roughness 0.001 } } }   

#declare txphlox_petiole = material { texture { pigment { color rgb <0.19, 0.6, 0.19> }
finish { ambient 0.1  diffuse 0.42 roughness 0.001 } } }   
  


#declare phlox = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.1529, 5.06197, 0.196>, 0.2582 }
		cylinder { <0.1529, 5.06197, 0.196>, <0.4586, 10.1056, 0.5876>, 0.2582 }
		cylinder { <0.4586, 10.1056, 0.5876>, <0.9161, 15.1188, 1.1739>, 0.2582 }
		material { txphlox_inter }}
	union { // internode
		cylinder { <0.9161, 15.1188, 1.1739>, <2.04276, 26.8139, 1.6732>, 0.5993 }
		cylinder { <2.04276, 26.8139, 1.6732>, <3.2283, 38.5082, 1.3088>, 0.5993 }
		cylinder { <3.2283, 38.5082, 1.3088>, <4.4663, 50.1382, 0.08282>, 0.5993 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.4663, 50.1382, 0.08282>, <4.5728, 51.0493, -0.1527>, 0.9652 }
			cylinder { <4.5728, 51.0493, -0.1527>, <4.6839, 51.9151, -0.5199>, 0.9652 }
			cylinder { <4.6839, 51.9151, -0.5199>, <4.797, 52.7169, -1.01099>, 0.9652 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <4.797, 52.7169, -1.01099>, <-2.8506, 79.5993, -23.4116>, <9.9186, 76.8548, -21.3355> }
			triangle { <9.9186, 76.8548, -21.3355>, <-2.8506, 79.5993, -23.4116>, <-3.2032, 93.3468, -36.6618> }
			triangle { <9.9186, 76.8548, -21.3355>, <-3.2032, 93.3468, -36.6618>, <10.5406, 89.5389, -37.5242> }
			triangle { <10.5406, 89.5389, -37.5242>, <-3.2032, 93.3468, -36.6618>, <0.1525, 98.2828, -49.2018> }
			triangle { <10.5406, 89.5389, -37.5242>, <0.1525, 98.2828, -49.2018>, <9.5695, 94.34, -49.349> }
			triangle { <9.5695, 94.34, -49.349>, <0.1525, 98.2828, -49.2018>, <7.461, 94.3796, -55.7487> }
			triangle { <15.7871, 90.2629, -54.4024>, <9.5695, 94.34, -49.349>, <7.461, 94.3796, -55.7487> }
			triangle { <15.7871, 90.2629, -54.4024>, <10.5406, 89.5389, -37.5242>, <9.5695, 94.34, -49.349> }
			triangle { <15.7871, 90.2629, -54.4024>, <19.9724, 83.1647, -44.3887>, <10.5406, 89.5389, -37.5242> }
			triangle { <10.5406, 89.5389, -37.5242>, <19.9724, 83.1647, -44.3887>, <9.9186, 76.8548, -21.3355> }
			triangle { <9.9186, 76.8548, -21.3355>, <19.9724, 83.1647, -44.3887>, <16.01996, 71.5405, -27.834> }
			triangle { <9.9186, 76.8548, -21.3355>, <16.01996, 71.5405, -27.834>, <4.797, 52.7169, -1.01099> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <4.4663, 50.1382, 0.08282>, <5.8019, 61.3873, -3.1237>, 0.6 }
		cylinder { <5.8019, 61.3873, -3.1237>, <7.1943, 71.9111, -8.2148>, 0.6 }
		cylinder { <7.1943, 71.9111, -8.2148>, <8.6024, 81.3997, -15.04083>, 0.6 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <8.6024, 81.3997, -15.04083>, <8.7127, 82.02484, -15.7467>, 0.9676 }
			cylinder { <8.7127, 82.02484, -15.7467>, <8.8143, 82.4795, -16.5738>, 0.9676 }
			cylinder { <8.8143, 82.4795, -16.5738>, <8.9024, 82.7418, -17.482>, 0.9676 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <8.9024, 82.7418, -17.482>, <-0.5154, 100.7361, -47.09148>, <11.9595, 96.3113, -46.352> }
			triangle { <11.9595, 96.3113, -46.352>, <-0.5154, 100.7361, -47.09148>, <-2.3334, 108.5438, -64.4755> }
			triangle { <11.9595, 96.3113, -46.352>, <-2.3334, 108.5438, -64.4755>, <10.2369, 101.8832, -66.1359> }
			triangle { <10.2369, 101.8832, -66.1359>, <-2.3334, 108.5438, -64.4755>, <-1.5102, 107.803, -78.3533> }
			triangle { <10.2369, 101.8832, -66.1359>, <-1.5102, 107.803, -78.3533>, <7.04235, 102.1844, -78.5586> }
			triangle { <7.04235, 102.1844, -78.5586>, <-1.5102, 107.803, -78.3533>, <3.4647, 100.3476, -83.9857> }
			triangle { <11.3046, 95.3393, -82.5826>, <7.04235, 102.1844, -78.5586>, <3.4647, 100.3476, -83.9857> }
			triangle { <11.3046, 95.3393, -82.5826>, <10.2369, 101.8832, -66.1359>, <7.04235, 102.1844, -78.5586> }
			triangle { <11.3046, 95.3393, -82.5826>, <16.8726, 91.6166, -71.4409>, <10.2369, 101.8832, -66.1359> }
			triangle { <10.2369, 101.8832, -66.1359>, <16.8726, 91.6166, -71.4409>, <11.9595, 96.3113, -46.352> }
			triangle { <11.9595, 96.3113, -46.352>, <16.8726, 91.6166, -71.4409>, <15.6044, 87.8407, -51.1674> }
			triangle { <11.9595, 96.3113, -46.352>, <15.6044, 87.8407, -51.1674>, <8.9024, 82.7418, -17.482> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <8.6024, 81.3997, -15.04083>, <8.8466, 91.647, -20.8323>, 0.6 }
		cylinder { <8.8466, 91.647, -20.8323>, <7.9217, 102.4314, -25.4639>, 0.6 }
		cylinder { <7.9217, 102.4314, -25.4639>, <5.8477, 113.5192, -28.8355>, 0.6 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.8477, 113.5192, -28.8355>, <5.6, 114.3882, -28.9943>, 0.935 }
			cylinder { <5.6, 114.3882, -28.9943>, <5.2717, 115.2433, -29.0459>, 0.935 }
			cylinder { <5.2717, 115.2433, -29.0459>, <4.8698, 116.066, -28.989>, 0.935 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <4.8698, 116.066, -28.989>, <-2.4212, 147.8779, -17.2069>, <-11.1158, 142.2483, -24.7463> }
			triangle { <-11.1158, 142.2483, -24.7463>, <-2.4212, 147.8779, -17.2069>, <-9.9529, 163.8837, -11.7917> }
			triangle { <-11.1158, 142.2483, -24.7463>, <-9.9529, 163.8837, -11.7917>, <-21.09298, 157.8405, -17.3551> }
			triangle { <-21.09298, 157.8405, -17.3551>, <-9.9529, 163.8837, -11.7917>, <-19.8636, 170.9198, -6.02315> }
			triangle { <-21.09298, 157.8405, -17.3551>, <-19.8636, 170.9198, -6.02315>, <-27.226, 165.4491, -9.7242> }
			triangle { <-27.226, 165.4491, -9.7242>, <-19.8636, 170.9198, -6.02315>, <-29.2883, 167.5556, -3.9002> }
			triangle { <-34.9375, 161.7649, -8.04961>, <-27.226, 165.4491, -9.7242>, <-29.2883, 167.5556, -3.9002> }
			triangle { <-34.9375, 161.7649, -8.04961>, <-21.09298, 157.8405, -17.3551>, <-27.226, 165.4491, -9.7242> }
			triangle { <-34.9375, 161.7649, -8.04961>, <-32.3255, 151.8733, -15.3406>, <-21.09298, 157.8405, -17.3551> }
			triangle { <-21.09298, 157.8405, -17.3551>, <-32.3255, 151.8733, -15.3406>, <-11.1158, 142.2483, -24.7463> }
			triangle { <-11.1158, 142.2483, -24.7463>, <-32.3255, 151.8733, -15.3406>, <-19.5595, 137.8304, -21.5438> }
			triangle { <-11.1158, 142.2483, -24.7463>, <-19.5595, 137.8304, -21.5438>, <4.8698, 116.066, -28.989> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <5.8477, 113.5192, -28.8355>, <4.05701, 124.6429, -32.2512>, 0.6 }
		cylinder { <4.05701, 124.6429, -32.2512>, <2.5506, 135.7956, -35.7089>, 0.6 }
		cylinder { <2.5506, 135.7956, -35.7089>, <1.3296, 146.9708, -39.2066>, 0.6 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.3296, 146.9708, -39.2066>, <1.3878, 147.7955, -39.4817>, 0.8881 }
			cylinder { <1.3878, 147.7955, -39.4817>, <1.593, 148.5936, -39.765>, 0.8881 }
			cylinder { <1.593, 148.5936, -39.765>, <1.939, 149.3415, -40.04814>, 0.8881 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <1.939, 149.3415, -40.04814>, <12.1225, 172.3362, -61.3474>, <14.04471, 174.4217, -49.5143> }
			triangle { <14.04471, 174.4217, -49.5143>, <12.1225, 172.3362, -61.3474>, <19.6823, 185.6832, -69.9173> }
			triangle { <14.04471, 174.4217, -49.5143>, <19.6823, 185.6832, -69.9173>, <24.61, 187.7061, -57.8988> }
			triangle { <24.61, 187.7061, -57.8988>, <19.6823, 185.6832, -69.9173>, <29.823, 192.975, -72.6158> }
			triangle { <24.61, 187.7061, -57.8988>, <29.823, 192.975, -72.6158>, <33.1738, 193.1857, -63.8419> }
			triangle { <33.1738, 193.1857, -63.8419>, <29.823, 192.975, -72.6158>, <38.1162, 193.4492, -67.5757> }
			triangle { <39.9897, 192.881, -59.1652>, <33.1738, 193.1857, -63.8419>, <38.1162, 193.4492, -67.5757> }
			triangle { <39.9897, 192.881, -59.1652>, <24.61, 187.7061, -57.8988>, <33.1738, 193.1857, -63.8419> }
			triangle { <39.9897, 192.881, -59.1652>, <34.3178, 186.9609, -50.4957>, <24.61, 187.7061, -57.8988> }
			triangle { <24.61, 187.7061, -57.8988>, <34.3178, 186.9609, -50.4957>, <14.04471, 174.4217, -49.5143> }
			triangle { <14.04471, 174.4217, -49.5143>, <34.3178, 186.9609, -50.4957>, <22.3887, 173.2754, -45.01555> }
			triangle { <14.04471, 174.4217, -49.5143>, <22.3887, 173.2754, -45.01555>, <1.939, 149.3415, -40.04814> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <1.3296, 146.9708, -39.2066>, <-0.3281, 157.8081, -42.9481>, 0.5903 }
		cylinder { <-0.3281, 157.8081, -42.9481>, <-2.4381, 168.4609, -46.9806>, 0.5903 }
		cylinder { <-2.4381, 168.4609, -46.9806>, <-4.9954, 178.9034, -51.2943>, 0.5903 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.9954, 178.9034, -51.2943>, <-5.2756, 179.5169, -51.6437>, 0.7742 }
			cylinder { <-5.2756, 179.5169, -51.6437>, <-5.6577, 180.0356, -52.04621>, 0.7742 }
			cylinder { <-5.6577, 180.0356, -52.04621>, <-6.1268, 180.4395, -52.4863>, 0.7742 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <-6.1268, 180.4395, -52.4863>, <-25.652, 200.7172, -58.2236>, <-20.3297, 196.6068, -66.4267> }
			triangle { <-20.3297, 196.6068, -66.4267>, <-25.652, 200.7172, -58.2236>, <-35.9431, 210.33, -64.248> }
			triangle { <-20.3297, 196.6068, -66.4267>, <-35.9431, 210.33, -64.248>, <-32.5107, 204.9695, -73.7774> }
			triangle { <-32.5107, 204.9695, -73.7774>, <-35.9431, 210.33, -64.248>, <-44.4405, 212.5132, -71.1116> }
			triangle { <-32.5107, 204.9695, -73.7774>, <-44.4405, 212.5132, -71.1116>, <-41.7292, 207.8398, -77.2656> }
			triangle { <-41.7292, 207.8398, -77.2656>, <-44.4405, 212.5132, -71.1116>, <-47.1251, 207.6663, -77.5177> }
			triangle { <-43.6115, 203.1721, -82.4291>, <-41.7292, 207.8398, -77.2656>, <-47.1251, 207.6663, -77.5177> }
			triangle { <-43.6115, 203.1721, -82.4291>, <-32.5107, 204.9695, -73.7774>, <-41.7292, 207.8398, -77.2656> }
			triangle { <-43.6115, 203.1721, -82.4291>, <-34.7633, 197.8112, -81.3514>, <-32.5107, 204.9695, -73.7774> }
			triangle { <-32.5107, 204.9695, -73.7774>, <-34.7633, 197.8112, -81.3514>, <-20.3297, 196.6068, -66.4267> }
			triangle { <-20.3297, 196.6068, -66.4267>, <-34.7633, 197.8112, -81.3514>, <-23.2996, 190.8681, -71.6738> }
			triangle { <-20.3297, 196.6068, -66.4267>, <-23.2996, 190.8681, -71.6738>, <-6.1268, 180.4395, -52.4863> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <-4.9954, 178.9034, -51.2943>, <-6.2042, 184.5325, -52.9948>, 0.3059 }
		cylinder { <-6.2042, 184.5325, -52.9948>, <-7.2851, 190.3248, -54.1438>, 0.3059 }
		cylinder { <-7.2851, 190.3248, -54.1438>, <-8.2275, 196.2245, -54.7304>, 0.3059 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.2275, 196.2245, -54.7304>, <-8.2577, 196.5057, -54.7044>, 0.2894 }
			cylinder { <-8.2577, 196.5057, -54.7044>, <-8.2725, 196.7781, -54.6256>, 0.2894 }
			cylinder { <-8.2725, 196.7781, -54.6256>, <-8.2712, 197.0313, -54.4972>, 0.2894 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <-8.2712, 197.0313, -54.4972>, <-4.7602, 206.8701, -52.00592>, <-8.3156, 205.7958, -50.6171> }
			triangle { <-8.3156, 205.7958, -50.6171>, <-4.7602, 206.8701, -52.00592>, <-3.6998, 212.0468, -49.801> }
			triangle { <-8.3156, 205.7958, -50.6171>, <-3.6998, 212.0468, -49.801>, <-7.1023, 210.9448, -47.4431> }
			triangle { <-7.1023, 210.9448, -47.4431>, <-3.6998, 212.0468, -49.801>, <-3.2941, 214.6251, -46.5564> }
			triangle { <-7.1023, 210.9448, -47.4431>, <-3.2941, 214.6251, -46.5564>, <-5.6152, 213.4487, -44.9439> }
			triangle { <-5.6152, 213.4487, -44.9439>, <-3.2941, 214.6251, -46.5564>, <-4.2601, 214.089, -43.5892> }
			triangle { <-6.4639, 212.7283, -42.489>, <-5.6152, 213.4487, -44.9439>, <-4.2601, 214.089, -43.5892> }
			triangle { <-6.4639, 212.7283, -42.489>, <-7.1023, 210.9448, -47.4431>, <-5.6152, 213.4487, -44.9439> }
			triangle { <-6.4639, 212.7283, -42.489>, <-8.4794, 209.7214, -43.9085>, <-7.1023, 210.9448, -47.4431> }
			triangle { <-7.1023, 210.9448, -47.4431>, <-8.4794, 209.7214, -43.9085>, <-8.3156, 205.7958, -50.6171> }
			triangle { <-8.3156, 205.7958, -50.6171>, <-8.4794, 209.7214, -43.9085>, <-8.8941, 204.8634, -47.7054> }
			triangle { <-8.3156, 205.7958, -50.6171>, <-8.8941, 204.8634, -47.7054>, <-8.2712, 197.0313, -54.4972> }
			material { txphlox_leaf }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-8.2275, 196.2245, -54.7304>, <-13.5863, 229.7726, -58.06603>, 0.2999 }
			cylinder { <-13.5863, 229.7726, -58.06603>, <-18.9451, 263.3207, -61.4016>, 0.2999 }
			cylinder { <-18.9451, 263.3207, -61.4016>, <-24.3039, 296.8688, -64.7371>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-24.3039, 296.8688, -64.7371>, <-24.6969, 299.1696, -65.04444>, 0.2999 }
			cylinder { <-24.6969, 299.1696, -65.04444>, <-25.1128, 301.4548, -65.4285>, 0.2999 }
			cylinder { <-25.1128, 301.4548, -65.4285>, <-25.5512, 303.7216, -65.889>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-25.5512, 303.7216, -65.889>, <-26.01141, 305.9673, -66.4253>, 0.2999 }
			cylinder { <-26.01141, 305.9673, -66.4253>, <-26.4928, 308.1891, -67.03695>, 0.2999 }
			cylinder { <-26.4928, 308.1891, -67.03695>, <-26.995, 310.3845, -67.7229>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-26.995, 310.3845, -67.7229>, <-27.5172, 312.5508, -68.4826>, 0.2999 }
			cylinder { <-27.5172, 312.5508, -68.4826>, <-28.05885, 314.6853, -69.3151>, 0.2999 }
			cylinder { <-28.05885, 314.6853, -69.3151>, <-28.6191, 316.7855, -70.2193>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-28.6191, 316.7855, -70.2193>, <-29.1975, 318.8489, -71.1942>, 0.2999 }
			cylinder { <-29.1975, 318.8489, -71.1942>, <-29.7931, 320.873, -72.2386>, 0.2999 }
			cylinder { <-29.7931, 320.873, -72.2386>, <-30.4053, 322.8554, -73.3513>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-30.4053, 322.8554, -73.3513>, <-31.03338, 324.7936, -74.5308>, 0.2999 }
			cylinder { <-31.03338, 324.7936, -74.5308>, <-31.6764, 326.6854, -75.7759>, 0.2999 }
			cylinder { <-31.6764, 326.6854, -75.7759>, <-32.3336, 328.5284, -77.08511>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-32.3336, 328.5284, -77.08511>, <-33.00432, 330.3205, -78.4566>, 0.2999 }
			cylinder { <-33.00432, 330.3205, -78.4566>, <-33.6875, 332.0594, -79.889>, 0.2999 }
			cylinder { <-33.6875, 332.0594, -79.889>, <-34.3825, 333.7432, -81.3805>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-34.3825, 333.7432, -81.3805>, <-35.08837, 335.3698, -82.9293>, 0.2999 }
			cylinder { <-35.08837, 335.3698, -82.9293>, <-35.8042, 336.9371, -84.5335>, 0.2999 }
			cylinder { <-35.8042, 336.9371, -84.5335>, <-36.5291, 338.4434, -86.1912>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-36.5291, 338.4434, -86.1912>, <-37.2623, 339.8868, -87.9005>, 0.2999 }
			cylinder { <-37.2623, 339.8868, -87.9005>, <-38.00278, 341.2656, -89.6592>, 0.2999 }
			cylinder { <-38.00278, 341.2656, -89.6592>, <-38.7496, 342.5782, -91.4653>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-38.7496, 342.5782, -91.4653>, <-39.5435, 343.9328, -93.2195>, 0.2999 }
			cylinder { <-39.5435, 343.9328, -93.2195>, <-40.3835, 345.3278, -94.9197>, 0.2999 }
			cylinder { <-40.3835, 345.3278, -94.9197>, <-41.2686, 346.7616, -96.5639>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-41.2686, 346.7616, -96.5639>, <-45.6865, 350.6168, -100.5013>, 0.2999 }
				cylinder { <-45.6865, 350.6168, -100.5013>, <-51.4864, 353.6938, -103.1044>, 0.2999 }
				cylinder { <-51.4864, 353.6938, -103.1044>, <-58.1689, 355.7276, -104.1491>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-58.1689, 355.7276, -104.1491>, <-58.9239, 355.8722, -103.8404>, <-60.5093, 356.3831, -104.2305> }
					triangle { <-58.9239, 355.8722, -103.8404>, <-61.4607, 356.6158, -104.0948>, <-60.5093, 356.3831, -104.2305> }
					triangle { <-61.4607, 356.6158, -104.0948>, <-61.4398, 356.7231, -104.6604>, <-60.5093, 356.3831, -104.2305> }
					triangle { <-60.5093, 356.3831, -104.2305>, <-61.4398, 356.7231, -104.6604>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-61.4607, 356.6158, -104.0948>, <-63.03092, 352.3327, -103.0299>, <-64.1802, 350.9983, -104.0391> }
					triangle { <-64.1802, 350.9983, -104.0391>, <-64.2359, 350.4221, -106.0851>, <-63.7495, 351.1095, -105.9368> }
					triangle { <-63.7495, 351.1095, -105.9368>, <-61.4607, 356.6158, -104.0948>, <-64.1802, 350.9983, -104.0391> }
					triangle { <-61.4607, 356.6158, -104.0948>, <-63.7495, 351.1095, -105.9368>, <-61.4398, 356.7231, -104.6604> }
					triangle { <-60.3987, 356.463, -104.7822>, <-58.758, 355.9921, -104.6679>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-60.3987, 356.463, -104.7822>, <-61.2396, 356.7757, -105.1981>, <-58.758, 355.9921, -104.6679> }
					triangle { <-60.3987, 356.463, -104.7822>, <-61.4398, 356.7231, -104.6604>, <-61.2396, 356.7757, -105.1981> }
					triangle { <-58.1689, 355.7276, -104.1491>, <-61.4398, 356.7231, -104.6604>, <-60.3987, 356.463, -104.7822> }
					triangle { <-63.4246, 351.5445, -107.8088>, <-62.07264, 353.0254, -107.811>, <-61.2396, 356.7757, -105.1981> }
					triangle { <-63.7495, 351.1095, -105.9368>, <-64.2359, 350.4221, -106.0851>, <-63.4246, 351.5445, -107.8088> }
					triangle { <-63.4246, 351.5445, -107.8088>, <-61.2396, 356.7757, -105.1981>, <-63.7495, 351.1095, -105.9368> }
					triangle { <-61.4398, 356.7231, -104.6604>, <-63.7495, 351.1095, -105.9368>, <-61.2396, 356.7757, -105.1981> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-58.1689, 355.7276, -104.1491>, <-58.7623, 356.2967, -104.0478>, <-60.4016, 356.6661, -104.3688> }
					triangle { <-58.7623, 356.2967, -104.0478>, <-61.2452, 357.1819, -104.3713>, <-60.4016, 356.6661, -104.3688> }
					triangle { <-61.2452, 357.1819, -104.3713>, <-61.4398, 356.7231, -104.6604>, <-60.4016, 356.6661, -104.3688> }
					triangle { <-60.4016, 356.6661, -104.3688>, <-61.4398, 356.7231, -104.6604>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-61.2452, 357.1819, -104.3713>, <-62.1097, 357.0342, -99.7696>, <-63.4871, 356.0389, -98.6596> }
					triangle { <-63.4871, 356.0389, -98.6596>, <-64.2679, 354.0653, -98.7877>, <-63.7937, 354.2897, -99.4629> }
					triangle { <-63.7937, 354.2897, -99.4629>, <-61.2452, 357.1819, -104.3713>, <-63.4871, 356.0389, -98.6596> }
					triangle { <-61.2452, 357.1819, -104.3713>, <-63.7937, 354.2897, -99.4629>, <-61.4398, 356.7231, -104.6604> }
					triangle { <-60.5065, 356.18, -104.6439>, <-58.9197, 355.5676, -104.4605>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-60.5065, 356.18, -104.6439>, <-61.4551, 356.2097, -104.9215>, <-58.9197, 355.5676, -104.4605> }
					triangle { <-60.5065, 356.18, -104.6439>, <-61.4398, 356.7231, -104.6604>, <-61.4551, 356.2097, -104.9215> }
					triangle { <-58.1689, 355.7276, -104.1491>, <-61.4398, 356.7231, -104.6604>, <-60.5065, 356.18, -104.6439> }
					triangle { <-64.2041, 352.7174, -100.5394>, <-63.0191, 352.8216, -102.1538>, <-61.4551, 356.2097, -104.9215> }
					triangle { <-63.7937, 354.2897, -99.4629>, <-64.2679, 354.0653, -98.7877>, <-64.2041, 352.7174, -100.5394> }
					triangle { <-64.2041, 352.7174, -100.5394>, <-61.4551, 356.2097, -104.9215>, <-63.7937, 354.2897, -99.4629> }
					triangle { <-61.4398, 356.7231, -104.6604>, <-63.7937, 354.2897, -99.4629>, <-61.4551, 356.2097, -104.9215> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-58.1689, 355.7276, -104.1491>, <-58.7087, 356.2208, -104.5385>, <-60.3658, 356.6155, -104.6959> }
					triangle { <-58.7087, 356.2208, -104.5385>, <-61.1738, 357.0807, -105.0255>, <-60.3658, 356.6155, -104.6959> }
					triangle { <-61.1738, 357.0807, -105.0255>, <-61.4398, 356.7231, -104.6604>, <-60.3658, 356.6155, -104.6959> }
					triangle { <-60.3658, 356.6155, -104.6959>, <-61.4398, 356.7231, -104.6604>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-61.1738, 357.0807, -105.0255>, <-60.2689, 361.3087, -103.2226>, <-61.09087, 362.3556, -101.6902> }
					triangle { <-61.09087, 362.3556, -101.6902>, <-61.771, 361.7685, -99.763>, <-61.5908, 361.1095, -100.2773> }
					triangle { <-61.5908, 361.1095, -100.2773>, <-61.1738, 357.0807, -105.0255>, <-61.09087, 362.3556, -101.6902> }
					triangle { <-61.1738, 357.0807, -105.0255>, <-61.5908, 361.1095, -100.2773>, <-61.4398, 356.7231, -104.6604> }
					triangle { <-60.5422, 356.2306, -104.3168>, <-58.9733, 355.6435, -103.9699>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-60.5422, 356.2306, -104.3168>, <-61.5266, 356.3109, -104.2673>, <-58.9733, 355.6435, -103.9699> }
					triangle { <-60.5422, 356.2306, -104.3168>, <-61.4398, 356.7231, -104.6604>, <-61.5266, 356.3109, -104.2673> }
					triangle { <-58.1689, 355.7276, -104.1491>, <-61.4398, 356.7231, -104.6604>, <-60.5422, 356.2306, -104.3168> }
					triangle { <-62.2962, 359.7256, -99.09981>, <-61.7977, 357.973, -99.9372>, <-61.5266, 356.3109, -104.2673> }
					triangle { <-61.5908, 361.1095, -100.2773>, <-61.771, 361.7685, -99.763>, <-62.2962, 359.7256, -99.09981> }
					triangle { <-62.2962, 359.7256, -99.09981>, <-61.5266, 356.3109, -104.2673>, <-61.5908, 361.1095, -100.2773> }
					triangle { <-61.4398, 356.7231, -104.6604>, <-61.5908, 361.1095, -100.2773>, <-61.5266, 356.3109, -104.2673> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-58.1689, 355.7276, -104.1491>, <-58.8367, 355.7487, -104.6389>, <-60.4511, 356.3008, -104.7628> }
					triangle { <-58.8367, 355.7487, -104.6389>, <-61.3444, 356.4512, -105.1593>, <-60.4511, 356.3008, -104.7628> }
					triangle { <-61.3444, 356.4512, -105.1593>, <-61.4398, 356.7231, -104.6604>, <-60.4511, 356.3008, -104.7628> }
					triangle { <-60.4511, 356.3008, -104.7628>, <-61.4398, 356.7231, -104.6604>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-61.3444, 356.4512, -105.1593>, <-60.03538, 359.2888, -108.6492>, <-60.2806, 361.2778, -108.9709> }
					triangle { <-60.2806, 361.2778, -108.9709>, <-60.1725, 362.9579, -107.6722>, <-60.1647, 362.2078, -107.2619> }
					triangle { <-60.1647, 362.2078, -107.2619>, <-61.3444, 356.4512, -105.1593>, <-60.2806, 361.2778, -108.9709> }
					triangle { <-61.3444, 356.4512, -105.1593>, <-60.1647, 362.2078, -107.2619>, <-61.4398, 356.7231, -104.6604> }
					triangle { <-60.4569, 356.5453, -104.2499>, <-58.8453, 356.1156, -103.8695>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-60.4569, 356.5453, -104.2499>, <-61.3559, 356.9404, -104.1335>, <-58.8453, 356.1156, -103.8695> }
					triangle { <-60.4569, 356.5453, -104.2499>, <-61.4398, 356.7231, -104.6604>, <-61.3559, 356.9404, -104.1335> }
					triangle { <-58.1689, 355.7276, -104.1491>, <-61.4398, 356.7231, -104.6604>, <-60.4569, 356.5453, -104.2499> }
					triangle { <-60.3198, 362.9493, -105.466>, <-60.08511, 361.4088, -104.204>, <-61.3559, 356.9404, -104.1335> }
					triangle { <-60.1647, 362.2078, -107.2619>, <-60.1725, 362.9579, -107.6722>, <-60.3198, 362.9493, -105.466> }
					triangle { <-60.3198, 362.9493, -105.466>, <-61.3559, 356.9404, -104.1335>, <-60.1647, 362.2078, -107.2619> }
					triangle { <-61.4398, 356.7231, -104.6604>, <-60.1647, 362.2078, -107.2619>, <-61.3559, 356.9404, -104.1335> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-58.1689, 355.7276, -104.1491>, <-58.9717, 355.53, -104.2009>, <-60.5412, 356.1549, -104.4708> }
					triangle { <-58.9717, 355.53, -104.2009>, <-61.5245, 356.1596, -104.5754>, <-60.5412, 356.1549, -104.4708> }
					triangle { <-61.5245, 356.1596, -104.5754>, <-61.4398, 356.7231, -104.6604>, <-60.5412, 356.1549, -104.4708> }
					triangle { <-60.5412, 356.1549, -104.4708>, <-61.4398, 356.7231, -104.6604>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-61.5245, 356.1596, -104.5754>, <-61.7681, 353.6576, -108.5284>, <-62.2188, 354.1526, -110.4445> }
					triangle { <-62.2188, 354.1526, -110.4445>, <-61.7189, 355.8397, -111.6384>, <-61.5189, 355.9342, -110.8125> }
					triangle { <-61.5189, 355.9342, -110.8125>, <-61.5245, 356.1596, -104.5754>, <-62.2188, 354.1526, -110.4445> }
					triangle { <-61.5245, 356.1596, -104.5754>, <-61.5189, 355.9342, -110.8125>, <-61.4398, 356.7231, -104.6604> }
					triangle { <-60.3669, 356.6912, -104.5418>, <-58.7102, 356.3343, -104.3074>, <-58.1689, 355.7276, -104.1491> }
					triangle { <-60.3669, 356.6912, -104.5418>, <-61.1759, 357.232, -104.7174>, <-58.7102, 356.3343, -104.3074> }
					triangle { <-60.3669, 356.6912, -104.5418>, <-61.4398, 356.7231, -104.6604>, <-61.1759, 357.232, -104.7174> }
					triangle { <-58.1689, 355.7276, -104.1491>, <-61.4398, 356.7231, -104.6604>, <-60.3669, 356.6912, -104.5418> }
					triangle { <-61.02781, 357.8168, -110.9297>, <-60.2575, 358.3048, -109.1437>, <-61.1759, 357.232, -104.7174> }
					triangle { <-61.5189, 355.9342, -110.8125>, <-61.7189, 355.8397, -111.6384>, <-61.02781, 357.8168, -110.9297> }
					triangle { <-61.02781, 357.8168, -110.9297>, <-61.1759, 357.232, -104.7174>, <-61.5189, 355.9342, -110.8125> }
					triangle { <-61.4398, 356.7231, -104.6604>, <-61.5189, 355.9342, -110.8125>, <-61.1759, 357.232, -104.7174> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-41.2686, 346.7616, -96.5639>, <-42.07915, 348.2018, -98.2407>, 0.2999 }
			cylinder { <-42.07915, 348.2018, -98.2407>, <-42.8139, 349.6467, -99.948>, 0.2999 }
			cylinder { <-42.8139, 349.6467, -99.948>, <-43.4722, 351.0945, -101.6838>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-43.4722, 351.0945, -101.6838>, <-43.7251, 356.4308, -106.3037>, 0.2999 }
				cylinder { <-43.7251, 356.4308, -106.3037>, <-42.2343, 362.3002, -109.9383>, 0.2999 }
				cylinder { <-42.2343, 362.3002, -109.9383>, <-39.128, 368.1973, -112.2746>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-39.128, 368.1973, -112.2746>, <-38.5022, 368.6782, -112.3641>, <-38.00943, 370.1258, -112.9574> }
					triangle { <-38.5022, 368.6782, -112.3641>, <-37.4211, 370.8385, -113.1691>, <-38.00943, 370.1258, -112.9574> }
					triangle { <-37.4211, 370.8385, -113.1691>, <-37.8791, 371.0602, -113.3841>, <-38.00943, 370.1258, -112.9574> }
					triangle { <-38.00943, 370.1258, -112.9574>, <-37.8791, 371.0602, -113.3841>, <-39.128, 368.1973, -112.2746> }
					triangle { <-37.4211, 370.8385, -113.1691>, <-36.5411, 372.185, -108.9755>, <-37.06913, 373.7565, -107.9564> }
					triangle { <-37.06913, 373.7565, -107.9564>, <-38.8273, 374.7813, -107.8338>, <-38.813, 374.226, -108.4368> }
					triangle { <-38.813, 374.226, -108.4368>, <-37.4211, 370.8385, -113.1691>, <-37.06913, 373.7565, -107.9564> }
					triangle { <-37.4211, 370.8385, -113.1691>, <-38.813, 374.226, -108.4368>, <-37.8791, 371.0602, -113.3841> }
					triangle { <-38.5016, 370.269, -113.142>, <-39.2406, 368.893, -112.641>, <-39.128, 368.1973, -112.2746> }
					triangle { <-38.5016, 370.269, -113.142>, <-38.4056, 371.1249, -113.5382>, <-39.2406, 368.893, -112.641> }
					triangle { <-38.5016, 370.269, -113.142>, <-37.8791, 371.0602, -113.3841>, <-38.4056, 371.1249, -113.5382> }
					triangle { <-39.128, 368.1973, -112.2746>, <-37.8791, 371.0602, -113.3841>, <-38.5016, 370.269, -113.142> }
					triangle { <-40.4328, 374.7351, -109.2175>, <-40.8072, 373.4261, -110.5751>, <-38.4056, 371.1249, -113.5382> }
					triangle { <-38.813, 374.226, -108.4368>, <-38.8273, 374.7813, -107.8338>, <-40.4328, 374.7351, -109.2175> }
					triangle { <-40.4328, 374.7351, -109.2175>, <-38.4056, 371.1249, -113.5382>, <-38.813, 374.226, -108.4368> }
					triangle { <-37.8791, 371.0602, -113.3841>, <-38.813, 374.226, -108.4368>, <-38.4056, 371.1249, -113.5382> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-39.128, 368.1973, -112.2746>, <-38.6762, 368.585, -112.8003>, <-38.1254, 370.0637, -113.2482> }
					triangle { <-38.6762, 368.585, -112.8003>, <-37.6531, 370.7143, -113.7507>, <-38.1254, 370.0637, -113.2482> }
					triangle { <-37.6531, 370.7143, -113.7507>, <-37.8791, 371.0602, -113.3841>, <-38.1254, 370.0637, -113.2482> }
					triangle { <-38.1254, 370.0637, -113.2482>, <-37.8791, 371.0602, -113.3841>, <-39.128, 368.1973, -112.2746> }
					triangle { <-37.6531, 370.7143, -113.7507>, <-33.4864, 369.4105, -112.6962>, <-32.1054, 370.1912, -111.5689> }
					triangle { <-32.1054, 370.1912, -111.5689>, <-32.1837, 371.1353, -109.7637>, <-32.9207, 371.0107, -110.1006> }
					triangle { <-32.9207, 371.0107, -110.1006>, <-37.6531, 370.7143, -113.7507>, <-32.1054, 370.1912, -111.5689> }
					triangle { <-37.6531, 370.7143, -113.7507>, <-32.9207, 371.0107, -110.1006>, <-37.8791, 371.0602, -113.3841> }
					triangle { <-38.3856, 370.3311, -112.8512>, <-39.06663, 368.9861, -112.2048>, <-39.128, 368.1973, -112.2746> }
					triangle { <-38.3856, 370.3311, -112.8512>, <-38.1736, 371.2491, -112.9566>, <-39.06663, 368.9861, -112.2048> }
					triangle { <-38.3856, 370.3311, -112.8512>, <-37.8791, 371.0602, -113.3841>, <-38.1736, 371.2491, -112.9566> }
					triangle { <-39.128, 368.1973, -112.2746>, <-37.8791, 371.0602, -113.3841>, <-38.3856, 370.3311, -112.8512> }
					triangle { <-33.8838, 372.0184, -108.8558>, <-35.7419, 371.728, -109.2551>, <-38.1736, 371.2491, -112.9566> }
					triangle { <-32.9207, 371.0107, -110.1006>, <-32.1837, 371.1353, -109.7637>, <-33.8838, 372.0184, -108.8558> }
					triangle { <-33.8838, 372.0184, -108.8558>, <-38.1736, 371.2491, -112.9566>, <-32.9207, 371.0107, -110.1006> }
					triangle { <-37.8791, 371.0602, -113.3841>, <-32.9207, 371.0107, -110.1006>, <-38.1736, 371.2491, -112.9566> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-39.128, 368.1973, -112.2746>, <-39.1181, 368.7672, -112.8278>, <-38.42, 370.1851, -113.2665> }
					triangle { <-39.1181, 368.7672, -112.8278>, <-38.2423, 370.9572, -113.7873>, <-38.42, 370.1851, -113.2665> }
					triangle { <-38.2423, 370.9572, -113.7873>, <-37.8791, 371.0602, -113.3841>, <-38.42, 370.1851, -113.2665> }
					triangle { <-38.42, 370.1851, -113.2665>, <-37.8791, 371.0602, -113.3841>, <-39.128, 368.1973, -112.2746> }
					triangle { <-38.2423, 370.9572, -113.7873>, <-36.4614, 368.9004, -117.361>, <-34.6442, 368.7876, -118.0485> }
					triangle { <-34.6442, 368.7876, -118.0485>, <-32.8413, 368.5704, -117.122>, <-33.4588, 368.7247, -116.6052> }
					triangle { <-33.4588, 368.7247, -116.6052>, <-38.2423, 370.9572, -113.7873>, <-34.6442, 368.7876, -118.0485> }
					triangle { <-38.2423, 370.9572, -113.7873>, <-33.4588, 368.7247, -116.6052>, <-37.8791, 371.0602, -113.3841> }
					triangle { <-38.09107, 370.2097, -112.8329>, <-38.6247, 368.804, -112.1773>, <-39.128, 368.1973, -112.2746> }
					triangle { <-38.09107, 370.2097, -112.8329>, <-37.5844, 371.0063, -112.92>, <-38.6247, 368.804, -112.1773> }
					triangle { <-38.09107, 370.2097, -112.8329>, <-37.8791, 371.0602, -113.3841>, <-37.5844, 371.0063, -112.92> }
					triangle { <-39.128, 368.1973, -112.2746>, <-37.8791, 371.0602, -113.3841>, <-38.09107, 370.2097, -112.8329> }
					triangle { <-32.3963, 368.9554, -115.0852>, <-33.6102, 369.1132, -113.6027>, <-37.5844, 371.0063, -112.92> }
					triangle { <-33.4588, 368.7247, -116.6052>, <-32.8413, 368.5704, -117.122>, <-32.3963, 368.9554, -115.0852> }
					triangle { <-32.3963, 368.9554, -115.0852>, <-37.5844, 371.0063, -112.92>, <-33.4588, 368.7247, -116.6052> }
					triangle { <-37.8791, 371.0602, -113.3841>, <-33.4588, 368.7247, -116.6052>, <-37.5844, 371.0063, -112.92> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-39.128, 368.1973, -112.2746>, <-39.2214, 368.9745, -112.4088>, <-38.4888, 370.3234, -112.9872> }
					triangle { <-39.2214, 368.9745, -112.4088>, <-38.38, 371.2337, -113.2287>, <-38.4888, 370.3234, -112.9872> }
					triangle { <-38.38, 371.2337, -113.2287>, <-37.8791, 371.0602, -113.3841>, <-38.4888, 370.3234, -112.9872> }
					triangle { <-38.4888, 370.3234, -112.9872>, <-37.8791, 371.0602, -113.3841>, <-39.128, 368.1973, -112.2746> }
					triangle { <-38.38, 371.2337, -113.2287>, <-41.3824, 371.3549, -116.567>, <-41.2008, 371.4724, -118.501> }
					triangle { <-41.2008, 371.4724, -118.501>, <-39.8974, 370.6074, -119.8084>, <-39.6887, 370.5056, -119.0221> }
					triangle { <-39.6887, 370.5056, -119.0221>, <-38.38, 371.2337, -113.2287>, <-41.2008, 371.4724, -118.501> }
					triangle { <-38.38, 371.2337, -113.2287>, <-39.6887, 370.5056, -119.0221>, <-37.8791, 371.0602, -113.3841> }
					triangle { <-38.02224, 370.0714, -113.1122>, <-38.5214, 368.5966, -112.5963>, <-39.128, 368.1973, -112.2746> }
					triangle { <-38.02224, 370.0714, -113.1122>, <-37.4467, 370.7297, -113.4786>, <-38.5214, 368.5966, -112.5963> }
					triangle { <-38.02224, 370.0714, -113.1122>, <-37.8791, 371.0602, -113.3841>, <-37.4467, 370.7297, -113.4786> }
					triangle { <-39.128, 368.1973, -112.2746>, <-37.8791, 371.0602, -113.3841>, <-38.02224, 370.0714, -113.1122> }
					triangle { <-38.01211, 369.7504, -119.3551>, <-37.3382, 369.1709, -117.6502>, <-37.4467, 370.7297, -113.4786> }
					triangle { <-39.6887, 370.5056, -119.0221>, <-39.8974, 370.6074, -119.8084>, <-38.01211, 369.7504, -119.3551> }
					triangle { <-38.01211, 369.7504, -119.3551>, <-37.4467, 370.7297, -113.4786>, <-39.6887, 370.5056, -119.0221> }
					triangle { <-37.8791, 371.0602, -113.3841>, <-39.6887, 370.5056, -119.0221>, <-37.4467, 370.7297, -113.4786> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-39.128, 368.1973, -112.2746>, <-38.835, 368.9187, -112.1179>, <-38.2312, 370.2862, -112.7933> }
					triangle { <-38.835, 368.9187, -112.1179>, <-37.8648, 371.1593, -112.8408>, <-38.2312, 370.2862, -112.7933> }
					triangle { <-37.8648, 371.1593, -112.8408>, <-37.8791, 371.0602, -113.3841>, <-38.2312, 370.2862, -112.7933> }
					triangle { <-38.2312, 370.2862, -112.7933>, <-37.8791, 371.0602, -113.3841>, <-39.128, 368.1973, -112.2746> }
					triangle { <-37.8648, 371.1593, -112.8408>, <-41.4324, 373.4155, -111.3062>, <-42.722, 374.5897, -112.1696> }
					triangle { <-42.722, 374.5897, -112.1696>, <-43.6528, 374.5038, -113.9814>, <-43.04782, 373.957, -113.8976> }
					triangle { <-43.04782, 373.957, -113.8976>, <-37.8648, 371.1593, -112.8408>, <-42.722, 374.5897, -112.1696> }
					triangle { <-37.8648, 371.1593, -112.8408>, <-43.04782, 373.957, -113.8976>, <-37.8791, 371.0602, -113.3841> }
					triangle { <-38.2798, 370.1086, -113.3061>, <-38.9078, 368.6524, -112.8872>, <-39.128, 368.1973, -112.2746> }
					triangle { <-38.2798, 370.1086, -113.3061>, <-37.9619, 370.8042, -113.8665>, <-38.9078, 368.6524, -112.8872> }
					triangle { <-38.2798, 370.1086, -113.3061>, <-37.8791, 371.0602, -113.3841>, <-37.9619, 370.8042, -113.8665> }
					triangle { <-39.128, 368.1973, -112.2746>, <-37.8791, 371.0602, -113.3841>, <-38.2798, 370.1086, -113.3061> }
					triangle { <-43.05394, 373.3764, -115.6739>, <-41.8533, 371.8766, -115.7507>, <-37.9619, 370.8042, -113.8665> }
					triangle { <-43.04782, 373.957, -113.8976>, <-43.6528, 374.5038, -113.9814>, <-43.05394, 373.3764, -115.6739> }
					triangle { <-43.05394, 373.3764, -115.6739>, <-37.9619, 370.8042, -113.8665>, <-43.04782, 373.957, -113.8976> }
					triangle { <-37.8791, 371.0602, -113.3841>, <-43.04782, 373.957, -113.8976>, <-37.9619, 370.8042, -113.8665> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-24.3039, 296.8688, -64.7371>, <-24.7075, 299.183, -64.8929>, 0.2999 }
			cylinder { <-24.7075, 299.183, -64.8929>, <-25.1447, 301.4949, -64.9742>, 0.2999 }
			cylinder { <-25.1447, 301.4949, -64.9742>, <-25.615, 303.8017, -64.981>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-25.615, 303.8017, -64.981>, <-27.6625, 304.7413, -64.2971>, 0.2999 }
			cylinder { <-27.6625, 304.7413, -64.2971>, <-29.6814, 305.7546, -63.634>, 0.2999 }
			cylinder { <-29.6814, 305.7546, -63.634>, <-31.6693, 306.8404, -62.9922>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-31.6693, 306.8404, -62.9922>, <-36.2787, 311.4039, -60.1975>, 0.2999 }
				cylinder { <-36.2787, 311.4039, -60.1975>, <-39.1369, 316.8804, -56.7739>, 0.2999 }
				cylinder { <-39.1369, 316.8804, -56.7739>, <-39.9978, 322.7983, -53.0163>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-39.9978, 322.7983, -53.0163>, <-39.663, 323.5392, -52.8575>, <-39.8757, 325.0045, -52.00047> }
					triangle { <-39.663, 323.5392, -52.8575>, <-39.6771, 325.916, -51.6726>, <-39.8757, 325.0045, -52.00047> }
					triangle { <-39.6771, 325.916, -51.6726>, <-40.1778, 325.847, -51.3961>, <-39.8757, 325.0045, -52.00047> }
					triangle { <-39.8757, 325.0045, -52.00047>, <-40.1778, 325.847, -51.3961>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-39.6771, 325.916, -51.6726>, <-35.9164, 324.8692, -49.08306>, <-35.6047, 324.7892, -47.07898> }
					triangle { <-35.6047, 324.7892, -47.07898>, <-36.8066, 324.0804, -45.4745>, <-37.2245, 324.1291, -46.2189> }
					triangle { <-37.2245, 324.1291, -46.2189>, <-39.6771, 325.916, -51.6726>, <-35.6047, 324.7892, -47.07898> }
					triangle { <-39.6771, 325.916, -51.6726>, <-37.2245, 324.1291, -46.2189>, <-40.1778, 325.847, -51.3961> }
					triangle { <-40.3714, 324.8519, -51.7683>, <-40.4066, 323.3103, -52.5092>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-40.3714, 324.8519, -51.7683>, <-40.6686, 325.6108, -51.2083>, <-40.4066, 323.3103, -52.5092> }
					triangle { <-40.3714, 324.8519, -51.7683>, <-40.1778, 325.847, -51.3961>, <-40.6686, 325.6108, -51.2083> }
					triangle { <-39.9978, 322.7983, -53.0163>, <-40.1778, 325.847, -51.3961>, <-40.3714, 324.8519, -51.7683> }
					triangle { <-38.9923, 323.7462, -45.4926>, <-40.2128, 323.5464, -47.07116>, <-40.6686, 325.6108, -51.2083> }
					triangle { <-37.2245, 324.1291, -46.2189>, <-36.8066, 324.0804, -45.4745>, <-38.9923, 323.7462, -45.4926> }
					triangle { <-38.9923, 323.7462, -45.4926>, <-40.6686, 325.6108, -51.2083>, <-37.2245, 324.1291, -46.2189> }
					triangle { <-40.1778, 325.847, -51.3961>, <-37.2245, 324.1291, -46.2189>, <-40.6686, 325.6108, -51.2083> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-39.9978, 322.7983, -53.0163>, <-40.1149, 323.6175, -53.05499>, <-40.1769, 325.0567, -52.1321> }
					triangle { <-40.1149, 323.6175, -53.05499>, <-40.2796, 326.0204, -51.9359>, <-40.1769, 325.0567, -52.1321> }
					triangle { <-40.2796, 326.0204, -51.9359>, <-40.1778, 325.847, -51.3961>, <-40.1769, 325.0567, -52.1321> }
					triangle { <-40.1769, 325.0567, -52.1321>, <-40.1778, 325.847, -51.3961>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-40.2796, 326.0204, -51.9359>, <-36.4691, 327.5509, -54.1904>, <-34.6881, 328.2795, -53.5446> }
					triangle { <-34.6881, 328.2795, -53.5446>, <-33.413, 327.7162, -51.9389>, <-34.179, 327.3368, -51.9163> }
					triangle { <-34.179, 327.3368, -51.9163>, <-40.2796, 326.0204, -51.9359>, <-34.6881, 328.2795, -53.5446> }
					triangle { <-40.2796, 326.0204, -51.9359>, <-34.179, 327.3368, -51.9163>, <-40.1778, 325.847, -51.3961> }
					triangle { <-40.07017, 324.7997, -51.6366>, <-39.9547, 323.232, -52.3117>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-40.07017, 324.7997, -51.6366>, <-40.06607, 325.5064, -50.945>, <-39.9547, 323.232, -52.3117> }
					triangle { <-40.07017, 324.7997, -51.6366>, <-40.1778, 325.847, -51.3961>, <-40.06607, 325.5064, -50.945> }
					triangle { <-39.9978, 322.7983, -53.0163>, <-40.1778, 325.847, -51.3961>, <-40.07017, 324.7997, -51.6366> }
					triangle { <-33.9583, 326.5232, -50.1589>, <-35.5435, 325.3235, -49.8963>, <-40.06607, 325.5064, -50.945> }
					triangle { <-34.179, 327.3368, -51.9163>, <-33.413, 327.7162, -51.9389>, <-33.9583, 326.5232, -50.1589> }
					triangle { <-33.9583, 326.5232, -50.1589>, <-40.06607, 325.5064, -50.945>, <-34.179, 327.3368, -51.9163> }
					triangle { <-40.1778, 325.847, -51.3961>, <-34.179, 327.3368, -51.9163>, <-40.06607, 325.5064, -50.945> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-39.9978, 322.7983, -53.0163>, <-40.4568, 323.4312, -52.7424>, <-40.4049, 324.9325, -51.9237> }
					triangle { <-40.4568, 323.4312, -52.7424>, <-40.7356, 325.772, -51.5192>, <-40.4049, 324.9325, -51.9237> }
					triangle { <-40.7356, 325.772, -51.5192>, <-40.1778, 325.847, -51.3961>, <-40.4049, 324.9325, -51.9237> }
					triangle { <-40.4049, 324.9325, -51.9237>, <-40.1778, 325.847, -51.3961>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-40.7356, 325.772, -51.5192>, <-42.1125, 327.8937, -55.4622>, <-41.3677, 329.4626, -56.5127> }
					triangle { <-41.3677, 329.4626, -56.5127>, <-39.3794, 330.0474, -56.988>, <-39.4217, 329.4167, -56.4122> }
					triangle { <-39.4217, 329.4167, -56.4122>, <-40.7356, 325.772, -51.5192>, <-41.3677, 329.4626, -56.5127> }
					triangle { <-40.7356, 325.772, -51.5192>, <-39.4217, 329.4167, -56.4122>, <-40.1778, 325.847, -51.3961> }
					triangle { <-39.8422, 324.9239, -51.845>, <-39.6127, 323.4183, -52.6243>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-39.8422, 324.9239, -51.845>, <-39.6101, 325.7548, -51.3618>, <-39.6127, 323.4183, -52.6243> }
					triangle { <-39.8422, 324.9239, -51.845>, <-40.1778, 325.847, -51.3961>, <-39.6101, 325.7548, -51.3618> }
					triangle { <-39.9978, 322.7983, -53.0163>, <-40.1778, 325.847, -51.3961>, <-39.8422, 324.9239, -51.845> }
					triangle { <-37.5223, 329.4038, -55.975>, <-37.2354, 327.8191, -54.7802>, <-39.6101, 325.7548, -51.3618> }
					triangle { <-39.4217, 329.4167, -56.4122>, <-39.3794, 330.0474, -56.988>, <-37.5223, 329.4038, -55.975> }
					triangle { <-37.5223, 329.4038, -55.975>, <-39.6101, 325.7548, -51.3618>, <-39.4217, 329.4167, -56.4122> }
					triangle { <-40.1778, 325.847, -51.3961>, <-39.4217, 329.4167, -56.4122>, <-39.6101, 325.7548, -51.3618> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-39.9978, 322.7983, -53.0163>, <-40.2195, 323.2361, -52.3488>, <-40.2466, 324.8024, -51.6613> }
					triangle { <-40.2195, 323.2361, -52.3488>, <-40.4191, 325.5118, -50.9944>, <-40.2466, 324.8024, -51.6613> }
					triangle { <-40.4191, 325.5118, -50.9944>, <-40.1778, 325.847, -51.3961>, <-40.2466, 324.8024, -51.6613> }
					triangle { <-40.2466, 324.8024, -51.6613>, <-40.1778, 325.847, -51.3961>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-40.4191, 325.5118, -50.9944>, <-45.1002, 325.427, -51.1527>, <-46.4748, 326.7146, -51.9092> }
					triangle { <-46.4748, 326.7146, -51.9092>, <-46.5161, 327.874, -53.6912>, <-45.7564, 327.5138, -53.5353> }
					triangle { <-45.7564, 327.5138, -53.5353>, <-40.4191, 325.5118, -50.9944>, <-46.4748, 326.7146, -51.9092> }
					triangle { <-40.4191, 325.5118, -50.9944>, <-45.7564, 327.5138, -53.5353>, <-40.1778, 325.847, -51.3961> }
					triangle { <-40.00045, 325.054, -52.1074>, <-39.8501, 323.6135, -53.01796>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-40.00045, 325.054, -52.1074>, <-39.9266, 326.015, -51.8866>, <-39.8501, 323.6135, -53.01796> }
					triangle { <-40.00045, 325.054, -52.1074>, <-40.1778, 325.847, -51.3961>, <-39.9266, 326.015, -51.8866> }
					triangle { <-39.9978, 322.7983, -53.0163>, <-40.1778, 325.847, -51.3961>, <-40.00045, 325.054, -52.1074> }
					triangle { <-44.7922, 328.4339, -54.9575>, <-42.966, 327.6077, -55.0189>, <-39.9266, 326.015, -51.8866> }
					triangle { <-45.7564, 327.5138, -53.5353>, <-46.5161, 327.874, -53.6912>, <-44.7922, 328.4339, -54.9575> }
					triangle { <-44.7922, 328.4339, -54.9575>, <-39.9266, 326.015, -51.8866>, <-45.7564, 327.5138, -53.5353> }
					triangle { <-40.1778, 325.847, -51.3961>, <-45.7564, 327.5138, -53.5353>, <-39.9266, 326.015, -51.8866> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-39.9978, 322.7983, -53.0163>, <-39.7214, 323.3038, -52.421>, <-39.9146, 324.8476, -51.7094> }
					triangle { <-39.7214, 323.3038, -52.421>, <-39.755, 325.6022, -51.09068>, <-39.9146, 324.8476, -51.7094> }
					triangle { <-39.755, 325.6022, -51.09068>, <-40.1778, 325.847, -51.3961>, <-39.9146, 324.8476, -51.7094> }
					triangle { <-39.9146, 324.8476, -51.7094>, <-40.1778, 325.847, -51.3961>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-39.755, 325.6022, -51.09068>, <-41.2129, 323.5296, -47.1506>, <-42.8593, 323.7827, -45.9908> }
					triangle { <-42.8593, 323.7827, -45.9908>, <-44.902, 324.1305, -46.468>, <-44.3779, 324.1966, -47.1404> }
					triangle { <-44.3779, 324.1966, -47.1404>, <-39.755, 325.6022, -51.09068>, <-42.8593, 323.7827, -45.9908> }
					triangle { <-39.755, 325.6022, -51.09068>, <-44.3779, 324.1966, -47.1404>, <-40.1778, 325.847, -51.3961> }
					triangle { <-40.3324, 325.0088, -52.05931>, <-40.3481, 323.5457, -52.9457>, <-39.9978, 322.7983, -53.0163> }
					triangle { <-40.3324, 325.0088, -52.05931>, <-40.5906, 325.9247, -51.7903>, <-40.3481, 323.5457, -52.9457> }
					triangle { <-40.3324, 325.0088, -52.05931>, <-40.1778, 325.847, -51.3961>, <-40.5906, 325.9247, -51.7903> }
					triangle { <-39.9978, 322.7983, -53.0163>, <-40.1778, 325.847, -51.3961>, <-40.3324, 325.0088, -52.05931> }
					triangle { <-45.7144, 324.8846, -48.3813>, <-44.834, 324.9271, -50.1825>, <-40.5906, 325.9247, -51.7903> }
					triangle { <-44.3779, 324.1966, -47.1404>, <-44.902, 324.1305, -46.468>, <-45.7144, 324.8846, -48.3813> }
					triangle { <-45.7144, 324.8846, -48.3813>, <-40.5906, 325.9247, -51.7903>, <-44.3779, 324.1966, -47.1404> }
					triangle { <-40.1778, 325.847, -51.3961>, <-44.3779, 324.1966, -47.1404>, <-40.5906, 325.9247, -51.7903> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-31.6693, 306.8404, -62.9922>, <-33.6997, 307.8658, -62.3854>, 0.2999 }
			cylinder { <-33.6997, 307.8658, -62.3854>, <-35.7703, 308.8297, -61.8143>, 0.2999 }
			cylinder { <-35.7703, 308.8297, -61.8143>, <-37.8785, 309.7308, -61.2796>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-37.8785, 309.7308, -61.2796>, <-44.5817, 311.925, -61.6485>, 0.2999 }
				cylinder { <-44.5817, 311.925, -61.6485>, <-51.08614, 313.421, -63.9588>, 0.2999 }
				cylinder { <-51.08614, 313.421, -63.9588>, <-56.8316, 314.09, -68.01162>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-56.8316, 314.09, -68.01162>, <-57.2823, 313.8252, -68.6542>, <-58.7116, 314.0974, -69.5541> }
					triangle { <-57.2823, 313.8252, -68.6542>, <-59.3974, 313.9657, -70.2543>, <-58.7116, 314.0974, -69.5541> }
					triangle { <-59.3974, 313.9657, -70.2543>, <-59.6439, 314.4175, -69.9953>, <-58.7116, 314.0974, -69.5541> }
					triangle { <-58.7116, 314.0974, -69.5541>, <-59.6439, 314.4175, -69.9953>, <-56.8316, 314.09, -68.01162> }
					triangle { <-59.3974, 313.9657, -70.2543>, <-56.7672, 315.1026, -73.9603>, <-56.7552, 316.7118, -75.1973> }
					triangle { <-56.7552, 316.7118, -75.1973>, <-57.00117, 318.7926, -74.8352>, <-57.1861, 318.3037, -74.1585> }
					triangle { <-57.1861, 318.3037, -74.1585>, <-59.3974, 313.9657, -70.2543>, <-56.7552, 316.7118, -75.1973> }
					triangle { <-59.3974, 313.9657, -70.2543>, <-57.1861, 318.3037, -74.1585>, <-59.6439, 314.4175, -69.9953> }
					triangle { <-58.881, 314.5402, -69.2408>, <-57.5365, 314.4894, -68.1842>, <-56.8316, 314.09, -68.01162> }
					triangle { <-58.881, 314.5402, -69.2408>, <-59.7362, 314.8513, -69.6276>, <-57.5365, 314.4894, -68.1842> }
					triangle { <-58.881, 314.5402, -69.2408>, <-59.6439, 314.4175, -69.9953>, <-59.7362, 314.8513, -69.6276> }
					triangle { <-56.8316, 314.09, -68.01162>, <-59.6439, 314.4175, -69.9953>, <-58.881, 314.5402, -69.2408> }
					triangle { <-57.913, 319.7376, -73.05638>, <-58.2357, 318.9402, -71.2449>, <-59.7362, 314.8513, -69.6276> }
					triangle { <-57.1861, 318.3037, -74.1585>, <-57.00117, 318.7926, -74.8352>, <-57.913, 319.7376, -73.05638> }
					triangle { <-57.913, 319.7376, -73.05638>, <-59.7362, 314.8513, -69.6276>, <-57.1861, 318.3037, -74.1585> }
					triangle { <-59.6439, 314.4175, -69.9953>, <-57.1861, 318.3037, -74.1585>, <-59.7362, 314.8513, -69.6276> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-56.8316, 314.09, -68.01162>, <-57.5717, 313.8024, -68.2478>, <-58.9045, 314.0822, -69.2832> }
					triangle { <-57.5717, 313.8024, -68.2478>, <-59.7831, 313.9353, -69.7124>, <-58.9045, 314.0822, -69.2832> }
					triangle { <-59.7831, 313.9353, -69.7124>, <-59.6439, 314.4175, -69.9953>, <-58.9045, 314.0822, -69.2832> }
					triangle { <-58.9045, 314.0822, -69.2832>, <-59.6439, 314.4175, -69.9953>, <-56.8316, 314.09, -68.01162> }
					triangle { <-59.7831, 313.9353, -69.7124>, <-58.7249, 310.0023, -72.02703>, <-58.4315, 309.6005, -73.9948> }
					triangle { <-58.4315, 309.6005, -73.9948>, <-57.4481, 310.6792, -75.541>, <-57.553, 311.1309, -74.8226> }
					triangle { <-57.553, 311.1309, -74.8226>, <-59.7831, 313.9353, -69.7124>, <-58.4315, 309.6005, -73.9948> }
					triangle { <-59.7831, 313.9353, -69.7124>, <-57.553, 311.1309, -74.8226>, <-59.6439, 314.4175, -69.9953> }
					triangle { <-58.6882, 314.5554, -69.5117>, <-57.2472, 314.5122, -68.5906>, <-56.8316, 314.09, -68.01162> }
					triangle { <-58.6882, 314.5554, -69.5117>, <-59.3505, 314.8817, -70.1695>, <-57.2472, 314.5122, -68.5906> }
					triangle { <-58.6882, 314.5554, -69.5117>, <-59.6439, 314.4175, -69.9953>, <-59.3505, 314.8817, -70.1695> }
					triangle { <-56.8316, 314.09, -68.01162>, <-59.6439, 314.4175, -69.9953>, <-58.6882, 314.5554, -69.5117> }
					triangle { <-56.9535, 312.8343, -75.5563>, <-56.8503, 314.1037, -74.00745>, <-59.3505, 314.8817, -70.1695> }
					triangle { <-57.553, 311.1309, -74.8226>, <-57.4481, 310.6792, -75.541>, <-56.9535, 312.8343, -75.5563> }
					triangle { <-56.9535, 312.8343, -75.5563>, <-59.3505, 314.8817, -70.1695>, <-57.553, 311.1309, -74.8226> }
					triangle { <-59.6439, 314.4175, -69.9953>, <-57.553, 311.1309, -74.8226>, <-59.3505, 314.8817, -70.1695> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-56.8316, 314.09, -68.01162>, <-57.6383, 314.2667, -68.07673>, <-58.9489, 314.3918, -69.1691> }
					triangle { <-57.6383, 314.2667, -68.07673>, <-59.8719, 314.5544, -69.4843>, <-58.9489, 314.3918, -69.1691> }
					triangle { <-59.8719, 314.5544, -69.4843>, <-59.6439, 314.4175, -69.9953>, <-58.9489, 314.3918, -69.1691> }
					triangle { <-58.9489, 314.3918, -69.1691>, <-59.6439, 314.4175, -69.9953>, <-56.8316, 314.09, -68.01162> }
					triangle { <-59.8719, 314.5544, -69.4843>, <-61.9439, 310.9625, -67.3049>, <-62.7238, 309.212, -67.9738> }
					triangle { <-62.7238, 309.212, -67.9738>, <-62.07244, 307.8326, -69.4551>, <-61.6359, 308.5678, -69.4574> }
					triangle { <-61.6359, 308.5678, -69.4574>, <-59.8719, 314.5544, -69.4843>, <-62.7238, 309.212, -67.9738> }
					triangle { <-59.8719, 314.5544, -69.4843>, <-61.6359, 308.5678, -69.4574>, <-59.6439, 314.4175, -69.9953> }
					triangle { <-58.6437, 314.2458, -69.6258>, <-57.1806, 314.0479, -68.7617>, <-56.8316, 314.09, -68.01162> }
					triangle { <-58.6437, 314.2458, -69.6258>, <-59.2617, 314.2626, -70.3976>, <-57.1806, 314.0479, -68.7617> }
					triangle { <-58.6437, 314.2458, -69.6258>, <-59.6439, 314.4175, -69.9953>, <-59.2617, 314.2626, -70.3976> }
					triangle { <-56.8316, 314.09, -68.01162>, <-59.6439, 314.4175, -69.9953>, <-58.6437, 314.2458, -69.6258> }
					triangle { <-60.6387, 308.2149, -71.09449>, <-59.2994, 309.6979, -71.2627>, <-59.2617, 314.2626, -70.3976> }
					triangle { <-61.6359, 308.5678, -69.4574>, <-62.07244, 307.8326, -69.4551>, <-60.6387, 308.2149, -71.09449> }
					triangle { <-60.6387, 308.2149, -71.09449>, <-59.2617, 314.2626, -70.3976>, <-61.6359, 308.5678, -69.4574> }
					triangle { <-59.6439, 314.4175, -69.9953>, <-61.6359, 308.5678, -69.4574>, <-59.2617, 314.2626, -70.3976> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-56.8316, 314.09, -68.01162>, <-57.3908, 314.5809, -68.3757>, <-58.7839, 314.6012, -69.3685> }
					triangle { <-57.3908, 314.5809, -68.3757>, <-59.5419, 314.9733, -69.883>, <-58.7839, 314.6012, -69.3685> }
					triangle { <-59.5419, 314.9733, -69.883>, <-59.6439, 314.4175, -69.9953>, <-58.7839, 314.6012, -69.3685> }
					triangle { <-58.7839, 314.6012, -69.3685>, <-59.6439, 314.4175, -69.9953>, <-56.8316, 314.09, -68.01162> }
					triangle { <-59.5419, 314.9733, -69.883>, <-62.00587, 316.6651, -66.2758>, <-63.7403, 316.0796, -65.399> }
					triangle { <-63.7403, 316.0796, -65.399>, <-64.5266, 314.1601, -64.9314>, <-63.8306, 314.1328, -65.4274> }
					triangle { <-63.8306, 314.1328, -65.4274>, <-59.5419, 314.9733, -69.883>, <-63.7403, 316.0796, -65.399> }
					triangle { <-59.5419, 314.9733, -69.883>, <-63.8306, 314.1328, -65.4274>, <-59.6439, 314.4175, -69.9953> }
					triangle { <-58.8087, 314.0364, -69.4265>, <-57.4281, 313.7337, -68.4627>, <-56.8316, 314.09, -68.01162> }
					triangle { <-58.8087, 314.0364, -69.4265>, <-59.5917, 313.8437, -69.9989>, <-57.4281, 313.7337, -68.4627> }
					triangle { <-58.8087, 314.0364, -69.4265>, <-59.6439, 314.4175, -69.9953>, <-59.5917, 313.8437, -69.9989> }
					triangle { <-56.8316, 314.09, -68.01162>, <-59.6439, 314.4175, -69.9953>, <-58.8087, 314.0364, -69.4265> }
					triangle { <-63.9102, 312.2203, -65.7953>, <-62.2213, 311.7704, -66.7783>, <-59.5917, 313.8437, -69.9989> }
					triangle { <-63.8306, 314.1328, -65.4274>, <-64.5266, 314.1601, -64.9314>, <-63.9102, 312.2203, -65.7953> }
					triangle { <-63.9102, 312.2203, -65.7953>, <-59.5917, 313.8437, -69.9989>, <-63.8306, 314.1328, -65.4274> }
					triangle { <-59.6439, 314.4175, -69.9953>, <-63.8306, 314.1328, -65.4274>, <-59.5917, 313.8437, -69.9989> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-56.8316, 314.09, -68.01162>, <-57.1675, 314.3039, -68.738>, <-58.635, 314.4165, -69.61> }
					triangle { <-57.1675, 314.3039, -68.738>, <-59.2442, 314.6039, -70.366>, <-58.635, 314.4165, -69.61> }
					triangle { <-59.2442, 314.6039, -70.366>, <-59.6439, 314.4175, -69.9953>, <-58.635, 314.4165, -69.61> }
					triangle { <-58.635, 314.4165, -69.61>, <-59.6439, 314.4175, -69.9953>, <-56.8316, 314.09, -68.01162> }
					triangle { <-59.2442, 314.6039, -70.366>, <-58.7581, 319.2624, -70.4511>, <-59.9958, 320.7847, -69.9308> }
					triangle { <-59.9958, 320.7847, -69.9308>, <-61.345, 321.036, -68.3067>, <-61.03898, 320.2407, -68.3767> }
					triangle { <-61.03898, 320.2407, -68.3767>, <-59.2442, 314.6039, -70.366>, <-59.9958, 320.7847, -69.9308> }
					triangle { <-59.2442, 314.6039, -70.366>, <-61.03898, 320.2407, -68.3767>, <-59.6439, 314.4175, -69.9953> }
					triangle { <-58.9576, 314.2211, -69.1849>, <-57.6514, 314.0107, -68.1004>, <-56.8316, 314.09, -68.01162> }
					triangle { <-58.9576, 314.2211, -69.1849>, <-59.8894, 314.2131, -69.5159>, <-57.6514, 314.0107, -68.1004> }
					triangle { <-58.9576, 314.2211, -69.1849>, <-59.6439, 314.4175, -69.9953>, <-59.8894, 314.2131, -69.5159> }
					triangle { <-56.8316, 314.09, -68.01162>, <-59.6439, 314.4175, -69.9953>, <-58.9576, 314.2211, -69.1849> }
					triangle { <-62.2002, 319.4492, -67.02616>, <-61.554, 317.5686, -66.7672>, <-59.8894, 314.2131, -69.5159> }
					triangle { <-61.03898, 320.2407, -68.3767>, <-61.345, 321.036, -68.3067>, <-62.2002, 319.4492, -67.02616> }
					triangle { <-62.2002, 319.4492, -67.02616>, <-59.8894, 314.2131, -69.5159>, <-61.03898, 320.2407, -68.3767> }
					triangle { <-59.6439, 314.4175, -69.9953>, <-61.03898, 320.2407, -68.3767>, <-59.8894, 314.2131, -69.5159> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-37.8785, 309.7308, -61.2796>, <-39.9583, 310.6506, -60.6705>, 0.2999 }
			cylinder { <-39.9583, 310.6506, -60.6705>, <-42.00726, 311.588, -59.9879>, 0.2999 }
			cylinder { <-42.00726, 311.588, -59.9879>, <-44.02277, 312.5418, -59.2326>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-44.02277, 312.5418, -59.2326>, <-49.6247, 314.2657, -55.292>, 0.2999 }
				cylinder { <-49.6247, 314.2657, -55.292>, <-54.2997, 314.7036, -50.01611>, 0.2999 }
				cylinder { <-54.2997, 314.7036, -50.01611>, <-57.6452, 313.8179, -43.8593>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-57.6452, 313.8179, -43.8593>, <-57.7006, 313.5995, -43.06214>, <-58.7737, 313.4248, -41.7413> }
					triangle { <-57.7006, 313.5995, -43.06214>, <-59.07694, 313.2188, -40.8229>, <-58.7737, 313.4248, -41.7413> }
					triangle { <-59.07694, 313.2188, -40.8229>, <-59.5888, 313.3773, -41.03446>, <-58.7737, 313.4248, -41.7413> }
					triangle { <-58.7737, 313.4248, -41.7413>, <-59.5888, 313.3773, -41.03446>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-59.07694, 313.2188, -40.8229>, <-58.3323, 308.5948, -40.9158>, <-59.5864, 307.0003, -40.9841> }
					triangle { <-59.5864, 307.0003, -40.9841>, <-61.3926, 306.6494, -42.04978>, <-61.1258, 307.4608, -42.08738> }
					triangle { <-61.1258, 307.4608, -42.08738>, <-59.07694, 313.2188, -40.8229>, <-59.5864, 307.0003, -40.9841> }
					triangle { <-59.07694, 313.2188, -40.8229>, <-61.1258, 307.4608, -42.08738>, <-59.5888, 313.3773, -41.03446> }
					triangle { <-59.2324, 313.5954, -42.03027>, <-58.3886, 313.8553, -43.4955>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-59.2324, 313.5954, -42.03027>, <-59.9942, 313.56, -41.4008>, <-58.3886, 313.8553, -43.4955> }
					triangle { <-59.2324, 313.5954, -42.03027>, <-59.5888, 313.3773, -41.03446>, <-59.9942, 313.56, -41.4008> }
					triangle { <-57.6452, 313.8179, -43.8593>, <-59.5888, 313.3773, -41.03446>, <-59.2324, 313.5954, -42.03027> }
					triangle { <-62.7204, 308.1659, -42.9586>, <-62.3072, 310.0731, -43.4201>, <-59.9942, 313.56, -41.4008> }
					triangle { <-61.1258, 307.4608, -42.08738>, <-61.3926, 306.6494, -42.04978>, <-62.7204, 308.1659, -42.9586> }
					triangle { <-62.7204, 308.1659, -42.9586>, <-59.9942, 313.56, -41.4008>, <-61.1258, 307.4608, -42.08738> }
					triangle { <-59.5888, 313.3773, -41.03446>, <-61.1258, 307.4608, -42.08738>, <-59.9942, 313.56, -41.4008> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-57.6452, 313.8179, -43.8593>, <-57.8636, 314.0698, -43.1009>, <-58.8824, 313.7384, -41.7671> }
					triangle { <-57.8636, 314.0698, -43.1009>, <-59.2943, 313.846, -40.8746>, <-58.8824, 313.7384, -41.7671> }
					triangle { <-59.2943, 313.846, -40.8746>, <-59.5888, 313.3773, -41.03446>, <-58.8824, 313.7384, -41.7671> }
					triangle { <-58.8824, 313.7384, -41.7671>, <-59.5888, 313.3773, -41.03446>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-59.2943, 313.846, -40.8746>, <-55.4983, 312.9154, -38.2921>, <-54.9752, 311.3312, -37.136> }
					triangle { <-54.9752, 311.3312, -37.136>, <-55.2137, 309.2342, -37.3953>, <-55.6454, 309.7006, -37.9674> }
					triangle { <-55.6454, 309.7006, -37.9674>, <-59.2943, 313.846, -40.8746>, <-54.9752, 311.3312, -37.136> }
					triangle { <-59.2943, 313.846, -40.8746>, <-55.6454, 309.7006, -37.9674>, <-59.5888, 313.3773, -41.03446> }
					triangle { <-59.1237, 313.2818, -42.00438>, <-58.2255, 313.3849, -43.4567>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-59.1237, 313.2818, -42.00438>, <-59.7768, 312.9328, -41.349>, <-58.2255, 313.3849, -43.4567> }
					triangle { <-59.1237, 313.2818, -42.00438>, <-59.5888, 313.3773, -41.03446>, <-59.7768, 312.9328, -41.349> }
					triangle { <-57.6452, 313.8179, -43.8593>, <-59.5888, 313.3773, -41.03446>, <-59.1237, 313.2818, -42.00438> }
					triangle { <-56.6237, 308.2111, -38.7569>, <-57.5891, 308.9582, -40.3478>, <-59.7768, 312.9328, -41.349> }
					triangle { <-55.6454, 309.7006, -37.9674>, <-55.2137, 309.2342, -37.3953>, <-56.6237, 308.2111, -38.7569> }
					triangle { <-56.6237, 308.2111, -38.7569>, <-59.7768, 312.9328, -41.349>, <-55.6454, 309.7006, -37.9674> }
					triangle { <-59.5888, 313.3773, -41.03446>, <-55.6454, 309.7006, -37.9674>, <-59.7768, 312.9328, -41.349> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-57.6452, 313.8179, -43.8593>, <-58.275, 314.0702, -43.3839>, <-59.1567, 313.7386, -41.9558> }
					triangle { <-58.275, 314.0702, -43.3839>, <-59.8428, 313.8464, -41.252>, <-59.1567, 313.7386, -41.9558> }
					triangle { <-59.8428, 313.8464, -41.252>, <-59.5888, 313.3773, -41.03446>, <-59.1567, 313.7386, -41.9558> }
					triangle { <-59.1567, 313.7386, -41.9558>, <-59.5888, 313.3773, -41.03446>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-59.8428, 313.8464, -41.252>, <-58.2791, 317.8701, -39.4326>, <-57.3547, 318.3216, -37.683> }
					triangle { <-57.3547, 318.3216, -37.683>, <-55.8442, 317.3239, -36.5675>, <-56.1626, 316.8546, -37.2075> }
					triangle { <-56.1626, 316.8546, -37.2075>, <-59.8428, 313.8464, -41.252>, <-57.3547, 318.3216, -37.683> }
					triangle { <-59.8428, 313.8464, -41.252>, <-56.1626, 316.8546, -37.2075>, <-59.5888, 313.3773, -41.03446> }
					triangle { <-58.8494, 313.2816, -41.8157>, <-57.8141, 313.3846, -43.1737>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-58.8494, 313.2816, -41.8157>, <-59.2282, 312.9324, -40.9717>, <-57.8141, 313.3846, -43.1737> }
					triangle { <-58.8494, 313.2816, -41.8157>, <-59.5888, 313.3773, -41.03446>, <-59.2282, 312.9324, -40.9717> }
					triangle { <-57.6452, 313.8179, -43.8593>, <-59.5888, 313.3773, -41.03446>, <-58.8494, 313.2816, -41.8157> }
					triangle { <-55.2548, 315.1986, -36.7252>, <-55.6159, 313.9092, -38.218>, <-59.2282, 312.9324, -40.9717> }
					triangle { <-56.1626, 316.8546, -37.2075>, <-55.8442, 317.3239, -36.5675>, <-55.2548, 315.1986, -36.7252> }
					triangle { <-55.2548, 315.1986, -36.7252>, <-59.2282, 312.9324, -40.9717>, <-56.1626, 316.8546, -37.2075> }
					triangle { <-59.5888, 313.3773, -41.03446>, <-56.1626, 316.8546, -37.2075>, <-59.2282, 312.9324, -40.9717> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-57.6452, 313.8179, -43.8593>, <-58.3701, 313.6, -43.5227>, <-59.2201, 313.4252, -42.04835> }
					triangle { <-58.3701, 313.6, -43.5227>, <-59.9696, 313.2195, -41.4369>, <-59.2201, 313.4252, -42.04835> }
					triangle { <-59.9696, 313.2195, -41.4369>, <-59.5888, 313.3773, -41.03446>, <-59.2201, 313.4252, -42.04835> }
					triangle { <-59.2201, 313.4252, -42.04835>, <-59.5888, 313.3773, -41.03446>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-59.9696, 313.2195, -41.4369>, <-62.8576, 316.6579, -42.7719>, <-63.4586, 318.3763, -41.8741> }
					triangle { <-63.4586, 318.3763, -41.8741>, <-62.4187, 319.8141, -40.7026>, <-61.9674, 319.1031, -40.8507> }
					triangle { <-61.9674, 319.1031, -40.8507>, <-59.9696, 313.2195, -41.4369>, <-63.4586, 318.3763, -41.8741> }
					triangle { <-59.9696, 313.2195, -41.4369>, <-61.9674, 319.1031, -40.8507>, <-59.5888, 313.3773, -41.03446> }
					triangle { <-58.786, 313.5951, -41.7232>, <-57.719, 313.8548, -43.03502>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-58.786, 313.5951, -41.7232>, <-59.1015, 313.5593, -40.7867>, <-57.719, 313.8548, -43.03502> }
					triangle { <-58.786, 313.5951, -41.7232>, <-59.5888, 313.3773, -41.03446>, <-59.1015, 313.5593, -40.7867> }
					triangle { <-57.6452, 313.8179, -43.8593>, <-59.5888, 313.3773, -41.03446>, <-58.786, 313.5951, -41.7232> }
					triangle { <-60.4927, 319.5371, -39.6525>, <-59.09602, 318.1302, -39.9541>, <-59.1015, 313.5593, -40.7867> }
					triangle { <-61.9674, 319.1031, -40.8507>, <-62.4187, 319.8141, -40.7026>, <-60.4927, 319.5371, -39.6525> }
					triangle { <-60.4927, 319.5371, -39.6525>, <-59.1015, 313.5593, -40.7867>, <-61.9674, 319.1031, -40.8507> }
					triangle { <-59.5888, 313.3773, -41.03446>, <-61.9674, 319.1031, -40.8507>, <-59.1015, 313.5593, -40.7867> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-57.6452, 313.8179, -43.8593>, <-58.00974, 313.3047, -43.3208>, <-58.9798, 313.2283, -41.9137> }
					triangle { <-58.00974, 313.3047, -43.3208>, <-59.489, 312.8258, -41.1677>, <-58.9798, 313.2283, -41.9137> }
					triangle { <-59.489, 312.8258, -41.1677>, <-59.5888, 313.3773, -41.03446>, <-58.9798, 313.2283, -41.9137> }
					triangle { <-58.9798, 313.2283, -41.9137>, <-59.5888, 313.3773, -41.03446>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-59.489, 312.8258, -41.1677>, <-62.891, 310.8389, -43.7023>, <-64.8587, 311.2737, -43.9451> }
					triangle { <-64.8587, 311.2737, -43.9451>, <-65.8996, 313.1173, -44.142>, <-65.08121, 313.2098, -43.9122> }
					triangle { <-65.08121, 313.2098, -43.9122>, <-59.489, 312.8258, -41.1677>, <-64.8587, 311.2737, -43.9451> }
					triangle { <-59.489, 312.8258, -41.1677>, <-65.08121, 313.2098, -43.9122>, <-59.5888, 313.3773, -41.03446> }
					triangle { <-59.02634, 313.7919, -41.8578>, <-58.07948, 314.1501, -43.2369>, <-57.6452, 313.8179, -43.8593> }
					triangle { <-59.02634, 313.7919, -41.8578>, <-59.582, 313.953, -41.05594>, <-58.07948, 314.1501, -43.2369> }
					triangle { <-59.02634, 313.7919, -41.8578>, <-59.5888, 313.3773, -41.03446>, <-59.582, 313.953, -41.05594> }
					triangle { <-57.6452, 313.8179, -43.8593>, <-59.5888, 313.3773, -41.03446>, <-59.02634, 313.7919, -41.8578> }
					triangle { <-65.1763, 315.125, -43.5631>, <-63.2939, 315.7236, -43.2177>, <-59.582, 313.953, -41.05594> }
					triangle { <-65.08121, 313.2098, -43.9122>, <-65.8996, 313.1173, -44.142>, <-65.1763, 315.125, -43.5631> }
					triangle { <-65.1763, 315.125, -43.5631>, <-59.582, 313.953, -41.05594>, <-65.08121, 313.2098, -43.9122> }
					triangle { <-59.5888, 313.3773, -41.03446>, <-65.08121, 313.2098, -43.9122>, <-59.582, 313.953, -41.05594> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-44.02277, 312.5418, -59.2326>, <-46.04642, 313.5323, -58.5498>, 0.2999 }
			cylinder { <-46.04642, 313.5323, -58.5498>, <-48.07578, 314.5584, -57.9403>, 0.2999 }
			cylinder { <-48.07578, 314.5584, -57.9403>, <-50.1083, 315.6188, -57.405>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-50.1083, 315.6188, -57.405>, <-55.2486, 320.4089, -56.6879>, 0.2999 }
				cylinder { <-55.2486, 320.4089, -56.6879>, <-58.9888, 326.3955, -56.9215>, 0.2999 }
				cylinder { <-58.9888, 326.3955, -56.9215>, <-61.00673, 333.063, -58.0859>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-61.00673, 333.063, -58.0859>, <-60.9453, 333.7553, -58.5366>, <-61.5205, 335.3575, -58.7064> }
					triangle { <-60.9453, 333.7553, -58.5366>, <-61.6149, 336.2662, -59.08507>, <-61.5205, 335.3575, -58.7064> }
					triangle { <-61.6149, 336.2662, -59.08507>, <-61.9944, 336.3266, -58.6558>, <-61.5205, 335.3575, -58.7064> }
					triangle { <-61.5205, 335.3575, -58.7064>, <-61.9944, 336.3266, -58.6558>, <-61.00673, 333.063, -58.0859> }
					triangle { <-61.6149, 336.2662, -59.08507>, <-57.3239, 337.8436, -58.06338>, <-56.6397, 339.1904, -56.7077> }
					triangle { <-56.6397, 339.1904, -56.7077>, <-57.1765, 339.5813, -54.6877>, <-57.7129, 339.0483, -55.08687> }
					triangle { <-57.7129, 339.0483, -55.08687>, <-61.6149, 336.2662, -59.08507>, <-56.6397, 339.1904, -56.7077> }
					triangle { <-61.6149, 336.2662, -59.08507>, <-57.7129, 339.0483, -55.08687>, <-61.9944, 336.3266, -58.6558> }
					triangle { <-61.8729, 335.3286, -58.2616>, <-61.474, 333.7119, -57.8693>, <-61.00673, 333.063, -58.0859> }
					triangle { <-61.8729, 335.3286, -58.2616>, <-62.3198, 336.2082, -58.1953>, <-61.474, 333.7119, -57.8693> }
					triangle { <-61.8729, 335.3286, -58.2616>, <-61.9944, 336.3266, -58.6558>, <-62.3198, 336.2082, -58.1953> }
					triangle { <-61.00673, 333.063, -58.0859>, <-61.9944, 336.3266, -58.6558>, <-61.8729, 335.3286, -58.2616> }
					triangle { <-59.04792, 338.9924, -53.6677>, <-60.3782, 337.5925, -54.2078>, <-62.3198, 336.2082, -58.1953> }
					triangle { <-57.7129, 339.0483, -55.08687>, <-57.1765, 339.5813, -54.6877>, <-59.04792, 338.9924, -53.6677> }
					triangle { <-59.04792, 338.9924, -53.6677>, <-62.3198, 336.2082, -58.1953>, <-57.7129, 339.0483, -55.08687> }
					triangle { <-61.9944, 336.3266, -58.6558>, <-57.7129, 339.0483, -55.08687>, <-62.3198, 336.2082, -58.1953> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-61.00673, 333.063, -58.0859>, <-61.4224, 333.6086, -58.5504>, <-61.8386, 335.2597, -58.7157> }
					triangle { <-61.4224, 333.6086, -58.5504>, <-62.251, 336.0704, -59.1035>, <-61.8386, 335.2597, -58.7157> }
					triangle { <-62.251, 336.0704, -59.1035>, <-61.9944, 336.3266, -58.6558>, <-61.8386, 335.2597, -58.7157> }
					triangle { <-61.8386, 335.2597, -58.7157>, <-61.9944, 336.3266, -58.6558>, <-61.00673, 333.063, -58.0859> }
					triangle { <-62.251, 336.0704, -59.1035>, <-59.7609, 336.2321, -63.06807>, <-58.2874, 337.4675, -63.7179> }
					triangle { <-58.2874, 337.4675, -63.7179>, <-56.621, 338.3449, -62.7305>, <-57.1748, 337.9693, -62.1982> }
					triangle { <-57.1748, 337.9693, -62.1982>, <-62.251, 336.0704, -59.1035>, <-58.2874, 337.4675, -63.7179> }
					triangle { <-62.251, 336.0704, -59.1035>, <-57.1748, 337.9693, -62.1982>, <-61.9944, 336.3266, -58.6558> }
					triangle { <-61.5549, 335.4265, -58.2524>, <-60.9969, 333.8587, -57.8555>, <-61.00673, 333.063, -58.0859> }
					triangle { <-61.5549, 335.4265, -58.2524>, <-61.6837, 336.404, -58.1768>, <-60.9969, 333.8587, -57.8555> }
					triangle { <-61.5549, 335.4265, -58.2524>, <-61.9944, 336.3266, -58.6558>, <-61.6837, 336.404, -58.1768> }
					triangle { <-61.00673, 333.063, -58.0859>, <-61.9944, 336.3266, -58.6558>, <-61.5549, 335.4265, -58.2524> }
					triangle { <-56.3488, 338.6071, -60.552>, <-57.3022, 337.6774, -59.05271>, <-61.6837, 336.404, -58.1768> }
					triangle { <-57.1748, 337.9693, -62.1982>, <-56.621, 338.3449, -62.7305>, <-56.3488, 338.6071, -60.552> }
					triangle { <-56.3488, 338.6071, -60.552>, <-61.6837, 336.404, -58.1768>, <-57.1748, 337.9693, -62.1982> }
					triangle { <-61.9944, 336.3266, -58.6558>, <-57.1748, 337.9693, -62.1982>, <-61.6837, 336.404, -58.1768> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-61.00673, 333.063, -58.0859>, <-61.6074, 333.6334, -58.08735>, <-61.9619, 335.2763, -58.4069> }
					triangle { <-61.6074, 333.6334, -58.08735>, <-62.4977, 336.1036, -58.4859>, <-61.9619, 335.2763, -58.4069> }
					triangle { <-62.4977, 336.1036, -58.4859>, <-61.9944, 336.3266, -58.6558>, <-61.9619, 335.2763, -58.4069> }
					triangle { <-61.9619, 335.2763, -58.4069>, <-61.9944, 336.3266, -58.6558>, <-61.00673, 333.063, -58.0859> }
					triangle { <-62.4977, 336.1036, -58.4859>, <-65.2637, 334.7503, -62.01633>, <-65.3578, 335.2832, -63.9726> }
					triangle { <-65.3578, 335.2832, -63.9726>, <-63.8498, 335.6882, -65.416>, <-63.5494, 335.6174, -64.6186> }
					triangle { <-63.5494, 335.6174, -64.6186>, <-62.4977, 336.1036, -58.4859>, <-65.3578, 335.2832, -63.9726> }
					triangle { <-62.4977, 336.1036, -58.4859>, <-63.5494, 335.6174, -64.6186>, <-61.9944, 336.3266, -58.6558> }
					triangle { <-61.4315, 335.4099, -58.5611>, <-60.8118, 333.8338, -58.3186>, <-61.00673, 333.063, -58.0859> }
					triangle { <-61.4315, 335.4099, -58.5611>, <-61.4369, 336.3708, -58.7944>, <-60.8118, 333.8338, -58.3186> }
					triangle { <-61.4315, 335.4099, -58.5611>, <-61.9944, 336.3266, -58.6558>, <-61.4369, 336.3708, -58.7944> }
					triangle { <-61.00673, 333.063, -58.0859>, <-61.9944, 336.3266, -58.6558>, <-61.4315, 335.4099, -58.5611> }
					triangle { <-61.7334, 336.1961, -65.02637>, <-60.6669, 335.9081, -63.3528>, <-61.4369, 336.3708, -58.7944> }
					triangle { <-63.5494, 335.6174, -64.6186>, <-63.8498, 335.6882, -65.416>, <-61.7334, 336.1961, -65.02637> }
					triangle { <-61.7334, 336.1961, -65.02637>, <-61.4369, 336.3708, -58.7944>, <-63.5494, 335.6174, -64.6186> }
					triangle { <-61.9944, 336.3266, -58.6558>, <-63.5494, 335.6174, -64.6186>, <-61.4369, 336.3708, -58.7944> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-61.00673, 333.063, -58.0859>, <-61.2464, 333.7958, -57.7829>, <-61.7213, 335.3845, -58.204> }
					triangle { <-61.2464, 333.7958, -57.7829>, <-62.01645, 336.3202, -58.08014>, <-61.7213, 335.3845, -58.204> }
					triangle { <-62.01645, 336.3202, -58.08014>, <-61.9944, 336.3266, -58.6558>, <-61.7213, 335.3845, -58.204> }
					triangle { <-61.7213, 335.3845, -58.204>, <-61.9944, 336.3266, -58.6558>, <-61.00673, 333.063, -58.0859> }
					triangle { <-62.01645, 336.3202, -58.08014>, <-66.279, 335.4323, -56.3518>, <-68.1458, 335.6357, -57.1221> }
					triangle { <-68.1458, 335.6357, -57.1221>, <-68.9404, 335.2578, -59.05788>, <-68.08677, 335.2208, -59.02568> }
					triangle { <-68.08677, 335.2208, -59.02568>, <-62.01645, 336.3202, -58.08014>, <-68.1458, 335.6357, -57.1221> }
					triangle { <-62.01645, 336.3202, -58.08014>, <-68.08677, 335.2208, -59.02568>, <-61.9944, 336.3266, -58.6558> }
					triangle { <-61.6722, 335.3016, -58.764>, <-61.1728, 333.6714, -58.623>, <-61.00673, 333.063, -58.0859> }
					triangle { <-61.6722, 335.3016, -58.764>, <-61.9183, 336.1542, -59.2002>, <-61.1728, 333.6714, -58.623> }
					triangle { <-61.6722, 335.3016, -58.764>, <-61.9944, 336.3266, -58.6558>, <-61.9183, 336.1542, -59.2002> }
					triangle { <-61.00673, 333.063, -58.0859>, <-61.9944, 336.3266, -58.6558>, <-61.6722, 335.3016, -58.764> }
					triangle { <-67.8106, 335.0688, -60.9491>, <-65.8538, 334.7133, -61.2056>, <-61.9183, 336.1542, -59.2002> }
					triangle { <-68.08677, 335.2208, -59.02568>, <-68.9404, 335.2578, -59.05788>, <-67.8106, 335.0688, -60.9491> }
					triangle { <-67.8106, 335.0688, -60.9491>, <-61.9183, 336.1542, -59.2002>, <-68.08677, 335.2208, -59.02568> }
					triangle { <-61.9944, 336.3266, -58.6558>, <-68.08677, 335.2208, -59.02568>, <-61.9183, 336.1542, -59.2002> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-61.00673, 333.063, -58.0859>, <-60.8311, 333.8723, -58.06484>, <-61.4443, 335.4355, -58.3919> }
					triangle { <-60.8311, 333.8723, -58.06484>, <-61.4626, 336.4221, -58.4559>, <-61.4443, 335.4355, -58.3919> }
					triangle { <-61.4626, 336.4221, -58.4559>, <-61.9944, 336.3266, -58.6558>, <-61.4443, 335.4355, -58.3919> }
					triangle { <-61.4443, 335.4355, -58.3919>, <-61.9944, 336.3266, -58.6558>, <-61.00673, 333.063, -58.0859> }
					triangle { <-61.4626, 336.4221, -58.4559>, <-61.2979, 337.3728, -53.8718>, <-62.6764, 338.0869, -52.5643> }
					triangle { <-62.6764, 338.0869, -52.5643>, <-64.7538, 337.7002, -52.3273>, <-64.4251, 337.3733, -53.04582> }
					triangle { <-64.4251, 337.3733, -53.04582>, <-61.4626, 336.4221, -58.4559>, <-62.6764, 338.0869, -52.5643> }
					triangle { <-61.4626, 336.4221, -58.4559>, <-64.4251, 337.3733, -53.04582>, <-61.9944, 336.3266, -58.6558> }
					triangle { <-61.9491, 335.2506, -58.5761>, <-61.5882, 333.5949, -58.3411>, <-61.00673, 333.063, -58.0859> }
					triangle { <-61.9491, 335.2506, -58.5761>, <-62.4721, 336.0522, -58.8244>, <-61.5882, 333.5949, -58.3411> }
					triangle { <-61.9491, 335.2506, -58.5761>, <-61.9944, 336.3266, -58.6558>, <-62.4721, 336.0522, -58.8244> }
					triangle { <-61.00673, 333.063, -58.0859>, <-61.9944, 336.3266, -58.6558>, <-61.9491, 335.2506, -58.5761> }
					triangle { <-66.1258, 336.8231, -53.8231>, <-65.6727, 335.77, -55.4684>, <-62.4721, 336.0522, -58.8244> }
					triangle { <-64.4251, 337.3733, -53.04582>, <-64.7538, 337.7002, -52.3273>, <-66.1258, 336.8231, -53.8231> }
					triangle { <-66.1258, 336.8231, -53.8231>, <-62.4721, 336.0522, -58.8244>, <-64.4251, 337.3733, -53.04582> }
					triangle { <-61.9944, 336.3266, -58.6558>, <-64.4251, 337.3733, -53.04582>, <-62.4721, 336.0522, -58.8244> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-50.1083, 315.6188, -57.405>, <-52.1659, 316.6101, -56.8337>, 0.2999 }
			cylinder { <-52.1659, 316.6101, -56.8337>, <-54.2459, 317.5312, -56.2273>, 0.2999 }
			cylinder { <-54.2459, 317.5312, -56.2273>, <-56.3458, 318.381, -55.5866>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-56.3458, 318.381, -55.5866>, <-63.2716, 319.0969, -54.4015>, 0.2999 }
				cylinder { <-63.2716, 319.0969, -54.4015>, <-70.2267, 317.9179, -54.05572>, 0.2999 }
				cylinder { <-70.2267, 317.9179, -54.05572>, <-76.6122, 314.9456, -54.579>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-76.6122, 314.9456, -54.579>, <-77.09645, 314.3201, -54.6503>, <-78.6633, 313.8598, -54.8033> }
					triangle { <-77.09645, 314.3201, -54.6503>, <-79.4077, 313.2796, -54.8939>, <-78.6633, 313.8598, -54.8033> }
					triangle { <-79.4077, 313.2796, -54.8939>, <-79.6894, 313.7548, -54.8936>, <-78.6633, 313.8598, -54.8033> }
					triangle { <-78.6633, 313.8598, -54.8033>, <-79.6894, 313.7548, -54.8936>, <-76.6122, 314.9456, -54.579> }
					triangle { <-79.4077, 313.2796, -54.8939>, <-78.4801, 311.7149, -59.00061>, <-79.2975, 312.0124, -60.7414> }
					triangle { <-79.2975, 312.0124, -60.7414>, <-80.04922, 313.6848, -61.6328>, <-79.8765, 313.7866, -60.8379> }
					triangle { <-79.8765, 313.7866, -60.8379>, <-79.4077, 313.2796, -54.8939>, <-79.2975, 312.0124, -60.7414> }
					triangle { <-79.4077, 313.2796, -54.8939>, <-79.8765, 313.7866, -60.8379>, <-79.6894, 313.7548, -54.8936> }
					triangle { <-78.8607, 314.3676, -54.7943>, <-77.3925, 315.0818, -54.6369>, <-76.6122, 314.9456, -54.579> }
					triangle { <-78.8607, 314.3676, -54.7943>, <-79.8025, 314.2952, -54.8761>, <-77.3925, 315.0818, -54.6369> }
					triangle { <-78.8607, 314.3676, -54.7943>, <-79.6894, 313.7548, -54.8936>, <-79.8025, 314.2952, -54.8761> }
					triangle { <-76.6122, 314.9456, -54.579>, <-79.6894, 313.7548, -54.8936>, <-78.8607, 314.3676, -54.7943> }
					triangle { <-80.6465, 315.4821, -60.6804>, <-80.191, 316.1155, -58.9231>, <-79.8025, 314.2952, -54.8761> }
					triangle { <-79.8765, 313.7866, -60.8379>, <-80.04922, 313.6848, -61.6328>, <-80.6465, 315.4821, -60.6804> }
					triangle { <-80.6465, 315.4821, -60.6804>, <-79.8025, 314.2952, -54.8761>, <-79.8765, 313.7866, -60.8379> }
					triangle { <-79.6894, 313.7548, -54.8936>, <-79.8765, 313.7866, -60.8379>, <-79.8025, 314.2952, -54.8761> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-76.6122, 314.9456, -54.579>, <-77.2301, 314.5622, -54.2595>, <-78.7524, 314.0212, -54.5427> }
					triangle { <-77.2301, 314.5622, -54.2595>, <-79.5859, 313.6024, -54.3728>, <-78.7524, 314.0212, -54.5427> }
					triangle { <-79.5859, 313.6024, -54.3728>, <-79.6894, 313.7548, -54.8936>, <-78.7524, 314.0212, -54.5427> }
					triangle { <-78.7524, 314.0212, -54.5427>, <-79.6894, 313.7548, -54.8936>, <-76.6122, 314.9456, -54.579> }
					triangle { <-79.5859, 313.6024, -54.3728>, <-78.09294, 309.3855, -53.9711>, <-78.2494, 307.8163, -55.1115> }
					triangle { <-78.2494, 307.8163, -55.1115>, <-78.1461, 307.5781, -57.1336>, <-78.1803, 308.3624, -56.8974> }
					triangle { <-78.1803, 308.3624, -56.8974>, <-79.5859, 313.6024, -54.3728>, <-78.2494, 307.8163, -55.1115> }
					triangle { <-79.5859, 313.6024, -54.3728>, <-78.1803, 308.3624, -56.8974>, <-79.6894, 313.7548, -54.8936> }
					triangle { <-78.7716, 314.2061, -55.05491>, <-77.2589, 314.8396, -55.02778>, <-76.6122, 314.9456, -54.579> }
					triangle { <-78.7716, 314.2061, -55.05491>, <-79.6243, 313.9724, -55.3972>, <-77.2589, 314.8396, -55.02778> }
					triangle { <-78.7716, 314.2061, -55.05491>, <-79.6894, 313.7548, -54.8936>, <-79.6243, 313.9724, -55.3972> }
					triangle { <-76.6122, 314.9456, -54.579>, <-79.6894, 313.7548, -54.8936>, <-78.7716, 314.2061, -55.05491> }
					triangle { <-78.3806, 309.0801, -58.6113>, <-78.2593, 310.9883, -58.4098>, <-79.6243, 313.9724, -55.3972> }
					triangle { <-78.1803, 308.3624, -56.8974>, <-78.1461, 307.5781, -57.1336>, <-78.3806, 309.0801, -58.6113> }
					triangle { <-78.3806, 309.0801, -58.6113>, <-79.6243, 313.9724, -55.3972>, <-78.1803, 308.3624, -56.8974> }
					triangle { <-79.6894, 313.7548, -54.8936>, <-78.1803, 308.3624, -56.8974>, <-79.6243, 313.9724, -55.3972> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-76.6122, 314.9456, -54.579>, <-77.3835, 314.9947, -54.3959>, <-78.8547, 314.3095, -54.6337> }
					triangle { <-77.3835, 314.9947, -54.3959>, <-79.7905, 314.1791, -54.5548>, <-78.8547, 314.3095, -54.6337> }
					triangle { <-79.7905, 314.1791, -54.5548>, <-79.6894, 313.7548, -54.8936>, <-78.8547, 314.3095, -54.6337> }
					triangle { <-78.8547, 314.3095, -54.6337>, <-79.6894, 313.7548, -54.8936>, <-76.6122, 314.9456, -54.579> }
					triangle { <-79.7905, 314.1791, -54.5548>, <-79.8972, 313.0535, -50.2079>, <-80.2194, 311.3686, -49.289> }
					triangle { <-80.2194, 311.3686, -49.289>, <-79.6344, 309.4572, -49.6899>, <-79.4814, 309.9817, -50.3012> }
					triangle { <-79.4814, 309.9817, -50.3012>, <-79.7905, 314.1791, -54.5548>, <-80.2194, 311.3686, -49.289> }
					triangle { <-79.7905, 314.1791, -54.5548>, <-79.4814, 309.9817, -50.3012>, <-79.6894, 313.7548, -54.8936> }
					triangle { <-78.6693, 313.9178, -54.9639>, <-77.1054, 314.4071, -54.8913>, <-76.6122, 314.9456, -54.579> }
					triangle { <-78.6693, 313.9178, -54.9639>, <-79.4197, 313.3957, -55.2152>, <-77.1054, 314.4071, -54.8913> }
					triangle { <-78.6693, 313.9178, -54.9639>, <-79.6894, 313.7548, -54.8936>, <-79.4197, 313.3957, -55.2152> }
					triangle { <-76.6122, 314.9456, -54.579>, <-79.6894, 313.7548, -54.8936>, <-78.6693, 313.9178, -54.9639> }
					triangle { <-78.9528, 308.6917, -51.5457>, <-78.2907, 309.6584, -53.07006>, <-79.4197, 313.3957, -55.2152> }
					triangle { <-79.4814, 309.9817, -50.3012>, <-79.6344, 309.4572, -49.6899>, <-78.9528, 308.6917, -51.5457> }
					triangle { <-78.9528, 308.6917, -51.5457>, <-79.4197, 313.3957, -55.2152>, <-79.4814, 309.9817, -50.3012> }
					triangle { <-79.6894, 313.7548, -54.8936>, <-79.4814, 309.9817, -50.3012>, <-79.4197, 313.3957, -55.2152> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-76.6122, 314.9456, -54.579>, <-77.3461, 315.024, -54.8723>, <-78.8298, 314.329, -54.9513> }
					triangle { <-77.3461, 315.024, -54.8723>, <-79.7406, 314.2181, -55.19>, <-78.8298, 314.329, -54.9513> }
					triangle { <-79.7406, 314.2181, -55.19>, <-79.6894, 313.7548, -54.8936>, <-78.8298, 314.329, -54.9513> }
					triangle { <-78.8298, 314.329, -54.9513>, <-79.6894, 313.7548, -54.8936>, <-76.6122, 314.9456, -54.579> }
					triangle { <-79.7406, 314.2181, -55.19>, <-81.4163, 317.6841, -52.8765>, <-82.5035, 317.7932, -51.2661> }
					triangle { <-82.5035, 317.7932, -51.2661>, <-82.4712, 316.7426, -49.5192>, <-81.9938, 316.4218, -50.1033> }
					triangle { <-81.9938, 316.4218, -50.1033>, <-79.7406, 314.2181, -55.19>, <-82.5035, 317.7932, -51.2661> }
					triangle { <-79.7406, 314.2181, -55.19>, <-81.9938, 316.4218, -50.1033>, <-79.6894, 313.7548, -54.8936> }
					triangle { <-78.6943, 313.8983, -54.6463>, <-77.1428, 314.3779, -54.4149>, <-76.6122, 314.9456, -54.579> }
					triangle { <-78.6943, 313.8983, -54.6463>, <-79.4696, 313.3567, -54.58>, <-77.1428, 314.3779, -54.4149> }
					triangle { <-78.6943, 313.8983, -54.6463>, <-79.6894, 313.7548, -54.8936>, <-79.4696, 313.3567, -54.58> }
					triangle { <-76.6122, 314.9456, -54.579>, <-79.6894, 313.7548, -54.8936>, <-78.6943, 313.8983, -54.6463> }
					triangle { <-81.5776, 314.85, -49.1821>, <-80.242, 313.9513, -50.2334>, <-79.4696, 313.3567, -54.58> }
					triangle { <-81.9938, 316.4218, -50.1033>, <-82.4712, 316.7426, -49.5192>, <-81.5776, 314.85, -49.1821> }
					triangle { <-81.5776, 314.85, -49.1821>, <-79.4696, 313.3567, -54.58>, <-81.9938, 316.4218, -50.1033> }
					triangle { <-79.6894, 313.7548, -54.8936>, <-81.9938, 316.4218, -50.1033>, <-79.4696, 313.3567, -54.58> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-76.6122, 314.9456, -54.579>, <-77.166, 314.6007, -55.03198>, <-78.7097, 314.0468, -55.05772> }
					triangle { <-77.166, 314.6007, -55.03198>, <-79.5005, 313.6538, -55.4028>, <-78.7097, 314.0468, -55.05772> }
					triangle { <-79.5005, 313.6538, -55.4028>, <-79.6894, 313.7548, -54.8936>, <-78.7097, 314.0468, -55.05772> }
					triangle { <-78.7097, 314.0468, -55.05772>, <-79.6894, 313.7548, -54.8936>, <-76.6122, 314.9456, -54.579> }
					triangle { <-79.5005, 313.6538, -55.4028>, <-80.5272, 316.8443, -58.3927>, <-81.9251, 318.1971, -58.4509> }
					triangle { <-81.9251, 318.1971, -58.4509>, <-82.7314, 319.3949, -57.0117>, <-82.2417, 318.8088, -56.7137> }
					triangle { <-82.2417, 318.8088, -56.7137>, <-79.5005, 313.6538, -55.4028>, <-81.9251, 318.1971, -58.4509> }
					triangle { <-79.5005, 313.6538, -55.4028>, <-82.2417, 318.8088, -56.7137>, <-79.6894, 313.7548, -54.8936> }
					triangle { <-78.8143, 314.1805, -54.5399>, <-77.323, 314.8011, -54.2553>, <-76.6122, 314.9456, -54.579> }
					triangle { <-78.8143, 314.1805, -54.5399>, <-79.7097, 313.921, -54.3672>, <-77.323, 314.8011, -54.2553> }
					triangle { <-78.8143, 314.1805, -54.5399>, <-79.6894, 313.7548, -54.8936>, <-79.7097, 313.921, -54.3672> }
					triangle { <-76.6122, 314.9456, -54.579>, <-79.6894, 313.7548, -54.8936>, <-78.8143, 314.1805, -54.5399> }
					triangle { <-82.6402, 319.11, -54.9129>, <-81.4342, 318.0023, -53.9054>, <-79.7097, 313.921, -54.3672> }
					triangle { <-82.2417, 318.8088, -56.7137>, <-82.7314, 319.3949, -57.0117>, <-82.6402, 319.11, -54.9129> }
					triangle { <-82.6402, 319.11, -54.9129>, <-79.7097, 313.921, -54.3672>, <-82.2417, 318.8088, -56.7137> }
					triangle { <-79.6894, 313.7548, -54.8936>, <-82.2417, 318.8088, -56.7137>, <-79.7097, 313.921, -54.3672> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-25.615, 303.8017, -64.981>, <-26.01175, 306.1219, -65.0206>, 0.2999 }
			cylinder { <-26.01175, 306.1219, -65.0206>, <-26.3343, 308.4529, -65.09281>, 0.2999 }
			cylinder { <-26.3343, 308.4529, -65.09281>, <-26.5823, 310.7917, -65.1976>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-26.5823, 310.7917, -65.1976>, <-24.9286, 312.3329, -64.54>, 0.2999 }
			cylinder { <-24.9286, 312.3329, -64.54>, <-23.3271, 313.935, -63.899>, 0.2999 }
			cylinder { <-23.3271, 313.935, -63.899>, <-21.7794, 315.5959, -63.2754>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-21.7794, 315.5959, -63.2754>, <-17.8166, 321.441, -63.1623>, 0.2999 }
				cylinder { <-17.8166, 321.441, -63.1623>, <-14.8749, 327.6452, -64.8167>, 0.2999 }
				cylinder { <-14.8749, 327.6452, -64.8167>, <-13.2078, 333.6742, -68.09621>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.2078, 333.6742, -68.09621>, <-13.5172, 334.2834, -68.5646>, <-13.1542, 335.7734, -69.3228> }
					triangle { <-13.5172, 334.2834, -68.5646>, <-13.297, 336.5925, -69.8581>, <-13.1542, 335.7734, -69.3228> }
					triangle { <-13.297, 336.5925, -69.8581>, <-12.745, 336.6887, -69.7241>, <-13.1542, 335.7734, -69.3228> }
					triangle { <-13.1542, 335.7734, -69.3228>, <-12.745, 336.6887, -69.7241>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-13.297, 336.5925, -69.8581>, <-13.9108, 334.5444, -74.02628>, <-12.7573, 334.4446, -75.6934> }
					triangle { <-12.7573, 334.4446, -75.6934>, <-10.664, 334.1922, -75.968>, <-10.8868, 334.3392, -75.1557> }
					triangle { <-10.8868, 334.3392, -75.1557>, <-13.297, 336.5925, -69.8581>, <-12.7573, 334.4446, -75.6934> }
					triangle { <-13.297, 336.5925, -69.8581>, <-10.8868, 334.3392, -75.1557>, <-12.745, 336.6887, -69.7241> }
					triangle { <-12.6148, 335.7871, -69.1442>, <-12.7082, 334.3039, -68.2967>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-12.6148, 335.7871, -69.1442>, <-12.2184, 336.6198, -69.5009>, <-12.7082, 334.3039, -68.2967> }
					triangle { <-12.6148, 335.7871, -69.1442>, <-12.745, 336.6887, -69.7241>, <-12.2184, 336.6198, -69.5009> }
					triangle { <-13.2078, 333.6742, -68.09621>, <-12.745, 336.6887, -69.7241>, <-12.6148, 335.7871, -69.1442> }
					triangle { <-9.07203, 334.538, -74.473>, <-9.2367, 334.6628, -72.4784>, <-12.2184, 336.6198, -69.5009> }
					triangle { <-10.8868, 334.3392, -75.1557>, <-10.664, 334.1922, -75.968>, <-9.07203, 334.538, -74.473> }
					triangle { <-9.07203, 334.538, -74.473>, <-12.2184, 336.6198, -69.5009>, <-10.8868, 334.3392, -75.1557> }
					triangle { <-12.745, 336.6887, -69.7241>, <-10.8868, 334.3392, -75.1557>, <-12.2184, 336.6198, -69.5009> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-13.2078, 333.6742, -68.09621>, <-13.3551, 334.4883, -68.1391>, <-13.04612, 335.91, -69.03913> }
					triangle { <-13.3551, 334.4883, -68.1391>, <-13.08092, 336.8657, -69.2907>, <-13.04612, 335.91, -69.03913> }
					triangle { <-13.08092, 336.8657, -69.2907>, <-12.745, 336.6887, -69.7241>, <-13.04612, 335.91, -69.03913> }
					triangle { <-13.04612, 335.91, -69.03913>, <-12.745, 336.6887, -69.7241>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-13.08092, 336.8657, -69.2907>, <-17.6315, 337.0841, -70.3809>, <-18.6164, 337.2591, -72.1471> }
					triangle { <-18.6164, 337.2591, -72.1471>, <-18.2826, 336.3922, -74.05978>, <-17.6403, 336.2646, -73.5099> }
					triangle { <-17.6403, 336.2646, -73.5099>, <-13.08092, 336.8657, -69.2907>, <-18.6164, 337.2591, -72.1471> }
					triangle { <-13.08092, 336.8657, -69.2907>, <-17.6403, 336.2646, -73.5099>, <-12.745, 336.6887, -69.7241> }
					triangle { <-12.7229, 335.6505, -69.4279>, <-12.8703, 334.099, -68.7223>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-12.7229, 335.6505, -69.4279>, <-12.4346, 336.3466, -70.0683>, <-12.8703, 334.099, -68.7223> }
					triangle { <-12.7229, 335.6505, -69.4279>, <-12.745, 336.6887, -69.7241>, <-12.4346, 336.3466, -70.0683> }
					triangle { <-13.2078, 333.6742, -68.09621>, <-12.745, 336.6887, -69.7241>, <-12.7229, 335.6505, -69.4279> }
					triangle { <-16.4082, 335.4854, -74.8037>, <-14.8308, 334.8346, -73.7503>, <-12.4346, 336.3466, -70.0683> }
					triangle { <-17.6403, 336.2646, -73.5099>, <-18.2826, 336.3922, -74.05978>, <-16.4082, 335.4854, -74.8037> }
					triangle { <-16.4082, 335.4854, -74.8037>, <-12.4346, 336.3466, -70.0683>, <-17.6403, 336.2646, -73.5099> }
					triangle { <-12.745, 336.6887, -69.7241>, <-17.6403, 336.2646, -73.5099>, <-12.4346, 336.3466, -70.0683> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-13.2078, 333.6742, -68.09621>, <-12.8602, 334.426, -68.1138>, <-12.7162, 335.8685, -69.02226> }
					triangle { <-12.8602, 334.426, -68.1138>, <-12.4211, 336.7826, -69.257>, <-12.7162, 335.8685, -69.02226> }
					triangle { <-12.4211, 336.7826, -69.257>, <-12.745, 336.6887, -69.7241>, <-12.7162, 335.8685, -69.02226> }
					triangle { <-12.7162, 335.8685, -69.02226>, <-12.745, 336.6887, -69.7241>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-12.4211, 336.7826, -69.257>, <-14.6449, 339.0811, -65.834>, <-16.2596, 340.3109, -65.8258> }
					triangle { <-16.2596, 340.3109, -65.8258>, <-18.1087, 340.2462, -66.8736>, <-17.5352, 339.6791, -67.1573> }
					triangle { <-17.5352, 339.6791, -67.1573>, <-12.4211, 336.7826, -69.257>, <-16.2596, 340.3109, -65.8258> }
					triangle { <-12.4211, 336.7826, -69.257>, <-17.5352, 339.6791, -67.1573>, <-12.745, 336.6887, -69.7241> }
					triangle { <-13.05283, 335.692, -69.4447>, <-13.3651, 334.1613, -68.7476>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-13.05283, 335.692, -69.4447>, <-13.09435, 336.4296, -70.102>, <-13.3651, 334.1613, -68.7476> }
					triangle { <-13.05283, 335.692, -69.4447>, <-12.745, 336.6887, -69.7241>, <-13.09435, 336.4296, -70.102> }
					triangle { <-13.2078, 333.6742, -68.09621>, <-12.745, 336.6887, -69.7241>, <-13.05283, 335.692, -69.4447> }
					triangle { <-18.5596, 339.1049, -68.7129>, <-17.562, 337.5515, -69.4957>, <-13.09435, 336.4296, -70.102> }
					triangle { <-17.5352, 339.6791, -67.1573>, <-18.1087, 340.2462, -66.8736>, <-18.5596, 339.1049, -68.7129> }
					triangle { <-18.5596, 339.1049, -68.7129>, <-13.09435, 336.4296, -70.102>, <-17.5352, 339.6791, -67.1573> }
					triangle { <-12.745, 336.6887, -69.7241>, <-17.5352, 339.6791, -67.1573>, <-13.09435, 336.4296, -70.102> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-13.2078, 333.6742, -68.09621>, <-12.7119, 334.182, -68.5235>, <-12.6173, 335.7058, -69.2953> }
					triangle { <-12.7119, 334.182, -68.5235>, <-12.2234, 336.4573, -69.8032>, <-12.6173, 335.7058, -69.2953> }
					triangle { <-12.2234, 336.4573, -69.8032>, <-12.745, 336.6887, -69.7241>, <-12.6173, 335.7058, -69.2953> }
					triangle { <-12.6173, 335.7058, -69.2953>, <-12.745, 336.6887, -69.7241>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-12.2234, 336.4573, -69.8032>, <-9.05049, 337.7943, -66.6267>, <-8.922, 339.4111, -65.4064> }
					triangle { <-8.922, 339.4111, -65.4064>, <-10.3811, 340.4641, -64.2735>, <-10.7157, 339.8958, -64.8177> }
					triangle { <-10.7157, 339.8958, -64.8177>, <-12.2234, 336.4573, -69.8032>, <-8.922, 339.4111, -65.4064> }
					triangle { <-12.2234, 336.4573, -69.8032>, <-10.7157, 339.8958, -64.8177>, <-12.745, 336.6887, -69.7241> }
					triangle { <-13.1517, 335.8546, -69.1716>, <-13.5134, 334.4053, -68.3379>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-13.1517, 335.8546, -69.1716>, <-13.292, 336.755, -69.5558>, <-13.5134, 334.4053, -68.3379> }
					triangle { <-13.1517, 335.8546, -69.1716>, <-12.745, 336.6887, -69.7241>, <-13.292, 336.755, -69.5558> }
					triangle { <-13.2078, 333.6742, -68.09621>, <-12.745, 336.6887, -69.7241>, <-13.1517, 335.8546, -69.1716> }
					triangle { <-12.5731, 340.4281, -64.561>, <-13.6812, 339.0841, -65.5545>, <-13.292, 336.755, -69.5558> }
					triangle { <-10.7157, 339.8958, -64.8177>, <-10.3811, 340.4641, -64.2735>, <-12.5731, 340.4281, -64.561> }
					triangle { <-12.5731, 340.4281, -64.561>, <-13.292, 336.755, -69.5558>, <-10.7157, 339.8958, -64.8177> }
					triangle { <-12.745, 336.6887, -69.7241>, <-10.7157, 339.8958, -64.8177>, <-13.292, 336.755, -69.5558> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-13.2078, 333.6742, -68.09621>, <-13.1241, 334.0926, -68.8063>, <-12.8921, 335.6462, -69.4839> }
					triangle { <-13.1241, 334.0926, -68.8063>, <-12.7729, 336.338, -70.1803>, <-12.8921, 335.6462, -69.4839> }
					triangle { <-12.7729, 336.338, -70.1803>, <-12.745, 336.6887, -69.7241>, <-12.8921, 335.6462, -69.4839> }
					triangle { <-12.8921, 335.6462, -69.4839>, <-12.745, 336.6887, -69.7241>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-12.7729, 336.338, -70.1803>, <-8.5899, 334.9481, -71.7662>, <-6.7248, 335.7308, -71.597> }
					triangle { <-6.7248, 335.7308, -71.597>, <-5.7105, 336.666, -69.9791>, <-6.5448, 336.5457, -69.8356> }
					triangle { <-6.5448, 336.5457, -69.8356>, <-12.7729, 336.338, -70.1803>, <-6.7248, 335.7308, -71.597> }
					triangle { <-12.7729, 336.338, -70.1803>, <-6.5448, 336.5457, -69.8356>, <-12.745, 336.6887, -69.7241> }
					triangle { <-12.8769, 335.9143, -68.9831>, <-13.1013, 334.4948, -68.0551>, <-13.2078, 333.6742, -68.09621> }
					triangle { <-12.8769, 335.9143, -68.9831>, <-12.7425, 336.8743, -69.1787>, <-13.1013, 334.4948, -68.0551> }
					triangle { <-12.8769, 335.9143, -68.9831>, <-12.745, 336.6887, -69.7241>, <-12.7425, 336.8743, -69.1787> }
					triangle { <-13.2078, 333.6742, -68.09621>, <-12.745, 336.6887, -69.7241>, <-12.8769, 335.9143, -68.9831> }
					triangle { <-6.621, 337.563, -68.1747>, <-8.4582, 337.2719, -67.4258>, <-12.7425, 336.8743, -69.1787> }
					triangle { <-6.5448, 336.5457, -69.8356>, <-5.7105, 336.666, -69.9791>, <-6.621, 337.563, -68.1747> }
					triangle { <-6.621, 337.563, -68.1747>, <-12.7425, 336.8743, -69.1787>, <-6.5448, 336.5457, -69.8356> }
					triangle { <-12.745, 336.6887, -69.7241>, <-6.5448, 336.5457, -69.8356>, <-12.7425, 336.8743, -69.1787> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-21.7794, 315.5959, -63.2754>, <-20.2108, 317.211, -62.5874>, 0.2999 }
			cylinder { <-20.2108, 317.211, -62.5874>, <-18.623, 318.7784, -61.836>, 0.2999 }
			cylinder { <-18.623, 318.7784, -61.836>, <-17.0181, 320.2963, -61.02191>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-17.0181, 320.2963, -61.02191>, <-13.1434, 324.4101, -56.7856>, 0.2999 }
				cylinder { <-13.1434, 324.4101, -56.7856>, <-10.5426, 327.7299, -51.1201>, 0.2999 }
				cylinder { <-10.5426, 327.7299, -51.1201>, <-9.4398, 329.9698, -44.5133>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-9.4398, 329.9698, -44.5133>, <-9.4935, 329.832, -43.6982>, <-9.1724, 330.4937, -42.1536> }
					triangle { <-9.4935, 329.832, -43.6982>, <-9.1343, 330.552, -41.1673>, <-9.1724, 330.4937, -42.1536> }
					triangle { <-9.1343, 330.552, -41.1673>, <-8.9, 331.0663, -41.2795>, <-9.1724, 330.4937, -42.1536> }
					triangle { <-9.1724, 330.4937, -42.1536>, <-8.9, 331.0663, -41.2795>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-9.1343, 330.552, -41.1673>, <-13.7441, 330.703, -40.3477>, <-14.9844, 332.1874, -39.7327> }
					triangle { <-14.9844, 332.1874, -39.7327>, <-15.08409, 334.256, -40.2148>, <-14.3783, 333.8709, -40.5058> }
					triangle { <-14.3783, 333.8709, -40.5058>, <-9.1343, 330.552, -41.1673>, <-14.9844, 332.1874, -39.7327> }
					triangle { <-9.1343, 330.552, -41.1673>, <-14.3783, 333.8709, -40.5058>, <-8.9, 331.0663, -41.2795> }
					triangle { <-8.9529, 330.9779, -42.3544>, <-9.1642, 330.5583, -43.9994>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-8.9529, 330.9779, -42.3544>, <-8.6952, 331.5204, -41.5689>, <-9.1642, 330.5583, -43.9994> }
					triangle { <-8.9529, 330.9779, -42.3544>, <-8.9, 331.0663, -41.2795>, <-8.6952, 331.5204, -41.5689> }
					triangle { <-9.4398, 329.9698, -44.5133>, <-8.9, 331.0663, -41.2795>, <-8.9529, 330.9779, -42.3544> }
					triangle { <-13.4843, 335.496, -41.1048>, <-11.8416, 334.8994, -42.08804>, <-8.6952, 331.5204, -41.5689> }
					triangle { <-14.3783, 333.8709, -40.5058>, <-15.08409, 334.256, -40.2148>, <-13.4843, 335.496, -41.1048> }
					triangle { <-13.4843, 335.496, -41.1048>, <-8.6952, 331.5204, -41.5689>, <-14.3783, 333.8709, -40.5058> }
					triangle { <-8.9, 331.0663, -41.2795>, <-14.3783, 333.8709, -40.5058>, <-8.6952, 331.5204, -41.5689> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-9.4398, 329.9698, -44.5133>, <-9.01266, 329.9127, -43.8058>, <-8.8518, 330.5475, -42.2254> }
					triangle { <-9.01266, 329.9127, -43.8058>, <-8.4931, 330.6596, -41.3107>, <-8.8518, 330.5475, -42.2254> }
					triangle { <-8.4931, 330.6596, -41.3107>, <-8.9, 331.0663, -41.2795>, <-8.8518, 330.5475, -42.2254> }
					triangle { <-8.8518, 330.5475, -42.2254>, <-8.9, 331.0663, -41.2795>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-8.4931, 330.6596, -41.3107>, <-9.8163, 326.5115, -39.5823>, <-11.2472, 325.9699, -38.2485> }
					triangle { <-11.2472, 325.9699, -38.2485>, <-13.2407, 326.6429, -37.9414>, <-12.7954, 327.1303, -38.4848> }
					triangle { <-12.7954, 327.1303, -38.4848>, <-8.4931, 330.6596, -41.3107>, <-11.2472, 325.9699, -38.2485> }
					triangle { <-8.4931, 330.6596, -41.3107>, <-12.7954, 327.1303, -38.4848>, <-8.9, 331.0663, -41.2795> }
					triangle { <-9.2735, 330.9241, -42.2827>, <-9.6451, 330.4776, -43.8918>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-9.2735, 330.9241, -42.2827>, <-9.3364, 331.4128, -41.4254>, <-9.6451, 330.4776, -43.8918> }
					triangle { <-9.2735, 330.9241, -42.2827>, <-8.9, 331.0663, -41.2795>, <-9.3364, 331.4128, -41.4254> }
					triangle { <-9.4398, 329.9698, -44.5133>, <-8.9, 331.0663, -41.2795>, <-9.2735, 330.9241, -42.2827> }
					triangle { <-14.1287, 328.5436, -38.6401>, <-13.4708, 329.7757, -40.07897>, <-9.3364, 331.4128, -41.4254> }
					triangle { <-12.7954, 327.1303, -38.4848>, <-13.2407, 326.6429, -37.9414>, <-14.1287, 328.5436, -38.6401> }
					triangle { <-14.1287, 328.5436, -38.6401>, <-9.3364, 331.4128, -41.4254>, <-12.7954, 327.1303, -38.4848> }
					triangle { <-8.9, 331.0663, -41.2795>, <-12.7954, 327.1303, -38.4848>, <-9.3364, 331.4128, -41.4254> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-9.4398, 329.9698, -44.5133>, <-8.9658, 330.3811, -43.9725>, <-8.8206, 330.8598, -42.3365> }
					triangle { <-8.9658, 330.3811, -43.9725>, <-8.4307, 331.2841, -41.5329>, <-8.8206, 330.8598, -42.3365> }
					triangle { <-8.4307, 331.2841, -41.5329>, <-8.9, 331.0663, -41.2795>, <-8.8206, 330.8598, -42.3365> }
					triangle { <-8.8206, 330.8598, -42.3365>, <-8.9, 331.0663, -41.2795>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-8.4307, 331.2841, -41.5329>, <-4.6307, 328.572, -41.1465>, <-4.1055, 327.1189, -39.8302> }
					triangle { <-4.1055, 327.1189, -39.8302>, <-5.2158, 325.5551, -38.9122>, <-5.7031, 326.1222, -39.3269> }
					triangle { <-5.7031, 326.1222, -39.3269>, <-8.4307, 331.2841, -41.5329>, <-4.1055, 327.1189, -39.8302> }
					triangle { <-8.4307, 331.2841, -41.5329>, <-5.7031, 326.1222, -39.3269>, <-8.9, 331.0663, -41.2795> }
					triangle { <-9.3047, 330.6119, -42.1716>, <-9.6919, 330.0092, -43.7252>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-9.3047, 330.6119, -42.1716>, <-9.3988, 330.7883, -41.2032>, <-9.6919, 330.0092, -43.7252> }
					triangle { <-9.3047, 330.6119, -42.1716>, <-8.9, 331.0663, -41.2795>, <-9.3988, 330.7883, -41.2032> }
					triangle { <-9.4398, 329.9698, -44.5133>, <-8.9, 331.0663, -41.2795>, <-9.3047, 330.6119, -42.1716> }
					triangle { <-7.4133, 325.4249, -38.7037>, <-8.826, 326.4235, -39.7178>, <-9.3988, 330.7883, -41.2032> }
					triangle { <-5.7031, 326.1222, -39.3269>, <-5.2158, 325.5551, -38.9122>, <-7.4133, 325.4249, -38.7037> }
					triangle { <-7.4133, 325.4249, -38.7037>, <-9.3988, 330.7883, -41.2032>, <-5.7031, 326.1222, -39.3269> }
					triangle { <-8.9, 331.0663, -41.2795>, <-5.7031, 326.1222, -39.3269>, <-9.3988, 330.7883, -41.2032> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-9.4398, 329.9698, -44.5133>, <-9.4174, 330.5943, -43.9694>, <-9.1217, 331.0019, -42.3344> }
					triangle { <-9.4174, 330.5943, -43.9694>, <-9.0328, 331.5684, -41.5288>, <-9.1217, 331.0019, -42.3344> }
					triangle { <-9.0328, 331.5684, -41.5288>, <-8.9, 331.0663, -41.2795>, <-9.1217, 331.0019, -42.3344> }
					triangle { <-9.1217, 331.0019, -42.3344>, <-8.9, 331.0663, -41.2795>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-9.0328, 331.5684, -41.5288>, <-5.3053, 334.0562, -42.8932>, <-3.3621, 334.0573, -42.3067> }
					triangle { <-3.3621, 334.0573, -42.3067>, <-2.02467, 332.4856, -41.7946>, <-2.8366, 332.2303, -41.8762> }
					triangle { <-2.8366, 332.2303, -41.8762>, <-9.0328, 331.5684, -41.5288>, <-3.3621, 334.0573, -42.3067> }
					triangle { <-9.0328, 331.5684, -41.5288>, <-2.8366, 332.2303, -41.8762>, <-8.9, 331.0663, -41.2795> }
					triangle { <-9.003717, 330.4698, -42.1737>, <-9.2404, 329.796, -43.7283>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-9.003717, 330.4698, -42.1737>, <-8.7968, 330.5041, -41.2073>, <-9.2404, 329.796, -43.7283> }
					triangle { <-9.003717, 330.4698, -42.1737>, <-8.9, 331.0663, -41.2795>, <-8.7968, 330.5041, -41.2073> }
					triangle { <-9.4398, 329.9698, -44.5133>, <-8.9, 331.0663, -41.2795>, <-9.003717, 330.4698, -42.1737> }
					triangle { <-2.5559, 330.4208, -41.2084>, <-4.2827, 329.4441, -41.5002>, <-8.7968, 330.5041, -41.2073> }
					triangle { <-2.8366, 332.2303, -41.8762>, <-2.02467, 332.4856, -41.7946>, <-2.5559, 330.4208, -41.2084> }
					triangle { <-2.5559, 330.4208, -41.2084>, <-8.7968, 330.5041, -41.2073>, <-2.8366, 332.2303, -41.8762> }
					triangle { <-8.9, 331.0663, -41.2795>, <-2.8366, 332.2303, -41.8762>, <-8.7968, 330.5041, -41.2073> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-9.4398, 329.9698, -44.5133>, <-9.7484, 330.2498, -43.7973>, <-9.3424, 330.7723, -42.2197> }
					triangle { <-9.7484, 330.2498, -43.7973>, <-9.4742, 331.1091, -41.2994>, <-9.3424, 330.7723, -42.2197> }
					triangle { <-9.4742, 331.1091, -41.2994>, <-8.9, 331.0663, -41.2795>, <-9.3424, 330.7723, -42.2197> }
					triangle { <-9.3424, 330.7723, -42.2197>, <-8.9, 331.0663, -41.2795>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-9.4742, 331.1091, -41.2994>, <-11.02274, 335.3931, -42.3921>, <-10.1871, 337.2371, -42.2455> }
					triangle { <-10.1871, 337.2371, -42.2455>, <-8.2156, 337.9442, -42.6118>, <-8.2791, 337.0916, -42.6159> }
					triangle { <-8.2791, 337.0916, -42.6159>, <-9.4742, 331.1091, -41.2994>, <-10.1871, 337.2371, -42.2455> }
					triangle { <-9.4742, 331.1091, -41.2994>, <-8.2791, 337.0916, -42.6159>, <-8.9, 331.0663, -41.2795> }
					triangle { <-8.783, 330.6994, -42.2884>, <-8.9093, 330.1405, -43.9003>, <-9.4398, 329.9698, -44.5133> }
					triangle { <-8.783, 330.6994, -42.2884>, <-8.3554, 330.9633, -41.4367>, <-8.9093, 330.1405, -43.9003> }
					triangle { <-8.783, 330.6994, -42.2884>, <-8.9, 331.0663, -41.2795>, <-8.3554, 330.9633, -41.4367> }
					triangle { <-9.4398, 329.9698, -44.5133>, <-8.9, 331.0663, -41.2795>, <-8.783, 330.6994, -42.2884> }
					triangle { <-6.3646, 336.7391, -42.7147>, <-6.1746, 334.7615, -42.9872>, <-8.3554, 330.9633, -41.4367> }
					triangle { <-8.2791, 337.0916, -42.6159>, <-8.2156, 337.9442, -42.6118>, <-6.3646, 336.7391, -42.7147> }
					triangle { <-6.3646, 336.7391, -42.7147>, <-8.3554, 330.9633, -41.4367>, <-8.2791, 337.0916, -42.6159> }
					triangle { <-8.9, 331.0663, -41.2795>, <-8.2791, 337.0916, -42.6159>, <-8.3554, 330.9633, -41.4367> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-17.0181, 320.2963, -61.02191>, <-15.3874, 321.8259, -60.2844>, 0.2999 }
			cylinder { <-15.3874, 321.8259, -60.2844>, <-13.7331, 323.3655, -59.6246>, 0.2999 }
			cylinder { <-13.7331, 323.3655, -59.6246>, <-12.05709, 324.9131, -59.04311>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-12.05709, 324.9131, -59.04311>, <-5.9283, 328.3975, -58.6185>, 0.2999 }
				cylinder { <-5.9283, 328.3975, -58.6185>, <0.7732, 330.4232, -59.5504>, 0.2999 }
				cylinder { <0.7732, 330.4232, -59.5504>, <7.4704, 330.8157, -61.7585>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <7.4704, 330.8157, -61.7585>, <8.1003, 330.6529, -62.2714>, <9.7807, 330.8599, -62.5167> }
					triangle { <8.1003, 330.6529, -62.2714>, <10.6616, 330.7885, -62.9602>, <9.7807, 330.8599, -62.5167> }
					triangle { <10.6616, 330.7885, -62.9602>, <10.8362, 331.0876, -62.4997>, <9.7807, 330.8599, -62.5167> }
					triangle { <9.7807, 330.8599, -62.5167>, <10.8362, 331.0876, -62.4997>, <7.4704, 330.8157, -61.7585> }
					triangle { <10.6616, 330.7885, -62.9602>, <11.2249, 326.1568, -62.5427>, <12.4465, 325.0177, -61.3894> }
					triangle { <12.4465, 325.0177, -61.3894>, <13.0726, 325.195, -59.365>, <12.6607, 325.885, -59.657> }
					triangle { <12.6607, 325.885, -59.657>, <10.6616, 330.7885, -62.9602>, <12.4465, 325.0177, -61.3894> }
					triangle { <10.6616, 330.7885, -62.9602>, <12.6607, 325.885, -59.657>, <10.8362, 331.0876, -62.4997> }
					triangle { <9.863, 331.1514, -62.03598>, <8.2238, 331.0903, -61.5502>, <7.4704, 330.8157, -61.7585> }
					triangle { <9.863, 331.1514, -62.03598>, <10.8263, 331.3717, -61.9986>, <8.2238, 331.0903, -61.5502> }
					triangle { <9.863, 331.1514, -62.03598>, <10.8362, 331.0876, -62.4997>, <10.8263, 331.3717, -61.9986> }
					triangle { <7.4704, 330.8157, -61.7585>, <10.8362, 331.0876, -62.4997>, <9.863, 331.1514, -62.03598> }
					triangle { <13.00914, 327.0101, -58.104>, <11.9385, 328.6838, -58.3759>, <10.8263, 331.3717, -61.9986> }
					triangle { <12.6607, 325.885, -59.657>, <13.0726, 325.195, -59.365>, <13.00914, 327.0101, -58.104> }
					triangle { <13.00914, 327.0101, -58.104>, <10.8263, 331.3717, -61.9986>, <12.6607, 325.885, -59.657> }
					triangle { <10.8362, 331.0876, -62.4997>, <12.6607, 325.885, -59.657>, <10.8263, 331.3717, -61.9986> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <7.4704, 330.8157, -61.7585>, <8.07125, 331.1489, -62.2215>, <9.7613, 331.1905, -62.4834> }
					triangle { <8.07125, 331.1489, -62.2215>, <10.6229, 331.4499, -62.8936>, <9.7613, 331.1905, -62.4834> }
					triangle { <10.6229, 331.4499, -62.8936>, <10.8362, 331.0876, -62.4997>, <9.7613, 331.1905, -62.4834> }
					triangle { <9.7613, 331.1905, -62.4834>, <10.8362, 331.0876, -62.4997>, <7.4704, 330.8157, -61.7585> }
					triangle { <10.6229, 331.4499, -62.8936>, <9.9511, 329.5015, -67.1004>, <10.758, 327.8753, -68.00833> }
					triangle { <10.758, 327.8753, -68.00833>, <11.2682, 325.9423, -67.284>, <11.06789, 326.4972, -66.6651> }
					triangle { <11.06789, 326.4972, -66.6651>, <10.6229, 331.4499, -62.8936>, <10.758, 327.8753, -68.00833> }
					triangle { <10.6229, 331.4499, -62.8936>, <11.06789, 326.4972, -66.6651>, <10.8362, 331.0876, -62.4997> }
					triangle { <9.8824, 330.8208, -62.06927>, <8.2528, 330.5943, -61.6001>, <7.4704, 330.8157, -61.7585> }
					triangle { <9.8824, 330.8208, -62.06927>, <10.865, 330.7104, -62.06524>, <8.2528, 330.5943, -61.6001> }
					triangle { <9.8824, 330.8208, -62.06927>, <10.8362, 331.0876, -62.4997>, <10.865, 330.7104, -62.06524> }
					triangle { <7.4704, 330.8157, -61.7585>, <10.8362, 331.0876, -62.4997>, <9.8824, 330.8208, -62.06927> }
					triangle { <11.5854, 325.3486, -65.1778>, <11.0005, 326.2969, -63.5106>, <10.865, 330.7104, -62.06524> }
					triangle { <11.06789, 326.4972, -66.6651>, <11.2682, 325.9423, -67.284>, <11.5854, 325.3486, -65.1778> }
					triangle { <11.5854, 325.3486, -65.1778>, <10.865, 330.7104, -62.06524>, <11.06789, 326.4972, -66.6651> }
					triangle { <10.8362, 331.0876, -62.4997>, <11.06789, 326.4972, -66.6651>, <10.865, 330.7104, -62.06524> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <7.4704, 330.8157, -61.7585>, <8.1668, 331.2643, -61.7451>, <9.825, 331.2674, -62.1659> }
					triangle { <8.1668, 331.2643, -61.7451>, <10.7503, 331.6037, -62.2585>, <9.825, 331.2674, -62.1659> }
					triangle { <10.7503, 331.6037, -62.2585>, <10.8362, 331.0876, -62.4997>, <9.825, 331.2674, -62.1659> }
					triangle { <9.825, 331.2674, -62.1659>, <10.8362, 331.0876, -62.4997>, <7.4704, 330.8157, -61.7585> }
					triangle { <10.7503, 331.6037, -62.2585>, <9.8921, 335.0233, -65.343>, <10.316, 335.2342, -67.3168> }
					triangle { <10.316, 335.2342, -67.3168>, <10.2631, 333.8647, -68.9425>, <10.1696, 333.4921, -68.1786> }
					triangle { <10.1696, 333.4921, -68.1786>, <10.7503, 331.6037, -62.2585>, <10.316, 335.2342, -67.3168> }
					triangle { <10.7503, 331.6037, -62.2585>, <10.1696, 333.4921, -68.1786>, <10.8362, 331.0876, -62.4997> }
					triangle { <9.8186, 330.7439, -62.3868>, <8.1572, 330.4789, -62.07653>, <7.4704, 330.8157, -61.7585> }
					triangle { <9.8186, 330.7439, -62.3868>, <10.7376, 330.5566, -62.7003>, <8.1572, 330.4789, -62.07653> }
					triangle { <9.8186, 330.7439, -62.3868>, <10.8362, 331.0876, -62.4997>, <10.7376, 330.5566, -62.7003> }
					triangle { <7.4704, 330.8157, -61.7585>, <10.8362, 331.0876, -62.4997>, <9.8186, 330.7439, -62.3868> }
					triangle { <10.2725, 331.6566, -68.8265>, <9.8369, 330.4859, -67.2577>, <10.7376, 330.5566, -62.7003> }
					triangle { <10.1696, 333.4921, -68.1786>, <10.2631, 333.8647, -68.9425>, <10.2725, 331.6566, -68.8265> }
					triangle { <10.2725, 331.6566, -68.8265>, <10.7376, 330.5566, -62.7003>, <10.1696, 333.4921, -68.1786> }
					triangle { <10.8362, 331.0876, -62.4997>, <10.1696, 333.4921, -68.1786>, <10.7376, 330.5566, -62.7003> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <7.4704, 330.8157, -61.7585>, <8.2558, 330.8406, -61.4962>, <9.8844, 330.985, -61.9999> }
					triangle { <8.2558, 330.8406, -61.4962>, <10.869, 331.0388, -61.9266>, <9.8844, 330.985, -61.9999> }
					triangle { <10.869, 331.0388, -61.9266>, <10.8362, 331.0876, -62.4997>, <9.8844, 330.985, -61.9999> }
					triangle { <9.8844, 330.985, -61.9999>, <10.8362, 331.0876, -62.4997>, <7.4704, 330.8157, -61.7585> }
					triangle { <10.869, 331.0388, -61.9266>, <11.129, 335.1428, -59.6828>, <11.7271, 336.9933, -60.2641> }
					triangle { <11.7271, 336.9933, -60.2641>, <11.4369, 338.0876, -62.06402>, <11.1989, 337.2682, -62.12> }
					triangle { <11.1989, 337.2682, -62.12>, <10.869, 331.0388, -61.9266>, <11.7271, 336.9933, -60.2641> }
					triangle { <10.869, 331.0388, -61.9266>, <11.1989, 337.2682, -62.12>, <10.8362, 331.0876, -62.4997> }
					triangle { <9.7593, 331.0263, -62.5527>, <8.06825, 330.9026, -62.3254>, <7.4704, 330.8157, -61.7585> }
					triangle { <9.7593, 331.0263, -62.5527>, <10.6189, 331.1214, -63.03226>, <8.06825, 330.9026, -62.3254> }
					triangle { <9.7593, 331.0263, -62.5527>, <10.8362, 331.0876, -62.4997>, <10.6189, 331.1214, -63.03226> }
					triangle { <7.4704, 330.8157, -61.7585>, <10.8362, 331.0876, -62.4997>, <9.7593, 331.0263, -62.5527> }
					triangle { <10.8724, 337.2755, -64.04165>, <10.04502, 335.5007, -64.4738>, <10.6189, 331.1214, -63.03226> }
					triangle { <11.1989, 337.2682, -62.12>, <11.4369, 338.0876, -62.06402>, <10.8724, 337.2755, -64.04165> }
					triangle { <10.8724, 337.2755, -64.04165>, <10.6189, 331.1214, -63.03226>, <11.1989, 337.2682, -62.12> }
					triangle { <10.8362, 331.0876, -62.4997>, <11.1989, 337.2682, -62.12>, <10.6189, 331.1214, -63.03226> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <7.4704, 330.8157, -61.7585>, <8.2141, 330.4571, -61.8264>, <9.8565, 330.7293, -62.22> }
					triangle { <8.2141, 330.4571, -61.8264>, <10.8134, 330.5274, -62.3668>, <9.8565, 330.7293, -62.22> }
					triangle { <10.8134, 330.5274, -62.3668>, <10.8362, 331.0876, -62.4997>, <9.8565, 330.7293, -62.22> }
					triangle { <9.8565, 330.7293, -62.22>, <10.8362, 331.0876, -62.4997>, <7.4704, 330.8157, -61.7585> }
					triangle { <10.8134, 330.5274, -62.3668>, <11.9652, 329.5803, -57.926>, <13.06374, 330.5838, -56.5454> }
					triangle { <13.06374, 330.5838, -56.5454>, <13.1994, 332.6485, -56.05547>, <12.7617, 332.4958, -56.7739> }
					triangle { <12.7617, 332.4958, -56.7739>, <10.8134, 330.5274, -62.3668>, <13.06374, 330.5838, -56.5454> }
					triangle { <10.8134, 330.5274, -62.3668>, <12.7617, 332.4958, -56.7739>, <10.8362, 331.0876, -62.4997> }
					triangle { <9.7871, 331.282, -62.3326>, <8.1099, 331.2861, -61.9952>, <7.4704, 330.8157, -61.7585> }
					triangle { <9.7871, 331.282, -62.3326>, <10.6745, 331.6328, -62.592>, <8.1099, 331.2861, -61.9952> }
					triangle { <9.7871, 331.282, -62.3326>, <10.8362, 331.0876, -62.4997>, <10.6745, 331.6328, -62.592> }
					triangle { <7.4704, 330.8157, -61.7585>, <10.8362, 331.0876, -62.4997>, <9.7871, 331.282, -62.3326> }
					triangle { <12.5893, 334.3605, -57.3147>, <11.3634, 334.3702, -58.9017>, <10.6745, 331.6328, -62.592> }
					triangle { <12.7617, 332.4958, -56.7739>, <13.1994, 332.6485, -56.05547>, <12.5893, 334.3605, -57.3147> }
					triangle { <12.5893, 334.3605, -57.3147>, <10.6745, 331.6328, -62.592>, <12.7617, 332.4958, -56.7739> }
					triangle { <10.8362, 331.0876, -62.4997>, <12.7617, 332.4958, -56.7739>, <10.6745, 331.6328, -62.592> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-12.05709, 324.9131, -59.04311>, <-10.4333, 326.4956, -58.4093>, 0.2999 }
			cylinder { <-10.4333, 326.4956, -58.4093>, <-8.8638, 328.1111, -57.7242>, 0.2999 }
			cylinder { <-8.8638, 328.1111, -57.7242>, <-7.3504, 329.7576, -56.9885>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-7.3504, 329.7576, -56.9885>, <-4.4742, 335.9062, -55.03784>, 0.2999 }
				cylinder { <-4.4742, 335.9062, -55.03784>, <-3.5095, 342.7343, -53.5117>, 0.2999 }
				cylinder { <-3.5095, 342.7343, -53.5117>, <-4.5394, 349.654, -52.5415>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-4.5394, 349.654, -52.5415>, <-5.0573, 350.2784, -52.3735>, <-5.1678, 351.9725, -52.1628> }
					triangle { <-5.0573, 350.2784, -52.3735>, <-5.582, 352.8528, -51.9858>, <-5.1678, 351.9725, -52.1628> }
					triangle { <-5.582, 352.8528, -51.9858>, <-5.0436, 353.041, -52.06668>, <-5.1678, 351.9725, -52.1628> }
					triangle { <-5.1678, 351.9725, -52.1628>, <-5.0436, 353.041, -52.06668>, <-4.5394, 349.654, -52.5415> }
					triangle { <-5.582, 352.8528, -51.9858>, <-8.271, 353.0861, -55.8146>, <-8.167, 354.2083, -57.5027> }
					triangle { <-8.167, 354.2083, -57.5027>, <-6.5287, 354.8154, -58.7146>, <-6.2924, 354.4569, -57.9752> }
					triangle { <-6.2924, 354.4569, -57.9752>, <-5.582, 352.8528, -51.9858>, <-8.167, 354.2083, -57.5027> }
					triangle { <-5.582, 352.8528, -51.9858>, <-6.2924, 354.4569, -57.9752>, <-5.0436, 353.041, -52.06668> }
					triangle { <-4.6155, 352.0679, -52.2567>, <-4.2288, 350.4214, -52.5143>, <-4.5394, 349.654, -52.5415> }
					triangle { <-4.6155, 352.0679, -52.2567>, <-4.4774, 353.0435, -52.1735>, <-4.2288, 350.4214, -52.5143> }
					triangle { <-4.6155, 352.0679, -52.2567>, <-5.0436, 353.041, -52.06668>, <-4.4774, 353.0435, -52.1735> }
					triangle { <-4.5394, 349.654, -52.5415>, <-5.0436, 353.041, -52.06668>, <-4.6155, 352.0679, -52.2567> }
					triangle { <-4.3929, 354.86, -58.1442>, <-3.4843, 353.9126, -56.6283>, <-4.4774, 353.0435, -52.1735> }
					triangle { <-6.2924, 354.4569, -57.9752>, <-6.5287, 354.8154, -58.7146>, <-4.3929, 354.86, -58.1442> }
					triangle { <-4.3929, 354.86, -58.1442>, <-4.4774, 353.0435, -52.1735>, <-6.2924, 354.4569, -57.9752> }
					triangle { <-5.0436, 353.041, -52.06668>, <-6.2924, 354.4569, -57.9752>, <-4.4774, 353.0435, -52.1735> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-4.5394, 349.654, -52.5415>, <-4.6981, 350.2832, -52.02664>, <-4.9284, 351.9757, -51.9315> }
					triangle { <-4.6981, 350.2832, -52.02664>, <-5.1032, 352.8592, -51.5232>, <-4.9284, 351.9757, -51.9315> }
					triangle { <-5.1032, 352.8592, -51.5232>, <-5.0436, 353.041, -52.06668>, <-4.9284, 351.9757, -51.9315> }
					triangle { <-4.9284, 351.9757, -51.9315>, <-5.0436, 353.041, -52.06668>, <-4.5394, 349.654, -52.5415> }
					triangle { <-5.1032, 352.8592, -51.5232>, <-9.5485, 352.1152, -50.2461>, <-11.3179, 352.8203, -50.9474> }
					triangle { <-11.3179, 352.8203, -50.9474>, <-12.02969, 353.1839, -52.9179>, <-11.1924, 353.0136, -52.8829> }
					triangle { <-11.1924, 353.0136, -52.8829>, <-5.1032, 352.8592, -51.5232>, <-11.3179, 352.8203, -50.9474> }
					triangle { <-5.1032, 352.8592, -51.5232>, <-11.1924, 353.0136, -52.8829>, <-5.0436, 353.041, -52.06668> }
					triangle { <-4.8549, 352.0647, -52.488>, <-4.5879, 350.4166, -52.8613>, <-4.5394, 349.654, -52.5415> }
					triangle { <-4.8549, 352.0647, -52.488>, <-4.9563, 353.0371, -52.6361>, <-4.5879, 350.4166, -52.8613> }
					triangle { <-4.8549, 352.0647, -52.488>, <-5.0436, 353.041, -52.06668>, <-4.9563, 353.0371, -52.6361> }
					triangle { <-4.5394, 349.654, -52.5415>, <-5.0436, 353.041, -52.06668>, <-4.8549, 352.0647, -52.488> }
					triangle { <-10.8159, 353.4281, -54.7499>, <-8.9117, 352.8861, -55.06877>, <-4.9563, 353.0371, -52.6361> }
					triangle { <-11.1924, 353.0136, -52.8829>, <-12.02969, 353.1839, -52.9179>, <-10.8159, 353.4281, -54.7499> }
					triangle { <-10.8159, 353.4281, -54.7499>, <-4.9563, 353.0371, -52.6361>, <-11.1924, 353.0136, -52.8829> }
					triangle { <-5.0436, 353.041, -52.06668>, <-11.1924, 353.0136, -52.8829>, <-4.9563, 353.0371, -52.6361> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-4.5394, 349.654, -52.5415>, <-4.2634, 350.3796, -52.2525>, <-4.6385, 352.04, -52.08218> }
					triangle { <-4.2634, 350.3796, -52.2525>, <-4.5235, 352.9877, -51.8244>, <-4.6385, 352.04, -52.08218> }
					triangle { <-4.5235, 352.9877, -51.8244>, <-5.0436, 353.041, -52.06668>, <-4.6385, 352.04, -52.08218> }
					triangle { <-4.6385, 352.04, -52.08218>, <-5.0436, 353.041, -52.06668>, <-4.5394, 349.654, -52.5415> }
					triangle { <-4.5235, 352.9877, -51.8244>, <-4.6424, 352.4151, -47.1765>, <-6.02712, 352.8815, -45.7677> }
					triangle { <-6.02712, 352.8815, -45.7677>, <-8.1498, 352.7573, -45.7562>, <-7.804, 352.6269, -46.5273> }
					triangle { <-7.804, 352.6269, -46.5273>, <-4.5235, 352.9877, -51.8244>, <-6.02712, 352.8815, -45.7677> }
					triangle { <-4.5235, 352.9877, -51.8244>, <-7.804, 352.6269, -46.5273>, <-5.0436, 353.041, -52.06668> }
					triangle { <-5.1447, 352.0004, -52.3374>, <-5.02273, 350.3203, -52.6353>, <-4.5394, 349.654, -52.5415> }
					triangle { <-5.1447, 352.0004, -52.3374>, <-5.536, 352.9086, -52.3349>, <-5.02273, 350.3203, -52.6353> }
					triangle { <-5.1447, 352.0004, -52.3374>, <-5.0436, 353.041, -52.06668>, <-5.536, 352.9086, -52.3349> }
					triangle { <-4.5394, 349.654, -52.5415>, <-5.0436, 353.041, -52.06668>, <-5.1447, 352.0004, -52.3374> }
					triangle { <-9.4862, 352.6112, -47.5117>, <-9.02956, 352.0722, -49.3884>, <-5.536, 352.9086, -52.3349> }
					triangle { <-7.804, 352.6269, -46.5273>, <-8.1498, 352.7573, -45.7562>, <-9.4862, 352.6112, -47.5117> }
					triangle { <-9.4862, 352.6112, -47.5117>, <-5.536, 352.9086, -52.3349>, <-7.804, 352.6269, -46.5273> }
					triangle { <-5.0436, 353.041, -52.06668>, <-7.804, 352.6269, -46.5273>, <-5.536, 352.9086, -52.3349> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-4.5394, 349.654, -52.5415>, <-4.3497, 350.4352, -52.7412>, <-4.6961, 352.0771, -52.4079> }
					triangle { <-4.3497, 350.4352, -52.7412>, <-4.6387, 353.062, -52.476>, <-4.6961, 352.0771, -52.4079> }
					triangle { <-4.6387, 353.062, -52.476>, <-5.0436, 353.041, -52.06668>, <-4.6961, 352.0771, -52.4079> }
					triangle { <-4.6961, 352.0771, -52.4079>, <-5.0436, 353.041, -52.06668>, <-4.5394, 349.654, -52.5415> }
					triangle { <-4.6387, 353.062, -52.476>, <-0.2869, 353.574, -50.8193>, <0.4431, 354.308, -49.07343> }
					triangle { <0.4431, 354.308, -49.07343>, <-0.2147, 354.1212, -47.06009>, <-0.7781, 353.8275, -47.6323> }
					triangle { <-0.7781, 353.8275, -47.6323>, <-4.6387, 353.062, -52.476>, <0.4431, 354.308, -49.07343> }
					triangle { <-4.6387, 353.062, -52.476>, <-0.7781, 353.8275, -47.6323>, <-5.0436, 353.041, -52.06668> }
					triangle { <-5.0872, 351.9633, -52.01162>, <-4.9363, 350.2646, -52.1467>, <-4.5394, 349.654, -52.5415> }
					triangle { <-5.0872, 351.9633, -52.01162>, <-5.4208, 352.8344, -51.6833>, <-4.9363, 350.2646, -52.1467> }
					triangle { <-5.0872, 351.9633, -52.01162>, <-5.0436, 353.041, -52.06668>, <-5.4208, 352.8344, -51.6833> }
					triangle { <-4.5394, 349.654, -52.5415>, <-5.0436, 353.041, -52.06668>, <-5.0872, 351.9633, -52.01162> }
					triangle { <-2.229, 353.5305, -46.3651>, <-3.676, 352.588, -47.3843>, <-5.4208, 352.8344, -51.6833> }
					triangle { <-0.7781, 353.8275, -47.6323>, <-0.2147, 354.1212, -47.06009>, <-2.229, 353.5305, -46.3651> }
					triangle { <-2.229, 353.5305, -46.3651>, <-5.4208, 352.8344, -51.6833>, <-0.7781, 353.8275, -47.6323> }
					triangle { <-5.0436, 353.041, -52.06668>, <-0.7781, 353.8275, -47.6323>, <-5.4208, 352.8344, -51.6833> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-4.5394, 349.654, -52.5415>, <-4.8478, 350.3718, -52.8171>, <-5.02819, 352.0348, -52.4585> }
					triangle { <-4.8478, 350.3718, -52.8171>, <-5.3028, 352.9773, -52.5772>, <-5.02819, 352.0348, -52.4585> }
					triangle { <-5.3028, 352.9773, -52.5772>, <-5.0436, 353.041, -52.06668>, <-5.02819, 352.0348, -52.4585> }
					triangle { <-5.02819, 352.0348, -52.4585>, <-5.0436, 353.041, -52.06668>, <-4.5394, 349.654, -52.5415> }
					triangle { <-5.3028, 352.9773, -52.5772>, <-2.5634, 353.995, -56.2385>, <-0.8993, 355.1404, -56.4355> }
					triangle { <-0.8993, 355.1404, -56.4355>, <0.8022, 355.4123, -55.1897>, <0.1701, 354.9756, -54.8143> }
					triangle { <0.1701, 354.9756, -54.8143>, <-5.3028, 352.9773, -52.5772>, <-0.8993, 355.1404, -56.4355> }
					triangle { <-5.3028, 352.9773, -52.5772>, <0.1701, 354.9756, -54.8143>, <-5.0436, 353.041, -52.06668> }
					triangle { <-4.7551, 352.0056, -51.961>, <-4.4383, 350.3281, -52.07081>, <-4.5394, 349.654, -52.5415> }
					triangle { <-4.7551, 352.0056, -51.961>, <-4.7567, 352.919, -51.5821>, <-4.4383, 350.3281, -52.07081> }
					triangle { <-4.7551, 352.0056, -51.961>, <-5.0436, 353.041, -52.06668>, <-4.7567, 352.919, -51.5821> }
					triangle { <-4.5394, 349.654, -52.5415>, <-5.0436, 353.041, -52.06668>, <-4.7551, 352.0056, -51.961> }
					triangle { <0.9662, 354.9414, -53.03558>, <-0.1972, 353.7426, -51.9263>, <-4.7567, 352.919, -51.5821> }
					triangle { <0.1701, 354.9756, -54.8143>, <0.8022, 355.4123, -55.1897>, <0.9662, 354.9414, -53.03558> }
					triangle { <0.9662, 354.9414, -53.03558>, <-4.7567, 352.919, -51.5821>, <0.1701, 354.9756, -54.8143> }
					triangle { <-5.0436, 353.041, -52.06668>, <0.1701, 354.9756, -54.8143>, <-4.7567, 352.919, -51.5821> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-7.3504, 329.7576, -56.9885>, <-5.7785, 331.3473, -56.2505>, 0.2999 }
			cylinder { <-5.7785, 331.3473, -56.2505>, <-4.1498, 332.8781, -55.5112>, 0.2999 }
			cylinder { <-4.1498, 332.8781, -55.5112>, <-2.4664, 334.3483, -54.7715>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.4664, 334.3483, -54.7715>, <2.9762, 337.1777, -51.2709>, 0.2999 }
				cylinder { <2.9762, 337.1777, -51.2709>, <8.3427, 338.1823, -46.7904>, 0.2999 }
				cylinder { <8.3427, 338.1823, -46.7904>, <13.1707, 337.2756, -41.7159>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <13.1707, 337.2756, -41.7159>, <13.6145, 336.8248, -41.2356>, <14.7161, 336.8575, -40.02079> }
					triangle { <13.6145, 336.8248, -41.2356>, <15.3168, 336.5284, -39.3652>, <14.7161, 336.8575, -40.02079> }
					triangle { <15.3168, 336.5284, -39.3652>, <15.3955, 337.0664, -39.2678>, <14.7161, 336.8575, -40.02079> }
					triangle { <14.7161, 336.8575, -40.02079>, <15.3955, 337.0664, -39.2678>, <13.1707, 337.2756, -41.7159> }
					triangle { <15.3168, 336.5284, -39.3652>, <12.2907, 334.6109, -36.656>, <11.613, 335.0808, -34.8933> }
					triangle { <11.613, 335.0808, -34.8933>, <11.1217, 336.8698, -34.04807>, <11.5119, 336.9425, -34.7653> }
					triangle { <11.5119, 336.9425, -34.7653>, <15.3168, 336.5284, -39.3652>, <11.613, 335.0808, -34.8933> }
					triangle { <15.3168, 336.5284, -39.3652>, <11.5119, 336.9425, -34.7653>, <15.3955, 337.0664, -39.2678> }
					triangle { <14.7339, 337.4013, -39.9904>, <13.6412, 337.6404, -41.1901>, <13.1707, 337.2756, -41.7159> }
					triangle { <14.7339, 337.4013, -39.9904>, <15.3524, 337.6158, -39.3046>, <13.6412, 337.6404, -41.1901> }
					triangle { <14.7339, 337.4013, -39.9904>, <15.3955, 337.0664, -39.2678>, <15.3524, 337.6158, -39.3046> }
					triangle { <13.1707, 337.2756, -41.7159>, <15.3955, 337.0664, -39.2678>, <14.7339, 337.4013, -39.9904> }
					triangle { <11.7345, 338.7964, -34.6863>, <12.4449, 339.3232, -36.3934>, <15.3524, 337.6158, -39.3046> }
					triangle { <11.5119, 336.9425, -34.7653>, <11.1217, 336.8698, -34.04807>, <11.7345, 338.7964, -34.6863> }
					triangle { <11.7345, 338.7964, -34.6863>, <15.3524, 337.6158, -39.3046>, <11.5119, 336.9425, -34.7653> }
					triangle { <15.3955, 337.0664, -39.2678>, <11.5119, 336.9425, -34.7653>, <15.3524, 337.6158, -39.3046> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <13.1707, 337.2756, -41.7159>, <13.911, 337.1098, -41.4807>, <14.9138, 337.0475, -40.1841> }
					triangle { <13.911, 337.1098, -41.4807>, <15.7121, 336.9084, -39.692>, <14.9138, 337.0475, -40.1841> }
					triangle { <15.7121, 336.9084, -39.692>, <15.3955, 337.0664, -39.2678>, <14.9138, 337.0475, -40.1841> }
					triangle { <14.9138, 337.0475, -40.1841>, <15.3955, 337.0664, -39.2678>, <13.1707, 337.2756, -41.7159> }
					triangle { <15.7121, 336.9084, -39.692>, <15.9871, 332.4541, -40.1996>, <15.7158, 330.9674, -38.9735> }
					triangle { <15.7158, 330.9674, -38.9735>, <14.3401, 330.6375, -37.5055>, <14.329, 331.4029, -37.7989> }
					triangle { <14.329, 331.4029, -37.7989>, <15.7121, 336.9084, -39.692>, <15.7158, 330.9674, -38.9735> }
					triangle { <15.7121, 336.9084, -39.692>, <14.329, 331.4029, -37.7989>, <15.3955, 337.0664, -39.2678> }
					triangle { <14.5363, 337.2113, -39.827>, <13.3447, 337.3554, -40.945>, <13.1707, 337.2756, -41.7159> }
					triangle { <14.5363, 337.2113, -39.827>, <14.957, 337.2358, -38.9778>, <13.3447, 337.3554, -40.945> }
					triangle { <14.5363, 337.2113, -39.827>, <15.3955, 337.0664, -39.2678>, <14.957, 337.2358, -38.9778> }
					triangle { <13.1707, 337.2756, -41.7159>, <15.3955, 337.0664, -39.2678>, <14.5363, 337.2113, -39.827> }
					triangle { <13.1358, 332.0862, -36.5332>, <12.715, 333.8731, -37.1046>, <14.957, 337.2358, -38.9778> }
					triangle { <14.329, 331.4029, -37.7989>, <14.3401, 330.6375, -37.5055>, <13.1358, 332.0862, -36.5332> }
					triangle { <13.1358, 332.0862, -36.5332>, <14.957, 337.2358, -38.9778>, <14.329, 331.4029, -37.7989> }
					triangle { <15.3955, 337.0664, -39.2678>, <14.329, 331.4029, -37.7989>, <14.957, 337.2358, -38.9778> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <13.1707, 337.2756, -41.7159>, <13.8189, 337.5634, -41.3582>, <14.8524, 337.3499, -40.1025> }
					triangle { <13.8189, 337.5634, -41.3582>, <15.5892, 337.5131, -39.5286>, <14.8524, 337.3499, -40.1025> }
					triangle { <15.5892, 337.5131, -39.5286>, <15.3955, 337.0664, -39.2678>, <14.8524, 337.3499, -40.1025> }
					triangle { <14.8524, 337.3499, -40.1025>, <15.3955, 337.0664, -39.2678>, <13.1707, 337.2756, -41.7159> }
					triangle { <15.5892, 337.5131, -39.5286>, <18.8715, 336.6283, -42.4642>, <20.132, 335.1548, -42.6291> }
					triangle { <20.132, 335.1548, -42.6291>, <19.9276, 333.1431, -42.3693>, <19.2794, 333.5742, -42.1122> }
					triangle { <19.2794, 333.5742, -42.1122>, <15.5892, 337.5131, -39.5286>, <20.132, 335.1548, -42.6291> }
					triangle { <15.5892, 337.5131, -39.5286>, <19.2794, 333.5742, -42.1122>, <15.3955, 337.0664, -39.2678> }
					triangle { <14.5977, 336.9089, -39.9087>, <13.4369, 336.9018, -41.0676>, <13.1707, 337.2756, -41.7159> }
					triangle { <14.5977, 336.9089, -39.9087>, <15.07997, 336.6311, -39.1411>, <13.4369, 336.9018, -41.0676> }
					triangle { <14.5977, 336.9089, -39.9087>, <15.3955, 337.0664, -39.2678>, <15.07997, 336.6311, -39.1411> }
					triangle { <13.1707, 337.2756, -41.7159>, <15.3955, 337.0664, -39.2678>, <14.5977, 336.9089, -39.9087> }
					triangle { <18.3919, 332.1412, -41.3052>, <16.6645, 332.8062, -40.7851>, <15.07997, 336.6311, -39.1411> }
					triangle { <19.2794, 333.5742, -42.1122>, <19.9276, 333.1431, -42.3693>, <18.3919, 332.1412, -41.3052> }
					triangle { <18.3919, 332.1412, -41.3052>, <15.07997, 336.6311, -39.1411>, <19.2794, 333.5742, -42.1122> }
					triangle { <15.3955, 337.0664, -39.2678>, <19.2794, 333.5742, -42.1122>, <15.07997, 336.6311, -39.1411> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <13.1707, 337.2756, -41.7159>, <13.4645, 337.5629, -41.03623>, <14.6161, 337.3496, -39.8878> }
					triangle { <13.4645, 337.5629, -41.03623>, <15.1168, 337.5125, -39.09937>, <14.6161, 337.3496, -39.8878> }
					triangle { <15.1168, 337.5125, -39.09937>, <15.3955, 337.0664, -39.2678>, <14.6161, 337.3496, -39.8878> }
					triangle { <14.6161, 337.3496, -39.8878>, <15.3955, 337.0664, -39.2678>, <13.1707, 337.2756, -41.7159> }
					triangle { <15.1168, 337.5125, -39.09937>, <16.9846, 341.4038, -40.3413>, <18.7998, 341.8953, -40.8423> }
					triangle { <18.7998, 341.8953, -40.8423>, <20.2145, 340.9474, -41.9632>, <19.568, 340.476, -41.7847> }
					triangle { <19.568, 340.476, -41.7847>, <15.1168, 337.5125, -39.09937>, <18.7998, 341.8953, -40.8423> }
					triangle { <15.1168, 337.5125, -39.09937>, <19.568, 340.476, -41.7847>, <15.3955, 337.0664, -39.2678> }
					triangle { <14.8339, 336.9092, -40.1234>, <13.7912, 336.9023, -41.3895>, <13.1707, 337.2756, -41.7159> }
					triangle { <14.8339, 336.9092, -40.1234>, <15.5524, 336.6317, -39.5705>, <13.7912, 336.9023, -41.3895> }
					triangle { <14.8339, 336.9092, -40.1234>, <15.3955, 337.0664, -39.2678>, <15.5524, 336.6317, -39.5705> }
					triangle { <13.1707, 337.2756, -41.7159>, <15.3955, 337.0664, -39.2678>, <14.8339, 336.9092, -40.1234> }
					triangle { <20.288, 338.8859, -42.452>, <18.8722, 337.5869, -42.3829>, <15.5524, 336.6317, -39.5705> }
					triangle { <19.568, 340.476, -41.7847>, <20.2145, 340.9474, -41.9632>, <20.288, 338.8859, -42.452> }
					triangle { <20.288, 338.8859, -42.452>, <15.5524, 336.6317, -39.5705>, <19.568, 340.476, -41.7847> }
					triangle { <15.3955, 337.0664, -39.2678>, <19.568, 340.476, -41.7847>, <15.5524, 336.6317, -39.5705> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <13.1707, 337.2756, -41.7159>, <13.3363, 337.0995, -40.9593>, <14.5307, 337.0407, -39.8365> }
					triangle { <13.3363, 337.0995, -40.9593>, <14.9459, 336.8947, -38.9968>, <14.5307, 337.0407, -39.8365> }
					triangle { <14.9459, 336.8947, -38.9968>, <15.3955, 337.0664, -39.2678>, <14.5307, 337.0407, -39.8365> }
					triangle { <14.5307, 337.0407, -39.8365>, <15.3955, 337.0664, -39.2678>, <13.1707, 337.2756, -41.7159> }
					triangle { <14.9459, 336.8947, -38.9968>, <12.8561, 340.1381, -36.6975>, <13.4552, 341.8488, -35.9892> }
					triangle { <13.4552, 341.8488, -35.9892>, <14.6901, 343.2854, -36.7427>, <14.695, 342.5892, -37.1755> }
					triangle { <14.695, 342.5892, -37.1755>, <14.9459, 336.8947, -38.9968>, <13.4552, 341.8488, -35.9892> }
					triangle { <14.9459, 336.8947, -38.9968>, <14.695, 342.5892, -37.1755>, <15.3955, 337.0664, -39.2678> }
					triangle { <14.9194, 337.2181, -40.1746>, <13.9194, 337.3656, -41.4664>, <13.1707, 337.2756, -41.7159> }
					triangle { <14.9194, 337.2181, -40.1746>, <15.7233, 337.2495, -39.673>, <13.9194, 337.3656, -41.4664> }
					triangle { <14.9194, 337.2181, -40.1746>, <15.3955, 337.0664, -39.2678>, <15.7233, 337.2495, -39.673> }
					triangle { <13.1707, 337.2756, -41.7159>, <15.3955, 337.0664, -39.2678>, <14.9194, 337.2181, -40.1746> }
					triangle { <16.1114, 343.0611, -38.2996>, <16.225, 341.6755, -39.6277>, <15.7233, 337.2495, -39.673> }
					triangle { <14.695, 342.5892, -37.1755>, <14.6901, 343.2854, -36.7427>, <16.1114, 343.0611, -38.2996> }
					triangle { <16.1114, 343.0611, -38.2996>, <15.7233, 337.2495, -39.673>, <14.695, 342.5892, -37.1755> }
					triangle { <15.3955, 337.0664, -39.2678>, <14.695, 342.5892, -37.1755>, <15.7233, 337.2495, -39.673> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-26.5823, 310.7917, -65.1976>, <-26.907, 313.1198, -65.3285>, 0.2999 }
			cylinder { <-26.907, 313.1198, -65.3285>, <-27.3079, 315.4343, -65.4854>, 0.2999 }
			cylinder { <-27.3079, 315.4343, -65.4854>, <-27.7847, 317.7325, -65.6682>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-27.7847, 317.7325, -65.6682>, <-28.8741, 318.7204, -67.5067>, 0.2999 }
			cylinder { <-28.8741, 318.7204, -67.5067>, <-29.9535, 319.7813, -69.3099>, 0.2999 }
			cylinder { <-29.9535, 319.7813, -69.3099>, <-31.02162, 320.9141, -71.07594>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-31.02162, 320.9141, -71.07594>, <-35.1505, 325.2777, -74.7898>, 0.2999 }
				cylinder { <-35.1505, 325.2777, -74.7898>, <-39.8486, 330.2309, -76.6>, 0.2999 }
				cylinder { <-39.8486, 330.2309, -76.6>, <-44.7112, 335.3471, -76.3504>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-44.7112, 335.3471, -76.3504>, <-44.9622, 336.0045, -75.9133>, <-46.09463, 337.2857, -75.8584> }
					triangle { <-44.9622, 336.0045, -75.9133>, <-46.5586, 338.0899, -75.518>, <-46.09463, 337.2857, -75.8584> }
					triangle { <-46.5586, 338.0899, -75.518>, <-46.8763, 338.0184, -75.9932>, <-46.09463, 337.2857, -75.8584> }
					triangle { <-46.09463, 337.2857, -75.8584>, <-46.8763, 338.0184, -75.9932>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-46.5586, 338.0899, -75.518>, <-48.4335, 336.1787, -71.6739>, <-50.3353, 335.6739, -71.1758> }
					triangle { <-50.3353, 335.6739, -71.1758>, <-51.9151, 334.7873, -72.289>, <-51.249, 335.0239, -72.7701> }
					triangle { <-51.249, 335.0239, -72.7701>, <-46.5586, 338.0899, -75.518>, <-50.3353, 335.6739, -71.1758> }
					triangle { <-46.5586, 338.0899, -75.518>, <-51.249, 335.0239, -72.7701>, <-46.8763, 338.0184, -75.9932> }
					triangle { <-46.353, 337.1411, -76.3434>, <-45.3499, 335.7876, -76.6408>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-46.353, 337.1411, -76.3434>, <-47.07552, 337.8006, -76.488>, <-45.3499, 335.7876, -76.6408> }
					triangle { <-46.353, 337.1411, -76.3434>, <-46.8763, 338.0184, -75.9932>, <-47.07552, 337.8006, -76.488> }
					triangle { <-44.7112, 335.3471, -76.3504>, <-46.8763, 338.0184, -75.9932>, <-46.353, 337.1411, -76.3434> }
					triangle { <-52.1014, 334.6855, -74.49>, <-50.6734, 334.9253, -75.8773>, <-47.07552, 337.8006, -76.488> }
					triangle { <-51.249, 335.0239, -72.7701>, <-51.9151, 334.7873, -72.289>, <-52.1014, 334.6855, -74.49> }
					triangle { <-52.1014, 334.6855, -74.49>, <-47.07552, 337.8006, -76.488>, <-51.249, 335.0239, -72.7701> }
					triangle { <-46.8763, 338.0184, -75.9932>, <-51.249, 335.0239, -72.7701>, <-47.07552, 337.8006, -76.488> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-44.7112, 335.3471, -76.3504>, <-44.839, 336.1654, -76.3697>, <-46.01249, 337.393, -76.1626> }
					triangle { <-44.839, 336.1654, -76.3697>, <-46.3943, 338.3044, -76.1265>, <-46.01249, 337.393, -76.1626> }
					triangle { <-46.3943, 338.3044, -76.1265>, <-46.8763, 338.0184, -75.9932>, <-46.01249, 337.393, -76.1626> }
					triangle { <-46.01249, 337.393, -76.1626>, <-46.8763, 338.0184, -75.9932>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-46.3943, 338.3044, -76.1265>, <-44.01522, 339.8572, -72.4018>, <-44.5631, 340.2606, -70.4895> }
					triangle { <-44.5631, 340.2606, -70.4895>, <-45.87, 339.2659, -69.1389>, <-45.915, 338.9687, -69.9394> }
					triangle { <-45.915, 338.9687, -69.9394>, <-46.3943, 338.3044, -76.1265>, <-44.5631, 340.2606, -70.4895> }
					triangle { <-46.3943, 338.3044, -76.1265>, <-45.915, 338.9687, -69.9394>, <-46.8763, 338.0184, -75.9932> }
					triangle { <-46.4352, 337.0338, -76.03918>, <-45.4731, 335.6267, -76.1844>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-46.4352, 337.0338, -76.03918>, <-47.2397, 337.5861, -75.8795>, <-45.4731, 335.6267, -76.1844> }
					triangle { <-46.4352, 337.0338, -76.03918>, <-46.8763, 338.0184, -75.9932>, <-47.2397, 337.5861, -75.8795> }
					triangle { <-44.7112, 335.3471, -76.3504>, <-46.8763, 338.0184, -75.9932>, <-46.4352, 337.0338, -76.03918> }
					triangle { <-47.4518, 337.8064, -69.6455>, <-47.6789, 336.7446, -71.3314>, <-47.2397, 337.5861, -75.8795> }
					triangle { <-45.915, 338.9687, -69.9394>, <-45.87, 339.2659, -69.1389>, <-47.4518, 337.8064, -69.6455> }
					triangle { <-47.4518, 337.8064, -69.6455>, <-47.2397, 337.5861, -75.8795>, <-45.915, 338.9687, -69.9394> }
					triangle { <-46.8763, 338.0184, -75.9932>, <-45.915, 338.9687, -69.9394>, <-47.2397, 337.5861, -75.8795> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-44.7112, 335.3471, -76.3504>, <-45.151, 335.9565, -76.6989>, <-46.2204, 337.2537, -76.3821> }
					triangle { <-45.151, 335.9565, -76.6989>, <-46.8103, 338.0259, -76.5655>, <-46.2204, 337.2537, -76.3821> }
					triangle { <-46.8103, 338.0259, -76.5655>, <-46.8763, 338.0184, -75.9932>, <-46.2204, 337.2537, -76.3821> }
					triangle { <-46.2204, 337.2537, -76.3821>, <-46.8763, 338.0184, -75.9932>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-46.8103, 338.0259, -76.5655>, <-43.5242, 341.0117, -78.05948>, <-42.699, 342.6738, -77.237> }
					triangle { <-42.699, 342.6738, -77.237>, <-42.1018, 343.1372, -75.2495>, <-42.552, 342.4128, -75.311> }
					triangle { <-42.552, 342.4128, -75.311>, <-46.8103, 338.0259, -76.5655>, <-42.699, 342.6738, -77.237> }
					triangle { <-46.8103, 338.0259, -76.5655>, <-42.552, 342.4128, -75.311>, <-46.8763, 338.0184, -75.9932> }
					triangle { <-46.2272, 337.173, -75.8196>, <-45.1611, 335.8355, -75.8552>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-46.2272, 337.173, -75.8196>, <-46.8238, 337.8646, -75.4405>, <-45.1611, 335.8355, -75.8552> }
					triangle { <-46.2272, 337.173, -75.8196>, <-46.8763, 338.0184, -75.9932>, <-46.8238, 337.8646, -75.4405> }
					triangle { <-44.7112, 335.3471, -76.3504>, <-46.8763, 338.0184, -75.9932>, <-46.2272, 337.173, -75.8196> }
					triangle { <-42.7451, 342.1224, -73.3933>, <-43.5827, 340.3124, -73.1845>, <-46.8238, 337.8646, -75.4405> }
					triangle { <-42.552, 342.4128, -75.311>, <-42.1018, 343.1372, -75.2495>, <-42.7451, 342.1224, -73.3933> }
					triangle { <-42.7451, 342.1224, -73.3933>, <-46.8238, 337.8646, -75.4405>, <-42.552, 342.4128, -75.311> }
					triangle { <-46.8763, 338.0184, -75.9932>, <-42.552, 342.4128, -75.311>, <-46.8238, 337.8646, -75.4405> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-44.7112, 335.3471, -76.3504>, <-45.4699, 335.6646, -76.4491>, <-46.4331, 337.0591, -76.2156> }
					triangle { <-45.4699, 335.6646, -76.4491>, <-47.2355, 337.6367, -76.2324>, <-46.4331, 337.0591, -76.2156> }
					triangle { <-47.2355, 337.6367, -76.2324>, <-46.8763, 338.0184, -75.9932>, <-46.4331, 337.0591, -76.2156> }
					triangle { <-46.4331, 337.0591, -76.2156>, <-46.8763, 338.0184, -75.9932>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-47.2355, 337.6367, -76.2324>, <-47.6345, 338.0575, -80.8809>, <-47.3017, 339.601, -82.1563> }
					triangle { <-47.3017, 339.601, -82.1563>, <-45.783, 341.0873, -82.2332>, <-45.7761, 340.6287, -81.5116> }
					triangle { <-45.7761, 340.6287, -81.5116>, <-47.2355, 337.6367, -76.2324>, <-47.3017, 339.601, -82.1563> }
					triangle { <-47.2355, 337.6367, -76.2324>, <-45.7761, 340.6287, -81.5116>, <-46.8763, 338.0184, -75.9932> }
					triangle { <-46.01461, 337.3676, -75.9862>, <-44.8422, 336.1274, -76.105>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-46.01461, 337.3676, -75.9862>, <-46.3985, 338.2538, -75.7736>, <-44.8422, 336.1274, -76.105> }
					triangle { <-46.01461, 337.3676, -75.9862>, <-46.8763, 338.0184, -75.9932>, <-46.3985, 338.2538, -75.7736> }
					triangle { <-44.7112, 335.3471, -76.3504>, <-46.8763, 338.0184, -75.9932>, <-46.01461, 337.3676, -75.9862> }
					triangle { <-44.4419, 341.7093, -80.5889>, <-44.00754, 340.7315, -78.893>, <-46.3985, 338.2538, -75.7736> }
					triangle { <-45.7761, 340.6287, -81.5116>, <-45.783, 341.0873, -82.2332>, <-44.4419, 341.7093, -80.5889> }
					triangle { <-44.4419, 341.7093, -80.5889>, <-46.3985, 338.2538, -75.7736>, <-45.7761, 340.6287, -81.5116> }
					triangle { <-46.8763, 338.0184, -75.9932>, <-45.7761, 340.6287, -81.5116>, <-46.3985, 338.2538, -75.7736> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-44.7112, 335.3471, -76.3504>, <-45.3515, 335.6947, -75.9562>, <-46.3541, 337.0792, -75.887> }
					triangle { <-45.3515, 335.6947, -75.9562>, <-47.07764, 337.6768, -75.5752>, <-46.3541, 337.0792, -75.887> }
					triangle { <-47.07764, 337.6768, -75.5752>, <-46.8763, 338.0184, -75.9932>, <-46.3541, 337.0792, -75.887> }
					triangle { <-46.3541, 337.0792, -75.887>, <-46.8763, 338.0184, -75.9932>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-47.07764, 337.6768, -75.5752>, <-50.7144, 335.0255, -76.8749>, <-52.09242, 335.2095, -78.3538> }
					triangle { <-52.09242, 335.2095, -78.3538>, <-51.9395, 335.8489, -80.3759>, <-51.2323, 335.9932, -79.9175> }
					triangle { <-51.2323, 335.9932, -79.9175>, <-47.07764, 337.6768, -75.5752>, <-52.09242, 335.2095, -78.3538> }
					triangle { <-47.07764, 337.6768, -75.5752>, <-51.2323, 335.9932, -79.9175>, <-46.8763, 338.0184, -75.9932> }
					triangle { <-46.09357, 337.3476, -76.3148>, <-44.9606, 336.0974, -76.5979>, <-44.7112, 335.3471, -76.3504> }
					triangle { <-46.09357, 337.3476, -76.3148>, <-46.5564, 338.2137, -76.4308>, <-44.9606, 336.0974, -76.5979> }
					triangle { <-46.09357, 337.3476, -76.3148>, <-46.8763, 338.0184, -75.9932>, <-46.5564, 338.2137, -76.4308> }
					triangle { <-44.7112, 335.3471, -76.3504>, <-46.8763, 338.0184, -75.9932>, <-46.09357, 337.3476, -76.3148> }
					triangle { <-50.3117, 337.0437, -81.2769>, <-48.456, 337.3518, -80.5823>, <-46.5564, 338.2137, -76.4308> }
					triangle { <-51.2323, 335.9932, -79.9175>, <-51.9395, 335.8489, -80.3759>, <-50.3117, 337.0437, -81.2769> }
					triangle { <-50.3117, 337.0437, -81.2769>, <-46.5564, 338.2137, -76.4308>, <-51.2323, 335.9932, -79.9175> }
					triangle { <-46.8763, 338.0184, -75.9932>, <-51.2323, 335.9932, -79.9175>, <-46.5564, 338.2137, -76.4308> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-31.02162, 320.9141, -71.07594>, <-32.04968, 321.9991, -72.8948>, 0.2999 }
			cylinder { <-32.04968, 321.9991, -72.8948>, <-33.03644, 323.0352, -74.7643>, 0.2999 }
			cylinder { <-33.03644, 323.0352, -74.7643>, <-33.9806, 324.0211, -76.6824>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.9806, 324.0211, -76.6824>, <-34.8411, 326.9098, -83.0698>, 0.2999 }
				cylinder { <-34.8411, 326.9098, -83.0698>, <-33.655, 329.4806, -89.5402>, 0.2999 }
				cylinder { <-33.655, 329.4806, -89.5402>, <-30.5246, 331.5123, -95.5366>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-30.5246, 331.5123, -95.5366>, <-29.9038, 331.4263, -96.07832>, <-29.2502, 332.0135, -97.5462> }
					triangle { <-29.9038, 331.4263, -96.07832>, <-28.6264, 332.0924, -98.3094>, <-29.2502, 332.0135, -97.5462> }
					triangle { <-28.6264, 332.0924, -98.3094>, <-28.9924, 332.5067, -98.4716>, <-29.2502, 332.0135, -97.5462> }
					triangle { <-29.2502, 332.0135, -97.5462>, <-28.9924, 332.5067, -98.4716>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-28.6264, 332.0924, -98.3094>, <-24.9024, 333.6669, -95.9434>, <-23.9919, 335.4789, -95.8581> }
					triangle { <-23.9919, 335.4789, -95.8581>, <-24.7593, 337.4614, -95.8102>, <-25.3515, 336.8698, -95.9851> }
					triangle { <-25.3515, 336.8698, -95.9851>, <-28.6264, 332.0924, -98.3094>, <-23.9919, 335.4789, -95.8581> }
					triangle { <-28.6264, 332.0924, -98.3094>, <-25.3515, 336.8698, -95.9851>, <-28.9924, 332.5067, -98.4716> }
					triangle { <-29.6582, 332.4005, -97.628>, <-30.5158, 332.0069, -96.201>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-29.6582, 332.4005, -97.628>, <-29.4423, 332.8665, -98.473>, <-30.5158, 332.0069, -96.201> }
					triangle { <-29.6582, 332.4005, -97.628>, <-28.9924, 332.5067, -98.4716>, <-29.4423, 332.8665, -98.473> }
					triangle { <-30.5246, 331.5123, -95.5366>, <-28.9924, 332.5067, -98.4716>, <-29.6582, 332.4005, -97.628> }
					triangle { <-26.7796, 338.1239, -96.4173>, <-28.4381, 337.0215, -96.6526>, <-29.4423, 332.8665, -98.473> }
					triangle { <-25.3515, 336.8698, -95.9851>, <-24.7593, 337.4614, -95.8102>, <-26.7796, 338.1239, -96.4173> }
					triangle { <-26.7796, 338.1239, -96.4173>, <-29.4423, 332.8665, -98.473>, <-25.3515, 336.8698, -95.9851> }
					triangle { <-28.9924, 332.5067, -98.4716>, <-25.3515, 336.8698, -95.9851>, <-29.4423, 332.8665, -98.473> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-30.5246, 331.5123, -95.5366>, <-30.3311, 331.3531, -96.3261>, <-29.535, 331.9647, -97.7114> }
					triangle { <-30.3311, 331.3531, -96.3261>, <-29.1961, 331.9948, -98.6399>, <-29.535, 331.9647, -97.7114> }
					triangle { <-29.1961, 331.9948, -98.6399>, <-28.9924, 332.5067, -98.4716>, <-29.535, 331.9647, -97.7114> }
					triangle { <-29.535, 331.9647, -97.7114>, <-28.9924, 332.5067, -98.4716>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-29.1961, 331.9948, -98.6399>, <-26.08366, 328.5095, -98.3074>, <-24.05467, 328.4763, -98.2635> }
					triangle { <-24.05467, 328.4763, -98.2635>, <-22.6265, 329.734, -97.3149>, <-23.4233, 330.0433, -97.2914> }
					triangle { <-23.4233, 330.0433, -97.2914>, <-29.1961, 331.9948, -98.6399>, <-24.05467, 328.4763, -98.2635> }
					triangle { <-29.1961, 331.9948, -98.6399>, <-23.4233, 330.0433, -97.2914>, <-28.9924, 332.5067, -98.4716> }
					triangle { <-29.3733, 332.4494, -97.4628>, <-30.08855, 332.0802, -95.9532>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-29.3733, 332.4494, -97.4628>, <-28.8727, 332.9642, -98.1426>, <-30.08855, 332.0802, -95.9532> }
					triangle { <-29.3733, 332.4494, -97.4628>, <-28.9924, 332.5067, -98.4716>, <-28.8727, 332.9642, -98.1426> }
					triangle { <-30.5246, 331.5123, -95.5366>, <-28.9924, 332.5067, -98.4716>, <-29.3733, 332.4494, -97.4628> }
					triangle { <-22.9496, 331.7886, -96.5643>, <-24.6821, 332.7105, -96.1524>, <-28.8727, 332.9642, -98.1426> }
					triangle { <-23.4233, 330.0433, -97.2914>, <-22.6265, 329.734, -97.3149>, <-22.9496, 331.7886, -96.5643> }
					triangle { <-22.9496, 331.7886, -96.5643>, <-28.8727, 332.9642, -98.1426>, <-23.4233, 330.0433, -97.2914> }
					triangle { <-28.9924, 332.5067, -98.4716>, <-23.4233, 330.0433, -97.2914>, <-28.8727, 332.9642, -98.1426> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-30.5246, 331.5123, -95.5366>, <-30.5919, 331.7788, -96.318>, <-29.7089, 332.2485, -97.706> }
					triangle { <-30.5919, 331.7788, -96.318>, <-29.5438, 332.5624, -98.629>, <-29.7089, 332.2485, -97.706> }
					triangle { <-29.5438, 332.5624, -98.629>, <-28.9924, 332.5067, -98.4716>, <-29.7089, 332.2485, -97.706> }
					triangle { <-29.7089, 332.2485, -97.706>, <-28.9924, 332.5067, -98.4716>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-29.5438, 332.5624, -98.629>, <-31.2575, 328.8388, -100.8969>, <-30.3765, 327.3425, -101.948> }
					triangle { <-30.3765, 327.3425, -101.948>, <-28.5979, 326.224, -101.6216>, <-28.6785, 326.8974, -101.1008> }
					triangle { <-28.6785, 326.8974, -101.1008>, <-29.5438, 332.5624, -98.629>, <-30.3765, 327.3425, -101.948> }
					triangle { <-29.5438, 332.5624, -98.629>, <-28.6785, 326.8974, -101.1008>, <-28.9924, 332.5067, -98.4716> }
					triangle { <-29.1995, 332.1655, -97.4682>, <-29.8277, 331.6544, -95.9613>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-29.1995, 332.1655, -97.4682>, <-28.525, 332.3965, -98.1534>, <-29.8277, 331.6544, -95.9613> }
					triangle { <-29.1995, 332.1655, -97.4682>, <-28.9924, 332.5067, -98.4716>, <-28.525, 332.3965, -98.1534> }
					triangle { <-30.5246, 331.5123, -95.5366>, <-28.9924, 332.5067, -98.4716>, <-29.1995, 332.1655, -97.4682> }
					triangle { <-26.8955, 326.7756, -100.3228>, <-26.8426, 328.1198, -98.8357>, <-28.525, 332.3965, -98.1534> }
					triangle { <-28.6785, 326.8974, -101.1008>, <-28.5979, 326.224, -101.6216>, <-26.8955, 326.7756, -100.3228> }
					triangle { <-26.8955, 326.7756, -100.3228>, <-28.525, 332.3965, -98.1534>, <-28.6785, 326.8974, -101.1008> }
					triangle { <-28.9924, 332.5067, -98.4716>, <-28.6785, 326.8974, -101.1008>, <-28.525, 332.3965, -98.1534> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-30.5246, 331.5123, -95.5366>, <-30.3282, 332.1192, -96.06511>, <-29.5331, 332.4754, -97.5374> }
					triangle { <-30.3282, 332.1192, -96.06511>, <-29.1922, 333.0163, -98.2918>, <-29.5331, 332.4754, -97.5374> }
					triangle { <-29.1922, 333.0163, -98.2918>, <-28.9924, 332.5067, -98.4716>, <-29.5331, 332.4754, -97.5374> }
					triangle { <-29.5331, 332.4754, -97.5374>, <-28.9924, 332.5067, -98.4716>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-29.1922, 333.0163, -98.2918>, <-33.3222, 334.2029, -100.1574>, <-34.2799, 333.6339, -101.8541> }
					triangle { <-34.2799, 333.6339, -101.8541>, <-34.4769, 331.7492, -102.8187>, <-33.9036, 331.7502, -102.1843> }
					triangle { <-33.9036, 331.7502, -102.1843>, <-29.1922, 333.0163, -98.2918>, <-34.2799, 333.6339, -101.8541> }
					triangle { <-29.1922, 333.0163, -98.2918>, <-33.9036, 331.7502, -102.1843>, <-28.9924, 332.5067, -98.4716> }
					triangle { <-29.3752, 331.9386, -97.6368>, <-30.09144, 331.314, -96.2142>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-29.3752, 331.9386, -97.6368>, <-28.8765, 331.9427, -98.4907>, <-30.09144, 331.314, -96.2142> }
					triangle { <-29.3752, 331.9386, -97.6368>, <-28.9924, 332.5067, -98.4716>, <-28.8765, 331.9427, -98.4907> }
					triangle { <-30.5246, 331.5123, -95.5366>, <-28.9924, 332.5067, -98.4716>, <-29.3752, 331.9386, -97.6368> }
					triangle { <-33.2011, 329.9659, -102.5337>, <-31.954, 329.5507, -101.0193>, <-28.8765, 331.9427, -98.4907> }
					triangle { <-33.9036, 331.7502, -102.1843>, <-34.4769, 331.7492, -102.8187>, <-33.2011, 329.9659, -102.5337> }
					triangle { <-33.2011, 329.9659, -102.5337>, <-28.8765, 331.9427, -98.4907>, <-33.9036, 331.7502, -102.1843> }
					triangle { <-28.9924, 332.5067, -98.4716>, <-33.9036, 331.7502, -102.1843>, <-28.8765, 331.9427, -98.4907> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-30.5246, 331.5123, -95.5366>, <-29.8966, 331.898, -95.9147>, <-29.2453, 332.328, -97.4371> }
					triangle { <-29.8966, 331.898, -95.9147>, <-28.6167, 332.7214, -98.09126>, <-29.2453, 332.328, -97.4371> }
					triangle { <-28.6167, 332.7214, -98.09126>, <-28.9924, 332.5067, -98.4716>, <-29.2453, 332.328, -97.4371> }
					triangle { <-29.2453, 332.328, -97.4371>, <-28.9924, 332.5067, -98.4716>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-28.6167, 332.7214, -98.09126>, <-29.3353, 337.2318, -97.04974>, <-30.2744, 338.7384, -98.03361> }
					triangle { <-30.2744, 338.7384, -98.03361>, <-32.06884, 338.7991, -99.1728>, <-31.8163, 338.0065, -98.9749> }
					triangle { <-31.8163, 338.0065, -98.9749>, <-28.6167, 332.7214, -98.09126>, <-30.2744, 338.7384, -98.03361> }
					triangle { <-28.6167, 332.7214, -98.09126>, <-31.8163, 338.0065, -98.9749>, <-28.9924, 332.5067, -98.4716> }
					triangle { <-29.663, 332.0861, -97.7371>, <-30.523, 331.5352, -96.3646>, <-30.5246, 331.5123, -95.5366> }
					triangle { <-29.663, 332.0861, -97.7371>, <-29.452, 332.2376, -98.6912>, <-30.523, 331.5352, -96.3646> }
					triangle { <-29.663, 332.0861, -97.7371>, <-28.9924, 332.5067, -98.4716>, <-29.452, 332.2376, -98.6912> }
					triangle { <-30.5246, 331.5123, -95.5366>, <-28.9924, 332.5067, -98.4716>, <-29.663, 332.0861, -97.7371> }
					triangle { <-33.1284, 337.0854, -100.0836>, <-32.955, 335.1353, -99.6497>, <-29.452, 332.2376, -98.6912> }
					triangle { <-31.8163, 338.0065, -98.9749>, <-32.06884, 338.7991, -99.1728>, <-33.1284, 337.0854, -100.0836> }
					triangle { <-33.1284, 337.0854, -100.0836>, <-29.452, 332.2376, -98.6912>, <-31.8163, 338.0065, -98.9749> }
					triangle { <-28.9924, 332.5067, -98.4716>, <-31.8163, 338.0065, -98.9749>, <-29.452, 332.2376, -98.6912> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-33.9806, 324.0211, -76.6824>, <-34.9974, 325.0077, -78.5627>, 0.2999 }
			cylinder { <-34.9974, 325.0077, -78.5627>, <-36.08533, 325.9938, -80.4029>, 0.2999 }
			cylinder { <-36.08533, 325.9938, -80.4029>, <-37.2431, 326.9782, -82.201>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-37.2431, 326.9782, -82.201>, <-42.08573, 328.4469, -87.128>, 0.2999 }
				cylinder { <-42.08573, 328.4469, -87.128>, <-47.8802, 328.3047, -91.1637>, 0.2999 }
				cylinder { <-47.8802, 328.3047, -91.1637>, <-54.1276, 326.5637, -93.9604>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-54.1276, 326.5637, -93.9604>, <-54.8714, 326.199, -93.9622>, <-56.2577, 325.8764, -94.9113> }
					triangle { <-54.8714, 326.199, -93.9622>, <-57.1522, 325.5249, -95.1441>, <-56.2577, 325.8764, -94.9113> }
					triangle { <-57.1522, 325.5249, -95.1441>, <-57.03738, 325.7729, -95.6513>, <-56.2577, 325.8764, -94.9113> }
					triangle { <-56.2577, 325.8764, -94.9113>, <-57.03738, 325.7729, -95.6513>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-57.1522, 325.5249, -95.1441>, <-56.1167, 320.959, -94.9839>, <-55.908, 319.5442, -96.4242> }
					triangle { <-55.908, 319.5442, -96.4242>, <-55.02349, 319.5944, -98.3572>, <-55.1043, 320.3662, -97.9982> }
					triangle { <-55.1043, 320.3662, -97.9982>, <-57.1522, 325.5249, -95.1441>, <-55.908, 319.5442, -96.4242> }
					triangle { <-57.1522, 325.5249, -95.1441>, <-55.1043, 320.3662, -97.9982>, <-57.03738, 325.7729, -95.6513> }
					triangle { <-56.06319, 326.146, -95.3722>, <-54.5796, 326.6034, -94.6535>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-56.06319, 326.146, -95.3722>, <-56.7631, 326.0641, -96.06591>, <-54.5796, 326.6034, -94.6535> }
					triangle { <-56.06319, 326.146, -95.3722>, <-57.03738, 325.7729, -95.6513>, <-56.7631, 326.0641, -96.06591> }
					triangle { <-54.1276, 326.5637, -93.9604>, <-57.03738, 325.7729, -95.6513>, <-56.06319, 326.146, -95.3722> }
					triangle { <-54.5786, 321.3865, -99.5736>, <-54.4307, 323.2957, -98.9783>, <-56.7631, 326.0641, -96.06591> }
					triangle { <-55.1043, 320.3662, -97.9982>, <-55.02349, 319.5944, -98.3572>, <-54.5786, 321.3865, -99.5736> }
					triangle { <-54.5786, 321.3865, -99.5736>, <-56.7631, 326.0641, -96.06591>, <-55.1043, 320.3662, -97.9982> }
					triangle { <-57.03738, 325.7729, -95.6513>, <-55.1043, 320.3662, -97.9982>, <-56.7631, 326.0641, -96.06591> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-54.1276, 326.5637, -93.9604>, <-54.9402, 326.6818, -94.06956>, <-56.3036, 326.1982, -94.9828> }
					triangle { <-54.9402, 326.6818, -94.06956>, <-57.244, 326.1686, -95.2872>, <-56.3036, 326.1982, -94.9828> }
					triangle { <-57.244, 326.1686, -95.2872>, <-57.03738, 325.7729, -95.6513>, <-56.3036, 326.1982, -94.9828> }
					triangle { <-56.3036, 326.1982, -94.9828>, <-57.03738, 325.7729, -95.6513>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-57.244, 326.1686, -95.2872>, <-59.1292, 324.3687, -91.3948>, <-59.9003, 322.5429, -90.9566> }
					triangle { <-59.9003, 322.5429, -90.9566>, <-59.2891, 320.5733, -91.4746>, <-58.8698, 321.1845, -91.901> }
					triangle { <-58.8698, 321.1845, -91.901>, <-57.244, 326.1686, -95.2872>, <-59.9003, 322.5429, -90.9566> }
					triangle { <-57.244, 326.1686, -95.2872>, <-58.8698, 321.1845, -91.901>, <-57.03738, 325.7729, -95.6513> }
					triangle { <-56.01728, 325.8241, -95.3006>, <-54.5107, 326.1206, -94.5462>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-56.01728, 325.8241, -95.3006>, <-56.6713, 325.4204, -95.9228>, <-54.5107, 326.1206, -94.5462> }
					triangle { <-56.01728, 325.8241, -95.3006>, <-57.03738, 325.7729, -95.6513>, <-56.6713, 325.4204, -95.9228> }
					triangle { <-54.1276, 326.5637, -93.9604>, <-57.03738, 325.7729, -95.6513>, <-56.01728, 325.8241, -95.3006> }
					triangle { <-57.9436, 319.9865, -93.1282>, <-56.6474, 321.1263, -94.1489>, <-56.6713, 325.4204, -95.9228> }
					triangle { <-58.8698, 321.1845, -91.901>, <-59.2891, 320.5733, -91.4746>, <-57.9436, 319.9865, -93.1282> }
					triangle { <-57.9436, 319.9865, -93.1282>, <-56.6713, 325.4204, -95.9228>, <-58.8698, 321.1845, -91.901> }
					triangle { <-57.03738, 325.7729, -95.6513>, <-58.8698, 321.1845, -91.901>, <-56.6713, 325.4204, -95.9228> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-54.1276, 326.5637, -93.9604>, <-54.7143, 326.7794, -94.504>, <-56.153, 326.2633, -95.2725> }
					triangle { <-54.7143, 326.7794, -94.504>, <-56.9427, 326.2988, -95.8665>, <-56.153, 326.2633, -95.2725> }
					triangle { <-56.9427, 326.2988, -95.8665>, <-57.03738, 325.7729, -95.6513>, <-56.153, 326.2633, -95.2725> }
					triangle { <-56.153, 326.2633, -95.2725>, <-57.03738, 325.7729, -95.6513>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-56.9427, 326.2988, -95.8665>, <-59.2703, 329.7057, -93.6483>, <-60.9477, 329.7075, -92.5054> }
					triangle { <-60.9477, 329.7075, -92.5054>, <-61.6676, 328.3621, -91.02457>, <-60.9954, 328.0629, -91.4603> }
					triangle { <-60.9954, 328.0629, -91.4603>, <-56.9427, 326.2988, -95.8665>, <-60.9477, 329.7075, -92.5054> }
					triangle { <-56.9427, 326.2988, -95.8665>, <-60.9954, 328.0629, -91.4603>, <-57.03738, 325.7729, -95.6513> }
					triangle { <-56.1679, 325.759, -95.01102>, <-54.7366, 326.023, -94.1117>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-56.1679, 325.759, -95.01102>, <-56.9725, 325.2902, -95.3435>, <-54.7366, 326.023, -94.1117> }
					triangle { <-56.1679, 325.759, -95.01102>, <-57.03738, 325.7729, -95.6513>, <-56.9725, 325.2902, -95.3435> }
					triangle { <-54.1276, 326.5637, -93.9604>, <-57.03738, 325.7729, -95.6513>, <-56.1679, 325.759, -95.01102> }
					triangle { <-61.04947, 326.2613, -90.7184>, <-59.3993, 325.3349, -91.3818>, <-56.9725, 325.2902, -95.3435> }
					triangle { <-60.9954, 328.0629, -91.4603>, <-61.6676, 328.3621, -91.02457>, <-61.04947, 326.2613, -90.7184> }
					triangle { <-61.04947, 326.2613, -90.7184>, <-56.9725, 325.2902, -95.3435>, <-60.9954, 328.0629, -91.4603> }
					triangle { <-57.03738, 325.7729, -95.6513>, <-60.9954, 328.0629, -91.4603>, <-56.9725, 325.2902, -95.3435> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-54.1276, 326.5637, -93.9604>, <-54.5037, 326.3579, -94.6693>, <-56.01262, 325.9823, -95.3827> }
					triangle { <-54.5037, 326.3579, -94.6693>, <-56.6619, 325.7368, -96.08688>, <-56.01262, 325.9823, -95.3827> }
					triangle { <-56.6619, 325.7368, -96.08688>, <-57.03738, 325.7729, -95.6513>, <-56.01262, 325.9823, -95.3827> }
					triangle { <-56.01262, 325.9823, -95.3827>, <-57.03738, 325.7729, -95.6513>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-56.6619, 325.7368, -96.08688>, <-56.3464, 329.6444, -98.6512>, <-57.6124, 331.2035, -98.9447> }
					triangle { <-57.6124, 331.2035, -98.9447>, <-58.8941, 332.2696, -97.6249>, <-58.5634, 331.56, -97.2811> }
					triangle { <-58.5634, 331.56, -97.2811>, <-56.6619, 325.7368, -96.08688>, <-57.6124, 331.2035, -98.9447> }
					triangle { <-56.6619, 325.7368, -96.08688>, <-58.5634, 331.56, -97.2811>, <-57.03738, 325.7729, -95.6513> }
					triangle { <-56.3083, 326.04, -94.9008>, <-54.9472, 326.4445, -93.9465>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-56.3083, 326.04, -94.9008>, <-57.2533, 325.8522, -95.1231>, <-54.9472, 326.4445, -93.9465> }
					triangle { <-56.3083, 326.04, -94.9008>, <-57.03738, 325.7729, -95.6513>, <-57.2533, 325.8522, -95.1231> }
					triangle { <-54.1276, 326.5637, -93.9604>, <-57.03738, 325.7729, -95.6513>, <-56.3083, 326.04, -94.9008> }
					triangle { <-59.633, 331.598, -95.652>, <-58.9091, 330.1446, -94.4752>, <-57.2533, 325.8522, -95.1231> }
					triangle { <-58.5634, 331.56, -97.2811>, <-58.8941, 332.2696, -97.6249>, <-59.633, 331.598, -95.652> }
					triangle { <-59.633, 331.598, -95.652>, <-57.2533, 325.8522, -95.1231>, <-58.5634, 331.56, -97.2811> }
					triangle { <-57.03738, 325.7729, -95.6513>, <-58.5634, 331.56, -97.2811>, <-57.2533, 325.8522, -95.1231> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-54.1276, 326.5637, -93.9604>, <-54.6022, 325.9938, -94.3293>, <-56.07831, 325.7396, -95.1561> }
					triangle { <-54.6022, 325.9938, -94.3293>, <-56.7933, 325.2513, -95.6336>, <-56.07831, 325.7396, -95.1561> }
					triangle { <-56.7933, 325.2513, -95.6336>, <-57.03738, 325.7729, -95.6513>, <-56.07831, 325.7396, -95.1561> }
					triangle { <-56.07831, 325.7396, -95.1561>, <-57.03738, 325.7729, -95.6513>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-56.7933, 325.2513, -95.6336>, <-54.368, 324.157, -99.4892>, <-54.4507, 324.8274, -101.4033> }
					triangle { <-54.4507, 324.8274, -101.4033>, <-54.7259, 326.7691, -102.2252>, <-54.8675, 326.7314, -101.3828> }
					triangle { <-54.8675, 326.7314, -101.3828>, <-56.7933, 325.2513, -95.6336>, <-54.4507, 324.8274, -101.4033> }
					triangle { <-56.7933, 325.2513, -95.6336>, <-54.8675, 326.7314, -101.3828>, <-57.03738, 325.7729, -95.6513> }
					triangle { <-56.2426, 326.2828, -95.1274>, <-54.8487, 326.8087, -94.2864>, <-54.1276, 326.5637, -93.9604> }
					triangle { <-56.2426, 326.2828, -95.1274>, <-57.1219, 326.3378, -95.5763>, <-54.8487, 326.8087, -94.2864> }
					triangle { <-56.2426, 326.2828, -95.1274>, <-57.03738, 325.7729, -95.6513>, <-57.1219, 326.3378, -95.5763> }
					triangle { <-54.1276, 326.5637, -93.9604>, <-57.03738, 325.7729, -95.6513>, <-56.2426, 326.2828, -95.1274> }
					triangle { <-55.5734, 328.5397, -101.2075>, <-55.7919, 328.8653, -99.2409>, <-57.1219, 326.3378, -95.5763> }
					triangle { <-54.8675, 326.7314, -101.3828>, <-54.7259, 326.7691, -102.2252>, <-55.5734, 328.5397, -101.2075> }
					triangle { <-55.5734, 328.5397, -101.2075>, <-57.1219, 326.3378, -95.5763>, <-54.8675, 326.7314, -101.3828> }
					triangle { <-57.03738, 325.7729, -95.6513>, <-54.8675, 326.7314, -101.3828>, <-57.1219, 326.3378, -95.5763> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-37.2431, 326.9782, -82.201>, <-38.338, 328.0136, -84.00983>, 0.2999 }
			cylinder { <-38.338, 328.0136, -84.00983>, <-39.3687, 329.0986, -85.8272>, 0.2999 }
			cylinder { <-39.3687, 329.0986, -85.8272>, <-40.3338, 330.2321, -87.651>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-40.3338, 330.2321, -87.651>, <-42.543, 335.2802, -92.06902>, 0.2999 }
				cylinder { <-42.543, 335.2802, -92.06902>, <-43.8758, 341.5414, -95.05297>, 0.2999 }
				cylinder { <-43.8758, 341.5414, -95.05297>, <-44.2174, 348.4764, -96.3459>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-44.2174, 348.4764, -96.3459>, <-43.8982, 349.2343, -96.2456>, <-44.09857, 350.8882, -96.6345> }
					triangle { <-43.8982, 349.2343, -96.2456>, <-43.9087, 351.8585, -96.6543>, <-44.09857, 350.8882, -96.6345> }
					triangle { <-43.9087, 351.8585, -96.6543>, <-44.3846, 351.871, -96.9788>, <-44.09857, 350.8882, -96.6345> }
					triangle { <-44.09857, 350.8882, -96.6345>, <-44.3846, 351.871, -96.9788>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-43.9087, 351.8585, -96.6543>, <-44.6749, 352.7622, -92.1221>, <-46.1626, 353.739, -91.1462> }
					triangle { <-46.1626, 353.739, -91.1462>, <-48.27, 353.7758, -91.4267>, <-47.8475, 353.3889, -92.0615> }
					triangle { <-47.8475, 353.3889, -92.0615>, <-43.9087, 351.8585, -96.6543>, <-46.1626, 353.739, -91.1462> }
					triangle { <-43.9087, 351.8585, -96.6543>, <-47.8475, 353.3889, -92.0615>, <-44.3846, 351.871, -96.9788> }
					triangle { <-44.5699, 350.8077, -96.9416>, <-44.6052, 349.1136, -96.7063>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-44.5699, 350.8077, -96.9416>, <-44.8514, 351.6975, -97.2685>, <-44.6052, 349.1136, -96.7063> }
					triangle { <-44.5699, 350.8077, -96.9416>, <-44.3846, 351.871, -96.9788>, <-44.8514, 351.6975, -97.2685> }
					triangle { <-44.2174, 348.4764, -96.3459>, <-44.3846, 351.871, -96.9788>, <-44.5699, 350.8077, -96.9416> }
					triangle { <-49.3835, 353.1891, -93.2447>, <-48.7598, 352.0647, -94.7836>, <-44.8514, 351.6975, -97.2685> }
					triangle { <-47.8475, 353.3889, -92.0615>, <-48.27, 353.7758, -91.4267>, <-49.3835, 353.1891, -93.2447> }
					triangle { <-49.3835, 353.1891, -93.2447>, <-44.8514, 351.6975, -97.2685>, <-47.8475, 353.3889, -92.0615> }
					triangle { <-44.3846, 351.871, -96.9788>, <-47.8475, 353.3889, -92.0615>, <-44.8514, 351.6975, -97.2685> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-44.2174, 348.4764, -96.3459>, <-43.9156, 349.142, -96.7361>, <-44.1101, 350.8267, -96.9615> }
					triangle { <-43.9156, 349.142, -96.7361>, <-43.9318, 351.7354, -97.3083>, <-44.1101, 350.8267, -96.9615> }
					triangle { <-43.9318, 351.7354, -97.3083>, <-44.3846, 351.871, -96.9788>, <-44.1101, 350.8267, -96.9615> }
					triangle { <-44.1101, 350.8267, -96.9615>, <-44.3846, 351.871, -96.9788>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-43.9318, 351.7354, -97.3083>, <-39.7926, 352.424, -95.2256>, <-39.2079, 353.6083, -93.6844> }
					triangle { <-39.2079, 353.6083, -93.6844>, <-40.1304, 354.101, -91.833>, <-40.6475, 353.6855, -92.3726> }
					triangle { <-40.6475, 353.6855, -92.3726>, <-43.9318, 351.7354, -97.3083>, <-39.2079, 353.6083, -93.6844> }
					triangle { <-43.9318, 351.7354, -97.3083>, <-40.6475, 353.6855, -92.3726>, <-44.3846, 351.871, -96.9788> }
					triangle { <-44.5583, 350.8693, -96.6146>, <-44.5879, 349.2059, -96.2158>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-44.5583, 350.8693, -96.6146>, <-44.8282, 351.8206, -96.6146>, <-44.5879, 349.2059, -96.2158> }
					triangle { <-44.5583, 350.8693, -96.6146>, <-44.3846, 351.871, -96.9788>, <-44.8282, 351.8206, -96.6146> }
					triangle { <-44.2174, 348.4764, -96.3459>, <-44.3846, 351.871, -96.9788>, <-44.5583, 350.8693, -96.6146> }
					triangle { <-42.2704, 353.8993, -91.3144>, <-43.6767, 352.7931, -92.2198>, <-44.8282, 351.8206, -96.6146> }
					triangle { <-40.6475, 353.6855, -92.3726>, <-40.1304, 354.101, -91.833>, <-42.2704, 353.8993, -91.3144> }
					triangle { <-42.2704, 353.8993, -91.3144>, <-44.8282, 351.8206, -96.6146>, <-40.6475, 353.6855, -92.3726> }
					triangle { <-44.3846, 351.871, -96.9788>, <-40.6475, 353.6855, -92.3726>, <-44.8282, 351.8206, -96.6146> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-44.2174, 348.4764, -96.3459>, <-44.3944, 349.0936, -96.8694>, <-44.4293, 350.7944, -97.05043> }
					triangle { <-44.3944, 349.0936, -96.8694>, <-44.5702, 351.6708, -97.4861>, <-44.4293, 350.7944, -97.05043> }
					triangle { <-44.5702, 351.6708, -97.4861>, <-44.3846, 351.871, -96.9788>, <-44.4293, 350.7944, -97.05043> }
					triangle { <-44.4293, 350.7944, -97.05043>, <-44.3846, 351.871, -96.9788>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-44.5702, 351.6708, -97.4861>, <-41.2135, 351.3268, -100.7356>, <-39.4155, 352.2419, -100.9588> }
					triangle { <-39.4155, 352.2419, -100.9588>, <-37.8994, 352.7694, -99.5644>, <-38.6274, 352.5127, -99.1967> }
					triangle { <-38.6274, 352.5127, -99.1967>, <-44.5702, 351.6708, -97.4861>, <-39.4155, 352.2419, -100.9588> }
					triangle { <-44.5702, 351.6708, -97.4861>, <-38.6274, 352.5127, -99.1967>, <-44.3846, 351.871, -96.9788> }
					triangle { <-44.2391, 350.9016, -96.5257>, <-44.1091, 349.2543, -96.08247>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-44.2391, 350.9016, -96.5257>, <-44.1898, 351.8852, -96.4368>, <-44.1091, 349.2543, -96.08247> }
					triangle { <-44.2391, 350.9016, -96.5257>, <-44.3846, 351.871, -96.9788>, <-44.1898, 351.8852, -96.4368> }
					triangle { <-44.2174, 348.4764, -96.3459>, <-44.3846, 351.871, -96.9788>, <-44.2391, 350.9016, -96.5257> }
					triangle { <-38.1159, 352.9743, -97.3734>, <-39.5652, 352.2557, -96.1884>, <-44.1898, 351.8852, -96.4368> }
					triangle { <-38.6274, 352.5127, -99.1967>, <-37.8994, 352.7694, -99.5644>, <-38.1159, 352.9743, -97.3734> }
					triangle { <-38.1159, 352.9743, -97.3734>, <-44.1898, 351.8852, -96.4368>, <-38.6274, 352.5127, -99.1967> }
					triangle { <-44.3846, 351.871, -96.9788>, <-38.6274, 352.5127, -99.1967>, <-44.1898, 351.8852, -96.4368> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-44.2174, 348.4764, -96.3459>, <-44.6773, 349.1555, -96.4627>, <-44.6179, 350.8356, -96.7792> }
					triangle { <-44.6773, 349.1555, -96.4627>, <-44.9475, 351.7533, -96.9438>, <-44.6179, 350.8356, -96.7792> }
					triangle { <-44.9475, 351.7533, -96.9438>, <-44.3846, 351.871, -96.9788>, <-44.6179, 350.8356, -96.7792> }
					triangle { <-44.6179, 350.8356, -96.7792>, <-44.3846, 351.871, -96.9788>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-44.9475, 351.7533, -96.9438>, <-46.9871, 350.9765, -101.0889>, <-46.5004, 351.5152, -102.9843> }
					triangle { <-46.5004, 351.5152, -102.9843>, <-44.6394, 351.6089, -104.0085>, <-44.5602, 351.4803, -103.1669> }
					triangle { <-44.5602, 351.4803, -103.1669>, <-44.9475, 351.7533, -96.9438>, <-46.5004, 351.5152, -102.9843> }
					triangle { <-44.9475, 351.7533, -96.9438>, <-44.5602, 351.4803, -103.1669>, <-44.3846, 351.871, -96.9788> }
					triangle { <-44.0505, 350.8603, -96.7969>, <-43.8261, 349.1924, -96.4892>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-44.0505, 350.8603, -96.7969>, <-43.8125, 351.8026, -96.9791>, <-43.8261, 349.1924, -96.4892> }
					triangle { <-44.0505, 350.8603, -96.7969>, <-44.3846, 351.871, -96.9788>, <-43.8125, 351.8026, -96.9791> }
					triangle { <-44.2174, 348.4764, -96.3459>, <-44.3846, 351.871, -96.9788>, <-44.0505, 350.8603, -96.7969> }
					triangle { <-42.6227, 351.6837, -103.105>, <-42.06905, 351.1902, -101.2419>, <-43.8125, 351.8026, -96.9791> }
					triangle { <-44.5602, 351.4803, -103.1669>, <-44.6394, 351.6089, -104.0085>, <-42.6227, 351.6837, -103.105> }
					triangle { <-42.6227, 351.6837, -103.105>, <-43.8125, 351.8026, -96.9791>, <-44.5602, 351.4803, -103.1669> }
					triangle { <-44.3846, 351.871, -96.9788>, <-44.5602, 351.4803, -103.1669>, <-43.8125, 351.8026, -96.9791> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-44.2174, 348.4764, -96.3459>, <-44.3661, 349.2437, -96.07137>, <-44.4104, 350.8945, -96.5183> }
					triangle { <-44.3661, 349.2437, -96.07137>, <-44.5325, 351.8711, -96.422>, <-44.4104, 350.8945, -96.5183> }
					triangle { <-44.5325, 351.8711, -96.422>, <-44.3846, 351.871, -96.9788>, <-44.4104, 350.8945, -96.5183> }
					triangle { <-44.4104, 350.8945, -96.5183>, <-44.3846, 351.871, -96.9788>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-44.5325, 351.8711, -96.422>, <-49.1587, 351.877, -95.685>, <-50.7333, 352.4544, -96.8283> }
					triangle { <-50.7333, 352.4544, -96.8283>, <-51.1455, 352.2402, -98.9032>, <-50.3445, 352.0299, -98.6905> }
					triangle { <-50.3445, 352.0299, -98.6905>, <-44.5325, 351.8711, -96.422>, <-50.7333, 352.4544, -96.8283> }
					triangle { <-44.5325, 351.8711, -96.422>, <-50.3445, 352.0299, -98.6905>, <-44.3846, 351.871, -96.9788> }
					triangle { <-44.258, 350.8014, -97.05783>, <-44.1374, 349.1042, -96.8806>, <-44.2174, 348.4764, -96.3459> }
					triangle { <-44.258, 350.8014, -97.05783>, <-44.2276, 351.6849, -97.5009>, <-44.1374, 349.1042, -96.8806> }
					triangle { <-44.258, 350.8014, -97.05783>, <-44.3846, 351.871, -96.9788>, <-44.2276, 351.6849, -97.5009> }
					triangle { <-44.2174, 348.4764, -96.3459>, <-44.3846, 351.871, -96.9788>, <-44.258, 350.8014, -97.05783> }
					triangle { <-49.6915, 351.8185, -100.5148>, <-47.8374, 351.0704, -100.3606>, <-44.2276, 351.6849, -97.5009> }
					triangle { <-50.3445, 352.0299, -98.6905>, <-51.1455, 352.2402, -98.9032>, <-49.6915, 351.8185, -100.5148> }
					triangle { <-49.6915, 351.8185, -100.5148>, <-44.2276, 351.6849, -97.5009>, <-50.3445, 352.0299, -98.6905> }
					triangle { <-44.3846, 351.871, -96.9788>, <-50.3445, 352.0299, -98.6905>, <-44.2276, 351.6849, -97.5009> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-40.3338, 330.2321, -87.651>, <-41.3241, 331.2937, -89.5043>, 0.2999 }
			cylinder { <-41.3241, 331.2937, -89.5043>, <-42.3385, 332.2821, -91.3849>, 0.2999 }
			cylinder { <-42.3385, 332.2821, -91.3849>, <-43.3757, 333.1961, -93.2906>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-43.3757, 333.1961, -93.2906>, <-45.5056, 334.3591, -99.9233>, 0.2999 }
				cylinder { <-45.5056, 334.3591, -99.9233>, <-46.4705, 333.8429, -106.9009>, 0.2999 }
				cylinder { <-46.4705, 333.8429, -106.9009>, <-46.1873, 331.6919, -113.6222>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-46.1873, 331.6919, -113.6222>, <-46.06105, 331.1449, -114.184>, <-46.01733, 330.8843, -115.8029> }
					triangle { <-46.06105, 331.1449, -114.184>, <-45.9122, 330.4115, -116.6179>, <-46.01733, 330.8843, -115.8029> }
					triangle { <-45.9122, 330.4115, -116.6179>, <-46.03454, 330.9032, -116.838>, <-46.01733, 330.8843, -115.8029> }
					triangle { <-46.01733, 330.8843, -115.8029>, <-46.03454, 330.9032, -116.838>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-45.9122, 330.4115, -116.6179>, <-41.5054, 329.6024, -116.3037>, <-39.9619, 330.3184, -117.2484> }
					triangle { <-39.9619, 330.3184, -117.2484>, <-39.493, 332.2009, -117.875>, <-40.2661, 332.126, -117.6126> }
					triangle { <-40.2661, 332.126, -117.6126>, <-45.9122, 330.4115, -116.6179>, <-39.9619, 330.3184, -117.2484> }
					triangle { <-45.9122, 330.4115, -116.6179>, <-40.2661, 332.126, -117.6126>, <-46.03454, 330.9032, -116.838> }
					triangle { <-46.1438, 331.3976, -115.9348>, <-46.2508, 331.9148, -114.3819>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-46.1438, 331.3976, -115.9348>, <-46.1652, 331.4381, -116.8818>, <-46.2508, 331.9148, -114.3819> }
					triangle { <-46.1438, 331.3976, -115.9348>, <-46.03454, 330.9032, -116.838>, <-46.1652, 331.4381, -116.8818> }
					triangle { <-46.1873, 331.6919, -113.6222>, <-46.03454, 330.9032, -116.838>, <-46.1438, 331.3976, -115.9348> }
					triangle { <-40.8265, 333.8259, -118.1497>, <-42.6019, 334.0509, -117.4469>, <-46.1652, 331.4381, -116.8818> }
					triangle { <-40.2661, 332.126, -117.6126>, <-39.493, 332.2009, -117.875>, <-40.8265, 333.8259, -118.1497> }
					triangle { <-40.8265, 333.8259, -118.1497>, <-46.1652, 331.4381, -116.8818>, <-40.2661, 332.126, -117.6126> }
					triangle { <-46.03454, 330.9032, -116.838>, <-40.2661, 332.126, -117.6126>, <-46.1652, 331.4381, -116.8818> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-46.1873, 331.6919, -113.6222>, <-46.5031, 331.3174, -114.2473>, <-46.312, 330.9992, -115.8451> }
					triangle { <-46.5031, 331.3174, -114.2473>, <-46.5017, 330.6415, -116.7024>, <-46.312, 330.9992, -115.8451> }
					triangle { <-46.5017, 330.6415, -116.7024>, <-46.03454, 330.9032, -116.838>, <-46.312, 330.9992, -115.8451> }
					triangle { <-46.312, 330.9992, -115.8451>, <-46.03454, 330.9032, -116.838>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-46.5017, 330.6415, -116.7024>, <-45.9329, 326.2995, -115.704>, <-44.5498, 325.0101, -116.1645> }
					triangle { <-44.5498, 325.0101, -116.1645>, <-42.5212, 325.1664, -116.2936>, <-42.9006, 325.8881, -116.2078> }
					triangle { <-42.9006, 325.8881, -116.2078>, <-46.5017, 330.6415, -116.7024>, <-44.5498, 325.0101, -116.1645> }
					triangle { <-46.5017, 330.6415, -116.7024>, <-42.9006, 325.8881, -116.2078>, <-46.03454, 330.9032, -116.838> }
					triangle { <-45.8491, 331.2826, -115.8926>, <-45.8087, 331.7424, -114.3186>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-45.8491, 331.2826, -115.8926>, <-45.5757, 331.2082, -116.7973>, <-45.8087, 331.7424, -114.3186> }
					triangle { <-45.8491, 331.2826, -115.8926>, <-46.03454, 330.9032, -116.838>, <-45.5757, 331.2082, -116.7973> }
					triangle { <-46.1873, 331.6919, -113.6222>, <-46.03454, 330.9032, -116.838>, <-45.8491, 331.2826, -115.8926> }
					triangle { <-41.3862, 326.9463, -116.489>, <-41.9204, 328.7551, -116.1156>, <-45.5757, 331.2082, -116.7973> }
					triangle { <-42.9006, 325.8881, -116.2078>, <-42.5212, 325.1664, -116.2936>, <-41.3862, 326.9463, -116.489> }
					triangle { <-41.3862, 326.9463, -116.489>, <-45.5757, 331.2082, -116.7973>, <-42.9006, 325.8881, -116.2078> }
					triangle { <-46.03454, 330.9032, -116.838>, <-42.9006, 325.8881, -116.2078>, <-45.5757, 331.2082, -116.7973> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-46.1873, 331.6919, -113.6222>, <-46.4686, 331.7815, -114.3595>, <-46.289, 331.3087, -115.9199> }
					triangle { <-46.4686, 331.7815, -114.3595>, <-46.4557, 331.2604, -116.852>, <-46.289, 331.3087, -115.9199> }
					triangle { <-46.4557, 331.2604, -116.852>, <-46.03454, 330.9032, -116.838>, <-46.289, 331.3087, -115.9199> }
					triangle { <-46.289, 331.3087, -115.9199>, <-46.03454, 330.9032, -116.838>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-46.4557, 331.2604, -116.852>, <-50.4999, 329.3159, -116.6608>, <-51.1239, 327.524, -117.0934> }
					triangle { <-51.1239, 327.524, -117.0934>, <-50.3087, 325.6802, -116.7897>, <-49.7909, 326.2968, -116.6355> }
					triangle { <-49.7909, 326.2968, -116.6355>, <-46.4557, 331.2604, -116.852>, <-51.1239, 327.524, -117.0934> }
					triangle { <-46.4557, 331.2604, -116.852>, <-49.7909, 326.2968, -116.6355>, <-46.03454, 330.9032, -116.838> }
					triangle { <-45.8721, 330.9731, -115.8178>, <-45.8432, 331.2782, -114.2064>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-45.8721, 330.9731, -115.8178>, <-45.6217, 330.5893, -116.6477>, <-45.8432, 331.2782, -114.2064> }
					triangle { <-45.8721, 330.9731, -115.8178>, <-46.03454, 330.9032, -116.838>, <-45.6217, 330.5893, -116.6477> }
					triangle { <-46.1873, 331.6919, -113.6222>, <-46.03454, 330.9032, -116.838>, <-45.8721, 330.9731, -115.8178> }
					triangle { <-48.2746, 325.2311, -116.3957>, <-46.8861, 326.4078, -115.7759>, <-45.6217, 330.5893, -116.6477> }
					triangle { <-49.7909, 326.2968, -116.6355>, <-50.3087, 325.6802, -116.7897>, <-48.2746, 325.2311, -116.3957> }
					triangle { <-48.2746, 325.2311, -116.3957>, <-45.6217, 330.5893, -116.6477>, <-49.7909, 326.2968, -116.6355> }
					triangle { <-46.03454, 330.9032, -116.838>, <-49.7909, 326.2968, -116.6355>, <-45.6217, 330.5893, -116.6477> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-46.1873, 331.6919, -113.6222>, <-46.00491, 331.9002, -114.3666>, <-45.9799, 331.3878, -115.9246> }
					triangle { <-46.00491, 331.9002, -114.3666>, <-45.8373, 331.4187, -116.8614>, <-45.9799, 331.3878, -115.9246> }
					triangle { <-45.8373, 331.4187, -116.8614>, <-46.03454, 330.9032, -116.838>, <-45.9799, 331.3878, -115.9246> }
					triangle { <-45.9799, 331.3878, -115.9246>, <-46.03454, 330.9032, -116.838>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-45.8373, 331.4187, -116.8614>, <-48.9375, 334.5111, -117.8608>, <-50.6604, 334.4094, -118.7601> }
					triangle { <-50.6604, 334.4094, -118.7601>, <-52.166, 333.037, -118.6823>, <-51.479, 332.7912, -118.3085> }
					triangle { <-51.479, 332.7912, -118.3085>, <-45.8373, 331.4187, -116.8614>, <-50.6604, 334.4094, -118.7601> }
					triangle { <-45.8373, 331.4187, -116.8614>, <-51.479, 332.7912, -118.3085>, <-46.03454, 330.9032, -116.838> }
					triangle { <-46.1812, 330.894, -115.813>, <-46.3069, 331.1595, -114.1993>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-46.1812, 330.894, -115.813>, <-46.2401, 330.431, -116.6383>, <-46.3069, 331.1595, -114.1993> }
					triangle { <-46.1812, 330.894, -115.813>, <-46.03454, 330.9032, -116.838>, <-46.2401, 330.431, -116.6383> }
					triangle { <-46.1873, 331.6919, -113.6222>, <-46.03454, 330.9032, -116.838>, <-46.1812, 330.894, -115.813> }
					triangle { <-52.03652, 331.0348, -117.9978>, <-50.6828, 330.2311, -116.894>, <-46.2401, 330.431, -116.6383> }
					triangle { <-51.479, 332.7912, -118.3085>, <-52.166, 333.037, -118.6823>, <-52.03652, 331.0348, -117.9978> }
					triangle { <-52.03652, 331.0348, -117.9978>, <-46.2401, 330.431, -116.6383>, <-51.479, 332.7912, -118.3085> }
					triangle { <-46.03454, 330.9032, -116.838>, <-51.479, 332.7912, -118.3085>, <-46.2401, 330.431, -116.6383> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-46.1873, 331.6919, -113.6222>, <-45.7491, 331.5009, -114.2565>, <-45.8094, 331.1216, -115.8512> }
					triangle { <-45.7491, 331.5009, -114.2565>, <-45.4963, 330.8861, -116.7146>, <-45.8094, 331.1216, -115.8512> }
					triangle { <-45.4963, 330.8861, -116.7146>, <-46.03454, 330.9032, -116.838>, <-45.8094, 331.1216, -115.8512> }
					triangle { <-45.8094, 331.1216, -115.8512>, <-46.03454, 330.9032, -116.838>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-45.4963, 330.8861, -116.7146>, <-43.2947, 334.6909, -117.6367>, <-43.6578, 336.1625, -118.8573> }
					triangle { <-43.6578, 336.1625, -118.8573>, <-45.3807, 337.1279, -119.3632>, <-45.5035, 336.4482, -118.9215> }
					triangle { <-45.5035, 336.4482, -118.9215>, <-45.4963, 330.8861, -116.7146>, <-43.6578, 336.1625, -118.8573> }
					triangle { <-45.4963, 330.8861, -116.7146>, <-45.5035, 336.4482, -118.9215>, <-46.03454, 330.9032, -116.838> }
					triangle { <-46.3517, 331.1602, -115.8864>, <-46.5627, 331.5589, -114.3094>, <-46.1873, 331.6919, -113.6222> }
					triangle { <-46.3517, 331.1602, -115.8864>, <-46.581, 330.9635, -116.7851>, <-46.5627, 331.5589, -114.3094> }
					triangle { <-46.3517, 331.1602, -115.8864>, <-46.03454, 330.9032, -116.838>, <-46.581, 330.9635, -116.7851> }
					triangle { <-46.1873, 331.6919, -113.6222>, <-46.03454, 330.9032, -116.838>, <-46.3517, 331.1602, -115.8864> }
					triangle { <-47.3638, 336.4268, -119.0983>, <-47.995, 335.0262, -117.9423>, <-46.581, 330.9635, -116.7851> }
					triangle { <-45.5035, 336.4482, -118.9215>, <-45.3807, 337.1279, -119.3632>, <-47.3638, 336.4268, -119.0983> }
					triangle { <-47.3638, 336.4268, -119.0983>, <-46.581, 330.9635, -116.7851>, <-45.5035, 336.4482, -118.9215> }
					triangle { <-46.03454, 330.9032, -116.838>, <-45.5035, 336.4482, -118.9215>, <-46.581, 330.9635, -116.7851> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-27.7847, 317.7325, -65.6682>, <-28.223, 320.0429, -65.7799>, 0.2999 }
			cylinder { <-28.223, 320.0429, -65.7799>, <-28.6224, 322.3627, -65.8204>, 0.2999 }
			cylinder { <-28.6224, 322.3627, -65.8204>, <-28.9825, 324.689, -65.7896>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-28.9825, 324.689, -65.7896>, <-29.7075, 325.8954, -63.9024>, 0.2999 }
			cylinder { <-29.7075, 325.8954, -63.9024>, <-30.4339, 327.1696, -62.0609>, 0.2999 }
			cylinder { <-30.4339, 327.1696, -62.0609>, <-31.1608, 328.51, -60.2671>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-31.1608, 328.51, -60.2671>, <-31.8692, 333.7878, -55.6274>, 0.2999 }
				cylinder { <-31.8692, 333.7878, -55.6274>, <-31.0444, 339.8674, -52.1287>, 0.2999 }
				cylinder { <-31.0444, 339.8674, -52.1287>, <-28.7573, 346.2253, -50.07245>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-28.7573, 346.2253, -50.07245>, <-28.4506, 346.943, -50.3502>, <-27.9424, 348.5089, -49.8851> }
					triangle { <-28.4506, 346.943, -50.3502>, <-27.589, 349.4277, -49.9795>, <-27.9424, 348.5089, -49.8851> }
					triangle { <-27.589, 349.4277, -49.9795>, <-27.6704, 349.4394, -49.4092>, <-27.9424, 348.5089, -49.8851> }
					triangle { <-27.9424, 348.5089, -49.8851>, <-27.6704, 349.4394, -49.4092>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-27.589, 349.4277, -49.9795>, <-23.2203, 348.3148, -51.2525>, <-21.4358, 348.4301, -50.2923> }
					triangle { <-21.4358, 348.4301, -50.2923>, <-20.8668, 348.027, -48.2836>, <-21.7133, 348.0325, -48.4045> }
					triangle { <-21.7133, 348.0325, -48.4045>, <-27.589, 349.4277, -49.9795>, <-21.4358, 348.4301, -50.2923> }
					triangle { <-27.589, 349.4277, -49.9795>, <-21.7133, 348.0325, -48.4045>, <-27.6704, 349.4394, -49.4092> }
					triangle { <-28.05357, 348.4326, -49.3331>, <-28.6173, 346.8285, -49.5221>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-28.05357, 348.4326, -49.3331>, <-27.8113, 349.275, -48.8753>, <-28.6173, 346.8285, -49.5221> }
					triangle { <-28.05357, 348.4326, -49.3331>, <-27.6704, 349.4394, -49.4092>, <-27.8113, 349.275, -48.8753> }
					triangle { <-28.7573, 346.2253, -50.07245>, <-27.6704, 349.4394, -49.4092>, <-28.05357, 348.4326, -49.3331> }
					triangle { <-22.1952, 347.9085, -46.5199>, <-24.1835, 347.6534, -46.468>, <-27.8113, 349.275, -48.8753> }
					triangle { <-21.7133, 348.0325, -48.4045>, <-20.8668, 348.027, -48.2836>, <-22.1952, 347.9085, -46.5199> }
					triangle { <-22.1952, 347.9085, -46.5199>, <-27.8113, 349.275, -48.8753>, <-21.7133, 348.0325, -48.4045> }
					triangle { <-27.6704, 349.4394, -49.4092>, <-21.7133, 348.0325, -48.4045>, <-27.8113, 349.275, -48.8753> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.7573, 346.2253, -50.07245>, <-28.8838, 347.0425, -50.1225>, <-28.2312, 348.5753, -49.7333> }
					triangle { <-28.8838, 347.0425, -50.1225>, <-28.1666, 349.5603, -49.6759>, <-28.2312, 348.5753, -49.7333> }
					triangle { <-28.1666, 349.5603, -49.6759>, <-27.6704, 349.4394, -49.4092>, <-28.2312, 348.5753, -49.7333> }
					triangle { <-28.2312, 348.5753, -49.7333>, <-27.6704, 349.4394, -49.4092>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-28.1666, 349.5603, -49.6759>, <-27.6969, 350.4475, -54.2516>, <-26.1265, 351.066, -55.3792> }
					triangle { <-26.1265, 351.066, -55.3792>, <-24.06049, 350.5643, -55.3467>, <-24.495, 350.2667, -54.6731> }
					triangle { <-24.495, 350.2667, -54.6731>, <-28.1666, 349.5603, -49.6759>, <-26.1265, 351.066, -55.3792> }
					triangle { <-28.1666, 349.5603, -49.6759>, <-24.495, 350.2667, -54.6731>, <-27.6704, 349.4394, -49.4092> }
					triangle { <-27.7648, 348.3663, -49.4848>, <-28.1842, 346.729, -49.7498>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-27.7648, 348.3663, -49.4848>, <-27.2338, 349.1424, -49.1789>, <-28.1842, 346.729, -49.7498> }
					triangle { <-27.7648, 348.3663, -49.4848>, <-27.6704, 349.4394, -49.4092>, <-27.2338, 349.1424, -49.1789> }
					triangle { <-28.7573, 346.2253, -50.07245>, <-27.6704, 349.4394, -49.4092>, <-27.7648, 348.3663, -49.4848> }
					triangle { <-22.9395, 349.6378, -53.6811>, <-23.6548, 348.6362, -52.09801>, <-27.2338, 349.1424, -49.1789> }
					triangle { <-24.495, 350.2667, -54.6731>, <-24.06049, 350.5643, -55.3467>, <-22.9395, 349.6378, -53.6811> }
					triangle { <-22.9395, 349.6378, -53.6811>, <-27.2338, 349.1424, -49.1789>, <-24.495, 350.2667, -54.6731> }
					triangle { <-27.6704, 349.4394, -49.4092>, <-24.495, 350.2667, -54.6731>, <-27.2338, 349.1424, -49.1789> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.7573, 346.2253, -50.07245>, <-28.8368, 346.9268, -49.639>, <-28.1998, 348.4982, -49.411> }
					triangle { <-28.8368, 346.9268, -49.639>, <-28.1039, 349.4061, -49.03129>, <-28.1998, 348.4982, -49.411> }
					triangle { <-28.1039, 349.4061, -49.03129>, <-27.6704, 349.4394, -49.4092>, <-28.1998, 348.4982, -49.411> }
					triangle { <-28.1998, 348.4982, -49.411>, <-27.6704, 349.4394, -49.4092>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-28.1039, 349.4061, -49.03129>, <-32.1371, 351.1964, -50.6039>, <-32.5686, 352.557, -52.04703> }
					triangle { <-32.5686, 352.557, -52.04703>, <-31.7596, 352.8871, -53.9855>, <-31.3084, 352.3322, -53.5169> }
					triangle { <-31.3084, 352.3322, -53.5169>, <-28.1039, 349.4061, -49.03129>, <-32.5686, 352.557, -52.04703> }
					triangle { <-28.1039, 349.4061, -49.03129>, <-31.3084, 352.3322, -53.5169>, <-27.6704, 349.4394, -49.4092> }
					triangle { <-27.7961, 348.4434, -49.8072>, <-28.2312, 346.8447, -50.2333>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-27.7961, 348.4434, -49.8072>, <-27.2964, 349.2966, -49.8236>, <-28.2312, 346.8447, -50.2333> }
					triangle { <-27.7961, 348.4434, -49.8072>, <-27.6704, 349.4394, -49.4092>, <-27.2964, 349.2966, -49.8236> }
					triangle { <-28.7573, 346.2253, -50.07245>, <-27.6704, 349.4394, -49.4092>, <-27.7961, 348.4434, -49.8072> }
					triangle { <-29.8097, 352.1826, -54.7541>, <-28.638, 350.7216, -54.03734>, <-27.2964, 349.2966, -49.8236> }
					triangle { <-31.3084, 352.3322, -53.5169>, <-31.7596, 352.8871, -53.9855>, <-29.8097, 352.1826, -54.7541> }
					triangle { <-29.8097, 352.1826, -54.7541>, <-27.2964, 349.2966, -49.8236>, <-31.3084, 352.3322, -53.5169> }
					triangle { <-27.6704, 349.4394, -49.4092>, <-31.3084, 352.3322, -53.5169>, <-27.2964, 349.2966, -49.8236> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.7573, 346.2253, -50.07245>, <-28.3741, 346.7548, -49.5634>, <-27.8914, 348.3835, -49.3606> }
					triangle { <-28.3741, 346.7548, -49.5634>, <-27.4871, 349.1767, -48.9304>, <-27.8914, 348.3835, -49.3606> }
					triangle { <-27.4871, 349.1767, -48.9304>, <-27.6704, 349.4394, -49.4092>, <-27.8914, 348.3835, -49.3606> }
					triangle { <-27.8914, 348.3835, -49.3606>, <-27.6704, 349.4394, -49.4092>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-27.4871, 349.1767, -48.9304>, <-30.4462, 349.5336, -45.3163>, <-31.9193, 350.8565, -44.8697> }
					triangle { <-31.9193, 350.8565, -44.8697>, <-33.3961, 351.807, -46.06848>, <-32.8011, 351.3939, -46.5228> }
					triangle { <-32.8011, 351.3939, -46.5228>, <-27.4871, 349.1767, -48.9304>, <-31.9193, 350.8565, -44.8697> }
					triangle { <-27.4871, 349.1767, -48.9304>, <-32.8011, 351.3939, -46.5228>, <-27.6704, 349.4394, -49.4092> }
					triangle { <-28.1045, 348.5581, -49.8576>, <-28.6938, 347.0167, -50.3089>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-28.1045, 348.5581, -49.8576>, <-27.9133, 349.526, -49.9244>, <-28.6938, 347.0167, -50.3089> }
					triangle { <-28.1045, 348.5581, -49.8576>, <-27.6704, 349.4394, -49.4092>, <-27.9133, 349.526, -49.9244> }
					triangle { <-28.7573, 346.2253, -50.07245>, <-27.6704, 349.4394, -49.4092>, <-28.1045, 348.5581, -49.8576> }
					triangle { <-33.3755, 352.0498, -48.2661>, <-32.293, 351.047, -49.624>, <-27.9133, 349.526, -49.9244> }
					triangle { <-32.8011, 351.3939, -46.5228>, <-33.3961, 351.807, -46.06848>, <-33.3755, 352.0498, -48.2661> }
					triangle { <-33.3755, 352.0498, -48.2661>, <-27.9133, 349.526, -49.9244>, <-32.8011, 351.3939, -46.5228> }
					triangle { <-27.6704, 349.4394, -49.4092>, <-32.8011, 351.3939, -46.5228>, <-27.9133, 349.526, -49.9244> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.7573, 346.2253, -50.07245>, <-28.1319, 346.7649, -50.00957>, <-27.7299, 348.3902, -49.658> }
					triangle { <-28.1319, 346.7649, -50.00957>, <-27.1641, 349.1902, -49.5253>, <-27.7299, 348.3902, -49.658> }
					triangle { <-27.1641, 349.1902, -49.5253>, <-27.6704, 349.4394, -49.4092>, <-27.7299, 348.3902, -49.658> }
					triangle { <-27.7299, 348.3902, -49.658>, <-27.6704, 349.4394, -49.4092>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-27.1641, 349.1902, -49.5253>, <-24.8521, 347.7258, -45.7233>, <-24.935, 348.2675, -43.7689> }
					triangle { <-24.935, 348.2675, -43.7689>, <-26.5624, 348.7579, -42.4913>, <-26.7815, 348.6965, -43.3155> }
					triangle { <-26.7815, 348.6965, -43.3155>, <-27.1641, 349.1902, -49.5253>, <-24.935, 348.2675, -43.7689> }
					triangle { <-27.1641, 349.1902, -49.5253>, <-26.7815, 348.6965, -43.3155>, <-27.6704, 349.4394, -49.4092> }
					triangle { <-28.266, 348.5513, -49.5602>, <-28.9361, 347.0066, -49.8628>, <-28.7573, 346.2253, -50.07245> }
					triangle { <-28.266, 348.5513, -49.5602>, <-28.2363, 349.5125, -49.3296>, <-28.9361, 347.0066, -49.8628> }
					triangle { <-28.266, 348.5513, -49.5602>, <-27.6704, 349.4394, -49.4092>, <-28.2363, 349.5125, -49.3296> }
					triangle { <-28.7573, 346.2253, -50.07245>, <-27.6704, 349.4394, -49.4092>, <-28.266, 348.5513, -49.5602> }
					triangle { <-28.5985, 349.3684, -43.1003>, <-29.4984, 349.1221, -44.8753>, <-28.2363, 349.5125, -49.3296> }
					triangle { <-26.7815, 348.6965, -43.3155>, <-26.5624, 348.7579, -42.4913>, <-28.5985, 349.3684, -43.1003> }
					triangle { <-28.5985, 349.3684, -43.1003>, <-28.2363, 349.5125, -49.3296>, <-26.7815, 348.6965, -43.3155> }
					triangle { <-27.6704, 349.4394, -49.4092>, <-26.7815, 348.6965, -43.3155>, <-28.2363, 349.5125, -49.3296> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-31.1608, 328.51, -60.2671>, <-31.9394, 329.791, -58.4518>, 0.2999 }
			cylinder { <-31.9394, 329.791, -58.4518>, <-32.7688, 331.011, -56.6171>, 0.2999 }
			cylinder { <-32.7688, 331.011, -56.6171>, <-33.6481, 332.1686, -54.7652>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.6481, 332.1686, -54.7652>, <-38.06853, 334.9534, -50.0126>, 0.2999 }
				cylinder { <-38.06853, 334.9534, -50.0126>, <-43.8909, 336.8105, -46.4722>, 0.2999 }
				cylinder { <-43.8909, 336.8105, -46.4722>, <-50.6138, 337.5799, -44.4491>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-50.6138, 337.5799, -44.4491>, <-51.3898, 337.2901, -44.4376>, <-52.9793, 337.5982, -43.8853> }
					triangle { <-51.3898, 337.2901, -44.4376>, <-53.9474, 337.4566, -43.7419>, <-52.9793, 337.5982, -43.8853> }
					triangle { <-53.9474, 337.4566, -43.7419>, <-53.9045, 337.9565, -43.4588>, <-52.9793, 337.5982, -43.8853> }
					triangle { <-52.9793, 337.5982, -43.8853>, <-53.9045, 337.9565, -43.4588>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-53.9474, 337.4566, -43.7419>, <-55.335, 337.9072, -48.1935>, <-56.3598, 339.3585, -49.1751> }
					triangle { <-56.3598, 339.3585, -49.1751>, <-56.2838, 341.4808, -49.06861>, <-55.8431, 341.0915, -48.4478> }
					triangle { <-55.8431, 341.0915, -48.4478>, <-53.9474, 337.4566, -43.7419>, <-56.3598, 339.3585, -49.1751> }
					triangle { <-53.9474, 337.4566, -43.7419>, <-55.8431, 341.0915, -48.4478>, <-53.9045, 337.9565, -43.4588> }
					triangle { <-52.8463, 338.0878, -43.6293>, <-51.1902, 338.0245, -44.05371>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-52.8463, 338.0878, -43.6293>, <-53.6813, 338.4358, -43.23>, <-51.1902, 338.0245, -44.05371> }
					triangle { <-52.8463, 338.0878, -43.6293>, <-53.9045, 337.9565, -43.4588>, <-53.6813, 338.4358, -43.23> }
					triangle { <-50.6138, 337.5799, -44.4491>, <-53.9045, 337.9565, -43.4588>, <-52.8463, 338.0878, -43.6293> }
					triangle { <-55.4505, 342.7042, -47.426>, <-54.1818, 342.1506, -45.9752>, <-53.6813, 338.4358, -43.23> }
					triangle { <-55.8431, 341.0915, -48.4478>, <-56.2838, 341.4808, -49.06861>, <-55.4505, 342.7042, -47.426> }
					triangle { <-55.4505, 342.7042, -47.426>, <-53.6813, 338.4358, -43.23>, <-55.8431, 341.0915, -48.4478> }
					triangle { <-53.9045, 337.9565, -43.4588>, <-55.8431, 341.0915, -48.4478>, <-53.6813, 338.4358, -43.23> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-50.6138, 337.5799, -44.4491>, <-51.2413, 337.3414, -43.9636>, <-52.8803, 337.6324, -43.5693> }
					triangle { <-51.2413, 337.3414, -43.9636>, <-53.7494, 337.5251, -43.11>, <-52.8803, 337.6324, -43.5693> }
					triangle { <-53.7494, 337.5251, -43.11>, <-53.9045, 337.9565, -43.4588>, <-52.8803, 337.6324, -43.5693> }
					triangle { <-52.8803, 337.6324, -43.5693>, <-53.9045, 337.9565, -43.4588>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-53.7494, 337.5251, -43.11>, <-54.8296, 333.2726, -44.7515>, <-56.2042, 332.6256, -46.09752> }
					triangle { <-56.2042, 332.6256, -46.09752>, <-56.8704, 333.4225, -47.9529>, <-56.3764, 333.96, -47.5078> }
					triangle { <-56.3764, 333.96, -47.5078>, <-53.7494, 337.5251, -43.11>, <-56.2042, 332.6256, -46.09752> }
					triangle { <-53.7494, 337.5251, -43.11>, <-56.3764, 333.96, -47.5078>, <-53.9045, 337.9565, -43.4588> }
					triangle { <-52.9453, 338.0536, -43.9453>, <-51.3387, 337.9731, -44.5276>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-52.9453, 338.0536, -43.9453>, <-53.8793, 338.3673, -43.862>, <-51.3387, 337.9731, -44.5276> }
					triangle { <-52.9453, 338.0536, -43.9453>, <-53.9045, 337.9565, -43.4588>, <-53.8793, 338.3673, -43.862> }
					triangle { <-50.6138, 337.5799, -44.4491>, <-53.9045, 337.9565, -43.4588>, <-52.9453, 338.0536, -43.9453> }
					triangle { <-56.6481, 335.5033, -48.6669>, <-55.3925, 336.9223, -48.01031>, <-53.8793, 338.3673, -43.862> }
					triangle { <-56.3764, 333.96, -47.5078>, <-56.8704, 333.4225, -47.9529>, <-56.6481, 335.5033, -48.6669> }
					triangle { <-56.6481, 335.5033, -48.6669>, <-53.8793, 338.3673, -43.862>, <-56.3764, 333.96, -47.5078> }
					triangle { <-53.9045, 337.9565, -43.4588>, <-56.3764, 333.96, -47.5078>, <-53.8793, 338.3673, -43.862> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-50.6138, 337.5799, -44.4491>, <-51.1596, 337.8264, -43.8767>, <-52.8259, 337.9557, -43.5113> }
					triangle { <-51.1596, 337.8264, -43.8767>, <-53.6406, 338.1716, -42.9941>, <-52.8259, 337.9557, -43.5113> }
					triangle { <-53.6406, 338.1716, -42.9941>, <-53.9045, 337.9565, -43.4588>, <-52.8259, 337.9557, -43.5113> }
					triangle { <-52.8259, 337.9557, -43.5113>, <-53.9045, 337.9565, -43.4588>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-53.6406, 338.1716, -42.9941>, <-53.05449, 335.0673, -39.5351>, <-54.00584, 333.3377, -39.06284> }
					triangle { <-54.00584, 333.3377, -39.06284>, <-54.7472, 331.7436, -40.2589>, <-54.5068, 332.4276, -40.7121> }
					triangle { <-54.5068, 332.4276, -40.7121>, <-53.6406, 338.1716, -42.9941>, <-54.00584, 333.3377, -39.06284> }
					triangle { <-53.6406, 338.1716, -42.9941>, <-54.5068, 332.4276, -40.7121>, <-53.9045, 337.9565, -43.4588> }
					triangle { <-52.9997, 337.7303, -44.00325>, <-51.4203, 337.4882, -44.6145>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-52.9997, 337.7303, -44.00325>, <-53.9882, 337.7208, -43.9778>, <-51.4203, 337.4882, -44.6145> }
					triangle { <-52.9997, 337.7303, -44.00325>, <-53.9045, 337.9565, -43.4588>, <-53.9882, 337.7208, -43.9778> }
					triangle { <-50.6138, 337.5799, -44.4491>, <-53.9045, 337.9565, -43.4588>, <-52.9997, 337.7303, -44.00325> }
					triangle { <-55.1935, 331.7973, -42.4238>, <-54.5608, 333.1136, -43.7979>, <-53.9882, 337.7208, -43.9778> }
					triangle { <-54.5068, 332.4276, -40.7121>, <-54.7472, 331.7436, -40.2589>, <-55.1935, 331.7973, -42.4238> }
					triangle { <-55.1935, 331.7973, -42.4238>, <-53.9882, 337.7208, -43.9778>, <-54.5068, 332.4276, -40.7121> }
					triangle { <-53.9045, 337.9565, -43.4588>, <-54.5068, 332.4276, -40.7121>, <-53.9882, 337.7208, -43.9778> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-50.6138, 337.5799, -44.4491>, <-51.2569, 338.0792, -44.2962>, <-52.8908, 338.1243, -43.791> }
					triangle { <-51.2569, 338.0792, -44.2962>, <-53.7703, 338.5088, -43.5534>, <-52.8908, 338.1243, -43.791> }
					triangle { <-53.7703, 338.5088, -43.5534>, <-53.9045, 337.9565, -43.4588>, <-52.8908, 338.1243, -43.791> }
					triangle { <-52.8908, 338.1243, -43.791>, <-53.9045, 337.9565, -43.4588>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-53.7703, 338.5088, -43.5534>, <-52.4461, 340.8279, -39.7046>, <-52.7821, 340.5172, -37.7271> }
					triangle { <-52.7821, 340.5172, -37.7271>, <-52.8286, 338.7486, -36.5476>, <-52.8005, 338.5977, -37.3888> }
					triangle { <-52.8005, 338.5977, -37.3888>, <-53.7703, 338.5088, -43.5534>, <-52.7821, 340.5172, -37.7271> }
					triangle { <-53.7703, 338.5088, -43.5534>, <-52.8005, 338.5977, -37.3888>, <-53.9045, 337.9565, -43.4588> }
					triangle { <-52.9348, 337.5617, -43.7236>, <-51.323, 337.2354, -44.1951>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-52.9348, 337.5617, -43.7236>, <-53.8585, 337.3837, -43.4185>, <-51.323, 337.2354, -44.1951> }
					triangle { <-52.9348, 337.5617, -43.7236>, <-53.9045, 337.9565, -43.4588>, <-53.8585, 337.3837, -43.4185> }
					triangle { <-50.6138, 337.5799, -44.4491>, <-53.9045, 337.9565, -43.4588>, <-52.9348, 337.5617, -43.7236> }
					triangle { <-53.08347, 336.6731, -37.2663>, <-52.8283, 335.9525, -39.1201>, <-53.8585, 337.3837, -43.4185> }
					triangle { <-52.8005, 338.5977, -37.3888>, <-52.8286, 338.7486, -36.5476>, <-53.08347, 336.6731, -37.2663> }
					triangle { <-53.08347, 336.6731, -37.2663>, <-53.8585, 337.3837, -43.4185>, <-52.8005, 338.5977, -37.3888> }
					triangle { <-53.9045, 337.9565, -43.4588>, <-52.8005, 338.5977, -37.3888>, <-53.8585, 337.3837, -43.4185> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-50.6138, 337.5799, -44.4491>, <-51.4013, 337.7427, -44.6481>, <-52.987, 337.9, -44.02562> }
					triangle { <-51.4013, 337.7427, -44.6481>, <-53.9628, 338.0602, -44.02261>, <-52.987, 337.9, -44.02562> }
					triangle { <-53.9628, 338.0602, -44.02261>, <-53.9045, 337.9565, -43.4588>, <-52.987, 337.9, -44.02562> }
					triangle { <-52.987, 337.9, -44.02562>, <-53.9045, 337.9565, -43.4588>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-53.9628, 338.0602, -44.02261>, <-53.8769, 342.6095, -45.1366>, <-54.259, 344.2944, -44.07125> }
					triangle { <-54.259, 344.2944, -44.07125>, <-53.7927, 344.8574, -42.07452>, <-53.6389, 344.0331, -42.2419> }
					triangle { <-53.6389, 344.0331, -42.2419>, <-53.9628, 338.0602, -44.02261>, <-54.259, 344.2944, -44.07125> }
					triangle { <-53.9628, 338.0602, -44.02261>, <-53.6389, 344.0331, -42.2419>, <-53.9045, 337.9565, -43.4588> }
					triangle { <-52.8386, 337.786, -43.489>, <-51.1787, 337.5718, -43.8432>, <-50.6138, 337.5799, -44.4491> }
					triangle { <-52.8386, 337.786, -43.489>, <-53.6659, 337.8322, -42.9494>, <-51.1787, 337.5718, -43.8432> }
					triangle { <-52.8386, 337.786, -43.489>, <-53.9045, 337.9565, -43.4588>, <-53.6659, 337.8322, -42.9494> }
					triangle { <-50.6138, 337.5799, -44.4491>, <-53.9045, 337.9565, -43.4588>, <-52.8386, 337.786, -43.489> }
					triangle { <-53.2447, 343.5157, -40.4045>, <-52.5904, 341.6219, -40.4861>, <-53.6659, 337.8322, -42.9494> }
					triangle { <-53.6389, 344.0331, -42.2419>, <-53.7927, 344.8574, -42.07452>, <-53.2447, 343.5157, -40.4045> }
					triangle { <-53.2447, 343.5157, -40.4045>, <-53.6659, 337.8322, -42.9494>, <-53.6389, 344.0331, -42.2419> }
					triangle { <-53.9045, 337.9565, -43.4588>, <-53.6389, 344.0331, -42.2419>, <-53.6659, 337.8322, -42.9494> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-33.6481, 332.1686, -54.7652>, <-34.4516, 333.3502, -52.8942>, 0.2999 }
			cylinder { <-34.4516, 333.3502, -52.8942>, <-35.1785, 334.5544, -51.00636>, 0.2999 }
			cylinder { <-35.1785, 334.5544, -51.00636>, <-35.8278, 335.7798, -49.1038>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-35.8278, 335.7798, -49.1038>, <-36.1406, 338.4754, -42.5832>, 0.2999 }
				cylinder { <-36.1406, 338.4754, -42.5832>, <-34.7913, 339.9585, -35.811>, 0.2999 }
				cylinder { <-34.7913, 339.9585, -35.811>, <-31.8963, 340.1013, -29.3704>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-31.8963, 340.1013, -29.3704>, <-31.2894, 339.9802, -28.8197>, <-30.8841, 340.0609, -27.1595> }
					triangle { <-31.2894, 339.9802, -28.8197>, <-30.3314, 339.99, -26.3427>, <-30.8841, 340.0609, -27.1595> }
					triangle { <-30.3314, 339.99, -26.3427>, <-30.8145, 340.1731, -26.08779>, <-30.8841, 340.0609, -27.1595> }
					triangle { <-30.8841, 340.0609, -27.1595>, <-30.8145, 340.1731, -26.08779>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-30.3314, 339.99, -26.3427>, <-29.8143, 335.3341, -26.3115>, <-30.5802, 333.8726, -25.1295> }
					triangle { <-30.5802, 333.8726, -25.1295>, <-32.511, 333.5829, -24.2874>, <-32.4038, 334.355, -24.6388> }
					triangle { <-32.4038, 334.355, -24.6388>, <-30.3314, 339.99, -26.3427>, <-30.5802, 333.8726, -25.1295> }
					triangle { <-30.3314, 339.99, -26.3427>, <-32.4038, 334.355, -24.6388>, <-30.8145, 340.1731, -26.08779> }
					triangle { <-31.3969, 340.242, -26.9945>, <-32.05858, 340.2519, -28.5721>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-31.3969, 340.242, -26.9945>, <-31.3569, 340.3523, -26.01271>, <-32.05858, 340.2519, -28.5721> }
					triangle { <-31.3969, 340.242, -26.9945>, <-30.8145, 340.1731, -26.08779>, <-31.3569, 340.3523, -26.01271> }
					triangle { <-31.8963, 340.1013, -29.3704>, <-30.8145, 340.1731, -26.08779>, <-31.3969, 340.242, -26.9945> }
					triangle { <-34.08394, 335.1105, -24.00196>, <-34.2581, 336.9042, -24.8814>, <-31.3569, 340.3523, -26.01271> }
					triangle { <-32.4038, 334.355, -24.6388>, <-32.511, 333.5829, -24.2874>, <-34.08394, 335.1105, -24.00196> }
					triangle { <-34.08394, 335.1105, -24.00196>, <-31.3569, 340.3523, -26.01271>, <-32.4038, 334.355, -24.6388> }
					triangle { <-30.8145, 340.1731, -26.08779>, <-32.4038, 334.355, -24.6388>, <-31.3569, 340.3523, -26.01271> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-31.8963, 340.1013, -29.3704>, <-31.4333, 340.4569, -28.7827>, <-30.98, 340.3787, -27.1349> }
					triangle { <-31.4333, 340.4569, -28.7827>, <-30.5232, 340.6256, -26.2934>, <-30.98, 340.3787, -27.1349> }
					triangle { <-30.5232, 340.6256, -26.2934>, <-30.8145, 340.1731, -26.08779>, <-30.98, 340.3787, -27.1349> }
					triangle { <-30.98, 340.3787, -27.1349>, <-30.8145, 340.1731, -26.08779>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-30.5232, 340.6256, -26.2934>, <-26.1422, 339.6234, -27.6154>, <-24.8583, 338.1354, -27.1083> }
					triangle { <-24.8583, 338.1354, -27.1083>, <-25.1455, 336.0561, -26.7687>, <-25.876, 336.4953, -26.8368> }
					triangle { <-25.876, 336.4953, -26.8368>, <-30.5232, 340.6256, -26.2934>, <-24.8583, 338.1354, -27.1083> }
					triangle { <-30.5232, 340.6256, -26.2934>, <-25.876, 336.4953, -26.8368>, <-30.8145, 340.1731, -26.08779> }
					triangle { <-31.301, 339.9242, -27.01924>, <-31.9147, 339.7752, -28.6091>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-31.301, 339.9242, -27.01924>, <-31.165, 339.7166, -26.06203>, <-31.9147, 339.7752, -28.6091> }
					triangle { <-31.301, 339.9242, -27.01924>, <-30.8145, 340.1731, -26.08779>, <-31.165, 339.7166, -26.06203> }
					triangle { <-31.8963, 340.1013, -29.3704>, <-30.8145, 340.1731, -26.08779>, <-31.301, 339.9242, -27.01924> }
					triangle { <-27.05135, 335.0297, -26.3177>, <-28.9236, 335.6844, -26.6127>, <-31.165, 339.7166, -26.06203> }
					triangle { <-25.876, 336.4953, -26.8368>, <-25.1455, 336.0561, -26.7687>, <-27.05135, 335.0297, -26.3177> }
					triangle { <-27.05135, 335.0297, -26.3177>, <-31.165, 339.7166, -26.06203>, <-25.876, 336.4953, -26.8368> }
					triangle { <-30.8145, 340.1731, -26.08779>, <-25.876, 336.4953, -26.8368>, <-31.165, 339.7166, -26.06203> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-31.8963, 340.1013, -29.3704>, <-31.9075, 340.4658, -28.6266>, <-31.2962, 340.3846, -27.03087> }
					triangle { <-31.9075, 340.4658, -28.6266>, <-31.1555, 340.6374, -26.08529>, <-31.2962, 340.3846, -27.03087> }
					triangle { <-31.1555, 340.6374, -26.08529>, <-30.8145, 340.1731, -26.08779>, <-31.2962, 340.3846, -27.03087> }
					triangle { <-31.2962, 340.3846, -27.03087>, <-30.8145, 340.1731, -26.08779>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-31.1555, 340.6374, -26.08529>, <-28.8834, 344.6672, -26.8224>, <-26.946, 345.2195, -26.5752> }
					triangle { <-26.946, 345.2195, -26.5752>, <-25.1139, 344.2101, -26.9574>, <-25.8014, 343.7055, -27.01907> }
					triangle { <-25.8014, 343.7055, -27.01907>, <-31.1555, 340.6374, -26.08529>, <-26.946, 345.2195, -26.5752> }
					triangle { <-31.1555, 340.6374, -26.08529>, <-25.8014, 343.7055, -27.01907>, <-30.8145, 340.1731, -26.08779> }
					triangle { <-30.9848, 339.9183, -27.1233>, <-31.4404, 339.7664, -28.7652>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-30.9848, 339.9183, -27.1233>, <-30.5327, 339.7048, -26.2701>, <-31.4404, 339.7664, -28.7652> }
					triangle { <-30.9848, 339.9183, -27.1233>, <-30.8145, 340.1731, -26.08779>, <-30.5327, 339.7048, -26.2701> }
					triangle { <-31.8963, 340.1013, -29.3704>, <-30.8145, 340.1731, -26.08779>, <-30.9848, 339.9183, -27.1233> }
					triangle { <-24.818, 342.0331, -27.2068>, <-26.1846, 340.6259, -27.6234>, <-30.5327, 339.7048, -26.2701> }
					triangle { <-25.8014, 343.7055, -27.01907>, <-25.1139, 344.2101, -26.9574>, <-24.818, 342.0331, -27.2068> }
					triangle { <-24.818, 342.0331, -27.2068>, <-30.5327, 339.7048, -26.2701>, <-25.8014, 343.7055, -27.01907> }
					triangle { <-30.8145, 340.1731, -26.08779>, <-25.8014, 343.7055, -27.01907>, <-30.5327, 339.7048, -26.2701> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-31.8963, 340.1013, -29.3704>, <-32.06124, 339.9946, -28.5656>, <-31.3986, 340.0705, -26.9902> }
					triangle { <-32.06124, 339.9946, -28.5656>, <-31.3604, 340.0092, -26.00404>, <-31.3986, 340.0705, -26.9902> }
					triangle { <-31.3604, 340.0092, -26.00404>, <-30.8145, 340.1731, -26.08779>, <-31.3986, 340.0705, -26.9902> }
					triangle { <-31.3986, 340.0705, -26.9902>, <-30.8145, 340.1731, -26.08779>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-31.3604, 340.0092, -26.00404>, <-34.2752, 343.5422, -25.02097>, <-33.9775, 345.401, -24.262> }
					triangle { <-33.9775, 345.401, -24.262>, <-32.4596, 346.8524, -24.5944>, <-32.2825, 346.0886, -24.9353> }
					triangle { <-32.2825, 346.0886, -24.9353>, <-31.3604, 340.0092, -26.00404>, <-33.9775, 345.401, -24.262> }
					triangle { <-31.3604, 340.0092, -26.00404>, <-32.2825, 346.0886, -24.9353>, <-30.8145, 340.1731, -26.08779> }
					triangle { <-30.8824, 340.2325, -27.1639>, <-31.2868, 340.2375, -28.8262>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-30.8824, 340.2325, -27.1639>, <-30.3278, 340.3331, -26.3514>, <-31.2868, 340.2375, -28.8262> }
					triangle { <-30.8824, 340.2325, -27.1639>, <-30.8145, 340.1731, -26.08779>, <-30.3278, 340.3331, -26.3514> }
					triangle { <-31.8963, 340.1013, -29.3704>, <-30.8145, 340.1731, -26.08779>, <-30.8824, 340.2325, -27.1639> }
					triangle { <-30.4496, 346.5078, -25.4488>, <-29.8008, 344.9459, -26.5262>, <-30.3278, 340.3331, -26.3514> }
					triangle { <-32.2825, 346.0886, -24.9353>, <-32.4596, 346.8524, -24.5944>, <-30.4496, 346.5078, -25.4488> }
					triangle { <-30.4496, 346.5078, -25.4488>, <-30.3278, 340.3331, -26.3514>, <-32.2825, 346.0886, -24.9353> }
					triangle { <-30.8145, 340.1731, -26.08779>, <-32.2825, 346.0886, -24.9353>, <-30.3278, 340.3331, -26.3514> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-31.8963, 340.1013, -29.3704>, <-31.6734, 339.6899, -28.6868>, <-31.1401, 339.8674, -27.071> }
					triangle { <-31.6734, 339.6899, -28.6868>, <-30.8434, 339.603, -26.1655>, <-31.1401, 339.8674, -27.071> }
					triangle { <-30.8434, 339.603, -26.1655>, <-30.8145, 340.1731, -26.08779>, <-31.1401, 339.8674, -27.071> }
					triangle { <-31.1401, 339.8674, -27.071>, <-30.8145, 340.1731, -26.08779>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-30.8434, 339.603, -26.1655>, <-34.8593, 337.687, -24.7004>, <-36.2575, 338.2823, -23.355> }
					triangle { <-36.2575, 338.2823, -23.355>, <-37.1003, 340.1853, -22.9193>, <-36.4246, 340.2224, -23.4421> }
					triangle { <-36.4246, 340.2224, -23.4421>, <-30.8434, 339.603, -26.1655>, <-36.2575, 338.2823, -23.355> }
					triangle { <-30.8434, 339.603, -26.1655>, <-36.4246, 340.2224, -23.4421>, <-30.8145, 340.1731, -26.08779> }
					triangle { <-31.1409, 340.4355, -27.08317>, <-31.6745, 340.5422, -28.705>, <-31.8963, 340.1013, -29.3704> }
					triangle { <-31.1409, 340.4355, -27.08317>, <-30.8449, 340.7393, -26.1899>, <-31.6745, 340.5422, -28.705> }
					triangle { <-31.1409, 340.4355, -27.08317>, <-30.8145, 340.1731, -26.08779>, <-30.8449, 340.7393, -26.1899> }
					triangle { <-31.8963, 340.1013, -29.3704>, <-30.8145, 340.1731, -26.08779>, <-31.1409, 340.4355, -27.08317> }
					triangle { <-36.2626, 342.1648, -23.4382>, <-34.8658, 342.611, -24.806>, <-30.8449, 340.7393, -26.1899> }
					triangle { <-36.4246, 340.2224, -23.4421>, <-37.1003, 340.1853, -22.9193>, <-36.2626, 342.1648, -23.4382> }
					triangle { <-36.2626, 342.1648, -23.4382>, <-30.8449, 340.7393, -26.1899>, <-36.4246, 340.2224, -23.4421> }
					triangle { <-30.8145, 340.1731, -26.08779>, <-36.4246, 340.2224, -23.4421>, <-30.8449, 340.7393, -26.1899> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-35.8278, 335.7798, -49.1038>, <-36.5408, 337.0341, -47.2435>, 0.2999 }
			cylinder { <-36.5408, 337.0341, -47.2435>, <-37.3166, 338.3159, -45.4276>, 0.2999 }
			cylinder { <-37.3166, 338.3159, -45.4276>, <-38.1544, 339.6236, -43.6582>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-38.1544, 339.6236, -43.6582>, <-40.843, 344.9443, -39.8709>, 0.2999 }
				cylinder { <-40.843, 344.9443, -39.8709>, <-43.4756, 351.2042, -37.9302>, 0.2999 }
				cylinder { <-43.4756, 351.2042, -37.9302>, <-45.8253, 357.8643, -38.00358>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-45.8253, 357.8643, -38.00358>, <-46.1675, 358.4922, -38.4217>, <-46.6994, 360.1139, -38.3024> }
					triangle { <-46.1675, 358.4922, -38.4217>, <-47.08506, 360.9791, -38.5861>, <-46.6994, 360.1139, -38.3024> }
					triangle { <-47.08506, 360.9791, -38.5861>, <-46.9755, 361.1242, -38.03946>, <-46.6994, 360.1139, -38.3024> }
					triangle { <-46.6994, 360.1139, -38.3024>, <-46.9755, 361.1242, -38.03946>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-47.08506, 360.9791, -38.5861>, <-43.7209, 362.2333, -41.5952>, <-42.2693, 363.6502, -41.5238> }
					triangle { <-42.2693, 363.6502, -41.5238>, <-41.00046, 364.316, -39.9529>, <-41.6266, 363.7967, -39.6896> }
					triangle { <-41.6266, 363.7967, -39.6896>, <-47.08506, 360.9791, -38.5861>, <-42.2693, 363.6502, -41.5238> }
					triangle { <-47.08506, 360.9791, -38.5861>, <-41.6266, 363.7967, -39.6896>, <-46.9755, 361.1242, -38.03946> }
					triangle { <-46.5583, 360.1696, -37.7548>, <-45.9558, 358.576, -37.6002>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-46.5583, 360.1696, -37.7548>, <-46.8029, 361.0907, -37.4908>, <-45.9558, 358.576, -37.6002> }
					triangle { <-46.5583, 360.1696, -37.7548>, <-46.9755, 361.1242, -38.03946>, <-46.8029, 361.0907, -37.4908> }
					triangle { <-45.8253, 357.8643, -38.00358>, <-46.9755, 361.1242, -38.03946>, <-46.5583, 360.1696, -37.7548> }
					triangle { <-41.3053, 364.0315, -37.7815>, <-42.4983, 362.7169, -36.8488>, <-46.8029, 361.0907, -37.4908> }
					triangle { <-41.6266, 363.7967, -39.6896>, <-41.00046, 364.316, -39.9529>, <-41.3053, 364.0315, -37.7815> }
					triangle { <-41.3053, 364.0315, -37.7815>, <-46.8029, 361.0907, -37.4908>, <-41.6266, 363.7967, -39.6896> }
					triangle { <-46.9755, 361.1242, -38.03946>, <-41.6266, 363.7967, -39.6896>, <-46.8029, 361.0907, -37.4908> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-45.8253, 357.8643, -38.00358>, <-46.463, 358.3923, -38.03184>, <-46.8964, 360.0472, -38.04257> }
					triangle { <-46.463, 358.3923, -38.03184>, <-47.4791, 360.8458, -38.06632>, <-46.8964, 360.0472, -38.04257> }
					triangle { <-47.4791, 360.8458, -38.06632>, <-46.9755, 361.1242, -38.03946>, <-46.8964, 360.0472, -38.04257> }
					triangle { <-46.8964, 360.0472, -38.04257>, <-46.9755, 361.1242, -38.03946>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-47.4791, 360.8458, -38.06632>, <-49.1275, 360.3168, -42.4192>, <-48.7889, 361.3212, -44.1502> }
					triangle { <-48.7889, 361.3212, -44.1502>, <-47.021, 362.1364, -45.00536>, <-46.9218, 361.8789, -44.196> }
					triangle { <-46.9218, 361.8789, -44.196>, <-47.4791, 360.8458, -38.06632>, <-48.7889, 361.3212, -44.1502> }
					triangle { <-47.4791, 360.8458, -38.06632>, <-46.9218, 361.8789, -44.196>, <-46.9755, 361.1242, -38.03946> }
					triangle { <-46.3612, 360.2363, -38.01472>, <-45.6603, 358.676, -37.99>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-46.3612, 360.2363, -38.01472>, <-46.4088, 361.224, -38.01062>, <-45.6603, 358.676, -37.99> }
					triangle { <-46.3612, 360.2363, -38.01472>, <-46.9755, 361.1242, -38.03946>, <-46.4088, 361.224, -38.01062> }
					triangle { <-45.8253, 357.8643, -38.00358>, <-46.9755, 361.1242, -38.03946>, <-46.3612, 360.2363, -38.01472> }
					triangle { <-45.1319, 362.6135, -43.9599>, <-44.4893, 361.9558, -42.1779>, <-46.4088, 361.224, -38.01062> }
					triangle { <-46.9218, 361.8789, -44.196>, <-47.021, 362.1364, -45.00536>, <-45.1319, 362.6135, -43.9599> }
					triangle { <-45.1319, 362.6135, -43.9599>, <-46.4088, 361.224, -38.01062>, <-46.9218, 361.8789, -44.196> }
					triangle { <-46.9755, 361.1242, -38.03946>, <-46.9218, 361.8789, -44.196>, <-46.4088, 361.224, -38.01062> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-45.8253, 357.8643, -38.00358>, <-46.2076, 358.487, -37.6133>, <-46.7262, 360.1103, -37.7635> }
					triangle { <-46.2076, 358.487, -37.6133>, <-47.1386, 360.972, -37.5082>, <-46.7262, 360.1103, -37.7635> }
					triangle { <-47.1386, 360.972, -37.5082>, <-46.9755, 361.1242, -38.03946>, <-46.7262, 360.1103, -37.7635> }
					triangle { <-46.7262, 360.1103, -37.7635>, <-46.9755, 361.1242, -38.03946>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-47.1386, 360.972, -37.5082>, <-51.5801, 359.5086, -37.2313>, <-53.2085, 359.8251, -38.4008> }
					triangle { <-53.2085, 359.8251, -38.4008>, <-53.4548, 359.9159, -40.5109>, <-52.6367, 359.9059, -40.2625> }
					triangle { <-52.6367, 359.9059, -40.2625>, <-47.1386, 360.972, -37.5082>, <-53.2085, 359.8251, -38.4008> }
					triangle { <-47.1386, 360.972, -37.5082>, <-52.6367, 359.9059, -40.2625>, <-46.9755, 361.1242, -38.03946> }
					triangle { <-46.5315, 360.1732, -38.2937>, <-45.9156, 358.5812, -38.4086>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-46.5315, 360.1732, -38.2937>, <-46.7493, 361.0977, -38.5686>, <-45.9156, 358.5812, -38.4086> }
					triangle { <-46.5315, 360.1732, -38.2937>, <-46.9755, 361.1242, -38.03946>, <-46.7493, 361.0977, -38.5686> }
					triangle { <-45.8253, 357.8643, -38.00358>, <-46.9755, 361.1242, -38.03946>, <-46.5315, 360.1732, -38.2937> }
					triangle { <-51.8783, 360.2546, -42.02385>, <-49.8929, 360.0532, -41.8263>, <-46.7493, 361.0977, -38.5686> }
					triangle { <-52.6367, 359.9059, -40.2625>, <-53.4548, 359.9159, -40.5109>, <-51.8783, 360.2546, -42.02385> }
					triangle { <-51.8783, 360.2546, -42.02385>, <-46.7493, 361.0977, -38.5686>, <-52.6367, 359.9059, -40.2625> }
					triangle { <-46.9755, 361.1242, -38.03946>, <-52.6367, 359.9059, -40.2625>, <-46.7493, 361.0977, -38.5686> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-45.8253, 357.8643, -38.00358>, <-45.7519, 358.6464, -37.7406>, <-46.4223, 360.2166, -37.8484> }
					triangle { <-45.7519, 358.6464, -37.7406>, <-46.5309, 361.1846, -37.678>, <-46.4223, 360.2166, -37.8484> }
					triangle { <-46.5309, 361.1846, -37.678>, <-46.9755, 361.1242, -38.03946>, <-46.4223, 360.2166, -37.8484> }
					triangle { <-46.4223, 360.2166, -37.8484>, <-46.9755, 361.1242, -38.03946>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-46.5309, 361.1846, -37.678>, <-47.7122, 360.9181, -33.1527>, <-49.4617, 361.2156, -32.1675> }
					triangle { <-49.4617, 361.2156, -32.1675>, <-51.4706, 360.7026, -32.6389>, <-50.9268, 360.586, -33.2883> }
					triangle { <-50.9268, 360.586, -33.2883>, <-46.5309, 361.1846, -37.678>, <-49.4617, 361.2156, -32.1675> }
					triangle { <-46.5309, 361.1846, -37.678>, <-50.9268, 360.586, -33.2883>, <-46.9755, 361.1242, -38.03946> }
					triangle { <-46.8354, 360.0669, -38.2088>, <-46.3714, 358.4218, -38.2813>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-46.8354, 360.0669, -38.2088>, <-47.357, 360.8852, -38.3989>, <-46.3714, 358.4218, -38.2813> }
					triangle { <-46.8354, 360.0669, -38.2088>, <-46.9755, 361.1242, -38.03946>, <-47.357, 360.8852, -38.3989> }
					triangle { <-45.8253, 357.8643, -38.00358>, <-46.9755, 361.1242, -38.03946>, <-46.8354, 360.0669, -38.2088> }
					triangle { <-52.2842, 360.1927, -34.6307>, <-51.2919, 359.6207, -36.2767>, <-47.357, 360.8852, -38.3989> }
					triangle { <-50.9268, 360.586, -33.2883>, <-51.4706, 360.7026, -32.6389>, <-52.2842, 360.1927, -34.6307> }
					triangle { <-52.2842, 360.1927, -34.6307>, <-47.357, 360.8852, -38.3989>, <-50.9268, 360.586, -33.2883> }
					triangle { <-46.9755, 361.1242, -38.03946>, <-50.9268, 360.586, -33.2883>, <-47.357, 360.8852, -38.3989> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-45.8253, 357.8643, -38.00358>, <-45.7266, 358.6497, -38.2477>, <-46.4055, 360.2188, -38.1865> }
					triangle { <-45.7266, 358.6497, -38.2477>, <-46.4973, 361.189, -38.3542>, <-46.4055, 360.2188, -38.1865> }
					triangle { <-46.4973, 361.189, -38.3542>, <-46.9755, 361.1242, -38.03946>, <-46.4055, 360.2188, -38.1865> }
					triangle { <-46.4055, 360.2188, -38.1865>, <-46.9755, 361.1242, -38.03946>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-46.4973, 361.189, -38.3542>, <-42.7817, 362.6274, -35.8904>, <-42.5989, 363.6153, -34.1267> }
					triangle { <-42.5989, 363.6153, -34.1267>, <-43.6572, 363.463, -32.2888>, <-44.01946, 363.0269, -32.9289> }
					triangle { <-44.01946, 363.0269, -32.9289>, <-46.4973, 361.189, -38.3542>, <-42.5989, 363.6153, -34.1267> }
					triangle { <-46.4973, 361.189, -38.3542>, <-44.01946, 363.0269, -32.9289>, <-46.9755, 361.1242, -38.03946> }
					triangle { <-46.8522, 360.0647, -37.8707>, <-46.3966, 358.4185, -37.7741>, <-45.8253, 357.8643, -38.00358> }
					triangle { <-46.8522, 360.0647, -37.8707>, <-47.3906, 360.8808, -37.7227>, <-46.3966, 358.4185, -37.7741> }
					triangle { <-46.8522, 360.0647, -37.8707>, <-46.9755, 361.1242, -38.03946>, <-47.3906, 360.8808, -37.7227> }
					triangle { <-45.8253, 357.8643, -38.00358>, <-46.9755, 361.1242, -38.03946>, <-46.8522, 360.0647, -37.8707> }
					triangle { <-45.6511, 362.5622, -31.9692>, <-46.6528, 361.2918, -33.154>, <-47.3906, 360.8808, -37.7227> }
					triangle { <-44.01946, 363.0269, -32.9289>, <-43.6572, 363.463, -32.2888>, <-45.6511, 362.5622, -31.9692> }
					triangle { <-45.6511, 362.5622, -31.9692>, <-47.3906, 360.8808, -37.7227>, <-44.01946, 363.0269, -32.9289> }
					triangle { <-46.9755, 361.1242, -38.03946>, <-44.01946, 363.0269, -32.9289>, <-47.3906, 360.8808, -37.7227> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-38.1544, 339.6236, -43.6582>, <-38.9766, 340.8695, -41.8378>, 0.2999 }
			cylinder { <-38.9766, 340.8695, -41.8378>, <-39.7824, 342.0521, -39.9684>, 0.2999 }
			cylinder { <-39.7824, 342.0521, -39.9684>, <-40.5708, 343.17, -38.05232>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-40.5708, 343.17, -38.05232>, <-43.8459, 344.6892, -31.982>, 0.2999 }
				cylinder { <-43.8459, 344.6892, -31.982>, <-47.7487, 344.2435, -26.1123>, 0.2999 }
				cylinder { <-47.7487, 344.2435, -26.1123>, <-51.9431, 341.871, -20.9489>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-51.9431, 341.871, -20.9489>, <-52.2743, 341.2919, -20.5179>, <-53.3312, 340.973, -19.3047> }
					triangle { <-52.2743, 341.2919, -20.5179>, <-53.8367, 340.4621, -18.6864>, <-53.3312, 340.973, -19.3047> }
					triangle { <-53.8367, 340.4621, -18.6864>, <-54.02151, 340.9595, -18.5331>, <-53.3312, 340.973, -19.3047> }
					triangle { <-53.3312, 340.973, -19.3047>, <-54.02151, 340.9595, -18.5331>, <-51.9431, 341.871, -20.9489> }
					triangle { <-53.8367, 340.4621, -18.6864>, <-56.4924, 338.363, -21.6385>, <-58.3806, 338.5418, -22.07414> }
					triangle { <-58.3806, 338.5418, -22.07414>, <-59.5952, 340.1691, -22.2559>, <-58.8617, 340.3422, -21.9333> }
					triangle { <-58.8617, 340.3422, -21.9333>, <-53.8367, 340.4621, -18.6864>, <-58.3806, 338.5418, -22.07414> }
					triangle { <-53.8367, 340.4621, -18.6864>, <-58.8617, 340.3422, -21.9333>, <-54.02151, 340.9595, -18.5331> }
					triangle { <-53.459, 341.4955, -19.2176>, <-52.466, 342.0755, -20.3872>, <-51.9431, 341.871, -20.9489> }
					triangle { <-53.459, 341.4955, -19.2176>, <-54.09241, 341.507, -18.5121>, <-52.466, 342.0755, -20.3872> }
					triangle { <-53.459, 341.4955, -19.2176>, <-54.02151, 340.9595, -18.5331>, <-54.09241, 341.507, -18.5121> }
					triangle { <-51.9431, 341.871, -20.9489>, <-54.02151, 340.9595, -18.5331>, <-53.459, 341.4955, -19.2176> }
					triangle { <-59.2542, 342.1119, -21.4787>, <-57.6003, 342.8908, -20.8833>, <-54.09241, 341.507, -18.5121> }
					triangle { <-58.8617, 340.3422, -21.9333>, <-59.5952, 340.1691, -22.2559>, <-59.2542, 342.1119, -21.4787> }
					triangle { <-59.2542, 342.1119, -21.4787>, <-54.09241, 341.507, -18.5121>, <-58.8617, 340.3422, -21.9333> }
					triangle { <-54.02151, 340.9595, -18.5331>, <-58.8617, 340.3422, -21.9333>, <-54.09241, 341.507, -18.5121> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-51.9431, 341.871, -20.9489>, <-52.0519, 341.5883, -20.2147>, <-53.1829, 341.1706, -19.1026> }
					triangle { <-52.0519, 341.5883, -20.2147>, <-53.5401, 340.8572, -18.2822>, <-53.1829, 341.1706, -19.1026> }
					triangle { <-53.5401, 340.8572, -18.2822>, <-54.02151, 340.9595, -18.5331>, <-53.1829, 341.1706, -19.1026> }
					triangle { <-53.1829, 341.1706, -19.1026>, <-54.02151, 340.9595, -18.5331>, <-51.9431, 341.871, -20.9489> }
					triangle { <-53.5401, 340.8572, -18.2822>, <-52.1888, 336.5862, -18.6064>, <-53.1428, 334.9218, -18.9338> }
					triangle { <-53.1428, 334.9218, -18.9338>, <-54.6807, 334.4492, -20.1859>, <-54.5373, 335.2546, -20.1325> }
					triangle { <-54.5373, 335.2546, -20.1325>, <-53.5401, 340.8572, -18.2822>, <-53.1428, 334.9218, -18.9338> }
					triangle { <-53.5401, 340.8572, -18.2822>, <-54.5373, 335.2546, -20.1325>, <-54.02151, 340.9595, -18.5331> }
					triangle { <-53.6073, 341.2979, -19.4197>, <-52.6885, 341.7792, -20.6904>, <-51.9431, 341.871, -20.9489> }
					triangle { <-53.6073, 341.2979, -19.4197>, <-54.3889, 341.1118, -18.9164>, <-52.6885, 341.7792, -20.6904> }
					triangle { <-53.6073, 341.2979, -19.4197>, <-54.02151, 340.9595, -18.5331>, <-54.3889, 341.1118, -18.9164> }
					triangle { <-51.9431, 341.871, -20.9489>, <-54.02151, 340.9595, -18.5331>, <-53.6073, 341.2979, -19.4197> }
					triangle { <-56.04301, 335.7916, -21.1006>, <-55.867, 337.6892, -21.3546>, <-54.3889, 341.1118, -18.9164> }
					triangle { <-54.5373, 335.2546, -20.1325>, <-54.6807, 334.4492, -20.1859>, <-56.04301, 335.7916, -21.1006> }
					triangle { <-56.04301, 335.7916, -21.1006>, <-54.3889, 341.1118, -18.9164>, <-54.5373, 335.2546, -20.1325> }
					triangle { <-54.02151, 340.9595, -18.5331>, <-54.5373, 335.2546, -20.1325>, <-54.3889, 341.1118, -18.9164> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-51.9431, 341.871, -20.9489>, <-52.2664, 342.0157, -20.238>, <-53.3259, 341.4555, -19.1181> }
					triangle { <-52.2664, 342.0157, -20.238>, <-53.8261, 341.4271, -18.3132>, <-53.3259, 341.4555, -19.1181> }
					triangle { <-53.8261, 341.4271, -18.3132>, <-54.02151, 340.9595, -18.5331>, <-53.3259, 341.4555, -19.1181> }
					triangle { <-53.3259, 341.4555, -19.1181>, <-54.02151, 340.9595, -18.5331>, <-51.9431, 341.871, -20.9489> }
					triangle { <-53.8261, 341.4271, -18.3132>, <-50.4008, 340.8123, -15.4737>, <-49.8145, 339.2809, -14.4258> }
					triangle { <-49.8145, 339.2809, -14.4258>, <-49.721, 337.2885, -14.8479>, <-50.1302, 337.7236, -15.4095> }
					triangle { <-50.1302, 337.7236, -15.4095>, <-53.8261, 341.4271, -18.3132>, <-49.8145, 339.2809, -14.4258> }
					triangle { <-53.8261, 341.4271, -18.3132>, <-50.1302, 337.7236, -15.4095>, <-54.02151, 340.9595, -18.5331> }
					triangle { <-53.4643, 341.0129, -19.4042>, <-52.474, 341.3518, -20.6671>, <-51.9431, 341.871, -20.9489> }
					triangle { <-53.4643, 341.0129, -19.4042>, <-54.1029, 340.5419, -18.8853>, <-52.474, 341.3518, -20.6671> }
					triangle { <-53.4643, 341.0129, -19.4042>, <-54.02151, 340.9595, -18.5331>, <-54.1029, 340.5419, -18.8853> }
					triangle { <-51.9431, 341.871, -20.9489>, <-54.02151, 340.9595, -18.5331>, <-53.4643, 341.0129, -19.4042> }
					triangle { <-50.7604, 336.2565, -16.3806>, <-51.6004, 336.9766, -17.953>, <-54.1029, 340.5419, -18.8853> }
					triangle { <-50.1302, 337.7236, -15.4095>, <-49.721, 337.2885, -14.8479>, <-50.7604, 336.2565, -16.3806> }
					triangle { <-50.7604, 336.2565, -16.3806>, <-54.1029, 340.5419, -18.8853>, <-50.1302, 337.7236, -15.4095> }
					triangle { <-54.02151, 340.9595, -18.5331>, <-50.1302, 337.7236, -15.4095>, <-54.1029, 340.5419, -18.8853> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-51.9431, 341.871, -20.9489>, <-52.6233, 341.9874, -20.5557>, <-53.5639, 341.4367, -19.33> }
					triangle { <-52.6233, 341.9874, -20.5557>, <-54.3021, 341.3894, -18.7369>, <-53.5639, 341.4367, -19.33> }
					triangle { <-54.3021, 341.3894, -18.7369>, <-54.02151, 340.9595, -18.5331>, <-53.5639, 341.4367, -19.33> }
					triangle { <-53.5639, 341.4367, -19.33>, <-54.02151, 340.9595, -18.5331>, <-51.9431, 341.871, -20.9489> }
					triangle { <-54.3021, 341.3894, -18.7369>, <-53.5827, 345.2406, -16.5404>, <-52.9642, 345.6356, -14.738> }
					triangle { <-52.9642, 345.6356, -14.738>, <-51.5241, 344.7897, -13.5689>, <-51.6896, 344.3601, -14.2472> }
					triangle { <-51.6896, 344.3601, -14.2472>, <-54.3021, 341.3894, -18.7369>, <-52.9642, 345.6356, -14.738> }
					triangle { <-54.3021, 341.3894, -18.7369>, <-51.6896, 344.3601, -14.2472>, <-54.02151, 340.9595, -18.5331> }
					triangle { <-53.2263, 341.0317, -19.1923>, <-52.117, 341.38, -20.3493>, <-51.9431, 341.871, -20.9489> }
					triangle { <-53.2263, 341.0317, -19.1923>, <-53.6269, 340.5796, -18.4616>, <-52.117, 341.38, -20.3493> }
					triangle { <-53.2263, 341.0317, -19.1923>, <-54.02151, 340.9595, -18.5331>, <-53.6269, 340.5796, -18.4616> }
					triangle { <-51.9431, 341.871, -20.9489>, <-54.02151, 340.9595, -18.5331>, <-53.2263, 341.0317, -19.1923> }
					triangle { <-50.6575, 342.8685, -13.7975>, <-50.657, 341.731, -15.3476>, <-53.6269, 340.5796, -18.4616> }
					triangle { <-51.6896, 344.3601, -14.2472>, <-51.5241, 344.7897, -13.5689>, <-50.6575, 342.8685, -13.7975> }
					triangle { <-50.6575, 342.8685, -13.7975>, <-53.6269, 340.5796, -18.4616>, <-51.6896, 344.3601, -14.2472> }
					triangle { <-54.02151, 340.9595, -18.5331>, <-51.6896, 344.3601, -14.2472>, <-53.6269, 340.5796, -18.4616> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-51.9431, 341.871, -20.9489>, <-52.6283, 341.5334, -20.7313>, <-53.5672, 341.134, -19.447> }
					triangle { <-52.6283, 341.5334, -20.7313>, <-54.3087, 340.784, -18.971>, <-53.5672, 341.134, -19.447> }
					triangle { <-54.3087, 340.784, -18.971>, <-54.02151, 340.9595, -18.5331>, <-53.5672, 341.134, -19.447> }
					triangle { <-53.5672, 341.134, -19.447>, <-54.02151, 340.9595, -18.5331>, <-51.9431, 341.871, -20.9489> }
					triangle { <-54.3087, 340.784, -18.971>, <-57.4043, 343.7039, -20.4079>, <-58.3383, 345.172, -19.5362> }
					triangle { <-58.3383, 345.172, -19.5362>, <-57.7188, 346.5969, -18.2164>, <-57.1674, 346.0029, -18.34> }
					triangle { <-57.1674, 346.0029, -18.34>, <-54.3087, 340.784, -18.971>, <-58.3383, 345.172, -19.5362> }
					triangle { <-54.3087, 340.784, -18.971>, <-57.1674, 346.0029, -18.34>, <-54.02151, 340.9595, -18.5331> }
					triangle { <-53.223, 341.3345, -19.07531>, <-52.112, 341.8341, -20.1737>, <-51.9431, 341.871, -20.9489> }
					triangle { <-53.223, 341.3345, -19.07531>, <-53.6203, 341.185, -18.2275>, <-52.112, 341.8341, -20.1737> }
					triangle { <-53.223, 341.3345, -19.07531>, <-54.02151, 340.9595, -18.5331>, <-53.6203, 341.185, -18.2275> }
					triangle { <-51.9431, 341.871, -20.9489>, <-54.02151, 340.9595, -18.5331>, <-53.223, 341.3345, -19.07531> }
					triangle { <-55.9862, 346.5419, -16.9958>, <-54.4212, 345.4414, -17.186>, <-53.6203, 341.185, -18.2275> }
					triangle { <-57.1674, 346.0029, -18.34>, <-57.7188, 346.5969, -18.2164>, <-55.9862, 346.5419, -16.9958> }
					triangle { <-55.9862, 346.5419, -16.9958>, <-53.6203, 341.185, -18.2275>, <-57.1674, 346.0029, -18.34> }
					triangle { <-54.02151, 340.9595, -18.5331>, <-57.1674, 346.0029, -18.34>, <-53.6203, 341.185, -18.2275> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-28.9825, 324.689, -65.7896>, <-29.3244, 327.0178, -65.8384>, 0.2999 }
			cylinder { <-29.3244, 327.0178, -65.8384>, <-29.6476, 329.3463, -65.9668>, 0.2999 }
			cylinder { <-29.6476, 329.3463, -65.9668>, <-29.9519, 331.6715, -66.1745>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-29.9519, 331.6715, -66.1745>, <-28.474, 333.1075, -67.3131>, 0.2999 }
			cylinder { <-28.474, 333.1075, -67.3131>, <-27.04259, 334.6067, -68.4292>, 0.2999 }
			cylinder { <-27.04259, 334.6067, -68.4292>, <-25.6594, 336.1675, -69.5217>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-25.6594, 336.1675, -69.5217>, <-23.3456, 341.5719, -73.4359>, 0.2999 }
				cylinder { <-23.3456, 341.5719, -73.4359>, <-23.06647, 347.2331, -77.6496>, 0.2999 }
				cylinder { <-23.06647, 347.2331, -77.6496>, <-24.8461, 352.6635, -81.8001>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-24.8461, 352.6635, -81.8001>, <-25.4244, 353.2436, -81.9239>, <-25.8523, 354.5964, -82.8798> }
					triangle { <-25.4244, 353.2436, -81.9239>, <-26.3892, 355.3602, -83.2055>, <-25.8523, 354.5964, -82.8798> }
					triangle { <-26.3892, 355.3602, -83.2055>, <-25.9512, 355.4164, -83.5755>, <-25.8523, 354.5964, -82.8798> }
					triangle { <-25.8523, 354.5964, -82.8798>, <-25.9512, 355.4164, -83.5755>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-26.3892, 355.3602, -83.2055>, <-30.013, 352.9272, -84.9067>, <-30.6367, 352.5285, -86.7967> }
					triangle { <-30.6367, 352.5285, -86.7967>, <-29.5792, 352.0431, -88.5764>, <-29.07288, 352.3015, -87.9377> }
					triangle { <-29.07288, 352.3015, -87.9377>, <-26.3892, 355.3602, -83.2055>, <-30.6367, 352.5285, -86.7967> }
					triangle { <-26.3892, 355.3602, -83.2055>, <-29.07288, 352.3015, -87.9377>, <-25.9512, 355.4164, -83.5755> }
					triangle { <-25.384, 354.5771, -83.2012>, <-24.7219, 353.2147, -82.406>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-25.384, 354.5771, -83.2012>, <-25.4526, 355.3217, -83.8483>, <-24.7219, 353.2147, -82.406> }
					triangle { <-25.384, 354.5771, -83.2012>, <-25.9512, 355.4164, -83.5755>, <-25.4526, 355.3217, -83.8483> }
					triangle { <-24.8461, 352.6635, -81.8001>, <-25.9512, 355.4164, -83.5755>, <-25.384, 354.5771, -83.2012> }
					triangle { <-27.4366, 352.3968, -88.9927>, <-25.9544, 352.7603, -87.6919>, <-25.4526, 355.3217, -83.8483> }
					triangle { <-29.07288, 352.3015, -87.9377>, <-29.5792, 352.0431, -88.5764>, <-27.4366, 352.3968, -88.9927> }
					triangle { <-27.4366, 352.3968, -88.9927>, <-25.4526, 355.3217, -83.8483>, <-29.07288, 352.3015, -87.9377> }
					triangle { <-25.9512, 355.4164, -83.5755>, <-29.07288, 352.3015, -87.9377>, <-25.4526, 355.3217, -83.8483> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-24.8461, 352.6635, -81.8001>, <-24.9941, 353.4781, -81.8282>, <-25.5654, 354.7527, -82.816> }
					triangle { <-24.9941, 353.4781, -81.8282>, <-25.8154, 355.6729, -83.0779>, <-25.5654, 354.7527, -82.816> }
					triangle { <-25.8154, 355.6729, -83.0779>, <-25.9512, 355.4164, -83.5755>, <-25.5654, 354.7527, -82.816> }
					triangle { <-25.5654, 354.7527, -82.816>, <-25.9512, 355.4164, -83.5755>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-25.8154, 355.6729, -83.0779>, <-29.4456, 356.2122, -80.1665>, <-31.4517, 356.2835, -80.4671> }
					triangle { <-31.4517, 356.2835, -80.4671>, <-32.7439, 355.1789, -81.7444>, <-31.9138, 355.0515, -81.9052> }
					triangle { <-31.9138, 355.0515, -81.9052>, <-25.8154, 355.6729, -83.0779>, <-31.4517, 356.2835, -80.4671> }
					triangle { <-25.8154, 355.6729, -83.0779>, <-31.9138, 355.0515, -81.9052>, <-25.9512, 355.4164, -83.5755> }
					triangle { <-25.6709, 354.4207, -83.265>, <-25.1523, 352.9802, -82.5017>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-25.6709, 354.4207, -83.265>, <-26.02643, 355.009, -83.9759>, <-25.1523, 352.9802, -82.5017> }
					triangle { <-25.6709, 354.4207, -83.265>, <-25.9512, 355.4164, -83.5755>, <-26.02643, 355.009, -83.9759> }
					triangle { <-24.8461, 352.6635, -81.8001>, <-25.9512, 355.4164, -83.5755>, <-25.6709, 354.4207, -83.265> }
					triangle { <-32.1725, 354.0152, -83.5356>, <-30.3598, 353.3353, -84.0582>, <-26.02643, 355.009, -83.9759> }
					triangle { <-31.9138, 355.0515, -81.9052>, <-32.7439, 355.1789, -81.7444>, <-32.1725, 354.0152, -83.5356> }
					triangle { <-32.1725, 354.0152, -83.5356>, <-26.02643, 355.009, -83.9759>, <-31.9138, 355.0515, -81.9052> }
					triangle { <-25.9512, 355.4164, -83.5755>, <-31.9138, 355.0515, -81.9052>, <-26.02643, 355.009, -83.9759> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-24.8461, 352.6635, -81.8001>, <-24.6723, 353.3709, -82.1947>, <-25.3509, 354.6812, -83.06035> }
					triangle { <-24.6723, 353.3709, -82.1947>, <-25.3864, 355.5299, -83.5665>, <-25.3509, 354.6812, -83.06035> }
					triangle { <-25.3864, 355.5299, -83.5665>, <-25.9512, 355.4164, -83.5755>, <-25.3509, 354.6812, -83.06035> }
					triangle { <-25.3509, 354.6812, -83.06035>, <-25.9512, 355.4164, -83.5755>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-25.3864, 355.5299, -83.5665>, <-24.08171, 358.4047, -80.1056>, <-25.09056, 359.7799, -79.00526> }
					triangle { <-25.09056, 359.7799, -79.00526>, <-27.04182, 359.7794, -78.1603>, <-26.9027, 359.1306, -78.6996> }
					triangle { <-26.9027, 359.1306, -78.6996>, <-25.3864, 355.5299, -83.5665>, <-25.09056, 359.7799, -79.00526> }
					triangle { <-25.3864, 355.5299, -83.5665>, <-26.9027, 359.1306, -78.6996>, <-25.9512, 355.4164, -83.5755> }
					triangle { <-25.8854, 354.4922, -83.0207>, <-25.474, 353.0874, -82.1352>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-25.8854, 354.4922, -83.0207>, <-26.4554, 355.1519, -83.4872>, <-25.474, 353.0874, -82.1352> }
					triangle { <-25.8854, 354.4922, -83.0207>, <-25.9512, 355.4164, -83.5755>, <-26.4554, 355.1519, -83.4872> }
					triangle { <-24.8461, 352.6635, -81.8001>, <-25.9512, 355.4164, -83.5755>, <-25.8854, 354.4922, -83.0207> }
					triangle { <-28.7428, 358.4885, -78.7342>, <-28.7138, 356.7669, -79.7619>, <-26.4554, 355.1519, -83.4872> }
					triangle { <-26.9027, 359.1306, -78.6996>, <-27.04182, 359.7794, -78.1603>, <-28.7428, 358.4885, -78.7342> }
					triangle { <-28.7428, 358.4885, -78.7342>, <-26.4554, 355.1519, -83.4872>, <-26.9027, 359.1306, -78.6996> }
					triangle { <-25.9512, 355.4164, -83.5755>, <-26.9027, 359.1306, -78.6996>, <-26.4554, 355.1519, -83.4872> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-24.8461, 352.6635, -81.8001>, <-24.9008, 353.0691, -82.5204>, <-25.5032, 354.48, -83.2774> }
					triangle { <-24.9008, 353.0691, -82.5204>, <-25.6911, 355.1275, -84.00085>, <-25.5032, 354.48, -83.2774> }
					triangle { <-25.6911, 355.1275, -84.00085>, <-25.9512, 355.4164, -83.5755>, <-25.5032, 354.48, -83.2774> }
					triangle { <-25.5032, 354.48, -83.2774>, <-25.9512, 355.4164, -83.5755>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-25.6911, 355.1275, -84.00085>, <-21.2839, 356.4953, -84.8077>, <-20.2848, 358.2185, -84.4176> }
					triangle { <-20.2848, 358.2185, -84.4176>, <-20.2998, 359.5298, -82.7438>, <-20.918, 358.9395, -82.721> }
					triangle { <-20.918, 358.9395, -82.721>, <-25.6911, 355.1275, -84.00085>, <-20.2848, 358.2185, -84.4176> }
					triangle { <-25.6911, 355.1275, -84.00085>, <-20.918, 358.9395, -82.721>, <-25.9512, 355.4164, -83.5755> }
					triangle { <-25.7331, 354.6934, -82.8035>, <-25.2455, 353.3892, -81.8095>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-25.7331, 354.6934, -82.8035>, <-26.1507, 355.5543, -83.05302>, <-25.2455, 353.3892, -81.8095> }
					triangle { <-25.7331, 354.6934, -82.8035>, <-25.9512, 355.4164, -83.5755>, <-26.1507, 355.5543, -83.05302> }
					triangle { <-24.8461, 352.6635, -81.8001>, <-25.9512, 355.4164, -83.5755>, <-25.7331, 354.6934, -82.8035> }
					triangle { <-21.8553, 359.6766, -81.1791>, <-23.2757, 358.3446, -80.7004>, <-26.1507, 355.5543, -83.05302> }
					triangle { <-20.918, 358.9395, -82.721>, <-20.2998, 359.5298, -82.7438>, <-21.8553, 359.6766, -81.1791> }
					triangle { <-21.8553, 359.6766, -81.1791>, <-26.1507, 355.5543, -83.05302>, <-20.918, 358.9395, -82.721> }
					triangle { <-25.9512, 355.4164, -83.5755>, <-20.918, 358.9395, -82.721>, <-26.1507, 355.5543, -83.05302> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-24.8461, 352.6635, -81.8001>, <-25.3726, 352.9893, -82.3505>, <-25.8178, 354.4268, -83.1642> }
					triangle { <-25.3726, 352.9893, -82.3505>, <-26.3202, 355.0211, -83.7743>, <-25.8178, 354.4268, -83.1642> }
					triangle { <-26.3202, 355.0211, -83.7743>, <-25.9512, 355.4164, -83.5755>, <-25.8178, 354.4268, -83.1642> }
					triangle { <-25.8178, 354.4268, -83.1642>, <-25.9512, 355.4164, -83.5755>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-26.3202, 355.0211, -83.7743>, <-25.00504, 353.059, -87.8197>, <-23.7642, 353.6692, -89.3056> }
					triangle { <-23.7642, 353.6692, -89.3056>, <-21.8917, 354.6763, -89.2785>, <-22.2794, 354.6552, -88.5167> }
					triangle { <-22.2794, 354.6552, -88.5167>, <-26.3202, 355.0211, -83.7743>, <-23.7642, 353.6692, -89.3056> }
					triangle { <-26.3202, 355.0211, -83.7743>, <-22.2794, 354.6552, -88.5167>, <-25.9512, 355.4164, -83.5755> }
					triangle { <-25.4185, 354.7466, -82.9168>, <-24.7737, 353.4691, -81.9794>, <-24.8461, 352.6635, -81.8001> }
					triangle { <-25.4185, 354.7466, -82.9168>, <-25.5216, 355.6608, -83.2795>, <-24.7737, 353.4691, -81.9794> }
					triangle { <-25.4185, 354.7466, -82.9168>, <-25.9512, 355.4164, -83.5755>, <-25.5216, 355.6608, -83.2795> }
					triangle { <-24.8461, 352.6635, -81.8001>, <-25.9512, 355.4164, -83.5755>, <-25.4185, 354.7466, -82.9168> }
					triangle { <-21.03589, 355.8549, -87.6149>, <-21.5446, 355.8311, -85.6754>, <-25.5216, 355.6608, -83.2795> }
					triangle { <-22.2794, 354.6552, -88.5167>, <-21.8917, 354.6763, -89.2785>, <-21.03589, 355.8549, -87.6149> }
					triangle { <-21.03589, 355.8549, -87.6149>, <-25.5216, 355.6608, -83.2795>, <-22.2794, 354.6552, -88.5167> }
					triangle { <-25.9512, 355.4164, -83.5755>, <-22.2794, 354.6552, -88.5167>, <-25.5216, 355.6608, -83.2795> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-25.6594, 336.1675, -69.5217>, <-24.211, 337.6881, -70.5858>, 0.2999 }
			cylinder { <-24.211, 337.6881, -70.5858>, <-22.6991, 339.1669, -71.6201>, 0.2999 }
			cylinder { <-22.6991, 339.1669, -71.6201>, <-21.1255, 340.602, -72.6235>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-21.1255, 340.602, -72.6235>, <-15.5345, 344.7659, -73.7577>, 0.2999 }
				cylinder { <-15.5345, 344.7659, -73.7577>, <-9.5551, 348.4298, -72.9184>, 0.2999 }
				cylinder { <-9.5551, 348.4298, -72.9184>, <-3.702, 351.2783, -70.1777>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-3.702, 351.2783, -70.1777>, <-3.08241, 351.2387, -69.6293>, <-1.6798, 352.0349, -69.05875> }
					triangle { <-3.08241, 351.2387, -69.6293>, <-0.8743, 352.1996, -68.5094>, <-1.6798, 352.0349, -69.05875> }
					triangle { <-0.8743, 352.1996, -68.5094>, <-0.8371, 352.6725, -68.8363>, <-1.6798, 352.0349, -69.05875> }
					triangle { <-1.6798, 352.0349, -69.05875>, <-0.8371, 352.6725, -68.8363>, <-3.702, 351.2783, -70.1777> }
					triangle { <-0.8743, 352.1996, -68.5094>, <-3.01992, 352.8924, -64.4031>, <-3.3271, 354.5507, -63.2738> }
					triangle { <-3.3271, 354.5507, -63.2738>, <-3.8334, 356.5518, -63.7842>, <-3.6255, 356.0692, -64.4587> }
					triangle { <-3.6255, 356.0692, -64.4587>, <-0.8743, 352.1996, -68.5094>, <-3.3271, 354.5507, -63.2738> }
					triangle { <-0.8743, 352.1996, -68.5094>, <-3.6255, 356.0692, -64.4587>, <-0.8371, 352.6725, -68.8363> }
					triangle { <-1.7211, 352.4697, -69.4224>, <-3.1443, 351.8908, -70.1748>, <-3.702, 351.2783, -70.1777> }
					triangle { <-1.7211, 352.4697, -69.4224>, <-0.9569, 353.0691, -69.2367>, <-3.1443, 351.8908, -70.1748> }
					triangle { <-1.7211, 352.4697, -69.4224>, <-0.8371, 352.6725, -68.8363>, <-0.9569, 353.0691, -69.2367> }
					triangle { <-3.702, 351.2783, -70.1777>, <-0.8371, 352.6725, -68.8363>, <-1.7211, 352.4697, -69.4224> }
					triangle { <-3.6093, 357.5215, -65.7587>, <-3.3778, 356.6602, -67.5547>, <-0.9569, 353.0691, -69.2367> }
					triangle { <-3.6255, 356.0692, -64.4587>, <-3.8334, 356.5518, -63.7842>, <-3.6093, 357.5215, -65.7587> }
					triangle { <-3.6093, 357.5215, -65.7587>, <-0.9569, 353.0691, -69.2367>, <-3.6255, 356.0692, -64.4587> }
					triangle { <-0.8371, 352.6725, -68.8363>, <-3.6255, 356.0692, -64.4587>, <-0.9569, 353.0691, -69.2367> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.702, 351.2783, -70.1777>, <-2.879, 351.2593, -70.08501>, <-1.5443, 352.0487, -69.3625> }
					triangle { <-2.879, 351.2593, -70.08501>, <-0.6032, 352.227, -69.1169>, <-1.5443, 352.0487, -69.3625> }
					triangle { <-0.6032, 352.227, -69.1169>, <-0.8371, 352.6725, -68.8363>, <-1.5443, 352.0487, -69.3625> }
					triangle { <-1.5443, 352.0487, -69.3625>, <-0.8371, 352.6725, -68.8363>, <-3.702, 351.2783, -70.1777> }
					triangle { <-0.6032, 352.227, -69.1169>, <0.09481, 348.4488, -66.4367>, <0.3047, 348.2031, -64.4329> }
					triangle { <0.3047, 348.2031, -64.4329>, <-0.6791, 349.0983, -62.774>, <-0.856, 349.4757, -63.5206> }
					triangle { <-0.856, 349.4757, -63.5206>, <-0.6032, 352.227, -69.1169>, <0.3047, 348.2031, -64.4329> }
					triangle { <-0.6032, 352.227, -69.1169>, <-0.856, 349.4757, -63.5206>, <-0.8371, 352.6725, -68.8363> }
					triangle { <-1.8567, 352.456, -69.1186>, <-3.3476, 351.8702, -69.7192>, <-3.702, 351.2783, -70.1777> }
					triangle { <-1.8567, 352.456, -69.1186>, <-1.228, 353.0416, -68.6292>, <-3.3476, 351.8702, -69.7192> }
					triangle { <-1.8567, 352.456, -69.1186>, <-0.8371, 352.6725, -68.8363>, <-1.228, 353.0416, -68.6292> }
					triangle { <-3.702, 351.2783, -70.1777>, <-0.8371, 352.6725, -68.8363>, <-1.8567, 352.456, -69.1186> }
					triangle { <-1.8299, 350.9863, -62.7666>, <-2.6126, 351.9788, -64.3234>, <-1.228, 353.0416, -68.6292> }
					triangle { <-0.856, 349.4757, -63.5206>, <-0.6791, 349.0983, -62.774>, <-1.8299, 350.9863, -62.7666> }
					triangle { <-1.8299, 350.9863, -62.7666>, <-1.228, 353.0416, -68.6292>, <-0.856, 349.4757, -63.5206> }
					triangle { <-0.8371, 352.6725, -68.8363>, <-0.856, 349.4757, -63.5206>, <-1.228, 353.0416, -68.6292> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.702, 351.2783, -70.1777>, <-2.9973, 351.6992, -70.2896>, <-1.6231, 352.3419, -69.4988> }
					triangle { <-2.9973, 351.6992, -70.2896>, <-0.7609, 352.8135, -69.3896>, <-1.6231, 352.3419, -69.4988> }
					triangle { <-0.7609, 352.8135, -69.3896>, <-0.8371, 352.6725, -68.8363>, <-1.6231, 352.3419, -69.4988> }
					triangle { <-1.6231, 352.3419, -69.4988>, <-0.8371, 352.6725, -68.8363>, <-3.702, 351.2783, -70.1777> }
					triangle { <-0.7609, 352.8135, -69.3896>, <1.9303, 349.8029, -71.764>, <3.3389, 348.4622, -71.1822> }
					triangle { <3.3389, 348.4622, -71.1822>, <3.4434, 347.1277, -69.5302>, <2.8013, 347.6897, -69.4754> }
					triangle { <2.8013, 347.6897, -69.4754>, <-0.7609, 352.8135, -69.3896>, <3.3389, 348.4622, -71.1822> }
					triangle { <-0.7609, 352.8135, -69.3896>, <2.8013, 347.6897, -69.4754>, <-0.8371, 352.6725, -68.8363> }
					triangle { <-1.7778, 352.1627, -68.9822>, <-3.2294, 351.4303, -69.5146>, <-3.702, 351.2783, -70.1777> }
					triangle { <-1.7778, 352.1627, -68.9822>, <-1.07031, 352.4551, -68.3564>, <-3.2294, 351.4303, -69.5146> }
					triangle { <-1.7778, 352.1627, -68.9822>, <-0.8371, 352.6725, -68.8363>, <-1.07031, 352.4551, -68.3564> }
					triangle { <-3.702, 351.2783, -70.1777>, <-0.8371, 352.6725, -68.8363>, <-1.7778, 352.1627, -68.9822> }
					triangle { <2.2818, 347.2376, -67.6519>, <0.5897, 348.2496, -67.2866>, <-1.07031, 352.4551, -68.3564> }
					triangle { <2.8013, 347.6897, -69.4754>, <3.4434, 347.1277, -69.5302>, <2.2818, 347.2376, -67.6519> }
					triangle { <2.2818, 347.2376, -67.6519>, <-1.07031, 352.4551, -68.3564>, <2.8013, 347.6897, -69.4754> }
					triangle { <-0.8371, 352.6725, -68.8363>, <2.8013, 347.6897, -69.4754>, <-1.07031, 352.4551, -68.3564> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.702, 351.2783, -70.1777>, <-3.2749, 351.9546, -69.9623>, <-1.8082, 352.5122, -69.2807> }
					triangle { <-3.2749, 351.9546, -69.9623>, <-1.1309, 353.1541, -68.9533>, <-1.8082, 352.5122, -69.2807> }
					triangle { <-1.1309, 353.1541, -68.9533>, <-0.8371, 352.6725, -68.8363>, <-1.8082, 352.5122, -69.2807> }
					triangle { <-1.8082, 352.5122, -69.2807>, <-0.8371, 352.6725, -68.8363>, <-3.702, 351.2783, -70.1777> }
					triangle { <-1.1309, 353.1541, -68.9533>, <-0.03288, 355.0959, -73.07259>, <1.6105, 354.9725, -74.2573> }
					triangle { <1.6105, 354.9725, -74.2573>, <2.8754, 353.3448, -74.7789>, <2.3263, 353.1628, -74.1492> }
					triangle { <2.3263, 353.1628, -74.1492>, <-1.1309, 353.1541, -68.9533>, <1.6105, 354.9725, -74.2573> }
					triangle { <-1.1309, 353.1541, -68.9533>, <2.3263, 353.1628, -74.1492>, <-0.8371, 352.6725, -68.8363> }
					triangle { <-1.5928, 351.9925, -69.2004>, <-2.9518, 351.175, -69.8419>, <-3.702, 351.2783, -70.1777> }
					triangle { <-1.5928, 351.9925, -69.2004>, <-0.7002, 352.1146, -68.7927>, <-2.9518, 351.175, -69.8419> }
					triangle { <-1.5928, 351.9925, -69.2004>, <-0.8371, 352.6725, -68.8363>, <-0.7002, 352.1146, -68.7927> }
					triangle { <-3.702, 351.2783, -70.1777>, <-0.8371, 352.6725, -68.8363>, <-1.5928, 351.9925, -69.2004> }
					triangle { <3.08212, 351.4209, -73.7088>, <1.8335, 350.5915, -72.3769>, <-0.7002, 352.1146, -68.7927> }
					triangle { <2.3263, 353.1628, -74.1492>, <2.8754, 353.3448, -74.7789>, <3.08212, 351.4209, -73.7088> }
					triangle { <3.08212, 351.4209, -73.7088>, <-0.7002, 352.1146, -68.7927>, <2.3263, 353.1628, -74.1492> }
					triangle { <-0.8371, 352.6725, -68.8363>, <2.3263, 353.1628, -74.1492>, <-0.7002, 352.1146, -68.7927> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.702, 351.2783, -70.1777>, <-3.3282, 351.6657, -69.5481>, <-1.8437, 352.3196, -69.00459> }
					triangle { <-3.3282, 351.6657, -69.5481>, <-1.2021, 352.7689, -68.401>, <-1.8437, 352.3196, -69.00459> }
					triangle { <-1.2021, 352.7689, -68.401>, <-0.8371, 352.6725, -68.8363>, <-1.8437, 352.3196, -69.00459> }
					triangle { <-1.8437, 352.3196, -69.00459>, <-0.8371, 352.6725, -68.8363>, <-3.702, 351.2783, -70.1777> }
					triangle { <-1.2021, 352.7689, -68.401>, <-3.1384, 357.0341, -68.4546>, <-2.5714, 358.7921, -69.2959> }
					triangle { <-2.5714, 358.7921, -69.2959>, <-1.6897, 359.2572, -71.1741>, <-1.7056, 358.4198, -71.00204> }
					triangle { <-1.7056, 358.4198, -71.00204>, <-1.2021, 352.7689, -68.401>, <-2.5714, 358.7921, -69.2959> }
					triangle { <-1.2021, 352.7689, -68.401>, <-1.7056, 358.4198, -71.00204>, <-0.8371, 352.6725, -68.8363> }
					triangle { <-1.5572, 352.1851, -69.4765>, <-2.8985, 351.4638, -70.2561>, <-3.702, 351.2783, -70.1777> }
					triangle { <-1.5572, 352.1851, -69.4765>, <-0.6291, 352.4998, -69.345>, <-2.8985, 351.4638, -70.2561> }
					triangle { <-1.5572, 352.1851, -69.4765>, <-0.8371, 352.6725, -68.8363>, <-0.6291, 352.4998, -69.345> }
					triangle { <-3.702, 351.2783, -70.1777>, <-0.8371, 352.6725, -68.8363>, <-1.5572, 352.1851, -69.4765> }
					triangle { <-0.6138, 357.8727, -72.5211>, <-0.6555, 355.868, -72.5451>, <-0.6291, 352.4998, -69.345> }
					triangle { <-1.7056, 358.4198, -71.00204>, <-1.6897, 359.2572, -71.1741>, <-0.6138, 357.8727, -72.5211> }
					triangle { <-0.6138, 357.8727, -72.5211>, <-0.6291, 352.4998, -69.345>, <-1.7056, 358.4198, -71.00204> }
					triangle { <-0.8371, 352.6725, -68.8363>, <-1.7056, 358.4198, -71.00204>, <-0.6291, 352.4998, -69.345> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-21.1255, 340.602, -72.6235>, <-19.5976, 342.0376, -73.6945>, 0.2999 }
			cylinder { <-19.5976, 342.0376, -73.6945>, <-18.1173, 343.472, -74.832>, 0.2999 }
			cylinder { <-18.1173, 343.472, -74.832>, <-16.6865, 344.9035, -76.03452>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-16.6865, 344.9035, -76.03452>, <-12.7415, 347.7964, -81.1287>, 0.2999 }
				cylinder { <-12.7415, 347.7964, -81.1287>, <-9.4838, 349.0385, -87.271>, 0.2999 }
				cylinder { <-9.4838, 349.0385, -87.271>, <-7.1941, 348.5229, -93.9324>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.1941, 348.5229, -93.9324>, <-7.2154, 348.2426, -94.7117>, <-6.3987, 348.2552, -96.2149> }
					triangle { <-7.2154, 348.2426, -94.7117>, <-6.2155, 348.0486, -97.1644>, <-6.3987, 348.2552, -96.2149> }
					triangle { <-6.2155, 348.0486, -97.1644>, <-5.7527, 348.3789, -97.07137>, <-6.3987, 348.2552, -96.2149> }
					triangle { <-6.3987, 348.2552, -96.2149>, <-5.7527, 348.3789, -97.07137>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-6.2155, 348.0486, -97.1644>, <-5.4023, 343.4602, -96.6847>, <-3.7109, 342.3436, -96.7956> }
					triangle { <-3.7109, 342.3436, -96.7956>, <-1.7275, 342.6848, -96.1091>, <-2.2301, 343.3748, -96.05865> }
					triangle { <-2.2301, 343.3748, -96.05865>, <-6.2155, 348.0486, -97.1644>, <-3.7109, 342.3436, -96.7956> }
					triangle { <-6.2155, 348.0486, -97.1644>, <-2.2301, 343.3748, -96.05865>, <-5.7527, 348.3789, -97.07137> }
					triangle { <-5.9754, 348.5894, -96.03587>, <-6.5804, 348.744, -94.4431>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-5.9754, 348.5894, -96.03587>, <-5.3689, 348.717, -96.8063>, <-6.5804, 348.744, -94.4431> }
					triangle { <-5.9754, 348.5894, -96.03587>, <-5.7527, 348.3789, -97.07137>, <-5.3689, 348.717, -96.8063> }
					triangle { <-7.1941, 348.5229, -93.9324>, <-5.7527, 348.3789, -97.07137>, <-5.9754, 348.5894, -96.03587> }
					triangle { <-0.8183, 344.6275, -95.5721>, <-1.7336, 346.3568, -95.133>, <-5.3689, 348.717, -96.8063> }
					triangle { <-2.2301, 343.3748, -96.05865>, <-1.7275, 342.6848, -96.1091>, <-0.8183, 344.6275, -95.5721> }
					triangle { <-0.8183, 344.6275, -95.5721>, <-5.3689, 348.717, -96.8063>, <-2.2301, 343.3748, -96.05865> }
					triangle { <-5.7527, 348.3789, -97.07137>, <-2.2301, 343.3748, -96.05865>, <-5.3689, 348.717, -96.8063> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.1941, 348.5229, -93.9324>, <-7.2083, 348.7416, -94.7313>, <-6.394, 348.5878, -96.228> }
					triangle { <-7.2083, 348.7416, -94.7313>, <-6.206, 348.7138, -97.1906>, <-6.394, 348.5878, -96.228> }
					triangle { <-6.206, 348.7138, -97.1906>, <-5.7527, 348.3789, -97.07137>, <-6.394, 348.5878, -96.228> }
					triangle { <-6.394, 348.5878, -96.228>, <-5.7527, 348.3789, -97.07137>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-6.206, 348.7138, -97.1906>, <-9.8987, 346.3808, -98.8835>, <-10.08251, 344.5918, -99.8246> }
					triangle { <-10.08251, 344.5918, -99.8246>, <-9.1391, 342.7117, -99.5138>, <-8.7852, 343.3495, -99.06766> }
					triangle { <-8.7852, 343.3495, -99.06766>, <-6.206, 348.7138, -97.1906>, <-10.08251, 344.5918, -99.8246> }
					triangle { <-6.206, 348.7138, -97.1906>, <-8.7852, 343.3495, -99.06766>, <-5.7527, 348.3789, -97.07137> }
					triangle { <-5.9802, 348.2568, -96.02278>, <-6.5875, 348.2451, -94.4235>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-5.9802, 348.2568, -96.02278>, <-5.3783, 348.0518, -96.7801>, <-6.5875, 348.2451, -94.4235> }
					triangle { <-5.9802, 348.2568, -96.02278>, <-5.7527, 348.3789, -97.07137>, <-5.3783, 348.0518, -96.7801> }
					triangle { <-7.1941, 348.5229, -93.9324>, <-5.7527, 348.3789, -97.07137>, <-5.9802, 348.2568, -96.02278> }
					triangle { <-7.2545, 342.33, -98.4222>, <-6.312, 343.5121, -97.1049>, <-5.3783, 348.0518, -96.7801> }
					triangle { <-8.7852, 343.3495, -99.06766>, <-9.1391, 342.7117, -99.5138>, <-7.2545, 342.33, -98.4222> }
					triangle { <-7.2545, 342.33, -98.4222>, <-5.3783, 348.0518, -96.7801>, <-8.7852, 343.3495, -99.06766> }
					triangle { <-5.7527, 348.3789, -97.07137>, <-8.7852, 343.3495, -99.06766>, <-5.3783, 348.0518, -96.7801> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.1941, 348.5229, -93.9324>, <-6.7752, 348.8997, -94.5397>, <-6.1052, 348.6932, -96.1002> }
					triangle { <-6.7752, 348.8997, -94.5397>, <-5.6285, 348.9247, -96.935>, <-6.1052, 348.6932, -96.1002> }
					triangle { <-5.6285, 348.9247, -96.935>, <-5.7527, 348.3789, -97.07137>, <-6.1052, 348.6932, -96.1002> }
					triangle { <-6.1052, 348.6932, -96.1002>, <-5.7527, 348.3789, -97.07137>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-5.6285, 348.9247, -96.935>, <-8.7042, 352.044, -98.5948>, <-10.02304, 351.9895, -100.1368> }
					triangle { <-10.02304, 351.9895, -100.1368>, <-11.3061, 350.458, -100.8644>, <-10.7442, 350.1844, -100.2809> }
					triangle { <-10.7442, 350.1844, -100.2809>, <-5.6285, 348.9247, -96.935>, <-10.02304, 351.9895, -100.1368> }
					triangle { <-5.6285, 348.9247, -96.935>, <-10.7442, 350.1844, -100.2809>, <-5.7527, 348.3789, -97.07137> }
					triangle { <-6.2689, 348.1513, -96.1505>, <-7.02072, 348.0869, -94.6151>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-6.2689, 348.1513, -96.1505>, <-5.9558, 347.8409, -97.03568>, <-7.02072, 348.0869, -94.6151> }
					triangle { <-6.2689, 348.1513, -96.1505>, <-5.7527, 348.3789, -97.07137>, <-5.9558, 347.8409, -97.03568> }
					triangle { <-7.1941, 348.5229, -93.9324>, <-5.7527, 348.3789, -97.07137>, <-6.2689, 348.1513, -96.1505> }
					triangle { <-11.1414, 348.2867, -100.4805>, <-10.1227, 347.3477, -99.03078>, <-5.9558, 347.8409, -97.03568> }
					triangle { <-10.7442, 350.1844, -100.2809>, <-11.3061, 350.458, -100.8644>, <-11.1414, 348.2867, -100.4805> }
					triangle { <-11.1414, 348.2867, -100.4805>, <-5.9558, 347.8409, -97.03568>, <-10.7442, 350.1844, -100.2809> }
					triangle { <-5.7527, 348.3789, -97.07137>, <-10.7442, 350.1844, -100.2809>, <-5.9558, 347.8409, -97.03568> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.1941, 348.5229, -93.9324>, <-6.5105, 348.5, -94.3998>, <-5.9288, 348.4268, -96.007> }
					triangle { <-6.5105, 348.5, -94.3998>, <-5.2756, 348.3918, -96.7486>, <-5.9288, 348.4268, -96.007> }
					triangle { <-5.2756, 348.3918, -96.7486>, <-5.7527, 348.3789, -97.07137>, <-5.9288, 348.4268, -96.007> }
					triangle { <-5.9288, 348.4268, -96.007>, <-5.7527, 348.3789, -97.07137>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-5.2756, 348.3918, -96.7486>, <-3.4583, 352.6763, -96.215>, <-3.6141, 354.3824, -97.3036> }
					triangle { <-3.6141, 354.3824, -97.3036>, <-5.254, 355.2908, -98.307>, <-5.418, 354.4977, -98.03296> }
					triangle { <-5.418, 354.4977, -98.03296>, <-5.2756, 348.3918, -96.7486>, <-3.6141, 354.3824, -97.3036> }
					triangle { <-5.2756, 348.3918, -96.7486>, <-5.418, 354.4977, -98.03296>, <-5.7527, 348.3789, -97.07137> }
					triangle { <-6.4453, 348.4178, -96.2437>, <-7.2853, 348.4866, -94.755>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-6.4453, 348.4178, -96.2437>, <-6.3087, 348.3739, -97.2221>, <-7.2853, 348.4866, -94.755> }
					triangle { <-6.4453, 348.4178, -96.2437>, <-5.7527, 348.3789, -97.07137>, <-6.3087, 348.3739, -97.2221> }
					triangle { <-7.1941, 348.5229, -93.9324>, <-5.7527, 348.3789, -97.07137>, <-6.4453, 348.4178, -96.2437> }
					triangle { <-7.1437, 354.3212, -98.9216>, <-7.9349, 352.5988, -98.2671>, <-6.3087, 348.3739, -97.2221> }
					triangle { <-5.418, 354.4977, -98.03296>, <-5.254, 355.2908, -98.307>, <-7.1437, 354.3212, -98.9216> }
					triangle { <-7.1437, 354.3212, -98.9216>, <-6.3087, 348.3739, -97.2221>, <-5.418, 354.4977, -98.03296> }
					triangle { <-5.7527, 348.3789, -97.07137>, <-5.418, 354.4977, -98.03296>, <-6.3087, 348.3739, -97.2221> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.1941, 348.5229, -93.9324>, <-6.7867, 348.0878, -94.5077>, <-6.1129, 348.1519, -96.07894> }
					triangle { <-6.7867, 348.0878, -94.5077>, <-5.6439, 347.8421, -96.8924>, <-6.1129, 348.1519, -96.07894> }
					triangle { <-5.6439, 347.8421, -96.8924>, <-5.7527, 348.3789, -97.07137>, <-6.1129, 348.1519, -96.07894> }
					triangle { <-6.1129, 348.1519, -96.07894>, <-5.7527, 348.3789, -97.07137>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-5.6439, 347.8421, -96.8924>, <-1.3868, 347.2912, -95.01665>, <0.3458, 348.3309, -95.2075> }
					triangle { <0.3458, 348.3309, -95.2075>, <0.7552, 350.4142, -95.3237>, <-0.07655, 350.2255, -95.3841> }
					triangle { <-0.07655, 350.2255, -95.3841>, <-5.6439, 347.8421, -96.8924>, <0.3458, 348.3309, -95.2075> }
					triangle { <-5.6439, 347.8421, -96.8924>, <-0.07655, 350.2255, -95.3841>, <-5.7527, 348.3789, -97.07137> }
					triangle { <-6.2612, 348.6926, -96.1718>, <-7.009179, 348.8988, -94.6471>, <-7.1941, 348.5229, -93.9324> }
					triangle { <-6.2612, 348.6926, -96.1718>, <-5.9405, 348.9235, -97.07828>, <-7.009179, 348.8988, -94.6471> }
					triangle { <-6.2612, 348.6926, -96.1718>, <-5.7527, 348.3789, -97.07137>, <-5.9405, 348.9235, -97.07828> }
					triangle { <-7.1941, 348.5229, -93.9324>, <-5.7527, 348.3789, -97.07137>, <-6.2612, 348.6926, -96.1718> }
					triangle { <-0.6673, 352.0255, -95.8423>, <-2.6719, 351.977, -95.8217>, <-5.9405, 348.9235, -97.07828> }
					triangle { <-0.07655, 350.2255, -95.3841>, <0.7552, 350.4142, -95.3237>, <-0.6673, 352.0255, -95.8423> }
					triangle { <-0.6673, 352.0255, -95.8423>, <-5.9405, 348.9235, -97.07828>, <-0.07655, 350.2255, -95.3841> }
					triangle { <-5.7527, 348.3789, -97.07137>, <-0.07655, 350.2255, -95.3841>, <-5.9405, 348.9235, -97.07828> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-16.6865, 344.9035, -76.03452>, <-15.2468, 346.3805, -77.1696>, 0.2999 }
			cylinder { <-15.2468, 346.3805, -77.1696>, <-13.8001, 347.9011, -78.2361>, 0.2999 }
			cylinder { <-13.8001, 347.9011, -78.2361>, <-12.3482, 349.4636, -79.2326>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-12.3482, 349.4636, -79.2326>, <-9.2408, 355.4808, -81.2377>, 0.2999 }
				cylinder { <-9.2408, 355.4808, -81.2377>, <-7.6495, 362.3095, -82.08567>, 0.2999 }
				cylinder { <-7.6495, 362.3095, -82.08567>, <-7.7113, 369.3617, -81.7035>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.7113, 369.3617, -81.7035>, <-7.9104, 370.0487, -81.2856>, <-7.861, 371.7585, -81.3198> }
					triangle { <-7.9104, 370.0487, -81.2856>, <-7.9978, 372.6893, -81.01563>, <-7.861, 371.7585, -81.3198> }
					triangle { <-7.9978, 372.6893, -81.01563>, <-7.7416, 372.8136, -81.5164>, <-7.861, 371.7585, -81.3198> }
					triangle { <-7.861, 371.7585, -81.3198>, <-7.7416, 372.8136, -81.5164>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-7.9978, 372.6893, -81.01563>, <-12.6779, 372.7536, -81.2088>, <-13.991, 373.6637, -82.4608> }
					triangle { <-13.991, 373.6637, -82.4608>, <-13.9804, 373.9676, -84.5653>, <-13.2385, 373.6729, -84.2589> }
					triangle { <-13.2385, 373.6729, -84.2589>, <-7.9978, 372.6893, -81.01563>, <-13.991, 373.6637, -82.4608> }
					triangle { <-7.9978, 372.6893, -81.01563>, <-13.2385, 373.6729, -84.2589>, <-7.7416, 372.8136, -81.5164> }
					triangle { <-7.6039, 371.7881, -81.8258>, <-7.5248, 370.0932, -82.04454>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-7.6039, 371.7881, -81.8258>, <-7.4837, 372.7487, -82.02753>, <-7.5248, 370.0932, -82.04454> }
					triangle { <-7.6039, 371.7881, -81.8258>, <-7.7416, 372.8136, -81.5164>, <-7.4837, 372.7487, -82.02753> }
					triangle { <-7.7113, 369.3617, -81.7035>, <-7.7416, 372.8136, -81.5164>, <-7.6039, 371.7881, -81.8258> }
					triangle { <-12.2344, 373.8665, -85.9182>, <-10.4501, 373.0108, -85.5937>, <-7.4837, 372.7487, -82.02753> }
					triangle { <-13.2385, 373.6729, -84.2589>, <-13.9804, 373.9676, -84.5653>, <-12.2344, 373.8665, -85.9182> }
					triangle { <-12.2344, 373.8665, -85.9182>, <-7.4837, 372.7487, -82.02753>, <-13.2385, 373.6729, -84.2589> }
					triangle { <-7.7416, 372.8136, -81.5164>, <-13.2385, 373.6729, -84.2589>, <-7.4837, 372.7487, -82.02753> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.7113, 369.3617, -81.7035>, <-7.4171, 370.0573, -81.363>, <-7.5322, 371.7641, -81.3714> }
					triangle { <-7.4171, 370.0573, -81.363>, <-7.3402, 372.7007, -81.1189>, <-7.5322, 371.7641, -81.3714> }
					triangle { <-7.3402, 372.7007, -81.1189>, <-7.7416, 372.8136, -81.5164>, <-7.5322, 371.7641, -81.3714> }
					triangle { <-7.5322, 371.7641, -81.3714>, <-7.7416, 372.8136, -81.5164>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-7.3402, 372.7007, -81.1189>, <-8.9953, 372.5437, -76.7393>, <-10.6461, 373.3355, -75.863> }
					triangle { <-10.6461, 373.3355, -75.863>, <-12.6548, 373.5437, -76.5287>, <-12.1147, 373.2972, -77.144> }
					triangle { <-12.1147, 373.2972, -77.144>, <-7.3402, 372.7007, -81.1189>, <-10.6461, 373.3355, -75.863> }
					triangle { <-7.3402, 372.7007, -81.1189>, <-12.1147, 373.2972, -77.144>, <-7.7416, 372.8136, -81.5164> }
					triangle { <-7.9328, 371.7824, -81.7741>, <-8.01804, 370.0847, -81.967>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-7.9328, 371.7824, -81.7741>, <-8.1413, 372.7373, -81.9242>, <-8.01804, 370.0847, -81.967> }
					triangle { <-7.9328, 371.7824, -81.7741>, <-7.7416, 372.8136, -81.5164>, <-8.1413, 372.7373, -81.9242> }
					triangle { <-7.7113, 369.3617, -81.7035>, <-7.7416, 372.8136, -81.5164>, <-7.9328, 371.7824, -81.7741> }
					triangle { <-13.3834, 373.4606, -78.6146>, <-12.467, 372.7024, -80.2291>, <-8.1413, 372.7373, -81.9242> }
					triangle { <-12.1147, 373.2972, -77.144>, <-12.6548, 373.5437, -76.5287>, <-13.3834, 373.4606, -78.6146> }
					triangle { <-13.3834, 373.4606, -78.6146>, <-8.1413, 372.7373, -81.9242>, <-12.1147, 373.2972, -77.144> }
					triangle { <-7.7416, 372.8136, -81.5164>, <-12.1147, 373.2972, -77.144>, <-8.1413, 372.7373, -81.9242> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.7113, 369.3617, -81.7035>, <-7.3363, 370.0846, -81.855>, <-7.4783, 371.7824, -81.6994> }
					triangle { <-7.3363, 370.0846, -81.855>, <-7.2324, 372.7372, -81.7749>, <-7.4783, 371.7824, -81.6994> }
					triangle { <-7.2324, 372.7372, -81.7749>, <-7.7416, 372.8136, -81.5164>, <-7.4783, 371.7824, -81.6994> }
					triangle { <-7.4783, 371.7824, -81.6994>, <-7.7416, 372.8136, -81.5164>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-7.2324, 372.7372, -81.7749>, <-3.5918, 372.7042, -78.827>, <-3.3246, 373.4592, -76.962> }
					triangle { <-3.3246, 373.4592, -76.962>, <-4.5977, 373.5456, -75.261>, <-4.9973, 373.2962, -75.9746> }
					triangle { <-4.9973, 373.2962, -75.9746>, <-7.2324, 372.7372, -81.7749>, <-3.3246, 373.4592, -76.962> }
					triangle { <-7.2324, 372.7372, -81.7749>, <-4.9973, 373.2962, -75.9746>, <-7.7416, 372.8136, -81.5164> }
					triangle { <-7.9867, 371.7642, -81.4461>, <-8.09888, 370.0573, -81.475>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-7.9867, 371.7642, -81.4461>, <-8.2491, 372.7008, -81.2682>, <-8.09888, 370.0573, -81.475> }
					triangle { <-7.9867, 371.7642, -81.4461>, <-7.7416, 372.8136, -81.5164>, <-8.2491, 372.7008, -81.2682> }
					triangle { <-7.7113, 369.3617, -81.7035>, <-7.7416, 372.8136, -81.5164>, <-7.9867, 371.7642, -81.4461> }
					triangle { <-6.7985, 373.3349, -75.2309>, <-7.9977, 372.5466, -76.6315>, <-8.2491, 372.7008, -81.2682> }
					triangle { <-4.9973, 373.2962, -75.9746>, <-4.5977, 373.5456, -75.261>, <-6.7985, 373.3349, -75.2309> }
					triangle { <-6.7985, 373.3349, -75.2309>, <-8.2491, 372.7008, -81.2682>, <-4.9973, 373.2962, -75.9746> }
					triangle { <-7.7416, 372.8136, -81.5164>, <-4.9973, 373.2962, -75.9746>, <-8.2491, 372.7008, -81.2682> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.7113, 369.3617, -81.7035>, <-7.7788, 370.0933, -82.08628>, <-7.7733, 371.7881, -81.8536> }
					triangle { <-7.7788, 370.0933, -82.08628>, <-7.8224, 372.7487, -82.08318>, <-7.7733, 371.7881, -81.8536> }
					triangle { <-7.8224, 372.7487, -82.08318>, <-7.7416, 372.8136, -81.5164>, <-7.7733, 371.7881, -81.8536> }
					triangle { <-7.7733, 371.7881, -81.8536>, <-7.7416, 372.8136, -81.5164>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-7.8224, 372.7487, -82.08318>, <-3.8844, 373.0148, -84.6063>, <-2.07633, 373.865, -84.2492> }
					triangle { <-2.07633, 373.865, -84.2492>, <-0.8685, 373.9707, -82.5024>, <-1.6559, 373.6713, -82.3558> }
					triangle { <-1.6559, 373.6713, -82.3558>, <-7.8224, 372.7487, -82.08318>, <-2.07633, 373.865, -84.2492> }
					triangle { <-7.8224, 372.7487, -82.08318>, <-1.6559, 373.6713, -82.3558>, <-7.7416, 372.8136, -81.5164> }
					triangle { <-7.6917, 371.7584, -81.292>, <-7.6563, 370.0487, -81.2438>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-7.6917, 371.7584, -81.292>, <-7.6591, 372.6893, -80.9599>, <-7.6563, 370.0487, -81.2438> }
					triangle { <-7.6917, 371.7584, -81.292>, <-7.7416, 372.8136, -81.5164>, <-7.6591, 372.6893, -80.9599> }
					triangle { <-7.7113, 369.3617, -81.7035>, <-7.7416, 372.8136, -81.5164>, <-7.6917, 371.7584, -81.292> }
					triangle { <-1.5183, 373.662, -80.4115>, <-3.1768, 372.7573, -79.7391>, <-7.6591, 372.6893, -80.9599> }
					triangle { <-1.6559, 373.6713, -82.3558>, <-0.8685, 373.9707, -82.5024>, <-1.5183, 373.662, -80.4115> }
					triangle { <-1.5183, 373.662, -80.4115>, <-7.6591, 372.6893, -80.9599>, <-1.6559, 373.6713, -82.3558> }
					triangle { <-7.7416, 372.8136, -81.5164>, <-1.6559, 373.6713, -82.3558>, <-7.6591, 372.6893, -80.9599> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.7113, 369.3617, -81.7035>, <-8.1389, 370.0708, -81.729>, <-8.01345, 371.7731, -81.6154> }
					triangle { <-8.1389, 370.0708, -81.729>, <-8.3026, 372.7187, -81.6068>, <-8.01345, 371.7731, -81.6154> }
					triangle { <-8.3026, 372.7187, -81.6068>, <-7.7416, 372.8136, -81.5164>, <-8.01345, 371.7731, -81.6154> }
					triangle { <-8.01345, 371.7731, -81.6154>, <-7.7416, 372.8136, -81.5164>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-8.3026, 372.7187, -81.6068>, <-9.5848, 373.0458, -86.1006>, <-8.7679, 373.9933, -87.699> }
					triangle { <-8.7679, 373.9933, -87.699>, <-6.7549, 374.2354, -88.3395>, <-6.8262, 373.9076, -87.553> }
					triangle { <-6.8262, 373.9076, -87.553>, <-8.3026, 372.7187, -81.6068>, <-8.7679, 373.9933, -87.699> }
					triangle { <-8.3026, 372.7187, -81.6068>, <-6.8262, 373.9076, -87.553>, <-7.7416, 372.8136, -81.5164> }
					triangle { <-7.4515, 371.7734, -81.5302>, <-7.2962, 370.0712, -81.6011>, <-7.7113, 369.3617, -81.7035> }
					triangle { <-7.4515, 371.7734, -81.5302>, <-7.1789, 372.7193, -81.4363>, <-7.2962, 370.0712, -81.6011> }
					triangle { <-7.4515, 371.7734, -81.5302>, <-7.7416, 372.8136, -81.5164>, <-7.1789, 372.7193, -81.4363> }
					triangle { <-7.7113, 369.3617, -81.7035>, <-7.7416, 372.8136, -81.5164>, <-7.4515, 371.7734, -81.5302> }
					triangle { <-4.9286, 373.9954, -87.1164>, <-4.7154, 373.0485, -85.3617>, <-7.1789, 372.7193, -81.4363> }
					triangle { <-6.8262, 373.9076, -87.553>, <-6.7549, 374.2354, -88.3395>, <-4.9286, 373.9954, -87.1164> }
					triangle { <-4.9286, 373.9954, -87.1164>, <-7.1789, 372.7193, -81.4363>, <-6.8262, 373.9076, -87.553> }
					triangle { <-7.7416, 372.8136, -81.5164>, <-6.8262, 373.9076, -87.553>, <-7.1789, 372.7193, -81.4363> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-12.3482, 349.4636, -79.2326>, <-10.8573, 350.9644, -80.2658>, 0.2999 }
			cylinder { <-10.8573, 350.9644, -80.2658>, <-9.3292, 352.4016, -81.3343>, 0.2999 }
			cylinder { <-9.3292, 352.4016, -81.3343>, <-7.7657, 353.7735, -82.437>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-7.7657, 353.7735, -82.437>, <-1.7709, 356.4311, -85.06053>, 0.2999 }
				cylinder { <-1.7709, 356.4311, -85.06053>, <5.01182, 357.4018, -86.7735>, 0.2999 }
				cylinder { <5.01182, 357.4018, -86.7735>, <11.9985, 356.6018, -87.4285>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <11.9985, 356.6018, -87.4285>, <12.6628, 356.1665, -87.4269>, <14.2951, 356.2274, -87.5773> }
					triangle { <12.6628, 356.1665, -87.4269>, <15.1901, 355.9166, -87.6128>, <14.2951, 356.2274, -87.5773> }
					triangle { <15.1901, 355.9166, -87.6128>, <15.2989, 356.4518, -87.6954>, <14.2951, 356.2274, -87.5773> }
					triangle { <14.2951, 356.2274, -87.5773>, <15.2989, 356.4518, -87.6954>, <11.9985, 356.6018, -87.4285> }
					triangle { <15.1901, 355.9166, -87.6128>, <15.5688, 354.621, -83.329>, <16.5454, 355.3499, -81.8117> }
					triangle { <16.5454, 355.3499, -81.8117>, <16.8658, 357.2619, -81.1809>, <16.5297, 357.2151, -81.9272> }
					triangle { <16.5297, 357.2151, -81.9272>, <15.1901, 355.9166, -87.6128>, <16.5454, 355.3499, -81.8117> }
					triangle { <15.1901, 355.9166, -87.6128>, <16.5297, 357.2151, -81.9272>, <15.2989, 356.4518, -87.6954> }
					triangle { <14.3135, 356.7667, -87.6526>, <12.6905, 356.9755, -87.5398>, <11.9985, 356.6018, -87.4285> }
					triangle { <14.3135, 356.7667, -87.6526>, <15.2269, 356.9952, -87.7634>, <12.6905, 356.9755, -87.5398> }
					triangle { <14.3135, 356.7667, -87.6526>, <15.2989, 356.4518, -87.6954>, <15.2269, 356.9952, -87.7634> }
					triangle { <11.9985, 356.6018, -87.4285>, <15.2989, 356.4518, -87.6954>, <14.3135, 356.7667, -87.6526> }
					triangle { <16.6714, 359.0353, -82.3262>, <15.7285, 359.2951, -83.9815>, <15.2269, 356.9952, -87.7634> }
					triangle { <16.5297, 357.2151, -81.9272>, <16.8658, 357.2619, -81.1809>, <16.6714, 359.0353, -82.3262> }
					triangle { <16.6714, 359.0353, -82.3262>, <15.2269, 356.9952, -87.7634>, <16.5297, 357.2151, -81.9272> }
					triangle { <15.2989, 356.4518, -87.6954>, <16.5297, 357.2151, -81.9272>, <15.2269, 356.9952, -87.7634> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <11.9985, 356.6018, -87.4285>, <12.639, 356.3918, -87.8487>, <14.2791, 356.3776, -87.8585> }
					triangle { <12.639, 356.3918, -87.8487>, <15.1582, 356.217, -88.1752>, <14.2791, 356.3776, -87.8585> }
					triangle { <15.1582, 356.217, -88.1752>, <15.2989, 356.4518, -87.6954>, <14.2791, 356.3776, -87.8585> }
					triangle { <14.2791, 356.3776, -87.8585>, <15.2989, 356.4518, -87.6954>, <11.9985, 356.6018, -87.4285> }
					triangle { <15.1582, 356.217, -88.1752>, <15.05599, 351.7285, -88.04519>, <15.9114, 350.4226, -86.8832> }
					triangle { <15.9114, 350.4226, -86.8832>, <16.255, 350.3958, -84.8739>, <15.9919, 351.1208, -85.1516> }
					triangle { <15.9919, 351.1208, -85.1516>, <15.1582, 356.217, -88.1752>, <15.9114, 350.4226, -86.8832> }
					triangle { <15.1582, 356.217, -88.1752>, <15.9919, 351.1208, -85.1516>, <15.2989, 356.4518, -87.6954> }
					triangle { <14.3294, 356.6165, -87.3714>, <12.7143, 356.7502, -87.118>, <11.9985, 356.6018, -87.4285> }
					triangle { <14.3294, 356.6165, -87.3714>, <15.2587, 356.6949, -87.201>, <12.7143, 356.7502, -87.118> }
					triangle { <14.3294, 356.6165, -87.3714>, <15.2989, 356.4518, -87.6954>, <15.2587, 356.6949, -87.201> }
					triangle { <11.9985, 356.6018, -87.4285>, <15.2989, 356.4518, -87.6954>, <14.3294, 356.6165, -87.3714> }
					triangle { <16.2547, 352.0555, -83.5548>, <15.4914, 353.7995, -83.8237>, <15.2587, 356.6949, -87.201> }
					triangle { <15.9919, 351.1208, -85.1516>, <16.255, 350.3958, -84.8739>, <16.2547, 352.0555, -83.5548> }
					triangle { <16.2547, 352.0555, -83.5548>, <15.2587, 356.6949, -87.201>, <15.9919, 351.1208, -85.1516> }
					triangle { <15.2989, 356.4518, -87.6954>, <15.9919, 351.1208, -85.1516>, <15.2587, 356.6949, -87.201> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <11.9985, 356.6018, -87.4285>, <12.6668, 356.8631, -87.769>, <14.2977, 356.6917, -87.8054> }
					triangle { <12.6668, 356.8631, -87.769>, <15.1954, 356.8453, -88.06902>, <14.2977, 356.6917, -87.8054> }
					triangle { <15.1954, 356.8453, -88.06902>, <15.2989, 356.4518, -87.6954>, <14.2977, 356.6917, -87.8054> }
					triangle { <14.2977, 356.6917, -87.8054>, <15.2989, 356.4518, -87.6954>, <11.9985, 356.6018, -87.4285> }
					triangle { <15.1954, 356.8453, -88.06902>, <14.8766, 355.3195, -92.2813>, <15.5537, 353.7205, -93.1599> }
					triangle { <15.5537, 353.7205, -93.1599>, <15.6972, 351.7803, -92.5502>, <15.4959, 352.299, -91.9481> }
					triangle { <15.4959, 352.299, -91.9481>, <15.1954, 356.8453, -88.06902>, <15.5537, 353.7205, -93.1599> }
					triangle { <15.1954, 356.8453, -88.06902>, <15.4959, 352.299, -91.9481>, <15.2989, 356.4518, -87.6954> }
					triangle { <14.3108, 356.3023, -87.4245>, <12.6865, 356.279, -87.1977>, <11.9985, 356.6018, -87.4285> }
					triangle { <14.3108, 356.3023, -87.4245>, <15.2216, 356.0665, -87.3072>, <12.6865, 356.279, -87.1977> }
					triangle { <14.3108, 356.3023, -87.4245>, <15.2989, 356.4518, -87.6954>, <15.2216, 356.0665, -87.3072> }
					triangle { <11.9985, 356.6018, -87.4285>, <15.2989, 356.4518, -87.6954>, <14.3108, 356.3023, -87.4245> }
					triangle { <15.6432, 351.0594, -90.5573>, <14.9901, 351.9445, -88.9803>, <15.2216, 356.0665, -87.3072> }
					triangle { <15.4959, 352.299, -91.9481>, <15.6972, 351.7803, -92.5502>, <15.6432, 351.0594, -90.5573> }
					triangle { <15.6432, 351.0594, -90.5573>, <15.2216, 356.0665, -87.3072>, <15.4959, 352.299, -91.9481> }
					triangle { <15.2989, 356.4518, -87.6954>, <15.4959, 352.299, -91.9481>, <15.2216, 356.0665, -87.3072> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <11.9985, 356.6018, -87.4285>, <12.7082, 356.9334, -87.2972>, <14.3253, 356.7386, -87.4909> }
					triangle { <12.7082, 356.9334, -87.2972>, <15.2505, 356.9392, -87.44>, <14.3253, 356.7386, -87.4909> }
					triangle { <15.2505, 356.9392, -87.44>, <15.2989, 356.4518, -87.6954>, <14.3253, 356.7386, -87.4909> }
					triangle { <14.3253, 356.7386, -87.4909>, <15.2989, 356.4518, -87.6954>, <11.9985, 356.6018, -87.4285> }
					triangle { <15.2505, 356.9392, -87.44>, <15.277, 360.4647, -90.2227>, <15.9634, 360.7167, -92.02621> }
					triangle { <15.9634, 360.7167, -92.02621>, <15.958, 359.5151, -93.6731>, <15.7224, 359.1323, -92.9875> }
					triangle { <15.7224, 359.1323, -92.9875>, <15.2505, 356.9392, -87.44>, <15.9634, 360.7167, -92.02621> }
					triangle { <15.2505, 356.9392, -87.44>, <15.7224, 359.1323, -92.9875>, <15.2989, 356.4518, -87.6954> }
					triangle { <14.2833, 356.2554, -87.739>, <12.6451, 356.2086, -87.6695>, <11.9985, 356.6018, -87.4285> }
					triangle { <14.2833, 356.2554, -87.739>, <15.1665, 355.9727, -87.9362>, <12.6451, 356.2086, -87.6695> }
					triangle { <14.2833, 356.2554, -87.739>, <15.2989, 356.4518, -87.6954>, <15.1665, 355.9727, -87.9362> }
					triangle { <11.9985, 356.6018, -87.4285>, <15.2989, 356.4518, -87.6954>, <14.2833, 356.2554, -87.739> }
					triangle { <15.6762, 357.4144, -93.7218>, <14.9127, 356.2765, -92.3732>, <15.1665, 355.9727, -87.9362> }
					triangle { <15.7224, 359.1323, -92.9875>, <15.958, 359.5151, -93.6731>, <15.6762, 357.4144, -93.7218> }
					triangle { <15.6762, 357.4144, -93.7218>, <15.1665, 355.9727, -87.9362>, <15.7224, 359.1323, -92.9875> }
					triangle { <15.2989, 356.4518, -87.6954>, <15.7224, 359.1323, -92.9875>, <15.1665, 355.9727, -87.9362> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <11.9985, 356.6018, -87.4285>, <12.7057, 356.4965, -87.08266>, <14.3236, 356.4473, -87.3478> }
					triangle { <12.7057, 356.4965, -87.08266>, <15.2472, 356.3565, -87.1538>, <14.3236, 356.4473, -87.3478> }
					triangle { <15.2472, 356.3565, -87.1538>, <15.2989, 356.4518, -87.6954>, <14.3236, 356.4473, -87.3478> }
					triangle { <14.3236, 356.4473, -87.3478>, <15.2989, 356.4518, -87.6954>, <11.9985, 356.6018, -87.4285> }
					triangle { <15.2472, 356.3565, -87.1538>, <15.7112, 360.0265, -84.6063>, <16.5856, 361.739, -84.9067> }
					triangle { <16.5856, 361.739, -84.9067>, <16.6911, 362.954, -86.5404>, <16.371, 362.2165, -86.7007> }
					triangle { <16.371, 362.2165, -86.7007>, <15.2472, 356.3565, -87.1538>, <16.5856, 361.739, -84.9067> }
					triangle { <15.2472, 356.3565, -87.1538>, <16.371, 362.2165, -86.7007>, <15.2989, 356.4518, -87.6954> }
					triangle { <14.2849, 356.5467, -87.8821>, <12.6476, 356.6456, -87.8841>, <11.9985, 356.6018, -87.4285> }
					triangle { <14.2849, 356.5467, -87.8821>, <15.1698, 356.5553, -88.2224>, <12.6476, 356.6456, -87.8841> }
					triangle { <14.2849, 356.5467, -87.8821>, <15.2989, 356.4518, -87.6954>, <15.1698, 356.5553, -88.2224> }
					triangle { <11.9985, 356.6018, -87.4285>, <15.2989, 356.4518, -87.6954>, <14.2849, 356.5467, -87.8821> }
					triangle { <16.3212, 362.4182, -88.5579>, <15.3759, 360.8879, -89.2371>, <15.1698, 356.5553, -88.2224> }
					triangle { <16.371, 362.2165, -86.7007>, <16.6911, 362.954, -86.5404>, <16.3212, 362.4182, -88.5579> }
					triangle { <16.3212, 362.4182, -88.5579>, <15.1698, 356.5553, -88.2224>, <16.371, 362.2165, -86.7007> }
					triangle { <15.2989, 356.4518, -87.6954>, <16.371, 362.2165, -86.7007>, <15.1698, 356.5553, -88.2224> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-29.9519, 331.6715, -66.1745>, <-30.3231, 333.9907, -66.3358>, 0.2999 }
			cylinder { <-30.3231, 333.9907, -66.3358>, <-30.7608, 336.3011, -66.4504>, 0.2999 }
			cylinder { <-30.7608, 336.3011, -66.4504>, <-31.2644, 338.5999, -66.5181>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-31.2644, 338.5999, -66.5181>, <-33.4159, 339.4771, -66.8979>, 0.2999 }
			cylinder { <-33.4159, 339.4771, -66.8979>, <-35.5355, 340.4295, -67.2753>, 0.2999 }
			cylinder { <-35.5355, 340.4295, -67.2753>, <-37.6208, 341.456, -67.6498>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-37.6208, 341.456, -67.6498>, <-43.2068, 345.7585, -67.24>, 0.2999 }
				cylinder { <-43.2068, 345.7585, -67.24>, <-47.6418, 350.9135, -65.332>, 0.2999 }
				cylinder { <-47.6418, 350.9135, -65.332>, <-50.5438, 356.4769, -62.09026>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-50.5438, 356.4769, -62.09026>, <-50.3682, 357.2006, -61.7273>, <-51.04933, 358.5846, -60.9874> }
					triangle { <-50.3682, 357.2006, -61.7273>, <-51.08411, 359.4634, -60.5354>, <-51.04933, 358.5846, -60.9874> }
					triangle { <-51.08411, 359.4634, -60.5354>, <-51.6522, 359.3706, -60.5574>, <-51.04933, 358.5846, -60.9874> }
					triangle { <-51.04933, 358.5846, -60.9874>, <-51.6522, 359.3706, -60.5574>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-51.08411, 359.4634, -60.5354>, <-49.1059, 358.1887, -56.4849>, <-49.8466, 357.9316, -54.6128> }
					triangle { <-49.8466, 357.9316, -54.6128>, <-51.662, 357.0848, -53.8996>, <-51.648, 357.1995, -54.7469> }
					triangle { <-51.648, 357.1995, -54.7469>, <-51.08411, 359.4634, -60.5354>, <-49.8466, 357.9316, -54.6128> }
					triangle { <-51.08411, 359.4634, -60.5354>, <-51.648, 357.1995, -54.7469>, <-51.6522, 359.3706, -60.5574> }
					triangle { <-51.5871, 358.4124, -61.05134>, <-51.1749, 356.9424, -61.8232>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-51.5871, 358.4124, -61.05134>, <-52.1597, 359.1192, -60.6633>, <-51.1749, 356.9424, -61.8232> }
					triangle { <-51.5871, 358.4124, -61.05134>, <-51.6522, 359.3706, -60.5574>, <-52.1597, 359.1192, -60.6633> }
					triangle { <-50.5438, 356.4769, -62.09026>, <-51.6522, 359.3706, -60.5574>, <-51.5871, 358.4124, -61.05134> }
					triangle { <-53.5216, 356.7553, -55.04968>, <-53.7668, 356.6968, -57.03906>, <-52.1597, 359.1192, -60.6633> }
					triangle { <-51.648, 357.1995, -54.7469>, <-51.662, 357.0848, -53.8996>, <-53.5216, 356.7553, -55.04968> }
					triangle { <-53.5216, 356.7553, -55.04968>, <-52.1597, 359.1192, -60.6633>, <-51.648, 357.1995, -54.7469> }
					triangle { <-51.6522, 359.3706, -60.5574>, <-51.648, 357.1995, -54.7469>, <-52.1597, 359.1192, -60.6633> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-50.5438, 356.4769, -62.09026>, <-50.6613, 357.2964, -62.1201>, <-51.2447, 358.6485, -61.2492> }
					triangle { <-50.6613, 357.2964, -62.1201>, <-51.4748, 359.5912, -61.0592>, <-51.2447, 358.6485, -61.2492> }
					triangle { <-51.4748, 359.5912, -61.0592>, <-51.6522, 359.3706, -60.5574>, <-51.2447, 358.6485, -61.2492> }
					triangle { <-51.2447, 358.6485, -61.2492>, <-51.6522, 359.3706, -60.5574>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-51.4748, 359.5912, -61.0592>, <-47.1192, 361.3117, -60.9439>, <-45.943, 361.9789, -59.4302> }
					triangle { <-45.943, 361.9789, -59.4302>, <-45.6308, 361.2748, -57.4483>, <-46.2855, 360.8955, -57.8465> }
					triangle { <-46.2855, 360.8955, -57.8465>, <-51.4748, 359.5912, -61.0592>, <-45.943, 361.9789, -59.4302> }
					triangle { <-51.4748, 359.5912, -61.0592>, <-46.2855, 360.8955, -57.8465>, <-51.6522, 359.3706, -60.5574> }
					triangle { <-51.3917, 358.3486, -60.7894>, <-50.8819, 356.8466, -61.4304>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-51.3917, 358.3486, -60.7894>, <-51.7689, 358.9914, -60.1396>, <-50.8819, 356.8466, -61.4304> }
					triangle { <-51.3917, 358.3486, -60.7894>, <-51.6522, 359.3706, -60.5574>, <-51.7689, 358.9914, -60.1396> }
					triangle { <-50.5438, 356.4769, -62.09026>, <-51.6522, 359.3706, -60.5574>, <-51.3917, 358.3486, -60.7894> }
					triangle { <-46.9477, 359.9297, -56.2884>, <-48.3935, 358.7127, -56.9591>, <-51.7689, 358.9914, -60.1396> }
					triangle { <-46.2855, 360.8955, -57.8465>, <-45.6308, 361.2748, -57.4483>, <-46.9477, 359.9297, -56.2884> }
					triangle { <-46.9477, 359.9297, -56.2884>, <-51.7689, 358.9914, -60.1396>, <-46.2855, 360.8955, -57.8465> }
					triangle { <-51.6522, 359.3706, -60.5574>, <-46.2855, 360.8955, -57.8465>, <-51.7689, 358.9914, -60.1396> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-50.5438, 356.4769, -62.09026>, <-51.1057, 357.0835, -62.03958>, <-51.541, 358.5065, -61.1955> }
					triangle { <-51.1057, 357.0835, -62.03958>, <-52.06746, 359.3073, -60.9518>, <-51.541, 358.5065, -61.1955> }
					triangle { <-52.06746, 359.3073, -60.9518>, <-51.6522, 359.3706, -60.5574>, <-51.541, 358.5065, -61.1955> }
					triangle { <-51.541, 358.5065, -61.1955>, <-51.6522, 359.3706, -60.5574>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-52.06746, 359.3073, -60.9518>, <-51.3548, 361.7703, -64.8723>, <-50.2512, 363.4253, -65.2761> }
					triangle { <-50.2512, 363.4253, -65.2761>, <-48.3233, 364.0481, -64.6305>, <-48.623, 363.369, -64.206> }
					triangle { <-48.623, 363.369, -64.206>, <-52.06746, 359.3073, -60.9518>, <-50.2512, 363.4253, -65.2761> }
					triangle { <-52.06746, 359.3073, -60.9518>, <-48.623, 363.369, -64.206>, <-51.6522, 359.3706, -60.5574> }
					triangle { <-51.09546, 358.4905, -60.8431>, <-50.4374, 357.0595, -61.511>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-51.09546, 358.4905, -60.8431>, <-51.1763, 359.2753, -60.247>, <-50.4374, 357.0595, -61.511> }
					triangle { <-51.09546, 358.4905, -60.8431>, <-51.6522, 359.3706, -60.5574>, <-51.1763, 359.2753, -60.247> }
					triangle { <-50.5438, 356.4769, -62.09026>, <-51.6522, 359.3706, -60.5574>, <-51.09546, 358.4905, -60.8431> }
					triangle { <-47.2066, 363.3159, -62.8681>, <-47.4933, 361.6316, -61.8183>, <-51.1763, 359.2753, -60.247> }
					triangle { <-48.623, 363.369, -64.206>, <-48.3233, 364.0481, -64.6305>, <-47.2066, 363.3159, -62.8681> }
					triangle { <-47.2066, 363.3159, -62.8681>, <-51.1763, 359.2753, -60.247>, <-48.623, 363.369, -64.206> }
					triangle { <-51.6522, 359.3706, -60.5574>, <-48.623, 363.369, -64.206>, <-51.1763, 359.2753, -60.247> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-50.5438, 356.4769, -62.09026>, <-51.09154, 356.8541, -61.5962>, <-51.5315, 358.3536, -60.9> }
					triangle { <-51.09154, 356.8541, -61.5962>, <-52.04847, 359.0015, -60.3607>, <-51.5315, 358.3536, -60.9> }
					triangle { <-52.04847, 359.0015, -60.3607>, <-51.6522, 359.3706, -60.5574>, <-51.5315, 358.3536, -60.9> }
					triangle { <-51.5315, 358.3536, -60.9>, <-51.6522, 359.3706, -60.5574>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-52.04847, 359.0015, -60.3607>, <-55.9986, 358.9349, -62.8779>, <-56.8577, 360.2854, -64.1261> }
					triangle { <-56.8577, 360.2854, -64.1261>, <-56.0438, 361.5978, -65.5877>, <-55.452, 361.2246, -65.09618> }
					triangle { <-55.452, 361.2246, -65.09618>, <-52.04847, 359.0015, -60.3607>, <-56.8577, 360.2854, -64.1261> }
					triangle { <-52.04847, 359.0015, -60.3607>, <-55.452, 361.2246, -65.09618>, <-51.6522, 359.3706, -60.5574> }
					triangle { <-51.1049, 358.6434, -61.1387>, <-50.4516, 357.2889, -61.9543>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-51.1049, 358.6434, -61.1387>, <-51.1953, 359.5811, -60.8381>, <-50.4516, 357.2889, -61.9543> }
					triangle { <-51.1049, 358.6434, -61.1387>, <-51.6522, 359.3706, -60.5574>, <-51.1953, 359.5811, -60.8381> }
					triangle { <-50.5438, 356.4769, -62.09026>, <-51.6522, 359.3706, -60.5574>, <-51.1049, 358.6434, -61.1387> }
					triangle { <-53.9428, 362.2661, -65.7572>, <-52.3017, 361.4469, -64.9467>, <-51.1953, 359.5811, -60.8381> }
					triangle { <-55.452, 361.2246, -65.09618>, <-56.0438, 361.5978, -65.5877>, <-53.9428, 362.2661, -65.7572> }
					triangle { <-53.9428, 362.2661, -65.7572>, <-51.1953, 359.5811, -60.8381>, <-55.452, 361.2246, -65.09618> }
					triangle { <-51.6522, 359.3706, -60.5574>, <-55.452, 361.2246, -65.09618>, <-51.1953, 359.5811, -60.8381> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-50.5438, 356.4769, -62.09026>, <-50.6288, 356.9276, -61.4003>, <-51.223, 358.4026, -60.7694> }
					triangle { <-50.6288, 356.9276, -61.4003>, <-51.4315, 359.0994, -60.09953>, <-51.223, 358.4026, -60.7694> }
					triangle { <-51.4315, 359.0994, -60.09953>, <-51.6522, 359.3706, -60.5574>, <-51.223, 358.4026, -60.7694> }
					triangle { <-51.223, 358.4026, -60.7694>, <-51.6522, 359.3706, -60.5574>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-51.4315, 359.0994, -60.09953>, <-54.5878, 356.688, -57.6159>, <-56.6039, 356.8389, -57.4363> }
					triangle { <-56.6039, 356.8389, -57.4363>, <-58.1383, 357.2293, -58.8556>, <-57.3498, 357.3541, -59.1618> }
					triangle { <-57.3498, 357.3541, -59.1618>, <-51.4315, 359.0994, -60.09953>, <-56.6039, 356.8389, -57.4363> }
					triangle { <-51.4315, 359.0994, -60.09953>, <-57.3498, 357.3541, -59.1618>, <-51.6522, 359.3706, -60.5574> }
					triangle { <-51.4134, 358.5945, -61.2693>, <-50.9143, 357.2154, -62.1502>, <-50.5438, 356.4769, -62.09026> }
					triangle { <-51.4134, 358.5945, -61.2693>, <-51.8122, 359.4832, -61.09931>, <-50.9143, 357.2154, -62.1502> }
					triangle { <-51.4134, 358.5945, -61.2693>, <-51.6522, 359.3706, -60.5574>, <-51.8122, 359.4832, -61.09931> }
					triangle { <-50.5438, 356.4769, -62.09026>, <-51.6522, 359.3706, -60.5574>, <-51.4134, 358.5945, -61.2693> }
					triangle { <-57.9047, 358.1502, -60.8522>, <-56.2375, 358.351, -61.9483>, <-51.8122, 359.4832, -61.09931> }
					triangle { <-57.3498, 357.3541, -59.1618>, <-58.1383, 357.2293, -58.8556>, <-57.9047, 358.1502, -60.8522> }
					triangle { <-57.9047, 358.1502, -60.8522>, <-51.8122, 359.4832, -61.09931>, <-57.3498, 357.3541, -59.1618> }
					triangle { <-51.6522, 359.3706, -60.5574>, <-57.3498, 357.3541, -59.1618>, <-51.8122, 359.4832, -61.09931> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-37.6208, 341.456, -67.6498>, <-39.7225, 342.4255, -68.08059>, 0.2999 }
			cylinder { <-39.7225, 342.4255, -68.08059>, <-41.838, 343.3369, -68.567>, 0.2999 }
			cylinder { <-41.838, 343.3369, -68.567>, <-43.9648, 344.189, -69.1085>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-43.9648, 344.189, -69.1085>, <-49.6516, 346.4128, -72.6579>, 0.2999 }
				cylinder { <-49.6516, 346.4128, -72.6579>, <-54.1551, 348.1126, -77.8262>, 0.2999 }
				cylinder { <-54.1551, 348.1126, -77.8262>, <-57.08762, 349.142, -84.1684>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-57.08762, 349.142, -84.1684>, <-57.1396, 348.9354, -84.969>, <-57.9284, 349.2872, -86.4457> }
					triangle { <-57.1396, 348.9354, -84.969>, <-58.1597, 349.2185, -87.4047>, <-57.9284, 349.2872, -86.4457> }
					triangle { <-58.1597, 349.2185, -87.4047>, <-58.5229, 349.6458, -87.2728>, <-57.9284, 349.2872, -86.4457> }
					triangle { <-57.9284, 349.2872, -86.4457>, <-58.5229, 349.6458, -87.2728>, <-57.08762, 349.142, -84.1684> }
					triangle { <-58.1597, 349.2185, -87.4047>, <-54.07032, 350.6762, -89.1643>, <-53.5057, 352.3885, -90.09681> }
					triangle { <-53.5057, 352.3885, -90.09681>, <-53.9924, 354.4293, -89.7514>, <-54.4723, 353.8828, -89.3018> }
					triangle { <-54.4723, 353.8828, -89.3018>, <-58.1597, 349.2185, -87.4047>, <-53.5057, 352.3885, -90.09681> }
					triangle { <-58.1597, 349.2185, -87.4047>, <-54.4723, 353.8828, -89.3018>, <-58.5229, 349.6458, -87.2728> }
					triangle { <-58.2523, 349.7007, -86.2288>, <-57.6254, 349.5556, -84.6437>, <-57.08762, 349.142, -84.1684> }
					triangle { <-58.2523, 349.7007, -86.2288>, <-58.8075, 350.0456, -86.9709>, <-57.6254, 349.5556, -84.6437> }
					triangle { <-58.2523, 349.7007, -86.2288>, <-58.5229, 349.6458, -87.2728>, <-58.8075, 350.0456, -86.9709> }
					triangle { <-57.08762, 349.142, -84.1684>, <-58.5229, 349.6458, -87.2728>, <-58.2523, 349.7007, -86.2288> }
					triangle { <-55.719, 355.2142, -88.6148>, <-56.8774, 354.2601, -87.2847>, <-58.8075, 350.0456, -86.9709> }
					triangle { <-54.4723, 353.8828, -89.3018>, <-53.9924, 354.4293, -89.7514>, <-55.719, 355.2142, -88.6148> }
					triangle { <-55.719, 355.2142, -88.6148>, <-58.8075, 350.0456, -86.9709>, <-54.4723, 353.8828, -89.3018> }
					triangle { <-58.5229, 349.6458, -87.2728>, <-54.4723, 353.8828, -89.3018>, <-58.8075, 350.0456, -86.9709> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-57.08762, 349.142, -84.1684>, <-57.5933, 348.877, -84.7687>, <-58.2309, 349.2483, -86.3122> }
					triangle { <-57.5933, 348.877, -84.7687>, <-58.7646, 349.1406, -87.1376>, <-58.2309, 349.2483, -86.3122> }
					triangle { <-58.7646, 349.1406, -87.1376>, <-58.5229, 349.6458, -87.2728>, <-58.2309, 349.2483, -86.3122> }
					triangle { <-58.2309, 349.2483, -86.3122>, <-58.5229, 349.6458, -87.2728>, <-57.08762, 349.142, -84.1684> }
					triangle { <-58.7646, 349.1406, -87.1376>, <-56.5094, 345.4267, -88.8886>, <-55.2443, 345.2001, -90.4596> }
					triangle { <-55.2443, 345.2001, -90.4596>, <-53.663, 346.4104, -91.2052>, <-54.1364, 346.7969, -90.6072> }
					triangle { <-54.1364, 346.7969, -90.6072>, <-58.7646, 349.1406, -87.1376>, <-55.2443, 345.2001, -90.4596> }
					triangle { <-58.7646, 349.1406, -87.1376>, <-54.1364, 346.7969, -90.6072>, <-58.5229, 349.6458, -87.2728> }
					triangle { <-57.9499, 349.7397, -86.3624>, <-57.1718, 349.614, -84.844>, <-57.08762, 349.142, -84.1684> }
					triangle { <-57.9499, 349.7397, -86.3624>, <-58.2026, 350.1234, -87.238>, <-57.1718, 349.614, -84.844> }
					triangle { <-57.9499, 349.7397, -86.3624>, <-58.5229, 349.6458, -87.2728>, <-58.2026, 350.1234, -87.238> }
					triangle { <-57.08762, 349.142, -84.1684>, <-58.5229, 349.6458, -87.2728>, <-57.9499, 349.7397, -86.3624> }
					triangle { <-53.3241, 348.558, -90.8024>, <-54.07407, 349.6855, -89.3234>, <-58.2026, 350.1234, -87.238> }
					triangle { <-54.1364, 346.7969, -90.6072>, <-53.663, 346.4104, -91.2052>, <-53.3241, 348.558, -90.8024> }
					triangle { <-53.3241, 348.558, -90.8024>, <-58.2026, 350.1234, -87.238>, <-54.1364, 346.7969, -90.6072> }
					triangle { <-58.5229, 349.6458, -87.2728>, <-54.1364, 346.7969, -90.6072>, <-58.2026, 350.1234, -87.238> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-57.08762, 349.142, -84.1684>, <-57.7577, 349.3244, -84.6201>, <-58.3405, 349.5466, -86.2131> }
					triangle { <-57.7577, 349.3244, -84.6201>, <-58.9838, 349.7373, -86.9394>, <-58.3405, 349.5466, -86.2131> }
					triangle { <-58.9838, 349.7373, -86.9394>, <-58.5229, 349.6458, -87.2728>, <-58.3405, 349.5466, -86.2131> }
					triangle { <-58.3405, 349.5466, -86.2131>, <-58.5229, 349.6458, -87.2728>, <-57.08762, 349.142, -84.1684> }
					triangle { <-58.9838, 349.7373, -86.9394>, <-61.7124, 345.9685, -86.395>, <-61.9691, 344.2847, -87.4989> }
					triangle { <-61.9691, 344.2847, -87.4989>, <-60.5983, 343.041, -88.5455>, <-60.2535, 343.7732, -88.2697> }
					triangle { <-60.2535, 343.7732, -88.2697>, <-58.9838, 349.7373, -86.9394>, <-61.9691, 344.2847, -87.4989> }
					triangle { <-58.9838, 349.7373, -86.9394>, <-60.2535, 343.7732, -88.2697>, <-58.5229, 349.6458, -87.2728> }
					triangle { <-57.8403, 349.4414, -86.4614>, <-57.00741, 349.1666, -84.9926>, <-57.08762, 349.142, -84.1684> }
					triangle { <-57.8403, 349.4414, -86.4614>, <-57.9834, 349.5268, -87.4361>, <-57.00741, 349.1666, -84.9926> }
					triangle { <-57.8403, 349.4414, -86.4614>, <-58.5229, 349.6458, -87.2728>, <-57.9834, 349.5268, -87.4361> }
					triangle { <-57.08762, 349.142, -84.1684>, <-58.5229, 349.6458, -87.2728>, <-57.8403, 349.4414, -86.4614> }
					triangle { <-58.5511, 343.5655, -89.196>, <-57.3774, 345.0565, -88.5474>, <-57.9834, 349.5268, -87.4361> }
					triangle { <-60.2535, 343.7732, -88.2697>, <-60.5983, 343.041, -88.5455>, <-58.5511, 343.5655, -89.196> }
					triangle { <-58.5511, 343.5655, -89.196>, <-57.9834, 349.5268, -87.4361>, <-60.2535, 343.7732, -88.2697> }
					triangle { <-58.5229, 349.6458, -87.2728>, <-60.2535, 343.7732, -88.2697>, <-57.9834, 349.5268, -87.4361> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-57.08762, 349.142, -84.1684>, <-57.4071, 349.6636, -84.7271>, <-58.1068, 349.7727, -86.2844> }
					triangle { <-57.4071, 349.6636, -84.7271>, <-58.5164, 350.1895, -87.08219>, <-58.1068, 349.7727, -86.2844> }
					triangle { <-58.5164, 350.1895, -87.08219>, <-58.5229, 349.6458, -87.2728>, <-58.1068, 349.7727, -86.2844> }
					triangle { <-58.1068, 349.7727, -86.2844>, <-58.5229, 349.6458, -87.2728>, <-57.08762, 349.142, -84.1684> }
					triangle { <-58.5164, 350.1895, -87.08219>, <-62.5374, 351.5579, -85.1063>, <-64.4494, 350.8987, -85.2786> }
					triangle { <-64.4494, 350.8987, -85.2786>, <-65.2786, 348.946, -85.4231>, <-64.427, 348.9621, -85.4978> }
					triangle { <-64.427, 348.9621, -85.4978>, <-58.5164, 350.1895, -87.08219>, <-64.4494, 350.8987, -85.2786> }
					triangle { <-58.5164, 350.1895, -87.08219>, <-64.427, 348.9621, -85.4978>, <-58.5229, 349.6458, -87.2728> }
					triangle { <-58.07401, 349.2153, -86.3901>, <-57.3579, 348.8274, -84.8856>, <-57.08762, 349.142, -84.1684> }
					triangle { <-58.07401, 349.2153, -86.3901>, <-58.4508, 349.0746, -87.2934>, <-57.3579, 348.8274, -84.8856> }
					triangle { <-58.07401, 349.2153, -86.3901>, <-58.5229, 349.6458, -87.2728>, <-58.4508, 349.0746, -87.2934> }
					triangle { <-57.08762, 349.142, -84.1684>, <-58.5229, 349.6458, -87.2728>, <-58.07401, 349.2153, -86.3901> }
					triangle { <-64.2252, 347.0897, -86.00049>, <-62.2531, 346.727, -86.02191>, <-58.4508, 349.0746, -87.2934> }
					triangle { <-64.427, 348.9621, -85.4978>, <-65.2786, 348.946, -85.4231>, <-64.2252, 347.0897, -86.00049> }
					triangle { <-64.2252, 347.0897, -86.00049>, <-58.4508, 349.0746, -87.2934>, <-64.427, 348.9621, -85.4978> }
					triangle { <-58.5229, 349.6458, -87.2728>, <-64.427, 348.9621, -85.4978>, <-58.4508, 349.0746, -87.2934> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-57.08762, 349.142, -84.1684>, <-57.01939, 349.4195, -84.946>, <-57.8483, 349.61, -86.4304> }
					triangle { <-57.01939, 349.4195, -84.946>, <-57.9994, 349.864, -87.374>, <-57.8483, 349.61, -86.4304> }
					triangle { <-57.9994, 349.864, -87.374>, <-58.5229, 349.6458, -87.2728>, <-57.8483, 349.61, -86.4304> }
					triangle { <-57.8483, 349.61, -86.4304>, <-58.5229, 349.6458, -87.2728>, <-57.08762, 349.142, -84.1684> }
					triangle { <-57.9994, 349.864, -87.374>, <-57.743, 354.5114, -86.8437>, <-59.1397, 355.9827, -86.9084> }
					triangle { <-59.1397, 355.9827, -86.9084>, <-61.1343, 356.0907, -86.1796>, <-60.8001, 355.3044, -86.1453> }
					triangle { <-60.8001, 355.3044, -86.1453>, <-57.9994, 349.864, -87.374>, <-59.1397, 355.9827, -86.9084> }
					triangle { <-57.9994, 349.864, -87.374>, <-60.8001, 355.3044, -86.1453>, <-58.5229, 349.6458, -87.2728> }
					triangle { <-58.3325, 349.378, -86.2441>, <-57.7457, 349.0715, -84.6667>, <-57.08762, 349.142, -84.1684> }
					triangle { <-58.3325, 349.378, -86.2441>, <-58.9678, 349.4001, -87.00159>, <-57.7457, 349.0715, -84.6667> }
					triangle { <-58.3325, 349.378, -86.2441>, <-58.5229, 349.6458, -87.2728>, <-58.9678, 349.4001, -87.00159> }
					triangle { <-57.08762, 349.142, -84.1684>, <-58.5229, 349.6458, -87.2728>, <-58.3325, 349.378, -86.2441> }
					triangle { <-62.4485, 354.3976, -85.6358>, <-61.9395, 352.501, -85.2297>, <-58.9678, 349.4001, -87.00159> }
					triangle { <-60.8001, 355.3044, -86.1453>, <-61.1343, 356.0907, -86.1796>, <-62.4485, 354.3976, -85.6358> }
					triangle { <-62.4485, 354.3976, -85.6358>, <-58.9678, 349.4001, -87.00159>, <-60.8001, 355.3044, -86.1453> }
					triangle { <-58.5229, 349.6458, -87.2728>, <-60.8001, 355.3044, -86.1453>, <-58.9678, 349.4001, -87.00159> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-43.9648, 344.189, -69.1085>, <-46.1055, 345.0531, -69.5705>, 0.2999 }
			cylinder { <-46.1055, 345.0531, -69.5705>, <-48.2574, 345.9283, -69.9522>, 0.2999 }
			cylinder { <-48.2574, 345.9283, -69.9522>, <-50.4181, 346.8133, -70.2534>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-50.4181, 346.8133, -70.2534>, <-57.3133, 348.1869, -69.5809>, 0.2999 }
				cylinder { <-57.3133, 348.1869, -69.5809>, <-64.02786, 348.1608, -67.3906>, 0.2999 }
				cylinder { <-64.02786, 348.1608, -67.3906>, <-69.9834, 346.7373, -63.871>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-69.9834, 346.7373, -63.871>, <-70.4244, 346.4493, -63.2316>, <-72.00905, 346.1595, -62.6557> }
					triangle { <-70.4244, 346.4493, -63.2316>, <-72.7253, 345.8735, -62.03696>, <-72.00905, 346.1595, -62.6557> }
					triangle { <-72.7253, 345.8735, -62.03696>, <-73.06658, 346.0505, -62.4661>, <-72.00905, 346.1595, -62.6557> }
					triangle { <-72.00905, 346.1595, -62.6557>, <-73.06658, 346.0505, -62.4661>, <-69.9834, 346.7373, -63.871> }
					triangle { <-72.7253, 345.8735, -62.03696>, <-71.8327, 341.2751, -62.09304>, <-72.8086, 339.6939, -62.91> }
					triangle { <-72.8086, 339.6939, -62.91>, <-73.811, 339.4401, -64.7679>, <-73.5979, 340.2515, -64.6027> }
					triangle { <-73.5979, 340.2515, -64.6027>, <-72.7253, 345.8735, -62.03696>, <-72.8086, 339.6939, -62.91> }
					triangle { <-72.7253, 345.8735, -62.03696>, <-73.5979, 340.2515, -64.6027>, <-73.06658, 346.0505, -62.4661> }
					triangle { <-72.2657, 346.3554, -63.1233>, <-70.8094, 346.743, -63.9331>, <-69.9834, 346.7373, -63.871> }
					triangle { <-72.2657, 346.3554, -63.1233>, <-73.2388, 346.2651, -62.9722>, <-70.8094, 346.743, -63.9331> }
					triangle { <-72.2657, 346.3554, -63.1233>, <-73.06658, 346.0505, -62.4661>, <-73.2388, 346.2651, -62.9722> }
					triangle { <-69.9834, 346.7373, -63.871>, <-73.06658, 346.0505, -62.4661>, <-72.2657, 346.3554, -63.1233> }
					triangle { <-74.5629, 341.0321, -66.1056>, <-74.05769, 342.9723, -66.146>, <-73.2388, 346.2651, -62.9722> }
					triangle { <-73.5979, 340.2515, -64.6027>, <-73.811, 339.4401, -64.7679>, <-74.5629, 341.0321, -66.1056> }
					triangle { <-74.5629, 341.0321, -66.1056>, <-73.2388, 346.2651, -62.9722>, <-73.5979, 340.2515, -64.6027> }
					triangle { <-73.06658, 346.0505, -62.4661>, <-73.5979, 340.2515, -64.6027>, <-73.2388, 346.2651, -62.9722> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-69.9834, 346.7373, -63.871>, <-70.566, 346.9214, -63.3116>, <-72.1034, 346.4743, -62.709> }
					triangle { <-70.566, 346.9214, -63.3116>, <-72.9142, 346.5029, -62.1436>, <-72.1034, 346.4743, -62.709> }
					triangle { <-72.9142, 346.5029, -62.1436>, <-73.06658, 346.0505, -62.4661>, <-72.1034, 346.4743, -62.709> }
					triangle { <-72.1034, 346.4743, -62.709>, <-73.06658, 346.0505, -62.4661>, <-69.9834, 346.7373, -63.871> }
					triangle { <-72.9142, 346.5029, -62.1436>, <-70.9072, 345.3446, -58.07243>, <-70.9708, 343.6639, -56.936> }
					triangle { <-70.9708, 343.6639, -56.936>, <-70.9527, 341.5983, -57.4401>, <-71.05626, 342.1137, -58.1145> }
					triangle { <-71.05626, 342.1137, -58.1145>, <-72.9142, 346.5029, -62.1436>, <-70.9708, 343.6639, -56.936> }
					triangle { <-72.9142, 346.5029, -62.1436>, <-71.05626, 342.1137, -58.1145>, <-73.06658, 346.0505, -62.4661> }
					triangle { <-72.1713, 346.0406, -63.07>, <-70.6678, 346.2709, -63.853>, <-69.9834, 346.7373, -63.871> }
					triangle { <-72.1713, 346.0406, -63.07>, <-73.04999, 345.6356, -62.8655>, <-70.6678, 346.2709, -63.853> }
					triangle { <-72.1713, 346.0406, -63.07>, <-73.06658, 346.0505, -62.4661>, <-73.04999, 345.6356, -62.8655> }
					triangle { <-69.9834, 346.7373, -63.871>, <-73.06658, 346.0505, -62.4661>, <-72.1713, 346.0406, -63.07> }
					triangle { <-71.4346, 340.7006, -59.4025>, <-71.4954, 341.5862, -61.2006>, <-73.04999, 345.6356, -62.8655> }
					triangle { <-71.05626, 342.1137, -58.1145>, <-70.9527, 341.5983, -57.4401>, <-71.4346, 340.7006, -59.4025> }
					triangle { <-71.4346, 340.7006, -59.4025>, <-73.04999, 345.6356, -62.8655>, <-71.05626, 342.1137, -58.1145> }
					triangle { <-73.06658, 346.0505, -62.4661>, <-71.05626, 342.1137, -58.1145>, <-73.04999, 345.6356, -62.8655> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-69.9834, 346.7373, -63.871>, <-70.7775, 346.9471, -63.7632>, <-72.2444, 346.4914, -63.01012> }
					triangle { <-70.7775, 346.9471, -63.7632>, <-73.1962, 346.5372, -62.7458>, <-72.2444, 346.4914, -63.01012> }
					triangle { <-73.1962, 346.5372, -62.7458>, <-73.06658, 346.0505, -62.4661>, <-72.2444, 346.4914, -63.01012> }
					triangle { <-72.2444, 346.4914, -63.01012>, <-73.06658, 346.0505, -62.4661>, <-69.9834, 346.7373, -63.871> }
					triangle { <-73.1962, 346.5372, -62.7458>, <-72.9456, 350.383, -60.08275>, <-73.05325, 350.6773, -58.07735> }
					triangle { <-73.05325, 350.6773, -58.07735>, <-72.2713, 349.5836, -56.43>, <-72.2015, 349.1731, -57.1767> }
					triangle { <-72.2015, 349.1731, -57.1767>, <-73.1962, 346.5372, -62.7458>, <-73.05325, 350.6773, -58.07735> }
					triangle { <-73.1962, 346.5372, -62.7458>, <-72.2015, 349.1731, -57.1767>, <-73.06658, 346.0505, -62.4661> }
					triangle { <-72.03034, 346.0235, -62.7689>, <-70.4563, 346.2453, -63.4014>, <-69.9834, 346.7373, -63.871> }
					triangle { <-72.03034, 346.0235, -62.7689>, <-72.7679, 345.6014, -62.2634>, <-70.4563, 346.2453, -63.4014> }
					triangle { <-72.03034, 346.0235, -62.7689>, <-73.06658, 346.0505, -62.4661>, <-72.7679, 345.6014, -62.2634> }
					triangle { <-69.9834, 346.7373, -63.871>, <-73.06658, 346.0505, -62.4661>, <-72.03034, 346.0235, -62.7689> }
					triangle { <-71.5899, 347.4801, -56.4291>, <-71.0898, 346.328, -57.9923>, <-72.7679, 345.6014, -62.2634> }
					triangle { <-72.2015, 349.1731, -57.1767>, <-72.2713, 349.5836, -56.43>, <-71.5899, 347.4801, -56.4291> }
					triangle { <-71.5899, 347.4801, -56.4291>, <-72.7679, 345.6014, -62.2634>, <-72.2015, 349.1731, -57.1767> }
					triangle { <-73.06658, 346.0505, -62.4661>, <-72.2015, 349.1731, -57.1767>, <-72.7679, 345.6014, -62.2634> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-69.9834, 346.7373, -63.871>, <-70.7686, 346.4911, -63.9665>, <-72.2385, 346.1874, -63.1456> }
					triangle { <-70.7686, 346.4911, -63.9665>, <-73.1843, 345.9292, -63.01688>, <-72.2385, 346.1874, -63.1456> }
					triangle { <-73.1843, 345.9292, -63.01688>, <-73.06658, 346.0505, -62.4661>, <-72.2385, 346.1874, -63.1456> }
					triangle { <-72.2385, 346.1874, -63.1456>, <-73.06658, 346.0505, -62.4661>, <-69.9834, 346.7373, -63.871> }
					triangle { <-73.1843, 345.9292, -63.01688>, <-75.1501, 349.4745, -65.3645>, <-76.1975, 351.1073, -64.7673> }
					triangle { <-76.1975, 351.1073, -64.7673>, <-75.9569, 352.4351, -63.124>, <-75.4618, 351.7396, -63.07673> }
					triangle { <-75.4618, 351.7396, -63.07673>, <-73.1843, 345.9292, -63.01688>, <-76.1975, 351.1073, -64.7673> }
					triangle { <-73.1843, 345.9292, -63.01688>, <-75.4618, 351.7396, -63.07673>, <-73.06658, 346.0505, -62.4661> }
					triangle { <-72.0363, 346.3275, -62.6333>, <-70.4652, 346.7013, -63.1981>, <-69.9834, 346.7373, -63.871> }
					triangle { <-72.0363, 346.3275, -62.6333>, <-72.7798, 346.2094, -61.9923>, <-70.4652, 346.7013, -63.1981> }
					triangle { <-72.0363, 346.3275, -62.6333>, <-73.06658, 346.0505, -62.4661>, <-72.7798, 346.2094, -61.9923> }
					triangle { <-69.9834, 346.7373, -63.871>, <-73.06658, 346.0505, -62.4661>, <-72.0363, 346.3275, -62.6333> }
					triangle { <-74.8156, 352.0648, -61.2667>, <-73.3975, 350.6888, -60.9248>, <-72.7798, 346.2094, -61.9923> }
					triangle { <-75.4618, 351.7396, -63.07673>, <-75.9569, 352.4351, -63.124>, <-74.8156, 352.0648, -61.2667> }
					triangle { <-74.8156, 352.0648, -61.2667>, <-72.7798, 346.2094, -61.9923>, <-75.4618, 351.7396, -63.07673> }
					triangle { <-73.06658, 346.0505, -62.4661>, <-75.4618, 351.7396, -63.07673>, <-72.7798, 346.2094, -61.9923> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-69.9834, 346.7373, -63.871>, <-70.547, 346.1788, -63.633>, <-72.09082, 345.9792, -62.9233> }
					triangle { <-70.547, 346.1788, -63.633>, <-72.8889, 345.5128, -62.5721>, <-72.09082, 345.9792, -62.9233> }
					triangle { <-72.8889, 345.5128, -62.5721>, <-73.06658, 346.0505, -62.4661>, <-72.09082, 345.9792, -62.9233> }
					triangle { <-72.09082, 345.9792, -62.9233>, <-73.06658, 346.0505, -62.4661>, <-69.9834, 346.7373, -63.871> }
					triangle { <-72.8889, 345.5128, -62.5721>, <-74.4519, 343.7605, -66.6257>, <-76.04404, 344.2167, -67.7991> }
					triangle { <-76.04404, 344.2167, -67.7991>, <-76.9229, 346.0714, -68.3549>, <-76.3378, 346.1425, -67.7354> }
					triangle { <-76.3378, 346.1425, -67.7354>, <-72.8889, 345.5128, -62.5721>, <-76.04404, 344.2167, -67.7991> }
					triangle { <-72.8889, 345.5128, -62.5721>, <-76.3378, 346.1425, -67.7354>, <-73.06658, 346.0505, -62.4661> }
					triangle { <-72.184, 346.5357, -62.8557>, <-70.6868, 347.0135, -63.5316>, <-69.9834, 346.7373, -63.871> }
					triangle { <-72.184, 346.5357, -62.8557>, <-73.07529, 346.6258, -62.437>, <-70.6868, 347.0135, -63.5316> }
					triangle { <-72.184, 346.5357, -62.8557>, <-73.06658, 346.0505, -62.4661>, <-73.07529, 346.6258, -62.437> }
					triangle { <-69.9834, 346.7373, -63.871>, <-73.06658, 346.0505, -62.4661>, <-72.184, 346.5357, -62.8557> }
					triangle { <-76.6807, 348.0195, -67.3374>, <-75.2595, 348.5836, -66.04016>, <-73.07529, 346.6258, -62.437> }
					triangle { <-76.3378, 346.1425, -67.7354>, <-76.9229, 346.0714, -68.3549>, <-76.6807, 348.0195, -67.3374> }
					triangle { <-76.6807, 348.0195, -67.3374>, <-73.07529, 346.6258, -62.437>, <-76.3378, 346.1425, -67.7354> }
					triangle { <-73.06658, 346.0505, -62.4661>, <-76.3378, 346.1425, -67.7354>, <-73.07529, 346.6258, -62.437> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-50.4181, 346.8133, -70.2534>, <-52.5508, 347.7413, -70.6181>, 0.2999 }
			cylinder { <-52.5508, 347.7413, -70.6181>, <-54.6529, 348.7112, -71.04597>, 0.2999 }
			cylinder { <-54.6529, 348.7112, -71.04597>, <-56.7218, 349.7218, -71.5364>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-56.7218, 349.7218, -71.5364>, <-61.7253, 354.4342, -73.1618>, 0.2999 }
				cylinder { <-61.7253, 354.4342, -73.1618>, <-65.09439, 360.4212, -74.8014>, 0.2999 }
				cylinder { <-65.09439, 360.4212, -74.8014>, <-66.5389, 367.1671, -76.3139>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-66.5389, 367.1671, -76.3139>, <-66.2888, 367.8965, -76.6167>, <-66.7693, 369.508, -76.9316> }
					triangle { <-66.2888, 367.8965, -76.6167>, <-66.6994, 370.4466, -77.2349>, <-66.7693, 369.508, -76.9316> }
					triangle { <-66.6994, 370.4466, -77.2349>, <-67.246, 370.4691, -77.05434>, <-66.7693, 369.508, -76.9316> }
					triangle { <-66.7693, 369.508, -76.9316>, <-67.246, 370.4691, -77.05434>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-66.6994, 370.4466, -77.2349>, <-63.5876, 371.9239, -74.06021>, <-63.7425, 373.1451, -72.4463> }
					triangle { <-63.7425, 373.1451, -72.4463>, <-65.2433, 373.3564, -70.9549>, <-65.4803, 372.8612, -71.6104> }
					triangle { <-65.4803, 372.8612, -71.6104>, <-66.6994, 370.4466, -77.2349>, <-63.7425, 373.1451, -72.4463> }
					triangle { <-66.6994, 370.4466, -77.2349>, <-65.4803, 372.8612, -71.6104>, <-67.246, 370.4691, -77.05434> }
					triangle { <-67.2966, 369.4401, -76.7308>, <-67.07973, 367.7947, -76.3154>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-67.2966, 369.4401, -76.7308>, <-67.7539, 370.3108, -76.8332>, <-67.07973, 367.7947, -76.3154> }
					triangle { <-67.2966, 369.4401, -76.7308>, <-67.246, 370.4691, -77.05434>, <-67.7539, 370.3108, -76.8332> }
					triangle { <-66.5389, 367.1671, -76.3139>, <-67.246, 370.4691, -77.05434>, <-67.2966, 369.4401, -76.7308> }
					triangle { <-67.3454, 372.6812, -71.07387>, <-68.1571, 371.3357, -72.3195>, <-67.7539, 370.3108, -76.8332> }
					triangle { <-65.4803, 372.8612, -71.6104>, <-65.2433, 373.3564, -70.9549>, <-67.3454, 372.6812, -71.07387> }
					triangle { <-67.3454, 372.6812, -71.07387>, <-67.7539, 370.3108, -76.8332>, <-65.4803, 372.8612, -71.6104> }
					triangle { <-67.246, 370.4691, -77.05434>, <-65.4803, 372.8612, -71.6104>, <-67.7539, 370.3108, -76.8332> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-66.5389, 367.1671, -76.3139>, <-66.6865, 367.752, -76.8819>, <-67.03447, 369.4116, -77.1084> }
					triangle { <-66.6865, 367.752, -76.8819>, <-67.2296, 370.2538, -77.5884>, <-67.03447, 369.4116, -77.1084> }
					triangle { <-67.2296, 370.2538, -77.5884>, <-67.246, 370.4691, -77.05434>, <-67.03447, 369.4116, -77.1084> }
					triangle { <-67.03447, 369.4116, -77.1084>, <-67.246, 370.4691, -77.05434>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-67.2296, 370.2538, -77.5884>, <-63.08717, 370.763, -79.7156>, <-61.5434, 372.0498, -79.4313> }
					triangle { <-61.5434, 372.0498, -79.4313>, <-60.6451, 372.8351, -77.6713>, <-61.3748, 372.4144, -77.524> }
					triangle { <-61.3748, 372.4144, -77.524>, <-67.2296, 370.2538, -77.5884>, <-61.5434, 372.0498, -79.4313> }
					triangle { <-67.2296, 370.2538, -77.5884>, <-61.3748, 372.4144, -77.524>, <-67.246, 370.4691, -77.05434> }
					triangle { <-67.03151, 369.5365, -76.554>, <-66.682, 367.9393, -76.05033>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-67.03151, 369.5365, -76.554>, <-67.2237, 370.5036, -76.4796>, <-66.682, 367.9393, -76.05033> }
					triangle { <-67.03151, 369.5365, -76.554>, <-67.246, 370.4691, -77.05434>, <-67.2237, 370.5036, -76.4796> }
					triangle { <-66.5389, 367.1671, -76.3139>, <-67.246, 370.4691, -77.05434>, <-67.03151, 369.5365, -76.554> }
					triangle { <-61.5231, 372.9035, -75.6431>, <-63.06152, 371.8458, -74.911>, <-67.2237, 370.5036, -76.4796> }
					triangle { <-61.3748, 372.4144, -77.524>, <-60.6451, 372.8351, -77.6713>, <-61.5231, 372.9035, -75.6431> }
					triangle { <-61.5231, 372.9035, -75.6431>, <-67.2237, 370.5036, -76.4796>, <-61.3748, 372.4144, -77.524> }
					triangle { <-67.246, 370.4691, -77.05434>, <-61.3748, 372.4144, -77.524>, <-67.2237, 370.5036, -76.4796> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-66.5389, 367.1671, -76.3139>, <-67.08112, 367.736, -76.5763>, <-67.2975, 369.4009, -76.9046> }
					triangle { <-67.08112, 367.736, -76.5763>, <-67.7558, 370.2324, -77.181>, <-67.2975, 369.4009, -76.9046> }
					triangle { <-67.7558, 370.2324, -77.181>, <-67.246, 370.4691, -77.05434>, <-67.2975, 369.4009, -76.9046> }
					triangle { <-67.2975, 369.4009, -76.9046>, <-67.246, 370.4691, -77.05434>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-67.7558, 370.2324, -77.181>, <-68.2954, 369.1988, -81.7181>, <-67.4113, 369.9025, -83.4042> }
					triangle { <-67.4113, 369.9025, -83.4042>, <-65.4002, 370.4322, -83.8471>, <-65.5412, 370.2909, -83.01568> }
					triangle { <-65.5412, 370.2909, -83.01568>, <-67.7558, 370.2324, -77.181>, <-67.4113, 369.9025, -83.4042> }
					triangle { <-67.7558, 370.2324, -77.181>, <-65.5412, 370.2909, -83.01568>, <-67.246, 370.4691, -77.05434> }
					triangle { <-66.7684, 369.5471, -76.7577>, <-66.2874, 367.9553, -76.3559>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-66.7684, 369.5471, -76.7577>, <-66.6975, 370.5249, -76.8871>, <-66.2874, 367.9553, -76.3559> }
					triangle { <-66.7684, 369.5471, -76.7577>, <-67.246, 370.4691, -77.05434>, <-66.6975, 370.5249, -76.8871> }
					triangle { <-66.5389, 367.1671, -76.3139>, <-67.246, 370.4691, -77.05434>, <-66.7684, 369.5471, -76.7577> }
					triangle { <-63.7956, 370.9019, -82.4>, <-63.7097, 370.4663, -80.4445>, <-66.6975, 370.5249, -76.8871> }
					triangle { <-65.5412, 370.2909, -83.01568>, <-65.4002, 370.4322, -83.8471>, <-63.7956, 370.9019, -82.4> }
					triangle { <-63.7956, 370.9019, -82.4>, <-66.6975, 370.5249, -76.8871>, <-65.5412, 370.2909, -83.01568> }
					triangle { <-67.246, 370.4691, -77.05434>, <-65.5412, 370.2909, -83.01568>, <-66.6975, 370.5249, -76.8871> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-66.5389, 367.1671, -76.3139>, <-66.931, 367.8705, -76.1194>, <-67.1974, 369.4906, -76.6001> }
					triangle { <-66.931, 367.8705, -76.1194>, <-67.5557, 370.4119, -76.5718>, <-67.1974, 369.4906, -76.6001> }
					triangle { <-67.5557, 370.4119, -76.5718>, <-67.246, 370.4691, -77.05434>, <-67.1974, 369.4906, -76.6001> }
					triangle { <-67.1974, 369.4906, -76.6001>, <-67.246, 370.4691, -77.05434>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-67.5557, 370.4119, -76.5718>, <-72.06332, 369.3783, -77.3188>, <-73.2917, 369.6506, -78.9115> }
					triangle { <-73.2917, 369.6506, -78.9115>, <-72.9814, 369.4459, -81.00517>, <-72.2604, 369.4055, -80.5472> }
					triangle { <-72.2604, 369.4055, -80.5472>, <-67.5557, 370.4119, -76.5718>, <-73.2917, 369.6506, -78.9115> }
					triangle { <-67.5557, 370.4119, -76.5718>, <-72.2604, 369.4055, -80.5472>, <-67.246, 370.4691, -77.05434> }
					triangle { <-66.8684, 369.4574, -77.06232>, <-66.4375, 367.8208, -76.8127>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-66.8684, 369.4574, -77.06232>, <-66.8977, 370.3455, -77.4962>, <-66.4375, 367.8208, -76.8127> }
					triangle { <-66.8684, 369.4574, -77.06232>, <-67.246, 370.4691, -77.05434>, <-66.8977, 370.3455, -77.4962> }
					triangle { <-66.5389, 367.1671, -76.3139>, <-67.246, 370.4691, -77.05434>, <-66.8684, 369.4574, -77.06232> }
					triangle { <-71.04365, 369.4239, -82.06983>, <-69.212, 369.0907, -81.3244>, <-66.8977, 370.3455, -77.4962> }
					triangle { <-72.2604, 369.4055, -80.5472>, <-72.9814, 369.4459, -81.00517>, <-71.04365, 369.4239, -82.06983> }
					triangle { <-71.04365, 369.4239, -82.06983>, <-66.8977, 370.3455, -77.4962>, <-72.2604, 369.4055, -80.5472> }
					triangle { <-67.246, 370.4691, -77.05434>, <-72.2604, 369.4055, -80.5472>, <-66.8977, 370.3455, -77.4962> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-66.5389, 367.1671, -76.3139>, <-66.4339, 367.9713, -76.1448>, <-66.8661, 369.5578, -76.617> }
					triangle { <-66.4339, 367.9713, -76.1448>, <-66.8929, 370.5462, -76.6056>, <-66.8661, 369.5578, -76.617> }
					triangle { <-66.8929, 370.5462, -76.6056>, <-67.246, 370.4691, -77.05434>, <-66.8661, 369.5578, -76.617> }
					triangle { <-66.8661, 369.5578, -76.617>, <-67.246, 370.4691, -77.05434>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-66.8929, 370.5462, -76.6056>, <-69.1097, 371.0879, -72.5145>, <-70.99, 371.6848, -72.03698> }
					triangle { <-70.99, 371.6848, -72.03698>, <-72.883, 371.2805, -72.917>, <-72.2222, 371.018, -73.392> }
					triangle { <-72.2222, 371.018, -73.392>, <-66.8929, 370.5462, -76.6056>, <-70.99, 371.6848, -72.03698> }
					triangle { <-66.8929, 370.5462, -76.6056>, <-72.2222, 371.018, -73.392>, <-67.246, 370.4691, -77.05434> }
					triangle { <-67.1998, 369.3903, -77.04541>, <-66.9345, 367.72, -76.7873>, <-66.5389, 367.1671, -76.3139> }
					triangle { <-67.1998, 369.3903, -77.04541>, <-67.5604, 370.2112, -77.4624>, <-66.9345, 367.72, -76.7873> }
					triangle { <-67.1998, 369.3903, -77.04541>, <-67.246, 370.4691, -77.05434>, <-67.5604, 370.2112, -77.4624> }
					triangle { <-66.5389, 367.1671, -76.3139>, <-67.246, 370.4691, -77.05434>, <-67.1998, 369.3903, -77.04541> }
					triangle { <-73.2706, 370.5401, -74.9642>, <-72.00224, 369.6361, -76.2271>, <-67.5604, 370.2112, -77.4624> }
					triangle { <-72.2222, 371.018, -73.392>, <-72.883, 371.2805, -72.917>, <-73.2706, 370.5401, -74.9642> }
					triangle { <-73.2706, 370.5401, -74.9642>, <-67.5604, 370.2112, -77.4624>, <-72.2222, 371.018, -73.392> }
					triangle { <-67.246, 370.4691, -77.05434>, <-72.2222, 371.018, -73.392>, <-67.5604, 370.2112, -77.4624> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-56.7218, 349.7218, -71.5364>, <-58.8274, 350.6606, -72.01401>, 0.2999 }
			cylinder { <-58.8274, 350.6606, -72.01401>, <-60.9669, 351.5262, -72.4782>, 0.2999 }
			cylinder { <-60.9669, 351.5262, -72.4782>, <-63.1379, 352.3177, -72.9285>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-63.1379, 352.3177, -72.9285>, <-69.7367, 352.932, -75.37>, 0.2999 }
				cylinder { <-69.7367, 352.932, -75.37>, <-75.8531, 351.7329, -78.692>, 0.2999 }
				cylinder { <-75.8531, 351.7329, -78.692>, <-80.9602, 348.8238, -82.6083>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-80.9602, 348.8238, -82.6083>, <-81.3139, 348.2075, -82.9631>, <-82.5666, 347.7638, -83.9246> }
					triangle { <-81.3139, 348.2075, -82.9631>, <-83.1366, 347.1945, -84.4244>, <-82.5666, 347.7638, -83.9246> }
					triangle { <-83.1366, 347.1945, -84.4244>, <-83.4005, 347.668, -84.5307>, <-82.5666, 347.7638, -83.9246> }
					triangle { <-82.5666, 347.7638, -83.9246>, <-83.4005, 347.668, -84.5307>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-83.1366, 347.1945, -84.4244>, <-80.1927, 345.998, -87.5986>, <-80.03046, 346.4489, -89.4848> }
					triangle { <-80.03046, 346.4489, -89.4848>, <-80.3015, 348.1941, -90.5031>, <-80.5588, 348.2252, -89.7254> }
					triangle { <-80.5588, 348.2252, -89.7254>, <-83.1366, 347.1945, -84.4244>, <-80.03046, 346.4489, -89.4848> }
					triangle { <-83.1366, 347.1945, -84.4244>, <-80.5588, 348.2252, -89.7254>, <-83.4005, 347.668, -84.5307> }
					triangle { <-82.7636, 348.2689, -83.9782>, <-81.6094, 348.9652, -83.04354>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-82.7636, 348.2689, -83.9782>, <-83.5307, 348.2049, -84.5316>, <-81.6094, 348.9652, -83.04354> }
					triangle { <-82.7636, 348.2689, -83.9782>, <-83.4005, 347.668, -84.5307>, <-83.5307, 348.2049, -84.5316> }
					triangle { <-80.9602, 348.8238, -82.6083>, <-83.4005, 347.668, -84.5307>, <-82.7636, 348.2689, -83.9782> }
					triangle { <-81.3768, 349.9008, -89.851>, <-81.9003, 350.3761, -88.06316>, <-83.5307, 348.2049, -84.5316> }
					triangle { <-80.5588, 348.2252, -89.7254>, <-80.3015, 348.1941, -90.5031>, <-81.3768, 349.9008, -89.851> }
					triangle { <-81.3768, 349.9008, -89.851>, <-83.5307, 348.2049, -84.5316>, <-80.5588, 348.2252, -89.7254> }
					triangle { <-83.4005, 347.668, -84.5307>, <-80.5588, 348.2252, -89.7254>, <-83.5307, 348.2049, -84.5316> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-80.9602, 348.8238, -82.6083>, <-81.6373, 348.4142, -82.6769>, <-82.7821, 347.9016, -83.7338> }
					triangle { <-81.6373, 348.4142, -82.6769>, <-83.5678, 347.4702, -84.04291>, <-82.7821, 347.9016, -83.7338> }
					triangle { <-83.5678, 347.4702, -84.04291>, <-83.4005, 347.668, -84.5307>, <-82.7821, 347.9016, -83.7338> }
					triangle { <-82.7821, 347.9016, -83.7338>, <-83.4005, 347.668, -84.5307>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-83.5678, 347.4702, -84.04291>, <-82.2982, 343.2329, -83.2635>, <-81.7875, 341.7709, -84.442> }
					triangle { <-81.7875, 341.7709, -84.442>, <-80.6659, 341.7122, -86.1435>, <-80.8494, 342.4726, -85.898> }
					triangle { <-80.8494, 342.4726, -85.898>, <-83.5678, 347.4702, -84.04291>, <-81.7875, 341.7709, -84.442> }
					triangle { <-83.5678, 347.4702, -84.04291>, <-80.8494, 342.4726, -85.898>, <-83.4005, 347.668, -84.5307> }
					triangle { <-82.548, 348.1311, -84.1689>, <-81.286, 348.7585, -83.3297>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-82.548, 348.1311, -84.1689>, <-83.09955, 347.9292, -84.9132>, <-81.286, 348.7585, -83.3297> }
					triangle { <-82.548, 348.1311, -84.1689>, <-83.4005, 347.668, -84.5307>, <-83.09955, 347.9292, -84.9132> }
					triangle { <-80.9602, 348.8238, -82.6083>, <-83.4005, 347.668, -84.5307>, <-82.548, 348.1311, -84.1689> }
					triangle { <-80.1875, 343.3391, -87.4157>, <-80.269, 345.222, -87.03519>, <-83.09955, 347.9292, -84.9132> }
					triangle { <-80.8494, 342.4726, -85.898>, <-80.6659, 341.7122, -86.1435>, <-80.1875, 343.3391, -87.4157> }
					triangle { <-80.1875, 343.3391, -87.4157>, <-83.09955, 347.9292, -84.9132>, <-80.8494, 342.4726, -85.898> }
					triangle { <-83.4005, 347.668, -84.5307>, <-80.8494, 342.4726, -85.898>, <-83.09955, 347.9292, -84.9132> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-80.9602, 348.8238, -82.6083>, <-81.7196, 348.8572, -82.8387>, <-82.837, 348.1969, -83.8416> }
					triangle { <-81.7196, 348.8572, -82.8387>, <-83.6776, 348.0609, -84.2586>, <-82.837, 348.1969, -83.8416> }
					triangle { <-83.6776, 348.0609, -84.2586>, <-83.4005, 347.668, -84.5307>, <-82.837, 348.1969, -83.8416> }
					triangle { <-82.837, 348.1969, -83.8416>, <-83.4005, 347.668, -84.5307>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-83.6776, 348.0609, -84.2586>, <-85.9168, 346.5556, -80.6679>, <-86.5846, 344.7963, -80.1717> }
					triangle { <-86.5846, 344.7963, -80.1717>, <-85.7935, 342.9274, -80.3653>, <-85.3759, 343.5037, -80.7722> }
					triangle { <-85.3759, 343.5037, -80.7722>, <-83.6776, 348.0609, -84.2586>, <-86.5846, 344.7963, -80.1717> }
					triangle { <-83.6776, 348.0609, -84.2586>, <-85.3759, 343.5037, -80.7722>, <-83.4005, 347.668, -84.5307> }
					triangle { <-82.4931, 347.8358, -84.0611>, <-81.2037, 348.3155, -83.1679>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-82.4931, 347.8358, -84.0611>, <-82.9897, 347.3385, -84.6975>, <-81.2037, 348.3155, -83.1679> }
					triangle { <-82.4931, 347.8358, -84.0611>, <-83.4005, 347.668, -84.5307>, <-82.9897, 347.3385, -84.6975> }
					triangle { <-80.9602, 348.8238, -82.6083>, <-83.4005, 347.668, -84.5307>, <-82.4931, 347.8358, -84.0611> }
					triangle { <-84.2344, 342.3282, -81.671>, <-82.9361, 343.4254, -82.5695>, <-82.9897, 347.3385, -84.6975> }
					triangle { <-85.3759, 343.5037, -80.7722>, <-85.7935, 342.9274, -80.3653>, <-84.2344, 342.3282, -81.671> }
					triangle { <-84.2344, 342.3282, -81.671>, <-82.9897, 347.3385, -84.6975>, <-85.3759, 343.5037, -80.7722> }
					triangle { <-83.4005, 347.668, -84.5307>, <-85.3759, 343.5037, -80.7722>, <-82.9897, 347.3385, -84.6975> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-80.9602, 348.8238, -82.6083>, <-81.4479, 348.9284, -83.2264>, <-82.6559, 348.2444, -84.1001> }
					triangle { <-81.4479, 348.9284, -83.2264>, <-83.3153, 348.1558, -84.7756>, <-82.6559, 348.2444, -84.1001> }
					triangle { <-83.3153, 348.1558, -84.7756>, <-83.4005, 347.668, -84.5307>, <-82.6559, 348.2444, -84.1001> }
					triangle { <-82.6559, 348.2444, -84.1001>, <-83.4005, 347.668, -84.5307>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-83.3153, 348.1558, -84.7756>, <-86.08147, 351.4052, -83.3745>, <-87.837, 351.3724, -82.5354> }
					triangle { <-87.837, 351.3724, -82.5354>, <-88.6458, 350.1716, -81.1>, <-87.925, 349.9032, -81.3838> }
					triangle { <-87.925, 349.9032, -81.3838>, <-83.3153, 348.1558, -84.7756>, <-87.837, 351.3724, -82.5354> }
					triangle { <-83.3153, 348.1558, -84.7756>, <-87.925, 349.9032, -81.3838>, <-83.4005, 347.668, -84.5307> }
					triangle { <-82.6743, 347.7883, -83.8026>, <-81.4754, 348.2443, -82.7801>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-82.6743, 347.7883, -83.8026>, <-83.352, 347.2436, -84.1805>, <-81.4754, 348.2443, -82.7801> }
					triangle { <-82.6743, 347.7883, -83.8026>, <-83.4005, 347.668, -84.5307>, <-83.352, 347.2436, -84.1805> }
					triangle { <-80.9602, 348.8238, -82.6083>, <-83.4005, 347.668, -84.5307>, <-82.6743, 347.7883, -83.8026> }
					triangle { <-87.9626, 348.2558, -80.5023>, <-86.2407, 347.4524, -80.7959>, <-83.352, 347.2436, -84.1805> }
					triangle { <-87.925, 349.9032, -81.3838>, <-88.6458, 350.1716, -81.1>, <-87.9626, 348.2558, -80.5023> }
					triangle { <-87.9626, 348.2558, -80.5023>, <-83.352, 347.2436, -84.1805>, <-87.925, 349.9032, -81.3838> }
					triangle { <-83.4005, 347.668, -84.5307>, <-87.925, 349.9032, -81.3838>, <-83.352, 347.2436, -84.1805> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-80.9602, 348.8238, -82.6083>, <-81.1933, 348.5208, -83.3045>, <-82.4862, 347.9726, -84.1521> }
					triangle { <-81.1933, 348.5208, -83.3045>, <-82.9759, 347.6123, -84.8796>, <-82.4862, 347.9726, -84.1521> }
					triangle { <-82.9759, 347.6123, -84.8796>, <-83.4005, 347.668, -84.5307>, <-82.4862, 347.9726, -84.1521> }
					triangle { <-82.4862, 347.9726, -84.1521>, <-83.4005, 347.668, -84.5307>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-82.9759, 347.6123, -84.8796>, <-82.4903, 351.0554, -87.7226>, <-83.7252, 352.4092, -88.3781> }
					triangle { <-83.7252, 352.4092, -88.3781>, <-85.2003, 353.4758, -87.4601>, <-84.903, 352.8653, -87.00078> }
					triangle { <-84.903, 352.8653, -87.00078>, <-82.9759, 347.6123, -84.8796>, <-83.7252, 352.4092, -88.3781> }
					triangle { <-82.9759, 347.6123, -84.8796>, <-84.903, 352.8653, -87.00078>, <-83.4005, 347.668, -84.5307> }
					triangle { <-82.8439, 348.0601, -83.7506>, <-81.73, 348.6519, -82.7021>, <-80.9602, 348.8238, -82.6083> }
					triangle { <-82.8439, 348.0601, -83.7506>, <-83.6914, 347.7871, -84.07653>, <-81.73, 348.6519, -82.7021> }
					triangle { <-82.8439, 348.0601, -83.7506>, <-83.4005, 347.668, -84.5307>, <-83.6914, 347.7871, -84.07653> }
					triangle { <-80.9602, 348.8238, -82.6083>, <-83.4005, 347.668, -84.5307>, <-82.8439, 348.0601, -83.7506> }
					triangle { <-86.1699, 353.0065, -85.6341>, <-85.5909, 351.813, -84.2424>, <-83.6914, 347.7871, -84.07653> }
					triangle { <-84.903, 352.8653, -87.00078>, <-85.2003, 353.4758, -87.4601>, <-86.1699, 353.0065, -85.6341> }
					triangle { <-86.1699, 353.0065, -85.6341>, <-83.6914, 347.7871, -84.07653>, <-84.903, 352.8653, -87.00078> }
					triangle { <-83.4005, 347.668, -84.5307>, <-84.903, 352.8653, -87.00078>, <-83.6914, 347.7871, -84.07653> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-31.2644, 338.5999, -66.5181>, <-31.6886, 340.9149, -66.5756>, 0.2999 }
			cylinder { <-31.6886, 340.9149, -66.5756>, <-32.03292, 343.2433, -66.6227>, 0.2999 }
			cylinder { <-32.03292, 343.2433, -66.6227>, <-32.2968, 345.5825, -66.6594>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-32.2968, 345.5825, -66.6594>, <-31.2721, 347.0583, -65.138>, 0.2999 }
			cylinder { <-31.2721, 347.0583, -65.138>, <-30.2866, 348.5961, -63.6526>, 0.2999 }
			cylinder { <-30.2866, 348.5961, -63.6526>, <-29.3414, 350.1941, -62.205>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-29.3414, 350.1941, -62.205>, <-26.2413, 356.003, -59.6499>, 0.2999 }
				cylinder { <-26.2413, 356.003, -59.6499>, <-23.1438, 362.3267, -59.1025>, 0.2999 }
				cylinder { <-23.1438, 362.3267, -59.1025>, <-20.3157, 368.6205, -60.6099>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-20.3157, 368.6205, -60.6099>, <-20.3725, 369.2689, -61.1223>, <-19.7422, 370.8198, -61.4748> }
					triangle { <-20.3725, 369.2689, -61.1223>, <-19.6309, 371.6831, -61.944>, <-19.7422, 370.8198, -61.4748> }
					triangle { <-19.6309, 371.6831, -61.944>, <-19.2272, 371.7667, -61.5416>, <-19.7422, 370.8198, -61.4748> }
					triangle { <-19.7422, 370.8198, -61.4748>, <-19.2272, 371.7667, -61.5416>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-19.6309, 371.6831, -61.944>, <-17.9628, 370.0119, -65.99>, <-16.1219, 370.0588, -66.8435> }
					triangle { <-16.1219, 370.0588, -66.8435>, <-14.168, 369.83, -66.03653>, <-14.777, 369.9048, -65.441> }
					triangle { <-14.777, 369.9048, -65.441>, <-19.6309, 371.6831, -61.944>, <-16.1219, 370.0588, -66.8435> }
					triangle { <-19.6309, 371.6831, -61.944>, <-14.777, 369.9048, -65.441>, <-19.2272, 371.7667, -61.5416> }
					triangle { <-19.3683, 370.8172, -61.04689>, <-19.8116, 369.265, -60.4804>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-19.3683, 370.8172, -61.04689>, <-18.8831, 371.6778, -61.08817>, <-19.8116, 369.265, -60.4804> }
					triangle { <-19.3683, 370.8172, -61.04689>, <-19.2272, 371.7667, -61.5416>, <-18.8831, 371.6778, -61.08817> }
					triangle { <-20.3157, 368.6205, -60.6099>, <-19.2272, 371.7667, -61.5416>, <-19.3683, 370.8172, -61.04689> }
					triangle { <-13.5669, 370.0409, -63.9191>, <-14.7224, 369.9891, -62.281>, <-18.8831, 371.6778, -61.08817> }
					triangle { <-14.777, 369.9048, -65.441>, <-14.168, 369.83, -66.03653>, <-13.5669, 370.0409, -63.9191> }
					triangle { <-13.5669, 370.0409, -63.9191>, <-18.8831, 371.6778, -61.08817>, <-14.777, 369.9048, -65.441> }
					triangle { <-19.2272, 371.7667, -61.5416>, <-14.777, 369.9048, -65.441>, <-18.8831, 371.6778, -61.08817> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-20.3157, 368.6205, -60.6099>, <-20.4568, 369.4353, -60.6591>, <-19.7984, 370.9307, -61.166> }
					triangle { <-20.4568, 369.4353, -60.6591>, <-19.7434, 371.9049, -61.3264>, <-19.7984, 370.9307, -61.166> }
					triangle { <-19.7434, 371.9049, -61.3264>, <-19.2272, 371.7667, -61.5416>, <-19.7984, 370.9307, -61.166> }
					triangle { <-19.7984, 370.9307, -61.166>, <-19.2272, 371.7667, -61.5416>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-19.7434, 371.9049, -61.3264>, <-23.1236, 372.2226, -64.5542>, <-23.08748, 372.5538, -66.5564> }
					triangle { <-23.08748, 372.5538, -66.5564>, <-21.7948, 371.8591, -68.0952>, <-21.5136, 371.6829, -67.3071> }
					triangle { <-21.5136, 371.6829, -67.3071>, <-19.7434, 371.9049, -61.3264>, <-23.08748, 372.5538, -66.5564> }
					triangle { <-19.7434, 371.9049, -61.3264>, <-21.5136, 371.6829, -67.3071>, <-19.2272, 371.7667, -61.5416> }
					triangle { <-19.312, 370.7063, -61.3556>, <-19.7272, 369.0986, -60.9436>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-19.312, 370.7063, -61.3556>, <-18.7706, 371.456, -61.7057>, <-19.7272, 369.0986, -60.9436> }
					triangle { <-19.312, 370.7063, -61.3556>, <-19.2272, 371.7667, -61.5416>, <-18.7706, 371.456, -61.7057> }
					triangle { <-20.3157, 368.6205, -60.6099>, <-19.2272, 371.7667, -61.5416>, <-19.312, 370.7063, -61.3556> }
					triangle { <-19.7635, 371.0201, -67.8522>, <-18.9079, 370.2773, -66.1977>, <-18.7706, 371.456, -61.7057> }
					triangle { <-21.5136, 371.6829, -67.3071>, <-21.7948, 371.8591, -68.0952>, <-19.7635, 371.0201, -67.8522> }
					triangle { <-19.7635, 371.0201, -67.8522>, <-18.7706, 371.456, -61.7057>, <-21.5136, 371.6829, -67.3071> }
					triangle { <-19.2272, 371.7667, -61.5416>, <-21.5136, 371.6829, -67.3071>, <-18.7706, 371.456, -61.7057> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-20.3157, 368.6205, -60.6099>, <-20.04053, 369.3706, -60.3911>, <-19.5209, 370.8876, -60.9874> }
					triangle { <-20.04053, 369.3706, -60.3911>, <-19.1883, 371.8187, -60.9692>, <-19.5209, 370.8876, -60.9874> }
					triangle { <-19.1883, 371.8187, -60.9692>, <-19.2272, 371.7667, -61.5416>, <-19.5209, 370.8876, -60.9874> }
					triangle { <-19.5209, 370.8876, -60.9874>, <-19.2272, 371.7667, -61.5416>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-19.1883, 371.8187, -60.9692>, <-22.936, 373.8075, -58.9832>, <-24.3859, 375.0332, -59.7012> }
					triangle { <-24.3859, 375.0332, -59.7012>, <-25.447, 375.0628, -61.5436>, <-24.7843, 374.5225, -61.5396> }
					triangle { <-24.7843, 374.5225, -61.5396>, <-19.1883, 371.8187, -60.9692>, <-24.3859, 375.0332, -59.7012> }
					triangle { <-19.1883, 371.8187, -60.9692>, <-24.7843, 374.5225, -61.5396>, <-19.2272, 371.7667, -61.5416> }
					triangle { <-19.5896, 370.7494, -61.5343>, <-20.1436, 369.1633, -61.2115>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-19.5896, 370.7494, -61.5343>, <-19.3257, 371.5423, -62.06305>, <-20.1436, 369.1633, -61.2115> }
					triangle { <-19.5896, 370.7494, -61.5343>, <-19.2272, 371.7667, -61.5416>, <-19.3257, 371.5423, -62.06305> }
					triangle { <-20.3157, 368.6205, -60.6099>, <-19.2272, 371.7667, -61.5416>, <-19.5896, 370.7494, -61.5343> }
					triangle { <-24.8555, 374.0889, -63.4385>, <-23.5317, 372.6099, -63.7233>, <-19.3257, 371.5423, -62.06305> }
					triangle { <-24.7843, 374.5225, -61.5396>, <-25.447, 375.0628, -61.5436>, <-24.8555, 374.0889, -63.4385> }
					triangle { <-24.8555, 374.0889, -63.4385>, <-19.3257, 371.5423, -62.06305>, <-24.7843, 374.5225, -61.5396> }
					triangle { <-19.2272, 371.7667, -61.5416>, <-24.7843, 374.5225, -61.5396>, <-19.3257, 371.5423, -62.06305> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-20.3157, 368.6205, -60.6099>, <-19.6949, 369.1636, -60.6862>, <-19.2905, 370.7496, -61.1841> }
					triangle { <-19.6949, 369.1636, -60.6862>, <-18.7275, 371.5427, -61.3626>, <-19.2905, 370.7496, -61.1841> }
					triangle { <-18.7275, 371.5427, -61.3626>, <-19.2272, 371.7667, -61.5416>, <-19.2905, 370.7496, -61.1841> }
					triangle { <-19.2905, 370.7496, -61.1841>, <-19.2272, 371.7667, -61.5416>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-18.7275, 371.5427, -61.3626>, <-17.6575, 372.591, -56.924>, <-18.2349, 374.0936, -55.6876> }
					triangle { <-18.2349, 374.0936, -55.6876>, <-20.1113, 375.0436, -55.3747>, <-20.09964, 374.5259, -56.05516> }
					triangle { <-20.09964, 374.5259, -56.05516>, <-18.7275, 371.5427, -61.3626>, <-18.2349, 374.0936, -55.6876> }
					triangle { <-18.7275, 371.5427, -61.3626>, <-20.09964, 374.5259, -56.05516>, <-19.2272, 371.7667, -61.5416> }
					triangle { <-19.82, 370.8874, -61.3376>, <-20.4892, 369.3703, -60.9165>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-19.82, 370.8874, -61.3376>, <-19.7865, 371.8182, -61.6696>, <-20.4892, 369.3703, -60.9165> }
					triangle { <-19.82, 370.8874, -61.3376>, <-19.2272, 371.7667, -61.5416>, <-19.7865, 371.8182, -61.6696> }
					triangle { <-20.3157, 368.6205, -60.6099>, <-19.2272, 371.7667, -61.5416>, <-19.82, 370.8874, -61.3376> }
					triangle { <-21.8534, 375.035, -56.7364>, <-22.2469, 373.785, -58.2542>, <-19.7865, 371.8182, -61.6696> }
					triangle { <-20.09964, 374.5259, -56.05516>, <-20.1113, 375.0436, -55.3747>, <-21.8534, 375.035, -56.7364> }
					triangle { <-21.8534, 375.035, -56.7364>, <-19.7865, 371.8182, -61.6696>, <-20.09964, 374.5259, -56.05516> }
					triangle { <-19.2272, 371.7667, -61.5416>, <-20.09964, 374.5259, -56.05516>, <-19.7865, 371.8182, -61.6696> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-20.3157, 368.6205, -60.6099>, <-19.9031, 369.0999, -61.1449>, <-19.4293, 370.7071, -61.4899> }
					triangle { <-19.9031, 369.0999, -61.1449>, <-19.00518, 371.4576, -61.9742>, <-19.4293, 370.7071, -61.4899> }
					triangle { <-19.00518, 371.4576, -61.9742>, <-19.2272, 371.7667, -61.5416>, <-19.4293, 370.7071, -61.4899> }
					triangle { <-19.4293, 370.7071, -61.4899>, <-19.2272, 371.7667, -61.5416>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-19.00518, 371.4576, -61.9742>, <-14.5375, 370.2098, -61.3198>, <-13.05037, 370.9729, -60.1684> }
					triangle { <-13.05037, 370.9729, -60.1684>, <-13.0353, 371.7607, -58.1934>, <-13.8214, 371.6289, -58.5027> }
					triangle { <-13.8214, 371.6289, -58.5027>, <-19.00518, 371.4576, -61.9742>, <-13.05037, 370.9729, -60.1684> }
					triangle { <-19.00518, 371.4576, -61.9742>, <-13.8214, 371.6289, -58.5027>, <-19.2272, 371.7667, -61.5416> }
					triangle { <-19.6811, 370.9299, -61.0318>, <-20.2809, 369.4341, -60.4578>, <-20.3157, 368.6205, -60.6099> }
					triangle { <-19.6811, 370.9299, -61.0318>, <-19.5089, 371.9033, -61.05801>, <-20.2809, 369.4341, -60.4578> }
					triangle { <-19.6811, 370.9299, -61.0318>, <-19.2272, 371.7667, -61.5416>, <-19.5089, 371.9033, -61.05801> }
					triangle { <-20.3157, 368.6205, -60.6099>, <-19.2272, 371.7667, -61.5416>, <-19.6811, 370.9299, -61.0318> }
					triangle { <-14.7713, 372.4954, -57.03791>, <-16.7203, 372.1408, -57.3494>, <-19.5089, 371.9033, -61.05801> }
					triangle { <-13.8214, 371.6289, -58.5027>, <-13.0353, 371.7607, -58.1934>, <-14.7713, 372.4954, -57.03791> }
					triangle { <-14.7713, 372.4954, -57.03791>, <-19.5089, 371.9033, -61.05801>, <-13.8214, 371.6289, -58.5027> }
					triangle { <-19.2272, 371.7667, -61.5416>, <-13.8214, 371.6289, -58.5027>, <-19.5089, 371.9033, -61.05801> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-29.3414, 350.1941, -62.205>, <-28.4085, 351.7408, -60.695>, 0.2999 }
			cylinder { <-28.4085, 351.7408, -60.695>, <-27.4892, 353.2343, -59.1245>, 0.2999 }
			cylinder { <-27.4892, 353.2343, -59.1245>, <-26.5845, 354.6729, -57.4952>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-26.5845, 354.6729, -57.4952>, <-25.568, 358.393, -51.5783>, 0.2999 }
				cylinder { <-25.568, 358.393, -51.5783>, <-26.3366, 361.197, -45.1417>, 0.2999 }
				cylinder { <-26.3366, 361.197, -45.1417>, <-28.8241, 362.8434, -38.7398>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-28.8241, 362.8434, -38.7398>, <-29.2762, 362.6341, -38.07798>, <-29.8094, 363.1565, -36.5386> }
					triangle { <-29.2762, 362.6341, -38.07798>, <-30.2776, 363.1273, -35.6681>, <-29.8094, 363.1565, -36.5386> }
					triangle { <-30.2776, 363.1273, -35.6681>, <-30.04171, 363.6493, -35.6062>, <-29.8094, 363.1565, -36.5386> }
					triangle { <-29.8094, 363.1565, -36.5386>, <-30.04171, 363.6493, -35.6062>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-30.2776, 363.1273, -35.6681>, <-34.671, 363.2092, -37.2918>, <-36.1161, 364.6345, -37.2794> }
					triangle { <-36.1161, 364.6345, -37.2794>, <-36.04963, 366.7376, -37.5854>, <-35.2773, 366.3792, -37.5066> }
					triangle { <-35.2773, 366.3792, -37.5066>, <-30.2776, 363.1273, -35.6681>, <-36.1161, 364.6345, -37.2794> }
					triangle { <-30.2776, 363.1273, -35.6681>, <-35.2773, 366.3792, -37.5066>, <-30.04171, 363.6493, -35.6062> }
					triangle { <-29.5401, 363.6563, -36.5625>, <-28.8723, 363.3839, -38.1138>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-29.5401, 363.6563, -36.5625>, <-29.739, 364.127, -35.7159>, <-28.8723, 363.3839, -38.1138> }
					triangle { <-29.5401, 363.6563, -36.5625>, <-30.04171, 363.6493, -35.6062>, <-29.739, 364.127, -35.7159> }
					triangle { <-28.8241, 362.8434, -38.7398>, <-30.04171, 363.6493, -35.6062>, <-29.5401, 363.6563, -36.5625> }
					triangle { <-34.2759, 368.0501, -37.4428>, <-32.337, 367.5413, -37.499>, <-29.739, 364.127, -35.7159> }
					triangle { <-35.2773, 366.3792, -37.5066>, <-36.04963, 366.7376, -37.5854>, <-34.2759, 368.0501, -37.4428> }
					triangle { <-34.2759, 368.0501, -37.4428>, <-29.739, 364.127, -35.7159>, <-35.2773, 366.3792, -37.5066> }
					triangle { <-30.04171, 363.6493, -35.6062>, <-35.2773, 366.3792, -37.5066>, <-29.739, 364.127, -35.7159> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.8241, 362.8434, -38.7398>, <-28.811, 362.7235, -37.9202>, <-29.4992, 363.2161, -36.4334> }
					triangle { <-28.811, 362.7235, -37.9202>, <-29.6573, 363.2466, -35.4577>, <-29.4992, 363.2161, -36.4334> }
					triangle { <-29.6573, 363.2466, -35.4577>, <-30.04171, 363.6493, -35.6062>, <-29.4992, 363.2161, -36.4334> }
					triangle { <-29.4992, 363.2161, -36.4334>, <-30.04171, 363.6493, -35.6062>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-29.6573, 363.2466, -35.4577>, <-31.4882, 358.9631, -34.9631>, <-33.3715, 358.3069, -34.5856> }
					triangle { <-33.3715, 358.3069, -34.5856>, <-35.2743, 358.9519, -35.2819>, <-34.6374, 359.485, -35.485> }
					triangle { <-34.6374, 359.485, -35.485>, <-29.6573, 363.2466, -35.4577>, <-33.3715, 358.3069, -34.5856> }
					triangle { <-29.6573, 363.2466, -35.4577>, <-34.6374, 359.485, -35.485>, <-30.04171, 363.6493, -35.6062> }
					triangle { <-29.8502, 363.5967, -36.6677>, <-29.3375, 363.2944, -38.2716>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-29.8502, 363.5967, -36.6677>, <-30.3593, 364.0078, -35.9263>, <-29.3375, 363.2944, -38.2716> }
					triangle { <-29.8502, 363.5967, -36.6677>, <-30.04171, 363.6493, -35.6062>, <-30.3593, 364.0078, -35.9263> }
					triangle { <-28.8241, 362.8434, -38.7398>, <-30.04171, 363.6493, -35.6062>, <-29.8502, 363.5967, -36.6677> }
					triangle { <-35.7702, 360.9076, -36.1865>, <-34.5304, 362.2615, -36.9934>, <-30.3593, 364.0078, -35.9263> }
					triangle { <-34.6374, 359.485, -35.485>, <-35.2743, 358.9519, -35.2819>, <-35.7702, 360.9076, -36.1865> }
					triangle { <-35.7702, 360.9076, -36.1865>, <-30.3593, 364.0078, -35.9263>, <-34.6374, 359.485, -35.485> }
					triangle { <-30.04171, 363.6493, -35.6062>, <-34.6374, 359.485, -35.485>, <-30.3593, 364.0078, -35.9263> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.8241, 362.8434, -38.7398>, <-28.7071, 363.2048, -38.00362>, <-29.43, 363.5369, -36.489> }
					triangle { <-28.7071, 363.2048, -38.00362>, <-29.5188, 363.8883, -35.5689>, <-29.43, 363.5369, -36.489> }
					triangle { <-29.5188, 363.8883, -35.5689>, <-30.04171, 363.6493, -35.6062>, <-29.43, 363.5369, -36.489> }
					triangle { <-29.43, 363.5369, -36.489>, <-30.04171, 363.6493, -35.6062>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-29.5188, 363.8883, -35.5689>, <-26.3198, 361.1494, -33.5171>, <-26.4683, 359.5852, -32.2321> }
					triangle { <-26.4683, 359.5852, -32.2321>, <-27.8202, 357.9473, -32.1272>, <-28.05555, 358.5493, -32.6869> }
					triangle { <-28.05555, 358.5493, -32.6869>, <-29.5188, 363.8883, -35.5689>, <-26.4683, 359.5852, -32.2321> }
					triangle { <-29.5188, 363.8883, -35.5689>, <-28.05555, 358.5493, -32.6869>, <-30.04171, 363.6493, -35.6062> }
					triangle { <-29.9195, 363.2758, -36.6121>, <-29.4414, 362.8132, -38.1882>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-29.9195, 363.2758, -36.6121>, <-30.4978, 363.3661, -35.8151>, <-29.4414, 362.8132, -38.1882> }
					triangle { <-29.9195, 363.2758, -36.6121>, <-30.04171, 363.6493, -35.6062>, <-30.4978, 363.3661, -35.8151> }
					triangle { <-28.8241, 362.8434, -38.7398>, <-30.04171, 363.6493, -35.6062>, <-29.9195, 363.2758, -36.6121> }
					triangle { <-29.8134, 357.8011, -33.0731>, <-30.5624, 358.8866, -34.5837>, <-30.4978, 363.3661, -35.8151> }
					triangle { <-28.05555, 358.5493, -32.6869>, <-27.8202, 357.9473, -32.1272>, <-29.8134, 357.8011, -33.0731> }
					triangle { <-29.8134, 357.8011, -33.0731>, <-30.4978, 363.3661, -35.8151>, <-28.05555, 358.5493, -32.6869> }
					triangle { <-30.04171, 363.6493, -35.6062>, <-28.05555, 358.5493, -32.6869>, <-30.4978, 363.3661, -35.8151> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.8241, 362.8434, -38.7398>, <-29.1072, 363.4173, -38.2137>, <-29.6967, 363.6786, -36.6291> }
					triangle { <-29.1072, 363.4173, -38.2137>, <-30.05227, 364.1716, -35.8491>, <-29.6967, 363.6786, -36.6291> }
					triangle { <-30.05227, 364.1716, -35.8491>, <-30.04171, 363.6493, -35.6062>, <-29.6967, 363.6786, -36.6291> }
					triangle { <-29.6967, 363.6786, -36.6291>, <-30.04171, 363.6493, -35.6062>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-30.05227, 364.1716, -35.8491>, <-26.2602, 366.7671, -34.9387>, <-24.8822, 366.7147, -33.4493> }
					triangle { <-24.8822, 366.7147, -33.4493>, <-23.9191, 365.1028, -32.4516>, <-24.5662, 364.8564, -32.9532> }
					triangle { <-24.5662, 364.8564, -32.9532>, <-30.05227, 364.1716, -35.8491>, <-24.8822, 366.7147, -33.4493> }
					triangle { <-30.05227, 364.1716, -35.8491>, <-24.5662, 364.8564, -32.9532>, <-30.04171, 363.6493, -35.6062> }
					triangle { <-29.6528, 363.1342, -36.472>, <-29.04138, 362.6007, -37.9781>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-29.6528, 363.1342, -36.472>, <-29.9644, 363.0828, -35.5349>, <-29.04138, 362.6007, -37.9781> }
					triangle { <-29.6528, 363.1342, -36.472>, <-30.04171, 363.6493, -35.6062>, <-29.9644, 363.0828, -35.5349> }
					triangle { <-28.8241, 362.8434, -38.7398>, <-30.04171, 363.6493, -35.6062>, <-29.6528, 363.1342, -36.472> }
					triangle { <-24.5821, 362.9948, -32.376>, <-25.8796, 362.0491, -33.5774>, <-29.9644, 363.0828, -35.5349> }
					triangle { <-24.5662, 364.8564, -32.9532>, <-23.9191, 365.1028, -32.4516>, <-24.5821, 362.9948, -32.376> }
					triangle { <-24.5821, 362.9948, -32.376>, <-29.9644, 363.0828, -35.5349>, <-24.5662, 364.8564, -32.9532> }
					triangle { <-30.04171, 363.6493, -35.6062>, <-24.5662, 364.8564, -32.9532>, <-29.9644, 363.0828, -35.5349> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.8241, 362.8434, -38.7398>, <-29.4643, 363.0592, -38.2603>, <-29.9347, 363.4399, -36.6602> }
					triangle { <-29.4643, 363.0592, -38.2603>, <-30.5283, 363.6942, -35.9113>, <-29.9347, 363.4399, -36.6602> }
					triangle { <-30.5283, 363.6942, -35.9113>, <-30.04171, 363.6493, -35.6062>, <-29.9347, 363.4399, -36.6602> }
					triangle { <-29.9347, 363.4399, -36.6602>, <-30.04171, 363.6493, -35.6062>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-30.5283, 363.6942, -35.9113>, <-31.4995, 368.0593, -37.3067>, <-30.9349, 369.8824, -36.6158> }
					triangle { <-30.9349, 369.8824, -36.6158>, <-29.08195, 370.6175, -35.8759>, <-29.09698, 369.7686, -35.9769> }
					triangle { <-29.09698, 369.7686, -35.9769>, <-30.5283, 363.6942, -35.9113>, <-30.9349, 369.8824, -36.6158> }
					triangle { <-30.5283, 363.6942, -35.9113>, <-29.09698, 369.7686, -35.9769>, <-30.04171, 363.6493, -35.6062> }
					triangle { <-29.4147, 363.3729, -36.4409>, <-28.6843, 362.9587, -37.9314>, <-28.8241, 362.8434, -38.7398> }
					triangle { <-29.4147, 363.3729, -36.4409>, <-29.4883, 363.5602, -35.4727>, <-28.6843, 362.9587, -37.9314> }
					triangle { <-29.4147, 363.3729, -36.4409>, <-30.04171, 363.6493, -35.6062>, <-29.4883, 363.5602, -35.4727> }
					triangle { <-28.8241, 362.8434, -38.7398>, <-30.04171, 363.6493, -35.6062>, <-29.4147, 363.3729, -36.4409> }
					triangle { <-27.3816, 369.4246, -35.1174>, <-26.9929, 367.4787, -35.4064>, <-29.4883, 363.5602, -35.4727> }
					triangle { <-29.09698, 369.7686, -35.9769>, <-29.08195, 370.6175, -35.8759>, <-27.3816, 369.4246, -35.1174> }
					triangle { <-27.3816, 369.4246, -35.1174>, <-29.4883, 363.5602, -35.4727>, <-29.09698, 369.7686, -35.9769> }
					triangle { <-30.04171, 363.6493, -35.6062>, <-29.09698, 369.7686, -35.9769>, <-29.4883, 363.5602, -35.4727> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-26.5845, 354.6729, -57.4952>, <-25.6195, 356.13, -55.9179>, 0.2999 }
			cylinder { <-25.6195, 356.13, -55.9179>, <-24.5952, 357.6039, -54.3943>, 0.2999 }
			cylinder { <-24.5952, 357.6039, -54.3943>, <-23.5131, 359.0927, -52.9263>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-23.5131, 359.0927, -52.9263>, <-18.5999, 362.5207, -49.1858>, 0.2999 }
				cylinder { <-18.5999, 362.5207, -49.1858>, <-12.4431, 364.6152, -46.4307>, 0.2999 }
				cylinder { <-12.4431, 364.6152, -46.4307>, <-5.5731, 365.1957, -44.8983>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-5.5731, 365.1957, -44.8983>, <-4.7639, 365.0783, -45.0315>, <-3.2009, 365.3047, -44.3737> }
					triangle { <-4.7639, 365.0783, -45.0315>, <-2.2145, 365.2722, -44.3129>, <-3.2009, 365.3047, -44.3737> }
					triangle { <-2.2145, 365.2722, -44.3129>, <-2.31, 365.5292, -43.8062>, <-3.2009, 365.3047, -44.3737> }
					triangle { <-3.2009, 365.3047, -44.3737>, <-2.31, 365.5292, -43.8062>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-2.2145, 365.2722, -44.3129>, <-1.7358, 360.6212, -44.02347>, <-1.2157, 359.3836, -42.501> }
					triangle { <-1.2157, 359.3836, -42.501>, <-1.7071, 359.3807, -40.4322>, <-1.9449, 360.0943, -40.839> }
					triangle { <-1.9449, 360.0943, -40.839>, <-2.2145, 365.2722, -44.3129>, <-1.2157, 359.3836, -42.501> }
					triangle { <-2.2145, 365.2722, -44.3129>, <-1.9449, 360.0943, -40.839>, <-2.31, 365.5292, -43.8062> }
					triangle { <-3.3859, 365.5526, -43.8969>, <-5.0413, 365.4502, -44.3163>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-3.3859, 365.5526, -43.8969>, <-2.5843, 365.7679, -43.3593>, <-5.0413, 365.4502, -44.3163> }
					triangle { <-3.3859, 365.5526, -43.8969>, <-2.31, 365.5292, -43.8062>, <-2.5843, 365.7679, -43.3593> }
					triangle { <-5.5731, 365.1957, -44.8983>, <-2.31, 365.5292, -43.8062>, <-3.3859, 365.5526, -43.8969> }
					triangle { <-2.4792, 361.0774, -39.243>, <-3.3382, 362.7694, -39.8914>, <-2.5843, 365.7679, -43.3593> }
					triangle { <-1.9449, 360.0943, -40.839>, <-1.7071, 359.3807, -40.4322>, <-2.4792, 361.0774, -39.243> }
					triangle { <-2.4792, 361.0774, -39.243>, <-2.5843, 365.7679, -43.3593>, <-1.9449, 360.0943, -40.839> }
					triangle { <-2.31, 365.5292, -43.8062>, <-1.9449, 360.0943, -40.839>, <-2.5843, 365.7679, -43.3593> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-5.5731, 365.1957, -44.8983>, <-4.8361, 365.568, -44.9654>, <-3.2491, 365.6312, -44.3296> }
					triangle { <-4.8361, 365.568, -44.9654>, <-2.3107, 365.9251, -44.2247>, <-3.2491, 365.6312, -44.3296> }
					triangle { <-2.3107, 365.9251, -44.2247>, <-2.31, 365.5292, -43.8062>, <-3.2491, 365.6312, -44.3296> }
					triangle { <-3.2491, 365.6312, -44.3296>, <-2.31, 365.5292, -43.8062>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-2.3107, 365.9251, -44.2247>, <-0.6776, 364.3566, -48.3257>, <0.5483, 362.8163, -48.8201> }
					triangle { <0.5483, 362.8163, -48.8201>, <0.7072, 360.8265, -48.08765>, <0.1973, 361.3247, -47.6155> }
					triangle { <0.1973, 361.3247, -47.6155>, <-2.3107, 365.9251, -44.2247>, <0.5483, 362.8163, -48.8201> }
					triangle { <-2.3107, 365.9251, -44.2247>, <0.1973, 361.3247, -47.6155>, <-2.31, 365.5292, -43.8062> }
					triangle { <-3.3377, 365.2262, -43.941>, <-4.9691, 364.9605, -44.3824>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-3.3377, 365.2262, -43.941>, <-2.4881, 365.1151, -43.4474>, <-4.9691, 364.9605, -44.3824> }
					triangle { <-3.3377, 365.2262, -43.941>, <-2.31, 365.5292, -43.8062>, <-2.4881, 365.1151, -43.4474> }
					triangle { <-5.5731, 365.1957, -44.8983>, <-2.31, 365.5292, -43.8062>, <-3.3377, 365.2262, -43.941> }
					triangle { <-0.05766, 360.0487, -46.1643>, <-1.4462, 360.8465, -44.9574>, <-2.4881, 365.1151, -43.4474> }
					triangle { <0.1973, 361.3247, -47.6155>, <0.7072, 360.8265, -48.08765>, <-0.05766, 360.0487, -46.1643> }
					triangle { <-0.05766, 360.0487, -46.1643>, <-2.4881, 365.1151, -43.4474>, <0.1973, 361.3247, -47.6155> }
					triangle { <-2.31, 365.5292, -43.8062>, <0.1973, 361.3247, -47.6155>, <-2.4881, 365.1151, -43.4474> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-5.5731, 365.1957, -44.8983>, <-4.9995, 365.6407, -44.4992>, <-3.358, 365.6797, -44.01886> }
					triangle { <-4.9995, 365.6407, -44.4992>, <-2.5287, 366.022, -43.6031>, <-3.358, 365.6797, -44.01886> }
					triangle { <-2.5287, 366.022, -43.6031>, <-2.31, 365.5292, -43.8062>, <-3.358, 365.6797, -44.01886> }
					triangle { <-3.358, 365.6797, -44.01886>, <-2.31, 365.5292, -43.8062>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-2.5287, 366.022, -43.6031>, <-1.8601, 369.7016, -46.4243>, <-0.5066, 370.0857, -47.8873> }
					triangle { <-0.5066, 370.0857, -47.8873>, <0.3298, 368.8653, -49.4144>, <-0.1204, 368.4267, -48.8347> }
					triangle { <-0.1204, 368.4267, -48.8347>, <-2.5287, 366.022, -43.6031>, <-0.5066, 370.0857, -47.8873> }
					triangle { <-2.5287, 366.022, -43.6031>, <-0.1204, 368.4267, -48.8347>, <-2.31, 365.5292, -43.8062> }
					triangle { <-3.2288, 365.1777, -44.2518>, <-4.8056, 364.8878, -44.8486>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-3.2288, 365.1777, -44.2518>, <-2.2702, 365.0181, -44.06909>, <-4.8056, 364.8878, -44.8486> }
					triangle { <-3.2288, 365.1777, -44.2518>, <-2.31, 365.5292, -43.8062>, <-2.2702, 365.0181, -44.06909> }
					triangle { <-5.5731, 365.1957, -44.8983>, <-2.31, 365.5292, -43.8062>, <-3.2288, 365.1777, -44.2518> }
					triangle { <0.3766, 366.6556, -49.4791>, <-0.7399, 365.3512, -48.4432>, <-2.2702, 365.0181, -44.06909> }
					triangle { <-0.1204, 368.4267, -48.8347>, <0.3298, 368.8653, -49.4144>, <0.3766, 366.6556, -49.4791> }
					triangle { <0.3766, 366.6556, -49.4791>, <-2.2702, 365.0181, -44.06909>, <-0.1204, 368.4267, -48.8347> }
					triangle { <-2.31, 365.5292, -43.8062>, <-0.1204, 368.4267, -48.8347>, <-2.2702, 365.0181, -44.06909> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-5.5731, 365.1957, -44.8983>, <-5.02996, 365.1967, -44.2728>, <-3.3783, 365.3836, -43.8679> }
					triangle { <-5.02996, 365.1967, -44.2728>, <-2.5692, 365.43, -43.3013>, <-3.3783, 365.3836, -43.8679> }
					triangle { <-2.5692, 365.43, -43.3013>, <-2.31, 365.5292, -43.8062>, <-3.3783, 365.3836, -43.8679> }
					triangle { <-3.3783, 365.3836, -43.8679>, <-2.31, 365.5292, -43.8062>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-2.5692, 365.43, -43.3013>, <-3.6602, 369.3194, -40.9292>, <-2.9327, 371.2135, -40.983> }
					triangle { <-2.9327, 371.2135, -40.983>, <-2.3213, 372.4628, -42.5913>, <-2.462, 371.6518, -42.8229> }
					triangle { <-2.462, 371.6518, -42.8229>, <-2.5692, 365.43, -43.3013>, <-2.9327, 371.2135, -40.983> }
					triangle { <-2.5692, 365.43, -43.3013>, <-2.462, 371.6518, -42.8229>, <-2.31, 365.5292, -43.8062> }
					triangle { <-3.2085, 365.4738, -44.4027>, <-4.7752, 365.3318, -45.07501>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-3.2085, 365.4738, -44.4027>, <-2.2296, 365.6101, -44.3709>, <-4.7752, 365.3318, -45.07501> }
					triangle { <-3.2085, 365.4738, -44.4027>, <-2.31, 365.5292, -43.8062>, <-2.2296, 365.6101, -44.3709> }
					triangle { <-5.5731, 365.1957, -44.8983>, <-2.31, 365.5292, -43.8062>, <-3.2085, 365.4738, -44.4027> }
					triangle { <-1.7725, 371.8291, -44.6374>, <-2.1888, 370.1002, -45.5641>, <-2.2296, 365.6101, -44.3709> }
					triangle { <-2.462, 371.6518, -42.8229>, <-2.3213, 372.4628, -42.5913>, <-1.7725, 371.8291, -44.6374> }
					triangle { <-1.7725, 371.8291, -44.6374>, <-2.2296, 365.6101, -44.3709>, <-2.462, 371.6518, -42.8229> }
					triangle { <-2.31, 365.5292, -43.8062>, <-2.462, 371.6518, -42.8229>, <-2.2296, 365.6101, -44.3709> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-5.5731, 365.1957, -44.8983>, <-4.8821, 364.8439, -44.6067>, <-3.2797, 365.1484, -44.09057> }
					triangle { <-4.8821, 364.8439, -44.6067>, <-2.3721, 364.9595, -43.7466>, <-3.2797, 365.1484, -44.09057> }
					triangle { <-2.3721, 364.9595, -43.7466>, <-2.31, 365.5292, -43.8062>, <-3.2797, 365.1484, -44.09057> }
					triangle { <-3.2797, 365.1484, -44.09057>, <-2.31, 365.5292, -43.8062>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-2.3721, 364.9595, -43.7466>, <-3.5822, 363.6227, -39.423>, <-3.3775, 364.4994, -37.6038> }
					triangle { <-3.3775, 364.4994, -37.6038>, <-3.5993, 366.5125, -36.9563>, <-3.6067, 366.4243, -37.8067> }
					triangle { <-3.6067, 366.4243, -37.8067>, <-2.3721, 364.9595, -43.7466>, <-3.3775, 364.4994, -37.6038> }
					triangle { <-2.3721, 364.9595, -43.7466>, <-3.6067, 366.4243, -37.8067>, <-2.31, 365.5292, -43.8062> }
					triangle { <-3.3071, 365.709, -44.1801>, <-4.9231, 365.6847, -44.741>, <-5.5731, 365.1957, -44.8983> }
					triangle { <-3.3071, 365.709, -44.1801>, <-2.4267, 366.0806, -43.9256>, <-4.9231, 365.6847, -44.741> }
					triangle { <-3.3071, 365.709, -44.1801>, <-2.31, 365.5292, -43.8062>, <-2.4267, 366.0806, -43.9256> }
					triangle { <-5.5731, 365.1957, -44.8983>, <-2.31, 365.5292, -43.8062>, <-3.3071, 365.709, -44.1801> }
					triangle { <-3.5642, 368.3296, -38.2156>, <-3.8189, 368.4805, -40.1989>, <-2.4267, 366.0806, -43.9256> }
					triangle { <-3.6067, 366.4243, -37.8067>, <-3.5993, 366.5125, -36.9563>, <-3.5642, 368.3296, -38.2156> }
					triangle { <-3.5642, 368.3296, -38.2156>, <-2.4267, 366.0806, -43.9256>, <-3.6067, 366.4243, -37.8067> }
					triangle { <-2.31, 365.5292, -43.8062>, <-3.6067, 366.4243, -37.8067>, <-2.4267, 366.0806, -43.9256> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-23.5131, 359.0927, -52.9263>, <-22.5039, 360.6116, -51.4374>, 0.2999 }
			cylinder { <-22.5039, 360.6116, -51.4374>, <-21.5689, 362.1589, -49.9294>, 0.2999 }
			cylinder { <-21.5689, 362.1589, -49.9294>, <-20.7092, 363.7327, -48.404>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.7092, 363.7327, -48.404>, <-19.4877, 369.6825, -44.7996>, 0.2999 }
				cylinder { <-19.4877, 369.6825, -44.7996>, <-19.7289, 376.3482, -42.4774>, 0.2999 }
				cylinder { <-19.7289, 376.3482, -42.4774>, <-21.412, 383.1558, -41.6373>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-21.412, 383.1558, -41.6373>, <-21.9707, 383.7634, -41.708>, <-22.2472, 385.4324, -41.4534> }
					triangle { <-21.9707, 383.7634, -41.708>, <-22.7325, 386.2939, -41.4442>, <-22.2472, 385.4324, -41.4534> }
					triangle { <-22.7325, 386.2939, -41.4442>, <-22.2359, 386.488, -41.226>, <-22.2472, 385.4324, -41.4534> }
					triangle { <-22.2472, 385.4324, -41.4534>, <-22.2359, 386.488, -41.226>, <-21.412, 383.1558, -41.6373> }
					triangle { <-22.7325, 386.2939, -41.4442>, <-23.1249, 386.8669, -46.07704>, <-22.2316, 388.1338, -47.3873> }
					triangle { <-22.2316, 388.1338, -47.3873>, <-20.234, 388.8443, -47.5499>, <-20.3883, 388.4216, -46.8228> }
					triangle { <-20.3883, 388.4216, -46.8228>, <-22.7325, 386.2939, -41.4442>, <-22.2316, 388.1338, -47.3873> }
					triangle { <-22.7325, 386.2939, -41.4442>, <-20.3883, 388.4216, -46.8228>, <-22.2359, 386.488, -41.226> }
					triangle { <-21.728, 385.5352, -41.2465>, <-21.1919, 383.9176, -41.3976>, <-21.412, 383.1558, -41.6373> }
					triangle { <-21.728, 385.5352, -41.2465>, <-21.6941, 386.4996, -41.03043>, <-21.1919, 383.9176, -41.3976> }
					triangle { <-21.728, 385.5352, -41.2465>, <-22.2359, 386.488, -41.226>, <-21.6941, 386.4996, -41.03043> }
					triangle { <-21.412, 383.1558, -41.6373>, <-22.2359, 386.488, -41.226>, <-21.728, 385.5352, -41.2465> }
					triangle { <-18.6837, 388.8365, -45.9733>, <-18.6252, 387.7581, -44.2837>, <-21.6941, 386.4996, -41.03043> }
					triangle { <-20.3883, 388.4216, -46.8228>, <-20.234, 388.8443, -47.5499>, <-18.6837, 388.8365, -45.9733> }
					triangle { <-18.6837, 388.8365, -45.9733>, <-21.6941, 386.4996, -41.03043>, <-20.3883, 388.4216, -46.8228> }
					triangle { <-22.2359, 386.488, -41.226>, <-20.3883, 388.4216, -46.8228>, <-21.6941, 386.4996, -41.03043> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-21.412, 383.1558, -41.6373>, <-21.8368, 383.7372, -41.2276>, <-22.1579, 385.4149, -41.1332> }
					triangle { <-21.8368, 383.7372, -41.2276>, <-22.5539, 386.259, -40.8038>, <-22.1579, 385.4149, -41.1332> }
					triangle { <-22.5539, 386.259, -40.8038>, <-22.2359, 386.488, -41.226>, <-22.1579, 385.4149, -41.1332> }
					triangle { <-22.1579, 385.4149, -41.1332>, <-22.2359, 386.488, -41.226>, <-21.412, 383.1558, -41.6373> }
					triangle { <-22.5539, 386.259, -40.8038>, <-26.9973, 385.4088, -42.01982>, <-28.1987, 386.1745, -43.4654> }
					triangle { <-28.1987, 386.1745, -43.4654>, <-27.8322, 386.7115, -45.4899>, <-27.1209, 386.5381, -45.0483> }
					triangle { <-27.1209, 386.5381, -45.0483>, <-22.5539, 386.259, -40.8038>, <-28.1987, 386.1745, -43.4654> }
					triangle { <-22.5539, 386.259, -40.8038>, <-27.1209, 386.5381, -45.0483>, <-22.2359, 386.488, -41.226> }
					triangle { <-21.8173, 385.5527, -41.5667>, <-21.3258, 383.9438, -41.8779>, <-21.412, 383.1558, -41.6373> }
					triangle { <-21.8173, 385.5527, -41.5667>, <-21.8727, 386.5345, -41.6708>, <-21.3258, 383.9438, -41.8779> }
					triangle { <-21.8173, 385.5527, -41.5667>, <-22.2359, 386.488, -41.226>, <-21.8727, 386.5345, -41.6708> }
					triangle { <-21.412, 383.1558, -41.6373>, <-22.2359, 386.488, -41.226>, <-21.8173, 385.5527, -41.5667> }
					triangle { <-25.8711, 387.1156, -46.428>, <-24.04521, 386.6024, -45.7771>, <-21.8727, 386.5345, -41.6708> }
					triangle { <-27.1209, 386.5381, -45.0483>, <-27.8322, 386.7115, -45.4899>, <-25.8711, 387.1156, -46.428> }
					triangle { <-25.8711, 387.1156, -46.428>, <-21.8727, 386.5345, -41.6708>, <-27.1209, 386.5381, -45.0483> }
					triangle { <-22.2359, 386.488, -41.226>, <-27.1209, 386.5381, -45.0483>, <-21.8727, 386.5345, -41.6708> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-21.412, 383.1558, -41.6373>, <-21.3522, 383.8528, -41.1936>, <-21.8348, 385.492, -41.1105> }
					triangle { <-21.3522, 383.8528, -41.1936>, <-21.9078, 386.4131, -40.7584>, <-21.8348, 385.492, -41.1105> }
					triangle { <-21.9078, 386.4131, -40.7584>, <-22.2359, 386.488, -41.226>, <-21.8348, 385.492, -41.1105> }
					triangle { <-21.8348, 385.492, -41.1105>, <-22.2359, 386.488, -41.226>, <-21.412, 383.1558, -41.6373> }
					triangle { <-21.9078, 386.4131, -40.7584>, <-24.334, 385.4321, -36.873>, <-26.2599, 385.7734, -36.3306> }
					triangle { <-26.2599, 385.7734, -36.3306>, <-28.08948, 385.6504, -37.4071>, <-27.396, 385.5883, -37.9035> }
					triangle { <-27.396, 385.5883, -37.9035>, <-21.9078, 386.4131, -40.7584>, <-26.2599, 385.7734, -36.3306> }
					triangle { <-21.9078, 386.4131, -40.7584>, <-27.396, 385.5883, -37.9035>, <-22.2359, 386.488, -41.226> }
					triangle { <-22.1403, 385.4756, -41.5894>, <-21.8104, 383.8282, -41.9119>, <-21.412, 383.1558, -41.6373> }
					triangle { <-22.1403, 385.4756, -41.5894>, <-22.5188, 386.3803, -41.7162>, <-21.8104, 383.8282, -41.9119> }
					triangle { <-22.1403, 385.4756, -41.5894>, <-22.2359, 386.488, -41.226>, <-22.5188, 386.3803, -41.7162> }
					triangle { <-21.412, 383.1558, -41.6373>, <-22.2359, 386.488, -41.226>, <-22.1403, 385.4756, -41.5894> }
					triangle { <-28.3474, 385.6611, -39.6031>, <-26.9816, 385.2897, -41.02361>, <-22.5188, 386.3803, -41.7162> }
					triangle { <-27.396, 385.5883, -37.9035>, <-28.08948, 385.6504, -37.4071>, <-28.3474, 385.6611, -39.6031> }
					triangle { <-28.3474, 385.6611, -39.6031>, <-22.5188, 386.3803, -41.7162>, <-27.396, 385.5883, -37.9035> }
					triangle { <-22.2359, 386.488, -41.226>, <-27.396, 385.5883, -37.9035>, <-22.5188, 386.3803, -41.7162> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-21.412, 383.1558, -41.6373>, <-21.1821, 383.9515, -41.6526>, <-21.7214, 385.5578, -41.4165> }
					triangle { <-21.1821, 383.9515, -41.6526>, <-21.681, 386.5448, -41.3704>, <-21.7214, 385.5578, -41.4165> }
					triangle { <-21.681, 386.5448, -41.3704>, <-22.2359, 386.488, -41.226>, <-21.7214, 385.5578, -41.4165> }
					triangle { <-21.7214, 385.5578, -41.4165>, <-22.2359, 386.488, -41.226>, <-21.412, 383.1558, -41.6373> }
					triangle { <-21.681, 386.5448, -41.3704>, <-18.7907, 386.9048, -37.7014>, <-19.07636, 387.481, -35.7762> }
					triangle { <-19.07636, 387.481, -35.7762>, <-20.6526, 387.1175, -34.3961>, <-20.8359, 386.876, -35.1957> }
					triangle { <-20.8359, 386.876, -35.1957>, <-21.681, 386.5448, -41.3704>, <-19.07636, 387.481, -35.7762> }
					triangle { <-21.681, 386.5448, -41.3704>, <-20.8359, 386.876, -35.1957>, <-22.2359, 386.488, -41.226> }
					triangle { <-22.2537, 385.4098, -41.2834>, <-21.9805, 383.7295, -41.4529>, <-21.412, 383.1558, -41.6373> }
					triangle { <-22.2537, 385.4098, -41.2834>, <-22.7456, 386.2487, -41.1042>, <-21.9805, 383.7295, -41.4529> }
					triangle { <-22.2537, 385.4098, -41.2834>, <-22.2359, 386.488, -41.226>, <-22.7456, 386.2487, -41.1042> }
					triangle { <-21.412, 383.1558, -41.6373>, <-22.2359, 386.488, -41.226>, <-22.2537, 385.4098, -41.2834> }
					triangle { <-22.7136, 386.4695, -34.8667>, <-23.4039, 385.6219, -36.5479>, <-22.7456, 386.2487, -41.1042> }
					triangle { <-20.8359, 386.876, -35.1957>, <-20.6526, 387.1175, -34.3961>, <-22.7136, 386.4695, -34.8667> }
					triangle { <-22.7136, 386.4695, -34.8667>, <-22.7456, 386.2487, -41.1042>, <-20.8359, 386.876, -35.1957> }
					triangle { <-22.2359, 386.488, -41.226>, <-20.8359, 386.876, -35.1957>, <-22.7456, 386.2487, -41.1042> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-21.412, 383.1558, -41.6373>, <-21.5701, 383.8954, -41.9753>, <-21.9801, 385.5204, -41.6316> }
					triangle { <-21.5701, 383.8954, -41.9753>, <-22.1984, 386.4699, -41.8007>, <-21.9801, 385.5204, -41.6316> }
					triangle { <-22.1984, 386.4699, -41.8007>, <-22.2359, 386.488, -41.226>, <-21.9801, 385.5204, -41.6316> }
					triangle { <-21.9801, 385.5204, -41.6316>, <-22.2359, 386.488, -41.226>, <-21.412, 383.1558, -41.6373> }
					triangle { <-22.1984, 386.4699, -41.8007>, <-18.03222, 387.8049, -43.4756>, <-16.5491, 388.9619, -42.7128> }
					triangle { <-16.5491, 388.9619, -42.7128>, <-15.7244, 389.1212, -40.7594>, <-16.4395, 388.6535, -40.7913> }
					triangle { <-16.4395, 388.6535, -40.7913>, <-22.1984, 386.4699, -41.8007>, <-16.5491, 388.9619, -42.7128> }
					triangle { <-22.1984, 386.4699, -41.8007>, <-16.4395, 388.6535, -40.7913>, <-22.2359, 386.488, -41.226> }
					triangle { <-21.995, 385.4472, -41.06833>, <-21.5925, 383.7856, -41.1302>, <-21.412, 383.1558, -41.6373> }
					triangle { <-21.995, 385.4472, -41.06833>, <-22.2282, 386.3235, -40.6739>, <-21.5925, 383.7856, -41.1302> }
					triangle { <-21.995, 385.4472, -41.06833>, <-22.2359, 386.488, -41.226>, <-22.2282, 386.3235, -40.6739> }
					triangle { <-21.412, 383.1558, -41.6373>, <-22.2359, 386.488, -41.226>, <-21.995, 385.4472, -41.06833> }
					triangle { <-16.6509, 388.4616, -38.8632>, <-18.1613, 387.1705, -38.5932>, <-22.2282, 386.3235, -40.6739> }
					triangle { <-16.4395, 388.6535, -40.7913>, <-15.7244, 389.1212, -40.7594>, <-16.6509, 388.4616, -38.8632> }
					triangle { <-16.6509, 388.4616, -38.8632>, <-22.2282, 386.3235, -40.6739>, <-16.4395, 388.6535, -40.7913> }
					triangle { <-22.2359, 386.488, -41.226>, <-16.4395, 388.6535, -40.7913>, <-22.2282, 386.3235, -40.6739> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-20.7092, 363.7327, -48.404>, <-19.7977, 365.2496, -46.8514>, 0.2999 }
			cylinder { <-19.7977, 365.2496, -46.8514>, <-18.8353, 366.7077, -45.2733>, 0.2999 }
			cylinder { <-18.8353, 366.7077, -45.2733>, <-17.8233, 368.1054, -43.6717>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-17.8233, 368.1054, -43.6717>, <-15.02713, 370.6098, -37.6891>, 0.2999 }
				cylinder { <-15.02713, 370.6098, -37.6891>, <-12.7113, 371.21, -31.0439>, 0.2999 }
				cylinder { <-12.7113, 371.21, -31.0439>, <-11.07544, 369.8544, -24.3082>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.07544, 369.8544, -24.3082>, <-10.9158, 369.3625, -23.7053>, <-10.5819, 369.2869, -22.1012> }
					triangle { <-10.9158, 369.3625, -23.7053>, <-10.3811, 368.9005, -21.259>, <-10.5819, 369.2869, -22.1012> }
					triangle { <-10.3811, 368.9005, -21.259>, <-10.3862, 369.4278, -21.09428>, <-10.5819, 369.2869, -22.1012> }
					triangle { <-10.5819, 369.2869, -22.1012>, <-10.3862, 369.4278, -21.09428>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-10.3811, 368.9005, -21.259>, <-14.2735, 366.7537, -20.6156>, <-15.7691, 367.0666, -19.4104> }
					triangle { <-15.7691, 367.0666, -19.4104>, <-16.6986, 368.7743, -18.7971>, <-16.00304, 368.9098, -19.2093> }
					triangle { <-16.00304, 368.9098, -19.2093>, <-10.3811, 368.9005, -21.259>, <-15.7691, 367.0666, -19.4104> }
					triangle { <-10.3811, 368.9005, -21.259>, <-16.00304, 368.9098, -19.2093>, <-10.3862, 369.4278, -21.09428> }
					triangle { <-10.6059, 369.8258, -22.02454>, <-10.9518, 370.1709, -23.5903>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-10.6059, 369.8258, -22.02454>, <-10.429, 369.9784, -21.1056>, <-10.9518, 370.1709, -23.5903> }
					triangle { <-10.6059, 369.8258, -22.02454>, <-10.3862, 369.4278, -21.09428>, <-10.429, 369.9784, -21.1056> }
					triangle { <-11.07544, 369.8544, -24.3082>, <-10.3862, 369.4278, -21.09428>, <-10.6059, 369.8258, -22.02454> }
					triangle { <-15.9329, 370.7492, -18.8865>, <-14.4812, 371.4243, -19.9511>, <-10.429, 369.9784, -21.1056> }
					triangle { <-16.00304, 368.9098, -19.2093>, <-16.6986, 368.7743, -18.7971>, <-15.9329, 370.7492, -18.8865> }
					triangle { <-15.9329, 370.7492, -18.8865>, <-10.429, 369.9784, -21.1056>, <-16.00304, 368.9098, -19.2093> }
					triangle { <-10.3862, 369.4278, -21.09428>, <-16.00304, 368.9098, -19.2093>, <-10.429, 369.9784, -21.1056> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-11.07544, 369.8544, -24.3082>, <-10.549, 369.6678, -23.7434>, <-10.3374, 369.4904, -22.1266> }
					triangle { <-10.549, 369.6678, -23.7434>, <-9.892, 369.3076, -21.3098>, <-10.3374, 369.4904, -22.1266> }
					triangle { <-9.892, 369.3076, -21.3098>, <-10.3862, 369.4278, -21.09428>, <-10.3374, 369.4904, -22.1266> }
					triangle { <-10.3374, 369.4904, -22.1266>, <-10.3862, 369.4278, -21.09428>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-9.892, 369.3076, -21.3098>, <-9.202, 364.9154, -21.9471>, <-9.9899, 363.3264, -21.1462> }
					triangle { <-9.9899, 363.3264, -21.1462>, <-11.9028, 362.8692, -20.6093>, <-11.7978, 363.6576, -20.8082> }
					triangle { <-11.7978, 363.6576, -20.8082>, <-9.892, 369.3076, -21.3098>, <-9.9899, 363.3264, -21.1462> }
					triangle { <-9.892, 369.3076, -21.3098>, <-11.7978, 363.6576, -20.8082>, <-10.3862, 369.4278, -21.09428> }
					triangle { <-10.8504, 369.6223, -21.9991>, <-11.3186, 369.8656, -23.5522>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-10.8504, 369.6223, -21.9991>, <-10.9181, 369.5713, -21.05481>, <-11.3186, 369.8656, -23.5522> }
					triangle { <-10.8504, 369.6223, -21.9991>, <-10.3862, 369.4278, -21.09428>, <-10.9181, 369.5713, -21.05481> }
					triangle { <-11.07544, 369.8544, -24.3082>, <-10.3862, 369.4278, -21.09428>, <-10.8504, 369.6223, -21.9991> }
					triangle { <-13.4959, 364.2273, -20.2748>, <-13.6486, 366.0581, -20.8419>, <-10.9181, 369.5713, -21.05481> }
					triangle { <-11.7978, 363.6576, -20.8082>, <-11.9028, 362.8692, -20.6093>, <-13.4959, 364.2273, -20.2748> }
					triangle { <-13.4959, 364.2273, -20.2748>, <-10.9181, 369.5713, -21.05481>, <-11.7978, 363.6576, -20.8082> }
					triangle { <-10.3862, 369.4278, -21.09428>, <-11.7978, 363.6576, -20.8082>, <-10.9181, 369.5713, -21.05481> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-11.07544, 369.8544, -24.3082>, <-10.7103, 370.1089, -23.6503>, <-10.4449, 369.7844, -22.06454> }
					triangle { <-10.7103, 370.1089, -23.6503>, <-10.1072, 369.8957, -21.1856>, <-10.4449, 369.7844, -22.06454> }
					triangle { <-10.1072, 369.8957, -21.1856>, <-10.3862, 369.4278, -21.09428>, <-10.4449, 369.7844, -22.06454> }
					triangle { <-10.4449, 369.7844, -22.06454>, <-10.3862, 369.4278, -21.09428>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-10.1072, 369.8957, -21.1856>, <-5.756, 369.271, -22.1079>, <-4.5214, 367.8168, -21.7228> }
					triangle { <-4.5214, 367.8168, -21.7228>, <-4.7401, 365.7902, -21.7576>, <-5.4476, 366.1974, -21.8328> }
					triangle { <-5.4476, 366.1974, -21.8328>, <-10.1072, 369.8957, -21.1856>, <-4.5214, 367.8168, -21.7228> }
					triangle { <-10.1072, 369.8957, -21.1856>, <-5.4476, 366.1974, -21.8328>, <-10.3862, 369.4278, -21.09428> }
					triangle { <-10.7428, 369.3282, -22.06121>, <-11.1572, 369.4246, -23.6453>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-10.7428, 369.3282, -22.06121>, <-10.703, 368.9832, -21.179>, <-11.1572, 369.4246, -23.6453> }
					triangle { <-10.7428, 369.3282, -22.06121>, <-10.3862, 369.4278, -21.09428>, <-10.703, 368.9832, -21.179> }
					triangle { <-11.07544, 369.8544, -24.3082>, <-10.3862, 369.4278, -21.09428>, <-10.7428, 369.3282, -22.06121> }
					triangle { <-6.5571, 364.6994, -21.7001>, <-8.3379, 365.3172, -22.07912>, <-10.703, 368.9832, -21.179> }
					triangle { <-5.4476, 366.1974, -21.8328>, <-4.7401, 365.7902, -21.7576>, <-6.5571, 364.6994, -21.7001> }
					triangle { <-6.5571, 364.6994, -21.7001>, <-10.703, 368.9832, -21.179>, <-5.4476, 366.1974, -21.8328> }
					triangle { <-10.3862, 369.4278, -21.09428>, <-5.4476, 366.1974, -21.8328>, <-10.703, 368.9832, -21.179> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-11.07544, 369.8544, -24.3082>, <-11.1784, 370.0803, -23.5537>, <-10.757, 369.7654, -22.00016> }
					triangle { <-11.1784, 370.0803, -23.5537>, <-10.7312, 369.8575, -21.0569>, <-10.757, 369.7654, -22.00016> }
					triangle { <-10.7312, 369.8575, -21.0569>, <-10.3862, 369.4278, -21.09428>, <-10.757, 369.7654, -22.00016> }
					triangle { <-10.757, 369.7654, -22.00016>, <-10.3862, 369.4278, -21.09428>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-10.7312, 369.8575, -21.0569>, <-8.6655, 373.8417, -20.8773>, <-6.8698, 374.3741, -20.3489> }
					triangle { <-6.8698, 374.3741, -20.3489>, <-5.04237, 373.5278, -20.6658>, <-5.6689, 373.043, -20.8767> }
					triangle { <-5.6689, 373.043, -20.8767>, <-10.7312, 369.8575, -21.0569>, <-6.8698, 374.3741, -20.3489> }
					triangle { <-10.7312, 369.8575, -21.0569>, <-5.6689, 373.043, -20.8767>, <-10.3862, 369.4278, -21.09428> }
					triangle { <-10.4308, 369.3473, -22.1255>, <-10.6891, 369.4532, -23.7419>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-10.4308, 369.3473, -22.1255>, <-10.07894, 369.0214, -21.3077>, <-10.6891, 369.4532, -23.7419> }
					triangle { <-10.4308, 369.3473, -22.1255>, <-10.3862, 369.4278, -21.09428>, <-10.07894, 369.0214, -21.3077> }
					triangle { <-11.07544, 369.8544, -24.3082>, <-10.3862, 369.4278, -21.09428>, <-10.4308, 369.3473, -22.1255> }
					triangle { <-4.641, 371.5174, -21.206>, <-5.8387, 370.2187, -21.9644>, <-10.07894, 369.0214, -21.3077> }
					triangle { <-5.6689, 373.043, -20.8767>, <-5.04237, 373.5278, -20.6658>, <-4.641, 371.5174, -21.206> }
					triangle { <-4.641, 371.5174, -21.206>, <-10.07894, 369.0214, -21.3077>, <-5.6689, 373.043, -20.8767> }
					triangle { <-10.3862, 369.4278, -21.09428>, <-5.6689, 373.043, -20.8767>, <-10.07894, 369.0214, -21.3077> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-11.07544, 369.8544, -24.3082>, <-11.3073, 369.612, -23.5882>, <-10.8429, 369.4532, -22.02316> }
					triangle { <-11.3073, 369.612, -23.5882>, <-10.9031, 369.2332, -21.1029>, <-10.8429, 369.4532, -22.02316> }
					triangle { <-10.9031, 369.2332, -21.1029>, <-10.3862, 369.4278, -21.09428>, <-10.8429, 369.4532, -22.02316> }
					triangle { <-10.8429, 369.4532, -22.02316>, <-10.3862, 369.4278, -21.09428>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-10.9031, 369.2332, -21.1029>, <-14.00913, 372.2625, -19.9411>, <-13.9262, 373.9034, -18.8981> }
					triangle { <-13.9262, 373.9034, -18.8981>, <-12.5447, 375.3999, -18.8085>, <-12.291, 374.7447, -19.2308> }
					triangle { <-12.291, 374.7447, -19.2308>, <-10.9031, 369.2332, -21.1029>, <-13.9262, 373.9034, -18.8981> }
					triangle { <-10.9031, 369.2332, -21.1029>, <-12.291, 374.7447, -19.2308>, <-10.3862, 369.4278, -21.09428> }
					triangle { <-10.3449, 369.6595, -22.1025>, <-10.5603, 369.9214, -23.7074>, <-11.07544, 369.8544, -24.3082> }
					triangle { <-10.3449, 369.6595, -22.1025>, <-9.907, 369.6457, -21.2617>, <-10.5603, 369.9214, -23.7074> }
					triangle { <-10.3449, 369.6595, -22.1025>, <-10.3862, 369.4278, -21.09428>, <-9.907, 369.6457, -21.2617> }
					triangle { <-11.07544, 369.8544, -24.3082>, <-10.3862, 369.4278, -21.09428>, <-10.3449, 369.6595, -22.1025> }
					triangle { <-10.523, 375.3128, -19.4409>, <-9.6928, 374.05, -20.6294>, <-9.907, 369.6457, -21.2617> }
					triangle { <-12.291, 374.7447, -19.2308>, <-12.5447, 375.3999, -18.8085>, <-10.523, 375.3128, -19.4409> }
					triangle { <-10.523, 375.3128, -19.4409>, <-9.907, 369.6457, -21.2617>, <-12.291, 374.7447, -19.2308> }
					triangle { <-10.3862, 369.4278, -21.09428>, <-12.291, 374.7447, -19.2308>, <-9.907, 369.6457, -21.2617> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-32.2968, 345.5825, -66.6594>, <-32.6131, 347.9133, -66.7582>, 0.2999 }
			cylinder { <-32.6131, 347.9133, -66.7582>, <-32.9815, 350.233, -66.9191>, 0.2999 }
			cylinder { <-32.9815, 350.233, -66.9191>, <-33.4013, 352.5388, -67.1419>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-33.4013, 352.5388, -67.1419>, <-33.4545, 353.6862, -69.1969>, 0.2999 }
			cylinder { <-33.4545, 353.6862, -69.1969>, <-33.5201, 354.9032, -71.2111>, 0.2999 }
			cylinder { <-33.5201, 354.9032, -71.2111>, <-33.598, 356.1885, -73.1821>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.598, 356.1885, -73.1821>, <-35.4716, 360.8667, -78.1305>, 0.2999 }
				cylinder { <-35.4716, 360.8667, -78.1305>, <-38.8238, 365.9645, -81.6883>, 0.2999 }
				cylinder { <-38.8238, 365.9645, -81.6883>, <-43.366, 371.0428, -83.5492>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-43.366, 371.0428, -83.5492>, <-43.8322, 371.6591, -83.251>, <-44.8923, 372.9314, -83.6803> }
					triangle { <-43.8322, 371.6591, -83.251>, <-45.4997, 373.7028, -83.5619>, <-44.8923, 372.9314, -83.6803> }
					triangle { <-45.4997, 373.7028, -83.5619>, <-45.5302, 373.6739, -84.1365>, <-44.8923, 372.9314, -83.6803> }
					triangle { <-44.8923, 372.9314, -83.6803>, <-45.5302, 373.6739, -84.1365>, <-43.366, 371.0428, -83.5492> }
					triangle { <-45.4997, 373.7028, -83.5619>, <-48.9739, 371.461, -81.3599>, <-50.8423, 370.9156, -81.9358> }
					triangle { <-50.8423, 370.9156, -81.9358>, <-51.6019, 370.1323, -83.7608>, <-50.7952, 370.4099, -83.8176> }
					triangle { <-50.7952, 370.4099, -83.8176>, <-45.4997, 373.7028, -83.5619>, <-50.8423, 370.9156, -81.9358> }
					triangle { <-45.4997, 373.7028, -83.5619>, <-50.7952, 370.4099, -83.8176>, <-45.5302, 373.6739, -84.1365> }
					triangle { <-44.8636, 372.8304, -84.2388>, <-43.7891, 371.5077, -84.08883>, <-43.366, 371.0428, -83.5492> }
					triangle { <-44.8636, 372.8304, -84.2388>, <-45.4421, 373.5008, -84.6789>, <-43.7891, 371.5077, -84.08883> }
					triangle { <-44.8636, 372.8304, -84.2388>, <-45.5302, 373.6739, -84.1365>, <-45.4421, 373.5008, -84.6789> }
					triangle { <-43.366, 371.0428, -83.5492>, <-45.5302, 373.6739, -84.1365>, <-44.8636, 372.8304, -84.2388> }
					triangle { <-50.6456, 370.2255, -85.7522>, <-48.7245, 370.5857, -86.2002>, <-45.4421, 373.5008, -84.6789> }
					triangle { <-50.7952, 370.4099, -83.8176>, <-51.6019, 370.1323, -83.7608>, <-50.6456, 370.2255, -85.7522> }
					triangle { <-50.6456, 370.2255, -85.7522>, <-45.4421, 373.5008, -84.6789>, <-50.7952, 370.4099, -83.8176> }
					triangle { <-45.5302, 373.6739, -84.1365>, <-50.7952, 370.4099, -83.8176>, <-45.4421, 373.5008, -84.6789> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-43.366, 371.0428, -83.5492>, <-43.5025, 371.8596, -83.5679>, <-44.6725, 373.0651, -83.8915> }
					triangle { <-43.5025, 371.8596, -83.5679>, <-45.06005, 373.9701, -83.9845>, <-44.6725, 373.0651, -83.8915> }
					triangle { <-45.06005, 373.9701, -83.9845>, <-45.5302, 373.6739, -84.1365>, <-44.6725, 373.0651, -83.8915> }
					triangle { <-44.6725, 373.0651, -83.8915>, <-45.5302, 373.6739, -84.1365>, <-43.366, 371.0428, -83.5492> }
					triangle { <-45.06005, 373.9701, -83.9845>, <-44.9608, 375.1857, -79.4615>, <-46.4173, 375.4189, -78.06719> }
					triangle { <-46.4173, 375.4189, -78.06719>, <-48.1821, 374.3098, -77.6471>, <-47.8033, 374.0846, -78.3798> }
					triangle { <-47.8033, 374.0846, -78.3798>, <-45.06005, 373.9701, -83.9845>, <-46.4173, 375.4189, -78.06719> }
					triangle { <-45.06005, 373.9701, -83.9845>, <-47.8033, 374.0846, -78.3798>, <-45.5302, 373.6739, -84.1365> }
					triangle { <-45.08342, 372.6968, -84.02754>, <-44.1188, 371.3072, -83.7719>, <-43.366, 371.0428, -83.5492> }
					triangle { <-45.08342, 372.6968, -84.02754>, <-45.8817, 373.2335, -84.2564>, <-44.1188, 371.3072, -83.7719> }
					triangle { <-45.08342, 372.6968, -84.02754>, <-45.5302, 373.6739, -84.1365>, <-45.8817, 373.2335, -84.2564> }
					triangle { <-43.366, 371.0428, -83.5492>, <-45.5302, 373.6739, -84.1365>, <-45.08342, 372.6968, -84.02754> }
					triangle { <-49.2249, 372.9021, -78.9962>, <-48.5217, 371.9937, -80.6398>, <-45.8817, 373.2335, -84.2564> }
					triangle { <-47.8033, 374.0846, -78.3798>, <-48.1821, 374.3098, -77.6471>, <-49.2249, 372.9021, -78.9962> }
					triangle { <-49.2249, 372.9021, -78.9962>, <-45.8817, 373.2335, -84.2564>, <-47.8033, 374.0846, -78.3798> }
					triangle { <-45.5302, 373.6739, -84.1365>, <-47.8033, 374.0846, -78.3798>, <-45.8817, 373.2335, -84.2564> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-43.366, 371.0428, -83.5492>, <-43.5957, 371.6809, -84.02486>, <-44.7347, 372.946, -84.1961> }
					triangle { <-43.5957, 371.6809, -84.02486>, <-45.1843, 373.7318, -84.5936>, <-44.7347, 372.946, -84.1961> }
					triangle { <-45.1843, 373.7318, -84.5936>, <-45.5302, 373.6739, -84.1365>, <-44.7347, 372.946, -84.1961> }
					triangle { <-44.7347, 372.946, -84.1961>, <-45.5302, 373.6739, -84.1365>, <-43.366, 371.0428, -83.5492> }
					triangle { <-45.1843, 373.7318, -84.5936>, <-41.7292, 376.8352, -83.9802>, <-41.5071, 378.4174, -82.7283> }
					triangle { <-41.5071, 378.4174, -82.7283>, <-42.01746, 378.7028, -80.6839>, <-42.3423, 377.9871, -81.02058> }
					triangle { <-42.3423, 377.9871, -81.02058>, <-45.1843, 373.7318, -84.5936>, <-41.5071, 378.4174, -82.7283> }
					triangle { <-45.1843, 373.7318, -84.5936>, <-42.3423, 377.9871, -81.02058>, <-45.5302, 373.6739, -84.1365> }
					triangle { <-45.02126, 372.8159, -83.7229>, <-44.0256, 371.4858, -83.315>, <-43.366, 371.0428, -83.5492> }
					triangle { <-45.02126, 372.8159, -83.7229>, <-45.7574, 373.4717, -83.6472>, <-44.0256, 371.4858, -83.315> }
					triangle { <-45.02126, 372.8159, -83.7229>, <-45.5302, 373.6739, -84.1365>, <-45.7574, 373.4717, -83.6472> }
					triangle { <-43.366, 371.0428, -83.5492>, <-45.5302, 373.6739, -84.1365>, <-45.02126, 372.8159, -83.7229> }
					triangle { <-43.4651, 377.5285, -79.4947>, <-44.2126, 375.7079, -79.8791>, <-45.7574, 373.4717, -83.6472> }
					triangle { <-42.3423, 377.9871, -81.02058>, <-42.01746, 378.7028, -80.6839>, <-43.4651, 377.5285, -79.4947> }
					triangle { <-43.4651, 377.5285, -79.4947>, <-45.7574, 373.4717, -83.6472>, <-42.3423, 377.9871, -81.02058> }
					triangle { <-45.5302, 373.6739, -84.1365>, <-42.3423, 377.9871, -81.02058>, <-45.7574, 373.4717, -83.6472> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-43.366, 371.0428, -83.5492>, <-43.984, 371.3684, -83.9945>, <-44.9935, 372.7376, -84.1759> }
					triangle { <-43.984, 371.3684, -83.9945>, <-45.702, 373.3151, -84.5532>, <-44.9935, 372.7376, -84.1759> }
					triangle { <-45.702, 373.3151, -84.5532>, <-45.5302, 373.6739, -84.1365>, <-44.9935, 372.7376, -84.1759> }
					triangle { <-44.9935, 372.7376, -84.1759>, <-45.5302, 373.6739, -84.1365>, <-43.366, 371.0428, -83.5492> }
					triangle { <-45.702, 373.3151, -84.5532>, <-43.715, 374.1454, -88.7135>, <-42.8517, 375.7952, -89.5212> }
					triangle { <-42.8517, 375.7952, -89.5212>, <-41.5697, 377.2813, -88.7029>, <-41.9082, 376.7607, -88.1151> }
					triangle { <-41.9082, 376.7607, -88.1151>, <-45.702, 373.3151, -84.5532>, <-42.8517, 375.7952, -89.5212> }
					triangle { <-45.702, 373.3151, -84.5532>, <-41.9082, 376.7607, -88.1151>, <-45.5302, 373.6739, -84.1365> }
					triangle { <-44.7624, 373.0243, -83.7431>, <-43.6373, 371.7984, -83.3453>, <-43.366, 371.0428, -83.5492> }
					triangle { <-44.7624, 373.0243, -83.7431>, <-45.2398, 373.8885, -83.6876>, <-43.6373, 371.7984, -83.3453> }
					triangle { <-44.7624, 373.0243, -83.7431>, <-45.5302, 373.6739, -84.1365>, <-45.2398, 373.8885, -83.6876> }
					triangle { <-43.366, 371.0428, -83.5492>, <-45.5302, 373.6739, -84.1365>, <-44.7624, 373.0243, -83.7431> }
					triangle { <-41.2725, 377.7544, -86.5635>, <-41.7121, 376.6301, -84.9623>, <-45.2398, 373.8885, -83.6876> }
					triangle { <-41.9082, 376.7607, -88.1151>, <-41.5697, 377.2813, -88.7029>, <-41.2725, 377.7544, -86.5635> }
					triangle { <-41.2725, 377.7544, -86.5635>, <-45.2398, 373.8885, -83.6876>, <-41.9082, 376.7607, -88.1151> }
					triangle { <-45.5302, 373.6739, -84.1365>, <-41.9082, 376.7607, -88.1151>, <-45.2398, 373.8885, -83.6876> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-43.366, 371.0428, -83.5492>, <-44.1323, 371.3547, -83.5091>, <-45.09245, 372.7285, -83.8523> }
					triangle { <-44.1323, 371.3547, -83.5091>, <-45.8998, 373.2968, -83.906>, <-45.09245, 372.7285, -83.8523> }
					triangle { <-45.8998, 373.2968, -83.906>, <-45.5302, 373.6739, -84.1365>, <-45.09245, 372.7285, -83.8523> }
					triangle { <-45.09245, 372.7285, -83.8523>, <-45.5302, 373.6739, -84.1365>, <-43.366, 371.0428, -83.5492> }
					triangle { <-45.8998, 373.2968, -83.906>, <-48.26, 370.7737, -87.06963>, <-48.7082, 371.0889, -89.02402> }
					triangle { <-48.7082, 371.0889, -89.02402>, <-47.5827, 371.9044, -90.6332>, <-47.2113, 372.007, -89.8699> }
					triangle { <-47.2113, 372.007, -89.8699>, <-45.8998, 373.2968, -83.906>, <-48.7082, 371.0889, -89.02402> }
					triangle { <-45.8998, 373.2968, -83.906>, <-47.2113, 372.007, -89.8699>, <-45.5302, 373.6739, -84.1365> }
					triangle { <-44.6635, 373.0334, -84.06678>, <-43.489, 371.8121, -83.8307>, <-43.366, 371.0428, -83.5492> }
					triangle { <-44.6635, 373.0334, -84.06678>, <-45.042, 373.9067, -84.3348>, <-43.489, 371.8121, -83.8307> }
					triangle { <-44.6635, 373.0334, -84.06678>, <-45.5302, 373.6739, -84.1365>, <-45.042, 373.9067, -84.3348> }
					triangle { <-43.366, 371.0428, -83.5492>, <-45.5302, 373.6739, -84.1365>, <-44.6635, 373.0334, -84.06678> }
					triangle { <-45.7772, 373.1727, -90.4892>, <-44.5427, 373.4167, -88.9279>, <-45.042, 373.9067, -84.3348> }
					triangle { <-47.2113, 372.007, -89.8699>, <-47.5827, 371.9044, -90.6332>, <-45.7772, 373.1727, -90.4892> }
					triangle { <-45.7772, 373.1727, -90.4892>, <-45.042, 373.9067, -84.3348>, <-47.2113, 372.007, -89.8699> }
					triangle { <-45.5302, 373.6739, -84.1365>, <-47.2113, 372.007, -89.8699>, <-45.042, 373.9067, -84.3348> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-33.598, 356.1885, -73.1821>, <-33.6125, 357.4309, -75.1817>, 0.2999 }
			cylinder { <-33.6125, 357.4309, -75.1817>, <-33.5637, 358.629, -77.2078>, 0.2999 }
			cylinder { <-33.5637, 358.629, -77.2078>, <-33.4515, 359.7813, -79.2577>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.4515, 359.7813, -79.2577>, <-31.09223, 363.2239, -84.9555>, 0.2999 }
				cylinder { <-31.09223, 363.2239, -84.9555>, <-26.9133, 366.3555, -89.7108>, 0.2999 }
				cylinder { <-26.9133, 366.3555, -89.7108>, <-21.2748, 368.9065, -93.1141>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-21.2748, 368.9065, -93.1141>, <-20.4622, 368.8682, -93.2707>, <-19.1829, 369.5822, -94.1541> }
					triangle { <-20.4622, 368.8682, -93.2707>, <-18.2631, 369.7278, -94.4867>, <-19.1829, 369.5822, -94.1541> }
					triangle { <-18.2631, 369.7278, -94.4867>, <-18.5148, 370.1551, -94.7799>, <-19.1829, 369.5822, -94.1541> }
					triangle { <-19.1829, 369.5822, -94.1541>, <-18.5148, 370.1551, -94.7799>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-18.2631, 369.7278, -94.4867>, <-16.3192, 371.0839, -90.446>, <-15.6576, 372.8806, -89.7721> }
					triangle { <-15.6576, 372.8806, -89.7721>, <-16.4306, 374.8516, -89.9685>, <-16.8264, 374.2784, -90.4643> }
					triangle { <-16.8264, 374.2784, -90.4643>, <-18.2631, 369.7278, -94.4867>, <-15.6576, 372.8806, -89.7721> }
					triangle { <-18.2631, 369.7278, -94.4867>, <-16.8264, 374.2784, -90.4643>, <-18.5148, 370.1551, -94.7799> }
					triangle { <-19.5102, 369.9754, -94.4016>, <-20.9531, 369.4579, -93.642>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-19.5102, 369.9754, -94.4016>, <-18.9177, 370.514, -94.9818>, <-20.9531, 369.4579, -93.642> }
					triangle { <-19.5102, 369.9754, -94.4016>, <-18.5148, 370.1551, -94.7799>, <-18.9177, 370.514, -94.9818> }
					triangle { <-21.2748, 368.9065, -93.1141>, <-18.5148, 370.1551, -94.7799>, <-19.5102, 369.9754, -94.4016> }
					triangle { <-17.894, 375.5669, -91.4638>, <-19.1556, 374.491, -92.5916>, <-18.9177, 370.514, -94.9818> }
					triangle { <-16.8264, 374.2784, -90.4643>, <-16.4306, 374.8516, -89.9685>, <-17.894, 375.5669, -91.4638> }
					triangle { <-17.894, 375.5669, -91.4638>, <-18.9177, 370.514, -94.9818>, <-16.8264, 374.2784, -90.4643> }
					triangle { <-18.5148, 370.1551, -94.7799>, <-16.8264, 374.2784, -90.4643>, <-18.9177, 370.514, -94.9818> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-21.2748, 368.9065, -93.1141>, <-20.7019, 368.8175, -93.7058>, <-19.3427, 369.5485, -94.4441> }
					triangle { <-20.7019, 368.8175, -93.7058>, <-18.5827, 369.6602, -95.06688>, <-19.3427, 369.5485, -94.4441> }
					triangle { <-18.5827, 369.6602, -95.06688>, <-18.5148, 370.1551, -94.7799>, <-19.3427, 369.5485, -94.4441> }
					triangle { <-19.3427, 369.5485, -94.4441>, <-18.5148, 370.1551, -94.7799>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-18.5827, 369.6602, -95.06688>, <-15.9148, 366.1566, -93.4693>, <-14.1871, 366.1179, -92.4048> }
					triangle { <-14.1871, 366.1179, -92.4048>, <-13.4913, 367.2857, -90.7698>, <-14.2034, 367.5924, -91.1301> }
					triangle { <-14.2034, 367.5924, -91.1301>, <-18.5827, 369.6602, -95.06688>, <-14.1871, 366.1179, -92.4048> }
					triangle { <-18.5827, 369.6602, -95.06688>, <-14.2034, 367.5924, -91.1301>, <-18.5148, 370.1551, -94.7799> }
					triangle { <-19.3504, 370.0092, -94.1116>, <-20.7134, 369.5086, -93.2069>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-19.3504, 370.0092, -94.1116>, <-18.5981, 370.5816, -94.4016>, <-20.7134, 369.5086, -93.2069> }
					triangle { <-19.3504, 370.0092, -94.1116>, <-18.5148, 370.1551, -94.7799>, <-18.5981, 370.5816, -94.4016> }
					triangle { <-21.2748, 368.9065, -93.1141>, <-18.5148, 370.1551, -94.7799>, <-19.3504, 370.0092, -94.1116> }
					triangle { <-14.2396, 369.2662, -90.1321>, <-15.9815, 370.1496, -90.5868>, <-18.5981, 370.5816, -94.4016> }
					triangle { <-14.2034, 367.5924, -91.1301>, <-13.4913, 367.2857, -90.7698>, <-14.2396, 369.2662, -90.1321> }
					triangle { <-14.2396, 369.2662, -90.1321>, <-18.5981, 370.5816, -94.4016>, <-14.2034, 367.5924, -91.1301> }
					triangle { <-18.5148, 370.1551, -94.7799>, <-14.2034, 367.5924, -91.1301>, <-18.5981, 370.5816, -94.4016> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-21.2748, 368.9065, -93.1141>, <-20.9495, 369.2411, -93.7985>, <-19.5078, 369.8308, -94.506> }
					triangle { <-20.9495, 369.2411, -93.7985>, <-18.9129, 370.225, -95.1905>, <-19.5078, 369.8308, -94.506> }
					triangle { <-18.9129, 370.225, -95.1905>, <-18.5148, 370.1551, -94.7799>, <-19.5078, 369.8308, -94.506> }
					triangle { <-19.5078, 369.8308, -94.506>, <-18.5148, 370.1551, -94.7799>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-18.9129, 370.225, -95.1905>, <-19.07929, 366.7178, -98.2916>, <-17.7228, 365.3195, -98.8614> }
					triangle { <-17.7228, 365.3195, -98.8614>, <-16.3057, 364.175, -97.7645>, <-16.6681, 364.7998, -97.3069> }
					triangle { <-16.6681, 364.7998, -97.3069>, <-18.9129, 370.225, -95.1905>, <-17.7228, 365.3195, -98.8614> }
					triangle { <-18.9129, 370.225, -95.1905>, <-16.6681, 364.7998, -97.3069>, <-18.5148, 370.1551, -94.7799> }
					triangle { <-19.1853, 369.7268, -94.04978>, <-20.4658, 369.085, -93.1142>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-19.1853, 369.7268, -94.04978>, <-18.268, 370.0168, -94.278>, <-20.4658, 369.085, -93.1142> }
					triangle { <-19.1853, 369.7268, -94.04978>, <-18.5148, 370.1551, -94.7799>, <-18.268, 370.0168, -94.278> }
					triangle { <-21.2748, 368.9065, -93.1141>, <-18.5148, 370.1551, -94.7799>, <-19.1853, 369.7268, -94.04978> }
					triangle { <-15.5194, 364.6083, -95.7439>, <-16.2847, 365.8157, -94.3376>, <-18.268, 370.0168, -94.278> }
					triangle { <-16.6681, 364.7998, -97.3069>, <-16.3057, 364.175, -97.7645>, <-15.5194, 364.6083, -95.7439> }
					triangle { <-15.5194, 364.6083, -95.7439>, <-18.268, 370.0168, -94.278>, <-16.6681, 364.7998, -97.3069> }
					triangle { <-18.5148, 370.1551, -94.7799>, <-16.6681, 364.7998, -97.3069>, <-18.268, 370.0168, -94.278> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-21.2748, 368.9065, -93.1141>, <-20.8651, 369.5576, -93.4216>, <-19.4516, 370.0418, -94.2547> }
					triangle { <-20.8651, 369.5576, -93.4216>, <-18.8004, 370.6469, -94.6879>, <-19.4516, 370.0418, -94.2547> }
					triangle { <-18.8004, 370.6469, -94.6879>, <-18.5148, 370.1551, -94.7799>, <-19.4516, 370.0418, -94.2547> }
					triangle { <-19.4516, 370.0418, -94.2547>, <-18.5148, 370.1551, -94.7799>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-18.8004, 370.6469, -94.6879>, <-21.4689, 371.9972, -98.2935>, <-21.4116, 371.5812, -100.2794> }
					triangle { <-21.4116, 371.5812, -100.2794>, <-21.01077, 369.7893, -101.3516>, <-20.8373, 369.7337, -100.5162> }
					triangle { <-20.8373, 369.7337, -100.5162>, <-18.8004, 370.6469, -94.6879>, <-21.4116, 371.5812, -100.2794> }
					triangle { <-18.8004, 370.6469, -94.6879>, <-20.8373, 369.7337, -100.5162>, <-18.5148, 370.1551, -94.7799> }
					triangle { <-19.2416, 369.5158, -94.301>, <-20.5502, 368.7685, -93.4911>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-19.2416, 369.5158, -94.301>, <-18.3804, 369.5949, -94.7806>, <-20.5502, 368.7685, -93.4911> }
					triangle { <-19.2416, 369.5158, -94.301>, <-18.5148, 370.1551, -94.7799>, <-18.3804, 369.5949, -94.7806> }
					triangle { <-21.2748, 368.9065, -93.1141>, <-18.5148, 370.1551, -94.7799>, <-19.2416, 369.5158, -94.301> }
					triangle { <-19.9766, 367.9867, -100.5963>, <-19.649, 367.4383, -98.6955>, <-18.3804, 369.5949, -94.7806> }
					triangle { <-20.8373, 369.7337, -100.5162>, <-21.01077, 369.7893, -101.3516>, <-19.9766, 367.9867, -100.5963> }
					triangle { <-19.9766, 367.9867, -100.5963>, <-18.3804, 369.5949, -94.7806>, <-20.8373, 369.7337, -100.5162> }
					triangle { <-18.5148, 370.1551, -94.7799>, <-20.8373, 369.7337, -100.5162>, <-18.3804, 369.5949, -94.7806> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-21.2748, 368.9065, -93.1141>, <-20.5594, 369.3236, -93.09046>, <-19.2478, 369.8859, -94.03394> }
					triangle { <-20.5594, 369.3236, -93.09046>, <-18.3928, 370.335, -94.2463>, <-19.2478, 369.8859, -94.03394> }
					triangle { <-18.3928, 370.335, -94.2463>, <-18.5148, 370.1551, -94.7799>, <-19.2478, 369.8859, -94.03394> }
					triangle { <-19.2478, 369.8859, -94.03394>, <-18.5148, 370.1551, -94.7799>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-18.3928, 370.335, -94.2463>, <-19.7374, 374.7363, -93.3715>, <-20.1159, 376.3248, -94.5771> }
					triangle { <-20.1159, 376.3248, -94.5771>, <-21.08914, 376.4875, -96.4606>, <-20.9366, 375.6803, -96.2233> }
					triangle { <-20.9366, 375.6803, -96.2233>, <-18.3928, 370.335, -94.2463>, <-20.1159, 376.3248, -94.5771> }
					triangle { <-18.3928, 370.335, -94.2463>, <-20.9366, 375.6803, -96.2233>, <-18.5148, 370.1551, -94.7799> }
					triangle { <-19.4454, 369.6718, -94.5218>, <-20.8559, 369.0025, -93.8223>, <-21.2748, 368.9065, -93.1141> }
					triangle { <-19.4454, 369.6718, -94.5218>, <-18.788, 369.9068, -95.2221>, <-20.8559, 369.0025, -93.8223> }
					triangle { <-19.4454, 369.6718, -94.5218>, <-18.5148, 370.1551, -94.7799>, <-18.788, 369.9068, -95.2221> }
					triangle { <-21.2748, 368.9065, -93.1141>, <-18.5148, 370.1551, -94.7799>, <-19.4454, 369.6718, -94.5218> }
					triangle { <-21.4664, 374.8618, -97.9111>, <-21.4501, 372.8809, -97.6>, <-18.788, 369.9068, -95.2221> }
					triangle { <-20.9366, 375.6803, -96.2233>, <-21.08914, 376.4875, -96.4606>, <-21.4664, 374.8618, -97.9111> }
					triangle { <-21.4664, 374.8618, -97.9111>, <-18.788, 369.9068, -95.2221>, <-20.9366, 375.6803, -96.2233> }
					triangle { <-18.5148, 370.1551, -94.7799>, <-20.9366, 375.6803, -96.2233>, <-18.788, 369.9068, -95.2221> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-33.4515, 359.7813, -79.2577>, <-33.4209, 360.9311, -81.3118>, 0.2999 }
			cylinder { <-33.4209, 360.9311, -81.3118>, <-33.4718, 362.0769, -83.3678>, 0.2999 }
			cylinder { <-33.4718, 362.0769, -83.3678>, <-33.6043, 363.2173, -85.4232>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.6043, 363.2173, -85.4232>, <-35.352, 365.1197, -91.9966>, 0.2999 }
				cylinder { <-35.352, 365.1197, -91.9966>, <-38.2995, 365.3395, -98.4111>, 0.2999 }
				cylinder { <-38.2995, 365.3395, -98.4111>, <-42.193, 363.8578, -104.1145>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-42.193, 363.8578, -104.1145>, <-42.817, 363.4953, -104.5214>, <-43.5177, 363.2589, -106.064> }
					triangle { <-42.817, 363.4953, -104.5214>, <-44.1554, 362.9302, -106.7446>, <-43.5177, 363.2589, -106.064> }
					triangle { <-44.1554, 362.9302, -106.7446>, <-43.811, 363.2219, -107.1027>, <-43.5177, 363.2589, -106.064> }
					triangle { <-43.5177, 363.2589, -106.064>, <-43.811, 363.2219, -107.1027>, <-42.193, 363.8578, -104.1145> }
					triangle { <-44.1554, 362.9302, -106.7446>, <-43.1426, 358.3672, -106.4315>, <-42.1724, 357.0849, -107.6702> }
					triangle { <-42.1724, 357.0849, -107.6702>, <-40.4354, 357.3051, -108.8767>, <-40.7206, 358.0422, -108.5505> }
					triangle { <-40.7206, 358.0422, -108.5505>, <-44.1554, 362.9302, -106.7446>, <-42.1724, 357.0849, -107.6702> }
					triangle { <-44.1554, 362.9302, -106.7446>, <-40.7206, 358.0422, -108.5505>, <-43.811, 363.2219, -107.1027> }
					triangle { <-43.1291, 363.5681, -106.3403>, <-42.2339, 363.959, -104.9357>, <-42.193, 363.8578, -104.1145> }
					triangle { <-43.1291, 363.5681, -106.3403>, <-43.378, 363.5484, -107.2971>, <-42.2339, 363.959, -104.9357> }
					triangle { <-43.1291, 363.5681, -106.3403>, <-43.811, 363.2219, -107.1027>, <-43.378, 363.5484, -107.2971> }
					triangle { <-42.193, 363.8578, -104.1145>, <-43.811, 363.2219, -107.1027>, <-43.1291, 363.5681, -106.3403> }
					triangle { <-39.5164, 359.1973, -109.5579>, <-39.774, 361.0462, -108.8257>, <-43.378, 363.5484, -107.2971> }
					triangle { <-40.7206, 358.0422, -108.5505>, <-40.4354, 357.3051, -108.8767>, <-39.5164, 359.1973, -109.5579> }
					triangle { <-39.5164, 359.1973, -109.5579>, <-43.378, 363.5484, -107.2971>, <-40.7206, 358.0422, -108.5505> }
					triangle { <-43.811, 363.2219, -107.1027>, <-40.7206, 358.0422, -108.5505>, <-43.378, 363.5484, -107.2971> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-42.193, 363.8578, -104.1145>, <-42.8434, 363.9857, -104.6114>, <-43.5353, 363.5859, -106.1241> }
					triangle { <-42.8434, 363.9857, -104.6114>, <-44.1906, 363.5841, -106.8647>, <-43.5353, 363.5859, -106.1241> }
					triangle { <-44.1906, 363.5841, -106.8647>, <-43.811, 363.2219, -107.1027>, <-43.5353, 363.5859, -106.1241> }
					triangle { <-43.5353, 363.5859, -106.1241>, <-43.811, 363.2219, -107.1027>, <-42.193, 363.8578, -104.1145> }
					triangle { <-44.1906, 363.5841, -106.8647>, <-47.703, 361.4488, -104.6179>, <-48.5085, 359.5921, -104.7728> }
					triangle { <-48.5085, 359.5921, -104.7728>, <-47.633, 357.6755, -105.0581>, <-47.08325, 358.3216, -105.1646> }
					triangle { <-47.08325, 358.3216, -105.1646>, <-44.1906, 363.5841, -106.8647>, <-48.5085, 359.5921, -104.7728> }
					triangle { <-44.1906, 363.5841, -106.8647>, <-47.08325, 358.3216, -105.1646>, <-43.811, 363.2219, -107.1027> }
					triangle { <-43.1115, 363.2411, -106.2802>, <-42.2075, 363.4685, -104.8457>, <-42.193, 363.8578, -104.1145> }
					triangle { <-43.1115, 363.2411, -106.2802>, <-43.3428, 362.8945, -107.177>, <-42.2075, 363.4685, -104.8457> }
					triangle { <-43.1115, 363.2411, -106.2802>, <-43.811, 363.2219, -107.1027>, <-43.3428, 362.8945, -107.177> }
					triangle { <-42.193, 363.8578, -104.1145>, <-43.811, 363.2219, -107.1027>, <-43.1115, 363.2411, -106.2802> }
					triangle { <-45.6119, 357.236, -105.8398>, <-44.02941, 358.4604, -105.9712>, <-43.3428, 362.8945, -107.177> }
					triangle { <-47.08325, 358.3216, -105.1646>, <-47.633, 357.6755, -105.0581>, <-45.6119, 357.236, -105.8398> }
					triangle { <-45.6119, 357.236, -105.8398>, <-43.3428, 362.8945, -107.177>, <-47.08325, 358.3216, -105.1646> }
					triangle { <-43.811, 363.2219, -107.1027>, <-47.08325, 358.3216, -105.1646>, <-43.3428, 362.8945, -107.177> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-42.193, 363.8578, -104.1145>, <-42.4334, 364.1212, -104.8623>, <-43.262, 363.6762, -106.2913> }
					triangle { <-42.4334, 364.1212, -104.8623>, <-43.6439, 363.7647, -107.1991>, <-43.262, 363.6762, -106.2913> }
					triangle { <-43.6439, 363.7647, -107.1991>, <-43.811, 363.2219, -107.1027>, <-43.262, 363.6762, -106.2913> }
					triangle { <-43.262, 363.6762, -106.2913>, <-43.811, 363.2219, -107.1027>, <-42.193, 363.8578, -104.1145> }
					triangle { <-43.6439, 363.7647, -107.1991>, <-46.9211, 366.9642, -106.215>, <-48.9443, 366.8664, -106.0849> }
					triangle { <-48.9443, 366.8664, -106.0849>, <-50.2538, 365.396, -105.2821>, <-49.4411, 365.136, -105.338> }
					triangle { <-49.4411, 365.136, -105.338>, <-43.6439, 363.7647, -107.1991>, <-48.9443, 366.8664, -106.0849> }
					triangle { <-43.6439, 363.7647, -107.1991>, <-49.4411, 365.136, -105.338>, <-43.811, 363.2219, -107.1027> }
					triangle { <-43.3848, 363.1508, -106.113>, <-42.6175, 363.333, -104.5948>, <-42.193, 363.8578, -104.1145> }
					triangle { <-43.3848, 363.1508, -106.113>, <-43.8894, 362.7138, -106.8425>, <-42.6175, 363.333, -104.5948> }
					triangle { <-43.3848, 363.1508, -106.113>, <-43.811, 363.2219, -107.1027>, <-43.8894, 362.7138, -106.8425> }
					triangle { <-42.193, 363.8578, -104.1145>, <-43.811, 363.2219, -107.1027>, <-43.3848, 363.1508, -106.113> }
					triangle { <-49.7831, 363.2759, -104.8665>, <-47.985, 362.4104, -104.6698>, <-43.8894, 362.7138, -106.8425> }
					triangle { <-49.4411, 365.136, -105.338>, <-50.2538, 365.396, -105.2821>, <-49.7831, 363.2759, -104.8665> }
					triangle { <-49.7831, 363.2759, -104.8665>, <-43.8894, 362.7138, -106.8425>, <-49.4411, 365.136, -105.338> }
					triangle { <-43.811, 363.2219, -107.1027>, <-49.4411, 365.136, -105.338>, <-43.8894, 362.7138, -106.8425> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-42.193, 363.8578, -104.1145>, <-42.1498, 363.7158, -104.9296>, <-43.07299, 363.4059, -106.3362> }
					triangle { <-42.1498, 363.7158, -104.9296>, <-43.2658, 363.2241, -107.2888>, <-43.07299, 363.4059, -106.3362> }
					triangle { <-43.2658, 363.2241, -107.2888>, <-43.811, 363.2219, -107.1027>, <-43.07299, 363.4059, -106.3362> }
					triangle { <-43.07299, 363.4059, -106.3362>, <-43.811, 363.2219, -107.1027>, <-42.193, 363.8578, -104.1145> }
					triangle { <-43.2658, 363.2241, -107.2888>, <-41.8702, 367.3428, -109.0306>, <-42.8816, 368.9228, -109.8054> }
					triangle { <-42.8816, 368.9228, -109.8054>, <-44.7003, 369.8692, -109.2412>, <-44.5578, 369.1317, -108.8326> }
					triangle { <-44.5578, 369.1317, -108.8326>, <-43.2658, 363.2241, -107.2888>, <-42.8816, 368.9228, -109.8054> }
					triangle { <-43.2658, 363.2241, -107.2888>, <-44.5578, 369.1317, -108.8326>, <-43.811, 363.2219, -107.1027> }
					triangle { <-43.5738, 363.4211, -106.0681>, <-42.9011, 363.7385, -104.5275>, <-42.193, 363.8578, -104.1145> }
					triangle { <-43.5738, 363.4211, -106.0681>, <-44.2676, 363.2545, -106.7528>, <-42.9011, 363.7385, -104.5275> }
					triangle { <-43.5738, 363.4211, -106.0681>, <-43.811, 363.2219, -107.1027>, <-44.2676, 363.2545, -106.7528> }
					triangle { <-42.193, 363.8578, -104.1145>, <-43.811, 363.2219, -107.1027>, <-43.5738, 363.4211, -106.0681> }
					triangle { <-46.3044, 369.0264, -107.974>, <-46.2113, 367.4742, -106.7079>, <-44.2676, 363.2545, -106.7528> }
					triangle { <-44.5578, 369.1317, -108.8326>, <-44.7003, 369.8692, -109.2412>, <-46.3044, 369.0264, -107.974> }
					triangle { <-46.3044, 369.0264, -107.974>, <-44.2676, 363.2545, -106.7528>, <-44.5578, 369.1317, -108.8326> }
					triangle { <-43.811, 363.2219, -107.1027>, <-44.5578, 369.1317, -108.8326>, <-44.2676, 363.2545, -106.7528> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-42.193, 363.8578, -104.1145>, <-42.3904, 363.3231, -104.7157>, <-43.2334, 363.1441, -106.1936> }
					triangle { <-42.3904, 363.3231, -104.7157>, <-43.5867, 362.7006, -107.0036>, <-43.2334, 363.1441, -106.1936> }
					triangle { <-43.5867, 362.7006, -107.0036>, <-43.811, 363.2219, -107.1027>, <-43.2334, 363.1441, -106.1936> }
					triangle { <-43.2334, 363.1441, -106.1936>, <-43.811, 363.2219, -107.1027>, <-42.193, 363.8578, -104.1145> }
					triangle { <-43.5867, 362.7006, -107.0036>, <-39.4997, 361.9493, -109.1664>, <-38.6332, 362.7863, -110.7999> }
					triangle { <-38.6332, 362.7863, -110.7999>, <-38.5406, 364.7932, -111.4963>, <-39.08683, 364.6813, -110.848> }
					triangle { <-39.08683, 364.6813, -110.848>, <-43.5867, 362.7006, -107.0036>, <-38.6332, 362.7863, -110.7999> }
					triangle { <-43.5867, 362.7006, -107.0036>, <-39.08683, 364.6813, -110.848>, <-43.811, 363.2219, -107.1027> }
					triangle { <-43.4134, 363.6829, -106.2107>, <-42.6605, 364.1312, -104.7414>, <-42.193, 363.8578, -104.1145> }
					triangle { <-43.4134, 363.6829, -106.2107>, <-43.9467, 363.778, -107.038>, <-42.6605, 364.1312, -104.7414> }
					triangle { <-43.4134, 363.6829, -106.2107>, <-43.811, 363.2219, -107.1027>, <-43.9467, 363.778, -107.038> }
					triangle { <-42.193, 363.8578, -104.1145>, <-43.811, 363.2219, -107.1027>, <-43.4134, 363.6829, -106.2107> }
					triangle { <-39.8634, 366.4677, -110.9172>, <-41.06008, 366.6184, -109.3151>, <-43.9467, 363.778, -107.038> }
					triangle { <-39.08683, 364.6813, -110.848>, <-38.5406, 364.7932, -111.4963>, <-39.8634, 366.4677, -110.9172> }
					triangle { <-39.8634, 366.4677, -110.9172>, <-43.9467, 363.778, -107.038>, <-39.08683, 364.6813, -110.848> }
					triangle { <-43.811, 363.2219, -107.1027>, <-39.08683, 364.6813, -110.848>, <-43.9467, 363.778, -107.038> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-33.6043, 363.2173, -85.4232>, <-33.6793, 364.4093, -87.452>, 0.2999 }
			cylinder { <-33.6793, 364.4093, -87.452>, <-33.6968, 365.6516, -89.4517>, 0.2999 }
			cylinder { <-33.6968, 365.6516, -89.4517>, <-33.6567, 366.9426, -91.42>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.6567, 366.9426, -91.42>, <-33.5503, 372.3633, -95.9463>, 0.2999 }
				cylinder { <-33.5503, 372.3633, -95.9463>, <-33.467, 378.8648, -98.7043>, 0.2999 }
				cylinder { <-33.467, 378.8648, -98.7043>, <-33.4138, 385.8873, -99.4563>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-33.4138, 385.8873, -99.4563>, <-33.2229, 386.633, -99.1503>, <-33.2719, 388.315, -99.4591> }
					triangle { <-33.2229, 386.633, -99.1503>, <-33.1411, 389.2831, -99.3055>, <-33.2719, 388.315, -99.4591> }
					triangle { <-33.1411, 389.2831, -99.3055>, <-33.3878, 389.3246, -99.8244>, <-33.2719, 388.315, -99.4591> }
					triangle { <-33.2719, 388.315, -99.4591>, <-33.3878, 389.3246, -99.8244>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-33.1411, 389.2831, -99.3055>, <-36.1318, 389.7834, -95.7347>, <-37.9502, 390.6713, -95.5771> }
					triangle { <-37.9502, 390.6713, -95.5771>, <-39.6262, 390.7346, -96.8841>, <-38.9242, 390.4049, -97.2443> }
					triangle { <-38.9242, 390.4049, -97.2443>, <-33.1411, 389.2831, -99.3055>, <-37.9502, 390.6713, -95.5771> }
					triangle { <-33.1411, 389.2831, -99.3055>, <-38.9242, 390.4049, -97.2443>, <-33.3878, 389.3246, -99.8244> }
					triangle { <-33.5194, 388.2624, -99.9679>, <-33.594, 386.5541, -99.9136>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-33.5194, 388.2624, -99.9679>, <-33.6359, 389.1778, -100.3233>, <-33.594, 386.5541, -99.9136> }
					triangle { <-33.5194, 388.2624, -99.9679>, <-33.3878, 389.3246, -99.8244>, <-33.6359, 389.1778, -100.3233> }
					triangle { <-33.4138, 385.8873, -99.4563>, <-33.3878, 389.3246, -99.8244>, <-33.5194, 388.2624, -99.9679> }
					triangle { <-39.641, 390.3117, -99.05447>, <-38.2762, 389.3273, -100.1451>, <-33.6359, 389.1778, -100.3233> }
					triangle { <-38.9242, 390.4049, -97.2443>, <-39.6262, 390.7346, -96.8841>, <-39.641, 390.3117, -99.05447> }
					triangle { <-39.641, 390.3117, -99.05447>, <-33.6359, 389.1778, -100.3233>, <-38.9242, 390.4049, -97.2443> }
					triangle { <-33.3878, 389.3246, -99.8244>, <-38.9242, 390.4049, -97.2443>, <-33.6359, 389.1778, -100.3233> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-33.4138, 385.8873, -99.4563>, <-32.9859, 386.5845, -99.5872>, <-33.114, 388.2826, -99.7503> }
					triangle { <-32.9859, 386.5845, -99.5872>, <-32.8251, 389.2183, -99.8879>, <-33.114, 388.2826, -99.7503> }
					triangle { <-32.8251, 389.2183, -99.8879>, <-33.3878, 389.3246, -99.8244>, <-33.114, 388.2826, -99.7503> }
					triangle { <-33.114, 388.2826, -99.7503>, <-33.3878, 389.3246, -99.8244>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-32.8251, 389.2183, -99.8879>, <-30.3411, 389.7167, -95.9476>, <-30.6684, 390.7597, -94.2374> }
					triangle { <-30.6684, 390.7597, -94.2374>, <-32.4208, 391.0876, -93.07857>, <-32.5754, 390.7219, -93.8358> }
					triangle { <-32.5754, 390.7219, -93.8358>, <-32.8251, 389.2183, -99.8879>, <-30.6684, 390.7597, -94.2374> }
					triangle { <-32.8251, 389.2183, -99.8879>, <-32.5754, 390.7219, -93.8358>, <-33.3878, 389.3246, -99.8244> }
					triangle { <-33.6773, 388.2948, -99.6767>, <-33.831, 386.6027, -99.4768>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-33.6773, 388.2948, -99.6767>, <-33.9519, 389.2426, -99.7408>, <-33.831, 386.6027, -99.4768> }
					triangle { <-33.6773, 388.2948, -99.6767>, <-33.3878, 389.3246, -99.8244>, <-33.9519, 389.2426, -99.7408> }
					triangle { <-33.4138, 385.8873, -99.4563>, <-33.3878, 389.3246, -99.8244>, <-33.6773, 388.2948, -99.6767> }
					triangle { <-34.5181, 390.8427, -93.7345>, <-35.2236, 389.822, -95.3098>, <-33.9519, 389.2426, -99.7408> }
					triangle { <-32.5754, 390.7219, -93.8358>, <-32.4208, 391.0876, -93.07857>, <-34.5181, 390.8427, -93.7345> }
					triangle { <-34.5181, 390.8427, -93.7345>, <-33.9519, 389.2426, -99.7408>, <-32.5754, 390.7219, -93.8358> }
					triangle { <-33.3878, 389.3246, -99.8244>, <-32.5754, 390.7219, -93.8358>, <-33.9519, 389.2426, -99.7408> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-33.4138, 385.8873, -99.4563>, <-33.329, 386.5484, -99.9483>, <-33.3426, 388.2586, -99.991> }
					triangle { <-33.329, 386.5484, -99.9483>, <-33.2825, 389.1702, -100.3694>, <-33.3426, 388.2586, -99.991> }
					triangle { <-33.2825, 389.1702, -100.3694>, <-33.3878, 389.3246, -99.8244>, <-33.3426, 388.2586, -99.991> }
					triangle { <-33.3426, 388.2586, -99.991>, <-33.3878, 389.3246, -99.8244>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-33.2825, 389.1702, -100.3694>, <-28.7324, 389.1118, -101.482>, <-27.1106, 390.0416, -100.6913> }
					triangle { <-27.1106, 390.0416, -100.6913>, <-26.532, 390.4426, -98.6849>, <-27.3339, 390.155, -98.7583> }
					triangle { <-27.3339, 390.155, -98.7583>, <-33.2825, 389.1702, -100.3694>, <-27.1106, 390.0416, -100.6913> }
					triangle { <-33.2825, 389.1702, -100.3694>, <-27.3339, 390.155, -98.7583>, <-33.3878, 389.3246, -99.8244> }
					triangle { <-33.4486, 388.3188, -99.436>, <-33.488, 386.6388, -99.1157>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-33.4486, 388.3188, -99.436>, <-33.4945, 389.2907, -99.2593>, <-33.488, 386.6388, -99.1157> }
					triangle { <-33.4486, 388.3188, -99.436>, <-33.3878, 389.3246, -99.8244>, <-33.4945, 389.2907, -99.2593> }
					triangle { <-33.4138, 385.8873, -99.4563>, <-33.3878, 389.3246, -99.8244>, <-33.4486, 388.3188, -99.436> }
					triangle { <-27.835, 390.4532, -96.8984>, <-29.6511, 389.6339, -96.6715>, <-33.4945, 389.2907, -99.2593> }
					triangle { <-27.3339, 390.155, -98.7583>, <-26.532, 390.4426, -98.6849>, <-27.835, 390.4532, -96.8984> }
					triangle { <-27.835, 390.4532, -96.8984>, <-33.4945, 389.2907, -99.2593>, <-27.3339, 390.155, -98.7583> }
					triangle { <-33.3878, 389.3246, -99.8244>, <-27.3339, 390.155, -98.7583>, <-33.4945, 389.2907, -99.2593> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-33.4138, 385.8873, -99.4563>, <-33.7811, 386.5743, -99.7379>, <-33.6441, 388.2758, -99.8508> }
					triangle { <-33.7811, 386.5743, -99.7379>, <-33.8854, 389.2048, -100.089>, <-33.6441, 388.2758, -99.8508> }
					triangle { <-33.8854, 389.2048, -100.089>, <-33.3878, 389.3246, -99.8244>, <-33.6441, 388.2758, -99.8508> }
					triangle { <-33.6441, 388.2758, -99.8508>, <-33.3878, 389.3246, -99.8244>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-33.8854, 389.2048, -100.089>, <-33.5139, 388.799, -104.7411>, <-32.1602, 389.5027, -106.0799> }
					triangle { <-32.1602, 389.5027, -106.0799>, <-30.04301, 389.6849, -106.0077>, <-30.3944, 389.4824, -105.255> }
					triangle { <-30.3944, 389.4824, -105.255>, <-33.8854, 389.2048, -100.089>, <-32.1602, 389.5027, -106.0799> }
					triangle { <-33.8854, 389.2048, -100.089>, <-30.3944, 389.4824, -105.255>, <-33.3878, 389.3246, -99.8244> }
					triangle { <-33.1472, 388.3015, -99.5762>, <-33.03587, 386.6128, -99.326>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-33.1472, 388.3015, -99.5762>, <-32.8916, 389.2561, -99.5397>, <-33.03587, 386.6128, -99.326> }
					triangle { <-33.1472, 388.3015, -99.5762>, <-33.3878, 389.3246, -99.8244>, <-32.8916, 389.2561, -99.5397> }
					triangle { <-33.4138, 385.8873, -99.4563>, <-33.3878, 389.3246, -99.8244>, <-33.1472, 388.3015, -99.5762> }
					triangle { <-28.765, 389.678, -104.2033>, <-29.2077, 389.0213, -102.3611>, <-32.8916, 389.2561, -99.5397> }
					triangle { <-30.3944, 389.4824, -105.255>, <-30.04301, 389.6849, -106.0077>, <-28.765, 389.678, -104.2033> }
					triangle { <-28.765, 389.678, -104.2033>, <-32.8916, 389.2561, -99.5397>, <-30.3944, 389.4824, -105.255> }
					triangle { <-33.3878, 389.3246, -99.8244>, <-30.3944, 389.4824, -105.255>, <-32.8916, 389.2561, -99.5397> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-33.4138, 385.8873, -99.4563>, <-33.7146, 386.6274, -99.2373>, <-33.5997, 388.3113, -99.5171> }
					triangle { <-33.7146, 386.6274, -99.2373>, <-33.7967, 389.2756, -99.4215>, <-33.5997, 388.3113, -99.5171> }
					triangle { <-33.7967, 389.2756, -99.4215>, <-33.3878, 389.3246, -99.8244>, <-33.5997, 388.3113, -99.5171> }
					triangle { <-33.5997, 388.3113, -99.5171>, <-33.3878, 389.3246, -99.8244>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-33.7967, 389.2756, -99.4215>, <-38.156, 389.2203, -101.1355>, <-38.9606, 389.8978, -102.8715> }
					triangle { <-38.9606, 389.8978, -102.8715>, <-38.2578, 389.8681, -104.878>, <-37.6657, 389.6392, -104.3051> }
					triangle { <-37.6657, 389.6392, -104.3051>, <-33.7967, 389.2756, -99.4215>, <-38.9606, 389.8978, -102.8715> }
					triangle { <-33.7967, 389.2756, -99.4215>, <-37.6657, 389.6392, -104.3051>, <-33.3878, 389.3246, -99.8244> }
					triangle { <-33.1916, 388.2661, -99.9099>, <-33.1024, 386.5597, -99.8266>, <-33.4138, 385.8873, -99.4563> }
					triangle { <-33.1916, 388.2661, -99.9099>, <-32.9804, 389.1853, -100.2072>, <-33.1024, 386.5597, -99.8266> }
					triangle { <-33.1916, 388.2661, -99.9099>, <-33.3878, 389.3246, -99.8244>, <-32.9804, 389.1853, -100.2072> }
					triangle { <-33.4138, 385.8873, -99.4563>, <-33.3878, 389.3246, -99.8244>, <-33.1916, 388.2661, -99.9099> }
					triangle { <-36.1717, 389.5892, -105.5559>, <-34.6188, 388.8289, -104.5402>, <-32.9804, 389.1853, -100.2072> }
					triangle { <-37.6657, 389.6392, -104.3051>, <-38.2578, 389.8681, -104.878>, <-36.1717, 389.5892, -105.5559> }
					triangle { <-36.1717, 389.5892, -105.5559>, <-32.9804, 389.1853, -100.2072>, <-37.6657, 389.6392, -104.3051> }
					triangle { <-33.3878, 389.3246, -99.8244>, <-37.6657, 389.6392, -104.3051>, <-32.9804, 389.1853, -100.2072> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-33.6567, 366.9426, -91.42>, <-33.6203, 368.1646, -93.4319>, 0.2999 }
			cylinder { <-33.6203, 368.1646, -93.4319>, <-33.5876, 369.3162, -95.4851>, 0.2999 }
			cylinder { <-33.5876, 369.3162, -95.4851>, <-33.5586, 370.3959, -97.5769>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.5586, 370.3959, -97.5769>, <-32.09321, 372.1423, -104.2617>, 0.2999 }
				cylinder { <-32.09321, 372.1423, -104.2617>, <-29.3754, 372.2456, -110.7798>, 0.2999 }
				cylinder { <-29.3754, 372.2456, -110.7798>, <-25.6395, 370.6967, -116.5701>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-25.6395, 370.6967, -116.5701>, <-25.2226, 370.2014, -117.0302>, <-24.3553, 370.0848, -118.4175> }
					triangle { <-25.2226, 370.2014, -117.0302>, <-23.8319, 369.6859, -119.1>, <-24.3553, 370.0848, -118.4175> }
					triangle { <-23.8319, 369.6859, -119.1>, <-23.8478, 370.1952, -119.3132>, <-24.3553, 370.0848, -118.4175> }
					triangle { <-24.3553, 370.0848, -118.4175>, <-23.8478, 370.1952, -119.3132>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-23.8319, 369.6859, -119.1>, <-20.1574, 368.8484, -116.6565>, <-18.3815, 369.6438, -116.6296> }
					triangle { <-18.3815, 369.6438, -116.6296>, <-17.7437, 371.5739, -116.7853>, <-18.5393, 371.4768, -116.958> }
					triangle { <-18.5393, 371.4768, -116.958>, <-23.8319, 369.6859, -119.1>, <-18.3815, 369.6438, -116.6296> }
					triangle { <-23.8319, 369.6859, -119.1>, <-18.5393, 371.4768, -116.958>, <-23.8478, 370.1952, -119.3132> }
					triangle { <-24.4203, 370.6079, -118.5556>, <-25.3201, 370.986, -117.2373>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-24.4203, 370.6079, -118.5556>, <-23.9619, 370.732, -119.3762>, <-25.3201, 370.986, -117.2373> }
					triangle { <-24.4203, 370.6079, -118.5556>, <-23.8478, 370.1952, -119.3132>, <-23.9619, 370.732, -119.3762> }
					triangle { <-25.6395, 370.6967, -116.5701>, <-23.8478, 370.1952, -119.3132>, <-24.4203, 370.6079, -118.5556> }
					triangle { <-18.8257, 373.218, -117.5732>, <-20.7208, 373.3815, -117.8534>, <-23.9619, 370.732, -119.3762> }
					triangle { <-18.5393, 371.4768, -116.958>, <-17.7437, 371.5739, -116.7853>, <-18.8257, 373.218, -117.5732> }
					triangle { <-18.8257, 373.218, -117.5732>, <-23.9619, 370.732, -119.3762>, <-18.5393, 371.4768, -116.958> }
					triangle { <-23.8478, 370.1952, -119.3132>, <-18.5393, 371.4768, -116.958>, <-23.9619, 370.732, -119.3762> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-25.6395, 370.6967, -116.5701>, <-25.5792, 370.3792, -117.2956>, <-24.593, 370.2033, -118.5944> }
					triangle { <-25.5792, 370.3792, -117.2956>, <-24.3074, 369.9229, -119.4539>, <-24.593, 370.2033, -118.5944> }
					triangle { <-24.3074, 369.9229, -119.4539>, <-23.8478, 370.1952, -119.3132>, <-24.593, 370.2033, -118.5944> }
					triangle { <-24.593, 370.2033, -118.5944>, <-23.8478, 370.1952, -119.3132>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-24.3074, 369.9229, -119.4539>, <-24.1302, 365.5092, -118.6409>, <-22.6488, 364.2644, -118.4332> }
					triangle { <-22.6488, 364.2644, -118.4332>, <-20.8422, 364.4298, -117.5029>, <-21.2444, 365.1413, -117.5665> }
					triangle { <-21.2444, 365.1413, -117.5665>, <-24.3074, 369.9229, -119.4539>, <-22.6488, 364.2644, -118.4332> }
					triangle { <-24.3074, 369.9229, -119.4539>, <-21.2444, 365.1413, -117.5665>, <-23.8478, 370.1952, -119.3132> }
					triangle { <-24.1825, 370.4893, -118.3786>, <-24.9635, 370.8082, -116.9719>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-24.1825, 370.4893, -118.3786>, <-23.4864, 370.495, -119.0222>, <-24.9635, 370.8082, -116.9719> }
					triangle { <-24.1825, 370.4893, -118.3786>, <-23.8478, 370.1952, -119.3132>, <-23.4864, 370.495, -119.0222> }
					triangle { <-25.6395, 370.6967, -116.5701>, <-23.8478, 370.1952, -119.3132>, <-24.1825, 370.4893, -118.3786> }
					triangle { <-19.8439, 366.219, -116.9585>, <-20.5728, 367.9881, -116.7705>, <-23.4864, 370.495, -119.0222> }
					triangle { <-21.2444, 365.1413, -117.5665>, <-20.8422, 364.4298, -117.5029>, <-19.8439, 366.219, -116.9585> }
					triangle { <-19.8439, 366.219, -116.9585>, <-23.4864, 370.495, -119.0222>, <-21.2444, 365.1413, -117.5665> }
					triangle { <-23.8478, 370.1952, -119.3132>, <-21.2444, 365.1413, -117.5665>, <-23.4864, 370.495, -119.0222> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-25.6395, 370.6967, -116.5701>, <-25.5133, 370.8514, -117.3389>, <-24.549, 370.5181, -118.6233> }
					triangle { <-25.5133, 370.8514, -117.3389>, <-24.2194, 370.5525, -119.5116>, <-24.549, 370.5181, -118.6233> }
					triangle { <-24.2194, 370.5525, -119.5116>, <-23.8478, 370.1952, -119.3132>, <-24.549, 370.5181, -118.6233> }
					triangle { <-24.549, 370.5181, -118.6233>, <-23.8478, 370.1952, -119.3132>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-24.2194, 370.5525, -119.5116>, <-27.7154, 368.6021, -121.5481>, <-27.9554, 366.856, -122.3732> }
					triangle { <-27.9554, 366.856, -122.3732>, <-27.3251, 364.9919, -121.8401>, <-26.984, 365.5921, -121.3979> }
					triangle { <-26.984, 365.5921, -121.3979>, <-24.2194, 370.5525, -119.5116>, <-27.9554, 366.856, -122.3732> }
					triangle { <-24.2194, 370.5525, -119.5116>, <-26.984, 365.5921, -121.3979>, <-23.8478, 370.1952, -119.3132> }
					triangle { <-24.2265, 370.1745, -118.3498>, <-25.02951, 370.336, -116.9286>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-24.2265, 370.1745, -118.3498>, <-23.5744, 369.8653, -118.9646>, <-25.02951, 370.336, -116.9286> }
					triangle { <-24.2265, 370.1745, -118.3498>, <-23.8478, 370.1952, -119.3132>, <-23.5744, 369.8653, -118.9646> }
					triangle { <-25.6395, 370.6967, -116.5701>, <-23.8478, 370.1952, -119.3132>, <-24.2265, 370.1745, -118.3498> }
					triangle { <-25.7515, 364.5081, -120.5044>, <-24.9202, 365.6242, -119.1779>, <-23.5744, 369.8653, -118.9646> }
					triangle { <-26.984, 365.5921, -121.3979>, <-27.3251, 364.9919, -121.8401>, <-25.7515, 364.5081, -120.5044> }
					triangle { <-25.7515, 364.5081, -120.5044>, <-23.5744, 369.8653, -118.9646>, <-26.984, 365.5921, -121.3979> }
					triangle { <-23.8478, 370.1952, -119.3132>, <-26.984, 365.5921, -121.3979>, <-23.5744, 369.8653, -118.9646> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-25.6395, 370.6967, -116.5701>, <-25.1153, 370.9699, -117.1006>, <-24.2837, 370.5971, -118.4644> }
					triangle { <-25.1153, 370.9699, -117.1006>, <-23.6887, 370.7105, -119.1938>, <-24.2837, 370.5971, -118.4644> }
					triangle { <-23.6887, 370.7105, -119.1938>, <-23.8478, 370.1952, -119.3132>, <-24.2837, 370.5971, -118.4644> }
					triangle { <-24.2837, 370.5971, -118.4644>, <-23.8478, 370.1952, -119.3132>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-23.6887, 370.7105, -119.1938>, <-25.9917, 373.8818, -121.3876>, <-27.01741, 373.8614, -123.0414> }
					triangle { <-27.01741, 373.8614, -123.0414>, <-28.2937, 372.4888, -123.8435>, <-27.8797, 372.2103, -123.193> }
					triangle { <-27.8797, 372.2103, -123.193>, <-23.6887, 370.7105, -119.1938>, <-27.01741, 373.8614, -123.0414> }
					triangle { <-23.6887, 370.7105, -119.1938>, <-27.8797, 372.2103, -123.193>, <-23.8478, 370.1952, -119.3132> }
					triangle { <-24.4918, 370.0956, -118.5086>, <-25.4275, 370.2175, -117.1669>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-24.4918, 370.0956, -118.5086>, <-24.105, 369.7073, -119.2823>, <-25.4275, 370.2175, -117.1669> }
					triangle { <-24.4918, 370.0956, -118.5086>, <-23.8478, 370.1952, -119.3132>, <-24.105, 369.7073, -119.2823> }
					triangle { <-25.6395, 370.6967, -116.5701>, <-23.8478, 370.1952, -119.3132>, <-24.4918, 370.0956, -118.5086> }
					triangle { <-28.4396, 370.4337, -123.3437>, <-27.7956, 369.5346, -121.771>, <-24.105, 369.7073, -119.2823> }
					triangle { <-27.8797, 372.2103, -123.193>, <-28.2937, 372.4888, -123.8435>, <-28.4396, 370.4337, -123.3437> }
					triangle { <-28.4396, 370.4337, -123.3437>, <-24.105, 369.7073, -119.2823>, <-27.8797, 372.2103, -123.193> }
					triangle { <-23.8478, 370.1952, -119.3132>, <-27.8797, 372.2103, -123.193>, <-24.105, 369.7073, -119.2823> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-25.6395, 370.6967, -116.5701>, <-24.9329, 370.5621, -116.9069>, <-24.1621, 370.3253, -118.3353> }
					triangle { <-24.9329, 370.5621, -116.9069>, <-23.4456, 370.1668, -118.9356>, <-24.1621, 370.3253, -118.3353> }
					triangle { <-23.4456, 370.1668, -118.9356>, <-23.8478, 370.1952, -119.3132>, <-24.1621, 370.3253, -118.3353> }
					triangle { <-24.1621, 370.3253, -118.3353>, <-23.8478, 370.1952, -119.3132>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-23.4456, 370.1668, -118.9356>, <-21.2501, 374.0363, -118.3188>, <-21.01108, 375.6103, -119.438> }
					triangle { <-21.01108, 375.6103, -119.438>, <-22.2827, 376.6181, -120.6724>, <-22.5818, 375.9022, -120.4076> }
					triangle { <-22.5818, 375.9022, -120.4076>, <-23.4456, 370.1668, -118.9356>, <-21.01108, 375.6103, -119.438> }
					triangle { <-23.4456, 370.1668, -118.9356>, <-22.5818, 375.9022, -120.4076>, <-23.8478, 370.1952, -119.3132> }
					triangle { <-24.6134, 370.3674, -118.6377>, <-25.6098, 370.6253, -117.3606>, <-25.6395, 370.6967, -116.5701> }
					triangle { <-24.6134, 370.3674, -118.6377>, <-24.3481, 370.251, -119.5405>, <-25.6098, 370.6253, -117.3606> }
					triangle { <-24.6134, 370.3674, -118.6377>, <-23.8478, 370.1952, -119.3132>, <-24.3481, 370.251, -119.5405> }
					triangle { <-25.6395, 370.6967, -116.5701>, <-23.8478, 370.1952, -119.3132>, <-24.6134, 370.3674, -118.6377> }
					triangle { <-24.09468, 375.898, -121.5047>, <-25.161, 374.4012, -120.94>, <-24.3481, 370.251, -119.5405> }
					triangle { <-22.5818, 375.9022, -120.4076>, <-22.2827, 376.6181, -120.6724>, <-24.09468, 375.898, -121.5047> }
					triangle { <-24.09468, 375.898, -121.5047>, <-24.3481, 370.251, -119.5405>, <-22.5818, 375.9022, -120.4076> }
					triangle { <-23.8478, 370.1952, -119.3132>, <-22.5818, 375.9022, -120.4076>, <-24.3481, 370.251, -119.5405> }
					material { txphlox_flower }}
				}
			}
		}
	union { // internode
		cylinder { <4.4663, 50.1382, 0.08282>, <4.4679, 61.9114, 0.06>, 0.6 }
		cylinder { <4.4679, 61.9114, 0.06>, <3.2315, 73.5597, 1.2423>, 0.6 }
		cylinder { <3.2315, 73.5597, 1.2423>, <0.7839, 84.8309, 3.6041>, 0.6 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.7839, 84.8309, 3.6041>, <0.4765, 85.6841, 3.9018>, 0.9729 }
			cylinder { <0.4765, 85.6841, 3.9018>, <0.06915, 86.4516, 4.2969>, 0.9729 }
			cylinder { <0.06915, 86.4516, 4.2969>, <-0.4261, 87.1108, 4.7778>, 0.9729 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <-0.4261, 87.1108, 4.7778>, <-8.3195, 110.9731, 30.694>, <-17.4537, 108.9957, 21.1894> }
			triangle { <-17.4537, 108.9957, 21.1894>, <-8.3195, 110.9731, 30.694>, <-16.3225, 123.103, 43.3159> }
			triangle { <-17.4537, 108.9957, 21.1894>, <-16.3225, 123.103, 43.3159>, <-27.938, 119.7467, 35.4927> }
			triangle { <-27.938, 119.7467, 35.4927>, <-16.3225, 123.103, 43.3159>, <-26.6121, 126.6584, 52.1153> }
			triangle { <-27.938, 119.7467, 35.4927>, <-26.6121, 126.6584, 52.1153>, <-34.2601, 123.0787, 46.233> }
			triangle { <-34.2601, 123.0787, 46.233>, <-26.6121, 126.6584, 52.1153>, <-36.2889, 122.2598, 52.6627> }
			triangle { <-42.1611, 118.6427, 46.1881>, <-34.2601, 123.0787, 46.233>, <-36.2889, 122.2598, 52.6627> }
			triangle { <-42.1611, 118.6427, 46.1881>, <-27.938, 119.7467, 35.4927>, <-34.2601, 123.0787, 46.233> }
			triangle { <-42.1611, 118.6427, 46.1881>, <-39.4462, 112.9248, 34.7518>, <-27.938, 119.7467, 35.4927> }
			triangle { <-27.938, 119.7467, 35.4927>, <-39.4462, 112.9248, 34.7518>, <-17.4537, 108.9957, 21.1894> }
			triangle { <-17.4537, 108.9957, 21.1894>, <-39.4462, 112.9248, 34.7518>, <-26.06032, 103.1434, 22.2337> }
			triangle { <-17.4537, 108.9957, 21.1894>, <-26.06032, 103.1434, 22.2337>, <-0.4261, 87.1108, 4.7778> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <0.7839, 84.8309, 3.6041>, <-1.8533, 95.9828, 6.1508>, 0.5982 }
		cylinder { <-1.8533, 95.9828, 6.1508>, <-4.6859, 107.0414, 8.8878>, 0.5982 }
		cylinder { <-4.6859, 107.0414, 8.8878>, <-7.712, 118.0, 11.8133>, 0.5982 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.712, 118.0, 11.8133>, <-8.000325, 118.711, 12.09265>, 0.8322 }
			cylinder { <-8.000325, 118.711, 12.09265>, <-8.3602, 119.3554, 12.4417>, 0.8322 }
			cylinder { <-8.3602, 119.3554, 12.4417>, <-8.7839, 119.9193, 12.8531>, 0.8322 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <-8.7839, 119.9193, 12.8531>, <-17.9631, 137.6707, 36.3968>, <-25.126, 136.5045, 27.6023> }
			triangle { <-25.126, 136.5045, 27.6023>, <-17.9631, 137.6707, 36.3968>, <-25.9996, 146.6047, 47.6524> }
			triangle { <-25.126, 136.5045, 27.6023>, <-25.9996, 146.6047, 47.6524>, <-35.3183, 144.0335, 40.01724> }
			triangle { <-35.3183, 144.0335, 40.01724>, <-25.9996, 146.6047, 47.6524>, <-35.4194, 148.5035, 54.7965> }
			triangle { <-35.3183, 144.0335, 40.01724>, <-35.4194, 148.5035, 54.7965>, <-41.4577, 145.7098, 49.0323> }
			triangle { <-41.4577, 145.7098, 49.0323>, <-35.4194, 148.5035, 54.7965>, <-43.5222, 144.3818, 54.2978> }
			triangle { <-48.01129, 141.6694, 48.1359>, <-41.4577, 145.7098, 49.0323>, <-43.5222, 144.3818, 54.2978> }
			triangle { <-48.01129, 141.6694, 48.1359>, <-35.3183, 144.0335, 40.01724>, <-41.4577, 145.7098, 49.0323> }
			triangle { <-48.01129, 141.6694, 48.1359>, <-44.8105, 137.9008, 38.1075>, <-35.3183, 144.0335, 40.01724> }
			triangle { <-35.3183, 144.0335, 40.01724>, <-44.8105, 137.9008, 38.1075>, <-25.126, 136.5045, 27.6023> }
			triangle { <-25.126, 136.5045, 27.6023>, <-44.8105, 137.9008, 38.1075>, <-32.286, 131.1403, 27.4675> }
			triangle { <-25.126, 136.5045, 27.6023>, <-32.286, 131.1403, 27.4675>, <-8.7839, 119.9193, 12.8531> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <-7.712, 118.0, 11.8133>, <-8.8529, 124.7241, 13.5582>, 0.3587 }
		cylinder { <-8.8529, 124.7241, 13.5582>, <-9.309, 131.5356, 15.2769>, 0.3587 }
		cylinder { <-9.309, 131.5356, 15.2769>, <-9.07604, 138.3691, 16.9528>, 0.3587 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.07604, 138.3691, 16.9528>, <-9.000357, 138.6855, 17.02594>, 0.3398 }
			cylinder { <-9.000357, 138.6855, 17.02594>, <-8.8629, 138.9825, 17.08987>, 0.3398 }
			cylinder { <-8.8629, 138.9825, 17.08987>, <-8.669, 139.2486, 17.1422>, 0.3398 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <-8.669, 139.2486, 17.1422>, <-3.2911, 150.3939, 14.7203>, <-2.6236, 148.5676, 18.9506> }
			triangle { <-2.6236, 148.5676, 18.9506>, <-3.2911, 150.3939, 14.7203>, <0.4001, 156.0093, 14.519> }
			triangle { <-2.6236, 148.5676, 18.9506>, <0.4001, 156.0093, 14.519>, <2.1997, 153.9679, 18.7491> }
			triangle { <2.1997, 153.9679, 18.7491>, <0.4001, 156.0093, 14.519>, <4.6642, 158.3609, 14.9572> }
			triangle { <2.1997, 153.9679, 18.7491>, <4.6642, 158.3609, 14.9572>, <5.8178, 156.4777, 17.7933> }
			triangle { <5.8178, 156.4777, 17.7933>, <4.6642, 158.3609, 14.9572>, <7.7571, 157.0586, 16.5568> }
			triangle { <8.3153, 155.0767, 19.1409>, <5.8178, 156.4777, 17.7933>, <7.7571, 157.0586, 16.5568> }
			triangle { <8.3153, 155.0767, 19.1409>, <2.1997, 153.9679, 18.7491>, <5.8178, 156.4777, 17.7933> }
			triangle { <8.3153, 155.0767, 19.1409>, <5.7298, 151.7225, 20.8464>, <2.1997, 153.9679, 18.7491> }
			triangle { <2.1997, 153.9679, 18.7491>, <5.7298, 151.7225, 20.8464>, <-2.6236, 148.5676, 18.9506> }
			triangle { <-2.6236, 148.5676, 18.9506>, <5.7298, 151.7225, 20.8464>, <0.4106, 146.8527, 20.04614> }
			triangle { <-2.6236, 148.5676, 18.9506>, <0.4106, 146.8527, 20.04614>, <-8.669, 139.2486, 17.1422> }
			material { txphlox_leaf }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-9.07604, 138.3691, 16.9528>, <-7.9459, 171.5052, 25.0795>, 0.2999 }
			cylinder { <-7.9459, 171.5052, 25.0795>, <-6.8159, 204.6413, 33.2061>, 0.2999 }
			cylinder { <-6.8159, 204.6413, 33.2061>, <-5.6859, 237.7773, 41.3327>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-5.6859, 237.7773, 41.3327>, <-5.5269, 240.0609, 41.8829>, 0.2999 }
			cylinder { <-5.5269, 240.0609, 41.8829>, <-5.287, 242.3399, 42.4223>, 0.2999 }
			cylinder { <-5.287, 242.3399, 42.4223>, <-4.9666, 244.6118, 42.9502>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-4.9666, 244.6118, 42.9502>, <-4.566, 246.8736, 43.4659>, 0.2999 }
			cylinder { <-4.566, 246.8736, 43.4659>, <-4.08574, 249.1228, 43.969>, 0.2999 }
			cylinder { <-4.08574, 249.1228, 43.969>, <-3.5262, 251.3565, 44.4588>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-3.5262, 251.3565, 44.4588>, <-2.8883, 253.5722, 44.9348>, 0.2999 }
			cylinder { <-2.8883, 253.5722, 44.9348>, <-2.1727, 255.767, 45.3963>, 0.2999 }
			cylinder { <-2.1727, 255.767, 45.3963>, <-1.3803, 257.9384, 45.843>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-1.3803, 257.9384, 45.843>, <-0.5119, 260.0838, 46.2742>, 0.2999 }
			cylinder { <-0.5119, 260.0838, 46.2742>, <0.4311, 262.2005, 46.6894>, 0.2999 }
			cylinder { <0.4311, 262.2005, 46.6894>, <1.448, 264.286, 47.0883>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <1.448, 264.286, 47.0883>, <2.5374, 266.3378, 47.4702>, 0.2999 }
			cylinder { <2.5374, 266.3378, 47.4702>, <3.698, 268.3534, 47.8349>, 0.2999 }
			cylinder { <3.698, 268.3534, 47.8349>, <4.9283, 270.3304, 48.1818>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <4.9283, 270.3304, 48.1818>, <6.227, 272.2663, 48.5106>, 0.2999 }
			cylinder { <6.227, 272.2663, 48.5106>, <7.5924, 274.1589, 48.821>, 0.2999 }
			cylinder { <7.5924, 274.1589, 48.821>, <9.0229, 276.0059, 49.1124>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <9.0229, 276.0059, 49.1124>, <10.5167, 277.805, 49.3848>, 0.2999 }
			cylinder { <10.5167, 277.805, 49.3848>, <12.07224, 279.554, 49.6376>, 0.2999 }
			cylinder { <12.07224, 279.554, 49.6376>, <13.6874, 281.2509, 49.8707>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <13.6874, 281.2509, 49.8707>, <15.3603, 282.8936, 50.08385>, 0.2999 }
			cylinder { <15.3603, 282.8936, 50.08385>, <17.08905, 284.4801, 50.2766>, 0.2999 }
			cylinder { <17.08905, 284.4801, 50.2766>, <18.8714, 286.0085, 50.449>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <18.8714, 286.0085, 50.449>, <20.6077, 287.5927, 50.5836>, 0.2999 }
			cylinder { <20.6077, 287.5927, 50.5836>, <22.2958, 289.2309, 50.6801>, 0.2999 }
			cylinder { <22.2958, 289.2309, 50.6801>, <23.9336, 290.921, 50.7385>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <23.9336, 290.921, 50.7385>, <29.03426, 295.4589, 52.548>, 0.2999 }
				cylinder { <29.03426, 295.4589, 52.548>, <34.01603, 299.1924, 55.8836>, 0.2999 }
				cylinder { <34.01603, 299.1924, 55.8836>, <38.5804, 301.8977, 60.5452>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <38.5804, 301.8977, 60.5452>, <39.02329, 301.9572, 61.2427>, <40.0554, 302.9764, 62.1498> }
					triangle { <39.02329, 301.9572, 61.2427>, <40.6384, 303.2695, 62.8928>, <40.0554, 302.9764, 62.1498> }
					triangle { <40.6384, 303.2695, 62.8928>, <40.6809, 303.7476, 62.5742>, <40.0554, 302.9764, 62.1498> }
					triangle { <40.0554, 302.9764, 62.1498>, <40.6809, 303.7476, 62.5742>, <38.5804, 301.8977, 60.5452> }
					triangle { <40.6384, 303.2695, 62.8928>, <37.364, 303.4986, 66.235>, <36.476, 305.056, 67.1868> }
					triangle { <36.476, 305.056, 67.1868>, <35.7891, 306.9464, 66.497>, <36.2543, 306.5204, 65.9197> }
					triangle { <36.2543, 306.5204, 65.9197>, <40.6384, 303.2695, 62.8928>, <36.476, 305.056, 67.1868> }
					triangle { <40.6384, 303.2695, 62.8928>, <36.2543, 306.5204, 65.9197>, <40.6809, 303.7476, 62.5742> }
					triangle { <40.04037, 303.4038, 61.7756>, <39.00074, 302.5984, 60.6815>, <38.5804, 301.8977, 60.5452> }
					triangle { <40.04037, 303.4038, 61.7756>, <40.6083, 304.1244, 62.1444>, <39.00074, 302.5984, 60.6815> }
					triangle { <40.04037, 303.4038, 61.7756>, <40.6809, 303.7476, 62.5742>, <40.6083, 304.1244, 62.1444> }
					triangle { <38.5804, 301.8977, 60.5452>, <40.6809, 303.7476, 62.5742>, <40.04037, 303.4038, 61.7756> }
					triangle { <36.3732, 307.9769, 64.63>, <37.2337, 307.2032, 62.9922>, <40.6083, 304.1244, 62.1444> }
					triangle { <36.2543, 306.5204, 65.9197>, <35.7891, 306.9464, 66.497>, <36.3732, 307.9769, 64.63> }
					triangle { <36.3732, 307.9769, 64.63>, <40.6083, 304.1244, 62.1444>, <36.2543, 306.5204, 65.9197> }
					triangle { <40.6809, 303.7476, 62.5742>, <36.2543, 306.5204, 65.9197>, <40.6083, 304.1244, 62.1444> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <38.5804, 301.8977, 60.5452>, <39.3368, 302.0216, 60.8594>, <40.2644, 303.0193, 61.8943> }
					triangle { <39.3368, 302.0216, 60.8594>, <41.05643, 303.3554, 62.3817>, <40.2644, 303.0193, 61.8943> }
					triangle { <41.05643, 303.3554, 62.3817>, <40.6809, 303.7476, 62.5742>, <40.2644, 303.0193, 61.8943> }
					triangle { <40.2644, 303.0193, 61.8943>, <40.6809, 303.7476, 62.5742>, <38.5804, 301.8977, 60.5452> }
					triangle { <41.05643, 303.3554, 62.3817>, <41.6393, 299.709, 65.2642>, <41.3319, 299.4666, 67.2558> }
					triangle { <41.3319, 299.4666, 67.2558>, <39.7915, 300.1443, 68.5554>, <39.763, 300.4986, 67.7778> }
					triangle { <39.763, 300.4986, 67.7778>, <41.05643, 303.3554, 62.3817>, <41.3319, 299.4666, 67.2558> }
					triangle { <41.05643, 303.3554, 62.3817>, <39.763, 300.4986, 67.7778>, <40.6809, 303.7476, 62.5742> }
					triangle { <39.8313, 303.3609, 62.03119>, <38.6872, 302.534, 61.06481>, <38.5804, 301.8977, 60.5452> }
					triangle { <39.8313, 303.3609, 62.03119>, <40.1903, 304.0385, 62.6555>, <38.6872, 302.534, 61.06481> }
					triangle { <39.8313, 303.3609, 62.03119>, <40.6809, 303.7476, 62.5742>, <40.1903, 304.0385, 62.6555> }
					triangle { <38.5804, 301.8977, 60.5452>, <40.6809, 303.7476, 62.5742>, <39.8313, 303.3609, 62.03119> }
					triangle { <38.3727, 301.8007, 68.1912>, <37.8862, 302.6693, 66.4505>, <40.1903, 304.0385, 62.6555> }
					triangle { <39.763, 300.4986, 67.7778>, <39.7915, 300.1443, 68.5554>, <38.3727, 301.8007, 68.1912> }
					triangle { <38.3727, 301.8007, 68.1912>, <40.1903, 304.0385, 62.6555>, <39.763, 300.4986, 67.7778> }
					triangle { <40.6809, 303.7476, 62.5742>, <39.763, 300.4986, 67.7778>, <40.1903, 304.0385, 62.6555> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <38.5804, 301.8977, 60.5452>, <39.2045, 302.4377, 60.6171>, <40.1762, 303.2967, 61.7327> }
					triangle { <39.2045, 302.4377, 60.6171>, <40.88, 303.9101, 62.0586>, <40.1762, 303.2967, 61.7327> }
					triangle { <40.88, 303.9101, 62.0586>, <40.6809, 303.7476, 62.5742>, <40.1762, 303.2967, 61.7327> }
					triangle { <40.1762, 303.2967, 61.7327>, <40.6809, 303.7476, 62.5742>, <38.5804, 301.8977, 60.5452> }
					triangle { <40.88, 303.9101, 62.0586>, <44.5991, 301.463, 60.6009>, <46.00522, 300.3796, 61.5854> }
					triangle { <46.00522, 300.3796, 61.5854>, <45.8836, 299.0535, 63.2431>, <45.1636, 299.4931, 63.1036> }
					triangle { <45.1636, 299.4931, 63.1036>, <40.88, 303.9101, 62.0586>, <46.00522, 300.3796, 61.5854> }
					triangle { <40.88, 303.9101, 62.0586>, <45.1636, 299.4931, 63.1036>, <40.6809, 303.7476, 62.5742> }
					triangle { <39.9195, 303.0835, 62.1927>, <38.8195, 302.1179, 61.3071>, <38.5804, 301.8977, 60.5452> }
					triangle { <39.9195, 303.0835, 62.1927>, <40.3667, 303.4838, 62.9786>, <38.8195, 302.1179, 61.3071> }
					triangle { <39.9195, 303.0835, 62.1927>, <40.6809, 303.7476, 62.5742>, <40.3667, 303.4838, 62.9786> }
					triangle { <38.5804, 301.8977, 60.5452>, <40.6809, 303.7476, 62.5742>, <39.9195, 303.0835, 62.1927> }
					triangle { <44.2514, 298.923, 64.7291>, <42.3748, 299.6155, 64.588>, <40.3667, 303.4838, 62.9786> }
					triangle { <45.1636, 299.4931, 63.1036>, <45.8836, 299.0535, 63.2431>, <44.2514, 298.923, 64.7291> }
					triangle { <44.2514, 298.923, 64.7291>, <40.3667, 303.4838, 62.9786>, <45.1636, 299.4931, 63.1036> }
					triangle { <40.6809, 303.7476, 62.5742>, <45.1636, 299.4931, 63.1036>, <40.3667, 303.4838, 62.9786> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <38.5804, 301.8977, 60.5452>, <38.8079, 302.6343, 60.8483>, <39.9118, 303.4278, 61.8868> }
					triangle { <38.8079, 302.6343, 60.8483>, <40.3513, 304.1722, 62.3669>, <39.9118, 303.4278, 61.8868> }
					triangle { <40.3513, 304.1722, 62.3669>, <40.6809, 303.7476, 62.5742>, <39.9118, 303.4278, 61.8868> }
					triangle { <39.9118, 303.4278, 61.8868>, <40.6809, 303.7476, 62.5742>, <38.5804, 301.8977, 60.5452> }
					triangle { <40.3513, 304.1722, 62.3669>, <42.1805, 306.353, 58.6462>, <44.08107, 306.5419, 57.9589> }
					triangle { <44.08107, 306.5419, 57.9589>, <45.7032, 305.1713, 57.8519>, <45.04305, 304.8841, 58.3132> }
					triangle { <45.04305, 304.8841, 58.3132>, <40.3513, 304.1722, 62.3669>, <44.08107, 306.5419, 57.9589> }
					triangle { <40.3513, 304.1722, 62.3669>, <45.04305, 304.8841, 58.3132>, <40.6809, 303.7476, 62.5742> }
					triangle { <40.1839, 302.9525, 62.03862>, <39.216, 301.9213, 61.07594>, <38.5804, 301.8977, 60.5452> }
					triangle { <40.1839, 302.9525, 62.03862>, <40.8954, 303.2216, 62.6703>, <39.216, 301.9213, 61.07594> }
					triangle { <40.1839, 302.9525, 62.03862>, <40.6809, 303.7476, 62.5742>, <40.8954, 303.2216, 62.6703> }
					triangle { <38.5804, 301.8977, 60.5452>, <40.6809, 303.7476, 62.5742>, <40.1839, 302.9525, 62.03862> }
					triangle { <45.94, 303.2939, 58.9958>, <44.5383, 302.2336, 59.9612>, <40.8954, 303.2216, 62.6703> }
					triangle { <45.04305, 304.8841, 58.3132>, <45.7032, 305.1713, 57.8519>, <45.94, 303.2939, 58.9958> }
					triangle { <45.94, 303.2939, 58.9958>, <40.8954, 303.2216, 62.6703>, <45.04305, 304.8841, 58.3132> }
					triangle { <40.6809, 303.7476, 62.5742>, <45.04305, 304.8841, 58.3132>, <40.8954, 303.2216, 62.6703> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <38.5804, 301.8977, 60.5452>, <38.6942, 302.3329, 61.2408>, <39.836, 303.2268, 62.1485> }
					triangle { <38.6942, 302.3329, 61.2408>, <40.1997, 303.7704, 62.8902>, <39.836, 303.2268, 62.1485> }
					triangle { <40.1997, 303.7704, 62.8902>, <40.6809, 303.7476, 62.5742>, <39.836, 303.2268, 62.1485> }
					triangle { <39.836, 303.2268, 62.1485>, <40.6809, 303.7476, 62.5742>, <38.5804, 301.8977, 60.5452> }
					triangle { <40.1997, 303.7704, 62.8902>, <37.6415, 307.6301, 62.1809>, <38.1027, 309.4756, 61.4731> }
					triangle { <38.1027, 309.4756, 61.4731>, <39.3703, 310.123, 59.8933>, <39.4536, 309.2928, 60.07997> }
					triangle { <39.4536, 309.2928, 60.07997>, <40.1997, 303.7704, 62.8902>, <38.1027, 309.4756, 61.4731> }
					triangle { <40.1997, 303.7704, 62.8902>, <39.4536, 309.2928, 60.07997>, <40.6809, 303.7476, 62.5742> }
					triangle { <40.2597, 303.1534, 61.7769>, <39.3297, 302.2227, 60.6834>, <38.5804, 301.8977, 60.5452> }
					triangle { <40.2597, 303.1534, 61.7769>, <41.04699, 303.6235, 62.147>, <39.3297, 302.2227, 60.6834> }
					triangle { <40.2597, 303.1534, 61.7769>, <40.6809, 303.7476, 62.5742>, <41.04699, 303.6235, 62.147> }
					triangle { <38.5804, 301.8977, 60.5452>, <40.6809, 303.7476, 62.5742>, <40.2597, 303.1534, 61.7769> }
					triangle { <40.9975, 308.974, 58.9336>, <41.3129, 306.9939, 58.9601>, <41.04699, 303.6235, 62.147> }
					triangle { <39.4536, 309.2928, 60.07997>, <39.3703, 310.123, 59.8933>, <40.9975, 308.974, 58.9336> }
					triangle { <40.9975, 308.974, 58.9336>, <41.04699, 303.6235, 62.147>, <39.4536, 309.2928, 60.07997> }
					triangle { <40.6809, 303.7476, 62.5742>, <39.4536, 309.2928, 60.07997>, <41.04699, 303.6235, 62.147> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <23.9336, 290.921, 50.7385>, <25.5892, 292.5893, 50.8736>, 0.2999 }
			cylinder { <25.5892, 292.5893, 50.8736>, <27.2604, 294.2339, 51.08536>, 0.2999 }
			cylinder { <27.2604, 294.2339, 51.08536>, <28.9452, 295.8529, 51.3734>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <28.9452, 295.8529, 51.3734>, <34.4877, 300.1733, 50.6679>, 0.2999 }
				cylinder { <34.4877, 300.1733, 50.6679>, <40.1859, 303.6985, 48.4349>, 0.2999 }
				cylinder { <40.1859, 303.6985, 48.4349>, <45.6984, 306.217, 44.8083>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <45.6984, 306.217, 44.8083>, <45.9604, 306.3745, 44.07522>, <47.2059, 307.0034, 43.2127> }
					triangle { <45.9604, 306.3745, 44.07522>, <47.7057, 307.2745, 42.4541>, <47.2059, 307.0034, 43.2127> }
					triangle { <47.7057, 307.2745, 42.4541>, <48.07153, 307.4301, 42.8376>, <47.2059, 307.0034, 43.2127> }
					triangle { <47.2059, 307.0034, 43.2127>, <48.07153, 307.4301, 42.8376>, <45.6984, 306.217, 44.8083> }
					triangle { <47.7057, 307.2745, 42.4541>, <48.4897, 303.1991, 40.7367>, <50.09376, 302.1034, 40.619> }
					triangle { <50.09376, 302.1034, 40.619>, <51.6145, 301.7576, 41.932>, <51.1146, 302.3652, 42.1623> }
					triangle { <51.1146, 302.3652, 42.1623>, <47.7057, 307.2745, 42.4541>, <50.09376, 302.1034, 40.619> }
					triangle { <47.7057, 307.2745, 42.4541>, <51.1146, 302.3652, 42.1623>, <48.07153, 307.4301, 42.8376> }
					triangle { <47.5067, 307.1257, 43.6503>, <46.4116, 306.5581, 44.7315>, <45.6984, 306.217, 44.8083> }
					triangle { <47.5067, 307.1257, 43.6503>, <48.3072, 307.5193, 43.3291>, <46.4116, 306.5581, 44.7315> }
					triangle { <47.5067, 307.1257, 43.6503>, <48.07153, 307.4301, 42.8376>, <48.3072, 307.5193, 43.3291> }
					triangle { <45.6984, 306.217, 44.8083>, <48.07153, 307.4301, 42.8376>, <47.5067, 307.1257, 43.6503> }
					triangle { <52.149, 302.9396, 43.6088>, <51.0965, 304.2597, 44.5286>, <48.3072, 307.5193, 43.3291> }
					triangle { <51.1146, 302.3652, 42.1623>, <51.6145, 301.7576, 41.932>, <52.149, 302.9396, 43.6088> }
					triangle { <52.149, 302.9396, 43.6088>, <48.3072, 307.5193, 43.3291>, <51.1146, 302.3652, 42.1623> }
					triangle { <48.07153, 307.4301, 42.8376>, <51.1146, 302.3652, 42.1623>, <48.3072, 307.5193, 43.3291> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <45.6984, 306.217, 44.8083>, <45.9494, 306.788, 44.3164>, <47.1986, 307.279, 43.3735> }
					triangle { <45.9494, 306.788, 44.3164>, <47.691, 307.8258, 42.7757>, <47.1986, 307.279, 43.3735> }
					triangle { <47.691, 307.8258, 42.7757>, <48.07153, 307.4301, 42.8376>, <47.1986, 307.279, 43.3735> }
					triangle { <47.1986, 307.279, 43.3735>, <48.07153, 307.4301, 42.8376>, <45.6984, 306.217, 44.8083> }
					triangle { <47.691, 307.8258, 42.7757>, <45.08406, 307.2951, 39.1569>, <45.3293, 306.3311, 37.4842> }
					triangle { <45.3293, 306.3311, 37.4842>, <46.1567, 304.5172, 37.05848>, <46.2891, 304.765, 37.8286> }
					triangle { <46.2891, 304.765, 37.8286>, <47.691, 307.8258, 42.7757>, <45.3293, 306.3311, 37.4842> }
					triangle { <47.691, 307.8258, 42.7757>, <46.2891, 304.765, 37.8286>, <48.07153, 307.4301, 42.8376> }
					triangle { <47.514, 306.8501, 43.4895>, <46.4226, 306.1447, 44.4903>, <45.6984, 306.217, 44.8083> }
					triangle { <47.514, 306.8501, 43.4895>, <48.3219, 306.968, 43.00756>, <46.4226, 306.1447, 44.4903> }
					triangle { <47.514, 306.8501, 43.4895>, <48.07153, 307.4301, 42.8376>, <48.3219, 306.968, 43.00756> }
					triangle { <45.6984, 306.217, 44.8083>, <48.07153, 307.4301, 42.8376>, <47.514, 306.8501, 43.4895> }
					triangle { <47.4851, 303.4007, 38.2763>, <47.8182, 303.5784, 40.1615>, <48.3219, 306.968, 43.00756> }
					triangle { <46.2891, 304.765, 37.8286>, <46.1567, 304.5172, 37.05848>, <47.4851, 303.4007, 38.2763> }
					triangle { <47.4851, 303.4007, 38.2763>, <48.3219, 306.968, 43.00756>, <46.2891, 304.765, 37.8286> }
					triangle { <48.07153, 307.4301, 42.8376>, <46.2891, 304.765, 37.8286>, <48.3219, 306.968, 43.00756> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <45.6984, 306.217, 44.8083>, <46.2632, 306.7599, 44.6769>, <47.4077, 307.2603, 43.6139> }
					triangle { <46.2632, 306.7599, 44.6769>, <48.1093, 307.7883, 43.2564>, <47.4077, 307.2603, 43.6139> }
					triangle { <48.1093, 307.7883, 43.2564>, <48.07153, 307.4301, 42.8376>, <47.4077, 307.2603, 43.6139> }
					triangle { <47.4077, 307.2603, 43.6139>, <48.07153, 307.4301, 42.8376>, <45.6984, 306.217, 44.8083> }
					triangle { <48.1093, 307.7883, 43.2564>, <45.779, 311.5765, 42.6294>, <45.1321, 312.4781, 41.03074> }
					triangle { <45.1321, 312.4781, 41.03074>, <44.3089, 311.777, 39.3023>, <44.6241, 311.188, 39.7776> }
					triangle { <44.6241, 311.188, 39.7776>, <48.1093, 307.7883, 43.2564>, <45.1321, 312.4781, 41.03074> }
					triangle { <48.1093, 307.7883, 43.2564>, <44.6241, 311.188, 39.7776>, <48.07153, 307.4301, 42.8376> }
					triangle { <47.3049, 306.8688, 43.2491>, <46.1089, 306.1727, 44.1297>, <45.6984, 306.217, 44.8083> }
					triangle { <47.3049, 306.8688, 43.2491>, <47.9036, 307.0055, 42.5268>, <46.1089, 306.1727, 44.1297> }
					triangle { <47.3049, 306.8688, 43.2491>, <48.07153, 307.4301, 42.8376>, <47.9036, 307.0055, 42.5268> }
					triangle { <45.6984, 306.217, 44.8083>, <48.07153, 307.4301, 42.8376>, <47.3049, 306.8688, 43.2491> }
					triangle { <44.4293, 309.8033, 38.5378>, <44.8876, 308.1842, 39.4677>, <47.9036, 307.0055, 42.5268> }
					triangle { <44.6241, 311.188, 39.7776>, <44.3089, 311.777, 39.3023>, <44.4293, 309.8033, 38.5378> }
					triangle { <44.4293, 309.8033, 38.5378>, <47.9036, 307.0055, 42.5268>, <44.6241, 311.188, 39.7776> }
					triangle { <48.07153, 307.4301, 42.8376>, <44.6241, 311.188, 39.7776>, <47.9036, 307.0055, 42.5268> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <45.6984, 306.217, 44.8083>, <46.471, 306.3289, 44.6619>, <47.5463, 306.9729, 43.6039> }
					triangle { <46.471, 306.3289, 44.6619>, <48.3865, 307.2136, 43.2364>, <47.5463, 306.9729, 43.6039> }
					triangle { <48.3865, 307.2136, 43.2364>, <48.07153, 307.4301, 42.8376>, <47.5463, 306.9729, 43.6039> }
					triangle { <47.5463, 306.9729, 43.6039>, <48.07153, 307.4301, 42.8376>, <45.6984, 306.217, 44.8083> }
					triangle { <48.3865, 307.2136, 43.2364>, <49.6207, 310.1664, 46.3877>, <49.7728, 312.1066, 46.3905> }
					triangle { <49.7728, 312.1066, 46.3905>, <48.6074, 313.572, 45.5837>, <48.4051, 312.8178, 45.334> }
					triangle { <48.4051, 312.8178, 45.334>, <48.3865, 307.2136, 43.2364>, <49.7728, 312.1066, 46.3905> }
					triangle { <48.3865, 307.2136, 43.2364>, <48.4051, 312.8178, 45.334>, <48.07153, 307.4301, 42.8376> }
					triangle { <47.1663, 307.1562, 43.2591>, <45.901, 306.6038, 44.1447>, <45.6984, 306.217, 44.8083> }
					triangle { <47.1663, 307.1562, 43.2591>, <47.6265, 307.5802, 42.5468>, <45.901, 306.6038, 44.1447> }
					triangle { <47.1663, 307.1562, 43.2591>, <48.07153, 307.4301, 42.8376>, <47.6265, 307.5802, 42.5468> }
					triangle { <45.6984, 306.217, 44.8083>, <48.07153, 307.4301, 42.8376>, <47.1663, 307.1562, 43.2591> }
					triangle { <47.1761, 313.3591, 44.03445>, <46.3273, 311.755, 43.3996>, <47.6265, 307.5802, 42.5468> }
					triangle { <48.4051, 312.8178, 45.334>, <48.6074, 313.572, 45.5837>, <47.1761, 313.3591, 44.03445> }
					triangle { <47.1761, 313.3591, 44.03445>, <47.6265, 307.5802, 42.5468>, <48.4051, 312.8178, 45.334> }
					triangle { <48.07153, 307.4301, 42.8376>, <48.4051, 312.8178, 45.334>, <47.6265, 307.5802, 42.5468> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <45.6984, 306.217, 44.8083>, <46.2811, 306.0871, 44.2844>, <47.4197, 306.8117, 43.3522> }
					triangle { <46.2811, 306.0871, 44.2844>, <48.1333, 306.8913, 42.733>, <47.4197, 306.8117, 43.3522> }
					triangle { <48.1333, 306.8913, 42.733>, <48.07153, 307.4301, 42.8376>, <47.4197, 306.8117, 43.3522> }
					triangle { <47.4197, 306.8117, 43.3522>, <48.07153, 307.4301, 42.8376>, <45.6984, 306.217, 44.8083> }
					triangle { <48.1333, 306.8913, 42.733>, <51.3213, 304.9108, 45.2003>, <52.8855, 305.5979, 46.1322> }
					triangle { <52.8855, 305.5979, 46.1322>, <53.1907, 307.2862, 47.2335>, <52.477, 307.2827, 46.8301> }
					triangle { <52.477, 307.2827, 46.8301>, <48.1333, 306.8913, 42.733>, <52.8855, 305.5979, 46.1322> }
					triangle { <48.1333, 306.8913, 42.733>, <52.477, 307.2827, 46.8301>, <48.07153, 307.4301, 42.8376> }
					triangle { <47.2929, 307.3174, 43.5108>, <46.09097, 306.8455, 44.5223>, <45.6984, 306.217, 44.8083> }
					triangle { <47.2929, 307.3174, 43.5108>, <47.8797, 307.9025, 43.05023>, <46.09097, 306.8455, 44.5223> }
					triangle { <47.2929, 307.3174, 43.5108>, <48.07153, 307.4301, 42.8376>, <47.8797, 307.9025, 43.05023> }
					triangle { <45.6984, 306.217, 44.8083>, <48.07153, 307.4301, 42.8376>, <47.2929, 307.3174, 43.5108> }
					triangle { <52.0192, 309.053, 47.2158>, <50.2225, 309.2929, 46.5746>, <47.8797, 307.9025, 43.05023> }
					triangle { <52.477, 307.2827, 46.8301>, <53.1907, 307.2862, 47.2335>, <52.0192, 309.053, 47.2158> }
					triangle { <52.0192, 309.053, 47.2158>, <47.8797, 307.9025, 43.05023>, <52.477, 307.2827, 46.8301> }
					triangle { <48.07153, 307.4301, 42.8376>, <52.477, 307.2827, 46.8301>, <47.8797, 307.9025, 43.05023> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-5.6859, 237.7773, 41.3327>, <-5.6744, 240.0746, 41.8472>, 0.2999 }
			cylinder { <-5.6744, 240.0746, 41.8472>, <-5.7296, 242.3813, 42.3153>, 0.2999 }
			cylinder { <-5.7296, 242.3813, 42.3153>, <-5.8511, 244.6944, 42.7362>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-5.8511, 244.6944, 42.7362>, <-5.6315, 245.8851, 44.7552>, 0.2999 }
			cylinder { <-5.6315, 245.8851, 44.7552>, <-5.3962, 247.0054, 46.8125>, 0.2999 }
			cylinder { <-5.3962, 247.0054, 46.8125>, <-5.1456, 248.0538, 48.9055>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-5.1456, 248.0538, 48.9055>, <-3.4559, 252.3269, 54.2691>, 0.2999 }
				cylinder { <-3.4559, 252.3269, 54.2691>, <-0.9294, 257.4717, 58.3959>, 0.2999 }
				cylinder { <-0.9294, 257.4717, 58.3959>, <2.2822, 263.18, 61.03851>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <2.2822, 263.18, 61.03851>, <2.5285, 263.9555, 60.8829>, <3.2763, 265.3373, 61.5598> }
					triangle { <2.5285, 263.9555, 60.8829>, <3.643, 266.2544, 61.6085>, <3.2763, 265.3373, 61.5598> }
					triangle { <3.643, 266.2544, 61.6085>, <3.7599, 266.1006, 62.1513>, <3.2763, 265.3373, 61.5598> }
					triangle { <3.2763, 265.3373, 61.5598>, <3.7599, 266.1006, 62.1513>, <2.2822, 263.18, 61.03851> }
					triangle { <3.643, 266.2544, 61.6085>, <7.2328, 265.6756, 58.655>, <9.24, 265.5626, 58.9344> }
					triangle { <9.24, 265.5626, 58.9344>, <10.4224, 264.6192, 60.4288>, <9.5876, 264.635, 60.6131> }
					triangle { <9.5876, 264.635, 60.6131>, <3.643, 266.2544, 61.6085>, <9.24, 265.5626, 58.9344> }
					triangle { <3.643, 266.2544, 61.6085>, <9.5876, 264.635, 60.6131>, <3.7599, 266.1006, 62.1513> }
					triangle { <3.3527, 265.1035, 62.07209>, <2.6431, 263.6047, 61.6513>, <2.2822, 263.18, 61.03851> }
					triangle { <3.3527, 265.1035, 62.07209>, <3.7958, 265.7867, 62.6331>, <2.6431, 263.6047, 61.6513> }
					triangle { <3.3527, 265.1035, 62.07209>, <3.7599, 266.1006, 62.1513>, <3.7958, 265.7867, 62.6331> }
					triangle { <2.2822, 263.18, 61.03851>, <3.7599, 266.1006, 62.1513>, <3.3527, 265.1035, 62.07209> }
					triangle { <9.7621, 263.9646, 62.435>, <7.8949, 263.6489, 63.09476>, <3.7958, 265.7867, 62.6331> }
					triangle { <9.5876, 264.635, 60.6131>, <10.4224, 264.6192, 60.4288>, <9.7621, 263.9646, 62.435> }
					triangle { <9.7621, 263.9646, 62.435>, <3.7958, 265.7867, 62.6331>, <9.5876, 264.635, 60.6131> }
					triangle { <3.7599, 266.1006, 62.1513>, <9.5876, 264.635, 60.6131>, <3.7958, 265.7867, 62.6331> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <2.2822, 263.18, 61.03851>, <2.206, 263.9736, 61.2638>, <3.06139, 265.3494, 61.8137> }
					triangle { <2.206, 263.9736, 61.2638>, <3.213, 266.2785, 62.1163>, <3.06139, 265.3494, 61.8137> }
					triangle { <3.213, 266.2785, 62.1163>, <3.7599, 266.1006, 62.1513>, <3.06139, 265.3494, 61.8137> }
					triangle { <3.06139, 265.3494, 61.8137>, <3.7599, 266.1006, 62.1513>, <2.2822, 263.18, 61.03851> }
					triangle { <3.213, 266.2785, 62.1163>, <2.1745, 268.4478, 58.09631>, <3.313, 269.4066, 56.7162> }
					triangle { <3.313, 269.4066, 56.7162>, <5.2265, 268.9754, 55.8955>, <5.02431, 268.4857, 56.5666> }
					triangle { <5.02431, 268.4857, 56.5666>, <3.213, 266.2785, 62.1163>, <3.313, 269.4066, 56.7162> }
					triangle { <3.213, 266.2785, 62.1163>, <5.02431, 268.4857, 56.5666>, <3.7599, 266.1006, 62.1513> }
					triangle { <3.5677, 265.0914, 61.8182>, <2.9656, 263.5867, 61.2705>, <2.2822, 263.18, 61.03851> }
					triangle { <3.5677, 265.0914, 61.8182>, <4.2257, 265.7626, 62.1253>, <2.9656, 263.5867, 61.2705> }
					triangle { <3.5677, 265.0914, 61.8182>, <3.7599, 266.1006, 62.1513>, <4.2257, 265.7626, 62.1253> }
					triangle { <2.2822, 263.18, 61.03851>, <3.7599, 266.1006, 62.1513>, <3.5677, 265.0914, 61.8182> }
					triangle { <6.7731, 267.6442, 56.747>, <6.5631, 266.2125, 58.1352>, <4.2257, 265.7626, 62.1253> }
					triangle { <5.02431, 268.4857, 56.5666>, <5.2265, 268.9754, 55.8955>, <6.7731, 267.6442, 56.747> }
					triangle { <6.7731, 267.6442, 56.747>, <4.2257, 265.7626, 62.1253>, <5.02431, 268.4857, 56.5666> }
					triangle { <3.7599, 266.1006, 62.1513>, <5.02431, 268.4857, 56.5666>, <4.2257, 265.7626, 62.1253> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <2.2822, 263.18, 61.03851>, <2.4049, 263.7261, 61.6492>, <3.1939, 265.1844, 62.07068> }
					triangle { <2.4049, 263.7261, 61.6492>, <3.4781, 265.9485, 62.6302>, <3.1939, 265.1844, 62.07068> }
					triangle { <3.4781, 265.9485, 62.6302>, <3.7599, 266.1006, 62.1513>, <3.1939, 265.1844, 62.07068> }
					triangle { <3.1939, 265.1844, 62.07068>, <3.7599, 266.1006, 62.1513>, <2.2822, 263.18, 61.03851> }
					triangle { <3.4781, 265.9485, 62.6302>, <-0.7075, 267.998, 63.1036>, <-1.5004, 269.7011, 62.335> }
					triangle { <-1.5004, 269.7011, 62.335>, <-1.3712, 270.5937, 60.4094>, <-0.8299, 269.9411, 60.5206> }
					triangle { <-0.8299, 269.9411, 60.5206>, <3.4781, 265.9485, 62.6302>, <-1.5004, 269.7011, 62.335> }
					triangle { <3.4781, 265.9485, 62.6302>, <-0.8299, 269.9411, 60.5206>, <3.7599, 266.1006, 62.1513> }
					triangle { <3.4352, 265.2564, 61.5612>, <2.7668, 263.8342, 60.885>, <2.2822, 263.18, 61.03851> }
					triangle { <3.4352, 265.2564, 61.5612>, <3.9606, 266.0926, 61.6113>, <2.7668, 263.8342, 60.885> }
					triangle { <3.4352, 265.2564, 61.5612>, <3.7599, 266.1006, 62.1513>, <3.9606, 266.0926, 61.6113> }
					triangle { <2.2822, 263.18, 61.03851>, <3.7599, 266.1006, 62.1513>, <3.4352, 265.2564, 61.5612> }
					triangle { <0.1482, 270.1934, 58.8537>, <1.3834, 268.6224, 58.6883>, <3.9606, 266.0926, 61.6113> }
					triangle { <-0.8299, 269.9411, 60.5206>, <-1.3712, 270.5937, 60.4094>, <0.1482, 270.1934, 58.8537> }
					triangle { <0.1482, 270.1934, 58.8537>, <3.9606, 266.0926, 61.6113>, <-0.8299, 269.9411, 60.5206> }
					triangle { <3.7599, 266.1006, 62.1513>, <-0.8299, 269.9411, 60.5206>, <3.9606, 266.0926, 61.6113> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <2.2822, 263.18, 61.03851>, <2.8521, 263.5528, 61.5102>, <3.492, 265.0688, 61.978> }
					triangle { <2.8521, 263.5528, 61.5102>, <4.07441, 265.7174, 62.4449>, <3.492, 265.0688, 61.978> }
					triangle { <4.07441, 265.7174, 62.4449>, <3.7599, 266.1006, 62.1513>, <3.492, 265.0688, 61.978> }
					triangle { <3.492, 265.0688, 61.978>, <3.7599, 266.1006, 62.1513>, <2.2822, 263.18, 61.03851> }
					triangle { <4.07441, 265.7174, 62.4449>, <2.5424, 264.9438, 66.8037>, <1.4067, 266.0418, 68.07826> }
					triangle { <1.4067, 266.0418, 68.07826>, <-0.3145, 267.2527, 67.7746>, <0.06051, 267.0035, 67.04776> }
					triangle { <0.06051, 267.0035, 67.04776>, <4.07441, 265.7174, 62.4449>, <1.4067, 266.0418, 68.07826> }
					triangle { <4.07441, 265.7174, 62.4449>, <0.06051, 267.0035, 67.04776>, <3.7599, 266.1006, 62.1513> }
					triangle { <3.137, 265.3719, 61.6539>, <2.3196, 264.0075, 61.02409>, <2.2822, 263.18, 61.03851> }
					triangle { <3.137, 265.3719, 61.6539>, <3.3644, 266.3237, 61.7967>, <2.3196, 264.0075, 61.02409> }
					triangle { <3.137, 265.3719, 61.6539>, <3.7599, 266.1006, 62.1513>, <3.3644, 266.3237, 61.7967> }
					triangle { <2.2822, 263.18, 61.03851>, <3.7599, 266.1006, 62.1513>, <3.137, 265.3719, 61.6539> }
					triangle { <-1.01907, 268.1131, 65.8635>, <-0.5341, 267.5707, 63.9948>, <3.3644, 266.3237, 61.7967> }
					triangle { <0.06051, 267.0035, 67.04776>, <-0.3145, 267.2527, 67.7746>, <-1.01907, 268.1131, 65.8635> }
					triangle { <-1.01907, 268.1131, 65.8635>, <3.3644, 266.3237, 61.7967>, <0.06051, 267.0035, 67.04776> }
					triangle { <3.7599, 266.1006, 62.1513>, <0.06051, 267.0035, 67.04776>, <3.3644, 266.3237, 61.7967> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <2.2822, 263.18, 61.03851>, <2.9296, 263.6967, 61.02951>, <3.5437, 265.1648, 61.6575> }
					triangle { <2.9296, 263.6967, 61.02951>, <4.1778, 265.9093, 61.8039>, <3.5437, 265.1648, 61.6575> }
					triangle { <4.1778, 265.9093, 61.8039>, <3.7599, 266.1006, 62.1513>, <3.5437, 265.1648, 61.6575> }
					triangle { <3.5437, 265.1648, 61.6575>, <3.7599, 266.1006, 62.1513>, <2.2822, 263.18, 61.03851> }
					triangle { <4.1778, 265.9093, 61.8039>, <7.5239, 263.4868, 64.01289>, <8.1449, 263.4455, 65.9448> }
					triangle { <8.1449, 263.4455, 65.9448>, <7.08432, 263.5045, 67.7868>, <6.5961, 263.6747, 67.1057> }
					triangle { <6.5961, 263.6747, 67.1057>, <4.1778, 265.9093, 61.8039>, <8.1449, 263.4455, 65.9448> }
					triangle { <4.1778, 265.9093, 61.8039>, <6.5961, 263.6747, 67.1057>, <3.7599, 266.1006, 62.1513> }
					triangle { <3.08535, 265.276, 61.9744>, <2.242, 263.8635, 61.5048>, <2.2822, 263.18, 61.03851> }
					triangle { <3.08535, 265.276, 61.9744>, <3.2609, 266.1317, 62.4377>, <2.242, 263.8635, 61.5048> }
					triangle { <3.08535, 265.276, 61.9744>, <3.7599, 266.1006, 62.1513>, <3.2609, 266.1317, 62.4377> }
					triangle { <2.2822, 263.18, 61.03851>, <3.7599, 266.1006, 62.1513>, <3.08535, 265.276, 61.9744> }
					triangle { <5.01231, 264.2054, 68.1102>, <3.5508, 264.4506, 66.7592>, <3.2609, 266.1317, 62.4377> }
					triangle { <6.5961, 263.6747, 67.1057>, <7.08432, 263.5045, 67.7868>, <5.01231, 264.2054, 68.1102> }
					triangle { <5.01231, 264.2054, 68.1102>, <3.2609, 266.1317, 62.4377>, <6.5961, 263.6747, 67.1057> }
					triangle { <3.7599, 266.1006, 62.1513>, <6.5961, 263.6747, 67.1057>, <3.2609, 266.1317, 62.4377> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-5.1456, 248.0538, 48.9055>, <-4.8528, 249.1618, 50.9619>, 0.2999 }
			cylinder { <-4.8528, 249.1618, 50.9619>, <-4.5181, 250.3282, 52.9794>, 0.2999 }
			cylinder { <-4.5181, 250.3282, 52.9794>, <-4.1418, 251.5514, 54.9554>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-4.1418, 251.5514, 54.9554>, <-4.6893, 254.8934, 61.1534>, 0.2999 }
				cylinder { <-4.6893, 254.8934, 61.1534>, <-6.8801, 257.7073, 67.2497>, 0.2999 }
				cylinder { <-6.8801, 257.7073, 67.2497>, <-10.5831, 259.8245, 72.879>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.5831, 259.8245, 72.879>, <-11.2237, 259.7721, 73.4016>, <-11.966, 260.4908, 74.7651> }
					triangle { <-11.2237, 259.7721, 73.4016>, <-12.6262, 260.6268, 75.4886>, <-11.966, 260.4908, 74.7651> }
					triangle { <-12.6262, 260.6268, 75.4886>, <-12.285, 261.073, 75.6168>, <-11.966, 260.4908, 74.7651> }
					triangle { <-11.966, 260.4908, 74.7651>, <-12.285, 261.073, 75.6168>, <-10.5831, 259.8245, 72.879> }
					triangle { <-12.6262, 260.6268, 75.4886>, <-16.3005, 261.754, 72.8101>, <-17.2789, 263.5017, 72.4813> }
					triangle { <-17.2789, 263.5017, 72.4813>, <-16.591, 265.4988, 72.2374>, <-15.9839, 264.9583, 72.5025> }
					triangle { <-15.9839, 264.9583, 72.5025>, <-12.6262, 260.6268, 75.4886>, <-17.2789, 263.5017, 72.4813> }
					triangle { <-12.6262, 260.6268, 75.4886>, <-15.9839, 264.9583, 72.5025>, <-12.285, 261.073, 75.6168> }
					triangle { <-11.5782, 260.9027, 74.8183>, <-10.6419, 260.39, 73.4815>, <-10.5831, 259.8245, 72.879> }
					triangle { <-11.5782, 260.9027, 74.8183>, <-11.8505, 261.4507, 75.5951>, <-10.6419, 260.39, 73.4815> }
					triangle { <-11.5782, 260.9027, 74.8183>, <-12.285, 261.073, 75.6168>, <-11.8505, 261.4507, 75.5951> }
					triangle { <-10.5831, 259.8245, 72.879>, <-12.285, 261.073, 75.6168>, <-11.5782, 260.9027, 74.8183> }
					triangle { <-14.6286, 266.3165, 72.8452>, <-12.9391, 265.324, 73.2717>, <-11.8505, 261.4507, 75.5951> }
					triangle { <-15.9839, 264.9583, 72.5025>, <-16.591, 265.4988, 72.2374>, <-14.6286, 266.3165, 72.8452> }
					triangle { <-14.6286, 266.3165, 72.8452>, <-11.8505, 261.4507, 75.5951>, <-15.9839, 264.9583, 72.5025> }
					triangle { <-12.285, 261.073, 75.6168>, <-15.9839, 264.9583, 72.5025>, <-11.8505, 261.4507, 75.5951> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-10.5831, 259.8245, 72.879>, <-10.8054, 259.7467, 73.6732>, <-11.6872, 260.4738, 74.9461> }
					triangle { <-10.8054, 259.7467, 73.6732>, <-12.06859, 260.593, 75.8507>, <-11.6872, 260.4738, 74.9461> }
					triangle { <-12.06859, 260.593, 75.8507>, <-12.285, 261.073, 75.6168>, <-11.6872, 260.4738, 74.9461> }
					triangle { <-11.6872, 260.4738, 74.9461>, <-12.285, 261.073, 75.6168>, <-10.5831, 259.8245, 72.879> }
					triangle { <-12.06859, 260.593, 75.8507>, <-15.01924, 256.9549, 75.795>, <-17.04119, 256.825, 75.6737> }
					triangle { <-17.04119, 256.825, 75.6737>, <-18.4748, 257.9017, 74.5307>, <-17.691, 258.2422, 74.5039> }
					triangle { <-17.691, 258.2422, 74.5039>, <-12.06859, 260.593, 75.8507>, <-17.04119, 256.825, 75.6737> }
					triangle { <-12.06859, 260.593, 75.8507>, <-17.691, 258.2422, 74.5039>, <-12.285, 261.073, 75.6168> }
					triangle { <-11.857, 260.9196, 74.6373>, <-11.06021, 260.4153, 73.2099>, <-10.5831, 259.8245, 72.879> }
					triangle { <-11.857, 260.9196, 74.6373>, <-12.4082, 261.4845, 75.233>, <-11.06021, 260.4153, 73.2099> }
					triangle { <-11.857, 260.9196, 74.6373>, <-12.285, 261.073, 75.6168>, <-12.4082, 261.4845, 75.233> }
					triangle { <-10.5831, 259.8245, 72.879>, <-12.285, 261.073, 75.6168>, <-11.857, 260.9196, 74.6373> }
					triangle { <-18.2017, 259.8711, 73.5632>, <-16.4912, 260.8183, 73.1183>, <-12.4082, 261.4845, 75.233> }
					triangle { <-17.691, 258.2422, 74.5039>, <-18.4748, 257.9017, 74.5307>, <-18.2017, 259.8711, 73.5632> }
					triangle { <-18.2017, 259.8711, 73.5632>, <-12.4082, 261.4845, 75.233>, <-17.691, 258.2422, 74.5039> }
					triangle { <-12.285, 261.073, 75.6168>, <-17.691, 258.2422, 74.5039>, <-12.4082, 261.4845, 75.233> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-10.5831, 259.8245, 72.879>, <-10.562, 260.1802, 73.6268>, <-11.5249, 260.7628, 74.9152> }
					triangle { <-10.562, 260.1802, 73.6268>, <-11.744, 261.171, 75.7888>, <-11.5249, 260.7628, 74.9152> }
					triangle { <-11.744, 261.171, 75.7888>, <-12.285, 261.073, 75.6168>, <-11.5249, 260.7628, 74.9152> }
					triangle { <-11.5249, 260.7628, 74.9152>, <-12.285, 261.073, 75.6168>, <-10.5831, 259.8245, 72.879> }
					triangle { <-11.744, 261.171, 75.7888>, <-9.9848, 257.8084, 78.5354>, <-10.851, 256.4018, 79.7147> }
					triangle { <-10.851, 256.4018, 79.7147>, <-12.5664, 255.174, 79.4475>, <-12.4897, 255.7874, 78.8567> }
					triangle { <-12.4897, 255.7874, 78.8567>, <-11.744, 261.171, 75.7888>, <-10.851, 256.4018, 79.7147> }
					triangle { <-11.744, 261.171, 75.7888>, <-12.4897, 255.7874, 78.8567>, <-12.285, 261.073, 75.6168> }
					triangle { <-12.01935, 260.6306, 74.6682>, <-11.3036, 259.9818, 73.2563>, <-10.5831, 259.8245, 72.879> }
					triangle { <-12.01935, 260.6306, 74.6682>, <-12.7328, 260.9065, 75.2948>, <-11.3036, 259.9818, 73.2563> }
					triangle { <-12.01935, 260.6306, 74.6682>, <-12.285, 261.073, 75.6168>, <-12.7328, 260.9065, 75.2948> }
					triangle { <-10.5831, 259.8245, 72.879>, <-12.285, 261.073, 75.6168>, <-12.01935, 260.6306, 74.6682> }
					triangle { <-14.2294, 255.4979, 78.0268>, <-14.2697, 256.6621, 76.3945>, <-12.7328, 260.9065, 75.2948> }
					triangle { <-12.4897, 255.7874, 78.8567>, <-12.5664, 255.174, 79.4475>, <-14.2294, 255.4979, 78.0268> }
					triangle { <-14.2294, 255.4979, 78.0268>, <-12.7328, 260.9065, 75.2948>, <-12.4897, 255.7874, 78.8567> }
					triangle { <-12.285, 261.073, 75.6168>, <-12.4897, 255.7874, 78.8567>, <-12.7328, 260.9065, 75.2948> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-10.5831, 259.8245, 72.879>, <-10.8275, 260.4776, 73.3261>, <-11.7019, 260.9611, 74.7148> }
					triangle { <-10.8275, 260.4776, 73.3261>, <-12.09811, 261.5675, 75.3879>, <-11.7019, 260.9611, 74.7148> }
					triangle { <-12.09811, 261.5675, 75.3879>, <-12.285, 261.073, 75.6168>, <-11.7019, 260.9611, 74.7148> }
					triangle { <-11.7019, 260.9611, 74.7148>, <-12.285, 261.073, 75.6168>, <-10.5831, 259.8245, 72.879> }
					triangle { <-12.09811, 261.5675, 75.3879>, <-8.1078, 263.143, 77.2696>, <-7.2053, 262.813, 79.0575> }
					triangle { <-7.2053, 262.813, 79.0575>, <-6.9758, 261.0599, 80.2387>, <-7.5195, 260.9634, 79.586> }
					triangle { <-7.5195, 260.9634, 79.586>, <-12.09811, 261.5675, 75.3879>, <-7.2053, 262.813, 79.0575> }
					triangle { <-12.09811, 261.5675, 75.3879>, <-7.5195, 260.9634, 79.586>, <-12.285, 261.073, 75.6168> }
					triangle { <-11.8423, 260.4323, 74.8687>, <-11.03807, 259.6844, 73.5569>, <-10.5831, 259.8245, 72.879> }
					triangle { <-11.8423, 260.4323, 74.8687>, <-12.3787, 260.51, 75.6957>, <-11.03807, 259.6844, 73.5569> }
					triangle { <-11.8423, 260.4323, 74.8687>, <-12.285, 261.073, 75.6168>, <-12.3787, 260.51, 75.6957> }
					triangle { <-10.5831, 259.8245, 72.879>, <-12.285, 261.073, 75.6168>, <-11.8423, 260.4323, 74.8687> }
					triangle { <-8.1642, 259.1999, 80.109>, <-9.324, 258.5605, 78.6032>, <-12.3787, 260.51, 75.6957> }
					triangle { <-7.5195, 260.9634, 79.586>, <-6.9758, 261.0599, 80.2387>, <-8.1642, 259.1999, 80.109> }
					triangle { <-8.1642, 259.1999, 80.109>, <-12.3787, 260.51, 75.6957>, <-7.5195, 260.9634, 79.586> }
					triangle { <-12.285, 261.073, 75.6168>, <-7.5195, 260.9634, 79.586>, <-12.3787, 260.51, 75.6957> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-10.5831, 259.8245, 72.879>, <-11.2427, 260.2215, 73.1848>, <-11.9787, 260.7904, 74.6206> }
					triangle { <-11.2427, 260.2215, 73.1848>, <-12.6516, 261.2261, 75.1996>, <-11.9787, 260.7904, 74.6206> }
					triangle { <-12.6516, 261.2261, 75.1996>, <-12.285, 261.073, 75.6168>, <-11.9787, 260.7904, 74.6206> }
					triangle { <-11.9787, 260.7904, 74.6206>, <-12.285, 261.073, 75.6168>, <-10.5831, 259.8245, 72.879> }
					triangle { <-12.6516, 261.2261, 75.1996>, <-12.07007, 265.6183, 73.6778>, <-11.2379, 267.2672, 74.5194> }
					triangle { <-11.2379, 267.2672, 74.5194>, <-9.5007, 267.5373, 75.7154>, <-9.7116, 266.7169, 75.5996> }
					triangle { <-9.7116, 266.7169, 75.5996>, <-12.6516, 261.2261, 75.1996>, <-11.2379, 267.2672, 74.5194> }
					triangle { <-12.6516, 261.2261, 75.1996>, <-9.7116, 266.7169, 75.5996>, <-12.285, 261.073, 75.6168> }
					triangle { <-11.5655, 260.603, 74.9629>, <-10.6229, 259.9405, 73.6982>, <-10.5831, 259.8245, 72.879> }
					triangle { <-11.5655, 260.603, 74.9629>, <-11.8252, 260.8514, 75.8841>, <-10.6229, 259.9405, 73.6982> }
					triangle { <-11.5655, 260.603, 74.9629>, <-12.285, 261.073, 75.6168>, <-11.8252, 260.8514, 75.8841> }
					triangle { <-10.5831, 259.8245, 72.879>, <-12.285, 261.073, 75.6168>, <-11.5655, 260.603, 74.9629> }
					triangle { <-8.4146, 265.987, 76.8583>, <-8.4892, 263.9946, 76.6441>, <-11.8252, 260.8514, 75.8841> }
					triangle { <-9.7116, 266.7169, 75.5996>, <-9.5007, 267.5373, 75.7154>, <-8.4146, 265.987, 76.8583> }
					triangle { <-8.4146, 265.987, 76.8583>, <-11.8252, 260.8514, 75.8841>, <-9.7116, 266.7169, 75.5996> }
					triangle { <-12.285, 261.073, 75.6168>, <-9.7116, 266.7169, 75.5996>, <-11.8252, 260.8514, 75.8841> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-4.1418, 251.5514, 54.9554>, <-3.8429, 252.7602, 56.9534>, 0.2999 }
			cylinder { <-3.8429, 252.7602, 56.9534>, <-3.6218, 253.953, 58.971>, 0.2999 }
			cylinder { <-3.6218, 253.953, 58.971>, <-3.4786, 255.1286, 61.00582>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.4786, 255.1286, 61.00582>, <-1.5529, 257.8004, 67.2537>, 0.2999 }
				cylinder { <-1.5529, 257.8004, 67.2537>, <1.7535, 259.4572, 73.2707>, 0.2999 }
				cylinder { <1.7535, 259.4572, 73.2707>, <6.2425, 259.9998, 78.6963>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <6.2425, 259.9998, 78.6963>, <7.017, 259.947, 78.9855>, <7.9929, 260.1138, 80.3807> }
					triangle { <7.017, 259.947, 78.9855>, <8.8102, 260.115, 80.9373>, <7.9929, 260.1138, 80.3807> }
					triangle { <8.8102, 260.115, 80.9373>, <8.4397, 260.2654, 81.3521>, <7.9929, 260.1138, 80.3807> }
					triangle { <7.9929, 260.1138, 80.3807>, <8.4397, 260.2654, 81.3521>, <6.2425, 259.9998, 78.6963> }
					triangle { <8.8102, 260.115, 80.9373>, <9.7141, 255.5214, 80.7721>, <9.5671, 254.0397, 82.1516> }
					triangle { <9.5671, 254.0397, 82.1516>, <8.1124, 253.6178, 83.6439>, <8.01452, 254.3846, 83.2784> }
					triangle { <8.01452, 254.3846, 83.2784>, <8.8102, 260.115, 80.9373>, <9.5671, 254.0397, 82.1516> }
					triangle { <8.8102, 260.115, 80.9373>, <8.01452, 254.3846, 83.2784>, <8.4397, 260.2654, 81.3521> }
					triangle { <7.5622, 260.257, 80.7227>, <6.3709, 260.1618, 79.4985>, <6.2425, 259.9998, 78.6963> }
					triangle { <7.5622, 260.257, 80.7227>, <7.9489, 260.4013, 81.6213>, <6.3709, 260.1618, 79.4985> }
					triangle { <7.5622, 260.257, 80.7227>, <8.4397, 260.2654, 81.3521>, <7.9489, 260.4013, 81.6213> }
					triangle { <6.2425, 259.9998, 78.6963>, <8.4397, 260.2654, 81.3521>, <7.5622, 260.257, 80.7227> }
					triangle { <6.6241, 255.0181, 84.4886>, <5.9815, 256.7622, 83.7362>, <7.9489, 260.4013, 81.6213> }
					triangle { <8.01452, 254.3846, 83.2784>, <8.1124, 253.6178, 83.6439>, <6.6241, 255.0181, 84.4886> }
					triangle { <6.6241, 255.0181, 84.4886>, <7.9489, 260.4013, 81.6213>, <8.01452, 254.3846, 83.2784> }
					triangle { <8.4397, 260.2654, 81.3521>, <8.01452, 254.3846, 83.2784>, <7.9489, 260.4013, 81.6213> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <6.2425, 259.9998, 78.6963>, <6.8549, 260.4111, 79.07325>, <7.8848, 260.4232, 80.4391> }
					triangle { <6.8549, 260.4111, 79.07325>, <8.5941, 260.7338, 81.05424>, <7.8848, 260.4232, 80.4391> }
					triangle { <8.5941, 260.7338, 81.05424>, <8.4397, 260.2654, 81.3521>, <7.8848, 260.4232, 80.4391> }
					triangle { <7.8848, 260.4232, 80.4391>, <8.4397, 260.2654, 81.3521>, <6.2425, 259.9998, 78.6963> }
					triangle { <8.5941, 260.7338, 81.05424>, <12.2576, 260.0568, 78.2142>, <13.7647, 258.6973, 78.2128> }
					triangle { <13.7647, 258.6973, 78.2128>, <13.8076, 256.6132, 78.6323>, <13.06707, 256.9879, 78.8377> }
					triangle { <13.06707, 256.9879, 78.8377>, <8.5941, 260.7338, 81.05424>, <13.7647, 258.6973, 78.2128> }
					triangle { <8.5941, 260.7338, 81.05424>, <13.06707, 256.9879, 78.8377>, <8.4397, 260.2654, 81.3521> }
					triangle { <7.6702, 259.9475, 80.6643>, <6.533, 259.6977, 79.4109>, <6.2425, 259.9998, 78.6963> }
					triangle { <7.6702, 259.9475, 80.6643>, <8.165, 259.7825, 81.5044>, <6.533, 259.6977, 79.4109> }
					triangle { <7.6702, 259.9475, 80.6643>, <8.4397, 260.2654, 81.3521>, <8.165, 259.7825, 81.5044> }
					triangle { <6.2425, 259.9998, 78.6963>, <8.4397, 260.2654, 81.3521>, <7.6702, 259.9475, 80.6643> }
					triangle { <12.2984, 255.4471, 79.751>, <10.3979, 255.9346, 80.165>, <8.165, 259.7825, 81.5044> }
					triangle { <13.06707, 256.9879, 78.8377>, <13.8076, 256.6132, 78.6323>, <12.2984, 255.4471, 79.751> }
					triangle { <12.2984, 255.4471, 79.751>, <8.165, 259.7825, 81.5044>, <13.06707, 256.9879, 78.8377> }
					triangle { <8.4397, 260.2654, 81.3521>, <13.06707, 256.9879, 78.8377>, <8.165, 259.7825, 81.5044> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <6.2425, 259.9998, 78.6963>, <6.4719, 260.3856, 79.3926>, <7.6295, 260.4062, 80.6521> }
					triangle { <6.4719, 260.3856, 79.3926>, <8.08352, 260.6997, 81.4801>, <7.6295, 260.4062, 80.6521> }
					triangle { <8.08352, 260.6997, 81.4801>, <8.4397, 260.2654, 81.3521>, <7.6295, 260.4062, 80.6521> }
					triangle { <7.6295, 260.4062, 80.6521>, <8.4397, 260.2654, 81.3521>, <6.2425, 259.9998, 78.6963> }
					triangle { <8.08352, 260.6997, 81.4801>, <9.5606, 264.8785, 79.9634>, <11.3968, 265.5972, 79.4819> }
					triangle { <11.3968, 265.5972, 79.4819>, <13.04371, 264.7316, 78.4525>, <12.429, 264.17, 78.6473> }
					triangle { <12.429, 264.17, 78.6473>, <8.08352, 260.6997, 81.4801>, <11.3968, 265.5972, 79.4819> }
					triangle { <8.08352, 260.6997, 81.4801>, <12.429, 264.17, 78.6473>, <8.4397, 260.2654, 81.3521> }
					triangle { <7.9256, 259.9646, 80.4513>, <6.916, 259.7232, 79.09148>, <6.2425, 259.9998, 78.6963> }
					triangle { <7.9256, 259.9646, 80.4513>, <8.6756, 259.8166, 81.07855>, <6.916, 259.7232, 79.09148> }
					triangle { <7.9256, 259.9646, 80.4513>, <8.4397, 260.2654, 81.3521>, <8.6756, 259.8166, 81.07855> }
					triangle { <6.2425, 259.9998, 78.6963>, <8.4397, 260.2654, 81.3521>, <7.9256, 259.9646, 80.4513> }
					triangle { <13.4198, 262.5798, 78.1099>, <12.1264, 261.0516, 78.2232>, <8.6756, 259.8166, 81.07855> }
					triangle { <12.429, 264.17, 78.6473>, <13.04371, 264.7316, 78.4525>, <13.4198, 262.5798, 78.1099> }
					triangle { <13.4198, 262.5798, 78.1099>, <8.6756, 259.8166, 81.07855>, <12.429, 264.17, 78.6473> }
					triangle { <8.4397, 260.2654, 81.3521>, <12.429, 264.17, 78.6473>, <8.6756, 259.8166, 81.07855> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <6.2425, 259.9998, 78.6963>, <6.3937, 259.9054, 79.5053>, <7.5774, 260.0861, 80.7272> }
					triangle { <6.3937, 259.9054, 79.5053>, <7.9792, 260.0595, 81.6304>, <7.5774, 260.0861, 80.7272> }
					triangle { <7.9792, 260.0595, 81.6304>, <8.4397, 260.2654, 81.3521>, <7.5774, 260.0861, 80.7272> }
					triangle { <7.5774, 260.0861, 80.7272>, <8.4397, 260.2654, 81.3521>, <6.2425, 259.9998, 78.6963> }
					triangle { <7.9792, 260.0595, 81.6304>, <5.3251, 263.3681, 83.6188>, <5.7136, 265.2684, 84.2169> }
					triangle { <5.7136, 265.2684, 84.2169>, <6.8691, 266.8294, 83.3513>, <6.9762, 266.0724, 82.9685> }
					triangle { <6.9762, 266.0724, 82.9685>, <7.9792, 260.0595, 81.6304>, <5.7136, 265.2684, 84.2169> }
					triangle { <7.9792, 260.0595, 81.6304>, <6.9762, 266.0724, 82.9685>, <8.4397, 260.2654, 81.3521> }
					triangle { <7.9777, 260.2847, 80.3762>, <6.9942, 260.2033, 78.9787>, <6.2425, 259.9998, 78.6963> }
					triangle { <7.9777, 260.2847, 80.3762>, <8.7798, 260.4567, 80.9282>, <6.9942, 260.2033, 78.9787> }
					triangle { <7.9777, 260.2847, 80.3762>, <8.4397, 260.2654, 81.3521>, <8.7798, 260.4567, 80.9282> }
					triangle { <6.2425, 259.9998, 78.6963>, <8.4397, 260.2654, 81.3521>, <7.9777, 260.2847, 80.3762> }
					triangle { <8.4491, 266.6256, 81.8179>, <8.7945, 265.0894, 80.5761>, <8.7798, 260.4567, 80.9282> }
					triangle { <6.9762, 266.0724, 82.9685>, <6.8691, 266.8294, 83.3513>, <8.4491, 266.6256, 81.8179> }
					triangle { <8.4491, 266.6256, 81.8179>, <8.7798, 260.4567, 80.9282>, <6.9762, 266.0724, 82.9685> }
					triangle { <8.4397, 260.2654, 81.3521>, <6.9762, 266.0724, 82.9685>, <8.7798, 260.4567, 80.9282> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <6.2425, 259.9998, 78.6963>, <6.7357, 259.6303, 79.2499>, <7.8053, 259.9026, 80.557> }
					triangle { <6.7357, 259.6303, 79.2499>, <8.4351, 259.6927, 81.2898>, <7.8053, 259.9026, 80.557> }
					triangle { <8.4351, 259.6927, 81.2898>, <8.4397, 260.2654, 81.3521>, <7.8053, 259.9026, 80.557> }
					triangle { <7.8053, 259.9026, 80.557>, <8.4397, 260.2654, 81.3521>, <6.2425, 259.9998, 78.6963> }
					triangle { <8.4351, 259.6927, 81.2898>, <5.4214, 257.4978, 84.1261>, <4.5657, 258.0177, 85.8918> }
					triangle { <4.5657, 258.0177, 85.8918>, <3.7754, 259.8571, 86.6083>, <4.2067, 259.9334, 85.8739> }
					triangle { <4.2067, 259.9334, 85.8739>, <8.4351, 259.6927, 81.2898>, <4.5657, 258.0177, 85.8918> }
					triangle { <8.4351, 259.6927, 81.2898>, <4.2067, 259.9334, 85.8739>, <8.4397, 260.2654, 81.3521> }
					triangle { <7.7497, 260.4681, 80.5464>, <6.6522, 260.4785, 79.2341>, <6.2425, 259.9998, 78.6963> }
					triangle { <7.7497, 260.4681, 80.5464>, <8.3239, 260.8236, 81.2688>, <6.6522, 260.4785, 79.2341> }
					triangle { <7.7497, 260.4681, 80.5464>, <8.4397, 260.2654, 81.3521>, <8.3239, 260.8236, 81.2688> }
					triangle { <6.2425, 259.9998, 78.6963>, <8.4397, 260.2654, 81.3521>, <7.7497, 260.4681, 80.5464> }
					triangle { <4.1857, 261.8817, 85.8197>, <4.9394, 262.3984, 84.03485>, <8.3239, 260.8236, 81.2688> }
					triangle { <4.2067, 259.9334, 85.8739>, <3.7754, 259.8571, 86.6083>, <4.1857, 261.8817, 85.8197> }
					triangle { <4.1857, 261.8817, 85.8197>, <8.3239, 260.8236, 81.2688>, <4.2067, 259.9334, 85.8739> }
					triangle { <8.4397, 260.2654, 81.3521>, <4.2067, 259.9334, 85.8739>, <8.3239, 260.8236, 81.2688> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-3.4786, 255.1286, 61.00582>, <-3.2619, 256.2708, 63.053>, 0.2999 }
			cylinder { <-3.2619, 256.2708, 63.053>, <-2.9718, 257.3783, 65.1101>, 0.2999 }
			cylinder { <-2.9718, 257.3783, 65.1101>, <-2.6089, 258.4496, 67.1748>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.6089, 258.4496, 67.1748>, <-2.1115, 263.0458, 72.5144>, 0.2999 }
				cylinder { <-2.1115, 263.0458, 72.5144>, <-2.2353, 268.7485, 76.6793>, 0.2999 }
				cylinder { <-2.2353, 268.7485, 76.6793>, <-2.9728, 275.2159, 79.4201>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-2.9728, 275.2159, 79.4201>, <-3.2145, 276.0065, 79.4721>, <-3.05117, 277.4524, 80.3718> }
					triangle { <-3.2145, 276.0065, 79.4721>, <-3.1921, 278.3965, 80.6301>, <-3.05117, 277.4524, 80.3718> }
					triangle { <-3.1921, 278.3965, 80.6301>, <-2.8253, 278.2595, 81.05284>, <-3.05117, 277.4524, 80.3718> }
					triangle { <-3.05117, 277.4524, 80.3718>, <-2.8253, 278.2595, 81.05284>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-3.1921, 278.3965, 80.6301>, <-1.151, 280.3964, 76.918>, <0.5949, 281.4049, 76.6851> }
					triangle { <0.5949, 281.4049, 76.6851>, <2.54, 281.0959, 77.4866>, <1.9392, 280.6076, 77.8496> }
					triangle { <1.9392, 280.6076, 77.8496>, <-3.1921, 278.3965, 80.6301>, <0.5949, 281.4049, 76.6851> }
					triangle { <-3.1921, 278.3965, 80.6301>, <1.9392, 280.6076, 77.8496>, <-2.8253, 278.2595, 81.05284> }
					triangle { <-2.6884, 277.2321, 80.7497>, <-2.6705, 275.676, 80.03913>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-2.6884, 277.2321, 80.7497>, <-2.4667, 277.9558, 81.386>, <-2.6705, 275.676, 80.03913> }
					triangle { <-2.6884, 277.2321, 80.7497>, <-2.8253, 278.2595, 81.05284>, <-2.4667, 277.9558, 81.386> }
					triangle { <-2.9728, 275.2159, 79.4201>, <-2.8253, 278.2595, 81.05284>, <-2.6884, 277.2321, 80.7497> }
					triangle { <3.07327, 279.8994, 79.2679>, <1.9922, 278.4869, 80.1938>, <-2.4667, 277.9558, 81.386> }
					triangle { <1.9392, 280.6076, 77.8496>, <2.54, 281.0959, 77.4866>, <3.07327, 279.8994, 79.2679> }
					triangle { <3.07327, 279.8994, 79.2679>, <-2.4667, 277.9558, 81.386>, <1.9392, 280.6076, 77.8496> }
					triangle { <-2.8253, 278.2595, 81.05284>, <1.9392, 280.6076, 77.8496>, <-2.4667, 277.9558, 81.386> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-2.9728, 275.2159, 79.4201>, <-3.3389, 275.7826, 79.9008>, <-3.1341, 277.3032, 80.6575> }
					triangle { <-3.3389, 275.7826, 79.9008>, <-3.3579, 278.0979, 81.2016>, <-3.1341, 277.3032, 80.6575> }
					triangle { <-3.3579, 278.0979, 81.2016>, <-2.8253, 278.2595, 81.05284>, <-3.1341, 277.3032, 80.6575> }
					triangle { <-3.1341, 277.3032, 80.6575>, <-2.8253, 278.2595, 81.05284>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-3.3579, 278.0979, 81.2016>, <-6.7149, 279.8481, 78.4426>, <-6.7894, 281.472, 77.2271> }
					triangle { <-6.7894, 281.472, 77.2271>, <-5.365, 282.3293, 75.9013>, <-5.03941, 281.7203, 76.4055> }
					triangle { <-5.03941, 281.7203, 76.4055>, <-3.3579, 278.0979, 81.2016>, <-6.7894, 281.472, 77.2271> }
					triangle { <-3.3579, 278.0979, 81.2016>, <-5.03941, 281.7203, 76.4055>, <-2.8253, 278.2595, 81.05284> }
					triangle { <-2.6055, 277.3814, 80.464>, <-2.5461, 275.8999, 79.6104>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-2.6055, 277.3814, 80.464>, <-2.3008, 278.2544, 80.8145>, <-2.5461, 275.8999, 79.6104> }
					triangle { <-2.6055, 277.3814, 80.464>, <-2.8253, 278.2595, 81.05284>, <-2.3008, 278.2544, 80.8145> }
					triangle { <-2.9728, 275.2159, 79.4201>, <-2.8253, 278.2595, 81.05284>, <-2.6055, 277.3814, 80.464> }
					triangle { <-3.1776, 282.0065, 75.9044>, <-2.1342, 280.526, 76.7651>, <-2.3008, 278.2544, 80.8145> }
					triangle { <-5.03941, 281.7203, 76.4055>, <-5.365, 282.3293, 75.9013>, <-3.1776, 282.0065, 75.9044> }
					triangle { <-3.1776, 282.0065, 75.9044>, <-2.3008, 278.2544, 80.8145>, <-5.03941, 281.7203, 76.4055> }
					triangle { <-2.8253, 278.2595, 81.05284>, <-5.03941, 281.7203, 76.4055>, <-2.3008, 278.2544, 80.8145> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-2.9728, 275.2159, 79.4201>, <-2.9192, 275.6392, 80.1302>, <-2.8542, 277.2076, 80.8105> }
					triangle { <-2.9192, 275.6392, 80.1302>, <-2.7983, 277.9067, 81.5075>, <-2.8542, 277.2076, 80.8105> }
					triangle { <-2.7983, 277.9067, 81.5075>, <-2.8253, 278.2595, 81.05284>, <-2.8542, 277.2076, 80.8105> }
					triangle { <-2.8542, 277.2076, 80.8105>, <-2.8253, 278.2595, 81.05284>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-2.7983, 277.9067, 81.5075>, <-6.9399, 277.1193, 83.55>, <-8.6826, 278.1596, 83.573> }
					triangle { <-8.6826, 278.1596, 83.573>, <-9.7231, 279.2354, 82.0626>, <-8.9346, 278.9984, 81.8317> }
					triangle { <-8.9346, 278.9984, 81.8317>, <-2.7983, 277.9067, 81.5075>, <-8.6826, 278.1596, 83.573> }
					triangle { <-2.7983, 277.9067, 81.5075>, <-8.9346, 278.9984, 81.8317>, <-2.8253, 278.2595, 81.05284> }
					triangle { <-2.8853, 277.477, 80.3111>, <-2.9658, 276.0433, 79.381>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-2.8853, 277.477, 80.3111>, <-2.8605, 278.4456, 80.5087>, <-2.9658, 276.0433, 79.381> }
					triangle { <-2.8853, 277.477, 80.3111>, <-2.8253, 278.2595, 81.05284>, <-2.8605, 278.4456, 80.5087> }
					triangle { <-2.9728, 275.2159, 79.4201>, <-2.8253, 278.2595, 81.05284>, <-2.8853, 277.477, 80.3111> }
					triangle { <-8.8951, 280.0005, 80.1604>, <-7.2094, 279.4541, 79.2218>, <-2.8605, 278.4456, 80.5087> }
					triangle { <-8.9346, 278.9984, 81.8317>, <-9.7231, 279.2354, 82.0626>, <-8.8951, 280.0005, 80.1604> }
					triangle { <-8.8951, 280.0005, 80.1604>, <-2.8605, 278.4456, 80.5087>, <-8.9346, 278.9984, 81.8317> }
					triangle { <-2.8253, 278.2595, 81.05284>, <-8.9346, 278.9984, 81.8317>, <-2.8605, 278.4456, 80.5087> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-2.9728, 275.2159, 79.4201>, <-2.5315, 275.7732, 79.8454>, <-2.5958, 277.2969, 80.6206> }
					triangle { <-2.5315, 275.7732, 79.8454>, <-2.2813, 278.0854, 81.1278>, <-2.5958, 277.2969, 80.6206> }
					triangle { <-2.2813, 278.0854, 81.1278>, <-2.8253, 278.2595, 81.05284>, <-2.5958, 277.2969, 80.6206> }
					triangle { <-2.5958, 277.2969, 80.6206>, <-2.8253, 278.2595, 81.05284>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-2.2813, 278.0854, 81.1278>, <-1.5171, 275.9556, 85.2297>, <-2.4861, 276.0146, 87.01224> }
					triangle { <-2.4861, 276.0146, 87.01224>, <-4.552, 276.0611, 87.5131>, <-4.3997, 276.178, 86.6799> }
					triangle { <-4.3997, 276.178, 86.6799>, <-2.2813, 278.0854, 81.1278>, <-2.4861, 276.0146, 87.01224> }
					triangle { <-2.2813, 278.0854, 81.1278>, <-4.3997, 276.178, 86.6799>, <-2.8253, 278.2595, 81.05284> }
					triangle { <-3.1438, 277.3877, 80.5009>, <-3.3535, 275.9094, 79.6658>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-3.1438, 277.3877, 80.5009>, <-3.3774, 278.2669, 80.8883>, <-3.3535, 275.9094, 79.6658> }
					triangle { <-3.1438, 277.3877, 80.5009>, <-2.8253, 278.2595, 81.05284>, <-3.3774, 278.2669, 80.8883> }
					triangle { <-2.9728, 275.2159, 79.4201>, <-2.8253, 278.2595, 81.05284>, <-3.1438, 277.3877, 80.5009> }
					triangle { <-6.2311, 276.635, 86.1939>, <-6.2669, 276.7425, 84.1918>, <-3.3774, 278.2669, 80.8883> }
					triangle { <-4.3997, 276.178, 86.6799>, <-4.552, 276.0611, 87.5131>, <-6.2311, 276.635, 86.1939> }
					triangle { <-6.2311, 276.635, 86.1939>, <-3.3774, 278.2669, 80.8883>, <-4.3997, 276.178, 86.6799> }
					triangle { <-2.8253, 278.2595, 81.05284>, <-4.3997, 276.178, 86.6799>, <-3.3774, 278.2669, 80.8883> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-2.9728, 275.2159, 79.4201>, <-2.7167, 276.0036, 79.4326>, <-2.7193, 277.4505, 80.3454> }
					triangle { <-2.7167, 276.0036, 79.4326>, <-2.5284, 278.3926, 80.5774>, <-2.7193, 277.4505, 80.3454> }
					triangle { <-2.5284, 278.3926, 80.5774>, <-2.8253, 278.2595, 81.05284>, <-2.7193, 277.4505, 80.3454> }
					triangle { <-2.7193, 277.4505, 80.3454>, <-2.8253, 278.2595, 81.05284>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-2.5284, 278.3926, 80.5774>, <2.1146, 278.0115, 81.06905>, <3.3343, 278.0506, 82.6909> }
					triangle { <3.3343, 278.0506, 82.6909>, <3.1413, 277.2283, 84.6423>, <2.4221, 277.1876, 84.1817> }
					triangle { <2.4221, 277.1876, 84.1817>, <-2.5284, 278.3926, 80.5774>, <3.3343, 278.0506, 82.6909> }
					triangle { <-2.5284, 278.3926, 80.5774>, <2.4221, 277.1876, 84.1817>, <-2.8253, 278.2595, 81.05284> }
					triangle { <-3.02033, 277.234, 80.7761>, <-3.1683, 275.6789, 80.07867>, <-2.9728, 275.2159, 79.4201> }
					triangle { <-3.02033, 277.234, 80.7761>, <-3.1304, 277.9597, 81.4388>, <-3.1683, 275.6789, 80.07867> }
					triangle { <-3.02033, 277.234, 80.7761>, <-2.8253, 278.2595, 81.05284>, <-3.1304, 277.9597, 81.4388> }
					triangle { <-2.9728, 275.2159, 79.4201>, <-2.8253, 278.2595, 81.05284>, <-3.02033, 277.234, 80.7761> }
					triangle { <1.2773, 276.5716, 85.634>, <-0.4941, 276.1357, 84.8016>, <-3.1304, 277.9597, 81.4388> }
					triangle { <2.4221, 277.1876, 84.1817>, <3.1413, 277.2283, 84.6423>, <1.2773, 276.5716, 85.634> }
					triangle { <1.2773, 276.5716, 85.634>, <-3.1304, 277.9597, 81.4388>, <2.4221, 277.1876, 84.1817> }
					triangle { <-2.8253, 278.2595, 81.05284>, <2.4221, 277.1876, 84.1817>, <-3.1304, 277.9597, 81.4388> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-2.6089, 258.4496, 67.1748>, <-2.2765, 259.5898, 69.2076>, 0.2999 }
			cylinder { <-2.2765, 259.5898, 69.2076>, <-1.975, 260.7973, 71.2059>, 0.2999 }
			cylinder { <-1.975, 260.7973, 71.2059>, <-1.7047, 262.0707, 73.1675>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.7047, 262.0707, 73.1675>, <-1.5636, 264.485, 79.8034>, 0.2999 }
				cylinder { <-1.5636, 264.485, 79.8034>, <-2.1007, 265.3484, 86.7926>, 0.2999 }
				cylinder { <-2.1007, 265.3484, 86.7926>, <-3.284, 264.6093, 93.7162>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-3.284, 264.6093, 93.7162>, <-3.2916, 264.0799, 94.3083>, <-3.5097, 263.8911, 95.923> }
					triangle { <-3.2916, 264.0799, 94.3083>, <-3.5686, 263.4492, 96.7597>, <-3.5097, 263.8911, 95.923> }
					triangle { <-3.5686, 263.4492, 96.7597>, <-3.6769, 263.959, 96.9425>, <-3.5097, 263.8911, 95.923> }
					triangle { <-3.5097, 263.8911, 95.923>, <-3.6769, 263.959, 96.9425>, <-3.284, 264.6093, 93.7162> }
					triangle { <-3.5686, 263.4492, 96.7597>, <-7.2374, 261.0005, 95.9126>, <-9.07269, 261.1096, 96.5507> }
					triangle { <-9.07269, 261.1096, 96.5507>, <-10.3062, 262.6933, 96.9062>, <-9.5281, 262.9094, 96.7647> }
					triangle { <-9.5281, 262.9094, 96.7647>, <-3.5686, 263.4492, 96.7597>, <-9.07269, 261.1096, 96.5507> }
					triangle { <-3.5686, 263.4492, 96.7597>, <-9.5281, 262.9094, 96.7647>, <-3.6769, 263.959, 96.9425> }
					triangle { <-3.6073, 264.4188, 96.01749>, <-3.4379, 264.8714, 94.45>, <-3.284, 264.6093, 93.7162> }
					triangle { <-3.6073, 264.4188, 96.01749>, <-3.7637, 264.5045, 96.9486>, <-3.4379, 264.8714, 94.45> }
					triangle { <-3.6073, 264.4188, 96.01749>, <-3.6769, 263.959, 96.9425>, <-3.7637, 264.5045, 96.9486> }
					triangle { <-3.284, 264.6093, 93.7162>, <-3.6769, 263.959, 96.9425>, <-3.6073, 264.4188, 96.01749> }
					triangle { <-9.7391, 264.7154, 97.1963>, <-8.0827, 265.5736, 96.7313>, <-3.7637, 264.5045, 96.9486> }
					triangle { <-9.5281, 262.9094, 96.7647>, <-10.3062, 262.6933, 96.9062>, <-9.7391, 264.7154, 97.1963> }
					triangle { <-9.7391, 264.7154, 97.1963>, <-3.7637, 264.5045, 96.9486>, <-9.5281, 262.9094, 96.7647> }
					triangle { <-3.6769, 263.959, 96.9425>, <-9.5281, 262.9094, 96.7647>, <-3.7637, 264.5045, 96.9486> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.284, 264.6093, 93.7162>, <-2.9628, 264.4112, 94.4151>, <-3.2906, 264.112, 95.9942> }
					triangle { <-2.9628, 264.4112, 94.4151>, <-3.1303, 263.8908, 96.9021>, <-3.2906, 264.112, 95.9942> }
					triangle { <-3.1303, 263.8908, 96.9021>, <-3.6769, 263.959, 96.9425>, <-3.2906, 264.112, 95.9942> }
					triangle { <-3.2906, 264.112, 95.9942>, <-3.6769, 263.959, 96.9425>, <-3.284, 264.6093, 93.7162> }
					triangle { <-3.1303, 263.8908, 96.9021>, <-1.8675, 259.6243, 96.2893>, <-2.7294, 257.9241, 96.6813> }
					triangle { <-2.7294, 257.9241, 96.6813>, <-4.6611, 257.2963, 96.5061>, <-4.5682, 258.104, 96.4003> }
					triangle { <-4.5682, 258.104, 96.4003>, <-3.1303, 263.8908, 96.9021>, <-2.7294, 257.9241, 96.6813> }
					triangle { <-3.1303, 263.8908, 96.9021>, <-4.5682, 258.104, 96.4003>, <-3.6769, 263.959, 96.9425> }
					triangle { <-3.8265, 264.198, 95.9463>, <-3.7666, 264.5402, 94.3432>, <-3.284, 264.6093, 93.7162> }
					triangle { <-3.8265, 264.198, 95.9463>, <-4.2021, 264.0629, 96.8062>, <-3.7666, 264.5402, 94.3432> }
					triangle { <-3.8265, 264.198, 95.9463>, <-3.6769, 263.959, 96.9425>, <-4.2021, 264.0629, 96.8062> }
					triangle { <-3.284, 264.6093, 93.7162>, <-3.6769, 263.959, 96.9425>, <-3.8265, 264.198, 95.9463> }
					triangle { <-6.3914, 258.5119, 96.3537>, <-6.5119, 260.3698, 95.8738>, <-4.2021, 264.0629, 96.8062> }
					triangle { <-4.5682, 258.104, 96.4003>, <-4.6611, 257.2963, 96.5061>, <-6.3914, 258.5119, 96.3537> }
					triangle { <-6.3914, 258.5119, 96.3537>, <-4.2021, 264.0629, 96.8062>, <-4.5682, 258.104, 96.4003> }
					triangle { <-3.6769, 263.959, 96.9425>, <-4.5682, 258.104, 96.4003>, <-4.2021, 264.0629, 96.8062> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.284, 264.6093, 93.7162>, <-3.1857, 264.831, 94.4725>, <-3.4392, 264.3918, 96.03253> }
					triangle { <-3.1857, 264.831, 94.4725>, <-3.4275, 264.4506, 96.9787>, <-3.4392, 264.3918, 96.03253> }
					triangle { <-3.4275, 264.4506, 96.9787>, <-3.6769, 263.959, 96.9425>, <-3.4392, 264.3918, 96.03253> }
					triangle { <-3.4392, 264.3918, 96.03253>, <-3.6769, 263.959, 96.9425>, <-3.284, 264.6093, 93.7162> }
					triangle { <-3.4275, 264.4506, 96.9787>, <1.01864, 264.1982, 97.5627>, <2.1801, 262.8023, 98.2625> }
					triangle { <2.1801, 262.8023, 98.2625>, <2.1722, 260.7758, 98.03973>, <1.4968, 261.1398, 97.7509> }
					triangle { <1.4968, 261.1398, 97.7509>, <-3.4275, 264.4506, 96.9787>, <2.1801, 262.8023, 98.2625> }
					triangle { <-3.4275, 264.4506, 96.9787>, <1.4968, 261.1398, 97.7509>, <-3.6769, 263.959, 96.9425> }
					triangle { <-3.6778, 263.9182, 95.9079>, <-3.5437, 264.1204, 94.2857>, <-3.284, 264.6093, 93.7162> }
					triangle { <-3.6778, 263.9182, 95.9079>, <-3.9048, 263.5031, 96.7296>, <-3.5437, 264.1204, 94.2857> }
					triangle { <-3.6778, 263.9182, 95.9079>, <-3.6769, 263.959, 96.9425>, <-3.9048, 263.5031, 96.7296> }
					triangle { <-3.284, 264.6093, 93.7162>, <-3.6769, 263.959, 96.9425>, <-3.6778, 263.9182, 95.9079> }
					triangle { <0.5492, 259.5652, 97.4114>, <-1.04982, 260.0926, 96.4833>, <-3.9048, 263.5031, 96.7296> }
					triangle { <1.4968, 261.1398, 97.7509>, <2.1722, 260.7758, 98.03973>, <0.5492, 259.5652, 97.4114> }
					triangle { <0.5492, 259.5652, 97.4114>, <-3.9048, 263.5031, 96.7296>, <1.4968, 261.1398, 97.7509> }
					triangle { <-3.6769, 263.959, 96.9425>, <1.4968, 261.1398, 97.7509>, <-3.9048, 263.5031, 96.7296> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.284, 264.6093, 93.7162>, <-3.6543, 264.7631, 94.4018>, <-3.7516, 264.3466, 95.9853> }
					triangle { <-3.6543, 264.7631, 94.4018>, <-4.05238, 264.36, 96.8843>, <-3.7516, 264.3466, 95.9853> }
					triangle { <-4.05238, 264.36, 96.8843>, <-3.6769, 263.959, 96.9425>, <-3.7516, 264.3466, 95.9853> }
					triangle { <-3.7516, 264.3466, 95.9853>, <-3.6769, 263.959, 96.9425>, <-3.284, 264.6093, 93.7162> }
					triangle { <-4.05238, 264.36, 96.8843>, <-2.5405, 268.4438, 97.9848>, <-1.08297, 269.0482, 99.1238> }
					triangle { <-1.08297, 269.0482, 99.1238>, <0.8142, 268.3557, 99.402>, <0.3419, 267.8498, 98.9626> }
					triangle { <0.3419, 267.8498, 98.9626>, <-4.05238, 264.36, 96.8843>, <-1.08297, 269.0482, 99.1238> }
					triangle { <-4.05238, 264.36, 96.8843>, <0.3419, 267.8498, 98.9626>, <-3.6769, 263.959, 96.9425> }
					triangle { <-3.3654, 263.9634, 95.9551>, <-3.07513, 264.1883, 94.3565>, <-3.284, 264.6093, 93.7162> }
					triangle { <-3.3654, 263.9634, 95.9551>, <-3.28, 263.5936, 96.824>, <-3.07513, 264.1883, 94.3565> }
					triangle { <-3.3654, 263.9634, 95.9551>, <-3.6769, 263.959, 96.9425>, <-3.28, 263.5936, 96.824> }
					triangle { <-3.284, 264.6093, 93.7162>, <-3.6769, 263.959, 96.9425>, <-3.3654, 263.9634, 95.9551> }
					triangle { <1.5558, 266.4296, 98.9175>, <0.8061, 265.1227, 97.7231>, <-3.28, 263.5936, 96.824> }
					triangle { <0.3419, 267.8498, 98.9626>, <0.8142, 268.3557, 99.402>, <1.5558, 266.4296, 98.9175> }
					triangle { <1.5558, 266.4296, 98.9175>, <-3.28, 263.5936, 96.824>, <0.3419, 267.8498, 98.9626> }
					triangle { <-3.6769, 263.959, 96.9425>, <0.3419, 267.8498, 98.9626>, <-3.28, 263.5936, 96.824> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.284, 264.6093, 93.7162>, <-3.7207, 264.2919, 94.2987>, <-3.7959, 264.0325, 95.9166> }
					triangle { <-3.7207, 264.2919, 94.2987>, <-4.1409, 263.7318, 96.7469>, <-3.7959, 264.0325, 95.9166> }
					triangle { <-4.1409, 263.7318, 96.7469>, <-3.6769, 263.959, 96.9425>, <-3.7959, 264.0325, 95.9166> }
					triangle { <-3.7959, 264.0325, 95.9166>, <-3.6769, 263.959, 96.9425>, <-3.284, 264.6093, 93.7162> }
					triangle { <-4.1409, 263.7318, 96.7469>, <-7.7201, 266.4377, 96.9496>, <-8.1425, 267.9862, 98.04999> }
					triangle { <-8.1425, 267.9862, 98.04999>, <-7.01433, 269.5587, 98.6909>, <-6.5747, 268.9599, 98.3438> }
					triangle { <-6.5747, 268.9599, 98.3438>, <-4.1409, 263.7318, 96.7469>, <-8.1425, 267.9862, 98.04999> }
					triangle { <-4.1409, 263.7318, 96.7469>, <-6.5747, 268.9599, 98.3438>, <-3.6769, 263.959, 96.9425> }
					triangle { <-3.3212, 264.2775, 96.02386>, <-3.00873, 264.6595, 94.4595>, <-3.284, 264.6093, 93.7162> }
					triangle { <-3.3212, 264.2775, 96.02386>, <-3.1915, 264.2219, 96.9614>, <-3.00873, 264.6595, 94.4595> }
					triangle { <-3.3212, 264.2775, 96.02386>, <-3.6769, 263.959, 96.9425>, <-3.1915, 264.2219, 96.9614> }
					triangle { <-3.284, 264.6093, 93.7162>, <-3.6769, 263.959, 96.9425>, <-3.3212, 264.2775, 96.02386> }
					triangle { <-4.8987, 269.6606, 98.7825>, <-3.606, 268.5612, 97.8787>, <-3.1915, 264.2219, 96.9614> }
					triangle { <-6.5747, 268.9599, 98.3438>, <-7.01433, 269.5587, 98.6909>, <-4.8987, 269.6606, 98.7825> }
					triangle { <-4.8987, 269.6606, 98.7825>, <-3.1915, 264.2219, 96.9614>, <-6.5747, 268.9599, 98.3438> }
					triangle { <-3.6769, 263.959, 96.9425>, <-6.5747, 268.9599, 98.3438>, <-3.1915, 264.2219, 96.9614> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-5.8511, 244.6944, 42.7362>, <-5.9553, 246.9927, 43.2356>, 0.2999 }
			cylinder { <-5.9553, 246.9927, 43.2356>, <-6.04209, 249.2735, 43.8129>, 0.2999 }
			cylinder { <-6.04209, 249.2735, 43.8129>, <-6.1112, 251.5339, 44.4673>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-6.1112, 251.5339, 44.4673>, <-5.1916, 253.4421, 43.44>, 0.2999 }
			cylinder { <-5.1916, 253.4421, 43.44>, <-4.2457, 255.303, 42.3516>, 0.2999 }
			cylinder { <-4.2457, 255.303, 42.3516>, <-3.2746, 257.1143, 41.2033>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.2746, 257.1143, 41.2033>, <-1.8572, 263.3228, 38.1488>, 0.2999 }
				cylinder { <-1.8572, 263.3228, 38.1488>, <-2.02064, 269.9335, 35.668>, 0.2999 }
				cylinder { <-2.02064, 269.9335, 35.668>, <-3.755, 276.5503, 33.9095>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-3.755, 276.5503, 33.9095>, <-4.1824, 277.224, 34.1326>, <-4.5563, 278.837, 33.7023> }
					triangle { <-4.1824, 277.224, 34.1326>, <-4.9671, 279.7343, 33.7641>, <-4.5563, 278.837, 33.7023> }
					triangle { <-4.9671, 279.7343, 33.7641>, <-4.6744, 279.8221, 33.2757>, <-4.5563, 278.837, 33.7023> }
					triangle { <-4.5563, 278.837, 33.7023>, <-4.6744, 279.8221, 33.2757>, <-3.755, 276.5503, 33.9095> }
					triangle { <-4.9671, 279.7343, 33.7641>, <-9.4245, 278.4539, 33.1033>, <-10.7089, 278.6927, 31.5498> }
					triangle { <-10.7089, 278.6927, 31.5498>, <-10.443, 278.5598, 29.4444>, <-9.709, 278.5507, 29.8827> }
					triangle { <-9.709, 278.5507, 29.8827>, <-4.9671, 279.7343, 33.7641>, <-10.7089, 278.6927, 31.5498> }
					triangle { <-4.9671, 279.7343, 33.7641>, <-9.709, 278.5507, 29.8827>, <-4.6744, 279.8221, 33.2757> }
					triangle { <-4.2383, 278.8351, 33.2312>, <-3.7055, 277.2211, 33.426>, <-3.755, 276.5503, 33.9095> }
					triangle { <-4.2383, 278.8351, 33.2312>, <-4.3313, 279.7305, 32.8221>, <-3.7055, 277.2211, 33.426> }
					triangle { <-4.2383, 278.8351, 33.2312>, <-4.6744, 279.8221, 33.2757>, <-4.3313, 279.7305, 32.8221> }
					triangle { <-3.755, 276.5503, 33.9095>, <-4.6744, 279.8221, 33.2757>, <-4.2383, 278.8351, 33.2312> }
					triangle { <-8.5364, 278.6797, 28.3311>, <-6.6692, 278.4373, 29.02107>, <-4.3313, 279.7305, 32.8221> }
					triangle { <-9.709, 278.5507, 29.8827>, <-10.443, 278.5598, 29.4444>, <-8.5364, 278.6797, 28.3311> }
					triangle { <-8.5364, 278.6797, 28.3311>, <-4.3313, 279.7305, 32.8221>, <-9.709, 278.5507, 29.8827> }
					triangle { <-4.6744, 279.8221, 33.2757>, <-9.709, 278.5507, 29.8827>, <-4.3313, 279.7305, 32.8221> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.755, 276.5503, 33.9095>, <-3.701, 277.3537, 34.104>, <-4.2354, 278.9235, 33.6832> }
					triangle { <-3.701, 277.3537, 34.104>, <-4.3253, 279.9073, 33.7261>, <-4.2354, 278.9235, 33.6832> }
					triangle { <-4.3253, 279.9073, 33.7261>, <-4.6744, 279.8221, 33.2757>, <-4.2354, 278.9235, 33.6832> }
					triangle { <-4.2354, 278.9235, 33.6832>, <-4.6744, 279.8221, 33.2757>, <-3.755, 276.5503, 33.9095> }
					triangle { <-4.3253, 279.9073, 33.7261>, <-6.5576, 280.1762, 37.8358>, <-8.4704, 280.6362, 38.335> }
					triangle { <-8.4704, 280.6362, 38.335>, <-10.3368, 280.1396, 37.4455>, <-9.6623, 279.9351, 36.9613> }
					triangle { <-9.6623, 279.9351, 36.9613>, <-4.3253, 279.9073, 33.7261>, <-8.4704, 280.6362, 38.335> }
					triangle { <-4.3253, 279.9073, 33.7261>, <-9.6623, 279.9351, 36.9613>, <-4.6744, 279.8221, 33.2757> }
					triangle { <-4.5592, 278.7486, 33.2503>, <-4.1868, 277.0914, 33.4546>, <-3.755, 276.5503, 33.9095> }
					triangle { <-4.5592, 278.7486, 33.2503>, <-4.9731, 279.5575, 32.8601>, <-4.1868, 277.0914, 33.4546> }
					triangle { <-4.5592, 278.7486, 33.2503>, <-4.6744, 279.8221, 33.2757>, <-4.9731, 279.5575, 32.8601> }
					triangle { <-3.755, 276.5503, 33.9095>, <-4.6744, 279.8221, 33.2757>, <-4.5592, 278.7486, 33.2503> }
					triangle { <-10.6836, 279.4411, 35.3764>, <-9.3646, 278.6606, 34.0834>, <-4.9731, 279.5575, 32.8601> }
					triangle { <-9.6623, 279.9351, 36.9613>, <-10.3368, 280.1396, 37.4455>, <-10.6836, 279.4411, 35.3764> }
					triangle { <-10.6836, 279.4411, 35.3764>, <-4.9731, 279.5575, 32.8601>, <-9.6623, 279.9351, 36.9613> }
					triangle { <-4.6744, 279.8221, 33.2757>, <-9.6623, 279.9351, 36.9613>, <-4.9731, 279.5575, 32.8601> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.755, 276.5503, 33.9095>, <-3.5531, 277.3034, 33.6297>, <-4.1367, 278.89, 33.367> }
					triangle { <-3.5531, 277.3034, 33.6297>, <-4.1281, 279.8402, 33.09374>, <-4.1367, 278.89, 33.367> }
					triangle { <-4.1281, 279.8402, 33.09374>, <-4.6744, 279.8221, 33.2757>, <-4.1367, 278.89, 33.367> }
					triangle { <-4.1367, 278.89, 33.367>, <-4.6744, 279.8221, 33.2757>, <-3.755, 276.5503, 33.9095> }
					triangle { <-4.1281, 279.8402, 33.09374>, <-1.1056, 281.4124, 36.309>, <-1.3325, 282.5695, 37.9612> }
					triangle { <-1.3325, 282.5695, 37.9612>, <-2.8384, 282.637, 39.4609>, <-3.04566, 282.1486, 38.7903> }
					triangle { <-3.04566, 282.1486, 38.7903>, <-4.1281, 279.8402, 33.09374>, <-1.3325, 282.5695, 37.9612> }
					triangle { <-4.1281, 279.8402, 33.09374>, <-3.04566, 282.1486, 38.7903>, <-4.6744, 279.8221, 33.2757> }
					triangle { <-4.6579, 278.7821, 33.5664>, <-4.3348, 277.1417, 33.9288>, <-3.755, 276.5503, 33.9095> }
					triangle { <-4.6579, 278.7821, 33.5664>, <-5.1703, 279.6246, 33.4925>, <-4.3348, 277.1417, 33.9288> }
					triangle { <-4.6579, 278.7821, 33.5664>, <-4.6744, 279.8221, 33.2757>, <-5.1703, 279.6246, 33.4925> }
					triangle { <-3.755, 276.5503, 33.9095>, <-4.6744, 279.8221, 33.2757>, <-4.6579, 278.7821, 33.5664> }
					triangle { <-4.8935, 281.8328, 39.3237>, <-5.622, 280.4781, 38.03716>, <-5.1703, 279.6246, 33.4925> }
					triangle { <-3.04566, 282.1486, 38.7903>, <-2.8384, 282.637, 39.4609>, <-4.8935, 281.8328, 39.3237> }
					triangle { <-4.8935, 281.8328, 39.3237>, <-5.1703, 279.6246, 33.4925>, <-3.04566, 282.1486, 38.7903> }
					triangle { <-4.6744, 279.8221, 33.2757>, <-3.04566, 282.1486, 38.7903>, <-5.1703, 279.6246, 33.4925> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.755, 276.5503, 33.9095>, <-3.9416, 277.1422, 33.3607>, <-4.3958, 278.7824, 33.1877> }
					triangle { <-3.9416, 277.1422, 33.3607>, <-4.6461, 279.6252, 32.735>, <-4.3958, 278.7824, 33.1877> }
					triangle { <-4.6461, 279.6252, 32.735>, <-4.6744, 279.8221, 33.2757>, <-4.3958, 278.7824, 33.1877> }
					triangle { <-4.3958, 278.7824, 33.1877>, <-4.6744, 279.8221, 33.2757>, <-3.755, 276.5503, 33.9095> }
					triangle { <-4.6461, 279.6252, 32.735>, <-0.5523, 280.4656, 30.6186>, <0.907, 281.8389, 30.9414> }
					triangle { <0.907, 281.8389, 30.9414>, <1.7594, 282.624, 32.7241>, <1.05873, 282.153, 32.8591> }
					triangle { <1.05873, 282.153, 32.8591>, <-4.6461, 279.6252, 32.735>, <0.907, 281.8389, 30.9414> }
					triangle { <-4.6461, 279.6252, 32.735>, <1.05873, 282.153, 32.8591>, <-4.6744, 279.8221, 33.2757> }
					triangle { <-4.3988, 278.8897, 33.7458>, <-3.9462, 277.303, 34.1978>, <-3.755, 276.5503, 33.9095> }
					triangle { <-4.3988, 278.8897, 33.7458>, <-4.6522, 279.8397, 33.8512>, <-3.9462, 277.303, 34.1978> }
					triangle { <-4.3988, 278.8897, 33.7458>, <-4.6744, 279.8221, 33.2757>, <-4.6522, 279.8397, 33.8512> }
					triangle { <-3.755, 276.5503, 33.9095>, <-4.6744, 279.8221, 33.2757>, <-4.3988, 278.8897, 33.7458> }
					triangle { <0.8861, 282.5718, 34.7548>, <-0.5787, 281.3951, 35.4552>, <-4.6522, 279.8397, 33.8512> }
					triangle { <1.05873, 282.153, 32.8591>, <1.7594, 282.624, 32.7241>, <0.8861, 282.5718, 34.7548> }
					triangle { <0.8861, 282.5718, 34.7548>, <-4.6522, 279.8397, 33.8512>, <1.05873, 282.153, 32.8591> }
					triangle { <-4.6744, 279.8221, 33.2757>, <1.05873, 282.153, 32.8591>, <-4.6522, 279.8397, 33.8512> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-3.755, 276.5503, 33.9095>, <-4.3364, 277.0923, 33.6762>, <-4.659, 278.7492, 33.398> }
					triangle { <-4.3364, 277.0923, 33.6762>, <-5.1725, 279.5587, 33.1556>, <-4.659, 278.7492, 33.398> }
					triangle { <-5.1725, 279.5587, 33.1556>, <-4.6744, 279.8221, 33.2757>, <-4.659, 278.7492, 33.398> }
					triangle { <-4.659, 278.7492, 33.398>, <-4.6744, 279.8221, 33.2757>, <-3.755, 276.5503, 33.9095> }
					triangle { <-5.1725, 279.5587, 33.1556>, <-5.7713, 278.6095, 28.6075>, <-4.9753, 279.4068, 26.9191> }
					triangle { <-4.9753, 279.4068, 26.9191>, <-3.01137, 280.0661, 26.4402>, <-3.1216, 279.8958, 27.2708> }
					triangle { <-3.1216, 279.8958, 27.2708>, <-5.1725, 279.5587, 33.1556>, <-4.9753, 279.4068, 26.9191> }
					triangle { <-5.1725, 279.5587, 33.1556>, <-3.1216, 279.8958, 27.2708>, <-4.6744, 279.8221, 33.2757> }
					triangle { <-4.1356, 278.9229, 33.5355>, <-3.5514, 277.3528, 33.8824>, <-3.755, 276.5503, 33.9095> }
					triangle { <-4.1356, 278.9229, 33.5355>, <-4.1258, 279.9061, 33.4306>, <-3.5514, 277.3528, 33.8824> }
					triangle { <-4.1356, 278.9229, 33.5355>, <-4.6744, 279.8221, 33.2757>, <-4.1258, 279.9061, 33.4306> }
					triangle { <-3.755, 276.5503, 33.9095>, <-4.6744, 279.8221, 33.2757>, <-4.1356, 278.9229, 33.5355> }
					triangle { <-1.3991, 280.5937, 27.8585>, <-1.2356, 280.1148, 29.7989>, <-4.1258, 279.9061, 33.4306> }
					triangle { <-3.1216, 279.8958, 27.2708>, <-3.01137, 280.0661, 26.4402>, <-1.3991, 280.5937, 27.8585> }
					triangle { <-1.3991, 280.5937, 27.8585>, <-4.1258, 279.9061, 33.4306>, <-3.1216, 279.8958, 27.2708> }
					triangle { <-4.6744, 279.8221, 33.2757>, <-3.1216, 279.8958, 27.2708>, <-4.1258, 279.9061, 33.4306> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-3.2746, 257.1143, 41.2033>, <-2.3695, 258.9705, 40.07275>, 0.2999 }
			cylinder { <-2.3695, 258.9705, 40.07275>, <-1.5315, 260.8691, 38.9613>, 0.2999 }
			cylinder { <-1.5315, 260.8691, 38.9613>, <-0.7615, 262.8081, 37.8703>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.7615, 262.8081, 37.8703>, <3.02443, 268.2395, 35.4109>, 0.2999 }
				cylinder { <3.02443, 268.2395, 35.4109>, <8.05977, 272.96, 33.9127>, 0.2999 }
				cylinder { <8.05977, 272.96, 33.9127>, <14.04263, 276.6867, 33.4652>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <14.04263, 276.6867, 33.4652>, <14.8642, 276.7715, 33.5289>, <16.1605, 277.8796, 33.3938> }
					triangle { <14.8642, 276.7715, 33.5289>, <17.09131, 278.2134, 33.4084>, <16.1605, 277.8796, 33.3938> }
					triangle { <17.09131, 278.2134, 33.4084>, <16.8384, 278.71, 33.2624>, <16.1605, 277.8796, 33.3938> }
					triangle { <16.1605, 277.8796, 33.3938>, <16.8384, 278.71, 33.2624>, <14.04263, 276.6867, 33.4652> }
					triangle { <17.09131, 278.2134, 33.4084>, <17.8711, 277.7586, 38.0052>, <18.05728, 279.1087, 39.5093> }
					triangle { <18.05728, 279.1087, 39.5093>, <17.01829, 280.9118, 39.9459>, <16.8408, 280.5939, 39.1722> }
					triangle { <16.8408, 280.5939, 39.1722>, <17.09131, 278.2134, 33.4084>, <18.05728, 279.1087, 39.5093> }
					triangle { <17.09131, 278.2134, 33.4084>, <16.8408, 280.5939, 39.1722>, <16.8384, 278.71, 33.2624> }
					triangle { <15.8311, 278.3208, 33.2532>, <14.37, 277.4333, 33.3182>, <14.04263, 276.6867, 33.4652> }
					triangle { <15.8311, 278.3208, 33.2532>, <16.4323, 279.0958, 33.1274>, <14.37, 277.4333, 33.3182> }
					triangle { <15.8311, 278.3208, 33.2532>, <16.8384, 278.71, 33.2624>, <16.4323, 279.0958, 33.1274> }
					triangle { <14.04263, 276.6867, 33.4652>, <16.8384, 278.71, 33.2624>, <15.8311, 278.3208, 33.2532> }
					triangle { <15.8057, 282.1235, 38.5492>, <15.01556, 281.5823, 36.7875>, <16.4323, 279.0958, 33.1274> }
					triangle { <16.8408, 280.5939, 39.1722>, <17.01829, 280.9118, 39.9459>, <15.8057, 282.1235, 38.5492> }
					triangle { <15.8057, 282.1235, 38.5492>, <16.4323, 279.0958, 33.1274>, <16.8408, 280.5939, 39.1722> }
					triangle { <16.8384, 278.71, 33.2624>, <16.8408, 280.5939, 39.1722>, <16.4323, 279.0958, 33.1274> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <14.04263, 276.6867, 33.4652>, <14.7347, 276.9039, 33.06524>, <16.07428, 277.9679, 33.08463> }
					triangle { <14.7347, 276.9039, 33.06524>, <16.9186, 278.3899, 32.7901>, <16.07428, 277.9679, 33.08463> }
					triangle { <16.9186, 278.3899, 32.7901>, <16.8384, 278.71, 33.2624>, <16.07428, 277.9679, 33.08463> }
					triangle { <16.07428, 277.9679, 33.08463>, <16.8384, 278.71, 33.2624>, <14.04263, 276.6867, 33.4652> }
					triangle { <16.9186, 278.3899, 32.7901>, <19.745, 274.7121, 33.4456>, <21.1877, 274.3125, 34.8164> }
					triangle { <21.1877, 274.3125, 34.8164>, <21.31, 274.6768, 36.9077>, <20.649, 275.067, 36.5309> }
					triangle { <20.649, 275.067, 36.5309>, <16.9186, 278.3899, 32.7901>, <21.1877, 274.3125, 34.8164> }
					triangle { <16.9186, 278.3899, 32.7901>, <20.649, 275.067, 36.5309>, <16.8384, 278.71, 33.2624> }
					triangle { <15.9174, 278.2325, 33.5624>, <14.4994, 277.3009, 33.7819>, <14.04263, 276.6867, 33.4652> }
					triangle { <15.9174, 278.2325, 33.5624>, <16.6049, 278.9192, 33.7457>, <14.4994, 277.3009, 33.7819> }
					triangle { <15.9174, 278.2325, 33.5624>, <16.8384, 278.71, 33.2624>, <16.6049, 278.9192, 33.7457> }
					triangle { <14.04263, 276.6867, 33.4652>, <16.8384, 278.71, 33.2624>, <15.9174, 278.2325, 33.5624> }
					triangle { <20.1159, 276.1209, 38.08152>, <18.3856, 277.0056, 37.5867>, <16.6049, 278.9192, 33.7457> }
					triangle { <20.649, 275.067, 36.5309>, <21.31, 274.6768, 36.9077>, <20.1159, 276.1209, 38.08152> }
					triangle { <20.1159, 276.1209, 38.08152>, <16.6049, 278.9192, 33.7457>, <20.649, 275.067, 36.5309> }
					triangle { <16.8384, 278.71, 33.2624>, <20.649, 275.067, 36.5309>, <16.6049, 278.9192, 33.7457> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <14.04263, 276.6867, 33.4652>, <14.4438, 277.3088, 33.0934>, <15.8803, 278.2378, 33.1034> }
					triangle { <14.4438, 277.3088, 33.0934>, <16.5307, 278.9297, 32.8276>, <15.8803, 278.2378, 33.1034> }
					triangle { <16.5307, 278.9297, 32.8276>, <16.8384, 278.71, 33.2624>, <15.8803, 278.2378, 33.1034> }
					triangle { <15.8803, 278.2378, 33.1034>, <16.8384, 278.71, 33.2624>, <14.04263, 276.6867, 33.4652> }
					triangle { <16.5307, 278.9297, 32.8276>, <17.6292, 277.1532, 28.6345>, <19.2944, 276.2373, 27.9217> }
					triangle { <19.2944, 276.2373, 27.9217>, <20.6204, 274.8149, 28.7818>, <20.06773, 275.1493, 29.342> }
					triangle { <20.06773, 275.1493, 29.342>, <16.5307, 278.9297, 32.8276>, <19.2944, 276.2373, 27.9217> }
					triangle { <16.5307, 278.9297, 32.8276>, <20.06773, 275.1493, 29.342>, <16.8384, 278.71, 33.2624> }
					triangle { <16.1113, 277.9626, 33.5436>, <14.7904, 276.8961, 33.7538>, <14.04263, 276.6867, 33.4652> }
					triangle { <16.1113, 277.9626, 33.5436>, <16.9929, 278.3794, 33.7082>, <14.7904, 276.8961, 33.7538> }
					triangle { <16.1113, 277.9626, 33.5436>, <16.8384, 278.71, 33.2624>, <16.9929, 278.3794, 33.7082> }
					triangle { <14.04263, 276.6867, 33.4652>, <16.8384, 278.71, 33.2624>, <16.1113, 277.9626, 33.5436> }
					triangle { <20.8734, 274.357, 30.9302>, <19.6319, 274.7685, 32.4502>, <16.9929, 278.3794, 33.7082> }
					triangle { <20.06773, 275.1493, 29.342>, <20.6204, 274.8149, 28.7818>, <20.8734, 274.357, 30.9302> }
					triangle { <20.8734, 274.357, 30.9302>, <16.9929, 278.3794, 33.7082>, <20.06773, 275.1493, 29.342> }
					triangle { <16.8384, 278.71, 33.2624>, <20.06773, 275.1493, 29.342>, <16.9929, 278.3794, 33.7082> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <14.04263, 276.6867, 33.4652>, <14.3907, 277.4304, 33.5748>, <15.8449, 278.3189, 33.4243> }
					triangle { <14.3907, 277.4304, 33.5748>, <16.46, 279.0918, 33.4695>, <15.8449, 278.3189, 33.4243> }
					triangle { <16.46, 279.0918, 33.4695>, <16.8384, 278.71, 33.2624>, <15.8449, 278.3189, 33.4243> }
					triangle { <15.8449, 278.3189, 33.4243>, <16.8384, 278.71, 33.2624>, <14.04263, 276.6867, 33.4652> }
					triangle { <16.46, 279.0918, 33.4695>, <14.4279, 281.7313, 30.1757>, <14.9761, 282.241, 28.2891> }
					triangle { <14.9761, 282.241, 28.2891>, <15.896, 281.1365, 26.7221>, <15.8948, 280.7279, 27.4732> }
					triangle { <15.8948, 280.7279, 27.4732>, <16.46, 279.0918, 33.4695>, <14.9761, 282.241, 28.2891> }
					triangle { <16.46, 279.0918, 33.4695>, <15.8948, 280.7279, 27.4732>, <16.8384, 278.71, 33.2624> }
					triangle { <16.1467, 277.8816, 33.2227>, <14.8434, 276.7745, 33.2723>, <14.04263, 276.6867, 33.4652> }
					triangle { <16.1467, 277.8816, 33.2227>, <17.06364, 278.2173, 33.06635>, <14.8434, 276.7745, 33.2723> }
					triangle { <16.1467, 277.8816, 33.2227>, <16.8384, 278.71, 33.2624>, <17.06364, 278.2173, 33.06635> }
					triangle { <14.04263, 276.6867, 33.4652>, <16.8384, 278.71, 33.2624>, <16.1467, 277.8816, 33.2227> }
					triangle { <17.03862, 279.253, 26.9114>, <17.04372, 277.9416, 28.4285>, <17.06364, 278.2173, 33.06635> }
					triangle { <15.8948, 280.7279, 27.4732>, <15.896, 281.1365, 26.7221>, <17.03862, 279.253, 26.9114> }
					triangle { <17.03862, 279.253, 26.9114>, <17.06364, 278.2173, 33.06635>, <15.8948, 280.7279, 27.4732> }
					triangle { <16.8384, 278.71, 33.2624>, <15.8948, 280.7279, 27.4732>, <17.06364, 278.2173, 33.06635> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <14.04263, 276.6867, 33.4652>, <14.6545, 277.0933, 33.848>, <16.02078, 278.0941, 33.6065> }
					triangle { <14.6545, 277.0933, 33.848>, <16.8116, 278.6424, 33.8339>, <16.02078, 278.0941, 33.6065> }
					triangle { <16.8116, 278.6424, 33.8339>, <16.8384, 278.71, 33.2624>, <16.02078, 278.0941, 33.6065> }
					triangle { <16.02078, 278.0941, 33.6065>, <16.8384, 278.71, 33.2624>, <14.04263, 276.6867, 33.4652> }
					triangle { <16.8116, 278.6424, 33.8339>, <14.5796, 282.1111, 36.05457>, <14.2, 284.0424, 35.5588> }
					triangle { <14.2, 284.0424, 35.5588>, <13.6361, 284.9615, 33.7261>, <13.8704, 284.1436, 33.6404> }
					triangle { <13.8704, 284.1436, 33.6404>, <16.8116, 278.6424, 33.8339>, <14.2, 284.0424, 35.5588> }
					triangle { <16.8116, 278.6424, 33.8339>, <13.8704, 284.1436, 33.6404>, <16.8384, 278.71, 33.2624> }
					triangle { <15.9709, 278.1063, 33.04056>, <14.5797, 277.1115, 32.9991>, <14.04263, 276.6867, 33.4652> }
					triangle { <15.9709, 278.1063, 33.04056>, <16.7119, 278.6667, 32.7019>, <14.5797, 277.1115, 32.9991> }
					triangle { <15.9709, 278.1063, 33.04056>, <16.8384, 278.71, 33.2624>, <16.7119, 278.6667, 32.7019> }
					triangle { <14.04263, 276.6867, 33.4652>, <16.8384, 278.71, 33.2624>, <15.9709, 278.1063, 33.04056> }
					triangle { <13.8593, 284.1254, 31.6913>, <14.1475, 282.2163, 31.1495>, <16.7119, 278.6667, 32.7019> }
					triangle { <13.8704, 284.1436, 33.6404>, <13.6361, 284.9615, 33.7261>, <13.8593, 284.1254, 31.6913> }
					triangle { <13.8593, 284.1254, 31.6913>, <16.7119, 278.6667, 32.7019>, <13.8704, 284.1436, 33.6404> }
					triangle { <16.8384, 278.71, 33.2624>, <13.8704, 284.1436, 33.6404>, <16.7119, 278.6667, 32.7019> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-0.7615, 262.8081, 37.8703>, <0.0825, 264.7336, 36.8108>, 0.2999 }
			cylinder { <0.0825, 264.7336, 36.8108>, <0.9997, 266.6434, 35.7843>, 0.2999 }
			cylinder { <0.9997, 266.6434, 35.7843>, <1.9889, 268.5352, 34.7918>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.9889, 268.5352, 34.7918>, <4.1013, 273.6608, 30.4158>, 0.2999 }
				cylinder { <4.1013, 273.6608, 30.4158>, <5.2315, 277.9295, 24.9037>, 0.2999 }
				cylinder { <5.2315, 277.9295, 24.9037>, <5.3119, 281.0854, 18.5857>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <5.3119, 281.0854, 18.5857>, <4.9352, 281.2408, 17.8644>, <5.08293, 282.0566, 16.368> }
					triangle { <4.9352, 281.2408, 17.8644>, <4.8371, 282.3718, 15.4635>, <5.08293, 282.0566, 16.368> }
					triangle { <4.8371, 282.3718, 15.4635>, <5.3513, 282.6301, 15.4932>, <5.08293, 282.0566, 16.368> }
					triangle { <5.08293, 282.0566, 16.368>, <5.3513, 282.6301, 15.4932>, <5.3119, 281.0854, 18.5857> }
					triangle { <4.8371, 282.3718, 15.4635>, <4.9174, 278.2244, 13.287>, <6.1934, 277.4021, 11.9396> }
					triangle { <6.1934, 277.4021, 11.9396>, <8.3129, 277.4394, 11.7734>, <8.00641, 277.9825, 12.3584> }
					triangle { <8.00641, 277.9825, 12.3584>, <4.8371, 282.3718, 15.4635>, <6.1934, 277.4021, 11.9396> }
					triangle { <4.8371, 282.3718, 15.4635>, <8.00641, 277.9825, 12.3584>, <5.3513, 282.6301, 15.4932> }
					triangle { <5.5959, 282.2725, 16.4824>, <5.7048, 281.5647, 18.03608>, <5.3119, 281.0854, 18.5857> }
					triangle { <5.5959, 282.2725, 16.4824>, <5.8633, 282.8037, 15.6923>, <5.7048, 281.5647, 18.03608> }
					triangle { <5.5959, 282.2725, 16.4824>, <5.3513, 282.6301, 15.4932>, <5.8633, 282.8037, 15.6923> }
					triangle { <5.3119, 281.0854, 18.5857>, <5.3513, 282.6301, 15.4932>, <5.5959, 282.2725, 16.4824> }
					triangle { <9.6993, 278.8777, 12.7213>, <9.3639, 280.0959, 14.2784>, <5.8633, 282.8037, 15.6923> }
					triangle { <8.00641, 277.9825, 12.3584>, <8.3129, 277.4394, 11.7734>, <9.6993, 278.8777, 12.7213> }
					triangle { <9.6993, 278.8777, 12.7213>, <5.8633, 282.8037, 15.6923>, <8.00641, 277.9825, 12.3584> }
					triangle { <5.3513, 282.6301, 15.4932>, <8.00641, 277.9825, 12.3584>, <5.8633, 282.8037, 15.6923> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <5.3119, 281.0854, 18.5857>, <5.02538, 281.6797, 18.08488>, <5.143, 282.3492, 16.5149> }
					triangle { <5.02538, 281.6797, 18.08488>, <4.9573, 282.9571, 15.7574>, <5.143, 282.3492, 16.5149> }
					triangle { <4.9573, 282.9571, 15.7574>, <5.3513, 282.6301, 15.4932>, <5.143, 282.3492, 16.5149> }
					triangle { <5.143, 282.3492, 16.5149>, <5.3513, 282.6301, 15.4932>, <5.3119, 281.0854, 18.5857> }
					triangle { <4.9573, 282.9571, 15.7574>, <0.537, 281.6405, 14.9376>, <-0.3262, 280.5747, 13.4413> }
					triangle { <-0.3262, 280.5747, 13.4413>, <0.3013, 278.846, 12.374>, <0.9124, 279.1833, 12.8679> }
					triangle { <0.9124, 279.1833, 12.8679>, <4.9573, 282.9571, 15.7574>, <-0.3262, 280.5747, 13.4413> }
					triangle { <4.9573, 282.9571, 15.7574>, <0.9124, 279.1833, 12.8679>, <5.3513, 282.6301, 15.4932> }
					triangle { <5.5359, 281.9799, 16.3354>, <5.6147, 281.1258, 17.8156>, <5.3119, 281.0854, 18.5857> }
					triangle { <5.5359, 281.9799, 16.3354>, <5.7431, 282.2185, 15.3984>, <5.6147, 281.1258, 17.8156> }
					triangle { <5.5359, 281.9799, 16.3354>, <5.3513, 282.6301, 15.4932>, <5.7431, 282.2185, 15.3984> }
					triangle { <5.3119, 281.0854, 18.5857>, <5.3513, 282.6301, 15.4932>, <5.5359, 281.9799, 16.3354> }
					triangle { <2.3585, 278.0512, 12.215>, <3.9421, 278.4399, 13.3822>, <5.7431, 282.2185, 15.3984> }
					triangle { <0.9124, 279.1833, 12.8679>, <0.3013, 278.846, 12.374>, <2.3585, 278.0512, 12.215> }
					triangle { <2.3585, 278.0512, 12.215>, <5.7431, 282.2185, 15.3984>, <0.9124, 279.1833, 12.8679> }
					triangle { <5.3513, 282.6301, 15.4932>, <0.9124, 279.1833, 12.8679>, <5.7431, 282.2185, 15.3984> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <5.3119, 281.0854, 18.5857>, <5.5199, 281.7385, 18.1205>, <5.4727, 282.3884, 16.5386> }
					triangle { <5.5199, 281.7385, 18.1205>, <5.6168, 283.0354, 15.8049>, <5.4727, 282.3884, 16.5386> }
					triangle { <5.6168, 283.0354, 15.8049>, <5.3513, 282.6301, 15.4932>, <5.4727, 282.3884, 16.5386> }
					triangle { <5.4727, 282.3884, 16.5386>, <5.3513, 282.6301, 15.4932>, <5.3119, 281.0854, 18.5857> }
					triangle { <5.6168, 283.0354, 15.8049>, <2.7648, 286.4149, 17.3508>, <0.9606, 287.0914, 16.7128> }
					triangle { <0.9606, 287.0914, 16.7128>, <-0.7621, 286.0857, 15.9768>, <-0.07668, 285.58, 16.05056> }
					triangle { <-0.07668, 285.58, 16.05056>, <5.6168, 283.0354, 15.8049>, <0.9606, 287.0914, 16.7128> }
					triangle { <5.6168, 283.0354, 15.8049>, <-0.07668, 285.58, 16.05056>, <5.3513, 282.6301, 15.4932> }
					triangle { <5.2061, 281.9407, 16.3117>, <5.1201, 281.067, 17.78>, <5.3119, 281.0854, 18.5857> }
					triangle { <5.2061, 281.9407, 16.3117>, <5.08367, 282.1401, 15.3509>, <5.1201, 281.067, 17.78> }
					triangle { <5.2061, 281.9407, 16.3117>, <5.3513, 282.6301, 15.4932>, <5.08367, 282.1401, 15.3509> }
					triangle { <5.3119, 281.0854, 18.5857>, <5.3513, 282.6301, 15.4932>, <5.2061, 281.9407, 16.3117> }
					triangle { <-0.8609, 284.0327, 15.1618>, <0.4545, 282.5355, 15.3836>, <5.08367, 282.1401, 15.3509> }
					triangle { <-0.07668, 285.58, 16.05056>, <-0.7621, 286.0857, 15.9768>, <-0.8609, 284.0327, 15.1618> }
					triangle { <-0.8609, 284.0327, 15.1618>, <5.08367, 282.1401, 15.3509>, <-0.07668, 285.58, 16.05056> }
					triangle { <5.3513, 282.6301, 15.4932>, <-0.07668, 285.58, 16.05056>, <5.08367, 282.1401, 15.3509> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <5.3119, 281.0854, 18.5857>, <5.7401, 281.3364, 17.9224>, <5.6195, 282.1203, 16.4066> }
					triangle { <5.7401, 281.3364, 17.9224>, <5.9103, 282.4993, 15.5408>, <5.6195, 282.1203, 16.4066> }
					triangle { <5.9103, 282.4993, 15.5408>, <5.3513, 282.6301, 15.4932>, <5.6195, 282.1203, 16.4066> }
					triangle { <5.6195, 282.1203, 16.4066>, <5.3513, 282.6301, 15.4932>, <5.3119, 281.0854, 18.5857> }
					triangle { <5.9103, 282.4993, 15.5408>, <8.5429, 285.9942, 17.2142>, <8.2876, 288.0072, 17.2635> }
					triangle { <8.2876, 288.0072, 17.2635>, <6.5821, 289.2211, 17.6364>, <6.3966, 288.3923, 17.5377> }
					triangle { <6.3966, 288.3923, 17.5377>, <5.9103, 282.4993, 15.5408>, <8.2876, 288.0072, 17.2635> }
					triangle { <5.9103, 282.4993, 15.5408>, <6.3966, 288.3923, 17.5377>, <5.3513, 282.6301, 15.4932> }
					triangle { <5.05939, 282.2088, 16.4437>, <4.8999, 281.4691, 17.978>, <5.3119, 281.0854, 18.5857> }
					triangle { <5.05939, 282.2088, 16.4437>, <4.7901, 282.6762, 15.615>, <4.8999, 281.4691, 17.978> }
					triangle { <5.05939, 282.2088, 16.4437>, <5.3513, 282.6301, 15.4932>, <4.7901, 282.6762, 15.615> }
					triangle { <5.3119, 281.0854, 18.5857>, <5.3513, 282.6301, 15.4932>, <5.05939, 282.2088, 16.4437> }
					triangle { <4.46, 288.6117, 17.5167>, <3.6884, 286.7609, 17.5354>, <4.7901, 282.6762, 15.615> }
					triangle { <6.3966, 288.3923, 17.5377>, <6.5821, 289.2211, 17.6364>, <4.46, 288.6117, 17.5167> }
					triangle { <4.46, 288.6117, 17.5167>, <4.7901, 282.6762, 15.615>, <6.3966, 288.3923, 17.5377> }
					triangle { <5.3513, 282.6301, 15.4932>, <6.3966, 288.3923, 17.5377>, <4.7901, 282.6762, 15.615> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <5.3119, 281.0854, 18.5857>, <5.3733, 281.0242, 17.7618>, <5.3749, 281.9122, 16.2995> }
					triangle { <5.3733, 281.0242, 17.7618>, <5.4212, 282.083, 15.3267>, <5.3749, 281.9122, 16.2995> }
					triangle { <5.4212, 282.083, 15.3267>, <5.3513, 282.6301, 15.4932>, <5.3749, 281.9122, 16.2995> }
					triangle { <5.3749, 281.9122, 16.2995>, <5.3513, 282.6301, 15.4932>, <5.3119, 281.0854, 18.5857> }
					triangle { <5.4212, 282.083, 15.3267>, <9.8934, 280.8557, 14.6647>, <11.5705, 281.9284, 14.2689> }
					triangle { <11.5705, 281.9284, 14.2689>, <12.2755, 283.7968, 14.9994>, <11.4677, 283.6259, 15.2214> }
					triangle { <11.4677, 283.6259, 15.2214>, <5.4212, 282.083, 15.3267>, <11.5705, 281.9284, 14.2689> }
					triangle { <5.4212, 282.083, 15.3267>, <11.4677, 283.6259, 15.2214>, <5.3513, 282.6301, 15.4932> }
					triangle { <5.3039, 282.4169, 16.5508>, <5.2667, 281.7813, 18.1387>, <5.3119, 281.0854, 18.5857> }
					triangle { <5.3039, 282.4169, 16.5508>, <5.2792, 283.0925, 15.8291>, <5.2667, 281.7813, 18.1387> }
					triangle { <5.3039, 282.4169, 16.5508>, <5.3513, 282.6301, 15.4932>, <5.2792, 283.0925, 15.8291> }
					triangle { <5.3119, 281.0854, 18.5857>, <5.3513, 282.6301, 15.4932>, <5.3039, 282.4169, 16.5508> }
					triangle { <11.0852, 285.3777, 15.9857>, <9.2779, 285.2304, 16.842>, <5.2792, 283.0925, 15.8291> }
					triangle { <11.4677, 283.6259, 15.2214>, <12.2755, 283.7968, 14.9994>, <11.0852, 285.3777, 15.9857> }
					triangle { <11.0852, 285.3777, 15.9857>, <5.2792, 283.0925, 15.8291>, <11.4677, 283.6259, 15.2214> }
					triangle { <5.3513, 282.6301, 15.4932>, <11.4677, 283.6259, 15.2214>, <5.2792, 283.0925, 15.8291> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <1.9889, 268.5352, 34.7918>, <2.938, 270.41, 33.7302>, 0.2999 }
			cylinder { <2.938, 270.41, 33.7302>, <3.8457, 272.2656, 32.6008>, 0.2999 }
			cylinder { <3.8457, 272.2656, 32.6008>, <4.7111, 274.0996, 31.405>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.7111, 274.0996, 31.405>, <6.9354, 280.4554, 29.2746>, 0.2999 }
				cylinder { <6.9354, 280.4554, 29.2746>, <8.6546, 287.284, 28.7288>, 0.2999 }
				cylinder { <8.6546, 287.284, 28.7288>, <9.7657, 294.176, 29.8005>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <9.7657, 294.176, 29.8005>, <9.8309, 294.8893, 30.2168>, <10.02162, 296.5813, 30.0516> }
					triangle { <9.8309, 294.8893, 30.2168>, <10.1168, 297.5275, 30.3226>, <10.02162, 296.5813, 30.0516> }
					triangle { <10.1168, 297.5275, 30.3226>, <10.1439, 297.612, 29.7534>, <10.02162, 296.5813, 30.0516> }
					triangle { <10.02162, 296.5813, 30.0516>, <10.1439, 297.612, 29.7534>, <9.7657, 294.176, 29.8005> }
					triangle { <10.1168, 297.5275, 30.3226>, <5.8353, 298.1189, 32.1293>, <4.2044, 299.1474, 31.4952> }
					triangle { <4.2044, 299.1474, 31.4952>, <3.3398, 299.4067, 29.57>, <4.11, 299.0358, 29.5516> }
					triangle { <4.11, 299.0358, 29.5516>, <10.1168, 297.5275, 30.3226>, <4.2044, 299.1474, 31.4952> }
					triangle { <10.1168, 297.5275, 30.3226>, <4.11, 299.0358, 29.5516>, <10.1439, 297.612, 29.7534> }
					triangle { <10.03835, 296.5717, 29.4836>, <9.856, 294.8748, 29.3648>, <9.7657, 294.176, 29.8005> }
					triangle { <10.03835, 296.5717, 29.4836>, <10.1503, 297.5082, 29.1867>, <9.856, 294.8748, 29.3648> }
					triangle { <10.03835, 296.5717, 29.4836>, <10.1439, 297.612, 29.7534>, <10.1503, 297.5082, 29.1867> }
					triangle { <9.7657, 294.176, 29.8005>, <10.1439, 297.612, 29.7534>, <10.03835, 296.5717, 29.4836> }
					triangle { <4.3187, 299.0815, 27.6142>, <5.9803, 298.0354, 27.207>, <10.1503, 297.5082, 29.1867> }
					triangle { <4.11, 299.0358, 29.5516>, <3.3398, 299.4067, 29.57>, <4.3187, 299.0815, 27.6142> }
					triangle { <4.3187, 299.0815, 27.6142>, <10.1503, 297.5082, 29.1867>, <4.11, 299.0358, 29.5516> }
					triangle { <10.1439, 297.612, 29.7534>, <4.11, 299.0358, 29.5516>, <10.1503, 297.5082, 29.1867> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <9.7657, 294.176, 29.8005>, <10.2416, 294.8402, 29.937>, <10.2954, 296.5486, 29.865> }
					triangle { <10.2416, 294.8402, 29.937>, <10.6644, 297.4621, 29.9496>, <10.2954, 296.5486, 29.865> }
					triangle { <10.6644, 297.4621, 29.9496>, <10.1439, 297.612, 29.7534>, <10.2954, 296.5486, 29.865> }
					triangle { <10.2954, 296.5486, 29.865>, <10.1439, 297.612, 29.7534>, <9.7657, 294.176, 29.8005> }
					triangle { <10.6644, 297.4621, 29.9496>, <11.04126, 297.5799, 34.6175>, <10.00858, 298.571, 36.05669> }
					triangle { <10.00858, 298.571, 36.05669>, <7.938, 298.9928, 36.2938>, <8.1361, 298.6746, 35.5253> }
					triangle { <8.1361, 298.6746, 35.5253>, <10.6644, 297.4621, 29.9496>, <10.00858, 298.571, 36.05669> }
					triangle { <10.6644, 297.4621, 29.9496>, <8.1361, 298.6746, 35.5253>, <10.1439, 297.612, 29.7534> }
					triangle { <9.7645, 296.6044, 29.6701>, <9.4452, 294.9239, 29.6446>, <9.7657, 294.176, 29.8005> }
					triangle { <9.7645, 296.6044, 29.6701>, <9.6027, 297.5736, 29.5597>, <9.4452, 294.9239, 29.6446> }
					triangle { <9.7645, 296.6044, 29.6701>, <10.1439, 297.612, 29.7534>, <9.6027, 297.5736, 29.5597> }
					triangle { <9.7657, 294.176, 29.8005>, <10.1439, 297.612, 29.7534>, <9.7645, 296.6044, 29.6701> }
					triangle { <6.3808, 298.9521, 34.7245>, <6.4402, 298.0632, 32.928>, <9.6027, 297.5736, 29.5597> }
					triangle { <8.1361, 298.6746, 35.5253>, <7.938, 298.9928, 36.2938>, <6.3808, 298.9521, 34.7245> }
					triangle { <6.3808, 298.9521, 34.7245>, <9.6027, 297.5736, 29.5597>, <8.1361, 298.6746, 35.5253> }
					triangle { <10.1439, 297.612, 29.7534>, <8.1361, 298.6746, 35.5253>, <9.6027, 297.5736, 29.5597> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <9.7657, 294.176, 29.8005>, <10.1058, 294.8486, 29.4566>, <10.2048, 296.5542, 29.5447> }
					triangle { <10.1058, 294.8486, 29.4566>, <10.4833, 297.4732, 29.309>, <10.2048, 296.5542, 29.5447> }
					triangle { <10.4833, 297.4732, 29.309>, <10.1439, 297.612, 29.7534>, <10.2048, 296.5542, 29.5447> }
					triangle { <10.2048, 296.5542, 29.5447>, <10.1439, 297.612, 29.7534>, <9.7657, 294.176, 29.8005> }
					triangle { <10.4833, 297.4732, 29.309>, <15.01547, 297.085, 30.429>, <16.1265, 297.8412, 31.95> }
					triangle { <16.1265, 297.8412, 31.95>, <15.7206, 298.1049, 34.02057>, <15.03201, 297.8885, 33.5621> }
					triangle { <15.03201, 297.8885, 33.5621>, <10.4833, 297.4732, 29.309>, <16.1265, 297.8412, 31.95> }
					triangle { <10.4833, 297.4732, 29.309>, <15.03201, 297.8885, 33.5621>, <10.1439, 297.612, 29.7534> }
					triangle { <9.855, 296.5988, 29.9904>, <9.5811, 294.9155, 30.1251>, <9.7657, 294.176, 29.8005> }
					triangle { <9.855, 296.5988, 29.9904>, <9.7838, 297.5625, 30.2003>, <9.5811, 294.9155, 30.1251> }
					triangle { <9.855, 296.5988, 29.9904>, <10.1439, 297.612, 29.7534>, <9.7838, 297.5625, 30.2003> }
					triangle { <9.7657, 294.176, 29.8005>, <10.1439, 297.612, 29.7534>, <9.855, 296.5988, 29.9904> }
					triangle { <13.7364, 298.1461, 34.9954>, <11.984, 297.4717, 34.2914>, <9.7838, 297.5625, 30.2003> }
					triangle { <15.03201, 297.8885, 33.5621>, <15.7206, 298.1049, 34.02057>, <13.7364, 298.1461, 34.9954> }
					triangle { <13.7364, 298.1461, 34.9954>, <9.7838, 297.5625, 30.2003>, <15.03201, 297.8885, 33.5621> }
					triangle { <10.1439, 297.612, 29.7534>, <15.03201, 297.8885, 33.5621>, <9.7838, 297.5625, 30.2003> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <9.7657, 294.176, 29.8005>, <9.6098, 294.9029, 29.4349>, <9.8742, 296.5904, 29.5303> }
					triangle { <9.6098, 294.9029, 29.4349>, <9.8221, 297.5456, 29.2801>, <9.8742, 296.5904, 29.5303> }
					triangle { <9.8221, 297.5456, 29.2801>, <10.1439, 297.612, 29.7534>, <9.8742, 296.5904, 29.5303> }
					triangle { <9.8742, 296.5904, 29.5303>, <10.1439, 297.612, 29.7534>, <9.7657, 294.176, 29.8005> }
					triangle { <9.8221, 297.5456, 29.2801>, <12.3028, 297.3134, 25.3131>, <14.1606, 297.9597, 24.8123> }
					triangle { <14.1606, 297.9597, 24.8123>, <16.00495, 297.9618, 25.8705>, <15.3322, 297.7567, 26.3567> }
					triangle { <15.3322, 297.7567, 26.3567>, <9.8221, 297.5456, 29.2801>, <14.1606, 297.9597, 24.8123> }
					triangle { <9.8221, 297.5456, 29.2801>, <15.3322, 297.7567, 26.3567>, <10.1439, 297.612, 29.7534> }
					triangle { <10.1857, 296.5626, 30.00489>, <10.07704, 294.8612, 30.1467>, <9.7657, 294.176, 29.8005> }
					triangle { <10.1857, 296.5626, 30.00489>, <10.445, 297.4901, 30.2292>, <10.07704, 294.8612, 30.1467> }
					triangle { <10.1857, 296.5626, 30.00489>, <10.1439, 297.612, 29.7534>, <10.445, 297.4901, 30.2292> }
					triangle { <9.7657, 294.176, 29.8005>, <10.1439, 297.612, 29.7534>, <10.1857, 296.5626, 30.00489> }
					triangle { <16.2888, 297.77, 28.05493>, <15.00207, 297.0727, 29.4258>, <10.445, 297.4901, 30.2292> }
					triangle { <15.3322, 297.7567, 26.3567>, <16.00495, 297.9618, 25.8705>, <16.2888, 297.77, 28.05493> }
					triangle { <16.2888, 297.77, 28.05493>, <10.445, 297.4901, 30.2292>, <15.3322, 297.7567, 26.3567> }
					triangle { <10.1439, 297.612, 29.7534>, <15.3322, 297.7567, 26.3567>, <10.445, 297.4901, 30.2292> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <9.7657, 294.176, 29.8005>, <9.4374, 294.9284, 29.9118>, <9.7592, 296.6074, 29.8483> }
					triangle { <9.4374, 294.9284, 29.9118>, <9.5922, 297.5797, 29.916>, <9.7592, 296.6074, 29.8483> }
					triangle { <9.5922, 297.5797, 29.916>, <10.1439, 297.612, 29.7534>, <9.7592, 296.6074, 29.8483> }
					triangle { <9.7592, 296.6074, 29.8483>, <10.1439, 297.612, 29.7534>, <9.7657, 294.176, 29.8005> }
					triangle { <9.5922, 297.5797, 29.916>, <6.5436, 297.962, 26.3798>, <6.6811, 298.7791, 24.5269> }
					triangle { <6.6811, 298.7791, 24.5269>, <8.2377, 298.7785, 23.07841>, <8.4801, 298.4764, 23.8406> }
					triangle { <8.4801, 298.4764, 23.8406>, <9.5922, 297.5797, 29.916>, <6.6811, 298.7791, 24.5269> }
					triangle { <9.5922, 297.5797, 29.916>, <8.4801, 298.4764, 23.8406>, <10.1439, 297.612, 29.7534> }
					triangle { <10.3006, 296.5456, 29.6869>, <10.2494, 294.8357, 29.6698>, <9.7657, 294.176, 29.8005> }
					triangle { <10.3006, 296.5456, 29.6869>, <10.6749, 297.4561, 29.5933>, <10.2494, 294.8357, 29.6698> }
					triangle { <10.3006, 296.5456, 29.6869>, <10.1439, 297.612, 29.7534>, <10.6749, 297.4561, 29.5933> }
					triangle { <9.7657, 294.176, 29.8005>, <10.1439, 297.612, 29.7534>, <10.3006, 296.5456, 29.6869> }
					triangle { <10.3805, 298.3568, 23.4242>, <11.2355, 297.4264, 24.9812>, <10.6749, 297.4561, 29.5933> }
					triangle { <8.4801, 298.4764, 23.8406>, <8.2377, 298.7785, 23.07841>, <10.3805, 298.3568, 23.4242> }
					triangle { <10.3805, 298.3568, 23.4242>, <10.6749, 297.4561, 29.5933>, <8.4801, 298.4764, 23.8406> }
					triangle { <10.1439, 297.612, 29.7534>, <8.4801, 298.4764, 23.8406>, <10.6749, 297.4561, 29.5933> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <4.7111, 274.0996, 31.405>, <5.5656, 275.9802, 30.2755>, 0.2999 }
			cylinder { <5.5656, 275.9802, 30.2755>, <6.4082, 277.905, 29.2136>, 0.2999 }
			cylinder { <6.4082, 277.905, 29.2136>, <7.2378, 279.8718, 28.2206>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.2378, 279.8718, 28.2206>, <10.9699, 284.7101, 24.6788>, 0.2999 }
				cylinder { <10.9699, 284.7101, 24.6788>, <15.7213, 288.1966, 20.7862>, 0.2999 }
				cylinder { <15.7213, 288.1966, 20.7862>, <21.2073, 290.122, 16.7763>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <21.2073, 290.122, 16.7763>, <21.694, 289.8727, 16.2003>, <22.9337, 290.3134, 15.2209> }
					triangle { <21.694, 289.8727, 16.2003>, <23.6002, 290.2344, 14.5512>, <22.9337, 290.3134, 15.2209> }
					triangle { <23.6002, 290.2344, 14.5512>, <23.7034, 290.7589, 14.6906>, <22.9337, 290.3134, 15.2209> }
					triangle { <22.9337, 290.3134, 15.2209>, <23.7034, 290.7589, 14.6906>, <21.2073, 290.122, 16.7763> }
					triangle { <23.6002, 290.2344, 14.5512>, <26.2252, 287.2449, 16.6358>, <27.9757, 287.3849, 17.4746> }
					triangle { <27.9757, 287.3849, 17.4746>, <28.8234, 288.8265, 18.6406>, <28.1157, 289.0572, 18.297> }
					triangle { <28.1157, 289.0572, 18.297>, <23.6002, 290.2344, 14.5512>, <27.9757, 287.3849, 17.4746> }
					triangle { <23.6002, 290.2344, 14.5512>, <28.1157, 289.0572, 18.297>, <23.7034, 290.7589, 14.6906> }
					triangle { <22.9686, 290.8204, 15.4174>, <21.7463, 290.6331, 16.4951>, <21.2073, 290.122, 16.7763> }
					triangle { <22.9686, 290.8204, 15.4174>, <23.6699, 291.2484, 14.9442>, <21.7463, 290.6331, 16.4951> }
					triangle { <22.9686, 290.8204, 15.4174>, <23.7034, 290.7589, 14.6906>, <23.6699, 291.2484, 14.9442> }
					triangle { <21.2073, 290.122, 16.7763>, <23.7034, 290.7589, 14.6906>, <22.9686, 290.8204, 15.4174> }
					triangle { <28.2141, 290.8493, 18.8176>, <26.5276, 291.6388, 18.3391>, <23.6699, 291.2484, 14.9442> }
					triangle { <28.1157, 289.0572, 18.297>, <28.8234, 288.8265, 18.6406>, <28.2141, 290.8493, 18.8176> }
					triangle { <28.2141, 290.8493, 18.8176>, <23.6699, 291.2484, 14.9442>, <28.1157, 289.0572, 18.297> }
					triangle { <23.7034, 290.7589, 14.6906>, <28.1157, 289.0572, 18.297>, <23.6699, 291.2484, 14.9442> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <21.2073, 290.122, 16.7763>, <21.4579, 290.2546, 16.0344>, <22.7763, 290.5681, 15.1102> }
					triangle { <21.4579, 290.2546, 16.0344>, <23.2853, 290.7437, 14.3299>, <22.7763, 290.5681, 15.1102> }
					triangle { <23.2853, 290.7437, 14.3299>, <23.7034, 290.7589, 14.6906>, <22.7763, 290.5681, 15.1102> }
					triangle { <22.7763, 290.5681, 15.1102>, <23.7034, 290.7589, 14.6906>, <21.2073, 290.122, 16.7763> }
					triangle { <23.2853, 290.7437, 14.3299>, <22.7498, 286.7589, 12.328>, <23.9579, 285.2649, 12.01897> }
					triangle { <23.9579, 285.2649, 12.01897>, <25.3918, 284.4007, 13.1824>, <25.1041, 285.1057, 13.4864> }
					triangle { <25.1041, 285.1057, 13.4864>, <23.2853, 290.7437, 14.3299>, <23.9579, 285.2649, 12.01897> }
					triangle { <23.2853, 290.7437, 14.3299>, <25.1041, 285.1057, 13.4864>, <23.7034, 290.7589, 14.6906> }
					triangle { <23.126, 290.5658, 15.528>, <21.9825, 290.2511, 16.6611>, <21.2073, 290.122, 16.7763> }
					triangle { <23.126, 290.5658, 15.528>, <23.9848, 290.739, 15.1655>, <21.9825, 290.2511, 16.6611> }
					triangle { <23.126, 290.5658, 15.528>, <23.7034, 290.7589, 14.6906>, <23.9848, 290.739, 15.1655> }
					triangle { <21.2073, 290.122, 16.7763>, <23.7034, 290.7589, 14.6906>, <23.126, 290.5658, 15.528> }
					triangle { <26.3477, 285.2488, 14.874>, <25.7807, 286.7385, 15.9491>, <23.9848, 290.739, 15.1655> }
					triangle { <25.1041, 285.1057, 13.4864>, <25.3918, 284.4007, 13.1824>, <26.3477, 285.2488, 14.874> }
					triangle { <26.3477, 285.2488, 14.874>, <23.9848, 290.739, 15.1655>, <25.1041, 285.1057, 13.4864> }
					triangle { <23.7034, 290.7589, 14.6906>, <25.1041, 285.1057, 13.4864>, <23.9848, 290.739, 15.1655> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <21.2073, 290.122, 16.7763>, <21.5818, 290.6342, 16.2985>, <22.8589, 290.8212, 15.2863> }
					triangle { <21.5818, 290.6342, 16.2985>, <23.4505, 291.2498, 14.6821>, <22.8589, 290.8212, 15.2863> }
					triangle { <23.4505, 291.2498, 14.6821>, <23.7034, 290.7589, 14.6906>, <22.8589, 290.8212, 15.2863> }
					triangle { <22.8589, 290.8212, 15.2863>, <23.7034, 290.7589, 14.6906>, <21.2073, 290.122, 16.7763> }
					triangle { <23.4505, 291.2498, 14.6821>, <20.5833, 291.7633, 11.2632>, <20.4357, 290.9016, 9.5245> }
					triangle { <20.4357, 290.9016, 9.5245>, <20.6753, 288.9658, 8.9316>, <20.9209, 289.1055, 9.7012> }
					triangle { <20.9209, 289.1055, 9.7012>, <23.4505, 291.2498, 14.6821>, <20.4357, 290.9016, 9.5245> }
					triangle { <23.4505, 291.2498, 14.6821>, <20.9209, 289.1055, 9.7012>, <23.7034, 290.7589, 14.6906> }
					triangle { <23.04346, 290.3127, 15.3519>, <21.8586, 289.8716, 16.3969>, <21.2073, 290.122, 16.7763> }
					triangle { <23.04346, 290.3127, 15.3519>, <23.8196, 290.2329, 14.8133>, <21.8586, 289.8716, 16.3969> }
					triangle { <23.04346, 290.3127, 15.3519>, <23.7034, 290.7589, 14.6906>, <23.8196, 290.2329, 14.8133> }
					triangle { <21.2073, 290.122, 16.7763>, <23.7034, 290.7589, 14.6906>, <23.04346, 290.3127, 15.3519> }
					triangle { <21.6965, 287.4271, 9.9727>, <22.1825, 287.3567, 11.8316>, <23.8196, 290.2329, 14.8133> }
					triangle { <20.9209, 289.1055, 9.7012>, <20.6753, 288.9658, 8.9316>, <21.6965, 287.4271, 9.9727> }
					triangle { <21.6965, 287.4271, 9.9727>, <23.8196, 290.2329, 14.8133>, <20.9209, 289.1055, 9.7012> }
					triangle { <23.7034, 290.7589, 14.6906>, <20.9209, 289.1055, 9.7012>, <23.8196, 290.2329, 14.8133> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <21.2073, 290.122, 16.7763>, <21.8956, 290.4904, 16.6302>, <23.06818, 290.7253, 15.5075> }
					triangle { <21.8956, 290.4904, 16.6302>, <23.869, 291.058, 15.1244>, <23.06818, 290.7253, 15.5075> }
					triangle { <23.869, 291.058, 15.1244>, <23.7034, 290.7589, 14.6906>, <23.06818, 290.7253, 15.5075> }
					triangle { <23.06818, 290.7253, 15.5075>, <23.7034, 290.7589, 14.6906>, <21.2073, 290.122, 16.7763> }
					triangle { <23.869, 291.058, 15.1244>, <22.6996, 295.389, 14.9029>, <22.2437, 296.5579, 13.4153> }
					triangle { <22.2437, 296.5579, 13.4153>, <21.1479, 296.2555, 11.7229>, <21.308, 295.5663, 12.1371> }
					triangle { <21.308, 295.5663, 12.1371>, <23.869, 291.058, 15.1244>, <22.2437, 296.5579, 13.4153> }
					triangle { <23.869, 291.058, 15.1244>, <21.308, 295.5663, 12.1371>, <23.7034, 290.7589, 14.6906> }
					triangle { <22.8342, 290.4086, 15.1308>, <21.5447, 290.0154, 16.06526>, <21.2073, 290.122, 16.7763> }
					triangle { <22.8342, 290.4086, 15.1308>, <23.4011, 290.4247, 14.371>, <21.5447, 290.0154, 16.06526> }
					triangle { <22.8342, 290.4086, 15.1308>, <23.7034, 290.7589, 14.6906>, <23.4011, 290.4247, 14.371> }
					triangle { <21.2073, 290.122, 16.7763>, <23.7034, 290.7589, 14.6906>, <22.8342, 290.4086, 15.1308> }
					triangle { <20.645, 294.3942, 10.8414>, <20.672, 292.6447, 11.6384>, <23.4011, 290.4247, 14.371> }
					triangle { <21.308, 295.5663, 12.1371>, <21.1479, 296.2555, 11.7229>, <20.645, 294.3942, 10.8414> }
					triangle { <20.645, 294.3942, 10.8414>, <23.4011, 290.4247, 14.371>, <21.308, 295.5663, 12.1371> }
					triangle { <23.7034, 290.7589, 14.6906>, <21.308, 295.5663, 12.1371>, <23.4011, 290.4247, 14.371> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <21.2073, 290.122, 16.7763>, <21.966, 290.0126, 16.5686>, <23.1151, 290.4067, 15.4664> }
					triangle { <21.966, 290.0126, 16.5686>, <23.9629, 290.421, 15.04226>, <23.1151, 290.4067, 15.4664> }
					triangle { <23.9629, 290.421, 15.04226>, <23.7034, 290.7589, 14.6906>, <23.1151, 290.4067, 15.4664> }
					triangle { <23.1151, 290.4067, 15.4664>, <23.7034, 290.7589, 14.6906>, <21.2073, 290.122, 16.7763> }
					triangle { <23.9629, 290.421, 15.04226>, <26.2392, 292.5543, 18.2734>, <26.974, 294.3517, 18.4028> }
					triangle { <26.974, 294.3517, 18.4028>, <26.2598, 296.1681, 17.814>, <25.8218, 295.536, 17.5298> }
					triangle { <25.8218, 295.536, 17.5298>, <23.9629, 290.421, 15.04226>, <26.974, 294.3517, 18.4028> }
					triangle { <23.9629, 290.421, 15.04226>, <25.8218, 295.536, 17.5298>, <23.7034, 290.7589, 14.6906> }
					triangle { <22.7872, 290.7271, 15.1719>, <21.4743, 290.4932, 16.1268>, <21.2073, 290.122, 16.7763> }
					triangle { <22.7872, 290.7271, 15.1719>, <23.3072, 291.0618, 14.4532>, <21.4743, 290.4932, 16.1268> }
					triangle { <22.7872, 290.7271, 15.1719>, <23.7034, 290.7589, 14.6906>, <23.3072, 291.0618, 14.4532> }
					triangle { <21.2073, 290.122, 16.7763>, <23.7034, 290.7589, 14.6906>, <22.7872, 290.7271, 15.1719> }
					triangle { <24.7338, 296.5412, 16.3903>, <23.3979, 295.3312, 15.721>, <23.3072, 291.0618, 14.4532> }
					triangle { <25.8218, 295.536, 17.5298>, <26.2598, 296.1681, 17.814>, <24.7338, 296.5412, 16.3903> }
					triangle { <24.7338, 296.5412, 16.3903>, <23.3072, 291.0618, 14.4532>, <25.8218, 295.536, 17.5298> }
					triangle { <23.7034, 290.7589, 14.6906>, <25.8218, 295.536, 17.5298>, <23.3072, 291.0618, 14.4532> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-6.1112, 251.5339, 44.4673>, <-6.1398, 253.8138, 45.05362>, 0.2999 }
			cylinder { <-6.1398, 253.8138, 45.05362>, <-6.1278, 256.1104, 45.571>, 0.2999 }
			cylinder { <-6.1278, 256.1104, 45.571>, <-6.07516, 258.4211, 46.01889>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-6.07516, 258.4211, 46.01889>, <-7.7751, 259.8604, 46.781>, 0.2999 }
			cylinder { <-7.7751, 259.8604, 46.781>, <-9.5253, 261.2354, 47.5484>, 0.2999 }
			cylinder { <-9.5253, 261.2354, 47.5484>, <-11.3235, 262.5445, 48.32>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.3235, 262.5445, 48.32>, <-15.5028, 267.1592, 51.6547>, 0.2999 }
				cylinder { <-15.5028, 267.1592, 51.6547>, <-18.2163, 272.185, 55.8093>, 0.2999 }
				cylinder { <-18.2163, 272.185, 55.8093>, <-19.3014, 277.3206, 60.5349>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-19.3014, 277.3206, 60.5349>, <-18.9665, 277.9734, 60.9195>, <-19.2683, 279.2303, 62.04021> }
					triangle { <-18.9665, 277.9734, 60.9195>, <-19.09142, 280.0252, 62.6012>, <-19.2683, 279.2303, 62.04021> }
					triangle { <-19.09142, 280.0252, 62.6012>, <-19.6399, 279.946, 62.7585>, <-19.2683, 279.2303, 62.04021> }
					triangle { <-19.2683, 279.2303, 62.04021>, <-19.6399, 279.946, 62.7585>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-19.09142, 280.0252, 62.6012>, <-15.9799, 278.0831, 65.5152>, <-16.07711, 277.5389, 67.4682> }
					triangle { <-16.07711, 277.5389, 67.4682>, <-17.6091, 276.6165, 68.6186>, <-17.8677, 276.8661, 67.8427> }
					triangle { <-17.8677, 276.8661, 67.8427>, <-19.09142, 280.0252, 62.6012>, <-16.07711, 277.5389, 67.4682> }
					triangle { <-19.09142, 280.0252, 62.6012>, <-17.8677, 276.8661, 67.8427>, <-19.6399, 279.946, 62.7585> }
					triangle { <-19.8075, 279.0792, 62.1366>, <-19.7754, 277.7466, 61.06415>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-19.8075, 279.0792, 62.1366>, <-20.1699, 279.7228, 62.794>, <-19.7754, 277.7466, 61.06415> }
					triangle { <-19.8075, 279.0792, 62.1366>, <-19.6399, 279.946, 62.7585>, <-20.1699, 279.7228, 62.794> }
					triangle { <-19.3014, 277.3206, 60.5349>, <-19.6399, 279.946, 62.7585>, <-19.8075, 279.0792, 62.1366> }
					triangle { <-19.762, 276.5058, 68.1269>, <-20.6535, 276.7729, 66.3506>, <-20.1699, 279.7228, 62.794> }
					triangle { <-17.8677, 276.8661, 67.8427>, <-17.6091, 276.6165, 68.6186>, <-19.762, 276.5058, 68.1269> }
					triangle { <-19.762, 276.5058, 68.1269>, <-20.1699, 279.7228, 62.794>, <-17.8677, 276.8661, 67.8427> }
					triangle { <-19.6399, 279.946, 62.7585>, <-17.8677, 276.8661, 67.8427>, <-20.1699, 279.7228, 62.794> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.3014, 277.3206, 60.5349>, <-19.3654, 278.1359, 60.6669>, <-19.5342, 279.3387, 61.8718> }
					triangle { <-19.3654, 278.1359, 60.6669>, <-19.6233, 280.2418, 62.2644>, <-19.5342, 279.3387, 61.8718> }
					triangle { <-19.6233, 280.2418, 62.2644>, <-19.6399, 279.946, 62.7585>, <-19.5342, 279.3387, 61.8718> }
					triangle { <-19.5342, 279.3387, 61.8718>, <-19.6399, 279.946, 62.7585>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-19.6233, 280.2418, 62.2644>, <-15.3663, 281.8532, 61.1572>, <-13.7134, 282.2491, 62.2668> }
					triangle { <-13.7134, 282.2491, 62.2668>, <-12.8139, 281.2298, 63.9018>, <-13.5878, 280.9299, 63.6962> }
					triangle { <-13.5878, 280.9299, 63.6962>, <-19.6233, 280.2418, 62.2644>, <-13.7134, 282.2491, 62.2668> }
					triangle { <-19.6233, 280.2418, 62.2644>, <-13.5878, 280.9299, 63.6962>, <-19.6399, 279.946, 62.7585> }
					triangle { <-19.5415, 278.9708, 62.3049>, <-19.3764, 277.5842, 61.3167>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-19.5415, 278.9708, 62.3049>, <-19.638, 279.5062, 63.1307>, <-19.3764, 277.5842, 61.3167> }
					triangle { <-19.5415, 278.9708, 62.3049>, <-19.6399, 279.946, 62.7585>, <-19.638, 279.5062, 63.1307> }
					triangle { <-19.3014, 277.3206, 60.5349>, <-19.6399, 279.946, 62.7585>, <-19.5415, 278.9708, 62.3049> }
					triangle { <-13.7634, 279.7357, 65.2267>, <-15.4297, 278.6656, 64.9112>, <-19.638, 279.5062, 63.1307> }
					triangle { <-13.5878, 280.9299, 63.6962>, <-12.8139, 281.2298, 63.9018>, <-13.7634, 279.7357, 65.2267> }
					triangle { <-13.7634, 279.7357, 65.2267>, <-19.638, 279.5062, 63.1307>, <-13.5878, 280.9299, 63.6962> }
					triangle { <-19.6399, 279.946, 62.7585>, <-13.5878, 280.9299, 63.6962>, <-19.638, 279.5062, 63.1307> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.3014, 277.3206, 60.5349>, <-19.7719, 277.9197, 60.8603>, <-19.8052, 279.1945, 62.00074> }
					triangle { <-19.7719, 277.9197, 60.8603>, <-20.1653, 279.9536, 62.5222>, <-19.8052, 279.1945, 62.00074> }
					triangle { <-20.1653, 279.9536, 62.5222>, <-19.6399, 279.946, 62.7585>, <-19.8052, 279.1945, 62.00074> }
					triangle { <-19.8052, 279.1945, 62.00074>, <-19.6399, 279.946, 62.7585>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-20.1653, 279.9536, 62.5222>, <-20.6188, 283.0054, 58.9972>, <-19.5993, 284.6865, 58.4929> }
					triangle { <-19.5993, 284.6865, 58.4929>, <-17.5284, 285.1669, 58.5355>, <-17.7171, 284.433, 58.9315> }
					triangle { <-17.7171, 284.433, 58.9315>, <-20.1653, 279.9536, 62.5222>, <-19.5993, 284.6865, 58.4929> }
					triangle { <-20.1653, 279.9536, 62.5222>, <-17.7171, 284.433, 58.9315>, <-19.6399, 279.946, 62.7585> }
					triangle { <-19.2705, 279.115, 62.176>, <-18.9699, 277.8004, 61.1233>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-19.2705, 279.115, 62.176>, <-19.09601, 279.7945, 62.8729>, <-18.9699, 277.8004, 61.1233> }
					triangle { <-19.2705, 279.115, 62.176>, <-19.6399, 279.946, 62.7585>, <-19.09601, 279.7945, 62.8729> }
					triangle { <-19.3014, 277.3206, 60.5349>, <-19.6399, 279.946, 62.7585>, <-19.2705, 279.115, 62.176> }
					triangle { <-15.9457, 284.1428, 59.6911>, <-15.985, 282.3158, 60.5169>, <-19.09601, 279.7945, 62.8729> }
					triangle { <-17.7171, 284.433, 58.9315>, <-17.5284, 285.1669, 58.5355>, <-15.9457, 284.1428, 59.6911> }
					triangle { <-15.9457, 284.1428, 59.6911>, <-19.09601, 279.7945, 62.8729>, <-17.7171, 284.433, 58.9315> }
					triangle { <-19.6399, 279.946, 62.7585>, <-17.7171, 284.433, 58.9315>, <-19.09601, 279.7945, 62.8729> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.3014, 277.3206, 60.5349>, <-19.628, 277.6216, 61.2342>, <-19.7093, 278.9958, 62.2499> }
					triangle { <-19.628, 277.6216, 61.2342>, <-19.9734, 279.5561, 63.02075>, <-19.7093, 278.9958, 62.2499> }
					triangle { <-19.9734, 279.5561, 63.02075>, <-19.6399, 279.946, 62.7585>, <-19.7093, 278.9958, 62.2499> }
					triangle { <-19.7093, 278.9958, 62.2499>, <-19.6399, 279.946, 62.7585>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-19.9734, 279.5561, 63.02075>, <-24.5277, 279.958, 62.00009>, <-25.6555, 281.5054, 61.3266> }
					triangle { <-25.6555, 281.5054, 61.3266>, <-25.2813, 283.0236, 59.8856>, <-24.5876, 282.5668, 60.08884> }
					triangle { <-24.5876, 282.5668, 60.08884>, <-19.9734, 279.5561, 63.02075>, <-25.6555, 281.5054, 61.3266> }
					triangle { <-19.9734, 279.5561, 63.02075>, <-24.5876, 282.5668, 60.08884>, <-19.6399, 279.946, 62.7585> }
					triangle { <-19.3665, 279.3137, 61.9268>, <-19.1139, 278.0984, 60.7495>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-19.3665, 279.3137, 61.9268>, <-19.2879, 280.1919, 62.3744>, <-19.1139, 278.0984, 60.7495> }
					triangle { <-19.3665, 279.3137, 61.9268>, <-19.6399, 279.946, 62.7585>, <-19.2879, 280.1919, 62.3744> }
					triangle { <-19.3014, 277.3206, 60.5349>, <-19.6399, 279.946, 62.7585>, <-19.3665, 279.3137, 61.9268> }
					triangle { <-23.3134, 283.6776, 59.1185>, <-21.5572, 282.713, 59.1995>, <-19.2879, 280.1919, 62.3744> }
					triangle { <-24.5876, 282.5668, 60.08884>, <-25.2813, 283.0236, 59.8856>, <-23.3134, 283.6776, 59.1185> }
					triangle { <-23.3134, 283.6776, 59.1185>, <-19.2879, 280.1919, 62.3744>, <-24.5876, 282.5668, 60.08884> }
					triangle { <-19.6399, 279.946, 62.7585>, <-24.5876, 282.5668, 60.08884>, <-19.2879, 280.1919, 62.3744> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.3014, 277.3206, 60.5349>, <-19.1227, 277.6553, 61.2713>, <-19.3724, 279.0182, 62.2747> }
					triangle { <-19.1227, 277.6553, 61.2713>, <-19.2996, 279.601, 63.07028>, <-19.3724, 279.0182, 62.2747> }
					triangle { <-19.2996, 279.601, 63.07028>, <-19.6399, 279.946, 62.7585>, <-19.3724, 279.0182, 62.2747> }
					triangle { <-19.3724, 279.0182, 62.2747>, <-19.6399, 279.946, 62.7585>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-19.2996, 279.601, 63.07028>, <-21.6174, 276.8699, 66.08925>, <-23.4458, 277.0213, 66.9574> }
					triangle { <-23.4458, 277.0213, 66.9574>, <-25.3319, 277.6594, 66.2114>, <-24.682, 277.8196, 65.6794> }
					triangle { <-24.682, 277.8196, 65.6794>, <-19.2996, 279.601, 63.07028>, <-23.4458, 277.0213, 66.9574> }
					triangle { <-19.2996, 279.601, 63.07028>, <-24.682, 277.8196, 65.6794>, <-19.6399, 279.946, 62.7585> }
					triangle { <-19.7034, 279.2912, 61.902>, <-19.6192, 278.0648, 60.7123>, <-19.3014, 277.3206, 60.5349> }
					triangle { <-19.7034, 279.2912, 61.902>, <-19.9616, 280.147, 62.3249>, <-19.6192, 278.0648, 60.7123> }
					triangle { <-19.7034, 279.2912, 61.902>, <-19.6399, 279.946, 62.7585>, <-19.9616, 280.147, 62.3249> }
					triangle { <-19.3014, 277.3206, 60.5349>, <-19.6399, 279.946, 62.7585>, <-19.7034, 279.2912, 61.902> }
					triangle { <-25.7076, 278.8865, 64.4108>, <-24.486, 279.2356, 62.8594>, <-19.9616, 280.147, 62.3249> }
					triangle { <-24.682, 277.8196, 65.6794>, <-25.3319, 277.6594, 66.2114>, <-25.7076, 278.8865, 64.4108> }
					triangle { <-25.7076, 278.8865, 64.4108>, <-19.9616, 280.147, 62.3249>, <-24.682, 277.8196, 65.6794> }
					triangle { <-19.6399, 279.946, 62.7585>, <-24.682, 277.8196, 65.6794>, <-19.9616, 280.147, 62.3249> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-11.3235, 262.5445, 48.32>, <-13.06974, 263.8938, 49.1401>, 0.2999 }
			cylinder { <-13.06974, 263.8938, 49.1401>, <-14.7618, 265.2817, 50.00786>, 0.2999 }
			cylinder { <-14.7618, 265.2817, 50.00786>, <-16.3979, 266.7065, 50.922>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-16.3979, 266.7065, 50.922>, <-21.8014, 271.1214, 52.01411>, 0.2999 }
				cylinder { <-21.8014, 271.1214, 52.01411>, <-27.3766, 275.4123, 51.39>, 0.2999 }
				cylinder { <-27.3766, 275.4123, 51.39>, <-32.7891, 279.3218, 49.08725>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-32.7891, 279.3218, 49.08725>, <-33.372, 279.519, 48.5326>, <-34.6255, 280.625, 48.1689> }
					triangle { <-33.372, 279.519, 48.5326>, <-35.3672, 281.0423, 47.6654>, <-34.6255, 280.625, 48.1689> }
					triangle { <-35.3672, 281.0423, 47.6654>, <-35.3669, 281.4081, 48.1105>, <-34.6255, 280.625, 48.1689> }
					triangle { <-34.6255, 280.625, 48.1689>, <-35.3669, 281.4081, 48.1105>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-35.3672, 281.0423, 47.6654>, <-32.8905, 282.534, 43.9795>, <-32.3083, 284.3802, 43.3691> }
					triangle { <-32.3083, 284.3802, 43.3691>, <-31.5931, 286.0761, 44.4338>, <-31.9023, 285.4603, 44.94> }
					triangle { <-31.9023, 285.4603, 44.94>, <-35.3672, 281.0423, 47.6654>, <-32.3083, 284.3802, 43.3691> }
					triangle { <-35.3672, 281.0423, 47.6654>, <-31.9023, 285.4603, 44.94>, <-35.3669, 281.4081, 48.1105> }
					triangle { <-34.5546, 280.9336, 48.6408>, <-33.2656, 279.9819, 49.2404>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-34.5546, 280.9336, 48.6408>, <-35.2253, 281.6595, 48.6092>, <-33.2656, 279.9819, 49.2404> }
					triangle { <-34.5546, 280.9336, 48.6408>, <-35.3669, 281.4081, 48.1105>, <-35.2253, 281.6595, 48.6092> }
					triangle { <-32.7891, 279.3218, 49.08725>, <-35.3669, 281.4081, 48.1105>, <-34.5546, 280.9336, 48.6408> }
					triangle { <-31.8236, 286.4888, 46.5939>, <-32.2757, 285.2083, 48.06943>, <-35.2253, 281.6595, 48.6092> }
					triangle { <-31.9023, 285.4603, 44.94>, <-31.5931, 286.0761, 44.4338>, <-31.8236, 286.4888, 46.5939> }
					triangle { <-31.8236, 286.4888, 46.5939>, <-35.2253, 281.6595, 48.6092>, <-31.9023, 285.4603, 44.94> }
					triangle { <-35.3669, 281.4081, 48.1105>, <-31.9023, 285.4603, 44.94>, <-35.2253, 281.6595, 48.6092> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-32.7891, 279.3218, 49.08725>, <-33.6004, 279.4416, 48.9698>, <-34.7777, 280.5734, 48.4604> }
					triangle { <-33.6004, 279.4416, 48.9698>, <-35.6717, 280.939, 48.2484>, <-34.7777, 280.5734, 48.4604> }
					triangle { <-35.6717, 280.939, 48.2484>, <-35.3669, 281.4081, 48.1105>, <-34.7777, 280.5734, 48.4604> }
					triangle { <-34.7777, 280.5734, 48.4604>, <-35.3669, 281.4081, 48.1105>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-35.6717, 280.939, 48.2484>, <-36.6552, 278.1721, 44.5985>, <-36.7633, 278.5159, 42.601> }
					triangle { <-36.7633, 278.5159, 42.601>, <-35.5708, 279.6883, 41.2877>, <-35.3976, 279.8188, 42.1147> }
					triangle { <-35.3976, 279.8188, 42.1147>, <-35.6717, 280.939, 48.2484>, <-36.7633, 278.5159, 42.601> }
					triangle { <-35.6717, 280.939, 48.2484>, <-35.3976, 279.8188, 42.1147>, <-35.3669, 281.4081, 48.1105> }
					triangle { <-34.4023, 280.9853, 48.3493>, <-33.03725, 280.0594, 48.8032>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-34.4023, 280.9853, 48.3493>, <-34.9208, 281.7628, 48.02622>, <-33.03725, 280.0594, 48.8032> }
					triangle { <-34.4023, 280.9853, 48.3493>, <-35.3669, 281.4081, 48.1105>, <-34.9208, 281.7628, 48.02622> }
					triangle { <-32.7891, 279.3218, 49.08725>, <-35.3669, 281.4081, 48.1105>, <-34.4023, 280.9853, 48.3493> }
					triangle { <-34.1978, 281.3305, 41.8418>, <-33.4014, 281.7418, 43.6356>, <-34.9208, 281.7628, 48.02622> }
					triangle { <-35.3976, 279.8188, 42.1147>, <-35.5708, 279.6883, 41.2877>, <-34.1978, 281.3305, 41.8418> }
					triangle { <-34.1978, 281.3305, 41.8418>, <-34.9208, 281.7628, 48.02622>, <-35.3976, 279.8188, 42.1147> }
					triangle { <-35.3669, 281.4081, 48.1105>, <-35.3976, 279.8188, 42.1147>, <-34.9208, 281.7628, 48.02622> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-32.7891, 279.3218, 49.08725>, <-33.4422, 279.7881, 49.2927>, <-34.6723, 280.8044, 48.6757> }
					triangle { <-33.4422, 279.7881, 49.2927>, <-35.4609, 281.4011, 48.6789>, <-34.6723, 280.8044, 48.6757> }
					triangle { <-35.4609, 281.4011, 48.6789>, <-35.3669, 281.4081, 48.1105>, <-34.6723, 280.8044, 48.6757> }
					triangle { <-34.6723, 280.8044, 48.6757>, <-35.3669, 281.4081, 48.1105>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-35.4609, 281.4011, 48.6789>, <-38.6515, 278.252, 50.03825>, <-40.174, 277.3276, 49.06489> }
					triangle { <-40.174, 277.3276, 49.06489>, <-40.335, 276.5241, 47.1028>, <-39.6263, 276.9864, 47.2256> }
					triangle { <-39.6263, 276.9864, 47.2256>, <-35.4609, 281.4011, 48.6789>, <-40.174, 277.3276, 49.06489> }
					triangle { <-35.4609, 281.4011, 48.6789>, <-39.6263, 276.9864, 47.2256>, <-35.3669, 281.4081, 48.1105> }
					triangle { <-34.5077, 280.7542, 48.1341>, <-33.1953, 279.7129, 48.4803>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-34.5077, 280.7542, 48.1341>, <-35.1317, 281.3007, 47.5957>, <-33.1953, 279.7129, 48.4803> }
					triangle { <-34.5077, 280.7542, 48.1341>, <-35.3669, 281.4081, 48.1105>, <-35.1317, 281.3007, 47.5957> }
					triangle { <-32.7891, 279.3218, 49.08725>, <-35.3669, 281.4081, 48.1105>, <-34.5077, 280.7542, 48.1341> }
					triangle { <-39.04928, 276.9848, 45.3639>, <-37.225, 277.8171, 45.3443>, <-35.1317, 281.3007, 47.5957> }
					triangle { <-39.6263, 276.9864, 47.2256>, <-40.335, 276.5241, 47.1028>, <-39.04928, 276.9848, 45.3639> }
					triangle { <-39.04928, 276.9848, 45.3639>, <-35.1317, 281.3007, 47.5957>, <-39.6263, 276.9864, 47.2256> }
					triangle { <-35.3669, 281.4081, 48.1105>, <-39.6263, 276.9864, 47.2256>, <-35.1317, 281.3007, 47.5957> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-32.7891, 279.3218, 49.08725>, <-33.1146, 280.083, 49.05807>, <-34.4539, 281.001, 48.5192> }
					triangle { <-33.1146, 280.083, 49.05807>, <-35.02414, 281.7943, 48.366>, <-34.4539, 281.001, 48.5192> }
					triangle { <-35.02414, 281.7943, 48.366>, <-35.3669, 281.4081, 48.1105>, <-34.4539, 281.001, 48.5192> }
					triangle { <-34.4539, 281.001, 48.5192>, <-35.3669, 281.4081, 48.1105>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-35.02414, 281.7943, 48.366>, <-36.1393, 282.664, 52.8319>, <-37.8588, 282.4464, 53.8882> }
					triangle { <-37.8588, 282.4464, 53.8882>, <-39.3461, 280.9268, 53.8971>, <-38.7839, 280.851, 53.2573> }
					triangle { <-38.7839, 280.851, 53.2573>, <-35.02414, 281.7943, 48.366>, <-37.8588, 282.4464, 53.8882> }
					triangle { <-35.02414, 281.7943, 48.366>, <-38.7839, 280.851, 53.2573>, <-35.3669, 281.4081, 48.1105> }
					triangle { <-34.7261, 280.5576, 48.2905>, <-33.5229, 279.418, 48.715>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-34.7261, 280.5576, 48.2905>, <-35.5684, 280.9075, 47.9086>, <-33.5229, 279.418, 48.715> }
					triangle { <-34.7261, 280.5576, 48.2905>, <-35.3669, 281.4081, 48.1105>, <-35.5684, 280.9075, 47.9086> }
					triangle { <-32.7891, 279.3218, 49.08725>, <-35.3669, 281.4081, 48.1105>, <-34.7261, 280.5576, 48.2905> }
					triangle { <-39.7187, 279.4167, 52.3255>, <-38.4981, 278.8215, 50.8499>, <-35.5684, 280.9075, 47.9086> }
					triangle { <-38.7839, 280.851, 53.2573>, <-39.3461, 280.9268, 53.8971>, <-39.7187, 279.4167, 52.3255> }
					triangle { <-39.7187, 279.4167, 52.3255>, <-35.5684, 280.9075, 47.9086>, <-38.7839, 280.851, 53.2573> }
					triangle { <-35.3669, 281.4081, 48.1105>, <-38.7839, 280.851, 53.2573>, <-35.5684, 280.9075, 47.9086> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-32.7891, 279.3218, 49.08725>, <-33.07062, 279.9142, 48.5811>, <-34.4246, 280.8885, 48.2013> }
					triangle { <-33.07062, 279.9142, 48.5811>, <-34.9653, 281.5692, 47.7301>, <-34.4246, 280.8885, 48.2013> }
					triangle { <-34.9653, 281.5692, 47.7301>, <-35.3669, 281.4081, 48.1105>, <-34.4246, 280.8885, 48.2013> }
					triangle { <-34.4246, 280.8885, 48.2013>, <-35.3669, 281.4081, 48.1105>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-34.9653, 281.5692, 47.7301>, <-32.525, 285.3504, 49.03095>, <-32.9241, 286.8709, 50.3149> }
					triangle { <-32.9241, 286.8709, 50.3149>, <-33.8618, 286.9194, 52.2227>, <-33.9382, 286.1672, 51.8234> }
					triangle { <-33.9382, 286.1672, 51.8234>, <-34.9653, 281.5692, 47.7301>, <-32.9241, 286.8709, 50.3149> }
					triangle { <-34.9653, 281.5692, 47.7301>, <-33.9382, 286.1672, 51.8234>, <-35.3669, 281.4081, 48.1105> }
					triangle { <-34.7555, 280.6702, 48.6084>, <-33.567, 279.5868, 49.1919>, <-32.7891, 279.3218, 49.08725> }
					triangle { <-34.7555, 280.6702, 48.6084>, <-35.6272, 281.1326, 48.5444>, <-33.567, 279.5868, 49.1919> }
					triangle { <-34.7555, 280.6702, 48.6084>, <-35.3669, 281.4081, 48.1105>, <-35.6272, 281.1326, 48.5444> }
					triangle { <-32.7891, 279.3218, 49.08725>, <-35.3669, 281.4081, 48.1105>, <-34.7555, 280.6702, 48.6084> }
					triangle { <-35.1855, 285.3792, 53.09718>, <-35.3931, 283.4585, 52.5596>, <-35.6272, 281.1326, 48.5444> }
					triangle { <-33.9382, 286.1672, 51.8234>, <-33.8618, 286.9194, 52.2227>, <-35.1855, 285.3792, 53.09718> }
					triangle { <-35.1855, 285.3792, 53.09718>, <-35.6272, 281.1326, 48.5444>, <-33.9382, 286.1672, 51.8234> }
					triangle { <-35.3669, 281.4081, 48.1105>, <-33.9382, 286.1672, 51.8234>, <-35.6272, 281.1326, 48.5444> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-16.3979, 266.7065, 50.922>, <-18.06598, 268.1401, 51.7616>, 0.2999 }
			cylinder { <-18.06598, 268.1401, 51.7616>, <-19.764, 269.5808, 52.5255>, 0.2999 }
			cylinder { <-19.764, 269.5808, 52.5255>, <-21.49, 271.0269, 53.2128>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-21.49, 271.0269, 53.2128>, <-26.8356, 274.2129, 56.553>, 0.2999 }
				cylinder { <-26.8356, 274.2129, 56.553>, <-32.02839, 276.0557, 60.9714>, 0.2999 }
				cylinder { <-32.02839, 276.0557, 60.9714>, <-36.7571, 276.4448, 66.203>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-36.7571, 276.4448, 66.203>, <-36.9731, 276.2581, 66.9807>, <-38.2011, 276.4273, 68.1597> }
					triangle { <-36.9731, 276.2581, 66.9807>, <-38.6622, 276.3289, 69.02898>, <-38.2011, 276.4273, 68.1597> }
					triangle { <-38.6622, 276.3289, 69.02898>, <-39.07178, 276.6353, 68.7638>, <-38.2011, 276.4273, 68.1597> }
					triangle { <-38.2011, 276.4273, 68.1597>, <-39.07178, 276.6353, 68.7638>, <-36.7571, 276.4448, 66.203> }
					triangle { <-38.6622, 276.3289, 69.02898>, <-39.3546, 271.6984, 68.8754>, <-41.01632, 270.5638, 68.6086> }
					triangle { <-41.01632, 270.5638, 68.6086>, <-42.6996, 270.7766, 67.327>, <-42.196, 271.4673, 67.3472> }
					triangle { <-42.196, 271.4673, 67.3472>, <-38.6622, 276.3289, 69.02898>, <-41.01632, 270.5638, 68.6086> }
					triangle { <-38.6622, 276.3289, 69.02898>, <-42.196, 271.4673, 67.3472>, <-39.07178, 276.6353, 68.7638> }
					triangle { <-38.5473, 276.7285, 67.8244>, <-37.4923, 276.7098, 66.4777>, <-36.7571, 276.4448, 66.203> }
					triangle { <-38.5473, 276.7285, 67.8244>, <-39.3545, 276.9313, 68.3584>, <-37.4923, 276.7098, 66.4777> }
					triangle { <-38.5473, 276.7285, 67.8244>, <-39.07178, 276.6353, 68.7638>, <-39.3545, 276.9313, 68.3584> }
					triangle { <-36.7571, 276.4448, 66.203>, <-39.07178, 276.6353, 68.7638>, <-38.5473, 276.7285, 67.8244> }
					triangle { <-43.3817, 272.6217, 66.3175>, <-42.3546, 274.3085, 65.9696>, <-39.3545, 276.9313, 68.3584> }
					triangle { <-42.196, 271.4673, 67.3472>, <-42.6996, 270.7766, 67.327>, <-43.3817, 272.6217, 66.3175> }
					triangle { <-43.3817, 272.6217, 66.3175>, <-39.3545, 276.9313, 68.3584>, <-42.196, 271.4673, 67.3472> }
					triangle { <-39.07178, 276.6353, 68.7638>, <-42.196, 271.4673, 67.3472>, <-39.3545, 276.9313, 68.3584> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-36.7571, 276.4448, 66.203>, <-36.9792, 276.7556, 66.9381>, <-38.2052, 276.759, 68.1313> }
					triangle { <-36.9792, 276.7556, 66.9381>, <-38.6704, 276.9922, 68.9722>, <-38.2052, 276.759, 68.1313> }
					triangle { <-38.6704, 276.9922, 68.9722>, <-39.07178, 276.6353, 68.7638>, <-38.2052, 276.759, 68.1313> }
					triangle { <-38.2052, 276.759, 68.1313>, <-39.07178, 276.6353, 68.7638>, <-36.7571, 276.4448, 66.203> }
					triangle { <-38.6704, 276.9922, 68.9722>, <-35.6822, 274.9587, 71.9522>, <-35.8111, 273.2966, 73.1102> }
					triangle { <-35.8111, 273.2966, 73.1102>, <-36.6429, 271.3719, 72.7572>, <-36.8391, 271.9449, 72.1536> }
					triangle { <-36.8391, 271.9449, 72.1536>, <-38.6704, 276.9922, 68.9722>, <-35.8111, 273.2966, 73.1102> }
					triangle { <-38.6704, 276.9922, 68.9722>, <-36.8391, 271.9449, 72.1536>, <-39.07178, 276.6353, 68.7638> }
					triangle { <-38.5432, 276.3968, 67.8528>, <-37.4862, 276.2123, 66.5203>, <-36.7571, 276.4448, 66.203> }
					triangle { <-38.5432, 276.3968, 67.8528>, <-39.3463, 276.2679, 68.4151>, <-37.4862, 276.2123, 66.5203> }
					triangle { <-38.5432, 276.3968, 67.8528>, <-39.07178, 276.6353, 68.7638>, <-39.3463, 276.2679, 68.4151> }
					triangle { <-36.7571, 276.4448, 66.203>, <-39.07178, 276.6353, 68.7638>, <-38.5432, 276.3968, 67.8528> }
					triangle { <-38.1204, 270.8219, 71.2069>, <-38.6112, 271.82, 69.5383>, <-39.3463, 276.2679, 68.4151> }
					triangle { <-36.8391, 271.9449, 72.1536>, <-36.6429, 271.3719, 72.7572>, <-38.1204, 270.8219, 71.2069> }
					triangle { <-38.1204, 270.8219, 71.2069>, <-39.3463, 276.2679, 68.4151>, <-36.8391, 271.9449, 72.1536> }
					triangle { <-39.07178, 276.6353, 68.7638>, <-36.8391, 271.9449, 72.1536>, <-39.3463, 276.2679, 68.4151> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-36.7571, 276.4448, 66.203>, <-37.3333, 276.8802, 66.6088>, <-38.4412, 276.8421, 67.9118> }
					triangle { <-37.3333, 276.8802, 66.6088>, <-39.1425, 277.1585, 68.5331>, <-38.4412, 276.8421, 67.9118> }
					triangle { <-39.1425, 277.1585, 68.5331>, <-39.07178, 276.6353, 68.7638>, <-38.4412, 276.8421, 67.9118> }
					triangle { <-38.4412, 276.8421, 67.9118>, <-39.07178, 276.6353, 68.7638>, <-36.7571, 276.4448, 66.203> }
					triangle { <-39.1425, 277.1585, 68.5331>, <-36.6624, 280.5204, 70.6525>, <-35.865, 280.6768, 72.5125> }
					triangle { <-35.865, 280.6768, 72.5125>, <-34.8776, 279.2708, 73.7652>, <-35.2432, 278.918, 73.0775> }
					triangle { <-35.2432, 278.918, 73.0775>, <-39.1425, 277.1585, 68.5331>, <-35.865, 280.6768, 72.5125> }
					triangle { <-39.1425, 277.1585, 68.5331>, <-35.2432, 278.918, 73.0775>, <-39.07178, 276.6353, 68.7638> }
					triangle { <-38.3071, 276.3137, 68.07239>, <-37.1321, 276.0877, 66.8496>, <-36.7571, 276.4448, 66.203> }
					triangle { <-38.3071, 276.3137, 68.07239>, <-38.8742, 276.1017, 68.8542>, <-37.1321, 276.0877, 66.8496> }
					triangle { <-38.3071, 276.3137, 68.07239>, <-39.07178, 276.6353, 68.7638>, <-38.8742, 276.1017, 68.8542> }
					triangle { <-36.7571, 276.4448, 66.203>, <-39.07178, 276.6353, 68.7638>, <-38.3071, 276.3137, 68.07239> }
					triangle { <-34.9484, 277.0662, 73.6096>, <-35.4999, 275.9411, 72.04399>, <-38.8742, 276.1017, 68.8542> }
					triangle { <-35.2432, 278.918, 73.0775>, <-34.8776, 279.2708, 73.7652>, <-34.9484, 277.0662, 73.6096> }
					triangle { <-34.9484, 277.0662, 73.6096>, <-38.8742, 276.1017, 68.8542>, <-35.2432, 278.918, 73.0775> }
					triangle { <-39.07178, 276.6353, 68.7638>, <-35.2432, 278.918, 73.0775>, <-38.8742, 276.1017, 68.8542> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-36.7571, 276.4448, 66.203>, <-37.5493, 276.461, 66.4448>, <-38.5852, 276.5626, 67.8024> }
					triangle { <-37.5493, 276.461, 66.4448>, <-39.4304, 276.5994, 68.3144>, <-38.5852, 276.5626, 67.8024> }
					triangle { <-39.4304, 276.5994, 68.3144>, <-39.07178, 276.6353, 68.7638>, <-38.5852, 276.5626, 67.8024> }
					triangle { <-38.5852, 276.5626, 67.8024>, <-39.07178, 276.6353, 68.7638>, <-36.7571, 276.4448, 66.203> }
					triangle { <-39.4304, 276.5994, 68.3144>, <-40.9497, 280.7493, 66.7603>, <-41.104, 282.5739, 67.6359> }
					triangle { <-41.104, 282.5739, 67.6359>, <-39.8268, 283.6309, 68.9674>, <-39.5988, 282.8152, 68.8506> }
					triangle { <-39.5988, 282.8152, 68.8506>, <-39.4304, 276.5994, 68.3144>, <-41.104, 282.5739, 67.6359> }
					triangle { <-39.4304, 276.5994, 68.3144>, <-39.5988, 282.8152, 68.8506>, <-39.07178, 276.6353, 68.7638> }
					triangle { <-38.1631, 276.5932, 68.1817>, <-36.9161, 276.507, 67.0137>, <-36.7571, 276.4448, 66.203> }
					triangle { <-38.1631, 276.5932, 68.1817>, <-38.5862, 276.6608, 69.07294>, <-36.9161, 276.507, 67.0137> }
					triangle { <-38.1631, 276.5932, 68.1817>, <-39.07178, 276.6353, 68.7638>, <-38.5862, 276.6608, 69.07294> }
					triangle { <-36.7571, 276.4448, 66.203>, <-39.07178, 276.6353, 68.7638>, <-38.1631, 276.5932, 68.1817> }
					triangle { <-38.2196, 282.7835, 70.2275>, <-37.2915, 281.0151, 70.04721>, <-38.5862, 276.6608, 69.07294> }
					triangle { <-39.5988, 282.8152, 68.8506>, <-39.8268, 283.6309, 68.9674>, <-38.2196, 282.7835, 70.2275> }
					triangle { <-38.2196, 282.7835, 70.2275>, <-38.5862, 276.6608, 69.07294>, <-39.5988, 282.8152, 68.8506> }
					triangle { <-39.07178, 276.6353, 68.7638>, <-39.5988, 282.8152, 68.8506>, <-38.5862, 276.6608, 69.07294> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-36.7571, 276.4448, 66.203>, <-37.3233, 276.0706, 66.6781>, <-38.4346, 276.3023, 67.958> }
					triangle { <-37.3233, 276.0706, 66.6781>, <-39.1291, 276.079, 68.6255>, <-38.4346, 276.3023, 67.958> }
					triangle { <-39.1291, 276.079, 68.6255>, <-39.07178, 276.6353, 68.7638>, <-38.4346, 276.3023, 67.958> }
					triangle { <-38.4346, 276.3023, 67.958>, <-39.07178, 276.6353, 68.7638>, <-36.7571, 276.4448, 66.203> }
					triangle { <-39.1291, 276.079, 68.6255>, <-42.6387, 275.2147, 65.6454>, <-44.3357, 276.2294, 65.1868> }
					triangle { <-44.3357, 276.2294, 65.1868>, <-44.734, 278.302, 64.9283>, <-43.9607, 278.1409, 65.2557> }
					triangle { <-43.9607, 278.1409, 65.2557>, <-39.1291, 276.079, 68.6255>, <-44.3357, 276.2294, 65.1868> }
					triangle { <-39.1291, 276.079, 68.6255>, <-43.9607, 278.1409, 65.2557>, <-39.07178, 276.6353, 68.7638> }
					triangle { <-38.3138, 276.8535, 68.0262>, <-37.1421, 276.8973, 66.7804>, <-36.7571, 276.4448, 66.203> }
					triangle { <-38.3138, 276.8535, 68.0262>, <-38.8875, 277.1812, 68.7618>, <-37.1421, 276.8973, 66.7804> }
					triangle { <-38.3138, 276.8535, 68.0262>, <-39.07178, 276.6353, 68.7638>, <-38.8875, 277.1812, 68.7618> }
					triangle { <-36.7571, 276.4448, 66.203>, <-39.07178, 276.6353, 68.7638>, <-38.3138, 276.8535, 68.0262> }
					triangle { <-43.5104, 279.9952, 65.6527>, <-41.5919, 279.9909, 66.2363>, <-38.8875, 277.1812, 68.7618> }
					triangle { <-43.9607, 278.1409, 65.2557>, <-44.734, 278.302, 64.9283>, <-43.5104, 279.9952, 65.6527> }
					triangle { <-43.5104, 279.9952, 65.6527>, <-38.8875, 277.1812, 68.7618>, <-43.9607, 278.1409, 65.2557> }
					triangle { <-39.07178, 276.6353, 68.7638>, <-43.9607, 278.1409, 65.2557>, <-38.8875, 277.1812, 68.7618> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-21.49, 271.0269, 53.2128>, <-23.2277, 272.4255, 53.9656>, 0.2999 }
			cylinder { <-23.2277, 272.4255, 53.9656>, <-24.975, 273.7751, 54.783>, 0.2999 }
			cylinder { <-24.975, 273.7751, 54.783>, <-26.7298, 275.0739, 55.664>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-26.7298, 275.0739, 55.664>, <-30.9371, 280.2812, 57.9148>, 0.2999 }
				cylinder { <-30.9371, 280.2812, 57.9148>, <-33.8349, 286.4872, 59.6386>, 0.2999 }
				cylinder { <-33.8349, 286.4872, 59.6386>, <-35.2496, 293.3199, 60.7319>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-35.2496, 293.3199, 60.7319>, <-35.1619, 294.1419, 60.6785>, <-35.7251, 295.6407, 61.2811> }
					triangle { <-35.1619, 294.1419, 60.6785>, <-35.7969, 296.6212, 61.3882>, <-35.7251, 295.6407, 61.2811> }
					triangle { <-35.7969, 296.6212, 61.3882>, <-36.2004, 296.4764, 61.7731>, <-35.7251, 295.6407, 61.2811> }
					triangle { <-35.7251, 295.6407, 61.2811>, <-36.2004, 296.4764, 61.7731>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-35.7969, 296.6212, 61.3882>, <-31.5706, 297.3802, 63.2609>, <-30.9645, 297.8789, 65.1327> }
					triangle { <-30.9645, 297.8789, 65.1327>, <-31.6164, 297.2549, 67.0581>, <-32.1293, 296.9984, 66.4238> }
					triangle { <-32.1293, 296.9984, 66.4238>, <-35.7969, 296.6212, 61.3882>, <-30.9645, 297.8789, 65.1327> }
					triangle { <-35.7969, 296.6212, 61.3882>, <-32.1293, 296.9984, 66.4238>, <-36.2004, 296.4764, 61.7731> }
					triangle { <-36.1026, 295.4095, 61.6375>, <-35.7281, 293.7951, 61.2131>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-36.1026, 295.4095, 61.6375>, <-36.5518, 296.1587, 62.1009>, <-35.7281, 293.7951, 61.2131> }
					triangle { <-36.1026, 295.4095, 61.6375>, <-36.2004, 296.4764, 61.7731>, <-36.5518, 296.1587, 62.1009> }
					triangle { <-35.2496, 293.3199, 60.7319>, <-36.2004, 296.4764, 61.7731>, <-36.1026, 295.4095, 61.6375> }
					triangle { <-33.5437, 296.2987, 67.5679>, <-34.8419, 295.376, 66.3494>, <-36.5518, 296.1587, 62.1009> }
					triangle { <-32.1293, 296.9984, 66.4238>, <-31.6164, 297.2549, 67.0581>, <-33.5437, 296.2987, 67.5679> }
					triangle { <-33.5437, 296.2987, 67.5679>, <-36.5518, 296.1587, 62.1009>, <-32.1293, 296.9984, 66.4238> }
					triangle { <-36.2004, 296.4764, 61.7731>, <-32.1293, 296.9984, 66.4238>, <-36.5518, 296.1587, 62.1009> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-35.2496, 293.3199, 60.7319>, <-35.6375, 294.0341, 60.5713>, <-36.04224, 295.5688, 61.2096> }
					triangle { <-35.6375, 294.0341, 60.5713>, <-36.431, 296.4773, 61.2451>, <-36.04224, 295.5688, 61.2096> }
					triangle { <-36.431, 296.4773, 61.2451>, <-36.2004, 296.4764, 61.7731>, <-36.04224, 295.5688, 61.2096> }
					triangle { <-36.04224, 295.5688, 61.2096>, <-36.2004, 296.4764, 61.7731>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-36.431, 296.4773, 61.2451>, <-33.7167, 298.4725, 57.9899>, <-32.2073, 299.8252, 58.09757> }
					triangle { <-32.2073, 299.8252, 58.09757>, <-30.5999, 300.0645, 59.4688>, <-31.1836, 299.4937, 59.7228> }
					triangle { <-31.1836, 299.4937, 59.7228>, <-36.431, 296.4773, 61.2451>, <-32.2073, 299.8252, 58.09757> }
					triangle { <-36.431, 296.4773, 61.2451>, <-31.1836, 299.4937, 59.7228>, <-36.2004, 296.4764, 61.7731> }
					triangle { <-35.7855, 295.4814, 61.709>, <-35.2524, 293.9029, 61.3204>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-35.7855, 295.4814, 61.709>, <-35.9176, 296.3025, 62.244>, <-35.2524, 293.9029, 61.3204> }
					triangle { <-35.7855, 295.4814, 61.709>, <-36.2004, 296.4764, 61.7731>, <-35.9176, 296.3025, 62.244> }
					triangle { <-35.2496, 293.3199, 60.7319>, <-36.2004, 296.4764, 61.7731>, <-35.7855, 295.4814, 61.709> }
					triangle { <-30.4532, 299.2278, 61.5102>, <-31.4921, 297.7148, 62.3182>, <-35.9176, 296.3025, 62.244> }
					triangle { <-31.1836, 299.4937, 59.7228>, <-30.5999, 300.0645, 59.4688>, <-30.4532, 299.2278, 61.5102> }
					triangle { <-30.4532, 299.2278, 61.5102>, <-35.9176, 296.3025, 62.244>, <-31.1836, 299.4937, 59.7228> }
					triangle { <-36.2004, 296.4764, 61.7731>, <-31.1836, 299.4937, 59.7228>, <-35.9176, 296.3025, 62.244> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-35.2496, 293.3199, 60.7319>, <-35.8488, 293.8362, 60.9781>, <-36.1831, 295.4369, 61.4808> }
					triangle { <-35.8488, 293.8362, 60.9781>, <-36.7128, 296.2135, 61.7876>, <-36.1831, 295.4369, 61.4808> }
					triangle { <-36.7128, 296.2135, 61.7876>, <-36.2004, 296.4764, 61.7731>, <-36.1831, 295.4369, 61.4808> }
					triangle { <-36.1831, 295.4369, 61.4808>, <-36.2004, 296.4764, 61.7731>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-36.7128, 296.2135, 61.7876>, <-39.272, 296.8248, 57.9118>, <-39.253, 298.2431, 56.4599> }
					triangle { <-39.253, 298.2431, 56.4599>, <-37.6642, 299.2547, 55.4732>, <-37.4102, 298.7969, 56.1493> }
					triangle { <-37.4102, 298.7969, 56.1493>, <-36.7128, 296.2135, 61.7876>, <-39.253, 298.2431, 56.4599> }
					triangle { <-36.7128, 296.2135, 61.7876>, <-37.4102, 298.7969, 56.1493>, <-36.2004, 296.4764, 61.7731> }
					triangle { <-35.6446, 295.6133, 61.4378>, <-35.04114, 294.1008, 60.9135>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-35.6446, 295.6133, 61.4378>, <-35.6358, 296.5663, 61.7015>, <-35.04114, 294.1008, 60.9135> }
					triangle { <-35.6446, 295.6133, 61.4378>, <-36.2004, 296.4764, 61.7731>, <-35.6358, 296.5663, 61.7015> }
					triangle { <-35.2496, 293.3199, 60.7319>, <-36.2004, 296.4764, 61.7731>, <-35.6446, 295.6133, 61.4378> }
					triangle { <-35.5733, 299.4485, 56.1657>, <-34.6051, 298.3537, 57.5387>, <-35.6358, 296.5663, 61.7015> }
					triangle { <-37.4102, 298.7969, 56.1493>, <-37.6642, 299.2547, 55.4732>, <-35.5733, 299.4485, 56.1657> }
					triangle { <-35.5733, 299.4485, 56.1657>, <-35.6358, 296.5663, 61.7015>, <-37.4102, 298.7969, 56.1493> }
					triangle { <-36.2004, 296.4764, 61.7731>, <-37.4102, 298.7969, 56.1493>, <-35.6358, 296.5663, 61.7015> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-35.2496, 293.3199, 60.7319>, <-35.5058, 293.8199, 61.3406>, <-35.9544, 295.4261, 61.7225> }
					triangle { <-35.5058, 293.8199, 61.3406>, <-36.2555, 296.1918, 62.271>, <-35.9544, 295.4261, 61.7225> }
					triangle { <-36.2555, 296.1918, 62.271>, <-36.2004, 296.4764, 61.7731>, <-35.9544, 295.4261, 61.7225> }
					triangle { <-35.9544, 295.4261, 61.7225>, <-36.2004, 296.4764, 61.7731>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-36.2555, 296.1918, 62.271>, <-40.6111, 294.6989, 63.1339>, <-42.4304, 295.3043, 62.4678> }
					triangle { <-42.4304, 295.3043, 62.4678>, <-43.1125, 295.937, 60.5558>, <-42.2622, 295.8645, 60.6085> }
					triangle { <-42.2622, 295.8645, 60.6085>, <-36.2555, 296.1918, 62.271>, <-42.4304, 295.3043, 62.4678> }
					triangle { <-36.2555, 296.1918, 62.271>, <-42.2622, 295.8645, 60.6085>, <-36.2004, 296.4764, 61.7731> }
					triangle { <-35.8733, 295.6242, 61.1961>, <-35.3841, 294.1171, 60.551>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-35.8733, 295.6242, 61.1961>, <-36.09324, 296.588, 61.2181>, <-35.3841, 294.1171, 60.551> }
					triangle { <-35.8733, 295.6242, 61.1961>, <-36.2004, 296.4764, 61.7731>, <-36.09324, 296.588, 61.2181> }
					triangle { <-35.2496, 293.3199, 60.7319>, <-36.2004, 296.4764, 61.7731>, <-35.8733, 295.6242, 61.1961> }
					triangle { <-41.8759, 296.6579, 58.8705>, <-39.9079, 296.4157, 58.5715>, <-36.09324, 296.588, 61.2181> }
					triangle { <-42.2622, 295.8645, 60.6085>, <-43.1125, 295.937, 60.5558>, <-41.8759, 296.6579, 58.8705> }
					triangle { <-41.8759, 296.6579, 58.8705>, <-36.09324, 296.588, 61.2181>, <-42.2622, 295.8645, 60.6085> }
					triangle { <-36.2004, 296.4764, 61.7731>, <-42.2622, 295.8645, 60.6085>, <-36.09324, 296.588, 61.2181> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-35.2496, 293.3199, 60.7319>, <-35.07489, 294.0117, 61.1527>, <-35.6671, 295.554, 61.5972> }
					triangle { <-35.07489, 294.0117, 61.1527>, <-35.6808, 296.4476, 62.02044>, <-35.6671, 295.554, 61.5972> }
					triangle { <-35.6808, 296.4476, 62.02044>, <-36.2004, 296.4764, 61.7731>, <-35.6671, 295.554, 61.5972> }
					triangle { <-35.6671, 295.554, 61.5972>, <-36.2004, 296.4764, 61.7731>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-35.6808, 296.4476, 62.02044>, <-35.7795, 295.0473, 66.4897>, <-37.2304, 295.0758, 67.9088> }
					triangle { <-37.2304, 295.0758, 67.9088>, <-39.3183, 294.6824, 67.8237>, <-38.9491, 294.7362, 67.05441> }
					triangle { <-38.9491, 294.7362, 67.05441>, <-35.6808, 296.4476, 62.02044>, <-37.2304, 295.0758, 67.9088> }
					triangle { <-35.6808, 296.4476, 62.02044>, <-38.9491, 294.7362, 67.05441>, <-36.2004, 296.4764, 61.7731> }
					triangle { <-36.1606, 295.4963, 61.3214>, <-35.8151, 293.9253, 60.7389>, <-35.2496, 293.3199, 60.7319> }
					triangle { <-36.1606, 295.4963, 61.3214>, <-36.6678, 296.3322, 61.4687>, <-35.8151, 293.9253, 60.7389> }
					triangle { <-36.1606, 295.4963, 61.3214>, <-36.2004, 296.4764, 61.7731>, <-36.6678, 296.3322, 61.4687> }
					triangle { <-35.2496, 293.3199, 60.7319>, <-36.2004, 296.4764, 61.7731>, <-36.1606, 295.4963, 61.3214> }
					triangle { <-40.6026, 294.6818, 66.02386>, <-40.05648, 294.5476, 64.09907>, <-36.6678, 296.3322, 61.4687> }
					triangle { <-38.9491, 294.7362, 67.05441>, <-39.3183, 294.6824, 67.8237>, <-40.6026, 294.6818, 66.02386> }
					triangle { <-40.6026, 294.6818, 66.02386>, <-36.6678, 296.3322, 61.4687>, <-38.9491, 294.7362, 67.05441> }
					triangle { <-36.2004, 296.4764, 61.7731>, <-38.9491, 294.7362, 67.05441>, <-36.6678, 296.3322, 61.4687> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-26.7298, 275.0739, 55.664>, <-28.4425, 276.4401, 56.526>, 0.2999 }
			cylinder { <-28.4425, 276.4401, 56.526>, <-30.1109, 277.8719, 57.3679>, 0.2999 }
			cylinder { <-30.1109, 277.8719, 57.3679>, <-31.733, 279.3677, 58.1887>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-31.733, 279.3677, 58.1887>, <-37.6853, 282.8083, 59.8059>, 0.2999 }
				cylinder { <-37.6853, 282.8083, 59.8059>, <-44.3668, 284.9956, 60.4809>, 0.2999 }
				cylinder { <-44.3668, 284.9956, 60.4809>, <-51.3771, 285.7988, 60.1732>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-51.3771, 285.7988, 60.1732>, <-52.063, 285.4001, 60.1355>, <-53.6955, 285.5577, 60.1159> }
					triangle { <-52.063, 285.4001, 60.1355>, <-54.6067, 285.298, 60.083>, <-53.6955, 285.5577, 60.1159> }
					triangle { <-54.6067, 285.298, 60.083>, <-54.6909, 285.8429, 60.116>, <-53.6955, 285.5577, 60.1159> }
					triangle { <-53.6955, 285.5577, 60.1159>, <-54.6909, 285.8429, 60.116>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-54.6067, 285.298, 60.083>, <-54.6464, 283.6998, 55.8856>, <-55.4265, 284.3607, 54.2297> }
					triangle { <-55.4265, 284.3607, 54.2297>, <-55.5695, 286.2329, 53.4357>, <-55.3105, 286.2258, 54.2135> }
					triangle { <-55.3105, 286.2258, 54.2135>, <-54.6067, 285.298, 60.083>, <-55.4265, 284.3607, 54.2297> }
					triangle { <-54.6067, 285.298, 60.083>, <-55.3105, 286.2258, 54.2135>, <-54.6909, 285.8429, 60.116> }
					triangle { <-53.6889, 286.1015, 60.1505>, <-52.05304, 286.2156, 60.1874>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-53.6889, 286.1015, 60.1505>, <-54.5934, 286.3854, 60.1521>, <-52.05304, 286.2156, 60.1874> }
					triangle { <-53.6889, 286.1015, 60.1505>, <-54.6909, 285.8429, 60.116>, <-54.5934, 286.3854, 60.1521> }
					triangle { <-51.3771, 285.7988, 60.1732>, <-54.6909, 285.8429, 60.116>, <-53.6889, 286.1015, 60.1505> }
					triangle { <-55.3811, 288.0761, 54.4659>, <-54.5888, 288.4121, 56.1852>, <-54.5934, 286.3854, 60.1521> }
					triangle { <-55.3105, 286.2258, 54.2135>, <-55.5695, 286.2329, 53.4357>, <-55.3811, 288.0761, 54.4659> }
					triangle { <-55.3811, 288.0761, 54.4659>, <-54.5934, 286.3854, 60.1521>, <-55.3105, 286.2258, 54.2135> }
					triangle { <-54.6909, 285.8429, 60.116>, <-55.3105, 286.2258, 54.2135>, <-54.5934, 286.3854, 60.1521> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-51.3771, 285.7988, 60.1732>, <-52.0666, 285.6554, 60.5405>, <-53.6979, 285.728, 60.3859> }
					triangle { <-52.0666, 285.6554, 60.5405>, <-54.6115, 285.6384, 60.6229>, <-53.6979, 285.728, 60.3859> }
					triangle { <-54.6115, 285.6384, 60.6229>, <-54.6909, 285.8429, 60.116>, <-53.6979, 285.728, 60.3859> }
					triangle { <-53.6979, 285.728, 60.3859>, <-54.6909, 285.8429, 60.116>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-54.6115, 285.6384, 60.6229>, <-54.7655, 281.1541, 60.8229>, <-55.5811, 279.8096, 59.6763> }
					triangle { <-55.5811, 279.8096, 59.6763>, <-55.73, 279.6472, 57.6495>, <-55.4521, 280.3766, 57.9002> }
					triangle { <-55.4521, 280.3766, 57.9002>, <-54.6115, 285.6384, 60.6229>, <-55.5811, 279.8096, 59.6763> }
					triangle { <-54.6115, 285.6384, 60.6229>, <-55.4521, 280.3766, 57.9002>, <-54.6909, 285.8429, 60.116> }
					triangle { <-53.6865, 285.9312, 59.8805>, <-52.04944, 285.9603, 59.7824>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-53.6865, 285.9312, 59.8805>, <-54.5887, 286.045, 59.6121>, <-52.04944, 285.9603, 59.7824> }
					triangle { <-53.6865, 285.9312, 59.8805>, <-54.6909, 285.8429, 60.116>, <-54.5887, 286.045, 59.6121> }
					triangle { <-51.3771, 285.7988, 60.1732>, <-54.6909, 285.8429, 60.116>, <-53.6865, 285.9312, 59.8805> }
					triangle { <-55.503, 281.1986, 56.2227>, <-54.6664, 282.9157, 56.4427>, <-54.5887, 286.045, 59.6121> }
					triangle { <-55.4521, 280.3766, 57.9002>, <-55.73, 279.6472, 57.6495>, <-55.503, 281.1986, 56.2227> }
					triangle { <-55.503, 281.1986, 56.2227>, <-54.5887, 286.045, 59.6121>, <-55.4521, 280.3766, 57.9002> }
					triangle { <-54.6909, 285.8429, 60.116>, <-55.4521, 280.3766, 57.9002>, <-54.5887, 286.045, 59.6121> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-51.3771, 285.7988, 60.1732>, <-52.05842, 286.12, 60.4252>, <-53.6925, 286.0377, 60.309> }
					triangle { <-52.05842, 286.12, 60.4252>, <-54.6006, 286.2579, 60.4692>, <-53.6925, 286.0377, 60.309> }
					triangle { <-54.6006, 286.2579, 60.4692>, <-54.6909, 285.8429, 60.116>, <-53.6925, 286.0377, 60.309> }
					triangle { <-53.6925, 286.0377, 60.309>, <-54.6909, 285.8429, 60.116>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-54.6006, 286.2579, 60.4692>, <-54.7822, 285.0444, 64.7898>, <-55.6354, 283.5551, 65.707> }
					triangle { <-55.6354, 283.5551, 65.707>, <-55.835, 281.5842, 65.2252>, <-55.5458, 282.0439, 64.6112> }
					triangle { <-55.5458, 282.0439, 64.6112>, <-54.6006, 286.2579, 60.4692>, <-55.6354, 283.5551, 65.707> }
					triangle { <-54.6006, 286.2579, 60.4692>, <-55.5458, 282.0439, 64.6112>, <-54.6909, 285.8429, 60.116> }
					triangle { <-53.6919, 285.6215, 59.9574>, <-52.05762, 285.4957, 59.8977>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-53.6919, 285.6215, 59.9574>, <-54.5996, 285.4255, 59.7659>, <-52.05762, 285.4957, 59.8977> }
					triangle { <-53.6919, 285.6215, 59.9574>, <-54.6909, 285.8429, 60.116>, <-54.5996, 285.4255, 59.7659> }
					triangle { <-51.3771, 285.7988, 60.1732>, <-54.6909, 285.8429, 60.116>, <-53.6919, 285.6215, 59.9574> }
					triangle { <-55.6318, 280.711, 63.3041>, <-54.7776, 281.4373, 61.7422>, <-54.5996, 285.4255, 59.7659> }
					triangle { <-55.5458, 282.0439, 64.6112>, <-55.835, 281.5842, 65.2252>, <-55.6318, 280.711, 63.3041> }
					triangle { <-55.6318, 280.711, 63.3041>, <-54.5996, 285.4255, 59.7659>, <-55.5458, 282.0439, 64.6112> }
					triangle { <-54.6909, 285.8429, 60.116>, <-55.5458, 282.0439, 64.6112>, <-54.5996, 285.4255, 59.7659> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-51.3771, 285.7988, 60.1732>, <-52.04969, 286.1561, 59.9478>, <-53.6866, 286.0618, 59.9908> }
					triangle { <-52.04969, 286.1561, 59.9478>, <-54.589, 286.3061, 59.8327>, <-53.6866, 286.0618, 59.9908> }
					triangle { <-54.589, 286.3061, 59.8327>, <-54.6909, 285.8429, 60.116>, <-53.6866, 286.0618, 59.9908> }
					triangle { <-53.6866, 286.0618, 59.9908>, <-54.6909, 285.8429, 60.116>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-54.589, 286.3061, 59.8327>, <-54.6735, 290.0308, 62.3413>, <-55.5148, 290.4558, 64.04395> }
					triangle { <-55.5148, 290.4558, 64.04395>, <-55.7404, 289.3851, 65.7641>, <-55.463, 288.9392, 65.1346> }
					triangle { <-55.463, 288.9392, 65.1346>, <-54.589, 286.3061, 59.8327>, <-55.5148, 290.4558, 64.04395> }
					triangle { <-54.589, 286.3061, 59.8327>, <-55.463, 288.9392, 65.1346>, <-54.6909, 285.8429, 60.116> }
					triangle { <-53.6977, 285.5974, 60.2756>, <-52.06635, 285.4596, 60.375>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-53.6977, 285.5974, 60.2756>, <-54.6112, 285.3773, 60.4023>, <-52.06635, 285.4596, 60.375> }
					triangle { <-53.6977, 285.5974, 60.2756>, <-54.6909, 285.8429, 60.116>, <-54.6112, 285.3773, 60.4023> }
					triangle { <-51.3771, 285.7988, 60.1732>, <-54.6909, 285.8429, 60.116>, <-53.6977, 285.5974, 60.2756> }
					triangle { <-55.5906, 287.2825, 65.99>, <-54.7698, 286.0062, 64.8095>, <-54.6112, 285.3773, 60.4023> }
					triangle { <-55.463, 288.9392, 65.1346>, <-55.7404, 289.3851, 65.7641>, <-55.5906, 287.2825, 65.99> }
					triangle { <-55.5906, 287.2825, 65.99>, <-54.6112, 285.3773, 60.4023>, <-55.463, 288.9392, 65.1346> }
					triangle { <-54.6909, 285.8429, 60.116>, <-55.463, 288.9392, 65.1346>, <-54.6112, 285.3773, 60.4023> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-51.3771, 285.7988, 60.1732>, <-52.05257, 285.7045, 59.7661>, <-53.6886, 285.7607, 59.8697> }
					triangle { <-52.05257, 285.7045, 59.7661>, <-54.5928, 285.7039, 59.5904>, <-53.6886, 285.7607, 59.8697> }
					triangle { <-54.5928, 285.7039, 59.5904>, <-54.6909, 285.8429, 60.116>, <-53.6886, 285.7607, 59.8697> }
					triangle { <-53.6886, 285.7607, 59.8697>, <-54.6909, 285.8429, 60.116>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-54.5928, 285.7039, 59.5904>, <-54.5883, 289.1873, 56.7551>, <-55.3837, 290.9612, 56.8435> }
					triangle { <-55.3837, 290.9612, 56.8435>, <-55.5738, 292.3016, 58.3678>, <-55.3154, 291.5627, 58.6115> }
					triangle { <-55.3154, 291.5627, 58.6115>, <-54.5928, 285.7039, 59.5904>, <-55.3837, 290.9612, 56.8435> }
					triangle { <-54.5928, 285.7039, 59.5904>, <-55.3154, 291.5627, 58.6115>, <-54.6909, 285.8429, 60.116> }
					triangle { <-53.6958, 285.8985, 60.3968>, <-52.06347, 285.9112, 60.5568>, <-51.3771, 285.7988, 60.1732> }
					triangle { <-53.6958, 285.8985, 60.3968>, <-54.6074, 285.9796, 60.6446>, <-52.06347, 285.9112, 60.5568> }
					triangle { <-53.6958, 285.8985, 60.3968>, <-54.6909, 285.8429, 60.116>, <-54.6074, 285.9796, 60.6446> }
					triangle { <-51.3771, 285.7988, 60.1732>, <-54.6909, 285.8429, 60.116>, <-53.6958, 285.8985, 60.3968> }
					triangle { <-55.4333, 291.9032, 60.4453>, <-54.6513, 290.382, 61.3232>, <-54.6074, 285.9796, 60.6446> }
					triangle { <-55.3154, 291.5627, 58.6115>, <-55.5738, 292.3016, 58.3678>, <-55.4333, 291.9032, 60.4453> }
					triangle { <-55.4333, 291.9032, 60.4453>, <-54.6074, 285.9796, 60.6446>, <-55.3154, 291.5627, 58.6115> }
					triangle { <-54.6909, 285.8429, 60.116>, <-55.3154, 291.5627, 58.6115>, <-54.6074, 285.9796, 60.6446> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-6.07516, 258.4211, 46.01889>, <-6.1001, 260.7273, 46.4915>, 0.2999 }
			cylinder { <-6.1001, 260.7273, 46.4915>, <-6.2029, 263.0262, 46.9885>, 0.2999 }
			cylinder { <-6.2029, 263.0262, 46.9885>, <-6.3832, 265.3151, 47.509>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-6.3832, 265.3151, 47.509>, <-4.9006, 266.732, 48.6653>, 0.2999 }
			cylinder { <-4.9006, 266.732, 48.6653>, <-3.3656, 268.0865, 49.8278>, 0.2999 }
			cylinder { <-3.3656, 268.0865, 49.8278>, <-1.7799, 269.377, 50.9953>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.7799, 269.377, 50.9953>, <2.6078, 274.4183, 53.2787>, 0.2999 }
				cylinder { <2.6078, 274.4183, 53.2787>, <6.3636, 280.3273, 54.2066>, 0.2999 }
				cylinder { <6.3636, 280.3273, 54.2066>, <9.2623, 286.7496, 53.7233>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <9.2623, 286.7496, 53.7233>, <9.1412, 287.5352, 53.4898>, <9.8542, 289.0887, 53.419> }
					triangle { <9.1412, 287.5352, 53.4898>, <9.9375, 290.0551, 53.2271>, <9.8542, 289.0887, 53.419> }
					triangle { <9.9375, 290.0551, 53.2271>, <10.46, 289.9818, 53.4586>, <9.8542, 289.0887, 53.419> }
					triangle { <9.8542, 289.0887, 53.419>, <10.46, 289.9818, 53.4586>, <9.2623, 286.7496, 53.7233> }
					triangle { <9.9375, 290.0551, 53.2271>, <9.8784, 289.7953, 48.5501>, <11.3133, 290.0598, 47.1391> }
					triangle { <11.3133, 290.0598, 47.1391>, <13.3624, 289.497, 47.06398>, <13.00619, 289.3881, 47.8336> }
					triangle { <13.00619, 289.3881, 47.8336>, <9.9375, 290.0551, 53.2271>, <11.3133, 290.0598, 47.1391> }
					triangle { <9.9375, 290.0551, 53.2271>, <13.00619, 289.3881, 47.8336>, <10.46, 289.9818, 53.4586> }
					triangle { <10.3439, 288.9268, 53.6577>, <9.8756, 287.2924, 53.8479>, <9.2623, 286.7496, 53.7233> }
					triangle { <10.3439, 288.9268, 53.6577>, <10.9168, 289.7314, 53.7045>, <9.8756, 287.2924, 53.8479> }
					triangle { <10.3439, 288.9268, 53.6577>, <10.46, 289.9818, 53.4586>, <10.9168, 289.7314, 53.7045> }
					triangle { <9.2623, 286.7496, 53.7233>, <10.46, 289.9818, 53.4586>, <10.3439, 288.9268, 53.6577> }
					triangle { <14.6592, 288.9536, 48.7704>, <14.122, 288.3923, 50.6191>, <10.9168, 289.7314, 53.7045> }
					triangle { <13.00619, 289.3881, 47.8336>, <13.3624, 289.497, 47.06398>, <14.6592, 288.9536, 48.7704> }
					triangle { <14.6592, 288.9536, 48.7704>, <10.9168, 289.7314, 53.7045>, <13.00619, 289.3881, 47.8336> }
					triangle { <10.46, 289.9818, 53.4586>, <13.00619, 289.3881, 47.8336>, <10.9168, 289.7314, 53.7045> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <9.2623, 286.7496, 53.7233>, <9.2431, 287.5375, 53.9787>, <9.9222, 289.0902, 53.7449> }
					triangle { <9.2431, 287.5375, 53.9787>, <10.07346, 290.0582, 53.8789>, <9.9222, 289.0902, 53.7449> }
					triangle { <10.07346, 290.0582, 53.8789>, <10.46, 289.9818, 53.4586>, <9.9222, 289.0902, 53.7449> }
					triangle { <9.9222, 289.0902, 53.7449>, <10.46, 289.9818, 53.4586>, <9.2623, 286.7496, 53.7233> }
					triangle { <10.07346, 290.0582, 53.8789>, <5.9065, 291.5802, 52.3739>, <5.3259, 292.57, 50.6996> }
					triangle { <5.3259, 292.57, 50.6996>, <5.906, 292.3907, 48.6618>, <6.4021, 291.947, 49.1986> }
					triangle { <6.4021, 291.947, 49.1986>, <10.07346, 290.0582, 53.8789>, <5.3259, 292.57, 50.6996> }
					triangle { <10.07346, 290.0582, 53.8789>, <6.4021, 291.947, 49.1986>, <10.46, 289.9818, 53.4586> }
					triangle { <10.2759, 288.9253, 53.3318>, <9.7737, 287.2901, 53.3591>, <9.2623, 286.7496, 53.7233> }
					triangle { <10.2759, 288.9253, 53.3318>, <10.7809, 289.7283, 53.0528>, <9.7737, 287.2901, 53.3591> }
					triangle { <10.2759, 288.9253, 53.3318>, <10.46, 289.9818, 53.4586>, <10.7809, 289.7283, 53.0528> }
					triangle { <9.2623, 286.7496, 53.7233>, <10.46, 289.9818, 53.4586>, <10.2759, 288.9253, 53.3318> }
					triangle { <7.7432, 291.4431, 47.8771>, <8.9724, 290.151, 48.7941>, <10.7809, 289.7283, 53.0528> }
					triangle { <6.4021, 291.947, 49.1986>, <5.906, 292.3907, 48.6618>, <7.7432, 291.4431, 47.8771> }
					triangle { <7.7432, 291.4431, 47.8771>, <10.7809, 289.7283, 53.0528>, <6.4021, 291.947, 49.1986> }
					triangle { <10.46, 289.9818, 53.4586>, <6.4021, 291.947, 49.1986>, <10.7809, 289.7283, 53.0528> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <9.2623, 286.7496, 53.7233>, <9.7092, 287.37, 54.04232>, <10.2329, 288.9785, 53.7873> }
					triangle { <9.7092, 287.37, 54.04232>, <10.6949, 289.8348, 53.9637>, <10.2329, 288.9785, 53.7873> }
					triangle { <10.6949, 289.8348, 53.9637>, <10.46, 289.9818, 53.4586>, <10.2329, 288.9785, 53.7873> }
					triangle { <10.2329, 288.9785, 53.7873>, <10.46, 289.9818, 53.4586>, <9.2623, 286.7496, 53.7233> }
					triangle { <10.6949, 289.8348, 53.9637>, <8.1849, 291.1711, 57.6865>, <6.7911, 292.6215, 57.9575> }
					triangle { <6.7911, 292.6215, 57.9575>, <5.196, 293.315, 56.7344>, <5.7283, 292.7808, 56.3314> }
					triangle { <5.7283, 292.7808, 56.3314>, <10.6949, 289.8348, 53.9637>, <6.7911, 292.6215, 57.9575> }
					triangle { <10.6949, 289.8348, 53.9637>, <5.7283, 292.7808, 56.3314>, <10.46, 289.9818, 53.4586> }
					triangle { <9.9652, 289.0369, 53.2894>, <9.3076, 287.4576, 53.2955>, <9.2623, 286.7496, 53.7233> }
					triangle { <9.9652, 289.0369, 53.2894>, <10.1595, 289.9517, 52.9679>, <9.3076, 287.4576, 53.2955> }
					triangle { <9.9652, 289.0369, 53.2894>, <10.46, 289.9818, 53.4586>, <10.1595, 289.9517, 52.9679> }
					triangle { <9.2623, 286.7496, 53.7233>, <10.46, 289.9818, 53.4586>, <9.9652, 289.0369, 53.2894> }
					triangle { <4.9617, 293.0208, 54.5555>, <5.8647, 291.6775, 53.3717>, <10.1595, 289.9517, 52.9679> }
					triangle { <5.7283, 292.7808, 56.3314>, <5.196, 293.315, 56.7344>, <4.9617, 293.0208, 54.5555> }
					triangle { <4.9617, 293.0208, 54.5555>, <10.1595, 289.9517, 52.9679>, <5.7283, 292.7808, 56.3314> }
					triangle { <10.46, 289.9818, 53.4586>, <5.7283, 292.7808, 56.3314>, <10.1595, 289.9517, 52.9679> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <9.2623, 286.7496, 53.7233>, <9.8997, 287.2626, 53.5933>, <10.3599, 288.907, 53.488> }
					triangle { <9.8997, 287.2626, 53.5933>, <10.9489, 289.6917, 53.3651>, <10.3599, 288.907, 53.488> }
					triangle { <10.9489, 289.6917, 53.3651>, <10.46, 289.9818, 53.4586>, <10.3599, 288.907, 53.488> }
					triangle { <10.3599, 288.907, 53.488>, <10.46, 289.9818, 53.4586>, <9.2623, 286.7496, 53.7233> }
					triangle { <10.9489, 289.6917, 53.3651>, <13.5862, 289.1295, 57.1957>, <13.6977, 290.1436, 58.9504> }
					triangle { <13.6977, 290.1436, 58.9504>, <12.2069, 291.001, 60.2009>, <11.9098, 290.745, 59.4412> }
					triangle { <11.9098, 290.745, 59.4412>, <10.9489, 289.6917, 53.3651>, <13.6977, 290.1436, 58.9504> }
					triangle { <10.9489, 289.6917, 53.3651>, <11.9098, 290.745, 59.4412>, <10.46, 289.9818, 53.4586> }
					triangle { <9.8382, 289.1085, 53.5887>, <9.1171, 287.5649, 53.7444>, <9.2623, 286.7496, 53.7233> }
					triangle { <9.8382, 289.1085, 53.5887>, <9.9055, 290.0948, 53.5665>, <9.1171, 287.5649, 53.7444> }
					triangle { <9.8382, 289.1085, 53.5887>, <10.46, 289.9818, 53.4586>, <9.9055, 290.0948, 53.5665> }
					triangle { <9.2623, 286.7496, 53.7233>, <10.46, 289.9818, 53.4586>, <9.8382, 289.1085, 53.5887> }
					triangle { <10.1327, 291.521, 59.6386>, <9.06474, 290.8764, 58.06861>, <9.9055, 290.0948, 53.5665> }
					triangle { <11.9098, 290.745, 59.4412>, <12.2069, 291.001, 60.2009>, <10.1327, 291.521, 59.6386> }
					triangle { <10.1327, 291.521, 59.6386>, <9.9055, 290.0948, 53.5665>, <11.9098, 290.745, 59.4412> }
					triangle { <10.46, 289.9818, 53.4586>, <11.9098, 290.745, 59.4412>, <9.9055, 290.0948, 53.5665> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <9.2623, 286.7496, 53.7233>, <9.5433, 287.3663, 53.2468>, <10.1223, 288.976, 53.2569> }
					triangle { <9.5433, 287.3663, 53.2468>, <10.4737, 289.8299, 52.903>, <10.1223, 288.976, 53.2569> }
					triangle { <10.4737, 289.8299, 52.903>, <10.46, 289.9818, 53.4586>, <10.1223, 288.976, 53.2569> }
					triangle { <10.1223, 288.976, 53.2569>, <10.46, 289.9818, 53.4586>, <9.2623, 286.7496, 53.7233> }
					triangle { <10.4737, 289.8299, 52.903>, <14.6486, 288.2664, 51.4639>, <16.5348, 288.5365, 52.1634> }
					triangle { <16.5348, 288.5365, 52.1634>, <17.3302, 288.6057, 54.1341>, <16.4756, 288.6165, 54.11> }
					triangle { <16.4756, 288.6165, 54.11>, <10.4737, 289.8299, 52.903>, <16.5348, 288.5365, 52.1634> }
					triangle { <10.4737, 289.8299, 52.903>, <16.4756, 288.6165, 54.11>, <10.46, 289.9818, 53.4586> }
					triangle { <10.0758, 289.0394, 53.8197>, <9.4735, 287.4613, 54.09104>, <9.2623, 286.7496, 53.7233> }
					triangle { <10.0758, 289.0394, 53.8197>, <10.3806, 289.9566, 54.02868>, <9.4735, 287.4613, 54.09104> }
					triangle { <10.0758, 289.0394, 53.8197>, <10.46, 289.9818, 53.4586>, <10.3806, 289.9566, 54.02868> }
					triangle { <9.2623, 286.7496, 53.7233>, <10.46, 289.9818, 53.4586>, <10.0758, 289.0394, 53.8197> }
					triangle { <16.2165, 288.9694, 56.00935>, <14.245, 288.8154, 56.3417>, <10.3806, 289.9566, 54.02868> }
					triangle { <16.4756, 288.6165, 54.11>, <17.3302, 288.6057, 54.1341>, <16.2165, 288.9694, 56.00935> }
					triangle { <16.2165, 288.9694, 56.00935>, <10.3806, 289.9566, 54.02868>, <16.4756, 288.6165, 54.11> }
					triangle { <10.46, 289.9818, 53.4586>, <16.4756, 288.6165, 54.11>, <10.3806, 289.9566, 54.02868> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-1.7799, 269.377, 50.9953>, <-0.2089, 270.7294, 52.1113>, 0.2999 }
			cylinder { <-0.2089, 270.7294, 52.1113>, <1.3455, 272.142, 53.1746>, 0.2999 }
			cylinder { <1.3455, 272.142, 53.1746>, <2.8816, 273.613, 54.184>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.8816, 273.613, 54.184>, <6.7643, 277.445, 58.6698>, 0.2999 }
				cylinder { <6.7643, 277.445, 58.6698>, <9.6887, 280.466, 64.3447>, 0.2999 }
				cylinder { <9.6887, 280.466, 64.3447>, <11.4795, 282.4951, 70.8684>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <11.4795, 282.4951, 70.8684>, <11.516, 282.3885, 71.6891>, <12.00292, 283.1082, 73.1628> }
					triangle { <11.516, 282.3885, 71.6891>, <12.1489, 283.204, 74.1361>, <12.00292, 283.1082, 73.1628> }
					triangle { <12.1489, 283.204, 74.1361>, <12.3681, 283.7132, 73.9793>, <12.00292, 283.1082, 73.1628> }
					triangle { <12.00292, 283.1082, 73.1628>, <12.3681, 283.7132, 73.9793>, <11.4795, 282.4951, 70.8684> }
					triangle { <12.1489, 283.204, 74.1361>, <7.6566, 283.3928, 75.4506>, <6.4873, 284.9013, 76.1412> }
					triangle { <6.4873, 284.9013, 76.1412>, <6.3295, 286.9501, 75.5945>, <7.000195, 286.5532, 75.2426> }
					triangle { <7.000195, 286.5532, 75.2426>, <12.1489, 283.204, 74.1361>, <6.4873, 284.9013, 76.1412> }
					triangle { <12.1489, 283.204, 74.1361>, <7.000195, 286.5532, 75.2426>, <12.3681, 283.7132, 73.9793> }
					triangle { <12.1977, 283.584, 72.9208>, <11.8082, 283.1023, 71.3262>, <11.4795, 282.4951, 70.8684> }
					triangle { <12.1977, 283.584, 72.9208>, <12.5385, 284.1557, 73.6521>, <11.8082, 283.1023, 71.3262> }
					triangle { <12.1977, 283.584, 72.9208>, <12.3681, 283.7132, 73.9793>, <12.5385, 284.1557, 73.6521> }
					triangle { <11.4795, 282.4951, 70.8684>, <12.3681, 283.7132, 73.9793>, <12.1977, 283.584, 72.9208> }
					triangle { <7.8185, 288.153, 74.4877>, <9.3449, 287.5169, 73.3535>, <12.5385, 284.1557, 73.6521> }
					triangle { <7.000195, 286.5532, 75.2426>, <6.3295, 286.9501, 75.5945>, <7.8185, 288.153, 74.4877> }
					triangle { <7.8185, 288.153, 74.4877>, <12.5385, 284.1557, 73.6521>, <7.000195, 286.5532, 75.2426> }
					triangle { <12.3681, 283.7132, 73.9793>, <7.000195, 286.5532, 75.2426>, <12.5385, 284.1557, 73.6521> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <11.4795, 282.4951, 70.8684>, <11.9819, 282.4643, 71.5264>, <12.3135, 283.1587, 73.05433> }
					triangle { <11.9819, 282.4643, 71.5264>, <12.7702, 283.3051, 73.9191>, <12.3135, 283.1587, 73.05433> }
					triangle { <12.7702, 283.3051, 73.9191>, <12.3681, 283.7132, 73.9793>, <12.3135, 283.1587, 73.05433> }
					triangle { <12.3135, 283.1587, 73.05433>, <12.3681, 283.7132, 73.9793>, <11.4795, 282.4951, 70.8684> }
					triangle { <12.7702, 283.3051, 73.9191>, <11.6562, 279.2278, 75.9391>, <10.3819, 278.7395, 77.4416> }
					triangle { <10.3819, 278.7395, 77.4416>, <8.4323, 279.4267, 77.9399>, <8.814, 279.8923, 77.3328> }
					triangle { <8.814, 279.8923, 77.3328>, <12.7702, 283.3051, 73.9191>, <10.3819, 278.7395, 77.4416> }
					triangle { <12.7702, 283.3051, 73.9191>, <8.814, 279.8923, 77.3328>, <12.3681, 283.7132, 73.9793> }
					triangle { <11.8871, 283.5335, 73.02939>, <11.3422, 283.0265, 71.489>, <11.4795, 282.4951, 70.8684> }
					triangle { <11.8871, 283.5335, 73.02939>, <11.9173, 284.0546, 73.8692>, <11.3422, 283.0265, 71.489> }
					triangle { <11.8871, 283.5335, 73.02939>, <12.3681, 283.7132, 73.9793>, <11.9173, 284.0546, 73.8692> }
					triangle { <11.4795, 282.4951, 70.8684>, <12.3681, 283.7132, 73.9793>, <11.8871, 283.5335, 73.02939> }
					triangle { <7.4678, 281.3006, 77.2711>, <7.9603, 282.476, 75.7229>, <11.9173, 284.0546, 73.8692> }
					triangle { <8.814, 279.8923, 77.3328>, <8.4323, 279.4267, 77.9399>, <7.4678, 281.3006, 77.2711> }
					triangle { <7.4678, 281.3006, 77.2711>, <11.9173, 284.0546, 73.8692>, <8.814, 279.8923, 77.3328> }
					triangle { <12.3681, 283.7132, 73.9793>, <8.814, 279.8923, 77.3328>, <11.9173, 284.0546, 73.8692> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <11.4795, 282.4951, 70.8684>, <12.00887, 282.9259, 71.3379>, <12.3315, 283.4665, 72.9287> }
					triangle { <12.00887, 282.9259, 71.3379>, <12.8061, 283.9206, 73.6678>, <12.3315, 283.4665, 72.9287> }
					triangle { <12.8061, 283.9206, 73.6678>, <12.3681, 283.7132, 73.9793>, <12.3315, 283.4665, 72.9287> }
					triangle { <12.3315, 283.4665, 72.9287>, <12.3681, 283.7132, 73.9793>, <11.4795, 282.4951, 70.8684> }
					triangle { <12.8061, 283.9206, 73.6678>, <16.633, 281.2197, 73.7375>, <17.3036, 279.8171, 75.04251> }
					triangle { <17.3036, 279.8171, 75.04251>, <16.3051, 278.291, 76.1358>, <15.7737, 278.8427, 75.7558> }
					triangle { <15.7737, 278.8427, 75.7558>, <12.8061, 283.9206, 73.6678>, <17.3036, 279.8171, 75.04251> }
					triangle { <12.8061, 283.9206, 73.6678>, <15.7737, 278.8427, 75.7558>, <12.3681, 283.7132, 73.9793> }
					triangle { <11.8691, 283.2257, 73.155>, <11.3153, 282.5648, 71.6774>, <11.4795, 282.4951, 70.8684> }
					triangle { <11.8691, 283.2257, 73.155>, <11.8814, 283.4391, 74.1205>, <11.3153, 282.5648, 71.6774> }
					triangle { <11.8691, 283.2257, 73.155>, <12.3681, 283.7132, 73.9793>, <11.8814, 283.4391, 74.1205> }
					triangle { <11.4795, 282.4951, 70.8684>, <12.3681, 283.7132, 73.9793>, <11.8691, 283.2257, 73.155> }
					triangle { <14.1442, 278.1721, 76.5891>, <12.626, 279.1334, 75.6991>, <11.8814, 283.4391, 74.1205> }
					triangle { <15.7737, 278.8427, 75.7558>, <16.3051, 278.291, 76.1358>, <14.1442, 278.1721, 76.5891> }
					triangle { <14.1442, 278.1721, 76.5891>, <11.8814, 283.4391, 74.1205>, <15.7737, 278.8427, 75.7558> }
					triangle { <12.3681, 283.7132, 73.9793>, <15.7737, 278.8427, 75.7558>, <11.8814, 283.4391, 74.1205> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <11.4795, 282.4951, 70.8684>, <11.5598, 283.1397, 71.3825>, <12.03213, 283.609, 72.9583> }
					triangle { <11.5598, 283.1397, 71.3825>, <12.2073, 284.2057, 73.7272>, <12.03213, 283.609, 72.9583> }
					triangle { <12.2073, 284.2057, 73.7272>, <12.3681, 283.7132, 73.9793>, <12.03213, 283.609, 72.9583> }
					triangle { <12.03213, 283.609, 72.9583>, <12.3681, 283.7132, 73.9793>, <11.4795, 282.4951, 70.8684> }
					triangle { <12.2073, 284.2057, 73.7272>, <15.7556, 286.6342, 71.8679>, <17.7514, 286.6549, 72.237> }
					triangle { <17.7514, 286.6549, 72.237>, <19.1414, 285.102, 72.6586>, <18.326, 284.845, 72.6764> }
					triangle { <18.326, 284.845, 72.6764>, <12.2073, 284.2057, 73.7272>, <17.7514, 286.6549, 72.237> }
					triangle { <12.2073, 284.2057, 73.7272>, <18.326, 284.845, 72.6764>, <12.3681, 283.7132, 73.9793> }
					triangle { <12.1685, 283.0832, 73.1253>, <11.7644, 282.351, 71.6329>, <11.4795, 282.4951, 70.8684> }
					triangle { <12.1685, 283.0832, 73.1253>, <12.4801, 283.1541, 74.0611>, <11.7644, 282.351, 71.6329> }
					triangle { <12.1685, 283.0832, 73.1253>, <12.3681, 283.7132, 73.9793>, <12.4801, 283.1541, 74.0611> }
					triangle { <11.4795, 282.4951, 70.8684>, <12.3681, 283.7132, 73.9793>, <12.1685, 283.0832, 73.1253> }
					triangle { <18.6834, 283.0619, 73.3778>, <16.9376, 282.0772, 73.3147>, <12.4801, 283.1541, 74.0611> }
					triangle { <18.326, 284.845, 72.6764>, <19.1414, 285.102, 72.6586>, <18.6834, 283.0619, 73.3778> }
					triangle { <18.6834, 283.0619, 73.3778>, <12.4801, 283.1541, 74.0611>, <18.326, 284.845, 72.6764> }
					triangle { <12.3681, 283.7132, 73.9793>, <18.326, 284.845, 72.6764>, <12.4801, 283.1541, 74.0611> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <11.4795, 282.4951, 70.8684>, <11.2506, 282.8026, 71.6028>, <11.8259, 283.3842, 73.1052> }
					triangle { <11.2506, 282.8026, 71.6028>, <11.7951, 283.7561, 74.02103>, <11.8259, 283.3842, 73.1052> }
					triangle { <11.7951, 283.7561, 74.02103>, <12.3681, 283.7132, 73.9793>, <11.8259, 283.3842, 73.1052> }
					triangle { <11.8259, 283.3842, 73.1052>, <12.3681, 283.7132, 73.9793>, <11.4795, 282.4951, 70.8684> }
					triangle { <11.7951, 283.7561, 74.02103>, <10.1241, 287.9976, 72.9427>, <10.9656, 289.8446, 72.9263> }
					triangle { <10.9656, 289.8446, 72.9263>, <12.883, 290.5344, 72.319>, <12.8219, 289.6823, 72.3544> }
					triangle { <12.8219, 289.6823, 72.3544>, <11.7951, 283.7561, 74.02103>, <10.9656, 289.8446, 72.9263> }
					triangle { <11.7951, 283.7561, 74.02103>, <12.8219, 289.6823, 72.3544>, <12.3681, 283.7132, 73.9793> }
					triangle { <12.3746, 283.308, 72.9784>, <12.07361, 282.6882, 71.4125>, <11.4795, 282.4951, 70.8684> }
					triangle { <12.3746, 283.308, 72.9784>, <12.8924, 283.6036, 73.7673>, <12.07361, 282.6882, 71.4125> }
					triangle { <12.3746, 283.308, 72.9784>, <12.3681, 283.7132, 73.9793>, <12.8924, 283.6036, 73.7673> }
					triangle { <11.4795, 282.4951, 70.8684>, <12.3681, 283.7132, 73.9793>, <12.3746, 283.308, 72.9784> }
					triangle { <14.7149, 289.3235, 72.05946>, <14.8793, 287.3368, 71.8432>, <12.8924, 283.6036, 73.7673> }
					triangle { <12.8219, 289.6823, 72.3544>, <12.883, 290.5344, 72.319>, <14.7149, 289.3235, 72.05946> }
					triangle { <14.7149, 289.3235, 72.05946>, <12.8924, 283.6036, 73.7673>, <12.8219, 289.6823, 72.3544> }
					triangle { <12.3681, 283.7132, 73.9793>, <12.8219, 289.6823, 72.3544>, <12.8924, 283.6036, 73.7673> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <2.8816, 273.613, 54.184>, <4.3916, 275.0589, 55.2665>, 0.2999 }
			cylinder { <4.3916, 275.0589, 55.2665>, <5.8735, 276.4779, 56.4209>, 0.2999 }
			cylinder { <5.8735, 276.4779, 56.4209>, <7.3257, 277.8683, 57.6458>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.3257, 277.8683, 57.6458>, <12.8468, 281.4753, 60.1738>, 0.2999 }
				cylinder { <12.8468, 281.4753, 60.1738>, <19.2016, 284.3016, 61.4034>, 0.2999 }
				cylinder { <19.2016, 284.3016, 61.4034>, <26.00909, 286.178, 61.261>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <26.00909, 286.178, 61.261>, <26.7061, 286.2901, 60.8276>, <28.3452, 286.7686, 60.933> }
					triangle { <26.7061, 286.2901, 60.8276>, <29.2663, 286.9692, 60.6345>, <28.3452, 286.7686, 60.933> }
					triangle { <29.2663, 286.9692, 60.6345>, <29.3412, 287.0964, 61.1913>, <28.3452, 286.7686, 60.933> }
					triangle { <28.3452, 286.7686, 60.933>, <29.3412, 287.0964, 61.1913>, <26.00909, 286.178, 61.261> }
					triangle { <29.2663, 286.9692, 60.6345>, <30.5427, 282.6086, 59.494>, <31.8119, 281.2774, 60.3525> }
					triangle { <31.8119, 281.2774, 60.3525>, <32.1906, 280.7709, 62.3826>, <31.7021, 281.4665, 62.2894> }
					triangle { <31.7021, 281.4665, 62.2894>, <29.2663, 286.9692, 60.6345>, <31.8119, 281.2774, 60.3525> }
					triangle { <29.2663, 286.9692, 60.6345>, <31.7021, 281.4665, 62.2894>, <29.3412, 287.0964, 61.1913> }
					triangle { <28.3287, 286.8707, 61.4918>, <26.6814, 286.4433, 61.6658>, <26.00909, 286.178, 61.261> }
					triangle { <28.3287, 286.8707, 61.4918>, <29.2334, 287.1733, 61.7521>, <26.6814, 286.4433, 61.6658> }
					triangle { <28.3287, 286.8707, 61.4918>, <29.3412, 287.0964, 61.1913>, <29.2334, 287.1733, 61.7521> }
					triangle { <26.00909, 286.178, 61.261>, <29.3412, 287.0964, 61.1913>, <28.3287, 286.8707, 61.4918> }
					triangle { <31.6995, 281.975, 64.171>, <30.4001, 283.4933, 64.337>, <29.2334, 287.1733, 61.7521> }
					triangle { <31.7021, 281.4665, 62.2894>, <32.1906, 280.7709, 62.3826>, <31.6995, 281.975, 64.171> }
					triangle { <31.6995, 281.975, 64.171>, <29.2334, 287.1733, 61.7521>, <31.7021, 281.4665, 62.2894> }
					triangle { <29.3412, 287.0964, 61.1913>, <31.7021, 281.4665, 62.2894>, <29.2334, 287.1733, 61.7521> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <26.00909, 286.178, 61.261>, <26.5904, 286.726, 61.04213>, <28.2681, 287.0592, 61.07597> }
					triangle { <26.5904, 286.726, 61.04213>, <29.1121, 287.5504, 60.9204>, <28.2681, 287.0592, 61.07597> }
					triangle { <29.1121, 287.5504, 60.9204>, <29.3412, 287.0964, 61.1913>, <28.2681, 287.0592, 61.07597> }
					triangle { <28.2681, 287.0592, 61.07597>, <29.3412, 287.0964, 61.1913>, <26.00909, 286.178, 61.261> }
					triangle { <29.1121, 287.5504, 60.9204>, <29.204, 287.2191, 56.2485>, <30.3571, 286.1469, 54.9676> }
					triangle { <30.3571, 286.1469, 54.9676>, <31.1036, 284.1574, 55.04272>, <30.7522, 284.4185, 55.7772> }
					triangle { <30.7522, 284.4185, 55.7772>, <29.1121, 287.5504, 60.9204>, <30.3571, 286.1469, 54.9676> }
					triangle { <29.1121, 287.5504, 60.9204>, <30.7522, 284.4185, 55.7772>, <29.3412, 287.0964, 61.1913> }
					triangle { <28.4058, 286.5801, 61.3488>, <26.797, 286.0074, 61.4514>, <26.00909, 286.178, 61.261> }
					triangle { <28.4058, 286.5801, 61.3488>, <29.3876, 286.5922, 61.4661>, <26.797, 286.0074, 61.4514> }
					triangle { <28.4058, 286.5801, 61.3488>, <29.3412, 287.0964, 61.1913>, <29.3876, 286.5922, 61.4661> }
					triangle { <26.00909, 286.178, 61.261>, <29.3412, 287.0964, 61.1913>, <28.4058, 286.5801, 61.3488> }
					triangle { <31.2984, 282.8732, 56.8321>, <30.3979, 283.067, 58.6133>, <29.3876, 286.5922, 61.4661> }
					triangle { <30.7522, 284.4185, 55.7772>, <31.1036, 284.1574, 55.04272>, <31.2984, 282.8732, 56.8321> }
					triangle { <31.2984, 282.8732, 56.8321>, <29.3876, 286.5922, 61.4661>, <30.7522, 284.4185, 55.7772> }
					triangle { <29.3412, 287.0964, 61.1913>, <30.7522, 284.4185, 55.7772>, <29.3876, 286.5922, 61.4661> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <26.00909, 286.178, 61.261>, <26.6166, 286.6687, 61.5374>, <28.2855, 287.021, 61.4062> }
					triangle { <26.6166, 286.6687, 61.5374>, <29.147, 287.4739, 61.5809>, <28.2855, 287.021, 61.4062> }
					triangle { <29.147, 287.4739, 61.5809>, <29.3412, 287.0964, 61.1913>, <28.2855, 287.021, 61.4062> }
					triangle { <28.2855, 287.021, 61.4062>, <29.3412, 287.0964, 61.1913>, <26.00909, 286.178, 61.261> }
					triangle { <29.147, 287.4739, 61.5809>, <28.05361, 291.6613, 59.7877>, <28.6355, 292.6306, 58.102> }
					triangle { <28.6355, 292.6306, 58.102>, <28.9758, 291.958, 56.1138>, <28.8679, 291.3227, 56.6757> }
					triangle { <28.8679, 291.3227, 56.6757>, <29.147, 287.4739, 61.5809>, <28.6355, 292.6306, 58.102> }
					triangle { <29.147, 287.4739, 61.5809>, <28.8679, 291.3227, 56.6757>, <29.3412, 287.0964, 61.1913> }
					triangle { <28.3884, 286.6183, 61.01859>, <26.7709, 286.0647, 60.956>, <26.00909, 286.178, 61.261> }
					triangle { <28.3884, 286.6183, 61.01859>, <29.3527, 286.6686, 60.8056>, <26.7709, 286.0647, 60.956> }
					triangle { <28.3884, 286.6183, 61.01859>, <29.3412, 287.0964, 61.1913>, <29.3527, 286.6686, 60.8056> }
					triangle { <26.00909, 286.178, 61.261>, <29.3412, 287.0964, 61.1913>, <28.3884, 286.6183, 61.01859> }
					triangle { <29.3385, 289.8792, 55.4533>, <28.9452, 288.1717, 56.4283>, <29.3527, 286.6686, 60.8056> }
					triangle { <28.8679, 291.3227, 56.6757>, <28.9758, 291.958, 56.1138>, <29.3385, 289.8792, 55.4533> }
					triangle { <29.3385, 289.8792, 55.4533>, <29.3527, 286.6686, 60.8056>, <28.8679, 291.3227, 56.6757> }
					triangle { <29.3412, 287.0964, 61.1913>, <28.8679, 291.3227, 56.6757>, <29.3527, 286.6686, 60.8056> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <26.00909, 286.178, 61.261>, <26.7486, 286.1968, 61.6338>, <28.3736, 286.7064, 61.4704> }
					triangle { <26.7486, 286.1968, 61.6338>, <29.3231, 286.8448, 61.7093>, <28.3736, 286.7064, 61.4704> }
					triangle { <29.3231, 286.8448, 61.7093>, <29.3412, 287.0964, 61.1913>, <28.3736, 286.7064, 61.4704> }
					triangle { <28.3736, 286.7064, 61.4704>, <29.3412, 287.0964, 61.1913>, <26.00909, 286.178, 61.261> }
					triangle { <29.3231, 286.8448, 61.7093>, <28.6706, 289.8376, 65.2536>, <29.01036, 291.8287, 65.4534> }
					triangle { <29.01036, 291.8287, 65.4534>, <28.7279, 293.4654, 64.1257>, <28.6357, 292.7021, 63.7516> }
					triangle { <28.6357, 292.7021, 63.7516>, <29.3231, 286.8448, 61.7093>, <29.01036, 291.8287, 65.4534> }
					triangle { <29.3231, 286.8448, 61.7093>, <28.6357, 292.7021, 63.7516>, <29.3412, 287.0964, 61.1913> }
					triangle { <28.3003, 286.9329, 60.9543>, <26.6388, 286.5366, 60.8597>, <26.00909, 286.178, 61.261> }
					triangle { <28.3003, 286.9329, 60.9543>, <29.1766, 287.2978, 60.6772>, <26.6388, 286.5366, 60.8597> }
					triangle { <28.3003, 286.9329, 60.9543>, <29.3412, 287.0964, 61.1913>, <29.1766, 287.2978, 60.6772> }
					triangle { <26.00909, 286.178, 61.261>, <29.3412, 287.0964, 61.1913>, <28.3003, 286.9329, 60.9543> }
					triangle { <28.51, 293.3763, 61.9272>, <28.03603, 291.8004, 60.7813>, <29.1766, 287.2978, 60.6772> }
					triangle { <28.6357, 292.7021, 63.7516>, <28.7279, 293.4654, 64.1257>, <28.51, 293.3763, 61.9272> }
					triangle { <28.51, 293.3763, 61.9272>, <29.1766, 287.2978, 60.6772>, <28.6357, 292.7021, 63.7516> }
					triangle { <29.3412, 287.0964, 61.1913>, <28.6357, 292.7021, 63.7516>, <29.1766, 287.2978, 60.6772> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <26.00909, 286.178, 61.261>, <26.8048, 285.9594, 61.1884>, <28.411, 286.5481, 61.1735> }
					triangle { <26.8048, 285.9594, 61.1884>, <29.3979, 286.5281, 61.1156>, <28.411, 286.5481, 61.1735> }
					triangle { <29.3979, 286.5281, 61.1156>, <29.3412, 287.0964, 61.1913>, <28.411, 286.5481, 61.1735> }
					triangle { <28.411, 286.5481, 61.1735>, <29.3412, 287.0964, 61.1913>, <26.00909, 286.178, 61.261> }
					triangle { <29.3979, 286.5281, 61.1156>, <30.2321, 284.1583, 65.06943>, <31.00314, 284.7061, 66.8653> }
					triangle { <31.00314, 284.7061, 66.8653>, <30.7447, 286.447, 68.05861>, <30.4138, 286.5187, 67.2734> }
					triangle { <30.4138, 286.5187, 67.2734>, <29.3979, 286.5281, 61.1156>, <31.00314, 284.7061, 66.8653> }
					triangle { <29.3979, 286.5281, 61.1156>, <30.4138, 286.5187, 67.2734>, <29.3412, 287.0964, 61.1913> }
					triangle { <28.2629, 287.0912, 61.2512>, <26.5827, 286.774, 61.305>, <26.00909, 286.178, 61.261> }
					triangle { <28.2629, 287.0912, 61.2512>, <29.1018, 287.6144, 61.271>, <26.5827, 286.774, 61.305> }
					triangle { <28.2629, 287.0912, 61.2512>, <29.3412, 287.0964, 61.1913>, <29.1018, 287.6144, 61.271> }
					triangle { <26.00909, 286.178, 61.261>, <29.3412, 287.0964, 61.1913>, <28.2629, 287.0912, 61.2512> }
					triangle { <29.9912, 288.4175, 67.3963>, <28.9488, 288.8654, 65.7429>, <29.1018, 287.6144, 61.271> }
					triangle { <30.4138, 286.5187, 67.2734>, <30.7447, 286.447, 68.05861>, <29.9912, 288.4175, 67.3963> }
					triangle { <29.9912, 288.4175, 67.3963>, <29.1018, 287.6144, 61.271>, <30.4138, 286.5187, 67.2734> }
					triangle { <29.3412, 287.0964, 61.1913>, <30.4138, 286.5187, 67.2734>, <29.1018, 287.6144, 61.271> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <7.3257, 277.8683, 57.6458>, <8.8377, 279.2401, 58.8183>, 0.2999 }
			cylinder { <8.8377, 279.2401, 58.8183>, <10.4077, 280.5915, 59.937>, 0.2999 }
			cylinder { <10.4077, 280.5915, 59.937>, <12.03387, 281.9209, 61.00047>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.03387, 281.9209, 61.00047>, <15.6319, 287.0708, 64.2278>, 0.2999 }
				cylinder { <15.6319, 287.0708, 64.2278>, <17.7339, 293.0736, 67.2987>, 0.2999 }
				cylinder { <17.7339, 293.0736, 67.2987>, <18.2141, 299.5695, 70.02908>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <18.2141, 299.5695, 70.02908>, <17.9615, 300.3078, 70.3074>, <18.4883, 301.8469, 70.8369> }
					triangle { <17.9615, 300.3078, 70.3074>, <18.4279, 302.7744, 71.1743>, <18.4883, 301.8469, 70.8369> }
					triangle { <18.4279, 302.7744, 71.1743>, <19.00228, 302.748, 71.137>, <18.4883, 301.8469, 70.8369> }
					triangle { <18.4883, 301.8469, 70.8369>, <19.00228, 302.748, 71.137>, <18.2141, 299.5695, 70.02908> }
					triangle { <18.4279, 302.7744, 71.1743>, <16.3675, 304.6935, 67.4304>, <17.03498, 305.9575, 65.9894> }
					triangle { <17.03498, 305.9575, 65.9894>, <18.8775, 306.0743, 64.9346>, <18.8953, 305.5308, 65.5944> }
					triangle { <18.8953, 305.5308, 65.5944>, <18.4279, 302.7744, 71.1743>, <17.03498, 305.9575, 65.9894> }
					triangle { <18.4279, 302.7744, 71.1743>, <18.8953, 305.5308, 65.5944>, <19.00228, 302.748, 71.137> }
					triangle { <19.04111, 301.7334, 70.7693>, <18.7906, 300.1375, 70.206>, <18.2141, 299.5695, 70.02908> }
					triangle { <19.04111, 301.7334, 70.7693>, <19.5334, 302.5474, 71.03909>, <18.7906, 300.1375, 70.206> }
					triangle { <19.04111, 301.7334, 70.7693>, <19.00228, 302.748, 71.137>, <19.5334, 302.5474, 71.03909> }
					triangle { <18.2141, 299.5695, 70.02908>, <19.00228, 302.748, 71.137>, <19.04111, 301.7334, 70.7693> }
					triangle { <20.8118, 305.182, 65.5272>, <21.1577, 303.71, 66.8443>, <19.5334, 302.5474, 71.03909> }
					triangle { <18.8953, 305.5308, 65.5944>, <18.8775, 306.0743, 64.9346>, <20.8118, 305.182, 65.5272> }
					triangle { <20.8118, 305.182, 65.5272>, <19.5334, 302.5474, 71.03909>, <18.8953, 305.5308, 65.5944> }
					triangle { <19.00228, 302.748, 71.137>, <18.8953, 305.5308, 65.5944>, <19.5334, 302.5474, 71.03909> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.2141, 299.5695, 70.02908>, <18.2644, 300.1122, 70.6529>, <18.6903, 301.7165, 71.06731> }
					triangle { <18.2644, 300.1122, 70.6529>, <18.8318, 302.5137, 71.635>, <18.6903, 301.7165, 71.06731> }
					triangle { <18.8318, 302.5137, 71.635>, <19.00228, 302.748, 71.137>, <18.6903, 301.7165, 71.06731> }
					triangle { <18.6903, 301.7165, 71.06731>, <19.00228, 302.748, 71.137>, <18.2141, 299.5695, 70.02908> }
					triangle { <18.8318, 302.5137, 71.635>, <14.3478, 303.3588, 72.6956>, <13.04793, 304.8083, 72.122> }
					triangle { <13.04793, 304.8083, 72.122>, <12.6991, 305.7535, 70.2496>, <13.4017, 305.2664, 70.2608> }
					triangle { <13.4017, 305.2664, 70.2608>, <18.8318, 302.5137, 71.635>, <13.04793, 304.8083, 72.122> }
					triangle { <18.8318, 302.5137, 71.635>, <13.4017, 305.2664, 70.2608>, <19.00228, 302.748, 71.137> }
					triangle { <18.8391, 301.8637, 70.539>, <18.4877, 300.3331, 69.8605>, <18.2141, 299.5695, 70.02908> }
					triangle { <18.8391, 301.8637, 70.539>, <19.1295, 302.8082, 70.5784>, <18.4877, 300.3331, 69.8605> }
					triangle { <18.8391, 301.8637, 70.539>, <19.00228, 302.748, 71.137>, <19.1295, 302.8082, 70.5784> }
					triangle { <18.2141, 299.5695, 70.02908>, <19.00228, 302.748, 71.137>, <18.8391, 301.8637, 70.539> }
					triangle { <14.06519, 305.8145, 68.512>, <15.638, 304.635, 68.117>, <19.1295, 302.8082, 70.5784> }
					triangle { <13.4017, 305.2664, 70.2608>, <12.6991, 305.7535, 70.2496>, <14.06519, 305.8145, 68.512> }
					triangle { <14.06519, 305.8145, 68.512>, <19.1295, 302.8082, 70.5784>, <13.4017, 305.2664, 70.2608> }
					triangle { <19.00228, 302.748, 71.137>, <13.4017, 305.2664, 70.2608>, <19.1295, 302.8082, 70.5784> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.2141, 299.5695, 70.02908>, <18.7205, 300.0683, 70.4546>, <18.9944, 301.6872, 70.935> }
					triangle { <18.7205, 300.0683, 70.4546>, <19.44, 302.455, 71.3705>, <18.9944, 301.6872, 70.935> }
					triangle { <19.44, 302.455, 71.3705>, <19.00228, 302.748, 71.137>, <18.9944, 301.6872, 70.935> }
					triangle { <18.9944, 301.6872, 70.935>, <19.00228, 302.748, 71.137>, <18.2141, 299.5695, 70.02908> }
					triangle { <19.44, 302.455, 71.3705>, <18.717, 301.1858, 75.8215>, <17.5008, 301.9069, 77.2777> }
					triangle { <17.5008, 301.9069, 77.2777>, <15.4987, 302.6221, 77.2411>, <15.8327, 302.5014, 76.4633> }
					triangle { <15.8327, 302.5014, 76.4633>, <19.44, 302.455, 71.3705>, <17.5008, 301.9069, 77.2777> }
					triangle { <19.44, 302.455, 71.3705>, <15.8327, 302.5014, 76.4633>, <19.00228, 302.748, 71.137> }
					triangle { <18.535, 301.893, 70.6712>, <18.03157, 300.377, 70.0589>, <18.2141, 299.5695, 70.02908> }
					triangle { <18.535, 301.893, 70.6712>, <18.5213, 302.8668, 70.8429>, <18.03157, 300.377, 70.0589> }
					triangle { <18.535, 301.893, 70.6712>, <19.00228, 302.748, 71.137>, <18.5213, 302.8668, 70.8429> }
					triangle { <18.2141, 299.5695, 70.02908>, <19.00228, 302.748, 71.137>, <18.535, 301.893, 70.6712> }
					triangle { <14.362, 303.3136, 75.475>, <14.7362, 302.9699, 73.5351>, <18.5213, 302.8668, 70.8429> }
					triangle { <15.8327, 302.5014, 76.4633>, <15.4987, 302.6221, 77.2411>, <14.362, 303.3136, 75.475> }
					triangle { <14.362, 303.3136, 75.475>, <18.5213, 302.8668, 70.8429>, <15.8327, 302.5014, 76.4633> }
					triangle { <19.00228, 302.748, 71.137>, <15.8327, 302.5014, 76.4633>, <18.5213, 302.8668, 70.8429> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.2141, 299.5695, 70.02908>, <18.7038, 300.2362, 69.9846>, <18.9832, 301.7992, 70.6217> }
					triangle { <18.7038, 300.2362, 69.9846>, <19.4177, 302.679, 70.7439>, <18.9832, 301.7992, 70.6217> }
					triangle { <19.4177, 302.679, 70.7439>, <19.00228, 302.748, 71.137>, <18.9832, 301.7992, 70.6217> }
					triangle { <18.9832, 301.7992, 70.6217>, <19.00228, 302.748, 71.137>, <18.2141, 299.5695, 70.02908> }
					triangle { <19.4177, 302.679, 70.7439>, <23.4777, 301.1571, 72.5173>, <24.2814, 301.2358, 74.3794> }
					triangle { <24.2814, 301.2358, 74.3794>, <23.4334, 300.9783, 76.3123>, <22.8514, 301.0312, 75.6881> }
					triangle { <22.8514, 301.0312, 75.6881>, <19.4177, 302.679, 70.7439>, <24.2814, 301.2358, 74.3794> }
					triangle { <19.4177, 302.679, 70.7439>, <22.8514, 301.0312, 75.6881>, <19.00228, 302.748, 71.137> }
					triangle { <18.5462, 301.7811, 70.9845>, <18.04829, 300.2091, 70.5288>, <18.2141, 299.5695, 70.02908> }
					triangle { <18.5462, 301.7811, 70.9845>, <18.5436, 302.6428, 71.4695>, <18.04829, 300.2091, 70.5288> }
					triangle { <18.5462, 301.7811, 70.9845>, <19.00228, 302.748, 71.137>, <18.5436, 302.6428, 71.4695> }
					triangle { <18.2141, 299.5695, 70.02908>, <19.00228, 302.748, 71.137>, <18.5462, 301.7811, 70.9845> }
					triangle { <21.295, 301.1121, 76.8586>, <19.6901, 301.0002, 75.6616>, <18.5436, 302.6428, 71.4695> }
					triangle { <22.8514, 301.0312, 75.6881>, <23.4334, 300.9783, 76.3123>, <21.295, 301.1121, 76.8586> }
					triangle { <21.295, 301.1121, 76.8586>, <18.5436, 302.6428, 71.4695>, <22.8514, 301.0312, 75.6881> }
					triangle { <19.00228, 302.748, 71.137>, <22.8514, 301.0312, 75.6881>, <18.5436, 302.6428, 71.4695> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.2141, 299.5695, 70.02908>, <18.2276, 300.3865, 69.8923>, <18.6658, 301.8993, 70.5602> }
					triangle { <18.2276, 300.3865, 69.8923>, <18.7828, 302.8794, 70.6208>, <18.6658, 301.8993, 70.5602> }
					triangle { <18.7828, 302.8794, 70.6208>, <19.00228, 302.748, 71.137>, <18.6658, 301.8993, 70.5602> }
					triangle { <18.6658, 301.8993, 70.5602>, <19.00228, 302.748, 71.137>, <18.2141, 299.5695, 70.02908> }
					triangle { <18.7828, 302.8794, 70.6208>, <22.00371, 303.3577, 67.253>, <23.9891, 303.7769, 67.2976> }
					triangle { <23.9891, 303.7769, 67.2976>, <25.5531, 303.1441, 68.5916>, <24.7728, 302.9317, 68.8693> }
					triangle { <24.7728, 302.9317, 68.8693>, <18.7828, 302.8794, 70.6208>, <23.9891, 303.7769, 67.2976> }
					triangle { <18.7828, 302.8794, 70.6208>, <24.7728, 302.9317, 68.8693>, <19.00228, 302.748, 71.137> }
					triangle { <18.8636, 301.6809, 71.0461>, <18.5244, 300.0588, 70.6211>, <18.2141, 299.5695, 70.02908> }
					triangle { <18.8636, 301.6809, 71.0461>, <19.1785, 302.4425, 71.5926>, <18.5244, 300.0588, 70.6211> }
					triangle { <18.8636, 301.6809, 71.0461>, <19.00228, 302.748, 71.137>, <19.1785, 302.4425, 71.5926> }
					triangle { <18.2141, 299.5695, 70.02908>, <19.00228, 302.748, 71.137>, <18.8636, 301.6809, 71.0461> }
					triangle { <25.3414, 302.2843, 70.6177>, <23.7187, 301.4645, 71.4639>, <19.1785, 302.4425, 71.5926> }
					triangle { <24.7728, 302.9317, 68.8693>, <25.5531, 303.1441, 68.5916>, <25.3414, 302.2843, 70.6177> }
					triangle { <25.3414, 302.2843, 70.6177>, <19.1785, 302.4425, 71.5926>, <24.7728, 302.9317, 68.8693> }
					triangle { <19.00228, 302.748, 71.137>, <24.7728, 302.9317, 68.8693>, <19.1785, 302.4425, 71.5926> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <12.03387, 281.9209, 61.00047>, <13.6039, 283.309, 62.07315>, 0.2999 }
			cylinder { <13.6039, 283.309, 62.07315>, <15.1159, 284.7542, 63.1537>, 0.2999 }
			cylinder { <15.1159, 284.7542, 63.1537>, <16.5682, 286.2547, 64.2409>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <16.5682, 286.2547, 64.2409>, <21.3781, 289.3428, 68.3895>, 0.2999 }
				cylinder { <21.3781, 289.3428, 68.3895>, <26.3526, 290.8325, 73.1768>, 0.2999 }
				cylinder { <26.3526, 290.8325, 73.1768>, <31.1937, 290.6345, 78.3156>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <31.1937, 290.6345, 78.3156>, <31.7515, 290.1771, 78.6481>, <32.918, 290.1248, 79.8001> }
					triangle { <31.7515, 290.1771, 78.6481>, <33.6197, 289.77, 80.3298>, <32.918, 290.1248, 79.8001> }
					triangle { <33.6197, 289.77, 80.3298>, <33.6017, 290.2699, 80.564>, <32.918, 290.1248, 79.8001> }
					triangle { <32.918, 290.1248, 79.8001>, <33.6017, 290.2699, 80.564>, <31.1937, 290.6345, 78.3156> }
					triangle { <33.6197, 289.77, 80.3298>, <31.2356, 286.6505, 82.5112>, <30.6203, 286.5085, 84.352> }
					triangle { <30.6203, 286.5085, 84.352>, <29.8643, 287.8846, 85.6525>, <30.1763, 288.2153, 84.9703> }
					triangle { <30.1763, 288.2153, 84.9703>, <33.6197, 289.77, 80.3298>, <30.6203, 286.5085, 84.352> }
					triangle { <33.6197, 289.77, 80.3298>, <30.1763, 288.2153, 84.9703>, <33.6017, 290.2699, 80.564> }
					triangle { <32.8341, 290.6348, 79.9727>, <31.6256, 290.942, 78.907>, <31.1937, 290.6345, 78.3156> }
					triangle { <32.8341, 290.6348, 79.9727>, <33.4518, 290.7899, 80.6749>, <31.6256, 290.942, 78.907> }
					triangle { <32.8341, 290.6348, 79.9727>, <33.6017, 290.2699, 80.564>, <33.4518, 290.7899, 80.6749> }
					triangle { <31.1937, 290.6345, 78.3156>, <33.6017, 290.2699, 80.564>, <32.8341, 290.6348, 79.9727> }
					triangle { <30.04687, 289.9933, 85.5311>, <30.5083, 291.0702, 84.00673>, <33.4518, 290.7899, 80.6749> }
					triangle { <30.1763, 288.2153, 84.9703>, <29.8643, 287.8846, 85.6525>, <30.04687, 289.9933, 85.5311> }
					triangle { <30.04687, 289.9933, 85.5311>, <33.4518, 290.7899, 80.6749>, <30.1763, 288.2153, 84.9703> }
					triangle { <33.6017, 290.2699, 80.564>, <30.1763, 288.2153, 84.9703>, <33.4518, 290.7899, 80.6749> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <31.1937, 290.6345, 78.3156>, <31.9681, 290.5694, 78.4797>, <33.06247, 290.3864, 79.6878> }
					triangle { <31.9681, 290.5694, 78.4797>, <33.9086, 290.293, 80.1052>, <33.06247, 290.3864, 79.6878> }
					triangle { <33.9086, 290.293, 80.1052>, <33.6017, 290.2699, 80.564>, <33.06247, 290.3864, 79.6878> }
					triangle { <33.06247, 290.3864, 79.6878>, <33.6017, 290.2699, 80.564>, <31.1937, 290.6345, 78.3156> }
					triangle { <33.9086, 290.293, 80.1052>, <34.9874, 286.2673, 78.431>, <35.1011, 284.495, 79.2267> }
					triangle { <35.1011, 284.495, 79.2267>, <33.9324, 283.529, 80.5895>, <33.7527, 284.3248, 80.5094> }
					triangle { <33.7527, 284.3248, 80.5094>, <33.9086, 290.293, 80.1052>, <35.1011, 284.495, 79.2267> }
					triangle { <33.9086, 290.293, 80.1052>, <33.7527, 284.3248, 80.5094>, <33.6017, 290.2699, 80.564> }
					triangle { <32.6896, 290.3732, 80.08499>, <31.4089, 290.5497, 79.07546>, <31.1937, 290.6345, 78.3156> }
					triangle { <32.6896, 290.3732, 80.08499>, <33.1629, 290.2668, 80.8995>, <31.4089, 290.5497, 79.07546> }
					triangle { <32.6896, 290.3732, 80.08499>, <33.6017, 290.2699, 80.564>, <33.1629, 290.2668, 80.8995> }
					triangle { <31.1937, 290.6345, 78.3156>, <33.6017, 290.2699, 80.564>, <32.6896, 290.3732, 80.08499> }
					triangle { <32.5536, 284.4054, 81.9405>, <31.7564, 286.1537, 81.8729>, <33.1629, 290.2668, 80.8995> }
					triangle { <33.7527, 284.3248, 80.5094>, <33.9324, 283.529, 80.5895>, <32.5536, 284.4054, 81.9405> }
					triangle { <32.5536, 284.4054, 81.9405>, <33.1629, 290.2668, 80.8995>, <33.7527, 284.3248, 80.5094> }
					triangle { <33.6017, 290.2699, 80.564>, <33.7527, 284.3248, 80.5094>, <33.1629, 290.2668, 80.8995> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <31.1937, 290.6345, 78.3156>, <31.801, 290.9482, 78.7201>, <32.951, 290.6389, 79.8481> }
					triangle { <31.801, 290.9482, 78.7201>, <33.6857, 290.7981, 80.4258>, <32.951, 290.6389, 79.8481> }
					triangle { <33.6857, 290.7981, 80.4258>, <33.6017, 290.2699, 80.564>, <32.951, 290.6389, 79.8481> }
					triangle { <32.951, 290.6389, 79.8481>, <33.6017, 290.2699, 80.564>, <31.1937, 290.6345, 78.3156> }
					triangle { <33.6857, 290.7981, 80.4258>, <36.8372, 291.3783, 77.2786>, <38.3388, 290.2849, 76.698> }
					triangle { <38.3388, 290.2849, 76.698>, <38.5427, 288.2754, 76.4216>, <37.8462, 288.4851, 76.7999> }
					triangle { <37.8462, 288.4851, 76.7999>, <33.6857, 290.7981, 80.4258>, <38.3388, 290.2849, 76.698> }
					triangle { <33.6857, 290.7981, 80.4258>, <37.8462, 288.4851, 76.7999>, <33.6017, 290.2699, 80.564> }
					triangle { <32.801, 290.1207, 79.9247>, <31.5761, 290.1709, 78.835>, <31.1937, 290.6345, 78.3156> }
					triangle { <32.801, 290.1207, 79.9247>, <33.3858, 289.7617, 80.579>, <31.5761, 290.1709, 78.835> }
					triangle { <32.801, 290.1207, 79.9247>, <33.6017, 290.2699, 80.564>, <33.3858, 289.7617, 80.579> }
					triangle { <31.1937, 290.6345, 78.3156>, <33.6017, 290.2699, 80.564>, <32.801, 290.1207, 79.9247> }
					triangle { <37.314, 286.744, 77.2214>, <35.5375, 286.8873, 77.9424>, <33.3858, 289.7617, 80.579> }
					triangle { <37.8462, 288.4851, 76.7999>, <38.5427, 288.2754, 76.4216>, <37.314, 286.744, 77.2214> }
					triangle { <37.314, 286.744, 77.2214>, <33.3858, 289.7617, 80.579>, <37.8462, 288.4851, 76.7999> }
					triangle { <33.6017, 290.2699, 80.564>, <37.8462, 288.4851, 76.7999>, <33.3858, 289.7617, 80.579> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <31.1937, 290.6345, 78.3156>, <31.4795, 290.7935, 79.03942>, <32.7367, 290.5358, 80.06097> }
					triangle { <31.4795, 290.7935, 79.03942>, <33.257, 290.5919, 80.8515>, <32.7367, 290.5358, 80.06097> }
					triangle { <33.257, 290.5919, 80.8515>, <33.6017, 290.2699, 80.564>, <32.7367, 290.5358, 80.06097> }
					triangle { <32.7367, 290.5358, 80.06097>, <33.6017, 290.2699, 80.564>, <31.1937, 290.6345, 78.3156> }
					triangle { <33.257, 290.5919, 80.8515>, <34.2458, 294.9679, 80.6358>, <35.8892, 295.9309, 80.2369> }
					triangle { <35.8892, 295.9309, 80.2369>, <37.3669, 295.6088, 78.8698>, <36.838, 294.9856, 78.9335> }
					triangle { <36.838, 294.9856, 78.9335>, <33.257, 290.5919, 80.8515>, <35.8892, 295.9309, 80.2369> }
					triangle { <33.257, 290.5919, 80.8515>, <36.838, 294.9856, 78.9335>, <33.6017, 290.2699, 80.564> }
					triangle { <33.01543, 290.2238, 79.7118>, <31.8976, 290.3256, 78.5157>, <31.1937, 290.6345, 78.3156> }
					triangle { <33.01543, 290.2238, 79.7118>, <33.8145, 289.9679, 80.1533>, <31.8976, 290.3256, 78.5157> }
					triangle { <33.01543, 290.2238, 79.7118>, <33.6017, 290.2699, 80.564>, <33.8145, 289.9679, 80.1533> }
					triangle { <31.1937, 290.6345, 78.3156>, <33.6017, 290.2699, 80.564>, <33.01543, 290.2238, 79.7118> }
					triangle { <37.7938, 293.799, 77.8514>, <36.6615, 292.264, 77.6104>, <33.8145, 289.9679, 80.1533> }
					triangle { <36.838, 294.9856, 78.9335>, <37.3669, 295.6088, 78.8698>, <37.7938, 293.799, 77.8514> }
					triangle { <37.7938, 293.799, 77.8514>, <33.8145, 289.9679, 80.1533>, <36.838, 294.9856, 78.9335> }
					triangle { <33.6017, 290.2699, 80.564>, <36.838, 294.9856, 78.9335>, <33.8145, 289.9679, 80.1533> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <31.1937, 290.6345, 78.3156>, <31.4484, 290.3098, 78.9942>, <32.7159, 290.2133, 80.03087> }
					triangle { <31.4484, 290.3098, 78.9942>, <33.2156, 289.9469, 80.7913>, <32.7159, 290.2133, 80.03087> }
					triangle { <33.2156, 289.9469, 80.7913>, <33.6017, 290.2699, 80.564>, <32.7159, 290.2133, 80.03087> }
					triangle { <32.7159, 290.2133, 80.03087>, <33.6017, 290.2699, 80.564>, <31.1937, 290.6345, 78.3156> }
					triangle { <33.2156, 289.9469, 80.7913>, <30.7316, 292.0018, 83.9186>, <31.04689, 293.5617, 85.03875> }
					triangle { <31.04689, 293.5617, 85.03875>, <31.9224, 295.3636, 84.6609>, <32.02628, 294.8164, 84.0594> }
					triangle { <32.02628, 294.8164, 84.0594>, <33.2156, 289.9469, 80.7913>, <31.04689, 293.5617, 85.03875> }
					triangle { <33.2156, 289.9469, 80.7913>, <32.02628, 294.8164, 84.0594>, <33.6017, 290.2699, 80.564> }
					triangle { <33.03615, 290.5463, 79.7419>, <31.9287, 290.8093, 78.5609>, <31.1937, 290.6345, 78.3156> }
					triangle { <33.03615, 290.5463, 79.7419>, <33.8559, 290.6129, 80.2135>, <31.9287, 290.8093, 78.5609> }
					triangle { <33.03615, 290.5463, 79.7419>, <33.6017, 290.2699, 80.564>, <33.8559, 290.6129, 80.2135> }
					triangle { <31.1937, 290.6345, 78.3156>, <33.6017, 290.2699, 80.564>, <33.03615, 290.5463, 79.7419> }
					triangle { <33.2346, 295.8375, 83.06469>, <33.5063, 294.8882, 81.4149>, <33.8559, 290.6129, 80.2135> }
					triangle { <32.02628, 294.8164, 84.0594>, <31.9224, 295.3636, 84.6609>, <33.2346, 295.8375, 83.06469> }
					triangle { <33.2346, 295.8375, 83.06469>, <33.8559, 290.6129, 80.2135>, <32.02628, 294.8164, 84.0594> }
					triangle { <33.6017, 290.2699, 80.564>, <32.02628, 294.8164, 84.0594>, <33.8559, 290.6129, 80.2135> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-6.3832, 265.3151, 47.509>, <-6.4891, 267.6008, 48.06316>, 0.2999 }
			cylinder { <-6.4891, 267.6008, 48.06316>, <-6.5205, 269.8805, 48.6502>, 0.2999 }
			cylinder { <-6.5205, 269.8805, 48.6502>, <-6.4774, 272.1514, 49.2697>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-6.4774, 272.1514, 49.2697>, <-7.09207, 274.0705, 48.05242>, 0.2999 }
			cylinder { <-7.09207, 274.0705, 48.05242>, <-7.7299, 275.9413, 46.7734>, 0.2999 }
			cylinder { <-7.7299, 275.9413, 46.7734>, <-8.3901, 277.7615, 45.4343>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3901, 277.7615, 45.4343>, <-11.1029, 283.7643, 42.8866>, 0.2999 }
				cylinder { <-11.1029, 283.7643, 42.8866>, <-14.3851, 289.9492, 41.9614>, 0.2999 }
				cylinder { <-14.3851, 289.9492, 41.9614>, <-18.04012, 295.9457, 42.7141>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-18.04012, 295.9457, 42.7141>, <-18.2476, 296.5554, 43.2351>, <-19.1107, 298.0254, 43.3792> }
					triangle { <-18.2476, 296.5554, 43.2351>, <-19.4765, 298.84, 43.804>, <-19.1107, 298.0254, 43.3792> }
					triangle { <-19.4765, 298.84, 43.804>, <-19.7, 298.9249, 43.2799>, <-19.1107, 298.0254, 43.3792> }
					triangle { <-19.1107, 298.0254, 43.3792>, <-19.7, 298.9249, 43.2799>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-19.4765, 298.84, 43.804>, <-22.4053, 296.7485, 46.8027>, <-24.4283, 296.5976, 46.871> }
					triangle { <-24.4283, 296.5976, 46.871>, <-25.8889, 296.2912, 45.3564>, <-25.1077, 296.455, 45.04977> }
					triangle { <-25.1077, 296.455, 45.04977>, <-19.4765, 298.84, 43.804>, <-24.4283, 296.5976, 46.871> }
					triangle { <-19.4765, 298.84, 43.804>, <-25.1077, 296.455, 45.04977>, <-19.7, 298.9249, 43.2799> }
					triangle { <-19.2888, 298.0287, 42.8395>, <-18.5147, 296.5603, 42.4256>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-19.2888, 298.0287, 42.8395>, <-19.8327, 298.8465, 42.7247>, <-18.5147, 296.5603, 42.4256> }
					triangle { <-19.2888, 298.0287, 42.8395>, <-19.7, 298.9249, 43.2799>, <-19.8327, 298.8465, 42.7247> }
					triangle { <-18.04012, 295.9457, 42.7141>, <-19.7, 298.9249, 43.2799>, <-19.2888, 298.0287, 42.8395> }
					triangle { <-25.6453, 296.6198, 43.1835>, <-23.9489, 296.7767, 42.1258>, <-19.8327, 298.8465, 42.7247> }
					triangle { <-25.1077, 296.455, 45.04977>, <-25.8889, 296.2912, 45.3564>, <-25.6453, 296.6198, 43.1835> }
					triangle { <-25.6453, 296.6198, 43.1835>, <-19.8327, 298.8465, 42.7247>, <-25.1077, 296.455, 45.04977> }
					triangle { <-19.7, 298.9249, 43.2799>, <-25.1077, 296.455, 45.04977>, <-19.8327, 298.8465, 42.7247> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-18.04012, 295.9457, 42.7141>, <-18.00774, 296.7624, 42.8491>, <-18.9508, 298.1634, 43.1219> }
					triangle { <-18.00774, 296.7624, 42.8491>, <-19.1566, 299.116, 43.2894>, <-18.9508, 298.1634, 43.1219> }
					triangle { <-19.1566, 299.116, 43.2894>, <-19.7, 298.9249, 43.2799>, <-18.9508, 298.1634, 43.1219> }
					triangle { <-18.9508, 298.1634, 43.1219>, <-19.7, 298.9249, 43.2799>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-19.1566, 299.116, 43.2894>, <-17.3277, 299.428, 47.5909>, <-18.1639, 299.6016, 49.4322> }
					triangle { <-18.1639, 299.6016, 49.4322>, <-19.8762, 298.7, 50.3133>, <-19.814, 298.5648, 49.4713> }
					triangle { <-19.814, 298.5648, 49.4713>, <-19.1566, 299.116, 43.2894>, <-18.1639, 299.6016, 49.4322> }
					triangle { <-19.1566, 299.116, 43.2894>, <-19.814, 298.5648, 49.4713>, <-19.7, 298.9249, 43.2799> }
					triangle { <-19.4487, 297.8907, 43.0969>, <-18.7546, 296.3533, 42.8116>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-19.4487, 297.8907, 43.0969>, <-20.1525, 298.5706, 43.2394>, <-18.7546, 296.3533, 42.8116> }
					triangle { <-19.4487, 297.8907, 43.0969>, <-19.7, 298.9249, 43.2799>, <-20.1525, 298.5706, 43.2394> }
					triangle { <-18.04012, 295.9457, 42.7141>, <-19.7, 298.9249, 43.2799>, <-19.4487, 297.8907, 43.0969> }
					triangle { <-21.5666, 297.7381, 49.2613>, <-21.6433, 297.0646, 47.374>, <-20.1525, 298.5706, 43.2394> }
					triangle { <-19.814, 298.5648, 49.4713>, <-19.8762, 298.7, 50.3133>, <-21.5666, 297.7381, 49.2613> }
					triangle { <-21.5666, 297.7381, 49.2613>, <-20.1525, 298.5706, 43.2394>, <-19.814, 298.5648, 49.4713> }
					triangle { <-19.7, 298.9249, 43.2799>, <-19.814, 298.5648, 49.4713>, <-20.1525, 298.5706, 43.2394> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-18.04012, 295.9457, 42.7141>, <-18.2804, 296.6886, 42.4374>, <-19.1326, 298.1142, 42.8474> }
					triangle { <-18.2804, 296.6886, 42.4374>, <-19.5203, 299.0176, 42.7404>, <-19.1326, 298.1142, 42.8474> }
					triangle { <-19.5203, 299.0176, 42.7404>, <-19.7, 298.9249, 43.2799>, <-19.1326, 298.1142, 42.8474> }
					triangle { <-19.1326, 298.1142, 42.8474>, <-19.7, 298.9249, 43.2799>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-19.5203, 299.0176, 42.7404>, <-15.5064, 301.4169, 42.4616>, <-14.5699, 302.6851, 43.74> }
					triangle { <-14.5699, 302.6851, 43.74>, <-14.3084, 302.6499, 45.8499>, <-14.8632, 302.0652, 45.5645> }
					triangle { <-14.8632, 302.0652, 45.5645>, <-19.5203, 299.0176, 42.7404>, <-14.5699, 302.6851, 43.74> }
					triangle { <-19.5203, 299.0176, 42.7404>, <-14.8632, 302.0652, 45.5645>, <-19.7, 298.9249, 43.2799> }
					triangle { <-19.2669, 297.9399, 43.3713>, <-18.4819, 296.4271, 43.2233>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-19.2669, 297.9399, 43.3713>, <-19.7888, 298.6689, 43.7883>, <-18.4819, 296.4271, 43.2233> }
					triangle { <-19.2669, 297.9399, 43.3713>, <-19.7, 298.9249, 43.2799>, <-19.7888, 298.6689, 43.7883> }
					triangle { <-18.04012, 295.9457, 42.7141>, <-19.7, 298.9249, 43.2799>, <-19.2669, 297.9399, 43.3713> }
					triangle { <-15.4876, 301.4938, 47.3203>, <-16.6704, 299.906, 47.00252>, <-19.7888, 298.6689, 43.7883> }
					triangle { <-14.8632, 302.0652, 45.5645>, <-14.3084, 302.6499, 45.8499>, <-15.4876, 301.4938, 47.3203> }
					triangle { <-15.4876, 301.4938, 47.3203>, <-19.7888, 298.6689, 43.7883>, <-14.8632, 302.0652, 45.5645> }
					triangle { <-19.7, 298.9249, 43.2799>, <-14.8632, 302.0652, 45.5645>, <-19.7888, 298.6689, 43.7883> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-18.04012, 295.9457, 42.7141>, <-18.6914, 296.4354, 42.5651>, <-19.4066, 297.9454, 42.9325> }
					triangle { <-18.6914, 296.4354, 42.5651>, <-20.0683, 298.68, 42.9106>, <-19.4066, 297.9454, 42.9325> }
					triangle { <-20.0683, 298.68, 42.9106>, <-19.7, 298.9249, 43.2799>, <-19.4066, 297.9454, 42.9325> }
					triangle { <-19.4066, 297.9454, 42.9325>, <-19.7, 298.9249, 43.2799>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-20.0683, 298.68, 42.9106>, <-19.4414, 299.9852, 38.4555>, <-18.5796, 301.6156, 37.6077> }
					triangle { <-18.5796, 301.6156, 37.6077>, <-16.828, 302.7192, 38.0929>, <-17.05111, 302.1514, 38.692> }
					triangle { <-17.05111, 302.1514, 38.692>, <-20.0683, 298.68, 42.9106>, <-18.5796, 301.6156, 37.6077> }
					triangle { <-20.0683, 298.68, 42.9106>, <-17.05111, 302.1514, 38.692>, <-19.7, 298.9249, 43.2799> }
					triangle { <-18.9929, 298.1087, 43.2862>, <-18.07093, 296.6804, 43.09569>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-18.9929, 298.1087, 43.2862>, <-19.2409, 299.0066, 43.6181>, <-18.07093, 296.6804, 43.09569> }
					triangle { <-18.9929, 298.1087, 43.2862>, <-19.7, 298.9249, 43.2799>, <-19.2409, 299.0066, 43.6181> }
					triangle { <-18.04012, 295.9457, 42.7141>, <-19.7, 298.9249, 43.2799>, <-18.9929, 298.1087, 43.2862> }
					triangle { <-15.7526, 302.7317, 40.02485>, <-15.856, 301.4007, 41.5211>, <-19.2409, 299.0066, 43.6181> }
					triangle { <-17.05111, 302.1514, 38.692>, <-16.828, 302.7192, 38.0929>, <-15.7526, 302.7317, 40.02485> }
					triangle { <-15.7526, 302.7317, 40.02485>, <-19.2409, 299.0066, 43.6181>, <-17.05111, 302.1514, 38.692> }
					triangle { <-19.7, 298.9249, 43.2799>, <-17.05111, 302.1514, 38.692>, <-19.2409, 299.0066, 43.6181> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-18.04012, 295.9457, 42.7141>, <-18.6708, 296.3518, 43.06554>, <-19.3929, 297.8897, 43.2661> }
					triangle { <-18.6708, 296.3518, 43.06554>, <-20.04082, 298.5685, 43.5779>, <-19.3929, 297.8897, 43.2661> }
					triangle { <-20.04082, 298.5685, 43.5779>, <-19.7, 298.9249, 43.2799>, <-19.3929, 297.8897, 43.2661> }
					triangle { <-19.3929, 297.8897, 43.2661>, <-19.7, 298.9249, 43.2799>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-20.04082, 298.5685, 43.5779>, <-23.7695, 297.0565, 41.179>, <-24.7644, 297.7965, 39.572> }
					triangle { <-24.7644, 297.7965, 39.572>, <-24.09323, 298.73, 37.7833>, <-23.4781, 298.6317, 38.369> }
					triangle { <-23.4781, 298.6317, 38.369>, <-20.04082, 298.5685, 43.5779>, <-24.7644, 297.7965, 39.572> }
					triangle { <-20.04082, 298.5685, 43.5779>, <-23.4781, 298.6317, 38.369>, <-19.7, 298.9249, 43.2799> }
					triangle { <-19.0067, 298.1644, 42.9526>, <-18.09154, 296.7639, 42.5952>, <-18.04012, 295.9457, 42.7141> }
					triangle { <-19.0067, 298.1644, 42.9526>, <-19.2683, 299.118, 42.9508>, <-18.09154, 296.7639, 42.5952> }
					triangle { <-19.0067, 298.1644, 42.9526>, <-19.7, 298.9249, 43.2799>, <-19.2683, 299.118, 42.9508> }
					triangle { <-18.04012, 295.9457, 42.7141>, <-19.7, 298.9249, 43.2799>, <-19.0067, 298.1644, 42.9526> }
					triangle { <-22.1252, 299.6739, 37.4295>, <-20.4223, 299.4375, 38.4617>, <-19.2683, 299.118, 42.9508> }
					triangle { <-23.4781, 298.6317, 38.369>, <-24.09323, 298.73, 37.7833>, <-22.1252, 299.6739, 37.4295> }
					triangle { <-22.1252, 299.6739, 37.4295>, <-19.2683, 299.118, 42.9508>, <-23.4781, 298.6317, 38.369> }
					triangle { <-19.7, 298.9249, 43.2799>, <-23.4781, 298.6317, 38.369>, <-19.2683, 299.118, 42.9508> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-8.3901, 277.7615, 45.4343>, <-9.08426, 279.6161, 44.161>, 0.2999 }
			cylinder { <-9.08426, 279.6161, 44.161>, <-9.8114, 281.5029, 42.9553>, 0.2999 }
			cylinder { <-9.8114, 281.5029, 42.9553>, <-10.5707, 283.4196, 41.8184>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.5707, 283.4196, 41.8184>, <-11.2616, 289.132, 37.723>, 0.2999 }
				cylinder { <-11.2616, 289.132, 37.723>, <-10.3238, 294.4647, 33.188>, 0.2999 }
				cylinder { <-10.3238, 294.4647, 33.188>, <-7.8136, 299.098, 28.4854>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.8136, 299.098, 28.4854>, <-7.2906, 299.3293, 27.886>, <-6.8333, 300.6236, 26.8651> }
					triangle { <-7.2906, 299.3293, 27.886>, <-6.3306, 301.1123, 26.1678>, <-6.8333, 300.6236, 26.8651> }
					triangle { <-6.3306, 301.1123, 26.1678>, <-6.6889, 301.5398, 26.3119>, <-6.8333, 300.6236, 26.8651> }
					triangle { <-6.8333, 300.6236, 26.8651>, <-6.6889, 301.5398, 26.3119>, <-7.8136, 299.098, 28.4854> }
					triangle { <-6.3306, 301.1123, 26.1678>, <-2.191, 301.2857, 28.3538>, <-1.1604, 302.7986, 29.2308> }
					triangle { <-1.1604, 302.7986, 29.2308>, <-1.7786, 304.4315, 30.4443>, <-2.4284, 304.0081, 30.08433> }
					triangle { <-2.4284, 304.0081, 30.08433>, <-6.3306, 301.1123, 26.1678>, <-1.1604, 302.7986, 29.2308> }
					triangle { <-6.3306, 301.1123, 26.1678>, <-2.4284, 304.0081, 30.08433>, <-6.6889, 301.5398, 26.3119> }
					triangle { <-7.2225, 300.9842, 27.06878>, <-7.8744, 299.8701, 28.1915>, <-7.8136, 299.098, 28.4854> }
					triangle { <-7.2225, 300.9842, 27.06878>, <-7.109, 301.8334, 26.5751>, <-7.8744, 299.8701, 28.1915> }
					triangle { <-7.2225, 300.9842, 27.06878>, <-6.6889, 301.5398, 26.3119>, <-7.109, 301.8334, 26.5751> }
					triangle { <-7.8136, 299.098, 28.4854>, <-6.6889, 301.5398, 26.3119>, <-7.2225, 300.9842, 27.06878> }
					triangle { <-3.82, 305.2622, 30.6225>, <-5.5641, 304.4104, 30.1189>, <-7.109, 301.8334, 26.5751> }
					triangle { <-2.4284, 304.0081, 30.08433>, <-1.7786, 304.4315, 30.4443>, <-3.82, 305.2622, 30.6225> }
					triangle { <-3.82, 305.2622, 30.6225>, <-7.109, 301.8334, 26.5751>, <-2.4284, 304.0081, 30.08433> }
					triangle { <-6.6889, 301.5398, 26.3119>, <-2.4284, 304.0081, 30.08433>, <-7.109, 301.8334, 26.5751> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.8136, 299.098, 28.4854>, <-7.7548, 299.3878, 27.7116>, <-7.1427, 300.6626, 26.7488> }
					triangle { <-7.7548, 299.3878, 27.7116>, <-6.9495, 301.1903, 25.9351>, <-7.1427, 300.6626, 26.7488> }
					triangle { <-6.9495, 301.1903, 25.9351>, <-6.6889, 301.5398, 26.3119>, <-7.1427, 300.6626, 26.7488> }
					triangle { <-7.1427, 300.6626, 26.7488>, <-6.6889, 301.5398, 26.3119>, <-7.8136, 299.098, 28.4854> }
					triangle { <-6.9495, 301.1903, 25.9351>, <-4.06024, 298.1441, 23.8573>, <-2.05534, 298.1458, 23.5407> }
					triangle { <-2.05534, 298.1458, 23.5407>, <-0.4182, 298.7441, 24.7586>, <-1.1797, 298.9726, 25.07334> }
					triangle { <-1.1797, 298.9726, 25.07334>, <-6.9495, 301.1903, 25.9351>, <-2.05534, 298.1458, 23.5407> }
					triangle { <-6.9495, 301.1903, 25.9351>, <-1.1797, 298.9726, 25.07334>, <-6.6889, 301.5398, 26.3119> }
					triangle { <-6.913, 300.9452, 27.185>, <-7.4102, 299.8116, 28.366>, <-7.8136, 299.098, 28.4854> }
					triangle { <-6.913, 300.9452, 27.185>, <-6.49, 301.7554, 26.8077>, <-7.4102, 299.8116, 28.366> }
					triangle { <-6.913, 300.9452, 27.185>, <-6.6889, 301.5398, 26.3119>, <-6.49, 301.7554, 26.8077> }
					triangle { <-7.8136, 299.098, 28.4854>, <-6.6889, 301.5398, 26.3119>, <-6.913, 300.9452, 27.185> }
					triangle { <-0.4854, 300.0764, 26.522>, <-2.06918, 300.5928, 27.6384>, <-6.49, 301.7554, 26.8077> }
					triangle { <-1.1797, 298.9726, 25.07334>, <-0.4182, 298.7441, 24.7586>, <-0.4854, 300.0764, 26.522> }
					triangle { <-0.4854, 300.0764, 26.522>, <-6.49, 301.7554, 26.8077>, <-1.1797, 298.9726, 25.07334> }
					triangle { <-6.6889, 301.5398, 26.3119>, <-1.1797, 298.9726, 25.07334>, <-6.49, 301.7554, 26.8077> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.8136, 299.098, 28.4854>, <-7.9825, 299.7372, 27.9862>, <-7.2945, 300.8955, 26.9319> }
					triangle { <-7.9825, 299.7372, 27.9862>, <-7.2531, 301.6562, 26.3014>, <-7.2945, 300.8955, 26.9319> }
					triangle { <-7.2531, 301.6562, 26.3014>, <-6.6889, 301.5398, 26.3119>, <-7.2945, 300.8955, 26.9319> }
					triangle { <-7.2945, 300.8955, 26.9319>, <-6.6889, 301.5398, 26.3119>, <-7.8136, 299.098, 28.4854> }
					triangle { <-7.2531, 301.6562, 26.3014>, <-9.5377, 299.6635, 22.73>, <-8.9298, 298.9782, 20.9187> }
					triangle { <-8.9298, 298.9782, 20.9187>, <-7.2, 297.9042, 20.3059>, <-7.1548, 298.1955, 21.1085> }
					triangle { <-7.1548, 298.1955, 21.1085>, <-7.2531, 301.6562, 26.3014>, <-8.9298, 298.9782, 20.9187> }
					triangle { <-7.2531, 301.6562, 26.3014>, <-7.1548, 298.1955, 21.1085>, <-6.6889, 301.5398, 26.3119> }
					triangle { <-6.7612, 300.7122, 27.00197>, <-7.1825, 299.4622, 28.09135>, <-7.8136, 299.098, 28.4854> }
					triangle { <-6.7612, 300.7122, 27.00197>, <-6.1864, 301.2896, 26.4415>, <-7.1825, 299.4622, 28.09135> }
					triangle { <-6.7612, 300.7122, 27.00197>, <-6.6889, 301.5398, 26.3119>, <-6.1864, 301.2896, 26.4415> }
					triangle { <-7.8136, 299.098, 28.4854>, <-6.6889, 301.5398, 26.3119>, <-6.7612, 300.7122, 27.00197> }
					triangle { <-5.2854, 297.7257, 21.3974>, <-4.9155, 298.075, 23.3371>, <-6.1864, 301.2896, 26.4415> }
					triangle { <-7.1548, 298.1955, 21.1085>, <-7.2, 297.9042, 20.3059>, <-5.2854, 297.7257, 21.3974> }
					triangle { <-5.2854, 297.7257, 21.3974>, <-6.1864, 301.2896, 26.4415>, <-7.1548, 298.1955, 21.1085> }
					triangle { <-6.6889, 301.5398, 26.3119>, <-7.1548, 298.1955, 21.1085>, <-6.1864, 301.2896, 26.4415> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.8136, 299.098, 28.4854>, <-7.6611, 299.8979, 28.333>, <-7.08035, 301.0027, 27.1631> }
					triangle { <-7.6611, 299.8979, 28.333>, <-6.8246, 301.8704, 26.7638>, <-7.08035, 301.0027, 27.1631> }
					triangle { <-6.8246, 301.8704, 26.7638>, <-6.6889, 301.5398, 26.3119>, <-7.08035, 301.0027, 27.1631> }
					triangle { <-7.08035, 301.0027, 27.1631>, <-6.6889, 301.5398, 26.3119>, <-7.8136, 299.098, 28.4854> }
					triangle { <-6.8246, 301.8704, 26.7638>, <-11.1049, 303.7583, 26.5193>, <-12.3478, 304.1532, 24.964> }
					triangle { <-12.3478, 304.1532, 24.964>, <-12.8151, 303.0647, 23.1981>, <-12.1521, 302.7435, 23.6322> }
					triangle { <-12.1521, 302.7435, 23.6322>, <-6.8246, 301.8704, 26.7638>, <-12.3478, 304.1532, 24.964> }
					triangle { <-6.8246, 301.8704, 26.7638>, <-12.1521, 302.7435, 23.6322>, <-6.6889, 301.5398, 26.3119> }
					triangle { <-6.9755, 300.6051, 26.7707>, <-7.5039, 299.3016, 27.7445>, <-7.8136, 299.098, 28.4854> }
					triangle { <-6.9755, 300.6051, 26.7707>, <-6.6149, 301.0753, 25.9791>, <-7.5039, 299.3016, 27.7445> }
					triangle { <-6.9755, 300.6051, 26.7707>, <-6.6889, 301.5398, 26.3119>, <-6.6149, 301.0753, 25.9791> }
					triangle { <-7.8136, 299.098, 28.4854>, <-6.6889, 301.5398, 26.3119>, <-6.9755, 300.6051, 26.7707> }
					triangle { <-11.6313, 301.4368, 22.283>, <-10.1961, 300.3131, 23.1191>, <-6.6149, 301.0753, 25.9791> }
					triangle { <-12.1521, 302.7435, 23.6322>, <-12.8151, 303.0647, 23.1981>, <-11.6313, 301.4368, 22.283> }
					triangle { <-11.6313, 301.4368, 22.283>, <-6.6149, 301.0753, 25.9791>, <-12.1521, 302.7435, 23.6322> }
					triangle { <-6.6889, 301.5398, 26.3119>, <-12.1521, 302.7435, 23.6322>, <-6.6149, 301.0753, 25.9791> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-7.8136, 299.098, 28.4854>, <-7.2271, 299.642, 28.2702>, <-6.7909, 300.8321, 27.1212> }
					triangle { <-7.2271, 299.642, 28.2702>, <-6.2458, 301.5292, 26.6799>, <-6.7909, 300.8321, 27.1212> }
					triangle { <-6.2458, 301.5292, 26.6799>, <-6.6889, 301.5398, 26.3119>, <-6.7909, 300.8321, 27.1212> }
					triangle { <-6.7909, 300.8321, 27.1212>, <-6.6889, 301.5398, 26.3119>, <-7.8136, 299.098, 28.4854> }
					triangle { <-6.2458, 301.5292, 26.6799>, <-6.4958, 304.776, 30.04758>, <-7.4736, 306.5499, 30.1787> }
					triangle { <-7.4736, 306.5499, 30.1787>, <-9.4139, 307.1598, 29.5585>, <-9.1869, 306.3901, 29.2632> }
					triangle { <-9.1869, 306.3901, 29.2632>, <-6.2458, 301.5292, 26.6799>, <-7.4736, 306.5499, 30.1787> }
					triangle { <-6.2458, 301.5292, 26.6799>, <-9.1869, 306.3901, 29.2632>, <-6.6889, 301.5398, 26.3119> }
					triangle { <-7.2648, 300.7757, 26.8126>, <-7.9379, 299.5574, 27.8074>, <-7.8136, 299.098, 28.4854> }
					triangle { <-7.2648, 300.7757, 26.8126>, <-7.1937, 301.4165, 26.06295>, <-7.9379, 299.5574, 27.8074> }
					triangle { <-7.2648, 300.7757, 26.8126>, <-6.6889, 301.5398, 26.3119>, <-7.1937, 301.4165, 26.06295> }
					triangle { <-7.8136, 299.098, 28.4854>, <-6.6889, 301.5398, 26.3119>, <-7.2648, 300.7757, 26.8126> }
					triangle { <-10.712, 306.1649, 28.07052>, <-10.6031, 304.2877, 27.3737>, <-7.1937, 301.4165, 26.06295> }
					triangle { <-9.1869, 306.3901, 29.2632>, <-9.4139, 307.1598, 29.5585>, <-10.712, 306.1649, 28.07052> }
					triangle { <-10.712, 306.1649, 28.07052>, <-7.1937, 301.4165, 26.06295>, <-9.1869, 306.3901, 29.2632> }
					triangle { <-6.6889, 301.5398, 26.3119>, <-9.1869, 306.3901, 29.2632>, <-7.1937, 301.4165, 26.06295> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-10.5707, 283.4196, 41.8184>, <-11.2588, 285.3391, 40.6419>, 0.2999 }
			cylinder { <-11.2588, 285.3391, 40.6419>, <-11.8746, 287.2594, 39.427>, 0.2999 }
			cylinder { <-11.8746, 287.2594, 39.427>, <-12.4175, 289.178, 38.1754>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-12.4175, 289.178, 38.1754>, <-15.544, 294.1007, 34.191>, 0.2999 }
				cylinder { <-15.544, 294.1007, 34.191>, <-19.9807, 297.8952, 30.2161>, 0.2999 }
				cylinder { <-19.9807, 297.8952, 30.2161>, <-25.4618, 300.3341, 26.4889>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-25.4618, 300.3341, 26.4889>, <-26.2787, 300.3455, 26.3515>, <-27.5132, 301.0121, 25.3726> }
					triangle { <-26.2787, 300.3455, 26.3515>, <-28.4253, 301.1833, 25.03118>, <-27.5132, 301.0121, 25.3726> }
					triangle { <-28.4253, 301.1833, 25.03118>, <-28.1447, 301.5279, 24.6645>, <-27.5132, 301.0121, 25.3726> }
					triangle { <-27.5132, 301.0121, 25.3726>, <-28.1447, 301.5279, 24.6645>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-28.4253, 301.1833, 25.03118>, <-29.2942, 296.9057, 23.3304>, <-29.4312, 296.1781, 21.4405> }
					triangle { <-29.4312, 296.1781, 21.4405>, <-28.3057, 296.5623, 19.6778>, <-28.134, 297.103, 20.3175> }
					triangle { <-28.134, 297.103, 20.3175>, <-28.4253, 301.1833, 25.03118>, <-29.4312, 296.1781, 21.4405> }
					triangle { <-28.4253, 301.1833, 25.03118>, <-28.134, 297.103, 20.3175>, <-28.1447, 301.5279, 24.6645> }
					triangle { <-27.1591, 301.3241, 25.05605>, <-25.7475, 300.8134, 25.8765>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-27.1591, 301.3241, 25.05605>, <-27.7171, 301.8071, 24.3979>, <-25.7475, 300.8134, 25.8765> }
					triangle { <-27.1591, 301.3241, 25.05605>, <-28.1447, 301.5279, 24.6645>, <-27.7171, 301.8071, 24.3979> }
					triangle { <-25.4618, 300.3341, 26.4889>, <-28.1447, 301.5279, 24.6645>, <-27.1591, 301.3241, 25.05605> }
					triangle { <-27.01149, 298.3096, 19.2768>, <-26.2252, 299.609, 20.5862>, <-27.7171, 301.8071, 24.3979> }
					triangle { <-28.134, 297.103, 20.3175>, <-28.3057, 296.5623, 19.6778>, <-27.01149, 298.3096, 19.2768> }
					triangle { <-27.01149, 298.3096, 19.2768>, <-27.7171, 301.8071, 24.3979>, <-28.134, 297.103, 20.3175> }
					triangle { <-28.1447, 301.5279, 24.6645>, <-28.134, 297.103, 20.3175>, <-27.7171, 301.8071, 24.3979> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-25.4618, 300.3341, 26.4889>, <-26.1358, 300.8141, 26.448>, <-27.418, 301.3246, 25.437> }
					triangle { <-26.1358, 300.8141, 26.448>, <-28.2348, 301.8081, 25.1598>, <-27.418, 301.3246, 25.437> }
					triangle { <-28.2348, 301.8081, 25.1598>, <-28.1447, 301.5279, 24.6645>, <-27.418, 301.3246, 25.437> }
					triangle { <-27.418, 301.3246, 25.437>, <-28.1447, 301.5279, 24.6645>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-28.2348, 301.8081, 25.1598>, <-31.2589, 299.6709, 28.02899>, <-32.7401, 298.3207, 27.7084> }
					triangle { <-32.7401, 298.3207, 27.7084>, <-32.8734, 296.6232, 26.4348>, <-32.1875, 297.1108, 26.2836> }
					triangle { <-32.1875, 297.1108, 26.2836>, <-28.2348, 301.8081, 25.1598>, <-32.7401, 298.3207, 27.7084> }
					triangle { <-28.2348, 301.8081, 25.1598>, <-32.1875, 297.1108, 26.2836>, <-28.1447, 301.5279, 24.6645> }
					triangle { <-27.2544, 301.0117, 24.9917>, <-25.8904, 300.3447, 25.7801>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-27.2544, 301.0117, 24.9917>, <-27.9077, 301.1823, 24.2692>, <-25.8904, 300.3447, 25.7801> }
					triangle { <-27.2544, 301.0117, 24.9917>, <-28.1447, 301.5279, 24.6645>, <-27.9077, 301.1823, 24.2692> }
					triangle { <-25.4618, 300.3341, 26.4889>, <-28.1447, 301.5279, 24.6645>, <-27.2544, 301.0117, 24.9917> }
					triangle { <-31.6225, 296.1823, 24.6657>, <-29.8413, 296.9589, 24.1698>, <-27.9077, 301.1823, 24.2692> }
					triangle { <-32.1875, 297.1108, 26.2836>, <-32.8734, 296.6232, 26.4348>, <-31.6225, 296.1823, 24.6657> }
					triangle { <-31.6225, 296.1823, 24.6657>, <-27.9077, 301.1823, 24.2692>, <-32.1875, 297.1108, 26.2836> }
					triangle { <-28.1447, 301.5279, 24.6645>, <-32.1875, 297.1108, 26.2836>, <-27.9077, 301.1823, 24.2692> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-25.4618, 300.3341, 26.4889>, <-25.8245, 300.9606, 26.0861>, <-27.2104, 301.4222, 25.1957> }
					triangle { <-25.8245, 300.9606, 26.0861>, <-27.8197, 302.0034, 24.6772>, <-27.2104, 301.4222, 25.1957> }
					triangle { <-27.8197, 302.0034, 24.6772>, <-28.1447, 301.5279, 24.6645>, <-27.2104, 301.4222, 25.1957> }
					triangle { <-27.2104, 301.4222, 25.1957>, <-28.1447, 301.5279, 24.6645>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-27.8197, 302.0034, 24.6772>, <-28.949, 304.985, 28.1094>, <-30.6493, 305.2696, 29.1807> }
					triangle { <-30.6493, 305.2696, 29.1807>, <-32.06022, 303.9103, 30.00719>, <-31.4989, 303.5408, 29.4784> }
					triangle { <-31.4989, 303.5408, 29.4784>, <-27.8197, 302.0034, 24.6772>, <-30.6493, 305.2696, 29.1807> }
					triangle { <-27.8197, 302.0034, 24.6772>, <-31.4989, 303.5408, 29.4784>, <-28.1447, 301.5279, 24.6645> }
					triangle { <-27.4619, 300.914, 25.233>, <-26.2017, 300.1982, 26.142>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-27.4619, 300.914, 25.233>, <-28.3227, 300.9869, 24.7518>, <-26.2017, 300.1982, 26.142> }
					triangle { <-27.4619, 300.914, 25.233>, <-28.1447, 301.5279, 24.6645>, <-28.3227, 300.9869, 24.7518> }
					triangle { <-25.4618, 300.3341, 26.4889>, <-28.1447, 301.5279, 24.6645>, <-27.4619, 300.914, 25.233> }
					triangle { <-32.3679, 301.7966, 29.4355>, <-31.1286, 300.5803, 28.4325>, <-28.3227, 300.9869, 24.7518> }
					triangle { <-31.4989, 303.5408, 29.4784>, <-32.06022, 303.9103, 30.00719>, <-32.3679, 301.7966, 29.4355> }
					triangle { <-32.3679, 301.7966, 29.4355>, <-28.3227, 300.9869, 24.7518>, <-31.4989, 303.5408, 29.4784> }
					triangle { <-28.1447, 301.5279, 24.6645>, <-31.4989, 303.5408, 29.4784>, <-28.3227, 300.9869, 24.7518> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-25.4618, 300.3341, 26.4889>, <-25.7721, 300.5839, 25.7625>, <-27.1755, 301.1711, 24.98> }
					triangle { <-25.7721, 300.5839, 25.7625>, <-27.7499, 301.5011, 24.2458>, <-27.1755, 301.1711, 24.98> }
					triangle { <-27.7499, 301.5011, 24.2458>, <-28.1447, 301.5279, 24.6645>, <-27.1755, 301.1711, 24.98> }
					triangle { <-27.1755, 301.1711, 24.98>, <-28.1447, 301.5279, 24.6645>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-27.7499, 301.5011, 24.2458>, <-25.5351, 305.5538, 23.4613>, <-26.0287, 307.4865, 23.8364> }
					triangle { <-26.0287, 307.4865, 23.8364>, <-26.9823, 308.421, 25.4913>, <-27.01343, 307.5669, 25.5166> }
					triangle { <-27.01343, 307.5669, 25.5166>, <-27.7499, 301.5011, 24.2458>, <-26.0287, 307.4865, 23.8364> }
					triangle { <-27.7499, 301.5011, 24.2458>, <-27.01343, 307.5669, 25.5166>, <-28.1447, 301.5279, 24.6645> }
					triangle { <-27.4968, 301.1652, 25.4487>, <-26.2541, 300.575, 26.4655>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-27.4968, 301.1652, 25.4487>, <-28.3926, 301.4893, 25.1832>, <-26.2541, 300.575, 26.4655> }
					triangle { <-27.4968, 301.1652, 25.4487>, <-28.1447, 301.5279, 24.6645>, <-28.3926, 301.4893, 25.1832> }
					triangle { <-25.4618, 300.3341, 26.4889>, <-28.1447, 301.5279, 24.6645>, <-27.4968, 301.1652, 25.4487> }
					triangle { <-28.2245, 307.446, 27.03905>, <-28.3201, 305.5024, 27.5231>, <-28.3926, 301.4893, 25.1832> }
					triangle { <-27.01343, 307.5669, 25.5166>, <-26.9823, 308.421, 25.4913>, <-28.2245, 307.446, 27.03905> }
					triangle { <-28.2245, 307.446, 27.03905>, <-28.3926, 301.4893, 25.1832>, <-27.01343, 307.5669, 25.5166> }
					triangle { <-28.1447, 301.5279, 24.6645>, <-27.01343, 307.5669, 25.5166>, <-28.3926, 301.4893, 25.1832> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-25.4618, 300.3341, 26.4889>, <-26.0571, 300.1979, 25.929>, <-27.3655, 300.9138, 25.09105> }
					triangle { <-26.0571, 300.1979, 25.929>, <-28.1298, 300.9866, 24.4679>, <-27.3655, 300.9138, 25.09105> }
					triangle { <-28.1298, 300.9866, 24.4679>, <-28.1447, 301.5279, 24.6645>, <-27.3655, 300.9138, 25.09105> }
					triangle { <-27.3655, 300.9138, 25.09105>, <-28.1447, 301.5279, 24.6645>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-28.1298, 300.9866, 24.4679>, <-25.7517, 300.4851, 20.4631>, <-25.2645, 301.7829, 18.9805> }
					triangle { <-25.2645, 301.7829, 18.9805>, <-24.6269, 303.8112, 19.01108>, <-24.9024, 303.5281, 19.7694> }
					triangle { <-24.9024, 303.5281, 19.7694>, <-28.1298, 300.9866, 24.4679>, <-25.2645, 301.7829, 18.9805> }
					triangle { <-28.1298, 300.9866, 24.4679>, <-24.9024, 303.5281, 19.7694>, <-28.1447, 301.5279, 24.6645> }
					triangle { <-27.3069, 301.4224, 25.3376>, <-25.9692, 300.9609, 26.299>, <-25.4618, 300.3341, 26.4889> }
					triangle { <-27.3069, 301.4224, 25.3376>, <-28.01267, 302.0038, 24.9611>, <-25.9692, 300.9609, 26.299> }
					triangle { <-27.3069, 301.4224, 25.3376>, <-28.1447, 301.5279, 24.6645>, <-28.01267, 302.0038, 24.9611> }
					triangle { <-25.4618, 300.3341, 26.4889>, <-28.1447, 301.5279, 24.6645>, <-27.3069, 301.4224, 25.3376> }
					triangle { <-24.8641, 305.2584, 20.6658>, <-25.2439, 304.8931, 22.6006>, <-28.01267, 302.0038, 24.9611> }
					triangle { <-24.9024, 303.5281, 19.7694>, <-24.6269, 303.8112, 19.01108>, <-24.8641, 305.2584, 20.6658> }
					triangle { <-24.8641, 305.2584, 20.6658>, <-28.01267, 302.0038, 24.9611>, <-24.9024, 303.5281, 19.7694> }
					triangle { <-28.1447, 301.5279, 24.6645>, <-24.9024, 303.5281, 19.7694>, <-28.01267, 302.0038, 24.9611> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-12.4175, 289.178, 38.1754>, <-13.03515, 291.0658, 36.9115>, 0.2999 }
			cylinder { <-13.03515, 291.0658, 36.9115>, <-13.7266, 292.9205, 35.6369>, 0.2999 }
			cylinder { <-13.7266, 292.9205, 35.6369>, <-14.4912, 294.7398, 34.3531>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-14.4912, 294.7398, 34.3531>, <-16.02984, 301.1233, 31.7519>, 0.2999 }
				cylinder { <-16.02984, 301.1233, 31.7519>, <-16.721, 308.0498, 30.5567>, 0.2999 }
				cylinder { <-16.721, 308.0498, 30.5567>, <-16.5234, 315.1042, 30.8391>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-16.5234, 315.1042, 30.8391>, <-16.2941, 315.8578, 31.09552>, <-16.629, 317.5305, 30.9655> }
					triangle { <-16.2941, 315.8578, 31.09552>, <-16.5392, 318.5021, 31.1255>, <-16.629, 317.5305, 30.9655> }
					triangle { <-16.5392, 318.5021, 31.1255>, <-16.9835, 318.5296, 30.7598>, <-16.629, 317.5305, 30.9655> }
					triangle { <-16.629, 317.5305, 30.9655>, <-16.9835, 318.5296, 30.7598>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-16.5392, 318.5021, 31.1255>, <-17.7899, 318.5343, 35.6399>, <-19.4504, 319.1938, 36.6029> }
					triangle { <-19.4504, 319.1938, 36.6029>, <-21.5175, 319.096, 36.1144>, <-21.00327, 318.8635, 35.4721> }
					triangle { <-21.00327, 318.8635, 35.4721>, <-16.5392, 318.5021, 31.1255>, <-19.4504, 319.1938, 36.6029> }
					triangle { <-16.5392, 318.5021, 31.1255>, <-21.00327, 318.8635, 35.4721>, <-16.9835, 318.5296, 30.7598> }
					triangle { <-17.06073, 317.4641, 30.6019>, <-16.9417, 315.7582, 30.5502>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-17.06073, 317.4641, 30.6019>, <-17.4026, 318.3693, 30.3984>, <-16.9417, 315.7582, 30.5502> }
					triangle { <-17.06073, 317.4641, 30.6019>, <-16.9835, 318.5296, 30.7598>, <-17.4026, 318.3693, 30.3984> }
					triangle { <-16.5234, 315.1042, 30.8391>, <-16.9835, 318.5296, 30.7598>, <-17.06073, 317.4641, 30.6019> }
					triangle { <-22.4004, 318.7401, 34.1187>, <-21.5313, 317.9587, 32.4891>, <-17.4026, 318.3693, 30.3984> }
					triangle { <-21.00327, 318.8635, 35.4721>, <-21.5175, 319.096, 36.1144>, <-22.4004, 318.7401, 34.1187> }
					triangle { <-22.4004, 318.7401, 34.1187>, <-17.4026, 318.3693, 30.3984>, <-21.00327, 318.8635, 35.4721> }
					triangle { <-16.9835, 318.5296, 30.7598>, <-21.00327, 318.8635, 35.4721>, <-17.4026, 318.3693, 30.3984> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-16.5234, 315.1042, 30.8391>, <-16.2588, 315.851, 30.5974>, <-16.6054, 317.5259, 30.6334> }
					triangle { <-16.2588, 315.851, 30.5974>, <-16.492, 318.4931, 30.4614>, <-16.6054, 317.5259, 30.6334> }
					triangle { <-16.492, 318.4931, 30.4614>, <-16.9835, 318.5296, 30.7598>, <-16.6054, 317.5259, 30.6334> }
					triangle { <-16.6054, 317.5259, 30.6334>, <-16.9835, 318.5296, 30.7598>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-16.492, 318.4931, 30.4614>, <-12.645, 319.1653, 33.04869>, <-12.3233, 320.1098, 34.8162> }
					triangle { <-12.3233, 320.1098, 34.8162>, <-13.4508, 320.1912, 36.6172>, <-13.8728, 319.8327, 35.9657> }
					triangle { <-13.8728, 319.8327, 35.9657>, <-16.492, 318.4931, 30.4614>, <-12.3233, 320.1098, 34.8162> }
					triangle { <-16.492, 318.4931, 30.4614>, <-13.8728, 319.8327, 35.9657>, <-16.9835, 318.5296, 30.7598> }
					triangle { <-17.08433, 317.4686, 30.934>, <-16.9771, 315.765, 31.04825>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-17.08433, 317.4686, 30.934>, <-17.4498, 318.3784, 31.06253>, <-16.9771, 315.765, 31.04825> }
					triangle { <-17.08433, 317.4686, 30.934>, <-16.9835, 318.5296, 30.7598>, <-17.4498, 318.3784, 31.06253> }
					triangle { <-16.5234, 315.1042, 30.8391>, <-16.9835, 318.5296, 30.7598>, <-17.08433, 317.4686, 30.934> }
					triangle { <-15.5958, 319.7178, 36.8698>, <-16.7955, 318.6681, 35.6531>, <-17.4498, 318.3784, 31.06253> }
					triangle { <-13.8728, 319.8327, 35.9657>, <-13.4508, 320.1912, 36.6172>, <-15.5958, 319.7178, 36.8698> }
					triangle { <-15.5958, 319.7178, 36.8698>, <-17.4498, 318.3784, 31.06253>, <-13.8728, 319.8327, 35.9657> }
					triangle { <-16.9835, 318.5296, 30.7598>, <-13.8728, 319.8327, 35.9657>, <-17.4498, 318.3784, 31.06253> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-16.5234, 315.1042, 30.8391>, <-16.7164, 315.7852, 30.4088>, <-16.9105, 317.482, 30.5077> }
					triangle { <-16.7164, 315.7852, 30.4088>, <-17.1022, 318.4053, 30.2099>, <-16.9105, 317.482, 30.5077> }
					triangle { <-17.1022, 318.4053, 30.2099>, <-16.9835, 318.5296, 30.7598>, <-16.9105, 317.482, 30.5077> }
					triangle { <-16.9105, 317.482, 30.5077>, <-16.9835, 318.5296, 30.7598>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-17.1022, 318.4053, 30.2099>, <-13.4553, 318.9237, 27.3156>, <-11.7487, 320.016, 27.4347> }
					triangle { <-11.7487, 320.016, 27.4347>, <-10.4235, 320.4225, 29.04712>, <-11.1507, 320.0437, 29.2896> }
					triangle { <-11.1507, 320.0437, 29.2896>, <-17.1022, 318.4053, 30.2099>, <-11.7487, 320.016, 27.4347> }
					triangle { <-17.1022, 318.4053, 30.2099>, <-11.1507, 320.0437, 29.2896>, <-16.9835, 318.5296, 30.7598> }
					triangle { <-16.7792, 317.5125, 31.05979>, <-16.5195, 315.8308, 31.2369>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-16.7792, 317.5125, 31.05979>, <-16.8396, 318.4661, 31.314>, <-16.5195, 315.8308, 31.2369> }
					triangle { <-16.7792, 317.5125, 31.05979>, <-16.9835, 318.5296, 30.7598>, <-16.8396, 318.4661, 31.314> }
					triangle { <-16.5234, 315.1042, 30.8391>, <-16.9835, 318.5296, 30.7598>, <-16.7792, 317.5125, 31.05979> }
					triangle { <-10.8517, 320.2239, 31.2072>, <-12.3177, 319.1873, 32.1003>, <-16.8396, 318.4661, 31.314> }
					triangle { <-11.1507, 320.0437, 29.2896>, <-10.4235, 320.4225, 29.04712>, <-10.8517, 320.2239, 31.2072> }
					triangle { <-10.8517, 320.2239, 31.2072>, <-16.8396, 318.4661, 31.314>, <-11.1507, 320.0437, 29.2896> }
					triangle { <-16.9835, 318.5296, 30.7598>, <-11.1507, 320.0437, 29.2896>, <-16.8396, 318.4661, 31.314> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-16.5234, 315.1042, 30.8391>, <-17.03891, 315.7507, 30.7884>, <-17.1255, 317.459, 30.7608> }
					triangle { <-17.03891, 315.7507, 30.7884>, <-17.5321, 318.3593, 30.7161>, <-17.1255, 317.459, 30.7608> }
					triangle { <-17.5321, 318.3593, 30.7161>, <-16.9835, 318.5296, 30.7598>, <-17.1255, 317.459, 30.7608> }
					triangle { <-17.1255, 317.459, 30.7608>, <-16.9835, 318.5296, 30.7598>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-17.5321, 318.3593, 30.7161>, <-19.1086, 318.1411, 26.3102>, <-18.5153, 319.0413, 24.5904> }
					triangle { <-18.5153, 319.0413, 24.5904>, <-16.591, 319.4725, 23.7951>, <-16.5733, 319.2069, 24.6077> }
					triangle { <-16.5733, 319.2069, 24.6077>, <-17.5321, 318.3593, 30.7161>, <-18.5153, 319.0413, 24.5904> }
					triangle { <-17.5321, 318.3593, 30.7161>, <-16.5733, 319.2069, 24.6077>, <-16.9835, 318.5296, 30.7598> }
					triangle { <-16.5642, 317.5355, 30.8066>, <-16.197, 315.8654, 30.8572>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-16.5642, 317.5355, 30.8066>, <-16.4096, 318.5122, 30.8078>, <-16.197, 315.8654, 30.8572> }
					triangle { <-16.5642, 317.5355, 30.8066>, <-16.9835, 318.5296, 30.7598>, <-16.4096, 318.5122, 30.8078> }
					triangle { <-16.5234, 315.1042, 30.8391>, <-16.9835, 318.5296, 30.7598>, <-16.5642, 317.5355, 30.8066> }
					triangle { <-14.6801, 319.5637, 24.9037>, <-14.2444, 318.8036, 26.7075>, <-16.4096, 318.5122, 30.8078> }
					triangle { <-16.5733, 319.2069, 24.6077>, <-16.591, 319.4725, 23.7951>, <-14.6801, 319.5637, 24.9037> }
					triangle { <-14.6801, 319.5637, 24.9037>, <-16.4096, 318.5122, 30.8078>, <-16.5733, 319.2069, 24.6077> }
					triangle { <-16.9835, 318.5296, 30.7598>, <-16.5733, 319.2069, 24.6077>, <-16.4096, 318.5122, 30.8078> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-16.5234, 315.1042, 30.8391>, <-16.774, 315.7962, 31.2193>, <-16.9489, 317.4894, 31.04804> }
					triangle { <-16.774, 315.7962, 31.2193>, <-17.179, 318.42, 31.2906>, <-16.9489, 317.4894, 31.04804> }
					triangle { <-17.179, 318.42, 31.2906>, <-16.9835, 318.5296, 30.7598>, <-16.9489, 317.4894, 31.04804> }
					triangle { <-16.9489, 317.4894, 31.04804>, <-16.9835, 318.5296, 30.7598>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-17.179, 318.42, 31.2906>, <-21.8279, 317.8968, 31.5325>, <-23.3471, 318.5255, 30.3423> }
					triangle { <-23.3471, 318.5255, 30.3423>, <-23.551, 318.6403, 28.2289>, <-22.7544, 318.4665, 28.4864> }
					triangle { <-22.7544, 318.4665, 28.4864>, <-17.179, 318.42, 31.2906>, <-23.3471, 318.5255, 30.3423> }
					triangle { <-17.179, 318.42, 31.2906>, <-22.7544, 318.4665, 28.4864>, <-16.9835, 318.5296, 30.7598> }
					triangle { <-16.7408, 317.5051, 30.5194>, <-16.4619, 315.8198, 30.4264>, <-16.5234, 315.1042, 30.8391> }
					triangle { <-16.7408, 317.5051, 30.5194>, <-16.7628, 318.4514, 30.2334>, <-16.4619, 315.8198, 30.4264> }
					triangle { <-16.7408, 317.5051, 30.5194>, <-16.9835, 318.5296, 30.7598>, <-16.7628, 318.4514, 30.2334> }
					triangle { <-16.5234, 315.1042, 30.8391>, <-16.9835, 318.5296, 30.7598>, <-16.7408, 317.5051, 30.5194> }
					triangle { <-21.9253, 318.6328, 26.7302>, <-20.02469, 318.0329, 26.9514>, <-16.7628, 318.4514, 30.2334> }
					triangle { <-22.7544, 318.4665, 28.4864>, <-23.551, 318.6403, 28.2289>, <-21.9253, 318.6328, 26.7302> }
					triangle { <-21.9253, 318.6328, 26.7302>, <-16.7628, 318.4514, 30.2334>, <-22.7544, 318.4665, 28.4864> }
					triangle { <-16.9835, 318.5296, 30.7598>, <-22.7544, 318.4665, 28.4864>, <-16.7628, 318.4514, 30.2334> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-14.4912, 294.7398, 34.3531>, <-15.2193, 296.6097, 33.122>, 0.2999 }
			cylinder { <-15.2193, 296.6097, 33.122>, <-15.9099, 298.5281, 31.945>, 0.2999 }
			cylinder { <-15.9099, 298.5281, 31.945>, <-16.5624, 300.4926, 30.8237>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-16.5624, 300.4926, 30.8237>, <-18.01883, 305.5009, 26.06143>, 0.2999 }
				cylinder { <-18.01883, 305.5009, 26.06143>, <-18.8867, 309.3237, 20.1864>, 0.2999 }
				cylinder { <-18.8867, 309.3237, 20.1864>, <-19.1142, 311.7318, 13.5507>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-19.1142, 311.7318, 13.5507>, <-19.227, 311.5107, 12.7962>, <-19.3367, 312.0527, 11.252> }
					triangle { <-19.227, 311.5107, 12.7962>, <-19.4478, 312.0195, 10.311>, <-19.3367, 312.0527, 11.252> }
					triangle { <-19.4478, 312.0195, 10.311>, <-19.3764, 312.5656, 10.3534>, <-19.3367, 312.0527, 11.252> }
					triangle { <-19.3367, 312.0527, 11.252>, <-19.3764, 312.5656, 10.3534>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-19.4478, 312.0195, 10.311>, <-15.6925, 309.7635, 9.3204>, <-14.02151, 310.2905, 8.4735> }
					triangle { <-14.02151, 310.2905, 8.4735>, <-12.8783, 311.9713, 8.6298>, <-13.6116, 312.0391, 8.99> }
					triangle { <-13.6116, 312.0391, 8.99>, <-19.4478, 312.0195, 10.311>, <-14.02151, 310.2905, 8.4735> }
					triangle { <-19.4478, 312.0195, 10.311>, <-13.6116, 312.0391, 8.99>, <-19.3764, 312.5656, 10.3534> }
					triangle { <-19.2581, 312.576, 11.382>, <-19.1092, 312.2956, 12.9912>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-19.2581, 312.576, 11.382>, <-19.2907, 313.0661, 10.571>, <-19.1092, 312.2956, 12.9912> }
					triangle { <-19.2581, 312.576, 11.382>, <-19.3764, 312.5656, 10.3534>, <-19.2907, 313.0661, 10.571> }
					triangle { <-19.1142, 311.7318, 13.5507>, <-19.3764, 312.5656, 10.3534>, <-19.2581, 312.576, 11.382> }
					triangle { <-13.4847, 313.8661, 9.362>, <-15.0118, 314.2984, 10.4473>, <-19.2907, 313.0661, 10.571> }
					triangle { <-13.6116, 312.0391, 8.99>, <-12.8783, 311.9713, 8.6298>, <-13.4847, 313.8661, 9.362> }
					triangle { <-13.4847, 313.8661, 9.362>, <-19.2907, 313.0661, 10.571>, <-13.6116, 312.0391, 8.99> }
					triangle { <-19.3764, 312.5656, 10.3534>, <-13.6116, 312.0391, 8.99>, <-19.2907, 313.0661, 10.571> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.1142, 311.7318, 13.5507>, <-19.5693, 311.8267, 12.9067>, <-19.5649, 312.2634, 11.3256> }
					triangle { <-19.5693, 311.8267, 12.9067>, <-19.9042, 312.4408, 10.4583>, <-19.5649, 312.2634, 11.3256> }
					triangle { <-19.9042, 312.4408, 10.4583>, <-19.3764, 312.5656, 10.3534>, <-19.5649, 312.2634, 11.3256> }
					triangle { <-19.5649, 312.2634, 11.3256>, <-19.3764, 312.5656, 10.3534>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-19.9042, 312.4408, 10.4583>, <-21.03418, 308.2348, 9.36>, <-20.274, 306.9471, 8.1145> }
					triangle { <-20.274, 306.9471, 8.1145>, <-18.3485, 306.4704, 7.6439>, <-18.4155, 307.1433, 8.1073> }
					triangle { <-18.4155, 307.1433, 8.1073>, <-19.9042, 312.4408, 10.4583>, <-20.274, 306.9471, 8.1145> }
					triangle { <-19.9042, 312.4408, 10.4583>, <-18.4155, 307.1433, 8.1073>, <-19.3764, 312.5656, 10.3534> }
					triangle { <-19.02997, 312.3653, 11.3083>, <-18.7668, 311.9796, 12.8808>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-19.02997, 312.3653, 11.3083>, <-18.8343, 312.6447, 10.4237>, <-18.7668, 311.9796, 12.8808> }
					triangle { <-19.02997, 312.3653, 11.3083>, <-19.3764, 312.5656, 10.3534>, <-18.8343, 312.6447, 10.4237> }
					triangle { <-19.1142, 311.7318, 13.5507>, <-19.3764, 312.5656, 10.3534>, <-19.02997, 312.3653, 11.3083> }
					triangle { <-16.6184, 307.6439, 7.9963>, <-16.3978, 309.1186, 9.2101>, <-18.8343, 312.6447, 10.4237> }
					triangle { <-18.4155, 307.1433, 8.1073>, <-18.3485, 306.4704, 7.6439>, <-16.6184, 307.6439, 7.9963> }
					triangle { <-16.6184, 307.6439, 7.9963>, <-18.8343, 312.6447, 10.4237>, <-18.4155, 307.1433, 8.1073> }
					triangle { <-19.3764, 312.5656, 10.3534>, <-18.4155, 307.1433, 8.1073>, <-18.8343, 312.6447, 10.4237> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.1142, 311.7318, 13.5507>, <-19.3609, 312.2476, 12.9994>, <-19.4259, 312.544, 11.3874> }
					triangle { <-19.3609, 312.2476, 12.9994>, <-19.6263, 313.0021, 10.5819>, <-19.4259, 312.544, 11.3874> }
					triangle { <-19.6263, 313.0021, 10.5819>, <-19.3764, 312.5656, 10.3534>, <-19.4259, 312.544, 11.3874> }
					triangle { <-19.4259, 312.544, 11.3874>, <-19.3764, 312.5656, 10.3534>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-19.6263, 313.0021, 10.5819>, <-24.1004, 312.6508, 10.7631>, <-25.3833, 311.5982, 9.7466> }
					triangle { <-25.3833, 311.5982, 9.7466>, <-25.3382, 309.681, 9.05465>, <-24.6174, 309.9413, 9.3458> }
					triangle { <-24.6174, 309.9413, 9.3458>, <-19.6263, 313.0021, 10.5819>, <-25.3833, 311.5982, 9.7466> }
					triangle { <-19.6263, 313.0021, 10.5819>, <-24.6174, 309.9413, 9.3458>, <-19.3764, 312.5656, 10.3534> }
					triangle { <-19.1689, 312.0847, 11.2466>, <-18.9753, 311.5587, 12.7881>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-19.1689, 312.0847, 11.2466>, <-19.1122, 312.0835, 10.3002>, <-18.9753, 311.5587, 12.7881> }
					triangle { <-19.1689, 312.0847, 11.2466>, <-19.3764, 312.5656, 10.3534>, <-19.1122, 312.0835, 10.3002> }
					triangle { <-19.1142, 311.7318, 13.5507>, <-19.3764, 312.5656, 10.3534>, <-19.1689, 312.0847, 11.2466> }
					triangle { <-23.6266, 308.4597, 8.784>, <-21.8724, 308.6703, 9.5423>, <-19.1122, 312.0835, 10.3002> }
					triangle { <-24.6174, 309.9413, 9.3458>, <-25.3382, 309.681, 9.05465>, <-23.6266, 308.4597, 8.784> }
					triangle { <-23.6266, 308.4597, 8.784>, <-19.1122, 312.0835, 10.3002>, <-24.6174, 309.9413, 9.3458> }
					triangle { <-19.3764, 312.5656, 10.3534>, <-24.6174, 309.9413, 9.3458>, <-19.1122, 312.0835, 10.3002> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.1142, 311.7318, 13.5507>, <-18.8878, 312.1957, 12.947>, <-19.1106, 312.5094, 11.3525> }
					triangle { <-18.8878, 312.1957, 12.947>, <-18.9956, 312.9329, 10.5121>, <-19.1106, 312.5094, 11.3525> }
					triangle { <-18.9956, 312.9329, 10.5121>, <-19.3764, 312.5656, 10.3534>, <-19.1106, 312.5094, 11.3525> }
					triangle { <-19.1106, 312.5094, 11.3525>, <-19.3764, 312.5656, 10.3534>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-18.9956, 312.9329, 10.5121>, <-20.6824, 316.9499, 11.6039>, <-22.3361, 317.8594, 11.1295> }
					triangle { <-22.3361, 317.8594, 11.1295>, <-24.2531, 317.1961, 10.9255>, <-23.7043, 316.5924, 11.00548> }
					triangle { <-23.7043, 316.5924, 11.00548>, <-18.9956, 312.9329, 10.5121>, <-22.3361, 317.8594, 11.1295> }
					triangle { <-18.9956, 312.9329, 10.5121>, <-23.7043, 316.5924, 11.00548>, <-19.3764, 312.5656, 10.3534> }
					triangle { <-19.4842, 312.1193, 11.2814>, <-19.4483, 311.6106, 12.8404>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-19.4842, 312.1193, 11.2814>, <-19.7429, 312.1527, 10.3699>, <-19.4483, 311.6106, 12.8404> }
					triangle { <-19.4842, 312.1193, 11.2814>, <-19.3764, 312.5656, 10.3534>, <-19.7429, 312.1527, 10.3699> }
					triangle { <-19.1142, 311.7318, 13.5507>, <-19.3764, 312.5656, 10.3534>, <-19.4842, 312.1193, 11.2814> }
					triangle { <-24.8897, 315.1937, 10.6438>, <-23.921, 313.5689, 10.9879>, <-19.7429, 312.1527, 10.3699> }
					triangle { <-23.7043, 316.5924, 11.00548>, <-24.2531, 317.1961, 10.9255>, <-24.8897, 315.1937, 10.6438> }
					triangle { <-24.8897, 315.1937, 10.6438>, <-19.7429, 312.1527, 10.3699>, <-23.7043, 316.5924, 11.00548> }
					triangle { <-19.3764, 312.5656, 10.3534>, <-23.7043, 316.5924, 11.00548>, <-19.7429, 312.1527, 10.3699> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.1142, 311.7318, 13.5507>, <-18.8038, 311.7334, 12.8196>, <-19.05461, 312.2012, 11.2676> }
					triangle { <-18.8038, 311.7334, 12.8196>, <-18.8836, 312.3165, 10.3422>, <-19.05461, 312.2012, 11.2676> }
					triangle { <-18.8836, 312.3165, 10.3422>, <-19.3764, 312.5656, 10.3534>, <-19.05461, 312.2012, 11.2676> }
					triangle { <-19.05461, 312.2012, 11.2676>, <-19.3764, 312.5656, 10.3534>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-18.8836, 312.3165, 10.3422>, <-15.4076, 315.1385, 10.6988>, <-15.2082, 317.039, 10.3308> }
					triangle { <-15.2082, 317.039, 10.3308>, <-16.4362, 318.6329, 10.6589>, <-16.7996, 317.9085, 10.7823> }
					triangle { <-16.7996, 317.9085, 10.7823>, <-18.8836, 312.3165, 10.3422>, <-15.2082, 317.039, 10.3308> }
					triangle { <-18.8836, 312.3165, 10.3422>, <-16.7996, 317.9085, 10.7823>, <-19.3764, 312.5656, 10.3534> }
					triangle { <-19.5402, 312.4275, 11.3664>, <-19.5323, 312.0729, 12.9679>, <-19.1142, 311.7318, 13.5507> }
					triangle { <-19.5402, 312.4275, 11.3664>, <-19.8549, 312.7691, 10.5399>, <-19.5323, 312.0729, 12.9679> }
					triangle { <-19.5402, 312.4275, 11.3664>, <-19.3764, 312.5656, 10.3534>, <-19.8549, 312.7691, 10.5399> }
					triangle { <-19.1142, 311.7318, 13.5507>, <-19.3764, 312.5656, 10.3534>, <-19.5402, 312.4275, 11.3664> }
					triangle { <-18.527, 318.5855, 11.00642>, <-19.6168, 317.0998, 11.5556>, <-19.8549, 312.7691, 10.5399> }
					triangle { <-16.7996, 317.9085, 10.7823>, <-16.4362, 318.6329, 10.6589>, <-18.527, 318.5855, 11.00642> }
					triangle { <-18.527, 318.5855, 11.00642>, <-19.8549, 312.7691, 10.5399>, <-16.7996, 317.9085, 10.7823> }
					triangle { <-19.3764, 312.5656, 10.3534>, <-16.7996, 317.9085, 10.7823>, <-19.8549, 312.7691, 10.5399> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-6.4774, 272.1514, 49.2697>, <-6.467, 274.4412, 49.8167>, 0.2999 }
			cylinder { <-6.467, 274.4412, 49.8167>, <-6.4893, 276.7471, 50.2905>, 0.2999 }
			cylinder { <-6.4893, 276.7471, 50.2905>, <-6.5444, 279.0665, 50.6908>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-6.5444, 279.0665, 50.6908>, <-7.2333, 280.2636, 52.5972>, 0.2999 }
			cylinder { <-7.2333, 280.2636, 52.5972>, <-7.9359, 281.3897, 54.5416>, 0.2999 }
			cylinder { <-7.9359, 281.3897, 54.5416>, <-8.6514, 282.4434, 56.5216>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.6514, 282.4434, 56.5216>, <-9.4075, 286.5947, 62.1854>, 0.2999 }
				cylinder { <-9.4075, 286.5947, 62.1854>, <-8.7281, 291.4875, 67.2334>, 0.2999 }
				cylinder { <-8.7281, 291.4875, 67.2334>, <-6.6537, 296.8284, 71.3631>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-6.6537, 296.8284, 71.3631>, <-6.2772, 297.566, 71.384>, <-5.8191, 298.8631, 72.401> }
					triangle { <-6.2772, 297.566, 71.384>, <-5.4257, 299.7312, 72.6647>, <-5.8191, 298.8631, 72.401> }
					triangle { <-5.4257, 299.7312, 72.6647>, <-5.6146, 299.5757, 73.1863>, <-5.8191, 298.8631, 72.401> }
					triangle { <-5.8191, 298.8631, 72.401>, <-5.6146, 299.5757, 73.1863>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-5.4257, 299.7312, 72.6647>, <-0.9307, 298.6721, 71.8783>, <0.639, 298.3282, 73.1182> }
					triangle { <0.639, 298.3282, 73.1182>, <0.799, 297.2821, 74.9625>, <-0.007876, 297.4003, 74.7055> }
					triangle { <-0.007876, 297.4003, 74.7055>, <-5.4257, 299.7312, 72.6647>, <0.639, 298.3282, 73.1182> }
					triangle { <-5.4257, 299.7312, 72.6647>, <-0.007876, 297.4003, 74.7055>, <-5.6146, 299.5757, 73.1863> }
					triangle { <-6.03645, 298.6323, 72.8726>, <-6.6032, 297.2198, 72.09148>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-6.03645, 298.6323, 72.8726>, <-5.8604, 299.2696, 73.608>, <-6.6032, 297.2198, 72.09148> }
					triangle { <-6.03645, 298.6323, 72.8726>, <-5.6146, 299.5757, 73.1863>, <-5.8604, 299.2696, 73.608> }
					triangle { <-6.6537, 296.8284, 71.3631>, <-5.6146, 299.5757, 73.1863>, <-6.03645, 298.6323, 72.8726> }
					triangle { <-0.8461, 296.7511, 76.3411>, <-2.8144, 296.6719, 75.9659>, <-5.8604, 299.2696, 73.608> }
					triangle { <-0.007876, 297.4003, 74.7055>, <0.799, 297.2821, 74.9625>, <-0.8461, 296.7511, 76.3411> }
					triangle { <-0.8461, 296.7511, 76.3411>, <-5.8604, 299.2696, 73.608>, <-0.007876, 297.4003, 74.7055> }
					triangle { <-5.6146, 299.5757, 73.1863>, <-0.007876, 297.4003, 74.7055>, <-5.8604, 299.2696, 73.608> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-6.6537, 296.8284, 71.3631>, <-6.7426, 297.6298, 71.5531>, <-6.1294, 298.9056, 72.5138> }
					triangle { <-6.7426, 297.6298, 71.5531>, <-6.04638, 299.8162, 72.8902>, <-6.1294, 298.9056, 72.5138> }
					triangle { <-6.04638, 299.8162, 72.8902>, <-5.6146, 299.5757, 73.1863>, <-6.1294, 298.9056, 72.5138> }
					triangle { <-6.1294, 298.9056, 72.5138>, <-5.6146, 299.5757, 73.1863>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-6.04638, 299.8162, 72.8902>, <-4.6798, 302.011, 68.9838>, <-2.9038, 302.8003, 68.3985> }
					triangle { <-2.9038, 302.8003, 68.3985>, <-0.899, 302.1293, 68.6264>, <-1.4638, 301.6806, 69.08556> }
					triangle { <-1.4638, 301.6806, 69.08556>, <-6.04638, 299.8162, 72.8902>, <-2.9038, 302.8003, 68.3985> }
					triangle { <-6.04638, 299.8162, 72.8902>, <-1.4638, 301.6806, 69.08556>, <-5.6146, 299.5757, 73.1863> }
					triangle { <-5.7261, 298.5898, 72.7599>, <-6.1377, 297.156, 71.9223>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-5.7261, 298.5898, 72.7599>, <-5.2398, 299.1846, 73.3824>, <-6.1377, 297.156, 71.9223> }
					triangle { <-5.7261, 298.5898, 72.7599>, <-5.6146, 299.5757, 73.1863>, <-5.2398, 299.1846, 73.3824> }
					triangle { <-6.6537, 296.8284, 71.3631>, <-5.6146, 299.5757, 73.1863>, <-5.7261, 298.5898, 72.7599> }
					triangle { <-0.148, 300.6421, 70.08014>, <-1.1847, 299.2738, 71.1165>, <-5.2398, 299.1846, 73.3824> }
					triangle { <-1.4638, 301.6806, 69.08556>, <-0.899, 302.1293, 68.6264>, <-0.148, 300.6421, 70.08014> }
					triangle { <-0.148, 300.6421, 70.08014>, <-5.2398, 299.1846, 73.3824>, <-1.4638, 301.6806, 69.08556> }
					triangle { <-5.6146, 299.5757, 73.1863>, <-1.4638, 301.6806, 69.08556>, <-5.2398, 299.1846, 73.3824> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-6.6537, 296.8284, 71.3631>, <-6.7929, 297.3684, 71.9756>, <-6.1629, 298.7314, 72.7954> }
					triangle { <-6.7929, 297.3684, 71.9756>, <-6.1134, 299.4677, 73.4536>, <-6.1629, 298.7314, 72.7954> }
					triangle { <-6.1134, 299.4677, 73.4536>, <-5.6146, 299.5757, 73.1863>, <-6.1629, 298.7314, 72.7954> }
					triangle { <-6.1629, 298.7314, 72.7954>, <-5.6146, 299.5757, 73.1863>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-6.1134, 299.4677, 73.4536>, <-9.712, 302.0071, 71.8577>, <-9.8159, 303.776, 70.8678> }
					triangle { <-9.8159, 303.776, 70.8678>, <-8.64, 304.6077, 69.3035>, <-8.3047, 303.8981, 69.6429> }
					triangle { <-8.3047, 303.8981, 69.6429>, <-6.1134, 299.4677, 73.4536>, <-9.8159, 303.776, 70.8678> }
					triangle { <-6.1134, 299.4677, 73.4536>, <-8.3047, 303.8981, 69.6429>, <-5.6146, 299.5757, 73.1863> }
					triangle { <-5.6926, 298.764, 72.4782>, <-6.08744, 297.4174, 71.4998>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-5.6926, 298.764, 72.4782>, <-5.1727, 299.5331, 72.8191>, <-6.08744, 297.4174, 71.4998> }
					triangle { <-5.6926, 298.764, 72.4782>, <-5.6146, 299.5757, 73.1863>, <-5.1727, 299.5331, 72.8191> }
					triangle { <-6.6537, 296.8284, 71.3631>, <-5.6146, 299.5757, 73.1863>, <-5.6926, 298.764, 72.4782> }
					triangle { <-6.6018, 303.9991, 68.6999>, <-5.6356, 302.29, 69.1081>, <-5.1727, 299.5331, 72.8191> }
					triangle { <-8.3047, 303.8981, 69.6429>, <-8.64, 304.6077, 69.3035>, <-6.6018, 303.9991, 68.6999> }
					triangle { <-6.6018, 303.9991, 68.6999>, <-5.1727, 299.5331, 72.8191>, <-8.3047, 303.8981, 69.6429> }
					triangle { <-5.6146, 299.5757, 73.1863>, <-8.3047, 303.8981, 69.6429>, <-5.1727, 299.5331, 72.8191> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-6.6537, 296.8284, 71.3631>, <-6.359, 297.1407, 72.07159>, <-5.8736, 298.5796, 72.8594> }
					triangle { <-6.359, 297.1407, 72.07159>, <-5.5348, 299.1641, 73.5814>, <-5.8736, 298.5796, 72.8594> }
					triangle { <-5.5348, 299.1641, 73.5814>, <-5.6146, 299.5757, 73.1863>, <-5.8736, 298.5796, 72.8594> }
					triangle { <-5.8736, 298.5796, 72.8594>, <-5.6146, 299.5757, 73.1863>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-5.5348, 299.1641, 73.5814>, <-9.1199, 298.6657, 76.5553>, <-10.6095, 299.916, 77.1365> }
					triangle { <-10.6095, 299.916, 77.1365>, <-11.7984, 301.3155, 76.06456>, <-11.1404, 301.009, 75.6125> }
					triangle { <-11.1404, 301.009, 75.6125>, <-5.5348, 299.1641, 73.5814>, <-10.6095, 299.916, 77.1365> }
					triangle { <-5.5348, 299.1641, 73.5814>, <-11.1404, 301.009, 75.6125>, <-5.6146, 299.5757, 73.1863> }
					triangle { <-5.9818, 298.9159, 72.4143>, <-6.5213, 297.6451, 71.4039>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-5.9818, 298.9159, 72.4143>, <-5.7513, 299.8367, 72.6912>, <-6.5213, 297.6451, 71.4039> }
					triangle { <-5.9818, 298.9159, 72.4143>, <-5.6146, 299.5757, 73.1863>, <-5.7513, 299.8367, 72.6912> }
					triangle { <-6.6537, 296.8284, 71.3631>, <-5.6146, 299.5757, 73.1863>, <-5.9818, 298.9159, 72.4143> }
					triangle { <-11.3489, 302.2142, 74.09496>, <-10.05774, 301.5804, 72.6976>, <-5.7513, 299.8367, 72.6912> }
					triangle { <-11.1404, 301.009, 75.6125>, <-11.7984, 301.3155, 76.06456>, <-11.3489, 302.2142, 74.09496> }
					triangle { <-11.3489, 302.2142, 74.09496>, <-5.7513, 299.8367, 72.6912>, <-11.1404, 301.009, 75.6125> }
					triangle { <-5.6146, 299.5757, 73.1863>, <-11.1404, 301.009, 75.6125>, <-5.7513, 299.8367, 72.6912> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-6.6537, 296.8284, 71.3631>, <-6.03547, 297.2646, 71.7003>, <-5.6579, 298.6622, 72.6119> }
					triangle { <-6.03547, 297.2646, 71.7003>, <-5.1034, 299.3293, 73.08656>, <-5.6579, 298.6622, 72.6119> }
					triangle { <-5.1034, 299.3293, 73.08656>, <-5.6146, 299.5757, 73.1863>, <-5.6579, 298.6622, 72.6119> }
					triangle { <-5.6579, 298.6622, 72.6119>, <-5.6146, 299.5757, 73.1863>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-5.1034, 299.3293, 73.08656>, <-3.6108, 296.5735, 76.5682>, <-4.05041, 296.4982, 78.5484> }
					triangle { <-4.05041, 296.4982, 78.5484>, <-5.8766, 296.7197, 79.6147>, <-5.9353, 296.9325, 78.7887> }
					triangle { <-5.9353, 296.9325, 78.7887>, <-5.1034, 299.3293, 73.08656>, <-4.05041, 296.4982, 78.5484> }
					triangle { <-5.1034, 299.3293, 73.08656>, <-5.9353, 296.9325, 78.7887>, <-5.6146, 299.5757, 73.1863> }
					triangle { <-6.1976, 298.8332, 72.6617>, <-6.8449, 297.5212, 71.7751>, <-6.6537, 296.8284, 71.3631> }
					triangle { <-6.1976, 298.8332, 72.6617>, <-6.1827, 299.6714, 73.1861>, <-6.8449, 297.5212, 71.7751> }
					triangle { <-6.1976, 298.8332, 72.6617>, <-5.6146, 299.5757, 73.1863>, <-6.1827, 299.6714, 73.1861> }
					triangle { <-6.6537, 296.8284, 71.3631>, <-5.6146, 299.5757, 73.1863>, <-6.1976, 298.8332, 72.6617> }
					triangle { <-7.7379, 297.6671, 78.8887>, <-8.2877, 298.0559, 76.9999>, <-6.1827, 299.6714, 73.1861> }
					triangle { <-5.9353, 296.9325, 78.7887>, <-5.8766, 296.7197, 79.6147>, <-7.7379, 297.6671, 78.8887> }
					triangle { <-7.7379, 297.6671, 78.8887>, <-6.1827, 299.6714, 73.1861>, <-5.9353, 296.9325, 78.7887> }
					triangle { <-5.6146, 299.5757, 73.1863>, <-5.9353, 296.9325, 78.7887>, <-6.1827, 299.6714, 73.1861> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-8.6514, 282.4434, 56.5216>, <-9.3056, 283.5506, 58.4936>, 0.2999 }
			cylinder { <-9.3056, 283.5506, 58.4936>, <-9.8978, 284.7099, 60.4552>, 0.2999 }
			cylinder { <-9.8978, 284.7099, 60.4552>, <-10.4272, 285.9199, 62.4041>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.4272, 285.9199, 62.4041>, <-13.6259, 289.4283, 67.6331>, 0.2999 }
				cylinder { <-13.6259, 289.4283, 67.6331>, <-18.2433, 292.6047, 71.9311>, 0.2999 }
				cylinder { <-18.2433, 292.6047, 71.9311>, <-24.0027, 295.2588, 75.04056>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-24.0027, 295.2588, 75.04056>, <-24.8201, 295.2931, 75.1705>, <-26.05937, 296.1221, 76.0095> }
					triangle { <-24.8201, 295.2931, 75.1705>, <-26.973, 296.3499, 76.3113>, <-26.05937, 296.1221, 76.0095> }
					triangle { <-26.973, 296.3499, 76.3113>, <-26.6942, 296.7551, 76.6114>, <-26.05937, 296.1221, 76.0095> }
					triangle { <-26.05937, 296.1221, 76.0095>, <-26.6942, 296.7551, 76.6114>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-26.973, 296.3499, 76.3113>, <-28.6576, 297.8491, 72.2053>, <-29.136, 299.6932, 71.505> }
					triangle { <-29.136, 299.6932, 71.505>, <-28.1989, 301.5896, 71.7212>, <-27.8715, 300.9865, 72.2313> }
					triangle { <-27.8715, 300.9865, 72.2313>, <-26.973, 296.3499, 76.3113>, <-29.136, 299.6932, 71.505> }
					triangle { <-26.973, 296.3499, 76.3113>, <-27.8715, 300.9865, 72.2313>, <-26.6942, 296.7551, 76.6114> }
					triangle { <-25.7068, 296.4863, 76.2665>, <-24.2914, 295.8394, 75.5561>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-25.7068, 296.4863, 76.2665>, <-26.268, 297.0783, 76.8254>, <-24.2914, 295.8394, 75.5561> }
					triangle { <-25.7068, 296.4863, 76.2665>, <-26.6942, 296.7551, 76.6114>, <-26.268, 297.0783, 76.8254> }
					triangle { <-24.0027, 295.2588, 75.04056>, <-26.6942, 296.7551, 76.6114>, <-25.7068, 296.4863, 76.2665> }
					triangle { <-26.7273, 302.1817, 73.2617>, <-25.6028, 301.0052, 74.4332>, <-26.268, 297.0783, 76.8254> }
					triangle { <-27.8715, 300.9865, 72.2313>, <-28.1989, 301.5896, 71.7212>, <-26.7273, 302.1817, 73.2617> }
					triangle { <-26.7273, 302.1817, 73.2617>, <-26.268, 297.0783, 76.8254>, <-27.8715, 300.9865, 72.2313> }
					triangle { <-26.6942, 296.7551, 76.6114>, <-27.8715, 300.9865, 72.2313>, <-26.268, 297.0783, 76.8254> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-24.0027, 295.2588, 75.04056>, <-24.6, 295.224, 75.6134>, <-25.9126, 296.076, 76.3047> }
					triangle { <-24.6, 295.224, 75.6134>, <-26.6796, 296.2578, 76.9018>, <-25.9126, 296.076, 76.3047> }
					triangle { <-26.6796, 296.2578, 76.9018>, <-26.6942, 296.7551, 76.6114>, <-25.9126, 296.076, 76.3047> }
					triangle { <-25.9126, 296.076, 76.3047>, <-26.6942, 296.7551, 76.6114>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-26.6796, 296.2578, 76.9018>, <-29.593, 292.9938, 75.2275>, <-31.282, 293.1014, 74.107> }
					triangle { <-31.282, 293.1014, 74.107>, <-31.8187, 294.3167, 72.4467>, <-31.09431, 294.5615, 72.8294> }
					triangle { <-31.09431, 294.5615, 72.8294>, <-26.6796, 296.2578, 76.9018>, <-31.282, 293.1014, 74.107> }
					triangle { <-26.6796, 296.2578, 76.9018>, <-31.09431, 294.5615, 72.8294>, <-26.6942, 296.7551, 76.6114> }
					triangle { <-25.8535, 296.5323, 75.9713>, <-24.5114, 295.9085, 75.1132>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-25.8535, 296.5323, 75.9713>, <-26.5614, 297.1705, 76.2349>, <-24.5114, 295.9085, 75.1132> }
					triangle { <-25.8535, 296.5323, 75.9713>, <-26.6942, 296.7551, 76.6114>, <-26.5614, 297.1705, 76.2349> }
					triangle { <-24.0027, 295.2588, 75.04056>, <-26.6942, 296.7551, 76.6114>, <-25.8535, 296.5323, 75.9713> }
					triangle { <-30.8782, 296.2199, 71.8284>, <-29.0809, 296.9489, 72.3376>, <-26.5614, 297.1705, 76.2349> }
					triangle { <-31.09431, 294.5615, 72.8294>, <-31.8187, 294.3167, 72.4467>, <-30.8782, 296.2199, 71.8284> }
					triangle { <-30.8782, 296.2199, 71.8284>, <-26.5614, 297.1705, 76.2349>, <-31.09431, 294.5615, 72.8294> }
					triangle { <-26.6942, 296.7551, 76.6114>, <-31.09431, 294.5615, 72.8294>, <-26.5614, 297.1705, 76.2349> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-24.0027, 295.2588, 75.04056>, <-24.3192, 295.6247, 75.713>, <-25.7254, 296.3431, 76.3711> }
					triangle { <-24.3192, 295.6247, 75.713>, <-26.3051, 296.792, 77.03468>, <-25.7254, 296.3431, 76.3711> }
					triangle { <-26.3051, 296.792, 77.03468>, <-26.6942, 296.7551, 76.6114>, <-25.7254, 296.3431, 76.3711> }
					triangle { <-25.7254, 296.3431, 76.3711>, <-26.6942, 296.7551, 76.6114>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-26.3051, 296.792, 77.03468>, <-26.5494, 293.3015, 80.1493>, <-28.04172, 292.0313, 80.6783> }
					triangle { <-28.04172, 292.0313, 80.6783>, <-29.5179, 291.0098, 79.5387>, <-29.08724, 291.5977, 79.09148> }
					triangle { <-29.08724, 291.5977, 79.09148>, <-26.3051, 296.792, 77.03468>, <-28.04172, 292.0313, 80.6783> }
					triangle { <-26.3051, 296.792, 77.03468>, <-29.08724, 291.5977, 79.09148>, <-26.6942, 296.7551, 76.6114> }
					triangle { <-26.04083, 296.2652, 75.9049>, <-24.7923, 295.5078, 75.01365>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-26.04083, 296.2652, 75.9049>, <-26.9359, 296.6363, 76.1021>, <-24.7923, 295.5078, 75.01365> }
					triangle { <-26.04083, 296.2652, 75.9049>, <-26.6942, 296.7551, 76.6114>, <-26.9359, 296.6363, 76.1021> }
					triangle { <-24.0027, 295.2588, 75.04056>, <-26.6942, 296.7551, 76.6114>, <-26.04083, 296.2652, 75.9049> }
					triangle { <-30.197, 291.4992, 77.4921>, <-29.283, 292.6266, 76.1084>, <-26.9359, 296.6363, 76.1021> }
					triangle { <-29.08724, 291.5977, 79.09148>, <-29.5179, 291.0098, 79.5387>, <-30.197, 291.4992, 77.4921> }
					triangle { <-30.197, 291.4992, 77.4921>, <-26.9359, 296.6363, 76.1021>, <-29.08724, 291.5977, 79.09148> }
					triangle { <-26.6942, 296.7551, 76.6114>, <-29.08724, 291.5977, 79.09148>, <-26.9359, 296.6363, 76.1021> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-24.0027, 295.2588, 75.04056>, <-24.363, 295.9452, 75.3326>, <-25.7546, 296.5568, 76.1175> }
					triangle { <-24.363, 295.9452, 75.3326>, <-26.3635, 297.2193, 76.5274>, <-25.7546, 296.5568, 76.1175> }
					triangle { <-26.3635, 297.2193, 76.5274>, <-26.6942, 296.7551, 76.6114>, <-25.7546, 296.5568, 76.1175> }
					triangle { <-25.7546, 296.5568, 76.1175>, <-26.6942, 296.7551, 76.6114>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-26.3635, 297.2193, 76.5274>, <-23.7046, 298.3498, 80.2149>, <-23.8628, 297.9517, 82.1989> }
					triangle { <-23.8628, 297.9517, 82.1989>, <-24.4547, 296.2082, 83.2624>, <-24.6052, 296.1634, 82.4219> }
					triangle { <-24.6052, 296.1634, 82.4219>, <-26.3635, 297.2193, 76.5274>, <-23.8628, 297.9517, 82.1989> }
					triangle { <-26.3635, 297.2193, 76.5274>, <-24.6052, 296.1634, 82.4219>, <-26.6942, 296.7551, 76.6114> }
					triangle { <-26.01161, 296.0516, 76.1585>, <-24.7485, 295.1873, 75.394>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-26.01161, 296.0516, 76.1585>, <-26.8775, 296.2089, 76.6093>, <-24.7485, 295.1873, 75.394> }
					triangle { <-26.01161, 296.0516, 76.1585>, <-26.6942, 296.7551, 76.6114>, <-26.8775, 296.2089, 76.6093> }
					triangle { <-24.0027, 295.2588, 75.04056>, <-26.6942, 296.7551, 76.6114>, <-26.01161, 296.0516, 76.1585> }
					triangle { <-25.6188, 294.4995, 82.4787>, <-25.9317, 293.9713, 80.5697>, <-26.8775, 296.2089, 76.6093> }
					triangle { <-24.6052, 296.1634, 82.4219>, <-24.4547, 296.2082, 83.2624>, <-25.6188, 294.4995, 82.4787> }
					triangle { <-25.6188, 294.4995, 82.4787>, <-26.8775, 296.2089, 76.6093>, <-24.6052, 296.1634, 82.4219> }
					triangle { <-26.6942, 296.7551, 76.6114>, <-24.6052, 296.1634, 82.4219>, <-26.8775, 296.2089, 76.6093> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-24.0027, 295.2588, 75.04056>, <-24.6773, 295.7372, 74.9923>, <-25.9641, 296.4181, 75.8906> }
					triangle { <-24.6773, 295.7372, 74.9923>, <-26.7825, 296.942, 76.07368>, <-25.9641, 296.4181, 75.8906> }
					triangle { <-26.7825, 296.942, 76.07368>, <-26.6942, 296.7551, 76.6114>, <-25.9641, 296.4181, 75.8906> }
					triangle { <-25.9641, 296.4181, 75.8906>, <-26.6942, 296.7551, 76.6114>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-26.7825, 296.942, 76.07368>, <-25.02732, 301.2028, 75.2311>, <-24.5494, 302.7585, 76.444> }
					triangle { <-24.5494, 302.7585, 76.444>, <-23.6272, 302.8456, 78.358>, <-23.8426, 302.0536, 78.1181> }
					triangle { <-23.8426, 302.0536, 78.1181>, <-26.7825, 296.942, 76.07368>, <-24.5494, 302.7585, 76.444> }
					triangle { <-26.7825, 296.942, 76.07368>, <-23.8426, 302.0536, 78.1181>, <-26.6942, 296.7551, 76.6114> }
					triangle { <-25.8021, 296.1902, 76.3854>, <-24.4342, 295.3953, 75.7343>, <-24.0027, 295.2588, 75.04056> }
					triangle { <-25.8021, 296.1902, 76.3854>, <-26.4585, 296.4862, 77.06314>, <-24.4342, 295.3953, 75.7343> }
					triangle { <-25.8021, 296.1902, 76.3854>, <-26.6942, 296.7551, 76.6114>, <-26.4585, 296.4862, 77.06314> }
					triangle { <-24.0027, 295.2588, 75.04056>, <-26.6942, 296.7551, 76.6114>, <-25.8021, 296.1902, 76.3854> }
					triangle { <-23.4421, 301.2012, 79.8246>, <-23.6229, 299.2277, 79.5187>, <-26.4585, 296.4862, 77.06314> }
					triangle { <-23.8426, 302.0536, 78.1181>, <-23.6272, 302.8456, 78.358>, <-23.4421, 301.2012, 79.8246> }
					triangle { <-23.4421, 301.2012, 79.8246>, <-26.4585, 296.4862, 77.06314>, <-23.8426, 302.0536, 78.1181> }
					triangle { <-26.6942, 296.7551, 76.6114>, <-23.8426, 302.0536, 78.1181>, <-26.4585, 296.4862, 77.06314> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-10.4272, 285.9199, 62.4041>, <-11.03568, 287.1252, 64.3328>, 0.2999 }
			cylinder { <-11.03568, 287.1252, 64.3328>, <-11.7223, 288.3242, 66.2389>, 0.2999 }
			cylinder { <-11.7223, 288.3242, 66.2389>, <-12.4865, 289.5157, 68.1201>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-12.4865, 289.5157, 68.1201>, <-13.6632, 292.0673, 74.5999>, 0.2999 }
				cylinder { <-13.6632, 292.0673, 74.5999>, <-13.6535, 293.4434, 81.5273>, 0.2999 }
				cylinder { <-13.6535, 293.4434, 81.5273>, <-12.458, 293.5614, 88.4872>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-12.458, 293.5614, 88.4872>, <-11.9441, 293.4232, 89.1221>, <-11.7867, 293.5017, 90.8238> }
					triangle { <-11.9441, 293.4232, 89.1221>, <-11.364, 293.4175, 91.7138>, <-11.7867, 293.5017, 90.8238> }
					triangle { <-11.364, 293.4175, 91.7138>, <-11.8728, 293.6191, 91.8939>, <-11.7867, 293.5017, 90.8238> }
					triangle { <-11.7867, 293.5017, 90.8238>, <-11.8728, 293.6191, 91.8939>, <-12.458, 293.5614, 88.4872> }
					triangle { <-11.364, 293.4175, 91.7138>, <-11.02229, 288.7469, 91.8304>, <-12.00604, 287.3214, 92.8886> }
					triangle { <-12.00604, 287.3214, 92.8886>, <-14.0494, 287.1048, 93.4355>, <-13.864, 287.8701, 93.1023> }
					triangle { <-13.864, 287.8701, 93.1023>, <-11.364, 293.4175, 91.7138>, <-12.00604, 287.3214, 92.8886> }
					triangle { <-11.364, 293.4175, 91.7138>, <-13.864, 287.8701, 93.1023>, <-11.8728, 293.6191, 91.8939> }
					triangle { <-12.3116, 293.7017, 90.9106>, <-12.7313, 293.7232, 89.2523>, <-12.458, 293.5614, 88.4872> }
					triangle { <-12.3116, 293.7017, 90.9106>, <-12.4136, 293.8176, 91.8873>, <-12.7313, 293.7232, 89.2523> }
					triangle { <-12.3116, 293.7017, 90.9106>, <-11.8728, 293.6191, 91.8939>, <-12.4136, 293.8176, 91.8873> }
					triangle { <-12.458, 293.5614, 88.4872>, <-11.8728, 293.6191, 91.8939>, <-12.3116, 293.7017, 90.9106> }
					triangle { <-15.5922, 288.688, 93.4814>, <-15.5706, 290.4803, 92.5823>, <-12.4136, 293.8176, 91.8873> }
					triangle { <-13.864, 287.8701, 93.1023>, <-14.0494, 287.1048, 93.4355>, <-15.5922, 288.688, 93.4814> }
					triangle { <-15.5922, 288.688, 93.4814>, <-12.4136, 293.8176, 91.8873>, <-13.864, 287.8701, 93.1023> }
					triangle { <-11.8728, 293.6191, 91.8939>, <-13.864, 287.8701, 93.1023>, <-12.4136, 293.8176, 91.8873> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-12.458, 293.5614, 88.4872>, <-12.07498, 293.9049, 89.1364>, <-11.874, 293.8228, 90.8334> }
					triangle { <-12.07498, 293.9049, 89.1364>, <-11.5384, 294.0598, 91.7329>, <-11.874, 293.8228, 90.8334> }
					triangle { <-11.5384, 294.0598, 91.7329>, <-11.8728, 293.6191, 91.8939>, <-11.874, 293.8228, 90.8334> }
					triangle { <-11.874, 293.8228, 90.8334>, <-11.8728, 293.6191, 91.8939>, <-12.458, 293.5614, 88.4872> }
					triangle { <-11.5384, 294.0598, 91.7329>, <-7.04817, 292.8969, 91.07745>, <-5.907, 291.3689, 91.7723> }
					triangle { <-5.907, 291.3689, 91.7723>, <-6.3146, 289.3033, 92.06966>, <-7.01099, 289.7671, 91.893> }
					triangle { <-7.01099, 289.7671, 91.893>, <-11.5384, 294.0598, 91.7329>, <-5.907, 291.3689, 91.7723> }
					triangle { <-11.5384, 294.0598, 91.7329>, <-7.01099, 289.7671, 91.893>, <-11.8728, 293.6191, 91.8939> }
					triangle { <-12.2243, 293.3806, 90.9011>, <-12.6005, 293.2415, 89.238>, <-12.458, 293.5614, 88.4872> }
					triangle { <-12.2243, 293.3806, 90.9011>, <-12.2392, 293.1753, 91.8682>, <-12.6005, 293.2415, 89.238> }
					triangle { <-12.2243, 293.3806, 90.9011>, <-11.8728, 293.6191, 91.8939>, <-12.2392, 293.1753, 91.8682> }
					triangle { <-12.458, 293.5614, 88.4872>, <-11.8728, 293.6191, 91.8939>, <-12.2243, 293.3806, 90.9011> }
					triangle { <-8.3013, 288.3468, 92.2348>, <-10.0849, 289.0639, 91.664>, <-12.2392, 293.1753, 91.8682> }
					triangle { <-7.01099, 289.7671, 91.893>, <-6.3146, 289.3033, 92.06966>, <-8.3013, 288.3468, 92.2348> }
					triangle { <-8.3013, 288.3468, 92.2348>, <-12.2392, 293.1753, 91.8682>, <-7.01099, 289.7671, 91.893> }
					triangle { <-11.8728, 293.6191, 91.8939>, <-7.01099, 289.7671, 91.893>, <-12.2392, 293.1753, 91.8682> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-12.458, 293.5614, 88.4872>, <-12.5665, 293.9313, 89.2204>, <-12.2016, 293.8405, 90.8894> }
					triangle { <-12.5665, 293.9313, 89.2204>, <-12.1938, 294.095, 91.8449>, <-12.2016, 293.8405, 90.8894> }
					triangle { <-12.1938, 294.095, 91.8449>, <-11.8728, 293.6191, 91.8939>, <-12.2016, 293.8405, 90.8894> }
					triangle { <-12.2016, 293.8405, 90.8894>, <-11.8728, 293.6191, 91.8939>, <-12.458, 293.5614, 88.4872> }
					triangle { <-12.1938, 294.095, 91.8449>, <-9.6965, 298.0382, 91.4452>, <-7.7988, 298.5247, 91.976> }
					triangle { <-7.7988, 298.5247, 91.976>, <-5.9672, 297.4497, 91.8718>, <-6.6554, 296.9688, 91.7098> }
					triangle { <-6.6554, 296.9688, 91.7098>, <-12.1938, 294.095, 91.8449>, <-7.7988, 298.5247, 91.976> }
					triangle { <-12.1938, 294.095, 91.8449>, <-6.6554, 296.9688, 91.7098>, <-11.8728, 293.6191, 91.8939> }
					triangle { <-11.8967, 293.363, 90.8451>, <-12.109, 293.2151, 89.154>, <-12.458, 293.5614, 88.4872> }
					triangle { <-11.8967, 293.363, 90.8451>, <-11.5838, 293.1401, 91.7563>, <-12.109, 293.2151, 89.154> }
					triangle { <-11.8967, 293.363, 90.8451>, <-11.8728, 293.6191, 91.8939>, <-11.5838, 293.1401, 91.7563> }
					triangle { <-12.458, 293.5614, 88.4872>, <-11.8728, 293.6191, 91.8939>, <-11.8967, 293.363, 90.8451> }
					triangle { <-5.7148, 295.2621, 91.6733>, <-7.0534, 293.9001, 91.06135>, <-11.5838, 293.1401, 91.7563> }
					triangle { <-6.6554, 296.9688, 91.7098>, <-5.9672, 297.4497, 91.8718>, <-5.7148, 295.2621, 91.6733> }
					triangle { <-5.7148, 295.2621, 91.6733>, <-11.5838, 293.1401, 91.7563>, <-6.6554, 296.9688, 91.7098> }
					triangle { <-11.8728, 293.6191, 91.8939>, <-6.6554, 296.9688, 91.7098>, <-11.5838, 293.1401, 91.7563> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-12.458, 293.5614, 88.4872>, <-12.744, 293.4662, 89.2588>, <-12.32, 293.5304, 90.915> }
					triangle { <-12.744, 293.4662, 89.2588>, <-12.4306, 293.4748, 91.896>, <-12.32, 293.5304, 90.915> }
					triangle { <-12.4306, 293.4748, 91.896>, <-11.8728, 293.6191, 91.8939>, <-12.32, 293.5304, 90.915> }
					triangle { <-12.32, 293.5304, 90.915>, <-11.8728, 293.6191, 91.8939>, <-12.458, 293.5614, 88.4872> }
					triangle { <-12.4306, 293.4748, 91.896>, <-15.3322, 297.1137, 92.4289>, <-15.08473, 298.9665, 93.22> }
					triangle { <-15.08473, 298.9665, 93.22>, <-13.4839, 300.3621, 93.1136>, <-13.2854, 299.59, 92.8042> }
					triangle { <-13.2854, 299.59, 92.8042>, <-12.4306, 293.4748, 91.896>, <-15.08473, 298.9665, 93.22> }
					triangle { <-12.4306, 293.4748, 91.896>, <-13.2854, 299.59, 92.8042>, <-11.8728, 293.6191, 91.8939> }
					triangle { <-11.7783, 293.6731, 90.8195>, <-11.9314, 293.6803, 89.1156>, <-12.458, 293.5614, 88.4872> }
					triangle { <-11.7783, 293.6731, 90.8195>, <-11.3471, 293.7603, 91.7051>, <-11.9314, 293.6803, 89.1156> }
					triangle { <-11.7783, 293.6731, 90.8195>, <-11.8728, 293.6191, 91.8939>, <-11.3471, 293.7603, 91.7051> }
					triangle { <-12.458, 293.5614, 88.4872>, <-11.8728, 293.6191, 91.8939>, <-11.7783, 293.6731, 90.8195> }
					triangle { <-11.3829, 299.9417, 92.5676>, <-10.6372, 298.3506, 91.6014>, <-11.3471, 293.7603, 91.7051> }
					triangle { <-13.2854, 299.59, 92.8042>, <-13.4839, 300.3621, 93.1136>, <-11.3829, 299.9417, 92.5676> }
					triangle { <-11.3829, 299.9417, 92.5676>, <-11.3471, 293.7603, 91.7051>, <-13.2854, 299.59, 92.8042> }
					triangle { <-11.8728, 293.6191, 91.8939>, <-13.2854, 299.59, 92.8042>, <-11.3471, 293.7603, 91.7051> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-12.458, 293.5614, 88.4872>, <-12.3536, 293.1474, 89.1971>, <-12.05977, 293.3178, 90.8738> }
					triangle { <-12.3536, 293.1474, 89.1971>, <-11.91, 293.0498, 91.8138>, <-12.05977, 293.3178, 90.8738> }
					triangle { <-11.91, 293.0498, 91.8138>, <-11.8728, 293.6191, 91.8939>, <-12.05977, 293.3178, 90.8738> }
					triangle { <-12.05977, 293.3178, 90.8738>, <-11.8728, 293.6191, 91.8939>, <-12.458, 293.5614, 88.4872> }
					triangle { <-11.91, 293.0498, 91.8138>, <-16.1639, 291.2847, 92.6705>, <-17.7241, 291.9379, 93.7925> }
					triangle { <-17.7241, 291.9379, 93.7925>, <-18.5544, 293.872, 94.09461>, <-17.8078, 293.8819, 93.6778> }
					triangle { <-17.8078, 293.8819, 93.6778>, <-11.91, 293.0498, 91.8138>, <-17.7241, 291.9379, 93.7925> }
					triangle { <-11.91, 293.0498, 91.8138>, <-17.8078, 293.8819, 93.6778>, <-11.8728, 293.6191, 91.8939> }
					triangle { <-12.03862, 293.8856, 90.8606>, <-12.3219, 293.9991, 89.1773>, <-12.458, 293.5614, 88.4872> }
					triangle { <-12.03862, 293.8856, 90.8606>, <-11.8677, 294.1853, 91.7873>, <-12.3219, 293.9991, 89.1773> }
					triangle { <-12.03862, 293.8856, 90.8606>, <-11.8728, 293.6191, 91.8939>, <-11.8677, 294.1853, 91.7873> }
					triangle { <-12.458, 293.5614, 88.4872>, <-11.8728, 293.6191, 91.8939>, <-12.03862, 293.8856, 90.8606> }
					triangle { <-17.5796, 295.8174, 93.7019>, <-15.9806, 296.2051, 92.5556>, <-11.8677, 294.1853, 91.7873> }
					triangle { <-17.8078, 293.8819, 93.6778>, <-18.5544, 293.872, 94.09461>, <-17.5796, 295.8174, 93.7019> }
					triangle { <-17.5796, 295.8174, 93.7019>, <-11.8677, 294.1853, 91.7873>, <-17.8078, 293.8819, 93.6778> }
					triangle { <-11.8728, 293.6191, 91.8939>, <-17.8078, 293.8819, 93.6778>, <-11.8677, 294.1853, 91.7873> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-12.4865, 289.5157, 68.1201>, <-13.1975, 290.6656, 70.04753>, 0.2999 }
			cylinder { <-13.1975, 290.6656, 70.04753>, <-13.8546, 291.7725, 72.0187>, 0.2999 }
			cylinder { <-13.8546, 291.7725, 72.0187>, <-14.4569, 292.8351, 74.0313>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-14.4569, 292.8351, 74.0313>, <-16.1878, 297.4477, 79.09205>, 0.2999 }
				cylinder { <-16.1878, 297.4477, 79.09205>, <-17.739, 303.2084, 82.8724>, 0.2999 }
				cylinder { <-17.739, 303.2084, 82.8724>, <-19.01757, 309.7719, 85.1458>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-19.01757, 309.7719, 85.1458>, <-19.1621, 310.5865, 85.1031>, <-19.3099, 312.0209, 86.02365> }
					triangle { <-19.1621, 310.5865, 85.1031>, <-19.4541, 312.98, 86.2162>, <-19.3099, 312.0209, 86.02365> }
					triangle { <-19.4541, 312.98, 86.2162>, <-19.3665, 312.8093, 86.7594>, <-19.3099, 312.0209, 86.02365> }
					triangle { <-19.3099, 312.0209, 86.02365>, <-19.3665, 312.8093, 86.7594>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-19.4541, 312.98, 86.2162>, <-15.6182, 314.6487, 84.1076>, <-13.8897, 315.4388, 84.8205> }
					triangle { <-13.8897, 315.4388, 84.8205>, <-12.6568, 314.9183, 86.4728>, <-13.4091, 314.5119, 86.4663> }
					triangle { <-13.4091, 314.5119, 86.4663>, <-19.4541, 312.98, 86.2162>, <-13.8897, 315.4388, 84.8205> }
					triangle { <-19.4541, 312.98, 86.2162>, <-13.4091, 314.5119, 86.4663>, <-19.3665, 312.8093, 86.7594> }
					triangle { <-19.2128, 311.7669, 86.5226>, <-19.01644, 310.2055, 85.8516>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-19.2128, 311.7669, 86.5226>, <-19.2598, 312.4721, 87.2142>, <-19.01644, 310.2055, 85.8516> }
					triangle { <-19.2128, 311.7669, 86.5226>, <-19.3665, 312.8093, 86.7594>, <-19.2598, 312.4721, 87.2142> }
					triangle { <-19.01757, 309.7719, 85.1458>, <-19.3665, 312.8093, 86.7594>, <-19.2128, 311.7669, 86.5226> }
					triangle { <-13.226, 313.7036, 88.2305>, <-14.7764, 312.4479, 88.4325>, <-19.2598, 312.4721, 87.2142> }
					triangle { <-13.4091, 314.5119, 86.4663>, <-12.6568, 314.9183, 86.4728>, <-13.226, 313.7036, 88.2305> }
					triangle { <-13.226, 313.7036, 88.2305>, <-19.2598, 312.4721, 87.2142>, <-13.4091, 314.5119, 86.4663> }
					triangle { <-19.3665, 312.8093, 86.7594>, <-13.4091, 314.5119, 86.4663>, <-19.2598, 312.4721, 87.2142> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.01757, 309.7719, 85.1458>, <-19.5087, 310.3876, 85.4025>, <-19.541, 311.8883, 86.2232> }
					triangle { <-19.5087, 310.3876, 85.4025>, <-19.9163, 312.7148, 86.6154>, <-19.541, 311.8883, 86.2232> }
					triangle { <-19.9163, 312.7148, 86.6154>, <-19.3665, 312.8093, 86.7594>, <-19.541, 311.8883, 86.2232> }
					triangle { <-19.541, 311.8883, 86.2232>, <-19.3665, 312.8093, 86.7594>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-19.9163, 312.7148, 86.6154>, <-21.2183, 314.7934, 82.6242>, <-20.4906, 316.3896, 81.6031> }
					triangle { <-20.4906, 316.3896, 81.6031>, <-18.5078, 317.0453, 81.2034>, <-18.5494, 316.4125, 81.7769> }
					triangle { <-18.5494, 316.4125, 81.7769>, <-19.9163, 312.7148, 86.6154>, <-20.4906, 316.3896, 81.6031> }
					triangle { <-19.9163, 312.7148, 86.6154>, <-18.5494, 316.4125, 81.7769>, <-19.3665, 312.8093, 86.7594> }
					triangle { <-18.9817, 311.8995, 86.323>, <-18.6697, 310.4044, 85.5523>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-18.9817, 311.8995, 86.323>, <-18.7976, 312.7373, 86.8151>, <-18.6697, 310.4044, 85.5523> }
					triangle { <-18.9817, 311.8995, 86.323>, <-19.3665, 312.8093, 86.7594>, <-18.7976, 312.7373, 86.8151> }
					triangle { <-19.01757, 309.7719, 85.1458>, <-19.3665, 312.8093, 86.7594>, <-18.9817, 311.8995, 86.323> }
					triangle { <-16.6685, 316.4663, 82.2854>, <-16.3707, 314.8906, 83.4895>, <-18.7976, 312.7373, 86.8151> }
					triangle { <-18.5494, 316.4125, 81.7769>, <-18.5078, 317.0453, 81.2034>, <-16.6685, 316.4663, 82.2854> }
					triangle { <-16.6685, 316.4663, 82.2854>, <-18.7976, 312.7373, 86.8151>, <-18.5494, 316.4125, 81.7769> }
					triangle { <-19.3665, 312.8093, 86.7594>, <-18.5494, 316.4125, 81.7769>, <-18.7976, 312.7373, 86.8151> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.01757, 309.7719, 85.1458>, <-19.2796, 310.2003, 85.8047>, <-19.3882, 311.7634, 86.4913> }
					triangle { <-19.2796, 310.2003, 85.8047>, <-19.6107, 312.4651, 87.1516>, <-19.3882, 311.7634, 86.4913> }
					triangle { <-19.6107, 312.4651, 87.1516>, <-19.3665, 312.8093, 86.7594>, <-19.3882, 311.7634, 86.4913> }
					triangle { <-19.3882, 311.7634, 86.4913>, <-19.3665, 312.8093, 86.7594>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-19.6107, 312.4651, 87.1516>, <-24.2766, 312.2146, 86.8169>, <-25.6667, 313.4539, 86.0097> }
					triangle { <-25.6667, 313.4539, 86.0097>, <-25.6819, 314.6143, 84.2279>, <-24.9163, 314.281, 84.4121> }
					triangle { <-24.9163, 314.281, 84.4121>, <-19.6107, 312.4651, 87.1516>, <-25.6667, 313.4539, 86.0097> }
					triangle { <-19.6107, 312.4651, 87.1516>, <-24.9163, 314.281, 84.4121>, <-19.3665, 312.8093, 86.7594> }
					triangle { <-19.1345, 312.0244, 86.05498>, <-18.8989, 310.5917, 85.1501>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-19.1345, 312.0244, 86.05498>, <-19.1032, 312.9871, 86.2788>, <-18.8989, 310.5917, 85.1501> }
					triangle { <-19.1345, 312.0244, 86.05498>, <-19.3665, 312.8093, 86.7594>, <-19.1032, 312.9871, 86.2788> }
					triangle { <-19.01757, 309.7719, 85.1458>, <-19.3665, 312.8093, 86.7594>, <-19.1345, 312.0244, 86.05498> }
					triangle { <-23.9325, 315.2373, 83.02773>, <-22.07722, 314.4765, 83.03493>, <-19.1032, 312.9871, 86.2788> }
					triangle { <-24.9163, 314.281, 84.4121>, <-25.6819, 314.6143, 84.2279>, <-23.9325, 315.2373, 83.02773> }
					triangle { <-23.9325, 315.2373, 83.02773>, <-19.1032, 312.9871, 86.2788>, <-24.9163, 314.281, 84.4121> }
					triangle { <-19.3665, 312.8093, 86.7594>, <-24.9163, 314.281, 84.4121>, <-19.1032, 312.9871, 86.2788> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.01757, 309.7719, 85.1458>, <-18.7891, 310.2816, 85.7576>, <-19.06133, 311.8177, 86.4599> }
					triangle { <-18.7891, 310.2816, 85.7576>, <-18.9568, 312.5736, 87.08887>, <-19.06133, 311.8177, 86.4599> }
					triangle { <-18.9568, 312.5736, 87.08887>, <-19.3665, 312.8093, 86.7594>, <-19.06133, 311.8177, 86.4599> }
					triangle { <-19.06133, 311.8177, 86.4599>, <-19.3665, 312.8093, 86.7594>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-18.9568, 312.5736, 87.08887>, <-20.5952, 310.4521, 90.9307>, <-22.313, 310.6614, 91.9915> }
					triangle { <-22.313, 310.6614, 91.9915>, <-24.3316, 310.9621, 91.3947>, <-23.7704, 311.0432, 90.7548> }
					triangle { <-23.7704, 311.0432, 90.7548>, <-18.9568, 312.5736, 87.08887>, <-22.313, 310.6614, 91.9915> }
					triangle { <-18.9568, 312.5736, 87.08887>, <-23.7704, 311.0432, 90.7548>, <-19.3665, 312.8093, 86.7594> }
					triangle { <-19.4614, 311.9702, 86.08636>, <-19.3893, 310.5104, 85.1972>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-19.4614, 311.9702, 86.08636>, <-19.7571, 312.8786, 86.3416>, <-19.3893, 310.5104, 85.1972> }
					triangle { <-19.4614, 311.9702, 86.08636>, <-19.3665, 312.8093, 86.7594>, <-19.7571, 312.8786, 86.3416> }
					triangle { <-19.01757, 309.7719, 85.1458>, <-19.3665, 312.8093, 86.7594>, <-19.4614, 311.9702, 86.08636> }
					triangle { <-25.04723, 311.7036, 89.4384>, <-24.06297, 311.7739, 87.6927>, <-19.7571, 312.8786, 86.3416> }
					triangle { <-23.7704, 311.0432, 90.7548>, <-24.3316, 310.9621, 91.3947>, <-25.04723, 311.7036, 89.4384> }
					triangle { <-25.04723, 311.7036, 89.4384>, <-19.7571, 312.8786, 86.3416>, <-23.7704, 311.0432, 90.7548> }
					triangle { <-19.3665, 312.8093, 86.7594>, <-23.7704, 311.0432, 90.7548>, <-19.7571, 312.8786, 86.3416> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-19.01757, 309.7719, 85.1458>, <-18.7154, 310.5239, 85.3175>, <-19.01219, 311.9792, 86.1665> }
					triangle { <-18.7154, 310.5239, 85.3175>, <-18.8586, 312.8966, 86.502>, <-19.01219, 311.9792, 86.1665> }
					triangle { <-18.8586, 312.8966, 86.502>, <-19.3665, 312.8093, 86.7594>, <-19.01219, 311.9792, 86.1665> }
					triangle { <-19.01219, 311.9792, 86.1665>, <-19.3665, 312.8093, 86.7594>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-18.8586, 312.8966, 86.502>, <-15.1632, 311.9792, 89.231>, <-14.9246, 311.9067, 91.2454> }
					triangle { <-14.9246, 311.9067, 91.2454>, <-16.1602, 311.1529, 92.8031>, <-16.5512, 311.188, 92.04352> }
					triangle { <-16.5512, 311.188, 92.04352>, <-18.8586, 312.8966, 86.502>, <-14.9246, 311.9067, 91.2454> }
					triangle { <-18.8586, 312.8966, 86.502>, <-16.5512, 311.188, 92.04352>, <-19.3665, 312.8093, 86.7594> }
					triangle { <-19.5105, 311.8086, 86.3797>, <-19.463, 310.2681, 85.6373>, <-19.01757, 309.7719, 85.1458> }
					triangle { <-19.5105, 311.8086, 86.3797>, <-19.8554, 312.5555, 86.9284>, <-19.463, 310.2681, 85.6373> }
					triangle { <-19.5105, 311.8086, 86.3797>, <-19.3665, 312.8093, 86.7594>, <-19.8554, 312.5555, 86.9284> }
					triangle { <-19.01757, 309.7719, 85.1458>, <-19.3665, 312.8093, 86.7594>, <-19.5105, 311.8086, 86.3797> }
					triangle { <-18.3303, 310.7414, 92.7024>, <-19.4827, 310.5012, 91.07901>, <-19.8554, 312.5555, 86.9284> }
					triangle { <-16.5512, 311.188, 92.04352>, <-16.1602, 311.1529, 92.8031>, <-18.3303, 310.7414, 92.7024> }
					triangle { <-18.3303, 310.7414, 92.7024>, <-19.8554, 312.5555, 86.9284>, <-16.5512, 311.188, 92.04352> }
					triangle { <-19.3665, 312.8093, 86.7594>, <-16.5512, 311.188, 92.04352>, <-19.8554, 312.5555, 86.9284> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-14.4569, 292.8351, 74.0313>, <-15.06169, 293.969, 76.0039>, 0.2999 }
			cylinder { <-15.06169, 293.969, 76.0039>, <-15.6681, 295.1727, 77.9341>, 0.2999 }
			cylinder { <-15.6681, 295.1727, 77.9341>, <-16.2755, 296.4448, 79.8196>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-16.2755, 296.4448, 79.8196>, <-19.207, 298.9596, 85.7328>, 0.2999 }
				cylinder { <-19.207, 298.9596, 85.7328>, <-23.07192, 300.0222, 91.548>, 0.2999 }
				cylinder { <-23.07192, 300.0222, 91.548>, <-27.6386, 299.569, 96.9166>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-27.6386, 299.569, 96.9166>, <-28.00126, 299.0563, 97.403>, <-29.01856, 298.9275, 98.6832> }
					triangle { <-28.00126, 299.0563, 97.403>, <-29.5379, 298.5127, 99.3593>, <-29.01856, 298.9275, 98.6832> }
					triangle { <-29.5379, 298.5127, 99.3593>, <-29.6651, 299.0354, 99.4847>, <-29.01856, 298.9275, 98.6832> }
					triangle { <-29.01856, 298.9275, 98.6832>, <-29.6651, 299.0354, 99.4847>, <-27.6386, 299.569, 96.9166> }
					triangle { <-29.5379, 298.5127, 99.3593>, <-32.5373, 296.4983, 96.6911>, <-34.4196, 296.8366, 96.3309> }
					triangle { <-34.4196, 296.8366, 96.3309>, <-35.4782, 298.562, 96.08856>, <-34.7153, 298.6816, 96.3638> }
					triangle { <-34.7153, 298.6816, 96.3638>, <-29.5379, 298.5127, 99.3593>, <-34.4196, 296.8366, 96.3309> }
					triangle { <-29.5379, 298.5127, 99.3593>, <-34.7153, 298.6816, 96.3638>, <-29.6651, 299.0354, 99.4847> }
					triangle { <-29.09023, 299.4648, 98.7383>, <-28.1087, 299.8623, 97.4856>, <-27.6386, 299.569, 96.9166> }
					triangle { <-29.09023, 299.4648, 98.7383>, <-29.6812, 299.5873, 99.4695>, <-28.1087, 299.8623, 97.4856> }
					triangle { <-29.09023, 299.4648, 98.7383>, <-29.6651, 299.0354, 99.4847>, <-29.6812, 299.5873, 99.4695> }
					triangle { <-27.6386, 299.569, 96.9166>, <-29.6651, 299.0354, 99.4847>, <-29.09023, 299.4648, 98.7383> }
					triangle { <-34.9094, 300.5083, 96.7073>, <-33.1585, 301.155, 97.1685>, <-29.6812, 299.5873, 99.4695> }
					triangle { <-34.7153, 298.6816, 96.3638>, <-35.4782, 298.562, 96.08856>, <-34.9094, 300.5083, 96.7073> }
					triangle { <-34.9094, 300.5083, 96.7073>, <-29.6812, 299.5873, 99.4695>, <-34.7153, 298.6816, 96.3638> }
					triangle { <-29.6651, 299.0354, 99.4847>, <-34.7153, 298.6816, 96.3638>, <-29.6812, 299.5873, 99.4695> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-27.6386, 299.569, 96.9166>, <-27.7353, 299.3485, 97.6735>, <-28.8413, 299.1223, 98.8636> }
					triangle { <-27.7353, 299.3485, 97.6735>, <-29.1834, 298.9022, 99.72>, <-28.8413, 299.1223, 98.8636> }
					triangle { <-29.1834, 298.9022, 99.72>, <-29.6651, 299.0354, 99.4847>, <-28.8413, 299.1223, 98.8636> }
					triangle { <-28.8413, 299.1223, 98.8636>, <-29.6651, 299.0354, 99.4847>, <-27.6386, 299.569, 96.9166> }
					triangle { <-29.1834, 298.9022, 99.72>, <-28.2725, 294.5047, 99.6423>, <-29.3998, 292.9267, 99.4797> }
					triangle { <-29.3998, 292.9267, 99.4797>, <-31.04038, 292.5284, 98.3368>, <-30.8168, 293.317, 98.3255> }
					triangle { <-30.8168, 293.317, 98.3255>, <-29.1834, 298.9022, 99.72>, <-29.3998, 292.9267, 99.4797> }
					triangle { <-29.1834, 298.9022, 99.72>, <-30.8168, 293.317, 98.3255>, <-29.6651, 299.0354, 99.4847> }
					triangle { <-29.2674, 299.2701, 98.558>, <-28.3746, 299.5702, 97.2151>, <-27.6386, 299.569, 96.9166> }
					triangle { <-29.2674, 299.2701, 98.558>, <-30.0358, 299.1978, 99.1088>, <-28.3746, 299.5702, 97.2151> }
					triangle { <-29.2674, 299.2701, 98.558>, <-29.6651, 299.0354, 99.4847>, <-30.0358, 299.1978, 99.1088> }
					triangle { <-27.6386, 299.569, 96.9166>, <-29.6651, 299.0354, 99.4847>, <-29.2674, 299.2701, 98.558> }
					triangle { <-32.3121, 293.9366, 97.3914>, <-31.9662, 295.7856, 96.9937>, <-30.0358, 299.1978, 99.1088> }
					triangle { <-30.8168, 293.317, 98.3255>, <-31.04038, 292.5284, 98.3368>, <-32.3121, 293.9366, 97.3914> }
					triangle { <-32.3121, 293.9366, 97.3914>, <-30.0358, 299.1978, 99.1088>, <-30.8168, 293.317, 98.3255> }
					triangle { <-29.6651, 299.0354, 99.4847>, <-30.8168, 293.317, 98.3255>, <-30.0358, 299.1978, 99.1088> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-27.6386, 299.569, 96.9166>, <-27.9082, 299.7928, 97.6294>, <-28.9565, 299.4185, 98.8342> }
					triangle { <-27.9082, 299.7928, 97.6294>, <-29.4139, 299.4946, 99.6612>, <-28.9565, 299.4185, 98.8342> }
					triangle { <-29.4139, 299.4946, 99.6612>, <-29.6651, 299.0354, 99.4847>, <-28.9565, 299.4185, 98.8342> }
					triangle { <-28.9565, 299.4185, 98.8342>, <-29.6651, 299.0354, 99.4847>, <-27.6386, 299.569, 96.9166> }
					triangle { <-29.4139, 299.4946, 99.6612>, <-25.9192, 298.7301, 102.3772>, <-25.43, 297.2212, 103.5046> }
					triangle { <-25.43, 297.2212, 103.5046>, <-25.5531, 295.2057, 103.2232>, <-25.9471, 295.6411, 102.6511> }
					triangle { <-25.9471, 295.6411, 102.6511>, <-29.4139, 299.4946, 99.6612>, <-25.43, 297.2212, 103.5046> }
					triangle { <-29.4139, 299.4946, 99.6612>, <-25.9471, 295.6411, 102.6511>, <-29.6651, 299.0354, 99.4847> }
					triangle { <-29.1522, 298.9739, 98.5874>, <-28.2018, 299.1259, 97.2592>, <-27.6386, 299.569, 96.9166> }
					triangle { <-29.1522, 298.9739, 98.5874>, <-29.8053, 298.6054, 99.1676>, <-28.2018, 299.1259, 97.2592> }
					triangle { <-29.1522, 298.9739, 98.5874>, <-29.6651, 299.0354, 99.4847>, <-29.8053, 298.6054, 99.1676> }
					triangle { <-27.6386, 299.569, 96.9166>, <-29.6651, 299.0354, 99.4847>, <-29.1522, 298.9739, 98.5874> }
					triangle { <-26.7673, 294.1831, 101.8181>, <-27.6153, 294.8769, 100.2382>, <-29.8053, 298.6054, 99.1676> }
					triangle { <-25.9471, 295.6411, 102.6511>, <-25.5531, 295.2057, 103.2232>, <-26.7673, 294.1831, 101.8181> }
					triangle { <-26.7673, 294.1831, 101.8181>, <-29.8053, 298.6054, 99.1676>, <-25.9471, 295.6411, 102.6511> }
					triangle { <-29.6651, 299.0354, 99.4847>, <-25.9471, 295.6411, 102.6511>, <-29.8053, 298.6054, 99.1676> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-27.6386, 299.569, 96.9166>, <-28.2825, 299.7794, 97.3312>, <-29.2061, 299.4095, 98.6354> }
					triangle { <-28.2825, 299.7794, 97.3312>, <-29.913, 299.4767, 99.2636>, <-29.2061, 299.4095, 98.6354> }
					triangle { <-29.913, 299.4767, 99.2636>, <-29.6651, 299.0354, 99.4847>, <-29.2061, 299.4095, 98.6354> }
					triangle { <-29.2061, 299.4095, 98.6354>, <-29.6651, 299.0354, 99.4847>, <-27.6386, 299.569, 96.9166> }
					triangle { <-29.913, 299.4767, 99.2636>, <-28.7076, 303.3745, 101.1419>, <-27.9593, 303.8253, 102.8809> }
					triangle { <-27.9593, 303.8253, 102.8809>, <-26.5484, 302.9191, 104.0404>, <-26.7905, 302.4638, 103.4031> }
					triangle { <-26.7905, 302.4638, 103.4031>, <-29.913, 299.4767, 99.2636>, <-27.9593, 303.8253, 102.8809> }
					triangle { <-29.913, 299.4767, 99.2636>, <-26.7905, 302.4638, 103.4031>, <-29.6651, 299.0354, 99.4847> }
					triangle { <-28.9026, 298.9828, 98.7862>, <-27.8274, 299.1393, 97.5574>, <-27.6386, 299.569, 96.9166> }
					triangle { <-28.9026, 298.9828, 98.7862>, <-29.3061, 298.6233, 99.5651>, <-27.8274, 299.1393, 97.5574> }
					triangle { <-28.9026, 298.9828, 98.7862>, <-29.6651, 299.0354, 99.4847>, <-29.3061, 298.6233, 99.5651> }
					triangle { <-27.6386, 299.569, 96.9166>, <-29.6651, 299.0354, 99.4847>, <-28.9026, 298.9828, 98.7862> }
					triangle { <-25.886, 300.9094, 103.9111>, <-26.07803, 299.6763, 102.4485>, <-29.3061, 298.6233, 99.5651> }
					triangle { <-26.7905, 302.4638, 103.4031>, <-26.5484, 302.9191, 104.0404>, <-25.886, 300.9094, 103.9111> }
					triangle { <-25.886, 300.9094, 103.9111>, <-29.3061, 298.6233, 99.5651>, <-26.7905, 302.4638, 103.4031> }
					triangle { <-29.6651, 299.0354, 99.4847>, <-26.7905, 302.4638, 103.4031>, <-29.3061, 298.6233, 99.5651> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-27.6386, 299.569, 96.9166>, <-28.3409, 299.3174, 97.1892>, <-29.245, 299.1015, 98.5407> }
					triangle { <-28.3409, 299.3174, 97.1892>, <-29.9908, 298.8607, 99.07426>, <-29.245, 299.1015, 98.5407> }
					triangle { <-29.9908, 298.8607, 99.07426>, <-29.6651, 299.0354, 99.4847>, <-29.245, 299.1015, 98.5407> }
					triangle { <-29.245, 299.1015, 98.5407>, <-29.6651, 299.0354, 99.4847>, <-27.6386, 299.569, 96.9166> }
					triangle { <-29.9908, 298.8607, 99.07426>, <-32.8595, 301.9744, 97.5746>, <-33.5991, 303.584, 98.3804> }
					triangle { <-33.5991, 303.584, 98.3804>, <-32.7751, 305.0247, 99.5643>, <-32.2914, 304.3713, 99.4586> }
					triangle { <-32.2914, 304.3713, 99.4586>, <-29.9908, 298.8607, 99.07426>, <-33.5991, 303.584, 98.3804> }
					triangle { <-29.9908, 298.8607, 99.07426>, <-32.2914, 304.3713, 99.4586>, <-29.6651, 299.0354, 99.4847> }
					triangle { <-28.8637, 299.2908, 98.8809>, <-27.7691, 299.6013, 97.6994>, <-27.6386, 299.569, 96.9166> }
					triangle { <-28.8637, 299.2908, 98.8809>, <-29.2283, 299.2393, 99.7545>, <-27.7691, 299.6013, 97.6994> }
					triangle { <-28.8637, 299.2908, 98.8809>, <-29.6651, 299.0354, 99.4847>, <-29.2283, 299.2393, 99.7545> }
					triangle { <-27.6386, 299.569, 96.9166>, <-29.6651, 299.0354, 99.4847>, <-28.8637, 299.2908, 98.8809> }
					triangle { <-30.994, 304.8776, 100.7048>, <-29.5556, 303.615, 100.5227>, <-29.2283, 299.2393, 99.7545> }
					triangle { <-32.2914, 304.3713, 99.4586>, <-32.7751, 305.0247, 99.5643>, <-30.994, 304.8776, 100.7048> }
					triangle { <-30.994, 304.8776, 100.7048>, <-29.2283, 299.2393, 99.7545>, <-32.2914, 304.3713, 99.4586> }
					triangle { <-29.6651, 299.0354, 99.4847>, <-32.2914, 304.3713, 99.4586>, <-29.2283, 299.2393, 99.7545> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-6.5444, 279.0665, 50.6908>, <-6.6255, 281.3706, 51.1669>, 0.2999 }
			cylinder { <-6.6255, 281.3706, 51.1669>, <-6.7326, 283.6569, 51.7184>, 0.2999 }
			cylinder { <-6.7326, 283.6569, 51.7184>, <-6.8655, 285.9225, 52.3446>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-6.8655, 285.9225, 52.3446>, <-5.3472, 287.6873, 51.995>, 0.2999 }
			cylinder { <-5.3472, 287.6873, 51.995>, <-3.7809, 289.4008, 51.6036>, 0.2999 }
			cylinder { <-3.7809, 289.4008, 51.6036>, <-2.1686, 291.0609, 51.1708>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.1686, 291.0609, 51.1708>, <1.2758, 296.9949, 49.4957>, 0.2999 }
				cylinder { <1.2758, 296.9949, 49.4957>, <3.1218, 303.5268, 47.5439>, 0.2999 }
				cylinder { <3.1218, 303.5268, 47.5439>, <3.2583, 310.2652, 45.4325>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <3.2583, 310.2652, 45.4325>, <2.8557, 310.9891, 45.4402>, <2.9317, 312.6259, 44.9485> }
					triangle { <2.8557, 310.9891, 45.4402>, <2.6491, 313.5666, 44.8343>, <2.9317, 312.6259, 44.9485> }
					triangle { <2.6491, 313.5666, 44.8343>, <3.1548, 313.6092, 44.5616>, <2.9317, 312.6259, 44.9485> }
					triangle { <2.9317, 312.6259, 44.9485>, <3.1548, 313.6092, 44.5616>, <3.2583, 310.2652, 45.4325> }
					triangle { <2.6491, 313.5666, 44.8343>, <-0.9889, 312.8091, 41.9821>, <-1.2861, 313.1666, 40.00634> }
					triangle { <-1.2861, 313.1666, 40.00634>, <-0.01829, 312.9604, 38.3118>, <0.391, 312.8735, 39.05748> }
					triangle { <0.391, 312.8735, 39.05748>, <2.6491, 313.5666, 44.8343>, <-1.2861, 313.1666, 40.00634> }
					triangle { <2.6491, 313.5666, 44.8343>, <0.391, 312.8735, 39.05748>, <3.1548, 313.6092, 44.5616> }
					triangle { <3.4403, 312.5769, 44.6997>, <3.6185, 310.9155, 45.06699>, <3.2583, 310.2652, 45.4325> }
					triangle { <3.4403, 312.5769, 44.6997>, <3.6662, 313.4685, 44.3367>, <3.6185, 310.9155, 45.06699> }
					triangle { <3.4403, 312.5769, 44.6997>, <3.1548, 313.6092, 44.5616>, <3.6662, 313.4685, 44.3367> }
					triangle { <3.2583, 310.2652, 45.4325>, <3.1548, 313.6092, 44.5616>, <3.4403, 312.5769, 44.6997> }
					triangle { <2.189, 312.8314, 38.3061>, <3.4185, 312.3839, 39.8257>, <3.6662, 313.4685, 44.3367> }
					triangle { <0.391, 312.8735, 39.05748>, <-0.01829, 312.9604, 38.3118>, <2.189, 312.8314, 38.3061> }
					triangle { <2.189, 312.8314, 38.3061>, <3.6662, 313.4685, 44.3367>, <0.391, 312.8735, 39.05748> }
					triangle { <3.1548, 313.6092, 44.5616>, <0.391, 312.8735, 39.05748>, <3.6662, 313.4685, 44.3367> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <3.2583, 310.2652, 45.4325>, <3.2976, 311.0604, 45.6614>, <3.2264, 312.6735, 45.09599> }
					triangle { <3.2976, 311.0604, 45.6614>, <3.2384, 313.6617, 45.1292>, <3.2264, 312.6735, 45.09599> }
					triangle { <3.2384, 313.6617, 45.1292>, <3.1548, 313.6092, 44.5616>, <3.2264, 312.6735, 45.09599> }
					triangle { <3.2264, 312.6735, 45.09599>, <3.1548, 313.6092, 44.5616>, <3.2583, 310.2652, 45.4325> }
					triangle { <3.2384, 313.6617, 45.1292>, <-0.7055, 314.2761, 47.5812>, <-2.5454, 314.969, 47.07684> }
					triangle { <-2.5454, 314.969, 47.07684>, <-3.7573, 314.6786, 45.3539>, <-2.959, 314.386, 45.2634> }
					triangle { <-2.959, 314.386, 45.2634>, <3.2384, 313.6617, 45.1292>, <-2.5454, 314.969, 47.07684> }
					triangle { <3.2384, 313.6617, 45.1292>, <-2.959, 314.386, 45.2634>, <3.1548, 313.6092, 44.5616> }
					triangle { <3.1457, 312.5294, 44.5522>, <3.1765, 310.8442, 44.8457>, <3.2583, 310.2652, 45.4325> }
					triangle { <3.1457, 312.5294, 44.5522>, <3.07697, 313.3734, 44.04177>, <3.1765, 310.8442, 44.8457> }
					triangle { <3.1457, 312.5294, 44.5522>, <3.1548, 313.6092, 44.5616>, <3.07697, 313.3734, 44.04177> }
					triangle { <3.2583, 310.2652, 45.4325>, <3.1548, 313.6092, 44.5616>, <3.1457, 312.5294, 44.5522> }
					triangle { <-3.09713, 313.9843, 43.3612>, <-1.4052, 313.0271, 42.8687>, <3.07697, 313.3734, 44.04177> }
					triangle { <-2.959, 314.386, 45.2634>, <-3.7573, 314.6786, 45.3539>, <-3.09713, 313.9843, 43.3612> }
					triangle { <-3.09713, 313.9843, 43.3612>, <3.07697, 313.3734, 44.04177>, <-2.959, 314.386, 45.2634> }
					triangle { <3.1548, 313.6092, 44.5616>, <-2.959, 314.386, 45.2634>, <3.07697, 313.3734, 44.04177> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <3.2583, 310.2652, 45.4325>, <3.6565, 310.9833, 45.3228>, <3.4656, 312.6221, 44.8702> }
					triangle { <3.6565, 310.9833, 45.3228>, <3.7169, 313.5589, 44.6778>, <3.4656, 312.6221, 44.8702> }
					triangle { <3.7169, 313.5589, 44.6778>, <3.1548, 313.6092, 44.5616>, <3.4656, 312.6221, 44.8702> }
					triangle { <3.4656, 312.6221, 44.8702>, <3.1548, 313.6092, 44.5616>, <3.2583, 310.2652, 45.4325> }
					triangle { <3.7169, 313.5589, 44.6778>, <4.8768, 314.8277, 49.03556>, <3.9846, 316.0367, 50.4001> }
					triangle { <3.9846, 316.0367, 50.4001>, <1.9487, 316.3123, 50.9482>, <2.0519, 315.8383, 50.2441> }
					triangle { <2.0519, 315.8383, 50.2441>, <3.7169, 313.5589, 44.6778>, <3.9846, 316.0367, 50.4001> }
					triangle { <3.7169, 313.5589, 44.6778>, <2.0519, 315.8383, 50.2441>, <3.1548, 313.6092, 44.5616> }
					triangle { <2.9064, 312.5807, 44.7779>, <2.8177, 310.9213, 45.1843>, <3.2583, 310.2652, 45.4325> }
					triangle { <2.9064, 312.5807, 44.7779>, <2.5984, 313.4762, 44.4932>, <2.8177, 310.9213, 45.1843> }
					triangle { <2.9064, 312.5807, 44.7779>, <3.1548, 313.6092, 44.5616>, <2.5984, 313.4762, 44.4932> }
					triangle { <3.2583, 310.2652, 45.4325>, <3.1548, 313.6092, 44.5616>, <2.9064, 312.5807, 44.7779> }
					triangle { <0.1633, 315.7541, 49.7693>, <0.03034, 314.4692, 48.2354>, <2.5984, 313.4762, 44.4932> }
					triangle { <2.0519, 315.8383, 50.2441>, <1.9487, 316.3123, 50.9482>, <0.1633, 315.7541, 49.7693> }
					triangle { <0.1633, 315.7541, 49.7693>, <2.5984, 313.4762, 44.4932>, <2.0519, 315.8383, 50.2441> }
					triangle { <3.1548, 313.6092, 44.5616>, <2.0519, 315.8383, 50.2441>, <2.5984, 313.4762, 44.4932> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <3.2583, 310.2652, 45.4325>, <3.4397, 310.8637, 44.8892>, <3.3211, 312.5423, 44.5812> }
					triangle { <3.4397, 310.8637, 44.8892>, <3.4278, 313.3994, 44.09969>, <3.3211, 312.5423, 44.5812> }
					triangle { <3.4278, 313.3994, 44.09969>, <3.1548, 313.6092, 44.5616>, <3.3211, 312.5423, 44.5812> }
					triangle { <3.3211, 312.5423, 44.5812>, <3.1548, 313.6092, 44.5616>, <3.2583, 310.2652, 45.4325> }
					triangle { <3.4278, 313.3994, 44.09969>, <8.09561, 313.7067, 44.3488>, <9.3407, 314.9041, 45.4145> }
					triangle { <9.3407, 314.9041, 45.4145>, <9.2675, 315.6188, 47.4158>, <8.5456, 315.2368, 47.1627> }
					triangle { <8.5456, 315.2368, 47.1627>, <3.4278, 313.3994, 44.09969>, <9.3407, 314.9041, 45.4145> }
					triangle { <3.4278, 313.3994, 44.09969>, <8.5456, 315.2368, 47.1627>, <3.1548, 313.6092, 44.5616> }
					triangle { <3.05102, 312.6605, 45.06704>, <3.03455, 311.041, 45.6179>, <3.2583, 310.2652, 45.4325> }
					triangle { <3.05102, 312.6605, 45.06704>, <2.8876, 313.6357, 45.07135>, <3.03455, 311.041, 45.6179> }
					triangle { <3.05102, 312.6605, 45.06704>, <3.1548, 313.6092, 44.5616>, <2.8876, 313.6357, 45.07135> }
					triangle { <3.2583, 310.2652, 45.4325>, <3.1548, 313.6092, 44.5616>, <3.05102, 312.6605, 45.06704> }
					triangle { <7.495, 315.7115, 48.7344>, <5.7547, 314.7308, 48.5593>, <2.8876, 313.6357, 45.07135> }
					triangle { <8.5456, 315.2368, 47.1627>, <9.2675, 315.6188, 47.4158>, <7.495, 315.7115, 48.7344> }
					triangle { <7.495, 315.7115, 48.7344>, <2.8876, 313.6357, 45.07135>, <8.5456, 315.2368, 47.1627> }
					triangle { <3.1548, 313.6092, 44.5616>, <8.5456, 315.2368, 47.1627>, <2.8876, 313.6357, 45.07135> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <3.2583, 310.2652, 45.4325>, <2.9372, 310.8673, 44.9628>, <2.9861, 312.5447, 44.6302> }
					triangle { <2.9372, 310.8673, 44.9628>, <2.7579, 313.4042, 44.1978>, <2.9861, 312.5447, 44.6302> }
					triangle { <2.7579, 313.4042, 44.1978>, <3.1548, 313.6092, 44.5616>, <2.9861, 312.5447, 44.6302> }
					triangle { <2.9861, 312.5447, 44.6302>, <3.1548, 313.6092, 44.5616>, <3.2583, 310.2652, 45.4325> }
					triangle { <2.7579, 313.4042, 44.1978>, <4.4156, 312.4403, 39.9237>, <6.03406, 313.1035, 38.8938> }
					triangle { <6.03406, 313.1035, 38.8938>, <8.03354, 313.516, 39.4881>, <7.5037, 313.3768, 40.1447> }
					triangle { <7.5037, 313.3768, 40.1447>, <2.7579, 313.4042, 44.1978>, <6.03406, 313.1035, 38.8938> }
					triangle { <2.7579, 313.4042, 44.1978>, <7.5037, 313.3768, 40.1447>, <3.1548, 313.6092, 44.5616> }
					triangle { <3.3859, 312.6581, 45.01794>, <3.5369, 311.0373, 45.5443>, <3.2583, 310.2652, 45.4325> }
					triangle { <3.3859, 312.6581, 45.01794>, <3.5574, 313.6309, 44.9731>, <3.5369, 311.0373, 45.5443> }
					triangle { <3.3859, 312.6581, 45.01794>, <3.1548, 313.6092, 44.5616>, <3.5574, 313.6309, 44.9731> }
					triangle { <3.2583, 310.2652, 45.4325>, <3.1548, 313.6092, 44.5616>, <3.3859, 312.6581, 45.01794> }
					triangle { <8.7659, 313.8779, 41.5428>, <7.8803, 313.4226, 43.2834>, <3.5574, 313.6309, 44.9731> }
					triangle { <7.5037, 313.3768, 40.1447>, <8.03354, 313.516, 39.4881>, <8.7659, 313.8779, 41.5428> }
					triangle { <8.7659, 313.8779, 41.5428>, <3.5574, 313.6309, 44.9731>, <7.5037, 313.3768, 40.1447> }
					triangle { <3.1548, 313.6092, 44.5616>, <7.5037, 313.3768, 40.1447>, <3.5574, 313.6309, 44.9731> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-2.1686, 291.0609, 51.1708>, <-0.6169, 292.7737, 50.7224>, 0.2999 }
			cylinder { <-0.6169, 292.7737, 50.7224>, <0.8725, 294.537, 50.2588>, 0.2999 }
			cylinder { <0.8725, 294.537, 50.2588>, <2.2977, 296.3487, 49.7805>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.2977, 296.3487, 49.7805>, <7.3895, 301.2433, 49.7711>, 0.2999 }
				cylinder { <7.3895, 301.2433, 49.7711>, <12.992, 305.3039, 51.1876>, 0.2999 }
				cylinder { <12.992, 305.3039, 51.1876>, <18.7695, 308.287, 53.9452>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <18.7695, 308.287, 53.9452>, <19.4521, 308.2754, 54.4144>, <20.757, 309.2195, 54.9914> }
					triangle { <19.4521, 308.2754, 54.4144>, <21.5859, 309.4411, 55.483>, <20.757, 309.2195, 54.9914> }
					triangle { <21.5859, 309.4411, 55.483>, <21.4978, 309.961, 55.251>, <20.757, 309.2195, 54.9914> }
					triangle { <20.757, 309.2195, 54.9914>, <21.4978, 309.961, 55.251>, <18.7695, 308.287, 53.9452> }
					triangle { <21.5859, 309.4411, 55.483>, <19.9013, 308.9907, 59.8309>, <19.4594, 310.3395, 61.2818> }
					triangle { <19.4594, 310.3395, 61.2818>, <18.5519, 312.2614, 61.2159>, <18.7514, 311.951, 60.4446> }
					triangle { <18.7514, 311.951, 60.4446>, <21.5859, 309.4411, 55.483>, <19.4594, 310.3395, 61.2818> }
					triangle { <21.5859, 309.4411, 55.483>, <18.7514, 311.951, 60.4446>, <21.4978, 309.961, 55.251> }
					triangle { <20.5942, 309.6936, 54.7236>, <19.208, 308.9866, 54.01281>, <18.7695, 308.287, 53.9452> }
					triangle { <20.5942, 309.6936, 54.7236>, <21.2603, 310.3893, 54.9475>, <19.208, 308.9866, 54.01281> }
					triangle { <20.5942, 309.6936, 54.7236>, <21.4978, 309.961, 55.251>, <21.2603, 310.3893, 54.9475> }
					triangle { <18.7695, 308.287, 53.9452>, <21.4978, 309.961, 55.251>, <20.5942, 309.6936, 54.7236> }
					triangle { <18.3473, 313.5793, 59.4524>, <18.4908, 313.0997, 57.5106>, <21.2603, 310.3893, 54.9475> }
					triangle { <18.7514, 311.951, 60.4446>, <18.5519, 312.2614, 61.2159>, <18.3473, 313.5793, 59.4524> }
					triangle { <18.3473, 313.5793, 59.4524>, <21.2603, 310.3893, 54.9475>, <18.7514, 311.951, 60.4446> }
					triangle { <21.4978, 309.961, 55.251>, <18.7514, 311.951, 60.4446>, <21.2603, 310.3893, 54.9475> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.7695, 308.287, 53.9452>, <19.5882, 308.4128, 53.9539>, <20.8477, 309.311, 54.6844> }
					triangle { <19.5882, 308.4128, 53.9539>, <21.7673, 309.6242, 54.8691>, <20.8477, 309.311, 54.6844> }
					triangle { <21.7673, 309.6242, 54.8691>, <21.4978, 309.961, 55.251>, <20.8477, 309.311, 54.6844> }
					triangle { <20.8477, 309.311, 54.6844>, <21.4978, 309.961, 55.251>, <18.7695, 308.287, 53.9452> }
					triangle { <21.7673, 309.6242, 54.8691>, <23.4508, 305.652, 56.6946>, <23.9572, 305.1125, 58.5846> }
					triangle { <23.9572, 305.1125, 58.5846>, <23.05567, 305.5023, 60.4705>, <22.7209, 305.9601, 59.8306> }
					triangle { <22.7209, 305.9601, 59.8306>, <21.7673, 309.6242, 54.8691>, <23.9572, 305.1125, 58.5846> }
					triangle { <21.7673, 309.6242, 54.8691>, <22.7209, 305.9601, 59.8306>, <21.4978, 309.961, 55.251> }
					triangle { <20.5035, 309.602, 55.03062>, <19.07199, 308.8492, 54.4732>, <18.7695, 308.287, 53.9452> }
					triangle { <20.5035, 309.602, 55.03062>, <21.07895, 310.2061, 55.5614>, <19.07199, 308.8492, 54.4732> }
					triangle { <20.5035, 309.602, 55.03062>, <21.4978, 309.961, 55.251>, <21.07895, 310.2061, 55.5614> }
					triangle { <18.7695, 308.287, 53.9452>, <21.4978, 309.961, 55.251>, <20.5035, 309.602, 55.03062> }
					triangle { <21.6053, 307.101, 60.9499>, <20.4678, 308.1738, 59.6945>, <21.07895, 310.2061, 55.5614> }
					triangle { <22.7209, 305.9601, 59.8306>, <23.05567, 305.5023, 60.4705>, <21.6053, 307.101, 60.9499> }
					triangle { <21.6053, 307.101, 60.9499>, <21.07895, 310.2061, 55.5614>, <22.7209, 305.9601, 59.8306> }
					triangle { <21.4978, 309.961, 55.251>, <22.7209, 305.9601, 59.8306>, <21.07895, 310.2061, 55.5614> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.7695, 308.287, 53.9452>, <19.37, 308.8497, 53.8499>, <20.7022, 309.6023, 54.6151> }
					triangle { <19.37, 308.8497, 53.8499>, <21.4763, 310.2067, 54.7304>, <20.7022, 309.6023, 54.6151> }
					triangle { <21.4763, 310.2067, 54.7304>, <21.4978, 309.961, 55.251>, <20.7022, 309.6023, 54.6151> }
					triangle { <20.7022, 309.6023, 54.6151>, <21.4978, 309.961, 55.251>, <18.7695, 308.287, 53.9452> }
					triangle { <21.4763, 310.2067, 54.7304>, <24.3196, 308.228, 51.5768>, <26.0027, 307.1073, 51.7535> }
					triangle { <26.0027, 307.1073, 51.7535>, <26.5498, 305.5559, 53.1008>, <25.8324, 305.9646, 53.3234> }
					triangle { <25.8324, 305.9646, 53.3234>, <21.4763, 310.2067, 54.7304>, <26.0027, 307.1073, 51.7535> }
					triangle { <21.4763, 310.2067, 54.7304>, <25.8324, 305.9646, 53.3234>, <21.4978, 309.961, 55.251> }
					triangle { <20.649, 309.3108, 55.09999>, <19.2902, 308.4124, 54.5772>, <18.7695, 308.287, 53.9452> }
					triangle { <20.649, 309.3108, 55.09999>, <21.3699, 309.6236, 55.7001>, <19.2902, 308.4124, 54.5772> }
					triangle { <20.649, 309.3108, 55.09999>, <21.4978, 309.961, 55.251>, <21.3699, 309.6236, 55.7001> }
					triangle { <18.7695, 308.287, 53.9452>, <21.4978, 309.961, 55.251>, <20.649, 309.3108, 55.09999> }
					triangle { <25.6393, 305.115, 55.06697>, <23.8587, 305.7011, 55.7791>, <21.3699, 309.6236, 55.7001> }
					triangle { <25.8324, 305.9646, 53.3234>, <26.5498, 305.5559, 53.1008>, <25.6393, 305.115, 55.06697> }
					triangle { <25.6393, 305.115, 55.06697>, <21.3699, 309.6236, 55.7001>, <25.8324, 305.9646, 53.3234> }
					triangle { <21.4978, 309.961, 55.251>, <25.8324, 305.9646, 53.3234>, <21.3699, 309.6236, 55.7001> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.7695, 308.287, 53.9452>, <19.09701, 308.9865, 54.245>, <20.5202, 309.6935, 54.8785> }
					triangle { <19.09701, 308.9865, 54.245>, <21.1123, 310.3891, 55.2572>, <20.5202, 309.6935, 54.8785> }
					triangle { <21.1123, 310.3891, 55.2572>, <21.4978, 309.961, 55.251>, <20.5202, 309.6935, 54.8785> }
					triangle { <20.5202, 309.6935, 54.8785>, <21.4978, 309.961, 55.251>, <18.7695, 308.287, 53.9452> }
					triangle { <21.1123, 310.3891, 55.2572>, <21.3152, 313.1828, 51.5024>, <22.788, 313.5858, 50.1652> }
					triangle { <22.788, 313.5858, 50.1652>, <24.2381, 312.3487, 49.2227>, <23.815, 311.9584, 49.855> }
					triangle { <23.815, 311.9584, 49.855>, <21.1123, 310.3891, 55.2572>, <22.788, 313.5858, 50.1652> }
					triangle { <21.1123, 310.3891, 55.2572>, <23.815, 311.9584, 49.855>, <21.4978, 309.961, 55.251> }
					triangle { <20.831, 309.2196, 54.8365>, <19.5632, 308.2756, 54.1821>, <18.7695, 308.287, 53.9452> }
					triangle { <20.831, 309.2196, 54.8365>, <21.7339, 309.4413, 55.1733>, <19.5632, 308.2756, 54.1821> }
					triangle { <20.831, 309.2196, 54.8365>, <21.4978, 309.961, 55.251>, <21.7339, 309.4413, 55.1733> }
					triangle { <18.7695, 308.287, 53.9452>, <21.4978, 309.961, 55.251>, <20.831, 309.2196, 54.8365> }
					triangle { <24.912, 310.3475, 49.8786>, <24.00906, 309.0757, 51.1389>, <21.7339, 309.4413, 55.1733> }
					triangle { <23.815, 311.9584, 49.855>, <24.2381, 312.3487, 49.2227>, <24.912, 310.3475, 49.8786> }
					triangle { <24.912, 310.3475, 49.8786>, <21.7339, 309.4413, 55.1733>, <23.815, 311.9584, 49.855> }
					triangle { <21.4978, 309.961, 55.251>, <23.815, 311.9584, 49.855>, <21.7339, 309.4413, 55.1733> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.7695, 308.287, 53.9452>, <19.1485, 308.6262, 54.5991>, <20.5546, 309.4533, 55.1146> }
					triangle { <19.1485, 308.6262, 54.5991>, <21.181, 309.9087, 55.7294>, <20.5546, 309.4533, 55.1146> }
					triangle { <21.181, 309.9087, 55.7294>, <21.4978, 309.961, 55.251>, <20.5546, 309.4533, 55.1146> }
					triangle { <20.5546, 309.4533, 55.1146>, <21.4978, 309.961, 55.251>, <18.7695, 308.287, 53.9452> }
					triangle { <21.181, 309.9087, 55.7294>, <18.5433, 313.6613, 56.6807>, <18.6831, 315.6135, 56.1429> }
					triangle { <18.6831, 315.6135, 56.1429>, <19.2205, 316.5554, 54.3139>, <19.3726, 315.714, 54.3225> }
					triangle { <19.3726, 315.714, 54.3225>, <21.181, 309.9087, 55.7294>, <18.6831, 315.6135, 56.1429> }
					triangle { <21.181, 309.9087, 55.7294>, <19.3726, 315.714, 54.3225>, <21.4978, 309.961, 55.251> }
					triangle { <20.7966, 309.4598, 54.6004>, <19.5116, 308.6359, 53.828>, <18.7695, 308.287, 53.9452> }
					triangle { <20.7966, 309.4598, 54.6004>, <21.6652, 309.9216, 54.7011>, <19.5116, 308.6359, 53.828> }
					triangle { <20.7966, 309.4598, 54.6004>, <21.4978, 309.961, 55.251>, <21.6652, 309.9216, 54.7011> }
					triangle { <18.7695, 308.287, 53.9452>, <21.4978, 309.961, 55.251>, <20.7966, 309.4598, 54.6004> }
					triangle { <20.3373, 315.6577, 52.6298>, <20.6414, 313.7173, 52.2251>, <21.6652, 309.9216, 54.7011> }
					triangle { <19.3726, 315.714, 54.3225>, <19.2205, 316.5554, 54.3139>, <20.3373, 315.6577, 52.6298> }
					triangle { <20.3373, 315.6577, 52.6298>, <21.6652, 309.9216, 54.7011>, <19.3726, 315.714, 54.3225> }
					triangle { <21.4978, 309.961, 55.251>, <19.3726, 315.714, 54.3225>, <21.6652, 309.9216, 54.7011> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <2.2977, 296.3487, 49.7805>, <3.7693, 298.139, 49.366>, 0.2999 }
			cylinder { <3.7693, 298.139, 49.366>, <5.2855, 299.9057, 49.01587>, 0.2999 }
			cylinder { <5.2855, 299.9057, 49.01587>, <6.8443, 301.6467, 48.7304>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.8443, 301.6467, 48.7304>, <11.4255, 306.3967, 46.2137>, 0.2999 }
				cylinder { <11.4255, 306.3967, 46.2137>, <15.6366, 310.3889, 42.1874>, 0.2999 }
				cylinder { <15.6366, 310.3889, 42.1874>, <19.2253, 313.3842, 36.8928>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <19.2253, 313.3842, 36.8928>, <19.2808, 313.5684, 36.08711>, <20.2489, 314.3304, 34.9001> }
					triangle { <19.2808, 313.5684, 36.08711>, <20.5265, 314.6541, 34.00798>, <20.2489, 314.3304, 34.9001> }
					triangle { <20.5265, 314.6541, 34.00798>, <20.9819, 314.8503, 34.3013>, <20.2489, 314.3304, 34.9001> }
					triangle { <20.2489, 314.3304, 34.9001>, <20.9819, 314.8503, 34.3013>, <19.2253, 313.3842, 36.8928> }
					triangle { <20.5265, 314.6541, 34.00798>, <21.2192, 310.4829, 31.9914>, <22.8967, 309.4883, 31.4286> }
					triangle { <22.8967, 309.4883, 31.4286>, <24.803, 309.2714, 32.3453>, <24.308, 309.8587, 32.721> }
					triangle { <24.308, 309.8587, 32.721>, <20.5265, 314.6541, 34.00798>, <22.8967, 309.4883, 31.4286> }
					triangle { <20.5265, 314.6541, 34.00798>, <24.308, 309.8587, 32.721>, <20.9819, 314.8503, 34.3013> }
					triangle { <20.6562, 314.4865, 35.2644>, <19.8917, 313.8025, 36.6336>, <19.2253, 313.3842, 36.8928> }
					triangle { <20.6562, 314.4865, 35.2644>, <21.3411, 314.9662, 34.7366>, <19.8917, 313.8025, 36.6336> }
					triangle { <20.6562, 314.4865, 35.2644>, <20.9819, 314.8503, 34.3013>, <21.3411, 314.9662, 34.7366> }
					triangle { <19.2253, 313.3842, 36.8928>, <20.9819, 314.8503, 34.3013>, <20.6562, 314.4865, 35.2644> }
					triangle { <25.6797, 310.5546, 33.9182>, <24.7489, 311.8353, 35.1489>, <21.3411, 314.9662, 34.7366> }
					triangle { <24.308, 309.8587, 32.721>, <24.803, 309.2714, 32.3453>, <25.6797, 310.5546, 33.9182> }
					triangle { <25.6797, 310.5546, 33.9182>, <21.3411, 314.9662, 34.7366>, <24.308, 309.8587, 32.721> }
					triangle { <20.9819, 314.8503, 34.3013>, <24.308, 309.8587, 32.721>, <21.3411, 314.9662, 34.7366> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <19.2253, 313.3842, 36.8928>, <19.2971, 313.998, 36.3411>, <20.2598, 314.6168, 35.06954> }
					triangle { <19.2971, 313.998, 36.3411>, <20.5483, 315.2269, 34.3467>, <20.2598, 314.6168, 35.06954> }
					triangle { <20.5483, 315.2269, 34.3467>, <20.9819, 314.8503, 34.3013>, <20.2598, 314.6168, 35.06954> }
					triangle { <20.2598, 314.6168, 35.06954>, <20.9819, 314.8503, 34.3013>, <19.2253, 313.3842, 36.8928> }
					triangle { <20.5483, 315.2269, 34.3467>, <17.01753, 314.4258, 31.374>, <16.9064, 313.4395, 29.6035> }
					triangle { <16.9064, 313.4395, 29.6035>, <17.7851, 311.6274, 28.9213>, <18.1001, 311.9, 29.6681> }
					triangle { <18.1001, 311.9, 29.6681>, <20.5483, 315.2269, 34.3467>, <16.9064, 313.4395, 29.6035> }
					triangle { <20.5483, 315.2269, 34.3467>, <18.1001, 311.9, 29.6681>, <20.9819, 314.8503, 34.3013> }
					triangle { <20.6453, 314.2001, 35.0951>, <19.8754, 313.3729, 36.3795>, <19.2253, 313.3842, 36.8928> }
					triangle { <20.6453, 314.2001, 35.0951>, <21.3193, 314.3934, 34.3978>, <19.8754, 313.3729, 36.3795> }
					triangle { <20.6453, 314.2001, 35.0951>, <20.9819, 314.8503, 34.3013>, <21.3193, 314.3934, 34.3978> }
					triangle { <19.2253, 313.3842, 36.8928>, <20.9819, 314.8503, 34.3013>, <20.6453, 314.2001, 35.0951> }
					triangle { <19.5408, 310.5918, 29.7782>, <20.3588, 310.8142, 31.5955>, <21.3193, 314.3934, 34.3978> }
					triangle { <18.1001, 311.9, 29.6681>, <17.7851, 311.6274, 28.9213>, <19.5408, 310.5918, 29.7782> }
					triangle { <19.5408, 310.5918, 29.7782>, <21.3193, 314.3934, 34.3978>, <18.1001, 311.9, 29.6681> }
					triangle { <20.9819, 314.8503, 34.3013>, <18.1001, 311.9, 29.6681>, <21.3193, 314.3934, 34.3978> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <19.2253, 313.3842, 36.8928>, <19.7103, 313.9986, 36.6215>, <20.5352, 314.6172, 35.2564> }
					triangle { <19.7103, 313.9986, 36.6215>, <21.09923, 315.2276, 34.7205>, <20.5352, 314.6172, 35.2564> }
					triangle { <21.09923, 315.2276, 34.7205>, <20.9819, 314.8503, 34.3013>, <20.5352, 314.6172, 35.2564> }
					triangle { <20.5352, 314.6172, 35.2564>, <20.9819, 314.8503, 34.3013>, <19.2253, 313.3842, 36.8928> }
					triangle { <21.09923, 315.2276, 34.7205>, <18.2574, 318.9514, 34.7747>, <17.1048, 319.8234, 33.3496> }
					triangle { <17.1048, 319.8234, 33.3496>, <15.8819, 319.0137, 31.81>, <16.3764, 318.4321, 32.1951> }
					triangle { <16.3764, 318.4321, 32.1951>, <21.09923, 315.2276, 34.7205>, <17.1048, 319.8234, 33.3496> }
					triangle { <21.09923, 315.2276, 34.7205>, <16.3764, 318.4321, 32.1951>, <20.9819, 314.8503, 34.3013> }
					triangle { <20.3698, 314.1997, 34.9081>, <19.4622, 313.3723, 36.09914>, <19.2253, 313.3842, 36.8928> }
					triangle { <20.3698, 314.1997, 34.9081>, <20.7684, 314.3927, 34.02401>, <19.4622, 313.3723, 36.09914> }
					triangle { <20.3698, 314.1997, 34.9081>, <20.9819, 314.8503, 34.3013>, <20.7684, 314.3927, 34.02401> }
					triangle { <19.2253, 313.3842, 36.8928>, <20.9819, 314.8503, 34.3013>, <20.3698, 314.1997, 34.9081> }
					triangle { <15.9746, 316.9706, 30.9696>, <16.824, 315.3333, 31.7562>, <20.7684, 314.3927, 34.02401> }
					triangle { <16.3764, 318.4321, 32.1951>, <15.8819, 319.0137, 31.81>, <15.9746, 316.9706, 30.9696> }
					triangle { <15.9746, 316.9706, 30.9696>, <20.7684, 314.3927, 34.02401>, <16.3764, 318.4321, 32.1951> }
					triangle { <20.9819, 314.8503, 34.3013>, <16.3764, 318.4321, 32.1951>, <20.7684, 314.3927, 34.02401> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <19.2253, 313.3842, 36.8928>, <19.9532, 313.5693, 36.5434>, <20.6972, 314.3311, 35.2043> }
					triangle { <19.9532, 313.5693, 36.5434>, <21.4231, 314.6553, 34.6163>, <20.6972, 314.3311, 35.2043> }
					triangle { <21.4231, 314.6553, 34.6163>, <20.9819, 314.8503, 34.3013>, <20.6972, 314.3311, 35.2043> }
					triangle { <20.6972, 314.3311, 35.2043>, <20.9819, 314.8503, 34.3013>, <19.2253, 313.3842, 36.8928> }
					triangle { <21.4231, 314.6553, 34.6163>, <23.2371, 317.8476, 37.5255>, <23.2196, 319.8773, 37.5248> }
					triangle { <23.2196, 319.8773, 37.5248>, <21.7058, 321.2917, 37.04624>, <21.5029, 320.4888, 36.8334> }
					triangle { <21.5029, 320.4888, 36.8334>, <21.4231, 314.6553, 34.6163>, <23.2196, 319.8773, 37.5248> }
					triangle { <21.4231, 314.6553, 34.6163>, <21.5029, 320.4888, 36.8334>, <20.9819, 314.8503, 34.3013> }
					triangle { <20.2079, 314.4859, 34.9602>, <19.2193, 313.8015, 36.1773>, <19.2253, 313.3842, 36.8928> }
					triangle { <20.2079, 314.4859, 34.9602>, <20.4445, 314.965, 34.1282>, <19.2193, 313.8015, 36.1773> }
					triangle { <20.2079, 314.4859, 34.9602>, <20.9819, 314.8503, 34.3013>, <20.4445, 314.965, 34.1282> }
					triangle { <19.2253, 313.3842, 36.8928>, <20.9819, 314.8503, 34.3013>, <20.2079, 314.4859, 34.9602> }
					triangle { <19.8761, 320.9352, 35.857>, <18.9965, 319.1894, 35.4103>, <20.4445, 314.965, 34.1282> }
					triangle { <21.5029, 320.4888, 36.8334>, <21.7058, 321.2917, 37.04624>, <19.8761, 320.9352, 35.857> }
					triangle { <19.8761, 320.9352, 35.857>, <20.4445, 314.965, 34.1282>, <21.5029, 320.4888, 36.8334> }
					triangle { <20.9819, 314.8503, 34.3013>, <21.5029, 320.4888, 36.8334>, <20.4445, 314.965, 34.1282> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <19.2253, 313.3842, 36.8928>, <19.6838, 313.2995, 36.2081>, <20.5175, 314.1512, 34.9808> }
					triangle { <19.6838, 313.2995, 36.2081>, <21.06386, 314.2955, 34.1693>, <20.5175, 314.1512, 34.9808> }
					triangle { <21.06386, 314.2955, 34.1693>, <20.9819, 314.8503, 34.3013>, <20.5175, 314.1512, 34.9808> }
					triangle { <20.5175, 314.1512, 34.9808>, <20.9819, 314.8503, 34.3013>, <19.2253, 313.3842, 36.8928> }
					triangle { <21.06386, 314.2955, 34.1693>, <25.09528, 312.5348, 35.7794>, <26.8533, 313.3935, 36.3197> }
					triangle { <26.8533, 313.3935, 36.3197>, <27.3026, 315.1797, 37.382>, <26.4789, 315.1102, 37.1634> }
					triangle { <26.4789, 315.1102, 37.1634>, <21.06386, 314.2955, 34.1693>, <26.8533, 313.3935, 36.3197> }
					triangle { <21.06386, 314.2955, 34.1693>, <26.4789, 315.1102, 37.1634>, <20.9819, 314.8503, 34.3013> }
					triangle { <20.3875, 314.6658, 35.1838>, <19.4887, 314.0714, 36.5126>, <19.2253, 313.3842, 36.8928> }
					triangle { <20.3875, 314.6658, 35.1838>, <20.8038, 315.3248, 34.5753>, <19.4887, 314.0714, 36.5126> }
					triangle { <20.3875, 314.6658, 35.1838>, <20.9819, 314.8503, 34.3013>, <20.8038, 315.3248, 34.5753> }
					triangle { <19.2253, 313.3842, 36.8928>, <20.9819, 314.8503, 34.3013>, <20.3875, 314.6658, 35.1838> }
					triangle { <25.9648, 316.91, 37.7068>, <23.9683, 316.9949, 37.5387>, <20.8038, 315.3248, 34.5753> }
					triangle { <26.4789, 315.1102, 37.1634>, <27.3026, 315.1797, 37.382>, <25.9648, 316.91, 37.7068> }
					triangle { <25.9648, 316.91, 37.7068>, <20.8038, 315.3248, 34.5753>, <26.4789, 315.1102, 37.1634> }
					triangle { <20.9819, 314.8503, 34.3013>, <26.4789, 315.1102, 37.1634>, <20.8038, 315.3248, 34.5753> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <6.8443, 301.6467, 48.7304>, <8.4014, 303.3742, 48.3644>, 0.2999 }
			cylinder { <8.4014, 303.3742, 48.3644>, <9.9548, 305.0861, 47.9183>, 0.2999 }
			cylinder { <9.9548, 305.0861, 47.9183>, <11.5026, 306.7802, 47.3926>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <11.5026, 306.7802, 47.3926>, <15.1934, 312.7839, 46.9262>, 0.2999 }
				cylinder { <15.1934, 312.7839, 46.9262>, <17.71, 319.3487, 47.5984>, 0.2999 }
				cylinder { <17.71, 319.3487, 47.5984>, <18.9018, 326.0813, 49.3689>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <18.9018, 326.0813, 49.3689>, <18.8294, 326.7902, 49.7915>, <19.2661, 328.4441, 49.8145> }
					triangle { <18.8294, 326.7902, 49.7915>, <19.3185, 329.3777, 50.1362>, <19.2661, 328.4441, 49.8145> }
					triangle { <19.3185, 329.3777, 50.1362>, <19.6364, 329.4468, 49.6607>, <19.2661, 328.4441, 49.8145> }
					triangle { <19.2661, 328.4441, 49.8145>, <19.6364, 329.4468, 49.6607>, <18.9018, 326.0813, 49.3689> }
					triangle { <19.3185, 329.3777, 50.1362>, <14.8058, 330.5078, 49.5852>, <13.8395, 331.7088, 48.2648> }
					triangle { <13.8395, 331.7088, 48.2648>, <14.09119, 332.0294, 46.1779>, <14.7196, 331.5698, 46.5312> }
					triangle { <14.7196, 331.5698, 46.5312>, <19.3185, 329.3777, 50.1362>, <13.8395, 331.7088, 48.2648> }
					triangle { <19.3185, 329.3777, 50.1362>, <14.7196, 331.5698, 46.5312>, <19.6364, 329.4468, 49.6607> }
					triangle { <19.5639, 328.421, 49.331>, <19.2761, 326.7556, 49.06629>, <18.9018, 326.0813, 49.3689> }
					triangle { <19.5639, 328.421, 49.331>, <19.9141, 329.3315, 49.1693>, <19.2761, 326.7556, 49.06629> }
					triangle { <19.5639, 328.421, 49.331>, <19.6364, 329.4468, 49.6607>, <19.9141, 329.3315, 49.1693> }
					triangle { <18.9018, 326.0813, 49.3689>, <19.6364, 329.4468, 49.6607>, <19.5639, 328.421, 49.331> }
					triangle { <15.8743, 331.5512, 44.961>, <17.3865, 330.3078, 45.3951>, <19.9141, 329.3315, 49.1693> }
					triangle { <14.7196, 331.5698, 46.5312>, <14.09119, 332.0294, 46.1779>, <15.8743, 331.5512, 44.961> }
					triangle { <15.8743, 331.5512, 44.961>, <19.9141, 329.3315, 49.1693>, <14.7196, 331.5698, 46.5312> }
					triangle { <19.6364, 329.4468, 49.6607>, <14.7196, 331.5698, 46.5312>, <19.9141, 329.3315, 49.1693> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.9018, 326.0813, 49.3689>, <19.3165, 326.6872, 49.7525>, <19.5909, 328.3755, 49.7886> }
					triangle { <19.3165, 326.6872, 49.7525>, <19.968, 329.2404, 50.08434>, <19.5909, 328.3755, 49.7886> }
					triangle { <19.968, 329.2404, 50.08434>, <19.6364, 329.4468, 49.6607>, <19.5909, 328.3755, 49.7886> }
					triangle { <19.5909, 328.3755, 49.7886>, <19.6364, 329.4468, 49.6607>, <18.9018, 326.0813, 49.3689> }
					triangle { <19.968, 329.2404, 50.08434>, <17.9663, 329.4077, 54.3164>, <16.4707, 330.5429, 55.08717> }
					triangle { <16.4707, 330.5429, 55.08717>, <14.6224, 331.2113, 54.2756>, <15.1416, 330.8563, 53.6963> }
					triangle { <15.1416, 330.8563, 53.6963>, <19.968, 329.2404, 50.08434>, <16.4707, 330.5429, 55.08717> }
					triangle { <19.968, 329.2404, 50.08434>, <15.1416, 330.8563, 53.6963>, <19.6364, 329.4468, 49.6607> }
					triangle { <19.2392, 328.4897, 49.357>, <18.789, 326.8585, 49.1052>, <18.9018, 326.0813, 49.3689> }
					triangle { <19.2392, 328.4897, 49.357>, <19.2646, 329.4688, 49.2212>, <18.789, 326.8585, 49.1052> }
					triangle { <19.2392, 328.4897, 49.357>, <19.6364, 329.4468, 49.6607>, <19.2646, 329.4688, 49.2212> }
					triangle { <18.9018, 326.0813, 49.3689>, <19.6364, 329.4468, 49.6607>, <19.2392, 328.4897, 49.357> }
					triangle { <14.06768, 331.3232, 52.1381>, <14.9186, 330.3972, 50.5761>, <19.2646, 329.4688, 49.2212> }
					triangle { <15.1416, 330.8563, 53.6963>, <14.6224, 331.2113, 54.2756>, <14.06768, 331.3232, 52.1381> }
					triangle { <14.06768, 331.3232, 52.1381>, <19.2646, 329.4688, 49.2212>, <15.1416, 330.8563, 53.6963> }
					triangle { <19.6364, 329.4468, 49.6607>, <15.1416, 330.8563, 53.6963>, <19.2646, 329.4688, 49.2212> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.9018, 326.0813, 49.3689>, <19.4416, 326.7018, 49.2693>, <19.6742, 328.3852, 49.4664> }
					triangle { <19.4416, 326.7018, 49.2693>, <20.1347, 329.2599, 49.44>, <19.6742, 328.3852, 49.4664> }
					triangle { <20.1347, 329.2599, 49.44>, <19.6364, 329.4468, 49.6607>, <19.6742, 328.3852, 49.4664> }
					triangle { <19.6742, 328.3852, 49.4664>, <19.6364, 329.4468, 49.6607>, <18.9018, 326.0813, 49.3689> }
					triangle { <20.1347, 329.2599, 49.44>, <23.4192, 328.3613, 52.657>, <23.6959, 329.0116, 54.5598> }
					triangle { <23.6959, 329.0116, 54.5598>, <22.34, 329.3634, 56.1595>, <21.9543, 329.2207, 55.4098> }
					triangle { <21.9543, 329.2207, 55.4098>, <20.1347, 329.2599, 49.44>, <23.6959, 329.0116, 54.5598> }
					triangle { <20.1347, 329.2599, 49.44>, <21.9543, 329.2207, 55.4098>, <19.6364, 329.4468, 49.6607> }
					triangle { <19.1558, 328.4799, 49.6791>, <18.664, 326.8439, 49.5884>, <18.9018, 326.0813, 49.3689> }
					triangle { <19.1558, 328.4799, 49.6791>, <19.09795, 329.4493, 49.8655>, <18.664, 326.8439, 49.5884> }
					triangle { <19.1558, 328.4799, 49.6791>, <19.6364, 329.4468, 49.6607>, <19.09795, 329.4493, 49.8655> }
					triangle { <18.9018, 326.0813, 49.3689>, <19.6364, 329.4468, 49.6607>, <19.1558, 328.4799, 49.6791> }
					triangle { <20.1535, 329.6587, 56.01349>, <18.9265, 329.1821, 54.5007>, <19.09795, 329.4493, 49.8655> }
					triangle { <21.9543, 329.2207, 55.4098>, <22.34, 329.3634, 56.1595>, <20.1535, 329.6587, 56.01349> }
					triangle { <20.1535, 329.6587, 56.01349>, <19.09795, 329.4493, 49.8655>, <21.9543, 329.2207, 55.4098> }
					triangle { <19.6364, 329.4468, 49.6607>, <21.9543, 329.2207, 55.4098>, <19.09795, 329.4493, 49.8655> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.9018, 326.0813, 49.3689>, <19.03298, 326.8139, 49.00513>, <19.4018, 328.46, 49.2903> }
					triangle { <19.03298, 326.8139, 49.00513>, <19.5899, 329.4094, 49.08776>, <19.4018, 328.46, 49.2903> }
					triangle { <19.5899, 329.4094, 49.08776>, <19.6364, 329.4468, 49.6607>, <19.4018, 328.46, 49.2903> }
					triangle { <19.4018, 328.46, 49.2903>, <19.6364, 329.4468, 49.6607>, <18.9018, 326.0813, 49.3689> }
					triangle { <19.5899, 329.4094, 49.08776>, <23.6797, 328.805, 46.8849>, <25.5976, 329.2168, 47.4066> }
					triangle { <25.5976, 329.2168, 47.4066>, <26.6504, 329.0222, 49.2437>, <25.8065, 328.908, 49.3198> }
					triangle { <25.8065, 328.908, 49.3198>, <19.5899, 329.4094, 49.08776>, <25.5976, 329.2168, 47.4066> }
					triangle { <19.5899, 329.4094, 49.08776>, <25.8065, 328.908, 49.3198>, <19.6364, 329.4468, 49.6607> }
					triangle { <19.4283, 328.4052, 49.8553>, <19.07264, 326.7318, 49.8526>, <18.9018, 326.0813, 49.3689> }
					triangle { <19.4283, 328.4052, 49.8553>, <19.6427, 329.2999, 50.2178>, <19.07264, 326.7318, 49.8526> }
					triangle { <19.4283, 328.4052, 49.8553>, <19.6364, 329.4468, 49.6607>, <19.6427, 329.2999, 50.2178> }
					triangle { <18.9018, 326.0813, 49.3689>, <19.6364, 329.4468, 49.6607>, <19.4283, 328.4052, 49.8553> }
					triangle { <25.7782, 328.8425, 51.2676>, <23.9089, 328.3303, 51.7817>, <19.6427, 329.2999, 50.2178> }
					triangle { <25.8065, 328.908, 49.3198>, <26.6504, 329.0222, 49.2437>, <25.7782, 328.8425, 51.2676> }
					triangle { <25.7782, 328.8425, 51.2676>, <19.6427, 329.2999, 50.2178>, <25.8065, 328.908, 49.3198> }
					triangle { <19.6364, 329.4468, 49.6607>, <25.8065, 328.908, 49.3198>, <19.6427, 329.2999, 50.2178> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <18.9018, 326.0813, 49.3689>, <18.6489, 326.8694, 49.3327>, <19.1458, 328.4969, 49.5087> }
					triangle { <18.6489, 326.8694, 49.3327>, <19.07787, 329.4833, 49.5245>, <19.1458, 328.4969, 49.5087> }
					triangle { <19.07787, 329.4833, 49.5245>, <19.6364, 329.4468, 49.6607>, <19.1458, 328.4969, 49.5087> }
					triangle { <19.1458, 328.4969, 49.5087>, <19.6364, 329.4468, 49.6607>, <18.9018, 326.0813, 49.3689> }
					triangle { <19.07787, 329.4833, 49.5245>, <18.276, 330.1516, 44.9577>, <19.4141, 330.9089, 43.4573> }
					triangle { <19.4141, 330.9089, 43.4573>, <21.4754, 330.6948, 42.9816>, <21.2676, 330.3817, 43.7496> }
					triangle { <21.2676, 330.3817, 43.7496>, <19.07787, 329.4833, 49.5245>, <19.4141, 330.9089, 43.4573> }
					triangle { <19.07787, 329.4833, 49.5245>, <21.2676, 330.3817, 43.7496>, <19.6364, 329.4468, 49.6607> }
					triangle { <19.6843, 328.3682, 49.6369>, <19.4566, 326.6764, 49.525>, <18.9018, 326.0813, 49.3689> }
					triangle { <19.6843, 328.3682, 49.6369>, <20.1548, 329.226, 49.781>, <19.4566, 326.6764, 49.525> }
					triangle { <19.6843, 328.3682, 49.6369>, <19.6364, 329.4468, 49.6607>, <20.1548, 329.226, 49.781> }
					triangle { <18.9018, 326.0813, 49.3689>, <19.6364, 329.4468, 49.6607>, <19.6843, 328.3682, 49.6369> }
					triangle { <23.09365, 330.0298, 44.3337>, <22.9428, 329.0366, 46.06924>, <20.1548, 329.226, 49.781> }
					triangle { <21.2676, 330.3817, 43.7496>, <21.4754, 330.6948, 42.9816>, <23.09365, 330.0298, 44.3337> }
					triangle { <23.09365, 330.0298, 44.3337>, <20.1548, 329.226, 49.781>, <21.2676, 330.3817, 43.7496> }
					triangle { <19.6364, 329.4468, 49.6607>, <21.2676, 330.3817, 43.7496>, <20.1548, 329.226, 49.781> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <11.5026, 306.7802, 47.3926>, <13.01325, 308.5233, 46.9208>, 0.2999 }
			cylinder { <13.01325, 308.5233, 46.9208>, <14.4847, 310.313, 46.5034>, 0.2999 }
			cylinder { <14.4847, 310.313, 46.5034>, <15.9152, 312.1473, 46.141>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <15.9152, 312.1473, 46.141>, <21.4362, 316.4375, 45.1431>, 0.2999 }
				cylinder { <21.4362, 316.4375, 45.1431>, <27.8556, 319.2578, 44.2945>, 0.2999 }
				cylinder { <27.8556, 319.2578, 44.2945>, <34.7886, 320.4392, 43.6461>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <34.7886, 320.4392, 43.6461>, <35.4668, 320.1224, 43.3805>, <37.07092, 320.3935, 43.1708> }
					triangle { <35.4668, 320.1224, 43.3805>, <37.9694, 320.2227, 42.921>, <37.07092, 320.3935, 43.1708> }
					triangle { <37.9694, 320.2227, 42.921>, <38.04718, 320.7339, 43.1151>, <37.07092, 320.3935, 43.1708> }
					triangle { <37.07092, 320.3935, 43.1708>, <38.04718, 320.7339, 43.1151>, <34.7886, 320.4392, 43.6461> }
					triangle { <37.9694, 320.2227, 42.921>, <38.8417, 316.9867, 45.9111>, <39.9394, 316.9357, 47.5173> }
					triangle { <39.9394, 316.9357, 47.5173>, <40.2449, 318.2903, 49.00998>, <39.8356, 318.596, 48.3687> }
					triangle { <39.8356, 318.596, 48.3687>, <37.9694, 320.2227, 42.921>, <39.9394, 316.9357, 47.5173> }
					triangle { <37.9694, 320.2227, 42.921>, <39.8356, 318.596, 48.3687>, <38.04718, 320.7339, 43.1151> }
					triangle { <37.05942, 320.8967, 43.3795>, <35.4496, 320.8772, 43.6935>, <34.7886, 320.4392, 43.6461> }
					triangle { <37.05942, 320.8967, 43.3795>, <37.9464, 321.229, 43.3383>, <35.4496, 320.8772, 43.6935> }
					triangle { <37.05942, 320.8967, 43.3795>, <38.04718, 320.7339, 43.1151>, <37.9464, 321.229, 43.3383> }
					triangle { <34.7886, 320.4392, 43.6461>, <38.04718, 320.7339, 43.1151>, <37.05942, 320.8967, 43.3795> }
					triangle { <39.8608, 320.3741, 48.9433>, <38.742, 321.3477, 47.7197>, <37.9464, 321.229, 43.3383> }
					triangle { <39.8356, 318.596, 48.3687>, <40.2449, 318.2903, 49.00998>, <39.8608, 320.3741, 48.9433> }
					triangle { <39.8608, 320.3741, 48.9433>, <37.9464, 321.229, 43.3383>, <39.8356, 318.596, 48.3687> }
					triangle { <38.04718, 320.7339, 43.1151>, <39.8356, 318.596, 48.3687>, <37.9464, 321.229, 43.3383> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <34.7886, 320.4392, 43.6461>, <35.3903, 320.5262, 43.1349>, <37.01989, 320.6627, 43.00713> }
					triangle { <35.3903, 320.5262, 43.1349>, <37.8673, 320.761, 42.5935>, <37.01989, 320.6627, 43.00713> }
					triangle { <37.8673, 320.761, 42.5935>, <38.04718, 320.7339, 43.1151>, <37.01989, 320.6627, 43.00713> }
					triangle { <37.01989, 320.6627, 43.00713>, <38.04718, 320.7339, 43.1151>, <34.7886, 320.4392, 43.6461> }
					triangle { <37.8673, 320.761, 42.5935>, <37.9624, 316.8277, 40.4272>, <38.986, 315.1953, 40.7009> }
					triangle { <38.986, 315.1953, 40.7009>, <39.5364, 314.1915, 42.3878>, <39.2166, 314.9315, 42.5366> }
					triangle { <39.2166, 314.9315, 42.5366>, <37.8673, 320.761, 42.5935>, <38.986, 315.1953, 40.7009> }
					triangle { <37.8673, 320.761, 42.5935>, <39.2166, 314.9315, 42.5366>, <38.04718, 320.7339, 43.1151> }
					triangle { <37.1104, 320.6275, 43.5432>, <35.5261, 320.4734, 43.9391>, <34.7886, 320.4392, 43.6461> }
					triangle { <37.1104, 320.6275, 43.5432>, <38.04846, 320.6906, 43.6658>, <35.5261, 320.4734, 43.9391> }
					triangle { <37.1104, 320.6275, 43.5432>, <38.04718, 320.7339, 43.1151>, <38.04846, 320.6906, 43.6658> }
					triangle { <34.7886, 320.4392, 43.6461>, <38.04718, 320.7339, 43.1151>, <37.1104, 320.6275, 43.5432> }
					triangle { <39.6048, 314.9547, 44.3645>, <38.7472, 316.5226, 45.07379>, <38.04846, 320.6906, 43.6658> }
					triangle { <39.2166, 314.9315, 42.5366>, <39.5364, 314.1915, 42.3878>, <39.6048, 314.9547, 44.3645> }
					triangle { <39.6048, 314.9547, 44.3645>, <38.04846, 320.6906, 43.6658>, <39.2166, 314.9315, 42.5366> }
					triangle { <38.04718, 320.7339, 43.1151>, <39.2166, 314.9315, 42.5366>, <38.04846, 320.6906, 43.6658> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <34.7886, 320.4392, 43.6461>, <35.407, 320.8937, 43.4413>, <37.03101, 320.9077, 43.2113> }
					triangle { <35.407, 320.8937, 43.4413>, <37.8896, 321.2511, 43.00204>, <37.03101, 320.9077, 43.2113> }
					triangle { <37.8896, 321.2511, 43.00204>, <38.04718, 320.7339, 43.1151>, <37.03101, 320.9077, 43.2113> }
					triangle { <37.03101, 320.9077, 43.2113>, <38.04718, 320.7339, 43.1151>, <34.7886, 320.4392, 43.6461> }
					triangle { <37.8896, 321.2511, 43.00204>, <37.1994, 322.0305, 38.6328>, <37.8467, 321.1572, 37.01868> }
					triangle { <37.8467, 321.1572, 37.01868>, <38.1316, 319.195, 36.5443>, <37.9726, 319.3203, 37.3388> }
					triangle { <37.9726, 319.3203, 37.3388>, <37.8896, 321.2511, 43.00204>, <37.8467, 321.1572, 37.01868> }
					triangle { <37.8896, 321.2511, 43.00204>, <37.9726, 319.3203, 37.3388>, <38.04718, 320.7339, 43.1151> }
					triangle { <37.09932, 320.3825, 43.339>, <35.5094, 320.1058, 43.6328>, <34.7886, 320.4392, 43.6461> }
					triangle { <37.09932, 320.3825, 43.339>, <38.02621, 320.2006, 43.2573>, <35.5094, 320.1058, 43.6328> }
					triangle { <37.09932, 320.3825, 43.339>, <38.04718, 320.7339, 43.1151>, <38.02621, 320.2006, 43.2573> }
					triangle { <34.7886, 320.4392, 43.6461>, <38.04718, 320.7339, 43.1151>, <37.09932, 320.3825, 43.339> }
					triangle { <38.3135, 317.5678, 37.891>, <37.7914, 317.4781, 39.7393>, <38.02621, 320.2006, 43.2573> }
					triangle { <37.9726, 319.3203, 37.3388>, <38.1316, 319.195, 36.5443>, <38.3135, 317.5678, 37.891> }
					triangle { <38.3135, 317.5678, 37.891>, <38.02621, 320.2006, 43.2573>, <37.9726, 319.3203, 37.3388> }
					triangle { <38.04718, 320.7339, 43.1151>, <37.9726, 319.3203, 37.3388>, <38.02621, 320.2006, 43.2573> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <34.7886, 320.4392, 43.6461>, <35.494, 320.7206, 43.8791>, <37.08902, 320.7923, 43.5032> }
					triangle { <35.494, 320.7206, 43.8791>, <38.00561, 321.0202, 43.5857>, <37.08902, 320.7923, 43.5032> }
					triangle { <38.00561, 321.0202, 43.5857>, <38.04718, 320.7339, 43.1151>, <37.08902, 320.7923, 43.5032> }
					triangle { <37.08902, 320.7923, 43.5032>, <38.04718, 320.7339, 43.1151>, <34.7886, 320.4392, 43.6461> }
					triangle { <38.00561, 321.0202, 43.5857>, <37.6001, 325.4536, 42.991>, <38.08548, 326.6378, 41.5249> }
					triangle { <38.08548, 326.6378, 41.5249>, <37.9588, 326.4328, 39.5005>, <37.8113, 325.7381, 39.91> }
					triangle { <37.8113, 325.7381, 39.91>, <38.00561, 321.0202, 43.5857>, <38.08548, 326.6378, 41.5249> }
					triangle { <38.00561, 321.0202, 43.5857>, <37.8113, 325.7381, 39.91>, <38.04718, 320.7339, 43.1151> }
					triangle { <37.04132, 320.498, 43.04717>, <35.4224, 320.2791, 43.195>, <34.7886, 320.4392, 43.6461> }
					triangle { <37.04132, 320.498, 43.04717>, <37.9102, 320.4315, 42.6736>, <35.4224, 320.2791, 43.195> }
					triangle { <37.04132, 320.498, 43.04717>, <38.04718, 320.7339, 43.1151>, <37.9102, 320.4315, 42.6736> }
					triangle { <34.7886, 320.4392, 43.6461>, <38.04718, 320.7339, 43.1151>, <37.04132, 320.498, 43.04717> }
					triangle { <37.7595, 324.6265, 38.4086>, <37.1867, 322.9027, 39.03865>, <37.9102, 320.4315, 42.6736> }
					triangle { <37.8113, 325.7381, 39.91>, <37.9588, 326.4328, 39.5005>, <37.7595, 324.6265, 38.4086> }
					triangle { <37.7595, 324.6265, 38.4086>, <37.9102, 320.4315, 42.6736>, <37.8113, 325.7381, 39.91> }
					triangle { <38.04718, 320.7339, 43.1151>, <37.8113, 325.7381, 39.91>, <37.9102, 320.4315, 42.6736> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <34.7886, 320.4392, 43.6461>, <35.5315, 320.2366, 43.8409>, <37.114, 320.4697, 43.4778> }
					triangle { <35.5315, 320.2366, 43.8409>, <38.05568, 320.375, 43.5349>, <37.114, 320.4697, 43.4778> }
					triangle { <38.05568, 320.375, 43.5349>, <38.04718, 320.7339, 43.1151>, <37.114, 320.4697, 43.4778> }
					triangle { <37.114, 320.4697, 43.4778>, <38.04718, 320.7339, 43.1151>, <34.7886, 320.4392, 43.6461> }
					triangle { <38.05568, 320.375, 43.5349>, <38.6304, 322.2893, 47.5571>, <39.3983, 323.9894, 48.1113> }
					triangle { <39.3983, 323.9894, 48.1113>, <39.2846, 325.8652, 47.3209>, <38.98, 325.2837, 46.8298> }
					triangle { <38.98, 325.2837, 46.8298>, <38.05568, 320.375, 43.5349>, <39.3983, 323.9894, 48.1113> }
					triangle { <38.05568, 320.375, 43.5349>, <38.98, 325.2837, 46.8298>, <38.04718, 320.7339, 43.1151> }
					triangle { <37.01628, 320.8206, 43.07259>, <35.3849, 320.763, 43.2331>, <34.7886, 320.4392, 43.6461> }
					triangle { <37.01628, 320.8206, 43.07259>, <37.8601, 321.0767, 42.7244>, <35.3849, 320.763, 43.2331> }
					triangle { <37.01628, 320.8206, 43.07259>, <38.04718, 320.7339, 43.1151>, <37.8601, 321.0767, 42.7244> }
					triangle { <34.7886, 320.4392, 43.6461>, <38.04718, 320.7339, 43.1151>, <37.01628, 320.8206, 43.07259> }
					triangle { <38.7302, 326.3871, 45.3424>, <37.783, 325.3303, 44.04529>, <37.8601, 321.0767, 42.7244> }
					triangle { <38.98, 325.2837, 46.8298>, <39.2846, 325.8652, 47.3209>, <38.7302, 326.3871, 45.3424> }
					triangle { <38.7302, 326.3871, 45.3424>, <37.8601, 321.0767, 42.7244>, <38.98, 325.2837, 46.8298> }
					triangle { <38.04718, 320.7339, 43.1151>, <38.98, 325.2837, 46.8298>, <37.8601, 321.0767, 42.7244> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-6.8655, 285.9225, 52.3446>, <-6.9274, 288.2012, 52.9329>, 0.2999 }
			cylinder { <-6.9274, 288.2012, 52.9329>, <-6.9179, 290.4904, 53.4826>, 0.2999 }
			cylinder { <-6.9179, 290.4904, 53.4826>, <-6.8372, 292.7872, 53.9931>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <-6.8372, 292.7872, 53.9931>, <-8.516, 294.4326, 53.8634>, 0.2999 }
			cylinder { <-8.516, 294.4326, 53.8634>, <-10.2476, 296.0202, 53.7105>, 0.2999 }
			cylinder { <-10.2476, 296.0202, 53.7105>, <-12.03012, 297.5482, 53.5346>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-12.03012, 297.5482, 53.5346>, <-16.768, 302.6915, 54.5249>, 0.2999 }
				cylinder { <-16.768, 302.6915, 54.5249>, <-20.6125, 308.0862, 56.9743>, 0.2999 }
				cylinder { <-20.6125, 308.0862, 56.9743>, <-23.3333, 313.409, 60.7358>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-23.3333, 313.409, 60.7358>, <-23.1652, 314.0253, 61.2631>, <-23.8441, 315.3316, 62.1346> }
					triangle { <-23.1652, 314.0253, 61.2631>, <-23.884, 316.1111, 62.7416>, <-23.8441, 315.3316, 62.1346> }
					triangle { <-23.884, 316.1111, 62.7416>, <-24.4424, 316.1005, 62.6004>, <-23.8441, 315.3316, 62.1346> }
					triangle { <-23.8441, 315.3316, 62.1346>, <-24.4424, 316.1005, 62.6004>, <-23.3333, 313.409, 60.7358> }
					triangle { <-23.884, 316.1111, 62.7416>, <-22.8919, 313.8743, 66.7362>, <-24.01487, 313.3852, 68.3548> }
					triangle { <-24.01487, 313.3852, 68.3548>, <-26.00956, 312.674, 68.5462>, <-25.8147, 312.9366, 67.7562> }
					triangle { <-25.8147, 312.9366, 67.7562>, <-23.884, 316.1111, 62.7416>, <-24.01487, 313.3852, 68.3548> }
					triangle { <-23.884, 316.1111, 62.7416>, <-25.8147, 312.9366, 67.7562>, <-24.4424, 316.1005, 62.6004> }
					triangle { <-24.3722, 315.2472, 61.9423>, <-23.9572, 313.8987, 60.9747>, <-23.3333, 313.409, 60.7358> }
					triangle { <-24.3722, 315.2472, 61.9423>, <-24.9401, 315.9424, 62.357>, <-23.9572, 313.8987, 60.9747> }
					triangle { <-24.3722, 315.2472, 61.9423>, <-24.4424, 316.1005, 62.6004>, <-24.9401, 315.9424, 62.357> }
					triangle { <-23.3333, 313.409, 60.7358>, <-24.4424, 316.1005, 62.6004>, <-24.3722, 315.2472, 61.9423> }
					triangle { <-27.6232, 312.8087, 67.04063>, <-27.4684, 313.1432, 65.0695>, <-24.9401, 315.9424, 62.357> }
					triangle { <-25.8147, 312.9366, 67.7562>, <-26.00956, 312.674, 68.5462>, <-27.6232, 312.8087, 67.04063> }
					triangle { <-27.6232, 312.8087, 67.04063>, <-24.9401, 315.9424, 62.357>, <-25.8147, 312.9366, 67.7562> }
					triangle { <-24.4424, 316.1005, 62.6004>, <-25.8147, 312.9366, 67.7562>, <-24.9401, 315.9424, 62.357> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-23.3333, 313.409, 60.7358>, <-23.3627, 314.2286, 60.8521>, <-23.9758, 315.4671, 61.8606> }
					triangle { <-23.3627, 314.2286, 60.8521>, <-24.1474, 316.3823, 62.1935>, <-23.9758, 315.4671, 61.8606> }
					triangle { <-24.1474, 316.3823, 62.1935>, <-24.4424, 316.1005, 62.6004>, <-23.9758, 315.4671, 61.8606> }
					triangle { <-23.9758, 315.4671, 61.8606>, <-24.4424, 316.1005, 62.6004>, <-23.3333, 313.409, 60.7358> }
					triangle { <-24.1474, 316.3823, 62.1935>, <-19.7584, 317.4562, 63.4297>, <-18.8513, 317.6762, 65.232> }
					triangle { <-18.8513, 317.6762, 65.232>, <-19.01296, 316.5911, 67.05354>, <-19.6078, 316.3808, 66.4765> }
					triangle { <-19.6078, 316.3808, 66.4765>, <-24.1474, 316.3823, 62.1935>, <-18.8513, 317.6762, 65.232> }
					triangle { <-24.1474, 316.3823, 62.1935>, <-19.6078, 316.3808, 66.4765>, <-24.4424, 316.1005, 62.6004> }
					triangle { <-24.2405, 315.1116, 62.2163>, <-23.7597, 313.6954, 61.3857>, <-23.3333, 313.409, 60.7358> }
					triangle { <-24.2405, 315.1116, 62.2163>, <-24.6766, 315.6713, 62.905>, <-23.7597, 313.6954, 61.3857> }
					triangle { <-24.2405, 315.1116, 62.2163>, <-24.4424, 316.1005, 62.6004>, <-24.6766, 315.6713, 62.905> }
					triangle { <-23.3333, 313.409, 60.7358>, <-24.4424, 316.1005, 62.6004>, <-24.2405, 315.1116, 62.2163> }
					triangle { <-20.6595, 315.2471, 67.663>, <-22.05174, 314.3753, 66.5128>, <-24.6766, 315.6713, 62.905> }
					triangle { <-19.6078, 316.3808, 66.4765>, <-19.01296, 316.5911, 67.05354>, <-20.6595, 315.2471, 67.663> }
					triangle { <-20.6595, 315.2471, 67.663>, <-24.6766, 315.6713, 62.905>, <-19.6078, 316.3808, 66.4765> }
					triangle { <-24.4424, 316.1005, 62.6004>, <-19.6078, 316.3808, 66.4765>, <-24.6766, 315.6713, 62.905> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-23.3333, 313.409, 60.7358>, <-23.8327, 314.066, 60.8073>, <-24.2892, 315.3587, 61.8307> }
					triangle { <-23.8327, 314.066, 60.8073>, <-24.7741, 316.1654, 62.1338>, <-24.2892, 315.3587, 61.8307> }
					triangle { <-24.7741, 316.1654, 62.1338>, <-24.4424, 316.1005, 62.6004>, <-24.2892, 315.3587, 61.8307> }
					triangle { <-24.2892, 315.3587, 61.8307>, <-24.4424, 316.1005, 62.6004>, <-23.3333, 313.409, 60.7358> }
					triangle { <-24.7741, 316.1654, 62.1338>, <-23.05436, 319.1772, 58.9847>, <-21.7377, 320.7154, 59.128> }
					triangle { <-21.7377, 320.7154, 59.128>, <-19.9278, 320.9483, 60.2196>, <-20.3707, 320.2501, 60.4373> }
					triangle { <-20.3707, 320.2501, 60.4373>, <-24.7741, 316.1654, 62.1338>, <-21.7377, 320.7154, 59.128> }
					triangle { <-24.7741, 316.1654, 62.1338>, <-20.3707, 320.2501, 60.4373>, <-24.4424, 316.1005, 62.6004> }
					triangle { <-23.9271, 315.2201, 62.2462>, <-23.2897, 313.858, 61.4305>, <-23.3333, 313.409, 60.7358> }
					triangle { <-23.9271, 315.2201, 62.2462>, <-24.05002, 315.8882, 62.9648>, <-23.2897, 313.858, 61.4305> }
					triangle { <-23.9271, 315.2201, 62.2462>, <-24.4424, 316.1005, 62.6004>, <-24.05002, 315.8882, 62.9648> }
					triangle { <-23.3333, 313.409, 60.7358>, <-24.4424, 316.1005, 62.6004>, <-23.9271, 315.2201, 62.2462> }
					triangle { <-19.2637, 319.7679, 61.9673>, <-19.9166, 317.9756, 62.5858>, <-24.05002, 315.8882, 62.9648> }
					triangle { <-20.3707, 320.2501, 60.4373>, <-19.9278, 320.9483, 60.2196>, <-19.2637, 319.7679, 61.9673> }
					triangle { <-19.2637, 319.7679, 61.9673>, <-24.05002, 315.8882, 62.9648>, <-20.3707, 320.2501, 60.4373> }
					triangle { <-24.4424, 316.1005, 62.6004>, <-20.3707, 320.2501, 60.4373>, <-24.05002, 315.8882, 62.9648> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-23.3333, 313.409, 60.7358>, <-23.93, 313.7607, 61.1902>, <-24.354, 315.1551, 62.08601> }
					triangle { <-23.93, 313.7607, 61.1902>, <-24.9038, 315.7583, 62.6444>, <-24.354, 315.1551, 62.08601> }
					triangle { <-24.9038, 315.7583, 62.6444>, <-24.4424, 316.1005, 62.6004>, <-24.354, 315.1551, 62.08601> }
					triangle { <-24.354, 315.1551, 62.08601>, <-24.4424, 316.1005, 62.6004>, <-23.3333, 313.409, 60.7358> }
					triangle { <-24.9038, 315.7583, 62.6444>, <-28.2556, 316.6751, 59.5028>, <-28.7121, 318.331, 58.4214> }
					triangle { <-28.7121, 318.331, 58.4214>, <-27.4984, 319.7647, 57.4249>, <-27.05631, 319.2333, 57.9282> }
					triangle { <-27.05631, 319.2333, 57.9282>, <-24.9038, 315.7583, 62.6444>, <-28.7121, 318.331, 58.4214> }
					triangle { <-24.9038, 315.7583, 62.6444>, <-27.05631, 319.2333, 57.9282>, <-24.4424, 316.1005, 62.6004> }
					triangle { <-23.8623, 315.4236, 61.9909>, <-23.1924, 314.1634, 61.04764>, <-23.3333, 313.409, 60.7358> }
					triangle { <-23.8623, 315.4236, 61.9909>, <-23.9203, 316.2953, 62.4542>, <-23.1924, 314.1634, 61.04764> }
					triangle { <-23.8623, 315.4236, 61.9909>, <-24.4424, 316.1005, 62.6004>, <-23.9203, 316.2953, 62.4542> }
					triangle { <-23.3333, 313.409, 60.7358>, <-24.4424, 316.1005, 62.6004>, <-23.8623, 315.4236, 61.9909> }
					triangle { <-25.3518, 320.1658, 57.7717>, <-23.9938, 319.0021, 58.6788>, <-23.9203, 316.2953, 62.4542> }
					triangle { <-27.05631, 319.2333, 57.9282>, <-27.4984, 319.7647, 57.4249>, <-25.3518, 320.1658, 57.7717> }
					triangle { <-25.3518, 320.1658, 57.7717>, <-23.9203, 316.2953, 62.4542>, <-27.05631, 319.2333, 57.9282> }
					triangle { <-24.4424, 316.1005, 62.6004>, <-27.05631, 319.2333, 57.9282>, <-23.9203, 316.2953, 62.4542> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-23.3333, 313.409, 60.7358>, <-23.5112, 313.7351, 61.4762>, <-24.07486, 315.1381, 62.2766> }
					triangle { <-23.5112, 313.7351, 61.4762>, <-24.3454, 315.7242, 63.02573>, <-24.07486, 315.1381, 62.2766> }
					triangle { <-24.3454, 315.7242, 63.02573>, <-24.4424, 316.1005, 62.6004>, <-24.07486, 315.1381, 62.2766> }
					triangle { <-24.07486, 315.1381, 62.2766>, <-24.4424, 316.1005, 62.6004>, <-23.3333, 313.409, 60.7358> }
					triangle { <-24.3454, 315.7242, 63.02573>, <-28.1537, 313.3482, 64.3658>, <-30.1407, 313.7323, 64.2099> }
					triangle { <-30.1407, 313.7323, 64.2099>, <-31.3139, 314.5737, 62.6488>, <-30.4716, 314.6451, 62.5198> }
					triangle { <-30.4716, 314.6451, 62.5198>, <-24.3454, 315.7242, 63.02573>, <-30.1407, 313.7323, 64.2099> }
					triangle { <-24.3454, 315.7242, 63.02573>, <-30.4716, 314.6451, 62.5198>, <-24.4424, 316.1005, 62.6004> }
					triangle { <-24.1415, 315.4406, 61.8002>, <-23.6112, 314.1889, 60.7616>, <-23.3333, 313.409, 60.7358> }
					triangle { <-24.1415, 315.4406, 61.8002>, <-24.4787, 316.3293, 62.07291>, <-23.6112, 314.1889, 60.7616> }
					triangle { <-24.1415, 315.4406, 61.8002>, <-24.4424, 316.1005, 62.6004>, <-24.4787, 316.3293, 62.07291> }
					triangle { <-23.3333, 313.409, 60.7358>, <-24.4424, 316.1005, 62.6004>, <-24.1415, 315.4406, 61.8002> }
					triangle { <-30.5963, 315.7998, 60.9544>, <-28.7315, 315.9704, 60.2369>, <-24.4787, 316.3293, 62.07291> }
					triangle { <-30.4716, 314.6451, 62.5198>, <-31.3139, 314.5737, 62.6488>, <-30.5963, 315.7998, 60.9544> }
					triangle { <-30.5963, 315.7998, 60.9544>, <-24.4787, 316.3293, 62.07291>, <-30.4716, 314.6451, 62.5198> }
					triangle { <-24.4424, 316.1005, 62.6004>, <-30.4716, 314.6451, 62.5198>, <-24.4787, 316.3293, 62.07291> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-12.03012, 297.5482, 53.5346>, <-13.7877, 299.1109, 53.4282>, 0.2999 }
			cylinder { <-13.7877, 299.1109, 53.4282>, <-15.5184, 300.7065, 53.3917>, 0.2999 }
			cylinder { <-15.5184, 300.7065, 53.3917>, <-17.2201, 302.333, 53.4249>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-17.2201, 302.333, 53.4249>, <-21.9077, 307.3773, 51.8549>, 0.2999 }
				cylinder { <-21.9077, 307.3773, 51.8549>, <-25.8968, 312.2837, 48.709>, 0.2999 }
				cylinder { <-25.8968, 312.2837, 48.709>, <-28.9484, 316.7583, 44.176>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-28.9484, 316.7583, 44.176>, <-29.1486, 317.0117, 43.4131>, <-29.9178, 318.2506, 42.5185> }
					triangle { <-29.1486, 317.0117, 43.4131>, <-30.2551, 318.7423, 41.7297>, <-29.9178, 318.2506, 42.5185> }
					triangle { <-30.2551, 318.7423, 41.7297>, <-30.4367, 319.1144, 42.1303>, <-29.9178, 318.2506, 42.5185> }
					triangle { <-29.9178, 318.2506, 42.5185>, <-30.4367, 319.1144, 42.1303>, <-28.9484, 316.7583, 44.176> }
					triangle { <-30.2551, 318.7423, 41.7297>, <-26.1156, 319.8555, 39.8402>, <-25.1027, 321.6071, 39.6801> }
					triangle { <-25.1027, 321.6071, 39.6801>, <-24.8316, 323.2279, 41.02955>, <-25.4197, 322.6633, 41.2873> }
					triangle { <-25.4197, 322.6633, 41.2873>, <-30.2551, 318.7423, 41.7297>, <-25.1027, 321.6071, 39.6801> }
					triangle { <-30.2551, 318.7423, 41.7297>, <-25.4197, 322.6633, 41.2873>, <-30.4367, 319.1144, 42.1303> }
					triangle { <-30.05866, 318.5581, 42.9751>, <-29.3599, 317.4731, 44.09818>, <-28.9484, 316.7583, 44.176> }
					triangle { <-30.05866, 318.5581, 42.9751>, <-30.5368, 319.3574, 42.643>, <-29.3599, 317.4731, 44.09818> }
					triangle { <-30.05866, 318.5581, 42.9751>, <-30.4367, 319.1144, 42.1303>, <-30.5368, 319.3574, 42.643> }
					triangle { <-28.9484, 316.7583, 44.176>, <-30.4367, 319.1144, 42.1303>, <-30.05866, 318.5581, 42.9751> }
					triangle { <-26.06494, 323.7087, 42.8006>, <-27.336, 322.5209, 43.7979>, <-30.5368, 319.3574, 42.643> }
					triangle { <-25.4197, 322.6633, 41.2873>, <-24.8316, 323.2279, 41.02955>, <-26.06494, 323.7087, 42.8006> }
					triangle { <-26.06494, 323.7087, 42.8006>, <-30.5368, 319.3574, 42.643>, <-25.4197, 322.6633, 41.2873> }
					triangle { <-30.4367, 319.1144, 42.1303>, <-25.4197, 322.6633, 41.2873>, <-30.5368, 319.3574, 42.643> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.9484, 316.7583, 44.176>, <-29.5724, 316.9707, 43.6741>, <-30.2003, 318.2232, 42.6925> }
					triangle { <-29.5724, 316.9707, 43.6741>, <-30.8201, 318.6876, 42.07773>, <-30.2003, 318.2232, 42.6925> }
					triangle { <-30.8201, 318.6876, 42.07773>, <-30.4367, 319.1144, 42.1303>, <-30.2003, 318.2232, 42.6925> }
					triangle { <-30.2003, 318.2232, 42.6925>, <-30.4367, 319.1144, 42.1303>, <-28.9484, 316.7583, 44.176> }
					triangle { <-30.8201, 318.6876, 42.07773>, <-30.1469, 315.9828, 38.3126>, <-29.2005, 316.2964, 36.5446> }
					triangle { <-29.2005, 316.2964, 36.5446>, <-27.3875, 317.2927, 36.05304>, <-27.6384, 317.4185, 36.8607> }
					triangle { <-27.6384, 317.4185, 36.8607>, <-30.8201, 318.6876, 42.07773>, <-29.2005, 316.2964, 36.5446> }
					triangle { <-30.8201, 318.6876, 42.07773>, <-27.6384, 317.4185, 36.8607>, <-30.4367, 319.1144, 42.1303> }
					triangle { <-29.7761, 318.5855, 42.8011>, <-28.9361, 317.5141, 43.8371>, <-28.9484, 316.7583, 44.176> }
					triangle { <-29.7761, 318.5855, 42.8011>, <-29.9718, 319.4121, 42.295>, <-28.9361, 317.5141, 43.8371> }
					triangle { <-29.7761, 318.5855, 42.8011>, <-30.4367, 319.1144, 42.1303>, <-29.9718, 319.4121, 42.295> }
					triangle { <-28.9484, 316.7583, 44.176>, <-30.4367, 319.1144, 42.1303>, <-29.7761, 318.5855, 42.8011> }
					triangle { <-26.3021, 318.7719, 37.2871>, <-26.4709, 319.1225, 39.2543>, <-29.9718, 319.4121, 42.295> }
					triangle { <-27.6384, 317.4185, 36.8607>, <-27.3875, 317.2927, 36.05304>, <-26.3021, 318.7719, 37.2871> }
					triangle { <-26.3021, 318.7719, 37.2871>, <-29.9718, 319.4121, 42.295>, <-27.6384, 317.4185, 36.8607> }
					triangle { <-30.4367, 319.1144, 42.1303>, <-27.6384, 317.4185, 36.8607>, <-29.9718, 319.4121, 42.295> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.9484, 316.7583, 44.176>, <-29.5594, 317.3026, 44.04705>, <-30.1917, 318.4445, 42.9411> }
					triangle { <-29.5594, 317.3026, 44.04705>, <-30.8029, 319.1302, 42.5748>, <-30.1917, 318.4445, 42.9411> }
					triangle { <-30.8029, 319.1302, 42.5748>, <-30.4367, 319.1144, 42.1303>, <-30.1917, 318.4445, 42.9411> }
					triangle { <-30.1917, 318.4445, 42.9411>, <-30.4367, 319.1144, 42.1303>, <-28.9484, 316.7583, 44.176> }
					triangle { <-30.8029, 319.1302, 42.5748>, <-34.576, 316.4087, 42.02538>, <-35.4989, 315.6513, 40.3839> }
					triangle { <-35.4989, 315.6513, 40.3839>, <-34.7446, 314.8328, 38.5722>, <-34.1459, 315.2105, 39.05191> }
					triangle { <-34.1459, 315.2105, 39.05191>, <-30.8029, 319.1302, 42.5748>, <-35.4989, 315.6513, 40.3839> }
					triangle { <-30.8029, 319.1302, 42.5748>, <-34.1459, 315.2105, 39.05191>, <-30.4367, 319.1144, 42.1303> }
					triangle { <-29.7847, 318.3642, 42.5526>, <-28.9491, 317.1822, 43.4643>, <-28.9484, 316.7583, 44.176> }
					triangle { <-29.7847, 318.3642, 42.5526>, <-29.989, 318.9696, 41.7978>, <-28.9491, 317.1822, 43.4643> }
					triangle { <-29.7847, 318.3642, 42.5526>, <-30.4367, 319.1144, 42.1303>, <-29.989, 318.9696, 41.7978> }
					triangle { <-28.9484, 316.7583, 44.176>, <-30.4367, 319.1144, 42.1303>, <-29.7847, 318.3642, 42.5526> }
					triangle { <-32.7184, 315.1028, 37.7292>, <-31.04947, 315.713, 38.6584>, <-29.989, 318.9696, 41.7978> }
					triangle { <-34.1459, 315.2105, 39.05191>, <-34.7446, 314.8328, 38.5722>, <-32.7184, 315.1028, 37.7292> }
					triangle { <-32.7184, 315.1028, 37.7292>, <-29.989, 318.9696, 41.7978>, <-34.1459, 315.2105, 39.05191> }
					triangle { <-30.4367, 319.1144, 42.1303>, <-34.1459, 315.2105, 39.05191>, <-29.989, 318.9696, 41.7978> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.9484, 316.7583, 44.176>, <-29.1276, 317.5519, 44.01997>, <-29.9038, 318.6107, 42.923> }
					triangle { <-29.1276, 317.5519, 44.01997>, <-30.2271, 319.4625, 42.5387>, <-29.9038, 318.6107, 42.923> }
					triangle { <-30.2271, 319.4625, 42.5387>, <-30.4367, 319.1144, 42.1303>, <-29.9038, 318.6107, 42.923> }
					triangle { <-29.9038, 318.6107, 42.923>, <-30.4367, 319.1144, 42.1303>, <-28.9484, 316.7583, 44.176> }
					triangle { <-30.2271, 319.4625, 42.5387>, <-33.3234, 320.5486, 45.8822>, <-35.3526, 320.5573, 45.9279> }
					triangle { <-35.3526, 320.5573, 45.9279>, <-36.8043, 319.2247, 45.1291>, <-36.00991, 319.07, 44.8532> }
					triangle { <-36.00991, 319.07, 44.8532>, <-30.2271, 319.4625, 42.5387>, <-35.3526, 320.5573, 45.9279> }
					triangle { <-30.2271, 319.4625, 42.5387>, <-36.00991, 319.07, 44.8532>, <-30.4367, 319.1144, 42.1303> }
					triangle { <-30.07269, 318.1981, 42.5706>, <-29.3809, 316.933, 43.4913>, <-28.9484, 316.7583, 44.176> }
					triangle { <-30.07269, 318.1981, 42.5706>, <-30.5648, 318.6373, 41.834>, <-29.3809, 316.933, 43.4913> }
					triangle { <-30.07269, 318.1981, 42.5706>, <-30.4367, 319.1144, 42.1303>, <-30.5648, 318.6373, 41.834> }
					triangle { <-28.9484, 316.7583, 44.176>, <-30.4367, 319.1144, 42.1303>, <-30.07269, 318.1981, 42.5706> }
					triangle { <-36.5065, 317.7377, 43.52>, <-34.7869, 316.9725, 42.8281>, <-30.5648, 318.6373, 41.834> }
					triangle { <-36.00991, 319.07, 44.8532>, <-36.8043, 319.2247, 45.1291>, <-36.5065, 317.7377, 43.52> }
					triangle { <-36.5065, 317.7377, 43.52>, <-30.5648, 318.6373, 41.834>, <-36.00991, 319.07, 44.8532> }
					triangle { <-30.4367, 319.1144, 42.1303>, <-36.00991, 319.07, 44.8532>, <-30.5648, 318.6373, 41.834> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-28.9484, 316.7583, 44.176>, <-28.8699, 317.3694, 43.6223>, <-29.732, 318.489, 42.6579> }
					triangle { <-28.8699, 317.3694, 43.6223>, <-29.8835, 319.2192, 42.00855>, <-29.732, 318.489, 42.6579> }
					triangle { <-29.8835, 319.2192, 42.00855>, <-30.4367, 319.1144, 42.1303>, <-29.732, 318.489, 42.6579> }
					triangle { <-29.732, 318.489, 42.6579>, <-30.4367, 319.1144, 42.1303>, <-28.9484, 316.7583, 44.176> }
					triangle { <-29.8835, 319.2192, 42.00855>, <-28.01568, 322.711, 44.5113>, <-28.8303, 324.2937, 45.4864> }
					triangle { <-28.8303, 324.2937, 45.4864>, <-30.5852, 324.4915, 46.6708>, <-30.5353, 323.7456, 46.2556> }
					triangle { <-30.5353, 323.7456, 46.2556>, <-29.8835, 319.2192, 42.00855>, <-28.8303, 324.2937, 45.4864> }
					triangle { <-29.8835, 319.2192, 42.00855>, <-30.5353, 323.7456, 46.2556>, <-30.4367, 319.1144, 42.1303> }
					triangle { <-30.2445, 318.3197, 42.8357>, <-29.6386, 317.1154, 43.889>, <-28.9484, 316.7583, 44.176> }
					triangle { <-30.2445, 318.3197, 42.8357>, <-30.9085, 318.8806, 42.3642>, <-29.6386, 317.1154, 43.889> }
					triangle { <-30.2445, 318.3197, 42.8357>, <-30.4367, 319.1144, 42.1303>, <-30.9085, 318.8806, 42.3642> }
					triangle { <-28.9484, 316.7583, 44.176>, <-30.4367, 319.1144, 42.1303>, <-30.2445, 318.3197, 42.8357> }
					triangle { <-32.3324, 323.1367, 46.7016>, <-32.4573, 321.2435, 46.05255>, <-30.9085, 318.8806, 42.3642> }
					triangle { <-30.5353, 323.7456, 46.2556>, <-30.5852, 324.4915, 46.6708>, <-32.3324, 323.1367, 46.7016> }
					triangle { <-32.3324, 323.1367, 46.7016>, <-30.9085, 318.8806, 42.3642>, <-30.5353, 323.7456, 46.2556> }
					triangle { <-30.4367, 319.1144, 42.1303>, <-30.5353, 323.7456, 46.2556>, <-30.9085, 318.8806, 42.3642> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-17.2201, 302.333, 53.4249>, <-18.9108, 303.9706, 53.378>, 0.2999 }
			cylinder { <-18.9108, 303.9706, 53.378>, <-20.5887, 305.6172, 53.2509>, 0.2999 }
			cylinder { <-20.5887, 305.6172, 53.2509>, <-22.2515, 307.2709, 53.04377>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-22.2515, 307.2709, 53.04377>, <-28.1537, 311.1338, 53.3965>, 0.2999 }
				cylinder { <-28.1537, 311.1338, 53.3965>, <-34.6159, 313.6671, 54.7023>, 0.2999 }
				cylinder { <-34.6159, 313.6671, 54.7023>, <-41.2508, 314.7188, 56.8829>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-41.2508, 314.7188, 56.8829>, <-41.8467, 314.5748, 57.4401>, <-43.4721, 314.9119, 57.8538> }
					triangle { <-41.8467, 314.5748, 57.4401>, <-44.3143, 314.8864, 58.3715>, <-43.4721, 314.9119, 57.8538> }
					triangle { <-44.3143, 314.8864, 58.3715>, <-44.4985, 315.2336, 57.9502>, <-43.4721, 314.9119, 57.8538> }
					triangle { <-43.4721, 314.9119, 57.8538>, <-44.4985, 315.2336, 57.9502>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-44.3143, 314.8864, 58.3715>, <-45.3523, 310.3681, 57.6991>, <-46.7723, 309.4327, 56.5906> }
					triangle { <-46.7723, 309.4327, 56.5906>, <-47.5509, 309.817, 54.6497>, <-47.0512, 310.4436, 54.9477> }
					triangle { <-47.0512, 310.4436, 54.9477>, <-44.3143, 314.8864, 58.3715>, <-46.7723, 309.4327, 56.5906> }
					triangle { <-44.3143, 314.8864, 58.3715>, <-47.0512, 310.4436, 54.9477>, <-44.4985, 315.2336, 57.9502> }
					triangle { <-43.5673, 315.245, 57.4034>, <-41.9896, 315.0744, 56.7644>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-43.5673, 315.245, 57.4034>, <-44.5047, 315.5526, 57.4706>, <-41.9896, 315.0744, 56.7644> }
					triangle { <-43.5673, 315.245, 57.4034>, <-44.4985, 315.2336, 57.9502>, <-44.5047, 315.5526, 57.4706> }
					triangle { <-41.2508, 314.7188, 56.8829>, <-44.4985, 315.2336, 57.9502>, <-43.5673, 315.245, 57.4034> }
					triangle { <-47.4231, 311.709, 53.5125>, <-46.1777, 313.2551, 53.7951>, <-44.5047, 315.5526, 57.4706> }
					triangle { <-47.0512, 310.4436, 54.9477>, <-47.5509, 309.817, 54.6497>, <-47.4231, 311.709, 53.5125> }
					triangle { <-47.4231, 311.709, 53.5125>, <-44.5047, 315.5526, 57.4706>, <-47.0512, 310.4436, 54.9477> }
					triangle { <-44.4985, 315.2336, 57.9502>, <-47.0512, 310.4436, 54.9477>, <-44.5047, 315.5526, 57.4706> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-41.2508, 314.7188, 56.8829>, <-41.7747, 315.0685, 57.421>, <-43.4241, 315.2411, 57.8411> }
					triangle { <-41.7747, 315.0685, 57.421>, <-44.2183, 315.5447, 58.346>, <-43.4241, 315.2411, 57.8411> }
					triangle { <-44.2183, 315.5447, 58.346>, <-44.4985, 315.2336, 57.9502>, <-43.4241, 315.2411, 57.8411> }
					triangle { <-43.4241, 315.2411, 57.8411>, <-44.4985, 315.2336, 57.9502>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-44.2183, 315.5447, 58.346>, <-43.3754, 313.233, 62.3323>, <-44.253, 311.6217, 63.2003> }
					triangle { <-44.253, 311.6217, 63.2003>, <-45.0065, 309.8021, 62.3989>, <-44.8081, 310.3819, 61.8026> }
					triangle { <-44.8081, 310.3819, 61.8026>, <-44.2183, 315.5447, 58.346>, <-44.253, 311.6217, 63.2003> }
					triangle { <-44.2183, 315.5447, 58.346>, <-44.8081, 310.3819, 61.8026>, <-44.4985, 315.2336, 57.9502> }
					triangle { <-43.6153, 314.9159, 57.4161>, <-42.06161, 314.5807, 56.7835>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-43.6153, 314.9159, 57.4161>, <-44.6007, 314.8943, 57.496>, <-42.06161, 314.5807, 56.7835> }
					triangle { <-43.6153, 314.9159, 57.4161>, <-44.4985, 315.2336, 57.9502>, <-44.6007, 314.8943, 57.496> }
					triangle { <-41.2508, 314.7188, 56.8829>, <-44.4985, 315.2336, 57.9502>, <-43.6153, 314.9159, 57.4161> }
					triangle { <-45.5597, 309.3993, 60.2963>, <-45.03276, 310.4143, 58.6491>, <-44.6007, 314.8943, 57.496> }
					triangle { <-44.8081, 310.3819, 61.8026>, <-45.0065, 309.8021, 62.3989>, <-45.5597, 309.3993, 60.2963> }
					triangle { <-45.5597, 309.3993, 60.2963>, <-44.6007, 314.8943, 57.496>, <-44.8081, 310.3819, 61.8026> }
					triangle { <-44.4985, 315.2336, 57.9502>, <-44.8081, 310.3819, 61.8026>, <-44.6007, 314.8943, 57.496> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-41.2508, 314.7188, 56.8829>, <-41.8996, 315.2275, 56.9643>, <-43.5074, 315.347, 57.5367> }
					triangle { <-41.8996, 315.2275, 56.9643>, <-44.3848, 315.7567, 57.7372>, <-43.5074, 315.347, 57.5367> }
					triangle { <-44.3848, 315.7567, 57.7372>, <-44.4985, 315.2336, 57.9502>, <-43.5074, 315.347, 57.5367> }
					triangle { <-43.5074, 315.347, 57.5367>, <-44.4985, 315.2336, 57.9502>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-44.3848, 315.7567, 57.7372>, <-42.9401, 318.8441, 60.9505>, <-43.1698, 318.9428, 62.9648> }
					triangle { <-43.1698, 318.9428, 62.9648>, <-43.1082, 317.4556, 64.4833>, <-43.1171, 317.1347, 63.6908> }
					triangle { <-43.1171, 317.1347, 63.6908>, <-44.3848, 315.7567, 57.7372>, <-43.1698, 318.9428, 62.9648> }
					triangle { <-44.3848, 315.7567, 57.7372>, <-43.1171, 317.1347, 63.6908>, <-44.4985, 315.2336, 57.9502> }
					triangle { <-43.5321, 314.8099, 57.7205>, <-41.9367, 314.4217, 57.2401>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-43.5321, 314.8099, 57.7205>, <-44.4342, 314.6823, 58.1048>, <-41.9367, 314.4217, 57.2401> }
					triangle { <-43.5321, 314.8099, 57.7205>, <-44.4985, 315.2336, 57.9502>, <-44.4342, 314.6823, 58.1048> }
					triangle { <-41.2508, 314.7188, 56.8829>, <-44.4985, 315.2336, 57.9502>, <-43.5321, 314.8099, 57.7205> }
					triangle { <-43.3388, 315.2722, 64.2211>, <-43.1544, 314.1887, 62.5438>, <-44.4342, 314.6823, 58.1048> }
					triangle { <-43.1171, 317.1347, 63.6908>, <-43.1082, 317.4556, 64.4833>, <-43.3388, 315.2722, 64.2211> }
					triangle { <-43.3388, 315.2722, 64.2211>, <-44.4342, 314.6823, 58.1048>, <-43.1171, 317.1347, 63.6908> }
					triangle { <-44.4985, 315.2336, 57.9502>, <-43.1171, 317.1347, 63.6908>, <-44.4342, 314.6823, 58.1048> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-41.2508, 314.7188, 56.8829>, <-42.04998, 314.8334, 56.697>, <-43.6076, 315.0844, 57.3584> }
					triangle { <-42.04998, 314.8334, 56.697>, <-44.5852, 315.2313, 57.3807>, <-43.6076, 315.0844, 57.3584> }
					triangle { <-44.5852, 315.2313, 57.3807>, <-44.4985, 315.2336, 57.9502>, <-43.6076, 315.0844, 57.3584> }
					triangle { <-43.6076, 315.0844, 57.3584>, <-44.4985, 315.2336, 57.9502>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-44.5852, 315.2313, 57.3807>, <-44.6438, 319.4993, 55.4505>, <-45.00967, 321.3467, 56.2074> }
					triangle { <-45.00967, 321.3467, 56.2074>, <-44.4617, 322.2721, 58.04176>, <-44.2993, 321.4329, 58.02047> }
					triangle { <-44.2993, 321.4329, 58.02047>, <-44.5852, 315.2313, 57.3807>, <-45.00967, 321.3467, 56.2074> }
					triangle { <-44.5852, 315.2313, 57.3807>, <-44.2993, 321.4329, 58.02047>, <-44.4985, 315.2336, 57.9502> }
					triangle { <-43.4319, 315.0726, 57.8987>, <-41.7864, 314.8158, 57.5075>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-43.4319, 315.0726, 57.8987>, <-44.2338, 315.2078, 58.4613>, <-41.7864, 314.8158, 57.5075> }
					triangle { <-43.4319, 315.0726, 57.8987>, <-44.4985, 315.2336, 57.9502>, <-44.2338, 315.2078, 58.4613> }
					triangle { <-41.2508, 314.7188, 56.8829>, <-44.4985, 315.2336, 57.9502>, <-43.4319, 315.0726, 57.8987> }
					triangle { <-43.8089, 321.2664, 59.8995>, <-43.121, 319.3973, 60.1332>, <-44.2338, 315.2078, 58.4613> }
					triangle { <-44.2993, 321.4329, 58.02047>, <-44.4617, 322.2721, 58.04176>, <-43.8089, 321.2664, 59.8995> }
					triangle { <-43.8089, 321.2664, 59.8995>, <-44.2338, 315.2078, 58.4613>, <-44.2993, 321.4329, 58.02047> }
					triangle { <-44.4985, 315.2336, 57.9502>, <-44.2993, 321.4329, 58.02047>, <-44.2338, 315.2078, 58.4613> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-41.2508, 314.7188, 56.8829>, <-42.0168, 314.4239, 56.9954>, <-43.5855, 314.8114, 57.5574> }
					triangle { <-42.0168, 314.4239, 56.9954>, <-44.541, 314.6853, 57.7786>, <-43.5855, 314.8114, 57.5574> }
					triangle { <-44.541, 314.6853, 57.7786>, <-44.4985, 315.2336, 57.9502>, <-43.5855, 314.8114, 57.5574> }
					triangle { <-43.5855, 314.8114, 57.5574>, <-44.4985, 315.2336, 57.9502>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-44.541, 314.6853, 57.7786>, <-46.1572, 314.1817, 53.4106>, <-47.2697, 315.3805, 52.2085> }
					triangle { <-47.2697, 315.3805, 52.2085>, <-47.2489, 317.48, 51.8725>, <-46.7674, 317.2352, 52.5353> }
					triangle { <-46.7674, 317.2352, 52.5353>, <-44.541, 314.6853, 57.7786>, <-47.2697, 315.3805, 52.2085> }
					triangle { <-44.541, 314.6853, 57.7786>, <-46.7674, 317.2352, 52.5353>, <-44.4985, 315.2336, 57.9502> }
					triangle { <-43.454, 315.3456, 57.6998>, <-41.8195, 315.2253, 57.209>, <-41.2508, 314.7188, 56.8829> }
					triangle { <-43.454, 315.3456, 57.6998>, <-44.278, 315.7537, 58.06343>, <-41.8195, 315.2253, 57.209> }
					triangle { <-43.454, 315.3456, 57.6998>, <-44.4985, 315.2336, 57.9502>, <-44.278, 315.7537, 58.06343> }
					triangle { <-41.2508, 314.7188, 56.8829>, <-44.4985, 315.2336, 57.9502>, <-43.454, 315.3456, 57.6998> }
					triangle { <-46.3712, 319.031, 53.1814>, <-45.01774, 318.8116, 54.6446>, <-44.278, 315.7537, 58.06343> }
					triangle { <-46.7674, 317.2352, 52.5353>, <-47.2489, 317.48, 51.8725>, <-46.3712, 319.031, 53.1814> }
					triangle { <-46.3712, 319.031, 53.1814>, <-44.278, 315.7537, 58.06343>, <-46.7674, 317.2352, 52.5353> }
					triangle { <-44.4985, 315.2336, 57.9502>, <-46.7674, 317.2352, 52.5353>, <-44.278, 315.7537, 58.06343> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-22.2515, 307.2709, 53.04377>, <-23.9625, 308.8802, 52.8855>, 0.2999 }
			cylinder { <-23.9625, 308.8802, 52.8855>, <-25.7196, 310.4432, 52.7762>, 0.2999 }
			cylinder { <-25.7196, 310.4432, 52.7762>, <-27.5208, 311.9581, 52.7161>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-27.5208, 311.9581, 52.7161>, <-31.6731, 317.6709, 52.7795>, 0.2999 }
				cylinder { <-31.6731, 317.6709, 52.7795>, <-34.3255, 324.2097, 53.08279>, 0.2999 }
				cylinder { <-34.3255, 324.2097, 53.08279>, <-35.3187, 331.1826, 53.6076>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-35.3187, 331.1826, 53.6076>, <-35.1243, 331.9872, 53.6397>, <-35.7409, 333.554, 53.9424> }
					triangle { <-35.1243, 331.9872, 53.6397>, <-35.7459, 334.538, 54.04019>, <-35.7409, 333.554, 53.9424> }
					triangle { <-35.7459, 334.538, 54.04019>, <-36.3013, 334.4498, 54.1655>, <-35.7409, 333.554, 53.9424> }
					triangle { <-35.7409, 333.554, 53.9424>, <-36.3013, 334.4498, 54.1655>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-35.7459, 334.538, 54.04019>, <-32.9718, 334.8298, 57.8037>, <-33.3332, 335.2913, 59.7469> }
					triangle { <-33.3332, 335.2913, 59.7469>, <-34.9272, 334.788, 61.0611>, <-35.07861, 334.5811, 60.2453> }
					triangle { <-35.07861, 334.5811, 60.2453>, <-35.7459, 334.538, 54.04019>, <-33.3332, 335.2913, 59.7469> }
					triangle { <-35.7459, 334.538, 54.04019>, <-35.07861, 334.5811, 60.2453>, <-36.3013, 334.4498, 54.1655> }
					triangle { <-36.2694, 333.3763, 54.05251>, <-35.917, 331.7206, 53.8049>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-36.2694, 333.3763, 54.05251>, <-36.8028, 334.1826, 54.2604>, <-35.917, 331.7206, 53.8049> }
					triangle { <-36.2694, 333.3763, 54.05251>, <-36.3013, 334.4498, 54.1655>, <-36.8028, 334.1826, 54.2604> }
					triangle { <-35.3187, 331.1826, 53.6076>, <-36.3013, 334.4498, 54.1655>, <-36.2694, 333.3763, 54.05251> }
					triangle { <-36.9442, 334.0769, 60.4993>, <-37.5515, 333.2897, 58.7579>, <-36.8028, 334.1826, 54.2604> }
					triangle { <-35.07861, 334.5811, 60.2453>, <-34.9272, 334.788, 61.0611>, <-36.9442, 334.0769, 60.4993> }
					triangle { <-36.9442, 334.0769, 60.4993>, <-36.8028, 334.1826, 54.2604>, <-35.07861, 334.5811, 60.2453> }
					triangle { <-36.3013, 334.4498, 54.1655>, <-35.07861, 334.5811, 60.2453>, <-36.8028, 334.1826, 54.2604> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-35.3187, 331.1826, 53.6076>, <-35.4908, 331.9342, 53.3048>, <-35.9853, 333.5187, 53.7191> }
					triangle { <-35.4908, 331.9342, 53.3048>, <-36.2346, 334.4673, 53.5935>, <-35.9853, 333.5187, 53.7191> }
					triangle { <-36.2346, 334.4673, 53.5935>, <-36.3013, 334.4498, 54.1655>, <-35.9853, 333.5187, 53.7191> }
					triangle { <-35.9853, 333.5187, 53.7191>, <-36.3013, 334.4498, 54.1655>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-36.2346, 334.4673, 53.5935>, <-32.05034, 336.061, 52.2164>, <-30.6568, 337.2277, 53.1201> }
					triangle { <-30.6568, 337.2277, 53.1201>, <-29.9373, 337.303, 55.1197>, <-30.6297, 336.8105, 55.02398> }
					triangle { <-30.6297, 336.8105, 55.02398>, <-36.2346, 334.4673, 53.5935>, <-30.6568, 337.2277, 53.1201> }
					triangle { <-36.2346, 334.4673, 53.5935>, <-30.6297, 336.8105, 55.02398>, <-36.3013, 334.4498, 54.1655> }
					triangle { <-36.02506, 333.4117, 54.2758>, <-35.5504, 331.7737, 54.1398>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-36.02506, 333.4117, 54.2758>, <-36.3141, 334.2533, 54.707>, <-35.5504, 331.7737, 54.1398> }
					triangle { <-36.02506, 333.4117, 54.2758>, <-36.3013, 334.4498, 54.1655>, <-36.3141, 334.2533, 54.707> }
					triangle { <-35.3187, 331.1826, 53.6076>, <-36.3013, 334.4498, 54.1655>, <-36.02506, 333.4117, 54.2758> }
					triangle { <-30.9282, 336.4965, 56.9243>, <-32.3945, 335.1336, 57.04121>, <-36.3141, 334.2533, 54.707> }
					triangle { <-30.6297, 336.8105, 55.02398>, <-29.9373, 337.303, 55.1197>, <-30.9282, 336.4965, 56.9243> }
					triangle { <-30.9282, 336.4965, 56.9243>, <-36.3141, 334.2533, 54.707>, <-30.6297, 336.8105, 55.02398> }
					triangle { <-36.3013, 334.4498, 54.1655>, <-30.6297, 336.8105, 55.02398>, <-36.3141, 334.2533, 54.707> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-35.3187, 331.1826, 53.6076>, <-35.8983, 331.771, 53.5429>, <-36.2569, 333.4099, 53.8778> }
					triangle { <-35.8983, 331.771, 53.5429>, <-36.7779, 334.2497, 53.9111>, <-36.2569, 333.4099, 53.8778> }
					triangle { <-36.7779, 334.2497, 53.9111>, <-36.3013, 334.4498, 54.1655>, <-36.2569, 333.4099, 53.8778> }
					triangle { <-36.2569, 333.4099, 53.8778>, <-36.3013, 334.4498, 54.1655>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-36.7779, 334.2497, 53.9111>, <-36.9638, 335.0806, 49.3046>, <-36.06077, 336.4569, 48.1171> }
					triangle { <-36.06077, 336.4569, 48.1171>, <-34.08926, 337.2532, 48.09943>, <-34.2614, 336.7825, 48.7921> }
					triangle { <-34.2614, 336.7825, 48.7921>, <-36.7779, 334.2497, 53.9111>, <-36.06077, 336.4569, 48.1171> }
					triangle { <-36.7779, 334.2497, 53.9111>, <-34.2614, 336.7825, 48.7921>, <-36.3013, 334.4498, 54.1655> }
					triangle { <-35.7534, 333.5205, 54.117>, <-35.143, 331.9369, 53.9016>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-35.7534, 333.5205, 54.117>, <-35.7708, 334.4709, 54.3894>, <-35.143, 331.9369, 53.9016> }
					triangle { <-35.7534, 333.5205, 54.117>, <-36.3013, 334.4498, 54.1655>, <-35.7708, 334.4709, 54.3894> }
					triangle { <-35.3187, 331.1826, 53.6076>, <-36.3013, 334.4498, 54.1655>, <-35.7534, 333.5205, 54.117> }
					triangle { <-32.62, 337.2125, 49.7513>, <-32.6, 336.0389, 51.3772>, <-35.7708, 334.4709, 54.3894> }
					triangle { <-34.2614, 336.7825, 48.7921>, <-34.08926, 337.2532, 48.09943>, <-32.62, 337.2125, 49.7513> }
					triangle { <-32.62, 337.2125, 49.7513>, <-35.7708, 334.4709, 54.3894>, <-34.2614, 336.7825, 48.7921> }
					triangle { <-36.3013, 334.4498, 54.1655>, <-34.2614, 336.7825, 48.7921>, <-35.7708, 334.4709, 54.3894> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-35.3187, 331.1826, 53.6076>, <-35.7873, 331.7216, 54.02733>, <-36.183, 333.377, 54.2007> }
					triangle { <-35.7873, 331.7216, 54.02733>, <-36.6299, 334.1839, 54.5569>, <-36.183, 333.377, 54.2007> }
					triangle { <-36.6299, 334.1839, 54.5569>, <-36.3013, 334.4498, 54.1655>, <-36.183, 333.377, 54.2007> }
					triangle { <-36.183, 333.377, 54.2007>, <-36.3013, 334.4498, 54.1655>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-36.6299, 334.1839, 54.5569>, <-40.9679, 333.2344, 53.06517>, <-42.1274, 334.037, 51.6052> }
					triangle { <-42.1274, 334.037, 51.6052>, <-41.6838, 334.7069, 49.6365>, <-40.9886, 334.5355, 50.1039> }
					triangle { <-40.9886, 334.5355, 50.1039>, <-36.6299, 334.1839, 54.5569>, <-42.1274, 334.037, 51.6052> }
					triangle { <-36.6299, 334.1839, 54.5569>, <-40.9886, 334.5355, 50.1039>, <-36.3013, 334.4498, 54.1655> }
					triangle { <-35.8274, 333.5534, 53.7941>, <-35.2539, 331.9862, 53.4173>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-35.8274, 333.5534, 53.7941>, <-35.9187, 334.5367, 53.7436>, <-35.2539, 331.9862, 53.4173> }
					triangle { <-35.8274, 333.5534, 53.7941>, <-36.3013, 334.4498, 54.1655>, <-35.9187, 334.5367, 53.7436> }
					triangle { <-35.3187, 331.1826, 53.6076>, <-36.3013, 334.4498, 54.1655>, <-35.8274, 333.5534, 53.7941> }
					triangle { <-39.6974, 335.2422, 48.8263>, <-37.886, 334.763, 49.5406>, <-35.9187, 334.5367, 53.7436> }
					triangle { <-40.9886, 334.5355, 50.1039>, <-41.6838, 334.7069, 49.6365>, <-39.6974, 335.2422, 48.8263> }
					triangle { <-39.6974, 335.2422, 48.8263>, <-35.9187, 334.5367, 53.7436>, <-40.9886, 334.5355, 50.1039> }
					triangle { <-36.3013, 334.4498, 54.1655>, <-40.9886, 334.5355, 50.1039>, <-35.9187, 334.5367, 53.7436> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-35.3187, 331.1826, 53.6076>, <-35.3018, 331.8573, 54.08805>, <-35.8593, 333.4674, 54.2412> }
					triangle { <-35.3018, 331.8573, 54.08805>, <-35.9825, 334.3648, 54.6379>, <-35.8593, 333.4674, 54.2412> }
					triangle { <-35.9825, 334.3648, 54.6379>, <-36.3013, 334.4498, 54.1655>, <-35.8593, 333.4674, 54.2412> }
					triangle { <-35.8593, 333.4674, 54.2412>, <-36.3013, 334.4498, 54.1655>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-35.9825, 334.3648, 54.6379>, <-38.4634, 333.0771, 58.3971>, <-40.4162, 333.3057, 58.9013> }
					triangle { <-40.4162, 333.3057, 58.9013>, <-42.2096, 333.1603, 57.7682>, <-41.5013, 333.1544, 57.2892> }
					triangle { <-41.5013, 333.1544, 57.2892>, <-35.9825, 334.3648, 54.6379>, <-40.4162, 333.3057, 58.9013> }
					triangle { <-35.9825, 334.3648, 54.6379>, <-41.5013, 333.1544, 57.2892>, <-36.3013, 334.4498, 54.1655> }
					triangle { <-36.1511, 333.4629, 53.7536>, <-35.7395, 331.8506, 53.3566>, <-35.3187, 331.1826, 53.6076> }
					triangle { <-36.1511, 333.4629, 53.7536>, <-36.5661, 334.3558, 53.6626>, <-35.7395, 331.8506, 53.3566> }
					triangle { <-36.1511, 333.4629, 53.7536>, <-36.3013, 334.4498, 54.1655>, <-36.5661, 334.3558, 53.6626> }
					triangle { <-35.3187, 331.1826, 53.6076>, <-36.3013, 334.4498, 54.1655>, <-36.1511, 333.4629, 53.7536> }
					triangle { <-42.4102, 333.2751, 55.5692>, <-40.9924, 333.0382, 54.171>, <-36.5661, 334.3558, 53.6626> }
					triangle { <-41.5013, 333.1544, 57.2892>, <-42.2096, 333.1603, 57.7682>, <-42.4102, 333.2751, 55.5692> }
					triangle { <-42.4102, 333.2751, 55.5692>, <-36.5661, 334.3558, 53.6626>, <-41.5013, 333.1544, 57.2892> }
					triangle { <-36.3013, 334.4498, 54.1655>, <-41.5013, 333.1544, 57.2892>, <-36.5661, 334.3558, 53.6626> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <-27.5208, 311.9581, 52.7161>, <-29.2687, 313.5344, 52.6634>, 0.2999 }
			cylinder { <-29.2687, 313.5344, 52.6634>, <-30.9611, 315.1703, 52.6183>, 0.2999 }
			cylinder { <-30.9611, 315.1703, 52.6183>, <-32.5961, 316.8638, 52.5806>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-32.5961, 316.8638, 52.5806>, <-38.1273, 321.0161, 51.1501>, 0.2999 }
				cylinder { <-38.1273, 321.0161, 51.1501>, <-43.9532, 323.9915, 48.4876>, 0.2999 }
				cylinder { <-43.9532, 323.9915, 48.4876>, <-49.7246, 325.6116, 44.7528>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-49.7246, 325.6116, 44.7528>, <-50.3392, 325.2961, 44.3608>, <-51.7126, 325.6453, 43.5349> }
					triangle { <-50.3392, 325.2961, 44.3608>, <-52.5073, 325.4945, 43.04029>, <-51.7126, 325.6453, 43.5349> }
					triangle { <-52.5073, 325.4945, 43.04029>, <-52.5348, 326.0461, 43.0496>, <-51.7126, 325.6453, 43.5349> }
					triangle { <-51.7126, 325.6453, 43.5349>, <-52.5348, 326.0461, 43.0496>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-52.5073, 325.4945, 43.04029>, <-50.6185, 323.8273, 39.3218>, <-50.3841, 324.542, 37.527> }
					triangle { <-50.3841, 324.542, 37.527>, <-49.8986, 326.4016, 36.8468>, <-50.0668, 326.3796, 37.6488> }
					triangle { <-50.0668, 326.3796, 37.6488>, <-52.5073, 325.4945, 43.04029>, <-50.3841, 324.542, 37.527> }
					triangle { <-52.5073, 325.4945, 43.04029>, <-50.0668, 326.3796, 37.6488>, <-52.5348, 326.0461, 43.0496> }
					triangle { <-51.6631, 326.185, 43.5908>, <-50.2649, 326.1057, 44.4448>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-51.6631, 326.185, 43.5908>, <-52.4082, 326.5739, 43.1522>, <-50.2649, 326.1057, 44.4448> }
					triangle { <-51.6631, 326.185, 43.5908>, <-52.5348, 326.0461, 43.0496>, <-52.4082, 326.5739, 43.1522> }
					triangle { <-49.7246, 325.6116, 44.7528>, <-52.5348, 326.0461, 43.0496>, <-51.6631, 326.185, 43.5908> }
					triangle { <-50.04572, 328.2301, 37.9094>, <-50.1892, 328.5049, 39.8069>, <-52.4082, 326.5739, 43.1522> }
					triangle { <-50.0668, 326.3796, 37.6488>, <-49.8986, 326.4016, 36.8468>, <-50.04572, 328.2301, 37.9094> }
					triangle { <-50.04572, 328.2301, 37.9094>, <-52.4082, 326.5739, 43.1522>, <-50.0668, 326.3796, 37.6488> }
					triangle { <-52.5348, 326.0461, 43.0496>, <-50.0668, 326.3796, 37.6488>, <-52.4082, 326.5739, 43.1522> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-49.7246, 325.6116, 44.7528>, <-50.5164, 325.5582, 44.7201>, <-51.8308, 325.82, 43.7744> }
					triangle { <-50.5164, 325.5582, 44.7201>, <-52.7436, 325.844, 43.5193>, <-51.8308, 325.82, 43.7744> }
					triangle { <-52.7436, 325.844, 43.5193>, <-52.5348, 326.0461, 43.0496>, <-51.8308, 325.82, 43.7744> }
					triangle { <-51.8308, 325.82, 43.7744>, <-52.5348, 326.0461, 43.0496>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-52.7436, 325.844, 43.5193>, <-53.4802, 321.4143, 43.4278>, <-53.757, 320.1527, 41.9721> }
					triangle { <-53.757, 320.1527, 41.9721>, <-52.8877, 319.9679, 40.1373>, <-52.6928, 320.6643, 40.5235> }
					triangle { <-52.6928, 320.6643, 40.5235>, <-52.7436, 325.844, 43.5193>, <-53.757, 320.1527, 41.9721> }
					triangle { <-52.7436, 325.844, 43.5193>, <-52.6928, 320.6643, 40.5235>, <-52.5348, 326.0461, 43.0496> }
					triangle { <-51.5449, 326.0102, 43.3513>, <-50.0877, 325.8435, 44.08551>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-51.5449, 326.0102, 43.3513>, <-52.1719, 326.2244, 42.6731>, <-50.0877, 325.8435, 44.08551> }
					triangle { <-51.5449, 326.0102, 43.3513>, <-52.5348, 326.0461, 43.0496>, <-52.1719, 326.2244, 42.6731> }
					triangle { <-49.7246, 325.6116, 44.7528>, <-52.5348, 326.0461, 43.0496>, <-51.5449, 326.0102, 43.3513> }
					triangle { <-51.8038, 321.4524, 39.08102>, <-51.00301, 323.0626, 39.7611>, <-52.1719, 326.2244, 42.6731> }
					triangle { <-52.6928, 320.6643, 40.5235>, <-52.8877, 319.9679, 40.1373>, <-51.8038, 321.4524, 39.08102> }
					triangle { <-51.8038, 321.4524, 39.08102>, <-52.1719, 326.2244, 42.6731>, <-52.6928, 320.6643, 40.5235> }
					triangle { <-52.5348, 326.0461, 43.0496>, <-52.6928, 320.6643, 40.5235>, <-52.1719, 326.2244, 42.6731> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-49.7246, 325.6116, 44.7528>, <-50.3994, 326.0161, 44.6438>, <-51.7528, 326.1253, 43.7235> }
					triangle { <-50.3994, 326.0161, 44.6438>, <-52.5876, 326.4546, 43.4176>, <-51.7528, 326.1253, 43.7235> }
					triangle { <-52.5876, 326.4546, 43.4176>, <-52.5348, 326.0461, 43.0496>, <-51.7528, 326.1253, 43.7235> }
					triangle { <-51.7528, 326.1253, 43.7235>, <-52.5348, 326.0461, 43.0496>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-52.5876, 326.4546, 43.4176>, <-55.04422, 325.359, 47.01464>, <-56.4033, 324.0, 47.3197> }
					triangle { <-56.4033, 324.0, 47.3197>, <-56.5549, 322.0572, 46.7207>, <-55.9474, 322.4669, 46.3531> }
					triangle { <-55.9474, 322.4669, 46.3531>, <-52.5876, 326.4546, 43.4176>, <-56.4033, 324.0, 47.3197> }
					triangle { <-52.5876, 326.4546, 43.4176>, <-55.9474, 322.4669, 46.3531>, <-52.5348, 326.0461, 43.0496> }
					triangle { <-51.623, 325.705, 43.4021>, <-50.2047, 325.3856, 44.1617>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-51.623, 325.705, 43.4021>, <-52.328, 325.6138, 42.7748>, <-50.2047, 325.3856, 44.1617> }
					triangle { <-51.623, 325.705, 43.4021>, <-52.5348, 326.0461, 43.0496>, <-52.328, 325.6138, 42.7748> }
					triangle { <-49.7246, 325.6116, 44.7528>, <-52.5348, 326.0461, 43.0496>, <-51.623, 325.705, 43.4021> }
					triangle { <-55.5164, 321.1272, 45.1235>, <-53.9193, 321.7155, 44.2291>, <-52.328, 325.6138, 42.7748> }
					triangle { <-55.9474, 322.4669, 46.3531>, <-56.5549, 322.0572, 46.7207>, <-55.5164, 321.1272, 45.1235> }
					triangle { <-55.5164, 321.1272, 45.1235>, <-52.328, 325.6138, 42.7748>, <-55.9474, 322.4669, 46.3531> }
					triangle { <-52.5348, 326.0461, 43.0496>, <-55.9474, 322.4669, 46.3531>, <-52.328, 325.6138, 42.7748> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-49.7246, 325.6116, 44.7528>, <-50.1487, 326.0413, 44.2367>, <-51.5857, 326.1421, 43.4521> }
					triangle { <-50.1487, 326.0413, 44.2367>, <-52.2534, 326.4881, 42.8748>, <-51.5857, 326.1421, 43.4521> }
					triangle { <-52.2534, 326.4881, 42.8748>, <-52.5348, 326.0461, 43.0496>, <-51.5857, 326.1421, 43.4521> }
					triangle { <-51.5857, 326.1421, 43.4521>, <-52.5348, 326.0461, 43.0496>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-52.2534, 326.4881, 42.8748>, <-53.1636, 330.2469, 45.1588>, <-54.6906, 330.8029, 46.2295> }
					triangle { <-54.6906, 330.8029, 46.2295>, <-55.8663, 329.8015, 47.5604>, <-55.3631, 329.3132, 47.1357> }
					triangle { <-55.3631, 329.3132, 47.1357>, <-52.2534, 326.4881, 42.8748>, <-54.6906, 330.8029, 46.2295> }
					triangle { <-52.2534, 326.4881, 42.8748>, <-55.3631, 329.3132, 47.1357>, <-52.5348, 326.0461, 43.0496> }
					triangle { <-51.7901, 325.6882, 43.6736>, <-50.4553, 325.3604, 44.5689>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-51.7901, 325.6882, 43.6736>, <-52.6622, 325.5803, 43.3177>, <-50.4553, 325.3604, 44.5689> }
					triangle { <-51.7901, 325.6882, 43.6736>, <-52.5348, 326.0461, 43.0496>, <-52.6622, 325.5803, 43.3177> }
					triangle { <-49.7246, 325.6116, 44.7528>, <-52.5348, 326.0461, 43.0496>, <-51.7901, 325.6882, 43.6736> }
					triangle { <-56.08745, 327.701, 47.7428>, <-54.9352, 326.3128, 47.07811>, <-52.6622, 325.5803, 43.3177> }
					triangle { <-55.3631, 329.3132, 47.1357>, <-55.8663, 329.8015, 47.5604>, <-56.08745, 327.701, 47.7428> }
					triangle { <-56.08745, 327.701, 47.7428>, <-52.6622, 325.5803, 43.3177>, <-55.3631, 329.3132, 47.1357> }
					triangle { <-52.5348, 326.0461, 43.0496>, <-55.3631, 329.3132, 47.1357>, <-52.6622, 325.5803, 43.3177> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-49.7246, 325.6116, 44.7528>, <-50.111, 325.5895, 44.05918>, <-51.5605, 325.8409, 43.3337> }
					triangle { <-50.111, 325.5895, 44.05918>, <-52.203, 325.8858, 42.638>, <-51.5605, 325.8409, 43.3337> }
					triangle { <-52.203, 325.8858, 42.638>, <-52.5348, 326.0461, 43.0496>, <-51.5605, 325.8409, 43.3337> }
					triangle { <-51.5605, 325.8409, 43.3337>, <-52.5348, 326.0461, 43.0496>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-52.203, 325.8858, 42.638>, <-50.3871, 329.2859, 40.3326>, <-50.9144, 331.1429, 40.08593> }
					triangle { <-50.9144, 331.1429, 40.08593>, <-51.6904, 332.527, 41.3659>, <-51.6738, 331.7679, 41.675> }
					triangle { <-51.6738, 331.7679, 41.675>, <-52.203, 325.8858, 42.638>, <-50.9144, 331.1429, 40.08593> }
					triangle { <-52.203, 325.8858, 42.638>, <-51.6738, 331.7679, 41.675>, <-52.5348, 326.0461, 43.0496> }
					triangle { <-51.8152, 325.9893, 43.792>, <-50.4931, 325.8122, 44.7464>, <-49.7246, 325.6116, 44.7528> }
					triangle { <-51.8152, 325.9893, 43.792>, <-52.7125, 326.1826, 43.5544>, <-50.4931, 325.8122, 44.7464> }
					triangle { <-51.8152, 325.9893, 43.792>, <-52.5348, 326.0461, 43.0496>, <-52.7125, 326.1826, 43.5544> }
					triangle { <-49.7246, 325.6116, 44.7528>, <-52.5348, 326.0461, 43.0496>, <-51.8152, 325.9893, 43.792> }
					triangle { <-52.6553, 332.157, 43.2169>, <-52.595, 330.5722, 44.3037>, <-52.7125, 326.1826, 43.5544> }
					triangle { <-51.6738, 331.7679, 41.675>, <-51.6904, 332.527, 41.3659>, <-52.6553, 332.157, 43.2169> }
					triangle { <-52.6553, 332.157, 43.2169>, <-52.7125, 326.1826, 43.5544>, <-51.6738, 331.7679, 41.675> }
					triangle { <-52.5348, 326.0461, 43.0496>, <-51.6738, 331.7679, 41.675>, <-52.7125, 326.1826, 43.5544> }
					material { txphlox_flower }}
				}
			}
		}
	union { // internode
		cylinder { <0.7839, 84.8309, 3.6041>, <-1.09653, 96.2127, 5.9552>, 0.6 }
		cylinder { <-1.09653, 96.2127, 5.9552>, <-2.4054, 107.6777, 8.2898>, 0.6 }
		cylinder { <-2.4054, 107.6777, 8.2898>, <-3.1395, 119.1982, 10.6024>, 0.6 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.1395, 119.1982, 10.6024>, <-3.05887, 120.1322, 10.7819>, 0.9729 }
			cylinder { <-3.05887, 120.1322, 10.7819>, <-2.8397, 121.046, 10.9494>, 0.9729 }
			cylinder { <-2.8397, 121.046, 10.9494>, <-2.4868, 121.9198, 11.1013>, 0.9729 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <-2.4868, 121.9198, 11.1013>, <13.979, 153.3071, 4.2398>, <13.7855, 149.1207, 16.8936> }
			triangle { <13.7855, 149.1207, 16.8936>, <13.979, 153.3071, 4.2398>, <24.5492, 169.3927, 4.1241> }
			triangle { <13.7855, 149.1207, 16.8936>, <24.5492, 169.3927, 4.1241>, <27.5478, 164.6272, 17.3787> }
			triangle { <27.5478, 164.6272, 17.3787>, <24.5492, 169.3927, 4.1241>, <36.391, 176.336, 6.8648> }
			triangle { <27.5478, 164.6272, 17.3787>, <36.391, 176.336, 6.8648>, <38.2465, 171.6714, 15.8485> }
			triangle { <38.2465, 171.6714, 15.8485>, <36.391, 176.336, 6.8648>, <44.3257, 173.0944, 13.1752> }
			triangle { <44.623, 168.0702, 21.1849>, <38.2465, 171.6714, 15.8485>, <44.3257, 173.0944, 13.1752> }
			triangle { <44.623, 168.0702, 21.1849>, <27.5478, 164.6272, 17.3787>, <38.2465, 171.6714, 15.8485> }
			triangle { <44.623, 168.0702, 21.1849>, <36.4642, 158.8266, 25.5259>, <27.5478, 164.6272, 17.3787> }
			triangle { <27.5478, 164.6272, 17.3787>, <36.4642, 158.8266, 25.5259>, <13.7855, 149.1207, 16.8936> }
			triangle { <13.7855, 149.1207, 16.8936>, <36.4642, 158.8266, 25.5259>, <21.7959, 144.5808, 21.857> }
			triangle { <13.7855, 149.1207, 16.8936>, <21.7959, 144.5808, 21.857>, <-2.4868, 121.9198, 11.1013> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <-3.1395, 119.1982, 10.6024>, <-3.008671, 130.7499, 12.8715>, 0.6 }
		cylinder { <-3.008671, 130.7499, 12.8715>, <-2.01346, 142.2704, 15.0848>, 0.6 }
		cylinder { <-2.01346, 142.2704, 15.0848>, <-0.1593, 153.697, 17.2302>, 0.6 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1593, 153.697, 17.2302>, <0.1716, 154.5788, 17.385>, 0.9729 }
			cylinder { <0.1716, 154.5788, 17.385>, <0.6707, 155.3821, 17.5147>, 0.9729 }
			cylinder { <0.6707, 155.3821, 17.5147>, <1.3185, 156.0761, 17.6142>, 0.9729 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <1.3185, 156.0761, 17.6142>, <19.1952, 186.2077, 8.9038>, <21.01652, 181.3258, 21.173> }
			triangle { <21.01652, 181.3258, 21.173>, <19.1952, 186.2077, 8.9038>, <31.09014, 201.2609, 7.3531> }
			triangle { <21.01652, 181.3258, 21.173>, <31.09014, 201.2609, 7.3531>, <36.08593, 195.4822, 19.5611> }
			triangle { <36.08593, 195.4822, 19.5611>, <31.09014, 201.2609, 7.3531>, <43.867, 206.9437, 7.9883> }
			triangle { <36.08593, 195.4822, 19.5611>, <43.867, 206.9437, 7.9883>, <46.9381, 201.6165, 16.2404> }
			triangle { <46.9381, 201.6165, 16.2404>, <43.867, 206.9437, 7.9883>, <52.5026, 202.6423, 12.484> }
			triangle { <53.8299, 197.1539, 20.07368>, <46.9381, 201.6165, 16.2404>, <52.5026, 202.6423, 12.484> }
			triangle { <53.8299, 197.1539, 20.07368>, <36.08593, 195.4822, 19.5611>, <46.9381, 201.6165, 16.2404> }
			triangle { <53.8299, 197.1539, 20.07368>, <45.7784, 188.4415, 25.562>, <36.08593, 195.4822, 19.5611> }
			triangle { <36.08593, 195.4822, 19.5611>, <45.7784, 188.4415, 25.562>, <21.01652, 181.3258, 21.173> }
			triangle { <21.01652, 181.3258, 21.173>, <45.7784, 188.4415, 25.562>, <29.3391, 175.8052, 24.2826> }
			triangle { <21.01652, 181.3258, 21.173>, <29.3391, 175.8052, 24.2826>, <1.3185, 156.0761, 17.6142> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <-0.1593, 153.697, 17.2302>, <1.4722, 165.1885, 19.2032>, 0.6 }
		cylinder { <1.4722, 165.1885, 19.2032>, <2.8802, 176.7379, 21.00245>, 0.6 }
		cylinder { <2.8802, 176.7379, 21.00245>, <4.06398, 188.3383, 22.6269>, 0.6 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.06398, 188.3383, 22.6269>, <3.9959, 189.2764, 22.6285>, 0.9587 }
			cylinder { <3.9959, 189.2764, 22.6285>, <3.7686, 190.1803, 22.5018>, 0.9587 }
			cylinder { <3.7686, 190.1803, 22.5018>, <3.3931, 191.0061, 22.2531>, 0.9587 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <3.3931, 191.0061, 22.2531>, <-10.9283, 222.8192, 29.2097>, <-5.06636, 221.2475, 17.5608> }
			triangle { <-5.06636, 221.2475, 17.5608>, <-10.9283, 222.8192, 29.2097>, <-18.4476, 240.2307, 28.9825> }
			triangle { <-5.06636, 221.2475, 17.5608>, <-18.4476, 240.2307, 28.9825>, <-15.07747, 238.914, 15.2608> }
			triangle { <-15.07747, 238.914, 15.2608>, <-18.4476, 240.2307, 28.9825>, <-26.5622, 249.8438, 23.3251> }
			triangle { <-15.07747, 238.914, 15.2608>, <-26.5622, 249.8438, 23.3251>, <-24.2663, 247.5613, 13.7149> }
			triangle { <-24.2663, 247.5613, 13.7149>, <-26.5622, 249.8438, 23.3251>, <-30.6079, 249.6991, 13.6496> }
			triangle { <-27.4863, 246.5567, 5.4476>, <-24.2663, 247.5613, 13.7149>, <-30.6079, 249.6991, 13.6496> }
			triangle { <-27.4863, 246.5567, 5.4476>, <-15.07747, 238.914, 15.2608>, <-24.2663, 247.5613, 13.7149> }
			triangle { <-27.4863, 246.5567, 5.4476>, <-19.3238, 236.9191, 2.9194>, <-15.07747, 238.914, 15.2608> }
			triangle { <-15.07747, 238.914, 15.2608>, <-19.3238, 236.9191, 2.9194>, <-5.06636, 221.2475, 17.5608> }
			triangle { <-5.06636, 221.2475, 17.5608>, <-19.3238, 236.9191, 2.9194>, <-9.9523, 219.6383, 8.6289> }
			triangle { <-5.06636, 221.2475, 17.5608>, <-9.9523, 219.6383, 8.6289>, <3.3931, 191.0061, 22.2531> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <4.06398, 188.3383, 22.6269>, <5.3827, 199.7749, 25.09161>, 0.6 }
		cylinder { <5.3827, 199.7749, 25.09161>, <6.8294, 210.9856, 28.3832>, 0.6 }
		cylinder { <6.8294, 210.9856, 28.3832>, <8.3961, 221.9099, 32.4839>, 0.6 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <8.3961, 221.9099, 32.4839>, <8.5376, 222.6674, 32.9547>, 0.9204 }
			cylinder { <8.5376, 222.6674, 32.9547>, <8.6948, 223.3153, 33.5637>, 0.9204 }
			cylinder { <8.6948, 223.3153, 33.5637>, <8.8618, 223.8289, 34.2874>, 0.9204 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <8.8618, 223.8289, 34.2874>, <26.8702, 244.7751, 54.3739>, <14.6388, 243.267, 57.04699> }
			triangle { <14.6388, 243.267, 57.04699>, <26.8702, 244.7751, 54.3739>, <33.6257, 255.3795, 67.5458> }
			triangle { <14.6388, 243.267, 57.04699>, <33.6257, 255.3795, 67.5458>, <21.4882, 252.4302, 72.9859> }
			triangle { <21.4882, 252.4302, 72.9859>, <33.6257, 255.3795, 67.5458>, <35.8449, 258.0578, 80.3237> }
			triangle { <21.4882, 252.4302, 72.9859>, <35.8449, 258.0578, 80.3237>, <27.2096, 254.8631, 83.4882> }
			triangle { <27.2096, 254.8631, 83.4882>, <35.8449, 258.0578, 80.3237>, <31.3868, 253.6953, 88.2285> }
			triangle { <23.1397, 250.531, 89.665>, <27.2096, 254.8631, 83.4882>, <31.3868, 253.6953, 88.2285> }
			triangle { <23.1397, 250.531, 89.665>, <21.4882, 252.4302, 72.9859>, <27.2096, 254.8631, 83.4882> }
			triangle { <23.1397, 250.531, 89.665>, <15.00011, 245.8173, 81.6374>, <21.4882, 252.4302, 72.9859> }
			triangle { <21.4882, 252.4302, 72.9859>, <15.00011, 245.8173, 81.6374>, <14.6388, 243.267, 57.04699> }
			triangle { <14.6388, 243.267, 57.04699>, <15.00011, 245.8173, 81.6374>, <11.051, 237.5241, 64.2629> }
			triangle { <14.6388, 243.267, 57.04699>, <11.051, 237.5241, 64.2629>, <8.8618, 223.8289, 34.2874> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <8.3961, 221.9099, 32.4839>, <10.2848, 232.9477, 36.1183>, 0.6 }
		cylinder { <10.2848, 232.9477, 36.1183>, <12.4907, 244.0725, 39.2776>, 0.6 }
		cylinder { <12.4907, 244.0725, 39.2776>, <15.00859, 255.2575, 41.9543>, 0.6 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <15.00859, 255.2575, 41.9543>, <15.2763, 256.0652, 42.00458>, 0.8688 }
			cylinder { <15.2763, 256.0652, 42.00458>, <15.6192, 256.8399, 41.9092>, 0.8688 }
			cylinder { <15.6192, 256.8399, 41.9092>, <16.02411, 257.5516, 41.672>, 0.8688 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <16.02411, 257.5516, 41.672>, <19.329, 287.5598, 30.3544>, <29.01874, 282.3022, 34.8463> }
			triangle { <29.01874, 282.3022, 34.8463>, <19.329, 287.5598, 30.3544>, <24.5819, 302.7222, 24.1902> }
			triangle { <29.01874, 282.3022, 34.8463>, <24.5819, 302.7222, 24.1902>, <35.9943, 297.1837, 26.3081> }
			triangle { <35.9943, 297.1837, 26.3081>, <24.5819, 302.7222, 24.1902>, <31.9955, 309.6131, 16.8532> }
			triangle { <35.9943, 297.1837, 26.3081>, <31.9955, 309.6131, 16.8532>, <39.5621, 304.5808, 18.2281> }
			triangle { <39.5621, 304.5808, 18.2281>, <31.9955, 309.6131, 16.8532>, <39.9816, 306.7374, 12.5746> }
			triangle { <46.1231, 301.3612, 14.7537>, <39.5621, 304.5808, 18.2281>, <39.9816, 306.7374, 12.5746> }
			triangle { <46.1231, 301.3612, 14.7537>, <35.9943, 297.1837, 26.3081>, <39.5621, 304.5808, 18.2281> }
			triangle { <46.1231, 301.3612, 14.7537>, <45.661, 291.9245, 21.6094>, <35.9943, 297.1837, 26.3081> }
			triangle { <35.9943, 297.1837, 26.3081>, <45.661, 291.9245, 21.6094>, <29.01874, 282.3022, 34.8463> }
			triangle { <29.01874, 282.3022, 34.8463>, <45.661, 291.9245, 21.6094>, <35.8772, 278.4577, 29.8022> }
			triangle { <29.01874, 282.3022, 34.8463>, <35.8772, 278.4577, 29.8022>, <16.02411, 257.5516, 41.672> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <15.00859, 255.2575, 41.9543>, <16.09361, 266.0498, 44.894>, 0.5727 }
		cylinder { <16.09361, 266.0498, 44.894>, <15.8439, 276.7955, 48.1742>, 0.5727 }
		cylinder { <15.8439, 276.7955, 48.1742>, <14.2632, 287.333, 51.7456>, 0.5727 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <14.2632, 287.333, 51.7456>, <14.0458, 287.9716, 51.9943>, 0.7327 }
			cylinder { <14.0458, 287.9716, 51.9943>, <13.7183, 288.5557, 52.2559>, 0.7327 }
			cylinder { <13.7183, 288.5557, 52.2559>, <13.2905, 289.0682, 52.5228>, 0.7327 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <13.2905, 289.0682, 52.5228>, <1.1444, 304.8016, 71.07791>, <-1.4536, 306.1403, 61.4731> }
			triangle { <-1.4536, 306.1403, 61.4731>, <1.1444, 304.8016, 71.07791>, <-7.4062, 313.5993, 78.8015> }
			triangle { <-1.4536, 306.1403, 61.4731>, <-7.4062, 313.5993, 78.8015>, <-12.3806, 314.2112, 69.1825> }
			triangle { <-12.3806, 314.2112, 69.1825>, <-7.4062, 313.5993, 78.8015>, <-16.9407, 317.0679, 81.6679> }
			triangle { <-12.3806, 314.2112, 69.1825>, <-16.9407, 317.0679, 81.6679>, <-20.09228, 316.5657, 74.6043> }
			triangle { <-20.09228, 316.5657, 74.6043>, <-16.9407, 317.0679, 81.6679>, <-23.8754, 315.6212, 77.9152> }
			triangle { <-25.6628, 314.831, 71.06371>, <-20.09228, 316.5657, 74.6043>, <-23.8754, 315.6212, 77.9152> }
			triangle { <-25.6628, 314.831, 71.06371>, <-12.3806, 314.2112, 69.1825>, <-20.09228, 316.5657, 74.6043> }
			triangle { <-25.6628, 314.831, 71.06371>, <-20.2828, 311.501, 63.5213>, <-12.3806, 314.2112, 69.1825> }
			triangle { <-12.3806, 314.2112, 69.1825>, <-20.2828, 311.501, 63.5213>, <-1.4536, 306.1403, 61.4731> }
			triangle { <-1.4536, 306.1403, 61.4731>, <-20.2828, 311.501, 63.5213>, <-8.03638, 303.3909, 58.1302> }
			triangle { <-1.4536, 306.1403, 61.4731>, <-8.03638, 303.3909, 58.1302>, <13.2905, 289.0682, 52.5228> }
			material { txphlox_leaf }}
		}
	union { // internode
		cylinder { <14.2632, 287.333, 51.7456>, <13.775, 292.0151, 53.4533>, 0.2552 }
		cylinder { <13.775, 292.0151, 53.4533>, <13.5041, 296.6725, 55.2732>, 0.2552 }
		cylinder { <13.5041, 296.6725, 55.2732>, <13.451, 301.2939, 57.2009>, 0.2552 }
		material { txphlox_inter }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <13.451, 301.2939, 57.2009>, <13.4788, 301.4998, 57.3038>, 0.2362 }
			cylinder { <13.4788, 301.4998, 57.3038>, <13.5361, 301.6931, 57.418>, 0.2362 }
			cylinder { <13.5361, 301.6931, 57.418>, <13.6218, 301.8698, 57.5413>, 0.2362 }
			material { txphlox_petiole }}
		mesh { // leaf
			triangle { <13.6218, 301.8698, 57.5413>, <18.7267, 308.6743, 59.6601>, <17.1201, 307.2136, 62.06055> }
			triangle { <17.1201, 307.2136, 62.06055>, <18.7267, 308.6743, 59.6601>, <21.4039, 311.924, 61.6893> }
			triangle { <17.1201, 307.2136, 62.06055>, <21.4039, 311.924, 61.6893>, <20.3905, 310.1452, 64.5242> }
			triangle { <20.3905, 310.1452, 64.5242>, <21.4039, 311.924, 61.6893>, <23.7833, 312.8561, 63.9306> }
			triangle { <20.3905, 310.1452, 64.5242>, <23.7833, 312.8561, 63.9306>, <23.02137, 311.3229, 65.7508> }
			triangle { <23.02137, 311.3229, 65.7508>, <23.7833, 312.8561, 63.9306>, <24.6563, 311.4568, 65.9205> }
			triangle { <23.6663, 309.9546, 67.3486>, <23.02137, 311.3229, 65.7508>, <24.6563, 311.4568, 65.9205> }
			triangle { <23.6663, 309.9546, 67.3486>, <20.3905, 310.1452, 64.5242>, <23.02137, 311.3229, 65.7508> }
			triangle { <23.6663, 309.9546, 67.3486>, <21.1936, 308.0259, 66.8586>, <20.3905, 310.1452, 64.5242> }
			triangle { <20.3905, 310.1452, 64.5242>, <21.1936, 308.0259, 66.8586>, <17.1201, 307.2136, 62.06055> }
			triangle { <17.1201, 307.2136, 62.06055>, <21.1936, 308.0259, 66.8586>, <18.1302, 305.5581, 63.7007> }
			triangle { <17.1201, 307.2136, 62.06055>, <18.1302, 305.5581, 63.7007>, <13.6218, 301.8698, 57.5413> }
			material { txphlox_leaf }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <13.451, 301.2939, 57.2009>, <13.0897, 332.7979, 70.3421>, 0.2999 }
			cylinder { <13.0897, 332.7979, 70.3421>, <12.7283, 364.3018, 83.4832>, 0.2999 }
			cylinder { <12.7283, 364.3018, 83.4832>, <12.3669, 395.8057, 96.6244>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <12.3669, 395.8057, 96.6244>, <12.4903, 397.9483, 97.5921>, 0.2999 }
			cylinder { <12.4903, 397.9483, 97.5921>, <12.7615, 400.0505, 98.6166>, 0.2999 }
			cylinder { <12.7615, 400.0505, 98.6166>, <13.179, 402.1021, 99.6932>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <13.179, 402.1021, 99.6932>, <13.7408, 404.0932, 100.817>, 0.2999 }
			cylinder { <13.7408, 404.0932, 100.817>, <14.444, 406.014, 101.9826>, 0.2999 }
			cylinder { <14.444, 406.014, 101.9826>, <15.2851, 407.8553, 103.1845>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <15.2851, 407.8553, 103.1845>, <16.2602, 409.6081, 104.4173>, 0.2999 }
			cylinder { <16.2602, 409.6081, 104.4173>, <17.3642, 411.2639, 105.675>, 0.2999 }
			cylinder { <17.3642, 411.2639, 105.675>, <18.592, 412.8146, 106.9518>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <18.592, 412.8146, 106.9518>, <19.9374, 414.2528, 108.2417>, 0.2999 }
			cylinder { <19.9374, 414.2528, 108.2417>, <21.3939, 415.5715, 109.5387>, 0.2999 }
			cylinder { <21.3939, 415.5715, 109.5387>, <22.9544, 416.7642, 110.8368>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <22.9544, 416.7642, 110.8368>, <24.6113, 417.8251, 112.1297>, 0.2999 }
			cylinder { <24.6113, 417.8251, 112.1297>, <26.3566, 418.749, 113.4114>, 0.2999 }
			cylinder { <26.3566, 418.749, 113.4114>, <28.1818, 419.5314, 114.676>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <28.1818, 419.5314, 114.676>, <30.07793, 420.1685, 115.9175>, 0.2999 }
			cylinder { <30.07793, 420.1685, 115.9175>, <32.03582, 420.6572, 117.1301>, 0.2999 }
			cylinder { <32.03582, 420.6572, 117.1301>, <34.04596, 420.995, 118.3081>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <34.04596, 420.995, 118.3081>, <36.0986, 421.1803, 119.4461>, 0.2999 }
			cylinder { <36.0986, 421.1803, 119.4461>, <38.1837, 421.212, 120.5386>, 0.2999 }
			cylinder { <38.1837, 421.212, 120.5386>, <40.2913, 421.0899, 121.5807>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <40.2913, 421.0899, 121.5807>, <42.411, 420.8147, 122.5673>, 0.2999 }
			cylinder { <42.411, 420.8147, 122.5673>, <44.5326, 420.3875, 123.4941>, 0.2999 }
			cylinder { <44.5326, 420.3875, 123.4941>, <46.6458, 419.8103, 124.3566>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <46.6458, 419.8103, 124.3566>, <48.8114, 419.3811, 125.1742>, 0.2999 }
			cylinder { <48.8114, 419.3811, 125.1742>, <51.01911, 419.1021, 125.9428>, 0.2999 }
			cylinder { <51.01911, 419.1021, 125.9428>, <53.2583, 418.9743, 126.6585>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <53.2583, 418.9743, 126.6585>, <59.3485, 417.9863, 130.0959>, 0.2999 }
				cylinder { <59.3485, 417.9863, 130.0959>, <64.5155, 416.4417, 134.6565>, 0.2999 }
				cylinder { <64.5155, 416.4417, 134.6565>, <68.508, 414.4154, 140.1188>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <68.508, 414.4154, 140.1188>, <68.6814, 414.0287, 140.8306>, <69.869, 413.8196, 142.0441> }
					triangle { <68.6814, 414.0287, 140.8306>, <70.2884, 413.4794, 142.8724>, <69.869, 413.8196, 142.0441> }
					triangle { <70.2884, 413.4794, 142.8724>, <70.7255, 413.8137, 142.7018>, <69.869, 413.8196, 142.0441> }
					triangle { <69.869, 413.8196, 142.0441>, <70.7255, 413.8137, 142.7018>, <68.508, 414.4154, 140.1188> }
					triangle { <70.2884, 413.4794, 142.8724>, <67.4128, 415.5349, 145.9467>, <67.6575, 417.0818, 147.2379> }
					triangle { <67.6575, 417.0818, 147.2379>, <68.6668, 418.9447, 147.0589>, <68.8276, 418.4057, 146.4149> }
					triangle { <68.8276, 418.4057, 146.4149>, <70.2884, 413.4794, 142.8724>, <67.6575, 417.0818, 147.2379> }
					triangle { <70.2884, 413.4794, 142.8724>, <68.8276, 418.4057, 146.4149>, <70.7255, 413.8137, 142.7018> }
					triangle { <70.2454, 414.1704, 141.8027>, <69.2459, 414.5548, 140.4685>, <68.508, 414.4154, 140.1188> }
					triangle { <70.2454, 414.1704, 141.8027>, <71.04116, 414.1809, 142.3896>, <69.2459, 414.5548, 140.4685> }
					triangle { <70.2454, 414.1704, 141.8027>, <70.7255, 413.8137, 142.7018>, <71.04116, 414.1809, 142.3896> }
					triangle { <68.508, 414.4154, 140.1188>, <70.7255, 413.8137, 142.7018>, <70.2454, 414.1704, 141.8027> }
					triangle { <70.2293, 419.4785, 145.5883>, <70.6747, 418.5747, 143.8546>, <71.04116, 414.1809, 142.3896> }
					triangle { <68.8276, 418.4057, 146.4149>, <68.6668, 418.9447, 147.0589>, <70.2293, 419.4785, 145.5883> }
					triangle { <70.2293, 419.4785, 145.5883>, <71.04116, 414.1809, 142.3896>, <68.8276, 418.4057, 146.4149> }
					triangle { <70.7255, 413.8137, 142.7018>, <68.8276, 418.4057, 146.4149>, <71.04116, 414.1809, 142.3896> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <68.508, 414.4154, 140.1188>, <69.03188, 413.8987, 140.4995>, <70.1027, 413.733, 141.8233> }
					triangle { <69.03188, 413.8987, 140.4995>, <70.7556, 413.3061, 142.4309>, <70.1027, 413.733, 141.8233> }
					triangle { <70.7556, 413.3061, 142.4309>, <70.7255, 413.8137, 142.7018>, <70.1027, 413.733, 141.8233> }
					triangle { <70.1027, 413.733, 141.8233>, <70.7255, 413.8137, 142.7018>, <68.508, 414.4154, 140.1188> }
					triangle { <70.7556, 413.3061, 142.4309>, <67.9289, 410.0271, 144.2205>, <67.07011, 409.7976, 146.0452> }
					triangle { <67.07011, 409.7976, 146.0452>, <66.178, 411.1844, 147.3877>, <66.5922, 411.5556, 146.7382> }
					triangle { <66.5922, 411.5556, 146.7382>, <70.7556, 413.3061, 142.4309>, <67.07011, 409.7976, 146.0452> }
					triangle { <70.7556, 413.3061, 142.4309>, <66.5922, 411.5556, 146.7382>, <70.7255, 413.8137, 142.7018> }
					triangle { <70.01182, 414.257, 142.0234>, <68.8955, 414.6848, 140.7996>, <68.508, 414.4154, 140.1188> }
					triangle { <70.01182, 414.257, 142.0234>, <70.5739, 414.3542, 142.8311>, <68.8955, 414.6848, 140.7996> }
					triangle { <70.01182, 414.257, 142.0234>, <70.7255, 413.8137, 142.7018>, <70.5739, 414.3542, 142.8311> }
					triangle { <68.508, 414.4154, 140.1188>, <70.7255, 413.8137, 142.7018>, <70.01182, 414.257, 142.0234> }
					triangle { <66.449, 413.3787, 147.4126>, <67.1412, 414.569, 145.9548>, <70.5739, 414.3542, 142.8311> }
					triangle { <66.5922, 411.5556, 146.7382>, <66.178, 411.1844, 147.3877>, <66.449, 413.3787, 147.4126> }
					triangle { <66.449, 413.3787, 147.4126>, <70.5739, 414.3542, 142.8311>, <66.5922, 411.5556, 146.7382> }
					triangle { <70.7255, 413.8137, 142.7018>, <66.5922, 411.5556, 146.7382>, <70.5739, 414.3542, 142.8311> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <68.508, 414.4154, 140.1188>, <69.2887, 414.3082, 140.3743>, <70.2739, 414.006, 141.7399> }
					triangle { <69.2887, 414.3082, 140.3743>, <71.09818, 413.8521, 142.2641>, <70.2739, 414.006, 141.7399> }
					triangle { <71.09818, 413.8521, 142.2641>, <70.7255, 413.8137, 142.7018>, <70.2739, 414.006, 141.7399> }
					triangle { <70.2739, 414.006, 141.7399>, <70.7255, 413.8137, 142.7018>, <68.508, 414.4154, 140.1188> }
					triangle { <71.09818, 413.8521, 142.2641>, <72.2837, 409.7168, 140.4097>, <72.2508, 407.8224, 141.1375> }
					triangle { <72.2508, 407.8224, 141.1375>, <70.8486, 406.7842, 142.353>, <70.6974, 407.624, 142.2981> }
					triangle { <70.6974, 407.624, 142.2981>, <71.09818, 413.8521, 142.2641>, <72.2508, 407.8224, 141.1375> }
					triangle { <71.09818, 413.8521, 142.2641>, <70.6974, 407.624, 142.2981>, <70.7255, 413.8137, 142.7018> }
					triangle { <69.8405, 413.984, 142.1068>, <68.6386, 414.2753, 140.9247>, <68.508, 414.4154, 140.1188> }
					triangle { <69.8405, 413.984, 142.1068>, <70.2314, 413.8082, 142.998>, <68.6386, 414.2753, 140.9247> }
					triangle { <69.8405, 413.984, 142.1068>, <70.7255, 413.8137, 142.7018>, <70.2314, 413.8082, 142.998> }
					triangle { <68.508, 414.4154, 140.1188>, <70.7255, 413.8137, 142.7018>, <69.8405, 413.984, 142.1068> }
					triangle { <69.2893, 407.6722, 143.6449>, <68.5277, 409.5265, 143.5898>, <70.2314, 413.8082, 142.998> }
					triangle { <70.6974, 407.624, 142.2981>, <70.8486, 406.7842, 142.353>, <69.2893, 407.6722, 143.6449> }
					triangle { <69.2893, 407.6722, 143.6449>, <70.2314, 413.8082, 142.998>, <70.6974, 407.624, 142.2981> }
					triangle { <70.7255, 413.8137, 142.7018>, <70.6974, 407.624, 142.2981>, <70.2314, 413.8082, 142.998> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <68.508, 414.4154, 140.1188>, <69.09946, 414.6952, 140.627>, <70.1477, 414.2639, 141.9083> }
					triangle { <69.09946, 414.6952, 140.627>, <70.8457, 414.368, 142.601>, <70.1477, 414.2639, 141.9083> }
					triangle { <70.8457, 414.368, 142.601>, <70.7255, 413.8137, 142.7018>, <70.1477, 414.2639, 141.9083> }
					triangle { <70.1477, 414.2639, 141.9083>, <70.7255, 413.8137, 142.7018>, <68.508, 414.4154, 140.1188> }
					triangle { <70.8457, 414.368, 142.601>, <74.4996, 415.0301, 139.7451>, <76.0884, 413.8673, 139.2513> }
					triangle { <76.0884, 413.8673, 139.2513>, <76.2675, 411.7839, 138.8656>, <75.5083, 412.0075, 139.1892> }
					triangle { <75.5083, 412.0075, 139.1892>, <70.8457, 414.368, 142.601>, <76.0884, 413.8673, 139.2513> }
					triangle { <70.8457, 414.368, 142.601>, <75.5083, 412.0075, 139.1892>, <70.7255, 413.8137, 142.7018> }
					triangle { <69.9667, 413.7261, 141.9384>, <68.8279, 413.8884, 140.6721>, <68.508, 414.4154, 140.1188> }
					triangle { <69.9667, 413.7261, 141.9384>, <70.4837, 413.2923, 142.6611>, <68.8279, 413.8884, 140.6721> }
					triangle { <69.9667, 413.7261, 141.9384>, <70.7255, 413.8137, 142.7018>, <70.4837, 413.2923, 142.6611> }
					triangle { <68.508, 414.4154, 140.1188>, <70.7255, 413.8137, 142.7018>, <69.9667, 413.7261, 141.9384> }
					triangle { <74.8515, 410.192, 139.4569>, <72.9309, 410.3687, 140.006>, <70.4837, 413.2923, 142.6611> }
					triangle { <75.5083, 412.0075, 139.1892>, <76.2675, 411.7839, 138.8656>, <74.8515, 410.192, 139.4569> }
					triangle { <74.8515, 410.192, 139.4569>, <70.4837, 413.2923, 142.6611>, <75.5083, 412.0075, 139.1892> }
					triangle { <70.7255, 413.8137, 142.7018>, <75.5083, 412.0075, 139.1892>, <70.4837, 413.2923, 142.6611> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <68.508, 414.4154, 140.1188>, <68.7184, 414.5198, 140.9132>, <69.8937, 414.147, 142.0991> }
					triangle { <68.7184, 414.5198, 140.9132>, <70.3377, 414.1342, 142.9826>, <69.8937, 414.147, 142.0991> }
					triangle { <70.3377, 414.1342, 142.9826>, <70.7255, 413.8137, 142.7018>, <69.8937, 414.147, 142.0991> }
					triangle { <69.8937, 414.147, 142.0991>, <70.7255, 413.8137, 142.7018>, <68.508, 414.4154, 140.1188> }
					triangle { <70.3377, 414.1342, 142.9826>, <71.4438, 418.6801, 143.2188>, <73.2067, 419.6764, 143.0784> }
					triangle { <73.2067, 419.6764, 143.0784>, <74.8988, 419.413, 141.8179>, <74.3353, 418.7715, 141.772> }
					triangle { <74.3353, 418.7715, 141.772>, <70.3377, 414.1342, 142.9826>, <73.2067, 419.6764, 143.0784> }
					triangle { <70.3377, 414.1342, 142.9826>, <74.3353, 418.7715, 141.772>, <70.7255, 413.8137, 142.7018> }
					triangle { <70.2207, 413.843, 141.7476>, <69.2089, 414.0638, 140.3859>, <68.508, 414.4154, 140.1188> }
					triangle { <70.2207, 413.843, 141.7476>, <70.9918, 413.5261, 142.2795>, <69.2089, 414.0638, 140.3859> }
					triangle { <70.2207, 413.843, 141.7476>, <70.7255, 413.8137, 142.7018>, <70.9918, 413.5261, 142.2795> }
					triangle { <68.508, 414.4154, 140.1188>, <70.7255, 413.8137, 142.7018>, <70.2207, 413.843, 141.7476> }
					triangle { <75.4412, 417.5989, 140.6761>, <74.2779, 416.0453, 140.172>, <70.9918, 413.5261, 142.2795> }
					triangle { <74.3353, 418.7715, 141.772>, <74.8988, 419.413, 141.8179>, <75.4412, 417.5989, 140.6761> }
					triangle { <75.4412, 417.5989, 140.6761>, <70.9918, 413.5261, 142.2795>, <74.3353, 418.7715, 141.772> }
					triangle { <70.7255, 413.8137, 142.7018>, <74.3353, 418.7715, 141.772>, <70.9918, 413.5261, 142.2795> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <53.2583, 418.9743, 126.6585>, <55.4437, 418.7749, 127.5108>, 0.2999 }
			cylinder { <55.4437, 418.7749, 127.5108>, <57.5649, 418.505, 128.4957>, 0.2999 }
			cylinder { <57.5649, 418.505, 128.4957>, <59.6117, 418.166, 129.6086>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <59.6117, 418.166, 129.6086>, <66.2299, 416.6486, 131.5527>, 0.2999 }
				cylinder { <66.2299, 416.6486, 131.5527>, <73.00461, 414.7045, 132.0076>, 0.2999 }
				cylinder { <73.00461, 414.7045, 132.0076>, <79.6064, 412.428, 130.9514>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <79.6064, 412.428, 130.9514>, <80.2314, 412.2633, 130.4897>, <81.7552, 411.6562, 130.4782> }
					triangle { <80.2314, 412.2633, 130.4897>, <82.5943, 411.3849, 130.1301>, <81.7552, 411.6562, 130.4782> }
					triangle { <82.5943, 411.3849, 130.1301>, <82.6904, 411.2493, 130.6569>, <81.7552, 411.6562, 130.4782> }
					triangle { <81.7552, 411.6562, 130.4782>, <82.6904, 411.2493, 130.6569>, <79.6064, 412.428, 130.9514> }
					triangle { <82.5943, 411.3849, 130.1301>, <81.1439, 407.9656, 127.6046>, <81.3012, 406.0341, 127.7832> }
					triangle { <81.3012, 406.0341, 127.7832>, <81.1765, 404.7941, 129.3966>, <81.2064, 405.5888, 129.5957> }
					triangle { <81.2064, 405.5888, 129.5957>, <82.5943, 411.3849, 130.1301>, <81.3012, 406.0341, 127.7832> }
					triangle { <82.5943, 411.3849, 130.1301>, <81.2064, 405.5888, 129.5957>, <82.6904, 411.2493, 130.6569> }
					triangle { <81.7668, 411.5529, 131.0131>, <80.2488, 412.1083, 131.292>, <79.6064, 412.428, 130.9514> }
					triangle { <81.7668, 411.5529, 131.0131>, <82.6175, 411.1783, 131.1999>, <80.2488, 412.1083, 131.292> }
					triangle { <81.7668, 411.5529, 131.0131>, <82.6904, 411.2493, 130.6569>, <82.6175, 411.1783, 131.1999> }
					triangle { <79.6064, 412.428, 130.9514>, <82.6904, 411.2493, 130.6569>, <81.7668, 411.5529, 131.0131> }
					triangle { <81.3803, 405.3282, 131.4381>, <81.2443, 407.0703, 132.2401>, <82.6175, 411.1783, 131.1999> }
					triangle { <81.2064, 405.5888, 129.5957>, <81.1765, 404.7941, 129.3966>, <81.3803, 405.3282, 131.4381> }
					triangle { <81.3803, 405.3282, 131.4381>, <82.6175, 411.1783, 131.1999>, <81.2064, 405.5888, 129.5957> }
					triangle { <82.6904, 411.2493, 130.6569>, <81.2064, 405.5888, 129.5957>, <82.6175, 411.1783, 131.1999> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <79.6064, 412.428, 130.9514>, <80.3794, 412.5652, 130.8306>, <81.8538, 411.8575, 130.7055> }
					triangle { <80.3794, 412.5652, 130.8306>, <82.7916, 411.7875, 130.5846>, <81.8538, 411.8575, 130.7055> }
					triangle { <82.7916, 411.7875, 130.5846>, <82.6904, 411.2493, 130.6569>, <81.8538, 411.8575, 130.7055> }
					triangle { <81.8538, 411.8575, 130.7055>, <82.6904, 411.2493, 130.6569>, <79.6064, 412.428, 130.9514> }
					triangle { <82.7916, 411.7875, 130.5846>, <82.959, 413.0463, 126.2764>, <83.307, 412.0699, 124.6293> }
					triangle { <83.307, 412.0699, 124.6293>, <82.7345, 410.2217, 123.9867>, <82.5697, 410.3591, 124.7779> }
					triangle { <82.5697, 410.3591, 124.7779>, <82.7916, 411.7875, 130.5846>, <83.307, 412.0699, 124.6293> }
					triangle { <82.7916, 411.7875, 130.5846>, <82.5697, 410.3591, 124.7779>, <82.6904, 411.2493, 130.6569> }
					triangle { <81.6681, 411.3516, 130.7859>, <80.1009, 411.8064, 130.9512>, <79.6064, 412.428, 130.9514> }
					triangle { <81.6681, 411.3516, 130.7859>, <82.4202, 410.7757, 130.7454>, <80.1009, 411.8064, 130.9512> }
					triangle { <81.6681, 411.3516, 130.7859>, <82.6904, 411.2493, 130.6569>, <82.4202, 410.7757, 130.7454> }
					triangle { <79.6064, 412.428, 130.9514>, <82.6904, 411.2493, 130.6569>, <81.6681, 411.3516, 130.7859> }
					triangle { <82.03822, 408.6129, 125.1788>, <81.3497, 408.6618, 126.9733>, <82.4202, 410.7757, 130.7454> }
					triangle { <82.5697, 410.3591, 124.7779>, <82.7345, 410.2217, 123.9867>, <82.03822, 408.6129, 125.1788> }
					triangle { <82.03822, 408.6129, 125.1788>, <82.4202, 410.7757, 130.7454>, <82.5697, 410.3591, 124.7779> }
					triangle { <82.6904, 411.2493, 130.6569>, <82.5697, 410.3591, 124.7779>, <82.4202, 410.7757, 130.7454> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <79.6064, 412.428, 130.9514>, <80.3362, 412.3464, 131.2542>, <81.825, 411.7116, 130.9879> }
					triangle { <80.3362, 412.3464, 131.2542>, <82.7339, 411.4957, 131.1494>, <81.825, 411.7116, 130.9879> }
					triangle { <82.7339, 411.4957, 131.1494>, <82.6904, 411.2493, 130.6569>, <81.825, 411.7116, 130.9879> }
					triangle { <81.825, 411.7116, 130.9879>, <82.6904, 411.2493, 130.6569>, <79.6064, 412.428, 130.9514> }
					triangle { <82.7339, 411.4957, 131.1494>, <84.4053, 415.6604, 130.961>, <85.5102, 416.5804, 129.6495> }
					triangle { <85.5102, 416.5804, 129.6495>, <85.5077, 416.5723, 127.6108>, <85.02647, 415.9968, 127.9413> }
					triangle { <85.02647, 415.9968, 127.9413>, <82.7339, 411.4957, 131.1494>, <85.5102, 416.5804, 129.6495> }
					triangle { <82.7339, 411.4957, 131.1494>, <85.02647, 415.9968, 127.9413>, <82.6904, 411.2493, 130.6569> }
					triangle { <81.6969, 411.4975, 130.5035>, <80.1441, 412.0253, 130.5276>, <79.6064, 412.428, 130.9514> }
					triangle { <81.6969, 411.4975, 130.5035>, <82.4778, 411.0675, 130.1806>, <80.1441, 412.0253, 130.5276> }
					triangle { <81.6969, 411.4975, 130.5035>, <82.6904, 411.2493, 130.6569>, <82.4778, 411.0675, 130.1806> }
					triangle { <79.6064, 412.428, 130.9514>, <82.6904, 411.2493, 130.6569>, <81.6969, 411.4975, 130.5035> }
					triangle { <84.635, 415.1175, 126.3394>, <83.2954, 413.8051, 126.7628>, <82.4778, 411.0675, 130.1806> }
					triangle { <85.02647, 415.9968, 127.9413>, <85.5077, 416.5723, 127.6108>, <84.635, 415.1175, 126.3394> }
					triangle { <84.635, 415.1175, 126.3394>, <82.4778, 411.0675, 130.1806>, <85.02647, 415.9968, 127.9413> }
					triangle { <82.6904, 411.2493, 130.6569>, <85.02647, 415.9968, 127.9413>, <82.4778, 411.0675, 130.1806> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <79.6064, 412.428, 130.9514>, <80.1611, 411.9071, 131.1791>, <81.7083, 411.4188, 130.9378> }
					triangle { <80.1611, 411.9071, 131.1791>, <82.5006, 410.91, 131.0493>, <81.7083, 411.4188, 130.9378> }
					triangle { <82.5006, 410.91, 131.0493>, <82.6904, 411.2493, 130.6569>, <81.7083, 411.4188, 130.9378> }
					triangle { <81.7083, 411.4188, 130.9378>, <82.6904, 411.2493, 130.6569>, <79.6064, 412.428, 130.9514> }
					triangle { <82.5006, 410.91, 131.0493>, <83.4977, 412.2197, 135.2283>, <84.8866, 413.3743, 135.9529> }
					triangle { <84.8866, 413.3743, 135.9529>, <85.6895, 415.1288, 135.2944>, <85.2044, 414.7633, 134.7437> }
					triangle { <85.2044, 414.7633, 134.7437>, <82.5006, 410.91, 131.0493>, <84.8866, 413.3743, 135.9529> }
					triangle { <82.5006, 410.91, 131.0493>, <85.2044, 414.7633, 134.7437>, <82.6904, 411.2493, 130.6569> }
					triangle { <81.8136, 411.7903, 130.5535>, <80.3191, 412.4645, 130.6026>, <79.6064, 412.428, 130.9514> }
					triangle { <81.8136, 411.7903, 130.5535>, <82.7112, 411.6532, 130.2807>, <80.3191, 412.4645, 130.6026> }
					triangle { <81.8136, 411.7903, 130.5535>, <82.6904, 411.2493, 130.6569>, <82.7112, 411.6532, 130.2807> }
					triangle { <79.6064, 412.428, 130.9514>, <82.6904, 411.2493, 130.6569>, <81.8136, 411.7903, 130.5535> }
					triangle { <85.6064, 415.9136, 133.3268>, <84.4106, 415.4402, 131.8976>, <82.7112, 411.6532, 130.2807> }
					triangle { <85.2044, 414.7633, 134.7437>, <85.6895, 415.1288, 135.2944>, <85.6064, 415.9136, 133.3268> }
					triangle { <85.6064, 415.9136, 133.3268>, <82.7112, 411.6532, 130.2807>, <85.2044, 414.7633, 134.7437> }
					triangle { <82.6904, 411.2493, 130.6569>, <85.2044, 414.7633, 134.7437>, <82.7112, 411.6532, 130.2807> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <79.6064, 412.428, 130.9514>, <80.09546, 411.855, 130.6995>, <81.6645, 411.384, 130.6181> }
					triangle { <80.09546, 411.855, 130.6995>, <82.4129, 410.8405, 130.4099>, <81.6645, 411.384, 130.6181> }
					triangle { <82.4129, 410.8405, 130.4099>, <82.6904, 411.2493, 130.6569>, <81.6645, 411.384, 130.6181> }
					triangle { <81.6645, 411.384, 130.6181>, <82.6904, 411.2493, 130.6569>, <79.6064, 412.428, 130.9514> }
					triangle { <82.4129, 410.8405, 130.4099>, <81.4516, 407.3923, 133.1226>, <82.246, 406.758, 134.7821> }
					triangle { <82.246, 406.758, 134.7821>, <82.9722, 407.7395, 136.4147>, <82.8079, 408.2337, 135.7816> }
					triangle { <82.8079, 408.2337, 135.7816>, <82.4129, 410.8405, 130.4099>, <82.246, 406.758, 134.7821> }
					triangle { <82.4129, 410.8405, 130.4099>, <82.8079, 408.2337, 135.7816>, <82.6904, 411.2493, 130.6569> }
					triangle { <81.8574, 411.8251, 130.8732>, <80.3848, 412.5166, 131.0822>, <79.6064, 412.428, 130.9514> }
					triangle { <81.8574, 411.8251, 130.8732>, <82.7988, 411.7227, 130.9201>, <80.3848, 412.5166, 131.0822> }
					triangle { <81.8574, 411.8251, 130.8732>, <82.6904, 411.2493, 130.6569>, <82.7988, 411.7227, 130.9201> }
					triangle { <79.6064, 412.428, 130.9514>, <82.6904, 411.2493, 130.6569>, <81.8574, 411.8251, 130.8732> }
					triangle { <83.5645, 409.7721, 136.5255>, <83.1238, 411.2151, 135.3338>, <82.7988, 411.7227, 130.9201> }
					triangle { <82.8079, 408.2337, 135.7816>, <82.9722, 407.7395, 136.4147>, <83.5645, 409.7721, 136.5255> }
					triangle { <83.5645, 409.7721, 136.5255>, <82.7988, 411.7227, 130.9201>, <82.8079, 408.2337, 135.7816> }
					triangle { <82.6904, 411.2493, 130.6569>, <82.8079, 408.2337, 135.7816>, <82.7988, 411.7227, 130.9201> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <12.3669, 395.8057, 96.6244>, <12.2779, 398.0303, 97.3897>, 0.2999 }
			cylinder { <12.2779, 398.0303, 97.3897>, <12.1255, 400.2962, 98.0102>, 0.2999 }
			cylinder { <12.1255, 400.2962, 98.0102>, <11.9106, 402.5925, 98.4828>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <11.9106, 402.5925, 98.4828>, <11.08638, 403.6571, 100.4141>, 0.2999 }
			cylinder { <11.08638, 403.6571, 100.4141>, <10.2428, 404.5737, 102.4118>, 0.2999 }
			cylinder { <10.2428, 404.5737, 102.4118>, <9.3839, 405.3378, 104.4663>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.3839, 405.3378, 104.4663>, <7.9745, 408.6565, 110.5394>, 0.2999 }
				cylinder { <7.9745, 408.6565, 110.5394>, <7.8011, 412.84, 116.2272>, 0.2999 }
				cylinder { <7.8011, 412.84, 116.2272>, <8.872, 417.6852, 121.2532>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <8.872, 417.6852, 121.2532>, <9.11, 418.4753, 121.3261>, <9.3264, 419.7644, 122.4298> }
					triangle { <9.11, 418.4753, 121.3261>, <9.5572, 420.6698, 122.7535>, <9.3264, 419.7644, 122.4298> }
					triangle { <9.5572, 420.6698, 122.7535>, <9.3985, 420.4493, 123.2616>, <9.3264, 419.7644, 122.4298> }
					triangle { <9.3264, 419.7644, 122.4298>, <9.3985, 420.4493, 123.2616>, <8.872, 417.6852, 121.2532> }
					triangle { <9.5572, 420.6698, 122.7535>, <14.1705, 420.4858, 121.9605>, <15.7746, 420.3483, 123.1964> }
					triangle { <15.7746, 420.3483, 123.1964>, <16.117, 419.2298, 124.9721>, <15.3023, 419.2182, 124.7126> }
					triangle { <15.3023, 419.2182, 124.7126>, <9.5572, 420.6698, 122.7535>, <15.7746, 420.3483, 123.1964> }
					triangle { <9.5572, 420.6698, 122.7535>, <15.3023, 419.2182, 124.7126>, <9.3985, 420.4493, 123.2616> }
					triangle { <9.1533, 419.4682, 122.8829>, <8.8504, 418.031, 122.0057>, <8.872, 417.6852, 121.2532> }
					triangle { <9.1533, 419.4682, 122.8829>, <9.211, 420.0774, 123.6596>, <8.8504, 418.031, 122.0057> }
					triangle { <9.1533, 419.4682, 122.8829>, <9.3985, 420.4493, 123.2616>, <9.211, 420.0774, 123.6596> }
					triangle { <8.872, 417.6852, 121.2532>, <9.3985, 420.4493, 123.2616>, <9.1533, 419.4682, 122.8829> }
					triangle { <14.5917, 418.3243, 126.2922>, <12.6701, 417.9187, 125.8868>, <9.211, 420.0774, 123.6596> }
					triangle { <15.3023, 419.2182, 124.7126>, <16.117, 419.2298, 124.9721>, <14.5917, 418.3243, 126.2922> }
					triangle { <14.5917, 418.3243, 126.2922>, <9.211, 420.0774, 123.6596>, <15.3023, 419.2182, 124.7126> }
					triangle { <9.3985, 420.4493, 123.2616>, <15.3023, 419.2182, 124.7126>, <9.211, 420.0774, 123.6596> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <8.872, 417.6852, 121.2532>, <8.6404, 418.4436, 121.4929>, <9.01337, 419.7432, 122.541> }
					triangle { <8.6404, 418.4436, 121.4929>, <8.931, 420.6275, 122.9759>, <9.01337, 419.7432, 122.541> }
					triangle { <8.931, 420.6275, 122.9759>, <9.3985, 420.4493, 123.2616>, <9.01337, 419.7432, 122.541> }
					triangle { <9.01337, 419.7432, 122.541>, <9.3985, 420.4493, 123.2616>, <8.872, 417.6852, 121.2532> }
					triangle { <8.931, 420.6275, 122.9759>, <9.8874, 423.2813, 119.2358>, <11.4939, 424.4121, 118.7256> }
					triangle { <11.4939, 424.4121, 118.7256>, <13.5862, 424.0973, 118.9365>, <13.1104, 423.5258, 119.3586> }
					triangle { <13.1104, 423.5258, 119.3586>, <8.931, 420.6275, 122.9759>, <11.4939, 424.4121, 118.7256> }
					triangle { <8.931, 420.6275, 122.9759>, <13.1104, 423.5258, 119.3586>, <9.3985, 420.4493, 123.2616> }
					triangle { <9.4664, 419.4893, 122.7717>, <9.32, 418.0627, 121.8389>, <8.872, 417.6852, 121.2532> }
					triangle { <9.4664, 419.4893, 122.7717>, <9.8371, 420.1197, 123.4373>, <9.32, 418.0627, 121.8389> }
					triangle { <9.4664, 419.4893, 122.7717>, <9.3985, 420.4493, 123.2616>, <9.8371, 420.1197, 123.4373> }
					triangle { <8.872, 417.6852, 121.2532>, <9.3985, 420.4493, 123.2616>, <9.4664, 419.4893, 122.7717> }
					triangle { <14.5897, 422.677, 120.3021>, <13.8138, 421.0806, 121.2353>, <9.8371, 420.1197, 123.4373> }
					triangle { <13.1104, 423.5258, 119.3586>, <13.5862, 424.0973, 118.9365>, <14.5897, 422.677, 120.3021> }
					triangle { <14.5897, 422.677, 120.3021>, <9.8371, 420.1197, 123.4373>, <13.1104, 423.5258, 119.3586> }
					triangle { <9.3985, 420.4493, 123.2616>, <13.1104, 423.5258, 119.3586>, <9.8371, 420.1197, 123.4373> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <8.872, 417.6852, 121.2532>, <8.6372, 418.1505, 121.8971>, <9.01122, 419.5478, 122.8105> }
					triangle { <8.6372, 418.1505, 121.8971>, <8.9267, 420.2367, 123.5149>, <9.01122, 419.5478, 122.8105> }
					triangle { <8.9267, 420.2367, 123.5149>, <9.3985, 420.4493, 123.2616>, <9.01122, 419.5478, 122.8105> }
					triangle { <9.01122, 419.5478, 122.8105>, <9.3985, 420.4493, 123.2616>, <8.872, 417.6852, 121.2532> }
					triangle { <8.9267, 420.2367, 123.5149>, <4.9333, 422.1895, 122.0371>, <4.5152, 423.972, 121.1608> }
					triangle { <4.5152, 423.972, 121.1608>, <5.5251, 425.1008, 119.6685>, <5.9818, 424.4421, 119.9662> }
					triangle { <5.9818, 424.4421, 119.9662>, <8.9267, 420.2367, 123.5149>, <4.5152, 423.972, 121.1608> }
					triangle { <8.9267, 420.2367, 123.5149>, <5.9818, 424.4421, 119.9662>, <9.3985, 420.4493, 123.2616> }
					triangle { <9.4685, 419.6847, 122.5022>, <9.3232, 418.3558, 121.4347>, <8.872, 417.6852, 121.2532> }
					triangle { <9.4685, 419.6847, 122.5022>, <9.8414, 420.5105, 122.8983>, <9.3232, 418.3558, 121.4347> }
					triangle { <9.4685, 419.6847, 122.5022>, <9.3985, 420.4493, 123.2616>, <9.8414, 420.5105, 122.8983> }
					triangle { <8.872, 417.6852, 121.2532>, <9.3985, 420.4493, 123.2616>, <9.4685, 419.6847, 122.5022> }
					triangle { <7.6403, 424.9074, 119.0541>, <8.8969, 423.3759, 119.3652>, <9.8414, 420.5105, 122.8983> }
					triangle { <5.9818, 424.4421, 119.9662>, <5.5251, 425.1008, 119.6685>, <7.6403, 424.9074, 119.0541> }
					triangle { <7.6403, 424.9074, 119.0541>, <9.8414, 420.5105, 122.8983>, <5.9818, 424.4421, 119.9662> }
					triangle { <9.3985, 420.4493, 123.2616>, <5.9818, 424.4421, 119.9662>, <9.8414, 420.5105, 122.8983> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <8.872, 417.6852, 121.2532>, <9.1048, 417.9983, 121.984>, <9.3229, 419.4464, 122.8684> }
					triangle { <9.1048, 417.9983, 121.984>, <9.5502, 420.0338, 123.6307>, <9.3229, 419.4464, 122.8684> }
					triangle { <9.5502, 420.0338, 123.6307>, <9.3985, 420.4493, 123.2616>, <9.3229, 419.4464, 122.8684> }
					triangle { <9.3229, 419.4464, 122.8684>, <9.3985, 420.4493, 123.2616>, <8.872, 417.6852, 121.2532> }
					triangle { <9.5502, 420.0338, 123.6307>, <6.1083, 418.7091, 126.5192>, <4.4177, 419.632, 127.1594> }
					triangle { <4.4177, 419.632, 127.1594>, <2.9986, 420.863, 126.1633>, <3.7015, 420.7094, 125.7014> }
					triangle { <3.7015, 420.7094, 125.7014>, <9.5502, 420.0338, 123.6307>, <4.4177, 419.632, 127.1594> }
					triangle { <9.5502, 420.0338, 123.6307>, <3.7015, 420.7094, 125.7014>, <9.3985, 420.4493, 123.2616> }
					triangle { <9.1568, 419.7862, 122.4443>, <8.8556, 418.508, 121.3478>, <8.872, 417.6852, 121.2532> }
					triangle { <9.1568, 419.7862, 122.4443>, <9.218, 420.7134, 122.7825>, <8.8556, 418.508, 121.3478> }
					triangle { <9.1568, 419.7862, 122.4443>, <9.3985, 420.4493, 123.2616>, <9.218, 420.7134, 122.7825> }
					triangle { <8.872, 417.6852, 121.2532>, <9.3985, 420.4493, 123.2616>, <9.1568, 419.7862, 122.4443> }
					triangle { <3.2825, 421.954, 124.2612>, <4.6685, 421.6541, 122.8434>, <9.218, 420.7134, 122.7825> }
					triangle { <3.7015, 420.7094, 125.7014>, <2.9986, 420.863, 126.1633>, <3.2825, 421.954, 124.2612> }
					triangle { <3.2825, 421.954, 124.2612>, <9.218, 420.7134, 122.7825>, <3.7015, 420.7094, 125.7014> }
					triangle { <9.3985, 420.4493, 123.2616>, <3.7015, 420.7094, 125.7014>, <9.218, 420.7134, 122.7825> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <8.872, 417.6852, 121.2532>, <9.4014, 418.2021, 121.6258>, <9.5207, 419.5822, 122.6296> }
					triangle { <9.4014, 418.2021, 121.6258>, <9.9457, 420.3055, 123.1531>, <9.5207, 419.5822, 122.6296> }
					triangle { <9.9457, 420.3055, 123.1531>, <9.3985, 420.4493, 123.2616>, <9.5207, 419.5822, 122.6296> }
					triangle { <9.5207, 419.5822, 122.6296>, <9.3985, 420.4493, 123.2616>, <8.872, 417.6852, 121.2532> }
					triangle { <9.9457, 420.3055, 123.1531>, <11.9033, 417.6402, 126.4711>, <11.4815, 417.3587, 128.4364> }
					triangle { <11.4815, 417.3587, 128.4364>, <9.6435, 417.1797, 129.4906>, <9.5489, 417.432, 128.6791> }
					triangle { <9.5489, 417.432, 128.6791>, <9.9457, 420.3055, 123.1531>, <11.4815, 417.3587, 128.4364> }
					triangle { <9.9457, 420.3055, 123.1531>, <9.5489, 417.432, 128.6791>, <9.3985, 420.4493, 123.2616> }
					triangle { <8.959, 419.6503, 122.6831>, <8.559, 418.3042, 121.706>, <8.872, 417.6852, 121.2532> }
					triangle { <8.959, 419.6503, 122.6831>, <8.8224, 420.4417, 123.2601>, <8.559, 418.3042, 121.706> }
					triangle { <8.959, 419.6503, 122.6831>, <9.3985, 420.4493, 123.2616>, <8.8224, 420.4417, 123.2601> }
					triangle { <8.872, 417.6852, 121.2532>, <9.3985, 420.4493, 123.2616>, <8.959, 419.6503, 122.6831> }
					triangle { <7.6435, 417.824, 128.8021>, <7.03575, 418.2304, 126.9349>, <8.8224, 420.4417, 123.2601> }
					triangle { <9.5489, 417.432, 128.6791>, <9.6435, 417.1797, 129.4906>, <7.6435, 417.824, 128.8021> }
					triangle { <7.6435, 417.824, 128.8021>, <8.8224, 420.4417, 123.2601>, <9.5489, 417.432, 128.6791> }
					triangle { <9.3985, 420.4493, 123.2616>, <9.5489, 417.432, 128.6791>, <8.8224, 420.4417, 123.2601> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <9.3839, 405.3378, 104.4663>, <8.6387, 406.2192, 106.5182>, 0.2999 }
			cylinder { <8.6387, 406.2192, 106.5182>, <8.01104, 407.2134, 108.5578>, 0.2999 }
			cylinder { <8.01104, 407.2134, 108.5578>, <7.5039, 408.3156, 110.5754>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.5039, 408.3156, 110.5754>, <4.5141, 411.498, 116.1266>, 0.2999 }
				cylinder { <4.5141, 411.498, 116.1266>, <0.2008, 414.4016, 120.9065>, 0.2999 }
				cylinder { <0.2008, 414.4016, 120.9065>, <-5.2263, 416.8853, 124.6828>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-5.2263, 416.8853, 124.6828>, <-6.01349, 417.008, 124.9099>, <-7.03569, 417.9029, 125.9495> }
					triangle { <-6.01349, 417.008, 124.9099>, <-7.8738, 418.213, 126.3729>, <-7.03569, 417.9029, 125.9495> }
					triangle { <-7.8738, 418.213, 126.3729>, <-7.5135, 418.5516, 126.6687>, <-7.03569, 417.9029, 125.9495> }
					triangle { <-7.03569, 417.9029, 125.9495>, <-7.5135, 418.5516, 126.6687>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-7.8738, 418.213, 126.3729>, <-9.7714, 420.2772, 122.6203>, <-10.07277, 422.2224, 122.1251> }
					triangle { <-10.07277, 422.2224, 122.1251>, <-8.8749, 423.9613, 122.3755>, <-8.578, 423.2784, 122.7957> }
					triangle { <-8.578, 423.2784, 122.7957>, <-7.8738, 418.213, 126.3729>, <-10.07277, 422.2224, 122.1251> }
					triangle { <-7.8738, 418.213, 126.3729>, <-8.578, 423.2784, 122.7957>, <-7.5135, 418.5516, 126.6687> }
					triangle { <-6.6127, 418.1959, 126.1908>, <-5.379, 417.4474, 125.2718>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-6.6127, 418.1959, 126.1908>, <-7.0279, 418.7989, 126.8556>, <-5.379, 417.4474, 125.2718> }
					triangle { <-6.6127, 418.1959, 126.1908>, <-7.5135, 418.5516, 126.6687>, <-7.0279, 418.7989, 126.8556> }
					triangle { <-5.2263, 416.8853, 124.6828>, <-7.5135, 418.5516, 126.6687>, <-6.6127, 418.1959, 126.1908> }
					triangle { <-7.1826, 424.2244, 123.774>, <-6.1059, 422.8163, 124.7116>, <-7.0279, 418.7989, 126.8556> }
					triangle { <-8.578, 423.2784, 122.7957>, <-8.8749, 423.9613, 122.3755>, <-7.1826, 424.2244, 123.774> }
					triangle { <-7.1826, 424.2244, 123.774>, <-7.0279, 418.7989, 126.8556>, <-8.578, 423.2784, 122.7957> }
					triangle { <-7.5135, 418.5516, 126.6687>, <-8.578, 423.2784, 122.7957>, <-7.0279, 418.7989, 126.8556> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-5.2263, 416.8853, 124.6828>, <-5.7587, 416.8721, 125.3173>, <-6.8658, 417.8123, 126.2211> }
					triangle { <-5.7587, 416.8721, 125.3173>, <-7.5341, 418.0317, 126.9162>, <-6.8658, 417.8123, 126.2211> }
					triangle { <-7.5341, 418.0317, 126.9162>, <-7.5135, 418.5516, 126.6687>, <-6.8658, 417.8123, 126.2211> }
					triangle { <-6.8658, 417.8123, 126.2211>, <-7.5135, 418.5516, 126.6687>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-7.5341, 418.0317, 126.9162>, <-11.01578, 415.318, 125.348>, <-12.785, 415.7347, 124.4447> }
					triangle { <-12.785, 415.7347, 124.4447>, <-13.3291, 417.1535, 122.9573>, <-12.5421, 417.2713, 123.2702> }
					triangle { <-12.5421, 417.2713, 123.2702>, <-7.5341, 418.0317, 126.9162>, <-12.785, 415.7347, 124.4447> }
					triangle { <-7.5341, 418.0317, 126.9162>, <-12.5421, 417.2713, 123.2702>, <-7.5135, 418.5516, 126.6687> }
					triangle { <-6.7825, 418.2865, 125.9192>, <-5.6338, 417.5834, 124.8644>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-6.7825, 418.2865, 125.9192>, <-7.3675, 418.9801, 126.3123>, <-5.6338, 417.5834, 124.8644> }
					triangle { <-6.7825, 418.2865, 125.9192>, <-7.5135, 418.5516, 126.6687>, <-7.3675, 418.9801, 126.3123> }
					triangle { <-5.2263, 416.8853, 124.6828>, <-7.5135, 418.5516, 126.6687>, <-6.7825, 418.2865, 125.9192> }
					triangle { <-12.2157, 418.975, 122.3816>, <-10.2937, 419.4277, 122.7314>, <-7.3675, 418.9801, 126.3123> }
					triangle { <-12.5421, 417.2713, 123.2702>, <-13.3291, 417.1535, 122.9573>, <-12.2157, 418.975, 122.3816> }
					triangle { <-12.2157, 418.975, 122.3816>, <-7.3675, 418.9801, 126.3123>, <-12.5421, 417.2713, 123.2702> }
					triangle { <-7.5135, 418.5516, 126.6687>, <-12.5421, 417.2713, 123.2702>, <-7.3675, 418.9801, 126.3123> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-5.2263, 416.8853, 124.6828>, <-5.4182, 417.2243, 125.4139>, <-6.6388, 418.0471, 126.2855> }
					triangle { <-5.4182, 417.2243, 125.4139>, <-7.08017, 418.5014, 127.045>, <-6.6388, 418.0471, 126.2855> }
					triangle { <-7.08017, 418.5014, 127.045>, <-7.5135, 418.5516, 126.6687>, <-6.6388, 418.0471, 126.2855> }
					triangle { <-6.6388, 418.0471, 126.2855>, <-7.5135, 418.5516, 126.6687>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-7.08017, 418.5014, 127.045>, <-7.4527, 414.7973, 129.8885>, <-9.03552, 413.6775, 130.4891> }
					triangle { <-9.03552, 413.6775, 130.4891>, <-10.7467, 412.954, 129.455>, <-10.2919, 413.5228, 129.007> }
					triangle { <-10.2919, 413.5228, 129.007>, <-7.08017, 418.5014, 127.045>, <-9.03552, 413.6775, 130.4891> }
					triangle { <-7.08017, 418.5014, 127.045>, <-10.2919, 413.5228, 129.007>, <-7.5135, 418.5516, 126.6687> }
					triangle { <-7.009565, 418.0517, 125.8548>, <-5.9742, 417.2311, 124.7678>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-7.009565, 418.0517, 125.8548>, <-7.8215, 418.5104, 126.1835>, <-5.9742, 417.2311, 124.7678> }
					triangle { <-7.009565, 418.0517, 125.8548>, <-7.5135, 418.5516, 126.6687>, <-7.8215, 418.5104, 126.1835> }
					triangle { <-5.2263, 416.8853, 124.6828>, <-7.5135, 418.5516, 126.6687>, <-7.009565, 418.0517, 125.8548> }
					triangle { <-11.5685, 413.7084, 127.5459>, <-10.6653, 414.8365, 126.1556>, <-7.8215, 418.5104, 126.1835> }
					triangle { <-10.2919, 413.5228, 129.007>, <-10.7467, 412.954, 129.455>, <-11.5685, 413.7084, 127.5459> }
					triangle { <-11.5685, 413.7084, 127.5459>, <-7.8215, 418.5104, 126.1835>, <-10.2919, 413.5228, 129.007> }
					triangle { <-7.5135, 418.5516, 126.6687>, <-10.2919, 413.5228, 129.007>, <-7.8215, 418.5104, 126.1835> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-5.2263, 416.8853, 124.6828>, <-5.4593, 417.5812, 125.0671>, <-6.6662, 418.2851, 126.0543> }
					triangle { <-5.4593, 417.5812, 125.0671>, <-7.1349, 418.9773, 126.5826>, <-6.6662, 418.2851, 126.0543> }
					triangle { <-7.1349, 418.9773, 126.5826>, <-7.5135, 418.5516, 126.6687>, <-6.6662, 418.2851, 126.0543> }
					triangle { <-6.6662, 418.2851, 126.0543>, <-7.5135, 418.5516, 126.6687>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-7.1349, 418.9773, 126.5826>, <-3.9731, 419.4298, 130.0093>, <-3.971, 418.8745, 131.9616> }
					triangle { <-3.971, 418.8745, 131.9616>, <-4.6724, 417.1272, 132.9496>, <-4.916, 417.1783, 132.1315> }
					triangle { <-4.916, 417.1783, 132.1315>, <-7.1349, 418.9773, 126.5826>, <-3.971, 418.8745, 131.9616> }
					triangle { <-7.1349, 418.9773, 126.5826>, <-4.916, 417.1783, 132.1315>, <-7.5135, 418.5516, 126.6687> }
					triangle { <-6.9821, 417.8137, 126.086>, <-5.9331, 416.8742, 125.1146>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-6.9821, 417.8137, 126.086>, <-7.7667, 418.0345, 126.646>, <-5.9331, 416.8742, 125.1146> }
					triangle { <-6.9821, 417.8137, 126.086>, <-7.5135, 418.5516, 126.6687>, <-7.7667, 418.0345, 126.646> }
					triangle { <-5.2263, 416.8853, 124.6828>, <-7.5135, 418.5516, 126.6687>, <-6.9821, 417.8137, 126.086> }
					triangle { <-6.1294, 415.6536, 132.1782>, <-6.7106, 415.3447, 130.284>, <-7.7667, 418.0345, 126.646> }
					triangle { <-4.916, 417.1783, 132.1315>, <-4.6724, 417.1272, 132.9496>, <-6.1294, 415.6536, 132.1782> }
					triangle { <-6.1294, 415.6536, 132.1782>, <-7.7667, 418.0345, 126.646>, <-4.916, 417.1783, 132.1315> }
					triangle { <-7.5135, 418.5516, 126.6687>, <-4.916, 417.1783, 132.1315>, <-7.7667, 418.0345, 126.646> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-5.2263, 416.8853, 124.6828>, <-5.8328, 417.4455, 124.7509>, <-6.9152, 418.1946, 125.8435> }
					triangle { <-5.8328, 417.4455, 124.7509>, <-7.6328, 418.7963, 126.1609>, <-6.9152, 418.1946, 125.8435> }
					triangle { <-7.6328, 418.7963, 126.1609>, <-7.5135, 418.5516, 126.6687>, <-6.9152, 418.1946, 125.8435> }
					triangle { <-6.9152, 418.1946, 125.8435>, <-7.5135, 418.5516, 126.6687>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-7.6328, 418.7963, 126.1609>, <-5.4278, 422.8677, 125.4495>, <-4.6217, 424.2353, 126.7143> }
					triangle { <-4.6217, 424.2353, 126.7143>, <-3.4981, 424.0327, 128.5081>, <-3.8408, 423.2986, 128.2348> }
					triangle { <-3.8408, 423.2986, 128.2348>, <-7.6328, 418.7963, 126.1609>, <-4.6217, 424.2353, 126.7143> }
					triangle { <-7.6328, 418.7963, 126.1609>, <-3.8408, 423.2986, 128.2348>, <-7.5135, 418.5516, 126.6687> }
					triangle { <-6.7332, 417.9042, 126.2968>, <-5.5597, 417.0099, 125.4308>, <-5.2263, 416.8853, 124.6828> }
					triangle { <-6.7332, 417.9042, 126.2968>, <-7.2688, 418.2155, 127.0676>, <-5.5597, 417.0099, 125.4308> }
					triangle { <-6.7332, 417.9042, 126.2968>, <-7.5135, 418.5516, 126.6687>, <-7.2688, 418.2155, 127.0676> }
					triangle { <-5.2263, 416.8853, 124.6828>, <-7.5135, 418.5516, 126.6687>, <-6.7332, 417.9042, 126.2968> }
					triangle { <-3.3778, 422.2509, 129.8119>, <-3.8501, 420.351, 129.3781>, <-7.2688, 418.2155, 127.0676> }
					triangle { <-3.8408, 423.2986, 128.2348>, <-3.4981, 424.0327, 128.5081>, <-3.3778, 422.2509, 129.8119> }
					triangle { <-3.3778, 422.2509, 129.8119>, <-7.2688, 418.2155, 127.0676>, <-3.8408, 423.2986, 128.2348> }
					triangle { <-7.5135, 418.5516, 126.6687>, <-3.8408, 423.2986, 128.2348>, <-7.2688, 418.2155, 127.0676> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <7.5039, 408.3156, 110.5754>, <6.8388, 409.4035, 112.5545>, 0.2999 }
			cylinder { <6.8388, 409.4035, 112.5545>, <6.01876, 410.4721, 114.4853>, 0.2999 }
			cylinder { <6.01876, 410.4721, 114.4853>, <5.04775, 411.5164, 116.3586>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.04775, 411.5164, 116.3586>, <3.1592, 413.7881, 122.7738>, 0.2999 }
				cylinder { <3.1592, 413.7881, 122.7738>, <2.3869, 415.0882, 129.6728>, 0.2999 }
				cylinder { <2.3869, 415.0882, 129.6728>, <2.7684, 415.3534, 136.7203>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <2.7684, 415.3534, 136.7203>, <3.162, 415.2462, 137.4413>, <3.001012, 415.355, 139.141> }
					triangle { <3.162, 415.2462, 137.4413>, <3.256, 415.3014, 140.0949>, <3.001012, 415.355, 139.141> }
					triangle { <3.256, 415.3014, 140.0949>, <2.7153, 415.4836, 140.1745>, <3.001012, 415.355, 139.141> }
					triangle { <3.001012, 415.355, 139.141>, <2.7153, 415.4836, 140.1745>, <2.7684, 415.3534, 136.7203> }
					triangle { <3.256, 415.3014, 140.0949>, <3.7538, 410.6517, 140.3727>, <2.6493, 409.2004, 141.2635> }
					triangle { <2.6493, 409.2004, 141.2635>, <0.5503, 408.9047, 141.432>, <0.7635, 409.6726, 141.122> }
					triangle { <0.7635, 409.6726, 141.122>, <3.256, 415.3014, 140.0949>, <2.6493, 409.2004, 141.2635> }
					triangle { <3.256, 415.3014, 140.0949>, <0.7635, 409.6726, 141.122>, <2.7153, 415.4836, 140.1745> }
					triangle { <2.4617, 415.5337, 139.126>, <2.3531, 415.5142, 137.4188>, <2.7684, 415.3534, 136.7203> }
					triangle { <2.4617, 415.5337, 139.126>, <2.1775, 415.6588, 140.0649>, <2.3531, 415.5142, 137.4188> }
					triangle { <2.4617, 415.5337, 139.126>, <2.7153, 415.4836, 140.1745>, <2.1775, 415.6588, 140.0649> }
					triangle { <2.7684, 415.3534, 136.7203>, <2.7153, 415.4836, 140.1745>, <2.4617, 415.5337, 139.126> }
					triangle { <-1.03561, 410.4214, 141.1609>, <-0.9196, 412.2002, 140.2424>, <2.1775, 415.6588, 140.0649> }
					triangle { <0.7635, 409.6726, 141.122>, <0.5503, 408.9047, 141.432>, <-1.03561, 410.4214, 141.1609> }
					triangle { <-1.03561, 410.4214, 141.1609>, <2.1775, 415.6588, 140.0649>, <0.7635, 409.6726, 141.122> }
					triangle { <2.7153, 415.4836, 140.1745>, <0.7635, 409.6726, 141.122>, <2.1775, 415.6588, 140.0649> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <2.7684, 415.3534, 136.7203>, <3.01198, 415.722, 137.4211>, <2.9009, 415.6723, 139.1275> }
					triangle { <3.01198, 415.722, 137.4211>, <3.05604, 415.9359, 140.0679>, <2.9009, 415.6723, 139.1275> }
					triangle { <3.05604, 415.9359, 140.0679>, <2.7153, 415.4836, 140.1745>, <2.9009, 415.6723, 139.1275> }
					triangle { <2.9009, 415.6723, 139.1275>, <2.7153, 415.4836, 140.1745>, <2.7684, 415.3534, 136.7203> }
					triangle { <3.05604, 415.9359, 140.0679>, <7.6325, 414.9561, 140.27>, <8.6857, 413.4879, 141.1947> }
					triangle { <8.6857, 413.4879, 141.1947>, <8.3119, 411.4112, 141.4568>, <7.6422, 411.8424, 141.1459> }
					triangle { <7.6422, 411.8424, 141.1459>, <3.05604, 415.9359, 140.0679>, <8.6857, 413.4879, 141.1947> }
					triangle { <3.05604, 415.9359, 140.0679>, <7.6422, 411.8424, 141.1459>, <2.7153, 415.4836, 140.1745> }
					triangle { <2.5617, 415.2165, 139.1395>, <2.5031, 415.0383, 137.4391>, <2.7684, 415.3534, 136.7203> }
					triangle { <2.5617, 415.2165, 139.1395>, <2.3776, 415.0243, 140.0919>, <2.5031, 415.0383, 137.4391> }
					triangle { <2.5617, 415.2165, 139.1395>, <2.7153, 415.4836, 140.1745>, <2.3776, 415.0243, 140.0919> }
					triangle { <2.7684, 415.3534, 136.7203>, <2.7153, 415.4836, 140.1745>, <2.5617, 415.2165, 139.1395> }
					triangle { <6.3678, 410.3734, 141.2765>, <4.6926, 411.0059, 140.3737>, <2.3776, 415.0243, 140.0919> }
					triangle { <7.6422, 411.8424, 141.1459>, <8.3119, 411.4112, 141.4568>, <6.3678, 410.3734, 141.2765> }
					triangle { <6.3678, 410.3734, 141.2765>, <2.3776, 415.0243, 140.0919>, <7.6422, 411.8424, 141.1459> }
					triangle { <2.7153, 415.4836, 140.1745>, <7.6422, 411.8424, 141.1459>, <2.3776, 415.0243, 140.0919> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <2.7684, 415.3534, 136.7203>, <2.5127, 415.7286, 137.4132>, <2.5681, 415.6767, 139.1223> }
					triangle { <2.5127, 415.7286, 137.4132>, <2.3903, 415.9447, 140.0573>, <2.5681, 415.6767, 139.1223> }
					triangle { <2.3903, 415.9447, 140.0573>, <2.7153, 415.4836, 140.1745>, <2.5681, 415.6767, 139.1223> }
					triangle { <2.5681, 415.6767, 139.1223>, <2.7153, 415.4836, 140.1745>, <2.7684, 415.3534, 136.7203> }
					triangle { <2.3903, 415.9447, 140.0573>, <4.7617, 419.9846, 140.0363>, <6.509, 420.5589, 140.8946> }
					triangle { <6.509, 420.5589, 140.8946>, <8.3694, 419.5615, 141.1504>, <7.7421, 419.0495, 140.8757> }
					triangle { <7.7421, 419.0495, 140.8757>, <2.3903, 415.9447, 140.0573>, <6.509, 420.5589, 140.8946> }
					triangle { <2.3903, 415.9447, 140.0573>, <7.7421, 419.0495, 140.8757>, <2.7153, 415.4836, 140.1745> }
					triangle { <2.8946, 415.2121, 139.1448>, <3.002407, 415.0317, 137.447>, <2.7684, 415.3534, 136.7203> }
					triangle { <2.8946, 415.2121, 139.1448>, <3.04328, 415.0154, 140.1024>, <3.002407, 415.0317, 137.447> }
					triangle { <2.8946, 415.2121, 139.1448>, <2.7153, 415.4836, 140.1745>, <3.04328, 415.0154, 140.1024> }
					triangle { <2.7684, 415.3534, 136.7203>, <2.7153, 415.4836, 140.1745>, <2.8946, 415.2121, 139.1448> }
					triangle { <8.7398, 417.384, 141.0486>, <7.5909, 415.9579, 140.2316>, <3.04328, 415.0154, 140.1024> }
					triangle { <7.7421, 419.0495, 140.8757>, <8.3694, 419.5615, 141.1504>, <8.7398, 417.384, 141.0486> }
					triangle { <8.7398, 417.384, 141.0486>, <3.04328, 415.0154, 140.1024>, <7.7421, 419.0495, 140.8757> }
					triangle { <2.7153, 415.4836, 140.1745>, <7.7421, 419.0495, 140.8757>, <3.04328, 415.0154, 140.1024> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <2.7684, 415.3534, 136.7203>, <2.3495, 415.2569, 137.4285>, <2.4593, 415.3622, 139.1324> }
					triangle { <2.3495, 415.2569, 137.4285>, <2.1728, 415.3158, 140.0777>, <2.4593, 415.3622, 139.1324> }
					triangle { <2.1728, 415.3158, 140.0777>, <2.7153, 415.4836, 140.1745>, <2.4593, 415.3622, 139.1324> }
					triangle { <2.4593, 415.3622, 139.1324>, <2.7153, 415.4836, 140.1745>, <2.7684, 415.3534, 136.7203> }
					triangle { <2.1728, 415.3158, 140.0777>, <-0.9179, 418.835, 139.9923>, <-0.8929, 420.7075, 140.7752> }
					triangle { <-0.8929, 420.7075, 140.7752>, <0.644, 422.1682, 140.9334>, <0.9261, 421.4012, 140.6822> }
					triangle { <0.9261, 421.4012, 140.6822>, <2.1728, 415.3158, 140.0777>, <-0.8929, 420.7075, 140.7752> }
					triangle { <2.1728, 415.3158, 140.0777>, <0.9261, 421.4012, 140.6822>, <2.7153, 415.4836, 140.1745> }
					triangle { <3.003391, 415.5265, 139.1346>, <3.1655, 415.5034, 137.4317>, <2.7684, 415.3534, 136.7203> }
					triangle { <3.003391, 415.5265, 139.1346>, <3.2608, 415.6444, 140.082>, <3.1655, 415.5034, 137.4317> }
					triangle { <3.003391, 415.5265, 139.1346>, <2.7153, 415.4836, 140.1745>, <3.2608, 415.6444, 140.082> }
					triangle { <2.7684, 415.3534, 136.7203>, <2.7153, 415.4836, 140.1745>, <3.003391, 415.5265, 139.1346> }
					triangle { <2.8244, 421.8302, 140.79>, <3.7968, 420.2589, 140.0111>, <3.2608, 415.6444, 140.082> }
					triangle { <0.9261, 421.4012, 140.6822>, <0.644, 422.1682, 140.9334>, <2.8244, 421.8302, 140.79> }
					triangle { <2.8244, 421.8302, 140.79>, <3.2608, 415.6444, 140.082>, <0.9261, 421.4012, 140.6822> }
					triangle { <2.7153, 415.4836, 140.1745>, <0.9261, 421.4012, 140.6822>, <3.2608, 415.6444, 140.082> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <2.7684, 415.3534, 136.7203>, <2.7568, 414.9543, 137.4461>, <2.7309, 415.1604, 139.1442> }
					triangle { <2.7568, 414.9543, 137.4461>, <2.7159, 414.9122, 140.1013>, <2.7309, 415.1604, 139.1442> }
					triangle { <2.7159, 414.9122, 140.1013>, <2.7153, 415.4836, 140.1745>, <2.7309, 415.1604, 139.1442> }
					triangle { <2.7309, 415.1604, 139.1442>, <2.7153, 415.4836, 140.1745>, <2.7684, 415.3534, 136.7203> }
					triangle { <2.7159, 414.9122, 140.1013>, <-1.5502, 412.9798, 140.2034>, <-3.3144, 413.5815, 141.0067> }
					triangle { <-3.3144, 413.5815, 141.0067>, <-4.2613, 415.4826, 141.11>, <-3.4519, 415.5184, 140.8367> }
					triangle { <-3.4519, 415.5184, 140.8367>, <2.7159, 414.9122, 140.1013>, <-3.3144, 413.5815, 141.0067> }
					triangle { <2.7159, 414.9122, 140.1013>, <-3.4519, 415.5184, 140.8367>, <2.7153, 415.4836, 140.1745> }
					triangle { <2.7318, 415.7283, 139.1228>, <2.7582, 415.8061, 137.414>, <2.7684, 415.3534, 136.7203> }
					triangle { <2.7318, 415.7283, 139.1228>, <2.7177, 416.0479, 140.0585>, <2.7582, 415.8061, 137.414> }
					triangle { <2.7318, 415.7283, 139.1228>, <2.7153, 415.4836, 140.1745>, <2.7177, 416.0479, 140.0585> }
					triangle { <2.7684, 415.3534, 136.7203>, <2.7153, 415.4836, 140.1745>, <2.7318, 415.7283, 139.1228> }
					triangle { <-3.3082, 417.4621, 140.8605>, <-1.5424, 417.9014, 140.0179>, <2.7177, 416.0479, 140.0585> }
					triangle { <-3.4519, 415.5184, 140.8367>, <-4.2613, 415.4826, 141.11>, <-3.3082, 417.4621, 140.8605> }
					triangle { <-3.3082, 417.4621, 140.8605>, <2.7177, 416.0479, 140.0585>, <-3.4519, 415.5184, 140.8367> }
					triangle { <2.7153, 415.4836, 140.1745>, <-3.4519, 415.5184, 140.8367>, <2.7177, 416.0479, 140.0585> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <5.04775, 411.5164, 116.3586>, <4.1849, 412.4814, 118.325>, 0.2999 }
			cylinder { <4.1849, 412.4814, 118.325>, <3.4342, 413.362, 120.3752>, 0.2999 }
			cylinder { <3.4342, 413.362, 120.3752>, <2.7992, 414.1541, 122.4994>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.7992, 414.1541, 122.4994>, <0.8582, 417.9124, 128.1554>, 0.2999 }
				cylinder { <0.8582, 417.9124, 128.1554>, <-1.02429, 422.8699, 132.8204>, 0.2999 }
				cylinder { <-1.02429, 422.8699, 132.8204>, <-2.7569, 428.7858, 136.2675>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-2.7569, 428.7858, 136.2675>, <-2.9872, 429.5774, 136.3493>, <-3.2447, 430.8395, 137.4751> }
					triangle { <-2.9872, 429.5774, 136.3493>, <-3.4797, 431.7394, 137.8109>, <-3.2447, 430.8395, 137.4751> }
					triangle { <-3.4797, 431.7394, 137.8109>, <-3.3521, 431.5028, 138.3205>, <-3.2447, 430.8395, 137.4751> }
					triangle { <-3.2447, 430.8395, 137.4751>, <-3.3521, 431.5028, 138.3205>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-3.4797, 431.7394, 137.8109>, <0.06957, 434.1028, 135.8715>, <1.7347, 434.9659, 136.6473> }
					triangle { <1.7347, 434.9659, 136.6473>, <3.08354, 434.3506, 138.1716>, <2.378, 433.8698, 138.1251> }
					triangle { <2.378, 433.8698, 138.1251>, <-3.4797, 431.7394, 137.8109>, <1.7347, 434.9659, 136.6473> }
					triangle { <-3.4797, 431.7394, 137.8109>, <2.378, 433.8698, 138.1251>, <-3.3521, 431.5028, 138.3205> }
					triangle { <-3.1008, 430.5285, 137.9284>, <-2.7713, 429.1108, 137.0293>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-3.1008, 430.5285, 137.9284>, <-3.1919, 431.1174, 138.7175>, <-2.7713, 429.1108, 137.0293> }
					triangle { <-3.1008, 430.5285, 137.9284>, <-3.3521, 431.5028, 138.3205>, <-3.1919, 431.1174, 138.7175> }
					triangle { <-2.7569, 428.7858, 136.2675>, <-3.3521, 431.5028, 138.3205>, <-3.1008, 430.5285, 137.9284> }
					triangle { <2.7182, 432.8407, 139.7451>, <1.3168, 431.4074, 139.8003>, <-3.1919, 431.1174, 138.7175> }
					triangle { <2.378, 433.8698, 138.1251>, <3.08354, 434.3506, 138.1716>, <2.7182, 432.8407, 139.7451> }
					triangle { <2.7182, 432.8407, 139.7451>, <-3.1919, 431.1174, 138.7175>, <2.378, 433.8698, 138.1251> }
					triangle { <-3.3521, 431.5028, 138.3205>, <2.378, 433.8698, 138.1251>, <-3.1919, 431.1174, 138.7175> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-2.7569, 428.7858, 136.2675>, <-3.2984, 429.3008, 136.6251>, <-3.4522, 430.6552, 137.6589> }
					triangle { <-3.2984, 429.3008, 136.6251>, <-3.8946, 431.3707, 138.1786>, <-3.4522, 430.6552, 137.6589> }
					triangle { <-3.8946, 431.3707, 138.1786>, <-3.3521, 431.5028, 138.3205>, <-3.4522, 430.6552, 137.6589> }
					triangle { <-3.4522, 430.6552, 137.6589>, <-3.3521, 431.5028, 138.3205>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-3.8946, 431.3707, 138.1786>, <-5.5725, 433.8475, 134.5737>, <-5.05856, 435.6439, 133.7807> }
					triangle { <-5.05856, 435.6439, 133.7807>, <-3.1733, 436.5628, 133.4301>, <-3.1246, 435.8532, 133.9048> }
					triangle { <-3.1246, 435.8532, 133.9048>, <-3.8946, 431.3707, 138.1786>, <-5.05856, 435.6439, 133.7807> }
					triangle { <-3.8946, 431.3707, 138.1786>, <-3.1246, 435.8532, 133.9048>, <-3.3521, 431.5028, 138.3205> }
					triangle { <-2.8933, 430.7129, 137.7446>, <-2.4601, 429.3874, 136.7535>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-2.8933, 430.7129, 137.7446>, <-2.777, 431.4861, 138.3499>, <-2.4601, 429.3874, 136.7535> }
					triangle { <-2.8933, 430.7129, 137.7446>, <-3.3521, 431.5028, 138.3205>, <-2.777, 431.4861, 138.3499> }
					triangle { <-2.7569, 428.7858, 136.2675>, <-3.3521, 431.5028, 138.3205>, <-2.8933, 430.7129, 137.7446> }
					triangle { <-1.2399, 436.0382, 134.3659>, <-0.7293, 434.3476, 135.3159>, <-2.777, 431.4861, 138.3499> }
					triangle { <-3.1246, 435.8532, 133.9048>, <-3.1733, 436.5628, 133.4301>, <-1.2399, 436.0382, 134.3659> }
					triangle { <-1.2399, 436.0382, 134.3659>, <-2.777, 431.4861, 138.3499>, <-3.1246, 435.8532, 133.9048> }
					triangle { <-3.3521, 431.5028, 138.3205>, <-3.1246, 435.8532, 133.9048>, <-2.777, 431.4861, 138.3499> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-2.7569, 428.7858, 136.2675>, <-3.03428, 429.0837, 136.989>, <-3.2761, 430.5104, 137.9016> }
					triangle { <-3.03428, 429.0837, 136.989>, <-3.5425, 431.0812, 138.6638>, <-3.2761, 430.5104, 137.9016> }
					triangle { <-3.5425, 431.0812, 138.6638>, <-3.3521, 431.5028, 138.3205>, <-3.2761, 430.5104, 137.9016> }
					triangle { <-3.2761, 430.5104, 137.9016>, <-3.3521, 431.5028, 138.3205>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-3.5425, 431.0812, 138.6638>, <-8.1668, 430.3738, 138.4189>, <-9.711, 431.5573, 137.8404> }
					triangle { <-9.711, 431.5573, 137.8404>, <-9.9218, 432.9534, 136.2505>, <-9.1187, 432.6826, 136.3632> }
					triangle { <-9.1187, 432.6826, 136.3632>, <-3.5425, 431.0812, 138.6638>, <-9.711, 431.5573, 137.8404> }
					triangle { <-3.5425, 431.0812, 138.6638>, <-9.1187, 432.6826, 136.3632>, <-3.3521, 431.5028, 138.3205> }
					triangle { <-3.06945, 430.8576, 137.502>, <-2.7242, 429.6045, 136.3896>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-3.06945, 430.8576, 137.502>, <-3.1291, 431.7756, 137.8646>, <-2.7242, 429.6045, 136.3896> }
					triangle { <-3.06945, 430.8576, 137.502>, <-3.3521, 431.5028, 138.3205>, <-3.1291, 431.7756, 137.8646> }
					triangle { <-2.7569, 428.7858, 136.2675>, <-3.3521, 431.5028, 138.3205>, <-3.06945, 430.8576, 137.502> }
					triangle { <-8.2988, 433.9299, 135.1097>, <-6.3757, 433.383, 134.9556>, <-3.1291, 431.7756, 137.8646> }
					triangle { <-9.1187, 432.6826, 136.3632>, <-9.9218, 432.9534, 136.2505>, <-8.2988, 433.9299, 135.1097> }
					triangle { <-8.2988, 433.9299, 135.1097>, <-3.1291, 431.7756, 137.8646>, <-9.1187, 432.6826, 136.3632> }
					triangle { <-3.3521, 431.5028, 138.3205>, <-9.1187, 432.6826, 136.3632>, <-3.1291, 431.7756, 137.8646> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-2.7569, 428.7858, 136.2675>, <-2.5574, 429.224, 136.9416>, <-2.9582, 430.6039, 137.8699> }
					triangle { <-2.5574, 429.224, 136.9416>, <-2.9066, 431.2683, 138.6006>, <-2.9582, 430.6039, 137.8699> }
					triangle { <-2.9066, 431.2683, 138.6006>, <-3.3521, 431.5028, 138.3205>, <-2.9582, 430.6039, 137.8699> }
					triangle { <-2.9582, 430.6039, 137.8699>, <-3.3521, 431.5028, 138.3205>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-2.9066, 431.2683, 138.6006>, <-4.1523, 428.4499, 142.129>, <-5.8365, 428.3156, 143.2539> }
					triangle { <-5.8365, 428.3156, 143.2539>, <-7.8987, 428.477, 142.7615>, <-7.3764, 428.7101, 142.1259> }
					triangle { <-7.3764, 428.7101, 142.1259>, <-2.9066, 431.2683, 138.6006>, <-5.8365, 428.3156, 143.2539> }
					triangle { <-2.9066, 431.2683, 138.6006>, <-7.3764, 428.7101, 142.1259>, <-3.3521, 431.5028, 138.3205> }
					triangle { <-3.3873, 430.7641, 137.5336>, <-3.2011, 429.4642, 136.4371>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-3.3873, 430.7641, 137.5336>, <-3.765, 431.5885, 137.9279>, <-3.2011, 429.4642, 136.4371> }
					triangle { <-3.3873, 430.7641, 137.5336>, <-3.3521, 431.5028, 138.3205>, <-3.765, 431.5885, 137.9279> }
					triangle { <-2.7569, 428.7858, 136.2675>, <-3.3521, 431.5028, 138.3205>, <-3.3873, 430.7641, 137.5336> }
					triangle { <-8.7692, 429.4098, 140.9556>, <-7.8718, 429.8376, 139.2141>, <-3.765, 431.5885, 137.9279> }
					triangle { <-7.3764, 428.7101, 142.1259>, <-7.8987, 428.477, 142.7615>, <-8.7692, 429.4098, 140.9556> }
					triangle { <-8.7692, 429.4098, 140.9556>, <-3.765, 431.5885, 137.9279>, <-7.3764, 428.7101, 142.1259> }
					triangle { <-3.3521, 431.5028, 138.3205>, <-7.3764, 428.7101, 142.1259>, <-3.765, 431.5885, 137.9279> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-2.7569, 428.7858, 136.2675>, <-2.5278, 429.5337, 136.5402>, <-2.9385, 430.8104, 137.6024> }
					triangle { <-2.5278, 429.5337, 136.5402>, <-2.8673, 431.6812, 138.0654>, <-2.9385, 430.8104, 137.6024> }
					triangle { <-2.8673, 431.6812, 138.0654>, <-3.3521, 431.5028, 138.3205>, <-2.9385, 430.8104, 137.6024> }
					triangle { <-2.9385, 430.8104, 137.6024>, <-3.3521, 431.5028, 138.3205>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-2.8673, 431.6812, 138.0654>, <1.01486, 430.7893, 140.5308>, <1.3441, 430.4541, 142.5054> }
					triangle { <1.3441, 430.4541, 142.5054>, <0.2603, 429.3535, 143.9667>, <-0.1637, 429.4548, 143.2312> }
					triangle { <-0.1637, 429.4548, 143.2312>, <-2.8673, 431.6812, 138.0654>, <1.3441, 430.4541, 142.5054> }
					triangle { <-2.8673, 431.6812, 138.0654>, <-0.1637, 429.4548, 143.2312>, <-3.3521, 431.5028, 138.3205> }
					triangle { <-3.407, 430.5576, 137.8011>, <-3.2306, 429.1545, 136.8384>, <-2.7569, 428.7858, 136.2675> }
					triangle { <-3.407, 430.5576, 137.8011>, <-3.8043, 431.1756, 138.463>, <-3.2306, 429.1545, 136.8384> }
					triangle { <-3.407, 430.5576, 137.8011>, <-3.3521, 431.5028, 138.3205>, <-3.8043, 431.1756, 138.463> }
					triangle { <-2.7569, 428.7858, 136.2675>, <-3.3521, 431.5028, 138.3205>, <-3.407, 430.5576, 137.8011> }
					triangle { <-1.8574, 428.7265, 143.8636>, <-3.04577, 428.5982, 142.2534>, <-3.8043, 431.1756, 138.463> }
					triangle { <-0.1637, 429.4548, 143.2312>, <0.2603, 429.3535, 143.9667>, <-1.8574, 428.7265, 143.8636> }
					triangle { <-1.8574, 428.7265, 143.8636>, <-3.8043, 431.1756, 138.463>, <-0.1637, 429.4548, 143.2312> }
					triangle { <-3.3521, 431.5028, 138.3205>, <-0.1637, 429.4548, 143.2312>, <-3.8043, 431.1756, 138.463> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <2.7992, 414.1541, 122.4994>, <2.1494, 415.0949, 124.5574>, 0.2999 }
			cylinder { <2.1494, 415.0949, 124.5574>, <1.4882, 416.1798, 126.5394>, 0.2999 }
			cylinder { <1.4882, 416.1798, 126.5394>, <0.819, 417.4037, 128.4359>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.819, 417.4037, 128.4359>, <-2.1455, 419.8686, 134.3535>, 0.2999 }
				cylinder { <-2.1455, 419.8686, 134.3535>, <-5.9229, 421.0069, 140.2117>, 0.2999 }
				cylinder { <-5.9229, 421.0069, 140.2117>, <-10.3295, 420.7632, 145.7258>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.3295, 420.7632, 145.7258>, <-10.7907, 420.3776, 146.2449>, <-11.8245, 420.5667, 147.5043> }
					triangle { <-10.7907, 420.3776, 146.2449>, <-12.4215, 420.3244, 148.1998>, <-11.8245, 420.5667, 147.5043> }
					triangle { <-12.4215, 420.3244, 148.1998>, <-12.4438, 420.8711, 148.2762>, <-11.8245, 420.5667, 147.5043> }
					triangle { <-11.8245, 420.5667, 147.5043>, <-12.4438, 420.8711, 148.2762>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-12.4215, 420.3244, 148.1998>, <-15.737, 418.7068, 145.6376>, <-17.5119, 419.3744, 145.2002> }
					triangle { <-17.5119, 419.3744, 145.2002>, <-18.2058, 421.2451, 144.7819>, <-17.4367, 421.2368, 145.0657> }
					triangle { <-17.4367, 421.2368, 145.0657>, <-12.4215, 420.3244, 148.1998>, <-17.5119, 419.3744, 145.2002> }
					triangle { <-12.4215, 420.3244, 148.1998>, <-17.4367, 421.2368, 145.0657>, <-12.4438, 420.8711, 148.2762> }
					triangle { <-11.7888, 421.1104, 147.5108>, <-10.7373, 421.1931, 146.2547>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-11.7888, 421.1104, 147.5108>, <-12.3503, 421.4118, 148.2129>, <-10.7373, 421.1931, 146.2547> }
					triangle { <-11.7888, 421.1104, 147.5108>, <-12.4438, 420.8711, 148.2762>, <-12.3503, 421.4118, 148.2129> }
					triangle { <-10.3295, 420.7632, 145.7258>, <-12.4438, 420.8711, 148.2762>, <-11.7888, 421.1104, 147.5108> }
					triangle { <-17.2684, 423.0894, 145.2449>, <-15.4283, 423.4185, 145.6944>, <-12.3503, 421.4118, 148.2129> }
					triangle { <-17.4367, 421.2368, 145.0657>, <-18.2058, 421.2451, 144.7819>, <-17.2684, 423.0894, 145.2449> }
					triangle { <-17.2684, 423.0894, 145.2449>, <-12.3503, 421.4118, 148.2129>, <-17.4367, 421.2368, 145.0657> }
					triangle { <-12.4438, 420.8711, 148.2762>, <-17.4367, 421.2368, 145.0657>, <-12.3503, 421.4118, 148.2129> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-10.3295, 420.7632, 145.7258>, <-10.4746, 420.635, 146.4961>, <-11.6137, 420.7383, 147.6717> }
					triangle { <-10.4746, 420.635, 146.4961>, <-12.00013, 420.6676, 148.5347>, <-11.6137, 420.7383, 147.6717> }
					triangle { <-12.00013, 420.6676, 148.5347>, <-12.4438, 420.8711, 148.2762>, <-11.6137, 420.7383, 147.6717> }
					triangle { <-11.6137, 420.7383, 147.6717>, <-12.4438, 420.8711, 148.2762>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-12.00013, 420.6676, 148.5347>, <-11.9771, 416.188, 148.8611>, <-13.3929, 414.854, 148.806> }
					triangle { <-13.3929, 414.854, 148.806>, <-15.0699, 414.6845, 147.659>, <-14.6945, 415.4096, 147.5855> }
					triangle { <-14.6945, 415.4096, 147.5855>, <-12.00013, 420.6676, 148.5347>, <-13.3929, 414.854, 148.806> }
					triangle { <-12.00013, 420.6676, 148.5347>, <-14.6945, 415.4096, 147.5855>, <-12.4438, 420.8711, 148.2762> }
					triangle { <-11.9996, 420.9388, 147.3434>, <-11.05339, 420.9358, 146.0036>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-11.9996, 420.9388, 147.3434>, <-12.7718, 421.0686, 147.878>, <-11.05339, 420.9358, 146.0036> }
					triangle { <-11.9996, 420.9388, 147.3434>, <-12.4438, 420.8711, 148.2762>, <-12.7718, 421.0686, 147.878> }
					triangle { <-10.3295, 420.7632, 145.7258>, <-12.4438, 420.8711, 148.2762>, <-11.9996, 420.9388, 147.3434> }
					triangle { <-16.02949, 416.2243, 146.5624>, <-15.3209, 417.9259, 146.0156>, <-12.7718, 421.0686, 147.878> }
					triangle { <-14.6945, 415.4096, 147.5855>, <-15.0699, 414.6845, 147.659>, <-16.02949, 416.2243, 146.5624> }
					triangle { <-16.02949, 416.2243, 146.5624>, <-12.7718, 421.0686, 147.878>, <-14.6945, 415.4096, 147.5855> }
					triangle { <-12.4438, 420.8711, 148.2762>, <-14.6945, 415.4096, 147.5855>, <-12.7718, 421.0686, 147.878> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-10.3295, 420.7632, 145.7258>, <-10.5557, 421.0988, 146.4092>, <-11.6678, 421.0475, 147.6138> }
					triangle { <-10.5557, 421.0988, 146.4092>, <-12.1082, 421.2859, 148.4188>, <-11.6678, 421.0475, 147.6138> }
					triangle { <-12.1082, 421.2859, 148.4188>, <-12.4438, 420.8711, 148.2762>, <-11.6678, 421.0475, 147.6138> }
					triangle { <-11.6678, 421.0475, 147.6138>, <-12.4438, 420.8711, 148.2762>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-12.1082, 421.2859, 148.4188>, <-8.8579, 420.0974, 151.2817>, <-8.6869, 418.6293, 152.5477> }
					triangle { <-8.6869, 418.6293, 152.5477>, <-9.204, 416.6603, 152.4384>, <-9.499, 417.1114, 151.8206> }
					triangle { <-9.499, 417.1114, 151.8206>, <-12.1082, 421.2859, 148.4188>, <-8.6869, 418.6293, 152.5477> }
					triangle { <-12.1082, 421.2859, 148.4188>, <-9.499, 417.1114, 151.8206>, <-12.4438, 420.8711, 148.2762> }
					triangle { <-11.9455, 420.6296, 147.4013>, <-10.9722, 420.472, 146.0904>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-11.9455, 420.6296, 147.4013>, <-12.6636, 420.4502, 147.9938>, <-10.9722, 420.472, 146.0904> }
					triangle { <-11.9455, 420.6296, 147.4013>, <-12.4438, 420.8711, 148.2762>, <-12.6636, 420.4502, 147.9938> }
					triangle { <-10.3295, 420.7632, 145.7258>, <-12.4438, 420.8711, 148.2762>, <-11.9455, 420.6296, 147.4013> }
					triangle { <-10.5843, 415.774, 151.0955>, <-11.2644, 416.476, 149.4398>, <-12.6636, 420.4502, 147.9938> }
					triangle { <-9.499, 417.1114, 151.8206>, <-9.204, 416.6603, 152.4384>, <-10.5843, 415.774, 151.0955> }
					triangle { <-10.5843, 415.774, 151.0955>, <-12.6636, 420.4502, 147.9938>, <-9.499, 417.1114, 151.8206> }
					triangle { <-12.4438, 420.8711, 148.2762>, <-9.499, 417.1114, 151.8206>, <-12.6636, 420.4502, 147.9938> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-10.3295, 420.7632, 145.7258>, <-10.9227, 421.1324, 146.1036>, <-11.9125, 421.0699, 147.4101> }
					triangle { <-10.9227, 421.1324, 146.1036>, <-12.5975, 421.3308, 148.0113>, <-11.9125, 421.0699, 147.4101> }
					triangle { <-12.5975, 421.3308, 148.0113>, <-12.4438, 420.8711, 148.2762>, <-11.9125, 421.0699, 147.4101> }
					triangle { <-11.9125, 421.0699, 147.4101>, <-12.4438, 420.8711, 148.2762>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-12.5975, 421.3308, 148.0113>, <-10.6609, 425.0687, 149.5768>, <-9.8534, 425.5182, 151.2894> }
					triangle { <-9.8534, 425.5182, 151.2894>, <-8.6599, 424.4606, 152.5596>, <-8.9818, 424.0063, 151.9579> }
					triangle { <-8.9818, 424.0063, 151.9579>, <-12.5975, 421.3308, 148.0113>, <-9.8534, 425.5182, 151.2894> }
					triangle { <-12.5975, 421.3308, 148.0113>, <-8.9818, 424.0063, 151.9579>, <-12.4438, 420.8711, 148.2762> }
					triangle { <-11.7008, 420.6072, 147.6051>, <-10.6053, 420.4384, 146.3961>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-11.7008, 420.6072, 147.6051>, <-12.1743, 420.4054, 148.4013>, <-10.6053, 420.4384, 146.3961> }
					triangle { <-11.7008, 420.6072, 147.6051>, <-12.4438, 420.8711, 148.2762>, <-12.1743, 420.4054, 148.4013> }
					triangle { <-10.3295, 420.7632, 145.7258>, <-12.4438, 420.8711, 148.2762>, <-11.7008, 420.6072, 147.6051> }
					triangle { <-8.4073, 422.3566, 152.6219>, <-8.8268, 421.0588, 151.2668>, <-12.1743, 420.4054, 148.4013> }
					triangle { <-8.9818, 424.0063, 151.9579>, <-8.6599, 424.4606, 152.5596>, <-8.4073, 422.3566, 152.6219> }
					triangle { <-8.4073, 422.3566, 152.6219>, <-12.1743, 420.4054, 148.4013>, <-8.9818, 424.0063, 151.9579> }
					triangle { <-12.4438, 420.8711, 148.2762>, <-8.9818, 424.0063, 151.9579>, <-12.1743, 420.4054, 148.4013> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-10.3295, 420.7632, 145.7258>, <-11.07015, 420.68, 146.0005>, <-12.01079, 420.7683, 147.3414> }
					triangle { <-11.07015, 420.68, 146.0005>, <-12.7941, 420.7275, 147.8739>, <-12.01079, 420.7683, 147.3414> }
					triangle { <-12.7941, 420.7275, 147.8739>, <-12.4438, 420.8711, 148.2762>, <-12.01079, 420.7683, 147.3414> }
					triangle { <-12.01079, 420.7683, 147.3414>, <-12.4438, 420.8711, 148.2762>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-12.7941, 420.7275, 147.8739>, <-14.9766, 424.1963, 146.0359>, <-15.3899, 425.9857, 146.6799> }
					triangle { <-15.3899, 425.9857, 146.6799>, <-14.3073, 427.3369, 147.7562>, <-13.9617, 426.5944, 147.7201> }
					triangle { <-13.9617, 426.5944, 147.7201>, <-12.7941, 420.7275, 147.8739>, <-15.3899, 425.9857, 146.6799> }
					triangle { <-12.7941, 420.7275, 147.8739>, <-13.9617, 426.5944, 147.7201>, <-12.4438, 420.8711, 148.2762> }
					triangle { <-11.6026, 420.9088, 147.6738>, <-10.4578, 420.8908, 146.4992>, <-10.3295, 420.7632, 145.7258> }
					triangle { <-11.6026, 420.9088, 147.6738>, <-11.9777, 421.0086, 148.5388>, <-10.4578, 420.8908, 146.4992> }
					triangle { <-11.6026, 420.9088, 147.6738>, <-12.4438, 420.8711, 148.2762>, <-11.9777, 421.0086, 148.5388> }
					triangle { <-10.3295, 420.7632, 145.7258>, <-12.4438, 420.8711, 148.2762>, <-11.6026, 420.9088, 147.6738> }
					triangle { <-12.6006, 426.946, 148.9515>, <-11.4391, 425.4143, 148.9171>, <-11.9777, 421.0086, 148.5388> }
					triangle { <-13.9617, 426.5944, 147.7201>, <-14.3073, 427.3369, 147.7562>, <-12.6006, 426.946, 148.9515> }
					triangle { <-12.6006, 426.946, 148.9515>, <-11.9777, 421.0086, 148.5388>, <-13.9617, 426.5944, 147.7201> }
					triangle { <-12.4438, 420.8711, 148.2762>, <-13.9617, 426.5944, 147.7201>, <-11.9777, 421.0086, 148.5388> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <11.9106, 402.5925, 98.4828>, <11.641, 404.8474, 99.1037>, 0.2999 }
			cylinder { <11.641, 404.8474, 99.1037>, <11.3178, 407.0499, 99.8698>, 0.2999 }
			cylinder { <11.3178, 407.0499, 99.8698>, <10.9425, 409.1895, 100.7774>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <10.9425, 409.1895, 100.7774>, <12.303, 411.1096, 100.7078>, 0.2999 }
			cylinder { <12.303, 411.1096, 100.7078>, <13.7688, 412.9449, 100.5466>, 0.2999 }
			cylinder { <13.7688, 412.9449, 100.5466>, <15.3329, 414.6863, 100.2946>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <15.3329, 414.6863, 100.2946>, <18.7606, 420.7734, 99.2548>, 0.2999 }
				cylinder { <18.7606, 420.7734, 99.2548>, <20.7571, 427.4274, 97.9816>, 0.2999 }
				cylinder { <20.7571, 427.4274, 97.9816>, <21.2255, 434.3249, 96.5368>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <21.2255, 434.3249, 96.5368>, <20.8166, 435.0294, 96.6877>, <20.8537, 436.7276, 96.4845> }
					triangle { <20.8166, 435.0294, 96.6877>, <20.5569, 437.6688, 96.5478>, <20.8537, 436.7276, 96.4845> }
					triangle { <20.5569, 437.6688, 96.5478>, <21.04904, 437.7668, 96.2646>, <20.8537, 436.7276, 96.4845> }
					triangle { <20.8537, 436.7276, 96.4845>, <21.04904, 437.7668, 96.2646>, <21.2255, 434.3249, 96.5368> }
					triangle { <20.5569, 437.6688, 96.5478>, <16.7979, 437.3514, 93.7704>, <16.4059, 438.0397, 91.9016> }
					triangle { <16.4059, 438.0397, 91.9016>, <17.5956, 438.1519, 90.1428>, <18.04002, 437.9447, 90.8434> }
					triangle { <18.04002, 437.9447, 90.8434>, <20.5569, 437.6688, 96.5478>, <16.4059, 438.0397, 91.9016> }
					triangle { <20.5569, 437.6688, 96.5478>, <18.04002, 437.9447, 90.8434>, <21.04904, 437.7668, 96.2646> }
					triangle { <21.3507, 436.7313, 96.2088>, <21.5619, 435.0349, 96.2741>, <21.2255, 434.3249, 96.5368> }
					triangle { <21.3507, 436.7313, 96.2088>, <21.5508, 437.6761, 95.9964>, <21.5619, 435.0349, 96.2741> }
					triangle { <21.3507, 436.7313, 96.2088>, <21.04904, 437.7668, 96.2646>, <21.5508, 437.6761, 95.9964> }
					triangle { <21.2255, 434.3249, 96.5368>, <21.04904, 437.7668, 96.2646>, <21.3507, 436.7313, 96.2088> }
					triangle { <19.8015, 438.0649, 90.01772>, <21.1045, 437.3833, 91.3811>, <21.5508, 437.6761, 95.9964> }
					triangle { <18.04002, 437.9447, 90.8434>, <17.5956, 438.1519, 90.1428>, <19.8015, 438.0649, 90.01772> }
					triangle { <19.8015, 438.0649, 90.01772>, <21.5508, 437.6761, 95.9964>, <18.04002, 437.9447, 90.8434> }
					triangle { <21.04904, 437.7668, 96.2646>, <18.04002, 437.9447, 90.8434>, <21.5508, 437.6761, 95.9964> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <21.2255, 434.3249, 96.5368>, <21.2676, 435.0692, 96.8982>, <21.1544, 436.7542, 96.6249> }
					triangle { <21.2676, 435.0692, 96.8982>, <21.1583, 437.7218, 96.8285>, <21.1544, 436.7542, 96.6249> }
					triangle { <21.1583, 437.7218, 96.8285>, <21.04904, 437.7668, 96.2646>, <21.1544, 436.7542, 96.6249> }
					triangle { <21.1544, 436.7542, 96.6249>, <21.04904, 437.7668, 96.2646>, <21.2255, 434.3249, 96.5368> }
					triangle { <21.1583, 437.7218, 96.8285>, <17.3266, 437.8334, 99.5211>, <15.4585, 438.5704, 99.226> }
					triangle { <15.4585, 438.5704, 99.226>, <14.1709, 438.5608, 97.5339>, <14.967, 438.3024, 97.359> }
					triangle { <14.967, 438.3024, 97.359>, <21.1583, 437.7218, 96.8285>, <15.4585, 438.5704, 99.226> }
					triangle { <21.1583, 437.7218, 96.8285>, <14.967, 438.3024, 97.359>, <21.04904, 437.7668, 96.2646> }
					triangle { <21.05001, 436.7048, 96.06849>, <21.1109, 434.9951, 96.06363>, <21.2255, 434.3249, 96.5368> }
					triangle { <21.05001, 436.7048, 96.06849>, <20.9494, 437.6231, 95.7157>, <21.1109, 434.9951, 96.06363> }
					triangle { <21.05001, 436.7048, 96.06849>, <21.04904, 437.7668, 96.2646>, <20.9494, 437.6231, 95.7157> }
					triangle { <21.2255, 434.3249, 96.5368>, <21.04904, 437.7668, 96.2646>, <21.05001, 436.7048, 96.06849> }
					triangle { <14.7446, 438.2331, 95.4238>, <16.4211, 437.4055, 94.6988>, <20.9494, 437.6231, 95.7157> }
					triangle { <14.967, 438.3024, 97.359>, <14.1709, 438.5608, 97.5339>, <14.7446, 438.2331, 95.4238> }
					triangle { <14.7446, 438.2331, 95.4238>, <20.9494, 437.6231, 95.7157>, <14.967, 438.3024, 97.359> }
					triangle { <21.04904, 437.7668, 96.2646>, <14.967, 438.3024, 97.359>, <20.9494, 437.6231, 95.7157> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <21.2255, 434.3249, 96.5368>, <21.6111, 435.0581, 96.5359>, <21.3834, 436.7468, 96.3833> }
					triangle { <21.6111, 435.0581, 96.5359>, <21.6163, 437.7071, 96.3455>, <21.3834, 436.7468, 96.3833> }
					triangle { <21.6163, 437.7071, 96.3455>, <21.04904, 437.7668, 96.2646>, <21.3834, 436.7468, 96.3833> }
					triangle { <21.3834, 436.7468, 96.3833>, <21.04904, 437.7668, 96.2646>, <21.2255, 434.3249, 96.5368> }
					triangle { <21.6163, 437.7071, 96.3455>, <22.9648, 438.2239, 100.8019>, <22.1251, 439.1629, 102.3934> }
					triangle { <22.1251, 439.1629, 102.3934>, <20.1143, 439.3036, 103.0702>, <20.1893, 438.9603, 102.2906> }
					triangle { <20.1893, 438.9603, 102.2906>, <21.6163, 437.7071, 96.3455>, <22.1251, 439.1629, 102.3934> }
					triangle { <21.6163, 437.7071, 96.3455>, <20.1893, 438.9603, 102.2906>, <21.04904, 437.7668, 96.2646> }
					triangle { <20.821, 436.7122, 96.31>, <20.7674, 435.0062, 96.4259>, <21.2255, 434.3249, 96.5368> }
					triangle { <20.821, 436.7122, 96.31>, <20.4914, 437.6378, 96.1987>, <20.7674, 435.0062, 96.4259> }
					triangle { <20.821, 436.7122, 96.31>, <21.04904, 437.7668, 96.2646>, <20.4914, 437.6378, 96.1987> }
					triangle { <21.2255, 434.3249, 96.5368>, <21.04904, 437.7668, 96.2646>, <20.821, 436.7122, 96.31> }
					triangle { <18.2816, 438.9261, 101.892>, <18.09016, 437.9236, 100.1659>, <20.4914, 437.6378, 96.1987> }
					triangle { <20.1893, 438.9603, 102.2906>, <20.1143, 439.3036, 103.0702>, <18.2816, 438.9261, 101.892> }
					triangle { <18.2816, 438.9261, 101.892>, <20.4914, 437.6378, 96.1987>, <20.1893, 438.9603, 102.2906> }
					triangle { <21.04904, 437.7668, 96.2646>, <20.1893, 438.9603, 102.2906>, <20.4914, 437.6378, 96.1987> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <21.2255, 434.3249, 96.5368>, <21.3756, 435.0114, 96.09816>, <21.2264, 436.7157, 96.09151> }
					triangle { <21.3756, 435.0114, 96.09816>, <21.3022, 437.6448, 95.7617>, <21.2264, 436.7157, 96.09151> }
					triangle { <21.3022, 437.6448, 95.7617>, <21.04904, 437.7668, 96.2646>, <21.2264, 436.7157, 96.09151> }
					triangle { <21.2264, 436.7157, 96.09151>, <21.04904, 437.7668, 96.2646>, <21.2255, 434.3249, 96.5368> }
					triangle { <21.3022, 437.6448, 95.7617>, <25.9733, 437.9869, 95.8546>, <27.2548, 439.0038, 97.05608> }
					triangle { <27.2548, 439.0038, 97.05608>, <27.2677, 439.3606, 99.1522>, <26.5386, 439.0154, 98.8688> }
					triangle { <26.5386, 439.0154, 98.8688>, <21.3022, 437.6448, 95.7617>, <27.2548, 439.0038, 97.05608> }
					triangle { <21.3022, 437.6448, 95.7617>, <26.5386, 439.0154, 98.8688>, <21.04904, 437.7668, 96.2646> }
					triangle { <20.978, 436.7433, 96.6018>, <21.003, 435.0529, 96.8637>, <21.2255, 434.3249, 96.5368> }
					triangle { <20.978, 436.7433, 96.6018>, <20.8054, 437.7001, 96.7824>, <21.003, 435.0529, 96.8637> }
					triangle { <20.978, 436.7433, 96.6018>, <21.04904, 437.7668, 96.2646>, <20.8054, 437.7001, 96.7824> }
					triangle { <21.2255, 434.3249, 96.5368>, <21.04904, 437.7668, 96.2646>, <20.978, 436.7433, 96.6018> }
					triangle { <25.5575, 439.1926, 100.5437>, <23.8206, 438.2263, 100.2779>, <20.8054, 437.7001, 96.7824> }
					triangle { <26.5386, 439.0154, 98.8688>, <27.2677, 439.3606, 99.1522>, <25.5575, 439.1926, 100.5437> }
					triangle { <25.5575, 439.1926, 100.5437>, <20.8054, 437.7001, 96.7824>, <26.5386, 439.0154, 98.8688> }
					triangle { <21.04904, 437.7668, 96.2646>, <26.5386, 439.0154, 98.8688>, <20.8054, 437.7001, 96.7824> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <21.2255, 434.3249, 96.5368>, <20.8771, 434.9934, 96.1933>, <20.8941, 436.7036, 96.1549> }
					triangle { <20.8771, 434.9934, 96.1933>, <20.6376, 437.6208, 95.8886>, <20.8941, 436.7036, 96.1549> }
					triangle { <20.6376, 437.6208, 95.8886>, <21.04904, 437.7668, 96.2646>, <20.8941, 436.7036, 96.1549> }
					triangle { <20.8941, 436.7036, 96.1549>, <21.04904, 437.7668, 96.2646>, <21.2255, 434.3249, 96.5368> }
					triangle { <20.6376, 437.6208, 95.8886>, <22.1044, 437.4395, 91.4433>, <23.6668, 438.2992, 90.4738> }
					triangle { <23.6668, 438.2992, 90.4738>, <25.6876, 438.6381, 91.04213>, <25.1902, 438.3782, 91.6872> }
					triangle { <25.1902, 438.3782, 91.6872>, <20.6376, 437.6208, 95.8886>, <23.6668, 438.2992, 90.4738> }
					triangle { <20.6376, 437.6208, 95.8886>, <25.1902, 438.3782, 91.6872>, <21.04904, 437.7668, 96.2646> }
					triangle { <21.3103, 436.7553, 96.5384>, <21.5014, 435.0709, 96.7685>, <21.2255, 434.3249, 96.5368> }
					triangle { <21.3103, 436.7553, 96.5384>, <21.4701, 437.7241, 96.6555>, <21.5014, 435.0709, 96.7685> }
					triangle { <21.3103, 436.7553, 96.5384>, <21.04904, 437.7668, 96.2646>, <21.4701, 437.7241, 96.6555> }
					triangle { <21.2255, 434.3249, 96.5368>, <21.04904, 437.7668, 96.2646>, <21.3103, 436.7553, 96.5384> }
					triangle { <26.511, 438.6523, 93.09418>, <25.7117, 437.8874, 94.7666>, <21.4701, 437.7241, 96.6555> }
					triangle { <25.1902, 438.3782, 91.6872>, <25.6876, 438.6381, 91.04213>, <26.511, 438.6523, 93.09418> }
					triangle { <26.511, 438.6523, 93.09418>, <21.4701, 437.7241, 96.6555>, <25.1902, 438.3782, 91.6872> }
					triangle { <21.04904, 437.7668, 96.2646>, <25.1902, 438.3782, 91.6872>, <21.4701, 437.7241, 96.6555> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <15.3329, 414.6863, 100.2946>, <16.7713, 416.5295, 100.0192>, 0.2999 }
			cylinder { <16.7713, 416.5295, 100.0192>, <18.07733, 418.4656, 99.7212>, 0.2999 }
			cylinder { <18.07733, 418.4656, 99.7212>, <19.2444, 420.4851, 99.4022>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.2444, 420.4851, 99.4022>, <23.5634, 426.0664, 99.6811>, 0.2999 }
				cylinder { <23.5634, 426.0664, 99.6811>, <28.4902, 430.8992, 101.1824>, 0.2999 }
				cylinder { <28.4902, 430.8992, 101.1824>, <33.7854, 434.7485, 103.8332>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <33.7854, 434.7485, 103.8332>, <34.4486, 434.9297, 104.2954>, <35.4885, 436.1918, 104.7978> }
					triangle { <34.4486, 434.9297, 104.2954>, <36.2382, 436.6351, 105.266>, <35.4885, 436.1918, 104.7978> }
					triangle { <36.2382, 436.6351, 105.266>, <36.03057, 437.1032, 105.002>, <35.4885, 436.1918, 104.7978> }
					triangle { <35.4885, 436.1918, 104.7978>, <36.03057, 437.1032, 105.002>, <33.7854, 434.7485, 103.8332> }
					triangle { <36.2382, 436.6351, 105.266>, <34.684, 436.0799, 109.6502>, <33.9261, 437.3762, 111.0158> }
					triangle { <33.9261, 437.3762, 111.0158>, <32.5884, 439.0192, 110.8356>, <32.8603, 438.7159, 110.0839> }
					triangle { <32.8603, 438.7159, 110.0839>, <36.2382, 436.6351, 105.266>, <33.9261, 437.3762, 111.0158> }
					triangle { <36.2382, 436.6351, 105.266>, <32.8603, 438.7159, 110.0839>, <36.03057, 437.1032, 105.002> }
					triangle { <35.2193, 436.5954, 104.5018>, <34.04486, 435.5351, 103.8514>, <33.7854, 434.7485, 103.8332> }
					triangle { <35.2193, 436.5954, 104.5018>, <35.6998, 437.4423, 104.674>, <34.04486, 435.5351, 103.8514> }
					triangle { <35.2193, 436.5954, 104.5018>, <36.03057, 437.1032, 105.002>, <35.6998, 437.4423, 104.674> }
					triangle { <33.7854, 434.7485, 103.8332>, <36.03057, 437.1032, 105.002>, <35.2193, 436.5954, 104.5018> }
					triangle { <32.08669, 440.134, 108.9932>, <32.3511, 439.5776, 107.0849>, <35.6998, 437.4423, 104.674> }
					triangle { <32.8603, 438.7159, 110.0839>, <32.5884, 439.0192, 110.8356>, <32.08669, 440.134, 108.9932> }
					triangle { <32.08669, 440.134, 108.9932>, <35.6998, 437.4423, 104.674>, <32.8603, 438.7159, 110.0839> }
					triangle { <36.03057, 437.1032, 105.002>, <32.8603, 438.7159, 110.0839>, <35.6998, 437.4423, 104.674> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <33.7854, 434.7485, 103.8332>, <34.5508, 435.0653, 103.8258>, <35.5566, 436.2823, 104.4847> }
					triangle { <34.5508, 435.0653, 103.8258>, <36.3744, 436.816, 104.6399>, <35.5566, 436.2823, 104.4847> }
					triangle { <36.3744, 436.816, 104.6399>, <36.03057, 437.1032, 105.002>, <35.5566, 436.2823, 104.4847> }
					triangle { <35.5566, 436.2823, 104.4847>, <36.03057, 437.1032, 105.002>, <33.7854, 434.7485, 103.8332> }
					triangle { <36.3744, 436.816, 104.6399>, <38.9428, 433.4836, 106.6999>, <39.5521, 433.2033, 108.6157> }
					triangle { <39.5521, 433.2033, 108.6157>, <38.5729, 433.489, 110.4814>, <38.1428, 433.8119, 109.8167> }
					triangle { <38.1428, 433.8119, 109.8167>, <36.3744, 436.816, 104.6399>, <39.5521, 433.2033, 108.6157> }
					triangle { <36.3744, 436.816, 104.6399>, <38.1428, 433.8119, 109.8167>, <36.03057, 437.1032, 105.002> }
					triangle { <35.1512, 436.5049, 104.8148>, <33.9426, 435.3994, 104.321>, <33.7854, 434.7485, 103.8332> }
					triangle { <35.1512, 436.5049, 104.8148>, <35.5636, 437.2614, 105.3001>, <33.9426, 435.3994, 104.321> }
					triangle { <35.1512, 436.5049, 104.8148>, <36.03057, 437.1032, 105.002>, <35.5636, 437.2614, 105.3001> }
					triangle { <33.7854, 434.7485, 103.8332>, <36.03057, 437.1032, 105.002>, <35.1512, 436.5049, 104.8148> }
					triangle { <36.7817, 434.7252, 110.8714>, <35.4291, 435.4138, 109.5609>, <35.5636, 437.2614, 105.3001> }
					triangle { <38.1428, 433.8119, 109.8167>, <38.5729, 433.489, 110.4814>, <36.7817, 434.7252, 110.8714> }
					triangle { <36.7817, 434.7252, 110.8714>, <35.5636, 437.2614, 105.3001>, <38.1428, 433.8119, 109.8167> }
					triangle { <36.03057, 437.1032, 105.002>, <38.1428, 433.8119, 109.8167>, <35.5636, 437.2614, 105.3001> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <33.7854, 434.7485, 103.8332>, <34.2356, 435.4303, 103.6961>, <35.3465, 436.5255, 104.3982> }
					triangle { <34.2356, 435.4303, 103.6961>, <35.9542, 437.3026, 104.4669>, <35.3465, 436.5255, 104.3982> }
					triangle { <35.9542, 437.3026, 104.4669>, <36.03057, 437.1032, 105.002>, <35.3465, 436.5255, 104.3982> }
					triangle { <35.3465, 436.5255, 104.3982>, <36.03057, 437.1032, 105.002>, <33.7854, 434.7485, 103.8332> }
					triangle { <35.9542, 437.3026, 104.4669>, <39.2041, 435.8557, 101.4191>, <41.1042, 435.1805, 101.6509> }
					triangle { <41.1042, 435.1805, 101.6509>, <41.9964, 433.8938, 103.0895>, <41.2013, 434.1341, 103.2924> }
					triangle { <41.2013, 434.1341, 103.2924>, <35.9542, 437.3026, 104.4669>, <41.1042, 435.1805, 101.6509> }
					triangle { <35.9542, 437.3026, 104.4669>, <41.2013, 434.1341, 103.2924>, <36.03057, 437.1032, 105.002> }
					triangle { <35.3613, 436.2617, 104.9013>, <34.2578, 435.0345, 104.4507>, <33.7854, 434.7485, 103.8332> }
					triangle { <35.3613, 436.2617, 104.9013>, <35.9838, 436.7749, 105.4731>, <34.2578, 435.0345, 104.4507> }
					triangle { <35.3613, 436.2617, 104.9013>, <36.03057, 437.1032, 105.002>, <35.9838, 436.7749, 105.4731> }
					triangle { <33.7854, 434.7485, 103.8332>, <36.03057, 437.1032, 105.002>, <35.3613, 436.2617, 104.9013> }
					triangle { <41.2055, 433.3775, 105.0887>, <39.3326, 433.569, 105.7793>, <35.9838, 436.7749, 105.4731> }
					triangle { <41.2013, 434.1341, 103.2924>, <41.9964, 433.8938, 103.0895>, <41.2055, 433.3775, 105.0887> }
					triangle { <41.2055, 433.3775, 105.0887>, <35.9838, 436.7749, 105.4731>, <41.2013, 434.1341, 103.2924> }
					triangle { <36.03057, 437.1032, 105.002>, <41.2013, 434.1341, 103.2924>, <35.9838, 436.7749, 105.4731> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <33.7854, 434.7485, 103.8332>, <33.9357, 435.5236, 104.0843>, <35.1465, 436.5877, 104.657> }
					triangle { <33.9357, 435.5236, 104.0843>, <35.5543, 437.427, 104.9845>, <35.1465, 436.5877, 104.657> }
					triangle { <35.5543, 437.427, 104.9845>, <36.03057, 437.1032, 105.002>, <35.1465, 436.5877, 104.657> }
					triangle { <35.1465, 436.5877, 104.657>, <36.03057, 437.1032, 105.002>, <33.7854, 434.7485, 103.8332> }
					triangle { <35.5543, 437.427, 104.9845>, <35.1092, 439.9402, 101.0563>, <36.4519, 440.5939, 99.6816> }
					triangle { <36.4519, 440.5939, 99.6816>, <38.1597, 439.6781, 98.8063>, <37.8377, 439.2403, 99.4664> }
					triangle { <37.8377, 439.2403, 99.4664>, <35.5543, 437.427, 104.9845>, <36.4519, 440.5939, 99.6816> }
					triangle { <35.5543, 437.427, 104.9845>, <37.8377, 439.2403, 99.4664>, <36.03057, 437.1032, 105.002> }
					triangle { <35.5613, 436.1995, 104.6425>, <34.5578, 434.9412, 104.0625>, <33.7854, 434.7485, 103.8332> }
					triangle { <35.5613, 436.1995, 104.6425>, <36.3837, 436.6505, 104.9555>, <34.5578, 434.9412, 104.0625> }
					triangle { <35.5613, 436.1995, 104.6425>, <36.03057, 437.1032, 105.002>, <36.3837, 436.6505, 104.9555> }
					triangle { <33.7854, 434.7485, 103.8332>, <36.03057, 437.1032, 105.002>, <35.5613, 436.1995, 104.6425> }
					triangle { <39.2859, 437.9409, 99.5826>, <38.7036, 436.5754, 100.9308>, <36.3837, 436.6505, 104.9555> }
					triangle { <37.8377, 439.2403, 99.4664>, <38.1597, 439.6781, 98.8063>, <39.2859, 437.9409, 99.5826> }
					triangle { <39.2859, 437.9409, 99.5826>, <36.3837, 436.6505, 104.9555>, <37.8377, 439.2403, 99.4664> }
					triangle { <36.03057, 437.1032, 105.002>, <37.8377, 439.2403, 99.4664>, <36.3837, 436.6505, 104.9555> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <33.7854, 434.7485, 103.8332>, <34.06933, 435.2095, 104.4603>, <35.2356, 436.3784, 104.9077> }
					triangle { <34.06933, 435.2095, 104.4603>, <35.7325, 437.0082, 105.4858>, <35.2356, 436.3784, 104.9077> }
					triangle { <35.7325, 437.0082, 105.4858>, <36.03057, 437.1032, 105.002>, <35.2356, 436.3784, 104.9077> }
					triangle { <35.2356, 436.3784, 104.9077>, <36.03057, 437.1032, 105.002>, <33.7854, 434.7485, 103.8332> }
					triangle { <35.7325, 437.0082, 105.4858>, <32.2734, 440.0808, 106.2202>, <31.9486, 441.9714, 105.5568> }
					triangle { <31.9486, 441.9714, 105.5568>, <32.2574, 442.8936, 103.666>, <32.6049, 442.1148, 103.7271> }
					triangle { <32.6049, 442.1148, 103.7271>, <35.7325, 437.0082, 105.4858>, <31.9486, 441.9714, 105.5568> }
					triangle { <35.7325, 437.0082, 105.4858>, <32.6049, 442.1148, 103.7271>, <36.03057, 437.1032, 105.002> }
					triangle { <35.4722, 436.4088, 104.3919>, <34.4241, 435.2552, 103.6865>, <33.7854, 434.7485, 103.8332> }
					triangle { <35.4722, 436.4088, 104.3919>, <36.2056, 437.0692, 104.4542>, <34.4241, 435.2552, 103.6865> }
					triangle { <35.4722, 436.4088, 104.3919>, <36.03057, 437.1032, 105.002>, <36.2056, 437.0692, 104.4542> }
					triangle { <33.7854, 434.7485, 103.8332>, <36.03057, 437.1032, 105.002>, <35.4722, 436.4088, 104.3919> }
					triangle { <33.565, 442.1797, 102.0321>, <34.3236, 440.345, 101.7499>, <36.2056, 437.0692, 104.4542> }
					triangle { <32.6049, 442.1148, 103.7271>, <32.2574, 442.8936, 103.666>, <33.565, 442.1797, 102.0321> }
					triangle { <33.565, 442.1797, 102.0321>, <36.2056, 437.0692, 104.4542>, <32.6049, 442.1148, 103.7271> }
					triangle { <36.03057, 437.1032, 105.002>, <32.6049, 442.1148, 103.7271>, <36.2056, 437.0692, 104.4542> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <19.2444, 420.4851, 99.4022>, <20.509, 422.4613, 99.2069>, 0.2999 }
			cylinder { <20.509, 422.4613, 99.2069>, <21.8647, 424.3847, 99.1365>, 0.2999 }
			cylinder { <21.8647, 424.3847, 99.1365>, <23.305, 426.2462, 99.1914>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <23.305, 426.2462, 99.1914>, <27.6519, 431.639, 97.8111>, 0.2999 }
				cylinder { <27.6519, 431.639, 97.8111>, <31.8136, 436.5781, 94.953>, 0.2999 }
				cylinder { <31.8136, 436.5781, 94.953>, <35.5878, 440.8235, 90.756>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <35.5878, 440.8235, 90.756>, <35.7633, 441.1694, 90.02409>, <36.8418, 442.2146, 89.2049> }
					triangle { <35.7633, 441.1694, 90.02409>, <37.2362, 442.7283, 88.4576>, <36.8418, 442.2146, 89.2049> }
					triangle { <37.2362, 442.7283, 88.4576>, <37.6123, 442.8897, 88.863>, <36.8418, 442.2146, 89.2049> }
					triangle { <36.8418, 442.2146, 89.2049>, <37.6123, 442.8897, 88.863>, <35.5878, 440.8235, 90.756> }
					triangle { <37.2362, 442.7283, 88.4576>, <38.6769, 439.1012, 85.8665>, <40.5166, 438.3484, 85.4555> }
					triangle { <40.5166, 438.3484, 85.4555>, <42.2475, 438.0722, 86.6593>, <41.6392, 438.5393, 87.03748> }
					triangle { <41.6392, 438.5393, 87.03748>, <37.2362, 442.7283, 88.4576>, <40.5166, 438.3484, 85.4555> }
					triangle { <37.2362, 442.7283, 88.4576>, <41.6392, 438.5393, 87.03748>, <37.6123, 442.8897, 88.863> }
					triangle { <37.1624, 442.3195, 89.6622>, <36.2442, 441.3267, 90.7101>, <35.5878, 440.8235, 90.756> }
					triangle { <37.1624, 442.3195, 89.6622>, <37.8774, 442.938, 89.3722>, <36.2442, 441.3267, 90.7101> }
					triangle { <37.1624, 442.3195, 89.6622>, <37.6123, 442.8897, 88.863>, <37.8774, 442.938, 89.3722> }
					triangle { <35.5878, 440.8235, 90.756>, <37.6123, 442.8897, 88.863>, <37.1624, 442.3195, 89.6622> }
					triangle { <42.7074, 439.065, 88.5807>, <41.4556, 440.01, 89.8301>, <37.8774, 442.938, 89.3722> }
					triangle { <41.6392, 438.5393, 87.03748>, <42.2475, 438.0722, 86.6593>, <42.7074, 439.065, 88.5807> }
					triangle { <42.7074, 439.065, 88.5807>, <37.8774, 442.938, 89.3722>, <41.6392, 438.5393, 87.03748> }
					triangle { <37.6123, 442.8897, 88.863>, <41.6392, 438.5393, 87.03748>, <37.8774, 442.938, 89.3722> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <35.5878, 440.8235, 90.756>, <35.6928, 441.5392, 90.3522>, <36.7948, 442.4611, 89.4236> }
					triangle { <35.6928, 441.5392, 90.3522>, <37.1422, 443.2213, 88.8951>, <36.7948, 442.4611, 89.4236> }
					triangle { <37.1422, 443.2213, 88.8951>, <37.6123, 442.8897, 88.863>, <36.7948, 442.4611, 89.4236> }
					triangle { <36.7948, 442.4611, 89.4236>, <37.6123, 442.8897, 88.863>, <35.5878, 440.8235, 90.756> }
					triangle { <37.1422, 443.2213, 88.8951>, <34.2759, 442.8141, 85.2122>, <34.571, 442.1996, 83.3004> }
					triangle { <34.571, 442.1996, 83.3004>, <35.7295, 440.6213, 82.4708>, <35.882, 440.7573, 83.3011> }
					triangle { <35.882, 440.7573, 83.3011>, <37.1422, 443.2213, 88.8951>, <34.571, 442.1996, 83.3004> }
					triangle { <37.1422, 443.2213, 88.8951>, <35.882, 440.7573, 83.3011>, <37.6123, 442.8897, 88.863> }
					triangle { <37.2095, 442.073, 89.4434>, <36.3147, 440.957, 90.3819>, <35.5878, 440.8235, 90.756> }
					triangle { <37.2095, 442.073, 89.4434>, <37.9714, 442.445, 88.9347>, <36.3147, 440.957, 90.3819> }
					triangle { <37.2095, 442.073, 89.4434>, <37.6123, 442.8897, 88.863>, <37.9714, 442.445, 88.9347> }
					triangle { <35.5878, 440.8235, 90.756>, <37.6123, 442.8897, 88.863>, <37.2095, 442.073, 89.4434> }
					triangle { <37.4043, 439.5475, 83.4358>, <37.8694, 439.4504, 85.384>, <37.9714, 442.445, 88.9347> }
					triangle { <35.882, 440.7573, 83.3011>, <35.7295, 440.6213, 82.4708>, <37.4043, 439.5475, 83.4358> }
					triangle { <37.4043, 439.5475, 83.4358>, <37.9714, 442.445, 88.9347>, <35.882, 440.7573, 83.3011> }
					triangle { <37.6123, 442.8897, 88.863>, <35.882, 440.7573, 83.3011>, <37.9714, 442.445, 88.9347> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <35.5878, 440.8235, 90.756>, <36.04916, 441.5093, 90.7007>, <37.03243, 442.4412, 89.656> }
					triangle { <36.04916, 441.5093, 90.7007>, <37.6173, 443.1815, 89.3598>, <37.03243, 442.4412, 89.656> }
					triangle { <37.6173, 443.1815, 89.3598>, <37.6123, 442.8897, 88.863>, <37.03243, 442.4412, 89.656> }
					triangle { <37.03243, 442.4412, 89.656>, <37.6123, 442.8897, 88.863>, <35.5878, 440.8235, 90.756> }
					triangle { <37.6173, 443.1815, 89.3598>, <34.4545, 446.6308, 89.5692>, <33.4852, 447.6974, 88.14> }
					triangle { <33.4852, 447.6974, 88.14>, <32.6334, 447.1389, 86.2735>, <33.1089, 446.524, 86.6298> }
					triangle { <33.1089, 446.524, 86.6298>, <37.6173, 443.1815, 89.3598>, <33.4852, 447.6974, 88.14> }
					triangle { <37.6173, 443.1815, 89.3598>, <33.1089, 446.524, 86.6298>, <37.6123, 442.8897, 88.863> }
					triangle { <36.9719, 442.0929, 89.2111>, <35.9584, 440.9868, 90.03342>, <35.5878, 440.8235, 90.756> }
					triangle { <36.9719, 442.0929, 89.2111>, <37.4963, 442.4848, 88.47>, <35.9584, 440.9868, 90.03342> }
					triangle { <36.9719, 442.0929, 89.2111>, <37.6123, 442.8897, 88.863>, <37.4963, 442.4848, 88.47> }
					triangle { <35.5878, 440.8235, 90.756>, <37.6123, 442.8897, 88.863>, <36.9719, 442.0929, 89.2111> }
					triangle { <33.07189, 445.317, 85.09982>, <33.9303, 443.6118, 85.7133>, <37.4963, 442.4848, 88.47> }
					triangle { <33.1089, 446.524, 86.6298>, <32.6334, 447.1389, 86.2735>, <33.07189, 445.317, 85.09982> }
					triangle { <33.07189, 445.317, 85.09982>, <37.4963, 442.4848, 88.47>, <33.1089, 446.524, 86.6298> }
					triangle { <37.6123, 442.8897, 88.863>, <33.1089, 446.524, 86.6298>, <37.4963, 442.4848, 88.47> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <35.5878, 440.8235, 90.756>, <36.3432, 441.1209, 90.5913>, <37.2284, 442.1823, 89.583> }
					triangle { <36.3432, 441.1209, 90.5913>, <38.00944, 442.6635, 89.2138>, <37.2284, 442.1823, 89.583> }
					triangle { <38.00944, 442.6635, 89.2138>, <37.6123, 442.8897, 88.863>, <37.2284, 442.1823, 89.583> }
					triangle { <37.2284, 442.1823, 89.583>, <37.6123, 442.8897, 88.863>, <35.5878, 440.8235, 90.756> }
					triangle { <38.00944, 442.6635, 89.2138>, <38.9676, 445.3124, 92.9569>, <38.7496, 447.2953, 93.3314> }
					triangle { <38.7496, 447.2953, 93.3314>, <37.2089, 448.6786, 92.8476>, <37.1264, 447.9238, 92.4544> }
					triangle { <37.1264, 447.9238, 92.4544>, <38.00944, 442.6635, 89.2138>, <38.7496, 447.2953, 93.3314> }
					triangle { <38.00944, 442.6635, 89.2138>, <37.1264, 447.9238, 92.4544>, <37.6123, 442.8897, 88.863> }
					triangle { <36.7759, 442.3518, 89.2841>, <35.6643, 441.3753, 90.1429>, <35.5878, 440.8235, 90.756> }
					triangle { <36.7759, 442.3518, 89.2841>, <37.1042, 443.0027, 88.616>, <35.6643, 441.3753, 90.1429> }
					triangle { <36.7759, 442.3518, 89.2841>, <37.6123, 442.8897, 88.863>, <37.1042, 443.0027, 88.616> }
					triangle { <35.5878, 440.8235, 90.756>, <37.6123, 442.8897, 88.863>, <36.7759, 442.3518, 89.2841> }
					triangle { <35.657, 448.4541, 91.2887>, <35.04524, 446.782, 90.3661>, <37.1042, 443.0027, 88.616> }
					triangle { <37.1264, 447.9238, 92.4544>, <37.2089, 448.6786, 92.8476>, <35.657, 448.4541, 91.2887> }
					triangle { <35.657, 448.4541, 91.2887>, <37.1042, 443.0027, 88.616>, <37.1264, 447.9238, 92.4544> }
					triangle { <37.6123, 442.8897, 88.863>, <37.1264, 447.9238, 92.4544>, <37.1042, 443.0027, 88.616> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <35.5878, 440.8235, 90.756>, <36.1639, 440.9077, 90.1667>, <37.1089, 442.0401, 89.3> }
					triangle { <36.1639, 440.9077, 90.1667>, <37.7703, 442.3792, 88.6478>, <37.1089, 442.0401, 89.3> }
					triangle { <37.7703, 442.3792, 88.6478>, <37.6123, 442.8897, 88.863>, <37.1089, 442.0401, 89.3> }
					triangle { <37.1089, 442.0401, 89.3>, <37.6123, 442.8897, 88.863>, <35.5878, 440.8235, 90.756> }
					triangle { <37.7703, 442.3792, 88.6478>, <41.6166, 440.5887, 90.6339>, <43.1609, 441.4302, 91.6473> }
					triangle { <43.1609, 441.4302, 91.6473>, <43.2405, 442.9905, 93.08963>, <42.478, 442.9145, 92.7101> }
					triangle { <42.478, 442.9145, 92.7101>, <37.7703, 442.3792, 88.6478>, <43.1609, 441.4302, 91.6473> }
					triangle { <37.7703, 442.3792, 88.6478>, <42.478, 442.9145, 92.7101>, <37.6123, 442.8897, 88.863> }
					triangle { <36.8954, 442.494, 89.5671>, <35.8436, 441.5885, 90.5674>, <35.5878, 440.8235, 90.756> }
					triangle { <36.8954, 442.494, 89.5671>, <37.3433, 443.287, 89.182>, <35.8436, 441.5885, 90.5674> }
					triangle { <36.8954, 442.494, 89.5671>, <37.6123, 442.8897, 88.863>, <37.3433, 443.287, 89.182> }
					triangle { <35.5878, 440.8235, 90.756>, <37.6123, 442.8897, 88.863>, <36.8954, 442.494, 89.5671> }
					triangle { <41.702, 444.5318, 93.4725>, <39.7663, 444.5224, 92.9488>, <37.3433, 443.287, 89.182> }
					triangle { <42.478, 442.9145, 92.7101>, <43.2405, 442.9905, 93.08963>, <41.702, 444.5318, 93.4725> }
					triangle { <41.702, 444.5318, 93.4725>, <37.3433, 443.287, 89.182>, <42.478, 442.9145, 92.7101> }
					triangle { <37.6123, 442.8897, 88.863>, <42.478, 442.9145, 92.7101>, <37.3433, 443.287, 89.182> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <23.305, 426.2462, 99.1914>, <24.7494, 428.1021, 99.08307>, 0.2999 }
			cylinder { <24.7494, 428.1021, 99.08307>, <26.1911, 429.9435, 98.812>, 0.2999 }
			cylinder { <26.1911, 429.9435, 98.812>, <27.6234, 431.7612, 98.3796>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <27.6234, 431.7612, 98.3796>, <31.0377, 437.9393, 98.1406>, 0.2999 }
				cylinder { <31.0377, 437.9393, 98.1406>, <33.4035, 444.542, 98.9716>, 0.2999 }
				cylinder { <33.4035, 444.542, 98.9716>, <34.606, 451.2484, 100.8321>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <34.606, 451.2484, 100.8321>, <34.5426, 451.9302, 101.2982>, <34.9471, 453.5897, 101.3939> }
					triangle { <34.5426, 451.9302, 101.2982>, <34.9984, 454.5045, 101.7659>, <34.9471, 453.5897, 101.3939> }
					triangle { <34.9984, 454.5045, 101.7659>, <35.2886, 454.6078, 101.2791>, <34.9471, 453.5897, 101.3939> }
					triangle { <34.9471, 453.5897, 101.3939>, <35.2886, 454.6078, 101.2791>, <34.606, 451.2484, 100.8321> }
					triangle { <34.9984, 454.5045, 101.7659>, <30.441, 455.5606, 101.5207>, <29.3811, 456.8123, 100.3249> }
					triangle { <29.3811, 456.8123, 100.3249>, <29.5131, 457.2566, 98.2497>, <30.1687, 456.7921, 98.5421> }
					triangle { <30.1687, 456.7921, 98.5421>, <34.9984, 454.5045, 101.7659>, <29.3811, 456.8123, 100.3249> }
					triangle { <34.9984, 454.5045, 101.7659>, <30.1687, 456.7921, 98.5421>, <35.2886, 454.6078, 101.2791> }
					triangle { <35.2187, 453.601, 100.8949>, <34.95, 451.9471, 100.5496>, <34.606, 451.2484, 100.8321> }
					triangle { <35.2187, 453.601, 100.8949>, <35.5415, 454.5269, 100.7678>, <34.95, 451.9471, 100.5496> }
					triangle { <35.2187, 453.601, 100.8949>, <35.2886, 454.6078, 101.2791>, <35.5415, 454.5269, 100.7678> }
					triangle { <34.606, 451.2484, 100.8321>, <35.2886, 454.6078, 101.2791>, <35.2187, 453.601, 100.8949> }
					triangle { <31.237, 456.8891, 96.9146>, <32.7947, 455.658, 97.1954>, <35.5415, 454.5269, 100.7678> }
					triangle { <30.1687, 456.7921, 98.5421>, <29.5131, 457.2566, 98.2497>, <31.237, 456.8891, 96.9146> }
					triangle { <31.237, 456.8891, 96.9146>, <35.5415, 454.5269, 100.7678>, <30.1687, 456.7921, 98.5421> }
					triangle { <35.2886, 454.6078, 101.2791>, <30.1687, 456.7921, 98.5421>, <35.5415, 454.5269, 100.7678> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <34.606, 451.2484, 100.8321>, <35.02884, 451.8408, 101.2277>, <35.2713, 453.5301, 101.3469> }
					triangle { <35.02884, 451.8408, 101.2277>, <35.6466, 454.3853, 101.6719>, <35.2713, 453.5301, 101.3469> }
					triangle { <35.6466, 454.3853, 101.6719>, <35.2886, 454.6078, 101.2791>, <35.2713, 453.5301, 101.3469> }
					triangle { <35.2713, 453.5301, 101.3469>, <35.2886, 454.6078, 101.2791>, <34.606, 451.2484, 100.8321> }
					triangle { <35.6466, 454.3853, 101.6719>, <33.8739, 454.2661, 106.0064>, <32.4, 455.3213, 106.9197> }
					triangle { <32.4, 455.3213, 106.9197>, <30.4977, 455.9923, 106.247>, <30.9917, 455.6827, 105.6215> }
					triangle { <30.9917, 455.6827, 105.6215>, <35.6466, 454.3853, 101.6719>, <32.4, 455.3213, 106.9197> }
					triangle { <35.6466, 454.3853, 101.6719>, <30.9917, 455.6827, 105.6215>, <35.2886, 454.6078, 101.2791> }
					triangle { <34.8946, 453.6606, 100.9419>, <34.4638, 452.0365, 100.6202>, <34.606, 451.2484, 100.8321> }
					triangle { <34.8946, 453.6606, 100.9419>, <34.8933, 454.6461, 100.8619>, <34.4638, 452.0365, 100.6202> }
					triangle { <34.8946, 453.6606, 100.9419>, <35.2886, 454.6078, 101.2791>, <34.8933, 454.6461, 100.8619> }
					triangle { <34.606, 451.2484, 100.8321>, <35.2886, 454.6078, 101.2791>, <34.8946, 453.6606, 100.9419> }
					triangle { <29.826, 456.2126, 104.152>, <30.6094, 455.3966, 102.4962>, <34.8933, 454.6461, 100.8619> }
					triangle { <30.9917, 455.6827, 105.6215>, <30.4977, 455.9923, 106.247>, <29.826, 456.2126, 104.152> }
					triangle { <29.826, 456.2126, 104.152>, <34.8933, 454.6461, 100.8619>, <30.9917, 455.6827, 105.6215> }
					triangle { <35.2886, 454.6078, 101.2791>, <30.9917, 455.6827, 105.6215>, <34.8933, 454.6461, 100.8619> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <34.606, 451.2484, 100.8321>, <35.1272, 451.8857, 100.7402>, <35.3369, 453.56, 101.0219> }
					triangle { <35.1272, 451.8857, 100.7402>, <35.7778, 454.4451, 101.0219>, <35.3369, 453.56, 101.0219> }
					triangle { <35.7778, 454.4451, 101.0219>, <35.2886, 454.6078, 101.2791>, <35.3369, 453.56, 101.0219> }
					triangle { <35.3369, 453.56, 101.0219>, <35.2886, 454.6078, 101.2791>, <34.606, 451.2484, 100.8321> }
					triangle { <35.7778, 454.4451, 101.0219>, <39.2487, 453.4406, 104.0033>, <39.6149, 453.9878, 105.9233> }
					triangle { <39.6149, 453.9878, 105.9233>, <38.3409, 454.2172, 107.6101>, <37.9181, 454.1085, 106.8749> }
					triangle { <37.9181, 454.1085, 106.8749>, <35.7778, 454.4451, 101.0219>, <39.6149, 453.9878, 105.9233> }
					triangle { <35.7778, 454.4451, 101.0219>, <37.9181, 454.1085, 106.8749>, <35.2886, 454.6078, 101.2791> }
					triangle { <34.829, 453.6306, 101.2669>, <34.3654, 451.9916, 101.1077>, <34.606, 451.2484, 100.8321> }
					triangle { <34.829, 453.6306, 101.2669>, <34.7621, 454.5863, 101.5118>, <34.3654, 451.9916, 101.1077> }
					triangle { <34.829, 453.6306, 101.2669>, <35.2886, 454.6078, 101.2791>, <34.7621, 454.5863, 101.5118> }
					triangle { <34.606, 451.2484, 100.8321>, <35.2886, 454.6078, 101.2791>, <34.829, 453.6306, 101.2669> }
					triangle { <36.1443, 454.4703, 107.5972>, <34.8469, 454.0524, 106.1264>, <34.7621, 454.5863, 101.5118> }
					triangle { <37.9181, 454.1085, 106.8749>, <38.3409, 454.2172, 107.6101>, <36.1443, 454.4703, 107.5972> }
					triangle { <36.1443, 454.4703, 107.5972>, <34.7621, 454.5863, 101.5118>, <37.9181, 454.1085, 106.8749> }
					triangle { <35.2886, 454.6078, 101.2791>, <37.9181, 454.1085, 106.8749>, <34.7621, 454.5863, 101.5118> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <34.606, 451.2484, 100.8321>, <34.7028, 452.0032, 100.5049>, <35.05395, 453.6384, 100.865> }
					triangle { <34.7028, 452.0032, 100.5049>, <35.2119, 454.6019, 100.7082>, <35.05395, 453.6384, 100.865> }
					triangle { <35.2119, 454.6019, 100.7082>, <35.2886, 454.6078, 101.2791>, <35.05395, 453.6384, 100.865> }
					triangle { <35.05395, 453.6384, 100.865>, <35.2886, 454.6078, 101.2791>, <34.606, 451.2484, 100.8321> }
					triangle { <35.2119, 454.6019, 100.7082>, <39.1878, 454.2171, 98.2608>, <41.1225, 454.6423, 98.7034> }
					triangle { <41.1225, 454.6423, 98.7034>, <42.2768, 454.3679, 100.468>, <41.4406, 454.2302, 100.5818> }
					triangle { <41.4406, 454.2302, 100.5818>, <35.2119, 454.6019, 100.7082>, <41.1225, 454.6423, 98.7034> }
					triangle { <35.2119, 454.6019, 100.7082>, <41.4406, 454.2302, 100.5818>, <35.2886, 454.6078, 101.2791> }
					triangle { <35.1119, 453.5522, 101.4238>, <34.7898, 451.874, 101.343>, <34.606, 451.2484, 100.8321> }
					triangle { <35.1119, 453.5522, 101.4238>, <35.328, 454.4296, 101.8256>, <34.7898, 451.874, 101.343> }
					triangle { <35.1119, 453.5522, 101.4238>, <35.2886, 454.6078, 101.2791>, <35.328, 454.4296, 101.8256> }
					triangle { <34.606, 451.2484, 100.8321>, <35.2886, 454.6078, 101.2791>, <35.1119, 453.5522, 101.4238> }
					triangle { <41.5191, 454.0536, 102.5214>, <39.6908, 453.4705, 103.1031>, <35.328, 454.4296, 101.8256> }
					triangle { <41.4406, 454.2302, 100.5818>, <42.2768, 454.3679, 100.468>, <41.5191, 454.0536, 102.5214> }
					triangle { <41.5191, 454.0536, 102.5214>, <35.328, 454.4296, 101.8256>, <41.4406, 454.2302, 100.5818> }
					triangle { <35.2886, 454.6078, 101.2791>, <41.4406, 454.2302, 100.5818>, <35.328, 454.4296, 101.8256> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <34.606, 451.2484, 100.8321>, <34.336, 452.0312, 100.855>, <34.8094, 453.657, 101.0984> }
					triangle { <34.336, 452.0312, 100.855>, <34.7229, 454.6391, 101.1749>, <34.8094, 453.657, 101.0984> }
					triangle { <34.7229, 454.6391, 101.1749>, <35.2886, 454.6078, 101.2791>, <34.8094, 453.657, 101.0984> }
					triangle { <34.8094, 453.657, 101.0984>, <35.2886, 454.6078, 101.2791>, <34.606, 451.2484, 100.8321> }
					triangle { <34.7229, 454.6391, 101.1749>, <33.6622, 455.5472, 96.7033>, <34.7022, 456.4143, 95.1912> }
					triangle { <34.7022, 456.4143, 95.1912>, <36.7386, 456.2747, 94.5956>, <36.579, 455.9138, 95.3541> }
					triangle { <36.579, 455.9138, 95.3541>, <34.7229, 454.6391, 101.1749>, <34.7022, 456.4143, 95.1912> }
					triangle { <34.7229, 454.6391, 101.1749>, <36.579, 455.9138, 95.3541>, <35.2886, 454.6078, 101.2791> }
					triangle { <35.3565, 453.5336, 101.1904>, <35.1566, 451.8461, 100.9929>, <34.606, 451.2484, 100.8321> }
					triangle { <35.3565, 453.5336, 101.1904>, <35.817, 454.3923, 101.3588>, <35.1566, 451.8461, 100.9929> }
					triangle { <35.3565, 453.5336, 101.1904>, <35.2886, 454.6078, 101.2791>, <35.817, 454.3923, 101.3588> }
					triangle { <34.606, 451.2484, 100.8321>, <35.2886, 454.6078, 101.2791>, <35.3565, 453.5336, 101.1904> }
					triangle { <38.4404, 455.5711, 95.8195>, <38.4033, 454.4778, 97.5001>, <35.817, 454.3923, 101.3588> }
					triangle { <36.579, 455.9138, 95.3541>, <36.7386, 456.2747, 94.5956>, <38.4404, 455.5711, 95.8195> }
					triangle { <38.4404, 455.5711, 95.8195>, <35.817, 454.3923, 101.3588>, <36.579, 455.9138, 95.3541> }
					triangle { <35.2886, 454.6078, 101.2791>, <36.579, 455.9138, 95.3541>, <35.817, 454.3923, 101.3588> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <27.6234, 431.7612, 98.3796>, <28.975, 433.6625, 98.06219>, 0.2999 }
			cylinder { <28.975, 433.6625, 98.06219>, <30.2395, 435.6382, 97.8611>, 0.2999 }
			cylinder { <30.2395, 435.6382, 97.8611>, <31.4105, 437.6788, 97.7773>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <31.4105, 437.6788, 97.7773>, <36.1797, 442.8811, 97.5052>, 0.2999 }
				cylinder { <36.1797, 442.8811, 97.5052>, <41.9732, 446.9109, 97.226>, 0.2999 }
				cylinder { <41.9732, 446.9109, 97.226>, <48.5097, 449.5724, 96.9531>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <48.5097, 449.5724, 96.9531>, <49.2866, 449.5226, 96.7959>, <50.7131, 450.3296, 96.8623> }
					triangle { <49.2866, 449.5226, 96.7959>, <51.6421, 450.4891, 96.7609>, <50.7131, 450.3296, 96.8623> }
					triangle { <51.6421, 450.4891, 96.7609>, <51.5106, 450.9797, 96.978>, <50.7131, 450.3296, 96.8623> }
					triangle { <50.7131, 450.3296, 96.8623>, <51.5106, 450.9797, 96.978>, <48.5097, 449.5724, 96.9531> }
					triangle { <51.6421, 450.4891, 96.7609>, <53.1184, 447.5016, 99.7724>, <53.9174, 447.6916, 101.5367> }
					triangle { <53.9174, 447.6916, 101.5367>, <53.5167, 448.9463, 103.0929>, <53.1269, 449.1481, 102.4005> }
					triangle { <53.1269, 449.1481, 102.4005>, <51.6421, 450.4891, 96.7609>, <53.9174, 447.6916, 101.5367> }
					triangle { <51.6421, 450.4891, 96.7609>, <53.1269, 449.1481, 102.4005>, <51.5106, 450.9797, 96.978> }
					triangle { <50.4993, 450.7816, 97.07875>, <48.9659, 450.2006, 97.1205>, <48.5097, 449.5724, 96.9531> }
					triangle { <50.4993, 450.7816, 97.07875>, <51.2146, 451.3932, 97.1937>, <48.9659, 450.2006, 97.1205> }
					triangle { <50.4993, 450.7816, 97.07875>, <51.5106, 450.9797, 96.978>, <51.2146, 451.3932, 97.1937> }
					triangle { <48.5097, 449.5724, 96.9531>, <51.5106, 450.9797, 96.978>, <50.4993, 450.7816, 97.07875> }
					triangle { <52.4565, 450.7805, 103.0156>, <51.2656, 451.4193, 101.648>, <51.2146, 451.3932, 97.1937> }
					triangle { <53.1269, 449.1481, 102.4005>, <53.5167, 448.9463, 103.0929>, <52.4565, 450.7805, 103.0156> }
					triangle { <52.4565, 450.7805, 103.0156>, <51.2146, 451.3932, 97.1937>, <53.1269, 449.1481, 102.4005> }
					triangle { <51.5106, 450.9797, 96.978>, <53.1269, 449.1481, 102.4005>, <51.2146, 451.3932, 97.1937> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <48.5097, 449.5724, 96.9531>, <49.1136, 449.8959, 96.5512>, <50.5977, 450.5785, 96.6992> }
					triangle { <49.1136, 449.8959, 96.5512>, <51.4114, 450.9869, 96.4347>, <50.5977, 450.5785, 96.6992> }
					triangle { <51.4114, 450.9869, 96.4347>, <51.5106, 450.9797, 96.978>, <50.5977, 450.5785, 96.6992> }
					triangle { <50.5977, 450.5785, 96.6992>, <51.5106, 450.9797, 96.978>, <48.5097, 449.5724, 96.9531> }
					triangle { <51.4114, 450.9869, 96.4347>, <53.1663, 447.498, 94.2164>, <54.6347, 446.2847, 94.6152> }
					triangle { <54.6347, 446.2847, 94.6152>, <55.2403, 445.3906, 96.3444>, <54.6681, 445.967, 96.4565> }
					triangle { <54.6681, 445.967, 96.4565>, <51.4114, 450.9869, 96.4347>, <54.6347, 446.2847, 94.6152> }
					triangle { <51.4114, 450.9869, 96.4347>, <54.6681, 445.967, 96.4565>, <51.5106, 450.9797, 96.978> }
					triangle { <50.6147, 450.5327, 97.2418>, <49.139, 449.8273, 97.3652>, <48.5097, 449.5724, 96.9531> }
					triangle { <50.6147, 450.5327, 97.2418>, <51.4453, 450.8954, 97.52>, <49.139, 449.8273, 97.3652> }
					triangle { <50.6147, 450.5327, 97.2418>, <51.5106, 450.9797, 96.978>, <51.4453, 450.8954, 97.52> }
					triangle { <48.5097, 449.5724, 96.9531>, <51.5106, 450.9797, 96.978>, <50.6147, 450.5327, 97.2418> }
					triangle { <54.7506, 445.9719, 98.3235>, <53.3133, 447.1013, 98.9196>, <51.4453, 450.8954, 97.52> }
					triangle { <54.6681, 445.967, 96.4565>, <55.2403, 445.3906, 96.3444>, <54.7506, 445.9719, 98.3235> }
					triangle { <54.7506, 445.9719, 98.3235>, <51.4453, 450.8954, 97.52>, <54.6681, 445.967, 96.4565> }
					triangle { <51.5106, 450.9797, 96.978>, <54.6681, 445.967, 96.4565>, <51.4453, 450.8954, 97.52> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <48.5097, 449.5724, 96.9531>, <48.958, 450.2222, 96.8652>, <50.494, 450.796, 96.9085> }
					triangle { <48.958, 450.2222, 96.8652>, <51.2039, 451.4219, 96.8533>, <50.494, 450.796, 96.9085> }
					triangle { <51.2039, 451.4219, 96.8533>, <51.5106, 450.9797, 96.978>, <50.494, 450.796, 96.9085> }
					triangle { <50.494, 450.796, 96.9085>, <51.5106, 450.9797, 96.978>, <48.5097, 449.5724, 96.9531> }
					triangle { <51.2039, 451.4219, 96.8533>, <50.9415, 452.2735, 92.4511>, <52.07943, 451.7987, 90.9454> }
					triangle { <52.07943, 451.7987, 90.9454>, <53.08575, 450.0889, 90.476>, <52.778, 450.0899, 91.2359> }
					triangle { <52.778, 450.0899, 91.2359>, <51.2039, 451.4219, 96.8533>, <52.07943, 451.7987, 90.9454> }
					triangle { <51.2039, 451.4219, 96.8533>, <52.778, 450.0899, 91.2359>, <51.5106, 450.9797, 96.978> }
					triangle { <50.7184, 450.3152, 97.03256>, <49.2946, 449.501, 97.05127>, <48.5097, 449.5724, 96.9531> }
					triangle { <50.7184, 450.3152, 97.03256>, <51.6528, 450.4604, 97.1014>, <49.2946, 449.501, 97.05127> }
					triangle { <50.7184, 450.3152, 97.03256>, <51.5106, 450.9797, 96.978>, <51.6528, 450.4604, 97.1014> }
					triangle { <48.5097, 449.5724, 96.9531>, <51.5106, 450.9797, 96.978>, <50.7184, 450.3152, 97.03256> }
					triangle { <53.613, 448.5135, 91.793>, <52.8865, 448.1069, 93.5261>, <51.6528, 450.4604, 97.1014> }
					triangle { <52.778, 450.0899, 91.2359>, <53.08575, 450.0889, 90.476>, <53.613, 448.5135, 91.793> }
					triangle { <53.613, 448.5135, 91.793>, <51.6528, 450.4604, 97.1014>, <52.778, 450.0899, 91.2359> }
					triangle { <51.5106, 450.9797, 96.978>, <52.778, 450.0899, 91.2359>, <51.6528, 450.4604, 97.1014> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <48.5097, 449.5724, 96.9531>, <49.03345, 450.0535, 97.3068>, <50.5443, 450.6835, 97.2029> }
					triangle { <49.03345, 450.0535, 97.3068>, <51.3045, 451.197, 97.4422>, <50.5443, 450.6835, 97.2029> }
					triangle { <51.3045, 451.197, 97.4422>, <51.5106, 450.9797, 96.978>, <50.5443, 450.6835, 97.2029> }
					triangle { <50.5443, 450.6835, 97.2029>, <51.5106, 450.9797, 96.978>, <48.5097, 449.5724, 96.9531> }
					triangle { <51.3045, 451.197, 97.4422>, <49.4978, 455.2731, 96.8996>, <49.759, 456.6649, 95.5646> }
					triangle { <49.759, 456.6649, 95.5646>, <50.01049, 456.5922, 93.5428>, <50.05104, 455.8576, 93.9046> }
					triangle { <50.05104, 455.8576, 93.9046>, <51.3045, 451.197, 97.4422>, <49.759, 456.6649, 95.5646> }
					triangle { <51.3045, 451.197, 97.4422>, <50.05104, 455.8576, 93.9046>, <51.5106, 450.9797, 96.978> }
					triangle { <50.6681, 450.4277, 96.7381>, <49.2192, 449.6697, 96.6096>, <48.5097, 449.5724, 96.9531> }
					triangle { <50.6681, 450.4277, 96.7381>, <51.5522, 450.6853, 96.5125>, <49.2192, 449.6697, 96.6096> }
					triangle { <50.6681, 450.4277, 96.7381>, <51.5106, 450.9797, 96.978>, <51.5522, 450.6853, 96.5125> }
					triangle { <48.5097, 449.5724, 96.9531>, <51.5106, 450.9797, 96.978>, <50.6681, 450.4277, 96.7381> }
					triangle { <50.6052, 454.9167, 92.3881>, <50.5711, 453.0559, 92.8709>, <51.5522, 450.6853, 96.5125> }
					triangle { <50.05104, 455.8576, 93.9046>, <50.01049, 456.5922, 93.5428>, <50.6052, 454.9167, 92.3881> }
					triangle { <50.6052, 454.9167, 92.3881>, <51.5522, 450.6853, 96.5125>, <50.05104, 455.8576, 93.9046> }
					triangle { <51.5106, 450.9797, 96.978>, <50.05104, 455.8576, 93.9046>, <51.5522, 450.6853, 96.5125> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <48.5097, 449.5724, 96.9531>, <49.2396, 449.6146, 97.2634>, <50.6817, 450.3909, 97.174> }
					triangle { <49.2396, 449.6146, 97.2634>, <51.5794, 450.6118, 97.3842>, <50.6817, 450.3909, 97.174> }
					triangle { <51.5794, 450.6118, 97.3842>, <51.5106, 450.9797, 96.978>, <50.6817, 450.3909, 97.174> }
					triangle { <50.6817, 450.3909, 97.174>, <51.5106, 450.9797, 96.978>, <48.5097, 449.5724, 96.9531> }
					triangle { <51.5794, 450.6118, 97.3842>, <50.8635, 452.2794, 101.4928>, <50.9121, 454.0882, 102.2093> }
					triangle { <50.9121, 454.0882, 102.2093>, <50.2808, 455.8753, 101.4582>, <50.2699, 455.2668, 100.9089> }
					triangle { <50.2699, 455.2668, 100.9089>, <51.5794, 450.6118, 97.3842>, <50.9121, 454.0882, 102.2093> }
					triangle { <51.5794, 450.6118, 97.3842>, <50.2699, 455.2668, 100.9089>, <51.5106, 450.9797, 96.978> }
					triangle { <50.5306, 450.7203, 96.767>, <49.01302, 450.1086, 96.653>, <48.5097, 449.5724, 96.9531> }
					triangle { <50.5306, 450.7203, 96.767>, <51.2773, 451.2705, 96.5704>, <49.01302, 450.1086, 96.653> }
					triangle { <50.5306, 450.7203, 96.767>, <51.5106, 450.9797, 96.978>, <51.2773, 451.2705, 96.5704> }
					triangle { <48.5097, 449.5724, 96.9531>, <51.5106, 450.9797, 96.978>, <50.5306, 450.7203, 96.767> }
					triangle { <49.8797, 456.3389, 99.4287>, <49.5542, 455.134, 97.9662>, <51.2773, 451.2705, 96.5704> }
					triangle { <50.2699, 455.2668, 100.9089>, <50.2808, 455.8753, 101.4582>, <49.8797, 456.3389, 99.4287> }
					triangle { <49.8797, 456.3389, 99.4287>, <51.2773, 451.2705, 96.5704>, <50.2699, 455.2668, 100.9089> }
					triangle { <51.5106, 450.9797, 96.978>, <50.2699, 455.2668, 100.9089>, <51.2773, 451.2705, 96.5704> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <10.9425, 409.1895, 100.7774>, <10.7088, 411.376, 101.6184>, 0.2999 }
			cylinder { <10.7088, 411.376, 101.6184>, <10.618, 413.5988, 102.3888>, 0.2999 }
			cylinder { <10.618, 413.5988, 102.3888>, <10.6705, 415.8471, 103.0852>, 0.2999 }
			material { txphlox_inflor }}
		union { // inflor. internode
			cylinder { <10.6705, 415.8471, 103.0852>, <8.9623, 417.467, 103.0596>, 0.2999 }
			cylinder { <8.9623, 417.467, 103.0596>, <7.1535, 418.9716, 102.9766>, 0.2999 }
			cylinder { <7.1535, 418.9716, 102.9766>, <5.2529, 420.3539, 102.8365>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.2529, 420.3539, 102.8365>, <0.0002761, 424.9694, 103.8313>, 0.2999 }
				cylinder { <0.0002761, 424.9694, 103.8313>, <-4.548, 429.8292, 106.1929>, 0.2999 }
				cylinder { <-4.548, 429.8292, 106.1929>, <-8.171, 434.6972, 109.8066>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-8.171, 434.6972, 109.8066>, <-8.03314, 435.3358, 110.316>, <-8.7785, 436.6162, 111.1713> }
					triangle { <-8.03314, 435.3358, 110.316>, <-8.8571, 437.4062, 111.7609>, <-8.7785, 436.6162, 111.1713> }
					triangle { <-8.8571, 437.4062, 111.7609>, <-9.4164, 437.356, 111.6318>, <-8.7785, 436.6162, 111.1713> }
					triangle { <-8.7785, 436.6162, 111.1713>, <-9.4164, 437.356, 111.6318>, <-8.171, 434.6972, 109.8066> }
					triangle { <-8.8571, 437.4062, 111.7609>, <-7.6432, 435.3361, 115.7841>, <-8.6998, 434.8149, 117.4369> }
					triangle { <-8.6998, 434.8149, 117.4369>, <-10.6398, 433.981, 117.6868>, <-10.4781, 434.2364, 116.8869> }
					triangle { <-10.4781, 434.2364, 116.8869>, <-8.8571, 437.4062, 111.7609>, <-8.6998, 434.8149, 117.4369> }
					triangle { <-8.8571, 437.4062, 111.7609>, <-10.4781, 434.2364, 116.8869>, <-9.4164, 437.356, 111.6318> }
					triangle { <-9.3036, 436.4932, 110.9922>, <-8.8208, 435.1513, 110.0473>, <-8.171, 434.6972, 109.8066> }
					triangle { <-9.3036, 436.4932, 110.9922>, <-9.9074, 437.1602, 111.4027>, <-8.8208, 435.1513, 110.0473> }
					triangle { <-9.3036, 436.4932, 110.9922>, <-9.4164, 437.356, 111.6318>, <-9.9074, 437.1602, 111.4027> }
					triangle { <-8.171, 434.6972, 109.8066>, <-9.4164, 437.356, 111.6318>, <-9.3036, 436.4932, 110.9922> }
					triangle { <-12.2881, 433.9744, 116.213>, <-12.1941, 434.2701, 114.2318>, <-9.9074, 437.1602, 111.4027> }
					triangle { <-10.4781, 434.2364, 116.8869>, <-10.6398, 433.981, 117.6868>, <-12.2881, 433.9744, 116.213> }
					triangle { <-12.2881, 433.9744, 116.213>, <-9.9074, 437.1602, 111.4027>, <-10.4781, 434.2364, 116.8869> }
					triangle { <-9.4164, 437.356, 111.6318>, <-10.4781, 434.2364, 116.8869>, <-9.9074, 437.1602, 111.4027> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-8.171, 434.6972, 109.8066>, <-8.2515, 435.5159, 109.9046>, <-8.9241, 436.7363, 110.897> }
					triangle { <-8.2515, 435.5159, 109.9046>, <-9.1484, 437.6463, 111.2124>, <-8.9241, 436.7363, 110.897> }
					triangle { <-9.1484, 437.6463, 111.2124>, <-9.4164, 437.356, 111.6318>, <-8.9241, 436.7363, 110.897> }
					triangle { <-8.9241, 436.7363, 110.897>, <-9.4164, 437.356, 111.6318>, <-8.171, 434.6972, 109.8066> }
					triangle { <-9.1484, 437.6463, 111.2124>, <-4.8153, 439.0316, 112.3303>, <-3.8892, 439.3537, 114.1075> }
					triangle { <-3.8892, 439.3537, 114.1075>, <-3.944, 438.3051, 115.9565>, <-4.5352, 438.0427, 115.3972> }
					triangle { <-4.5352, 438.0427, 115.3972>, <-9.1484, 437.6463, 111.2124>, <-3.8892, 439.3537, 114.1075> }
					triangle { <-9.1484, 437.6463, 111.2124>, <-4.5352, 438.0427, 115.3972>, <-9.4164, 437.356, 111.6318> }
					triangle { <-9.158, 436.3732, 111.2664>, <-8.6023, 434.9713, 110.4586>, <-8.171, 434.6972, 109.8066> }
					triangle { <-9.158, 436.3732, 111.2664>, <-9.6161, 436.9201, 111.9511>, <-8.6023, 434.9713, 110.4586> }
					triangle { <-9.158, 436.3732, 111.2664>, <-9.4164, 437.356, 111.6318>, <-9.6161, 436.9201, 111.9511> }
					triangle { <-8.171, 434.6972, 109.8066>, <-9.4164, 437.356, 111.6318>, <-9.158, 436.3732, 111.2664> }
					triangle { <-5.4872, 436.8726, 116.6315>, <-6.842, 435.8848, 115.5314>, <-9.6161, 436.9201, 111.9511> }
					triangle { <-4.5352, 438.0427, 115.3972>, <-3.944, 438.3051, 115.9565>, <-5.4872, 436.8726, 116.6315> }
					triangle { <-5.4872, 436.8726, 116.6315>, <-9.6161, 436.9201, 111.9511>, <-4.5352, 438.0427, 115.3972> }
					triangle { <-9.4164, 437.356, 111.6318>, <-4.5352, 438.0427, 115.3972>, <-9.6161, 436.9201, 111.9511> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-8.171, 434.6972, 109.8066>, <-8.7107, 435.3221, 109.8735>, <-9.2303, 436.6071, 110.8763> }
					triangle { <-8.7107, 435.3221, 109.8735>, <-9.7607, 437.388, 111.171>, <-9.2303, 436.6071, 110.8763> }
					triangle { <-9.7607, 437.388, 111.171>, <-9.4164, 437.356, 111.6318>, <-9.2303, 436.6071, 110.8763> }
					triangle { <-9.2303, 436.6071, 110.8763>, <-9.4164, 437.356, 111.6318>, <-8.171, 434.6972, 109.8066> }
					triangle { <-9.7607, 437.388, 111.171>, <-8.303, 440.4272, 107.9177>, <-7.08692, 442.0503, 107.9977> }
					triangle { <-7.08692, 442.0503, 107.9977>, <-5.275, 442.4263, 109.045>, <-5.6671, 441.7063, 109.288> }
					triangle { <-5.6671, 441.7063, 109.288>, <-9.7607, 437.388, 111.171>, <-7.08692, 442.0503, 107.9977> }
					triangle { <-9.7607, 437.388, 111.171>, <-5.6671, 441.7063, 109.288>, <-9.4164, 437.356, 111.6318> }
					triangle { <-8.8519, 436.5023, 111.2871>, <-8.1431, 435.165, 110.4898>, <-8.171, 434.6972, 109.8066> }
					triangle { <-8.8519, 436.5023, 111.2871>, <-9.003902, 437.1784, 111.9926>, <-8.1431, 435.165, 110.4898> }
					triangle { <-8.8519, 436.5023, 111.2871>, <-9.4164, 437.356, 111.6318>, <-9.003902, 437.1784, 111.9926> }
					triangle { <-8.171, 434.6972, 109.8066>, <-9.4164, 437.356, 111.6318>, <-8.8519, 436.5023, 111.2871> }
					triangle { <-4.5011, 441.3342, 110.805>, <-5.02356, 439.519, 111.4782>, <-9.003902, 437.1784, 111.9926> }
					triangle { <-5.6671, 441.7063, 109.288>, <-5.275, 442.4263, 109.045>, <-4.5011, 441.3342, 110.805> }
					triangle { <-4.5011, 441.3342, 110.805>, <-9.003902, 437.1784, 111.9926>, <-5.6671, 441.7063, 109.288> }
					triangle { <-9.4164, 437.356, 111.6318>, <-5.6671, 441.7063, 109.288>, <-9.003902, 437.1784, 111.9926> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-8.171, 434.6972, 109.8066>, <-8.7804, 435.0205, 110.2654>, <-9.2767, 436.4061, 111.1375> }
					triangle { <-8.7804, 435.0205, 110.2654>, <-9.8535, 436.9858, 111.6934>, <-9.2767, 436.4061, 111.1375> }
					triangle { <-9.8535, 436.9858, 111.6934>, <-9.4164, 437.356, 111.6318>, <-9.2767, 436.4061, 111.1375> }
					triangle { <-9.2767, 436.4061, 111.1375>, <-9.4164, 437.356, 111.6318>, <-8.171, 434.6972, 109.8066> }
					triangle { <-9.8535, 436.9858, 111.6934>, <-13.319, 437.6071, 108.6032>, <-13.9036, 439.2032, 107.4939> }
					triangle { <-13.9036, 439.2032, 107.4939>, <-12.8057, 440.6877, 106.4393>, <-12.3201, 440.1985, 106.9451> }
					triangle { <-12.3201, 440.1985, 106.9451>, <-9.8535, 436.9858, 111.6934>, <-13.9036, 439.2032, 107.4939> }
					triangle { <-9.8535, 436.9858, 111.6934>, <-12.3201, 440.1985, 106.9451>, <-9.4164, 437.356, 111.6318> }
					triangle { <-8.8054, 436.7034, 111.0259>, <-8.07354, 435.4666, 110.0979>, <-8.171, 434.6972, 109.8066> }
					triangle { <-8.8054, 436.7034, 111.0259>, <-8.911, 437.5805, 111.4702>, <-8.07354, 435.4666, 110.0979> }
					triangle { <-8.8054, 436.7034, 111.0259>, <-9.4164, 437.356, 111.6318>, <-8.911, 437.5805, 111.4702> }
					triangle { <-8.171, 434.6972, 109.8066>, <-9.4164, 437.356, 111.6318>, <-8.8054, 436.7034, 111.0259> }
					triangle { <-10.6834, 441.2351, 106.7311>, <-9.2349, 440.1842, 107.6358>, <-8.911, 437.5805, 111.4702> }
					triangle { <-12.3201, 440.1985, 106.9451>, <-12.8057, 440.6877, 106.4393>, <-10.6834, 441.2351, 106.7311> }
					triangle { <-10.6834, 441.2351, 106.7311>, <-8.911, 437.5805, 111.4702>, <-12.3201, 440.1985, 106.9451> }
					triangle { <-9.4164, 437.356, 111.6318>, <-12.3201, 440.1985, 106.9451>, <-8.911, 437.5805, 111.4702> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-8.171, 434.6972, 109.8066>, <-8.3552, 435.0291, 110.5429>, <-8.9933, 436.4118, 111.3226> }
					triangle { <-8.3552, 435.0291, 110.5429>, <-9.2867, 436.9973, 112.0635>, <-8.9933, 436.4118, 111.3226> }
					triangle { <-9.2867, 436.9973, 112.0635>, <-9.4164, 437.356, 111.6318>, <-8.9933, 436.4118, 111.3226> }
					triangle { <-8.9933, 436.4118, 111.3226>, <-9.4164, 437.356, 111.6318>, <-8.171, 434.6972, 109.8066> }
					triangle { <-9.2867, 436.9973, 112.0635>, <-12.905, 434.4132, 113.5383>, <-14.9155, 434.6641, 113.4157> }
					triangle { <-14.9155, 434.6641, 113.4157>, <-16.1714, 435.3895, 111.8608>, <-15.3383, 435.5121, 111.7124> }
					triangle { <-15.3383, 435.5121, 111.7124>, <-9.2867, 436.9973, 112.0635>, <-14.9155, 434.6641, 113.4157> }
					triangle { <-9.2867, 436.9973, 112.0635>, <-15.3383, 435.5121, 111.7124>, <-9.4164, 437.356, 111.6318> }
					triangle { <-9.0889, 436.6977, 110.8409>, <-8.4986, 435.458, 109.8203>, <-8.171, 434.6972, 109.8066> }
					triangle { <-9.0889, 436.6977, 110.8409>, <-9.4778, 437.5691, 111.1001>, <-8.4986, 435.458, 109.8203> }
					triangle { <-9.0889, 436.6977, 110.8409>, <-9.4164, 437.356, 111.6318>, <-9.4778, 437.5691, 111.1001> }
					triangle { <-8.171, 434.6972, 109.8066>, <-9.4164, 437.356, 111.6318>, <-9.0889, 436.6977, 110.8409> }
					triangle { <-15.5687, 436.6179, 110.1239>, <-13.7335, 436.8912, 109.3633>, <-9.4778, 437.5691, 111.1001> }
					triangle { <-15.3383, 435.5121, 111.7124>, <-16.1714, 435.3895, 111.8608>, <-15.5687, 436.6179, 110.1239> }
					triangle { <-15.5687, 436.6179, 110.1239>, <-9.4778, 437.5691, 111.1001>, <-15.3383, 435.5121, 111.7124> }
					triangle { <-9.4164, 437.356, 111.6318>, <-15.3383, 435.5121, 111.7124>, <-9.4778, 437.5691, 111.1001> }
					material { txphlox_flower }}
				}
			}
		union { // inflor. internode
			cylinder { <5.2529, 420.3539, 102.8365>, <3.394, 421.7986, 102.8415>, 0.2999 }
			cylinder { <3.394, 421.7986, 102.8415>, <1.5857, 423.2985, 102.9916>, 0.2999 }
			cylinder { <1.5857, 423.2985, 102.9916>, <-0.1635, 424.8463, 103.2863>, 0.2999 }
			material { txphlox_inflor }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.1635, 424.8463, 103.2863>, <-5.1109, 429.8509, 102.686>, 0.2999 }
				cylinder { <-5.1109, 429.8509, 102.686>, <-9.5176, 434.9732, 100.6304>, 0.2999 }
				cylinder { <-9.5176, 434.9732, 100.6304>, <-13.1694, 439.9644, 97.2193>, 0.2999 }
				material { txphlox_pedicel }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.1694, 439.9644, 97.2193>, <-13.4441, 440.4165, 96.5818>, <-14.3505, 441.8017, 96.15> }
					triangle { <-13.4441, 440.4165, 96.5818>, <-14.777, 442.4777, 95.5679>, <-14.3505, 441.8017, 96.15> }
					triangle { <-14.777, 442.4777, 95.5679>, <-14.9462, 442.6991, 96.07223>, <-14.3505, 441.8017, 96.15> }
					triangle { <-14.3505, 441.8017, 96.15>, <-14.9462, 442.6991, 96.07223>, <-13.1694, 439.9644, 97.2193> }
					triangle { <-14.777, 442.4777, 95.5679>, <-10.8713, 444.4174, 93.8568>, <-9.9735, 446.2104, 94.1715> }
					triangle { <-9.9735, 446.2104, 94.1715>, <-9.6854, 447.3738, 95.9279>, <-10.2185, 446.7145, 96.0384> }
					triangle { <-10.2185, 446.7145, 96.0384>, <-14.777, 442.4777, 95.5679>, <-9.9735, 446.2104, 94.1715> }
					triangle { <-14.777, 442.4777, 95.5679>, <-10.2185, 446.7145, 96.0384>, <-14.9462, 442.6991, 96.07223> }
					triangle { <-14.471, 441.9481, 96.6857>, <-13.6249, 440.6361, 97.3854>, <-13.1694, 439.9644, 97.2193> }
					triangle { <-14.471, 441.9481, 96.6857>, <-15.01812, 442.7705, 96.6393>, <-13.6249, 440.6361, 97.3854> }
					triangle { <-14.471, 441.9481, 96.6857>, <-14.9462, 442.6991, 96.07223>, <-15.01812, 442.7705, 96.6393> }
					triangle { <-13.1694, 439.9644, 97.2193>, <-14.9462, 442.6991, 96.07223>, <-14.471, 441.9481, 96.6857> }
					triangle { <-10.7971, 447.2108, 97.8323>, <-11.9158, 445.6862, 98.4996>, <-15.01812, 442.7705, 96.6393> }
					triangle { <-10.2185, 446.7145, 96.0384>, <-9.6854, 447.3738, 95.9279>, <-10.7971, 447.2108, 97.8323> }
					triangle { <-10.7971, 447.2108, 97.8323>, <-15.01812, 442.7705, 96.6393>, <-10.2185, 446.7145, 96.0384> }
					triangle { <-14.9462, 442.6991, 96.07223>, <-10.2185, 446.7145, 96.0384>, <-15.01812, 442.7705, 96.6393> }
					material { txphlox_flower }}
				mesh { // flower petal
					triangle { <-13.1694, 439.9644, 97.2193>, <-13.8426, 440.2673, 96.8432>, <-14.6161, 441.7022, 96.3243> }
					triangle { <-13.8426, 440.2673, 96.8432>, <-15.3083, 442.2788, 95.9165>, <-14.6161, 441.7022, 96.3243> }
					triangle { <-15.3083, 442.2788, 95.9165>, <-14.9462, 442.6991, 96.07223>, <-14.6161, 441.7022, 96.3243> }
					triangle { <-14.6161, 441.7022, 96.3243>, <-14.9462, 442.6991, 96.07223>, <-13.1694, 439.9644, 97.2193> }
					triangle { <-15.3083, 442.2788, 95.9165>, <-14.7907, 440.873, 91.4779>, <-14.00842, 441.769, 89.8332> }
					triangle { <-14.00842, 441.769, 89.8332>, <-12.299, 443.0031, 89.5568>, <-12.4908, 442.864, 90.3784> }
					triangle { <-12.4908, 442.864, 90.3784>, <-15.3083, 442.2788, 95.9165>, <-14.00842, 441.769, 89.8332> }
					triangle { <-15.3083, 442.2788, 95.9165>, <-12.4908, 442.864, 90.3784>, <-14.9462, 442.6991, 96.07223> }
					triangle { <-14.2054, 442.0476, 96.5114>, <-13.2265, 440.7853, 97.1239>, <-13.1694, 439.9644, 97.2193> }
					triangle { <-14.2054, 442.0476, 96.5114>, <-14.4869, 442.9695, 96.2907>, <-13.2265, 440.7853, 97.1239> }
					triangle { <-14.2054, 442.0476, 96.5114>, <-14.9462, 442.6991, 96.07223>, <-14.4869, 442.9695, 96.2907> }
					triangle { <-13.1694, 439.9644, 97.2193>, <-14.9462, 442.6991, 96.07223>, <-14.2054, 442.0476, 96.5114> }
					triangle { <-11.2019, 444.1288, 91.1118>, <-11.2312, 443.8659, 93.09966>, <-14.4869, 442.9695, 96.2907> }
					triangle { <-12.4908, 442.864, 90.3784>, <-12.299, 443.0031, 89.5568>, <-11.2019, 444.1288, 91.1118> }
					triangle { <-11.2019, 444.1288, 9