// File generated by sPatch, Copyright 1996-1998 by Mike Clifton
#ifndef (IMPORT_SPATCH)
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


background { color rgb <0, 0, 0> }

camera {
	location <-2.5, 0.868, -3.235>
	look_at <1.608, -0.346, -0.022>
}

// set an overall brightness/ambient light level in the scene
global_settings { ambient_light  color red 1.0 green 0.25  }





light_source { < -100, 50, -200 > color 400000 red 0.65 green 0.49 blue 0.24 }
// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <20, 38, -40> // <x y z> position of light
  point_at <1.4, 0, -0.9>      // direction of spotlight
  radius 0.3                // hotspot (inner, in degrees)
  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 1               // intensity falloff radius (outer, in degrees)
}


#end
     
fog
{
  fog_type   1
  distance   300
  color red 0.72 green 0.45 blue 0.20
  fog_offset 0.1
  fog_alt    4
  turbulence 0.08
}    

     
global_settings{number_of_waves 30 }     
     
     
     
     
// Layer 1 

#declare cargo =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.199, 0.170, -0.670> <0.215, 0.174, -0.670> <0.263, 0.185, -0.670> <0.280, 0.188, -0.670> 
		<0.199, 0.170, -0.536> <0.215, 0.174, -0.536> <0.263, 0.185, -0.536> <0.280, 0.188, -0.536> 
		<0.199, 0.170, 0.402> <0.215, 0.174, 0.402> <0.263, 0.185, 0.402> <0.280, 0.188, 0.402> 
		<0.199, 0.170, 0.670> <0.215, 0.174, 0.670> <0.263, 0.185, 0.670> <0.280, 0.188, 0.670> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.199, 0.170, -0.670> <0.199, 0.170, -0.536> <0.199, 0.170, 0.402> <0.199, 0.170, 0.670> 
		<0.290, 0.036, -0.623> <0.290, 0.036, -0.489> <0.290, 0.036, 0.355> <0.290, 0.036, 0.623> 
		<0.564, -0.367, -0.484> <0.564, -0.367, -0.396> <0.564, -0.367, 0.309> <0.564, -0.367, 0.484> 
		<0.656, -0.501, -0.438> <0.656, -0.501, -0.350> <0.656, -0.501, 0.262> <0.656, -0.501, 0.438> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.199, 0.170, -0.670> <0.290, 0.036, -0.623> <0.564, -0.367, -0.484> <0.656, -0.501, -0.438> 
		<0.215, 0.174, -0.670> <0.306, 0.039, -0.623> <0.575, -0.364, -0.484> <0.666, -0.498, -0.438> 
		<0.263, 0.185, -0.670> <0.349, 0.049, -0.623> <0.612, -0.356, -0.484> <0.698, -0.491, -0.438> 
		<0.280, 0.188, -0.670> <0.365, 0.053, -0.623> <0.622, -0.354, -0.484> <0.708, -0.489, -0.438> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.199, 0.170, 0.670> <0.215, 0.174, 0.670> <0.263, 0.185, 0.670> <0.280, 0.188, 0.670> 
		<0.290, 0.036, 0.623> <0.306, 0.039, 0.623> <0.349, 0.049, 0.623> <0.365, 0.053, 0.623> 
		<0.564, -0.367, 0.484> <0.575, -0.364, 0.484> <0.612, -0.356, 0.484> <0.622, -0.354, 0.484> 
		<0.656, -0.501, 0.438> <0.666, -0.498, 0.438> <0.698, -0.491, 0.438> <0.708, -0.489, 0.438> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.656, -0.501, -0.438> <0.656, -0.501, -0.350> <0.656, -0.501, 0.262> <0.656, -0.501, 0.438> 
		<0.666, -0.498, -0.438> <0.666, -0.498, -0.350> <0.666, -0.498, 0.262> <0.666, -0.498, 0.438> 
		<0.698, -0.491, -0.438> <0.698, -0.491, -0.350> <0.698, -0.491, 0.262> <0.698, -0.491, 0.438> 
		<0.708, -0.489, -0.438> <0.708, -0.489, -0.350> <0.708, -0.489, 0.262> <0.708, -0.489, 0.438> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.280, 0.188, -0.670> <0.365, 0.053, -0.623> <0.622, -0.354, -0.484> <0.708, -0.489, -0.438> 
		<0.280, 0.188, -0.536> <0.365, 0.053, -0.489> <0.622, -0.354, -0.396> <0.708, -0.489, -0.350> 
		<0.280, 0.188, 0.402> <0.365, 0.053, 0.355> <0.622, -0.354, 0.309> <0.708, -0.489, 0.262> 
		<0.280, 0.188, 0.670> <0.365, 0.053, 0.623> <0.622, -0.354, 0.484> <0.708, -0.489, 0.438> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, -0.229, 0.560> <0.517, -0.282, 0.539> <0.642, -0.440, 0.474> <0.684, -0.493, 0.453> 
		<0.641, -0.228, 0.575> <0.682, -0.281, 0.553> <0.786, -0.449, 0.485> <0.828, -0.502, 0.463> 
		<1.795, -0.227, 0.674> <1.796, -0.297, 0.645> <1.837, -0.492, 0.566> <1.837, -0.563, 0.537> 
		<2.125, -0.226, 0.702> <2.126, -0.297, 0.673> <2.126, -0.509, 0.587> <2.126, -0.580, 0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, -0.229, 0.560> <0.641, -0.228, 0.575> <1.795, -0.227, 0.674> <2.125, -0.226, 0.702> 
		<0.476, -0.229, 0.560> <0.641, -0.228, 0.575> <1.795, -0.227, 0.674> <2.125, -0.226, 0.702> 
		<0.476, -0.229, 0.560> <0.641, -0.228, 0.575> <1.795, -0.227, 0.674> <2.125, -0.226, 0.702> 
		<0.476, -0.229, 0.560> <0.641, -0.228, 0.575> <1.795, -0.227, 0.674> <2.125, -0.226, 0.702> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, -0.229, 0.560> <0.476, -0.229, 0.560> <0.476, -0.229, 0.560> <0.476, -0.229, 0.560> 
		<0.517, -0.282, 0.539> <0.517, -0.282, 0.539> <0.517, -0.282, 0.539> <0.517, -0.282, 0.539> 
		<0.642, -0.440, 0.474> <0.642, -0.440, 0.474> <0.642, -0.440, 0.474> <0.642, -0.440, 0.474> 
		<0.684, -0.493, 0.453> <0.684, -0.493, 0.453> <0.684, -0.493, 0.453> <0.684, -0.493, 0.453> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.125, -0.226, 0.702> <2.126, -0.297, 0.673> <2.126, -0.509, 0.587> <2.126, -0.580, 0.558> 
		<2.125, -0.226, 0.702> <2.126, -0.297, 0.673> <2.126, -0.509, 0.587> <2.126, -0.580, 0.558> 
		<2.125, -0.226, 0.702> <2.126, -0.297, 0.673> <2.126, -0.509, 0.587> <2.126, -0.580, 0.558> 
		<2.125, -0.226, 0.702> <2.126, -0.297, 0.673> <2.126, -0.509, 0.587> <2.126, -0.580, 0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, -0.229, 0.560> <0.641, -0.228, 0.575> <1.795, -0.227, 0.674> <2.125, -0.226, 0.702> 
		<0.517, -0.282, 0.539> <0.682, -0.281, 0.553> <1.796, -0.297, 0.645> <2.126, -0.297, 0.673> 
		<0.642, -0.440, 0.474> <0.786, -0.449, 0.485> <1.837, -0.492, 0.566> <2.126, -0.509, 0.587> 
		<0.684, -0.493, 0.453> <0.828, -0.502, 0.463> <1.837, -0.563, 0.537> <2.126, -0.580, 0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.684, -0.493, 0.453> <0.684, -0.493, 0.453> <0.684, -0.493, 0.453> <0.684, -0.493, 0.453> 
		<0.828, -0.502, 0.463> <0.828, -0.502, 0.463> <0.828, -0.502, 0.463> <0.828, -0.502, 0.463> 
		<1.837, -0.563, 0.537> <1.837, -0.563, 0.537> <1.837, -0.563, 0.537> <1.837, -0.563, 0.537> 
		<2.126, -0.580, 0.558> <2.126, -0.580, 0.558> <2.126, -0.580, 0.558> <2.126, -0.580, 0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, -0.230, -0.559> <0.517, -0.283, -0.538> <0.642, -0.442, -0.475> <0.684, -0.496, -0.454> 
		<0.641, -0.229, -0.572> <0.682, -0.282, -0.551> <0.786, -0.451, -0.485> <0.828, -0.504, -0.464> 
		<1.795, -0.225, -0.665> <1.796, -0.296, -0.637> <1.837, -0.491, -0.560> <1.837, -0.562, -0.533> 
		<2.125, -0.223, -0.692> <2.126, -0.294, -0.664> <2.126, -0.508, -0.580> <2.126, -0.579, -0.552> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, -0.230, -0.559> <0.641, -0.229, -0.572> <1.795, -0.225, -0.665> <2.125, -0.223, -0.692> 
		<0.476, -0.230, -0.559> <0.641, -0.229, -0.572> <1.795, -0.225, -0.665> <2.125, -0.223, -0.692> 
		<0.476, -0.230, -0.559> <0.641, -0.229, -0.572> <1.795, -0.225, -0.665> <2.125, -0.223, -0.692> 
		<0.476, -0.230, -0.559> <0.641, -0.229, -0.572> <1.795, -0.225, -0.665> <2.125, -0.223, -0.692> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, -0.230, -0.559> <0.476, -0.230, -0.559> <0.476, -0.230, -0.559> <0.476, -0.230, -0.559> 
		<0.517, -0.283, -0.538> <0.517, -0.283, -0.538> <0.517, -0.283, -0.538> <0.517, -0.283, -0.538> 
		<0.642, -0.442, -0.475> <0.642, -0.442, -0.475> <0.642, -0.442, -0.475> <0.642, -0.442, -0.475> 
		<0.684, -0.496, -0.454> <0.684, -0.496, -0.454> <0.684, -0.496, -0.454> <0.684, -0.496, -0.454> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.125, -0.223, -0.692> <2.126, -0.294, -0.664> <2.126, -0.508, -0.580> <2.126, -0.579, -0.552> 
		<2.125, -0.223, -0.692> <2.126, -0.294, -0.664> <2.126, -0.508, -0.580> <2.126, -0.579, -0.552> 
		<2.125, -0.223, -0.692> <2.126, -0.294, -0.664> <2.126, -0.508, -0.580> <2.126, -0.579, -0.552> 
		<2.125, -0.223, -0.692> <2.126, -0.294, -0.664> <2.126, -0.508, -0.580> <2.126, -0.579, -0.552> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, -0.230, -0.559> <0.641, -0.229, -0.572> <1.795, -0.225, -0.665> <2.125, -0.223, -0.692> 
		<0.517, -0.283, -0.538> <0.682, -0.282, -0.551> <1.796, -0.296, -0.637> <2.126, -0.294, -0.664> 
		<0.642, -0.442, -0.475> <0.786, -0.451, -0.485> <1.837, -0.491, -0.560> <2.126, -0.508, -0.580> 
		<0.684, -0.496, -0.454> <0.828, -0.504, -0.464> <1.837, -0.562, -0.533> <2.126, -0.579, -0.552> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.684, -0.496, -0.454> <0.684, -0.496, -0.454> <0.684, -0.496, -0.454> <0.684, -0.496, -0.454> 
		<0.828, -0.504, -0.464> <0.828, -0.504, -0.464> <0.828, -0.504, -0.464> <0.828, -0.504, -0.464> 
		<1.837, -0.562, -0.533> <1.837, -0.562, -0.533> <1.837, -0.562, -0.533> <1.837, -0.562, -0.533> 
		<2.126, -0.579, -0.552> <2.126, -0.579, -0.552> <2.126, -0.579, -0.552> <2.126, -0.579, -0.552> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 0.139, -0.689> <0.307, 0.073, -0.663> <0.431, -0.127, -0.587> <0.473, -0.194, -0.561> 
		<0.451, 0.149, -0.705> <0.493, 0.082, -0.680> <0.597, -0.128, -0.599> <0.638, -0.195, -0.574> 
		<1.753, 0.214, -0.819> <1.753, 0.126, -0.786> <1.795, -0.116, -0.693> <1.795, -0.204, -0.660> 
		<2.125, 0.233, -0.852> <2.126, 0.145, -0.819> <2.126, -0.118, -0.718> <2.126, -0.206, -0.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 0.139, -0.689> <0.451, 0.149, -0.705> <1.753, 0.214, -0.819> <2.125, 0.233, -0.852> 
		<0.265, 0.139, -0.689> <0.451, 0.149, -0.705> <1.753, 0.214, -0.819> <2.125, 0.233, -0.852> 
		<0.265, 0.139, -0.689> <0.451, 0.149, -0.705> <1.753, 0.214, -0.819> <2.125, 0.233, -0.852> 
		<0.265, 0.139, -0.689> <0.451, 0.149, -0.705> <1.753, 0.214, -0.819> <2.125, 0.233, -0.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 0.139, -0.689> <0.265, 0.139, -0.689> <0.265, 0.139, -0.689> <0.265, 0.139, -0.689> 
		<0.307, 0.073, -0.663> <0.307, 0.073, -0.663> <0.307, 0.073, -0.663> <0.307, 0.073, -0.663> 
		<0.431, -0.127, -0.587> <0.431, -0.127, -0.587> <0.431, -0.127, -0.587> <0.431, -0.127, -0.587> 
		<0.473, -0.194, -0.561> <0.473, -0.194, -0.561> <0.473, -0.194, -0.561> <0.473, -0.194, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.125, 0.233, -0.852> <2.126, 0.145, -0.819> <2.126, -0.118, -0.718> <2.126, -0.206, -0.684> 
		<2.125, 0.233, -0.852> <2.126, 0.145, -0.819> <2.126, -0.118, -0.718> <2.126, -0.206, -0.684> 
		<2.125, 0.233, -0.852> <2.126, 0.145, -0.819> <2.126, -0.118, -0.718> <2.126, -0.206, -0.684> 
		<2.125, 0.233, -0.852> <2.126, 0.145, -0.819> <2.126, -0.118, -0.718> <2.126, -0.206, -0.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 0.139, -0.689> <0.451, 0.149, -0.705> <1.753, 0.214, -0.819> <2.125, 0.233, -0.852> 
		<0.307, 0.073, -0.663> <0.493, 0.082, -0.680> <1.753, 0.126, -0.786> <2.126, 0.145, -0.819> 
		<0.431, -0.127, -0.587> <0.597, -0.128, -0.599> <1.795, -0.116, -0.693> <2.126, -0.118, -0.718> 
		<0.473, -0.194, -0.561> <0.638, -0.195, -0.574> <1.795, -0.204, -0.660> <2.126, -0.206, -0.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.473, -0.194, -0.561> <0.473, -0.194, -0.561> <0.473, -0.194, -0.561> <0.473, -0.194, -0.561> 
		<0.638, -0.195, -0.574> <0.638, -0.195, -0.574> <0.638, -0.195, -0.574> <0.638, -0.195, -0.574> 
		<1.795, -0.204, -0.660> <1.795, -0.204, -0.660> <1.795, -0.204, -0.660> <1.795, -0.204, -0.660> 
		<2.126, -0.206, -0.684> <2.126, -0.206, -0.684> <2.126, -0.206, -0.684> <2.126, -0.206, -0.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.239, 0.143, 0.684> <0.280, 0.075, 0.660> <0.405, -0.127, 0.590> <0.447, -0.194, 0.566> 
		<0.427, 0.153, 0.701> <0.469, 0.086, 0.677> <0.573, -0.127, 0.603> <0.615, -0.194, 0.580> 
		<1.748, 0.228, 0.820> <1.748, 0.140, 0.789> <1.790, -0.105, 0.704> <1.790, -0.194, 0.673> 
		<2.125, 0.250, 0.854> <2.126, 0.161, 0.823> <2.126, -0.105, 0.730> <2.126, -0.194, 0.699> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.239, 0.143, 0.684> <0.427, 0.153, 0.701> <1.748, 0.228, 0.820> <2.125, 0.250, 0.854> 
		<0.239, 0.143, 0.684> <0.427, 0.153, 0.701> <1.748, 0.228, 0.820> <2.125, 0.250, 0.854> 
		<0.239, 0.143, 0.684> <0.427, 0.153, 0.701> <1.748, 0.228, 0.820> <2.125, 0.250, 0.854> 
		<0.239, 0.143, 0.684> <0.427, 0.153, 0.701> <1.748, 0.228, 0.820> <2.125, 0.250, 0.854> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.239, 0.143, 0.684> <0.239, 0.143, 0.684> <0.239, 0.143, 0.684> <0.239, 0.143, 0.684> 
		<0.280, 0.075, 0.660> <0.280, 0.075, 0.660> <0.280, 0.075, 0.660> <0.280, 0.075, 0.660> 
		<0.405, -0.127, 0.590> <0.405, -0.127, 0.590> <0.405, -0.127, 0.590> <0.405, -0.127, 0.590> 
		<0.447, -0.194, 0.566> <0.447, -0.194, 0.566> <0.447, -0.194, 0.566> <0.447, -0.194, 0.566> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.125, 0.250, 0.854> <2.126, 0.161, 0.823> <2.126, -0.105, 0.730> <2.126, -0.194, 0.699> 
		<2.125, 0.250, 0.854> <2.126, 0.161, 0.823> <2.126, -0.105, 0.730> <2.126, -0.194, 0.699> 
		<2.125, 0.250, 0.854> <2.126, 0.161, 0.823> <2.126, -0.105, 0.730> <2.126, -0.194, 0.699> 
		<2.125, 0.250, 0.854> <2.126, 0.161, 0.823> <2.126, -0.105, 0.730> <2.126, -0.194, 0.699> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.239, 0.143, 0.684> <0.427, 0.153, 0.701> <1.748, 0.228, 0.820> <2.125, 0.250, 0.854> 
		<0.280, 0.075, 0.660> <0.469, 0.086, 0.677> <1.748, 0.140, 0.789> <2.126, 0.161, 0.823> 
		<0.405, -0.127, 0.590> <0.573, -0.127, 0.603> <1.790, -0.105, 0.704> <2.126, -0.105, 0.730> 
		<0.447, -0.194, 0.566> <0.615, -0.194, 0.580> <1.790, -0.194, 0.673> <2.126, -0.194, 0.699> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.447, -0.194, 0.566> <0.447, -0.194, 0.566> <0.447, -0.194, 0.566> <0.447, -0.194, 0.566> 
		<0.615, -0.194, 0.580> <0.615, -0.194, 0.580> <0.615, -0.194, 0.580> <0.615, -0.194, 0.580> 
		<1.790, -0.194, 0.673> <1.790, -0.194, 0.673> <1.790, -0.194, 0.673> <1.790, -0.194, 0.673> 
		<2.126, -0.194, 0.699> <2.126, -0.194, 0.699> <2.126, -0.194, 0.699> <2.126, -0.194, 0.699> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.071, 0.231, -0.881> <2.089, 0.231, -0.881> <2.142, 0.231, -0.881> <2.160, 0.231, -0.881> 
		<2.071, 0.231, -0.710> <2.089, 0.231, -0.710> <2.142, 0.231, -0.710> <2.160, 0.231, -0.710> 
		<2.071, 0.231, 0.482> <2.089, 0.231, 0.482> <2.142, 0.231, 0.482> <2.160, 0.231, 0.482> 
		<2.071, 0.231, 0.823> <2.089, 0.231, 0.823> <2.142, 0.231, 0.823> <2.160, 0.231, 0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.071, 0.231, -0.881> <2.071, 0.231, -0.710> <2.071, 0.231, 0.482> <2.071, 0.231, 0.823> 
		<2.074, 0.065, -0.817> <2.074, 0.065, -0.647> <2.074, 0.065, 0.424> <2.074, 0.065, 0.765> 
		<2.084, -0.433, -0.626> <2.084, -0.433, -0.517> <2.084, -0.433, 0.371> <2.084, -0.433, 0.590> 
		<2.087, -0.600, -0.563> <2.087, -0.600, -0.453> <2.087, -0.600, 0.313> <2.087, -0.600, 0.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.071, 0.231, -0.881> <2.074, 0.065, -0.817> <2.084, -0.433, -0.626> <2.087, -0.600, -0.563> 
		<2.089, 0.231, -0.881> <2.092, 0.065, -0.817> <2.095, -0.433, -0.626> <2.098, -0.600, -0.563> 
		<2.142, 0.231, -0.881> <2.139, 0.065, -0.817> <2.136, -0.433, -0.626> <2.133, -0.600, -0.563> 
		<2.160, 0.231, -0.881> <2.157, 0.065, -0.817> <2.148, -0.433, -0.626> <2.144, -0.600, -0.563> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.071, 0.231, 0.823> <2.089, 0.231, 0.823> <2.142, 0.231, 0.823> <2.160, 0.231, 0.823> 
		<2.074, 0.065, 0.765> <2.092, 0.065, 0.765> <2.139, 0.065, 0.765> <2.157, 0.065, 0.765> 
		<2.084, -0.433, 0.590> <2.095, -0.433, 0.590> <2.136, -0.433, 0.590> <2.148, -0.433, 0.590> 
		<2.087, -0.600, 0.531> <2.098, -0.600, 0.531> <2.133, -0.600, 0.531> <2.144, -0.600, 0.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.087, -0.600, -0.563> <2.087, -0.600, -0.453> <2.087, -0.600, 0.313> <2.087, -0.600, 0.531> 
		<2.098, -0.600, -0.563> <2.098, -0.600, -0.453> <2.098, -0.600, 0.313> <2.098, -0.600, 0.531> 
		<2.133, -0.600, -0.563> <2.133, -0.600, -0.453> <2.133, -0.600, 0.313> <2.133, -0.600, 0.531> 
		<2.144, -0.600, -0.563> <2.144, -0.600, -0.453> <2.144, -0.600, 0.313> <2.144, -0.600, 0.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.160, 0.231, -0.881> <2.157, 0.065, -0.817> <2.148, -0.433, -0.626> <2.144, -0.600, -0.563> 
		<2.160, 0.231, -0.710> <2.157, 0.065, -0.647> <2.148, -0.433, -0.517> <2.144, -0.600, -0.453> 
		<2.160, 0.231, 0.482> <2.157, 0.065, 0.424> <2.148, -0.433, 0.371> <2.144, -0.600, 0.313> 
		<2.160, 0.231, 0.823> <2.157, 0.065, 0.765> <2.148, -0.433, 0.590> <2.144, -0.600, 0.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.689, -0.487, -0.461> <0.984, -0.507, -0.485> <1.870, -0.567, -0.556> <2.166, -0.587, -0.580> 
		<0.689, -0.487, -0.370> <0.984, -0.507, -0.393> <1.870, -0.567, -0.441> <2.165, -0.587, -0.465> 
		<0.687, -0.487, 0.270> <0.982, -0.507, 0.294> <1.868, -0.567, 0.318> <2.164, -0.587, 0.342> 
		<0.687, -0.487, 0.453> <0.982, -0.507, 0.477> <1.868, -0.567, 0.548> <2.163, -0.587, 0.572> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.689, -0.487, -0.461> <0.689, -0.487, -0.370> <0.687, -0.487, 0.270> <0.687, -0.487, 0.453> 
		<0.690, -0.495, -0.463> <0.689, -0.495, -0.372> <0.688, -0.495, 0.272> <0.687, -0.495, 0.455> 
		<0.691, -0.518, -0.469> <0.691, -0.518, -0.376> <0.689, -0.518, 0.274> <0.689, -0.518, 0.461> 
		<0.692, -0.526, -0.471> <0.692, -0.526, -0.378> <0.690, -0.526, 0.276> <0.689, -0.526, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.689, -0.487, -0.461> <0.690, -0.495, -0.463> <0.691, -0.518, -0.469> <0.692, -0.526, -0.471> 
		<0.984, -0.507, -0.485> <0.985, -0.515, -0.487> <0.992, -0.540, -0.494> <0.992, -0.548, -0.496> 
		<1.870, -0.567, -0.556> <1.876, -0.577, -0.559> <1.888, -0.605, -0.566> <1.894, -0.614, -0.569> 
		<2.166, -0.587, -0.580> <2.171, -0.597, -0.583> <2.189, -0.627, -0.590> <2.195, -0.636, -0.593> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.687, -0.487, 0.453> <0.982, -0.507, 0.477> <1.868, -0.567, 0.548> <2.163, -0.587, 0.572> 
		<0.687, -0.495, 0.455> <0.982, -0.515, 0.479> <1.874, -0.577, 0.551> <2.169, -0.597, 0.575> 
		<0.689, -0.518, 0.461> <0.989, -0.540, 0.485> <1.886, -0.605, 0.558> <2.186, -0.627, 0.582> 
		<0.689, -0.526, 0.463> <0.990, -0.548, 0.488> <1.892, -0.614, 0.561> <2.192, -0.636, 0.585> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.692, -0.526, -0.471> <0.692, -0.526, -0.378> <0.690, -0.526, 0.276> <0.689, -0.526, 0.463> 
		<0.992, -0.548, -0.496> <0.992, -0.548, -0.402> <0.990, -0.548, 0.301> <0.990, -0.548, 0.488> 
		<1.894, -0.614, -0.569> <1.894, -0.614, -0.451> <1.892, -0.614, 0.325> <1.892, -0.614, 0.561> 
		<2.195, -0.636, -0.593> <2.194, -0.636, -0.475> <2.193, -0.636, 0.349> <2.192, -0.636, 0.585> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.166, -0.587, -0.580> <2.171, -0.597, -0.583> <2.189, -0.627, -0.590> <2.195, -0.636, -0.593> 
		<2.165, -0.587, -0.465> <2.171, -0.597, -0.468> <2.189, -0.627, -0.473> <2.194, -0.636, -0.475> 
		<2.164, -0.587, 0.342> <2.169, -0.597, 0.344> <2.187, -0.627, 0.347> <2.193, -0.636, 0.349> 
		<2.163, -0.587, 0.572> <2.169, -0.597, 0.575> <2.186, -0.627, 0.582> <2.192, -0.636, 0.585> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment {
    wood
    turbulence 0.05            // For best results,  keep this low!
    scale <0.05, 0.05, 1>        // Scaled for a unit object
    color_map {
        [0.1 rgb <0.42, 0.26, 0.15>]
        [0.9 rgb <0.52, 0.37, 0.26>]
    }
}
	#end
}

#declare handle =
// Layer 2
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.702, -0.204, -0.921> <3.702, -0.204, -0.921> <3.702, -0.204, -0.921> <3.702, -0.204, -0.921> 
		<3.700, -0.204, -0.945> <3.702, -0.204, -0.921> <3.702, -0.204, -0.921> <3.703, -0.204, -0.897> 
		<3.699, -0.224, -0.965> <3.701, -0.224, -0.938> <3.703, -0.224, -0.903> <3.705, -0.224, -0.877> 
		<3.699, -0.248, -0.965> <3.701, -0.248, -0.938> <3.703, -0.248, -0.903> <3.705, -0.248, -0.877> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.702, -0.204, -0.921> <3.700, -0.204, -0.945> <3.699, -0.224, -0.965> <3.699, -0.248, -0.965> 
		<2.445, -0.209, -0.789> <2.444, -0.209, -0.812> <2.443, -0.214, -0.838> <2.443, -0.238, -0.838> 
		<0.770, -0.215, -0.612> <0.769, -0.213, -0.631> <0.768, -0.226, -0.650> <0.767, -0.225, -0.669> 
		<-0.487, -0.220, -0.480> <-0.487, -0.218, -0.498> <-0.488, -0.216, -0.523> <-0.489, -0.215, -0.542> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.702, -0.204, -0.921> <2.445, -0.209, -0.789> <0.770, -0.215, -0.612> <-0.487, -0.220, -0.480> 
		<3.703, -0.204, -0.897> <2.447, -0.209, -0.765> <0.771, -0.233, -0.613> <-0.486, -0.238, -0.481> 
		<3.705, -0.224, -0.877> <2.448, -0.234, -0.759> <0.772, -0.253, -0.601> <-0.485, -0.263, -0.483> 
		<3.705, -0.248, -0.877> <2.448, -0.258, -0.759> <0.773, -0.271, -0.602> <-0.484, -0.281, -0.484> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.702, -0.292, -0.921> <3.704, -0.292, -0.897> <3.705, -0.272, -0.877> <3.705, -0.248, -0.877> 
		<2.446, -0.287, -0.809> <2.447, -0.287, -0.785> <2.448, -0.282, -0.759> <2.448, -0.258, -0.759> 
		<0.770, -0.281, -0.659> <0.771, -0.283, -0.640> <0.772, -0.270, -0.621> <0.773, -0.271, -0.602> 
		<-0.486, -0.277, -0.546> <-0.485, -0.278, -0.528> <-0.484, -0.280, -0.503> <-0.484, -0.281, -0.484> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.702, -0.292, -0.921> <3.702, -0.292, -0.921> <3.702, -0.292, -0.921> <3.702, -0.292, -0.921> 
		<3.704, -0.292, -0.897> <3.702, -0.292, -0.921> <3.702, -0.292, -0.921> <3.701, -0.292, -0.945> 
		<3.705, -0.272, -0.877> <3.703, -0.272, -0.903> <3.701, -0.272, -0.938> <3.699, -0.272, -0.965> 
		<3.705, -0.248, -0.877> <3.703, -0.248, -0.903> <3.701, -0.248, -0.938> <3.699, -0.248, -0.965> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.702, -0.292, -0.921> <2.446, -0.287, -0.809> <0.770, -0.281, -0.659> <-0.486, -0.277, -0.546> 
		<3.701, -0.292, -0.945> <2.444, -0.287, -0.833> <0.769, -0.263, -0.657> <-0.487, -0.258, -0.545> 
		<3.699, -0.272, -0.965> <2.443, -0.262, -0.838> <0.768, -0.243, -0.670> <-0.488, -0.234, -0.543> 
		<3.699, -0.248, -0.965> <2.443, -0.238, -0.838> <0.767, -0.225, -0.669> <-0.489, -0.215, -0.542> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.487, -0.220, -0.480> <-0.487, -0.220, -0.480> <-0.487, -0.220, -0.480> <-0.487, -0.220, -0.480> 
		<-0.486, -0.238, -0.481> <-0.486, -0.237, -0.500> <-0.486, -0.237, -0.500> <-0.487, -0.218, -0.498> 
		<-0.485, -0.263, -0.483> <-0.486, -0.243, -0.500> <-0.487, -0.236, -0.506> <-0.488, -0.216, -0.523> 
		<-0.484, -0.281, -0.484> <-0.485, -0.262, -0.502> <-0.487, -0.235, -0.524> <-0.489, -0.215, -0.542> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.486, -0.277, -0.546> <-0.486, -0.277, -0.546> <-0.486, -0.277, -0.546> <-0.486, -0.277, -0.546> 
		<-0.487, -0.258, -0.545> <-0.486, -0.260, -0.526> <-0.486, -0.260, -0.526> <-0.485, -0.278, -0.528> 
		<-0.488, -0.234, -0.543> <-0.487, -0.253, -0.526> <-0.486, -0.260, -0.520> <-0.484, -0.280, -0.503> 
		<-0.489, -0.215, -0.542> <-0.487, -0.235, -0.524> <-0.485, -0.262, -0.502> <-0.484, -0.281, -0.484> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.706, -0.204, 0.876> <3.706, -0.204, 0.876> <3.706, -0.204, 0.876> <3.706, -0.204, 0.876> 
		<3.708, -0.204, 0.853> <3.706, -0.204, 0.876> <3.706, -0.204, 0.876> <3.703, -0.204, 0.900> 
		<3.711, -0.224, 0.833> <3.708, -0.224, 0.859> <3.704, -0.224, 0.894> <3.701, -0.224, 0.920> 
		<3.711, -0.248, 0.833> <3.708, -0.248, 0.859> <3.704, -0.248, 0.894> <3.701, -0.248, 0.920> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.706, -0.204, 0.876> <3.708, -0.204, 0.853> <3.711, -0.224, 0.833> <3.711, -0.248, 0.833> 
		<2.447, -0.208, 0.790> <2.449, -0.208, 0.766> <2.452, -0.215, 0.741> <2.452, -0.239, 0.741> 
		<0.768, -0.212, 0.675> <0.770, -0.213, 0.656> <0.772, -0.227, 0.637> <0.773, -0.227, 0.618> 
		<-0.490, -0.216, 0.588> <-0.489, -0.217, 0.569> <-0.487, -0.218, 0.545> <-0.485, -0.218, 0.526> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.706, -0.204, 0.876> <2.447, -0.208, 0.790> <0.768, -0.212, 0.675> <-0.490, -0.216, 0.588> 
		<3.703, -0.204, 0.900> <2.444, -0.208, 0.814> <0.767, -0.231, 0.675> <-0.492, -0.235, 0.589> 
		<3.701, -0.224, 0.920> <2.442, -0.233, 0.821> <0.765, -0.250, 0.688> <-0.494, -0.259, 0.589> 
		<3.701, -0.248, 0.920> <2.442, -0.257, 0.821> <0.764, -0.269, 0.689> <-0.495, -0.278, 0.590> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.706, -0.292, 0.876> <3.703, -0.292, 0.900> <3.701, -0.272, 0.920> <3.701, -0.248, 0.920> 
		<2.447, -0.288, 0.772> <2.444, -0.288, 0.796> <2.442, -0.281, 0.821> <2.442, -0.257, 0.821> 
		<0.769, -0.284, 0.633> <0.767, -0.283, 0.651> <0.765, -0.270, 0.671> <0.764, -0.269, 0.689> 
		<-0.490, -0.280, 0.528> <-0.492, -0.280, 0.547> <-0.494, -0.279, 0.572> <-0.495, -0.278, 0.590> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.706, -0.292, 0.876> <3.706, -0.292, 0.876> <3.706, -0.292, 0.876> <3.706, -0.292, 0.876> 
		<3.703, -0.292, 0.900> <3.706, -0.292, 0.876> <3.706, -0.292, 0.876> <3.709, -0.292, 0.853> 
		<3.701, -0.272, 0.920> <3.704, -0.272, 0.894> <3.708, -0.272, 0.859> <3.711, -0.272, 0.833> 
		<3.701, -0.248, 0.920> <3.704, -0.248, 0.894> <3.708, -0.248, 0.859> <3.711, -0.248, 0.833> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.706, -0.292, 0.876> <2.447, -0.288, 0.772> <0.769, -0.284, 0.633> <-0.490, -0.280, 0.528> 
		<3.709, -0.292, 0.853> <2.450, -0.288, 0.748> <0.770, -0.265, 0.632> <-0.489, -0.262, 0.528> 
		<3.711, -0.272, 0.833> <2.452, -0.263, 0.741> <0.772, -0.246, 0.619> <-0.487, -0.237, 0.527> 
		<3.711, -0.248, 0.833> <2.452, -0.239, 0.741> <0.773, -0.227, 0.618> <-0.485, -0.218, 0.526> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.490, -0.216, 0.588> <-0.490, -0.216, 0.588> <-0.490, -0.216, 0.588> <-0.490, -0.216, 0.588> 
		<-0.492, -0.235, 0.589> <-0.490, -0.235, 0.570> <-0.490, -0.235, 0.570> <-0.489, -0.217, 0.569> 
		<-0.494, -0.259, 0.589> <-0.491, -0.242, 0.570> <-0.490, -0.236, 0.564> <-0.487, -0.218, 0.545> 
		<-0.495, -0.278, 0.590> <-0.492, -0.260, 0.571> <-0.488, -0.236, 0.545> <-0.485, -0.218, 0.526> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.490, -0.280, 0.528> <-0.490, -0.280, 0.528> <-0.490, -0.280, 0.528> <-0.490, -0.280, 0.528> 
		<-0.489, -0.262, 0.528> <-0.490, -0.261, 0.546> <-0.490, -0.261, 0.546> <-0.492, -0.280, 0.547> 
		<-0.487, -0.237, 0.527> <-0.490, -0.255, 0.546> <-0.491, -0.261, 0.552> <-0.494, -0.279, 0.572> 
		<-0.485, -0.218, 0.526> <-0.488, -0.236, 0.545> <-0.492, -0.260, 0.571> <-0.495, -0.278, 0.590> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment {
    wood
    turbulence 0.6
    color_map {
        [0.0 rgb <0.93, 0.71, 0.53>]
        [0.8 rgb <0.98, 0.81, 0.60>]
        [0.8 rgb <0.60, 0.33, 0.27>]
        [1.0 rgb <0.70, 0.60, 0.23>]
    }
}
	#end
}

#declare brackets =
// Layer 3
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.913, -0.175, -0.719> <1.902, -0.175, -0.718> <1.888, -0.175, -0.717> <1.877, -0.175, -0.716> 
		<1.911, -0.203, -0.731> <1.900, -0.203, -0.730> <1.886, -0.203, -0.729> <1.875, -0.203, -0.728> 
		<1.902, -0.213, -0.785> <1.891, -0.213, -0.784> <1.877, -0.213, -0.782> <1.866, -0.213, -0.781> 
		<1.899, -0.241, -0.797> <1.889, -0.241, -0.796> <1.874, -0.241, -0.795> <1.864, -0.241, -0.794> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.913, -0.175, -0.719> <1.911, -0.203, -0.731> <1.902, -0.213, -0.785> <1.899, -0.241, -0.797> 
		<1.924, -0.175, -0.720> <1.921, -0.203, -0.732> <1.912, -0.213, -0.786> <1.910, -0.241, -0.798> 
		<1.938, -0.175, -0.722> <1.936, -0.203, -0.733> <1.927, -0.213, -0.787> <1.925, -0.241, -0.799> 
		<1.949, -0.175, -0.722> <1.946, -0.203, -0.734> <1.938, -0.213, -0.788> <1.935, -0.241, -0.800> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.913, -0.175, -0.719> <1.915, -0.155, -0.711> <1.912, -0.127, -0.736> <1.911, -0.106, -0.744> 
		<1.902, -0.175, -0.718> <1.904, -0.155, -0.710> <1.901, -0.127, -0.736> <1.900, -0.106, -0.743> 
		<1.888, -0.175, -0.717> <1.890, -0.155, -0.709> <1.886, -0.127, -0.734> <1.886, -0.106, -0.742> 
		<1.877, -0.175, -0.716> <1.879, -0.155, -0.708> <1.876, -0.127, -0.733> <1.875, -0.106, -0.741> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.913, -0.175, -0.719> <1.924, -0.175, -0.720> <1.938, -0.175, -0.722> <1.949, -0.175, -0.722> 
		<1.915, -0.155, -0.711> <1.926, -0.155, -0.712> <1.940, -0.155, -0.713> <1.951, -0.155, -0.714> 
		<1.912, -0.127, -0.736> <1.922, -0.127, -0.737> <1.937, -0.127, -0.739> <1.947, -0.127, -0.740> 
		<1.911, -0.106, -0.744> <1.922, -0.106, -0.745> <1.936, -0.106, -0.746> <1.947, -0.106, -0.747> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.899, -0.241, -0.797> <1.889, -0.241, -0.796> <1.874, -0.241, -0.795> <1.864, -0.241, -0.794> 
		<1.898, -0.258, -0.805> <1.887, -0.258, -0.804> <1.873, -0.258, -0.803> <1.862, -0.258, -0.802> 
		<1.900, -0.294, -0.793> <1.889, -0.294, -0.792> <1.875, -0.294, -0.791> <1.864, -0.294, -0.790> 
		<1.903, -0.299, -0.776> <1.893, -0.299, -0.775> <1.878, -0.299, -0.773> <1.868, -0.299, -0.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.899, -0.241, -0.797> <1.898, -0.258, -0.805> <1.900, -0.294, -0.793> <1.903, -0.299, -0.776> 
		<1.910, -0.241, -0.798> <1.909, -0.258, -0.806> <1.911, -0.294, -0.794> <1.914, -0.299, -0.777> 
		<1.925, -0.241, -0.799> <1.923, -0.258, -0.807> <1.925, -0.294, -0.796> <1.928, -0.299, -0.778> 
		<1.935, -0.241, -0.800> <1.934, -0.258, -0.808> <1.936, -0.294, -0.797> <1.939, -0.299, -0.779> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.903, -0.299, -0.776> <1.909, -0.307, -0.747> <1.916, -0.280, -0.708> <1.921, -0.272, -0.679> 
		<1.914, -0.299, -0.777> <1.919, -0.307, -0.748> <1.927, -0.280, -0.709> <1.932, -0.272, -0.680> 
		<1.928, -0.299, -0.778> <1.934, -0.307, -0.749> <1.941, -0.280, -0.711> <1.946, -0.272, -0.682> 
		<1.939, -0.299, -0.779> <1.945, -0.307, -0.750> <1.952, -0.280, -0.711> <1.957, -0.272, -0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.903, -0.299, -0.776> <1.893, -0.299, -0.775> <1.878, -0.299, -0.773> <1.868, -0.299, -0.773> 
		<1.909, -0.307, -0.747> <1.898, -0.307, -0.746> <1.884, -0.307, -0.745> <1.873, -0.307, -0.744> 
		<1.916, -0.280, -0.708> <1.905, -0.280, -0.707> <1.891, -0.280, -0.706> <1.880, -0.280, -0.705> 
		<1.921, -0.272, -0.679> <1.911, -0.272, -0.679> <1.896, -0.272, -0.677> <1.885, -0.272, -0.676> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.868, -0.299, -0.773> <1.864, -0.294, -0.790> <1.862, -0.258, -0.802> <1.864, -0.241, -0.794> 
		<1.857, -0.299, -0.772> <1.853, -0.294, -0.789> <1.852, -0.258, -0.801> <1.853, -0.241, -0.793> 
		<1.842, -0.299, -0.770> <1.839, -0.294, -0.788> <1.837, -0.258, -0.800> <1.839, -0.241, -0.792> 
		<1.832, -0.299, -0.769> <1.828, -0.294, -0.787> <1.826, -0.258, -0.799> <1.828, -0.241, -0.791> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.868, -0.299, -0.773> <1.857, -0.299, -0.772> <1.842, -0.299, -0.770> <1.832, -0.299, -0.769> 
		<1.873, -0.307, -0.744> <1.862, -0.307, -0.743> <1.848, -0.307, -0.741> <1.837, -0.307, -0.741> 
		<1.880, -0.280, -0.705> <1.869, -0.280, -0.704> <1.855, -0.280, -0.703> <1.844, -0.280, -0.702> 
		<1.885, -0.272, -0.676> <1.875, -0.272, -0.675> <1.860, -0.272, -0.674> <1.850, -0.272, -0.673> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.864, -0.241, -0.794> <1.866, -0.213, -0.781> <1.875, -0.203, -0.728> <1.877, -0.175, -0.716> 
		<1.853, -0.241, -0.793> <1.855, -0.213, -0.781> <1.864, -0.203, -0.727> <1.866, -0.175, -0.715> 
		<1.839, -0.241, -0.792> <1.841, -0.213, -0.779> <1.850, -0.203, -0.725> <1.852, -0.175, -0.714> 
		<1.828, -0.241, -0.791> <1.830, -0.213, -0.778> <1.839, -0.203, -0.725> <1.841, -0.175, -0.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.877, -0.175, -0.716> <1.879, -0.155, -0.708> <1.876, -0.127, -0.733> <1.875, -0.106, -0.741> 
		<1.866, -0.175, -0.715> <1.868, -0.155, -0.707> <1.865, -0.127, -0.732> <1.864, -0.106, -0.740> 
		<1.852, -0.175, -0.714> <1.854, -0.155, -0.706> <1.851, -0.127, -0.731> <1.850, -0.106, -0.739> 
		<1.841, -0.175, -0.713> <1.843, -0.155, -0.705> <1.840, -0.127, -0.730> <1.839, -0.106, -0.738> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.841, -0.175, -0.713> <1.843, -0.155, -0.705> <1.840, -0.127, -0.730> <1.839, -0.106, -0.738> 
		<1.831, -0.175, -0.712> <1.832, -0.155, -0.704> <1.829, -0.127, -0.729> <1.828, -0.106, -0.737> 
		<1.816, -0.175, -0.711> <1.818, -0.155, -0.703> <1.815, -0.127, -0.728> <1.814, -0.106, -0.735> 
		<1.805, -0.175, -0.710> <1.807, -0.155, -0.702> <1.804, -0.127, -0.727> <1.803, -0.106, -0.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.841, -0.175, -0.713> <1.831, -0.175, -0.712> <1.816, -0.175, -0.711> <1.805, -0.175, -0.710> 
		<1.839, -0.203, -0.725> <1.828, -0.203, -0.724> <1.814, -0.203, -0.722> <1.803, -0.203, -0.721> 
		<1.830, -0.213, -0.778> <1.819, -0.213, -0.777> <1.805, -0.213, -0.776> <1.794, -0.213, -0.775> 
		<1.828, -0.241, -0.791> <1.817, -0.241, -0.790> <1.803, -0.241, -0.789> <1.792, -0.241, -0.788> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.828, -0.241, -0.791> <1.817, -0.241, -0.790> <1.803, -0.241, -0.789> <1.792, -0.241, -0.788> 
		<1.826, -0.258, -0.799> <1.816, -0.258, -0.798> <1.801, -0.258, -0.797> <1.791, -0.258, -0.796> 
		<1.828, -0.294, -0.787> <1.818, -0.294, -0.786> <1.803, -0.294, -0.785> <1.793, -0.294, -0.784> 
		<1.832, -0.299, -0.769> <1.821, -0.299, -0.768> <1.807, -0.299, -0.767> <1.796, -0.299, -0.766> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.832, -0.299, -0.769> <1.821, -0.299, -0.768> <1.807, -0.299, -0.767> <1.796, -0.299, -0.766> 
		<1.837, -0.307, -0.741> <1.826, -0.307, -0.740> <1.812, -0.307, -0.738> <1.801, -0.307, -0.737> 
		<1.844, -0.280, -0.702> <1.833, -0.280, -0.701> <1.819, -0.280, -0.700> <1.808, -0.280, -0.699> 
		<1.850, -0.272, -0.673> <1.839, -0.272, -0.672> <1.824, -0.272, -0.671> <1.814, -0.272, -0.670> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.820, -0.175, -0.635> <0.810, -0.175, -0.634> <0.795, -0.175, -0.633> <0.785, -0.175, -0.632> 
		<0.818, -0.203, -0.647> <0.807, -0.203, -0.646> <0.793, -0.203, -0.645> <0.782, -0.203, -0.644> 
		<0.809, -0.213, -0.701> <0.798, -0.213, -0.700> <0.784, -0.213, -0.698> <0.773, -0.213, -0.697> 
		<0.807, -0.241, -0.713> <0.796, -0.241, -0.712> <0.782, -0.241, -0.711> <0.771, -0.241, -0.710> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.820, -0.175, -0.635> <0.818, -0.203, -0.647> <0.809, -0.213, -0.701> <0.807, -0.241, -0.713> 
		<0.831, -0.175, -0.636> <0.829, -0.203, -0.648> <0.820, -0.213, -0.701> <0.818, -0.241, -0.714> 
		<0.845, -0.175, -0.637> <0.843, -0.203, -0.649> <0.834, -0.213, -0.703> <0.832, -0.241, -0.715> 
		<0.856, -0.175, -0.638> <0.854, -0.203, -0.650> <0.845, -0.213, -0.704> <0.843, -0.241, -0.716> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.820, -0.175, -0.635> <0.822, -0.155, -0.627> <0.819, -0.127, -0.652> <0.818, -0.106, -0.660> 
		<0.810, -0.175, -0.634> <0.811, -0.155, -0.626> <0.808, -0.127, -0.651> <0.808, -0.106, -0.659> 
		<0.795, -0.175, -0.633> <0.797, -0.155, -0.625> <0.794, -0.127, -0.650> <0.793, -0.106, -0.658> 
		<0.785, -0.175, -0.632> <0.786, -0.155, -0.624> <0.783, -0.127, -0.649> <0.782, -0.106, -0.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.820, -0.175, -0.635> <0.831, -0.175, -0.636> <0.845, -0.175, -0.637> <0.856, -0.175, -0.638> 
		<0.822, -0.155, -0.627> <0.833, -0.155, -0.628> <0.847, -0.155, -0.629> <0.858, -0.155, -0.630> 
		<0.819, -0.127, -0.652> <0.830, -0.127, -0.653> <0.844, -0.127, -0.655> <0.855, -0.127, -0.656> 
		<0.818, -0.106, -0.660> <0.829, -0.106, -0.661> <0.843, -0.106, -0.662> <0.854, -0.106, -0.663> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.807, -0.241, -0.713> <0.796, -0.241, -0.712> <0.782, -0.241, -0.711> <0.771, -0.241, -0.710> 
		<0.806, -0.258, -0.721> <0.795, -0.258, -0.720> <0.780, -0.258, -0.719> <0.770, -0.258, -0.718> 
		<0.807, -0.294, -0.709> <0.797, -0.294, -0.708> <0.782, -0.294, -0.707> <0.772, -0.294, -0.706> 
		<0.811, -0.299, -0.692> <0.800, -0.299, -0.691> <0.786, -0.299, -0.689> <0.775, -0.299, -0.688> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.807, -0.241, -0.713> <0.806, -0.258, -0.721> <0.807, -0.294, -0.709> <0.811, -0.299, -0.692> 
		<0.818, -0.241, -0.714> <0.816, -0.258, -0.722> <0.818, -0.294, -0.710> <0.822, -0.299, -0.693> 
		<0.832, -0.241, -0.715> <0.831, -0.258, -0.723> <0.833, -0.294, -0.712> <0.836, -0.299, -0.694> 
		<0.843, -0.241, -0.716> <0.841, -0.258, -0.724> <0.843, -0.294, -0.712> <0.847, -0.299, -0.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.811, -0.299, -0.692> <0.816, -0.307, -0.663> <0.823, -0.280, -0.624> <0.829, -0.272, -0.595> 
		<0.822, -0.299, -0.693> <0.827, -0.307, -0.664> <0.834, -0.280, -0.625> <0.839, -0.272, -0.596> 
		<0.836, -0.299, -0.694> <0.841, -0.307, -0.665> <0.848, -0.280, -0.626> <0.854, -0.272, -0.598> 
		<0.847, -0.299, -0.695> <0.852, -0.307, -0.666> <0.859, -0.280, -0.627> <0.864, -0.272, -0.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.811, -0.299, -0.692> <0.800, -0.299, -0.691> <0.786, -0.299, -0.689> <0.775, -0.299, -0.688> 
		<0.816, -0.307, -0.663> <0.805, -0.307, -0.662> <0.791, -0.307, -0.661> <0.780, -0.307, -0.660> 
		<0.823, -0.280, -0.624> <0.813, -0.280, -0.623> <0.798, -0.280, -0.622> <0.787, -0.280, -0.621> 
		<0.829, -0.272, -0.595> <0.818, -0.272, -0.595> <0.804, -0.272, -0.593> <0.793, -0.272, -0.592> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.775, -0.299, -0.688> <0.772, -0.294, -0.706> <0.770, -0.258, -0.718> <0.771, -0.241, -0.710> 
		<0.764, -0.299, -0.688> <0.761, -0.294, -0.705> <0.759, -0.258, -0.717> <0.760, -0.241, -0.709> 
		<0.750, -0.299, -0.686> <0.747, -0.294, -0.704> <0.745, -0.258, -0.716> <0.746, -0.241, -0.708> 
		<0.739, -0.299, -0.685> <0.736, -0.294, -0.703> <0.734, -0.258, -0.715> <0.735, -0.241, -0.707> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.775, -0.299, -0.688> <0.764, -0.299, -0.688> <0.750, -0.299, -0.686> <0.739, -0.299, -0.685> 
		<0.780, -0.307, -0.660> <0.769, -0.307, -0.659> <0.755, -0.307, -0.657> <0.744, -0.307, -0.656> 
		<0.787, -0.280, -0.621> <0.777, -0.280, -0.620> <0.762, -0.280, -0.619> <0.752, -0.280, -0.618> 
		<0.793, -0.272, -0.592> <0.782, -0.272, -0.591> <0.768, -0.272, -0.590> <0.757, -0.272, -0.589> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.771, -0.241, -0.710> <0.773, -0.213, -0.697> <0.782, -0.203, -0.644> <0.785, -0.175, -0.632> 
		<0.760, -0.241, -0.709> <0.762, -0.213, -0.696> <0.771, -0.203, -0.643> <0.774, -0.175, -0.631> 
		<0.746, -0.241, -0.708> <0.748, -0.213, -0.695> <0.757, -0.203, -0.641> <0.759, -0.175, -0.630> 
		<0.735, -0.241, -0.707> <0.737, -0.213, -0.694> <0.746, -0.203, -0.640> <0.749, -0.175, -0.629> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.785, -0.175, -0.632> <0.786, -0.155, -0.624> <0.783, -0.127, -0.649> <0.782, -0.106, -0.657> 
		<0.774, -0.175, -0.631> <0.776, -0.155, -0.623> <0.772, -0.127, -0.648> <0.772, -0.106, -0.656> 
		<0.759, -0.175, -0.630> <0.761, -0.155, -0.622> <0.758, -0.127, -0.647> <0.757, -0.106, -0.654> 
		<0.749, -0.175, -0.629> <0.750, -0.155, -0.621> <0.747, -0.127, -0.646> <0.747, -0.106, -0.654> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.749, -0.175, -0.629> <0.750, -0.155, -0.621> <0.747, -0.127, -0.646> <0.747, -0.106, -0.654> 
		<0.738, -0.175, -0.628> <0.740, -0.155, -0.620> <0.736, -0.127, -0.645> <0.736, -0.106, -0.653> 
		<0.724, -0.175, -0.627> <0.725, -0.155, -0.619> <0.722, -0.127, -0.644> <0.721, -0.106, -0.651> 
		<0.713, -0.175, -0.626> <0.715, -0.155, -0.618> <0.711, -0.127, -0.643> <0.711, -0.106, -0.650> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.749, -0.175, -0.629> <0.738, -0.175, -0.628> <0.724, -0.175, -0.627> <0.713, -0.175, -0.626> 
		<0.746, -0.203, -0.640> <0.736, -0.203, -0.640> <0.721, -0.203, -0.638> <0.710, -0.203, -0.637> 
		<0.737, -0.213, -0.694> <0.727, -0.213, -0.693> <0.712, -0.213, -0.692> <0.701, -0.213, -0.691> 
		<0.735, -0.241, -0.707> <0.724, -0.241, -0.706> <0.710, -0.241, -0.705> <0.699, -0.241, -0.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.735, -0.241, -0.707> <0.724, -0.241, -0.706> <0.710, -0.241, -0.705> <0.699, -0.241, -0.704> 
		<0.734, -0.258, -0.715> <0.723, -0.258, -0.714> <0.709, -0.258, -0.713> <0.698, -0.258, -0.712> 
		<0.736, -0.294, -0.703> <0.725, -0.294, -0.702> <0.711, -0.294, -0.701> <0.700, -0.294, -0.700> 
		<0.739, -0.299, -0.685> <0.728, -0.299, -0.684> <0.714, -0.299, -0.683> <0.703, -0.299, -0.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.739, -0.299, -0.685> <0.728, -0.299, -0.684> <0.714, -0.299, -0.683> <0.703, -0.299, -0.682> 
		<0.744, -0.307, -0.656> <0.734, -0.307, -0.656> <0.719, -0.307, -0.654> <0.709, -0.307, -0.653> 
		<0.752, -0.280, -0.618> <0.741, -0.280, -0.617> <0.726, -0.280, -0.616> <0.716, -0.280, -0.615> 
		<0.757, -0.272, -0.589> <0.746, -0.272, -0.588> <0.732, -0.272, -0.587> <0.721, -0.272, -0.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.851, -0.189, 0.760> <1.840, -0.189, 0.759> <1.825, -0.189, 0.758> <1.815, -0.189, 0.757> 
		<1.848, -0.217, 0.772> <1.837, -0.217, 0.771> <1.823, -0.217, 0.769> <1.812, -0.217, 0.769> 
		<1.839, -0.226, 0.825> <1.828, -0.226, 0.825> <1.814, -0.226, 0.823> <1.803, -0.226, 0.822> 
		<1.837, -0.254, 0.838> <1.826, -0.254, 0.837> <1.812, -0.254, 0.836> <1.801, -0.254, 0.835> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.851, -0.189, 0.760> <1.848, -0.217, 0.772> <1.839, -0.226, 0.825> <1.837, -0.254, 0.838> 
		<1.861, -0.189, 0.761> <1.859, -0.217, 0.773> <1.850, -0.226, 0.826> <1.848, -0.254, 0.839> 
		<1.876, -0.189, 0.762> <1.873, -0.217, 0.774> <1.864, -0.226, 0.828> <1.862, -0.254, 0.840> 
		<1.886, -0.189, 0.763> <1.884, -0.217, 0.775> <1.875, -0.226, 0.829> <1.873, -0.254, 0.841> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.851, -0.189, 0.760> <1.852, -0.168, 0.752> <1.849, -0.140, 0.777> <1.848, -0.120, 0.785> 
		<1.840, -0.189, 0.759> <1.842, -0.168, 0.751> <1.838, -0.140, 0.776> <1.838, -0.120, 0.784> 
		<1.825, -0.189, 0.758> <1.827, -0.168, 0.750> <1.824, -0.140, 0.775> <1.823, -0.120, 0.783> 
		<1.815, -0.189, 0.757> <1.816, -0.168, 0.749> <1.813, -0.140, 0.774> <1.813, -0.120, 0.782> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.851, -0.189, 0.760> <1.861, -0.189, 0.761> <1.876, -0.189, 0.762> <1.886, -0.189, 0.763> 
		<1.852, -0.168, 0.752> <1.863, -0.168, 0.753> <1.877, -0.168, 0.754> <1.888, -0.168, 0.755> 
		<1.849, -0.140, 0.777> <1.860, -0.140, 0.778> <1.874, -0.140, 0.780> <1.885, -0.140, 0.780> 
		<1.848, -0.120, 0.785> <1.859, -0.120, 0.786> <1.874, -0.120, 0.787> <1.884, -0.120, 0.788> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.837, -0.254, 0.838> <1.826, -0.254, 0.837> <1.812, -0.254, 0.836> <1.801, -0.254, 0.835> 
		<1.836, -0.271, 0.846> <1.825, -0.271, 0.845> <1.811, -0.271, 0.844> <1.800, -0.271, 0.843> 
		<1.838, -0.308, 0.834> <1.827, -0.308, 0.833> <1.813, -0.308, 0.832> <1.802, -0.308, 0.831> 
		<1.841, -0.313, 0.817> <1.830, -0.313, 0.816> <1.816, -0.313, 0.814> <1.805, -0.313, 0.813> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.837, -0.254, 0.838> <1.836, -0.271, 0.846> <1.838, -0.308, 0.834> <1.841, -0.313, 0.817> 
		<1.848, -0.254, 0.839> <1.846, -0.271, 0.847> <1.848, -0.308, 0.835> <1.852, -0.313, 0.817> 
		<1.862, -0.254, 0.840> <1.861, -0.271, 0.848> <1.863, -0.308, 0.836> <1.866, -0.313, 0.819> 
		<1.873, -0.254, 0.841> <1.872, -0.271, 0.849> <1.873, -0.308, 0.837> <1.877, -0.313, 0.820> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.841, -0.313, 0.817> <1.846, -0.321, 0.788> <1.853, -0.294, 0.749> <1.859, -0.286, 0.720> 
		<1.852, -0.313, 0.817> <1.857, -0.321, 0.789> <1.864, -0.294, 0.750> <1.870, -0.286, 0.721> 
		<1.866, -0.313, 0.819> <1.871, -0.321, 0.790> <1.879, -0.294, 0.751> <1.884, -0.286, 0.723> 
		<1.877, -0.313, 0.820> <1.882, -0.321, 0.791> <1.889, -0.294, 0.752> <1.895, -0.286, 0.723> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.841, -0.313, 0.817> <1.830, -0.313, 0.816> <1.816, -0.313, 0.814> <1.805, -0.313, 0.813> 
		<1.846, -0.321, 0.788> <1.835, -0.321, 0.787> <1.821, -0.321, 0.785> <1.810, -0.321, 0.785> 
		<1.853, -0.294, 0.749> <1.843, -0.294, 0.748> <1.828, -0.294, 0.747> <1.818, -0.294, 0.746> 
		<1.859, -0.286, 0.720> <1.848, -0.286, 0.719> <1.834, -0.286, 0.718> <1.823, -0.286, 0.717> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.805, -0.313, 0.813> <1.802, -0.308, 0.831> <1.800, -0.271, 0.843> <1.801, -0.254, 0.835> 
		<1.794, -0.313, 0.812> <1.791, -0.308, 0.830> <1.789, -0.271, 0.842> <1.790, -0.254, 0.834> 
		<1.780, -0.313, 0.811> <1.777, -0.308, 0.829> <1.775, -0.271, 0.841> <1.776, -0.254, 0.833> 
		<1.769, -0.313, 0.810> <1.766, -0.308, 0.828> <1.764, -0.271, 0.840> <1.765, -0.254, 0.832> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.805, -0.313, 0.813> <1.794, -0.313, 0.812> <1.780, -0.313, 0.811> <1.769, -0.313, 0.810> 
		<1.810, -0.321, 0.785> <1.800, -0.321, 0.784> <1.785, -0.321, 0.782> <1.775, -0.321, 0.781> 
		<1.818, -0.294, 0.746> <1.807, -0.294, 0.745> <1.792, -0.294, 0.744> <1.782, -0.294, 0.743> 
		<1.823, -0.286, 0.717> <1.812, -0.286, 0.716> <1.798, -0.286, 0.715> <1.787, -0.286, 0.714> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.801, -0.254, 0.835> <1.803, -0.226, 0.822> <1.812, -0.217, 0.769> <1.815, -0.189, 0.757> 
		<1.790, -0.254, 0.834> <1.793, -0.226, 0.821> <1.802, -0.217, 0.768> <1.804, -0.189, 0.756> 
		<1.776, -0.254, 0.833> <1.778, -0.226, 0.820> <1.787, -0.217, 0.766> <1.790, -0.189, 0.755> 
		<1.765, -0.254, 0.832> <1.767, -0.226, 0.819> <1.776, -0.217, 0.765> <1.779, -0.189, 0.754> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.815, -0.189, 0.757> <1.816, -0.168, 0.749> <1.813, -0.140, 0.774> <1.813, -0.120, 0.782> 
		<1.804, -0.189, 0.756> <1.806, -0.168, 0.748> <1.802, -0.140, 0.773> <1.802, -0.120, 0.781> 
		<1.790, -0.189, 0.755> <1.791, -0.168, 0.747> <1.788, -0.140, 0.772> <1.787, -0.120, 0.779> 
		<1.779, -0.189, 0.754> <1.781, -0.168, 0.746> <1.777, -0.140, 0.771> <1.777, -0.120, 0.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.779, -0.189, 0.754> <1.781, -0.168, 0.746> <1.777, -0.140, 0.771> <1.777, -0.120, 0.778> 
		<1.768, -0.189, 0.753> <1.770, -0.168, 0.745> <1.767, -0.140, 0.770> <1.766, -0.120, 0.778> 
		<1.754, -0.189, 0.752> <1.755, -0.168, 0.744> <1.752, -0.140, 0.769> <1.752, -0.120, 0.776> 
		<1.743, -0.189, 0.751> <1.745, -0.168, 0.743> <1.742, -0.140, 0.768> <1.741, -0.120, 0.775> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.779, -0.189, 0.754> <1.768, -0.189, 0.753> <1.754, -0.189, 0.752> <1.743, -0.189, 0.751> 
		<1.776, -0.217, 0.765> <1.766, -0.217, 0.764> <1.751, -0.217, 0.763> <1.741, -0.217, 0.762> 
		<1.767, -0.226, 0.819> <1.757, -0.226, 0.818> <1.742, -0.226, 0.817> <1.732, -0.226, 0.816> 
		<1.765, -0.254, 0.832> <1.755, -0.254, 0.831> <1.740, -0.254, 0.830> <1.729, -0.254, 0.829> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.765, -0.254, 0.832> <1.755, -0.254, 0.831> <1.740, -0.254, 0.830> <1.729, -0.254, 0.829> 
		<1.764, -0.271, 0.840> <1.753, -0.271, 0.839> <1.739, -0.271, 0.837> <1.728, -0.271, 0.837> 
		<1.766, -0.308, 0.828> <1.755, -0.308, 0.827> <1.741, -0.308, 0.826> <1.730, -0.308, 0.825> 
		<1.769, -0.313, 0.810> <1.758, -0.313, 0.809> <1.744, -0.313, 0.808> <1.733, -0.313, 0.807> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.769, -0.313, 0.810> <1.758, -0.313, 0.809> <1.744, -0.313, 0.808> <1.733, -0.313, 0.807> 
		<1.775, -0.321, 0.781> <1.764, -0.321, 0.780> <1.749, -0.321, 0.779> <1.739, -0.321, 0.778> 
		<1.782, -0.294, 0.743> <1.771, -0.294, 0.742> <1.757, -0.294, 0.741> <1.746, -0.294, 0.740> 
		<1.787, -0.286, 0.714> <1.776, -0.286, 0.713> <1.762, -0.286, 0.712> <1.751, -0.286, 0.711> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, -0.189, 0.659> <0.798, -0.189, 0.658> <0.783, -0.189, 0.657> <0.772, -0.189, 0.656> 
		<0.806, -0.217, 0.671> <0.795, -0.217, 0.670> <0.781, -0.217, 0.669> <0.770, -0.217, 0.668> 
		<0.797, -0.226, 0.725> <0.786, -0.226, 0.724> <0.772, -0.226, 0.722> <0.761, -0.226, 0.722> 
		<0.795, -0.254, 0.737> <0.784, -0.254, 0.736> <0.770, -0.254, 0.735> <0.759, -0.254, 0.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, -0.189, 0.659> <0.806, -0.217, 0.671> <0.797, -0.226, 0.725> <0.795, -0.254, 0.737> 
		<0.819, -0.189, 0.660> <0.817, -0.217, 0.672> <0.808, -0.226, 0.726> <0.806, -0.254, 0.738> 
		<0.833, -0.189, 0.662> <0.831, -0.217, 0.673> <0.822, -0.226, 0.727> <0.820, -0.254, 0.739> 
		<0.844, -0.189, 0.663> <0.842, -0.217, 0.674> <0.833, -0.226, 0.728> <0.831, -0.254, 0.740> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, -0.189, 0.659> <0.810, -0.168, 0.651> <0.807, -0.140, 0.677> <0.806, -0.120, 0.684> 
		<0.798, -0.189, 0.658> <0.799, -0.168, 0.650> <0.796, -0.140, 0.676> <0.795, -0.120, 0.683> 
		<0.783, -0.189, 0.657> <0.785, -0.168, 0.649> <0.782, -0.140, 0.674> <0.781, -0.120, 0.682> 
		<0.772, -0.189, 0.656> <0.774, -0.168, 0.648> <0.771, -0.140, 0.673> <0.770, -0.120, 0.681> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, -0.189, 0.659> <0.819, -0.189, 0.660> <0.833, -0.189, 0.662> <0.844, -0.189, 0.663> 
		<0.810, -0.168, 0.651> <0.821, -0.168, 0.652> <0.835, -0.168, 0.654> <0.846, -0.168, 0.654> 
		<0.807, -0.140, 0.677> <0.818, -0.140, 0.677> <0.832, -0.140, 0.679> <0.843, -0.140, 0.680> 
		<0.806, -0.120, 0.684> <0.817, -0.120, 0.685> <0.831, -0.120, 0.686> <0.842, -0.120, 0.687> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.795, -0.254, 0.737> <0.784, -0.254, 0.736> <0.770, -0.254, 0.735> <0.759, -0.254, 0.734> 
		<0.793, -0.271, 0.745> <0.783, -0.271, 0.744> <0.768, -0.271, 0.743> <0.758, -0.271, 0.742> 
		<0.795, -0.308, 0.733> <0.785, -0.308, 0.733> <0.770, -0.308, 0.731> <0.760, -0.308, 0.730> 
		<0.799, -0.313, 0.716> <0.788, -0.313, 0.715> <0.774, -0.313, 0.713> <0.763, -0.313, 0.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.795, -0.254, 0.737> <0.793, -0.271, 0.745> <0.795, -0.308, 0.733> <0.799, -0.313, 0.716> 
		<0.806, -0.254, 0.738> <0.804, -0.271, 0.746> <0.806, -0.308, 0.734> <0.809, -0.313, 0.717> 
		<0.820, -0.254, 0.739> <0.819, -0.271, 0.747> <0.820, -0.308, 0.736> <0.824, -0.313, 0.718> 
		<0.831, -0.254, 0.740> <0.829, -0.271, 0.748> <0.831, -0.308, 0.737> <0.835, -0.313, 0.719> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.799, -0.313, 0.716> <0.804, -0.321, 0.687> <0.811, -0.294, 0.648> <0.817, -0.286, 0.620> 
		<0.809, -0.313, 0.717> <0.815, -0.321, 0.688> <0.822, -0.294, 0.649> <0.827, -0.286, 0.620> 
		<0.824, -0.313, 0.718> <0.829, -0.321, 0.689> <0.836, -0.294, 0.651> <0.842, -0.286, 0.622> 
		<0.835, -0.313, 0.719> <0.840, -0.321, 0.690> <0.847, -0.294, 0.651> <0.852, -0.286, 0.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.799, -0.313, 0.716> <0.788, -0.313, 0.715> <0.774, -0.313, 0.713> <0.763, -0.313, 0.713> 
		<0.804, -0.321, 0.687> <0.793, -0.321, 0.686> <0.779, -0.321, 0.685> <0.768, -0.321, 0.684> 
		<0.811, -0.294, 0.648> <0.800, -0.294, 0.647> <0.786, -0.294, 0.646> <0.775, -0.294, 0.645> 
		<0.817, -0.286, 0.620> <0.806, -0.286, 0.619> <0.791, -0.286, 0.617> <0.781, -0.286, 0.616> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.763, -0.313, 0.713> <0.760, -0.308, 0.730> <0.758, -0.271, 0.742> <0.759, -0.254, 0.734> 
		<0.752, -0.313, 0.712> <0.749, -0.308, 0.729> <0.747, -0.271, 0.741> <0.748, -0.254, 0.733> 
		<0.738, -0.313, 0.710> <0.734, -0.308, 0.728> <0.733, -0.271, 0.740> <0.734, -0.254, 0.732> 
		<0.727, -0.313, 0.709> <0.724, -0.308, 0.727> <0.722, -0.271, 0.739> <0.723, -0.254, 0.731> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.763, -0.313, 0.713> <0.752, -0.313, 0.712> <0.738, -0.313, 0.710> <0.727, -0.313, 0.709> 
		<0.768, -0.321, 0.684> <0.757, -0.321, 0.683> <0.743, -0.321, 0.681> <0.732, -0.321, 0.681> 
		<0.775, -0.294, 0.645> <0.765, -0.294, 0.644> <0.750, -0.294, 0.643> <0.739, -0.294, 0.642> 
		<0.781, -0.286, 0.616> <0.770, -0.286, 0.615> <0.756, -0.286, 0.614> <0.745, -0.286, 0.613> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.759, -0.254, 0.734> <0.761, -0.226, 0.722> <0.770, -0.217, 0.668> <0.772, -0.189, 0.656> 
		<0.748, -0.254, 0.733> <0.750, -0.226, 0.721> <0.759, -0.217, 0.667> <0.762, -0.189, 0.655> 
		<0.734, -0.254, 0.732> <0.736, -0.226, 0.719> <0.745, -0.217, 0.665> <0.747, -0.189, 0.654> 
		<0.723, -0.254, 0.731> <0.725, -0.226, 0.718> <0.734, -0.217, 0.665> <0.737, -0.189, 0.653> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.772, -0.189, 0.656> <0.774, -0.168, 0.648> <0.771, -0.140, 0.673> <0.770, -0.120, 0.681> 
		<0.762, -0.189, 0.655> <0.763, -0.168, 0.647> <0.760, -0.140, 0.672> <0.760, -0.120, 0.680> 
		<0.747, -0.189, 0.654> <0.749, -0.168, 0.646> <0.746, -0.140, 0.671> <0.745, -0.120, 0.679> 
		<0.737, -0.189, 0.653> <0.738, -0.168, 0.645> <0.735, -0.140, 0.670> <0.735, -0.120, 0.678> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.737, -0.189, 0.653> <0.738, -0.168, 0.645> <0.735, -0.140, 0.670> <0.735, -0.120, 0.678> 
		<0.726, -0.189, 0.652> <0.728, -0.168, 0.644> <0.724, -0.140, 0.669> <0.724, -0.120, 0.677> 
		<0.712, -0.189, 0.651> <0.713, -0.168, 0.643> <0.710, -0.140, 0.668> <0.709, -0.120, 0.675> 
		<0.701, -0.189, 0.650> <0.703, -0.168, 0.642> <0.699, -0.140, 0.667> <0.699, -0.120, 0.675> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.737, -0.189, 0.653> <0.726, -0.189, 0.652> <0.712, -0.189, 0.651> <0.701, -0.189, 0.650> 
		<0.734, -0.217, 0.665> <0.723, -0.217, 0.664> <0.709, -0.217, 0.662> <0.698, -0.217, 0.661> 
		<0.725, -0.226, 0.718> <0.714, -0.226, 0.717> <0.700, -0.226, 0.716> <0.689, -0.226, 0.715> 
		<0.723, -0.254, 0.731> <0.712, -0.254, 0.730> <0.698, -0.254, 0.729> <0.687, -0.254, 0.728> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.723, -0.254, 0.731> <0.712, -0.254, 0.730> <0.698, -0.254, 0.729> <0.687, -0.254, 0.728> 
		<0.722, -0.271, 0.739> <0.711, -0.271, 0.738> <0.697, -0.271, 0.737> <0.686, -0.271, 0.736> 
		<0.724, -0.308, 0.727> <0.713, -0.308, 0.726> <0.699, -0.308, 0.725> <0.688, -0.308, 0.724> 
		<0.727, -0.313, 0.709> <0.716, -0.313, 0.709> <0.702, -0.313, 0.707> <0.691, -0.313, 0.706> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.727, -0.313, 0.709> <0.716, -0.313, 0.709> <0.702, -0.313, 0.707> <0.691, -0.313, 0.706> 
		<0.732, -0.321, 0.681> <0.722, -0.321, 0.680> <0.707, -0.321, 0.678> <0.696, -0.321, 0.677> 
		<0.739, -0.294, 0.642> <0.729, -0.294, 0.641> <0.714, -0.294, 0.640> <0.704, -0.294, 0.639> 
		<0.745, -0.286, 0.613> <0.734, -0.286, 0.612> <0.720, -0.286, 0.611> <0.709, -0.286, 0.610> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.709, -0.510, -0.303> <0.709, -0.510, -0.342> <0.709, -0.510, -0.395> <0.709, -0.510, -0.434> 
		<0.773, -0.521, -0.303> <0.773, -0.521, -0.342> <0.773, -0.521, -0.395> <0.773, -0.521, -0.434> 
		<0.862, -0.525, -0.303> <0.862, -0.525, -0.342> <0.862, -0.525, -0.395> <0.862, -0.525, -0.434> 
		<0.925, -0.545, -0.303> <0.925, -0.545, -0.342> <0.925, -0.545, -0.395> <0.925, -0.545, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.925, -0.545, -0.303> <0.925, -0.545, -0.342> <0.925, -0.545, -0.395> <0.925, -0.545, -0.434> 
		<1.009, -0.572, -0.303> <1.009, -0.572, -0.342> <1.009, -0.572, -0.395> <1.009, -0.572, -0.434> 
		<1.123, -0.612, -0.303> <1.123, -0.612, -0.342> <1.123, -0.612, -0.395> <1.123, -0.612, -0.434> 
		<1.193, -0.666, -0.303> <1.193, -0.666, -0.342> <1.193, -0.666, -0.395> <1.193, -0.666, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.193, -0.666, -0.303> <1.193, -0.666, -0.342> <1.193, -0.666, -0.395> <1.193, -0.666, -0.434> 
		<1.247, -0.708, -0.303> <1.247, -0.708, -0.342> <1.247, -0.708, -0.395> <1.247, -0.708, -0.434> 
		<1.270, -0.811, -0.303> <1.270, -0.811, -0.342> <1.270, -0.811, -0.395> <1.270, -0.811, -0.434> 
		<1.322, -0.856, -0.303> <1.322, -0.856, -0.342> <1.322, -0.856, -0.395> <1.322, -0.856, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.322, -0.856, -0.303> <1.322, -0.856, -0.342> <1.322, -0.856, -0.395> <1.322, -0.856, -0.434> 
		<1.367, -0.895, -0.303> <1.367, -0.895, -0.342> <1.367, -0.895, -0.395> <1.367, -0.895, -0.434> 
		<1.445, -0.936, -0.303> <1.445, -0.936, -0.342> <1.445, -0.936, -0.395> <1.445, -0.936, -0.434> 
		<1.504, -0.934, -0.303> <1.504, -0.934, -0.342> <1.504, -0.934, -0.395> <1.504, -0.934, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.504, -0.934, -0.303> <1.504, -0.934, -0.342> <1.504, -0.934, -0.395> <1.504, -0.934, -0.434> 
		<1.577, -0.931, -0.303> <1.577, -0.931, -0.342> <1.577, -0.931, -0.395> <1.577, -0.931, -0.434> 
		<1.672, -0.885, -0.303> <1.672, -0.885, -0.342> <1.672, -0.885, -0.395> <1.672, -0.885, -0.434> 
		<1.729, -0.839, -0.303> <1.729, -0.839, -0.342> <1.729, -0.839, -0.395> <1.729, -0.839, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.729, -0.839, -0.303> <1.729, -0.839, -0.342> <1.729, -0.839, -0.395> <1.729, -0.839, -0.434> 
		<1.796, -0.783, -0.303> <1.796, -0.783, -0.342> <1.796, -0.783, -0.395> <1.796, -0.783, -0.434> 
		<1.850, -0.675, -0.303> <1.850, -0.675, -0.342> <1.850, -0.675, -0.395> <1.850, -0.675, -0.434> 
		<1.902, -0.605, -0.303> <1.902, -0.605, -0.342> <1.902, -0.605, -0.395> <1.902, -0.605, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.717, -0.517, 0.379> <0.717, -0.517, 0.340> <0.717, -0.517, 0.287> <0.717, -0.517, 0.248> 
		<0.782, -0.528, 0.379> <0.782, -0.528, 0.340> <0.782, -0.528, 0.287> <0.782, -0.528, 0.248> 
		<0.871, -0.532, 0.379> <0.871, -0.532, 0.340> <0.871, -0.532, 0.287> <0.871, -0.532, 0.248> 
		<0.933, -0.552, 0.379> <0.933, -0.552, 0.340> <0.933, -0.552, 0.287> <0.933, -0.552, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.933, -0.552, 0.379> <0.933, -0.552, 0.340> <0.933, -0.552, 0.287> <0.933, -0.552, 0.248> 
		<1.017, -0.579, 0.379> <1.017, -0.579, 0.340> <1.017, -0.579, 0.287> <1.017, -0.579, 0.248> 
		<1.132, -0.618, 0.379> <1.132, -0.618, 0.340> <1.132, -0.618, 0.287> <1.132, -0.618, 0.248> 
		<1.201, -0.673, 0.379> <1.201, -0.673, 0.340> <1.201, -0.673, 0.287> <1.201, -0.673, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.201, -0.673, 0.379> <1.201, -0.673, 0.340> <1.201, -0.673, 0.287> <1.201, -0.673, 0.248> 
		<1.256, -0.715, 0.379> <1.256, -0.715, 0.340> <1.256, -0.715, 0.287> <1.256, -0.715, 0.248> 
		<1.279, -0.818, 0.379> <1.279, -0.818, 0.340> <1.279, -0.818, 0.287> <1.279, -0.818, 0.248> 
		<1.331, -0.863, 0.379> <1.331, -0.863, 0.340> <1.331, -0.863, 0.287> <1.331, -0.863, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.331, -0.863, 0.379> <1.331, -0.863, 0.340> <1.331, -0.863, 0.287> <1.331, -0.863, 0.248> 
		<1.376, -0.902, 0.379> <1.376, -0.902, 0.340> <1.376, -0.902, 0.287> <1.376, -0.902, 0.248> 
		<1.453, -0.943, 0.379> <1.453, -0.943, 0.340> <1.453, -0.943, 0.287> <1.453, -0.943, 0.248> 
		<1.513, -0.941, 0.379> <1.513, -0.941, 0.340> <1.513, -0.941, 0.287> <1.513, -0.941, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.513, -0.941, 0.379> <1.513, -0.941, 0.340> <1.513, -0.941, 0.287> <1.513, -0.941, 0.248> 
		<1.586, -0.938, 0.379> <1.586, -0.938, 0.340> <1.586, -0.938, 0.287> <1.586, -0.938, 0.248> 
		<1.681, -0.892, 0.379> <1.681, -0.892, 0.340> <1.681, -0.892, 0.287> <1.681, -0.892, 0.248> 
		<1.737, -0.846, 0.379> <1.737, -0.846, 0.340> <1.737, -0.846, 0.287> <1.737, -0.846, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.737, -0.846, 0.379> <1.737, -0.846, 0.340> <1.737, -0.846, 0.287> <1.737, -0.846, 0.248> 
		<1.805, -0.790, 0.379> <1.805, -0.790, 0.340> <1.805, -0.790, 0.287> <1.805, -0.790, 0.248> 
		<1.858, -0.682, 0.379> <1.858, -0.682, 0.340> <1.858, -0.682, 0.287> <1.858, -0.682, 0.248> 
		<1.910, -0.612, 0.379> <1.910, -0.612, 0.340> <1.910, -0.612, 0.287> <1.910, -0.612, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.709, -0.510, -0.303> <0.709, -0.510, -0.342> <0.709, -0.510, -0.395> <0.709, -0.510, -0.434> 
		<0.773, -0.521, -0.303> <0.773, -0.521, -0.342> <0.773, -0.521, -0.395> <0.773, -0.521, -0.434> 
		<0.862, -0.525, -0.303> <0.862, -0.525, -0.342> <0.862, -0.525, -0.395> <0.862, -0.525, -0.434> 
		<0.925, -0.545, -0.303> <0.925, -0.545, -0.342> <0.925, -0.545, -0.395> <0.925, -0.545, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.925, -0.545, -0.303> <0.925, -0.545, -0.342> <0.925, -0.545, -0.395> <0.925, -0.545, -0.434> 
		<1.009, -0.572, -0.303> <1.009, -0.572, -0.342> <1.009, -0.572, -0.395> <1.009, -0.572, -0.434> 
		<1.123, -0.612, -0.303> <1.123, -0.612, -0.342> <1.123, -0.612, -0.395> <1.123, -0.612, -0.434> 
		<1.193, -0.666, -0.303> <1.193, -0.666, -0.342> <1.193, -0.666, -0.395> <1.193, -0.666, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.193, -0.666, -0.303> <1.193, -0.666, -0.342> <1.193, -0.666, -0.395> <1.193, -0.666, -0.434> 
		<1.247, -0.708, -0.303> <1.247, -0.708, -0.342> <1.247, -0.708, -0.395> <1.247, -0.708, -0.434> 
		<1.270, -0.811, -0.303> <1.270, -0.811, -0.342> <1.270, -0.811, -0.395> <1.270, -0.811, -0.434> 
		<1.322, -0.856, -0.303> <1.322, -0.856, -0.342> <1.322, -0.856, -0.395> <1.322, -0.856, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.322, -0.856, -0.303> <1.322, -0.856, -0.342> <1.322, -0.856, -0.395> <1.322, -0.856, -0.434> 
		<1.367, -0.895, -0.303> <1.367, -0.895, -0.342> <1.367, -0.895, -0.395> <1.367, -0.895, -0.434> 
		<1.445, -0.936, -0.303> <1.445, -0.936, -0.342> <1.445, -0.936, -0.395> <1.445, -0.936, -0.434> 
		<1.504, -0.934, -0.303> <1.504, -0.934, -0.342> <1.504, -0.934, -0.395> <1.504, -0.934, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.504, -0.934, -0.303> <1.504, -0.934, -0.342> <1.504, -0.934, -0.395> <1.504, -0.934, -0.434> 
		<1.577, -0.931, -0.303> <1.577, -0.931, -0.342> <1.577, -0.931, -0.395> <1.577, -0.931, -0.434> 
		<1.672, -0.885, -0.303> <1.672, -0.885, -0.342> <1.672, -0.885, -0.395> <1.672, -0.885, -0.434> 
		<1.729, -0.839, -0.303> <1.729, -0.839, -0.342> <1.729, -0.839, -0.395> <1.729, -0.839, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.729, -0.839, -0.303> <1.729, -0.839, -0.342> <1.729, -0.839, -0.395> <1.729, -0.839, -0.434> 
		<1.796, -0.783, -0.303> <1.796, -0.783, -0.342> <1.796, -0.783, -0.395> <1.796, -0.783, -0.434> 
		<1.850, -0.675, -0.303> <1.850, -0.675, -0.342> <1.850, -0.675, -0.395> <1.850, -0.675, -0.434> 
		<1.902, -0.605, -0.303> <1.902, -0.605, -0.342> <1.902, -0.605, -0.395> <1.902, -0.605, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.717, -0.517, 0.379> <0.717, -0.517, 0.340> <0.717, -0.517, 0.287> <0.717, -0.517, 0.248> 
		<0.782, -0.528, 0.379> <0.782, -0.528, 0.340> <0.782, -0.528, 0.287> <0.782, -0.528, 0.248> 
		<0.871, -0.532, 0.379> <0.871, -0.532, 0.340> <0.871, -0.532, 0.287> <0.871, -0.532, 0.248> 
		<0.933, -0.552, 0.379> <0.933, -0.552, 0.340> <0.933, -0.552, 0.287> <0.933, -0.552, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.933, -0.552, 0.379> <0.933, -0.552, 0.340> <0.933, -0.552, 0.287> <0.933, -0.552, 0.248> 
		<1.017, -0.579, 0.379> <1.017, -0.579, 0.340> <1.017, -0.579, 0.287> <1.017, -0.579, 0.248> 
		<1.132, -0.618, 0.379> <1.132, -0.618, 0.340> <1.132, -0.618, 0.287> <1.132, -0.618, 0.248> 
		<1.201, -0.673, 0.379> <1.201, -0.673, 0.340> <1.201, -0.673, 0.287> <1.201, -0.673, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.201, -0.673, 0.379> <1.201, -0.673, 0.340> <1.201, -0.673, 0.287> <1.201, -0.673, 0.248> 
		<1.256, -0.715, 0.379> <1.256, -0.715, 0.340> <1.256, -0.715, 0.287> <1.256, -0.715, 0.248> 
		<1.279, -0.818, 0.379> <1.279, -0.818, 0.340> <1.279, -0.818, 0.287> <1.279, -0.818, 0.248> 
		<1.331, -0.863, 0.379> <1.331, -0.863, 0.340> <1.331, -0.863, 0.287> <1.331, -0.863, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.331, -0.863, 0.379> <1.331, -0.863, 0.340> <1.331, -0.863, 0.287> <1.331, -0.863, 0.248> 
		<1.376, -0.902, 0.379> <1.376, -0.902, 0.340> <1.376, -0.902, 0.287> <1.376, -0.902, 0.248> 
		<1.453, -0.943, 0.379> <1.453, -0.943, 0.340> <1.453, -0.943, 0.287> <1.453, -0.943, 0.248> 
		<1.513, -0.941, 0.379> <1.513, -0.941, 0.340> <1.513, -0.941, 0.287> <1.513, -0.941, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.513, -0.941, 0.379> <1.513, -0.941, 0.340> <1.513, -0.941, 0.287> <1.513, -0.941, 0.248> 
		<1.586, -0.938, 0.379> <1.586, -0.938, 0.340> <1.586, -0.938, 0.287> <1.586, -0.938, 0.248> 
		<1.681, -0.892, 0.379> <1.681, -0.892, 0.340> <1.681, -0.892, 0.287> <1.681, -0.892, 0.248> 
		<1.737, -0.846, 0.379> <1.737, -0.846, 0.340> <1.737, -0.846, 0.287> <1.737, -0.846, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.737, -0.846, 0.379> <1.737, -0.846, 0.340> <1.737, -0.846, 0.287> <1.737, -0.846, 0.248> 
		<1.805, -0.790, 0.379> <1.805, -0.790, 0.340> <1.805, -0.790, 0.287> <1.805, -0.790, 0.248> 
		<1.858, -0.682, 0.379> <1.858, -0.682, 0.340> <1.858, -0.682, 0.287> <1.858, -0.682, 0.248> 
		<1.910, -0.612, 0.379> <1.910, -0.612, 0.340> <1.910, -0.612, 0.287> <1.910, -0.612, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.709, -0.510, -0.303> <0.709, -0.510, -0.342> <0.709, -0.510, -0.395> <0.709, -0.510, -0.434> 
		<0.773, -0.521, -0.303> <0.773, -0.521, -0.342> <0.773, -0.521, -0.395> <0.773, -0.521, -0.434> 
		<0.862, -0.525, -0.303> <0.862, -0.525, -0.342> <0.862, -0.525, -0.395> <0.862, -0.525, -0.434> 
		<0.925, -0.545, -0.303> <0.925, -0.545, -0.342> <0.925, -0.545, -0.395> <0.925, -0.545, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.925, -0.545, -0.303> <0.925, -0.545, -0.342> <0.925, -0.545, -0.395> <0.925, -0.545, -0.434> 
		<1.009, -0.572, -0.303> <1.009, -0.572, -0.342> <1.009, -0.572, -0.395> <1.009, -0.572, -0.434> 
		<1.123, -0.612, -0.303> <1.123, -0.612, -0.342> <1.123, -0.612, -0.395> <1.123, -0.612, -0.434> 
		<1.193, -0.666, -0.303> <1.193, -0.666, -0.342> <1.193, -0.666, -0.395> <1.193, -0.666, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.193, -0.666, -0.303> <1.193, -0.666, -0.342> <1.193, -0.666, -0.395> <1.193, -0.666, -0.434> 
		<1.247, -0.708, -0.303> <1.247, -0.708, -0.342> <1.247, -0.708, -0.395> <1.247, -0.708, -0.434> 
		<1.270, -0.811, -0.303> <1.270, -0.811, -0.342> <1.270, -0.811, -0.395> <1.270, -0.811, -0.434> 
		<1.322, -0.856, -0.303> <1.322, -0.856, -0.342> <1.322, -0.856, -0.395> <1.322, -0.856, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.322, -0.856, -0.303> <1.322, -0.856, -0.342> <1.322, -0.856, -0.395> <1.322, -0.856, -0.434> 
		<1.367, -0.895, -0.303> <1.367, -0.895, -0.342> <1.367, -0.895, -0.395> <1.367, -0.895, -0.434> 
		<1.445, -0.936, -0.303> <1.445, -0.936, -0.342> <1.445, -0.936, -0.395> <1.445, -0.936, -0.434> 
		<1.504, -0.934, -0.303> <1.504, -0.934, -0.342> <1.504, -0.934, -0.395> <1.504, -0.934, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.504, -0.934, -0.303> <1.504, -0.934, -0.342> <1.504, -0.934, -0.395> <1.504, -0.934, -0.434> 
		<1.577, -0.931, -0.303> <1.577, -0.931, -0.342> <1.577, -0.931, -0.395> <1.577, -0.931, -0.434> 
		<1.672, -0.885, -0.303> <1.672, -0.885, -0.342> <1.672, -0.885, -0.395> <1.672, -0.885, -0.434> 
		<1.729, -0.839, -0.303> <1.729, -0.839, -0.342> <1.729, -0.839, -0.395> <1.729, -0.839, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.729, -0.839, -0.303> <1.729, -0.839, -0.342> <1.729, -0.839, -0.395> <1.729, -0.839, -0.434> 
		<1.796, -0.783, -0.303> <1.796, -0.783, -0.342> <1.796, -0.783, -0.395> <1.796, -0.783, -0.434> 
		<1.850, -0.675, -0.303> <1.850, -0.675, -0.342> <1.850, -0.675, -0.395> <1.850, -0.675, -0.434> 
		<1.902, -0.605, -0.303> <1.902, -0.605, -0.342> <1.902, -0.605, -0.395> <1.902, -0.605, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.717, -0.517, 0.379> <0.717, -0.517, 0.340> <0.717, -0.517, 0.287> <0.717, -0.517, 0.248> 
		<0.782, -0.528, 0.379> <0.782, -0.528, 0.340> <0.782, -0.528, 0.287> <0.782, -0.528, 0.248> 
		<0.871, -0.532, 0.379> <0.871, -0.532, 0.340> <0.871, -0.532, 0.287> <0.871, -0.532, 0.248> 
		<0.933, -0.552, 0.379> <0.933, -0.552, 0.340> <0.933, -0.552, 0.287> <0.933, -0.552, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.933, -0.552, 0.379> <0.933, -0.552, 0.340> <0.933, -0.552, 0.287> <0.933, -0.552, 0.248> 
		<1.017, -0.579, 0.379> <1.017, -0.579, 0.340> <1.017, -0.579, 0.287> <1.017, -0.579, 0.248> 
		<1.132, -0.618, 0.379> <1.132, -0.618, 0.340> <1.132, -0.618, 0.287> <1.132, -0.618, 0.248> 
		<1.201, -0.673, 0.379> <1.201, -0.673, 0.340> <1.201, -0.673, 0.287> <1.201, -0.673, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.201, -0.673, 0.379> <1.201, -0.673, 0.340> <1.201, -0.673, 0.287> <1.201, -0.673, 0.248> 
		<1.256, -0.715, 0.379> <1.256, -0.715, 0.340> <1.256, -0.715, 0.287> <1.256, -0.715, 0.248> 
		<1.279, -0.818, 0.379> <1.279, -0.818, 0.340> <1.279, -0.818, 0.287> <1.279, -0.818, 0.248> 
		<1.331, -0.863, 0.379> <1.331, -0.863, 0.340> <1.331, -0.863, 0.287> <1.331, -0.863, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.331, -0.863, 0.379> <1.331, -0.863, 0.340> <1.331, -0.863, 0.287> <1.331, -0.863, 0.248> 
		<1.376, -0.902, 0.379> <1.376, -0.902, 0.340> <1.376, -0.902, 0.287> <1.376, -0.902, 0.248> 
		<1.453, -0.943, 0.379> <1.453, -0.943, 0.340> <1.453, -0.943, 0.287> <1.453, -0.943, 0.248> 
		<1.513, -0.941, 0.379> <1.513, -0.941, 0.340> <1.513, -0.941, 0.287> <1.513, -0.941, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.513, -0.941, 0.379> <1.513, -0.941, 0.340> <1.513, -0.941, 0.287> <1.513, -0.941, 0.248> 
		<1.586, -0.938, 0.379> <1.586, -0.938, 0.340> <1.586, -0.938, 0.287> <1.586, -0.938, 0.248> 
		<1.681, -0.892, 0.379> <1.681, -0.892, 0.340> <1.681, -0.892, 0.287> <1.681, -0.892, 0.248> 
		<1.737, -0.846, 0.379> <1.737, -0.846, 0.340> <1.737, -0.846, 0.287> <1.737, -0.846, 0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.737, -0.846, 0.379> <1.737, -0.846, 0.340> <1.737, -0.846, 0.287> <1.737, -0.846, 0.248> 
		<1.805, -0.790, 0.379> <1.805, -0.790, 0.340> <1.805, -0.790, 0.287> <1.805, -0.790, 0.248> 
		<1.858, -0.682, 0.379> <1.858, -0.682, 0.340> <1.858, -0.682, 0.287> <1.858, -0.682, 0.248> 
		<1.910, -0.612, 0.379> <1.910, -0.612, 0.340> <1.910, -0.612, 0.287> <1.910, -0.612, 0.248> 
	}
	#ifndef (IMPORT_SPATCH)
	texture { 
    pigment {
        granite
        color_map {
            [0.0 rgb <0.89, 0.51, 0.28>]
            [0.4 rgb <0.70, 0.13, 0.00>]
            [0.5 rgb <0.69, 0.41, 0.08>]
            [0.6 rgb <0.658824, 0.658824, 0.658824>]
            [1.0 rgb <0.89, 0.51, 0.28>]
        }
    }
    finish { ambient 0.2 diffuse 0.4 }
}
	#end
}

#declare tire =
// Layer 4
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.354, 0.124> <-0.142, -0.354, 0.059> <-0.017, -0.354, 0.059> 
		<-0.338, -0.354, -0.124> <-0.338, -0.354, 0.000> <-0.142, -0.479, 0.059> <-0.017, -0.479, 0.059> 
		<-0.142, -0.354, -0.059> <-0.142, -0.479, -0.059> <-0.017, -0.675, 0.000> <-0.017, -0.675, 0.124> 
		<-0.017, -0.354, -0.059> <-0.017, -0.479, -0.059> <-0.017, -0.675, -0.124> <-0.017, -0.675, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> 
		<-0.338, -0.527, 0.000> <-0.338, -0.527, -0.124> <-0.338, -0.527, -0.124> <-0.338, -0.354, -0.124> 
		<-0.190, -0.675, 0.000> <-0.190, -0.675, -0.124> <-0.142, -0.479, -0.059> <-0.142, -0.354, -0.059> 
		<-0.017, -0.675, 0.000> <-0.017, -0.675, -0.124> <-0.017, -0.479, -0.059> <-0.017, -0.354, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.354, -0.124> <-0.142, -0.354, -0.059> <-0.017, -0.354, -0.059> 
		<-0.338, -0.354, 0.124> <-0.338, -0.354, 0.000> <-0.142, -0.230, -0.059> <-0.017, -0.230, -0.059> 
		<-0.142, -0.354, 0.059> <-0.142, -0.230, 0.059> <-0.017, -0.034, 0.000> <-0.017, -0.034, -0.124> 
		<-0.017, -0.354, 0.059> <-0.017, -0.230, 0.059> <-0.017, -0.034, 0.124> <-0.017, -0.034, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> 
		<-0.338, -0.181, 0.000> <-0.338, -0.181, -0.124> <-0.338, -0.181, -0.124> <-0.338, -0.354, -0.124> 
		<-0.190, -0.034, 0.000> <-0.190, -0.034, -0.124> <-0.142, -0.230, -0.059> <-0.142, -0.354, -0.059> 
		<-0.017, -0.034, 0.000> <-0.017, -0.034, -0.124> <-0.017, -0.230, -0.059> <-0.017, -0.354, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.354, -0.124> <-0.142, -0.354, -0.059> <-0.017, -0.354, -0.059> 
		<-0.338, -0.181, 0.000> <-0.338, -0.181, -0.124> <-0.017, -0.354, -0.059> <0.107, -0.354, -0.059> 
		<-0.190, -0.034, 0.000> <-0.017, -0.034, 0.000> <0.303, -0.181, -0.124> <0.303, -0.354, -0.124> 
		<-0.017, -0.034, 0.000> <0.156, -0.034, 0.000> <0.303, -0.181, 0.000> <0.303, -0.354, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.354, -0.124> <-0.142, -0.354, -0.059> <-0.017, -0.354, -0.059> 
		<-0.338, -0.527, 0.000> <-0.338, -0.527, -0.124> <-0.017, -0.354, -0.059> <0.107, -0.354, -0.059> 
		<-0.190, -0.675, 0.000> <-0.017, -0.675, 0.000> <0.303, -0.527, -0.124> <0.303, -0.354, -0.124> 
		<-0.017, -0.675, 0.000> <0.156, -0.675, 0.000> <0.303, -0.527, 0.000> <0.303, -0.354, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> 
		<-0.338, -0.181, 0.000> <-0.338, -0.181, 0.124> <-0.338, -0.181, 0.124> <-0.338, -0.354, 0.124> 
		<-0.190, -0.034, 0.000> <-0.190, -0.034, 0.124> <-0.142, -0.230, 0.059> <-0.142, -0.354, 0.059> 
		<-0.017, -0.034, 0.000> <-0.017, -0.034, 0.124> <-0.017, -0.230, 0.059> <-0.017, -0.354, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> <-0.338, -0.354, 0.000> 
		<-0.338, -0.354, 0.124> <-0.338, -0.527, 0.124> <-0.338, -0.527, 0.124> <-0.338, -0.527, 0.000> 
		<-0.142, -0.354, 0.059> <-0.142, -0.479, 0.059> <-0.190, -0.675, 0.124> <-0.190, -0.675, 0.000> 
		<-0.017, -0.354, 0.059> <-0.017, -0.479, 0.059> <-0.017, -0.675, 0.124> <-0.017, -0.675, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.181, 0.000> <-0.190, -0.034, 0.000> <-0.017, -0.034, 0.000> 
		<-0.338, -0.354, 0.124> <-0.338, -0.181, 0.124> <-0.017, -0.034, 0.000> <0.156, -0.034, 0.000> 
		<-0.142, -0.354, 0.059> <-0.017, -0.354, 0.059> <0.303, -0.181, 0.124> <0.303, -0.181, 0.000> 
		<-0.017, -0.354, 0.059> <0.107, -0.354, 0.059> <0.303, -0.354, 0.124> <0.303, -0.354, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.354, 0.124> <-0.142, -0.354, 0.059> <-0.017, -0.354, 0.059> 
		<-0.338, -0.527, 0.000> <-0.338, -0.527, 0.124> <-0.017, -0.354, 0.059> <0.107, -0.354, 0.059> 
		<-0.190, -0.675, 0.000> <-0.017, -0.675, 0.000> <0.303, -0.527, 0.124> <0.303, -0.354, 0.124> 
		<-0.017, -0.675, 0.000> <0.156, -0.675, 0.000> <0.303, -0.527, 0.000> <0.303, -0.354, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.527, 0.000> <-0.190, -0.675, 0.000> <-0.017, -0.675, 0.000> 
		<-0.338, -0.181, 0.000> <-0.338, -0.354, 0.000> <-0.190, -0.675, 0.124> <-0.017, -0.675, 0.124> 
		<-0.190, -0.034, 0.000> <-0.190, -0.034, 0.124> <-0.017, -0.354, 0.059> <-0.017, -0.479, 0.059> 
		<-0.017, -0.034, 0.000> <-0.017, -0.034, 0.124> <-0.017, -0.230, 0.059> <-0.017, -0.354, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.354, 0.000> <-0.338, -0.527, 0.000> <-0.190, -0.675, 0.000> <-0.017, -0.675, 0.000> 
		<-0.338, -0.181, 0.000> <-0.338, -0.354, 0.000> <-0.190, -0.675, -0.124> <-0.017, -0.675, -0.124> 
		<-0.190, -0.034, 0.000> <-0.190, -0.034, -0.124> <-0.017, -0.354, -0.059> <-0.017, -0.479, -0.059> 
		<-0.017, -0.034, 0.000> <-0.017, -0.034, -0.124> <-0.017, -0.230, -0.059> <-0.017, -0.354, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, -0.354, 0.000> <0.303, -0.354, 0.124> <0.107, -0.354, 0.059> <-0.017, -0.354, 0.059> 
		<0.303, -0.354, -0.124> <0.303, -0.354, 0.000> <0.107, -0.230, 0.059> <-0.017, -0.230, 0.059> 
		<0.107, -0.354, -0.059> <0.107, -0.230, -0.059> <-0.017, -0.034, 0.000> <-0.017, -0.034, 0.124> 
		<-0.017, -0.354, -0.059> <-0.017, -0.230, -0.059> <-0.017, -0.034, -0.124> <-0.017, -0.034, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, -0.354, 0.000> <0.303, -0.354, 0.000> <0.303, -0.354, 0.000> <0.303, -0.354, 0.000> 
		<0.303, -0.181, 0.000> <0.303, -0.181, 0.124> <0.303, -0.181, 0.124> <0.303, -0.354, 0.124> 
		<0.156, -0.034, 0.000> <0.156, -0.034, 0.124> <0.107, -0.230, 0.059> <0.107, -0.354, 0.059> 
		<-0.017, -0.034, 0.000> <-0.017, -0.034, 0.124> <-0.017, -0.230, 0.059> <-0.017, -0.354, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, -0.354, 0.000> <0.303, -0.354, -0.124> <0.107, -0.354, -0.059> <-0.017, -0.354, -0.059> 
		<0.303, -0.354, 0.124> <0.303, -0.354, 0.000> <0.107, -0.479, -0.059> <-0.017, -0.479, -0.059> 
		<0.107, -0.354, 0.059> <0.107, -0.479, 0.059> <-0.017, -0.675, 0.000> <-0.017, -0.675, -0.124> 
		<-0.017, -0.354, 0.059> <-0.017, -0.479, 0.059> <-0.017, -0.675, 0.124> <-0.017, -0.675, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, -0.354, 0.000> <0.303, -0.354, 0.000> <0.303, -0.354, 0.000> <0.303, -0.354, 0.000> 
		<0.303, -0.527, 0.000> <0.303, -0.527, 0.124> <0.303, -0.527, 0.124> <0.303, -0.354, 0.124> 
		<0.156, -0.675, 0.000> <0.156, -0.675, 0.124> <0.107, -0.479, 0.059> <0.107, -0.354, 0.059> 
		<-0.017, -0.675, 0.000> <-0.017, -0.675, 0.124> <-0.017, -0.479, 0.059> <-0.017, -0.354, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, -0.354, 0.000> <0.303, -0.354, 0.000> <0.303, -0.354, 0.000> <0.303, -0.354, 0.000> 
		<0.303, -0.527, 0.000> <0.303, -0.527, -0.124> <0.303, -0.527, -0.124> <0.303, -0.354, -0.124> 
		<0.156, -0.675, 0.000> <0.156, -0.675, -0.124> <0.107, -0.479, -0.059> <0.107, -0.354, -0.059> 
		<-0.017, -0.675, 0.000> <-0.017, -0.675, -0.124> <-0.017, -0.479, -0.059> <-0.017, -0.354, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, -0.354, 0.000> <0.303, -0.354, 0.000> <0.303, -0.354, 0.000> <0.303, -0.354, 0.000> 
		<0.303, -0.181, 0.000> <0.303, -0.181, -0.124> <0.303, -0.181, -0.124> <0.303, -0.354, -0.124> 
		<0.156, -0.034, 0.000> <0.156, -0.034, -0.124> <0.107, -0.230, -0.059> <0.107, -0.354, -0.059> 
		<-0.017, -0.034, 0.000> <-0.017, -0.034, -0.124> <-0.017, -0.230, -0.059> <-0.017, -0.354, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, -0.354, 0.000> <0.303, -0.181, 0.000> <0.156, -0.034, 0.000> <-0.017, -0.034, 0.000> 
		<0.303, -0.527, 0.000> <0.303, -0.354, 0.000> <0.156, -0.034, -0.124> <-0.017, -0.034, -0.124> 
		<0.156, -0.675, 0.000> <0.156, -0.675, -0.124> <-0.017, -0.354, -0.059> <-0.017, -0.230, -0.059> 
		<-0.017, -0.675, 0.000> <-0.017, -0.675, -0.124> <-0.017, -0.479, -0.059> <-0.017, -0.354, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, -0.354, 0.000> <0.303, -0.181, 0.000> <0.156, -0.034, 0.000> <-0.017, -0.034, 0.000> 
		<0.303, -0.527, 0.000> <0.303, -0.354, 0.000> <0.156, -0.034, 0.124> <-0.017, -0.034, 0.124> 
		<0.156, -0.675, 0.000> <0.156, -0.675, 0.124> <-0.017, -0.354, 0.059> <-0.017, -0.230, 0.059> 
		<-0.017, -0.675, 0.000> <-0.017, -0.675, 0.124> <-0.017, -0.479, 0.059> <-0.017, -0.354, 0.059> 
	}
	#ifndef (IMPORT_SPATCH) 
	hollow on
	normal {
    bump_map { 
   
      png "tire.png"
      bump_size 2
       map_type 5 }
      scale 0.3
    
  }
	
	
	pigment { color red 0.184314 green 0.309804 blue 0.30980 }
	finish { phong 0.1 }
	#end
}

#declare rim =
// Layer 5
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.354, 0.087> <-0.105, -0.354, 0.135> <-0.017, -0.354, 0.135> 
		<-0.202, -0.354, -0.087> <-0.202, -0.354, 0.000> <-0.105, -0.442, 0.135> <-0.017, -0.442, 0.135> 
		<-0.105, -0.354, -0.135> <-0.105, -0.442, -0.135> <-0.017, -0.539, 0.000> <-0.017, -0.539, 0.087> 
		<-0.017, -0.354, -0.135> <-0.017, -0.442, -0.135> <-0.017, -0.539, -0.087> <-0.017, -0.539, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> 
		<-0.202, -0.454, 0.000> <-0.202, -0.454, -0.087> <-0.202, -0.454, -0.087> <-0.202, -0.354, -0.087> 
		<-0.117, -0.539, 0.000> <-0.117, -0.539, -0.087> <-0.105, -0.442, -0.135> <-0.105, -0.354, -0.135> 
		<-0.017, -0.539, 0.000> <-0.017, -0.539, -0.087> <-0.017, -0.442, -0.135> <-0.017, -0.354, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.354, -0.087> <-0.105, -0.354, -0.135> <-0.017, -0.354, -0.135> 
		<-0.202, -0.354, 0.087> <-0.202, -0.354, 0.000> <-0.105, -0.267, -0.135> <-0.017, -0.267, -0.135> 
		<-0.105, -0.354, 0.135> <-0.105, -0.267, 0.135> <-0.017, -0.170, 0.000> <-0.017, -0.170, -0.087> 
		<-0.017, -0.354, 0.135> <-0.017, -0.267, 0.135> <-0.017, -0.170, 0.087> <-0.017, -0.170, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> 
		<-0.202, -0.255, 0.000> <-0.202, -0.255, -0.087> <-0.202, -0.255, -0.087> <-0.202, -0.354, -0.087> 
		<-0.117, -0.170, 0.000> <-0.117, -0.170, -0.087> <-0.105, -0.267, -0.135> <-0.105, -0.354, -0.135> 
		<-0.017, -0.170, 0.000> <-0.017, -0.170, -0.087> <-0.017, -0.267, -0.135> <-0.017, -0.354, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.354, -0.087> <-0.105, -0.354, -0.135> <-0.017, -0.354, -0.135> 
		<-0.202, -0.255, 0.000> <-0.202, -0.255, -0.087> <-0.017, -0.354, -0.135> <0.070, -0.354, -0.135> 
		<-0.117, -0.170, 0.000> <-0.017, -0.170, 0.000> <0.167, -0.255, -0.087> <0.167, -0.354, -0.087> 
		<-0.017, -0.170, 0.000> <0.082, -0.170, 0.000> <0.167, -0.255, 0.000> <0.167, -0.354, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.354, -0.087> <-0.105, -0.354, -0.135> <-0.017, -0.354, -0.135> 
		<-0.202, -0.454, 0.000> <-0.202, -0.454, -0.087> <-0.017, -0.354, -0.135> <0.070, -0.354, -0.135> 
		<-0.117, -0.539, 0.000> <-0.017, -0.539, 0.000> <0.167, -0.454, -0.087> <0.167, -0.354, -0.087> 
		<-0.017, -0.539, 0.000> <0.082, -0.539, 0.000> <0.167, -0.454, 0.000> <0.167, -0.354, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> 
		<-0.202, -0.255, 0.000> <-0.202, -0.255, 0.087> <-0.202, -0.255, 0.087> <-0.202, -0.354, 0.087> 
		<-0.117, -0.170, 0.000> <-0.117, -0.170, 0.087> <-0.105, -0.267, 0.135> <-0.105, -0.354, 0.135> 
		<-0.017, -0.170, 0.000> <-0.017, -0.170, 0.087> <-0.017, -0.267, 0.135> <-0.017, -0.354, 0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> <-0.202, -0.354, 0.000> 
		<-0.202, -0.354, 0.087> <-0.202, -0.454, 0.087> <-0.202, -0.454, 0.087> <-0.202, -0.454, 0.000> 
		<-0.105, -0.354, 0.135> <-0.105, -0.442, 0.135> <-0.117, -0.539, 0.087> <-0.117, -0.539, 0.000> 
		<-0.017, -0.354, 0.135> <-0.017, -0.442, 0.135> <-0.017, -0.539, 0.087> <-0.017, -0.539, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.255, 0.000> <-0.117, -0.170, 0.000> <-0.017, -0.170, 0.000> 
		<-0.202, -0.354, 0.087> <-0.202, -0.255, 0.087> <-0.017, -0.170, 0.000> <0.082, -0.170, 0.000> 
		<-0.105, -0.354, 0.135> <-0.017, -0.354, 0.135> <0.167, -0.255, 0.087> <0.167, -0.255, 0.000> 
		<-0.017, -0.354, 0.135> <0.070, -0.354, 0.135> <0.167, -0.354, 0.087> <0.167, -0.354, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.354, 0.087> <-0.105, -0.354, 0.135> <-0.017, -0.354, 0.135> 
		<-0.202, -0.454, 0.000> <-0.202, -0.454, 0.087> <-0.017, -0.354, 0.135> <0.070, -0.354, 0.135> 
		<-0.117, -0.539, 0.000> <-0.017, -0.539, 0.000> <0.167, -0.454, 0.087> <0.167, -0.354, 0.087> 
		<-0.017, -0.539, 0.000> <0.082, -0.539, 0.000> <0.167, -0.454, 0.000> <0.167, -0.354, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.454, 0.000> <-0.117, -0.539, 0.000> <-0.017, -0.539, 0.000> 
		<-0.202, -0.255, 0.000> <-0.202, -0.354, 0.000> <-0.117, -0.539, 0.087> <-0.017, -0.539, 0.087> 
		<-0.117, -0.170, 0.000> <-0.117, -0.170, 0.087> <-0.017, -0.354, 0.135> <-0.017, -0.442, 0.135> 
		<-0.017, -0.170, 0.000> <-0.017, -0.170, 0.087> <-0.017, -0.267, 0.135> <-0.017, -0.354, 0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -0.354, 0.000> <-0.202, -0.454, 0.000> <-0.117, -0.539, 0.000> <-0.017, -0.539, 0.000> 
		<-0.202, -0.255, 0.000> <-0.202, -0.354, 0.000> <-0.117, -0.539, -0.087> <-0.017, -0.539, -0.087> 
		<-0.117, -0.170, 0.000> <-0.117, -0.170, -0.087> <-0.017, -0.354, -0.135> <-0.017, -0.442, -0.135> 
		<-0.017, -0.170, 0.000> <-0.017, -0.170, -0.087> <-0.017, -0.267, -0.135> <-0.017, -0.354, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -0.354, 0.000> <0.167, -0.354, 0.087> <0.070, -0.354, 0.135> <-0.017, -0.354, 0.135> 
		<0.167, -0.354, -0.087> <0.167, -0.354, 0.000> <0.070, -0.267, 0.135> <-0.017, -0.267, 0.135> 
		<0.070, -0.354, -0.135> <0.070, -0.267, -0.135> <-0.017, -0.170, 0.000> <-0.017, -0.170, 0.087> 
		<-0.017, -0.354, -0.135> <-0.017, -0.267, -0.135> <-0.017, -0.170, -0.087> <-0.017, -0.170, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -0.354, 0.000> <0.167, -0.354, 0.000> <0.167, -0.354, 0.000> <0.167, -0.354, 0.000> 
		<0.167, -0.255, 0.000> <0.167, -0.255, 0.087> <0.167, -0.255, 0.087> <0.167, -0.354, 0.087> 
		<0.082, -0.170, 0.000> <0.082, -0.170, 0.087> <0.070, -0.267, 0.135> <0.070, -0.354, 0.135> 
		<-0.017, -0.170, 0.000> <-0.017, -0.170, 0.087> <-0.017, -0.267, 0.135> <-0.017, -0.354, 0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -0.354, 0.000> <0.167, -0.354, -0.087> <0.070, -0.354, -0.135> <-0.017, -0.354, -0.135> 
		<0.167, -0.354, 0.087> <0.167, -0.354, 0.000> <0.070, -0.442, -0.135> <-0.017, -0.442, -0.135> 
		<0.070, -0.354, 0.135> <0.070, -0.442, 0.135> <-0.017, -0.539, 0.000> <-0.017, -0.539, -0.087> 
		<-0.017, -0.354, 0.135> <-0.017, -0.442, 0.135> <-0.017, -0.539, 0.087> <-0.017, -0.539, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -0.354, 0.000> <0.167, -0.354, 0.000> <0.167, -0.354, 0.000> <0.167, -0.354, 0.000> 
		<0.167, -0.454, 0.000> <0.167, -0.454, 0.087> <0.167, -0.454, 0.087> <0.167, -0.354, 0.087> 
		<0.082, -0.539, 0.000> <0.082, -0.539, 0.087> <0.070, -0.442, 0.135> <0.070, -0.354, 0.135> 
		<-0.017, -0.539, 0.000> <-0.017, -0.539, 0.087> <-0.017, -0.442, 0.135> <-0.017, -0.354, 0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -0.354, 0.000> <0.167, -0.354, 0.000> <0.167, -0.354, 0.000> <0.167, -0.354, 0.000> 
		<0.167, -0.454, 0.000> <0.167, -0.454, -0.087> <0.167, -0.454, -0.087> <0.167, -0.354, -0.087> 
		<0.082, -0.539, 0.000> <0.082, -0.539, -0.087> <0.070, -0.442, -0.135> <0.070, -0.354, -0.135> 
		<-0.017, -0.539, 0.000> <-0.017, -0.539, -0.087> <-0.017, -0.442, -0.135> <-0.017, -0.354, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -0.354, 0.000> <0.167, -0.354, 0.000> <0.167, -0.354, 0.000> <0.167, -0.354, 0.000> 
		<0.167, -0.255, 0.000> <0.167, -0.255, -0.087> <0.167, -0.255, -0.087> <0.167, -0.354, -0.087> 
		<0.082, -0.170, 0.000> <0.082, -0.170, -0.087> <0.070, -0.267, -0.135> <0.070, -0.354, -0.135> 
		<-0.017, -0.170, 0.000> <-0.017, -0.170, -0.087> <-0.017, -0.267, -0.135> <-0.017, -0.354, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -0.354, 0.000> <0.167, -0.255, 0.000> <0.082, -0.170, 0.000> <-0.017, -0.170, 0.000> 
		<0.167, -0.454, 0.000> <0.167, -0.354, 0.000> <0.082, -0.170, -0.087> <-0.017, -0.170, -0.087> 
		<0.082, -0.539, 0.000> <0.082, -0.539, -0.087> <-0.017, -0.354, -0.135> <-0.017, -0.267, -0.135> 
		<-0.017, -0.539, 0.000> <-0.017, -0.539, -0.087> <-0.017, -0.442, -0.135> <-0.017, -0.354, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -0.354, 0.000> <0.167, -0.255, 0.000> <0.082, -0.170, 0.000> <-0.017, -0.170, 0.000> 
		<0.167, -0.454, 0.000> <0.167, -0.354, 0.000> <0.082, -0.170, 0.087> <-0.017, -0.170, 0.087> 
		<0.082, -0.539, 0.000> <0.082, -0.539, 0.087> <-0.017, -0.354, 0.135> <-0.017, -0.267, 0.135> 
		<-0.017, -0.539, 0.000> <-0.017, -0.539, 0.087> <-0.017, -0.442, 0.135> <-0.017, -0.354, 0.135> 
	}
	#ifndef (IMPORT_SPATCH)
	texture {
    pigment {
        granite
        color_map {
            [0.0 rgb <0.42, 0.20, 0.20>]
            [0.5 rgb <0.50, 0.50, 0.02>]
            [0.6 rgb <0.60, 0.20, 0.20>]
            [0.6 rgb <0.30, 0.20, 0.20>]
        }
    }
    finish { ambient 0.2 diffuse 0.6 }
    normal { wrinkles 1 scale 0.1 }
}
	#end
}


#declare axle =
// Layer 6
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.040, -0.352, 0.594> <-0.040, -0.352, 0.594> <-0.040, -0.352, 0.594> <-0.040, -0.352, 0.594> 
		<-0.040, -0.340, 0.594> <-0.040, -0.352, 0.594> <-0.040, -0.352, 0.594> <-0.040, -0.364, 0.594> 
		<-0.029, -0.330, 0.594> <-0.029, -0.343, 0.594> <-0.029, -0.361, 0.594> <-0.029, -0.375, 0.594> 
		<-0.017, -0.330, 0.594> <-0.017, -0.343, 0.594> <-0.017, -0.361, 0.594> <-0.017, -0.375, 0.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.040, -0.352, 0.594> <-0.040, -0.340, 0.594> <-0.029, -0.330, 0.594> <-0.017, -0.330, 0.594> 
		<-0.040, -0.352, 0.247> <-0.040, -0.340, 0.247> <-0.029, -0.330, 0.247> <-0.017, -0.330, 0.247> 
		<-0.040, -0.352, -0.214> <-0.040, -0.340, -0.214> <-0.029, -0.330, -0.214> <-0.017, -0.330, -0.214> 
		<-0.040, -0.352, -0.561> <-0.040, -0.340, -0.561> <-0.029, -0.330, -0.561> <-0.017, -0.330, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.040, -0.352, 0.594> <-0.040, -0.352, 0.247> <-0.040, -0.352, -0.214> <-0.040, -0.352, -0.561> 
		<-0.040, -0.364, 0.594> <-0.040, -0.364, 0.247> <-0.040, -0.364, -0.214> <-0.040, -0.364, -0.561> 
		<-0.029, -0.375, 0.594> <-0.029, -0.375, 0.247> <-0.029, -0.375, -0.214> <-0.029, -0.375, -0.561> 
		<-0.017, -0.375, 0.594> <-0.017, -0.375, 0.247> <-0.017, -0.375, -0.214> <-0.017, -0.375, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, -0.352, 0.594> <0.005, -0.364, 0.594> <-0.005, -0.375, 0.594> <-0.017, -0.375, 0.594> 
		<0.005, -0.352, 0.247> <0.005, -0.364, 0.247> <-0.005, -0.375, 0.247> <-0.017, -0.375, 0.247> 
		<0.005, -0.352, -0.214> <0.005, -0.364, -0.214> <-0.005, -0.375, -0.214> <-0.017, -0.375, -0.214> 
		<0.005, -0.352, -0.561> <0.005, -0.364, -0.561> <-0.005, -0.375, -0.561> <-0.017, -0.375, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, -0.352, 0.594> <0.005, -0.352, 0.594> <0.005, -0.352, 0.594> <0.005, -0.352, 0.594> 
		<0.005, -0.364, 0.594> <0.005, -0.352, 0.594> <0.005, -0.352, 0.594> <0.005, -0.340, 0.594> 
		<-0.005, -0.375, 0.594> <-0.005, -0.361, 0.594> <-0.005, -0.343, 0.594> <-0.005, -0.330, 0.594> 
		<-0.017, -0.375, 0.594> <-0.017, -0.361, 0.594> <-0.017, -0.343, 0.594> <-0.017, -0.330, 0.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, -0.352, 0.594> <0.005, -0.352, 0.247> <0.005, -0.352, -0.214> <0.005, -0.352, -0.561> 
		<0.005, -0.340, 0.594> <0.005, -0.340, 0.247> <0.005, -0.340, -0.214> <0.005, -0.340, -0.561> 
		<-0.005, -0.330, 0.594> <-0.005, -0.330, 0.247> <-0.005, -0.330, -0.214> <-0.005, -0.330, -0.561> 
		<-0.017, -0.330, 0.594> <-0.017, -0.330, 0.247> <-0.017, -0.330, -0.214> <-0.017, -0.330, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.040, -0.352, -0.561> <-0.040, -0.352, -0.561> <-0.040, -0.352, -0.561> <-0.040, -0.352, -0.561> 
		<-0.040, -0.364, -0.561> <-0.040, -0.352, -0.561> <-0.040, -0.352, -0.561> <-0.040, -0.340, -0.561> 
		<-0.029, -0.375, -0.561> <-0.029, -0.361, -0.561> <-0.029, -0.343, -0.561> <-0.029, -0.330, -0.561> 
		<-0.017, -0.375, -0.561> <-0.017, -0.361, -0.561> <-0.017, -0.343, -0.561> <-0.017, -0.330, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, -0.352, -0.561> <0.005, -0.352, -0.561> <0.005, -0.352, -0.561> <0.005, -0.352, -0.561> 
		<0.005, -0.340, -0.561> <0.005, -0.352, -0.561> <0.005, -0.352, -0.561> <0.005, -0.364, -0.561> 
		<-0.005, -0.330, -0.561> <-0.005, -0.343, -0.561> <-0.005, -0.361, -0.561> <-0.005, -0.375, -0.561> 
		<-0.017, -0.330, -0.561> <-0.017, -0.343, -0.561> <-0.017, -0.361, -0.561> <-0.017, -0.375, -0.561> 
	}
	#ifndef (IMPORT_SPATCH)
	texture {
    pigment { rgb <0.658824, 0.658824, 0.658824> }
    finish {
        ambient 0.3
        diffuse 0.7
        reflection 0.03
        brilliance 1
        specular 0.2
        roughness 0.1
    }
}
	#end
}

#declare hardware =
// Layer 7
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.127, -0.311, -0.517> <-0.127, -0.311, -0.517> <-0.127, -0.311, -0.517> <-0.127, -0.311, -0.517> 
		<-0.128, -0.264, -0.517> <-0.126, -0.324, -0.517> <-0.126, -0.324, -0.517> <-0.125, -0.370, -0.517> 
		<-0.059, -0.275, -0.524> <-0.058, -0.316, -0.524> <-0.070, -0.370, -0.523> <-0.069, -0.410, -0.523> 
		<-0.013, -0.275, -0.528> <-0.012, -0.316, -0.528> <-0.011, -0.370, -0.529> <-0.009, -0.410, -0.529> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.127, -0.311, -0.517> <-0.128, -0.264, -0.517> <-0.059, -0.275, -0.524> <-0.013, -0.275, -0.528> 
		<-0.129, -0.311, -0.534> <-0.130, -0.264, -0.534> <-0.061, -0.275, -0.541> <-0.015, -0.275, -0.545> 
		<-0.131, -0.311, -0.556> <-0.132, -0.264, -0.556> <-0.063, -0.275, -0.563> <-0.017, -0.275, -0.567> 
		<-0.132, -0.311, -0.573> <-0.134, -0.264, -0.573> <-0.065, -0.275, -0.580> <-0.019, -0.275, -0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.127, -0.311, -0.517> <-0.129, -0.311, -0.534> <-0.131, -0.311, -0.556> <-0.132, -0.311, -0.573> 
		<-0.125, -0.370, -0.517> <-0.127, -0.370, -0.534> <-0.129, -0.370, -0.556> <-0.131, -0.370, -0.573> 
		<-0.069, -0.410, -0.523> <-0.070, -0.410, -0.540> <-0.073, -0.410, -0.562> <-0.074, -0.410, -0.579> 
		<-0.009, -0.410, -0.529> <-0.011, -0.410, -0.545> <-0.013, -0.410, -0.568> <-0.015, -0.410, -0.585> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.108, -0.311, -0.540> <0.110, -0.370, -0.541> <0.050, -0.410, -0.535> <-0.009, -0.410, -0.529> 
		<0.107, -0.311, -0.557> <0.108, -0.370, -0.557> <0.048, -0.410, -0.551> <-0.011, -0.410, -0.545> 
		<0.104, -0.311, -0.579> <0.106, -0.370, -0.580> <0.046, -0.410, -0.574> <-0.013, -0.410, -0.568> 
		<0.103, -0.311, -0.596> <0.104, -0.370, -0.596> <0.045, -0.410, -0.590> <-0.015, -0.410, -0.585> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.108, -0.311, -0.540> <0.108, -0.311, -0.540> <0.108, -0.311, -0.540> <0.108, -0.311, -0.540> 
		<0.110, -0.370, -0.541> <0.109, -0.321, -0.540> <0.109, -0.321, -0.540> <0.107, -0.262, -0.540> 
		<0.050, -0.410, -0.535> <0.049, -0.370, -0.534> <0.037, -0.316, -0.533> <0.036, -0.275, -0.533> 
		<-0.009, -0.410, -0.529> <-0.011, -0.370, -0.529> <-0.012, -0.316, -0.528> <-0.013, -0.275, -0.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.108, -0.311, -0.540> <0.107, -0.311, -0.557> <0.104, -0.311, -0.579> <0.103, -0.311, -0.596> 
		<0.107, -0.262, -0.540> <0.105, -0.262, -0.557> <0.103, -0.262, -0.579> <0.101, -0.262, -0.596> 
		<0.036, -0.275, -0.533> <0.034, -0.275, -0.550> <0.032, -0.275, -0.572> <0.030, -0.275, -0.589> 
		<-0.013, -0.275, -0.528> <-0.015, -0.275, -0.545> <-0.017, -0.275, -0.567> <-0.019, -0.275, -0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.132, -0.311, -0.573> <-0.132, -0.311, -0.573> <-0.132, -0.311, -0.573> <-0.132, -0.311, -0.573> 
		<-0.131, -0.370, -0.573> <-0.132, -0.324, -0.573> <-0.132, -0.324, -0.573> <-0.134, -0.264, -0.573> 
		<-0.074, -0.410, -0.579> <-0.075, -0.370, -0.579> <-0.064, -0.316, -0.580> <-0.065, -0.275, -0.580> 
		<-0.015, -0.410, -0.585> <-0.016, -0.370, -0.584> <-0.018, -0.316, -0.584> <-0.019, -0.275, -0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, -0.311, -0.596> <0.103, -0.311, -0.596> <0.103, -0.311, -0.596> <0.103, -0.311, -0.596> 
		<0.101, -0.262, -0.596> <0.103, -0.321, -0.596> <0.103, -0.321, -0.596> <0.104, -0.370, -0.596> 
		<0.030, -0.275, -0.589> <0.031, -0.316, -0.589> <0.043, -0.370, -0.590> <0.045, -0.410, -0.590> 
		<-0.019, -0.275, -0.584> <-0.018, -0.316, -0.584> <-0.016, -0.370, -0.584> <-0.015, -0.410, -0.585> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, -0.311, 0.610> <-0.137, -0.311, 0.610> <-0.137, -0.311, 0.610> <-0.137, -0.311, 0.610> 
		<-0.139, -0.264, 0.610> <-0.137, -0.324, 0.610> <-0.137, -0.324, 0.610> <-0.136, -0.370, 0.610> 
		<-0.070, -0.275, 0.615> <-0.068, -0.316, 0.615> <-0.080, -0.370, 0.614> <-0.079, -0.410, 0.614> 
		<-0.024, -0.275, 0.618> <-0.022, -0.316, 0.618> <-0.021, -0.370, 0.619> <-0.020, -0.410, 0.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, -0.311, 0.610> <-0.139, -0.264, 0.610> <-0.070, -0.275, 0.615> <-0.024, -0.275, 0.618> 
		<-0.136, -0.311, 0.593> <-0.138, -0.264, 0.593> <-0.068, -0.275, 0.598> <-0.022, -0.275, 0.601> 
		<-0.135, -0.311, 0.571> <-0.136, -0.264, 0.571> <-0.067, -0.275, 0.576> <-0.021, -0.275, 0.579> 
		<-0.133, -0.311, 0.554> <-0.135, -0.264, 0.554> <-0.065, -0.275, 0.559> <-0.019, -0.275, 0.562> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, -0.311, 0.610> <-0.136, -0.311, 0.593> <-0.135, -0.311, 0.571> <-0.133, -0.311, 0.554> 
		<-0.136, -0.370, 0.610> <-0.134, -0.370, 0.593> <-0.133, -0.370, 0.571> <-0.132, -0.370, 0.554> 
		<-0.079, -0.410, 0.614> <-0.078, -0.410, 0.597> <-0.076, -0.410, 0.575> <-0.075, -0.410, 0.558> 
		<-0.020, -0.410, 0.619> <-0.018, -0.410, 0.602> <-0.017, -0.410, 0.579> <-0.015, -0.410, 0.563> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.098, -0.311, 0.627> <0.100, -0.370, 0.627> <0.040, -0.410, 0.623> <-0.020, -0.410, 0.619> 
		<0.099, -0.311, 0.611> <0.101, -0.370, 0.611> <0.041, -0.410, 0.606> <-0.018, -0.410, 0.602> 
		<0.101, -0.311, 0.588> <0.103, -0.370, 0.588> <0.043, -0.410, 0.584> <-0.017, -0.410, 0.579> 
		<0.102, -0.311, 0.571> <0.104, -0.370, 0.571> <0.044, -0.410, 0.567> <-0.015, -0.410, 0.563> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.098, -0.311, 0.627> <0.098, -0.311, 0.627> <0.098, -0.311, 0.627> <0.098, -0.311, 0.627> 
		<0.100, -0.370, 0.627> <0.098, -0.321, 0.627> <0.098, -0.321, 0.627> <0.097, -0.262, 0.627> 
		<0.040, -0.410, 0.623> <0.039, -0.370, 0.623> <0.027, -0.316, 0.622> <0.025, -0.275, 0.622> 
		<-0.020, -0.410, 0.619> <-0.021, -0.370, 0.619> <-0.022, -0.316, 0.618> <-0.024, -0.275, 0.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.098, -0.311, 0.627> <0.099, -0.311, 0.611> <0.101, -0.311, 0.588> <0.102, -0.311, 0.571> 
		<0.097, -0.262, 0.627> <0.098, -0.262, 0.610> <0.100, -0.262, 0.588> <0.101, -0.262, 0.571> 
		<0.025, -0.275, 0.622> <0.027, -0.275, 0.605> <0.028, -0.275, 0.583> <0.029, -0.275, 0.566> 
		<-0.024, -0.275, 0.618> <-0.022, -0.275, 0.601> <-0.021, -0.275, 0.579> <-0.019, -0.275, 0.562> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.133, -0.311, 0.554> <-0.133, -0.311, 0.554> <-0.133, -0.311, 0.554> <-0.133, -0.311, 0.554> 
		<-0.132, -0.370, 0.554> <-0.133, -0.324, 0.554> <-0.133, -0.324, 0.554> <-0.135, -0.264, 0.554> 
		<-0.075, -0.410, 0.558> <-0.076, -0.370, 0.558> <-0.064, -0.316, 0.559> <-0.065, -0.275, 0.559> 
		<-0.015, -0.410, 0.563> <-0.017, -0.370, 0.563> <-0.018, -0.316, 0.562> <-0.019, -0.275, 0.562> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, -0.311, 0.571> <0.102, -0.311, 0.571> <0.102, -0.311, 0.571> <0.102, -0.311, 0.571> 
		<0.101, -0.262, 0.571> <0.103, -0.321, 0.571> <0.103, -0.321, 0.571> <0.104, -0.370, 0.571> 
		<0.029, -0.275, 0.566> <0.031, -0.316, 0.566> <0.043, -0.370, 0.567> <0.044, -0.410, 0.567> 
		<-0.019, -0.275, 0.562> <-0.018, -0.316, 0.562> <-0.017, -0.370, 0.563> <-0.015, -0.410, 0.563> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.047, -0.315, 0.141> <-0.033, -0.315, 0.141> <0.011, -0.315, 0.141> <0.025, -0.315, 0.141> 
		<-0.048, -0.315, 0.143> <-0.033, -0.315, 0.143> <0.011, -0.315, 0.143> <0.026, -0.315, 0.143> 
		<-0.049, -0.314, 0.154> <-0.033, -0.314, 0.154> <0.012, -0.314, 0.154> <0.027, -0.314, 0.154> 
		<-0.049, -0.313, 0.158> <-0.034, -0.313, 0.158> <0.012, -0.313, 0.158> <0.027, -0.313, 0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.047, -0.315, 0.141> <-0.048, -0.315, 0.143> <-0.049, -0.314, 0.154> <-0.049, -0.313, 0.158> 
		<-0.047, -0.329, 0.141> <-0.048, -0.329, 0.143> <-0.049, -0.329, 0.154> <-0.049, -0.329, 0.158> 
		<-0.047, -0.373, 0.141> <-0.048, -0.373, 0.143> <-0.049, -0.374, 0.154> <-0.049, -0.374, 0.158> 
		<-0.047, -0.388, 0.141> <-0.048, -0.388, 0.143> <-0.049, -0.389, 0.154> <-0.049, -0.389, 0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.047, -0.315, 0.141> <-0.047, -0.329, 0.141> <-0.047, -0.373, 0.141> <-0.047, -0.388, 0.141> 
		<-0.033, -0.315, 0.141> <-0.033, -0.329, 0.141> <-0.033, -0.373, 0.141> <-0.033, -0.388, 0.141> 
		<0.011, -0.315, 0.141> <0.011, -0.329, 0.141> <0.011, -0.373, 0.141> <0.011, -0.388, 0.141> 
		<0.025, -0.315, 0.141> <0.025, -0.329, 0.141> <0.025, -0.373, 0.141> <0.025, -0.388, 0.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.049, -0.313, 0.158> <-0.034, -0.313, 0.158> <0.012, -0.313, 0.158> <0.027, -0.313, 0.158> 
		<-0.049, -0.329, 0.158> <-0.034, -0.329, 0.158> <0.012, -0.329, 0.158> <0.027, -0.329, 0.158> 
		<-0.049, -0.374, 0.158> <-0.034, -0.374, 0.158> <0.012, -0.374, 0.158> <0.027, -0.374, 0.158> 
		<-0.049, -0.389, 0.158> <-0.034, -0.389, 0.158> <0.012, -0.389, 0.158> <0.027, -0.389, 0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.047, -0.388, 0.141> <-0.048, -0.388, 0.143> <-0.049, -0.389, 0.154> <-0.049, -0.389, 0.158> 
		<-0.033, -0.388, 0.141> <-0.033, -0.388, 0.143> <-0.033, -0.389, 0.154> <-0.034, -0.389, 0.158> 
		<0.011, -0.388, 0.141> <0.011, -0.388, 0.143> <0.012, -0.389, 0.154> <0.012, -0.389, 0.158> 
		<0.025, -0.388, 0.141> <0.026, -0.388, 0.143> <0.027, -0.389, 0.154> <0.027, -0.389, 0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, -0.315, 0.141> <0.025, -0.329, 0.141> <0.025, -0.373, 0.141> <0.025, -0.388, 0.141> 
		<0.026, -0.315, 0.143> <0.026, -0.329, 0.143> <0.026, -0.373, 0.143> <0.026, -0.388, 0.143> 
		<0.027, -0.314, 0.154> <0.027, -0.329, 0.154> <0.027, -0.374, 0.154> <0.027, -0.389, 0.154> 
		<0.027, -0.313, 0.158> <0.027, -0.329, 0.158> <0.027, -0.374, 0.158> <0.027, -0.389, 0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, -0.315, -0.155> <-0.038, -0.315, -0.155> <0.005, -0.315, -0.155> <0.020, -0.315, -0.155> 
		<-0.053, -0.315, -0.153> <-0.039, -0.315, -0.153> <0.006, -0.315, -0.153> <0.020, -0.315, -0.153> 
		<-0.054, -0.314, -0.142> <-0.039, -0.314, -0.142> <0.006, -0.314, -0.142> <0.021, -0.314, -0.142> 
		<-0.055, -0.313, -0.139> <-0.039, -0.313, -0.139> <0.006, -0.313, -0.139> <0.022, -0.313, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, -0.315, -0.155> <-0.053, -0.315, -0.153> <-0.054, -0.314, -0.142> <-0.055, -0.313, -0.139> 
		<-0.053, -0.329, -0.155> <-0.053, -0.329, -0.153> <-0.054, -0.329, -0.142> <-0.055, -0.329, -0.139> 
		<-0.053, -0.373, -0.155> <-0.053, -0.373, -0.153> <-0.054, -0.374, -0.142> <-0.055, -0.374, -0.139> 
		<-0.053, -0.388, -0.155> <-0.053, -0.388, -0.153> <-0.054, -0.389, -0.142> <-0.055, -0.389, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, -0.315, -0.155> <-0.053, -0.329, -0.155> <-0.053, -0.373, -0.155> <-0.053, -0.388, -0.155> 
		<-0.038, -0.315, -0.155> <-0.038, -0.329, -0.155> <-0.038, -0.373, -0.155> <-0.038, -0.388, -0.155> 
		<0.005, -0.315, -0.155> <0.005, -0.329, -0.155> <0.005, -0.373, -0.155> <0.005, -0.388, -0.155> 
		<0.020, -0.315, -0.155> <0.020, -0.329, -0.155> <0.020, -0.373, -0.155> <0.020, -0.388, -0.155> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.055, -0.313, -0.139> <-0.039, -0.313, -0.139> <0.006, -0.313, -0.139> <0.022, -0.313, -0.139> 
		<-0.055, -0.329, -0.139> <-0.039, -0.329, -0.139> <0.006, -0.329, -0.139> <0.022, -0.329, -0.139> 
		<-0.055, -0.374, -0.139> <-0.039, -0.374, -0.139> <0.006, -0.374, -0.139> <0.022, -0.374, -0.139> 
		<-0.055, -0.389, -0.139> <-0.039, -0.389, -0.139> <0.006, -0.389, -0.139> <0.022, -0.389, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, -0.388, -0.155> <-0.053, -0.388, -0.153> <-0.054, -0.389, -0.142> <-0.055, -0.389, -0.139> 
		<-0.038, -0.388, -0.155> <-0.039, -0.388, -0.153> <-0.039, -0.389, -0.142> <-0.039, -0.389, -0.139> 
		<0.005, -0.388, -0.155> <0.006, -0.388, -0.153> <0.006, -0.389, -0.142> <0.006, -0.389, -0.139> 
		<0.020, -0.388, -0.155> <0.020, -0.388, -0.153> <0.021, -0.389, -0.142> <0.022, -0.389, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, -0.315, -0.155> <0.020, -0.329, -0.155> <0.020, -0.373, -0.155> <0.020, -0.388, -0.155> 
		<0.020, -0.315, -0.153> <0.020, -0.329, -0.153> <0.020, -0.373, -0.153> <0.020, -0.388, -0.153> 
		<0.021, -0.314, -0.142> <0.021, -0.329, -0.142> <0.021, -0.374, -0.142> <0.021, -0.389, -0.142> 
		<0.022, -0.313, -0.139> <0.022, -0.329, -0.139> <0.022, -0.374, -0.139> <0.022, -0.389, -0.139> 
	}
	#ifndef (IMPORT_SPATCH)
	texture {
    pigment { rgb <0.658824, 0.658824, 0.658824> }
    finish {
        ambient 0.3
        diffuse 0.7
        reflection 0.15
        brilliance 8
        specular 0.8
        roughness 0.1
    }
}
	#end
}

// rootball
#declare rootball =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.386, -0.271> <0.722, -0.386, -0.224> <0.778, -0.386, -0.224> 
		<0.675, -0.386, -0.382> <0.675, -0.386, -0.327> <0.722, -0.441, -0.224> <0.778, -0.441, -0.224> 
		<0.722, -0.386, -0.430> <0.722, -0.441, -0.430> <0.778, -0.488, -0.327> <0.778, -0.488, -0.271> 
		<0.778, -0.386, -0.430> <0.778, -0.441, -0.430> <0.778, -0.488, -0.382> <0.778, -0.488, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.386, -0.327> <0.675, -0.386, -0.327> <0.675, -0.386, -0.327> 
		<0.675, -0.441, -0.327> <0.675, -0.441, -0.382> <0.675, -0.441, -0.382> <0.675, -0.386, -0.382> 
		<0.722, -0.488, -0.327> <0.722, -0.488, -0.382> <0.722, -0.441, -0.430> <0.722, -0.386, -0.430> 
		<0.778, -0.488, -0.327> <0.778, -0.488, -0.382> <0.778, -0.441, -0.430> <0.778, -0.386, -0.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.386, -0.382> <0.722, -0.386, -0.430> <0.778, -0.386, -0.430> 
		<0.675, -0.386, -0.271> <0.675, -0.386, -0.327> <0.722, -0.330, -0.430> <0.778, -0.330, -0.430> 
		<0.722, -0.386, -0.224> <0.722, -0.330, -0.224> <0.778, -0.283, -0.327> <0.778, -0.283, -0.382> 
		<0.778, -0.386, -0.224> <0.778, -0.330, -0.224> <0.778, -0.283, -0.271> <0.778, -0.283, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.386, -0.327> <0.675, -0.386, -0.327> <0.675, -0.386, -0.327> 
		<0.675, -0.330, -0.327> <0.675, -0.330, -0.382> <0.675, -0.330, -0.382> <0.675, -0.386, -0.382> 
		<0.722, -0.283, -0.327> <0.722, -0.283, -0.382> <0.722, -0.330, -0.430> <0.722, -0.386, -0.430> 
		<0.778, -0.283, -0.327> <0.778, -0.283, -0.382> <0.778, -0.330, -0.430> <0.778, -0.386, -0.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.386, -0.382> <0.722, -0.386, -0.430> <0.778, -0.386, -0.430> 
		<0.675, -0.330, -0.327> <0.675, -0.330, -0.382> <0.778, -0.386, -0.430> <0.833, -0.386, -0.430> 
		<0.722, -0.283, -0.327> <0.778, -0.283, -0.327> <0.881, -0.330, -0.382> <0.881, -0.386, -0.382> 
		<0.778, -0.283, -0.327> <0.833, -0.283, -0.327> <0.881, -0.330, -0.327> <0.881, -0.386, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.386, -0.382> <0.722, -0.386, -0.430> <0.778, -0.386, -0.430> 
		<0.675, -0.441, -0.327> <0.675, -0.441, -0.382> <0.778, -0.386, -0.430> <0.833, -0.386, -0.430> 
		<0.722, -0.488, -0.327> <0.778, -0.488, -0.327> <0.881, -0.441, -0.382> <0.881, -0.386, -0.382> 
		<0.778, -0.488, -0.327> <0.833, -0.488, -0.327> <0.881, -0.441, -0.327> <0.881, -0.386, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.386, -0.327> <0.675, -0.386, -0.327> <0.675, -0.386, -0.327> 
		<0.675, -0.330, -0.327> <0.675, -0.330, -0.271> <0.675, -0.330, -0.271> <0.675, -0.386, -0.271> 
		<0.722, -0.283, -0.327> <0.722, -0.283, -0.271> <0.722, -0.330, -0.224> <0.722, -0.386, -0.224> 
		<0.778, -0.283, -0.327> <0.778, -0.283, -0.271> <0.778, -0.330, -0.224> <0.778, -0.386, -0.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.386, -0.327> <0.675, -0.386, -0.327> <0.675, -0.386, -0.327> 
		<0.675, -0.386, -0.271> <0.675, -0.441, -0.271> <0.675, -0.441, -0.271> <0.675, -0.441, -0.327> 
		<0.722, -0.386, -0.224> <0.722, -0.441, -0.224> <0.722, -0.488, -0.271> <0.722, -0.488, -0.327> 
		<0.778, -0.386, -0.224> <0.778, -0.441, -0.224> <0.778, -0.488, -0.271> <0.778, -0.488, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.330, -0.327> <0.722, -0.283, -0.327> <0.778, -0.283, -0.327> 
		<0.675, -0.386, -0.271> <0.675, -0.330, -0.271> <0.778, -0.283, -0.327> <0.833, -0.283, -0.327> 
		<0.722, -0.386, -0.224> <0.778, -0.386, -0.224> <0.881, -0.330, -0.271> <0.881, -0.330, -0.327> 
		<0.778, -0.386, -0.224> <0.833, -0.386, -0.224> <0.881, -0.386, -0.271> <0.881, -0.386, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.386, -0.271> <0.722, -0.386, -0.224> <0.778, -0.386, -0.224> 
		<0.675, -0.441, -0.327> <0.675, -0.441, -0.271> <0.778, -0.386, -0.224> <0.833, -0.386, -0.224> 
		<0.722, -0.488, -0.327> <0.778, -0.488, -0.327> <0.881, -0.441, -0.271> <0.881, -0.386, -0.271> 
		<0.778, -0.488, -0.327> <0.833, -0.488, -0.327> <0.881, -0.441, -0.327> <0.881, -0.386, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.441, -0.327> <0.722, -0.488, -0.327> <0.778, -0.488, -0.327> 
		<0.675, -0.330, -0.327> <0.675, -0.386, -0.327> <0.722, -0.488, -0.271> <0.778, -0.488, -0.271> 
		<0.722, -0.283, -0.327> <0.722, -0.283, -0.271> <0.778, -0.386, -0.224> <0.778, -0.441, -0.224> 
		<0.778, -0.283, -0.327> <0.778, -0.283, -0.271> <0.778, -0.330, -0.224> <0.778, -0.386, -0.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.675, -0.386, -0.327> <0.675, -0.441, -0.327> <0.722, -0.488, -0.327> <0.778, -0.488, -0.327> 
		<0.675, -0.330, -0.327> <0.675, -0.386, -0.327> <0.722, -0.488, -0.382> <0.778, -0.488, -0.382> 
		<0.722, -0.283, -0.327> <0.722, -0.283, -0.382> <0.778, -0.386, -0.430> <0.778, -0.441, -0.430> 
		<0.778, -0.283, -0.327> <0.778, -0.283, -0.382> <0.778, -0.330, -0.430> <0.778, -0.386, -0.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, -0.386, -0.327> <0.881, -0.386, -0.271> <0.833, -0.386, -0.224> <0.778, -0.386, -0.224> 
		<0.881, -0.386, -0.382> <0.881, -0.386, -0.327> <0.833, -0.330, -0.224> <0.778, -0.330, -0.224> 
		<0.833, -0.386, -0.430> <0.833, -0.330, -0.430> <0.778, -0.283, -0.327> <0.778, -0.283, -0.271> 
		<0.778, -0.386, -0.430> <0.778, -0.330, -0.430> <0.778, -0.283, -0.382> <0.778, -0.283, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, -0.386, -0.327> <0.881, -0.386, -0.327> <0.881, -0.386, -0.327> <0.881, -0.386, -0.327> 
		<0.881, -0.330, -0.327> <0.881, -0.330, -0.271> <0.881, -0.330, -0.271> <0.881, -0.386, -0.271> 
		<0.833, -0.283, -0.327> <0.833, -0.283, -0.271> <0.833, -0.330, -0.224> <0.833, -0.386, -0.224> 
		<0.778, -0.283, -0.327> <0.778, -0.283, -0.271> <0.778, -0.330, -0.224> <0.778, -0.386, -0.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, -0.386, -0.327> <0.881, -0.386, -0.382> <0.833, -0.386, -0.430> <0.778, -0.386, -0.430> 
		<0.881, -0.386, -0.271> <0.881, -0.386, -0.327> <0.833, -0.441, -0.430> <0.778, -0.441, -0.430> 
		<0.833, -0.386, -0.224> <0.833, -0.441, -0.224> <0.778, -0.488, -0.327> <0.778, -0.488, -0.382> 
		<0.778, -0.386, -0.224> <0.778, -0.441, -0.224> <0.778, -0.488, -0.271> <0.778, -0.488, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, -0.386, -0.327> <0.881, -0.386, -0.327> <0.881, -0.386, -0.327> <0.881, -0.386, -0.327> 
		<0.881, -0.441, -0.327> <0.881, -0.441, -0.271> <0.881, -0.441, -0.271> <0.881, -0.386, -0.271> 
		<0.833, -0.488, -0.327> <0.833, -0.488, -0.271> <0.833, -0.441, -0.224> <0.833, -0.386, -0.224> 
		<0.778, -0.488, -0.327> <0.778, -0.488, -0.271> <0.778, -0.441, -0.224> <0.778, -0.386, -0.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, -0.386, -0.327> <0.881, -0.386, -0.327> <0.881, -0.386, -0.327> <0.881, -0.386, -0.327> 
		<0.881, -0.441, -0.327> <0.881, -0.441, -0.382> <0.881, -0.441, -0.382> <0.881, -0.386, -0.382> 
		<0.833, -0.488, -0.327> <0.833, -0.488, -0.382> <0.833, -0.441, -0.430> <0.833, -0.386, -0.430> 
		<0.778, -0.488, -0.327> <0.778, -0.488, -0.382> <0.778, -0.441, -0.430> <0.778, -0.386, -0.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, -0.386, -0.327> <0.881, -0.386, -0.327> <0.881, -0.386, -0.327> <0.881, -0.386, -0.327> 
		<0.881, -0.330, -0.327> <0.881, -0.330, -0.382> <0.881, -0.330, -0.382> <0.881, -0.386, -0.382> 
		<0.833, -0.283, -0.327> <0.833, -0.283, -0.382> <0.833, -0.330, -0.430> <0.833, -0.386, -0.430> 
		<0.778, -0.283, -0.327> <0.778, -0.283, -0.382> <0.778, -0.330, -0.430> <0.778, -0.386, -0.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, -0.386, -0.327> <0.881, -0.330, -0.327> <0.833, -0.283, -0.327> <0.778, -0.283, -0.327> 
		<0.881, -0.441, -0.327> <0.881, -0.386, -0.327> <0.833, -0.283, -0.382> <0.778, -0.283, -0.382> 
		<0.833, -0.488, -0.327> <0.833, -0.488, -0.382> <0.778, -0.386, -0.430> <0.778, -0.330, -0.430> 
		<0.778, -0.488, -0.327> <0.778, -0.488, -0.382> <0.778, -0.441, -0.430> <0.778, -0.386, -0.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, -0.386, -0.327> <0.881, -0.330, -0.327> <0.833, -0.283, -0.327> <0.778, -0.283, -0.327> 
		<0.881, -0.441, -0.327> <0.881, -0.386, -0.327> <0.833, -0.283, -0.271> <0.778, -0.283, -0.271> 
		<0.833, -0.488, -0.327> <0.833, -0.488, -0.271> <0.778, -0.386, -0.224> <0.778, -0.330, -0.224> 
		<0.778, -0.488, -0.327> <0.778, -0.488, -0.271> <0.778, -0.441, -0.224> <0.778, -0.386, -0.224> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment {
    agate
    color_map {
    [0.0 rgb 0]
    [0.5 rgb <0.9, 0.7, 0.6>]
    [0.6 rgb <0.9, 0.7, 0.4>]
    [1.0 rgb <0.7, 0.4, 0.2>]
}
}
	#end
}


// fronds
#declare fronds =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.760, -0.117, -0.327> <0.760, -0.117, -0.327> <0.760, -0.117, -0.327> <0.760, -0.117, -0.327> 
		<0.767, -0.143, -0.327> <0.767, -0.143, -0.327> <0.766, -0.143, -0.328> <0.766, -0.143, -0.328> 
		<0.779, -0.176, -0.327> <0.779, -0.176, -0.327> <0.778, -0.176, -0.328> <0.778, -0.176, -0.328> 
		<0.782, -0.202, -0.327> <0.782, -0.202, -0.327> <0.782, -0.202, -0.328> <0.781, -0.202, -0.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.760, -0.117, -0.327> <0.767, -0.143, -0.327> <0.779, -0.176, -0.327> <0.782, -0.202, -0.327> 
		<0.760, -0.117, -0.326> <0.767, -0.143, -0.326> <0.779, -0.176, -0.326> <0.782, -0.202, -0.326> 
		<0.760, -0.117, -0.326> <0.766, -0.143, -0.326> <0.778, -0.176, -0.325> <0.782, -0.202, -0.325> 
		<0.760, -0.117, -0.326> <0.766, -0.143, -0.326> <0.778, -0.176, -0.325> <0.781, -0.202, -0.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.782, -0.202, -0.327> <0.782, -0.202, -0.327> <0.782, -0.202, -0.328> <0.781, -0.202, -0.329> 
		<0.786, -0.229, -0.327> <0.786, -0.229, -0.327> <0.786, -0.229, -0.329> <0.785, -0.229, -0.329> 
		<0.784, -0.265, -0.327> <0.784, -0.265, -0.328> <0.784, -0.265, -0.329> <0.783, -0.265, -0.330> 
		<0.785, -0.292, -0.327> <0.785, -0.292, -0.328> <0.784, -0.292, -0.330> <0.783, -0.292, -0.331> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.782, -0.202, -0.327> <0.786, -0.229, -0.327> <0.784, -0.265, -0.327> <0.785, -0.292, -0.327> 
		<0.782, -0.202, -0.326> <0.786, -0.229, -0.326> <0.784, -0.265, -0.325> <0.785, -0.292, -0.325> 
		<0.782, -0.202, -0.325> <0.786, -0.229, -0.324> <0.784, -0.265, -0.324> <0.784, -0.292, -0.323> 
		<0.781, -0.202, -0.324> <0.785, -0.229, -0.324> <0.783, -0.265, -0.323> <0.783, -0.292, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.760, -0.117, -0.326> <0.766, -0.143, -0.326> <0.778, -0.176, -0.325> <0.781, -0.202, -0.324> 
		<0.760, -0.117, -0.326> <0.766, -0.143, -0.325> <0.777, -0.176, -0.324> <0.781, -0.202, -0.324> 
		<0.760, -0.117, -0.326> <0.765, -0.143, -0.325> <0.777, -0.176, -0.324> <0.780, -0.202, -0.323> 
		<0.759, -0.117, -0.326> <0.765, -0.143, -0.325> <0.776, -0.176, -0.324> <0.779, -0.202, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.759, -0.117, -0.326> <0.765, -0.143, -0.325> <0.776, -0.176, -0.324> <0.779, -0.202, -0.323> 
		<0.759, -0.117, -0.326> <0.765, -0.143, -0.325> <0.775, -0.176, -0.324> <0.778, -0.202, -0.323> 
		<0.759, -0.117, -0.326> <0.764, -0.143, -0.325> <0.775, -0.176, -0.324> <0.777, -0.202, -0.324> 
		<0.759, -0.117, -0.326> <0.764, -0.143, -0.326> <0.774, -0.176, -0.325> <0.777, -0.202, -0.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.759, -0.117, -0.326> <0.764, -0.143, -0.326> <0.774, -0.176, -0.325> <0.777, -0.202, -0.324> 
		<0.759, -0.117, -0.326> <0.764, -0.143, -0.326> <0.774, -0.176, -0.325> <0.776, -0.202, -0.325> 
		<0.759, -0.117, -0.326> <0.764, -0.143, -0.326> <0.774, -0.176, -0.326> <0.776, -0.202, -0.326> 
		<0.759, -0.117, -0.327> <0.764, -0.143, -0.327> <0.774, -0.176, -0.327> <0.776, -0.202, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.759, -0.117, -0.327> <0.764, -0.143, -0.327> <0.774, -0.176, -0.327> <0.776, -0.202, -0.327> 
		<0.759, -0.117, -0.327> <0.764, -0.143, -0.327> <0.774, -0.176, -0.327> <0.776, -0.202, -0.327> 
		<0.759, -0.117, -0.327> <0.764, -0.143, -0.328> <0.774, -0.176, -0.328> <0.776, -0.202, -0.328> 
		<0.759, -0.117, -0.327> <0.764, -0.143, -0.328> <0.774, -0.176, -0.328> <0.777, -0.202, -0.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.759, -0.117, -0.327> <0.764, -0.143, -0.328> <0.774, -0.176, -0.328> <0.777, -0.202, -0.329> 
		<0.759, -0.117, -0.327> <0.764, -0.143, -0.328> <0.775, -0.176, -0.329> <0.777, -0.202, -0.329> 
		<0.759, -0.117, -0.327> <0.765, -0.143, -0.328> <0.775, -0.176, -0.329> <0.778, -0.202, -0.330> 
		<0.759, -0.117, -0.327> <0.765, -0.143, -0.328> <0.776, -0.176, -0.329> <0.779, -0.202, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.759, -0.117, -0.327> <0.765, -0.143, -0.328> <0.776, -0.176, -0.329> <0.779, -0.202, -0.330> 
		<0.760, -0.117, -0.327> <0.765, -0.143, -0.328> <0.777, -0.176, -0.329> <0.780, -0.202, -0.330> 
		<0.760, -0.117, -0.327> <0.766, -0.143, -0.328> <0.777, -0.176, -0.329> <0.781, -0.202, -0.329> 
		<0.760, -0.117, -0.327> <0.766, -0.143, -0.328> <0.778, -0.176, -0.328> <0.781, -0.202, -0.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.781, -0.202, -0.324> <0.785, -0.229, -0.324> <0.783, -0.265, -0.323> <0.783, -0.292, -0.322> 
		<0.781, -0.202, -0.324> <0.785, -0.229, -0.323> <0.782, -0.265, -0.322> <0.782, -0.292, -0.321> 
		<0.780, -0.202, -0.323> <0.783, -0.229, -0.323> <0.781, -0.265, -0.321> <0.781, -0.292, -0.321> 
		<0.779, -0.202, -0.323> <0.782, -0.229, -0.323> <0.779, -0.265, -0.321> <0.779, -0.292, -0.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.202, -0.323> <0.782, -0.229, -0.323> <0.779, -0.265, -0.321> <0.779, -0.292, -0.321> 
		<0.778, -0.202, -0.323> <0.781, -0.229, -0.323> <0.778, -0.265, -0.321> <0.778, -0.292, -0.321> 
		<0.777, -0.202, -0.324> <0.780, -0.229, -0.323> <0.776, -0.265, -0.322> <0.776, -0.292, -0.321> 
		<0.777, -0.202, -0.324> <0.779, -0.229, -0.324> <0.775, -0.265, -0.323> <0.775, -0.292, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.777, -0.202, -0.324> <0.779, -0.229, -0.324> <0.775, -0.265, -0.323> <0.775, -0.292, -0.322> 
		<0.776, -0.202, -0.325> <0.779, -0.229, -0.324> <0.774, -0.265, -0.324> <0.774, -0.292, -0.323> 
		<0.776, -0.202, -0.326> <0.778, -0.229, -0.326> <0.774, -0.265, -0.325> <0.773, -0.292, -0.325> 
		<0.776, -0.202, -0.327> <0.778, -0.229, -0.327> <0.774, -0.265, -0.327> <0.773, -0.292, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.776, -0.202, -0.327> <0.778, -0.229, -0.327> <0.774, -0.265, -0.327> <0.773, -0.292, -0.327> 
		<0.776, -0.202, -0.327> <0.778, -0.229, -0.327> <0.774, -0.265, -0.328> <0.773, -0.292, -0.328> 
		<0.776, -0.202, -0.328> <0.779, -0.229, -0.329> <0.774, -0.265, -0.329> <0.774, -0.292, -0.330> 
		<0.777, -0.202, -0.329> <0.779, -0.229, -0.329> <0.775, -0.265, -0.330> <0.775, -0.292, -0.331> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.777, -0.202, -0.329> <0.779, -0.229, -0.329> <0.775, -0.265, -0.330> <0.775, -0.292, -0.331> 
		<0.777, -0.202, -0.329> <0.780, -0.229, -0.330> <0.776, -0.265, -0.331> <0.776, -0.292, -0.332> 
		<0.778, -0.202, -0.330> <0.781, -0.229, -0.331> <0.778, -0.265, -0.332> <0.778, -0.292, -0.333> 
		<0.779, -0.202, -0.330> <0.782, -0.229, -0.331> <0.779, -0.265, -0.332> <0.779, -0.292, -0.333> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.202, -0.330> <0.782, -0.229, -0.331> <0.779, -0.265, -0.332> <0.779, -0.292, -0.333> 
		<0.780, -0.202, -0.330> <0.783, -0.229, -0.331> <0.781, -0.265, -0.332> <0.781, -0.292, -0.333> 
		<0.781, -0.202, -0.329> <0.785, -0.229, -0.330> <0.782, -0.265, -0.331> <0.782, -0.292, -0.332> 
		<0.781, -0.202, -0.329> <0.785, -0.229, -0.329> <0.783, -0.265, -0.330> <0.783, -0.292, -0.331> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.568, -0.234, -0.335> <0.568, -0.234, -0.335> <0.568, -0.234, -0.335> <0.568, -0.234, -0.335> 
		<0.604, -0.234, -0.335> <0.604, -0.234, -0.335> <0.604, -0.235, -0.336> <0.604, -0.235, -0.336> 
		<0.656, -0.222, -0.335> <0.656, -0.222, -0.336> <0.655, -0.222, -0.336> <0.655, -0.222, -0.336> 
		<0.689, -0.236, -0.335> <0.689, -0.236, -0.336> <0.688, -0.237, -0.337> <0.688, -0.237, -0.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.568, -0.234, -0.335> <0.604, -0.234, -0.335> <0.656, -0.222, -0.335> <0.689, -0.236, -0.335> 
		<0.568, -0.234, -0.335> <0.604, -0.234, -0.335> <0.656, -0.222, -0.334> <0.689, -0.236, -0.334> 
		<0.568, -0.234, -0.334> <0.604, -0.235, -0.334> <0.655, -0.222, -0.334> <0.688, -0.237, -0.333> 
		<0.568, -0.234, -0.334> <0.604, -0.235, -0.334> <0.655, -0.222, -0.333> <0.688, -0.237, -0.333> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.689, -0.236, -0.335> <0.689, -0.236, -0.336> <0.688, -0.237, -0.337> <0.688, -0.237, -0.337> 
		<0.713, -0.247, -0.335> <0.713, -0.247, -0.336> <0.713, -0.248, -0.337> <0.713, -0.248, -0.338> 
		<0.725, -0.288, -0.335> <0.725, -0.288, -0.336> <0.724, -0.288, -0.338> <0.724, -0.289, -0.339> 
		<0.740, -0.310, -0.335> <0.740, -0.310, -0.336> <0.740, -0.311, -0.338> <0.739, -0.311, -0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.689, -0.236, -0.335> <0.713, -0.247, -0.335> <0.725, -0.288, -0.335> <0.740, -0.310, -0.335> 
		<0.689, -0.236, -0.334> <0.713, -0.247, -0.334> <0.725, -0.288, -0.333> <0.740, -0.310, -0.333> 
		<0.688, -0.237, -0.333> <0.713, -0.248, -0.333> <0.724, -0.288, -0.332> <0.740, -0.311, -0.331> 
		<0.688, -0.237, -0.333> <0.713, -0.248, -0.332> <0.724, -0.289, -0.331> <0.739, -0.311, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.568, -0.234, -0.334> <0.604, -0.235, -0.334> <0.655, -0.222, -0.333> <0.688, -0.237, -0.333> 
		<0.567, -0.234, -0.334> <0.604, -0.235, -0.334> <0.655, -0.222, -0.333> <0.687, -0.237, -0.332> 
		<0.567, -0.234, -0.334> <0.603, -0.235, -0.333> <0.654, -0.222, -0.333> <0.687, -0.238, -0.332> 
		<0.567, -0.234, -0.334> <0.603, -0.235, -0.333> <0.654, -0.223, -0.333> <0.686, -0.238, -0.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.567, -0.234, -0.334> <0.603, -0.235, -0.333> <0.654, -0.223, -0.333> <0.686, -0.238, -0.332> 
		<0.567, -0.234, -0.334> <0.603, -0.235, -0.333> <0.653, -0.223, -0.333> <0.685, -0.238, -0.332> 
		<0.567, -0.234, -0.334> <0.602, -0.236, -0.334> <0.653, -0.223, -0.333> <0.685, -0.239, -0.332> 
		<0.567, -0.234, -0.334> <0.602, -0.236, -0.334> <0.652, -0.224, -0.333> <0.684, -0.239, -0.333> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.567, -0.234, -0.334> <0.602, -0.236, -0.334> <0.652, -0.224, -0.333> <0.684, -0.239, -0.333> 
		<0.567, -0.234, -0.334> <0.602, -0.236, -0.334> <0.652, -0.224, -0.334> <0.684, -0.240, -0.333> 
		<0.566, -0.234, -0.335> <0.602, -0.236, -0.335> <0.652, -0.224, -0.334> <0.683, -0.240, -0.334> 
		<0.566, -0.234, -0.335> <0.602, -0.236, -0.335> <0.652, -0.224, -0.335> <0.683, -0.240, -0.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.566, -0.234, -0.335> <0.602, -0.236, -0.335> <0.652, -0.224, -0.335> <0.683, -0.240, -0.335> 
		<0.566, -0.234, -0.335> <0.602, -0.236, -0.335> <0.652, -0.224, -0.336> <0.683, -0.240, -0.336> 
		<0.567, -0.234, -0.335> <0.602, -0.236, -0.336> <0.652, -0.224, -0.336> <0.684, -0.240, -0.337> 
		<0.567, -0.234, -0.335> <0.602, -0.236, -0.336> <0.652, -0.224, -0.336> <0.684, -0.239, -0.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.567, -0.234, -0.335> <0.602, -0.236, -0.336> <0.652, -0.224, -0.336> <0.684, -0.239, -0.337> 
		<0.567, -0.234, -0.335> <0.602, -0.236, -0.336> <0.653, -0.223, -0.337> <0.685, -0.239, -0.338> 
		<0.567, -0.234, -0.336> <0.603, -0.235, -0.336> <0.653, -0.223, -0.337> <0.685, -0.238, -0.338> 
		<0.567, -0.234, -0.336> <0.603, -0.235, -0.336> <0.654, -0.223, -0.337> <0.686, -0.238, -0.338> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.567, -0.234, -0.336> <0.603, -0.235, -0.336> <0.654, -0.223, -0.337> <0.686, -0.238, -0.338> 
		<0.567, -0.234, -0.336> <0.603, -0.235, -0.336> <0.654, -0.222, -0.337> <0.687, -0.238, -0.338> 
		<0.567, -0.234, -0.335> <0.604, -0.235, -0.336> <0.655, -0.222, -0.337> <0.687, -0.237, -0.338> 
		<0.568, -0.234, -0.335> <0.604, -0.235, -0.336> <0.655, -0.222, -0.336> <0.688, -0.237, -0.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.688, -0.237, -0.333> <0.713, -0.248, -0.332> <0.724, -0.289, -0.331> <0.739, -0.311, -0.330> 
		<0.687, -0.237, -0.332> <0.712, -0.248, -0.331> <0.723, -0.289, -0.330> <0.738, -0.312, -0.330> 
		<0.687, -0.238, -0.332> <0.711, -0.249, -0.331> <0.722, -0.290, -0.330> <0.736, -0.313, -0.329> 
		<0.686, -0.238, -0.332> <0.710, -0.250, -0.331> <0.721, -0.291, -0.330> <0.735, -0.313, -0.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.686, -0.238, -0.332> <0.710, -0.250, -0.331> <0.721, -0.291, -0.330> <0.735, -0.313, -0.329> 
		<0.685, -0.238, -0.332> <0.710, -0.250, -0.331> <0.719, -0.292, -0.330> <0.734, -0.314, -0.329> 
		<0.685, -0.239, -0.332> <0.709, -0.251, -0.331> <0.718, -0.292, -0.330> <0.733, -0.315, -0.330> 
		<0.684, -0.239, -0.333> <0.708, -0.251, -0.332> <0.717, -0.293, -0.331> <0.732, -0.316, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.684, -0.239, -0.333> <0.708, -0.251, -0.332> <0.717, -0.293, -0.331> <0.732, -0.316, -0.330> 
		<0.684, -0.240, -0.333> <0.708, -0.252, -0.333> <0.717, -0.293, -0.332> <0.731, -0.316, -0.331> 
		<0.683, -0.240, -0.334> <0.707, -0.252, -0.334> <0.716, -0.294, -0.333> <0.730, -0.317, -0.333> 
		<0.683, -0.240, -0.335> <0.707, -0.252, -0.335> <0.716, -0.294, -0.335> <0.730, -0.317, -0.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.683, -0.240, -0.335> <0.707, -0.252, -0.335> <0.716, -0.294, -0.335> <0.730, -0.317, -0.335> 
		<0.683, -0.240, -0.336> <0.707, -0.252, -0.336> <0.716, -0.294, -0.336> <0.730, -0.317, -0.336> 
		<0.684, -0.240, -0.337> <0.708, -0.252, -0.337> <0.717, -0.293, -0.338> <0.731, -0.316, -0.338> 
		<0.684, -0.239, -0.337> <0.708, -0.251, -0.338> <0.717, -0.293, -0.339> <0.732, -0.316, -0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.684, -0.239, -0.337> <0.708, -0.251, -0.338> <0.717, -0.293, -0.339> <0.732, -0.316, -0.339> 
		<0.685, -0.239, -0.338> <0.709, -0.251, -0.338> <0.718, -0.292, -0.340> <0.733, -0.315, -0.340> 
		<0.685, -0.238, -0.338> <0.710, -0.250, -0.339> <0.719, -0.292, -0.340> <0.734, -0.314, -0.341> 
		<0.686, -0.238, -0.338> <0.710, -0.250, -0.339> <0.721, -0.291, -0.340> <0.735, -0.313, -0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.686, -0.238, -0.338> <0.710, -0.250, -0.339> <0.721, -0.291, -0.340> <0.735, -0.313, -0.341> 
		<0.687, -0.238, -0.338> <0.711, -0.249, -0.339> <0.722, -0.290, -0.340> <0.736, -0.313, -0.341> 
		<0.687, -0.237, -0.338> <0.712, -0.248, -0.338> <0.723, -0.289, -0.340> <0.738, -0.312, -0.340> 
		<0.688, -0.237, -0.337> <0.713, -0.248, -0.338> <0.724, -0.289, -0.339> <0.739, -0.311, -0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.855, -0.197, -0.262> <0.855, -0.197, -0.262> <0.855, -0.197, -0.262> <0.855, -0.197, -0.262> 
		<0.840, -0.200, -0.280> <0.841, -0.200, -0.281> <0.841, -0.200, -0.281> <0.841, -0.200, -0.281> 
		<0.816, -0.188, -0.313> <0.817, -0.188, -0.313> <0.817, -0.188, -0.313> <0.817, -0.188, -0.314> 
		<0.807, -0.207, -0.324> <0.808, -0.207, -0.324> <0.809, -0.207, -0.325> <0.809, -0.207, -0.326> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.855, -0.197, -0.262> <0.840, -0.200, -0.280> <0.816, -0.188, -0.313> <0.807, -0.207, -0.324> 
		<0.855, -0.197, -0.262> <0.840, -0.200, -0.280> <0.816, -0.188, -0.313> <0.806, -0.207, -0.323> 
		<0.854, -0.197, -0.262> <0.839, -0.200, -0.280> <0.815, -0.188, -0.312> <0.805, -0.207, -0.323> 
		<0.854, -0.197, -0.262> <0.839, -0.200, -0.280> <0.815, -0.188, -0.313> <0.805, -0.207, -0.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.807, -0.207, -0.324> <0.808, -0.207, -0.324> <0.809, -0.207, -0.325> <0.809, -0.207, -0.326> 
		<0.797, -0.228, -0.336> <0.797, -0.228, -0.337> <0.799, -0.228, -0.338> <0.799, -0.228, -0.339> 
		<0.806, -0.270, -0.321> <0.807, -0.270, -0.322> <0.808, -0.270, -0.323> <0.809, -0.270, -0.324> 
		<0.806, -0.297, -0.320> <0.807, -0.297, -0.321> <0.808, -0.297, -0.322> <0.809, -0.297, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.807, -0.207, -0.324> <0.797, -0.228, -0.336> <0.806, -0.270, -0.321> <0.806, -0.297, -0.320> 
		<0.806, -0.207, -0.323> <0.796, -0.228, -0.336> <0.805, -0.270, -0.321> <0.804, -0.297, -0.319> 
		<0.805, -0.207, -0.323> <0.794, -0.228, -0.336> <0.803, -0.270, -0.320> <0.802, -0.297, -0.319> 
		<0.805, -0.207, -0.324> <0.793, -0.228, -0.336> <0.802, -0.270, -0.321> <0.801, -0.297, -0.320> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.854, -0.197, -0.262> <0.839, -0.200, -0.280> <0.815, -0.188, -0.313> <0.805, -0.207, -0.324> 
		<0.854, -0.197, -0.262> <0.839, -0.200, -0.280> <0.814, -0.188, -0.313> <0.804, -0.207, -0.324> 
		<0.854, -0.197, -0.262> <0.839, -0.200, -0.281> <0.814, -0.188, -0.313> <0.803, -0.207, -0.325> 
		<0.854, -0.197, -0.262> <0.838, -0.200, -0.281> <0.813, -0.188, -0.314> <0.803, -0.207, -0.325> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.854, -0.197, -0.262> <0.838, -0.200, -0.281> <0.813, -0.188, -0.314> <0.803, -0.207, -0.325> 
		<0.854, -0.197, -0.262> <0.838, -0.200, -0.281> <0.813, -0.188, -0.315> <0.803, -0.207, -0.326> 
		<0.854, -0.197, -0.263> <0.838, -0.200, -0.282> <0.813, -0.188, -0.315> <0.802, -0.207, -0.327> 
		<0.854, -0.197, -0.263> <0.838, -0.200, -0.282> <0.813, -0.188, -0.316> <0.803, -0.207, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.854, -0.197, -0.263> <0.838, -0.200, -0.282> <0.813, -0.188, -0.316> <0.803, -0.207, -0.328> 
		<0.854, -0.197, -0.263> <0.838, -0.200, -0.282> <0.814, -0.188, -0.316> <0.803, -0.207, -0.329> 
		<0.854, -0.197, -0.263> <0.839, -0.200, -0.283> <0.814, -0.188, -0.316> <0.804, -0.207, -0.329> 
		<0.854, -0.197, -0.263> <0.839, -0.200, -0.283> <0.815, -0.188, -0.317> <0.804, -0.207, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.854, -0.197, -0.263> <0.839, -0.200, -0.283> <0.815, -0.188, -0.317> <0.804, -0.207, -0.330> 
		<0.854, -0.197, -0.263> <0.839, -0.200, -0.283> <0.815, -0.188, -0.317> <0.805, -0.207, -0.330> 
		<0.854, -0.197, -0.263> <0.840, -0.200, -0.283> <0.816, -0.188, -0.317> <0.806, -0.207, -0.330> 
		<0.855, -0.197, -0.263> <0.840, -0.200, -0.283> <0.816, -0.188, -0.317> <0.807, -0.207, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.855, -0.197, -0.263> <0.840, -0.200, -0.283> <0.816, -0.188, -0.317> <0.807, -0.207, -0.330> 
		<0.855, -0.197, -0.263> <0.840, -0.200, -0.283> <0.817, -0.188, -0.317> <0.808, -0.207, -0.329> 
		<0.855, -0.197, -0.263> <0.841, -0.200, -0.283> <0.817, -0.188, -0.316> <0.808, -0.207, -0.329> 
		<0.855, -0.197, -0.263> <0.841, -0.200, -0.282> <0.817, -0.188, -0.316> <0.809, -0.207, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.855, -0.197, -0.263> <0.841, -0.200, -0.282> <0.817, -0.188, -0.316> <0.809, -0.207, -0.328> 
		<0.855, -0.197, -0.263> <0.841, -0.200, -0.282> <0.818, -0.188, -0.315> <0.809, -0.207, -0.327> 
		<0.855, -0.197, -0.262> <0.841, -0.200, -0.281> <0.818, -0.188, -0.315> <0.809, -0.207, -0.326> 
		<0.855, -0.197, -0.262> <0.841, -0.200, -0.281> <0.817, -0.188, -0.314> <0.809, -0.207, -0.326> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.805, -0.207, -0.324> <0.793, -0.228, -0.336> <0.802, -0.270, -0.321> <0.801, -0.297, -0.320> 
		<0.804, -0.207, -0.324> <0.793, -0.228, -0.336> <0.801, -0.270, -0.321> <0.800, -0.297, -0.320> 
		<0.803, -0.207, -0.325> <0.791, -0.228, -0.337> <0.800, -0.270, -0.322> <0.798, -0.297, -0.322> 
		<0.803, -0.207, -0.325> <0.791, -0.228, -0.338> <0.799, -0.270, -0.324> <0.798, -0.297, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.803, -0.207, -0.325> <0.791, -0.228, -0.338> <0.799, -0.270, -0.324> <0.798, -0.297, -0.323> 
		<0.803, -0.207, -0.326> <0.791, -0.228, -0.339> <0.799, -0.270, -0.325> <0.797, -0.297, -0.324> 
		<0.802, -0.207, -0.327> <0.791, -0.227, -0.340> <0.799, -0.270, -0.326> <0.797, -0.297, -0.326> 
		<0.803, -0.207, -0.328> <0.791, -0.227, -0.341> <0.799, -0.270, -0.328> <0.797, -0.297, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.803, -0.207, -0.328> <0.791, -0.227, -0.341> <0.799, -0.270, -0.328> <0.797, -0.297, -0.328> 
		<0.803, -0.207, -0.329> <0.791, -0.227, -0.342> <0.800, -0.270, -0.329> <0.798, -0.297, -0.329> 
		<0.804, -0.207, -0.329> <0.793, -0.227, -0.343> <0.801, -0.270, -0.330> <0.799, -0.297, -0.331> 
		<0.804, -0.207, -0.330> <0.794, -0.227, -0.344> <0.802, -0.270, -0.331> <0.801, -0.297, -0.331> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.804, -0.207, -0.330> <0.794, -0.227, -0.344> <0.802, -0.270, -0.331> <0.801, -0.297, -0.331> 
		<0.805, -0.207, -0.330> <0.794, -0.227, -0.344> <0.803, -0.270, -0.331> <0.802, -0.297, -0.332> 
		<0.806, -0.207, -0.330> <0.796, -0.228, -0.344> <0.805, -0.270, -0.331> <0.804, -0.297, -0.332> 
		<0.807, -0.207, -0.330> <0.797, -0.228, -0.344> <0.806, -0.270, -0.331> <0.805, -0.297, -0.331> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.807, -0.207, -0.330> <0.797, -0.228, -0.344> <0.806, -0.270, -0.331> <0.805, -0.297, -0.331> 
		<0.808, -0.207, -0.329> <0.797, -0.228, -0.344> <0.807, -0.270, -0.330> <0.807, -0.297, -0.331> 
		<0.808, -0.207, -0.329> <0.799, -0.228, -0.342> <0.808, -0.270, -0.329> <0.808, -0.297, -0.329> 
		<0.809, -0.207, -0.328> <0.799, -0.228, -0.342> <0.809, -0.270, -0.328> <0.809, -0.297, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.809, -0.207, -0.328> <0.799, -0.228, -0.342> <0.809, -0.270, -0.328> <0.809, -0.297, -0.328> 
		<0.809, -0.207, -0.327> <0.799, -0.228, -0.341> <0.809, -0.270, -0.327> <0.809, -0.297, -0.327> 
		<0.809, -0.207, -0.326> <0.799, -0.228, -0.339> <0.809, -0.270, -0.325> <0.809, -0.297, -0.325> 
		<0.809, -0.207, -0.326> <0.799, -0.228, -0.339> <0.809, -0.270, -0.324> <0.809, -0.297, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.232, -0.456> <0.779, -0.232, -0.456> <0.779, -0.232, -0.456> <0.779, -0.232, -0.456> 
		<0.773, -0.233, -0.435> <0.774, -0.233, -0.435> <0.774, -0.233, -0.435> <0.775, -0.233, -0.435> 
		<0.764, -0.223, -0.403> <0.765, -0.223, -0.403> <0.765, -0.223, -0.403> <0.766, -0.223, -0.403> 
		<0.761, -0.236, -0.385> <0.762, -0.236, -0.385> <0.763, -0.236, -0.385> <0.764, -0.236, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.232, -0.456> <0.773, -0.233, -0.435> <0.764, -0.223, -0.403> <0.761, -0.236, -0.385> 
		<0.779, -0.232, -0.456> <0.773, -0.233, -0.435> <0.763, -0.223, -0.403> <0.760, -0.236, -0.385> 
		<0.778, -0.232, -0.456> <0.773, -0.233, -0.435> <0.763, -0.223, -0.403> <0.760, -0.236, -0.386> 
		<0.778, -0.232, -0.456> <0.773, -0.234, -0.435> <0.762, -0.224, -0.404> <0.759, -0.236, -0.386> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.761, -0.236, -0.385> <0.762, -0.236, -0.385> <0.763, -0.236, -0.385> <0.764, -0.236, -0.385> 
		<0.758, -0.251, -0.363> <0.758, -0.251, -0.363> <0.760, -0.251, -0.363> <0.761, -0.252, -0.363> 
		<0.761, -0.291, -0.354> <0.762, -0.291, -0.354> <0.763, -0.291, -0.354> <0.765, -0.291, -0.355> 
		<0.760, -0.314, -0.341> <0.762, -0.314, -0.341> <0.764, -0.314, -0.341> <0.765, -0.315, -0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.761, -0.236, -0.385> <0.758, -0.251, -0.363> <0.761, -0.291, -0.354> <0.760, -0.314, -0.341> 
		<0.760, -0.236, -0.385> <0.757, -0.251, -0.363> <0.759, -0.291, -0.354> <0.759, -0.314, -0.341> 
		<0.760, -0.236, -0.386> <0.755, -0.252, -0.364> <0.758, -0.291, -0.355> <0.757, -0.315, -0.342> 
		<0.759, -0.236, -0.386> <0.755, -0.252, -0.365> <0.757, -0.292, -0.356> <0.757, -0.316, -0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.778, -0.232, -0.456> <0.773, -0.234, -0.435> <0.762, -0.224, -0.404> <0.759, -0.236, -0.386> 
		<0.778, -0.232, -0.456> <0.772, -0.234, -0.435> <0.762, -0.224, -0.404> <0.759, -0.237, -0.387> 
		<0.778, -0.232, -0.457> <0.772, -0.234, -0.436> <0.762, -0.224, -0.405> <0.759, -0.237, -0.388> 
		<0.778, -0.233, -0.457> <0.772, -0.234, -0.436> <0.762, -0.225, -0.405> <0.759, -0.238, -0.389> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.778, -0.233, -0.457> <0.772, -0.234, -0.436> <0.762, -0.225, -0.405> <0.759, -0.238, -0.389> 
		<0.778, -0.233, -0.457> <0.772, -0.234, -0.437> <0.762, -0.225, -0.406> <0.759, -0.238, -0.389> 
		<0.778, -0.233, -0.457> <0.773, -0.234, -0.437> <0.763, -0.225, -0.406> <0.760, -0.238, -0.390> 
		<0.779, -0.233, -0.457> <0.773, -0.234, -0.437> <0.763, -0.225, -0.406> <0.760, -0.238, -0.390> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.233, -0.457> <0.773, -0.234, -0.437> <0.763, -0.225, -0.406> <0.760, -0.238, -0.390> 
		<0.779, -0.233, -0.457> <0.773, -0.235, -0.437> <0.764, -0.226, -0.407> <0.761, -0.239, -0.391> 
		<0.779, -0.233, -0.457> <0.774, -0.235, -0.437> <0.764, -0.226, -0.407> <0.762, -0.239, -0.391> 
		<0.779, -0.233, -0.457> <0.774, -0.235, -0.437> <0.765, -0.226, -0.406> <0.763, -0.239, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.233, -0.457> <0.774, -0.235, -0.437> <0.765, -0.226, -0.406> <0.763, -0.239, -0.391> 
		<0.779, -0.233, -0.457> <0.774, -0.235, -0.437> <0.766, -0.225, -0.406> <0.764, -0.239, -0.390> 
		<0.779, -0.233, -0.457> <0.775, -0.234, -0.437> <0.766, -0.225, -0.406> <0.764, -0.238, -0.390> 
		<0.780, -0.233, -0.457> <0.775, -0.234, -0.437> <0.767, -0.225, -0.405> <0.765, -0.238, -0.389> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.780, -0.233, -0.457> <0.775, -0.234, -0.437> <0.767, -0.225, -0.405> <0.765, -0.238, -0.389> 
		<0.780, -0.233, -0.457> <0.775, -0.234, -0.436> <0.767, -0.225, -0.405> <0.765, -0.238, -0.389> 
		<0.780, -0.232, -0.457> <0.775, -0.234, -0.436> <0.767, -0.224, -0.405> <0.765, -0.237, -0.388> 
		<0.780, -0.232, -0.456> <0.775, -0.234, -0.436> <0.767, -0.224, -0.404> <0.765, -0.237, -0.387> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.780, -0.232, -0.456> <0.775, -0.234, -0.436> <0.767, -0.224, -0.404> <0.765, -0.237, -0.387> 
		<0.780, -0.232, -0.456> <0.775, -0.234, -0.435> <0.767, -0.224, -0.403> <0.765, -0.236, -0.386> 
		<0.779, -0.232, -0.456> <0.775, -0.233, -0.435> <0.766, -0.223, -0.403> <0.764, -0.236, -0.386> 
		<0.779, -0.232, -0.456> <0.775, -0.233, -0.435> <0.766, -0.223, -0.403> <0.764, -0.236, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.759, -0.236, -0.386> <0.755, -0.252, -0.365> <0.757, -0.292, -0.356> <0.757, -0.316, -0.343> 
		<0.759, -0.237, -0.387> <0.755, -0.253, -0.365> <0.757, -0.292, -0.357> <0.756, -0.316, -0.345> 
		<0.759, -0.237, -0.388> <0.754, -0.254, -0.367> <0.757, -0.293, -0.359> <0.756, -0.317, -0.346> 
		<0.759, -0.238, -0.389> <0.755, -0.254, -0.368> <0.757, -0.294, -0.360> <0.756, -0.318, -0.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.759, -0.238, -0.389> <0.755, -0.254, -0.368> <0.757, -0.294, -0.360> <0.756, -0.318, -0.348> 
		<0.759, -0.238, -0.389> <0.755, -0.254, -0.368> <0.757, -0.294, -0.361> <0.757, -0.318, -0.349> 
		<0.760, -0.238, -0.390> <0.756, -0.255, -0.369> <0.758, -0.295, -0.362> <0.758, -0.319, -0.350> 
		<0.760, -0.238, -0.390> <0.757, -0.255, -0.370> <0.759, -0.295, -0.363> <0.759, -0.320, -0.351> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.760, -0.238, -0.390> <0.757, -0.255, -0.370> <0.759, -0.295, -0.363> <0.759, -0.320, -0.351> 
		<0.761, -0.239, -0.391> <0.757, -0.256, -0.370> <0.761, -0.296, -0.363> <0.760, -0.320, -0.351> 
		<0.762, -0.239, -0.391> <0.759, -0.256, -0.370> <0.762, -0.296, -0.363> <0.762, -0.320, -0.352> 
		<0.763, -0.239, -0.391> <0.760, -0.256, -0.370> <0.763, -0.295, -0.363> <0.764, -0.320, -0.351> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.763, -0.239, -0.391> <0.760, -0.256, -0.370> <0.763, -0.295, -0.363> <0.764, -0.320, -0.351> 
		<0.764, -0.239, -0.390> <0.761, -0.256, -0.370> <0.765, -0.295, -0.363> <0.765, -0.320, -0.351> 
		<0.764, -0.238, -0.390> <0.762, -0.255, -0.369> <0.766, -0.295, -0.362> <0.767, -0.319, -0.350> 
		<0.765, -0.238, -0.389> <0.762, -0.255, -0.368> <0.767, -0.294, -0.361> <0.767, -0.318, -0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.765, -0.238, -0.389> <0.762, -0.255, -0.368> <0.767, -0.294, -0.361> <0.767, -0.318, -0.349> 
		<0.765, -0.238, -0.389> <0.763, -0.254, -0.367> <0.767, -0.294, -0.360> <0.768, -0.318, -0.348> 
		<0.765, -0.237, -0.388> <0.763, -0.253, -0.366> <0.767, -0.293, -0.359> <0.768, -0.317, -0.346> 
		<0.765, -0.237, -0.387> <0.763, -0.253, -0.365> <0.767, -0.292, -0.357> <0.768, -0.316, -0.345> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.765, -0.237, -0.387> <0.763, -0.253, -0.365> <0.767, -0.292, -0.357> <0.768, -0.316, -0.345> 
		<0.765, -0.236, -0.386> <0.763, -0.253, -0.365> <0.767, -0.292, -0.356> <0.768, -0.316, -0.343> 
		<0.764, -0.236, -0.386> <0.762, -0.252, -0.364> <0.766, -0.291, -0.355> <0.766, -0.315, -0.342> 
		<0.764, -0.236, -0.385> <0.761, -0.252, -0.363> <0.765, -0.291, -0.355> <0.765, -0.315, -0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.673, -0.270, -0.247> <0.673, -0.270, -0.247> <0.673, -0.270, -0.248> <0.673, -0.270, -0.248> 
		<0.683, -0.259, -0.259> <0.683, -0.259, -0.259> <0.683, -0.259, -0.260> <0.682, -0.259, -0.260> 
		<0.696, -0.226, -0.273> <0.695, -0.226, -0.274> <0.695, -0.226, -0.274> <0.694, -0.226, -0.274> 
		<0.708, -0.233, -0.287> <0.707, -0.233, -0.287> <0.706, -0.233, -0.287> <0.705, -0.233, -0.287> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.673, -0.270, -0.247> <0.683, -0.259, -0.259> <0.696, -0.226, -0.273> <0.708, -0.233, -0.287> 
		<0.673, -0.270, -0.247> <0.684, -0.259, -0.259> <0.696, -0.226, -0.273> <0.708, -0.233, -0.286> 
		<0.673, -0.270, -0.247> <0.684, -0.259, -0.258> <0.697, -0.226, -0.272> <0.709, -0.233, -0.285> 
		<0.673, -0.270, -0.247> <0.684, -0.259, -0.258> <0.697, -0.226, -0.272> <0.709, -0.233, -0.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.708, -0.233, -0.287> <0.707, -0.233, -0.287> <0.706, -0.233, -0.287> <0.705, -0.233, -0.287> 
		<0.724, -0.243, -0.305> <0.724, -0.243, -0.306> <0.722, -0.244, -0.307> <0.721, -0.244, -0.307> 
		<0.729, -0.287, -0.311> <0.728, -0.287, -0.312> <0.727, -0.287, -0.312> <0.725, -0.288, -0.312> 
		<0.738, -0.310, -0.321> <0.737, -0.310, -0.322> <0.735, -0.311, -0.323> <0.734, -0.311, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.708, -0.233, -0.287> <0.724, -0.243, -0.305> <0.729, -0.287, -0.311> <0.738, -0.310, -0.321> 
		<0.708, -0.233, -0.286> <0.725, -0.243, -0.305> <0.730, -0.287, -0.310> <0.739, -0.310, -0.320> 
		<0.709, -0.233, -0.285> <0.726, -0.244, -0.303> <0.731, -0.287, -0.309> <0.740, -0.311, -0.318> 
		<0.709, -0.233, -0.284> <0.726, -0.244, -0.302> <0.731, -0.288, -0.307> <0.740, -0.311, -0.317> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.673, -0.270, -0.247> <0.684, -0.259, -0.258> <0.697, -0.226, -0.272> <0.709, -0.233, -0.284> 
		<0.673, -0.270, -0.247> <0.684, -0.259, -0.258> <0.697, -0.226, -0.271> <0.709, -0.234, -0.284> 
		<0.673, -0.270, -0.246> <0.684, -0.260, -0.257> <0.697, -0.226, -0.271> <0.709, -0.234, -0.283> 
		<0.673, -0.270, -0.246> <0.684, -0.260, -0.257> <0.696, -0.227, -0.270> <0.708, -0.234, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.673, -0.270, -0.246> <0.684, -0.260, -0.257> <0.696, -0.227, -0.270> <0.708, -0.234, -0.282> 
		<0.673, -0.270, -0.246> <0.684, -0.260, -0.257> <0.696, -0.227, -0.270> <0.708, -0.235, -0.282> 
		<0.673, -0.271, -0.246> <0.683, -0.260, -0.257> <0.696, -0.227, -0.270> <0.707, -0.235, -0.281> 
		<0.673, -0.271, -0.246> <0.683, -0.260, -0.257> <0.695, -0.228, -0.270> <0.706, -0.235, -0.281> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.673, -0.271, -0.246> <0.683, -0.260, -0.257> <0.695, -0.228, -0.270> <0.706, -0.235, -0.281> 
		<0.673, -0.271, -0.246> <0.683, -0.260, -0.257> <0.694, -0.228, -0.270> <0.705, -0.236, -0.281> 
		<0.672, -0.271, -0.246> <0.682, -0.260, -0.257> <0.694, -0.228, -0.270> <0.704, -0.236, -0.282> 
		<0.672, -0.271, -0.246> <0.682, -0.260, -0.257> <0.693, -0.228, -0.270> <0.704, -0.236, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.672, -0.271, -0.246> <0.682, -0.260, -0.257> <0.693, -0.228, -0.270> <0.704, -0.236, -0.282> 
		<0.672, -0.271, -0.246> <0.682, -0.260, -0.257> <0.693, -0.228, -0.271> <0.703, -0.236, -0.283> 
		<0.672, -0.271, -0.247> <0.681, -0.260, -0.258> <0.693, -0.228, -0.271> <0.703, -0.236, -0.284> 
		<0.672, -0.271, -0.247> <0.681, -0.260, -0.258> <0.693, -0.228, -0.272> <0.703, -0.235, -0.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.672, -0.271, -0.247> <0.681, -0.260, -0.258> <0.693, -0.228, -0.272> <0.703, -0.235, -0.284> 
		<0.672, -0.271, -0.247> <0.681, -0.260, -0.258> <0.692, -0.227, -0.273> <0.703, -0.235, -0.285> 
		<0.672, -0.270, -0.247> <0.681, -0.260, -0.259> <0.693, -0.227, -0.273> <0.703, -0.235, -0.286> 
		<0.672, -0.270, -0.247> <0.681, -0.260, -0.259> <0.693, -0.227, -0.273> <0.703, -0.234, -0.287> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.672, -0.270, -0.247> <0.681, -0.260, -0.259> <0.693, -0.227, -0.273> <0.703, -0.234, -0.287> 
		<0.672, -0.270, -0.247> <0.682, -0.260, -0.259> <0.693, -0.226, -0.274> <0.704, -0.234, -0.287> 
		<0.672, -0.270, -0.248> <0.682, -0.259, -0.260> <0.694, -0.226, -0.274> <0.705, -0.234, -0.287> 
		<0.673, -0.270, -0.248> <0.682, -0.259, -0.260> <0.694, -0.226, -0.274> <0.705, -0.233, -0.287> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.709, -0.233, -0.284> <0.726, -0.244, -0.302> <0.731, -0.288, -0.307> <0.740, -0.311, -0.317> 
		<0.709, -0.234, -0.284> <0.726, -0.244, -0.302> <0.731, -0.288, -0.306> <0.741, -0.312, -0.316> 
		<0.709, -0.234, -0.283> <0.726, -0.245, -0.300> <0.731, -0.289, -0.305> <0.740, -0.312, -0.314> 
		<0.708, -0.234, -0.282> <0.726, -0.246, -0.300> <0.730, -0.290, -0.304> <0.739, -0.313, -0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.708, -0.234, -0.282> <0.726, -0.246, -0.300> <0.730, -0.290, -0.304> <0.739, -0.313, -0.313> 
		<0.708, -0.235, -0.282> <0.725, -0.246, -0.299> <0.729, -0.290, -0.303> <0.738, -0.314, -0.312> 
		<0.707, -0.235, -0.281> <0.724, -0.247, -0.299> <0.728, -0.291, -0.302> <0.737, -0.315, -0.311> 
		<0.706, -0.235, -0.281> <0.723, -0.247, -0.299> <0.727, -0.291, -0.302> <0.735, -0.315, -0.311> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.706, -0.235, -0.281> <0.723, -0.247, -0.299> <0.727, -0.291, -0.302> <0.735, -0.315, -0.311> 
		<0.705, -0.236, -0.281> <0.722, -0.248, -0.299> <0.725, -0.292, -0.302> <0.734, -0.316, -0.311> 
		<0.704, -0.236, -0.282> <0.720, -0.248, -0.300> <0.724, -0.292, -0.303> <0.732, -0.316, -0.312> 
		<0.704, -0.236, -0.282> <0.720, -0.248, -0.300> <0.723, -0.292, -0.304> <0.731, -0.316, -0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.704, -0.236, -0.282> <0.720, -0.248, -0.300> <0.723, -0.292, -0.304> <0.731, -0.316, -0.313> 
		<0.703, -0.236, -0.283> <0.719, -0.248, -0.301> <0.722, -0.292, -0.305> <0.730, -0.316, -0.314> 
		<0.703, -0.236, -0.284> <0.718, -0.248, -0.303> <0.721, -0.292, -0.306> <0.729, -0.316, -0.316> 
		<0.703, -0.235, -0.284> <0.718, -0.247, -0.303> <0.721, -0.291, -0.307> <0.729, -0.315, -0.317> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.703, -0.235, -0.284> <0.718, -0.247, -0.303> <0.721, -0.291, -0.307> <0.729, -0.315, -0.317> 
		<0.703, -0.235, -0.285> <0.718, -0.247, -0.304> <0.721, -0.291, -0.309> <0.729, -0.315, -0.318> 
		<0.703, -0.235, -0.286> <0.718, -0.246, -0.305> <0.721, -0.290, -0.310> <0.729, -0.314, -0.320> 
		<0.703, -0.234, -0.287> <0.719, -0.246, -0.306> <0.722, -0.290, -0.311> <0.730, -0.313, -0.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.703, -0.234, -0.287> <0.719, -0.246, -0.306> <0.722, -0.290, -0.311> <0.730, -0.313, -0.321> 
		<0.704, -0.234, -0.287> <0.719, -0.245, -0.306> <0.723, -0.289, -0.312> <0.731, -0.312, -0.322> 
		<0.705, -0.234, -0.287> <0.720, -0.244, -0.307> <0.724, -0.288, -0.312> <0.733, -0.312, -0.323> 
		<0.705, -0.233, -0.287> <0.721, -0.244, -0.307> <0.725, -0.288, -0.312> <0.734, -0.311, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.920, -0.193, -0.327> <0.920, -0.193, -0.327> <0.920, -0.192, -0.327> <0.920, -0.193, -0.326> 
		<0.902, -0.206, -0.331> <0.902, -0.206, -0.331> <0.902, -0.206, -0.330> <0.902, -0.206, -0.330> 
		<0.875, -0.219, -0.340> <0.874, -0.219, -0.339> <0.874, -0.219, -0.338> <0.874, -0.219, -0.338> 
		<0.861, -0.237, -0.340> <0.860, -0.237, -0.339> <0.860, -0.237, -0.338> <0.860, -0.237, -0.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.920, -0.193, -0.327> <0.902, -0.206, -0.331> <0.875, -0.219, -0.340> <0.861, -0.237, -0.340> 
		<0.920, -0.193, -0.327> <0.902, -0.206, -0.331> <0.875, -0.220, -0.340> <0.861, -0.237, -0.340> 
		<0.920, -0.193, -0.327> <0.903, -0.206, -0.331> <0.875, -0.220, -0.340> <0.862, -0.238, -0.341> 
		<0.921, -0.193, -0.327> <0.903, -0.206, -0.331> <0.876, -0.220, -0.341> <0.862, -0.238, -0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.861, -0.237, -0.340> <0.860, -0.237, -0.339> <0.860, -0.237, -0.338> <0.860, -0.237, -0.337> 
		<0.846, -0.255, -0.339> <0.846, -0.255, -0.339> <0.845, -0.254, -0.337> <0.845, -0.255, -0.336> 
		<0.838, -0.285, -0.331> <0.837, -0.285, -0.330> <0.837, -0.285, -0.328> <0.837, -0.285, -0.327> 
		<0.828, -0.306, -0.327> <0.828, -0.305, -0.326> <0.827, -0.305, -0.324> <0.828, -0.305, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.861, -0.237, -0.340> <0.846, -0.255, -0.339> <0.838, -0.285, -0.331> <0.828, -0.306, -0.327> 
		<0.861, -0.237, -0.340> <0.846, -0.255, -0.340> <0.839, -0.286, -0.332> <0.829, -0.306, -0.328> 
		<0.862, -0.238, -0.341> <0.847, -0.256, -0.341> <0.839, -0.286, -0.333> <0.830, -0.308, -0.329> 
		<0.862, -0.238, -0.341> <0.848, -0.257, -0.341> <0.841, -0.287, -0.333> <0.831, -0.308, -0.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.921, -0.193, -0.327> <0.903, -0.206, -0.331> <0.876, -0.220, -0.341> <0.862, -0.238, -0.341> 
		<0.921, -0.193, -0.327> <0.903, -0.207, -0.331> <0.876, -0.221, -0.341> <0.863, -0.239, -0.341> 
		<0.921, -0.193, -0.327> <0.904, -0.207, -0.331> <0.877, -0.221, -0.341> <0.864, -0.239, -0.341> 
		<0.921, -0.193, -0.327> <0.904, -0.207, -0.331> <0.877, -0.222, -0.340> <0.864, -0.240, -0.340> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.921, -0.193, -0.327> <0.904, -0.207, -0.331> <0.877, -0.222, -0.340> <0.864, -0.240, -0.340> 
		<0.921, -0.193, -0.327> <0.904, -0.207, -0.331> <0.878, -0.222, -0.340> <0.864, -0.240, -0.340> 
		<0.921, -0.193, -0.327> <0.904, -0.208, -0.330> <0.878, -0.222, -0.339> <0.865, -0.241, -0.339> 
		<0.921, -0.193, -0.327> <0.904, -0.208, -0.330> <0.878, -0.222, -0.339> <0.865, -0.241, -0.338> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.921, -0.193, -0.327> <0.904, -0.208, -0.330> <0.878, -0.222, -0.339> <0.865, -0.241, -0.338> 
		<0.921, -0.193, -0.326> <0.904, -0.208, -0.330> <0.878, -0.223, -0.338> <0.865, -0.241, -0.338> 
		<0.921, -0.193, -0.326> <0.904, -0.208, -0.329> <0.878, -0.222, -0.337> <0.865, -0.241, -0.336> 
		<0.921, -0.193, -0.326> <0.904, -0.207, -0.329> <0.878, -0.222, -0.337> <0.865, -0.240, -0.336> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.921, -0.193, -0.326> <0.904, -0.207, -0.329> <0.878, -0.222, -0.337> <0.865, -0.240, -0.336> 
		<0.921, -0.193, -0.326> <0.904, -0.207, -0.329> <0.877, -0.222, -0.336> <0.864, -0.240, -0.335> 
		<0.921, -0.193, -0.326> <0.904, -0.207, -0.328> <0.877, -0.222, -0.336> <0.864, -0.239, -0.335> 
		<0.921, -0.193, -0.326> <0.904, -0.207, -0.328> <0.876, -0.221, -0.336> <0.863, -0.239, -0.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.921, -0.193, -0.326> <0.904, -0.207, -0.328> <0.876, -0.221, -0.336> <0.863, -0.239, -0.335> 
		<0.921, -0.193, -0.326> <0.903, -0.207, -0.328> <0.876, -0.221, -0.336> <0.862, -0.239, -0.334> 
		<0.921, -0.193, -0.326> <0.903, -0.206, -0.329> <0.876, -0.220, -0.336> <0.862, -0.238, -0.335> 
		<0.920, -0.193, -0.326> <0.903, -0.206, -0.329> <0.875, -0.220, -0.336> <0.861, -0.237, -0.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.920, -0.193, -0.326> <0.903, -0.206, -0.329> <0.875, -0.220, -0.336> <0.861, -0.237, -0.335> 
		<0.920, -0.193, -0.326> <0.903, -0.206, -0.329> <0.875, -0.220, -0.337> <0.861, -0.237, -0.335> 
		<0.920, -0.193, -0.326> <0.902, -0.206, -0.329> <0.875, -0.219, -0.337> <0.860, -0.237, -0.336> 
		<0.920, -0.193, -0.326> <0.902, -0.206, -0.330> <0.874, -0.219, -0.338> <0.860, -0.237, -0.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.862, -0.238, -0.341> <0.848, -0.257, -0.341> <0.841, -0.287, -0.333> <0.831, -0.308, -0.329> 
		<0.863, -0.239, -0.341> <0.848, -0.257, -0.341> <0.842, -0.288, -0.333> <0.832, -0.309, -0.330> 
		<0.864, -0.239, -0.341> <0.850, -0.258, -0.341> <0.843, -0.289, -0.333> <0.834, -0.311, -0.329> 
		<0.864, -0.240, -0.340> <0.850, -0.259, -0.341> <0.844, -0.290, -0.332> <0.835, -0.311, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.864, -0.240, -0.340> <0.850, -0.259, -0.341> <0.844, -0.290, -0.332> <0.835, -0.311, -0.328> 
		<0.864, -0.240, -0.340> <0.851, -0.259, -0.340> <0.845, -0.291, -0.331> <0.836, -0.312, -0.328> 
		<0.865, -0.241, -0.339> <0.851, -0.260, -0.339> <0.845, -0.291, -0.330> <0.837, -0.313, -0.326> 
		<0.865, -0.241, -0.338> <0.851, -0.260, -0.338> <0.845, -0.291, -0.329> <0.837, -0.313, -0.325> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.865, -0.241, -0.338> <0.851, -0.260, -0.338> <0.845, -0.291, -0.329> <0.837, -0.313, -0.325> 
		<0.865, -0.241, -0.338> <0.852, -0.260, -0.337> <0.846, -0.291, -0.327> <0.837, -0.313, -0.323> 
		<0.865, -0.241, -0.336> <0.851, -0.260, -0.335> <0.845, -0.291, -0.326> <0.837, -0.313, -0.321> 
		<0.865, -0.240, -0.336> <0.851, -0.260, -0.335> <0.845, -0.291, -0.325> <0.836, -0.312, -0.320> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.865, -0.240, -0.336> <0.851, -0.260, -0.335> <0.845, -0.291, -0.325> <0.836, -0.312, -0.320> 
		<0.864, -0.240, -0.335> <0.851, -0.259, -0.334> <0.844, -0.290, -0.324> <0.835, -0.312, -0.319> 
		<0.864, -0.239, -0.335> <0.849, -0.258, -0.333> <0.843, -0.289, -0.323> <0.834, -0.311, -0.318> 
		<0.863, -0.239, -0.335> <0.849, -0.258, -0.333> <0.842, -0.289, -0.323> <0.833, -0.310, -0.317> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.863, -0.239, -0.335> <0.849, -0.258, -0.333> <0.842, -0.289, -0.323> <0.833, -0.310, -0.317> 
		<0.862, -0.239, -0.334> <0.848, -0.257, -0.333> <0.841, -0.288, -0.322> <0.832, -0.309, -0.317> 
		<0.862, -0.238, -0.335> <0.847, -0.256, -0.333> <0.840, -0.287, -0.323> <0.830, -0.308, -0.318> 
		<0.861, -0.237, -0.335> <0.847, -0.256, -0.334> <0.839, -0.286, -0.323> <0.830, -0.307, -0.318> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.861, -0.237, -0.335> <0.847, -0.256, -0.334> <0.839, -0.286, -0.323> <0.830, -0.307, -0.318> 
		<0.861, -0.237, -0.335> <0.846, -0.255, -0.334> <0.838, -0.285, -0.324> <0.829, -0.306, -0.319> 
		<0.860, -0.237, -0.336> <0.845, -0.255, -0.336> <0.838, -0.285, -0.325> <0.828, -0.305, -0.321> 
		<0.860, -0.237, -0.337> <0.845, -0.255, -0.336> <0.837, -0.285, -0.327> <0.828, -0.305, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.718, -0.133, -0.297> <0.718, -0.133, -0.297> <0.718, -0.133, -0.297> <0.718, -0.133, -0.297> 
		<0.729, -0.155, -0.294> <0.729, -0.155, -0.294> <0.729, -0.155, -0.295> <0.729, -0.155, -0.295> 
		<0.748, -0.183, -0.287> <0.748, -0.183, -0.288> <0.748, -0.183, -0.288> <0.747, -0.183, -0.289> 
		<0.755, -0.207, -0.288> <0.755, -0.207, -0.288> <0.754, -0.207, -0.289> <0.754, -0.207, -0.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.718, -0.133, -0.297> <0.729, -0.155, -0.294> <0.748, -0.183, -0.287> <0.755, -0.207, -0.288> 
		<0.718, -0.133, -0.296> <0.729, -0.155, -0.294> <0.748, -0.183, -0.286> <0.755, -0.207, -0.287> 
		<0.718, -0.133, -0.296> <0.729, -0.155, -0.293> <0.748, -0.183, -0.286> <0.754, -0.207, -0.286> 
		<0.718, -0.133, -0.296> <0.729, -0.156, -0.293> <0.747, -0.183, -0.285> <0.754, -0.208, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.755, -0.207, -0.288> <0.755, -0.207, -0.288> <0.754, -0.207, -0.289> <0.754, -0.207, -0.290> 
		<0.762, -0.233, -0.288> <0.762, -0.233, -0.289> <0.761, -0.233, -0.291> <0.761, -0.233, -0.291> 
		<0.761, -0.269, -0.296> <0.761, -0.269, -0.298> <0.761, -0.269, -0.299> <0.760, -0.269, -0.300> 
		<0.764, -0.296, -0.300> <0.764, -0.296, -0.301> <0.763, -0.296, -0.303> <0.762, -0.295, -0.304> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.755, -0.207, -0.288> <0.762, -0.233, -0.288> <0.761, -0.269, -0.296> <0.764, -0.296, -0.300> 
		<0.755, -0.207, -0.287> <0.762, -0.233, -0.287> <0.761, -0.269, -0.295> <0.764, -0.296, -0.299> 
		<0.754, -0.207, -0.286> <0.761, -0.234, -0.286> <0.761, -0.270, -0.294> <0.763, -0.296, -0.297> 
		<0.754, -0.208, -0.285> <0.761, -0.234, -0.285> <0.760, -0.270, -0.293> <0.762, -0.297, -0.296> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.718, -0.133, -0.296> <0.729, -0.156, -0.293> <0.747, -0.183, -0.285> <0.754, -0.208, -0.285> 
		<0.718, -0.133, -0.296> <0.728, -0.156, -0.293> <0.747, -0.184, -0.285> <0.753, -0.208, -0.285> 
		<0.717, -0.133, -0.296> <0.728, -0.156, -0.292> <0.746, -0.184, -0.285> <0.752, -0.208, -0.284> 
		<0.717, -0.133, -0.296> <0.728, -0.156, -0.292> <0.745, -0.184, -0.285> <0.751, -0.208, -0.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.717, -0.133, -0.296> <0.728, -0.156, -0.292> <0.745, -0.184, -0.285> <0.751, -0.208, -0.284> 
		<0.717, -0.133, -0.296> <0.727, -0.156, -0.292> <0.745, -0.184, -0.285> <0.751, -0.208, -0.284> 
		<0.717, -0.133, -0.296> <0.727, -0.156, -0.293> <0.744, -0.184, -0.285> <0.750, -0.208, -0.285> 
		<0.717, -0.133, -0.296> <0.726, -0.156, -0.293> <0.744, -0.184, -0.285> <0.749, -0.208, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.717, -0.133, -0.296> <0.726, -0.156, -0.293> <0.744, -0.184, -0.285> <0.749, -0.208, -0.285> 
		<0.717, -0.133, -0.296> <0.726, -0.156, -0.293> <0.743, -0.184, -0.286> <0.749, -0.208, -0.286> 
		<0.717, -0.133, -0.296> <0.726, -0.156, -0.294> <0.743, -0.184, -0.286> <0.748, -0.208, -0.287> 
		<0.717, -0.133, -0.297> <0.726, -0.156, -0.294> <0.743, -0.184, -0.287> <0.748, -0.208, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.717, -0.133, -0.297> <0.726, -0.156, -0.294> <0.743, -0.184, -0.287> <0.748, -0.208, -0.288> 
		<0.717, -0.133, -0.297> <0.726, -0.156, -0.294> <0.743, -0.184, -0.288> <0.748, -0.208, -0.288> 
		<0.717, -0.133, -0.297> <0.726, -0.155, -0.295> <0.743, -0.184, -0.288> <0.749, -0.207, -0.289> 
		<0.717, -0.133, -0.297> <0.726, -0.155, -0.295> <0.744, -0.184, -0.289> <0.749, -0.207, -0.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.717, -0.133, -0.297> <0.726, -0.155, -0.295> <0.744, -0.184, -0.289> <0.749, -0.207, -0.290> 
		<0.717, -0.133, -0.297> <0.727, -0.155, -0.295> <0.744, -0.183, -0.289> <0.750, -0.207, -0.290> 
		<0.717, -0.133, -0.297> <0.727, -0.155, -0.295> <0.745, -0.183, -0.290> <0.751, -0.207, -0.291> 
		<0.717, -0.133, -0.297> <0.728, -0.155, -0.295> <0.745, -0.183, -0.290> <0.751, -0.207, -0.291> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.717, -0.133, -0.297> <0.728, -0.155, -0.295> <0.745, -0.183, -0.290> <0.751, -0.207, -0.291> 
		<0.717, -0.133, -0.297> <0.728, -0.155, -0.295> <0.746, -0.183, -0.290> <0.752, -0.207, -0.291> 
		<0.718, -0.133, -0.297> <0.728, -0.155, -0.295> <0.747, -0.183, -0.289> <0.753, -0.207, -0.290> 
		<0.718, -0.133, -0.297> <0.729, -0.155, -0.295> <0.747, -0.183, -0.289> <0.754, -0.207, -0.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.754, -0.208, -0.285> <0.761, -0.234, -0.285> <0.760, -0.270, -0.293> <0.762, -0.297, -0.296> 
		<0.753, -0.208, -0.285> <0.760, -0.234, -0.285> <0.759, -0.270, -0.292> <0.761, -0.297, -0.295> 
		<0.752, -0.208, -0.284> <0.759, -0.234, -0.284> <0.757, -0.270, -0.291> <0.759, -0.297, -0.294> 
		<0.751, -0.208, -0.284> <0.758, -0.234, -0.284> <0.756, -0.270, -0.291> <0.758, -0.297, -0.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.751, -0.208, -0.284> <0.758, -0.234, -0.284> <0.756, -0.270, -0.291> <0.758, -0.297, -0.294> 
		<0.751, -0.208, -0.284> <0.757, -0.234, -0.284> <0.755, -0.270, -0.291> <0.757, -0.297, -0.294> 
		<0.750, -0.208, -0.285> <0.756, -0.234, -0.285> <0.753, -0.271, -0.292> <0.755, -0.297, -0.295> 
		<0.749, -0.208, -0.285> <0.755, -0.234, -0.285> <0.752, -0.270, -0.293> <0.754, -0.297, -0.296> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.749, -0.208, -0.285> <0.755, -0.234, -0.285> <0.752, -0.270, -0.293> <0.754, -0.297, -0.296> 
		<0.749, -0.208, -0.286> <0.755, -0.234, -0.286> <0.751, -0.270, -0.294> <0.753, -0.297, -0.297> 
		<0.748, -0.208, -0.287> <0.754, -0.234, -0.288> <0.751, -0.270, -0.295> <0.752, -0.297, -0.299> 
		<0.748, -0.208, -0.288> <0.754, -0.234, -0.288> <0.751, -0.270, -0.296> <0.752, -0.297, -0.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.748, -0.208, -0.288> <0.754, -0.234, -0.288> <0.751, -0.270, -0.296> <0.752, -0.297, -0.300> 
		<0.748, -0.208, -0.288> <0.754, -0.234, -0.289> <0.751, -0.270, -0.298> <0.752, -0.297, -0.302> 
		<0.749, -0.207, -0.289> <0.755, -0.234, -0.291> <0.751, -0.270, -0.299> <0.753, -0.296, -0.304> 
		<0.749, -0.207, -0.290> <0.755, -0.234, -0.291> <0.752, -0.269, -0.300> <0.754, -0.296, -0.304> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.749, -0.207, -0.290> <0.755, -0.234, -0.291> <0.752, -0.269, -0.300> <0.754, -0.296, -0.304> 
		<0.750, -0.207, -0.290> <0.756, -0.233, -0.292> <0.753, -0.269, -0.301> <0.755, -0.296, -0.305> 
		<0.751, -0.207, -0.291> <0.757, -0.233, -0.292> <0.755, -0.269, -0.302> <0.757, -0.296, -0.306> 
		<0.751, -0.207, -0.291> <0.758, -0.233, -0.292> <0.756, -0.269, -0.302> <0.758, -0.296, -0.306> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.751, -0.207, -0.291> <0.758, -0.233, -0.292> <0.756, -0.269, -0.302> <0.758, -0.296, -0.306> 
		<0.752, -0.207, -0.291> <0.759, -0.233, -0.292> <0.757, -0.269, -0.302> <0.759, -0.295, -0.306> 
		<0.753, -0.207, -0.290> <0.760, -0.233, -0.292> <0.759, -0.269, -0.301> <0.761, -0.295, -0.305> 
		<0.754, -0.207, -0.290> <0.761, -0.233, -0.291> <0.760, -0.269, -0.300> <0.762, -0.295, -0.304> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.806, -0.127, -0.277> <0.806, -0.127, -0.277> <0.806, -0.127, -0.277> <0.805, -0.127, -0.277> 
		<0.806, -0.150, -0.283> <0.806, -0.150, -0.283> <0.806, -0.150, -0.284> <0.806, -0.150, -0.284> 
		<0.807, -0.181, -0.295> <0.807, -0.181, -0.295> <0.807, -0.181, -0.296> <0.807, -0.181, -0.296> 
		<0.808, -0.205, -0.298> <0.808, -0.205, -0.299> <0.808, -0.205, -0.300> <0.807, -0.205, -0.301> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.806, -0.127, -0.277> <0.806, -0.150, -0.283> <0.807, -0.181, -0.295> <0.808, -0.205, -0.298> 
		<0.806, -0.127, -0.277> <0.806, -0.150, -0.283> <0.807, -0.181, -0.294> <0.808, -0.205, -0.298> 
		<0.806, -0.127, -0.276> <0.806, -0.150, -0.282> <0.807, -0.181, -0.294> <0.808, -0.205, -0.297> 
		<0.805, -0.127, -0.276> <0.806, -0.150, -0.282> <0.807, -0.181, -0.293> <0.807, -0.205, -0.296> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, -0.205, -0.298> <0.808, -0.205, -0.299> <0.808, -0.205, -0.300> <0.807, -0.205, -0.301> 
		<0.809, -0.232, -0.303> <0.809, -0.232, -0.303> <0.808, -0.232, -0.305> <0.808, -0.232, -0.305> 
		<0.810, -0.268, -0.301> <0.810, -0.268, -0.303> <0.810, -0.268, -0.304> <0.809, -0.268, -0.305> 
		<0.811, -0.295, -0.303> <0.811, -0.295, -0.304> <0.810, -0.295, -0.306> <0.809, -0.295, -0.307> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, -0.205, -0.298> <0.809, -0.232, -0.303> <0.810, -0.268, -0.301> <0.811, -0.295, -0.303> 
		<0.808, -0.205, -0.298> <0.809, -0.232, -0.302> <0.810, -0.268, -0.300> <0.811, -0.295, -0.301> 
		<0.808, -0.205, -0.297> <0.808, -0.232, -0.300> <0.810, -0.268, -0.299> <0.810, -0.295, -0.299> 
		<0.807, -0.205, -0.296> <0.808, -0.232, -0.300> <0.809, -0.268, -0.298> <0.809, -0.295, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.805, -0.127, -0.276> <0.806, -0.150, -0.282> <0.807, -0.181, -0.293> <0.807, -0.205, -0.296> 
		<0.805, -0.127, -0.276> <0.806, -0.150, -0.282> <0.806, -0.181, -0.292> <0.807, -0.205, -0.296> 
		<0.805, -0.127, -0.276> <0.805, -0.150, -0.282> <0.806, -0.181, -0.292> <0.806, -0.205, -0.295> 
		<0.805, -0.127, -0.276> <0.805, -0.150, -0.282> <0.805, -0.181, -0.292> <0.805, -0.205, -0.295> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.805, -0.127, -0.276> <0.805, -0.150, -0.282> <0.805, -0.181, -0.292> <0.805, -0.205, -0.295> 
		<0.805, -0.127, -0.276> <0.805, -0.150, -0.282> <0.804, -0.181, -0.292> <0.804, -0.205, -0.295> 
		<0.805, -0.127, -0.276> <0.804, -0.150, -0.282> <0.804, -0.181, -0.292> <0.803, -0.205, -0.296> 
		<0.804, -0.127, -0.276> <0.804, -0.150, -0.282> <0.803, -0.181, -0.293> <0.803, -0.205, -0.296> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.804, -0.127, -0.276> <0.804, -0.150, -0.282> <0.803, -0.181, -0.293> <0.803, -0.205, -0.296> 
		<0.804, -0.127, -0.276> <0.804, -0.150, -0.282> <0.803, -0.181, -0.294> <0.802, -0.205, -0.297> 
		<0.804, -0.127, -0.277> <0.803, -0.150, -0.283> <0.802, -0.181, -0.294> <0.802, -0.205, -0.298> 
		<0.804, -0.127, -0.277> <0.803, -0.150, -0.283> <0.802, -0.181, -0.295> <0.802, -0.205, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.804, -0.127, -0.277> <0.803, -0.150, -0.283> <0.802, -0.181, -0.295> <0.802, -0.205, -0.298> 
		<0.804, -0.127, -0.277> <0.803, -0.150, -0.283> <0.802, -0.181, -0.295> <0.802, -0.205, -0.299> 
		<0.804, -0.127, -0.277> <0.804, -0.150, -0.284> <0.803, -0.181, -0.296> <0.802, -0.205, -0.300> 
		<0.804, -0.127, -0.277> <0.804, -0.150, -0.284> <0.803, -0.181, -0.296> <0.803, -0.205, -0.301> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.804, -0.127, -0.277> <0.804, -0.150, -0.284> <0.803, -0.181, -0.296> <0.803, -0.205, -0.301> 
		<0.805, -0.127, -0.277> <0.804, -0.150, -0.284> <0.804, -0.181, -0.297> <0.803, -0.205, -0.301> 
		<0.805, -0.127, -0.278> <0.805, -0.150, -0.285> <0.804, -0.181, -0.297> <0.804, -0.205, -0.302> 
		<0.805, -0.127, -0.278> <0.805, -0.150, -0.285> <0.805, -0.181, -0.297> <0.805, -0.205, -0.302> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.805, -0.127, -0.278> <0.805, -0.150, -0.285> <0.805, -0.181, -0.297> <0.805, -0.205, -0.302> 
		<0.805, -0.127, -0.278> <0.805, -0.150, -0.285> <0.806, -0.181, -0.297> <0.806, -0.205, -0.302> 
		<0.805, -0.127, -0.277> <0.806, -0.150, -0.284> <0.806, -0.181, -0.297> <0.807, -0.205, -0.301> 
		<0.805, -0.127, -0.277> <0.806, -0.150, -0.284> <0.807, -0.181, -0.296> <0.807, -0.205, -0.301> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.807, -0.205, -0.296> <0.808, -0.232, -0.300> <0.809, -0.268, -0.298> <0.809, -0.295, -0.298> 
		<0.807, -0.205, -0.296> <0.807, -0.232, -0.299> <0.808, -0.268, -0.297> <0.808, -0.295, -0.297> 
		<0.806, -0.205, -0.295> <0.806, -0.232, -0.298> <0.806, -0.268, -0.296> <0.806, -0.295, -0.297> 
		<0.805, -0.205, -0.295> <0.805, -0.232, -0.298> <0.805, -0.268, -0.296> <0.805, -0.295, -0.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.805, -0.205, -0.295> <0.805, -0.232, -0.298> <0.805, -0.268, -0.296> <0.805, -0.295, -0.297> 
		<0.804, -0.205, -0.295> <0.804, -0.232, -0.298> <0.804, -0.268, -0.296> <0.804, -0.295, -0.297> 
		<0.803, -0.205, -0.296> <0.803, -0.232, -0.299> <0.802, -0.268, -0.297> <0.802, -0.295, -0.297> 
		<0.803, -0.205, -0.296> <0.802, -0.232, -0.300> <0.801, -0.268, -0.298> <0.801, -0.295, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.803, -0.205, -0.296> <0.802, -0.232, -0.300> <0.801, -0.268, -0.298> <0.801, -0.295, -0.298> 
		<0.802, -0.205, -0.297> <0.802, -0.232, -0.300> <0.800, -0.268, -0.299> <0.800, -0.295, -0.299> 
		<0.802, -0.205, -0.298> <0.801, -0.232, -0.302> <0.800, -0.268, -0.300> <0.799, -0.295, -0.301> 
		<0.802, -0.205, -0.298> <0.801, -0.232, -0.303> <0.800, -0.268, -0.301> <0.799, -0.295, -0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.802, -0.205, -0.298> <0.801, -0.232, -0.303> <0.800, -0.268, -0.301> <0.799, -0.295, -0.303> 
		<0.802, -0.205, -0.299> <0.801, -0.232, -0.303> <0.800, -0.268, -0.303> <0.799, -0.295, -0.304> 
		<0.802, -0.205, -0.300> <0.802, -0.232, -0.305> <0.800, -0.268, -0.304> <0.800, -0.295, -0.306> 
		<0.803, -0.205, -0.301> <0.802, -0.232, -0.305> <0.801, -0.268, -0.305> <0.801, -0.295, -0.307> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.803, -0.205, -0.301> <0.802, -0.232, -0.305> <0.801, -0.268, -0.305> <0.801, -0.295, -0.307> 
		<0.803, -0.205, -0.301> <0.803, -0.232, -0.306> <0.802, -0.268, -0.306> <0.802, -0.295, -0.308> 
		<0.804, -0.205, -0.302> <0.804, -0.232, -0.307> <0.804, -0.268, -0.307> <0.804, -0.295, -0.309> 
		<0.805, -0.205, -0.302> <0.805, -0.232, -0.307> <0.805, -0.268, -0.307> <0.805, -0.295, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.805, -0.205, -0.302> <0.805, -0.232, -0.307> <0.805, -0.268, -0.307> <0.805, -0.295, -0.309> 
		<0.806, -0.205, -0.302> <0.806, -0.232, -0.307> <0.806, -0.268, -0.307> <0.806, -0.295, -0.309> 
		<0.807, -0.205, -0.301> <0.807, -0.232, -0.306> <0.808, -0.268, -0.306> <0.808, -0.295, -0.308> 
		<0.807, -0.205, -0.301> <0.808, -0.232, -0.305> <0.809, -0.268, -0.305> <0.809, -0.295, -0.307> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.815, -0.137, -0.403> <0.815, -0.137, -0.403> <0.815, -0.137, -0.403> <0.816, -0.137, -0.403> 
		<0.812, -0.161, -0.395> <0.813, -0.161, -0.395> <0.813, -0.161, -0.395> <0.813, -0.161, -0.395> 
		<0.808, -0.193, -0.383> <0.809, -0.193, -0.383> <0.809, -0.193, -0.383> <0.810, -0.193, -0.383> 
		<0.806, -0.218, -0.377> <0.807, -0.218, -0.377> <0.808, -0.218, -0.377> <0.809, -0.218, -0.377> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.815, -0.137, -0.403> <0.812, -0.161, -0.395> <0.808, -0.193, -0.383> <0.806, -0.218, -0.377> 
		<0.815, -0.137, -0.403> <0.812, -0.161, -0.395> <0.807, -0.193, -0.384> <0.806, -0.218, -0.377> 
		<0.815, -0.137, -0.404> <0.812, -0.161, -0.396> <0.807, -0.193, -0.384> <0.805, -0.218, -0.378> 
		<0.815, -0.137, -0.404> <0.812, -0.162, -0.396> <0.807, -0.193, -0.385> <0.805, -0.218, -0.379> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.806, -0.218, -0.377> <0.807, -0.218, -0.377> <0.808, -0.218, -0.377> <0.809, -0.218, -0.377> 
		<0.804, -0.244, -0.371> <0.805, -0.244, -0.370> <0.807, -0.244, -0.370> <0.807, -0.244, -0.370> 
		<0.804, -0.280, -0.366> <0.805, -0.280, -0.365> <0.806, -0.280, -0.365> <0.808, -0.280, -0.366> 
		<0.803, -0.307, -0.361> <0.804, -0.307, -0.361> <0.806, -0.307, -0.361> <0.807, -0.307, -0.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.806, -0.218, -0.377> <0.804, -0.244, -0.371> <0.804, -0.280, -0.366> <0.803, -0.307, -0.361> 
		<0.806, -0.218, -0.377> <0.804, -0.244, -0.371> <0.802, -0.280, -0.367> <0.801, -0.307, -0.362> 
		<0.805, -0.218, -0.378> <0.802, -0.244, -0.372> <0.801, -0.280, -0.368> <0.800, -0.307, -0.363> 
		<0.805, -0.218, -0.379> <0.802, -0.245, -0.373> <0.801, -0.281, -0.369> <0.799, -0.307, -0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.815, -0.137, -0.404> <0.812, -0.162, -0.396> <0.807, -0.193, -0.385> <0.805, -0.218, -0.379> 
		<0.815, -0.137, -0.404> <0.812, -0.162, -0.396> <0.806, -0.193, -0.385> <0.804, -0.218, -0.380> 
		<0.815, -0.137, -0.404> <0.812, -0.162, -0.397> <0.807, -0.193, -0.386> <0.804, -0.218, -0.381> 
		<0.815, -0.137, -0.404> <0.812, -0.162, -0.397> <0.807, -0.194, -0.386> <0.805, -0.218, -0.381> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.815, -0.137, -0.404> <0.812, -0.162, -0.397> <0.807, -0.194, -0.386> <0.805, -0.218, -0.381> 
		<0.815, -0.137, -0.404> <0.812, -0.162, -0.398> <0.807, -0.194, -0.387> <0.805, -0.218, -0.382> 
		<0.815, -0.137, -0.405> <0.812, -0.162, -0.398> <0.808, -0.194, -0.387> <0.806, -0.219, -0.383> 
		<0.815, -0.137, -0.405> <0.812, -0.162, -0.398> <0.808, -0.194, -0.388> <0.806, -0.219, -0.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.815, -0.137, -0.405> <0.812, -0.162, -0.398> <0.808, -0.194, -0.388> <0.806, -0.219, -0.383> 
		<0.815, -0.137, -0.405> <0.813, -0.162, -0.398> <0.809, -0.194, -0.388> <0.807, -0.219, -0.383> 
		<0.815, -0.137, -0.405> <0.813, -0.162, -0.398> <0.809, -0.194, -0.388> <0.808, -0.219, -0.383> 
		<0.816, -0.137, -0.405> <0.814, -0.162, -0.398> <0.810, -0.194, -0.388> <0.809, -0.219, -0.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.816, -0.137, -0.405> <0.814, -0.162, -0.398> <0.810, -0.194, -0.388> <0.809, -0.219, -0.383> 
		<0.816, -0.137, -0.405> <0.814, -0.162, -0.398> <0.811, -0.194, -0.387> <0.810, -0.219, -0.383> 
		<0.816, -0.137, -0.404> <0.814, -0.162, -0.397> <0.811, -0.194, -0.387> <0.810, -0.218, -0.382> 
		<0.816, -0.137, -0.404> <0.814, -0.162, -0.397> <0.811, -0.194, -0.386> <0.811, -0.218, -0.381> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.816, -0.137, -0.404> <0.814, -0.162, -0.397> <0.811, -0.194, -0.386> <0.811, -0.218, -0.381> 
		<0.816, -0.137, -0.404> <0.814, -0.162, -0.397> <0.812, -0.193, -0.386> <0.811, -0.218, -0.380> 
		<0.816, -0.137, -0.404> <0.814, -0.162, -0.396> <0.812, -0.193, -0.385> <0.811, -0.218, -0.379> 
		<0.816, -0.137, -0.404> <0.814, -0.161, -0.396> <0.811, -0.193, -0.384> <0.810, -0.218, -0.379> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.816, -0.137, -0.404> <0.814, -0.161, -0.396> <0.811, -0.193, -0.384> <0.810, -0.218, -0.379> 
		<0.816, -0.137, -0.403> <0.814, -0.161, -0.396> <0.811, -0.193, -0.384> <0.810, -0.218, -0.378> 
		<0.816, -0.137, -0.403> <0.814, -0.161, -0.395> <0.811, -0.193, -0.383> <0.809, -0.218, -0.377> 
		<0.816, -0.137, -0.403> <0.813, -0.161, -0.395> <0.810, -0.193, -0.383> <0.809, -0.218, -0.377> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.805, -0.218, -0.379> <0.802, -0.245, -0.373> <0.801, -0.281, -0.369> <0.799, -0.307, -0.365> 
		<0.804, -0.218, -0.380> <0.802, -0.245, -0.374> <0.801, -0.281, -0.370> <0.799, -0.307, -0.366> 
		<0.804, -0.218, -0.381> <0.802, -0.245, -0.375> <0.801, -0.281, -0.372> <0.799, -0.308, -0.368> 
		<0.805, -0.218, -0.381> <0.802, -0.245, -0.376> <0.801, -0.281, -0.373> <0.800, -0.308, -0.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.805, -0.218, -0.381> <0.802, -0.245, -0.376> <0.801, -0.281, -0.373> <0.800, -0.308, -0.369> 
		<0.805, -0.218, -0.382> <0.803, -0.245, -0.377> <0.802, -0.281, -0.374> <0.800, -0.308, -0.371> 
		<0.806, -0.219, -0.383> <0.804, -0.245, -0.378> <0.803, -0.281, -0.375> <0.802, -0.308, -0.372> 
		<0.806, -0.219, -0.383> <0.805, -0.245, -0.378> <0.804, -0.281, -0.376> <0.803, -0.308, -0.373> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.806, -0.219, -0.383> <0.805, -0.245, -0.378> <0.804, -0.281, -0.376> <0.803, -0.308, -0.373> 
		<0.807, -0.219, -0.383> <0.805, -0.245, -0.378> <0.806, -0.281, -0.376> <0.805, -0.308, -0.373> 
		<0.808, -0.219, -0.383> <0.807, -0.245, -0.378> <0.807, -0.281, -0.376> <0.807, -0.308, -0.373> 
		<0.809, -0.219, -0.383> <0.808, -0.245, -0.378> <0.808, -0.281, -0.375> <0.808, -0.308, -0.372> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.809, -0.219, -0.383> <0.808, -0.245, -0.378> <0.808, -0.281, -0.375> <0.808, -0.308, -0.372> 
		<0.810, -0.219, -0.383> <0.808, -0.245, -0.378> <0.809, -0.281, -0.375> <0.809, -0.308, -0.372> 
		<0.810, -0.218, -0.382> <0.810, -0.245, -0.376> <0.810, -0.281, -0.374> <0.811, -0.308, -0.370> 
		<0.811, -0.218, -0.381> <0.810, -0.245, -0.376> <0.811, -0.281, -0.373> <0.811, -0.308, -0.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.811, -0.218, -0.381> <0.810, -0.245, -0.376> <0.811, -0.281, -0.373> <0.811, -0.308, -0.369> 
		<0.811, -0.218, -0.380> <0.810, -0.245, -0.375> <0.811, -0.281, -0.371> <0.811, -0.308, -0.368> 
		<0.811, -0.218, -0.379> <0.810, -0.245, -0.373> <0.811, -0.281, -0.370> <0.811, -0.307, -0.365> 
		<0.810, -0.218, -0.379> <0.810, -0.245, -0.373> <0.811, -0.281, -0.369> <0.811, -0.307, -0.364> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.810, -0.218, -0.379> <0.810, -0.245, -0.373> <0.811, -0.281, -0.369> <0.811, -0.307, -0.364> 
		<0.810, -0.218, -0.378> <0.809, -0.244, -0.372> <0.810, -0.280, -0.367> <0.810, -0.307, -0.363> 
		<0.809, -0.218, -0.377> <0.808, -0.244, -0.371> <0.809, -0.280, -0.366> <0.809, -0.307, -0.362> 
		<0.809, -0.218, -0.377> <0.807, -0.244, -0.370> <0.808, -0.280, -0.366> <0.807, -0.307, -0.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.294, -0.172> <0.779, -0.294, -0.172> <0.779, -0.294, -0.172> <0.779, -0.294, -0.173> 
		<0.780, -0.274, -0.191> <0.780, -0.274, -0.191> <0.780, -0.274, -0.192> <0.780, -0.274, -0.192> 
		<0.781, -0.225, -0.208> <0.781, -0.224, -0.208> <0.781, -0.224, -0.209> <0.780, -0.224, -0.209> 
		<0.782, -0.227, -0.235> <0.782, -0.227, -0.236> <0.782, -0.226, -0.237> <0.781, -0.226, -0.237> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.294, -0.172> <0.780, -0.274, -0.191> <0.781, -0.225, -0.208> <0.782, -0.227, -0.235> 
		<0.779, -0.295, -0.172> <0.780, -0.274, -0.191> <0.781, -0.225, -0.207> <0.782, -0.228, -0.235> 
		<0.779, -0.295, -0.172> <0.780, -0.275, -0.190> <0.781, -0.225, -0.207> <0.782, -0.228, -0.234> 
		<0.779, -0.295, -0.172> <0.780, -0.275, -0.190> <0.780, -0.226, -0.206> <0.781, -0.228, -0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.782, -0.227, -0.235> <0.782, -0.227, -0.236> <0.782, -0.226, -0.237> <0.781, -0.226, -0.237> 
		<0.783, -0.229, -0.262> <0.783, -0.229, -0.263> <0.782, -0.228, -0.264> <0.782, -0.228, -0.264> 
		<0.784, -0.281, -0.269> <0.784, -0.280, -0.270> <0.783, -0.279, -0.271> <0.782, -0.279, -0.272> 
		<0.785, -0.304, -0.283> <0.785, -0.303, -0.284> <0.784, -0.302, -0.286> <0.783, -0.301, -0.287> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.782, -0.227, -0.235> <0.783, -0.229, -0.262> <0.784, -0.281, -0.269> <0.785, -0.304, -0.283> 
		<0.782, -0.228, -0.235> <0.783, -0.230, -0.262> <0.784, -0.281, -0.268> <0.785, -0.304, -0.282> 
		<0.782, -0.228, -0.234> <0.783, -0.231, -0.261> <0.783, -0.282, -0.267> <0.784, -0.305, -0.280> 
		<0.781, -0.228, -0.234> <0.782, -0.231, -0.260> <0.782, -0.283, -0.266> <0.783, -0.306, -0.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.295, -0.172> <0.780, -0.275, -0.190> <0.780, -0.226, -0.206> <0.781, -0.228, -0.234> 
		<0.779, -0.295, -0.172> <0.780, -0.275, -0.190> <0.780, -0.226, -0.206> <0.781, -0.229, -0.233> 
		<0.779, -0.295, -0.171> <0.779, -0.275, -0.190> <0.779, -0.226, -0.206> <0.779, -0.229, -0.233> 
		<0.779, -0.295, -0.171> <0.779, -0.275, -0.190> <0.779, -0.226, -0.206> <0.779, -0.229, -0.233> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.295, -0.171> <0.779, -0.275, -0.190> <0.779, -0.226, -0.206> <0.779, -0.229, -0.233> 
		<0.779, -0.295, -0.171> <0.779, -0.275, -0.190> <0.778, -0.226, -0.206> <0.778, -0.229, -0.233> 
		<0.778, -0.295, -0.172> <0.778, -0.275, -0.190> <0.778, -0.226, -0.206> <0.777, -0.229, -0.233> 
		<0.778, -0.295, -0.172> <0.778, -0.275, -0.190> <0.777, -0.226, -0.206> <0.776, -0.228, -0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.778, -0.295, -0.172> <0.778, -0.275, -0.190> <0.777, -0.226, -0.206> <0.776, -0.228, -0.234> 
		<0.778, -0.295, -0.172> <0.778, -0.275, -0.190> <0.777, -0.225, -0.207> <0.776, -0.228, -0.234> 
		<0.778, -0.295, -0.172> <0.777, -0.274, -0.191> <0.777, -0.225, -0.207> <0.776, -0.228, -0.235> 
		<0.778, -0.294, -0.172> <0.777, -0.274, -0.191> <0.777, -0.225, -0.208> <0.776, -0.227, -0.235> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.778, -0.294, -0.172> <0.777, -0.274, -0.191> <0.777, -0.225, -0.208> <0.776, -0.227, -0.235> 
		<0.778, -0.294, -0.172> <0.777, -0.274, -0.191> <0.777, -0.224, -0.208> <0.776, -0.227, -0.236> 
		<0.778, -0.294, -0.172> <0.778, -0.274, -0.192> <0.777, -0.224, -0.209> <0.776, -0.226, -0.237> 
		<0.778, -0.294, -0.173> <0.778, -0.274, -0.192> <0.777, -0.224, -0.209> <0.776, -0.226, -0.237> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.778, -0.294, -0.173> <0.778, -0.274, -0.192> <0.777, -0.224, -0.209> <0.776, -0.226, -0.237> 
		<0.778, -0.294, -0.173> <0.778, -0.274, -0.192> <0.778, -0.224, -0.210> <0.777, -0.226, -0.238> 
		<0.779, -0.294, -0.173> <0.779, -0.273, -0.192> <0.778, -0.224, -0.210> <0.778, -0.225, -0.238> 
		<0.779, -0.294, -0.173> <0.779, -0.273, -0.192> <0.779, -0.224, -0.210> <0.779, -0.225, -0.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.294, -0.173> <0.779, -0.273, -0.192> <0.779, -0.224, -0.210> <0.779, -0.225, -0.238> 
		<0.779, -0.294, -0.173> <0.779, -0.273, -0.192> <0.779, -0.224, -0.210> <0.779, -0.225, -0.238> 
		<0.779, -0.294, -0.173> <0.780, -0.274, -0.192> <0.780, -0.224, -0.210> <0.781, -0.226, -0.238> 
		<0.779, -0.294, -0.173> <0.780, -0.274, -0.192> <0.780, -0.224, -0.209> <0.781, -0.226, -0.237> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.781, -0.228, -0.234> <0.782, -0.231, -0.260> <0.782, -0.283, -0.266> <0.783, -0.306, -0.280> 
		<0.781, -0.229, -0.233> <0.781, -0.231, -0.260> <0.781, -0.283, -0.265> <0.782, -0.306, -0.279> 
		<0.779, -0.229, -0.233> <0.779, -0.232, -0.260> <0.780, -0.283, -0.264> <0.780, -0.307, -0.278> 
		<0.779, -0.229, -0.233> <0.779, -0.232, -0.260> <0.779, -0.283, -0.264> <0.779, -0.307, -0.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.229, -0.233> <0.779, -0.232, -0.260> <0.779, -0.283, -0.264> <0.779, -0.307, -0.278> 
		<0.778, -0.229, -0.233> <0.778, -0.232, -0.260> <0.777, -0.283, -0.264> <0.777, -0.307, -0.278> 
		<0.777, -0.229, -0.233> <0.776, -0.231, -0.260> <0.776, -0.283, -0.265> <0.775, -0.306, -0.279> 
		<0.776, -0.228, -0.234> <0.776, -0.231, -0.260> <0.775, -0.283, -0.266> <0.774, -0.306, -0.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.776, -0.228, -0.234> <0.776, -0.231, -0.260> <0.775, -0.283, -0.266> <0.774, -0.306, -0.280> 
		<0.776, -0.228, -0.234> <0.775, -0.231, -0.261> <0.774, -0.282, -0.267> <0.773, -0.305, -0.280> 
		<0.776, -0.228, -0.235> <0.774, -0.230, -0.262> <0.773, -0.281, -0.268> <0.773, -0.304, -0.282> 
		<0.776, -0.227, -0.235> <0.774, -0.229, -0.262> <0.773, -0.281, -0.269> <0.773, -0.304, -0.283> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.776, -0.227, -0.235> <0.774, -0.229, -0.262> <0.773, -0.281, -0.269> <0.773, -0.304, -0.283> 
		<0.776, -0.227, -0.236> <0.774, -0.229, -0.263> <0.773, -0.280, -0.270> <0.773, -0.303, -0.284> 
		<0.776, -0.226, -0.237> <0.775, -0.228, -0.264> <0.774, -0.279, -0.271> <0.773, -0.302, -0.286> 
		<0.776, -0.226, -0.237> <0.776, -0.228, -0.264> <0.775, -0.279, -0.272> <0.774, -0.301, -0.287> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.776, -0.226, -0.237> <0.776, -0.228, -0.264> <0.775, -0.279, -0.272> <0.774, -0.301, -0.287> 
		<0.777, -0.226, -0.238> <0.776, -0.227, -0.265> <0.776, -0.278, -0.273> <0.775, -0.301, -0.288> 
		<0.778, -0.225, -0.238> <0.778, -0.227, -0.265> <0.777, -0.278, -0.273> <0.777, -0.300, -0.288> 
		<0.779, -0.225, -0.238> <0.779, -0.227, -0.265> <0.779, -0.278, -0.273> <0.779, -0.300, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, -0.225, -0.238> <0.779, -0.227, -0.265> <0.779, -0.278, -0.273> <0.779, -0.300, -0.288> 
		<0.779, -0.225, -0.238> <0.779, -0.227, -0.265> <0.780, -0.278, -0.273> <0.780, -0.300, -0.288> 
		<0.781, -0.226, -0.238> <0.781, -0.227, -0.265> <0.781, -0.278, -0.273> <0.782, -0.301, -0.288> 
		<0.781, -0.226, -0.237> <0.782, -0.228, -0.264> <0.782, -0.279, -0.272> <0.783, -0.301, -0.287> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.918, -0.200, -0.378> <0.918, -0.200, -0.379> <0.918, -0.200, -0.379> <0.918, -0.200, -0.379> 
		<0.897, -0.207, -0.377> <0.897, -0.207, -0.377> <0.896, -0.207, -0.377> <0.896, -0.207, -0.378> 
		<0.861, -0.206, -0.377> <0.861, -0.206, -0.377> <0.861, -0.206, -0.378> <0.861, -0.206, -0.378> 
		<0.846, -0.222, -0.372> <0.846, -0.222, -0.373> <0.846, -0.223, -0.374> <0.845, -0.223, -0.374> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.918, -0.200, -0.378> <0.897, -0.207, -0.377> <0.861, -0.206, -0.377> <0.846, -0.222, -0.372> 
		<0.918, -0.200, -0.378> <0.897, -0.207, -0.376> <0.861, -0.206, -0.376> <0.846, -0.222, -0.371> 
		<0.918, -0.200, -0.378> <0.896, -0.206, -0.376> <0.861, -0.205, -0.376> <0.846, -0.222, -0.370> 
		<0.918, -0.200, -0.378> <0.896, -0.206, -0.376> <0.861, -0.205, -0.375> <0.845, -0.221, -0.370> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.846, -0.222, -0.372> <0.846, -0.222, -0.373> <0.846, -0.223, -0.374> <0.845, -0.223, -0.374> 
		<0.828, -0.242, -0.366> <0.828, -0.242, -0.367> <0.827, -0.242, -0.369> <0.827, -0.242, -0.369> 
		<0.828, -0.280, -0.355> <0.828, -0.281, -0.357> <0.828, -0.281, -0.358> <0.827, -0.281, -0.359> 
		<0.820, -0.305, -0.348> <0.820, -0.306, -0.350> <0.820, -0.306, -0.351> <0.819, -0.306, -0.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.846, -0.222, -0.372> <0.828, -0.242, -0.366> <0.828, -0.280, -0.355> <0.820, -0.305, -0.348> 
		<0.846, -0.222, -0.371> <0.828, -0.241, -0.366> <0.828, -0.280, -0.354> <0.820, -0.305, -0.347> 
		<0.846, -0.222, -0.370> <0.827, -0.241, -0.364> <0.828, -0.279, -0.353> <0.820, -0.304, -0.345> 
		<0.845, -0.221, -0.370> <0.827, -0.240, -0.364> <0.827, -0.279, -0.352> <0.819, -0.304, -0.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.918, -0.200, -0.378> <0.896, -0.206, -0.376> <0.861, -0.205, -0.375> <0.845, -0.221, -0.370> 
		<0.918, -0.200, -0.378> <0.896, -0.206, -0.375> <0.860, -0.205, -0.375> <0.845, -0.221, -0.369> 
		<0.918, -0.199, -0.378> <0.895, -0.206, -0.375> <0.860, -0.205, -0.375> <0.844, -0.221, -0.369> 
		<0.918, -0.199, -0.378> <0.895, -0.206, -0.375> <0.859, -0.204, -0.375> <0.843, -0.220, -0.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.918, -0.199, -0.378> <0.895, -0.206, -0.375> <0.859, -0.204, -0.375> <0.843, -0.220, -0.369> 
		<0.917, -0.199, -0.378> <0.895, -0.206, -0.375> <0.858, -0.204, -0.375> <0.842, -0.220, -0.369> 
		<0.917, -0.199, -0.378> <0.894, -0.206, -0.376> <0.858, -0.204, -0.375> <0.841, -0.220, -0.370> 
		<0.917, -0.199, -0.378> <0.894, -0.206, -0.376> <0.858, -0.204, -0.376> <0.841, -0.220, -0.370> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.917, -0.199, -0.378> <0.894, -0.206, -0.376> <0.858, -0.204, -0.376> <0.841, -0.220, -0.370> 
		<0.917, -0.199, -0.378> <0.894, -0.206, -0.376> <0.857, -0.204, -0.376> <0.840, -0.220, -0.371> 
		<0.917, -0.199, -0.378> <0.894, -0.206, -0.377> <0.857, -0.204, -0.377> <0.840, -0.220, -0.372> 
		<0.917, -0.199, -0.379> <0.894, -0.206, -0.377> <0.857, -0.204, -0.377> <0.840, -0.220, -0.373> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.917, -0.199, -0.379> <0.894, -0.206, -0.377> <0.857, -0.204, -0.377> <0.840, -0.220, -0.373> 
		<0.917, -0.199, -0.379> <0.894, -0.206, -0.377> <0.857, -0.204, -0.378> <0.840, -0.221, -0.373> 
		<0.917, -0.200, -0.379> <0.894, -0.206, -0.378> <0.857, -0.205, -0.378> <0.840, -0.221, -0.374> 
		<0.917, -0.200, -0.379> <0.894, -0.206, -0.378> <0.858, -0.205, -0.379> <0.841, -0.221, -0.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.917, -0.200, -0.379> <0.894, -0.206, -0.378> <0.858, -0.205, -0.379> <0.841, -0.221, -0.375> 
		<0.917, -0.200, -0.379> <0.894, -0.206, -0.378> <0.858, -0.205, -0.379> <0.841, -0.222, -0.375> 
		<0.917, -0.200, -0.379> <0.895, -0.206, -0.378> <0.858, -0.205, -0.379> <0.842, -0.222, -0.375> 
		<0.918, -0.200, -0.379> <0.895, -0.207, -0.378> <0.859, -0.206, -0.379> <0.843, -0.222, -0.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.918, -0.200, -0.379> <0.895, -0.207, -0.378> <0.859, -0.206, -0.379> <0.843, -0.222, -0.375> 
		<0.918, -0.200, -0.379> <0.895, -0.207, -0.378> <0.860, -0.206, -0.379> <0.844, -0.222, -0.375> 
		<0.918, -0.200, -0.379> <0.896, -0.207, -0.378> <0.860, -0.206, -0.379> <0.845, -0.223, -0.375> 
		<0.918, -0.200, -0.379> <0.896, -0.207, -0.378> <0.861, -0.206, -0.378> <0.845, -0.223, -0.374> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.845, -0.221, -0.370> <0.827, -0.240, -0.364> <0.827, -0.279, -0.352> <0.819, -0.304, -0.344> 
		<0.845, -0.221, -0.369> <0.826, -0.240, -0.363> <0.826, -0.278, -0.351> <0.818, -0.303, -0.343> 
		<0.844, -0.221, -0.369> <0.825, -0.239, -0.363> <0.824, -0.278, -0.351> <0.816, -0.302, -0.343> 
		<0.843, -0.220, -0.369> <0.824, -0.239, -0.363> <0.823, -0.277, -0.351> <0.815, -0.302, -0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.843, -0.220, -0.369> <0.824, -0.239, -0.363> <0.823, -0.277, -0.351> <0.815, -0.302, -0.343> 
		<0.842, -0.220, -0.369> <0.824, -0.239, -0.363> <0.822, -0.277, -0.351> <0.813, -0.301, -0.343> 
		<0.841, -0.220, -0.370> <0.822, -0.238, -0.364> <0.820, -0.277, -0.352> <0.811, -0.301, -0.344> 
		<0.841, -0.220, -0.370> <0.822, -0.238, -0.364> <0.820, -0.277, -0.353> <0.810, -0.301, -0.345> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.841, -0.220, -0.370> <0.822, -0.238, -0.364> <0.820, -0.277, -0.353> <0.810, -0.301, -0.345> 
		<0.840, -0.220, -0.371> <0.821, -0.238, -0.365> <0.819, -0.277, -0.354> <0.809, -0.301, -0.346> 
		<0.840, -0.220, -0.372> <0.821, -0.238, -0.367> <0.818, -0.277, -0.355> <0.809, -0.301, -0.348> 
		<0.840, -0.220, -0.373> <0.821, -0.239, -0.367> <0.818, -0.277, -0.356> <0.809, -0.302, -0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.840, -0.220, -0.373> <0.821, -0.239, -0.367> <0.818, -0.277, -0.356> <0.809, -0.302, -0.349> 
		<0.840, -0.221, -0.373> <0.821, -0.239, -0.368> <0.818, -0.278, -0.358> <0.809, -0.302, -0.351> 
		<0.840, -0.221, -0.374> <0.821, -0.239, -0.370> <0.819, -0.278, -0.359> <0.809, -0.303, -0.352> 
		<0.841, -0.221, -0.375> <0.822, -0.240, -0.370> <0.820, -0.279, -0.360> <0.810, -0.303, -0.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.841, -0.221, -0.375> <0.822, -0.240, -0.370> <0.820, -0.279, -0.360> <0.810, -0.303, -0.353> 
		<0.841, -0.222, -0.375> <0.822, -0.240, -0.371> <0.820, -0.279, -0.361> <0.811, -0.304, -0.354> 
		<0.842, -0.222, -0.375> <0.824, -0.241, -0.371> <0.822, -0.280, -0.361> <0.813, -0.305, -0.355> 
		<0.843, -0.222, -0.375> <0.824, -0.241, -0.371> <0.823, -0.280, -0.361> <0.815, -0.305, -0.355> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.843, -0.222, -0.375> <0.824, -0.241, -0.371> <0.823, -0.280, -0.361> <0.815, -0.305, -0.355> 
		<0.844, -0.222, -0.375> <0.825, -0.241, -0.371> <0.824, -0.281, -0.361> <0.816, -0.306, -0.355> 
		<0.845, -0.223, -0.375> <0.826, -0.242, -0.370> <0.826, -0.281, -0.360> <0.818, -0.306, -0.354> 
		<0.845, -0.223, -0.374> <0.827, -0.242, -0.369> <0.827, -0.281, -0.359> <0.819, -0.306, -0.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.786, -0.157, -0.418> <0.786, -0.157, -0.418> <0.786, -0.157, -0.418> <0.786, -0.157, -0.418> 
		<0.787, -0.176, -0.398> <0.787, -0.176, -0.399> <0.787, -0.176, -0.399> <0.787, -0.176, -0.399> 
		<0.788, -0.194, -0.364> <0.788, -0.194, -0.365> <0.788, -0.194, -0.365> <0.787, -0.194, -0.366> 
		<0.789, -0.218, -0.354> <0.789, -0.218, -0.354> <0.788, -0.218, -0.355> <0.788, -0.218, -0.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.786, -0.157, -0.418> <0.787, -0.176, -0.398> <0.788, -0.194, -0.364> <0.789, -0.218, -0.354> 
		<0.786, -0.157, -0.417> <0.787, -0.176, -0.398> <0.788, -0.194, -0.363> <0.789, -0.218, -0.353> 
		<0.786, -0.157, -0.417> <0.787, -0.176, -0.397> <0.788, -0.194, -0.363> <0.788, -0.218, -0.352> 
		<0.786, -0.157, -0.417> <0.787, -0.176, -0.397> <0.787, -0.194, -0.362> <0.788, -0.218, -0.351> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.789, -0.218, -0.354> <0.789, -0.218, -0.354> <0.788, -0.218, -0.355> <0.788, -0.218, -0.356> 
		<0.790, -0.243, -0.343> <0.790, -0.243, -0.344> <0.789, -0.244, -0.345> <0.789, -0.244, -0.346> 
		<0.791, -0.281, -0.354> <0.791, -0.281, -0.355> <0.790, -0.281, -0.356> <0.789, -0.281, -0.357> 
		<0.792, -0.309, -0.354> <0.792, -0.309, -0.355> <0.791, -0.309, -0.357> <0.790, -0.309, -0.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.789, -0.218, -0.354> <0.790, -0.243, -0.343> <0.791, -0.281, -0.354> <0.792, -0.309, -0.354> 
		<0.789, -0.218, -0.353> <0.790, -0.243, -0.342> <0.791, -0.281, -0.352> <0.792, -0.309, -0.352> 
		<0.788, -0.218, -0.352> <0.789, -0.243, -0.341> <0.790, -0.281, -0.351> <0.791, -0.309, -0.350> 
		<0.788, -0.218, -0.351> <0.789, -0.243, -0.340> <0.789, -0.281, -0.350> <0.790, -0.309, -0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.786, -0.157, -0.417> <0.787, -0.176, -0.397> <0.787, -0.194, -0.362> <0.788, -0.218, -0.351> 
		<0.786, -0.157, -0.417> <0.787, -0.176, -0.397> <0.787, -0.194, -0.362> <0.787, -0.218, -0.351> 
		<0.786, -0.157, -0.417> <0.786, -0.176, -0.397> <0.786, -0.194, -0.362> <0.786, -0.218, -0.350> 
		<0.786, -0.157, -0.417> <0.786, -0.176, -0.397> <0.786, -0.194, -0.362> <0.786, -0.218, -0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.786, -0.157, -0.417> <0.786, -0.176, -0.397> <0.786, -0.194, -0.362> <0.786, -0.218, -0.350> 
		<0.785, -0.157, -0.417> <0.785, -0.176, -0.397> <0.785, -0.194, -0.362> <0.785, -0.218, -0.350> 
		<0.785, -0.157, -0.417> <0.785, -0.176, -0.397> <0.785, -0.194, -0.362> <0.784, -0.218, -0.351> 
		<0.785, -0.157, -0.417> <0.785, -0.176, -0.397> <0.784, -0.194, -0.362> <0.783, -0.218, -0.351> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.785, -0.157, -0.417> <0.785, -0.176, -0.397> <0.784, -0.194, -0.362> <0.783, -0.218, -0.351> 
		<0.785, -0.157, -0.417> <0.784, -0.176, -0.397> <0.783, -0.194, -0.363> <0.783, -0.218, -0.352> 
		<0.785, -0.157, -0.417> <0.784, -0.176, -0.398> <0.783, -0.194, -0.363> <0.782, -0.218, -0.353> 
		<0.785, -0.157, -0.418> <0.784, -0.176, -0.398> <0.783, -0.194, -0.364> <0.782, -0.218, -0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.785, -0.157, -0.418> <0.784, -0.176, -0.398> <0.783, -0.194, -0.364> <0.782, -0.218, -0.354> 
		<0.785, -0.157, -0.418> <0.784, -0.176, -0.399> <0.783, -0.194, -0.365> <0.782, -0.218, -0.354> 
		<0.785, -0.157, -0.418> <0.784, -0.176, -0.399> <0.783, -0.194, -0.365> <0.783, -0.218, -0.355> 
		<0.785, -0.157, -0.418> <0.785, -0.176, -0.399> <0.784, -0.194, -0.366> <0.783, -0.218, -0.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.785, -0.157, -0.418> <0.785, -0.176, -0.399> <0.784, -0.194, -0.366> <0.783, -0.218, -0.356> 
		<0.785, -0.157, -0.418> <0.785, -0.176, -0.400> <0.785, -0.194, -0.366> <0.784, -0.218, -0.356> 
		<0.785, -0.157, -0.418> <0.785, -0.176, -0.400> <0.785, -0.194, -0.366> <0.785, -0.218, -0.357> 
		<0.786, -0.157, -0.418> <0.786, -0.176, -0.400> <0.786, -0.194, -0.366> <0.786, -0.218, -0.357> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.786, -0.157, -0.418> <0.786, -0.176, -0.400> <0.786, -0.194, -0.366> <0.786, -0.218, -0.357> 
		<0.786, -0.157, -0.418> <0.786, -0.176, -0.400> <0.786, -0.194, -0.366> <0.786, -0.218, -0.357> 
		<0.786, -0.157, -0.418> <0.787, -0.176, -0.400> <0.787, -0.194, -0.366> <0.787, -0.218, -0.356> 
		<0.786, -0.157, -0.418> <0.787, -0.176, -0.399> <0.787, -0.194, -0.366> <0.788, -0.218, -0.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.788, -0.218, -0.351> <0.789, -0.243, -0.340> <0.789, -0.281, -0.350> <0.790, -0.309, -0.349> 
		<0.787, -0.218, -0.351> <0.788, -0.243, -0.340> <0.788, -0.281, -0.349> <0.789, -0.309, -0.348> 
		<0.786, -0.218, -0.350> <0.786, -0.243, -0.339> <0.787, -0.281, -0.348> <0.787, -0.309, -0.348> 
		<0.786, -0.218, -0.350> <0.786, -0.243, -0.339> <0.786, -0.281, -0.348> <0.786, -0.309, -0.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.786, -0.218, -0.350> <0.786, -0.243, -0.339> <0.786, -0.281, -0.348> <0.786, -0.309, -0.348> 
		<0.785, -0.218, -0.350> <0.785, -0.243, -0.339> <0.784, -0.281, -0.348> <0.784, -0.309, -0.348> 
		<0.784, -0.218, -0.351> <0.783, -0.243, -0.340> <0.783, -0.281, -0.349> <0.782, -0.309, -0.348> 
		<0.783, -0.218, -0.351> <0.783, -0.243, -0.340> <0.782, -0.281, -0.350> <0.781, -0.309, -0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.783, -0.218, -0.351> <0.783, -0.243, -0.340> <0.782, -0.281, -0.350> <0.781, -0.309, -0.349> 
		<0.783, -0.218, -0.352> <0.782, -0.243, -0.341> <0.781, -0.281, -0.351> <0.780, -0.309, -0.350> 
		<0.782, -0.218, -0.353> <0.782, -0.243, -0.342> <0.780, -0.281, -0.352> <0.780, -0.309, -0.352> 
		<0.782, -0.218, -0.354> <0.782, -0.243, -0.343> <0.780, -0.281, -0.354> <0.780, -0.309, -0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.782, -0.218, -0.354> <0.782, -0.243, -0.343> <0.780, -0.281, -0.354> <0.780, -0.309, -0.354> 
		<0.782, -0.218, -0.354> <0.782, -0.243, -0.344> <0.780, -0.281, -0.355> <0.780, -0.309, -0.355> 
		<0.783, -0.218, -0.355> <0.782, -0.244, -0.345> <0.781, -0.281, -0.356> <0.780, -0.309, -0.357> 
		<0.783, -0.218, -0.356> <0.783, -0.244, -0.346> <0.782, -0.281, -0.357> <0.781, -0.309, -0.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.783, -0.218, -0.356> <0.783, -0.244, -0.346> <0.782, -0.281, -0.357> <0.781, -0.309, -0.358> 
		<0.784, -0.218, -0.356> <0.783, -0.244, -0.346> <0.783, -0.281, -0.358> <0.782, -0.309, -0.359> 
		<0.785, -0.218, -0.357> <0.785, -0.244, -0.347> <0.784, -0.281, -0.359> <0.784, -0.309, -0.360> 
		<0.786, -0.218, -0.357> <0.786, -0.244, -0.347> <0.786, -0.281, -0.359> <0.786, -0.309, -0.360> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.786, -0.218, -0.357> <0.786, -0.244, -0.347> <0.786, -0.281, -0.359> <0.786, -0.309, -0.360> 
		<0.786, -0.218, -0.357> <0.786, -0.244, -0.347> <0.787, -0.281, -0.359> <0.787, -0.309, -0.360> 
		<0.787, -0.218, -0.356> <0.788, -0.244, -0.346> <0.788, -0.281, -0.358> <0.789, -0.309, -0.359> 
		<0.788, -0.218, -0.356> <0.789, -0.244, -0.346> <0.789, -0.281, -0.357> <0.790, -0.309, -0.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.702, -0.188, -0.447> <0.702, -0.188, -0.447> <0.702, -0.188, -0.447> <0.702, -0.188, -0.447> 
		<0.712, -0.199, -0.431> <0.712, -0.199, -0.431> <0.712, -0.199, -0.432> <0.712, -0.199, -0.432> 
		<0.731, -0.208, -0.406> <0.731, -0.208, -0.407> <0.731, -0.208, -0.408> <0.731, -0.208, -0.408> 
		<0.737, -0.225, -0.394> <0.737, -0.225, -0.394> <0.736, -0.225, -0.395> <0.736, -0.226, -0.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.702, -0.188, -0.447> <0.712, -0.199, -0.431> <0.731, -0.208, -0.406> <0.737, -0.225, -0.394> 
		<0.702, -0.188, -0.446> <0.712, -0.199, -0.431> <0.731, -0.208, -0.406> <0.737, -0.225, -0.393> 
		<0.702, -0.188, -0.446> <0.712, -0.199, -0.430> <0.731, -0.208, -0.405> <0.736, -0.225, -0.392> 
		<0.702, -0.188, -0.446> <0.712, -0.199, -0.430> <0.731, -0.208, -0.405> <0.736, -0.225, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.737, -0.225, -0.394> <0.737, -0.225, -0.394> <0.736, -0.225, -0.395> <0.736, -0.226, -0.396> 
		<0.743, -0.246, -0.378> <0.743, -0.246, -0.379> <0.743, -0.247, -0.381> <0.742, -0.247, -0.381> 
		<0.739, -0.282, -0.369> <0.739, -0.283, -0.370> <0.738, -0.283, -0.371> <0.737, -0.283, -0.372> 
		<0.740, -0.307, -0.358> <0.740, -0.307, -0.359> <0.739, -0.308, -0.361> <0.738, -0.308, -0.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.737, -0.225, -0.394> <0.743, -0.246, -0.378> <0.739, -0.282, -0.369> <0.740, -0.307, -0.358> 
		<0.737, -0.225, -0.393> <0.743, -0.246, -0.378> <0.739, -0.282, -0.367> <0.740, -0.307, -0.357> 
		<0.736, -0.225, -0.392> <0.743, -0.245, -0.376> <0.738, -0.282, -0.366> <0.739, -0.306, -0.355> 
		<0.736, -0.225, -0.391> <0.742, -0.245, -0.375> <0.737, -0.282, -0.365> <0.738, -0.306, -0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.702, -0.188, -0.446> <0.712, -0.199, -0.430> <0.731, -0.208, -0.405> <0.736, -0.225, -0.391> 
		<0.702, -0.188, -0.446> <0.712, -0.199, -0.430> <0.730, -0.208, -0.404> <0.735, -0.225, -0.391> 
		<0.701, -0.188, -0.446> <0.711, -0.199, -0.429> <0.730, -0.208, -0.404> <0.734, -0.224, -0.391> 
		<0.701, -0.188, -0.446> <0.711, -0.199, -0.429> <0.729, -0.208, -0.404> <0.734, -0.224, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.701, -0.188, -0.446> <0.711, -0.199, -0.429> <0.729, -0.208, -0.404> <0.734, -0.224, -0.391> 
		<0.701, -0.188, -0.446> <0.711, -0.199, -0.429> <0.728, -0.208, -0.404> <0.733, -0.224, -0.391> 
		<0.701, -0.188, -0.446> <0.710, -0.199, -0.430> <0.728, -0.208, -0.404> <0.732, -0.225, -0.391> 
		<0.701, -0.188, -0.446> <0.710, -0.199, -0.430> <0.727, -0.208, -0.405> <0.731, -0.225, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.701, -0.188, -0.446> <0.710, -0.199, -0.430> <0.727, -0.208, -0.405> <0.731, -0.225, -0.391> 
		<0.701, -0.188, -0.446> <0.710, -0.199, -0.430> <0.727, -0.208, -0.405> <0.731, -0.225, -0.392> 
		<0.700, -0.188, -0.446> <0.709, -0.199, -0.431> <0.727, -0.208, -0.406> <0.730, -0.225, -0.393> 
		<0.700, -0.188, -0.447> <0.709, -0.199, -0.431> <0.727, -0.208, -0.406> <0.730, -0.225, -0.394> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.700, -0.188, -0.447> <0.709, -0.199, -0.431> <0.727, -0.208, -0.406> <0.730, -0.225, -0.394> 
		<0.700, -0.188, -0.447> <0.709, -0.199, -0.431> <0.727, -0.208, -0.407> <0.730, -0.225, -0.394> 
		<0.701, -0.188, -0.447> <0.710, -0.199, -0.432> <0.727, -0.209, -0.407> <0.731, -0.225, -0.395> 
		<0.701, -0.188, -0.447> <0.710, -0.199, -0.432> <0.727, -0.209, -0.408> <0.731, -0.226, -0.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.701, -0.188, -0.447> <0.710, -0.199, -0.432> <0.727, -0.209, -0.408> <0.731, -0.226, -0.396> 
		<0.701, -0.188, -0.447> <0.710, -0.199, -0.432> <0.728, -0.209, -0.408> <0.732, -0.226, -0.396> 
		<0.701, -0.188, -0.447> <0.711, -0.199, -0.432> <0.728, -0.209, -0.409> <0.733, -0.226, -0.397> 
		<0.701, -0.188, -0.447> <0.711, -0.199, -0.432> <0.729, -0.209, -0.409> <0.734, -0.226, -0.397> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.701, -0.188, -0.447> <0.711, -0.199, -0.432> <0.729, -0.209, -0.409> <0.734, -0.226, -0.397> 
		<0.701, -0.188, -0.447> <0.711, -0.199, -0.432> <0.730, -0.209, -0.409> <0.734, -0.226, -0.397> 
		<0.702, -0.188, -0.447> <0.712, -0.199, -0.432> <0.730, -0.209, -0.409> <0.735, -0.226, -0.396> 
		<0.702, -0.188, -0.447> <0.712, -0.199, -0.432> <0.731, -0.208, -0.408> <0.736, -0.226, -0.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.736, -0.225, -0.391> <0.742, -0.245, -0.375> <0.737, -0.282, -0.365> <0.738, -0.306, -0.354> 
		<0.735, -0.225, -0.391> <0.742, -0.245, -0.375> <0.736, -0.282, -0.364> <0.737, -0.306, -0.353> 
		<0.734, -0.224, -0.391> <0.740, -0.245, -0.374> <0.735, -0.281, -0.364> <0.735, -0.306, -0.352> 
		<0.734, -0.224, -0.391> <0.739, -0.245, -0.374> <0.734, -0.281, -0.364> <0.734, -0.306, -0.352> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.734, -0.224, -0.391> <0.739, -0.245, -0.374> <0.734, -0.281, -0.364> <0.734, -0.306, -0.352> 
		<0.733, -0.224, -0.391> <0.739, -0.245, -0.374> <0.732, -0.281, -0.364> <0.732, -0.306, -0.352> 
		<0.732, -0.225, -0.391> <0.737, -0.245, -0.375> <0.731, -0.282, -0.364> <0.730, -0.306, -0.353> 
		<0.731, -0.225, -0.391> <0.736, -0.246, -0.375> <0.730, -0.282, -0.365> <0.729, -0.306, -0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.731, -0.225, -0.391> <0.736, -0.246, -0.375> <0.730, -0.282, -0.365> <0.729, -0.306, -0.354> 
		<0.731, -0.225, -0.392> <0.736, -0.246, -0.376> <0.729, -0.282, -0.366> <0.728, -0.306, -0.355> 
		<0.730, -0.225, -0.393> <0.735, -0.246, -0.377> <0.728, -0.282, -0.367> <0.728, -0.307, -0.357> 
		<0.730, -0.225, -0.394> <0.735, -0.246, -0.378> <0.728, -0.282, -0.369> <0.728, -0.307, -0.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.730, -0.225, -0.394> <0.735, -0.246, -0.378> <0.728, -0.282, -0.369> <0.728, -0.307, -0.358> 
		<0.730, -0.225, -0.394> <0.735, -0.246, -0.379> <0.728, -0.283, -0.370> <0.728, -0.307, -0.359> 
		<0.731, -0.225, -0.395> <0.736, -0.247, -0.380> <0.729, -0.283, -0.371> <0.728, -0.308, -0.361> 
		<0.731, -0.226, -0.396> <0.736, -0.247, -0.381> <0.730, -0.283, -0.372> <0.729, -0.308, -0.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.731, -0.226, -0.396> <0.736, -0.247, -0.381> <0.730, -0.283, -0.372> <0.729, -0.308, -0.362> 
		<0.732, -0.226, -0.396> <0.737, -0.247, -0.381> <0.731, -0.283, -0.373> <0.730, -0.308, -0.363> 
		<0.733, -0.226, -0.397> <0.739, -0.247, -0.382> <0.732, -0.284, -0.374> <0.732, -0.308, -0.364> 
		<0.734, -0.226, -0.397> <0.739, -0.247, -0.382> <0.734, -0.284, -0.374> <0.734, -0.308, -0.364> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.734, -0.226, -0.397> <0.739, -0.247, -0.382> <0.734, -0.284, -0.374> <0.734, -0.308, -0.364> 
		<0.734, -0.226, -0.397> <0.740, -0.247, -0.382> <0.735, -0.284, -0.374> <0.735, -0.308, -0.364> 
		<0.735, -0.226, -0.396> <0.742, -0.247, -0.382> <0.736, -0.283, -0.373> <0.737, -0.308, -0.363> 
		<0.736, -0.226, -0.396> <0.742, -0.247, -0.381> <0.737, -0.283, -0.372> <0.738, -0.308, -0.362> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment { color green 1.0 blue 0.498039 }
	finish { phong 0.3 }
	#end
}
 
declare barrow =
union{

object {cargo }
object {handle }
object {brackets}
object {tire}
object {rim}
object {axle}
object {hardware}
object {rootball}
object {fronds 
        scale 2
	translate <-0.89,0.13,0.5>}
} 





 

 
#declare clouds = 
 // An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  51.0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?

pigment {
    agate
    color_map {
        [0.3 rgbf <1, 1, 1, 1>]
        [1.0 red 0.65 green 0.49 blue 0.24]
    }
    scale 490
    
}finish {ambient 0.7} }
  
  

#declare skylayer =
  // An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  500.0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?

pigment {  color red 0.74902 green 0.847059 blue 0.847059
    
}

}

#declare field = 

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -0.7 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?

    normal{  waves 0.5 
              scale 5
              frequency 22
    //bump_map {
    //  png "field.png"
    //  bump_size 5 }
    //  scale 12
      
  } // texture pigment/normal pattern
// create a wavy surface (also use phase)
      
      

	pigment { red 0.858824 green 0.576471 blue 0.439216 }
	finish {
         
        ambient 0.2
        diffuse 0.65
        specular 0.005
        
    }   

}

#declare environment =
union{

object {field}
object {clouds}
object {skylayer}
}

object {barrow rotate <-20,40,15>
               translate <0,-0.4,0> }
object {environment}
