
// Rock Garden of the Gods
// Landscape generated with Teragen ... Image_Map created in Teragen by shooting
// from center and very high with max telepoto lens to flatten scene
// Teragen .ter file converted to smooth_triangles with Wilbur
//  but they all had unit positive normals along the x-axis
// Loaded into CrossRoad -- converted to .dxf -- loaded into Wct2pov to make smooth

#include "colors.inc"
#include "textures.inc"

global_settings { max_trace_level 64 // needed for the sky stack
	          ambient_light rgb <230 / 255, 241 / 255, 247 / 255>
                }

background { SkyBlue }

camera {
        location  <330, 30, 300> 
        direction <0, 0,  1>
        up        <0, 1,  0>
        right   <4/3, 0,  0>
        look_at   <105, 30, 420>
        angle 65
}

light_source {<0, 10000000, -5000000> color White} //Sun
light_source {<330, 30, 300> color White shadowless} //Camera Light

#declare trace_clouds = 2; //0=off, 1-partial, 2=full
#declare trace_land = 2; //0=off, 1=on, 2=smoothed
#declare trace_tree = 1;
#declare trace_eagle = 1;
#declare trace_moon = 1;

//Setting Moon
#if (trace_moon=1)
#declare Moon = 
      sphere {0, 35000
              normal { bump_map { png "MoonBump.png" map_type 1 bump_size 5.0 } }
              pigment {image_map {png "MoonMap.png" map_type 1 interpolate 2 } }
              finish {ambient 0 diffuse 1}
             }           
object { Moon 
         translate<0,0,600000>
         rotate<-20,0,0>
         rotate<0,-50,0> 
         no_shadow 
       }  
#end

// Tree -----------------------
#if (trace_tree=1)
#declare _LEVEL1_Black = texture {pigment {color Tan} finish {Dull}}
#declare _LEVEL2_Black = texture {pigment {color Brown} finish {Dull}}
#declare _LEVEL3_Black = texture {pigment {color DarkBrown} finish {Dull}}
#declare _LEVEL4_Black = texture {pigment {color MediumWood} finish {Dull}}
#declare _LEAVES_Black = texture {pigment {color PaleGreen} finish {Dull}}
object { #include "Bonsai.inc"
         scale 0.1
         rotate <0,-60,0>
         translate <266, 10.5, 324>
       }
#end

// Eagle ---------------------
#if (trace_eagle=1)
#declare _Layer0_Black = texture {pigment {color Black} finish {Shiny}}
#declare _Layer0_Yellow = texture {pigment {color Brown} finish {Shiny}}
#declare _Layer0_LightGray = texture {pigment {color Gray30} finish {Shiny}}
#declare _Layer0_White = texture {pigment {color Silver} finish {Shiny}}
#declare _Layer0_Red = texture {pigment {color Red} finish {Shiny}}
object { #include "Eagle.inc"
         scale 0.03
         rotate <-90,0,0>
         rotate <0,130,0>
         rotate <30,0,0>
         rotate <0,40,0>
         translate <269, 14, 324>
       }                     
#end

//Rock Garden of the Gods --------------------------------- 
#if (trace_land>0)
#declare TeragenPovText = 
            texture { pigment { image_map { sys "teragenpov.bmp" interpolate 2 once } 
                                translate <-.3008, -.4241, 0>
                                rotate <-90,0,0>
                              }
                      finish {crand 0.05 reflection 0.0 diffuse 0.7 ambient 0.3}
                    }
object { #include "TerRotateRuff.inc"                
         scale <1,1,-1>
         translate <.3008,.5,.4241>
         scale <1, .15, 1>*600 
       }
#if (trace_land=2)
object { #include "TerRotateSmoth.inc"                
         scale <1,1,-1>
         translate <.3008,.5,.4241>
         scale <1, .15, 1>*600 
         translate <0, 0.001, 0>
       }
#end
#end
                                                                                
//Stormy Sky -----------------------------------
//Code shamelessly lifted from "19141918" by Ian Shumsky who got it
//from "Canyon" by Jaime Piqueres
#if (trace_clouds>0)  
#declare sky_color=SkyBlue*0.8; 
#declare sun_color = <240 / 255, 247 / 255, 253 / 255>;
sky_sphere { pigment { sky_color } }
//
// The cloud planes. 
#if (trace_clouds > 0)
	#if (trace_clouds = 1)
		#declare num_planes = 4;
	#else
		#declare num_planes = 20;
	#end
  #declare StormySky = union {
	#declare clouds_height = 5000;
	#declare plane_dist = 40;
	#declare textu_dist = 40;
	#declare cnt_planes = 1;
	// First cloud layer. This layer is quite dark and broody.
	//
        union
	{ #while (cnt_planes <= num_planes)
	    #declare p = sky_color * .5 + White * .5;
	    #declare p1 = p * (1 - (cnt_planes / num_planes)) + White * (cnt_planes / num_planes);
	    #declare p2 = p * .9 * (1 - (cnt_planes / num_planes)) + White * .9 * (cnt_planes / num_planes);
            plane { y, 0 texture { pigment { agate
					     octaves 9
					     lambda 3
					     turbulence 4
				   color_map {
				              [0.0 Clear]
					      [0.6 Clear]
					      [0.7 p1 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
					      [1.0 p2 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
					     }
					      scale 1000000
				           }
				  finish { ambient sun_color }
				  translate (clouds_height + textu_dist * cnt_planes) * y
				 }
                                no_shadow
				translate (clouds_height + plane_dist * cnt_planes) * y
			}
                        #declare cnt_planes = cnt_planes + 1;
		#end
		translate 7000 * z
	}
        // The second layer of clouds. This layer has a different base texture
	// which gives a more 'solid' type cloud. It is also higher than the first
	// level.
	//
        #declare clouds_height = 7500;
	#declare cnt_planes = 1;
        union
	{
		#while (cnt_planes <= num_planes)
			#declare p = sky_color * .5 + White * .5;
			#declare p1 = p * (1 - (cnt_planes / num_planes)) + White * (cnt_planes / num_planes);
			#declare p2 = p * .9 * (1 - (cnt_planes / num_planes)) + White * .9 * (cnt_planes / num_planes);

			plane
			{
				y, 0
				texture
				{
					pigment
					{
						marble
						octaves 9
						lambda 3
						turbulence 4
						color_map
						{
							[0.0 Clear]
							[0.6 Clear]
							[0.7 p1 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
							[1.0 p2 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
						}
						scale 1000000
					}
					finish
					{
						ambient sun_color
					}
					translate (clouds_height + textu_dist * cnt_planes) * y
				}

				no_shadow
				translate (clouds_height + plane_dist * cnt_planes) * y
			}

			#declare cnt_planes = cnt_planes + 1;
		#end
		translate 7000 * z
	}
        // Finally, place a third level of clouds for a final 'whispy' set
	// of clouds.
	//
        #declare num_planes = 2;
	#declare clouds_height = 15000;
	#declare plane_dist = 40;
	#declare textu_dist = 40;
	#declare cnt_planes = 1;
        union
	{
		#while (cnt_planes <= num_planes)
			#declare p = White*1.2;
			#declare p1 = p*(1-(cnt_planes/num_planes))+White*(cnt_planes/num_planes);
			#declare p2 = p*.9*(1-(cnt_planes/num_planes))+White*.9*(cnt_planes/num_planes);

			plane
			{
				y, 0
				texture
				{
					pigment
					{
						ripples
						octaves 9
						lambda 3
						turbulence 4
						color_map
						{
							[0.0 Clear]
							[0.4 Clear]
							[0.7 p1 filter 0.8+0.1*(cnt_planes/num_planes)]
							[1.0 p2 filter 0.8+0.1*(cnt_planes/num_planes)]
						}
						scale 100000
					}
					finish
					{
						ambient sun_color
					}
					translate (clouds_height+textu_dist*cnt_planes)*y
				}
				no_shadow
				translate (clouds_height+plane_dist*cnt_planes)*y
			}
			#declare cnt_planes = cnt_planes+1;
		#end
		rotate y*45
	}
#end  
   } //End StormySky union
object { StormySky
         rotate <0,270,0>
       }     
#end //If Clouds    
                                                                               