#include "colors.inc"

#declare Cloud = merge
{    
	sphere
	{
		<-1, 0, 0>
		1
	}
	sphere
	{
		<1.5, 0.3, 0>
		1.2
	}
	sphere
	{
		<0.2, 0.2, -0.3>
		1.1
	}
	sphere
	{
		<0, 1, -0.1>
		0.9
	}
	sphere
	{
		<0.8, -0.2, -0.8>
		1
	}
	pigment
	{
		color White
	}
	finish 
	{
		phong 1 phong_size 100
		ambient .15
		diffuse .7
   }
}

#declare Leaves = sphere
{
	<0, 0, 0>
	0.25
	scale <0.9, 0.5, 1.5>
	translate <0, 2.25, 0.4>
	pigment
	{
		color Red
	}
}

#declare Leave = intersection
{
	sphere
	{
		<1, 0, 0>
		1.2
	}
	sphere
	{
		<-1, 0, 0>
		1.2
	}
	rotate y*90
	scale <0.2, 1, 0.2>
	rotate <0, 20, -45>
	pigment
	{
		color ForestGreen
	}
}

#declare Flower = merge
{
	cylinder
	{
		<0, 0, 0>
		<0, 2, 0>
		0.05
		pigment
		{
		 	color ForestGreen
		}	
	}
	sphere
	{
		<0, 2.25, 0>
		0.25
		pigment
		{
			color Yellow
		}
	}
	object { Leaves }
	object { Leaves rotate 72*y}
	object { Leaves rotate 144*y}
	object { Leaves rotate 216*y}
	object { Leaves rotate 288*y}
	object { Leave translate <0.5, 0.5, 0>}
	finish 
	{
		phong 1 phong_size 100
		ambient .15
		diffuse .7
   }
}

#declare Ray = sphere
{
	<0, 0, 0>
	1
	scale <0.1, 1, 0.1>
	translate <0, 2.3, 0>
}

#declare Sun = merge
{
	sphere
	{
		<0, 0, 0>
		1
	}
	#declare Counter = 0;
	#while (Counter < 355)
		object { Ray rotate Counter*z}
		#declare Counter = Counter + 36;
	#end
	pigment
	{
		color Yellow
	}
	finish 
	{
		phong 1 phong_size 100
		ambient .15
		diffuse .7
	}
}

#declare Row = union
{
	#declare i = -4;
	#while (i < 4.5 )
		object { Flower translate <i, -4, 0>}
		#declare i = i+2;
	#end
}

#declare Flowers = union
{
	#declare j = 0;
	#while (j < 8.5)
		object { Row translate <0, 0, j>}
		#declare j = j+2;
	#end
}

#declare Wood = difference
{
	prism
	{
		linear_sweep
		linear_spline
		0, 0.1, 6,
		<-0.4, 0>, <0.4, 0>, <0.4, 1.7>, <0, 2>, <-0.4, 1.7>, <-0.4, 0>
	}
	cylinder
	{
		<0, -0.1, 1.6>
		<0, 0.2, 1.6>
		0.15
	}
	cylinder
	{
		<0, -0.1, 0.8>
		<0, 0.2, 0.8>
		0.2
	}
	rotate -90*x
}

#declare Wall = union
{
	#declare CounterW = -4.5;
	#while (CounterW < 4.6)
		object { Wood translate <CounterW, 0, -1> }
		#declare CounterW = CounterW + 1;
	#end
	box
	{
		<-5, 0.3, -1>
		<5, 0.5, -0.9>
	}
	box
	{
		<-5, 1.2, -1>
		<5, 1.4, -0.9>
	}
	pigment
	{
		color Brown
	}
	finish 
	{
		phong 1 phong_size 100
		ambient .15
		diffuse .7
	}
}

#declare Watering = merge
{
	difference
	{
		cone
		{
			<0, 0, 0>, 1.5
			<0, 2, 0>, 1
		}
		cone
		{
			<0, 0.05, 0>, 1.45
			<0, 1.95, 0>, 0.95
		}
		difference
		{
			sphere
			{
				<0, 1.975, 0>
				0.95
			}
			sphere
			{
				<-1.7, 1.975, 0>
				2
			}
		}
		scale <1, 1, 0.7>
	}
	difference
	{
		cone
		{
			<-1.2, 0.5, 0>, 0.2
			<-2.2, 2, 0>, 0.08
		}
		sphere
		{
			<-2.2, 2, 0>
			0.06
		}
	}
	torus
	{
		1, 0.1
		rotate x*-90
		translate <0.7, 1.7, 0>
	}
	pigment
	{
		color NeonPink
	}
	finish 
	{
		phong 1 phong_size 100
		ambient .15
		diffuse .7
	}
	normal
	{
		bump_map
		{
			gif "watering.gif"
			once
			bump_size 1
		}
		translate <-0.5, 0.5, 0>
	}
}

#declare Sign = union
{
	box
	{
		<-0.7, 1, -0.15>
		<0.7, 2, -0.1>
		pigment
		{
			image_map
			{
				gif "flower.gif"
				once
			}
			translate <-0.5, 1, 0>
		}
		finish 
		{
			phong 1 phong_size 100
			ambient .4
			diffuse .7
		}
	}
	cylinder
	{
		<0, 0, 0>
		<0, 2.1, 0>
		0.1
		pigment
		{
			color Brown
		}
		finish 
		{
			phong 1 phong_size 100
			ambient .15
			diffuse .7
		}
	}
} 

camera
{
	location <0, 0, -11>
	look_at <0, -1, 0>
}

plane
{
	y, -4
	no_shadow
	pigment
	{
		color Green
	}
}

plane
{
	y, 40
	no_shadow
	pigment
	{
		color Blue
	}
}
      
object { Sun rotate <-20, -30, 0> translate <-13, 5, 20> no_shadow}
object { Wall translate y*-4}
object { Wall rotate -90*y translate <4, -4, 4>}
object { Wall rotate 90*y translate <-4, -4, 4>}
object { Wall rotate 180*y translate <0, -4, 8>}
object { Flowers } 
object { Watering scale 0.8 rotate y*20 translate <3, -4, -3>}
object { Sign translate <-3, -4, -2> rotate y*-10}
object { Cloud scale 1.2 translate <6, 7, 20> no_shadow}


light_source
{
	<-6, 10, 14>
	color White
}  

light_source
{
	<0, 5, -11>
	color White
	shadowless
}

light_source
{
	<0, 0, 0>
	color 0.4
	shadowless
}    