// ===========================================================================
//
// IRTC 'Gardens' - add_sky.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file creates a whispy cloudy sky. It is based on the clounds created
// by Jaime Vives Piqueres in his Canyon entry of the 'Landmarks' IRTC round.
// The trace_sky flag defines what is defined for the scene. Valid values are:
//
// Value   Effect
// ------ -------
//     0 - nothing
//     1 - only sky sphere
//     2 - few cloud layers
//     3 - maximum cloud layers
//
// ===========================================================================

#if (trace_sky > 0)
	sky_sphere
	{
		pigment
		{
			sky_colour
		}
	}

	#if (trace_sky > 1)
		#if (trace_sky = 2)
			#declare num_planes = 4;
		#else
			#declare num_planes = 20;
		#end

		//
		// Place a third level of clouds for a final 'whispy' set
		// of clouds.
		//

		#declare clouds_height = 15000;
		#declare plane_dist = 40;
		#declare textu_dist = 40;
		#declare cnt_planes = 1;

		union
		{
			#while (cnt_planes <= num_planes)
				#declare p = White*1.2;
				#declare p1 = p*(1-(cnt_planes/num_planes))+White*(cnt_planes/num_planes);
				#declare p2 = p*.9*(1-(cnt_planes/num_planes))+White*.9*(cnt_planes/num_planes);

				plane
				{
					y, 0
					texture
					{
						pigment
						{
							ripples
							octaves 9
							lambda 3
							turbulence 4
							color_map
							{
								[0.0 Clear]
								[0.4 Clear]
								[0.7 p1 filter 0.8+0.1*(cnt_planes/num_planes)]
								[1.0 p2 filter 0.8+0.1*(cnt_planes/num_planes)]
							}
							scale 100000
						}
						finish
						{
							ambient sunlight_colour
						}
						translate (clouds_height+textu_dist*cnt_planes)*y
					}
					no_shadow
					translate (clouds_height+plane_dist*cnt_planes)*y
				}
				#declare cnt_planes = cnt_planes+1;
			#end
			rotate y*45
		}
	#end
#end

