// ===========================================================================
//
// IRTC 'Gardens' - add_soil.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// Add a layer of soild to the scene. This will be almost completely covered
// by other objects, notably the grass. The trace_soil flag defines what is
// added to the scene. Valid values are:
//
// Value   Effect
// ------ -------
//     0 - No soil
//     1 - Only use a simple plane
//     2 - Use a base plane followed by a large HF object
//
// ===========================================================================

#include "soil.inc"

//
// Check if we need to add anything.
//

#if (trace_soil > 0)
	#if (trace_soil = 1)
		//
		// We only need a place for the soil.
		//

		plane
		{
			y, hf_y_scale
			texture
			{
				pigment
				{
					colour DarkBrown
				}
			}
		}
	#else
		//
		// We need a lower plane for a base and the soil heightfield object.
		//

		plane
		{
			y, 0
			texture
			{
				pigment
				{
					colour DarkBrown
				}
			}
		}

		//
		// Put the soil heightfield.
		//

		object
		{
			soil_patch
		}
	#end
#end

