// ===========================================================================
//
// IRTC 'Gardens' - blossom.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file defines a blossom leaf. The actual leaf is a bicubic patch
// originally created by Glenn McCarter for his 'The Drama of Cinema' entry to
// the IRTC. The actual creation of the object is controlled by the
// trace_blossom flag. Valid values and effects for the flag are:
//
// Value   Effect
// ------ -------
//     0 - No blossom is created
//     1 - A blossom object is defined
//
// ===========================================================================

#if (trace_blossom > 0)
	#declare blossom_random = seed (100);

	#declare PetalLarge1 = union
	{
		object
		{
			bicubic_patch
			{
				type 1
				flatness 0.0100
				u_steps 3
				v_steps 3,
				<0.116352, -0.690505, -0.478589>,
				<0.173449, -0.932996, -0.397877>,
				<1.127697, -1.435896, -0.462845>,
				<2.388780, -1.585916, -0.396720>,
				<-0.086712, -0.509529, 0.195555>,
				<0.204952, -0.775144, -0.563270>,
				<1.091498, -1.276566, -0.728683>,
				<2.347019, -1.223007, -0.673416>,
				<-0.017488, -0.145226, -0.042415>,
				<0.204952, -0.347644, -0.937223>,
				<1.091498, -0.664237, -1.117720>,
				<2.370680, -0.745657, -1.054911>,
				<-0.026574, 0.164050, -0.042415>,
				<0.216562, 0.085499, -0.937223>,
				<1.091498, 0.155722, -1.117720>,
				<2.370680, 0.114352, -1.061782>
			}
		}
		object
		{
			bicubic_patch
			{
				type 1
				flatness 0.0100
				u_steps 3
				v_steps 3,
				<-0.026574, 0.164050, -0.042415>,
				<0.216562, 0.085499, -0.937223>,
				<1.091498, 0.155722, -1.117720>,
				<2.370680, 0.114352, -1.061782>,
				<-0.035659, 0.473325, -0.042415>,
				<0.228171, 0.518641, -0.937223>,
				<1.091498, 0.975680, -1.117720>,
				<2.370680, 0.974362, -1.054911>,
				<-0.014074, 0.728767, 0.093568>,
				<0.228171, 0.946141, -0.801240>,
				<1.091498, 1.588010, -0.976252>,
				<2.370680, 1.540054, -0.816675>,
				<0.046580, 0.879452, 0.006997>,
				<0.228171, 1.264923, -0.461282>,
				<1.091498, 1.796940, -0.343004>,
				<2.370680, 1.745878, -0.268125>
			}
		}
		object
		{
			bicubic_patch
			{
				type 1
				flatness 0.0100
				u_steps 3
				v_steps 3,
				<2.388780, -1.585916, -0.396720>,
				<3.649863, -1.735936, -0.330594>,
				<3.882563, -1.608819, 0.020126>,
				<4.178862, -1.373171, -0.842608>,
				<2.347019, -1.223007, -0.673416>,
				<3.602539, -1.169447, -0.618149>,
				<3.915936, -1.433925, -0.257582>,
				<4.374617, -0.933158, -0.959074>,
				<2.370680, -0.745657, -1.054911>,
				<3.649863, -0.827078, -0.992102>,
				<3.915936, -0.761777, -0.631536>,
				<4.855386, -0.418100, -1.365591>,
				<2.370680, 0.114352, -1.061782>,
				<3.649863, 0.072983, -0.992102>,
				<3.915936, 0.138284, -0.631536>,
				<4.850227, 0.163726, -1.123296>
			}
		}
		object
		{
			bicubic_patch
			{
				type 1
				flatness 0.0100
				u_steps 3
				v_steps 3,
				<2.370680, 0.114352, -1.061782>,
				<3.649863, 0.072983, -0.992102>,
				<3.915936, 0.138284, -0.631536>,
				<4.850227, 0.163726, -1.123296>,
				<2.370680, 0.974362, -1.054911>,
				<3.649863, 0.973043, -0.992102>,
				<3.915936, 1.038344, -0.631536>,
				<4.845068, 0.745553, -0.881001>,
				<2.370680, 1.540054, -0.816675>,
				<3.649863, 1.492098, -0.657098>,
				<3.915936, 1.679874, -0.878286>,
				<4.374617, 1.578253, -1.229608>,
				<2.370680, 1.745878, -0.268125>,
				<3.649863, 1.694816, -0.193247>,
				<3.882563, 1.832217, -0.492920>,
				<3.913821, 1.738315, -0.797358>
			}
		}
	}

	#macro put_blossom (blossom_location)
		object
		{
			PetalLarge1
			pigment
			{
				gradient x
				colour_map
				{
					[0.0 colour White]
					[0.1 colour White]
					[0.75 colour Pink]
					[1.0 colour Red]
				}
				scale 5
			}
			scale 1/1.5
			rotate y*(360*rand(blossom_random))
			translate blossom_location
		}
	#end
#end

