// ===========================================================================
//
// cat.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file create the cat object. The cat is originally a Poser animal
// figure which is exported as a .3ds file the converted to a mesh2 object by
// Thomas Baier's 3DS2Pov file converter. The material file produced from the
// converter is then edited to reference a modified Poser texture file.
//
// The trace_cat flag is used to control if the cat object is defined. The
// following values are valid:
//
// Value   Effect
// ------ -------
//     0 - No Object created
//     1 - Object defined but using colours
//     2 - Object defined but uses uv mapping
//
// ===========================================================================

#if (trace_cat > 0)
	//
	// Include the colours for the cat.
	//

	#if (trace_cat > 1)
		#include "standard_cat_material.inc"
	#else
		#include "cat_material.inc"
	#end

	//
	// Include the cat mesh object.
	//

	#include "cat_object.inc"
#end

