// ===========================================================================
//
// IRTC 'Gardens' - garden.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file defines some colours, textures and constants used in the scene.
//
// ===========================================================================

// ===========================================================================
//
// COLOURS AND TEXTURES
//
// ===========================================================================

#include "colors.inc"

#declare sunlight_colour = rgb <240 / 255, 247 / 255, 253 / 255>;
#declare daylight_colour = rgb <230 / 255, 241 / 255, 247 / 255>;

#declare sky_colour = SkyBlue * 0.8;

//
// Modified versions of Stones.inc textures
//

#declare T_Grnt0a = texture
{
	pigment
	{
		granite
		turbulence 0.6
		color_map
		{
			[0.000, 0.153 color rgbf <0.729, 0.502, 0.451, 0.306> color rgbf <0.769, 0.686, 0.592, 0.792>]
			[0.153, 0.398 color rgbf <0.769, 0.686, 0.592, 0.792> color rgbf <0.843, 0.753, 0.718, 0.396>]
			[0.398, 0.559 color rgbf <0.843, 0.753, 0.718, 0.396> color rgbf <0.780, 0.667, 0.561, 0.976>]
			[0.559, 0.729 color rgbf <0.780, 0.667, 0.561, 0.976> color rgbf <0.741, 0.659, 0.576, 0.820>]
			[0.729, 1.001 color rgbf <0.741, 0.659, 0.576, 0.820> color rgbf <0.729, 0.502, 0.451, 0.306>]
		}
	}
}

#declare T_Grnt9a = texture
{
	pigment
	{
		granite
		turbulence 0.6
		color_map
		{
			[0.000, 0.216 color rgbf <0.812, 0.812, 0.812, 0.835> color rgbf <0.745, 0.843, 0.835, 0.847>]
			[0.216, 0.241 color rgbf <0.745, 0.843, 0.835, 0.847> color rgbf <0.404, 0.337, 0.337, 0.463>]
			[0.241, 0.267 color rgbf <0.404, 0.337, 0.337, 0.463> color rgbf <0.773, 0.729, 0.745, 0.622>]
			[0.267, 0.759 color rgbf <0.773, 0.729, 0.745, 0.622> color rgbf <0.914, 0.843, 0.725, 0.651>]
			[0.759, 0.784 color rgbf <0.914, 0.843, 0.725, 0.651> color rgbf <0.153, 0.133, 0.208, 0.437>]
			[0.784, 0.810 color rgbf <0.153, 0.133, 0.208, 0.437> color rgbf <0.812, 0.812, 0.812, 0.835>]
			[0.810, 1.001 color rgbf <0.812, 0.812, 0.812, 0.835> color rgbf <0.812, 0.812, 0.812, 0.835>]
		}
	}
}

#declare T_Stone8 = texture
{
	pigment
	{
		color White
	}
	finish
	{
		ambient 0.6
		crand 0.06
		diffuse 0.7
	}
}
texture
{
	T_Grnt0a
	scale <0.02, 0.02, 0.02>
	rotate <0, 0, -30>
}
texture
{
	T_Grnt9a
	scale <0.02, 0.02, 0.02>
	rotate <0, 0, 40>
	finish
	{
		phong 1.0
		ambient 0.2
		diffuse 0.5
		phong_size 90
	}
}

#declare Headstone_texture = texture
{
	T_Stone8
	scale 100
}

//
// The soil texture
//

#declare soil_texture = texture
{
	pigment
	{
		crackle
		octaves 9
		lambda 3
		turbulence 4
		colour_map
		{
			[0.00 rgb <54, 31, 13> / 255]
			[0.04 rgb <83, 53, 25> / 255]
			[0.08 rgb <95, 67, 38> / 255]
			[0.12 rgb <104, 76, 47> / 255]
			[0.16 rgb <105, 78, 49> / 255]
			[0.24 rgb <108, 80, 51> / 255]
			[0.28 rgb <110, 82, 54> / 255]
			[0.36 rgb <113, 85, 57> / 255]
			[0.48 rgb <118, 94, 60> / 255]
			[0.56 rgb <120, 96, 62> / 255]
			[0.60 rgb <119, 90, 64> / 255]
			[0.64 rgb <124, 95, 66> / 255]
			[0.72 rgb <123, 98, 66> / 255]
			[0.80 rgb <128, 94, 65> / 255]
			[0.84 rgb <133, 108, 76> / 255]
			[0.96 rgb <145, 118, 88> / 255]
			[1.00 rgb <113, 85, 57> / 255]
		}
		scale 2.5
	}
}

// ===========================================================================
//
// CONSTANTS
//
// ===========================================================================

//
// Heightfield values.
//

#declare hf_x_scale = 50;
#declare hf_y_scale = 4;
#declare hf_z_scale = 50;

//
// Values used in creation and placement of grass patches.
//

#declare grass_patch_size = 25;

