// ===========================================================================
//
// IRTC 'Gardens' - garden.pov
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file controls the placement of all objects in the final image. All
// objects are defined and added in their own file, and their definition and
// placement is controlled by a flag. Refer to the appropriate
// add_<object>.inc file to see the effects of the flags.
//
// ===========================================================================

//
// Include standard POV-Ray headers.
//

#include "colors.inc"

//
// Include scene constants.
//

#include "garden.inc"

//
// Fix the global settings.
//

global_settings
{
	assumed_gamma 1.0
	ambient_light daylight_colour
	max_trace_level 32
}

//
// Specify if we should use mesh2 objects...
//

#declare use_mesh2 = 1;

//
// Set the general background colour. This shouldn't actually be seen because
// of the sky and other objects.
//

background
{
	color Black
}

//
// Specify the camera position.
//

camera
{
	location <-240,200,-288>
	look_at <0,50,0>
	angle 25
}

//
// Specify the light sources.
//

#declare do_area = 1;

#declare sun = light_source
{
	<0, 0, -10000>
	colour sunlight_colour * 1.15

	#if (do_area > 0)
		area_light
		<92, 0, 0> <0, 92, 0>
		5, 5
		adaptive 0
		jitter
	#end
}

object
{
	sun
	rotate x*35 // rotate x*45
	rotate y*-10// rotate y*-14
}

light_source
{
	<-240,200,-288>
	colour sunlight_colour / 5
	shadowless
}

//
// Add the sky...
//

#declare trace_sky = 3; // 0 -> 3
#include "add_sky.inc"

//
// Add the ground...
//

#declare trace_soil = 2; // 0 -> 2
#include "add_soil.inc"

//
// Add the sundial...
//

#declare trace_sundial = 1; // 0 -> 1
#include "add_sundial.inc"

//
// Add gravel around the sundial...
//

#declare trace_gravel = 1; // 0 -> 1
#include "add_gravel.inc"

//
// Add the grass...
//

#declare trace_grass = 2; // 0 -> 2
#include "add_grass.inc"

//
// Add the brickwork...
//

#declare trace_bricks = 1; // 0 -> 1
#include "add_bricks.inc"

//
// Add some plant pots...
//

#declare trace_plant_pots = 1; // 0 -> 1
#include "add_plant_pot.inc"

//
// Add some blossom around...
//

#declare trace_blossom = 1; // 0 -> 1
#include "add_blossom.inc"

//
// Put a garden rake in the scene...
//

#declare trace_rake = 1; // 0 -> 1
#include "add_rake.inc"

//
// Add a prowling cat...
//

#declare trace_cat = 2; // 0 -> 2
#include "add_cat.inc"

//
// Add a butterfly for the cat to look at...
//

#declare trace_fly = 1; // 0 -> 1
#include "add_butterfly.inc"

