// ===========================================================================
//
// IRTC 'Gardens' - rake.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file creates a rake object. The trace_rake flag controls if this
// object is created. Valid values for this flag are:
//
// Value   Effect
// ------ -------
//     0 - Don't define rake
//     1 - Define rake
//
// ===========================================================================

#if (trace_rake > 0)

	#include "finish.inc"
	#include "woods.inc"

	#declare rake_rand = seed (0);

	#declare prong = union
	{
		cylinder
		{
			<0, 0, 0>, <-29, 0, 0>, 0.15
		}
		cylinder
		{
			<-30, 1, 0>, <-30, 5, 0>, 0.15
		}
		sphere
		{
			<-30, 5, 0>, 0.15
		}
		intersection
		{
			torus
			{
				1, 0.15
			}
			box
			{
				<0, -10, 0>, <10, 10, 10>
			}
			rotate x*90
			rotate y*180
			translate <-29, 1, 0>
		}
	}

	#declare prong_group = union
	{
		#declare prong_count = 0;

		#while (prong_count < 11)
			object
			{
				prong
				rotate z * (-0.5 + rand (rake_rand))
				rotate y * ((prong_count * 4) + 2)
			}
			object
			{
				prong
				rotate z * (-0.5 + rand (rake_rand))
				rotate -y * ((prong_count * 4) + 2)
			}

			#declare prong_count = prong_count + 1;
		#end
	}

	#declare prong_hold_1 = difference
	{
		union
		{
			difference
			{
				union
				{
					cylinder
					{
						<0, -1, 0>, <0, 1, 0>, 5
					}
					torus
					{
						5,  1
					}
				}
				box
				{
					<0, -10, 0>, <-10, 10, 10>
					rotate y*42
				}
				box
				{
					<0, -10, 0>, <-10, 10, -10>
					rotate y*-42
				}
			}
			sphere
			{
				<0, 0, 0>, 1
				translate <-5, 0, 0>
				rotate y*42
			}
			sphere
			{
				<0, 0, 0>, 1
				translate <-5, 0, 0>
				rotate y*-42
			}
			cylinder
			{
				<0, 0, 0>, <-5, 0, 0>, 1
				rotate y*42
			}
			cylinder
			{
				<0, 0, 0>, <-5, 0, 0>, 1
				rotate y*-42
			}
		}
		box
		{
			<0, -10, -10>, <10, 10, 10>
		}
	}

	#declare stick_bit = union
	{
		cylinder
		{
			<1, 0, 0>, <121, 0, 0>, 1.25
		}
		cone
		{
			<0, 0, 0>, 1
			<1, 0, 0>, 1.25
		}
	}

	#declare grip_bit_1 = torus
	{
		1.4, .5
		scale <1, 2, 1>
		rotate z*90
	}

	#declare grip = union
	{
		cylinder
		{
			<120.9, 0, 0>, <135, 0, 0>, 1.4
		}
		object
		{
			grip_bit_1
			translate <123, 0, 0>
		}
		object
		{
			grip_bit_1
			translate <125, 0, 0>
		}
		object
		{
			grip_bit_1
			translate <127, 0, 0>
		}
		object
		{
			grip_bit_1
			translate <129, 0, 0>
		}
		object
		{
			grip_bit_1
			translate <131, 0, 0>
		}
		object
		{
			grip_bit_1
			translate <133, 0, 0>
		}
		sphere
		{
			<0, 0, 0>, 1.4
			scale <0.5, 1, 1>
			translate <135, 0, 0>
		}
	}

	#declare rake = union
	{
		object
		{
			prong_group
			texture
			{
				pigment
				{
					colour rgb <0.1, 0.1, 0.1>
				}
				normal
				{
					crackle
					scale 0.5
				}
				finish
				{
					Phong_Shiny
				}
			}
		}

		object
		{
			prong_hold_1
			texture
			{
				pigment
				{
					colour rgb <0.1, 0.1, 0.1>
				}
				normal
				{
					crackle
					scale 0.5
				}
				finish
				{
					Phong_Shiny
				}
			}
		}

		object
		{
			stick_bit
			texture
			{
				T_Wood35
				finish
				{
					specular 0.15
					roughness 0.025
					ambient 0.25
				}
				rotate <0, 90, 0>
				scale <8, 4, 4>
				translate <-3, 0, 0>
			}
		}

		object
		{
			grip
			texture
			{
				pigment
				{
					colour Black
				}
				finish
				{
					Dull
				}
			}
		}
	}
#end

