// ===========================================================================
//
// IRTC 'Gardens' - soil.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file defines a heightfield object to be the base soil for the image.
// The construction of the heightfield is controlled by the trace_soil flag.
// Valid values for this flag are:
//
// Value   Effect
// ------ -------
//     0 - Do nothing
//     1 - Still do nothing
//     2 - Create the heightfield object
//
// ===========================================================================

#if (trace_soil > 1)
	#declare soil_dent = height_field
	{
		gif "soil_dent.gif"
		smooth
		translate <-0.5, 0, -0.5>
		scale <hf_x_scale, hf_y_scale, hf_z_scale>
	}

	#declare soil_base = height_field
	{
		gif "soil_base.gif"
		smooth
		translate <-0.5, 0, -0.5>
		scale <hf_x_scale, hf_y_scale, hf_z_scale>
	}

	#declare soil_mirror = height_field
	{
		gif "soil_mirror.gif"
		smooth
		translate <-0.5, 0, -0.5>
		scale <hf_x_scale, hf_y_scale, hf_z_scale>
	}

	#declare soil_flip = height_field
	{
		gif "soil_flip.gif"
		smooth
		translate <-0.5, 0, -0.5>
		scale <hf_x_scale, hf_y_scale, hf_z_scale>
	}

	#declare soil_mirror_flip = height_field
	{
		gif "soil_mirror_flip.gif"
		smooth
		translate <-0.5, 0, -0.5>
		scale <hf_x_scale, hf_y_scale, hf_z_scale>
	}

	#declare soil_patch = union
	{
		#declare cX = -2;
		#while (cX<10)
			#declare cZ = -2;
			#while (cZ<11)
				#if ((cX = 0) & (cZ = 0))
					object
					{
						soil_dent
						translate <50*cX,0,50*cZ>
					}
				#else
					#local xd = mod (abs (cX), 2);
					#local zd = mod (abs (cZ), 2);

					#if (xd = 1)
						#if (zd = 1)
							object
							{
								soil_mirror_flip
								translate <50*cX,0,50*cZ>
							}
						#else
							object
							{
								soil_mirror
								translate <50*cX,0,50*cZ>
							}
						#end
					#else
						#if (zd = 1)
							object
							{
								soil_flip
								translate <50*cX,0,50*cZ>
							}
						#else
							object
							{
								soil_base
								translate <50*cX,0,50*cZ>
							}
						#end
					#end
				#end
				#declare cZ = cZ+1;
			#end
			#declare cX = cX+1;
		#end

		texture
		{
			soil_texture
		}
	}
#end

